require.config({"config": {
        "jsbuild":{"magnifier/magnify.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'magnifier/magnifier'\n], function ($, _) {\n    'use strict';\n\n    return function (config, element) {\n\n        var isTouchEnabled = 'ontouchstart' in document.documentElement,\n            gallerySelector = '[data-gallery-role=\"gallery\"]',\n            magnifierSelector = '[data-gallery-role=\"magnifier\"]',\n            magnifierZoomSelector = '[data-gallery-role=\"magnifier-zoom\"]',\n            zoomInButtonSelector = '[data-gallery-role=\"fotorama__zoom-in\"]',\n            zoomOutButtonSelector = '[data-gallery-role=\"fotorama__zoom-out\"]',\n            fullscreenImageSelector = '[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"] .fotorama__img--full',\n            imageDraggableClass = 'fotorama__img--draggable',\n            imageZoommable = 'fotorama__img--zoommable',\n            zoomInLoaded = 'zoom-in-loaded',\n            zoomOutLoaded = 'zoom-out-loaded',\n            zoomInDisabled = 'fotorama__zoom-in--disabled',\n            zoomOutDisabled = 'fotorama__zoom-out--disabled',\n            keyboardNavigation,\n            videoContainerClass = 'fotorama-video-container',\n            hideMagnifier,\n            dragFlag,\n            endX,\n            transitionEnabled,\n            transitionActive = false,\n            tapFlag = 0,\n            allowZoomOut = false,\n            allowZoomIn = true;\n\n        transitionEnabled = document.documentElement.style.transition !== undefined ||\n            document.documentElement.style.WebkitTransition !== undefined ||\n            document.documentElement.style.MozTransition !== undefined ||\n            document.documentElement.style.MsTransition !== undefined ||\n            document.documentElement.style.OTransition !== undefined;\n\n        /**\n         * Return width and height of original image\n         * @param img original image node\n         * @returns {{rw: number, rh: number}}\n         */\n        function getImageSize(img) {\n            return {\n                rw: img.naturalWidth,\n                rh: img.naturalHeight\n            };\n        }\n\n        /**\n         * Sets min-height and min-width for image to avoid transition bug\n         * @param $image - fullscreen image\n         */\n        function calculateMinSize($image) {\n\n            var minHeight,\n                minWidth,\n                height = $image.height(),\n                width = $image.width(),\n                parentHeight = $image.parent().height(),\n                parentWidth = $image.parent().width();\n\n            if (width > parentWidth || height > parentHeight) {\n\n                if (width / height < parentWidth / parentHeight) {\n                    minHeight = parentHeight;\n                    minWidth = width * (parentHeight / height);\n                } else {\n                    minWidth = parentWidth;\n                    minHeight = height * parentWidth / width;\n                }\n                $image.css({\n                    'min-width': minWidth,\n                    'min-height': minHeight\n                });\n            }\n        }\n\n        function toggleZoomable($image, flag) {\n            if (flag) {\n                $image.css({\n                    'min-width': $image.width(),\n                    'min-height': $image.height(),\n                    'width': $image.width(),\n                    'height': $image.height()\n                }).addClass(imageZoommable);\n            } else {\n                $image.css({\n                    width: '',\n                    height: '',\n                    top: '',\n                    left: '',\n                    right: '',\n                    bottom: ''\n                }).removeClass(imageZoommable);\n                calculateMinSize($image);\n            }\n        }\n\n        function resetVars($image) {\n            allowZoomIn = true;\n            allowZoomOut = dragFlag = transitionActive = false;\n            $image.hasClass(imageDraggableClass) && $image.removeClass(imageDraggableClass);\n            toggleZoomable($image, false);\n        }\n\n        /**\n         * Set state for zoom controls.\n         * If state is true, zoom controls will be visible.\n         * IF state is false, zoom controls will be hidden.\n         * @param isHide\n         */\n        function hideZoomControls(isHide) {\n            if (isHide) {\n                $(zoomInButtonSelector).addClass(zoomInDisabled);\n                $(zoomOutButtonSelector).addClass(zoomOutDisabled);\n            } else {\n                $(zoomInButtonSelector).removeClass(zoomInDisabled);\n                $(zoomOutButtonSelector).removeClass(zoomOutDisabled);\n            }\n        }\n\n        /**\n         * Asynchronus control visibility of zoom buttons.\n         * If image bigger than her wrapper. Zoom controls must visible.\n         * @param path - image source path\n         * @param $image\n         */\n        function asyncToggleZoomButtons(path, $image) {\n            var img = new Image();\n\n            img.onload = function () {\n                this.height > $image.parent().height() || this.width > $image.parent().width() ?\n                    hideZoomControls(false) : hideZoomControls(true);\n            };\n            img.src = path;\n        }\n\n        /**\n         * Control visibility of zoom buttons.\n         * Zoom controls must be invisible for video content and touch devices.\n         * On touch devices active pinchIn/pinchOut.\n         * @param $image\n         * @param isTouchScreen - true for touch devices\n         * @param isVideoActiveFrame - true for active video frame\n         */\n        function toggleZoomButtons($image, isTouchScreen, isVideoActiveFrame) {\n            var path = $image.attr('src');\n\n            if (path && !isTouchScreen && !isVideoActiveFrame) {\n                asyncToggleZoomButtons(path, $image);\n            } else {\n                hideZoomControls(true);\n            }\n        }\n\n        /**\n         * Handle resize event in fullscreen.\n         * @param $image - Fullscreen image.\n         * @param e - Event.\n         */\n        function resizeHandler(e, $image) {\n            var imageSize,\n                parentWidth,\n                parentHeight,\n                isImageSmall,\n                isImageFit;\n\n            if (!e.data.$image || !e.data.$image.length)\n                return;\n\n            imageSize = getImageSize($(fullscreenImageSelector)[0]);\n            parentWidth = e.data.$image.parent().width();\n            parentHeight = e.data.$image.parent().height();\n            isImageSmall = parentWidth >= imageSize.rw && parentHeight >= imageSize.rh;\n            isImageFit = parentWidth > e.data.$image.width() && parentHeight > e.data.$image.height();\n\n            toggleZoomButtons(e.data.$image, isTouchEnabled, checkForVideo(e.data.fotorama.activeFrame.$stageFrame));\n            calculateMinSize(e.data.$image);\n\n            if (e.data.$image.hasClass(imageZoommable) && !allowZoomOut || isImageSmall || isImageFit) {\n                resetVars(e.data.$image);\n            }\n\n            if (!isImageSmall) {\n                toggleStandartNavigation();\n            }\n        }\n\n        function getTopValue($image, topProp, step, height, containerHeight) {\n            var top;\n\n            if (parseInt($image.css('marginTop')) || parseInt($image.css('marginLeft'))) {\n                top = dragFlag ? topProp - step / 4 : 0;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > height - containerHeight ? height - containerHeight : top;\n            } else {\n                top = topProp + step / 2;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > 0 ? 0 : top;\n\n                if (!dragFlag && step < 0) {\n                    top = top < (containerHeight - height) / 2 ? (containerHeight - height) / 2 : top;\n                }\n            }\n\n            return top;\n        }\n\n        function getLeftValue(leftProp, step, width, containerWidth) {\n            var left;\n\n            left = leftProp + step / 2;\n            left = left < containerWidth - width ? containerWidth - width : left;\n            left = left > 0 ? 0 : left;\n\n            if (!dragFlag && step < 0) {\n                left = left < (containerWidth - width) / 2 ? (containerWidth - width) / 2 : left;\n            }\n\n            return left;\n        }\n\n        function checkFullscreenImagePosition($image, dimentions, widthStep, heightStep) {\n            var $imageContainer,\n                containerWidth,\n                containerHeight,\n                settings,\n                top,\n                left,\n                right,\n                bottom,\n                ratio;\n\n            if ($(gallerySelector).data('fotorama').fullScreen) {\n                transitionActive = true;\n                $imageContainer = $image.parent();\n                containerWidth = $imageContainer.width();\n                containerHeight = $imageContainer.height();\n                top = $image.position().top;\n                left = $image.position().left;\n                ratio = $image.width() / $image.height();\n                dimentions.height = isNaN(dimentions.height) ? dimentions.width / ratio : dimentions.height;\n                dimentions.width = isNaN(dimentions.width) ? dimentions.height * ratio : dimentions.width;\n\n                top = dimentions.height >= containerHeight ?\n                    getTopValue($image, top, heightStep, dimentions.height, containerHeight) : 0;\n\n                left = dimentions.width >= containerWidth ?\n                    getLeftValue(left, widthStep, dimentions.width, containerWidth) : 0;\n\n                right = dragFlag && left < (containerWidth - dimentions.width) / 2 ? 0 : left;\n                bottom = dragFlag ? 0 : top;\n\n                settings = $.extend(dimentions, {\n                    top: top,\n                    left: left,\n                    right: right\n                });\n\n                $image.css(settings);\n            }\n        }\n\n        /**\n         * Toggles fotorama's keyboard and mouse/touch navigation.\n         */\n        function toggleStandartNavigation() {\n            var $selectable =\n                    $('a[href], area[href], input, select, textarea, button, iframe, object, embed, *[tabindex], *[contenteditable]')\n                    .not('[tabindex=-1], [disabled], :hidden'),\n                fotorama = $(gallerySelector).data('fotorama'),\n                $focus = $(':focus'),\n                index;\n\n            if (fotorama.fullScreen) {\n\n                $selectable.each(function (number) {\n\n                    if ($(this).is($focus)) {\n                        index = number;\n                    }\n                });\n\n                fotorama.setOptions({\n                    swipe: !allowZoomOut,\n                    keyboard: !allowZoomOut\n                });\n\n                if (_.isNumber(index)) {\n                    $selectable.eq(index).trigger('focus');\n                }\n            }\n        }\n\n        function zoomIn(e, xStep, yStep) {\n            var $image,\n                imgOriginalSize,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                widthResult,\n                heightResult,\n                ratio,\n                dimentions = {};\n\n            if (allowZoomIn && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomInButtonSelector).hasClass(zoomInDisabled))) {\n                $image = $(fullscreenImageSelector);\n                imgOriginalSize = getImageSize($image[0]);\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n                allowZoomOut = true;\n                toggleStandartNavigation();\n\n                if (!$image.hasClass(imageZoommable)) {\n                    toggleZoomable($image, true);\n                }\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth + zoomWidthStep;\n\n                    if (widthResult >= imgOriginalSize.rw) {\n                        widthResult = imgOriginalSize.rw;\n                        zoomWidthStep = xStep || widthResult - imageWidth;\n                        allowZoomIn = false;\n                    }\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || heightResult - imageHeight;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight + zoomHeightStep;\n\n                    if (heightResult >= imgOriginalSize.rh) {\n                        heightResult = imgOriginalSize.rh;\n                        zoomHeightStep = yStep || heightResult - imageHeight;\n                        allowZoomIn = false;\n                    }\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || widthResult - imageWidth;\n                }\n\n                if (imageWidth >= imageHeight && imageWidth !== imgOriginalSize.rw) {\n                    dimentions = $.extend(dimentions, {\n                        width: widthResult,\n                        height: 'auto'\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n\n                } else if (imageWidth < imageHeight && imageHeight !== imgOriginalSize.rh) {\n                    dimentions = $.extend(dimentions, {\n                        width: 'auto',\n                        height: heightResult\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n                }\n            }\n\n            return false;\n        }\n\n        function zoomOut(e, xStep, yStep) {\n            var $image,\n                widthResult,\n                heightResult,\n                dimentions,\n                parentWidth,\n                parentHeight,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                ratio,\n                fitIntoParent;\n\n            if (allowZoomOut && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomOutButtonSelector).hasClass(zoomOutDisabled))) {\n                allowZoomIn = true;\n                $image = $(fullscreenImageSelector);\n                parentWidth = $image.parent().width();\n                parentHeight = $image.parent().height();\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth - zoomWidthStep;\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || imageHeight - heightResult;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight - zoomHeightStep;\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || imageWidth - widthResult;\n                }\n\n                fitIntoParent = function () {\n                    if (ratio > parentWidth / parentHeight) {\n                        widthResult = parentWidth;\n                        zoomWidthStep = imageWidth - widthResult;\n                        heightResult = widthResult / ratio;\n                        zoomHeightStep = imageHeight - heightResult;\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                    } else {\n                        heightResult = parentHeight;\n                        zoomHeightStep = imageHeight - heightResult;\n                        widthResult = heightResult * ratio;\n                        zoomWidthStep = imageWidth - widthResult;\n                        dimentions = {\n                            width: 'auto',\n                            height: heightResult\n                        };\n                    }\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                };\n\n                if (imageWidth >= imageHeight) {\n                    if (widthResult > parentWidth) {\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else if (heightResult > parentHeight) {\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else {\n                        allowZoomOut = dragFlag = false;\n                        toggleStandartNavigation();\n                        fitIntoParent();\n                    }\n                } else if (heightResult > parentHeight) {\n                    dimentions = {\n                        width: 'auto',\n                        height: heightResult\n                    };\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                } else if (widthResult > parentWidth) {\n                    dimentions = {\n                        width: 'auto',\n                        height: heightResult\n                    };\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                } else {\n                    allowZoomOut = dragFlag = false;\n                    toggleStandartNavigation();\n                    fitIntoParent();\n                }\n            }\n\n            return false;\n        }\n\n        /**\n         * Bind event on scroll on active item in fotorama\n         * @param e\n         * @param fotorama - object of fotorama\n         */\n        function mousewheel(e, fotorama, element) {\n            var $fotoramaStage = fotorama.activeFrame.$stageFrame,\n                fotoramaStage = $fotoramaStage.get(0);\n\n            function onWheel(e) {\n                var delta = e.deltaY || e.wheelDelta,\n                    ev = e || window.event;\n\n                if ($(gallerySelector).data('fotorama').fullScreen) {\n\n                    if (e.deltaY) {\n                        if (delta > 0) {\n                            zoomOut(ev);\n                        } else {\n                            zoomIn(ev);\n                        }\n                    } else if (delta > 0) {\n                        zoomIn(ev);\n                    } else {\n                        zoomOut(ev);\n                    }\n\n                    e.preventDefault ? e.preventDefault() : e.returnValue = false;\n                }\n            }\n\n            if (!$fotoramaStage.hasClass('magnify-wheel-loaded')) {\n                if (fotoramaStage && fotoramaStage.addEventListener) {\n                    if ('onwheel' in document) {\n                        fotoramaStage.addEventListener('wheel', onWheel, { passive: false });\n                    } else if ('onmousewheel' in document) {\n                        fotoramaStage.addEventListener('mousewheel', onWheel);\n                    } else {\n                        fotoramaStage.addEventListener('MozMousePixelScroll', onWheel);\n                    }\n                    $fotoramaStage.addClass('magnify-wheel-loaded');\n                }\n            }\n        }\n\n        /**\n         * Method which makes draggable picture. Also work on touch devices.\n         */\n        function magnifierFullscreen(fotorama) {\n            var isDragActive = false,\n                startX,\n                startY,\n                imagePosX,\n                imagePosY,\n                touch,\n                swipeSlide,\n                $gallery = $(gallerySelector),\n                $image = $(fullscreenImageSelector, $gallery),\n                $imageContainer = $('[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"]'),\n                gallery = $gallery.data('fotorama'),\n                pinchDimention;\n\n            swipeSlide = _.throttle(function (direction) {\n                $(gallerySelector).data('fotorama').show(direction);\n            }, 500, {\n                trailing: false\n            });\n\n            /**\n             * Returns top position value for passed jQuery object.\n             *\n             * @param $el\n             * @return {number}\n             */\n            function getTop($el) {\n                return parseInt($el.get(0).style.top);\n            }\n\n            function shiftImage(dx, dy, e) {\n                var top = +imagePosY + dy,\n                    left = +imagePosX + dx,\n                    swipeCondition = $image.width() / 10 + 20;\n\n                dragFlag = true;\n\n                if ($image.offset().left === $imageContainer.offset().left + $imageContainer.width() - $image.width() && e.keyCode === 39 ||\n                    endX - 1 < $imageContainer.offset().left + $imageContainer.width() - $image.width() && dx < 0 &&\n                    _.isNumber(endX) &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    endX = null;\n                    swipeSlide('>');\n\n                    return;\n                }\n\n                if ($image.offset().left === $imageContainer.offset().left && dx !== 0 && e.keyCode === 37 ||\n                    endX === $imageContainer.offset().left && dx > 0 &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    endX = null;\n                    swipeSlide('<');\n\n                    return;\n                }\n\n                if ($image.height() > $imageContainer.height()) {\n                    if ($imageContainer.height() > $image.height() + top) {\n                        $image.css('top', $imageContainer.height() - $image.height());\n                    } else {\n                        top = $image.height() - getTop($image) - $imageContainer.height();\n                        dy = dy < top ? dy : top;\n                        $image.css('top', getTop($image) + dy);\n                    }\n                }\n\n                if ($image.width() > $imageContainer.width()) {\n\n                    if ($imageContainer.offset().left + $imageContainer.width() > left + $image.width()) {\n                        left = $imageContainer.offset().left + $imageContainer.width() - $image.width();\n                    } else {\n                        left = $imageContainer.offset().left < left ? $imageContainer.offset().left : left;\n                    }\n                    $image.offset({\n                        'left': left\n                    });\n                    $image.css('right', '');\n                } else if (Math.abs(dy) < 1 && allowZoomOut &&\n                    !(e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    dx < 0 ? $(gallerySelector).data('fotorama').show('>') : $(gallerySelector).data('fotorama').show('<');\n                }\n\n                if ($image.width() <= $imageContainer.width() && allowZoomOut &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove') &&\n                    Math.abs(dx) > Math.abs(dy) && Math.abs(dx) > swipeCondition) {\n                    dx < 0 ? swipeSlide('>') : swipeSlide('<');\n                }\n            }\n\n            /**\n             * Sets image size to original or fit in parent block\n             * @param e - event object\n             */\n            function dblClickHandler(e) {\n                var imgOriginalSize = getImageSize($image[0]),\n                    proportions;\n\n                if (imgOriginalSize.rh < $image.parent().height() && imgOriginalSize.rw < $image.parent().width()) {\n                    return;\n                }\n\n                proportions = imgOriginalSize.rw / imgOriginalSize.rh;\n\n                if (allowZoomIn) {\n                    zoomIn(e, imgOriginalSize.rw - $image.width(), imgOriginalSize.rh - $image.height());\n                } else if (proportions > $imageContainer.width() / $imageContainer.height()) {\n                    zoomOut(e, imgOriginalSize.rw - $imageContainer.width(), imgOriginalSize.rw / proportions);\n                } else {\n                    zoomOut(e, imgOriginalSize.rw * proportions, imgOriginalSize.rh - $imageContainer.height());\n                }\n            }\n\n            function detectDoubleTap(e) {\n                var now = new Date().getTime(),\n                    timesince = now - tapFlag;\n\n                if (timesince < 400 && timesince > 0) {\n                    transitionActive = false;\n                    tapFlag = 0;\n                    dblClickHandler(e);\n                } else {\n                    tapFlag = new Date().getTime();\n                }\n            }\n\n            if (isTouchEnabled) {\n                $image.off('tap');\n                $image.on('tap', function (e) {\n                    if (e.originalEvent.originalEvent.touches.length === 0) {\n                        detectDoubleTap(e);\n                    }\n                });\n            } else {\n                $image.off('dblclick');\n                $image.on('dblclick', dblClickHandler);\n            }\n\n            if (gallery.fullScreen) {\n                toggleZoomButtons($image, isTouchEnabled, checkForVideo(fotorama.activeFrame.$stageFrame));\n            }\n\n            function getDimention(event) {\n                return Math.sqrt(\n                    (event.touches[0].clientX - event.touches[1].clientX) * (event.touches[0].clientX - event.touches[1].clientX) +\n                    (event.touches[0].clientY - event.touches[1].clientY) * (event.touches[0].clientY - event.touches[1].clientY));\n            }\n\n            $image.off(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown');\n            $image.on(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    pinchDimention = getDimention(e.originalEvent);\n                    isDragActive = false;\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n                } else if (gallery.fullScreen && (!transitionEnabled || !transitionActive)) {\n                    imagePosY = getTop($image);\n                    imagePosX = $image.offset().left;\n\n                    if (isTouchEnabled) {\n                        touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                        e.clientX = touch.pageX;\n                        e.clientY = touch.pageY;\n                    }\n                    startX = e.clientX || e.originalEvent.clientX;\n                    startY = e.clientY || e.originalEvent.clientY;\n                    isDragActive = true;\n                }\n\n                if ($image.offset() && $image.width() > $imageContainer.width()) {\n                    endX = $image.offset().left;\n                }\n            });\n\n            $image.off(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove');\n            $image.on(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    var currentDimention = getDimention(e.originalEvent);\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n\n                    if (currentDimention < pinchDimention) {\n                        zoomOut(e);\n                        pinchDimention = currentDimention;\n                    } else if (currentDimention > pinchDimention) {\n                        zoomIn(e);\n                        pinchDimention = currentDimention;\n                    }\n                } else {\n                    var clientX,\n                        clientY;\n\n                    if (gallery.fullScreen && isDragActive && (!transitionEnabled || !transitionActive)) {\n\n                        if (allowZoomOut && !$image.hasClass(imageDraggableClass)) {\n                            $image.addClass(imageDraggableClass);\n                        }\n                        clientX = e.clientX || e.originalEvent.clientX;\n                        clientY = e.clientY || e.originalEvent.clientY;\n\n                        e.preventDefault();\n\n                        if (isTouchEnabled) {\n                            touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                            clientX = touch.pageX;\n                            clientY = touch.pageY;\n                        }\n\n                        if (allowZoomOut) {\n                            imagePosY = getTop($(fullscreenImageSelector, $gallery));\n                            shiftImage(clientX - startX, clientY - startY, e);\n                        }\n                    }\n                }\n            });\n\n            $image.off('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd ');\n            $image.on('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd', function () {\n                transitionActive = false;\n            });\n\n            if (keyboardNavigation) {\n                $(document).off('keydown', keyboardNavigation);\n            }\n\n            /**\n             * Replaces original navigations with better one\n             * @param e - event object\n             */\n            keyboardNavigation = function (e) {\n                var step = 40,\n                    $focus = $(':focus'),\n                    isFullScreen = $(gallerySelector).data('fotorama').fullScreen,\n                    initVars = function () {\n                        imagePosX = $(fullscreenImageSelector, $gallery).offset().left;\n                        imagePosY = getTop($(fullscreenImageSelector, $gallery));\n                    };\n\n                if (($focus.attr('data-gallery-role') || !$focus.length) && allowZoomOut) {\n                    if (isFullScreen) {\n                        imagePosX = $(fullscreenImageSelector, $(gallerySelector)).offset().left;\n                        imagePosY = getTop($(fullscreenImageSelector, $(gallerySelector)));\n                    }\n\n                    if (e.keyCode === 39) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(-step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 38) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(0, step, e);\n                        }\n                    }\n\n                    if (e.keyCode === 37) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 40) {\n\n                        if (isFullScreen) {\n                            e.preventDefault();\n                            initVars();\n                            shiftImage(0, -step, e);\n                        }\n                    }\n                }\n\n                if (e.keyCode === 27 && isFullScreen && allowZoomOut) {\n                    $(gallerySelector).data('fotorama').cancelFullScreen();\n                }\n            };\n\n            /**\n             * @todo keyboard navigation through Fotorama Api.\n             */\n            $(document).on('keydown', keyboardNavigation);\n\n            $(document).on(isTouchEnabled ? 'touchend' : 'mouseup pointerup MSPointerUp', function (e) {\n                if (gallery.fullScreen) {\n\n                    if ($image.offset() && $image.width() > $imageContainer.width()) {\n                        endX = $image.offset().left;\n                    }\n\n                    isDragActive = false;\n                    $image.removeClass(imageDraggableClass);\n                }\n            });\n\n            $(window).off('resize', resizeHandler);\n            $(window).on('resize', {\n                $image: $image,\n                fotorama: fotorama\n            }, resizeHandler);\n        }\n\n        /**\n         * Hides magnifier preview and zoom blocks.\n         */\n        hideMagnifier = function () {\n            $(magnifierSelector).empty().hide();\n            $(magnifierZoomSelector).remove();\n        };\n\n        /**\n         * Check is active frame in gallery include video content.\n         * If true activeFrame contain video.\n         * @param $stageFrame - active frame in gallery\n         * @returns {*|Boolean}\n         */\n        function checkForVideo($stageFrame) {\n            return $stageFrame.hasClass(videoContainerClass);\n        }\n\n        /**\n         * Hides magnifier on drag and while arrow click.\n         */\n        function behaveOnDrag(e, initPos) {\n            var pos = [e.pageX, e.pageY],\n                isArrow = $(e.target).data('gallery-role') === 'arrow',\n                isClick = initPos[0] === pos[0] && initPos[1] === pos[1],\n                isImg = $(e.target).parent().data('active');\n\n            if (isArrow || isImg && !isClick) {\n                hideMagnifier();\n            }\n        }\n\n        if (config.magnifierOpts.enabled) {\n            $(element).on('pointerdown mousedown MSPointerDown', function (e) {\n                var pos = [e.pageX, e.pageY];\n\n                $(element).on('mousemove pointermove MSPointerMove', function (ev) {\n                    navigator.msPointerEnabled ? hideMagnifier() : behaveOnDrag(ev, pos);\n                });\n                $(document).on('mouseup pointerup MSPointerUp', function () {\n                    $(element).off('mousemove pointermove MSPointerMove');\n                });\n            });\n        }\n\n        $.extend(config.magnifierOpts, {\n            zoomable: false,\n            thumb: '.fotorama__img',\n            largeWrapper: '[data-gallery-role=\"magnifier\"]',\n            height: config.magnifierOpts.height || function () {\n                return $('[data-active=\"true\"]').height();\n            },\n            width: config.magnifierOpts.width || function () {\n                var productMedia = $(gallerySelector).parent().parent();\n\n                return productMedia.parent().width() - productMedia.width() - 20;\n            },\n            left: config.magnifierOpts.left || function () {\n                return $(gallerySelector).offset().left + $(gallerySelector).width() + 20;\n            },\n            top: config.magnifierOpts.top || function () {\n                return $(gallerySelector).offset().top;\n            }\n        });\n\n        $(element).on('fotorama:load fotorama:showend fotorama:fullscreenexit fotorama:ready', function (e, fotorama) {\n            var $activeStageFrame = $(gallerySelector).data('fotorama').activeFrame.$stageFrame;\n\n            if (!$activeStageFrame.find(magnifierZoomSelector).length) {\n                hideMagnifier();\n\n                if (config.magnifierOpts) {\n                    config.magnifierOpts.large = $(gallerySelector).data('fotorama').activeFrame.img;\n                    config.magnifierOpts.full = fotorama.data[fotorama.activeIndex].original;\n                    !checkForVideo($activeStageFrame) && $($activeStageFrame).magnify(config.magnifierOpts);\n                }\n            }\n        });\n\n        $(element).on('gallery:loaded', function (e) {\n            var $prevImage;\n\n            $(element).find(gallerySelector)\n                .on('fotorama:ready', function (e, fotorama) {\n                    var $zoomIn = $(zoomInButtonSelector),\n                        $zoomOut = $(zoomOutButtonSelector);\n\n                    if (!$zoomIn.hasClass(zoomInLoaded)) {\n                        $zoomIn.on('click touchstart', zoomIn);\n                        $zoomIn.on('mousedown', function (e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomIn.on('keyup', function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $(window).on('keyup', function (e) {\n\n                            if (e.keyCode === 107 || fotorama.fullscreen) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $zoomIn.addClass(zoomInLoaded);\n                    }\n\n                    if (!$zoomOut.hasClass(zoomOutLoaded)) {\n                        $zoomOut.on('click touchstart', zoomOut);\n                        $zoomOut.on('mousedown', function (e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomOut.on('keyup', function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $(window).on('keyup', function (e) {\n\n                            if (e.keyCode === 109 || fotorama.fullscreen) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $zoomOut.addClass(zoomOutLoaded);\n                    }\n                })\n                .on('fotorama:fullscreenenter fotorama:showend', function (e, fotorama) {\n                    hideMagnifier();\n\n                    if (!$(fullscreenImageSelector).is($prevImage)) {\n                        resetVars($(fullscreenImageSelector));\n                    }\n                    magnifierFullscreen(fotorama);\n                    mousewheel(e, fotorama, element);\n\n                    if ($prevImage) {\n                        calculateMinSize($prevImage);\n\n                        if (!$(fullscreenImageSelector).is($prevImage)) {\n                            resetVars($prevImage);\n                        }\n                    }\n\n                    toggleStandartNavigation();\n                })\n                .on('fotorama:load', function (e, fotorama) {\n                    if ($(gallerySelector).data('fotorama').fullScreen) {\n                        toggleZoomButtons($(fullscreenImageSelector), isTouchEnabled,\n                            checkForVideo(fotorama.activeFrame.$stageFrame));\n                    }\n                    magnifierFullscreen(fotorama);\n                })\n                .on('fotorama:show', function (e, fotorama) {\n                    $prevImage = _.clone($(fullscreenImageSelector));\n                    hideMagnifier();\n                })\n                .on('fotorama:fullscreenexit', function (e, fotorama) {\n                    resetVars($(fullscreenImageSelector));\n                    hideMagnifier();\n                    hideZoomControls(true);\n                });\n        });\n\n        return config;\n    };\n});\n","magnifier/magnifier.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function ($) {\n    $.fn.magnify = function (options) {\n        'use strict';\n\n        var magnify = new Magnify($(this), options);\n\n        /* events must be tracked here */\n\n        /**\n         * Return that from _init function\n         *\n         */\n        return magnify;\n    };\n\n    function Magnify(element, options) {\n        var customUserOptions = options || {},\n            $box = $(element),\n            $thumb,\n            that = this,\n            largeWrapper = options.largeWrapper || '.magnifier-preview',\n            $magnifierPreview = $(largeWrapper);\n\n        curThumb = null,\n        magnifierOptions = {\n            x: 0,\n            y: 0,\n            w: 0,\n            h: 0,\n            lensW: 0,\n            lensH: 0,\n            lensBgX: 0,\n            lensBgY: 0,\n            largeW: 0,\n            largeH: 0,\n            largeL: 0,\n            largeT: 0,\n            zoom: 2,\n            zoomMin: 1.1,\n            zoomMax: 5,\n            mode: 'outside',\n            eventType: 'click',\n            status: 0,\n            zoomAttached: false,\n            zoomable: customUserOptions.zoomable !== undefined ?\n                customUserOptions.zoomable\n                : false,\n            onthumbenter: customUserOptions.onthumbenter !== undefined ?\n                customUserOptions.onthumbenter\n                : null,\n            onthumbmove: customUserOptions.onthumbmove !== undefined ?\n                customUserOptions.onthumbmove\n                : null,\n            onthumbleave: customUserOptions.onthumbleave !== undefined ?\n                customUserOptions.onthumbleave\n                : null,\n            onzoom: customUserOptions.onzoom !== undefined ?\n                customUserOptions.onzoom\n                : null\n        },\n        pos = {\n            t: 0,\n            l: 0,\n            x: 0,\n            y: 0\n        },\n        gId = 0,\n        status = 0,\n        curIdx = '',\n        curLens = null,\n        curLarge = null,\n        lensbg = customUserOptions.bg !== undefined ?\n            customUserOptions.lensbg\n            : true,\n        gZoom = customUserOptions.zoom !== undefined ?\n            customUserOptions.zoom\n            : magnifierOptions.zoom,\n        gZoomMin = customUserOptions.zoomMin !== undefined ?\n            customUserOptions.zoomMin\n            : magnifierOptions.zoomMin,\n        gZoomMax = customUserOptions.zoomMax !== undefined ?\n            customUserOptions.zoomMax\n            : magnifierOptions.zoomMax,\n        gMode = customUserOptions.mode || magnifierOptions.mode,\n        gEventType = customUserOptions.eventType || magnifierOptions.eventType,\n        data = {},\n        inBounds = false,\n        isOverThumb = false,\n        rate = 1,\n        paddingX = 0,\n        paddingY = 0,\n        enabled = true,\n        showWrapper = true;\n\n        var MagnifyCls = {\n            magnifyHidden: 'magnify-hidden',\n            magnifyOpaque: 'magnify-opaque',\n            magnifyFull: 'magnify-fullimage'\n        };\n\n        /**\n         * Update Lens positon on.\n         *\n         */\n        that.update = function () {\n            updateLensOnLoad();\n        };\n\n        /**\n         * Init new Magnifier\n         *\n         */\n        that.init = function () {\n            _init($box, options);\n        };\n\n        function _toBoolean(str) {\n            if (typeof str === 'string') {\n                if (str === 'true') {\n                    return true;\n                } else if (str === 'false' || '') {\n                    return false;\n                }\n                console.warn('Wrong type: can\\'t be transformed to Boolean');\n\n            } else if (typeof str === 'boolean') {\n                return str;\n            }\n        }\n\n        function createLens(thumb) {\n            if ($(thumb).siblings('.magnify-lens').length) {\n                return false;\n            }\n            var lens = $('<div class=\"magnify-lens magnify-hidden\" data-gallery-role=\"magnifier-zoom\"></div>');\n\n            $(thumb).parent().append(lens);\n        }\n\n        function updateLensOnLoad(idSelectorMainImg, thumb, largeImgInMagnifyLens, largeWrapper) {\n            var magnifyLensElement= $box.find('.magnify-lens'),\n                textWrapper;\n\n            if (data[idSelectorMainImg].status === 1) {\n                textWrapper = $('<div class=\"magnifier-loader-text\"></div>');\n                magnifyLensElement.className = 'magnifier-loader magnify-hidden';\n                textWrapper.html('Loading...');\n                magnifyLensElement.html('').append(textWrapper);\n            } else if (data[idSelectorMainImg].status === 2) {\n                magnifyLensElement.addClass(MagnifyCls.magnifyHidden);\n                magnifyLensElement.html('');\n\n                largeImgInMagnifyLens.id = idSelectorMainImg + '-large';\n                largeImgInMagnifyLens.style.width = data[idSelectorMainImg].largeImgInMagnifyLensWidth + 'px';\n                largeImgInMagnifyLens.style.height = data[idSelectorMainImg].largeImgInMagnifyLensHeight + 'px';\n                largeImgInMagnifyLens.className = 'magnifier-large magnify-hidden';\n\n                if (data[idSelectorMainImg].mode === 'inside') {\n                    magnifyLensElement.append(largeImgInMagnifyLens);\n                } else {\n                    largeWrapper.html('').append(largeImgInMagnifyLens);\n                }\n            }\n\n            data[idSelectorMainImg].lensH = data[idSelectorMainImg].lensH > $thumb.height() ? $thumb.height() : data[idSelectorMainImg].lensH;\n\n            if (Math.round(data[idSelectorMainImg].lensW) === 0) {\n                magnifyLensElement.css('display', 'none');\n            } else {\n                magnifyLensElement.css({\n                    width: Math.round(data[idSelectorMainImg].lensW) + 'px',\n                    height: Math.round(data[idSelectorMainImg].lensH) + 'px',\n                    display: ''\n                });\n            }\n        }\n\n        function getMousePos() {\n            var xPos = pos.x - magnifierOptions.x,\n                yPos = pos.y - magnifierOptions.y,\n                t,\n                l;\n\n            inBounds =  xPos < 0 || yPos < 0 || xPos > magnifierOptions.w || yPos > magnifierOptions.h  ? false : true;\n\n            l = xPos - magnifierOptions.lensW / 2;\n            t = yPos - magnifierOptions.lensH / 2;\n\n            if (xPos < magnifierOptions.lensW / 2) {\n                l = 0;\n            }\n\n            if (yPos < magnifierOptions.lensH / 2) {\n                t = 0;\n            }\n\n            if (xPos - magnifierOptions.w + Math.ceil(magnifierOptions.lensW / 2) > 0) {\n                l = magnifierOptions.w - Math.ceil(magnifierOptions.lensW + 2);\n            }\n\n            if (yPos - magnifierOptions.h + Math.ceil(magnifierOptions.lensH / 2) > 0) {\n                t = magnifierOptions.h - Math.ceil(magnifierOptions.lensH);\n            }\n\n            pos.l = l;\n            pos.t = t;\n\n            magnifierOptions.lensBgX = pos.l;\n            magnifierOptions.lensBgY = pos.t;\n\n            if (magnifierOptions.mode === 'inside') {\n                magnifierOptions.largeL = Math.round(xPos * (magnifierOptions.zoom - magnifierOptions.lensW / magnifierOptions.w));\n                magnifierOptions.largeT = Math.round(yPos * (magnifierOptions.zoom - magnifierOptions.lensH / magnifierOptions.h));\n            } else {\n                magnifierOptions.largeL = Math.round(magnifierOptions.lensBgX * magnifierOptions.zoom * (magnifierOptions.largeWrapperW / magnifierOptions.w));\n                magnifierOptions.largeT = Math.round(magnifierOptions.lensBgY * magnifierOptions.zoom * (magnifierOptions.largeWrapperH / magnifierOptions.h));\n            }\n        }\n\n        function onThumbEnter() {\n            if (_toBoolean(enabled)) {\n                magnifierOptions = data[curIdx];\n                curLens = $box.find('.magnify-lens');\n\n                if (magnifierOptions.status === 2) {\n                    curLens.removeClass(MagnifyCls.magnifyOpaque);\n                    curLarge = $('#' + curIdx + '-large');\n                    curLarge.removeClass(MagnifyCls.magnifyHidden);\n                } else if (magnifierOptions.status === 1) {\n                    curLens.className = 'magnifier-loader';\n                }\n            }\n        }\n\n        function onThumbLeave() {\n            if (magnifierOptions.status > 0) {\n                var handler = magnifierOptions.onthumbleave;\n\n                if (handler !== null) {\n                    handler({\n                        thumb: curThumb,\n                        lens: curLens,\n                        large: curLarge,\n                        x: pos.x,\n                        y: pos.y\n                    });\n                }\n\n                if (!curLens.hasClass(MagnifyCls.magnifyHidden)) {\n                    curLens.addClass(MagnifyCls.magnifyHidden);\n\n                    //$curThumb.removeClass(MagnifyCls.magnifyOpaque);\n                    if (curLarge !== null) {\n                        curLarge.addClass(MagnifyCls.magnifyHidden);\n                    }\n                }\n            }\n        }\n\n        function move() {\n            if (_toBoolean(enabled)) {\n                if (status !== magnifierOptions.status) {\n                    onThumbEnter();\n                }\n\n                if (magnifierOptions.status > 0) {\n                    curThumb.className = magnifierOptions.thumbCssClass + ' magnify-opaque';\n\n                    if (magnifierOptions.status === 1) {\n                        curLens.className = 'magnifier-loader';\n                    } else if (magnifierOptions.status === 2) {\n                        curLens.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.css({\n                            left: '-' + magnifierOptions.largeL + 'px',\n                            top: '-' + magnifierOptions.largeT + 'px'\n                        });\n                    }\n\n                    var borderOffset = 2; // Offset for magnify-lens border\n                    pos.t = pos.t <= 0 ? 0 : pos.t - borderOffset;\n\n                    curLens.css({\n                        left: pos.l + paddingX + 'px',\n                        top: pos.t + paddingY + 'px'\n                    });\n\n                    if (lensbg) {\n                        curLens.css({\n                            'background-color': 'rgba(f,f,f,.5)'\n                        });\n                    } else {\n                        curLens.get(0).style.backgroundPosition = '-' +\n                        magnifierOptions.lensBgX + 'px -' +\n                        magnifierOptions.lensBgY + 'px';\n                    }\n                    var handler = magnifierOptions.onthumbmove;\n\n                    if (handler !== null) {\n                        handler({\n                            thumb: curThumb,\n                            lens: curLens,\n                            large: curLarge,\n                            x: pos.x,\n                            y: pos.y\n                        });\n                    }\n                }\n\n                status = magnifierOptions.status;\n            }\n        }\n\n        function setThumbData(mainImage, mainImageData) {\n            var thumbBounds = mainImage.getBoundingClientRect(),\n                w = 0,\n                h = 0;\n\n            mainImageData.x = Math.round(thumbBounds.left);\n            mainImageData.y = Math.round(thumbBounds.top);\n            mainImageData.w = Math.round(thumbBounds.right - mainImageData.x);\n            mainImageData.h = Math.round(thumbBounds.bottom - mainImageData.y);\n\n            if (mainImageData.mode === 'inside') {\n                w = mainImageData.w;\n                h = mainImageData.h;\n            } else {\n                w = mainImageData.largeWrapperW;\n                h = mainImageData.largeWrapperH;\n            }\n\n            mainImageData.largeImgInMagnifyLensWidth = Math.round(mainImageData.zoom * w);\n            mainImageData.largeImgInMagnifyLensHeight = Math.round(mainImageData.zoom * h);\n\n            mainImageData.lensW = Math.round(mainImageData.w / mainImageData.zoom);\n            mainImageData.lensH = Math.round(mainImageData.h / mainImageData.zoom);\n        }\n\n        function _init($box, options) {\n            var opts = {};\n\n            if (options.thumb === undefined) {\n                return false;\n            }\n\n            $thumb = $box.find(options.thumb);\n\n            if ($thumb.length) {\n                for (var key in options) {\n                    opts[key] = options[key];\n                }\n\n                opts.thumb = $thumb;\n                enabled = opts.enabled;\n\n                if (_toBoolean(enabled)) {\n\n                    $magnifierPreview.show().css('display', '');\n                    $magnifierPreview.addClass(MagnifyCls.magnifyHidden);\n                    set(opts);\n                } else {\n                    $magnifierPreview.empty().hide();\n                }\n            }\n\n            return that;\n        }\n\n        function hoverEvents(thumb) {\n            $(thumb).on('mouseover', function (e) {\n\n                if (showWrapper) {\n\n                    if (magnifierOptions.status !== 0) {\n                        onThumbLeave();\n                    }\n                    handleEvents(e);\n                    isOverThumb = inBounds;\n                }\n            }).trigger('mouseover');\n        }\n\n        function clickEvents(thumb) {\n            $(thumb).on('click', function (e) {\n\n                if (showWrapper) {\n                    if (!isOverThumb) {\n                        if (magnifierOptions.status !== 0) {\n                            onThumbLeave();\n                        }\n                        handleEvents(e);\n                        isOverThumb = true;\n                    }\n                }\n            });\n        }\n\n        function bindEvents(eType, thumb) {\n            var eventFlag = 'hasBoundEvent_' + eType;\n            if (thumb[eventFlag]) {\n                // Events are already bound, no need to bind in duplicate\n                return;\n            }\n            thumb[eventFlag] = true;\n\n            switch (eType) {\n                case 'hover':\n                    hoverEvents(thumb);\n                    break;\n\n                case 'click':\n                    clickEvents(thumb);\n                    break;\n            }\n        }\n\n        function handleEvents(e) {\n            var src = e.target;\n\n            curIdx = src.id;\n            curThumb = src;\n\n            onThumbEnter(src);\n\n            setThumbData(curThumb, magnifierOptions);\n\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n            move();\n\n            var handler = magnifierOptions.onthumbenter;\n\n            if (handler !== null) {\n                handler({\n                    thumb: curThumb,\n                    lens: curLens,\n                    large: curLarge,\n                    x: pos.x,\n                    y: pos.y\n                });\n            }\n        }\n\n        function set(options) {\n            if (data[options.thumb.id] !== undefined) {\n                curThumb = options.thumb;\n\n                return false;\n            }\n\n            var thumbObj = new Image(),\n                largeObj = new Image(),\n                $thumb = options.thumb,\n                thumb = $thumb.get(0),\n                idx = thumb.id,\n                largeUrl,\n                largeWrapper = $(options.largeWrapper),\n                zoom = options.zoom || thumb.getAttribute('data-zoom') || gZoom,\n                zoomMin = options.zoomMin || gZoomMin,\n                zoomMax = options.zoomMax || gZoomMax,\n                mode = options.mode || thumb.getAttribute('data-mode') || gMode,\n                eventType = options.eventType || thumb.getAttribute('data-eventType') || gEventType,\n                onthumbenter = options.onthumbenter !== undefined ?\n                    options.onthumbenter\n                    : magnifierOptions.onthumbenter,\n                onthumbleave = options.onthumbleave !== undefined ?\n                    options.onthumbleave\n                    : magnifierOptions.onthumbleave,\n                onthumbmove = options.onthumbmove !== undefined ?\n                    options.onthumbmove\n                    : magnifierOptions.onthumbmove;\n\n            largeUrl = $thumb.data('original') || customUserOptions.full || $thumb.attr('src');\n\n            if (thumb.id === '') {\n                idx = thumb.id = 'magnifier-item-' + gId;\n                gId += 1;\n            }\n\n            createLens(thumb, idx);\n\n            if (options.width) {\n                largeWrapper.width(options.width);\n            }\n\n            if (options.height) {\n                largeWrapper.height(options.height);\n            }\n\n            if (options.top) {\n                if (typeof options.top == 'function') {\n                    var top = options.top() + 'px';\n                } else {\n                    var top = options.top + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.top = top.replace('%px', '%');\n                }\n            }\n\n            if (options.left) {\n                if (typeof options.left == 'function') {\n                    var left = options.left() + 'px';\n                } else {\n                    var left = options.left + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.left = left.replace('%px', '%');\n                }\n            }\n\n            data[idx] = {\n                zoom: zoom,\n                zoomMin: zoomMin,\n                zoomMax: zoomMax,\n                mode: mode,\n                eventType: eventType,\n                thumbCssClass: thumb.className,\n                zoomAttached: false,\n                status: 0,\n                largeUrl: largeUrl,\n                largeWrapperId: mode === 'outside' ? largeWrapper.attr('id') : null,\n                largeWrapperW: mode === 'outside' ? largeWrapper.width() : null,\n                largeWrapperH: mode === 'outside' ? largeWrapper.height() : null,\n                onthumbenter: onthumbenter,\n                onthumbleave: onthumbleave,\n                onthumbmove: onthumbmove\n            };\n\n            paddingX = ($thumb.parent().width() - $thumb.width()) / 2;\n            paddingY = ($thumb.parent().height() - $thumb.height()) / 2;\n\n            showWrapper = false;\n            $(thumbObj).on('load', function () {\n                if (data.hasOwnProperty(idx)) {\n                    data[idx].status = 1;\n                    $(largeObj).on('load', function () {\n                        if (largeObj.width > largeWrapper.width() || largeObj.height > largeWrapper.height()) {\n                            showWrapper = true;\n                            bindEvents(eventType, thumb);\n                            data[idx].status = 2;\n                            if (largeObj.width > largeObj.height) {\n                                data[idx].zoom = largeObj.width / largeWrapper.width();\n                            } else {\n                                data[idx].zoom = largeObj.height / largeWrapper.height();\n                            }\n                            setThumbData(thumb, data[idx]);\n                            updateLensOnLoad(idx, thumb, largeObj, largeWrapper);\n                        }\n                    });\n                    largeObj.src = data[idx].largeUrl;\n                }\n            });\n\n            thumbObj.src = thumb.src;\n        }\n\n        /**\n         * Hide magnifier when mouse exceeds image bounds.\n         */\n        function onMouseLeave() {\n            onThumbLeave();\n            isOverThumb = false;\n            $magnifierPreview.addClass(MagnifyCls.magnifyHidden);\n        }\n\n        function onMousemove(e) {\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n\n            if (gEventType === 'hover') {\n                isOverThumb = inBounds;\n            }\n\n            if (inBounds && isOverThumb) {\n                if (gMode === 'outside') {\n                    $magnifierPreview.removeClass(MagnifyCls.magnifyHidden);\n                }\n                move();\n            }\n        }\n\n        function onScroll() {\n            if (curThumb !== null) {\n                setThumbData(curThumb, magnifierOptions);\n            }\n        }\n\n        $(window).on('scroll', onScroll);\n        $(window).on('resize', function () {\n            _init($box, customUserOptions);\n        });\n\n        $box.on('mousemove', onMousemove);\n        $box.on('mouseleave', onMouseLeave);\n\n        _init($box, customUserOptions);\n    }\n}(jQuery));\n","Magento_PaypalCaptcha/js/model/skipRefreshCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    return {\n        skip: ko.observable(false)\n    };\n});\n","Magento_PaypalCaptcha/js/view/payment/list-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/model/captchaList'\n], function ($, captchaList) {\n    'use strict';\n\n    var mixin = {\n\n        formId: 'co-payment-form',\n\n        /**\n         * Sets custom template for Payflow Pro\n         *\n         * @param {Object} payment\n         * @returns {Object}\n         */\n        createComponent: function (payment) {\n\n            var component = this._super(payment);\n\n            if (component.component === 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method') {\n                component.template = 'Magento_PaypalCaptcha/payment/payflowpro-form';\n                $(window).off('clearTimeout')\n                    .on('clearTimeout', this.clearTimeout.bind(this));\n            }\n\n            return component;\n        },\n\n        /**\n         * Overrides default window.clearTimeout() to catch errors from iframe and reload Captcha.\n         *\n         * @param {Number} timeoutID\n         */\n        clearTimeout: function (timeoutID) {\n            var captcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (captcha !== null) {\n                captcha.refresh();\n            }\n            clearTimeout(timeoutID);\n        }\n    };\n\n    /**\n     * Overrides `Magento_Checkout/js/view/payment/list::createComponent`\n     */\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/payment/method-renderer/payflowpro-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var payflowProMethodMixin = {\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            skipRefreshCaptcha.skip(true);\n            this._super();\n        }\n    };\n\n    return function (payflowProMethod) {\n        return payflowProMethod.extend(payflowProMethodMixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/checkout/paymentCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Captcha/js/model/captcha'\n],\nfunction ($, defaultCaptcha, captchaList, Captcha) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            var captchaConfigPayment,\n                currentCaptcha;\n\n            this._super();\n\n            if (window[this.configSource] && window[this.configSource].captchaPayments) {\n                captchaConfigPayment = window[this.configSource].captchaPayments;\n\n                $.each(captchaConfigPayment, function (formId, captchaData) {\n                    var captcha;\n\n                    captchaData.formId = formId;\n                    captcha = Captcha(captchaData);\n                    captchaList.add(captcha);\n                });\n            }\n\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n            }\n        }\n    });\n});\n","Magento_PaypalCaptcha/js/view/checkout/defaultCaptcha-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaypalCaptcha/js/model/skipRefreshCaptcha'\n], function (skipRefreshCaptcha) {\n    'use strict';\n\n    var defaultCaptchaMixin = {\n        /**\n         * @override\n         */\n        refresh: function () {\n            if (!skipRefreshCaptcha.skip()) {\n                this._super();\n            } else {\n                skipRefreshCaptcha.skip(false);\n            }\n        }\n    };\n\n    return function (defaultCaptcha) {\n        return defaultCaptcha.extend(defaultCaptchaMixin);\n    };\n});\n","js-cookie/cookie-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-cookie/js.cookie'\n], function ($, cookie) {\n    'use strict';\n\n    window.Cookies = window.Cookies || cookie;\n\n    var config = $.cookie = function (key, value, options) {\n        if (value !== undefined) {\n            options = $.extend({}, config.defaults, options);\n\n            return cookie.set(key, value, options);\n        }\n\n        var result = key ? undefined : {},\n            cookies = document.cookie ? document.cookie.split('; ') : [],\n            i;\n\n        for (i = 0; i < cookies.length; i++) {\n            var parts = cookies[i].split('='),\n                name = config.raw ? parts.shift() : decodeURIComponent(parts.shift()),\n                cookieValue = parts.join('=');\n\n            if (key && key === name) {\n                result = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '));\n                break;\n            }\n\n            if (!key && (cookieValue = decodeURIComponent(cookieValue.replace('/\\\\+/g', ' '))) !== undefined) {\n                result[name] = cookieValue;\n            }\n        }\n\n        return result;\n    };\n\n    config.defaults = {};\n\n    $.removeCookie = function (key, options) {\n        if ($.cookie(key) === undefined) {\n            return false;\n        }\n\n        $.cookie(key, '', $.extend({}, options, { expires: -1 }));\n        return !$.cookie(key);\n    };\n});\n","js-cookie/js.cookie.js":"/*! js-cookie v3.0.5 | MIT */\n;\n(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define(factory) :\n            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, (function () {\n                var current = global.Cookies;\n                var exports = global.Cookies = factory();\n                exports.noConflict = function () { global.Cookies = current; return exports; };\n            })());\n})(this, (function () { 'use strict';\n\n    /* eslint-disable no-var */\n    function assign (target) {\n        for (var i = 1; i < arguments.length; i++) {\n            var source = arguments[i];\n            for (var key in source) {\n                target[key] = source[key];\n            }\n        }\n        return target\n    }\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n    var defaultConverter = {\n        read: function (value) {\n            if (value[0] === '\"') {\n                value = value.slice(1, -1);\n            }\n            return value.replace(/(%[\\dA-F]{2})+/gi, decodeURIComponent)\n        },\n        write: function (value) {\n            return encodeURIComponent(value).replace(\n                /%(2[346BF]|3[AC-F]|40|5[BDE]|60|7[BCD])/g,\n                decodeURIComponent\n            )\n        }\n    };\n    /* eslint-enable no-var */\n\n    /* eslint-disable no-var */\n\n    function init (converter, defaultAttributes) {\n        function set (name, value, attributes) {\n            if (typeof document === 'undefined') {\n                return\n            }\n\n            attributes = assign({}, defaultAttributes, attributes);\n\n            if (typeof attributes.expires === 'number') {\n                attributes.expires = new Date(Date.now() + attributes.expires * 864e5);\n            }\n            if (attributes.expires) {\n                attributes.expires = attributes.expires.toUTCString();\n            }\n\n            name = encodeURIComponent(name)\n                .replace(/%(2[346B]|5E|60|7C)/g, decodeURIComponent)\n                .replace(/[()]/g, escape);\n\n            var stringifiedAttributes = '';\n            for (var attributeName in attributes) {\n                if (!attributes[attributeName]) {\n                    continue\n                }\n\n                stringifiedAttributes += '; ' + attributeName;\n\n                if (attributes[attributeName] === true) {\n                    continue\n                }\n\n                // Considers RFC 6265 section 5.2:\n                // ...\n                // 3.  If the remaining unparsed-attributes contains a %x3B (\";\")\n                //     character:\n                // Consume the characters of the unparsed-attributes up to,\n                // not including, the first %x3B (\";\") character.\n                // ...\n                stringifiedAttributes += '=' + attributes[attributeName].split(';')[0];\n            }\n\n            return (document.cookie =\n                name + '=' + converter.write(value, name) + stringifiedAttributes)\n        }\n\n        function get (name) {\n            if (typeof document === 'undefined' || (arguments.length && !name)) {\n                return\n            }\n\n            // To prevent the for loop in the first place assign an empty array\n            // in case there are no cookies at all.\n            var cookies = document.cookie ? document.cookie.split('; ') : [];\n            var jar = {};\n            for (var i = 0; i < cookies.length; i++) {\n                var parts = cookies[i].split('=');\n                var value = parts.slice(1).join('=');\n\n                try {\n                    var found = decodeURIComponent(parts[0]);\n                    jar[found] = converter.read(value, found);\n\n                    if (name === found) {\n                        break\n                    }\n                } catch (e) {}\n            }\n\n            return name ? jar[name] : jar\n        }\n\n        return Object.create(\n            {\n                set,\n                get,\n                remove: function (name, attributes) {\n                    set(\n                        name,\n                        '',\n                        assign({}, attributes, {\n                            expires: -1\n                        })\n                    );\n                },\n                withAttributes: function (attributes) {\n                    return init(this.converter, assign({}, this.attributes, attributes))\n                },\n                withConverter: function (converter) {\n                    return init(assign({}, this.converter, converter), this.attributes)\n                }\n            },\n            {\n                attributes: { value: Object.freeze(defaultAttributes) },\n                converter: { value: Object.freeze(converter) }\n            }\n        )\n    }\n\n    var api = init(defaultConverter, { path: '/' });\n    /* eslint-enable no-var */\n\n    return api;\n\n}));\n","PayPal_Braintree/js/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","PayPal_Braintree/js/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/checkoutAgreements/view/checkout-agreements-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return function (CheckoutAgreements) {\n        return CheckoutAgreements.extend({\n            /**\n             * Replace checkboxes unique id with Braintree PayPal Vault unique id using the index.\n             * First call the original & extend in order to prevent unwanted behaviour.\n             *\n             * @param {Object} context - the ko context\n             * @param {Number} agreementId\n             */\n            getCheckboxId: function (context, agreementId) {\n                let result = this._super(context, agreementId),\n\n                    /* Fetch corresponding payment method from parent context */\n                    paymentMethodRenderer = context.$parents[1],\n                    paymentMethodName;\n\n                /* We only want to check for Braintree PayPal Vault methods with set properties     */\n                if (!paymentMethodRenderer ||\n                    _.get(paymentMethodRenderer, ['code'], null) !== 'braintree_paypal_vault' ||\n                    !_.has(paymentMethodRenderer, 'index')\n                ) {\n                    return result;\n                }\n\n                paymentMethodName = paymentMethodRenderer.index;\n\n                /* Now check that the relevant index `braintree_paypal_vault_X` has global variables set */\n                if (!this.hasVaultInCheckoutConfig(paymentMethodName)) {\n                    return result;\n                }\n\n                /* If yes, use unique name */\n                return 'agreement_' + paymentMethodName + '_' + agreementId;\n            },\n\n            /**\n             * Check whether the current method renderer index has configuration in the checkout global.\n             *\n             * @param {String} vaultIndex\n             * @return {Boolean}\n             */\n            hasVaultInCheckoutConfig: function (vaultIndex) {\n                return _.has(window.checkoutConfig.payment, ['vault', vaultIndex]);\n            }\n        });\n    };\n});\n","PayPal_Braintree/js/googlepay/button.js":"/**\n * Braintree Google Pay button\n **/\ndefine(\n    [\n        'uiComponent',\n        'underscore',\n        'knockout',\n        'jquery',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_CheckoutAgreements/js/view/checkout-agreements',\n        'PayPal_Braintree/js/googlepay/model/parsed-response',\n        'PayPal_Braintree/js/googlepay/model/payment-data',\n        'PayPal_Braintree/js/view/payment/adapter',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeGooglePay',\n        'mage/translate',\n        'googlePayLibrary'\n    ],\n    function (\n        Component,\n        _,\n        ko,\n        $,\n        additionalValidators,\n        checkoutAgreements,\n        parsedResponseModel,\n        paymentDataModel,\n        braintreeMainAdapter,\n        braintree,\n        dataCollector,\n        googlePay,\n        $t\n    ) {\n        'use strict';\n\n        return {\n            init: function (element, context) {\n\n                // No element or context\n                if (!element || !context) {\n                    return;\n                }\n\n                // Context must implement these methods\n                if (typeof context.getClientToken !== 'function') {\n                    console.error(\n                        'Braintree GooglePay Context passed does not provide a getClientToken method',\n                        context\n                    );\n                    return;\n                }\n                if (typeof context.getPaymentRequest !== 'function') {\n                    console.error(\n                        'Braintree GooglePay Context passed does not provide a getPaymentRequest method',\n                        context\n                    );\n                    return;\n                }\n                if (typeof context.startPlaceOrder !== 'function') {\n                    console.error(\n                        'Braintree GooglePay Context passed does not provide a startPlaceOrder method',\n                        context\n                    );\n                    return;\n                }\n\n                // init google pay object\n                let paymentsClient = new window.google.payments.api.PaymentsClient({\n                        environment: context.getEnvironment()\n                    }),\n\n                    // Create a button within the KO element, as Google Pay can only be instantiated through\n                    // a valid on click event (ko onclick bind interferes with this).\n                    button = document.createElement('button'),\n                    color = context.getBtnColor() === 1 ? 'black' : 'white';\n\n                button.className = 'braintree-googlepay-button long ' + color;\n                button.title = $t('Buy with Google Pay');\n\n                // init braintree api\n                braintree.create({\n                    authorization: context.getClientToken()\n                }, function (clientErr, clientInstance) {\n                    this.initGooglePay(clientErr, clientInstance, paymentsClient, button, element, context);\n                }.bind(this));\n            },\n\n            initGooglePay: function (clientErr, clientInstance, paymentsClient, button, element, context) {\n                if (clientErr) {\n                    console.error('Error creating client:', clientErr);\n                    return;\n                }\n                dataCollector.create({\n                    client: clientInstance\n                }, function (dataCollectorErr, dataCollectorInstance) {\n                    if (dataCollectorErr) {\n                        return;\n                    }\n                    googlePay.create({\n                        client: clientInstance,\n                        googlePayVersion: 2\n                    }, function (googlePayErr, googlePaymentInstance) {\n                        this.render(\n                            clientInstance,\n                            googlePayErr,\n                            googlePaymentInstance,\n                            dataCollectorInstance,\n                            paymentsClient,\n                            button,\n                            element,\n                            context\n                        );\n                    }.bind(this));\n                }.bind(this));\n            },\n\n            render: function (clientInstance, googlePayErr, googlePaymentInstance,\n                dataCollectorInstance, paymentsClient, button, element, context) {\n                // No instance\n                if (googlePayErr) {\n                    console.error('Braintree GooglePay Error creating googlePayInstance:', googlePayErr);\n                    return;\n                }\n\n                /**\n                 * Assign existing client instance to braintree adapter to use existing one\n                 * otherwise new client instance needs to be created for 3DS verification\n                 * which calls the Braintree Client & Device Collector SDK twice and\n                 * makes process slow.\n                 */\n                braintreeMainAdapter.clientInstance = clientInstance;\n                braintreeMainAdapter.deviceData = dataCollectorInstance.deviceData;\n\n                paymentsClient.isReadyToPay({\n                    apiVersion: 2,\n                    apiVersionMinor: 0,\n                    allowedPaymentMethods: googlePaymentInstance.createPaymentDataRequest().allowedPaymentMethods\n                }).then(function (response) {\n                    if (response.result) {\n                        button.addEventListener('click', function (event) {\n                            let agreements = checkoutAgreements().agreements,\n                                shouldDisableActions = false;\n\n                            _.each(agreements, function (item) {\n                                if (checkoutAgreements().isAgreementRequired(item)) {\n                                    let inputId = '#agreement_braintree_googlepay_' + item.agreementId,\n                                        inputEl = document.querySelector(inputId);\n\n                                    if (inputEl !== null && !inputEl.checked) {\n                                        shouldDisableActions = true;\n                                    }\n\n                                }\n                            });\n\n                            if ($(button).parents('#braintree-googlepay-express-payment').length === 0\n                                && !additionalValidators.validate(false)) {\n                                event.preventDefault();\n                                return false;\n                            }\n\n                            if (!shouldDisableActions) {\n                                event.preventDefault();\n                                $('body').loader('show');\n\n                                let paymentDataRequest = googlePaymentInstance.createPaymentDataRequest(\n                                    context.getPaymentRequest()\n                                );\n\n                                paymentsClient.loadPaymentData(paymentDataRequest).then(function (paymentData) {\n                                    // Persist the paymentData (shipping address etc.)\n                                    paymentDataModel.setPaymentMethodData(_.get(\n                                        paymentData,\n                                        'paymentMethodData',\n                                        null\n                                    ));\n                                    paymentDataModel.setEmail(_.get(paymentData, 'email', ''));\n                                    paymentDataModel.setShippingAddress(_.get(\n                                        paymentData,\n                                        'shippingAddress',\n                                        null\n                                    ));\n                                    // Return the braintree nonce promise\n                                    return googlePaymentInstance.parseResponse(paymentData);\n                                }).then(function (result) {\n                                    parsedResponseModel.setNonce(result.nonce);\n                                    parsedResponseModel.setIsNetworkTokenized(_.get(\n                                        result,\n                                        ['details', 'isNetworkTokenized'],\n                                        false\n                                    ));\n                                    parsedResponseModel.setBin(_.get(\n                                        result,\n                                        ['details', 'bin'],\n                                        null\n                                    ));\n\n                                    context.startPlaceOrder(dataCollectorInstance.deviceData);\n                                    $('body').loader('hide');\n                                }).catch(function (err) {\n                                    // Handle errors\n                                    // err = {statusCode: \"CANCELED\"}\n                                    console.error(err);\n                                    parsedResponseModel.resetDefaultData();\n                                    $('body').loader('hide');\n                                });\n                            }\n                        });\n                        element.appendChild(button);\n                    }\n                }).catch(function (err) {\n                    console.error(err);\n                    $('body').loader('hide');\n                });\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/googlepay/api.js":"/**\n * Braintree Google Pay button api\n **/\ndefine([\n    'uiComponent',\n    'underscore',\n    'jquery',\n    'mage/translate',\n    'mage/storage',\n    'PayPal_Braintree/js/form-builder',\n    'PayPal_Braintree/js/googlepay/implementations/shortcut/3d-secure',\n    'PayPal_Braintree/js/googlepay/model/parsed-response',\n    'PayPal_Braintree/js/googlepay/model/payment-data',\n    'PayPal_Braintree/js/helper/remove-non-digit-characters',\n    'PayPal_Braintree/js/view/payment/validator-manager'\n], function (\n    Component,\n    _,\n    $,\n    $t,\n    storage,\n    formBuilder,\n    threeDSecureValidator,\n    parsedResponseModel,\n    paymentDataModel,\n    removeNonDigitCharacters,\n    validatorManager\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            validatorManager: validatorManager,\n            threeDSecureValidator: threeDSecureValidator,\n            clientToken: null,\n            merchantId: null,\n            currencyCode: null,\n            actionSuccess: null,\n            amount: null,\n            cardTypes: [],\n            btnColor: 0,\n            email: null,\n            paymentMethodNonce: null,\n            creditCardBin: null\n        },\n\n        /**\n         * Set & get environment\n         * \"PRODUCTION\" or \"TEST\"\n         */\n        setEnvironment: function (value) {\n            this.environment = value;\n        },\n        getEnvironment: function () {\n            return this.environment;\n        },\n\n        /**\n         * Set & get api token\n         */\n        setClientToken: function (value) {\n            this.clientToken = value;\n        },\n        getClientToken: function () {\n            return this.clientToken;\n        },\n\n        /**\n         * Set and get display name\n         */\n        setMerchantId: function (value) {\n            this.merchantId = value;\n        },\n        getMerchantId: function () {\n            return this.merchantId;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setAmount: function (value) {\n            this.amount = parseFloat(value).toFixed(2);\n        },\n        getAmount: function () {\n            return this.amount;\n        },\n\n        /**\n         * Set and get currency code\n         */\n        setCurrencyCode: function (value) {\n            this.currencyCode = value;\n        },\n        getCurrencyCode: function () {\n            return this.currencyCode;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setActionSuccess: function (value) {\n            this.actionSuccess = value;\n        },\n        getActionSuccess: function () {\n            return this.actionSuccess;\n        },\n\n        /**\n         * Set and get success redirection url\n         */\n        setCardTypes: function (value) {\n            this.cardTypes = value;\n        },\n        getCardTypes: function () {\n            return this.cardTypes;\n        },\n\n        /**\n         * BTN Color\n         */\n        setBtnColor: function (value) {\n            this.btnColor = value;\n        },\n        getBtnColor: function () {\n            return this.btnColor;\n        },\n\n        /**\n         * Add the 3D Secure validator config.\n         *\n         * @param {object} value\n         */\n        setThreeDSecureValidatorConfig: function (value) {\n            this.threeDSecureValidator.setConfig(value);\n        },\n\n        /**\n         * Add the 3D Secure validator to the validation manager with amount & billing address data set.\n         * It will be added only if 3D Secure is active.\n         */\n        addThreeDSecureValidator: function () {\n            this.threeDSecureValidator.setBillingAddress(this.getThreeDSecureBillingAddressData());\n            this.threeDSecureValidator.setShippingAddress(this.getThreeDSecureShippingAddressData());\n            this.threeDSecureValidator.setTotalAmount(this.getAmount());\n\n            this.validatorManager.add(this.threeDSecureValidator);\n        },\n\n        /**\n         * Payment request info\n         */\n        getPaymentRequest: function () {\n            let result = {\n                transactionInfo: {\n                    totalPriceStatus: 'ESTIMATED',\n                    totalPrice: this.getAmount(),\n                    currencyCode: this.getCurrencyCode()\n                },\n                allowedPaymentMethods: [\n                    {\n                        'type': 'CARD',\n                        'parameters': {\n                            'allowedCardNetworks': this.getCardTypes(),\n                            'billingAddressRequired': true,\n                            'billingAddressParameters': {\n                                format: 'FULL',\n                                phoneNumberRequired: true\n                            }\n                        }\n\n                    }\n                ],\n                shippingAddressRequired: true,\n                shippingAddressParameters: {\n                    phoneNumberRequired: true\n                },\n                emailRequired: true\n            };\n\n            if (this.getEnvironment() !== 'TEST') {\n                result.merchantInfo = { merchantId: this.getMerchantId() };\n            }\n\n            return result;\n        },\n\n        /**\n         * Place the order\n         */\n        startPlaceOrder: function (deviceData) {\n            let self = this,\n                payload = {\n                    details: {\n                        shippingAddress: self.getShippingAddressData(),\n                        billingAddress: self.getBillingAddressData()\n                    },\n                    nonce: parsedResponseModel.getNonce(),\n                    isNetworkTokenized: parsedResponseModel.getIsNetworkTokenized(),\n                    deviceData: deviceData\n                };\n\n            self.email = paymentDataModel.getEmail();\n            self.paymentMethodNonce = parsedResponseModel.getNonce();\n            self.creditCardBin = parsedResponseModel.getBin();\n\n            if (parsedResponseModel.getIsNetworkTokenized() === false) {\n                /* Add 3D Secure verification to payment & validate payment for non network tokenized cards */\n                self.addThreeDSecureValidator();\n\n                self.validatorManager.validate(self, function () {\n                    /* Set the new nonce from the 3DS verification */\n                    payload.nonce = self.paymentMethodNonce;\n\n                    return formBuilder.build({\n                        action: self.getActionSuccess(),\n                        fields: {\n                            result: JSON.stringify(payload)\n                        }\n                    }).submit();\n                }, function () {\n                    self.paymentMethodNonce = null;\n                    self.creditCardBin = null;\n                });\n            } else {\n                formBuilder.build({\n                    action: this.getActionSuccess(),\n                    fields: {\n                        result: JSON.stringify(payload)\n                    }\n                }).submit();\n            }\n        },\n\n        /**\n         * Get the shipping address from the payment data model which should already be set by the calling script.\n         *\n         * @return {?Object}\n         */\n        getShippingAddressData: function () {\n            let shippingAddress = paymentDataModel.getShippingAddress();\n\n            if (shippingAddress === null) {\n                return null;\n            }\n\n            return {\n                streetAddress: shippingAddress.address1 + '\\n' + shippingAddress.address2,\n                locality: shippingAddress.locality,\n                postalCode: shippingAddress.postalCode,\n                countryCodeAlpha2: shippingAddress.countryCode,\n                email: paymentDataModel.getEmail(),\n                name: shippingAddress.name,\n                telephone: removeNonDigitCharacters(_.get(shippingAddress, 'phoneNumber', '')),\n                region: _.get(shippingAddress, 'administrativeArea', '')\n            };\n        },\n\n        /**\n         * Get the billing address from the payment data model which should already be set by the calling script.\n         *\n         * @return {?Object}\n         */\n        getBillingAddressData: function () {\n            let paymentMethodData = paymentDataModel.getPaymentMethodData(),\n                billingAddress = _.get(paymentMethodData, ['info', 'billingAddress'], null);\n\n            if (paymentMethodData === null) {\n                return null;\n            }\n\n\n            if (billingAddress === null) {\n                return null;\n            }\n\n            return {\n                streetAddress: billingAddress.address1 + '\\n' + billingAddress.address2,\n                locality: billingAddress.locality,\n                postalCode: billingAddress.postalCode,\n                countryCodeAlpha2: billingAddress.countryCode,\n                email: paymentDataModel.getEmail(),\n                name: billingAddress.name,\n                telephone: removeNonDigitCharacters(_.get(billingAddress, 'phoneNumber', '')),\n                region: _.get(billingAddress, 'administrativeArea', '')\n            };\n        },\n\n        /**\n         * Get the billing address data as required for 3D Secure verification.\n         *\n         * For First & last name, use a simple split by space.\n         *\n         * @return {?Object}\n         */\n        getThreeDSecureBillingAddressData: function () {\n            let paymentMethodData = paymentDataModel.getPaymentMethodData(),\n                billingAddress = _.get(paymentMethodData, ['info', 'billingAddress'], null);\n\n            if (paymentMethodData === null) {\n                return null;\n            }\n\n            if (billingAddress === null) {\n                return null;\n            }\n\n            return {\n                firstname: billingAddress.name.substring(0, billingAddress.name.indexOf(' ')),\n                lastname: billingAddress.name.substring(billingAddress.name.indexOf(' ') + 1),\n                telephone: removeNonDigitCharacters(_.get(billingAddress, 'phoneNumber', '')),\n                street: [\n                    billingAddress.address1,\n                    billingAddress.address2\n                ],\n                city: billingAddress.locality,\n                regionCode: _.get(billingAddress, 'administrativeArea', ''),\n                postcode: billingAddress.postalCode,\n                countryId: billingAddress.countryCode\n            };\n        },\n\n        /**\n         * Get the shipping address data as required for 3D Secure verification.\n         *\n         * For First & last name, use a simple split by space.\n         *\n         * @return {?Object}\n         */\n        getThreeDSecureShippingAddressData: function () {\n            let shippingAddress = paymentDataModel.getShippingAddress();\n\n            if (shippingAddress === null) {\n                return null;\n            }\n\n            return {\n                firstname: shippingAddress.name.substring(0, shippingAddress.name.indexOf(' ')),\n                lastname: shippingAddress.name.substring(shippingAddress.name.indexOf(' ') + 1),\n                telephone: removeNonDigitCharacters(_.get(shippingAddress, 'phoneNumber', '')),\n                street: [\n                    shippingAddress.address1,\n                    shippingAddress.address2\n                ],\n                city: shippingAddress.locality,\n                regionCode: _.get(shippingAddress, 'administrativeArea', ''),\n                postcode: shippingAddress.postalCode,\n                countryId: shippingAddress.countryCode\n            };\n        }\n    });\n});\n","PayPal_Braintree/js/googlepay/model/payment-data.js":"define([\n    'underscore',\n    'ko'\n], function (_, ko) {\n    'use strict';\n\n    let paymentMethodData = ko.observable(null),\n        email = ko.observable(null),\n        shippingAddress = ko.observable(null);\n\n    return {\n        paymentMethodData: paymentMethodData,\n        email: email,\n        shippingAddress: shippingAddress,\n\n        /**\n         * Get Google Pay payment method data details.\n         *\n         * @return {?Object}\n         */\n        getPaymentMethodData: function () {\n            return this.paymentMethodData();\n        },\n\n        /**\n         * Set Google Pay payment method data details.\n         *\n         * @param {?Object} value\n         * @return {void}\n         */\n        setPaymentMethodData: function (value) {\n            this.paymentMethodData(_.isObject(value) ? value : null);\n        },\n\n        /**\n         * Get Google Pay email.\n         *\n         * @return {?string}\n         */\n        getEmail: function () {\n            return this.email();\n        },\n\n        /**\n         * Set Google Pay email.\n         *\n         * @param {?string} value\n         * @return {void}\n         */\n        setEmail: function (value) {\n            this.email(_.isString(value) ? value : null);\n        },\n\n        /**\n         * Get Google Pay shipping address.\n         *\n         * @return {?Object}\n         */\n        getShippingAddress: function () {\n            return shippingAddress();\n        },\n\n        /**\n         * Set Google Pay shipping address.\n         *\n         * @param {?Object} value\n         * @return {void}\n         */\n        setShippingAddress: function (value) {\n            this.shippingAddress(_.isObject(value) ? value : null);\n        },\n\n        /**\n         * Reset data to default.\n         */\n        resetDefaultData: function () {\n            this.setPaymentMethodData(null);\n            this.setEmail(null);\n            this.setShippingAddress(null);\n        }\n    };\n});\n","PayPal_Braintree/js/googlepay/model/parsed-response.js":"define([\n    'underscore',\n    'ko'\n], function (_, ko) {\n    'use strict';\n\n    let nonce = ko.observable(null),\n        isNetworkTokenized = ko.observable(false),\n        bin = ko.observable(null);\n\n    return {\n        nonce: nonce,\n        isNetworkTokenized: isNetworkTokenized,\n        bin: bin,\n\n        /**\n         * Get the payment nonce.\n         *\n         * @return {?string}\n         */\n        getNonce: function () {\n            return this.nonce();\n        },\n\n        /**\n         * Set the payment nonce.\n         *\n         * @param {?string} value\n         * @return {void}\n         */\n        setNonce: function (value) {\n            this.nonce(_.isString(value) ? value : null);\n        },\n\n        /**\n         * Get is network tokenized property for used card.\n         *\n         * @return {boolean}\n         */\n        getIsNetworkTokenized: function () {\n            return this.isNetworkTokenized();\n        },\n\n        /**\n         * Set is network tokenized property for used card.\n         *\n         * @param {boolean} value\n         * @return {void}\n         */\n        setIsNetworkTokenized: function (value) {\n            this.isNetworkTokenized(_.isBoolean(value) ? value : false);\n        },\n\n        /**\n         * Get card bin.\n         *\n         * @return {?string}\n         */\n        getBin: function () {\n            return this.bin();\n        },\n\n        /**\n         * Set the card bin.\n         *\n         * @param {?string} value\n         * @return {void}\n         */\n        setBin: function (value) {\n            this.bin(_.isString(value) ? value : null);\n        },\n\n        /**\n         * Reset data to default.\n         */\n        resetDefaultData: function () {\n            this.setNonce(null);\n            this.setIsNetworkTokenized(false);\n            this.setBin(null);\n        }\n    };\n});\n","PayPal_Braintree/js/googlepay/implementations/shortcut.js":"/**\n * Braintree Google Pay mini cart payment method integration.\n **/\ndefine(\n    [\n        'uiComponent',\n        'PayPal_Braintree/js/googlepay/button',\n        'PayPal_Braintree/js/googlepay/api',\n        'domReady!'\n    ],\n    function (\n        Component,\n        button,\n        buttonApi\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                id: null,\n                clientToken: null,\n                merchantId: null,\n                currencyCode: null,\n                actionSuccess: null,\n                amount: null,\n                environment: 'TEST',\n                cardType: [],\n                btnColor: 0,\n                threeDSecure: null\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n\n                /* Add client token & environment to 3DS Config */\n                this.threeDSecure.clientToken = this.clientToken;\n                this.threeDSecure.environment = this.environment;\n\n                let api = new buttonApi();\n\n                api.setEnvironment(this.environment);\n                api.setCurrencyCode(this.currencyCode);\n                api.setClientToken(this.clientToken);\n                api.setMerchantId(this.merchantId);\n                api.setActionSuccess(this.actionSuccess);\n                api.setAmount(this.amount);\n                api.setCardTypes(this.cardTypes);\n                api.setBtnColor(this.btnColor);\n                api.setThreeDSecureValidatorConfig(this.threeDSecure);\n\n                // Attach the button\n                button.init(\n                    document.getElementById(this.id),\n                    api\n                );\n\n                return this;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/googlepay/implementations/shortcut/adapter.js":"/*browser:true*/\ndefine([\n    'underscore',\n    'jquery',\n    'mage/translate',\n    'braintree',\n    'PayPal_Braintree/js/model/full-screen-loader',\n    'Magento_Ui/js/model/messageList'\n], function (\n    _,\n    $,\n    $t,\n    client,\n    defaultFullScreenLoader,\n    globalMessageList\n) {\n    'use strict';\n\n    /**\n     * Braintree Client adapter implementation generic enough to be used for GooglePay button payments.\n     *\n     * This can be used in other pages along with the basket page, but not in the checkout page when placing an order.\n     */\n    return {\n        fullScreenLoader: defaultFullScreenLoader,\n        apiClient: null,\n        config: {},\n        checkout: null,\n        clientInstance: null,\n        code: 'braintree',\n\n        /**\n         * {Object}\n         */\n        events: {\n            onClick: null,\n            onCancel: null,\n            onError: null\n        },\n\n        /**\n         * Get Braintree api client.\n         *\n         * @returns {Object}\n         */\n        getApiClient: function () {\n            return this.clientInstance;\n        },\n\n        /**\n         * Set configuration.\n         *\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n\n            if (_.has(this.config, 'code')) {\n                this.code = this.config.code;\n            }\n        },\n\n        /**\n         * Get payment name.\n         *\n         * @returns {string}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get client token\n         *\n         * @returns {string|*}\n         */\n        getClientToken: function () {\n            return this.config.hasOwnProperty('clientToken') ? this.config.clientToken : null;\n        },\n\n        /**\n         * @returns {string}\n         */\n        getEnvironment: function () {\n            return this.config.hasOwnProperty('environment') ? this.config.environment : null;\n        },\n\n        /**\n         * Set fullscreen loader implementation allowing to use custom.\n         *\n         * @param {Function} fullScreenLoader\n         */\n        setFullScreenLoader: function (fullScreenLoader) {\n            this.fullScreenLoader = fullScreenLoader;\n        },\n\n        /**\n         * Get the full screen loader implementation.\n         *\n         * @return {Object}\n         */\n        getFullScreenLoader: function () {\n            return this.fullScreenLoader;\n        },\n\n        /**\n         * Show error message\n         *\n         * @param {string} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n\n            this.getFullScreenLoader().stopLoader(true);\n        },\n\n        /**\n         * Setup Braintree SDK.\n         *\n         * @param {Function|null} callback\n         */\n        setup: function (callback = null) {\n            if (!this.getClientToken()) {\n                this.showError($t('Sorry, but something went wrong.'));\n                return;\n            }\n\n            if (this.clientInstance) {\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onReady(this);\n                }\n\n                if (typeof callback === 'function') {\n                    callback(this.clientInstance);\n                }\n\n                return;\n            }\n\n            client.create({\n                authorization: this.getClientToken()\n            }, function (clientErr, clientInstance) {\n                if (clientErr) {\n                    console.error('Braintree Setup Error', clientErr);\n                    return this.showError('Sorry, but something went wrong. Please contact the store owner.');\n                }\n\n                this.clientInstance = clientInstance;\n\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onReady(this);\n                }\n\n                if (typeof callback === 'function') {\n                    callback(this.clientInstance);\n                }\n            }.bind(this));\n        }\n    };\n});\n","PayPal_Braintree/js/googlepay/implementations/shortcut/3d-secure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'underscore',\n    'jquery',\n    'mage/translate',\n    'braintreeThreeDSecure',\n    'PayPal_Braintree/js/googlepay/implementations/shortcut/adapter',\n    'PayPal_Braintree/js/helper/remove-non-digit-characters',\n    'PayPal_Braintree/js/helper/format-amount',\n    'PayPal_Braintree/js/model/full-screen-loader'\n], function (\n    _,\n    $,\n    $t,\n    threeDSecure,\n    braintree,\n    removeNonDigitCharacters,\n    formatAmount,\n    defaultFullScreenLoader\n) {\n    'use strict';\n\n    /**\n     * 3D Secure implementation generic enough to be used for GooglePay button payments.\n     *\n     * This can be used in other pages along with the basket page, but not in the checkout page when placing an order.\n     */\n    return {\n        code: 'three_d_secure',\n        fullScreenLoader: defaultFullScreenLoader,\n        config: null,\n        billingAddress: null,\n        shippingAddress: null,\n        totalAmount: null,\n\n        /**\n         * Get code.\n         *\n         * @returns {string}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         *\n         * @return {boolean}\n         */\n        isEnabled: function () {\n            return this.config !== null ? _.get(this.config, ['enabled'], false) : false;\n        },\n\n        /**\n         * Set the full screen loader implementation.\n         *\n         * @param fullScreenLoader\n         */\n        setFullScreenLoader: function (fullScreenLoader) {\n            this.fullScreenLoader = fullScreenLoader;\n        },\n\n        /**\n         * Get the full screen loader implementation.\n         */\n        getFullScreenLoader: function () {\n            return this.fullScreenLoader;\n        },\n\n        /**\n         * Set 3d secure config.\n         *\n         * @param {object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n            this.config.thresholdAmount = parseFloat(_.get(config, 'thresholdAmount', '0.0'));\n        },\n\n        /**\n         * Get the billing address data.\n         */\n        getBillingAddress: function () {\n            return this.billingAddress;\n        },\n\n        /**\n         * Set the billing address data.\n         *\n         * @param {object} value\n         */\n        setBillingAddress: function (value) {\n            this.billingAddress = value;\n        },\n\n        /**\n         * Get the shipping address data.\n         */\n        getShippingAddress: function () {\n            return this.shippingAddress;\n        },\n\n        /**\n         * Set the shipping address data.\n         *\n         * @param {object} value\n         */\n        setShippingAddress: function (value) {\n            this.shippingAddress = value;\n        },\n\n        /**\n         * Get the total amount to be charged.\n         */\n        getTotalAmount: function () {\n            return this.totalAmount;\n        },\n\n        /**\n         * Set the full screen loader implementation.\n         *\n         * @param {string} value\n         */\n        setTotalAmount: function (value) {\n            this.totalAmount = formatAmount(value);\n        },\n\n        /**\n         * Get the Braintree environment.\n         *\n         * @return {string|null}\n         */\n        getEnvironment: function () {\n            return _.get(this.config, 'environment', 'TEST');\n        },\n\n        /**\n         * Get the Braintree Client Token.\n         *\n         * @return {string|null}\n         */\n        getClientToken: function () {\n            return _.get(this.config, 'clientToken', null);\n        },\n\n        /**\n         * Check minimal amount for 3d secure activation.\n         *\n         * @param {Number} amount\n         * @returns {Boolean}\n         */\n        isAmountAvailable: function (amount) {\n            amount = parseFloat(amount.toString());\n\n            return amount >= this.config.thresholdAmount;\n        },\n\n        /**\n         * Check if current country is available for 3d secure.\n         *\n         * @param {String} countryId\n         * @returns {Boolean}\n         */\n        isCountryAvailable: function (countryId) {\n            let key,\n                specificCountries = _.get(this.config, 'specificCountries', []);\n\n            // all countries are available\n            if (!specificCountries.length) {\n                return true;\n            }\n\n            for (key in specificCountries) {\n                if (countryId === specificCountries[key]) {\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Check billing/shipping address line lengths\n         *\n         * @param errorMessage\n         * @param billingAddress\n         * @param shippingAddress\n         * @returns {*}\n         */\n        checkBillingLineLengths: function (errorMessage, billingAddress, shippingAddress) {\n            let lineError = null;\n\n            if (billingAddress.street[0].length > 50 ||\n                (shippingAddress.street !== undefined && shippingAddress.street[0].length > 50)) {\n                lineError = 'line1';\n            } else if (billingAddress.street[1].length > 50 ||\n                (shippingAddress.street !== undefined && shippingAddress.street[1].length > 50)) {\n                lineError = 'line2';\n            }\n\n            if (lineError) {\n                let error = `Billing/Shipping ${lineError} must be string and less than 50 characters.`;\n\n                return $t(`${error} Please update the address and try again.`);\n            }\n        },\n\n        /**\n         * Get the challenge requested config (default false).\n         *\n         * @returns {Boolean}\n         */\n        getChallengeRequested: function () {\n            return _.get(this.config, 'challengeRequested', false);\n        },\n\n        /**\n         * Get Customer's IP Address\n         *\n         * @returns {Boolean}\n         */\n        getIpAddress: function () {\n            return _.get(this.config, 'ipAddress', '');\n        },\n\n        /**\n         * Trigger 3DS verification & validate Braintree payment nonce.\n         *\n         * @param {Object} context\n         * @returns {Object}\n         */\n        validate: function (context) {\n            let self = this,\n                clientInstance = braintree.getApiClient(),\n                state = $.Deferred(),\n                billingAddress = self.getBillingAddress(),\n                shippingAddress = self.getShippingAddress(),\n                setup3d;\n\n            // Handle billing address region code\n            if (billingAddress.regionCode == null) {\n                billingAddress.regionCode = undefined;\n            }\n            if (billingAddress.regionCode !== undefined && billingAddress.regionCode.length > 2) {\n                billingAddress.regionCode = undefined;\n            }\n\n            // Handle shipping address region code\n            if (shippingAddress.regionCode == null) {\n                shippingAddress.regionCode = undefined;\n            }\n            if (shippingAddress.regionCode !== undefined && shippingAddress.regionCode.length > 2) {\n                shippingAddress.regionCode = undefined;\n            }\n\n            if (!self.isAmountAvailable(self.getTotalAmount()) || !self.isCountryAvailable(billingAddress.countryId)) {\n                state.resolve();\n                return state.promise();\n            }\n\n            self.getFullScreenLoader().startLoader();\n\n            setup3d = function (client) {\n                threeDSecure.create({\n                    version: 2,\n                    client: client\n                }, function (threeDSecureErr, threeDSecureInstance) {\n                    if (threeDSecureErr) {\n                        self.getFullScreenLoader().stopLoader();\n                        return state.reject($t('Please try again with another form of payment.'));\n                    }\n\n                    let threeDSContainer = document.createElement('div'),\n                        tdMask = document.createElement('div'),\n                        tdFrame = document.createElement('div'),\n                        tdBody = document.createElement('div'),\n                        threeDSecureParameters;\n\n                    threeDSContainer.className = 'braintree-three-d-modal';\n                    tdMask.className = 'bt-mask';\n                    tdFrame.className = 'bt-modal-frame';\n                    tdBody.className = 'bt-modal-body';\n\n                    tdFrame.appendChild(tdBody);\n                    threeDSContainer.appendChild(tdMask);\n                    threeDSContainer.appendChild(tdFrame);\n\n                    threeDSecureParameters = {\n                        amount: self.getTotalAmount(),\n                        nonce: context.paymentMethodNonce,\n                        bin: context.creditCardBin,\n                        collectDeviceData: true,\n                        challengeRequested: self.getChallengeRequested(),\n                        billingAddress: {\n                            givenName: billingAddress.firstname,\n                            surname: billingAddress.lastname,\n                            phoneNumber: billingAddress.telephone !== null\n                                ? removeNonDigitCharacters(billingAddress.telephone)\n                                : billingAddress.telephone,\n                            streetAddress: billingAddress.street[0],\n                            extendedAddress: billingAddress.street[1],\n                            locality: billingAddress.city,\n                            region: billingAddress.regionCode,\n                            postalCode: billingAddress.postcode,\n                            countryCodeAlpha2: billingAddress.countryId\n                        },\n                        additionalInformation: {\n                            shippingGivenName: shippingAddress.firstname,\n                            shippingSurname: shippingAddress.lastname,\n                            shippingAddress: {\n                                streetAddress: shippingAddress.street[0],\n                                extendedAddress: shippingAddress.street[1],\n                                locality: shippingAddress.city,\n                                region: shippingAddress.regionCode,\n                                postalCode: shippingAddress.postcode,\n                                countryCodeAlpha2: shippingAddress.countryId\n                            },\n                            shippingPhone: shippingAddress.telephone !== null\n                                ? removeNonDigitCharacters(shippingAddress.telephone)\n                                : shippingAddress.telephone,\n                            ipAddress: self.getIpAddress()\n                        },\n                        onLookupComplete: function (data, next) {\n                            next();\n                        },\n                        addFrame: function (err, iframe) {\n                            self.getFullScreenLoader().stopLoader();\n\n                            if (err) {\n                                console.log('Unable to verify card over 3D Secure', err);\n                                return state.reject($t('Please try again with another form of payment.'));\n                            }\n\n                            tdBody.appendChild(iframe);\n                            document.body.appendChild(threeDSContainer);\n                        },\n                        removeFrame: function () {\n                            self.getFullScreenLoader().startLoader();\n                            document.body.removeChild(threeDSContainer);\n                        }\n                    };\n\n                    if (_.has(context, 'email') && context.email !== null) {\n                        threeDSecureParameters.email = context.email;\n                    }\n\n                    threeDSecureInstance.verifyCard(threeDSecureParameters, function (err, response) {\n                        self.getFullScreenLoader().stopLoader();\n\n                        if (err) {\n                            console.error('3DSecure validation failed', err);\n                            if (err.code === 'THREEDS_LOOKUP_VALIDATION_ERROR') {\n                                let errorMessage = err.details.originalError.details.originalError.error.message,\n                                    error = self.checkBillingLineLengths(errorMessage, billingAddress, shippingAddress);\n\n                                return error ? state.reject(error) : state.reject($t(errorMessage));\n                            }\n\n                            return state.reject($t('Please try again with another form of payment.'));\n                        }\n\n                        let liability = {\n                            shifted: response.liabilityShifted,\n                            shiftPossible: response.liabilityShiftPossible\n                        };\n\n                        if (liability.shifted || !liability.shifted && !liability.shiftPossible) {\n                            context.paymentMethodNonce = response.nonce;\n                            state.resolve();\n                        } else {\n                            state.reject($t('Please try again with another form of payment.'));\n                        }\n                    }.bind(this));\n                });\n            };\n\n            if (!clientInstance) {\n                self.createClientInstance(setup3d);\n            } else {\n                setup3d(clientInstance);\n            }\n\n            return state.promise();\n        },\n\n        /**\n         * Create a Braintree client instance with simplified form.\n         *\n         * @param {Function} setupThreeDSecureCallback\n         * @return {*}\n         */\n        createClientInstance: function (setupThreeDSecureCallback) {\n            let self = this;\n\n            return require(['PayPal_Braintree/js/googlepay/implementations/shortcut/form'], function (c) {\n                c.defaults.clientConfig.clientToken = self.getClientToken();\n                c.defaults.clientConfig.environment = self.getEnvironment();\n                braintree.setConfig(c.defaults.clientConfig);\n                braintree.setup(setupThreeDSecureCallback);\n            });\n        }\n    };\n});\n","PayPal_Braintree/js/googlepay/implementations/shortcut/form.js":"/*browser:true*/\ndefine([\n    'underscore',\n    'jquery',\n    'uiComponent'\n], function (_, $, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            braintreeClient: null,\n            code: 'braintree',\n            isProcessing: false,\n\n            /**\n             * Braintree client configuration\n             *\n             * {Object}\n             */\n            clientConfig: {\n                onReady: function () {},\n\n                /**\n                 * Triggers on payment nonce receive\n                 */\n                onPaymentMethodReceived: function () {\n                    this.isProcessing = false;\n                },\n\n                /**\n                 * Allow a new nonce to be generated\n                 */\n                onPaymentMethodError: function () {\n                    this.isProcessing = false;\n                },\n\n                /**\n                 * After Braintree instance initialization\n                 */\n                onInstanceReady: function () {},\n\n                /**\n                 * Triggers on any Braintree error\n                 * @param {Object} response\n                 */\n                onError: function (response) {\n                    this.isProcessing = false;\n                    throw response.message;\n                },\n\n                /**\n                 * Triggers when customer click \"Cancel\"\n                 */\n                onCancelled: function () {\n                    this.isProcessing = false;\n                }\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         *\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            this._super();\n\n            this.initClientConfig();\n\n            return this;\n        },\n\n        /**\n         * Get payment name\n         *\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n        }\n    });\n});\n","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-googlepay.js":"define([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    let config = window.checkoutConfig.payment;\n\n    if (config['braintree_googlepay'].clientToken) {\n        rendererList.push({\n            type: 'braintree_googlepay',\n            component: 'PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay'\n        });\n    }\n\n    return Component.extend({});\n});\n","PayPal_Braintree/js/googlepay/implementations/core-checkout/method-renderer/googlepay.js":"/**\n * Braintree Google Pay payment method integration.\n **/\ndefine([\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'PayPal_Braintree/js/googlepay/button',\n    'PayPal_Braintree/js/googlepay/model/parsed-response',\n    'PayPal_Braintree/js/view/payment/validator-handler'\n], function (\n    _,\n    Component,\n    quote,\n    VaultEnabler,\n    GooglePayButton,\n    parsedResponseModel,\n    validatorManager\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/googlepay/core-checkout',\n            validatorManager: validatorManager,\n            paymentMethodNonce: null,\n            creditCardBin: null,\n            deviceData: null,\n            grandTotalAmount: 0,\n            vaultEnabler: null,\n            additionalData: {}\n        },\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * Inject the Google Pay button into the target element\n         */\n        getGooglePayBtn: function (id) {\n            GooglePayButton.init(\n                document.getElementById(id),\n                this\n            );\n        },\n\n        /**\n         * Subscribe to grand totals\n         */\n        initObservable: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            this.validatorManager.initialize();\n\n            this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n            this.currencyCode = quote.totals()['base_currency_code'];\n\n            quote.totals.subscribe(function () {\n                if (this.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Google Pay place order method\n         */\n        startPlaceOrder: function (device_data) {\n            let self = this;\n\n            /* Set the nonce & bin and trigger 3DS if card is not network tokenized */\n            self.paymentMethodNonce = parsedResponseModel.getNonce();\n            self.creditCardBin = parsedResponseModel.getBin();\n\n            if (parsedResponseModel.getIsNetworkTokenized() === false) {\n                // place order on success validation\n                self.validatorManager.validate(self, function () {\n                    self.setDeviceData(device_data);\n                    return self.placeOrder('parent');\n                }, function () {\n                    self.paymentMethodNonce = null;\n                    self.creditCardBin = null;\n                });\n            } else {\n                self.setDeviceData(device_data);\n                self.placeOrder();\n            }\n        },\n\n        /**\n         * Save device_data\n         */\n        setDeviceData: function (device_data) {\n            this.deviceData = device_data;\n        },\n\n        /**\n         * Retrieve the client token\n         * @returns null|string\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Payment request info\n         */\n        getPaymentRequest: function () {\n            let result = {\n                transactionInfo: {\n                    totalPriceStatus: 'FINAL',\n                    totalPrice: this.grandTotalAmount,\n                    currencyCode: this.currencyCode\n                },\n                allowedPaymentMethods: [\n                    {\n                        'type': 'CARD',\n                        'parameters': {\n                            'allowedCardNetworks': this.getCardTypes(),\n                            'billingAddressRequired': true,\n                            'billingAddressParameters': {\n                                format: 'FULL',\n                                phoneNumberRequired: true\n                            }\n                        }\n\n                    }\n                ],\n                shippingAddressRequired: false,\n                emailRequired: false\n            };\n\n            if (this.getEnvironment() !== 'TEST') {\n                result.merchantInfo = { merchantId: this.getMerchantId() };\n            }\n\n            return result;\n        },\n\n        /**\n         * Merchant display name\n         */\n        getMerchantId: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantId;\n        },\n\n        /**\n         * Environment\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.payment[this.getCode()].environment;\n        },\n\n        /**\n         * Card Types\n         */\n        getCardTypes: function () {\n            return window.checkoutConfig.payment[this.getCode()].cardTypes;\n        },\n\n        /**\n         * BTN Color\n         */\n        getBtnColor: function () {\n            return window.checkoutConfig.payment[this.getCode()].btnColor;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            let data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce,\n                    'device_data': this.deviceData,\n                    'is_network_tokenized': parsedResponseModel.getIsNetworkTokenized()\n                }\n            };\n\n            if (parsedResponseModel.getIsNetworkTokenized() === false) {\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n                this.vaultEnabler.visitAdditionalData(data);\n            }\n\n            return data;\n        },\n\n        /**\n         * Return image url for the Google Pay mark\n         */\n        getPaymentMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].vaultCode;\n        }\n    });\n});\n","PayPal_Braintree/js/lpm/process-fallback-response.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Customer/js/customer-data',\n    'Magento_Checkout/js/model/quote',\n    'jquery',\n    'braintree',\n    'braintreeLpm',\n    'PayPal_Braintree/js/model/full-screen-loader',\n    'mage/translate',\n    'underscore'\n], function (Component, customerData, quote, $, braintree, lpm, fullScreenLoader, $t, _) {\n    'use strict';\n\n    return Component.extend({\n        code: 'braintree_local_payment',\n        paymentMethodNonce: null,\n        config: {\n            clientToken: null,\n            merchantAccountId: null,\n            redirectOnFail: null\n        },\n\n        /**\n         * Initialize config values\n         *\n         * @param config\n         */\n        initialize: function (config) {\n            this._super();\n            this.config.clientToken = config.clientToken;\n            this.config.merchantAccountId = config.merchantAccountId;\n            this.config.redirectOnFail = config.redirectOnFail;\n            this.setupLpmFallback();\n        },\n\n        /**\n         * Setup local payment fallback scenario\n         */\n        setupLpmFallback: function () {\n            let self = this;\n\n            fullScreenLoader.startLoader();\n\n            braintree.create({\n                authorization: self.config.clientToken\n            }, function (clientError, clientInstance) {\n                if (clientError) {\n                    self.redirectCustomerOnFailure($t('Unable to initialize Braintree Client.'));\n                    return;\n                }\n\n                lpm.create({\n                    client: clientInstance,\n                    merchantAccountId: self.config.merchantAccountId\n                }, function (lpmError, lpmInstance) {\n                    if (lpmError) {\n                        self.redirectCustomerOnFailure($t(lpmError.message));\n                    }\n\n                    if (lpmInstance.hasTokenizationParams()) {\n                        lpmInstance.tokenize(function (tokenizeError, payload) {\n                            if (tokenizeError) {\n                                self.redirectCustomerOnFailure($t(tokenizeError.message));\n                            } else {\n                                // Send the nonce to the server to create a transaction\n                                self.setPaymentMethodNonce(payload.nonce);\n                                self.isPlaceOrderActionAllowed(true);\n\n                                if (!window.checkoutConfig.isCustomerLoggedIn) {\n                                    // Set the email to the quote.\n                                    let checkoutData = customerData.get('checkout-data')();\n\n                                    quote.guestEmail = checkoutData.inputFieldEmailValue;\n                                }\n\n                                // Check all agreements if any available.\n                                let agreements = $('.checkout-agreements input[type=\"checkbox\"]');\n\n                                if (agreements.length) {\n                                    agreements.prop('checked', true);\n                                }\n\n                                self.placeOrder();\n                            }\n                        });\n                    } else {\n                        let error = 'Payment can not be processed as invalid parameters received';\n\n                        self.redirectCustomerOnFailure($t(error));\n                    }\n                });\n            });\n        },\n\n        /**\n         * Get code\n         *\n         * @returns {string}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Set payment method nonce\n         *\n         * @param nonce\n         */\n        setPaymentMethodNonce: function (nonce) {\n            this.paymentMethodNonce = nonce;\n        },\n\n        /**\n         * Get data\n         *\n         * @returns {{additional_data: {payment_method_nonce: null}, method: string}}\n         */\n        getData: function () {\n            let data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        },\n\n        /**\n         * redirect customer to the configured page if any error/failure/cancelled.\n         */\n        redirectCustomerOnFailure: function (message) {\n            if (message) {\n                let braintreeData = customerData.get('braintree')(),\n                    errors = braintreeData.errors || [];\n\n                errors.push(message);\n\n                customerData.set('braintree', { errors: errors });\n            }\n\n            window.location.href = this.config.redirectOnFail;\n        }\n    });\n});\n","PayPal_Braintree/js/reCaptcha/webapiReCaptchaRegistry-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function (originalFunction) {\n        /**\n         * {@inheritDoc}\n         */\n        originalFunction.addListener = function (id , func) {\n            this._listeners[id] = func;\n        };\n\n        return originalFunction;\n    };\n});\n","PayPal_Braintree/js/paypal/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/paypal/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'rjsResolver',\n        'uiRegistry',\n        'uiComponent',\n        'underscore',\n        'jquery',\n        'Magento_Customer/js/customer-data',\n        'mage/translate',\n        'braintree',\n        'braintreeCheckoutPayPalAdapter',\n        'braintreeDataCollector',\n        'braintreePayPalCheckout',\n        'PayPal_Braintree/js/form-builder',\n        'PayPal_Braintree/js/helper/remove-non-digit-characters',\n        'PayPal_Braintree/js/helper/replace-single-quote-character',\n        'domReady!'\n    ],\n    function (\n        resolver,\n        registry,\n        Component,\n        _,\n        $,\n        customerData,\n        $t,\n        braintree,\n        Braintree,\n        dataCollector,\n        paypalCheckout,\n        formBuilder,\n        removeNonDigitCharacters,\n        replaceSingleQuoteCharacter\n    ) {\n        'use strict';\n\n        return {\n            events: {\n                onClick: null,\n                onCancel: null,\n                onError: null\n            },\n\n            /**\n             * Initialize button\n             *\n             * @param buttonConfig\n             * @param lineItems\n             */\n            init: function (buttonConfig, lineItems) {\n                if ($('.action-braintree-paypal-message').length) {\n                    $('.product-add-form form').on('keyup change paste', 'input, select, textarea', function () {\n                        let currentPrice, currencySymbol;\n\n                        currentPrice = $('.product-info-main span').find('[data-price-type=\\'finalPrice\\']').text();\n                        currencySymbol = $('.action-braintree-paypal-message[data-pp-type=\"product\"]')\n                            .data('currency-symbol');\n                        $('.action-braintree-paypal-message[data-pp-type=\"product\"]')\n                            .attr('data-pp-amount', currentPrice.replace(currencySymbol,''));\n                    });\n                }\n\n                this.loadSDK(buttonConfig, lineItems);\n\n                window.addEventListener('hashchange', function () {\n                    const step = window.location.hash.replace('#', '');\n\n                    if (step === 'shipping') {\n                        Braintree.getPayPalInstance().teardown(function () {\n                            this.loadSDK(buttonConfig, lineItems);\n                        }.bind(this));\n                    }\n\n                }.bind(this));\n\n                window.addEventListener('paypal:reinit-express', function () {\n                    this.loadSDK(buttonConfig, lineItems);\n                }.bind(this));\n            },\n\n            /**\n             * Load Braintree PayPal SDK\n             *\n             * @param buttonConfig\n             * @param lineItems\n             */\n            loadSDK: function (buttonConfig, lineItems) {\n                braintree.create({\n                    authorization: buttonConfig.clientToken\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('paypalCheckout error', clientErr);\n                        let error = 'PayPal Checkout could not be initialized. Please contact the store owner.';\n\n                        return this.showError(error);\n                    }\n                    dataCollector.create({\n                        client: clientInstance,\n                        paypal: true\n                    }, function (err) {\n                        if (err) {\n                            return console.log(err);\n                        }\n                    });\n                    paypalCheckout.create({\n                        client: clientInstance\n                    }, function (err, paypalCheckoutInstance) {\n                        Braintree.setPayPalInstance(paypalCheckoutInstance);\n                        let configSDK = {\n                                components: 'buttons,messages,funding-eligibility',\n                                'enable-funding': this.isCreditActive(buttonConfig) ? 'credit' : 'paylater',\n                                currency: buttonConfig.currency\n                            },\n\n                            buyerCountry = this.getMerchantCountry(buttonConfig);\n\n                        if (buttonConfig.environment === 'sandbox'\n                            && (buyerCountry !== '' || buyerCountry !== 'undefined'))\n                        {\n                            configSDK['buyer-country'] = buyerCountry;\n                        }\n                        paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                            this.renderPayPalButtons(paypalCheckoutInstance, lineItems);\n                            this.renderPayPalMessages();\n                        }.bind(this));\n                    }.bind(this));\n                }.bind(this));\n            },\n\n            /**\n             * Is Credit enabled\n             *\n             * @param buttonConfig\n             * @returns {boolean}\n             */\n            isCreditActive: function (buttonConfig) {\n                return buttonConfig.isCreditActive;\n            },\n\n            /**\n             * Get merchant country\n             *\n             * @param buttonConfig\n             * @returns {string}\n             */\n            getMerchantCountry: function (buttonConfig) {\n                return buttonConfig.merchantCountry;\n            },\n\n            /**\n             * Render PayPal buttons\n             *\n             * @param paypalCheckoutInstance\n             * @param lineItems\n             */\n            renderPayPalButtons: function (paypalCheckoutInstance, lineItems) {\n                this.payPalButton(paypalCheckoutInstance, lineItems);\n            },\n\n            /**\n             * Render PayPal messages\n             */\n            renderPayPalMessages: function () {\n                $('.action-braintree-paypal-message').each(function () {\n                    window.paypal.Messages({\n                        amount: $(this).data('pp-amount'),\n                        pageType: $(this).data('pp-type'),\n                        style: {\n                            layout: $(this).data('messaging-layout'),\n                            text: {\n                                color:   $(this).data('messaging-text-color')\n                            },\n                            logo: {\n                                type: $(this).data('messaging-logo'),\n                                position: $(this).data('messaging-logo-position')\n                            }\n                        }\n                    }).render('#' + $(this).attr('id'));\n\n\n                });\n            },\n\n            /**\n             * @param paypalCheckoutInstance\n             * @param lineItems\n             */\n            payPalButton: function (paypalCheckoutInstance, lineItems) {\n                $('.action-braintree-paypal-logo').each(function () {\n                    let currentElement = $(this),\n                        style = {\n                            label: currentElement.data('label'),\n                            color: currentElement.data('color'),\n                            shape: currentElement.data('shape')\n                        },\n                        button;\n\n                    if (currentElement.data('fundingicons')) {\n                        style.fundingicons = currentElement.data('fundingicons');\n                    }\n\n                    // Render\n                    button = window.paypal.Buttons({\n                        fundingSource: currentElement.data('funding'),\n                        style: style,\n                        createOrder: function () {\n                            return paypalCheckoutInstance.createPayment({\n                                amount: currentElement.data('amount'),\n                                locale: currentElement.data('locale'),\n                                currency: currentElement.data('currency'),\n                                flow: 'checkout',\n                                enableShippingAddress: true,\n                                displayName: currentElement.data('displayname'),\n                                lineItems: JSON.parse(lineItems)\n                            });\n                        },\n                        validate: function (actions) {\n                            let cart = customerData.get('cart'),\n                                customer = customerData.get('customer'),\n                                declinePayment = false,\n                                isGuestCheckoutAllowed;\n\n                            isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n                            declinePayment = !customer().firstname && !isGuestCheckoutAllowed\n                                && typeof isGuestCheckoutAllowed !== 'undefined';\n\n                            if (declinePayment) {\n                                actions.disable();\n                            }\n                        },\n\n                        onCancel: function () {\n                            jQuery('#maincontent').trigger('processStop');\n                        },\n\n                        onError: function (errorData) {\n                            console.error('paypalCheckout button render error', errorData);\n                            jQuery('#maincontent').trigger('processStop');\n                        },\n\n                        onClick: function () {\n                            if (currentElement.data('location') === 'productpage') {\n                                let form = $('#product_addtocart_form');\n\n                                if (!(form.validation() && form.validation('isValid'))) {\n                                    return false;\n                                }\n                            }\n\n                            let cart = customerData.get('cart'),\n                                customer = customerData.get('customer'),\n                                declinePayment = false,\n                                isGuestCheckoutAllowed;\n\n                            isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n                            declinePayment = !customer().firstname && !isGuestCheckoutAllowed\n                                && typeof isGuestCheckoutAllowed !== 'undefined';\n                            if (declinePayment) {\n                                // eslint-disable-next-line\n                                alert($t('To check out, please sign in with your email address.'));\n                            }\n                        },\n\n                        onApprove: function (approveData) {\n                            return paypalCheckoutInstance.tokenizePayment(approveData, function (err, payload) {\n                                jQuery('#maincontent').trigger('processStart');\n\n                                /* Set variables & default values for shipping/recipient name to billing */\n                                let accountFirstName = replaceSingleQuoteCharacter(payload.details.firstName),\n                                    accountLastName = replaceSingleQuoteCharacter(payload.details.lastName),\n                                    accountEmail = replaceSingleQuoteCharacter(payload.details.email),\n                                    recipientFirstName = accountFirstName,\n                                    recipientLastName = accountLastName,\n                                    address = payload.details.shippingAddress,\n                                    recipientName = null,\n                                    actionSuccess,\n                                    isRequiredBillingAddress,\n                                    phone = _.get(payload, ['details', 'phone'], '');\n\n                                // Map the shipping address correctly\n                                if (!_.isUndefined(address.recipientName) && _.isString(address.recipientName)) {\n                                    /*\n                                         * Trim leading/ending spaces before splitting,\n                                         * filter to remove array keys with empty values\n                                         * & set to variable.\n                                         */\n                                    recipientName = address.recipientName.trim().split(' ').filter(n => n);\n                                }\n\n                                /*\n                                     * If the recipientName is not null, and it is an array with\n                                     * first/last name, use it. Otherwise, keep the default billing first/last name.\n                                     * This is to avoid cases of old accounts where spaces were allowed to first or\n                                     * last name in PayPal and the result was an array with empty fields\n                                     * resulting in empty names in the system.\n                                     */\n                                if (!_.isNull(recipientName) && !_.isUndefined(recipientName[1])) {\n                                    recipientFirstName = replaceSingleQuoteCharacter(recipientName[0]);\n                                    recipientLastName = replaceSingleQuoteCharacter(recipientName[1]);\n                                }\n\n                                payload.details.shippingAddress = {\n                                    streetAddress: typeof address.line2 !== 'undefined' && _.isString(address.line2)\n                                        ? replaceSingleQuoteCharacter(address.line1)\n                                                + ' ' + replaceSingleQuoteCharacter(address.line2)\n                                        : replaceSingleQuoteCharacter(address.line1),\n                                    locality: replaceSingleQuoteCharacter(address.city),\n                                    postalCode: address.postalCode,\n                                    countryCodeAlpha2: address.countryCode,\n                                    email: accountEmail,\n                                    recipientFirstName: recipientFirstName,\n                                    recipientLastName: recipientLastName,\n                                    telephone: removeNonDigitCharacters(phone),\n                                    region: typeof address.state !== 'undefined'\n                                        ? replaceSingleQuoteCharacter(address.state)\n                                        : ''\n                                };\n\n                                payload.details.email = accountEmail;\n                                payload.details.firstName = accountFirstName;\n                                payload.details.lastName = accountLastName;\n                                if (typeof payload.details.businessName !== 'undefined'\n                                        && _.isString(payload.details.businessName)) {\n                                    payload.details.businessName\n                                            = replaceSingleQuoteCharacter(payload.details.businessName);\n                                }\n\n                                // Map the billing address correctly\n                                isRequiredBillingAddress = currentElement.data('requiredbillingaddress');\n\n                                if (isRequiredBillingAddress === 1\n                                            && typeof payload.details.billingAddress !== 'undefined') {\n                                    let billingAddress = payload.details.billingAddress;\n\n                                    payload.details.billingAddress = {\n                                        streetAddress: typeof billingAddress.line2 !== 'undefined'\n                                                && _.isString(billingAddress.line2)\n                                            ? replaceSingleQuoteCharacter(billingAddress.line1)\n                                                    + ' ' + replaceSingleQuoteCharacter(billingAddress.line2)\n                                            : replaceSingleQuoteCharacter(billingAddress.line1),\n                                        locality: replaceSingleQuoteCharacter(billingAddress.city),\n                                        postalCode: billingAddress.postalCode,\n                                        countryCodeAlpha2: billingAddress.countryCode,\n                                        telephone: removeNonDigitCharacters(phone),\n                                        region: typeof billingAddress.state !== 'undefined'\n                                            ? replaceSingleQuoteCharacter(billingAddress.state)\n                                            : ''\n                                    };\n                                }\n\n                                if (currentElement.data('location') === 'productpage') {\n                                    let form = $('#product_addtocart_form');\n\n                                    payload.additionalData = form.serialize();\n                                }\n\n                                actionSuccess = currentElement.data('actionsuccess');\n\n                                formBuilder.build(\n                                    {\n                                        action: actionSuccess,\n                                        fields: {\n                                            result: JSON.stringify(payload)\n                                        }\n                                    }\n                                ).submit();\n                            });\n                        }\n                    });\n\n                    if (!button.isEligible()) {\n                        console.log('PayPal button is not elligible');\n                        currentElement.parent().remove();\n                        return;\n                    }\n                    if (button.isEligible() && $('#' + currentElement.attr('id')).length) {\n                        button.render('#' + currentElement.attr('id'));\n                    }\n                });\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/paypal/product-page.js":"define(\n    ['PayPal_Braintree/js/paypal/button', 'jquery'],\n    function (button, $) {\n        'use strict';\n\n        return button.extend({\n\n            defaults: {\n                label: 'buynow',\n                branding: true\n            },\n\n            /**\n             * The validation on the add-to-cart form is done after the PayPal window has opened.\n             * This is because the validate method exposed by the PP Button requires an event to\n             * disable/enable the button.\n             * We can't fire an event due to the way the mage.validation widget works and we can't\n             * do something gross like an interval because the validation() method shows the error\n             * messages and focuses the user's input on the first erroring input field.\n             * @param payload\n             * @returns {*}\n             */\n            beforeSubmit: function (payload) {\n                var form = $('#product_addtocart_form');\n\n                if (!(form.validation() && form.validation('isValid'))) {\n                    return false;\n                }\n\n                payload.additionalData = form.serialize();\n\n                return payload;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/paypal/credit/calculator.js":"define([\n    'underscore',\n    'uiComponent'\n], function (_, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/credit/calculator',\n            displaySummary: true, // \"From X per month\"\n            displayInterestDetails: false, // Display the more in-depth summary of interest rates\n            instalmentsFrom: 0,\n            currentInstalment: {\n                term: 0,\n                monthlyPayment: 0,\n                apr: 0,\n                cost: 0,\n                costIncInterest: 0\n            },\n            endpoint: null,\n            instalments: [],\n            visible: false,\n            merchantName: ''\n        },\n\n        /**\n         * initialize and observe the default variables\n         *\n         * @returns {*}\n         */\n        initObservable: function () {\n            this._super();\n            if (this.instalments.length > 0) {\n                this.currentInstalment = this.instalments[0];\n                this.instalmentsFrom = this.instalments[this.instalments.length - 1].monthlyPayment;\n                this.visible = true;\n            } else {\n                this.loadInstalments();\n            }\n\n            this.observe(['instalments', 'currentInstalment', 'instalmentsFrom', 'visible']);\n            return this;\n        },\n\n        /**\n         * check current instalment\n         *\n         * @param term\n         * @returns {boolean}\n         */\n        isCurrentInstalment: function (term) {\n            return this.currentInstalment().term === term;\n        },\n\n        /**\n         * set current instalment\n         *\n         * @param instalment\n         */\n        setCurrentInstalment: function (instalment) {\n            this.currentInstalment(instalment);\n        },\n\n        /**\n         * load instalments\n         *\n         * @returns {boolean}\n         */\n        loadInstalments: function () {\n            if (!this.endpoint) {\n                return false;\n            }\n\n            let self = this;\n\n            require(['Magento_Checkout/js/model/quote', 'jquery'], function (quote, $) {\n                if (typeof quote.totals()['base_grand_total'] === 'undefined') {\n                    return false;\n                }\n\n                $.getJSON(self.endpoint, {amount: quote.totals()['base_grand_total']}, function (response) {\n                    self.instalments(response);\n                    self.setCurrentInstalment(response[0]);\n                    self.visible(true);\n                });\n            });\n        }\n    });\n});\n","PayPal_Braintree/js/model/step-navigator-mixin.js":"define([\n    'mage/utils/wrapper'\n], function (wrapper) {\n    'use strict';\n\n    let mixin = {\n        handleHash: function (originalFn) {\n            var hashString = window.location.hash.replace('#', '');\n\n            if (hashString.indexOf('venmo') > -1) {\n                return false;\n            }\n\n            return originalFn();\n        }\n    };\n\n    return function (target) {\n        return wrapper.extend(target, mixin);\n    };\n});\n","PayPal_Braintree/js/model/vault-enabler.js":"define([\n    'Magento_Vault/js/view/payment/vault-enabler'\n], function (VaultEnabler) {\n    'use strict';\n\n    return {\n        // Initialise a single VaultEnabler instance.\n        vaultEnabler: new VaultEnabler(),\n\n        /**\n         * @returns {VaultEnabler}\n         */\n        getVaultEnabler() {\n            return this.vaultEnabler;\n        },\n\n        /**\n         * Set the payment code against the vault enabler.\n         *\n         * @param {string} code\n         */\n        setPaymentCode(code) {\n            this.vaultEnabler.setPaymentCode(code);\n        },\n\n        /**\n         * Returns the vault enabled state.\n         *\n         * @returns {boolean}\n         */\n        isVaultEnabled() {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * Returns the active payment token enabler state.\n         *\n         * @returns {boolean}\n         */\n        isActivePaymentTokenEnabler() {\n            return this.vaultEnabler.isActivePaymentTokenEnabler();\n        },\n\n        /**\n         * @param {Object} data\n         */\n        visitAdditionalData(data) {\n            this.vaultEnabler.visitAdditionalData(data);\n        }\n    };\n});\n","PayPal_Braintree/js/model/place-order-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable max-nested-callbacks */\n\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry'\n], function ($, wrapper, recaptchaRegistry) {\n    'use strict';\n\n    return function (placeOrder) {\n        return wrapper.wrap(placeOrder, function (originalAction, serviceUrl, payload, messageContainer) {\n            var recaptchaDeferred;\n\n            if (recaptchaRegistry.triggers.hasOwnProperty('recaptcha-checkout-braintree')) {\n                //ReCaptcha is present for checkout\n                recaptchaDeferred = $.Deferred();\n                recaptchaRegistry.addListener('recaptcha-checkout-braintree', function (token) {\n                    //Add reCaptcha value to place-order request and resolve deferred with the API call results\n                    payload.xReCaptchaValue = token;\n                    originalAction(serviceUrl, payload, messageContainer).done(function () {\n                        recaptchaDeferred.resolve.apply(recaptchaDeferred, arguments);\n                    }).fail(function () {\n                        recaptchaDeferred.reject.apply(recaptchaDeferred, arguments);\n                    });\n                });\n                //Trigger ReCaptcha validation\n                recaptchaRegistry.triggers['recaptcha-checkout-braintree']();\n\n                if (!recaptchaRegistry._isInvisibleType.hasOwnProperty('recaptcha-checkout-braintree') ||\n                    recaptchaRegistry._isInvisibleType['recaptcha-checkout-braintree'] === false\n                ) {\n                    //remove listener so that place order action is only triggered by the 'Place Order' button\n                    recaptchaRegistry.removeListener('recaptcha-checkout-braintree');\n                }\n                return recaptchaDeferred;\n            }\n\n            //No ReCaptcha, just sending the request\n            return originalAction(serviceUrl, payload, messageContainer);\n        });\n    };\n});\n","PayPal_Braintree/js/model/full-screen-loader.js":"define([\n    'jquery',\n    'rjsResolver'\n], function ($, resolver) {\n    'use strict';\n\n    /**\n     * New full screen loader (spinner) implementation with configurable container.\n     * It can be used across website areas including checkout.\n     */\n    return {\n        container: 'body',\n\n        /**\n         * Set the container element with its ID to replace default container.\n         *\n         * Only allow to set elements by ID (as expected to be unique.\n         * If the container has already been changed, do not allow changing again as this be set once per component.\n         *\n         * @param {string} value\n         */\n        setContainer: function (value) {\n            if (this.container !== 'body' || !value.startsWith('#')) {\n                return;\n            }\n\n            this.container = value;\n        },\n\n        /**\n         * Get the container element.\n         *\n         * @return {string}\n         */\n        getContainer: function () {\n            return this.container;\n        },\n\n        /**\n         * Start full page loader action\n         */\n        startLoader: function () {\n            $(this.getContainer()).trigger('processStart');\n        },\n\n        /**\n         * Stop full page loader action\n         *\n         * @param {Boolean} [forceStop]\n         */\n        stopLoader: function (forceStop) {\n            let $elem = $(this.getContainer()),\n                stop = $elem.trigger.bind($elem, 'processStop'); //eslint-disable-line jquery-no-bind-unbind\n\n            forceStop ? stop() : resolver(stop);\n        }\n    };\n});\n","PayPal_Braintree/js/view/product-page.js":"define(\n    ['uiComponent'],\n    function (Component) {\n        'use strict';\n\n        return Component.extend({\n\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/adapter.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'jquery',\n    'braintree',\n    'braintreeDataCollector',\n    'braintreeHostedFields',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function ($, client, dataCollector, hostedFields, fullScreenLoader, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        apiClient: null,\n        config: {},\n        checkout: null,\n        deviceData: null,\n        clientInstance: null,\n        hostedFieldsInstance: null,\n        paypalInstance: null,\n        code: 'braintree',\n\n        /**\n         * {Object}\n         */\n        events: {\n            onClick: null,\n            onCancel: null,\n            onError: null\n        },\n\n        /**\n         * Get Braintree api client\n         * @returns {Object}\n         */\n        getApiClient: function () {\n            return this.clientInstance;\n        },\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get payment name\n         * @returns {String}\n         */\n        getCode: function () {\n            if (window.checkoutConfig.payment[this.code]) {\n                return this.code;\n            }\n            return 'braintree_paypal';\n\n        },\n\n        /**\n         * Get client token\n         * @returns {String|*}\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.payment[this.getCode()].environment;\n        },\n\n        getCurrentCode: function (paypalType = null) {\n            var code = 'braintree_paypal';\n\n            if (paypalType !== 'paypal') {\n                code = code + '_' + paypalType;\n            }\n            return code;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getColor: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.color;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getShape: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.shape;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getLabel: function (paypalType = null) {\n            return window.checkoutConfig.payment[this.getCurrentCode(paypalType)].style.label;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getBranding: function () {\n            return null;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getFundingIcons: function () {\n            return null;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getDisabledFunding: function () {\n            return window.checkoutConfig.payment[this.getCode()].disabledFunding;\n        },\n\n        /**\n         * Show error message\n         *\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader();\n        },\n\n        /**\n         * Has PayPal been init'd already\n         */\n        getPayPalInstance: function () {\n            if (typeof this.config.paypalInstance !== 'undefined' && this.config.paypalInstance) {\n                return this.config.paypalInstance;\n            }\n\n            return null;\n        },\n\n        setPayPalInstance: function (val) {\n            this.config.paypalInstance = val;\n        },\n\n        /**\n         * Setup Braintree SDK\n         *\n         * @param {Function|null} callback\n         */\n        setup: function (callback = null) {\n            if (!this.getClientToken()) {\n                this.showError($t('Sorry, but something went wrong.'));\n                return;\n            }\n\n            if (this.clientInstance) {\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onDeviceDataReceived(this.deviceData);\n                    this.config.onReady(this);\n                }\n\n                if (typeof callback === 'function') {\n                    callback(this.clientInstance);\n                }\n                return;\n            }\n\n            client.create({\n                authorization: this.getClientToken()\n            }, function (clientErr, clientInstance) {\n                if (clientErr) {\n                    console.error('Braintree Setup Error', clientErr);\n                    return this.showError('Sorry, but something went wrong. Please contact the store owner.');\n                }\n\n                let options = {\n                    client: clientInstance\n                };\n\n                if (typeof this.config.dataCollector === 'object'\n                    && typeof this.config.dataCollector.paypal === 'boolean'\n                ) {\n                    options.paypal = true;\n                }\n\n                this.clientInstance = clientInstance;\n\n                if (typeof this.config.onReady === 'function') {\n                    this.config.onReady(this);\n                }\n\n                dataCollector.create(options, function (err, dataCollectorInstance) {\n                    if (err) {\n                        return console.log(err);\n                    }\n\n                    this.deviceData = dataCollectorInstance.deviceData;\n                    this.config.onDeviceDataReceived(this.deviceData);\n\n                    if (typeof callback === 'function') {\n                        callback(this.clientInstance);\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Setup hosted fields instance\n         */\n        setupHostedFields: function () {\n            var self = this;\n\n            if (this.hostedFieldsInstance) {\n                this.hostedFieldsInstance.teardown(function () {\n                    this.hostedFieldsInstance = null;\n                    this.setupHostedFields();\n                }.bind(this));\n                return;\n            }\n\n            hostedFields.create({\n                client: this.clientInstance,\n                fields: this.config.hostedFields,\n                styles: this.config.styles\n            }, function (createErr, hostedFieldsInstance) {\n                if (createErr) {\n                    let error = 'Braintree hosted fields could not be initialized. Please contact the store owner.';\n\n                    self.showError($t(error));\n                    console.error('Braintree hosted fields error', createErr);\n                    return;\n                }\n\n                this.config.onInstanceReady(hostedFieldsInstance);\n                this.hostedFieldsInstance = hostedFieldsInstance;\n            }.bind(this));\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({}, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    switch (tokenizeErr.code) {\n                    case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                        // occurs when none of the fields are filled in\n                        console.error('All fields are empty! Please fill out the form.');\n                        break;\n                    case 'HOSTED_FIELDS_FIELDS_INVALID':\n                        // occurs when certain fields do not pass client side validation\n                        console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                        break;\n                    case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                        // occurs when:\n                        //   * the client token used for client authorization was generated\n                        //     with a customer ID and the fail on duplicate payment method\n                        //     option is set to true\n                        //   * the card being tokenized has previously been vaulted (with any customer)\n                        // eslint-disable-next-line\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                        console.error('This payment method already exists in your vault.');\n                        break;\n                    case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                        // occurs when:\n                        //   * the client token used for client authorization was generated\n                        //     with a customer ID and the verify card option is set to true\n                        //     and you have credit card verification turned on in the Braintree\n                        //     control panel\n                        //   * the cvv does not pass verfication\n                        //   (developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                        // eslint-disable-next-line\n                            // See: developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                        console.error('CVV did not pass verification');\n                        break;\n                    case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                        // occurs for any other tokenization error on the server\n                        console.error('Tokenization failed server side. Is the card valid?');\n                        break;\n                    case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                        // occurs when the Braintree gateway cannot be contacted\n                        console.error('Network error occurred when tokenizing.');\n                        break;\n                    default:\n                        console.error('Something bad happened!', tokenizeErr);\n                    }\n                } else {\n                    this.config.onPaymentMethodReceived(payload);\n                }\n            }.bind(this));\n        }\n    };\n});\n\n","PayPal_Braintree/js/view/payment/3d-secure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/adapter',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate',\n    'braintreeThreeDSecure',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'PayPal_Braintree/js/helper/remove-non-digit-characters',\n    'PayPal_Braintree/js/model/vault-enabler'\n], function (\n    $,\n    braintree,\n    quote,\n    $t,\n    threeDSecure,\n    fullScreenLoader,\n    removeNonDigitCharacters,\n    vaultEnablerModel\n) {\n    'use strict';\n\n    return {\n        config: null,\n\n        /**\n         * Set 3d secure config\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n            this.config.thresholdAmount = parseFloat(config.thresholdAmount);\n\n            // Initialize vault enabler to check is it actually enabled or passed\n            vaultEnablerModel.setPaymentCode(this.config.ccVaultCode);\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'three_d_secure';\n        },\n\n        /**\n         * Check billing/shipping address line lengths\n         *\n         * @param errorMessage\n         * @param billingAddress\n         * @param shippingAddress\n         * @returns {*}\n         */\n        checkBillingLineLengths: function (errorMessage, billingAddress, shippingAddress) {\n            let lineError = null;\n\n            if (billingAddress.street[0].length > 50 ||\n                (shippingAddress.street !== undefined && shippingAddress.street[0].length > 50)) {\n                lineError = 'line1';\n            } else if (billingAddress.street[1].length > 50 ||\n                (shippingAddress.street !== undefined && shippingAddress.street[1].length > 50)) {\n                lineError = 'line2';\n            }\n\n            if (lineError) {\n                let error = `Billing/Shipping ${lineError} must be string and less than 50 characters.`;\n\n                return $t(`${error} Please update the address and try again.`);\n            }\n        },\n\n        /**\n         * Validate Braintree payment nonce\n         * @param {Object} context\n         * @returns {Object}\n         */\n        validate: function (context) {\n            let self = this,\n                clientInstance = braintree.getApiClient(),\n                state = $.Deferred(),\n                totalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2),\n                billingAddress = quote.billingAddress(),\n                shippingAddress = quote.shippingAddress(),\n                setup3d;\n\n            // Handle billing address region code\n            if (billingAddress.regionCode == null) {\n                billingAddress.regionCode = undefined;\n            }\n            if (billingAddress.regionCode !== undefined && billingAddress.regionCode.length > 2) {\n                billingAddress.regionCode = undefined;\n            }\n\n            // Handle shipping address region code\n            if (!quote.isVirtual() && shippingAddress !== null) {\n                if (shippingAddress.regionCode == null) {\n                    shippingAddress.regionCode = undefined;\n                }\n                if (shippingAddress.regionCode !== undefined && shippingAddress.regionCode.length > 2) {\n                    shippingAddress.regionCode = undefined;\n                }\n            }\n\n            // No 3d secure if using CVV verification on vaulted cards\n            if (quote.paymentMethod().method.indexOf('braintree_cc_vault_') !== -1) {\n                if (this.config.useCvvVault === true) {\n                    state.resolve();\n                    return state.promise();\n                }\n            }\n\n            if (!this.isAmountAvailable(totalAmount) || !this.isCountryAvailable(billingAddress.countryId)) {\n                state.resolve();\n                return state.promise();\n            }\n\n            fullScreenLoader.startLoader();\n\n            setup3d = function (client) {\n                threeDSecure.create({\n                    version: 2,\n                    client: client\n                }, function (threeDSecureErr, threeDSecureInstance) {\n                    if (threeDSecureErr) {\n                        fullScreenLoader.stopLoader();\n                        return state.reject($t('Please try again with another form of payment.'));\n                    }\n\n                    let threeDSContainer = document.createElement('div'),\n                        tdMask = document.createElement('div'),\n                        tdFrame = document.createElement('div'),\n                        tdBody = document.createElement('div'),\n                        threeDSecureParameters;\n\n                    threeDSContainer.className = 'braintree-three-d-modal';\n                    tdMask.className = 'bt-mask';\n                    tdFrame.className = 'bt-modal-frame';\n                    tdBody.className = 'bt-modal-body';\n\n                    tdFrame.appendChild(tdBody);\n                    threeDSContainer.appendChild(tdMask);\n                    threeDSContainer.appendChild(tdFrame);\n\n                    threeDSecureParameters = {\n                        amount: totalAmount,\n                        nonce: context.paymentMethodNonce,\n                        bin: context.creditCardBin,\n                        collectDeviceData: true,\n                        challengeRequested: self.getChallengeRequested(),\n                        cardAddChallengeRequested: self.getCardAddChallengeRequested(),\n                        billingAddress: {\n                            givenName: billingAddress.firstname,\n                            surname: billingAddress.lastname,\n                            phoneNumber: billingAddress.telephone !== null\n                                ? removeNonDigitCharacters(billingAddress.telephone)\n                                : billingAddress.telephone,\n                            streetAddress: billingAddress.street[0],\n                            extendedAddress: billingAddress.street[1],\n                            locality: billingAddress.city,\n                            region: billingAddress.regionCode,\n                            postalCode: billingAddress.postcode,\n                            countryCodeAlpha2: billingAddress.countryId\n                        },\n                        additionalInformation: {\n                            ipAddress: self.getIpAddress()\n                        },\n                        onLookupComplete: function (data, next) {\n                            next();\n                        },\n                        addFrame: function (err, iframe) {\n                            fullScreenLoader.stopLoader();\n\n                            if (err) {\n                                console.log('Unable to verify card over 3D Secure', err);\n                                return state.reject($t('Please try again with another form of payment.'));\n                            }\n\n                            tdBody.appendChild(iframe);\n                            document.body.appendChild(threeDSContainer);\n                        },\n                        removeFrame: function () {\n                            fullScreenLoader.startLoader();\n                            document.body.removeChild(threeDSContainer);\n                        }\n                    };\n\n                    if (context.hasOwnProperty('email') && context.email !== null) {\n                        threeDSecureParameters.email = context.email;\n                    }\n\n                    if (!quote.isVirtual() && shippingAddress !== null) {\n                        threeDSecureParameters.additionalInformation = {\n                            shippingGivenName: shippingAddress.firstname,\n                            shippingSurname: shippingAddress.lastname,\n                            shippingAddress: {\n                                streetAddress: shippingAddress.street[0],\n                                extendedAddress: shippingAddress.street[1],\n                                locality: shippingAddress.city,\n                                region: shippingAddress.regionCode,\n                                postalCode: shippingAddress.postcode,\n                                countryCodeAlpha2: shippingAddress.countryId\n                            },\n                            shippingPhone: shippingAddress.telephone !== null\n                                ? removeNonDigitCharacters(shippingAddress.telephone)\n                                : shippingAddress.telephone,\n                            ipAddress: threeDSecureParameters.additionalInformation.ipAddress\n                        }\n                    }\n\n                    threeDSecureInstance.verifyCard(threeDSecureParameters, function (err, response) {\n                        fullScreenLoader.stopLoader();\n\n                        if (err) {\n                            console.error('3DSecure validation failed', err);\n                            if (err.code === 'THREEDS_LOOKUP_VALIDATION_ERROR') {\n                                let errorMessage = err.details.originalError.details.originalError.error.message,\n                                    error = self.checkBillingLineLengths(errorMessage, billingAddress, shippingAddress);\n\n                                return error ? state.reject(error) : state.reject($t(errorMessage));\n                            }\n\n                            return state.reject($t('Please try again with another form of payment.'));\n                        }\n\n                        let liability = {\n                            shifted: response.liabilityShifted,\n                            shiftPossible: response.liabilityShiftPossible\n                        };\n\n                        if (liability.shifted || !liability.shifted && !liability.shiftPossible) {\n                            context.paymentMethodNonce = response.nonce;\n                            state.resolve();\n                        } else {\n                            state.reject($t('Please try again with another form of payment.'));\n                        }\n                    });\n                });\n            };\n\n            if (!clientInstance) {\n                require(['PayPal_Braintree/js/view/payment/method-renderer/cc-form'], function (c) {\n                    let config = c.extend({\n                        defaults: {\n                            clientConfig: {\n                                onReady: function () {}\n                            }\n                        }\n                    });\n\n                    braintree.setConfig(config.defaults.clientConfig);\n                    braintree.setup(setup3d);\n                });\n            } else {\n                setup3d(clientInstance);\n            }\n\n            return state.promise();\n        },\n\n        /**\n         * Check minimal amount for 3d secure activation\n         * @param {Number} amount\n         * @returns {Boolean}\n         */\n        isAmountAvailable: function (amount) {\n            amount = parseFloat(amount.toString());\n\n            return amount >= this.config.thresholdAmount;\n        },\n\n        /**\n         * Check if current country is available for 3d secure\n         * @param {String} countryId\n         * @returns {Boolean}\n         */\n        isCountryAvailable: function (countryId) {\n            let key,\n                specificCountries = this.config.specificCountries;\n\n            // all countries are available\n            if (!specificCountries.length) {\n                return true;\n            }\n\n            for (key in specificCountries) {\n                if (countryId === specificCountries[key]) {\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Get the challenge requested config\n         * it will only be returned TRUE when Vault is disabled(FALSE)\n         * and 'PaymentTokenEnabler' is set to FALSE.\n         *\n         * @returns {Boolean}\n         */\n        getChallengeRequested: function () {\n            if (vaultEnablerModel.isVaultEnabled() && vaultEnablerModel.isActivePaymentTokenEnabler()) {\n                return false;\n            }\n            return this.config.challengeRequested;\n        },\n\n        /**\n         * This parameter will be passed as TRUE when\n         * Vault is enabled(TRUE) and 'PaymentTokenEnabler'\n         * is set to TRUE.\n         *\n         * @returns {boolean}\n         */\n        getCardAddChallengeRequested: function () {\n            if (vaultEnablerModel.isVaultEnabled() && vaultEnablerModel.isActivePaymentTokenEnabler()) {\n                return true;\n            }\n            return false;\n        },\n\n        /**\n         * Get the Customer's IP Address\n         *\n         * @returns {*}\n         */\n        getIpAddress: function () {\n            return this.config.ipAddress;\n        }\n    };\n});\n","PayPal_Braintree/js/view/payment/braintree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'Magento_Customer/js/customer-data',\n    'Magento_Ui/js/model/messageList'\n], function (Component, rendererList, customerData, globalMessageList) {\n    'use strict';\n\n    let config = window.checkoutConfig.payment,\n        braintreeType = 'braintree',\n        payPalType = 'braintree_paypal',\n        braintreeAchDirectDebit = 'braintree_ach_direct_debit',\n        braintreeVenmo = 'braintree_venmo',\n        braintreeLocalPayment = 'braintree_local_payment';\n\n    if (config[braintreeType] && config[braintreeType].isActive && config[braintreeType].clientToken) {\n        rendererList.push({\n            type: braintreeType,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/hosted-fields'\n        });\n    }\n\n    if (config[payPalType] && config[payPalType].isActive) {\n        rendererList.push({\n            type: payPalType,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/paypal'\n        });\n    }\n\n    if (config[braintreeVenmo] && config[braintreeVenmo].isAllowed && config[braintreeVenmo].clientToken) {\n        rendererList.push({\n            type: braintreeVenmo,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/venmo'\n        });\n    }\n\n    if (config[braintreeAchDirectDebit] && config[braintreeAchDirectDebit].isActive\n        && config[braintreeAchDirectDebit].clientToken) {\n        rendererList.push({\n            type: braintreeAchDirectDebit,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/ach'\n        });\n    }\n\n    if (config[braintreeLocalPayment] && config[braintreeLocalPayment].clientToken) {\n        rendererList.push({\n            type: braintreeLocalPayment,\n            component: 'PayPal_Braintree/js/view/payment/method-renderer/lpm'\n        });\n    }\n\n    /** Add view logic here if needed */\n    return Component.extend({\n        initialize: function () {\n            this._super();\n\n            let braintreeData = customerData.get('braintree')(),\n                errors = braintreeData.errors || [];\n\n            errors.forEach(function (error) {\n                globalMessageList.addErrorMessage({ 'message': error });\n            });\n\n            customerData.set('braintree', { errors: [] });\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/validator-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/model/full-screen-loader'\n], function (\n    $,\n    globalMessageList,\n    defaultFullScreenLoader\n) {\n    'use strict';\n\n    /**\n     * New Validator handler implementation that can be used across website areas including checkout.\n     */\n    return {\n        fullScreenLoader: defaultFullScreenLoader,\n        validators: [],\n\n        /**\n         * Set the full screen loader implementation.\n         *\n         * @param fullScreenLoader\n         */\n        setFullScreenLoader: function (fullScreenLoader) {\n            this.fullScreenLoader = fullScreenLoader;\n        },\n\n        /**\n         * Get the full screen loader implementation.\n         */\n        getFullScreenLoader: function () {\n            return this.fullScreenLoader;\n        },\n\n        /**\n         * Add new validator if enabled.\n         *\n         * Always expect the validator to have the isEnabled method (property), if not skip.\n         *\n         * @param {Object} validator\n         */\n        add: function (validator) {\n            if (!validator.hasOwnProperty('isEnabled')\n                || typeof validator.isEnabled !== 'function'\n                || !validator.isEnabled()\n            ) {\n                return;\n            }\n\n            this.validators.push(validator);\n        },\n\n        /**\n         * Run pull of validators.\n         *\n         * @param {Object} context\n         * @param {Function} callback\n         * @param {Function} errorCallback\n         */\n        validate: function (context, callback, errorCallback) {\n            let self = this,\n                deferred;\n\n            // no available validators\n            if (!self.validators.length) {\n                callback();\n\n                return;\n            }\n\n            // get list of deferred validators\n            deferred = $.map(self.validators, function (current) {\n                return current.validate(context);\n            });\n\n            $.when.apply($, deferred)\n                .done(function () {\n                    callback();\n                }).fail(function (error) {\n                    errorCallback();\n                    self.showError(error);\n                });\n        },\n\n        /**\n         * Show error message.\n         *\n         * @param {string} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n\n            this.getFullScreenLoader().stopLoader(true);\n        }\n    };\n});\n","PayPal_Braintree/js/view/payment/venmo.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_venmo',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/venmo'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/ach.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_ach_direct_debit',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/ach'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/lpm.js":"define(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/renderer-list'\n    ],\n    function (\n        Component,\n        rendererList\n    ) {\n        'use strict';\n\n        rendererList.push(\n            {\n                type: 'braintree_local_payment',\n                component: 'PayPal_Braintree/js/view/payment/method-renderer/lpm'\n            }\n        );\n\n        return Component.extend({});\n    }\n);\n","PayPal_Braintree/js/view/payment/validator-handler.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/3d-secure',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, globalMessageList, verify3DSecure, fullScreenLoader) {\n    'use strict';\n\n    return {\n        validators: [],\n\n        /**\n         * Get payment config\n         * @returns {Object}\n         */\n        getConfig: function () {\n            return window.checkoutConfig.payment;\n        },\n\n        /**\n         * Init list of validators\n         */\n        initialize: function () {\n            let config = this.getConfig();\n\n            if (config[verify3DSecure.getCode()].enabled) {\n                verify3DSecure.setConfig(config[verify3DSecure.getCode()]);\n                this.add(verify3DSecure);\n            }\n        },\n\n        /**\n         * Add new validator\n         * @param {Object} validator\n         */\n        add: function (validator) {\n            this.validators.push(validator);\n        },\n\n        /**\n         * Run pull of validators\n         * @param {Object} context\n         * @param {Function} callback\n         */\n        validate: function (context, callback, errorCallback) {\n            var self = this,\n                deferred;\n\n            // no available validators\n            if (!self.validators.length) {\n                callback();\n\n                return;\n            }\n\n            // get list of deferred validators\n            deferred = $.map(self.validators, function (current) {\n                return current.validate(context);\n            });\n\n            $.when.apply($, deferred)\n                .done(function () {\n                    callback();\n                }).fail(function (error) {\n                    errorCallback();\n                    self.showError(error);\n                });\n        },\n\n        /**\n         * Show error message\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n            fullScreenLoader.stopLoader(true);\n        }\n    };\n});\n","PayPal_Braintree/js/view/payment/express/express-paypal-paylater.js":"/**\n * Express PayLater button component\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'mage/url',\n    'domReady!'\n], function ($, _, Component, url) {\n    'use strict';\n\n    const config = _.get(window.checkoutConfig.payment, 'braintree_paypal_paylater', {});\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/express/express-paypal-paylater',\n            isActive: _.get(config, 'isActive', false),\n            checkoutCurrency: window.checkoutConfig.quoteData.base_currency_code,\n            checkoutAmount: window.checkoutConfig.quoteData.base_grand_total,\n            checkoutLocale: _.get(config, 'locale', null),\n            buttonLabel: _.get(config, ['style', 'label'], null),\n            buttonColor: _.get(config, ['style', 'color'], null),\n            buttonShape: _.get(config, ['style', 'shape'], null),\n            actionSuccess: url.build('braintree/paypal/review/'),\n            isMessageActive: _.get(config, 'isMessageActive', false),\n            messageTextColor: _.get(config ,['message', 'text_color'], null),\n            messageLayout: _.get(config ,['message', 'layout'], null),\n            messageLogoPosition: _.get(config ,['message', 'logo_position'], null),\n            messageLogo: _.get(config ,['message', 'logo'], null)\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Is the payment method active.\n         *\n         * @return {boolean}\n         */\n        isMethodActive: function () {\n            return this.isActive;\n        },\n\n        /**\n         * Is the payment method message active.\n         *\n         * @return {boolean}\n         */\n        isMethodMessageActive: function () {\n            return this.isMessageActive;\n        },\n\n        /**\n         * Is Billing address required.\n         *\n         * @return {string}\n         */\n        getIsRequiredBillingAddress: function () {\n            return _.get(config, 'isRequiredBillingAddress', '0') === '0' ? '' : 'true';\n        },\n\n        /**\n         * Get the merchant's name config.\n         *\n         * @return {string}\n         */\n        getMerchantName: function () {\n            return _.get(config, 'merchantName', '');\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/express/express-googlepay.js":"/**\n * Express GooglePay button component\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'mage/url',\n    'PayPal_Braintree/js/googlepay/button',\n    'PayPal_Braintree/js/googlepay/api',\n    'domReady!'\n], function ($, _, Component, url, button, buttonApi) {\n    'use strict';\n\n    const config = _.get(window.checkoutConfig.payment, 'braintree_googlepay', {});\n\n    return Component.extend({\n\n        defaults: {\n            template: 'PayPal_Braintree/express/express-googlepay',\n            id: 'braintree-googlepay-express-payment',\n            isActive: !_.isEmpty(config),\n            clientToken: _.get(config, 'clientToken', null),\n            merchantId: _.get(config, 'merchantId', null),\n            currencyCode: window.checkoutConfig.quoteData.base_currency_code,\n            actionSuccess: url.build('braintree/googlepay/review/'),\n            amount: window.checkoutConfig.quoteData.base_grand_total,\n            environment: _.get(config, 'environment', 'TEST'),\n            cardTypes: _.get(config, 'cardTypes', []),\n            btnColor: _.get(config, 'btnColor', ''),\n            threeDSecure: null\n        },\n\n        /**\n         * Is the payment method active.\n         *\n         * @return {boolean}\n         */\n        isMethodActive: function () {\n            return this.isActive;\n        },\n\n        /**\n         * Get the 3D Secure config object.\n         *\n         * @return {\n        *   {\n        *      thresholdAmount: (number|*),\n        *      specificCountries: ([]|*),\n        *      challengeRequested: (boolean|*),\n        *      enabled: boolean\n        *   } ||\n        *   {\n        *      thresholdAmount: number,\n        *      specificCountries: *[],\n        *      challengeRequested: boolean,\n        *      enabled: boolean\n        *   }\n        * }\n         */\n        get3DSecureConfig: function () {\n            let secureConfig = _.get(window.checkoutConfig.payment, 'three_d_secure', {});\n\n            if (_.isEmpty(secureConfig)) {\n                return {\n                    'enabled': false,\n                    'challengeRequested': false,\n                    'thresholdAmount': 0.0,\n                    'specificCountries': [],\n                    'ipAddress': ''\n                };\n            }\n\n            return {\n                'enabled': true,\n                'challengeRequested': secureConfig.challengeRequested ,\n                'thresholdAmount': secureConfig.thresholdAmount,\n                'specificCountries': secureConfig.specificCountries,\n                'ipAddress': secureConfig.ipAddress\n            };\n        },\n\n        /**\n         * Initialize Google Pay express.\n         */\n        initGooglePayExpress: function () {\n            if (!this.isMethodActive()) {\n                return;\n            }\n\n            this.threeDSecure = this.get3DSecureConfig();\n\n            /* Add client token & environment to 3DS Config */\n            this.threeDSecure.clientToken = this.clientToken;\n            this.threeDSecure.environment = this.environment;\n\n            let api = new buttonApi();\n\n            api.setEnvironment(this.environment);\n            api.setCurrencyCode(this.currencyCode);\n            api.setClientToken(this.clientToken);\n            api.setMerchantId(this.merchantId);\n            api.setActionSuccess(this.actionSuccess);\n            api.setAmount(this.amount);\n            api.setCardTypes(this.cardTypes);\n            api.setBtnColor(this.btnColor);\n            api.setThreeDSecureValidatorConfig(this.threeDSecure);\n\n            // Attach the button\n            button.init(\n                document.getElementById(this.id),\n                api\n            );\n        },\n\n        /**\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/express/express-paypal-credit.js":"/**\n * Express Paypal Credit button component\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'mage/url',\n    'domReady!'\n], function ($, _, Component, url) {\n    'use strict';\n\n    const config = _.get(window.checkoutConfig.payment, 'braintree_paypal_credit', {});\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/express/express-paypal-credit',\n            isActive: _.get(config, 'isActive', false),\n            checkoutCurrency: window.checkoutConfig.quoteData.base_currency_code,\n            checkoutAmount: window.checkoutConfig.quoteData.base_grand_total,\n            checkoutLocale: _.get(config, 'locale', null),\n            buttonLabel: _.get(config, ['style', 'label'], null),\n            buttonColor: _.get(config, ['style', 'color'], null),\n            buttonShape: _.get(config, ['style', 'shape'], null),\n            actionSuccess: url.build('braintree/paypal/review/')\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Is the payment method active.\n         *\n         * @return {boolean}\n         */\n        isMethodActive: function () {\n            return this.isActive;\n        },\n\n        /**\n         * Is Billing address required.\n         *\n         * @return {string}\n         */\n        getIsRequiredBillingAddress: function () {\n            return _.get(config, 'isRequiredBillingAddress', '0') === '0' ? '' : 'true';\n        },\n\n        /**\n         * Get the merchant's name config.\n         *\n         * @return {string}\n         */\n        getMerchantName: function () {\n            return _.get(config, 'merchantName', '');\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/express/express-applepay.js":"/**\n * Braintree Apple Pay express payment method integration.\n **/\ndefine([\n    'underscore',\n    'uiComponent',\n    'PayPal_Braintree/js/applepay/button',\n    'PayPal_Braintree/js/applepay/api',\n    'PayPal_Braintree/js/helper/format-amount',\n    'mage/translate',\n    'mage/url',\n    'domReady!'\n], function (\n    _,\n    Component,\n    button,\n    buttonApi,\n    formatAmount,\n    $t,\n    url\n) {\n    'use strict';\n\n    const config = _.get(window.checkoutConfig.payment, 'braintree_applepay', {});\n\n    return Component.extend({\n\n        defaults: {\n            template: 'PayPal_Braintree/express/express-applepay',\n            id: 'braintree-applepay-express-payment',\n            isActive: !_.isEmpty(config),\n            clientToken: _.get(config, 'clientToken', null),\n            quoteId: window.checkoutConfig.quoteId,\n            displayName: _.get(config, 'merchantName', null),\n            actionSuccess: url.build('checkout/onepage/success'),\n            grandTotalAmount: window.checkoutConfig.quoteData.base_grand_total,\n            isLoggedIn: false,\n            storeCode: window.checkoutConfig.storeCode\n        },\n\n        /**\n         * Is the payment method active.\n         *\n         * @return {boolean}\n         */\n        isMethodActive: function () {\n            return this.isActive;\n        },\n\n        /**\n         * Initialize Apple Pay express.\n         */\n        initApplePayExpress: function () {\n            if (!this.isMethodActive() || !this.clientToken) {\n                return;\n            }\n\n            if (!this.displayName) {\n                this.displayName = $t('Store');\n            }\n\n            this.isLoggedIn = window.checkoutConfig.customer_is_guest === '1' ? 'true' : 'false';\n\n            let api = new buttonApi();\n\n            api.setGrandTotalAmount(formatAmount(this.grandTotalAmount));\n            api.setClientToken(this.clientToken);\n            api.setDisplayName(this.displayName);\n            api.setQuoteId(this.quoteId);\n            api.setActionSuccess(this.actionSuccess);\n            api.setIsLoggedIn(this.isLoggedIn);\n            api.setStoreCode(this.storeCode);\n\n            // Attach the button\n            button.init(\n                document.getElementById(this.id),\n                api\n            );\n        },\n\n        /**\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/express/express-paypal.js":"/**\n * Express Paypal button component\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'mage/url',\n    'PayPal_Braintree/js/paypal/button',\n    'PayPal_Braintree/js/helper/get-cart-line-items-helper',\n    'domReady!'\n], function ($, _, Component, url, paypalButton, getCartLineItems) {\n    'use strict';\n\n    const config = _.get(window.checkoutConfig.payment, 'braintree_paypal', {});\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/express/express-paypal',\n            isActive: _.get(config, 'isActive', false),\n            clientToken: _.get(config, 'clientToken', null),\n            checkoutCurrency: window.checkoutConfig.quoteData.base_currency_code,\n            checkoutAmount: window.checkoutConfig.quoteData.base_grand_total,\n            checkoutLocale: _.get(config, 'locale', null),\n            buttonLabel: _.get(config, ['style', 'label'], null),\n            buttonColor: _.get(config, ['style', 'color'], null),\n            buttonShape: _.get(config, ['style', 'shape'], null),\n            actionSuccess: url.build('braintree/paypal/review/')\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Is the payment method active.\n         *\n         * @return {boolean}\n         */\n        isMethodActive: function () {\n            return this.isActive;\n        },\n\n        /**\n         * Is Billing address required.\n         *\n         * @return {string}\n         */\n        getIsRequiredBillingAddress: function () {\n            return _.get(config, 'isRequiredBillingAddress', '0') === '0' ? '' : 'true';\n        },\n\n        /**\n         * Get the merchant's name config.\n         *\n         * @return {string}\n         */\n        getMerchantName: function () {\n            return _.get(config, 'merchantName', '');\n        },\n\n        /**\n         * Initialize Braintree PayPal buttons.\n         *\n         * PayPal Credit & PayPal Pay Later & PayPal Pay Later Messaging rely on PayPal to be enabled.\n         */\n        initPayPalButtons: function () {\n            if (!this.isMethodActive() || !this.clientToken) {\n                return;\n            }\n\n            let buttonConfig = {\n                    'clientToken': this.clientToken,\n                    'currency': this.checkoutCurrency,\n                    'environment': config.environment,\n                    'merchantCountry': config.merchantCountry,\n                    'isCreditActive': _.get(window.checkoutConfig.payment,\n                        ['braintree_paypal_credit', 'isActive'], false)\n                },\n\n                cartLineItems = getCartLineItems();\n\n            paypalButton.init(\n                buttonConfig,\n                JSON.stringify(cartLineItems)\n            );\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/express/express-payment.js":"/**\n * General express payment component that initializes braintree payment buttons\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'domReady!'\n], function ($, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/express/express-payment'\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/ach-vault.js":"/*browser:true*/\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/validator-handler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function (\n    ko,\n    $,\n    _,\n    VaultComponent,\n    globalMessageList,\n    validatorManager,\n    additionalValidators,\n    fullScreenLoader\n) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            active: false,\n            imports: {\n                onActiveChange: 'active'\n            },\n            template: 'PayPal_Braintree/payment/ach/vault',\n            validatorManager: validatorManager,\n            additionalData: {}\n        },\n\n        /**\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super().observe(['active']);\n            this.validatorManager.initialize();\n            return this;\n        },\n\n        /**\n         * Is payment option active?\n         *\n         * @returns {boolean}\n         */\n        isActive: function () {\n            let active = this.getId() === this.isChecked();\n\n            this.active(active);\n            return active;\n        },\n\n        /**\n         * Return the payment method code.\n         *\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'braintree_ach_direct_debit_vault';\n        },\n\n        /**\n         * Get Bank Account last 4 digits.\n         *\n         * @returns {String}\n         */\n        getAccountNumberLastFourDigits: function () {\n            return this.details.last4;\n        },\n\n        /**\n         *\n         * Get bank's routing number\n         *\n         * @returns {String}\n         */\n        getRoutingNumber: function () {\n            return this.details.routingNumber;\n        },\n\n        /**\n         * Get the ACH icon.\n         *\n         * @return {String}\n         */\n        getPaymentIcon() {\n            return window.checkoutConfig.payment['braintree_ach_direct_debit'].paymentIcon;\n        },\n\n        /**\n         * Trigger Place order action.\n         *\n         * Set payment method nonce & place order.\n         */\n        triggerPlaceOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce & places order.\n         */\n        getPaymentMethodNonce: function () {\n            let self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            }).done(function (response) {\n                fullScreenLoader.stopLoader();\n                self.additionalData['payment_method_nonce'] = response.paymentMethodNonce;\n                self.placeOrder();\n            }).fail(function (response) {\n                let error = JSON.parse(response.responseText);\n\n                fullScreenLoader.stopLoader();\n                globalMessageList.addErrorMessage({\n                    message: error.message\n                });\n            });\n        },\n\n        /**\n         * Get payment method data.\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            let data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/paypal-customer-vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate',\n    'braintree',\n    'braintreeDataCollector',\n    'braintreePayPalCheckout',\n    'PayPal_Braintree/js/helper/format-amount',\n    'PayPal_Braintree/js/helper/remove-non-digit-characters',\n    'PayPal_Braintree/js/helper/replace-unsupported-characters',\n    'Magento_Checkout/js/action/create-billing-address',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_CheckoutAgreements/js/view/checkout-agreements',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList'\n], function (\n    $,\n    _,\n    $t,\n    client,\n    dataCollector,\n    paypalCheckout,\n    formatAmount,\n    removeNonDigitCharacters,\n    replaceUnsupportedCharacters,\n    createBillingAddress,\n    selectBillingAddress,\n    fullScreenLoader,\n    quote,\n    additionalValidators,\n    checkoutAgreements,\n    VaultComponent,\n    globalMessageList\n) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/paypal/customer-vault',\n\n            /**\n             * Component config set via provider.\n             */\n            code: null,\n            nonceUrl: null,\n            publicHash: null,\n            clientToken: null,\n            clientInstance: null,\n            checkout: null,\n            details: {},\n\n            /**\n             * {Object}\n             */\n            events: {\n                onClick: null,\n                onCancel: null,\n                onError: null,\n                onRender: null\n            },\n\n            /**\n             * Additional payment data\n             *\n             * {Object}\n             */\n            additionalData: {},\n\n            /**\n             * Placeholders for PayPal instance vaulted payment.\n             */\n            paypalInstance: null,\n            paymentMethodNonce: null,\n            grandTotalAmount: null,\n            isReviewRequired: false,\n            customerEmail: null,\n\n            /**\n             * {Array}\n             */\n            lineItemsArray: [\n                'name',\n                'kind',\n                'quantity',\n                'unitAmount',\n                'productCode',\n                'description'\n            ],\n\n            /**\n             * PayPal client configuration\n             *\n             * {Object}\n             */\n            clientConfig: {\n                dataCollector: {\n                    paypal: true\n                },\n\n                /**\n                 * Triggers when widget is loaded\n                 */\n                onReady: function () {\n                    this.setupPayPal();\n                },\n\n                /**\n                 * Triggers on payment nonce receive\n                 * @param {Object} response\n                 */\n                onPaymentMethodReceived: function (response) {\n                    this.beforePlaceOrder(response);\n                }\n            },\n\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         *\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            let self = this;\n\n            this._super().observe(['active', 'isReviewRequired', 'customerEmail']);\n\n            window.addEventListener('hashchange', function (e) {\n                let methodCode = quote.paymentMethod();\n\n                if (methodCode && methodCode.method === self.getId()) {\n                    if (e.newURL.indexOf('payment') > 0 && self.grandTotalAmount !== null) {\n                        self.reInitPayPalVault();\n                    }\n                }\n            });\n\n            quote.paymentMethod.subscribe(function (value) {\n                if (value.method && value.method === self.getId()) {\n                    self.reInitPayPalVault();\n                }\n            });\n\n            self.grandTotalAmount = quote.totals()['base_grand_total'];\n\n            quote.totals.subscribe(function () {\n                if (self.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    self.grandTotalAmount = quote.totals()['base_grand_total'];\n                    let methodCode = quote.paymentMethod();\n\n                    if (methodCode && methodCode.method === self.getId()) {\n                        self.reInitPayPalVault();\n                    }\n                }\n            });\n\n            self.isReviewRequired(false);\n            self.initClientConfig();\n\n            return this;\n        },\n\n        /**\n         * Triggers when payment method change\n         *\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                return;\n            }\n\n            // need always re-init Braintree with PayPal configuration\n            this.reInitPayPalVault();\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n        },\n\n        /**\n         * Get configuration for PayPal\n         *\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            let totals = quote.totals(),\n                config = {};\n\n            config.paypal = {\n                flow: 'checkout',\n                amount: formatAmount(this.grandTotalAmount),\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            if (!quote.isVirtual()) {\n                config.paypal.enableShippingAddress = true;\n                config.paypal.shippingAddressEditable = false;\n                config.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * Re-init PayPal Vault Auth Flow\n         */\n        reInitPayPalVault: function () {\n            this.disableButton();\n            this.clientConfig.paypal.amount = formatAmount(this.grandTotalAmount);\n\n            if (!quote.isVirtual()) {\n                this.clientConfig.paypal.enableShippingAddress = true;\n                this.clientConfig.paypal.shippingAddressEditable = false;\n                this.clientConfig.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n\n            // Send Line Items\n            this.clientConfig.paypal.lineItems = this.getLineItems();\n\n            if (this.getPayPalInstance()) {\n                this.getPayPalInstance().teardown(function () {\n                    this.setPayPalInstance(null);\n                    this.createClientInstance(null);\n                }.bind(this));\n            } else {\n                this.createClientInstance(null);\n                this.enableButton();\n            }\n        },\n\n        /**\n         * Get the current Braintree client instance.\n         *\n         * Null if not set.\n         *\n         * @return {*|null}\n         */\n        getClientInstance: function () {\n            if (typeof this.clientInstance !== 'undefined' && this.clientInstance) {\n                return this.clientInstance;\n            }\n\n            return null;\n        },\n\n        /**\n         * Set the Braintree client instance or null it.\n         *\n         * @param val\n         */\n        setClientInstance: function (val) {\n            this.clientInstance = val;\n        },\n\n        /**\n         * Get the PayPal instance if already instantiated, otherwise null.\n         *\n         * @return {*|null}\n         */\n        getPayPalInstance: function () {\n            if (typeof this.paypalInstance !== 'undefined' && this.paypalInstance) {\n                return this.paypalInstance;\n            }\n\n            return null;\n        },\n\n        /**\n         * Set the PayPal instance or null it by setting the value of the property.\n         *\n         * @param val\n         */\n        setPayPalInstance: function (val) {\n            this.paypalInstance = val;\n        },\n\n        /**\n         * Create the Braintree client instance.\n         *\n         * @param {Function|null} callback\n         */\n        createClientInstance: function (callback = null) {\n            if (this.getClientToken() === null) {\n                this.showError($t('Sorry, but something went wrong.'));\n                return;\n            }\n\n            if (this.getClientInstance()) {\n                if (typeof this.clientConfig.onReady === 'function') {\n                    this.clientConfig.onReady(this);\n                }\n\n                if (typeof callback === 'function') {\n                    callback(this.clientInstance);\n                }\n\n                return;\n            }\n\n            client.create({\n                authorization: this.getClientToken()\n            }, function (clientErr, clientInstance) {\n                if (clientErr) {\n                    console.error('Braintree Setup Error', clientErr);\n                    return this.showError('Sorry, but something went wrong. Please contact the store owner.');\n                }\n\n                let options = {\n                    client: clientInstance\n                };\n\n                if (typeof this.clientConfig.dataCollector === 'object'\n                    && typeof this.clientConfig.dataCollector.paypal === 'boolean')\n                {\n                    options.paypal = true;\n                }\n\n                dataCollector.create(options, function (err, dataCollectorInstance) {\n                    if (err) {\n                        return console.log(err);\n                    }\n                    this.additionalData['device_data'] = dataCollectorInstance.deviceData;\n                }.bind(this));\n\n                this.setClientInstance(clientInstance);\n\n                if (typeof this.clientConfig.onReady === 'function') {\n                    this.clientConfig.onReady(this);\n                }\n\n                if (typeof callback === 'function') {\n                    callback(this.getClientInstance());\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Get Environment\n         *\n         * @returns {String}\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].environment;\n        },\n\n        /**\n         * Setup PayPal instance\n         */\n        setupPayPal: function () {\n            if (this.getPayPalInstance()) {\n                fullScreenLoader.stopLoader(true);\n                return;\n            }\n\n            paypalCheckout.create({\n                autoSetDataUserIdToken: true,\n                client: this.getClientInstance()\n            }, function (createErr, paypalCheckoutInstance) {\n                if (createErr) {\n                    this.showError(\n                        $t('PayPal Checkout could not be initialized. Please contact the store owner.')\n                    );\n                    console.error('paypalCheckout error', createErr);\n                    return;\n                }\n\n                let quoteObj = quote.totals(),\n\n                    configSDK = {\n                        components: 'buttons,messages,funding-eligibility',\n                        'enable-funding': 'paylater',\n                        currency: quoteObj['base_currency_code']\n                    },\n\n                    buyerCountry = this.getMerchantCountry();\n\n                if (this.getEnvironment() === 'sandbox' && buyerCountry !== null) {\n                    configSDK['buyer-country'] = buyerCountry;\n                }\n\n                paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                    this.loadPayPalButton(paypalCheckoutInstance, 'paypal');\n\n                    if (this.isPayLaterEnabled()) {\n                        this.loadPayPalButton(paypalCheckoutInstance, 'paylater');\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Load PayPal buttons\n         *\n         * @param paypalCheckoutInstance\n         * @param funding\n         */\n        loadPayPalButton: function (paypalCheckoutInstance, funding) {\n            let paypalPayment = this.clientConfig.paypal,\n                onPaymentMethodReceived = this.clientConfig.onPaymentMethodReceived,\n\n                style = {\n                    label: this.getLabelByFunding(funding),\n                    color: this.getColorByFunding(funding),\n                    shape: this.getShapeByFunding(funding)\n                },\n\n                payPalButtonId = this.getButtonIdByFunding(funding),\n                payPalButtonElement = $('#' + payPalButtonId),\n                button,\n                events = this.events;\n\n            payPalButtonElement.html('');\n\n            // Render\n            this.setPayPalInstance(paypalCheckoutInstance);\n\n            button = window.paypal.Buttons({\n                fundingSource: funding,\n                env: this.getEnvironment(),\n                style: style,\n                commit: true,\n                locale: this.clientConfig.paypal.locale,\n\n                onInit: function (data, actions) {\n                    let agreements = checkoutAgreements().agreements,\n                        shouldDisableActions = false;\n\n                    actions.disable();\n\n                    _.each(agreements, function (item) {\n                        if (checkoutAgreements().isAgreementRequired(item)) {\n                            let paymentMethodCode = quote.paymentMethod().method,\n                                inputId = '#agreement_' + paymentMethodCode + '_' + item.agreementId,\n                                inputEl = document.querySelector(inputId);\n\n                            if (!inputEl.checked) {\n                                shouldDisableActions = true;\n                            }\n\n                            inputEl.addEventListener('change', function () {\n                                if (additionalValidators.validate(false)) {\n                                    actions.enable();\n                                } else {\n                                    actions.disable();\n                                }\n                            });\n                        }\n                    });\n\n                    if (!shouldDisableActions) {\n                        actions.enable();\n                    }\n                },\n\n                createOrder: function () {\n                    return paypalCheckoutInstance.createPayment(paypalPayment).catch(function (err) {\n                        throw err.details.originalError.details.originalError.paymentResource;\n                    });\n                },\n\n                onCancel: function (data) {\n                    console.log('checkout.js payment cancelled', JSON.stringify(data, 0, 2));\n\n                    if (typeof events.onCancel === 'function') {\n                        events.onCancel();\n                    }\n                },\n\n                onError: function (err) {\n                    if (err.errorName === 'VALIDATION_ERROR'\n                        && err.errorMessage.indexOf('Value is invalid') !== -1\n                    ) {\n                        this.showError(\n                            $t('Address failed validation. Please check and confirm your City, State, and Postal Code')\n                        );\n                    } else {\n                        this.showError($t('PayPal Checkout could not be initialized. Please contact the store owner.'));\n                    }\n\n                    this.setPayPalInstance(null);\n                    console.error('Paypal checkout.js error', err);\n\n                    if (typeof events.onError === 'function') {\n                        events.onError(err);\n                    }\n                }.bind(this),\n\n                onClick: function (data) {\n                    if (!quote.isVirtual()) {\n                        this.clientConfig.paypal.enableShippingAddress = true;\n                        this.clientConfig.paypal.shippingAddressEditable = false;\n                        this.clientConfig.paypal.shippingAddressOverride = this.getShippingAddress();\n                    }\n\n                    // To check term & conditions input checked - validate additional validators.\n                    if (!additionalValidators.validate(false)) {\n                        return false;\n                    }\n\n                    if (typeof events.onClick === 'function') {\n                        events.onClick(data);\n                    }\n                }.bind(this),\n\n                onApprove: function (data) {\n                    return paypalCheckoutInstance.tokenizePayment(data)\n                        .then(function (payload) {\n                            onPaymentMethodReceived(payload);\n                        });\n                }\n\n            });\n\n            if (button.isEligible() && payPalButtonElement.length) {\n                button.render('#' + payPalButtonId).then(function () {\n                    this.enableButton();\n\n                    if (typeof this.clientConfig.onPaymentMethodError === 'function') {\n                        this.clientConfig.onPaymentMethodError();\n                    }\n                }.bind(this)).then(function (data) {\n                    if (typeof events.onRender === 'function') {\n                        events.onRender(data);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Prepare data to place order\n         *\n         * @param {Object} data\n         */\n        beforePlaceOrder: function (data) {\n            this.setPaymentMethodNonce(data.nonce);\n            this.customerEmail(data.details.email);\n            if (quote.isVirtual()) {\n                this.isReviewRequired(true);\n            } else if (this.isRequiredBillingAddress() === '1' || quote.billingAddress() === null) {\n                if (typeof data.details.billingAddress !== 'undefined') {\n                    this.setBillingAddress(data.details, data.details.billingAddress);\n                } else {\n                    this.setBillingAddress(data.details, data.details.shippingAddress);\n                }\n            } else if (quote.shippingAddress() === quote.billingAddress()) {\n                selectBillingAddress(quote.shippingAddress());\n            } else {\n                selectBillingAddress(quote.billingAddress());\n            }\n            this.placeOrder();\n        },\n\n        /**\n         * Get the component's client token.\n         *\n         * @return {String}\n         */\n        getClientToken: function () {\n            return this.clientToken;\n        },\n\n        /**\n         * Get merchant country\n         *\n         * @returns {*}\n         */\n        getMerchantCountry: function () {\n            return _.get(window.checkoutConfig.payment, ['braintree_paypal', 'merchantCountry'], null);\n        },\n\n        /**\n         * Get PayPal payer email\n         *\n         * @returns {String}\n         */\n        getPayerEmail: function () {\n            return this.details.payerEmail;\n        },\n\n        /**\n         * Get type of payment\n         *\n         * @returns {String}\n         */\n        getPaymentIcon: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].paymentIcon;\n        },\n\n        /**\n         * Get merchant name\n         *\n         * @returns {String}\n         */\n        getMerchantName: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].merchantName;\n        },\n\n        /**\n         * Get payment method data\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            let data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash,\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        },\n\n        /**\n         * Set payment nonce.\n         *\n         * @param {String} paymentMethodNonce\n         */\n        setPaymentMethodNonce: function (paymentMethodNonce) {\n            this.paymentMethodNonce = paymentMethodNonce;\n        },\n\n        /**\n         * Get shipping address\n         *\n         * @returns {Object}\n         */\n        getShippingAddress: function () {\n            let address = quote.shippingAddress();\n\n            return {\n                recipientName: address.firstname + ' ' + address.lastname,\n                line1: address.street[0],\n                line2: typeof address.street[2] === 'undefined'\n                    ? address.street[1]\n                    : address.street[1] + ' ' + address.street[2],\n                city: address.city,\n                countryCode: address.countryId,\n                postalCode: address.postcode,\n                state: address.regionCode\n            };\n        },\n\n        /**\n         * Update quote billing address\n         *\n         * @param {Object}customer\n         * @param {Object}address\n         */\n        setBillingAddress: function (customer, address) {\n            let billingAddress = {\n                street: [address.line1],\n                city: address.city,\n                postcode: address.postalCode,\n                countryId: address.countryCode,\n                email: customer.email,\n                firstname: customer.firstName,\n                lastname: customer.lastName,\n                telephone: removeNonDigitCharacters(_.get(customer, 'phone', '00000000000'))\n            };\n\n            billingAddress['region_code'] = typeof address.state === 'string' ? address.state : '';\n            billingAddress = createBillingAddress(billingAddress);\n            quote.billingAddress(billingAddress);\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Triggers when customer click \"Continue to PayPal\" button\n         */\n        payWithPayPal: function () {\n            if (additionalValidators.validate(false)) {\n                this.checkout.paypal.initAuthFlow();\n            }\n        },\n\n        /**\n         * Get a kebab case formatted string of the component ID (normally with `_`).\n         *\n         * @return {String|null}\n         */\n        getKebabCaseId: function () {\n            if (this.getId() === null) {\n                return null;\n            }\n\n            return this.getId().replace('_', '-');\n        },\n\n        /**\n         * Get the PayPal button placeholder id.\n         *\n         * @returns {String}\n         */\n        getPayPalButtonId: function () {\n            return this.getId() + '_placeholder';\n        },\n\n        /**\n         * Get PayPal Pay Later button placeholder id.\n         *\n         * @returns {String}\n         */\n        getPayLaterButtonId: function () {\n            return this.getId() + '_paylater_placeholder';\n        },\n\n        /**\n         * Check if Pay Later enabled.\n         *\n         * @returns {boolean}\n         */\n        isPayLaterEnabled: function () {\n            return _.get(window.checkoutConfig.payment, ['braintree_paypal_paylater', 'isActive'], false);\n        },\n\n        /**\n         * Check if Pay Later messaging enabled.\n         *\n         * @returns {boolean}\n         */\n        isPayLaterMessageEnabled: function () {\n            return _.get(window.checkoutConfig.payment, ['braintree_paypal_paylater', 'isMessageActive'], false);\n        },\n\n        /**\n         * Get the formatted grand total.\n         *\n         * @return {string}\n         */\n        getGrandTotalAmount: function () {\n            return formatAmount(this.grandTotalAmount);\n        },\n\n        /**\n         * Get locale\n         *\n         * @returns {String}\n         */\n        getLocale: function () {\n            return _.get(window.checkoutConfig.payment, ['braintree_paypal', 'locale'], '');\n        },\n\n        /**\n         * Get PayPal Pay Later Message Layout.\n         *\n         * @returns {string}\n         */\n        getMessagingLayout: function () {\n            return _.get(window.checkoutConfig.payment, ['braintree_paypal_paylater', 'message', 'layout'], '');\n        },\n\n        /**\n         * Get PayPal Pay Later Message Logo.\n         *\n         * @returns {string}\n         */\n        getMessagingLogo: function () {\n            return _.get(window.checkoutConfig.payment, ['braintree_paypal_paylater', 'message', 'logo'], '');\n        },\n\n        /**\n         * Get PayPal Pay Later Message Logo position.\n         *\n         * @returns {string}\n         */\n        getMessagingLogoPosition: function () {\n            return _.get(window.checkoutConfig.payment, ['braintree_paypal_paylater', 'message', 'logo_position'], '');\n        },\n\n        /**\n         * Get PayPal Pay Later Message Text Color.\n         *\n         * @returns {string}\n         */\n        getMessagingTextColor: function () {\n            return _.get(window.checkoutConfig.payment, ['braintree_paypal_paylater', 'message', 'text_color'], '');\n        },\n\n        /**\n         * Is Billing Address required from PayPal side.\n         *\n         * @returns {exports.isRequiredBillingAddress|(function())|boolean|String}\n         */\n        isRequiredBillingAddress: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].isRequiredBillingAddress;\n        },\n\n        /**\n         * Show error message\n         *\n         * @param {String} errorMessage\n         */\n        showError: function (errorMessage) {\n            globalMessageList.addErrorMessage({\n                message: errorMessage\n            });\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Get line items\n         *\n         * @returns {Array}\n         */\n        getLineItems: function () {\n            let self = this,\n                lineItems = [];\n\n            if (this.canSendLineItems()) {\n                let giftWrappingItems = 0,\n                    giftWrappingOrder = 0,\n                    storeCredit = 0,\n                    giftCardAccount = 0,\n                    giftWrappingPrintedCard = 0,\n                    baseDiscountAmount,\n                    baseTaxAmount;\n\n                $.each(quote.totals()['total_segments'], function (segmentsKey, segmentsItem) {\n                    if (segmentsItem['code'] === 'customerbalance') {\n                        storeCredit = formatAmount(Math.abs(segmentsItem['value']).toString());\n                    }\n                    if (segmentsItem['code'] === 'giftcardaccount') {\n                        giftCardAccount = formatAmount(Math.abs(segmentsItem['value']).toString());\n                    }\n                    if (segmentsItem['code'] === 'giftwrapping') {\n                        let extensionAttributes = segmentsItem['extension_attributes'];\n\n                        giftWrappingOrder = extensionAttributes['gw_base_price'];\n                        giftWrappingItems = extensionAttributes['gw_items_base_price'];\n                        giftWrappingPrintedCard = extensionAttributes['gw_card_base_price'];\n                    }\n                });\n\n                $.each(quote.getItems(), function (quoteItemKey, quoteItem) {\n                    if (quoteItem.parent_item_id !== null || quoteItem.price === 0.0) {\n                        return true;\n                    }\n\n                    let itemName = replaceUnsupportedCharacters(quoteItem.name),\n                        itemSku = replaceUnsupportedCharacters(quoteItem.sku),\n\n                        description = '',\n                        itemQty = parseFloat(quoteItem.qty),\n                        itemUnitAmount = parseFloat(quoteItem.price),\n                        lineItemValues,\n                        mappedLineItems;\n\n                    if (itemQty > Math.floor(itemQty) && itemQty < Math.ceil(itemQty)) {\n                        description = 'Item quantity is ' + itemQty.toFixed(2)\n                            + ' and per unit amount is ' + itemUnitAmount.toFixed(2);\n                        itemUnitAmount = parseFloat(itemQty * itemUnitAmount);\n                        itemQty = parseFloat('1');\n                    }\n\n                    lineItemValues = [\n                        itemName,\n                        'debit',\n                        itemQty.toFixed(2),\n                        itemUnitAmount.toFixed(2),\n                        itemSku,\n                        description\n                    ],\n\n                    mappedLineItems = $.map(self.lineItemsArray, function (itemElement, itemIndex) {\n                        return [[\n                            self.lineItemsArray[itemIndex],\n                            lineItemValues[itemIndex]\n                        ]];\n                    });\n\n                    lineItems[quoteItemKey] = Object.fromEntries(mappedLineItems);\n                });\n\n                /**\n                 * Adds credit (refund or discount) kind as LineItems for the\n                 * PayPal transaction if discount amount is greater than 0(Zero)\n                 * as discountAmount lineItem field is not being used by PayPal.\n                 *\n                 * developer.paypal.com/braintree/docs/reference/response/transaction-line-item/php#discount_amount\n                 */\n                baseDiscountAmount = formatAmount(Math.abs(quote.totals()['base_discount_amount']).toString());\n\n                if (baseDiscountAmount > 0) {\n                    let discountLineItem = {\n                        'name': 'Discount',\n                        'kind': 'credit',\n                        'quantity': 1.00,\n                        'unitAmount': baseDiscountAmount\n                    };\n\n                    lineItems = $.merge(lineItems, [discountLineItem]);\n                }\n\n                /**\n                 * Adds shipping as LineItems for the PayPal transaction\n                 * if shipping amount is greater than 0(Zero) to manage\n                 * the totals with client-side implementation as there is\n                 * no any field exist in the client-side implementation\n                 * to send the shipping amount to the Braintree.\n                 */\n                if (quote.totals()['base_shipping_amount'] > 0) {\n                    let shippingLineItem = {\n                        'name': 'Shipping',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': quote.totals()['base_shipping_amount']\n                    };\n\n                    lineItems = $.merge(lineItems, [shippingLineItem]);\n                }\n\n                baseTaxAmount = formatAmount(quote.totals()['base_tax_amount']);\n\n                if (baseTaxAmount > 0) {\n                    let taxLineItem = {\n                        'name': 'Tax',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': baseTaxAmount\n                    };\n\n                    lineItems = $.merge(lineItems, [taxLineItem]);\n                }\n\n                /**\n                 * Adds credit (Store Credit) kind as LineItems for the\n                 * PayPal transaction if store credit is greater than 0(Zero)\n                 * to manage the totals with client-side implementation\n                 */\n                if (storeCredit > 0) {\n                    let storeCreditItem = {\n                        'name': 'Store Credit',\n                        'kind': 'credit',\n                        'quantity': 1.00,\n                        'unitAmount': storeCredit\n                    };\n\n                    lineItems = $.merge(lineItems, [storeCreditItem]);\n                }\n\n                /**\n                 * Adds Gift Wrapping for items as LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftWrappingItems > 0) {\n                    let gwItems = {\n                        'name': 'Gift Wrapping for Items',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': giftWrappingItems\n                    };\n\n                    lineItems = $.merge(lineItems, [gwItems]);\n                }\n\n                /**\n                 * Adds Gift Wrapping for order as LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftWrappingOrder > 0) {\n                    let gwOrderItem = {\n                        'name': 'Gift Wrapping for Order',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': giftWrappingOrder\n                    };\n\n                    lineItems = $.merge(lineItems, [gwOrderItem]);\n                }\n\n                /**\n                 * Adds Gift Wrapping Printed Card as LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftWrappingPrintedCard > 0) {\n                    let gwPrintedCard = {\n                        'name': 'Printed Card',\n                        'kind': 'debit',\n                        'quantity': 1.00,\n                        'unitAmount': giftWrappingPrintedCard\n                    };\n\n                    lineItems = $.merge(lineItems, [gwPrintedCard]);\n                }\n\n                /**\n                 * Adds Gift Cards as credit LineItems for the PayPal\n                 * transaction if it is greater than 0(Zero) to manage\n                 * the totals with client-side implementation\n                 */\n                if (giftCardAccount > 0) {\n                    let giftCardItem = {\n                        'name': 'Gift Cards',\n                        'kind': 'credit',\n                        'quantity': 1.00,\n                        'unitAmount': giftCardAccount\n                    };\n\n                    lineItems = $.merge(lineItems, [giftCardItem]);\n                }\n\n                if (lineItems.length >= 250) {\n                    lineItems = [];\n                }\n            }\n            return lineItems;\n        },\n\n        /**\n         * Can send line items\n         *\n         * @returns {Boolean}\n         */\n        canSendLineItems: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].canSendLineItems;\n        },\n\n        /**\n         * Get the Button ID for the required funding\n         *\n         * @param {string} funding\n         * @return {string}\n         */\n        getButtonIdByFunding: function (funding) {\n            if (funding === 'paylater') {\n                return this.getPayLaterButtonId();\n            }\n\n            return this.getPayPalButtonId();\n        },\n\n        /**\n         * Get the label config associated to the PayPal funding source.\n         *\n         * @param {string} funding\n         * @return {string}\n         */\n        getLabelByFunding: function (funding) {\n            return _.get(\n                window.checkoutConfig.payment,\n                [this.getPaymentMethodCodeByFunding(funding), 'style', 'label'],\n                ''\n            );\n        },\n\n        /**\n         * Get the color config associated to the PayPal funding source.\n         *\n         * @param {string} funding\n         * @return {string}\n         */\n        getColorByFunding: function (funding) {\n            return _.get(\n                window.checkoutConfig.payment,\n                [this.getPaymentMethodCodeByFunding(funding), 'style', 'color'],\n                ''\n            );\n        },\n\n        /**\n         * Get the shape config associated to the PayPal funding source.\n         *\n         * @param {string} funding\n         * @return {string}\n         */\n        getShapeByFunding: function (funding) {\n            return _.get(\n                window.checkoutConfig.payment,\n                [this.getPaymentMethodCodeByFunding(funding), 'style', 'shape'],\n                ''\n            );\n        },\n\n        /**\n         * Get the payment method code related to the PayPal funding source.\n         *\n         * @param {string} funding\n         * @return {string}\n         */\n        getPaymentMethodCodeByFunding: function (funding) {\n            if (funding === 'paylater') {\n                return 'braintree_paypal_paylater';\n            }\n\n            return 'braintree_paypal';\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/paypal-vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, _, VaultComponent, globalMessageList, fullScreenLoader) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/paypal/vault',\n            additionalData: {}\n        },\n\n        /**\n         * Get PayPal payer email\n         * @returns {String}\n         */\n        getPayerEmail: function () {\n            return this.details.payerEmail;\n        },\n\n        /**\n         * Get type of payment\n         * @returns {String}\n         */\n        getPaymentIcon: function () {\n            return window.checkoutConfig.payment['braintree_paypal'].paymentIcon;\n        },\n\n        /**\n         * Place order\n         */\n        beforePlaceOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            })\n                .done(function (response) {\n                    fullScreenLoader.stopLoader();\n                    self.additionalData['payment_method_nonce'] = response.paymentMethodNonce;\n                    self.placeOrder();\n                })\n                .fail(function (response) {\n                    var error = JSON.parse(response.responseText);\n\n                    fullScreenLoader.stopLoader();\n                    globalMessageList.addErrorMessage({\n                        message: error.message\n                    });\n                });\n        },\n\n        /**\n         * Get payment method data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/paypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'braintree',\n    'braintreeCheckoutPayPalAdapter',\n    'braintreePayPalCheckout',\n    'PayPal_Braintree/js/helper/format-amount',\n    'PayPal_Braintree/js/helper/remove-non-digit-characters',\n    'PayPal_Braintree/js/helper/replace-unsupported-characters',\n    'PayPal_Braintree/js/helper/get-cart-line-items-helper',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'Magento_Checkout/js/action/create-billing-address',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_CheckoutAgreements/js/view/checkout-agreements',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Component,\n    braintree,\n    Braintree,\n    paypalCheckout,\n    formatAmount,\n    removeNonDigitCharacters,\n    replaceUnsupportedCharacters,\n    getCartLineItems,\n    quote,\n    fullScreenLoader,\n    additionalValidators,\n    stepNavigator,\n    VaultEnabler,\n    createBillingAddress,\n    selectBillingAddress,\n    checkoutAgreements,\n    $t\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/paypal',\n            code: 'braintree_paypal',\n            active: false,\n            paypalInstance: null,\n            paymentMethodNonce: null,\n            grandTotalAmount: null,\n            isReviewRequired: false,\n            customerEmail: null,\n\n            /**\n             * Additional payment data\n             *\n             * {Object}\n             */\n            additionalData: {},\n\n            /**\n             * Line items array\n             *\n             * {Array}\n             */\n            lineItemsArray: [\n                'name',\n                'kind',\n                'quantity',\n                'unitAmount',\n                'productCode',\n                'description'\n            ],\n\n            /**\n             * PayPal client configuration\n             *\n             * {Object}\n             */\n            clientConfig: {\n                offerCredit: false,\n                offerCreditOnly: false,\n                dataCollector: {\n                    paypal: true\n                },\n\n                buttonPayPalId: 'braintree_paypal_placeholder',\n                buttonCreditId: 'braintree_paypal_credit_placeholder',\n                buttonPayLaterId: 'braintree_paypal_paylater_placeholder',\n\n                onDeviceDataReceived: function (deviceData) {\n                    this.additionalData['device_data'] = deviceData;\n                },\n\n                /**\n                 * Triggers when widget is loaded\n                 */\n                onReady: function () {\n                    this.setupPayPal();\n                },\n\n                /**\n                 * Triggers on payment nonce receive\n                 *\n                 * @param {Object} response\n                 */\n                onPaymentMethodReceived: function (response) {\n                    this.beforePlaceOrder(response);\n                }\n            },\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         *\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            let self = this;\n\n            this._super()\n                .observe(['active', 'isReviewRequired', 'customerEmail']);\n\n            window.addEventListener('hashchange', function (e) {\n                let methodCode = quote.paymentMethod();\n\n                if (methodCode === 'braintree_paypal' || methodCode === 'braintree_paypal_vault') {\n                    if (e.newURL.indexOf('payment') > 0 && self.grandTotalAmount !== null) {\n                        self.reInitPayPal();\n                    }\n                }\n            });\n\n            quote.paymentMethod.subscribe(function (value) {\n                let methodCode = value;\n\n                if (methodCode === 'braintree_paypal' || methodCode === 'braintree_paypal_vault') {\n                    self.reInitPayPal();\n                }\n            });\n\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n            this.vaultEnabler.isActivePaymentTokenEnabler.subscribe(function () {\n                self.onVaultPaymentTokenEnablerChange();\n            });\n\n            this.grandTotalAmount = quote.totals()['base_grand_total'];\n\n            quote.totals.subscribe(function () {\n                if (self.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    self.grandTotalAmount = quote.totals()['base_grand_total'];\n                    let methodCode = quote.paymentMethod();\n\n                    if (methodCode &&\n                        (methodCode.method === 'braintree_paypal' || methodCode.method === 'braintree_paypal_vault')) {\n                        self.reInitPayPal();\n                    }\n                }\n            });\n\n            // for each component initialization need update property\n            this.isReviewRequired(false);\n            this.initClientConfig();\n\n            return this;\n        },\n\n        /**\n         * Get payment name\n         *\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get payment title\n         *\n         * @returns {String}\n         */\n        getTitle: function () {\n            return window.checkoutConfig.payment[this.getCode()].title;\n        },\n\n        /**\n         * Check if payment is active\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            let active = this.getCode() === this.isChecked();\n\n            this.active(active);\n\n            return active;\n        },\n\n        /**\n         * Triggers when payment method change\n         *\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                return;\n            }\n\n            // need always re-init Braintree with PayPal configuration\n            this.reInitPayPal();\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n        },\n\n        /**\n         * Set payment nonce\n         *\n         * @param {String} paymentMethodNonce\n         */\n        setPaymentMethodNonce: function (paymentMethodNonce) {\n            this.paymentMethodNonce = paymentMethodNonce;\n        },\n\n        /**\n         * Update quote billing address\n         *\n         * @param {Object}customer\n         * @param {Object}address\n         */\n        setBillingAddress: function (customer, address) {\n            let billingAddress = {\n                street: [address.line1],\n                city: address.city,\n                postcode: address.postalCode,\n                countryId: address.countryCode,\n                email: customer.email,\n                firstname: customer.firstName,\n                lastname: customer.lastName,\n                telephone: removeNonDigitCharacters(_.get(customer, 'phone', '00000000000'))\n            };\n\n            billingAddress['region_code'] = typeof address.state === 'string' ? address.state : '';\n            billingAddress = createBillingAddress(billingAddress);\n            quote.billingAddress(billingAddress);\n        },\n\n        /**\n         * Prepare data to place order\n         *\n         * @param {Object} data\n         */\n        beforePlaceOrder: function (data) {\n            this.setPaymentMethodNonce(data.nonce);\n            this.customerEmail(data.details.email);\n            if (quote.isVirtual()) {\n                this.isReviewRequired(true);\n            } else if (this.isRequiredBillingAddress() === '1' || quote.billingAddress() === null) {\n                if (typeof data.details.billingAddress !== 'undefined') {\n                    this.setBillingAddress(data.details, data.details.billingAddress);\n                } else {\n                    this.setBillingAddress(data.details, data.details.shippingAddress);\n                }\n            } else if (quote.shippingAddress() === quote.billingAddress()) {\n                selectBillingAddress(quote.shippingAddress());\n            } else {\n                selectBillingAddress(quote.billingAddress());\n            }\n            this.placeOrder();\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            this.disableButton();\n            this.clientConfig.paypal.amount = formatAmount(this.grandTotalAmount);\n\n            if (!quote.isVirtual()) {\n                this.clientConfig.paypal.enableShippingAddress = true;\n                this.clientConfig.paypal.shippingAddressEditable = false;\n                this.clientConfig.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n            // Send Line Items\n            this.clientConfig.paypal.lineItems = getCartLineItems();\n\n            Braintree.setConfig(this.clientConfig);\n\n            if (Braintree.getPayPalInstance()) {\n                Braintree.getPayPalInstance().teardown(function () {\n                    Braintree.setup();\n                });\n                Braintree.setPayPalInstance(null);\n            } else {\n                Braintree.setup();\n                this.enableButton();\n            }\n        },\n\n        /**\n         * Setup PayPal instance\n         */\n        setupPayPal: function () {\n            if (Braintree.config.paypalInstance) {\n                fullScreenLoader.stopLoader(true);\n                return;\n            }\n\n            paypalCheckout.create({\n                client: Braintree.clientInstance\n            }, function (createErr, paypalCheckoutInstance) {\n                if (createErr) {\n                    Braintree.showError(\n                        $t('PayPal Checkout could not be initialized. Please contact the store owner.'));\n                    console.error('paypalCheckout error', createErr);\n                    return;\n                }\n                let quoteObj = quote.totals(),\n                    configSDK = {\n                        components: 'buttons,messages,funding-eligibility',\n                        'enable-funding': this.isCreditEnabled() ? 'credit' : 'paylater',\n                        currency: quoteObj['base_currency_code']\n                    },\n                    buyerCountry = this.getMerchantCountry();\n\n                if (Braintree.getEnvironment() === 'sandbox' && buyerCountry !== null) {\n                    configSDK['buyer-country'] = buyerCountry;\n                }\n                paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                    this.loadPayPalButton(paypalCheckoutInstance, 'paypal');\n                    if (this.isCreditEnabled()) {\n                        this.loadPayPalButton(paypalCheckoutInstance, 'credit');\n                    }\n                    if (this.isPayLaterEnabled()) {\n                        this.loadPayPalButton(paypalCheckoutInstance, 'paylater');\n                    }\n\n                }.bind(this));\n            }.bind(this));\n        },\n\n        loadPayPalButton: function (paypalCheckoutInstance, funding) {\n            let paypalPayment = Braintree.config.paypal,\n                onPaymentMethodReceived = Braintree.config.onPaymentMethodReceived,\n                style = {\n                    label: Braintree.getLabel(funding),\n                    color: Braintree.getColor(funding),\n                    shape: Braintree.getShape(funding)\n                },\n                button,\n                events = Braintree.events,\n                payPalButtonId,\n                payPalButtonElement;\n\n            if (funding === 'credit') {\n                Braintree.config.buttonId = this.getCreditButtonId();\n            } else if (funding === 'paylater') {\n                Braintree.config.buttonId = this.getPayLaterButtonId();\n            } else {\n                Braintree.config.buttonId = this.getPayPalButtonId();\n            }\n\n            payPalButtonId = Braintree.config.buttonId;\n            payPalButtonElement = $('#' + Braintree.config.buttonId);\n            payPalButtonElement.html('');\n\n            // Render\n            Braintree.config.paypalInstance = paypalCheckoutInstance;\n\n            button = window.paypal.Buttons({\n                fundingSource: funding,\n                env: Braintree.getEnvironment(),\n                style: style,\n                commit: true,\n                locale: Braintree.config.paypal.locale,\n\n                onInit: function (data, actions) {\n                    let agreements = checkoutAgreements().agreements,\n                        shouldDisableActions = false;\n\n                    actions.disable();\n\n                    _.each(agreements, function (item) {\n                        if (checkoutAgreements().isAgreementRequired(item)) {\n                            let paymentMethodCode = quote.paymentMethod().method,\n                                inputId = '#agreement_' + paymentMethodCode + '_' + item.agreementId,\n                                inputEl = document.querySelector(inputId);\n\n                            if (!inputEl.checked) {\n                                shouldDisableActions = true;\n                            }\n\n                            inputEl.addEventListener('change', function () {\n                                if (additionalValidators.validate()) {\n                                    actions.enable();\n                                } else {\n                                    actions.disable();\n                                }\n                            });\n                        }\n                    });\n\n                    if (!shouldDisableActions) {\n                        actions.enable();\n                    }\n                },\n\n                createOrder: function () {\n                    return paypalCheckoutInstance.createPayment(paypalPayment).catch(function (err) {\n                        throw err.details.originalError.details.originalError.paymentResource;\n                    });\n                },\n\n                onCancel: function (data) {\n                    console.log('checkout.js payment cancelled', JSON.stringify(data, 0, 2));\n\n                    if (typeof events.onCancel === 'function') {\n                        events.onCancel();\n                    }\n                },\n\n                onError: function (err) {\n                    if (err.errorName === 'VALIDATION_ERROR' && err.errorMessage.indexOf('Value is invalid') !== -1) {\n                        Braintree.showError(\n                            $t(\n                                'Address failed validation. Please check and confirm your City, State, and Postal Code'\n                            )\n                        );\n                    } else {\n                        Braintree.showError(\n                            $t('PayPal Checkout could not be initialized. Please contact the store owner.'));\n                    }\n                    Braintree.config.paypalInstance = null;\n                    console.error('Paypal checkout.js error', err);\n\n                    if (typeof events.onError === 'function') {\n                        events.onError(err);\n                    }\n                },\n\n                onClick: function (data) {\n                    if (!quote.isVirtual()) {\n                        this.clientConfig.paypal.enableShippingAddress = true;\n                        this.clientConfig.paypal.shippingAddressEditable = false;\n                        this.clientConfig.paypal.shippingAddressOverride = this.getShippingAddress();\n                    }\n\n                    // To check term & conditions input checked - validate additional validators.\n                    if (!additionalValidators.validate()) {\n                        return false;\n                    }\n\n                    if (typeof events.onClick === 'function') {\n                        events.onClick(data);\n                    }\n                }.bind(this),\n\n                onApprove: function (data) {\n                    return paypalCheckoutInstance.tokenizePayment(data)\n                        .then(function (payload) {\n                            onPaymentMethodReceived(payload);\n                        });\n                }\n            });\n\n            if (button.isEligible() && payPalButtonElement.length) {\n                button.render('#' + payPalButtonId).then(function () {\n                    Braintree.enableButton();\n                    if (typeof Braintree.config.onPaymentMethodError === 'function') {\n                        Braintree.config.onPaymentMethodError();\n                    }\n                }).then(function (data) {\n                    if (typeof events.onRender === 'function') {\n                        events.onRender(data);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Get locale\n         *\n         * @returns {String}\n         */\n        getLocale: function () {\n            return window.checkoutConfig.payment[this.getCode()].locale;\n        },\n\n        /**\n         * Is Billing Address required from PayPal side\n         *\n         * @returns {exports.isRequiredBillingAddress|(function())|boolean}\n         */\n        isRequiredBillingAddress: function () {\n            return window.checkoutConfig.payment[this.getCode()].isRequiredBillingAddress;\n        },\n\n        /**\n         * Get configuration for PayPal\n         *\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            let totals = quote.totals(),\n                config = {},\n                isActiveVaultEnabler = this.isActiveVault();\n\n            config.paypal = {\n                flow: 'checkout',\n                amount: formatAmount(this.grandTotalAmount),\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            if (isActiveVaultEnabler) {\n                config.paypal.requestBillingAgreement = true;\n            }\n\n            if (!quote.isVirtual()) {\n                config.paypal.enableShippingAddress = true;\n                config.paypal.shippingAddressEditable = false;\n                config.paypal.shippingAddressOverride = this.getShippingAddress();\n            }\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * Get shipping address\n         *\n         * @returns {Object}\n         */\n        getShippingAddress: function () {\n            let address = quote.shippingAddress();\n\n            return {\n                recipientName: address.firstname + ' ' + address.lastname,\n                line1: address.street[0],\n                line2: typeof address.street[2] === 'undefined'\n                    ? address.street[1] : address.street[1] + ' ' + address.street[2],\n                city: address.city,\n                countryCode: address.countryId,\n                postalCode: address.postcode,\n                state: address.regionCode\n            };\n        },\n\n        /**\n         * Get merchant name\n         *\n         * @returns {String}\n         */\n        getMerchantName: function () {\n            return window.checkoutConfig.payment[this.getCode()]['merchantName'];\n        },\n\n        /**\n         * Get data\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            let data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * Returns payment acceptance mark image path\n         *\n         * @returns {String}\n         */\n        getPaymentAcceptanceMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()]['paymentAcceptanceMarkSrc'];\n        },\n\n        /**\n         * Get paypal vault payment method code\n         *\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()]['vaultCode'];\n        },\n\n        /**\n         * Check if vault is active\n         *\n         * @returns {Boolean}\n         */\n        isActiveVault: function () {\n            return this.vaultEnabler.isVaultEnabled() && this.vaultEnabler.isActivePaymentTokenEnabler();\n        },\n\n        /**\n         * Re-init PayPal Auth flow to use Vault\n         */\n        onVaultPaymentTokenEnablerChange: function () {\n            this.clientConfig.paypal.singleUse = !this.isActiveVault();\n            this.reInitPayPal();\n        },\n\n        /**\n         * Disable submit button\n         */\n        disableButton: function () {\n            // stop any previous shown loaders\n            fullScreenLoader.stopLoader(true);\n            fullScreenLoader.startLoader();\n            $('[data-button=\"place\"]').attr('disabled', 'disabled');\n        },\n\n        /**\n         * Enable submit button\n         */\n        enableButton: function () {\n            $('[data-button=\"place\"]').removeAttr('disabled');\n            fullScreenLoader.stopLoader(true);\n        },\n\n        /**\n         * Triggers when customer click \"Continue to PayPal\" button\n         */\n        payWithPayPal: function () {\n            if (additionalValidators.validate()) {\n                Braintree.checkout.paypal.initAuthFlow();\n            }\n        },\n\n        /**\n         * Get PayPal button id\n         *\n         * @returns {String}\n         */\n        getPayPalButtonId: function () {\n            return this.clientConfig.buttonPayPalId;\n        },\n\n        /**\n         * Get Credit button id\n         *\n         * @returns {String}\n         */\n        getCreditButtonId: function () {\n            return this.clientConfig.buttonCreditId;\n        },\n\n        /**\n         * Get Pay Later button id\n         *\n         * @returns {String}\n         */\n        getPayLaterButtonId: function () {\n            return this.clientConfig.buttonPayLaterId;\n        },\n\n        /**\n         * Check if Pay Later enabled\n         *\n         * @returns {*}\n         */\n        isPayLaterEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['isActive'];\n        },\n\n        /**\n         * Check if Pay Later messaging enabled\n         *\n         * @returns {*}\n         */\n        isPayLaterMessageEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['isMessageActive'];\n        },\n\n        /**\n         * Get grand total\n         *\n         * @returns {string}\n         */\n        getGrandTotalAmount: function () {\n            return formatAmount(this.grandTotalAmount);\n        },\n\n        /**\n         * Check if PayPal Credit enabled\n         *\n         * @returns {*}\n         */\n        isCreditEnabled: function () {\n            return window.checkoutConfig.payment['braintree_paypal_credit']['isActive'];\n        },\n\n        /**\n         * Get Message Layout\n         *\n         * @returns {string}\n         */\n        getMessagingLayout: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['layout'];\n        },\n\n        /**\n         * Get Message Logo\n         *\n         * @returns {string}\n         */\n        getMessagingLogo: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['logo'];\n        },\n\n        /**\n         * Get Message Logo position\n         *\n         * @returns {string}\n         */\n        getMessagingLogoPosition: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['logo_position'];\n        },\n\n        /**\n         * Get Message Text Color\n         *\n         * @returns {string}\n         */\n        getMessagingTextColor: function () {\n            return window.checkoutConfig.payment['braintree_paypal_paylater']['message']['text_color'];\n        },\n\n        /**\n         * Get merchant country\n         *\n         * @returns {*}\n         */\n        getMerchantCountry: function () {\n            return window.checkoutConfig.payment[this.getCode()]['merchantCountry'];\n        },\n\n        /**\n         * Regex to replace all unsupported characters.\n         *\n         * @param str\n         */\n        replaceUnsupportedCharacters: function (str) {\n            // eslint-disable-next-line no-useless-escape\n            str.replace('/[^a-zA-Z0-9\\s\\-.\\']/', '');\n            return str.substr(0, 127);\n        },\n\n        /**\n         * Can send line items\n         *\n         * @returns {Boolean}\n         */\n        canSendLineItems: function () {\n            return window.checkoutConfig.payment[this.getCode()].canSendLineItems;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/venmo-vault.js":"/*browser:true*/\n\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/validator-handler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function (\n    ko,\n    $,\n    _,\n    VaultComponent,\n    globalMessageList,\n    validatorManager,\n    additionalValidators,\n    fullScreenLoader\n) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            active: false,\n            imports: {\n                onActiveChange: 'active'\n            },\n            template: 'PayPal_Braintree/payment/venmo/vault',\n            validatorManager: validatorManager,\n            additionalData: {}\n        },\n\n        /**\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super().observe(['active']);\n            this.validatorManager.initialize();\n            return this;\n        },\n\n        /**\n         * Is payment option active?\n         *\n         * @returns {boolean}\n         */\n        isActive: function () {\n            let active = this.getId() === this.isChecked();\n\n            this.active(active);\n            return active;\n        },\n\n        /**\n         * Return the payment method code.\n         *\n         * @returns {string}\n         */\n        getCode: function () {\n            return 'braintree_venmo_vault';\n        },\n\n        /**\n         * Get venmo username\n         *\n         * @returns {String}\n         */\n        getVenmoUsername: function () {\n            return this.details.username;\n        },\n\n        /**\n         * Get the Venmo icon\n         *\n         * @param type\n         * @return {*|boolean}\n         */\n        getVenmoIcon() {\n            return window.checkoutConfig.payment.braintree_venmo.paymentMarkSrc;\n        },\n\n        /**\n         * trigger Place order action.\n         *\n         * Set payment method nonce & place order.\n         */\n        triggerPlaceOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce & places order.\n         */\n        getPaymentMethodNonce: function () {\n            let self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            }).done(function (response) {\n                fullScreenLoader.stopLoader();\n                self.additionalData['payment_method_nonce'] = response.paymentMethodNonce;\n                self.placeOrder();\n            }).fail(function (response) {\n                let error = JSON.parse(response.responseText);\n\n                fullScreenLoader.stopLoader();\n                globalMessageList.addErrorMessage({\n                    message: error.message\n                });\n            });\n        },\n\n        /**\n         * Get payment method data.\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            let data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/hosted-fields.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/method-renderer/cc-form',\n    'PayPal_Braintree/js/model/vault-enabler',\n    'PayPal_Braintree/js/validator',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'mage/translate'\n], function ($, Component, vaultEnablerModel, validator, additionalValidators, $t) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            template: 'PayPal_Braintree/payment/form',\n            clientConfig: {\n\n                /**\n                 * {String}\n                 */\n                id: 'co-transparent-form-braintree'\n            },\n            isValidCardNumber: false,\n            isValidExpirationDate: false,\n            isValidCvvNumber: false,\n\n            onInstanceReady: function (instance) {\n                instance.on('validityChange', this.onValidityChange.bind(this));\n                instance.on('cardTypeChange', this.onCardTypeChange.bind(this));\n            }\n        },\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = vaultEnablerModel.getVaultEnabler();\n            vaultEnablerModel.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * Init config\n         */\n        initClientConfig: function () {\n            this._super();\n\n            this.clientConfig.hostedFields = this.getHostedFields();\n            this.clientConfig.styles = {\n                'input': {\n                    'font-size': '14pt',\n                    'color': '#3A3A3A'\n                },\n                ':focus': {\n                    'color': 'black'\n                },\n                '.valid': {\n                    'color': 'green'\n                },\n                '.invalid': {\n                    'color': 'red'\n                }\n            };\n            this.clientConfig.onInstanceReady = this.onInstanceReady.bind(this);\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = this._super();\n\n            vaultEnablerModel.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Bool}\n         */\n        isVaultEnabled: function () {\n            return vaultEnablerModel.isVaultEnabled();\n        },\n\n        /**\n         * Get Braintree Hosted Fields\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number'),\n                        placeholder: $t('4111 1111 1111 1111')\n                    },\n                    expirationDate: {\n                        selector: self.getSelector('expirationDate'),\n                        placeholder: $t('MM/YYYY')\n                    }\n                };\n\n            if (self.hasVerification()) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                };\n            }\n\n            return fields;\n        },\n\n        /**\n         * Triggers on Hosted Field changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onValidityChange: function (event) {\n            // Handle a change in validation or card type\n            if (event.emittedBy === 'number') {\n                this.selectedCardType(null);\n\n                if (event.cards.length === 1) {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.selectedCardType(\n                        validator.getMageCardType(event.cards[0].type, this.getCcAvailableTypes())\n                    );\n                    this.validateCardType();\n                } else {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.validateCardType();\n                }\n            }\n\n            // Other field validations\n            if (event.emittedBy === 'expirationDate') {\n                this.isValidExpirationDate = event.fields.expirationDate.isValid;\n            }\n            if (event.emittedBy === 'cvv') {\n                this.isValidCvvNumber = event.fields.cvv.isValid;\n            }\n        },\n\n        /**\n         * Triggers on Hosted Field card type changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onCardTypeChange: function (event) {\n            if (event.cards.length === 1) {\n                this.selectedCardType(\n                    validator.getMageCardType(event.cards[0].type, this.getCcAvailableTypes())\n                );\n            } else {\n                this.selectedCardType(null);\n            }\n        },\n\n        /**\n         * Toggle invalid class on selector\n         * @param selector\n         * @param state\n         * @returns {boolean}\n         */\n        validateField: function (selector, state) {\n            var $selector = $(this.getSelector(selector)),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            if (state === true) {\n                $selector.removeClass(invalidClass);\n                return true;\n            }\n\n            $selector.addClass(invalidClass);\n            return false;\n        },\n\n        /**\n         * Validate current credit card type\n         * @returns {Boolean}\n         */\n        validateCardType: function () {\n            return this.validateField(\n                'cc_number',\n                this.isValidCardNumber\n            );\n        },\n\n        /**\n         * Validate current expiry date\n         * @returns {boolean}\n         */\n        validateExpirationDate: function () {\n            return this.validateField(\n                'expirationDate',\n                this.isValidExpirationDate === true\n            );\n        },\n\n        /**\n         * Validate current CVV field\n         * @returns {boolean}\n         */\n        validateCvvNumber: function () {\n            var self = this;\n\n            if (self.hasVerification() === false) {\n                return true;\n            }\n\n            return this.validateField(\n                'cc_cid',\n                this.isValidCvvNumber === true\n            );\n        },\n\n        /**\n         * Validate all fields\n         * @returns {boolean}\n         */\n        validateFormFields: function () {\n            return (this.validateCardType() && this.validateExpirationDate() && this.validateCvvNumber()) === true;\n        },\n\n        /**\n         * Trigger order placing\n         */\n        placeOrderClick: function () {\n            if (this.validateFormFields() && additionalValidators.validate()) {\n                this.placeOrder();\n            }\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].ccVaultCode;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'PayPal_Braintree/js/view/payment/adapter',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/validator-handler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'braintree',\n    'braintreeHostedFields',\n    'mage/url'\n], function (\n    ko,\n    $,\n    VaultComponent,\n    Braintree,\n    globalMessageList,\n    validatorManager,\n    additionalValidators,\n    fullScreenLoader,\n    client,\n    hostedFields,\n    url\n) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            active: false,\n            hostedFieldsInstance: null,\n            imports: {\n                onActiveChange: 'active'\n            },\n            modules: {\n                hostedFields: '${ $.parentName }.braintree'\n            },\n            template: 'PayPal_Braintree/payment/cc/vault',\n            updatePaymentUrl: url.build('braintree/payment/updatepaymentmethod'),\n            vaultedCVV: ko.observable(''),\n            validatorManager: validatorManager,\n            isValidCvv: false,\n            onInstanceReady: function (instance) {\n                instance.on('validityChange', this.onValidityChange.bind(this));\n            }\n        },\n\n        /**\n         * Event fired by Braintree SDK whenever input value length matches the validation length.\n         * In the case of a CVV, this is 3, or 4 for AMEX.\n         *\n         * @param event\n         */\n        onValidityChange: function (event) {\n            if (event.emittedBy === 'cvv') {\n                this.isValidCvv = event.fields.cvv.isValid;\n            }\n        },\n\n        /**\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super().observe(['active']);\n            this.validatorManager.initialize();\n            return this;\n        },\n\n        /**\n         * Is payment option active?\n         *\n         * @returns {boolean}\n         */\n        isActive: function () {\n            let active = this.getId() === this.isChecked();\n\n            this.active(active);\n            return active;\n        },\n\n        /**\n         * Fired whenever a payment option is changed.\n         *\n         * @param isActive\n         */\n        onActiveChange: function (isActive) {\n            let self = this;\n\n            if (!isActive) {\n                return;\n            }\n\n            if (self.showCvvVerify()) {\n                if (self.hostedFieldsInstance) {\n                    self.hostedFieldsInstance.teardown(function (teardownError) {\n                        if (teardownError) {\n                            globalMessageList.addErrorMessage({\n                                message: teardownError.message\n                            });\n                        }\n                        self.hostedFieldsInstance = null;\n                        self.initHostedCvvField();\n                    });\n                    return;\n                }\n                self.initHostedCvvField();\n            }\n        },\n\n        /**\n         * Initialize the CVV input field with the Braintree Hosted Fields SDK.\n         */\n        initHostedCvvField: function () {\n            let self = this;\n\n            client.create({\n                authorization: Braintree.getClientToken()\n            }, function (clientError, clientInstance) {\n                if (clientError) {\n                    globalMessageList.addErrorMessage({\n                        message: clientError.message\n                    });\n                }\n                hostedFields.create({\n                    client: clientInstance,\n                    fields: {\n                        cvv: {\n                            selector: '#' + self.getId() + '_cid',\n                            placeholder: '123'\n                        }\n                    }\n                }, function (hostedError, hostedFieldsInstance) {\n                    if (hostedError) {\n                        globalMessageList.addErrorMessage({\n                            message: hostedError.message\n                        });\n                        return;\n                    }\n\n                    self.hostedFieldsInstance = hostedFieldsInstance;\n                    self.onInstanceReady(self.hostedFieldsInstance);\n                });\n            });\n        },\n\n        /**\n         * Return the payment method code.\n         *\n         * @returns {string}\n         */\n        getCode: function () {\n            return 'braintree_cc_vault';\n        },\n\n        /**\n         * Get last 4 digits of card\n         *\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details.maskedCC;\n        },\n\n        /**\n         * Get expiration date\n         *\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details.expirationDate;\n        },\n\n        /**\n         * Get card type\n         *\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details.type;\n        },\n\n        /**\n         * Get card icons\n         *\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        getIcons: function (type) {\n            return window.checkoutConfig.payment.braintree.icons.hasOwnProperty(type) ?\n                window.checkoutConfig.payment.braintree.icons[type]\n                : false;\n        },\n\n        /**\n         * Get show CVV Field\n         *\n         * @returns {Boolean}\n         */\n        showCvvVerify: function () {\n            return window.checkoutConfig.payment[this.code].cvvVerify;\n        },\n\n        /**\n         * Show or hide the error message.\n         *\n         * @param selector\n         * @param state\n         * @returns {boolean}\n         */\n        validateCvv: function (selector, state) {\n            let $selector = $(selector),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            if (state === true) {\n                $selector.removeClass(invalidClass);\n                return true;\n            }\n\n            $selector.addClass(invalidClass);\n            return false;\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            let self = this;\n\n            if (self.showCvvVerify()) {\n                if (!self.validateCvv('#' + self.getId() + '_cid', self.isValidCvv)\n                    || !additionalValidators.validate()) {\n                    return;\n                }\n            } else if (!additionalValidators.validate()) {\n                return;\n            }\n\n            fullScreenLoader.startLoader();\n\n            if (self.showCvvVerify() && typeof self.hostedFieldsInstance !== 'undefined') {\n                self.hostedFieldsInstance.tokenize({}, function (error, payload) {\n                    if (error) {\n                        fullScreenLoader.stopLoader();\n                        globalMessageList.addErrorMessage({\n                            message: error.message\n                        });\n                        return;\n                    }\n                    $.getJSON(self.updatePaymentUrl, {\n                        'nonce': payload.nonce,\n                        'public_hash': self.publicHash\n                    }).done(function (response) {\n                        if (response.success === false) {\n                            fullScreenLoader.stopLoader();\n                            globalMessageList.addErrorMessage({\n                                message: 'CVV verification failed.'\n                            });\n                            return;\n                        }\n                        self.getPaymentMethodNonce();\n                    });\n                });\n            } else {\n                self.getPaymentMethodNonce();\n            }\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            let self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash,\n                'cvv': self.vaultedCVV()\n            }).done(function (response) {\n                fullScreenLoader.stopLoader();\n                self.hostedFields(function (formComponent) {\n                    formComponent.setPaymentMethodNonce(response.paymentMethodNonce);\n                    formComponent.setCreditCardBin(response.details.bin);\n                    formComponent.additionalData['public_hash'] = self.publicHash;\n                    formComponent.code = self.code;\n                    if (self.vaultedCVV()) {\n                        formComponent.additionalData['cvv'] = self.vaultedCVV();\n                    }\n\n                    self.validatorManager.validate(formComponent, function () {\n                        fullScreenLoader.stopLoader();\n                        return formComponent.placeOrder('parent');\n                    }, function () {\n                        // No teardown actions required.\n                        fullScreenLoader.stopLoader();\n                        formComponent.setPaymentMethodNonce(null);\n                        formComponent.setCreditCardBin(null);\n                    });\n\n                });\n            }).fail(function (response) {\n                let error = JSON.parse(response.responseText);\n\n                fullScreenLoader.stopLoader();\n                globalMessageList.addErrorMessage({\n                    message: error.message\n                });\n            });\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/venmo.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeVenmo',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'mage/translate',\n        'Magento_Vault/js/view/payment/vault-enabler',\n        'underscore'\n    ],\n    function (\n        Component,\n        braintree,\n        dataCollector,\n        venmo,\n        formBuilder,\n        messageList,\n        fullScreenLoader,\n        additionalValidators,\n        $t,\n        VaultEnabler,\n        _\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                deviceData: null,\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/venmo',\n                venmoInstance: null,\n                vaultEnabler: null\n            },\n\n            clickVenmoBtn: function () {\n                var self = this;\n\n                if (!additionalValidators.validate()) {\n                    return false;\n                }\n\n                if (!this.venmoInstance) {\n                    this.setErrorMsg($t('Venmo not initialized, please try reloading.'));\n                    return;\n                }\n\n                this.venmoInstance.tokenize(function (tokenizeErr, payload) {\n                    if (tokenizeErr) {\n                        if (tokenizeErr.code === 'VENMO_CANCELED') {\n                            self.setErrorMsg($t('Venmo app is not available or the payment flow was cancelled.'));\n                        } else if (tokenizeErr.code === 'VENMO_APP_CANCELED') {\n                            self.setErrorMsg($t('Venmo payment flow cancelled.'));\n                        } else {\n                            self.setErrorMsg(tokenizeErr.message);\n                        }\n                    } else {\n                        self.handleVenmoSuccess(payload);\n                    }\n                });\n            },\n\n            collectDeviceData: function (clientInstance, callback) {\n                var self = this;\n\n                dataCollector.create({\n                    client: clientInstance,\n                    paypal: true\n                }, function (dataCollectorErr, dataCollectorInstance) {\n                    if (dataCollectorErr) {\n                        return;\n                    }\n                    self.deviceData = dataCollectorInstance.deviceData;\n                    callback();\n                });\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function () {\n                return 'braintree_venmo';\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                        'device_data': this.deviceData\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n                this.vaultEnabler.visitAdditionalData(data);\n\n                return data;\n            },\n\n            getPaymentMarkSrc: function () {\n                return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n            },\n\n            getTitle: function () {\n                return 'Venmo';\n            },\n\n            handleVenmoSuccess: function (payload) {\n                this.setPaymentMethodNonce(payload.nonce);\n                this.placeOrder();\n            },\n\n            initialize: function () {\n                var self = this;\n\n                this._super();\n                this.vaultEnabler = new VaultEnabler();\n                this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n                this.vaultEnabler.isActivePaymentTokenEnabler.subscribe(function () {\n                    self.venmoInstance.teardown(function () {\n                        self.initVenmo();\n                    });\n\n                });\n                this.initVenmo();\n                return this;\n            },\n\n            isAllowed: function () {\n                return window.checkoutConfig.payment[this.getCode()].isAllowed;\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            setVenmoInstance: function (instance) {\n                this.venmoInstance = instance;\n            },\n\n            isVaultEnabled: function () {\n                return this.vaultEnabler.isVaultEnabled();\n            },\n\n            /**\n             * @returns {String}\n             */\n            getVaultCode: function () {\n                return window.checkoutConfig.payment[this.getCode()].vaultCode;\n            },\n\n            getPaymentMethodUsage: function () {\n                return this.vaultEnabler.isActivePaymentTokenEnabler()\n                    ? 'multi_use'\n                    : 'single_use';\n            },\n\n            initVenmo: function () {\n                var self = this;\n\n                braintree.create({\n                    authorization: self.getClientToken()\n                }, function (clientError, clientInstance) {\n                    if (clientError) {\n                        this.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                        return;\n                    }\n\n                    // Collect device data\n                    self.collectDeviceData(clientInstance, function () {\n                        // callback from collectDeviceData\n                        venmo.create({\n                            client: clientInstance,\n                            allowDesktop: true,\n                            allowDesktopWebLogin: true,\n                            mobileWebFallBack: true,\n                            paymentMethodUsage: self.getPaymentMethodUsage(),\n                            allowNewBrowserTab: false\n                        }, function (venmoErr, venmoInstance) {\n                            if (venmoErr) {\n                                self.setErrorMsg($t('Error initializing Venmo: %1').replace('%1', venmoErr));\n                                return;\n                            }\n\n                            if (!venmoInstance.isBrowserSupported()) {\n                                console.log('Browser does not support Venmo');\n                                return;\n                            }\n\n                            self.setVenmoInstance(venmoInstance);\n                        });\n                    });\n                });\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/ach.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'jquery',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeAch',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/action/select-billing-address',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote',\n        'mage/translate',\n        'Magento_Vault/js/view/payment/vault-enabler',\n        'underscore'\n    ],\n    function (\n        Component,\n        ko,\n        $,\n        braintree,\n        dataCollector,\n        ach,\n        formBuilder,\n        messageList,\n        selectBillingAddress,\n        fullScreenLoader,\n        quote,\n        $t,\n        VaultEnabler,\n        _\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                deviceData: null,\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/ach',\n                achInstance: null,\n                routingNumber: ko.observable(''),\n                accountNumber: ko.observable(''),\n                accountType: ko.observable('checking'),\n                ownershipType: ko.observable('personal'),\n                firstName: ko.observable(''),\n                lastName: ko.observable(''),\n                businessName: ko.observable(''),\n                hasAuthorization: ko.observable(false),\n                business: ko.observable(false), // for ownership type\n                personal: ko.observable(true), // for ownership type\n                vaultEnabler: null\n            },\n\n            clickAchBtn: function () {\n                if (!this.validateForm('#' + this.getCode() + '-form')) {\n                    return;\n                }\n\n                fullScreenLoader.startLoader();\n\n                let self = this,\n\n                    billingAddress = quote.billingAddress(),\n\n                    regionCode,\n\n                    bankDetails = {\n                        routingNumber: self.routingNumber(),\n                        accountNumber: self.accountNumber(),\n                        accountType: self.accountType(),\n                        ownershipType: self.ownershipType(),\n                        billingAddress: {\n                            streetAddress: billingAddress.street[0],\n                            extendedAddress: billingAddress.street[1],\n                            locality: billingAddress.city,\n                            region: billingAddress.regionCode,\n                            postalCode: billingAddress.postcode\n                        }\n                    },\n\n                    mandateText = document.getElementById(self.isVaultActive()\n                        ? 'braintree-ach-mandate-vault'\n                        : 'braintree-ach-mandate'\n                    ).textContent;\n\n                if (bankDetails.ownershipType === 'personal') {\n                    bankDetails.firstName = self.firstName();\n                    bankDetails.lastName = self.lastName();\n                } else {\n                    bankDetails.businessName = self.businessName();\n                }\n\n                // if no region code is available, lets find one!\n                if (typeof billingAddress.regionCode === 'undefined') {\n                    $.get('/rest/V1/directory/countries/' + billingAddress.countryId).done(function (data) {\n                        if (typeof data.available_regions !== 'undefined') {\n                            data.available_regions.forEach(function (availableRegion) {\n                                if (availableRegion.id === billingAddress.regionId) {\n                                    regionCode = availableRegion.code;\n                                    bankDetails.billingAddress.region = regionCode;\n                                    self.tokenizeAch(bankDetails, mandateText);\n                                }\n                            });\n                        } else {\n                            fullScreenLoader.stopLoader();\n                            self.tokenizeAch(bankDetails, mandateText);\n                        }\n                    }).fail(function () {\n                        fullScreenLoader.stopLoader();\n                    });\n                } else {\n                    self.tokenizeAch(bankDetails, mandateText);\n                }\n            },\n\n            tokenizeAch: function (bankDetails, mandateText) {\n                let self = this;\n\n                self.achInstance.tokenize({\n                    bankDetails: bankDetails,\n                    mandateText: mandateText\n                }, function (tokenizeErr, tokenizedPayload) {\n                    if (tokenizeErr) {\n                        let error = 'There was an error with the provided bank details. Please check and try again.';\n\n                        self.setErrorMsg($t(error));\n                        self.hasAuthorization(false);\n                        fullScreenLoader.stopLoader();\n                    } else {\n                        fullScreenLoader.stopLoader();\n                        self.handleAchSuccess(tokenizedPayload);\n                    }\n                });\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function () {\n                return 'braintree_ach_direct_debit';\n            },\n\n            getStoreName: function () {\n                return window.checkoutConfig.payment[this.getCode()].storeName;\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                        'device_data': this.deviceData\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n                this.vaultEnabler.visitAdditionalData(data);\n\n                return data;\n            },\n\n            getTitle: function () {\n                return 'ACH Direct Debit';\n            },\n\n            handleAchSuccess: function (payload) {\n                this.setPaymentMethodNonce(payload.nonce);\n                this.placeOrder();\n            },\n\n            initialize: function () {\n                this._super();\n                this.vaultEnabler = new VaultEnabler();\n                this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n                let self = this;\n\n                this.vaultEnabler.isActivePaymentTokenEnabler.subscribe(function () {\n                    self.achInstance.teardown(function () {\n                        self.initAch();\n                    });\n                });\n\n                this.initAch();\n\n                return this;\n            },\n\n            isAllowed: function () {\n                return window.checkoutConfig.payment[this.getCode()].isAllowed;\n            },\n\n            /**\n             * Change the account type.\n             *\n             * @param data\n             * @param event\n             */\n            changeOwnershipType: function (data, event) {\n                let self = this;\n\n                if (event.currentTarget.value === 'business') {\n                    self.business(true);\n                    self.personal(false);\n                } else {\n                    self.business(false);\n                    self.personal(true);\n                }\n            },\n\n            /**\n             * Is Business type account.\n             *\n             * @returns {Boolean}\n             */\n            isBusiness: function () {\n                return this.business;\n            },\n\n            /**\n             * Is Personal type account.\n             *\n             * @returns {Boolean}\n             */\n            isPersonal: function () {\n                return this.personal;\n            },\n\n            /**\n             * Get the account holder name input.\n             *\n             * @returns {String}\n             */\n            getAccountHolderName: function () {\n                if (this.firstName() !== '' || this.lastName() !== '') {\n                    return this.firstName() + ' ' + this.lastName();\n                }\n\n                return 'XXXX';\n            },\n\n            /**\n             * Get the account number input.\n             *\n             * @returns {String}\n             */\n            getAccountNumber: function () {\n                return this.accountNumber() !== '' ? this.accountNumber() : 'XXXX';\n            },\n\n            /**\n             * Get the Bank Routing Number input.\n             *\n             * @returns {String}\n             */\n            getRoutingNumber: function () {\n                return this.routingNumber() !== '' ? this.routingNumber() : 'XXXX';\n            },\n\n            /**\n             * Get the quote totals value.\n             *\n             * @returns {String}\n             */\n            getGrandTotal: function () {\n                let totals = quote.getTotals()();\n\n                if (totals) {\n                    return totals['grand_total'];\n                }\n\n                return quote['grand_total'];\n            },\n\n            /**\n             * Get the current date in US format (ACH is US only).\n             *\n             * @returns {String}\n             */\n            getCurrentDate: function () {\n                const today = new Date();\n\n                return today.toLocaleDateString('en-US');\n            },\n\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            /**\n             * Set the ACH instance.\n             *\n             * @param {*} instance\n             */\n            setAchInstance: function (instance) {\n                this.achInstance = instance;\n            },\n\n            /**\n             * Validate ACH form.\n             *\n             * @param {*} form\n             * @returns {*|jQuery}\n             */\n            validateForm: function (form) {\n                return $(form).validation() && $(form).validation('isValid');\n            },\n\n            /**\n             * Get ACH's should vault checkbox element ID.\n             *\n             * @returns {String}\n             */\n            getVaultCheckboxId: function () {\n                return this.getCode() + '_enable_vault';\n            },\n\n            /**\n             * Check whether Vault is enabled.\n             *\n             * @returns {Boolean}\n             */\n            isVaultEnabled: function () {\n                return this.vaultEnabler.isVaultEnabled();\n            },\n\n            /**\n             * Is Vault enabled & vaulting payment active (checked)\n             *\n             * @returns {Boolean}\n             */\n            isVaultActive: function () {\n                return this.isVaultEnabled() && this.vaultEnabler.isActivePaymentTokenEnabler();\n            },\n\n            /**\n             * Get ACH vault payment method code.\n             *\n             * @returns {String}\n             */\n            getVaultCode: function () {\n                return window.checkoutConfig.payment[this.getCode()]['vaultCode'];\n            },\n\n            /**\n             * Initialize ACH component.\n             *\n             * @returns {void}\n             */\n            initAch: function () {\n                let self = this;\n\n                braintree.create({\n                    authorization: self.getClientToken()\n                }, function (clientError, clientInstance) {\n                    if (clientError) {\n                        this.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                        return;\n                    }\n\n                    /* Collect device data */\n                    self.collectDeviceData(clientInstance, function () {\n                        /* callback from collectDeviceData */\n                        ach.create({\n                            client: clientInstance\n                        }, function (achErr, achInstance) {\n                            if (achErr) {\n                                self.setErrorMsg($t('Error initializing ACH: %1').replace('%1', achErr));\n                                return;\n                            }\n\n                            self.setAchInstance(achInstance);\n                        });\n                    });\n                });\n            },\n\n            /**\n             * Collect device data.\n             *\n             * @param clientInstance\n             * @param {Function} callback\n             * @returns {void}\n             */\n            collectDeviceData: function (clientInstance, callback) {\n                let self = this;\n\n                dataCollector.create({\n                    client: clientInstance,\n                    paypal: true\n                }, function (dataCollectorErr, dataCollectorInstance) {\n                    if (dataCollectorErr) {\n                        return;\n                    }\n\n                    self.deviceData = dataCollectorInstance.deviceData;\n                    callback();\n                });\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/applepay-vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/validator-handler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function (\n    ko,\n    $,\n    _,\n    VaultComponent,\n    globalMessageList,\n    validatorManager,\n    additionalValidators,\n    fullScreenLoader\n) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            active: false,\n            imports: {\n                onActiveChange: 'active'\n            },\n            template: 'PayPal_Braintree/applepay/vault',\n            validatorManager: validatorManager,\n            additionalData: {}\n        },\n\n        /**\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super().observe(['active']);\n            this.validatorManager.initialize();\n            return this;\n        },\n\n        /**\n         * Is payment option active?\n         *\n         * @returns {boolean}\n         */\n        isActive: function () {\n            let active = this.getId() === this.isChecked();\n\n            this.active(active);\n            return active;\n        },\n\n        /**\n         * Return the payment method code.\n         *\n         * @returns {string}\n         */\n        getCode: function () {\n            return 'braintree_applepay_vault';\n        },\n\n        /**\n         * Get last 4 digits of card.\n         *\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details.maskedCC;\n        },\n\n        /**\n         * Get expiration date.\n         *\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details.expirationDate;\n        },\n\n        /**\n         * Get card type.\n         *\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details.type;\n        },\n\n        /**\n         * Get the ApplePay Card icons.\n         *\n         * @param type\n         * @return {*|boolean}\n         */\n        getApplePayIcons(type) {\n            let lowerCasedType = type.toLowerCase();\n\n            return window.checkoutConfig.payment.braintree_applepay.icons.hasOwnProperty(lowerCasedType) ?\n                window.checkoutConfig.payment.braintree_applepay.icons[lowerCasedType]\n                : false;\n        },\n\n        /**\n         * trigger Place order action.\n         *\n         * Set payment method nonce & place order.\n         */\n        triggerPlaceOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce & places order.\n         */\n        getPaymentMethodNonce: function () {\n            let self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            }).done(function (response) {\n                fullScreenLoader.stopLoader();\n                self.additionalData['payment_method_nonce'] = response.paymentMethodNonce;\n                self.placeOrder();\n            }).fail(function (response) {\n                let error = JSON.parse(response.responseText);\n\n                fullScreenLoader.stopLoader();\n                globalMessageList.addErrorMessage({\n                    message: error.message\n                });\n            });\n        },\n\n        /**\n         * Get payment method data.\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            let data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/googlepay-vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Ui/js/model/messageList',\n    'PayPal_Braintree/js/view/payment/validator-handler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function (\n    ko,\n    $,\n    _,\n    VaultComponent,\n    globalMessageList,\n    validatorManager,\n    additionalValidators,\n    fullScreenLoader\n) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            active: false,\n            imports: {\n                onActiveChange: 'active'\n            },\n            template: 'PayPal_Braintree/googlepay/vault',\n            validatorManager: validatorManager,\n            additionalData: {}\n        },\n\n        /**\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super().observe(['active']);\n            this.validatorManager.initialize();\n            return this;\n        },\n\n        /**\n         * Is payment option active?\n         *\n         * @returns {boolean}\n         */\n        isActive: function () {\n            let active = this.getId() === this.isChecked();\n\n            this.active(active);\n            return active;\n        },\n\n        /**\n         * Return the payment method code.\n         *\n         * @returns {string}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Get last 4 digits of card.\n         *\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details.maskedCC;\n        },\n\n        /**\n         * Get expiration date.\n         *\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details.expirationDate;\n        },\n\n        /**\n         * Get card type.\n         *\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details.type;\n        },\n\n        /**\n         * Get the Google Pay Card icons.\n         *\n         * @param type\n         * @return {*|boolean}\n         */\n        getGooglePayIcons: function (type) {\n            let lowerCasedType = type.toLowerCase();\n\n            return window.checkoutConfig.payment.braintree_googlepay.icons.hasOwnProperty(lowerCasedType) ?\n                window.checkoutConfig.payment.braintree_googlepay.icons[lowerCasedType]\n                : false;\n        },\n\n        /**\n         * trigger Place order action.\n         *\n         * Set payment method nonce & place order.\n         */\n        triggerPlaceOrder: function () {\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Send request to get payment method nonce & places order.\n         */\n        getPaymentMethodNonce: function () {\n            let self = this;\n\n            fullScreenLoader.startLoader();\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            }).done(function (response) {\n                fullScreenLoader.stopLoader();\n                self.additionalData['payment_method_nonce'] = response.paymentMethodNonce;\n                self.placeOrder();\n            }).fail(function (response) {\n                let error = JSON.parse(response.responseText);\n\n                fullScreenLoader.stopLoader();\n                globalMessageList.addErrorMessage({\n                    message: error.message\n                });\n            });\n        },\n\n        /**\n         * Get payment method data.\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            let data = {\n                'method': this.code,\n                'additional_data': {\n                    'public_hash': this.publicHash\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            return data;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/lpm.js":"define(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'ko',\n        'underscore',\n        'jquery',\n        'braintree',\n        'braintreeLpm',\n        'PayPal_Braintree/js/form-builder',\n        'Magento_Ui/js/model/messageList',\n        'Magento_Checkout/js/action/select-billing-address',\n        'PayPal_Braintree/js/helper/remove-non-digit-characters',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'mage/url',\n        'mage/translate'\n    ],\n    function (\n        Component,\n        ko,\n        _,\n        $,\n        braintree,\n        lpm,\n        formBuilder,\n        messageList,\n        selectBillingAddress,\n        removeNonDigitCharacters,\n        fullScreenLoader,\n        quote,\n        additionalValidators,\n        url,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                code: 'braintree_local_payment',\n                paymentMethodsAvailable: ko.observable(false),\n                paymentMethodNonce: null,\n                template: 'PayPal_Braintree/payment/lpm'\n            },\n\n            clickPaymentBtn: function (method) {\n                let self = this;\n\n                if (additionalValidators.validate()) {\n                    fullScreenLoader.startLoader();\n\n                    braintree.create({\n                        authorization: self.getClientToken()\n                    }, function (clientError, clientInstance) {\n                        if (clientError) {\n                            self.setErrorMsg($t('Unable to initialize Braintree Client.'));\n                            fullScreenLoader.stopLoader();\n                            return;\n                        }\n\n                        lpm.create({\n                            client: clientInstance,\n                            merchantAccountId: self.getMerchantAccountId()\n                        }, function (lpmError, lpmInstance) {\n                            if (lpmError) {\n                                self.setErrorMsg(lpmError);\n                                fullScreenLoader.stopLoader();\n                                return;\n                            }\n\n                            lpmInstance.startPayment({\n                                amount: self.getAmount(),\n                                currencyCode: self.getCurrencyCode(),\n                                email: self.getCustomerDetails().email,\n                                phone: removeNonDigitCharacters(_.get(self.getCustomerDetails(), 'phone', '')),\n                                givenName: self.getCustomerDetails().firstName,\n                                surname: self.getCustomerDetails().lastName,\n                                shippingAddressRequired: !quote.isVirtual(),\n                                address: self.getAddress(),\n                                paymentType: method,\n                                onPaymentStart: function (data, start) {\n                                    start();\n                                },\n                                // This is a required option, however it will apparently never be used in the current\n                                // payment flow. Therefore, both values are set to allow the payment flow to continue,\n                                // rather than error out.\n                                fallback: {\n                                    url: self.getFallbackUrl(),\n                                    buttonText: self.getFallbackButtonText()\n                                }\n                            }, function (startPaymentError, payload) {\n                                fullScreenLoader.stopLoader();\n                                if (startPaymentError) {\n                                    switch (startPaymentError.code) {\n                                    case 'LOCAL_PAYMENT_POPUP_CLOSED':\n                                        self.setErrorMsg($t('Local Payment popup was closed unexpectedly.'));\n                                        break;\n                                    case 'LOCAL_PAYMENT_WINDOW_OPEN_FAILED':\n                                        self.setErrorMsg($t('Local Payment popup failed to open.'));\n                                        break;\n                                    case 'LOCAL_PAYMENT_WINDOW_CLOSED':\n                                        self.setErrorMsg($t('Local Payment popup was closed. Payment cancelled.'));\n                                        break;\n                                    default:\n                                        self.setErrorMsg('Error! ' + startPaymentError);\n                                        break;\n                                    }\n                                } else {\n                                    // Send the nonce to your server to create a transaction\n                                    self.setPaymentMethodNonce(payload.nonce);\n                                    self.placeOrder();\n                                }\n                            });\n                        });\n                    });\n                }\n            },\n\n            getAddress: function () {\n                let shippingAddress = quote.shippingAddress();\n\n                if (quote.isVirtual()) {\n                    return {\n                        countryCode: shippingAddress.countryId\n                    };\n                }\n\n                return {\n                    streetAddress: shippingAddress.street[0],\n                    extendedAddress: shippingAddress.street[1],\n                    locality: shippingAddress.city,\n                    postalCode: shippingAddress.postcode,\n                    region: shippingAddress.region,\n                    countryCode: shippingAddress.countryId\n                };\n            },\n\n            getAmount: function () {\n                return quote.totals()['base_grand_total'].toString();\n            },\n\n            getBillingAddress: function () {\n                return quote.billingAddress();\n            },\n\n            getClientToken: function () {\n                return window.checkoutConfig.payment[this.getCode()].clientToken;\n            },\n\n            getCode: function () {\n                return this.code;\n            },\n\n            getCurrencyCode: function () {\n                return quote.totals()['base_currency_code'];\n            },\n\n            getCustomerDetails: function () {\n                let billingAddress = quote.billingAddress();\n\n                return {\n                    firstName: billingAddress.firstname,\n                    lastName: billingAddress.lastname,\n                    phone: billingAddress.telephone !== null ? billingAddress.telephone : '',\n                    email: typeof quote.guestEmail === 'string'\n                        ? quote.guestEmail : window.checkoutConfig.customerData.email\n                };\n            },\n\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            getMerchantAccountId: function () {\n                return window.checkoutConfig.payment[this.getCode()].merchantAccountId;\n            },\n\n            getPaymentMethod: function (method) {\n                let methods = this.getPaymentMethods();\n\n                for (let i = 0; i < methods.length; i++) {\n                    if (methods[i].method === method) {\n                        return methods[i];\n                    }\n                }\n            },\n\n            /**\n             * Get allowed local payment methods\n             *\n             * @returns {*}\n             */\n            getPaymentMethods: function () {\n                return window.checkoutConfig.payment[this.getCode()].allowedMethods;\n            },\n\n            /**\n             * Get payment icons\n             *\n             * @returns {*}\n             */\n            getPaymentMarkSrc: function () {\n                return window.checkoutConfig.payment[this.getCode()].paymentIcons;\n            },\n\n            /**\n             * Get title\n             *\n             * @returns {*}\n             */\n            getTitle: function () {\n                return window.checkoutConfig.payment[this.getCode()].title;\n            },\n\n            /**\n             * Get fallback url\n             *\n             * @returns {String}\n             */\n            getFallbackUrl: function () {\n                return window.checkoutConfig.payment[this.getCode()].fallbackUrl;\n            },\n\n            /**\n             * Get fallback button text\n             * @returns {String}\n             */\n            getFallbackButtonText: function () {\n                return window.checkoutConfig.payment[this.getCode()].fallbackButtonText;\n            },\n\n            /**\n             * Initialize\n             *\n             * @returns {*}\n             */\n            initialize: function () {\n                this._super();\n                return this;\n            },\n\n            /**\n             * Is payment method active?\n             *\n             * @returns {boolean}\n             */\n            isActive: function () {\n                let address = quote.billingAddress() || quote.shippingAddress(),\n                    methods = this.getPaymentMethods();\n\n                for (let i = 0; i < methods.length; i++) {\n                    if (methods[i].countries.includes(address.countryId)) {\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n\n            /**\n             * Is country and currency valid?\n             *\n             * @param method\n             * @returns {boolean}\n             */\n            isValidCountryAndCurrency: function (method) {\n                let address = quote.billingAddress(),\n                    countryId = address.countryId,\n                    quoteCurrency = quote.totals()['base_currency_code'],\n                    paymentMethodDetails = this.getPaymentMethod(method);\n\n                if (!address) {\n                    this.paymentMethodsAvailable(false);\n                    return false;\n                }\n\n                if (countryId !== 'GB' && paymentMethodDetails.countries.includes(countryId)\n                    && (quoteCurrency === 'EUR' || quoteCurrency === 'PLN') || countryId === 'GB'\n                    && paymentMethodDetails.countries.includes(countryId) && quoteCurrency === 'GBP') {\n                    this.paymentMethodsAvailable(true);\n                    return true;\n                }\n\n                return false;\n            },\n\n            /**\n             * Set error message\n             *\n             * @param message\n             */\n            setErrorMsg: function (message) {\n                messageList.addErrorMessage({\n                    message: message\n                });\n            },\n\n            /**\n             * Set payment method nonce\n             *\n             * @param nonce\n             */\n            setPaymentMethodNonce: function (nonce) {\n                this.paymentMethodNonce = nonce;\n            },\n\n            /**\n             * Validate form\n             *\n             * @param form\n             * @returns {*|jQuery}\n             */\n            validateForm: function (form) {\n                return $(form).validation() && $(form).validation('isValid');\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/cc-form.js":"/**\n * Copyright 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine(\n    [\n        'underscore',\n        'jquery',\n        'Magento_Payment/js/view/payment/cc-form',\n        'Magento_Checkout/js/model/quote',\n        'PayPal_Braintree/js/view/payment/adapter',\n        'mage/translate',\n        'PayPal_Braintree/js/validator',\n        'PayPal_Braintree/js/view/payment/validator-handler',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (\n        _,\n        $,\n        Component,\n        quote,\n        braintree,\n        $t,\n        validator,\n        validatorManager,\n        fullScreenLoader\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                active: false,\n                braintreeClient: null,\n                braintreeDeviceData: null,\n                paymentMethodNonce: null,\n                lastBillingAddress: null,\n                validatorManager: validatorManager,\n                code: 'braintree',\n                isProcessing: false,\n                creditCardBin: null,\n\n                /**\n                 * Additional payment data\n                 *\n                 * {Object}\n                 */\n                additionalData: {},\n\n                /**\n                 * Braintree client configuration\n                 *\n                 * {Object}\n                 */\n                clientConfig: {\n                    onReady: function (context) {\n                        context.setupHostedFields();\n                    },\n\n                    /**\n                     * Triggers on payment nonce receive\n                     * @param {Object} response\n                     */\n                    onPaymentMethodReceived: function (response) {\n                        this.handleNonce(response);\n                        this.isProcessing = false;\n                    },\n\n                    /**\n                     * Allow a new nonce to be generated\n                     */\n                    onPaymentMethodError: function () {\n                        this.isProcessing = false;\n                    },\n\n                    /**\n                     * Device data initialization\n                     * @param {String} deviceData\n                     */\n                    onDeviceDataReceived: function (deviceData) {\n                        if (this.additionalData === undefined) {\n                            this.additionalData = {};\n                        }\n                        this.additionalData['device_data'] = deviceData;\n                    },\n\n                    /**\n                     * After Braintree instance initialization\n                     */\n                    onInstanceReady: function () {},\n\n                    /**\n                     * Triggers on any Braintree error\n                     * @param {Object} response\n                     */\n                    onError: function (response) {\n                        this.isProcessing = false;\n                        braintree.showError($t('Payment ' + this.getTitle() + ' can\\'t be initialized'));\n                        throw response.message;\n                    },\n\n                    /**\n                     * Triggers when customer click \"Cancel\"\n                     */\n                    onCancelled: function () {\n                        this.paymentMethodNonce = null;\n                        this.isProcessing = false;\n                    }\n                },\n                imports: {\n                    onActiveChange: 'active'\n                }\n            },\n\n            /**\n             * Set list of observable attributes\n             *\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                validator.setConfig(window.checkoutConfig.payment[this.getCode()]);\n                this._super()\n                    .observe(['active']);\n                this.validatorManager.initialize();\n                this.initClientConfig();\n\n                return this;\n            },\n\n            /**\n             * Get payment name\n             *\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Check if payment is active\n             *\n             * @returns {Boolean}\n             */\n            isActive: function () {\n                let active = this.getCode() === this.isChecked();\n\n                this.active(active);\n\n                return active;\n            },\n\n            /**\n             * Triggers when payment method change\n             * @param {Boolean} isActive\n             */\n            onActiveChange: function (isActive) {\n                if (!isActive) {\n                    return;\n                }\n\n                this.initBraintree();\n            },\n\n            /**\n             * Init config\n             */\n            initClientConfig: function () {\n                _.each(this.clientConfig, function (fn, name) {\n                    if (typeof fn === 'function') {\n                        this.clientConfig[name] = fn.bind(this);\n                    }\n                }, this);\n            },\n\n            /**\n             * Init Braintree configuration\n             */\n            initBraintree: function () {\n                let intervalId = setInterval(function () {\n                    // stop loader when frame will be loaded\n                    if ($('#braintree-hosted-field-number').length) {\n                        clearInterval(intervalId);\n                        fullScreenLoader.stopLoader(true);\n                    }\n                }, 500);\n\n                if (braintree.checkout) {\n                    braintree.checkout.teardown(function () {\n                        braintree.checkout = null;\n                    });\n                }\n\n                fullScreenLoader.startLoader();\n                braintree.setConfig(this.clientConfig);\n                braintree.setup();\n            },\n\n            /**\n             * Get full selector name\n             *\n             * @param {String} field\n             * @returns {String}\n             */\n            getSelector: function (field) {\n                return '#' + this.getCode() + '_' + field;\n            },\n\n            /**\n             * Get list of available CC types\n             *\n             * @returns {Object}\n             */\n            getCcAvailableTypes: function () {\n                let availableTypes = validator.getAvailableCardTypes(),\n                    billingAddress = quote.billingAddress(),\n                    billingCountryId;\n\n                this.lastBillingAddress = quote.shippingAddress();\n\n                if (!billingAddress) {\n                    billingAddress = this.lastBillingAddress;\n                }\n\n                billingCountryId = billingAddress.countryId;\n\n                if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n                    return validator.collectTypes(\n                        availableTypes,\n                        validator.getCountrySpecificCardTypes(billingCountryId)\n                    );\n                }\n\n                return availableTypes;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getEnvironment: function () {\n                return window.checkoutConfig.payment[this.getCode()].environment;\n            },\n\n            /**\n             * Get data\n             *\n             * @returns {Object}\n             */\n            getData: function () {\n                let data = {\n                    'method': this.getCode(),\n                    'additional_data': {\n                        'payment_method_nonce': this.paymentMethodNonce,\n                        'g-recaptcha-response' : $('#token-grecaptcha-braintree').val()\n                    }\n                };\n\n                data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n                return data;\n            },\n\n            /**\n             * Set payment nonce\n             * @param {String} paymentMethodNonce\n             */\n            setPaymentMethodNonce: function (paymentMethodNonce) {\n                this.paymentMethodNonce = paymentMethodNonce;\n            },\n\n            /**\n             * Set credit card bin\n             * @param creditCardBin\n             */\n            setCreditCardBin: function (creditCardBin) {\n                this.creditCardBin = creditCardBin;\n            },\n\n            /**\n             * Prepare payload to place order\n             * @param {Object} payload\n             */\n            handleNonce: function (payload) {\n                let self = this;\n\n                this.setPaymentMethodNonce(payload.nonce);\n                this.setCreditCardBin(payload.details.bin);\n\n                // place order on success validation\n                self.validatorManager.validate(self, function () {\n                    return self.placeOrder('parent');\n                }, function () {\n                    self.isProcessing = false;\n                    self.paymentMethodNonce = null;\n                    self.creditCardBin = null;\n                });\n            },\n\n            /**\n             * Action to place order\n             * @param {String} key\n             */\n            placeOrder: function (key) {\n                if (key) {\n                    return this._super();\n                }\n\n                if (this.isProcessing) {\n                    return false;\n                }\n                this.isProcessing = true;\n\n\n                braintree.tokenizeHostedFields();\n                return false;\n            },\n\n            /**\n             * Get payment icons\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.braintree.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.braintree.icons[type]\n                    : false;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/view/payment/method-renderer/multishipping/paypal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\ndefine([\n    'jquery',\n    'underscore',\n    'braintreeCheckoutPayPalAdapter',\n    'Magento_Checkout/js/model/quote',\n    'PayPal_Braintree/js/view/payment/method-renderer/paypal',\n    'PayPal_Braintree/js/helper/format-amount',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Braintree,\n    quote,\n    Component,\n    formatAmount,\n    setPaymentInformationAction,\n    additionalValidators,\n    fullScreenLoader,\n    $t\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/multishipping/paypal',\n            submitButtonSelector: '[id=\"parent-payment-continue\"]',\n            reviewButtonHtml: ''\n        },\n\n        /**\n         * @override\n         */\n        initObservable: function () {\n            this.reviewButtonHtml = $(this.submitButtonSelector).html();\n            return this._super();\n        },\n\n        initClientConfig: function () {\n            this.clientConfig = _.extend(this.clientConfig, this.getPayPalConfig());\n            this.clientConfig.paypal.enableShippingAddress = false;\n\n            _.each(this.clientConfig, function (fn, name) {\n                if (typeof fn === 'function') {\n                    this.clientConfig[name] = fn.bind(this);\n                }\n            }, this);\n            this.clientConfig.buttonPayPalId = 'parent-payment-continue';\n        },\n\n        /**\n         * @override\n         */\n        onActiveChange: function (isActive) {\n            this.updateSubmitButtonHtml(isActive);\n            this._super(isActive);\n        },\n\n        /**\n         * @override\n         */\n        beforePlaceOrder: function (data) {\n            this._super(data);\n        },\n\n        /**\n         * Re-init PayPal Auth Flow\n         */\n        reInitPayPal: function () {\n            this.disableButton();\n            this.clientConfig.paypal.amount = formatAmount(this.grandTotalAmount);\n\n            if (!quote.isVirtual()) {\n                this.clientConfig.paypal.enableShippingAddress = false;\n                this.clientConfig.paypal.shippingAddressEditable = false;\n            }\n\n            Braintree.setConfig(this.clientConfig);\n\n            if (Braintree.getPayPalInstance()) {\n                Braintree.getPayPalInstance().teardown(function () {\n                    Braintree.setup();\n                });\n                Braintree.setPayPalInstance(null);\n            } else {\n                Braintree.setup();\n                this.enableButton();\n            }\n        },\n\n        loadPayPalButton: function (paypalCheckoutInstance, funding) {\n            if (funding === 'credit') {\n                Braintree.config.buttonId = this.getCreditButtonId();\n            } else if (funding === 'paylater') {\n                Braintree.config.buttonId = this.getPayLaterButtonId();\n            } else {\n                Braintree.config.buttonId = this.getPayPalButtonId();\n            }\n\n            let paypalPayment = Braintree.config.paypal,\n                onPaymentMethodReceived = Braintree.config.onPaymentMethodReceived,\n                style = {\n                    label: Braintree.getLabel(funding),\n                    color: Braintree.getColor(funding),\n                    shape: Braintree.getShape(funding)\n                },\n                payPalButtonId = Braintree.config.buttonId,\n                payPalButtonElement = $('#' + Braintree.config.buttonId),\n                events = Braintree.events,\n\n                button = window.paypal.Buttons({\n                    fundingSource: funding,\n                    env: Braintree.getEnvironment(),\n                    style: style,\n                    commit: true,\n                    locale: Braintree.config.paypal.locale,\n\n                    createOrder: function () {\n                        return paypalCheckoutInstance.createPayment(paypalPayment);\n                    },\n\n                    onCancel: function (data) {\n                        console.log('checkout.js payment cancelled', JSON.stringify(data, 0, 2));\n\n                        if (typeof events.onCancel === 'function') {\n                            events.onCancel();\n                        }\n                    },\n\n                    onError: function (err) {\n                        let error = 'PayPal Checkout could not be initialized. Please contact the store owner.';\n\n                        Braintree.showError($t(error));\n                        Braintree.config.paypalInstance = null;\n                        console.error('Paypal checkout.js error', err);\n\n                        if (typeof events.onError === 'function') {\n                            events.onError(err);\n                        }\n                    },\n\n                    onClick: function (data) {\n                    // To check term & conditions input checked - validate additional validators.\n                        if (!additionalValidators.validate()) {\n                            return false;\n                        }\n\n                        if (typeof events.onClick === 'function') {\n                            events.onClick(data);\n                        }\n                    },\n\n                    onApprove: function (data) {\n                        return paypalCheckoutInstance.tokenizePayment(data)\n                            .then(function (payload) {\n                                onPaymentMethodReceived(payload);\n                            });\n                    }\n                });\n\n            payPalButtonElement.html('');\n\n            // Render\n            Braintree.config.paypalInstance = paypalCheckoutInstance;\n\n            if (button.isEligible() && payPalButtonElement.length) {\n                button.render('#' + payPalButtonId).then(function () {\n                    Braintree.enableButton();\n                    if (typeof Braintree.config.onPaymentMethodError === 'function') {\n                        Braintree.config.onPaymentMethodError();\n                    }\n                }).then(function (data) {\n                    if (typeof events.onRender === 'function') {\n                        events.onRender(data);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Get configuration for PayPal\n         *\n         * @returns {Object}\n         */\n        getPayPalConfig: function () {\n            let totals = quote.totals(),\n                config = {};\n\n            config.paypal = {\n                flow: 'checkout',\n                amount: formatAmount(this.grandTotalAmount),\n                currency: totals['base_currency_code'],\n                locale: this.getLocale(),\n                requestBillingAgreement: true,\n\n                /**\n                 * Triggers on any Braintree error\n                 */\n                onError: function () {\n                    this.paymentMethodNonce = null;\n                },\n\n                /**\n                 * Triggers if browser doesn't support PayPal Checkout\n                 */\n                onUnsupported: function () {\n                    this.paymentMethodNonce = null;\n                }\n            };\n\n            if (!quote.isVirtual()) {\n                config.paypal.enableShippingAddress = false;\n                config.paypal.shippingAddressEditable = false;\n            }\n\n            if (this.getMerchantName()) {\n                config.paypal.displayName = this.getMerchantName();\n            }\n\n            return config;\n        },\n\n        /**\n         * Get shipping address\n         *\n         * @returns {{}}\n         */\n        getShippingAddress: function () {\n            return {};\n        },\n\n        /**\n         * @override\n         */\n        getData: function () {\n            let data = this._super();\n\n            data['additional_data']['is_active_payment_token_enabler'] = true;\n\n            return data;\n        },\n\n        /**\n         * @override\n         */\n        isActiveVault: function () {\n            return true;\n        },\n\n        /**\n         * Checks if payment method nonce is already received.\n         *\n         * @returns {Boolean}\n         */\n        isPaymentMethodNonceReceived: function () {\n            return this.paymentMethodNonce !== null;\n        },\n\n        /**\n         * Update submit button on multi-addresses checkout billing form.\n         *\n         * @param {Boolean} isActive\n         */\n        updateSubmitButtonHtml: function (isActive) {\n            $(this.submitButtonSelector).removeClass('primary');\n            if (this.isPaymentMethodNonceReceived() || !isActive) {\n                $(this.submitButtonSelector).addClass('primary');\n                $(this.submitButtonSelector).html(this.reviewButtonHtml);\n            }\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            if (!this.isPaymentMethodNonceReceived()) {\n                this.payWithPayPal();\n            } else {\n                fullScreenLoader.startLoader();\n\n                $.when(\n                    setPaymentInformationAction(\n                        this.messageContainer,\n                        this.getData()\n                    )\n                ).done(this.done.bind(this))\n                    .fail(this.fail.bind(this));\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            fullScreenLoader.stopLoader();\n            $('#multishipping-billing-form').trigger('submit');\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/view/payment/method-renderer/multishipping/hosted-fields.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\ndefine([\n    'jquery',\n    'PayPal_Braintree/js/view/payment/method-renderer/hosted-fields',\n    'PayPal_Braintree/js/validator',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'PayPal_Braintree/js/view/payment/adapter'\n], function (\n    $,\n    Component,\n    validator,\n    messageList,\n    $t,\n    fullScreenLoader,\n    setPaymentInformationAction,\n    additionalValidators,\n    braintree\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/payment/multishipping/form'\n        },\n\n        /**\n         * Get list of available CC types\n         *\n         * @returns {Object}\n         */\n        getCcAvailableTypes: function () {\n            let availableTypes = validator.getAvailableCardTypes(),\n                billingCountryId;\n\n            billingCountryId = $('#multishipping_billing_country_id').val();\n\n            if (billingCountryId && validator.getCountrySpecificCardTypes(billingCountryId)) {\n                return validator.collectTypes(\n                    availableTypes, validator.getCountrySpecificCardTypes(billingCountryId)\n                );\n            }\n\n            return availableTypes;\n        },\n\n        /**\n         * @override\n         */\n        handleNonce: function (payload) {\n            let self = this;\n\n            this.setPaymentMethodNonce(payload.nonce);\n            this.setCreditCardBin(payload.details.bin);\n\n            // place order on success validation\n            self.validatorManager.validate(self, function () {\n                return self.setPaymentInformation();\n            }, function () {\n                self.isProcessing = false;\n                self.paymentMethodNonce = null;\n                self.creditCardBin = null;\n            });\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            if (this.isProcessing) {\n                return false;\n            }\n            this.isProcessing = true;\n\n\n            braintree.tokenizeHostedFields();\n            return false;\n        },\n\n        /**\n         * @override\n         */\n        getData: function () {\n            let data = this._super();\n\n            data['additional_data']['is_active_payment_token_enabler'] = true;\n\n            return data;\n        },\n\n        /**\n         * @override\n         */\n        setPaymentInformation: function () {\n            if (additionalValidators.validate()) {\n                fullScreenLoader.startLoader();\n                $.when(\n                    setPaymentInformationAction(\n                        this.messageContainer,\n                        this.getData()\n                    )\n                ).done(this.done.bind(this))\n                    .fail(this.fail.bind(this));\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            fullScreenLoader.stopLoader();\n            $('#multishipping-billing-form').trigger('submit');\n\n            return this;\n        }\n    });\n});\n","PayPal_Braintree/js/applepay/button.js":"/**\n * Braintree Apple Pay button\n **/\ndefine(\n    [\n        'uiComponent',\n        'knockout',\n        'jquery',\n        'braintree',\n        'braintreeDataCollector',\n        'braintreeApplePay',\n        'mage/translate',\n        'Magento_Checkout/js/model/payment/additional-validators'\n    ],\n    function (\n        Component,\n        ko,\n        $,\n        braintree,\n        dataCollector,\n        applePay,\n        $t,\n        additionalValidators\n    ) {\n        'use strict';\n\n        return {\n            init: function (element, context) {\n                // No element or context\n                if (!element || !context) {\n                    return;\n                }\n\n                // Context must implement these methods\n                if (typeof context.getClientToken !== 'function') {\n                    console.error(\n                        'Braintree ApplePay Context passed does not provide a getClientToken method',\n                        context\n                    );\n                    return;\n                }\n                if (typeof context.getPaymentRequest !== 'function') {\n                    console.error(\n                        'Braintree ApplePay Context passed does not provide a getPaymentRequest method',\n                        context\n                    );\n                    return;\n                }\n                if (typeof context.startPlaceOrder !== 'function') {\n                    console.error(\n                        'Braintree ApplePay Context passed does not provide a startPlaceOrder method',\n                        context\n                    );\n                    return;\n                }\n\n                if (this.deviceSupported() === false) {\n                    return;\n                }\n\n                // init braintree api\n                braintree.create({\n                    authorization: context.getClientToken()\n                }, function (clientErr, clientInstance) {\n                    this.initApplePay(clientErr, clientInstance, element, context);\n                }.bind(this));\n            },\n\n            /**\n             * Check the site is using HTTPS & apple pay is supported on this device.\n             * @return boolean\n             */\n            deviceSupported: function () {\n                if (location.protocol !== 'https:') {\n                    console.warn('Braintree Apple Pay requires your checkout be served over HTTPS');\n                    return false;\n                }\n\n                if ((window.ApplePaySession && window.ApplePaySession.canMakePayments()) !== true) {\n                    console.warn('Braintree Apple Pay is not supported on this device/browser');\n                    return false;\n                }\n\n                return true;\n            },\n\n            initApplePay: function (clientErr, clientInstance, element, context) {\n                if (clientErr) {\n                    console.error('Error creating client:', clientErr);\n                    return;\n                }\n\n                dataCollector.create({\n                    client: clientInstance\n                }, function (dataCollectorErr, dataCollectorInstance) {\n                    if (dataCollectorErr) {\n                        return;\n                    }\n\n                    applePay.create({\n                        client: clientInstance\n                    }, function (applePayErr, applePayInstance) {\n                        this.render(applePayErr, applePayInstance, dataCollectorInstance, element, context);\n                    }.bind(this));\n                }.bind(this));\n            },\n\n            render: function (applePayErr, applePayInstance, dataCollectorInstance, element, context) {\n                // No instance\n                if (applePayErr) {\n                    console.error('Braintree ApplePay Error creating applePayInstance:', applePayErr);\n                    return;\n                }\n\n                // Create a button within the KO element, as apple pay can only be instantiated through\n                // a valid on click event (ko onclick bind interferes with this).\n                let el = document.createElement('div');\n\n                el.className = 'braintree-apple-pay-button';\n                el.title = $t('Pay with Apple Pay');\n                el.alt = $t('Pay with Apple Pay');\n                el.addEventListener('click', function (e) {\n                    e.preventDefault();\n\n                    if ($(el).parents('#braintree-applepay-express-payment').length === 0\n                        && !additionalValidators.validate()) {\n                        return false;\n                    }\n\n                    // Payment request object\n                    let paymentRequest = applePayInstance.createPaymentRequest(context.getPaymentRequest());\n\n                    if (!paymentRequest) {\n                        console.error('Braintree ApplePay Unable to create paymentRequest', paymentRequest);\n                        this.showError();\n                        return;\n                    }\n\n                    // Show the loader\n                    $('body').loader('show');\n\n                    // Init apple pay session\n                    try {\n                        let session = new window.ApplePaySession(1, paymentRequest);\n\n                        // Handle invalid merchant\n                        session.onvalidatemerchant = function (event) {\n                            applePayInstance.performValidation({\n                                validationURL: event.validationURL,\n                                displayName: context.getDisplayName()\n                            }, function (validationErr, merchantSession) {\n                                if (validationErr) {\n                                    session.abort();\n                                    console.error('Braintree ApplePay Error validating merchant:', validationErr);\n                                    this.showError();\n                                    return;\n                                }\n\n                                session.completeMerchantValidation(merchantSession);\n                            });\n                        };\n\n                        // Attach payment auth event\n                        session.onpaymentauthorized = function (event) {\n                            applePayInstance.tokenize({\n                                token: event.payment.token\n                            }, function (tokenizeErr, payload) {\n                                if (tokenizeErr) {\n                                    console.error('Error tokenizing Apple Pay:', tokenizeErr);\n                                    session.completePayment(window.ApplePaySession.STATUS_FAILURE);\n                                    return;\n                                }\n\n                                let nonce = payload.nonce;\n\n                                // Pass the nonce back to the payment method\n                                context.startPlaceOrder(nonce, event, session, dataCollectorInstance.deviceData);\n                            });\n                        };\n\n                        // Attach onShippingContactSelect method\n                        if (typeof context.onShippingContactSelect === 'function') {\n                            session.onshippingcontactselected = function (event) {\n                                return context.onShippingContactSelect(event, session);\n                            };\n                        }\n\n                        // Attach onShippingMethodSelect method\n                        if (typeof context.onShippingMethodSelect === 'function') {\n                            session.onshippingmethodselected = function (event) {\n                                return context.onShippingMethodSelect(event, session);\n                            };\n                        }\n\n                        // Hook\n                        if (typeof context.onButtonClick === 'function') {\n                            context.onButtonClick(session, this, e);\n                        } else {\n                            $('body').loader('hide');\n                            session.begin();\n                        }\n                    } catch (err) {\n                        $('body').loader('hide');\n                        console.error('Braintree ApplePay Unable to create ApplePaySession', err);\n                        this.showError();\n                        return false;\n                    }\n                }.bind(this));\n\n                element.appendChild(el);\n            },\n\n            showError() {\n                // eslint-disable-next-line\n                alert($t('We\\'re unable to take payments through Apple Pay at the moment. Please try an alternative payment method.'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/applepay/api.js":"/**\n * Braintree Apple Pay button API\n *\n **/\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'uiComponent',\n        'mage/translate',\n        'mage/storage',\n        'Magento_Customer/js/customer-data',\n        'PayPal_Braintree/js/helper/remove-non-digit-characters'\n    ],\n    function (\n        $,\n        _,\n        Component,\n        $t,\n        storage,\n        customerData,\n        removeNonDigitCharacters\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                clientToken: null,\n                quoteId: 0,\n                displayName: null,\n                actionSuccess: null,\n                grandTotalAmount: 0,\n                isLoggedIn: false,\n                storeCode: 'default',\n                shippingAddress: {},\n                countryDirectory: null,\n                shippingMethods: {}\n            },\n\n            initialize: function () {\n                this._super();\n                if (!this.countryDirectory) {\n                    storage.get('rest/V1/directory/countries').done(function (result) {\n                        this.countryDirectory = {};\n                        let i, data, x, region, name;\n\n                        for (i = 0; i < result.length; ++i) {\n                            data = result[i];\n                            this.countryDirectory[data.two_letter_abbreviation] = {};\n                            if (typeof data.available_regions === 'undefined') {\n                                continue;\n                            }\n\n                            for (x = 0; x < data.available_regions.length; ++x) {\n                                region = data.available_regions[x];\n                                name = region.name.toLowerCase().replace(/[^A-Z0-9]/ig, '');\n                                this.countryDirectory[data.two_letter_abbreviation][name] = region.id;\n                            }\n                        }\n                    }.bind(this));\n                }\n            },\n\n            /**\n             * Get region ID\n             */\n            getRegionId: function (countryCode, regionName) {\n                if (typeof regionName !== 'string') {\n                    return null;\n                }\n\n                regionName = regionName.toLowerCase().replace(/[^A-Z0-9]/ig, '');\n\n                if (typeof this.countryDirectory[countryCode] !== 'undefined'\n                    && typeof this.countryDirectory[countryCode][regionName] !== 'undefined') {\n                    return this.countryDirectory[countryCode][regionName];\n                }\n\n                return 0;\n            },\n\n            /**\n             * Set & get api token\n             */\n            setClientToken: function (value) {\n                this.clientToken = value;\n            },\n            getClientToken: function () {\n                return this.clientToken;\n            },\n\n            /**\n             * Set and get quote id\n             */\n            setQuoteId: function (value) {\n                this.quoteId = value;\n            },\n            getQuoteId: function () {\n                return this.quoteId;\n            },\n\n            /**\n             * Set and get display name\n             */\n            setDisplayName: function (value) {\n                this.displayName = value;\n            },\n            getDisplayName: function () {\n                return this.displayName;\n            },\n\n            /**\n             * Set and get success redirection url\n             */\n            setActionSuccess: function (value) {\n                this.actionSuccess = value;\n            },\n            getActionSuccess: function () {\n                return this.actionSuccess;\n            },\n\n            /**\n             * Set and get grand total\n             */\n            setGrandTotalAmount: function (value) {\n                this.grandTotalAmount = parseFloat(value).toFixed(2);\n            },\n            getGrandTotalAmount: function () {\n                return parseFloat(this.grandTotalAmount);\n            },\n\n            /**\n             * Set and get is logged in\n             */\n            setIsLoggedIn: function (value) {\n                this.isLoggedIn = value;\n            },\n            getIsLoggedIn: function () {\n                return this.isLoggedIn;\n            },\n\n            /**\n             * Set and get store code\n             */\n            setStoreCode: function (value) {\n                this.storeCode = value;\n            },\n            getStoreCode: function () {\n                return this.storeCode;\n            },\n\n            /**\n             * API Urls for logged in / guest\n             */\n            getApiUrl: function (uri) {\n                if (this.getIsLoggedIn() === true) {\n                    return 'rest/' + this.getStoreCode() + '/V1/carts/mine/' + uri;\n                }\n                return 'rest/' + this.getStoreCode() + '/V1/guest-carts/' + this.getQuoteId() + '/' + uri;\n\n            },\n\n            /**\n             * Payment request info\n             */\n            getPaymentRequest: function () {\n                return {\n                    total: {\n                        label: this.getDisplayName(),\n                        amount: this.getGrandTotalAmount()\n                    },\n                    requiredShippingContactFields: ['postalAddress', 'name', 'email', 'phone'],\n                    requiredBillingContactFields: ['postalAddress', 'name']\n                };\n            },\n\n            /**\n             * Retrieve shipping methods based on address\n             */\n            onShippingContactSelect: function (event, session) {\n                // Get the address.\n                let address = event.shippingContact,\n\n                    // Create a payload.\n                    payload = {\n                        address: {\n                            city: address.locality,\n                            region: address.administrativeArea,\n                            country_id: address.countryCode.toUpperCase(),\n                            postcode: address.postalCode,\n                            save_in_address_book: 0\n                        }\n                    };\n\n                this.shippingAddress = payload.address;\n\n                // POST to endpoint for shipping methods.\n                storage.post(\n                    this.getApiUrl('estimate-shipping-methods'),\n                    JSON.stringify(payload)\n                ).done(function (result) {\n                    // Stop if no shipping methods.\n                    let virtualFlag = false,\n                        shippingMethods = [],\n                        totalsPayload = {};\n\n                    if (result.length === 0) {\n                        let productItems = customerData.get('cart')().items;\n\n                        _.each(productItems,\n                            function (item) {\n                                if (item.is_virtual || item.product_type === 'bundle') {\n                                    virtualFlag = true;\n                                } else {\n                                    virtualFlag = false;\n                                }\n                            }\n                        );\n                        if (!virtualFlag) {\n                            session.abort();\n                            // eslint-disable-next-line\n                            alert($t('There are no shipping methods available for you right now. Please try again or use an alternative payment method.'));\n                            return false;\n                        }\n                    }\n\n                    this.shippingMethods = {};\n\n                    // Format shipping methods array.\n                    for (let i = 0; i < result.length; i++) {\n                        if (typeof result[i].method_code !== 'string') {\n                            continue;\n                        }\n\n                        let method = {\n                            identifier: result[i].method_code,\n                            label: result[i].method_title,\n                            detail: result[i].carrier_title ? result[i].carrier_title : '',\n                            amount: parseFloat(result[i].amount).toFixed(2)\n                        };\n\n                        // Add method object to array.\n                        shippingMethods.push(method);\n\n                        this.shippingMethods[result[i].method_code] = result[i];\n\n                        if (!this.shippingMethod) {\n                            this.shippingMethod = result[i].method_code;\n                        }\n                    }\n\n                    // Create payload to get totals\n                    totalsPayload = {\n                        'addressInformation': {\n                            'address': {\n                                'countryId': this.shippingAddress.country_id,\n                                'region': this.shippingAddress.region,\n                                'regionId': this.getRegionId(\n                                    this.shippingAddress.country_id, this.shippingAddress.region),\n                                'postcode': this.shippingAddress.postcode\n                            },\n                            'shipping_method_code': virtualFlag\n                                ? null : this.shippingMethods[shippingMethods[0].identifier].method_code,\n                            'shipping_carrier_code': virtualFlag\n                                ? null : this.shippingMethods[shippingMethods[0].identifier].carrier_code\n                        }\n                    };\n\n                    // POST to endpoint to get totals, using 1st shipping method\n                    storage.post(\n                        this.getApiUrl('totals-information'),\n                        JSON.stringify(totalsPayload)\n                    ).done(function (totals) {\n                        // Set total\n                        this.setGrandTotalAmount(totals.base_grand_total);\n\n                        // Pass shipping methods back\n                        session.completeShippingContactSelection(\n                            window.ApplePaySession.STATUS_SUCCESS,\n                            shippingMethods,\n                            {\n                                label: this.getDisplayName(),\n                                amount: this.getGrandTotalAmount()\n                            },\n                            [{\n                                type: 'final',\n                                label: $t('Shipping'),\n                                amount: virtualFlag ? 0 : shippingMethods[0].amount\n                            }]\n                        );\n                    }.bind(this)).fail(function (error) {\n                        session.abort();\n                        // eslint-disable-next-line\n                        alert($t('We\\'re unable to fetch the cart totals for you. Please try an alternative payment method.'));\n                        console.error('Braintree ApplePay: Unable to get totals', error);\n                        return false;\n                    });\n\n                }.bind(this)).fail(function (result) {\n                    session.abort();\n                    // eslint-disable-next-line\n                    alert($t('We\\'re unable to find any shipping methods for you. Please try an alternative payment method.'));\n                    // eslint-disable-next-line\n                    console.error('Braintree ApplePay: Unable to find shipping methods for estimate-shipping-methods', result);\n                    return false;\n                });\n            },\n\n            /**\n             * Record which shipping method has been selected & Updated totals\n             */\n            onShippingMethodSelect: function (event, session) {\n                let shippingMethod = event.shippingMethod,\n                    payload = {\n                        'addressInformation': {\n                            'address': {\n                                'countryId': this.shippingAddress.country_id,\n                                'region': this.shippingAddress.region,\n                                'regionId': this.getRegionId(this.shippingAddress.country_id,\n                                    this.shippingAddress.region),\n                                'postcode': this.shippingAddress.postcode\n                            },\n                            'shipping_method_code': this.shippingMethods[shippingMethod.identifier].method_code,\n                            'shipping_carrier_code': this.shippingMethods[shippingMethod.identifier].carrier_code\n                        }\n                    };\n\n                this.shippingMethod = shippingMethod.identifier;\n\n\n                storage.post(\n                    this.getApiUrl('totals-information'),\n                    JSON.stringify(payload)\n                ).done(function (r) {\n                    this.setGrandTotalAmount(r.base_grand_total);\n\n                    session.completeShippingMethodSelection(\n                        window.ApplePaySession.STATUS_SUCCESS,\n                        {\n                            label: this.getDisplayName(),\n                            amount: this.getGrandTotalAmount()\n                        },\n                        [{\n                            type: 'final',\n                            label: $t('Shipping'),\n                            amount: shippingMethod.amount\n                        }]\n                    );\n                }.bind(this));\n            },\n\n            /**\n             * Place the order\n             */\n            startPlaceOrder: function (nonce, event, session, device_data) {\n                let shippingContact = event.payment.shippingContact,\n                    billingContact = event.payment.billingContact,\n                    payload = {\n                        'addressInformation': {\n                            'shipping_address': {\n                                'email': shippingContact.emailAddress,\n                                'telephone': removeNonDigitCharacters(_.get(shippingContact, 'phoneNumber', '')),\n                                'firstname': shippingContact.givenName,\n                                'lastname': shippingContact.familyName,\n                                'street': shippingContact.addressLines,\n                                'city': shippingContact.locality,\n                                'region': shippingContact.administrativeArea,\n                                'region_id': this.getRegionId(\n                                    shippingContact.countryCode.toUpperCase(), shippingContact.administrativeArea),\n                                'region_code': null,\n                                'country_id': shippingContact.countryCode.toUpperCase(),\n                                'postcode': shippingContact.postalCode,\n                                'same_as_billing': 0,\n                                'customer_address_id': 0,\n                                'save_in_address_book': 0\n                            },\n                            'billing_address': {\n                                'email': shippingContact.emailAddress,\n                                'telephone': removeNonDigitCharacters(_.get(shippingContact, 'phoneNumber', '')),\n                                'firstname': billingContact.givenName,\n                                'lastname': billingContact.familyName,\n                                'street': billingContact.addressLines,\n                                'city': billingContact.locality,\n                                'region': billingContact.administrativeArea,\n                                'region_id': this.getRegionId(\n                                    billingContact.countryCode.toUpperCase(), billingContact.administrativeArea),\n                                'region_code': null,\n                                'country_id': billingContact.countryCode.toUpperCase(),\n                                'postcode': billingContact.postalCode,\n                                'same_as_billing': 0,\n                                'customer_address_id': 0,\n                                'save_in_address_book': 0\n                            },\n                            'shipping_method_code': this.shippingMethod\n                                ? this.shippingMethods[this.shippingMethod].method_code : '' ,\n                            'shipping_carrier_code': this.shippingMethod\n                                ? this.shippingMethods[this.shippingMethod].carrier_code : ''\n                        }\n                    };\n\n                // Set addresses\n                storage.post(\n                    this.getApiUrl('shipping-information'),\n                    JSON.stringify(payload)\n                ).done(function () {\n                    // Submit payment information\n                    let paymentInformation = {\n                        'email': shippingContact.emailAddress,\n                        'paymentMethod': {\n                            'method': 'braintree_applepay',\n                            'additional_data': {\n                                'payment_method_nonce': nonce,\n                                'device_data': device_data\n                            }\n                        }\n                    };\n\n                    if (window.checkout && window.checkout.agreementIds) {\n                        paymentInformation.paymentMethod.extension_attributes = {\n                            'agreement_ids': window.checkout.agreementIds\n                        };\n                    }\n                    storage.post(\n                        this.getApiUrl('payment-information'),\n                        JSON.stringify(paymentInformation)\n                    ).done(function () {\n                        document.location = this.getActionSuccess();\n                        session.completePayment(window.ApplePaySession.STATUS_SUCCESS);\n                    }.bind(this)).fail(function (r) {\n                        session.completePayment(window.ApplePaySession.STATUS_FAILURE);\n                        session.abort();\n                        // eslint-disable-next-line\n                        alert($t('We\\'re unable to take your payment through Apple Pay. Please try an again or use an alternative payment method.'));\n                        console.error('Braintree ApplePay Unable to take payment', r);\n                        return false;\n                    });\n\n                }.bind(this)).fail(function (r) {\n                    console.error('Braintree ApplePay Unable to set shipping information', r);\n                    session.completePayment(window.ApplePaySession.STATUS_INVALID_BILLING_POSTAL_ADDRESS);\n                });\n            }\n        });\n    });\n","PayPal_Braintree/js/applepay/implementations/shortcut.js":"/**\n * Braintree Apple Pay mini cart payment method integration.\n **/\ndefine(\n    [\n        'uiComponent',\n        'PayPal_Braintree/js/applepay/button',\n        'PayPal_Braintree/js/applepay/api',\n        'mage/translate',\n        'domReady!'\n    ],\n    function (\n        Component,\n        button,\n        buttonApi,\n        $t\n    ) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                id: null,\n                clientToken: null,\n                quoteId: 0,\n                displayName: null,\n                actionSuccess: null,\n                grandTotalAmount: 0,\n                isLoggedIn: false,\n                storeCode: 'default'\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initialize: function () {\n                this._super();\n                if (!this.displayName) {\n                    this.displayName = $t('Store');\n                }\n\n                let api = new buttonApi();\n\n                api.setGrandTotalAmount(parseFloat(this.grandTotalAmount).toFixed(2));\n                api.setClientToken(this.clientToken);\n                api.setDisplayName(this.displayName);\n                api.setQuoteId(this.quoteId);\n                api.setActionSuccess(this.actionSuccess);\n                api.setIsLoggedIn(this.isLoggedIn);\n                api.setStoreCode(this.storeCode);\n\n                // Attach the button\n                button.init(\n                    document.getElementById(this.id),\n                    api\n                );\n\n                return this;\n            }\n        });\n    }\n);\n","PayPal_Braintree/js/applepay/implementations/core-checkout/method-applepay.js":"define([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    let config = window.checkoutConfig.payment;\n\n    if (config['braintree_applepay'].clientToken) {\n        rendererList.push({\n            type: 'braintree_applepay',\n            component: 'PayPal_Braintree/js/applepay/implementations/core-checkout/method-renderer/applepay'\n        });\n    }\n\n    return Component.extend({});\n});\n","PayPal_Braintree/js/applepay/implementations/core-checkout/method-renderer/applepay.js":"/**\n * Braintree Apple Pay payment method integration.\n **/\ndefine([\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'PayPal_Braintree/js/applepay/button'\n], function (\n    _,\n    Component,\n    quote,\n    VaultEnabler,\n    button\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'PayPal_Braintree/applepay/core-checkout',\n            paymentMethodNonce: null,\n            deviceData: null,\n            grandTotalAmount: 0,\n            deviceSupported: button.deviceSupported(),\n            vaultEnabler: null,\n            additionalData: {}\n        },\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * Inject the apple pay button into the target element\n         */\n        getApplePayBtn: function (id) {\n            button.init(\n                document.getElementById(id),\n                this\n            );\n        },\n\n        /**\n         * Subscribe to grand totals\n         */\n        initObservable: function () {\n            this._super();\n\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n\n            quote.totals.subscribe(function () {\n                if (this.grandTotalAmount !== quote.totals()['base_grand_total']) {\n                    this.grandTotalAmount = parseFloat(quote.totals()['base_grand_total']).toFixed(2);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Apple pay place order method\n         */\n        startPlaceOrder: function (nonce, event, session, device_data) {\n            this.setPaymentMethodNonce(nonce);\n            this.setDeviceData(device_data);\n            this.placeOrder();\n\n            session.completePayment(window.ApplePaySession.STATUS_SUCCESS);\n        },\n\n        /**\n         * Save nonce\n         */\n        setPaymentMethodNonce: function (nonce) {\n            this.paymentMethodNonce = nonce;\n        },\n\n        /**\n         * Save nonce\n         */\n        setDeviceData: function (device_data) {\n            this.deviceData = device_data;\n        },\n\n        /**\n         * Retrieve the client token\n         * @returns null|string\n         */\n        getClientToken: function () {\n            return window.checkoutConfig.payment[this.getCode()].clientToken;\n        },\n\n        /**\n         * Payment request data\n         */\n        getPaymentRequest: function () {\n            return {\n                total: {\n                    label: this.getDisplayName(),\n                    amount: this.grandTotalAmount\n                }\n            };\n        },\n\n        /**\n         * Merchant display name\n         */\n        getDisplayName: function () {\n            return window.checkoutConfig.payment[this.getCode()].merchantName;\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'payment_method_nonce': this.paymentMethodNonce,\n                    'device_data': this.deviceData\n                }\n            };\n\n            data['additional_data'] = _.extend(data['additional_data'], this.additionalData);\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * Return image url for the apple pay mark\n         */\n        getPaymentMarkSrc: function () {\n            return window.checkoutConfig.payment[this.getCode()].paymentMarkSrc;\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return window.checkoutConfig.payment[this.getCode()].vaultCode;\n        }\n    });\n});\n","PayPal_Braintree/js/helper/get-braintree-config.js":"define(['jquery'], function ($) {\n    'use strict';\n\n    return function () {\n        return $.ajax({\n            method: 'POST',\n            url: '/graphql',\n            contentType: 'application/json',\n            data: JSON.stringify({\n                query: `{\n                    storeConfig {\n                        braintree_merchant_account_id,\n                        braintree_3dsecure_verify_3dsecure,\n                        braintree_3dsecure_always_request_3ds,\n                        braintree_3dsecure_threshold_amount,\n                        braintree_3dsecure_allowspecific,\n                        braintree_3dsecure_specificcountry\n                    }\n                  }`\n            })\n        });\n    };\n});\n","PayPal_Braintree/js/helper/remove-non-digit-characters.js":"define([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /**\n     * Remove any non-digit characters from string.\n     *\n     * @param {string} value\n     * @return {string}\n     */\n    return function (value) {\n        return _.isString(value) ? value.replace(/\\D/g, '') : '';\n    };\n});\n","PayPal_Braintree/js/helper/get-cart-line-items-helper.js":"define([\n    'jquery',\n    'underscore',\n    'PayPal_Braintree/js/helper/format-amount',\n    'PayPal_Braintree/js/helper/replace-unsupported-characters',\n    'Magento_Checkout/js/model/quote'\n], function (\n    $,\n    _,\n    formatAmount,\n    replaceUnsupportedCharacters,\n    quote\n) {\n    'use strict';\n\n    /**\n     * Get line items\n     *\n     * @returns {Array}\n     */\n    return function () {\n        let lineItems = [];\n\n        /**\n         * Line items array\n         *\n         * {Array}\n         */\n        var lineItemsArray = [\n            'name',\n            'kind',\n            'quantity',\n            'unitAmount',\n            'productCode',\n            'description'\n        ];\n\n        if (window.checkoutConfig.payment['braintree_paypal'].canSendLineItems) {\n            let giftWrappingItems = 0, giftWrappingOrder = 0, storeCredit = 0, giftCardAccount = 0,\n                giftWrappingPrintedCard = 0,\n                baseDiscountAmount = formatAmount(Math.abs(quote.totals()['base_discount_amount']).toString()),\n                baseTaxAmount = formatAmount(quote.totals()['base_tax_amount']);\n\n            $.each(quote.totals()['total_segments'], function (segmentsKey, segmentsItem) {\n                if (segmentsItem['code'] === 'customerbalance') {\n                    storeCredit = formatAmount(Math.abs(segmentsItem['value']).toString());\n                }\n                if (segmentsItem['code'] === 'giftcardaccount') {\n                    giftCardAccount = formatAmount(Math.abs(segmentsItem['value']).toString());\n                }\n                if (segmentsItem['code'] === 'giftwrapping') {\n                    let extensionAttributes = segmentsItem['extension_attributes'];\n\n                    giftWrappingOrder = extensionAttributes['gw_base_price'];\n                    giftWrappingItems = extensionAttributes['gw_items_base_price'];\n                    giftWrappingPrintedCard = extensionAttributes['gw_card_base_price'];\n                }\n            });\n\n            $.each(quote.getItems(), function (quoteItemKey, quoteItem) {\n                if (quoteItem.parent_item_id !== null || quoteItem.price === 0.0) {\n                    return true;\n                }\n\n                let floatQty = parseFloat(quoteItem.qty),\n                    itemName = replaceUnsupportedCharacters(quoteItem.name),\n                    itemSku = replaceUnsupportedCharacters(quoteItem.sku),\n                    hasQty = floatQty > Math.floor(floatQty) && floatQty < Math.ceil(floatQty),\n                    description = hasQty\n                        ? 'Item quantity is ' + floatQty.toFixed(2) + ' and per unit amount is '\n                            + parseFloat(quoteItem.price).toFixed(2)\n                        : '',\n                    itemUnitAmount = hasQty\n                        ? parseFloat(floatQty * parseFloat(quoteItem.price)) : parseFloat(quoteItem.price),\n                    itemQty = hasQty ? parseFloat('1') : floatQty,\n                    lineItemValues = [\n                        itemName,\n                        'debit',\n                        itemQty.toFixed(2),\n                        itemUnitAmount.toFixed(2),\n                        itemSku,\n                        description\n                    ],\n\n                    mappedLineItems = $.map(lineItemsArray, function (itemElement, itemIndex) {\n                        return [[\n                            lineItemsArray[itemIndex],\n                            lineItemValues[itemIndex]\n                        ]];\n                    });\n\n                lineItems[quoteItemKey] = Object.fromEntries(mappedLineItems);\n            });\n\n            /**\n             * Adds credit (refund or discount) kind as LineItems for the\n             * PayPal transaction if discount amount is greater than 0(Zero)\n             * as discountAmount lineItem field is not being used by PayPal.\n             *\n             * developer.paypal.com/braintree/docs/reference/response/transaction-line-item/php#discount_amount\n             */\n            if (baseDiscountAmount > 0) {\n                let discountLineItem = {\n                    'name': 'Discount',\n                    'kind': 'credit',\n                    'quantity': 1.00,\n                    'unitAmount': baseDiscountAmount\n                };\n\n                lineItems = $.merge(lineItems, [discountLineItem]);\n            }\n\n            /**\n             * Adds shipping as LineItems for the PayPal transaction\n             * if shipping amount is greater than 0(Zero) to manage\n             * the totals with client-side implementation as there is\n             * no any field exist in the client-side implementation\n             * to send the shipping amount to the Braintree.\n             */\n            if (quote.totals()['base_shipping_amount'] > 0) {\n                let shippingLineItem = {\n                    'name': 'Shipping',\n                    'kind': 'debit',\n                    'quantity': 1.00,\n                    'unitAmount': quote.totals()['base_shipping_amount']\n                };\n\n                lineItems = $.merge(lineItems, [shippingLineItem]);\n            }\n\n            if (baseTaxAmount > 0) {\n                let taxLineItem = {\n                    'name': 'Tax',\n                    'kind': 'debit',\n                    'quantity': 1.00,\n                    'unitAmount': baseTaxAmount\n                };\n\n                lineItems = $.merge(lineItems, [taxLineItem]);\n            }\n\n            /**\n             * Adds credit (Store Credit) kind as LineItems for the\n             * PayPal transaction if store credit is greater than 0(Zero)\n             * to manage the totals with client-side implementation\n             */\n            if (storeCredit > 0) {\n                let storeCreditItem = {\n                    'name': 'Store Credit',\n                    'kind': 'credit',\n                    'quantity': 1.00,\n                    'unitAmount': storeCredit\n                };\n\n                lineItems = $.merge(lineItems, [storeCreditItem]);\n            }\n\n            /**\n             * Adds Gift Wrapping for items as LineItems for the PayPal\n             * transaction if it is greater than 0(Zero) to manage\n             * the totals with client-side implementation\n             */\n            if (giftWrappingItems > 0) {\n                let gwItems = {\n                    'name': 'Gift Wrapping for Items',\n                    'kind': 'debit',\n                    'quantity': 1.00,\n                    'unitAmount': giftWrappingItems\n                };\n\n                lineItems = $.merge(lineItems, [gwItems]);\n            }\n\n            /**\n             * Adds Gift Wrapping for order as LineItems for the PayPal\n             * transaction if it is greater than 0(Zero) to manage\n             * the totals with client-side implementation\n             */\n            if (giftWrappingOrder > 0) {\n                let gwOrderItem = {\n                    'name': 'Gift Wrapping for Order',\n                    'kind': 'debit',\n                    'quantity': 1.00,\n                    'unitAmount': giftWrappingOrder\n                };\n\n                lineItems = $.merge(lineItems, [gwOrderItem]);\n            }\n\n            /**\n             * Adds Gift Wrapping Printed Card as LineItems for the PayPal\n             * transaction if it is greater than 0(Zero) to manage\n             * the totals with client-side implementation\n             */\n            if (giftWrappingPrintedCard > 0) {\n                let gwPrintedCard = {\n                    'name': 'Printed Card',\n                    'kind': 'debit',\n                    'quantity': 1.00,\n                    'unitAmount': giftWrappingPrintedCard\n                };\n\n                lineItems = $.merge(lineItems, [gwPrintedCard]);\n            }\n\n            /**\n             * Adds Gift Cards as credit LineItems for the PayPal\n             * transaction if it is greater than 0(Zero) to manage\n             * the totals with client-side implementation\n             */\n            if (giftCardAccount > 0) {\n                let giftCardItem = {\n                    'name': 'Gift Cards',\n                    'kind': 'credit',\n                    'quantity': 1.00,\n                    'unitAmount': giftCardAccount\n                };\n\n                lineItems = $.merge(lineItems, [giftCardItem]);\n            }\n\n            if (lineItems.length >= 250) {\n                lineItems = [];\n            }\n        }\n        return lineItems;\n    };\n});\n","PayPal_Braintree/js/helper/create-client-token.js":"define(['jquery'], function ($) {\n    'use strict';\n\n    return function () {\n        return $.ajax({\n            method: 'POST',\n            url: '/graphql',\n            contentType: 'application/json',\n            data: JSON.stringify({\n                query: `\n                    mutation {\n                      createBraintreeClientToken\n                    }`\n            })\n        });\n    };\n});\n","PayPal_Braintree/js/helper/format-amount.js":"define(function () {\n    'use strict';\n\n    /**\n     * Format amount (string) to two decimals.\n     *\n     * @param {string} str\n     * @return {string}\n     */\n    return function (amount) {\n        return parseFloat(amount).toFixed(2);\n    };\n});\n","PayPal_Braintree/js/helper/replace-single-quote-character.js":"define([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /**\n     * Replace single quote character to HTML entity string.\n     *\n     * @param {string} value\n     * @return {string}\n     */\n    return function (value) {\n        return _.isString(value) ? value.replace(/'/g, '&apos;') : '';\n    };\n});\n","PayPal_Braintree/js/helper/replace-unsupported-characters.js":"define(function () {\n    'use strict';\n\n    /**\n     * Regex to replace all unsupported characters from string.\n     *\n     * @param {String} str\n     * @return {String}\n     */\n    return function (str) {\n        // eslint-disable-next-line no-useless-escape\n        return str.replace('/[^a-zA-Z0-9\\s\\-.\\']/', '').substring(0, 127);\n    };\n});\n","PayPal_Braintree/js/customer/utilities.js":"/* eslint-disable max-depth */\ndefine([\n    'jquery',\n    'ko',\n    'mage/url',\n    'mage/translate',\n    'mage/calendar'\n], function ($, ko, urlBuilder) {\n    'use strict';\n    return {\n\n        viewModel: {\n            activeVM: ko.observableArray(null),\n            pausedVM: ko.observableArray(null),\n            pendingVM: ko.observableArray(null),\n\n            updatedOrderEntityId: ko.observable(null),\n            showBanner: ko.observable(false),\n            errorModal: {\n                visible: ko.observable(false),\n                message: ko.observable(null)\n            }\n        },\n        sectionCounter: 0,\n\n        makeCall: function (url, verb, callback, viewModel) {\n            var self = this;\n\n            $.ajax({\n                url: urlBuilder.build(url),\n                contentType: 'application/json',\n                global: true,\n                type: verb,\n                showLoader: true,\n                cache: false,\n                success: function (response) {\n                    callback(response);\n                    self.handleSuccess(self.viewModel.updatedOrderEntityId());\n                },\n                error: function (xhr, status, error) {\n                    $('body').trigger('processStop');\n                    if (viewModel) {\n                        self.hideModal(viewModel);\n                    }\n\n                    self.handleError(xhr, status, error);\n                }\n            });\n        },\n\n        //Get entity ID from response json back from update\n        //After section updates, run this to find the updatedOrderEntityId value and add the class\n        //Find a div with that ID and add a class to it\n        handleSuccess: function (entity_id) {\n            var self = this,\n                successClass = 'updated-success',\n                orderItem = $('.repeat-order-id-' + entity_id),\n                parentContainer = orderItem.closest('.repeat-order');\n\n            // If there is another success message on an item then reset\n            if ($('.updated-success').length) {\n                $(this).removeClass(successClass);\n            }\n\n            orderItem.addClass(successClass);\n            parentContainer.addClass(successClass);\n\n            //Remove the class\n            //Set the entityid value back to null, so the success message is only shown once\n            setTimeout(function () {\n                orderItem.removeClass(successClass);\n                parentContainer.removeClass(successClass);\n                self.viewModel.updatedOrderEntityId(null);\n            }, 20000);\n        },\n\n        hideModal: function (viewModel) {\n            return viewModel.visible(false);\n        },\n\n        //Get a message relating to a particular response and show it on the page in a modal\n        handleError: function (xhr) {\n            this.viewModel.errorModal.message(JSON.parse(xhr.responseText).message);\n            this.viewModel.errorModal.visible(true);\n        },\n\n        formatDate: function (value, format) {\n            if (!format || typeof format == 'undefined') {\n                format = 'MM dd, yy';\n            }\n\n            return $.datepicker.formatDate(format, new Date(value));\n        },\n\n        formatCurrency: function (value) {\n            //If the price is a negative number, make it a positive number. eg -1.25 becomes 1.25\n            var formattedValue = Math.abs(value);\n\n            //Set number to 2 decimal places as it is a price\n            formattedValue = formattedValue.toFixed(2);\n\n            return formattedValue;\n        },\n\n        formatWeeks: function (value) {\n            var dayValue = value / 7;\n\n            return dayValue === 1 ? $.mage.__('Week') : dayValue + ' ' + $.mage.__('Weeks');\n        },\n\n        //Used for payment details as they are formatted as a string of json:\n        //eg '{\"type\":\"VI\",\"maskedCC\":\"1111\",\"expirationDate\":\"11\\/2022\"}'\n        parseStringtoJSON: function (string) {\n            var result = JSON.parse(string);\n\n            return result;\n        },\n\n        //Find the image url in the product.media_gallery_entries array\n        getImgUrl: function (data) {\n            var imgUrl,\n                i = 0,\n                j = 0,\n                dataLength = data.length;\n\n            for (i = 0; i < dataLength; i++) {\n\n                for (j = 0; j < data[i].types.length; j++) {\n                    if (data[i].types[j] === 'thumbnail') {\n                        imgUrl = data[i].file;\n\n                        break;\n                    }\n                }\n            }\n\n            return '/media/catalog/product' + imgUrl;\n        },\n\n        //Find the image label to be used as an alt tag in the product.media_gallery_entries array\n        getImgAltTag: function (data) {\n            var altTag,\n                i = 0,\n                j = 0,\n                dataLength = data.length;\n\n            for (i = 0; i < dataLength; i++) {\n\n                for (j = 0; j < data[i].types.length; j++) {\n                    altTag = this.updateAltTag(data[i].types[j]);\n\n                    if (data[i].types[j] === 'thumbnail') {\n\n                        if (data[i].label === null || data[i].label === '') {\n                            altTag = ' ';\n                        }\n                        else {\n                            altTag = data[i].label;\n                        }\n\n                        break;\n                    }\n                }\n            }\n\n            return altTag;\n        }\n    };\n});\n","PayPal_Braintree/js/customer/payment/address-form-initializer.js":"define([\n    'jquery',\n    'uiComponent',\n    'ko',\n    'PayPal_Braintree/js/customer/modals/address-modal',\n    'mageUtils',\n    'Magento_Checkout/js/model/payment/additional-validators'\n], function (\n    $,\n    Component,\n    ko,\n    addressModal,\n    utils,\n    additionalValidators\n) {\n    'use strict';\n    return Component.extend({\n\n        defaults: {\n            template: 'Paypal_Braintree/customer/payment/address-wrapper',\n            addressModal: addressModal,\n            deliveryIntervals: ko.observableArray(null),\n            currentlySelectedInterval: ko.observable(null),\n            minDatePickerValue: 1,\n            standardDeliveryDays: 1,\n            baseUrl: ko.observable(),\n            updatedOrderEntityId: null,\n            countryId: 'GB',\n            submitBtnSelector: '#braintree_submit',\n            phoneNumberMaxLength: ko.observable(11),\n            phoneNumberMinLength: ko.observable(2),\n            phoneNumberMaxLengthErrorVisible: ko.observable(false),\n            phoneNumberMinLengthErrorVisible: ko.observable(false)\n        },\n\n        initialize: function () {\n            this._super();\n            let self = this;\n\n            additionalValidators.registerValidator({\n                validate: function () {\n                    const $form = $('#form-validate');\n\n                    $form.validation();\n                    return $form.validation('isValid');\n                }\n            });\n\n            fetch('/graphql', {\n                method: 'POST',\n                headers: {\n                    'Content-Type': 'application/json'\n                },\n                body: JSON.stringify({\n                    query: `{\n                        countries {\n                            full_name_locale,\n                            two_letter_abbreviation\n                        }\n                    }`\n                })\n            }).then(response => response.json()).then(response => {\n                const countries = response.data.countries || [];\n\n                countries.forEach(country => {\n                    self.addressModal.viewModel.countries.push({\n                        countryCode: country.two_letter_abbreviation,\n                        countryName: country.full_name_locale\n                    });\n                });\n            });\n        },\n\n        toggleSubmit: function (disable) {\n            var submitBtn = $(this.submitBtnSelector);\n\n            if (submitBtn.length) {\n                submitBtn.attr('disabled', disable);\n            }\n        },\n\n        showAddressModal: function (entity_id, groupedOrdersLength, shippingId, countryId) {\n            this.addressModal.viewModel.selectExistingVisible(true);\n            this.addressModal.viewModel.currentCountryId(this.countryId);\n            this.addressModal.showAddressModal(entity_id, groupedOrdersLength, shippingId, countryId);\n            let addressLength = this.addressModal.viewModel.currentAddresses().length;\n\n            this.addressModal.viewModel.newAddressFormVisible(addressLength === 0);\n            this.showLookupForm();\n            this.toggleSubmit(true);\n        },\n\n        showNewAddressForm: function () {\n            this.addressModal.toggleNewAddAddressForm(true);\n            if (this.addressModal.toggleNewAddAddressForm) {\n                document.getElementById('form-validate').style.display = 'block';\n            }\n            this.addressModal.viewModel.isLookup(false);\n\n            this.toggleSubmit(false);\n        },\n\n        showLookupForm: function () {\n            this.addressModal.toggleNewAddAddressForm(true);\n        },\n\n        showExistingSelector: function () {\n            this.addressModal.toggleNewAddAddressForm(false);\n            if (this.addressModal.toggleNewAddAddressForm) {\n                document.getElementById('form-validate').style.display = 'none';\n            }\n\n            this.toggleSubmit(false);\n        },\n\n        /**\n         * @param {*} postCode\n         * @param {*} countryId\n         * @param {Array} postCodesPatterns\n         * @return {Boolean}\n         */\n        validatePostCode: function (postCode, countryId) {\n            var pattern, regex,\n                patterns = window.checkout.postCodes[countryId];\n\n            this.validatedPostCodeExample = [];\n\n            if (!utils.isEmpty(postCode) && !utils.isEmpty(patterns)) {\n                for (pattern in patterns) {\n                    if (patterns.hasOwnProperty(pattern)) { //eslint-disable-line max-depth\n                        this.validatedPostCodeExample.push(patterns[pattern].example);\n                        regex = new RegExp(patterns[pattern].pattern);\n\n                        if (regex.test(postCode)) { //eslint-disable-line max-depth\n                            return true;\n                        }\n                    }\n                }\n\n                return false;\n            }\n\n            return true;\n        },\n\n        postcodeValidation: function (postcodeElement) {\n            var countryId = this.countryId,\n                validationResult,\n                warnMessage,\n                warnElement = $('.warning-postcode');\n\n            if (postcodeElement == null || postcodeElement.val() == null) {\n                return true;\n            }\n\n            warnElement.hide();\n            warnElement.text('');\n\n            validationResult = this.validatePostCode(postcodeElement.val(), countryId, []);\n\n            if (!validationResult) {\n                warnMessage = 'Please enter a valid post code.';\n\n                warnElement.show();\n                warnElement.text(warnMessage);\n\n                if (warnMessage) {\n                    warnElement.prev().addClass('input-postcode-error');\n                }\n            } else {\n                warnElement.prev().removeClass('input-postcode-error');\n            }\n\n            return validationResult;\n        }\n    });\n});\n","PayPal_Braintree/js/customer/payment/braintree-card.js":"define([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'mage/translate',\n    'uiRegistry',\n    'braintreeThreeDSecure',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'PayPal_Braintree/js/helper/get-braintree-config',\n    'PayPal_Braintree/js/view/payment/adapter'\n], function (Component, $, ko, _,  $t, uiRegistry, threeDSecure, additionalValidators, getBraintreeConfig, braintree) {\n    'use strict';\n\n    /**\n     * braintree is not an instance of Component so we need to merge in our changes\n     * and return an instance of Component with the final merged object.\n     */\n    var uiC = _.extend(braintree, {\n        clientToken: null,\n        uiConfig: null,\n        paymentMethodNonce: null,\n        selectedCardType: null,\n\n        isValidCardNumber: false,\n        isValidExpirationDate: false,\n        isValidCvvNumber: false,\n\n        viewModel: {\n            paymentMethodNonce: ko.observable(null),\n            publicHash: ko.observable(null),\n            paymentMethodCode: 'braintree',\n            total: ko.observable(0),\n            isThreeDSecureEnabled: ko.observable(false),\n            selectedMethod: {\n                price: ko.observable(0)\n            },\n            errorMessage: ko.observable()\n        },\n\n        /**\n         * Additional payment data\n         *\n         * {Object}\n         */\n        additionalData: {},\n\n        /**\n         * @inheritDoc\n         */\n        initialize: async function (uiConfig) {\n            this._super().observe([\n                'selectedCardType'\n            ]);\n\n            await this.getBraintreeConfig();\n\n            this.uiConfig = uiConfig;\n            this.icons = uiConfig.icons;\n            this.cvvImage = uiConfig.cvvImage;\n            this.viewModel.isThreeDSecureEnabled(uiConfig.isThreeDSecureEnabled);\n            this.viewModel.total(parseFloat(uiConfig.amount).toFixed(2));\n\n            let self = this;\n\n            const elm = await this._waitForElm('#co-transparent-form-braintree');\n\n            if (elm) {\n                this.clientConfig = {\n                    additionalData: {},\n\n                    /**\n                     * Device data initialization\n                     * @param {String} deviceData\n                     */\n                    onDeviceDataReceived: function (deviceData) {\n                        this.additionalData['device_data'] = deviceData;\n                    },\n\n                    /**\n                     * Triggers on any Braintree error\n                     * @param {Object} response\n                     */\n                    onError: function (response) {\n                        self.showError($t('Please enter a valid card number, expiry date and CVV Number.'));\n                        throw response.message;\n                    },\n\n                    /**\n                     * Triggers when customer click \"Cancel\"\n                     */\n                    onCancelled: function () {\n                        self.showError($t('The process has been cancelled'));\n                    },\n\n                    onReady: function (context) {\n                        context.setupHostedFields();\n                    },\n\n                    /**\n                     * Allow a new nonce to be generated\n                     */\n                    onPaymentMethodError: function () {\n                        this.isProcessing = false;\n                    },\n\n                    /**\n                     * Set payment nonce\n                     * @param {String} paymentMethodNonce\n                     */\n                    setPaymentMethodNonce: function (paymentMethodNonce) {\n                        this.paymentMethodNonce = paymentMethodNonce;\n                    },\n\n\n                    /**\n                     * After Braintree instance initialization\n                     */\n                    onInstanceReady: function (instance) {\n                        instance.on('validityChange', self.onValidityChange.bind(self));\n                        instance.on('cardTypeChange', self.onCardTypeChange.bind(self));\n                    },\n\n                    id: 'co-transparent-form-braintree',\n\n                    hostedFields: {\n                        number: {\n                            selector: '#braintree_cc_number',\n                            placeholder: '4111 1111 1111 1111'\n                        },\n                        expirationDate: {\n                            selector: '#braintree_expirationDate',\n                            placeholder: $t('MM/YYYY')\n                        },\n                        cvv: {\n                            selector: '#braintree_cc_cid',\n                            placeholder: $t('000')\n                        }\n                    },\n\n                    styles: {\n                        'input': {\n                            'font-size': '14px',\n                            'color': '#3A3A3A'\n                        },\n                        ':focus': {\n                            'color': 'black'\n                        },\n                        '.valid': {\n                            'color': 'green'\n                        },\n                        '.invalid': {\n                            'color': 'red'\n                        }\n                    },\n\n                    onPaymentMethodReceived: function (response) {\n                        $.ajax({\n                            url: '/rest/default/V1/braintree/mine/payment/vault',\n                            type: 'POST',\n                            data: JSON.stringify({\n                                billingAddress: {},\n                                payment: {\n                                    payment_method_code: self.viewModel.paymentMethodCode,\n                                    payment_method_nonce: response.nonce,\n                                    device_data: this.additionalData.device_data\n                                }\n                            }),\n                            contentType:'application/json; charset=utf-8',\n                            success: function () {\n                                window.location.reload();\n                            },\n                            error: function (error) {\n                                $('body').trigger('processStop');\n                                console.warn(error.message);\n                            }\n                        });\n                    }\n                };\n\n                this.setConfig(this.clientConfig);\n                this.clientToken = uiConfig.clientToken;\n                this.setup();\n            }\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.uiConfig.ccTypeMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        getBraintreeConfig: function () {\n            return getBraintreeConfig()\n                .then(response => {\n                    this.merchantAccountId = response.data.storeConfig.braintree_merchant_account_id;\n                });\n        },\n\n        /**\n         * Triggers on Hosted Field changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onValidityChange: function (event) {\n            // Handle a change in validation or card type\n            if (event.emittedBy === 'number') {\n                this.selectedCardType(null);\n\n                if (event.cards.length === 1) {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.selectedCardType(\n                        this.getMageCardType(event.cards[0].type, this.uiConfig.availableCardTypes));\n                    this.validateCardType();\n                } else {\n                    this.isValidCardNumber = event.fields.number.isValid;\n                    this.validateCardType();\n                }\n            }\n\n            // Other field validations\n            if (event.emittedBy === 'expirationDate') {\n                this.isValidExpirationDate = event.fields.expirationDate.isValid;\n            }\n            if (event.emittedBy === 'cvv') {\n                this.isValidCvvNumber = event.fields.cvv.isValid;\n            }\n        },\n\n        /**\n         * Triggers on Hosted Field card type changes\n         * @param {Object} event\n         * @returns {Boolean}\n         */\n        onCardTypeChange: function (event) {\n            if (event.cards.length === 1) {\n                this.selectedCardType(\n                    this.getMageCardType(event.cards[0].type, this.uiConfig.availableCardTypes)\n                );\n            } else {\n                this.selectedCardType(null);\n            }\n        },\n\n        _waitForElm: function (selector) {\n            return new Promise(resolve => {\n                if (document.querySelector(selector)) {\n                    return resolve(document.querySelector(selector));\n                }\n\n                const observer = new MutationObserver(() => {\n                    if (document.querySelector(selector)) {\n                        resolve(document.querySelector(selector));\n                        observer.disconnect();\n                    }\n                });\n\n                observer.observe(document.body, {\n                    childList: true,\n                    subtree: true\n                });\n            });\n        },\n\n        /**\n         * @inheritDoc\n         */\n        getClientToken: function () {\n            return this.clientToken;\n        },\n\n        /**\n         * Trigger order placing\n         */\n        placeOrderClick: function () {\n            if (this.validateFormFields() && additionalValidators.validate()) {\n                this.handleNonce();\n            }\n        },\n\n        /**\n         * Get jQuery selector\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        /**\n         * Get card icons\n         *\n         * @param {String} type\n         * @returns {Object|Boolean}\n         */\n        getIcons: function (findType) {\n            return this.icons.find(({ type }) => type === findType);\n        },\n\n        /**\n         * Toggle invalid class on selector\n         * @param selector\n         * @param state\n         * @returns {boolean}\n         */\n        validateField: function (selector, state) {\n            var $selector = $(this.getSelector(selector)),\n                invalidClass = 'braintree-hosted-fields-invalid';\n\n            if (state === true) {\n                $selector.removeClass(invalidClass);\n                return true;\n            }\n\n            $selector.addClass(invalidClass);\n            return false;\n        },\n\n        /**\n         * Validate all fields\n         * @returns {boolean}\n         */\n        validateFormFields: function () {\n            return (this.validateCardType() && this.validateExpirationDate() && this.validateCvvNumber()) === true;\n        },\n\n        /**\n         * Validate current credit card type\n         * @returns {Boolean}\n         */\n        validateCardType: function () {\n            return this.validateField(\n                'cc_number',\n                this.isValidCardNumber\n            );\n        },\n\n        /**\n         * Validate current expiry date\n         * @returns {boolean}\n         */\n        validateExpirationDate: function () {\n            return this.validateField(\n                'expirationDate',\n                this.isValidExpirationDate === true\n            );\n        },\n\n        /**\n         * Validate current CVV field\n         * @returns {boolean}\n         */\n        validateCvvNumber: function () {\n            return this.validateField(\n                'cc_cid',\n                this.isValidCvvNumber === true\n            );\n        },\n\n        /**\n         * Get image for CVV\n         * @returns {String}\n         */\n        getCvvImageHtml: function () {\n            return '<img src=\"' + this.cvvImage +\n                '\" alt=\"' + $t('Card Verification Number Visual Reference') +\n                '\" title=\"' + $t('Card Verification Number Visual Reference') +\n                '\" />';\n        },\n\n        /**\n         * Prepare data to place order\n         */\n        handleNonce: function () {\n\n            $('body').trigger('processStart');\n            this.viewModel.errorMessage('');\n\n            let state = $.Deferred(),\n                addressBilling = uiRegistry.get('store-braintree-card-form.address'),\n                shippingId = addressBilling.addressModal.viewModel.currentShippingId(),\n\n                // If we have a shipping ID then get the selected address otherwise use the new address.\n                currentAddress = shippingId\n                    ? addressBilling.addressModal.viewModel.currentAddresses().find(function (address) {\n                        return address.id === shippingId;\n                    }) : {\n                        firstname: document.getElementById('firstname').value,\n                        lastname: document.getElementById('lastname').value,\n                        telephone: document.getElementById('telephone').value,\n                        street: [\n                            document.getElementById('street_1').value,\n                            document.getElementById('street_2').value\n                        ],\n                        city: document.getElementById('city').value,\n                        region: {\n                            region_code: document.getElementById('region_id').value\n                        },\n                        postcode: document.getElementById('zip').value,\n                        country_id: document.getElementById('country').value\n                    };\n\n            const billingAddress = {\n                givenName: currentAddress.firstname,\n                surname: currentAddress.lastname,\n                phoneNumber: currentAddress.telephone,\n                streetAddress: currentAddress.street[0],\n                extendedAddress: currentAddress.street[1],\n                locality: currentAddress.city,\n                region: currentAddress.region.region_code,\n                postalCode: currentAddress.postcode,\n                countryCodeAlpha2: currentAddress.country_id\n            };\n\n            this.hostedFieldsInstance\n                .tokenize({\n                    vault: true,\n                    billingAddress\n                }).then(function (payload) {\n                    this.viewModel.paymentMethodNonce(payload.nonce);\n                    let threeDSEnabled = this.viewModel.isThreeDSecureEnabled();\n\n                    const callback = () => {\n                        const nonce = this.viewModel.paymentMethodNonce();\n\n                        this.clientConfig.onPaymentMethodReceived({ nonce });\n                    };\n\n                    if (threeDSEnabled) {\n                        threeDSecure.create({\n                            version: 2,\n                            client: this.clientInstance\n                        }, function (threeDSecureErr, threeDSecureInstance) {\n                            if (threeDSecureErr) {\n                                console.warn(threeDSecureErr);\n                                return;\n                            }\n\n                            threeDSecureInstance.verifyCard({\n                                amount: this.viewModel.total(),\n                                nonce: payload.nonce,\n                                bin: payload.details.bin,\n                                cardAddChallengeRequested: true,\n                                vault: true,\n\n                                onLookupComplete: function (data, next) {\n                                    next();\n                                }\n                            }, function (err, response) {\n                                if (err) {\n                                    $('body').trigger('processStop');\n                                    this.viewModel.errorMessage($t('Please try again with another form of payment.'));\n                                    return state.reject($t('Please try again with another form of payment.'));\n                                }\n\n                                let liability = {\n                                    shifted: response.liabilityShifted,\n                                    shiftPossible: response.liabilityShiftPossible\n                                };\n\n                                if (liability.shifted || !liability.shifted && !liability.shiftPossible) {\n                                    this.viewModel.paymentMethodNonce(response.nonce);\n                                    state.resolve();\n\n                                    // Validation Passed\n                                    callback();\n\n                                } else {\n                                    // eslint-disable-next-line max-len\n                                    this.viewModel.errorMessage($t('We could not validate your payment method. Please try again with another form of payment.'));\n                                    $('body').trigger('processStop');\n                                    state.reject($t('Please try again with another form of payment.'));\n                                }\n                            }.bind(this));\n                        }.bind(this));\n                    } else {\n                        callback();\n                    }\n                }.bind(this))\n                .catch(function () {\n                    $('body').trigger('processStop');\n                });\n        }\n    });\n\n    return Component.extend(uiC);\n});\n","PayPal_Braintree/js/customer/payment/braintree-paypal.js":"define([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'PayPal_Braintree/js/view/payment/adapter',\n    'braintreePayPalCheckout',\n    'mage/translate'\n], function (Component, $, ko, _, braintree, paypalCheckout, $t) {\n    'use strict';\n\n    /**\n     * braintree is not an instance of Component so we need to merge in our changes\n     * and return an instance of Component with the final merged object.\n     */\n    var uiC = _.extend(braintree, {\n        clientToken: null,\n        uiConfig: null,\n        paymentMethodNonce: null,\n\n        viewModel: {\n            errorMessage: ko.observable()\n        },\n\n        /**\n         * @inheritDoc\n         */\n        initialize: function (uiConfig) {\n            this._super();\n\n            this.uiConfig = uiConfig;\n            this.merchantName = uiConfig.merchantName;\n            this.locale = uiConfig.locale;\n            this.currency = uiConfig.currency;\n            this.orderAmount = uiConfig.orderAmount;\n            const self = this;\n\n            this.clientConfig = {\n\n                additionalData: {},\n                buttonId: 'paypal_container',\n\n                /**\n                 * Device data initialization\n                 * @param {String} deviceData\n                 */\n                onDeviceDataReceived: function (deviceData) {\n                    this.additionalData['device_data'] = deviceData;\n                },\n\n                /**\n                 * Triggers when widget is loaded\n                 * @param {Object} context\n                 */\n                onReady: function (context) {\n                    paypalCheckout.create({\n                        client: context.clientInstance\n                    }, async function (paypalCheckoutErr, paypalCheckoutInstance) {\n                        self.setPayPalInstance(paypalCheckoutInstance);\n\n                        await paypalCheckoutInstance.loadPayPalSDK({\n                            vault: true\n                        });\n\n                        window.paypal.Buttons({\n                            fundingSource: window.paypal.FUNDING.PAYPAL,\n\n                            createBillingAgreement: function () {\n                                return paypalCheckoutInstance.createPayment({\n                                    flow: 'vault',\n\n                                    enableShippingAddress: false,\n                                    shippingAddressEditable: false,\n\n                                    amount: self.orderAmount,\n                                    currency: self.currency,\n                                    locale: self.locale\n                                });\n                            },\n\n                            onApprove: function (data) {\n                                $('body').trigger('processStart');\n                                return paypalCheckoutInstance.tokenizePayment(data, function (err, payload) {\n                                    if (err) {\n                                        $('body').trigger('processStop');\n                                        self.viewModel.errorMessage(\n                                            $t('Please try again with another form of payment.'));\n                                        return;\n                                    }\n\n                                    $.ajax({\n                                        url: '/rest/default/V1/braintree/mine/payment/vault',\n                                        type: 'POST',\n                                        data: JSON.stringify({\n                                            payment: {\n                                                payment_method_code: 'braintree_paypal',\n                                                payment_method_nonce: payload.nonce,\n                                                device_data: self.deviceData\n                                            }\n                                        }),\n                                        contentType:'application/json; charset=utf-8',\n                                        success: function () {\n                                            window.location.reload();\n                                        },\n                                        error: function (error) {\n                                            $('body').trigger('processStop');\n                                            console.warn(error.message);\n                                        }\n                                    });\n                                });\n                            },\n\n                            onCancel: function (data) {\n                                console.log('PayPal payment canceled', JSON.stringify(data, 0, 2));\n                            },\n\n                            onError: function (err) {\n                                console.error('PayPal error', err);\n                            }\n                        }).render('#paypal_container_account');\n                    });\n                },\n\n                /**\n                 * Triggers on any Braintree error\n                 * @param {Object} response\n                 */\n                onError: function (response) {\n                    self.showError($t('PayPal error msg'));\n                    throw response.message;\n                },\n\n                /**\n                 * Triggers when customer click \"Cancel\"\n                 */\n                onCancelled: function () {\n                    self.showError($t('The process has been cancelled'));\n                },\n\n                onPaymentMethodReceived: function (response) {\n                    self.paymentMethodNonce = response.nonce;\n                    $('#braintree-paypal-payment-method-nonce').val(response.nonce);\n                    $('#braintree-paypal-form').trigger('submit');\n                },\n\n                dataCollector: {\n                    paypal: true\n                },\n                paypal: {\n                    container: 'paypal_container_account',\n                    flow: 'vault',\n                    singleUse: false,\n                    amount: self.orderAmount,\n                    currency: self.currency,\n                    locale: self.locale,\n                    enableShippingAddress: false,\n                    displayName: self.merchantName,\n\n                    /**\n                     * Triggers on any Braintree error\n                     */\n                    onError: function () {\n                        this.paymentMethodNonce = null;\n                    },\n\n                    /**\n                     * Triggers if browser doesn't support PayPal Checkout\n                     */\n                    onUnsupported: function () {\n                        this.paymentMethodNonce = null;\n                    }\n                }\n            };\n\n            this.setConfig(this.clientConfig);\n            this.clientToken = uiConfig.clientToken;\n        },\n\n        /**\n         * @inheritDoc\n         */\n        getClientToken: function () {\n            return this.clientToken;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getColor: function () {\n            return this.color;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getShape: function () {\n            return this.shape;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getLayout: function () {\n            return this.layout;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSize: function () {\n            return this.size;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getEnvironment: function () {\n            return this.environment;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getDisabledFunding: function () {\n            return this.disabledFunding;\n        },\n\n        /**\n         * Set the PayPal instance or null it by setting the value of the property.\n         *\n         * @param val\n         */\n        setPayPalInstance: function (val) {\n            this.paypalInstance = val;\n        },\n\n        /**\n         * Run the teardown script to remove the PayPal instance.\n         */\n        teardownPayPalInstance: function () {\n            if (this.paypalInstance) {\n                this.paypalInstance.teardown(function () {\n                    $('#paypal_container_account').empty();\n                });\n                this.paypalInstance = null;\n            }\n\n            window.dispatchEvent(new Event('paypal:reinit-express'));\n        }\n    });\n\n    return Component.extend(uiC);\n});\n","PayPal_Braintree/js/customer/payment/update-payment.js":"define([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'uiRegistry'\n], function (Component, $, ko, registry) {\n    'use strict';\n    return Component.extend({\n        defaults: {\n            addNewCardVM: {\n                visible: ko.observable(false)\n            },\n            addNewPayPalVM: {\n                visible: ko.observable(false)\n            },\n            errorModalVM: {\n                visible: ko.observable(false),\n                message: ko.observable(null),\n                header: ko.observable('Error')\n            }\n        },\n\n        /**\n         * Add the repeat order block to the frontend\n         */\n        initialize: function () {\n            this.modifyKnockoutRemovalBehaviour();\n\n            this._super();\n        },\n\n        /**\n         * By moving the billing address form inside of Knockout it\n         * conflicts with the mage.directoryRegionUpdater widget.\n         *\n         * Knockout will run a cleanData method that removes jQuery events so removes the region updater events\n         * so User's will no longer see the correct region fields.\n         */\n        modifyKnockoutRemovalBehaviour: function () {\n            const normalFunction = ko.utils.domNodeDisposal.cleanExternalData;\n\n            ko.utils.domNodeDisposal.cleanExternalData = function (node) {\n                if (node.id === 'country') {\n                    return;\n                }\n\n                normalFunction(node);\n            };\n        },\n\n        showAddCardModal: function () {\n            this.addNewCardVM.visible(true);\n\n            $('html, body').animate({scrollTop: 0}, 400);\n        },\n\n        hideAddCardModal: function () {\n            this.addNewCardVM.visible(false);\n        },\n\n        showAddPayPalModal: function () {\n            var braintreePaypal = registry.get('new-form-braintree-paypal');\n\n            braintreePaypal.setup();\n            this.addNewPayPalVM.visible(true);\n        },\n\n        hideAddPayPalModal: function () {\n            var braintreePaypal = registry.get('new-form-braintree-paypal');\n\n            braintreePaypal.teardownPayPalInstance();\n            this.addNewPayPalVM.visible(false);\n        }\n    });\n});\n","PayPal_Braintree/js/customer/modals/address-modal.js":"define([\n    'jquery',\n    'ko',\n    'PayPal_Braintree/js/customer/utilities',\n    'mageUtils'\n], function ($, ko, utilities, utils) {\n    'use strict';\n\n    return {\n        viewModel: {\n            visible: ko.observable(false),\n            newAddressFormVisible: ko.observable(false),\n            selectExistingVisible: ko.observable(false),\n            currentAddresses: ko.observableArray([]),\n            initialSubscriptionAddressId: ko.observable(null),\n            currentShippingId: ko.observable(null),\n            currentEntityId: ko.observable(null),\n            currentOrderIsGrouped: ko.observable(false),\n            useForSelected: ko.observable(false),\n            saveAddressDisabled: ko.observable(true),\n            confirmationVisibleType: ko.observable(null),\n            defaultForAllAddressId: ko.observable(null),\n            isLookup: ko.observable(true),\n            newAddress: {\n                firstName: document.getElementById('firstname').value,\n                lastName: document.getElementById('lastname').value,\n                street: document.getElementById('street_1').value,\n                street2: document.getElementById('street_2').value,\n                city: document.getElementById('city').value,\n                postcode: document.getElementById('zip').value,\n                country: document.getElementById('country').value,\n                telephone: document.getElementById('telephone').value,\n                region: document.getElementById('region_id').value\n            },\n            currentCountryId: ko.observable(null),\n            countries: ko.observableArray(null)\n        },\n\n        fetchAllAddressUrl: 'rest/V1/repeat-orders/user-addresses',\n        assignAddressUrl: 'rest/V1/repeat-orders/grouped/set-shipping-address/',\n        useForAllUrl: 'rest/V1/repeat-orders/set-shipping-address-for-all/',\n        addAddressUrl: 'rest/V1/repeat-orders/add-shipping-address/',\n        validatedPostCodeExample: [],\n\n        showAddressModal: function (entity_id, groupedOrdersLength, shippingId, countryId) {\n            var self = this;\n\n            this.viewModel.visible(true);\n            this.viewModel.selectExistingVisible(true);\n            this.viewModel.currentEntityId(entity_id);\n            this.viewModel.initialSubscriptionAddressId(shippingId);\n            this.viewModel.currentOrderIsGrouped(groupedOrdersLength > 1);\n            this.viewModel.useForSelected(false);\n            this.clearAddressField();\n\n            fetch('/graphql', {\n                method: 'POST',\n                headers: {\n                    'Content-Type': 'application/json'\n                },\n                body: JSON.stringify({\n                    query: `{\n                customer {\n                    addresses {\n                        id,\n                        street,\n                        country_id,\n                        region {\n                            region_code\n                        },\n                        telephone,\n                        postcode,\n                        firstname,\n                        lastname,\n                        city\n                    }\n                }\n              }`\n                })\n            }).then(response => response.json()).then(response => {\n                const addresses = response.data.customer?.addresses || [];\n\n                self.viewModel.currentAddresses.removeAll();\n\n                //Get addresses from response and put them in an observable array\n                //The template looks at the array and builds the <select> dropdown form\n                for (let i = 0; i < addresses.length; i++) {\n                    const address = {\n                        id: addresses[i].id,\n                        firstname: addresses[i].firstname,\n                        lastname: addresses[i].lastname,\n                        region: {\n                            region_code: addresses[i].region.region_code\n                        },\n                        telephone: addresses[i].telephone,\n                        postcode: addresses[i].postcode,\n                        country_id: addresses[i].country_id,\n                        city: addresses[i].city,\n                        street: addresses[i].street.join(', ')\n                    };\n\n                    self.viewModel.currentAddresses.push(address);\n                }\n\n                self.viewModel.currentShippingId(shippingId);\n                self.viewModel.currentCountryId(countryId);\n                self.viewModel.saveAddressDisabled(true);\n            });\n        },\n\n        hideAddressModal: function () {\n            this.viewModel.newAddressFormVisible(false);\n            this.viewModel.selectExistingVisible(false);\n            this.viewModel.confirmationVisibleType(null);\n            this.viewModel.visible(false);\n\n            // Remove previous clickToAddress initialization block\n            $('#cc_c2a').remove();\n        },\n\n        showConfirmChangeAddress: function (event, context, type) {\n            if (type === 'new') {\n                let form = $(event.target).closest('form');\n\n                if (!(form.validation() && form.validation('isValid'))) {\n                    return false;\n                }\n            }\n\n            this.viewModel.newAddressFormVisible(false);\n            this.viewModel.selectExistingVisible(false);\n            this.viewModel.confirmationVisibleType(type);\n        },\n\n        /**\n     * @param {*} postCode\n     * @param {*} countryId\n     * @return {Boolean}\n     */\n        validatePostCode: function (postCode, countryId) {\n            var pattern, regex,\n                patterns = window.checkout.postCodes[countryId];\n\n            this.validatedPostCodeExample = [];\n\n            if (!utils.isEmpty(postCode) && !utils.isEmpty(patterns)) {\n                for (pattern in patterns) {\n                    if (patterns.hasOwnProperty(pattern)) { //eslint-disable-line max-depth\n                        this.validatedPostCodeExample.push(patterns[pattern].example);\n                        regex = new RegExp(patterns[pattern].pattern);\n\n                        if (regex.test(postCode)) { //eslint-disable-line max-depth\n                            return true;\n                        }\n                    }\n                }\n\n                return false;\n            }\n\n            return true;\n        },\n\n        postcodeValidation: function (postcodeElement) {\n            var countryId = $('select[name=\"country\"]:visible').val(),\n                validationResult,\n                warnMessage,\n                warnElement = $('.warning-postcode');\n\n            if (postcodeElement == null || postcodeElement.val() == null) {\n                return true;\n            }\n\n            warnElement.hide();\n            warnElement.text('');\n\n            validationResult = this.validatePostCode(postcodeElement.val(), countryId, []);\n\n            if (!validationResult) {\n                warnMessage = 'Please enter a valid post code.';\n                warnElement.show();\n                warnElement.text(warnMessage);\n\n                if (warnMessage) {\n                    warnElement.prev().addClass('input-postcode-error');\n                }\n\n            } else {\n                warnElement.prev().removeClass('input-postcode-error');\n            }\n\n            return validationResult;\n        },\n\n        toggleNewAddAddressForm: function (show) {\n            this.viewModel.newAddressFormVisible(show);\n            this.viewModel.selectExistingVisible(!show);\n            this.viewModel.isLookup(show);\n            this.clearAddressField();\n        },\n\n        clearAddressField: function () {\n            $('#cc_c2a').remove();\n            this.viewModel.currentShippingId(null);\n            this.viewModel.newAddress.street = null;\n            this.viewModel.newAddress.street = null;\n            this.viewModel.newAddress.street2 = null;\n            this.viewModel.newAddress.city = null;\n            this.viewModel.newAddress.postcode = null;\n            this.viewModel.newAddress.telephone = null;\n            this.viewModel.newAddress.country = this.viewModel.currentCountryId();\n        },\n\n        updateCurrentAddressId: function () {\n            var current = this.viewModel.currentShippingId(),\n                initial = this.viewModel.initialSubscriptionAddressId();\n\n            this.viewModel.saveAddressDisabled(current === initial);\n            this.viewModel.useForSelected(false);\n        },\n\n        onUseForAllChange: function (type, event) {\n            if (event && event.target) {\n                this.viewModel.useForSelected(event.target.checked);\n            }\n\n            if (type === 'existing') {\n                let currentId = this.viewModel.currentShippingId(),\n                    initialId = this.viewModel.initialSubscriptionAddressId(),\n                    defaultForAll = this.viewModel.defaultForAllAddressId();\n\n                if (currentId === initialId && defaultForAll === currentId && this.viewModel.useForSelected()) {\n                    this.viewModel.saveAddressDisabled(!this.viewModel.saveAddressDisabled());\n                }\n            }\n\n            return true;\n        },\n\n        submitChanges: function (event) {\n            if (this.viewModel.confirmationVisibleType() === 'new') {\n                return this.submitNewAddress(event);\n            }\n\n            return this.submitExistingAddress();\n        },\n\n        submitExistingAddress: function () {\n            var self = this,\n                entityId = this.viewModel.currentEntityId(),\n                addressId = this.viewModel.currentShippingId(),\n                useForAll = this.viewModel.useForSelected(),\n                url = (useForAll ? this.useForAllUrl : this.assignAddressUrl + entityId + '/') + addressId,\n                verb = useForAll ? 'POST' : 'PUT';\n\n            utilities.makeCall(url, verb, function () {\n                self.hideAddressModal();\n                utilities.viewModel.updatedOrderEntityId(entityId);\n            }, self.viewModel);\n\n            return true;\n        },\n\n        submitNewAddress: function () {\n            var self = this,\n                entityId = this.viewModel.currentEntityId,\n                firstName = this.viewModel.newAddress.firstName,\n                lastName = this.viewModel.newAddress.lastName,\n                street = this.viewModel.newAddress.street,\n                city = this.viewModel.newAddress.city,\n                postcode = this.viewModel.newAddress.postcode,\n                country = this.viewModel.currentCountryId,\n                telephone = this.viewModel.newAddress.telephone,\n                url = this.addAddressUrl +\n          '?entityId=' + entityId +\n          '&firstName=' + firstName +\n          '&lastName=' + lastName +\n          '&street=' + street +\n          '&postcode=' + postcode +\n          '&city=' + city +\n          '&countryId=' + country +\n          '&telephone=' + telephone;\n\n            utilities.makeCall(\n                url,\n                'POST',\n                function (response) {\n                    self.viewModel.currentShippingId(response.id);\n                    self.submitExistingAddress();\n                }, self.viewModel);\n\n            return true;\n        }\n    };\n});\n","Magento_Multishipping/js/multi-shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'jquery-ui-modules/widget'\n], function ($, customerData) {\n    'use strict';\n\n    $.widget('mage.multiShipping', {\n        options: {\n            itemsQty: 0,\n            addNewAddressBtn: 'button[data-role=\"add-new-address\"]', // Add a new multishipping address.\n            addNewAddressFlag: '#add_new_address_flag', // Hidden input field with value 0 or 1.\n            canContinueBtn: 'button[data-role=\"can-continue\"]', // Continue (update quantity or go to shipping).\n            canContinueFlag: '#can_continue_flag' // Hidden input field with value 0 or 1.\n        },\n\n        /**\n         * Bind event handlers to click events for corresponding buttons.\n         * @private\n         */\n        _create: function () {\n            this._prepareCartData();\n            $(this.options.addNewAddressBtn).on('click', $.proxy(this._addNewAddress, this));\n            $(this.options.canContinueBtn).on('click', $.proxy(this._canContinue, this));\n        },\n\n        /**\n         * Takes cart items qty from current cart data and compare it with current items qty\n         * Reloads cart data if cart items qty is wrong\n         * @private\n         */\n        _prepareCartData: function () {\n            var cartData = customerData.get('cart');\n\n            if (cartData()['summary_count'] !== this.options.itemsQty) {\n                customerData.reload(['cart'], false);\n            }\n        },\n\n        /**\n         * Add a new address. Set the hidden input field and submit the form. Then enter a new shipping address.\n         * @private\n         */\n        _addNewAddress: function () {\n            $(this.options.addNewAddressFlag).val(1);\n            this.element.submit();\n        },\n\n        /**\n         * Can the user continue to the next step? The data-flag attribute holds either 0 (no) or 1 (yes).\n         * @private\n         * @param {Event} event - Click event on the corresponding button.\n         */\n        _canContinue: function (event) {\n            $(this.options.canContinueFlag).val(parseInt($(event.currentTarget).data('flag'), 10));\n        }\n    });\n\n    return $.mage.multiShipping;\n});\n","Magento_Multishipping/js/payment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.payment', {\n        options: {\n            continueSelector: '#payment-continue',\n            methodsContainer: '#payment-methods',\n            minBalance: 0,\n            tmpl: '<input id=\"hidden-free\" type=\"hidden\" name=\"payment[method]\" value=\"free\">'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.element.find('dd [name^=\"payment[\"]').prop('disabled', true).end()\n                .on('click', this.options.continueSelector, $.proxy(this._submitHandler, this))\n                .on('updateCheckoutPrice', $.proxy(function (event, data) {\n                    //updating the checkoutPrice\n                    if (data.price) {\n                        this.options.checkoutPrice += data.price;\n                    }\n\n                    //updating total price\n                    if (data.totalPrice) {\n                        data.totalPrice = this.options.checkoutPrice;\n                    }\n\n                    if (this.options.checkoutPrice <= this.options.minBalance) {\n                        // Add free input field, hide and disable unchecked\n                        // checkbox payment method and all radio button payment methods\n                        this._disablePaymentMethods();\n                    } else {\n                        // Remove free input field, show all payment method\n                        this._enablePaymentMethods();\n                    }\n                }, this))\n                .on('click', 'dt input:radio', $.proxy(this._paymentMethodHandler, this));\n\n            if (this.options.checkoutPrice < this.options.minBalance) {\n                this._disablePaymentMethods();\n            } else {\n                this._enablePaymentMethods();\n            }\n        },\n\n        /**\n         * Display payment details when payment method radio button is checked\n         * @private\n         * @param {EventObject} e\n         */\n        _paymentMethodHandler: function (e) {\n            var element = $(e.target),\n                parentsDl = element.closest('dl');\n\n            parentsDl.find('dt input:radio').prop('checked', false);\n            parentsDl.find('dd').addClass('no-display').end()\n                .find('.items').hide()\n                .find('[name^=\"payment[\"]').prop('disabled', true);\n            element.prop('checked', true).parent()\n                .next('dd').removeClass('no-display')\n                .find('.items').show().find('[name^=\"payment[\"]').prop('disabled', false);\n        },\n\n        /**\n         * make sure one payment method is selected\n         * @private\n         * @return {Boolean}\n         */\n        _validatePaymentMethod: function () {\n            var methods = this.element.find('[name^=\"payment[\"]'),\n                isValid = false;\n\n            if (methods.length === 0) {\n                alert({\n                    content: $.mage.__('We can\\'t complete your order because you don\\'t have a payment method set up.')\n                });\n            } else if (this.options.checkoutPrice <= this.options.minBalance) {\n                isValid = true;\n            } else if (methods.filter('input:radio:checked').length) {\n                isValid = true;\n            } else {\n                alert({\n                    content: $.mage.__('Please choose a payment method.')\n                });\n            }\n\n            return isValid;\n        },\n\n        /**\n         * Disable and enable payment methods\n         * @private\n         */\n        _disablePaymentMethods: function () {\n            var tmpl = mageTemplate(this.options.tmpl, {\n                data: {}\n            });\n\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', true).end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', true).parent().hide();\n            this.element.find('[name=\"payment[method]\"][value=\"free\"]').parent('dt').remove();\n            this.element.find(this.options.methodsContainer).hide().find('[name^=\"payment[\"]').prop('disabled', true);\n\n            $(tmpl).appendTo(this.element);\n        },\n\n        /**\n         * Enable and enable payment methods\n         * @private\n         */\n        _enablePaymentMethods: function () {\n            this.element.find('input[name=\"payment[method]\"]').prop('disabled', false).end()\n                .find('dt input:radio:checked').trigger('click').end()\n                .find('input[id^=\"use\"][name^=\"payment[use\"]:not(:checked)').prop('disabled', false).parent().show();\n            this.element.find(this.options.methodsContainer).show();\n        },\n\n        /**\n         * Returns checked payment method.\n         *\n         * @private\n         */\n        _getSelectedPaymentMethod: function () {\n            return this.element.find('input[name=\\'payment[method]\\']:checked');\n        },\n\n        /**\n         * Validate  before form submit\n         * @private\n         * @param {EventObject} e\n         */\n        _submitHandler: function (e) {\n            var currentMethod,\n                submitButton;\n\n            e.preventDefault();\n\n            if (this._validatePaymentMethod()) {\n                currentMethod = this._getSelectedPaymentMethod();\n                submitButton = currentMethod.parent().next('dd').find('button[type=submit]');\n\n                if (submitButton.length) {\n                    submitButton.first().trigger('click');\n                } else {\n                    this.element.trigger('submit');\n                }\n            }\n        }\n    });\n\n    return $.mage.payment;\n});\n","Magento_Multishipping/js/overview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.orderOverview', {\n        options: {\n            opacity: 0.5, // CSS opacity for the 'Place Order' button when it's clicked and then disabled.\n            pleaseWaitLoader: 'span.please-wait', // 'Submitting order information...' Ajax loader.\n            placeOrderSubmit: 'button[type=\"submit\"]', // The 'Place Order' button.\n            agreements: '.checkout-agreements' // Container for all of the checkout agreements and terms/conditions\n        },\n\n        /**\n         * Bind a submit handler to the form.\n         * @private\n         */\n        _create: function () {\n            this.element.on('submit', $.proxy(this._showLoader, this));\n        },\n\n        /**\n         * Verify that all agreements and terms/conditions are checked. Show the Ajax loader. Disable\n         * the submit button (i.e. Place Order).\n         * @return {Boolean}\n         * @private\n         */\n        _showLoader: function () {\n            if ($(this.options.agreements).find('input[type=\"checkbox\"]:not(:checked)').length > 0) {\n                return false;\n            }\n            this.element.find(this.options.pleaseWaitLoader).show().end()\n                .find(this.options.placeOrderSubmit).prop('disabled', true).css('opacity', this.options.opacity);\n\n            return true;\n        }\n    });\n\n    return $.mage.orderOverview;\n});\n","Magento_Multishipping/js/multi-shipping-balance.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/dataPost',\n    'jquery-ui-modules/widget'\n], function ($, dataPost) {\n    'use strict';\n\n    $.widget('mage.multiShippingBalance', {\n        options: {\n            changeUrl: ''\n        },\n\n        /**\n         * Initialize balance checkbox events.\n         *\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(function (event) {\n                dataPost().postData({\n                    action: this.options.changeUrl,\n                    data: {\n                        useBalance: +$(event.target).is(':checked')\n                    }\n                });\n            }, this));\n        }\n    });\n\n    return $.mage.multiShippingBalance;\n});\n","Magento_GroupedProduct/js/product-ids-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/product/view/product-ids',\n    'Magento_Catalog/js/product/view/product-info'\n], function ($, productIds, productInfo) {\n    'use strict';\n\n    /**\n     * Returns id's of products in form.\n     *\n     * @param {Object} config\n     * @param {HTMLElement} element\n     * @return {Array}\n     */\n    return function (config, element) {\n        $(element).find('div[data-product-id]').each(function () {\n            productIds.push($(this).data('productId').toString());\n            productInfo.push(\n                {\n                    'id': $(this).data('productId').toString()\n                }\n            );\n        });\n\n        return productIds();\n    };\n});\n","Magento_GroupedProduct/js/grouped-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.groupedProduct', {\n        options: {\n            qtySelector: 'input.qty',\n            qtyNameSelector: 'super_group'\n        },\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            // Override defaults with URL query parameters and/or inputs values\n            this._overrideDefaults();\n        },\n\n        /**\n         * Override default options values settings with either URL query parameters or\n         * initialized inputs values.\n         * @private\n         */\n        _overrideDefaults: function () {\n            var hashIndex = window.location.href.indexOf('#');\n\n            if (hashIndex !== -1) {\n                this._parseQueryParams(window.location.href.substr(hashIndex + 1));\n            }\n        },\n\n        /**\n         * Parse query parameters from a query string and set options values based on the\n         * key value pairs of the parameters.\n         * @param {*} queryString - URL query string containing query parameters.\n         * @private\n         */\n        _parseQueryParams: function (queryString) {\n            var queryParams = $.parseQuery({\n                    query: queryString\n                }),\n                form = this.element,\n                qtyNameSelector = this.options.qtyNameSelector,\n                qtys = $(this.options.qtySelector, form);\n\n            $.each(queryParams, $.proxy(function (key, value) {\n                qtys.each(function (index, qty) {\n                    var nameSelector = qtyNameSelector.concat('[', key, ']');\n\n                    if (qty.name === nameSelector) {\n                        $(qty).val(value);\n                    }\n                });\n            }, this));\n        }\n    });\n\n    return $.mage.groupedProduct;\n});\n","Magento_Payment/js/transparent.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'Magento_Payment/js/model/credit-card-validation/validator',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, mageTemplate, alert, ui, validator, fullScreenLoader) {\n    'use strict';\n\n    $.widget('mage.transparent', {\n        options: {\n            context: null,\n            placeOrderSelector: '[data-role=\"review-save\"]',\n            paymentFormSelector: '#co-payment-form',\n            updateSelectorPrefix: '#checkout-',\n            updateSelectorSuffix: '-load',\n            hiddenFormTmpl:\n                '<form target=\"<%= data.target %>\" action=\"<%= data.action %>\" method=\"POST\" ' +\n                'hidden enctype=\"application/x-www-form-urlencoded\" class=\"no-display\">' +\n                    '<% _.each(data.inputs, function(val, key){ %>' +\n                    '<input value=\"<%= val %>\" name=\"<%= key %>\" type=\"hidden\">' +\n                    '<% }); %>' +\n                '</form>',\n            reviewAgreementForm: '#checkout-agreements',\n            cgiUrl: null,\n            orderSaveUrl: null,\n            controller: null,\n            gateway: null,\n            dateDelim: null,\n            cardFieldsMap: null,\n            expireYearLength: 2\n        },\n\n        /**\n         * {Function}\n         * @private\n         */\n        _create: function () {\n            this.hiddenFormTmpl = mageTemplate(this.options.hiddenFormTmpl);\n\n            if (this.options.context) {\n                this.options.context.setPlaceOrderHandler($.proxy(this._orderSave, this));\n                this.options.context.setValidateHandler($.proxy(this._validateHandler, this));\n            } else {\n                $(this.options.placeOrderSelector)\n                    .off('click')\n                    .on('click', $.proxy(this._placeOrderHandler, this));\n            }\n\n            this.element.validation();\n            $('[data-container=\"' + this.options.gateway + '-cc-number\"]').on('focusout', function () {\n                $(this).valid();\n            });\n        },\n\n        /**\n         * handler for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _validateHandler: function () {\n            return this.element.validation && this.element.validation('isValid');\n        },\n\n        /**\n         * handler for Place Order button to call gateway for credit card validation\n         * @return {Boolean}\n         * @private\n         */\n        _placeOrderHandler: function () {\n            if (this._validateHandler()) {\n                this._orderSave();\n            }\n\n            return false;\n        },\n\n        /**\n         * Save order and generate post data for gateway call\n         * @private\n         */\n        _orderSave: function () {\n            var postData = $(this.options.paymentFormSelector).serialize();\n\n            if ($(this.options.reviewAgreementForm).length) {\n                postData += '&' + $(this.options.reviewAgreementForm).serialize();\n            }\n            postData += '&controller=' + this.options.controller;\n            postData += '&cc_type=' + this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-type\"]'\n            ).val();\n\n            return $.ajax({\n                url: this.options.orderSaveUrl,\n                type: 'post',\n                context: this,\n                data: postData,\n                dataType: 'json',\n\n                /**\n                 * {Function}\n                 */\n                beforeSend: function () {\n                    fullScreenLoader.startLoader();\n                },\n\n                /**\n                 * {Function}\n                 */\n                success: function (response) {\n                    var preparedData,\n                        msg,\n\n                        /**\n                         * {Function}\n                         */\n                        alertActionHandler = function () {\n                            // default action\n                        };\n\n                    if (response.success && response[this.options.gateway]) {\n                        preparedData = this._preparePaymentData(\n                            response[this.options.gateway].fields,\n                            this.options.cardFieldsMap\n                        );\n                        this._postPaymentToGateway(preparedData);\n                    } else {\n                        fullScreenLoader.stopLoader(true);\n\n                        msg = response['error_messages'];\n\n                        if (this.options.context) {\n                            this.options.context.clearTimeout().fail();\n                            alertActionHandler = this.options.context.alertActionHandler;\n                        }\n\n                        if (typeof msg === 'object') {\n                            msg = msg.join('\\n');\n                        }\n\n                        if (msg) {\n                            alert(\n                                {\n                                    content: msg,\n                                    actions: {\n\n                                        /**\n                                         * {Function}\n                                         */\n                                        always: alertActionHandler\n                                    }\n                                }\n                            );\n                        }\n                    }\n                }.bind(this)\n            });\n        },\n\n        /**\n         * Post data to gateway for credit card validation\n         * @param {Object} data\n         * @private\n         */\n        _postPaymentToGateway: function (data) {\n            var tmpl,\n                iframeSelector = '[data-container=\"' + this.options.gateway + '-transparent-iframe\"]';\n\n            tmpl = this.hiddenFormTmpl({\n                data: {\n                    target: $(iframeSelector).attr('name'),\n                    action: this.options.cgiUrl,\n                    inputs: data\n                }\n            });\n            $(tmpl).appendTo($(iframeSelector)).trigger('submit');\n        },\n\n        /**\n         * Add credit card fields to post data for gateway\n         * @param {Object} data\n         * @param {Object} ccfields\n         * @private\n         */\n        _preparePaymentData: function (data, ccfields) {\n            var preparedata;\n\n            if (this.element.find('[data-container=\"' + this.options.gateway + '-cc-cvv\"]').length) {\n                data[ccfields.cccvv] = this.element.find(\n                    '[data-container=\"' + this.options.gateway + '-cc-cvv\"]'\n                ).val();\n            }\n            preparedata = this._prepareExpDate();\n            data[ccfields.ccexpdate] = preparedata.month + this.options.dateDelim + preparedata.year;\n            data[ccfields.ccnum] = this.element.find(\n                '[data-container=\"' + this.options.gateway + '-cc-number\"]'\n            ).val();\n\n            return data;\n        },\n\n        /**\n         * Grab Month and Year into one\n         * @returns {Object}\n         * @private\n         */\n        _prepareExpDate: function () {\n            var year = this.element.find('[data-container=\"' + this.options.gateway + '-cc-year\"]').val(),\n                month = parseInt(\n                    this.element.find('[data-container=\"' + this.options.gateway + '-cc-month\"]').val(),\n                    10\n                );\n\n            if (year.length > this.options.expireYearLength) {\n                year = year.substring(year.length - this.options.expireYearLength);\n            }\n\n            if (month < 10) {\n                month = '0' + month;\n            }\n\n            return {\n                month: month, year: year\n            };\n        }\n    });\n\n    return $.mage.transparent;\n});\n","Magento_Payment/js/cc-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.creditCardType', {\n        options: {\n            typeCodes: ['SS', 'SM', 'SO'] // Type codes for Switch/Maestro/Solo credit cards.\n        },\n\n        /**\n         * Bind change handler to select element and trigger the event to show/hide\n         * the Switch/Maestro or Solo credit card type container for those credit card types.\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(this._toggleCardType, this)).trigger('change');\n        },\n\n        /**\n         * Toggle the Switch/Maestro and Solo credit card type container depending on which\n         * credit card type is selected.\n         * @private\n         */\n        _toggleCardType: function () {\n            $(this.options.creditCardTypeContainer)\n                .toggle($.inArray(this.element.val(), this.options.typeCodes) !== -1);\n        }\n    });\n\n    return $.mage.creditCardType;\n});\n","Magento_Payment/js/model/credit-card-validation/cvv-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    /**\n     * CVV number validation.\n     * Validate digit count for CVV code.\n     *\n     * @param {*} value\n     * @param {Number} maxLength\n     * @return {Object}\n     */\n    return function (value, maxLength) {\n        var DEFAULT_LENGTH = 3;\n\n        maxLength = maxLength || DEFAULT_LENGTH;\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (value.length === maxLength) {\n            return resultWrapper(true, true);\n        }\n\n        if (value.length < maxLength) {\n            return resultWrapper(false, true);\n        }\n\n        if (value.length > maxLength) {\n            return resultWrapper(false, false);\n        }\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'mageUtils',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator'\n], function (utils, parseDate, expirationMonth, expirationYear) {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @param {*} month\n     * @param {*} year\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid, month, year) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid,\n            month: month,\n            year: year\n        };\n    }\n\n    return function (value) {\n        var date,\n            monthValid,\n            yearValid;\n\n        if (utils.isEmpty(value)) {\n            return resultWrapper(false, false, null, null);\n        }\n\n        value = value.replace(/^(\\d\\d) (\\d\\d(\\d\\d)?)$/, '$1/$2');\n        date = parseDate(value);\n        monthValid = expirationMonth(date.month);\n        yearValid = expirationYear(date.year);\n\n        if (monthValid.isValid && yearValid.isValid) {\n            return resultWrapper(true, true, date.month, date.year);\n        }\n\n        if (monthValid.isPotentiallyValid && yearValid.isPotentiallyValid) {\n            return resultWrapper(false, true, null, null);\n        }\n\n        return resultWrapper(false, false, null, null);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'mageUtils',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type'\n], function (utils, luhn10, creditCardTypes) {\n    'use strict';\n\n    /**\n     * @param {*} card\n     * @param {*} isPotentiallyValid\n     * @param {*} isValid\n     * @return {Object}\n     */\n    function resultWrapper(card, isPotentiallyValid, isValid) {\n        return {\n            card: card,\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var potentialTypes,\n            cardType,\n            valid,\n            i,\n            maxLength;\n\n        if (utils.isEmpty(value)) {\n            return resultWrapper(null, false, false);\n        }\n\n        value = value.replace(/\\s+/g, '');\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(null, false, false);\n        }\n\n        potentialTypes = creditCardTypes.getCardTypes(value);\n\n        if (potentialTypes.length === 0) {\n            return resultWrapper(null, false, false);\n        } else if (potentialTypes.length !== 1) {\n            return resultWrapper(null, true, false);\n        }\n\n        cardType = potentialTypes[0];\n\n        if (cardType.type === 'unionpay') {  // UnionPay is not Luhn 10 compliant\n            valid = true;\n        } else {\n            valid = luhn10(value);\n        }\n\n        for (i = 0; i < cardType.lengths.length; i++) {\n            if (cardType.lengths[i] === value.length) {\n                return resultWrapper(cardType, valid, valid);\n            }\n        }\n\n        maxLength = Math.max.apply(null, cardType.lengths);\n\n        if (value.length < maxLength) {\n            return resultWrapper(cardType, true, false);\n        }\n\n        return resultWrapper(cardType, false, false);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'Magento_Payment/js/model/credit-card-validation/cvv-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator',\n    'Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-data',\n    'mage/translate'\n], function ($, cvvValidator, creditCardNumberValidator, yearValidator, monthValidator, creditCardData) {\n    'use strict';\n\n    $('.payment-method-content input[type=\"number\"]').on('keyup', function () {\n        if ($(this).val() < 0) {\n            $(this).val($(this).val().replace(/^-/, ''));\n        }\n    });\n\n    $.each({\n        'validate-card-type': [\n            function (number, item, allowedTypes) {\n                var cardInfo,\n                    i,\n                    l;\n\n                if (!creditCardNumberValidator(number).isValid) {\n                    return false;\n                }\n\n                cardInfo = creditCardNumberValidator(number).card;\n\n                for (i = 0, l = allowedTypes.length; i < l; i++) {\n                    if (cardInfo.title == allowedTypes[i].type) { //eslint-disable-line eqeqeq\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card type number.')\n        ],\n        'validate-card-number': [\n\n            /**\n             * Validate credit card number based on mod 10\n             *\n             * @param {*} number - credit card number\n             * @return {Boolean}\n             */\n            function (number) {\n                return creditCardNumberValidator(number).isValid;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-card-date': [\n\n            /**\n             * Validate credit card expiration month\n             *\n             * @param {String} date - month\n             * @return {Boolean}\n             */\n            function (date) {\n                return monthValidator(date).isValid;\n            },\n            $.mage.__('Incorrect credit card expiration month.')\n        ],\n        'validate-card-cvv': [\n\n            /**\n             * Validate cvv\n             *\n             * @param {String} cvv - card verification value\n             * @return {Boolean}\n             */\n            function (cvv) {\n                var maxLength = creditCardData.creditCard ? creditCardData.creditCard.code.size : 3;\n\n                return cvvValidator(cvv, maxLength).isValid;\n            },\n            $.mage.__('Please enter a valid credit card verification number.')\n        ],\n        'validate-card-year': [\n\n            /**\n             * Validate credit card expiration year\n             *\n             * @param {String} date - year\n             * @return {Boolean}\n             */\n            function (date) {\n                return yearValidator(date).isValid;\n            },\n            $.mage.__('Incorrect credit card expiration year.')\n        ]\n\n    }, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([], function () {\n    'use strict';\n\n    return {\n        creditCard: null,\n        creditCardNumber: null,\n        expirationMonth: null,\n        expirationYear: null,\n        cvvCode: null\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-month-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var month,\n            monthValid;\n\n        if (value.replace(/\\s/g, '') === '' || value === '0') {\n            return resultWrapper(false, true);\n        }\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (isNaN(value)) {\n            return resultWrapper(false, false);\n        }\n\n        month = parseInt(value, 10);\n        monthValid = month > 0 && month < 13;\n\n        return resultWrapper(monthValid, monthValid);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/parse-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function (value) {\n        var month, len;\n\n        if (value.match('/')) {\n            value = value.split(/\\s*\\/\\s*/g);\n\n            return {\n                month: value[0],\n                year: value.slice(1).join()\n            };\n        }\n\n        len = value[0] === '0' || value.length > 5 || value.length === 4 || value.length === 3 ? 2 : 1;\n        month = value.substr(0, len);\n\n        return {\n            month: month,\n            year: value.substr(month.length, 4)\n        };\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/expiration-date-validator/expiration-year-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * @param {*} isValid\n     * @param {*} isPotentiallyValid\n     * @return {Object}\n     */\n    function resultWrapper(isValid, isPotentiallyValid) {\n        return {\n            isValid: isValid,\n            isPotentiallyValid: isPotentiallyValid\n        };\n    }\n\n    return function (value) {\n        var currentYear = new Date().getFullYear(),\n            len = value.length,\n            valid,\n            expMaxLifetime = 19;\n\n        if (value.replace(/\\s/g, '') === '') {\n            return resultWrapper(false, true);\n        }\n\n        if (!/^\\d*$/.test(value)) {\n            return resultWrapper(false, false);\n        }\n\n        if (len !== 4) {\n            return resultWrapper(false, true);\n        }\n\n        value = parseInt(value, 10);\n        valid = value >= currentYear && value <= currentYear + expMaxLifetime;\n\n        return resultWrapper(valid, valid);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/luhn10-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Luhn algorithm verification\n     */\n    return function (a, b, c, d, e) {\n        for (d = +a[b = a.length - 1], e = 0; b--;) {\n            c = +a[b];\n            d += ++e % 2 ? 2 * c % 10 + (c > 4) : c;\n        }\n\n        return !(d % 10);\n    };\n});\n","Magento_Payment/js/model/credit-card-validation/credit-card-number-validator/credit-card-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'mageUtils'\n], function ($, utils) {\n    'use strict';\n\n    var types = [\n        {\n            title: 'Visa',\n            type: 'VI',\n            pattern: '^4\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'MasterCard',\n            type: 'MC',\n            pattern: '^(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'American Express',\n            type: 'AE',\n            pattern: '^3([47]\\\\d*)?$',\n            isAmex: true,\n            gaps: [4, 10],\n            lengths: [15],\n            code: {\n                name: 'CID',\n                size: 4\n            }\n        },\n        {\n            title: 'Diners',\n            type: 'DN',\n            pattern: '^(3(0[0-5]|095|6|[8-9]))\\\\d*$',\n            gaps: [4, 10],\n            lengths: [14, 16, 17, 18, 19],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'Discover',\n            type: 'DI',\n            pattern: '^(6011(0|[2-4]|74|7[7-9]|8[6-9]|9)|6(4[4-9]|5))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CID',\n                size: 3\n            }\n        },\n        {\n            title: 'JCB',\n            type: 'JCB',\n            pattern: '^35(2[8-9]|[3-8])\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CVV',\n                size: 3\n            }\n        },\n        {\n            title: 'UnionPay',\n            type: 'UN',\n            pattern: '^(622(1(2[6-9]|[3-9])|[3-8]|9([[0-1]|2[0-5]))|62[4-6]|628([2-8]))\\\\d*?$',\n            gaps: [4, 8, 12],\n            lengths: [16, 17, 18, 19],\n            code: {\n                name: 'CVN',\n                size: 3\n            }\n        },\n        {\n            title: 'Maestro International',\n            type: 'MI',\n            pattern: '^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Maestro Domestic',\n            type: 'MD',\n            pattern: '^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [12, 13, 14, 15, 16, 17, 18, 19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Hipercard',\n            type: 'HC',\n            pattern: '^((606282)|(637095)|(637568)|(637599)|(637609)|(637612))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [13, 16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Elo',\n            type: 'ELO',\n            pattern: '^((509091)|(636368)|(636297)|(504175)|(438935)|(40117[8-9])|(45763[1-2])|' +\n                '(457393)|(431274)|(50990[0-2])|(5099[7-9][0-9])|(50996[4-9])|(509[1-8][0-9][0-9])|' +\n                '(5090(0[0-2]|0[4-9]|1[2-9]|[24589][0-9]|3[1-9]|6[0-46-9]|7[0-24-9]))|' +\n                '(5067(0[0-24-8]|1[0-24-9]|2[014-9]|3[0-379]|4[0-9]|5[0-3]|6[0-5]|7[0-8]))|' +\n                '(6504(0[5-9]|1[0-9]|2[0-9]|3[0-9]))|' +\n                '(6504(8[5-9]|9[0-9])|6505(0[0-9]|1[0-9]|2[0-9]|3[0-8]))|' +\n                '(6505(4[1-9]|5[0-9]|6[0-9]|7[0-9]|8[0-9]|9[0-8]))|' +\n                '(6507(0[0-9]|1[0-8]))|(65072[0-7])|(6509(0[1-9]|1[0-9]|20))|' +\n                '(6516(5[2-9]|6[0-9]|7[0-9]))|(6550(0[0-9]|1[0-9]))|' +\n                '(6550(2[1-9]|3[0-9]|4[0-9]|5[0-8])))\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [16],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        },\n        {\n            title: 'Aura',\n            type: 'AU',\n            pattern: '^5078\\\\d*$',\n            gaps: [4, 8, 12],\n            lengths: [19],\n            code: {\n                name: 'CVC',\n                size: 3\n            }\n        }\n    ];\n\n    return {\n        /**\n         * @param {*} cardNumber\n         * @return {Array}\n         */\n        getCardTypes: function (cardNumber) {\n            var i, value,\n                result = [];\n\n            if (utils.isEmpty(cardNumber)) {\n                return result;\n            }\n\n            if (cardNumber === '') {\n                return $.extend(true, {}, types);\n            }\n\n            for (i = 0; i < types.length; i++) {\n                value = types[i];\n\n                if (new RegExp(value.pattern).test(cardNumber)) {\n                    result.push($.extend(true, {}, value));\n                }\n            }\n\n            return result;\n        }\n    };\n});\n","Magento_Payment/js/view/payment/iframe.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'jquery',\n    'Magento_Payment/js/view/payment/cc-form',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Ui/js/modal/alert'\n], function (\n    $,\n    Component,\n    messageList,\n    $t,\n    fullScreenLoader,\n    setPaymentInformationAction,\n    additionalValidators,\n    alert\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Payment/payment/iframe',\n            timeoutId: null,\n            timeoutMessage: 'Sorry, but something went wrong.'\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSource: function () {\n            return window.checkoutConfig.payment.iframe.source[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getControllerName: function () {\n            return window.checkoutConfig.payment.iframe.controllerName[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getPlaceOrderUrl: function () {\n            return window.checkoutConfig.payment.iframe.placeOrderUrl[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getCgiUrl: function () {\n            return window.checkoutConfig.payment.iframe.cgiUrl[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getSaveOrderUrl: function () {\n            return window.checkoutConfig.payment.iframe.saveOrderUrl[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getDateDelim: function () {\n            return window.checkoutConfig.payment.iframe.dateDelim[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getCardFieldsMap: function () {\n            return window.checkoutConfig.payment.iframe.cardFieldsMap[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getExpireYearLength: function () {\n            return window.checkoutConfig.payment.iframe.expireYearLength[this.getCode()];\n        },\n\n        /**\n         * @param {Object} parent\n         * @returns {Function}\n         */\n        originalPlaceOrder: function (parent) {\n            return parent.placeOrder.bind(parent);\n        },\n\n        /**\n         * @returns {Number}\n         */\n        getTimeoutTime: function () {\n            return window.checkoutConfig.payment.iframe.timeoutTime[this.getCode()];\n        },\n\n        /**\n         * @returns {String}\n         */\n        getTimeoutMessage: function () {\n            return $t(this.timeoutMessage);\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (this.validateHandler() &&\n                additionalValidators.validate() &&\n                this.isPlaceOrderActionAllowed() === true\n            ) {\n                fullScreenLoader.startLoader();\n\n                this.isPlaceOrderActionAllowed(false);\n\n                $.when(\n                    this.setPaymentInformation()\n                ).done(\n                    this.done.bind(this)\n                ).fail(\n                    this.fail.bind(this)\n                ).always(\n                    function () {\n                        self.isPlaceOrderActionAllowed(true);\n                    }\n                );\n\n                this.initTimeoutHandler();\n            }\n        },\n\n        /**\n         * {Function}\n         */\n        setPaymentInformation: function () {\n            return setPaymentInformationAction(\n                this.messageContainer,\n                {\n                    method: this.getCode()\n                }\n            );\n        },\n\n        /**\n         * {Function}\n         */\n        initTimeoutHandler: function () {\n            this.timeoutId = setTimeout(\n                this.timeoutHandler.bind(this),\n                this.getTimeoutTime()\n            );\n\n            $(window).off('clearTimeout')\n                .on('clearTimeout', this.clearTimeout.bind(this));\n        },\n\n        /**\n         * {Function}\n         */\n        clearTimeout: function () {\n            clearTimeout(this.timeoutId);\n            this.fail();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        timeoutHandler: function () {\n            this.clearTimeout();\n\n            alert(\n                {\n                    content: this.getTimeoutMessage(),\n                    actions: {\n\n                        /**\n                         * {Function}\n                         */\n                        always: this.alertActionHandler.bind(this)\n                    }\n                }\n            );\n\n            this.fail();\n        },\n\n        /**\n         * {Function}\n         */\n        alertActionHandler: function () {\n            fullScreenLoader.startLoader();\n            window.location.reload();\n        },\n\n        /**\n         * {Function}\n         */\n        fail: function () {\n            fullScreenLoader.stopLoader();\n\n            return this;\n        },\n\n        /**\n         * {Function}\n         */\n        done: function () {\n            this.placeOrderHandler().fail(function () {\n                fullScreenLoader.stopLoader();\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Payment/js/view/payment/payments.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    rendererList.push(\n        {\n            type: 'free',\n            component: 'Magento_Payment/js/view/payment/method-renderer/free-method'\n        }\n    );\n\n    /** Add view logic here if needed */\n    return Component.extend({});\n});\n","Magento_Payment/js/view/payment/cc-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'underscore',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-data',\n    'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',\n    'mage/translate'\n], function (_, Component, creditCardData, cardNumberValidator, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            creditCardType: '',\n            creditCardExpYear: '',\n            creditCardExpMonth: '',\n            creditCardNumber: '',\n            creditCardSsStartMonth: '',\n            creditCardSsStartYear: '',\n            creditCardSsIssue: '',\n            creditCardVerificationNumber: '',\n            selectedCardType: null\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'creditCardType',\n                    'creditCardExpYear',\n                    'creditCardExpMonth',\n                    'creditCardNumber',\n                    'creditCardVerificationNumber',\n                    'creditCardSsStartMonth',\n                    'creditCardSsStartYear',\n                    'creditCardSsIssue',\n                    'selectedCardType'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init component\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            //Set credit card number to credit card data object\n            this.creditCardNumber.subscribe(function (value) {\n                var result;\n\n                self.selectedCardType(null);\n\n                if (value === '' || value === null) {\n                    return false;\n                }\n                result = cardNumberValidator(value);\n\n                if (!result.isPotentiallyValid && !result.isValid) {\n                    return false;\n                }\n\n                if (result.card !== null) {\n                    self.selectedCardType(result.card.type);\n                    creditCardData.creditCard = result.card;\n                }\n\n                if (result.isValid) {\n                    creditCardData.creditCardNumber = value;\n                    self.creditCardType(result.card.type);\n                }\n            });\n\n            //Set expiration year to credit card data object\n            this.creditCardExpYear.subscribe(function (value) {\n                creditCardData.expirationYear = value;\n            });\n\n            //Set expiration month to credit card data object\n            this.creditCardExpMonth.subscribe(function (value) {\n                creditCardData.expirationMonth = value;\n            });\n\n            //Set cvv code to credit card data object\n            this.creditCardVerificationNumber.subscribe(function (value) {\n                creditCardData.cvvCode = value;\n            });\n        },\n\n        /**\n         * Get code\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'cc';\n        },\n\n        /**\n         * Get data\n         * @returns {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'additional_data': {\n                    'cc_cid': this.creditCardVerificationNumber(),\n                    'cc_ss_start_month': this.creditCardSsStartMonth(),\n                    'cc_ss_start_year': this.creditCardSsStartYear(),\n                    'cc_ss_issue': this.creditCardSsIssue(),\n                    'cc_type': this.creditCardType(),\n                    'cc_exp_year': this.creditCardExpYear(),\n                    'cc_exp_month': this.creditCardExpMonth(),\n                    'cc_number': this.creditCardNumber()\n                }\n            };\n        },\n\n        /**\n         * Get list of available credit card types\n         * @returns {Object}\n         */\n        getCcAvailableTypes: function () {\n            return window.checkoutConfig.payment.ccform.availableTypes[this.getCode()];\n        },\n\n        /**\n         * Get payment icons\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        getIcons: function (type) {\n            return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                window.checkoutConfig.payment.ccform.icons[type]\n                : false;\n        },\n\n        /**\n         * Get list of months\n         * @returns {Object}\n         */\n        getCcMonths: function () {\n            return window.checkoutConfig.payment.ccform.months[this.getCode()];\n        },\n\n        /**\n         * Get list of years\n         * @returns {Object}\n         */\n        getCcYears: function () {\n            return window.checkoutConfig.payment.ccform.years[this.getCode()];\n        },\n\n        /**\n         * Check if current payment has verification\n         * @returns {Boolean}\n         */\n        hasVerification: function () {\n            return window.checkoutConfig.payment.ccform.hasVerification[this.getCode()];\n        },\n\n        /**\n         * @deprecated\n         * @returns {Boolean}\n         */\n        hasSsCardType: function () {\n            return window.checkoutConfig.payment.ccform.hasSsCardType[this.getCode()];\n        },\n\n        /**\n         * Get image url for CVV\n         * @returns {String}\n         */\n        getCvvImageUrl: function () {\n            return window.checkoutConfig.payment.ccform.cvvImageUrl[this.getCode()];\n        },\n\n        /**\n         * Get image for CVV\n         * @returns {String}\n         */\n        getCvvImageHtml: function () {\n            return '<img src=\"' + this.getCvvImageUrl() +\n                '\" alt=\"' + $t('Card Verification Number Visual Reference') +\n                '\" title=\"' + $t('Card Verification Number Visual Reference') +\n                '\" />';\n        },\n\n        /**\n         * Get unsanitized html for image for CVV\n         * @returns {String}\n         */\n        getCvvImageUnsanitizedHtml: function () {\n            return this.getCvvImageHtml();\n        },\n\n        /**\n         * @deprecated\n         * @returns {Object}\n         */\n        getSsStartYears: function () {\n            return window.checkoutConfig.payment.ccform.ssStartYears[this.getCode()];\n        },\n\n        /**\n         * Get list of available credit card types values\n         * @returns {Object}\n         */\n        getCcAvailableTypesValues: function () {\n            return _.map(this.getCcAvailableTypes(), function (value, key) {\n                return {\n                    'value': key,\n                    'type': value\n                };\n            });\n        },\n\n        /**\n         * Get list of available month values\n         * @returns {Object}\n         */\n        getCcMonthsValues: function () {\n            return _.map(this.getCcMonths(), function (value, key) {\n                return {\n                    'value': key,\n                    'month': value\n                };\n            });\n        },\n\n        /**\n         * Get list of available year values\n         * @returns {Object}\n         */\n        getCcYearsValues: function () {\n            return _.map(this.getCcYears(), function (value, key) {\n                return {\n                    'value': key,\n                    'year': value\n                };\n            });\n        },\n\n        /**\n         * @deprecated\n         * @returns {Object}\n         */\n        getSsStartYearsValues: function () {\n            return _.map(this.getSsStartYears(), function (value, key) {\n                return {\n                    'value': key,\n                    'year': value\n                };\n            });\n        },\n\n        /**\n         * Is legend available to display\n         * @returns {Boolean}\n         */\n        isShowLegend: function () {\n            return false;\n        },\n\n        /**\n         * Get available credit card type by code\n         * @param {String} code\n         * @returns {String}\n         */\n        getCcTypeTitleByCode: function (code) {\n            var title = '',\n                keyValue = 'value',\n                keyType = 'type';\n\n            _.each(this.getCcAvailableTypesValues(), function (value) {\n                if (value[keyValue] === code) {\n                    title = value[keyType];\n                }\n            });\n\n            return title;\n        },\n\n        /**\n         * Prepare credit card number to output\n         * @param {String} number\n         * @returns {String}\n         */\n        formatDisplayCcNumber: function (number) {\n            return 'xxxx-' + number.substr(-4);\n        },\n\n        /**\n         * Get credit card details\n         * @returns {Array}\n         */\n        getInfo: function () {\n            return [\n                {\n                    'name': 'Credit Card Type', value: this.getCcTypeTitleByCode(this.creditCardType())\n                },\n                {\n                    'name': 'Credit Card Number', value: this.formatDisplayCcNumber(this.creditCardNumber())\n                }\n            ];\n        }\n    });\n});\n","Magento_Payment/js/view/payment/method-renderer/free-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* @api */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Payment/payment/free'\n        },\n\n        /** Returns is method available */\n        isAvailable: function () {\n            return quote.totals()['grand_total'] <= 0;\n        }\n    });\n});\n","Magento_InstantPurchase/js/view/instant-purchase.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'mage/url',\n    'mage/template',\n    'mage/translate',\n    'text!Magento_InstantPurchase/template/confirmation.html',\n    'mage/validation'\n], function (ko, $, _, Component, confirm, customerData, urlBuilder, mageTemplate, $t, confirmationTemplate) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_InstantPurchase/instant-purchase',\n            buttonText: $t('Instant Purchase'),\n            purchaseUrl: urlBuilder.build('instantpurchase/button/placeOrder'),\n            showButton: false,\n            paymentToken: null,\n            shippingAddress: null,\n            billingAddress: null,\n            shippingMethod: null,\n            productFormSelector: '#product_addtocart_form',\n            confirmationTitle: $t('Instant Purchase Confirmation'),\n            confirmationData: {\n                message: $t('Are you sure you want to place order and pay?'),\n                shippingAddressTitle: $t('Shipping Address'),\n                billingAddressTitle: $t('Billing Address'),\n                paymentMethodTitle: $t('Payment Method'),\n                shippingMethodTitle: $t('Shipping Method')\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var instantPurchase = customerData.get('instant-purchase');\n\n            this._super();\n\n            this.setPurchaseData(instantPurchase());\n            instantPurchase.subscribe(this.setPurchaseData, this);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('showButton paymentToken shippingAddress billingAddress shippingMethod');\n\n            return this;\n        },\n\n        /**\n         * Set data from customerData.\n         *\n         * @param {Object} data\n         */\n        setPurchaseData: function (data) {\n            this.showButton(data.available);\n            this.paymentToken(data.paymentToken);\n            this.shippingAddress(data.shippingAddress);\n            this.billingAddress(data.billingAddress);\n            this.shippingMethod(data.shippingMethod);\n        },\n\n        /**\n         * Confirmation method\n         */\n        instantPurchase: function () {\n            var form = $(this.productFormSelector),\n                confirmTemplate = mageTemplate(confirmationTemplate),\n                confirmData = _.extend({}, this.confirmationData, {\n                    paymentToken: this.paymentToken().summary,\n                    shippingAddress: this.shippingAddress().summary,\n                    billingAddress: this.billingAddress().summary,\n                    shippingMethod: this.shippingMethod().summary\n                });\n\n            if (!(form.validation() && form.validation('isValid'))) {\n                return;\n            }\n\n            confirm({\n                title: this.confirmationTitle,\n                content: confirmTemplate({\n                    data: confirmData\n                }),\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        $.ajax({\n                            url: this.purchaseUrl,\n                            data: form.serialize(),\n                            type: 'post',\n                            dataType: 'json',\n\n                            /** Show loader before send */\n                            beforeSend: function () {\n                                $('body').trigger('processStart');\n                            }\n                        }).always(function () {\n                            $('body').trigger('processStop');\n                        });\n                    }.bind(this)\n                }\n            });\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/manage-coupon-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, uiRegistry, fieldset, async) {\n    'use strict';\n\n    return fieldset.extend({\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Initialize element\n         *\n         * @returns {Abstract} Chainable\n         */\n        initialize: function (elems, position) {\n            var obj = this;\n\n            this._super();\n\n            async.async('#sales-rule-form-tab-coupons', document.getElementById('container'), function (node) {\n                var useAutoGeneration = uiRegistry.get(\n                    'sales_rule_form.sales_rule_form.rule_information.use_auto_generation'\n                );\n\n                useAutoGeneration.on('checked', function () {\n                    obj.enableDisableFields();\n                });\n                obj.enableDisableFields();\n            });\n\n            return this;\n        },\n\n        /*eslint-enable no-unused-vars*/\n        /*eslint-disable lines-around-comment*/\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            /**\n             * \\Magento\\Rule\\Model\\AbstractModel::COUPON_TYPE_AUTO\n             */\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/coupon-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select'\n], function (_, uiRegistry, select) {\n    'use strict';\n\n    return select.extend({\n\n        /**\n         * Hide fields on coupon tab\n         */\n        onUpdate: function () {\n\n            /* eslint-disable eqeqeq */\n            if (this.value() != this.displayOnlyForCouponType) {\n                uiRegistry.get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation').checked(false);\n            }\n\n            this.enableDisableFields();\n        },\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/action/cancel-coupon.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_SalesRule/js/model/payment/discount-messages',\n    'mage/storage',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/totals',\n    'mage/translate',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/recollect-shipping-rates'\n], function ($, quote, urlManager, errorProcessor, messageContainer, storage, getPaymentInformationAction, totals, $t,\n  fullScreenLoader, recollectShippingRates\n) {\n    'use strict';\n\n    var successCallbacks = [],\n        action,\n        callSuccessCallbacks;\n\n    /**\n     * Execute callbacks when a coupon is successfully canceled.\n     */\n    callSuccessCallbacks = function () {\n        successCallbacks.forEach(function (callback) {\n            callback();\n        });\n    };\n\n    /**\n     * Cancel applied coupon.\n     *\n     * @param {Boolean} isApplied\n     * @returns {Deferred}\n     */\n    action =  function (isApplied) {\n        var quoteId = quote.getQuoteId(),\n            url = urlManager.getCancelCouponUrl(quoteId),\n            message = $t('Your coupon was successfully removed.');\n\n        messageContainer.clear();\n        fullScreenLoader.startLoader();\n\n        return storage.delete(\n            url,\n            false\n        ).done(function () {\n            var deferred = $.Deferred();\n\n            totals.isLoading(true);\n            recollectShippingRates();\n            getPaymentInformationAction(deferred);\n            $.when(deferred).done(function () {\n                isApplied(false);\n                totals.isLoading(false);\n                fullScreenLoader.stopLoader();\n                //Allowing to tap into coupon-cancel process.\n                callSuccessCallbacks();\n            });\n            messageContainer.addSuccessMessage({\n                'message': message\n            });\n        }).fail(function (response) {\n            totals.isLoading(false);\n            fullScreenLoader.stopLoader();\n            errorProcessor.process(response, messageContainer);\n        });\n    };\n\n    /**\n     * Callback for when the cancel-coupon process is finished.\n     *\n     * @param {Function} callback\n     */\n    action.registerSuccessCallback = function (callback) {\n        successCallbacks.push(callback);\n    };\n\n    return action;\n});\n","Magento_SalesRule/js/action/select-payment-method-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/model/payment/discount-messages',\n    'Magento_Checkout/js/action/set-payment-information-extended',\n    'Magento_Checkout/js/action/get-totals',\n    'Magento_SalesRule/js/model/coupon'\n], function ($, wrapper, quote, messageContainer, setPaymentInformationExtended, getTotalsAction, coupon) {\n    'use strict';\n\n    return function (selectPaymentMethodAction) {\n\n        return wrapper.wrap(selectPaymentMethodAction, function (originalSelectPaymentMethodAction, paymentMethod) {\n\n            originalSelectPaymentMethodAction(paymentMethod);\n\n            if (paymentMethod === null) {\n                return;\n            }\n\n            $.when(\n                setPaymentInformationExtended(\n                    messageContainer,\n                    {\n                        method: paymentMethod.method\n                    },\n                    true\n                )\n            ).done(\n                function () {\n                    var deferred = $.Deferred(),\n\n                        /**\n                         * Update coupon form.\n                         */\n                        updateCouponCallback = function () {\n                            if (quote.totals() && !quote.totals()['coupon_code']) {\n                                coupon.setCouponCode('');\n                                coupon.setIsApplied(false);\n                            }\n                        };\n\n                    getTotalsAction([], deferred);\n                    $.when(deferred).done(updateCouponCallback);\n                }\n            );\n        });\n    };\n\n});\n","Magento_SalesRule/js/action/set-coupon-code.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Customer store credit(balance) application\n */\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_SalesRule/js/model/payment/discount-messages',\n    'mage/storage',\n    'mage/translate',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/recollect-shipping-rates'\n], function (ko, $, quote, urlManager, errorProcessor, messageContainer, storage, $t, getPaymentInformationAction,\n    totals, fullScreenLoader, recollectShippingRates\n) {\n    'use strict';\n\n    var dataModifiers = [],\n        successCallbacks = [],\n        failCallbacks = [],\n        action;\n\n    /**\n     * Apply provided coupon.\n     *\n     * @param {String} couponCode\n     * @param {Boolean}isApplied\n     * @returns {Deferred}\n     */\n    action = function (couponCode, isApplied) {\n        var quoteId = quote.getQuoteId(),\n            url = urlManager.getApplyCouponUrl(couponCode, quoteId),\n            message = $t('Your coupon was successfully applied.'),\n            data = {},\n            headers = {};\n\n        //Allowing to modify coupon-apply request\n        dataModifiers.forEach(function (modifier) {\n            modifier(headers, data);\n        });\n        fullScreenLoader.startLoader();\n\n        return storage.put(\n            url,\n            data,\n            false,\n            null,\n            headers\n        ).done(function (response) {\n            var deferred;\n\n            if (response) {\n                deferred = $.Deferred();\n\n                isApplied(true);\n                totals.isLoading(true);\n                recollectShippingRates();\n                getPaymentInformationAction(deferred);\n                $.when(deferred).done(function () {\n                    fullScreenLoader.stopLoader();\n                    totals.isLoading(false);\n                });\n                messageContainer.addSuccessMessage({\n                    'message': message\n                });\n                //Allowing to tap into apply-coupon process.\n                successCallbacks.forEach(function (callback) {\n                    callback(response);\n                });\n            }\n        }).fail(function (response) {\n            fullScreenLoader.stopLoader();\n            totals.isLoading(false);\n            errorProcessor.process(response, messageContainer);\n            //Allowing to tap into apply-coupon process.\n            failCallbacks.forEach(function (callback) {\n                callback(response);\n            });\n        });\n    };\n\n    /**\n     * Modifying data to be sent.\n     *\n     * @param {Function} modifier\n     */\n    action.registerDataModifier = function (modifier) {\n        dataModifiers.push(modifier);\n    };\n\n    /**\n     * When successfully added a coupon.\n     *\n     * @param {Function} callback\n     */\n    action.registerSuccessCallback = function (callback) {\n        successCallbacks.push(callback);\n    };\n\n    /**\n     * When failed to add a coupon.\n     *\n     * @param {Function} callback\n     */\n    action.registerFailCallback = function (callback) {\n        failCallbacks.push(callback);\n    };\n\n    return action;\n});\n","Magento_SalesRule/js/model/coupon.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * Coupon model.\n */\ndefine([\n    'ko',\n    'domReady!'\n], function (ko) {\n    'use strict';\n\n    var couponCode = ko.observable(null),\n        isApplied = ko.observable(null);\n\n    return {\n        couponCode: couponCode,\n        isApplied: isApplied,\n\n        /**\n         * @return {*}\n         */\n        getCouponCode: function () {\n            return couponCode;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        getIsApplied: function () {\n            return isApplied;\n        },\n\n        /**\n         * @param {*} couponCodeValue\n         */\n        setCouponCode: function (couponCodeValue) {\n            couponCode(couponCodeValue);\n        },\n\n        /**\n         * @param {Boolean} isAppliedValue\n         */\n        setIsApplied: function (isAppliedValue) {\n            isApplied(isAppliedValue);\n        }\n    };\n});\n","Magento_SalesRule/js/model/place-order-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/model/coupon',\n    'Magento_Checkout/js/action/get-totals'\n], function ($, wrapper, quote, coupon, getTotalsAction) {\n    'use strict';\n\n    return function (placeOrderAction) {\n        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, messageContainer) {\n            var result;\n\n            $.when(\n                result = originalAction(paymentData, messageContainer)\n            ).fail(\n                function () {\n                    var deferred = $.Deferred(),\n\n                        /**\n                         * Update coupon form\n                         */\n                        updateCouponCallback = function () {\n                            if (quote.totals() && !quote.totals()['coupon_code']) {\n                                coupon.setCouponCode('');\n                                coupon.setIsApplied(false);\n                            }\n                        };\n\n                    getTotalsAction([], deferred);\n                    $.when(deferred).done(updateCouponCallback);\n                }\n            );\n\n            return result;\n        });\n    };\n});\n","Magento_SalesRule/js/model/shipping-save-processor-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/utils/wrapper',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/model/coupon'\n], function (wrapper, quote, coupon) {\n    'use strict';\n\n    return function (shippingSaveProcessor) {\n        shippingSaveProcessor.saveShippingInformation = wrapper.wrapSuper(\n            shippingSaveProcessor.saveShippingInformation,\n            function (type) {\n                var updateCouponCallback;\n\n                /**\n                 * Update coupon form\n                 */\n                updateCouponCallback = function () {\n                    if (quote.totals() && !quote.totals()['coupon_code']) {\n                        coupon.setCouponCode('');\n                        coupon.setIsApplied(false);\n                    }\n                };\n\n                return this._super(type).done(updateCouponCallback);\n            }\n        );\n\n        return shippingSaveProcessor;\n    };\n});\n","Magento_SalesRule/js/model/payment/discount-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/model/messages'\n], function (Messages) {\n    'use strict';\n\n    return new Messages();\n});\n","Magento_SalesRule/js/view/payment/discount-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/view/messages',\n    '../../model/payment/discount-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_SalesRule/js/view/payment/captcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'Magento_Captcha/js/view/checkout/defaultCaptcha',\n        'Magento_Captcha/js/model/captchaList',\n        'Magento_SalesRule/js/action/set-coupon-code',\n        'Magento_SalesRule/js/action/cancel-coupon',\n        'Magento_Checkout/js/model/quote',\n        'ko'\n    ],\n    function (defaultCaptcha, captchaList, setCouponCodeAction, cancelCouponAction, quote, ko) {\n        'use strict';\n\n        var totals = quote.getTotals(),\n            couponCode = ko.observable(null),\n            isApplied;\n\n        if (totals()) {\n            couponCode(totals()['coupon_code']);\n        }\n        //Captcha can only be required for adding a coupon so we need to know if one was added already.\n        isApplied = ko.observable(couponCode() != null);\n\n        return defaultCaptcha.extend({\n            /** @inheritdoc */\n            initialize: function () {\n                var self = this,\n                    currentCaptcha;\n\n                this._super();\n                //Getting coupon captcha model.\n                currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n                if (currentCaptcha != null) {\n                    if (!isApplied()) {\n                        //Show captcha if we don't have a coupon applied.\n                        currentCaptcha.setIsVisible(true);\n                    }\n                    this.setCurrentCaptcha(currentCaptcha);\n                    //Add captcha code to coupon-apply request.\n                    setCouponCodeAction.registerDataModifier(function (headers) {\n                        if (self.isRequired()) {\n                            headers['X-Captcha'] = self.captchaValue()();\n                        }\n                    });\n                    //Refresh captcha after failed request.\n                    setCouponCodeAction.registerFailCallback(function () {\n                        if (self.isRequired()) {\n                            self.refresh();\n                        }\n                    });\n                    //Hide captcha when a coupon has been applied.\n                    setCouponCodeAction.registerSuccessCallback(function () {\n                        self.setIsVisible(false);\n                    });\n                    //Show captcha again if it was canceled.\n                    cancelCouponAction.registerSuccessCallback(function () {\n                        if (self.isRequired()) {\n                            self.setIsVisible(true);\n                        }\n                    });\n                }\n            }\n        });\n    });\n","Magento_SalesRule/js/view/payment/discount.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_SalesRule/js/action/set-coupon-code',\n    'Magento_SalesRule/js/action/cancel-coupon',\n    'Magento_SalesRule/js/model/coupon'\n], function ($, ko, Component, quote, setCouponCodeAction, cancelCouponAction, coupon) {\n    'use strict';\n\n    var totals = quote.getTotals(),\n        couponCode = coupon.getCouponCode(),\n        isApplied = coupon.getIsApplied();\n\n    if (totals()) {\n        couponCode(totals()['coupon_code']);\n    }\n    isApplied(couponCode() != null);\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_SalesRule/payment/discount'\n        },\n        couponCode: couponCode,\n\n        /**\n         * Applied flag\n         */\n        isApplied: isApplied,\n\n        /**\n         * Coupon code application procedure\n         */\n        apply: function () {\n            if (this.validate()) {\n                setCouponCodeAction(couponCode(), isApplied);\n            }\n        },\n\n        /**\n         * Cancel using coupon\n         */\n        cancel: function () {\n            if (this.validate()) {\n                couponCode('');\n                cancelCouponAction(isApplied);\n            }\n        },\n\n        /**\n         * Coupon form validation\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            let form = '#discount-form';\n\n            $(form + ' input[type=\"text\"]').each(function () {\n                let currentValue = $(this).val();\n\n                $(this).val(currentValue.trim());\n            });\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n});\n","Magento_SalesRule/js/view/cart/totals/discount.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_SalesRule/js/view/summary/discount'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_SalesRule/cart/totals/discount'\n        },\n\n        /**\n         * @override\n         *\n         * @returns {Boolean}\n         */\n        isDisplayed: function () {\n            return this.getPureValue() != 0; //eslint-disable-line eqeqeq\n        }\n    });\n});\n","Magento_SalesRule/js/view/summary/discount.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_SalesRule/summary/discount'\n        },\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*|Boolean}\n         */\n        isDisplayed: function () {\n            return this.isFullMode() && this.getPureValue() != 0; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*}\n         */\n        getCouponCode: function () {\n            if (!this.totals()) {\n                return null;\n            }\n\n            return this.totals()['coupon_code'];\n        },\n\n        /**\n         * @return {*}\n         */\n        getCouponLabel: function () {\n            if (!this.totals()) {\n                return null;\n            }\n\n            return this.totals()['coupon_label'];\n        },\n\n        /**\n         * Get discount title\n         *\n         * @returns {null|String}\n         */\n        getTitle: function () {\n            var discountSegments;\n\n            if (!this.totals()) {\n                return null;\n            }\n\n            discountSegments = this.totals()['total_segments'].filter(function (segment) {\n                return segment.code.indexOf('discount') !== -1;\n            });\n\n            return discountSegments.length ? discountSegments[0].title : null;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            var price = 0;\n\n            if (this.totals() && this.totals()['discount_amount']) {\n                price = parseFloat(this.totals()['discount_amount']);\n            }\n\n            return price;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Smile_ElasticsuiteTracker/js/user-consent.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteTracker\n * @author    Aurelien FOUCRET <aurelien.foucret@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\ndefine(['jquery', 'mage/cookies'], function ($) {\n    return function(config) {\n        return config.cookieRestrictionEnabled == false || $.mage.cookies.get(config.cookieRestrictionName) !== null;\n    };\n});\n","Smile_ElasticsuiteTracker/js/tracking.js":"/* global document: true */\n/* global window: true */\n/* global console: true */\n/* exported smileTracker */\n\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteTracker\n * @author    Aurelien FOUCRET <aurelien.foucret@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\nconst smileTracker = (function () {\n\n    \"use strict\";\n\n    const guid = (function() {\n        function s4() {\n            return Math.floor((1 + Math.random()) * 0x10000)\n                .toString(16)\n                .substring(1);\n        }\n        return function() {\n            return s4() + s4() + '-' + s4() + '-' + s4() + '-' +\n                s4() + '-' + s4() + s4() + s4();\n        };\n    }());\n\n    function getCookie(cookieName) {\n        const name = cookieName + \"=\";\n        const ca = document.cookie.split(';');\n        for (let i = 0; i < ca.length; i++) {\n            let c = ca[i];\n            while (c.charAt(0) === ' ') {\n                c = c.substring(1);\n            }\n            if (c.indexOf(name) !== -1) {\n                return c.substring(name.length, c.length);\n            }\n        }\n        return null;\n    }\n\n    function setCookie(cookieName, cookieValue, expiresAt, path) {\n        const expires = \"expires=\" + expiresAt.toUTCString();\n        document.cookie = cookieName + \"=\" + cookieValue + \"; \" + expires + \"; path=\" + path;\n    }\n\n    // Retrieve values for a param into URL\n    function getQueryStringParameterByName(name) {\n        let results = null;\n\n        if (name && name.replace) {\n            name = name.replace(/[\\[]/, \"\\\\[\").replace(/[\\]]/, \"\\\\]\");\n            const regex = new RegExp(\"[\\\\?&]\" + name + \"=([^&#]*)\");\n            results = regex.exec(window.location.search);\n        }\n\n        return results === null ? \"\" : decodeURIComponent(results[1].replace(/\\+/g, \" \"));\n    }\n\n    // Add page title and page URL to the tracked variables\n    function addStandardPageVars() {\n        // Website base url tracking (eg. mydomain.com)\n        this.addPageVar(\"site\", window.location.hostname);\n\n        // Page URL tracking (eg. home.html)\n        this.addPageVar(\"url\", window.location.pathname);\n\n        // Page title tracking\n        this.addPageVar(\"title\", document.title);\n    }\n\n    // Append GA campaign variable to the tracked variables\n    // Following URL variables are used :\n    // - utm_source\n    // - utm_campaign\n    // - utm_medium\n    function addCampaignVars() {\n        // GA variables to be fetched from URI\n        const urlParams = ['utm_source', 'utm_campaign', 'utm_medium', 'utm_term'];\n\n        urlParams.forEach(function (element) {\n            const paramName = element;\n            const paramValue = getQueryStringParameterByName(paramName);\n            if (paramValue) {\n                // Append the GA param to the tracker\n                this.addPageVar(paramName, paramValue);\n            }\n        }.bind(this));\n    }\n\n    function addReferrerVars() {\n        if (document.referrer) {\n            let parser = document.createElement('a');\n            parser.href = document.referrer;\n            this.addPageVar('referrer.domain', parser.hostname);\n            this.addPageVar('referrer.page', parser.pathname);\n        }\n    }\n\n    function addResolutionVars() {\n        this.addPageVar('resolution.x', window.screen.availWidth);\n        this.addPageVar('resolution.y', window.screen.availHeight);\n        return this;\n    }\n\n    function addCustomerVars(customerData) {\n        getCustomerDataCodeToTrack().forEach(function (customerDataCode) {\n            if (customerData.hasOwnProperty('tracking') && customerData.tracking.hasOwnProperty(customerDataCode)) {\n                this.addCustomerVar(customerDataCode, customerData.tracking[customerDataCode]);\n            }\n        }.bind(this));\n    }\n\n    function addMetaPageVars() {\n        const metaTags = document.getElementsByTagName('meta');\n        for (let tagIndex = 0; tagIndex < metaTags.length; tagIndex++) {\n            if (metaTags[tagIndex].getAttribute('name')) {\n                let components = metaTags[tagIndex].getAttribute('name').split(':');\n                if (components.length === 2 && components[0] === 'sct') {\n                    let varName = components[1];\n                    this.addPageVar(varName, metaTags[tagIndex].getAttribute('content'));\n                }\n            }\n        }\n    }\n\n    function getTrackerVars() {\n        if (this.trackerVarsAdded === false) {\n            addStandardPageVars.bind(this)();\n            addReferrerVars.bind(this)();\n            addCampaignVars.bind(this)();\n            addMetaPageVars.bind(this)();\n            addResolutionVars.bind(this)();\n            this.trackerVarsAdded = true;\n        }\n\n        let urlParams = [];\n\n        for (let currentVar in this.vars) {\n            if ({}.hasOwnProperty.call(this.vars, currentVar)) {\n                urlParams.push(currentVar + \"=\" + this.vars[currentVar]);\n            }\n        }\n\n        return urlParams;\n    }\n\n    function getTrackerPostVars() {\n        if (this.trackerVarsAdded === false) {\n            addStandardPageVars.bind(this)();\n            addReferrerVars.bind(this)();\n            addCampaignVars.bind(this)();\n            addMetaPageVars.bind(this)();\n            addResolutionVars.bind(this)();\n            this.trackerVarsAdded = true;\n        }\n\n        Object.keys(this.vars).forEach(key => {\n            this.vars[key] = decodeURIComponent(this.vars[key]);\n        });\n\n        return bracketVarsToJson(this.vars);\n    }\n\n    function getTrackerUrl() {\n        let urlParams = getTrackerVars.bind(this)();\n        return this.baseUrl + \"?\" + urlParams.join('&');\n    }\n\n    function getCustomerDataCodeToTrack() {\n        return ['age', 'gender', 'zipcode', 'state', 'country'];\n    }\n\n    function setTrackerStyle(imgNode) {\n        imgNode.setAttribute('style', 'position: absolute; top: 0; left: 0; visibility: hidden;');\n    }\n\n    // Send the tag to the remote server\n    // Append a transparent pixel to the body\n    function sendTag(forceCollect = false) {\n        initSession.bind(this)();\n\n        if (this.config && this.config.hasOwnProperty('storeId')) {\n            addPageVar.bind(this)('store_id', this.config.storeId);\n        }\n\n        if (this.trackerSent === false || forceCollect === true) {\n            if (this.endpointUrl) {\n                const eventData = {'eventData': getTrackerPostVars.bind(this)()};\n                let request = new XMLHttpRequest();\n                request.open('POST', this.endpointUrl, true);\n                request.setRequestHeader('Content-Type', 'application/json');\n                request.send(JSON.stringify(eventData));\n            } else {\n                const bodyNode = document.getElementsByTagName('body')[0];\n                buildTrackingImg.bind(this)(bodyNode, getTrackerUrl.bind(this)());\n            }\n            this.trackerSent = true;\n            this.vars = {};\n        }\n    }\n\n    function sendTelemetry() {\n        initSession.bind(this)();\n        initCustomerData.bind(this)();\n        getTrackerVars.bind(this);\n\n        const vars = bracketVarsToJson(this.vars);\n\n        if (this.telemetryEnabled && this.telemetryTrackerSent === false) {\n            let request = new XMLHttpRequest();\n            request.open('POST', this.telemetryUrl, true);\n            request.setRequestHeader('Content-Type', 'application/json');\n            request.send(JSON.stringify(vars));\n\n            this.telemetryTrackerSent = true;\n        }\n    }\n\n    function bracketVarsToJson(vars) {\n        let result = {};\n\n        for (const i in vars) {\n            let a = i.match(/([^\\[\\]]+)(\\[[^\\[\\]]+[^\\]])*?/g),\n                p = vars[i];\n            let j = a.length;\n            while (j--) {\n                let q = {};\n                q[a[j]] = p;\n                p = q;\n            }\n\n            let k = Object.keys(p)[0],\n                o = result;\n\n            while (k in o) {\n                p = p[k];\n                o = o[k];\n                k = Object.keys(p)[0];\n            }\n\n            o[k] = p[k];\n        }\n\n        return result;\n    }\n\n    function buildTrackingImg(bodyNode, trackingUrl) {\n        let imgNode = document.createElement('img');\n        imgNode.setAttribute('src', trackingUrl);\n        imgNode.setAttribute('alt', '');\n        setTrackerStyle(imgNode);\n        bodyNode.appendChild(imgNode);\n    }\n\n    // Append a variable to the page\n    function addVariable(varName, value) {\n        this.vars[varName] = encodeURIComponent(value);\n        return this;\n    }\n\n    function addSessionVar(varName, value) {\n        addVariable.bind(this)(transformVarName.bind(this)(varName, 'session'), value);\n    }\n\n    function addPageVar(varName, value) {\n        addVariable.bind(this)(transformVarName.bind(this)(varName , 'page'), value);\n    }\n\n    function addCustomerVar(varName, value) {\n        addVariable.bind(this)(transformVarName.bind(this)(varName , 'customer'), value);\n    }\n\n    function transformVarName(varName, prefix) {\n        return prefix + \"[\" + varName.replace(/[.]/g, \"][\") + \"]\";\n    }\n\n    function initSession() {\n        if (this.config && this.config.hasOwnProperty('sessionConfig')) {\n            const config   = this.config.sessionConfig;\n            const expireAt = new Date();\n            const path     = config['path'] || '/';\n\n            if (!this.sessionInitialized) {\n                if (getCookie(config['visit_cookie_name']) === null) {\n                    expireAt.setSeconds(expireAt.getSeconds() + parseInt(config['visit_cookie_lifetime'], 10));\n                    setCookie(config['visit_cookie_name'], guid(), expireAt, path);\n                } else {\n                    expireAt.setSeconds(expireAt.getSeconds() + parseInt(config['visit_cookie_lifetime'], 10));\n                    setCookie(config['visit_cookie_name'], getCookie(config['visit_cookie_name']), expireAt, path);\n                }\n\n                if (getCookie(config['visitor_cookie_name']) === null) {\n                    expireAt.setDate(expireAt.getDate() + parseInt(config['visitor_cookie_lifetime'], 10));\n                    setCookie(config['visitor_cookie_name'], guid(), expireAt, path);\n                }\n                this.sessionInitialized = true;\n            }\n\n            addSessionVar.bind(this)('uid', getCookie(config['visit_cookie_name']));\n            addSessionVar.bind(this)('vid', getCookie(config['visitor_cookie_name']));\n        }\n    }\n\n    function initCustomerData() {\n        try {\n            let mageStorage = localStorage.getItem('mage-cache-storage');\n            if (mageStorage !== null) {\n                mageStorage = JSON.parse(mageStorage);\n                if ((mageStorage.customer !== undefined)) {\n                    addCustomerVars.bind(this)(mageStorage.customer);\n                }\n            }\n        } catch (e) {\n            // Nothing.\n        }\n    }\n\n    // Implementation of the tracker\n    const SmileTrackerImpl = function() {\n        this.vars = {};\n        this.trackerSent = false;\n        this.telemetryTrackerSent = false;\n        this.trackerVarsAdded = false;\n        this.sessionInitialized = false;\n        this.customerData = {};\n    };\n\n    SmileTrackerImpl.prototype.sendTag = function (forceCollect = false) {\n        if (document.readyState !== 'loading') {\n            sendTag.bind(this)(forceCollect);\n            sendTelemetry.bind(this)();\n        } else {\n            document.addEventListener('DOMContentLoaded', function () {\n                sendTag.bind(this)(forceCollect);\n                sendTelemetry.bind(this)();\n            }.bind(this));\n        }\n    };\n\n    SmileTrackerImpl.prototype.setConfig = function (config) {\n        this.config           = config;\n        this.baseUrl          = config.beaconUrl;\n        this.endpointUrl      = false;\n        if (config.hasOwnProperty('endpointUrl') && (config.endpointUrl.length !== 0)) {\n            this.endpointUrl = config.endpointUrl;\n        }\n        this.telemetryEnabled = config.telemetryEnabled;\n        this.telemetryUrl     = config.telemetryUrl;\n\n\n    };\n\n    SmileTrackerImpl.prototype.addPageVar = function (varName, value) {\n        addPageVar.bind(this)(varName, value);\n    };\n\n    SmileTrackerImpl.prototype.addCustomerVar = function (varName, value) {\n        addCustomerVar.bind(this)(varName, value);\n    };\n\n    SmileTrackerImpl.prototype.addSessionVar = function (varName, value) {\n        addSessionVar.bind(this)(varName, value);\n    };\n\n    return new SmileTrackerImpl();\n}());\n","Magento_Usps/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig;\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var rules = validationRules.getRules(),\n                self = this;\n\n            $.each(rules, function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            if (!this.validationErrors.length) {\n                if (address['country_id'] == checkoutConfig.originCountryCode) { //eslint-disable-line eqeqeq\n                    return !utils.isEmpty(address.postcode);\n                }\n\n                return true;\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Usps/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                },\n                'postcode': {\n                    'required': false\n                }\n            };\n        }\n    };\n});\n","Magento_Usps/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../model/shipping-rates-validator',\n    '../model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    uspsShippingRatesValidator,\n    uspsShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('usps', uspsShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('usps', uspsShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validator/freeshipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    '../shipping-rates-validation-rules/freeshipping',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validator/flatrate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    '../shipping-rates-validation-rules/flatrate',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validator/tablerate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    '../shipping-rates-validation-rules/tablerate',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message, regionFields;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    regionFields = ['region', 'region_id', 'region_id_input'];\n\n                    if (\n                        $.inArray(field, regionFields) === -1 ||\n                        utils.isEmpty(address.region) && utils.isEmpty(address['region_id'])\n                    ) {\n                        self.validationErrors.push(message);\n                    }\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validation-rules/freeshipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validation-rules/flatrate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_OfflineShipping/js/model/shipping-rates-validation-rules/tablerate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'postcode': {\n                    'required': true\n                },\n                'country_id': {\n                    'required': true\n                },\n                'region_id': {\n                    'required': true\n                },\n                'region_id_input': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_OfflineShipping/js/view/shipping-rates-validation/freeshipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../../model/shipping-rates-validator/freeshipping',\n    '../../model/shipping-rates-validation-rules/freeshipping'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    freeshippingShippingRatesValidator,\n    freeshippingShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('freeshipping', freeshippingShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('freeshipping', freeshippingShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_OfflineShipping/js/view/shipping-rates-validation/flatrate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../../model/shipping-rates-validator/flatrate',\n    '../../model/shipping-rates-validation-rules/flatrate'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    flatrateShippingRatesValidator,\n    flatrateShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('flatrate', flatrateShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('flatrate', flatrateShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_OfflineShipping/js/view/shipping-rates-validation/tablerate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    '../../model/shipping-rates-validator/tablerate',\n    '../../model/shipping-rates-validation-rules/tablerate'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    tablerateShippingRatesValidator,\n    tablerateShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('tablerate', tablerateShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('tablerate', tablerateShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_ProductVideo/js/fotorama-add-video-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'catalogGallery',\n    'loadPlayer'\n], function ($) {\n    'use strict';\n\n    /**\n     * @private\n     */\n    var allowBase = true; //global var is needed because fotorama always fully reloads events in case of fullscreen\n\n    /**\n     * @private\n     */\n    function parseHref(href) {\n        var a = document.createElement('a');\n\n        a.href = href;\n\n        return a;\n    }\n\n    /**\n     * @private\n     */\n    function parseURL(href, forceVideo) {\n        var id,\n            type,\n            ampersandPosition,\n            vimeoRegex,\n            useYoutubeNocookie = false;\n\n        /**\n         * Get youtube ID\n         * @param {String} srcid\n         * @returns {{}}\n         */\n        function _getYoutubeId(srcid) {\n            if (srcid) {\n                ampersandPosition = srcid.indexOf('&');\n\n                if (ampersandPosition === -1) {\n                    return srcid;\n                }\n\n                srcid = srcid.substring(0, ampersandPosition);\n            }\n\n            return srcid;\n        }\n\n        if (typeof href !== 'string') {\n            return href;\n        }\n\n        href = parseHref(href);\n\n        if (href.host.match(/youtube\\.com/) && href.search) {\n            id = href.search.split('v=')[1];\n\n            if (id) {\n                id = _getYoutubeId(id);\n                type = 'youtube';\n            }\n        } else if (href.host.match(/youtube\\.com|youtu\\.be|youtube-nocookie.com/)) {\n            id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n            type = 'youtube';\n\n            if (href.host.match(/youtube-nocookie.com/)) {\n                useYoutubeNocookie = true;\n            }\n        } else if (href.host.match(/vimeo\\.com/)) {\n            type = 'vimeo';\n            vimeoRegex = new RegExp(['https?:\\\\/\\\\/(?:www\\\\.|player\\\\.)?vimeo.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)',\n                '?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|album\\\\/(\\\\d+)\\\\/video\\\\/|video\\\\/|)(\\\\d+)(?:$|\\\\/|\\\\?)'\n            ].join(''));\n            id = href.href.match(vimeoRegex)[3];\n        }\n\n        if ((!id || !type) && forceVideo) {\n            id = href.href;\n            type = 'custom';\n        }\n\n        return id ? {\n            id: id, type: type, s: href.search.replace(/^\\?/, ''), useYoutubeNocookie: useYoutubeNocookie\n        } : false;\n    }\n\n    //create AddFotoramaVideoEvents widget\n    $.widget('mage.AddFotoramaVideoEvents', {\n        options: {\n            videoData: '',\n            videoSettings: '',\n            optionsVideoData: '',\n            dataMergeStrategy: 'replace'\n        },\n\n        /**\n         * @private\n         */\n        onVimeoJSFramework: function () {},\n        defaultVideoData: [],\n        PV: 'product-video', // [CONST]\n        VU: 'video-unplayed',\n        PVLOADED: 'fotorama__product-video--loaded', // [CONST]\n        PVLOADING: 'fotorama__product-video--loading', // [CONST]\n        VID: 'video', // [CONST]\n        VI: 'vimeo', // [CONST]\n        FTVC: 'fotorama__video-close',\n        FTAR: 'fotorama__arr',\n        fotoramaSpinner: 'fotorama__spinner',\n        fotoramaSpinnerShow: 'fotorama__spinner--show',\n        TI: 'video-thumb-icon',\n        isFullscreen: false,\n        FTCF: '[data-gallery-role=\"fotorama__fullscreen-icon\"]',\n        Base: 0, //on check for video is base this setting become true if there is any video with base role\n        MobileMaxWidth: 768,\n        GP: 'gallery-placeholder', //gallery placeholder class is needed to find and erase <script> tag\n        videoData: null,\n        videoDataPlaceholder: [{\n            id: '',\n            isBase: true,\n            mediaType: 'image',\n            provider: ''\n        }],\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            $(this.element).data('gallery') ?\n                this._onGalleryLoaded() :\n                $(this.element).on('gallery:loaded', this._onGalleryLoaded.bind(this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initialize: function () {\n            if (!this.defaultVideoData.length) {\n                this.defaultVideoData = this.options.videoData;\n            }\n\n            // If product does not have images, no video data generated,\n            // but for configurable product we still need a video data, in case of 'prepend' gallery strategy.\n            if (!this.defaultVideoData.length && !this.options.videoData.length) {\n                this.defaultVideoData = this.options.videoData = this.videoDataPlaceholder;\n            }\n\n            this.clearEvents();\n\n            if (this._checkForVideoExist()) {\n                this._checkFullscreen();\n                this._listenForFullscreen();\n                this._isVideoBase();\n                this._initFotoramaVideo();\n                this._attachFotoramaEvents();\n            }\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         */\n        _onGalleryLoaded: function () {\n            this.fotoramaItem = $(this.element).find('.fotorama-item');\n            this._initialize();\n        },\n\n        /**\n         * Clear gallery events to prevent duplicated calls.\n         *\n         * @private\n         */\n        clearEvents: function () {\n            if (this.fotoramaItem !== undefined) {\n                this.fotoramaItem.off(\n                    'fotorama:show.' + this.PV +\n                    ' fotorama:showend.' + this.PV +\n                    ' fotorama:fullscreenenter.' + this.PV +\n                    ' fotorama:fullscreenexit.' + this.PV\n                );\n            }\n        },\n\n        /**\n         *\n         * @param {Object} options\n         * @private\n         */\n        _setOptions: function (options) {\n            if (options.videoData && options.videoData.length) {\n                this.options.videoData = options.videoData;\n            }\n\n            this._loadVideoData(options);\n            this._initialize();\n        },\n\n        /**\n         * Set video data for configurable product.\n         *\n         * @param {Object} options\n         * @private\n         */\n        _loadVideoData: function (options) {\n            if (options.selectedOption) {\n                if (options.dataMergeStrategy === 'prepend') {\n                    this.options.videoData = [].concat(\n                        this.options.optionsVideoData[options.selectedOption],\n                        this.defaultVideoData\n                    );\n                } else {\n                    this.options.videoData = this.options.optionsVideoData[options.selectedOption];\n                }\n            } else {\n                this.options.videoData = this.defaultVideoData;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkFullscreen: function () {\n            if (this.fotoramaItem.data('fotorama').fullScreen || false) {\n                this.isFullscreen = true;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _listenForFullscreen: function () {\n            this.fotoramaItem.on('fotorama:fullscreenenter.' + this.PV, $.proxy(function () {\n                this.isFullscreen = true;\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit.' + this.PV, $.proxy(function () {\n                this.isFullscreen = false;\n                this._hideVideoArrows();\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} inputData\n         * @param {bool} isJSON\n         * @returns {{}}\n         * @private\n         */\n        _createVideoData: function (inputData, isJSON) {\n            var videoData = [],\n                dataUrl,\n                tmpVideoData,\n                tmpInputData,\n                i;\n\n            if (isJSON) {\n                inputData = JSON.parse(inputData);\n            }\n\n            for (i = 0; i < inputData.length; i++) {\n                tmpInputData = inputData[i];\n                dataUrl = '';\n                tmpVideoData = {\n                    mediaType: '',\n                    isBase: '',\n                    id: '',\n                    provider: ''\n                };\n                tmpVideoData.mediaType = this.VID;\n\n                if (tmpInputData.mediaType !== 'external-video') {\n                    tmpVideoData.mediaType = tmpInputData.mediaType;\n                }\n\n                tmpVideoData.isBase = tmpInputData.isBase;\n\n                if (tmpInputData.videoUrl && tmpInputData.videoUrl !== null) {\n                    dataUrl = tmpInputData.videoUrl;\n                    dataUrl = parseURL(dataUrl);\n                    tmpVideoData.id = dataUrl.id;\n                    tmpVideoData.provider = dataUrl.type;\n                    tmpVideoData.videoUrl = tmpInputData.videoUrl;\n                    tmpVideoData.useYoutubeNocookie = dataUrl.useYoutubeNocookie;\n                }\n\n                videoData.push(tmpVideoData);\n            }\n\n            return videoData;\n        },\n\n        /**\n         *\n         * @param {Object} fotorama\n         * @param {bool} isBase\n         * @private\n         */\n        _createCloseVideo: function (fotorama, isBase) {\n            var closeVideo;\n\n            this.fotoramaItem.find('.' + this.FTVC).remove();\n            this.fotoramaItem.append('<div class=\"' + this.FTVC + '\"></div>');\n            this.fotoramaItem.css('position', 'relative');\n            closeVideo = this.fotoramaItem.find('.' + this.FTVC);\n            this._closeVideoSetEvents(closeVideo, fotorama);\n\n            if (\n                isBase &&\n                this.options.videoData[fotorama.activeIndex].isBase &&\n                $(window).width() > this.MobileMaxWidth) {\n                this._showCloseVideo();\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _hideCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .removeClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @private\n         */\n        _showCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .addClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @param {jQuery} $closeVideo\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _closeVideoSetEvents: function ($closeVideo, fotorama) {\n            $closeVideo.on('click', $.proxy(function () {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n                this._hideCloseVideo();\n            }, this));\n        },\n\n        /**\n         *\n         * @returns {Boolean}\n         * @private\n         */\n        _checkForVideoExist: function () {\n            var key, result, checker, videoSettings;\n\n            if (!this.options.videoData) {\n                return false;\n            }\n\n            if (!this.options.videoSettings) {\n                return false;\n            }\n\n            result = this._createVideoData(this.options.videoData, false);\n            checker = false;\n            videoSettings = this.options.videoSettings[0];\n            videoSettings.playIfBase = parseInt(videoSettings.playIfBase, 10);\n            videoSettings.showRelated = parseInt(videoSettings.showRelated, 10);\n            videoSettings.videoAutoRestart = parseInt(videoSettings.videoAutoRestart, 10);\n\n            for (key in result) {\n                if (result[key].mediaType === this.VID) {\n                    checker = true;\n                }\n            }\n\n            if (checker) {\n                this.options.videoData = result;\n            }\n\n            return checker;\n        },\n\n        /**\n         *\n         * @private\n         */\n        _isVideoBase: function () {\n            var allVideoData = this.options.videoData,\n                videoItem,\n                allVideoDataKeys,\n                key,\n                i;\n\n            allVideoDataKeys = Object.keys(allVideoData);\n\n            for (i = 0; i < allVideoDataKeys.length; i++) {\n                key = allVideoDataKeys[i];\n                videoItem = allVideoData[key];\n\n                if (\n                    videoItem.mediaType === this.VID && videoItem.isBase &&\n                    this.options.videoSettings[0].playIfBase && allowBase\n                ) {\n                    this.Base = true;\n                    allowBase = false;\n                }\n            }\n\n            if (!this.isFullscreen) {\n                this._createCloseVideo(this.fotoramaItem.data('fotorama'), this.Base);\n            }\n        },\n\n        /**\n         *\n         * @param {Event} e\n         * @private\n         */\n        _initFotoramaVideo: function (e) {\n            var fotorama = this.fotoramaItem.data('fotorama'),\n                thumbsParent,\n                thumbs,\n                t;\n\n            if (!fotorama.activeFrame.$navThumbFrame) {\n                this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (evt, fotoramaData) {\n                    $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n                }, this));\n\n                this._startPrepareForPlayer(e, fotorama);\n\n                return null;\n            }\n\n            fotorama.data.map($.proxy(this._setItemType, this));\n            thumbsParent = fotorama.activeFrame.$navThumbFrame.parent();\n            thumbs = thumbsParent.find('.fotorama__nav__frame:visible');\n\n            for (t = 0; t < thumbs.length; t++) {\n                this._setThumbsIcon(thumbs.eq(t), t);\n                this._checkForVideo(e, fotorama, t + 1);\n            }\n\n            this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (evt, fotoramaData) {\n                $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} elem\n         * @param {Number} i\n         * @private\n         */\n        _setThumbsIcon: function (elem, i) {\n            var fotorama = this.fotoramaItem.data('fotorama');\n\n            if (fotorama.options.nav === 'dots' && elem.hasClass(this.TI)) {\n                elem.removeClass(this.TI);\n            }\n\n            if (this.options.videoData[i].mediaType === this.VID &&\n                fotorama.data[i].type ===  this.VID &&\n                fotorama.options.nav === 'thumbs') {\n                elem.addClass(this.TI);\n            }\n        },\n\n        /**\n         * Temporary solution with adding types for configurable product items\n         *\n         * @param {Object} item\n         * @param {Number} i\n         * @private\n         */\n        _setItemType: function (item, i) {\n            !item.type && (item.type = this.options.videoData[i].mediaType);\n        },\n\n        /**\n         * Attach\n         *\n         * @private\n         */\n        _attachFotoramaEvents: function () {\n            this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (e, fotorama) {\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:show.' + this.PV, $.proxy(function (e, fotorama) {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit.' + this.PV, $.proxy(function (e, fotorama) {\n                fotorama.activeFrame.$stageFrame.find('.' + this.PV).remove();\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n        },\n\n        /**\n         * Start prepare for player\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _startPrepareForPlayer: function (e, fotorama) {\n            this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, false);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i - 1);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i + 1);\n        },\n\n        /**\n         * Check for video\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _checkForVideo: function (e, fotorama, number) {\n            var videoData = this.options.videoData[number - 1],\n                $image = fotorama.data[number - 1];\n\n            if ($image) {\n                !$image.type && this._setItemType($image, number - 1);\n\n                if ($image.type === 'image') {\n                    $image.$navThumbFrame && $image.$navThumbFrame.removeClass(this.TI);\n                    this._hideCloseVideo();\n\n                    return;\n                } else if ($image.$navThumbFrame && $image.type === 'video') {\n                    !$image.$navThumbFrame.hasClass(this.TI) && $image.$navThumbFrame.addClass(this.TI);\n                }\n\n                $image = $image.$stageFrame;\n            }\n\n            if ($image && videoData && videoData.mediaType === this.VID) {\n                $(fotorama.activeFrame.$stageFrame).removeAttr('href');\n                this._prepareForVideoContainer($image, videoData, fotorama, number);\n            }\n\n            if (this.isFullscreen && this.fotoramaItem.data('fotorama').activeFrame.i === number) {\n                this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.trigger('click');\n            }\n        },\n\n        /**\n         * Prepare for video container\n         *\n         * @param {jQuery} $image\n         * @param {Object} videoData\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _prepareForVideoContainer: function ($image, videoData, fotorama, number) {\n            $image.addClass('fotorama-video-container').addClass(this.VU);\n            this._createVideoContainer(videoData, $image);\n            this._setVideoEvent($image, this.PV, fotorama, number);\n        },\n\n        /**\n         * Create video container\n         *\n         * @param {Object} videoData\n         * @param {jQuery} $image\n         * @private\n         */\n        _createVideoContainer: function (videoData, $image) {\n            var videoSettings;\n\n            videoSettings = this.options.videoSettings[0];\n            $image.find('.' + this.PV).remove();\n            $image.append(\n                '<div class=\"' +\n                this.PV +\n                '\" data-related=\"' +\n                videoSettings.showRelated +\n                '\" data-loop=\"' +\n                videoSettings.videoAutoRestart +\n                '\" data-type=\"' +\n                videoData.provider +\n                '\" data-code=\"' +\n                videoData.id +\n                '\"  data-youtubenocookie=\"' +\n                videoData.useYoutubeNocookie +\n                '\" data-width=\"100%\" data-height=\"100%\"></div>'\n            );\n        },\n\n        /**\n         *\n         * @param {Object} $image\n         * @param {Object} PV\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _setVideoEvent: function ($image, PV, fotorama, number) {\n            $image.find('.magnify-lens').remove();\n            $image\n                .off('click tap', $.proxy(this._clickHandler, this))\n                .on('click tap', $.proxy(this._clickHandler, this));\n            this._handleBaseVideo(fotorama, number); //check for video is it base and handle it if it's base\n        },\n\n        /**\n         * Hides preview arrows above video player.\n         * @private\n         */\n        _hideVideoArrows: function () {\n            var arrows = $('.' + this.FTAR);\n\n            arrows.removeClass('fotorama__arr--shown');\n            arrows.removeClass('fotorama__arr--hidden');\n        },\n\n        /**\n         * @private\n         */\n        _showLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.addClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.addClass(this.PVLOADING);\n        },\n\n        /**\n         * @private\n         */\n        _hideLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.removeClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.removeClass(this.PVLOADING);\n        },\n\n        /**\n         * @param {Event} event\n         * @private\n         */\n        _clickHandler: function (event) {\n            var type;\n\n            if ($(event.target).hasClass(this.VU) && $(event.target).find('iframe').length === 0) {\n                $(event.target).removeClass(this.VU);\n                type = $(event.target).find('.' + this.PV).data('type');\n\n                if (type === this.VI) {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                } else if (type === this.VI) {\n                    this._showLoader();\n                    this.onVimeoJSFramework = function () {\n                        $(event.target).find('.' + this.PV).productVideoLoader();\n                        this._hideLoader();\n                    }.bind(this);\n                } else {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                }\n\n                $('.' + this.FTAR).addClass(this.isFullscreen ? 'fotorama__arr--shown' : 'fotorama__arr--hidden');\n                $('.' + this.FTVC).addClass('fotorama-show-control');\n            }\n        },\n\n        /**\n         * Handle base video\n         * @param {Object} fotorama\n         * @param {Number} srcNumber\n         * @private\n         */\n        _handleBaseVideo: function (fotorama, srcNumber) {\n            var videoData = this.options.videoData,\n                activeIndex = fotorama.activeIndex,\n                number = parseInt(srcNumber, 10),\n                activeIndexIsBase = videoData[activeIndex];\n\n            if (!this.Base) {\n                return;\n            }\n\n            if (activeIndexIsBase && number === 1 && $(window).width() > this.MobileMaxWidth) {\n                setTimeout($.proxy(function () {\n                    fotorama.requestFullScreen();\n                    this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.trigger('click');\n                    this.Base = false;\n                }, this), 50);\n            }\n        },\n\n        /**\n         * Destroy video player\n         * @param {jQuery} $wrapper\n         * @param {jQuery} current\n         * @param {bool} close\n         * @private\n         */\n        _unloadVideoPlayer: function ($wrapper, current, close) {\n            var self = this;\n\n            if (!$wrapper) {\n                return;\n            }\n\n            $wrapper.find('.' + this.PVLOADED).removeClass(this.PVLOADED);\n            this._hideLoader();\n\n            $wrapper.find('.' + this.PV).each(function () {\n                var $item = $(this).parent(),\n                    cloneVideoDiv,\n                    iframeElement = $(this).find('iframe'),\n                    currentIndex,\n                    itemIndex;\n\n                if (iframeElement.length === 0) {\n                    return;\n                }\n\n                currentIndex = current.activeFrame.$stageFrame.index();\n                itemIndex = $item.index();\n\n                if (currentIndex === itemIndex && !close) {\n                    return;\n                }\n\n                if (currentIndex !== itemIndex && close) {\n                    return;\n                }\n\n                iframeElement.remove();\n                cloneVideoDiv = $(this).clone();\n                $(this).remove();\n                $item.append(cloneVideoDiv);\n                $item.addClass(self.VU);\n\n                self._hideCloseVideo();\n                self._hideVideoArrows();\n\n                if (self.isFullscreen && !self.fotoramaItem.data('fotorama').options.fullscreen.arrows) {\n                    if ($('.' + self.FTAR + '--prev').is(':focus') || $('.' + self.FTAR + '--next').is(':focus')) {\n                        $(self.FTCF).trigger('focus');\n                    }\n                }\n            });\n        }\n    });\n\n    return $.mage.AddFotoramaVideoEvents;\n});\n","Magento_ProductVideo/js/load-player.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n @version 0.0.1\n @requires jQuery & jQuery UI\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'vimeoWrapper'\n], function ($) {\n    'use strict';\n\n    var videoRegister = {\n        _register: {},\n\n        /**\n         * Checks, if api is already registered\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isRegistered: function (api) {\n            return this._register[api] !== undefined;\n        },\n\n        /**\n         * Checks, if api is loaded\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isLoaded: function (api) {\n            return this._register[api] !== undefined && this._register[api] === true;\n        },\n\n        /**\n         * Register new video api\n         * @param {String} api\n         * @param {bool} loaded\n         */\n        register: function (api, loaded) {\n            loaded = loaded || false;\n            this._register[api] = loaded;\n        }\n    };\n\n    $.widget('mage.productVideoLoader', {\n\n        /**\n         * @private\n         */\n        _create: function () {\n            switch (this.element.data('type')) {\n                case 'youtube':\n                    this.element.videoYoutube();\n                    this._player = this.element.data('mageVideoYoutube');\n                    break;\n\n                case 'vimeo':\n                    this.element.videoVimeo();\n                    this._player = this.element.data('mageVideoVimeo');\n                    break;\n                default:\n                    throw {\n                        name: 'Video Error',\n                        message: 'Unknown video type',\n\n                        /**\n                         * join name with message\n                         */\n                        toString: function () {\n                            return this.name + ': ' + this.message;\n                        }\n                    };\n            }\n        },\n\n        /**\n         * Initializes variables\n         * @private\n         */\n        _initialize: function () {\n            this._params = this.element.data('params') || {};\n            this._code = this.element.data('code');\n            this._width = this.element.data('width');\n            this._height = this.element.data('height');\n            this._autoplay = !!this.element.data('autoplay');\n            this._playing = this._autoplay || false;\n            this._loop = this.element.data('loop');\n            this._rel = this.element.data('related');\n            this.useYoutubeNocookie = this.element.data('youtubenocookie') || false;\n\n            this._responsive = this.element.data('responsive') !== false;\n\n            if (this._responsive === true) {\n                this.element.addClass('responsive');\n            }\n\n            this._calculateRatio();\n        },\n\n        /**\n         * Abstract play command\n         */\n        play: function () {\n            this._player.play();\n        },\n\n        /**\n         * Abstract pause command\n         */\n        pause: function () {\n            this._player.pause();\n        },\n\n        /**\n         * Abstract stop command\n         */\n        stop: function () {\n            this._player.stop();\n        },\n\n        /**\n         * Abstract playing command\n         */\n        playing: function () {\n            return this._player.playing();\n        },\n\n        /**\n         * Calculates ratio for responsive videos\n         * @private\n         */\n        _calculateRatio: function () {\n            if (!this._responsive) {\n                return;\n            }\n            this.element.css('paddingBottom', this._height / this._width * 100 + '%');\n        }\n    });\n\n    $.widget('mage.videoYoutube', $.mage.productVideoLoader, {\n\n        /**\n         * Initialization of the Youtube widget\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            this._initialize();\n\n            this.element.append('<div></div>');\n\n            this._on(window, {\n\n                /**\n                 * Handle event\n                 */\n                'youtubeapiready': function () {\n                    var host = 'https://www.youtube.com';\n\n                    if (self.useYoutubeNocookie) {\n                        host = 'https://www.youtube-nocookie.com';\n                    }\n\n                    if (self._player !== undefined) {\n                        return;\n                    }\n                    self._autoplay = true;\n\n                    if (self._autoplay) {\n                        self._params.autoplay = 1;\n                    }\n\n                    if (!self._rel) {\n                        self._params.rel = 0;\n                    }\n\n                    self._player = new window.YT.Player(self.element.children(':first')[0], {\n                        height: self._height,\n                        width: self._width,\n                        videoId: self._code,\n                        playerVars: self._params,\n                        host: host,\n                        events: {\n\n                            /**\n                             * Get duration\n                             */\n                            'onReady': function onPlayerReady() {\n                                self._player.getDuration();\n                                self.element.closest('.fotorama__stage__frame')\n                                    .addClass('fotorama__product-video--loaded');\n                            },\n\n                            /**\n                             * Event observer\n                             */\n                            onStateChange: function (data) {\n                                switch (window.parseInt(data.data, 10)) {\n                                    case 1:\n                                        self._playing = true;\n                                        break;\n                                    default:\n                                        self._playing = false;\n                                        break;\n                                }\n\n                                self._trigger('statechange', {}, data);\n\n                                if (data.data === window.YT.PlayerState.ENDED && self._loop) {\n                                    self._player.playVideo();\n                                }\n                            }\n                        }\n\n                    });\n                }\n            });\n\n            this._loadApi();\n        },\n\n        /**\n         * Loads Youtube API and triggers event, when loaded\n         * @private\n         */\n        _loadApi: function () {\n            var element,\n                scriptTag;\n\n            if (videoRegister.isRegistered('youtube')) {\n                if (videoRegister.isLoaded('youtube')) {\n                    $(window).trigger('youtubeapiready');\n                }\n\n                return;\n            }\n\n            // if script already loaded by other library\n            if (window.YT) {\n                videoRegister.register('youtube', true);\n                $(window).trigger('youtubeapiready');\n\n                return;\n            }\n            videoRegister.register('youtube');\n\n            element = document.createElement('script');\n            scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://www.youtube.com/iframe_api';\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n\n            /**\n             * Event observe and handle\n             */\n            window.onYouTubeIframeAPIReady = function () {\n                $(window).trigger('youtubeapiready');\n                videoRegister.register('youtube', true);\n            };\n        },\n\n        /**\n         * Play command for Youtube\n         */\n        play: function () {\n            this._player.playVideo();\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Youtube\n         */\n        pause: function () {\n            this._player.pauseVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Youtube\n         */\n        stop: function () {\n            this._player.stopVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Youtube\n         */\n        playing: function () {\n            return this._playing;\n        },\n\n        /**\n         * stops and unloads player\n         * @private\n         */\n        _destroy: function () {\n            this.stop();\n        }\n    });\n\n    $.widget('mage.videoVimeo', $.mage.productVideoLoader, {\n\n        /**\n         * Initialize the Vimeo widget\n         * @private\n         */\n        _create: function () {\n            var timestamp,\n                additionalParams = '',\n                src,\n                id;\n\n            this._initialize();\n            timestamp = new Date().getTime();\n            this._autoplay = true;\n\n            if (this._autoplay) {\n                additionalParams += '&autoplay=1';\n            }\n\n            if (this._loop) {\n                additionalParams += '&loop=1';\n            }\n            src = 'https://player.vimeo.com/video/' +\n                this._code + '?api=1&player_id=vimeo' +\n                this._code +\n                timestamp +\n                additionalParams;\n            id = 'vimeo' + this._code + timestamp;\n            this.element.append(\n                $('<iframe></iframe>')\n                    .attr('frameborder', 0)\n                    .attr('id', id)\n                    .attr('width', this._width)\n                    .attr('height', this._height)\n                    .attr('src', src)\n                    .attr('webkitallowfullscreen', '')\n                    .attr('mozallowfullscreen', '')\n                    .attr('allowfullscreen', '')\n                    .attr('referrerPolicy', 'origin')\n                    .attr('allow', 'autoplay')\n            );\n\n            /* eslint-disable no-undef */\n            this._player = new Vimeo.Player(this.element.children(':first')[0]);\n\n            this._player.ready().then(function () {\n                $('#' + id).closest('.fotorama__stage__frame').addClass('fotorama__product-video--loaded');\n            });\n        },\n\n        /**\n         * Play command for Vimeo\n         */\n        play: function () {\n            this._player.play();\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Vimeo\n         */\n        pause: function () {\n            this._player.pause();\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Vimeo\n         */\n        stop: function () {\n            this._player.unload();\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Vimeo\n         */\n        playing: function () {\n            return this._playing;\n        }\n    });\n});\n","Magento_PageBuilder/js/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['uiEvents'], function (uiEvents) {\n    'use strict';\n\n    return {\n\n        /**\n         * Calls callback when name event is triggered\n         *\n         * @param {String} events\n         * @param {Function} callback\n         * @param {Function} ns\n         * @return {Object}\n         */\n        on: function (events, callback, ns) {\n            uiEvents.on('pagebuilder:' + events, callback, 'pagebuilder:' + ns);\n\n            return this;\n        },\n\n        /**\n         * Removed callback from listening to target event\n         *\n         * @param {String} ns\n         * @return {Object}\n         */\n        off: function (ns) {\n            uiEvents.off('pagebuilder:' + ns);\n\n            return this;\n        },\n\n        /**\n         * Triggers event and executes all attached callbacks\n         *\n         * @param {String} name\n         * @param {any} args\n         * @returns {Boolean}\n         */\n        trigger: function (name, args) {\n            return uiEvents.trigger('pagebuilder:' + name, args);\n        }\n    };\n});\n","Magento_PageBuilder/js/widget-initializer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'jquery',\n    'mage/apply/main',\n    'Magento_Ui/js/lib/view/utils/dom-observer'\n], function (_, $, mage, domObserver) {\n    'use strict';\n\n    /**\n     * Initializes components assigned to HTML elements.\n     *\n     *\n     * @param {HTMLElement} el\n     * @param {Array} data\n     * @param {Object} breakpoints\n     * @param {Object} currentViewport\n     */\n    function initializeWidget(el, data, breakpoints, currentViewport) {\n        _.each(data, function (config, component) {\n            config = config || {};\n            config.breakpoints = breakpoints;\n            config.currentViewport = currentViewport;\n            mage.applyFor(el, config, component);\n        });\n    }\n\n    return function (data, contextElement) {\n        _.each(data.config, function (componentConfiguration, elementPath) {\n            domObserver.get(\n                elementPath,\n                function (element) {\n                    var $element = $(element);\n\n                    if (contextElement) {\n                        $element = $(contextElement).find(element);\n                    }\n\n                    if ($element.length) {\n                        initializeWidget($element, componentConfiguration, data.breakpoints, data.currentViewport);\n                    }\n                }\n            );\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/tabs/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'jquery-ui-modules/tabs'\n], function ($, events) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element);\n\n        // Ignore stage builder preview tabs\n        if ($element.is('.pagebuilder-tabs')) {\n            return;\n        }\n\n        // Disambiguate between the mage/tabs component which is loaded randomly depending on requirejs order.\n        $.ui.tabs({\n            active: $element.data('activeTab') || 0,\n            create:\n\n                /**\n                 * Adjust the margin bottom of the navigation to correctly display the active tab\n                 */\n                function () {\n                    var borderWidth = parseInt($element.find('.tabs-content').css('borderWidth').toString(), 10);\n\n                    $element.find('.tabs-navigation').css('marginBottom', -borderWidth);\n                    $element.find('.tabs-navigation li:not(:first-child)').css('marginLeft', -borderWidth);\n                },\n            activate:\n\n                /**\n                 * Trigger redraw event since new content is being displayed\n                 */\n                function () {\n                    events.trigger('contentType:redrawAfter', {\n                        element: element\n                    });\n                }\n        }, element);\n    };\n});\n","Magento_PageBuilder/js/content-type/products/appearance/carousel/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'matchMedia',\n    'Magento_PageBuilder/js/utils/breakpoints',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, _, mediaCheck, breakpointsUtils, events) {\n    'use strict';\n\n    /**\n     * Build slick\n     *\n     * @param {jQuery} $carouselElement\n     * @param {Object} config\n     */\n    function buildSlick($carouselElement, config) {\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($carouselElement.hasClass('slick-initialized')) {\n            $carouselElement.slick('unslick');\n        }\n\n        config.slidesToScroll = config.slidesToShow;\n        $carouselElement.slick(config);\n    }\n\n    /**\n     * Initialize slider.\n     *\n     * @param {jQuery} $element\n     * @param {Object} slickConfig\n     * @param {Object} breakpoint\n     */\n    function initSlider($element, slickConfig, breakpoint) {\n        var productCount = $element.find('.product-item').length,\n            $carouselElement = $($element.children()),\n            centerModeClass = 'center-mode',\n            carouselMode = $element.data('carousel-mode'),\n            slidesToShow = breakpoint.options.products[carouselMode] ?\n                breakpoint.options.products[carouselMode].slidesToShow :\n                breakpoint.options.products.default.slidesToShow;\n\n        slickConfig.slidesToShow = parseFloat(slidesToShow);\n\n        if (carouselMode === 'continuous' && productCount > slickConfig.slidesToShow) {\n            $element.addClass(centerModeClass);\n            slickConfig.centerPadding = $element.data('center-padding');\n            slickConfig.centerMode = true;\n        } else {\n            $element.removeClass(centerModeClass);\n            slickConfig.infinite = $element.data('infinite-loop');\n        }\n\n        buildSlick($carouselElement, slickConfig);\n    }\n\n    return function (config, element) {\n        var $element = $(element),\n            $carouselElement = $($element.children()),\n            currentViewport = config.currentViewport,\n            currentBreakpoint = config.breakpoints[currentViewport],\n            slickConfig = {\n                autoplay: $element.data('autoplay'),\n                autoplaySpeed: $element.data('autoplay-speed') || 0,\n                arrows: $element.data('show-arrows'),\n                dots: $element.data('show-dots')\n            };\n\n        _.each(config.breakpoints, function (breakpoint) {\n            mediaCheck({\n                media: breakpointsUtils.buildMedia(breakpoint.conditions),\n\n                /** @inheritdoc */\n                entry: function () {\n                    initSlider($element, slickConfig, breakpoint);\n                }\n            });\n        });\n\n        //initialize slider when content type is added in mobile viewport\n        if (currentViewport === 'mobile') {\n            initSlider($element, slickConfig, currentBreakpoint);\n        }\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($carouselElement.closest(args.element).length) {\n                $carouselElement.slick('setPosition');\n            }\n        });\n\n        events.on('stage:viewportChangeAfter', function (args) {\n            var breakpoint = config.breakpoints[args.viewport];\n\n            initSlider($element, slickConfig, breakpoint);\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/slide/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function ($, _, showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]'),\n            viewportElement = document.createElement('div'),\n            $slider = null;\n\n        showOnHover(config);\n\n        if (videoElement) {\n            $slider = $(element).closest('[data-content-type=slider]');\n            viewportElement.classList.add('jarallax-viewport-element');\n            videoElement.setAttribute('data-element-in-viewport', '.jarallax-viewport-element');\n            videoElement.appendChild(viewportElement);\n            videoBackground(config, videoElement);\n\n            if ($slider.data('afterChangeIsSet')) {\n                return;\n            }\n\n            $slider.on('afterChange init', function () {\n                var videoSlides = $slider[0].querySelectorAll('.jarallax');\n\n                _.each(videoSlides, function (videoSlide) {\n                    videoSlide.jarallax && videoSlide.jarallax.onScroll();\n                });\n            });\n            $slider.data('afterChangeIsSet', true);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/buttons/appearance/inline/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events'\n], function ($, events) {\n    'use strict';\n\n    /**\n     * Equalize the width of a list of button-item components\n     *\n     * @param {JQuery} buttonList\n     */\n    var equalizeButtonWidth = function (buttonList) {\n        var buttonMinWidth = 0;\n\n        buttonList.css('min-width', buttonMinWidth);\n        buttonList.each(function () {\n            var buttonWidth = this.offsetWidth;\n\n            if (buttonWidth > buttonMinWidth) {\n                buttonMinWidth = buttonWidth;\n            }\n        });\n        buttonList.css('min-width', buttonMinWidth);\n    };\n\n    return function (config, element) {\n        var $element = $(element),\n            buttonSelector = '[data-element=\"link\"], [data-element=\"empty_link\"]';\n\n        if ($element.data('sameWidth')) {\n            equalizeButtonWidth($element.find(buttonSelector));\n            $(window).on('resize', function () {\n                equalizeButtonWidth($element.find(buttonSelector));\n            });\n            events.on('contentType:redrawAfter', function (eventData) {\n                if ($element.closest(eventData.element).length > 0) {\n                    equalizeButtonWidth($element.find(buttonSelector));\n                }\n            });\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/slider/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, events) {\n    'use strict';\n\n    return function (config, sliderElement) {\n        var $element = $(sliderElement);\n\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($element.hasClass('slick-initialized')) {\n            $element.slick('unslick');\n        }\n\n        $element.slick({\n            autoplay: $element.data('autoplay'),\n            autoplaySpeed: $element.data('autoplay-speed') || 0,\n            fade: $element.data('fade'),\n            infinite: $element.data('infinite-loop'),\n            arrows: $element.data('show-arrows'),\n            dots: $element.data('show-dots')\n        });\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($element.closest(args.element).length) {\n                $element.slick('setPosition');\n            }\n        });\n        // eslint-disable-next-line jquery-no-bind-unbind\n        events.on('stage:viewportChangeAfter', $element.slick.bind($element, 'setPosition'));\n    };\n});\n","Magento_PageBuilder/js/content-type/row/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/widget/video-background',\n    'jarallax'\n], function ($, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = null,\n            elementStyle = null;\n\n        if ($element.data('appearance') === 'contained') {\n            $element = $(element).find('[data-element=\"inner\"]');\n        }\n\n        if ($element.data('background-type') === 'video') {\n            videoBackground(config, $element[0]);\n\n            return;\n        }\n\n        if ($element.data('enableParallax') !== 1) {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        parallaxSpeed = parseFloat($element.data('parallaxSpeed'));\n        elementStyle = window.getComputedStyle($element[0]);\n\n        window.jarallax($element[0], {\n            imgPosition: elementStyle.backgroundPosition || '50% 50%',\n            imgRepeat: elementStyle.backgroundRepeat || 'no-repeat',\n            imgSize: elementStyle.backgroundSize || 'cover',\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/map/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/utils/map'\n], function ($, GoogleMap) {\n    'use strict';\n\n    return function (config, element) {\n        var locations,\n            controls,\n            mapOptions = {};\n\n        element = element[0];\n\n        if (element !== undefined && element.hasAttribute('data-locations')) {\n\n            /**\n             * Set map display to none if no locations\n             */\n            if (element.getAttribute('data-locations') === '[]') {\n                $(element).hide();\n\n                return;\n            }\n            locations = JSON.parse(element.getAttribute('data-locations'));\n            locations.forEach(function (location) {\n                location.position.latitude = parseFloat(location.position.latitude);\n                location.position.longitude = parseFloat(location.position.longitude);\n            });\n            controls = element.getAttribute('data-show-controls');\n            mapOptions.disableDefaultUI = controls !== 'true';\n            mapOptions.mapTypeControl = controls === 'true';\n            new GoogleMap(element, locations, mapOptions);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/banner/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function (showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]');\n\n        showOnHover(config);\n\n        if (videoElement) {\n            videoBackground(config, videoElement);\n        }\n    };\n});\n","Magento_PageBuilder/js/widget/show-on-hover.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    /**\n     * Show the overlay on hover of specific elements\n     *\n     * @param {JQuery<Element>[]} $elements\n     */\n    function showOverlayOnHover($elements) {\n        $elements.each(function (index, element) {\n            var overlayEl = $(element).find('.pagebuilder-overlay'),\n                overlayColor = overlayEl.attr('data-overlay-color');\n\n            $(element).on('mouseenter', function () {\n                overlayEl.css('background-color', overlayColor);\n            });\n\n            $(element).on('mouseleave', function () {\n                overlayEl.css('background-color', 'transparent');\n            });\n        });\n    }\n\n    /**\n     * Show button on hover of specific elements\n     *\n     * @param {JQuery<Element>[]} $elements\n     * @param {String} buttonClass\n     */\n    function showButtonOnHover($elements, buttonClass) {\n        $elements.each(function (index, element) {\n            var buttonEl = $(element).find(buttonClass);\n\n            $(element).on('mouseenter', function () {\n                buttonEl.css({\n                    'opacity': '1',\n                    'visibility': 'visible'\n                });\n            });\n\n            $(element).on('mouseleave', function () {\n                buttonEl.css({\n                    'opacity': '0',\n                    'visibility': 'hidden'\n                });\n            });\n        });\n    }\n\n    return function (config) {\n\n        var buttonSelector = config.buttonSelector,\n            overlayHoverSelector = 'div[data-content-type=\"%s\"][data-show-overlay=\"%s\"]'\n                .replace('%s', config.dataRole)\n                .replace('%s', config.showOverlay),\n            overlayButtonSelector = 'div[data-content-type=\"%s\"][data-show-button=\"%s\"]'\n                .replace('%s', config.dataRole)\n                .replace('%s', config.showOverlay);\n\n        showOverlayOnHover($(overlayHoverSelector));\n        showButtonOnHover($(overlayButtonSelector), buttonSelector);\n    };\n});\n","Magento_PageBuilder/js/widget/video-background.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jarallax',\n    'jarallaxVideo',\n    'vimeoWrapper'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = $element.data('enableParallax') !== 1 ? 1 : parseFloat($element.data('parallaxSpeed'));\n\n        if ($element.data('background-type') !== 'video') {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        window.jarallax($element[0], {\n            imgSrc: $element.data('videoFallbackSrc'),\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5,\n            videoLoop: $element.data('videoLoop'),\n            videoPlayOnlyVisible: $element.data('videoPlayOnlyVisible'),\n            videoLazyLoading: $element.data('videoLazyLoad'),\n            disableVideo: false,\n            elementInViewport: $element.data('elementInViewport') &&\n                $element[0].querySelector($element.data('elementInViewport'))\n        });\n        $element[0].jarallax.video && $element[0].jarallax.video.on('started', function () {\n            if ($element[0].jarallax.$video) {\n                $element[0].jarallax.$video.style.visibility = 'visible';\n            }\n        });\n    };\n});\n","Magento_PageBuilder/js/utils/breakpoints.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        /**\n         * Build media query.\n         *\n         * @param {Object} conditions\n         * @returns {String}\n         */\n        buildMedia: function (conditions) {\n            var result = _.map(_.pairs(conditions), function (condition) {\n                return '(' + condition.join(': ') + ')';\n            });\n\n            return result.join(' and ');\n        }\n    };\n});\n","Magento_PageBuilder/js/utils/map.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * googleMaps dependency is added within googlemaps.phtml through shim based on API key being set\n *\n * @api\n */\ndefine([\n    'underscore',\n    'module',\n    'Magento_PageBuilder/js/events'\n], function (_, module, events) {\n    'use strict';\n\n    var google = window.google || {},\n\n        /**\n         * Generates a google map usable latitude and longitude object\n         *\n         * @param {Object} position\n         * @return {google.maps.LatLng}\n         */\n        getGoogleLatitudeLongitude = function (position) {\n            return new google.maps.LatLng(position.latitude, position.longitude);\n        },\n        gmAuthFailure = false;\n\n    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n    /**\n     * Google's error listener for map loader failures\n     */\n    window.gm_authFailure = function () {\n        events.trigger('googleMaps:authFailure');\n        gmAuthFailure = true;\n    };\n    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n    return function (element, markers, additionalOptions) {\n        var options,\n            style;\n\n        // If we've previously had an API key error, throw the error even again\n        if (gmAuthFailure) {\n            events.trigger('googleMaps:authFailure');\n\n            return;\n        }\n\n        // If Google Maps isn't loaded don't try init the map, it won't work\n        if (typeof google.maps === 'undefined') {\n            return;\n        }\n\n        /**\n         * Just in case of a bad JSON that bypassed validation\n         */\n        try {\n            style = module.config().style ? JSON.parse(module.config().style) : [];\n        }\n        catch (error) {\n            style = [];\n        }\n        options = _.extend({\n            zoom: 8,\n            center: getGoogleLatitudeLongitude({\n                latitude: 30.2672,\n                longitude: -97.7431\n            }),\n            scrollwheel: false,\n            disableDoubleClickZoom: false,\n            disableDefaultUI: false,\n            mapTypeControl: true,\n            mapTypeControlOptions: {\n                style: google.maps.MapTypeControlStyle.DEFAULT\n            },\n            styles: style\n        }, additionalOptions);\n\n        /* Create the map */\n        this.map = new google.maps.Map(element, options);\n        this.markers = [];\n\n        /**\n         * Callback function on map config update\n         * @param {Array} newMarkers\n         * @param {Object} updateOptions\n         */\n        this.onUpdate = function (newMarkers, updateOptions) {\n            this.map.setOptions(updateOptions);\n            this.setMarkers(newMarkers);\n        };\n\n        /**\n         * Sets the markers to selected map\n         * @param {Object} newMarkers\n         */\n        this.setMarkers = function (newMarkers) {\n            var activeInfoWindow,\n                latitudeLongitudeBounds = new google.maps.LatLngBounds();\n\n            this.markers.forEach(function (marker) {\n                marker.setMap(null);\n            }, this);\n\n            this.markers = [];\n            this.bounds = [];\n\n            /**\n             * Creates and set listener for markers\n             */\n            if (newMarkers && newMarkers.length) {\n                newMarkers.forEach(function (newMarker) {\n                    var location = _.escape(newMarker['location_name']) || '',\n                    comment = newMarker.comment ?\n                        '<p>' + _.escape(newMarker.comment).replace(/(?:\\r\\n|\\r|\\n)/g, '<br/>') + '</p>'\n                        : '',\n                    phone = newMarker.phone ? '<p>Phone: ' + _.escape(newMarker.phone) + '</p>' : '',\n                    address = newMarker.address ? _.escape(newMarker.address) + '<br/>' : '',\n                    city = _.escape(newMarker.city) || '',\n                    country = newMarker.country ? _.escape(newMarker.country) : '',\n                    state = newMarker.state ? _.escape(newMarker.state) + ' ' : '',\n                    zipCode = newMarker.zipcode ? _.escape(newMarker.zipcode) : '',\n                    cityComma = city !== '' && (zipCode !== '' || state !== '') ? ', ' : '',\n                    lineBreak = city !== '' || zipCode !== '' ? '<br/>' : '',\n                    contentString =\n                        '<div>' +\n                        '<h3><b>' + location + '</b></h3>' +\n                        comment +\n                        phone +\n                        '<p><span>' + address +\n                        city + cityComma + state + zipCode + lineBreak +\n                        country + '</span></p>' +\n                        '</div>',\n                    infowindow = new google.maps.InfoWindow({\n                        content: contentString,\n                        maxWidth: 350\n                    }),\n                    newCreatedMarker = new google.maps.Marker({\n                        map: this.map,\n                        position: getGoogleLatitudeLongitude(newMarker.position),\n                        title: location\n                    });\n\n                    if (location) {\n                        newCreatedMarker.addListener('click', function () {\n                            if (activeInfoWindow) {\n                                activeInfoWindow.close();\n                            }\n\n                            infowindow.open(this.map, newCreatedMarker);\n                            activeInfoWindow = infowindow;\n                        }, this);\n                    }\n\n                    this.markers.push(newCreatedMarker);\n                    this.bounds.push(getGoogleLatitudeLongitude(newMarker.position));\n                }, this);\n            }\n\n            /**\n             * This sets the bounds of the map for multiple locations\n             */\n            if (this.bounds.length > 1) {\n                this.bounds.forEach(function (bound) {\n                    latitudeLongitudeBounds.extend(bound);\n                });\n                this.map.fitBounds(latitudeLongitudeBounds);\n            }\n\n            /**\n             * Zoom to 8 if there is only a single location\n             */\n            if (this.bounds.length === 1) {\n                this.map.setCenter(this.bounds[0]);\n                this.map.setZoom(8);\n            }\n        };\n\n        this.setMarkers(markers);\n    };\n});\n","Magento_PageBuilder/js/resource/slick/slick.min.js":"/*\n     _ _      _       _\n ___| (_) ___| | __  (_)___\n/ __| | |/ __| |/ /  | / __|\n\\__ \\ | | (__|   < _ | \\__ \\\n|___/_|_|\\___|_|\\_(_)/ |___/\n                   |__/\n\n Version: 1.9.0\n  Author: Ken Wheeler\n Website: http://kenwheeler.github.io\n    Docs: http://kenwheeler.github.io/slick\n    Repo: http://github.com/kenwheeler/slick\n  Issues: http://github.com/kenwheeler/slick/issues\n\n */\n(function(i){\"use strict\";\"function\"==typeof define&&define.amd?define([\"jquery\"],i):\"undefined\"!=typeof exports?module.exports=i(require(\"jquery\")):i(jQuery)})(function(i){\"use strict\";var e=window.Slick||{};e=function(){function e(e,o){var s,n=this;n.defaults={accessibility:!0,adaptiveHeight:!1,appendArrows:i(e),appendDots:i(e),arrows:!0,asNavFor:null,prevArrow:'<button class=\"slick-prev\" aria-label=\"Previous\" type=\"button\">Previous</button>',nextArrow:'<button class=\"slick-next\" aria-label=\"Next\" type=\"button\">Next</button>',autoplay:!1,autoplaySpeed:3e3,centerMode:!1,centerPadding:\"50px\",cssEase:\"ease\",customPaging:function(e,t){return i('<button type=\"button\" />').text(t+1)},dots:!1,dotsClass:\"slick-dots\",draggable:!0,easing:\"linear\",edgeFriction:.35,fade:!1,focusOnSelect:!1,focusOnChange:!1,infinite:!0,initialSlide:0,lazyLoad:\"ondemand\",mobileFirst:!1,pauseOnHover:!0,pauseOnFocus:!0,pauseOnDotsHover:!1,respondTo:\"window\",responsive:null,rows:1,rtl:!1,slide:\"\",slidesPerRow:1,slidesToShow:1,slidesToScroll:1,speed:500,swipe:!0,swipeToSlide:!1,touchMove:!0,touchThreshold:5,useCSS:!0,useTransform:!0,variableWidth:!1,vertical:!1,verticalSwiping:!1,waitForAnimate:!0,zIndex:1e3},n.initials={animating:!1,dragging:!1,autoPlayTimer:null,currentDirection:0,currentLeft:null,currentSlide:0,direction:1,$dots:null,listWidth:null,listHeight:null,loadIndex:0,$nextArrow:null,$prevArrow:null,scrolling:!1,slideCount:null,slideWidth:null,$slideTrack:null,$slides:null,sliding:!1,slideOffset:0,swipeLeft:null,swiping:!1,$list:null,touchObject:{},transformsEnabled:!1,unslicked:!1},i.extend(n,n.initials),n.activeBreakpoint=null,n.animType=null,n.animProp=null,n.breakpoints=[],n.breakpointSettings=[],n.cssTransitions=!1,n.focussed=!1,n.interrupted=!1,n.hidden=\"hidden\",n.paused=!0,n.positionProp=null,n.respondTo=null,n.rowCount=1,n.shouldClick=!0,n.$slider=i(e),n.$slidesCache=null,n.transformType=null,n.transitionType=null,n.visibilityChange=\"visibilitychange\",n.windowWidth=0,n.windowTimer=null,s=i(e).data(\"slick\")||{},n.options=i.extend({},n.defaults,o,s),n.currentSlide=n.options.initialSlide,n.originalSettings=n.options,\"undefined\"!=typeof document.mozHidden?(n.hidden=\"mozHidden\",n.visibilityChange=\"mozvisibilitychange\"):\"undefined\"!=typeof document.webkitHidden&&(n.hidden=\"webkitHidden\",n.visibilityChange=\"webkitvisibilitychange\"),n.autoPlay=i.proxy(n.autoPlay,n),n.autoPlayClear=i.proxy(n.autoPlayClear,n),n.autoPlayIterator=i.proxy(n.autoPlayIterator,n),n.changeSlide=i.proxy(n.changeSlide,n),n.clickHandler=i.proxy(n.clickHandler,n),n.selectHandler=i.proxy(n.selectHandler,n),n.setPosition=i.proxy(n.setPosition,n),n.swipeHandler=i.proxy(n.swipeHandler,n),n.dragHandler=i.proxy(n.dragHandler,n),n.keyHandler=i.proxy(n.keyHandler,n),n.instanceUid=t++,n.htmlExpr=/^(?:\\s*(<[\\w\\W]+>)[^>]*)$/,n.registerBreakpoints(),n.init(!0)}var t=0;return e}(),e.prototype.activateADA=function(){var i=this;i.$slideTrack.find(\".slick-active\").attr({\"aria-hidden\":\"false\"}).find(\"a, input, button, select\").attr({tabindex:\"0\"})},e.prototype.addSlide=e.prototype.slickAdd=function(e,t,o){var s=this;if(\"boolean\"==typeof t)o=t,t=null;else if(t<0||t>=s.slideCount)return!1;s.unload(),\"number\"==typeof t?0===t&&0===s.$slides.length?i(e).appendTo(s.$slideTrack):o?i(e).insertBefore(s.$slides.eq(t)):i(e).insertAfter(s.$slides.eq(t)):o===!0?i(e).prependTo(s.$slideTrack):i(e).appendTo(s.$slideTrack),s.$slides=s.$slideTrack.children(this.options.slide),s.$slideTrack.children(this.options.slide).detach(),s.$slideTrack.append(s.$slides),s.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e)}),s.$slidesCache=s.$slides,s.reinit()},e.prototype.animateHeight=function(){var i=this;if(1===i.options.slidesToShow&&i.options.adaptiveHeight===!0&&i.options.vertical===!1){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.animate({height:e},i.options.speed)}},e.prototype.animateSlide=function(e,t){var o={},s=this;s.animateHeight(),s.options.rtl===!0&&s.options.vertical===!1&&(e=-e),s.transformsEnabled===!1?s.options.vertical===!1?s.$slideTrack.animate({left:e},s.options.speed,s.options.easing,t):s.$slideTrack.animate({top:e},s.options.speed,s.options.easing,t):s.cssTransitions===!1?(s.options.rtl===!0&&(s.currentLeft=-s.currentLeft),i({animStart:s.currentLeft}).animate({animStart:e},{duration:s.options.speed,easing:s.options.easing,step:function(i){i=Math.ceil(i),s.options.vertical===!1?(o[s.animType]=\"translate(\"+i+\"px, 0px)\",s.$slideTrack.css(o)):(o[s.animType]=\"translate(0px,\"+i+\"px)\",s.$slideTrack.css(o))},complete:function(){t&&t.call()}})):(s.applyTransition(),e=Math.ceil(e),s.options.vertical===!1?o[s.animType]=\"translate3d(\"+e+\"px, 0px, 0px)\":o[s.animType]=\"translate3d(0px,\"+e+\"px, 0px)\",s.$slideTrack.css(o),t&&setTimeout(function(){s.disableTransition(),t.call()},s.options.speed))},e.prototype.getNavTarget=function(){var e=this,t=e.options.asNavFor;return t&&null!==t&&(t=i(t).not(e.$slider)),t},e.prototype.asNavFor=function(e){var t=this,o=t.getNavTarget();null!==o&&\"object\"==typeof o&&o.each(function(){var t=i(this).slick(\"getSlick\");t.unslicked||t.slideHandler(e,!0)})},e.prototype.applyTransition=function(i){var e=this,t={};e.options.fade===!1?t[e.transitionType]=e.transformType+\" \"+e.options.speed+\"ms \"+e.options.cssEase:t[e.transitionType]=\"opacity \"+e.options.speed+\"ms \"+e.options.cssEase,e.options.fade===!1?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.autoPlay=function(){var i=this;i.autoPlayClear(),i.slideCount>i.options.slidesToShow&&(i.autoPlayTimer=setInterval(i.autoPlayIterator,i.options.autoplaySpeed))},e.prototype.autoPlayClear=function(){var i=this;i.autoPlayTimer&&clearInterval(i.autoPlayTimer)},e.prototype.autoPlayIterator=function(){var i=this,e=i.currentSlide+i.options.slidesToScroll;i.paused||i.interrupted||i.focussed||(i.options.infinite===!1&&(1===i.direction&&i.currentSlide+1===i.slideCount-1?i.direction=0:0===i.direction&&(e=i.currentSlide-i.options.slidesToScroll,i.currentSlide-1===0&&(i.direction=1))),i.slideHandler(e))},e.prototype.buildArrows=function(){var e=this;e.options.arrows===!0&&(e.$prevArrow=i(e.options.prevArrow).addClass(\"slick-arrow\"),e.$nextArrow=i(e.options.nextArrow).addClass(\"slick-arrow\"),e.slideCount>e.options.slidesToShow?(e.$prevArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.$nextArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.prependTo(e.options.appendArrows),e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.appendTo(e.options.appendArrows),e.options.infinite!==!0&&e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\")):e.$prevArrow.add(e.$nextArrow).addClass(\"slick-hidden\").attr({\"aria-disabled\":\"true\",tabindex:\"-1\"}))},e.prototype.buildDots=function(){var e,t,o=this;if(o.options.dots===!0&&o.slideCount>o.options.slidesToShow){for(o.$slider.addClass(\"slick-dotted\"),t=i(\"<ul />\").addClass(o.options.dotsClass),e=0;e<=o.getDotCount();e+=1)t.append(i(\"<li />\").append(o.options.customPaging.call(this,o,e)));o.$dots=t.appendTo(o.options.appendDots),o.$dots.find(\"li\").first().addClass(\"slick-active\")}},e.prototype.buildOut=function(){var e=this;e.$slides=e.$slider.children(e.options.slide+\":not(.slick-cloned)\").addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e).data(\"originalStyling\",i(t).attr(\"style\")||\"\")}),e.$slider.addClass(\"slick-slider\"),e.$slideTrack=0===e.slideCount?i('<div class=\"slick-track\"/>').appendTo(e.$slider):e.$slides.wrapAll('<div class=\"slick-track\"/>').parent(),e.$list=e.$slideTrack.wrap('<div class=\"slick-list\"/>').parent(),e.$slideTrack.css(\"opacity\",0),e.options.centerMode!==!0&&e.options.swipeToSlide!==!0||(e.options.slidesToScroll=1),i(\"img[data-lazy]\",e.$slider).not(\"[src]\").addClass(\"slick-loading\"),e.setupInfinite(),e.buildArrows(),e.buildDots(),e.updateDots(),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.options.draggable===!0&&e.$list.addClass(\"draggable\")},e.prototype.buildRows=function(){var i,e,t,o,s,n,r,l=this;if(o=document.createDocumentFragment(),n=l.$slider.children(),l.options.rows>0){for(r=l.options.slidesPerRow*l.options.rows,s=Math.ceil(n.length/r),i=0;i<s;i++){var d=document.createElement(\"div\");for(e=0;e<l.options.rows;e++){var a=document.createElement(\"div\");for(t=0;t<l.options.slidesPerRow;t++){var c=i*r+(e*l.options.slidesPerRow+t);n.get(c)&&a.appendChild(n.get(c))}d.appendChild(a)}o.appendChild(d)}l.$slider.empty().append(o),l.$slider.children().children().children().css({width:100/l.options.slidesPerRow+\"%\",display:\"inline-block\"})}},e.prototype.checkResponsive=function(e,t){var o,s,n,r=this,l=!1,d=r.$slider.width(),a=window.innerWidth||i(window).width();if(\"window\"===r.respondTo?n=a:\"slider\"===r.respondTo?n=d:\"min\"===r.respondTo&&(n=Math.min(a,d)),r.options.responsive&&r.options.responsive.length&&null!==r.options.responsive){s=null;for(o in r.breakpoints)r.breakpoints.hasOwnProperty(o)&&(r.originalSettings.mobileFirst===!1?n<r.breakpoints[o]&&(s=r.breakpoints[o]):n>r.breakpoints[o]&&(s=r.breakpoints[o]));null!==s?null!==r.activeBreakpoint?(s!==r.activeBreakpoint||t)&&(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):null!==r.activeBreakpoint&&(r.activeBreakpoint=null,r.options=r.originalSettings,e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e),l=s),e||l===!1||r.$slider.trigger(\"breakpoint\",[r,l])}},e.prototype.changeSlide=function(e,t){var o,s,n,r=this,l=i(e.currentTarget);switch(l.is(\"a\")&&e.preventDefault(),l.is(\"li\")||(l=l.closest(\"li\")),n=r.slideCount%r.options.slidesToScroll!==0,o=n?0:(r.slideCount-r.currentSlide)%r.options.slidesToScroll,e.data.message){case\"previous\":s=0===o?r.options.slidesToScroll:r.options.slidesToShow-o,r.slideCount>r.options.slidesToShow&&r.slideHandler(r.currentSlide-s,!1,t);break;case\"next\":s=0===o?r.options.slidesToScroll:o,r.slideCount>r.options.slidesToShow&&r.slideHandler(r.currentSlide+s,!1,t);break;case\"index\":var d=0===e.data.index?0:e.data.index||l.index()*r.options.slidesToScroll;r.slideHandler(r.checkNavigable(d),!1,t),l.children().trigger(\"focus\");break;default:return}},e.prototype.checkNavigable=function(i){var e,t,o=this;if(e=o.getNavigableIndexes(),t=0,i>e[e.length-1])i=e[e.length-1];else for(var s in e){if(i<e[s]){i=t;break}t=e[s]}return i},e.prototype.cleanUpEvents=function(){var e=this;e.options.dots&&null!==e.$dots&&(i(\"li\",e.$dots).off(\"click.slick\",e.changeSlide).off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)),e.options.accessibility===!0&&e.$dots.off(\"keydown.slick\",e.keyHandler)),e.$slider.off(\"focus.slick blur.slick\"),e.options.arrows===!0&&e.slideCount>e.options.slidesToShow&&(e.$prevArrow&&e.$prevArrow.off(\"click.slick\",e.changeSlide),e.$nextArrow&&e.$nextArrow.off(\"click.slick\",e.changeSlide),e.options.accessibility===!0&&(e.$prevArrow&&e.$prevArrow.off(\"keydown.slick\",e.keyHandler),e.$nextArrow&&e.$nextArrow.off(\"keydown.slick\",e.keyHandler))),e.$list.off(\"touchstart.slick mousedown.slick\",e.swipeHandler),e.$list.off(\"touchmove.slick mousemove.slick\",e.swipeHandler),e.$list.off(\"touchend.slick mouseup.slick\",e.swipeHandler),e.$list.off(\"touchcancel.slick mouseleave.slick\",e.swipeHandler),e.$list.off(\"click.slick\",e.clickHandler),i(document).off(e.visibilityChange,e.visibility),e.cleanUpSlideEvents(),e.options.accessibility===!0&&e.$list.off(\"keydown.slick\",e.keyHandler),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().off(\"click.slick\",e.selectHandler),i(window).off(\"orientationchange.slick.slick-\"+e.instanceUid,e.orientationChange),i(window).off(\"resize.slick.slick-\"+e.instanceUid,e.resize),i(\"[draggable!=true]\",e.$slideTrack).off(\"dragstart\",e.preventDefault),i(window).off(\"load.slick.slick-\"+e.instanceUid,e.setPosition)},e.prototype.cleanUpSlideEvents=function(){var e=this;e.$list.off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.cleanUpRows=function(){var i,e=this;e.options.rows>0&&(i=e.$slides.children().children(),i.removeAttr(\"style\"),e.$slider.empty().append(i))},e.prototype.clickHandler=function(i){var e=this;e.shouldClick===!1&&(i.stopImmediatePropagation(),i.stopPropagation(),i.preventDefault())},e.prototype.destroy=function(e){var t=this;t.autoPlayClear(),t.touchObject={},t.cleanUpEvents(),i(\".slick-cloned\",t.$slider).detach(),t.$dots&&t.$dots.remove(),t.$prevArrow&&t.$prevArrow.length&&(t.$prevArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.prevArrow)&&t.$prevArrow.remove()),t.$nextArrow&&t.$nextArrow.length&&(t.$nextArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.nextArrow)&&t.$nextArrow.remove()),t.$slides&&(t.$slides.removeClass(\"slick-slide slick-active slick-center slick-visible slick-current\").removeAttr(\"aria-hidden\").removeAttr(\"data-slick-index\").each(function(){i(this).attr(\"style\",i(this).data(\"originalStyling\"))}),t.$slideTrack.children(this.options.slide).detach(),t.$slideTrack.detach(),t.$list.detach(),t.$slider.append(t.$slides)),t.cleanUpRows(),t.$slider.removeClass(\"slick-slider\"),t.$slider.removeClass(\"slick-initialized\"),t.$slider.removeClass(\"slick-dotted\"),t.unslicked=!0,e||t.$slider.trigger(\"destroy\",[t])},e.prototype.disableTransition=function(i){var e=this,t={};t[e.transitionType]=\"\",e.options.fade===!1?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.fadeSlide=function(i,e){var t=this;t.cssTransitions===!1?(t.$slides.eq(i).css({zIndex:t.options.zIndex}),t.$slides.eq(i).animate({opacity:1},t.options.speed,t.options.easing,e)):(t.applyTransition(i),t.$slides.eq(i).css({opacity:1,zIndex:t.options.zIndex}),e&&setTimeout(function(){t.disableTransition(i),e.call()},t.options.speed))},e.prototype.fadeSlideOut=function(i){var e=this;e.cssTransitions===!1?e.$slides.eq(i).animate({opacity:0,zIndex:e.options.zIndex-2},e.options.speed,e.options.easing):(e.applyTransition(i),e.$slides.eq(i).css({opacity:0,zIndex:e.options.zIndex-2}))},e.prototype.filterSlides=e.prototype.slickFilter=function(i){var e=this;null!==i&&(e.$slidesCache=e.$slides,e.unload(),e.$slideTrack.children(this.options.slide).detach(),e.$slidesCache.filter(i).appendTo(e.$slideTrack),e.reinit())},e.prototype.focusHandler=function(){var e=this;e.$slider.off(\"focus.slick blur.slick\").on(\"focus.slick\",\"*\",function(t){var o=i(this);setTimeout(function(){e.options.pauseOnFocus&&o.is(\":focus\")&&(e.focussed=!0,e.autoPlay())},0)}).on(\"blur.slick\",\"*\",function(t){i(this);e.options.pauseOnFocus&&(e.focussed=!1,e.autoPlay())})},e.prototype.getCurrent=e.prototype.slickCurrentSlide=function(){var i=this;return i.currentSlide},e.prototype.getDotCount=function(){var i=this,e=0,t=0,o=0;if(i.options.infinite===!0)if(i.slideCount<=i.options.slidesToShow)++o;else for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else if(i.options.centerMode===!0)o=i.slideCount;else if(i.options.asNavFor)for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else o=1+Math.ceil((i.slideCount-i.options.slidesToShow)/i.options.slidesToScroll);return o-1},e.prototype.getLeft=function(i){var e,t,o,s,n=this,r=0;return n.slideOffset=0,t=n.$slides.first().outerHeight(!0),n.options.infinite===!0?(n.slideCount>n.options.slidesToShow&&(n.slideOffset=n.slideWidth*n.options.slidesToShow*-1,s=-1,n.options.vertical===!0&&n.options.centerMode===!0&&(2===n.options.slidesToShow?s=-1.5:1===n.options.slidesToShow&&(s=-2)),r=t*n.options.slidesToShow*s),n.slideCount%n.options.slidesToScroll!==0&&i+n.options.slidesToScroll>n.slideCount&&n.slideCount>n.options.slidesToShow&&(i>n.slideCount?(n.slideOffset=(n.options.slidesToShow-(i-n.slideCount))*n.slideWidth*-1,r=(n.options.slidesToShow-(i-n.slideCount))*t*-1):(n.slideOffset=n.slideCount%n.options.slidesToScroll*n.slideWidth*-1,r=n.slideCount%n.options.slidesToScroll*t*-1))):i+n.options.slidesToShow>n.slideCount&&(n.slideOffset=(i+n.options.slidesToShow-n.slideCount)*n.slideWidth,r=(i+n.options.slidesToShow-n.slideCount)*t),n.slideCount<=n.options.slidesToShow&&(n.slideOffset=0,r=0),n.options.centerMode===!0&&n.slideCount<=n.options.slidesToShow?n.slideOffset=n.slideWidth*Math.floor(n.options.slidesToShow)/2-n.slideWidth*n.slideCount/2:n.options.centerMode===!0&&n.options.infinite===!0?n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)-n.slideWidth:n.options.centerMode===!0&&(n.slideOffset=0,n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)),e=n.options.vertical===!1?i*n.slideWidth*-1+n.slideOffset:i*t*-1+r,n.options.variableWidth===!0&&(o=n.slideCount<=n.options.slidesToShow||n.options.infinite===!1?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow),e=n.options.rtl===!0?o[0]?(n.$slideTrack.width()-o[0].offsetLeft-o.width())*-1:0:o[0]?o[0].offsetLeft*-1:0,n.options.centerMode===!0&&(o=n.slideCount<=n.options.slidesToShow||n.options.infinite===!1?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow+1),e=n.options.rtl===!0?o[0]?(n.$slideTrack.width()-o[0].offsetLeft-o.width())*-1:0:o[0]?o[0].offsetLeft*-1:0,e+=(n.$list.width()-o.outerWidth())/2)),e},e.prototype.getOption=e.prototype.slickGetOption=function(i){var e=this;return e.options[i]},e.prototype.getNavigableIndexes=function(){var i,e=this,t=0,o=0,s=[];for(e.options.infinite===!1?i=e.slideCount:(t=e.options.slidesToScroll*-1,o=e.options.slidesToScroll*-1,i=2*e.slideCount);t<i;)s.push(t),t=o+e.options.slidesToScroll,o+=e.options.slidesToScroll<=e.options.slidesToShow?e.options.slidesToScroll:e.options.slidesToShow;return s},e.prototype.getSlick=function(){return this},e.prototype.getSlideCount=function(){var e,t,o,s,n=this;return s=n.options.centerMode===!0?Math.floor(n.$list.width()/2):0,o=n.swipeLeft*-1+s,n.options.swipeToSlide===!0?(n.$slideTrack.find(\".slick-slide\").each(function(e,s){var r,l,d;if(r=i(s).outerWidth(),l=s.offsetLeft,n.options.centerMode!==!0&&(l+=r/2),d=l+r,o<d)return t=s,!1}),e=Math.abs(i(t).attr(\"data-slick-index\")-n.currentSlide)||1):n.options.slidesToScroll},e.prototype.goTo=e.prototype.slickGoTo=function(i,e){var t=this;t.changeSlide({data:{message:\"index\",index:parseInt(i)}},e)},e.prototype.init=function(e){var t=this;i(t.$slider).hasClass(\"slick-initialized\")||(i(t.$slider).addClass(\"slick-initialized\"),t.buildRows(),t.buildOut(),t.setProps(),t.startLoad(),t.loadSlider(),t.initializeEvents(),t.updateArrows(),t.updateDots(),t.checkResponsive(!0),t.focusHandler()),e&&t.$slider.trigger(\"init\",[t]),t.options.accessibility===!0&&t.initADA(),t.options.autoplay&&(t.paused=!1,t.autoPlay())},e.prototype.initADA=function(){var e=this,t=Math.ceil(e.slideCount/e.options.slidesToShow),o=e.getNavigableIndexes().filter(function(i){return i>=0&&i<e.slideCount});e.$slides.add(e.$slideTrack.find(\".slick-cloned\")).attr({\"aria-hidden\":\"true\",tabindex:\"-1\"}).find(\"a, input, button, select\").attr({tabindex:\"-1\"}),null!==e.$dots&&(e.$slides.not(e.$slideTrack.find(\".slick-cloned\")).each(function(t){var s=o.indexOf(t);if(i(this).attr({role:\"tabpanel\",id:\"slick-slide\"+e.instanceUid+t,tabindex:-1}),s!==-1){var n=\"slick-slide-control\"+e.instanceUid+s;i(\"#\"+n).length&&i(this).attr({\"aria-describedby\":n})}}),e.$dots.attr(\"role\",\"tablist\").find(\"li\").each(function(s){var n=o[s];i(this).attr({role:\"presentation\"}),i(this).find(\"button\").first().attr({role:\"tab\",id:\"slick-slide-control\"+e.instanceUid+s,\"aria-controls\":\"slick-slide\"+e.instanceUid+n,\"aria-label\":s+1+\" of \"+t,\"aria-selected\":null,tabindex:\"-1\"})}).eq(e.currentSlide).find(\"button\").attr({\"aria-selected\":\"true\",tabindex:\"0\"}).end());for(var s=e.currentSlide,n=s+e.options.slidesToShow;s<n;s++)e.options.focusOnChange?e.$slides.eq(s).attr({tabindex:\"0\"}):e.$slides.eq(s).removeAttr(\"tabindex\");e.activateADA()},e.prototype.initArrowEvents=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.off(\"click.slick\").on(\"click.slick\",{message:\"previous\"},i.changeSlide),i.$nextArrow.off(\"click.slick\").on(\"click.slick\",{message:\"next\"},i.changeSlide),i.options.accessibility===!0&&(i.$prevArrow.on(\"keydown.slick\",i.keyHandler),i.$nextArrow.on(\"keydown.slick\",i.keyHandler)))},e.prototype.initDotEvents=function(){var e=this;e.options.dots===!0&&e.slideCount>e.options.slidesToShow&&(i(\"li\",e.$dots).on(\"click.slick\",{message:\"index\"},e.changeSlide),e.options.accessibility===!0&&e.$dots.on(\"keydown.slick\",e.keyHandler)),e.options.dots===!0&&e.options.pauseOnDotsHover===!0&&e.slideCount>e.options.slidesToShow&&i(\"li\",e.$dots).on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.initSlideEvents=function(){var e=this;e.options.pauseOnHover&&(e.$list.on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)))},e.prototype.initializeEvents=function(){var e=this;e.initArrowEvents(),e.initDotEvents(),e.initSlideEvents(),e.$list.on(\"touchstart.slick mousedown.slick\",{action:\"start\"},e.swipeHandler),e.$list.on(\"touchmove.slick mousemove.slick\",{action:\"move\"},e.swipeHandler),e.$list.on(\"touchend.slick mouseup.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"touchcancel.slick mouseleave.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"click.slick\",e.clickHandler),i(document).on(e.visibilityChange,i.proxy(e.visibility,e)),e.options.accessibility===!0&&e.$list.on(\"keydown.slick\",e.keyHandler),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),i(window).on(\"orientationchange.slick.slick-\"+e.instanceUid,i.proxy(e.orientationChange,e)),i(window).on(\"resize.slick.slick-\"+e.instanceUid,i.proxy(e.resize,e)),i(\"[draggable!=true]\",e.$slideTrack).on(\"dragstart\",e.preventDefault),i(window).on(\"load.slick.slick-\"+e.instanceUid,e.setPosition),i(e.setPosition)},e.prototype.initUI=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.show(),i.$nextArrow.show()),i.options.dots===!0&&i.slideCount>i.options.slidesToShow&&i.$dots.show()},e.prototype.keyHandler=function(i){var e=this;i.target.tagName.match(\"TEXTAREA|INPUT|SELECT\")||(37===i.keyCode&&e.options.accessibility===!0?e.changeSlide({data:{message:e.options.rtl===!0?\"next\":\"previous\"}}):39===i.keyCode&&e.options.accessibility===!0&&e.changeSlide({data:{message:e.options.rtl===!0?\"previous\":\"next\"}}))},e.prototype.lazyLoad=function(){function e(e){i(\"img[data-lazy]\",e).each(function(){var e=i(this),t=i(this).attr(\"data-lazy\"),o=i(this).attr(\"data-srcset\"),s=i(this).attr(\"data-sizes\")||r.$slider.attr(\"data-sizes\"),n=document.createElement(\"img\");n.onload=function(){e.animate({opacity:0},100,function(){o&&(e.attr(\"srcset\",o),s&&e.attr(\"sizes\",s)),e.attr(\"src\",t).animate({opacity:1},200,function(){e.removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\")}),r.$slider.trigger(\"lazyLoaded\",[r,e,t])})},n.onerror=function(){e.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),r.$slider.trigger(\"lazyLoadError\",[r,e,t])},n.src=t})}var t,o,s,n,r=this;if(r.options.centerMode===!0?r.options.infinite===!0?(s=r.currentSlide+(r.options.slidesToShow/2+1),n=s+r.options.slidesToShow+2):(s=Math.max(0,r.currentSlide-(r.options.slidesToShow/2+1)),n=2+(r.options.slidesToShow/2+1)+r.currentSlide):(s=r.options.infinite?r.options.slidesToShow+r.currentSlide:r.currentSlide,n=Math.ceil(s+r.options.slidesToShow),r.options.fade===!0&&(s>0&&s--,n<=r.slideCount&&n++)),t=r.$slider.find(\".slick-slide\").slice(s,n),\"anticipated\"===r.options.lazyLoad)for(var l=s-1,d=n,a=r.$slider.find(\".slick-slide\"),c=0;c<r.options.slidesToScroll;c++)l<0&&(l=r.slideCount-1),t=t.add(a.eq(l)),t=t.add(a.eq(d)),l--,d++;e(t),r.slideCount<=r.options.slidesToShow?(o=r.$slider.find(\".slick-slide\"),e(o)):r.currentSlide>=r.slideCount-r.options.slidesToShow?(o=r.$slider.find(\".slick-cloned\").slice(0,r.options.slidesToShow),e(o)):0===r.currentSlide&&(o=r.$slider.find(\".slick-cloned\").slice(r.options.slidesToShow*-1),e(o))},e.prototype.loadSlider=function(){var i=this;i.setPosition(),i.$slideTrack.css({opacity:1}),i.$slider.removeClass(\"slick-loading\"),i.initUI(),\"progressive\"===i.options.lazyLoad&&i.progressiveLazyLoad()},e.prototype.next=e.prototype.slickNext=function(){var i=this;i.changeSlide({data:{message:\"next\"}})},e.prototype.orientationChange=function(){var i=this;i.checkResponsive(),i.setPosition()},e.prototype.pause=e.prototype.slickPause=function(){var i=this;i.autoPlayClear(),i.paused=!0},e.prototype.play=e.prototype.slickPlay=function(){var i=this;i.autoPlay(),i.options.autoplay=!0,i.paused=!1,i.focussed=!1,i.interrupted=!1},e.prototype.postSlide=function(e){var t=this;if(!t.unslicked&&(t.$slider.trigger(\"afterChange\",[t,e]),t.animating=!1,t.slideCount>t.options.slidesToShow&&t.setPosition(),t.swipeLeft=null,t.options.autoplay&&t.autoPlay(),t.options.accessibility===!0&&(t.initADA(),t.options.focusOnChange))){var o=i(t.$slides.get(t.currentSlide));o.attr(\"tabindex\",0).focus()}},e.prototype.prev=e.prototype.slickPrev=function(){var i=this;i.changeSlide({data:{message:\"previous\"}})},e.prototype.preventDefault=function(i){i.preventDefault()},e.prototype.progressiveLazyLoad=function(e){e=e||1;var t,o,s,n,r,l=this,d=i(\"img[data-lazy]\",l.$slider);d.length?(t=d.first(),o=t.attr(\"data-lazy\"),s=t.attr(\"data-srcset\"),n=t.attr(\"data-sizes\")||l.$slider.attr(\"data-sizes\"),r=document.createElement(\"img\"),r.onload=function(){s&&(t.attr(\"srcset\",s),n&&t.attr(\"sizes\",n)),t.attr(\"src\",o).removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\"),l.options.adaptiveHeight===!0&&l.setPosition(),l.$slider.trigger(\"lazyLoaded\",[l,t,o]),l.progressiveLazyLoad()},r.onerror=function(){e<3?setTimeout(function(){l.progressiveLazyLoad(e+1)},500):(t.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),l.$slider.trigger(\"lazyLoadError\",[l,t,o]),l.progressiveLazyLoad())},r.src=o):l.$slider.trigger(\"allImagesLoaded\",[l])},e.prototype.refresh=function(e){var t,o,s=this;o=s.slideCount-s.options.slidesToShow,!s.options.infinite&&s.currentSlide>o&&(s.currentSlide=o),s.slideCount<=s.options.slidesToShow&&(s.currentSlide=0),t=s.currentSlide,s.destroy(!0),i.extend(s,s.initials,{currentSlide:t}),s.init(),e||s.changeSlide({data:{message:\"index\",index:t}},!1)},e.prototype.registerBreakpoints=function(){var e,t,o,s=this,n=s.options.responsive||null;if(\"array\"===i.type(n)&&n.length){s.respondTo=s.options.respondTo||\"window\";for(e in n)if(o=s.breakpoints.length-1,n.hasOwnProperty(e)){for(t=n[e].breakpoint;o>=0;)s.breakpoints[o]&&s.breakpoints[o]===t&&s.breakpoints.splice(o,1),o--;s.breakpoints.push(t),s.breakpointSettings[t]=n[e].settings}s.breakpoints.sort(function(i,e){return s.options.mobileFirst?i-e:e-i})}},e.prototype.reinit=function(){var e=this;e.$slides=e.$slideTrack.children(e.options.slide).addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.currentSlide>=e.slideCount&&0!==e.currentSlide&&(e.currentSlide=e.currentSlide-e.options.slidesToScroll),e.slideCount<=e.options.slidesToShow&&(e.currentSlide=0),e.registerBreakpoints(),e.setProps(),e.setupInfinite(),e.buildArrows(),e.updateArrows(),e.initArrowEvents(),e.buildDots(),e.updateDots(),e.initDotEvents(),e.cleanUpSlideEvents(),e.initSlideEvents(),e.checkResponsive(!1,!0),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.setPosition(),e.focusHandler(),e.paused=!e.options.autoplay,e.autoPlay(),e.$slider.trigger(\"reInit\",[e])},e.prototype.resize=function(){var e=this;i(window).width()!==e.windowWidth&&(clearTimeout(e.windowDelay),e.windowDelay=window.setTimeout(function(){e.windowWidth=i(window).width(),e.checkResponsive(),e.unslicked||e.setPosition()},50))},e.prototype.removeSlide=e.prototype.slickRemove=function(i,e,t){var o=this;return\"boolean\"==typeof i?(e=i,i=e===!0?0:o.slideCount-1):i=e===!0?--i:i,!(o.slideCount<1||i<0||i>o.slideCount-1)&&(o.unload(),t===!0?o.$slideTrack.children().remove():o.$slideTrack.children(this.options.slide).eq(i).remove(),o.$slides=o.$slideTrack.children(this.options.slide),o.$slideTrack.children(this.options.slide).detach(),o.$slideTrack.append(o.$slides),o.$slidesCache=o.$slides,void o.reinit())},e.prototype.setCSS=function(i){var e,t,o=this,s={};o.options.rtl===!0&&(i=-i),e=\"left\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",t=\"top\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",s[o.positionProp]=i,o.transformsEnabled===!1?o.$slideTrack.css(s):(s={},o.cssTransitions===!1?(s[o.animType]=\"translate(\"+e+\", \"+t+\")\",o.$slideTrack.css(s)):(s[o.animType]=\"translate3d(\"+e+\", \"+t+\", 0px)\",o.$slideTrack.css(s)))},e.prototype.setDimensions=function(){var i=this;i.options.vertical===!1?i.options.centerMode===!0&&i.$list.css({padding:\"0px \"+i.options.centerPadding}):(i.$list.height(i.$slides.first().outerHeight(!0)*i.options.slidesToShow),i.options.centerMode===!0&&i.$list.css({padding:i.options.centerPadding+\" 0px\"})),i.listWidth=i.$list.width(),i.listHeight=i.$list.height(),i.options.vertical===!1&&i.options.variableWidth===!1?(i.slideWidth=Math.ceil(i.listWidth/i.options.slidesToShow),i.$slideTrack.width(Math.ceil(i.slideWidth*i.$slideTrack.children(\".slick-slide\").length))):i.options.variableWidth===!0?i.$slideTrack.width(5e3*i.slideCount):(i.slideWidth=Math.ceil(i.listWidth),i.$slideTrack.height(Math.ceil(i.$slides.first().outerHeight(!0)*i.$slideTrack.children(\".slick-slide\").length)));var e=i.$slides.first().outerWidth(!0)-i.$slides.first().width();i.options.variableWidth===!1&&i.$slideTrack.children(\".slick-slide\").width(i.slideWidth-e)},e.prototype.setFade=function(){var e,t=this;t.$slides.each(function(o,s){e=t.slideWidth*o*-1,t.options.rtl===!0?i(s).css({position:\"relative\",right:e,top:0,zIndex:t.options.zIndex-2,opacity:0}):i(s).css({position:\"relative\",left:e,top:0,zIndex:t.options.zIndex-2,opacity:0})}),t.$slides.eq(t.currentSlide).css({zIndex:t.options.zIndex-1,opacity:1})},e.prototype.setHeight=function(){var i=this;if(1===i.options.slidesToShow&&i.options.adaptiveHeight===!0&&i.options.vertical===!1){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.css(\"height\",e)}},e.prototype.setOption=e.prototype.slickSetOption=function(){var e,t,o,s,n,r=this,l=!1;if(\"object\"===i.type(arguments[0])?(o=arguments[0],l=arguments[1],n=\"multiple\"):\"string\"===i.type(arguments[0])&&(o=arguments[0],s=arguments[1],l=arguments[2],\"responsive\"===arguments[0]&&\"array\"===i.type(arguments[1])?n=\"responsive\":\"undefined\"!=typeof arguments[1]&&(n=\"single\")),\"single\"===n)r.options[o]=s;else if(\"multiple\"===n)i.each(o,function(i,e){r.options[i]=e});else if(\"responsive\"===n)for(t in s)if(\"array\"!==i.type(r.options.responsive))r.options.responsive=[s[t]];else{for(e=r.options.responsive.length-1;e>=0;)r.options.responsive[e].breakpoint===s[t].breakpoint&&r.options.responsive.splice(e,1),e--;r.options.responsive.push(s[t])}l&&(r.unload(),r.reinit())},e.prototype.setPosition=function(){var i=this;i.setDimensions(),i.setHeight(),i.options.fade===!1?i.setCSS(i.getLeft(i.currentSlide)):i.setFade(),i.$slider.trigger(\"setPosition\",[i])},e.prototype.setProps=function(){var i=this,e=document.body.style;i.positionProp=i.options.vertical===!0?\"top\":\"left\",\n\"top\"===i.positionProp?i.$slider.addClass(\"slick-vertical\"):i.$slider.removeClass(\"slick-vertical\"),void 0===e.WebkitTransition&&void 0===e.MozTransition&&void 0===e.msTransition||i.options.useCSS===!0&&(i.cssTransitions=!0),i.options.fade&&(\"number\"==typeof i.options.zIndex?i.options.zIndex<3&&(i.options.zIndex=3):i.options.zIndex=i.defaults.zIndex),void 0!==e.OTransform&&(i.animType=\"OTransform\",i.transformType=\"-o-transform\",i.transitionType=\"OTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.MozTransform&&(i.animType=\"MozTransform\",i.transformType=\"-moz-transform\",i.transitionType=\"MozTransition\",void 0===e.perspectiveProperty&&void 0===e.MozPerspective&&(i.animType=!1)),void 0!==e.webkitTransform&&(i.animType=\"webkitTransform\",i.transformType=\"-webkit-transform\",i.transitionType=\"webkitTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.msTransform&&(i.animType=\"msTransform\",i.transformType=\"-ms-transform\",i.transitionType=\"msTransition\",void 0===e.msTransform&&(i.animType=!1)),void 0!==e.transform&&i.animType!==!1&&(i.animType=\"transform\",i.transformType=\"transform\",i.transitionType=\"transition\"),i.transformsEnabled=i.options.useTransform&&null!==i.animType&&i.animType!==!1},e.prototype.setSlideClasses=function(i){var e,t,o,s,n=this;if(t=n.$slider.find(\".slick-slide\").removeClass(\"slick-active slick-center slick-current\").attr(\"aria-hidden\",\"true\"),n.$slides.eq(i).addClass(\"slick-current\"),n.options.centerMode===!0){var r=n.options.slidesToShow%2===0?1:0;e=Math.floor(n.options.slidesToShow/2),n.options.infinite===!0&&(i>=e&&i<=n.slideCount-1-e?n.$slides.slice(i-e+r,i+e+1).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(o=n.options.slidesToShow+i,t.slice(o-e+1+r,o+e+2).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\")),0===i?t.eq(t.length-1-n.options.slidesToShow).addClass(\"slick-center\"):i===n.slideCount-1&&t.eq(n.options.slidesToShow).addClass(\"slick-center\")),n.$slides.eq(i).addClass(\"slick-center\")}else i>=0&&i<=n.slideCount-n.options.slidesToShow?n.$slides.slice(i,i+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.length<=n.options.slidesToShow?t.addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(s=n.slideCount%n.options.slidesToShow,o=n.options.infinite===!0?n.options.slidesToShow+i:i,n.options.slidesToShow==n.options.slidesToScroll&&n.slideCount-i<n.options.slidesToShow?t.slice(o-(n.options.slidesToShow-s),o+s).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.slice(o,o+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"));\"ondemand\"!==n.options.lazyLoad&&\"anticipated\"!==n.options.lazyLoad||n.lazyLoad()},e.prototype.setupInfinite=function(){var e,t,o,s=this;if(s.options.fade===!0&&(s.options.centerMode=!1),s.options.infinite===!0&&s.options.fade===!1&&(t=null,s.slideCount>s.options.slidesToShow)){for(o=s.options.centerMode===!0?s.options.slidesToShow+1:s.options.slidesToShow,e=s.slideCount;e>s.slideCount-o;e-=1)t=e-1,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t-s.slideCount).prependTo(s.$slideTrack).addClass(\"slick-cloned\");for(e=0;e<o+s.slideCount;e+=1)t=e,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t+s.slideCount).appendTo(s.$slideTrack).addClass(\"slick-cloned\");s.$slideTrack.find(\".slick-cloned\").find(\"[id]\").each(function(){i(this).attr(\"id\",\"\")})}},e.prototype.interrupt=function(i){var e=this;i||e.autoPlay(),e.interrupted=i},e.prototype.selectHandler=function(e){var t=this,o=i(e.target).is(\".slick-slide\")?i(e.target):i(e.target).parents(\".slick-slide\"),s=parseInt(o.attr(\"data-slick-index\"));return s||(s=0),t.slideCount<=t.options.slidesToShow?void t.slideHandler(s,!1,!0):void t.slideHandler(s)},e.prototype.slideHandler=function(i,e,t){var o,s,n,r,l,d=null,a=this;if(e=e||!1,!(a.animating===!0&&a.options.waitForAnimate===!0||a.options.fade===!0&&a.currentSlide===i))return e===!1&&a.asNavFor(i),o=i,d=a.getLeft(o),r=a.getLeft(a.currentSlide),a.currentLeft=null===a.swipeLeft?r:a.swipeLeft,a.options.infinite===!1&&a.options.centerMode===!1&&(i<0||i>a.getDotCount()*a.options.slidesToScroll)?void(a.options.fade===!1&&(o=a.currentSlide,t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o))):a.options.infinite===!1&&a.options.centerMode===!0&&(i<0||i>a.slideCount-a.options.slidesToScroll)?void(a.options.fade===!1&&(o=a.currentSlide,t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o))):(a.options.autoplay&&clearInterval(a.autoPlayTimer),s=o<0?a.slideCount%a.options.slidesToScroll!==0?a.slideCount-a.slideCount%a.options.slidesToScroll:a.slideCount+o:o>=a.slideCount?a.slideCount%a.options.slidesToScroll!==0?0:o-a.slideCount:o,a.animating=!0,a.$slider.trigger(\"beforeChange\",[a,a.currentSlide,s]),n=a.currentSlide,a.currentSlide=s,a.setSlideClasses(a.currentSlide),a.options.asNavFor&&(l=a.getNavTarget(),l=l.slick(\"getSlick\"),l.slideCount<=l.options.slidesToShow&&l.setSlideClasses(a.currentSlide)),a.updateDots(),a.updateArrows(),a.options.fade===!0?(t!==!0?(a.fadeSlideOut(n),a.fadeSlide(s,function(){a.postSlide(s)})):a.postSlide(s),void a.animateHeight()):void(t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(d,function(){a.postSlide(s)}):a.postSlide(s)))},e.prototype.startLoad=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.hide(),i.$nextArrow.hide()),i.options.dots===!0&&i.slideCount>i.options.slidesToShow&&i.$dots.hide(),i.$slider.addClass(\"slick-loading\")},e.prototype.swipeDirection=function(){var i,e,t,o,s=this;return i=s.touchObject.startX-s.touchObject.curX,e=s.touchObject.startY-s.touchObject.curY,t=Math.atan2(e,i),o=Math.round(180*t/Math.PI),o<0&&(o=360-Math.abs(o)),o<=45&&o>=0?s.options.rtl===!1?\"left\":\"right\":o<=360&&o>=315?s.options.rtl===!1?\"left\":\"right\":o>=135&&o<=225?s.options.rtl===!1?\"right\":\"left\":s.options.verticalSwiping===!0?o>=35&&o<=135?\"down\":\"up\":\"vertical\"},e.prototype.swipeEnd=function(i){var e,t,o=this;if(o.dragging=!1,o.swiping=!1,o.scrolling)return o.scrolling=!1,!1;if(o.interrupted=!1,o.shouldClick=!(o.touchObject.swipeLength>10),void 0===o.touchObject.curX)return!1;if(o.touchObject.edgeHit===!0&&o.$slider.trigger(\"edge\",[o,o.swipeDirection()]),o.touchObject.swipeLength>=o.touchObject.minSwipe){switch(t=o.swipeDirection()){case\"left\":case\"down\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide+o.getSlideCount()):o.currentSlide+o.getSlideCount(),o.currentDirection=0;break;case\"right\":case\"up\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide-o.getSlideCount()):o.currentSlide-o.getSlideCount(),o.currentDirection=1}\"vertical\"!=t&&(o.slideHandler(e),o.touchObject={},o.$slider.trigger(\"swipe\",[o,t]))}else o.touchObject.startX!==o.touchObject.curX&&(o.slideHandler(o.currentSlide),o.touchObject={})},e.prototype.swipeHandler=function(i){var e=this;if(!(e.options.swipe===!1||\"ontouchend\"in document&&e.options.swipe===!1||e.options.draggable===!1&&i.type.indexOf(\"mouse\")!==-1))switch(e.touchObject.fingerCount=i.originalEvent&&void 0!==i.originalEvent.touches?i.originalEvent.touches.length:1,e.touchObject.minSwipe=e.listWidth/e.options.touchThreshold,e.options.verticalSwiping===!0&&(e.touchObject.minSwipe=e.listHeight/e.options.touchThreshold),i.data.action){case\"start\":e.swipeStart(i);break;case\"move\":e.swipeMove(i);break;case\"end\":e.swipeEnd(i)}},e.prototype.swipeMove=function(i){var e,t,o,s,n,r,l=this;return n=void 0!==i.originalEvent?i.originalEvent.touches:null,!(!l.dragging||l.scrolling||n&&1!==n.length)&&(e=l.getLeft(l.currentSlide),l.touchObject.curX=void 0!==n?n[0].pageX:i.clientX,l.touchObject.curY=void 0!==n?n[0].pageY:i.clientY,l.touchObject.swipeLength=Math.round(Math.sqrt(Math.pow(l.touchObject.curX-l.touchObject.startX,2))),r=Math.round(Math.sqrt(Math.pow(l.touchObject.curY-l.touchObject.startY,2))),!l.options.verticalSwiping&&!l.swiping&&r>4?(l.scrolling=!0,!1):(l.options.verticalSwiping===!0&&(l.touchObject.swipeLength=r),t=l.swipeDirection(),void 0!==i.originalEvent&&l.touchObject.swipeLength>4&&(l.swiping=!0,i.preventDefault()),s=(l.options.rtl===!1?1:-1)*(l.touchObject.curX>l.touchObject.startX?1:-1),l.options.verticalSwiping===!0&&(s=l.touchObject.curY>l.touchObject.startY?1:-1),o=l.touchObject.swipeLength,l.touchObject.edgeHit=!1,l.options.infinite===!1&&(0===l.currentSlide&&\"right\"===t||l.currentSlide>=l.getDotCount()&&\"left\"===t)&&(o=l.touchObject.swipeLength*l.options.edgeFriction,l.touchObject.edgeHit=!0),l.options.vertical===!1?l.swipeLeft=e+o*s:l.swipeLeft=e+o*(l.$list.height()/l.listWidth)*s,l.options.verticalSwiping===!0&&(l.swipeLeft=e+o*s),l.options.fade!==!0&&l.options.touchMove!==!1&&(l.animating===!0?(l.swipeLeft=null,!1):void l.setCSS(l.swipeLeft))))},e.prototype.swipeStart=function(i){var e,t=this;return t.interrupted=!0,1!==t.touchObject.fingerCount||t.slideCount<=t.options.slidesToShow?(t.touchObject={},!1):(void 0!==i.originalEvent&&void 0!==i.originalEvent.touches&&(e=i.originalEvent.touches[0]),t.touchObject.startX=t.touchObject.curX=void 0!==e?e.pageX:i.clientX,t.touchObject.startY=t.touchObject.curY=void 0!==e?e.pageY:i.clientY,void(t.dragging=!0))},e.prototype.unfilterSlides=e.prototype.slickUnfilter=function(){var i=this;null!==i.$slidesCache&&(i.unload(),i.$slideTrack.children(this.options.slide).detach(),i.$slidesCache.appendTo(i.$slideTrack),i.reinit())},e.prototype.unload=function(){var e=this;i(\".slick-cloned\",e.$slider).remove(),e.$dots&&e.$dots.remove(),e.$prevArrow&&e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.remove(),e.$nextArrow&&e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.remove(),e.$slides.removeClass(\"slick-slide slick-active slick-visible slick-current\").attr(\"aria-hidden\",\"true\").css(\"width\",\"\")},e.prototype.unslick=function(i){var e=this;e.$slider.trigger(\"unslick\",[e,i]),e.destroy()},e.prototype.updateArrows=function(){var i,e=this;i=Math.floor(e.options.slidesToShow/2),e.options.arrows===!0&&e.slideCount>e.options.slidesToShow&&!e.options.infinite&&(e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),e.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),0===e.currentSlide?(e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):e.currentSlide>=e.slideCount-e.options.slidesToShow&&e.options.centerMode===!1?(e.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):e.currentSlide>=e.slideCount-1&&e.options.centerMode===!0&&(e.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")))},e.prototype.updateDots=function(){var i=this;null!==i.$dots&&(i.$dots.find(\"li\").removeClass(\"slick-active\").end(),i.$dots.find(\"li\").eq(Math.floor(i.currentSlide/i.options.slidesToScroll)).addClass(\"slick-active\"))},e.prototype.visibility=function(){var i=this;i.options.autoplay&&(document[i.hidden]?i.interrupted=!0:i.interrupted=!1)},i.fn.slick=function(){var i,t,o=this,s=arguments[0],n=Array.prototype.slice.call(arguments,1),r=o.length;for(i=0;i<r;i++)if(\"object\"==typeof s||\"undefined\"==typeof s?o[i].slick=new e(o[i],s):t=o[i].slick[s].apply(o[i].slick,n),\"undefined\"!=typeof t)return t;return o}});\n","Magento_PageBuilder/js/resource/jarallax/jarallax-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/resource/jarallax/jarallax'\n], function(jarallax){\n    'use strict';\n\n    window.jarallax = window.jarallax || jarallax;\n});\n","Magento_PageBuilder/js/resource/jarallax/jarallax-video.js":"/*!\n * Video Extension for Jarallax v2.0.3 (https://github.com/nk-o/jarallax)\n * Copyright 2022 nK <https://nkdev.info>\n * Licensed under MIT (https://github.com/nk-o/jarallax/blob/master/LICENSE)\n */\n\n(function (global, factory) {\n  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n      typeof define === 'function' && define.amd ? define(factory) :\n          (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.jarallaxVideo = factory());\n})(this, (function () { 'use strict';\n\n  /*!\n   * Name    : Video Worker\n   * Version : 2.0.0\n   * Author  : nK <https://nkdev.info>\n   * GitHub  : https://github.com/nk-o/video-worker\n   */\n\n  /* eslint-disable import/no-mutable-exports */\n\n  /* eslint-disable no-restricted-globals */\n  let win$1;\n\n  if (typeof window !== 'undefined') {\n    win$1 = window;\n  } else if (typeof global !== 'undefined') {\n    win$1 = global;\n  } else if (typeof self !== 'undefined') {\n    win$1 = self;\n  } else {\n    win$1 = {};\n  }\n\n  var global$1$1 = win$1; // Deferred\n  // thanks http://stackoverflow.com/questions/18096715/implement-deferred-object-without-using-jquery\n\n  function Deferred() {\n    this.doneCallbacks = [];\n    this.failCallbacks = [];\n  }\n\n  Deferred.prototype = {\n    execute(list, args) {\n      let i = list.length; // eslint-disable-next-line no-param-reassign\n\n      args = Array.prototype.slice.call(args);\n\n      while (i) {\n        i -= 1;\n        list[i].apply(null, args);\n      }\n    },\n\n    resolve(...args) {\n      this.execute(this.doneCallbacks, args);\n    },\n\n    reject(...args) {\n      this.execute(this.failCallbacks, args);\n    },\n\n    done(callback) {\n      this.doneCallbacks.push(callback);\n    },\n\n    fail(callback) {\n      this.failCallbacks.push(callback);\n    }\n\n  };\n  let ID = 0;\n  let YoutubeAPIadded = 0;\n  let VimeoAPIadded = 0;\n  let loadingYoutubePlayer = 0;\n  let loadingVimeoPlayer = 0;\n  const loadingYoutubeDefer = /*#__PURE__*/new Deferred();\n  const loadingVimeoDefer = /*#__PURE__*/new Deferred();\n\n  class VideoWorker {\n    constructor(url, options) {\n      const self = this;\n      self.url = url;\n      self.options_default = {\n        autoplay: false,\n        loop: false,\n        mute: false,\n        volume: 100,\n        showControls: true,\n        accessibilityHidden: false,\n        // start / end video time in seconds\n        startTime: 0,\n        endTime: 0\n      };\n      self.options = self.extend({}, self.options_default, options); // Fix wrong option name.\n      // Thanks to https://github.com/nk-o/video-worker/issues/13.\n\n      if (typeof self.options.showContols !== 'undefined') {\n        self.options.showControls = self.options.showContols;\n        delete self.options.showContols;\n      } // check URL\n\n\n      self.videoID = self.parseURL(url); // init\n\n      if (self.videoID) {\n        self.ID = ID;\n        ID += 1;\n        self.loadAPI();\n        self.init();\n      }\n    } // Extend like jQuery.extend\n    // eslint-disable-next-line class-methods-use-this\n\n\n    extend(...args) {\n      const out = args[0] || {};\n      Object.keys(args).forEach(i => {\n        if (!args[i]) {\n          return;\n        }\n\n        Object.keys(args[i]).forEach(key => {\n          out[key] = args[i][key];\n        });\n      });\n      return out;\n    }\n\n    parseURL(url) {\n      // parse youtube ID\n      function getYoutubeID(ytUrl) {\n        // eslint-disable-next-line no-useless-escape\n        const regExp = /.*(?:youtu.be\\/|v\\/|u\\/\\w\\/|embed\\/|watch\\?v=)([^#\\&\\?]*).*/;\n        const match = ytUrl.match(regExp);\n        return match && match[1].length === 11 ? match[1] : false;\n      } // parse vimeo ID\n\n\n      function getVimeoID(vmUrl) {\n        // eslint-disable-next-line no-useless-escape\n        const regExp = /https?:\\/\\/(?:www\\.|player\\.)?vimeo.com\\/(?:channels\\/(?:\\w+\\/)?|groups\\/([^/]*)\\/videos\\/|album\\/(\\d+)\\/video\\/|video\\/|)(\\d+)(?:$|\\/|\\?)/;\n        const match = vmUrl.match(regExp);\n        return match && match[3] ? match[3] : false;\n      } // parse local string\n\n\n      function getLocalVideos(locUrl) {\n        // eslint-disable-next-line no-useless-escape\n        const videoFormats = locUrl.split(/,(?=mp4\\:|webm\\:|ogv\\:|ogg\\:)/);\n        const result = {};\n        let ready = 0;\n        videoFormats.forEach(val => {\n          // eslint-disable-next-line no-useless-escape\n          const match = val.match(/^(mp4|webm|ogv|ogg)\\:(.*)/);\n\n          if (match && match[1] && match[2]) {\n            // eslint-disable-next-line prefer-destructuring\n            result[match[1] === 'ogv' ? 'ogg' : match[1]] = match[2];\n            ready = 1;\n          }\n        });\n        return ready ? result : false;\n      }\n\n      const Youtube = getYoutubeID(url);\n      const Vimeo = getVimeoID(url);\n      const Local = getLocalVideos(url);\n\n      if (Youtube) {\n        this.type = 'youtube';\n        return Youtube;\n      }\n\n      if (Vimeo) {\n        this.type = 'vimeo';\n        return Vimeo;\n      }\n\n      if (Local) {\n        this.type = 'local';\n        return Local;\n      }\n\n      return false;\n    }\n\n    isValid() {\n      return !!this.videoID;\n    } // events\n\n\n    on(name, callback) {\n      this.userEventsList = this.userEventsList || []; // add new callback in events list\n\n      (this.userEventsList[name] || (this.userEventsList[name] = [])).push(callback);\n    }\n\n    off(name, callback) {\n      if (!this.userEventsList || !this.userEventsList[name]) {\n        return;\n      }\n\n      if (!callback) {\n        delete this.userEventsList[name];\n      } else {\n        this.userEventsList[name].forEach((val, key) => {\n          if (val === callback) {\n            this.userEventsList[name][key] = false;\n          }\n        });\n      }\n    }\n\n    fire(name, ...args) {\n      if (this.userEventsList && typeof this.userEventsList[name] !== 'undefined') {\n        this.userEventsList[name].forEach(val => {\n          // call with all arguments\n          if (val) {\n            val.apply(this, args);\n          }\n        });\n      }\n    }\n\n    play(start) {\n      const self = this;\n\n      if (!self.player) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.playVideo) {\n        if (typeof start !== 'undefined') {\n          self.player.seekTo(start || 0);\n        }\n\n        if (global$1$1.YT.PlayerState.PLAYING !== self.player.getPlayerState()) {\n          self.player.playVideo();\n        }\n      }\n\n      if (self.type === 'vimeo') {\n        if (typeof start !== 'undefined') {\n          self.player.setCurrentTime(start);\n        }\n\n        self.player.getPaused().then(paused => {\n          if (paused) {\n            self.player.play();\n          }\n        });\n      }\n\n      if (self.type === 'local') {\n        if (typeof start !== 'undefined') {\n          self.player.currentTime = start;\n        }\n\n        if (self.player.paused) {\n          self.player.play();\n        }\n      }\n    }\n\n    pause() {\n      const self = this;\n\n      if (!self.player) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.pauseVideo) {\n        if (global$1$1.YT.PlayerState.PLAYING === self.player.getPlayerState()) {\n          self.player.pauseVideo();\n        }\n      }\n\n      if (self.type === 'vimeo') {\n        self.player.getPaused().then(paused => {\n          if (!paused) {\n            self.player.pause();\n          }\n        });\n      }\n\n      if (self.type === 'local') {\n        if (!self.player.paused) {\n          self.player.pause();\n        }\n      }\n    }\n\n    mute() {\n      const self = this;\n\n      if (!self.player) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.mute) {\n        self.player.mute();\n      }\n\n      if (self.type === 'vimeo' && self.player.setVolume) {\n        self.player.setVolume(0);\n      }\n\n      if (self.type === 'local') {\n        self.$video.muted = true;\n      }\n    }\n\n    unmute() {\n      const self = this;\n\n      if (!self.player) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.mute) {\n        self.player.unMute();\n      }\n\n      if (self.type === 'vimeo' && self.player.setVolume) {\n        self.player.setVolume(self.options.volume);\n      }\n\n      if (self.type === 'local') {\n        self.$video.muted = false;\n      }\n    }\n\n    setVolume(volume = false) {\n      const self = this;\n\n      if (!self.player || !volume) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.setVolume) {\n        self.player.setVolume(volume);\n      }\n\n      if (self.type === 'vimeo' && self.player.setVolume) {\n        self.player.setVolume(volume);\n      }\n\n      if (self.type === 'local') {\n        self.$video.volume = volume / 100;\n      }\n    }\n\n    getVolume(callback) {\n      const self = this;\n\n      if (!self.player) {\n        callback(false);\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.getVolume) {\n        callback(self.player.getVolume());\n      }\n\n      if (self.type === 'vimeo' && self.player.getVolume) {\n        self.player.getVolume().then(volume => {\n          callback(volume);\n        });\n      }\n\n      if (self.type === 'local') {\n        callback(self.$video.volume * 100);\n      }\n    }\n\n    getMuted(callback) {\n      const self = this;\n\n      if (!self.player) {\n        callback(null);\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.isMuted) {\n        callback(self.player.isMuted());\n      }\n\n      if (self.type === 'vimeo' && self.player.getVolume) {\n        self.player.getVolume().then(volume => {\n          callback(!!volume);\n        });\n      }\n\n      if (self.type === 'local') {\n        callback(self.$video.muted);\n      }\n    }\n\n    getImageURL(callback) {\n      const self = this;\n\n      if (self.videoImage) {\n        callback(self.videoImage);\n        return;\n      }\n\n      if (self.type === 'youtube') {\n        const availableSizes = ['maxresdefault', 'sddefault', 'hqdefault', '0'];\n        let step = 0;\n        const tempImg = new Image();\n\n        tempImg.onload = function () {\n          // if no thumbnail, youtube add their own image with width = 120px\n          if ((this.naturalWidth || this.width) !== 120 || step === availableSizes.length - 1) {\n            // ok\n            self.videoImage = `https://img.youtube.com/vi/${self.videoID}/${availableSizes[step]}.jpg`;\n            callback(self.videoImage);\n          } else {\n            // try another size\n            step += 1;\n            this.src = `https://img.youtube.com/vi/${self.videoID}/${availableSizes[step]}.jpg`;\n          }\n        };\n\n        tempImg.src = `https://img.youtube.com/vi/${self.videoID}/${availableSizes[step]}.jpg`;\n      }\n\n      if (self.type === 'vimeo') {\n        let request = new XMLHttpRequest(); // https://vimeo.com/api/oembed.json?url=https://vimeo.com/235212527\n\n        request.open('GET', `https://vimeo.com/api/oembed.json?url=${self.url}`, true);\n\n        request.onreadystatechange = function () {\n          if (this.readyState === 4) {\n            if (this.status >= 200 && this.status < 400) {\n              // Success!\n              const response = JSON.parse(this.responseText);\n\n              if (response.thumbnail_url) {\n                self.videoImage = response.thumbnail_url;\n                callback(self.videoImage);\n              }\n            }\n          }\n        };\n\n        request.send();\n        request = null;\n      }\n    } // fallback to the old version.\n\n\n    getIframe(callback) {\n      this.getVideo(callback);\n    }\n\n    getVideo(callback) {\n      const self = this; // return generated video block\n\n      if (self.$video) {\n        callback(self.$video);\n        return;\n      } // generate new video block\n\n\n      self.onAPIready(() => {\n        let hiddenDiv;\n\n        if (!self.$video) {\n          hiddenDiv = document.createElement('div');\n          hiddenDiv.style.display = 'none';\n        } // Youtube\n\n\n        if (self.type === 'youtube') {\n          self.playerOptions = {\n            // GDPR Compliance.\n            host: 'https://www.youtube-nocookie.com',\n            videoId: self.videoID,\n            playerVars: {\n              autohide: 1,\n              rel: 0,\n              autoplay: 0,\n              // autoplay enable on mobile devices\n              playsinline: 1\n            }\n          }; // hide controls\n\n          if (!self.options.showControls) {\n            self.playerOptions.playerVars.iv_load_policy = 3;\n            self.playerOptions.playerVars.modestbranding = 1;\n            self.playerOptions.playerVars.controls = 0;\n            self.playerOptions.playerVars.showinfo = 0;\n            self.playerOptions.playerVars.disablekb = 1;\n          } // events\n\n\n          let ytStarted;\n          let ytProgressInterval;\n          self.playerOptions.events = {\n            onReady(e) {\n              // mute\n              if (self.options.mute) {\n                e.target.mute();\n              } else if (self.options.volume) {\n                e.target.setVolume(self.options.volume);\n              } // autoplay\n\n\n              if (self.options.autoplay) {\n                self.play(self.options.startTime);\n              }\n\n              self.fire('ready', e); // For seamless loops, set the endTime to 0.1 seconds less than the video's duration\n              // https://github.com/nk-o/video-worker/issues/2\n\n              if (self.options.loop && !self.options.endTime) {\n                const secondsOffset = 0.1;\n                self.options.endTime = self.player.getDuration() - secondsOffset;\n              } // volumechange\n\n\n              setInterval(() => {\n                self.getVolume(volume => {\n                  if (self.options.volume !== volume) {\n                    self.options.volume = volume;\n                    self.fire('volumechange', e);\n                  }\n                });\n              }, 150);\n            },\n\n            onStateChange(e) {\n              // loop\n              if (self.options.loop && e.data === global$1$1.YT.PlayerState.ENDED) {\n                self.play(self.options.startTime);\n              }\n\n              if (!ytStarted && e.data === global$1$1.YT.PlayerState.PLAYING) {\n                ytStarted = 1;\n                self.fire('started', e);\n              }\n\n              if (e.data === global$1$1.YT.PlayerState.PLAYING) {\n                self.fire('play', e);\n              }\n\n              if (e.data === global$1$1.YT.PlayerState.PAUSED) {\n                self.fire('pause', e);\n              }\n\n              if (e.data === global$1$1.YT.PlayerState.ENDED) {\n                self.fire('ended', e);\n              } // progress check\n\n\n              if (e.data === global$1$1.YT.PlayerState.PLAYING) {\n                ytProgressInterval = setInterval(() => {\n                  self.fire('timeupdate', e); // check for end of video and play again or stop\n\n                  if (self.options.endTime && self.player.getCurrentTime() >= self.options.endTime) {\n                    if (self.options.loop) {\n                      self.play(self.options.startTime);\n                    } else {\n                      self.pause();\n                    }\n                  }\n                }, 150);\n              } else {\n                clearInterval(ytProgressInterval);\n              }\n            },\n\n            onError(e) {\n              self.fire('error', e);\n            }\n\n          };\n          const firstInit = !self.$video;\n\n          if (firstInit) {\n            const div = document.createElement('div');\n            div.setAttribute('id', self.playerID);\n            hiddenDiv.appendChild(div);\n            document.body.appendChild(hiddenDiv);\n          }\n\n          self.player = self.player || new global$1$1.YT.Player(self.playerID, self.playerOptions);\n\n          if (firstInit) {\n            self.$video = document.getElementById(self.playerID); // add accessibility attributes\n\n            if (self.options.accessibilityHidden) {\n              self.$video.setAttribute('tabindex', '-1');\n              self.$video.setAttribute('aria-hidden', 'true');\n            } // get video width and height\n\n\n            self.videoWidth = parseInt(self.$video.getAttribute('width'), 10) || 1280;\n            self.videoHeight = parseInt(self.$video.getAttribute('height'), 10) || 720;\n          }\n        } // Vimeo\n\n\n        if (self.type === 'vimeo') {\n          self.playerOptions = {\n            // GDPR Compliance.\n            dnt: 1,\n            id: self.videoID,\n            autopause: 0,\n            transparent: 0,\n            autoplay: self.options.autoplay ? 1 : 0,\n            loop: self.options.loop ? 1 : 0,\n            muted: self.options.mute ? 1 : 0\n          };\n\n          if (self.options.volume) {\n            self.playerOptions.volume = self.options.volume;\n          } // hide controls\n\n\n          if (!self.options.showControls) {\n            self.playerOptions.badge = 0;\n            self.playerOptions.byline = 0;\n            self.playerOptions.portrait = 0;\n            self.playerOptions.title = 0;\n            self.playerOptions.background = 1;\n          }\n\n          if (!self.$video) {\n            let playerOptionsString = '';\n            Object.keys(self.playerOptions).forEach(key => {\n              if (playerOptionsString !== '') {\n                playerOptionsString += '&';\n              }\n\n              playerOptionsString += `${key}=${encodeURIComponent(self.playerOptions[key])}`;\n            }); // we need to create iframe manually because when we create it using API\n            // js events won't triggers after iframe moved to another place\n\n            self.$video = document.createElement('iframe');\n            self.$video.setAttribute('id', self.playerID);\n            self.$video.setAttribute('src', `https://player.vimeo.com/video/${self.videoID}?${playerOptionsString}`);\n            self.$video.setAttribute('frameborder', '0');\n            self.$video.setAttribute('mozallowfullscreen', '');\n            self.$video.setAttribute('allowfullscreen', '');\n            self.$video.setAttribute('title', 'Vimeo video player'); // add accessibility attributes\n\n            if (self.options.accessibilityHidden) {\n              self.$video.setAttribute('tabindex', '-1');\n              self.$video.setAttribute('aria-hidden', 'true');\n            }\n\n            hiddenDiv.appendChild(self.$video);\n            document.body.appendChild(hiddenDiv);\n          }\n\n          self.player = self.player || new global$1$1.Vimeo.Player(self.$video, self.playerOptions); // set current time for autoplay\n\n          if (self.options.startTime && self.options.autoplay) {\n            self.player.setCurrentTime(self.options.startTime);\n          } // get video width and height\n\n\n          self.player.getVideoWidth().then(width => {\n            self.videoWidth = width || 1280;\n          });\n          self.player.getVideoHeight().then(height => {\n            self.videoHeight = height || 720;\n          }); // events\n\n          let vmStarted;\n          self.player.on('timeupdate', e => {\n            if (!vmStarted) {\n              self.fire('started', e);\n              vmStarted = 1;\n            }\n\n            self.fire('timeupdate', e); // check for end of video and play again or stop\n\n            if (self.options.endTime) {\n              if (self.options.endTime && e.seconds >= self.options.endTime) {\n                if (self.options.loop) {\n                  self.play(self.options.startTime);\n                } else {\n                  self.pause();\n                }\n              }\n            }\n          });\n          self.player.on('play', e => {\n            self.fire('play', e); // check for the start time and start with it\n\n            if (self.options.startTime && e.seconds === 0) {\n              self.play(self.options.startTime);\n            }\n          });\n          self.player.on('pause', e => {\n            self.fire('pause', e);\n          });\n          self.player.on('ended', e => {\n            self.fire('ended', e);\n          });\n          self.player.on('loaded', e => {\n            self.fire('ready', e);\n          });\n          self.player.on('volumechange', e => {\n            self.fire('volumechange', e);\n          });\n          self.player.on('error', e => {\n            self.fire('error', e);\n          });\n        } // Local\n\n\n        function addSourceToLocal(element, src, type) {\n          const source = document.createElement('source');\n          source.src = src;\n          source.type = type;\n          element.appendChild(source);\n        }\n\n        if (self.type === 'local') {\n          if (!self.$video) {\n            self.$video = document.createElement('video'); // show controls\n\n            if (self.options.showControls) {\n              self.$video.controls = true;\n            } // mute\n\n\n            if (self.options.mute) {\n              self.$video.muted = true;\n            } else if (self.$video.volume) {\n              self.$video.volume = self.options.volume / 100;\n            } // loop\n\n\n            if (self.options.loop) {\n              self.$video.loop = true;\n            } // autoplay enable on mobile devices\n\n\n            self.$video.setAttribute('playsinline', '');\n            self.$video.setAttribute('webkit-playsinline', ''); // add accessibility attributes\n\n            if (self.options.accessibilityHidden) {\n              self.$video.setAttribute('tabindex', '-1');\n              self.$video.setAttribute('aria-hidden', 'true');\n            }\n\n            self.$video.setAttribute('id', self.playerID);\n            hiddenDiv.appendChild(self.$video);\n            document.body.appendChild(hiddenDiv);\n            Object.keys(self.videoID).forEach(key => {\n              addSourceToLocal(self.$video, self.videoID[key], `video/${key}`);\n            });\n          }\n\n          self.player = self.player || self.$video;\n          let locStarted;\n          self.player.addEventListener('playing', e => {\n            if (!locStarted) {\n              self.fire('started', e);\n            }\n\n            locStarted = 1;\n          });\n          self.player.addEventListener('timeupdate', function (e) {\n            self.fire('timeupdate', e); // check for end of video and play again or stop\n\n            if (self.options.endTime) {\n              if (self.options.endTime && this.currentTime >= self.options.endTime) {\n                if (self.options.loop) {\n                  self.play(self.options.startTime);\n                } else {\n                  self.pause();\n                }\n              }\n            }\n          });\n          self.player.addEventListener('play', e => {\n            self.fire('play', e);\n          });\n          self.player.addEventListener('pause', e => {\n            self.fire('pause', e);\n          });\n          self.player.addEventListener('ended', e => {\n            self.fire('ended', e);\n          });\n          self.player.addEventListener('loadedmetadata', function () {\n            // get video width and height\n            self.videoWidth = this.videoWidth || 1280;\n            self.videoHeight = this.videoHeight || 720;\n            self.fire('ready'); // autoplay\n\n            if (self.options.autoplay) {\n              self.play(self.options.startTime);\n            }\n          });\n          self.player.addEventListener('volumechange', e => {\n            self.getVolume(volume => {\n              self.options.volume = volume;\n            });\n            self.fire('volumechange', e);\n          });\n          self.player.addEventListener('error', e => {\n            self.fire('error', e);\n          });\n        }\n\n        callback(self.$video);\n      });\n    }\n\n    init() {\n      const self = this;\n      self.playerID = `VideoWorker-${self.ID}`;\n    }\n\n    loadAPI() {\n      const self = this;\n\n      if (YoutubeAPIadded && VimeoAPIadded) {\n        return;\n      }\n\n      let src = ''; // load Youtube API\n\n      if (self.type === 'youtube' && !YoutubeAPIadded) {\n        YoutubeAPIadded = 1;\n        src = 'https://www.youtube.com/iframe_api';\n      } // load Vimeo API\n\n\n      if (self.type === 'vimeo' && !VimeoAPIadded) {\n        VimeoAPIadded = 1; // Useful when Vimeo API added using RequireJS https://github.com/nk-o/video-worker/pull/7\n\n        if (typeof global$1$1.Vimeo !== 'undefined') {\n          return;\n        }\n\n        src = 'https://player.vimeo.com/api/player.js';\n      }\n\n      if (!src) {\n        return;\n      } // add script in head section\n\n\n      let tag = document.createElement('script');\n      let head = document.getElementsByTagName('head')[0];\n      tag.src = src;\n      head.appendChild(tag);\n      head = null;\n      tag = null;\n    }\n\n    onAPIready(callback) {\n      const self = this; // Youtube\n\n      if (self.type === 'youtube') {\n        // Listen for global YT player callback\n        if ((typeof global$1$1.YT === 'undefined' || global$1$1.YT.loaded === 0) && !loadingYoutubePlayer) {\n          // Prevents Ready event from being called twice\n          loadingYoutubePlayer = 1; // Creates deferred so, other players know when to wait.\n\n          global$1$1.onYouTubeIframeAPIReady = function () {\n            global$1$1.onYouTubeIframeAPIReady = null;\n            loadingYoutubeDefer.resolve('done');\n            callback();\n          };\n        } else if (typeof global$1$1.YT === 'object' && global$1$1.YT.loaded === 1) {\n          callback();\n        } else {\n          loadingYoutubeDefer.done(() => {\n            callback();\n          });\n        }\n      } // Vimeo\n\n\n      if (self.type === 'vimeo') {\n        if (typeof global$1$1.Vimeo === 'undefined' && !loadingVimeoPlayer) {\n          loadingVimeoPlayer = 1;\n          const vimeoInterval = setInterval(() => {\n            if (typeof global$1$1.Vimeo !== 'undefined') {\n              clearInterval(vimeoInterval);\n              loadingVimeoDefer.resolve('done');\n              callback();\n            }\n          }, 20);\n        } else if (typeof global$1$1.Vimeo !== 'undefined') {\n          callback();\n        } else {\n          loadingVimeoDefer.done(() => {\n            callback();\n          });\n        }\n      } // Local\n\n\n      if (self.type === 'local') {\n        callback();\n      }\n    }\n\n  }\n\n  function ready(callback) {\n    if ('complete' === document.readyState || 'interactive' === document.readyState) {\n      // Already ready or interactive, execute callback\n      callback();\n    } else {\n      document.addEventListener('DOMContentLoaded', callback, {\n        capture: true,\n        once: true,\n        passive: true\n      });\n    }\n  }\n\n  /* eslint-disable import/no-mutable-exports */\n\n  /* eslint-disable no-restricted-globals */\n  let win;\n\n  if ('undefined' !== typeof window) {\n    win = window;\n  } else if ('undefined' !== typeof global) {\n    win = global;\n  } else if ('undefined' !== typeof self) {\n    win = self;\n  } else {\n    win = {};\n  }\n\n  var global$1 = win;\n\n  function jarallaxVideo(jarallax = global$1.jarallax) {\n    if ('undefined' === typeof jarallax) {\n      return;\n    }\n\n    const Jarallax = jarallax.constructor; // append video after when block will be visible.\n\n    const defOnScroll = Jarallax.prototype.onScroll;\n\n    Jarallax.prototype.onScroll = function () {\n      const self = this;\n      defOnScroll.apply(self);\n      const isReady = !self.isVideoInserted && self.video && (!self.options.videoLazyLoading || self.isElementInViewport) && !self.options.disableVideo();\n\n      if (isReady) {\n        self.isVideoInserted = true;\n        self.video.getVideo(video => {\n          const $parent = video.parentNode;\n          self.css(video, {\n            position: self.image.position,\n            top: '0px',\n            left: '0px',\n            right: '0px',\n            bottom: '0px',\n            width: '100%',\n            height: '100%',\n            maxWidth: 'none',\n            maxHeight: 'none',\n            pointerEvents: 'none',\n            transformStyle: 'preserve-3d',\n            backfaceVisibility: 'hidden',\n            willChange: 'transform,opacity',\n            margin: 0,\n            zIndex: -1\n          });\n          self.$video = video; // add Poster attribute to self-hosted video\n\n          if ('local' === self.video.type) {\n            if (self.image.src) {\n              self.$video.setAttribute('poster', self.image.src);\n            } else if (self.image.$item && 'IMG' === self.image.$item.tagName && self.image.$item.src) {\n              self.$video.setAttribute('poster', self.image.$item.src);\n            }\n          } // insert video tag\n\n\n          self.image.$container.appendChild(video); // remove parent video element (created by VideoWorker)\n\n          $parent.parentNode.removeChild($parent); // call onVideoInsert event\n\n          if (self.options.onVideoInsert) {\n            self.options.onVideoInsert.call(self);\n          }\n        });\n      }\n    }; // cover video\n\n\n    const defCoverImage = Jarallax.prototype.coverImage;\n\n    Jarallax.prototype.coverImage = function () {\n      const self = this;\n      const imageData = defCoverImage.apply(self);\n      const node = self.image.$item ? self.image.$item.nodeName : false;\n\n      if (imageData && self.video && node && ('IFRAME' === node || 'VIDEO' === node)) {\n        let h = imageData.image.height;\n        let w = h * self.image.width / self.image.height;\n        let ml = (imageData.container.width - w) / 2;\n        let mt = imageData.image.marginTop;\n\n        if (imageData.container.width > w) {\n          w = imageData.container.width;\n          h = w * self.image.height / self.image.width;\n          ml = 0;\n          mt += (imageData.image.height - h) / 2;\n        } // add video height over than need to hide controls\n\n\n        if ('IFRAME' === node) {\n          h += 400;\n          mt -= 200;\n        }\n\n        self.css(self.$video, {\n          width: `${w}px`,\n          marginLeft: `${ml}px`,\n          height: `${h}px`,\n          marginTop: `${mt}px`\n        });\n      }\n\n      return imageData;\n    }; // init video\n\n\n    const defInitImg = Jarallax.prototype.initImg;\n\n    Jarallax.prototype.initImg = function () {\n      const self = this;\n      const defaultResult = defInitImg.apply(self);\n\n      if (!self.options.videoSrc) {\n        self.options.videoSrc = self.$item.getAttribute('data-jarallax-video') || null;\n      }\n\n      if (self.options.videoSrc) {\n        self.defaultInitImgResult = defaultResult;\n        return true;\n      }\n\n      return defaultResult;\n    };\n\n    const defCanInitParallax = Jarallax.prototype.canInitParallax;\n\n    Jarallax.prototype.canInitParallax = function () {\n      const self = this;\n      let defaultResult = defCanInitParallax.apply(self);\n\n      if (!self.options.videoSrc) {\n        return defaultResult;\n      } // Init video api\n\n\n      const video = new VideoWorker(self.options.videoSrc, {\n        autoplay: true,\n        loop: self.options.videoLoop,\n        showControls: false,\n        accessibilityHidden: true,\n        startTime: self.options.videoStartTime || 0,\n        endTime: self.options.videoEndTime || 0,\n        mute: self.options.videoVolume ? 0 : 1,\n        volume: self.options.videoVolume || 0\n      }); // call onVideoWorkerInit event\n\n      if (self.options.onVideoWorkerInit) {\n        self.options.onVideoWorkerInit.call(self, video);\n      }\n\n      function resetDefaultImage() {\n        if (self.image.$default_item) {\n          self.image.$item = self.image.$default_item;\n          self.image.$item.style.display = 'block'; // set image width and height\n\n          self.coverImage();\n          self.onScroll();\n        }\n      }\n\n      if (video.isValid()) {\n        // Force enable parallax.\n        // When the parallax disabled on mobile devices, we still need to display videos.\n        // https://github.com/nk-o/jarallax/issues/159\n        if (this.options.disableParallax()) {\n          defaultResult = true;\n          self.image.position = 'absolute';\n          self.options.type = 'scroll';\n          self.options.speed = 1;\n        } // if parallax will not be inited, we can add thumbnail on background.\n\n\n        if (!defaultResult) {\n          if (!self.defaultInitImgResult) {\n            video.getImageURL(url => {\n              // save default user styles\n              const curStyle = self.$item.getAttribute('style');\n\n              if (curStyle) {\n                self.$item.setAttribute('data-jarallax-original-styles', curStyle);\n              } // set new background\n\n\n              self.css(self.$item, {\n                'background-image': `url(\"${url}\")`,\n                'background-position': 'center',\n                'background-size': 'cover'\n              });\n            });\n          } // init video\n\n        } else {\n          video.on('ready', () => {\n            if (self.options.videoPlayOnlyVisible) {\n              const oldOnScroll = self.onScroll;\n\n              self.onScroll = function () {\n                oldOnScroll.apply(self);\n\n                if (!self.videoError && (self.options.videoLoop || !self.options.videoLoop && !self.videoEnded)) {\n                  if (self.isVisible()) {\n                    video.play();\n                  } else {\n                    video.pause();\n                  }\n                }\n              };\n            } else {\n              video.play();\n            }\n          });\n          video.on('started', () => {\n            self.image.$default_item = self.image.$item;\n            self.image.$item = self.$video; // set video width and height\n\n            self.image.width = self.video.videoWidth || 1280;\n            self.image.height = self.video.videoHeight || 720;\n            self.coverImage();\n            self.onScroll(); // hide image\n\n            if (self.image.$default_item) {\n              self.image.$default_item.style.display = 'none';\n            }\n          });\n          video.on('ended', () => {\n            self.videoEnded = true;\n\n            if (!self.options.videoLoop) {\n              // show default image if Loop disabled.\n              resetDefaultImage();\n            }\n          });\n          video.on('error', () => {\n            self.videoError = true; // show default image if video loading error.\n\n            resetDefaultImage();\n          });\n          self.video = video; // set image if not exists\n\n          if (!self.defaultInitImgResult) {\n            // set empty image on self-hosted video if not defined\n            self.image.src = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';\n\n            if ('local' !== video.type) {\n              video.getImageURL(url => {\n                self.image.bgImage = `url(\"${url}\")`;\n                self.init();\n              });\n              return false;\n            }\n          }\n        }\n      }\n\n      return defaultResult;\n    }; // Destroy video parallax\n\n\n    const defDestroy = Jarallax.prototype.destroy;\n\n    Jarallax.prototype.destroy = function () {\n      const self = this;\n\n      if (self.image.$default_item) {\n        self.image.$item = self.image.$default_item;\n        delete self.image.$default_item;\n      }\n\n      defDestroy.apply(self);\n    };\n  }\n\n  jarallaxVideo(); // data-jarallax-video initialization\n\n  ready(() => {\n    if ('undefined' !== typeof global$1.jarallax) {\n      global$1.jarallax(document.querySelectorAll('[data-jarallax-video]'));\n    }\n  }); // We should add VideoWorker globally, since some project uses it.\n\n  if (!global$1.VideoWorker) {\n    global$1.VideoWorker = VideoWorker;\n  }\n\n  return jarallaxVideo;\n\n}));\n//# sourceMappingURL=jarallax-video.js.map\n","Magento_PageBuilder/js/resource/jarallax/jarallax.js":"/*!\n * Jarallax v2.0.3 (https://github.com/nk-o/jarallax)\n * Copyright 2022 nK <https://nkdev.info>\n * Licensed under MIT (https://github.com/nk-o/jarallax/blob/master/LICENSE)\n */\n(function (global, factory) {\n  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n      typeof define === 'function' && define.amd ? define(factory) :\n          (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.jarallax = factory());\n})(this, (function () { 'use strict';\n\n  function ready(callback) {\n    if ('complete' === document.readyState || 'interactive' === document.readyState) {\n      // Already ready or interactive, execute callback\n      callback();\n    } else {\n      document.addEventListener('DOMContentLoaded', callback, {\n        capture: true,\n        once: true,\n        passive: true\n      });\n    }\n  }\n\n  /* eslint-disable import/no-mutable-exports */\n\n  /* eslint-disable no-restricted-globals */\n  let win;\n\n  if ('undefined' !== typeof window) {\n    win = window;\n  } else if ('undefined' !== typeof global) {\n    win = global;\n  } else if ('undefined' !== typeof self) {\n    win = self;\n  } else {\n    win = {};\n  }\n\n  var global$1 = win;\n\n  const {\n    navigator\n  } = global$1;\n  const isMobile = /*#__PURE__*/ /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);\n  let $deviceHelper;\n  /**\n   * The most popular mobile browsers changes height after page scroll and this generates image jumping.\n   * We can fix it using this workaround with vh units.\n   */\n\n  function getDeviceHeight() {\n    if (!$deviceHelper && document.body) {\n      $deviceHelper = document.createElement('div');\n      $deviceHelper.style.cssText = 'position: fixed; top: -9999px; left: 0; height: 100vh; width: 0;';\n      document.body.appendChild($deviceHelper);\n    }\n\n    return ($deviceHelper ? $deviceHelper.clientHeight : 0) || global$1.innerHeight || document.documentElement.clientHeight;\n  } // Window height data\n\n\n  let wndH;\n\n  function updateWndVars() {\n    if (isMobile) {\n      wndH = getDeviceHeight();\n    } else {\n      wndH = global$1.innerHeight || document.documentElement.clientHeight;\n    }\n  }\n\n  updateWndVars();\n  global$1.addEventListener('resize', updateWndVars);\n  global$1.addEventListener('orientationchange', updateWndVars);\n  global$1.addEventListener('load', updateWndVars);\n  ready(() => {\n    updateWndVars();\n  }); // list with all jarallax instances\n  // need to render all in one scroll/resize event\n\n  const jarallaxList = []; // get all parents of the element.\n\n  function getParents(elem) {\n    const parents = [];\n\n    while (null !== elem.parentElement) {\n      elem = elem.parentElement;\n\n      if (1 === elem.nodeType) {\n        parents.push(elem);\n      }\n    }\n\n    return parents;\n  }\n\n  function updateParallax() {\n    if (!jarallaxList.length) {\n      return;\n    }\n\n    jarallaxList.forEach((data, k) => {\n      const {\n        instance,\n        oldData\n      } = data;\n      const clientRect = instance.$item.getBoundingClientRect();\n      const newData = {\n        width: clientRect.width,\n        height: clientRect.height,\n        top: clientRect.top,\n        bottom: clientRect.bottom,\n        wndW: global$1.innerWidth,\n        wndH\n      };\n      const isResized = !oldData || oldData.wndW !== newData.wndW || oldData.wndH !== newData.wndH || oldData.width !== newData.width || oldData.height !== newData.height;\n      const isScrolled = isResized || !oldData || oldData.top !== newData.top || oldData.bottom !== newData.bottom;\n      jarallaxList[k].oldData = newData;\n\n      if (isResized) {\n        instance.onResize();\n      }\n\n      if (isScrolled) {\n        instance.onScroll();\n      }\n    });\n    global$1.requestAnimationFrame(updateParallax);\n  }\n\n  let instanceID = 0; // Jarallax class\n\n  class Jarallax {\n    constructor(item, userOptions) {\n      const self = this;\n      self.instanceID = instanceID;\n      instanceID += 1;\n      self.$item = item;\n      self.defaults = {\n        type: 'scroll',\n        // type of parallax: scroll, scale, opacity, scale-opacity, scroll-opacity\n        speed: 0.5,\n        // supported value from -1 to 2\n        imgSrc: null,\n        imgElement: '.jarallax-img',\n        imgSize: 'cover',\n        imgPosition: '50% 50%',\n        imgRepeat: 'no-repeat',\n        // supported only for background, not for <img> tag\n        keepImg: false,\n        // keep <img> tag in it's default place\n        elementInViewport: null,\n        zIndex: -100,\n        disableParallax: false,\n        disableVideo: false,\n        // video\n        videoSrc: null,\n        videoStartTime: 0,\n        videoEndTime: 0,\n        videoVolume: 0,\n        videoLoop: true,\n        videoPlayOnlyVisible: true,\n        videoLazyLoading: true,\n        // events\n        onScroll: null,\n        // function(calculations) {}\n        onInit: null,\n        // function() {}\n        onDestroy: null,\n        // function() {}\n        onCoverImage: null // function() {}\n\n      }; // prepare data-options\n\n      const dataOptions = self.$item.dataset || {};\n      const pureDataOptions = {};\n      Object.keys(dataOptions).forEach(key => {\n        const loweCaseOption = key.substr(0, 1).toLowerCase() + key.substr(1);\n\n        if (loweCaseOption && 'undefined' !== typeof self.defaults[loweCaseOption]) {\n          pureDataOptions[loweCaseOption] = dataOptions[key];\n        }\n      });\n      self.options = self.extend({}, self.defaults, pureDataOptions, userOptions);\n      self.pureOptions = self.extend({}, self.options); // prepare 'true' and 'false' strings to boolean\n\n      Object.keys(self.options).forEach(key => {\n        if ('true' === self.options[key]) {\n          self.options[key] = true;\n        } else if ('false' === self.options[key]) {\n          self.options[key] = false;\n        }\n      }); // fix speed option [-1.0, 2.0]\n\n      self.options.speed = Math.min(2, Math.max(-1, parseFloat(self.options.speed))); // prepare disableParallax callback\n\n      if ('string' === typeof self.options.disableParallax) {\n        self.options.disableParallax = new RegExp(self.options.disableParallax);\n      }\n\n      if (self.options.disableParallax instanceof RegExp) {\n        const disableParallaxRegexp = self.options.disableParallax;\n\n        self.options.disableParallax = () => disableParallaxRegexp.test(navigator.userAgent);\n      }\n\n      if ('function' !== typeof self.options.disableParallax) {\n        self.options.disableParallax = () => false;\n      } // prepare disableVideo callback\n\n\n      if ('string' === typeof self.options.disableVideo) {\n        self.options.disableVideo = new RegExp(self.options.disableVideo);\n      }\n\n      if (self.options.disableVideo instanceof RegExp) {\n        const disableVideoRegexp = self.options.disableVideo;\n\n        self.options.disableVideo = () => disableVideoRegexp.test(navigator.userAgent);\n      }\n\n      if ('function' !== typeof self.options.disableVideo) {\n        self.options.disableVideo = () => false;\n      } // custom element to check if parallax in viewport\n\n\n      let elementInVP = self.options.elementInViewport; // get first item from array\n\n      if (elementInVP && 'object' === typeof elementInVP && 'undefined' !== typeof elementInVP.length) {\n        [elementInVP] = elementInVP;\n      } // check if dom element\n\n\n      if (!(elementInVP instanceof Element)) {\n        elementInVP = null;\n      }\n\n      self.options.elementInViewport = elementInVP;\n      self.image = {\n        src: self.options.imgSrc || null,\n        $container: null,\n        useImgTag: false,\n        // 1. Position fixed is needed for the most of browsers because absolute position have glitches\n        // 2. On MacOS with smooth scroll there is a huge lags with absolute position - https://github.com/nk-o/jarallax/issues/75\n        // 3. Previously used 'absolute' for mobile devices. But we re-tested on iPhone 12 and 'fixed' position is working better, then 'absolute', so for now position is always 'fixed'\n        position: 'fixed'\n      };\n\n      if (self.initImg() && self.canInitParallax()) {\n        self.init();\n      }\n    } // add styles to element\n    // eslint-disable-next-line class-methods-use-this\n\n\n    css(el, styles) {\n      if ('string' === typeof styles) {\n        return global$1.getComputedStyle(el).getPropertyValue(styles);\n      }\n\n      Object.keys(styles).forEach(key => {\n        el.style[key] = styles[key];\n      });\n      return el;\n    } // Extend like jQuery.extend\n    // eslint-disable-next-line class-methods-use-this\n\n\n    extend(out, ...args) {\n      out = out || {};\n      Object.keys(args).forEach(i => {\n        if (!args[i]) {\n          return;\n        }\n\n        Object.keys(args[i]).forEach(key => {\n          out[key] = args[i][key];\n        });\n      });\n      return out;\n    } // get window size and scroll position. Useful for extensions\n    // eslint-disable-next-line class-methods-use-this\n\n\n    getWindowData() {\n      return {\n        width: global$1.innerWidth || document.documentElement.clientWidth,\n        height: wndH,\n        y: document.documentElement.scrollTop\n      };\n    } // Jarallax functions\n\n\n    initImg() {\n      const self = this; // find image element\n\n      let $imgElement = self.options.imgElement;\n\n      if ($imgElement && 'string' === typeof $imgElement) {\n        $imgElement = self.$item.querySelector($imgElement);\n      } // check if dom element\n\n\n      if (!($imgElement instanceof Element)) {\n        if (self.options.imgSrc) {\n          $imgElement = new Image();\n          $imgElement.src = self.options.imgSrc;\n        } else {\n          $imgElement = null;\n        }\n      }\n\n      if ($imgElement) {\n        if (self.options.keepImg) {\n          self.image.$item = $imgElement.cloneNode(true);\n        } else {\n          self.image.$item = $imgElement;\n          self.image.$itemParent = $imgElement.parentNode;\n        }\n\n        self.image.useImgTag = true;\n      } // true if there is img tag\n\n\n      if (self.image.$item) {\n        return true;\n      } // get image src\n\n\n      if (null === self.image.src) {\n        self.image.src = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';\n        self.image.bgImage = self.css(self.$item, 'background-image');\n      }\n\n      return !(!self.image.bgImage || 'none' === self.image.bgImage);\n    }\n\n    canInitParallax() {\n      return !this.options.disableParallax();\n    }\n\n    init() {\n      const self = this;\n      const containerStyles = {\n        position: 'absolute',\n        top: 0,\n        left: 0,\n        width: '100%',\n        height: '100%',\n        overflow: 'hidden'\n      };\n      let imageStyles = {\n        pointerEvents: 'none',\n        transformStyle: 'preserve-3d',\n        backfaceVisibility: 'hidden',\n        willChange: 'transform,opacity'\n      };\n\n      if (!self.options.keepImg) {\n        // save default user styles\n        const curStyle = self.$item.getAttribute('style');\n\n        if (curStyle) {\n          self.$item.setAttribute('data-jarallax-original-styles', curStyle);\n        }\n\n        if (self.image.useImgTag) {\n          const curImgStyle = self.image.$item.getAttribute('style');\n\n          if (curImgStyle) {\n            self.image.$item.setAttribute('data-jarallax-original-styles', curImgStyle);\n          }\n        }\n      } // set relative position and z-index to the parent\n\n\n      if ('static' === self.css(self.$item, 'position')) {\n        self.css(self.$item, {\n          position: 'relative'\n        });\n      }\n\n      if ('auto' === self.css(self.$item, 'z-index')) {\n        self.css(self.$item, {\n          zIndex: 0\n        });\n      } // container for parallax image\n\n\n      self.image.$container = document.createElement('div');\n      self.css(self.image.$container, containerStyles);\n      self.css(self.image.$container, {\n        'z-index': self.options.zIndex\n      }); // it will remove some image overlapping\n      // overlapping occur due to an image position fixed inside absolute position element\n      // needed only when background in fixed position\n\n      if ('fixed' === this.image.position) {\n        self.css(self.image.$container, {\n          '-webkit-clip-path': 'polygon(0 0, 100% 0, 100% 100%, 0 100%)',\n          'clip-path': 'polygon(0 0, 100% 0, 100% 100%, 0 100%)'\n        });\n      }\n\n      self.image.$container.setAttribute('id', `jarallax-container-${self.instanceID}`);\n      self.$item.appendChild(self.image.$container); // use img tag\n\n      if (self.image.useImgTag) {\n        imageStyles = self.extend({\n          'object-fit': self.options.imgSize,\n          'object-position': self.options.imgPosition,\n          'max-width': 'none'\n        }, containerStyles, imageStyles); // use div with background image\n      } else {\n        self.image.$item = document.createElement('div');\n\n        if (self.image.src) {\n          imageStyles = self.extend({\n            'background-position': self.options.imgPosition,\n            'background-size': self.options.imgSize,\n            'background-repeat': self.options.imgRepeat,\n            'background-image': self.image.bgImage || `url(\"${self.image.src}\")`\n          }, containerStyles, imageStyles);\n        }\n      }\n\n      if ('opacity' === self.options.type || 'scale' === self.options.type || 'scale-opacity' === self.options.type || 1 === self.options.speed) {\n        self.image.position = 'absolute';\n      } // 1. Check if one of parents have transform style (without this check, scroll transform will be inverted if used parallax with position fixed)\n      //    discussion - https://github.com/nk-o/jarallax/issues/9\n      // 2. Check if parents have overflow scroll\n\n\n      if ('fixed' === self.image.position) {\n        const $parents = getParents(self.$item).filter(el => {\n          const styles = global$1.getComputedStyle(el);\n          const parentTransform = styles['-webkit-transform'] || styles['-moz-transform'] || styles.transform;\n          const overflowRegex = /(auto|scroll)/;\n          return parentTransform && 'none' !== parentTransform || overflowRegex.test(styles.overflow + styles['overflow-y'] + styles['overflow-x']);\n        });\n        self.image.position = $parents.length ? 'absolute' : 'fixed';\n      } // add position to parallax block\n\n\n      imageStyles.position = self.image.position; // insert parallax image\n\n      self.css(self.image.$item, imageStyles);\n      self.image.$container.appendChild(self.image.$item); // set initial position and size\n\n      self.onResize();\n      self.onScroll(true); // call onInit event\n\n      if (self.options.onInit) {\n        self.options.onInit.call(self);\n      } // remove default user background\n\n\n      if ('none' !== self.css(self.$item, 'background-image')) {\n        self.css(self.$item, {\n          'background-image': 'none'\n        });\n      }\n\n      self.addToParallaxList();\n    } // add to parallax instances list\n\n\n    addToParallaxList() {\n      jarallaxList.push({\n        instance: this\n      });\n\n      if (1 === jarallaxList.length) {\n        global$1.requestAnimationFrame(updateParallax);\n      }\n    } // remove from parallax instances list\n\n\n    removeFromParallaxList() {\n      const self = this;\n      jarallaxList.forEach((data, key) => {\n        if (data.instance.instanceID === self.instanceID) {\n          jarallaxList.splice(key, 1);\n        }\n      });\n    }\n\n    destroy() {\n      const self = this;\n      self.removeFromParallaxList(); // return styles on container as before jarallax init\n\n      const originalStylesTag = self.$item.getAttribute('data-jarallax-original-styles');\n      self.$item.removeAttribute('data-jarallax-original-styles'); // null occurs if there is no style tag before jarallax init\n\n      if (!originalStylesTag) {\n        self.$item.removeAttribute('style');\n      } else {\n        self.$item.setAttribute('style', originalStylesTag);\n      }\n\n      if (self.image.useImgTag) {\n        // return styles on img tag as before jarallax init\n        const originalStylesImgTag = self.image.$item.getAttribute('data-jarallax-original-styles');\n        self.image.$item.removeAttribute('data-jarallax-original-styles'); // null occurs if there is no style tag before jarallax init\n\n        if (!originalStylesImgTag) {\n          self.image.$item.removeAttribute('style');\n        } else {\n          self.image.$item.setAttribute('style', originalStylesTag);\n        } // move img tag to its default position\n\n\n        if (self.image.$itemParent) {\n          self.image.$itemParent.appendChild(self.image.$item);\n        }\n      } // remove additional dom elements\n\n\n      if (self.image.$container) {\n        self.image.$container.parentNode.removeChild(self.image.$container);\n      } // call onDestroy event\n\n\n      if (self.options.onDestroy) {\n        self.options.onDestroy.call(self);\n      } // delete jarallax from item\n\n\n      delete self.$item.jarallax;\n    } // Fallback for removed function.\n    // Does nothing now.\n    // eslint-disable-next-line class-methods-use-this\n\n\n    clipContainer() {}\n\n    coverImage() {\n      const self = this;\n      const rect = self.image.$container.getBoundingClientRect();\n      const contH = rect.height;\n      const {\n        speed\n      } = self.options;\n      const isScroll = 'scroll' === self.options.type || 'scroll-opacity' === self.options.type;\n      let scrollDist = 0;\n      let resultH = contH;\n      let resultMT = 0; // scroll parallax\n\n      if (isScroll) {\n        // scroll distance and height for image\n        if (0 > speed) {\n          scrollDist = speed * Math.max(contH, wndH);\n\n          if (wndH < contH) {\n            scrollDist -= speed * (contH - wndH);\n          }\n        } else {\n          scrollDist = speed * (contH + wndH);\n        } // size for scroll parallax\n\n\n        if (1 < speed) {\n          resultH = Math.abs(scrollDist - wndH);\n        } else if (0 > speed) {\n          resultH = scrollDist / speed + Math.abs(scrollDist);\n        } else {\n          resultH += (wndH - contH) * (1 - speed);\n        }\n\n        scrollDist /= 2;\n      } // store scroll distance\n\n\n      self.parallaxScrollDistance = scrollDist; // vertical center\n\n      if (isScroll) {\n        resultMT = (wndH - resultH) / 2;\n      } else {\n        resultMT = (contH - resultH) / 2;\n      } // apply result to item\n\n\n      self.css(self.image.$item, {\n        height: `${resultH}px`,\n        marginTop: `${resultMT}px`,\n        left: 'fixed' === self.image.position ? `${rect.left}px` : '0',\n        width: `${rect.width}px`\n      }); // call onCoverImage event\n\n      if (self.options.onCoverImage) {\n        self.options.onCoverImage.call(self);\n      } // return some useful data. Used in the video cover function\n\n\n      return {\n        image: {\n          height: resultH,\n          marginTop: resultMT\n        },\n        container: rect\n      };\n    }\n\n    isVisible() {\n      return this.isElementInViewport || false;\n    }\n\n    onScroll(force) {\n      const self = this;\n      const rect = self.$item.getBoundingClientRect();\n      const contT = rect.top;\n      const contH = rect.height;\n      const styles = {}; // check if in viewport\n\n      let viewportRect = rect;\n\n      if (self.options.elementInViewport) {\n        viewportRect = self.options.elementInViewport.getBoundingClientRect();\n      }\n\n      self.isElementInViewport = 0 <= viewportRect.bottom && 0 <= viewportRect.right && viewportRect.top <= wndH && viewportRect.left <= global$1.innerWidth; // stop calculations if item is not in viewport\n\n      if (force ? false : !self.isElementInViewport) {\n        return;\n      } // calculate parallax helping variables\n\n\n      const beforeTop = Math.max(0, contT);\n      const beforeTopEnd = Math.max(0, contH + contT);\n      const afterTop = Math.max(0, -contT);\n      const beforeBottom = Math.max(0, contT + contH - wndH);\n      const beforeBottomEnd = Math.max(0, contH - (contT + contH - wndH));\n      const afterBottom = Math.max(0, -contT + wndH - contH);\n      const fromViewportCenter = 1 - 2 * ((wndH - contT) / (wndH + contH)); // calculate on how percent of section is visible\n\n      let visiblePercent = 1;\n\n      if (contH < wndH) {\n        visiblePercent = 1 - (afterTop || beforeBottom) / contH;\n      } else if (beforeTopEnd <= wndH) {\n        visiblePercent = beforeTopEnd / wndH;\n      } else if (beforeBottomEnd <= wndH) {\n        visiblePercent = beforeBottomEnd / wndH;\n      } // opacity\n\n\n      if ('opacity' === self.options.type || 'scale-opacity' === self.options.type || 'scroll-opacity' === self.options.type) {\n        styles.transform = 'translate3d(0,0,0)';\n        styles.opacity = visiblePercent;\n      } // scale\n\n\n      if ('scale' === self.options.type || 'scale-opacity' === self.options.type) {\n        let scale = 1;\n\n        if (0 > self.options.speed) {\n          scale -= self.options.speed * visiblePercent;\n        } else {\n          scale += self.options.speed * (1 - visiblePercent);\n        }\n\n        styles.transform = `scale(${scale}) translate3d(0,0,0)`;\n      } // scroll\n\n\n      if ('scroll' === self.options.type || 'scroll-opacity' === self.options.type) {\n        let positionY = self.parallaxScrollDistance * fromViewportCenter; // fix if parallax block in absolute position\n\n        if ('absolute' === self.image.position) {\n          positionY -= contT;\n        }\n\n        styles.transform = `translate3d(0,${positionY}px,0)`;\n      }\n\n      self.css(self.image.$item, styles); // call onScroll event\n\n      if (self.options.onScroll) {\n        self.options.onScroll.call(self, {\n          section: rect,\n          beforeTop,\n          beforeTopEnd,\n          afterTop,\n          beforeBottom,\n          beforeBottomEnd,\n          afterBottom,\n          visiblePercent,\n          fromViewportCenter\n        });\n      }\n    }\n\n    onResize() {\n      this.coverImage();\n    }\n\n  } // global definition\n\n\n  const jarallax = function (items, options, ...args) {\n    // check for dom element\n    // thanks: http://stackoverflow.com/questions/384286/javascript-isdom-how-do-you-check-if-a-javascript-object-is-a-dom-object\n    if ('object' === typeof HTMLElement ? items instanceof HTMLElement : items && 'object' === typeof items && null !== items && 1 === items.nodeType && 'string' === typeof items.nodeName) {\n      items = [items];\n    }\n\n    const len = items.length;\n    let k = 0;\n    let ret;\n\n    for (k; k < len; k += 1) {\n      if ('object' === typeof options || 'undefined' === typeof options) {\n        if (!items[k].jarallax) {\n          items[k].jarallax = new Jarallax(items[k], options);\n        }\n      } else if (items[k].jarallax) {\n        // eslint-disable-next-line prefer-spread\n        ret = items[k].jarallax[options].apply(items[k].jarallax, args);\n      }\n\n      if ('undefined' !== typeof ret) {\n        return ret;\n      }\n    }\n\n    return items;\n  };\n\n  jarallax.constructor = Jarallax;\n\n  const $ = global$1.jQuery; // jQuery support\n\n  if ('undefined' !== typeof $) {\n    const $Plugin = function (...args) {\n      Array.prototype.unshift.call(args, this);\n      const res = jarallax.apply(global$1, args);\n      return 'object' !== typeof res ? res : this;\n    };\n\n    $Plugin.constructor = jarallax.constructor; // no conflict\n\n    const old$Plugin = $.fn.jarallax;\n    $.fn.jarallax = $Plugin;\n\n    $.fn.jarallax.noConflict = function () {\n      $.fn.jarallax = old$Plugin;\n      return this;\n    };\n  } // data-jarallax initialization\n\n\n  ready(() => {\n    jarallax(document.querySelectorAll('[data-jarallax]'));\n  });\n\n  return jarallax;\n\n}));\n//# sourceMappingURL=jarallax.js.map\n","Magento_Checkout/js/checkout-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'rjsResolver'\n], function (resolver) {\n    'use strict';\n\n    /**\n     * Removes provided loader element from DOM.\n     *\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function hideLoader($loader) {\n        $loader.parentNode.removeChild($loader);\n    }\n\n    /**\n     * Initializes assets loading process listener.\n     *\n     * @param {Object} config - Optional configuration\n     * @param {HTMLElement} $loader - Loader DOM element.\n     */\n    function init(config, $loader) {\n        resolver(hideLoader.bind(null, $loader));\n    }\n\n    return init;\n});\n","Magento_Checkout/js/region-updater.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/validation'\n], function ($, mageTemplate, _) {\n    'use strict';\n\n    $.widget('mage.regionUpdater', {\n        options: {\n            regionTemplate:\n                '<option value=\"<%- data.value %>\" <% if (data.isSelected) { %>selected=\"selected\"<% } %>>' +\n                    '<%- data.title %>' +\n                '</option>',\n            isRegionRequired: true,\n            isZipRequired: true,\n            isCountryRequired: true,\n            currentRegion: null,\n            isMultipleCountriesAllowed: true\n        },\n\n        /**\n         *\n         * @private\n         */\n        _create: function () {\n            this._initCountryElement();\n\n            this.currentRegionOption = this.options.currentRegion;\n            this.regionTmpl = mageTemplate(this.options.regionTemplate);\n\n            this._updateRegion(this.element.find('option:selected').val());\n\n            $(this.options.regionListId).on('change', $.proxy(function (e) {\n                this.setOption = false;\n                this.currentRegionOption = $(e.target).val();\n            }, this));\n\n            $(this.options.regionInputId).on('focusout', $.proxy(function () {\n                this.setOption = true;\n            }, this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initCountryElement: function () {\n\n            if (this.options.isMultipleCountriesAllowed) {\n                this.element.parents('div.field').show();\n                this.element.on('change', $.proxy(function (e) {\n                    // clear region inputs on country change\n                    $(this.options.regionListId).val('');\n                    $(this.options.regionInputId).val('');\n                    this._updateRegion($(e.target).val());\n                }, this));\n\n                if (this.options.isCountryRequired) {\n                    this.element.addClass('required-entry');\n                    this.element.parents('div.field').addClass('required');\n                }\n            } else {\n                this.element.parents('div.field').hide();\n            }\n        },\n\n        /**\n         * Remove options from dropdown list\n         *\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @private\n         */\n        _removeSelectOptions: function (selectElement) {\n            selectElement.find('option').each(function (index) {\n                if (index) {\n                    $(this).remove();\n                }\n            });\n        },\n\n        /**\n         * Render dropdown list\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @param {String} key - region code\n         * @param {Object} value - region object\n         * @private\n         */\n        _renderSelectOption: function (selectElement, key, value) {\n            selectElement.append($.proxy(function () {\n                var name = value.name.replace(/[!\"#$%&'()*+,.\\/:;<=>?@[\\\\\\]^`{|}~]/g, '\\\\$&'),\n                    tmplData,\n                    tmpl;\n\n                if (value.code && $(name).is('span')) {\n                    key = value.code;\n                    value.name = $(name).text();\n                }\n\n                tmplData = {\n                    value: key,\n                    title: value.name,\n                    isSelected: false\n                };\n\n                if (this.options.defaultRegion === key) {\n                    tmplData.isSelected = true;\n                }\n\n                tmpl = this.regionTmpl({\n                    data: tmplData\n                });\n\n                return $(tmpl);\n            }, this));\n        },\n\n        /**\n         * Takes clearError callback function as first option\n         * If no form is passed as option, look up the closest form and call clearError method.\n         * @private\n         */\n        _clearError: function () {\n            var args = ['clearError', this.options.regionListId, this.options.regionInputId, this.options.postcodeId];\n\n            if (this.options.clearError && typeof this.options.clearError === 'function') {\n                this.options.clearError.call(this);\n            } else {\n                if (!this.options.form) {\n                    this.options.form = this.element.closest('form').length ? $(this.element.closest('form')[0]) : null;\n                }\n\n                this.options.form = $(this.options.form);\n\n                this.options.form && this.options.form.data('validator') &&\n                    this.options.form.validation.apply(this.options.form, _.compact(args));\n\n                // Clean up errors on region & zip fix\n                $(this.options.regionInputId).removeClass('mage-error').parent().find('.mage-error').remove();\n                $(this.options.regionListId).removeClass('mage-error').parent().find('.mage-error').remove();\n                $(this.options.postcodeId).removeClass('mage-error').parent().find('.mage-error').remove();\n            }\n        },\n\n        /**\n         * Update dropdown list based on the country selected\n         *\n         * @param {String} country - 2 uppercase letter for country code\n         * @private\n         */\n        _updateRegion: function (country) {\n            // Clear validation error messages\n            var regionList = $(this.options.regionListId),\n                regionInput = $(this.options.regionInputId),\n                postcode = $(this.options.postcodeId),\n                label = regionList.parent().siblings('label'),\n                container = regionList.parents('div.field'),\n                regionsEntries,\n                regionId,\n                regionData;\n\n            this._clearError();\n            this._checkRegionRequired(country);\n\n            // Populate state/province dropdown list if available or use input box\n            if (this.options.regionJson[country]) {\n                this._removeSelectOptions(regionList);\n                regionsEntries = _.pairs(this.options.regionJson[country]);\n                regionsEntries.sort(function (a, b) {\n                    return a[1].name > b[1].name ? 1 : -1;\n                });\n                $.each(regionsEntries, $.proxy(function (key, value) {\n                    regionId = value[0];\n                    regionData = value[1];\n                    this._renderSelectOption(regionList, regionId, regionData);\n                }, this));\n\n                if (this.currentRegionOption) {\n                    regionList.val(this.currentRegionOption);\n                }\n\n                if (this.setOption) {\n                    regionList.find('option').filter(function () {\n                        return this.text === regionInput.val();\n                    }).attr('selected', true);\n                }\n\n                if (this.options.isRegionRequired) {\n                    regionList.addClass('required-entry').prop('disabled', false);\n                    container.addClass('required').show();\n                } else {\n                    regionList.removeClass('required-entry validate-select').removeAttr('data-validate');\n                    container.removeClass('required');\n\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionList.hide();\n                        container.hide();\n                    } else {\n                        regionList.prop('disabled', false).show();\n                    }\n                }\n\n                regionList.show();\n                regionInput.hide();\n                label.attr('for', regionList.attr('id'));\n            } else {\n                this._removeSelectOptions(regionList);\n\n                if (this.options.isRegionRequired) {\n                    regionInput.addClass('required-entry').prop('disabled', false);\n                    container.addClass('required').show();\n                } else {\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionInput.attr('disabled', 'disabled');\n                        container.hide();\n                    }\n                    container.removeClass('required');\n                    regionInput.removeClass('required-entry');\n                }\n\n                regionList.removeClass('required-entry').prop('disabled', 'disabled').hide();\n                regionInput.show();\n                label.attr('for', regionInput.attr('id'));\n            }\n\n            // If country is in optionalzip list, make postcode input not required\n            if (this.options.isZipRequired) {\n                $.inArray(country, this.options.countriesWithOptionalZip) >= 0 ?\n                    postcode.removeClass('required-entry').closest('.field').removeClass('required') :\n                    postcode.addClass('required-entry').closest('.field').addClass('required');\n            }\n\n            // Add defaultvalue attribute to state/province select element\n            regionList.attr('defaultvalue', this.options.defaultRegion);\n            this.options.form.find('[type=\"submit\"]').prop('disabled', false).show();\n        },\n\n        /**\n         * Check if the selected country has a mandatory region selection\n         *\n         * @param {String} country - Code of the country - 2 uppercase letter for country code\n         * @private\n         */\n        _checkRegionRequired: function (country) {\n            var self = this;\n\n            this.options.isRegionRequired = false;\n            $.each(this.options.regionJson.config['regions_required'], function (index, elem) {\n                if (elem === country) {\n                    self.options.isRegionRequired = true;\n                }\n            });\n        }\n    });\n\n    return $.mage.regionUpdater;\n});\n","Magento_Checkout/js/empty-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['Magento_Customer/js/customer-data'], function (customerData) {\n    'use strict';\n\n    return function () {\n        var cartData = customerData.get('cart');\n\n        customerData.getInitCustomerData().done(function () {\n            if (cartData().items && cartData().items.length !== 0) {\n                customerData.reload(['cart'], false);\n            }\n        });\n    };\n});\n","Magento_Checkout/js/discount-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.discountCode', {\n        options: {\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.couponCode = $(this.options.couponCodeSelector);\n            this.removeCoupon = $(this.options.removeCouponSelector);\n\n            $(this.options.applyButton).on('click', $.proxy(function () {\n                this.couponCode.attr('data-validate', '{required:true}');\n                this.removeCoupon.attr('value', '0');\n                $(this.element).validation().trigger('submit');\n            }, this));\n\n            $(this.options.cancelButton).on('click', $.proxy(function () {\n                this.couponCode.removeAttr('data-validate');\n                this.removeCoupon.attr('value', '1');\n                this.element.trigger('submit');\n            }, this));\n        }\n    });\n\n    return $.mage.discountCode;\n});\n","Magento_Checkout/js/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/authentication-popup',\n    'Magento_Customer/js/customer-data',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/decorate',\n    'mage/collapsible',\n    'mage/cookies',\n    'jquery-ui-modules/effect-fade'\n], function ($, authenticationPopup, customerData, alert, confirm, _) {\n    'use strict';\n\n    $.widget('mage.sidebar', {\n        options: {\n            isRecursive: true,\n            minicart: {\n                maxItemsVisible: 3\n            }\n        },\n        scrollHeight: 0,\n        shoppingCartUrl: window.checkout.shoppingCartUrl,\n\n        /**\n         * Create sidebar.\n         * @private\n         */\n        _create: function () {\n            this._initContent();\n        },\n\n        /**\n         * Update sidebar block.\n         */\n        update: function () {\n            $(this.options.targetElement).trigger('contentUpdated');\n            this._calcHeight();\n        },\n\n        /**\n         * @private\n         */\n        _initContent: function () {\n            var self = this,\n                events = {};\n\n            this.element.decorate('list', this.options.isRecursive);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.button.close] = function (event) {\n                event.stopPropagation();\n                $(self.options.targetElement).dropdownDialog('close');\n            };\n            events['click ' + this.options.button.checkout] = $.proxy(function () {\n                var cart = customerData.get('cart'),\n                    customer = customerData.get('customer'),\n                    element = $(this.options.button.checkout);\n\n                if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                    // set URL for redirect on successful login/registration. It's postprocessed on backend.\n                    $.cookie('login_redirect', this.options.url.checkout);\n\n                    if (this.options.url.isRedirectRequired) {\n                        element.prop('disabled', true);\n                        location.href = this.options.url.loginUrl;\n                    } else {\n                        authenticationPopup.showModal();\n                    }\n\n                    return false;\n                }\n                element.prop('disabled', true);\n                location.href = this.options.url.checkout;\n            }, this);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.button.remove] =  function (event) {\n                event.stopPropagation();\n                confirm({\n                    content: self.options.confirmMessage,\n                    actions: {\n                        /** @inheritdoc */\n                        confirm: function () {\n                            self._removeItem($(event.currentTarget));\n                        },\n\n                        /** @inheritdoc */\n                        always: function (e) {\n                            e.stopImmediatePropagation();\n                        }\n                    }\n                });\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['keyup ' + this.options.item.qty] = function (event) {\n                self._showItemButton($(event.target));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['change ' + this.options.item.qty] = function (event) {\n                self._showItemButton($(event.target));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.item.button] = function (event) {\n                event.stopPropagation();\n                self._updateItemQty($(event.currentTarget));\n            };\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['focusout ' + this.options.item.qty] = function (event) {\n                self._validateQty($(event.currentTarget));\n            };\n\n            this._on(this.element, events);\n            this._calcHeight();\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _showItemButton: function (elem) {\n            var itemId = elem.data('cart-item'),\n                itemQty = elem.data('item-qty');\n\n            if (this._isValidQty(itemQty, elem.val())) {\n                $('#update-cart-item-' + itemId).show('fade', 300);\n            } else if (elem.val() == 0) { //eslint-disable-line eqeqeq\n                this._hideItemButton(elem);\n            } else {\n                this._hideItemButton(elem);\n            }\n        },\n\n        /**\n         * @param {*} origin - origin qty. 'data-item-qty' attribute.\n         * @param {*} changed - new qty.\n         * @returns {Boolean}\n         * @private\n         */\n        _isValidQty: function (origin, changed) {\n            return origin != changed && //eslint-disable-line eqeqeq\n                changed.length > 0 &&\n                changed - 0 == changed && //eslint-disable-line eqeqeq\n                changed - 0 > 0;\n        },\n\n        /**\n         * @param {Object} elem\n         * @private\n         */\n        _validateQty: function (elem) {\n            var itemQty = elem.data('item-qty');\n\n            if (!this._isValidQty(itemQty, elem.val())) {\n                elem.val(itemQty);\n            }\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _hideItemButton: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            $('#update-cart-item-' + itemId).hide('fade', 300);\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _updateItemQty: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            this._ajax(this.options.url.update, {\n                'item_id': itemId,\n                'item_qty': $('#cart-item-' + itemId + '-qty').val()\n            }, elem, this._updateItemQtyAfter);\n        },\n\n        /**\n         * Update content after update qty\n         *\n         * @param {HTMLElement} elem\n         */\n        _updateItemQtyAfter: function (elem) {\n            var productData = this._getProductById(Number(elem.data('cart-item')));\n\n            if (!_.isUndefined(productData)) {\n                $(document).trigger('ajax:updateCartItemQty');\n\n                if (window.location.href === this.shoppingCartUrl) {\n                    window.location.reload(false);\n                }\n            }\n            this._hideItemButton(elem);\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _removeItem: function (elem) {\n            var itemId = elem.data('cart-item');\n\n            this._ajax(this.options.url.remove, {\n                'item_id': itemId\n            }, elem, this._removeItemAfter);\n        },\n\n        /**\n         * Update content after item remove\n         *\n         * @param {Object} elem\n         * @private\n         */\n        _removeItemAfter: function (elem) {\n            var productData = this._getProductById(Number(elem.data('cart-item')));\n\n            if (!_.isUndefined(productData)) {\n                $(document).trigger('ajax:removeFromCart', {\n                    productIds: [productData['product_id']],\n                    productInfo: [\n                        {\n                            'id': productData['product_id']\n                        }\n                    ]\n                });\n\n                if (window.location.href.indexOf(this.shoppingCartUrl) === 0) {\n                    window.location.reload();\n                }\n            }\n        },\n\n        /**\n         * Retrieves product data by Id.\n         *\n         * @param {Number} productId - product Id\n         * @returns {Object|undefined}\n         * @private\n         */\n        _getProductById: function (productId) {\n            return _.find(customerData.get('cart')().items, function (item) {\n                return productId === Number(item['item_id']);\n            });\n        },\n\n        /**\n         * @param {String} url - ajax url\n         * @param {Object} data - post data for ajax call\n         * @param {Object} elem - element that initiated the event\n         * @param {Function} callback - callback method to execute after AJAX success\n         */\n        _ajax: function (url, data, elem, callback) {\n            $.extend(data, {\n                'form_key': $.mage.cookies.get('form_key')\n            });\n\n            $.ajax({\n                url: url,\n                data: data,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    elem.attr('disabled', 'disabled');\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    elem.attr('disabled', null);\n                }\n            })\n                .done(function (response) {\n                    var msg;\n\n                    if (response.success) {\n                        callback.call(this, elem, response);\n                    } else {\n                        msg = response['error_message'];\n\n                        if (msg) {\n                            alert({\n                                content: msg\n                            });\n                        }\n                    }\n                })\n                .fail(function (error) {\n                    console.log(JSON.stringify(error));\n                });\n        },\n\n        /**\n         * Calculate height of minicart list\n         *\n         * @private\n         */\n        _calcHeight: function () {\n            var self = this,\n                height = 0,\n                counter = this.options.minicart.maxItemsVisible,\n                target = $(this.options.minicart.list),\n                outerHeight;\n\n            self.scrollHeight = 0;\n            target.children().each(function () {\n\n                if ($(this).find('.options').length > 0) {\n                    $(this).collapsible();\n                }\n                outerHeight = $(this).outerHeight(true);\n\n                if (counter-- > 0) {\n                    height += outerHeight;\n                }\n                self.scrollHeight += outerHeight;\n            });\n\n            target.parent().height(height);\n        }\n    });\n\n    return $.mage.sidebar;\n});\n","Magento_Checkout/js/shopping-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    $.widget('mage.shoppingCart', {\n        /** @inheritdoc */\n        _create: function () {\n            var items, i, reload;\n\n            $(this.options.emptyCartButton).on('click', $.proxy(function () {\n                this._confirmClearCart();\n            }, this));\n            items = $.find('[data-role=\"cart-item-qty\"]');\n\n            for (i = 0; i < items.length; i++) {\n                $(items[i]).on('keypress', $.proxy(function (event) { //eslint-disable-line no-loop-func\n                    var keyCode = event.keyCode ? event.keyCode : event.which;\n\n                    if (keyCode == 13) { //eslint-disable-line eqeqeq\n                        $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n                        $(this.options.updateCartActionContainer)\n                            .attr('name', 'update_cart_action').attr('value', 'update_qty');\n\n                    }\n                }, this));\n            }\n            $(this.options.continueShoppingButton).on('click', $.proxy(function () {\n                location.href = this.options.continueShoppingUrl;\n            }, this));\n\n            $(document).on('ajax:removeFromCart', $.proxy(function () {\n                reload = true;\n                $('div.block.block-minicart').on('dropdowndialogclose', $.proxy(function () {\n                    if (reload === true) {\n                        location.reload();\n                        reload = false;\n                    }\n                    $('div.block.block-minicart').off('dropdowndialogclose');\n                }));\n            }, this));\n            $(document).on('ajax:updateItemQty', $.proxy(function () {\n                reload = true;\n                $('div.block.block-minicart').on('dropdowndialogclose', $.proxy(function () {\n                    if (reload === true) {\n                        location.reload();\n                        reload = false;\n                    }\n                    $('div.block.block-minicart').off('dropdowndialogclose');\n                }));\n            }, this));\n        },\n\n        /**\n         * Display confirmation modal for clearing the cart\n         * @private\n         */\n        _confirmClearCart: function () {\n            var self = this;\n\n            confirm({\n                content: $.mage.__('Are you sure you want to remove all items from your shopping cart?'),\n                actions: {\n                    /**\n                     * Confirmation modal handler to execute clear cart action\n                     */\n                    confirm: function () {\n                        self.clearCart();\n                    }\n                }\n            });\n        },\n\n        /**\n         * Prepares the form and submit to clear the cart\n         * @public\n         */\n        clearCart: function () {\n            $(this.options.emptyCartButton).attr('name', 'update_cart_action_temp');\n            $(this.options.updateCartActionContainer)\n                .attr('name', 'update_cart_action').attr('value', 'empty_cart');\n\n            if ($(this.options.emptyCartButton).parents('form').length > 0) {\n                $(this.options.emptyCartButton).parents('form').trigger('submit');\n            }\n        }\n    });\n\n    return $.mage.shoppingCart;\n});\n","Magento_Checkout/js/proceed-to-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/authentication-popup',\n    'Magento_Customer/js/customer-data'\n], function ($, authenticationPopup, customerData) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).on('click', function (event) {\n            var cart = customerData.get('cart'),\n                customer = customerData.get('customer');\n\n            event.preventDefault();\n\n            if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {\n                authenticationPopup.showModal();\n\n                return false;\n            }\n            $(element).attr('disabled', true);\n            location.href = config.checkoutUrl;\n        });\n\n    };\n});\n","Magento_Checkout/js/checkout-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Checkout adapter for customer data storage\n *\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'mageUtils',\n    'jquery/jquery-storageapi'\n], function ($, storage, utils) {\n    'use strict';\n\n    var cacheKey = 'checkout-data',\n\n        /**\n         * @param {Object} data\n         */\n        saveData = function (data) {\n            storage.set(cacheKey, data);\n        },\n\n        /**\n         * @return {*}\n         */\n        initData = function () {\n            return {\n                'selectedShippingAddress': null, //Selected shipping address pulled from persistence storage\n                'shippingAddressFromData': null, //Shipping address pulled from persistence storage\n                'newCustomerShippingAddress': null, //Shipping address pulled from persistence storage for customer\n                'selectedShippingRate': null, //Shipping rate pulled from persistence storage\n                'selectedPaymentMethod': null, //Payment method pulled from persistence storage\n                'selectedBillingAddress': null, //Selected billing address pulled from persistence storage\n                'billingAddressFromData': null, //Billing address pulled from persistence storage\n                'newCustomerBillingAddress': null //Billing address pulled from persistence storage for new customer\n            };\n        },\n\n        /**\n         * @return {*}\n         */\n        getData = function () {\n            var data = storage.get(cacheKey)();\n\n            if ($.isEmptyObject(data)) {\n                data = $.initNamespaceStorage('mage-cache-storage').localStorage.get(cacheKey);\n\n                if ($.isEmptyObject(data)) {\n                    data = initData();\n                    saveData(data);\n                }\n            }\n\n            return data;\n        };\n\n    return {\n        /**\n         * Setting the selected shipping address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedShippingAddress: function (data) {\n            var obj = getData();\n\n            obj.selectedShippingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected shipping address from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedShippingAddress: function () {\n            return getData().selectedShippingAddress;\n        },\n\n        /**\n         * Setting the shipping address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setShippingAddressFromData: function (data) {\n            var obj = getData();\n\n            obj.shippingAddressFromData = utils.filterFormData(data);\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the shipping address from persistence storage\n         *\n         * @return {*}\n         */\n        getShippingAddressFromData: function () {\n            return getData().shippingAddressFromData;\n        },\n\n        /**\n         * Setting the shipping address pulled from persistence storage for new customer\n         *\n         * @param {Object} data\n         */\n        setNewCustomerShippingAddress: function (data) {\n            var obj = getData();\n\n            obj.newCustomerShippingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the shipping address from persistence storage for new customer\n         *\n         * @return {*}\n         */\n        getNewCustomerShippingAddress: function () {\n            return getData().newCustomerShippingAddress;\n        },\n\n        /**\n         * Setting the selected shipping rate pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedShippingRate: function (data) {\n            var obj = getData();\n\n            obj.selectedShippingRate = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected shipping rate from local storage\n         *\n         * @return {*}\n         */\n        getSelectedShippingRate: function () {\n            return getData().selectedShippingRate;\n        },\n\n        /**\n         * Setting the selected payment method pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedPaymentMethod: function (data) {\n            var obj = getData();\n\n            obj.selectedPaymentMethod = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the payment method from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedPaymentMethod: function () {\n            return getData().selectedPaymentMethod;\n        },\n\n        /**\n         * Setting the selected billing address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setSelectedBillingAddress: function (data) {\n            var obj = getData();\n\n            obj.selectedBillingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the selected billing address from persistence storage\n         *\n         * @return {*}\n         */\n        getSelectedBillingAddress: function () {\n            return getData().selectedBillingAddress;\n        },\n\n        /**\n         * Setting the billing address pulled from persistence storage\n         *\n         * @param {Object} data\n         */\n        setBillingAddressFromData: function (data) {\n            var obj = getData();\n\n            obj.billingAddressFromData = utils.filterFormData(data);\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the billing address from persistence storage\n         *\n         * @return {*}\n         */\n        getBillingAddressFromData: function () {\n            return getData().billingAddressFromData;\n        },\n\n        /**\n         * Setting the billing address pulled from persistence storage for new customer\n         *\n         * @param {Object} data\n         */\n        setNewCustomerBillingAddress: function (data) {\n            var obj = getData();\n\n            obj.newCustomerBillingAddress = data;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the billing address from persistence storage for new customer\n         *\n         * @return {*}\n         */\n        getNewCustomerBillingAddress: function () {\n            return getData().newCustomerBillingAddress;\n        },\n\n        /**\n         * Pulling the email address from persistence storage\n         *\n         * @return {*}\n         */\n        getValidatedEmailValue: function () {\n            var obj = getData();\n\n            return obj.validatedEmailValue ? obj.validatedEmailValue : '';\n        },\n\n        /**\n         * Setting the email address pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setValidatedEmailValue: function (email) {\n            var obj = getData();\n\n            obj.validatedEmailValue = email;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the email input field value from persistence storage\n         *\n         * @return {*}\n         */\n        getInputFieldEmailValue: function () {\n            var obj = getData();\n\n            return obj.inputFieldEmailValue ? obj.inputFieldEmailValue : '';\n        },\n\n        /**\n         * Setting the email input field value pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setInputFieldEmailValue: function (email) {\n            var obj = getData();\n\n            obj.inputFieldEmailValue = email;\n            saveData(obj);\n        },\n\n        /**\n         * Pulling the checked email value from persistence storage\n         *\n         * @return {*}\n         */\n        getCheckedEmailValue: function () {\n            var obj = getData();\n\n            return obj.checkedEmailValue ? obj.checkedEmailValue : '';\n        },\n\n        /**\n         * Setting the checked email value pulled from persistence storage\n         *\n         * @param {String} email\n         */\n        setCheckedEmailValue: function (email) {\n            var obj = getData();\n\n            obj.checkedEmailValue = email;\n            saveData(obj);\n        }\n    };\n});\n","Magento_Checkout/js/action/set-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'jquery',\n        'Magento_Checkout/js/model/quote',\n        'Magento_Checkout/js/model/url-builder',\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Customer/js/model/customer',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Checkout/js/action/get-payment-information'\n    ],\n    function ($,\n              quote,\n              urlBuilder,\n              storage,\n              errorProcessor,\n              customer,\n              fullScreenLoader,\n              getPaymentInformationAction\n    ) {\n        'use strict';\n\n        return function (messageContainer) {\n            var serviceUrl,\n                payload;\n\n            /**\n             * Checkout for guest and registered customer.\n             */\n            if (!customer.isLoggedIn()) {\n                serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/billing-address', {\n                    cartId: quote.getQuoteId()\n                });\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            } else {\n                serviceUrl = urlBuilder.createUrl('/carts/mine/billing-address', {});\n                payload = {\n                    cartId: quote.getQuoteId(),\n                    address: quote.billingAddress()\n                };\n            }\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload)\n            ).done(\n                function () {\n                    var deferred = $.Deferred();\n\n                    getPaymentInformationAction(deferred);\n                    $.when(deferred).done(function () {\n                        fullScreenLoader.stopLoader();\n                    });\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/action/set-payment-information-extended.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/action/get-totals',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'underscore',\n    'Magento_Checkout/js/model/payment/place-order-hooks'\n], function (quote, urlBuilder, storage, errorProcessor, customer, getTotalsAction, fullScreenLoader, _, hooks) {\n    'use strict';\n\n    /**\n     * Filter template data.\n     *\n     * @param {Object|Array} data\n     */\n    var filterTemplateData = function (data) {\n        return _.each(data, function (value, key, list) {\n            if (_.isArray(value) || _.isObject(value)) {\n                list[key] = filterTemplateData(value);\n            }\n\n            if (key === '__disableTmpl' || key === 'title') {\n                delete list[key];\n            }\n        });\n    };\n\n    return function (messageContainer, paymentData, skipBilling) {\n        var serviceUrl,\n            payload,\n            headers = {};\n\n        paymentData = filterTemplateData(paymentData);\n        skipBilling = skipBilling || false;\n        payload = {\n            cartId: quote.getQuoteId(),\n            paymentMethod: paymentData\n        };\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/set-payment-information', {\n                cartId: quote.getQuoteId()\n            });\n            payload.email = quote.guestEmail;\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/set-payment-information', {});\n        }\n\n        if (skipBilling === false) {\n            payload.billingAddress = quote.billingAddress();\n        }\n\n        fullScreenLoader.startLoader();\n\n        _.each(hooks.requestModifiers, function (modifier) {\n            modifier(headers, payload);\n        });\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload), true, 'application/json', headers\n        ).fail(\n            function (response) {\n                errorProcessor.process(response, messageContainer);\n            }\n        ).always(\n            function () {\n                fullScreenLoader.stopLoader();\n                _.each(hooks.afterRequestListeners, function (listener) {\n                    listener();\n                });\n            }\n        );\n    };\n});\n","Magento_Checkout/js/action/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/place-order'\n], function (quote, urlBuilder, customer, placeOrderService) {\n    'use strict';\n\n    return function (paymentData, messageContainer) {\n        var serviceUrl, payload;\n\n        payload = {\n            cartId: quote.getQuoteId(),\n            billingAddress: quote.billingAddress(),\n            paymentMethod: paymentData\n        };\n\n        if (customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        } else {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:quoteId/payment-information', {\n                quoteId: quote.getQuoteId()\n            });\n            payload.email = quote.guestEmail;\n        }\n\n        return placeOrderService(serviceUrl, payload, messageContainer);\n    };\n});\n","Magento_Checkout/js/action/get-totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    '../model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/error-processor',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals'\n], function ($, quote, resourceUrlManager, errorProcessor, storage, totals) {\n    'use strict';\n\n    return function (callbacks, deferred) {\n        deferred = deferred || $.Deferred();\n        totals.isLoading(true);\n\n        return storage.get(\n            resourceUrlManager.getUrlForCartTotals(quote),\n            false\n        ).done(function (response) {\n            var proceed = true;\n\n            totals.isLoading(false);\n\n            if (callbacks.length > 0) {\n                $.each(callbacks, function (index, callback) {\n                    proceed = proceed && callback();\n                });\n            }\n\n            if (proceed) {\n                quote.setTotals(response);\n                deferred.resolve();\n            }\n        }).fail(function (response) {\n            totals.isLoading(false);\n            deferred.reject();\n            errorProcessor.process(response);\n        }).always(function () {\n            totals.isLoading(false);\n        });\n    };\n});\n","Magento_Checkout/js/action/get-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/url-builder',\n    'mage/storage',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/payment-service'\n], function ($, quote, urlBuilder, storage, errorProcessor, customer, methodConverter, paymentService) {\n    'use strict';\n\n    return function (deferred, messageContainer) {\n        var serviceUrl;\n\n        deferred = deferred || $.Deferred();\n\n        /**\n         * Checkout for guest and registered customer.\n         */\n        if (!customer.isLoggedIn()) {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/payment-information', {\n                cartId: quote.getQuoteId()\n            });\n        } else {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});\n        }\n\n        return storage.get(\n            serviceUrl, false\n        ).done(function (response) {\n            quote.setTotals(response.totals);\n            paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n            deferred.resolve();\n        }).fail(function (response) {\n            errorProcessor.process(response, messageContainer);\n            deferred.reject();\n        });\n    };\n});\n","Magento_Checkout/js/action/update-shopping-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'jquery',\n    'mage/translate',\n    'jquery-ui-modules/widget',\n    'mage/validation'\n], function (alert, confirm, $, $t) {\n    'use strict';\n\n    $.widget('mage.updateShoppingCart', {\n        options: {\n            validationURL: '',\n            eventName: 'updateCartItemQty',\n            updateCartActionContainer: '',\n            isCartHasUpdatedContent: false\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._on(this.element, {\n                'submit': this.onSubmit\n            });\n            this._on('[data-role=cart-item-qty]', {\n                'change': function () {\n                    this.isCartHasUpdatedContent = true;\n                }\n            });\n            this._on('ul.pages-items', {\n                'click a': function (event) {\n                    if (this.isCartHasUpdatedContent) {\n                        event.preventDefault();\n                        this.changePageConfirm($(event.currentTarget).attr('href'));\n                    }\n                }\n            });\n        },\n\n        /**\n         * Show the confirmation popup\n         * @param nextPageUrl\n         */\n        changePageConfirm: function (nextPageUrl) {\n            confirm({\n                title: $t('Are you sure you want to leave the page?'),\n                content: $t('Changes you made to the cart will not be saved.'),\n                actions: {\n                    confirm: function () {\n                        window.location.href = nextPageUrl;\n                    }\n                },\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss',\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }, {\n                    text: $t('Leave'),\n                    class: 'action-primary action-accept',\n                    click: function (event) {\n                        this.closeModal(event, true);\n                    }\n                }]\n            });\n        },\n\n        /**\n         * Prevents default submit action and calls form validator.\n         *\n         * @param {Event} event\n         * @return {Boolean}\n         */\n        onSubmit: function (event) {\n            var action = this.element.find(this.options.updateCartActionContainer).val();\n\n            if (!this.options.validationURL || action === 'empty_cart') {\n                return true;\n            }\n\n            if (this.isValid()) {\n                event.preventDefault();\n                this.validateItems(this.options.validationURL, this.element.serialize());\n            }\n\n            return false;\n        },\n\n        /**\n         * Validates requested form.\n         *\n         * @return {Boolean}\n         */\n        isValid: function () {\n            return this.element.validation() && this.element.validation('isValid');\n        },\n\n        /**\n         * Validates updated shopping cart data.\n         *\n         * @param {String} url - request url\n         * @param {Object} data - post data for ajax call\n         */\n        validateItems: function (url, data) {\n            $.extend(data, {\n                'form_key': $.mage.cookies.get('form_key')\n            });\n\n            $.ajax({\n                url: url,\n                data: data,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    $(document.body).trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $(document.body).trigger('processStop');\n                }\n            })\n                .done(function (response) {\n                    if (response.success) {\n                        this.onSuccess();\n                    } else {\n                        this.onError(response);\n                    }\n                })\n                .fail(function () {\n                    this.submitForm();\n                });\n        },\n\n        /**\n         * Form validation succeed.\n         */\n        onSuccess: function () {\n            $(document).trigger('ajax:' + this.options.eventName);\n            this.submitForm();\n        },\n\n        /**\n         * Form validation failed.\n         */\n        onError: function (response) {\n            var that = this,\n                elm,\n                responseData = [];\n\n            try {\n                responseData = JSON.parse(response['error_message']);\n            } catch (error) {\n            }\n\n            if (response['error_message']) {\n                try {\n                    $.each(responseData, function (index, data) {\n\n                        if (data.itemId !== undefined) {\n                            elm = $('#cart-' + data.itemId + '-qty');\n                            elm.val(elm.attr('data-item-qty'));\n                        }\n                        response['error_message'] = data.error;\n                    });\n                } catch (e) {}\n                alert({\n                    content: response['error_message'],\n                    actions: {\n                        /** @inheritdoc */\n                        always: function () {\n                            that.submitForm();\n                        }\n                    }\n                });\n            } else {\n                this.submitForm();\n            }\n        },\n\n        /**\n         * Real submit of validated form.\n         */\n        submitForm: function () {\n            this.element\n                .off('submit', this.onSubmit)\n                .on('submit', function () {\n                    $(document.body).trigger('processStart');\n                })\n                .trigger('submit');\n        }\n    });\n\n    return $.mage.updateShoppingCart;\n});\n","Magento_Checkout/js/action/select-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    '../model/quote'\n], function ($, quote) {\n    'use strict';\n\n    return function (billingAddress) {\n        var address = null;\n\n        if (quote.shippingAddress() && billingAddress.getCacheKey() == //eslint-disable-line eqeqeq\n            quote.shippingAddress().getCacheKey()\n        ) {\n            address = $.extend(true, {}, billingAddress);\n            address.saveInAddressBook = null;\n        } else {\n            address = billingAddress;\n        }\n        quote.billingAddress(address);\n    };\n});\n","Magento_Checkout/js/action/recollect-shipping-rates.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/shipping-rate-registry'\n], function (quote, selectShippingAddress, rateRegistry) {\n    'use strict';\n\n    return function () {\n        var shippingAddress = null;\n\n        if (!quote.isVirtual()) {\n            shippingAddress = quote.shippingAddress();\n\n            rateRegistry.set(shippingAddress.getCacheKey(), null);\n            selectShippingAddress(shippingAddress);\n        }\n    };\n});\n","Magento_Checkout/js/action/set-payment-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/action/set-payment-information-extended'\n\n], function (setPaymentInformationExtended) {\n    'use strict';\n\n    return function (messageContainer, paymentData) {\n\n        return setPaymentInformationExtended(messageContainer, paymentData, false);\n    };\n});\n","Magento_Checkout/js/action/select-payment-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (paymentMethod) {\n        if (paymentMethod) {\n            paymentMethod.__disableTmpl = {\n                title: true\n            };\n        }\n        quote.paymentMethod(paymentMethod);\n    };\n});\n","Magento_Checkout/js/action/select-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingAddress) {\n        quote.shippingAddress(shippingAddress);\n    };\n});\n","Magento_Checkout/js/action/select-shipping-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote'\n], function (quote) {\n    'use strict';\n\n    return function (shippingMethod) {\n        quote.shippingMethod(shippingMethod);\n    };\n});\n","Magento_Checkout/js/action/create-billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/address-converter'\n], function (addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        var address = addressConverter.formAddressDataToQuoteAddress(addressData);\n\n        /**\n         * Returns new customer billing address type.\n         *\n         * @returns {String}\n         */\n        address.getType = function () {\n            return 'new-customer-billing-address';\n        };\n\n        return address;\n    };\n});\n","Magento_Checkout/js/action/redirect-on-success.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(\n    [\n        'mage/url',\n        'Magento_Checkout/js/model/full-screen-loader'\n    ],\n    function (url, fullScreenLoader) {\n        'use strict';\n\n        return {\n            redirectUrl: window.checkoutConfig.defaultSuccessPageUrl,\n\n            /**\n             * Provide redirect to page\n             */\n            execute: function () {\n                fullScreenLoader.startLoader();\n                this.redirectToSuccessPage();\n            },\n\n            /**\n             * Redirect to success page.\n             */\n            redirectToSuccessPage: function () {\n                window.location.replace(url.build(this.redirectUrl));\n            }\n        };\n    }\n);\n","Magento_Checkout/js/action/create-shipping-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/address-converter'\n], function (addressList, addressConverter) {\n    'use strict';\n\n    return function (addressData) {\n        var address = addressConverter.formAddressDataToQuoteAddress(addressData),\n            isAddressUpdated = addressList().some(function (currentAddress, index, addresses) {\n                if (currentAddress.getKey() == address.getKey()) { //eslint-disable-line eqeqeq\n                    addresses[index] = address;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n        if (!isAddressUpdated) {\n            addressList.push(address);\n        } else {\n            addressList.valueHasMutated();\n        }\n\n        return address;\n    };\n});\n","Magento_Checkout/js/action/set-shipping-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    '../model/quote',\n    'Magento_Checkout/js/model/shipping-save-processor'\n], function (quote, shippingSaveProcessor) {\n    'use strict';\n\n    return function () {\n        return shippingSaveProcessor.saveShippingInformation(quote.shippingAddress().getType());\n    };\n});\n","Magento_Checkout/js/model/payment-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/action/select-payment-method'\n], function (_, quote, methodList, selectPaymentMethod) {\n    'use strict';\n\n    /**\n    * Free method filter\n    * @param {Object} paymentMethod\n    * @return {Boolean}\n    */\n    var isFreePaymentMethod = function (paymentMethod) {\n            return paymentMethod.method === 'free';\n        },\n\n        /**\n         * Grabs the grand total from quote\n         * @return {Number}\n         */\n        getGrandTotal = function () {\n            return quote.totals()['grand_total'];\n        };\n\n    return {\n        isFreeAvailable: false,\n\n        /**\n         * Populate the list of payment methods\n         * @param {Array} methods\n         */\n        setPaymentMethods: function (methods) {\n            var freeMethod,\n                filteredMethods,\n                methodIsAvailable,\n                methodNames;\n\n            freeMethod = _.find(methods, isFreePaymentMethod);\n            this.isFreeAvailable = !!freeMethod;\n\n            if (freeMethod && getGrandTotal() <= 0) {\n                methods.splice(0, methods.length, freeMethod);\n                selectPaymentMethod(freeMethod);\n            }\n\n            filteredMethods = _.without(methods, freeMethod);\n            if (filteredMethods.length === 1) {\n                selectPaymentMethod(filteredMethods[0]);\n            } else if (quote.paymentMethod()) {\n                methodIsAvailable = methods.some(function (item) {\n                    return item.method === quote.paymentMethod().method;\n                });\n\n                if (!methodIsAvailable && !_.isEmpty(window.checkoutConfig.vault)) {\n                    methodIsAvailable = Object.keys(window.checkoutConfig.payment.vault)\n                        .findIndex((vaultPayment) => vaultPayment === quote.paymentMethod().method) !== -1;\n                }\n\n                //Unset selected payment method if not available\n                if (!methodIsAvailable) {\n                    selectPaymentMethod(null);\n                }\n            }\n\n            /**\n             * Overwrite methods with existing methods to preserve ko array references.\n             * This prevent ko from re-rendering those methods.\n             */\n            methodNames = _.pluck(methods, 'method');\n            _.map(methodList(), function (existingMethod) {\n                var existingMethodIndex = methodNames.indexOf(existingMethod.method);\n\n                if (existingMethodIndex !== -1) {\n                    methods[existingMethodIndex] = existingMethod;\n                }\n            });\n\n            methodList(methods);\n        },\n\n        /**\n         * Get the list of available payment methods.\n         * @return {Array}\n         */\n        getAvailablePaymentMethods: function () {\n            var allMethods = methodList().slice(),\n                grandTotalOverZero = getGrandTotal() > 0;\n\n            if (!this.isFreeAvailable) {\n                return allMethods;\n            }\n\n            if (grandTotalOverZero) {\n                return _.reject(allMethods, isFreePaymentMethod);\n            }\n\n            return _.filter(allMethods, isFreePaymentMethod);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/checkout-data-resolver'\n], function (ko, checkoutDataResolver) {\n    'use strict';\n\n    var shippingRates = ko.observableArray([]);\n\n    return {\n        isLoading: ko.observable(false),\n\n        /**\n         * Set shipping rates\n         *\n         * @param {*} ratesData\n         */\n        setShippingRates: function (ratesData) {\n            shippingRates(ratesData);\n            shippingRates.valueHasMutated();\n            checkoutDataResolver.resolveShippingRates(ratesData);\n        },\n\n        /**\n         * Get shipping rates\n         *\n         * @returns {*}\n         */\n        getShippingRates: function () {\n            return shippingRates;\n        }\n    };\n});\n","Magento_Checkout/js/model/checkout-data-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Checkout adapter for customer data storage\n */\ndefine([\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/action/select-payment-method',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/action/create-billing-address',\n    'underscore'\n], function (\n    addressList,\n    quote,\n    checkoutData,\n    createShippingAddress,\n    selectShippingAddress,\n    selectShippingMethodAction,\n    paymentService,\n    selectPaymentMethodAction,\n    addressConverter,\n    selectBillingAddress,\n    createBillingAddress,\n    _\n) {\n    'use strict';\n\n    var isBillingAddressResolvedFromBackend = false;\n\n    return {\n\n        /**\n         * Resolve estimation address. Used local storage\n         */\n        resolveEstimationAddress: function () {\n            var address;\n\n            if (quote.isVirtual()) {\n                if (checkoutData.getBillingAddressFromData()) {\n                    address = addressConverter.formAddressDataToQuoteAddress(\n                        checkoutData.getBillingAddressFromData()\n                    );\n                    selectBillingAddress(address);\n                } else {\n                    this.resolveBillingAddress();\n                }\n            } else if (checkoutData.getShippingAddressFromData()) {\n                address = addressConverter.formAddressDataToQuoteAddress(checkoutData.getShippingAddressFromData());\n                selectShippingAddress(address);\n            } else {\n                this.resolveShippingAddress();\n            }\n        },\n\n        /**\n         * Resolve shipping address. Used local storage\n         */\n        resolveShippingAddress: function () {\n            var newCustomerShippingAddress;\n\n            if (!checkoutData.getShippingAddressFromData() &&\n                window.checkoutConfig.shippingAddressFromData\n            ) {\n                checkoutData.setShippingAddressFromData(window.checkoutConfig.shippingAddressFromData);\n            }\n\n            newCustomerShippingAddress = checkoutData.getNewCustomerShippingAddress();\n\n            if (newCustomerShippingAddress) {\n                createShippingAddress(newCustomerShippingAddress);\n            }\n            this.applyShippingAddress();\n        },\n\n        /**\n         * Apply resolved estimated address to quote\n         *\n         * @param {Object} isEstimatedAddress\n         */\n        applyShippingAddress: function (isEstimatedAddress) {\n            var address,\n                shippingAddress,\n                isConvertAddress;\n\n            if (addressList().length === 0) {\n                address = addressConverter.formAddressDataToQuoteAddress(\n                    checkoutData.getShippingAddressFromData()\n                );\n                selectShippingAddress(address);\n            }\n            shippingAddress = quote.shippingAddress();\n            isConvertAddress = isEstimatedAddress || false;\n\n            if (!shippingAddress) {\n                shippingAddress = this.getShippingAddressFromCustomerAddressList();\n\n                if (shippingAddress) {\n                    selectShippingAddress(\n                        isConvertAddress ?\n                            addressConverter.addressToEstimationAddress(shippingAddress)\n                            : shippingAddress\n                    );\n                }\n            }\n        },\n\n        /**\n         * @param {Object} ratesData\n         */\n        resolveShippingRates: function (ratesData) {\n            var selectedShippingRate = checkoutData.getSelectedShippingRate(),\n                availableRate = false;\n\n            if (ratesData.length === 1 && !quote.shippingMethod()) {\n                //set shipping rate if we have only one available shipping rate\n                selectShippingMethodAction(ratesData[0]);\n\n                return;\n            }\n\n            if (quote.shippingMethod()) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] == quote.shippingMethod()['carrier_code'] && //eslint-disable-line\n                        rate['method_code'] == quote.shippingMethod()['method_code']; //eslint-disable-line eqeqeq\n                });\n            }\n\n            if (!availableRate && selectedShippingRate) {\n                availableRate = _.find(ratesData, function (rate) {\n                    return rate['carrier_code'] + '_' + rate['method_code'] === selectedShippingRate;\n                });\n            }\n\n            if (!availableRate && window.checkoutConfig.selectedShippingMethod) {\n                availableRate = _.find(ratesData, function (rate) {\n                    var selectedShippingMethod = window.checkoutConfig.selectedShippingMethod;\n\n                    return rate['carrier_code'] == selectedShippingMethod['carrier_code'] && //eslint-disable-line\n                        rate['method_code'] == selectedShippingMethod['method_code']; //eslint-disable-line eqeqeq\n                });\n            }\n\n            //Unset selected shipping method if not available\n            if (!availableRate) {\n                selectShippingMethodAction(null);\n            } else {\n                selectShippingMethodAction(availableRate);\n            }\n        },\n\n        /**\n         * Resolve payment method. Used local storage\n         */\n        resolvePaymentMethod: function () {\n            var availablePaymentMethods = paymentService.getAvailablePaymentMethods(),\n                selectedPaymentMethod = checkoutData.getSelectedPaymentMethod();\n\n            if (selectedPaymentMethod) {\n                availablePaymentMethods.some(function (payment) {\n                    if (payment.method == selectedPaymentMethod) { //eslint-disable-line eqeqeq\n                        selectPaymentMethodAction(payment);\n                    }\n                });\n            }\n        },\n\n        /**\n         * Resolve billing address. Used local storage\n         */\n        resolveBillingAddress: function () {\n            var selectedBillingAddress,\n                newCustomerBillingAddressData;\n\n            selectedBillingAddress = checkoutData.getSelectedBillingAddress();\n            newCustomerBillingAddressData = checkoutData.getNewCustomerBillingAddress();\n\n            if (selectedBillingAddress) {\n                if (selectedBillingAddress === 'new-customer-billing-address' && newCustomerBillingAddressData) {\n                    selectBillingAddress(createBillingAddress(newCustomerBillingAddressData));\n                } else {\n                    addressList.some(function (address) {\n                        if (selectedBillingAddress === address.getKey()) {\n                            selectBillingAddress(address);\n                        }\n                    });\n                }\n            } else {\n                this.applyBillingAddress();\n            }\n\n            if (!isBillingAddressResolvedFromBackend &&\n                !checkoutData.getBillingAddressFromData() &&\n                !_.isEmpty(window.checkoutConfig.billingAddressFromData) &&\n                !quote.billingAddress()\n            ) {\n                if (window.checkoutConfig.isBillingAddressFromDataValid === true) {\n                    selectBillingAddress(createBillingAddress(window.checkoutConfig.billingAddressFromData));\n                } else {\n                    checkoutData.setBillingAddressFromData(window.checkoutConfig.billingAddressFromData);\n                }\n                isBillingAddressResolvedFromBackend = true;\n            }\n        },\n\n        /**\n         * Apply resolved billing address to quote\n         */\n        applyBillingAddress: function () {\n            var shippingAddress,\n                isBillingAddressInitialized;\n\n            if (quote.billingAddress()) {\n                selectBillingAddress(quote.billingAddress());\n\n                return;\n            }\n\n            if (quote.isVirtual() || !quote.billingAddress()) {\n                isBillingAddressInitialized = addressList.some(function (addrs) {\n                    if (addrs.isDefaultBilling()) {\n                        selectBillingAddress(addrs);\n\n                        return true;\n                    }\n\n                    return false;\n                });\n            }\n\n            shippingAddress = quote.shippingAddress();\n\n            if (!isBillingAddressInitialized &&\n                shippingAddress &&\n                shippingAddress.canUseForBilling() &&\n                (shippingAddress.isDefaultShipping() || !quote.isVirtual())\n            ) {\n                //set billing address same as shipping by default if it is not empty\n                selectBillingAddress(quote.shippingAddress());\n            }\n        },\n\n        /**\n         * Get shipping address from address list\n         *\n         * @return {Object|null}\n         */\n        getShippingAddressFromCustomerAddressList: function () {\n            var shippingAddress = _.find(\n                    addressList(),\n                    function (address) {\n                        return checkoutData.getSelectedShippingAddress() == address.getKey() //eslint-disable-line\n                    }\n                );\n\n            if (!shippingAddress) {\n                shippingAddress = _.find(\n                    addressList(),\n                    function (address) {\n                        return address.isDefaultShipping();\n                    }\n                );\n            }\n\n            if (!shippingAddress && addressList().length === 1) {\n                shippingAddress = addressList()[0];\n            }\n\n            return shippingAddress;\n        }\n    };\n});\n","Magento_Checkout/js/model/quote.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'domReady!'\n], function (ko, _) {\n    'use strict';\n\n    /**\n     * Get totals data from the extension attributes.\n     * @param {*} data\n     * @returns {*}\n     */\n    var proceedTotalsData = function (data) {\n            if (_.isObject(data) && _.isObject(data['extension_attributes'])) {\n                _.each(data['extension_attributes'], function (element, index) {\n                    data[index] = element;\n                });\n            }\n\n            return data;\n        },\n        billingAddress = ko.observable(null),\n        shippingAddress = ko.observable(null),\n        shippingMethod = ko.observable(null),\n        paymentMethod = ko.observable(null),\n        quoteData = window.checkoutConfig.quoteData,\n        basePriceFormat = window.checkoutConfig.basePriceFormat,\n        priceFormat = window.checkoutConfig.priceFormat,\n        storeCode = window.checkoutConfig.storeCode,\n        totalsData = proceedTotalsData(window.checkoutConfig.totalsData),\n        totals = ko.observable(totalsData),\n        collectedTotals = ko.observable({});\n\n    return {\n        totals: totals,\n        shippingAddress: shippingAddress,\n        shippingMethod: shippingMethod,\n        billingAddress: billingAddress,\n        paymentMethod: paymentMethod,\n        guestEmail: null,\n\n        /**\n         * @return {*}\n         */\n        getQuoteId: function () {\n            return quoteData['entity_id'];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isVirtual: function () {\n            return !!Number(quoteData['is_virtual']);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPriceFormat: function () {\n            return priceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getBasePriceFormat: function () {\n            return basePriceFormat;\n        },\n\n        /**\n         * @return {*}\n         */\n        getItems: function () {\n            return window.checkoutConfig.quoteItemData;\n        },\n\n        /**\n         *\n         * @return {*}\n         */\n        getTotals: function () {\n            return totals;\n        },\n\n        /**\n         * @param {Object} data\n         */\n        setTotals: function (data) {\n            data = proceedTotalsData(data);\n            totals(data);\n            this.setCollectedTotals('subtotal_with_discount', parseFloat(data['subtotal_with_discount']));\n        },\n\n        /**\n         * @param {*} paymentMethodCode\n         */\n        setPaymentMethod: function (paymentMethodCode) {\n            paymentMethod(paymentMethodCode);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPaymentMethod: function () {\n            return paymentMethod;\n        },\n\n        /**\n         * @return {*}\n         */\n        getStoreCode: function () {\n            return storeCode;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} value\n         */\n        setCollectedTotals: function (code, value) {\n            var colTotals = collectedTotals();\n\n            colTotals[code] = value;\n            collectedTotals(colTotals);\n        },\n\n        /**\n         * @return {Number}\n         */\n        getCalculatedTotal: function () {\n            var total = 0.; //eslint-disable-line no-floating-decimal\n\n            _.each(collectedTotals(), function (value) {\n                total += value;\n            });\n\n            return total;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPersistent: function () {\n            return !!Number(quoteData['is_persistent']);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/shipping-rate-processor/customer-address'\n], function (quote, defaultProcessor, customerAddressProcessor) {\n    'use strict';\n\n    var processors = {};\n\n    processors.default =  defaultProcessor;\n    processors['customer-address'] = customerAddressProcessor;\n\n    quote.shippingAddress.subscribe(function () {\n        var type = quote.shippingAddress().getType();\n\n        if (processors[type]) {\n            processors[type].getRates(quote.shippingAddress());\n        } else {\n            processors.default.getRates(quote.shippingAddress());\n        }\n    });\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        }\n    };\n});\n","Magento_Checkout/js/model/customer-email-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/model/customer',\n    'mage/validation'\n], function ($, customer) {\n    'use strict';\n\n    return {\n        /**\n         * Validate checkout agreements\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            var emailValidationResult = customer.isLoggedIn(),\n                loginFormSelector = 'form[data-role=email-with-possible-login]';\n\n            if (!customer.isLoggedIn()) {\n                $(loginFormSelector).validation();\n                emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n            }\n\n            return emailValidationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/place-order.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine(\n    [\n        'mage/storage',\n        'Magento_Checkout/js/model/error-processor',\n        'Magento_Checkout/js/model/full-screen-loader',\n        'Magento_Customer/js/customer-data',\n        'Magento_Checkout/js/model/payment/place-order-hooks',\n        'underscore'\n    ],\n    function (storage, errorProcessor, fullScreenLoader, customerData, hooks, _) {\n        'use strict';\n\n        return function (serviceUrl, payload, messageContainer) {\n            var headers = {}, redirectURL = '';\n\n            fullScreenLoader.startLoader();\n            _.each(hooks.requestModifiers, function (modifier) {\n                modifier(headers, payload);\n            });\n\n            return storage.post(\n                serviceUrl, JSON.stringify(payload), true, 'application/json', headers\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response, messageContainer);\n                    redirectURL = response.getResponseHeader('errorRedirectAction');\n\n                    if (redirectURL) {\n                        setTimeout(function () {\n                            errorProcessor.redirectTo(redirectURL);\n                        }, 3000);\n                    }\n                }\n            ).done(\n                function (response) {\n                    var clearData = {\n                        'selectedShippingAddress': null,\n                        'shippingAddressFromData': null,\n                        'newCustomerShippingAddress': null,\n                        'selectedShippingRate': null,\n                        'selectedPaymentMethod': null,\n                        'selectedBillingAddress': null,\n                        'billingAddressFromData': null,\n                        'newCustomerBillingAddress': null\n                    };\n\n                    if (response.responseType !== 'error') {\n                        customerData.set('checkout-data', clearData);\n                    }\n                }\n            ).always(\n                function () {\n                    fullScreenLoader.stopLoader();\n                    _.each(hooks.afterRequestListeners, function (listener) {\n                        listener();\n                    });\n                }\n            );\n        };\n    }\n);\n","Magento_Checkout/js/model/error-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/url',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate'\n], function (url, globalMessageList, $t) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} response\n         * @param {Object} messageContainer\n         */\n        process: function (response, messageContainer) {\n            var error;\n\n            messageContainer = messageContainer || globalMessageList;\n\n            if (response.status == 401) { //eslint-disable-line eqeqeq\n                this.redirectTo(url.build('customer/account/login/'));\n            } else {\n                try {\n                    error = JSON.parse(response.responseText);\n                } catch (exception) {\n                    error = {\n                        message: $t('Something went wrong with your request. Please try again later.')\n                    };\n                }\n                messageContainer.addErrorMessage(error);\n            }\n        },\n\n        /**\n         * Method to redirect by requested URL.\n         */\n        redirectTo: function (redirectUrl) {\n            window.location.replace(redirectUrl);\n        }\n    };\n});\n","Magento_Checkout/js/model/address-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/new-customer-address',\n    'Magento_Customer/js/customer-data',\n    'mage/utils/objects',\n    'underscore'\n], function ($, address, customerData, mageUtils, _) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return {\n        /**\n         * Convert address form data to Address object\n         *\n         * @param {Object} formData\n         * @returns {Object}\n         */\n        formAddressDataToQuoteAddress: function (formData) {\n            // clone address form data to new object\n            var addressData = $.extend(true, {}, formData),\n                region,\n                regionName = addressData.region,\n                customAttributes;\n\n            if (mageUtils.isObject(addressData.street)) {\n                addressData.street = this.objectToArray(addressData.street);\n            }\n\n            addressData.region = {\n                'region_id': addressData['region_id'],\n                'region_code': addressData['region_code'],\n                region: regionName\n            };\n\n            if (addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                region = countryData()[addressData['country_id']].regions[addressData['region_id']];\n\n                if (region) {\n                    addressData.region['region_id'] = addressData['region_id'];\n                    addressData.region['region_code'] = region.code;\n                    addressData.region.region = region.name;\n                }\n            } else if (\n                !addressData['region_id'] &&\n                countryData()[addressData['country_id']] &&\n                countryData()[addressData['country_id']].regions\n            ) {\n                addressData.region['region_code'] = '';\n                addressData.region.region = '';\n            }\n            delete addressData['region_id'];\n\n            if (addressData['custom_attributes']) {\n                addressData['custom_attributes'] = _.map(\n                    addressData['custom_attributes'],\n                    function (value, key) {\n                        customAttributes = {\n                            'attribute_code': key,\n                            'value': value\n                        };\n\n                        if (typeof value === 'boolean') {\n                            customAttributes = {\n                                'attribute_code': key,\n                                'value': value,\n                                'label': value === true ? 'Yes' : 'No'\n                            };\n                        }\n\n                        return customAttributes;\n                    }\n                );\n            }\n\n            return address(addressData);\n        },\n\n        /**\n         * Convert Address object to address form data.\n         *\n         * @param {Object} addrs\n         * @returns {Object}\n         */\n        quoteAddressToFormAddressData: function (addrs) {\n            var self = this,\n                output = {},\n                streetObject,\n                customAttributesObject;\n\n            $.each(addrs, function (key) {\n                if (addrs.hasOwnProperty(key) && typeof addrs[key] !== 'function') {\n                    output[self.toUnderscore(key)] = addrs[key];\n                }\n            });\n\n            if (Array.isArray(addrs.street)) {\n                streetObject = {};\n                addrs.street.forEach(function (value, index) {\n                    streetObject[index] = value;\n                });\n                output.street = streetObject;\n            }\n\n            //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            if (Array.isArray(addrs.customAttributes)) {\n                customAttributesObject = {};\n                addrs.customAttributes.forEach(function (value) {\n                    customAttributesObject[value.attribute_code] = value.value;\n                });\n                output.custom_attributes = customAttributesObject;\n            }\n            //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            return output;\n        },\n\n        /**\n         * @param {String} string\n         */\n        toUnderscore: function (string) {\n            return string.replace(/([A-Z])/g, function ($1) {\n                return '_' + $1.toLowerCase();\n            });\n        },\n\n        /**\n         * @param {Object} formProviderData\n         * @param {String} formIndex\n         * @return {Object}\n         */\n        formDataProviderToFlatData: function (formProviderData, formIndex) {\n            var addressData = {};\n\n            $.each(formProviderData, function (path, value) {\n                var pathComponents = path.split('.'),\n                    dataObject = {};\n\n                pathComponents.splice(pathComponents.indexOf(formIndex), 1);\n                pathComponents.reverse();\n                $.each(pathComponents, function (index, pathPart) {\n                    var parent = {};\n\n                    if (index == 0) { //eslint-disable-line eqeqeq\n                        dataObject[pathPart] = value;\n                    } else {\n                        parent[pathPart] = dataObject;\n                        dataObject = parent;\n                    }\n                });\n                $.extend(true, addressData, dataObject);\n            });\n\n            return addressData;\n        },\n\n        /**\n         * Convert object to array\n         * @param {Object} object\n         * @returns {Array}\n         */\n        objectToArray: function (object) {\n            var convertedArray = [];\n\n            $.each(object, function (key) {\n                return typeof object[key] === 'string' ? convertedArray.push(object[key]) : false;\n            });\n\n            return convertedArray.slice(0);\n        },\n\n        /**\n         * @param {Object} addrs\n         * @return {*|Object}\n         */\n        addressToEstimationAddress: function (addrs) {\n            var self = this,\n                estimatedAddressData = {};\n\n            $.each(addrs, function (key) {\n                estimatedAddressData[self.toUnderscore(key)] = addrs[key];\n            });\n\n            return this.formAddressDataToQuoteAddress(estimatedAddressData);\n        }\n    };\n});\n","Magento_Checkout/js/model/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        popUp: false,\n\n        /**\n         * @param {Object} popUp\n         */\n        setPopup: function (popUp) {\n            this.popUp = popUp;\n        },\n\n        /**\n         * Show popup.\n         */\n        show: function () {\n            if (this.popUp) {\n                this.popUp.modal('openModal');\n            }\n        },\n\n        /**\n         * Hide popup.\n         */\n        hide: function () {\n            if (this.popUp) {\n                this.popUp.modal('closeModal');\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var cache = [];\n\n    return {\n        /**\n         * @param {String} addressKey\n         * @return {*}\n         */\n        get: function (addressKey) {\n            if (cache[addressKey]) {\n                return cache[addressKey];\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {String} addressKey\n         * @param {*} data\n         */\n        set: function (addressKey, data) {\n            cache[addressKey] = data;\n        }\n    };\n});\n","Magento_Checkout/js/model/authentication-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Ui/js/model/messages'\n], function (ko, Messages) {\n    'use strict';\n\n    return new Messages();\n});\n","Magento_Checkout/js/model/default-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    './default-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-post-code-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Define necessity of using default post code value\n     */\n    var useDefaultPostCode;\n\n    return {\n        /**\n         * Resolve default post code\n         *\n         * @returns {String|null}\n         */\n        resolve: function () {\n            return useDefaultPostCode ?  window.checkoutConfig.defaultPostcode : null;\n        },\n\n        /**\n         * Set state to useDefaultPostCode variable\n         *\n         * @param {Boolean} shouldUseDefaultPostCode\n         * @returns {underscore}\n         */\n        setUseDefaultPostCode: function (shouldUseDefaultPostCode) {\n            useDefaultPostCode = shouldUseDefaultPostCode;\n\n            return this;\n        }\n    };\n});\n","Magento_Checkout/js/model/default-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    './shipping-rates-validation-rules',\n    '../model/address-converter',\n    '../action/select-shipping-address',\n    './postcode-validator',\n    './default-validator',\n    'mage/translate',\n    'uiRegistry',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/quote'\n], function (\n    $,\n    ko,\n    shippingRatesValidationRules,\n    addressConverter,\n    selectShippingAddress,\n    postcodeValidator,\n    defaultValidator,\n    $t,\n    uiRegistry,\n    formPopUpState,\n    shippingService\n) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig,\n        validators = [],\n        observedElements = [],\n        postcodeElements = [],\n        postcodeElementName = 'postcode';\n\n    validators.push(defaultValidator);\n\n    return {\n        validateAddressTimeout: 0,\n        validateZipCodeTimeout: 0,\n        validateDelay: 2000,\n\n        /**\n         * @param {String} carrier\n         * @param {Object} validator\n         */\n        registerValidator: function (carrier, validator) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                validators.push(validator);\n            }\n        },\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validateAddressData: function (address) {\n            return validators.some(function (validator) {\n                return validator.validate(address);\n            });\n        },\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this,\n                elements = shippingRatesValidationRules.getObservableFields();\n\n            if ($.inArray(postcodeElementName, elements) === -1) {\n                // Add postcode field to observables if not exist for zip code validation support\n                elements.push(postcodeElementName);\n            }\n\n            $.each(elements, function (index, field) {\n                uiRegistry.async(formPath + '.' + field)(self.doElementBinding.bind(self));\n            });\n        },\n\n        /**\n         * Bind shipping rates request to form element\n         *\n         * @param {Object} element\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        doElementBinding: function (element, force, delay) {\n            var observableFields = shippingRatesValidationRules.getObservableFields();\n\n            if (element && (observableFields.indexOf(element.index) !== -1 || force)) {\n                if (element.index !== postcodeElementName) {\n                    this.bindHandler(element, delay);\n                }\n            }\n\n            if (element.index === postcodeElementName) {\n                this.bindHandler(element, delay);\n                postcodeElements.push(element);\n            }\n        },\n\n        /**\n         * @param {*} elements\n         * @param {Boolean} force\n         * @param {Number} delay\n         */\n        bindChangeHandlers: function (elements, force, delay) {\n            var self = this;\n\n            $.each(elements, function (index, elem) {\n                self.doElementBinding(elem, force, delay);\n            });\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        bindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            if (element.component.indexOf('/group') !== -1) {\n                $.each(element.elems(), function (index, elem) {\n                    self.bindHandler(elem);\n                });\n            } else {\n                element.on('value', function () {\n                    clearTimeout(self.validateZipCodeTimeout);\n                    self.validateZipCodeTimeout = setTimeout(function () {\n                        if (element.index === postcodeElementName) {\n                            self.postcodeValidation(element);\n                        } else {\n                            $.each(postcodeElements, function (index, elem) {\n                                self.postcodeValidation(elem);\n                            });\n                        }\n                    }, delay);\n\n                    if (!formPopUpState.isVisible()) {\n                        // Prevent shipping methods showing none available whilst we resolve\n                        shippingService.isLoading(true);\n                        clearTimeout(self.validateAddressTimeout);\n                        self.validateAddressTimeout = setTimeout(function () {\n                            self.validateFields();\n                        }, delay);\n                    }\n                });\n                observedElements.push(element);\n            }\n        },\n\n        /**\n         * @return {*}\n         */\n        postcodeValidation: function (postcodeElement) {\n            var countryId = $('select[name=\"country_id\"]:visible').val(),\n                validationResult,\n                warnMessage;\n\n            if (postcodeElement == null || postcodeElement.value() == null) {\n                return true;\n            }\n\n            postcodeElement.warn(null);\n            validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n            if (!validationResult) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postcodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                postcodeElement.warn(warnMessage);\n            }\n\n            return validationResult;\n        },\n\n        /**\n         * Convert form data to quote address and validate fields for shipping rates\n         */\n        validateFields: function () {\n            var addressFlat = addressConverter.formDataProviderToFlatData(\n                this.collectObservedData(),\n                'shippingAddress'\n                ),\n                address;\n\n            if (this.validateAddressData(addressFlat)) {\n                addressFlat = uiRegistry.get('checkoutProvider').shippingAddress;\n                address = addressConverter.formAddressDataToQuoteAddress(addressFlat);\n                selectShippingAddress(address);\n            }\n        },\n\n        /**\n         * Collect observed fields data to object\n         *\n         * @returns {*}\n         */\n        collectObservedData: function () {\n            var observedValues = {};\n\n            $.each(observedElements, function (index, field) {\n                observedValues[field.dataScope] = field.value();\n            });\n\n            return observedValues;\n        }\n    };\n});\n","Magento_Checkout/js/model/url-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return {\n        method: 'rest',\n        storeCode: window.checkoutConfig.storeCode,\n        version: 'V1',\n        serviceUrl: ':method/:storeCode/:version',\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        createUrl: function (url, params) {\n            var completeUrl = this.serviceUrl + url;\n\n            return this.bindParams(completeUrl, params);\n        },\n\n        /**\n         * @param {String} url\n         * @param {Object} params\n         * @return {*}\n         */\n        bindParams: function (url, params) {\n            var urlParts;\n\n            params.method = this.method;\n            params.storeCode = this.storeCode;\n            params.version = this.version;\n\n            urlParts = url.split('/');\n            urlParts = urlParts.filter(Boolean);\n\n            $.each(urlParts, function (key, part) {\n                part = part.replace(':', '');\n\n                if (params[part] != undefined) { //eslint-disable-line eqeqeq\n                    urlParts[key] = params[part];\n                }\n            });\n\n            return urlParts.join('/');\n        }\n    };\n});\n","Magento_Checkout/js/model/resource-url-manager.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/url-builder',\n    'mageUtils'\n], function (customer, urlBuilder, utils) {\n        'use strict';\n\n        return {\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForTotalsEstimationForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/totals-information',\n                        'customer': '/carts/mine/totals-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsForNewAddress: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/estimate-shipping-methods',\n                        'customer': '/carts/mine/estimate-shipping-methods'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForEstimationShippingMethodsByAddressId: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'default': '/carts/mine/estimate-shipping-methods-by-address-id'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} couponCode\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getApplyCouponUrl: function (couponCode, quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/' + encodeURIComponent(couponCode),\n                        'customer': '/carts/mine/coupons/' + encodeURIComponent(couponCode)\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {String} quoteId\n             * @return {*}\n             */\n            getCancelCouponUrl: function (quoteId) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quoteId\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/' + quoteId + '/coupons/',\n                        'customer': '/carts/mine/coupons/'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForCartTotals: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            quoteId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:quoteId/totals',\n                        'customer': '/carts/mine/totals'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * @param {Object} quote\n             * @return {*}\n             */\n            getUrlForSetShippingInformation: function (quote) {\n                var params = this.getCheckoutMethod() == 'guest' ? //eslint-disable-line eqeqeq\n                        {\n                            cartId: quote.getQuoteId()\n                        } : {},\n                    urls = {\n                        'guest': '/guest-carts/:cartId/shipping-information',\n                        'customer': '/carts/mine/shipping-information'\n                    };\n\n                return this.getUrl(urls, params);\n            },\n\n            /**\n             * Get url for service.\n             *\n             * @param {*} urls\n             * @param {*} urlParams\n             * @return {String|*}\n             */\n            getUrl: function (urls, urlParams) {\n                var url;\n\n                if (utils.isEmpty(urls)) {\n                    return 'Provided service call does not exist.';\n                }\n\n                if (!utils.isEmpty(urls['default'])) {\n                    url = urls['default'];\n                } else {\n                    url = urls[this.getCheckoutMethod()];\n                }\n\n                return urlBuilder.createUrl(url, urlParams);\n            },\n\n            /**\n             * @return {String}\n             */\n            getCheckoutMethod: function () {\n                return customer.isLoggedIn() ? 'customer' : 'guest';\n            }\n        };\n    }\n);\n","Magento_Checkout/js/model/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/customer-data'\n], function (ko, quote, customerData) {\n    'use strict';\n\n    var quoteItems = ko.observable(quote.totals().items),\n        cartData = customerData.get('cart'),\n        quoteSubtotal = parseFloat(quote.totals().subtotal),\n        subtotalAmount = parseFloat(cartData().subtotalAmount);\n\n    quote.totals.subscribe(function (newValue) {\n        quoteItems(newValue.items);\n    });\n\n    if (!isNaN(subtotalAmount) && quoteSubtotal !== subtotalAmount && quoteSubtotal !== 0) {\n        customerData.reload(['cart'], false);\n    }\n\n    return {\n        totals: quote.totals,\n        isLoading: ko.observable(false),\n\n        /**\n         * @return {Function}\n         */\n        getItems: function () {\n            return quoteItems;\n        },\n\n        /**\n         * @param {*} code\n         * @return {*}\n         */\n        getSegment: function (code) {\n            var i, total;\n\n            if (!this.totals()) {\n                return null;\n            }\n\n            for (i in this.totals()['total_segments']) { //eslint-disable-line guard-for-in\n                total = this.totals()['total_segments'][i];\n\n                if (total.code == code) { //eslint-disable-line eqeqeq\n                    return total;\n                }\n            }\n\n            return null;\n        }\n    };\n});\n","Magento_Checkout/js/model/postcode-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mageUtils'\n], function (utils) {\n    'use strict';\n\n    return {\n        validatedPostCodeExample: [],\n\n        /**\n         * @param {*} postCode\n         * @param {*} countryId\n         * @param {Array} postCodesPatterns\n         * @return {Boolean}\n         */\n        validate: function (postCode, countryId, postCodesPatterns) {\n            var pattern, regex,\n                patterns = postCodesPatterns ? postCodesPatterns[countryId] :\n                    window.checkoutConfig.postCodes[countryId];\n\n            this.validatedPostCodeExample = [];\n\n            if (!utils.isEmpty(postCode) && !utils.isEmpty(patterns)) {\n                for (pattern in patterns) {\n                    if (patterns.hasOwnProperty(pattern)) { //eslint-disable-line max-depth\n                        this.validatedPostCodeExample.push(patterns[pattern].example);\n                        regex = new RegExp(patterns[pattern].pattern);\n\n                        if (regex.test(postCode)) { //eslint-disable-line max-depth\n                            return true;\n                        }\n                    }\n                }\n\n                return false;\n            }\n\n            return true;\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Checkout/js/model/shipping-save-processor/default'\n], function (defaultProcessor) {\n    'use strict';\n\n    var processors = {};\n\n    processors['default'] =  defaultProcessor;\n\n    return {\n        /**\n         * @param {String} type\n         * @param {*} processor\n         */\n        registerProcessor: function (type, processor) {\n            processors[type] = processor;\n        },\n\n        /**\n         * @param {String} type\n         * @return {Array}\n         */\n        saveShippingInformation: function (type) {\n            var rates = [];\n\n            if (processors[type]) {\n                rates = processors[type].saveShippingInformation();\n            } else {\n                rates = processors['default'].saveShippingInformation();\n            }\n\n            return rates;\n        }\n    };\n});\n","Magento_Checkout/js/model/new-customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/default-post-code-resolver'\n], function (_, DefaultPostCodeResolver) {\n    'use strict';\n\n    /**\n     * @param {Object} addressData\n     * Returns new address object\n     */\n    return function (addressData) {\n        var identifier = Date.now(),\n            countryId = addressData['country_id'] || addressData.countryId || window.checkoutConfig.defaultCountryId,\n            regionId;\n\n        if (addressData.region && addressData.region['region_id']) {\n            regionId = addressData.region['region_id'];\n        } else if (\n            /* eslint-disable */\n            addressData['country_id'] && addressData['country_id'] == window.checkoutConfig.defaultCountryId ||\n            !addressData['country_id'] && countryId == window.checkoutConfig.defaultCountryId\n            /* eslint-enable */\n        ) {\n            regionId = window.checkoutConfig.defaultRegionId || undefined;\n        }\n\n        return {\n            email: addressData.email,\n            countryId: countryId,\n            regionId: regionId || addressData.regionId,\n            regionCode: addressData.region ? addressData.region['region_code'] : null,\n            region: addressData.region ? addressData.region.region : null,\n            customerId: addressData['customer_id'] || addressData.customerId,\n            street: addressData.street,\n            company: addressData.company,\n            telephone: addressData.telephone,\n            fax: addressData.fax,\n            postcode: addressData.postcode ? addressData.postcode : DefaultPostCodeResolver.resolve(),\n            city: addressData.city,\n            firstname: addressData.firstname,\n            lastname: addressData.lastname,\n            middlename: addressData.middlename,\n            prefix: addressData.prefix,\n            suffix: addressData.suffix,\n            vatId: addressData['vat_id'],\n            saveInAddressBook: addressData['save_in_address_book'],\n            customAttributes: addressData['custom_attributes'],\n            extensionAttributes: addressData['extension_attributes'],\n\n            /**\n             * @return {*}\n             */\n            isDefaultShipping: function () {\n                return addressData['default_shipping'];\n            },\n\n            /**\n             * @return {*}\n             */\n            isDefaultBilling: function () {\n                return addressData['default_billing'];\n            },\n\n            /**\n             * @return {String}\n             */\n            getType: function () {\n                return 'new-customer-address';\n            },\n\n            /**\n             * @return {String}\n             */\n            getKey: function () {\n                return this.getType();\n            },\n\n            /**\n             * @return {String}\n             */\n            getCacheKey: function () {\n                return this.getType() + identifier;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            isEditable: function () {\n                return true;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            canUseForBilling: function () {\n                return true;\n            }\n        };\n    };\n});\n","Magento_Checkout/js/model/billing-address-postcode-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n           'jquery',\n           'Magento_Checkout/js/model/postcode-validator',\n           'mage/translate',\n           'uiRegistry'\n       ], function (\n    $,\n    postcodeValidator,\n    $t,\n    uiRegistry\n) {\n    'use strict';\n\n    var postcodeElementName = 'postcode';\n\n    return {\n        validateZipCodeTimeout: 0,\n        validateDelay: 2000,\n\n        /**\n         * Perform postponed binding for fieldset elements\n         *\n         * @param {String} formPath\n         */\n        initFields: function (formPath) {\n            var self = this;\n\n            uiRegistry.async(formPath + '.' + postcodeElementName)(self.bindHandler.bind(self));\n        },\n\n        /**\n         * @param {Object} element\n         * @param {Number} delay\n         */\n        bindHandler: function (element, delay) {\n            var self = this;\n\n            delay = typeof delay === 'undefined' ? self.validateDelay : delay;\n\n            element.on('value', function () {\n                clearTimeout(self.validateZipCodeTimeout);\n                self.validateZipCodeTimeout = setTimeout(function () {\n                    self.postcodeValidation(element);\n                }, delay);\n            });\n        },\n\n        /**\n         * @param {Object} postcodeElement\n         * @return {*}\n         */\n        postcodeValidation: function (postcodeElement) {\n            var countryId = $('select[name=\"country_id\"]:visible').val(),\n                validationResult,\n                warnMessage;\n\n            if (postcodeElement == null || postcodeElement.value() == null) {\n                return true;\n            }\n\n            postcodeElement.warn(null);\n            validationResult = postcodeValidator.validate(postcodeElement.value(), countryId);\n\n            if (!validationResult) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postcodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postcodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n                postcodeElement.warn(warnMessage);\n            }\n\n            return validationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/full-screen-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'rjsResolver'\n], function ($, resolver) {\n    'use strict';\n\n    var containerId = '#checkout';\n\n    return {\n\n        /**\n         * Start full page loader action\n         */\n        startLoader: function () {\n            $(containerId).trigger('processStart');\n        },\n\n        /**\n         * Stop full page loader action\n         *\n         * @param {Boolean} [forceStop]\n         */\n        stopLoader: function (forceStop) {\n            var $elem = $(containerId),\n                stop = $elem.trigger.bind($elem, 'processStop'); //eslint-disable-line jquery-no-bind-unbind\n\n            forceStop ? stop() : resolver(stop);\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    var ratesRules = {},\n        checkoutConfig = window.checkoutConfig;\n\n    return {\n        /**\n         * @param {String} carrier\n         * @param {Object} rules\n         */\n        registerRules: function (carrier, rules) {\n            if (checkoutConfig.activeCarriers.indexOf(carrier) !== -1) {\n                ratesRules[carrier] = rules.getRules();\n            }\n        },\n\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return ratesRules;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getObservableFields: function () {\n            var self = this,\n                observableFields = [];\n\n            $.each(self.getRules(), function (carrier, fields) {\n                $.each(fields, function (field) {\n                    if (observableFields.indexOf(field) === -1) {\n                        observableFields.push(field);\n                    }\n                });\n            });\n\n            return observableFields;\n        }\n    };\n});\n","Magento_Checkout/js/model/step-navigator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko'\n], function ($, ko) {\n    'use strict';\n\n    var steps = ko.observableArray();\n\n    return {\n        steps: steps,\n        stepCodes: [],\n        validCodes: [],\n\n        /**\n         * @return {Boolean}\n         */\n        handleHash: function () {\n            var hashString = window.location.hash.replace('#', ''),\n                isRequestedStepVisible;\n\n            if (hashString === '') {\n                return false;\n            }\n\n            if ($.inArray(hashString, this.validCodes) === -1) {\n                window.location.href = window.checkoutConfig.pageNotFoundUrl;\n\n                return false;\n            }\n\n            isRequestedStepVisible = steps.sort(this.sortItems).some(function (element) {\n                return (element.code == hashString || element.alias == hashString) && element.isVisible(); //eslint-disable-line\n            });\n\n            //if requested step is visible, then we don't need to load step data from server\n            if (isRequestedStepVisible) {\n                return false;\n            }\n\n            steps().sort(this.sortItems).forEach(function (element) {\n                if (element.code == hashString || element.alias == hashString) { //eslint-disable-line eqeqeq\n                    element.navigate(element);\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n\n            return false;\n        },\n\n        /**\n         * @param {String} code\n         * @param {*} alias\n         * @param {*} title\n         * @param {Function} isVisible\n         * @param {*} navigate\n         * @param {*} sortOrder\n         */\n        registerStep: function (code, alias, title, isVisible, navigate, sortOrder) {\n            var hash, active;\n\n            if ($.inArray(code, this.validCodes) !== -1) {\n                throw new DOMException('Step code [' + code + '] already registered in step navigator');\n            }\n\n            if (alias != null) {\n                if ($.inArray(alias, this.validCodes) !== -1) {\n                    throw new DOMException('Step code [' + alias + '] already registered in step navigator');\n                }\n                this.validCodes.push(alias);\n            }\n            this.validCodes.push(code);\n            steps.push({\n                code: code,\n                alias: alias != null ? alias : code,\n                title: title,\n                isVisible: isVisible,\n                navigate: navigate,\n                sortOrder: sortOrder\n            });\n            active = this.getActiveItemIndex();\n            steps.each(function (elem, index) {\n                if (active !== index) {\n                    elem.isVisible(false);\n                }\n            });\n            this.stepCodes.push(code);\n            hash = window.location.hash.replace('#', '');\n\n            if (hash != '' && hash != code) { //eslint-disable-line eqeqeq\n                //Force hiding of not active step\n                isVisible(false);\n            }\n        },\n\n        /**\n         * @param {Object} itemOne\n         * @param {Object} itemTwo\n         * @return {Number}\n         */\n        sortItems: function (itemOne, itemTwo) {\n            return itemOne.sortOrder > itemTwo.sortOrder ? 1 : -1;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getActiveItemIndex: function () {\n            var activeIndex = 0;\n\n            steps().sort(this.sortItems).some(function (element, index) {\n                if (element.isVisible()) {\n                    activeIndex = index;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return activeIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @return {Boolean}\n         */\n        isProcessed: function (code) {\n            var activeItemIndex = this.getActiveItemIndex(),\n                sortedItems = steps().sort(this.sortItems),\n                requestedItemIndex = -1;\n\n            sortedItems.forEach(function (element, index) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    requestedItemIndex = index;\n                }\n            });\n\n            return activeItemIndex > requestedItemIndex;\n        },\n\n        /**\n         * @param {*} code\n         * @param {*} scrollToElementId\n         */\n        navigateTo: function (code, scrollToElementId) {\n            var sortedItems = steps().sort(this.sortItems),\n                bodyElem = $('body');\n\n            scrollToElementId = scrollToElementId || null;\n\n            if (!this.isProcessed(code)) {\n                return;\n            }\n            sortedItems.forEach(function (element) {\n                if (element.code == code) { //eslint-disable-line eqeqeq\n                    element.isVisible(true);\n                    bodyElem.animate({\n                        scrollTop: $('#' + code).offset().top\n                    }, 0, function () {\n                        window.location = window.checkoutConfig.checkoutUrl + '#' + code;\n                    });\n\n                    if (scrollToElementId && $('#' + scrollToElementId).length) {\n                        bodyElem.animate({\n                            scrollTop: $('#' + scrollToElementId).offset().top\n                        }, 0);\n                    }\n                } else {\n                    element.isVisible(false);\n                }\n\n            });\n        },\n\n        /**\n         * Sets window location hash.\n         *\n         * @param {String} hash\n         */\n        setHash: function (hash) {\n            window.location.hash = hash;\n        },\n\n        /**\n         * Next step.\n         */\n        next: function () {\n            var activeIndex = 0,\n                code;\n\n            steps().sort(this.sortItems).forEach(function (element, index) {\n                if (element.isVisible()) {\n                    element.isVisible(false);\n                    activeIndex = index;\n                }\n            });\n\n            if (steps().length > activeIndex + 1) {\n                code = steps()[activeIndex + 1].code;\n                steps()[activeIndex + 1].isVisible(true);\n                this.setHash(code);\n                document.body.scrollTop = document.documentElement.scrollTop = 0;\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/payload-extender.js":"define([], function () {\n    'use strict';\n\n    return function (payload) {\n        payload.addressInformation['extension_attributes'] = {};\n\n        return payload;\n    };\n});\n","Magento_Checkout/js/model/shipping-save-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'mage/storage',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/model/shipping-save-processor/payload-extender'\n], function (\n    ko,\n    quote,\n    resourceUrlManager,\n    storage,\n    paymentService,\n    methodConverter,\n    errorProcessor,\n    fullScreenLoader,\n    selectBillingAddressAction,\n    payloadExtender\n) {\n    'use strict';\n\n    return {\n        /**\n         * @return {jQuery.Deferred}\n         */\n        saveShippingInformation: function () {\n            var payload;\n\n            if (!quote.billingAddress() && quote.shippingAddress().canUseForBilling()) {\n                selectBillingAddressAction(quote.shippingAddress());\n            }\n\n            payload = {\n                addressInformation: {\n                    'shipping_address': quote.shippingAddress(),\n                    'billing_address': quote.billingAddress(),\n                    'shipping_method_code': quote.shippingMethod()['method_code'],\n                    'shipping_carrier_code': quote.shippingMethod()['carrier_code']\n                }\n            };\n\n            payloadExtender(payload);\n\n            fullScreenLoader.startLoader();\n\n            return storage.post(\n                resourceUrlManager.getUrlForSetShippingInformation(quote),\n                JSON.stringify(payload)\n            ).done(\n                function (response) {\n                    quote.setTotals(response.totals);\n                    paymentService.setPaymentMethods(methodConverter(response['payment_methods']));\n                    fullScreenLoader.stopLoader();\n                }\n            ).fail(\n                function (response) {\n                    errorProcessor.process(response);\n                    fullScreenLoader.stopLoader();\n                }\n            );\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-address/form-popup-state.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return {\n        isVisible: ko.observable(false)\n    };\n});\n","Magento_Checkout/js/model/payment/method-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/model/payment/additional-validators.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    var validators = [];\n\n    return {\n        /**\n         * Register unique validator\n         *\n         * @param {*} validator\n         */\n        registerValidator: function (validator) {\n            validators.push(validator);\n        },\n\n        /**\n         * Returns array of registered validators\n         *\n         * @returns {Array}\n         */\n        getValidators: function () {\n            return validators;\n        },\n\n        /**\n         * Process validators\n         *\n         * @returns {Boolean}\n         */\n        validate: function (hideError) {\n            var validationResult = true;\n\n            hideError = hideError || false;\n\n            if (validators.length <= 0) {\n                return validationResult;\n            }\n\n            validators.forEach(function (item) {\n                if (item.validate(hideError) == false) { //eslint-disable-line eqeqeq\n                    validationResult = false;\n\n                    return false;\n                }\n            });\n\n            return validationResult;\n        }\n    };\n});\n","Magento_Checkout/js/model/payment/renderer-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Checkout/js/model/payment/method-group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'uiElement',\n        'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    var DEFAULT_GROUP_ALIAS = 'default';\n\n    return Element.extend({\n        defaults: {\n            alias: DEFAULT_GROUP_ALIAS,\n            title: $t('Payment Method'),\n            sortOrder: 100,\n            displayArea: 'payment-methods-items-${ $.alias }'\n        },\n\n        /**\n         * Checks if group instance is default\n         *\n         * @returns {Boolean}\n         */\n        isDefault: function () {\n            return this.alias === DEFAULT_GROUP_ALIAS;\n        }\n    });\n});\n","Magento_Checkout/js/model/payment/method-converter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return function (methods) {\n        _.each(methods, function (method) {\n            if (method.hasOwnProperty('code')) {\n                method.method = method.code;\n                delete method.code;\n            }\n        });\n\n        return methods;\n    };\n});\n","Magento_Checkout/js/model/payment/place-order-hooks.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        requestModifiers: [],\n        afterRequestListeners: []\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/new-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache, serviceUrl, payload;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getCacheKey());\n            serviceUrl = resourceUrlManager.getUrlForEstimationShippingMethodsForNewAddress(quote);\n            payload = JSON.stringify({\n                    address: {\n                        'street': address.street,\n                        'city': address.city,\n                        'region_id': address.regionId,\n                        'region': address.region,\n                        'country_id': address.countryId,\n                        'postcode': address.postcode,\n                        'email': address.email,\n                        'customer_id': address.customerId,\n                        'firstname': address.firstname,\n                        'lastname': address.lastname,\n                        'middlename': address.middlename,\n                        'prefix': address.prefix,\n                        'suffix': address.suffix,\n                        'vat_id': address.vatId,\n                        'company': address.company,\n                        'telephone': address.telephone,\n                        'fax': address.fax,\n                        'custom_attributes': address.customAttributes,\n                        'save_in_address_book': address.saveInAddressBook\n                    }\n                }\n            );\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                let async = quote.isPersistent() ? false : true;\n\n                storage.post(\n                    serviceUrl, payload, false, 'application/json', {}, async\n                ).done(function (result) {\n                    rateRegistry.set(address.getCacheKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                });\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/shipping-rate-processor/customer-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/model/error-processor'\n], function (resourceUrlManager, quote, storage, shippingService, rateRegistry, errorProcessor) {\n    'use strict';\n\n    return {\n        /**\n         * @param {Object} address\n         */\n        getRates: function (address) {\n            var cache;\n\n            shippingService.isLoading(true);\n            cache = rateRegistry.get(address.getKey());\n\n            if (cache) {\n                shippingService.setShippingRates(cache);\n                shippingService.isLoading(false);\n            } else {\n                storage.post(\n                    resourceUrlManager.getUrlForEstimationShippingMethodsByAddressId(),\n                    JSON.stringify({\n                        addressId: address.customerAddressId\n                    }),\n                    false\n                ).done(function (result) {\n                    rateRegistry.set(address.getKey(), result);\n                    shippingService.setShippingRates(result);\n                }).fail(function (response) {\n                    shippingService.setShippingRates([]);\n                    errorProcessor.process(response);\n                }).always(function () {\n                    shippingService.isLoading(false);\n                }\n                );\n            }\n        }\n    };\n});\n","Magento_Checkout/js/model/cart/estimate-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-rate-processor/new-address',\n    'Magento_Checkout/js/model/cart/totals-processor/default',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (_, quote, defaultProcessor, totalsDefaultProvider, shippingService, cartCache, customerData) {\n    'use strict';\n\n    var rateProcessors = {},\n        totalsProcessors = {},\n\n        /**\n         * Cache shipping address until changed\n         */\n        setShippingAddress = function () {\n            var shippingAddress = _.pick(quote.shippingAddress(), cartCache.requiredFields);\n\n            cartCache.set('shipping-address', shippingAddress);\n        },\n\n        /**\n         * Estimate totals for shipping address and update shipping rates.\n         */\n        estimateTotalsAndUpdateRates = function () {\n            var type = quote.shippingAddress().getType();\n\n            if (\n                quote.isVirtual() ||\n                window.checkoutConfig.activeCarriers && window.checkoutConfig.activeCarriers.length === 0\n            ) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type] ?\n                    totalsProcessors[type].estimateTotals(quote.shippingAddress()) :\n                    totalsProcessors['default'].estimateTotals(quote.shippingAddress());\n            } else {\n                // check if user data not changed -> load rates from cache\n                if (!cartCache.isChanged('address', quote.shippingAddress()) &&\n                    !cartCache.isChanged('cartVersion', customerData.get('cart')()['data_id']) &&\n                    cartCache.get('rates') && !cartCache.isChanged('totals', quote.getTotals())\n                ) {\n                    shippingService.setShippingRates(cartCache.get('rates'));\n                    quote.setTotals(cartCache.get('totals'));\n                    return;\n                }\n\n                // update rates list when estimated address was set\n                rateProcessors['default'] = defaultProcessor;\n                rateProcessors[type] ?\n                    rateProcessors[type].getRates(quote.shippingAddress()) :\n                    rateProcessors['default'].getRates(quote.shippingAddress());\n\n                // save rates to cache after load\n                shippingService.getShippingRates().subscribe(function (rates) {\n                    cartCache.set('rates', rates);\n                    setShippingAddress();\n                });\n\n                // update totals based on updated shipping address / rates changes\n                if (cartCache.get('shipping-address') && cartCache.get('shipping-address').countryId &&\n                    cartCache.isChanged('shipping-address',  quote.shippingAddress()) &&\n                    (!quote.shippingMethod() || !quote.shippingMethod()['method_code'])) {\n                    totalsDefaultProvider.estimateTotals(quote.shippingAddress());\n                    cartCache.set('totals', quote.getTotals());\n                }\n            }\n            // unset loader on shipping rates list\n            shippingService.isLoading(false);\n        },\n\n        /**\n         * Estimate totals for shipping address.\n         */\n        estimateTotalsShipping = function () {\n            totalsDefaultProvider.estimateTotals(quote.shippingAddress());\n        },\n\n        /**\n         * Estimate totals for billing address.\n         */\n        estimateTotalsBilling = function () {\n            var type = quote.billingAddress().getType();\n\n            if (quote.isVirtual()) {\n                // update totals block when estimated address was set\n                totalsProcessors['default'] = totalsDefaultProvider;\n                totalsProcessors[type] ?\n                    totalsProcessors[type].estimateTotals(quote.billingAddress()) :\n                    totalsProcessors['default'].estimateTotals(quote.billingAddress());\n            }\n        };\n\n    quote.shippingAddress.subscribe(estimateTotalsAndUpdateRates);\n    quote.shippingMethod.subscribe(estimateTotalsShipping);\n    quote.billingAddress.subscribe(estimateTotalsBilling);\n});\n","Magento_Checkout/js/model/cart/cache.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Cart adapter for customer data storage.\n * It stores cart data in customer data(localStorage) without saving on server.\n * Adapter is created for shipping rates and totals data caching. It eliminates unneeded calculations requests.\n */\ndefine([\n    'underscore',\n    'Magento_Customer/js/customer-data',\n    'mageUtils'\n], function (_, storage, utils) {\n    'use strict';\n\n    var cacheKey = 'cart-data',\n        cartData = {\n            totals: null,\n            address: null,\n            cartVersion: null,\n            shippingMethodCode: null,\n            shippingCarrierCode: null,\n            rates: null\n        },\n\n        /**\n         * Set data to local storage.\n         *\n         * @param {Object} checkoutData\n         */\n        setData = function (checkoutData) {\n            storage.set(cacheKey, checkoutData);\n        },\n\n        /**\n         * Get data from local storage.\n         *\n         * @param {String} [key]\n         * @returns {*}\n         */\n        getData = function (key) {\n            var data = key ? storage.get(cacheKey)()[key] : storage.get(cacheKey)();\n\n            if (_.isEmpty(storage.get(cacheKey)())) {\n                setData(utils.copy(cartData));\n            }\n\n            return data;\n        },\n\n        /**\n         * Build method name base on name, prefix and suffix.\n         *\n         * @param {String} name\n         * @param {String} prefix\n         * @param {String} suffix\n         * @return {String}\n         */\n        getMethodName = function (name, prefix, suffix) {\n            prefix = prefix || '';\n            suffix = suffix || '';\n\n            return prefix + name.charAt(0).toUpperCase() + name.slice(1) + suffix;\n        };\n\n    /**\n     * Provides get/set/isChanged/clear methods for work with cart data.\n     * Can be customized via mixin functionality.\n     */\n    return {\n        cartData: cartData,\n\n        /**\n         * Array of required address fields\n         */\n        requiredFields: ['countryId', 'region', 'regionId', 'postcode'],\n\n        /**\n         * Get data from customer data.\n         * Concatenate provided key with method name and call method if it exist or makes get by key.\n         *\n         * @param {String} key\n         * @return {*}\n         */\n        get: function (key) {\n            var methodName = getMethodName(key, '_get');\n\n            if (key === cacheKey) {\n                return getData();\n            }\n\n            if (this[methodName]) {\n                return this[methodName]();\n            }\n\n            return getData(key);\n        },\n\n        /**\n         * Set data to customer data.\n         * Concatenate provided key with method name and call method if it exist or makes set by key.\n         * @example _setCustomAddress method will be called, if it exists.\n         *  set('address', customAddressValue)\n         * @example Will set value by provided key.\n         *  set('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         */\n        set: function (key, value) {\n            var methodName = getMethodName(key, '_set'),\n                obj;\n\n            if (key === cacheKey) {\n                _.each(value, function (val, k) {\n                    this.set(k, val);\n                }, this);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName](value);\n            } else {\n                obj = getData();\n                obj[key] = value;\n                setData(obj);\n            }\n        },\n\n        /**\n         * Clear data in cache.\n         * Concatenate provided key with method name and call method if it exist or clear by key.\n         * @example _clearCustomAddress method will be called, if it exist.\n         *  clear('customAddress')\n         * @example Will clear data by provided key.\n         *  clear('rates')\n         *\n         * @param {String} key\n         */\n        clear: function (key) {\n            var methodName = getMethodName(key, '_clear');\n\n            if (key === cacheKey) {\n                setData(this.cartData);\n\n                return;\n            }\n\n            if (this[methodName]) {\n                this[methodName]();\n            } else {\n                this.set(key, null);\n            }\n        },\n\n        /**\n         * Check if provided data has difference with cached data.\n         * Concatenate provided key with method name and call method if it exist or makes strict equality.\n         * @example Will call existing _isAddressChanged.\n         *  isChanged('address', addressToCompare)\n         * @example Will get data by provided key and make strict equality with provided value.\n         *  isChanged('rates', ratesToCompare)\n         *\n         * @param {String} key\n         * @param {*} value\n         * @return {Boolean}\n         */\n        isChanged: function (key, value) {\n            var methodName = getMethodName(key, '_is', 'Changed');\n\n            if (this[methodName]) {\n                return this[methodName](value);\n            }\n\n            return this.get(key) !== value;\n        },\n\n        /**\n         * Compare cached address with provided.\n         * Custom method for check object equality.\n         *\n         * @param {Object} address\n         * @returns {Boolean}\n         */\n        _isAddressChanged: function (address) {\n            return JSON.stringify(_.pick(this.get('address'), this.requiredFields)) !==\n                JSON.stringify(_.pick(address, this.requiredFields));\n        },\n\n        /**\n         * Compare cached subtotal with provided.\n         * Custom method for check object equality.\n         *\n         * @param {float} subtotal\n         * @returns {Boolean}\n         */\n        _isSubtotalChanged: function (subtotal) {\n            var cached = parseFloat(this.get('totals').subtotal);\n\n            return subtotal !== cached;\n        }\n    };\n});\n","Magento_Checkout/js/model/cart/totals-processor/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/resource-url-manager',\n    'Magento_Checkout/js/model/quote',\n    'mage/storage',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/error-processor',\n    'Magento_Checkout/js/model/cart/cache',\n    'Magento_Customer/js/customer-data'\n], function (_, resourceUrlManager, quote, storage, totalsService, errorProcessor, cartCache, customerData) {\n    'use strict';\n\n    /**\n     * Load data from server.\n     *\n     * @param {Object} address\n     */\n    var loadFromServer = function (address) {\n        var serviceUrl,\n            payload;\n\n        // Start loader for totals block\n        totalsService.isLoading(true);\n        serviceUrl = resourceUrlManager.getUrlForTotalsEstimationForNewAddress(quote);\n        payload = {\n            addressInformation: {\n                address: _.pick(address, cartCache.requiredFields)\n            }\n        };\n\n        if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n            payload.addressInformation['shipping_method_code'] = quote.shippingMethod()['method_code'];\n            payload.addressInformation['shipping_carrier_code'] = quote.shippingMethod()['carrier_code'];\n        }\n\n        return storage.post(\n            serviceUrl, JSON.stringify(payload), false\n        ).done(function (result) {\n            var data = {\n                totals: result,\n                address: address,\n                cartVersion: customerData.get('cart')()['data_id'],\n                shippingMethodCode: null,\n                shippingCarrierCode: null\n            };\n\n            if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {\n                data.shippingMethodCode = quote.shippingMethod()['method_code'];\n                data.shippingCarrierCode = quote.shippingMethod()['carrier_code'];\n            }\n\n            quote.setTotals(result);\n            cartCache.set('cart-data', data);\n        }).fail(function (response) {\n            errorProcessor.process(response);\n        }).always(function () {\n            // Stop loader for totals block\n            totalsService.isLoading(false);\n        });\n    };\n\n    return {\n        /**\n         * Array of required address fields.\n         * @property {Array.String} requiredFields\n         * @deprecated Use cart cache.\n         */\n        requiredFields: cartCache.requiredFields,\n\n        /**\n         * Get shipping rates for specified address.\n         * @param {Object} address\n         */\n        estimateTotals: function (address) {\n            return loadFromServer(address);\n        }\n    };\n});\n","Magento_Checkout/js/view/progress-bar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'uiComponent',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/view/billing-address'\n], function ($, _, ko, Component, stepNavigator, billingAddress) {\n    'use strict';\n\n    var steps = stepNavigator.steps;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/progress-bar',\n            visible: true\n        },\n        steps: steps,\n\n        /** @inheritdoc */\n        initialize: function () {\n            var stepsValue;\n\n            this._super();\n            window.addEventListener('hashchange', _.bind(stepNavigator.handleHash, stepNavigator));\n\n            if (!window.location.hash) {\n                stepsValue = stepNavigator.steps();\n\n                if (stepsValue.length) {\n                    stepNavigator.setHash(stepsValue.sort(stepNavigator.sortItems)[0].code);\n                }\n            }\n\n            stepNavigator.handleHash();\n        },\n\n        /**\n         * @param {*} itemOne\n         * @param {*} itemTwo\n         * @return {*|Number}\n         */\n        sortItems: function (itemOne, itemTwo) {\n            return stepNavigator.sortItems(itemOne, itemTwo);\n        },\n\n        /**\n         * @param {Object} step\n         */\n        navigateTo: function (step) {\n            if (step.code === 'shipping') {\n                billingAddress().needCancelBillingAddressChanges();\n            }\n            stepNavigator.navigateTo(step.code);\n        },\n\n        /**\n         * @param {Object} item\n         * @return {*|Boolean}\n         */\n        isProcessed: function (item) {\n            return stepNavigator.isProcessed(item.code);\n        }\n    });\n});\n","Magento_Checkout/js/view/estimation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Checkout/js/model/sidebar'\n], function (Component, quote, priceUtils, totals, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totals.isLoading,\n\n        /**\n         * @return {Number}\n         */\n        getQuantity: function () {\n            if (totals.totals()) {\n                return parseFloat(totals.totals()['items_qty']);\n            }\n\n            return 0;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            if (totals.totals()) {\n                return parseFloat(totals.getSegment('grand_total').value);\n            }\n\n            return 0;\n        },\n\n        /**\n         * Show sidebar.\n         */\n        showSidebar: function () {\n            sidebarModel.show();\n        },\n\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            return priceUtils.formatPriceLocale(price, quote.getPriceFormat());\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getPureValue());\n        }\n    });\n});\n","Magento_Checkout/js/view/minicart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'ko',\n    'underscore',\n    'sidebar',\n    'mage/translate',\n    'mage/dropdown'\n], function (Component, customerData, $, ko, _) {\n    'use strict';\n\n    var sidebarInitialized = false,\n        addToCartCalls = 0,\n        miniCart;\n\n    miniCart = $('[data-block=\\'minicart\\']');\n\n    /**\n     * @return {Boolean}\n     */\n    function initSidebar() {\n        if (miniCart.data('mageSidebar')) {\n            miniCart.sidebar('update');\n        }\n\n        if (!$('[data-role=product-item]').length) {\n            return false;\n        }\n        miniCart.trigger('contentUpdated');\n\n        if (sidebarInitialized) {\n            return false;\n        }\n        sidebarInitialized = true;\n        miniCart.sidebar({\n            'targetElement': 'div.block.block-minicart',\n            'url': {\n                'checkout': window.checkout.checkoutUrl,\n                'update': window.checkout.updateItemQtyUrl,\n                'remove': window.checkout.removeItemUrl,\n                'loginUrl': window.checkout.customerLoginUrl,\n                'isRedirectRequired': window.checkout.isRedirectRequired\n            },\n            'button': {\n                'checkout': '#top-cart-btn-checkout',\n                'remove': '#mini-cart a.action.delete',\n                'close': '#btn-minicart-close'\n            },\n            'showcart': {\n                'parent': 'span.counter',\n                'qty': 'span.counter-number',\n                'label': 'span.counter-label'\n            },\n            'minicart': {\n                'list': '#mini-cart',\n                'content': '#minicart-content-wrapper',\n                'qty': 'div.items-total',\n                'subtotal': 'div.subtotal span.price',\n                'maxItemsVisible': window.checkout.minicartMaxItemsVisible\n            },\n            'item': {\n                'qty': ':input.cart-item-qty',\n                'button': ':button.update-cart-item'\n            },\n            'confirmMessage': $.mage.__('Are you sure you would like to remove this item from the shopping cart?')\n        });\n    }\n\n    miniCart.on('dropdowndialogopen', function () {\n        initSidebar();\n    });\n\n    return Component.extend({\n        shoppingCartUrl: window.checkout.shoppingCartUrl,\n        maxItemsToDisplay: window.checkout.maxItemsToDisplay,\n        cart: {},\n\n        // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n        /**\n         * @override\n         */\n        initialize: function () {\n            var self = this,\n                cartData = customerData.get('cart');\n\n            this.update(cartData());\n            cartData.subscribe(function (updatedCart) {\n                addToCartCalls--;\n                this.isLoading(addToCartCalls > 0);\n                sidebarInitialized = false;\n                this.update(updatedCart);\n                initSidebar();\n            }, this);\n            $('[data-block=\"minicart\"]').on('contentLoading', function () {\n                addToCartCalls++;\n                self.isLoading(true);\n            });\n\n            if (\n                cartData().website_id !== window.checkout.websiteId && cartData().website_id !== undefined ||\n                cartData().storeId !== window.checkout.storeId && cartData().storeId !== undefined\n            ) {\n                customerData.reload(['cart'], false);\n            }\n\n            return this._super();\n        },\n        //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n        isLoading: ko.observable(false),\n        initSidebar: initSidebar,\n\n        /**\n         * Close mini shopping cart.\n         */\n        closeMinicart: function () {\n            $('[data-block=\"minicart\"]').find('[data-role=\"dropdownDialog\"]').dropdownDialog('close');\n        },\n\n        /**\n         * @param {String} productType\n         * @return {*|String}\n         */\n        getItemRenderer: function (productType) {\n            return this.itemRenderer[productType] || 'defaultRenderer';\n        },\n\n        /**\n         * Update mini shopping cart content.\n         *\n         * @param {Object} updatedCart\n         * @returns void\n         */\n        update: function (updatedCart) {\n            _.each(updatedCart, function (value, key) {\n                if (!this.cart.hasOwnProperty(key)) {\n                    this.cart[key] = ko.observable();\n                }\n                this.cart[key](value);\n            }, this);\n        },\n\n        /**\n         * Get cart param by name.\n         *\n         * @param {String} name\n         * @returns {*}\n         */\n        getCartParamUnsanitizedHtml: function (name) {\n            if (!_.isUndefined(name)) {\n                if (!this.cart.hasOwnProperty(name)) {\n                    this.cart[name] = ko.observable();\n                }\n            }\n\n            return this.cart[name]();\n        },\n\n        /**\n         * @deprecated please use getCartParamUnsanitizedHtml.\n         * @param {String} name\n         * @returns {*}\n         */\n        getCartParam: function (name) {\n            return this.getCartParamUnsanitizedHtml(name);\n        },\n\n        /**\n         * Returns array of cart items, limited by 'maxItemsToDisplay' setting\n         * @returns []\n         */\n        getCartItems: function () {\n            var items = this.getCartParamUnsanitizedHtml('items') || [];\n\n            items = items.slice(parseInt(-this.maxItemsToDisplay, 10));\n\n            return items;\n        },\n\n        /**\n         * Returns count of cart line items\n         * @returns {Number}\n         */\n        getCartLineItemsCount: function () {\n            var items = this.getCartParamUnsanitizedHtml('items') || [];\n\n            return parseInt(items.length, 10);\n        }\n    });\n});\n","Magento_Checkout/js/view/cart-item-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * Prepare the product name value to be rendered as HTML\n         *\n         * @param {String} productName\n         * @return {String}\n         */\n        getProductNameUnsanitizedHtml: function (productName) {\n            // product name has already escaped on backend\n            return productName;\n        },\n\n        /**\n         * Prepare the given option value to be rendered as HTML\n         *\n         * @param {String} optionValue\n         * @return {String}\n         */\n        getOptionValueUnsanitizedHtml: function (optionValue) {\n            // option value has already escaped on backend\n            return optionValue;\n        }\n    });\n});\n","Magento_Checkout/js/view/sidebar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'ko',\n    'jquery',\n    'Magento_Checkout/js/model/sidebar'\n], function (Component, ko, $, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {HTMLElement} element\n         */\n        setModalElement: function (element) {\n            sidebarModel.setPopup($(element));\n        }\n    });\n});\n","Magento_Checkout/js/view/registration.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/model/messageList'\n], function ($, Component, messageList) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/registration',\n            accountCreated: false,\n            creationStarted: false,\n            isFormVisible: true\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super()\n                .observe('accountCreated')\n                .observe('isFormVisible')\n                .observe('creationStarted');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        getEmailAddress: function () {\n            return this.email;\n        },\n\n        /**\n         * @return String\n         */\n        getUrl: function () {\n            return this.registrationUrl;\n        },\n\n        /**\n         * Create new user account.\n         *\n         * @deprecated\n         */\n        createAccount: function () {\n            this.creationStarted(true);\n            $.post(\n                this.registrationUrl\n            ).done(\n                function (response) {\n\n                    if (response.errors == false) { //eslint-disable-line eqeqeq\n                        this.accountCreated(true);\n                    } else {\n                        messageList.addErrorMessage(response);\n                    }\n                    this.isFormVisible(false);\n                }.bind(this)\n            ).fail(\n                function (response) {\n                    this.accountCreated(false);\n                    this.isFormVisible(false);\n                    messageList.addErrorMessage(response);\n                }.bind(this)\n            );\n        }\n    });\n});\n","Magento_Checkout/js/view/authentication-messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/view/messages',\n    'Magento_Checkout/js/model/authentication-messages'\n], function (Component, messageContainer) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function (config) {\n            return this._super(config, messageContainer);\n        }\n    });\n});\n","Magento_Checkout/js/view/payment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'ko',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/model/payment/method-converter',\n    'Magento_Checkout/js/action/get-payment-information',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'mage/translate'\n], function (\n    $,\n    _,\n    Component,\n    ko,\n    quote,\n    stepNavigator,\n    paymentService,\n    methodConverter,\n    getPaymentInformation,\n    checkoutDataResolver,\n    $t\n) {\n    'use strict';\n\n    /** Set payment methods to collection */\n    paymentService.setPaymentMethods(methodConverter(window.checkoutConfig.paymentMethods));\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/payment',\n            activeMethod: ''\n        },\n        isVisible: ko.observable(quote.isVirtual()),\n        quoteIsVirtual: quote.isVirtual(),\n        isPaymentMethodsAvailable: ko.computed(function () {\n            return paymentService.getAvailablePaymentMethods().length > 0;\n        }),\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            checkoutDataResolver.resolvePaymentMethod();\n            stepNavigator.registerStep(\n                'payment',\n                null,\n                $t('Review & Payments'),\n                this.isVisible,\n                _.bind(this.navigate, this),\n                this.sortOrder\n            );\n\n            return this;\n        },\n\n        /**\n         * Navigate method.\n         */\n        navigate: function () {\n            var self = this;\n\n            if (!self.hasShippingMethod()) {\n                this.isVisible(false);\n                stepNavigator.setHash('shipping');\n            } else {\n                getPaymentInformation().done(function () {\n                    self.isVisible(true);\n                });\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        hasShippingMethod: function () {\n            return window.checkoutConfig.selectedShippingMethod !== null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getFormKey: function () {\n            return window.checkoutConfig.formKey;\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Checkout/js/model/sidebar'\n], function ($, Component, quote, stepNavigator, sidebarModel) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isVisible: function () {\n            return !quote.isVirtual() && stepNavigator.isProcessed('shipping');\n        },\n\n        /**\n         * @return {String}\n         */\n        getShippingMethodTitle: function () {\n            var shippingMethod = quote.shippingMethod(),\n                shippingMethodTitle = '';\n\n            if (!shippingMethod) {\n                return '';\n            }\n\n            shippingMethodTitle = shippingMethod['carrier_title'];\n\n            if (typeof shippingMethod['method_title'] !== 'undefined') {\n                shippingMethodTitle += ' - ' + shippingMethod['method_title'];\n            }\n\n            return shippingMethodTitle;\n        },\n\n        /**\n         * Back step.\n         */\n        back: function () {\n            sidebarModel.hide();\n            stepNavigator.navigateTo('shipping');\n        },\n\n        /**\n         * Back to shipping method.\n         */\n        backToShippingMethod: function () {\n            sidebarModel.hide();\n            stepNavigator.navigateTo('shipping', 'opc-shipping_method');\n        }\n    });\n});\n","Magento_Checkout/js/view/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/totals'\n], function (Component, totals) {\n    'use strict';\n\n    return Component.extend({\n        isLoading: totals.isLoading\n    });\n});\n","Magento_Checkout/js/view/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/form/form',\n    'ko',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/address-converter',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/create-shipping-address',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/model/shipping-service',\n    'Magento_Checkout/js/action/select-shipping-method',\n    'Magento_Checkout/js/model/shipping-rate-registry',\n    'Magento_Checkout/js/action/set-shipping-information',\n    'Magento_Checkout/js/model/step-navigator',\n    'Magento_Ui/js/modal/modal',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'Magento_Checkout/js/checkout-data',\n    'uiRegistry',\n    'mage/translate',\n    'Magento_Checkout/js/model/shipping-rate-service'\n], function (\n    $,\n    _,\n    Component,\n    ko,\n    customer,\n    addressList,\n    addressConverter,\n    quote,\n    createShippingAddress,\n    selectShippingAddress,\n    shippingRatesValidator,\n    formPopUpState,\n    shippingService,\n    selectShippingMethodAction,\n    rateRegistry,\n    setShippingInformationAction,\n    stepNavigator,\n    modal,\n    checkoutDataResolver,\n    checkoutData,\n    registry,\n    $t\n) {\n    'use strict';\n\n    var popUp = null;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping',\n            shippingFormTemplate: 'Magento_Checkout/shipping-address/form',\n            shippingMethodListTemplate: 'Magento_Checkout/shipping-address/shipping-method-list',\n            shippingMethodItemTemplate: 'Magento_Checkout/shipping-address/shipping-method-item',\n            imports: {\n                countryOptions: '${ $.parentName }.shippingAddress.shipping-address-fieldset.country_id:indexedOptions'\n            }\n        },\n        visible: ko.observable(!quote.isVirtual()),\n        errorValidationMessage: ko.observable(false),\n        isCustomerLoggedIn: customer.isLoggedIn,\n        isFormPopUpVisible: formPopUpState.isVisible,\n        isFormInline: addressList().length === 0,\n        isNewAddressAdded: ko.observable(false),\n        saveInAddressBook: 1,\n        quoteIsVirtual: quote.isVirtual(),\n\n        /**\n         * @return {exports}\n         */\n        initialize: function () {\n            var self = this,\n                hasNewAddress,\n                fieldsetName = 'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset';\n\n            this._super();\n\n            if (!quote.isVirtual()) {\n                stepNavigator.registerStep(\n                    'shipping',\n                    '',\n                    $t('Shipping'),\n                    this.visible, _.bind(this.navigate, this),\n                    this.sortOrder\n                );\n            }\n            checkoutDataResolver.resolveShippingAddress();\n\n            hasNewAddress = addressList.some(function (address) {\n                return address.getType() == 'new-customer-address'; //eslint-disable-line eqeqeq\n            });\n\n            this.isNewAddressAdded(hasNewAddress);\n\n            this.isFormPopUpVisible.subscribe(function (value) {\n                if (value) {\n                    self.getPopUp().openModal();\n                }\n            });\n\n            quote.shippingMethod.subscribe(function () {\n                self.errorValidationMessage(false);\n            });\n\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                var shippingAddressData = checkoutData.getShippingAddressFromData();\n\n                if (shippingAddressData) {\n                    checkoutProvider.set(\n                        'shippingAddress',\n                        $.extend(true, {}, checkoutProvider.get('shippingAddress'), shippingAddressData)\n                    );\n                }\n                checkoutProvider.on('shippingAddress', function (shippingAddrsData, changes) {\n                    var isStreetAddressDeleted, isStreetAddressNotEmpty;\n\n                    /**\n                     * In last modifying operation street address was deleted.\n                     * @return {Boolean}\n                     */\n                    isStreetAddressDeleted = function () {\n                        var change;\n\n                        if (!changes || changes.length === 0) {\n                            return false;\n                        }\n\n                        change = changes.pop();\n\n                        if (_.isUndefined(change.value) || _.isUndefined(change.oldValue)) {\n                            return false;\n                        }\n\n                        if (!change.path.startsWith('shippingAddress.street')) {\n                            return false;\n                        }\n\n                        return change.value.length === 0 && change.oldValue.length > 0;\n                    };\n\n                    isStreetAddressNotEmpty = shippingAddrsData.street && !_.isEmpty(shippingAddrsData.street[0]);\n\n                    if (isStreetAddressNotEmpty || isStreetAddressDeleted()) {\n                        checkoutData.setShippingAddressFromData(shippingAddrsData);\n                    }\n                });\n                shippingRatesValidator.initFields(fieldsetName);\n            });\n\n            return this;\n        },\n\n        /**\n         * Navigator change hash handler.\n         *\n         * @param {Object} step - navigation step\n         */\n        navigate: function (step) {\n            step && step.isVisible(true);\n        },\n\n        /**\n         * @return {*}\n         */\n        getPopUp: function () {\n            var self = this,\n                buttons;\n\n            if (!popUp) {\n                buttons = this.popUpForm.options.buttons;\n                this.popUpForm.options.buttons = [\n                    {\n                        text: buttons.save.text ? buttons.save.text : $t('Save Address'),\n                        class: buttons.save.class ? buttons.save.class : 'action primary action-save-address',\n                        click: self.saveNewAddress.bind(self)\n                    },\n                    {\n                        text: buttons.cancel.text ? buttons.cancel.text : $t('Cancel'),\n                        class: buttons.cancel.class ? buttons.cancel.class : 'action secondary action-hide-popup',\n\n                        /** @inheritdoc */\n                        click: this.onClosePopUp.bind(this)\n                    }\n                ];\n\n                /** @inheritdoc */\n                this.popUpForm.options.closed = function () {\n                    self.isFormPopUpVisible(false);\n                };\n\n                this.popUpForm.options.modalCloseBtnHandler = this.onClosePopUp.bind(this);\n                this.popUpForm.options.keyEventHandlers = {\n                    escapeKey: this.onClosePopUp.bind(this)\n                };\n\n                /** @inheritdoc */\n                this.popUpForm.options.opened = function () {\n                    // Store temporary address for revert action in case when user click cancel action\n                    self.temporaryAddress = $.extend(true, {}, checkoutData.getShippingAddressFromData());\n                };\n                popUp = modal(this.popUpForm.options, $(this.popUpForm.element));\n            }\n\n            return popUp;\n        },\n\n        /**\n         * Revert address and close modal.\n         */\n        onClosePopUp: function () {\n            checkoutData.setShippingAddressFromData($.extend(true, {}, this.temporaryAddress));\n            this.getPopUp().closeModal();\n        },\n\n        /**\n         * Show address form popup\n         */\n        showFormPopUp: function () {\n            this.isFormPopUpVisible(true);\n        },\n\n        /**\n         * Save new shipping address\n         */\n        saveNewAddress: function () {\n            var addressData,\n                newShippingAddress;\n\n            this.source.set('params.invalid', false);\n            this.triggerShippingDataValidateEvent();\n\n            if (!this.source.get('params.invalid')) {\n                addressData = this.source.get('shippingAddress');\n                // if user clicked the checkbox, its value is true or false. Need to convert.\n                addressData['save_in_address_book'] = this.saveInAddressBook ? 1 : 0;\n\n                // New address must be selected as a shipping address\n                newShippingAddress = createShippingAddress(addressData);\n                selectShippingAddress(newShippingAddress);\n                checkoutData.setSelectedShippingAddress(newShippingAddress.getKey());\n                checkoutData.setNewCustomerShippingAddress($.extend(true, {}, addressData));\n                this.getPopUp().closeModal();\n                this.isNewAddressAdded(true);\n            }\n        },\n\n        /**\n         * Shipping Method View\n         */\n        rates: shippingService.getShippingRates(),\n        isLoading: shippingService.isLoading,\n        isSelected: ko.computed(function () {\n            return checkoutData.getSelectedShippingRate() ? checkoutData.getSelectedShippingRate() :\n                quote.shippingMethod() ?\n                quote.shippingMethod()['carrier_code'] + '_' + quote.shippingMethod()['method_code'] :\n                null;\n        }),\n\n        /**\n         * @param {Object} shippingMethod\n         * @return {Boolean}\n         */\n        selectShippingMethod: function (shippingMethod) {\n            selectShippingMethodAction(shippingMethod);\n            checkoutData.setSelectedShippingRate(shippingMethod['carrier_code'] + '_' + shippingMethod['method_code']);\n\n            return true;\n        },\n\n        /**\n         * Set shipping information handler\n         */\n        setShippingInformation: function () {\n            if (this.validateShippingInformation()) {\n                quote.billingAddress(null);\n                checkoutDataResolver.resolveBillingAddress();\n                registry.async('checkoutProvider')(function (checkoutProvider) {\n                    var shippingAddressData = checkoutData.getShippingAddressFromData();\n\n                    if (shippingAddressData) {\n                        checkoutProvider.set(\n                            'shippingAddress',\n                            $.extend(true, {}, checkoutProvider.get('shippingAddress'), shippingAddressData)\n                        );\n                    }\n                });\n                setShippingInformationAction().done(\n                    function () {\n                        stepNavigator.next();\n                    }\n                );\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        validateShippingInformation: function () {\n            var shippingAddress,\n                addressData,\n                loginFormSelector = 'form[data-role=email-with-possible-login]',\n                emailValidationResult = customer.isLoggedIn(),\n                field,\n                option = _.isObject(this.countryOptions) && this.countryOptions[quote.shippingAddress().countryId],\n                messageContainer = registry.get('checkout.errors').messageContainer;\n\n            if (!quote.shippingMethod()) {\n                this.errorValidationMessage(\n                    $t('The shipping method is missing. Select the shipping method and try again.')\n                );\n\n                return false;\n            }\n\n            if (!customer.isLoggedIn()) {\n                $(loginFormSelector).validation();\n                emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());\n            }\n\n            if (this.isFormInline) {\n                this.source.set('params.invalid', false);\n                this.triggerShippingDataValidateEvent();\n\n                if (!quote.shippingMethod()['method_code']) {\n                    this.errorValidationMessage(\n                        $t('The shipping method is missing. Select the shipping method and try again.')\n                    );\n                }\n\n                if (emailValidationResult &&\n                    this.source.get('params.invalid') ||\n                    !quote.shippingMethod()['method_code'] ||\n                    !quote.shippingMethod()['carrier_code']\n                ) {\n                    this.focusInvalid();\n\n                    return false;\n                }\n\n                shippingAddress = quote.shippingAddress();\n                addressData = addressConverter.formAddressDataToQuoteAddress(\n                    this.source.get('shippingAddress')\n                );\n\n                //Copy form data to quote shipping address object\n                for (field in addressData) {\n                    if (addressData.hasOwnProperty(field) &&  //eslint-disable-line max-depth\n                        shippingAddress.hasOwnProperty(field) &&\n                        typeof addressData[field] != 'function' &&\n                        _.isEqual(shippingAddress[field], addressData[field])\n                    ) {\n                        shippingAddress[field] = addressData[field];\n                    } else if (typeof addressData[field] != 'function' &&\n                        !_.isEqual(shippingAddress[field], addressData[field])) {\n                        shippingAddress = addressData;\n                        break;\n                    }\n                }\n\n                if (customer.isLoggedIn()) {\n                    shippingAddress['save_in_address_book'] = 1;\n                }\n                selectShippingAddress(shippingAddress);\n            } else if (customer.isLoggedIn() &&\n                option &&\n                option['is_region_required'] &&\n                !quote.shippingAddress().region\n            ) {\n                messageContainer.addErrorMessage({\n                    message: $t('Please specify a regionId in shipping address.')\n                });\n\n                return false;\n            }\n\n            if (!emailValidationResult) {\n                $(loginFormSelector + ' input[name=username]').trigger('focus');\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Trigger Shipping data Validate Event.\n         */\n        triggerShippingDataValidateEvent: function () {\n            this.source.trigger('shippingAddress.data.validate');\n\n            if (this.source.get('shippingAddress.custom_attributes')) {\n                this.source.trigger('shippingAddress.custom_attributes.data.validate');\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/authentication.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/action/login',\n    'Magento_Customer/js/model/customer',\n    'mage/validation',\n    'Magento_Checkout/js/model/authentication-messages',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function ($, Component, loginAction, customer, validation, messageContainer, fullScreenLoader) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig;\n\n    return Component.extend({\n        isGuestCheckoutAllowed: checkoutConfig.isGuestCheckoutAllowed,\n        isCustomerLoginRequired: checkoutConfig.isCustomerLoginRequired,\n        registerUrl: checkoutConfig.registerUrl,\n        forgotPasswordUrl: checkoutConfig.forgotPasswordUrl,\n        autocomplete: checkoutConfig.autocomplete,\n        defaults: {\n            template: 'Magento_Checkout/authentication'\n        },\n\n        /**\n         * Is login form enabled for current customer.\n         *\n         * @return {Boolean}\n         */\n        isActive: function () {\n            return !customer.isLoggedIn();\n        },\n\n        /**\n         * Provide login action.\n         *\n         * @param {HTMLElement} loginForm\n         */\n        login: function (loginForm) {\n            var loginData = {},\n                formDataArray = $(loginForm).serializeArray();\n\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if ($(loginForm).validation() &&\n                $(loginForm).validation('isValid')\n            ) {\n                fullScreenLoader.startLoader();\n                loginAction(loginData, checkoutConfig.checkoutUrl, undefined, messageContainer).always(function () {\n                    fullScreenLoader.stopLoader();\n                });\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/billing-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/model/address-list',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/create-billing-address',\n    'Magento_Checkout/js/action/select-billing-address',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'Magento_Customer/js/customer-data',\n    'Magento_Checkout/js/action/set-billing-address',\n    'Magento_Ui/js/model/messageList',\n    'mage/translate',\n    'Magento_Checkout/js/model/billing-address-postcode-validator',\n    'Magento_Checkout/js/model/address-converter'\n],\nfunction (\n    ko,\n    _,\n    Component,\n    customer,\n    addressList,\n    quote,\n    createBillingAddress,\n    selectBillingAddress,\n    checkoutData,\n    checkoutDataResolver,\n    customerData,\n    setBillingAddressAction,\n    globalMessageList,\n    $t,\n    billingAddressPostcodeValidator,\n    addressConverter\n) {\n    'use strict';\n\n    var lastSelectedBillingAddress = null,\n        addressUpdated = false,\n        addressEdited = false,\n        countryData = customerData.get('directory-data'),\n        addressOptions = addressList().filter(function (address) {\n            return address.getType() === 'customer-address';\n        });\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/billing-address',\n            actionsTemplate: 'Magento_Checkout/billing-address/actions',\n            formTemplate: 'Magento_Checkout/billing-address/form',\n            detailsTemplate: 'Magento_Checkout/billing-address/details',\n            links: {\n                isAddressFormVisible: '${$.billingAddressListProvider}:isNewAddressSelected'\n            }\n        },\n        currentBillingAddress: quote.billingAddress,\n        customerHasAddresses: addressOptions.length > 0,\n\n        /**\n         * Init component\n         */\n        initialize: function () {\n            this._super();\n            quote.paymentMethod.subscribe(function () {\n                checkoutDataResolver.resolveBillingAddress();\n            }, this);\n            billingAddressPostcodeValidator.initFields(this.get('name') + '.form-fields');\n        },\n\n        /**\n         * @return {exports.initObservable}\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    selectedAddress: null,\n                    isAddressDetailsVisible: quote.billingAddress() != null,\n                    isAddressFormVisible: !customer.isLoggedIn() || !addressOptions.length,\n                    isAddressSameAsShipping: false,\n                    saveInAddressBook: 1\n                });\n\n            quote.billingAddress.subscribe(function (newAddress) {\n                if (quote.isVirtual()) {\n                    this.isAddressSameAsShipping(false);\n                } else {\n                    this.isAddressSameAsShipping(\n                        newAddress != null &&\n                        newAddress.getCacheKey() == quote.shippingAddress().getCacheKey() //eslint-disable-line eqeqeq\n                    );\n                }\n\n                if (newAddress != null && newAddress.saveInAddressBook !== undefined) {\n                    this.saveInAddressBook(newAddress.saveInAddressBook);\n                } else {\n                    this.saveInAddressBook(1);\n                }\n                this.isAddressDetailsVisible(true);\n            }, this);\n\n            return this;\n        },\n\n        canUseShippingAddress: ko.computed(function () {\n            return !quote.isVirtual() && quote.shippingAddress() && quote.shippingAddress().canUseForBilling();\n        }),\n\n        /**\n         * @param {Object} address\n         * @return {*}\n         */\n        addressOptionsText: function (address) {\n            return address.getAddressInline();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        useShippingAddress: function () {\n            if (this.isAddressSameAsShipping()) {\n                selectBillingAddress(quote.shippingAddress());\n                this.updateAddresses(true);\n                this.isAddressDetailsVisible(true);\n            } else {\n                lastSelectedBillingAddress = quote.billingAddress();\n                quote.billingAddress(null);\n                this.isAddressDetailsVisible(false);\n            }\n            checkoutData.setSelectedBillingAddress(null);\n\n            return true;\n        },\n\n        /**\n         * Update address action\n         */\n        updateAddress: function () {\n            var addressData, newBillingAddress;\n\n            addressUpdated = true;\n\n            if (this.selectedAddress() && !this.isAddressFormVisible()) {\n                selectBillingAddress(this.selectedAddress());\n                checkoutData.setSelectedBillingAddress(this.selectedAddress().getKey());\n            } else {\n                this.source.set('params.invalid', false);\n                this.source.trigger(this.dataScopePrefix + '.data.validate');\n\n                if (this.source.get(this.dataScopePrefix + '.custom_attributes')) {\n                    this.source.trigger(this.dataScopePrefix + '.custom_attributes.data.validate');\n                }\n\n                if (!this.source.get('params.invalid')) {\n                    addressData = this.source.get(this.dataScopePrefix);\n\n                    if (customer.isLoggedIn() && !this.customerHasAddresses) { //eslint-disable-line max-depth\n                        this.saveInAddressBook(1);\n                    }\n                    addressData['save_in_address_book'] = this.saveInAddressBook() ? 1 : 0;\n                    newBillingAddress = createBillingAddress(addressData);\n                    // New address must be selected as a billing address\n                    selectBillingAddress(newBillingAddress);\n                    checkoutData.setSelectedBillingAddress(newBillingAddress.getKey());\n                    checkoutData.setNewCustomerBillingAddress(addressData);\n                }\n            }\n            this.updateAddresses(true);\n        },\n\n        /**\n         * Edit address action\n         */\n        editAddress: function () {\n            addressUpdated = false;\n            addressEdited = true;\n            lastSelectedBillingAddress = quote.billingAddress();\n            quote.billingAddress(null);\n            this.isAddressDetailsVisible(false);\n        },\n\n        /**\n         * Cancel address edit action\n         */\n        cancelAddressEdit: function () {\n            addressUpdated = true;\n            this.restoreBillingAddress();\n\n            if (quote.billingAddress()) {\n                // restore 'Same As Shipping' checkbox state\n                this.isAddressSameAsShipping(\n                    quote.billingAddress() != null &&\n                        quote.billingAddress().getCacheKey() == quote.shippingAddress().getCacheKey() && //eslint-disable-line\n                        !quote.isVirtual()\n                );\n                this.isAddressDetailsVisible(true);\n            }\n        },\n\n        /**\n         * Manage cancel button visibility\n         */\n        canUseCancelBillingAddress: ko.computed(function () {\n            return quote.billingAddress() || lastSelectedBillingAddress;\n        }),\n\n        /**\n         * Check if Billing Address Changes should be canceled\n         */\n        needCancelBillingAddressChanges: function () {\n            if (addressEdited && !addressUpdated) {\n                this.cancelAddressEdit();\n            }\n        },\n\n        /**\n         * Restore billing address\n         */\n        restoreBillingAddress: function () {\n            var lastBillingAddress;\n\n            if (lastSelectedBillingAddress != null) {\n                selectBillingAddress(lastSelectedBillingAddress);\n                lastBillingAddress = addressConverter.quoteAddressToFormAddressData(lastSelectedBillingAddress);\n\n                checkoutData.setNewCustomerBillingAddress(lastBillingAddress);\n            }\n        },\n\n        /**\n         * @param {Number} countryId\n         * @return {*}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /**\n         * Trigger action to update shipping and billing addresses\n         *\n         * @param {Boolean} force\n         */\n        updateAddresses: function (force) {\n            force = !(typeof force === 'undefined' || force !== true);\n\n            if (force\n                || window.checkoutConfig.reloadOnBillingAddress\n                || !window.checkoutConfig.displayBillingOnPaymentMethod) {\n                setBillingAddressAction(globalMessageList);\n            }\n        },\n\n        /**\n         * Get code\n         * @param {Object} parent\n         * @returns {String}\n         */\n        getCode: function (parent) {\n            return _.isFunction(parent.getCode) ? parent.getCode() : 'shared';\n        },\n\n        /**\n         * Get customer attribute label\n         *\n         * @param {*} attribute\n         * @returns {*}\n         */\n        getCustomAttributeLabel: function (attribute) {\n            var label;\n\n            if (typeof attribute === 'string') {\n                return attribute;\n            }\n\n            if (attribute.label) {\n                return attribute.label;\n            }\n\n            if (_.isArray(attribute.value)) {\n                label = _.map(attribute.value, function (value) {\n                    return this.getCustomAttributeOptionLabel(attribute['attribute_code'], value) || value;\n                }, this).join(', ');\n            } else if (typeof attribute.value === 'object') {\n                label = _.map(Object.values(attribute.value)).join(', ');\n            } else {\n                label = this.getCustomAttributeOptionLabel(attribute['attribute_code'], attribute.value);\n            }\n\n            return label || attribute.value;\n        },\n\n        /**\n         * Get option label for given attribute code and option ID\n         *\n         * @param {String} attributeCode\n         * @param {String} value\n         * @returns {String|null}\n         */\n        getCustomAttributeOptionLabel: function (attributeCode, value) {\n            var option,\n                label,\n                options = this.source.get('customAttributes') || {};\n\n            if (options[attributeCode]) {\n                option = _.findWhere(options[attributeCode], {\n                    value: value\n                });\n\n                if (option) {\n                    label = option.label;\n                }\n            } else if (value.file !== null) {\n                label = value.file;\n            }\n\n            return label;\n        }\n    });\n});\n","Magento_Checkout/js/view/form/element/email.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'ko',\n    'Magento_Customer/js/model/customer',\n    'Magento_Customer/js/action/check-email-availability',\n    'Magento_Customer/js/action/login',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/validation'\n], function ($, Component, ko, customer, checkEmailAvailability, loginAction, quote, checkoutData, fullScreenLoader) {\n    'use strict';\n\n    var validatedEmail;\n\n    if (!checkoutData.getValidatedEmailValue() &&\n        window.checkoutConfig.validatedEmailValue\n    ) {\n        checkoutData.setInputFieldEmailValue(window.checkoutConfig.validatedEmailValue);\n        checkoutData.setValidatedEmailValue(window.checkoutConfig.validatedEmailValue);\n    }\n\n    validatedEmail = checkoutData.getValidatedEmailValue();\n\n    if (validatedEmail && !customer.isLoggedIn()) {\n        quote.guestEmail = validatedEmail;\n    }\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/form/element/email',\n            email: checkoutData.getInputFieldEmailValue(),\n            emailFocused: false,\n            isLoading: false,\n            isPasswordVisible: false,\n            listens: {\n                email: 'emailHasChanged',\n                emailFocused: 'validateEmail'\n            },\n            ignoreTmpls: {\n                email: true\n            }\n        },\n        checkDelay: 2000,\n        checkRequest: null,\n        isEmailCheckComplete: null,\n        isCustomerLoggedIn: customer.isLoggedIn,\n        forgotPasswordUrl: window.checkoutConfig.forgotPasswordUrl,\n        emailCheckTimeout: 0,\n        emailInputId: '#customer-email',\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.isPasswordVisible = this.resolveInitialPasswordVisibility();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['email', 'emailFocused', 'isLoading', 'isPasswordVisible']);\n\n            return this;\n        },\n\n        /**\n         * Callback on changing email property\n         */\n        emailHasChanged: function () {\n            var self = this;\n\n            clearTimeout(this.emailCheckTimeout);\n\n            if (self.validateEmail()) {\n                quote.guestEmail = self.email();\n                checkoutData.setValidatedEmailValue(self.email());\n            }\n            this.emailCheckTimeout = setTimeout(function () {\n                if (self.validateEmail()) {\n                    self.checkEmailAvailability();\n                } else {\n                    self.isPasswordVisible(false);\n                }\n            }, self.checkDelay);\n\n            checkoutData.setInputFieldEmailValue(self.email());\n        },\n\n        /**\n         * Check email existing.\n         */\n        checkEmailAvailability: function () {\n            this.validateRequest();\n            this.isEmailCheckComplete = $.Deferred();\n            // Clean up errors on email\n            $(this.emailInputId).removeClass('mage-error').parent().find('.mage-error').remove();\n            this.isLoading(true);\n            this.checkRequest = checkEmailAvailability(this.isEmailCheckComplete, this.email());\n\n            $.when(this.isEmailCheckComplete).done(function () {\n                this.isPasswordVisible(false);\n                checkoutData.setCheckedEmailValue('');\n            }.bind(this)).fail(function () {\n                this.isPasswordVisible(true);\n                checkoutData.setCheckedEmailValue(this.email());\n            }.bind(this)).always(function () {\n                this.isLoading(false);\n            }.bind(this));\n        },\n\n        /**\n         * If request has been sent -> abort it.\n         * ReadyStates for request aborting:\n         * 1 - The request has been set up\n         * 2 - The request has been sent\n         * 3 - The request is in process\n         */\n        validateRequest: function () {\n            if (this.checkRequest != null && $.inArray(this.checkRequest.readyState, [1, 2, 3])) {\n                this.checkRequest.abort();\n                this.checkRequest = null;\n            }\n        },\n\n        /**\n         * Local email validation.\n         *\n         * @param {Boolean} focused - input focus.\n         * @returns {Boolean} - validation result.\n         */\n        validateEmail: function (focused) {\n            var loginFormSelector = 'form[data-role=email-with-possible-login]',\n                usernameSelector = loginFormSelector + ' input[name=username]',\n                loginForm = $(loginFormSelector),\n                validator,\n                valid;\n\n            loginForm.validation();\n\n            if (focused === false && !!this.email()) {\n                valid = !!$(usernameSelector).valid();\n\n                if (valid) {\n                    $(usernameSelector).removeAttr('aria-invalid aria-describedby');\n                }\n\n                return valid;\n            }\n\n            if (loginForm.is(':visible')) {\n                validator = loginForm.validate();\n\n                return validator.check(usernameSelector);\n            }\n\n            return true;\n        },\n\n        /**\n         * Log in form submitting callback.\n         *\n         * @param {HTMLElement} loginForm - form element.\n         */\n        login: function (loginForm) {\n            var loginData = {},\n                formDataArray = $(loginForm).serializeArray();\n\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n\n            if (this.isPasswordVisible() && $(loginForm).validation() && $(loginForm).validation('isValid')) {\n                fullScreenLoader.startLoader();\n                loginAction(loginData).always(function () {\n                    fullScreenLoader.stopLoader();\n                });\n            }\n        },\n\n        /**\n         * Resolves an initial state of a login form.\n         *\n         * @returns {Boolean} - initial visibility state.\n         */\n        resolveInitialPasswordVisibility: function () {\n            if (checkoutData.getInputFieldEmailValue() !== '' && checkoutData.getCheckedEmailValue() !== '') {\n                return true;\n            }\n\n            if (checkoutData.getInputFieldEmailValue() !== '') {\n                return checkoutData.getInputFieldEmailValue() === checkoutData.getCheckedEmailValue();\n            }\n\n            return false;\n        }\n    });\n});\n","Magento_Checkout/js/view/configure/product-customer-data.js":"require([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'underscore',\n    'domReady!'\n], function ($, customerData, _) {\n    'use strict';\n\n    var selectors = {\n        qtySelector: '#product_addtocart_form [name=\"qty\"]',\n        productIdSelector: '#product_addtocart_form [name=\"product\"]',\n        itemIdSelector: '#product_addtocart_form [name=\"item\"]'\n    },\n    cartData = customerData.get('cart'),\n    productId = $(selectors.productIdSelector).val(),\n    itemId = $(selectors.itemIdSelector).val(),\n    productQty,\n    productQtyInput,\n\n    /**\n    * Updates product's qty input value according to actual data\n    */\n    updateQty = function () {\n\n        if (productQty || productQty === 0) {\n            productQtyInput = productQtyInput || $(selectors.qtySelector);\n\n            if (productQtyInput && productQty.toString() !== productQtyInput.val()) {\n                productQtyInput.val(productQty);\n            }\n        }\n    },\n\n    /**\n    * Sets productQty according to cart data from customer-data\n    *\n    * @param {Object} data - cart data from customer-data\n    */\n    setProductQty = function (data) {\n        var product;\n\n        if (!(data && data.items && data.items.length && productId)) {\n            return;\n        }\n        product = _.find(data.items, function (item) {\n            if (item['item_id'] === itemId) {\n                return item['product_id'] === productId ||\n                    item['item_id'] === productId;\n            }\n        });\n\n        if (!product) {\n            return;\n        }\n        productQty = product.qty;\n    };\n\n    cartData.subscribe(function (updateCartData) {\n        setProductQty(updateCartData);\n        updateQty();\n    });\n\n    setProductQty(cartData());\n    updateQty();\n});\n","Magento_Checkout/js/view/shipping-address/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Customer/js/model/address-list'\n], function (_, ko, utils, Component, layout, addressList) {\n    'use strict';\n\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-address/address-renderer/default',\n        provider: 'checkoutProvider'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/list',\n            visible: addressList().length > 0,\n            rendererTemplates: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            addressList.subscribe(function (changes) {\n                    var self = this;\n\n                    changes.forEach(function (change) {\n                        if (change.status === 'added') {\n                            self.createRendererComponent(change.value, change.index);\n                        }\n                    });\n                },\n                this,\n                'arrayChange'\n            );\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n            // the list of child components that are responsible for address rendering\n            this.rendererComponents = [];\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initChildren: function () {\n            _.each(addressList(), this.createRendererComponent, this);\n\n            return this;\n        },\n\n        /**\n         * Create new component that will render given address in the address list\n         *\n         * @param {Object} address\n         * @param {*} index\n         */\n        createRendererComponent: function (address, index) {\n            var rendererTemplate, templateData, rendererComponent;\n\n            if (index in this.rendererComponents) {\n                this.rendererComponents[index].address(address);\n            } else {\n                // rendererTemplates are provided via layout\n                rendererTemplate = address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined ? //eslint-disable-line\n                    utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()]) :\n                    defaultRendererTemplate;\n                templateData = {\n                    parentName: this.name,\n                    name: index\n                };\n                rendererComponent = utils.template(rendererTemplate, templateData);\n                utils.extend(rendererComponent, {\n                    address: ko.observable(address)\n                });\n                layout([rendererComponent]);\n                this.rendererComponents[index] = rendererComponent;\n            }\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-address/address-renderer/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'underscore',\n    'Magento_Checkout/js/action/select-shipping-address',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-address/form-popup-state',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Customer/js/customer-data'\n], function ($, ko, Component, _, selectShippingAddressAction, quote, formPopUpState, checkoutData, customerData) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-address/address-renderer/default'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super();\n            this.isSelected = ko.computed(function () {\n                var isSelected = false,\n                    shippingAddress = quote.shippingAddress();\n\n                if (shippingAddress) {\n                    isSelected = shippingAddress.getKey() == this.address().getKey(); //eslint-disable-line eqeqeq\n                }\n\n                return isSelected;\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * @param {String} countryId\n         * @return {String}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        /**\n         * Get customer attribute label\n         *\n         * @param {*} attribute\n         * @returns {*}\n         */\n        getCustomAttributeLabel: function (attribute) {\n            var label;\n\n            if (typeof attribute === 'string') {\n                return attribute;\n            }\n\n            if (attribute.label) {\n                return attribute.label;\n            }\n\n            if (_.isArray(attribute.value)) {\n                label = _.map(attribute.value, function (value) {\n                    return this.getCustomAttributeOptionLabel(attribute['attribute_code'], value) || value;\n                }, this).join(', ');\n            } else if (typeof attribute.value === 'object') {\n                label = _.map(Object.values(attribute.value)).join(', ');\n            } else {\n                label = this.getCustomAttributeOptionLabel(attribute['attribute_code'], attribute.value);\n            }\n\n            return label || attribute.value;\n        },\n\n        /**\n         * Get option label for given attribute code and option ID\n         *\n         * @param {String} attributeCode\n         * @param {String} value\n         * @returns {String|null}\n         */\n        getCustomAttributeOptionLabel: function (attributeCode, value) {\n            var option,\n                label,\n                options = this.source.get('customAttributes') || {};\n\n            if (options[attributeCode]) {\n                option = _.findWhere(options[attributeCode], {\n                    value: value\n                });\n\n                if (option) {\n                    label = option.label;\n                }\n            } else if (value.file !== null) {\n                label = value.file;\n            }\n\n            return label;\n        },\n\n        /** Set selected customer shipping address  */\n        selectAddress: function () {\n            selectShippingAddressAction(this.address());\n            checkoutData.setSelectedShippingAddress(this.address().getKey());\n        },\n\n        /**\n         * Edit address.\n         */\n        editAddress: function () {\n            formPopUpState.isVisible(true);\n            this.showPopup();\n\n        },\n\n        /**\n         * Show popup.\n         */\n        showPopup: function () {\n            $('[data-open-modal=\"opc-new-shipping-address\"]').trigger('click');\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/method-list',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'mage/translate',\n    'uiRegistry'\n], function (_, ko, utils, Component, paymentMethods, rendererList, layout, checkoutDataResolver, $t, registry) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/payment-methods/list',\n            visible: paymentMethods().length > 0,\n            configDefaultGroup: {\n                name: 'methodGroup',\n                component: 'Magento_Checkout/js/model/payment/method-group'\n            },\n            paymentGroupsList: [],\n            defaultGroupTitle: $t('Select a new payment method')\n        },\n\n        /**\n         * Initialize view.\n         *\n         * @returns {Component} Chainable.\n         */\n        initialize: function () {\n            this._super().initDefaulGroup().initChildren();\n            paymentMethods.subscribe(\n                function (changes) {\n                    checkoutDataResolver.resolvePaymentMethod();\n                    //remove renderer for \"deleted\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'deleted') {\n                            this.removeRenderer(change.value.method);\n                        }\n                    }, this);\n                    //add renderer for \"added\" payment methods\n                    _.each(changes, function (change) {\n                        if (change.status === 'added') {\n                            this.createRenderer(change.value);\n                        }\n                    }, this);\n                }, this, 'arrayChange');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().\n                observe(['paymentGroupsList']);\n\n            return this;\n        },\n\n        /**\n         * Creates default group\n         *\n         * @returns {Component} Chainable.\n         */\n        initDefaulGroup: function () {\n            layout([\n                this.configDefaultGroup\n            ]);\n\n            return this;\n        },\n\n        /**\n         * Create renders for child payment methods.\n         *\n         * @returns {Component} Chainable.\n         */\n        initChildren: function () {\n            var self = this;\n\n            _.each(paymentMethods(), function (paymentMethodData) {\n                self.createRenderer(paymentMethodData);\n            });\n\n            return this;\n        },\n\n        /**\n         * @returns\n         */\n        createComponent: function (payment) {\n            var rendererTemplate,\n                rendererComponent,\n                templateData;\n\n            templateData = {\n                parentName: this.name,\n                name: payment.name\n            };\n            rendererTemplate = {\n                parent: '${ $.$data.parentName }',\n                name: '${ $.$data.name }',\n                displayArea: payment.displayArea,\n                component: payment.component\n            };\n            rendererComponent = utils.template(rendererTemplate, templateData);\n            utils.extend(rendererComponent, {\n                item: payment.item,\n                config: payment.config\n            });\n\n            return rendererComponent;\n        },\n\n        /**\n         * Create renderer.\n         *\n         * @param {Object} paymentMethodData\n         */\n        createRenderer: function (paymentMethodData) {\n            var isRendererForMethod = false,\n                currentGroup;\n\n            registry.get(this.configDefaultGroup.name, function (defaultGroup) {\n                _.each(rendererList(), function (renderer) {\n\n                    if (renderer.hasOwnProperty('typeComparatorCallback') &&\n                        typeof renderer.typeComparatorCallback == 'function'\n                    ) {\n                        isRendererForMethod = renderer.typeComparatorCallback(renderer.type, paymentMethodData.method);\n                    } else {\n                        isRendererForMethod = renderer.type === paymentMethodData.method;\n                    }\n\n                    if (isRendererForMethod) {\n                        currentGroup = renderer.group ? renderer.group : defaultGroup;\n\n                        this.collectPaymentGroups(currentGroup);\n\n                        layout([\n                            this.createComponent(\n                                {\n                                    config: renderer.config,\n                                    component: renderer.component,\n                                    name: renderer.type,\n                                    method: paymentMethodData.method,\n                                    item: paymentMethodData,\n                                    displayArea: currentGroup.displayArea\n                                }\n                            )]);\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Collects unique groups of available payment methods\n         *\n         * @param {Object} group\n         */\n        collectPaymentGroups: function (group) {\n            var groupsList = this.paymentGroupsList(),\n                isGroupExists = _.some(groupsList, function (existsGroup) {\n                    return existsGroup.alias === group.alias;\n                });\n\n            if (!isGroupExists) {\n                groupsList.push(group);\n                groupsList = _.sortBy(groupsList, function (existsGroup) {\n                    return existsGroup.sortOrder;\n                });\n                this.paymentGroupsList(groupsList);\n            }\n        },\n\n        /**\n         * Returns payment group title\n         *\n         * @param {Object} group\n         * @returns {String}\n         */\n        getGroupTitle: function (group) {\n            var title = group().title;\n\n            if (group().isDefault() && this.paymentGroupsList().length > 1) {\n                title = this.defaultGroupTitle;\n            }\n\n            return title;\n        },\n\n        /**\n         * Checks if at least one payment method available\n         *\n         * @returns {String}\n         */\n        isPaymentMethodsAvailable: function () {\n            return _.some(this.paymentGroupsList(), function (group) {\n                return this.regionHasElements(group.displayArea);\n            }, this);\n        },\n\n        /**\n         * Remove view renderer.\n         *\n         * @param {String} paymentMethodCode\n         */\n        removeRenderer: function (paymentMethodCode) {\n            var items;\n\n            _.each(this.paymentGroupsList(), function (group) {\n                items = this.getRegion(group.displayArea);\n\n                _.find(items(), function (value) {\n                    if (value.item.method.indexOf(paymentMethodCode) === 0) {\n                        value.disposeSubscriptions();\n                        value.destroy();\n                    }\n                });\n            }, this);\n        }\n    });\n});\n","Magento_Checkout/js/view/payment/email-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'uiComponent',\n        'Magento_Checkout/js/model/payment/additional-validators',\n        'Magento_Checkout/js/model/customer-email-validator'\n    ],\n    function (Component, additionalValidators, agreementValidator) {\n        'use strict';\n\n        additionalValidators.registerValidator(agreementValidator);\n\n        return Component.extend({});\n    }\n);\n","Magento_Checkout/js/view/payment/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'uiComponent',\n    'Magento_Checkout/js/action/place-order',\n    'Magento_Checkout/js/action/select-payment-method',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/model/customer',\n    'Magento_Checkout/js/model/payment-service',\n    'Magento_Checkout/js/checkout-data',\n    'Magento_Checkout/js/model/checkout-data-resolver',\n    'uiRegistry',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Ui/js/model/messages',\n    'uiLayout',\n    'Magento_Checkout/js/action/redirect-on-success'\n], function (\n    ko,\n    $,\n    Component,\n    placeOrderAction,\n    selectPaymentMethodAction,\n    quote,\n    customer,\n    paymentService,\n    checkoutData,\n    checkoutDataResolver,\n    registry,\n    additionalValidators,\n    Messages,\n    layout,\n    redirectOnSuccessAction\n) {\n    'use strict';\n\n    return Component.extend({\n        redirectAfterPlaceOrder: true,\n        isPlaceOrderActionAllowed: ko.observable(quote.billingAddress() != null),\n\n        /**\n         * After place order callback\n         */\n        afterPlaceOrder: function () {\n            // Override this function and put after place order logic here\n        },\n\n        /**\n         * Initialize view.\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            var billingAddressCode,\n                billingAddressData,\n                defaultAddressData;\n\n            this._super().initChildren();\n            quote.billingAddress.subscribe(function (address) {\n                this.isPlaceOrderActionAllowed(address !== null);\n            }, this);\n            checkoutDataResolver.resolveBillingAddress();\n\n            billingAddressCode = 'billingAddress' + this.getCode();\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                defaultAddressData = checkoutProvider.get(billingAddressCode);\n\n                if (defaultAddressData === undefined) {\n                    // Skip if payment does not have a billing address form\n                    return;\n                }\n                billingAddressData = checkoutData.getBillingAddressFromData();\n\n                if (billingAddressData) {\n                    checkoutProvider.set(\n                        billingAddressCode,\n                        $.extend(true, {}, defaultAddressData, billingAddressData)\n                    );\n                }\n                checkoutProvider.on(billingAddressCode, function (providerBillingAddressData) {\n                    checkoutData.setBillingAddressFromData(providerBillingAddressData);\n                }, billingAddressCode);\n            });\n\n            return this;\n        },\n\n        /**\n         * Initialize child elements\n         *\n         * @returns {Component} Chainable.\n         */\n        initChildren: function () {\n            this.messageContainer = new Messages();\n            this.createMessagesComponent();\n\n            return this;\n        },\n\n        /**\n         * Create child message renderer component\n         *\n         * @returns {Component} Chainable.\n         */\n        createMessagesComponent: function () {\n\n            var messagesComponent = {\n                parent: this.name,\n                name: this.name + '.messages',\n                displayArea: 'messages',\n                component: 'Magento_Ui/js/view/messages',\n                config: {\n                    messageContainer: this.messageContainer\n                }\n            };\n\n            layout([messagesComponent]);\n\n            return this;\n        },\n\n        /**\n         * Place order.\n         */\n        placeOrder: function (data, event) {\n            var self = this;\n\n            if (event) {\n                event.preventDefault();\n            }\n\n            if (this.validate() &&\n                additionalValidators.validate() &&\n                this.isPlaceOrderActionAllowed() === true\n            ) {\n                this.isPlaceOrderActionAllowed(false);\n\n                this.getPlaceOrderDeferredObject()\n                    .done(\n                        function () {\n                            self.afterPlaceOrder();\n\n                            if (self.redirectAfterPlaceOrder) {\n                                redirectOnSuccessAction.execute();\n                            }\n                        }\n                    ).always(\n                        function () {\n                            self.isPlaceOrderActionAllowed(true);\n                        }\n                    );\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @return {*}\n         */\n        getPlaceOrderDeferredObject: function () {\n            return $.when(\n                placeOrderAction(this.getData(), this.messageContainer)\n            );\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        selectPaymentMethod: function () {\n            selectPaymentMethodAction(this.getData());\n            checkoutData.setSelectedPaymentMethod(this.item.method);\n\n            return true;\n        },\n\n        isChecked: ko.computed(function () {\n            return quote.paymentMethod() ? quote.paymentMethod().method : null;\n        }),\n\n        isRadioButtonVisible: ko.computed(function () {\n            return paymentService.getAvailablePaymentMethods().length !== 1;\n        }),\n\n        /**\n         * Get payment method data\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'po_number': null,\n                'additional_data': null\n            };\n        },\n\n        /**\n         * Get payment method type.\n         */\n        getTitle: function () {\n            return this.item.title;\n        },\n\n        /**\n         * Get payment method code.\n         */\n        getCode: function () {\n            return this.item.method;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        validate: function () {\n            return true;\n        },\n\n        /**\n         * @return {String}\n         */\n        getBillingAddressFormName: function () {\n            return 'billing-address-form-' + this.item.method;\n        },\n\n        /**\n         * Dispose billing address subscriptions\n         */\n        disposeSubscriptions: function () {\n            // dispose all active subscriptions\n            var billingAddressCode = 'billingAddress' + this.getCode();\n\n            registry.async('checkoutProvider')(function (checkoutProvider) {\n                checkoutProvider.off(billingAddressCode);\n            });\n        }\n    });\n});\n","Magento_Checkout/js/view/shipping-information/list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'mageUtils',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Checkout/js/model/quote'\n], function ($, ko, utils, Component, layout, quote) {\n    'use strict';\n\n    var defaultRendererTemplate = {\n        parent: '${ $.$data.parentName }',\n        name: '${ $.$data.name }',\n        component: 'Magento_Checkout/js/view/shipping-information/address-renderer/default',\n        provider: 'checkoutProvider'\n    };\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/list',\n            rendererTemplates: {}\n        },\n\n        /** @inheritdoc */\n        initializ