require.config({"config": {
        "jsbuild":{"js/navigation-menu.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @deprecated\n * @see lib/web/mage/menu.js\n */\ndefine([\n    'jquery',\n    'matchMedia',\n    'mage/template',\n    'mage/dropdowns',\n    'mage/terms'\n], function ($, mediaCheck, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.navigationMenu', {\n        options: {\n            itemsContainer: '> ul',\n            topLevel: 'li.level0',\n            topLevelSubmenu: '> .submenu',\n            topLevelHoverClass: 'hover',\n            expandedTopLevel: '.more',\n            hoverInTimeout: 300,\n            hoverOutTimeout: 500,\n            submenuAnimationSpeed: 200,\n            collapsable: true,\n            collapsableDropdownTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<li class=\"level0 level-top more parent\">' +\n                        '<div class=\"submenu\">' +\n                            '<ul><%= elems %></ul>' +\n                        '</div>' +\n                    '</li>' +\n                '</script>'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.itemsContainer = $(this.options.itemsContainer, this.element);\n            this.topLevel = $(this.options.topLevel, this.element);\n            this.topLevelSubmenu = $(this.options.topLevelSubmenu, this.topLevel);\n\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            if (this.options.collapsable) {\n                setTimeout($.proxy(function () {\n                    this._checkToCollapseOrExpand();\n                }, this), 100);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._on({\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                'mouseenter > ul > li.level0': function (e) {\n                    if (!this.entered) { // fix IE bug with 'mouseenter' event\n                        this.timeoutId && clearTimeout(this.timeoutId);\n                        this.timeoutId = setTimeout($.proxy(function () {\n                            this._openSubmenu(e);\n                        }, this), this.options.hoverInTimeout);\n                        this.entered = true;\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                'mouseleave > ul > li.level0': function (e) {\n                    this.entered = null;\n\n                    this.timeoutId && clearTimeout(this.timeoutId);\n                    this.timeoutId = setTimeout($.proxy(function () {\n                        this._closeSubmenu(e.currentTarget);\n                    }, this), this.options.hoverOutTimeout);\n                },\n\n                /**\n                 * @param {jQuert.Event} e\n                 */\n                'click': function (e) {\n                    e.stopPropagation();\n                }\n            });\n\n            $(document)\n                .on('click.hideMenu', $.proxy(function () {\n                    var isOpened = this.topLevel.filter(function () {\n                        return $(this).data('opened');\n                    });\n\n                    if (isOpened) {\n                        this._closeSubmenu(null, false);\n                    }\n                }, this));\n\n            $(window)\n                .on('resize', $.proxy(function () {\n                    this.timeoutOnResize && clearTimeout(this.timeoutOnResize);\n                    this.timeoutOnResize = setTimeout($.proxy(function () {\n                        if (this.options.collapsable) {\n                            if ($(this.options.expandedTopLevel, this.element).length) {\n                                this._expandMenu();\n                            }\n                            this._checkToCollapseOrExpand();\n                        }\n                    }, this), 300);\n                }, this));\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _openSubmenu: function (e) {\n            var menuItem = e.currentTarget;\n\n            if (!$(menuItem).data('opened')) {\n                this._closeSubmenu(menuItem, true, true);\n\n                $(this.options.topLevelSubmenu, menuItem)\n                    .slideDown(this.options.submenuAnimationSpeed, $.proxy(function () {\n                        $(menuItem).addClass(this.options.topLevelHoverClass);\n                        $(menuItem).data('opened', true);\n                    }, this));\n            } else if ($(e.target).closest(this.options.topLevel)) {\n                $(e.target)\n                    .addClass(this.options.topLevelHoverClass)\n                    .siblings(this.options.topLevel)\n                        .removeClass(this.options.topLevelHoverClass);\n            }\n        },\n\n        /**\n         * @param {*} menuItem\n         * @param {*} excludeCurrent\n         * @param {*} fast\n         * @private\n         */\n        _closeSubmenu: function (menuItem, excludeCurrent, fast) {\n            var topLevel = $(this.options.topLevel, this.element),\n                activeSubmenu = $(this.options.topLevelSubmenu, menuItem || null);\n\n            $(this.options.topLevelSubmenu, topLevel)\n                .filter(function () {\n                    return excludeCurrent ? $(this).not(activeSubmenu) : true;\n                })\n                .slideUp(fast ? 0 : this.options.submenuAnimationSpeed);\n\n            topLevel\n                .removeClass(this.options.topLevelHoverClass)\n                .data('opened', false);\n        },\n\n        /**\n         * @private\n         */\n        _checkToCollapseOrExpand: function () {\n            var navWidth, totalWidth, startCollapseIndex;\n\n            if ($('html').hasClass('lt-640') || $('html').hasClass('w-640')) {\n                return;\n            }\n\n            navWidth = this.itemsContainer.width();\n            totalWidth = 0;\n            startCollapseIndex = 0;\n\n            $.each($(this.options.topLevel, this.element), function (index, item) {\n                totalWidth += $(item).outerWidth(true);\n\n                if (totalWidth > navWidth && !startCollapseIndex) {\n                    startCollapseIndex = index - 2;\n                }\n            });\n\n            this[startCollapseIndex ? '_collapseMenu' : '_expandMenu'](startCollapseIndex);\n        },\n\n        /**\n         * @param {*} startCollapseIndex\n         * @private\n         */\n        _collapseMenu: function (startCollapseIndex) {\n            this.elemsToCollapse = this.topLevel.filter(function (index) {\n                return index > startCollapseIndex;\n            });\n            this.elemsToCollapseClone = $('<div></div>').append(this.elemsToCollapse.clone()).html();\n\n            this.collapsableDropdown = $(\n                mageTemplate(\n                    this.options.collapsableDropdownTemplate,\n                    {\n                        elems: this.elemsToCollapseClone\n                    }\n                )\n            );\n\n            this.itemsContainer.append(this.collapsableDropdown);\n            this.elemsToCollapse.detach();\n        },\n\n        /**\n         * @private\n         */\n        _expandMenu: function () {\n            this.elemsToCollapse && this.elemsToCollapse.appendTo(this.itemsContainer);\n            this.collapsableDropdown && this.collapsableDropdown.remove();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            this._expandMenu();\n        }\n    });\n\n    /*\n     * Provides \"Continium\" effect for submenu\n     * */\n    $.widget('mage.navigationMenu', $.mage.navigationMenu, {\n        options: {\n            parentLevel: '> ul > li.level0',\n            submenuAnimationSpeed: 150,\n            submenuContiniumEffect: false\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            this._super();\n            this._applySubmenuStyles();\n        },\n\n        /**\n         * @private\n         */\n        _applySubmenuStyles: function () {\n            $(this.options.topLevelSubmenu, $(this.options.topLevel, this.element))\n                .removeAttr('style');\n\n            $(this.options.topLevelSubmenu, $(this.options.parentLevel, this.element))\n                .css({\n                    display: 'block',\n                    height: 0,\n                    overflow: 'hidden'\n                });\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _openSubmenu: function (e) {\n            var menuItem = e.currentTarget,\n                submenu = $(this.options.topLevelSubmenu, menuItem),\n                openedItems = $(this.options.topLevel, this.element).filter(function () {\n                    return $(this).data('opened');\n                });\n\n            if (submenu.length) {\n                this.heightToAnimate = $(this.options.itemsContainer, submenu).outerHeight(true);\n\n                if (openedItems.length) {\n                    this._closeSubmenu(menuItem, true, this.heightToAnimate, $.proxy(function () {\n                        submenu.css({\n                            height: 'auto'\n                        });\n                        $(menuItem)\n                            .addClass(this.options.topLevelHoverClass);\n                    }, this), e);\n                } else {\n                    submenu.animate({\n                        height: this.heightToAnimate\n                    }, this.options.submenuAnimationSpeed, $.proxy(function () {\n                        $(menuItem)\n                            .addClass(this.options.topLevelHoverClass);\n                    }, this));\n                }\n\n                $(menuItem)\n                    .data('opened', true);\n            } else {\n                this._closeSubmenu(menuItem);\n            }\n        },\n\n        /**\n         * @param {*} menuItem\n         * @param {*} excludeCurrent\n         * @param {*} heightToAnimate\n         * @param {Function} callback\n         * @private\n         */\n        _closeSubmenu: function (menuItem, excludeCurrent, heightToAnimate, callback) {\n            var topLevel = $(this.options.topLevel, this.itemsContainer),\n                prevOpenedItem, prevOpenedSubmenu;\n\n            if (!excludeCurrent) {\n                $(this.options.topLevelSubmenu, $(this.options.parentLevel, this.element))\n                    .animate({\n                        height: 0\n                    });\n\n                topLevel\n                    .data('opened', false)\n                    .removeClass(this.options.topLevelHoverClass);\n            } else {\n                prevOpenedItem = topLevel.filter(function () {\n                    return $(this).data('opened');\n                });\n                prevOpenedSubmenu = $(this.options.topLevelSubmenu, prevOpenedItem);\n\n                prevOpenedSubmenu.animate({\n                    height: heightToAnimate\n                }, this.options.submenuAnimationSpeed, 'linear', function () {\n                    $(this).css({\n                        height: 0\n                    });\n                    callback && callback();\n                });\n\n                prevOpenedItem\n                    .data('opened', false)\n                    .removeClass(this.options.topLevelHoverClass);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _collapseMenu: function () {\n            this._superApply(arguments);\n            this._applySubmenuStyles();\n        }\n    });\n\n    //  Responsive menu\n    $.widget('mage.navigationMenu', $.mage.navigationMenu, {\n        options: {\n            responsive: false,\n            origNavPlaceholder: '.page-header',\n            mainContainer: 'body',\n            pageWrapper: '.page-wrapper',\n            openedMenuClass: 'opened',\n            toggleActionPlaceholder: '.block-search',\n            itemWithSubmenu: 'li.parent',\n            titleWithSubmenu: 'li.parent > a',\n            submenu: 'li.parent > .submenu',\n            toggleActionTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<span data-action=\"toggle-nav\" class=\"action toggle nav\">Toggle Nav</span>' +\n                '</script>',\n            submenuActionsTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<li class=\"action all\">' +\n                        '<a href=\"<%= categoryURL %>\"><span>All <%= category %></span></a>' +\n                    '</li>' +\n                '</script>',\n            navigationSectionsWrapperTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<dl class=\"navigation-tabs\" data-sections=\"tabs\">' +\n                    '</dl>' +\n                '</script>',\n            navigationItemWrapperTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<dt class=\"item title <% if (active) { %>active<% } %>\" data-section=\"title\">' +\n                        '<a class=\"switch\" data-toggle=\"switch\" href=\"#TODO\"><%= title %></a>' +\n                    '</dt>' +\n                    '<dd class=\"item content <% if (active) { %>active<%}%>\" data-section=\"content\">' +\n                    '</dd>' +\n                '</script>'\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            this._super();\n\n            this.mainContainer = $(this.options.mainContainer);\n            this.pageWrapper = $(this.options.pageWrapper);\n            this.toggleAction = $(mageTemplate(this.options.toggleActionTemplate, {}));\n\n            if (this.options.responsive) {\n                mediaCheck({\n                    media: '(min-width: 768px)',\n                    entry: $.proxy(function () {\n                        this._toggleDesktopMode();\n                    }, this),\n                    exit: $.proxy(function () {\n                        this._toggleMobileMode();\n                    }, this)\n                });\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._super();\n            this._bindDocumentEvents();\n        },\n\n        /**\n         * @private\n         */\n        _bindDocumentEvents: function () {\n            if (!this.eventsBound) {\n                $(document)\n                    .on('click.toggleMenu', '.action.toggle.nav', $.proxy(function (e) {\n                        if ($(this.element).data('opened')) {\n                            this._hideMenu();\n                        } else {\n                            this._showMenu();\n                        }\n                        e.stopPropagation();\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this))\n                    .on('click.hideMenu', this.options.pageWrapper, $.proxy(function () {\n                        if ($(this.element).data('opened')) {\n                            this._hideMenu();\n                            this.mobileNav.scrollTop(0);\n                            this._fixedBackLink();\n                        }\n                    }, this))\n                    .on('click.showSubmenu', this.options.titleWithSubmenu, $.proxy(function (e) {\n                        this._showSubmenu(e);\n\n                        e.preventDefault();\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this))\n                    .on('click.hideSubmenu', '.action.back', $.proxy(function (e) {\n                        this._hideSubmenu(e);\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this));\n\n                this.eventsBound = true;\n            }\n        },\n\n        /**\n         * @private\n         */\n        _showMenu: function () {\n            $(this.element).data('opened', true);\n            this.mainContainer.add('html').addClass(this.options.openedMenuClass);\n        },\n\n        /**\n         * @private\n         */\n        _hideMenu: function () {\n            $(this.element).data('opened', false);\n            this.mainContainer.add('html').removeClass(this.options.openedMenuClass);\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _showSubmenu: function (e) {\n            var submenu;\n\n            $(e.currentTarget).addClass('action back');\n            submenu = $(e.currentTarget).siblings('.submenu');\n\n            submenu.addClass('opened');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _hideSubmenu: function (e) {\n            var submenuSelector = '.submenu',\n                submenu = $(e.currentTarget).next(submenuSelector);\n\n            $(e.currentTarget).removeClass('action back');\n            submenu.removeClass('opened');\n        },\n\n        /**\n         * @private\n         */\n        _renderSubmenuActions: function () {\n            $.each(\n                $(this.options.itemWithSubmenu),\n                $.proxy(function (index, item) {\n                    var actions = $(mageTemplate(\n                            this.options.submenuActionsTemplate,\n                            {\n                                category: $('> a > span', item).text(),\n                                categoryURL: $('> a', item).attr('href')\n                            }\n                        )),\n                        submenu = $('> .submenu', item),\n                        items = $('> ul', submenu);\n\n                    items.prepend(actions);\n                }, this)\n            );\n        },\n\n        /**\n         * @private\n         */\n        _toggleMobileMode: function () {\n            this._expandMenu();\n\n            $(this.options.topLevelSubmenu, $(this.options.topLevel, this.element))\n                .removeAttr('style');\n\n            this.toggleAction.insertBefore(this.options.toggleActionPlaceholder);\n            this.mobileNav = $(this.element).detach().clone();\n            this.mainContainer.prepend(this.mobileNav);\n            this.mobileNav.find('> ul').addClass('nav');\n            this._insertExtraItems();\n            this._wrapItemsInSections();\n            this.mobileNav.scroll($.proxy(function () {\n                this._fixedBackLink();\n            }, this));\n\n            this._renderSubmenuActions();\n            this._bindDocumentEvents();\n        },\n\n        /**\n         * @private\n         */\n        _toggleDesktopMode: function () {\n            this.mobileNav && this.mobileNav.remove();\n            this.toggleAction.detach();\n            $(this.element).insertAfter(this.options.origNavPlaceholder);\n\n            $(document)\n                .off('click.toggleMenu', '.action.toggle.nav')\n                .off('click.hideMenu', this.options.pageWrapper)\n                .off('click.showSubmenu', this.options.titleWithSubmenu)\n                .off('click.hideSubmenu', '.action.back');\n\n            this.eventsBound = false;\n\n            this._applySubmenuStyles();\n        },\n\n        /**\n         * @private\n         */\n        _insertExtraItems: function () {\n            var settings, footerSettings, account;\n\n            if ($('.header.panel .switcher').length) {\n                settings = $('.header.panel .switcher')\n                    .clone()\n                    .addClass('settings');\n\n                this.mobileNav.prepend(settings);\n            }\n\n            if ($('.footer .switcher').length) {\n                footerSettings = $('.footer .switcher')\n                    .clone()\n                    .addClass('settings');\n\n                this.mobileNav.prepend(footerSettings);\n            }\n\n            if ($('.header.panel .header.links li').length) {\n                account = $('.header.panel > .header.links')\n                    .clone()\n                    .addClass('account');\n\n                this.mobileNav.prepend(account);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _wrapItemsInSections: function () {\n            var account = $('> .account', this.mobileNav),\n                settings = $('> .settings', this.mobileNav),\n                nav = $('> .nav', this.mobileNav),\n                navigationSectionsWrapper = $(mageTemplate(this.options.navigationSectionsWrapperTemplate, {})),\n                navigationItemWrapper;\n\n            this.mobileNav.append(navigationSectionsWrapper);\n\n            if (nav.length) {\n                navigationItemWrapper = $(mageTemplate(this.options.navigationItemWrapperTemplate, {\n                    title: 'Menu'\n                }));\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(nav);\n            }\n\n            if (account.length) {\n                navigationItemWrapper = $(mageTemplate(this.options.navigationItemWrapperTemplate, {\n                    title: 'Account'\n                }));\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(account);\n            }\n\n            if (settings.length) {\n                navigationItemWrapper = $(\n                    mageTemplate(this.options.navigationItemWrapperTemplate, {\n                        title: 'Settings'\n                    })\n                );\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(settings);\n            }\n\n            navigationSectionsWrapper.addClass(\n                'navigation-tabs-' + navigationSectionsWrapper.find('[data-section=\"title\"]').length\n            );\n            navigationSectionsWrapper.terms();\n        },\n\n        /**\n         * @private\n         */\n        _fixedBackLink: function () {\n            var linksBack = this.mobileNav.find('.submenu .action.back'),\n                linkBack = this.mobileNav.find('.submenu.opened > ul > .action.back').last(),\n                subMenu, navOffset, linkBackHeight;\n\n            linksBack.removeClass('fixed');\n\n            if (linkBack.length) {\n                subMenu = linkBack.parent();\n                navOffset = this.mobileNav.find('.nav').position().top;\n                linkBackHeight = linkBack.height();\n\n                if (navOffset <= 0) {\n                    linkBack.addClass('fixed');\n                    subMenu.css({\n                        paddingTop: linkBackHeight\n                    });\n                } else {\n                    linkBack.removeClass('fixed');\n                    subMenu.css({\n                        paddingTop: 0\n                    });\n                }\n            }\n        }\n    });\n\n    return $.mage.navigationMenu;\n});\n","Magento_Vault/js/customer_account/deleteWidget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modalToggle',\n    'mage/translate'\n], function ($, modalToggle) {\n    'use strict';\n\n    return function (config, deleteButton) {\n        config.buttons = [\n            {\n                text: $.mage.__('Cancel'),\n                class: 'action secondary cancel'\n            }, {\n                text: $.mage.__('Delete'),\n                class: 'action primary',\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) { //eslint-disable-line no-unused-vars\n                    $(deleteButton.form).trigger('submit');\n                }\n            }\n        ];\n\n        modalToggle(config, deleteButton);\n    };\n});\n","Magento_Vault/js/view/payment/vault-enabler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\n/* @api */\ndefine(\n    [\n        'uiElement'\n    ],\n    function (\n        Component\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                isActivePaymentTokenEnabler: true\n            },\n\n            /**\n             * @param {String} paymentCode\n             */\n            setPaymentCode: function (paymentCode) {\n                this.paymentCode = paymentCode;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([\n                        'isActivePaymentTokenEnabler'\n                    ]);\n\n                return this;\n            },\n\n            /**\n             * @param {Object} data\n             */\n            visitAdditionalData: function (data) {\n                if (!this.isVaultEnabled()) {\n                    return;\n                }\n\n                if (!('additional_data' in data)) {\n                    data['additional_data'] = {};\n                }\n\n                data['additional_data']['is_active_payment_token_enabler'] = this.isActivePaymentTokenEnabler();\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isVaultEnabled: function () {\n                return typeof window.checkoutConfig.vault[this.paymentCode] !== 'undefined' &&\n                    window.checkoutConfig.vault[this.paymentCode]['is_enabled'] === true;\n            }\n        });\n    }\n);\n","Magento_Vault/js/view/payment/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\n/* @api */\ndefine([\n    'underscore',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'uiRegistry'\n], function (_, Component, rendererList, layout, registry) {\n    'use strict';\n\n    var vaultGroupName = 'vaultGroup';\n\n    layout([{\n        name: vaultGroupName,\n        component: 'Magento_Checkout/js/model/payment/method-group',\n        alias: 'vault',\n        sortOrder: 10\n    }]);\n\n    registry.get(vaultGroupName, function (vaultGroup) {\n        _.each(window.checkoutConfig.payment.vault, function (config, index) {\n            rendererList.push(\n                {\n                    type: index,\n                    config: config.config,\n                    component: config.component,\n                    group: vaultGroup,\n\n                    /**\n                     * Custom payment method types comparator\n                     * @param {String} typeA\n                     * @param {String} typeB\n                     * @return {Boolean}\n                     */\n                    typeComparatorCallback: function (typeA, typeB) {\n                        // vault token items have the same name as vault payment without index\n                        return typeA.substring(0, typeA.lastIndexOf('_')) === typeB;\n                    }\n                }\n            );\n        });\n    });\n\n    /**\n     * Add view logic here if needed\n     */\n    return Component.extend({});\n});\n","Magento_Vault/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Checkout/js/action/select-payment-method',\n        'Magento_Checkout/js/checkout-data'\n    ],\n    function (Component, selectPaymentMethod, checkoutData) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Vault/payment/form'\n            },\n\n            /**\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([]);\n\n                return this;\n            },\n\n            /**\n             * @returns\n             */\n            selectPaymentMethod: function () {\n                selectPaymentMethod(\n                    {\n                        method: this.getId()\n                    }\n                );\n                checkoutData.setSelectedPaymentMethod(this.getId());\n\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getTitle: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getToken: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getId: function () {\n                return this.index;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Get last 4 digits of card\n             * @returns {String}\n             */\n            getMaskedCard: function () {\n                return '';\n            },\n\n            /**\n             * Get expiration date\n             * @returns {String}\n             */\n            getExpirationDate: function () {\n                return '';\n            },\n\n            /**\n             * Get card type\n             * @returns {String}\n             */\n            getCardType: function () {\n                return '';\n            },\n\n            /**\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.ccform.icons[type]\n                    : false;\n            },\n\n            /**\n             * Return state of place order button.\n             *\n             * @return {Boolean}\n             */\n            isButtonActive: function () {\n                return this.isActive() && this.isPlaceOrderActionAllowed();\n            },\n\n            /**\n             * Check if payment is active.\n             *\n             * @return {Boolean}\n             */\n            isActive: function () {\n                return this.isChecked() === this.getId();\n            },\n\n            /**\n             * @returns {*}\n             */\n            getData: function () {\n                var data = {\n                    method: this.getCode()\n                };\n\n                data['additional_data'] = {};\n                data['additional_data']['public_hash'] = this.getToken();\n\n                return data;\n            }\n        });\n    }\n);\n","Magento_GoogleAnalytics/js/google-analytics.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* jscs:disable */\n/* eslint-disable */\ndefine([\n    'jquery',\n    'mage/cookies'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} config\n     */\n    return function (config) {\n        var allowServices = false,\n            allowedCookies,\n            allowedWebsites;\n\n        if (config.isCookieRestrictionModeEnabled) {\n            allowedCookies = $.mage.cookies.get(config.cookieName);\n\n            if (allowedCookies !== null) {\n                allowedWebsites = JSON.parse(allowedCookies);\n\n                if (allowedWebsites[config.currentWebsite] === 1) {\n                    allowServices = true;\n                }\n            }\n        } else {\n            allowServices = true;\n        }\n\n        if (allowServices) {\n            (function (i, s, o, g, r, a, m) {\n                i.GoogleAnalyticsObject = r;\n                i[r] = i[r] || function () {\n                        (i[r].q = i[r].q || []).push(arguments)\n                    }, i[r].l = 1 * new Date();\n                a = s.createElement(o),\n                    m = s.getElementsByTagName(o)[0];\n                a.async = 1;\n                a.src = g;\n                m.parentNode.insertBefore(a, m)\n            })(window, document, 'script', '//www.google-analytics.com/analytics.js', 'ga');\n\n            // Process page info\n            ga('create', config.pageTrackingData.accountId, 'auto');\n\n            if (config.pageTrackingData.isAnonymizedIpActive) {\n                ga('set', 'anonymizeIp', true);\n            }\n\n            // Process orders data\n            if (config.ordersTrackingData.hasOwnProperty('currency')) {\n                ga('require', 'ec', 'ec.js');\n\n                ga('set', 'currencyCode', config.ordersTrackingData.currency);\n\n                // Collect product data for GA\n                if (config.ordersTrackingData.products) {\n                    $.each(config.ordersTrackingData.products, function (index, value) {\n                        ga('ec:addProduct', value);\n                    });\n                }\n\n                // Collect orders data for GA\n                if (config.ordersTrackingData.orders) {\n                    $.each(config.ordersTrackingData.orders, function (index, value) {\n                        ga('ec:setAction', 'purchase', value);\n                    });\n                }\n\n                ga('send', 'pageview');\n            } else {\n                // Process Data if not orders\n                ga('send', 'pageview' + config.pageTrackingData.optPageUrl);\n            }\n        }\n    }\n});\n","jquery/jquery.storageapi.min.js":"/* jQuery Storage API Plugin 1.7.3 https://github.com/julien-maurel/jQuery-Storage-API */\n!function(e){\"function\"==typeof define&&define.amd?define([\"jquery\", \"jquery/jquery.cookie\"],e):e(\"object\"==typeof exports?require(\"jquery\"):jQuery)}(function(e){function t(t){var r,i,n,o=arguments.length,s=window[t],a=arguments,u=a[1];if(2>o)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(u)){i={};for(var f in u){r=u[f];try{i[r]=JSON.parse(s.getItem(r))}catch(c){i[r]=s.getItem(r)}}return i}if(2!=o){try{i=JSON.parse(s.getItem(u))}catch(c){throw new ReferenceError(u+\" is not defined in this storage\")}for(var f=2;o-1>f;f++)if(i=i[a[f]],void 0===i)throw new ReferenceError([].slice.call(a,1,f+1).join(\".\")+\" is not defined in this storage\");if(e.isArray(a[f])){n=i,i={};for(var m in a[f])i[a[f][m]]=n[a[f][m]];return i}return i[a[f]]}try{return JSON.parse(s.getItem(u))}catch(c){return s.getItem(u)}}function r(t){var r,i,n=arguments.length,o=window[t],s=arguments,a=s[1],u=s[2],f={};if(2>n||!e.isPlainObject(a)&&3>n)throw Error(\"Minimum 3 arguments must be given or second parameter must be an object\");if(e.isPlainObject(a)){for(var c in a)r=a[c],e.isPlainObject(r)?o.setItem(c,JSON.stringify(r)):o.setItem(c,r);return a}if(3==n)return\"object\"==typeof u?o.setItem(a,JSON.stringify(u)):o.setItem(a,u),u;try{i=o.getItem(a),null!=i&&(f=JSON.parse(i))}catch(m){}i=f;for(var c=2;n-2>c;c++)r=s[c],i[r]&&e.isPlainObject(i[r])||(i[r]={}),i=i[r];return i[s[c]]=s[c+1],o.setItem(a,JSON.stringify(f)),f}function i(t){var r,i,n=arguments.length,o=window[t],s=arguments,a=s[1];if(2>n)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(a)){for(var u in a)o.removeItem(a[u]);return!0}if(2==n)return o.removeItem(a),!0;try{r=i=JSON.parse(o.getItem(a))}catch(f){throw new ReferenceError(a+\" is not defined in this storage\")}for(var u=2;n-1>u;u++)if(i=i[s[u]],void 0===i)throw new ReferenceError([].slice.call(s,1,u).join(\".\")+\" is not defined in this storage\");if(e.isArray(s[u]))for(var c in s[u])delete i[s[u][c]];else delete i[s[u]];return o.setItem(a,JSON.stringify(r)),!0}function n(t,r){var n=a(t);for(var o in n)i(t,n[o]);if(r)for(var o in e.namespaceStorages)u(o)}function o(r){var i=arguments.length,n=arguments,s=(window[r],n[1]);if(1==i)return 0==a(r).length;if(e.isArray(s)){for(var u=0;u<s.length;u++)if(!o(r,s[u]))return!1;return!0}try{var f=t.apply(this,arguments);e.isArray(n[i-1])||(f={totest:f});for(var u in f)if(!(e.isPlainObject(f[u])&&e.isEmptyObject(f[u])||e.isArray(f[u])&&!f[u].length)&&f[u])return!1;return!0}catch(c){return!0}}function s(r){var i=arguments.length,n=arguments,o=(window[r],n[1]);if(2>i)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(o)){for(var a=0;a<o.length;a++)if(!s(r,o[a]))return!1;return!0}try{var u=t.apply(this,arguments);e.isArray(n[i-1])||(u={totest:u});for(var a in u)if(void 0===u[a]||null===u[a])return!1;return!0}catch(f){return!1}}function a(r){var i=arguments.length,n=window[r],o=arguments,s=(o[1],[]),a={};if(a=i>1?t.apply(this,o):n,a._cookie)for(var u in e.cookie())\"\"!=u&&s.push(u.replace(a._prefix,\"\"));else for(var f in a)s.push(f);return s}function u(t){if(!t||\"string\"!=typeof t)throw Error(\"First parameter must be a string\");g?(window.localStorage.getItem(t)||window.localStorage.setItem(t,\"{}\"),window.sessionStorage.getItem(t)||window.sessionStorage.setItem(t,\"{}\")):(window.localCookieStorage.getItem(t)||window.localCookieStorage.setItem(t,\"{}\"),window.sessionCookieStorage.getItem(t)||window.sessionCookieStorage.setItem(t,\"{}\"));var r={localStorage:e.extend({},e.localStorage,{_ns:t}),sessionStorage:e.extend({},e.sessionStorage,{_ns:t})};return e.cookie&&(window.cookieStorage.getItem(t)||window.cookieStorage.setItem(t,\"{}\"),r.cookieStorage=e.extend({},e.cookieStorage,{_ns:t})),e.namespaceStorages[t]=r,r}function f(e){if(!window[e])return!1;var t=\"jsapi\";try{return window[e].setItem(t,t),window[e].removeItem(t),!0}catch(r){return!1}}var c=\"ls_\",m=\"ss_\",g=f(\"localStorage\"),h={_type:\"\",_ns:\"\",_callMethod:function(e,t){var r=[this._type],t=Array.prototype.slice.call(t),i=t[0];return this._ns&&r.push(this._ns),\"string\"==typeof i&&-1!==i.indexOf(\".\")&&(t.shift(),[].unshift.apply(t,i.split(\".\"))),[].push.apply(r,t),e.apply(this,r)},get:function(){return this._callMethod(t,arguments)},set:function(){var t=arguments.length,i=arguments,n=i[0];if(1>t||!e.isPlainObject(n)&&2>t)throw Error(\"Minimum 2 arguments must be given or first parameter must be an object\");if(e.isPlainObject(n)&&this._ns){for(var o in n)r(this._type,this._ns,o,n[o]);return n}var s=this._callMethod(r,i);return this._ns?s[n.split(\".\")[0]]:s},remove:function(){if(arguments.length<1)throw Error(\"Minimum 1 argument must be given\");return this._callMethod(i,arguments)},removeAll:function(e){return this._ns?(r(this._type,this._ns,{}),!0):n(this._type,e)},isEmpty:function(){return this._callMethod(o,arguments)},isSet:function(){if(arguments.length<1)throw Error(\"Minimum 1 argument must be given\");return this._callMethod(s,arguments)},keys:function(){return this._callMethod(a,arguments)}};if(e.cookie){window.name||(window.name=Math.floor(1e8*Math.random()));var l={_cookie:!0,_prefix:\"\",_expires:null,_path:null,_domain:null,setItem:function(t,r){e.cookie(this._prefix+t,r,{expires:this._expires,path:this._path,domain:this._domain})},getItem:function(t){return e.cookie(this._prefix+t)},removeItem:function(t){return e.removeCookie(this._prefix+t)},clear:function(){for(var t in e.cookie())\"\"!=t&&(!this._prefix&&-1===t.indexOf(c)&&-1===t.indexOf(m)||this._prefix&&0===t.indexOf(this._prefix))&&e.removeCookie(t)},setExpires:function(e){return this._expires=e,this},setPath:function(e){return this._path=e,this},setDomain:function(e){return this._domain=e,this},setConf:function(e){return e.path&&(this._path=e.path),e.domain&&(this._domain=e.domain),e.expires&&(this._expires=e.expires),this},setDefaultConf:function(){this._path=this._domain=this._expires=null}};g||(window.localCookieStorage=e.extend({},l,{_prefix:c,_expires:3650}),window.sessionCookieStorage=e.extend({},l,{_prefix:m+window.name+\"_\"})),window.cookieStorage=e.extend({},l),e.cookieStorage=e.extend({},h,{_type:\"cookieStorage\",setExpires:function(e){return window.cookieStorage.setExpires(e),this},setPath:function(e){return window.cookieStorage.setPath(e),this},setDomain:function(e){return window.cookieStorage.setDomain(e),this},setConf:function(e){return window.cookieStorage.setConf(e),this},setDefaultConf:function(){return window.cookieStorage.setDefaultConf(),this}})}e.initNamespaceStorage=function(e){return u(e)},g?(e.localStorage=e.extend({},h,{_type:\"localStorage\"}),e.sessionStorage=e.extend({},h,{_type:\"sessionStorage\"})):(e.localStorage=e.extend({},h,{_type:\"localCookieStorage\"}),e.sessionStorage=e.extend({},h,{_type:\"sessionCookieStorage\"})),e.namespaceStorages={},e.removeAllStorages=function(t){e.localStorage.removeAll(t),e.sessionStorage.removeAll(t),e.cookieStorage&&e.cookieStorage.removeAll(t),t||(e.namespaceStorages={})}});\n","jquery/jquery.validate.js":"/*!\n * jQuery Validation Plugin v1.19.5\n *\n * https://jqueryvalidation.org/\n *\n * Copyright (c) 2022 J\u00f6rn Zaefferer\n * Released under the MIT license\n */\n(function( factory ) {\n    if ( typeof define === \"function\" && define.amd ) {\n        define( [\"jquery\", \"jquery/jquery.metadata\"], factory );\n    } else if (typeof module === \"object\" && module.exports) {\n        module.exports = factory( require( \"jquery\" ) );\n    } else {\n        factory( jQuery );\n    }\n}(function( $ ) {\n\n    $.extend( $.fn, {\n\n        // https://jqueryvalidation.org/validate/\n        validate: function( options ) {\n\n            // If nothing is selected, return nothing; can't chain anyway\n            if ( !this.length ) {\n                if ( options && options.debug && window.console ) {\n                    console.warn( \"Nothing selected, can't validate, returning nothing.\" );\n                }\n                return;\n            }\n\n            // Check if a validator for this form was already created\n            var validator = $.data( this[ 0 ], \"validator\" );\n            if ( validator ) {\n                return validator;\n            }\n\n            // Add novalidate tag if HTML5.\n            this.attr( \"novalidate\", \"novalidate\" );\n\n            validator = new $.validator( options, this[ 0 ] );\n            $.data( this[ 0 ], \"validator\", validator );\n\n            if ( validator.settings.onsubmit ) {\n\n                this.on( \"click.validate\", \":submit\", function( event ) {\n\n                    // Track the used submit button to properly handle scripted\n                    // submits later.\n                    validator.submitButton = event.currentTarget;\n\n                    // Allow suppressing validation by adding a cancel class to the submit button\n                    if ( $( this ).hasClass( \"cancel\" ) ) {\n                        validator.cancelSubmit = true;\n                    }\n\n                    // Allow suppressing validation by adding the html5 formnovalidate attribute to the submit button\n                    if ( $( this ).attr( \"formnovalidate\" ) !== undefined ) {\n                        validator.cancelSubmit = true;\n                    }\n                } );\n\n                // Validate the form on submit\n                this.on( \"submit.validate\", function( event ) {\n                    if ( validator.settings.debug ) {\n\n                        // Prevent form submit to be able to see console output\n                        event.preventDefault();\n                    }\n\n                    function handle() {\n                        var hidden, result;\n\n                        // Insert a hidden input as a replacement for the missing submit button\n                        // The hidden input is inserted in two cases:\n                        //   - A user defined a `submitHandler`\n                        //   - There was a pending request due to `remote` method and `stopRequest()`\n                        //     was called to submit the form in case it's valid\n                        if ( validator.submitButton && ( validator.settings.submitHandler || validator.formSubmitted ) ) {\n                            hidden = $( \"<input type='hidden'/>\" )\n                                .attr( \"name\", validator.submitButton.name )\n                                .val( $( validator.submitButton ).val() )\n                                .appendTo( validator.currentForm );\n                        }\n\n                        if ( validator.settings.submitHandler && !validator.settings.debug ) {\n                            result = validator.settings.submitHandler.call( validator, validator.currentForm, event );\n                            if ( hidden ) {\n\n                                // And clean up afterwards; thanks to no-block-scope, hidden can be referenced\n                                hidden.remove();\n                            }\n                            if ( result !== undefined ) {\n                                return result;\n                            }\n                            return false;\n                        }\n                        return true;\n                    }\n\n                    // Prevent submit for invalid forms or custom submit handlers\n                    if ( validator.cancelSubmit ) {\n                        validator.cancelSubmit = false;\n                        return handle();\n                    }\n                    if ( validator.form() ) {\n                        if ( validator.pendingRequest ) {\n                            validator.formSubmitted = true;\n                            return false;\n                        }\n                        return handle();\n                    } else {\n                        validator.focusInvalid();\n                        return false;\n                    }\n                } );\n            }\n\n            return validator;\n        },\n\n        // https://jqueryvalidation.org/valid/\n        valid: function() {\n            var valid, validator, errorList;\n\n            if ( $( this[ 0 ] ).is( \"form\" ) ) {\n                valid = this.validate().form();\n            } else {\n                errorList = [];\n                valid = true;\n                validator = $( this[ 0 ].form ).validate();\n                this.each( function() {\n                    valid = validator.element( this ) && valid;\n                    if ( !valid ) {\n                        errorList = errorList.concat( validator.errorList );\n                    }\n                } );\n                validator.errorList = errorList;\n            }\n            return valid;\n        },\n\n        // https://jqueryvalidation.org/rules/\n        rules: function( command, argument ) {\n            var element = this[ 0 ],\n                isContentEditable = typeof this.attr( \"contenteditable\" ) !== \"undefined\" && this.attr( \"contenteditable\" ) !== \"false\",\n                settings, staticRules, existingRules, data, param, filtered;\n\n            // If nothing is selected, return empty object; can't chain anyway\n            if ( element == null ) {\n                return;\n            }\n\n            if ( !element.form && isContentEditable ) {\n                element.form = this.closest( \"form\" )[ 0 ];\n                element.name = this.attr( \"name\" );\n            }\n\n            if ( element.form == null ) {\n                return;\n            }\n\n            if ( command ) {\n                settings = $.data( element.form, \"validator\" ).settings;\n                staticRules = settings.rules;\n                existingRules = $.validator.staticRules( element );\n                switch ( command ) {\n                    case \"add\":\n                        $.extend( existingRules, $.validator.normalizeRule( argument ) );\n\n                        // Remove messages from rules, but allow them to be set separately\n                        delete existingRules.messages;\n                        staticRules[ element.name ] = existingRules;\n                        if ( argument.messages ) {\n                            settings.messages[ element.name ] = $.extend( settings.messages[ element.name ], argument.messages );\n                        }\n                        break;\n                    case \"remove\":\n                        if ( !argument ) {\n                            delete staticRules[ element.name ];\n                            return existingRules;\n                        }\n                        filtered = {};\n                        $.each( argument.split( /\\s/ ), function( index, method ) {\n                            filtered[ method ] = existingRules[ method ];\n                            delete existingRules[ method ];\n                        } );\n                        return filtered;\n                }\n            }\n\n            data = $.validator.normalizeRules(\n                $.extend(\n                    {},\n                    $.validator.metadataRules(element),\n                    $.validator.classRules( element ),\n                    $.validator.attributeRules( element ),\n                    $.validator.dataRules( element ),\n                    $.validator.staticRules( element )\n                ), element );\n\n            // Make sure required is at front\n            if ( data.required ) {\n                param = data.required;\n                delete data.required;\n                data = $.extend( { required: param }, data );\n            }\n\n            // Make sure remote is at back\n            if ( data.remote ) {\n                param = data.remote;\n                delete data.remote;\n                data = $.extend( data, { remote: param } );\n            }\n\n            return data;\n        }\n    } );\n\n// JQuery trim is deprecated, provide a trim method based on String.prototype.trim\n    var trim = function( str ) {\n\n        // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/trim#Polyfill\n        return str.replace( /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, \"\" );\n    };\n\n// Custom selectors\n    $.extend( $.expr.pseudos || $.expr[ \":\" ], {\t\t// '|| $.expr[ \":\" ]' here enables backwards compatibility to jQuery 1.7. Can be removed when dropping jQ 1.7.x support\n\n        // https://jqueryvalidation.org/blank-selector/\n        blank: function( a ) {\n            return !trim( \"\" + $( a ).val() );\n        },\n\n        // https://jqueryvalidation.org/filled-selector/\n        filled: function( a ) {\n            var val = $( a ).val();\n            return val !== null && !!trim( \"\" + val );\n        },\n\n        // https://jqueryvalidation.org/unchecked-selector/\n        unchecked: function( a ) {\n            return !$( a ).prop( \"checked\" );\n        }\n    } );\n\n// Constructor for validator\n    $.validator = function( options, form ) {\n        this.settings = $.extend( true, {}, $.validator.defaults, options );\n        this.currentForm = form;\n        this.init();\n    };\n\n// https://jqueryvalidation.org/jQuery.validator.format/\n    $.validator.format = function( source, params ) {\n        if ( arguments.length === 1 ) {\n            return function() {\n                var args = $.makeArray( arguments );\n                args.unshift( source );\n                return $.validator.format.apply( this, args );\n            };\n        }\n        if ( params === undefined ) {\n            return source;\n        }\n        if ( arguments.length > 2 && params.constructor !== Array  ) {\n            params = $.makeArray( arguments ).slice( 1 );\n        }\n        if ( params.constructor !== Array ) {\n            params = [ params ];\n        }\n        $.each( params, function( i, n ) {\n            source = source.replace( new RegExp( \"\\\\{\" + i + \"\\\\}\", \"g\" ), function() {\n                return n;\n            } );\n        } );\n        return source;\n    };\n\n    $.extend( $.validator, {\n\n        defaults: {\n            messages: {},\n            groups: {},\n            rules: {},\n            errorClass: \"error\",\n            pendingClass: \"pending\",\n            validClass: \"valid\",\n            errorElement: \"label\",\n            focusCleanup: false,\n            focusInvalid: true,\n            errorContainer: $( [] ),\n            errorLabelContainer: $( [] ),\n            onsubmit: true,\n            ignore: \":hidden\",\n            ignoreTitle: false,\n            onfocusin: function( element ) {\n                this.lastActive = element;\n\n                // Hide error label and remove error class on focus if enabled\n                if ( this.settings.focusCleanup ) {\n                    if ( this.settings.unhighlight ) {\n                        this.settings.unhighlight.call( this, element, this.settings.errorClass, this.settings.validClass );\n                    }\n                    this.hideThese( this.errorsFor( element ) );\n                }\n            },\n            onfocusout: function( element ) {\n                if ( !this.checkable( element ) && ( element.name in this.submitted || !this.optional( element ) ) ) {\n                    this.element( element );\n                }\n            },\n            onkeyup: function( element, event ) {\n\n                // Avoid revalidate the field when pressing one of the following keys\n                // Shift       => 16\n                // Ctrl        => 17\n                // Alt         => 18\n                // Caps lock   => 20\n                // End         => 35\n                // Home        => 36\n                // Left arrow  => 37\n                // Up arrow    => 38\n                // Right arrow => 39\n                // Down arrow  => 40\n                // Insert      => 45\n                // Num lock    => 144\n                // AltGr key   => 225\n                var excludedKeys = [\n                    16, 17, 18, 20, 35, 36, 37,\n                    38, 39, 40, 45, 144, 225\n                ];\n\n                if ( event.which === 9 && this.elementValue( element ) === \"\" || $.inArray( event.keyCode, excludedKeys ) !== -1 ) {\n                    return;\n                } else if ( element.name in this.submitted || element.name in this.invalid ) {\n                    this.element( element );\n                }\n            },\n            onclick: function( element ) {\n\n                // Click on selects, radiobuttons and checkboxes\n                if ( element.name in this.submitted ) {\n                    this.element( element );\n\n                    // Or option elements, check parent select in that case\n                } else if ( element.parentNode.name in this.submitted ) {\n                    this.element( element.parentNode );\n                }\n            },\n            highlight: function( element, errorClass, validClass ) {\n                if ( element.type === \"radio\" ) {\n                    this.findByName( element.name ).addClass( errorClass ).removeClass( validClass );\n                } else {\n                    $( element ).addClass( errorClass ).removeClass( validClass );\n                }\n            },\n            unhighlight: function( element, errorClass, validClass ) {\n                if ( element.type === \"radio\" ) {\n                    this.findByName( element.name ).removeClass( errorClass ).addClass( validClass );\n                } else {\n                    $( element ).removeClass( errorClass ).addClass( validClass );\n                }\n            }\n        },\n\n        // https://jqueryvalidation.org/jQuery.validator.setDefaults/\n        setDefaults: function( settings ) {\n            $.extend( $.validator.defaults, settings );\n        },\n\n        messages: {\n            required: \"This field is required.\",\n            remote: \"Please fix this field.\",\n            email: \"Please enter a valid email address.\",\n            url: \"Please enter a valid URL.\",\n            date: \"Please enter a valid date.\",\n            dateISO: \"Please enter a valid date (ISO).\",\n            number: \"Please enter a valid number.\",\n            digits: \"Please enter only digits.\",\n            equalTo: \"Please enter the same value again.\",\n            maxlength: $.validator.format( \"Please enter no more than {0} characters.\" ),\n            minlength: $.validator.format( \"Please enter at least {0} characters.\" ),\n            rangelength: $.validator.format( \"Please enter a value between {0} and {1} characters long.\" ),\n            range: $.validator.format( \"Please enter a value between {0} and {1}.\" ),\n            max: $.validator.format( \"Please enter a value less than or equal to {0}.\" ),\n            min: $.validator.format( \"Please enter a value greater than or equal to {0}.\" ),\n            step: $.validator.format( \"Please enter a multiple of {0}.\" )\n        },\n\n        autoCreateRanges: false,\n\n        prototype: {\n\n            init: function() {\n                this.labelContainer = $( this.settings.errorLabelContainer );\n                this.errorContext = this.labelContainer.length && this.labelContainer || $( this.currentForm );\n                this.containers = $( this.settings.errorContainer ).add( this.settings.errorLabelContainer );\n                this.submitted = {};\n                this.valueCache = {};\n                this.pendingRequest = 0;\n                this.pending = {};\n                this.invalid = {};\n                this.reset();\n\n                var currentForm = this.currentForm,\n                    groups = ( this.groups = {} ),\n                    rules;\n                $.each( this.settings.groups, function( key, value ) {\n                    if ( typeof value === \"string\" ) {\n                        value = value.split( /\\s/ );\n                    }\n                    $.each( value, function( index, name ) {\n                        groups[ name ] = key;\n                    } );\n                } );\n                rules = this.settings.rules;\n                $.each( rules, function( key, value ) {\n                    rules[ key ] = $.validator.normalizeRule( value );\n                } );\n\n                function delegate( event ) {\n                    var isContentEditable = typeof $( this ).attr( \"contenteditable\" ) !== \"undefined\" && $( this ).attr( \"contenteditable\" ) !== \"false\";\n\n                    // Set form expando on contenteditable\n                    if ( !this.form && isContentEditable ) {\n                        this.form = $( this ).closest( \"form\" )[ 0 ];\n                        this.name = $( this ).attr( \"name\" );\n                    }\n\n                    // Ignore the element if it belongs to another form. This will happen mainly\n                    // when setting the `form` attribute of an input to the id of another form.\n                    if ( currentForm !== this.form ) {\n                        return;\n                    }\n\n                    var validator = $.data( this.form, \"validator\" ),\n                        eventType = \"on\" + event.type.replace( /^validate/, \"\" ),\n                        settings = validator.settings;\n                    if ( settings[ eventType ] && !$( this ).is( settings.ignore ) ) {\n                        settings[ eventType ].call( validator, this, event );\n                    }\n                }\n\n                $( this.currentForm )\n                    .on( \"focusin.validate focusout.validate keyup.validate\",\n                        \":text, [type='password'], [type='file'], select, textarea, [type='number'], [type='search'], \" +\n                        \"[type='tel'], [type='url'], [type='email'], [type='datetime'], [type='date'], [type='month'], \" +\n                        \"[type='week'], [type='time'], [type='datetime-local'], [type='range'], [type='color'], \" +\n                        \"[type='radio'], [type='checkbox'], [contenteditable], [type='button']\", delegate )\n\n                    // Support: Chrome, oldIE\n                    // \"select\" is provided as event.target when clicking a option\n                    .on( \"click.validate\", \"select, option, [type='radio'], [type='checkbox']\", delegate );\n\n                if ( this.settings.invalidHandler ) {\n                    $( this.currentForm ).on( \"invalid-form.validate\", this.settings.invalidHandler );\n                }\n            },\n\n            // https://jqueryvalidation.org/Validator.form/\n            form: function() {\n                this.checkForm();\n                $.extend( this.submitted, this.errorMap );\n                this.invalid = $.extend( {}, this.errorMap );\n                if ( !this.valid() ) {\n                    $( this.currentForm ).triggerHandler( \"invalid-form\", [ this ] );\n                }\n                this.showErrors();\n                return this.valid();\n            },\n\n            checkForm: function() {\n                this.prepareForm();\n                for ( var i = 0, elements = ( this.currentElements = this.elements() ); elements[ i ]; i++ ) {\n                    this.check( elements[ i ] );\n                }\n                return this.valid();\n            },\n\n            // https://jqueryvalidation.org/Validator.element/\n            element: function( element ) {\n                var cleanElement = this.clean( element ),\n                    checkElement = this.validationTargetFor( cleanElement ),\n                    v = this,\n                    result = true,\n                    rs, group;\n\n                if ( checkElement === undefined ) {\n                    delete this.invalid[ cleanElement.name ];\n                } else {\n                    this.prepareElement( checkElement );\n                    this.currentElements = $( checkElement );\n\n                    // If this element is grouped, then validate all group elements already\n                    // containing a value\n                    group = this.groups[ checkElement.name ];\n                    if ( group ) {\n                        $.each( this.groups, function( name, testgroup ) {\n                            if ( testgroup === group && name !== checkElement.name ) {\n                                cleanElement = v.validationTargetFor( v.clean( v.findByName( name ) ) );\n                                if ( cleanElement && cleanElement.name in v.invalid ) {\n                                    v.currentElements.push( cleanElement );\n                                    result = v.check( cleanElement ) && result;\n                                }\n                            }\n                        } );\n                    }\n\n                    rs = this.check( checkElement ) !== false;\n                    result = result && rs;\n                    if ( rs ) {\n                        this.invalid[ checkElement.name ] = false;\n                    } else {\n                        this.invalid[ checkElement.name ] = true;\n                    }\n\n                    if ( !this.numberOfInvalids() ) {\n\n                        // Hide error containers on last error\n                        this.toHide = this.toHide.add( this.containers );\n                    }\n                    this.showErrors();\n\n                    // Add aria-invalid status for screen readers\n                    $( element ).attr( \"aria-invalid\", !rs );\n                }\n\n                return result;\n            },\n\n            // https://jqueryvalidation.org/Validator.showErrors/\n            showErrors: function( errors ) {\n                if ( errors ) {\n                    var validator = this;\n\n                    // Add items to error list and map\n                    $.extend( this.errorMap, errors );\n                    this.errorList = $.map( this.errorMap, function( message, name ) {\n                        return {\n                            message: message,\n                            element: validator.findByName( name )[ 0 ]\n                        };\n                    } );\n\n                    // Remove items from success list\n                    this.successList = $.grep( this.successList, function( element ) {\n                        return !( element.name in errors );\n                    } );\n                }\n                if ( this.settings.showErrors ) {\n                    this.settings.showErrors.call( this, this.errorMap, this.errorList );\n                } else {\n                    this.defaultShowErrors();\n                }\n            },\n\n            // https://jqueryvalidation.org/Validator.resetForm/\n            resetForm: function() {\n                if ( $.fn.resetForm ) {\n                    $( this.currentForm ).resetForm();\n                }\n                this.invalid = {};\n                this.submitted = {};\n                this.prepareForm();\n                this.hideErrors();\n                var elements = this.elements()\n                    .removeData( \"previousValue\" )\n                    .removeAttr( \"aria-invalid\" );\n\n                this.resetElements( elements );\n            },\n\n            resetElements: function( elements ) {\n                var i;\n\n                if ( this.settings.unhighlight ) {\n                    for ( i = 0; elements[ i ]; i++ ) {\n                        this.settings.unhighlight.call( this, elements[ i ],\n                            this.settings.errorClass, \"\" );\n                        this.findByName( elements[ i ].name ).removeClass( this.settings.validClass );\n                    }\n                } else {\n                    elements\n                        .removeClass( this.settings.errorClass )\n                        .removeClass( this.settings.validClass );\n                }\n            },\n\n            numberOfInvalids: function() {\n                return this.objectLength( this.invalid );\n            },\n\n            objectLength: function( obj ) {\n                /* jshint unused: false */\n                var count = 0,\n                    i;\n                for ( i in obj ) {\n\n                    // This check allows counting elements with empty error\n                    // message as invalid elements\n                    if ( obj[ i ] !== undefined && obj[ i ] !== null && obj[ i ] !== false ) {\n                        count++;\n                    }\n                }\n                return count;\n            },\n\n            hideErrors: function() {\n                this.hideThese( this.toHide );\n            },\n\n            hideThese: function( errors ) {\n                errors.not( this.containers ).text( \"\" );\n                this.addWrapper( errors ).hide();\n            },\n\n            valid: function() {\n                return this.size() === 0;\n            },\n\n            size: function() {\n                return this.errorList.length;\n            },\n\n            focusInvalid: function() {\n                if ( this.settings.focusInvalid ) {\n                    try {\n                        $( this.findLastActive() || this.errorList.length && this.errorList[ 0 ].element || [] )\n                            .filter( \":visible\" )\n                            .trigger( \"focus\" )\n\n                            // Manually trigger focusin event; without it, focusin handler isn't called, findLastActive won't have anything to find\n                            .trigger( \"focusin\" );\n                    } catch ( e ) {\n\n                        // Ignore IE throwing errors when focusing hidden elements\n                    }\n                }\n            },\n\n            findLastActive: function() {\n                var lastActive = this.lastActive;\n                return lastActive && $.grep( this.errorList, function( n ) {\n                    return n.element.name === lastActive.name;\n                } ).length === 1 && lastActive;\n            },\n\n            elements: function() {\n                var validator = this,\n                    rulesCache = {};\n\n                // Select all valid inputs inside the form (no submit or reset buttons)\n                return $( this.currentForm )\n                    .find( \"input, select, textarea, [contenteditable]\" )\n                    .not( \":submit, :reset, :image, :disabled\" )\n                    .not( this.settings.ignore )\n                    .filter( function() {\n                        var name = this.name || $( this ).attr( \"name\" ); // For contenteditable\n                        var isContentEditable = typeof $( this ).attr( \"contenteditable\" ) !== \"undefined\" && $( this ).attr( \"contenteditable\" ) !== \"false\";\n\n                        if ( !name && validator.settings.debug && window.console ) {\n                            console.error( \"%o has no name assigned\", this );\n                        }\n\n                        // Set form expando on contenteditable\n                        if ( isContentEditable ) {\n                            this.form = $( this ).closest( \"form\" )[ 0 ];\n                            this.name = name;\n                        }\n\n                        // Ignore elements that belong to other/nested forms\n                        if ( this.form !== validator.currentForm ) {\n                            return false;\n                        }\n\n                        // Select only the first element for each name, and only those with rules specified\n                        if ( name in rulesCache || !validator.objectLength( $( this ).rules() ) ) {\n                            return false;\n                        }\n\n                        rulesCache[ name ] = true;\n                        return true;\n                    } );\n            },\n\n            clean: function( selector ) {\n                return $( selector )[ 0 ];\n            },\n\n            errors: function() {\n                var errorClass = this.settings.errorClass.split( \" \" ).join( \".\" );\n                return $( this.settings.errorElement + \".\" + errorClass, this.errorContext );\n            },\n\n            resetInternals: function() {\n                this.successList = [];\n                this.errorList = [];\n                this.errorMap = {};\n                this.toShow = $( [] );\n                this.toHide = $( [] );\n            },\n\n            reset: function() {\n                this.resetInternals();\n                this.currentElements = $( [] );\n            },\n\n            prepareForm: function() {\n                this.reset();\n                this.toHide = this.errors().add( this.containers );\n            },\n\n            prepareElement: function( element ) {\n                this.reset();\n                this.toHide = this.errorsFor( element );\n            },\n\n            elementValue: function( element ) {\n                var $element = $( element ),\n                    type = element.type,\n                    isContentEditable = typeof $element.attr( \"contenteditable\" ) !== \"undefined\" && $element.attr( \"contenteditable\" ) !== \"false\",\n                    val, idx;\n\n                if ( type === \"radio\" || type === \"checkbox\" ) {\n                    return this.findByName( element.name ).filter( \":checked\" ).val();\n                } else if ( type === \"number\" && typeof element.validity !== \"undefined\" ) {\n                    return element.validity.badInput ? \"NaN\" : $element.val();\n                }\n\n                if ( isContentEditable ) {\n                    val = $element.text();\n                } else {\n                    val = $element.val();\n                }\n\n                if ( type === \"file\" ) {\n\n                    // Modern browser (chrome & safari)\n                    if ( val.substr( 0, 12 ) === \"C:\\\\fakepath\\\\\" ) {\n                        return val.substr( 12 );\n                    }\n\n                    // Legacy browsers\n                    // Unix-based path\n                    idx = val.lastIndexOf( \"/\" );\n                    if ( idx >= 0 ) {\n                        return val.substr( idx + 1 );\n                    }\n\n                    // Windows-based path\n                    idx = val.lastIndexOf( \"\\\\\" );\n                    if ( idx >= 0 ) {\n                        return val.substr( idx + 1 );\n                    }\n\n                    // Just the file name\n                    return val;\n                }\n\n                if ( typeof val === \"string\" ) {\n                    return val.replace( /\\r/g, \"\" );\n                }\n                return val;\n            },\n\n            check: function( element ) {\n                element = this.validationTargetFor( this.clean( element ) );\n\n                var rules = $( element ).rules(),\n                    rulesCount = $.map( rules, function( n, i ) {\n                        return i;\n                    } ).length,\n                    dependencyMismatch = false,\n                    val = this.elementValue( element ),\n                    result, method, rule, normalizer;\n\n                // Prioritize the local normalizer defined for this element over the global one\n                // if the former exists, otherwise user the global one in case it exists.\n                if ( typeof rules.normalizer === \"function\" ) {\n                    normalizer = rules.normalizer;\n                } else if (\ttypeof this.settings.normalizer === \"function\" ) {\n                    normalizer = this.settings.normalizer;\n                }\n\n                // If normalizer is defined, then call it to the changed value instead\n                // of using the real one.\n                // Note that `this` in the normalizer is `element`.\n                if ( normalizer ) {\n                    val = normalizer.call( element, val );\n\n                    // Delete the normalizer from rules to avoid treating it as a pre-defined method.\n                    delete rules.normalizer;\n                }\n\n                for ( method in rules ) {\n                    rule = { method: method, parameters: rules[ method ] };\n                    try {\n                        result = $.validator.methods[ method ].call( this, val, element, rule.parameters );\n\n                        // If a method indicates that the field is optional and therefore valid,\n                        // don't mark it as valid when there are no other rules\n                        if ( result === \"dependency-mismatch\" && rulesCount === 1 ) {\n                            dependencyMismatch = true;\n                            continue;\n                        }\n                        dependencyMismatch = false;\n\n                        if ( result === \"pending\" ) {\n                            this.toHide = this.toHide.not( this.errorsFor( element ) );\n                            return;\n                        }\n\n                        if ( !result ) {\n                            this.formatAndAdd( element, rule );\n                            return false;\n                        }\n                    } catch ( e ) {\n                        if ( this.settings.debug && window.console ) {\n                            console.log( \"Exception occurred when checking element \" + element.id + \", check the '\" + rule.method + \"' method.\", e );\n                        }\n                        if ( e instanceof TypeError ) {\n                            e.message += \".  Exception occurred when checking element \" + element.id + \", check the '\" + rule.method + \"' method.\";\n                        }\n\n                        throw e;\n                    }\n                }\n                if ( dependencyMismatch ) {\n                    return;\n                }\n                if ( this.objectLength( rules ) ) {\n                    this.successList.push( element );\n                }\n                return true;\n            },\n\n            // Return the custom message for the given element and validation method\n            // specified in the element's HTML5 data attribute\n            // return the generic message if present and no method specific message is present\n            customDataMessage: function( element, method ) {\n                return $( element ).data( \"msg\" + method.charAt( 0 ).toUpperCase() +\n                    method.substring( 1 ).toLowerCase() ) || $( element ).data( \"msg\" );\n            },\n\n            // Return the custom message for the given element name and validation method\n            customMessage: function( name, method ) {\n                var m = this.settings.messages[ name ];\n                return m && ( m.constructor === String ? m : m[ method ] );\n            },\n\n            // Return the first defined argument, allowing empty strings\n            findDefined: function() {\n                for ( var i = 0; i < arguments.length; i++ ) {\n                    if ( arguments[ i ] !== undefined ) {\n                        return arguments[ i ];\n                    }\n                }\n                return undefined;\n            },\n\n            // The second parameter 'rule' used to be a string, and extended to an object literal\n            // of the following form:\n            // rule = {\n            //     method: \"method name\",\n            //     parameters: \"the given method parameters\"\n            // }\n            //\n            // The old behavior still supported, kept to maintain backward compatibility with\n            // old code, and will be removed in the next major release.\n            defaultMessage: function( element, rule ) {\n                if ( typeof rule === \"string\" ) {\n                    rule = { method: rule };\n                }\n\n                var message = this.findDefined(\n                        this.customMessage( element.name, rule.method ),\n                        this.customDataMessage( element, rule.method ),\n\n                        // 'title' is never undefined, so handle empty string as undefined\n                        !this.settings.ignoreTitle && element.title || undefined,\n                        $.validator.messages[ rule.method ],\n                        \"<strong>Warning: No message defined for \" + element.name + \"</strong>\"\n                    ),\n                    theregex = /\\$?\\{(\\d+)\\}/g;\n                if ( typeof message === \"function\" ) {\n                    message = message.call( this, rule.parameters, element );\n                } else if ( theregex.test( message ) ) {\n                    message = $.validator.format( message.replace( theregex, \"{$1}\" ), rule.parameters );\n                }\n\n                return message;\n            },\n\n            formatAndAdd: function( element, rule ) {\n                var message = this.defaultMessage( element, rule );\n\n                this.errorList.push( {\n                    message: message,\n                    element: element,\n                    method: rule.method\n                } );\n\n                this.errorMap[ element.name ] = message;\n                this.submitted[ element.name ] = message;\n            },\n\n            addWrapper: function( toToggle ) {\n                if ( this.settings.wrapper ) {\n                    toToggle = toToggle.add( toToggle.parent( this.settings.wrapper ) );\n                }\n                return toToggle;\n            },\n\n            defaultShowErrors: function() {\n                var i, elements, error;\n                for ( i = 0; this.errorList[ i ]; i++ ) {\n                    error = this.errorList[ i ];\n                    if ( this.settings.highlight ) {\n                        this.settings.highlight.call( this, error.element, this.settings.errorClass, this.settings.validClass );\n                    }\n                    this.showLabel( error.element, error.message );\n                }\n                if ( this.errorList.length ) {\n                    this.toShow = this.toShow.add( this.containers );\n                }\n                if ( this.settings.success ) {\n                    for ( i = 0; this.successList[ i ]; i++ ) {\n                        this.showLabel( this.successList[ i ] );\n                    }\n                }\n                if ( this.settings.unhighlight ) {\n                    for ( i = 0, elements = this.validElements(); elements[ i ]; i++ ) {\n                        this.settings.unhighlight.call( this, elements[ i ], this.settings.errorClass, this.settings.validClass );\n                    }\n                }\n                this.toHide = this.toHide.not( this.toShow );\n                this.hideErrors();\n                this.addWrapper( this.toShow ).show();\n            },\n\n            validElements: function() {\n                return this.currentElements.not( this.invalidElements() );\n            },\n\n            invalidElements: function() {\n                return $( this.errorList ).map( function() {\n                    return this.element;\n                } );\n            },\n\n            showLabel: function( element, message ) {\n                var place, group, errorID, v,\n                    error = this.errorsFor( element ),\n                    elementID = this.idOrName( element ),\n                    describedBy = $( element ).attr( \"aria-describedby\" );\n\n                if ( error.length ) {\n\n                    // Refresh error/success class\n                    error.removeClass( this.settings.validClass ).addClass( this.settings.errorClass );\n\n                    // Replace message on existing label\n                    error.html( message );\n                } else {\n\n                    // Create error element\n                    error = $( \"<\" + this.settings.errorElement + \">\" )\n                        .attr( \"id\", elementID + \"-error\" )\n                        .addClass( this.settings.errorClass )\n                        .html( message || \"\" );\n\n                    // Maintain reference to the element to be placed into the DOM\n                    place = error;\n                    if ( this.settings.wrapper ) {\n\n                        // Make sure the element is visible, even in IE\n                        // actually showing the wrapped element is handled elsewhere\n                        place = error.hide().show().wrap( \"<\" + this.settings.wrapper + \"/>\" ).parent();\n                    }\n                    if ( this.labelContainer.length ) {\n                        this.labelContainer.append( place );\n                    } else if ( this.settings.errorPlacement ) {\n                        this.settings.errorPlacement.call( this, place, $( element ) );\n                    } else {\n                        place.insertAfter( element );\n                    }\n\n                    // Link error back to the element\n                    if ( error.is( \"label\" ) ) {\n\n                        // If the error is a label, then associate using 'for'\n                        error.attr( \"for\", elementID );\n\n                        // If the element is not a child of an associated label, then it's necessary\n                        // to explicitly apply aria-describedby\n                    } else if ( error.parents( \"label[for='\" + this.escapeCssMeta( elementID ) + \"']\" ).length === 0 ) {\n                        errorID = error.attr( \"id\" );\n\n                        // Respect existing non-error aria-describedby\n                        if ( !describedBy ) {\n                            describedBy = errorID;\n                        } else if ( !describedBy.match( new RegExp( \"\\\\b\" + this.escapeCssMeta( errorID ) + \"\\\\b\" ) ) ) {\n\n                            // Add to end of list if not already present\n                            describedBy += \" \" + errorID;\n                        }\n                        $( element ).attr( \"aria-describedby\", describedBy );\n\n                        // If this element is grouped, then assign to all elements in the same group\n                        group = this.groups[ element.name ];\n                        if ( group ) {\n                            v = this;\n                            $.each( v.groups, function( name, testgroup ) {\n                                if ( testgroup === group ) {\n                                    $( \"[name='\" + v.escapeCssMeta( name ) + \"']\", v.currentForm )\n                                        .attr( \"aria-describedby\", error.attr( \"id\" ) );\n                                }\n                            } );\n                        }\n                    }\n                }\n                if ( !message && this.settings.success ) {\n                    error.text( \"\" );\n                    if ( typeof this.settings.success === \"string\" ) {\n                        error.addClass( this.settings.success );\n                    } else {\n                        this.settings.success( error, element );\n                    }\n                }\n                this.toShow = this.toShow.add( error );\n            },\n\n            errorsFor: function( element ) {\n                var name = this.escapeCssMeta( this.idOrName( element ) ),\n                    describer = $( element ).attr( \"aria-describedby\" ),\n                    selector = \"label[for='\" + name + \"'], label[for='\" + name + \"'] *\";\n\n                // 'aria-describedby' should directly reference the error element\n                if ( describer ) {\n                    selector = selector + \", #\" + this.escapeCssMeta( describer )\n                        .replace( /\\s+/g, \", #\" ) + \":visible\";\n                }\n\n                return this\n                    .errors()\n                    .filter( selector );\n            },\n\n            // See https://api.jquery.com/category/selectors/, for CSS\n            // meta-characters that should be escaped in order to be used with JQuery\n            // as a literal part of a name/id or any selector.\n            escapeCssMeta: function( string ) {\n                if ( string === undefined ) {\n                    return \"\";\n                }\n\n                return string.replace( /([\\\\!\"#$%&'()*+,./:;<=>?@\\[\\]^`{|}~])/g, \"\\\\$1\" );\n            },\n\n            idOrName: function( element ) {\n                return this.groups[ element.name ] || ( this.checkable( element ) ? element.name : element.id || element.name );\n            },\n\n            validationTargetFor: function( element ) {\n\n                // If radio/checkbox, validate first element in group instead\n                if ( this.checkable( element ) ) {\n                    element = this.findByName( element.name );\n                }\n\n                // Always apply ignore filter\n                return $( element ).not( this.settings.ignore )[ 0 ];\n            },\n\n            checkable: function( element ) {\n                return ( /radio|checkbox/i ).test( element.type );\n            },\n\n            findByName: function( name ) {\n                return $( this.currentForm ).find( \"[name='\" + this.escapeCssMeta( name ) + \"']\" );\n            },\n\n            getLength: function( value, element ) {\n                switch ( element.nodeName.toLowerCase() ) {\n                    case \"select\":\n                        return $( \"option:selected\", element ).length;\n                    case \"input\":\n                        if ( this.checkable( element ) ) {\n                            return this.findByName( element.name ).filter( \":checked\" ).length;\n                        }\n                }\n                return value.length;\n            },\n\n            depend: function( param, element ) {\n                return this.dependTypes[ typeof param ] ? this.dependTypes[ typeof param ]( param, element ) : true;\n            },\n\n            dependTypes: {\n                \"boolean\": function( param ) {\n                    return param;\n                },\n                \"string\": function( param, element ) {\n                    return !!$( param, element.form ).length;\n                },\n                \"function\": function( param, element ) {\n                    return param( element );\n                }\n            },\n\n            optional: function( element ) {\n                var val = this.elementValue( element );\n                return !$.validator.methods.required.call( this, val, element ) && \"dependency-mismatch\";\n            },\n\n            startRequest: function( element ) {\n                if ( !this.pending[ element.name ] ) {\n                    this.pendingRequest++;\n                    $( element ).addClass( this.settings.pendingClass );\n                    this.pending[ element.name ] = true;\n                }\n            },\n\n            stopRequest: function( element, valid ) {\n                this.pendingRequest--;\n\n                // Sometimes synchronization fails, make sure pendingRequest is never < 0\n                if ( this.pendingRequest < 0 ) {\n                    this.pendingRequest = 0;\n                }\n                delete this.pending[ element.name ];\n                $( element ).removeClass( this.settings.pendingClass );\n                if ( valid && this.pendingRequest === 0 && this.formSubmitted && this.form() && this.pendingRequest === 0 ) {\n                    $( this.currentForm ).trigger( \"submit\" );\n\n                    // Remove the hidden input that was used as a replacement for the\n                    // missing submit button. The hidden input is added by `handle()`\n                    // to ensure that the value of the used submit button is passed on\n                    // for scripted submits triggered by this method\n                    if ( this.submitButton ) {\n                        $( \"input:hidden[name='\" + this.submitButton.name + \"']\", this.currentForm ).remove();\n                    }\n\n                    this.formSubmitted = false;\n                } else if ( !valid && this.pendingRequest === 0 && this.formSubmitted ) {\n                    $( this.currentForm ).triggerHandler( \"invalid-form\", [ this ] );\n                    this.formSubmitted = false;\n                }\n            },\n\n            previousValue: function( element, method ) {\n                method = typeof method === \"string\" && method || \"remote\";\n\n                return $.data( element, \"previousValue\" ) || $.data( element, \"previousValue\", {\n                    old: null,\n                    valid: true,\n                    message: this.defaultMessage( element, { method: method } )\n                } );\n            },\n\n            // Cleans up all forms and elements, removes validator-specific events\n            destroy: function() {\n                this.resetForm();\n\n                $( this.currentForm )\n                    .off( \".validate\" )\n                    .removeData( \"validator\" )\n                    .find( \".validate-equalTo-blur\" )\n                    .off( \".validate-equalTo\" )\n                    .removeClass( \"validate-equalTo-blur\" )\n                    .find( \".validate-lessThan-blur\" )\n                    .off( \".validate-lessThan\" )\n                    .removeClass( \"validate-lessThan-blur\" )\n                    .find( \".validate-lessThanEqual-blur\" )\n                    .off( \".validate-lessThanEqual\" )\n                    .removeClass( \"validate-lessThanEqual-blur\" )\n                    .find( \".validate-greaterThanEqual-blur\" )\n                    .off( \".validate-greaterThanEqual\" )\n                    .removeClass( \"validate-greaterThanEqual-blur\" )\n                    .find( \".validate-greaterThan-blur\" )\n                    .off( \".validate-greaterThan\" )\n                    .removeClass( \"validate-greaterThan-blur\" );\n            }\n\n        },\n\n        classRuleSettings: {\n            required: { required: true },\n            email: { email: true },\n            url: { url: true },\n            date: { date: true },\n            dateISO: { dateISO: true },\n            number: { number: true },\n            digits: { digits: true },\n            creditcard: { creditcard: true }\n        },\n\n        addClassRules: function( className, rules ) {\n            if ( className.constructor === String ) {\n                this.classRuleSettings[ className ] = rules;\n            } else {\n                $.extend( this.classRuleSettings, className );\n            }\n        },\n\n        classRules: function( element ) {\n            var rules = {},\n                classes = $( element ).attr( \"class\" );\n\n            if ( classes ) {\n                $.each( classes.split( \" \" ), function() {\n                    if ( this in $.validator.classRuleSettings ) {\n                        $.extend( rules, $.validator.classRuleSettings[ this ] );\n                    }\n                } );\n            }\n            return rules;\n        },\n\n        normalizeAttributeRule: function( rules, type, method, value ) {\n\n            // Convert the value to a number for number inputs, and for text for backwards compability\n            // allows type=\"date\" and others to be compared as strings\n            if ( /min|max|step/.test( method ) && ( type === null || /number|range|text/.test( type ) ) ) {\n                value = Number( value );\n\n                // Support Opera Mini, which returns NaN for undefined minlength\n                if ( isNaN( value ) ) {\n                    value = undefined;\n                }\n            }\n\n            if ( value || value === 0 ) {\n                rules[ method ] = value;\n            } else if ( type === method && type !== \"range\" ) {\n\n                // Exception: the jquery validate 'range' method\n                // does not test for the html5 'range' type\n                rules[ type === \"date\" ? \"dateISO\" : method ] = true;\n            }\n        },\n\n        attributeRules: function( element ) {\n            var rules = {},\n                $element = $( element ),\n                type = element.getAttribute( \"type\" ),\n                method, value;\n\n            for ( method in $.validator.methods ) {\n\n                // Support for <input required> in both html5 and older browsers\n                if ( method === \"required\" ) {\n                    value = element.getAttribute( method );\n\n                    // Some browsers return an empty string for the required attribute\n                    // and non-HTML5 browsers might have required=\"\" markup\n                    if ( value === \"\" ) {\n                        value = true;\n                    }\n\n                    // Force non-HTML5 browsers to return bool\n                    value = !!value;\n                } else {\n                    value = $element.attr( method );\n                }\n\n                this.normalizeAttributeRule( rules, type, method, value );\n            }\n\n            // 'maxlength' may be returned as -1, 2147483647 ( IE ) and 524288 ( safari ) for text inputs\n            if ( rules.maxlength && /-1|2147483647|524288/.test( rules.maxlength ) ) {\n                delete rules.maxlength;\n            }\n\n            return rules;\n        },\n\n        metadataRules: function (element) {\n            if (!$.metadata) {\n                return {};\n            }\n\n            var meta = $.data(element.form, 'validator').settings.meta;\n            return meta ?\n                $(element).metadata()[meta] :\n                $(element).metadata();\n        },\n        \n        dataRules: function( element ) {\n            var rules = {},\n                $element = $( element ),\n                type = element.getAttribute( \"type\" ),\n                method, value;\n\n            for ( method in $.validator.methods ) {\n                value = $element.data( \"rule\" + method.charAt( 0 ).toUpperCase() + method.substring( 1 ).toLowerCase() );\n\n                // Cast empty attributes like `data-rule-required` to `true`\n                if ( value === \"\" ) {\n                    value = true;\n                }\n\n                this.normalizeAttributeRule( rules, type, method, value );\n            }\n            return rules;\n        },\n\n        staticRules: function( element ) {\n            var rules = {},\n                validator = $.data( element.form, \"validator\" );\n\n            if ( validator.settings.rules ) {\n                rules = $.validator.normalizeRule( validator.settings.rules[ element.name ] ) || {};\n            }\n            return rules;\n        },\n\n        normalizeRules: function( rules, element ) {\n\n            // Handle dependency check\n            $.each( rules, function( prop, val ) {\n\n                // Ignore rule when param is explicitly false, eg. required:false\n                if ( val === false ) {\n                    delete rules[ prop ];\n                    return;\n                }\n                if ( val.param || val.depends ) {\n                    var keepRule = true;\n                    switch ( typeof val.depends ) {\n                        case \"string\":\n                            keepRule = !!$( val.depends, element.form ).length;\n                            break;\n                        case \"function\":\n                            keepRule = val.depends.call( element, element );\n                            break;\n                    }\n                    if ( keepRule ) {\n                        rules[ prop ] = val.param !== undefined ? val.param : true;\n                    } else {\n                        $.data( element.form, \"validator\" ).resetElements( $( element ) );\n                        delete rules[ prop ];\n                    }\n                }\n            } );\n\n            // Evaluate parameters\n            $.each( rules, function( rule, parameter ) {\n                rules[ rule ] = typeof parameter === \"function\" && rule !== \"normalizer\" ? parameter( element ) : parameter;\n            } );\n\n            // Clean number parameters\n            $.each( [ \"minlength\", \"maxlength\" ], function() {\n                if ( rules[ this ] ) {\n                    rules[ this ] = Number( rules[ this ] );\n                }\n            } );\n            $.each( [ \"rangelength\", \"range\" ], function() {\n                var parts;\n                if ( rules[ this ] ) {\n                    if ( Array.isArray( rules[ this ] ) ) {\n                        rules[ this ] = [ Number( rules[ this ][ 0 ] ), Number( rules[ this ][ 1 ] ) ];\n                    } else if ( typeof rules[ this ] === \"string\" ) {\n                        parts = rules[ this ].replace( /[\\[\\]]/g, \"\" ).split( /[\\s,]+/ );\n                        rules[ this ] = [ Number( parts[ 0 ] ), Number( parts[ 1 ] ) ];\n                    }\n                }\n            } );\n\n            if ( $.validator.autoCreateRanges ) {\n\n                // Auto-create ranges\n                if ( rules.min != null && rules.max != null ) {\n                    rules.range = [ rules.min, rules.max ];\n                    delete rules.min;\n                    delete rules.max;\n                }\n                if ( rules.minlength != null && rules.maxlength != null ) {\n                    rules.rangelength = [ rules.minlength, rules.maxlength ];\n                    delete rules.minlength;\n                    delete rules.maxlength;\n                }\n            }\n\n            return rules;\n        },\n\n        // Converts a simple string to a {string: true} rule, e.g., \"required\" to {required:true}\n        normalizeRule: function( data ) {\n            if ( typeof data === \"string\" ) {\n                var transformed = {};\n                $.each( data.split( /\\s/ ), function() {\n                    transformed[ this ] = true;\n                } );\n                data = transformed;\n            }\n            return data;\n        },\n\n        // https://jqueryvalidation.org/jQuery.validator.addMethod/\n        addMethod: function( name, method, message ) {\n            $.validator.methods[ name ] = method;\n            $.validator.messages[ name ] = message !== undefined ? message : $.validator.messages[ name ];\n            if ( method.length < 3 ) {\n                $.validator.addClassRules( name, $.validator.normalizeRule( name ) );\n            }\n        },\n\n        // https://jqueryvalidation.org/jQuery.validator.methods/\n        methods: {\n\n            // https://jqueryvalidation.org/required-method/\n            required: function( value, element, param ) {\n\n                // Check if dependency is met\n                if ( !this.depend( param, element ) ) {\n                    return \"dependency-mismatch\";\n                }\n                if ( element.nodeName.toLowerCase() === \"select\" ) {\n\n                    // Could be an array for select-multiple or a string, both are fine this way\n                    var val = $( element ).val();\n                    return val && val.length > 0;\n                }\n                if ( this.checkable( element ) ) {\n                    return this.getLength( value, element ) > 0;\n                }\n                return value !== undefined && value !== null && value.length > 0;\n            },\n\n            // https://jqueryvalidation.org/email-method/\n            email: function( value, element ) {\n\n                // From https://html.spec.whatwg.org/multipage/forms.html#valid-e-mail-address\n                // Retrieved 2014-01-14\n                // If you have a problem with this implementation, report a bug against the above spec\n                // Or use custom methods to implement your own email validation\n                return this.optional( element ) || /^[a-zA-Z0-9.!#$%&'*+\\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/url-method/\n            url: function( value, element ) {\n\n                // Copyright (c) 2010-2013 Diego Perini, MIT licensed\n                // https://gist.github.com/dperini/729294\n                // see also https://mathiasbynens.be/demo/url-regex\n                // modified to allow protocol-relative URLs\n                return this.optional( element ) || /^(?:(?:(?:https?|ftp):)?\\/\\/)(?:(?:[^\\]\\[?\\/<~#`!@$^&*()+=}|:\";',>{ ]|%[0-9A-Fa-f]{2})+(?::(?:[^\\]\\[?\\/<~#`!@$^&*()+=}|:\";',>{ ]|%[0-9A-Fa-f]{2})*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z0-9\\u00a1-\\uffff][a-z0-9\\u00a1-\\uffff_-]{0,62})?[a-z0-9\\u00a1-\\uffff]\\.)+(?:[a-z\\u00a1-\\uffff]{2,}\\.?))(?::\\d{2,5})?(?:[/?#]\\S*)?$/i.test( value );\n            },\n\n            // https://jqueryvalidation.org/date-method/\n            date: ( function() {\n                var called = false;\n\n                return function( value, element ) {\n                    if ( !called ) {\n                        called = true;\n                        if ( this.settings.debug && window.console ) {\n                            console.warn(\n                                \"The `date` method is deprecated and will be removed in version '2.0.0'.\\n\" +\n                                \"Please don't use it, since it relies on the Date constructor, which\\n\" +\n                                \"behaves very differently across browsers and locales. Use `dateISO`\\n\" +\n                                \"instead or one of the locale specific methods in `localizations/`\\n\" +\n                                \"and `additional-methods.js`.\"\n                            );\n                        }\n                    }\n\n                    return this.optional( element ) || !/Invalid|NaN/.test( new Date( value ).toString() );\n                };\n            }() ),\n\n            // https://jqueryvalidation.org/dateISO-method/\n            dateISO: function( value, element ) {\n                return this.optional( element ) || /^\\d{4}[\\/\\-](0?[1-9]|1[012])[\\/\\-](0?[1-9]|[12][0-9]|3[01])$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/number-method/\n            number: function( value, element ) {\n                return this.optional( element ) || /^(?:-?\\d+|-?\\d{1,3}(?:,\\d{3})+)?(?:\\.\\d+)?$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/digits-method/\n            digits: function( value, element ) {\n                return this.optional( element ) || /^\\d+$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/minlength-method/\n            minlength: function( value, element, param ) {\n                var length = Array.isArray( value ) ? value.length : this.getLength( value, element );\n                return this.optional( element ) || length >= param;\n            },\n\n            // https://jqueryvalidation.org/maxlength-method/\n            maxlength: function( value, element, param ) {\n                var length = Array.isArray( value ) ? value.length : this.getLength( value, element );\n                return this.optional( element ) || length <= param;\n            },\n\n            // https://jqueryvalidation.org/rangelength-method/\n            rangelength: function( value, element, param ) {\n                var length = Array.isArray( value ) ? value.length : this.getLength( value, element );\n                return this.optional( element ) || ( length >= param[ 0 ] && length <= param[ 1 ] );\n            },\n\n            // https://jqueryvalidation.org/min-method/\n            min: function( value, element, param ) {\n                return this.optional( element ) || value >= param;\n            },\n\n            // https://jqueryvalidation.org/max-method/\n            max: function( value, element, param ) {\n                return this.optional( element ) || value <= param;\n            },\n\n            // https://jqueryvalidation.org/range-method/\n            range: function( value, element, param ) {\n                return this.optional( element ) || ( value >= param[ 0 ] && value <= param[ 1 ] );\n            },\n\n            // https://jqueryvalidation.org/step-method/\n            step: function( value, element, param ) {\n                var type = $( element ).attr( \"type\" ),\n                    errorMessage = \"Step attribute on input type \" + type + \" is not supported.\",\n                    supportedTypes = [ \"text\", \"number\", \"range\" ],\n                    re = new RegExp( \"\\\\b\" + type + \"\\\\b\" ),\n                    notSupported = type && !re.test( supportedTypes.join() ),\n                    decimalPlaces = function( num ) {\n                        var match = ( \"\" + num ).match( /(?:\\.(\\d+))?$/ );\n                        if ( !match ) {\n                            return 0;\n                        }\n\n                        // Number of digits right of decimal point.\n                        return match[ 1 ] ? match[ 1 ].length : 0;\n                    },\n                    toInt = function( num ) {\n                        return Math.round( num * Math.pow( 10, decimals ) );\n                    },\n                    valid = true,\n                    decimals;\n\n                // Works only for text, number and range input types\n                // TODO find a way to support input types date, datetime, datetime-local, month, time and week\n                if ( notSupported ) {\n                    throw new Error( errorMessage );\n                }\n\n                decimals = decimalPlaces( param );\n\n                // Value can't have too many decimals\n                if ( decimalPlaces( value ) > decimals || toInt( value ) % toInt( param ) !== 0 ) {\n                    valid = false;\n                }\n\n                return this.optional( element ) || valid;\n            },\n\n            // https://jqueryvalidation.org/equalTo-method/\n            equalTo: function( value, element, param ) {\n\n                // Bind to the blur event of the target in order to revalidate whenever the target field is updated\n                var target = $( param );\n                if ( this.settings.onfocusout && target.not( \".validate-equalTo-blur\" ).length ) {\n                    target.addClass( \"validate-equalTo-blur\" ).on( \"blur.validate-equalTo\", function() {\n                        $( element ).valid();\n                    } );\n                }\n                return value === target.val();\n            },\n\n            // https://jqueryvalidation.org/remote-method/\n            remote: function( value, element, param, method ) {\n                if ( this.optional( element ) ) {\n                    return \"dependency-mismatch\";\n                }\n\n                method = typeof method === \"string\" && method || \"remote\";\n\n                var previous = this.previousValue( element, method ),\n                    validator, data, optionDataString;\n\n                if ( !this.settings.messages[ element.name ] ) {\n                    this.settings.messages[ element.name ] = {};\n                }\n                previous.originalMessage = previous.originalMessage || this.settings.messages[ element.name ][ method ];\n                this.settings.messages[ element.name ][ method ] = previous.message;\n\n                param = typeof param === \"string\" && { url: param } || param;\n                optionDataString = $.param( $.extend( { data: value }, param.data ) );\n                if ( previous.old === optionDataString ) {\n                    return previous.valid;\n                }\n\n                previous.old = optionDataString;\n                validator = this;\n                this.startRequest( element );\n                data = {};\n                data[ element.name ] = value;\n                $.ajax( $.extend( true, {\n                    mode: \"abort\",\n                    port: \"validate\" + element.name,\n                    dataType: \"json\",\n                    data: data,\n                    context: validator.currentForm,\n                    success: function( response ) {\n                        var valid = response === true || response === \"true\",\n                            errors, message, submitted;\n\n                        validator.settings.messages[ element.name ][ method ] = previous.originalMessage;\n                        if ( valid ) {\n                            submitted = validator.formSubmitted;\n                            validator.resetInternals();\n                            validator.toHide = validator.errorsFor( element );\n                            validator.formSubmitted = submitted;\n                            validator.successList.push( element );\n                            validator.invalid[ element.name ] = false;\n                            validator.showErrors();\n                        } else {\n                            errors = {};\n                            message = response || validator.defaultMessage( element, { method: method, parameters: value } );\n                            errors[ element.name ] = previous.message = message;\n                            validator.invalid[ element.name ] = true;\n                            validator.showErrors( errors );\n                        }\n                        previous.valid = valid;\n                        validator.stopRequest( element, valid );\n                    }\n                }, param ) );\n                return \"pending\";\n            }\n        }\n\n    } );\n\n// Ajax mode: abort\n// usage: $.ajax({ mode: \"abort\"[, port: \"uniqueport\"]});\n// if mode:\"abort\" is used, the previous request on that port (port can be undefined) is aborted via XMLHttpRequest.abort()\n\n    var pendingRequests = {},\n        ajax;\n\n// Use a prefilter if available (1.5+)\n    if ( $.ajaxPrefilter ) {\n        $.ajaxPrefilter( function( settings, _, xhr ) {\n            var port = settings.port;\n            if ( settings.mode === \"abort\" ) {\n                if ( pendingRequests[ port ] ) {\n                    pendingRequests[ port ].abort();\n                }\n                pendingRequests[ port ] = xhr;\n            }\n        } );\n    } else {\n\n        // Proxy ajax\n        ajax = $.ajax;\n        $.ajax = function( settings ) {\n            var mode = ( \"mode\" in settings ? settings : $.ajaxSettings ).mode,\n                port = ( \"port\" in settings ? settings : $.ajaxSettings ).port;\n            if ( mode === \"abort\" ) {\n                if ( pendingRequests[ port ] ) {\n                    pendingRequests[ port ].abort();\n                }\n                pendingRequests[ port ] = ajax.apply( this, arguments );\n                return pendingRequests[ port ];\n            }\n            return ajax.apply( this, arguments );\n        };\n    }\n    return $;\n}));\n","jquery/jquery.tabs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    \"jquery\",\n    \"jquery/bootstrap/tab\",\n    \"jquery/bootstrap/collapse\",\n], function () {\n\n});\n","jquery/compat.js":"// Import every plugin under the sun. Bad for performance,\n// but prevents the store from breaking in situations\n// where a dependency was missed during the migration from\n// a monolith build of jQueryUI to a modular one\n\ndefine([\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/accordion',\n    'jquery-ui-modules/autocomplete',\n    'jquery-ui-modules/button',\n    'jquery-ui-modules/datepicker',\n    'jquery-ui-modules/dialog',\n    'jquery-ui-modules/draggable',\n    'jquery-ui-modules/droppable',\n    'jquery-ui-modules/effect-blind',\n    'jquery-ui-modules/effect-bounce',\n    'jquery-ui-modules/effect-clip',\n    'jquery-ui-modules/effect-drop',\n    'jquery-ui-modules/effect-explode',\n    'jquery-ui-modules/effect-fade',\n    'jquery-ui-modules/effect-fold',\n    'jquery-ui-modules/effect-highlight',\n    'jquery-ui-modules/effect-scale',\n    'jquery-ui-modules/effect-pulsate',\n    'jquery-ui-modules/effect-shake',\n    'jquery-ui-modules/effect-slide',\n    'jquery-ui-modules/effect-transfer',\n    'jquery-ui-modules/effect',\n    'jquery-ui-modules/menu',\n    'jquery-ui-modules/mouse',\n    'jquery-ui-modules/position',\n    'jquery-ui-modules/progressbar',\n    'jquery-ui-modules/resizable',\n    'jquery-ui-modules/selectable',\n    'jquery-ui-modules/slider',\n    'jquery-ui-modules/sortable',\n    'jquery-ui-modules/spinner',\n    'jquery-ui-modules/tabs',\n    'jquery-ui-modules/timepicker',\n    'jquery-ui-modules/tooltip',\n    'jquery-ui-modules/widget'\n], function() {\n    console.warn(\n        'Fallback to JQueryUI Compat activated. ' +\n        'Your store is missing a dependency for a ' +\n        'jQueryUI widget. Identifying and addressing the dependency ' +\n        'will drastically improve the performance of your site.'\n    );\n});\n","jquery/jquery-migrate.js":"/*!\n * jQuery Migrate - v3.3.2 - 2020-11-17T23:22Z\n * Copyright OpenJS Foundation and other contributors\n */\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\" ], function( jQuery ) {\n            return factory( jQuery, window );\n        } );\n    } else if ( typeof module === \"object\" && module.exports ) {\n\n        // Node/CommonJS\n        // eslint-disable-next-line no-undef\n        module.exports = factory( require( \"jquery\" ), window );\n    } else {\n\n        // Browser globals\n        factory( jQuery, window );\n    }\n} )( function( jQuery, window ) {\n    \"use strict\";\n\n    jQuery.migrateVersion = \"3.3.2\";\n\n// Returns 0 if v1 == v2, -1 if v1 < v2, 1 if v1 > v2\n    function compareVersions( v1, v2 ) {\n        var i,\n            rVersionParts = /^(\\d+)\\.(\\d+)\\.(\\d+)/,\n            v1p = rVersionParts.exec( v1 ) || [ ],\n            v2p = rVersionParts.exec( v2 ) || [ ];\n\n        for ( i = 1; i <= 3; i++ ) {\n            if ( +v1p[ i ] > +v2p[ i ] ) {\n                return 1;\n            }\n            if ( +v1p[ i ] < +v2p[ i ] ) {\n                return -1;\n            }\n        }\n        return 0;\n    }\n\n    function jQueryVersionSince( version ) {\n        return compareVersions( jQuery.fn.jquery, version ) >= 0;\n    }\n\n    ( function() {\n\n        // Support: IE9 only\n        // IE9 only creates console object when dev tools are first opened\n        // IE9 console is a host object, callable but doesn't have .apply()\n        if ( !window.console || !window.console.log ) {\n            return;\n        }\n\n        // Need jQuery 3.0.0+ and no older Migrate loaded\n        if ( !jQuery || !jQueryVersionSince( \"3.0.0\" ) ) {\n            window.console.log( \"JQMIGRATE: jQuery 3.0.0+ REQUIRED\" );\n        }\n        if ( jQuery.migrateWarnings ) {\n            window.console.log( \"JQMIGRATE: Migrate plugin loaded multiple times\" );\n        }\n\n        // Show a message on the console so devs know we're active\n        window.console.log( \"JQMIGRATE: Migrate is installed\" +\n            ( jQuery.migrateMute ? \"\" : \" with logging active\" ) +\n            \", version \" + jQuery.migrateVersion );\n\n    } )();\n\n    var warnedAbout = {};\n\n// By default each warning is only reported once.\n    jQuery.migrateDeduplicateWarnings = true;\n\n// List of warnings already given; public read only\n    jQuery.migrateWarnings = [];\n\n// Set to false to disable traces that appear with warnings\n    if ( jQuery.migrateTrace === undefined ) {\n        jQuery.migrateTrace = true;\n    }\n\n// Forget any warnings we've already given; public\n    jQuery.migrateReset = function() {\n        warnedAbout = {};\n        jQuery.migrateWarnings.length = 0;\n    };\n\n    function migrateWarn( msg ) {\n        var console = window.console;\n        if ( !jQuery.migrateDeduplicateWarnings || !warnedAbout[ msg ] ) {\n            warnedAbout[ msg ] = true;\n            jQuery.migrateWarnings.push( msg );\n            if ( console && console.warn && !jQuery.migrateMute ) {\n                console.warn( \"JQMIGRATE: \" + msg );\n                if ( jQuery.migrateTrace && console.trace ) {\n                    console.trace();\n                }\n            }\n        }\n    }\n\n    function migrateWarnProp( obj, prop, value, msg ) {\n        Object.defineProperty( obj, prop, {\n            configurable: true,\n            enumerable: true,\n            get: function() {\n                migrateWarn( msg );\n                return value;\n            },\n            set: function( newValue ) {\n                migrateWarn( msg );\n                value = newValue;\n            }\n        } );\n    }\n\n    function migrateWarnFunc( obj, prop, newFunc, msg ) {\n        obj[ prop ] = function() {\n            migrateWarn( msg );\n            return newFunc.apply( this, arguments );\n        };\n    }\n\n    if ( window.document.compatMode === \"BackCompat\" ) {\n\n        // JQuery has never supported or tested Quirks Mode\n        migrateWarn( \"jQuery is not compatible with Quirks Mode\" );\n    }\n\n    var findProp,\n        class2type = {},\n        oldInit = jQuery.fn.init,\n        oldFind = jQuery.find,\n\n        rattrHashTest = /\\[(\\s*[-\\w]+\\s*)([~|^$*]?=)\\s*([-\\w#]*?#[-\\w#]*)\\s*\\]/,\n        rattrHashGlob = /\\[(\\s*[-\\w]+\\s*)([~|^$*]?=)\\s*([-\\w#]*?#[-\\w#]*)\\s*\\]/g,\n\n        // Support: Android <=4.0 only\n        // Make sure we trim BOM and NBSP\n        rtrim = /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g;\n\n    jQuery.fn.init = function( arg1 ) {\n        var args = Array.prototype.slice.call( arguments );\n\n        if ( typeof arg1 === \"string\" && arg1 === \"#\" ) {\n\n            // JQuery( \"#\" ) is a bogus ID selector, but it returned an empty set before jQuery 3.0\n            migrateWarn( \"jQuery( '#' ) is not a valid selector\" );\n            args[ 0 ] = [];\n        }\n\n        return oldInit.apply( this, args );\n    };\n    jQuery.fn.init.prototype = jQuery.fn;\n\n    jQuery.find = function( selector ) {\n        var args = Array.prototype.slice.call( arguments );\n\n        // Support: PhantomJS 1.x\n        // String#match fails to match when used with a //g RegExp, only on some strings\n        if ( typeof selector === \"string\" && rattrHashTest.test( selector ) ) {\n\n            // The nonstandard and undocumented unquoted-hash was removed in jQuery 1.12.0\n            // First see if qS thinks it's a valid selector, if so avoid a false positive\n            try {\n                window.document.querySelector( selector );\n            } catch ( err1 ) {\n\n                // Didn't *look* valid to qSA, warn and try quoting what we think is the value\n                selector = selector.replace( rattrHashGlob, function( _, attr, op, value ) {\n                    return \"[\" + attr + op + \"\\\"\" + value + \"\\\"]\";\n                } );\n\n                // If the regexp *may* have created an invalid selector, don't update it\n                // Note that there may be false alarms if selector uses jQuery extensions\n                try {\n                    window.document.querySelector( selector );\n                    migrateWarn( \"Attribute selector with '#' must be quoted: \" + args[ 0 ] );\n                    args[ 0 ] = selector;\n                } catch ( err2 ) {\n                    migrateWarn( \"Attribute selector with '#' was not fixed: \" + args[ 0 ] );\n                }\n            }\n        }\n\n        return oldFind.apply( this, args );\n    };\n\n// Copy properties attached to original jQuery.find method (e.g. .attr, .isXML)\n    for ( findProp in oldFind ) {\n        if ( Object.prototype.hasOwnProperty.call( oldFind, findProp ) ) {\n            jQuery.find[ findProp ] = oldFind[ findProp ];\n        }\n    }\n\n// The number of elements contained in the matched element set\n    migrateWarnFunc( jQuery.fn, \"size\", function() {\n            return this.length;\n        },\n        \"jQuery.fn.size() is deprecated and removed; use the .length property\" );\n\n    migrateWarnFunc( jQuery, \"parseJSON\", function() {\n            return JSON.parse.apply( null, arguments );\n        },\n        \"jQuery.parseJSON is deprecated; use JSON.parse\" );\n\n    migrateWarnFunc( jQuery, \"holdReady\", jQuery.holdReady,\n        \"jQuery.holdReady is deprecated\" );\n\n    migrateWarnFunc( jQuery, \"unique\", jQuery.uniqueSort,\n        \"jQuery.unique is deprecated; use jQuery.uniqueSort\" );\n\n// Now jQuery.expr.pseudos is the standard incantation\n    migrateWarnProp( jQuery.expr, \"filters\", jQuery.expr.pseudos,\n        \"jQuery.expr.filters is deprecated; use jQuery.expr.pseudos\" );\n    migrateWarnProp( jQuery.expr, \":\", jQuery.expr.pseudos,\n        \"jQuery.expr[':'] is deprecated; use jQuery.expr.pseudos\" );\n\n// Prior to jQuery 3.1.1 there were internal refs so we don't warn there\n    if ( jQueryVersionSince( \"3.1.1\" ) ) {\n        migrateWarnFunc( jQuery, \"trim\", function( text ) {\n                return text == null ?\n                    \"\" :\n                    ( text + \"\" ).replace( rtrim, \"\" );\n            },\n            \"jQuery.trim is deprecated; use String.prototype.trim\" );\n    }\n\n// Prior to jQuery 3.2 there were internal refs so we don't warn there\n    if ( jQueryVersionSince( \"3.2.0\" ) ) {\n        migrateWarnFunc( jQuery, \"nodeName\", function( elem, name ) {\n                return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();\n            },\n            \"jQuery.nodeName is deprecated\" );\n\n        migrateWarnFunc( jQuery, \"isArray\", Array.isArray,\n            \"jQuery.isArray is deprecated; use Array.isArray\"\n        );\n    }\n\n    if ( jQueryVersionSince( \"3.3.0\" ) ) {\n\n        migrateWarnFunc( jQuery, \"isNumeric\", function( obj ) {\n\n                // As of jQuery 3.0, isNumeric is limited to\n                // strings and numbers (primitives or objects)\n                // that can be coerced to finite numbers (gh-2662)\n                var type = typeof obj;\n                return ( type === \"number\" || type === \"string\" ) &&\n\n                    // parseFloat NaNs numeric-cast false positives (\"\")\n                    // ...but misinterprets leading-number strings, e.g. hex literals (\"0x...\")\n                    // subtraction forces infinities to NaN\n                    !isNaN( obj - parseFloat( obj ) );\n            },\n            \"jQuery.isNumeric() is deprecated\"\n        );\n\n        // Populate the class2type map\n        jQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".\n            split( \" \" ),\n            function( _, name ) {\n                class2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n            } );\n\n        migrateWarnFunc( jQuery, \"type\", function( obj ) {\n                if ( obj == null ) {\n                    return obj + \"\";\n                }\n\n                // Support: Android <=2.3 only (functionish RegExp)\n                return typeof obj === \"object\" || typeof obj === \"function\" ?\n                    class2type[ Object.prototype.toString.call( obj ) ] || \"object\" :\n                    typeof obj;\n            },\n            \"jQuery.type is deprecated\" );\n\n        migrateWarnFunc( jQuery, \"isFunction\",\n            function( obj ) {\n                return typeof obj === \"function\";\n            },\n            \"jQuery.isFunction() is deprecated\" );\n\n        migrateWarnFunc( jQuery, \"isWindow\",\n            function( obj ) {\n                return obj != null && obj === obj.window;\n            },\n            \"jQuery.isWindow() is deprecated\"\n        );\n    }\n\n// Support jQuery slim which excludes the ajax module\n    if ( jQuery.ajax ) {\n\n        var oldAjax = jQuery.ajax,\n            rjsonp = /(=)\\?(?=&|$)|\\?\\?/;\n\n        jQuery.ajax = function( ) {\n            var jQXHR = oldAjax.apply( this, arguments );\n\n            // Be sure we got a jQXHR (e.g., not sync)\n            if ( jQXHR.promise ) {\n                migrateWarnFunc( jQXHR, \"success\", jQXHR.done,\n                    \"jQXHR.success is deprecated and removed\" );\n                migrateWarnFunc( jQXHR, \"error\", jQXHR.fail,\n                    \"jQXHR.error is deprecated and removed\" );\n                migrateWarnFunc( jQXHR, \"complete\", jQXHR.always,\n                    \"jQXHR.complete is deprecated and removed\" );\n            }\n\n            return jQXHR;\n        };\n\n// Only trigger the logic in jQuery <4 as the JSON-to-JSONP auto-promotion\n// behavior is gone in jQuery 4.0 and as it has security implications, we don't\n// want to restore the legacy behavior.\n        if ( !jQueryVersionSince( \"4.0.0\" ) ) {\n\n            // Register this prefilter before the jQuery one. Otherwise, a promoted\n            // request is transformed into one with the script dataType and we can't\n            // catch it anymore.\n            jQuery.ajaxPrefilter( \"+json\", function( s ) {\n\n                // Warn if JSON-to-JSONP auto-promotion happens.\n                if ( s.jsonp !== false && ( rjsonp.test( s.url ) ||\n                    typeof s.data === \"string\" &&\n                    ( s.contentType || \"\" )\n                        .indexOf( \"application/x-www-form-urlencoded\" ) === 0 &&\n                    rjsonp.test( s.data )\n                ) ) {\n                    migrateWarn( \"JSON-to-JSONP auto-promotion is deprecated\" );\n                }\n            } );\n        }\n\n    }\n\n    var oldRemoveAttr = jQuery.fn.removeAttr,\n        oldToggleClass = jQuery.fn.toggleClass,\n        rmatchNonSpace = /\\S+/g;\n\n    jQuery.fn.removeAttr = function( name ) {\n        var self = this;\n\n        jQuery.each( name.match( rmatchNonSpace ), function( _i, attr ) {\n            if ( jQuery.expr.match.bool.test( attr ) ) {\n                migrateWarn( \"jQuery.fn.removeAttr no longer sets boolean properties: \" + attr );\n                self.prop( attr, false );\n            }\n        } );\n\n        return oldRemoveAttr.apply( this, arguments );\n    };\n\n    jQuery.fn.toggleClass = function( state ) {\n\n        // Only deprecating no-args or single boolean arg\n        if ( state !== undefined && typeof state !== \"boolean\" ) {\n            return oldToggleClass.apply( this, arguments );\n        }\n\n        migrateWarn( \"jQuery.fn.toggleClass( boolean ) is deprecated\" );\n\n        // Toggle entire class name of each element\n        return this.each( function() {\n            var className = this.getAttribute && this.getAttribute( \"class\" ) || \"\";\n\n            if ( className ) {\n                jQuery.data( this, \"__className__\", className );\n            }\n\n            // If the element has a class name or if we're passed `false`,\n            // then remove the whole classname (if there was one, the above saved it).\n            // Otherwise bring back whatever was previously saved (if anything),\n            // falling back to the empty string if nothing was stored.\n            if ( this.setAttribute ) {\n                this.setAttribute( \"class\",\n                    className || state === false ?\n                        \"\" :\n                        jQuery.data( this, \"__className__\" ) || \"\"\n                );\n            }\n        } );\n    };\n\n    function camelCase( string ) {\n        return string.replace( /-([a-z])/g, function( _, letter ) {\n            return letter.toUpperCase();\n        } );\n    }\n\n    var oldFnCss,\n        internalSwapCall = false,\n        ralphaStart = /^[a-z]/,\n\n        // The regex visualized:\n        //\n        //                         /----------\\\n        //                        |            |    /-------\\\n        //                        |  / Top  \\  |   |         |\n        //         /--- Border ---+-| Right  |-+---+- Width -+---\\\n        //        |                 | Bottom |                    |\n        //        |                  \\ Left /                     |\n        //        |                                               |\n        //        |                              /----------\\     |\n        //        |          /-------------\\    |            |    |- END\n        //        |         |               |   |  / Top  \\  |    |\n        //        |         |  / Margin  \\  |   | | Right  | |    |\n        //        |---------+-|           |-+---+-| Bottom |-+----|\n        //        |            \\ Padding /         \\ Left /       |\n        // BEGIN -|                                               |\n        //        |                /---------\\                    |\n        //        |               |           |                   |\n        //        |               |  / Min \\  |    / Width  \\     |\n        //         \\--------------+-|       |-+---|          |---/\n        //                           \\ Max /       \\ Height /\n        rautoPx = /^(?:Border(?:Top|Right|Bottom|Left)?(?:Width|)|(?:Margin|Padding)?(?:Top|Right|Bottom|Left)?|(?:Min|Max)?(?:Width|Height))$/;\n\n// If this version of jQuery has .swap(), don't false-alarm on internal uses\n    if ( jQuery.swap ) {\n        jQuery.each( [ \"height\", \"width\", \"reliableMarginRight\" ], function( _, name ) {\n            var oldHook = jQuery.cssHooks[ name ] && jQuery.cssHooks[ name ].get;\n\n            if ( oldHook ) {\n                jQuery.cssHooks[ name ].get = function() {\n                    var ret;\n\n                    internalSwapCall = true;\n                    ret = oldHook.apply( this, arguments );\n                    internalSwapCall = false;\n                    return ret;\n                };\n            }\n        } );\n    }\n\n    jQuery.swap = function( elem, options, callback, args ) {\n        var ret, name,\n            old = {};\n\n        if ( !internalSwapCall ) {\n            migrateWarn( \"jQuery.swap() is undocumented and deprecated\" );\n        }\n\n        // Remember the old values, and insert the new ones\n        for ( name in options ) {\n            old[ name ] = elem.style[ name ];\n            elem.style[ name ] = options[ name ];\n        }\n\n        ret = callback.apply( elem, args || [] );\n\n        // Revert the old values\n        for ( name in options ) {\n            elem.style[ name ] = old[ name ];\n        }\n\n        return ret;\n    };\n\n    if ( jQueryVersionSince( \"3.4.0\" ) && typeof Proxy !== \"undefined\" ) {\n\n        jQuery.cssProps = new Proxy( jQuery.cssProps || {}, {\n            set: function() {\n                migrateWarn( \"JQMIGRATE: jQuery.cssProps is deprecated\" );\n                return Reflect.set.apply( this, arguments );\n            }\n        } );\n    }\n\n// Create a dummy jQuery.cssNumber if missing. It won't be used by jQuery but\n// it will prevent code adding new keys to it unconditionally from crashing.\n    if ( !jQuery.cssNumber ) {\n        jQuery.cssNumber = {};\n    }\n\n    function isAutoPx( prop ) {\n\n        // The first test is used to ensure that:\n        // 1. The prop starts with a lowercase letter (as we uppercase it for the second regex).\n        // 2. The prop is not empty.\n        return ralphaStart.test( prop ) &&\n            rautoPx.test( prop[ 0 ].toUpperCase() + prop.slice( 1 ) );\n    }\n\n    oldFnCss = jQuery.fn.css;\n\n    jQuery.fn.css = function( name, value ) {\n        var camelName,\n            origThis = this;\n        if ( name && typeof name === \"object\" && !Array.isArray( name ) ) {\n            jQuery.each( name, function( n, v ) {\n                jQuery.fn.css.call( origThis, n, v );\n            } );\n            return this;\n        }\n        if ( typeof value === \"number\" ) {\n            camelName = camelCase( name );\n            if ( !isAutoPx( camelName ) && !jQuery.cssNumber[ camelName ] ) {\n                migrateWarn( \"Number-typed values are deprecated for jQuery.fn.css( \\\"\" +\n                    name + \"\\\", value )\" );\n            }\n        }\n\n        return oldFnCss.apply( this, arguments );\n    };\n\n    var oldData = jQuery.data;\n\n    jQuery.data = function( elem, name, value ) {\n        var curData, sameKeys, key;\n\n        // Name can be an object, and each entry in the object is meant to be set as data\n        if ( name && typeof name === \"object\" && arguments.length === 2 ) {\n            curData = jQuery.hasData( elem ) && oldData.call( this, elem );\n            sameKeys = {};\n            for ( key in name ) {\n                if ( key !== camelCase( key ) ) {\n                    migrateWarn( \"jQuery.data() always sets/gets camelCased names: \" + key );\n                    curData[ key ] = name[ key ];\n                } else {\n                    sameKeys[ key ] = name[ key ];\n                }\n            }\n\n            oldData.call( this, elem, sameKeys );\n\n            return name;\n        }\n\n        // If the name is transformed, look for the un-transformed name in the data object\n        if ( name && typeof name === \"string\" && name !== camelCase( name ) ) {\n            curData = jQuery.hasData( elem ) && oldData.call( this, elem );\n            if ( curData && name in curData ) {\n                migrateWarn( \"jQuery.data() always sets/gets camelCased names: \" + name );\n                if ( arguments.length > 2 ) {\n                    curData[ name ] = value;\n                }\n                return curData[ name ];\n            }\n        }\n\n        return oldData.apply( this, arguments );\n    };\n\n// Support jQuery slim which excludes the effects module\n    if ( jQuery.fx ) {\n\n        var intervalValue, intervalMsg,\n            oldTweenRun = jQuery.Tween.prototype.run,\n            linearEasing = function( pct ) {\n                return pct;\n            };\n\n        jQuery.Tween.prototype.run = function( ) {\n            if ( jQuery.easing[ this.easing ].length > 1 ) {\n                migrateWarn(\n                    \"'jQuery.easing.\" + this.easing.toString() + \"' should use only one argument\"\n                );\n\n                jQuery.easing[ this.easing ] = linearEasing;\n            }\n\n            oldTweenRun.apply( this, arguments );\n        };\n\n        intervalValue = jQuery.fx.interval || 13;\n        intervalMsg = \"jQuery.fx.interval is deprecated\";\n\n// Support: IE9, Android <=4.4\n// Avoid false positives on browsers that lack rAF\n// Don't warn if document is hidden, jQuery uses setTimeout (#292)\n        if ( window.requestAnimationFrame ) {\n            Object.defineProperty( jQuery.fx, \"interval\", {\n                configurable: true,\n                enumerable: true,\n                get: function() {\n                    if ( !window.document.hidden ) {\n                        migrateWarn( intervalMsg );\n                    }\n                    return intervalValue;\n                },\n                set: function( newValue ) {\n                    migrateWarn( intervalMsg );\n                    intervalValue = newValue;\n                }\n            } );\n        }\n\n    }\n\n    var oldLoad = jQuery.fn.load,\n        oldEventAdd = jQuery.event.add,\n        originalFix = jQuery.event.fix;\n\n    jQuery.event.props = [];\n    jQuery.event.fixHooks = {};\n\n    migrateWarnProp( jQuery.event.props, \"concat\", jQuery.event.props.concat,\n        \"jQuery.event.props.concat() is deprecated and removed\" );\n\n    jQuery.event.fix = function( originalEvent ) {\n        var event,\n            type = originalEvent.type,\n            fixHook = this.fixHooks[ type ],\n            props = jQuery.event.props;\n\n        if ( props.length ) {\n            migrateWarn( \"jQuery.event.props are deprecated and removed: \" + props.join() );\n            while ( props.length ) {\n                jQuery.event.addProp( props.pop() );\n            }\n        }\n\n        if ( fixHook && !fixHook._migrated_ ) {\n            fixHook._migrated_ = true;\n            migrateWarn( \"jQuery.event.fixHooks are deprecated and removed: \" + type );\n            if ( ( props = fixHook.props ) && props.length ) {\n                while ( props.length ) {\n                    jQuery.event.addProp( props.pop() );\n                }\n            }\n        }\n\n        event = originalFix.call( this, originalEvent );\n\n        return fixHook && fixHook.filter ? fixHook.filter( event, originalEvent ) : event;\n    };\n\n    jQuery.event.add = function( elem, types ) {\n\n        // This misses the multiple-types case but that seems awfully rare\n        if ( elem === window && types === \"load\" && window.document.readyState === \"complete\" ) {\n            migrateWarn( \"jQuery(window).on('load'...) called after load event occurred\" );\n        }\n        return oldEventAdd.apply( this, arguments );\n    };\n\n    jQuery.each( [ \"load\", \"unload\", \"error\" ], function( _, name ) {\n\n        jQuery.fn[ name ] = function() {\n            var args = Array.prototype.slice.call( arguments, 0 );\n\n            // If this is an ajax load() the first arg should be the string URL;\n            // technically this could also be the \"Anything\" arg of the event .load()\n            // which just goes to show why this dumb signature has been deprecated!\n            // jQuery custom builds that exclude the Ajax module justifiably die here.\n            if ( name === \"load\" && typeof args[ 0 ] === \"string\" ) {\n                return oldLoad.apply( this, args );\n            }\n\n            migrateWarn( \"jQuery.fn.\" + name + \"() is deprecated\" );\n\n            args.splice( 0, 0, name );\n            if ( arguments.length ) {\n                return this.on.apply( this, args );\n            }\n\n            // Use .triggerHandler here because:\n            // - load and unload events don't need to bubble, only applied to window or image\n            // - error event should not bubble to window, although it does pre-1.7\n            // See http://bugs.jquery.com/ticket/11820\n            this.triggerHandler.apply( this, args );\n            return this;\n        };\n\n    } );\n\n    jQuery.each( ( \"blur focus focusin focusout resize scroll click dblclick \" +\n            \"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave \" +\n            \"change select submit keydown keypress keyup contextmenu\" ).split( \" \" ),\n        function( _i, name ) {\n\n            // Handle event binding\n            jQuery.fn[ name ] = function( data, fn ) {\n                migrateWarn( \"jQuery.fn.\" + name + \"() event shorthand is deprecated\" );\n                return arguments.length > 0 ?\n                    this.on( name, null, data, fn ) :\n                    this.trigger( name );\n            };\n        } );\n\n// Trigger \"ready\" event only once, on document ready\n    jQuery( function() {\n        jQuery( window.document ).triggerHandler( \"ready\" );\n    } );\n\n    jQuery.event.special.ready = {\n        setup: function() {\n            if ( this === window.document ) {\n                migrateWarn( \"'ready' event is deprecated\" );\n            }\n        }\n    };\n\n    jQuery.fn.extend( {\n\n        bind: function( types, data, fn ) {\n            migrateWarn( \"jQuery.fn.bind() is deprecated\" );\n            return this.on( types, null, data, fn );\n        },\n        unbind: function( types, fn ) {\n            migrateWarn( \"jQuery.fn.unbind() is deprecated\" );\n            return this.off( types, null, fn );\n        },\n        delegate: function( selector, types, data, fn ) {\n            migrateWarn( \"jQuery.fn.delegate() is deprecated\" );\n            return this.on( types, selector, data, fn );\n        },\n        undelegate: function( selector, types, fn ) {\n            migrateWarn( \"jQuery.fn.undelegate() is deprecated\" );\n            return arguments.length === 1 ?\n                this.off( selector, \"**\" ) :\n                this.off( types, selector || \"**\", fn );\n        },\n        hover: function( fnOver, fnOut ) {\n            migrateWarn( \"jQuery.fn.hover() is deprecated\" );\n            return this.on( \"mouseenter\", fnOver ).on( \"mouseleave\", fnOut || fnOver );\n        }\n    } );\n\n    var rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\\/\\0>\\x20\\t\\r\\n\\f]*)[^>]*)\\/>/gi,\n        origHtmlPrefilter = jQuery.htmlPrefilter,\n        makeMarkup = function( html ) {\n            var doc = window.document.implementation.createHTMLDocument( \"\" );\n            doc.body.innerHTML = html;\n            return doc.body && doc.body.innerHTML;\n        },\n        warnIfChanged = function( html ) {\n            var changed = html.replace( rxhtmlTag, \"<$1></$2>\" );\n            if ( changed !== html && makeMarkup( html ) !== makeMarkup( changed ) ) {\n                migrateWarn( \"HTML tags must be properly nested and closed: \" + html );\n            }\n        };\n\n    jQuery.UNSAFE_restoreLegacyHtmlPrefilter = function() {\n        jQuery.htmlPrefilter = function( html ) {\n            warnIfChanged( html );\n            return html.replace( rxhtmlTag, \"<$1></$2>\" );\n        };\n    };\n\n    jQuery.htmlPrefilter = function( html ) {\n        warnIfChanged( html );\n        return origHtmlPrefilter( html );\n    };\n\n    var oldOffset = jQuery.fn.offset;\n\n    jQuery.fn.offset = function() {\n        var elem = this[ 0 ];\n\n        if ( elem && ( !elem.nodeType || !elem.getBoundingClientRect ) ) {\n            migrateWarn( \"jQuery.fn.offset() requires a valid DOM element\" );\n            return arguments.length ? this : undefined;\n        }\n\n        return oldOffset.apply( this, arguments );\n    };\n\n// Support jQuery slim which excludes the ajax module\n// The jQuery.param patch is about respecting `jQuery.ajaxSettings.traditional`\n// so it doesn't make sense for the slim build.\n    if ( jQuery.ajax ) {\n\n        var oldParam = jQuery.param;\n\n        jQuery.param = function( data, traditional ) {\n            var ajaxTraditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;\n\n            if ( traditional === undefined && ajaxTraditional ) {\n\n                migrateWarn( \"jQuery.param() no longer uses jQuery.ajaxSettings.traditional\" );\n                traditional = ajaxTraditional;\n            }\n\n            return oldParam.call( this, data, traditional );\n        };\n\n    }\n\n    var oldSelf = jQuery.fn.andSelf || jQuery.fn.addBack;\n\n    jQuery.fn.andSelf = function() {\n        migrateWarn( \"jQuery.fn.andSelf() is deprecated and removed, use jQuery.fn.addBack()\" );\n        return oldSelf.apply( this, arguments );\n    };\n\n// Support jQuery slim which excludes the deferred module in jQuery 4.0+\n    if ( jQuery.Deferred ) {\n\n        var oldDeferred = jQuery.Deferred,\n            tuples = [\n\n                // Action, add listener, callbacks, .then handlers, final state\n                [ \"resolve\", \"done\", jQuery.Callbacks( \"once memory\" ),\n                    jQuery.Callbacks( \"once memory\" ), \"resolved\" ],\n                [ \"reject\", \"fail\", jQuery.Callbacks( \"once memory\" ),\n                    jQuery.Callbacks( \"once memory\" ), \"rejected\" ],\n                [ \"notify\", \"progress\", jQuery.Callbacks( \"memory\" ),\n                    jQuery.Callbacks( \"memory\" ) ]\n            ];\n\n        jQuery.Deferred = function( func ) {\n            var deferred = oldDeferred(),\n                promise = deferred.promise();\n\n            deferred.pipe = promise.pipe = function( /* fnDone, fnFail, fnProgress */ ) {\n                var fns = arguments;\n\n                migrateWarn( \"deferred.pipe() is deprecated\" );\n\n                return jQuery.Deferred( function( newDefer ) {\n                    jQuery.each( tuples, function( i, tuple ) {\n                        var fn = typeof fns[ i ] === \"function\" && fns[ i ];\n\n                        // Deferred.done(function() { bind to newDefer or newDefer.resolve })\n                        // deferred.fail(function() { bind to newDefer or newDefer.reject })\n                        // deferred.progress(function() { bind to newDefer or newDefer.notify })\n                        deferred[ tuple[ 1 ] ]( function() {\n                            var returned = fn && fn.apply( this, arguments );\n                            if ( returned && typeof returned.promise === \"function\" ) {\n                                returned.promise()\n                                    .done( newDefer.resolve )\n                                    .fail( newDefer.reject )\n                                    .progress( newDefer.notify );\n                            } else {\n                                newDefer[ tuple[ 0 ] + \"With\" ](\n                                    this === promise ? newDefer.promise() : this,\n                                    fn ? [ returned ] : arguments\n                                );\n                            }\n                        } );\n                    } );\n                    fns = null;\n                } ).promise();\n\n            };\n\n            if ( func ) {\n                func.call( deferred, deferred );\n            }\n\n            return deferred;\n        };\n\n// Preserve handler of uncaught exceptions in promise chains\n        jQuery.Deferred.exceptionHook = oldDeferred.exceptionHook;\n\n    }\n\n    return jQuery;\n} );\n","jquery/timepicker.js":"/*! jQuery Timepicker Addon - v1.6.3 - 2016-04-20\n* http://trentrichardson.com/examples/timepicker\n* Copyright (c) 2016 Trent Richardson; Licensed MIT */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery', 'jquery-ui-modules/datepicker', 'jquery-ui-modules/slider'], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n    /*\n    * Lets not redefine timepicker, Prevent \"Uncaught RangeError: Maximum call stack size exceeded\"\n    */\n    $.ui.timepicker = $.ui.timepicker || {};\n    if ($.ui.timepicker.version) {\n        return;\n    }\n\n    /*\n    * Extend jQueryUI, get it started with our version number\n    */\n    $.extend($.ui, {\n        timepicker: {\n            version: \"1.6.3\"\n        }\n    });\n\n    /*\n    * Timepicker manager.\n    * Use the singleton instance of this class, $.timepicker, to interact with the time picker.\n    * Settings for (groups of) time pickers are maintained in an instance object,\n    * allowing multiple different settings on the same page.\n    */\n    var Timepicker = function () {\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[''] = { // Default regional settings\n            currentText: 'Now',\n            closeText: 'Done',\n            amNames: ['AM', 'A'],\n            pmNames: ['PM', 'P'],\n            timeFormat: 'HH:mm',\n            timeSuffix: '',\n            timeOnlyTitle: 'Choose Time',\n            timeText: 'Time',\n            hourText: 'Hour',\n            minuteText: 'Minute',\n            secondText: 'Second',\n            millisecText: 'Millisecond',\n            microsecText: 'Microsecond',\n            timezoneText: 'Time Zone',\n            isRTL: false\n        };\n        this._defaults = { // Global defaults for all the datetime picker instances\n            showButtonPanel: true,\n            timeOnly: false,\n            timeOnlyShowDate: false,\n            showHour: null,\n            showMinute: null,\n            showSecond: null,\n            showMillisec: null,\n            showMicrosec: null,\n            showTimezone: null,\n            showTime: true,\n            stepHour: 1,\n            stepMinute: 1,\n            stepSecond: 1,\n            stepMillisec: 1,\n            stepMicrosec: 1,\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null,\n            hourMin: 0,\n            minuteMin: 0,\n            secondMin: 0,\n            millisecMin: 0,\n            microsecMin: 0,\n            hourMax: 23,\n            minuteMax: 59,\n            secondMax: 59,\n            millisecMax: 999,\n            microsecMax: 999,\n            minDateTime: null,\n            maxDateTime: null,\n            maxTime: null,\n            minTime: null,\n            onSelect: null,\n            hourGrid: 0,\n            minuteGrid: 0,\n            secondGrid: 0,\n            millisecGrid: 0,\n            microsecGrid: 0,\n            alwaysSetTime: true,\n            separator: ' ',\n            altFieldTimeOnly: true,\n            altTimeFormat: null,\n            altSeparator: null,\n            altTimeSuffix: null,\n            altRedirectFocus: true,\n            pickerTimeFormat: null,\n            pickerTimeSuffix: null,\n            showTimepicker: true,\n            timezoneList: null,\n            addSliderAccess: false,\n            sliderAccessArgs: null,\n            controlType: 'slider',\n            oneLine: false,\n            defaultValue: null,\n            parse: 'strict',\n            afterInject: null\n        };\n        $.extend(this._defaults, this.regional['']);\n    };\n\n    $.extend(Timepicker.prototype, {\n        $input: null,\n        $altInput: null,\n        $timeObj: null,\n        inst: null,\n        hour_slider: null,\n        minute_slider: null,\n        second_slider: null,\n        millisec_slider: null,\n        microsec_slider: null,\n        timezone_select: null,\n        maxTime: null,\n        minTime: null,\n        hour: 0,\n        minute: 0,\n        second: 0,\n        millisec: 0,\n        microsec: 0,\n        timezone: null,\n        hourMinOriginal: null,\n        minuteMinOriginal: null,\n        secondMinOriginal: null,\n        millisecMinOriginal: null,\n        microsecMinOriginal: null,\n        hourMaxOriginal: null,\n        minuteMaxOriginal: null,\n        secondMaxOriginal: null,\n        millisecMaxOriginal: null,\n        microsecMaxOriginal: null,\n        ampm: '',\n        formattedDate: '',\n        formattedTime: '',\n        formattedDateTime: '',\n        timezoneList: null,\n        units: ['hour', 'minute', 'second', 'millisec', 'microsec'],\n        support: {},\n        control: null,\n\n        /*\n        * Override the default settings for all instances of the time picker.\n        * @param  {Object} settings  object - the new settings to use as defaults (anonymous object)\n        * @return {Object} the manager object\n        */\n        setDefaults: function (settings) {\n            extendRemove(this._defaults, settings || {});\n            return this;\n        },\n\n        /*\n        * Create a new Timepicker instance\n        */\n        _newInst: function ($input, opts) {\n            var tp_inst = new Timepicker(),\n                inlineSettings = {},\n                fns = {},\n                overrides, i;\n\n            for (var attrName in this._defaults) {\n                if (this._defaults.hasOwnProperty(attrName)) {\n                    var attrValue = $input.attr('time:' + attrName);\n                    if (attrValue) {\n                        try {\n                            inlineSettings[attrName] = eval(attrValue);\n                        } catch (err) {\n                            inlineSettings[attrName] = attrValue;\n                        }\n                    }\n                }\n            }\n\n            overrides = {\n                beforeShow: function (input, dp_inst) {\n                    if ($.isFunction(tp_inst._defaults.evnts.beforeShow)) {\n                        return tp_inst._defaults.evnts.beforeShow.call($input[0], input, dp_inst, tp_inst);\n                    }\n                },\n                onChangeMonthYear: function (year, month, dp_inst) {\n                    // Update the time as well : this prevents the time from disappearing from the $input field.\n                    // tp_inst._updateDateTime(dp_inst);\n                    if ($.isFunction(tp_inst._defaults.evnts.onChangeMonthYear)) {\n                        tp_inst._defaults.evnts.onChangeMonthYear.call($input[0], year, month, dp_inst, tp_inst);\n                    }\n                },\n                onClose: function (dateText, dp_inst) {\n                    if (tp_inst.timeDefined === true && $input.val() !== '') {\n                        tp_inst._updateDateTime(dp_inst);\n                    }\n                    if ($.isFunction(tp_inst._defaults.evnts.onClose)) {\n                        tp_inst._defaults.evnts.onClose.call($input[0], dateText, dp_inst, tp_inst);\n                    }\n                }\n            };\n            for (i in overrides) {\n                if (overrides.hasOwnProperty(i)) {\n                    fns[i] = opts[i] || this._defaults[i] || null;\n                }\n            }\n\n            tp_inst._defaults = $.extend({}, this._defaults, inlineSettings, opts, overrides, {\n                evnts: fns,\n                timepicker: tp_inst // add timepicker as a property of datepicker: $.datepicker._get(dp_inst, 'timepicker');\n            });\n            tp_inst.amNames = $.map(tp_inst._defaults.amNames, function (val) {\n                return val.toUpperCase();\n            });\n            tp_inst.pmNames = $.map(tp_inst._defaults.pmNames, function (val) {\n                return val.toUpperCase();\n            });\n\n            // detect which units are supported\n            tp_inst.support = detectSupport(\n                tp_inst._defaults.timeFormat +\n                (tp_inst._defaults.pickerTimeFormat ? tp_inst._defaults.pickerTimeFormat : '') +\n                (tp_inst._defaults.altTimeFormat ? tp_inst._defaults.altTimeFormat : ''));\n\n            // controlType is string - key to our this._controls\n            if (typeof(tp_inst._defaults.controlType) === 'string') {\n                if (tp_inst._defaults.controlType === 'slider' && typeof($.ui.slider) === 'undefined') {\n                    tp_inst._defaults.controlType = 'select';\n                }\n                tp_inst.control = tp_inst._controls[tp_inst._defaults.controlType];\n            }\n            // controlType is an object and must implement create, options, value methods\n            else {\n                tp_inst.control = tp_inst._defaults.controlType;\n            }\n\n            // prep the timezone options\n            var timezoneList = [-720, -660, -600, -570, -540, -480, -420, -360, -300, -270, -240, -210, -180, -120, -60,\n                0, 60, 120, 180, 210, 240, 270, 300, 330, 345, 360, 390, 420, 480, 525, 540, 570, 600, 630, 660, 690, 720, 765, 780, 840];\n            if (tp_inst._defaults.timezoneList !== null) {\n                timezoneList = tp_inst._defaults.timezoneList;\n            }\n            var tzl = timezoneList.length, tzi = 0, tzv = null;\n            if (tzl > 0 && typeof timezoneList[0] !== 'object') {\n                for (; tzi < tzl; tzi++) {\n                    tzv = timezoneList[tzi];\n                    timezoneList[tzi] = { value: tzv, label: $.timepicker.timezoneOffsetString(tzv, tp_inst.support.iso8601) };\n                }\n            }\n            tp_inst._defaults.timezoneList = timezoneList;\n\n            // set the default units\n            tp_inst.timezone = tp_inst._defaults.timezone !== null ? $.timepicker.timezoneOffsetNumber(tp_inst._defaults.timezone) :\n                ((new Date()).getTimezoneOffset() * -1);\n            tp_inst.hour = tp_inst._defaults.hour < tp_inst._defaults.hourMin ? tp_inst._defaults.hourMin :\n                tp_inst._defaults.hour > tp_inst._defaults.hourMax ? tp_inst._defaults.hourMax : tp_inst._defaults.hour;\n            tp_inst.minute = tp_inst._defaults.minute < tp_inst._defaults.minuteMin ? tp_inst._defaults.minuteMin :\n                tp_inst._defaults.minute > tp_inst._defaults.minuteMax ? tp_inst._defaults.minuteMax : tp_inst._defaults.minute;\n            tp_inst.second = tp_inst._defaults.second < tp_inst._defaults.secondMin ? tp_inst._defaults.secondMin :\n                tp_inst._defaults.second > tp_inst._defaults.secondMax ? tp_inst._defaults.secondMax : tp_inst._defaults.second;\n            tp_inst.millisec = tp_inst._defaults.millisec < tp_inst._defaults.millisecMin ? tp_inst._defaults.millisecMin :\n                tp_inst._defaults.millisec > tp_inst._defaults.millisecMax ? tp_inst._defaults.millisecMax : tp_inst._defaults.millisec;\n            tp_inst.microsec = tp_inst._defaults.microsec < tp_inst._defaults.microsecMin ? tp_inst._defaults.microsecMin :\n                tp_inst._defaults.microsec > tp_inst._defaults.microsecMax ? tp_inst._defaults.microsecMax : tp_inst._defaults.microsec;\n            tp_inst.ampm = '';\n            tp_inst.$input = $input;\n\n            if (tp_inst._defaults.altField) {\n                tp_inst.$altInput = $(tp_inst._defaults.altField);\n                if (tp_inst._defaults.altRedirectFocus === true) {\n                    tp_inst.$altInput.css({\n                        cursor: 'pointer'\n                    }).focus(function () {\n                        $input.trigger(\"focus\");\n                    });\n                }\n            }\n\n            if (tp_inst._defaults.minDate === 0 || tp_inst._defaults.minDateTime === 0) {\n                tp_inst._defaults.minDate = new Date();\n            }\n            if (tp_inst._defaults.maxDate === 0 || tp_inst._defaults.maxDateTime === 0) {\n                tp_inst._defaults.maxDate = new Date();\n            }\n\n            // datepicker needs minDate/maxDate, timepicker needs minDateTime/maxDateTime..\n            if (tp_inst._defaults.minDate !== undefined && tp_inst._defaults.minDate instanceof Date) {\n                tp_inst._defaults.minDateTime = new Date(tp_inst._defaults.minDate.getTime());\n            }\n            if (tp_inst._defaults.minDateTime !== undefined && tp_inst._defaults.minDateTime instanceof Date) {\n                tp_inst._defaults.minDate = new Date(tp_inst._defaults.minDateTime.getTime());\n            }\n            if (tp_inst._defaults.maxDate !== undefined && tp_inst._defaults.maxDate instanceof Date) {\n                tp_inst._defaults.maxDateTime = new Date(tp_inst._defaults.maxDate.getTime());\n            }\n            if (tp_inst._defaults.maxDateTime !== undefined && tp_inst._defaults.maxDateTime instanceof Date) {\n                tp_inst._defaults.maxDate = new Date(tp_inst._defaults.maxDateTime.getTime());\n            }\n            tp_inst.$input.bind('focus', function () {\n                tp_inst._onFocus();\n            });\n\n            return tp_inst;\n        },\n\n        /*\n        * add our sliders to the calendar\n        */\n        _addTimePicker: function (dp_inst) {\n            var currDT = $.trim((this.$altInput && this._defaults.altFieldTimeOnly) ? this.$input.val() + ' ' + this.$altInput.val() : this.$input.val());\n\n            this.timeDefined = this._parseTime(currDT);\n            this._limitMinMaxDateTime(dp_inst, false);\n            this._injectTimePicker();\n            this._afterInject();\n        },\n\n        /*\n        * parse the time string from input value or _setTime\n        */\n        _parseTime: function (timeString, withDate) {\n            if (!this.inst) {\n                this.inst = $.datepicker._getInst(this.$input[0]);\n            }\n\n            if (withDate || !this._defaults.timeOnly) {\n                var dp_dateFormat = $.datepicker._get(this.inst, 'dateFormat');\n                try {\n                    var parseRes = parseDateTimeInternal(dp_dateFormat, this._defaults.timeFormat, timeString, $.datepicker._getFormatConfig(this.inst), this._defaults);\n                    if (!parseRes.timeObj) {\n                        return false;\n                    }\n                    $.extend(this, parseRes.timeObj);\n                } catch (err) {\n                    $.timepicker.log(\"Error parsing the date/time string: \" + err +\n                        \"\\ndate/time string = \" + timeString +\n                        \"\\ntimeFormat = \" + this._defaults.timeFormat +\n                        \"\\ndateFormat = \" + dp_dateFormat);\n                    return false;\n                }\n                return true;\n            } else {\n                var timeObj = $.datepicker.parseTime(this._defaults.timeFormat, timeString, this._defaults);\n                if (!timeObj) {\n                    return false;\n                }\n                $.extend(this, timeObj);\n                return true;\n            }\n        },\n\n        /*\n        * Handle callback option after injecting timepicker\n        */\n        _afterInject: function() {\n            var o = this.inst.settings;\n            if ($.isFunction(o.afterInject)) {\n                o.afterInject.call(this);\n            }\n        },\n\n        /*\n        * generate and inject html for timepicker into ui datepicker\n        */\n        _injectTimePicker: function () {\n            var $dp = this.inst.dpDiv,\n                o = this.inst.settings,\n                tp_inst = this,\n                litem = '',\n                uitem = '',\n                show = null,\n                max = {},\n                gridSize = {},\n                size = null,\n                i = 0,\n                l = 0;\n\n            // Prevent displaying twice\n            if ($dp.find(\"div.ui-timepicker-div\").length === 0 && o.showTimepicker) {\n                var noDisplay = ' ui_tpicker_unit_hide',\n                    html = '<div class=\"ui-timepicker-div' + (o.isRTL ? ' ui-timepicker-rtl' : '') + (o.oneLine && o.controlType === 'select' ? ' ui-timepicker-oneLine' : '') + '\"><dl>' + '<dt class=\"ui_tpicker_time_label' + ((o.showTime) ? '' : noDisplay) + '\">' + o.timeText + '</dt>' +\n                        '<dd class=\"ui_tpicker_time '+ ((o.showTime) ? '' : noDisplay) + '\"><input class=\"ui_tpicker_time_input\" ' + (o.timeInput ? '' : 'disabled') + '/></dd>';\n\n                // Create the markup\n                for (i = 0, l = this.units.length; i < l; i++) {\n                    litem = this.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // Added by Peter Medeiros:\n                    // - Figure out what the hour/minute/second max should be based on the step values.\n                    // - Example: if stepMinute is 15, then minMax is 45.\n                    max[litem] = parseInt((o[litem + 'Max'] - ((o[litem + 'Max'] - o[litem + 'Min']) % o['step' + uitem])), 10);\n                    gridSize[litem] = 0;\n\n                    html += '<dt class=\"ui_tpicker_' + litem + '_label' + (show ? '' : noDisplay) + '\">' + o[litem + 'Text'] + '</dt>' +\n                        '<dd class=\"ui_tpicker_' + litem + (show ? '' : noDisplay) + '\"><div class=\"ui_tpicker_' + litem + '_slider' + (show ? '' : noDisplay) + '\"></div>';\n\n                    if (show && o[litem + 'Grid'] > 0) {\n                        html += '<div style=\"padding-left: 1px\"><table class=\"ui-tpicker-grid-label\"><tr>';\n\n                        if (litem === 'hour') {\n                            for (var h = o[litem + 'Min']; h <= max[litem]; h += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                var tmph = $.datepicker.formatTime(this.support.ampm ? 'hht' : 'HH', {hour: h}, o);\n                                html += '<td data-for=\"' + litem + '\">' + tmph + '</td>';\n                            }\n                        }\n                        else {\n                            for (var m = o[litem + 'Min']; m <= max[litem]; m += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                html += '<td data-for=\"' + litem + '\">' + ((m < 10) ? '0' : '') + m + '</td>';\n                            }\n                        }\n\n                        html += '</tr></table></div>';\n                    }\n                    html += '</dd>';\n                }\n\n                // Timezone\n                var showTz = o.showTimezone !== null ? o.showTimezone : this.support.timezone;\n                html += '<dt class=\"ui_tpicker_timezone_label' + (showTz ? '' : noDisplay) + '\">' + o.timezoneText + '</dt>';\n                html += '<dd class=\"ui_tpicker_timezone' + (showTz ? '' : noDisplay) + '\"></dd>';\n\n                // Create the elements from string\n                html += '</dl></div>';\n                var $tp = $(html);\n\n                // if we only want time picker...\n                if (o.timeOnly === true) {\n                    $tp.prepend('<div class=\"ui-widget-header ui-helper-clearfix ui-corner-all\">' + '<div class=\"ui-datepicker-title\">' + o.timeOnlyTitle + '</div>' + '</div>');\n                    $dp.find('.ui-datepicker-header, .ui-datepicker-calendar').hide();\n                }\n\n                // add sliders, adjust grids, add events\n                for (i = 0, l = tp_inst.units.length; i < l; i++) {\n                    litem = tp_inst.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // add the slider\n                    tp_inst[litem + '_slider'] = tp_inst.control.create(tp_inst, $tp.find('.ui_tpicker_' + litem + '_slider'), litem, tp_inst[litem], o[litem + 'Min'], max[litem], o['step' + uitem]);\n\n                    // adjust the grid and add click event\n                    if (show && o[litem + 'Grid'] > 0) {\n                        size = 100 * gridSize[litem] * o[litem + 'Grid'] / (max[litem] - o[litem + 'Min']);\n                        $tp.find('.ui_tpicker_' + litem + ' table').css({\n                            width: size + \"%\",\n                            marginLeft: o.isRTL ? '0' : ((size / (-2 * gridSize[litem])) + \"%\"),\n                            marginRight: o.isRTL ? ((size / (-2 * gridSize[litem])) + \"%\") : '0',\n                            borderCollapse: 'collapse'\n                        }).find(\"td\").click(function (e) {\n                            var $t = $(this),\n                                h = $t.html(),\n                                n = parseInt(h.replace(/[^0-9]/g), 10),\n                                ap = h.replace(/[^apm]/ig),\n                                f = $t.data('for'); // loses scope, so we use data-for\n\n                            if (f === 'hour') {\n                                if (ap.indexOf('p') !== -1 && n < 12) {\n                                    n += 12;\n                                }\n                                else {\n                                    if (ap.indexOf('a') !== -1 && n === 12) {\n                                        n = 0;\n                                    }\n                                }\n                            }\n\n                            tp_inst.control.value(tp_inst, tp_inst[f + '_slider'], litem, n);\n\n                            tp_inst._onTimeChange();\n                            tp_inst._onSelectHandler();\n                        }).css({\n                            cursor: 'pointer',\n                            width: (100 / gridSize[litem]) + '%',\n                            textAlign: 'center',\n                            overflow: 'hidden'\n                        });\n                    } // end if grid > 0\n                } // end for loop\n\n                // Add timezone options\n                this.timezone_select = $tp.find('.ui_tpicker_timezone').append('<select></select>').find(\"select\");\n                $.fn.append.apply(this.timezone_select,\n                    $.map(o.timezoneList, function (val, idx) {\n                        return $(\"<option />\").val(typeof val === \"object\" ? val.value : val).text(typeof val === \"object\" ? val.label : val);\n                    }));\n                if (typeof(this.timezone) !== \"undefined\" && this.timezone !== null && this.timezone !== \"\") {\n                    var local_timezone = (new Date(this.inst.selectedYear, this.inst.selectedMonth, this.inst.selectedDay, 12)).getTimezoneOffset() * -1;\n                    if (local_timezone === this.timezone) {\n                        selectLocalTimezone(tp_inst);\n                    } else {\n                        this.timezone_select.val(this.timezone);\n                    }\n                } else {\n                    if (typeof(this.hour) !== \"undefined\" && this.hour !== null && this.hour !== \"\") {\n                        this.timezone_select.val(o.timezone);\n                    } else {\n                        selectLocalTimezone(tp_inst);\n                    }\n                }\n                this.timezone_select.change(function () {\n                    tp_inst._onTimeChange();\n                    tp_inst._onSelectHandler();\n                    tp_inst._afterInject();\n                });\n                // End timezone options\n\n                // inject timepicker into datepicker\n                var $buttonPanel = $dp.find('.ui-datepicker-buttonpane');\n                if ($buttonPanel.length) {\n                    $buttonPanel.before($tp);\n                } else {\n                    $dp.append($tp);\n                }\n\n                this.$timeObj = $tp.find('.ui_tpicker_time_input');\n                this.$timeObj.change(function () {\n                    var timeFormat = tp_inst.inst.settings.timeFormat;\n                    var parsedTime = $.datepicker.parseTime(timeFormat, this.value);\n                    var update = new Date();\n                    if (parsedTime) {\n                        update.setHours(parsedTime.hour);\n                        update.setMinutes(parsedTime.minute);\n                        update.setSeconds(parsedTime.second);\n                        $.datepicker._setTime(tp_inst.inst, update);\n                    } else {\n                        this.value = tp_inst.formattedTime;\n                        this.blur();\n                    }\n                });\n\n                if (this.inst !== null) {\n                    var timeDefined = this.timeDefined;\n                    this._onTimeChange();\n                    this.timeDefined = timeDefined;\n                }\n\n                // slideAccess integration: http://trentrichardson.com/2011/11/11/jquery-ui-sliders-and-touch-accessibility/\n                if (this._defaults.addSliderAccess) {\n                    var sliderAccessArgs = this._defaults.sliderAccessArgs,\n                        rtl = this._defaults.isRTL;\n                    sliderAccessArgs.isRTL = rtl;\n\n                    setTimeout(function () { // fix for inline mode\n                        if ($tp.find('.ui-slider-access').length === 0) {\n                            $tp.find('.ui-slider:visible').sliderAccess(sliderAccessArgs);\n\n                            // fix any grids since sliders are shorter\n                            var sliderAccessWidth = $tp.find('.ui-slider-access:eq(0)').outerWidth(true);\n                            if (sliderAccessWidth) {\n                                $tp.find('table:visible').each(function () {\n                                    var $g = $(this),\n                                        oldWidth = $g.outerWidth(),\n                                        oldMarginLeft = $g.css(rtl ? 'marginRight' : 'marginLeft').toString().replace('%', ''),\n                                        newWidth = oldWidth - sliderAccessWidth,\n                                        newMarginLeft = ((oldMarginLeft * newWidth) / oldWidth) + '%',\n                                        css = { width: newWidth, marginRight: 0, marginLeft: 0 };\n                                    css[rtl ? 'marginRight' : 'marginLeft'] = newMarginLeft;\n                                    $g.css(css);\n                                });\n                            }\n                        }\n                    }, 10);\n                }\n                // end slideAccess integration\n\n                tp_inst._limitMinMaxDateTime(this.inst, true);\n            }\n        },\n\n        /*\n        * This function tries to limit the ability to go outside the\n        * min/max date range\n        */\n        _limitMinMaxDateTime: function (dp_inst, adjustSliders) {\n            var o = this._defaults,\n                dp_date = new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay);\n\n            if (!this._defaults.showTimepicker) {\n                return;\n            } // No time so nothing to check here\n\n            if ($.datepicker._get(dp_inst, 'minDateTime') !== null && $.datepicker._get(dp_inst, 'minDateTime') !== undefined && dp_date) {\n                var minDateTime = $.datepicker._get(dp_inst, 'minDateTime'),\n                    minDateTimeDate = new Date(minDateTime.getFullYear(), minDateTime.getMonth(), minDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMinOriginal === null || this.minuteMinOriginal === null || this.secondMinOriginal === null || this.millisecMinOriginal === null || this.microsecMinOriginal === null) {\n                    this.hourMinOriginal = o.hourMin;\n                    this.minuteMinOriginal = o.minuteMin;\n                    this.secondMinOriginal = o.secondMin;\n                    this.millisecMinOriginal = o.millisecMin;\n                    this.microsecMinOriginal = o.microsecMin;\n                }\n\n                if (dp_inst.settings.timeOnly || minDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMin = minDateTime.getHours();\n                    if (this.hour <= this._defaults.hourMin) {\n                        this.hour = this._defaults.hourMin;\n                        this._defaults.minuteMin = minDateTime.getMinutes();\n                        if (this.minute <= this._defaults.minuteMin) {\n                            this.minute = this._defaults.minuteMin;\n                            this._defaults.secondMin = minDateTime.getSeconds();\n                            if (this.second <= this._defaults.secondMin) {\n                                this.second = this._defaults.secondMin;\n                                this._defaults.millisecMin = minDateTime.getMilliseconds();\n                                if (this.millisec <= this._defaults.millisecMin) {\n                                    this.millisec = this._defaults.millisecMin;\n                                    this._defaults.microsecMin = minDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec < this._defaults.microsecMin) {\n                                        this.microsec = this._defaults.microsecMin;\n                                    }\n                                    this._defaults.microsecMin = this.microsecMinOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMin = this.millisecMinOriginal;\n                                this._defaults.microsecMin = this.microsecMinOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMin = this.secondMinOriginal;\n                            this._defaults.millisecMin = this.millisecMinOriginal;\n                            this._defaults.microsecMin = this.microsecMinOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMin = this.minuteMinOriginal;\n                        this._defaults.secondMin = this.secondMinOriginal;\n                        this._defaults.millisecMin = this.millisecMinOriginal;\n                        this._defaults.microsecMin = this.microsecMinOriginal;\n                    }\n                } else {\n                    this._defaults.hourMin = this.hourMinOriginal;\n                    this._defaults.minuteMin = this.minuteMinOriginal;\n                    this._defaults.secondMin = this.secondMinOriginal;\n                    this._defaults.millisecMin = this.millisecMinOriginal;\n                    this._defaults.microsecMin = this.microsecMinOriginal;\n                }\n            }\n\n            if ($.datepicker._get(dp_inst, 'maxDateTime') !== null && $.datepicker._get(dp_inst, 'maxDateTime') !== undefined && dp_date) {\n                var maxDateTime = $.datepicker._get(dp_inst, 'maxDateTime'),\n                    maxDateTimeDate = new Date(maxDateTime.getFullYear(), maxDateTime.getMonth(), maxDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMaxOriginal === null || this.minuteMaxOriginal === null || this.secondMaxOriginal === null || this.millisecMaxOriginal === null) {\n                    this.hourMaxOriginal = o.hourMax;\n                    this.minuteMaxOriginal = o.minuteMax;\n                    this.secondMaxOriginal = o.secondMax;\n                    this.millisecMaxOriginal = o.millisecMax;\n                    this.microsecMaxOriginal = o.microsecMax;\n                }\n\n                if (dp_inst.settings.timeOnly || maxDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMax = maxDateTime.getHours();\n                    if (this.hour >= this._defaults.hourMax) {\n                        this.hour = this._defaults.hourMax;\n                        this._defaults.minuteMax = maxDateTime.getMinutes();\n                        if (this.minute >= this._defaults.minuteMax) {\n                            this.minute = this._defaults.minuteMax;\n                            this._defaults.secondMax = maxDateTime.getSeconds();\n                            if (this.second >= this._defaults.secondMax) {\n                                this.second = this._defaults.secondMax;\n                                this._defaults.millisecMax = maxDateTime.getMilliseconds();\n                                if (this.millisec >= this._defaults.millisecMax) {\n                                    this.millisec = this._defaults.millisecMax;\n                                    this._defaults.microsecMax = maxDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec > this._defaults.microsecMax) {\n                                        this.microsec = this._defaults.microsecMax;\n                                    }\n                                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMax = this.millisecMaxOriginal;\n                                this._defaults.microsecMax = this.microsecMaxOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMax = this.secondMaxOriginal;\n                            this._defaults.millisecMax = this.millisecMaxOriginal;\n                            this._defaults.microsecMax = this.microsecMaxOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMax = this.minuteMaxOriginal;\n                        this._defaults.secondMax = this.secondMaxOriginal;\n                        this._defaults.millisecMax = this.millisecMaxOriginal;\n                        this._defaults.microsecMax = this.microsecMaxOriginal;\n                    }\n                } else {\n                    this._defaults.hourMax = this.hourMaxOriginal;\n                    this._defaults.minuteMax = this.minuteMaxOriginal;\n                    this._defaults.secondMax = this.secondMaxOriginal;\n                    this._defaults.millisecMax = this.millisecMaxOriginal;\n                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                }\n            }\n\n            if (dp_inst.settings.minTime!==null) {\n                var tempMinTime=new Date(\"01/01/1970 \" + dp_inst.settings.minTime);\n                if (this.hour<tempMinTime.getHours()) {\n                    this.hour=this._defaults.hourMin=tempMinTime.getHours();\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else if (this.hour===tempMinTime.getHours() && this.minute<tempMinTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMin<tempMinTime.getHours()) {\n                        this._defaults.hourMin=tempMinTime.getHours();\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else if (this._defaults.hourMin===tempMinTime.getHours()===this.hour && this._defaults.minuteMin<tempMinTime.getMinutes()) {\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMin=0;\n                    }\n                }\n            }\n\n            if (dp_inst.settings.maxTime!==null) {\n                var tempMaxTime=new Date(\"01/01/1970 \" + dp_inst.settings.maxTime);\n                if (this.hour>tempMaxTime.getHours()) {\n                    this.hour=this._defaults.hourMax=tempMaxTime.getHours();\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else if (this.hour===tempMaxTime.getHours() && this.minute>tempMaxTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMax>tempMaxTime.getHours()) {\n                        this._defaults.hourMax=tempMaxTime.getHours();\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else if (this._defaults.hourMax===tempMaxTime.getHours()===this.hour && this._defaults.minuteMax>tempMaxTime.getMinutes()) {\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMax=59;\n                    }\n                }\n            }\n\n            if (adjustSliders !== undefined && adjustSliders === true) {\n                var hourMax = parseInt((this._defaults.hourMax - ((this._defaults.hourMax - this._defaults.hourMin) % this._defaults.stepHour)), 10),\n                    minMax = parseInt((this._defaults.minuteMax - ((this._defaults.minuteMax - this._defaults.minuteMin) % this._defaults.stepMinute)), 10),\n                    secMax = parseInt((this._defaults.secondMax - ((this._defaults.secondMax - this._defaults.secondMin) % this._defaults.stepSecond)), 10),\n                    millisecMax = parseInt((this._defaults.millisecMax - ((this._defaults.millisecMax - this._defaults.millisecMin) % this._defaults.stepMillisec)), 10),\n                    microsecMax = parseInt((this._defaults.microsecMax - ((this._defaults.microsecMax - this._defaults.microsecMin) % this._defaults.stepMicrosec)), 10);\n\n                if (this.hour_slider) {\n                    this.control.options(this, this.hour_slider, 'hour', { min: this._defaults.hourMin, max: hourMax, step: this._defaults.stepHour });\n                    this.control.value(this, this.hour_slider, 'hour', this.hour - (this.hour % this._defaults.stepHour));\n                }\n                if (this.minute_slider) {\n                    this.control.options(this, this.minute_slider, 'minute', { min: this._defaults.minuteMin, max: minMax, step: this._defaults.stepMinute });\n                    this.control.value(this, this.minute_slider, 'minute', this.minute - (this.minute % this._defaults.stepMinute));\n                }\n                if (this.second_slider) {\n                    this.control.options(this, this.second_slider, 'second', { min: this._defaults.secondMin, max: secMax, step: this._defaults.stepSecond });\n                    this.control.value(this, this.second_slider, 'second', this.second - (this.second % this._defaults.stepSecond));\n                }\n                if (this.millisec_slider) {\n                    this.control.options(this, this.millisec_slider, 'millisec', { min: this._defaults.millisecMin, max: millisecMax, step: this._defaults.stepMillisec });\n                    this.control.value(this, this.millisec_slider, 'millisec', this.millisec - (this.millisec % this._defaults.stepMillisec));\n                }\n                if (this.microsec_slider) {\n                    this.control.options(this, this.microsec_slider, 'microsec', { min: this._defaults.microsecMin, max: microsecMax, step: this._defaults.stepMicrosec });\n                    this.control.value(this, this.microsec_slider, 'microsec', this.microsec - (this.microsec % this._defaults.stepMicrosec));\n                }\n            }\n\n        },\n\n        /*\n        * when a slider moves, set the internal time...\n        * on time change is also called when the time is updated in the text field\n        */\n        _onTimeChange: function () {\n            if (!this._defaults.showTimepicker) {\n                return;\n            }\n            var hour = (this.hour_slider) ? this.control.value(this, this.hour_slider, 'hour') : false,\n                minute = (this.minute_slider) ? this.control.value(this, this.minute_slider, 'minute') : false,\n                second = (this.second_slider) ? this.control.value(this, this.second_slider, 'second') : false,\n                millisec = (this.millisec_slider) ? this.control.value(this, this.millisec_slider, 'millisec') : false,\n                microsec = (this.microsec_slider) ? this.control.value(this, this.microsec_slider, 'microsec') : false,\n                timezone = (this.timezone_select) ? this.timezone_select.val() : false,\n                o = this._defaults,\n                pickerTimeFormat = o.pickerTimeFormat || o.timeFormat,\n                pickerTimeSuffix = o.pickerTimeSuffix || o.timeSuffix;\n\n            if (typeof(hour) === 'object') {\n                hour = false;\n            }\n            if (typeof(minute) === 'object') {\n                minute = false;\n            }\n            if (typeof(second) === 'object') {\n                second = false;\n            }\n            if (typeof(millisec) === 'object') {\n                millisec = false;\n            }\n            if (typeof(microsec) === 'object') {\n                microsec = false;\n            }\n            if (typeof(timezone) === 'object') {\n                timezone = false;\n            }\n\n            if (hour !== false) {\n                hour = parseInt(hour, 10);\n            }\n            if (minute !== false) {\n                minute = parseInt(minute, 10);\n            }\n            if (second !== false) {\n                second = parseInt(second, 10);\n            }\n            if (millisec !== false) {\n                millisec = parseInt(millisec, 10);\n            }\n            if (microsec !== false) {\n                microsec = parseInt(microsec, 10);\n            }\n            if (timezone !== false) {\n                timezone = timezone.toString();\n            }\n\n            var ampm = o[hour < 12 ? 'amNames' : 'pmNames'][0];\n\n            // If the update was done in the input field, the input field should not be updated.\n            // If the update was done using the sliders, update the input field.\n            var hasChanged = (\n                hour !== parseInt(this.hour,10) || // sliders should all be numeric\n                minute !== parseInt(this.minute,10) ||\n                second !== parseInt(this.second,10) ||\n                millisec !== parseInt(this.millisec,10) ||\n                microsec !== parseInt(this.microsec,10) ||\n                (this.ampm.length > 0 && (hour < 12) !== ($.inArray(this.ampm.toUpperCase(), this.amNames) !== -1)) ||\n                (this.timezone !== null && timezone !== this.timezone.toString()) // could be numeric or \"EST\" format, so use toString()\n            );\n\n            if (hasChanged) {\n\n                if (hour !== false) {\n                    this.hour = hour;\n                }\n                if (minute !== false) {\n                    this.minute = minute;\n                }\n                if (second !== false) {\n                    this.second = second;\n                }\n                if (millisec !== false) {\n                    this.millisec = millisec;\n                }\n                if (microsec !== false) {\n                    this.microsec = microsec;\n                }\n                if (timezone !== false) {\n                    this.timezone = timezone;\n                }\n\n                if (!this.inst) {\n                    this.inst = $.datepicker._getInst(this.$input[0]);\n                }\n\n                this._limitMinMaxDateTime(this.inst, true);\n            }\n            if (this.support.ampm) {\n                this.ampm = ampm;\n            }\n\n            // Updates the time within the timepicker\n            this.formattedTime = $.datepicker.formatTime(o.timeFormat, this, o);\n            if (this.$timeObj) {\n                if (pickerTimeFormat === o.timeFormat) {\n                    this.$timeObj.val(this.formattedTime + pickerTimeSuffix);\n                }\n                else {\n                    this.$timeObj.val($.datepicker.formatTime(pickerTimeFormat, this, o) + pickerTimeSuffix);\n                }\n                if (this.$timeObj[0].setSelectionRange) {\n                    var sPos = this.$timeObj[0].selectionStart;\n                    var ePos = this.$timeObj[0].selectionEnd;\n                    this.$timeObj[0].setSelectionRange(sPos, ePos);\n                }\n            }\n\n            this.timeDefined = true;\n            if (hasChanged) {\n                this._updateDateTime();\n                //this.$input.focus(); // may automatically open the picker on setDate\n            }\n        },\n\n        /*\n        * call custom onSelect.\n        * bind to sliders slidestop, and grid click.\n        */\n        _onSelectHandler: function () {\n            var onSelect = this._defaults.onSelect || this.inst.settings.onSelect;\n            var inputEl = this.$input ? this.$input[0] : null;\n            if (onSelect && inputEl) {\n                onSelect.apply(inputEl, [this.formattedDateTime, this]);\n            }\n        },\n\n        /*\n        * update our input with the new date time..\n        */\n        _updateDateTime: function (dp_inst) {\n            dp_inst = this.inst || dp_inst;\n            var dtTmp = (dp_inst.currentYear > 0?\n                new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay) :\n                new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                dt = $.datepicker._daylightSavingAdjust(dtTmp),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay)),\n                dateFmt = $.datepicker._get(dp_inst, 'dateFormat'),\n                formatCfg = $.datepicker._getFormatConfig(dp_inst),\n                timeAvailable = dt !== null && this.timeDefined;\n            this.formattedDate = $.datepicker.formatDate(dateFmt, (dt === null ? new Date() : dt), formatCfg);\n            var formattedDateTime = this.formattedDate;\n\n            // if a slider was changed but datepicker doesn't have a value yet, set it\n            if (dp_inst.lastVal === \"\") {\n                dp_inst.currentYear = dp_inst.selectedYear;\n                dp_inst.currentMonth = dp_inst.selectedMonth;\n                dp_inst.currentDay = dp_inst.selectedDay;\n            }\n\n            /*\n            * remove following lines to force every changes in date picker to change the input value\n            * Bug descriptions: when an input field has a default value, and click on the field to pop up the date picker.\n            * If the user manually empty the value in the input field, the date picker will never change selected value.\n            */\n            //if (dp_inst.lastVal !== undefined && (dp_inst.lastVal.length > 0 && this.$input.val().length === 0)) {\n            //\treturn;\n            //}\n\n            if (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === false) {\n                formattedDateTime = this.formattedTime;\n            } else if ((this._defaults.timeOnly !== true && (this._defaults.alwaysSetTime || timeAvailable)) || (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === true)) {\n                formattedDateTime += this._defaults.separator + this.formattedTime + this._defaults.timeSuffix;\n            }\n\n            this.formattedDateTime = formattedDateTime;\n\n            if (!this._defaults.showTimepicker) {\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput && this._defaults.timeOnly === false && this._defaults.altFieldTimeOnly === true) {\n                this.$altInput.val(this.formattedTime);\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput) {\n                this.$input.val(formattedDateTime);\n                var altFormattedDateTime = '',\n                    altSeparator = this._defaults.altSeparator !== null ? this._defaults.altSeparator : this._defaults.separator,\n                    altTimeSuffix = this._defaults.altTimeSuffix !== null ? this._defaults.altTimeSuffix : this._defaults.timeSuffix;\n\n                if (!this._defaults.timeOnly) {\n                    if (this._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(this._defaults.altFormat, (dt === null ? new Date() : dt), formatCfg);\n                    }\n                    else {\n                        altFormattedDateTime = this.formattedDate;\n                    }\n\n                    if (altFormattedDateTime) {\n                        altFormattedDateTime += altSeparator;\n                    }\n                }\n\n                if (this._defaults.altTimeFormat !== null) {\n                    altFormattedDateTime += $.datepicker.formatTime(this._defaults.altTimeFormat, this, this._defaults) + altTimeSuffix;\n                }\n                else {\n                    altFormattedDateTime += this.formattedTime + altTimeSuffix;\n                }\n                this.$altInput.val(altFormattedDateTime);\n            } else {\n                this.$input.val(formattedDateTime);\n            }\n\n            this.$input.trigger(\"change\");\n        },\n\n        _onFocus: function () {\n            if (!this.$input.val() && this._defaults.defaultValue) {\n                this.$input.val(this._defaults.defaultValue);\n                var inst = $.datepicker._getInst(this.$input.get(0)),\n                    tp_inst = $.datepicker._get(inst, 'timepicker');\n                if (tp_inst) {\n                    if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                        try {\n                            $.datepicker._updateDatepicker(inst);\n                        } catch (err) {\n                            $.timepicker.log(err);\n                        }\n                    }\n                }\n            }\n        },\n\n        /*\n        * Small abstraction to control types\n        * We can add more, just be sure to follow the pattern: create, options, value\n        */\n        _controls: {\n            // slider methods\n            slider: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var rtl = tp_inst._defaults.isRTL; // if rtl go -60->0 instead of 0->60\n                    return obj.prop('slide', null).slider({\n                        orientation: \"horizontal\",\n                        value: rtl ? val * -1 : val,\n                        min: rtl ? max * -1 : min,\n                        max: rtl ? min * -1 : max,\n                        step: step,\n                        slide: function (event, ui) {\n                            tp_inst.control.value(tp_inst, $(this), unit, rtl ? ui.value * -1 : ui.value);\n                            tp_inst._onTimeChange();\n                        },\n                        stop: function (event, ui) {\n                            tp_inst._onSelectHandler();\n                        }\n                    });\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (typeof(opts) === 'string') {\n                            if (opts === 'min' || opts === 'max') {\n                                if (val !== undefined) {\n                                    return obj.slider(opts, val * -1);\n                                }\n                                return Math.abs(obj.slider(opts));\n                            }\n                            return obj.slider(opts);\n                        }\n                        var min = opts.min,\n                            max = opts.max;\n                        opts.min = opts.max = null;\n                        if (min !== undefined) {\n                            opts.max = min * -1;\n                        }\n                        if (max !== undefined) {\n                            opts.min = max * -1;\n                        }\n                        return obj.slider(opts);\n                    }\n                    if (typeof(opts) === 'string' && val !== undefined) {\n                        return obj.slider(opts, val);\n                    }\n                    return obj.slider(opts);\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (val !== undefined) {\n                            return obj.slider('value', val * -1);\n                        }\n                        return Math.abs(obj.slider('value'));\n                    }\n                    if (val !== undefined) {\n                        return obj.slider('value', val);\n                    }\n                    return obj.slider('value');\n                }\n            },\n            // select methods\n            select: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var sel = '<select class=\"ui-timepicker-select ui-state-default ui-corner-all\" data-unit=\"' + unit + '\" data-min=\"' + min + '\" data-max=\"' + max + '\" data-step=\"' + step + '\">',\n                        format = tp_inst._defaults.pickerTimeFormat || tp_inst._defaults.timeFormat;\n\n                    for (var i = min; i <= max; i += step) {\n                        sel += '<option value=\"' + i + '\"' + (i === val ? ' selected' : '') + '>';\n                        if (unit === 'hour') {\n                            sel += $.datepicker.formatTime($.trim(format.replace(/[^ht ]/ig, '')), {hour: i}, tp_inst._defaults);\n                        }\n                        else if (unit === 'millisec' || unit === 'microsec' || i >= 10) { sel += i; }\n                        else {sel += '0' + i.toString(); }\n                        sel += '</option>';\n                    }\n                    sel += '</select>';\n\n                    obj.children('select').remove();\n\n                    $(sel).appendTo(obj).change(function (e) {\n                        tp_inst._onTimeChange();\n                        tp_inst._onSelectHandler();\n                        tp_inst._afterInject();\n                    });\n\n                    return obj;\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    var o = {},\n                        $t = obj.children('select');\n                    if (typeof(opts) === 'string') {\n                        if (val === undefined) {\n                            return $t.data(opts);\n                        }\n                        o[opts] = val;\n                    }\n                    else { o = opts; }\n                    return tp_inst.control.create(tp_inst, obj, $t.data('unit'), $t.val(), o.min>=0 ? o.min : $t.data('min'), o.max || $t.data('max'), o.step || $t.data('step'));\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    var $t = obj.children('select');\n                    if (val !== undefined) {\n                        return $t.val(val);\n                    }\n                    return $t.val();\n                }\n            }\n        } // end _controls\n\n    });\n\n    $.fn.extend({\n        /*\n        * shorthand just to use timepicker.\n        */\n        timepicker: function (o) {\n            o = o || {};\n            var tmp_args = Array.prototype.slice.call(arguments);\n\n            if (typeof o === 'object') {\n                tmp_args[0] = $.extend(o, {\n                    timeOnly: true\n                });\n            }\n\n            return $(this).each(function () {\n                $.fn.datetimepicker.apply($(this), tmp_args);\n            });\n        },\n\n        /*\n        * extend timepicker to datepicker\n        */\n        datetimepicker: function (o) {\n            o = o || {};\n            var tmp_args = arguments;\n\n            if (typeof(o) === 'string') {\n                if (o === 'getDate'  || (o === 'option' && tmp_args.length === 2 && typeof (tmp_args[1]) === 'string')) {\n                    return $.fn.datepicker.apply($(this[0]), tmp_args);\n                } else {\n                    return this.each(function () {\n                        var $t = $(this);\n                        $t.datepicker.apply($t, tmp_args);\n                    });\n                }\n            } else {\n                return this.each(function () {\n                    var $t = $(this);\n                    $t.datepicker($.timepicker._newInst($t, o)._defaults);\n                });\n            }\n        }\n    });\n\n    /*\n    * Public Utility to parse date and time\n    */\n    $.datepicker.parseDateTime = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var parseRes = parseDateTimeInternal(dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings);\n        if (parseRes.timeObj) {\n            var t = parseRes.timeObj;\n            parseRes.date.setHours(t.hour, t.minute, t.second, t.millisec);\n            parseRes.date.setMicroseconds(t.microsec);\n        }\n\n        return parseRes.date;\n    };\n\n    /*\n    * Public utility to parse time\n    */\n    $.datepicker.parseTime = function (timeFormat, timeString, options) {\n        var o = extendRemove(extendRemove({}, $.timepicker._defaults), options || {}),\n            iso8601 = (timeFormat.replace(/\\'.*?\\'/g, '').indexOf('Z') !== -1);\n\n        // Strict parse requires the timeString to match the timeFormat exactly\n        var strictParse = function (f, s, o) {\n\n            // pattern for standard and localized AM/PM markers\n            var getPatternAmpm = function (amNames, pmNames) {\n                var markers = [];\n                if (amNames) {\n                    $.merge(markers, amNames);\n                }\n                if (pmNames) {\n                    $.merge(markers, pmNames);\n                }\n                markers = $.map(markers, function (val) {\n                    return val.replace(/[.*+?|()\\[\\]{}\\\\]/g, '\\\\$&');\n                });\n                return '(' + markers.join('|') + ')?';\n            };\n\n            // figure out position of time elements.. cause js cant do named captures\n            var getFormatPositions = function (timeFormat) {\n                var finds = timeFormat.toLowerCase().match(/(h{1,2}|m{1,2}|s{1,2}|l{1}|c{1}|t{1,2}|z|'.*?')/g),\n                    orders = {\n                        h: -1,\n                        m: -1,\n                        s: -1,\n                        l: -1,\n                        c: -1,\n                        t: -1,\n                        z: -1\n                    };\n\n                if (finds) {\n                    for (var i = 0; i < finds.length; i++) {\n                        if (orders[finds[i].toString().charAt(0)] === -1) {\n                            orders[finds[i].toString().charAt(0)] = i + 1;\n                        }\n                    }\n                }\n                return orders;\n            };\n\n            var regstr = '^' + f.toString()\n                    .replace(/([hH]{1,2}|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n                        var ml = match.length;\n                        switch (match.charAt(0).toLowerCase()) {\n                            case 'h':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'm':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 's':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'l':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'c':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'z':\n                                return '(z|[-+]\\\\d\\\\d:?\\\\d\\\\d|\\\\S+)?';\n                            case 't':\n                                return getPatternAmpm(o.amNames, o.pmNames);\n                            default:    // literal escaped in quotes\n                                return '(' + match.replace(/\\'/g, \"\").replace(/(\\.|\\$|\\^|\\\\|\\/|\\(|\\)|\\[|\\]|\\?|\\+|\\*)/g, function (m) { return \"\\\\\" + m; }) + ')?';\n                        }\n                    })\n                    .replace(/\\s/g, '\\\\s?') +\n                o.timeSuffix + '$',\n                order = getFormatPositions(f),\n                ampm = '',\n                treg;\n\n            treg = s.match(new RegExp(regstr, 'i'));\n\n            var resTime = {\n                hour: 0,\n                minute: 0,\n                second: 0,\n                millisec: 0,\n                microsec: 0\n            };\n\n            if (treg) {\n                if (order.t !== -1) {\n                    if (treg[order.t] === undefined || treg[order.t].length === 0) {\n                        ampm = '';\n                        resTime.ampm = '';\n                    } else {\n                        ampm = $.inArray(treg[order.t].toUpperCase(), $.map(o.amNames, function (x,i) { return x.toUpperCase(); })) !== -1 ? 'AM' : 'PM';\n                        resTime.ampm = o[ampm === 'AM' ? 'amNames' : 'pmNames'][0];\n                    }\n                }\n\n                if (order.h !== -1) {\n                    if (ampm === 'AM' && treg[order.h] === '12') {\n                        resTime.hour = 0; // 12am = 0 hour\n                    } else {\n                        if (ampm === 'PM' && treg[order.h] !== '12') {\n                            resTime.hour = parseInt(treg[order.h], 10) + 12; // 12pm = 12 hour, any other pm = hour + 12\n                        } else {\n                            resTime.hour = Number(treg[order.h]);\n                        }\n                    }\n                }\n\n                if (order.m !== -1) {\n                    resTime.minute = Number(treg[order.m]);\n                }\n                if (order.s !== -1) {\n                    resTime.second = Number(treg[order.s]);\n                }\n                if (order.l !== -1) {\n                    resTime.millisec = Number(treg[order.l]);\n                }\n                if (order.c !== -1) {\n                    resTime.microsec = Number(treg[order.c]);\n                }\n                if (order.z !== -1 && treg[order.z] !== undefined) {\n                    resTime.timezone = $.timepicker.timezoneOffsetNumber(treg[order.z]);\n                }\n\n\n                return resTime;\n            }\n            return false;\n        };// end strictParse\n\n        // First try JS Date, if that fails, use strictParse\n        var looseParse = function (f, s, o) {\n            try {\n                var d = new Date('2012-01-01 ' + s);\n                if (isNaN(d.getTime())) {\n                    d = new Date('2012-01-01T' + s);\n                    if (isNaN(d.getTime())) {\n                        d = new Date('01/01/2012 ' + s);\n                        if (isNaN(d.getTime())) {\n                            throw \"Unable to parse time with native Date: \" + s;\n                        }\n                    }\n                }\n\n                return {\n                    hour: d.getHours(),\n                    minute: d.getMinutes(),\n                    second: d.getSeconds(),\n                    millisec: d.getMilliseconds(),\n                    microsec: d.getMicroseconds(),\n                    timezone: d.getTimezoneOffset() * -1\n                };\n            }\n            catch (err) {\n                try {\n                    return strictParse(f, s, o);\n                }\n                catch (err2) {\n                    $.timepicker.log(\"Unable to parse \\ntimeString: \" + s + \"\\ntimeFormat: \" + f);\n                }\n            }\n            return false;\n        }; // end looseParse\n\n        if (typeof o.parse === \"function\") {\n            return o.parse(timeFormat, timeString, o);\n        }\n        if (o.parse === 'loose') {\n            return looseParse(timeFormat, timeString, o);\n        }\n        return strictParse(timeFormat, timeString, o);\n    };\n\n    /**\n     * Public utility to format the time\n     * @param {string} format format of the time\n     * @param {Object} time Object not a Date for timezones\n     * @param {Object} [options] essentially the regional[].. amNames, pmNames, ampm\n     * @returns {string} the formatted time\n     */\n    $.datepicker.formatTime = function (format, time, options) {\n        options = options || {};\n        options = $.extend({}, $.timepicker._defaults, options);\n        time = $.extend({\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null\n        }, time);\n\n        var tmptime = format,\n            ampmName = options.amNames[0],\n            hour = parseInt(time.hour, 10);\n\n        if (hour > 11) {\n            ampmName = options.pmNames[0];\n        }\n\n        tmptime = tmptime.replace(/(?:HH?|hh?|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n            switch (match) {\n                case 'HH':\n                    return ('0' + hour).slice(-2);\n                case 'H':\n                    return hour;\n                case 'hh':\n                    return ('0' + convert24to12(hour)).slice(-2);\n                case 'h':\n                    return convert24to12(hour);\n                case 'mm':\n                    return ('0' + time.minute).slice(-2);\n                case 'm':\n                    return time.minute;\n                case 'ss':\n                    return ('0' + time.second).slice(-2);\n                case 's':\n                    return time.second;\n                case 'l':\n                    return ('00' + time.millisec).slice(-3);\n                case 'c':\n                    return ('00' + time.microsec).slice(-3);\n                case 'z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, false);\n                case 'Z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, true);\n                case 'T':\n                    return ampmName.charAt(0).toUpperCase();\n                case 'TT':\n                    return ampmName.toUpperCase();\n                case 't':\n                    return ampmName.charAt(0).toLowerCase();\n                case 'tt':\n                    return ampmName.toLowerCase();\n                default:\n                    return match.replace(/'/g, \"\");\n            }\n        });\n\n        return tmptime;\n    };\n\n    /*\n    * the bad hack :/ override datepicker so it doesn't close on select\n    // inspired: http://stackoverflow.com/questions/1252512/jquery-datepicker-prevent-closing-picker-when-clicking-a-date/1762378#1762378\n    */\n    $.datepicker._base_selectDate = $.datepicker._selectDate;\n    $.datepicker._selectDate = function (id, dateStr) {\n        var inst = this._getInst($(id)[0]),\n            tp_inst = this._get(inst, 'timepicker'),\n            was_inline;\n\n        if (tp_inst && inst.settings.showTimepicker) {\n            tp_inst._limitMinMaxDateTime(inst, true);\n            was_inline = inst.inline;\n            inst.inline = inst.stay_open = true;\n            //This way the onSelect handler called from calendarpicker get the full dateTime\n            this._base_selectDate(id, dateStr);\n            inst.inline = was_inline;\n            inst.stay_open = false;\n            this._notifyChange(inst);\n            this._updateDatepicker(inst);\n        } else {\n            this._base_selectDate(id, dateStr);\n        }\n    };\n\n    /*\n    * second bad hack :/ override datepicker so it triggers an event when changing the input field\n    * and does not redraw the datepicker on every selectDate event\n    */\n    $.datepicker._base_updateDatepicker = $.datepicker._updateDatepicker;\n    $.datepicker._updateDatepicker = function (inst) {\n\n        // don't popup the datepicker if there is another instance already opened\n        var input = inst.input[0];\n        if ($.datepicker._curInst && $.datepicker._curInst !== inst && $.datepicker._datepickerShowing && $.datepicker._lastInput !== input) {\n            return;\n        }\n\n        if (typeof(inst.stay_open) !== 'boolean' || inst.stay_open === false) {\n\n            this._base_updateDatepicker(inst);\n\n            // Reload the time control when changing something in the input text field.\n            var tp_inst = this._get(inst, 'timepicker');\n            if (tp_inst) {\n                tp_inst._addTimePicker(inst);\n            }\n        }\n    };\n\n    /*\n    * third bad hack :/ override datepicker so it allows spaces and colon in the input field\n    */\n    $.datepicker._base_doKeyPress = $.datepicker._doKeyPress;\n    $.datepicker._doKeyPress = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if ($.datepicker._get(inst, 'constrainInput')) {\n                var ampm = tp_inst.support.ampm,\n                    tz = tp_inst._defaults.showTimezone !== null ? tp_inst._defaults.showTimezone : tp_inst.support.timezone,\n                    dateChars = $.datepicker._possibleChars($.datepicker._get(inst, 'dateFormat')),\n                    datetimeChars = tp_inst._defaults.timeFormat.toString()\n                            .replace(/[hms]/g, '')\n                            .replace(/TT/g, ampm ? 'APM' : '')\n                            .replace(/Tt/g, ampm ? 'AaPpMm' : '')\n                            .replace(/tT/g, ampm ? 'AaPpMm' : '')\n                            .replace(/T/g, ampm ? 'AP' : '')\n                            .replace(/tt/g, ampm ? 'apm' : '')\n                            .replace(/t/g, ampm ? 'ap' : '') +\n                        \" \" + tp_inst._defaults.separator +\n                        tp_inst._defaults.timeSuffix +\n                        (tz ? tp_inst._defaults.timezoneList.join('') : '') +\n                        (tp_inst._defaults.amNames.join('')) + (tp_inst._defaults.pmNames.join('')) +\n                        dateChars,\n                    chr = String.fromCharCode(event.charCode === undefined ? event.keyCode : event.charCode);\n                return event.ctrlKey || (chr < ' ' || !dateChars || datetimeChars.indexOf(chr) > -1);\n            }\n        }\n\n        return $.datepicker._base_doKeyPress(event);\n    };\n\n    /*\n    * Fourth bad hack :/ override _updateAlternate function used in inline mode to init altField\n    * Update any alternate field to synchronise with the main field.\n    */\n    $.datepicker._base_updateAlternate = $.datepicker._updateAlternate;\n    $.datepicker._updateAlternate = function (inst) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var altField = tp_inst._defaults.altField;\n            if (altField) { // update alternate field too\n                var altFormat = tp_inst._defaults.altFormat || tp_inst._defaults.dateFormat,\n                    date = this._getDate(inst),\n                    formatCfg = $.datepicker._getFormatConfig(inst),\n                    altFormattedDateTime = '',\n                    altSeparator = tp_inst._defaults.altSeparator ? tp_inst._defaults.altSeparator : tp_inst._defaults.separator,\n                    altTimeSuffix = tp_inst._defaults.altTimeSuffix ? tp_inst._defaults.altTimeSuffix : tp_inst._defaults.timeSuffix,\n                    altTimeFormat = tp_inst._defaults.altTimeFormat !== null ? tp_inst._defaults.altTimeFormat : tp_inst._defaults.timeFormat;\n\n                altFormattedDateTime += $.datepicker.formatTime(altTimeFormat, tp_inst, tp_inst._defaults) + altTimeSuffix;\n                if (!tp_inst._defaults.timeOnly && !tp_inst._defaults.altFieldTimeOnly && date !== null) {\n                    if (tp_inst._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(tp_inst._defaults.altFormat, date, formatCfg) + altSeparator + altFormattedDateTime;\n                    }\n                    else {\n                        altFormattedDateTime = tp_inst.formattedDate + altSeparator + altFormattedDateTime;\n                    }\n                }\n                $(altField).val( inst.input.val() ? altFormattedDateTime : \"\");\n            }\n        }\n        else {\n            $.datepicker._base_updateAlternate(inst);\n        }\n    };\n\n    /*\n    * Override key up event to sync manual input changes.\n    */\n    $.datepicker._base_doKeyUp = $.datepicker._doKeyUp;\n    $.datepicker._doKeyUp = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                try {\n                    $.datepicker._updateDatepicker(inst);\n                } catch (err) {\n                    $.timepicker.log(err);\n                }\n            }\n        }\n\n        return $.datepicker._base_doKeyUp(event);\n    };\n\n    /*\n    * override \"Today\" button to also grab the time and set it to input field.\n    */\n    $.datepicker._base_gotoToday = $.datepicker._gotoToday;\n    $.datepicker._gotoToday = function (id) {\n        var inst = this._getInst($(id)[0]);\n        this._base_gotoToday(id);\n        var tp_inst = this._get(inst, 'timepicker');\n        if (!tp_inst) {\n            return;\n        }\n\n        var tzoffset = $.timepicker.timezoneOffsetNumber(tp_inst.timezone);\n        var now = new Date();\n        now.setMinutes(now.getMinutes() + now.getTimezoneOffset() + parseInt(tzoffset, 10));\n        this._setTime(inst, now);\n        this._setDate(inst, now);\n        tp_inst._onSelectHandler();\n    };\n\n    /*\n    * Disable & enable the Time in the datetimepicker\n    */\n    $.datepicker._disableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = false;\n            tp_inst._defaults.showTimepicker = false;\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    $.datepicker._enableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = true;\n            tp_inst._defaults.showTimepicker = true;\n            tp_inst._addTimePicker(inst); // Could be disabled on page load\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create our own set time function\n    */\n    $.datepicker._setTime = function (inst, date) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var defaults = tp_inst._defaults;\n\n            // calling _setTime with no date sets time to defaults\n            tp_inst.hour = date ? date.getHours() : defaults.hour;\n            tp_inst.minute = date ? date.getMinutes() : defaults.minute;\n            tp_inst.second = date ? date.getSeconds() : defaults.second;\n            tp_inst.millisec = date ? date.getMilliseconds() : defaults.millisec;\n            tp_inst.microsec = date ? date.getMicroseconds() : defaults.microsec;\n\n            //check if within min/max times..\n            tp_inst._limitMinMaxDateTime(inst, true);\n\n            tp_inst._onTimeChange();\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create new public method to set only time, callable as $().datepicker('setTime', date)\n    */\n    $.datepicker._setTimeDatepicker = function (target, date, withDate) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            this._setDateFromField(inst);\n            var tp_date;\n            if (date) {\n                if (typeof date === \"string\") {\n                    tp_inst._parseTime(date, withDate);\n                    tp_date = new Date();\n                    tp_date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                    tp_date.setMicroseconds(tp_inst.microsec);\n                } else {\n                    tp_date = new Date(date.getTime());\n                    tp_date.setMicroseconds(date.getMicroseconds());\n                }\n                if (tp_date.toString() === 'Invalid Date') {\n                    tp_date = undefined;\n                }\n                this._setTime(inst, tp_date);\n            }\n        }\n\n    };\n\n    /*\n    * override setDate() to allow setting time too within Date object\n    */\n    $.datepicker._base_setDateDatepicker = $.datepicker._setDateDatepicker;\n    $.datepicker._setDateDatepicker = function (target, _date) {\n        var inst = this._getInst(target);\n        var date = _date;\n        if (!inst) {\n            return;\n        }\n\n        if (typeof(_date) === 'string') {\n            date = new Date(_date);\n            if (!date.getTime()) {\n                this._base_setDateDatepicker.apply(this, arguments);\n                date = $(target).datepicker('getDate');\n            }\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        var tp_date;\n        if (date instanceof Date) {\n            tp_date = new Date(date.getTime());\n            tp_date.setMicroseconds(date.getMicroseconds());\n        } else {\n            tp_date = date;\n        }\n\n        // This is important if you are using the timezone option, javascript's Date\n        // object will only return the timezone offset for the current locale, so we\n        // adjust it accordingly.  If not using timezone option this won't matter..\n        // If a timezone is different in tp, keep the timezone as is\n        if (tp_inst && tp_date) {\n            // look out for DST if tz wasn't specified\n            if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                tp_inst.timezone = tp_date.getTimezoneOffset() * -1;\n            }\n            date = $.timepicker.timezoneAdjust(date, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()), tp_inst.timezone);\n            tp_date = $.timepicker.timezoneAdjust(tp_date, $.timepicker.timezoneOffsetString(-tp_date.getTimezoneOffset()), tp_inst.timezone);\n        }\n\n        this._updateDatepicker(inst);\n        this._base_setDateDatepicker.apply(this, arguments);\n        this._setTimeDatepicker(target, tp_date, true);\n    };\n\n    /*\n    * override getDate() to allow getting time too within Date object\n    */\n    $.datepicker._base_getDateDatepicker = $.datepicker._getDateDatepicker;\n    $.datepicker._getDateDatepicker = function (target, noDefault) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            // if it hasn't yet been defined, grab from field\n            if (inst.lastVal === undefined) {\n                this._setDateFromField(inst, noDefault);\n            }\n\n            var date = this._getDate(inst);\n\n            var currDT = null;\n\n            if (tp_inst.$altInput && tp_inst._defaults.altFieldTimeOnly) {\n                currDT = tp_inst.$input.val() + ' ' + tp_inst.$altInput.val();\n            }\n            else if (tp_inst.$input.get(0).tagName !== 'INPUT' && tp_inst.$altInput) {\n                /**\n                 * in case the datetimepicker has been applied to a non-input tag for inline UI,\n                 * and the user has not configured the plugin to display only time in altInput,\n                 * pick current date time from the altInput (and hope for the best, for now, until \"ER1\" is applied)\n                 *\n                 * @todo ER1. Since altInput can have a totally difference format, convert it to standard format by reading input format from \"altFormat\" and \"altTimeFormat\" option values\n                 */\n                currDT = tp_inst.$altInput.val();\n            }\n            else {\n                currDT = tp_inst.$input.val();\n            }\n\n            if (date && tp_inst._parseTime(currDT, !inst.settings.timeOnly)) {\n                date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                date.setMicroseconds(tp_inst.microsec);\n\n                // This is important if you are using the timezone option, javascript's Date\n                // object will only return the timezone offset for the current locale, so we\n                // adjust it accordingly.  If not using timezone option this won't matter..\n                if (tp_inst.timezone != null) {\n                    // look out for DST if tz wasn't specified\n                    if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                        tp_inst.timezone = date.getTimezoneOffset() * -1;\n                    }\n                    date = $.timepicker.timezoneAdjust(date, tp_inst.timezone, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()));\n                }\n            }\n            return date;\n        }\n        return this._base_getDateDatepicker(target, noDefault);\n    };\n\n    /*\n    * override parseDate() because UI 1.8.14 throws an error about \"Extra characters\"\n    * An option in datapicker to ignore extra format characters would be nicer.\n    */\n    $.datepicker._base_parseDate = $.datepicker.parseDate;\n    $.datepicker.parseDate = function (format, value, settings) {\n        var date;\n        try {\n            date = this._base_parseDate(format, value, settings);\n        } catch (err) {\n            // Hack!  The error message ends with a colon, a space, and\n            // the \"extra\" characters.  We rely on that instead of\n            // attempting to perfectly reproduce the parsing algorithm.\n            if (err.indexOf(\":\") >= 0) {\n                date = this._base_parseDate(format, value.substring(0, value.length - (err.length - err.indexOf(':') - 2)), settings);\n                $.timepicker.log(\"Error parsing the date string: \" + err + \"\\ndate string = \" + value + \"\\ndate format = \" + format);\n            } else {\n                throw err;\n            }\n        }\n        return date;\n    };\n\n    /*\n    * override formatDate to set date with time to the input\n    */\n    $.datepicker._base_formatDate = $.datepicker._formatDate;\n    $.datepicker._formatDate = function (inst, day, month, year) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            tp_inst._updateDateTime(inst);\n            return tp_inst.$input.val();\n        }\n        return this._base_formatDate(inst);\n    };\n\n    /*\n    * override options setter to add time to maxDate(Time) and minDate(Time). MaxDate\n    */\n    $.datepicker._base_optionDatepicker = $.datepicker._optionDatepicker;\n    $.datepicker._optionDatepicker = function (target, name, value) {\n        var inst = this._getInst(target),\n            name_clone;\n        if (!inst) {\n            return null;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var min = null,\n                max = null,\n                onselect = null,\n                overrides = tp_inst._defaults.evnts,\n                fns = {},\n                prop,\n                ret,\n                oldVal,\n                $target;\n            if (typeof name === 'string') { // if min/max was set with the string\n                if (name === 'minDate' || name === 'minDateTime') {\n                    min = value;\n                } else if (name === 'maxDate' || name === 'maxDateTime') {\n                    max = value;\n                } else if (name === 'onSelect') {\n                    onselect = value;\n                } else if (overrides.hasOwnProperty(name)) {\n                    if (typeof (value) === 'undefined') {\n                        return overrides[name];\n                    }\n                    fns[name] = value;\n                    name_clone = {}; //empty results in exiting function after overrides updated\n                }\n            } else if (typeof name === 'object') { //if min/max was set with the JSON\n                if (name.minDate) {\n                    min = name.minDate;\n                } else if (name.minDateTime) {\n                    min = name.minDateTime;\n                } else if (name.maxDate) {\n                    max = name.maxDate;\n                } else if (name.maxDateTime) {\n                    max = name.maxDateTime;\n                }\n                for (prop in overrides) {\n                    if (overrides.hasOwnProperty(prop) && name[prop]) {\n                        fns[prop] = name[prop];\n                    }\n                }\n            }\n            for (prop in fns) {\n                if (fns.hasOwnProperty(prop)) {\n                    overrides[prop] = fns[prop];\n                    if (!name_clone) { name_clone = $.extend({}, name); }\n                    delete name_clone[prop];\n                }\n            }\n            if (name_clone && isEmptyObject(name_clone)) { return; }\n            if (min) { //if min was set\n                if (min === 0) {\n                    min = new Date();\n                } else {\n                    min = new Date(min);\n                }\n                tp_inst._defaults.minDate = min;\n                tp_inst._defaults.minDateTime = min;\n            } else if (max) { //if max was set\n                if (max === 0) {\n                    max = new Date();\n                } else {\n                    max = new Date(max);\n                }\n                tp_inst._defaults.maxDate = max;\n                tp_inst._defaults.maxDateTime = max;\n            } else if (onselect) {\n                tp_inst._defaults.onSelect = onselect;\n            }\n\n            // Datepicker will override our date when we call _base_optionDatepicker when\n            // calling minDate/maxDate, so we will first grab the value, call\n            // _base_optionDatepicker, then set our value back.\n            if(min || max){\n                $target = $(target);\n                oldVal = $target.datetimepicker('getDate');\n                ret = this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n                $target.datetimepicker('setDate', oldVal);\n                return ret;\n            }\n        }\n        if (value === undefined) {\n            return this._base_optionDatepicker.call($.datepicker, target, name);\n        }\n        return this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n    };\n\n    /*\n    * jQuery isEmptyObject does not check hasOwnProperty - if someone has added to the object prototype,\n    * it will return false for all objects\n    */\n    var isEmptyObject = function (obj) {\n        var prop;\n        for (prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                return false;\n            }\n        }\n        return true;\n    };\n\n    /*\n    * jQuery extend now ignores nulls!\n    */\n    var extendRemove = function (target, props) {\n        $.extend(target, props);\n        for (var name in props) {\n            if (props[name] === null || props[name] === undefined) {\n                target[name] = props[name];\n            }\n        }\n        return target;\n    };\n\n    /*\n    * Determine by the time format which units are supported\n    * Returns an object of booleans for each unit\n    */\n    var detectSupport = function (timeFormat) {\n        var tf = timeFormat.replace(/'.*?'/g, '').toLowerCase(), // removes literals\n            isIn = function (f, t) { // does the format contain the token?\n                return f.indexOf(t) !== -1 ? true : false;\n            };\n        return {\n            hour: isIn(tf, 'h'),\n            minute: isIn(tf, 'm'),\n            second: isIn(tf, 's'),\n            millisec: isIn(tf, 'l'),\n            microsec: isIn(tf, 'c'),\n            timezone: isIn(tf, 'z'),\n            ampm: isIn(tf, 't') && isIn(timeFormat, 'h'),\n            iso8601: isIn(timeFormat, 'Z')\n        };\n    };\n\n    /*\n    * Converts 24 hour format into 12 hour\n    * Returns 12 hour without leading 0\n    */\n    var convert24to12 = function (hour) {\n        hour %= 12;\n\n        if (hour === 0) {\n            hour = 12;\n        }\n\n        return String(hour);\n    };\n\n    var computeEffectiveSetting = function (settings, property) {\n        return settings && settings[property] ? settings[property] : $.timepicker._defaults[property];\n    };\n\n    /*\n    * Splits datetime string into date and time substrings.\n    * Throws exception when date can't be parsed\n    * Returns {dateString: dateString, timeString: timeString}\n    */\n    var splitDateTime = function (dateTimeString, timeSettings) {\n        // The idea is to get the number separator occurrences in datetime and the time format requested (since time has\n        // fewer unknowns, mostly numbers and am/pm). We will use the time pattern to split.\n        var separator = computeEffectiveSetting(timeSettings, 'separator'),\n            format = computeEffectiveSetting(timeSettings, 'timeFormat'),\n            timeParts = format.split(separator), // how many occurrences of separator may be in our format?\n            timePartsLen = timeParts.length,\n            allParts = dateTimeString.split(separator),\n            allPartsLen = allParts.length;\n\n        if (allPartsLen > 1) {\n            return {\n                dateString: allParts.splice(0, allPartsLen - timePartsLen).join(separator),\n                timeString: allParts.splice(0, timePartsLen).join(separator)\n            };\n        }\n\n        return {\n            dateString: dateTimeString,\n            timeString: ''\n        };\n    };\n\n    /*\n    * Internal function to parse datetime interval\n    * Returns: {date: Date, timeObj: Object}, where\n    *   date - parsed date without time (type Date)\n    *   timeObj = {hour: , minute: , second: , millisec: , microsec: } - parsed time. Optional\n    */\n    var parseDateTimeInternal = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var date,\n            parts,\n            parsedTime;\n\n        parts = splitDateTime(dateTimeString, timeSettings);\n        date = $.datepicker._base_parseDate(dateFormat, parts.dateString, dateSettings);\n\n        if (parts.timeString === '') {\n            return {\n                date: date\n            };\n        }\n\n        parsedTime = $.datepicker.parseTime(timeFormat, parts.timeString, timeSettings);\n\n        if (!parsedTime) {\n            throw 'Wrong time format';\n        }\n\n        return {\n            date: date,\n            timeObj: parsedTime\n        };\n    };\n\n    /*\n    * Internal function to set timezone_select to the local timezone\n    */\n    var selectLocalTimezone = function (tp_inst, date) {\n        if (tp_inst && tp_inst.timezone_select) {\n            var now = date || new Date();\n            tp_inst.timezone_select.val(-now.getTimezoneOffset());\n        }\n    };\n\n    /*\n    * Create a Singleton Instance\n    */\n    $.timepicker = new Timepicker();\n\n    /**\n     * Get the timezone offset as string from a date object (eg '+0530' for UTC+5.5)\n     * @param {number} tzMinutes if not a number, less than -720 (-1200), or greater than 840 (+1400) this value is returned\n     * @param {boolean} iso8601 if true formats in accordance to iso8601 \"+12:45\"\n     * @return {string}\n     */\n    $.timepicker.timezoneOffsetString = function (tzMinutes, iso8601) {\n        if (isNaN(tzMinutes) || tzMinutes > 840 || tzMinutes < -720) {\n            return tzMinutes;\n        }\n\n        var off = tzMinutes,\n            minutes = off % 60,\n            hours = (off - minutes) / 60,\n            iso = iso8601 ? ':' : '',\n            tz = (off >= 0 ? '+' : '-') + ('0' + Math.abs(hours)).slice(-2) + iso + ('0' + Math.abs(minutes)).slice(-2);\n\n        if (tz === '+00:00') {\n            return 'Z';\n        }\n        return tz;\n    };\n\n    /**\n     * Get the number in minutes that represents a timezone string\n     * @param  {string} tzString formatted like \"+0500\", \"-1245\", \"Z\"\n     * @return {number} the offset minutes or the original string if it doesn't match expectations\n     */\n    $.timepicker.timezoneOffsetNumber = function (tzString) {\n        var normalized = tzString.toString().replace(':', ''); // excuse any iso8601, end up with \"+1245\"\n\n        if (normalized.toUpperCase() === 'Z') { // if iso8601 with Z, its 0 minute offset\n            return 0;\n        }\n\n        if (!/^(\\-|\\+)\\d{4}$/.test(normalized)) { // possibly a user defined tz, so just give it back\n            return parseInt(tzString, 10);\n        }\n\n        return ((normalized.substr(0, 1) === '-' ? -1 : 1) * // plus or minus\n            ((parseInt(normalized.substr(1, 2), 10) * 60) + // hours (converted to minutes)\n                parseInt(normalized.substr(3, 2), 10))); // minutes\n    };\n\n    /**\n     * No way to set timezone in js Date, so we must adjust the minutes to compensate. (think setDate, getDate)\n     * @param  {Date} date\n     * @param  {string} fromTimezone formatted like \"+0500\", \"-1245\"\n     * @param  {string} toTimezone formatted like \"+0500\", \"-1245\"\n     * @return {Date}\n     */\n    $.timepicker.timezoneAdjust = function (date, fromTimezone, toTimezone) {\n        var fromTz = $.timepicker.timezoneOffsetNumber(fromTimezone);\n        var toTz = $.timepicker.timezoneOffsetNumber(toTimezone);\n        if (!isNaN(toTz)) {\n            date.setMinutes(date.getMinutes() + (-fromTz) - (-toTz));\n        }\n        return date;\n    };\n\n    /**\n     * Calls `timepicker()` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * n.b. The input value must be correctly formatted (reformatting is not supported)\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the timepicker() call\n     * @return {jQuery}\n     */\n    $.timepicker.timeRange = function (startTime, endTime, options) {\n        return $.timepicker.handleRange('timepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datetimepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @return {jQuery}\n     */\n    $.timepicker.datetimeRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datetimepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.dateRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `method` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.handleRange = function (method, startTime, endTime, options) {\n        options = $.extend({}, {\n            minInterval: 0, // min allowed interval in milliseconds\n            maxInterval: 0, // max allowed interval in milliseconds\n            start: {},      // options for start picker\n            end: {}         // options for end picker\n        }, options);\n\n        // for the mean time this fixes an issue with calling getDate with timepicker()\n        var timeOnly = false;\n        if(method === 'timepicker'){\n            timeOnly = true;\n            method = 'datetimepicker';\n        }\n\n        function checkDates(changed, other) {\n            var startdt = startTime[method]('getDate'),\n                enddt = endTime[method]('getDate'),\n                changeddt = changed[method]('getDate');\n\n            if (startdt !== null) {\n                var minDate = new Date(startdt.getTime()),\n                    maxDate = new Date(startdt.getTime());\n\n                minDate.setMilliseconds(minDate.getMilliseconds() + options.minInterval);\n                maxDate.setMilliseconds(maxDate.getMilliseconds() + options.maxInterval);\n\n                if (options.minInterval > 0 && minDate > enddt) { // minInterval check\n                    endTime[method]('setDate', minDate);\n                }\n                else if (options.maxInterval > 0 && maxDate < enddt) { // max interval check\n                    endTime[method]('setDate', maxDate);\n                }\n                else if (startdt > enddt) {\n                    other[method]('setDate', changeddt);\n                }\n            }\n        }\n\n        function selected(changed, other, option) {\n            if (!changed.val()) {\n                return;\n            }\n            var date = changed[method].call(changed, 'getDate');\n            if (date !== null && options.minInterval > 0) {\n                if (option === 'minDate') {\n                    date.setMilliseconds(date.getMilliseconds() + options.minInterval);\n                }\n                if (option === 'maxDate') {\n                    date.setMilliseconds(date.getMilliseconds() - options.minInterval);\n                }\n            }\n\n            if (date.getTime) {\n                other[method].call(other, 'option', option, date);\n            }\n        }\n\n        $.fn[method].call(startTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), endTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), endTime, 'minDate');\n            }\n        }, options, options.start));\n        $.fn[method].call(endTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), startTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), startTime, 'maxDate');\n            }\n        }, options, options.end));\n\n        checkDates(startTime, endTime);\n\n        selected(startTime, endTime, 'minDate');\n        selected(endTime, startTime, 'maxDate');\n\n        return $([startTime.get(0), endTime.get(0)]);\n    };\n\n    /**\n     * Log error or data to the console during error or debugging\n     * @param  {Object} err pass any type object to log to the console during error or debugging\n     * @return {void}\n     */\n    $.timepicker.log = function () {\n        // Older IE (9, maybe 10) throw error on accessing `window.console.log.apply`, so check first.\n        if (window.console && window.console.log && window.console.log.apply) {\n            window.console.log.apply(window.console, Array.prototype.slice.call(arguments));\n        }\n    };\n\n    /*\n     * Add util object to allow access to private methods for testability.\n     */\n    $.timepicker._util = {\n        _extendRemove: extendRemove,\n        _isEmptyObject: isEmptyObject,\n        _convert24to12: convert24to12,\n        _detectSupport: detectSupport,\n        _selectLocalTimezone: selectLocalTimezone,\n        _computeEffectiveSetting: computeEffectiveSetting,\n        _splitDateTime: splitDateTime,\n        _parseDateTimeInternal: parseDateTimeInternal\n    };\n\n    /*\n    * Microsecond support\n    */\n    if (!Date.prototype.getMicroseconds) {\n        Date.prototype.microseconds = 0;\n        Date.prototype.getMicroseconds = function () { return this.microseconds; };\n        Date.prototype.setMicroseconds = function (m) {\n            this.setMilliseconds(this.getMilliseconds() + Math.floor(m / 1000));\n            this.microseconds = m % 1000;\n            return this;\n        };\n    }\n\n    /*\n    * Keep up with the version\n    */\n    $.timepicker.version = \"1.6.3\";\n\n}));\n","jquery/jquery.parsequery.js":"/**\n * Copyright (c) 2010 Conrad Irwin <conrad@rapportive.com> MIT license.\n * Based loosely on original: Copyright (c) 2008 mkmanning MIT license.\n *\n * Parses CGI query strings into javascript objects.\n *\n * See the README for details.\n **/\ndefine([\n    \"jquery\"\n], function($){\n    $.parseQuery = function (options) {\n\n        var config = {query: window.location.search || \"\"},\n            params = {};\n\n        if (typeof options === 'string') {\n            options = {query: options};\n        }\n        $.extend(config, $.parseQuery, options);\n        config.query = config.query.replace(/^\\?/, '');\n\n        if (config.query.length > 0) {\n            $.each(config.query.split(config.separator), function (i, param) {\n                var pair = param.split('='),\n                    key = config.decode(pair.shift(), null).toString(),\n                    value = config.decode(pair.length ? pair.join('=') : null, key);\n\n                if (config.array_keys.test ? config.array_keys.test(key) : config.array_keys(key)) {\n                    params[key] = params[key] || [];\n                    params[key].push(value);\n                } else {\n                    params[key] = value;\n                }\n            });\n        }\n        return params;\n    };\n    $.parseQuery.decode = $.parseQuery.default_decode = function (string) {\n        return decodeURIComponent((string || \"\").replace(/\\+/g, ' '));\n    };\n    $.parseQuery.array_keys = function () {\n        return false;\n    };\n    $.parseQuery.separator = \"&\";\n});\n","jquery/jquery.cookie.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-cookie/cookie-wrapper'\n], function () {\n\n});\n","jquery/jquery-ui-timepicker-addon.js":"/*! jQuery Timepicker Addon - v1.6.3 - 2016-04-20\n* http://trentrichardson.com/examples/timepicker\n* Copyright (c) 2016 Trent Richardson; Licensed MIT */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery', 'jquery/ui'], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n    /*\n    * Lets not redefine timepicker, Prevent \"Uncaught RangeError: Maximum call stack size exceeded\"\n    */\n    $.ui.timepicker = $.ui.timepicker || {};\n    if ($.ui.timepicker.version) {\n        return;\n    }\n\n    /*\n    * Extend jQueryUI, get it started with our version number\n    */\n    $.extend($.ui, {\n        timepicker: {\n            version: \"1.6.3\"\n        }\n    });\n\n    /*\n    * Timepicker manager.\n    * Use the singleton instance of this class, $.timepicker, to interact with the time picker.\n    * Settings for (groups of) time pickers are maintained in an instance object,\n    * allowing multiple different settings on the same page.\n    */\n    var Timepicker = function () {\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[''] = { // Default regional settings\n            currentText: 'Now',\n            closeText: 'Done',\n            amNames: ['AM', 'A'],\n            pmNames: ['PM', 'P'],\n            timeFormat: 'HH:mm',\n            timeSuffix: '',\n            timeOnlyTitle: 'Choose Time',\n            timeText: 'Time',\n            hourText: 'Hour',\n            minuteText: 'Minute',\n            secondText: 'Second',\n            millisecText: 'Millisecond',\n            microsecText: 'Microsecond',\n            timezoneText: 'Time Zone',\n            isRTL: false\n        };\n        this._defaults = { // Global defaults for all the datetime picker instances\n            showButtonPanel: true,\n            timeOnly: false,\n            timeOnlyShowDate: false,\n            showHour: null,\n            showMinute: null,\n            showSecond: null,\n            showMillisec: null,\n            showMicrosec: null,\n            showTimezone: null,\n            showTime: true,\n            stepHour: 1,\n            stepMinute: 1,\n            stepSecond: 1,\n            stepMillisec: 1,\n            stepMicrosec: 1,\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null,\n            hourMin: 0,\n            minuteMin: 0,\n            secondMin: 0,\n            millisecMin: 0,\n            microsecMin: 0,\n            hourMax: 23,\n            minuteMax: 59,\n            secondMax: 59,\n            millisecMax: 999,\n            microsecMax: 999,\n            minDateTime: null,\n            maxDateTime: null,\n            maxTime: null,\n            minTime: null,\n            onSelect: null,\n            hourGrid: 0,\n            minuteGrid: 0,\n            secondGrid: 0,\n            millisecGrid: 0,\n            microsecGrid: 0,\n            alwaysSetTime: true,\n            separator: ' ',\n            altFieldTimeOnly: true,\n            altTimeFormat: null,\n            altSeparator: null,\n            altTimeSuffix: null,\n            altRedirectFocus: true,\n            pickerTimeFormat: null,\n            pickerTimeSuffix: null,\n            showTimepicker: true,\n            timezoneList: null,\n            addSliderAccess: false,\n            sliderAccessArgs: null,\n            controlType: 'slider',\n            oneLine: false,\n            defaultValue: null,\n            parse: 'strict',\n            afterInject: null\n        };\n        $.extend(this._defaults, this.regional['']);\n    };\n\n    $.extend(Timepicker.prototype, {\n        $input: null,\n        $altInput: null,\n        $timeObj: null,\n        inst: null,\n        hour_slider: null,\n        minute_slider: null,\n        second_slider: null,\n        millisec_slider: null,\n        microsec_slider: null,\n        timezone_select: null,\n        maxTime: null,\n        minTime: null,\n        hour: 0,\n        minute: 0,\n        second: 0,\n        millisec: 0,\n        microsec: 0,\n        timezone: null,\n        hourMinOriginal: null,\n        minuteMinOriginal: null,\n        secondMinOriginal: null,\n        millisecMinOriginal: null,\n        microsecMinOriginal: null,\n        hourMaxOriginal: null,\n        minuteMaxOriginal: null,\n        secondMaxOriginal: null,\n        millisecMaxOriginal: null,\n        microsecMaxOriginal: null,\n        ampm: '',\n        formattedDate: '',\n        formattedTime: '',\n        formattedDateTime: '',\n        timezoneList: null,\n        units: ['hour', 'minute', 'second', 'millisec', 'microsec'],\n        support: {},\n        control: null,\n\n        /*\n        * Override the default settings for all instances of the time picker.\n        * @param  {Object} settings  object - the new settings to use as defaults (anonymous object)\n        * @return {Object} the manager object\n        */\n        setDefaults: function (settings) {\n            extendRemove(this._defaults, settings || {});\n            return this;\n        },\n\n        /*\n        * Create a new Timepicker instance\n        */\n        _newInst: function ($input, opts) {\n            var tp_inst = new Timepicker(),\n                inlineSettings = {},\n                fns = {},\n                overrides, i;\n\n            for (var attrName in this._defaults) {\n                if (this._defaults.hasOwnProperty(attrName)) {\n                    var attrValue = $input.attr('time:' + attrName);\n                    if (attrValue) {\n                        try {\n                            inlineSettings[attrName] = eval(attrValue);\n                        } catch (err) {\n                            inlineSettings[attrName] = attrValue;\n                        }\n                    }\n                }\n            }\n\n            overrides = {\n                beforeShow: function (input, dp_inst) {\n                    if ($.isFunction(tp_inst._defaults.evnts.beforeShow)) {\n                        return tp_inst._defaults.evnts.beforeShow.call($input[0], input, dp_inst, tp_inst);\n                    }\n                },\n                onChangeMonthYear: function (year, month, dp_inst) {\n                    // Update the time as well : this prevents the time from disappearing from the $input field.\n                    // tp_inst._updateDateTime(dp_inst);\n                    if ($.isFunction(tp_inst._defaults.evnts.onChangeMonthYear)) {\n                        tp_inst._defaults.evnts.onChangeMonthYear.call($input[0], year, month, dp_inst, tp_inst);\n                    }\n                },\n                onClose: function (dateText, dp_inst) {\n                    if (tp_inst.timeDefined === true && $input.val() !== '') {\n                        tp_inst._updateDateTime(dp_inst);\n                    }\n                    if ($.isFunction(tp_inst._defaults.evnts.onClose)) {\n                        tp_inst._defaults.evnts.onClose.call($input[0], dateText, dp_inst, tp_inst);\n                    }\n                }\n            };\n            for (i in overrides) {\n                if (overrides.hasOwnProperty(i)) {\n                    fns[i] = opts[i] || this._defaults[i] || null;\n                }\n            }\n\n            tp_inst._defaults = $.extend({}, this._defaults, inlineSettings, opts, overrides, {\n                evnts: fns,\n                timepicker: tp_inst // add timepicker as a property of datepicker: $.datepicker._get(dp_inst, 'timepicker');\n            });\n            tp_inst.amNames = $.map(tp_inst._defaults.amNames, function (val) {\n                return val.toUpperCase();\n            });\n            tp_inst.pmNames = $.map(tp_inst._defaults.pmNames, function (val) {\n                return val.toUpperCase();\n            });\n\n            // detect which units are supported\n            tp_inst.support = detectSupport(\n                tp_inst._defaults.timeFormat +\n                (tp_inst._defaults.pickerTimeFormat ? tp_inst._defaults.pickerTimeFormat : '') +\n                (tp_inst._defaults.altTimeFormat ? tp_inst._defaults.altTimeFormat : ''));\n\n            // controlType is string - key to our this._controls\n            if (typeof(tp_inst._defaults.controlType) === 'string') {\n                if (tp_inst._defaults.controlType === 'slider' && typeof($.ui.slider) === 'undefined') {\n                    tp_inst._defaults.controlType = 'select';\n                }\n                tp_inst.control = tp_inst._controls[tp_inst._defaults.controlType];\n            }\n            // controlType is an object and must implement create, options, value methods\n            else {\n                tp_inst.control = tp_inst._defaults.controlType;\n            }\n\n            // prep the timezone options\n            var timezoneList = [-720, -660, -600, -570, -540, -480, -420, -360, -300, -270, -240, -210, -180, -120, -60,\n                0, 60, 120, 180, 210, 240, 270, 300, 330, 345, 360, 390, 420, 480, 525, 540, 570, 600, 630, 660, 690, 720, 765, 780, 840];\n            if (tp_inst._defaults.timezoneList !== null) {\n                timezoneList = tp_inst._defaults.timezoneList;\n            }\n            var tzl = timezoneList.length, tzi = 0, tzv = null;\n            if (tzl > 0 && typeof timezoneList[0] !== 'object') {\n                for (; tzi < tzl; tzi++) {\n                    tzv = timezoneList[tzi];\n                    timezoneList[tzi] = { value: tzv, label: $.timepicker.timezoneOffsetString(tzv, tp_inst.support.iso8601) };\n                }\n            }\n            tp_inst._defaults.timezoneList = timezoneList;\n\n            // set the default units\n            tp_inst.timezone = tp_inst._defaults.timezone !== null ? $.timepicker.timezoneOffsetNumber(tp_inst._defaults.timezone) :\n                ((new Date()).getTimezoneOffset() * -1);\n            tp_inst.hour = tp_inst._defaults.hour < tp_inst._defaults.hourMin ? tp_inst._defaults.hourMin :\n                tp_inst._defaults.hour > tp_inst._defaults.hourMax ? tp_inst._defaults.hourMax : tp_inst._defaults.hour;\n            tp_inst.minute = tp_inst._defaults.minute < tp_inst._defaults.minuteMin ? tp_inst._defaults.minuteMin :\n                tp_inst._defaults.minute > tp_inst._defaults.minuteMax ? tp_inst._defaults.minuteMax : tp_inst._defaults.minute;\n            tp_inst.second = tp_inst._defaults.second < tp_inst._defaults.secondMin ? tp_inst._defaults.secondMin :\n                tp_inst._defaults.second > tp_inst._defaults.secondMax ? tp_inst._defaults.secondMax : tp_inst._defaults.second;\n            tp_inst.millisec = tp_inst._defaults.millisec < tp_inst._defaults.millisecMin ? tp_inst._defaults.millisecMin :\n                tp_inst._defaults.millisec > tp_inst._defaults.millisecMax ? tp_inst._defaults.millisecMax : tp_inst._defaults.millisec;\n            tp_inst.microsec = tp_inst._defaults.microsec < tp_inst._defaults.microsecMin ? tp_inst._defaults.microsecMin :\n                tp_inst._defaults.microsec > tp_inst._defaults.microsecMax ? tp_inst._defaults.microsecMax : tp_inst._defaults.microsec;\n            tp_inst.ampm = '';\n            tp_inst.$input = $input;\n\n            if (tp_inst._defaults.altField) {\n                tp_inst.$altInput = $(tp_inst._defaults.altField);\n                if (tp_inst._defaults.altRedirectFocus === true) {\n                    tp_inst.$altInput.css({\n                        cursor: 'pointer'\n                    }).focus(function () {\n                        $input.trigger(\"focus\");\n                    });\n                }\n            }\n\n            if (tp_inst._defaults.minDate === 0 || tp_inst._defaults.minDateTime === 0) {\n                tp_inst._defaults.minDate = new Date();\n            }\n            if (tp_inst._defaults.maxDate === 0 || tp_inst._defaults.maxDateTime === 0) {\n                tp_inst._defaults.maxDate = new Date();\n            }\n\n            // datepicker needs minDate/maxDate, timepicker needs minDateTime/maxDateTime..\n            if (tp_inst._defaults.minDate !== undefined && tp_inst._defaults.minDate instanceof Date) {\n                tp_inst._defaults.minDateTime = new Date(tp_inst._defaults.minDate.getTime());\n            }\n            if (tp_inst._defaults.minDateTime !== undefined && tp_inst._defaults.minDateTime instanceof Date) {\n                tp_inst._defaults.minDate = new Date(tp_inst._defaults.minDateTime.getTime());\n            }\n            if (tp_inst._defaults.maxDate !== undefined && tp_inst._defaults.maxDate instanceof Date) {\n                tp_inst._defaults.maxDateTime = new Date(tp_inst._defaults.maxDate.getTime());\n            }\n            if (tp_inst._defaults.maxDateTime !== undefined && tp_inst._defaults.maxDateTime instanceof Date) {\n                tp_inst._defaults.maxDate = new Date(tp_inst._defaults.maxDateTime.getTime());\n            }\n            tp_inst.$input.bind('focus', function () {\n                tp_inst._onFocus();\n            });\n\n            return tp_inst;\n        },\n\n        /*\n        * add our sliders to the calendar\n        */\n        _addTimePicker: function (dp_inst) {\n            var currDT = $.trim((this.$altInput && this._defaults.altFieldTimeOnly) ? this.$input.val() + ' ' + this.$altInput.val() : this.$input.val());\n\n            this.timeDefined = this._parseTime(currDT);\n            this._limitMinMaxDateTime(dp_inst, false);\n            this._injectTimePicker();\n            this._afterInject();\n        },\n\n        /*\n        * parse the time string from input value or _setTime\n        */\n        _parseTime: function (timeString, withDate) {\n            if (!this.inst) {\n                this.inst = $.datepicker._getInst(this.$input[0]);\n            }\n\n            if (withDate || !this._defaults.timeOnly) {\n                var dp_dateFormat = $.datepicker._get(this.inst, 'dateFormat');\n                try {\n                    var parseRes = parseDateTimeInternal(dp_dateFormat, this._defaults.timeFormat, timeString, $.datepicker._getFormatConfig(this.inst), this._defaults);\n                    if (!parseRes.timeObj) {\n                        return false;\n                    }\n                    $.extend(this, parseRes.timeObj);\n                } catch (err) {\n                    $.timepicker.log(\"Error parsing the date/time string: \" + err +\n                        \"\\ndate/time string = \" + timeString +\n                        \"\\ntimeFormat = \" + this._defaults.timeFormat +\n                        \"\\ndateFormat = \" + dp_dateFormat);\n                    return false;\n                }\n                return true;\n            } else {\n                var timeObj = $.datepicker.parseTime(this._defaults.timeFormat, timeString, this._defaults);\n                if (!timeObj) {\n                    return false;\n                }\n                $.extend(this, timeObj);\n                return true;\n            }\n        },\n\n        /*\n        * Handle callback option after injecting timepicker\n        */\n        _afterInject: function() {\n            var o = this.inst.settings;\n            if ($.isFunction(o.afterInject)) {\n                o.afterInject.call(this);\n            }\n        },\n\n        /*\n        * generate and inject html for timepicker into ui datepicker\n        */\n        _injectTimePicker: function () {\n            var $dp = this.inst.dpDiv,\n                o = this.inst.settings,\n                tp_inst = this,\n                litem = '',\n                uitem = '',\n                show = null,\n                max = {},\n                gridSize = {},\n                size = null,\n                i = 0,\n                l = 0;\n\n            // Prevent displaying twice\n            if ($dp.find(\"div.ui-timepicker-div\").length === 0 && o.showTimepicker) {\n                var noDisplay = ' ui_tpicker_unit_hide',\n                    html = '<div class=\"ui-timepicker-div' + (o.isRTL ? ' ui-timepicker-rtl' : '') + (o.oneLine && o.controlType === 'select' ? ' ui-timepicker-oneLine' : '') + '\"><dl>' + '<dt class=\"ui_tpicker_time_label' + ((o.showTime) ? '' : noDisplay) + '\">' + o.timeText + '</dt>' +\n                        '<dd class=\"ui_tpicker_time '+ ((o.showTime) ? '' : noDisplay) + '\"><input class=\"ui_tpicker_time_input\" ' + (o.timeInput ? '' : 'disabled') + '/></dd>';\n\n                // Create the markup\n                for (i = 0, l = this.units.length; i < l; i++) {\n                    litem = this.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // Added by Peter Medeiros:\n                    // - Figure out what the hour/minute/second max should be based on the step values.\n                    // - Example: if stepMinute is 15, then minMax is 45.\n                    max[litem] = parseInt((o[litem + 'Max'] - ((o[litem + 'Max'] - o[litem + 'Min']) % o['step' + uitem])), 10);\n                    gridSize[litem] = 0;\n\n                    html += '<dt class=\"ui_tpicker_' + litem + '_label' + (show ? '' : noDisplay) + '\">' + o[litem + 'Text'] + '</dt>' +\n                        '<dd class=\"ui_tpicker_' + litem + (show ? '' : noDisplay) + '\"><div class=\"ui_tpicker_' + litem + '_slider' + (show ? '' : noDisplay) + '\"></div>';\n\n                    if (show && o[litem + 'Grid'] > 0) {\n                        html += '<div style=\"padding-left: 1px\"><table class=\"ui-tpicker-grid-label\"><tr>';\n\n                        if (litem === 'hour') {\n                            for (var h = o[litem + 'Min']; h <= max[litem]; h += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                var tmph = $.datepicker.formatTime(this.support.ampm ? 'hht' : 'HH', {hour: h}, o);\n                                html += '<td data-for=\"' + litem + '\">' + tmph + '</td>';\n                            }\n                        }\n                        else {\n                            for (var m = o[litem + 'Min']; m <= max[litem]; m += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                html += '<td data-for=\"' + litem + '\">' + ((m < 10) ? '0' : '') + m + '</td>';\n                            }\n                        }\n\n                        html += '</tr></table></div>';\n                    }\n                    html += '</dd>';\n                }\n\n                // Timezone\n                var showTz = o.showTimezone !== null ? o.showTimezone : this.support.timezone;\n                html += '<dt class=\"ui_tpicker_timezone_label' + (showTz ? '' : noDisplay) + '\">' + o.timezoneText + '</dt>';\n                html += '<dd class=\"ui_tpicker_timezone' + (showTz ? '' : noDisplay) + '\"></dd>';\n\n                // Create the elements from string\n                html += '</dl></div>';\n                var $tp = $(html);\n\n                // if we only want time picker...\n                if (o.timeOnly === true) {\n                    $tp.prepend('<div class=\"ui-widget-header ui-helper-clearfix ui-corner-all\">' + '<div class=\"ui-datepicker-title\">' + o.timeOnlyTitle + '</div>' + '</div>');\n                    $dp.find('.ui-datepicker-header, .ui-datepicker-calendar').hide();\n                }\n\n                // add sliders, adjust grids, add events\n                for (i = 0, l = tp_inst.units.length; i < l; i++) {\n                    litem = tp_inst.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // add the slider\n                    tp_inst[litem + '_slider'] = tp_inst.control.create(tp_inst, $tp.find('.ui_tpicker_' + litem + '_slider'), litem, tp_inst[litem], o[litem + 'Min'], max[litem], o['step' + uitem]);\n\n                    // adjust the grid and add click event\n                    if (show && o[litem + 'Grid'] > 0) {\n                        size = 100 * gridSize[litem] * o[litem + 'Grid'] / (max[litem] - o[litem + 'Min']);\n                        $tp.find('.ui_tpicker_' + litem + ' table').css({\n                            width: size + \"%\",\n                            marginLeft: o.isRTL ? '0' : ((size / (-2 * gridSize[litem])) + \"%\"),\n                            marginRight: o.isRTL ? ((size / (-2 * gridSize[litem])) + \"%\") : '0',\n                            borderCollapse: 'collapse'\n                        }).find(\"td\").click(function (e) {\n                            var $t = $(this),\n                                h = $t.html(),\n                                n = parseInt(h.replace(/[^0-9]/g), 10),\n                                ap = h.replace(/[^apm]/ig),\n                                f = $t.data('for'); // loses scope, so we use data-for\n\n                            if (f === 'hour') {\n                                if (ap.indexOf('p') !== -1 && n < 12) {\n                                    n += 12;\n                                }\n                                else {\n                                    if (ap.indexOf('a') !== -1 && n === 12) {\n                                        n = 0;\n                                    }\n                                }\n                            }\n\n                            tp_inst.control.value(tp_inst, tp_inst[f + '_slider'], litem, n);\n\n                            tp_inst._onTimeChange();\n                            tp_inst._onSelectHandler();\n                        }).css({\n                            cursor: 'pointer',\n                            width: (100 / gridSize[litem]) + '%',\n                            textAlign: 'center',\n                            overflow: 'hidden'\n                        });\n                    } // end if grid > 0\n                } // end for loop\n\n                // Add timezone options\n                this.timezone_select = $tp.find('.ui_tpicker_timezone').append('<select></select>').find(\"select\");\n                $.fn.append.apply(this.timezone_select,\n                    $.map(o.timezoneList, function (val, idx) {\n                        return $(\"<option />\").val(typeof val === \"object\" ? val.value : val).text(typeof val === \"object\" ? val.label : val);\n                    }));\n                if (typeof(this.timezone) !== \"undefined\" && this.timezone !== null && this.timezone !== \"\") {\n                    var local_timezone = (new Date(this.inst.selectedYear, this.inst.selectedMonth, this.inst.selectedDay, 12)).getTimezoneOffset() * -1;\n                    if (local_timezone === this.timezone) {\n                        selectLocalTimezone(tp_inst);\n                    } else {\n                        this.timezone_select.val(this.timezone);\n                    }\n                } else {\n                    if (typeof(this.hour) !== \"undefined\" && this.hour !== null && this.hour !== \"\") {\n                        this.timezone_select.val(o.timezone);\n                    } else {\n                        selectLocalTimezone(tp_inst);\n                    }\n                }\n                this.timezone_select.change(function () {\n                    tp_inst._onTimeChange();\n                    tp_inst._onSelectHandler();\n                    tp_inst._afterInject();\n                });\n                // End timezone options\n\n                // inject timepicker into datepicker\n                var $buttonPanel = $dp.find('.ui-datepicker-buttonpane');\n                if ($buttonPanel.length) {\n                    $buttonPanel.before($tp);\n                } else {\n                    $dp.append($tp);\n                }\n\n                this.$timeObj = $tp.find('.ui_tpicker_time_input');\n                this.$timeObj.change(function () {\n                    var timeFormat = tp_inst.inst.settings.timeFormat;\n                    var parsedTime = $.datepicker.parseTime(timeFormat, this.value);\n                    var update = new Date();\n                    if (parsedTime) {\n                        update.setHours(parsedTime.hour);\n                        update.setMinutes(parsedTime.minute);\n                        update.setSeconds(parsedTime.second);\n                        $.datepicker._setTime(tp_inst.inst, update);\n                    } else {\n                        this.value = tp_inst.formattedTime;\n                        this.blur();\n                    }\n                });\n\n                if (this.inst !== null) {\n                    var timeDefined = this.timeDefined;\n                    this._onTimeChange();\n                    this.timeDefined = timeDefined;\n                }\n\n                // slideAccess integration: http://trentrichardson.com/2011/11/11/jquery-ui-sliders-and-touch-accessibility/\n                if (this._defaults.addSliderAccess) {\n                    var sliderAccessArgs = this._defaults.sliderAccessArgs,\n                        rtl = this._defaults.isRTL;\n                    sliderAccessArgs.isRTL = rtl;\n\n                    setTimeout(function () { // fix for inline mode\n                        if ($tp.find('.ui-slider-access').length === 0) {\n                            $tp.find('.ui-slider:visible').sliderAccess(sliderAccessArgs);\n\n                            // fix any grids since sliders are shorter\n                            var sliderAccessWidth = $tp.find('.ui-slider-access:eq(0)').outerWidth(true);\n                            if (sliderAccessWidth) {\n                                $tp.find('table:visible').each(function () {\n                                    var $g = $(this),\n                                        oldWidth = $g.outerWidth(),\n                                        oldMarginLeft = $g.css(rtl ? 'marginRight' : 'marginLeft').toString().replace('%', ''),\n                                        newWidth = oldWidth - sliderAccessWidth,\n                                        newMarginLeft = ((oldMarginLeft * newWidth) / oldWidth) + '%',\n                                        css = { width: newWidth, marginRight: 0, marginLeft: 0 };\n                                    css[rtl ? 'marginRight' : 'marginLeft'] = newMarginLeft;\n                                    $g.css(css);\n                                });\n                            }\n                        }\n                    }, 10);\n                }\n                // end slideAccess integration\n\n                tp_inst._limitMinMaxDateTime(this.inst, true);\n            }\n        },\n\n        /*\n        * This function tries to limit the ability to go outside the\n        * min/max date range\n        */\n        _limitMinMaxDateTime: function (dp_inst, adjustSliders) {\n            var o = this._defaults,\n                dp_date = new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay);\n\n            if (!this._defaults.showTimepicker) {\n                return;\n            } // No time so nothing to check here\n\n            if ($.datepicker._get(dp_inst, 'minDateTime') !== null && $.datepicker._get(dp_inst, 'minDateTime') !== undefined && dp_date) {\n                var minDateTime = $.datepicker._get(dp_inst, 'minDateTime'),\n                    minDateTimeDate = new Date(minDateTime.getFullYear(), minDateTime.getMonth(), minDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMinOriginal === null || this.minuteMinOriginal === null || this.secondMinOriginal === null || this.millisecMinOriginal === null || this.microsecMinOriginal === null) {\n                    this.hourMinOriginal = o.hourMin;\n                    this.minuteMinOriginal = o.minuteMin;\n                    this.secondMinOriginal = o.secondMin;\n                    this.millisecMinOriginal = o.millisecMin;\n                    this.microsecMinOriginal = o.microsecMin;\n                }\n\n                if (dp_inst.settings.timeOnly || minDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMin = minDateTime.getHours();\n                    if (this.hour <= this._defaults.hourMin) {\n                        this.hour = this._defaults.hourMin;\n                        this._defaults.minuteMin = minDateTime.getMinutes();\n                        if (this.minute <= this._defaults.minuteMin) {\n                            this.minute = this._defaults.minuteMin;\n                            this._defaults.secondMin = minDateTime.getSeconds();\n                            if (this.second <= this._defaults.secondMin) {\n                                this.second = this._defaults.secondMin;\n                                this._defaults.millisecMin = minDateTime.getMilliseconds();\n                                if (this.millisec <= this._defaults.millisecMin) {\n                                    this.millisec = this._defaults.millisecMin;\n                                    this._defaults.microsecMin = minDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec < this._defaults.microsecMin) {\n                                        this.microsec = this._defaults.microsecMin;\n                                    }\n                                    this._defaults.microsecMin = this.microsecMinOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMin = this.millisecMinOriginal;\n                                this._defaults.microsecMin = this.microsecMinOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMin = this.secondMinOriginal;\n                            this._defaults.millisecMin = this.millisecMinOriginal;\n                            this._defaults.microsecMin = this.microsecMinOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMin = this.minuteMinOriginal;\n                        this._defaults.secondMin = this.secondMinOriginal;\n                        this._defaults.millisecMin = this.millisecMinOriginal;\n                        this._defaults.microsecMin = this.microsecMinOriginal;\n                    }\n                } else {\n                    this._defaults.hourMin = this.hourMinOriginal;\n                    this._defaults.minuteMin = this.minuteMinOriginal;\n                    this._defaults.secondMin = this.secondMinOriginal;\n                    this._defaults.millisecMin = this.millisecMinOriginal;\n                    this._defaults.microsecMin = this.microsecMinOriginal;\n                }\n            }\n\n            if ($.datepicker._get(dp_inst, 'maxDateTime') !== null && $.datepicker._get(dp_inst, 'maxDateTime') !== undefined && dp_date) {\n                var maxDateTime = $.datepicker._get(dp_inst, 'maxDateTime'),\n                    maxDateTimeDate = new Date(maxDateTime.getFullYear(), maxDateTime.getMonth(), maxDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMaxOriginal === null || this.minuteMaxOriginal === null || this.secondMaxOriginal === null || this.millisecMaxOriginal === null) {\n                    this.hourMaxOriginal = o.hourMax;\n                    this.minuteMaxOriginal = o.minuteMax;\n                    this.secondMaxOriginal = o.secondMax;\n                    this.millisecMaxOriginal = o.millisecMax;\n                    this.microsecMaxOriginal = o.microsecMax;\n                }\n\n                if (dp_inst.settings.timeOnly || maxDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMax = maxDateTime.getHours();\n                    if (this.hour >= this._defaults.hourMax) {\n                        this.hour = this._defaults.hourMax;\n                        this._defaults.minuteMax = maxDateTime.getMinutes();\n                        if (this.minute >= this._defaults.minuteMax) {\n                            this.minute = this._defaults.minuteMax;\n                            this._defaults.secondMax = maxDateTime.getSeconds();\n                            if (this.second >= this._defaults.secondMax) {\n                                this.second = this._defaults.secondMax;\n                                this._defaults.millisecMax = maxDateTime.getMilliseconds();\n                                if (this.millisec >= this._defaults.millisecMax) {\n                                    this.millisec = this._defaults.millisecMax;\n                                    this._defaults.microsecMax = maxDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec > this._defaults.microsecMax) {\n                                        this.microsec = this._defaults.microsecMax;\n                                    }\n                                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMax = this.millisecMaxOriginal;\n                                this._defaults.microsecMax = this.microsecMaxOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMax = this.secondMaxOriginal;\n                            this._defaults.millisecMax = this.millisecMaxOriginal;\n                            this._defaults.microsecMax = this.microsecMaxOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMax = this.minuteMaxOriginal;\n                        this._defaults.secondMax = this.secondMaxOriginal;\n                        this._defaults.millisecMax = this.millisecMaxOriginal;\n                        this._defaults.microsecMax = this.microsecMaxOriginal;\n                    }\n                } else {\n                    this._defaults.hourMax = this.hourMaxOriginal;\n                    this._defaults.minuteMax = this.minuteMaxOriginal;\n                    this._defaults.secondMax = this.secondMaxOriginal;\n                    this._defaults.millisecMax = this.millisecMaxOriginal;\n                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                }\n            }\n\n            if (dp_inst.settings.minTime!==null) {\n                var tempMinTime=new Date(\"01/01/1970 \" + dp_inst.settings.minTime);\n                if (this.hour<tempMinTime.getHours()) {\n                    this.hour=this._defaults.hourMin=tempMinTime.getHours();\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else if (this.hour===tempMinTime.getHours() && this.minute<tempMinTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMin<tempMinTime.getHours()) {\n                        this._defaults.hourMin=tempMinTime.getHours();\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else if (this._defaults.hourMin===tempMinTime.getHours()===this.hour && this._defaults.minuteMin<tempMinTime.getMinutes()) {\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMin=0;\n                    }\n                }\n            }\n\n            if (dp_inst.settings.maxTime!==null) {\n                var tempMaxTime=new Date(\"01/01/1970 \" + dp_inst.settings.maxTime);\n                if (this.hour>tempMaxTime.getHours()) {\n                    this.hour=this._defaults.hourMax=tempMaxTime.getHours();\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else if (this.hour===tempMaxTime.getHours() && this.minute>tempMaxTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMax>tempMaxTime.getHours()) {\n                        this._defaults.hourMax=tempMaxTime.getHours();\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else if (this._defaults.hourMax===tempMaxTime.getHours()===this.hour && this._defaults.minuteMax>tempMaxTime.getMinutes()) {\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMax=59;\n                    }\n                }\n            }\n\n            if (adjustSliders !== undefined && adjustSliders === true) {\n                var hourMax = parseInt((this._defaults.hourMax - ((this._defaults.hourMax - this._defaults.hourMin) % this._defaults.stepHour)), 10),\n                    minMax = parseInt((this._defaults.minuteMax - ((this._defaults.minuteMax - this._defaults.minuteMin) % this._defaults.stepMinute)), 10),\n                    secMax = parseInt((this._defaults.secondMax - ((this._defaults.secondMax - this._defaults.secondMin) % this._defaults.stepSecond)), 10),\n                    millisecMax = parseInt((this._defaults.millisecMax - ((this._defaults.millisecMax - this._defaults.millisecMin) % this._defaults.stepMillisec)), 10),\n                    microsecMax = parseInt((this._defaults.microsecMax - ((this._defaults.microsecMax - this._defaults.microsecMin) % this._defaults.stepMicrosec)), 10);\n\n                if (this.hour_slider) {\n                    this.control.options(this, this.hour_slider, 'hour', { min: this._defaults.hourMin, max: hourMax, step: this._defaults.stepHour });\n                    this.control.value(this, this.hour_slider, 'hour', this.hour - (this.hour % this._defaults.stepHour));\n                }\n                if (this.minute_slider) {\n                    this.control.options(this, this.minute_slider, 'minute', { min: this._defaults.minuteMin, max: minMax, step: this._defaults.stepMinute });\n                    this.control.value(this, this.minute_slider, 'minute', this.minute - (this.minute % this._defaults.stepMinute));\n                }\n                if (this.second_slider) {\n                    this.control.options(this, this.second_slider, 'second', { min: this._defaults.secondMin, max: secMax, step: this._defaults.stepSecond });\n                    this.control.value(this, this.second_slider, 'second', this.second - (this.second % this._defaults.stepSecond));\n                }\n                if (this.millisec_slider) {\n                    this.control.options(this, this.millisec_slider, 'millisec', { min: this._defaults.millisecMin, max: millisecMax, step: this._defaults.stepMillisec });\n                    this.control.value(this, this.millisec_slider, 'millisec', this.millisec - (this.millisec % this._defaults.stepMillisec));\n                }\n                if (this.microsec_slider) {\n                    this.control.options(this, this.microsec_slider, 'microsec', { min: this._defaults.microsecMin, max: microsecMax, step: this._defaults.stepMicrosec });\n                    this.control.value(this, this.microsec_slider, 'microsec', this.microsec - (this.microsec % this._defaults.stepMicrosec));\n                }\n            }\n\n        },\n\n        /*\n        * when a slider moves, set the internal time...\n        * on time change is also called when the time is updated in the text field\n        */\n        _onTimeChange: function () {\n            if (!this._defaults.showTimepicker) {\n                return;\n            }\n            var hour = (this.hour_slider) ? this.control.value(this, this.hour_slider, 'hour') : false,\n                minute = (this.minute_slider) ? this.control.value(this, this.minute_slider, 'minute') : false,\n                second = (this.second_slider) ? this.control.value(this, this.second_slider, 'second') : false,\n                millisec = (this.millisec_slider) ? this.control.value(this, this.millisec_slider, 'millisec') : false,\n                microsec = (this.microsec_slider) ? this.control.value(this, this.microsec_slider, 'microsec') : false,\n                timezone = (this.timezone_select) ? this.timezone_select.val() : false,\n                o = this._defaults,\n                pickerTimeFormat = o.pickerTimeFormat || o.timeFormat,\n                pickerTimeSuffix = o.pickerTimeSuffix || o.timeSuffix;\n\n            if (typeof(hour) === 'object') {\n                hour = false;\n            }\n            if (typeof(minute) === 'object') {\n                minute = false;\n            }\n            if (typeof(second) === 'object') {\n                second = false;\n            }\n            if (typeof(millisec) === 'object') {\n                millisec = false;\n            }\n            if (typeof(microsec) === 'object') {\n                microsec = false;\n            }\n            if (typeof(timezone) === 'object') {\n                timezone = false;\n            }\n\n            if (hour !== false) {\n                hour = parseInt(hour, 10);\n            }\n            if (minute !== false) {\n                minute = parseInt(minute, 10);\n            }\n            if (second !== false) {\n                second = parseInt(second, 10);\n            }\n            if (millisec !== false) {\n                millisec = parseInt(millisec, 10);\n            }\n            if (microsec !== false) {\n                microsec = parseInt(microsec, 10);\n            }\n            if (timezone !== false) {\n                timezone = timezone.toString();\n            }\n\n            var ampm = o[hour < 12 ? 'amNames' : 'pmNames'][0];\n\n            // If the update was done in the input field, the input field should not be updated.\n            // If the update was done using the sliders, update the input field.\n            var hasChanged = (\n                hour !== parseInt(this.hour,10) || // sliders should all be numeric\n                minute !== parseInt(this.minute,10) ||\n                second !== parseInt(this.second,10) ||\n                millisec !== parseInt(this.millisec,10) ||\n                microsec !== parseInt(this.microsec,10) ||\n                (this.ampm.length > 0 && (hour < 12) !== ($.inArray(this.ampm.toUpperCase(), this.amNames) !== -1)) ||\n                (this.timezone !== null && timezone !== this.timezone.toString()) // could be numeric or \"EST\" format, so use toString()\n            );\n\n            if (hasChanged) {\n\n                if (hour !== false) {\n                    this.hour = hour;\n                }\n                if (minute !== false) {\n                    this.minute = minute;\n                }\n                if (second !== false) {\n                    this.second = second;\n                }\n                if (millisec !== false) {\n                    this.millisec = millisec;\n                }\n                if (microsec !== false) {\n                    this.microsec = microsec;\n                }\n                if (timezone !== false) {\n                    this.timezone = timezone;\n                }\n\n                if (!this.inst) {\n                    this.inst = $.datepicker._getInst(this.$input[0]);\n                }\n\n                this._limitMinMaxDateTime(this.inst, true);\n            }\n            if (this.support.ampm) {\n                this.ampm = ampm;\n            }\n\n            // Updates the time within the timepicker\n            this.formattedTime = $.datepicker.formatTime(o.timeFormat, this, o);\n            if (this.$timeObj) {\n                if (pickerTimeFormat === o.timeFormat) {\n                    this.$timeObj.val(this.formattedTime + pickerTimeSuffix);\n                }\n                else {\n                    this.$timeObj.val($.datepicker.formatTime(pickerTimeFormat, this, o) + pickerTimeSuffix);\n                }\n                if (this.$timeObj[0].setSelectionRange) {\n                    var sPos = this.$timeObj[0].selectionStart;\n                    var ePos = this.$timeObj[0].selectionEnd;\n                    this.$timeObj[0].setSelectionRange(sPos, ePos);\n                }\n            }\n\n            this.timeDefined = true;\n            if (hasChanged) {\n                this._updateDateTime();\n                //this.$input.focus(); // may automatically open the picker on setDate\n            }\n        },\n\n        /*\n        * call custom onSelect.\n        * bind to sliders slidestop, and grid click.\n        */\n        _onSelectHandler: function () {\n            var onSelect = this._defaults.onSelect || this.inst.settings.onSelect;\n            var inputEl = this.$input ? this.$input[0] : null;\n            if (onSelect && inputEl) {\n                onSelect.apply(inputEl, [this.formattedDateTime, this]);\n            }\n        },\n\n        /*\n        * update our input with the new date time..\n        */\n        _updateDateTime: function (dp_inst) {\n            dp_inst = this.inst || dp_inst;\n            var dtTmp = (dp_inst.currentYear > 0?\n                new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay) :\n                new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                dt = $.datepicker._daylightSavingAdjust(dtTmp),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay)),\n                dateFmt = $.datepicker._get(dp_inst, 'dateFormat'),\n                formatCfg = $.datepicker._getFormatConfig(dp_inst),\n                timeAvailable = dt !== null && this.timeDefined;\n            this.formattedDate = $.datepicker.formatDate(dateFmt, (dt === null ? new Date() : dt), formatCfg);\n            var formattedDateTime = this.formattedDate;\n\n            // if a slider was changed but datepicker doesn't have a value yet, set it\n            if (dp_inst.lastVal === \"\") {\n                dp_inst.currentYear = dp_inst.selectedYear;\n                dp_inst.currentMonth = dp_inst.selectedMonth;\n                dp_inst.currentDay = dp_inst.selectedDay;\n            }\n\n            /*\n            * remove following lines to force every changes in date picker to change the input value\n            * Bug descriptions: when an input field has a default value, and click on the field to pop up the date picker.\n            * If the user manually empty the value in the input field, the date picker will never change selected value.\n            */\n            //if (dp_inst.lastVal !== undefined && (dp_inst.lastVal.length > 0 && this.$input.val().length === 0)) {\n            //\treturn;\n            //}\n\n            if (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === false) {\n                formattedDateTime = this.formattedTime;\n            } else if ((this._defaults.timeOnly !== true && (this._defaults.alwaysSetTime || timeAvailable)) || (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === true)) {\n                formattedDateTime += this._defaults.separator + this.formattedTime + this._defaults.timeSuffix;\n            }\n\n            this.formattedDateTime = formattedDateTime;\n\n            if (!this._defaults.showTimepicker) {\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput && this._defaults.timeOnly === false && this._defaults.altFieldTimeOnly === true) {\n                this.$altInput.val(this.formattedTime);\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput) {\n                this.$input.val(formattedDateTime);\n                var altFormattedDateTime = '',\n                    altSeparator = this._defaults.altSeparator !== null ? this._defaults.altSeparator : this._defaults.separator,\n                    altTimeSuffix = this._defaults.altTimeSuffix !== null ? this._defaults.altTimeSuffix : this._defaults.timeSuffix;\n\n                if (!this._defaults.timeOnly) {\n                    if (this._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(this._defaults.altFormat, (dt === null ? new Date() : dt), formatCfg);\n                    }\n                    else {\n                        altFormattedDateTime = this.formattedDate;\n                    }\n\n                    if (altFormattedDateTime) {\n                        altFormattedDateTime += altSeparator;\n                    }\n                }\n\n                if (this._defaults.altTimeFormat !== null) {\n                    altFormattedDateTime += $.datepicker.formatTime(this._defaults.altTimeFormat, this, this._defaults) + altTimeSuffix;\n                }\n                else {\n                    altFormattedDateTime += this.formattedTime + altTimeSuffix;\n                }\n                this.$altInput.val(altFormattedDateTime);\n            } else {\n                this.$input.val(formattedDateTime);\n            }\n\n            this.$input.trigger(\"change\");\n        },\n\n        _onFocus: function () {\n            if (!this.$input.val() && this._defaults.defaultValue) {\n                this.$input.val(this._defaults.defaultValue);\n                var inst = $.datepicker._getInst(this.$input.get(0)),\n                    tp_inst = $.datepicker._get(inst, 'timepicker');\n                if (tp_inst) {\n                    if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                        try {\n                            $.datepicker._updateDatepicker(inst);\n                        } catch (err) {\n                            $.timepicker.log(err);\n                        }\n                    }\n                }\n            }\n        },\n\n        /*\n        * Small abstraction to control types\n        * We can add more, just be sure to follow the pattern: create, options, value\n        */\n        _controls: {\n            // slider methods\n            slider: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var rtl = tp_inst._defaults.isRTL; // if rtl go -60->0 instead of 0->60\n                    return obj.prop('slide', null).slider({\n                        orientation: \"horizontal\",\n                        value: rtl ? val * -1 : val,\n                        min: rtl ? max * -1 : min,\n                        max: rtl ? min * -1 : max,\n                        step: step,\n                        slide: function (event, ui) {\n                            tp_inst.control.value(tp_inst, $(this), unit, rtl ? ui.value * -1 : ui.value);\n                            tp_inst._onTimeChange();\n                        },\n                        stop: function (event, ui) {\n                            tp_inst._onSelectHandler();\n                        }\n                    });\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (typeof(opts) === 'string') {\n                            if (opts === 'min' || opts === 'max') {\n                                if (val !== undefined) {\n                                    return obj.slider(opts, val * -1);\n                                }\n                                return Math.abs(obj.slider(opts));\n                            }\n                            return obj.slider(opts);\n                        }\n                        var min = opts.min,\n                            max = opts.max;\n                        opts.min = opts.max = null;\n                        if (min !== undefined) {\n                            opts.max = min * -1;\n                        }\n                        if (max !== undefined) {\n                            opts.min = max * -1;\n                        }\n                        return obj.slider(opts);\n                    }\n                    if (typeof(opts) === 'string' && val !== undefined) {\n                        return obj.slider(opts, val);\n                    }\n                    return obj.slider(opts);\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (val !== undefined) {\n                            return obj.slider('value', val * -1);\n                        }\n                        return Math.abs(obj.slider('value'));\n                    }\n                    if (val !== undefined) {\n                        return obj.slider('value', val);\n                    }\n                    return obj.slider('value');\n                }\n            },\n            // select methods\n            select: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var sel = '<select class=\"ui-timepicker-select ui-state-default ui-corner-all\" data-unit=\"' + unit + '\" data-min=\"' + min + '\" data-max=\"' + max + '\" data-step=\"' + step + '\">',\n                        format = tp_inst._defaults.pickerTimeFormat || tp_inst._defaults.timeFormat;\n\n                    for (var i = min; i <= max; i += step) {\n                        sel += '<option value=\"' + i + '\"' + (i === val ? ' selected' : '') + '>';\n                        if (unit === 'hour') {\n                            sel += $.datepicker.formatTime($.trim(format.replace(/[^ht ]/ig, '')), {hour: i}, tp_inst._defaults);\n                        }\n                        else if (unit === 'millisec' || unit === 'microsec' || i >= 10) { sel += i; }\n                        else {sel += '0' + i.toString(); }\n                        sel += '</option>';\n                    }\n                    sel += '</select>';\n\n                    obj.children('select').remove();\n\n                    $(sel).appendTo(obj).change(function (e) {\n                        tp_inst._onTimeChange();\n                        tp_inst._onSelectHandler();\n                        tp_inst._afterInject();\n                    });\n\n                    return obj;\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    var o = {},\n                        $t = obj.children('select');\n                    if (typeof(opts) === 'string') {\n                        if (val === undefined) {\n                            return $t.data(opts);\n                        }\n                        o[opts] = val;\n                    }\n                    else { o = opts; }\n                    return tp_inst.control.create(tp_inst, obj, $t.data('unit'), $t.val(), o.min>=0 ? o.min : $t.data('min'), o.max || $t.data('max'), o.step || $t.data('step'));\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    var $t = obj.children('select');\n                    if (val !== undefined) {\n                        return $t.val(val);\n                    }\n                    return $t.val();\n                }\n            }\n        } // end _controls\n\n    });\n\n    $.fn.extend({\n        /*\n        * shorthand just to use timepicker.\n        */\n        timepicker: function (o) {\n            o = o || {};\n            var tmp_args = Array.prototype.slice.call(arguments);\n\n            if (typeof o === 'object') {\n                tmp_args[0] = $.extend(o, {\n                    timeOnly: true\n                });\n            }\n\n            return $(this).each(function () {\n                $.fn.datetimepicker.apply($(this), tmp_args);\n            });\n        },\n\n        /*\n        * extend timepicker to datepicker\n        */\n        datetimepicker: function (o) {\n            o = o || {};\n            var tmp_args = arguments;\n\n            if (typeof(o) === 'string') {\n                if (o === 'getDate'  || (o === 'option' && tmp_args.length === 2 && typeof (tmp_args[1]) === 'string')) {\n                    return $.fn.datepicker.apply($(this[0]), tmp_args);\n                } else {\n                    return this.each(function () {\n                        var $t = $(this);\n                        $t.datepicker.apply($t, tmp_args);\n                    });\n                }\n            } else {\n                return this.each(function () {\n                    var $t = $(this);\n                    $t.datepicker($.timepicker._newInst($t, o)._defaults);\n                });\n            }\n        }\n    });\n\n    /*\n    * Public Utility to parse date and time\n    */\n    $.datepicker.parseDateTime = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var parseRes = parseDateTimeInternal(dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings);\n        if (parseRes.timeObj) {\n            var t = parseRes.timeObj;\n            parseRes.date.setHours(t.hour, t.minute, t.second, t.millisec);\n            parseRes.date.setMicroseconds(t.microsec);\n        }\n\n        return parseRes.date;\n    };\n\n    /*\n    * Public utility to parse time\n    */\n    $.datepicker.parseTime = function (timeFormat, timeString, options) {\n        var o = extendRemove(extendRemove({}, $.timepicker._defaults), options || {}),\n            iso8601 = (timeFormat.replace(/\\'.*?\\'/g, '').indexOf('Z') !== -1);\n\n        // Strict parse requires the timeString to match the timeFormat exactly\n        var strictParse = function (f, s, o) {\n\n            // pattern for standard and localized AM/PM markers\n            var getPatternAmpm = function (amNames, pmNames) {\n                var markers = [];\n                if (amNames) {\n                    $.merge(markers, amNames);\n                }\n                if (pmNames) {\n                    $.merge(markers, pmNames);\n                }\n                markers = $.map(markers, function (val) {\n                    return val.replace(/[.*+?|()\\[\\]{}\\\\]/g, '\\\\$&');\n                });\n                return '(' + markers.join('|') + ')?';\n            };\n\n            // figure out position of time elements.. cause js cant do named captures\n            var getFormatPositions = function (timeFormat) {\n                var finds = timeFormat.toLowerCase().match(/(h{1,2}|m{1,2}|s{1,2}|l{1}|c{1}|t{1,2}|z|'.*?')/g),\n                    orders = {\n                        h: -1,\n                        m: -1,\n                        s: -1,\n                        l: -1,\n                        c: -1,\n                        t: -1,\n                        z: -1\n                    };\n\n                if (finds) {\n                    for (var i = 0; i < finds.length; i++) {\n                        if (orders[finds[i].toString().charAt(0)] === -1) {\n                            orders[finds[i].toString().charAt(0)] = i + 1;\n                        }\n                    }\n                }\n                return orders;\n            };\n\n            var regstr = '^' + f.toString()\n                    .replace(/([hH]{1,2}|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n                        var ml = match.length;\n                        switch (match.charAt(0).toLowerCase()) {\n                            case 'h':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'm':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 's':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'l':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'c':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'z':\n                                return '(z|[-+]\\\\d\\\\d:?\\\\d\\\\d|\\\\S+)?';\n                            case 't':\n                                return getPatternAmpm(o.amNames, o.pmNames);\n                            default:    // literal escaped in quotes\n                                return '(' + match.replace(/\\'/g, \"\").replace(/(\\.|\\$|\\^|\\\\|\\/|\\(|\\)|\\[|\\]|\\?|\\+|\\*)/g, function (m) { return \"\\\\\" + m; }) + ')?';\n                        }\n                    })\n                    .replace(/\\s/g, '\\\\s?') +\n                o.timeSuffix + '$',\n                order = getFormatPositions(f),\n                ampm = '',\n                treg;\n\n            treg = s.match(new RegExp(regstr, 'i'));\n\n            var resTime = {\n                hour: 0,\n                minute: 0,\n                second: 0,\n                millisec: 0,\n                microsec: 0\n            };\n\n            if (treg) {\n                if (order.t !== -1) {\n                    if (treg[order.t] === undefined || treg[order.t].length === 0) {\n                        ampm = '';\n                        resTime.ampm = '';\n                    } else {\n                        ampm = $.inArray(treg[order.t].toUpperCase(), $.map(o.amNames, function (x,i) { return x.toUpperCase(); })) !== -1 ? 'AM' : 'PM';\n                        resTime.ampm = o[ampm === 'AM' ? 'amNames' : 'pmNames'][0];\n                    }\n                }\n\n                if (order.h !== -1) {\n                    if (ampm === 'AM' && treg[order.h] === '12') {\n                        resTime.hour = 0; // 12am = 0 hour\n                    } else {\n                        if (ampm === 'PM' && treg[order.h] !== '12') {\n                            resTime.hour = parseInt(treg[order.h], 10) + 12; // 12pm = 12 hour, any other pm = hour + 12\n                        } else {\n                            resTime.hour = Number(treg[order.h]);\n                        }\n                    }\n                }\n\n                if (order.m !== -1) {\n                    resTime.minute = Number(treg[order.m]);\n                }\n                if (order.s !== -1) {\n                    resTime.second = Number(treg[order.s]);\n                }\n                if (order.l !== -1) {\n                    resTime.millisec = Number(treg[order.l]);\n                }\n                if (order.c !== -1) {\n                    resTime.microsec = Number(treg[order.c]);\n                }\n                if (order.z !== -1 && treg[order.z] !== undefined) {\n                    resTime.timezone = $.timepicker.timezoneOffsetNumber(treg[order.z]);\n                }\n\n\n                return resTime;\n            }\n            return false;\n        };// end strictParse\n\n        // First try JS Date, if that fails, use strictParse\n        var looseParse = function (f, s, o) {\n            try {\n                var d = new Date('2012-01-01 ' + s);\n                if (isNaN(d.getTime())) {\n                    d = new Date('2012-01-01T' + s);\n                    if (isNaN(d.getTime())) {\n                        d = new Date('01/01/2012 ' + s);\n                        if (isNaN(d.getTime())) {\n                            throw \"Unable to parse time with native Date: \" + s;\n                        }\n                    }\n                }\n\n                return {\n                    hour: d.getHours(),\n                    minute: d.getMinutes(),\n                    second: d.getSeconds(),\n                    millisec: d.getMilliseconds(),\n                    microsec: d.getMicroseconds(),\n                    timezone: d.getTimezoneOffset() * -1\n                };\n            }\n            catch (err) {\n                try {\n                    return strictParse(f, s, o);\n                }\n                catch (err2) {\n                    $.timepicker.log(\"Unable to parse \\ntimeString: \" + s + \"\\ntimeFormat: \" + f);\n                }\n            }\n            return false;\n        }; // end looseParse\n\n        if (typeof o.parse === \"function\") {\n            return o.parse(timeFormat, timeString, o);\n        }\n        if (o.parse === 'loose') {\n            return looseParse(timeFormat, timeString, o);\n        }\n        return strictParse(timeFormat, timeString, o);\n    };\n\n    /**\n     * Public utility to format the time\n     * @param {string} format format of the time\n     * @param {Object} time Object not a Date for timezones\n     * @param {Object} [options] essentially the regional[].. amNames, pmNames, ampm\n     * @returns {string} the formatted time\n     */\n    $.datepicker.formatTime = function (format, time, options) {\n        options = options || {};\n        options = $.extend({}, $.timepicker._defaults, options);\n        time = $.extend({\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null\n        }, time);\n\n        var tmptime = format,\n            ampmName = options.amNames[0],\n            hour = parseInt(time.hour, 10);\n\n        if (hour > 11) {\n            ampmName = options.pmNames[0];\n        }\n\n        tmptime = tmptime.replace(/(?:HH?|hh?|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n            switch (match) {\n                case 'HH':\n                    return ('0' + hour).slice(-2);\n                case 'H':\n                    return hour;\n                case 'hh':\n                    return ('0' + convert24to12(hour)).slice(-2);\n                case 'h':\n                    return convert24to12(hour);\n                case 'mm':\n                    return ('0' + time.minute).slice(-2);\n                case 'm':\n                    return time.minute;\n                case 'ss':\n                    return ('0' + time.second).slice(-2);\n                case 's':\n                    return time.second;\n                case 'l':\n                    return ('00' + time.millisec).slice(-3);\n                case 'c':\n                    return ('00' + time.microsec).slice(-3);\n                case 'z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, false);\n                case 'Z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, true);\n                case 'T':\n                    return ampmName.charAt(0).toUpperCase();\n                case 'TT':\n                    return ampmName.toUpperCase();\n                case 't':\n                    return ampmName.charAt(0).toLowerCase();\n                case 'tt':\n                    return ampmName.toLowerCase();\n                default:\n                    return match.replace(/'/g, \"\");\n            }\n        });\n\n        return tmptime;\n    };\n\n    /*\n    * the bad hack :/ override datepicker so it doesn't close on select\n    // inspired: http://stackoverflow.com/questions/1252512/jquery-datepicker-prevent-closing-picker-when-clicking-a-date/1762378#1762378\n    */\n    $.datepicker._base_selectDate = $.datepicker._selectDate;\n    $.datepicker._selectDate = function (id, dateStr) {\n        var inst = this._getInst($(id)[0]),\n            tp_inst = this._get(inst, 'timepicker'),\n            was_inline;\n\n        if (tp_inst && inst.settings.showTimepicker) {\n            tp_inst._limitMinMaxDateTime(inst, true);\n            was_inline = inst.inline;\n            inst.inline = inst.stay_open = true;\n            //This way the onSelect handler called from calendarpicker get the full dateTime\n            this._base_selectDate(id, dateStr);\n            inst.inline = was_inline;\n            inst.stay_open = false;\n            this._notifyChange(inst);\n            this._updateDatepicker(inst);\n        } else {\n            this._base_selectDate(id, dateStr);\n        }\n    };\n\n    /*\n    * second bad hack :/ override datepicker so it triggers an event when changing the input field\n    * and does not redraw the datepicker on every selectDate event\n    */\n    $.datepicker._base_updateDatepicker = $.datepicker._updateDatepicker;\n    $.datepicker._updateDatepicker = function (inst) {\n\n        // don't popup the datepicker if there is another instance already opened\n        var input = inst.input[0];\n        if ($.datepicker._curInst && $.datepicker._curInst !== inst && $.datepicker._datepickerShowing && $.datepicker._lastInput !== input) {\n            return;\n        }\n\n        if (typeof(inst.stay_open) !== 'boolean' || inst.stay_open === false) {\n\n            this._base_updateDatepicker(inst);\n\n            // Reload the time control when changing something in the input text field.\n            var tp_inst = this._get(inst, 'timepicker');\n            if (tp_inst) {\n                tp_inst._addTimePicker(inst);\n            }\n        }\n    };\n\n    /*\n    * third bad hack :/ override datepicker so it allows spaces and colon in the input field\n    */\n    $.datepicker._base_doKeyPress = $.datepicker._doKeyPress;\n    $.datepicker._doKeyPress = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if ($.datepicker._get(inst, 'constrainInput')) {\n                var ampm = tp_inst.support.ampm,\n                    tz = tp_inst._defaults.showTimezone !== null ? tp_inst._defaults.showTimezone : tp_inst.support.timezone,\n                    dateChars = $.datepicker._possibleChars($.datepicker._get(inst, 'dateFormat')),\n                    datetimeChars = tp_inst._defaults.timeFormat.toString()\n                            .replace(/[hms]/g, '')\n                            .replace(/TT/g, ampm ? 'APM' : '')\n                            .replace(/Tt/g, ampm ? 'AaPpMm' : '')\n                            .replace(/tT/g, ampm ? 'AaPpMm' : '')\n                            .replace(/T/g, ampm ? 'AP' : '')\n                            .replace(/tt/g, ampm ? 'apm' : '')\n                            .replace(/t/g, ampm ? 'ap' : '') +\n                        \" \" + tp_inst._defaults.separator +\n                        tp_inst._defaults.timeSuffix +\n                        (tz ? tp_inst._defaults.timezoneList.join('') : '') +\n                        (tp_inst._defaults.amNames.join('')) + (tp_inst._defaults.pmNames.join('')) +\n                        dateChars,\n                    chr = String.fromCharCode(event.charCode === undefined ? event.keyCode : event.charCode);\n                return event.ctrlKey || (chr < ' ' || !dateChars || datetimeChars.indexOf(chr) > -1);\n            }\n        }\n\n        return $.datepicker._base_doKeyPress(event);\n    };\n\n    /*\n    * Fourth bad hack :/ override _updateAlternate function used in inline mode to init altField\n    * Update any alternate field to synchronise with the main field.\n    */\n    $.datepicker._base_updateAlternate = $.datepicker._updateAlternate;\n    $.datepicker._updateAlternate = function (inst) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var altField = tp_inst._defaults.altField;\n            if (altField) { // update alternate field too\n                var altFormat = tp_inst._defaults.altFormat || tp_inst._defaults.dateFormat,\n                    date = this._getDate(inst),\n                    formatCfg = $.datepicker._getFormatConfig(inst),\n                    altFormattedDateTime = '',\n                    altSeparator = tp_inst._defaults.altSeparator ? tp_inst._defaults.altSeparator : tp_inst._defaults.separator,\n                    altTimeSuffix = tp_inst._defaults.altTimeSuffix ? tp_inst._defaults.altTimeSuffix : tp_inst._defaults.timeSuffix,\n                    altTimeFormat = tp_inst._defaults.altTimeFormat !== null ? tp_inst._defaults.altTimeFormat : tp_inst._defaults.timeFormat;\n\n                altFormattedDateTime += $.datepicker.formatTime(altTimeFormat, tp_inst, tp_inst._defaults) + altTimeSuffix;\n                if (!tp_inst._defaults.timeOnly && !tp_inst._defaults.altFieldTimeOnly && date !== null) {\n                    if (tp_inst._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(tp_inst._defaults.altFormat, date, formatCfg) + altSeparator + altFormattedDateTime;\n                    }\n                    else {\n                        altFormattedDateTime = tp_inst.formattedDate + altSeparator + altFormattedDateTime;\n                    }\n                }\n                $(altField).val( inst.input.val() ? altFormattedDateTime : \"\");\n            }\n        }\n        else {\n            $.datepicker._base_updateAlternate(inst);\n        }\n    };\n\n    /*\n    * Override key up event to sync manual input changes.\n    */\n    $.datepicker._base_doKeyUp = $.datepicker._doKeyUp;\n    $.datepicker._doKeyUp = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                try {\n                    $.datepicker._updateDatepicker(inst);\n                } catch (err) {\n                    $.timepicker.log(err);\n                }\n            }\n        }\n\n        return $.datepicker._base_doKeyUp(event);\n    };\n\n    /*\n    * override \"Today\" button to also grab the time and set it to input field.\n    */\n    $.datepicker._base_gotoToday = $.datepicker._gotoToday;\n    $.datepicker._gotoToday = function (id) {\n        var inst = this._getInst($(id)[0]);\n        this._base_gotoToday(id);\n        var tp_inst = this._get(inst, 'timepicker');\n        if (!tp_inst) {\n            return;\n        }\n\n        var tzoffset = $.timepicker.timezoneOffsetNumber(tp_inst.timezone);\n        var now = new Date();\n        now.setMinutes(now.getMinutes() + now.getTimezoneOffset() + parseInt(tzoffset, 10));\n        this._setTime(inst, now);\n        this._setDate(inst, now);\n        tp_inst._onSelectHandler();\n    };\n\n    /*\n    * Disable & enable the Time in the datetimepicker\n    */\n    $.datepicker._disableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = false;\n            tp_inst._defaults.showTimepicker = false;\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    $.datepicker._enableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = true;\n            tp_inst._defaults.showTimepicker = true;\n            tp_inst._addTimePicker(inst); // Could be disabled on page load\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create our own set time function\n    */\n    $.datepicker._setTime = function (inst, date) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var defaults = tp_inst._defaults;\n\n            // calling _setTime with no date sets time to defaults\n            tp_inst.hour = date ? date.getHours() : defaults.hour;\n            tp_inst.minute = date ? date.getMinutes() : defaults.minute;\n            tp_inst.second = date ? date.getSeconds() : defaults.second;\n            tp_inst.millisec = date ? date.getMilliseconds() : defaults.millisec;\n            tp_inst.microsec = date ? date.getMicroseconds() : defaults.microsec;\n\n            //check if within min/max times..\n            tp_inst._limitMinMaxDateTime(inst, true);\n\n            tp_inst._onTimeChange();\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create new public method to set only time, callable as $().datepicker('setTime', date)\n    */\n    $.datepicker._setTimeDatepicker = function (target, date, withDate) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            this._setDateFromField(inst);\n            var tp_date;\n            if (date) {\n                if (typeof date === \"string\") {\n                    tp_inst._parseTime(date, withDate);\n                    tp_date = new Date();\n                    tp_date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                    tp_date.setMicroseconds(tp_inst.microsec);\n                } else {\n                    tp_date = new Date(date.getTime());\n                    tp_date.setMicroseconds(date.getMicroseconds());\n                }\n                if (tp_date.toString() === 'Invalid Date') {\n                    tp_date = undefined;\n                }\n                this._setTime(inst, tp_date);\n            }\n        }\n\n    };\n\n    /*\n    * override setDate() to allow setting time too within Date object\n    */\n    $.datepicker._base_setDateDatepicker = $.datepicker._setDateDatepicker;\n    $.datepicker._setDateDatepicker = function (target, _date) {\n        var inst = this._getInst(target);\n        var date = _date;\n        if (!inst) {\n            return;\n        }\n\n        if (typeof(_date) === 'string') {\n            date = new Date(_date);\n            if (!date.getTime()) {\n                this._base_setDateDatepicker.apply(this, arguments);\n                date = $(target).datepicker('getDate');\n            }\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        var tp_date;\n        if (date instanceof Date) {\n            tp_date = new Date(date.getTime());\n            tp_date.setMicroseconds(date.getMicroseconds());\n        } else {\n            tp_date = date;\n        }\n\n        // This is important if you are using the timezone option, javascript's Date\n        // object will only return the timezone offset for the current locale, so we\n        // adjust it accordingly.  If not using timezone option this won't matter..\n        // If a timezone is different in tp, keep the timezone as is\n        if (tp_inst && tp_date) {\n            // look out for DST if tz wasn't specified\n            if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                tp_inst.timezone = tp_date.getTimezoneOffset() * -1;\n            }\n            date = $.timepicker.timezoneAdjust(date, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()), tp_inst.timezone);\n            tp_date = $.timepicker.timezoneAdjust(tp_date, $.timepicker.timezoneOffsetString(-tp_date.getTimezoneOffset()), tp_inst.timezone);\n        }\n\n        this._updateDatepicker(inst);\n        this._base_setDateDatepicker.apply(this, arguments);\n        this._setTimeDatepicker(target, tp_date, true);\n    };\n\n    /*\n    * override getDate() to allow getting time too within Date object\n    */\n    $.datepicker._base_getDateDatepicker = $.datepicker._getDateDatepicker;\n    $.datepicker._getDateDatepicker = function (target, noDefault) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            // if it hasn't yet been defined, grab from field\n            if (inst.lastVal === undefined) {\n                this._setDateFromField(inst, noDefault);\n            }\n\n            var date = this._getDate(inst);\n\n            var currDT = null;\n\n            if (tp_inst.$altInput && tp_inst._defaults.altFieldTimeOnly) {\n                currDT = tp_inst.$input.val() + ' ' + tp_inst.$altInput.val();\n            }\n            else if (tp_inst.$input.get(0).tagName !== 'INPUT' && tp_inst.$altInput) {\n                /**\n                 * in case the datetimepicker has been applied to a non-input tag for inline UI,\n                 * and the user has not configured the plugin to display only time in altInput,\n                 * pick current date time from the altInput (and hope for the best, for now, until \"ER1\" is applied)\n                 *\n                 * @todo ER1. Since altInput can have a totally difference format, convert it to standard format by reading input format from \"altFormat\" and \"altTimeFormat\" option values\n                 */\n                currDT = tp_inst.$altInput.val();\n            }\n            else {\n                currDT = tp_inst.$input.val();\n            }\n\n            if (date && tp_inst._parseTime(currDT, !inst.settings.timeOnly)) {\n                date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                date.setMicroseconds(tp_inst.microsec);\n\n                // This is important if you are using the timezone option, javascript's Date\n                // object will only return the timezone offset for the current locale, so we\n                // adjust it accordingly.  If not using timezone option this won't matter..\n                if (tp_inst.timezone != null) {\n                    // look out for DST if tz wasn't specified\n                    if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                        tp_inst.timezone = date.getTimezoneOffset() * -1;\n                    }\n                    date = $.timepicker.timezoneAdjust(date, tp_inst.timezone, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()));\n                }\n            }\n            return date;\n        }\n        return this._base_getDateDatepicker(target, noDefault);\n    };\n\n    /*\n    * override parseDate() because UI 1.8.14 throws an error about \"Extra characters\"\n    * An option in datapicker to ignore extra format characters would be nicer.\n    */\n    $.datepicker._base_parseDate = $.datepicker.parseDate;\n    $.datepicker.parseDate = function (format, value, settings) {\n        var date;\n        try {\n            date = this._base_parseDate(format, value, settings);\n        } catch (err) {\n            // Hack!  The error message ends with a colon, a space, and\n            // the \"extra\" characters.  We rely on that instead of\n            // attempting to perfectly reproduce the parsing algorithm.\n            if (err.indexOf(\":\") >= 0) {\n                date = this._base_parseDate(format, value.substring(0, value.length - (err.length - err.indexOf(':') - 2)), settings);\n                $.timepicker.log(\"Error parsing the date string: \" + err + \"\\ndate string = \" + value + \"\\ndate format = \" + format);\n            } else {\n                throw err;\n            }\n        }\n        return date;\n    };\n\n    /*\n    * override formatDate to set date with time to the input\n    */\n    $.datepicker._base_formatDate = $.datepicker._formatDate;\n    $.datepicker._formatDate = function (inst, day, month, year) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            tp_inst._updateDateTime(inst);\n            return tp_inst.$input.val();\n        }\n        return this._base_formatDate(inst);\n    };\n\n    /*\n    * override options setter to add time to maxDate(Time) and minDate(Time). MaxDate\n    */\n    $.datepicker._base_optionDatepicker = $.datepicker._optionDatepicker;\n    $.datepicker._optionDatepicker = function (target, name, value) {\n        var inst = this._getInst(target),\n            name_clone;\n        if (!inst) {\n            return null;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var min = null,\n                max = null,\n                onselect = null,\n                overrides = tp_inst._defaults.evnts,\n                fns = {},\n                prop,\n                ret,\n                oldVal,\n                $target;\n            if (typeof name === 'string') { // if min/max was set with the string\n                if (name === 'minDate' || name === 'minDateTime') {\n                    min = value;\n                } else if (name === 'maxDate' || name === 'maxDateTime') {\n                    max = value;\n                } else if (name === 'onSelect') {\n                    onselect = value;\n                } else if (overrides.hasOwnProperty(name)) {\n                    if (typeof (value) === 'undefined') {\n                        return overrides[name];\n                    }\n                    fns[name] = value;\n                    name_clone = {}; //empty results in exiting function after overrides updated\n                }\n            } else if (typeof name === 'object') { //if min/max was set with the JSON\n                if (name.minDate) {\n                    min = name.minDate;\n                } else if (name.minDateTime) {\n                    min = name.minDateTime;\n                } else if (name.maxDate) {\n                    max = name.maxDate;\n                } else if (name.maxDateTime) {\n                    max = name.maxDateTime;\n                }\n                for (prop in overrides) {\n                    if (overrides.hasOwnProperty(prop) && name[prop]) {\n                        fns[prop] = name[prop];\n                    }\n                }\n            }\n            for (prop in fns) {\n                if (fns.hasOwnProperty(prop)) {\n                    overrides[prop] = fns[prop];\n                    if (!name_clone) { name_clone = $.extend({}, name); }\n                    delete name_clone[prop];\n                }\n            }\n            if (name_clone && isEmptyObject(name_clone)) { return; }\n            if (min) { //if min was set\n                if (min === 0) {\n                    min = new Date();\n                } else {\n                    min = new Date(min);\n                }\n                tp_inst._defaults.minDate = min;\n                tp_inst._defaults.minDateTime = min;\n            } else if (max) { //if max was set\n                if (max === 0) {\n                    max = new Date();\n                } else {\n                    max = new Date(max);\n                }\n                tp_inst._defaults.maxDate = max;\n                tp_inst._defaults.maxDateTime = max;\n            } else if (onselect) {\n                tp_inst._defaults.onSelect = onselect;\n            }\n\n            // Datepicker will override our date when we call _base_optionDatepicker when\n            // calling minDate/maxDate, so we will first grab the value, call\n            // _base_optionDatepicker, then set our value back.\n            if(min || max){\n                $target = $(target);\n                oldVal = $target.datetimepicker('getDate');\n                ret = this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n                $target.datetimepicker('setDate', oldVal);\n                return ret;\n            }\n        }\n        if (value === undefined) {\n            return this._base_optionDatepicker.call($.datepicker, target, name);\n        }\n        return this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n    };\n\n    /*\n    * jQuery isEmptyObject does not check hasOwnProperty - if someone has added to the object prototype,\n    * it will return false for all objects\n    */\n    var isEmptyObject = function (obj) {\n        var prop;\n        for (prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                return false;\n            }\n        }\n        return true;\n    };\n\n    /*\n    * jQuery extend now ignores nulls!\n    */\n    var extendRemove = function (target, props) {\n        $.extend(target, props);\n        for (var name in props) {\n            if (props[name] === null || props[name] === undefined) {\n                target[name] = props[name];\n            }\n        }\n        return target;\n    };\n\n    /*\n    * Determine by the time format which units are supported\n    * Returns an object of booleans for each unit\n    */\n    var detectSupport = function (timeFormat) {\n        var tf = timeFormat.replace(/'.*?'/g, '').toLowerCase(), // removes literals\n            isIn = function (f, t) { // does the format contain the token?\n                return f.indexOf(t) !== -1 ? true : false;\n            };\n        return {\n            hour: isIn(tf, 'h'),\n            minute: isIn(tf, 'm'),\n            second: isIn(tf, 's'),\n            millisec: isIn(tf, 'l'),\n            microsec: isIn(tf, 'c'),\n            timezone: isIn(tf, 'z'),\n            ampm: isIn(tf, 't') && isIn(timeFormat, 'h'),\n            iso8601: isIn(timeFormat, 'Z')\n        };\n    };\n\n    /*\n    * Converts 24 hour format into 12 hour\n    * Returns 12 hour without leading 0\n    */\n    var convert24to12 = function (hour) {\n        hour %= 12;\n\n        if (hour === 0) {\n            hour = 12;\n        }\n\n        return String(hour);\n    };\n\n    var computeEffectiveSetting = function (settings, property) {\n        return settings && settings[property] ? settings[property] : $.timepicker._defaults[property];\n    };\n\n    /*\n    * Splits datetime string into date and time substrings.\n    * Throws exception when date can't be parsed\n    * Returns {dateString: dateString, timeString: timeString}\n    */\n    var splitDateTime = function (dateTimeString, timeSettings) {\n        // The idea is to get the number separator occurrences in datetime and the time format requested (since time has\n        // fewer unknowns, mostly numbers and am/pm). We will use the time pattern to split.\n        var separator = computeEffectiveSetting(timeSettings, 'separator'),\n            format = computeEffectiveSetting(timeSettings, 'timeFormat'),\n            timeParts = format.split(separator), // how many occurrences of separator may be in our format?\n            timePartsLen = timeParts.length,\n            allParts = dateTimeString.split(separator),\n            allPartsLen = allParts.length;\n\n        if (allPartsLen > 1) {\n            return {\n                dateString: allParts.splice(0, allPartsLen - timePartsLen).join(separator),\n                timeString: allParts.splice(0, timePartsLen).join(separator)\n            };\n        }\n\n        return {\n            dateString: dateTimeString,\n            timeString: ''\n        };\n    };\n\n    /*\n    * Internal function to parse datetime interval\n    * Returns: {date: Date, timeObj: Object}, where\n    *   date - parsed date without time (type Date)\n    *   timeObj = {hour: , minute: , second: , millisec: , microsec: } - parsed time. Optional\n    */\n    var parseDateTimeInternal = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var date,\n            parts,\n            parsedTime;\n\n        parts = splitDateTime(dateTimeString, timeSettings);\n        date = $.datepicker._base_parseDate(dateFormat, parts.dateString, dateSettings);\n\n        if (parts.timeString === '') {\n            return {\n                date: date\n            };\n        }\n\n        parsedTime = $.datepicker.parseTime(timeFormat, parts.timeString, timeSettings);\n\n        if (!parsedTime) {\n            throw 'Wrong time format';\n        }\n\n        return {\n            date: date,\n            timeObj: parsedTime\n        };\n    };\n\n    /*\n    * Internal function to set timezone_select to the local timezone\n    */\n    var selectLocalTimezone = function (tp_inst, date) {\n        if (tp_inst && tp_inst.timezone_select) {\n            var now = date || new Date();\n            tp_inst.timezone_select.val(-now.getTimezoneOffset());\n        }\n    };\n\n    /*\n    * Create a Singleton Instance\n    */\n    $.timepicker = new Timepicker();\n\n    /**\n     * Get the timezone offset as string from a date object (eg '+0530' for UTC+5.5)\n     * @param {number} tzMinutes if not a number, less than -720 (-1200), or greater than 840 (+1400) this value is returned\n     * @param {boolean} iso8601 if true formats in accordance to iso8601 \"+12:45\"\n     * @return {string}\n     */\n    $.timepicker.timezoneOffsetString = function (tzMinutes, iso8601) {\n        if (isNaN(tzMinutes) || tzMinutes > 840 || tzMinutes < -720) {\n            return tzMinutes;\n        }\n\n        var off = tzMinutes,\n            minutes = off % 60,\n            hours = (off - minutes) / 60,\n            iso = iso8601 ? ':' : '',\n            tz = (off >= 0 ? '+' : '-') + ('0' + Math.abs(hours)).slice(-2) + iso + ('0' + Math.abs(minutes)).slice(-2);\n\n        if (tz === '+00:00') {\n            return 'Z';\n        }\n        return tz;\n    };\n\n    /**\n     * Get the number in minutes that represents a timezone string\n     * @param  {string} tzString formatted like \"+0500\", \"-1245\", \"Z\"\n     * @return {number} the offset minutes or the original string if it doesn't match expectations\n     */\n    $.timepicker.timezoneOffsetNumber = function (tzString) {\n        var normalized = tzString.toString().replace(':', ''); // excuse any iso8601, end up with \"+1245\"\n\n        if (normalized.toUpperCase() === 'Z') { // if iso8601 with Z, its 0 minute offset\n            return 0;\n        }\n\n        if (!/^(\\-|\\+)\\d{4}$/.test(normalized)) { // possibly a user defined tz, so just give it back\n            return parseInt(tzString, 10);\n        }\n\n        return ((normalized.substr(0, 1) === '-' ? -1 : 1) * // plus or minus\n            ((parseInt(normalized.substr(1, 2), 10) * 60) + // hours (converted to minutes)\n                parseInt(normalized.substr(3, 2), 10))); // minutes\n    };\n\n    /**\n     * No way to set timezone in js Date, so we must adjust the minutes to compensate. (think setDate, getDate)\n     * @param  {Date} date\n     * @param  {string} fromTimezone formatted like \"+0500\", \"-1245\"\n     * @param  {string} toTimezone formatted like \"+0500\", \"-1245\"\n     * @return {Date}\n     */\n    $.timepicker.timezoneAdjust = function (date, fromTimezone, toTimezone) {\n        var fromTz = $.timepicker.timezoneOffsetNumber(fromTimezone);\n        var toTz = $.timepicker.timezoneOffsetNumber(toTimezone);\n        if (!isNaN(toTz)) {\n            date.setMinutes(date.getMinutes() + (-fromTz) - (-toTz));\n        }\n        return date;\n    };\n\n    /**\n     * Calls `timepicker()` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * n.b. The input value must be correctly formatted (reformatting is not supported)\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the timepicker() call\n     * @return {jQuery}\n     */\n    $.timepicker.timeRange = function (startTime, endTime, options) {\n        return $.timepicker.handleRange('timepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datetimepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @return {jQuery}\n     */\n    $.timepicker.datetimeRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datetimepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.dateRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `method` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.handleRange = function (method, startTime, endTime, options) {\n        options = $.extend({}, {\n            minInterval: 0, // min allowed interval in milliseconds\n            maxInterval: 0, // max allowed interval in milliseconds\n            start: {},      // options for start picker\n            end: {}         // options for end picker\n        }, options);\n\n        // for the mean time this fixes an issue with calling getDate with timepicker()\n        var timeOnly = false;\n        if(method === 'timepicker'){\n            timeOnly = true;\n            method = 'datetimepicker';\n        }\n\n        function checkDates(changed, other) {\n            var startdt = startTime[method]('getDate'),\n                enddt = endTime[method]('getDate'),\n                changeddt = changed[method]('getDate');\n\n            if (startdt !== null) {\n                var minDate = new Date(startdt.getTime()),\n                    maxDate = new Date(startdt.getTime());\n\n                minDate.setMilliseconds(minDate.getMilliseconds() + options.minInterval);\n                maxDate.setMilliseconds(maxDate.getMilliseconds() + options.maxInterval);\n\n                if (options.minInterval > 0 && minDate > enddt) { // minInterval check\n                    endTime[method]('setDate', minDate);\n                }\n                else if (options.maxInterval > 0 && maxDate < enddt) { // max interval check\n                    endTime[method]('setDate', maxDate);\n                }\n                else if (startdt > enddt) {\n                    other[method]('setDate', changeddt);\n                }\n            }\n        }\n\n        function selected(changed, other, option) {\n            if (!changed.val()) {\n                return;\n            }\n            var date = changed[method].call(changed, 'getDate');\n            if (date !== null && options.minInterval > 0) {\n                if (option === 'minDate') {\n                    date.setMilliseconds(date.getMilliseconds() + options.minInterval);\n                }\n                if (option === 'maxDate') {\n                    date.setMilliseconds(date.getMilliseconds() - options.minInterval);\n                }\n            }\n\n            if (date.getTime) {\n                other[method].call(other, 'option', option, date);\n            }\n        }\n\n        $.fn[method].call(startTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), endTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), endTime, 'minDate');\n            }\n        }, options, options.start));\n        $.fn[method].call(endTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), startTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), startTime, 'maxDate');\n            }\n        }, options, options.end));\n\n        checkDates(startTime, endTime);\n\n        selected(startTime, endTime, 'minDate');\n        selected(endTime, startTime, 'maxDate');\n\n        return $([startTime.get(0), endTime.get(0)]);\n    };\n\n    /**\n     * Log error or data to the console during error or debugging\n     * @param  {Object} err pass any type object to log to the console during error or debugging\n     * @return {void}\n     */\n    $.timepicker.log = function () {\n        // Older IE (9, maybe 10) throw error on accessing `window.console.log.apply`, so check first.\n        if (window.console && window.console.log && window.console.log.apply) {\n            window.console.log.apply(window.console, Array.prototype.slice.call(arguments));\n        }\n    };\n\n    /*\n     * Add util object to allow access to private methods for testability.\n     */\n    $.timepicker._util = {\n        _extendRemove: extendRemove,\n        _isEmptyObject: isEmptyObject,\n        _convert24to12: convert24to12,\n        _detectSupport: detectSupport,\n        _selectLocalTimezone: selectLocalTimezone,\n        _computeEffectiveSetting: computeEffectiveSetting,\n        _splitDateTime: splitDateTime,\n        _parseDateTimeInternal: parseDateTimeInternal\n    };\n\n    /*\n    * Microsecond support\n    */\n    if (!Date.prototype.getMicroseconds) {\n        Date.prototype.microseconds = 0;\n        Date.prototype.getMicroseconds = function () { return this.microseconds; };\n        Date.prototype.setMicroseconds = function (m) {\n            this.setMilliseconds(this.getMilliseconds() + Math.floor(m / 1000));\n            this.microseconds = m % 1000;\n            return this;\n        };\n    }\n\n    /*\n    * Keep up with the version\n    */\n    $.timepicker.version = \"1.6.3\";\n\n}));\n","jquery/z-index.js":"/*!\n * zIndex plugin from jQuery UI Core - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/category/ui-core/\n */\ndefine([\n    'jquery'\n], function ($, undefined) {\n\n// plugins\n    $.fn.extend({\n        zIndex: function (zIndex) {\n            if (zIndex !== undefined) {\n                return this.css(\"zIndex\", zIndex);\n            }\n\n            if (this.length) {\n                var elem = $(this[0]), position, value;\n                while (elem.length && elem[0] !== document) {\n                    // Ignore z-index if position is set to a value where z-index is ignored by the browser\n                    // This makes behavior of this function consistent across browsers\n                    // WebKit always returns auto if the element is positioned\n                    position = elem.css(\"position\");\n                    if (position === \"absolute\" || position === \"relative\" || position === \"fixed\") {\n                        // IE returns 0 when zIndex is not specified\n                        // other browsers return a string\n                        // we ignore the case of nested elements with an explicit value of 0\n                        // <div style=\"z-index: -10;\"><div style=\"z-index: 0;\"></div></div>\n                        value = parseInt(elem.css(\"zIndex\"), 10);\n                        if (!isNaN(value) && value !== 0) {\n                            return value;\n                        }\n                    }\n                    elem = elem.parent();\n                }\n            }\n\n            return 0;\n        }\n    });\n});\n","jquery/jquery.metadata.js":"/*\n * Metadata - jQuery plugin for parsing metadata from elements\n *\n * Copyright (c) 2006 John Resig, Yehuda Katz, J\u00ef\u00bf\u00bd\u00c3\u00b6rn Zaefferer, Paul McLanahan\n *\n * Dual licensed under the MIT and GPL licenses:\n *   http://www.opensource.org/licenses/mit-license.php\n *   http://www.gnu.org/licenses/gpl.html\n *\n * Revision: $Id: jquery.metadata.js 3640 2007-10-11 18:34:38Z pmclanahan $\n *\n */\n\n/**\n * Sets the type of metadata to use. Metadata is encoded in JSON, and each property\n * in the JSON will become a property of the element itself.\n *\n * There are four supported types of metadata storage:\n *\n *   attr:  Inside an attribute. The name parameter indicates *which* attribute.\n *\n *   class: Inside the class attribute, wrapped in curly braces: { }\n *\n *   elem:  Inside a child element (e.g. a script tag). The\n *          name parameter indicates *which* element.\n *   html5: Values are stored in data-* attributes.\n *\n * The metadata for an element is loaded the first time the element is accessed via jQuery.\n *\n * As a result, you can define the metadata type, use $(expr) to load the metadata into the elements\n * matched by expr, then redefine the metadata type and run another $(expr) for other elements.\n *\n * @name $.metadata.setType\n *\n * @example <p id=\"one\" class=\"some_class {item_id: 1, item_label: 'Label'}\">This is a p</p>\n * @before $.metadata.setType(\"class\")\n * @after $(\"#one\").metadata().item_id == 1; $(\"#one\").metadata().item_label == \"Label\"\n * @desc Reads metadata from the class attribute\n *\n * @example <p id=\"one\" class=\"some_class\" data=\"{item_id: 1, item_label: 'Label'}\">This is a p</p>\n * @before $.metadata.setType(\"attr\", \"data\")\n * @after $(\"#one\").metadata().item_id == 1; $(\"#one\").metadata().item_label == \"Label\"\n * @desc Reads metadata from a \"data\" attribute\n *\n * @example <p id=\"one\" class=\"some_class\"><script>{item_id: 1, item_label: 'Label'}</script>This is a p</p>\n * @before $.metadata.setType(\"elem\", \"script\")\n * @after $(\"#one\").metadata().item_id == 1; $(\"#one\").metadata().item_label == \"Label\"\n * @desc Reads metadata from a nested script element\n *\n * @example <p id=\"one\" class=\"some_class\" data-item_id=\"1\" data-item_label=\"Label\">This is a p</p>\n * @before $.metadata.setType(\"html5\")\n * @after $(\"#one\").metadata().item_id == 1; $(\"#one\").metadata().item_label == \"Label\"\n * @desc Reads metadata from a series of data-* attributes\n *\n * @param String type The encoding type\n * @param String name The name of the attribute to be used to get metadata (optional)\n * @cat Plugins/Metadata\n * @descr Sets the type of encoding to be used when loading metadata for the first time\n * @type undefined\n * @see metadata()\n */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\"jquery\"], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n\n    $.extend({\n        metadata : {\n            defaults : {\n                type: 'class',\n                name: 'metadata',\n                cre: /({.*})/,\n                single: 'metadata',\n                meta:'validate'\n            },\n            setType: function( type, name ){\n                this.defaults.type = type;\n                this.defaults.name = name;\n            },\n            get: function( elem, opts ){\n                var settings = $.extend({},this.defaults,opts);\n                // check for empty string in single property\n                if (!settings.single.length) {\n                    settings.single = 'metadata';\n                }\n                if (!settings.meta.length) {\n                    settings.meta = 'validate';\n                }\n\n                var data = $.data(elem, settings.single);\n                // returned cached data if it already exists\n                if ( data ) return data;\n\n                data = \"{}\";\n\n                var getData = function(data) {\n                    if(typeof data != \"string\") return data;\n\n                    if( data.indexOf('{') < 0 ) {\n                        data = eval(\"(\" + data + \")\");\n                    }\n                }\n\n                var getObject = function(data) {\n                    if(typeof data != \"string\") return data;\n\n                    data = eval(\"(\" + data + \")\");\n                    return data;\n                }\n\n                if ( settings.type == \"html5\" ) {\n                    var object = {};\n                    $( elem.attributes ).each(function() {\n                        var name = this.nodeName;\n                        if (name.indexOf('data-' + settings.meta) === 0) {\n                            name = name.replace(/^data-/, '');\n                        }\n                        else {\n                            return true;\n                        }\n                        object[name] = getObject(this.value);\n                    });\n                } else {\n                    if ( settings.type == \"class\" ) {\n                        var m = settings.cre.exec( elem.className );\n                        if ( m )\n                            data = m[1];\n                    } else if ( settings.type == \"elem\" ) {\n                        if( !elem.getElementsByTagName ) return;\n                        var e = elem.getElementsByTagName(settings.name);\n                        if ( e.length )\n                            data = $.trim(e[0].innerHTML);\n                    } else if ( elem.getAttribute != undefined ) {\n                        var attr = elem.getAttribute( settings.name );\n                        if ( attr )\n                            data = attr;\n                    }\n                    object = getObject(data.indexOf(\"{\") < 0 ? \"{\" + data + \"}\" : data);\n                }\n\n                $.data( elem, settings.single, object );\n                return object;\n            }\n        }\n    });\n\n    /**\n     * Returns the metadata object for the first member of the jQuery object.\n     *\n     * @name metadata\n     * @descr Returns element's metadata object\n     * @param Object opts An object contianing settings to override the defaults\n     * @type jQuery\n     * @cat Plugins/Metadata\n     */\n    $.fn.metadata = function( opts ){\n        return $.metadata.get( this[0], opts );\n    };\n\n}));","jquery/bootstrap/collapse.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): collapse.js and base-component.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([\n    \"jquery\",\n    \"./util/index\",\n    \"./dom/data\",\n    \"./dom/event-handler\",\n    \"./dom/manipulator\",\n    \"./dom/selector-engine\"\n], function($, Util, Data, EventHandler, Manipulator, SelectorEngine) {\n    'use strict';\n\n    const defineJQueryPlugin = Util.defineJQueryPlugin;\n    const executeAfterTransition = Util.executeAfterTransition;\n    const getElement = Util.getElement;\n    const getSelectorFromElement = Util.getSelectorFromElement;\n    const getElementFromSelector = Util.getElementFromSelector;\n    const reflow = Util.reflow;\n    const typeCheckConfig = Util.typeCheckConfig;\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const VERSION = '5.1.3';\n    const NAME = 'collapse';\n    const DATA_KEY = 'bs.collapse';\n    const EVENT_KEY = `.${DATA_KEY}`;\n    const DATA_API_KEY = '.data-api';\n\n    const Default = {\n        toggle: true,\n        parent: null\n    };\n\n    const DefaultType = {\n        toggle: 'boolean',\n        parent: '(null|element)'\n    };\n\n    const EVENT_SHOW = `show${EVENT_KEY}`;\n    const EVENT_SHOWN = `shown${EVENT_KEY}`;\n    const EVENT_HIDE = `hide${EVENT_KEY}`;\n    const EVENT_HIDDEN = `hidden${EVENT_KEY}`;\n    const EVENT_CLICK_DATA_API = `click${EVENT_KEY}${DATA_API_KEY}`;\n\n    const CLASS_NAME_SHOW = 'show';\n    const CLASS_NAME_COLLAPSE = 'collapse';\n    const CLASS_NAME_COLLAPSING = 'collapsing';\n    const CLASS_NAME_COLLAPSED = 'collapsed';\n    const CLASS_NAME_DEEPER_CHILDREN = `:scope .${CLASS_NAME_COLLAPSE} .${CLASS_NAME_COLLAPSE}`;\n    const CLASS_NAME_HORIZONTAL = 'collapse-horizontal';\n\n    const WIDTH = 'width';\n    const HEIGHT = 'height';\n\n    const SELECTOR_ACTIVES = '.collapse.show, .collapse.collapsing';\n    const SELECTOR_DATA_TOGGLE = '[data-bs-toggle=\"collapse\"]';\n\n    /**\n     * ------------------------------------------------------------------------\n     * Class Definition\n     * ------------------------------------------------------------------------\n     */\n\n    var Collapse = function(element, config) {\n        element = getElement(element);\n\n        if (!element) {\n            return;\n        }\n\n        this._element = element;\n        Data.set(this._element, DATA_KEY, this);\n\n        this._isTransitioning = false;\n        this._config = this._getConfig(config);\n        this._triggerArray = [];\n\n        const toggleList = SelectorEngine.find(SELECTOR_DATA_TOGGLE);\n\n        for (let i = 0, len = toggleList.length; i < len; i++) {\n            const elem = toggleList[i];\n            const selector = getSelectorFromElement(elem);\n            const filterElement = SelectorEngine.find(selector)\n                .filter(foundElem => foundElem === this._element);\n\n            if (selector !== null && filterElement.length) {\n                this._selector = selector;\n                this._triggerArray.push(elem);\n            }\n        }\n\n        this._initializeChildren();\n\n        if (!this._config.parent) {\n            this._addAriaAndCollapsedClass(this._triggerArray, this._isShown());\n        }\n\n        if (this._config.toggle) {\n            this.toggle();\n        }\n    }\n\n    // Getters\n\n    Collapse.VERSION = VERSION;\n\n    Collapse.Default = Default;\n\n    Collapse.NAME = NAME;\n\n    Collapse.DATA_KEY = 'bs.' + Collapse.NAME;\n\n    Collapse.EVENT_KEY = '.' + Collapse.DATA_KEY;\n\n    // Public\n\n    Collapse.prototype.dispose = function() {\n        Data.remove(this._element, this.constructor.DATA_KEY);\n        EventHandler.off(this._element, this.constructor.EVENT_KEY);\n\n        Object.getOwnPropertyNames(this).forEach(propertyName => {\n            this[propertyName] = null;\n        })\n    }\n\n    Collapse.prototype._queueCallback = function(callback, element, isAnimated = true) {\n        executeAfterTransition(callback, element, isAnimated);\n    }\n\n    Collapse.prototype.toggle = function() {\n        if (this._isShown()) {\n            this.hide();\n        } else {\n            this.show();\n        }\n    }\n\n    Collapse.prototype.show = function() {\n        if (this._isTransitioning || this._isShown()) {\n            return;\n        }\n\n        let actives = [];\n        let activesData;\n\n        if (this._config.parent) {\n            const children = SelectorEngine.find(CLASS_NAME_DEEPER_CHILDREN, this._config.parent);\n            actives = SelectorEngine.find(SELECTOR_ACTIVES, this._config.parent).filter(elem => !children.includes(elem)); // remove children if greater depth\n        }\n\n        const container = SelectorEngine.findOne(this._selector);\n        if (actives.length) {\n            const tempActiveData = actives.find(elem => container !== elem);\n            activesData = tempActiveData ? Collapse.getInstance(tempActiveData) : null;\n\n            if (activesData && activesData._isTransitioning) {\n                return;\n            }\n        }\n\n        const startEvent = EventHandler.trigger(this._element, EVENT_SHOW);\n        if (startEvent.defaultPrevented) {\n            return;\n        }\n\n        actives.forEach(elemActive => {\n            if (container !== elemActive) {\n                Collapse.getOrCreateInstance(elemActive, {toggle: false}).hide();\n            }\n\n            if (!activesData) {\n                Data.set(elemActive, DATA_KEY, null);\n            }\n        })\n\n        const dimension = this._getDimension();\n\n        this._element.classList.remove(CLASS_NAME_COLLAPSE);\n        this._element.classList.add(CLASS_NAME_COLLAPSING);\n\n        this._element.style[dimension] = 0;\n\n        this._addAriaAndCollapsedClass(this._triggerArray, true);\n        this._isTransitioning = true;\n\n        const complete = () => {\n            this._isTransitioning = false;\n\n            this._element.classList.remove(CLASS_NAME_COLLAPSING);\n            this._element.classList.add(CLASS_NAME_COLLAPSE, CLASS_NAME_SHOW);\n\n            this._element.style[dimension] = '';\n\n            EventHandler.trigger(this._element, EVENT_SHOWN);\n        };\n\n        const capitalizedDimension = dimension[0].toUpperCase() + dimension.slice(1);\n        const scrollSize = `scroll${capitalizedDimension}`;\n\n        this._queueCallback(complete, this._element, true);\n        this._element.style[dimension] = `${this._element[scrollSize]}px`;\n    }\n\n    Collapse.prototype.hide = function() {\n        if (this._isTransitioning || !this._isShown()) {\n            return;\n        }\n\n        const startEvent = EventHandler.trigger(this._element, EVENT_HIDE);\n        if (startEvent.defaultPrevented) {\n            return;\n        }\n\n        const dimension = this._getDimension();\n\n        this._element.style[dimension] = `${this._element.getBoundingClientRect()[dimension]}px`;\n\n        reflow(this._element);\n\n        this._element.classList.add(CLASS_NAME_COLLAPSING);\n        this._element.classList.remove(CLASS_NAME_COLLAPSE, CLASS_NAME_SHOW);\n\n        const triggerArrayLength = this._triggerArray.length;\n        for (let i = 0; i < triggerArrayLength; i++) {\n            const trigger = this._triggerArray[i];\n            const elem = getElementFromSelector(trigger);\n\n            if (elem && !this._isShown(elem)) {\n                this._addAriaAndCollapsedClass([trigger], false);\n            }\n        }\n\n        this._isTransitioning = true;\n\n        const complete = () => {\n            this._isTransitioning = false;\n            this._element.classList.remove(CLASS_NAME_COLLAPSING);\n            this._element.classList.add(CLASS_NAME_COLLAPSE);\n            EventHandler.trigger(this._element, EVENT_HIDDEN);\n        };\n\n        this._element.style[dimension] = '';\n\n        this._queueCallback(complete, this._element, true);\n    }\n\n    Collapse.prototype._isShown = function(element = this._element) {\n        return element.classList.contains(CLASS_NAME_SHOW);\n    }\n\n    // Private\n\n    Collapse.prototype._getConfig = function(config) {\n        config = {\n            ...Default,\n            ...Manipulator.getDataAttributes(this._element),\n            ...config\n        };\n        config.toggle = Boolean(config.toggle); // Coerce string values\n        config.parent = getElement(config.parent);\n        typeCheckConfig(NAME, config, DefaultType);\n        return config;\n    }\n\n    Collapse.prototype._getDimension = function() {\n        return this._element.classList.contains(CLASS_NAME_HORIZONTAL) ? WIDTH : HEIGHT;\n    }\n\n    Collapse.prototype._initializeChildren = function() {\n        if (!this._config.parent) {\n            return;\n        }\n\n        const children = SelectorEngine.find(CLASS_NAME_DEEPER_CHILDREN, this._config.parent);\n        SelectorEngine.find(SELECTOR_DATA_TOGGLE, this._config.parent).filter(elem => !children.includes(elem))\n            .forEach(element => {\n                const selected = getElementFromSelector(element);\n\n                if (selected) {\n                    this._addAriaAndCollapsedClass([element], this._isShown(selected));\n                }\n            })\n    }\n\n    Collapse.prototype._addAriaAndCollapsedClass = function(triggerArray, isOpen) {\n        if (!triggerArray.length) {\n            return;\n        }\n\n        triggerArray.forEach(elem => {\n            if (isOpen) {\n                elem.classList.remove(CLASS_NAME_COLLAPSED);\n            } else {\n                elem.classList.add(CLASS_NAME_COLLAPSED);\n            }\n\n            elem.setAttribute('aria-expanded', isOpen);\n        })\n    }\n\n    // Static\n\n    Collapse.getInstance = function(element) {\n        return Data.get(getElement(element), this.DATA_KEY);\n    }\n\n    Collapse.getOrCreateInstance = function(element, config = {}) {\n        return this.getInstance(element) || new this(element, typeof config === 'object' ? config : null);\n    }\n\n    Collapse.jQueryInterface = function(config) {\n        return this.each(function () {\n            const _config = {};\n            if (typeof config === 'string' && /show|hide/.test(config)) {\n                _config.toggle = false;\n            }\n\n            const data = Collapse.getOrCreateInstance(this, _config);\n\n            if (typeof config === 'string') {\n                if (typeof data[config] === 'undefined') {\n                    throw new TypeError(`No method named \"${config}\"`);\n                }\n\n                data[config]();\n            }\n        })\n    }\n\n    /**\n     * ------------------------------------------------------------------------\n     * Data Api implementation\n     * ------------------------------------------------------------------------\n     */\n\n    EventHandler.on(document, EVENT_CLICK_DATA_API, SELECTOR_DATA_TOGGLE, function (event) {\n        // preventDefault only for <a> elements (which change the URL) not inside the collapsible element\n        if (event.target.tagName === 'A' || (event.delegateTarget && event.delegateTarget.tagName === 'A')) {\n            event.preventDefault();\n        }\n\n        const selector = getSelectorFromElement(this);\n        const selectorElements = SelectorEngine.find(selector);\n\n        selectorElements.forEach(element => {\n            Collapse.getOrCreateInstance(element, {toggle: false}).toggle();\n        })\n    })\n\n    /**\n     * ------------------------------------------------------------------------\n     * jQuery\n     * ------------------------------------------------------------------------\n     * add .Collapse to jQuery only if jQuery is present\n     */\n\n    defineJQueryPlugin(Collapse);\n\n    return Collapse;\n});\n","jquery/bootstrap/tab.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): tab.js and base-component.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([\n    \"./util/index\",\n    \"./dom/event-handler\",\n    \"./dom/selector-engine\"\n], function(Util, EventHandler, SelectorEngine) {\n    'use strict';\n\n    const defineJQueryPlugin = Util.defineJQueryPlugin;\n    const executeAfterTransition = Util.executeAfterTransition;\n    const getElement = Util.getElement;\n    const getElementFromSelector = Util.getElementFromSelector;\n    const isDisabled = Util.isDisabled;\n    const reflow = Util.reflow;\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const VERSION = '5.1.3';\n    const NAME = 'tab';\n    const DATA_KEY = 'bs.tab';\n    const EVENT_KEY = `.${DATA_KEY}`;\n    const DATA_API_KEY = '.data-api';\n\n    const EVENT_HIDE = `hide${EVENT_KEY}`;\n    const EVENT_HIDDEN = `hidden${EVENT_KEY}`;\n    const EVENT_SHOW = `show${EVENT_KEY}`;\n    const EVENT_SHOWN = `shown${EVENT_KEY}`;\n    const EVENT_CLICK_DATA_API = `click${EVENT_KEY}${DATA_API_KEY}`;\n\n    const CLASS_NAME_DROPDOWN_MENU = 'dropdown-menu';\n    const CLASS_NAME_ACTIVE = 'active';\n    const CLASS_NAME_FADE = 'fade';\n    const CLASS_NAME_SHOW = 'show';\n\n    const SELECTOR_DROPDOWN = '.dropdown';\n    const SELECTOR_NAV_LIST_GROUP = '.nav, .list-group';\n    const SELECTOR_ACTIVE = '.active';\n    const SELECTOR_ACTIVE_UL = ':scope > li > .active';\n    const SELECTOR_DATA_TOGGLE = '[data-bs-toggle=\"tab\"], [data-bs-toggle=\"pill\"], [data-bs-toggle=\"list\"]';\n    const SELECTOR_DROPDOWN_TOGGLE = '.dropdown-toggle';\n    const SELECTOR_DROPDOWN_ACTIVE_CHILD = ':scope > .dropdown-menu .active';\n\n    /**\n     * ------------------------------------------------------------------------\n     * Class Definition\n     * ------------------------------------------------------------------------\n     */\n\n    function Tab(element) {\n        element = getElement(element);\n\n        if (!element) {\n            return;\n        }\n\n        this._element = element;\n        Data.set(this._element, DATA_KEY, this);\n    }\n\n    // Getters\n\n    Tab.VERSION = VERSION;\n\n    Tab.NAME = NAME;\n\n    Tab.DATA_KEY = 'bs.' + Tab.NAME;\n\n    Tab.EVENT_KEY = '.' + Tab.DATA_KEY;\n\n    // Public\n\n    Tab.prototype.dispose = function() {\n        Data.remove(this._element, this.constructor.DATA_KEY);\n        EventHandler.off(this._element, this.constructor.EVENT_KEY);\n\n        Object.getOwnPropertyNames(this).forEach(propertyName => {\n            this[propertyName] = null;\n        })\n    }\n\n    Tab.prototype._queueCallback = function(callback, element, isAnimated = true) {\n        executeAfterTransition(callback, element, isAnimated);\n    }\n\n    Tab.prototype.show = function() {\n        if ((this._element.parentNode &&\n            this._element.parentNode.nodeType === Node.ELEMENT_NODE &&\n            this._element.classList.contains(CLASS_NAME_ACTIVE))) {\n            return;\n        }\n\n        let previous;\n        const target = getElementFromSelector(this._element);\n        const listElement = this._element.closest(SELECTOR_NAV_LIST_GROUP);\n\n        if (listElement) {\n            const itemSelector = listElement.nodeName === 'UL' || listElement.nodeName === 'OL' ? SELECTOR_ACTIVE_UL : SELECTOR_ACTIVE;\n            previous = SelectorEngine.find(itemSelector, listElement);\n            previous = previous[previous.length - 1];\n        }\n\n        const hideEvent = previous ?\n            EventHandler.trigger(previous, EVENT_HIDE, {\n                relatedTarget: this._element\n            }) :\n            null;\n\n        const showEvent = EventHandler.trigger(this._element, EVENT_SHOW, {\n            relatedTarget: previous\n        });\n\n        if (showEvent.defaultPrevented || (hideEvent !== null && hideEvent.defaultPrevented)) {\n            return;\n        }\n\n        this._activate(this._element, listElement);\n\n        const complete = () => {\n            EventHandler.trigger(previous, EVENT_HIDDEN, {\n                relatedTarget: this._element\n            });\n            EventHandler.trigger(this._element, EVENT_SHOWN, {\n                relatedTarget: previous\n            });\n        };\n\n        if (target) {\n            this._activate(target, target.parentNode, complete);\n        } else {\n            complete();\n        }\n    }\n\n    // Private\n\n    Tab.prototype._activate = function(element, container, callback) {\n        const activeElements = container && (container.nodeName === 'UL' || container.nodeName === 'OL') ?\n            SelectorEngine.find(SELECTOR_ACTIVE_UL, container) :\n            SelectorEngine.children(container, SELECTOR_ACTIVE);\n\n        const active = activeElements[0];\n        const isTransitioning = callback && (active && active.classList.contains(CLASS_NAME_FADE));\n\n        const complete = () => this._transitionComplete(element, active, callback);\n\n        if (active && isTransitioning) {\n            active.classList.remove(CLASS_NAME_SHOW);\n            this._queueCallback(complete, element, true);\n        } else {\n            complete();\n        }\n    }\n\n    Tab.prototype._transitionComplete = function(element, active, callback) {\n        if (active) {\n            active.classList.remove(CLASS_NAME_ACTIVE);\n\n            const dropdownChild = SelectorEngine.findOne(SELECTOR_DROPDOWN_ACTIVE_CHILD, active.parentNode);\n\n            if (dropdownChild) {\n                dropdownChild.classList.remove(CLASS_NAME_ACTIVE);\n            }\n\n            if (active.getAttribute('role') === 'tab') {\n                active.setAttribute('aria-selected', false);\n            }\n        }\n\n        element.classList.add(CLASS_NAME_ACTIVE);\n        if (element.getAttribute('role') === 'tab') {\n            element.setAttribute('aria-selected', true);\n        }\n\n        reflow(element);\n\n        if (element.classList.contains(CLASS_NAME_FADE)) {\n            element.classList.add(CLASS_NAME_SHOW);\n        }\n\n        let parent = element.parentNode;\n        if (parent && parent.nodeName === 'LI') {\n            parent = parent.parentNode;\n        }\n\n        if (parent && parent.classList.contains(CLASS_NAME_DROPDOWN_MENU)) {\n            const dropdownElement = element.closest(SELECTOR_DROPDOWN);\n\n            if (dropdownElement) {\n                SelectorEngine.find(SELECTOR_DROPDOWN_TOGGLE, dropdownElement)\n                    .forEach(dropdown => dropdown.classList.add(CLASS_NAME_ACTIVE));\n            }\n\n            element.setAttribute('aria-expanded', true);\n        }\n\n        if (callback) {\n            callback();\n        }\n    }\n\n    // Static\n\n    Tab.getInstance = function(element) {\n        return Data.get(getElement(element), this.DATA_KEY);\n    }\n\n    Tab.getOrCreateInstance = function(element, config = {}) {\n        return this.getInstance(element) || new this(element, typeof config === 'object' ? config : null);\n    }\n\n    Tab.jQueryInterface = function(config) {\n        return this.each(function () {\n            const data = Tab.getOrCreateInstance(this);\n\n            if (typeof config === 'string') {\n                if (typeof data[config] === 'undefined') {\n                    throw new TypeError(`No method named \"${config}\"`);\n                }\n\n                data[config]();\n            }\n        })\n    }\n\n    /**\n     * ------------------------------------------------------------------------\n     * Data Api implementation\n     * ------------------------------------------------------------------------\n     */\n\n    EventHandler.on(document, EVENT_CLICK_DATA_API, SELECTOR_DATA_TOGGLE, function (event) {\n        if (['A', 'AREA'].includes(this.tagName)) {\n            event.preventDefault();\n        }\n\n        if (isDisabled(this)) {\n            return;\n        }\n\n        const data = Tab.getOrCreateInstance(this);\n        data.show();\n    })\n\n    /**\n     * ------------------------------------------------------------------------\n     * jQuery\n     * ------------------------------------------------------------------------\n     * add .Tab to jQuery only if jQuery is present\n     */\n\n    defineJQueryPlugin(Tab);\n\n    return Tab;\n});\n","jquery/bootstrap/util/index.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): util/index.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\n\ndefine([\n    \"jquery\",\n    'domReady!'\n], function() {\n    'use strict';\n\n    const MAX_UID = 1000000;\n    const MILLISECONDS_MULTIPLIER = 1000;\n    const TRANSITION_END = 'transitionend';\n\n    // Shoutout AngusCroll (https://goo.gl/pxwQGp)\n    const toType = obj => {\n        if (obj === null || obj === undefined) {\n            return `${obj}`\n        }\n\n        return {}.toString.call(obj).match(/\\s([a-z]+)/i)[1].toLowerCase()\n    };\n\n    /**\n     * --------------------------------------------------------------------------\n     * Public Util Api\n     * --------------------------------------------------------------------------\n     */\n\n    const getUID = prefix => {\n        do {\n            prefix += Math.floor(Math.random() * MAX_UID)\n        } while (document.getElementById(prefix))\n\n        return prefix\n    };\n\n    const getSelector = element => {\n        let selector = element.getAttribute('data-bs-target');\n\n        if (!selector || selector === '#') {\n            let hrefAttr = element.getAttribute('href');\n\n            // The only valid content that could double as a selector are IDs or classes,\n            // so everything starting with `#` or `.`. If a \"real\" URL is used as the selector,\n            // `document.querySelector` will rightfully complain it is invalid.\n            // See https://github.com/twbs/bootstrap/issues/32273\n            if (!hrefAttr || (!hrefAttr.includes('#') && !hrefAttr.startsWith('.'))) {\n                return null\n            }\n\n            // Just in case some CMS puts out a full URL with the anchor appended\n            if (hrefAttr.includes('#') && !hrefAttr.startsWith('#')) {\n                hrefAttr = `#${hrefAttr.split('#')[1]}`\n            }\n\n            selector = hrefAttr && hrefAttr !== '#' ? hrefAttr.trim() : null\n        }\n\n        return selector\n    };\n\n    const getSelectorFromElement = element => {\n        const selector = getSelector(element);\n\n        if (selector) {\n            return document.querySelector(selector) ? selector : null\n        }\n\n        return null\n    };\n\n    const getElementFromSelector = element => {\n        const selector = getSelector(element);\n\n        return selector ? document.querySelector(selector) : null\n    };\n\n    const getTransitionDurationFromElement = element => {\n        if (!element) {\n            return 0\n        }\n\n        // Get transition-duration of the element\n        let {transitionDuration, transitionDelay} = window.getComputedStyle(element);\n\n        const floatTransitionDuration = Number.parseFloat(transitionDuration);\n        const floatTransitionDelay = Number.parseFloat(transitionDelay);\n\n        // Return 0 if element or transition duration is not found\n        if (!floatTransitionDuration && !floatTransitionDelay) {\n            return 0\n        }\n\n        // If multiple durations are defined, take the first\n        transitionDuration = transitionDuration.split(',')[0]\n        transitionDelay = transitionDelay.split(',')[0]\n\n        return (Number.parseFloat(transitionDuration) + Number.parseFloat(transitionDelay)) * MILLISECONDS_MULTIPLIER\n    };\n\n    const triggerTransitionEnd = element => {\n        element.dispatchEvent(new Event(TRANSITION_END))\n    };\n\n    const isElement = obj => {\n        if (!obj || typeof obj !== 'object') {\n            return false\n        }\n\n        if (typeof obj.jquery !== 'undefined') {\n            obj = obj[0]\n        }\n\n        return typeof obj.nodeType !== 'undefined'\n    };\n\n    const getElement = obj => {\n        if (isElement(obj)) { // it's a jQuery object or a node element\n            return obj.jquery ? obj[0] : obj\n        }\n\n        if (typeof obj === 'string' && obj.length > 0) {\n            return document.querySelector(obj)\n        }\n\n        return null\n    };\n\n    const typeCheckConfig = (componentName, config, configTypes) => {\n        Object.keys(configTypes).forEach(property => {\n            const expectedTypes = configTypes[property];\n            const value = config[property];\n            const valueType = value && isElement(value) ? 'element' : toType(value);\n\n            if (!new RegExp(expectedTypes).test(valueType)) {\n                throw new TypeError(\n                    `${componentName.toUpperCase()}: Option \"${property}\" provided type \"${valueType}\" but expected type \"${expectedTypes}\".`\n                )\n            }\n        })\n    };\n\n    const isVisible = element => {\n        if (!isElement(element) || element.getClientRects().length === 0) {\n            return false\n        }\n\n        return getComputedStyle(element).getPropertyValue('visibility') === 'visible'\n    };\n\n    const isDisabled = element => {\n        if (!element || element.nodeType !== Node.ELEMENT_NODE) {\n            return true\n        }\n\n        if (element.classList.contains('disabled')) {\n            return true\n        }\n\n        if (typeof element.disabled !== 'undefined') {\n            return element.disabled\n        }\n\n        return element.hasAttribute('disabled') && element.getAttribute('disabled') !== 'false'\n    };\n\n    const findShadowRoot = element => {\n        if (!document.documentElement.attachShadow) {\n            return null\n        }\n\n        // Can find the shadow root otherwise it'll return the document\n        if (typeof element.getRootNode === 'function') {\n            const root = element.getRootNode();\n            return root instanceof ShadowRoot ? root : null\n        }\n\n        if (element instanceof ShadowRoot) {\n            return element\n        }\n\n        // when we don't find a shadow root\n        if (!element.parentNode) {\n            return null\n        }\n\n        return findShadowRoot(element.parentNode)\n    };\n\n    const noop = () => {};\n\n    /**\n     * Trick to restart an element's animation\n     *\n     * @param {HTMLElement} element\n     * @return void\n     *\n     * @see https://www.charistheo.io/blog/2021/02/restart-a-css-animation-with-javascript/#restarting-a-css-animation\n     */\n    const reflow = element => {\n        // eslint-disable-next-line no-unused-expressions\n        element.offsetHeight\n    };\n\n    const getjQuery = () => {\n        const {jQuery} = window;\n\n        if (jQuery && !document.body.hasAttribute('data-bs-no-jquery')) {\n            return jQuery\n        }\n\n        return null\n    };\n\n    const DOMContentLoadedCallbacks = [];\n\n    const onDOMContentLoaded = callback => {\n        if (document.readyState === 'loading') {\n            // add listener on the first call when the document is in loading state\n            if (!DOMContentLoadedCallbacks.length) {\n                document.addEventListener('DOMContentLoaded', () => {\n                    DOMContentLoadedCallbacks.forEach(callback => callback())\n                })\n            }\n\n            DOMContentLoadedCallbacks.push(callback)\n        } else {\n            callback()\n        }\n    };\n\n    const isRTL = () => document.documentElement.dir === 'rtl';\n\n    const defineJQueryPlugin = plugin => {\n        onDOMContentLoaded(() => {\n            const $ = getjQuery();\n            /* istanbul ignore if */\n            if ($) {\n                const name = plugin.NAME;\n                const JQUERY_NO_CONFLICT = $.fn[name];\n                $.fn[name] = plugin.jQueryInterface\n                $.fn[name].Constructor = plugin\n                $.fn[name].noConflict = () => {\n                    $.fn[name] = JQUERY_NO_CONFLICT\n                    return plugin.jQueryInterface\n                }\n            }\n        })\n    };\n\n    const execute = callback => {\n        if (typeof callback === 'function') {\n            callback()\n        }\n    };\n\n    const executeAfterTransition = (callback, transitionElement, waitForTransition = true) => {\n        if (!waitForTransition) {\n            execute(callback)\n            return\n        }\n\n        const durationPadding = 5;\n        const emulatedDuration = getTransitionDurationFromElement(transitionElement) + durationPadding;\n\n        let called = false;\n\n        const handler = ({ target }) => {\n            if (target !== transitionElement) {\n                return\n            }\n\n            called = true\n            transitionElement.removeEventListener(TRANSITION_END, handler)\n            execute(callback)\n        };\n\n        transitionElement.addEventListener(TRANSITION_END, handler)\n        setTimeout(() => {\n            if (!called) {\n                triggerTransitionEnd(transitionElement)\n            }\n        }, emulatedDuration)\n    };\n\n    /**\n     * Return the previous/next element of a list.\n     *\n     * @param {array} list    The list of elements\n     * @param activeElement   The active element\n     * @param shouldGetNext   Choose to get next or previous element\n     * @param isCycleAllowed\n     * @return {Element|elem} The proper element\n     */\n    const getNextActiveElement = (list, activeElement, shouldGetNext, isCycleAllowed) => {\n        let index = list.indexOf(activeElement);\n\n        // if the element does not exist in the list return an element depending on the direction and if cycle is allowed\n        if (index === -1) {\n            return list[!shouldGetNext && isCycleAllowed ? list.length - 1 : 0]\n        }\n\n        const listLength = list.length;\n\n        index += shouldGetNext ? 1 : -1\n\n        if (isCycleAllowed) {\n            index = (index + listLength) % listLength\n        }\n\n        return list[Math.max(0, Math.min(index, listLength - 1))]\n    };\n\n    return {\n        getElement,\n        getUID,\n        getSelectorFromElement,\n        getElementFromSelector,\n        getTransitionDurationFromElement,\n        triggerTransitionEnd,\n        isElement,\n        typeCheckConfig,\n        isVisible,\n        isDisabled,\n        findShadowRoot,\n        noop,\n        getNextActiveElement,\n        reflow,\n        getjQuery,\n        onDOMContentLoaded,\n        isRTL,\n        defineJQueryPlugin,\n        execute,\n        executeAfterTransition\n    };\n});\n","jquery/bootstrap/dom/manipulator.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): dom/manipulator.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([], function() {\n    'use strict';\n\n    function normalizeData(val) {\n        if (val === 'true') {\n            return true\n        }\n\n        if (val === 'false') {\n            return false\n        }\n\n        if (val === Number(val).toString()) {\n            return Number(val)\n        }\n\n        if (val === '' || val === 'null') {\n            return null\n        }\n\n        return val\n    }\n\n    function normalizeDataKey(key) {\n        return key.replace(/[A-Z]/g, chr => `-${chr.toLowerCase()}`)\n    }\n\n    return {\n        setDataAttribute: function(element, key, value) {\n            element.setAttribute(`data-bs-${normalizeDataKey(key)}`, value)\n        },\n\n        removeDataAttribute: function(element, key) {\n            element.removeAttribute(`data-bs-${normalizeDataKey(key)}`)\n        },\n\n        getDataAttributes: function(element) {\n            if (!element) {\n                return {}\n            }\n\n            const attributes = {};\n\n            Object.keys(element.dataset)\n                .filter(key => key.startsWith('bs'))\n                .forEach(key => {\n                    let pureKey = key.replace(/^bs/, '');\n                    pureKey = pureKey.charAt(0).toLowerCase() + pureKey.slice(1, pureKey.length)\n                    attributes[pureKey] = normalizeData(element.dataset[key])\n                })\n\n            return attributes\n        },\n\n        getDataAttribute: function(element, key) {\n            return normalizeData(element.getAttribute(`data-bs-${normalizeDataKey(key)}`))\n        },\n\n        offset: function(element) {\n            const rect = element.getBoundingClientRect();\n\n            return {\n                top: rect.top + window.pageYOffset,\n                left: rect.left + window.pageXOffset\n            }\n        },\n\n        position: function(element) {\n            return {\n                top: element.offsetTop,\n                left: element.offsetLeft\n            }\n        }\n    }\n});\n","jquery/bootstrap/dom/event-handler.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): dom/event-handler.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([\n    \"../util/index\"\n], function(Util) {\n    'use strict';\n\n    const getjQuery = Util.getjQuery;\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const namespaceRegex = /[^.]*(?=\\..*)\\.|.*/;\n    const stripNameRegex = /\\..*/;\n    const stripUidRegex = /::\\d+$/;\n    const eventRegistry = {}; // Events storage\n    let uidEvent = 1;\n    const customEvents = {\n        mouseenter: 'mouseover',\n        mouseleave: 'mouseout'\n    };\n    const customEventsRegex = /^(mouseenter|mouseleave)/i;\n    const nativeEvents = new Set([\n        'click',\n        'dblclick',\n        'mouseup',\n        'mousedown',\n        'contextmenu',\n        'mousewheel',\n        'DOMMouseScroll',\n        'mouseover',\n        'mouseout',\n        'mousemove',\n        'selectstart',\n        'selectend',\n        'keydown',\n        'keypress',\n        'keyup',\n        'orientationchange',\n        'touchstart',\n        'touchmove',\n        'touchend',\n        'touchcancel',\n        'pointerdown',\n        'pointermove',\n        'pointerup',\n        'pointerleave',\n        'pointercancel',\n        'gesturestart',\n        'gesturechange',\n        'gestureend',\n        'focus',\n        'blur',\n        'change',\n        'reset',\n        'select',\n        'submit',\n        'focusin',\n        'focusout',\n        'load',\n        'unload',\n        'beforeunload',\n        'resize',\n        'move',\n        'DOMContentLoaded',\n        'readystatechange',\n        'error',\n        'abort',\n        'scroll'\n    ]);\n\n    /**\n     * ------------------------------------------------------------------------\n     * Private methods\n     * ------------------------------------------------------------------------\n     */\n\n    function getUidEvent(element, uid) {\n        return (uid && `${uid}::${uidEvent++}`) || element.uidEvent || uidEvent++\n    }\n\n    function getEvent(element) {\n        const uid = getUidEvent(element);\n\n        element.uidEvent = uid\n        eventRegistry[uid] = eventRegistry[uid] || {}\n\n        return eventRegistry[uid]\n    }\n\n    function bootstrapHandler(element, fn) {\n        return function handler(event) {\n            event.delegateTarget = element\n\n            if (handler.oneOff) {\n                EventHandler.off(element, event.type, fn)\n            }\n\n            return fn.apply(element, [event])\n        }\n    }\n\n    function bootstrapDelegationHandler(element, selector, fn) {\n        return function handler(event) {\n            const domElements = element.querySelectorAll(selector);\n\n            for (let {target} = event; target && target !== this; target = target.parentNode) {\n                for (let i = domElements.length; i--;) {\n                    if (domElements[i] === target) {\n                        event.delegateTarget = target\n\n                        if (handler.oneOff) {\n                            EventHandler.off(element, event.type, selector, fn)\n                        }\n\n                        return fn.apply(target, [event])\n                    }\n                }\n            }\n\n            // To please ESLint\n            return null\n        }\n    }\n\n    function findHandler(events, handler, delegationSelector = null) {\n        const uidEventList = Object.keys(events);\n\n        for (let i = 0, len = uidEventList.length; i < len; i++) {\n            const event = events[uidEventList[i]];\n\n            if (event.originalHandler === handler && event.delegationSelector === delegationSelector) {\n                return event\n            }\n        }\n\n        return null\n    }\n\n    function normalizeParams(originalTypeEvent, handler, delegationFn) {\n        const delegation = typeof handler === 'string';\n        const originalHandler = delegation ? delegationFn : handler;\n\n        let typeEvent = getTypeEvent(originalTypeEvent);\n        const isNative = nativeEvents.has(typeEvent);\n\n        if (!isNative) {\n            typeEvent = originalTypeEvent\n        }\n\n        return [delegation, originalHandler, typeEvent]\n    }\n\n    function addHandler(element, originalTypeEvent, handler, delegationFn, oneOff) {\n        if (typeof originalTypeEvent !== 'string' || !element) {\n            return\n        }\n\n        if (!handler) {\n            handler = delegationFn\n            delegationFn = null\n        }\n\n        // in case of mouseenter or mouseleave wrap the handler within a function that checks for its DOM position\n        // this prevents the handler from being dispatched the same way as mouseover or mouseout does\n        if (customEventsRegex.test(originalTypeEvent)) {\n            const wrapFn = fn => {\n                return function (event) {\n                    if (!event.relatedTarget || (event.relatedTarget !== event.delegateTarget && !event.delegateTarget.contains(event.relatedTarget))) {\n                        return fn.call(this, event)\n                    }\n                }\n            };\n\n            if (delegationFn) {\n                delegationFn = wrapFn(delegationFn)\n            } else {\n                handler = wrapFn(handler)\n            }\n        }\n\n        const [delegation, originalHandler, typeEvent] = normalizeParams(originalTypeEvent, handler, delegationFn);\n        const events = getEvent(element);\n        const handlers = events[typeEvent] || (events[typeEvent] = {});\n        const previousFn = findHandler(handlers, originalHandler, delegation ? handler : null);\n\n        if (previousFn) {\n            previousFn.oneOff = previousFn.oneOff && oneOff\n\n            return\n        }\n\n        const uid = getUidEvent(originalHandler, originalTypeEvent.replace(namespaceRegex, ''));\n        const fn = delegation ?\n            bootstrapDelegationHandler(element, handler, delegationFn) :\n            bootstrapHandler(element, handler);\n\n        fn.delegationSelector = delegation ? handler : null\n        fn.originalHandler = originalHandler\n        fn.oneOff = oneOff\n        fn.uidEvent = uid\n        handlers[uid] = fn\n\n        element.addEventListener(typeEvent, fn, delegation)\n    }\n\n    function removeHandler(element, events, typeEvent, handler, delegationSelector) {\n        const fn = findHandler(events[typeEvent], handler, delegationSelector);\n\n        if (!fn) {\n            return\n        }\n\n        element.removeEventListener(typeEvent, fn, Boolean(delegationSelector))\n        delete events[typeEvent][fn.uidEvent]\n    }\n\n    function removeNamespacedHandlers(element, events, typeEvent, namespace) {\n        const storeElementEvent = events[typeEvent] || {};\n\n        Object.keys(storeElementEvent).forEach(handlerKey => {\n            if (handlerKey.includes(namespace)) {\n                const event = storeElementEvent[handlerKey];\n\n                removeHandler(element, events, typeEvent, event.originalHandler, event.delegationSelector)\n            }\n        })\n    }\n\n    function getTypeEvent(event) {\n        // allow to get the native events from namespaced events ('click.bs.button' --> 'click')\n        event = event.replace(stripNameRegex, '')\n        return customEvents[event] || event\n    }\n\n    return {\n        on: function(element, event, handler, delegationFn) {\n            addHandler(element, event, handler, delegationFn, false)\n        },\n\n        one: function(element, event, handler, delegationFn) {\n            addHandler(element, event, handler, delegationFn, true)\n        },\n\n        off: function(element, originalTypeEvent, handler, delegationFn) {\n            if (typeof originalTypeEvent !== 'string' || !element) {\n                return\n            }\n\n            const [delegation, originalHandler, typeEvent] = normalizeParams(originalTypeEvent, handler, delegationFn);\n            const inNamespace = typeEvent !== originalTypeEvent;\n            const events = getEvent(element);\n            const isNamespace = originalTypeEvent.startsWith('.');\n\n            if (typeof originalHandler !== 'undefined') {\n                // Simplest case: handler is passed, remove that listener ONLY.\n                if (!events || !events[typeEvent]) {\n                    return\n                }\n\n                removeHandler(element, events, typeEvent, originalHandler, delegation ? handler : null)\n                return\n            }\n\n            if (isNamespace) {\n                Object.keys(events).forEach(elementEvent => {\n                    removeNamespacedHandlers(element, events, elementEvent, originalTypeEvent.slice(1))\n                })\n            }\n\n            const storeElementEvent = events[typeEvent] || {};\n            Object.keys(storeElementEvent).forEach(keyHandlers => {\n                const handlerKey = keyHandlers.replace(stripUidRegex, '');\n\n                if (!inNamespace || originalTypeEvent.includes(handlerKey)) {\n                    const event = storeElementEvent[keyHandlers];\n\n                    removeHandler(element, events, typeEvent, event.originalHandler, event.delegationSelector)\n                }\n            })\n        },\n\n        trigger: function(element, event, args) {\n            if (typeof event !== 'string' || !element) {\n                return null\n            }\n\n            const $ = getjQuery();\n            const typeEvent = getTypeEvent(event);\n            const inNamespace = event !== typeEvent;\n            const isNative = nativeEvents.has(typeEvent);\n\n            let jQueryEvent;\n            let bubbles = true;\n            let nativeDispatch = true;\n            let defaultPrevented = false;\n            let evt = null;\n\n            if (inNamespace && $) {\n                jQueryEvent = $.Event(event, args)\n\n                $(element).trigger(jQueryEvent)\n                bubbles = !jQueryEvent.isPropagationStopped()\n                nativeDispatch = !jQueryEvent.isImmediatePropagationStopped()\n                defaultPrevented = jQueryEvent.isDefaultPrevented()\n            }\n\n            if (isNative) {\n                evt = document.createEvent('HTMLEvents')\n                evt.initEvent(typeEvent, bubbles, true)\n            } else {\n                evt = new CustomEvent(event, {\n                    bubbles,\n                    cancelable: true\n                })\n            }\n\n            // merge custom information in our event\n            if (typeof args !== 'undefined') {\n                Object.keys(args).forEach(key => {\n                    Object.defineProperty(evt, key, {\n                        get() {\n                            return args[key]\n                        }\n                    })\n                })\n            }\n\n            if (defaultPrevented) {\n                evt.preventDefault()\n            }\n\n            if (nativeDispatch) {\n                element.dispatchEvent(evt)\n            }\n\n            if (evt.defaultPrevented && typeof jQueryEvent !== 'undefined') {\n                jQueryEvent.preventDefault()\n            }\n\n            return evt\n        }\n    }\n});\n","jquery/bootstrap/dom/selector-engine.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): dom/selector-engine.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([\n    \"../util/index\"\n], function(Util) {\n    'use strict';\n\n    const isDisabled = Util.isDisabled;\n    const isVisible = Util.isVisible;\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const NODE_TEXT = 3;\n\n    return {\n        find: function(selector, element = document.documentElement) {\n            return [].concat(...Element.prototype.querySelectorAll.call(element, selector))\n        },\n\n        findOne: function(selector, element = document.documentElement) {\n            return Element.prototype.querySelector.call(element, selector)\n        },\n\n        children: function(element, selector) {\n            return [].concat(...element.children)\n                .filter(child => child.matches(selector))\n        },\n\n        parents: function(element, selector) {\n            const parents = [];\n\n            let ancestor = element.parentNode;\n\n            while (ancestor && ancestor.nodeType === Node.ELEMENT_NODE && ancestor.nodeType !== NODE_TEXT) {\n                if (ancestor.matches(selector)) {\n                    parents.push(ancestor)\n                }\n\n                ancestor = ancestor.parentNode\n            }\n\n            return parents\n        },\n\n        prev: function(element, selector) {\n            let previous = element.previousElementSibling;\n\n            while (previous) {\n                if (previous.matches(selector)) {\n                    return [previous]\n                }\n\n                previous = previous.previousElementSibling\n            }\n\n            return []\n        },\n\n        next: function(element, selector) {\n            let next = element.nextElementSibling;\n\n            while (next) {\n                if (next.matches(selector)) {\n                    return [next]\n                }\n\n                next = next.nextElementSibling\n            }\n\n            return []\n        },\n\n        focusableChildren: function(element) {\n            const focusables = [\n                'a',\n                'button',\n                'input',\n                'textarea',\n                'select',\n                'details',\n                '[tabindex]',\n                '[contenteditable=\"true\"]'\n            ].map(selector => `${selector}:not([tabindex^=\"-\"])`).join(', ');\n\n            return this.find(focusables, element).filter(el => !isDisabled(el) && isVisible(el))\n        }\n    }\n});\n","jquery/bootstrap/dom/data.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): dom/data.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([], function() {\n    'use strict';\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const elementMap = new Map();\n\n    return {\n        set: function (element, key, instance) {\n            if (!elementMap.has(element)) {\n                elementMap.set(element, new Map())\n            }\n\n            const instanceMap = elementMap.get(element);\n\n            // make it clear we only want one instance per element\n            // can be removed later when multiple key/instances are fine to be used\n            if (!instanceMap.has(key) && instanceMap.size !== 0) {\n                // eslint-disable-next-line no-console\n                console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(instanceMap.keys())[0]}.`)\n                return\n            }\n\n            instanceMap.set(key, instance)\n        },\n\n        get: function (element, key) {\n            if (elementMap.has(element)) {\n                return elementMap.get(element).get(key) || null\n            }\n\n            return null\n        },\n\n        remove: function (element, key) {\n            if (!elementMap.has(element)) {\n                return\n            }\n\n            const instanceMap = elementMap.get(element);\n\n            instanceMap.delete(key)\n\n            // free up element references if there are no instances left for an element\n            if (instanceMap.size === 0) {\n                elementMap.delete(element)\n            }\n        }\n    }\n});\n","jquery/ui-modules/disable-selection.js":"/*!\n * jQuery UI Disable Selection 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: disableSelection\n//>>group: Core\n//>>description: Disable selection of text content within the set of matched elements.\n//>>docs: http://api.jqueryui.com/disableSelection/\n\n// This file is deprecated\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.fn.extend( {\n        disableSelection: ( function() {\n            var eventType = \"onselectstart\" in document.createElement( \"div\" ) ?\n                \"selectstart\" :\n                \"mousedown\";\n\n            return function() {\n                return this.on( eventType + \".ui-disableSelection\", function( event ) {\n                    event.preventDefault();\n                } );\n            };\n        } )(),\n\n        enableSelection: function() {\n            return this.off( \".ui-disableSelection\" );\n        }\n    } );\n\n} );\n","jquery/ui-modules/jquery-var-for-color.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\t\"use strict\";\n\n// Create a local jQuery because jQuery Color relies on it and the\n// global may not exist with AMD and a custom build (#10199).\n// This module is a noop if used as a regular AMD module.\n// eslint-disable-next-line no-unused-vars\nvar jQuery = $;\n\n} );\n","jquery/ui-modules/core.js":"// This file is deprecated in 1.12.0 to be removed in 1.14\n( function() {\n\"use strict\";\n\ndefine( [\n\t\"jquery\",\n\t\"./data\",\n\t\"./disable-selection\",\n\t\"./focusable\",\n\t\"./form\",\n\t\"./ie\",\n\t\"./keycode\",\n\t\"./labels\",\n\t\"./jquery-patch\",\n\t\"./plugin\",\n\t\"./safe-active-element\",\n\t\"./safe-blur\",\n\t\"./scroll-parent\",\n\t\"./tabbable\",\n\t\"./unique-id\",\n\t\"./version\"\n] );\n} )();\n","jquery/ui-modules/ie.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// This file is deprecated\nreturn $.ui.ie = !!/msie [\\w.]+/.exec( navigator.userAgent.toLowerCase() );\n} );\n","jquery/ui-modules/keycode.js":"/*!\n * jQuery UI Keycode 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Keycode\n//>>group: Core\n//>>description: Provide keycodes as keynames\n//>>docs: http://api.jqueryui.com/jQuery.ui.keyCode/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.ui.keyCode = {\n        BACKSPACE: 8,\n        COMMA: 188,\n        DELETE: 46,\n        DOWN: 40,\n        END: 35,\n        ENTER: 13,\n        ESCAPE: 27,\n        HOME: 36,\n        LEFT: 37,\n        PAGE_DOWN: 34,\n        PAGE_UP: 33,\n        PERIOD: 190,\n        RIGHT: 39,\n        SPACE: 32,\n        TAB: 9,\n        UP: 38\n    };\n\n} );\n","jquery/ui-modules/jquery-patch.js":"/*!\n * jQuery UI Support for jQuery core 1.8.x and newer 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n */\n\n//>>label: jQuery 1.8+ Support\n//>>group: Core\n//>>description: Support version 1.8.x and newer of jQuery core\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n// Support: jQuery 1.9.x or older\n// $.expr[ \":\" ] is deprecated.\n    if ( !$.expr.pseudos ) {\n        $.expr.pseudos = $.expr[ \":\" ];\n    }\n\n// Support: jQuery 1.11.x or older\n// $.unique has been renamed to $.uniqueSort\n    if ( !$.uniqueSort ) {\n        $.uniqueSort = $.unique;\n    }\n\n// Support: jQuery 2.2.x or older.\n// This method has been defined in jQuery 3.0.0.\n// Code from https://github.com/jquery/jquery/blob/e539bac79e666bba95bba86d690b4e609dca2286/src/selector/escapeSelector.js\n    if ( !$.escapeSelector ) {\n\n        // CSS string/identifier serialization\n        // https://drafts.csswg.org/cssom/#common-serializing-idioms\n        var rcssescape = /([\\0-\\x1f\\x7f]|^-?\\d)|^-$|[^\\x80-\\uFFFF\\w-]/g;\n\n        var fcssescape = function( ch, asCodePoint ) {\n            if ( asCodePoint ) {\n\n                // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER\n                if ( ch === \"\\0\" ) {\n                    return \"\\uFFFD\";\n                }\n\n                // Control characters and (dependent upon position) numbers get escaped as code points\n                return ch.slice( 0, -1 ) + \"\\\\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + \" \";\n            }\n\n            // Other potentially-special ASCII characters get backslash-escaped\n            return \"\\\\\" + ch;\n        };\n\n        $.escapeSelector = function( sel ) {\n            return ( sel + \"\" ).replace( rcssescape, fcssescape );\n        };\n    }\n\n// Support: jQuery 3.4.x or older\n// These methods have been defined in jQuery 3.5.0.\n    if ( !$.fn.even || !$.fn.odd ) {\n        $.fn.extend( {\n            even: function() {\n                return this.filter( function( i ) {\n                    return i % 2 === 0;\n                } );\n            },\n            odd: function() {\n                return this.filter( function( i ) {\n                    return i % 2 === 1;\n                } );\n            }\n        } );\n    }\n\n} );\n","jquery/ui-modules/labels.js":"/*!\n * jQuery UI Labels 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: labels\n//>>group: Core\n//>>description: Find all the labels associated with a given input\n//>>docs: http://api.jqueryui.com/labels/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.fn.labels = function() {\n        var ancestor, selector, id, labels, ancestors;\n\n        if ( !this.length ) {\n            return this.pushStack( [] );\n        }\n\n        // Check control.labels first\n        if ( this[ 0 ].labels && this[ 0 ].labels.length ) {\n            return this.pushStack( this[ 0 ].labels );\n        }\n\n        // Support: IE <= 11, FF <= 37, Android <= 2.3 only\n        // Above browsers do not support control.labels. Everything below is to support them\n        // as well as document fragments. control.labels does not work on document fragments\n        labels = this.eq( 0 ).parents( \"label\" );\n\n        // Look for the label based on the id\n        id = this.attr( \"id\" );\n        if ( id ) {\n\n            // We don't search against the document in case the element\n            // is disconnected from the DOM\n            ancestor = this.eq( 0 ).parents().last();\n\n            // Get a full set of top level ancestors\n            ancestors = ancestor.add( ancestor.length ? ancestor.siblings() : this.siblings() );\n\n            // Create a selector for the label based on the id\n            selector = \"label[for='\" + $.escapeSelector( id ) + \"']\";\n\n            labels = labels.add( ancestors.find( selector ).addBack( selector ) );\n\n        }\n\n        // Return whatever we have found for labels\n        return this.pushStack( labels );\n    };\n\n} );\n","jquery/ui-modules/form-reset-mixin.js":"/*!\n * jQuery UI Form Reset Mixin 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Form Reset Mixin\n//>>group: Core\n//>>description: Refresh input widgets when their form is reset\n//>>docs: http://api.jqueryui.com/form-reset-mixin/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./form\",\n            \"./version\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.ui.formResetMixin = {\n        _formResetHandler: function() {\n            var form = $( this );\n\n            // Wait for the form reset to actually happen before refreshing\n            setTimeout( function() {\n                var instances = form.data( \"ui-form-reset-instances\" );\n                $.each( instances, function() {\n                    this.refresh();\n                } );\n            } );\n        },\n\n        _bindFormResetHandler: function() {\n            this.form = this.element._form();\n            if ( !this.form.length ) {\n                return;\n            }\n\n            var instances = this.form.data( \"ui-form-reset-instances\" ) || [];\n            if ( !instances.length ) {\n\n                // We don't use _on() here because we use a single event handler per form\n                this.form.on( \"reset.ui-form-reset\", this._formResetHandler );\n            }\n            instances.push( this );\n            this.form.data( \"ui-form-reset-instances\", instances );\n        },\n\n        _unbindFormResetHandler: function() {\n            if ( !this.form.length ) {\n                return;\n            }\n\n            var instances = this.form.data( \"ui-form-reset-instances\" );\n            instances.splice( $.inArray( this, instances ), 1 );\n            if ( instances.length ) {\n                this.form.data( \"ui-form-reset-instances\", instances );\n            } else {\n                this.form\n                    .removeData( \"ui-form-reset-instances\" )\n                    .off( \"reset.ui-form-reset\" );\n            }\n        }\n    };\n\n} );\n","jquery/ui-modules/unique-id.js":"/*!\n * jQuery UI Unique ID 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: uniqueId\n//>>group: Core\n//>>description: Functions to generate and remove uniqueId's\n//>>docs: http://api.jqueryui.com/uniqueId/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.fn.extend( {\n        uniqueId: ( function() {\n            var uuid = 0;\n\n            return function() {\n                return this.each( function() {\n                    if ( !this.id ) {\n                        this.id = \"ui-id-\" + ( ++uuid );\n                    }\n                } );\n            };\n        } )(),\n\n        removeUniqueId: function() {\n            return this.each( function() {\n                if ( /^ui-id-\\d+$/.test( this.id ) ) {\n                    $( this ).removeAttr( \"id\" );\n                }\n            } );\n        }\n    } );\n\n} );\n","jquery/ui-modules/scroll-parent.js":"/*!\n * jQuery UI Scroll Parent 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: scrollParent\n//>>group: Core\n//>>description: Get the closest ancestor element that is scrollable.\n//>>docs: http://api.jqueryui.com/scrollParent/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.fn.scrollParent = function( includeHidden ) {\n        var position = this.css( \"position\" ),\n            excludeStaticParent = position === \"absolute\",\n            overflowRegex = includeHidden ? /(auto|scroll|hidden)/ : /(auto|scroll)/,\n            scrollParent = this.parents().filter( function() {\n                var parent = $( this );\n                if ( excludeStaticParent && parent.css( \"position\" ) === \"static\" ) {\n                    return false;\n                }\n                return overflowRegex.test( parent.css( \"overflow\" ) + parent.css( \"overflow-y\" ) +\n                    parent.css( \"overflow-x\" ) );\n            } ).eq( 0 );\n\n        return position === \"fixed\" || !scrollParent.length ?\n            $( this[ 0 ].ownerDocument || document ) :\n            scrollParent;\n    };\n\n} );\n","jquery/ui-modules/tabbable.js":"/*!\n * jQuery UI Tabbable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: :tabbable Selector\n//>>group: Core\n//>>description: Selects elements which can be tabbed to.\n//>>docs: http://api.jqueryui.com/tabbable-selector/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\", \"./focusable\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.extend( $.expr.pseudos, {\n        tabbable: function( element ) {\n            var tabIndex = $.attr( element, \"tabindex\" ),\n                hasTabindex = tabIndex != null;\n            return ( !hasTabindex || tabIndex >= 0 ) && $.ui.focusable( element, hasTabindex );\n        }\n    } );\n\n} );\n","jquery/ui-modules/widget.js":"/*!\n * jQuery UI Widget 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Widget\n//>>group: Core\n//>>description: Provides a factory for creating stateful widgets with a common API.\n//>>docs: http://api.jqueryui.com/jQuery.widget/\n//>>demos: http://jqueryui.com/widget/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var widgetUuid = 0;\n    var widgetHasOwnProperty = Array.prototype.hasOwnProperty;\n    var widgetSlice = Array.prototype.slice;\n\n    $.cleanData = ( function( orig ) {\n        return function( elems ) {\n            var events, elem, i;\n            for ( i = 0; ( elem = elems[ i ] ) != null; i++ ) {\n\n                // Only trigger remove when necessary to save time\n                events = $._data( elem, \"events\" );\n                if ( events && events.remove ) {\n                    $( elem ).triggerHandler( \"remove\" );\n                }\n            }\n            orig( elems );\n        };\n    } )( $.cleanData );\n\n    $.widget = function( name, base, prototype ) {\n        var existingConstructor, constructor, basePrototype;\n\n        // ProxiedPrototype allows the provided prototype to remain unmodified\n        // so that it can be used as a mixin for multiple widgets (#8876)\n        var proxiedPrototype = {};\n\n        var namespace = name.split( \".\" )[ 0 ];\n        name = name.split( \".\" )[ 1 ];\n        var fullName = namespace + \"-\" + name;\n\n        if ( !prototype ) {\n            prototype = base;\n            base = $.Widget;\n        }\n\n        if ( Array.isArray( prototype ) ) {\n            prototype = $.extend.apply( null, [ {} ].concat( prototype ) );\n        }\n\n        // Create selector for plugin\n        $.expr.pseudos[ fullName.toLowerCase() ] = function( elem ) {\n            return !!$.data( elem, fullName );\n        };\n\n        $[ namespace ] = $[ namespace ] || {};\n        existingConstructor = $[ namespace ][ name ];\n        constructor = $[ namespace ][ name ] = function( options, element ) {\n\n            // Allow instantiation without \"new\" keyword\n            if ( !this || !this._createWidget ) {\n                return new constructor( options, element );\n            }\n\n            // Allow instantiation without initializing for simple inheritance\n            // must use \"new\" keyword (the code above always passes args)\n            if ( arguments.length ) {\n                this._createWidget( options, element );\n            }\n        };\n\n        // Extend with the existing constructor to carry over any static properties\n        $.extend( constructor, existingConstructor, {\n            version: prototype.version,\n\n            // Copy the object used to create the prototype in case we need to\n            // redefine the widget later\n            _proto: $.extend( {}, prototype ),\n\n            // Track widgets that inherit from this widget in case this widget is\n            // redefined after a widget inherits from it\n            _childConstructors: []\n        } );\n\n        basePrototype = new base();\n\n        // We need to make the options hash a property directly on the new instance\n        // otherwise we'll modify the options hash on the prototype that we're\n        // inheriting from\n        basePrototype.options = $.widget.extend( {}, basePrototype.options );\n        $.each( prototype, function( prop, value ) {\n            if ( typeof value !== \"function\" ) {\n                proxiedPrototype[ prop ] = value;\n                return;\n            }\n            proxiedPrototype[ prop ] = ( function() {\n                function _super() {\n                    return base.prototype[ prop ].apply( this, arguments );\n                }\n\n                function _superApply( args ) {\n                    return base.prototype[ prop ].apply( this, args );\n                }\n\n                return function() {\n                    var __super = this._super;\n                    var __superApply = this._superApply;\n                    var returnValue;\n\n                    this._super = _super;\n                    this._superApply = _superApply;\n\n                    returnValue = value.apply( this, arguments );\n\n                    this._super = __super;\n                    this._superApply = __superApply;\n\n                    return returnValue;\n                };\n            } )();\n        } );\n        constructor.prototype = $.widget.extend( basePrototype, {\n\n            // TODO: remove support for widgetEventPrefix\n            // always use the name + a colon as the prefix, e.g., draggable:start\n            // don't prefix for widgets that aren't DOM-based\n            widgetEventPrefix: existingConstructor ? ( basePrototype.widgetEventPrefix || name ) : name\n        }, proxiedPrototype, {\n            constructor: constructor,\n            namespace: namespace,\n            widgetName: name,\n            widgetFullName: fullName\n        } );\n\n        // If this widget is being redefined then we need to find all widgets that\n        // are inheriting from it and redefine all of them so that they inherit from\n        // the new version of this widget. We're essentially trying to replace one\n        // level in the prototype chain.\n        if ( existingConstructor ) {\n            $.each( existingConstructor._childConstructors, function( i, child ) {\n                var childPrototype = child.prototype;\n\n                // Redefine the child widget using the same prototype that was\n                // originally used, but inherit from the new version of the base\n                $.widget( childPrototype.namespace + \".\" + childPrototype.widgetName, constructor,\n                    child._proto );\n            } );\n\n            // Remove the list of existing child constructors from the old constructor\n            // so the old child constructors can be garbage collected\n            delete existingConstructor._childConstructors;\n        } else {\n            base._childConstructors.push( constructor );\n        }\n\n        $.widget.bridge( name, constructor );\n\n        return constructor;\n    };\n\n    $.widget.extend = function( target ) {\n        var input = widgetSlice.call( arguments, 1 );\n        var inputIndex = 0;\n        var inputLength = input.length;\n        var key;\n        var value;\n\n        for ( ; inputIndex < inputLength; inputIndex++ ) {\n            for ( key in input[ inputIndex ] ) {\n                value = input[ inputIndex ][ key ];\n                if ( widgetHasOwnProperty.call( input[ inputIndex ], key ) && value !== undefined ) {\n\n                    // Clone objects\n                    if ( $.isPlainObject( value ) ) {\n                        target[ key ] = $.isPlainObject( target[ key ] ) ?\n                            $.widget.extend( {}, target[ key ], value ) :\n\n                            // Don't extend strings, arrays, etc. with objects\n                            $.widget.extend( {}, value );\n\n                        // Copy everything else by reference\n                    } else {\n                        target[ key ] = value;\n                    }\n                }\n            }\n        }\n        return target;\n    };\n\n    $.widget.bridge = function( name, object ) {\n        var fullName = object.prototype.widgetFullName || name;\n        $.fn[ name ] = function( options ) {\n            var isMethodCall = typeof options === \"string\";\n            var args = widgetSlice.call( arguments, 1 );\n            var returnValue = this;\n\n            if ( isMethodCall ) {\n\n                // If this is an empty collection, we need to have the instance method\n                // return undefined instead of the jQuery instance\n                if ( !this.length && options === \"instance\" ) {\n                    returnValue = undefined;\n                } else {\n                    this.each( function() {\n                        var methodValue;\n                        var instance = $.data( this, fullName );\n\n                        if ( options === \"instance\" ) {\n                            returnValue = instance;\n                            return false;\n                        }\n\n                        if ( !instance ) {\n                            return $.error( \"cannot call methods on \" + name +\n                                \" prior to initialization; \" +\n                                \"attempted to call method '\" + options + \"'\" );\n                        }\n\n                        if ( typeof instance[ options ] !== \"function\" ||\n                            options.charAt( 0 ) === \"_\" ) {\n                            return $.error( \"no such method '\" + options + \"' for \" + name +\n                                \" widget instance\" );\n                        }\n\n                        methodValue = instance[ options ].apply( instance, args );\n\n                        if ( methodValue !== instance && methodValue !== undefined ) {\n                            returnValue = methodValue && methodValue.jquery ?\n                                returnValue.pushStack( methodValue.get() ) :\n                                methodValue;\n                            return false;\n                        }\n                    } );\n                }\n            } else {\n\n                // Allow multiple hashes to be passed on init\n                if ( args.length ) {\n                    options = $.widget.extend.apply( null, [ options ].concat( args ) );\n                }\n\n                this.each( function() {\n                    var instance = $.data( this, fullName );\n                    if ( instance ) {\n                        instance.option( options || {} );\n                        if ( instance._init ) {\n                            instance._init();\n                        }\n                    } else {\n                        $.data( this, fullName, new object( options, this ) );\n                    }\n                } );\n            }\n\n            return returnValue;\n        };\n    };\n\n    $.Widget = function( /* options, element */ ) {};\n    $.Widget._childConstructors = [];\n\n    $.Widget.prototype = {\n        widgetName: \"widget\",\n        widgetEventPrefix: \"\",\n        defaultElement: \"<div>\",\n\n        options: {\n            classes: {},\n            disabled: false,\n\n            // Callbacks\n            create: null\n        },\n\n        _createWidget: function( options, element ) {\n            element = $( element || this.defaultElement || this )[ 0 ];\n            this.element = $( element );\n            this.uuid = widgetUuid++;\n            this.eventNamespace = \".\" + this.widgetName + this.uuid;\n\n            this.bindings = $();\n            this.hoverable = $();\n            this.focusable = $();\n            this.classesElementLookup = {};\n\n            if ( element !== this ) {\n                $.data( element, this.widgetFullName, this );\n                this._on( true, this.element, {\n                    remove: function( event ) {\n                        if ( event.target === element ) {\n                            this.destroy();\n                        }\n                    }\n                } );\n                this.document = $( element.style ?\n\n                    // Element within the document\n                    element.ownerDocument :\n\n                    // Element is window or document\n                    element.document || element );\n                this.window = $( this.document[ 0 ].defaultView || this.document[ 0 ].parentWindow );\n            }\n\n            this.options = $.widget.extend( {},\n                this.options,\n                this._getCreateOptions(),\n                options );\n\n            this._create();\n\n            if ( this.options.disabled ) {\n                this._setOptionDisabled( this.options.disabled );\n            }\n\n            this._trigger( \"create\", null, this._getCreateEventData() );\n            this._init();\n        },\n\n        _getCreateOptions: function() {\n            return {};\n        },\n\n        _getCreateEventData: $.noop,\n\n        _create: $.noop,\n\n        _init: $.noop,\n\n        destroy: function() {\n            var that = this;\n\n            this._destroy();\n            $.each( this.classesElementLookup, function( key, value ) {\n                that._removeClass( value, key );\n            } );\n\n            // We can probably remove the unbind calls in 2.0\n            // all event bindings should go through this._on()\n            this.element\n                .off( this.eventNamespace )\n                .removeData( this.widgetFullName );\n            this.widget()\n                .off( this.eventNamespace )\n                .removeAttr( \"aria-disabled\" );\n\n            // Clean up events and states\n            this.bindings.off( this.eventNamespace );\n        },\n\n        _destroy: $.noop,\n\n        widget: function() {\n            return this.element;\n        },\n\n        option: function( key, value ) {\n            var options = key;\n            var parts;\n            var curOption;\n            var i;\n\n            if ( arguments.length === 0 ) {\n\n                // Don't return a reference to the internal hash\n                return $.widget.extend( {}, this.options );\n            }\n\n            if ( typeof key === \"string\" ) {\n\n                // Handle nested keys, e.g., \"foo.bar\" => { foo: { bar: ___ } }\n                options = {};\n                parts = key.split( \".\" );\n                key = parts.shift();\n                if ( parts.length ) {\n                    curOption = options[ key ] = $.widget.extend( {}, this.options[ key ] );\n                    for ( i = 0; i < parts.length - 1; i++ ) {\n                        curOption[ parts[ i ] ] = curOption[ parts[ i ] ] || {};\n                        curOption = curOption[ parts[ i ] ];\n                    }\n                    key = parts.pop();\n                    if ( arguments.length === 1 ) {\n                        return curOption[ key ] === undefined ? null : curOption[ key ];\n                    }\n                    curOption[ key ] = value;\n                } else {\n                    if ( arguments.length === 1 ) {\n                        return this.options[ key ] === undefined ? null : this.options[ key ];\n                    }\n                    options[ key ] = value;\n                }\n            }\n\n            this._setOptions( options );\n\n            return this;\n        },\n\n        _setOptions: function( options ) {\n            var key;\n\n            for ( key in options ) {\n                this._setOption( key, options[ key ] );\n            }\n\n            return this;\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"classes\" ) {\n                this._setOptionClasses( value );\n            }\n\n            this.options[ key ] = value;\n\n            if ( key === \"disabled\" ) {\n                this._setOptionDisabled( value );\n            }\n\n            return this;\n        },\n\n        _setOptionClasses: function( value ) {\n            var classKey, elements, currentElements;\n\n            for ( classKey in value ) {\n                currentElements = this.classesElementLookup[ classKey ];\n                if ( value[ classKey ] === this.options.classes[ classKey ] ||\n                    !currentElements ||\n                    !currentElements.length ) {\n                    continue;\n                }\n\n                // We are doing this to create a new jQuery object because the _removeClass() call\n                // on the next line is going to destroy the reference to the current elements being\n                // tracked. We need to save a copy of this collection so that we can add the new classes\n                // below.\n                elements = $( currentElements.get() );\n                this._removeClass( currentElements, classKey );\n\n                // We don't use _addClass() here, because that uses this.options.classes\n                // for generating the string of classes. We want to use the value passed in from\n                // _setOption(), this is the new value of the classes option which was passed to\n                // _setOption(). We pass this value directly to _classes().\n                elements.addClass( this._classes( {\n                    element: elements,\n                    keys: classKey,\n                    classes: value,\n                    add: true\n                } ) );\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._toggleClass( this.widget(), this.widgetFullName + \"-disabled\", null, !!value );\n\n            // If the widget is becoming disabled, then nothing is interactive\n            if ( value ) {\n                this._removeClass( this.hoverable, null, \"ui-state-hover\" );\n                this._removeClass( this.focusable, null, \"ui-state-focus\" );\n            }\n        },\n\n        enable: function() {\n            return this._setOptions( { disabled: false } );\n        },\n\n        disable: function() {\n            return this._setOptions( { disabled: true } );\n        },\n\n        _classes: function( options ) {\n            var full = [];\n            var that = this;\n\n            options = $.extend( {\n                element: this.element,\n                classes: this.options.classes || {}\n            }, options );\n\n            function bindRemoveEvent() {\n                var nodesToBind = [];\n\n                options.element.each( function( _, element ) {\n                    var isTracked = $.map( that.classesElementLookup, function( elements ) {\n                        return elements;\n                    } )\n                        .some( function( elements ) {\n                            return elements.is( element );\n                        } );\n\n                    if ( !isTracked ) {\n                        nodesToBind.push( element );\n                    }\n                } );\n\n                that._on( $( nodesToBind ), {\n                    remove: \"_untrackClassesElement\"\n                } );\n            }\n\n            function processClassString( classes, checkOption ) {\n                var current, i;\n                for ( i = 0; i < classes.length; i++ ) {\n                    current = that.classesElementLookup[ classes[ i ] ] || $();\n                    if ( options.add ) {\n                        bindRemoveEvent();\n                        current = $( $.uniqueSort( current.get().concat( options.element.get() ) ) );\n                    } else {\n                        current = $( current.not( options.element ).get() );\n                    }\n                    that.classesElementLookup[ classes[ i ] ] = current;\n                    full.push( classes[ i ] );\n                    if ( checkOption && options.classes[ classes[ i ] ] ) {\n                        full.push( options.classes[ classes[ i ] ] );\n                    }\n                }\n            }\n\n            if ( options.keys ) {\n                processClassString( options.keys.match( /\\S+/g ) || [], true );\n            }\n            if ( options.extra ) {\n                processClassString( options.extra.match( /\\S+/g ) || [] );\n            }\n\n            return full.join( \" \" );\n        },\n\n        _untrackClassesElement: function( event ) {\n            var that = this;\n            $.each( that.classesElementLookup, function( key, value ) {\n                if ( $.inArray( event.target, value ) !== -1 ) {\n                    that.classesElementLookup[ key ] = $( value.not( event.target ).get() );\n                }\n            } );\n\n            this._off( $( event.target ) );\n        },\n\n        _removeClass: function( element, keys, extra ) {\n            return this._toggleClass( element, keys, extra, false );\n        },\n\n        _addClass: function( element, keys, extra ) {\n            return this._toggleClass( element, keys, extra, true );\n        },\n\n        _toggleClass: function( element, keys, extra, add ) {\n            add = ( typeof add === \"boolean\" ) ? add : extra;\n            var shift = ( typeof element === \"string\" || element === null ),\n                options = {\n                    extra: shift ? keys : extra,\n                    keys: shift ? element : keys,\n                    element: shift ? this.element : element,\n                    add: add\n                };\n            options.element.toggleClass( this._classes( options ), add );\n            return this;\n        },\n\n        _on: function( suppressDisabledCheck, element, handlers ) {\n            var delegateElement;\n            var instance = this;\n\n            // No suppressDisabledCheck flag, shuffle arguments\n            if ( typeof suppressDisabledCheck !== \"boolean\" ) {\n                handlers = element;\n                element = suppressDisabledCheck;\n                suppressDisabledCheck = false;\n            }\n\n            // No element argument, shuffle and use this.element\n            if ( !handlers ) {\n                handlers = element;\n                element = this.element;\n                delegateElement = this.widget();\n            } else {\n                element = delegateElement = $( element );\n                this.bindings = this.bindings.add( element );\n            }\n\n            $.each( handlers, function( event, handler ) {\n                function handlerProxy() {\n\n                    // Allow widgets to customize the disabled handling\n                    // - disabled as an array instead of boolean\n                    // - disabled class as method for disabling individual parts\n                    if ( !suppressDisabledCheck &&\n                        ( instance.options.disabled === true ||\n                            $( this ).hasClass( \"ui-state-disabled\" ) ) ) {\n                        return;\n                    }\n                    return ( typeof handler === \"string\" ? instance[ handler ] : handler )\n                        .apply( instance, arguments );\n                }\n\n                // Copy the guid so direct unbinding works\n                if ( typeof handler !== \"string\" ) {\n                    handlerProxy.guid = handler.guid =\n                        handler.guid || handlerProxy.guid || $.guid++;\n                }\n\n                var match = event.match( /^([\\w:-]*)\\s*(.*)$/ );\n                var eventName = match[ 1 ] + instance.eventNamespace;\n                var selector = match[ 2 ];\n\n                if ( selector ) {\n                    delegateElement.on( eventName, selector, handlerProxy );\n                } else {\n                    element.on( eventName, handlerProxy );\n                }\n            } );\n        },\n\n        _off: function( element, eventName ) {\n            eventName = ( eventName || \"\" ).split( \" \" ).join( this.eventNamespace + \" \" ) +\n                this.eventNamespace;\n            element.off( eventName );\n\n            // Clear the stack to avoid memory leaks (#10056)\n            this.bindings = $( this.bindings.not( element ).get() );\n            this.focusable = $( this.focusable.not( element ).get() );\n            this.hoverable = $( this.hoverable.not( element ).get() );\n        },\n\n        _delay: function( handler, delay ) {\n            function handlerProxy() {\n                return ( typeof handler === \"string\" ? instance[ handler ] : handler )\n                    .apply( instance, arguments );\n            }\n            var instance = this;\n            return setTimeout( handlerProxy, delay || 0 );\n        },\n\n        _hoverable: function( element ) {\n            this.hoverable = this.hoverable.add( element );\n            this._on( element, {\n                mouseenter: function( event ) {\n                    this._addClass( $( event.currentTarget ), null, \"ui-state-hover\" );\n                },\n                mouseleave: function( event ) {\n                    this._removeClass( $( event.currentTarget ), null, \"ui-state-hover\" );\n                }\n            } );\n        },\n\n        _focusable: function( element ) {\n            this.focusable = this.focusable.add( element );\n            this._on( element, {\n                focusin: function( event ) {\n                    this._addClass( $( event.currentTarget ), null, \"ui-state-focus\" );\n                },\n                focusout: function( event ) {\n                    this._removeClass( $( event.currentTarget ), null, \"ui-state-focus\" );\n                }\n            } );\n        },\n\n        _trigger: function( type, event, data ) {\n            var prop, orig;\n            var callback = this.options[ type ];\n\n            data = data || {};\n            event = $.Event( event );\n            event.type = ( type === this.widgetEventPrefix ?\n                type :\n                this.widgetEventPrefix + type ).toLowerCase();\n\n            // The original event may come from any element\n            // so we need to reset the target on the new event\n            event.target = this.element[ 0 ];\n\n            // Copy original event properties over to the new event\n            orig = event.originalEvent;\n            if ( orig ) {\n                for ( prop in orig ) {\n                    if ( !( prop in event ) ) {\n                        event[ prop ] = orig[ prop ];\n                    }\n                }\n            }\n\n            this.element.trigger( event, data );\n            return !( typeof callback === \"function\" &&\n                callback.apply( this.element[ 0 ], [ event ].concat( data ) ) === false ||\n                event.isDefaultPrevented() );\n        }\n    };\n\n    $.each( { show: \"fadeIn\", hide: \"fadeOut\" }, function( method, defaultEffect ) {\n        $.Widget.prototype[ \"_\" + method ] = function( element, options, callback ) {\n            if ( typeof options === \"string\" ) {\n                options = { effect: options };\n            }\n\n            var hasOptions;\n            var effectName = !options ?\n                method :\n                options === true || typeof options === \"number\" ?\n                    defaultEffect :\n                    options.effect || defaultEffect;\n\n            options = options || {};\n            if ( typeof options === \"number\" ) {\n                options = { duration: options };\n            } else if ( options === true ) {\n                options = {};\n            }\n\n            hasOptions = !$.isEmptyObject( options );\n            options.complete = callback;\n\n            if ( options.delay ) {\n                element.delay( options.delay );\n            }\n\n            if ( hasOptions && $.effects && $.effects.effect[ effectName ] ) {\n                element[ method ]( options );\n            } else if ( effectName !== method && element[ effectName ] ) {\n                element[ effectName ]( options.duration, options.easing, callback );\n            } else {\n                element.queue( function( next ) {\n                    $( this )[ method ]();\n                    if ( callback ) {\n                        callback.call( element[ 0 ] );\n                    }\n                    next();\n                } );\n            }\n        };\n    } );\n\n    return $.widget;\n\n} );\n","jquery/ui-modules/version.js":"( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.ui = $.ui || {};\n\n    return $.ui.version = \"1.13.2\";\n\n} );\n","jquery/ui-modules/focusable.js":"/*!\n * jQuery UI Focusable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: :focusable Selector\n//>>group: Core\n//>>description: Selects elements which can be focused.\n//>>docs: http://api.jqueryui.com/focusable-selector/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n// Selectors\n    $.ui.focusable = function( element, hasTabindex ) {\n        var map, mapName, img, focusableIfVisible, fieldset,\n            nodeName = element.nodeName.toLowerCase();\n\n        if ( \"area\" === nodeName ) {\n            map = element.parentNode;\n            mapName = map.name;\n            if ( !element.href || !mapName || map.nodeName.toLowerCase() !== \"map\" ) {\n                return false;\n            }\n            img = $( \"img[usemap='#\" + mapName + \"']\" );\n            return img.length > 0 && img.is( \":visible\" );\n        }\n\n        if ( /^(input|select|textarea|button|object)$/.test( nodeName ) ) {\n            focusableIfVisible = !element.disabled;\n\n            if ( focusableIfVisible ) {\n\n                // Form controls within a disabled fieldset are disabled.\n                // However, controls within the fieldset's legend do not get disabled.\n                // Since controls generally aren't placed inside legends, we skip\n                // this portion of the check.\n                fieldset = $( element ).closest( \"fieldset\" )[ 0 ];\n                if ( fieldset ) {\n                    focusableIfVisible = !fieldset.disabled;\n                }\n            }\n        } else if ( \"a\" === nodeName ) {\n            focusableIfVisible = element.href || hasTabindex;\n        } else {\n            focusableIfVisible = hasTabindex;\n        }\n\n        return focusableIfVisible && $( element ).is( \":visible\" ) && visible( $( element ) );\n    };\n\n// Support: IE 8 only\n// IE 8 doesn't resolve inherit to visible/hidden for computed values\n    function visible( element ) {\n        var visibility = element.css( \"visibility\" );\n        while ( visibility === \"inherit\" ) {\n            element = element.parent();\n            visibility = element.css( \"visibility\" );\n        }\n        return visibility === \"visible\";\n    }\n\n    $.extend( $.expr.pseudos, {\n        focusable: function( element ) {\n            return $.ui.focusable( element, $.attr( element, \"tabindex\" ) != null );\n        }\n    } );\n\n    return $.ui.focusable;\n\n} );\n","jquery/ui-modules/data.js":"/*!\n * jQuery UI :data 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: :data Selector\n//>>group: Core\n//>>description: Selects elements which have data stored under the specified key.\n//>>docs: http://api.jqueryui.com/data-selector/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.extend( $.expr.pseudos, {\n        data: $.expr.createPseudo ?\n            $.expr.createPseudo( function( dataName ) {\n                return function( elem ) {\n                    return !!$.data( elem, dataName );\n                };\n            } ) :\n\n            // Support: jQuery <1.8\n            function( elem, i, match ) {\n                return !!$.data( elem, match[ 3 ] );\n            }\n    } );\n} );\n","jquery/ui-modules/effect.js":"/*!\n * jQuery UI Effects 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Effects Core\n//>>group: Effects\n/* eslint-disable max-len */\n//>>description: Extends the internal jQuery effects. Includes morphing and easing. Required by all other effects.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/category/effects-core/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./jquery-var-for-color\",\n            \"./vendor/jquery-color/jquery.color\",\n            \"./version\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var dataSpace = \"ui-effects-\",\n        dataSpaceStyle = \"ui-effects-style\",\n        dataSpaceAnimated = \"ui-effects-animated\";\n\n    $.effects = {\n        effect: {}\n    };\n\n    /******************************************************************************/\n    /****************************** CLASS ANIMATIONS ******************************/\n    /******************************************************************************/\n    ( function() {\n\n        var classAnimationActions = [ \"add\", \"remove\", \"toggle\" ],\n            shorthandStyles = {\n                border: 1,\n                borderBottom: 1,\n                borderColor: 1,\n                borderLeft: 1,\n                borderRight: 1,\n                borderTop: 1,\n                borderWidth: 1,\n                margin: 1,\n                padding: 1\n            };\n\n        $.each(\n            [ \"borderLeftStyle\", \"borderRightStyle\", \"borderBottomStyle\", \"borderTopStyle\" ],\n            function( _, prop ) {\n                $.fx.step[ prop ] = function( fx ) {\n                    if ( fx.end !== \"none\" && !fx.setAttr || fx.pos === 1 && !fx.setAttr ) {\n                        jQuery.style( fx.elem, prop, fx.end );\n                        fx.setAttr = true;\n                    }\n                };\n            }\n        );\n\n        function camelCase( string ) {\n            return string.replace( /-([\\da-z])/gi, function( all, letter ) {\n                return letter.toUpperCase();\n            } );\n        }\n\n        function getElementStyles( elem ) {\n            var key, len,\n                style = elem.ownerDocument.defaultView ?\n                    elem.ownerDocument.defaultView.getComputedStyle( elem, null ) :\n                    elem.currentStyle,\n                styles = {};\n\n            if ( style && style.length && style[ 0 ] && style[ style[ 0 ] ] ) {\n                len = style.length;\n                while ( len-- ) {\n                    key = style[ len ];\n                    if ( typeof style[ key ] === \"string\" ) {\n                        styles[ camelCase( key ) ] = style[ key ];\n                    }\n                }\n\n                // Support: Opera, IE <9\n            } else {\n                for ( key in style ) {\n                    if ( typeof style[ key ] === \"string\" ) {\n                        styles[ key ] = style[ key ];\n                    }\n                }\n            }\n\n            return styles;\n        }\n\n        function styleDifference( oldStyle, newStyle ) {\n            var diff = {},\n                name, value;\n\n            for ( name in newStyle ) {\n                value = newStyle[ name ];\n                if ( oldStyle[ name ] !== value ) {\n                    if ( !shorthandStyles[ name ] ) {\n                        if ( $.fx.step[ name ] || !isNaN( parseFloat( value ) ) ) {\n                            diff[ name ] = value;\n                        }\n                    }\n                }\n            }\n\n            return diff;\n        }\n\n// Support: jQuery <1.8\n        if ( !$.fn.addBack ) {\n            $.fn.addBack = function( selector ) {\n                return this.add( selector == null ?\n                    this.prevObject : this.prevObject.filter( selector )\n                );\n            };\n        }\n\n        $.effects.animateClass = function( value, duration, easing, callback ) {\n            var o = $.speed( duration, easing, callback );\n\n            return this.queue( function() {\n                var animated = $( this ),\n                    baseClass = animated.attr( \"class\" ) || \"\",\n                    applyClassChange,\n                    allAnimations = o.children ? animated.find( \"*\" ).addBack() : animated;\n\n                // Map the animated objects to store the original styles.\n                allAnimations = allAnimations.map( function() {\n                    var el = $( this );\n                    return {\n                        el: el,\n                        start: getElementStyles( this )\n                    };\n                } );\n\n                // Apply class change\n                applyClassChange = function() {\n                    $.each( classAnimationActions, function( i, action ) {\n                        if ( value[ action ] ) {\n                            animated[ action + \"Class\" ]( value[ action ] );\n                        }\n                    } );\n                };\n                applyClassChange();\n\n                // Map all animated objects again - calculate new styles and diff\n                allAnimations = allAnimations.map( function() {\n                    this.end = getElementStyles( this.el[ 0 ] );\n                    this.diff = styleDifference( this.start, this.end );\n                    return this;\n                } );\n\n                // Apply original class\n                animated.attr( \"class\", baseClass );\n\n                // Map all animated objects again - this time collecting a promise\n                allAnimations = allAnimations.map( function() {\n                    var styleInfo = this,\n                        dfd = $.Deferred(),\n                        opts = $.extend( {}, o, {\n                            queue: false,\n                            complete: function() {\n                                dfd.resolve( styleInfo );\n                            }\n                        } );\n\n                    this.el.animate( this.diff, opts );\n                    return dfd.promise();\n                } );\n\n                // Once all animations have completed:\n                $.when.apply( $, allAnimations.get() ).done( function() {\n\n                    // Set the final class\n                    applyClassChange();\n\n                    // For each animated element,\n                    // clear all css properties that were animated\n                    $.each( arguments, function() {\n                        var el = this.el;\n                        $.each( this.diff, function( key ) {\n                            el.css( key, \"\" );\n                        } );\n                    } );\n\n                    // This is guarnteed to be there if you use jQuery.speed()\n                    // it also handles dequeuing the next anim...\n                    o.complete.call( animated[ 0 ] );\n                } );\n            } );\n        };\n\n        $.fn.extend( {\n            addClass: ( function( orig ) {\n                return function( classNames, speed, easing, callback ) {\n                    return speed ?\n                        $.effects.animateClass.call( this,\n                            { add: classNames }, speed, easing, callback ) :\n                        orig.apply( this, arguments );\n                };\n            } )( $.fn.addClass ),\n\n            removeClass: ( function( orig ) {\n                return function( classNames, speed, easing, callback ) {\n                    return arguments.length > 1 ?\n                        $.effects.animateClass.call( this,\n                            { remove: classNames }, speed, easing, callback ) :\n                        orig.apply( this, arguments );\n                };\n            } )( $.fn.removeClass ),\n\n            toggleClass: ( function( orig ) {\n                return function( classNames, force, speed, easing, callback ) {\n                    if ( typeof force === \"boolean\" || force === undefined ) {\n                        if ( !speed ) {\n\n                            // Without speed parameter\n                            return orig.apply( this, arguments );\n                        } else {\n                            return $.effects.animateClass.call( this,\n                                ( force ? { add: classNames } : { remove: classNames } ),\n                                speed, easing, callback );\n                        }\n                    } else {\n\n                        // Without force parameter\n                        return $.effects.animateClass.call( this,\n                            { toggle: classNames }, force, speed, easing );\n                    }\n                };\n            } )( $.fn.toggleClass ),\n\n            switchClass: function( remove, add, speed, easing, callback ) {\n                return $.effects.animateClass.call( this, {\n                    add: add,\n                    remove: remove\n                }, speed, easing, callback );\n            }\n        } );\n\n    } )();\n\n    /******************************************************************************/\n    /*********************************** EFFECTS **********************************/\n    /******************************************************************************/\n\n    ( function() {\n\n        if ( $.expr && $.expr.pseudos && $.expr.pseudos.animated ) {\n            $.expr.pseudos.animated = ( function( orig ) {\n                return function( elem ) {\n                    return !!$( elem ).data( dataSpaceAnimated ) || orig( elem );\n                };\n            } )( $.expr.pseudos.animated );\n        }\n\n        if ( $.uiBackCompat !== false ) {\n            $.extend( $.effects, {\n\n                // Saves a set of properties in a data storage\n                save: function( element, set ) {\n                    var i = 0, length = set.length;\n                    for ( ; i < length; i++ ) {\n                        if ( set[ i ] !== null ) {\n                            element.data( dataSpace + set[ i ], element[ 0 ].style[ set[ i ] ] );\n                        }\n                    }\n                },\n\n                // Restores a set of previously saved properties from a data storage\n                restore: function( element, set ) {\n                    var val, i = 0, length = set.length;\n                    for ( ; i < length; i++ ) {\n                        if ( set[ i ] !== null ) {\n                            val = element.data( dataSpace + set[ i ] );\n                            element.css( set[ i ], val );\n                        }\n                    }\n                },\n\n                setMode: function( el, mode ) {\n                    if ( mode === \"toggle\" ) {\n                        mode = el.is( \":hidden\" ) ? \"show\" : \"hide\";\n                    }\n                    return mode;\n                },\n\n                // Wraps the element around a wrapper that copies position properties\n                createWrapper: function( element ) {\n\n                    // If the element is already wrapped, return it\n                    if ( element.parent().is( \".ui-effects-wrapper\" ) ) {\n                        return element.parent();\n                    }\n\n                    // Wrap the element\n                    var props = {\n                            width: element.outerWidth( true ),\n                            height: element.outerHeight( true ),\n                            \"float\": element.css( \"float\" )\n                        },\n                        wrapper = $( \"<div></div>\" )\n                            .addClass( \"ui-effects-wrapper\" )\n                            .css( {\n                                fontSize: \"100%\",\n                                background: \"transparent\",\n                                border: \"none\",\n                                margin: 0,\n                                padding: 0\n                            } ),\n\n                        // Store the size in case width/height are defined in % - Fixes #5245\n                        size = {\n                            width: element.width(),\n                            height: element.height()\n                        },\n                        active = document.activeElement;\n\n                    // Support: Firefox\n                    // Firefox incorrectly exposes anonymous content\n                    // https://bugzilla.mozilla.org/show_bug.cgi?id=561664\n                    try {\n                        // eslint-disable-next-line no-unused-expressions\n                        active.id;\n                    } catch ( e ) {\n                        active = document.body;\n                    }\n\n                    element.wrap( wrapper );\n\n                    // Fixes #7595 - Elements lose focus when wrapped.\n                    if ( element[ 0 ] === active || $.contains( element[ 0 ], active ) ) {\n                        $( active ).trigger( \"focus\" );\n                    }\n\n                    // Hotfix for jQuery 1.4 since some change in wrap() seems to actually\n                    // lose the reference to the wrapped element\n                    wrapper = element.parent();\n\n                    // Transfer positioning properties to the wrapper\n                    if ( element.css( \"position\" ) === \"static\" ) {\n                        wrapper.css( { position: \"relative\" } );\n                        element.css( { position: \"relative\" } );\n                    } else {\n                        $.extend( props, {\n                            position: element.css( \"position\" ),\n                            zIndex: element.css( \"z-index\" )\n                        } );\n                        $.each( [ \"top\", \"left\", \"bottom\", \"right\" ], function( i, pos ) {\n                            props[ pos ] = element.css( pos );\n                            if ( isNaN( parseInt( props[ pos ], 10 ) ) ) {\n                                props[ pos ] = \"auto\";\n                            }\n                        } );\n                        element.css( {\n                            position: \"relative\",\n                            top: 0,\n                            left: 0,\n                            right: \"auto\",\n                            bottom: \"auto\"\n                        } );\n                    }\n                    element.css( size );\n\n                    return wrapper.css( props ).show();\n                },\n\n                removeWrapper: function( element ) {\n                    var active = document.activeElement;\n\n                    if ( element.parent().is( \".ui-effects-wrapper\" ) ) {\n                        element.parent().replaceWith( element );\n\n                        // Fixes #7595 - Elements lose focus when wrapped.\n                        if ( element[ 0 ] === active || $.contains( element[ 0 ], active ) ) {\n                            $( active ).trigger( \"focus\" );\n                        }\n                    }\n\n                    return element;\n                }\n            } );\n        }\n\n        $.extend( $.effects, {\n            version: \"1.13.2\",\n\n            define: function( name, mode, effect ) {\n                if ( !effect ) {\n                    effect = mode;\n                    mode = \"effect\";\n                }\n\n                $.effects.effect[ name ] = effect;\n                $.effects.effect[ name ].mode = mode;\n\n                return effect;\n            },\n\n            scaledDimensions: function( element, percent, direction ) {\n                if ( percent === 0 ) {\n                    return {\n                        height: 0,\n                        width: 0,\n                        outerHeight: 0,\n                        outerWidth: 0\n                    };\n                }\n\n                var x = direction !== \"horizontal\" ? ( ( percent || 100 ) / 100 ) : 1,\n                    y = direction !== \"vertical\" ? ( ( percent || 100 ) / 100 ) : 1;\n\n                return {\n                    height: element.height() * y,\n                    width: element.width() * x,\n                    outerHeight: element.outerHeight() * y,\n                    outerWidth: element.outerWidth() * x\n                };\n\n            },\n\n            clipToBox: function( animation ) {\n                return {\n                    width: animation.clip.right - animation.clip.left,\n                    height: animation.clip.bottom - animation.clip.top,\n                    left: animation.clip.left,\n                    top: animation.clip.top\n                };\n            },\n\n            // Injects recently queued functions to be first in line (after \"inprogress\")\n            unshift: function( element, queueLength, count ) {\n                var queue = element.queue();\n\n                if ( queueLength > 1 ) {\n                    queue.splice.apply( queue,\n                        [ 1, 0 ].concat( queue.splice( queueLength, count ) ) );\n                }\n                element.dequeue();\n            },\n\n            saveStyle: function( element ) {\n                element.data( dataSpaceStyle, element[ 0 ].style.cssText );\n            },\n\n            restoreStyle: function( element ) {\n                element[ 0 ].style.cssText = element.data( dataSpaceStyle ) || \"\";\n                element.removeData( dataSpaceStyle );\n            },\n\n            mode: function( element, mode ) {\n                var hidden = element.is( \":hidden\" );\n\n                if ( mode === \"toggle\" ) {\n                    mode = hidden ? \"show\" : \"hide\";\n                }\n                if ( hidden ? mode === \"hide\" : mode === \"show\" ) {\n                    mode = \"none\";\n                }\n                return mode;\n            },\n\n            // Translates a [top,left] array into a baseline value\n            getBaseline: function( origin, original ) {\n                var y, x;\n\n                switch ( origin[ 0 ] ) {\n                    case \"top\":\n                        y = 0;\n                        break;\n                    case \"middle\":\n                        y = 0.5;\n                        break;\n                    case \"bottom\":\n                        y = 1;\n                        break;\n                    default:\n                        y = origin[ 0 ] / original.height;\n                }\n\n                switch ( origin[ 1 ] ) {\n                    case \"left\":\n                        x = 0;\n                        break;\n                    case \"center\":\n                        x = 0.5;\n                        break;\n                    case \"right\":\n                        x = 1;\n                        break;\n                    default:\n                        x = origin[ 1 ] / original.width;\n                }\n\n                return {\n                    x: x,\n                    y: y\n                };\n            },\n\n            // Creates a placeholder element so that the original element can be made absolute\n            createPlaceholder: function( element ) {\n                var placeholder,\n                    cssPosition = element.css( \"position\" ),\n                    position = element.position();\n\n                // Lock in margins first to account for form elements, which\n                // will change margin if you explicitly set height\n                // see: http://jsfiddle.net/JZSMt/3/ https://bugs.webkit.org/show_bug.cgi?id=107380\n                // Support: Safari\n                element.css( {\n                    marginTop: element.css( \"marginTop\" ),\n                    marginBottom: element.css( \"marginBottom\" ),\n                    marginLeft: element.css( \"marginLeft\" ),\n                    marginRight: element.css( \"marginRight\" )\n                } )\n                    .outerWidth( element.outerWidth() )\n                    .outerHeight( element.outerHeight() );\n\n                if ( /^(static|relative)/.test( cssPosition ) ) {\n                    cssPosition = \"absolute\";\n\n                    placeholder = $( \"<\" + element[ 0 ].nodeName + \">\" ).insertAfter( element ).css( {\n\n                        // Convert inline to inline block to account for inline elements\n                        // that turn to inline block based on content (like img)\n                        display: /^(inline|ruby)/.test( element.css( \"display\" ) ) ?\n                            \"inline-block\" :\n                            \"block\",\n                        visibility: \"hidden\",\n\n                        // Margins need to be set to account for margin collapse\n                        marginTop: element.css( \"marginTop\" ),\n                        marginBottom: element.css( \"marginBottom\" ),\n                        marginLeft: element.css( \"marginLeft\" ),\n                        marginRight: element.css( \"marginRight\" ),\n                        \"float\": element.css( \"float\" )\n                    } )\n                        .outerWidth( element.outerWidth() )\n                        .outerHeight( element.outerHeight() )\n                        .addClass( \"ui-effects-placeholder\" );\n\n                    element.data( dataSpace + \"placeholder\", placeholder );\n                }\n\n                element.css( {\n                    position: cssPosition,\n                    left: position.left,\n                    top: position.top\n                } );\n\n                return placeholder;\n            },\n\n            removePlaceholder: function( element ) {\n                var dataKey = dataSpace + \"placeholder\",\n                    placeholder = element.data( dataKey );\n\n                if ( placeholder ) {\n                    placeholder.remove();\n                    element.removeData( dataKey );\n                }\n            },\n\n            // Removes a placeholder if it exists and restores\n            // properties that were modified during placeholder creation\n            cleanUp: function( element ) {\n                $.effects.restoreStyle( element );\n                $.effects.removePlaceholder( element );\n            },\n\n            setTransition: function( element, list, factor, value ) {\n                value = value || {};\n                $.each( list, function( i, x ) {\n                    var unit = element.cssUnit( x );\n                    if ( unit[ 0 ] > 0 ) {\n                        value[ x ] = unit[ 0 ] * factor + unit[ 1 ];\n                    }\n                } );\n                return value;\n            }\n        } );\n\n// Return an effect options object for the given parameters:\n        function _normalizeArguments( effect, options, speed, callback ) {\n\n            // Allow passing all options as the first parameter\n            if ( $.isPlainObject( effect ) ) {\n                options = effect;\n                effect = effect.effect;\n            }\n\n            // Convert to an object\n            effect = { effect: effect };\n\n            // Catch (effect, null, ...)\n            if ( options == null ) {\n                options = {};\n            }\n\n            // Catch (effect, callback)\n            if ( typeof options === \"function\" ) {\n                callback = options;\n                speed = null;\n                options = {};\n            }\n\n            // Catch (effect, speed, ?)\n            if ( typeof options === \"number\" || $.fx.speeds[ options ] ) {\n                callback = speed;\n                speed = options;\n                options = {};\n            }\n\n            // Catch (effect, options, callback)\n            if ( typeof speed === \"function\" ) {\n                callback = speed;\n                speed = null;\n            }\n\n            // Add options to effect\n            if ( options ) {\n                $.extend( effect, options );\n            }\n\n            speed = speed || options.duration;\n            effect.duration = $.fx.off ? 0 :\n                typeof speed === \"number\" ? speed :\n                    speed in $.fx.speeds ? $.fx.speeds[ speed ] :\n                        $.fx.speeds._default;\n\n            effect.complete = callback || options.complete;\n\n            return effect;\n        }\n\n        function standardAnimationOption( option ) {\n\n            // Valid standard speeds (nothing, number, named speed)\n            if ( !option || typeof option === \"number\" || $.fx.speeds[ option ] ) {\n                return true;\n            }\n\n            // Invalid strings - treat as \"normal\" speed\n            if ( typeof option === \"string\" && !$.effects.effect[ option ] ) {\n                return true;\n            }\n\n            // Complete callback\n            if ( typeof option === \"function\" ) {\n                return true;\n            }\n\n            // Options hash (but not naming an effect)\n            if ( typeof option === \"object\" && !option.effect ) {\n                return true;\n            }\n\n            // Didn't match any standard API\n            return false;\n        }\n\n        $.fn.extend( {\n            effect: function( /* effect, options, speed, callback */ ) {\n                var args = _normalizeArguments.apply( this, arguments ),\n                    effectMethod = $.effects.effect[ args.effect ],\n                    defaultMode = effectMethod.mode,\n                    queue = args.queue,\n                    queueName = queue || \"fx\",\n                    complete = args.complete,\n                    mode = args.mode,\n                    modes = [],\n                    prefilter = function( next ) {\n                        var el = $( this ),\n                            normalizedMode = $.effects.mode( el, mode ) || defaultMode;\n\n                        // Sentinel for duck-punching the :animated pseudo-selector\n                        el.data( dataSpaceAnimated, true );\n\n                        // Save effect mode for later use,\n                        // we can't just call $.effects.mode again later,\n                        // as the .show() below destroys the initial state\n                        modes.push( normalizedMode );\n\n                        // See $.uiBackCompat inside of run() for removal of defaultMode in 1.14\n                        if ( defaultMode && ( normalizedMode === \"show\" ||\n                            ( normalizedMode === defaultMode && normalizedMode === \"hide\" ) ) ) {\n                            el.show();\n                        }\n\n                        if ( !defaultMode || normalizedMode !== \"none\" ) {\n                            $.effects.saveStyle( el );\n                        }\n\n                        if ( typeof next === \"function\" ) {\n                            next();\n                        }\n                    };\n\n                if ( $.fx.off || !effectMethod ) {\n\n                    // Delegate to the original method (e.g., .show()) if possible\n                    if ( mode ) {\n                        return this[ mode ]( args.duration, complete );\n                    } else {\n                        return this.each( function() {\n                            if ( complete ) {\n                                complete.call( this );\n                            }\n                        } );\n                    }\n                }\n\n                function run( next ) {\n                    var elem = $( this );\n\n                    function cleanup() {\n                        elem.removeData( dataSpaceAnimated );\n\n                        $.effects.cleanUp( elem );\n\n                        if ( args.mode === \"hide\" ) {\n                            elem.hide();\n                        }\n\n                        done();\n                    }\n\n                    function done() {\n                        if ( typeof complete === \"function\" ) {\n                            complete.call( elem[ 0 ] );\n                        }\n\n                        if ( typeof next === \"function\" ) {\n                            next();\n                        }\n                    }\n\n                    // Override mode option on a per element basis,\n                    // as toggle can be either show or hide depending on element state\n                    args.mode = modes.shift();\n\n                    if ( $.uiBackCompat !== false && !defaultMode ) {\n                        if ( elem.is( \":hidden\" ) ? mode === \"hide\" : mode === \"show\" ) {\n\n                            // Call the core method to track \"olddisplay\" properly\n                            elem[ mode ]();\n                            done();\n                        } else {\n                            effectMethod.call( elem[ 0 ], args, done );\n                        }\n                    } else {\n                        if ( args.mode === \"none\" ) {\n\n                            // Call the core method to track \"olddisplay\" properly\n                            elem[ mode ]();\n                            done();\n                        } else {\n                            effectMethod.call( elem[ 0 ], args, cleanup );\n                        }\n                    }\n                }\n\n                // Run prefilter on all elements first to ensure that\n                // any showing or hiding happens before placeholder creation,\n                // which ensures that any layout changes are correctly captured.\n                return queue === false ?\n                    this.each( prefilter ).each( run ) :\n                    this.queue( queueName, prefilter ).queue( queueName, run );\n            },\n\n            show: ( function( orig ) {\n                return function( option ) {\n                    if ( standardAnimationOption( option ) ) {\n                        return orig.apply( this, arguments );\n                    } else {\n                        var args = _normalizeArguments.apply( this, arguments );\n                        args.mode = \"show\";\n                        return this.effect.call( this, args );\n                    }\n                };\n            } )( $.fn.show ),\n\n            hide: ( function( orig ) {\n                return function( option ) {\n                    if ( standardAnimationOption( option ) ) {\n                        return orig.apply( this, arguments );\n                    } else {\n                        var args = _normalizeArguments.apply( this, arguments );\n                        args.mode = \"hide\";\n                        return this.effect.call( this, args );\n                    }\n                };\n            } )( $.fn.hide ),\n\n            toggle: ( function( orig ) {\n                return function( option ) {\n                    if ( standardAnimationOption( option ) || typeof option === \"boolean\" ) {\n                        return orig.apply( this, arguments );\n                    } else {\n                        var args = _normalizeArguments.apply( this, arguments );\n                        args.mode = \"toggle\";\n                        return this.effect.call( this, args );\n                    }\n                };\n            } )( $.fn.toggle ),\n\n            cssUnit: function( key ) {\n                var style = this.css( key ),\n                    val = [];\n\n                $.each( [ \"em\", \"px\", \"%\", \"pt\" ], function( i, unit ) {\n                    if ( style.indexOf( unit ) > 0 ) {\n                        val = [ parseFloat( style ), unit ];\n                    }\n                } );\n                return val;\n            },\n\n            cssClip: function( clipObj ) {\n                if ( clipObj ) {\n                    return this.css( \"clip\", \"rect(\" + clipObj.top + \"px \" + clipObj.right + \"px \" +\n                        clipObj.bottom + \"px \" + clipObj.left + \"px)\" );\n                }\n                return parseClip( this.css( \"clip\" ), this );\n            },\n\n            transfer: function( options, done ) {\n                var element = $( this ),\n                    target = $( options.to ),\n                    targetFixed = target.css( \"position\" ) === \"fixed\",\n                    body = $( \"body\" ),\n                    fixTop = targetFixed ? body.scrollTop() : 0,\n                    fixLeft = targetFixed ? body.scrollLeft() : 0,\n                    endPosition = target.offset(),\n                    animation = {\n                        top: endPosition.top - fixTop,\n                        left: endPosition.left - fixLeft,\n                        height: target.innerHeight(),\n                        width: target.innerWidth()\n                    },\n                    startPosition = element.offset(),\n                    transfer = $( \"<div class='ui-effects-transfer'></div>\" );\n\n                transfer\n                    .appendTo( \"body\" )\n                    .addClass( options.className )\n                    .css( {\n                        top: startPosition.top - fixTop,\n                        left: startPosition.left - fixLeft,\n                        height: element.innerHeight(),\n                        width: element.innerWidth(),\n                        position: targetFixed ? \"fixed\" : \"absolute\"\n                    } )\n                    .animate( animation, options.duration, options.easing, function() {\n                        transfer.remove();\n                        if ( typeof done === \"function\" ) {\n                            done();\n                        }\n                    } );\n            }\n        } );\n\n        function parseClip( str, element ) {\n            var outerWidth = element.outerWidth(),\n                outerHeight = element.outerHeight(),\n                clipRegex = /^rect\\((-?\\d*\\.?\\d*px|-?\\d+%|auto),?\\s*(-?\\d*\\.?\\d*px|-?\\d+%|auto),?\\s*(-?\\d*\\.?\\d*px|-?\\d+%|auto),?\\s*(-?\\d*\\.?\\d*px|-?\\d+%|auto)\\)$/,\n                values = clipRegex.exec( str ) || [ \"\", 0, outerWidth, outerHeight, 0 ];\n\n            return {\n                top: parseFloat( values[ 1 ] ) || 0,\n                right: values[ 2 ] === \"auto\" ? outerWidth : parseFloat( values[ 2 ] ),\n                bottom: values[ 3 ] === \"auto\" ? outerHeight : parseFloat( values[ 3 ] ),\n                left: parseFloat( values[ 4 ] ) || 0\n            };\n        }\n\n        $.fx.step.clip = function( fx ) {\n            if ( !fx.clipInit ) {\n                fx.start = $( fx.elem ).cssClip();\n                if ( typeof fx.end === \"string\" ) {\n                    fx.end = parseClip( fx.end, fx.elem );\n                }\n                fx.clipInit = true;\n            }\n\n            $( fx.elem ).cssClip( {\n                top: fx.pos * ( fx.end.top - fx.start.top ) + fx.start.top,\n                right: fx.pos * ( fx.end.right - fx.start.right ) + fx.start.right,\n                bottom: fx.pos * ( fx.end.bottom - fx.start.bottom ) + fx.start.bottom,\n                left: fx.pos * ( fx.end.left - fx.start.left ) + fx.start.left\n            } );\n        };\n\n    } )();\n\n    /******************************************************************************/\n    /*********************************** EASING ***********************************/\n    /******************************************************************************/\n\n    ( function() {\n\n// Based on easing equations from Robert Penner (http://www.robertpenner.com/easing)\n\n        var baseEasings = {};\n\n        $.each( [ \"Quad\", \"Cubic\", \"Quart\", \"Quint\", \"Expo\" ], function( i, name ) {\n            baseEasings[ name ] = function( p ) {\n                return Math.pow( p, i + 2 );\n            };\n        } );\n\n        $.extend( baseEasings, {\n            Sine: function( p ) {\n                return 1 - Math.cos( p * Math.PI / 2 );\n            },\n            Circ: function( p ) {\n                return 1 - Math.sqrt( 1 - p * p );\n            },\n            Elastic: function( p ) {\n                return p === 0 || p === 1 ? p :\n                    -Math.pow( 2, 8 * ( p - 1 ) ) * Math.sin( ( ( p - 1 ) * 80 - 7.5 ) * Math.PI / 15 );\n            },\n            Back: function( p ) {\n                return p * p * ( 3 * p - 2 );\n            },\n            Bounce: function( p ) {\n                var pow2,\n                    bounce = 4;\n\n                while ( p < ( ( pow2 = Math.pow( 2, --bounce ) ) - 1 ) / 11 ) {}\n                return 1 / Math.pow( 4, 3 - bounce ) - 7.5625 * Math.pow( ( pow2 * 3 - 2 ) / 22 - p, 2 );\n            }\n        } );\n\n        $.each( baseEasings, function( name, easeIn ) {\n            $.easing[ \"easeIn\" + name ] = easeIn;\n            $.easing[ \"easeOut\" + name ] = function( p ) {\n                return 1 - easeIn( 1 - p );\n            };\n            $.easing[ \"easeInOut\" + name ] = function( p ) {\n                return p < 0.5 ?\n                    easeIn( p * 2 ) / 2 :\n                    1 - easeIn( p * -2 + 2 ) / 2;\n            };\n        } );\n\n    } )();\n\n    return $.effects;\n\n} );\n","jquery/ui-modules/safe-blur.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.ui.safeBlur = function( element ) {\n\n\t// Support: IE9 - 10 only\n\t// If the <body> is blurred, IE will switch windows, see #9420\n\tif ( element && element.nodeName.toLowerCase() !== \"body\" ) {\n\t\t$( element ).trigger( \"blur\" );\n\t}\n};\n\n} );\n","jquery/ui-modules/form.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// Support: IE8 Only\n// IE8 does not support the form attribute and when it is supplied. It overwrites the form prop\n// with a string, so we need to find the proper form.\nreturn $.fn._form = function() {\n\treturn typeof this[ 0 ].form === \"string\" ? this.closest( \"form\" ) : $( this[ 0 ].form );\n};\n\n} );\n","jquery/ui-modules/safe-active-element.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.ui.safeActiveElement = function( document ) {\n\tvar activeElement;\n\n\t// Support: IE 9 only\n\t// IE9 throws an \"Unspecified error\" accessing document.activeElement from an <iframe>\n\ttry {\n\t\tactiveElement = document.activeElement;\n\t} catch ( error ) {\n\t\tactiveElement = document.body;\n\t}\n\n\t// Support: IE 9 - 11 only\n\t// IE may return null instead of an element\n\t// Interestingly, this only seems to occur when NOT in an iframe\n\tif ( !activeElement ) {\n\t\tactiveElement = document.body;\n\t}\n\n\t// Support: IE 11 only\n\t// IE11 returns a seemingly empty object in some cases when accessing\n\t// document.activeElement from an <iframe>\n\tif ( !activeElement.nodeName ) {\n\t\tactiveElement = document.body;\n\t}\n\n\treturn activeElement;\n};\n\n} );\n","jquery/ui-modules/plugin.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// $.ui.plugin is deprecated. Use $.widget() extensions instead.\nreturn $.ui.plugin = {\n\tadd: function( module, option, set ) {\n\t\tvar i,\n\t\t\tproto = $.ui[ module ].prototype;\n\t\tfor ( i in set ) {\n\t\t\tproto.plugins[ i ] = proto.plugins[ i ] || [];\n\t\t\tproto.plugins[ i ].push( [ option, set[ i ] ] );\n\t\t}\n\t},\n\tcall: function( instance, name, args, allowDisconnected ) {\n\t\tvar i,\n\t\t\tset = instance.plugins[ name ];\n\n\t\tif ( !set ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( !allowDisconnected && ( !instance.element[ 0 ].parentNode ||\n\t\t\t\tinstance.element[ 0 ].parentNode.nodeType === 11 ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tfor ( i = 0; i < set.length; i++ ) {\n\t\t\tif ( instance.options[ set[ i ][ 0 ] ] ) {\n\t\t\t\tset[ i ][ 1 ].apply( instance.element, args );\n\t\t\t}\n\t\t}\n\t}\n};\n\n} );\n","jquery/ui-modules/position.js":"/*!\n * jQuery UI Position 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/position/\n */\n\n//>>label: Position\n//>>group: Core\n//>>description: Positions elements relative to other elements.\n//>>docs: http://api.jqueryui.com/position/\n//>>demos: http://jqueryui.com/position/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    ( function() {\n        var cachedScrollbarWidth,\n            max = Math.max,\n            abs = Math.abs,\n            rhorizontal = /left|center|right/,\n            rvertical = /top|center|bottom/,\n            roffset = /[\\+\\-]\\d+(\\.[\\d]+)?%?/,\n            rposition = /^\\w+/,\n            rpercent = /%$/,\n            _position = $.fn.position;\n\n        function getOffsets( offsets, width, height ) {\n            return [\n                parseFloat( offsets[ 0 ] ) * ( rpercent.test( offsets[ 0 ] ) ? width / 100 : 1 ),\n                parseFloat( offsets[ 1 ] ) * ( rpercent.test( offsets[ 1 ] ) ? height / 100 : 1 )\n            ];\n        }\n\n        function parseCss( element, property ) {\n            return parseInt( $.css( element, property ), 10 ) || 0;\n        }\n\n        function isWindow( obj ) {\n            return obj != null && obj === obj.window;\n        }\n\n        function getDimensions( elem ) {\n            var raw = elem[ 0 ];\n            if ( raw.nodeType === 9 ) {\n                return {\n                    width: elem.width(),\n                    height: elem.height(),\n                    offset: { top: 0, left: 0 }\n                };\n            }\n            if ( isWindow( raw ) ) {\n                return {\n                    width: elem.width(),\n                    height: elem.height(),\n                    offset: { top: elem.scrollTop(), left: elem.scrollLeft() }\n                };\n            }\n            if ( raw.preventDefault ) {\n                return {\n                    width: 0,\n                    height: 0,\n                    offset: { top: raw.pageY, left: raw.pageX }\n                };\n            }\n            return {\n                width: elem.outerWidth(),\n                height: elem.outerHeight(),\n                offset: elem.offset()\n            };\n        }\n\n        $.position = {\n            scrollbarWidth: function() {\n                if ( cachedScrollbarWidth !== undefined ) {\n                    return cachedScrollbarWidth;\n                }\n                var w1, w2,\n                    div = $( \"<div style=\" +\n                        \"'display:block;position:absolute;width:200px;height:200px;overflow:hidden;'>\" +\n                        \"<div style='height:300px;width:auto;'></div></div>\" ),\n                    innerDiv = div.children()[ 0 ];\n\n                $( \"body\" ).append( div );\n                w1 = innerDiv.offsetWidth;\n                div.css( \"overflow\", \"scroll\" );\n\n                w2 = innerDiv.offsetWidth;\n\n                if ( w1 === w2 ) {\n                    w2 = div[ 0 ].clientWidth;\n                }\n\n                div.remove();\n\n                return ( cachedScrollbarWidth = w1 - w2 );\n            },\n            getScrollInfo: function( within ) {\n                var overflowX = within.isWindow || within.isDocument ? \"\" :\n                        within.element.css( \"overflow-x\" ),\n                    overflowY = within.isWindow || within.isDocument ? \"\" :\n                        within.element.css( \"overflow-y\" ),\n                    hasOverflowX = overflowX === \"scroll\" ||\n                        ( overflowX === \"auto\" && within.width < within.element[ 0 ].scrollWidth ),\n                    hasOverflowY = overflowY === \"scroll\" ||\n                        ( overflowY === \"auto\" && within.height < within.element[ 0 ].scrollHeight );\n                return {\n                    width: hasOverflowY ? $.position.scrollbarWidth() : 0,\n                    height: hasOverflowX ? $.position.scrollbarWidth() : 0\n                };\n            },\n            getWithinInfo: function( element ) {\n                var withinElement = $( element || window ),\n                    isElemWindow = isWindow( withinElement[ 0 ] ),\n                    isDocument = !!withinElement[ 0 ] && withinElement[ 0 ].nodeType === 9,\n                    hasOffset = !isElemWindow && !isDocument;\n                return {\n                    element: withinElement,\n                    isWindow: isElemWindow,\n                    isDocument: isDocument,\n                    offset: hasOffset ? $( element ).offset() : { left: 0, top: 0 },\n                    scrollLeft: withinElement.scrollLeft(),\n                    scrollTop: withinElement.scrollTop(),\n                    width: withinElement.outerWidth(),\n                    height: withinElement.outerHeight()\n                };\n            }\n        };\n\n        $.fn.position = function( options ) {\n            if ( !options || !options.of ) {\n                return _position.apply( this, arguments );\n            }\n\n            // Make a copy, we don't want to modify arguments\n            options = $.extend( {}, options );\n\n            var atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions,\n\n                // Make sure string options are treated as CSS selectors\n                target = typeof options.of === \"string\" ?\n                    $( document ).find( options.of ) :\n                    $( options.of ),\n\n                within = $.position.getWithinInfo( options.within ),\n                scrollInfo = $.position.getScrollInfo( within ),\n                collision = ( options.collision || \"flip\" ).split( \" \" ),\n                offsets = {};\n\n            dimensions = getDimensions( target );\n            if ( target[ 0 ].preventDefault ) {\n\n                // Force left top to allow flipping\n                options.at = \"left top\";\n            }\n            targetWidth = dimensions.width;\n            targetHeight = dimensions.height;\n            targetOffset = dimensions.offset;\n\n            // Clone to reuse original targetOffset later\n            basePosition = $.extend( {}, targetOffset );\n\n            // Force my and at to have valid horizontal and vertical positions\n            // if a value is missing or invalid, it will be converted to center\n            $.each( [ \"my\", \"at\" ], function() {\n                var pos = ( options[ this ] || \"\" ).split( \" \" ),\n                    horizontalOffset,\n                    verticalOffset;\n\n                if ( pos.length === 1 ) {\n                    pos = rhorizontal.test( pos[ 0 ] ) ?\n                        pos.concat( [ \"center\" ] ) :\n                        rvertical.test( pos[ 0 ] ) ?\n                            [ \"center\" ].concat( pos ) :\n                            [ \"center\", \"center\" ];\n                }\n                pos[ 0 ] = rhorizontal.test( pos[ 0 ] ) ? pos[ 0 ] : \"center\";\n                pos[ 1 ] = rvertical.test( pos[ 1 ] ) ? pos[ 1 ] : \"center\";\n\n                // Calculate offsets\n                horizontalOffset = roffset.exec( pos[ 0 ] );\n                verticalOffset = roffset.exec( pos[ 1 ] );\n                offsets[ this ] = [\n                    horizontalOffset ? horizontalOffset[ 0 ] : 0,\n                    verticalOffset ? verticalOffset[ 0 ] : 0\n                ];\n\n                // Reduce to just the positions without the offsets\n                options[ this ] = [\n                    rposition.exec( pos[ 0 ] )[ 0 ],\n                    rposition.exec( pos[ 1 ] )[ 0 ]\n                ];\n            } );\n\n            // Normalize collision option\n            if ( collision.length === 1 ) {\n                collision[ 1 ] = collision[ 0 ];\n            }\n\n            if ( options.at[ 0 ] === \"right\" ) {\n                basePosition.left += targetWidth;\n            } else if ( options.at[ 0 ] === \"center\" ) {\n                basePosition.left += targetWidth / 2;\n            }\n\n            if ( options.at[ 1 ] === \"bottom\" ) {\n                basePosition.top += targetHeight;\n            } else if ( options.at[ 1 ] === \"center\" ) {\n                basePosition.top += targetHeight / 2;\n            }\n\n            atOffset = getOffsets( offsets.at, targetWidth, targetHeight );\n            basePosition.left += atOffset[ 0 ];\n            basePosition.top += atOffset[ 1 ];\n\n            return this.each( function() {\n                var collisionPosition, using,\n                    elem = $( this ),\n                    elemWidth = elem.outerWidth(),\n                    elemHeight = elem.outerHeight(),\n                    marginLeft = parseCss( this, \"marginLeft\" ),\n                    marginTop = parseCss( this, \"marginTop\" ),\n                    collisionWidth = elemWidth + marginLeft + parseCss( this, \"marginRight\" ) +\n                        scrollInfo.width,\n                    collisionHeight = elemHeight + marginTop + parseCss( this, \"marginBottom\" ) +\n                        scrollInfo.height,\n                    position = $.extend( {}, basePosition ),\n                    myOffset = getOffsets( offsets.my, elem.outerWidth(), elem.outerHeight() );\n\n                if ( options.my[ 0 ] === \"right\" ) {\n                    position.left -= elemWidth;\n                } else if ( options.my[ 0 ] === \"center\" ) {\n                    position.left -= elemWidth / 2;\n                }\n\n                if ( options.my[ 1 ] === \"bottom\" ) {\n                    position.top -= elemHeight;\n                } else if ( options.my[ 1 ] === \"center\" ) {\n                    position.top -= elemHeight / 2;\n                }\n\n                position.left += myOffset[ 0 ];\n                position.top += myOffset[ 1 ];\n\n                collisionPosition = {\n                    marginLeft: marginLeft,\n                    marginTop: marginTop\n                };\n\n                $.each( [ \"left\", \"top\" ], function( i, dir ) {\n                    if ( $.ui.position[ collision[ i ] ] ) {\n                        $.ui.position[ collision[ i ] ][ dir ]( position, {\n                            targetWidth: targetWidth,\n                            targetHeight: targetHeight,\n                            elemWidth: elemWidth,\n                            elemHeight: elemHeight,\n                            collisionPosition: collisionPosition,\n                            collisionWidth: collisionWidth,\n                            collisionHeight: collisionHeight,\n                            offset: [ atOffset[ 0 ] + myOffset[ 0 ], atOffset [ 1 ] + myOffset[ 1 ] ],\n                            my: options.my,\n                            at: options.at,\n                            within: within,\n                            elem: elem\n                        } );\n                    }\n                } );\n\n                if ( options.using ) {\n\n                    // Adds feedback as second argument to using callback, if present\n                    using = function( props ) {\n                        var left = targetOffset.left - position.left,\n                            right = left + targetWidth - elemWidth,\n                            top = targetOffset.top - position.top,\n                            bottom = top + targetHeight - elemHeight,\n                            feedback = {\n                                target: {\n                                    element: target,\n                                    left: targetOffset.left,\n                                    top: targetOffset.top,\n                                    width: targetWidth,\n                                    height: targetHeight\n                                },\n                                element: {\n                                    element: elem,\n                                    left: position.left,\n                                    top: position.top,\n                                    width: elemWidth,\n                                    height: elemHeight\n                                },\n                                horizontal: right < 0 ? \"left\" : left > 0 ? \"right\" : \"center\",\n                                vertical: bottom < 0 ? \"top\" : top > 0 ? \"bottom\" : \"middle\"\n                            };\n                        if ( targetWidth < elemWidth && abs( left + right ) < targetWidth ) {\n                            feedback.horizontal = \"center\";\n                        }\n                        if ( targetHeight < elemHeight && abs( top + bottom ) < targetHeight ) {\n                            feedback.vertical = \"middle\";\n                        }\n                        if ( max( abs( left ), abs( right ) ) > max( abs( top ), abs( bottom ) ) ) {\n                            feedback.important = \"horizontal\";\n                        } else {\n                            feedback.important = \"vertical\";\n                        }\n                        options.using.call( this, props, feedback );\n                    };\n                }\n\n                elem.offset( $.extend( position, { using: using } ) );\n            } );\n        };\n\n        $.ui.position = {\n            fit: {\n                left: function( position, data ) {\n                    var within = data.within,\n                        withinOffset = within.isWindow ? within.scrollLeft : within.offset.left,\n                        outerWidth = within.width,\n                        collisionPosLeft = position.left - data.collisionPosition.marginLeft,\n                        overLeft = withinOffset - collisionPosLeft,\n                        overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,\n                        newOverRight;\n\n                    // Element is wider than within\n                    if ( data.collisionWidth > outerWidth ) {\n\n                        // Element is initially over the left side of within\n                        if ( overLeft > 0 && overRight <= 0 ) {\n                            newOverRight = position.left + overLeft + data.collisionWidth - outerWidth -\n                                withinOffset;\n                            position.left += overLeft - newOverRight;\n\n                            // Element is initially over right side of within\n                        } else if ( overRight > 0 && overLeft <= 0 ) {\n                            position.left = withinOffset;\n\n                            // Element is initially over both left and right sides of within\n                        } else {\n                            if ( overLeft > overRight ) {\n                                position.left = withinOffset + outerWidth - data.collisionWidth;\n                            } else {\n                                position.left = withinOffset;\n                            }\n                        }\n\n                        // Too far left -> align with left edge\n                    } else if ( overLeft > 0 ) {\n                        position.left += overLeft;\n\n                        // Too far right -> align with right edge\n                    } else if ( overRight > 0 ) {\n                        position.left -= overRight;\n\n                        // Adjust based on position and margin\n                    } else {\n                        position.left = max( position.left - collisionPosLeft, position.left );\n                    }\n                },\n                top: function( position, data ) {\n                    var within = data.within,\n                        withinOffset = within.isWindow ? within.scrollTop : within.offset.top,\n                        outerHeight = data.within.height,\n                        collisionPosTop = position.top - data.collisionPosition.marginTop,\n                        overTop = withinOffset - collisionPosTop,\n                        overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,\n                        newOverBottom;\n\n                    // Element is taller than within\n                    if ( data.collisionHeight > outerHeight ) {\n\n                        // Element is initially over the top of within\n                        if ( overTop > 0 && overBottom <= 0 ) {\n                            newOverBottom = position.top + overTop + data.collisionHeight - outerHeight -\n                                withinOffset;\n                            position.top += overTop - newOverBottom;\n\n                            // Element is initially over bottom of within\n                        } else if ( overBottom > 0 && overTop <= 0 ) {\n                            position.top = withinOffset;\n\n                            // Element is initially over both top and bottom of within\n                        } else {\n                            if ( overTop > overBottom ) {\n                                position.top = withinOffset + outerHeight - data.collisionHeight;\n                            } else {\n                                position.top = withinOffset;\n                            }\n                        }\n\n                        // Too far up -> align with top\n                    } else if ( overTop > 0 ) {\n                        position.top += overTop;\n\n                        // Too far down -> align with bottom edge\n                    } else if ( overBottom > 0 ) {\n                        position.top -= overBottom;\n\n                        // Adjust based on position and margin\n                    } else {\n                        position.top = max( position.top - collisionPosTop, position.top );\n                    }\n                }\n            },\n            flip: {\n                left: function( position, data ) {\n                    var within = data.within,\n                        withinOffset = within.offset.left + within.scrollLeft,\n                        outerWidth = within.width,\n                        offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,\n                        collisionPosLeft = position.left - data.collisionPosition.marginLeft,\n                        overLeft = collisionPosLeft - offsetLeft,\n                        overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,\n                        myOffset = data.my[ 0 ] === \"left\" ?\n                            -data.elemWidth :\n                            data.my[ 0 ] === \"right\" ?\n                                data.elemWidth :\n                                0,\n                        atOffset = data.at[ 0 ] === \"left\" ?\n                            data.targetWidth :\n                            data.at[ 0 ] === \"right\" ?\n                                -data.targetWidth :\n                                0,\n                        offset = -2 * data.offset[ 0 ],\n                        newOverRight,\n                        newOverLeft;\n\n                    if ( overLeft < 0 ) {\n                        newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth -\n                            outerWidth - withinOffset;\n                        if ( newOverRight < 0 || newOverRight < abs( overLeft ) ) {\n                            position.left += myOffset + atOffset + offset;\n                        }\n                    } else if ( overRight > 0 ) {\n                        newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset +\n                            atOffset + offset - offsetLeft;\n                        if ( newOverLeft > 0 || abs( newOverLeft ) < overRight ) {\n                            position.left += myOffset + atOffset + offset;\n                        }\n                    }\n                },\n                top: function( position, data ) {\n                    var within = data.within,\n                        withinOffset = within.offset.top + within.scrollTop,\n                        outerHeight = within.height,\n                        offsetTop = within.isWindow ? within.scrollTop : within.offset.top,\n                        collisionPosTop = position.top - data.collisionPosition.marginTop,\n                        overTop = collisionPosTop - offsetTop,\n                        overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,\n                        top = data.my[ 1 ] === \"top\",\n                        myOffset = top ?\n                            -data.elemHeight :\n                            data.my[ 1 ] === \"bottom\" ?\n                                data.elemHeight :\n                                0,\n                        atOffset = data.at[ 1 ] === \"top\" ?\n                            data.targetHeight :\n                            data.at[ 1 ] === \"bottom\" ?\n                                -data.targetHeight :\n                                0,\n                        offset = -2 * data.offset[ 1 ],\n                        newOverTop,\n                        newOverBottom;\n                    if ( overTop < 0 ) {\n                        newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight -\n                            outerHeight - withinOffset;\n                        if ( newOverBottom < 0 || newOverBottom < abs( overTop ) ) {\n                            position.top += myOffset + atOffset + offset;\n                        }\n                    } else if ( overBottom > 0 ) {\n                        newOverTop = position.top - data.collisionPosition.marginTop + myOffset + atOffset +\n                            offset - offsetTop;\n                        if ( newOverTop > 0 || abs( newOverTop ) < overBottom ) {\n                            position.top += myOffset + atOffset + offset;\n                        }\n                    }\n                }\n            },\n            flipfit: {\n                left: function() {\n                    $.ui.position.flip.left.apply( this, arguments );\n                    $.ui.position.fit.left.apply( this, arguments );\n                },\n                top: function() {\n                    $.ui.position.flip.top.apply( this, arguments );\n                    $.ui.position.fit.top.apply( this, arguments );\n                }\n            }\n        };\n\n    } )();\n\n    return $.ui.position;\n\n} );\n","jquery/ui-modules/i18n/datepicker-id.js":"/* Indonesian initialisation for the jQuery UI date picker plugin. */\n/* Written by Deden Fathurahman (dedenf@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.id = {\n\tcloseText: \"Tutup\",\n\tprevText: \"&#x3C;mundur\",\n\tnextText: \"maju&#x3E;\",\n\tcurrentText: \"hari ini\",\n\tmonthNames: [ \"Januari\", \"Februari\", \"Maret\", \"April\", \"Mei\", \"Juni\",\n\t\"Juli\", \"Agustus\", \"September\", \"Oktober\", \"Nopember\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Agus\", \"Sep\", \"Okt\", \"Nop\", \"Des\" ],\n\tdayNames: [ \"Minggu\", \"Senin\", \"Selasa\", \"Rabu\", \"Kamis\", \"Jumat\", \"Sabtu\" ],\n\tdayNamesShort: [ \"Min\", \"Sen\", \"Sel\", \"Rab\", \"kam\", \"Jum\", \"Sab\" ],\n\tdayNamesMin: [ \"Mg\", \"Sn\", \"Sl\", \"Rb\", \"Km\", \"jm\", \"Sb\" ],\n\tweekHeader: \"Mg\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.id );\n\nreturn datepicker.regional.id;\n\n} );\n","jquery/ui-modules/i18n/datepicker-az.js":"/* Azerbaijani (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Jamil Najafov (necefov33@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.az = {\n\tcloseText: \"Ba\u011fla\",\n\tprevText: \"&#x3C;Geri\",\n\tnextText: \"\u0130r\u0259li&#x3E;\",\n\tcurrentText: \"Bug\u00fcn\",\n\tmonthNames: [ \"Yanvar\", \"Fevral\", \"Mart\", \"Aprel\", \"May\", \"\u0130yun\",\n\t\"\u0130yul\", \"Avqust\", \"Sentyabr\", \"Oktyabr\", \"Noyabr\", \"Dekabr\" ],\n\tmonthNamesShort: [ \"Yan\", \"Fev\", \"Mar\", \"Apr\", \"May\", \"\u0130yun\",\n\t\"\u0130yul\", \"Avq\", \"Sen\", \"Okt\", \"Noy\", \"Dek\" ],\n\tdayNames: [ \"Bazar\", \"Bazar ert\u0259si\", \"\u00c7\u0259r\u015f\u0259nb\u0259 ax\u015fam\u0131\", \"\u00c7\u0259r\u015f\u0259nb\u0259\", \"C\u00fcm\u0259 ax\u015fam\u0131\", \"C\u00fcm\u0259\", \"\u015e\u0259nb\u0259\" ],\n\tdayNamesShort: [ \"B\", \"Be\", \"\u00c7a\", \"\u00c7\", \"Ca\", \"C\", \"\u015e\" ],\n\tdayNamesMin: [ \"B\", \"B\", \"\u00c7\", \"\u0421\", \"\u00c7\", \"C\", \"\u015e\" ],\n\tweekHeader: \"Hf\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.az );\n\nreturn datepicker.regional.az;\n\n} );\n","jquery/ui-modules/i18n/datepicker-zh-CN.js":"/* Chinese initialisation for the jQuery UI date picker plugin. */\n/* Written by Cloudream (cloudream@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"zh-CN\" ] = {\n\tcloseText: \"\u5173\u95ed\",\n\tprevText: \"&#x3C;\u4e0a\u6708\",\n\tnextText: \"\u4e0b\u6708&#x3E;\",\n\tcurrentText: \"\u4eca\u5929\",\n\tmonthNames: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tmonthNamesShort: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tdayNames: [ \"\u661f\u671f\u65e5\", \"\u661f\u671f\u4e00\", \"\u661f\u671f\u4e8c\", \"\u661f\u671f\u4e09\", \"\u661f\u671f\u56db\", \"\u661f\u671f\u4e94\", \"\u661f\u671f\u516d\" ],\n\tdayNamesShort: [ \"\u5468\u65e5\", \"\u5468\u4e00\", \"\u5468\u4e8c\", \"\u5468\u4e09\", \"\u5468\u56db\", \"\u5468\u4e94\", \"\u5468\u516d\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u4e00\", \"\u4e8c\", \"\u4e09\", \"\u56db\", \"\u4e94\", \"\u516d\" ],\n\tweekHeader: \"\u5468\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional[ \"zh-CN\" ] );\n\nreturn datepicker.regional[ \"zh-CN\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-en-AU.js":"/* English/Australia initialisation for the jQuery UI date picker plugin. */\n/* Based on the en-GB initialisation. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"en-AU\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ],\n\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ],\n\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"en-AU\" ] );\n\nreturn datepicker.regional[ \"en-AU\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-af.js":"/* Afrikaans initialisation for the jQuery UI date picker plugin. */\n/* Written by Renier Pretorius. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.af = {\n\tcloseText: \"Selekteer\",\n\tprevText: \"Vorige\",\n\tnextText: \"Volgende\",\n\tcurrentText: \"Vandag\",\n\tmonthNames: [ \"Januarie\", \"Februarie\", \"Maart\", \"April\", \"Mei\", \"Junie\",\n\t\"Julie\", \"Augustus\", \"September\", \"Oktober\", \"November\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mrt\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Des\" ],\n\tdayNames: [ \"Sondag\", \"Maandag\", \"Dinsdag\", \"Woensdag\", \"Donderdag\", \"Vrydag\", \"Saterdag\" ],\n\tdayNamesShort: [ \"Son\", \"Maa\", \"Din\", \"Woe\", \"Don\", \"Vry\", \"Sat\" ],\n\tdayNamesMin: [ \"So\", \"Ma\", \"Di\", \"Wo\", \"Do\", \"Vr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.af );\n\nreturn datepicker.regional.af;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hy.js":"/* Armenian(UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Levon Zakaryan (levon.zakaryan@gmail.com)*/\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hy = {\n\tcloseText: \"\u0553\u0561\u056f\u0565\u056c\",\n\tprevText: \"&#x3C;\u0546\u0561\u056d.\",\n\tnextText: \"\u0540\u0561\u057b.&#x3E;\",\n\tcurrentText: \"\u0531\u0575\u057d\u0585\u0580\",\n\tmonthNames: [ \"\u0540\u0578\u0582\u0576\u057e\u0561\u0580\", \"\u0553\u0565\u057f\u0580\u057e\u0561\u0580\", \"\u0544\u0561\u0580\u057f\", \"\u0531\u057a\u0580\u056b\u056c\", \"\u0544\u0561\u0575\u056b\u057d\", \"\u0540\u0578\u0582\u0576\u056b\u057d\",\n\t\"\u0540\u0578\u0582\u056c\u056b\u057d\", \"\u0555\u0563\u0578\u057d\u057f\u0578\u057d\", \"\u054d\u0565\u057a\u057f\u0565\u0574\u0562\u0565\u0580\", \"\u0540\u0578\u056f\u057f\u0565\u0574\u0562\u0565\u0580\", \"\u0546\u0578\u0575\u0565\u0574\u0562\u0565\u0580\", \"\u0534\u0565\u056f\u057f\u0565\u0574\u0562\u0565\u0580\" ],\n\tmonthNamesShort: [ \"\u0540\u0578\u0582\u0576\u057e\", \"\u0553\u0565\u057f\u0580\", \"\u0544\u0561\u0580\u057f\", \"\u0531\u057a\u0580\", \"\u0544\u0561\u0575\u056b\u057d\", \"\u0540\u0578\u0582\u0576\u056b\u057d\",\n\t\"\u0540\u0578\u0582\u056c\", \"\u0555\u0563\u057d\", \"\u054d\u0565\u057a\", \"\u0540\u0578\u056f\", \"\u0546\u0578\u0575\", \"\u0534\u0565\u056f\" ],\n\tdayNames: [ \"\u056f\u056b\u0580\u0561\u056f\u056b\", \"\u0565\u056f\u0578\u0582\u0577\u0561\u0562\u0569\u056b\", \"\u0565\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b\", \"\u0579\u0578\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b\", \"\u0570\u056b\u0576\u0563\u0577\u0561\u0562\u0569\u056b\", \"\u0578\u0582\u0580\u0562\u0561\u0569\", \"\u0577\u0561\u0562\u0561\u0569\" ],\n\tdayNamesShort: [ \"\u056f\u056b\u0580\", \"\u0565\u0580\u056f\", \"\u0565\u0580\u0584\", \"\u0579\u0580\u0584\", \"\u0570\u0576\u0563\", \"\u0578\u0582\u0580\u0562\", \"\u0577\u0562\u0569\" ],\n\tdayNamesMin: [ \"\u056f\u056b\u0580\", \"\u0565\u0580\u056f\", \"\u0565\u0580\u0584\", \"\u0579\u0580\u0584\", \"\u0570\u0576\u0563\", \"\u0578\u0582\u0580\u0562\", \"\u0577\u0562\u0569\" ],\n\tweekHeader: \"\u0547\u0532\u054f\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hy );\n\nreturn datepicker.regional.hy;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ky.js":"/* Kyrgyz (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Sergey Kartashov (ebishkek@yandex.ru). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ky = {\n\tcloseText: \"\u0416\u0430\u0431\u0443\u0443\",\n\tprevText: \"&#x3c;\u041c\u0443\u0440\",\n\tnextText: \"\u041a\u0438\u0439&#x3e;\",\n\tcurrentText: \"\u0411\u04af\u0433\u04af\u043d\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\u044c\", \"\u0424\u0435\u0432\u0440\u0430\u043b\u044c\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\u044c\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\u044c\",\n\t\"\u0418\u044e\u043b\u044c\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c\", \"\u041e\u043a\u0442\u044f\u0431\u0440\u044c\", \"\u041d\u043e\u044f\u0431\u0440\u044c\", \"\u0414\u0435\u043a\u0430\u0431\u0440\u044c\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u0436\u0435\u043a\u0448\u0435\u043c\u0431\u0438\", \"\u0434\u04af\u0439\u0448\u04e9\u043c\u0431\u04af\", \"\u0448\u0435\u0439\u0448\u0435\u043c\u0431\u0438\", \"\u0448\u0430\u0440\u0448\u0435\u043c\u0431\u0438\", \"\u0431\u0435\u0439\u0448\u0435\u043c\u0431\u0438\", \"\u0436\u0443\u043c\u0430\", \"\u0438\u0448\u0435\u043c\u0431\u0438\" ],\n\tdayNamesShort: [ \"\u0436\u0435\u043a\", \"\u0434\u04af\u0439\", \"\u0448\u0435\u0439\", \"\u0448\u0430\u0440\", \"\u0431\u0435\u0439\", \"\u0436\u0443\u043c\", \"\u0438\u0448\u0435\" ],\n\tdayNamesMin: [ \"\u0416\u043a\", \"\u0414\u0448\", \"\u0428\u0448\", \"\u0428\u0440\", \"\u0411\u0448\", \"\u0416\u043c\", \"\u0418\u0448\" ],\n\tweekHeader: \"\u0416\u0443\u043c\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.ky );\n\nreturn datepicker.regional.ky;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ja.js":"/* Japanese initialisation for the jQuery UI date picker plugin. */\n/* Written by Kentaro SATO (kentaro@ranvis.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ja = {\n\tcloseText: \"\u9589\u3058\u308b\",\n\tprevText: \"&#x3C;\u524d\",\n\tnextText: \"\u6b21&#x3E;\",\n\tcurrentText: \"\u4eca\u65e5\",\n\tmonthNames: [ \"1\u6708\", \"2\u6708\", \"3\u6708\", \"4\u6708\", \"5\u6708\", \"6\u6708\",\n\t\"7\u6708\", \"8\u6708\", \"9\u6708\", \"10\u6708\", \"11\u6708\", \"12\u6708\" ],\n\tmonthNamesShort: [ \"1\u6708\", \"2\u6708\", \"3\u6708\", \"4\u6708\", \"5\u6708\", \"6\u6708\",\n\t\"7\u6708\", \"8\u6708\", \"9\u6708\", \"10\u6708\", \"11\u6708\", \"12\u6708\" ],\n\tdayNames: [ \"\u65e5\u66dc\u65e5\", \"\u6708\u66dc\u65e5\", \"\u706b\u66dc\u65e5\", \"\u6c34\u66dc\u65e5\", \"\u6728\u66dc\u65e5\", \"\u91d1\u66dc\u65e5\", \"\u571f\u66dc\u65e5\" ],\n\tdayNamesShort: [ \"\u65e5\", \"\u6708\", \"\u706b\", \"\u6c34\", \"\u6728\", \"\u91d1\", \"\u571f\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u6708\", \"\u706b\", \"\u6c34\", \"\u6728\", \"\u91d1\", \"\u571f\" ],\n\tweekHeader: \"\u9031\",\n\tdateFormat: \"yy/mm/dd\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional.ja );\n\nreturn datepicker.regional.ja;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ka.js":"/* Georgian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Lado Lomidze (lado.lomidze@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ka = {\n\tcloseText: \"\u10d3\u10d0\u10ee\u10e3\u10e0\u10d5\u10d0\",\n\tprevText: \"&#x3c; \u10ec\u10d8\u10dc\u10d0\",\n\tnextText: \"\u10e8\u10d4\u10db\u10d3\u10d4\u10d2\u10d8 &#x3e;\",\n\tcurrentText: \"\u10d3\u10e6\u10d4\u10e1\",\n\tmonthNames: [\n\t\t\"\u10d8\u10d0\u10dc\u10d5\u10d0\u10e0\u10d8\",\n\t\t\"\u10d7\u10d4\u10d1\u10d4\u10e0\u10d5\u10d0\u10da\u10d8\",\n\t\t\"\u10db\u10d0\u10e0\u10e2\u10d8\",\n\t\t\"\u10d0\u10de\u10e0\u10d8\u10da\u10d8\",\n\t\t\"\u10db\u10d0\u10d8\u10e1\u10d8\",\n\t\t\"\u10d8\u10d5\u10dc\u10d8\u10e1\u10d8\",\n\t\t\"\u10d8\u10d5\u10da\u10d8\u10e1\u10d8\",\n\t\t\"\u10d0\u10d2\u10d5\u10d8\u10e1\u10e2\u10dd\",\n\t\t\"\u10e1\u10d4\u10e5\u10e2\u10d4\u10db\u10d1\u10d4\u10e0\u10d8\",\n\t\t\"\u10dd\u10e5\u10e2\u10dd\u10db\u10d1\u10d4\u10e0\u10d8\",\n\t\t\"\u10dc\u10dd\u10d4\u10db\u10d1\u10d4\u10e0\u10d8\",\n\t\t\"\u10d3\u10d4\u10d9\u10d4\u10db\u10d1\u10d4\u10e0\u10d8\"\n\t],\n\tmonthNamesShort: [ \"\u10d8\u10d0\u10dc\", \"\u10d7\u10d4\u10d1\", \"\u10db\u10d0\u10e0\", \"\u10d0\u10de\u10e0\", \"\u10db\u10d0\u10d8\", \"\u10d8\u10d5\u10dc\", \"\u10d8\u10d5\u10da\", \"\u10d0\u10d2\u10d5\", \"\u10e1\u10d4\u10e5\", \"\u10dd\u10e5\u10e2\", \"\u10dc\u10dd\u10d4\", \"\u10d3\u10d4\u10d9\" ],\n\tdayNames: [ \"\u10d9\u10d5\u10d8\u10e0\u10d0\", \"\u10dd\u10e0\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10e1\u10d0\u10db\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10dd\u10d7\u10ee\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10ee\u10e3\u10d7\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10de\u10d0\u10e0\u10d0\u10e1\u10d9\u10d4\u10d5\u10d8\", \"\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\" ],\n\tdayNamesShort: [ \"\u10d9\u10d5\", \"\u10dd\u10e0\u10e8\", \"\u10e1\u10d0\u10db\", \"\u10dd\u10d7\u10ee\", \"\u10ee\u10e3\u10d7\", \"\u10de\u10d0\u10e0\", \"\u10e8\u10d0\u10d1\" ],\n\tdayNamesMin: [ \"\u10d9\u10d5\", \"\u10dd\u10e0\u10e8\", \"\u10e1\u10d0\u10db\", \"\u10dd\u10d7\u10ee\", \"\u10ee\u10e3\u10d7\", \"\u10de\u10d0\u10e0\", \"\u10e8\u10d0\u10d1\" ],\n\tweekHeader: \"\u10d9\u10d5\u10d8\u10e0\u10d0\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ka );\n\nreturn datepicker.regional.ka;\n\n} );\n","jquery/ui-modules/i18n/datepicker-zh-TW.js":"/* Chinese initialisation for the jQuery UI date picker plugin. */\n/* Written by Ressol (ressol@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"zh-TW\" ] = {\n\tcloseText: \"\u95dc\u9589\",\n\tprevText: \"&#x3C;\u4e0a\u500b\u6708\",\n\tnextText: \"\u4e0b\u500b\u6708&#x3E;\",\n\tcurrentText: \"\u4eca\u5929\",\n\tmonthNames: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tmonthNamesShort: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tdayNames: [ \"\u661f\u671f\u65e5\", \"\u661f\u671f\u4e00\", \"\u661f\u671f\u4e8c\", \"\u661f\u671f\u4e09\", \"\u661f\u671f\u56db\", \"\u661f\u671f\u4e94\", \"\u661f\u671f\u516d\" ],\n\tdayNamesShort: [ \"\u9031\u65e5\", \"\u9031\u4e00\", \"\u9031\u4e8c\", \"\u9031\u4e09\", \"\u9031\u56db\", \"\u9031\u4e94\", \"\u9031\u516d\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u4e00\", \"\u4e8c\", \"\u4e09\", \"\u56db\", \"\u4e94\", \"\u516d\" ],\n\tweekHeader: \"\u9031\",\n\tdateFormat: \"yy/mm/dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional[ \"zh-TW\" ] );\n\nreturn datepicker.regional[ \"zh-TW\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-pt-BR.js":"/* Brazilian initialisation for the jQuery UI date picker plugin. */\n/* Written by Leonildo Costa Silva (leocsilva@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"pt-BR\" ] = {\n\tcloseText: \"Fechar\",\n\tprevText: \"&#x3C;Anterior\",\n\tnextText: \"Pr\u00f3ximo&#x3E;\",\n\tcurrentText: \"Hoje\",\n\tmonthNames: [ \"Janeiro\", \"Fevereiro\", \"Mar\u00e7o\", \"Abril\", \"Maio\", \"Junho\",\n\t\"Julho\", \"Agosto\", \"Setembro\", \"Outubro\", \"Novembro\", \"Dezembro\" ],\n\tmonthNamesShort: [ \"Jan\", \"Fev\", \"Mar\", \"Abr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Ago\", \"Set\", \"Out\", \"Nov\", \"Dez\" ],\n\tdayNames: [\n\t\t\"Domingo\",\n\t\t\"Segunda-feira\",\n\t\t\"Ter\u00e7a-feira\",\n\t\t\"Quarta-feira\",\n\t\t\"Quinta-feira\",\n\t\t\"Sexta-feira\",\n\t\t\"S\u00e1bado\"\n\t],\n\tdayNamesShort: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tdayNamesMin: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"pt-BR\" ] );\n\nreturn datepicker.regional[ \"pt-BR\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-he.js":"/* Hebrew initialisation for the UI Datepicker extension. */\n/* Written by Amir Hardon (ahardon at gmail dot com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.he = {\n\tcloseText: \"\u05e1\u05d2\u05d5\u05e8\",\n\tprevText: \"&#x3C;\u05d4\u05e7\u05d5\u05d3\u05dd\",\n\tnextText: \"\u05d4\u05d1\u05d0&#x3E;\",\n\tcurrentText: \"\u05d4\u05d9\u05d5\u05dd\",\n\tmonthNames: [ \"\u05d9\u05e0\u05d5\u05d0\u05e8\", \"\u05e4\u05d1\u05e8\u05d5\u05d0\u05e8\", \"\u05de\u05e8\u05e5\", \"\u05d0\u05e4\u05e8\u05d9\u05dc\", \"\u05de\u05d0\u05d9\", \"\u05d9\u05d5\u05e0\u05d9\",\n\t\"\u05d9\u05d5\u05dc\u05d9\", \"\u05d0\u05d5\u05d2\u05d5\u05e1\u05d8\", \"\u05e1\u05e4\u05d8\u05de\u05d1\u05e8\", \"\u05d0\u05d5\u05e7\u05d8\u05d5\u05d1\u05e8\", \"\u05e0\u05d5\u05d1\u05de\u05d1\u05e8\", \"\u05d3\u05e6\u05de\u05d1\u05e8\" ],\n\tmonthNamesShort: [ \"\u05d9\u05e0\u05d5\", \"\u05e4\u05d1\u05e8\", \"\u05de\u05e8\u05e5\", \"\u05d0\u05e4\u05e8\", \"\u05de\u05d0\u05d9\", \"\u05d9\u05d5\u05e0\u05d9\",\n\t\"\u05d9\u05d5\u05dc\u05d9\", \"\u05d0\u05d5\u05d2\", \"\u05e1\u05e4\u05d8\", \"\u05d0\u05d5\u05e7\", \"\u05e0\u05d5\u05d1\", \"\u05d3\u05e6\u05de\" ],\n\tdayNames: [ \"\u05e8\u05d0\u05e9\u05d5\u05df\", \"\u05e9\u05e0\u05d9\", \"\u05e9\u05dc\u05d9\u05e9\u05d9\", \"\u05e8\u05d1\u05d9\u05e2\u05d9\", \"\u05d7\u05de\u05d9\u05e9\u05d9\", \"\u05e9\u05d9\u05e9\u05d9\", \"\u05e9\u05d1\u05ea\" ],\n\tdayNamesShort: [ \"\u05d0'\", \"\u05d1'\", \"\u05d2'\", \"\u05d3'\", \"\u05d4'\", \"\u05d5'\", \"\u05e9\u05d1\u05ea\" ],\n\tdayNamesMin: [ \"\u05d0'\", \"\u05d1'\", \"\u05d2'\", \"\u05d3'\", \"\u05d4'\", \"\u05d5'\", \"\u05e9\u05d1\u05ea\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.he );\n\nreturn datepicker.regional.he;\n\n} );\n","jquery/ui-modules/i18n/datepicker-de-AT.js":"/* German/Austrian initialisation for the jQuery UI date picker plugin. */\n/* Based on the de initialisation. */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"de-AT\" ] = {\n\tcloseText: \"Schlie\u00dfen\",\n\tprevText: \"&#x3C;Zur\u00fcck\",\n\tnextText: \"Vor&#x3E;\",\n\tcurrentText: \"Heute\",\n\tmonthNames: [ \"J\u00e4nner\", \"Februar\", \"M\u00e4rz\", \"April\", \"Mai\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Dezember\" ],\n\tmonthNamesShort: [ \"J\u00e4n\", \"Feb\", \"M\u00e4r\", \"Apr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dez\" ],\n\tdayNames: [ \"Sonntag\", \"Montag\", \"Dienstag\", \"Mittwoch\", \"Donnerstag\", \"Freitag\", \"Samstag\" ],\n\tdayNamesShort: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tdayNamesMin: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"KW\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"de-AT\" ] );\n\nreturn datepicker.regional[ \"de-AT\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-bg.js":"/* Bulgarian initialisation for the jQuery UI date picker plugin. */\n/* Written by Stoyan Kyosev (http://svest.org). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.bg = {\n\tcloseText: \"\u0437\u0430\u0442\u0432\u043e\u0440\u0438\",\n\tprevText: \"&#x3C;\u043d\u0430\u0437\u0430\u0434\",\n\tnextText: \"\u043d\u0430\u043f\u0440\u0435\u0434&#x3E;\",\n\tnextBigText: \"&#x3E;&#x3E;\",\n\tcurrentText: \"\u0434\u043d\u0435\u0441\",\n\tmonthNames: [ \"\u042f\u043d\u0443\u0430\u0440\u0438\", \"\u0424\u0435\u0432\u0440\u0443\u0430\u0440\u0438\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0438\u043b\", \"\u041c\u0430\u0439\", \"\u042e\u043d\u0438\",\n\t\"\u042e\u043b\u0438\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043f\u0442\u0435\u043c\u0432\u0440\u0438\", \"\u041e\u043a\u0442\u043e\u043c\u0432\u0440\u0438\", \"\u041d\u043e\u0435\u043c\u0432\u0440\u0438\", \"\u0414\u0435\u043a\u0435\u043c\u0432\u0440\u0438\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0443\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u042e\u043d\u0438\",\n\t\"\u042e\u043b\u0438\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043f\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u0432\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u041d\u0435\u0434\u0435\u043b\u044f\", \"\u041f\u043e\u043d\u0435\u0434\u0435\u043b\u043d\u0438\u043a\", \"\u0412\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0421\u0440\u044f\u0434\u0430\", \"\u0427\u0435\u0442\u0432\u044a\u0440\u0442\u044a\u043a\", \"\u041f\u0435\u0442\u044a\u043a\", \"\u0421\u044a\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u041d\u0435\u0434\", \"\u041f\u043e\u043d\", \"\u0412\u0442\u043e\", \"\u0421\u0440\u044f\", \"\u0427\u0435\u0442\", \"\u041f\u0435\u0442\", \"\u0421\u044a\u0431\" ],\n\tdayNamesMin: [ \"\u041d\u0435\", \"\u041f\u043e\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0435\", \"\u041f\u0435\", \"\u0421\u044a\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.bg );\n\nreturn datepicker.regional.bg;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sq.js":"/* Albanian initialisation for the jQuery UI date picker plugin. */\n/* Written by Flakron Bytyqi (flakron@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sq = {\n\tcloseText: \"mbylle\",\n\tprevText: \"&#x3C;mbrapa\",\n\tnextText: \"P\u00ebrpara&#x3E;\",\n\tcurrentText: \"sot\",\n\tmonthNames: [ \"Janar\", \"Shkurt\", \"Mars\", \"Prill\", \"Maj\", \"Qershor\",\n\t\"Korrik\", \"Gusht\", \"Shtator\", \"Tetor\", \"N\u00ebntor\", \"Dhjetor\" ],\n\tmonthNamesShort: [ \"Jan\", \"Shk\", \"Mar\", \"Pri\", \"Maj\", \"Qer\",\n\t\"Kor\", \"Gus\", \"Sht\", \"Tet\", \"N\u00ebn\", \"Dhj\" ],\n\tdayNames: [ \"E Diel\", \"E H\u00ebn\u00eb\", \"E Mart\u00eb\", \"E M\u00ebrkur\u00eb\", \"E Enjte\", \"E Premte\", \"E Shtune\" ],\n\tdayNamesShort: [ \"Di\", \"H\u00eb\", \"Ma\", \"M\u00eb\", \"En\", \"Pr\", \"Sh\" ],\n\tdayNamesMin: [ \"Di\", \"H\u00eb\", \"Ma\", \"M\u00eb\", \"En\", \"Pr\", \"Sh\" ],\n\tweekHeader: \"Ja\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sq );\n\nreturn datepicker.regional.sq;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nl-BE.js":"/* Dutch (Belgium) initialisation for the jQuery UI date picker plugin. */\n/* David De Sloovere @DavidDeSloovere */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"nl-BE\" ] = {\n\tcloseText: \"Sluiten\",\n\tprevText: \"\u2190\",\n\tnextText: \"\u2192\",\n\tcurrentText: \"Vandaag\",\n\tmonthNames: [ \"januari\", \"februari\", \"maart\", \"april\", \"mei\", \"juni\",\n\t\"juli\", \"augustus\", \"september\", \"oktober\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mrt\", \"apr\", \"mei\", \"jun\",\n\t\"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"dec\" ],\n\tdayNames: [ \"zondag\", \"maandag\", \"dinsdag\", \"woensdag\", \"donderdag\", \"vrijdag\", \"zaterdag\" ],\n\tdayNamesShort: [ \"zon\", \"maa\", \"din\", \"woe\", \"don\", \"vri\", \"zat\" ],\n\tdayNamesMin: [ \"zo\", \"ma\", \"di\", \"wo\", \"do\", \"vr\", \"za\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"nl-BE\" ] );\n\nreturn datepicker.regional[ \"nl-BE\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-ar-DZ.js":"/* Algerian Arabic Translation for jQuery UI date picker plugin.\n/* Used in most of Maghreb countries, primarily in Algeria, Tunisia, Morocco.\n/* Mohamed Cherif BOUCHELAGHEM -- cherifbouchelaghem@yahoo.fr */\n/* Mohamed Amine HADDAD -- zatamine@gmail.com */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"ar-DZ\" ] = {\n\tcloseText: \"\u0625\u063a\u0644\u0627\u0642\",\n\tprevText: \"&#x3C;\u0627\u0644\u0633\u0627\u0628\u0642\",\n\tnextText: \"\u0627\u0644\u062a\u0627\u0644\u064a&#x3E;\",\n\tcurrentText: \"\u0627\u0644\u064a\u0648\u0645\",\n\tmonthNames: [ \"\u062c\u0627\u0646\u0641\u064a\", \"\u0641\u064a\u0641\u0631\u064a\", \"\u0645\u0627\u0631\u0633\", \"\u0623\u0641\u0631\u064a\u0644\", \"\u0645\u0627\u064a\", \"\u062c\u0648\u0627\u0646\",\n\t\"\u062c\u0648\u064a\u0644\u064a\u0629\", \"\u0623\u0648\u062a\", \"\u0633\u0628\u062a\u0645\u0628\u0631\", \"\u0623\u0643\u062a\u0648\u0628\u0631\", \"\u0646\u0648\u0641\u0645\u0628\u0631\", \"\u062f\u064a\u0633\u0645\u0628\u0631\" ],\n\tmonthNamesShort: [ \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"10\", \"11\", \"12\" ],\n\tdayNames: [ \"\u0627\u0644\u0623\u062d\u062f\", \"\u0627\u0644\u0627\u062b\u0646\u064a\u0646\", \"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u0627\u0644\u062e\u0645\u064a\u0633\", \"\u0627\u0644\u062c\u0645\u0639\u0629\", \"\u0627\u0644\u0633\u0628\u062a\" ],\n\tdayNamesShort: [ \"\u0627\u0644\u0623\u062d\u062f\", \"\u0627\u0644\u0627\u062b\u0646\u064a\u0646\", \"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u0627\u0644\u062e\u0645\u064a\u0633\", \"\u0627\u0644\u062c\u0645\u0639\u0629\", \"\u0627\u0644\u0633\u0628\u062a\" ],\n\tdayNamesMin: [ \"\u062d\", \"\u0646\", \"\u062b\", \"\u0631\", \"\u062e\", \"\u062c\", \"\u0633\" ],\n\tweekHeader: \"\u0623\u0633\u0628\u0648\u0639\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 6,\n\t\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"ar-DZ\" ] );\n\nreturn datepicker.regional[ \"ar-DZ\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr-CA.js":"/* Canadian-French initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"fr-CA\" ] = {\n\tcloseText: \"Fermer\",\n\tprevText: \"Pr\u00e9c\u00e9dent\",\n\tnextText: \"Suivant\",\n\tcurrentText: \"Aujourd'hui\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sem.\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional[ \"fr-CA\" ] );\n\nreturn datepicker.regional[ \"fr-CA\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-en-GB.js":"/* English/UK initialisation for the jQuery UI date picker plugin. */\n/* Written by Stuart. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"en-GB\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ],\n\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ],\n\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"en-GB\" ] );\n\nreturn datepicker.regional[ \"en-GB\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-rm.js":"/* Romansh initialisation for the jQuery UI date picker plugin. */\n/* Written by Yvonne Gienal (yvonne.gienal@educa.ch). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.rm = {\n\tcloseText: \"Serrar\",\n\tprevText: \"&#x3C;Suandant\",\n\tnextText: \"Precedent&#x3E;\",\n\tcurrentText: \"Actual\",\n\tmonthNames: [\n\t\t\"Schaner\",\n\t\t\"Favrer\",\n\t\t\"Mars\",\n\t\t\"Avrigl\",\n\t\t\"Matg\",\n\t\t\"Zercladur\",\n\t\t\"Fanadur\",\n\t\t\"Avust\",\n\t\t\"Settember\",\n\t\t\"October\",\n\t\t\"November\",\n\t\t\"December\"\n\t],\n\tmonthNamesShort: [\n\t\t\"Scha\",\n\t\t\"Fev\",\n\t\t\"Mar\",\n\t\t\"Avr\",\n\t\t\"Matg\",\n\t\t\"Zer\",\n\t\t\"Fan\",\n\t\t\"Avu\",\n\t\t\"Sett\",\n\t\t\"Oct\",\n\t\t\"Nov\",\n\t\t\"Dec\"\n\t],\n\tdayNames: [ \"Dumengia\", \"Glindesdi\", \"Mardi\", \"Mesemna\", \"Gievgia\", \"Venderdi\", \"Sonda\" ],\n\tdayNamesShort: [ \"Dum\", \"Gli\", \"Mar\", \"Mes\", \"Gie\", \"Ven\", \"Som\" ],\n\tdayNamesMin: [ \"Du\", \"Gl\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"So\" ],\n\tweekHeader: \"emna\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.rm );\n\nreturn datepicker.regional.rm;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hr.js":"/* Croatian i18n for the jQuery UI date picker plugin. */\n/* Written by Vjekoslav Nesek. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hr = {\n\tcloseText: \"Zatvori\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"Danas\",\n\tmonthNames: [ \"Sije\u010danj\", \"Velja\u010da\", \"O\u017eujak\", \"Travanj\", \"Svibanj\", \"Lipanj\",\n\t\"Srpanj\", \"Kolovoz\", \"Rujan\", \"Listopad\", \"Studeni\", \"Prosinac\" ],\n\tmonthNamesShort: [ \"Sij\", \"Velj\", \"O\u017eu\", \"Tra\", \"Svi\", \"Lip\",\n\t\"Srp\", \"Kol\", \"Ruj\", \"Lis\", \"Stu\", \"Pro\" ],\n\tdayNames: [ \"Nedjelja\", \"Ponedjeljak\", \"Utorak\", \"Srijeda\", \"\u010cetvrtak\", \"Petak\", \"Subota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Sri\", \"\u010cet\", \"Pet\", \"Sub\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"Sr\", \"\u010ce\", \"Pe\", \"Su\" ],\n\tweekHeader: \"Tje\",\n\tdateFormat: \"dd.mm.yy.\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hr );\n\nreturn datepicker.regional.hr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ms.js":"/* Malaysian initialisation for the jQuery UI date picker plugin. */\n/* Written by Mohd Nawawi Mohamad Jamili (nawawi@ronggeng.net). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ms = {\n\tcloseText: \"Tutup\",\n\tprevText: \"&#x3C;Sebelum\",\n\tnextText: \"Selepas&#x3E;\",\n\tcurrentText: \"hari ini\",\n\tmonthNames: [ \"Januari\", \"Februari\", \"Mac\", \"April\", \"Mei\", \"Jun\",\n\t\"Julai\", \"Ogos\", \"September\", \"Oktober\", \"November\", \"Disember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mac\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Ogo\", \"Sep\", \"Okt\", \"Nov\", \"Dis\" ],\n\tdayNames: [ \"Ahad\", \"Isnin\", \"Selasa\", \"Rabu\", \"Khamis\", \"Jumaat\", \"Sabtu\" ],\n\tdayNamesShort: [ \"Aha\", \"Isn\", \"Sel\", \"Rab\", \"kha\", \"Jum\", \"Sab\" ],\n\tdayNamesMin: [ \"Ah\", \"Is\", \"Se\", \"Ra\", \"Kh\", \"Ju\", \"Sa\" ],\n\tweekHeader: \"Mg\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ms );\n\nreturn datepicker.regional.ms;\n\n} );\n","jquery/ui-modules/i18n/datepicker-th.js":"/* Thai initialisation for the jQuery UI date picker plugin. */\n/* Written by pipo (pipo@sixhead.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.th = {\n\tcloseText: \"\u0e1b\u0e34\u0e14\",\n\tprevText: \"&#xAB;&#xA0;\u0e22\u0e49\u0e2d\u0e19\",\n\tnextText: \"\u0e16\u0e31\u0e14\u0e44\u0e1b&#xA0;&#xBB;\",\n\tcurrentText: \"\u0e27\u0e31\u0e19\u0e19\u0e35\u0e49\",\n\tmonthNames: [ \"\u0e21\u0e01\u0e23\u0e32\u0e04\u0e21\", \"\u0e01\u0e38\u0e21\u0e20\u0e32\u0e1e\u0e31\u0e19\u0e18\u0e4c\", \"\u0e21\u0e35\u0e19\u0e32\u0e04\u0e21\", \"\u0e40\u0e21\u0e29\u0e32\u0e22\u0e19\", \"\u0e1e\u0e24\u0e29\u0e20\u0e32\u0e04\u0e21\", \"\u0e21\u0e34\u0e16\u0e38\u0e19\u0e32\u0e22\u0e19\",\n\t\"\u0e01\u0e23\u0e01\u0e0e\u0e32\u0e04\u0e21\", \"\u0e2a\u0e34\u0e07\u0e2b\u0e32\u0e04\u0e21\", \"\u0e01\u0e31\u0e19\u0e22\u0e32\u0e22\u0e19\", \"\u0e15\u0e38\u0e25\u0e32\u0e04\u0e21\", \"\u0e1e\u0e24\u0e28\u0e08\u0e34\u0e01\u0e32\u0e22\u0e19\", \"\u0e18\u0e31\u0e19\u0e27\u0e32\u0e04\u0e21\" ],\n\tmonthNamesShort: [ \"\u0e21.\u0e04.\", \"\u0e01.\u0e1e.\", \"\u0e21\u0e35.\u0e04.\", \"\u0e40\u0e21.\u0e22.\", \"\u0e1e.\u0e04.\", \"\u0e21\u0e34.\u0e22.\",\n\t\"\u0e01.\u0e04.\", \"\u0e2a.\u0e04.\", \"\u0e01.\u0e22.\", \"\u0e15.\u0e04.\", \"\u0e1e.\u0e22.\", \"\u0e18.\u0e04.\" ],\n\tdayNames: [ \"\u0e2d\u0e32\u0e17\u0e34\u0e15\u0e22\u0e4c\", \"\u0e08\u0e31\u0e19\u0e17\u0e23\u0e4c\", \"\u0e2d\u0e31\u0e07\u0e04\u0e32\u0e23\", \"\u0e1e\u0e38\u0e18\", \"\u0e1e\u0e24\u0e2b\u0e31\u0e2a\u0e1a\u0e14\u0e35\", \"\u0e28\u0e38\u0e01\u0e23\u0e4c\", \"\u0e40\u0e2a\u0e32\u0e23\u0e4c\" ],\n\tdayNamesShort: [ \"\u0e2d\u0e32.\", \"\u0e08.\", \"\u0e2d.\", \"\u0e1e.\", \"\u0e1e\u0e24.\", \"\u0e28.\", \"\u0e2a.\" ],\n\tdayNamesMin: [ \"\u0e2d\u0e32.\", \"\u0e08.\", \"\u0e2d.\", \"\u0e1e.\", \"\u0e1e\u0e24.\", \"\u0e28.\", \"\u0e2a.\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.th );\n\nreturn datepicker.regional.th;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fi.js":"/* Finnish initialisation for the jQuery UI date picker plugin. */\n/* Written by Harri Kilpi\u00f6 (harrikilpio@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fi = {\n\tcloseText: \"Sulje\",\n\tprevText: \"&#xAB;Edellinen\",\n\tnextText: \"Seuraava&#xBB;\",\n\tcurrentText: \"T\u00e4n\u00e4\u00e4n\",\n\tmonthNames: [ \"Tammikuu\", \"Helmikuu\", \"Maaliskuu\", \"Huhtikuu\", \"Toukokuu\", \"Kes\u00e4kuu\",\n\t\"Hein\u00e4kuu\", \"Elokuu\", \"Syyskuu\", \"Lokakuu\", \"Marraskuu\", \"Joulukuu\" ],\n\tmonthNamesShort: [ \"Tammi\", \"Helmi\", \"Maalis\", \"Huhti\", \"Touko\", \"Kes\u00e4\",\n\t\"Hein\u00e4\", \"Elo\", \"Syys\", \"Loka\", \"Marras\", \"Joulu\" ],\n\tdayNamesShort: [ \"Su\", \"Ma\", \"Ti\", \"Ke\", \"To\", \"Pe\", \"La\" ],\n\tdayNames: [ \"Sunnuntai\", \"Maanantai\", \"Tiistai\", \"Keskiviikko\", \"Torstai\", \"Perjantai\", \"Lauantai\" ],\n\tdayNamesMin: [ \"Su\", \"Ma\", \"Ti\", \"Ke\", \"To\", \"Pe\", \"La\" ],\n\tweekHeader: \"Vk\",\n\tdateFormat: \"d.m.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fi );\n\nreturn datepicker.regional.fi;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ru.js":"/* Russian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Andrew Stromnov (stromnov@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ru = {\n\tcloseText: \"\u0417\u0430\u043a\u0440\u044b\u0442\u044c\",\n\tprevText: \"&#x3C;\u041f\u0440\u0435\u0434\",\n\tnextText: \"\u0421\u043b\u0435\u0434&#x3E;\",\n\tcurrentText: \"\u0421\u0435\u0433\u043e\u0434\u043d\u044f\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\u044c\", \"\u0424\u0435\u0432\u0440\u0430\u043b\u044c\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\u044c\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\u044c\",\n\t\"\u0418\u044e\u043b\u044c\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c\", \"\u041e\u043a\u0442\u044f\u0431\u0440\u044c\", \"\u041d\u043e\u044f\u0431\u0440\u044c\", \"\u0414\u0435\u043a\u0430\u0431\u0440\u044c\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u0432\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435\", \"\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a\", \"\u0432\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0441\u0440\u0435\u0434\u0430\", \"\u0447\u0435\u0442\u0432\u0435\u0440\u0433\", \"\u043f\u044f\u0442\u043d\u0438\u0446\u0430\", \"\u0441\u0443\u0431\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u0432\u0441\u043a\", \"\u043f\u043d\u0434\", \"\u0432\u0442\u0440\", \"\u0441\u0440\u0434\", \"\u0447\u0442\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u0412\u0441\", \"\u041f\u043d\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0442\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u041d\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ru );\n\nreturn datepicker.regional.ru;\n\n} );\n","jquery/ui-modules/i18n/datepicker-eu.js":"/* Karrikas-ek itzulia (karrikas@karrikas.com) */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.eu = {\n\tcloseText: \"Egina\",\n\tprevText: \"&#x3C;Aur\",\n\tnextText: \"Hur&#x3E;\",\n\tcurrentText: \"Gaur\",\n\tmonthNames: [ \"urtarrila\", \"otsaila\", \"martxoa\", \"apirila\", \"maiatza\", \"ekaina\",\n\t\t\"uztaila\", \"abuztua\", \"iraila\", \"urria\", \"azaroa\", \"abendua\" ],\n\tmonthNamesShort: [ \"urt.\", \"ots.\", \"mar.\", \"api.\", \"mai.\", \"eka.\",\n\t\t\"uzt.\", \"abu.\", \"ira.\", \"urr.\", \"aza.\", \"abe.\" ],\n\tdayNames: [ \"igandea\", \"astelehena\", \"asteartea\", \"asteazkena\", \"osteguna\", \"ostirala\", \"larunbata\" ],\n\tdayNamesShort: [ \"ig.\", \"al.\", \"ar.\", \"az.\", \"og.\", \"ol.\", \"lr.\" ],\n\tdayNamesMin: [ \"ig\", \"al\", \"ar\", \"az\", \"og\", \"ol\", \"lr\" ],\n\tweekHeader: \"As\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.eu );\n\nreturn datepicker.regional.eu;\n\n} );\n","jquery/ui-modules/i18n/datepicker-mk.js":"/* Macedonian i18n for the jQuery UI date picker plugin. */\n/* Written by Stojce Slavkovski. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.mk = {\n\tcloseText: \"\u0417\u0430\u0442\u0432\u043e\u0440\u0438\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"\u0414\u0435\u043d\u0435\u0441\",\n\tmonthNames: [ \"\u0408\u0430\u043d\u0443\u0430\u0440\u0438\", \"\u0424\u0435\u0432\u0440\u0443\u0430\u0440\u0438\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0438\u043b\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\u0438\",\n\t\"\u0408\u0443\u043b\u0438\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043f\u0442\u0435\u043c\u0432\u0440\u0438\", \"\u041e\u043a\u0442\u043e\u043c\u0432\u0440\u0438\", \"\u041d\u043e\u0435\u043c\u0432\u0440\u0438\", \"\u0414\u0435\u043a\u0435\u043c\u0432\u0440\u0438\" ],\n\tmonthNamesShort: [ \"\u0408\u0430\u043d\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\",\n\t\"\u0408\u0443\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043f\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u0435\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u041d\u0435\u0434\u0435\u043b\u0430\", \"\u041f\u043e\u043d\u0435\u0434\u0435\u043b\u043d\u0438\u043a\", \"\u0412\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0421\u0440\u0435\u0434\u0430\", \"\u0427\u0435\u0442\u0432\u0440\u0442\u043e\u043a\", \"\u041f\u0435\u0442\u043e\u043a\", \"\u0421\u0430\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u041d\u0435\u0434\", \"\u041f\u043e\u043d\", \"\u0412\u0442\u043e\", \"\u0421\u0440\u0435\", \"\u0427\u0435\u0442\", \"\u041f\u0435\u0442\", \"\u0421\u0430\u0431\" ],\n\tdayNamesMin: [ \"\u041d\u0435\", \"\u041f\u043e\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0435\", \"\u041f\u0435\", \"\u0421\u0430\" ],\n\tweekHeader: \"\u0421\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.mk );\n\nreturn datepicker.regional.mk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-no.js":"/* Norwegian initialisation for the jQuery UI date picker plugin. */\n/* Written by Naimdjon Takhirov (naimdjon@gmail.com). */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.no = {\n\tcloseText: \"Lukk\",\n\tprevText: \"&#xAB;Forrige\",\n\tnextText: \"Neste&#xBB;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [\n\t\t\"januar\",\n\t\t\"februar\",\n\t\t\"mars\",\n\t\t\"april\",\n\t\t\"mai\",\n\t\t\"juni\",\n\t\t\"juli\",\n\t\t\"august\",\n\t\t\"september\",\n\t\t\"oktober\",\n\t\t\"november\",\n\t\t\"desember\"\n\t],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mar\", \"apr\", \"mai\", \"jun\", \"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"des\" ],\n\tdayNamesShort: [ \"s\u00f8n\", \"man\", \"tir\", \"ons\", \"tor\", \"fre\", \"l\u00f8r\" ],\n\tdayNames: [ \"s\u00f8ndag\", \"mandag\", \"tirsdag\", \"onsdag\", \"torsdag\", \"fredag\", \"l\u00f8rdag\" ],\n\tdayNamesMin: [ \"s\u00f8\", \"ma\", \"ti\", \"on\", \"to\", \"fr\", \"l\u00f8\" ],\n\tweekHeader: \"Uke\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.no );\n\nreturn datepicker.regional.no;\n\n} );\n","jquery/ui-modules/i18n/datepicker-el.js":"/* Greek (el) initialisation for the jQuery UI date picker plugin. */\n/* Written by Alex Cicovic (http://www.alexcicovic.com) */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.el = {\n\tcloseText: \"\u039a\u03bb\u03b5\u03af\u03c3\u03b9\u03bc\u03bf\",\n\tprevText: \"\u03a0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf\u03c2\",\n\tnextText: \"\u0395\u03c0\u03cc\u03bc\u03b5\u03bd\u03bf\u03c2\",\n\tcurrentText: \"\u03a3\u03ae\u03bc\u03b5\u03c1\u03b1\",\n\tmonthNames: [ \"\u0399\u03b1\u03bd\u03bf\u03c5\u03ac\u03c1\u03b9\u03bf\u03c2\", \"\u03a6\u03b5\u03b2\u03c1\u03bf\u03c5\u03ac\u03c1\u03b9\u03bf\u03c2\", \"\u039c\u03ac\u03c1\u03c4\u03b9\u03bf\u03c2\", \"\u0391\u03c0\u03c1\u03af\u03bb\u03b9\u03bf\u03c2\", \"\u039c\u03ac\u03b9\u03bf\u03c2\", \"\u0399\u03bf\u03cd\u03bd\u03b9\u03bf\u03c2\",\n\t\"\u0399\u03bf\u03cd\u03bb\u03b9\u03bf\u03c2\", \"\u0391\u03cd\u03b3\u03bf\u03c5\u03c3\u03c4\u03bf\u03c2\", \"\u03a3\u03b5\u03c0\u03c4\u03ad\u03bc\u03b2\u03c1\u03b9\u03bf\u03c2\", \"\u039f\u03ba\u03c4\u03ce\u03b2\u03c1\u03b9\u03bf\u03c2\", \"\u039d\u03bf\u03ad\u03bc\u03b2\u03c1\u03b9\u03bf\u03c2\", \"\u0394\u03b5\u03ba\u03ad\u03bc\u03b2\u03c1\u03b9\u03bf\u03c2\" ],\n\tmonthNamesShort: [ \"\u0399\u03b1\u03bd\", \"\u03a6\u03b5\u03b2\", \"\u039c\u03b1\u03c1\", \"\u0391\u03c0\u03c1\", \"\u039c\u03b1\u03b9\", \"\u0399\u03bf\u03c5\u03bd\",\n\t\"\u0399\u03bf\u03c5\u03bb\", \"\u0391\u03c5\u03b3\", \"\u03a3\u03b5\u03c0\", \"\u039f\u03ba\u03c4\", \"\u039d\u03bf\u03b5\", \"\u0394\u03b5\u03ba\" ],\n\tdayNames: [ \"\u039a\u03c5\u03c1\u03b9\u03b1\u03ba\u03ae\", \"\u0394\u03b5\u03c5\u03c4\u03ad\u03c1\u03b1\", \"\u03a4\u03c1\u03af\u03c4\u03b7\", \"\u03a4\u03b5\u03c4\u03ac\u03c1\u03c4\u03b7\", \"\u03a0\u03ad\u03bc\u03c0\u03c4\u03b7\", \"\u03a0\u03b1\u03c1\u03b1\u03c3\u03ba\u03b5\u03c5\u03ae\", \"\u03a3\u03ac\u03b2\u03b2\u03b1\u03c4\u03bf\" ],\n\tdayNamesShort: [ \"\u039a\u03c5\u03c1\", \"\u0394\u03b5\u03c5\", \"\u03a4\u03c1\u03b9\", \"\u03a4\u03b5\u03c4\", \"\u03a0\u03b5\u03bc\", \"\u03a0\u03b1\u03c1\", \"\u03a3\u03b1\u03b2\" ],\n\tdayNamesMin: [ \"\u039a\u03c5\", \"\u0394\u03b5\", \"\u03a4\u03c1\", \"\u03a4\u03b5\", \"\u03a0\u03b5\", \"\u03a0\u03b1\", \"\u03a3\u03b1\" ],\n\tweekHeader: \"\u0395\u03b2\u03b4\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.el );\n\nreturn datepicker.regional.el;\n\n} );\n","jquery/ui-modules/i18n/datepicker-et.js":"/* Estonian initialisation for the jQuery UI date picker plugin. */\n/* Written by Mart S\u00f5mermaa (mrts.pydev at gmail com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.et = {\n\tcloseText: \"Sulge\",\n\tprevText: \"Eelnev\",\n\tnextText: \"J\u00e4rgnev\",\n\tcurrentText: \"T\u00e4na\",\n\tmonthNames: [ \"Jaanuar\", \"Veebruar\", \"M\u00e4rts\", \"Aprill\", \"Mai\", \"Juuni\",\n\t\"Juuli\", \"August\", \"September\", \"Oktoober\", \"November\", \"Detsember\" ],\n\tmonthNamesShort: [ \"Jaan\", \"Veebr\", \"M\u00e4rts\", \"Apr\", \"Mai\", \"Juuni\",\n\t\"Juuli\", \"Aug\", \"Sept\", \"Okt\", \"Nov\", \"Dets\" ],\n\tdayNames: [\n\t\t\"P\u00fchap\u00e4ev\",\n\t\t\"Esmasp\u00e4ev\",\n\t\t\"Teisip\u00e4ev\",\n\t\t\"Kolmap\u00e4ev\",\n\t\t\"Neljap\u00e4ev\",\n\t\t\"Reede\",\n\t\t\"Laup\u00e4ev\"\n\t],\n\tdayNamesShort: [ \"P\u00fchap\", \"Esmasp\", \"Teisip\", \"Kolmap\", \"Neljap\", \"Reede\", \"Laup\" ],\n\tdayNamesMin: [ \"P\", \"E\", \"T\", \"K\", \"N\", \"R\", \"L\" ],\n\tweekHeader: \"n\u00e4d\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.et );\n\nreturn datepicker.regional.et;\n\n} );\n","jquery/ui-modules/i18n/datepicker-is.js":"/* Icelandic initialisation for the jQuery UI date picker plugin. */\n/* Written by Haukur H. Thorsson (haukur@eskill.is). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.is = {\n\tcloseText: \"Loka\",\n\tprevText: \"&#x3C; Fyrri\",\n\tnextText: \"N\u00e6sti &#x3E;\",\n\tcurrentText: \"\u00cd dag\",\n\tmonthNames: [ \"Jan\u00faar\", \"Febr\u00faar\", \"Mars\", \"Apr\u00edl\", \"Ma\u00ed\", \"J\u00fan\u00ed\",\n\t\"J\u00fal\u00ed\", \"\u00c1g\u00fast\", \"September\", \"Okt\u00f3ber\", \"N\u00f3vember\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Ma\u00ed\", \"J\u00fan\",\n\t\"J\u00fal\", \"\u00c1g\u00fa\", \"Sep\", \"Okt\", \"N\u00f3v\", \"Des\" ],\n\tdayNames: [\n\t\t\"Sunnudagur\",\n\t\t\"M\u00e1nudagur\",\n\t\t\"\u00deri\u00f0judagur\",\n\t\t\"Mi\u00f0vikudagur\",\n\t\t\"Fimmtudagur\",\n\t\t\"F\u00f6studagur\",\n\t\t\"Laugardagur\"\n\t],\n\tdayNamesShort: [ \"Sun\", \"M\u00e1n\", \"\u00deri\", \"Mi\u00f0\", \"Fim\", \"F\u00f6s\", \"Lau\" ],\n\tdayNamesMin: [ \"Su\", \"M\u00e1\", \"\u00der\", \"Mi\", \"Fi\", \"F\u00f6\", \"La\" ],\n\tweekHeader: \"Vika\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.is );\n\nreturn datepicker.regional.is;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sl.js":"/* Slovenian initialisation for the jQuery UI date picker plugin. */\n/* Written by Jaka Jancar (jaka@kubje.org). */\n/* c = \u010d, s = \u0161 z = \u017e C = \u010c S = \u0160 Z = \u017d */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sl = {\n\tcloseText: \"Zapri\",\n\tprevText: \"&#x3C;Prej\u0161nji\",\n\tnextText: \"Naslednji&#x3E;\",\n\tcurrentText: \"Trenutni\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Marec\", \"April\", \"Maj\", \"Junij\",\n\t\"Julij\", \"Avgust\", \"September\", \"Oktober\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Avg\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Nedelja\", \"Ponedeljek\", \"Torek\", \"Sreda\", \"\u010cetrtek\", \"Petek\", \"Sobota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Tor\", \"Sre\", \"\u010cet\", \"Pet\", \"Sob\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"To\", \"Sr\", \"\u010ce\", \"Pe\", \"So\" ],\n\tweekHeader: \"Teden\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sl );\n\nreturn datepicker.regional.sl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nn.js":"/* Norwegian Nynorsk initialisation for the jQuery UI date picker plugin. */\n/* Written by Bj\u00f8rn Johansen (post@bjornjohansen.no). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.nn = {\n\tcloseText: \"Lukk\",\n\tprevText: \"&#xAB;F\u00f8rre\",\n\tnextText: \"Neste&#xBB;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [\n\t\t\"januar\",\n\t\t\"februar\",\n\t\t\"mars\",\n\t\t\"april\",\n\t\t\"mai\",\n\t\t\"juni\",\n\t\t\"juli\",\n\t\t\"august\",\n\t\t\"september\",\n\t\t\"oktober\",\n\t\t\"november\",\n\t\t\"desember\"\n\t],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mar\", \"apr\", \"mai\", \"jun\", \"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"des\" ],\n\tdayNamesShort: [ \"sun\", \"m\u00e5n\", \"tys\", \"ons\", \"tor\", \"fre\", \"lau\" ],\n\tdayNames: [ \"sundag\", \"m\u00e5ndag\", \"tysdag\", \"onsdag\", \"torsdag\", \"fredag\", \"laurdag\" ],\n\tdayNamesMin: [ \"su\", \"m\u00e5\", \"ty\", \"on\", \"to\", \"fr\", \"la\" ],\n\tweekHeader: \"Veke\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.nn );\n\nreturn datepicker.regional.nn;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ko.js":"/* Korean initialisation for the jQuery calendar extension. */\n/* Written by DaeKwon Kang (ncrash.dk@gmail.com), Edited by Genie and Myeongjin Lee. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ko = {\n\tcloseText: \"\ub2eb\uae30\",\n\tprevText: \"\uc774\uc804\ub2ec\",\n\tnextText: \"\ub2e4\uc74c\ub2ec\",\n\tcurrentText: \"\uc624\ub298\",\n\tmonthNames: [ \"1\uc6d4\", \"2\uc6d4\", \"3\uc6d4\", \"4\uc6d4\", \"5\uc6d4\", \"6\uc6d4\",\n\t\"7\uc6d4\", \"8\uc6d4\", \"9\uc6d4\", \"10\uc6d4\", \"11\uc6d4\", \"12\uc6d4\" ],\n\tmonthNamesShort: [ \"1\uc6d4\", \"2\uc6d4\", \"3\uc6d4\", \"4\uc6d4\", \"5\uc6d4\", \"6\uc6d4\",\n\t\"7\uc6d4\", \"8\uc6d4\", \"9\uc6d4\", \"10\uc6d4\", \"11\uc6d4\", \"12\uc6d4\" ],\n\tdayNames: [ \"\uc77c\uc694\uc77c\", \"\uc6d4\uc694\uc77c\", \"\ud654\uc694\uc77c\", \"\uc218\uc694\uc77c\", \"\ubaa9\uc694\uc77c\", \"\uae08\uc694\uc77c\", \"\ud1a0\uc694\uc77c\" ],\n\tdayNamesShort: [ \"\uc77c\", \"\uc6d4\", \"\ud654\", \"\uc218\", \"\ubaa9\", \"\uae08\", \"\ud1a0\" ],\n\tdayNamesMin: [ \"\uc77c\", \"\uc6d4\", \"\ud654\", \"\uc218\", \"\ubaa9\", \"\uae08\", \"\ud1a0\" ],\n\tweekHeader: \"\uc8fc\",\n\tdateFormat: \"yy. m. d.\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\ub144\" };\ndatepicker.setDefaults( datepicker.regional.ko );\n\nreturn datepicker.regional.ko;\n\n} );\n","jquery/ui-modules/i18n/datepicker-pt.js":"/* Portuguese initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.pt = {\n\tcloseText: \"Fechar\",\n\tprevText: \"Anterior\",\n\tnextText: \"Seguinte\",\n\tcurrentText: \"Hoje\",\n\tmonthNames: [ \"Janeiro\", \"Fevereiro\", \"Mar\u00e7o\", \"Abril\", \"Maio\", \"Junho\",\n\t\"Julho\", \"Agosto\", \"Setembro\", \"Outubro\", \"Novembro\", \"Dezembro\" ],\n\tmonthNamesShort: [ \"Jan\", \"Fev\", \"Mar\", \"Abr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Ago\", \"Set\", \"Out\", \"Nov\", \"Dez\" ],\n\tdayNames: [\n\t\t\"Domingo\",\n\t\t\"Segunda-feira\",\n\t\t\"Ter\u00e7a-feira\",\n\t\t\"Quarta-feira\",\n\t\t\"Quinta-feira\",\n\t\t\"Sexta-feira\",\n\t\t\"S\u00e1bado\"\n\t],\n\tdayNamesShort: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tdayNamesMin: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tweekHeader: \"Sem\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.pt );\n\nreturn datepicker.regional.pt;\n\n} );\n","jquery/ui-modules/i18n/datepicker-vi.js":"/* Vietnamese initialisation for the jQuery UI date picker plugin. */\n/* Translated by Le Thanh Huy (lthanhhuy@cit.ctu.edu.vn). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.vi = {\n\tcloseText: \"\u0110\u00f3ng\",\n\tprevText: \"&#x3C;Tr\u01b0\u1edbc\",\n\tnextText: \"Ti\u1ebfp&#x3E;\",\n\tcurrentText: \"H\u00f4m nay\",\n\tmonthNames: [ \"Th\u00e1ng M\u1ed9t\", \"Th\u00e1ng Hai\", \"Th\u00e1ng Ba\", \"Th\u00e1ng T\u01b0\", \"Th\u00e1ng N\u0103m\", \"Th\u00e1ng S\u00e1u\",\n\t\"Th\u00e1ng B\u1ea3y\", \"Th\u00e1ng T\u00e1m\", \"Th\u00e1ng Ch\u00edn\", \"Th\u00e1ng M\u01b0\u1eddi\", \"Th\u00e1ng M\u01b0\u1eddi M\u1ed9t\", \"Th\u00e1ng M\u01b0\u1eddi Hai\" ],\n\tmonthNamesShort: [ \"Th\u00e1ng 1\", \"Th\u00e1ng 2\", \"Th\u00e1ng 3\", \"Th\u00e1ng 4\", \"Th\u00e1ng 5\", \"Th\u00e1ng 6\",\n\t\"Th\u00e1ng 7\", \"Th\u00e1ng 8\", \"Th\u00e1ng 9\", \"Th\u00e1ng 10\", \"Th\u00e1ng 11\", \"Th\u00e1ng 12\" ],\n\tdayNames: [ \"Ch\u1ee7 Nh\u1eadt\", \"Th\u1ee9 Hai\", \"Th\u1ee9 Ba\", \"Th\u1ee9 T\u01b0\", \"Th\u1ee9 N\u0103m\", \"Th\u1ee9 S\u00e1u\", \"Th\u1ee9 B\u1ea3y\" ],\n\tdayNamesShort: [ \"CN\", \"T2\", \"T3\", \"T4\", \"T5\", \"T6\", \"T7\" ],\n\tdayNamesMin: [ \"CN\", \"T2\", \"T3\", \"T4\", \"T5\", \"T6\", \"T7\" ],\n\tweekHeader: \"Tu\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.vi );\n\nreturn datepicker.regional.vi;\n\n} );\n","jquery/ui-modules/i18n/datepicker-lv.js":"/* Latvian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* @author Arturas Paleicikas <arturas.paleicikas@metasite.net> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.lv = {\n\tcloseText: \"Aizv\u0113rt\",\n\tprevText: \"Iepr.\",\n\tnextText: \"N\u0101k.\",\n\tcurrentText: \"\u0160odien\",\n\tmonthNames: [ \"Janv\u0101ris\", \"Febru\u0101ris\", \"Marts\", \"Apr\u012blis\", \"Maijs\", \"J\u016bnijs\",\n\t\"J\u016blijs\", \"Augusts\", \"Septembris\", \"Oktobris\", \"Novembris\", \"Decembris\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Mai\", \"J\u016bn\",\n\t\"J\u016bl\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [\n\t\t\"sv\u0113tdiena\",\n\t\t\"pirmdiena\",\n\t\t\"otrdiena\",\n\t\t\"tre\u0161diena\",\n\t\t\"ceturtdiena\",\n\t\t\"piektdiena\",\n\t\t\"sestdiena\"\n\t],\n\tdayNamesShort: [ \"svt\", \"prm\", \"otr\", \"tre\", \"ctr\", \"pkt\", \"sst\" ],\n\tdayNamesMin: [ \"Sv\", \"Pr\", \"Ot\", \"Tr\", \"Ct\", \"Pk\", \"Ss\" ],\n\tweekHeader: \"Ned.\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.lv );\n\nreturn datepicker.regional.lv;\n\n} );\n","jquery/ui-modules/i18n/datepicker-kk.js":"/* Kazakh (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Dmitriy Karasyov (dmitriy.karasyov@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.kk = {\n\tcloseText: \"\u0416\u0430\u0431\u0443\",\n\tprevText: \"&#x3C;\u0410\u043b\u0434\u044b\u04a3\u0493\u044b\",\n\tnextText: \"\u041a\u0435\u043b\u0435\u0441\u0456&#x3E;\",\n\tcurrentText: \"\u0411\u04af\u0433\u0456\u043d\",\n\tmonthNames: [ \"\u049a\u0430\u04a3\u0442\u0430\u0440\", \"\u0410\u049b\u043f\u0430\u043d\", \"\u041d\u0430\u0443\u0440\u044b\u0437\", \"\u0421\u04d9\u0443\u0456\u0440\", \"\u041c\u0430\u043c\u044b\u0440\", \"\u041c\u0430\u0443\u0441\u044b\u043c\",\n\t\"\u0428\u0456\u043b\u0434\u0435\", \"\u0422\u0430\u043c\u044b\u0437\", \"\u049a\u044b\u0440\u043a\u04af\u0439\u0435\u043a\", \"\u049a\u0430\u0437\u0430\u043d\", \"\u049a\u0430\u0440\u0430\u0448\u0430\", \"\u0416\u0435\u043b\u0442\u043e\u049b\u0441\u0430\u043d\" ],\n\tmonthNamesShort: [ \"\u049a\u0430\u04a3\", \"\u0410\u049b\u043f\", \"\u041d\u0430\u0443\", \"\u0421\u04d9\u0443\", \"\u041c\u0430\u043c\", \"\u041c\u0430\u0443\",\n\t\"\u0428\u0456\u043b\", \"\u0422\u0430\u043c\", \"\u049a\u044b\u0440\", \"\u049a\u0430\u0437\", \"\u049a\u0430\u0440\", \"\u0416\u0435\u043b\" ],\n\tdayNames: [ \"\u0416\u0435\u043a\u0441\u0435\u043d\u0431\u0456\", \"\u0414\u04af\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0421\u0435\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0421\u04d9\u0440\u0441\u0435\u043d\u0431\u0456\", \"\u0411\u0435\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0416\u04b1\u043c\u0430\", \"\u0421\u0435\u043d\u0431\u0456\" ],\n\tdayNamesShort: [ \"\u0436\u043a\u0441\", \"\u0434\u0441\u043d\", \"\u0441\u0441\u043d\", \"\u0441\u0440\u0441\", \"\u0431\u0441\u043d\", \"\u0436\u043c\u0430\", \"\u0441\u043d\u0431\" ],\n\tdayNamesMin: [ \"\u0416\u043a\", \"\u0414\u0441\", \"\u0421\u0441\", \"\u0421\u0440\", \"\u0411\u0441\", \"\u0416\u043c\", \"\u0421\u043d\" ],\n\tweekHeader: \"\u041d\u0435\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.kk );\n\nreturn datepicker.regional.kk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-it-CH.js":"/* Italian initialisation for the jQuery UI date picker plugin. */\n/* Written by Antonello Pasella (antonello.pasella@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"it-CH\" ] = {\n\tcloseText: \"Chiudi\",\n\tprevText: \"&#x3C;Prec\",\n\tnextText: \"Succ&#x3E;\",\n\tcurrentText: \"Oggi\",\n\tmonthNames: [ \"Gennaio\", \"Febbraio\", \"Marzo\", \"Aprile\", \"Maggio\", \"Giugno\",\n\t\t\"Luglio\", \"Agosto\", \"Settembre\", \"Ottobre\", \"Novembre\", \"Dicembre\" ],\n\tmonthNamesShort: [ \"Gen\", \"Feb\", \"Mar\", \"Apr\", \"Mag\", \"Giu\",\n\t\t\"Lug\", \"Ago\", \"Set\", \"Ott\", \"Nov\", \"Dic\" ],\n\tdayNames: [ \"Domenica\", \"Luned\u00ec\", \"Marted\u00ec\", \"Mercoled\u00ec\", \"Gioved\u00ec\", \"Venerd\u00ec\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"Mer\", \"Gio\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"it-CH\" ] );\n\nreturn datepicker.regional[ \"it-CH\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-gl.js":"/* Galician localization for 'UI date picker' jQuery extension. */\n/* Translated by Jorge Barreiro <yortx.barry@gmail.com>. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.gl = {\n\tcloseText: \"Pechar\",\n\tprevText: \"&#x3C;Ant\",\n\tnextText: \"Seg&#x3E;\",\n\tcurrentText: \"Hoxe\",\n\tmonthNames: [ \"Xaneiro\", \"Febreiro\", \"Marzo\", \"Abril\", \"Maio\", \"Xu\u00f1o\",\n\t\"Xullo\", \"Agosto\", \"Setembro\", \"Outubro\", \"Novembro\", \"Decembro\" ],\n\tmonthNamesShort: [ \"Xan\", \"Feb\", \"Mar\", \"Abr\", \"Mai\", \"Xu\u00f1\",\n\t\"Xul\", \"Ago\", \"Set\", \"Out\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Domingo\", \"Luns\", \"Martes\", \"M\u00e9rcores\", \"Xoves\", \"Venres\", \"S\u00e1bado\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"M\u00e9r\", \"Xov\", \"Ven\", \"S\u00e1b\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"M\u00e9\", \"Xo\", \"Ve\", \"S\u00e1\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.gl );\n\nreturn datepicker.regional.gl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-pl.js":"/* Polish initialisation for the jQuery UI date picker plugin. */\n/* Written by Jacek Wysocki (jacek.wysocki@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.pl = {\n\tcloseText: \"Zamknij\",\n\tprevText: \"&#x3C;Poprzedni\",\n\tnextText: \"Nast\u0119pny&#x3E;\",\n\tcurrentText: \"Dzi\u015b\",\n\tmonthNames: [ \"Stycze\u0144\", \"Luty\", \"Marzec\", \"Kwiecie\u0144\", \"Maj\", \"Czerwiec\",\n\t\"Lipiec\", \"Sierpie\u0144\", \"Wrzesie\u0144\", \"Pa\u017adziernik\", \"Listopad\", \"Grudzie\u0144\" ],\n\tmonthNamesShort: [ \"Sty\", \"Lu\", \"Mar\", \"Kw\", \"Maj\", \"Cze\",\n\t\"Lip\", \"Sie\", \"Wrz\", \"Pa\", \"Lis\", \"Gru\" ],\n\tdayNames: [ \"Niedziela\", \"Poniedzia\u0142ek\", \"Wtorek\", \"\u015aroda\", \"Czwartek\", \"Pi\u0105tek\", \"Sobota\" ],\n\tdayNamesShort: [ \"Nie\", \"Pn\", \"Wt\", \"\u015ar\", \"Czw\", \"Pt\", \"So\" ],\n\tdayNamesMin: [ \"N\", \"Pn\", \"Wt\", \"\u015ar\", \"Cz\", \"Pt\", \"So\" ],\n\tweekHeader: \"Tydz\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.pl );\n\nreturn datepicker.regional.pl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-eo.js":"/* Esperanto initialisation for the jQuery UI date picker plugin. */\n/* Written by Olivier M. (olivierweb@ifrance.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.eo = {\n\tcloseText: \"Fermi\",\n\tprevText: \"&#x3C;Anta\",\n\tnextText: \"Sekv&#x3E;\",\n\tcurrentText: \"Nuna\",\n\tmonthNames: [ \"Januaro\", \"Februaro\", \"Marto\", \"Aprilo\", \"Majo\", \"Junio\",\n\t\"Julio\", \"A\u016dgusto\", \"Septembro\", \"Oktobro\", \"Novembro\", \"Decembro\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"A\u016dg\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Diman\u0109o\", \"Lundo\", \"Mardo\", \"Merkredo\", \"\u0134a\u016ddo\", \"Vendredo\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dim\", \"Lun\", \"Mar\", \"Mer\", \"\u0134a\u016d\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Di\", \"Lu\", \"Ma\", \"Me\", \"\u0134a\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sb\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.eo );\n\nreturn datepicker.regional.eo;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ro.js":"/* Romanian initialisation for the jQuery UI date picker plugin.\n *\n * Written by Edmond L. (ll_edmond@walla.com)\n * and Ionut G. Stan (ionut.g.stan@gmail.com)\n */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ro = {\n\tcloseText: \"\u00cenchide\",\n\tprevText: \"&#xAB; Luna precedent\u0103\",\n\tnextText: \"Luna urm\u0103toare &#xBB;\",\n\tcurrentText: \"Azi\",\n\tmonthNames: [ \"Ianuarie\", \"Februarie\", \"Martie\", \"Aprilie\", \"Mai\", \"Iunie\",\n\t\"Iulie\", \"August\", \"Septembrie\", \"Octombrie\", \"Noiembrie\", \"Decembrie\" ],\n\tmonthNamesShort: [ \"Ian\", \"Feb\", \"Mar\", \"Apr\", \"Mai\", \"Iun\",\n\t\"Iul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Duminic\u0103\", \"Luni\", \"Mar\u0163i\", \"Miercuri\", \"Joi\", \"Vineri\", \"S\u00e2mb\u0103t\u0103\" ],\n\tdayNamesShort: [ \"Dum\", \"Lun\", \"Mar\", \"Mie\", \"Joi\", \"Vin\", \"S\u00e2m\" ],\n\tdayNamesMin: [ \"Du\", \"Lu\", \"Ma\", \"Mi\", \"Jo\", \"Vi\", \"S\u00e2\" ],\n\tweekHeader: \"S\u0103pt\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ro );\n\nreturn datepicker.regional.ro;\n\n} );\n","jquery/ui-modules/i18n/datepicker-tj.js":"/* Tajiki (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Abdurahmon Saidov (saidovab@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.tj = {\n\tcloseText: \"\u0418\u0434\u043e\u043c\u0430\",\n\tprevText: \"&#x3c;\u049a\u0430\u0444\u043e\",\n\tnextText: \"\u041f\u0435\u0448&#x3e;\",\n\tcurrentText: \"\u0418\u043c\u0440\u04ef\u0437\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\", \"\u0424\u0435\u0432\u0440\u0430\u043b\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\", \"\u041e\u043a\u0442\u044f\u0431\u0440\", \"\u041d\u043e\u044f\u0431\u0440\", \"\u0414\u0435\u043a\u0430\u0431\u0440\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u044f\u043a\u0448\u0430\u043d\u0431\u0435\", \"\u0434\u0443\u0448\u0430\u043d\u0431\u0435\", \"\u0441\u0435\u0448\u0430\u043d\u0431\u0435\", \"\u0447\u043e\u0440\u0448\u0430\u043d\u0431\u0435\", \"\u043f\u0430\u043d\u04b7\u0448\u0430\u043d\u0431\u0435\", \"\u04b7\u0443\u043c\u044a\u0430\", \"\u0448\u0430\u043d\u0431\u0435\" ],\n\tdayNamesShort: [ \"\u044f\u043a\u0448\", \"\u0434\u0443\u0448\", \"\u0441\u0435\u0448\", \"\u0447\u043e\u0440\", \"\u043f\u0430\u043d\", \"\u04b7\u0443\u043c\", \"\u0448\u0430\u043d\" ],\n\tdayNamesMin: [ \"\u042f\u043a\", \"\u0414\u0448\", \"\u0421\u0448\", \"\u0427\u0448\", \"\u041f\u0448\", \"\u04b6\u043c\", \"\u0428\u043d\" ],\n\tweekHeader: \"\u0425\u0444\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.tj );\n\nreturn datepicker.regional.tj;\n\n} );\n","jquery/ui-modules/i18n/datepicker-tr.js":"/* Turkish initialisation for the jQuery UI date picker plugin. */\n/* Written by Izzet Emre Erkan (kara@karalamalar.net). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.tr = {\n\tcloseText: \"kapat\",\n\tprevText: \"&#x3C;geri\",\n\tnextText: \"ileri&#x3e\",\n\tcurrentText: \"bug\u00fcn\",\n\tmonthNames: [ \"Ocak\", \"\u015eubat\", \"Mart\", \"Nisan\", \"May\u0131s\", \"Haziran\",\n\t\"Temmuz\", \"A\u011fustos\", \"Eyl\u00fcl\", \"Ekim\", \"Kas\u0131m\", \"Aral\u0131k\" ],\n\tmonthNamesShort: [ \"Oca\", \"\u015eub\", \"Mar\", \"Nis\", \"May\", \"Haz\",\n\t\"Tem\", \"A\u011fu\", \"Eyl\", \"Eki\", \"Kas\", \"Ara\" ],\n\tdayNames: [ \"Pazar\", \"Pazartesi\", \"Sal\u0131\", \"\u00c7ar\u015famba\", \"Per\u015fembe\", \"Cuma\", \"Cumartesi\" ],\n\tdayNamesShort: [ \"Pz\", \"Pt\", \"Sa\", \"\u00c7a\", \"Pe\", \"Cu\", \"Ct\" ],\n\tdayNamesMin: [ \"Pz\", \"Pt\", \"Sa\", \"\u00c7a\", \"Pe\", \"Cu\", \"Ct\" ],\n\tweekHeader: \"Hf\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.tr );\n\nreturn datepicker.regional.tr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fo.js":"/* Faroese initialisation for the jQuery UI date picker plugin */\n/* Written by Sverri Mohr Olsen, sverrimo@gmail.com */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fo = {\n\tcloseText: \"Lat aftur\",\n\tprevText: \"&#x3C;Fyrra\",\n\tnextText: \"N\u00e6sta&#x3E;\",\n\tcurrentText: \"\u00cd dag\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Mars\", \"Apr\u00edl\", \"Mei\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Des\" ],\n\tdayNames: [\n\t\t\"Sunnudagur\",\n\t\t\"M\u00e1nadagur\",\n\t\t\"T\u00fdsdagur\",\n\t\t\"Mikudagur\",\n\t\t\"H\u00f3sdagur\",\n\t\t\"Fr\u00edggjadagur\",\n\t\t\"Leyardagur\"\n\t],\n\tdayNamesShort: [ \"Sun\", \"M\u00e1n\", \"T\u00fds\", \"Mik\", \"H\u00f3s\", \"Fr\u00ed\", \"Ley\" ],\n\tdayNamesMin: [ \"Su\", \"M\u00e1\", \"T\u00fd\", \"Mi\", \"H\u00f3\", \"Fr\", \"Le\" ],\n\tweekHeader: \"Vk\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fo );\n\nreturn datepicker.regional.fo;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ar.js":"/* Arabic Translation for jQuery UI date picker plugin. */\n/* Used in most of Arab countries, primarily in Bahrain, */\n/* Kuwait, Oman, Qatar, Saudi Arabia and the United Arab Emirates, Egypt, Sudan and Yemen. */\n/* Written by Mohammed Alshehri -- m@dralshehri.com */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ar = {\n\tcloseText: \"\u0625\u063a\u0644\u0627\u0642\",\n\tprevText: \"&#x3C;\u0627\u0644\u0633\u0627\u0628\u0642\",\n\tnextText: \"\u0627\u0644\u062a\u0627\u0644\u064a&#x3E;\",\n\tcurrentText: \"\u0627\u0644\u064a\u0648\u0645\",\n\tmonthNames: [ \"\u064a\u0646\u0627\u064a\u0631\", \"\u0641\u0628\u0631\u0627\u064a\u0631\", \"\u0645\u0627\u0631\u0633\", \"\u0623\u0628\u0631\u064a\u0644\", \"\u0645\u0627\u064a\u0648\", \"\u064a\u0648\u0646\u064a\u0648\",\n\t\"\u064a\u0648\u0644\u064a\u0648\", \"\u0623\u063a\u0633\u0637\u0633\", \"\u0633\u0628\u062a\u0645\u0628\u0631\", \"\u0623\u0643\u062a\u0648\u0628\u0631\", \"\u0646\u0648\u0641\u0645\u0628\u0631\", \"\u062f\u064a\u0633\u0645\u0628\u0631\" ],\n\tmonthNamesShort: [ \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"10\", \"11\", \"12\" ],\n\tdayNames: [ \"\u0627\u0644\u0623\u062d\u062f\", \"\u0627\u0644\u0627\u062b\u0646\u064a\u0646\", \"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u0627\u0644\u062e\u0645\u064a\u0633\", \"\u0627\u0644\u062c\u0645\u0639\u0629\", \"\u0627\u0644\u0633\u0628\u062a\" ],\n\tdayNamesShort: [ \"\u0623\u062d\u062f\", \"\u0627\u062b\u0646\u064a\u0646\", \"\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u062e\u0645\u064a\u0633\", \"\u062c\u0645\u0639\u0629\", \"\u0633\u0628\u062a\" ],\n\tdayNamesMin: [ \"\u062d\", \"\u0646\", \"\u062b\", \"\u0631\", \"\u062e\", \"\u062c\", \"\u0633\" ],\n\tweekHeader: \"\u0623\u0633\u0628\u0648\u0639\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\t\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ar );\n\nreturn datepicker.regional.ar;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sr-SR.js":"/* Serbian i18n for the jQuery UI date picker plugin. */\n/* Written by Dejan Dimi\u0107. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"sr-SR\" ] = {\n\tcloseText: \"Zatvori\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"Danas\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Mart\", \"April\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Avgust\", \"Septembar\", \"Oktobar\", \"Novembar\", \"Decembar\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Avg\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Nedelja\", \"Ponedeljak\", \"Utorak\", \"Sreda\", \"\u010cetvrtak\", \"Petak\", \"Subota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Sre\", \"\u010cet\", \"Pet\", \"Sub\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"Sr\", \"\u010ce\", \"Pe\", \"Su\" ],\n\tweekHeader: \"Sed\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"sr-SR\" ] );\n\nreturn datepicker.regional[ \"sr-SR\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-sk.js":"/* Slovak initialisation for the jQuery UI date picker plugin. */\n/* Written by Vojtech Rinik (vojto@hmm.sk). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sk = {\n\tcloseText: \"Zavrie\u0165\",\n\tprevText: \"&#x3C;Predch\u00e1dzaj\u00faci\",\n\tnextText: \"Nasleduj\u00faci&#x3E;\",\n\tcurrentText: \"Dnes\",\n\tmonthNames: [ \"janu\u00e1r\", \"febru\u00e1r\", \"marec\", \"apr\u00edl\", \"m\u00e1j\", \"j\u00fan\",\n\t\"j\u00fal\", \"august\", \"september\", \"okt\u00f3ber\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"M\u00e1j\", \"J\u00fan\",\n\t\"J\u00fal\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"nede\u013ea\", \"pondelok\", \"utorok\", \"streda\", \"\u0161tvrtok\", \"piatok\", \"sobota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Str\", \"\u0160tv\", \"Pia\", \"Sob\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"St\", \"\u0160t\", \"Pia\", \"So\" ],\n\tweekHeader: \"Ty\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sk );\n\nreturn datepicker.regional.sk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-it.js":"/* Italian initialisation for the jQuery UI date picker plugin. */\n/* Written by Antonello Pasella (antonello.pasella@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.it = {\n\tcloseText: \"Chiudi\",\n\tprevText: \"&#x3C;Prec\",\n\tnextText: \"Succ&#x3E;\",\n\tcurrentText: \"Oggi\",\n\tmonthNames: [ \"Gennaio\", \"Febbraio\", \"Marzo\", \"Aprile\", \"Maggio\", \"Giugno\",\n\t\t\"Luglio\", \"Agosto\", \"Settembre\", \"Ottobre\", \"Novembre\", \"Dicembre\" ],\n\tmonthNamesShort: [ \"Gen\", \"Feb\", \"Mar\", \"Apr\", \"Mag\", \"Giu\",\n\t\t\"Lug\", \"Ago\", \"Set\", \"Ott\", \"Nov\", \"Dic\" ],\n\tdayNames: [ \"Domenica\", \"Luned\u00ec\", \"Marted\u00ec\", \"Mercoled\u00ec\", \"Gioved\u00ec\", \"Venerd\u00ec\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"Mer\", \"Gio\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.it );\n\nreturn datepicker.regional.it;\n\n} );\n","jquery/ui-modules/i18n/datepicker-es.js":"/* Inicializaci\u00f3n en espa\u00f1ol para la extensi\u00f3n 'UI date picker' para jQuery. */\n/* Traducido por Vester (xvester@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.es = {\n\tcloseText: \"Cerrar\",\n\tprevText: \"&#x3C;Ant\",\n\tnextText: \"Sig&#x3E;\",\n\tcurrentText: \"Hoy\",\n\tmonthNames: [ \"enero\", \"febrero\", \"marzo\", \"abril\", \"mayo\", \"junio\",\n\t\"julio\", \"agosto\", \"septiembre\", \"octubre\", \"noviembre\", \"diciembre\" ],\n\tmonthNamesShort: [ \"ene\", \"feb\", \"mar\", \"abr\", \"may\", \"jun\",\n\t\"jul\", \"ago\", \"sep\", \"oct\", \"nov\", \"dic\" ],\n\tdayNames: [ \"domingo\", \"lunes\", \"martes\", \"mi\u00e9rcoles\", \"jueves\", \"viernes\", \"s\u00e1bado\" ],\n\tdayNamesShort: [ \"dom\", \"lun\", \"mar\", \"mi\u00e9\", \"jue\", \"vie\", \"s\u00e1b\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"X\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.es );\n\nreturn datepicker.regional.es;\n\n} );\n","jquery/ui-modules/i18n/datepicker-en-NZ.js":"/* English/New Zealand initialisation for the jQuery UI date picker plugin. */\n/* Based on the en-GB initialisation. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"en-NZ\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ],\n\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ],\n\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"en-NZ\" ] );\n\nreturn datepicker.regional[ \"en-NZ\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-sr.js":"/* Serbian i18n for the jQuery UI date picker plugin. */\n/* Written by Dejan Dimi\u0107. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sr = {\n\tcloseText: \"\u0417\u0430\u0442\u0432\u043e\u0440\u0438\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"\u0414\u0430\u043d\u0430\u0441\",\n\tmonthNames: [ \"\u0408\u0430\u043d\u0443\u0430\u0440\", \"\u0424\u0435\u0431\u0440\u0443\u0430\u0440\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0438\u043b\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\",\n\t\"\u0408\u0443\u043b\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043f\u0442\u0435\u043c\u0431\u0430\u0440\", \"\u041e\u043a\u0442\u043e\u0431\u0430\u0440\", \"\u041d\u043e\u0432\u0435\u043c\u0431\u0430\u0440\", \"\u0414\u0435\u0446\u0435\u043c\u0431\u0430\u0440\" ],\n\tmonthNamesShort: [ \"\u0408\u0430\u043d\", \"\u0424\u0435\u0431\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\",\n\t\"\u0408\u0443\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043f\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u0432\", \"\u0414\u0435\u0446\" ],\n\tdayNames: [ \"\u041d\u0435\u0434\u0435\u0459\u0430\", \"\u041f\u043e\u043d\u0435\u0434\u0435\u0459\u0430\u043a\", \"\u0423\u0442\u043e\u0440\u0430\u043a\", \"\u0421\u0440\u0435\u0434\u0430\", \"\u0427\u0435\u0442\u0432\u0440\u0442\u0430\u043a\", \"\u041f\u0435\u0442\u0430\u043a\", \"\u0421\u0443\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u041d\u0435\u0434\", \"\u041f\u043e\u043d\", \"\u0423\u0442\u043e\", \"\u0421\u0440\u0435\", \"\u0427\u0435\u0442\", \"\u041f\u0435\u0442\", \"\u0421\u0443\u0431\" ],\n\tdayNamesMin: [ \"\u041d\u0435\", \"\u041f\u043e\", \"\u0423\u0442\", \"\u0421\u0440\", \"\u0427\u0435\", \"\u041f\u0435\", \"\u0421\u0443\" ],\n\tweekHeader: \"\u0421\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sr );\n\nreturn datepicker.regional.sr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hu.js":"/* Hungarian initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hu = {\n\tcloseText: \"Bez\u00e1r\",\n\tprevText: \"Vissza\",\n\tnextText: \"El\u0151re\",\n\tcurrentText: \"Ma\",\n\tmonthNames: [ \"Janu\u00e1r\", \"Febru\u00e1r\", \"M\u00e1rcius\", \"\u00c1prilis\", \"M\u00e1jus\", \"J\u00fanius\",\n\t\"J\u00falius\", \"Augusztus\", \"Szeptember\", \"Okt\u00f3ber\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"M\u00e1r\", \"\u00c1pr\", \"M\u00e1j\", \"J\u00fan\",\n\t\"J\u00fal\", \"Aug\", \"Szep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Vas\u00e1rnap\", \"H\u00e9tf\u0151\", \"Kedd\", \"Szerda\", \"Cs\u00fct\u00f6rt\u00f6k\", \"P\u00e9ntek\", \"Szombat\" ],\n\tdayNamesShort: [ \"Vas\", \"H\u00e9t\", \"Ked\", \"Sze\", \"Cs\u00fc\", \"P\u00e9n\", \"Szo\" ],\n\tdayNamesMin: [ \"V\", \"H\", \"K\", \"Sze\", \"Cs\", \"P\", \"Szo\" ],\n\tweekHeader: \"H\u00e9t\",\n\tdateFormat: \"yy.mm.dd.\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hu );\n\nreturn datepicker.regional.hu;\n\n} );\n","jquery/ui-modules/i18n/datepicker-lt.js":"/* Lithuanian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* @author Arturas Paleicikas <arturas@avalon.lt> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.lt = {\n\tcloseText: \"U\u017edaryti\",\n\tprevText: \"&#x3C;Atgal\",\n\tnextText: \"Pirmyn&#x3E;\",\n\tcurrentText: \"\u0160iandien\",\n\tmonthNames: [ \"Sausis\", \"Vasaris\", \"Kovas\", \"Balandis\", \"Gegu\u017e\u0117\", \"Bir\u017eelis\",\n\t\"Liepa\", \"Rugpj\u016btis\", \"Rugs\u0117jis\", \"Spalis\", \"Lapkritis\", \"Gruodis\" ],\n\tmonthNamesShort: [ \"Sau\", \"Vas\", \"Kov\", \"Bal\", \"Geg\", \"Bir\",\n\t\"Lie\", \"Rugp\", \"Rugs\", \"Spa\", \"Lap\", \"Gru\" ],\n\tdayNames: [\n\t\t\"sekmadienis\",\n\t\t\"pirmadienis\",\n\t\t\"antradienis\",\n\t\t\"tre\u010diadienis\",\n\t\t\"ketvirtadienis\",\n\t\t\"penktadienis\",\n\t\t\"\u0161e\u0161tadienis\"\n\t],\n\tdayNamesShort: [ \"sek\", \"pir\", \"ant\", \"tre\", \"ket\", \"pen\", \"\u0161e\u0161\" ],\n\tdayNamesMin: [ \"Se\", \"Pr\", \"An\", \"Tr\", \"Ke\", \"Pe\", \"\u0160e\" ],\n\tweekHeader: \"SAV\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.lt );\n\nreturn datepicker.regional.lt;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ml.js":"/* Malayalam (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Saji Nediyanchath (saji89@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ml = {\n\tcloseText: \"\u0d36\u0d30\u0d3f\",\n\tprevText: \"\u0d2e\u0d41\u0d28\u0d4d\u0d28\u0d24\u0d4d\u0d24\u0d46\",\n\tnextText: \"\u0d05\u0d1f\u0d41\u0d24\u0d4d\u0d24\u0d24\u0d4d \",\n\tcurrentText: \"\u0d07\u0d28\u0d4d\u0d28\u0d4d\",\n\tmonthNames: [ \"\u0d1c\u0d28\u0d41\u0d35\u0d30\u0d3f\", \"\u0d2b\u0d46\u0d2c\u0d4d\u0d30\u0d41\u0d35\u0d30\u0d3f\", \"\u0d2e\u0d3e\u0d30\u0d4d\u200d\u0d1a\u0d4d\u0d1a\u0d4d\", \"\u0d0f\u0d2a\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u200d\", \"\u0d2e\u0d47\u0d2f\u0d4d\", \"\u0d1c\u0d42\u0d23\u0d4d\u200d\",\n\t\"\u0d1c\u0d42\u0d32\u0d48\", \"\u0d06\u0d17\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4d\", \"\u0d38\u0d46\u0d2a\u0d4d\u0d31\u0d4d\u0d31\u0d02\u0d2c\u0d30\u0d4d\u200d\", \"\u0d12\u0d15\u0d4d\u0d1f\u0d4b\u0d2c\u0d30\u0d4d\u200d\", \"\u0d28\u0d35\u0d02\u0d2c\u0d30\u0d4d\u200d\", \"\u0d21\u0d3f\u0d38\u0d02\u0d2c\u0d30\u0d4d\u200d\" ],\n\tmonthNamesShort: [ \"\u0d1c\u0d28\u0d41\", \"\u0d2b\u0d46\u0d2c\u0d4d\", \"\u0d2e\u0d3e\u0d30\u0d4d\u200d\", \"\u0d0f\u0d2a\u0d4d\u0d30\u0d3f\", \"\u0d2e\u0d47\u0d2f\u0d4d\", \"\u0d1c\u0d42\u0d23\u0d4d\u200d\",\n\t\"\u0d1c\u0d42\u0d32\u0d3e\", \"\u0d06\u0d17\", \"\u0d38\u0d46\u0d2a\u0d4d\", \"\u0d12\u0d15\u0d4d\u0d1f\u0d4b\", \"\u0d28\u0d35\u0d02\", \"\u0d21\u0d3f\u0d38\" ],\n\tdayNames: [ \"\u0d1e\u0d3e\u0d2f\u0d30\u0d4d\u200d\", \"\u0d24\u0d3f\u0d19\u0d4d\u0d15\u0d33\u0d4d\u200d\", \"\u0d1a\u0d4a\u0d35\u0d4d\u0d35\", \"\u0d2c\u0d41\u0d27\u0d28\u0d4d\u200d\", \"\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d02\", \"\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\", \"\u0d36\u0d28\u0d3f\" ],\n\tdayNamesShort: [ \"\u0d1e\u0d3e\u0d2f\", \"\u0d24\u0d3f\u0d19\u0d4d\u0d15\", \"\u0d1a\u0d4a\u0d35\u0d4d\u0d35\", \"\u0d2c\u0d41\u0d27\", \"\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d02\", \"\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\", \"\u0d36\u0d28\u0d3f\" ],\n\tdayNamesMin: [ \"\u0d1e\u0d3e\", \"\u0d24\u0d3f\", \"\u0d1a\u0d4a\", \"\u0d2c\u0d41\", \"\u0d35\u0d4d\u0d2f\u0d3e\", \"\u0d35\u0d46\", \"\u0d36\" ],\n\tweekHeader: \"\u0d06\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ml );\n\nreturn datepicker.regional.ml;\n\n} );\n","jquery/ui-modules/i18n/datepicker-bs.js":"/* Bosnian i18n for the jQuery UI date picker plugin. */\n/* Written by Kenan Konjo. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.bs = {\n\tcloseText: \"Zatvori\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"Danas\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Mart\", \"April\", \"Maj\", \"Juni\",\n\t\"Juli\", \"August\", \"Septembar\", \"Oktobar\", \"Novembar\", \"Decembar\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Nedelja\", \"Ponedeljak\", \"Utorak\", \"Srijeda\", \"\u010cetvrtak\", \"Petak\", \"Subota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Sri\", \"\u010cet\", \"Pet\", \"Sub\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"Sr\", \"\u010ce\", \"Pe\", \"Su\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.bs );\n\nreturn datepicker.regional.bs;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sv.js":"/* Swedish initialisation for the jQuery UI date picker plugin. */\n/* Written by Anders Ekdahl ( anders@nomadiz.se). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sv = {\n\tcloseText: \"St\u00e4ng\",\n\tprevText: \"&#xAB;F\u00f6rra\",\n\tnextText: \"N\u00e4sta&#xBB;\",\n\tcurrentText: \"Idag\",\n\tmonthNames: [ \"januari\", \"februari\", \"mars\", \"april\", \"maj\", \"juni\",\n\t\"juli\", \"augusti\", \"september\", \"oktober\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"jan.\", \"feb.\", \"mars\", \"apr.\", \"maj\", \"juni\",\n\t\"juli\", \"aug.\", \"sep.\", \"okt.\", \"nov.\", \"dec.\" ],\n\tdayNamesShort: [ \"s\u00f6n\", \"m\u00e5n\", \"tis\", \"ons\", \"tor\", \"fre\", \"l\u00f6r\" ],\n\tdayNames: [ \"s\u00f6ndag\", \"m\u00e5ndag\", \"tisdag\", \"onsdag\", \"torsdag\", \"fredag\", \"l\u00f6rdag\" ],\n\tdayNamesMin: [ \"s\u00f6\", \"m\u00e5\", \"ti\", \"on\", \"to\", \"fr\", \"l\u00f6\" ],\n\tweekHeader: \"Ve\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sv );\n\nreturn datepicker.regional.sv;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hi.js":"/* Hindi initialisation for the jQuery UI date picker plugin. */\n/* Written by Michael Dawart. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hi = {\n\tcloseText: \"\u092c\u0902\u0926\",\n\tprevText: \"\u092a\u093f\u091b\u0932\u093e\",\n\tnextText: \"\u0905\u0917\u0932\u093e\",\n\tcurrentText: \"\u0906\u091c\",\n\tmonthNames: [ \"\u091c\u0928\u0935\u0930\u0940 \", \"\u092b\u0930\u0935\u0930\u0940\", \"\u092e\u093e\u0930\u094d\u091a\", \"\u0905\u092a\u094d\u0930\u0947\u0932\", \"\u092e\u0908\", \"\u091c\u0942\u0928\",\n\t\"\u091c\u0942\u0932\u093e\u0908\", \"\u0905\u0917\u0938\u094d\u0924 \", \"\u0938\u093f\u0924\u092e\u094d\u092c\u0930\", \"\u0905\u0915\u094d\u091f\u0942\u092c\u0930\", \"\u0928\u0935\u092e\u094d\u092c\u0930\", \"\u0926\u093f\u0938\u092e\u094d\u092c\u0930\" ],\n\tmonthNamesShort: [ \"\u091c\u0928\", \"\u092b\u0930\", \"\u092e\u093e\u0930\u094d\u091a\", \"\u0905\u092a\u094d\u0930\u0947\u0932\", \"\u092e\u0908\", \"\u091c\u0942\u0928\",\n\t\"\u091c\u0942\u0932\u093e\u0908\", \"\u0905\u0917\", \"\u0938\u093f\u0924\", \"\u0905\u0915\u094d\u091f\", \"\u0928\u0935\", \"\u0926\u093f\" ],\n\tdayNames: [ \"\u0930\u0935\u093f\u0935\u093e\u0930\", \"\u0938\u094b\u092e\u0935\u093e\u0930\", \"\u092e\u0902\u0917\u0932\u0935\u093e\u0930\", \"\u092c\u0941\u0927\u0935\u093e\u0930\", \"\u0917\u0941\u0930\u0941\u0935\u093e\u0930\", \"\u0936\u0941\u0915\u094d\u0930\u0935\u093e\u0930\", \"\u0936\u0928\u093f\u0935\u093e\u0930\" ],\n\tdayNamesShort: [ \"\u0930\u0935\u093f\", \"\u0938\u094b\u092e\", \"\u092e\u0902\u0917\u0932\", \"\u092c\u0941\u0927\", \"\u0917\u0941\u0930\u0941\", \"\u0936\u0941\u0915\u094d\u0930\", \"\u0936\u0928\u093f\" ],\n\tdayNamesMin: [ \"\u0930\u0935\u093f\", \"\u0938\u094b\u092e\", \"\u092e\u0902\u0917\u0932\", \"\u092c\u0941\u0927\", \"\u0917\u0941\u0930\u0941\", \"\u0936\u0941\u0915\u094d\u0930\", \"\u0936\u0928\u093f\" ],\n\tweekHeader: \"\u0939\u092b\u094d\u0924\u093e\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hi );\n\nreturn datepicker.regional.hi;\n\n} );\n","jquery/ui-modules/i18n/datepicker-uk.js":"/* Ukrainian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Maxim Drogobitskiy (maxdao@gmail.com). */\n/* Corrected by Igor Milla (igor.fsp.milla@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.uk = {\n\tcloseText: \"\u0417\u0430\u043a\u0440\u0438\u0442\u0438\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456\",\n\tmonthNames: [ \"\u0421\u0456\u0447\u0435\u043d\u044c\", \"\u041b\u044e\u0442\u0438\u0439\", \"\u0411\u0435\u0440\u0435\u0437\u0435\u043d\u044c\", \"\u041a\u0432\u0456\u0442\u0435\u043d\u044c\", \"\u0422\u0440\u0430\u0432\u0435\u043d\u044c\", \"\u0427\u0435\u0440\u0432\u0435\u043d\u044c\",\n\t\"\u041b\u0438\u043f\u0435\u043d\u044c\", \"\u0421\u0435\u0440\u043f\u0435\u043d\u044c\", \"\u0412\u0435\u0440\u0435\u0441\u0435\u043d\u044c\", \"\u0416\u043e\u0432\u0442\u0435\u043d\u044c\", \"\u041b\u0438\u0441\u0442\u043e\u043f\u0430\u0434\", \"\u0413\u0440\u0443\u0434\u0435\u043d\u044c\" ],\n\tmonthNamesShort: [ \"\u0421\u0456\u0447\", \"\u041b\u044e\u0442\", \"\u0411\u0435\u0440\", \"\u041a\u0432\u0456\", \"\u0422\u0440\u0430\", \"\u0427\u0435\u0440\",\n\t\"\u041b\u0438\u043f\", \"\u0421\u0435\u0440\", \"\u0412\u0435\u0440\", \"\u0416\u043e\u0432\", \"\u041b\u0438\u0441\", \"\u0413\u0440\u0443\" ],\n\tdayNames: [ \"\u043d\u0435\u0434\u0456\u043b\u044f\", \"\u043f\u043e\u043d\u0435\u0434\u0456\u043b\u043e\u043a\", \"\u0432\u0456\u0432\u0442\u043e\u0440\u043e\u043a\", \"\u0441\u0435\u0440\u0435\u0434\u0430\", \"\u0447\u0435\u0442\u0432\u0435\u0440\", \"\u043f\u2019\u044f\u0442\u043d\u0438\u0446\u044f\", \"\u0441\u0443\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u043d\u0435\u0434\", \"\u043f\u043d\u0434\", \"\u0432\u0456\u0432\", \"\u0441\u0440\u0434\", \"\u0447\u0442\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u041d\u0434\", \"\u041f\u043d\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0442\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u0422\u0438\u0436\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.uk );\n\nreturn datepicker.regional.uk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-cs.js":"/* Czech initialisation for the jQuery UI date picker plugin. */\n/* Written by Tomas Muller (tomas@tomas-muller.net). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.cs = {\n\tcloseText: \"Zav\u0159\u00edt\",\n\tprevText: \"&#x3C;D\u0159\u00edve\",\n\tnextText: \"Pozd\u011bji&#x3E;\",\n\tcurrentText: \"Nyn\u00ed\",\n\tmonthNames: [ \"leden\", \"\u00fanor\", \"b\u0159ezen\", \"duben\", \"kv\u011bten\", \"\u010derven\",\n\t\"\u010dervenec\", \"srpen\", \"z\u00e1\u0159\u00ed\", \"\u0159\u00edjen\", \"listopad\", \"prosinec\" ],\n\tmonthNamesShort: [ \"led\", \"\u00fano\", \"b\u0159e\", \"dub\", \"kv\u011b\", \"\u010der\",\n\t\"\u010dvc\", \"srp\", \"z\u00e1\u0159\", \"\u0159\u00edj\", \"lis\", \"pro\" ],\n\tdayNames: [ \"ned\u011ble\", \"pond\u011bl\u00ed\", \"\u00fater\u00fd\", \"st\u0159eda\", \"\u010dtvrtek\", \"p\u00e1tek\", \"sobota\" ],\n\tdayNamesShort: [ \"ne\", \"po\", \"\u00fat\", \"st\", \"\u010dt\", \"p\u00e1\", \"so\" ],\n\tdayNamesMin: [ \"ne\", \"po\", \"\u00fat\", \"st\", \"\u010dt\", \"p\u00e1\", \"so\" ],\n\tweekHeader: \"T\u00fdd\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.cs );\n\nreturn datepicker.regional.cs;\n\n} );\n","jquery/ui-modules/i18n/datepicker-km.js":"/* Khmer initialisation for the jQuery calendar extension. */\n/* Written by Chandara Om (chandara.teacher@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.km = {\n\tcloseText: \"\u1792\u17d2\u179c\u17be\u200b\u179a\u17bd\u1785\",\n\tprevText: \"\u1798\u17bb\u1793\",\n\tnextText: \"\u1794\u1793\u17d2\u1791\u17b6\u1794\u17cb\",\n\tcurrentText: \"\u1790\u17d2\u1784\u17c3\u200b\u1793\u17c1\u17c7\",\n\tmonthNames: [ \"\u1798\u1780\u179a\u17b6\", \"\u1780\u17bb\u1798\u17d2\u1797\u17c8\", \"\u1798\u17b8\u1793\u17b6\", \"\u1798\u17c1\u179f\u17b6\", \"\u17a7\u179f\u1797\u17b6\", \"\u1798\u17b7\u1790\u17bb\u1793\u17b6\",\n\t\"\u1780\u1780\u17d2\u1780\u178a\u17b6\", \"\u179f\u17b8\u17a0\u17b6\", \"\u1780\u1789\u17d2\u1789\u17b6\", \"\u178f\u17bb\u179b\u17b6\", \"\u179c\u17b7\u1785\u17d2\u1786\u17b7\u1780\u17b6\", \"\u1792\u17d2\u1793\u17bc\" ],\n\tmonthNamesShort: [ \"\u1798\u1780\u179a\u17b6\", \"\u1780\u17bb\u1798\u17d2\u1797\u17c8\", \"\u1798\u17b8\u1793\u17b6\", \"\u1798\u17c1\u179f\u17b6\", \"\u17a7\u179f\u1797\u17b6\", \"\u1798\u17b7\u1790\u17bb\u1793\u17b6\",\n\t\"\u1780\u1780\u17d2\u1780\u178a\u17b6\", \"\u179f\u17b8\u17a0\u17b6\", \"\u1780\u1789\u17d2\u1789\u17b6\", \"\u178f\u17bb\u179b\u17b6\", \"\u179c\u17b7\u1785\u17d2\u1786\u17b7\u1780\u17b6\", \"\u1792\u17d2\u1793\u17bc\" ],\n\tdayNames: [ \"\u17a2\u17b6\u1791\u17b7\u178f\u17d2\u1799\", \"\u1785\u1793\u17d2\u1791\", \"\u17a2\u1784\u17d2\u1782\u17b6\u179a\", \"\u1796\u17bb\u1792\", \"\u1796\u17d2\u179a\u17a0\u179f\u17d2\u1794\u178f\u17b7\u17cd\", \"\u179f\u17bb\u1780\u17d2\u179a\", \"\u179f\u17c5\u179a\u17cd\" ],\n\tdayNamesShort: [ \"\u17a2\u17b6\", \"\u1785\", \"\u17a2\", \"\u1796\u17bb\", \"\u1796\u17d2\u179a\u17a0\", \"\u179f\u17bb\", \"\u179f\u17c5\" ],\n\tdayNamesMin: [ \"\u17a2\u17b6\", \"\u1785\", \"\u17a2\", \"\u1796\u17bb\", \"\u1796\u17d2\u179a\u17a0\", \"\u179f\u17bb\", \"\u179f\u17c5\" ],\n\tweekHeader: \"\u179f\u1794\u17d2\u178a\u17b6\u17a0\u17cd\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.km );\n\nreturn datepicker.regional.km;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr.js":"/* French initialisation for the jQuery UI date picker plugin. */\n/* Written by Keith Wood (kbwood{at}iinet.com.au),\n\t\t\t  St\u00e9phane Nahmani (sholby@sholby.net),\n\t\t\t  St\u00e9phane Raimbault <stephane.raimbault@gmail.com> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fr = {\n\tcloseText: \"Fermer\",\n\tprevText: \"Pr\u00e9c\u00e9dent\",\n\tnextText: \"Suivant\",\n\tcurrentText: \"Aujourd'hui\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avr.\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sem.\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fr );\n\nreturn datepicker.regional.fr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nl.js":"/* Dutch (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Mathias Bynens <http://mathiasbynens.be/> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.nl = {\n\tcloseText: \"Sluiten\",\n\tprevText: \"\u2190\",\n\tnextText: \"\u2192\",\n\tcurrentText: \"Vandaag\",\n\tmonthNames: [ \"januari\", \"februari\", \"maart\", \"april\", \"mei\", \"juni\",\n\t\"juli\", \"augustus\", \"september\", \"oktober\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mrt\", \"apr\", \"mei\", \"jun\",\n\t\"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"dec\" ],\n\tdayNames: [ \"zondag\", \"maandag\", \"dinsdag\", \"woensdag\", \"donderdag\", \"vrijdag\", \"zaterdag\" ],\n\tdayNamesShort: [ \"zon\", \"maa\", \"din\", \"woe\", \"don\", \"vri\", \"zat\" ],\n\tdayNamesMin: [ \"zo\", \"ma\", \"di\", \"wo\", \"do\", \"vr\", \"za\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.nl );\n\nreturn datepicker.regional.nl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fa.js":"/* Persian (Farsi) Translation for the jQuery UI date picker plugin. */\n/* Javad Mowlanezhad -- jmowla@gmail.com */\n/* Jalali calendar should supported soon! (Its implemented but I have to test it) */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fa = {\n\tcloseText: \"\u0628\u0633\u062a\u0646\",\n\tprevText: \"&#x3C;\u0642\u0628\u0644\u06cc\",\n\tnextText: \"\u0628\u0639\u062f\u06cc&#x3E;\",\n\tcurrentText: \"\u0627\u0645\u0631\u0648\u0632\",\n\tmonthNames: [\n\t\t\"\u0698\u0627\u0646\u0648\u06cc\u0647\",\n\t\t\"\u0641\u0648\u0631\u06cc\u0647\",\n\t\t\"\u0645\u0627\u0631\u0633\",\n\t\t\"\u0622\u0648\u0631\u06cc\u0644\",\n\t\t\"\u0645\u0647\",\n\t\t\"\u0698\u0648\u0626\u0646\",\n\t\t\"\u0698\u0648\u0626\u06cc\u0647\",\n\t\t\"\u0627\u0648\u062a\",\n\t\t\"\u0633\u067e\u062a\u0627\u0645\u0628\u0631\",\n\t\t\"\u0627\u06a9\u062a\u0628\u0631\",\n\t\t\"\u0646\u0648\u0627\u0645\u0628\u0631\",\n\t\t\"\u062f\u0633\u0627\u0645\u0628\u0631\"\n\t],\n\tmonthNamesShort: [ \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"10\", \"11\", \"12\" ],\n\tdayNames: [\n\t\t\"\u064a\u06a9\u0634\u0646\u0628\u0647\",\n\t\t\"\u062f\u0648\u0634\u0646\u0628\u0647\",\n\t\t\"\u0633\u0647\u200c\u0634\u0646\u0628\u0647\",\n\t\t\"\u0686\u0647\u0627\u0631\u0634\u0646\u0628\u0647\",\n\t\t\"\u067e\u0646\u062c\u0634\u0646\u0628\u0647\",\n\t\t\"\u062c\u0645\u0639\u0647\",\n\t\t\"\u0634\u0646\u0628\u0647\"\n\t],\n\tdayNamesShort: [\n\t\t\"\u06cc\",\n\t\t\"\u062f\",\n\t\t\"\u0633\",\n\t\t\"\u0686\",\n\t\t\"\u067e\",\n\t\t\"\u062c\",\n\t\t\"\u0634\"\n\t],\n\tdayNamesMin: [\n\t\t\"\u06cc\",\n\t\t\"\u062f\",\n\t\t\"\u0633\",\n\t\t\"\u0686\",\n\t\t\"\u067e\",\n\t\t\"\u062c\",\n\t\t\"\u0634\"\n\t],\n\tweekHeader: \"\u0647\u0641\",\n\tdateFormat: \"yy/mm/dd\",\n\tfirstDay: 6,\n\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fa );\n\nreturn datepicker.regional.fa;\n\n} );\n","jquery/ui-modules/i18n/datepicker-de.js":"/* German initialisation for the jQuery UI date picker plugin. */\n/* Written by Milian Wolff (mail@milianw.de). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.de = {\n\tcloseText: \"Schlie\u00dfen\",\n\tprevText: \"&#x3C;Zur\u00fcck\",\n\tnextText: \"Vor&#x3E;\",\n\tcurrentText: \"Heute\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"M\u00e4rz\", \"April\", \"Mai\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Dezember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"M\u00e4r\", \"Apr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dez\" ],\n\tdayNames: [ \"Sonntag\", \"Montag\", \"Dienstag\", \"Mittwoch\", \"Donnerstag\", \"Freitag\", \"Samstag\" ],\n\tdayNamesShort: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tdayNamesMin: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"KW\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.de );\n\nreturn datepicker.regional.de;\n\n} );\n","jquery/ui-modules/i18n/datepicker-da.js":"/* Danish initialisation for the jQuery UI date picker plugin. */\n/* Written by Jan Christensen ( deletestuff@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.da = {\n\tcloseText: \"Luk\",\n\tprevText: \"&#x3C;Forrige\",\n\tnextText: \"N\u00e6ste&#x3E;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Marts\", \"April\", \"Maj\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"S\u00f8ndag\", \"Mandag\", \"Tirsdag\", \"Onsdag\", \"Torsdag\", \"Fredag\", \"L\u00f8rdag\" ],\n\tdayNamesShort: [ \"S\u00f8n\", \"Man\", \"Tir\", \"Ons\", \"Tor\", \"Fre\", \"L\u00f8r\" ],\n\tdayNamesMin: [ \"S\u00f8\", \"Ma\", \"Ti\", \"On\", \"To\", \"Fr\", \"L\u00f8\" ],\n\tweekHeader: \"Uge\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.da );\n\nreturn datepicker.regional.da;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nb.js":"/* Norwegian Bokm\u00e5l initialisation for the jQuery UI date picker plugin. */\n/* Written by Bj\u00f8rn Johansen (post@bjornjohansen.no). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.nb = {\n\tcloseText: \"Lukk\",\n\tprevText: \"&#xAB;Forrige\",\n\tnextText: \"Neste&#xBB;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [\n\t\t\"januar\",\n\t\t\"februar\",\n\t\t\"mars\",\n\t\t\"april\",\n\t\t\"mai\",\n\t\t\"juni\",\n\t\t\"juli\",\n\t\t\"august\",\n\t\t\"september\",\n\t\t\"oktober\",\n\t\t\"november\",\n\t\t\"desember\"\n\t],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mar\", \"apr\", \"mai\", \"jun\", \"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"des\" ],\n\tdayNamesShort: [ \"s\u00f8n\", \"man\", \"tir\", \"ons\", \"tor\", \"fre\", \"l\u00f8r\" ],\n\tdayNames: [ \"s\u00f8ndag\", \"mandag\", \"tirsdag\", \"onsdag\", \"torsdag\", \"fredag\", \"l\u00f8rdag\" ],\n\tdayNamesMin: [ \"s\u00f8\", \"ma\", \"ti\", \"on\", \"to\", \"fr\", \"l\u00f8\" ],\n\tweekHeader: \"Uke\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.nb );\n\nreturn datepicker.regional.nb;\n\n} );\n","jquery/ui-modules/i18n/datepicker-be.js":"/* Belarusian initialisation for the jQuery UI date picker plugin. */\n/* Written by Pavel Selitskas <p.selitskas@gmail.com> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.be = {\n\tcloseText: \"\u0417\u0430\u0447\u044b\u043d\u0456\u0446\u044c\",\n\tprevText: \"&larr;\u041f\u0430\u043f\u044f\u0440.\",\n\tnextText: \"\u041d\u0430\u0441\u0442.&rarr;\",\n\tcurrentText: \"\u0421\u0451\u043d\u044c\u043d\u044f\",\n\tmonthNames: [ \"\u0421\u0442\u0443\u0434\u0437\u0435\u043d\u044c\", \"\u041b\u044e\u0442\u044b\", \"\u0421\u0430\u043a\u0430\u0432\u0456\u043a\", \"\u041a\u0440\u0430\u0441\u0430\u0432\u0456\u043a\", \"\u0422\u0440\u0430\u0432\u0435\u043d\u044c\", \"\u0427\u044d\u0440\u0432\u0435\u043d\u044c\",\n\t\"\u041b\u0456\u043f\u0435\u043d\u044c\", \"\u0416\u043d\u0456\u0432\u0435\u043d\u044c\", \"\u0412\u0435\u0440\u0430\u0441\u0435\u043d\u044c\", \"\u041a\u0430\u0441\u0442\u0440\u044b\u0447\u043d\u0456\u043a\", \"\u041b\u0456\u0441\u0442\u0430\u043f\u0430\u0434\", \"\u0421\u044c\u043d\u0435\u0436\u0430\u043d\u044c\" ],\n\tmonthNamesShort: [ \"\u0421\u0442\u0443\", \"\u041b\u044e\u0442\", \"\u0421\u0430\u043a\", \"\u041a\u0440\u0430\", \"\u0422\u0440\u0430\", \"\u0427\u044d\u0440\",\n\t\"\u041b\u0456\u043f\", \"\u0416\u043d\u0456\", \"\u0412\u0435\u0440\", \"\u041a\u0430\u0441\", \"\u041b\u0456\u0441\", \"\u0421\u044c\u043d\" ],\n\tdayNames: [ \"\u043d\u044f\u0434\u0437\u0435\u043b\u044f\", \"\u043f\u0430\u043d\u044f\u0434\u0437\u0435\u043b\u0430\u043a\", \"\u0430\u045e\u0442\u043e\u0440\u0430\u043a\", \"\u0441\u0435\u0440\u0430\u0434\u0430\", \"\u0447\u0430\u0446\u044c\u0432\u0435\u0440\", \"\u043f\u044f\u0442\u043d\u0456\u0446\u0430\", \"\u0441\u0443\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u043d\u0434\u0437\", \"\u043f\u043d\u0434\", \"\u0430\u045e\u0442\", \"\u0441\u0440\u0434\", \"\u0447\u0446\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u041d\u0434\", \"\u041f\u043d\", \"\u0410\u045e\", \"\u0421\u0440\", \"\u0427\u0446\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u0422\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.be );\n\nreturn datepicker.regional.be;\n\n} );\n","jquery/ui-modules/i18n/datepicker-lb.js":"/* Luxembourgish initialisation for the jQuery UI date picker plugin. */\n/* Written by Michel Weimerskirch <michel@weimerskirch.net> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.lb = {\n\tcloseText: \"F\u00e4erdeg\",\n\tprevText: \"Zr\u00e9ck\",\n\tnextText: \"Weider\",\n\tcurrentText: \"Haut\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"M\u00e4erz\", \"Abr\u00ebll\", \"Mee\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Dezember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"M\u00e4e\", \"Abr\", \"Mee\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dez\" ],\n\tdayNames: [\n\t\t\"Sonndeg\",\n\t\t\"M\u00e9indeg\",\n\t\t\"D\u00ebnschdeg\",\n\t\t\"M\u00ebttwoch\",\n\t\t\"Donneschdeg\",\n\t\t\"Freideg\",\n\t\t\"Samschdeg\"\n\t],\n\tdayNamesShort: [ \"Son\", \"M\u00e9i\", \"D\u00ebn\", \"M\u00ebt\", \"Don\", \"Fre\", \"Sam\" ],\n\tdayNamesMin: [ \"So\", \"M\u00e9\", \"D\u00eb\", \"M\u00eb\", \"Do\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"W\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.lb );\n\nreturn datepicker.regional.lb;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ca.js":"/* Inicialitzaci\u00f3 en catal\u00e0 per a l'extensi\u00f3 'UI date picker' per jQuery. */\n/* Writers: (joan.leon@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ca = {\n\tcloseText: \"Tanca\",\n\tprevText: \"Anterior\",\n\tnextText: \"Seg\u00fcent\",\n\tcurrentText: \"Avui\",\n\tmonthNames: [ \"gener\", \"febrer\", \"mar\u00e7\", \"abril\", \"maig\", \"juny\",\n\t\"juliol\", \"agost\", \"setembre\", \"octubre\", \"novembre\", \"desembre\" ],\n\tmonthNamesShort: [ \"gen\", \"feb\", \"mar\u00e7\", \"abr\", \"maig\", \"juny\",\n\t\"jul\", \"ag\", \"set\", \"oct\", \"nov\", \"des\" ],\n\tdayNames: [ \"diumenge\", \"dilluns\", \"dimarts\", \"dimecres\", \"dijous\", \"divendres\", \"dissabte\" ],\n\tdayNamesShort: [ \"dg\", \"dl\", \"dt\", \"dc\", \"dj\", \"dv\", \"ds\" ],\n\tdayNamesMin: [ \"dg\", \"dl\", \"dt\", \"dc\", \"dj\", \"dv\", \"ds\" ],\n\tweekHeader: \"Set\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ca );\n\nreturn datepicker.regional.ca;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ta.js":"/* Tamil (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by S A Sureshkumar (saskumar@live.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ta = {\n\tcloseText: \"\u0bae\u0bc2\u0b9f\u0bc1\",\n\tprevText: \"\u0bae\u0bc1\u0ba9\u0bcd\u0ba9\u0bc8\u0baf\u0ba4\u0bc1\",\n\tnextText: \"\u0b85\u0b9f\u0bc1\u0ba4\u0bcd\u0ba4\u0ba4\u0bc1\",\n\tcurrentText: \"\u0b87\u0ba9\u0bcd\u0bb1\u0bc1\",\n\tmonthNames: [ \"\u0ba4\u0bc8\", \"\u0bae\u0bbe\u0b9a\u0bbf\", \"\u0baa\u0b99\u0bcd\u0b95\u0bc1\u0ba9\u0bbf\", \"\u0b9a\u0bbf\u0ba4\u0bcd\u0ba4\u0bbf\u0bb0\u0bc8\", \"\u0bb5\u0bc8\u0b95\u0bbe\u0b9a\u0bbf\", \"\u0b86\u0ba9\u0bbf\",\n\t\"\u0b86\u0b9f\u0bbf\", \"\u0b86\u0bb5\u0ba3\u0bbf\", \"\u0baa\u0bc1\u0bb0\u0b9f\u0bcd\u0b9f\u0bbe\u0b9a\u0bbf\", \"\u0b90\u0baa\u0bcd\u0baa\u0b9a\u0bbf\", \"\u0b95\u0bbe\u0bb0\u0bcd\u0ba4\u0bcd\u0ba4\u0bbf\u0b95\u0bc8\", \"\u0bae\u0bbe\u0bb0\u0bcd\u0b95\u0bb4\u0bbf\" ],\n\tmonthNamesShort: [ \"\u0ba4\u0bc8\", \"\u0bae\u0bbe\u0b9a\u0bbf\", \"\u0baa\u0b99\u0bcd\", \"\u0b9a\u0bbf\u0ba4\u0bcd\", \"\u0bb5\u0bc8\u0b95\u0bbe\", \"\u0b86\u0ba9\u0bbf\",\n\t\"\u0b86\u0b9f\u0bbf\", \"\u0b86\u0bb5\", \"\u0baa\u0bc1\u0bb0\", \"\u0b90\u0baa\u0bcd\", \"\u0b95\u0bbe\u0bb0\u0bcd\", \"\u0bae\u0bbe\u0bb0\u0bcd\" ],\n\tdayNames: [\n\t\t\"\u0b9e\u0bbe\u0baf\u0bbf\u0bb1\u0bcd\u0bb1\u0bc1\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0ba4\u0bbf\u0b99\u0bcd\u0b95\u0b9f\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0b9a\u0bc6\u0bb5\u0bcd\u0bb5\u0bbe\u0baf\u0bcd\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0baa\u0bc1\u0ba4\u0ba9\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0bb5\u0bbf\u0baf\u0bbe\u0bb4\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0bb5\u0bc6\u0bb3\u0bcd\u0bb3\u0bbf\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0b9a\u0ba9\u0bbf\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\"\n\t],\n\tdayNamesShort: [\n\t\t\"\u0b9e\u0bbe\u0baf\u0bbf\u0bb1\u0bc1\",\n\t\t\"\u0ba4\u0bbf\u0b99\u0bcd\u0b95\u0bb3\u0bcd\",\n\t\t\"\u0b9a\u0bc6\u0bb5\u0bcd\u0bb5\u0bbe\u0baf\u0bcd\",\n\t\t\"\u0baa\u0bc1\u0ba4\u0ba9\u0bcd\",\n\t\t\"\u0bb5\u0bbf\u0baf\u0bbe\u0bb4\u0ba9\u0bcd\",\n\t\t\"\u0bb5\u0bc6\u0bb3\u0bcd\u0bb3\u0bbf\",\n\t\t\"\u0b9a\u0ba9\u0bbf\"\n\t],\n\tdayNamesMin: [ \"\u0b9e\u0bbe\", \"\u0ba4\u0bbf\", \"\u0b9a\u0bc6\", \"\u0baa\u0bc1\", \"\u0bb5\u0bbf\", \"\u0bb5\u0bc6\", \"\u0b9a\" ],\n\tweekHeader: \"\u041d\u0435\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ta );\n\nreturn datepicker.regional.ta;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr-CH.js":"/* Swiss-French initialisation for the jQuery UI date picker plugin. */\n/* Written Martin Voelkle (martin.voelkle@e-tc.ch). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"fr-CH\" ] = {\n\tcloseText: \"Fermer\",\n\tprevText: \"&#x3C;Pr\u00e9c\",\n\tnextText: \"Suiv&#x3E;\",\n\tcurrentText: \"Courant\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"fr-CH\" ] );\n\nreturn datepicker.regional[ \"fr-CH\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-cy-GB.js":"/* Welsh/UK initialisation for the jQuery UI date picker plugin. */\n/* Written by William Griffiths. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"cy-GB\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"Ionawr\", \"Chwefror\", \"Mawrth\", \"Ebrill\", \"Mai\", \"Mehefin\",\n\t\"Gorffennaf\", \"Awst\", \"Medi\", \"Hydref\", \"Tachwedd\", \"Rhagfyr\" ],\n\tmonthNamesShort: [ \"Ion\", \"Chw\", \"Maw\", \"Ebr\", \"Mai\", \"Meh\",\n\t\"Gor\", \"Aws\", \"Med\", \"Hyd\", \"Tac\", \"Rha\" ],\n\tdayNames: [\n\t\t\"Dydd Sul\",\n\t\t\"Dydd Llun\",\n\t\t\"Dydd Mawrth\",\n\t\t\"Dydd Mercher\",\n\t\t\"Dydd Iau\",\n\t\t\"Dydd Gwener\",\n\t\t\"Dydd Sadwrn\"\n\t],\n\tdayNamesShort: [ \"Sul\", \"Llu\", \"Maw\", \"Mer\", \"Iau\", \"Gwe\", \"Sad\" ],\n\tdayNamesMin: [ \"Su\", \"Ll\", \"Ma\", \"Me\", \"Ia\", \"Gw\", \"Sa\" ],\n\tweekHeader: \"Wy\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"cy-GB\" ] );\n\nreturn datepicker.regional[ \"cy-GB\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-zh-HK.js":"/* Chinese initialisation for the jQuery UI date picker plugin. */\n/* Written by SCCY (samuelcychan@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"zh-HK\" ] = {\n\tcloseText: \"\u95dc\u9589\",\n\tprevText: \"&#x3C;\u4e0a\u6708\",\n\tnextText: \"\u4e0b\u6708&#x3E;\",\n\tcurrentText: \"\u4eca\u5929\",\n\tmonthNames: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tmonthNamesShort: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tdayNames: [ \"\u661f\u671f\u65e5\", \"\u661f\u671f\u4e00\", \"\u661f\u671f\u4e8c\", \"\u661f\u671f\u4e09\", \"\u661f\u671f\u56db\", \"\u661f\u671f\u4e94\", \"\u661f\u671f\u516d\" ],\n\tdayNamesShort: [ \"\u5468\u65e5\", \"\u5468\u4e00\", \"\u5468\u4e8c\", \"\u5468\u4e09\", \"\u5468\u56db\", \"\u5468\u4e94\", \"\u5468\u516d\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u4e00\", \"\u4e8c\", \"\u4e09\", \"\u56db\", \"\u4e94\", \"\u516d\" ],\n\tweekHeader: \"\u5468\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional[ \"zh-HK\" ] );\n\nreturn datepicker.regional[ \"zh-HK\" ];\n\n} );\n","jquery/ui-modules/effects/effect-pulsate.js":"/*!\n * jQuery UI Effects Pulsate 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Pulsate Effect\n//>>group: Effects\n//>>description: Pulsates an element n times by changing the opacity to zero and back.\n//>>docs: http://api.jqueryui.com/pulsate-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"pulsate\", \"show\", function( options, done ) {\n        var element = $( this ),\n            mode = options.mode,\n            show = mode === \"show\",\n            hide = mode === \"hide\",\n            showhide = show || hide,\n\n            // Showing or hiding leaves off the \"last\" animation\n            anims = ( ( options.times || 5 ) * 2 ) + ( showhide ? 1 : 0 ),\n            duration = options.duration / anims,\n            animateTo = 0,\n            i = 1,\n            queuelen = element.queue().length;\n\n        if ( show || !element.is( \":visible\" ) ) {\n            element.css( \"opacity\", 0 ).show();\n            animateTo = 1;\n        }\n\n        // Anims - 1 opacity \"toggles\"\n        for ( ; i < anims; i++ ) {\n            element.animate( { opacity: animateTo }, duration, options.easing );\n            animateTo = 1 - animateTo;\n        }\n\n        element.animate( { opacity: animateTo }, duration, options.easing );\n\n        element.queue( done );\n\n        $.effects.unshift( element, queuelen, anims + 1 );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-fade.js":"/*!\n * jQuery UI Effects Fade 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Fade Effect\n//>>group: Effects\n//>>description: Fades the element.\n//>>docs: http://api.jqueryui.com/fade-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"fade\", \"toggle\", function( options, done ) {\n        var show = options.mode === \"show\";\n\n        $( this )\n            .css( \"opacity\", show ? 0 : 1 )\n            .animate( {\n                opacity: show ? 1 : 0\n            }, {\n                queue: false,\n                duration: options.duration,\n                easing: options.easing,\n                complete: done\n            } );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-clip.js":"/*!\n * jQuery UI Effects Clip 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Clip Effect\n//>>group: Effects\n//>>description: Clips the element on and off like an old TV.\n//>>docs: http://api.jqueryui.com/clip-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"clip\", \"hide\", function( options, done ) {\n        var start,\n            animate = {},\n            element = $( this ),\n            direction = options.direction || \"vertical\",\n            both = direction === \"both\",\n            horizontal = both || direction === \"horizontal\",\n            vertical = both || direction === \"vertical\";\n\n        start = element.cssClip();\n        animate.clip = {\n            top: vertical ? ( start.bottom - start.top ) / 2 : start.top,\n            right: horizontal ? ( start.right - start.left ) / 2 : start.right,\n            bottom: vertical ? ( start.bottom - start.top ) / 2 : start.bottom,\n            left: horizontal ? ( start.right - start.left ) / 2 : start.left\n        };\n\n        $.effects.createPlaceholder( element );\n\n        if ( options.mode === \"show\" ) {\n            element.cssClip( animate.clip );\n            animate.clip = start;\n        }\n\n        element.animate( animate, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: done\n        } );\n\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-fold.js":"/*!\n * jQuery UI Effects Fold 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Fold Effect\n//>>group: Effects\n//>>description: Folds an element first horizontally and then vertically.\n//>>docs: http://api.jqueryui.com/fold-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"fold\", \"hide\", function( options, done ) {\n\n        // Create element\n        var element = $( this ),\n            mode = options.mode,\n            show = mode === \"show\",\n            hide = mode === \"hide\",\n            size = options.size || 15,\n            percent = /([0-9]+)%/.exec( size ),\n            horizFirst = !!options.horizFirst,\n            ref = horizFirst ? [ \"right\", \"bottom\" ] : [ \"bottom\", \"right\" ],\n            duration = options.duration / 2,\n\n            placeholder = $.effects.createPlaceholder( element ),\n\n            start = element.cssClip(),\n            animation1 = { clip: $.extend( {}, start ) },\n            animation2 = { clip: $.extend( {}, start ) },\n\n            distance = [ start[ ref[ 0 ] ], start[ ref[ 1 ] ] ],\n\n            queuelen = element.queue().length;\n\n        if ( percent ) {\n            size = parseInt( percent[ 1 ], 10 ) / 100 * distance[ hide ? 0 : 1 ];\n        }\n        animation1.clip[ ref[ 0 ] ] = size;\n        animation2.clip[ ref[ 0 ] ] = size;\n        animation2.clip[ ref[ 1 ] ] = 0;\n\n        if ( show ) {\n            element.cssClip( animation2.clip );\n            if ( placeholder ) {\n                placeholder.css( $.effects.clipToBox( animation2 ) );\n            }\n\n            animation2.clip = start;\n        }\n\n        // Animate\n        element\n            .queue( function( next ) {\n                if ( placeholder ) {\n                    placeholder\n                        .animate( $.effects.clipToBox( animation1 ), duration, options.easing )\n                        .animate( $.effects.clipToBox( animation2 ), duration, options.easing );\n                }\n\n                next();\n            } )\n            .animate( animation1, duration, options.easing )\n            .animate( animation2, duration, options.easing )\n            .queue( done );\n\n        $.effects.unshift( element, queuelen, 4 );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-drop.js":"/*!\n * jQuery UI Effects Clip 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Clip Effect\n//>>group: Effects\n//>>description: Clips the element on and off like an old TV.\n//>>docs: http://api.jqueryui.com/clip-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"clip\", \"hide\", function( options, done ) {\n        var start,\n            animate = {},\n            element = $( this ),\n            direction = options.direction || \"vertical\",\n            both = direction === \"both\",\n            horizontal = both || direction === \"horizontal\",\n            vertical = both || direction === \"vertical\";\n\n        start = element.cssClip();\n        animate.clip = {\n            top: vertical ? ( start.bottom - start.top ) / 2 : start.top,\n            right: horizontal ? ( start.right - start.left ) / 2 : start.right,\n            bottom: vertical ? ( start.bottom - start.top ) / 2 : start.bottom,\n            left: horizontal ? ( start.right - start.left ) / 2 : start.left\n        };\n\n        $.effects.createPlaceholder( element );\n\n        if ( options.mode === \"show\" ) {\n            element.cssClip( animate.clip );\n            animate.clip = start;\n        }\n\n        element.animate( animate, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: done\n        } );\n\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-scale.js":"/*!\n * jQuery UI Effects Scale 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Scale Effect\n//>>group: Effects\n//>>description: Grows or shrinks an element and its content.\n//>>docs: http://api.jqueryui.com/scale-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\",\n            \"./effect-size\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"scale\", function( options, done ) {\n\n        // Create element\n        var el = $( this ),\n            mode = options.mode,\n            percent = parseInt( options.percent, 10 ) ||\n                ( parseInt( options.percent, 10 ) === 0 ? 0 : ( mode !== \"effect\" ? 0 : 100 ) ),\n\n            newOptions = $.extend( true, {\n                from: $.effects.scaledDimensions( el ),\n                to: $.effects.scaledDimensions( el, percent, options.direction || \"both\" ),\n                origin: options.origin || [ \"middle\", \"center\" ]\n            }, options );\n\n        // Fade option to support puff\n        if ( options.fade ) {\n            newOptions.from.opacity = 1;\n            newOptions.to.opacity = 0;\n        }\n\n        $.effects.effect.size.call( this, newOptions, done );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-explode.js":"/*!\n * jQuery UI Effects Explode 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Explode Effect\n//>>group: Effects\n/* eslint-disable max-len */\n//>>description: Explodes an element in all directions into n pieces. Implodes an element to its original wholeness.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/explode-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"explode\", \"hide\", function( options, done ) {\n\n        var i, j, left, top, mx, my,\n            rows = options.pieces ? Math.round( Math.sqrt( options.pieces ) ) : 3,\n            cells = rows,\n            element = $( this ),\n            mode = options.mode,\n            show = mode === \"show\",\n\n            // Show and then visibility:hidden the element before calculating offset\n            offset = element.show().css( \"visibility\", \"hidden\" ).offset(),\n\n            // Width and height of a piece\n            width = Math.ceil( element.outerWidth() / cells ),\n            height = Math.ceil( element.outerHeight() / rows ),\n            pieces = [];\n\n        // Children animate complete:\n        function childComplete() {\n            pieces.push( this );\n            if ( pieces.length === rows * cells ) {\n                animComplete();\n            }\n        }\n\n        // Clone the element for each row and cell.\n        for ( i = 0; i < rows; i++ ) { // ===>\n            top = offset.top + i * height;\n            my = i - ( rows - 1 ) / 2;\n\n            for ( j = 0; j < cells; j++ ) { // |||\n                left = offset.left + j * width;\n                mx = j - ( cells - 1 ) / 2;\n\n                // Create a clone of the now hidden main element that will be absolute positioned\n                // within a wrapper div off the -left and -top equal to size of our pieces\n                element\n                    .clone()\n                    .appendTo( \"body\" )\n                    .wrap( \"<div></div>\" )\n                    .css( {\n                        position: \"absolute\",\n                        visibility: \"visible\",\n                        left: -j * width,\n                        top: -i * height\n                    } )\n\n                    // Select the wrapper - make it overflow: hidden and absolute positioned based on\n                    // where the original was located +left and +top equal to the size of pieces\n                    .parent()\n                    .addClass( \"ui-effects-explode\" )\n                    .css( {\n                        position: \"absolute\",\n                        overflow: \"hidden\",\n                        width: width,\n                        height: height,\n                        left: left + ( show ? mx * width : 0 ),\n                        top: top + ( show ? my * height : 0 ),\n                        opacity: show ? 0 : 1\n                    } )\n                    .animate( {\n                        left: left + ( show ? 0 : mx * width ),\n                        top: top + ( show ? 0 : my * height ),\n                        opacity: show ? 1 : 0\n                    }, options.duration || 500, options.easing, childComplete );\n            }\n        }\n\n        function animComplete() {\n            element.css( {\n                visibility: \"visible\"\n            } );\n            $( pieces ).remove();\n            done();\n        }\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-puff.js":"/*!\n * jQuery UI Effects Puff 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Puff Effect\n//>>group: Effects\n//>>description: Creates a puff effect by scaling the element up and hiding it at the same time.\n//>>docs: http://api.jqueryui.com/puff-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\",\n            \"./effect-scale\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"puff\", \"hide\", function( options, done ) {\n        var newOptions = $.extend( true, {}, options, {\n            fade: true,\n            percent: parseInt( options.percent, 10 ) || 150\n        } );\n\n        $.effects.effect.scale.call( this, newOptions, done );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-transfer.js":"/*!\n * jQuery UI Effects Transfer 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Transfer Effect\n//>>group: Effects\n//>>description: Displays a transfer effect from one element to another.\n//>>docs: http://api.jqueryui.com/transfer-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var effect;\n    if ( $.uiBackCompat !== false ) {\n        effect = $.effects.define( \"transfer\", function( options, done ) {\n            $( this ).transfer( options, done );\n        } );\n    }\n    return effect;\n\n} );\n","jquery/ui-modules/effects/effect-bounce.js":"/*!\n * jQuery UI Effects Bounce 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Bounce Effect\n//>>group: Effects\n//>>description: Bounces an element horizontally or vertically n times.\n//>>docs: http://api.jqueryui.com/bounce-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"bounce\", function( options, done ) {\n        var upAnim, downAnim, refValue,\n            element = $( this ),\n\n            // Defaults:\n            mode = options.mode,\n            hide = mode === \"hide\",\n            show = mode === \"show\",\n            direction = options.direction || \"up\",\n            distance = options.distance,\n            times = options.times || 5,\n\n            // Number of internal animations\n            anims = times * 2 + ( show || hide ? 1 : 0 ),\n            speed = options.duration / anims,\n            easing = options.easing,\n\n            // Utility:\n            ref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n            motion = ( direction === \"up\" || direction === \"left\" ),\n            i = 0,\n\n            queuelen = element.queue().length;\n\n        $.effects.createPlaceholder( element );\n\n        refValue = element.css( ref );\n\n        // Default distance for the BIGGEST bounce is the outer Distance / 3\n        if ( !distance ) {\n            distance = element[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]() / 3;\n        }\n\n        if ( show ) {\n            downAnim = { opacity: 1 };\n            downAnim[ ref ] = refValue;\n\n            // If we are showing, force opacity 0 and set the initial position\n            // then do the \"first\" animation\n            element\n                .css( \"opacity\", 0 )\n                .css( ref, motion ? -distance * 2 : distance * 2 )\n                .animate( downAnim, speed, easing );\n        }\n\n        // Start at the smallest distance if we are hiding\n        if ( hide ) {\n            distance = distance / Math.pow( 2, times - 1 );\n        }\n\n        downAnim = {};\n        downAnim[ ref ] = refValue;\n\n        // Bounces up/down/left/right then back to 0 -- times * 2 animations happen here\n        for ( ; i < times; i++ ) {\n            upAnim = {};\n            upAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n            element\n                .animate( upAnim, speed, easing )\n                .animate( downAnim, speed, easing );\n\n            distance = hide ? distance * 2 : distance / 2;\n        }\n\n        // Last Bounce when Hiding\n        if ( hide ) {\n            upAnim = { opacity: 0 };\n            upAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n            element.animate( upAnim, speed, easing );\n        }\n\n        element.queue( done );\n\n        $.effects.unshift( element, queuelen, anims + 1 );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-blind.js":"/*!\n * jQuery UI Effects Blind 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Blind Effect\n//>>group: Effects\n//>>description: Blinds the element.\n//>>docs: http://api.jqueryui.com/blind-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"blind\", \"hide\", function( options, done ) {\n        var map = {\n                up: [ \"bottom\", \"top\" ],\n                vertical: [ \"bottom\", \"top\" ],\n                down: [ \"top\", \"bottom\" ],\n                left: [ \"right\", \"left\" ],\n                horizontal: [ \"right\", \"left\" ],\n                right: [ \"left\", \"right\" ]\n            },\n            element = $( this ),\n            direction = options.direction || \"up\",\n            start = element.cssClip(),\n            animate = { clip: $.extend( {}, start ) },\n            placeholder = $.effects.createPlaceholder( element );\n\n        animate.clip[ map[ direction ][ 0 ] ] = animate.clip[ map[ direction ][ 1 ] ];\n\n        if ( options.mode === \"show\" ) {\n            element.cssClip( animate.clip );\n            if ( placeholder ) {\n                placeholder.css( $.effects.clipToBox( animate ) );\n            }\n\n            animate.clip = start;\n        }\n\n        if ( placeholder ) {\n            placeholder.animate( $.effects.clipToBox( animate ), options.duration, options.easing );\n        }\n\n        element.animate( animate, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: done\n        } );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-slide.js":"/*!\n * jQuery UI Effects Slide 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Slide Effect\n//>>group: Effects\n//>>description: Slides an element in and out of the viewport.\n//>>docs: http://api.jqueryui.com/slide-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"slide\", \"show\", function( options, done ) {\n        var startClip, startRef,\n            element = $( this ),\n            map = {\n                up: [ \"bottom\", \"top\" ],\n                down: [ \"top\", \"bottom\" ],\n                left: [ \"right\", \"left\" ],\n                right: [ \"left\", \"right\" ]\n            },\n            mode = options.mode,\n            direction = options.direction || \"left\",\n            ref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n            positiveMotion = ( direction === \"up\" || direction === \"left\" ),\n            distance = options.distance ||\n                element[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]( true ),\n            animation = {};\n\n        $.effects.createPlaceholder( element );\n\n        startClip = element.cssClip();\n        startRef = element.position()[ ref ];\n\n        // Define hide animation\n        animation[ ref ] = ( positiveMotion ? -1 : 1 ) * distance + startRef;\n        animation.clip = element.cssClip();\n        animation.clip[ map[ direction ][ 1 ] ] = animation.clip[ map[ direction ][ 0 ] ];\n\n        // Reverse the animation if we're showing\n        if ( mode === \"show\" ) {\n            element.cssClip( animation.clip );\n            element.css( ref, animation[ ref ] );\n            animation.clip = startClip;\n            animation[ ref ] = startRef;\n        }\n\n        // Actually animate\n        element.animate( animation, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: done\n        } );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-highlight.js":"/*!\n * jQuery UI Effects Highlight 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Highlight Effect\n//>>group: Effects\n//>>description: Highlights the background of an element in a defined color for a custom duration.\n//>>docs: http://api.jqueryui.com/highlight-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"highlight\", \"show\", function( options, done ) {\n        var element = $( this ),\n            animation = {\n                backgroundColor: element.css( \"backgroundColor\" )\n            };\n\n        if ( options.mode === \"hide\" ) {\n            animation.opacity = 0;\n        }\n\n        $.effects.saveStyle( element );\n\n        element\n            .css( {\n                backgroundImage: \"none\",\n                backgroundColor: options.color || \"#ffff99\"\n            } )\n            .animate( animation, {\n                queue: false,\n                duration: options.duration,\n                easing: options.easing,\n                complete: done\n            } );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-size.js":"/*!\n * jQuery UI Effects Size 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Size Effect\n//>>group: Effects\n//>>description: Resize an element to a specified width and height.\n//>>docs: http://api.jqueryui.com/size-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"size\", function( options, done ) {\n\n        // Create element\n        var baseline, factor, temp,\n            element = $( this ),\n\n            // Copy for children\n            cProps = [ \"fontSize\" ],\n            vProps = [ \"borderTopWidth\", \"borderBottomWidth\", \"paddingTop\", \"paddingBottom\" ],\n            hProps = [ \"borderLeftWidth\", \"borderRightWidth\", \"paddingLeft\", \"paddingRight\" ],\n\n            // Set options\n            mode = options.mode,\n            restore = mode !== \"effect\",\n            scale = options.scale || \"both\",\n            origin = options.origin || [ \"middle\", \"center\" ],\n            position = element.css( \"position\" ),\n            pos = element.position(),\n            original = $.effects.scaledDimensions( element ),\n            from = options.from || original,\n            to = options.to || $.effects.scaledDimensions( element, 0 );\n\n        $.effects.createPlaceholder( element );\n\n        if ( mode === \"show\" ) {\n            temp = from;\n            from = to;\n            to = temp;\n        }\n\n        // Set scaling factor\n        factor = {\n            from: {\n                y: from.height / original.height,\n                x: from.width / original.width\n            },\n            to: {\n                y: to.height / original.height,\n                x: to.width / original.width\n            }\n        };\n\n        // Scale the css box\n        if ( scale === \"box\" || scale === \"both\" ) {\n\n            // Vertical props scaling\n            if ( factor.from.y !== factor.to.y ) {\n                from = $.effects.setTransition( element, vProps, factor.from.y, from );\n                to = $.effects.setTransition( element, vProps, factor.to.y, to );\n            }\n\n            // Horizontal props scaling\n            if ( factor.from.x !== factor.to.x ) {\n                from = $.effects.setTransition( element, hProps, factor.from.x, from );\n                to = $.effects.setTransition( element, hProps, factor.to.x, to );\n            }\n        }\n\n        // Scale the content\n        if ( scale === \"content\" || scale === \"both\" ) {\n\n            // Vertical props scaling\n            if ( factor.from.y !== factor.to.y ) {\n                from = $.effects.setTransition( element, cProps, factor.from.y, from );\n                to = $.effects.setTransition( element, cProps, factor.to.y, to );\n            }\n        }\n\n        // Adjust the position properties based on the provided origin points\n        if ( origin ) {\n            baseline = $.effects.getBaseline( origin, original );\n            from.top = ( original.outerHeight - from.outerHeight ) * baseline.y + pos.top;\n            from.left = ( original.outerWidth - from.outerWidth ) * baseline.x + pos.left;\n            to.top = ( original.outerHeight - to.outerHeight ) * baseline.y + pos.top;\n            to.left = ( original.outerWidth - to.outerWidth ) * baseline.x + pos.left;\n        }\n        delete from.outerHeight;\n        delete from.outerWidth;\n        element.css( from );\n\n        // Animate the children if desired\n        if ( scale === \"content\" || scale === \"both\" ) {\n\n            vProps = vProps.concat( [ \"marginTop\", \"marginBottom\" ] ).concat( cProps );\n            hProps = hProps.concat( [ \"marginLeft\", \"marginRight\" ] );\n\n            // Only animate children with width attributes specified\n            // TODO: is this right? should we include anything with css width specified as well\n            element.find( \"*[width]\" ).each( function() {\n                var child = $( this ),\n                    childOriginal = $.effects.scaledDimensions( child ),\n                    childFrom = {\n                        height: childOriginal.height * factor.from.y,\n                        width: childOriginal.width * factor.from.x,\n                        outerHeight: childOriginal.outerHeight * factor.from.y,\n                        outerWidth: childOriginal.outerWidth * factor.from.x\n                    },\n                    childTo = {\n                        height: childOriginal.height * factor.to.y,\n                        width: childOriginal.width * factor.to.x,\n                        outerHeight: childOriginal.height * factor.to.y,\n                        outerWidth: childOriginal.width * factor.to.x\n                    };\n\n                // Vertical props scaling\n                if ( factor.from.y !== factor.to.y ) {\n                    childFrom = $.effects.setTransition( child, vProps, factor.from.y, childFrom );\n                    childTo = $.effects.setTransition( child, vProps, factor.to.y, childTo );\n                }\n\n                // Horizontal props scaling\n                if ( factor.from.x !== factor.to.x ) {\n                    childFrom = $.effects.setTransition( child, hProps, factor.from.x, childFrom );\n                    childTo = $.effects.setTransition( child, hProps, factor.to.x, childTo );\n                }\n\n                if ( restore ) {\n                    $.effects.saveStyle( child );\n                }\n\n                // Animate children\n                child.css( childFrom );\n                child.animate( childTo, options.duration, options.easing, function() {\n\n                    // Restore children\n                    if ( restore ) {\n                        $.effects.restoreStyle( child );\n                    }\n                } );\n            } );\n        }\n\n        // Animate\n        element.animate( to, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: function() {\n\n                var offset = element.offset();\n\n                if ( to.opacity === 0 ) {\n                    element.css( \"opacity\", from.opacity );\n                }\n\n                if ( !restore ) {\n                    element\n                        .css( \"position\", position === \"static\" ? \"relative\" : position )\n                        .offset( offset );\n\n                    // Need to save style here so that automatic style restoration\n                    // doesn't restore to the original styles from before the animation.\n                    $.effects.saveStyle( element );\n                }\n\n                done();\n            }\n        } );\n\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-shake.js":"/*!\n * jQuery UI Effects Shake 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Shake Effect\n//>>group: Effects\n//>>description: Shakes an element horizontally or vertically n times.\n//>>docs: http://api.jqueryui.com/shake-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"shake\", function( options, done ) {\n\n        var i = 1,\n            element = $( this ),\n            direction = options.direction || \"left\",\n            distance = options.distance || 20,\n            times = options.times || 3,\n            anims = times * 2 + 1,\n            speed = Math.round( options.duration / anims ),\n            ref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n            positiveMotion = ( direction === \"up\" || direction === \"left\" ),\n            animation = {},\n            animation1 = {},\n            animation2 = {},\n\n            queuelen = element.queue().length;\n\n        $.effects.createPlaceholder( element );\n\n        // Animation\n        animation[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance;\n        animation1[ ref ] = ( positiveMotion ? \"+=\" : \"-=\" ) + distance * 2;\n        animation2[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance * 2;\n\n        // Animate\n        element.animate( animation, speed, options.easing );\n\n        // Shakes\n        for ( ; i < times; i++ ) {\n            element\n                .animate( animation1, speed, options.easing )\n                .animate( animation2, speed, options.easing );\n        }\n\n        element\n            .animate( animation1, speed, options.easing )\n            .animate( animation, speed / 2, options.easing )\n            .queue( done );\n\n        $.effects.unshift( element, queuelen, anims + 1 );\n    } );\n\n} );\n","jquery/ui-modules/widgets/sortable.js":"/*!\n * jQuery UI Sortable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Sortable\n//>>group: Interactions\n//>>description: Enables items in a list to be sorted using the mouse.\n//>>docs: http://api.jqueryui.com/sortable/\n//>>demos: http://jqueryui.com/sortable/\n//>>css.structure: ../../themes/base/sortable.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../data\",\n            \"../ie\",\n            \"../scroll-parent\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.sortable\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"sort\",\n        ready: false,\n        options: {\n            appendTo: \"parent\",\n            axis: false,\n            connectWith: false,\n            containment: false,\n            cursor: \"auto\",\n            cursorAt: false,\n            dropOnEmpty: true,\n            forcePlaceholderSize: false,\n            forceHelperSize: false,\n            grid: false,\n            handle: false,\n            helper: \"original\",\n            items: \"> *\",\n            opacity: false,\n            placeholder: false,\n            revert: false,\n            scroll: true,\n            scrollSensitivity: 20,\n            scrollSpeed: 20,\n            scope: \"default\",\n            tolerance: \"intersect\",\n            zIndex: 1000,\n\n            // Callbacks\n            activate: null,\n            beforeStop: null,\n            change: null,\n            deactivate: null,\n            out: null,\n            over: null,\n            receive: null,\n            remove: null,\n            sort: null,\n            start: null,\n            stop: null,\n            update: null\n        },\n\n        _isOverAxis: function( x, reference, size ) {\n            return ( x >= reference ) && ( x < ( reference + size ) );\n        },\n\n        _isFloating: function( item ) {\n            return ( /left|right/ ).test( item.css( \"float\" ) ) ||\n                ( /inline|table-cell/ ).test( item.css( \"display\" ) );\n        },\n\n        _create: function() {\n            this.containerCache = {};\n            this._addClass( \"ui-sortable\" );\n\n            //Get the items\n            this.refresh();\n\n            //Let's determine the parent's offset\n            this.offset = this.element.offset();\n\n            //Initialize mouse events for interaction\n            this._mouseInit();\n\n            this._setHandleClassName();\n\n            //We're ready to go\n            this.ready = true;\n\n        },\n\n        _setOption: function( key, value ) {\n            this._super( key, value );\n\n            if ( key === \"handle\" ) {\n                this._setHandleClassName();\n            }\n        },\n\n        _setHandleClassName: function() {\n            var that = this;\n            this._removeClass( this.element.find( \".ui-sortable-handle\" ), \"ui-sortable-handle\" );\n            $.each( this.items, function() {\n                that._addClass(\n                    this.instance.options.handle ?\n                        this.item.find( this.instance.options.handle ) :\n                        this.item,\n                    \"ui-sortable-handle\"\n                );\n            } );\n        },\n\n        _destroy: function() {\n            this._mouseDestroy();\n\n            for ( var i = this.items.length - 1; i >= 0; i-- ) {\n                this.items[ i ].item.removeData( this.widgetName + \"-item\" );\n            }\n\n            return this;\n        },\n\n        _mouseCapture: function( event, overrideHandle ) {\n            var currentItem = null,\n                validHandle = false,\n                that = this;\n\n            if ( this.reverting ) {\n                return false;\n            }\n\n            if ( this.options.disabled || this.options.type === \"static\" ) {\n                return false;\n            }\n\n            //We have to refresh the items data once first\n            this._refreshItems( event );\n\n            //Find out if the clicked node (or one of its parents) is a actual item in this.items\n            $( event.target ).parents().each( function() {\n                if ( $.data( this, that.widgetName + \"-item\" ) === that ) {\n                    currentItem = $( this );\n                    return false;\n                }\n            } );\n            if ( $.data( event.target, that.widgetName + \"-item\" ) === that ) {\n                currentItem = $( event.target );\n            }\n\n            if ( !currentItem ) {\n                return false;\n            }\n            if ( this.options.handle && !overrideHandle ) {\n                $( this.options.handle, currentItem ).find( \"*\" ).addBack().each( function() {\n                    if ( this === event.target ) {\n                        validHandle = true;\n                    }\n                } );\n                if ( !validHandle ) {\n                    return false;\n                }\n            }\n\n            this.currentItem = currentItem;\n            this._removeCurrentsFromItems();\n            return true;\n\n        },\n\n        _mouseStart: function( event, overrideHandle, noActivation ) {\n\n            var i, body,\n                o = this.options;\n\n            this.currentContainer = this;\n\n            //We only need to call refreshPositions, because the refreshItems call has been moved to\n            // mouseCapture\n            this.refreshPositions();\n\n            //Prepare the dragged items parent\n            this.appendTo = $( o.appendTo !== \"parent\" ?\n                o.appendTo :\n                this.currentItem.parent() );\n\n            //Create and append the visible helper\n            this.helper = this._createHelper( event );\n\n            //Cache the helper size\n            this._cacheHelperProportions();\n\n            /*\n             * - Position generation -\n             * This block generates everything position related - it's the core of draggables.\n             */\n\n            //Cache the margins of the original element\n            this._cacheMargins();\n\n            //The element's absolute position on the page minus margins\n            this.offset = this.currentItem.offset();\n            this.offset = {\n                top: this.offset.top - this.margins.top,\n                left: this.offset.left - this.margins.left\n            };\n\n            $.extend( this.offset, {\n                click: { //Where the click happened, relative to the element\n                    left: event.pageX - this.offset.left,\n                    top: event.pageY - this.offset.top\n                },\n\n                // This is a relative to absolute position minus the actual position calculation -\n                // only used for relative positioned helper\n                relative: this._getRelativeOffset()\n            } );\n\n            // After we get the helper offset, but before we get the parent offset we can\n            // change the helper's position to absolute\n            // TODO: Still need to figure out a way to make relative sorting possible\n            this.helper.css( \"position\", \"absolute\" );\n            this.cssPosition = this.helper.css( \"position\" );\n\n            //Adjust the mouse offset relative to the helper if \"cursorAt\" is supplied\n            if ( o.cursorAt ) {\n                this._adjustOffsetFromHelper( o.cursorAt );\n            }\n\n            //Cache the former DOM position\n            this.domPosition = {\n                prev: this.currentItem.prev()[ 0 ],\n                parent: this.currentItem.parent()[ 0 ]\n            };\n\n            // If the helper is not the original, hide the original so it's not playing any role during\n            // the drag, won't cause anything bad this way\n            if ( this.helper[ 0 ] !== this.currentItem[ 0 ] ) {\n                this.currentItem.hide();\n            }\n\n            //Create the placeholder\n            this._createPlaceholder();\n\n            //Get the next scrolling parent\n            this.scrollParent = this.placeholder.scrollParent();\n\n            $.extend( this.offset, {\n                parent: this._getParentOffset()\n            } );\n\n            //Set a containment if given in the options\n            if ( o.containment ) {\n                this._setContainment();\n            }\n\n            if ( o.cursor && o.cursor !== \"auto\" ) { // cursor option\n                body = this.document.find( \"body\" );\n\n                // Support: IE\n                this.storedCursor = body.css( \"cursor\" );\n                body.css( \"cursor\", o.cursor );\n\n                this.storedStylesheet =\n                    $( \"<style>*{ cursor: \" + o.cursor + \" !important; }</style>\" ).appendTo( body );\n            }\n\n            // We need to make sure to grab the zIndex before setting the\n            // opacity, because setting the opacity to anything lower than 1\n            // causes the zIndex to change from \"auto\" to 0.\n            if ( o.zIndex ) { // zIndex option\n                if ( this.helper.css( \"zIndex\" ) ) {\n                    this._storedZIndex = this.helper.css( \"zIndex\" );\n                }\n                this.helper.css( \"zIndex\", o.zIndex );\n            }\n\n            if ( o.opacity ) { // opacity option\n                if ( this.helper.css( \"opacity\" ) ) {\n                    this._storedOpacity = this.helper.css( \"opacity\" );\n                }\n                this.helper.css( \"opacity\", o.opacity );\n            }\n\n            //Prepare scrolling\n            if ( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                this.scrollParent[ 0 ].tagName !== \"HTML\" ) {\n                this.overflowOffset = this.scrollParent.offset();\n            }\n\n            //Call callbacks\n            this._trigger( \"start\", event, this._uiHash() );\n\n            //Recache the helper size\n            if ( !this._preserveHelperProportions ) {\n                this._cacheHelperProportions();\n            }\n\n            //Post \"activate\" events to possible containers\n            if ( !noActivation ) {\n                for ( i = this.containers.length - 1; i >= 0; i-- ) {\n                    this.containers[ i ]._trigger( \"activate\", event, this._uiHash( this ) );\n                }\n            }\n\n            //Prepare possible droppables\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.current = this;\n            }\n\n            if ( $.ui.ddmanager && !o.dropBehaviour ) {\n                $.ui.ddmanager.prepareOffsets( this, event );\n            }\n\n            this.dragging = true;\n\n            this._addClass( this.helper, \"ui-sortable-helper\" );\n\n            //Move the helper, if needed\n            if ( !this.helper.parent().is( this.appendTo ) ) {\n                this.helper.detach().appendTo( this.appendTo );\n\n                //Update position\n                this.offset.parent = this._getParentOffset();\n            }\n\n            //Generate the original position\n            this.position = this.originalPosition = this._generatePosition( event );\n            this.originalPageX = event.pageX;\n            this.originalPageY = event.pageY;\n            this.lastPositionAbs = this.positionAbs = this._convertPositionTo( \"absolute\" );\n\n            this._mouseDrag( event );\n\n            return true;\n\n        },\n\n        _scroll: function( event ) {\n            var o = this.options,\n                scrolled = false;\n\n            if ( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                this.scrollParent[ 0 ].tagName !== \"HTML\" ) {\n\n                if ( ( this.overflowOffset.top + this.scrollParent[ 0 ].offsetHeight ) -\n                    event.pageY < o.scrollSensitivity ) {\n                    this.scrollParent[ 0 ].scrollTop =\n                        scrolled = this.scrollParent[ 0 ].scrollTop + o.scrollSpeed;\n                } else if ( event.pageY - this.overflowOffset.top < o.scrollSensitivity ) {\n                    this.scrollParent[ 0 ].scrollTop =\n                        scrolled = this.scrollParent[ 0 ].scrollTop - o.scrollSpeed;\n                }\n\n                if ( ( this.overflowOffset.left + this.scrollParent[ 0 ].offsetWidth ) -\n                    event.pageX < o.scrollSensitivity ) {\n                    this.scrollParent[ 0 ].scrollLeft = scrolled =\n                        this.scrollParent[ 0 ].scrollLeft + o.scrollSpeed;\n                } else if ( event.pageX - this.overflowOffset.left < o.scrollSensitivity ) {\n                    this.scrollParent[ 0 ].scrollLeft = scrolled =\n                        this.scrollParent[ 0 ].scrollLeft - o.scrollSpeed;\n                }\n\n            } else {\n\n                if ( event.pageY - this.document.scrollTop() < o.scrollSensitivity ) {\n                    scrolled = this.document.scrollTop( this.document.scrollTop() - o.scrollSpeed );\n                } else if ( this.window.height() - ( event.pageY - this.document.scrollTop() ) <\n                    o.scrollSensitivity ) {\n                    scrolled = this.document.scrollTop( this.document.scrollTop() + o.scrollSpeed );\n                }\n\n                if ( event.pageX - this.document.scrollLeft() < o.scrollSensitivity ) {\n                    scrolled = this.document.scrollLeft(\n                        this.document.scrollLeft() - o.scrollSpeed\n                    );\n                } else if ( this.window.width() - ( event.pageX - this.document.scrollLeft() ) <\n                    o.scrollSensitivity ) {\n                    scrolled = this.document.scrollLeft(\n                        this.document.scrollLeft() + o.scrollSpeed\n                    );\n                }\n\n            }\n\n            return scrolled;\n        },\n\n        _mouseDrag: function( event ) {\n            var i, item, itemElement, intersection,\n                o = this.options;\n\n            //Compute the helpers position\n            this.position = this._generatePosition( event );\n            this.positionAbs = this._convertPositionTo( \"absolute\" );\n\n            //Set the helper position\n            if ( !this.options.axis || this.options.axis !== \"y\" ) {\n                this.helper[ 0 ].style.left = this.position.left + \"px\";\n            }\n            if ( !this.options.axis || this.options.axis !== \"x\" ) {\n                this.helper[ 0 ].style.top = this.position.top + \"px\";\n            }\n\n            //Do scrolling\n            if ( o.scroll ) {\n                if ( this._scroll( event ) !== false ) {\n\n                    //Update item positions used in position checks\n                    this._refreshItemPositions( true );\n\n                    if ( $.ui.ddmanager && !o.dropBehaviour ) {\n                        $.ui.ddmanager.prepareOffsets( this, event );\n                    }\n                }\n            }\n\n            this.dragDirection = {\n                vertical: this._getDragVerticalDirection(),\n                horizontal: this._getDragHorizontalDirection()\n            };\n\n            //Rearrange\n            for ( i = this.items.length - 1; i >= 0; i-- ) {\n\n                //Cache variables and intersection, continue if no intersection\n                item = this.items[ i ];\n                itemElement = item.item[ 0 ];\n                intersection = this._intersectsWithPointer( item );\n                if ( !intersection ) {\n                    continue;\n                }\n\n                // Only put the placeholder inside the current Container, skip all\n                // items from other containers. This works because when moving\n                // an item from one container to another the\n                // currentContainer is switched before the placeholder is moved.\n                //\n                // Without this, moving items in \"sub-sortables\" can cause\n                // the placeholder to jitter between the outer and inner container.\n                if ( item.instance !== this.currentContainer ) {\n                    continue;\n                }\n\n                // Cannot intersect with itself\n                // no useless actions that have been done before\n                // no action if the item moved is the parent of the item checked\n                if ( itemElement !== this.currentItem[ 0 ] &&\n                    this.placeholder[ intersection === 1 ?\n                        \"next\" : \"prev\" ]()[ 0 ] !== itemElement &&\n                    !$.contains( this.placeholder[ 0 ], itemElement ) &&\n                    ( this.options.type === \"semi-dynamic\" ?\n                            !$.contains( this.element[ 0 ], itemElement ) :\n                            true\n                    )\n                ) {\n\n                    this.direction = intersection === 1 ? \"down\" : \"up\";\n\n                    if ( this.options.tolerance === \"pointer\" ||\n                        this._intersectsWithSides( item ) ) {\n                        this._rearrange( event, item );\n                    } else {\n                        break;\n                    }\n\n                    this._trigger( \"change\", event, this._uiHash() );\n                    break;\n                }\n            }\n\n            //Post events to containers\n            this._contactContainers( event );\n\n            //Interconnect with droppables\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.drag( this, event );\n            }\n\n            //Call callbacks\n            this._trigger( \"sort\", event, this._uiHash() );\n\n            this.lastPositionAbs = this.positionAbs;\n            return false;\n\n        },\n\n        _mouseStop: function( event, noPropagation ) {\n\n            if ( !event ) {\n                return;\n            }\n\n            //If we are using droppables, inform the manager about the drop\n            if ( $.ui.ddmanager && !this.options.dropBehaviour ) {\n                $.ui.ddmanager.drop( this, event );\n            }\n\n            if ( this.options.revert ) {\n                var that = this,\n                    cur = this.placeholder.offset(),\n                    axis = this.options.axis,\n                    animation = {};\n\n                if ( !axis || axis === \"x\" ) {\n                    animation.left = cur.left - this.offset.parent.left - this.margins.left +\n                        ( this.offsetParent[ 0 ] === this.document[ 0 ].body ?\n                                0 :\n                                this.offsetParent[ 0 ].scrollLeft\n                        );\n                }\n                if ( !axis || axis === \"y\" ) {\n                    animation.top = cur.top - this.offset.parent.top - this.margins.top +\n                        ( this.offsetParent[ 0 ] === this.document[ 0 ].body ?\n                                0 :\n                                this.offsetParent[ 0 ].scrollTop\n                        );\n                }\n                this.reverting = true;\n                $( this.helper ).animate(\n                    animation,\n                    parseInt( this.options.revert, 10 ) || 500,\n                    function() {\n                        that._clear( event );\n                    }\n                );\n            } else {\n                this._clear( event, noPropagation );\n            }\n\n            return false;\n\n        },\n\n        cancel: function() {\n\n            if ( this.dragging ) {\n\n                this._mouseUp( new $.Event( \"mouseup\", { target: null } ) );\n\n                if ( this.options.helper === \"original\" ) {\n                    this.currentItem.css( this._storedCSS );\n                    this._removeClass( this.currentItem, \"ui-sortable-helper\" );\n                } else {\n                    this.currentItem.show();\n                }\n\n                //Post deactivating events to containers\n                for ( var i = this.containers.length - 1; i >= 0; i-- ) {\n                    this.containers[ i ]._trigger( \"deactivate\", null, this._uiHash( this ) );\n                    if ( this.containers[ i ].containerCache.over ) {\n                        this.containers[ i ]._trigger( \"out\", null, this._uiHash( this ) );\n                        this.containers[ i ].containerCache.over = 0;\n                    }\n                }\n\n            }\n\n            if ( this.placeholder ) {\n\n                //$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately,\n                // it unbinds ALL events from the original node!\n                if ( this.placeholder[ 0 ].parentNode ) {\n                    this.placeholder[ 0 ].parentNode.removeChild( this.placeholder[ 0 ] );\n                }\n                if ( this.options.helper !== \"original\" && this.helper &&\n                    this.helper[ 0 ].parentNode ) {\n                    this.helper.remove();\n                }\n\n                $.extend( this, {\n                    helper: null,\n                    dragging: false,\n                    reverting: false,\n                    _noFinalSort: null\n                } );\n\n                if ( this.domPosition.prev ) {\n                    $( this.domPosition.prev ).after( this.currentItem );\n                } else {\n                    $( this.domPosition.parent ).prepend( this.currentItem );\n                }\n            }\n\n            return this;\n\n        },\n\n        serialize: function( o ) {\n\n            var items = this._getItemsAsjQuery( o && o.connected ),\n                str = [];\n            o = o || {};\n\n            $( items ).each( function() {\n                var res = ( $( o.item || this ).attr( o.attribute || \"id\" ) || \"\" )\n                    .match( o.expression || ( /(.+)[\\-=_](.+)/ ) );\n                if ( res ) {\n                    str.push(\n                        ( o.key || res[ 1 ] + \"[]\" ) +\n                        \"=\" + ( o.key && o.expression ? res[ 1 ] : res[ 2 ] ) );\n                }\n            } );\n\n            if ( !str.length && o.key ) {\n                str.push( o.key + \"=\" );\n            }\n\n            return str.join( \"&\" );\n\n        },\n\n        toArray: function( o ) {\n\n            var items = this._getItemsAsjQuery( o && o.connected ),\n                ret = [];\n\n            o = o || {};\n\n            items.each( function() {\n                ret.push( $( o.item || this ).attr( o.attribute || \"id\" ) || \"\" );\n            } );\n            return ret;\n\n        },\n\n        /* Be careful with the following core functions */\n        _intersectsWith: function( item ) {\n\n            var x1 = this.positionAbs.left,\n                x2 = x1 + this.helperProportions.width,\n                y1 = this.positionAbs.top,\n                y2 = y1 + this.helperProportions.height,\n                l = item.left,\n                r = l + item.width,\n                t = item.top,\n                b = t + item.height,\n                dyClick = this.offset.click.top,\n                dxClick = this.offset.click.left,\n                isOverElementHeight = ( this.options.axis === \"x\" ) || ( ( y1 + dyClick ) > t &&\n                    ( y1 + dyClick ) < b ),\n                isOverElementWidth = ( this.options.axis === \"y\" ) || ( ( x1 + dxClick ) > l &&\n                    ( x1 + dxClick ) < r ),\n                isOverElement = isOverElementHeight && isOverElementWidth;\n\n            if ( this.options.tolerance === \"pointer\" ||\n                this.options.forcePointerForContainers ||\n                ( this.options.tolerance !== \"pointer\" &&\n                    this.helperProportions[ this.floating ? \"width\" : \"height\" ] >\n                    item[ this.floating ? \"width\" : \"height\" ] )\n            ) {\n                return isOverElement;\n            } else {\n\n                return ( l < x1 + ( this.helperProportions.width / 2 ) && // Right Half\n                    x2 - ( this.helperProportions.width / 2 ) < r && // Left Half\n                    t < y1 + ( this.helperProportions.height / 2 ) && // Bottom Half\n                    y2 - ( this.helperProportions.height / 2 ) < b ); // Top Half\n\n            }\n        },\n\n        _intersectsWithPointer: function( item ) {\n            var verticalDirection, horizontalDirection,\n                isOverElementHeight = ( this.options.axis === \"x\" ) ||\n                    this._isOverAxis(\n                        this.positionAbs.top + this.offset.click.top, item.top, item.height ),\n                isOverElementWidth = ( this.options.axis === \"y\" ) ||\n                    this._isOverAxis(\n                        this.positionAbs.left + this.offset.click.left, item.left, item.width ),\n                isOverElement = isOverElementHeight && isOverElementWidth;\n\n            if ( !isOverElement ) {\n                return false;\n            }\n\n            verticalDirection = this.dragDirection.vertical;\n            horizontalDirection = this.dragDirection.horizontal;\n\n            return this.floating ?\n                ( ( horizontalDirection === \"right\" || verticalDirection === \"down\" ) ? 2 : 1 ) :\n                ( verticalDirection && ( verticalDirection === \"down\" ? 2 : 1 ) );\n\n        },\n\n        _intersectsWithSides: function( item ) {\n\n            var isOverBottomHalf = this._isOverAxis( this.positionAbs.top +\n                    this.offset.click.top, item.top + ( item.height / 2 ), item.height ),\n                isOverRightHalf = this._isOverAxis( this.positionAbs.left +\n                    this.offset.click.left, item.left + ( item.width / 2 ), item.width ),\n                verticalDirection = this.dragDirection.vertical,\n                horizontalDirection = this.dragDirection.horizontal;\n\n            if ( this.floating && horizontalDirection ) {\n                return ( ( horizontalDirection === \"right\" && isOverRightHalf ) ||\n                    ( horizontalDirection === \"left\" && !isOverRightHalf ) );\n            } else {\n                return verticalDirection && ( ( verticalDirection === \"down\" && isOverBottomHalf ) ||\n                    ( verticalDirection === \"up\" && !isOverBottomHalf ) );\n            }\n\n        },\n\n        _getDragVerticalDirection: function() {\n            var delta = this.positionAbs.top - this.lastPositionAbs.top;\n            return delta !== 0 && ( delta > 0 ? \"down\" : \"up\" );\n        },\n\n        _getDragHorizontalDirection: function() {\n            var delta = this.positionAbs.left - this.lastPositionAbs.left;\n            return delta !== 0 && ( delta > 0 ? \"right\" : \"left\" );\n        },\n\n        refresh: function( event ) {\n            this._refreshItems( event );\n            this._setHandleClassName();\n            this.refreshPositions();\n            return this;\n        },\n\n        _connectWith: function() {\n            var options = this.options;\n            return options.connectWith.constructor === String ?\n                [ options.connectWith ] :\n                options.connectWith;\n        },\n\n        _getItemsAsjQuery: function( connected ) {\n\n            var i, j, cur, inst,\n                items = [],\n                queries = [],\n                connectWith = this._connectWith();\n\n            if ( connectWith && connected ) {\n                for ( i = connectWith.length - 1; i >= 0; i-- ) {\n                    cur = $( connectWith[ i ], this.document[ 0 ] );\n                    for ( j = cur.length - 1; j >= 0; j-- ) {\n                        inst = $.data( cur[ j ], this.widgetFullName );\n                        if ( inst && inst !== this && !inst.options.disabled ) {\n                            queries.push( [ typeof inst.options.items === \"function\" ?\n                                inst.options.items.call( inst.element ) :\n                                $( inst.options.items, inst.element )\n                                    .not( \".ui-sortable-helper\" )\n                                    .not( \".ui-sortable-placeholder\" ), inst ] );\n                        }\n                    }\n                }\n            }\n\n            queries.push( [ typeof this.options.items === \"function\" ?\n                this.options.items\n                    .call( this.element, null, { options: this.options, item: this.currentItem } ) :\n                $( this.options.items, this.element )\n                    .not( \".ui-sortable-helper\" )\n                    .not( \".ui-sortable-placeholder\" ), this ] );\n\n            function addItems() {\n                items.push( this );\n            }\n            for ( i = queries.length - 1; i >= 0; i-- ) {\n                queries[ i ][ 0 ].each( addItems );\n            }\n\n            return $( items );\n\n        },\n\n        _removeCurrentsFromItems: function() {\n\n            var list = this.currentItem.find( \":data(\" + this.widgetName + \"-item)\" );\n\n            this.items = $.grep( this.items, function( item ) {\n                for ( var j = 0; j < list.length; j++ ) {\n                    if ( list[ j ] === item.item[ 0 ] ) {\n                        return false;\n                    }\n                }\n                return true;\n            } );\n\n        },\n\n        _refreshItems: function( event ) {\n\n            this.items = [];\n            this.containers = [ this ];\n\n            var i, j, cur, inst, targetData, _queries, item, queriesLength,\n                items = this.items,\n                queries = [ [ typeof this.options.items === \"function\" ?\n                    this.options.items.call( this.element[ 0 ], event, { item: this.currentItem } ) :\n                    $( this.options.items, this.element ), this ] ],\n                connectWith = this._connectWith();\n\n            //Shouldn't be run the first time through due to massive slow-down\n            if ( connectWith && this.ready ) {\n                for ( i = connectWith.length - 1; i >= 0; i-- ) {\n                    cur = $( connectWith[ i ], this.document[ 0 ] );\n                    for ( j = cur.length - 1; j >= 0; j-- ) {\n                        inst = $.data( cur[ j ], this.widgetFullName );\n                        if ( inst && inst !== this && !inst.options.disabled ) {\n                            queries.push( [ typeof inst.options.items === \"function\" ?\n                                inst.options.items\n                                    .call( inst.element[ 0 ], event, { item: this.currentItem } ) :\n                                $( inst.options.items, inst.element ), inst ] );\n                            this.containers.push( inst );\n                        }\n                    }\n                }\n            }\n\n            for ( i = queries.length - 1; i >= 0; i-- ) {\n                targetData = queries[ i ][ 1 ];\n                _queries = queries[ i ][ 0 ];\n\n                for ( j = 0, queriesLength = _queries.length; j < queriesLength; j++ ) {\n                    item = $( _queries[ j ] );\n\n                    // Data for target checking (mouse manager)\n                    item.data( this.widgetName + \"-item\", targetData );\n\n                    items.push( {\n                        item: item,\n                        instance: targetData,\n                        width: 0, height: 0,\n                        left: 0, top: 0\n                    } );\n                }\n            }\n\n        },\n\n        _refreshItemPositions: function( fast ) {\n            var i, item, t, p;\n\n            for ( i = this.items.length - 1; i >= 0; i-- ) {\n                item = this.items[ i ];\n\n                //We ignore calculating positions of all connected containers when we're not over them\n                if ( this.currentContainer && item.instance !== this.currentContainer &&\n                    item.item[ 0 ] !== this.currentItem[ 0 ] ) {\n                    continue;\n                }\n\n                t = this.options.toleranceElement ?\n                    $( this.options.toleranceElement, item.item ) :\n                    item.item;\n\n                if ( !fast ) {\n                    item.width = t.outerWidth();\n                    item.height = t.outerHeight();\n                }\n\n                p = t.offset();\n                item.left = p.left;\n                item.top = p.top;\n            }\n        },\n\n        refreshPositions: function( fast ) {\n\n            // Determine whether items are being displayed horizontally\n            this.floating = this.items.length ?\n                this.options.axis === \"x\" || this._isFloating( this.items[ 0 ].item ) :\n                false;\n\n            // This has to be redone because due to the item being moved out/into the offsetParent,\n            // the offsetParent's position will change\n            if ( this.offsetParent && this.helper ) {\n                this.offset.parent = this._getParentOffset();\n            }\n\n            this._refreshItemPositions( fast );\n\n            var i, p;\n\n            if ( this.options.custom && this.options.custom.refreshContainers ) {\n                this.options.custom.refreshContainers.call( this );\n            } else {\n                for ( i = this.containers.length - 1; i >= 0; i-- ) {\n                    p = this.containers[ i ].element.offset();\n                    this.containers[ i ].containerCache.left = p.left;\n                    this.containers[ i ].containerCache.top = p.top;\n                    this.containers[ i ].containerCache.width =\n                        this.containers[ i ].element.outerWidth();\n                    this.containers[ i ].containerCache.height =\n                        this.containers[ i ].element.outerHeight();\n                }\n            }\n\n            return this;\n        },\n\n        _createPlaceholder: function( that ) {\n            that = that || this;\n            var className, nodeName,\n                o = that.options;\n\n            if ( !o.placeholder || o.placeholder.constructor === String ) {\n                className = o.placeholder;\n                nodeName = that.currentItem[ 0 ].nodeName.toLowerCase();\n                o.placeholder = {\n                    element: function() {\n\n                        var element = $( \"<\" + nodeName + \">\", that.document[ 0 ] );\n\n                        that._addClass( element, \"ui-sortable-placeholder\",\n                            className || that.currentItem[ 0 ].className )\n                            ._removeClass( element, \"ui-sortable-helper\" );\n\n                        if ( nodeName === \"tbody\" ) {\n                            that._createTrPlaceholder(\n                                that.currentItem.find( \"tr\" ).eq( 0 ),\n                                $( \"<tr>\", that.document[ 0 ] ).appendTo( element )\n                            );\n                        } else if ( nodeName === \"tr\" ) {\n                            that._createTrPlaceholder( that.currentItem, element );\n                        } else if ( nodeName === \"img\" ) {\n                            element.attr( \"src\", that.currentItem.attr( \"src\" ) );\n                        }\n\n                        if ( !className ) {\n                            element.css( \"visibility\", \"hidden\" );\n                        }\n\n                        return element;\n                    },\n                    update: function( container, p ) {\n\n                        // 1. If a className is set as 'placeholder option, we don't force sizes -\n                        // the class is responsible for that\n                        // 2. The option 'forcePlaceholderSize can be enabled to force it even if a\n                        // class name is specified\n                        if ( className && !o.forcePlaceholderSize ) {\n                            return;\n                        }\n\n                        // If the element doesn't have a actual height or width by itself (without\n                        // styles coming from a stylesheet), it receives the inline height and width\n                        // from the dragged item. Or, if it's a tbody or tr, it's going to have a height\n                        // anyway since we're populating them with <td>s above, but they're unlikely to\n                        // be the correct height on their own if the row heights are dynamic, so we'll\n                        // always assign the height of the dragged item given forcePlaceholderSize\n                        // is true.\n                        if ( !p.height() || ( o.forcePlaceholderSize &&\n                            ( nodeName === \"tbody\" || nodeName === \"tr\" ) ) ) {\n                            p.height(\n                                that.currentItem.innerHeight() -\n                                parseInt( that.currentItem.css( \"paddingTop\" ) || 0, 10 ) -\n                                parseInt( that.currentItem.css( \"paddingBottom\" ) || 0, 10 ) );\n                        }\n                        if ( !p.width() ) {\n                            p.width(\n                                that.currentItem.innerWidth() -\n                                parseInt( that.currentItem.css( \"paddingLeft\" ) || 0, 10 ) -\n                                parseInt( that.currentItem.css( \"paddingRight\" ) || 0, 10 ) );\n                        }\n                    }\n                };\n            }\n\n            //Create the placeholder\n            that.placeholder = $( o.placeholder.element.call( that.element, that.currentItem ) );\n\n            //Append it after the actual current item\n            that.currentItem.after( that.placeholder );\n\n            //Update the size of the placeholder (TODO: Logic to fuzzy, see line 316/317)\n            o.placeholder.update( that, that.placeholder );\n\n        },\n\n        _createTrPlaceholder: function( sourceTr, targetTr ) {\n            var that = this;\n\n            sourceTr.children().each( function() {\n                $( \"<td>&#160;</td>\", that.document[ 0 ] )\n                    .attr( \"colspan\", $( this ).attr( \"colspan\" ) || 1 )\n                    .appendTo( targetTr );\n            } );\n        },\n\n        _contactContainers: function( event ) {\n            var i, j, dist, itemWithLeastDistance, posProperty, sizeProperty, cur, nearBottom,\n                floating, axis,\n                innermostContainer = null,\n                innermostIndex = null;\n\n            // Get innermost container that intersects with item\n            for ( i = this.containers.length - 1; i >= 0; i-- ) {\n\n                // Never consider a container that's located within the item itself\n                if ( $.contains( this.currentItem[ 0 ], this.containers[ i ].element[ 0 ] ) ) {\n                    continue;\n                }\n\n                if ( this._intersectsWith( this.containers[ i ].containerCache ) ) {\n\n                    // If we've already found a container and it's more \"inner\" than this, then continue\n                    if ( innermostContainer &&\n                        $.contains(\n                            this.containers[ i ].element[ 0 ],\n                            innermostContainer.element[ 0 ] ) ) {\n                        continue;\n                    }\n\n                    innermostContainer = this.containers[ i ];\n                    innermostIndex = i;\n\n                } else {\n\n                    // container doesn't intersect. trigger \"out\" event if necessary\n                    if ( this.containers[ i ].containerCache.over ) {\n                        this.containers[ i ]._trigger( \"out\", event, this._uiHash( this ) );\n                        this.containers[ i ].containerCache.over = 0;\n                    }\n                }\n\n            }\n\n            // If no intersecting containers found, return\n            if ( !innermostContainer ) {\n                return;\n            }\n\n            // Move the item into the container if it's not there already\n            if ( this.containers.length === 1 ) {\n                if ( !this.containers[ innermostIndex ].containerCache.over ) {\n                    this.containers[ innermostIndex ]._trigger( \"over\", event, this._uiHash( this ) );\n                    this.containers[ innermostIndex ].containerCache.over = 1;\n                }\n            } else {\n\n                // When entering a new container, we will find the item with the least distance and\n                // append our item near it\n                dist = 10000;\n                itemWithLeastDistance = null;\n                floating = innermostContainer.floating || this._isFloating( this.currentItem );\n                posProperty = floating ? \"left\" : \"top\";\n                sizeProperty = floating ? \"width\" : \"height\";\n                axis = floating ? \"pageX\" : \"pageY\";\n\n                for ( j = this.items.length - 1; j >= 0; j-- ) {\n                    if ( !$.contains(\n                        this.containers[ innermostIndex ].element[ 0 ], this.items[ j ].item[ 0 ] )\n                    ) {\n                        continue;\n                    }\n                    if ( this.items[ j ].item[ 0 ] === this.currentItem[ 0 ] ) {\n                        continue;\n                    }\n\n                    cur = this.items[ j ].item.offset()[ posProperty ];\n                    nearBottom = false;\n                    if ( event[ axis ] - cur > this.items[ j ][ sizeProperty ] / 2 ) {\n                        nearBottom = true;\n                    }\n\n                    if ( Math.abs( event[ axis ] - cur ) < dist ) {\n                        dist = Math.abs( event[ axis ] - cur );\n                        itemWithLeastDistance = this.items[ j ];\n                        this.direction = nearBottom ? \"up\" : \"down\";\n                    }\n                }\n\n                //Check if dropOnEmpty is enabled\n                if ( !itemWithLeastDistance && !this.options.dropOnEmpty ) {\n                    return;\n                }\n\n                if ( this.currentContainer === this.containers[ innermostIndex ] ) {\n                    if ( !this.currentContainer.containerCache.over ) {\n                        this.containers[ innermostIndex ]._trigger( \"over\", event, this._uiHash() );\n                        this.currentContainer.containerCache.over = 1;\n                    }\n                    return;\n                }\n\n                if ( itemWithLeastDistance ) {\n                    this._rearrange( event, itemWithLeastDistance, null, true );\n                } else {\n                    this._rearrange( event, null, this.containers[ innermostIndex ].element, true );\n                }\n                this._trigger( \"change\", event, this._uiHash() );\n                this.containers[ innermostIndex ]._trigger( \"change\", event, this._uiHash( this ) );\n                this.currentContainer = this.containers[ innermostIndex ];\n\n                //Update the placeholder\n                this.options.placeholder.update( this.currentContainer, this.placeholder );\n\n                //Update scrollParent\n                this.scrollParent = this.placeholder.scrollParent();\n\n                //Update overflowOffset\n                if ( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                    this.scrollParent[ 0 ].tagName !== \"HTML\" ) {\n                    this.overflowOffset = this.scrollParent.offset();\n                }\n\n                this.containers[ innermostIndex ]._trigger( \"over\", event, this._uiHash( this ) );\n                this.containers[ innermostIndex ].containerCache.over = 1;\n            }\n\n        },\n\n        _createHelper: function( event ) {\n\n            var o = this.options,\n                helper = typeof o.helper === \"function\" ?\n                    $( o.helper.apply( this.element[ 0 ], [ event, this.currentItem ] ) ) :\n                    ( o.helper === \"clone\" ? this.currentItem.clone() : this.currentItem );\n\n            //Add the helper to the DOM if that didn't happen already\n            if ( !helper.parents( \"body\" ).length ) {\n                this.appendTo[ 0 ].appendChild( helper[ 0 ] );\n            }\n\n            if ( helper[ 0 ] === this.currentItem[ 0 ] ) {\n                this._storedCSS = {\n                    width: this.currentItem[ 0 ].style.width,\n                    height: this.currentItem[ 0 ].style.height,\n                    position: this.currentItem.css( \"position\" ),\n                    top: this.currentItem.css( \"top\" ),\n                    left: this.currentItem.css( \"left\" )\n                };\n            }\n\n            if ( !helper[ 0 ].style.width || o.forceHelperSize ) {\n                helper.width( this.currentItem.width() );\n            }\n            if ( !helper[ 0 ].style.height || o.forceHelperSize ) {\n                helper.height( this.currentItem.height() );\n            }\n\n            return helper;\n\n        },\n\n        _adjustOffsetFromHelper: function( obj ) {\n            if ( typeof obj === \"string\" ) {\n                obj = obj.split( \" \" );\n            }\n            if ( Array.isArray( obj ) ) {\n                obj = { left: +obj[ 0 ], top: +obj[ 1 ] || 0 };\n            }\n            if ( \"left\" in obj ) {\n                this.offset.click.left = obj.left + this.margins.left;\n            }\n            if ( \"right\" in obj ) {\n                this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n            }\n            if ( \"top\" in obj ) {\n                this.offset.click.top = obj.top + this.margins.top;\n            }\n            if ( \"bottom\" in obj ) {\n                this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n            }\n        },\n\n        _getParentOffset: function() {\n\n            //Get the offsetParent and cache its position\n            this.offsetParent = this.helper.offsetParent();\n            var po = this.offsetParent.offset();\n\n            // This is a special case where we need to modify a offset calculated on start, since the\n            // following happened:\n            // 1. The position of the helper is absolute, so it's position is calculated based on the\n            // next positioned parent\n            // 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't\n            // the document, which means that the scroll is included in the initial calculation of the\n            // offset of the parent, and never recalculated upon drag\n            if ( this.cssPosition === \"absolute\" && this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) {\n                po.left += this.scrollParent.scrollLeft();\n                po.top += this.scrollParent.scrollTop();\n            }\n\n            // This needs to be actually done for all browsers, since pageX/pageY includes this\n            // information with an ugly IE fix\n            if ( this.offsetParent[ 0 ] === this.document[ 0 ].body ||\n                ( this.offsetParent[ 0 ].tagName &&\n                    this.offsetParent[ 0 ].tagName.toLowerCase() === \"html\" && $.ui.ie ) ) {\n                po = { top: 0, left: 0 };\n            }\n\n            return {\n                top: po.top + ( parseInt( this.offsetParent.css( \"borderTopWidth\" ), 10 ) || 0 ),\n                left: po.left + ( parseInt( this.offsetParent.css( \"borderLeftWidth\" ), 10 ) || 0 )\n            };\n\n        },\n\n        _getRelativeOffset: function() {\n\n            if ( this.cssPosition === \"relative\" ) {\n                var p = this.currentItem.position();\n                return {\n                    top: p.top - ( parseInt( this.helper.css( \"top\" ), 10 ) || 0 ) +\n                        this.scrollParent.scrollTop(),\n                    left: p.left - ( parseInt( this.helper.css( \"left\" ), 10 ) || 0 ) +\n                        this.scrollParent.scrollLeft()\n                };\n            } else {\n                return { top: 0, left: 0 };\n            }\n\n        },\n\n        _cacheMargins: function() {\n            this.margins = {\n                left: ( parseInt( this.currentItem.css( \"marginLeft\" ), 10 ) || 0 ),\n                top: ( parseInt( this.currentItem.css( \"marginTop\" ), 10 ) || 0 )\n            };\n        },\n\n        _cacheHelperProportions: function() {\n            this.helperProportions = {\n                width: this.helper.outerWidth(),\n                height: this.helper.outerHeight()\n            };\n        },\n\n        _setContainment: function() {\n\n            var ce, co, over,\n                o = this.options;\n            if ( o.containment === \"parent\" ) {\n                o.containment = this.helper[ 0 ].parentNode;\n            }\n            if ( o.containment === \"document\" || o.containment === \"window\" ) {\n                this.containment = [\n                    0 - this.offset.relative.left - this.offset.parent.left,\n                    0 - this.offset.relative.top - this.offset.parent.top,\n                    o.containment === \"document\" ?\n                        this.document.width() :\n                        this.window.width() - this.helperProportions.width - this.margins.left,\n                    ( o.containment === \"document\" ?\n                            ( this.document.height() || document.body.parentNode.scrollHeight ) :\n                            this.window.height() || this.document[ 0 ].body.parentNode.scrollHeight\n                    ) - this.helperProportions.height - this.margins.top\n                ];\n            }\n\n            if ( !( /^(document|window|parent)$/ ).test( o.containment ) ) {\n                ce = $( o.containment )[ 0 ];\n                co = $( o.containment ).offset();\n                over = ( $( ce ).css( \"overflow\" ) !== \"hidden\" );\n\n                this.containment = [\n                    co.left + ( parseInt( $( ce ).css( \"borderLeftWidth\" ), 10 ) || 0 ) +\n                    ( parseInt( $( ce ).css( \"paddingLeft\" ), 10 ) || 0 ) - this.margins.left,\n                    co.top + ( parseInt( $( ce ).css( \"borderTopWidth\" ), 10 ) || 0 ) +\n                    ( parseInt( $( ce ).css( \"paddingTop\" ), 10 ) || 0 ) - this.margins.top,\n                    co.left + ( over ? Math.max( ce.scrollWidth, ce.offsetWidth ) : ce.offsetWidth ) -\n                    ( parseInt( $( ce ).css( \"borderLeftWidth\" ), 10 ) || 0 ) -\n                    ( parseInt( $( ce ).css( \"paddingRight\" ), 10 ) || 0 ) -\n                    this.helperProportions.width - this.margins.left,\n                    co.top + ( over ? Math.max( ce.scrollHeight, ce.offsetHeight ) : ce.offsetHeight ) -\n                    ( parseInt( $( ce ).css( \"borderTopWidth\" ), 10 ) || 0 ) -\n                    ( parseInt( $( ce ).css( \"paddingBottom\" ), 10 ) || 0 ) -\n                    this.helperProportions.height - this.margins.top\n                ];\n            }\n\n        },\n\n        _convertPositionTo: function( d, pos ) {\n\n            if ( !pos ) {\n                pos = this.position;\n            }\n            var mod = d === \"absolute\" ? 1 : -1,\n                scroll = this.cssPosition === \"absolute\" &&\n                !( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                    $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) ?\n                    this.offsetParent :\n                    this.scrollParent,\n                scrollIsRootNode = ( /(html|body)/i ).test( scroll[ 0 ].tagName );\n\n            return {\n                top: (\n\n                    // The absolute mouse position\n                    pos.top\t+\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.top * mod +\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.top * mod -\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.scrollParent.scrollTop() :\n                        ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) * mod )\n                ),\n                left: (\n\n                    // The absolute mouse position\n                    pos.left +\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.left * mod +\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.left * mod\t-\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 :\n                            scroll.scrollLeft() ) * mod )\n                )\n            };\n\n        },\n\n        _generatePosition: function( event ) {\n\n            var top, left,\n                o = this.options,\n                pageX = event.pageX,\n                pageY = event.pageY,\n                scroll = this.cssPosition === \"absolute\" &&\n                !( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                    $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) ?\n                    this.offsetParent :\n                    this.scrollParent,\n                scrollIsRootNode = ( /(html|body)/i ).test( scroll[ 0 ].tagName );\n\n            // This is another very weird special case that only happens for relative elements:\n            // 1. If the css position is relative\n            // 2. and the scroll parent is the document or similar to the offset parent\n            // we have to refresh the relative offset during the scroll so there are no jumps\n            if ( this.cssPosition === \"relative\" && !( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                this.scrollParent[ 0 ] !== this.offsetParent[ 0 ] ) ) {\n                this.offset.relative = this._getRelativeOffset();\n            }\n\n            /*\n             * - Position constraining -\n             * Constrain the position to a mix of grid, containment.\n             */\n\n            if ( this.originalPosition ) { //If we are not dragging yet, we won't check for options\n\n                if ( this.containment ) {\n                    if ( event.pageX - this.offset.click.left < this.containment[ 0 ] ) {\n                        pageX = this.containment[ 0 ] + this.offset.click.left;\n                    }\n                    if ( event.pageY - this.offset.click.top < this.containment[ 1 ] ) {\n                        pageY = this.containment[ 1 ] + this.offset.click.top;\n                    }\n                    if ( event.pageX - this.offset.click.left > this.containment[ 2 ] ) {\n                        pageX = this.containment[ 2 ] + this.offset.click.left;\n                    }\n                    if ( event.pageY - this.offset.click.top > this.containment[ 3 ] ) {\n                        pageY = this.containment[ 3 ] + this.offset.click.top;\n                    }\n                }\n\n                if ( o.grid ) {\n                    top = this.originalPageY + Math.round( ( pageY - this.originalPageY ) /\n                        o.grid[ 1 ] ) * o.grid[ 1 ];\n                    pageY = this.containment ?\n                        ( ( top - this.offset.click.top >= this.containment[ 1 ] &&\n                            top - this.offset.click.top <= this.containment[ 3 ] ) ?\n                            top :\n                            ( ( top - this.offset.click.top >= this.containment[ 1 ] ) ?\n                                top - o.grid[ 1 ] : top + o.grid[ 1 ] ) ) :\n                        top;\n\n                    left = this.originalPageX + Math.round( ( pageX - this.originalPageX ) /\n                        o.grid[ 0 ] ) * o.grid[ 0 ];\n                    pageX = this.containment ?\n                        ( ( left - this.offset.click.left >= this.containment[ 0 ] &&\n                            left - this.offset.click.left <= this.containment[ 2 ] ) ?\n                            left :\n                            ( ( left - this.offset.click.left >= this.containment[ 0 ] ) ?\n                                left - o.grid[ 0 ] : left + o.grid[ 0 ] ) ) :\n                        left;\n                }\n\n            }\n\n            return {\n                top: (\n\n                    // The absolute mouse position\n                    pageY -\n\n                    // Click offset (relative to the element)\n                    this.offset.click.top -\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.top -\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.top +\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.scrollParent.scrollTop() :\n                        ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) )\n                ),\n                left: (\n\n                    // The absolute mouse position\n                    pageX -\n\n                    // Click offset (relative to the element)\n                    this.offset.click.left -\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.left -\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.left +\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.scrollParent.scrollLeft() :\n                        scrollIsRootNode ? 0 : scroll.scrollLeft() ) )\n                )\n            };\n\n        },\n\n        _rearrange: function( event, i, a, hardRefresh ) {\n\n            if ( a ) {\n                a[ 0 ].appendChild( this.placeholder[ 0 ] );\n            } else {\n                i.item[ 0 ].parentNode.insertBefore( this.placeholder[ 0 ],\n                    ( this.direction === \"down\" ? i.item[ 0 ] : i.item[ 0 ].nextSibling ) );\n            }\n\n            //Various things done here to improve the performance:\n            // 1. we create a setTimeout, that calls refreshPositions\n            // 2. on the instance, we have a counter variable, that get's higher after every append\n            // 3. on the local scope, we copy the counter variable, and check in the timeout,\n            // if it's still the same\n            // 4. this lets only the last addition to the timeout stack through\n            this.counter = this.counter ? ++this.counter : 1;\n            var counter = this.counter;\n\n            this._delay( function() {\n                if ( counter === this.counter ) {\n\n                    //Precompute after each DOM insertion, NOT on mousemove\n                    this.refreshPositions( !hardRefresh );\n                }\n            } );\n\n        },\n\n        _clear: function( event, noPropagation ) {\n\n            this.reverting = false;\n\n            // We delay all events that have to be triggered to after the point where the placeholder\n            // has been removed and everything else normalized again\n            var i,\n                delayedTriggers = [];\n\n            // We first have to update the dom position of the actual currentItem\n            // Note: don't do it if the current item is already removed (by a user), or it gets\n            // reappended (see #4088)\n            if ( !this._noFinalSort && this.currentItem.parent().length ) {\n                this.placeholder.before( this.currentItem );\n            }\n            this._noFinalSort = null;\n\n            if ( this.helper[ 0 ] === this.currentItem[ 0 ] ) {\n                for ( i in this._storedCSS ) {\n                    if ( this._storedCSS[ i ] === \"auto\" || this._storedCSS[ i ] === \"static\" ) {\n                        this._storedCSS[ i ] = \"\";\n                    }\n                }\n                this.currentItem.css( this._storedCSS );\n                this._removeClass( this.currentItem, \"ui-sortable-helper\" );\n            } else {\n                this.currentItem.show();\n            }\n\n            if ( this.fromOutside && !noPropagation ) {\n                delayedTriggers.push( function( event ) {\n                    this._trigger( \"receive\", event, this._uiHash( this.fromOutside ) );\n                } );\n            }\n            if ( ( this.fromOutside ||\n                this.domPosition.prev !==\n                this.currentItem.prev().not( \".ui-sortable-helper\" )[ 0 ] ||\n                this.domPosition.parent !== this.currentItem.parent()[ 0 ] ) && !noPropagation ) {\n\n                // Trigger update callback if the DOM position has changed\n                delayedTriggers.push( function( event ) {\n                    this._trigger( \"update\", event, this._uiHash() );\n                } );\n            }\n\n            // Check if the items Container has Changed and trigger appropriate\n            // events.\n            if ( this !== this.currentContainer ) {\n                if ( !noPropagation ) {\n                    delayedTriggers.push( function( event ) {\n                        this._trigger( \"remove\", event, this._uiHash() );\n                    } );\n                    delayedTriggers.push( ( function( c ) {\n                        return function( event ) {\n                            c._trigger( \"receive\", event, this._uiHash( this ) );\n                        };\n                    } ).call( this, this.currentContainer ) );\n                    delayedTriggers.push( ( function( c ) {\n                        return function( event ) {\n                            c._trigger( \"update\", event, this._uiHash( this ) );\n                        };\n                    } ).call( this, this.currentContainer ) );\n                }\n            }\n\n            //Post events to containers\n            function delayEvent( type, instance, container ) {\n                return function( event ) {\n                    container._trigger( type, event, instance._uiHash( instance ) );\n                };\n            }\n            for ( i = this.containers.length - 1; i >= 0; i-- ) {\n                if ( !noPropagation ) {\n                    delayedTriggers.push( delayEvent( \"deactivate\", this, this.containers[ i ] ) );\n                }\n                if ( this.containers[ i ].containerCache.over ) {\n                    delayedTriggers.push( delayEvent( \"out\", this, this.containers[ i ] ) );\n                    this.containers[ i ].containerCache.over = 0;\n                }\n            }\n\n            //Do what was originally in plugins\n            if ( this.storedCursor ) {\n                this.document.find( \"body\" ).css( \"cursor\", this.storedCursor );\n                this.storedStylesheet.remove();\n            }\n            if ( this._storedOpacity ) {\n                this.helper.css( \"opacity\", this._storedOpacity );\n            }\n            if ( this._storedZIndex ) {\n                this.helper.css( \"zIndex\", this._storedZIndex === \"auto\" ? \"\" : this._storedZIndex );\n            }\n\n            this.dragging = false;\n\n            if ( !noPropagation ) {\n                this._trigger( \"beforeStop\", event, this._uiHash() );\n            }\n\n            //$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately,\n            // it unbinds ALL events from the original node!\n            this.placeholder[ 0 ].parentNode.removeChild( this.placeholder[ 0 ] );\n\n            if ( !this.cancelHelperRemoval ) {\n                if ( this.helper[ 0 ] !== this.currentItem[ 0 ] ) {\n                    this.helper.remove();\n                }\n                this.helper = null;\n            }\n\n            if ( !noPropagation ) {\n                for ( i = 0; i < delayedTriggers.length; i++ ) {\n\n                    // Trigger all delayed events\n                    delayedTriggers[ i ].call( this, event );\n                }\n                this._trigger( \"stop\", event, this._uiHash() );\n            }\n\n            this.fromOutside = false;\n            return !this.cancelHelperRemoval;\n\n        },\n\n        _trigger: function() {\n            if ( $.Widget.prototype._trigger.apply( this, arguments ) === false ) {\n                this.cancel();\n            }\n        },\n\n        _uiHash: function( _inst ) {\n            var inst = _inst || this;\n            return {\n                helper: inst.helper,\n                placeholder: inst.placeholder || $( [] ),\n                position: inst.position,\n                originalPosition: inst.originalPosition,\n                offset: inst.positionAbs,\n                item: inst.currentItem,\n                sender: _inst ? _inst.element : null\n            };\n        }\n\n    } );\n\n} );\n","jquery/ui-modules/widgets/controlgroup.js":"/*!\n * jQuery UI Controlgroup 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Controlgroup\n//>>group: Widgets\n//>>description: Visually groups form control widgets\n//>>docs: http://api.jqueryui.com/controlgroup/\n//>>demos: http://jqueryui.com/controlgroup/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/controlgroup.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var controlgroupCornerRegex = /ui-corner-([a-z]){2,6}/g;\n\n    return $.widget( \"ui.controlgroup\", {\n        version: \"1.13.2\",\n        defaultElement: \"<div>\",\n        options: {\n            direction: \"horizontal\",\n            disabled: null,\n            onlyVisible: true,\n            items: {\n                \"button\": \"input[type=button], input[type=submit], input[type=reset], button, a\",\n                \"controlgroupLabel\": \".ui-controlgroup-label\",\n                \"checkboxradio\": \"input[type='checkbox'], input[type='radio']\",\n                \"selectmenu\": \"select\",\n                \"spinner\": \".ui-spinner-input\"\n            }\n        },\n\n        _create: function() {\n            this._enhance();\n        },\n\n        // To support the enhanced option in jQuery Mobile, we isolate DOM manipulation\n        _enhance: function() {\n            this.element.attr( \"role\", \"toolbar\" );\n            this.refresh();\n        },\n\n        _destroy: function() {\n            this._callChildMethod( \"destroy\" );\n            this.childWidgets.removeData( \"ui-controlgroup-data\" );\n            this.element.removeAttr( \"role\" );\n            if ( this.options.items.controlgroupLabel ) {\n                this.element\n                    .find( this.options.items.controlgroupLabel )\n                    .find( \".ui-controlgroup-label-contents\" )\n                    .contents().unwrap();\n            }\n        },\n\n        _initWidgets: function() {\n            var that = this,\n                childWidgets = [];\n\n            // First we iterate over each of the items options\n            $.each( this.options.items, function( widget, selector ) {\n                var labels;\n                var options = {};\n\n                // Make sure the widget has a selector set\n                if ( !selector ) {\n                    return;\n                }\n\n                if ( widget === \"controlgroupLabel\" ) {\n                    labels = that.element.find( selector );\n                    labels.each( function() {\n                        var element = $( this );\n\n                        if ( element.children( \".ui-controlgroup-label-contents\" ).length ) {\n                            return;\n                        }\n                        element.contents()\n                            .wrapAll( \"<span class='ui-controlgroup-label-contents'></span>\" );\n                    } );\n                    that._addClass( labels, null, \"ui-widget ui-widget-content ui-state-default\" );\n                    childWidgets = childWidgets.concat( labels.get() );\n                    return;\n                }\n\n                // Make sure the widget actually exists\n                if ( !$.fn[ widget ] ) {\n                    return;\n                }\n\n                // We assume everything is in the middle to start because we can't determine\n                // first / last elements until all enhancments are done.\n                if ( that[ \"_\" + widget + \"Options\" ] ) {\n                    options = that[ \"_\" + widget + \"Options\" ]( \"middle\" );\n                } else {\n                    options = { classes: {} };\n                }\n\n                // Find instances of this widget inside controlgroup and init them\n                that.element\n                    .find( selector )\n                    .each( function() {\n                        var element = $( this );\n                        var instance = element[ widget ]( \"instance\" );\n\n                        // We need to clone the default options for this type of widget to avoid\n                        // polluting the variable options which has a wider scope than a single widget.\n                        var instanceOptions = $.widget.extend( {}, options );\n\n                        // If the button is the child of a spinner ignore it\n                        // TODO: Find a more generic solution\n                        if ( widget === \"button\" && element.parent( \".ui-spinner\" ).length ) {\n                            return;\n                        }\n\n                        // Create the widget if it doesn't exist\n                        if ( !instance ) {\n                            instance = element[ widget ]()[ widget ]( \"instance\" );\n                        }\n                        if ( instance ) {\n                            instanceOptions.classes =\n                                that._resolveClassesValues( instanceOptions.classes, instance );\n                        }\n                        element[ widget ]( instanceOptions );\n\n                        // Store an instance of the controlgroup to be able to reference\n                        // from the outermost element for changing options and refresh\n                        var widgetElement = element[ widget ]( \"widget\" );\n                        $.data( widgetElement[ 0 ], \"ui-controlgroup-data\",\n                            instance ? instance : element[ widget ]( \"instance\" ) );\n\n                        childWidgets.push( widgetElement[ 0 ] );\n                    } );\n            } );\n\n            this.childWidgets = $( $.uniqueSort( childWidgets ) );\n            this._addClass( this.childWidgets, \"ui-controlgroup-item\" );\n        },\n\n        _callChildMethod: function( method ) {\n            this.childWidgets.each( function() {\n                var element = $( this ),\n                    data = element.data( \"ui-controlgroup-data\" );\n                if ( data && data[ method ] ) {\n                    data[ method ]();\n                }\n            } );\n        },\n\n        _updateCornerClass: function( element, position ) {\n            var remove = \"ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-corner-all\";\n            var add = this._buildSimpleOptions( position, \"label\" ).classes.label;\n\n            this._removeClass( element, null, remove );\n            this._addClass( element, null, add );\n        },\n\n        _buildSimpleOptions: function( position, key ) {\n            var direction = this.options.direction === \"vertical\";\n            var result = {\n                classes: {}\n            };\n            result.classes[ key ] = {\n                \"middle\": \"\",\n                \"first\": \"ui-corner-\" + ( direction ? \"top\" : \"left\" ),\n                \"last\": \"ui-corner-\" + ( direction ? \"bottom\" : \"right\" ),\n                \"only\": \"ui-corner-all\"\n            }[ position ];\n\n            return result;\n        },\n\n        _spinnerOptions: function( position ) {\n            var options = this._buildSimpleOptions( position, \"ui-spinner\" );\n\n            options.classes[ \"ui-spinner-up\" ] = \"\";\n            options.classes[ \"ui-spinner-down\" ] = \"\";\n\n            return options;\n        },\n\n        _buttonOptions: function( position ) {\n            return this._buildSimpleOptions( position, \"ui-button\" );\n        },\n\n        _checkboxradioOptions: function( position ) {\n            return this._buildSimpleOptions( position, \"ui-checkboxradio-label\" );\n        },\n\n        _selectmenuOptions: function( position ) {\n            var direction = this.options.direction === \"vertical\";\n            return {\n                width: direction ? \"auto\" : false,\n                classes: {\n                    middle: {\n                        \"ui-selectmenu-button-open\": \"\",\n                        \"ui-selectmenu-button-closed\": \"\"\n                    },\n                    first: {\n                        \"ui-selectmenu-button-open\": \"ui-corner-\" + ( direction ? \"top\" : \"tl\" ),\n                        \"ui-selectmenu-button-closed\": \"ui-corner-\" + ( direction ? \"top\" : \"left\" )\n                    },\n                    last: {\n                        \"ui-selectmenu-button-open\": direction ? \"\" : \"ui-corner-tr\",\n                        \"ui-selectmenu-button-closed\": \"ui-corner-\" + ( direction ? \"bottom\" : \"right\" )\n                    },\n                    only: {\n                        \"ui-selectmenu-button-open\": \"ui-corner-top\",\n                        \"ui-selectmenu-button-closed\": \"ui-corner-all\"\n                    }\n\n                }[ position ]\n            };\n        },\n\n        _resolveClassesValues: function( classes, instance ) {\n            var result = {};\n            $.each( classes, function( key ) {\n                var current = instance.options.classes[ key ] || \"\";\n                current = String.prototype.trim.call( current.replace( controlgroupCornerRegex, \"\" ) );\n                result[ key ] = ( current + \" \" + classes[ key ] ).replace( /\\s+/g, \" \" );\n            } );\n            return result;\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"direction\" ) {\n                this._removeClass( \"ui-controlgroup-\" + this.options.direction );\n            }\n\n            this._super( key, value );\n            if ( key === \"disabled\" ) {\n                this._callChildMethod( value ? \"disable\" : \"enable\" );\n                return;\n            }\n\n            this.refresh();\n        },\n\n        refresh: function() {\n            var children,\n                that = this;\n\n            this._addClass( \"ui-controlgroup ui-controlgroup-\" + this.options.direction );\n\n            if ( this.options.direction === \"horizontal\" ) {\n                this._addClass( null, \"ui-helper-clearfix\" );\n            }\n            this._initWidgets();\n\n            children = this.childWidgets;\n\n            // We filter here because we need to track all childWidgets not just the visible ones\n            if ( this.options.onlyVisible ) {\n                children = children.filter( \":visible\" );\n            }\n\n            if ( children.length ) {\n\n                // We do this last because we need to make sure all enhancment is done\n                // before determining first and last\n                $.each( [ \"first\", \"last\" ], function( index, value ) {\n                    var instance = children[ value ]().data( \"ui-controlgroup-data\" );\n\n                    if ( instance && that[ \"_\" + instance.widgetName + \"Options\" ] ) {\n                        var options = that[ \"_\" + instance.widgetName + \"Options\" ](\n                            children.length === 1 ? \"only\" : value\n                        );\n                        options.classes = that._resolveClassesValues( options.classes, instance );\n                        instance.element[ instance.widgetName ]( options );\n                    } else {\n                        that._updateCornerClass( children[ value ](), value );\n                    }\n                } );\n\n                // Finally call the refresh method on each of the child widgets.\n                this._callChildMethod( \"refresh\" );\n            }\n        }\n    } );\n} );\n","jquery/ui-modules/widgets/droppable.js":"/*!\n * jQuery UI Droppable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Droppable\n//>>group: Interactions\n//>>description: Enables drop targets for draggable elements.\n//>>docs: http://api.jqueryui.com/droppable/\n//>>demos: http://jqueryui.com/droppable/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./draggable\",\n            \"./mouse\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.droppable\", {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"drop\",\n        options: {\n            accept: \"*\",\n            addClasses: true,\n            greedy: false,\n            scope: \"default\",\n            tolerance: \"intersect\",\n\n            // Callbacks\n            activate: null,\n            deactivate: null,\n            drop: null,\n            out: null,\n            over: null\n        },\n        _create: function() {\n\n            var proportions,\n                o = this.options,\n                accept = o.accept;\n\n            this.isover = false;\n            this.isout = true;\n\n            this.accept = typeof accept === \"function\" ? accept : function( d ) {\n                return d.is( accept );\n            };\n\n            this.proportions = function( /* valueToWrite */ ) {\n                if ( arguments.length ) {\n\n                    // Store the droppable's proportions\n                    proportions = arguments[ 0 ];\n                } else {\n\n                    // Retrieve or derive the droppable's proportions\n                    return proportions ?\n                        proportions :\n                        proportions = {\n                            width: this.element[ 0 ].offsetWidth,\n                            height: this.element[ 0 ].offsetHeight\n                        };\n                }\n            };\n\n            this._addToManager( o.scope );\n\n            if ( o.addClasses ) {\n                this._addClass( \"ui-droppable\" );\n            }\n\n        },\n\n        _addToManager: function( scope ) {\n\n            // Add the reference and positions to the manager\n            $.ui.ddmanager.droppables[ scope ] = $.ui.ddmanager.droppables[ scope ] || [];\n            $.ui.ddmanager.droppables[ scope ].push( this );\n        },\n\n        _splice: function( drop ) {\n            var i = 0;\n            for ( ; i < drop.length; i++ ) {\n                if ( drop[ i ] === this ) {\n                    drop.splice( i, 1 );\n                }\n            }\n        },\n\n        _destroy: function() {\n            var drop = $.ui.ddmanager.droppables[ this.options.scope ];\n\n            this._splice( drop );\n        },\n\n        _setOption: function( key, value ) {\n\n            if ( key === \"accept\" ) {\n                this.accept = typeof value === \"function\" ? value : function( d ) {\n                    return d.is( value );\n                };\n            } else if ( key === \"scope\" ) {\n                var drop = $.ui.ddmanager.droppables[ this.options.scope ];\n\n                this._splice( drop );\n                this._addToManager( value );\n            }\n\n            this._super( key, value );\n        },\n\n        _activate: function( event ) {\n            var draggable = $.ui.ddmanager.current;\n\n            this._addActiveClass();\n            if ( draggable ) {\n                this._trigger( \"activate\", event, this.ui( draggable ) );\n            }\n        },\n\n        _deactivate: function( event ) {\n            var draggable = $.ui.ddmanager.current;\n\n            this._removeActiveClass();\n            if ( draggable ) {\n                this._trigger( \"deactivate\", event, this.ui( draggable ) );\n            }\n        },\n\n        _over: function( event ) {\n\n            var draggable = $.ui.ddmanager.current;\n\n            // Bail if draggable and droppable are same element\n            if ( !draggable || ( draggable.currentItem ||\n                draggable.element )[ 0 ] === this.element[ 0 ] ) {\n                return;\n            }\n\n            if ( this.accept.call( this.element[ 0 ], ( draggable.currentItem ||\n                draggable.element ) ) ) {\n                this._addHoverClass();\n                this._trigger( \"over\", event, this.ui( draggable ) );\n            }\n\n        },\n\n        _out: function( event ) {\n\n            var draggable = $.ui.ddmanager.current;\n\n            // Bail if draggable and droppable are same element\n            if ( !draggable || ( draggable.currentItem ||\n                draggable.element )[ 0 ] === this.element[ 0 ] ) {\n                return;\n            }\n\n            if ( this.accept.call( this.element[ 0 ], ( draggable.currentItem ||\n                draggable.element ) ) ) {\n                this._removeHoverClass();\n                this._trigger( \"out\", event, this.ui( draggable ) );\n            }\n\n        },\n\n        _drop: function( event, custom ) {\n\n            var draggable = custom || $.ui.ddmanager.current,\n                childrenIntersection = false;\n\n            // Bail if draggable and droppable are same element\n            if ( !draggable || ( draggable.currentItem ||\n                draggable.element )[ 0 ] === this.element[ 0 ] ) {\n                return false;\n            }\n\n            this.element\n                .find( \":data(ui-droppable)\" )\n                .not( \".ui-draggable-dragging\" )\n                .each( function() {\n                    var inst = $( this ).droppable( \"instance\" );\n                    if (\n                        inst.options.greedy &&\n                        !inst.options.disabled &&\n                        inst.options.scope === draggable.options.scope &&\n                        inst.accept.call(\n                            inst.element[ 0 ], ( draggable.currentItem || draggable.element )\n                        ) &&\n                        $.ui.intersect(\n                            draggable,\n                            $.extend( inst, { offset: inst.element.offset() } ),\n                            inst.options.tolerance, event\n                        )\n                    ) {\n                        childrenIntersection = true;\n                        return false;\n                    }\n                } );\n            if ( childrenIntersection ) {\n                return false;\n            }\n\n            if ( this.accept.call( this.element[ 0 ],\n                ( draggable.currentItem || draggable.element ) ) ) {\n                this._removeActiveClass();\n                this._removeHoverClass();\n\n                this._trigger( \"drop\", event, this.ui( draggable ) );\n                return this.element;\n            }\n\n            return false;\n\n        },\n\n        ui: function( c ) {\n            return {\n                draggable: ( c.currentItem || c.element ),\n                helper: c.helper,\n                position: c.position,\n                offset: c.positionAbs\n            };\n        },\n\n        // Extension points just to make backcompat sane and avoid duplicating logic\n        // TODO: Remove in 1.14 along with call to it below\n        _addHoverClass: function() {\n            this._addClass( \"ui-droppable-hover\" );\n        },\n\n        _removeHoverClass: function() {\n            this._removeClass( \"ui-droppable-hover\" );\n        },\n\n        _addActiveClass: function() {\n            this._addClass( \"ui-droppable-active\" );\n        },\n\n        _removeActiveClass: function() {\n            this._removeClass( \"ui-droppable-active\" );\n        }\n    } );\n\n    $.ui.intersect = ( function() {\n        function isOverAxis( x, reference, size ) {\n            return ( x >= reference ) && ( x < ( reference + size ) );\n        }\n\n        return function( draggable, droppable, toleranceMode, event ) {\n\n            if ( !droppable.offset ) {\n                return false;\n            }\n\n            var x1 = ( draggable.positionAbs ||\n                    draggable.position.absolute ).left + draggable.margins.left,\n                y1 = ( draggable.positionAbs ||\n                    draggable.position.absolute ).top + draggable.margins.top,\n                x2 = x1 + draggable.helperProportions.width,\n                y2 = y1 + draggable.helperProportions.height,\n                l = droppable.offset.left,\n                t = droppable.offset.top,\n                r = l + droppable.proportions().width,\n                b = t + droppable.proportions().height;\n\n            switch ( toleranceMode ) {\n                case \"fit\":\n                    return ( l <= x1 && x2 <= r && t <= y1 && y2 <= b );\n                case \"intersect\":\n                    return ( l < x1 + ( draggable.helperProportions.width / 2 ) && // Right Half\n                        x2 - ( draggable.helperProportions.width / 2 ) < r && // Left Half\n                        t < y1 + ( draggable.helperProportions.height / 2 ) && // Bottom Half\n                        y2 - ( draggable.helperProportions.height / 2 ) < b ); // Top Half\n                case \"pointer\":\n                    return isOverAxis( event.pageY, t, droppable.proportions().height ) &&\n                        isOverAxis( event.pageX, l, droppable.proportions().width );\n                case \"touch\":\n                    return (\n                        ( y1 >= t && y1 <= b ) || // Top edge touching\n                        ( y2 >= t && y2 <= b ) || // Bottom edge touching\n                        ( y1 < t && y2 > b ) // Surrounded vertically\n                    ) && (\n                        ( x1 >= l && x1 <= r ) || // Left edge touching\n                        ( x2 >= l && x2 <= r ) || // Right edge touching\n                        ( x1 < l && x2 > r ) // Surrounded horizontally\n                    );\n                default:\n                    return false;\n            }\n        };\n    } )();\n\n    /*\n        This manager tracks offsets of draggables and droppables\n    */\n    $.ui.ddmanager = {\n        current: null,\n        droppables: { \"default\": [] },\n        prepareOffsets: function( t, event ) {\n\n            var i, j,\n                m = $.ui.ddmanager.droppables[ t.options.scope ] || [],\n                type = event ? event.type : null, // workaround for #2317\n                list = ( t.currentItem || t.element ).find( \":data(ui-droppable)\" ).addBack();\n\n            droppablesLoop: for ( i = 0; i < m.length; i++ ) {\n\n                // No disabled and non-accepted\n                if ( m[ i ].options.disabled || ( t && !m[ i ].accept.call( m[ i ].element[ 0 ],\n                    ( t.currentItem || t.element ) ) ) ) {\n                    continue;\n                }\n\n                // Filter out elements in the current dragged item\n                for ( j = 0; j < list.length; j++ ) {\n                    if ( list[ j ] === m[ i ].element[ 0 ] ) {\n                        m[ i ].proportions().height = 0;\n                        continue droppablesLoop;\n                    }\n                }\n\n                m[ i ].visible = m[ i ].element.css( \"display\" ) !== \"none\";\n                if ( !m[ i ].visible ) {\n                    continue;\n                }\n\n                // Activate the droppable if used directly from draggables\n                if ( type === \"mousedown\" ) {\n                    m[ i ]._activate.call( m[ i ], event );\n                }\n\n                m[ i ].offset = m[ i ].element.offset();\n                m[ i ].proportions( {\n                    width: m[ i ].element[ 0 ].offsetWidth,\n                    height: m[ i ].element[ 0 ].offsetHeight\n                } );\n\n            }\n\n        },\n        drop: function( draggable, event ) {\n\n            var dropped = false;\n\n            // Create a copy of the droppables in case the list changes during the drop (#9116)\n            $.each( ( $.ui.ddmanager.droppables[ draggable.options.scope ] || [] ).slice(), function() {\n\n                if ( !this.options ) {\n                    return;\n                }\n                if ( !this.options.disabled && this.visible &&\n                    $.ui.intersect( draggable, this, this.options.tolerance, event ) ) {\n                    dropped = this._drop.call( this, event ) || dropped;\n                }\n\n                if ( !this.options.disabled && this.visible && this.accept.call( this.element[ 0 ],\n                    ( draggable.currentItem || draggable.element ) ) ) {\n                    this.isout = true;\n                    this.isover = false;\n                    this._deactivate.call( this, event );\n                }\n\n            } );\n            return dropped;\n\n        },\n        dragStart: function( draggable, event ) {\n\n            // Listen for scrolling so that if the dragging causes scrolling the position of the\n            // droppables can be recalculated (see #5003)\n            draggable.element.parentsUntil( \"body\" ).on( \"scroll.droppable\", function() {\n                if ( !draggable.options.refreshPositions ) {\n                    $.ui.ddmanager.prepareOffsets( draggable, event );\n                }\n            } );\n        },\n        drag: function( draggable, event ) {\n\n            // If you have a highly dynamic page, you might try this option. It renders positions\n            // every time you move the mouse.\n            if ( draggable.options.refreshPositions ) {\n                $.ui.ddmanager.prepareOffsets( draggable, event );\n            }\n\n            // Run through all droppables and check their positions based on specific tolerance options\n            $.each( $.ui.ddmanager.droppables[ draggable.options.scope ] || [], function() {\n\n                if ( this.options.disabled || this.greedyChild || !this.visible ) {\n                    return;\n                }\n\n                var parentInstance, scope, parent,\n                    intersects = $.ui.intersect( draggable, this, this.options.tolerance, event ),\n                    c = !intersects && this.isover ?\n                        \"isout\" :\n                        ( intersects && !this.isover ? \"isover\" : null );\n                if ( !c ) {\n                    return;\n                }\n\n                if ( this.options.greedy ) {\n\n                    // find droppable parents with same scope\n                    scope = this.options.scope;\n                    parent = this.element.parents( \":data(ui-droppable)\" ).filter( function() {\n                        return $( this ).droppable( \"instance\" ).options.scope === scope;\n                    } );\n\n                    if ( parent.length ) {\n                        parentInstance = $( parent[ 0 ] ).droppable( \"instance\" );\n                        parentInstance.greedyChild = ( c === \"isover\" );\n                    }\n                }\n\n                // We just moved into a greedy child\n                if ( parentInstance && c === \"isover\" ) {\n                    parentInstance.isover = false;\n                    parentInstance.isout = true;\n                    parentInstance._out.call( parentInstance, event );\n                }\n\n                this[ c ] = true;\n                this[ c === \"isout\" ? \"isover\" : \"isout\" ] = false;\n                this[ c === \"isover\" ? \"_over\" : \"_out\" ].call( this, event );\n\n                // We just moved out of a greedy child\n                if ( parentInstance && c === \"isout\" ) {\n                    parentInstance.isout = false;\n                    parentInstance.isover = true;\n                    parentInstance._over.call( parentInstance, event );\n                }\n            } );\n\n        },\n        dragStop: function( draggable, event ) {\n            draggable.element.parentsUntil( \"body\" ).off( \"scroll.droppable\" );\n\n            // Call prepareOffsets one final time since IE does not fire return scroll events when\n            // overflow was caused by drag (see #5003)\n            if ( !draggable.options.refreshPositions ) {\n                $.ui.ddmanager.prepareOffsets( draggable, event );\n            }\n        }\n    };\n\n// DEPRECATED\n// TODO: switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for activeClass and hoverClass options\n        $.widget( \"ui.droppable\", $.ui.droppable, {\n            options: {\n                hoverClass: false,\n                activeClass: false\n            },\n            _addActiveClass: function() {\n                this._super();\n                if ( this.options.activeClass ) {\n                    this.element.addClass( this.options.activeClass );\n                }\n            },\n            _removeActiveClass: function() {\n                this._super();\n                if ( this.options.activeClass ) {\n                    this.element.removeClass( this.options.activeClass );\n                }\n            },\n            _addHoverClass: function() {\n                this._super();\n                if ( this.options.hoverClass ) {\n                    this.element.addClass( this.options.hoverClass );\n                }\n            },\n            _removeHoverClass: function() {\n                this._super();\n                if ( this.options.hoverClass ) {\n                    this.element.removeClass( this.options.hoverClass );\n                }\n            }\n        } );\n    }\n\n    return $.ui.droppable;\n\n} );\n","jquery/ui-modules/widgets/draggable.js":"/*!\n * jQuery UI Draggable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Draggable\n//>>group: Interactions\n//>>description: Enables dragging functionality for any element.\n//>>docs: http://api.jqueryui.com/draggable/\n//>>demos: http://jqueryui.com/draggable/\n//>>css.structure: ../../themes/base/draggable.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../data\",\n            \"../plugin\",\n            \"../safe-active-element\",\n            \"../safe-blur\",\n            \"../scroll-parent\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.draggable\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"drag\",\n        options: {\n            addClasses: true,\n            appendTo: \"parent\",\n            axis: false,\n            connectToSortable: false,\n            containment: false,\n            cursor: \"auto\",\n            cursorAt: false,\n            grid: false,\n            handle: false,\n            helper: \"original\",\n            iframeFix: false,\n            opacity: false,\n            refreshPositions: false,\n            revert: false,\n            revertDuration: 500,\n            scope: \"default\",\n            scroll: true,\n            scrollSensitivity: 20,\n            scrollSpeed: 20,\n            snap: false,\n            snapMode: \"both\",\n            snapTolerance: 20,\n            stack: false,\n            zIndex: false,\n\n            // Callbacks\n            drag: null,\n            start: null,\n            stop: null\n        },\n        _create: function() {\n\n            if ( this.options.helper === \"original\" ) {\n                this._setPositionRelative();\n            }\n            if ( this.options.addClasses ) {\n                this._addClass( \"ui-draggable\" );\n            }\n            this._setHandleClassName();\n\n            this._mouseInit();\n        },\n\n        _setOption: function( key, value ) {\n            this._super( key, value );\n            if ( key === \"handle\" ) {\n                this._removeHandleClassName();\n                this._setHandleClassName();\n            }\n        },\n\n        _destroy: function() {\n            if ( ( this.helper || this.element ).is( \".ui-draggable-dragging\" ) ) {\n                this.destroyOnClear = true;\n                return;\n            }\n            this._removeHandleClassName();\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function( event ) {\n            var o = this.options;\n\n            // Among others, prevent a drag on a resizable-handle\n            if ( this.helper || o.disabled ||\n                $( event.target ).closest( \".ui-resizable-handle\" ).length > 0 ) {\n                return false;\n            }\n\n            //Quit if we're not on a valid handle\n            this.handle = this._getHandle( event );\n            if ( !this.handle ) {\n                return false;\n            }\n\n            this._blurActiveElement( event );\n\n            this._blockFrames( o.iframeFix === true ? \"iframe\" : o.iframeFix );\n\n            return true;\n\n        },\n\n        _blockFrames: function( selector ) {\n            this.iframeBlocks = this.document.find( selector ).map( function() {\n                var iframe = $( this );\n\n                return $( \"<div>\" )\n                    .css( \"position\", \"absolute\" )\n                    .appendTo( iframe.parent() )\n                    .outerWidth( iframe.outerWidth() )\n                    .outerHeight( iframe.outerHeight() )\n                    .offset( iframe.offset() )[ 0 ];\n            } );\n        },\n\n        _unblockFrames: function() {\n            if ( this.iframeBlocks ) {\n                this.iframeBlocks.remove();\n                delete this.iframeBlocks;\n            }\n        },\n\n        _blurActiveElement: function( event ) {\n            var activeElement = $.ui.safeActiveElement( this.document[ 0 ] ),\n                target = $( event.target );\n\n            // Don't blur if the event occurred on an element that is within\n            // the currently focused element\n            // See #10527, #12472\n            if ( target.closest( activeElement ).length ) {\n                return;\n            }\n\n            // Blur any element that currently has focus, see #4261\n            $.ui.safeBlur( activeElement );\n        },\n\n        _mouseStart: function( event ) {\n\n            var o = this.options;\n\n            //Create and append the visible helper\n            this.helper = this._createHelper( event );\n\n            this._addClass( this.helper, \"ui-draggable-dragging\" );\n\n            //Cache the helper size\n            this._cacheHelperProportions();\n\n            //If ddmanager is used for droppables, set the global draggable\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.current = this;\n            }\n\n            /*\n             * - Position generation -\n             * This block generates everything position related - it's the core of draggables.\n             */\n\n            //Cache the margins of the original element\n            this._cacheMargins();\n\n            //Store the helper's css position\n            this.cssPosition = this.helper.css( \"position\" );\n            this.scrollParent = this.helper.scrollParent( true );\n            this.offsetParent = this.helper.offsetParent();\n            this.hasFixedAncestor = this.helper.parents().filter( function() {\n                return $( this ).css( \"position\" ) === \"fixed\";\n            } ).length > 0;\n\n            //The element's absolute position on the page minus margins\n            this.positionAbs = this.element.offset();\n            this._refreshOffsets( event );\n\n            //Generate the original position\n            this.originalPosition = this.position = this._generatePosition( event, false );\n            this.originalPageX = event.pageX;\n            this.originalPageY = event.pageY;\n\n            //Adjust the mouse offset relative to the helper if \"cursorAt\" is supplied\n            if ( o.cursorAt ) {\n                this._adjustOffsetFromHelper( o.cursorAt );\n            }\n\n            //Set a containment if given in the options\n            this._setContainment();\n\n            //Trigger event + callbacks\n            if ( this._trigger( \"start\", event ) === false ) {\n                this._clear();\n                return false;\n            }\n\n            //Recache the helper size\n            this._cacheHelperProportions();\n\n            //Prepare the droppable offsets\n            if ( $.ui.ddmanager && !o.dropBehaviour ) {\n                $.ui.ddmanager.prepareOffsets( this, event );\n            }\n\n            // Execute the drag once - this causes the helper not to be visible before getting its\n            // correct position\n            this._mouseDrag( event, true );\n\n            // If the ddmanager is used for droppables, inform the manager that dragging has started\n            // (see #5003)\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.dragStart( this, event );\n            }\n\n            return true;\n        },\n\n        _refreshOffsets: function( event ) {\n            this.offset = {\n                top: this.positionAbs.top - this.margins.top,\n                left: this.positionAbs.left - this.margins.left,\n                scroll: false,\n                parent: this._getParentOffset(),\n                relative: this._getRelativeOffset()\n            };\n\n            this.offset.click = {\n                left: event.pageX - this.offset.left,\n                top: event.pageY - this.offset.top\n            };\n        },\n\n        _mouseDrag: function( event, noPropagation ) {\n\n            // reset any necessary cached properties (see #5009)\n            if ( this.hasFixedAncestor ) {\n                this.offset.parent = this._getParentOffset();\n            }\n\n            //Compute the helpers position\n            this.position = this._generatePosition( event, true );\n            this.positionAbs = this._convertPositionTo( \"absolute\" );\n\n            //Call plugins and callbacks and use the resulting position if something is returned\n            if ( !noPropagation ) {\n                var ui = this._uiHash();\n                if ( this._trigger( \"drag\", event, ui ) === false ) {\n                    this._mouseUp( new $.Event( \"mouseup\", event ) );\n                    return false;\n                }\n                this.position = ui.position;\n            }\n\n            this.helper[ 0 ].style.left = this.position.left + \"px\";\n            this.helper[ 0 ].style.top = this.position.top + \"px\";\n\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.drag( this, event );\n            }\n\n            return false;\n        },\n\n        _mouseStop: function( event ) {\n\n            //If we are using droppables, inform the manager about the drop\n            var that = this,\n                dropped = false;\n            if ( $.ui.ddmanager && !this.options.dropBehaviour ) {\n                dropped = $.ui.ddmanager.drop( this, event );\n            }\n\n            //if a drop comes from outside (a sortable)\n            if ( this.dropped ) {\n                dropped = this.dropped;\n                this.dropped = false;\n            }\n\n            if ( ( this.options.revert === \"invalid\" && !dropped ) ||\n                ( this.options.revert === \"valid\" && dropped ) ||\n                this.options.revert === true || ( typeof this.options.revert === \"function\" &&\n                    this.options.revert.call( this.element, dropped ) )\n            ) {\n                $( this.helper ).animate(\n                    this.originalPosition,\n                    parseInt( this.options.revertDuration, 10 ),\n                    function() {\n                        if ( that._trigger( \"stop\", event ) !== false ) {\n                            that._clear();\n                        }\n                    }\n                );\n            } else {\n                if ( this._trigger( \"stop\", event ) !== false ) {\n                    this._clear();\n                }\n            }\n\n            return false;\n        },\n\n        _mouseUp: function( event ) {\n            this._unblockFrames();\n\n            // If the ddmanager is used for droppables, inform the manager that dragging has stopped\n            // (see #5003)\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.dragStop( this, event );\n            }\n\n            // Only need to focus if the event occurred on the draggable itself, see #10527\n            if ( this.handleElement.is( event.target ) ) {\n\n                // The interaction is over; whether or not the click resulted in a drag,\n                // focus the element\n                this.element.trigger( \"focus\" );\n            }\n\n            return $.ui.mouse.prototype._mouseUp.call( this, event );\n        },\n\n        cancel: function() {\n\n            if ( this.helper.is( \".ui-draggable-dragging\" ) ) {\n                this._mouseUp( new $.Event( \"mouseup\", { target: this.element[ 0 ] } ) );\n            } else {\n                this._clear();\n            }\n\n            return this;\n\n        },\n\n        _getHandle: function( event ) {\n            return this.options.handle ?\n                !!$( event.target ).closest( this.element.find( this.options.handle ) ).length :\n                true;\n        },\n\n        _setHandleClassName: function() {\n            this.handleElement = this.options.handle ?\n                this.element.find( this.options.handle ) : this.element;\n            this._addClass( this.handleElement, \"ui-draggable-handle\" );\n        },\n\n        _removeHandleClassName: function() {\n            this._removeClass( this.handleElement, \"ui-draggable-handle\" );\n        },\n\n        _createHelper: function( event ) {\n\n            var o = this.options,\n                helperIsFunction = typeof o.helper === \"function\",\n                helper = helperIsFunction ?\n                    $( o.helper.apply( this.element[ 0 ], [ event ] ) ) :\n                    ( o.helper === \"clone\" ?\n                        this.element.clone().removeAttr( \"id\" ) :\n                        this.element );\n\n            if ( !helper.parents( \"body\" ).length ) {\n                helper.appendTo( ( o.appendTo === \"parent\" ?\n                    this.element[ 0 ].parentNode :\n                    o.appendTo ) );\n            }\n\n            // Http://bugs.jqueryui.com/ticket/9446\n            // a helper function can return the original element\n            // which wouldn't have been set to relative in _create\n            if ( helperIsFunction && helper[ 0 ] === this.element[ 0 ] ) {\n                this._setPositionRelative();\n            }\n\n            if ( helper[ 0 ] !== this.element[ 0 ] &&\n                !( /(fixed|absolute)/ ).test( helper.css( \"position\" ) ) ) {\n                helper.css( \"position\", \"absolute\" );\n            }\n\n            return helper;\n\n        },\n\n        _setPositionRelative: function() {\n            if ( !( /^(?:r|a|f)/ ).test( this.element.css( \"position\" ) ) ) {\n                this.element[ 0 ].style.position = \"relative\";\n            }\n        },\n\n        _adjustOffsetFromHelper: function( obj ) {\n            if ( typeof obj === \"string\" ) {\n                obj = obj.split( \" \" );\n            }\n            if ( Array.isArray( obj ) ) {\n                obj = { left: +obj[ 0 ], top: +obj[ 1 ] || 0 };\n            }\n            if ( \"left\" in obj ) {\n                this.offset.click.left = obj.left + this.margins.left;\n            }\n            if ( \"right\" in obj ) {\n                this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n            }\n            if ( \"top\" in obj ) {\n                this.offset.click.top = obj.top + this.margins.top;\n            }\n            if ( \"bottom\" in obj ) {\n                this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n            }\n        },\n\n        _isRootNode: function( element ) {\n            return ( /(html|body)/i ).test( element.tagName ) || element === this.document[ 0 ];\n        },\n\n        _getParentOffset: function() {\n\n            //Get the offsetParent and cache its position\n            var po = this.offsetParent.offset(),\n                document = this.document[ 0 ];\n\n            // This is a special case where we need to modify a offset calculated on start, since the\n            // following happened:\n            // 1. The position of the helper is absolute, so it's position is calculated based on the\n            // next positioned parent\n            // 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't\n            // the document, which means that the scroll is included in the initial calculation of the\n            // offset of the parent, and never recalculated upon drag\n            if ( this.cssPosition === \"absolute\" && this.scrollParent[ 0 ] !== document &&\n                $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) {\n                po.left += this.scrollParent.scrollLeft();\n                po.top += this.scrollParent.scrollTop();\n            }\n\n            if ( this._isRootNode( this.offsetParent[ 0 ] ) ) {\n                po = { top: 0, left: 0 };\n            }\n\n            return {\n                top: po.top + ( parseInt( this.offsetParent.css( \"borderTopWidth\" ), 10 ) || 0 ),\n                left: po.left + ( parseInt( this.offsetParent.css( \"borderLeftWidth\" ), 10 ) || 0 )\n            };\n\n        },\n\n        _getRelativeOffset: function() {\n            if ( this.cssPosition !== \"relative\" ) {\n                return { top: 0, left: 0 };\n            }\n\n            var p = this.element.position(),\n                scrollIsRootNode = this._isRootNode( this.scrollParent[ 0 ] );\n\n            return {\n                top: p.top - ( parseInt( this.helper.css( \"top\" ), 10 ) || 0 ) +\n                    ( !scrollIsRootNode ? this.scrollParent.scrollTop() : 0 ),\n                left: p.left - ( parseInt( this.helper.css( \"left\" ), 10 ) || 0 ) +\n                    ( !scrollIsRootNode ? this.scrollParent.scrollLeft() : 0 )\n            };\n\n        },\n\n        _cacheMargins: function() {\n            this.margins = {\n                left: ( parseInt( this.element.css( \"marginLeft\" ), 10 ) || 0 ),\n                top: ( parseInt( this.element.css( \"marginTop\" ), 10 ) || 0 ),\n                right: ( parseInt( this.element.css( \"marginRight\" ), 10 ) || 0 ),\n                bottom: ( parseInt( this.element.css( \"marginBottom\" ), 10 ) || 0 )\n            };\n        },\n\n        _cacheHelperProportions: function() {\n            this.helperProportions = {\n                width: this.helper.outerWidth(),\n                height: this.helper.outerHeight()\n            };\n        },\n\n        _setContainment: function() {\n\n            var isUserScrollable, c, ce,\n                o = this.options,\n                document = this.document[ 0 ];\n\n            this.relativeContainer = null;\n\n            if ( !o.containment ) {\n                this.containment = null;\n                return;\n            }\n\n            if ( o.containment === \"window\" ) {\n                this.containment = [\n                    $( window ).scrollLeft() - this.offset.relative.left - this.offset.parent.left,\n                    $( window ).scrollTop() - this.offset.relative.top - this.offset.parent.top,\n                    $( window ).scrollLeft() + $( window ).width() -\n                    this.helperProportions.width - this.margins.left,\n                    $( window ).scrollTop() +\n                    ( $( window ).height() || document.body.parentNode.scrollHeight ) -\n                    this.helperProportions.height - this.margins.top\n                ];\n                return;\n            }\n\n            if ( o.containment === \"document\" ) {\n                this.containment = [\n                    0,\n                    0,\n                    $( document ).width() - this.helperProportions.width - this.margins.left,\n                    ( $( document ).height() || document.body.parentNode.scrollHeight ) -\n                    this.helperProportions.height - this.margins.top\n                ];\n                return;\n            }\n\n            if ( o.containment.constructor === Array ) {\n                this.containment = o.containment;\n                return;\n            }\n\n            if ( o.containment === \"parent\" ) {\n                o.containment = this.helper[ 0 ].parentNode;\n            }\n\n            c = $( o.containment );\n            ce = c[ 0 ];\n\n            if ( !ce ) {\n                return;\n            }\n\n            isUserScrollable = /(scroll|auto)/.test( c.css( \"overflow\" ) );\n\n            this.containment = [\n                ( parseInt( c.css( \"borderLeftWidth\" ), 10 ) || 0 ) +\n                ( parseInt( c.css( \"paddingLeft\" ), 10 ) || 0 ),\n                ( parseInt( c.css( \"borderTopWidth\" ), 10 ) || 0 ) +\n                ( parseInt( c.css( \"paddingTop\" ), 10 ) || 0 ),\n                ( isUserScrollable ? Math.max( ce.scrollWidth, ce.offsetWidth ) : ce.offsetWidth ) -\n                ( parseInt( c.css( \"borderRightWidth\" ), 10 ) || 0 ) -\n                ( parseInt( c.css( \"paddingRight\" ), 10 ) || 0 ) -\n                this.helperProportions.width -\n                this.margins.left -\n                this.margins.right,\n                ( isUserScrollable ? Math.max( ce.scrollHeight, ce.offsetHeight ) : ce.offsetHeight ) -\n                ( parseInt( c.css( \"borderBottomWidth\" ), 10 ) || 0 ) -\n                ( parseInt( c.css( \"paddingBottom\" ), 10 ) || 0 ) -\n                this.helperProportions.height -\n                this.margins.top -\n                this.margins.bottom\n            ];\n            this.relativeContainer = c;\n        },\n\n        _convertPositionTo: function( d, pos ) {\n\n            if ( !pos ) {\n                pos = this.position;\n            }\n\n            var mod = d === \"absolute\" ? 1 : -1,\n                scrollIsRootNode = this._isRootNode( this.scrollParent[ 0 ] );\n\n            return {\n                top: (\n\n                    // The absolute mouse position\n                    pos.top\t+\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.top * mod +\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.top * mod -\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.offset.scroll.top :\n                        ( scrollIsRootNode ? 0 : this.offset.scroll.top ) ) * mod )\n                ),\n                left: (\n\n                    // The absolute mouse position\n                    pos.left +\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.left * mod +\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.left * mod\t-\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.offset.scroll.left :\n                        ( scrollIsRootNode ? 0 : this.offset.scroll.left ) ) * mod )\n                )\n            };\n\n        },\n\n        _generatePosition: function( event, constrainPosition ) {\n\n            var containment, co, top, left,\n                o = this.options,\n                scrollIsRootNode = this._isRootNode( this.scrollParent[ 0 ] ),\n                pageX = event.pageX,\n                pageY = event.pageY;\n\n            // Cache the scroll\n            if ( !scrollIsRootNode || !this.offset.scroll ) {\n                this.offset.scroll = {\n                    top: this.scrollParent.scrollTop(),\n                    left: this.scrollParent.scrollLeft()\n                };\n            }\n\n            /*\n             * - Position constraining -\n             * Constrain the position to a mix of grid, containment.\n             */\n\n            // If we are not dragging yet, we won't check for options\n            if ( constrainPosition ) {\n                if ( this.containment ) {\n                    if ( this.relativeContainer ) {\n                        co = this.relativeContainer.offset();\n                        containment = [\n                            this.containment[ 0 ] + co.left,\n                            this.containment[ 1 ] + co.top,\n                            this.containment[ 2 ] + co.left,\n                            this.containment[ 3 ] + co.top\n                        ];\n                    } else {\n                        containment = this.containment;\n                    }\n\n                    if ( event.pageX - this.offset.click.left < containment[ 0 ] ) {\n                        pageX = containment[ 0 ] + this.offset.click.left;\n                    }\n                    if ( event.pageY - this.offset.click.top < containment[ 1 ] ) {\n                        pageY = containment[ 1 ] + this.offset.click.top;\n                    }\n                    if ( event.pageX - this.offset.click.left > containment[ 2 ] ) {\n                        pageX = containment[ 2 ] + this.offset.click.left;\n                    }\n                    if ( event.pageY - this.offset.click.top > containment[ 3 ] ) {\n                        pageY = containment[ 3 ] + this.offset.click.top;\n                    }\n                }\n\n                if ( o.grid ) {\n\n                    //Check for grid elements set to 0 to prevent divide by 0 error causing invalid\n                    // argument errors in IE (see ticket #6950)\n                    top = o.grid[ 1 ] ? this.originalPageY + Math.round( ( pageY -\n                        this.originalPageY ) / o.grid[ 1 ] ) * o.grid[ 1 ] : this.originalPageY;\n                    pageY = containment ? ( ( top - this.offset.click.top >= containment[ 1 ] ||\n                        top - this.offset.click.top > containment[ 3 ] ) ?\n                        top :\n                        ( ( top - this.offset.click.top >= containment[ 1 ] ) ?\n                            top - o.grid[ 1 ] : top + o.grid[ 1 ] ) ) : top;\n\n                    left = o.grid[ 0 ] ? this.originalPageX +\n                        Math.round( ( pageX - this.originalPageX ) / o.grid[ 0 ] ) * o.grid[ 0 ] :\n                        this.originalPageX;\n                    pageX = containment ? ( ( left - this.offset.click.left >= containment[ 0 ] ||\n                        left - this.offset.click.left > containment[ 2 ] ) ?\n                        left :\n                        ( ( left - this.offset.click.left >= containment[ 0 ] ) ?\n                            left - o.grid[ 0 ] : left + o.grid[ 0 ] ) ) : left;\n                }\n\n                if ( o.axis === \"y\" ) {\n                    pageX = this.originalPageX;\n                }\n\n                if ( o.axis === \"x\" ) {\n                    pageY = this.originalPageY;\n                }\n            }\n\n            return {\n                top: (\n\n                    // The absolute mouse position\n                    pageY -\n\n                    // Click offset (relative to the element)\n                    this.offset.click.top -\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.top -\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.top +\n                    ( this.cssPosition === \"fixed\" ?\n                        -this.offset.scroll.top :\n                        ( scrollIsRootNode ? 0 : this.offset.scroll.top ) )\n                ),\n                left: (\n\n                    // The absolute mouse position\n                    pageX -\n\n                    // Click offset (relative to the element)\n                    this.offset.click.left -\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.left -\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.left +\n                    ( this.cssPosition === \"fixed\" ?\n                        -this.offset.scroll.left :\n                        ( scrollIsRootNode ? 0 : this.offset.scroll.left ) )\n                )\n            };\n\n        },\n\n        _clear: function() {\n            this._removeClass( this.helper, \"ui-draggable-dragging\" );\n            if ( this.helper[ 0 ] !== this.element[ 0 ] && !this.cancelHelperRemoval ) {\n                this.helper.remove();\n            }\n            this.helper = null;\n            this.cancelHelperRemoval = false;\n            if ( this.destroyOnClear ) {\n                this.destroy();\n            }\n        },\n\n        // From now on bulk stuff - mainly helpers\n\n        _trigger: function( type, event, ui ) {\n            ui = ui || this._uiHash();\n            $.ui.plugin.call( this, type, [ event, ui, this ], true );\n\n            // Absolute position and offset (see #6884 ) have to be recalculated after plugins\n            if ( /^(drag|start|stop)/.test( type ) ) {\n                this.positionAbs = this._convertPositionTo( \"absolute\" );\n                ui.offset = this.positionAbs;\n            }\n            return $.Widget.prototype._trigger.call( this, type, event, ui );\n        },\n\n        plugins: {},\n\n        _uiHash: function() {\n            return {\n                helper: this.helper,\n                position: this.position,\n                originalPosition: this.originalPosition,\n                offset: this.positionAbs\n            };\n        }\n\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"connectToSortable\", {\n        start: function( event, ui, draggable ) {\n            var uiSortable = $.extend( {}, ui, {\n                item: draggable.element\n            } );\n\n            draggable.sortables = [];\n            $( draggable.options.connectToSortable ).each( function() {\n                var sortable = $( this ).sortable( \"instance\" );\n\n                if ( sortable && !sortable.options.disabled ) {\n                    draggable.sortables.push( sortable );\n\n                    // RefreshPositions is called at drag start to refresh the containerCache\n                    // which is used in drag. This ensures it's initialized and synchronized\n                    // with any changes that might have happened on the page since initialization.\n                    sortable.refreshPositions();\n                    sortable._trigger( \"activate\", event, uiSortable );\n                }\n            } );\n        },\n        stop: function( event, ui, draggable ) {\n            var uiSortable = $.extend( {}, ui, {\n                item: draggable.element\n            } );\n\n            draggable.cancelHelperRemoval = false;\n\n            $.each( draggable.sortables, function() {\n                var sortable = this;\n\n                if ( sortable.isOver ) {\n                    sortable.isOver = 0;\n\n                    // Allow this sortable to handle removing the helper\n                    draggable.cancelHelperRemoval = true;\n                    sortable.cancelHelperRemoval = false;\n\n                    // Use _storedCSS To restore properties in the sortable,\n                    // as this also handles revert (#9675) since the draggable\n                    // may have modified them in unexpected ways (#8809)\n                    sortable._storedCSS = {\n                        position: sortable.placeholder.css( \"position\" ),\n                        top: sortable.placeholder.css( \"top\" ),\n                        left: sortable.placeholder.css( \"left\" )\n                    };\n\n                    sortable._mouseStop( event );\n\n                    // Once drag has ended, the sortable should return to using\n                    // its original helper, not the shared helper from draggable\n                    sortable.options.helper = sortable.options._helper;\n                } else {\n\n                    // Prevent this Sortable from removing the helper.\n                    // However, don't set the draggable to remove the helper\n                    // either as another connected Sortable may yet handle the removal.\n                    sortable.cancelHelperRemoval = true;\n\n                    sortable._trigger( \"deactivate\", event, uiSortable );\n                }\n            } );\n        },\n        drag: function( event, ui, draggable ) {\n            $.each( draggable.sortables, function() {\n                var innermostIntersecting = false,\n                    sortable = this;\n\n                // Copy over variables that sortable's _intersectsWith uses\n                sortable.positionAbs = draggable.positionAbs;\n                sortable.helperProportions = draggable.helperProportions;\n                sortable.offset.click = draggable.offset.click;\n\n                if ( sortable._intersectsWith( sortable.containerCache ) ) {\n                    innermostIntersecting = true;\n\n                    $.each( draggable.sortables, function() {\n\n                        // Copy over variables that sortable's _intersectsWith uses\n                        this.positionAbs = draggable.positionAbs;\n                        this.helperProportions = draggable.helperProportions;\n                        this.offset.click = draggable.offset.click;\n\n                        if ( this !== sortable &&\n                            this._intersectsWith( this.containerCache ) &&\n                            $.contains( sortable.element[ 0 ], this.element[ 0 ] ) ) {\n                            innermostIntersecting = false;\n                        }\n\n                        return innermostIntersecting;\n                    } );\n                }\n\n                if ( innermostIntersecting ) {\n\n                    // If it intersects, we use a little isOver variable and set it once,\n                    // so that the move-in stuff gets fired only once.\n                    if ( !sortable.isOver ) {\n                        sortable.isOver = 1;\n\n                        // Store draggable's parent in case we need to reappend to it later.\n                        draggable._parent = ui.helper.parent();\n\n                        sortable.currentItem = ui.helper\n                            .appendTo( sortable.element )\n                            .data( \"ui-sortable-item\", true );\n\n                        // Store helper option to later restore it\n                        sortable.options._helper = sortable.options.helper;\n\n                        sortable.options.helper = function() {\n                            return ui.helper[ 0 ];\n                        };\n\n                        // Fire the start events of the sortable with our passed browser event,\n                        // and our own helper (so it doesn't create a new one)\n                        event.target = sortable.currentItem[ 0 ];\n                        sortable._mouseCapture( event, true );\n                        sortable._mouseStart( event, true, true );\n\n                        // Because the browser event is way off the new appended portlet,\n                        // modify necessary variables to reflect the changes\n                        sortable.offset.click.top = draggable.offset.click.top;\n                        sortable.offset.click.left = draggable.offset.click.left;\n                        sortable.offset.parent.left -= draggable.offset.parent.left -\n                            sortable.offset.parent.left;\n                        sortable.offset.parent.top -= draggable.offset.parent.top -\n                            sortable.offset.parent.top;\n\n                        draggable._trigger( \"toSortable\", event );\n\n                        // Inform draggable that the helper is in a valid drop zone,\n                        // used solely in the revert option to handle \"valid/invalid\".\n                        draggable.dropped = sortable.element;\n\n                        // Need to refreshPositions of all sortables in the case that\n                        // adding to one sortable changes the location of the other sortables (#9675)\n                        $.each( draggable.sortables, function() {\n                            this.refreshPositions();\n                        } );\n\n                        // Hack so receive/update callbacks work (mostly)\n                        draggable.currentItem = draggable.element;\n                        sortable.fromOutside = draggable;\n                    }\n\n                    if ( sortable.currentItem ) {\n                        sortable._mouseDrag( event );\n\n                        // Copy the sortable's position because the draggable's can potentially reflect\n                        // a relative position, while sortable is always absolute, which the dragged\n                        // element has now become. (#8809)\n                        ui.position = sortable.position;\n                    }\n                } else {\n\n                    // If it doesn't intersect with the sortable, and it intersected before,\n                    // we fake the drag stop of the sortable, but make sure it doesn't remove\n                    // the helper by using cancelHelperRemoval.\n                    if ( sortable.isOver ) {\n\n                        sortable.isOver = 0;\n                        sortable.cancelHelperRemoval = true;\n\n                        // Calling sortable's mouseStop would trigger a revert,\n                        // so revert must be temporarily false until after mouseStop is called.\n                        sortable.options._revert = sortable.options.revert;\n                        sortable.options.revert = false;\n\n                        sortable._trigger( \"out\", event, sortable._uiHash( sortable ) );\n                        sortable._mouseStop( event, true );\n\n                        // Restore sortable behaviors that were modfied\n                        // when the draggable entered the sortable area (#9481)\n                        sortable.options.revert = sortable.options._revert;\n                        sortable.options.helper = sortable.options._helper;\n\n                        if ( sortable.placeholder ) {\n                            sortable.placeholder.remove();\n                        }\n\n                        // Restore and recalculate the draggable's offset considering the sortable\n                        // may have modified them in unexpected ways. (#8809, #10669)\n                        ui.helper.appendTo( draggable._parent );\n                        draggable._refreshOffsets( event );\n                        ui.position = draggable._generatePosition( event, true );\n\n                        draggable._trigger( \"fromSortable\", event );\n\n                        // Inform draggable that the helper is no longer in a valid drop zone\n                        draggable.dropped = false;\n\n                        // Need to refreshPositions of all sortables just in case removing\n                        // from one sortable changes the location of other sortables (#9675)\n                        $.each( draggable.sortables, function() {\n                            this.refreshPositions();\n                        } );\n                    }\n                }\n            } );\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"cursor\", {\n        start: function( event, ui, instance ) {\n            var t = $( \"body\" ),\n                o = instance.options;\n\n            if ( t.css( \"cursor\" ) ) {\n                o._cursor = t.css( \"cursor\" );\n            }\n            t.css( \"cursor\", o.cursor );\n        },\n        stop: function( event, ui, instance ) {\n            var o = instance.options;\n            if ( o._cursor ) {\n                $( \"body\" ).css( \"cursor\", o._cursor );\n            }\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"opacity\", {\n        start: function( event, ui, instance ) {\n            var t = $( ui.helper ),\n                o = instance.options;\n            if ( t.css( \"opacity\" ) ) {\n                o._opacity = t.css( \"opacity\" );\n            }\n            t.css( \"opacity\", o.opacity );\n        },\n        stop: function( event, ui, instance ) {\n            var o = instance.options;\n            if ( o._opacity ) {\n                $( ui.helper ).css( \"opacity\", o._opacity );\n            }\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"scroll\", {\n        start: function( event, ui, i ) {\n            if ( !i.scrollParentNotHidden ) {\n                i.scrollParentNotHidden = i.helper.scrollParent( false );\n            }\n\n            if ( i.scrollParentNotHidden[ 0 ] !== i.document[ 0 ] &&\n                i.scrollParentNotHidden[ 0 ].tagName !== \"HTML\" ) {\n                i.overflowOffset = i.scrollParentNotHidden.offset();\n            }\n        },\n        drag: function( event, ui, i  ) {\n\n            var o = i.options,\n                scrolled = false,\n                scrollParent = i.scrollParentNotHidden[ 0 ],\n                document = i.document[ 0 ];\n\n            if ( scrollParent !== document && scrollParent.tagName !== \"HTML\" ) {\n                if ( !o.axis || o.axis !== \"x\" ) {\n                    if ( ( i.overflowOffset.top + scrollParent.offsetHeight ) - event.pageY <\n                        o.scrollSensitivity ) {\n                        scrollParent.scrollTop = scrolled = scrollParent.scrollTop + o.scrollSpeed;\n                    } else if ( event.pageY - i.overflowOffset.top < o.scrollSensitivity ) {\n                        scrollParent.scrollTop = scrolled = scrollParent.scrollTop - o.scrollSpeed;\n                    }\n                }\n\n                if ( !o.axis || o.axis !== \"y\" ) {\n                    if ( ( i.overflowOffset.left + scrollParent.offsetWidth ) - event.pageX <\n                        o.scrollSensitivity ) {\n                        scrollParent.scrollLeft = scrolled = scrollParent.scrollLeft + o.scrollSpeed;\n                    } else if ( event.pageX - i.overflowOffset.left < o.scrollSensitivity ) {\n                        scrollParent.scrollLeft = scrolled = scrollParent.scrollLeft - o.scrollSpeed;\n                    }\n                }\n\n            } else {\n\n                if ( !o.axis || o.axis !== \"x\" ) {\n                    if ( event.pageY - $( document ).scrollTop() < o.scrollSensitivity ) {\n                        scrolled = $( document ).scrollTop( $( document ).scrollTop() - o.scrollSpeed );\n                    } else if ( $( window ).height() - ( event.pageY - $( document ).scrollTop() ) <\n                        o.scrollSensitivity ) {\n                        scrolled = $( document ).scrollTop( $( document ).scrollTop() + o.scrollSpeed );\n                    }\n                }\n\n                if ( !o.axis || o.axis !== \"y\" ) {\n                    if ( event.pageX - $( document ).scrollLeft() < o.scrollSensitivity ) {\n                        scrolled = $( document ).scrollLeft(\n                            $( document ).scrollLeft() - o.scrollSpeed\n                        );\n                    } else if ( $( window ).width() - ( event.pageX - $( document ).scrollLeft() ) <\n                        o.scrollSensitivity ) {\n                        scrolled = $( document ).scrollLeft(\n                            $( document ).scrollLeft() + o.scrollSpeed\n                        );\n                    }\n                }\n\n            }\n\n            if ( scrolled !== false && $.ui.ddmanager && !o.dropBehaviour ) {\n                $.ui.ddmanager.prepareOffsets( i, event );\n            }\n\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"snap\", {\n        start: function( event, ui, i ) {\n\n            var o = i.options;\n\n            i.snapElements = [];\n\n            $( o.snap.constructor !== String ? ( o.snap.items || \":data(ui-draggable)\" ) : o.snap )\n                .each( function() {\n                    var $t = $( this ),\n                        $o = $t.offset();\n                    if ( this !== i.element[ 0 ] ) {\n                        i.snapElements.push( {\n                            item: this,\n                            width: $t.outerWidth(), height: $t.outerHeight(),\n                            top: $o.top, left: $o.left\n                        } );\n                    }\n                } );\n\n        },\n        drag: function( event, ui, inst ) {\n\n            var ts, bs, ls, rs, l, r, t, b, i, first,\n                o = inst.options,\n                d = o.snapTolerance,\n                x1 = ui.offset.left, x2 = x1 + inst.helperProportions.width,\n                y1 = ui.offset.top, y2 = y1 + inst.helperProportions.height;\n\n            for ( i = inst.snapElements.length - 1; i >= 0; i-- ) {\n\n                l = inst.snapElements[ i ].left - inst.margins.left;\n                r = l + inst.snapElements[ i ].width;\n                t = inst.snapElements[ i ].top - inst.margins.top;\n                b = t + inst.snapElements[ i ].height;\n\n                if ( x2 < l - d || x1 > r + d || y2 < t - d || y1 > b + d ||\n                    !$.contains( inst.snapElements[ i ].item.ownerDocument,\n                        inst.snapElements[ i ].item ) ) {\n                    if ( inst.snapElements[ i ].snapping ) {\n                        if ( inst.options.snap.release ) {\n                            inst.options.snap.release.call(\n                                inst.element,\n                                event,\n                                $.extend( inst._uiHash(), { snapItem: inst.snapElements[ i ].item } )\n                            );\n                        }\n                    }\n                    inst.snapElements[ i ].snapping = false;\n                    continue;\n                }\n\n                if ( o.snapMode !== \"inner\" ) {\n                    ts = Math.abs( t - y2 ) <= d;\n                    bs = Math.abs( b - y1 ) <= d;\n                    ls = Math.abs( l - x2 ) <= d;\n                    rs = Math.abs( r - x1 ) <= d;\n                    if ( ts ) {\n                        ui.position.top = inst._convertPositionTo( \"relative\", {\n                            top: t - inst.helperProportions.height,\n                            left: 0\n                        } ).top;\n                    }\n                    if ( bs ) {\n                        ui.position.top = inst._convertPositionTo( \"relative\", {\n                            top: b,\n                            left: 0\n                        } ).top;\n                    }\n                    if ( ls ) {\n                        ui.position.left = inst._convertPositionTo( \"relative\", {\n                            top: 0,\n                            left: l - inst.helperProportions.width\n                        } ).left;\n                    }\n                    if ( rs ) {\n                        ui.position.left = inst._convertPositionTo( \"relative\", {\n                            top: 0,\n                            left: r\n                        } ).left;\n                    }\n                }\n\n                first = ( ts || bs || ls || rs );\n\n                if ( o.snapMode !== \"outer\" ) {\n                    ts = Math.abs( t - y1 ) <= d;\n                    bs = Math.abs( b - y2 ) <= d;\n                    ls = Math.abs( l - x1 ) <= d;\n                    rs = Math.abs( r - x2 ) <= d;\n                    if ( ts ) {\n                        ui.position.top = inst._convertPositionTo( \"relative\", {\n                            top: t,\n                            left: 0\n                        } ).top;\n                    }\n                    if ( bs ) {\n                        ui.position.top = inst._convertPositionTo( \"relative\", {\n                            top: b - inst.helperProportions.height,\n                            left: 0\n                        } ).top;\n                    }\n                    if ( ls ) {\n                        ui.position.left = inst._convertPositionTo( \"relative\", {\n                            top: 0,\n                            left: l\n                        } ).left;\n                    }\n                    if ( rs ) {\n                        ui.position.left = inst._convertPositionTo( \"relative\", {\n                            top: 0,\n                            left: r - inst.helperProportions.width\n                        } ).left;\n                    }\n                }\n\n                if ( !inst.snapElements[ i ].snapping && ( ts || bs || ls || rs || first ) ) {\n                    if ( inst.options.snap.snap ) {\n                        inst.options.snap.snap.call(\n                            inst.element,\n                            event,\n                            $.extend( inst._uiHash(), {\n                                snapItem: inst.snapElements[ i ].item\n                            } ) );\n                    }\n                }\n                inst.snapElements[ i ].snapping = ( ts || bs || ls || rs || first );\n\n            }\n\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"stack\", {\n        start: function( event, ui, instance ) {\n            var min,\n                o = instance.options,\n                group = $.makeArray( $( o.stack ) ).sort( function( a, b ) {\n                    return ( parseInt( $( a ).css( \"zIndex\" ), 10 ) || 0 ) -\n                        ( parseInt( $( b ).css( \"zIndex\" ), 10 ) || 0 );\n                } );\n\n            if ( !group.length ) {\n                return;\n            }\n\n            min = parseInt( $( group[ 0 ] ).css( \"zIndex\" ), 10 ) || 0;\n            $( group ).each( function( i ) {\n                $( this ).css( \"zIndex\", min + i );\n            } );\n            this.css( \"zIndex\", ( min + group.length ) );\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"zIndex\", {\n        start: function( event, ui, instance ) {\n            var t = $( ui.helper ),\n                o = instance.options;\n\n            if ( t.css( \"zIndex\" ) ) {\n                o._zIndex = t.css( \"zIndex\" );\n            }\n            t.css( \"zIndex\", o.zIndex );\n        },\n        stop: function( event, ui, instance ) {\n            var o = instance.options;\n\n            if ( o._zIndex ) {\n                $( ui.helper ).css( \"zIndex\", o._zIndex );\n            }\n        }\n    } );\n\n    return $.ui.draggable;\n\n} );\n","jquery/ui-modules/widgets/checkboxradio.js":"/*!\n * jQuery UI Checkboxradio 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Checkboxradio\n//>>group: Widgets\n//>>description: Enhances a form with multiple themeable checkboxes or radio buttons.\n//>>docs: http://api.jqueryui.com/checkboxradio/\n//>>demos: http://jqueryui.com/checkboxradio/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/button.css\n//>>css.structure: ../../themes/base/checkboxradio.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../form-reset-mixin\",\n            \"../labels\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.checkboxradio\", [ $.ui.formResetMixin, {\n        version: \"1.13.2\",\n        options: {\n            disabled: null,\n            label: null,\n            icon: true,\n            classes: {\n                \"ui-checkboxradio-label\": \"ui-corner-all\",\n                \"ui-checkboxradio-icon\": \"ui-corner-all\"\n            }\n        },\n\n        _getCreateOptions: function() {\n            var disabled, labels, labelContents;\n            var options = this._super() || {};\n\n            // We read the type here, because it makes more sense to throw a element type error first,\n            // rather then the error for lack of a label. Often if its the wrong type, it\n            // won't have a label (e.g. calling on a div, btn, etc)\n            this._readType();\n\n            labels = this.element.labels();\n\n            // If there are multiple labels, use the last one\n            this.label = $( labels[ labels.length - 1 ] );\n            if ( !this.label.length ) {\n                $.error( \"No label found for checkboxradio widget\" );\n            }\n\n            this.originalLabel = \"\";\n\n            // We need to get the label text but this may also need to make sure it does not contain the\n            // input itself.\n            // The label contents could be text, html, or a mix. We wrap all elements\n            // and read the wrapper's `innerHTML` to get a string representation of\n            // the label, without the input as part of it.\n            labelContents = this.label.contents().not( this.element[ 0 ] );\n\n            if ( labelContents.length ) {\n                this.originalLabel += labelContents\n                    .clone()\n                    .wrapAll( \"<div></div>\" )\n                    .parent()\n                    .html();\n            }\n\n            // Set the label option if we found label text\n            if ( this.originalLabel ) {\n                options.label = this.originalLabel;\n            }\n\n            disabled = this.element[ 0 ].disabled;\n            if ( disabled != null ) {\n                options.disabled = disabled;\n            }\n            return options;\n        },\n\n        _create: function() {\n            var checked = this.element[ 0 ].checked;\n\n            this._bindFormResetHandler();\n\n            if ( this.options.disabled == null ) {\n                this.options.disabled = this.element[ 0 ].disabled;\n            }\n\n            this._setOption( \"disabled\", this.options.disabled );\n            this._addClass( \"ui-checkboxradio\", \"ui-helper-hidden-accessible\" );\n            this._addClass( this.label, \"ui-checkboxradio-label\", \"ui-button ui-widget\" );\n\n            if ( this.type === \"radio\" ) {\n                this._addClass( this.label, \"ui-checkboxradio-radio-label\" );\n            }\n\n            if ( this.options.label && this.options.label !== this.originalLabel ) {\n                this._updateLabel();\n            } else if ( this.originalLabel ) {\n                this.options.label = this.originalLabel;\n            }\n\n            this._enhance();\n\n            if ( checked ) {\n                this._addClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\" );\n            }\n\n            this._on( {\n                change: \"_toggleClasses\",\n                focus: function() {\n                    this._addClass( this.label, null, \"ui-state-focus ui-visual-focus\" );\n                },\n                blur: function() {\n                    this._removeClass( this.label, null, \"ui-state-focus ui-visual-focus\" );\n                }\n            } );\n        },\n\n        _readType: function() {\n            var nodeName = this.element[ 0 ].nodeName.toLowerCase();\n            this.type = this.element[ 0 ].type;\n            if ( nodeName !== \"input\" || !/radio|checkbox/.test( this.type ) ) {\n                $.error( \"Can't create checkboxradio on element.nodeName=\" + nodeName +\n                    \" and element.type=\" + this.type );\n            }\n        },\n\n        // Support jQuery Mobile enhanced option\n        _enhance: function() {\n            this._updateIcon( this.element[ 0 ].checked );\n        },\n\n        widget: function() {\n            return this.label;\n        },\n\n        _getRadioGroup: function() {\n            var group;\n            var name = this.element[ 0 ].name;\n            var nameSelector = \"input[name='\" + $.escapeSelector( name ) + \"']\";\n\n            if ( !name ) {\n                return $( [] );\n            }\n\n            if ( this.form.length ) {\n                group = $( this.form[ 0 ].elements ).filter( nameSelector );\n            } else {\n\n                // Not inside a form, check all inputs that also are not inside a form\n                group = $( nameSelector ).filter( function() {\n                    return $( this )._form().length === 0;\n                } );\n            }\n\n            return group.not( this.element );\n        },\n\n        _toggleClasses: function() {\n            var checked = this.element[ 0 ].checked;\n            this._toggleClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\", checked );\n\n            if ( this.options.icon && this.type === \"checkbox\" ) {\n                this._toggleClass( this.icon, null, \"ui-icon-check ui-state-checked\", checked )\n                    ._toggleClass( this.icon, null, \"ui-icon-blank\", !checked );\n            }\n\n            if ( this.type === \"radio\" ) {\n                this._getRadioGroup()\n                    .each( function() {\n                        var instance = $( this ).checkboxradio( \"instance\" );\n\n                        if ( instance ) {\n                            instance._removeClass( instance.label,\n                                \"ui-checkboxradio-checked\", \"ui-state-active\" );\n                        }\n                    } );\n            }\n        },\n\n        _destroy: function() {\n            this._unbindFormResetHandler();\n\n            if ( this.icon ) {\n                this.icon.remove();\n                this.iconSpace.remove();\n            }\n        },\n\n        _setOption: function( key, value ) {\n\n            // We don't allow the value to be set to nothing\n            if ( key === \"label\" && !value ) {\n                return;\n            }\n\n            this._super( key, value );\n\n            if ( key === \"disabled\" ) {\n                this._toggleClass( this.label, null, \"ui-state-disabled\", value );\n                this.element[ 0 ].disabled = value;\n\n                // Don't refresh when setting disabled\n                return;\n            }\n            this.refresh();\n        },\n\n        _updateIcon: function( checked ) {\n            var toAdd = \"ui-icon ui-icon-background \";\n\n            if ( this.options.icon ) {\n                if ( !this.icon ) {\n                    this.icon = $( \"<span>\" );\n                    this.iconSpace = $( \"<span> </span>\" );\n                    this._addClass( this.iconSpace, \"ui-checkboxradio-icon-space\" );\n                }\n\n                if ( this.type === \"checkbox\" ) {\n                    toAdd += checked ? \"ui-icon-check ui-state-checked\" : \"ui-icon-blank\";\n                    this._removeClass( this.icon, null, checked ? \"ui-icon-blank\" : \"ui-icon-check\" );\n                } else {\n                    toAdd += \"ui-icon-blank\";\n                }\n                this._addClass( this.icon, \"ui-checkboxradio-icon\", toAdd );\n                if ( !checked ) {\n                    this._removeClass( this.icon, null, \"ui-icon-check ui-state-checked\" );\n                }\n                this.icon.prependTo( this.label ).after( this.iconSpace );\n            } else if ( this.icon !== undefined ) {\n                this.icon.remove();\n                this.iconSpace.remove();\n                delete this.icon;\n            }\n        },\n\n        _updateLabel: function() {\n\n            // Remove the contents of the label ( minus the icon, icon space, and input )\n            var contents = this.label.contents().not( this.element[ 0 ] );\n            if ( this.icon ) {\n                contents = contents.not( this.icon[ 0 ] );\n            }\n            if ( this.iconSpace ) {\n                contents = contents.not( this.iconSpace[ 0 ] );\n            }\n            contents.remove();\n\n            this.label.append( this.options.label );\n        },\n\n        refresh: function() {\n            var checked = this.element[ 0 ].checked,\n                isDisabled = this.element[ 0 ].disabled;\n\n            this._updateIcon( checked );\n            this._toggleClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\", checked );\n            if ( this.options.label !== null ) {\n                this._updateLabel();\n            }\n\n            if ( isDisabled !== this.options.disabled ) {\n                this._setOptions( { \"disabled\": isDisabled } );\n            }\n        }\n\n    } ] );\n\n    return $.ui.checkboxradio;\n\n} );\n","jquery/ui-modules/widgets/tooltip.js":"/*!\n * jQuery UI Tooltip 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Tooltip\n//>>group: Widgets\n//>>description: Shows additional information for any element on hover or focus.\n//>>docs: http://api.jqueryui.com/tooltip/\n//>>demos: http://jqueryui.com/tooltip/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/tooltip.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../keycode\",\n            \"../position\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.tooltip\", {\n        version: \"1.13.2\",\n        options: {\n            classes: {\n                \"ui-tooltip\": \"ui-corner-all ui-widget-shadow\"\n            },\n            content: function() {\n                var title = $( this ).attr( \"title\" );\n\n                // Escape title, since we're going from an attribute to raw HTML\n                return $( \"<a>\" ).text( title ).html();\n            },\n            hide: true,\n\n            // Disabled elements have inconsistent behavior across browsers (#8661)\n            items: \"[title]:not([disabled])\",\n            position: {\n                my: \"left top+15\",\n                at: \"left bottom\",\n                collision: \"flipfit flip\"\n            },\n            show: true,\n            track: false,\n\n            // Callbacks\n            close: null,\n            open: null\n        },\n\n        _addDescribedBy: function( elem, id ) {\n            var describedby = ( elem.attr( \"aria-describedby\" ) || \"\" ).split( /\\s+/ );\n            describedby.push( id );\n            elem\n                .data( \"ui-tooltip-id\", id )\n                .attr( \"aria-describedby\", String.prototype.trim.call( describedby.join( \" \" ) ) );\n        },\n\n        _removeDescribedBy: function( elem ) {\n            var id = elem.data( \"ui-tooltip-id\" ),\n                describedby = ( elem.attr( \"aria-describedby\" ) || \"\" ).split( /\\s+/ ),\n                index = $.inArray( id, describedby );\n\n            if ( index !== -1 ) {\n                describedby.splice( index, 1 );\n            }\n\n            elem.removeData( \"ui-tooltip-id\" );\n            describedby = String.prototype.trim.call( describedby.join( \" \" ) );\n            if ( describedby ) {\n                elem.attr( \"aria-describedby\", describedby );\n            } else {\n                elem.removeAttr( \"aria-describedby\" );\n            }\n        },\n\n        _create: function() {\n            this._on( {\n                mouseover: \"open\",\n                focusin: \"open\"\n            } );\n\n            // IDs of generated tooltips, needed for destroy\n            this.tooltips = {};\n\n            // IDs of parent tooltips where we removed the title attribute\n            this.parents = {};\n\n            // Append the aria-live region so tooltips announce correctly\n            this.liveRegion = $( \"<div>\" )\n                .attr( {\n                    role: \"log\",\n                    \"aria-live\": \"assertive\",\n                    \"aria-relevant\": \"additions\"\n                } )\n                .appendTo( this.document[ 0 ].body );\n            this._addClass( this.liveRegion, null, \"ui-helper-hidden-accessible\" );\n\n            this.disabledTitles = $( [] );\n        },\n\n        _setOption: function( key, value ) {\n            var that = this;\n\n            this._super( key, value );\n\n            if ( key === \"content\" ) {\n                $.each( this.tooltips, function( id, tooltipData ) {\n                    that._updateContent( tooltipData.element );\n                } );\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this[ value ? \"_disable\" : \"_enable\" ]();\n        },\n\n        _disable: function() {\n            var that = this;\n\n            // Close open tooltips\n            $.each( this.tooltips, function( id, tooltipData ) {\n                var event = $.Event( \"blur\" );\n                event.target = event.currentTarget = tooltipData.element[ 0 ];\n                that.close( event, true );\n            } );\n\n            // Remove title attributes to prevent native tooltips\n            this.disabledTitles = this.disabledTitles.add(\n                this.element.find( this.options.items ).addBack()\n                    .filter( function() {\n                        var element = $( this );\n                        if ( element.is( \"[title]\" ) ) {\n                            return element\n                                .data( \"ui-tooltip-title\", element.attr( \"title\" ) )\n                                .removeAttr( \"title\" );\n                        }\n                    } )\n            );\n        },\n\n        _enable: function() {\n\n            // restore title attributes\n            this.disabledTitles.each( function() {\n                var element = $( this );\n                if ( element.data( \"ui-tooltip-title\" ) ) {\n                    element.attr( \"title\", element.data( \"ui-tooltip-title\" ) );\n                }\n            } );\n            this.disabledTitles = $( [] );\n        },\n\n        open: function( event ) {\n            var that = this,\n                target = $( event ? event.target : this.element )\n\n                    // we need closest here due to mouseover bubbling,\n                    // but always pointing at the same event target\n                    .closest( this.options.items );\n\n            // No element to show a tooltip for or the tooltip is already open\n            if ( !target.length || target.data( \"ui-tooltip-id\" ) ) {\n                return;\n            }\n\n            if ( target.attr( \"title\" ) ) {\n                target.data( \"ui-tooltip-title\", target.attr( \"title\" ) );\n            }\n\n            target.data( \"ui-tooltip-open\", true );\n\n            // Kill parent tooltips, custom or native, for hover\n            if ( event && event.type === \"mouseover\" ) {\n                target.parents().each( function() {\n                    var parent = $( this ),\n                        blurEvent;\n                    if ( parent.data( \"ui-tooltip-open\" ) ) {\n                        blurEvent = $.Event( \"blur\" );\n                        blurEvent.target = blurEvent.currentTarget = this;\n                        that.close( blurEvent, true );\n                    }\n                    if ( parent.attr( \"title\" ) ) {\n                        parent.uniqueId();\n                        that.parents[ this.id ] = {\n                            element: this,\n                            title: parent.attr( \"title\" )\n                        };\n                        parent.attr( \"title\", \"\" );\n                    }\n                } );\n            }\n\n            this._registerCloseHandlers( event, target );\n            this._updateContent( target, event );\n        },\n\n        _updateContent: function( target, event ) {\n            var content,\n                contentOption = this.options.content,\n                that = this,\n                eventType = event ? event.type : null;\n\n            if ( typeof contentOption === \"string\" || contentOption.nodeType ||\n                contentOption.jquery ) {\n                return this._open( event, target, contentOption );\n            }\n\n            content = contentOption.call( target[ 0 ], function( response ) {\n\n                // IE may instantly serve a cached response for ajax requests\n                // delay this call to _open so the other call to _open runs first\n                that._delay( function() {\n\n                    // Ignore async response if tooltip was closed already\n                    if ( !target.data( \"ui-tooltip-open\" ) ) {\n                        return;\n                    }\n\n                    // JQuery creates a special event for focusin when it doesn't\n                    // exist natively. To improve performance, the native event\n                    // object is reused and the type is changed. Therefore, we can't\n                    // rely on the type being correct after the event finished\n                    // bubbling, so we set it back to the previous value. (#8740)\n                    if ( event ) {\n                        event.type = eventType;\n                    }\n                    this._open( event, target, response );\n                } );\n            } );\n            if ( content ) {\n                this._open( event, target, content );\n            }\n        },\n\n        _open: function( event, target, content ) {\n            var tooltipData, tooltip, delayedShow, a11yContent,\n                positionOption = $.extend( {}, this.options.position );\n\n            if ( !content ) {\n                return;\n            }\n\n            // Content can be updated multiple times. If the tooltip already\n            // exists, then just update the content and bail.\n            tooltipData = this._find( target );\n            if ( tooltipData ) {\n                tooltipData.tooltip.find( \".ui-tooltip-content\" ).html( content );\n                return;\n            }\n\n            // If we have a title, clear it to prevent the native tooltip\n            // we have to check first to avoid defining a title if none exists\n            // (we don't want to cause an element to start matching [title])\n            //\n            // We use removeAttr only for key events, to allow IE to export the correct\n            // accessible attributes. For mouse events, set to empty string to avoid\n            // native tooltip showing up (happens only when removing inside mouseover).\n            if ( target.is( \"[title]\" ) ) {\n                if ( event && event.type === \"mouseover\" ) {\n                    target.attr( \"title\", \"\" );\n                } else {\n                    target.removeAttr( \"title\" );\n                }\n            }\n\n            tooltipData = this._tooltip( target );\n            tooltip = tooltipData.tooltip;\n            this._addDescribedBy( target, tooltip.attr( \"id\" ) );\n            tooltip.find( \".ui-tooltip-content\" ).html( content );\n\n            // Support: Voiceover on OS X, JAWS on IE <= 9\n            // JAWS announces deletions even when aria-relevant=\"additions\"\n            // Voiceover will sometimes re-read the entire log region's contents from the beginning\n            this.liveRegion.children().hide();\n            a11yContent = $( \"<div>\" ).html( tooltip.find( \".ui-tooltip-content\" ).html() );\n            a11yContent.removeAttr( \"name\" ).find( \"[name]\" ).removeAttr( \"name\" );\n            a11yContent.removeAttr( \"id\" ).find( \"[id]\" ).removeAttr( \"id\" );\n            a11yContent.appendTo( this.liveRegion );\n\n            function position( event ) {\n                positionOption.of = event;\n                if ( tooltip.is( \":hidden\" ) ) {\n                    return;\n                }\n                tooltip.position( positionOption );\n            }\n            if ( this.options.track && event && /^mouse/.test( event.type ) ) {\n                this._on( this.document, {\n                    mousemove: position\n                } );\n\n                // trigger once to override element-relative positioning\n                position( event );\n            } else {\n                tooltip.position( $.extend( {\n                    of: target\n                }, this.options.position ) );\n            }\n\n            tooltip.hide();\n\n            this._show( tooltip, this.options.show );\n\n            // Handle tracking tooltips that are shown with a delay (#8644). As soon\n            // as the tooltip is visible, position the tooltip using the most recent\n            // event.\n            // Adds the check to add the timers only when both delay and track options are set (#14682)\n            if ( this.options.track && this.options.show && this.options.show.delay ) {\n                delayedShow = this.delayedShow = setInterval( function() {\n                    if ( tooltip.is( \":visible\" ) ) {\n                        position( positionOption.of );\n                        clearInterval( delayedShow );\n                    }\n                }, 13 );\n            }\n\n            this._trigger( \"open\", event, { tooltip: tooltip } );\n        },\n\n        _registerCloseHandlers: function( event, target ) {\n            var events = {\n                keyup: function( event ) {\n                    if ( event.keyCode === $.ui.keyCode.ESCAPE ) {\n                        var fakeEvent = $.Event( event );\n                        fakeEvent.currentTarget = target[ 0 ];\n                        this.close( fakeEvent, true );\n                    }\n                }\n            };\n\n            // Only bind remove handler for delegated targets. Non-delegated\n            // tooltips will handle this in destroy.\n            if ( target[ 0 ] !== this.element[ 0 ] ) {\n                events.remove = function() {\n                    var targetElement = this._find( target );\n                    if ( targetElement ) {\n                        this._removeTooltip( targetElement.tooltip );\n                    }\n                };\n            }\n\n            if ( !event || event.type === \"mouseover\" ) {\n                events.mouseleave = \"close\";\n            }\n            if ( !event || event.type === \"focusin\" ) {\n                events.focusout = \"close\";\n            }\n            this._on( true, target, events );\n        },\n\n        close: function( event ) {\n            var tooltip,\n                that = this,\n                target = $( event ? event.currentTarget : this.element ),\n                tooltipData = this._find( target );\n\n            // The tooltip may already be closed\n            if ( !tooltipData ) {\n\n                // We set ui-tooltip-open immediately upon open (in open()), but only set the\n                // additional data once there's actually content to show (in _open()). So even if the\n                // tooltip doesn't have full data, we always remove ui-tooltip-open in case we're in\n                // the period between open() and _open().\n                target.removeData( \"ui-tooltip-open\" );\n                return;\n            }\n\n            tooltip = tooltipData.tooltip;\n\n            // Disabling closes the tooltip, so we need to track when we're closing\n            // to avoid an infinite loop in case the tooltip becomes disabled on close\n            if ( tooltipData.closing ) {\n                return;\n            }\n\n            // Clear the interval for delayed tracking tooltips\n            clearInterval( this.delayedShow );\n\n            // Only set title if we had one before (see comment in _open())\n            // If the title attribute has changed since open(), don't restore\n            if ( target.data( \"ui-tooltip-title\" ) && !target.attr( \"title\" ) ) {\n                target.attr( \"title\", target.data( \"ui-tooltip-title\" ) );\n            }\n\n            this._removeDescribedBy( target );\n\n            tooltipData.hiding = true;\n            tooltip.stop( true );\n            this._hide( tooltip, this.options.hide, function() {\n                that._removeTooltip( $( this ) );\n            } );\n\n            target.removeData( \"ui-tooltip-open\" );\n            this._off( target, \"mouseleave focusout keyup\" );\n\n            // Remove 'remove' binding only on delegated targets\n            if ( target[ 0 ] !== this.element[ 0 ] ) {\n                this._off( target, \"remove\" );\n            }\n            this._off( this.document, \"mousemove\" );\n\n            if ( event && event.type === \"mouseleave\" ) {\n                $.each( this.parents, function( id, parent ) {\n                    $( parent.element ).attr( \"title\", parent.title );\n                    delete that.parents[ id ];\n                } );\n            }\n\n            tooltipData.closing = true;\n            this._trigger( \"close\", event, { tooltip: tooltip } );\n            if ( !tooltipData.hiding ) {\n                tooltipData.closing = false;\n            }\n        },\n\n        _tooltip: function( element ) {\n            var tooltip = $( \"<div>\" ).attr( \"role\", \"tooltip\" ),\n                content = $( \"<div>\" ).appendTo( tooltip ),\n                id = tooltip.uniqueId().attr( \"id\" );\n\n            this._addClass( content, \"ui-tooltip-content\" );\n            this._addClass( tooltip, \"ui-tooltip\", \"ui-widget ui-widget-content\" );\n\n            tooltip.appendTo( this._appendTo( element ) );\n\n            return this.tooltips[ id ] = {\n                element: element,\n                tooltip: tooltip\n            };\n        },\n\n        _find: function( target ) {\n            var id = target.data( \"ui-tooltip-id\" );\n            return id ? this.tooltips[ id ] : null;\n        },\n\n        _removeTooltip: function( tooltip ) {\n\n            // Clear the interval for delayed tracking tooltips\n            clearInterval( this.delayedShow );\n\n            tooltip.remove();\n            delete this.tooltips[ tooltip.attr( \"id\" ) ];\n        },\n\n        _appendTo: function( target ) {\n            var element = target.closest( \".ui-front, dialog\" );\n\n            if ( !element.length ) {\n                element = this.document[ 0 ].body;\n            }\n\n            return element;\n        },\n\n        _destroy: function() {\n            var that = this;\n\n            // Close open tooltips\n            $.each( this.tooltips, function( id, tooltipData ) {\n\n                // Delegate to close method to handle common cleanup\n                var event = $.Event( \"blur\" ),\n                    element = tooltipData.element;\n                event.target = event.currentTarget = element[ 0 ];\n                that.close( event, true );\n\n                // Remove immediately; destroying an open tooltip doesn't use the\n                // hide animation\n                $( \"#\" + id ).remove();\n\n                // Restore the title\n                if ( element.data( \"ui-tooltip-title\" ) ) {\n\n                    // If the title attribute has changed since open(), don't restore\n                    if ( !element.attr( \"title\" ) ) {\n                        element.attr( \"title\", element.data( \"ui-tooltip-title\" ) );\n                    }\n                    element.removeData( \"ui-tooltip-title\" );\n                }\n            } );\n            this.liveRegion.remove();\n        }\n    } );\n\n// DEPRECATED\n// TODO: Switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for tooltipClass option\n        $.widget( \"ui.tooltip\", $.ui.tooltip, {\n            options: {\n                tooltipClass: null\n            },\n            _tooltip: function() {\n                var tooltipData = this._superApply( arguments );\n                if ( this.options.tooltipClass ) {\n                    tooltipData.tooltip.addClass( this.options.tooltipClass );\n                }\n                return tooltipData;\n            }\n        } );\n    }\n\n    return $.ui.tooltip;\n\n} );\n","jquery/ui-modules/widgets/dialog.js":"/*!\n * jQuery UI Dialog 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Dialog\n//>>group: Widgets\n//>>description: Displays customizable dialog windows.\n//>>docs: http://api.jqueryui.com/dialog/\n//>>demos: http://jqueryui.com/dialog/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/dialog.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./button\",\n            \"./draggable\",\n            \"./mouse\",\n            \"./resizable\",\n            \"../focusable\",\n            \"../keycode\",\n            \"../position\",\n            \"../safe-active-element\",\n            \"../safe-blur\",\n            \"../tabbable\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.dialog\", {\n        version: \"1.13.2\",\n        options: {\n            appendTo: \"body\",\n            autoOpen: true,\n            buttons: [],\n            classes: {\n                \"ui-dialog\": \"ui-corner-all\",\n                \"ui-dialog-titlebar\": \"ui-corner-all\"\n            },\n            closeOnEscape: true,\n            closeText: \"Close\",\n            draggable: true,\n            hide: null,\n            height: \"auto\",\n            maxHeight: null,\n            maxWidth: null,\n            minHeight: 150,\n            minWidth: 150,\n            modal: false,\n            position: {\n                my: \"center\",\n                at: \"center\",\n                of: window,\n                collision: \"fit\",\n\n                // Ensure the titlebar is always visible\n                using: function( pos ) {\n                    var topOffset = $( this ).css( pos ).offset().top;\n                    if ( topOffset < 0 ) {\n                        $( this ).css( \"top\", pos.top - topOffset );\n                    }\n                }\n            },\n            resizable: true,\n            show: null,\n            title: null,\n            width: 300,\n\n            // Callbacks\n            beforeClose: null,\n            close: null,\n            drag: null,\n            dragStart: null,\n            dragStop: null,\n            focus: null,\n            open: null,\n            resize: null,\n            resizeStart: null,\n            resizeStop: null\n        },\n\n        sizeRelatedOptions: {\n            buttons: true,\n            height: true,\n            maxHeight: true,\n            maxWidth: true,\n            minHeight: true,\n            minWidth: true,\n            width: true\n        },\n\n        resizableRelatedOptions: {\n            maxHeight: true,\n            maxWidth: true,\n            minHeight: true,\n            minWidth: true\n        },\n\n        _create: function() {\n            this.originalCss = {\n                display: this.element[ 0 ].style.display,\n                width: this.element[ 0 ].style.width,\n                minHeight: this.element[ 0 ].style.minHeight,\n                maxHeight: this.element[ 0 ].style.maxHeight,\n                height: this.element[ 0 ].style.height\n            };\n            this.originalPosition = {\n                parent: this.element.parent(),\n                index: this.element.parent().children().index( this.element )\n            };\n            this.originalTitle = this.element.attr( \"title\" );\n            if ( this.options.title == null && this.originalTitle != null ) {\n                this.options.title = this.originalTitle;\n            }\n\n            // Dialogs can't be disabled\n            if ( this.options.disabled ) {\n                this.options.disabled = false;\n            }\n\n            this._createWrapper();\n\n            this.element\n                .show()\n                .removeAttr( \"title\" )\n                .appendTo( this.uiDialog );\n\n            this._addClass( \"ui-dialog-content\", \"ui-widget-content\" );\n\n            this._createTitlebar();\n            this._createButtonPane();\n\n            if ( this.options.draggable && $.fn.draggable ) {\n                this._makeDraggable();\n            }\n            if ( this.options.resizable && $.fn.resizable ) {\n                this._makeResizable();\n            }\n\n            this._isOpen = false;\n\n            this._trackFocus();\n        },\n\n        _init: function() {\n            if ( this.options.autoOpen ) {\n                this.open();\n            }\n        },\n\n        _appendTo: function() {\n            var element = this.options.appendTo;\n            if ( element && ( element.jquery || element.nodeType ) ) {\n                return $( element );\n            }\n            return this.document.find( element || \"body\" ).eq( 0 );\n        },\n\n        _destroy: function() {\n            var next,\n                originalPosition = this.originalPosition;\n\n            this._untrackInstance();\n            this._destroyOverlay();\n\n            this.element\n                .removeUniqueId()\n                .css( this.originalCss )\n\n                // Without detaching first, the following becomes really slow\n                .detach();\n\n            this.uiDialog.remove();\n\n            if ( this.originalTitle ) {\n                this.element.attr( \"title\", this.originalTitle );\n            }\n\n            next = originalPosition.parent.children().eq( originalPosition.index );\n\n            // Don't try to place the dialog next to itself (#8613)\n            if ( next.length && next[ 0 ] !== this.element[ 0 ] ) {\n                next.before( this.element );\n            } else {\n                originalPosition.parent.append( this.element );\n            }\n        },\n\n        widget: function() {\n            return this.uiDialog;\n        },\n\n        disable: $.noop,\n        enable: $.noop,\n\n        close: function( event ) {\n            var that = this;\n\n            if ( !this._isOpen || this._trigger( \"beforeClose\", event ) === false ) {\n                return;\n            }\n\n            this._isOpen = false;\n            this._focusedElement = null;\n            this._destroyOverlay();\n            this._untrackInstance();\n\n            if ( !this.opener.filter( \":focusable\" ).trigger( \"focus\" ).length ) {\n\n                // Hiding a focused element doesn't trigger blur in WebKit\n                // so in case we have nothing to focus on, explicitly blur the active element\n                // https://bugs.webkit.org/show_bug.cgi?id=47182\n                $.ui.safeBlur( $.ui.safeActiveElement( this.document[ 0 ] ) );\n            }\n\n            this._hide( this.uiDialog, this.options.hide, function() {\n                that._trigger( \"close\", event );\n            } );\n        },\n\n        isOpen: function() {\n            return this._isOpen;\n        },\n\n        moveToTop: function() {\n            this._moveToTop();\n        },\n\n        _moveToTop: function( event, silent ) {\n            var moved = false,\n                zIndices = this.uiDialog.siblings( \".ui-front:visible\" ).map( function() {\n                    return +$( this ).css( \"z-index\" );\n                } ).get(),\n                zIndexMax = Math.max.apply( null, zIndices );\n\n            if ( zIndexMax >= +this.uiDialog.css( \"z-index\" ) ) {\n                this.uiDialog.css( \"z-index\", zIndexMax + 1 );\n                moved = true;\n            }\n\n            if ( moved && !silent ) {\n                this._trigger( \"focus\", event );\n            }\n            return moved;\n        },\n\n        open: function() {\n            var that = this;\n            if ( this._isOpen ) {\n                if ( this._moveToTop() ) {\n                    this._focusTabbable();\n                }\n                return;\n            }\n\n            this._isOpen = true;\n            this.opener = $( $.ui.safeActiveElement( this.document[ 0 ] ) );\n\n            this._size();\n            this._position();\n            this._createOverlay();\n            this._moveToTop( null, true );\n\n            // Ensure the overlay is moved to the top with the dialog, but only when\n            // opening. The overlay shouldn't move after the dialog is open so that\n            // modeless dialogs opened after the modal dialog stack properly.\n            if ( this.overlay ) {\n                this.overlay.css( \"z-index\", this.uiDialog.css( \"z-index\" ) - 1 );\n            }\n\n            this._show( this.uiDialog, this.options.show, function() {\n                that._focusTabbable();\n                that._trigger( \"focus\" );\n            } );\n\n            // Track the dialog immediately upon opening in case a focus event\n            // somehow occurs outside of the dialog before an element inside the\n            // dialog is focused (#10152)\n            this._makeFocusTarget();\n\n            this._trigger( \"open\" );\n        },\n\n        _focusTabbable: function() {\n\n            // Set focus to the first match:\n            // 1. An element that was focused previously\n            // 2. First element inside the dialog matching [autofocus]\n            // 3. Tabbable element inside the content element\n            // 4. Tabbable element inside the buttonpane\n            // 5. The close button\n            // 6. The dialog itself\n            var hasFocus = this._focusedElement;\n            if ( !hasFocus ) {\n                hasFocus = this.element.find( \"[autofocus]\" );\n            }\n            if ( !hasFocus.length ) {\n                hasFocus = this.element.find( \":tabbable\" );\n            }\n            if ( !hasFocus.length ) {\n                hasFocus = this.uiDialogButtonPane.find( \":tabbable\" );\n            }\n            if ( !hasFocus.length ) {\n                hasFocus = this.uiDialogTitlebarClose.filter( \":tabbable\" );\n            }\n            if ( !hasFocus.length ) {\n                hasFocus = this.uiDialog;\n            }\n            hasFocus.eq( 0 ).trigger( \"focus\" );\n        },\n\n        _restoreTabbableFocus: function() {\n            var activeElement = $.ui.safeActiveElement( this.document[ 0 ] ),\n                isActive = this.uiDialog[ 0 ] === activeElement ||\n                    $.contains( this.uiDialog[ 0 ], activeElement );\n            if ( !isActive ) {\n                this._focusTabbable();\n            }\n        },\n\n        _keepFocus: function( event ) {\n            event.preventDefault();\n            this._restoreTabbableFocus();\n\n            // support: IE\n            // IE <= 8 doesn't prevent moving focus even with event.preventDefault()\n            // so we check again later\n            this._delay( this._restoreTabbableFocus );\n        },\n\n        _createWrapper: function() {\n            this.uiDialog = $( \"<div>\" )\n                .hide()\n                .attr( {\n\n                    // Setting tabIndex makes the div focusable\n                    tabIndex: -1,\n                    role: \"dialog\"\n                } )\n                .appendTo( this._appendTo() );\n\n            this._addClass( this.uiDialog, \"ui-dialog\", \"ui-widget ui-widget-content ui-front\" );\n            this._on( this.uiDialog, {\n                keydown: function( event ) {\n                    if ( this.options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode &&\n                        event.keyCode === $.ui.keyCode.ESCAPE ) {\n                        event.preventDefault();\n                        this.close( event );\n                        return;\n                    }\n\n                    // Prevent tabbing out of dialogs\n                    if ( event.keyCode !== $.ui.keyCode.TAB || event.isDefaultPrevented() ) {\n                        return;\n                    }\n                    var tabbables = this.uiDialog.find( \":tabbable\" ),\n                        first = tabbables.first(),\n                        last = tabbables.last();\n\n                    if ( ( event.target === last[ 0 ] || event.target === this.uiDialog[ 0 ] ) &&\n                        !event.shiftKey ) {\n                        this._delay( function() {\n                            first.trigger( \"focus\" );\n                        } );\n                        event.preventDefault();\n                    } else if ( ( event.target === first[ 0 ] ||\n                        event.target === this.uiDialog[ 0 ] ) && event.shiftKey ) {\n                        this._delay( function() {\n                            last.trigger( \"focus\" );\n                        } );\n                        event.preventDefault();\n                    }\n                },\n                mousedown: function( event ) {\n                    if ( this._moveToTop( event ) ) {\n                        this._focusTabbable();\n                    }\n                }\n            } );\n\n            // We assume that any existing aria-describedby attribute means\n            // that the dialog content is marked up properly\n            // otherwise we brute force the content as the description\n            if ( !this.element.find( \"[aria-describedby]\" ).length ) {\n                this.uiDialog.attr( {\n                    \"aria-describedby\": this.element.uniqueId().attr( \"id\" )\n                } );\n            }\n        },\n\n        _createTitlebar: function() {\n            var uiDialogTitle;\n\n            this.uiDialogTitlebar = $( \"<div>\" );\n            this._addClass( this.uiDialogTitlebar,\n                \"ui-dialog-titlebar\", \"ui-widget-header ui-helper-clearfix\" );\n            this._on( this.uiDialogTitlebar, {\n                mousedown: function( event ) {\n\n                    // Don't prevent click on close button (#8838)\n                    // Focusing a dialog that is partially scrolled out of view\n                    // causes the browser to scroll it into view, preventing the click event\n                    if ( !$( event.target ).closest( \".ui-dialog-titlebar-close\" ) ) {\n\n                        // Dialog isn't getting focus when dragging (#8063)\n                        this.uiDialog.trigger( \"focus\" );\n                    }\n                }\n            } );\n\n            // Support: IE\n            // Use type=\"button\" to prevent enter keypresses in textboxes from closing the\n            // dialog in IE (#9312)\n            this.uiDialogTitlebarClose = $( \"<button type='button'></button>\" )\n                .button( {\n                    label: $( \"<a>\" ).text( this.options.closeText ).html(),\n                    icon: \"ui-icon-closethick\",\n                    showLabel: false\n                } )\n                .appendTo( this.uiDialogTitlebar );\n\n            this._addClass( this.uiDialogTitlebarClose, \"ui-dialog-titlebar-close\" );\n            this._on( this.uiDialogTitlebarClose, {\n                click: function( event ) {\n                    event.preventDefault();\n                    this.close( event );\n                }\n            } );\n\n            uiDialogTitle = $( \"<span>\" ).uniqueId().prependTo( this.uiDialogTitlebar );\n            this._addClass( uiDialogTitle, \"ui-dialog-title\" );\n            this._title( uiDialogTitle );\n\n            this.uiDialogTitlebar.prependTo( this.uiDialog );\n\n            this.uiDialog.attr( {\n                \"aria-labelledby\": uiDialogTitle.attr( \"id\" )\n            } );\n        },\n\n        _title: function( title ) {\n            if ( this.options.title ) {\n                title.text( this.options.title );\n            } else {\n                title.html( \"&#160;\" );\n            }\n        },\n\n        _createButtonPane: function() {\n            this.uiDialogButtonPane = $( \"<div>\" );\n            this._addClass( this.uiDialogButtonPane, \"ui-dialog-buttonpane\",\n                \"ui-widget-content ui-helper-clearfix\" );\n\n            this.uiButtonSet = $( \"<div>\" )\n                .appendTo( this.uiDialogButtonPane );\n            this._addClass( this.uiButtonSet, \"ui-dialog-buttonset\" );\n\n            this._createButtons();\n        },\n\n        _createButtons: function() {\n            var that = this,\n                buttons = this.options.buttons;\n\n            // If we already have a button pane, remove it\n            this.uiDialogButtonPane.remove();\n            this.uiButtonSet.empty();\n\n            if ( $.isEmptyObject( buttons ) || ( Array.isArray( buttons ) && !buttons.length ) ) {\n                this._removeClass( this.uiDialog, \"ui-dialog-buttons\" );\n                return;\n            }\n\n            $.each( buttons, function( name, props ) {\n                var click, buttonOptions;\n                props = typeof props === \"function\" ?\n                    { click: props, text: name } :\n                    props;\n\n                // Default to a non-submitting button\n                props = $.extend( { type: \"button\" }, props );\n\n                // Change the context for the click callback to be the main element\n                click = props.click;\n                buttonOptions = {\n                    icon: props.icon,\n                    iconPosition: props.iconPosition,\n                    showLabel: props.showLabel,\n\n                    // Deprecated options\n                    icons: props.icons,\n                    text: props.text\n                };\n\n                delete props.click;\n                delete props.icon;\n                delete props.iconPosition;\n                delete props.showLabel;\n\n                // Deprecated options\n                delete props.icons;\n                if ( typeof props.text === \"boolean\" ) {\n                    delete props.text;\n                }\n\n                $( \"<button></button>\", props )\n                    .button( buttonOptions )\n                    .appendTo( that.uiButtonSet )\n                    .on( \"click\", function() {\n                        click.apply( that.element[ 0 ], arguments );\n                    } );\n            } );\n            this._addClass( this.uiDialog, \"ui-dialog-buttons\" );\n            this.uiDialogButtonPane.appendTo( this.uiDialog );\n        },\n\n        _makeDraggable: function() {\n            var that = this,\n                options = this.options;\n\n            function filteredUi( ui ) {\n                return {\n                    position: ui.position,\n                    offset: ui.offset\n                };\n            }\n\n            this.uiDialog.draggable( {\n                cancel: \".ui-dialog-content, .ui-dialog-titlebar-close\",\n                handle: \".ui-dialog-titlebar\",\n                containment: \"document\",\n                start: function( event, ui ) {\n                    that._addClass( $( this ), \"ui-dialog-dragging\" );\n                    that._blockFrames();\n                    that._trigger( \"dragStart\", event, filteredUi( ui ) );\n                },\n                drag: function( event, ui ) {\n                    that._trigger( \"drag\", event, filteredUi( ui ) );\n                },\n                stop: function( event, ui ) {\n                    var left = ui.offset.left - that.document.scrollLeft(),\n                        top = ui.offset.top - that.document.scrollTop();\n\n                    options.position = {\n                        my: \"left top\",\n                        at: \"left\" + ( left >= 0 ? \"+\" : \"\" ) + left + \" \" +\n                            \"top\" + ( top >= 0 ? \"+\" : \"\" ) + top,\n                        of: that.window\n                    };\n                    that._removeClass( $( this ), \"ui-dialog-dragging\" );\n                    that._unblockFrames();\n                    that._trigger( \"dragStop\", event, filteredUi( ui ) );\n                }\n            } );\n        },\n\n        _makeResizable: function() {\n            var that = this,\n                options = this.options,\n                handles = options.resizable,\n\n                // .ui-resizable has position: relative defined in the stylesheet\n                // but dialogs have to use absolute or fixed positioning\n                position = this.uiDialog.css( \"position\" ),\n                resizeHandles = typeof handles === \"string\" ?\n                    handles :\n                    \"n,e,s,w,se,sw,ne,nw\";\n\n            function filteredUi( ui ) {\n                return {\n                    originalPosition: ui.originalPosition,\n                    originalSize: ui.originalSize,\n                    position: ui.position,\n                    size: ui.size\n                };\n            }\n\n            this.uiDialog.resizable( {\n                cancel: \".ui-dialog-content\",\n                containment: \"document\",\n                alsoResize: this.element,\n                maxWidth: options.maxWidth,\n                maxHeight: options.maxHeight,\n                minWidth: options.minWidth,\n                minHeight: this._minHeight(),\n                handles: resizeHandles,\n                start: function( event, ui ) {\n                    that._addClass( $( this ), \"ui-dialog-resizing\" );\n                    that._blockFrames();\n                    that._trigger( \"resizeStart\", event, filteredUi( ui ) );\n                },\n                resize: function( event, ui ) {\n                    that._trigger( \"resize\", event, filteredUi( ui ) );\n                },\n                stop: function( event, ui ) {\n                    var offset = that.uiDialog.offset(),\n                        left = offset.left - that.document.scrollLeft(),\n                        top = offset.top - that.document.scrollTop();\n\n                    options.height = that.uiDialog.height();\n                    options.width = that.uiDialog.width();\n                    options.position = {\n                        my: \"left top\",\n                        at: \"left\" + ( left >= 0 ? \"+\" : \"\" ) + left + \" \" +\n                            \"top\" + ( top >= 0 ? \"+\" : \"\" ) + top,\n                        of: that.window\n                    };\n                    that._removeClass( $( this ), \"ui-dialog-resizing\" );\n                    that._unblockFrames();\n                    that._trigger( \"resizeStop\", event, filteredUi( ui ) );\n                }\n            } )\n                .css( \"position\", position );\n        },\n\n        _trackFocus: function() {\n            this._on( this.widget(), {\n                focusin: function( event ) {\n                    this._makeFocusTarget();\n                    this._focusedElement = $( event.target );\n                }\n            } );\n        },\n\n        _makeFocusTarget: function() {\n            this._untrackInstance();\n            this._trackingInstances().unshift( this );\n        },\n\n        _untrackInstance: function() {\n            var instances = this._trackingInstances(),\n                exists = $.inArray( this, instances );\n            if ( exists !== -1 ) {\n                instances.splice( exists, 1 );\n            }\n        },\n\n        _trackingInstances: function() {\n            var instances = this.document.data( \"ui-dialog-instances\" );\n            if ( !instances ) {\n                instances = [];\n                this.document.data( \"ui-dialog-instances\", instances );\n            }\n            return instances;\n        },\n\n        _minHeight: function() {\n            var options = this.options;\n\n            return options.height === \"auto\" ?\n                options.minHeight :\n                Math.min( options.minHeight, options.height );\n        },\n\n        _position: function() {\n\n            // Need to show the dialog to get the actual offset in the position plugin\n            var isVisible = this.uiDialog.is( \":visible\" );\n            if ( !isVisible ) {\n                this.uiDialog.show();\n            }\n            this.uiDialog.position( this.options.position );\n            if ( !isVisible ) {\n                this.uiDialog.hide();\n            }\n        },\n\n        _setOptions: function( options ) {\n            var that = this,\n                resize = false,\n                resizableOptions = {};\n\n            $.each( options, function( key, value ) {\n                that._setOption( key, value );\n\n                if ( key in that.sizeRelatedOptions ) {\n                    resize = true;\n                }\n                if ( key in that.resizableRelatedOptions ) {\n                    resizableOptions[ key ] = value;\n                }\n            } );\n\n            if ( resize ) {\n                this._size();\n                this._position();\n            }\n            if ( this.uiDialog.is( \":data(ui-resizable)\" ) ) {\n                this.uiDialog.resizable( \"option\", resizableOptions );\n            }\n        },\n\n        _setOption: function( key, value ) {\n            var isDraggable, isResizable,\n                uiDialog = this.uiDialog;\n\n            if ( key === \"disabled\" ) {\n                return;\n            }\n\n            this._super( key, value );\n\n            if ( key === \"appendTo\" ) {\n                this.uiDialog.appendTo( this._appendTo() );\n            }\n\n            if ( key === \"buttons\" ) {\n                this._createButtons();\n            }\n\n            if ( key === \"closeText\" ) {\n                this.uiDialogTitlebarClose.button( {\n\n                    // Ensure that we always pass a string\n                    label: $( \"<a>\" ).text( \"\" + this.options.closeText ).html()\n                } );\n            }\n\n            if ( key === \"draggable\" ) {\n                isDraggable = uiDialog.is( \":data(ui-draggable)\" );\n                if ( isDraggable && !value ) {\n                    uiDialog.draggable( \"destroy\" );\n                }\n\n                if ( !isDraggable && value ) {\n                    this._makeDraggable();\n                }\n            }\n\n            if ( key === \"position\" ) {\n                this._position();\n            }\n\n            if ( key === \"resizable\" ) {\n\n                // currently resizable, becoming non-resizable\n                isResizable = uiDialog.is( \":data(ui-resizable)\" );\n                if ( isResizable && !value ) {\n                    uiDialog.resizable( \"destroy\" );\n                }\n\n                // Currently resizable, changing handles\n                if ( isResizable && typeof value === \"string\" ) {\n                    uiDialog.resizable( \"option\", \"handles\", value );\n                }\n\n                // Currently non-resizable, becoming resizable\n                if ( !isResizable && value !== false ) {\n                    this._makeResizable();\n                }\n            }\n\n            if ( key === \"title\" ) {\n                this._title( this.uiDialogTitlebar.find( \".ui-dialog-title\" ) );\n            }\n        },\n\n        _size: function() {\n\n            // If the user has resized the dialog, the .ui-dialog and .ui-dialog-content\n            // divs will both have width and height set, so we need to reset them\n            var nonContentHeight, minContentHeight, maxContentHeight,\n                options = this.options;\n\n            // Reset content sizing\n            this.element.show().css( {\n                width: \"auto\",\n                minHeight: 0,\n                maxHeight: \"none\",\n                height: 0\n            } );\n\n            if ( options.minWidth > options.width ) {\n                options.width = options.minWidth;\n            }\n\n            // Reset wrapper sizing\n            // determine the height of all the non-content elements\n            nonContentHeight = this.uiDialog.css( {\n                height: \"auto\",\n                width: options.width\n            } )\n                .outerHeight();\n            minContentHeight = Math.max( 0, options.minHeight - nonContentHeight );\n            maxContentHeight = typeof options.maxHeight === \"number\" ?\n                Math.max( 0, options.maxHeight - nonContentHeight ) :\n                \"none\";\n\n            if ( options.height === \"auto\" ) {\n                this.element.css( {\n                    minHeight: minContentHeight,\n                    maxHeight: maxContentHeight,\n                    height: \"auto\"\n                } );\n            } else {\n                this.element.height( Math.max( 0, options.height - nonContentHeight ) );\n            }\n\n            if ( this.uiDialog.is( \":data(ui-resizable)\" ) ) {\n                this.uiDialog.resizable( \"option\", \"minHeight\", this._minHeight() );\n            }\n        },\n\n        _blockFrames: function() {\n            this.iframeBlocks = this.document.find( \"iframe\" ).map( function() {\n                var iframe = $( this );\n\n                return $( \"<div>\" )\n                    .css( {\n                        position: \"absolute\",\n                        width: iframe.outerWidth(),\n                        height: iframe.outerHeight()\n                    } )\n                    .appendTo( iframe.parent() )\n                    .offset( iframe.offset() )[ 0 ];\n            } );\n        },\n\n        _unblockFrames: function() {\n            if ( this.iframeBlocks ) {\n                this.iframeBlocks.remove();\n                delete this.iframeBlocks;\n            }\n        },\n\n        _allowInteraction: function( event ) {\n            if ( $( event.target ).closest( \".ui-dialog\" ).length ) {\n                return true;\n            }\n\n            // TODO: Remove hack when datepicker implements\n            // the .ui-front logic (#8989)\n            return !!$( event.target ).closest( \".ui-datepicker\" ).length;\n        },\n\n        _createOverlay: function() {\n            if ( !this.options.modal ) {\n                return;\n            }\n\n            var jqMinor = $.fn.jquery.substring( 0, 4 );\n\n            // We use a delay in case the overlay is created from an\n            // event that we're going to be cancelling (#2804)\n            var isOpening = true;\n            this._delay( function() {\n                isOpening = false;\n            } );\n\n            if ( !this.document.data( \"ui-dialog-overlays\" ) ) {\n\n                // Prevent use of anchors and inputs\n                // This doesn't use `_on()` because it is a shared event handler\n                // across all open modal dialogs.\n                this.document.on( \"focusin.ui-dialog\", function( event ) {\n                    if ( isOpening ) {\n                        return;\n                    }\n\n                    var instance = this._trackingInstances()[ 0 ];\n                    if ( !instance._allowInteraction( event ) ) {\n                        event.preventDefault();\n                        instance._focusTabbable();\n\n                        // Support: jQuery >=3.4 <3.6 only\n                        // Focus re-triggering in jQuery 3.4/3.5 makes the original element\n                        // have its focus event propagated last, breaking the re-targeting.\n                        // Trigger focus in a delay in addition if needed to avoid the issue\n                        // See https://github.com/jquery/jquery/issues/4382\n                        if ( jqMinor === \"3.4.\" || jqMinor === \"3.5.\" ) {\n                            instance._delay( instance._restoreTabbableFocus );\n                        }\n                    }\n                }.bind( this ) );\n            }\n\n            this.overlay = $( \"<div>\" )\n                .appendTo( this._appendTo() );\n\n            this._addClass( this.overlay, null, \"ui-widget-overlay ui-front\" );\n            this._on( this.overlay, {\n                mousedown: \"_keepFocus\"\n            } );\n            this.document.data( \"ui-dialog-overlays\",\n                ( this.document.data( \"ui-dialog-overlays\" ) || 0 ) + 1 );\n        },\n\n        _destroyOverlay: function() {\n            if ( !this.options.modal ) {\n                return;\n            }\n\n            if ( this.overlay ) {\n                var overlays = this.document.data( \"ui-dialog-overlays\" ) - 1;\n\n                if ( !overlays ) {\n                    this.document.off( \"focusin.ui-dialog\" );\n                    this.document.removeData( \"ui-dialog-overlays\" );\n                } else {\n                    this.document.data( \"ui-dialog-overlays\", overlays );\n                }\n\n                this.overlay.remove();\n                this.overlay = null;\n            }\n        }\n    } );\n\n// DEPRECATED\n// TODO: switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for dialogClass option\n        $.widget( \"ui.dialog\", $.ui.dialog, {\n            options: {\n                dialogClass: \"\"\n            },\n            _createWrapper: function() {\n                this._super();\n                this.uiDialog.addClass( this.options.dialogClass );\n            },\n            _setOption: function( key, value ) {\n                if ( key === \"dialogClass\" ) {\n                    this.uiDialog\n                        .removeClass( this.options.dialogClass )\n                        .addClass( value );\n                }\n                this._superApply( arguments );\n            }\n        } );\n    }\n\n    return $.ui.dialog;\n\n} );\n","jquery/ui-modules/widgets/tabs.js":"/*!\n * jQuery UI Tabs 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Tabs\n//>>group: Widgets\n//>>description: Transforms a set of container elements into a tab structure.\n//>>docs: http://api.jqueryui.com/tabs/\n//>>demos: http://jqueryui.com/tabs/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/tabs.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../keycode\",\n            \"../safe-active-element\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.tabs\", {\n        version: \"1.13.2\",\n        delay: 300,\n        options: {\n            active: null,\n            classes: {\n                \"ui-tabs\": \"ui-corner-all\",\n                \"ui-tabs-nav\": \"ui-corner-all\",\n                \"ui-tabs-panel\": \"ui-corner-bottom\",\n                \"ui-tabs-tab\": \"ui-corner-top\"\n            },\n            collapsible: false,\n            event: \"click\",\n            heightStyle: \"content\",\n            hide: null,\n            show: null,\n\n            // Callbacks\n            activate: null,\n            beforeActivate: null,\n            beforeLoad: null,\n            load: null\n        },\n\n        _isLocal: ( function() {\n            var rhash = /#.*$/;\n\n            return function( anchor ) {\n                var anchorUrl, locationUrl;\n\n                anchorUrl = anchor.href.replace( rhash, \"\" );\n                locationUrl = location.href.replace( rhash, \"\" );\n\n                // Decoding may throw an error if the URL isn't UTF-8 (#9518)\n                try {\n                    anchorUrl = decodeURIComponent( anchorUrl );\n                } catch ( error ) {}\n                try {\n                    locationUrl = decodeURIComponent( locationUrl );\n                } catch ( error ) {}\n\n                return anchor.hash.length > 1 && anchorUrl === locationUrl;\n            };\n        } )(),\n\n        _create: function() {\n            var that = this,\n                options = this.options;\n\n            this.running = false;\n\n            this._addClass( \"ui-tabs\", \"ui-widget ui-widget-content\" );\n            this._toggleClass( \"ui-tabs-collapsible\", null, options.collapsible );\n\n            this._processTabs();\n            options.active = this._initialActive();\n\n            // Take disabling tabs via class attribute from HTML\n            // into account and update option properly.\n            if ( Array.isArray( options.disabled ) ) {\n                options.disabled = $.uniqueSort( options.disabled.concat(\n                    $.map( this.tabs.filter( \".ui-state-disabled\" ), function( li ) {\n                        return that.tabs.index( li );\n                    } )\n                ) ).sort();\n            }\n\n            // Check for length avoids error when initializing empty list\n            if ( this.options.active !== false && this.anchors.length ) {\n                this.active = this._findActive( options.active );\n            } else {\n                this.active = $();\n            }\n\n            this._refresh();\n\n            if ( this.active.length ) {\n                this.load( options.active );\n            }\n        },\n\n        _initialActive: function() {\n            var active = this.options.active,\n                collapsible = this.options.collapsible,\n                locationHash = location.hash.substring( 1 );\n\n            if ( active === null ) {\n\n                // check the fragment identifier in the URL\n                if ( locationHash ) {\n                    this.tabs.each( function( i, tab ) {\n                        if ( $( tab ).attr( \"aria-controls\" ) === locationHash ) {\n                            active = i;\n                            return false;\n                        }\n                    } );\n                }\n\n                // Check for a tab marked active via a class\n                if ( active === null ) {\n                    active = this.tabs.index( this.tabs.filter( \".ui-tabs-active\" ) );\n                }\n\n                // No active tab, set to false\n                if ( active === null || active === -1 ) {\n                    active = this.tabs.length ? 0 : false;\n                }\n            }\n\n            // Handle numbers: negative, out of range\n            if ( active !== false ) {\n                active = this.tabs.index( this.tabs.eq( active ) );\n                if ( active === -1 ) {\n                    active = collapsible ? false : 0;\n                }\n            }\n\n            // Don't allow collapsible: false and active: false\n            if ( !collapsible && active === false && this.anchors.length ) {\n                active = 0;\n            }\n\n            return active;\n        },\n\n        _getCreateEventData: function() {\n            return {\n                tab: this.active,\n                panel: !this.active.length ? $() : this._getPanelForTab( this.active )\n            };\n        },\n\n        _tabKeydown: function( event ) {\n            var focusedTab = $( $.ui.safeActiveElement( this.document[ 0 ] ) ).closest( \"li\" ),\n                selectedIndex = this.tabs.index( focusedTab ),\n                goingForward = true;\n\n            if ( this._handlePageNav( event ) ) {\n                return;\n            }\n\n            switch ( event.keyCode ) {\n                case $.ui.keyCode.RIGHT:\n                case $.ui.keyCode.DOWN:\n                    selectedIndex++;\n                    break;\n                case $.ui.keyCode.UP:\n                case $.ui.keyCode.LEFT:\n                    goingForward = false;\n                    selectedIndex--;\n                    break;\n                case $.ui.keyCode.END:\n                    selectedIndex = this.anchors.length - 1;\n                    break;\n                case $.ui.keyCode.HOME:\n                    selectedIndex = 0;\n                    break;\n                case $.ui.keyCode.SPACE:\n\n                    // Activate only, no collapsing\n                    event.preventDefault();\n                    clearTimeout( this.activating );\n                    this._activate( selectedIndex );\n                    return;\n                case $.ui.keyCode.ENTER:\n\n                    // Toggle (cancel delayed activation, allow collapsing)\n                    event.preventDefault();\n                    clearTimeout( this.activating );\n\n                    // Determine if we should collapse or activate\n                    this._activate( selectedIndex === this.options.active ? false : selectedIndex );\n                    return;\n                default:\n                    return;\n            }\n\n            // Focus the appropriate tab, based on which key was pressed\n            event.preventDefault();\n            clearTimeout( this.activating );\n            selectedIndex = this._focusNextTab( selectedIndex, goingForward );\n\n            // Navigating with control/command key will prevent automatic activation\n            if ( !event.ctrlKey && !event.metaKey ) {\n\n                // Update aria-selected immediately so that AT think the tab is already selected.\n                // Otherwise AT may confuse the user by stating that they need to activate the tab,\n                // but the tab will already be activated by the time the announcement finishes.\n                focusedTab.attr( \"aria-selected\", \"false\" );\n                this.tabs.eq( selectedIndex ).attr( \"aria-selected\", \"true\" );\n\n                this.activating = this._delay( function() {\n                    this.option( \"active\", selectedIndex );\n                }, this.delay );\n            }\n        },\n\n        _panelKeydown: function( event ) {\n            if ( this._handlePageNav( event ) ) {\n                return;\n            }\n\n            // Ctrl+up moves focus to the current tab\n            if ( event.ctrlKey && event.keyCode === $.ui.keyCode.UP ) {\n                event.preventDefault();\n                this.active.trigger( \"focus\" );\n            }\n        },\n\n        // Alt+page up/down moves focus to the previous/next tab (and activates)\n        _handlePageNav: function( event ) {\n            if ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_UP ) {\n                this._activate( this._focusNextTab( this.options.active - 1, false ) );\n                return true;\n            }\n            if ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_DOWN ) {\n                this._activate( this._focusNextTab( this.options.active + 1, true ) );\n                return true;\n            }\n        },\n\n        _findNextTab: function( index, goingForward ) {\n            var lastTabIndex = this.tabs.length - 1;\n\n            function constrain() {\n                if ( index > lastTabIndex ) {\n                    index = 0;\n                }\n                if ( index < 0 ) {\n                    index = lastTabIndex;\n                }\n                return index;\n            }\n\n            while ( $.inArray( constrain(), this.options.disabled ) !== -1 ) {\n                index = goingForward ? index + 1 : index - 1;\n            }\n\n            return index;\n        },\n\n        _focusNextTab: function( index, goingForward ) {\n            index = this._findNextTab( index, goingForward );\n            this.tabs.eq( index ).trigger( \"focus\" );\n            return index;\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"active\" ) {\n\n                // _activate() will handle invalid values and update this.options\n                this._activate( value );\n                return;\n            }\n\n            this._super( key, value );\n\n            if ( key === \"collapsible\" ) {\n                this._toggleClass( \"ui-tabs-collapsible\", null, value );\n\n                // Setting collapsible: false while collapsed; open first panel\n                if ( !value && this.options.active === false ) {\n                    this._activate( 0 );\n                }\n            }\n\n            if ( key === \"event\" ) {\n                this._setupEvents( value );\n            }\n\n            if ( key === \"heightStyle\" ) {\n                this._setupHeightStyle( value );\n            }\n        },\n\n        _sanitizeSelector: function( hash ) {\n            return hash ? hash.replace( /[!\"$%&'()*+,.\\/:;<=>?@\\[\\]\\^`{|}~]/g, \"\\\\$&\" ) : \"\";\n        },\n\n        refresh: function() {\n            var options = this.options,\n                lis = this.tablist.children( \":has(a[href])\" );\n\n            // Get disabled tabs from class attribute from HTML\n            // this will get converted to a boolean if needed in _refresh()\n            options.disabled = $.map( lis.filter( \".ui-state-disabled\" ), function( tab ) {\n                return lis.index( tab );\n            } );\n\n            this._processTabs();\n\n            // Was collapsed or no tabs\n            if ( options.active === false || !this.anchors.length ) {\n                options.active = false;\n                this.active = $();\n\n                // was active, but active tab is gone\n            } else if ( this.active.length && !$.contains( this.tablist[ 0 ], this.active[ 0 ] ) ) {\n\n                // all remaining tabs are disabled\n                if ( this.tabs.length === options.disabled.length ) {\n                    options.active = false;\n                    this.active = $();\n\n                    // activate previous tab\n                } else {\n                    this._activate( this._findNextTab( Math.max( 0, options.active - 1 ), false ) );\n                }\n\n                // was active, active tab still exists\n            } else {\n\n                // make sure active index is correct\n                options.active = this.tabs.index( this.active );\n            }\n\n            this._refresh();\n        },\n\n        _refresh: function() {\n            this._setOptionDisabled( this.options.disabled );\n            this._setupEvents( this.options.event );\n            this._setupHeightStyle( this.options.heightStyle );\n\n            this.tabs.not( this.active ).attr( {\n                \"aria-selected\": \"false\",\n                \"aria-expanded\": \"false\",\n                tabIndex: -1\n            } );\n            this.panels.not( this._getPanelForTab( this.active ) )\n                .hide()\n                .attr( {\n                    \"aria-hidden\": \"true\"\n                } );\n\n            // Make sure one tab is in the tab order\n            if ( !this.active.length ) {\n                this.tabs.eq( 0 ).attr( \"tabIndex\", 0 );\n            } else {\n                this.active\n                    .attr( {\n                        \"aria-selected\": \"true\",\n                        \"aria-expanded\": \"true\",\n                        tabIndex: 0\n                    } );\n                this._addClass( this.active, \"ui-tabs-active\", \"ui-state-active\" );\n                this._getPanelForTab( this.active )\n                    .show()\n                    .attr( {\n                        \"aria-hidden\": \"false\"\n                    } );\n            }\n        },\n\n        _processTabs: function() {\n            var that = this,\n                prevTabs = this.tabs,\n                prevAnchors = this.anchors,\n                prevPanels = this.panels;\n\n            this.tablist = this._getList().attr( \"role\", \"tablist\" );\n            this._addClass( this.tablist, \"ui-tabs-nav\",\n                \"ui-helper-reset ui-helper-clearfix ui-widget-header\" );\n\n            // Prevent users from focusing disabled tabs via click\n            this.tablist\n                .on( \"mousedown\" + this.eventNamespace, \"> li\", function( event ) {\n                    if ( $( this ).is( \".ui-state-disabled\" ) ) {\n                        event.preventDefault();\n                    }\n                } )\n\n                // Support: IE <9\n                // Preventing the default action in mousedown doesn't prevent IE\n                // from focusing the element, so if the anchor gets focused, blur.\n                // We don't have to worry about focusing the previously focused\n                // element since clicking on a non-focusable element should focus\n                // the body anyway.\n                .on( \"focus\" + this.eventNamespace, \".ui-tabs-anchor\", function() {\n                    if ( $( this ).closest( \"li\" ).is( \".ui-state-disabled\" ) ) {\n                        this.blur();\n                    }\n                } );\n\n            this.tabs = this.tablist.find( \"> li:has(a[href])\" )\n                .attr( {\n                    role: \"tab\",\n                    tabIndex: -1\n                } );\n            this._addClass( this.tabs, \"ui-tabs-tab\", \"ui-state-default\" );\n\n            this.anchors = this.tabs.map( function() {\n                return $( \"a\", this )[ 0 ];\n            } )\n                .attr( {\n                    tabIndex: -1\n                } );\n            this._addClass( this.anchors, \"ui-tabs-anchor\" );\n\n            this.panels = $();\n\n            this.anchors.each( function( i, anchor ) {\n                var selector, panel, panelId,\n                    anchorId = $( anchor ).uniqueId().attr( \"id\" ),\n                    tab = $( anchor ).closest( \"li\" ),\n                    originalAriaControls = tab.attr( \"aria-controls\" );\n\n                // Inline tab\n                if ( that._isLocal( anchor ) ) {\n                    selector = anchor.hash;\n                    panelId = selector.substring( 1 );\n                    panel = that.element.find( that._sanitizeSelector( selector ) );\n\n                    // remote tab\n                } else {\n\n                    // If the tab doesn't already have aria-controls,\n                    // generate an id by using a throw-away element\n                    panelId = tab.attr( \"aria-controls\" ) || $( {} ).uniqueId()[ 0 ].id;\n                    selector = \"#\" + panelId;\n                    panel = that.element.find( selector );\n                    if ( !panel.length ) {\n                        panel = that._createPanel( panelId );\n                        panel.insertAfter( that.panels[ i - 1 ] || that.tablist );\n                    }\n                    panel.attr( \"aria-live\", \"polite\" );\n                }\n\n                if ( panel.length ) {\n                    that.panels = that.panels.add( panel );\n                }\n                if ( originalAriaControls ) {\n                    tab.data( \"ui-tabs-aria-controls\", originalAriaControls );\n                }\n                tab.attr( {\n                    \"aria-controls\": panelId,\n                    \"aria-labelledby\": anchorId\n                } );\n                panel.attr( \"aria-labelledby\", anchorId );\n            } );\n\n            this.panels.attr( \"role\", \"tabpanel\" );\n            this._addClass( this.panels, \"ui-tabs-panel\", \"ui-widget-content\" );\n\n            // Avoid memory leaks (#10056)\n            if ( prevTabs ) {\n                this._off( prevTabs.not( this.tabs ) );\n                this._off( prevAnchors.not( this.anchors ) );\n                this._off( prevPanels.not( this.panels ) );\n            }\n        },\n\n        // Allow overriding how to find the list for rare usage scenarios (#7715)\n        _getList: function() {\n            return this.tablist || this.element.find( \"ol, ul\" ).eq( 0 );\n        },\n\n        _createPanel: function( id ) {\n            return $( \"<div>\" )\n                .attr( \"id\", id )\n                .data( \"ui-tabs-destroy\", true );\n        },\n\n        _setOptionDisabled: function( disabled ) {\n            var currentItem, li, i;\n\n            if ( Array.isArray( disabled ) ) {\n                if ( !disabled.length ) {\n                    disabled = false;\n                } else if ( disabled.length === this.anchors.length ) {\n                    disabled = true;\n                }\n            }\n\n            // Disable tabs\n            for ( i = 0; ( li = this.tabs[ i ] ); i++ ) {\n                currentItem = $( li );\n                if ( disabled === true || $.inArray( i, disabled ) !== -1 ) {\n                    currentItem.attr( \"aria-disabled\", \"true\" );\n                    this._addClass( currentItem, null, \"ui-state-disabled\" );\n                } else {\n                    currentItem.removeAttr( \"aria-disabled\" );\n                    this._removeClass( currentItem, null, \"ui-state-disabled\" );\n                }\n            }\n\n            this.options.disabled = disabled;\n\n            this._toggleClass( this.widget(), this.widgetFullName + \"-disabled\", null,\n                disabled === true );\n        },\n\n        _setupEvents: function( event ) {\n            var events = {};\n            if ( event ) {\n                $.each( event.split( \" \" ), function( index, eventName ) {\n                    events[ eventName ] = \"_eventHandler\";\n                } );\n            }\n\n            this._off( this.anchors.add( this.tabs ).add( this.panels ) );\n\n            // Always prevent the default action, even when disabled\n            this._on( true, this.anchors, {\n                click: function( event ) {\n                    event.preventDefault();\n                }\n            } );\n            this._on( this.anchors, events );\n            this._on( this.tabs, { keydown: \"_tabKeydown\" } );\n            this._on( this.panels, { keydown: \"_panelKeydown\" } );\n\n            this._focusable( this.tabs );\n            this._hoverable( this.tabs );\n        },\n\n        _setupHeightStyle: function( heightStyle ) {\n            var maxHeight,\n                parent = this.element.parent();\n\n            if ( heightStyle === \"fill\" ) {\n                maxHeight = parent.height();\n                maxHeight -= this.element.outerHeight() - this.element.height();\n\n                this.element.siblings( \":visible\" ).each( function() {\n                    var elem = $( this ),\n                        position = elem.css( \"position\" );\n\n                    if ( position === \"absolute\" || position === \"fixed\" ) {\n                        return;\n                    }\n                    maxHeight -= elem.outerHeight( true );\n                } );\n\n                this.element.children().not( this.panels ).each( function() {\n                    maxHeight -= $( this ).outerHeight( true );\n                } );\n\n                this.panels.each( function() {\n                    $( this ).height( Math.max( 0, maxHeight -\n                        $( this ).innerHeight() + $( this ).height() ) );\n                } )\n                    .css( \"overflow\", \"auto\" );\n            } else if ( heightStyle === \"auto\" ) {\n                maxHeight = 0;\n                this.panels.each( function() {\n                    maxHeight = Math.max( maxHeight, $( this ).height( \"\" ).height() );\n                } ).height( maxHeight );\n            }\n        },\n\n        _eventHandler: function( event ) {\n            var options = this.options,\n                active = this.active,\n                anchor = $( event.currentTarget ),\n                tab = anchor.closest( \"li\" ),\n                clickedIsActive = tab[ 0 ] === active[ 0 ],\n                collapsing = clickedIsActive && options.collapsible,\n                toShow = collapsing ? $() : this._getPanelForTab( tab ),\n                toHide = !active.length ? $() : this._getPanelForTab( active ),\n                eventData = {\n                    oldTab: active,\n                    oldPanel: toHide,\n                    newTab: collapsing ? $() : tab,\n                    newPanel: toShow\n                };\n\n            event.preventDefault();\n\n            if ( tab.hasClass( \"ui-state-disabled\" ) ||\n\n                // tab is already loading\n                tab.hasClass( \"ui-tabs-loading\" ) ||\n\n                // can't switch durning an animation\n                this.running ||\n\n                // click on active header, but not collapsible\n                ( clickedIsActive && !options.collapsible ) ||\n\n                // allow canceling activation\n                ( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n                return;\n            }\n\n            options.active = collapsing ? false : this.tabs.index( tab );\n\n            this.active = clickedIsActive ? $() : tab;\n            if ( this.xhr ) {\n                this.xhr.abort();\n            }\n\n            if ( !toHide.length && !toShow.length ) {\n                $.error( \"jQuery UI Tabs: Mismatching fragment identifier.\" );\n            }\n\n            if ( toShow.length ) {\n                this.load( this.tabs.index( tab ), event );\n            }\n            this._toggle( event, eventData );\n        },\n\n        // Handles show/hide for selecting tabs\n        _toggle: function( event, eventData ) {\n            var that = this,\n                toShow = eventData.newPanel,\n                toHide = eventData.oldPanel;\n\n            this.running = true;\n\n            function complete() {\n                that.running = false;\n                that._trigger( \"activate\", event, eventData );\n            }\n\n            function show() {\n                that._addClass( eventData.newTab.closest( \"li\" ), \"ui-tabs-active\", \"ui-state-active\" );\n\n                if ( toShow.length && that.options.show ) {\n                    that._show( toShow, that.options.show, complete );\n                } else {\n                    toShow.show();\n                    complete();\n                }\n            }\n\n            // Start out by hiding, then showing, then completing\n            if ( toHide.length && this.options.hide ) {\n                this._hide( toHide, this.options.hide, function() {\n                    that._removeClass( eventData.oldTab.closest( \"li\" ),\n                        \"ui-tabs-active\", \"ui-state-active\" );\n                    show();\n                } );\n            } else {\n                this._removeClass( eventData.oldTab.closest( \"li\" ),\n                    \"ui-tabs-active\", \"ui-state-active\" );\n                toHide.hide();\n                show();\n            }\n\n            toHide.attr( \"aria-hidden\", \"true\" );\n            eventData.oldTab.attr( {\n                \"aria-selected\": \"false\",\n                \"aria-expanded\": \"false\"\n            } );\n\n            // If we're switching tabs, remove the old tab from the tab order.\n            // If we're opening from collapsed state, remove the previous tab from the tab order.\n            // If we're collapsing, then keep the collapsing tab in the tab order.\n            if ( toShow.length && toHide.length ) {\n                eventData.oldTab.attr( \"tabIndex\", -1 );\n            } else if ( toShow.length ) {\n                this.tabs.filter( function() {\n                    return $( this ).attr( \"tabIndex\" ) === 0;\n                } )\n                    .attr( \"tabIndex\", -1 );\n            }\n\n            toShow.attr( \"aria-hidden\", \"false\" );\n            eventData.newTab.attr( {\n                \"aria-selected\": \"true\",\n                \"aria-expanded\": \"true\",\n                tabIndex: 0\n            } );\n        },\n\n        _activate: function( index ) {\n            var anchor,\n                active = this._findActive( index );\n\n            // Trying to activate the already active panel\n            if ( active[ 0 ] === this.active[ 0 ] ) {\n                return;\n            }\n\n            // Trying to collapse, simulate a click on the current active header\n            if ( !active.length ) {\n                active = this.active;\n            }\n\n            anchor = active.find( \".ui-tabs-anchor\" )[ 0 ];\n            this._eventHandler( {\n                target: anchor,\n                currentTarget: anchor,\n                preventDefault: $.noop\n            } );\n        },\n\n        _findActive: function( index ) {\n            return index === false ? $() : this.tabs.eq( index );\n        },\n\n        _getIndex: function( index ) {\n\n            // meta-function to give users option to provide a href string instead of a numerical index.\n            if ( typeof index === \"string\" ) {\n                index = this.anchors.index( this.anchors.filter( \"[href$='\" +\n                    $.escapeSelector( index ) + \"']\" ) );\n            }\n\n            return index;\n        },\n\n        _destroy: function() {\n            if ( this.xhr ) {\n                this.xhr.abort();\n            }\n\n            this.tablist\n                .removeAttr( \"role\" )\n                .off( this.eventNamespace );\n\n            this.anchors\n                .removeAttr( \"role tabIndex\" )\n                .removeUniqueId();\n\n            this.tabs.add( this.panels ).each( function() {\n                if ( $.data( this, \"ui-tabs-destroy\" ) ) {\n                    $( this ).remove();\n                } else {\n                    $( this ).removeAttr( \"role tabIndex \" +\n                        \"aria-live aria-busy aria-selected aria-labelledby aria-hidden aria-expanded\" );\n                }\n            } );\n\n            this.tabs.each( function() {\n                var li = $( this ),\n                    prev = li.data( \"ui-tabs-aria-controls\" );\n                if ( prev ) {\n                    li\n                        .attr( \"aria-controls\", prev )\n                        .removeData( \"ui-tabs-aria-controls\" );\n                } else {\n                    li.removeAttr( \"aria-controls\" );\n                }\n            } );\n\n            this.panels.show();\n\n            if ( this.options.heightStyle !== \"content\" ) {\n                this.panels.css( \"height\", \"\" );\n            }\n        },\n\n        enable: function( index ) {\n            var disabled = this.options.disabled;\n            if ( disabled === false ) {\n                return;\n            }\n\n            if ( index === undefined ) {\n                disabled = false;\n            } else {\n                index = this._getIndex( index );\n                if ( Array.isArray( disabled ) ) {\n                    disabled = $.map( disabled, function( num ) {\n                        return num !== index ? num : null;\n                    } );\n                } else {\n                    disabled = $.map( this.tabs, function( li, num ) {\n                        return num !== index ? num : null;\n                    } );\n                }\n            }\n            this._setOptionDisabled( disabled );\n        },\n\n        disable: function( index ) {\n            var disabled = this.options.disabled;\n            if ( disabled === true ) {\n                return;\n            }\n\n            if ( index === undefined ) {\n                disabled = true;\n            } else {\n                index = this._getIndex( index );\n                if ( $.inArray( index, disabled ) !== -1 ) {\n                    return;\n                }\n                if ( Array.isArray( disabled ) ) {\n                    disabled = $.merge( [ index ], disabled ).sort();\n                } else {\n                    disabled = [ index ];\n                }\n            }\n            this._setOptionDisabled( disabled );\n        },\n\n        load: function( index, event ) {\n            index = this._getIndex( index );\n            var that = this,\n                tab = this.tabs.eq( index ),\n                anchor = tab.find( \".ui-tabs-anchor\" ),\n                panel = this._getPanelForTab( tab ),\n                eventData = {\n                    tab: tab,\n                    panel: panel\n                },\n                complete = function( jqXHR, status ) {\n                    if ( status === \"abort\" ) {\n                        that.panels.stop( false, true );\n                    }\n\n                    that._removeClass( tab, \"ui-tabs-loading\" );\n                    panel.removeAttr( \"aria-busy\" );\n\n                    if ( jqXHR === that.xhr ) {\n                        delete that.xhr;\n                    }\n                };\n\n            // Not remote\n            if ( this._isLocal( anchor[ 0 ] ) ) {\n                return;\n            }\n\n            this.xhr = $.ajax( this._ajaxSettings( anchor, event, eventData ) );\n\n            // Support: jQuery <1.8\n            // jQuery <1.8 returns false if the request is canceled in beforeSend,\n            // but as of 1.8, $.ajax() always returns a jqXHR object.\n            if ( this.xhr && this.xhr.statusText !== \"canceled\" ) {\n                this._addClass( tab, \"ui-tabs-loading\" );\n                panel.attr( \"aria-busy\", \"true\" );\n\n                this.xhr\n                    .done( function( response, status, jqXHR ) {\n\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout( function() {\n                            panel.html( response );\n                            that._trigger( \"load\", event, eventData );\n\n                            complete( jqXHR, status );\n                        }, 1 );\n                    } )\n                    .fail( function( jqXHR, status ) {\n\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout( function() {\n                            complete( jqXHR, status );\n                        }, 1 );\n                    } );\n            }\n        },\n\n        _ajaxSettings: function( anchor, event, eventData ) {\n            var that = this;\n            return {\n\n                // Support: IE <11 only\n                // Strip any hash that exists to prevent errors with the Ajax request\n                url: anchor.attr( \"href\" ).replace( /#.*$/, \"\" ),\n                beforeSend: function( jqXHR, settings ) {\n                    return that._trigger( \"beforeLoad\", event,\n                        $.extend( { jqXHR: jqXHR, ajaxSettings: settings }, eventData ) );\n                }\n            };\n        },\n\n        _getPanelForTab: function( tab ) {\n            var id = $( tab ).attr( \"aria-controls\" );\n            return this.element.find( this._sanitizeSelector( \"#\" + id ) );\n        }\n    } );\n\n// DEPRECATED\n// TODO: Switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for ui-tab class (now ui-tabs-tab)\n        $.widget( \"ui.tabs\", $.ui.tabs, {\n            _processTabs: function() {\n                this._superApply( arguments );\n                this._addClass( this.tabs, \"ui-tab\" );\n            }\n        } );\n    }\n\n    return $.ui.tabs;\n\n} );\n","jquery/ui-modules/widgets/resizable.js":"/*!\n * jQuery UI Resizable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Resizable\n//>>group: Interactions\n//>>description: Enables resize functionality for any element.\n//>>docs: http://api.jqueryui.com/resizable/\n//>>demos: http://jqueryui.com/resizable/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/resizable.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../disable-selection\",\n            \"../plugin\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.resizable\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"resize\",\n        options: {\n            alsoResize: false,\n            animate: false,\n            animateDuration: \"slow\",\n            animateEasing: \"swing\",\n            aspectRatio: false,\n            autoHide: false,\n            classes: {\n                \"ui-resizable-se\": \"ui-icon ui-icon-gripsmall-diagonal-se\"\n            },\n            containment: false,\n            ghost: false,\n            grid: false,\n            handles: \"e,s,se\",\n            helper: false,\n            maxHeight: null,\n            maxWidth: null,\n            minHeight: 10,\n            minWidth: 10,\n\n            // See #7960\n            zIndex: 90,\n\n            // Callbacks\n            resize: null,\n            start: null,\n            stop: null\n        },\n\n        _num: function( value ) {\n            return parseFloat( value ) || 0;\n        },\n\n        _isNumber: function( value ) {\n            return !isNaN( parseFloat( value ) );\n        },\n\n        _hasScroll: function( el, a ) {\n\n            if ( $( el ).css( \"overflow\" ) === \"hidden\" ) {\n                return false;\n            }\n\n            var scroll = ( a && a === \"left\" ) ? \"scrollLeft\" : \"scrollTop\",\n                has = false;\n\n            if ( el[ scroll ] > 0 ) {\n                return true;\n            }\n\n            // TODO: determine which cases actually cause this to happen\n            // if the element doesn't have the scroll set, see if it's possible to\n            // set the scroll\n            try {\n                el[ scroll ] = 1;\n                has = ( el[ scroll ] > 0 );\n                el[ scroll ] = 0;\n            } catch ( e ) {\n\n                // `el` might be a string, then setting `scroll` will throw\n                // an error in strict mode; ignore it.\n            }\n            return has;\n        },\n\n        _create: function() {\n\n            var margins,\n                o = this.options,\n                that = this;\n            this._addClass( \"ui-resizable\" );\n\n            $.extend( this, {\n                _aspectRatio: !!( o.aspectRatio ),\n                aspectRatio: o.aspectRatio,\n                originalElement: this.element,\n                _proportionallyResizeElements: [],\n                _helper: o.helper || o.ghost || o.animate ? o.helper || \"ui-resizable-helper\" : null\n            } );\n\n            // Wrap the element if it cannot hold child nodes\n            if ( this.element[ 0 ].nodeName.match( /^(canvas|textarea|input|select|button|img)$/i ) ) {\n\n                this.element.wrap(\n                    $( \"<div class='ui-wrapper'></div>\" ).css( {\n                        overflow: \"hidden\",\n                        position: this.element.css( \"position\" ),\n                        width: this.element.outerWidth(),\n                        height: this.element.outerHeight(),\n                        top: this.element.css( \"top\" ),\n                        left: this.element.css( \"left\" )\n                    } )\n                );\n\n                this.element = this.element.parent().data(\n                    \"ui-resizable\", this.element.resizable( \"instance\" )\n                );\n\n                this.elementIsWrapper = true;\n\n                margins = {\n                    marginTop: this.originalElement.css( \"marginTop\" ),\n                    marginRight: this.originalElement.css( \"marginRight\" ),\n                    marginBottom: this.originalElement.css( \"marginBottom\" ),\n                    marginLeft: this.originalElement.css( \"marginLeft\" )\n                };\n\n                this.element.css( margins );\n                this.originalElement.css( \"margin\", 0 );\n\n                // support: Safari\n                // Prevent Safari textarea resize\n                this.originalResizeStyle = this.originalElement.css( \"resize\" );\n                this.originalElement.css( \"resize\", \"none\" );\n\n                this._proportionallyResizeElements.push( this.originalElement.css( {\n                    position: \"static\",\n                    zoom: 1,\n                    display: \"block\"\n                } ) );\n\n                // Support: IE9\n                // avoid IE jump (hard set the margin)\n                this.originalElement.css( margins );\n\n                this._proportionallyResize();\n            }\n\n            this._setupHandles();\n\n            if ( o.autoHide ) {\n                $( this.element )\n                    .on( \"mouseenter\", function() {\n                        if ( o.disabled ) {\n                            return;\n                        }\n                        that._removeClass( \"ui-resizable-autohide\" );\n                        that._handles.show();\n                    } )\n                    .on( \"mouseleave\", function() {\n                        if ( o.disabled ) {\n                            return;\n                        }\n                        if ( !that.resizing ) {\n                            that._addClass( \"ui-resizable-autohide\" );\n                            that._handles.hide();\n                        }\n                    } );\n            }\n\n            this._mouseInit();\n        },\n\n        _destroy: function() {\n\n            this._mouseDestroy();\n            this._addedHandles.remove();\n\n            var wrapper,\n                _destroy = function( exp ) {\n                    $( exp )\n                        .removeData( \"resizable\" )\n                        .removeData( \"ui-resizable\" )\n                        .off( \".resizable\" );\n                };\n\n            // TODO: Unwrap at same DOM position\n            if ( this.elementIsWrapper ) {\n                _destroy( this.element );\n                wrapper = this.element;\n                this.originalElement.css( {\n                    position: wrapper.css( \"position\" ),\n                    width: wrapper.outerWidth(),\n                    height: wrapper.outerHeight(),\n                    top: wrapper.css( \"top\" ),\n                    left: wrapper.css( \"left\" )\n                } ).insertAfter( wrapper );\n                wrapper.remove();\n            }\n\n            this.originalElement.css( \"resize\", this.originalResizeStyle );\n            _destroy( this.originalElement );\n\n            return this;\n        },\n\n        _setOption: function( key, value ) {\n            this._super( key, value );\n\n            switch ( key ) {\n                case \"handles\":\n                    this._removeHandles();\n                    this._setupHandles();\n                    break;\n                case \"aspectRatio\":\n                    this._aspectRatio = !!value;\n                    break;\n                default:\n                    break;\n            }\n        },\n\n        _setupHandles: function() {\n            var o = this.options, handle, i, n, hname, axis, that = this;\n            this.handles = o.handles ||\n                ( !$( \".ui-resizable-handle\", this.element ).length ?\n                    \"e,s,se\" : {\n                        n: \".ui-resizable-n\",\n                        e: \".ui-resizable-e\",\n                        s: \".ui-resizable-s\",\n                        w: \".ui-resizable-w\",\n                        se: \".ui-resizable-se\",\n                        sw: \".ui-resizable-sw\",\n                        ne: \".ui-resizable-ne\",\n                        nw: \".ui-resizable-nw\"\n                    } );\n\n            this._handles = $();\n            this._addedHandles = $();\n            if ( this.handles.constructor === String ) {\n\n                if ( this.handles === \"all\" ) {\n                    this.handles = \"n,e,s,w,se,sw,ne,nw\";\n                }\n\n                n = this.handles.split( \",\" );\n                this.handles = {};\n\n                for ( i = 0; i < n.length; i++ ) {\n\n                    handle = String.prototype.trim.call( n[ i ] );\n                    hname = \"ui-resizable-\" + handle;\n                    axis = $( \"<div>\" );\n                    this._addClass( axis, \"ui-resizable-handle \" + hname );\n\n                    axis.css( { zIndex: o.zIndex } );\n\n                    this.handles[ handle ] = \".ui-resizable-\" + handle;\n                    if ( !this.element.children( this.handles[ handle ] ).length ) {\n                        this.element.append( axis );\n                        this._addedHandles = this._addedHandles.add( axis );\n                    }\n                }\n\n            }\n\n            this._renderAxis = function( target ) {\n\n                var i, axis, padPos, padWrapper;\n\n                target = target || this.element;\n\n                for ( i in this.handles ) {\n\n                    if ( this.handles[ i ].constructor === String ) {\n                        this.handles[ i ] = this.element.children( this.handles[ i ] ).first().show();\n                    } else if ( this.handles[ i ].jquery || this.handles[ i ].nodeType ) {\n                        this.handles[ i ] = $( this.handles[ i ] );\n                        this._on( this.handles[ i ], { \"mousedown\": that._mouseDown } );\n                    }\n\n                    if ( this.elementIsWrapper &&\n                        this.originalElement[ 0 ]\n                            .nodeName\n                            .match( /^(textarea|input|select|button)$/i ) ) {\n                        axis = $( this.handles[ i ], this.element );\n\n                        padWrapper = /sw|ne|nw|se|n|s/.test( i ) ?\n                            axis.outerHeight() :\n                            axis.outerWidth();\n\n                        padPos = [ \"padding\",\n                            /ne|nw|n/.test( i ) ? \"Top\" :\n                                /se|sw|s/.test( i ) ? \"Bottom\" :\n                                    /^e$/.test( i ) ? \"Right\" : \"Left\" ].join( \"\" );\n\n                        target.css( padPos, padWrapper );\n\n                        this._proportionallyResize();\n                    }\n\n                    this._handles = this._handles.add( this.handles[ i ] );\n                }\n            };\n\n            // TODO: make renderAxis a prototype function\n            this._renderAxis( this.element );\n\n            this._handles = this._handles.add( this.element.find( \".ui-resizable-handle\" ) );\n            this._handles.disableSelection();\n\n            this._handles.on( \"mouseover\", function() {\n                if ( !that.resizing ) {\n                    if ( this.className ) {\n                        axis = this.className.match( /ui-resizable-(se|sw|ne|nw|n|e|s|w)/i );\n                    }\n                    that.axis = axis && axis[ 1 ] ? axis[ 1 ] : \"se\";\n                }\n            } );\n\n            if ( o.autoHide ) {\n                this._handles.hide();\n                this._addClass( \"ui-resizable-autohide\" );\n            }\n        },\n\n        _removeHandles: function() {\n            this._addedHandles.remove();\n        },\n\n        _mouseCapture: function( event ) {\n            var i, handle,\n                capture = false;\n\n            for ( i in this.handles ) {\n                handle = $( this.handles[ i ] )[ 0 ];\n                if ( handle === event.target || $.contains( handle, event.target ) ) {\n                    capture = true;\n                }\n            }\n\n            return !this.options.disabled && capture;\n        },\n\n        _mouseStart: function( event ) {\n\n            var curleft, curtop, cursor,\n                o = this.options,\n                el = this.element;\n\n            this.resizing = true;\n\n            this._renderProxy();\n\n            curleft = this._num( this.helper.css( \"left\" ) );\n            curtop = this._num( this.helper.css( \"top\" ) );\n\n            if ( o.containment ) {\n                curleft += $( o.containment ).scrollLeft() || 0;\n                curtop += $( o.containment ).scrollTop() || 0;\n            }\n\n            this.offset = this.helper.offset();\n            this.position = { left: curleft, top: curtop };\n\n            this.size = this._helper ? {\n                width: this.helper.width(),\n                height: this.helper.height()\n            } : {\n                width: el.width(),\n                height: el.height()\n            };\n\n            this.originalSize = this._helper ? {\n                width: el.outerWidth(),\n                height: el.outerHeight()\n            } : {\n                width: el.width(),\n                height: el.height()\n            };\n\n            this.sizeDiff = {\n                width: el.outerWidth() - el.width(),\n                height: el.outerHeight() - el.height()\n            };\n\n            this.originalPosition = { left: curleft, top: curtop };\n            this.originalMousePosition = { left: event.pageX, top: event.pageY };\n\n            this.aspectRatio = ( typeof o.aspectRatio === \"number\" ) ?\n                o.aspectRatio :\n                ( ( this.originalSize.width / this.originalSize.height ) || 1 );\n\n            cursor = $( \".ui-resizable-\" + this.axis ).css( \"cursor\" );\n            $( \"body\" ).css( \"cursor\", cursor === \"auto\" ? this.axis + \"-resize\" : cursor );\n\n            this._addClass( \"ui-resizable-resizing\" );\n            this._propagate( \"start\", event );\n            return true;\n        },\n\n        _mouseDrag: function( event ) {\n\n            var data, props,\n                smp = this.originalMousePosition,\n                a = this.axis,\n                dx = ( event.pageX - smp.left ) || 0,\n                dy = ( event.pageY - smp.top ) || 0,\n                trigger = this._change[ a ];\n\n            this._updatePrevProperties();\n\n            if ( !trigger ) {\n                return false;\n            }\n\n            data = trigger.apply( this, [ event, dx, dy ] );\n\n            this._updateVirtualBoundaries( event.shiftKey );\n            if ( this._aspectRatio || event.shiftKey ) {\n                data = this._updateRatio( data, event );\n            }\n\n            data = this._respectSize( data, event );\n\n            this._updateCache( data );\n\n            this._propagate( \"resize\", event );\n\n            props = this._applyChanges();\n\n            if ( !this._helper && this._proportionallyResizeElements.length ) {\n                this._proportionallyResize();\n            }\n\n            if ( !$.isEmptyObject( props ) ) {\n                this._updatePrevProperties();\n                this._trigger( \"resize\", event, this.ui() );\n                this._applyChanges();\n            }\n\n            return false;\n        },\n\n        _mouseStop: function( event ) {\n\n            this.resizing = false;\n            var pr, ista, soffseth, soffsetw, s, left, top,\n                o = this.options, that = this;\n\n            if ( this._helper ) {\n\n                pr = this._proportionallyResizeElements;\n                ista = pr.length && ( /textarea/i ).test( pr[ 0 ].nodeName );\n                soffseth = ista && this._hasScroll( pr[ 0 ], \"left\" ) ? 0 : that.sizeDiff.height;\n                soffsetw = ista ? 0 : that.sizeDiff.width;\n\n                s = {\n                    width: ( that.helper.width()  - soffsetw ),\n                    height: ( that.helper.height() - soffseth )\n                };\n                left = ( parseFloat( that.element.css( \"left\" ) ) +\n                    ( that.position.left - that.originalPosition.left ) ) || null;\n                top = ( parseFloat( that.element.css( \"top\" ) ) +\n                    ( that.position.top - that.originalPosition.top ) ) || null;\n\n                if ( !o.animate ) {\n                    this.element.css( $.extend( s, { top: top, left: left } ) );\n                }\n\n                that.helper.height( that.size.height );\n                that.helper.width( that.size.width );\n\n                if ( this._helper && !o.animate ) {\n                    this._proportionallyResize();\n                }\n            }\n\n            $( \"body\" ).css( \"cursor\", \"auto\" );\n\n            this._removeClass( \"ui-resizable-resizing\" );\n\n            this._propagate( \"stop\", event );\n\n            if ( this._helper ) {\n                this.helper.remove();\n            }\n\n            return false;\n\n        },\n\n        _updatePrevProperties: function() {\n            this.prevPosition = {\n                top: this.position.top,\n                left: this.position.left\n            };\n            this.prevSize = {\n                width: this.size.width,\n                height: this.size.height\n            };\n        },\n\n        _applyChanges: function() {\n            var props = {};\n\n            if ( this.position.top !== this.prevPosition.top ) {\n                props.top = this.position.top + \"px\";\n            }\n            if ( this.position.left !== this.prevPosition.left ) {\n                props.left = this.position.left + \"px\";\n            }\n            if ( this.size.width !== this.prevSize.width ) {\n                props.width = this.size.width + \"px\";\n            }\n            if ( this.size.height !== this.prevSize.height ) {\n                props.height = this.size.height + \"px\";\n            }\n\n            this.helper.css( props );\n\n            return props;\n        },\n\n        _updateVirtualBoundaries: function( forceAspectRatio ) {\n            var pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b,\n                o = this.options;\n\n            b = {\n                minWidth: this._isNumber( o.minWidth ) ? o.minWidth : 0,\n                maxWidth: this._isNumber( o.maxWidth ) ? o.maxWidth : Infinity,\n                minHeight: this._isNumber( o.minHeight ) ? o.minHeight : 0,\n                maxHeight: this._isNumber( o.maxHeight ) ? o.maxHeight : Infinity\n            };\n\n            if ( this._aspectRatio || forceAspectRatio ) {\n                pMinWidth = b.minHeight * this.aspectRatio;\n                pMinHeight = b.minWidth / this.aspectRatio;\n                pMaxWidth = b.maxHeight * this.aspectRatio;\n                pMaxHeight = b.maxWidth / this.aspectRatio;\n\n                if ( pMinWidth > b.minWidth ) {\n                    b.minWidth = pMinWidth;\n                }\n                if ( pMinHeight > b.minHeight ) {\n                    b.minHeight = pMinHeight;\n                }\n                if ( pMaxWidth < b.maxWidth ) {\n                    b.maxWidth = pMaxWidth;\n                }\n                if ( pMaxHeight < b.maxHeight ) {\n                    b.maxHeight = pMaxHeight;\n                }\n            }\n            this._vBoundaries = b;\n        },\n\n        _updateCache: function( data ) {\n            this.offset = this.helper.offset();\n            if ( this._isNumber( data.left ) ) {\n                this.position.left = data.left;\n            }\n            if ( this._isNumber( data.top ) ) {\n                this.position.top = data.top;\n            }\n            if ( this._isNumber( data.height ) ) {\n                this.size.height = data.height;\n            }\n            if ( this._isNumber( data.width ) ) {\n                this.size.width = data.width;\n            }\n        },\n\n        _updateRatio: function( data ) {\n\n            var cpos = this.position,\n                csize = this.size,\n                a = this.axis;\n\n            if ( this._isNumber( data.height ) ) {\n                data.width = ( data.height * this.aspectRatio );\n            } else if ( this._isNumber( data.width ) ) {\n                data.height = ( data.width / this.aspectRatio );\n            }\n\n            if ( a === \"sw\" ) {\n                data.left = cpos.left + ( csize.width - data.width );\n                data.top = null;\n            }\n            if ( a === \"nw\" ) {\n                data.top = cpos.top + ( csize.height - data.height );\n                data.left = cpos.left + ( csize.width - data.width );\n            }\n\n            return data;\n        },\n\n        _respectSize: function( data ) {\n\n            var o = this._vBoundaries,\n                a = this.axis,\n                ismaxw = this._isNumber( data.width ) && o.maxWidth && ( o.maxWidth < data.width ),\n                ismaxh = this._isNumber( data.height ) && o.maxHeight && ( o.maxHeight < data.height ),\n                isminw = this._isNumber( data.width ) && o.minWidth && ( o.minWidth > data.width ),\n                isminh = this._isNumber( data.height ) && o.minHeight && ( o.minHeight > data.height ),\n                dw = this.originalPosition.left + this.originalSize.width,\n                dh = this.originalPosition.top + this.originalSize.height,\n                cw = /sw|nw|w/.test( a ), ch = /nw|ne|n/.test( a );\n            if ( isminw ) {\n                data.width = o.minWidth;\n            }\n            if ( isminh ) {\n                data.height = o.minHeight;\n            }\n            if ( ismaxw ) {\n                data.width = o.maxWidth;\n            }\n            if ( ismaxh ) {\n                data.height = o.maxHeight;\n            }\n\n            if ( isminw && cw ) {\n                data.left = dw - o.minWidth;\n            }\n            if ( ismaxw && cw ) {\n                data.left = dw - o.maxWidth;\n            }\n            if ( isminh && ch ) {\n                data.top = dh - o.minHeight;\n            }\n            if ( ismaxh && ch ) {\n                data.top = dh - o.maxHeight;\n            }\n\n            // Fixing jump error on top/left - bug #2330\n            if ( !data.width && !data.height && !data.left && data.top ) {\n                data.top = null;\n            } else if ( !data.width && !data.height && !data.top && data.left ) {\n                data.left = null;\n            }\n\n            return data;\n        },\n\n        _getPaddingPlusBorderDimensions: function( element ) {\n            var i = 0,\n                widths = [],\n                borders = [\n                    element.css( \"borderTopWidth\" ),\n                    element.css( \"borderRightWidth\" ),\n                    element.css( \"borderBottomWidth\" ),\n                    element.css( \"borderLeftWidth\" )\n                ],\n                paddings = [\n                    element.css( \"paddingTop\" ),\n                    element.css( \"paddingRight\" ),\n                    element.css( \"paddingBottom\" ),\n                    element.css( \"paddingLeft\" )\n                ];\n\n            for ( ; i < 4; i++ ) {\n                widths[ i ] = ( parseFloat( borders[ i ] ) || 0 );\n                widths[ i ] += ( parseFloat( paddings[ i ] ) || 0 );\n            }\n\n            return {\n                height: widths[ 0 ] + widths[ 2 ],\n                width: widths[ 1 ] + widths[ 3 ]\n            };\n        },\n\n        _proportionallyResize: function() {\n\n            if ( !this._proportionallyResizeElements.length ) {\n                return;\n            }\n\n            var prel,\n                i = 0,\n                element = this.helper || this.element;\n\n            for ( ; i < this._proportionallyResizeElements.length; i++ ) {\n\n                prel = this._proportionallyResizeElements[ i ];\n\n                // TODO: Seems like a bug to cache this.outerDimensions\n                // considering that we are in a loop.\n                if ( !this.outerDimensions ) {\n                    this.outerDimensions = this._getPaddingPlusBorderDimensions( prel );\n                }\n\n                prel.css( {\n                    height: ( element.height() - this.outerDimensions.height ) || 0,\n                    width: ( element.width() - this.outerDimensions.width ) || 0\n                } );\n\n            }\n\n        },\n\n        _renderProxy: function() {\n\n            var el = this.element, o = this.options;\n            this.elementOffset = el.offset();\n\n            if ( this._helper ) {\n\n                this.helper = this.helper || $( \"<div></div>\" ).css( { overflow: \"hidden\" } );\n\n                this._addClass( this.helper, this._helper );\n                this.helper.css( {\n                    width: this.element.outerWidth(),\n                    height: this.element.outerHeight(),\n                    position: \"absolute\",\n                    left: this.elementOffset.left + \"px\",\n                    top: this.elementOffset.top + \"px\",\n                    zIndex: ++o.zIndex //TODO: Don't modify option\n                } );\n\n                this.helper\n                    .appendTo( \"body\" )\n                    .disableSelection();\n\n            } else {\n                this.helper = this.element;\n            }\n\n        },\n\n        _change: {\n            e: function( event, dx ) {\n                return { width: this.originalSize.width + dx };\n            },\n            w: function( event, dx ) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return { left: sp.left + dx, width: cs.width - dx };\n            },\n            n: function( event, dx, dy ) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return { top: sp.top + dy, height: cs.height - dy };\n            },\n            s: function( event, dx, dy ) {\n                return { height: this.originalSize.height + dy };\n            },\n            se: function( event, dx, dy ) {\n                return $.extend( this._change.s.apply( this, arguments ),\n                    this._change.e.apply( this, [ event, dx, dy ] ) );\n            },\n            sw: function( event, dx, dy ) {\n                return $.extend( this._change.s.apply( this, arguments ),\n                    this._change.w.apply( this, [ event, dx, dy ] ) );\n            },\n            ne: function( event, dx, dy ) {\n                return $.extend( this._change.n.apply( this, arguments ),\n                    this._change.e.apply( this, [ event, dx, dy ] ) );\n            },\n            nw: function( event, dx, dy ) {\n                return $.extend( this._change.n.apply( this, arguments ),\n                    this._change.w.apply( this, [ event, dx, dy ] ) );\n            }\n        },\n\n        _propagate: function( n, event ) {\n            $.ui.plugin.call( this, n, [ event, this.ui() ] );\n            if ( n !== \"resize\" ) {\n                this._trigger( n, event, this.ui() );\n            }\n        },\n\n        plugins: {},\n\n        ui: function() {\n            return {\n                originalElement: this.originalElement,\n                element: this.element,\n                helper: this.helper,\n                position: this.position,\n                size: this.size,\n                originalSize: this.originalSize,\n                originalPosition: this.originalPosition\n            };\n        }\n\n    } );\n\n    /*\n     * Resizable Extensions\n     */\n\n    $.ui.plugin.add( \"resizable\", \"animate\", {\n\n        stop: function( event ) {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                pr = that._proportionallyResizeElements,\n                ista = pr.length && ( /textarea/i ).test( pr[ 0 ].nodeName ),\n                soffseth = ista && that._hasScroll( pr[ 0 ], \"left\" ) ? 0 : that.sizeDiff.height,\n                soffsetw = ista ? 0 : that.sizeDiff.width,\n                style = {\n                    width: ( that.size.width - soffsetw ),\n                    height: ( that.size.height - soffseth )\n                },\n                left = ( parseFloat( that.element.css( \"left\" ) ) +\n                    ( that.position.left - that.originalPosition.left ) ) || null,\n                top = ( parseFloat( that.element.css( \"top\" ) ) +\n                    ( that.position.top - that.originalPosition.top ) ) || null;\n\n            that.element.animate(\n                $.extend( style, top && left ? { top: top, left: left } : {} ), {\n                    duration: o.animateDuration,\n                    easing: o.animateEasing,\n                    step: function() {\n\n                        var data = {\n                            width: parseFloat( that.element.css( \"width\" ) ),\n                            height: parseFloat( that.element.css( \"height\" ) ),\n                            top: parseFloat( that.element.css( \"top\" ) ),\n                            left: parseFloat( that.element.css( \"left\" ) )\n                        };\n\n                        if ( pr && pr.length ) {\n                            $( pr[ 0 ] ).css( { width: data.width, height: data.height } );\n                        }\n\n                        // Propagating resize, and updating values for each animation step\n                        that._updateCache( data );\n                        that._propagate( \"resize\", event );\n\n                    }\n                }\n            );\n        }\n\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"containment\", {\n\n        start: function() {\n            var element, p, co, ch, cw, width, height,\n                that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                el = that.element,\n                oc = o.containment,\n                ce = ( oc instanceof $ ) ?\n                    oc.get( 0 ) :\n                    ( /parent/.test( oc ) ) ? el.parent().get( 0 ) : oc;\n\n            if ( !ce ) {\n                return;\n            }\n\n            that.containerElement = $( ce );\n\n            if ( /document/.test( oc ) || oc === document ) {\n                that.containerOffset = {\n                    left: 0,\n                    top: 0\n                };\n                that.containerPosition = {\n                    left: 0,\n                    top: 0\n                };\n\n                that.parentData = {\n                    element: $( document ),\n                    left: 0,\n                    top: 0,\n                    width: $( document ).width(),\n                    height: $( document ).height() || document.body.parentNode.scrollHeight\n                };\n            } else {\n                element = $( ce );\n                p = [];\n                $( [ \"Top\", \"Right\", \"Left\", \"Bottom\" ] ).each( function( i, name ) {\n                    p[ i ] = that._num( element.css( \"padding\" + name ) );\n                } );\n\n                that.containerOffset = element.offset();\n                that.containerPosition = element.position();\n                that.containerSize = {\n                    height: ( element.innerHeight() - p[ 3 ] ),\n                    width: ( element.innerWidth() - p[ 1 ] )\n                };\n\n                co = that.containerOffset;\n                ch = that.containerSize.height;\n                cw = that.containerSize.width;\n                width = ( that._hasScroll( ce, \"left\" ) ? ce.scrollWidth : cw );\n                height = ( that._hasScroll( ce ) ? ce.scrollHeight : ch );\n\n                that.parentData = {\n                    element: ce,\n                    left: co.left,\n                    top: co.top,\n                    width: width,\n                    height: height\n                };\n            }\n        },\n\n        resize: function( event ) {\n            var woset, hoset, isParent, isOffsetRelative,\n                that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                co = that.containerOffset,\n                cp = that.position,\n                pRatio = that._aspectRatio || event.shiftKey,\n                cop = {\n                    top: 0,\n                    left: 0\n                },\n                ce = that.containerElement,\n                continueResize = true;\n\n            if ( ce[ 0 ] !== document && ( /static/ ).test( ce.css( \"position\" ) ) ) {\n                cop = co;\n            }\n\n            if ( cp.left < ( that._helper ? co.left : 0 ) ) {\n                that.size.width = that.size.width +\n                    ( that._helper ?\n                        ( that.position.left - co.left ) :\n                        ( that.position.left - cop.left ) );\n\n                if ( pRatio ) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                    continueResize = false;\n                }\n                that.position.left = o.helper ? co.left : 0;\n            }\n\n            if ( cp.top < ( that._helper ? co.top : 0 ) ) {\n                that.size.height = that.size.height +\n                    ( that._helper ?\n                        ( that.position.top - co.top ) :\n                        that.position.top );\n\n                if ( pRatio ) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                    continueResize = false;\n                }\n                that.position.top = that._helper ? co.top : 0;\n            }\n\n            isParent = that.containerElement.get( 0 ) === that.element.parent().get( 0 );\n            isOffsetRelative = /relative|absolute/.test( that.containerElement.css( \"position\" ) );\n\n            if ( isParent && isOffsetRelative ) {\n                that.offset.left = that.parentData.left + that.position.left;\n                that.offset.top = that.parentData.top + that.position.top;\n            } else {\n                that.offset.left = that.element.offset().left;\n                that.offset.top = that.element.offset().top;\n            }\n\n            woset = Math.abs( that.sizeDiff.width +\n                ( that._helper ?\n                    that.offset.left - cop.left :\n                    ( that.offset.left - co.left ) ) );\n\n            hoset = Math.abs( that.sizeDiff.height +\n                ( that._helper ?\n                    that.offset.top - cop.top :\n                    ( that.offset.top - co.top ) ) );\n\n            if ( woset + that.size.width >= that.parentData.width ) {\n                that.size.width = that.parentData.width - woset;\n                if ( pRatio ) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                    continueResize = false;\n                }\n            }\n\n            if ( hoset + that.size.height >= that.parentData.height ) {\n                that.size.height = that.parentData.height - hoset;\n                if ( pRatio ) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                    continueResize = false;\n                }\n            }\n\n            if ( !continueResize ) {\n                that.position.left = that.prevPosition.left;\n                that.position.top = that.prevPosition.top;\n                that.size.width = that.prevSize.width;\n                that.size.height = that.prevSize.height;\n            }\n        },\n\n        stop: function() {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                co = that.containerOffset,\n                cop = that.containerPosition,\n                ce = that.containerElement,\n                helper = $( that.helper ),\n                ho = helper.offset(),\n                w = helper.outerWidth() - that.sizeDiff.width,\n                h = helper.outerHeight() - that.sizeDiff.height;\n\n            if ( that._helper && !o.animate && ( /relative/ ).test( ce.css( \"position\" ) ) ) {\n                $( this ).css( {\n                    left: ho.left - cop.left - co.left,\n                    width: w,\n                    height: h\n                } );\n            }\n\n            if ( that._helper && !o.animate && ( /static/ ).test( ce.css( \"position\" ) ) ) {\n                $( this ).css( {\n                    left: ho.left - cop.left - co.left,\n                    width: w,\n                    height: h\n                } );\n            }\n        }\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"alsoResize\", {\n\n        start: function() {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options;\n\n            $( o.alsoResize ).each( function() {\n                var el = $( this );\n                el.data( \"ui-resizable-alsoresize\", {\n                    width: parseFloat( el.width() ), height: parseFloat( el.height() ),\n                    left: parseFloat( el.css( \"left\" ) ), top: parseFloat( el.css( \"top\" ) )\n                } );\n            } );\n        },\n\n        resize: function( event, ui ) {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                os = that.originalSize,\n                op = that.originalPosition,\n                delta = {\n                    height: ( that.size.height - os.height ) || 0,\n                    width: ( that.size.width - os.width ) || 0,\n                    top: ( that.position.top - op.top ) || 0,\n                    left: ( that.position.left - op.left ) || 0\n                };\n\n            $( o.alsoResize ).each( function() {\n                var el = $( this ), start = $( this ).data( \"ui-resizable-alsoresize\" ), style = {},\n                    css = el.parents( ui.originalElement[ 0 ] ).length ?\n                        [ \"width\", \"height\" ] :\n                        [ \"width\", \"height\", \"top\", \"left\" ];\n\n                $.each( css, function( i, prop ) {\n                    var sum = ( start[ prop ] || 0 ) + ( delta[ prop ] || 0 );\n                    if ( sum && sum >= 0 ) {\n                        style[ prop ] = sum || null;\n                    }\n                } );\n\n                el.css( style );\n            } );\n        },\n\n        stop: function() {\n            $( this ).removeData( \"ui-resizable-alsoresize\" );\n        }\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"ghost\", {\n\n        start: function() {\n\n            var that = $( this ).resizable( \"instance\" ), cs = that.size;\n\n            that.ghost = that.originalElement.clone();\n            that.ghost.css( {\n                opacity: 0.25,\n                display: \"block\",\n                position: \"relative\",\n                height: cs.height,\n                width: cs.width,\n                margin: 0,\n                left: 0,\n                top: 0\n            } );\n\n            that._addClass( that.ghost, \"ui-resizable-ghost\" );\n\n            // DEPRECATED\n            // TODO: remove after 1.12\n            if ( $.uiBackCompat !== false && typeof that.options.ghost === \"string\" ) {\n\n                // Ghost option\n                that.ghost.addClass( this.options.ghost );\n            }\n\n            that.ghost.appendTo( that.helper );\n\n        },\n\n        resize: function() {\n            var that = $( this ).resizable( \"instance\" );\n            if ( that.ghost ) {\n                that.ghost.css( {\n                    position: \"relative\",\n                    height: that.size.height,\n                    width: that.size.width\n                } );\n            }\n        },\n\n        stop: function() {\n            var that = $( this ).resizable( \"instance\" );\n            if ( that.ghost && that.helper ) {\n                that.helper.get( 0 ).removeChild( that.ghost.get( 0 ) );\n            }\n        }\n\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"grid\", {\n\n        resize: function() {\n            var outerDimensions,\n                that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                cs = that.size,\n                os = that.originalSize,\n                op = that.originalPosition,\n                a = that.axis,\n                grid = typeof o.grid === \"number\" ? [ o.grid, o.grid ] : o.grid,\n                gridX = ( grid[ 0 ] || 1 ),\n                gridY = ( grid[ 1 ] || 1 ),\n                ox = Math.round( ( cs.width - os.width ) / gridX ) * gridX,\n                oy = Math.round( ( cs.height - os.height ) / gridY ) * gridY,\n                newWidth = os.width + ox,\n                newHeight = os.height + oy,\n                isMaxWidth = o.maxWidth && ( o.maxWidth < newWidth ),\n                isMaxHeight = o.maxHeight && ( o.maxHeight < newHeight ),\n                isMinWidth = o.minWidth && ( o.minWidth > newWidth ),\n                isMinHeight = o.minHeight && ( o.minHeight > newHeight );\n\n            o.grid = grid;\n\n            if ( isMinWidth ) {\n                newWidth += gridX;\n            }\n            if ( isMinHeight ) {\n                newHeight += gridY;\n            }\n            if ( isMaxWidth ) {\n                newWidth -= gridX;\n            }\n            if ( isMaxHeight ) {\n                newHeight -= gridY;\n            }\n\n            if ( /^(se|s|e)$/.test( a ) ) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n            } else if ( /^(ne)$/.test( a ) ) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.top = op.top - oy;\n            } else if ( /^(sw)$/.test( a ) ) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.left = op.left - ox;\n            } else {\n                if ( newHeight - gridY <= 0 || newWidth - gridX <= 0 ) {\n                    outerDimensions = that._getPaddingPlusBorderDimensions( this );\n                }\n\n                if ( newHeight - gridY > 0 ) {\n                    that.size.height = newHeight;\n                    that.position.top = op.top - oy;\n                } else {\n                    newHeight = gridY - outerDimensions.height;\n                    that.size.height = newHeight;\n                    that.position.top = op.top + os.height - newHeight;\n                }\n                if ( newWidth - gridX > 0 ) {\n                    that.size.width = newWidth;\n                    that.position.left = op.left - ox;\n                } else {\n                    newWidth = gridX - outerDimensions.width;\n                    that.size.width = newWidth;\n                    that.position.left = op.left + os.width - newWidth;\n                }\n            }\n        }\n\n    } );\n\n    return $.ui.resizable;\n\n} );\n","jquery/ui-modules/widgets/spinner.js":"/*!\n * jQuery UI Spinner 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Spinner\n//>>group: Widgets\n//>>description: Displays buttons to easily input numbers via the keyboard or mouse.\n//>>docs: http://api.jqueryui.com/spinner/\n//>>demos: http://jqueryui.com/spinner/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/spinner.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./button\",\n            \"../version\",\n            \"../keycode\",\n            \"../safe-active-element\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    function spinnerModifier( fn ) {\n        return function() {\n            var previous = this.element.val();\n            fn.apply( this, arguments );\n            this._refresh();\n            if ( previous !== this.element.val() ) {\n                this._trigger( \"change\" );\n            }\n        };\n    }\n\n    $.widget( \"ui.spinner\", {\n        version: \"1.13.2\",\n        defaultElement: \"<input>\",\n        widgetEventPrefix: \"spin\",\n        options: {\n            classes: {\n                \"ui-spinner\": \"ui-corner-all\",\n                \"ui-spinner-down\": \"ui-corner-br\",\n                \"ui-spinner-up\": \"ui-corner-tr\"\n            },\n            culture: null,\n            icons: {\n                down: \"ui-icon-triangle-1-s\",\n                up: \"ui-icon-triangle-1-n\"\n            },\n            incremental: true,\n            max: null,\n            min: null,\n            numberFormat: null,\n            page: 10,\n            step: 1,\n\n            change: null,\n            spin: null,\n            start: null,\n            stop: null\n        },\n\n        _create: function() {\n\n            // handle string values that need to be parsed\n            this._setOption( \"max\", this.options.max );\n            this._setOption( \"min\", this.options.min );\n            this._setOption( \"step\", this.options.step );\n\n            // Only format if there is a value, prevents the field from being marked\n            // as invalid in Firefox, see #9573.\n            if ( this.value() !== \"\" ) {\n\n                // Format the value, but don't constrain.\n                this._value( this.element.val(), true );\n            }\n\n            this._draw();\n            this._on( this._events );\n            this._refresh();\n\n            // Turning off autocomplete prevents the browser from remembering the\n            // value when navigating through history, so we re-enable autocomplete\n            // if the page is unloaded before the widget is destroyed. #7790\n            this._on( this.window, {\n                beforeunload: function() {\n                    this.element.removeAttr( \"autocomplete\" );\n                }\n            } );\n        },\n\n        _getCreateOptions: function() {\n            var options = this._super();\n            var element = this.element;\n\n            $.each( [ \"min\", \"max\", \"step\" ], function( i, option ) {\n                var value = element.attr( option );\n                if ( value != null && value.length ) {\n                    options[ option ] = value;\n                }\n            } );\n\n            return options;\n        },\n\n        _events: {\n            keydown: function( event ) {\n                if ( this._start( event ) && this._keydown( event ) ) {\n                    event.preventDefault();\n                }\n            },\n            keyup: \"_stop\",\n            focus: function() {\n                this.previous = this.element.val();\n            },\n            blur: function( event ) {\n                if ( this.cancelBlur ) {\n                    delete this.cancelBlur;\n                    return;\n                }\n\n                this._stop();\n                this._refresh();\n                if ( this.previous !== this.element.val() ) {\n                    this._trigger( \"change\", event );\n                }\n            },\n            mousewheel: function( event, delta ) {\n                var activeElement = $.ui.safeActiveElement( this.document[ 0 ] );\n                var isActive = this.element[ 0 ] === activeElement;\n\n                if ( !isActive || !delta ) {\n                    return;\n                }\n\n                if ( !this.spinning && !this._start( event ) ) {\n                    return false;\n                }\n\n                this._spin( ( delta > 0 ? 1