define(
    [
        'jquery',
        'uiComponent',
        'knockout',
        'mage/translate',
    ],
    function ($, Component, ko, $t,) {
        'use strict';

        return Component.extend({
            defaults: {
                template: 'Extendware_AskQuestion/view/form',
            },
            productSku: null,
            productName: null,
            form_key: $.cookie('form_key'),
            responseMessage: ko.observable(''),
            questionSent: ko.observable(false),
            formData: ko.observable({
                name: '',
                email: '',
                question: '',
            }),
            initialize: function(config) {
                this._super();
                const self = this;

                self.buttonLabel = ko.computed(() => {
                    return self.questionSent() ? $t('Sent') : $t('Submit Question');
                });

                self.productName = config.productName;
                self.endpoint = config.endpoint;
                self.productSku = config.productSku;
            },
            sendQuestion: function () {
                const self = this;

                if (self.questionSent()) {
                    return true;
                }

                self.questionSent(true);

                self.postFormData(self.endpoint,
                    {
                        ...self.formData(),
                        product_sku: self.productSku,
                        form_key: self.form_key,
                        isAjax: true,
                    })
                    .then((data) => {
                        self.responseMessage(data.msg);

                        if (!data || !data.success) {
                            this.questionSent(false);
                        }
                    });
            },
            postFormData: async function (url, data) {
                const response = await fetch(url, {
                    method: 'POST',
                    headers: {
                        "content-type": "application/x-www-form-urlencoded; charset=UTF-8",
                    },
                    body: new URLSearchParams(data),
                });

                return response.json();
            }
        });
    }
);
