require.config({"config": {
        "jsbuild":{"jquery/ui-modules/widgets/slider.js":"/*!\n * jQuery UI Slider 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Slider\n//>>group: Widgets\n//>>description: Displays a flexible slider with ranges and accessibility via keyboard.\n//>>docs: http://api.jqueryui.com/slider/\n//>>demos: http://jqueryui.com/slider/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/slider.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../keycode\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.slider\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"slide\",\n\n        options: {\n            animate: false,\n            classes: {\n                \"ui-slider\": \"ui-corner-all\",\n                \"ui-slider-handle\": \"ui-corner-all\",\n\n                // Note: ui-widget-header isn't the most fittingly semantic framework class for this\n                // element, but worked best visually with a variety of themes\n                \"ui-slider-range\": \"ui-corner-all ui-widget-header\"\n            },\n            distance: 0,\n            max: 100,\n            min: 0,\n            orientation: \"horizontal\",\n            range: false,\n            step: 1,\n            value: 0,\n            values: null,\n\n            // Callbacks\n            change: null,\n            slide: null,\n            start: null,\n            stop: null\n        },\n\n        // Number of pages in a slider\n        // (how many times can you page up/down to go through the whole range)\n        numPages: 5,\n\n        _create: function() {\n            this._keySliding = false;\n            this._mouseSliding = false;\n            this._animateOff = true;\n            this._handleIndex = null;\n            this._detectOrientation();\n            this._mouseInit();\n            this._calculateNewMax();\n\n            this._addClass( \"ui-slider ui-slider-\" + this.orientation,\n                \"ui-widget ui-widget-content\" );\n\n            this._refresh();\n\n            this._animateOff = false;\n        },\n\n        _refresh: function() {\n            this._createRange();\n            this._createHandles();\n            this._setupEvents();\n            this._refreshValue();\n        },\n\n        _createHandles: function() {\n            var i, handleCount,\n                options = this.options,\n                existingHandles = this.element.find( \".ui-slider-handle\" ),\n                handle = \"<span tabindex='0'></span>\",\n                handles = [];\n\n            handleCount = ( options.values && options.values.length ) || 1;\n\n            if ( existingHandles.length > handleCount ) {\n                existingHandles.slice( handleCount ).remove();\n                existingHandles = existingHandles.slice( 0, handleCount );\n            }\n\n            for ( i = existingHandles.length; i < handleCount; i++ ) {\n                handles.push( handle );\n            }\n\n            this.handles = existingHandles.add( $( handles.join( \"\" ) ).appendTo( this.element ) );\n\n            this._addClass( this.handles, \"ui-slider-handle\", \"ui-state-default\" );\n\n            this.handle = this.handles.eq( 0 );\n\n            this.handles.each( function( i ) {\n                $( this )\n                    .data( \"ui-slider-handle-index\", i )\n                    .attr( \"tabIndex\", 0 );\n            } );\n        },\n\n        _createRange: function() {\n            var options = this.options;\n\n            if ( options.range ) {\n                if ( options.range === true ) {\n                    if ( !options.values ) {\n                        options.values = [ this._valueMin(), this._valueMin() ];\n                    } else if ( options.values.length && options.values.length !== 2 ) {\n                        options.values = [ options.values[ 0 ], options.values[ 0 ] ];\n                    } else if ( Array.isArray( options.values ) ) {\n                        options.values = options.values.slice( 0 );\n                    }\n                }\n\n                if ( !this.range || !this.range.length ) {\n                    this.range = $( \"<div>\" )\n                        .appendTo( this.element );\n\n                    this._addClass( this.range, \"ui-slider-range\" );\n                } else {\n                    this._removeClass( this.range, \"ui-slider-range-min ui-slider-range-max\" );\n\n                    // Handle range switching from true to min/max\n                    this.range.css( {\n                        \"left\": \"\",\n                        \"bottom\": \"\"\n                    } );\n                }\n                if ( options.range === \"min\" || options.range === \"max\" ) {\n                    this._addClass( this.range, \"ui-slider-range-\" + options.range );\n                }\n            } else {\n                if ( this.range ) {\n                    this.range.remove();\n                }\n                this.range = null;\n            }\n        },\n\n        _setupEvents: function() {\n            this._off( this.handles );\n            this._on( this.handles, this._handleEvents );\n            this._hoverable( this.handles );\n            this._focusable( this.handles );\n        },\n\n        _destroy: function() {\n            this.handles.remove();\n            if ( this.range ) {\n                this.range.remove();\n            }\n\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function( event ) {\n            var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,\n                that = this,\n                o = this.options;\n\n            if ( o.disabled ) {\n                return false;\n            }\n\n            this.elementSize = {\n                width: this.element.outerWidth(),\n                height: this.element.outerHeight()\n            };\n            this.elementOffset = this.element.offset();\n\n            position = { x: event.pageX, y: event.pageY };\n            normValue = this._normValueFromMouse( position );\n            distance = this._valueMax() - this._valueMin() + 1;\n            this.handles.each( function( i ) {\n                var thisDistance = Math.abs( normValue - that.values( i ) );\n                if ( ( distance > thisDistance ) ||\n                    ( distance === thisDistance &&\n                        ( i === that._lastChangedValue || that.values( i ) === o.min ) ) ) {\n                    distance = thisDistance;\n                    closestHandle = $( this );\n                    index = i;\n                }\n            } );\n\n            allowed = this._start( event, index );\n            if ( allowed === false ) {\n                return false;\n            }\n            this._mouseSliding = true;\n\n            this._handleIndex = index;\n\n            this._addClass( closestHandle, null, \"ui-state-active\" );\n            closestHandle.trigger( \"focus\" );\n\n            offset = closestHandle.offset();\n            mouseOverHandle = !$( event.target ).parents().addBack().is( \".ui-slider-handle\" );\n            this._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {\n                left: event.pageX - offset.left - ( closestHandle.width() / 2 ),\n                top: event.pageY - offset.top -\n                    ( closestHandle.height() / 2 ) -\n                    ( parseInt( closestHandle.css( \"borderTopWidth\" ), 10 ) || 0 ) -\n                    ( parseInt( closestHandle.css( \"borderBottomWidth\" ), 10 ) || 0 ) +\n                    ( parseInt( closestHandle.css( \"marginTop\" ), 10 ) || 0 )\n            };\n\n            if ( !this.handles.hasClass( \"ui-state-hover\" ) ) {\n                this._slide( event, index, normValue );\n            }\n            this._animateOff = true;\n            return true;\n        },\n\n        _mouseStart: function() {\n            return true;\n        },\n\n        _mouseDrag: function( event ) {\n            var position = { x: event.pageX, y: event.pageY },\n                normValue = this._normValueFromMouse( position );\n\n            this._slide( event, this._handleIndex, normValue );\n\n            return false;\n        },\n\n        _mouseStop: function( event ) {\n            this._removeClass( this.handles, null, \"ui-state-active\" );\n            this._mouseSliding = false;\n\n            this._stop( event, this._handleIndex );\n            this._change( event, this._handleIndex );\n\n            this._handleIndex = null;\n            this._clickOffset = null;\n            this._animateOff = false;\n\n            return false;\n        },\n\n        _detectOrientation: function() {\n            this.orientation = ( this.options.orientation === \"vertical\" ) ? \"vertical\" : \"horizontal\";\n        },\n\n        _normValueFromMouse: function( position ) {\n            var pixelTotal,\n                pixelMouse,\n                percentMouse,\n                valueTotal,\n                valueMouse;\n\n            if ( this.orientation === \"horizontal\" ) {\n                pixelTotal = this.elementSize.width;\n                pixelMouse = position.x - this.elementOffset.left -\n                    ( this._clickOffset ? this._clickOffset.left : 0 );\n            } else {\n                pixelTotal = this.elementSize.height;\n                pixelMouse = position.y - this.elementOffset.top -\n                    ( this._clickOffset ? this._clickOffset.top : 0 );\n            }\n\n            percentMouse = ( pixelMouse / pixelTotal );\n            if ( percentMouse > 1 ) {\n                percentMouse = 1;\n            }\n            if ( percentMouse < 0 ) {\n                percentMouse = 0;\n            }\n            if ( this.orientation === \"vertical\" ) {\n                percentMouse = 1 - percentMouse;\n            }\n\n            valueTotal = this._valueMax() - this._valueMin();\n            valueMouse = this._valueMin() + percentMouse * valueTotal;\n\n            return this._trimAlignValue( valueMouse );\n        },\n\n        _uiHash: function( index, value, values ) {\n            var uiHash = {\n                handle: this.handles[ index ],\n                handleIndex: index,\n                value: value !== undefined ? value : this.value()\n            };\n\n            if ( this._hasMultipleValues() ) {\n                uiHash.value = value !== undefined ? value : this.values( index );\n                uiHash.values = values || this.values();\n            }\n\n            return uiHash;\n        },\n\n        _hasMultipleValues: function() {\n            return this.options.values && this.options.values.length;\n        },\n\n        _start: function( event, index ) {\n            return this._trigger( \"start\", event, this._uiHash( index ) );\n        },\n\n        _slide: function( event, index, newVal ) {\n            var allowed, otherVal,\n                currentValue = this.value(),\n                newValues = this.values();\n\n            if ( this._hasMultipleValues() ) {\n                otherVal = this.values( index ? 0 : 1 );\n                currentValue = this.values( index );\n\n                if ( this.options.values.length === 2 && this.options.range === true ) {\n                    newVal =  index === 0 ? Math.min( otherVal, newVal ) : Math.max( otherVal, newVal );\n                }\n\n                newValues[ index ] = newVal;\n            }\n\n            if ( newVal === currentValue ) {\n                return;\n            }\n\n            allowed = this._trigger( \"slide\", event, this._uiHash( index, newVal, newValues ) );\n\n            // A slide can be canceled by returning false from the slide callback\n            if ( allowed === false ) {\n                return;\n            }\n\n            if ( this._hasMultipleValues() ) {\n                this.values( index, newVal );\n            } else {\n                this.value( newVal );\n            }\n        },\n\n        _stop: function( event, index ) {\n            this._trigger( \"stop\", event, this._uiHash( index ) );\n        },\n\n        _change: function( event, index ) {\n            if ( !this._keySliding && !this._mouseSliding ) {\n\n                //store the last changed value index for reference when handles overlap\n                this._lastChangedValue = index;\n                this._trigger( \"change\", event, this._uiHash( index ) );\n            }\n        },\n\n        value: function( newValue ) {\n            if ( arguments.length ) {\n                this.options.value = this._trimAlignValue( newValue );\n                this._refreshValue();\n                this._change( null, 0 );\n                return;\n            }\n\n            return this._value();\n        },\n\n        values: function( index, newValue ) {\n            var vals,\n                newValues,\n                i;\n\n            if ( arguments.length > 1 ) {\n                this.options.values[ index ] = this._trimAlignValue( newValue );\n                this._refreshValue();\n                this._change( null, index );\n                return;\n            }\n\n            if ( arguments.length ) {\n                if ( Array.isArray( arguments[ 0 ] ) ) {\n                    vals = this.options.values;\n                    newValues = arguments[ 0 ];\n                    for ( i = 0; i < vals.length; i += 1 ) {\n                        vals[ i ] = this._trimAlignValue( newValues[ i ] );\n                        this._change( null, i );\n                    }\n                    this._refreshValue();\n                } else {\n                    if ( this._hasMultipleValues() ) {\n                        return this._values( index );\n                    } else {\n                        return this.value();\n                    }\n                }\n            } else {\n                return this._values();\n            }\n        },\n\n        _setOption: function( key, value ) {\n            var i,\n                valsLength = 0;\n\n            if ( key === \"range\" && this.options.range === true ) {\n                if ( value === \"min\" ) {\n                    this.options.value = this._values( 0 );\n                    this.options.values = null;\n                } else if ( value === \"max\" ) {\n                    this.options.value = this._values( this.options.values.length - 1 );\n                    this.options.values = null;\n                }\n            }\n\n            if ( Array.isArray( this.options.values ) ) {\n                valsLength = this.options.values.length;\n            }\n\n            this._super( key, value );\n\n            switch ( key ) {\n                case \"orientation\":\n                    this._detectOrientation();\n                    this._removeClass( \"ui-slider-horizontal ui-slider-vertical\" )\n                        ._addClass( \"ui-slider-\" + this.orientation );\n                    this._refreshValue();\n                    if ( this.options.range ) {\n                        this._refreshRange( value );\n                    }\n\n                    // Reset positioning from previous orientation\n                    this.handles.css( value === \"horizontal\" ? \"bottom\" : \"left\", \"\" );\n                    break;\n                case \"value\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    this._change( null, 0 );\n                    this._animateOff = false;\n                    break;\n                case \"values\":\n                    this._animateOff = true;\n                    this._refreshValue();\n\n                    // Start from the last handle to prevent unreachable handles (#9046)\n                    for ( i = valsLength - 1; i >= 0; i-- ) {\n                        this._change( null, i );\n                    }\n                    this._animateOff = false;\n                    break;\n                case \"step\":\n                case \"min\":\n                case \"max\":\n                    this._animateOff = true;\n                    this._calculateNewMax();\n                    this._refreshValue();\n                    this._animateOff = false;\n                    break;\n                case \"range\":\n                    this._animateOff = true;\n                    this._refresh();\n                    this._animateOff = false;\n                    break;\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this._toggleClass( null, \"ui-state-disabled\", !!value );\n        },\n\n        //internal value getter\n        // _value() returns value trimmed by min and max, aligned by step\n        _value: function() {\n            var val = this.options.value;\n            val = this._trimAlignValue( val );\n\n            return val;\n        },\n\n        //internal values getter\n        // _values() returns array of values trimmed by min and max, aligned by step\n        // _values( index ) returns single value trimmed by min and max, aligned by step\n        _values: function( index ) {\n            var val,\n                vals,\n                i;\n\n            if ( arguments.length ) {\n                val = this.options.values[ index ];\n                val = this._trimAlignValue( val );\n\n                return val;\n            } else if ( this._hasMultipleValues() ) {\n\n                // .slice() creates a copy of the array\n                // this copy gets trimmed by min and max and then returned\n                vals = this.options.values.slice();\n                for ( i = 0; i < vals.length; i += 1 ) {\n                    vals[ i ] = this._trimAlignValue( vals[ i ] );\n                }\n\n                return vals;\n            } else {\n                return [];\n            }\n        },\n\n        // Returns the step-aligned value that val is closest to, between (inclusive) min and max\n        _trimAlignValue: function( val ) {\n            if ( val <= this._valueMin() ) {\n                return this._valueMin();\n            }\n            if ( val >= this._valueMax() ) {\n                return this._valueMax();\n            }\n            var step = ( this.options.step > 0 ) ? this.options.step : 1,\n                valModStep = ( val - this._valueMin() ) % step,\n                alignValue = val - valModStep;\n\n            if ( Math.abs( valModStep ) * 2 >= step ) {\n                alignValue += ( valModStep > 0 ) ? step : ( -step );\n            }\n\n            // Since JavaScript has problems with large floats, round\n            // the final value to 5 digits after the decimal point (see #4124)\n            return parseFloat( alignValue.toFixed( 5 ) );\n        },\n\n        _calculateNewMax: function() {\n            var max = this.options.max,\n                min = this._valueMin(),\n                step = this.options.step,\n                aboveMin = Math.round( ( max - min ) / step ) * step;\n            max = aboveMin + min;\n            if ( max > this.options.max ) {\n\n                //If max is not divisible by step, rounding off may increase its value\n                max -= step;\n            }\n            this.max = parseFloat( max.toFixed( this._precision() ) );\n        },\n\n        _precision: function() {\n            var precision = this._precisionOf( this.options.step );\n            if ( this.options.min !== null ) {\n                precision = Math.max( precision, this._precisionOf( this.options.min ) );\n            }\n            return precision;\n        },\n\n        _precisionOf: function( num ) {\n            var str = num.toString(),\n                decimal = str.indexOf( \".\" );\n            return decimal === -1 ? 0 : str.length - decimal - 1;\n        },\n\n        _valueMin: function() {\n            return this.options.min;\n        },\n\n        _valueMax: function() {\n            return this.max;\n        },\n\n        _refreshRange: function( orientation ) {\n            if ( orientation === \"vertical\" ) {\n                this.range.css( { \"width\": \"\", \"left\": \"\" } );\n            }\n            if ( orientation === \"horizontal\" ) {\n                this.range.css( { \"height\": \"\", \"bottom\": \"\" } );\n            }\n        },\n\n        _refreshValue: function() {\n            var lastValPercent, valPercent, value, valueMin, valueMax,\n                oRange = this.options.range,\n                o = this.options,\n                that = this,\n                animate = ( !this._animateOff ) ? o.animate : false,\n                _set = {};\n\n            if ( this._hasMultipleValues() ) {\n                this.handles.each( function( i ) {\n                    valPercent = ( that.values( i ) - that._valueMin() ) / ( that._valueMax() -\n                        that._valueMin() ) * 100;\n                    _set[ that.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n                    $( this ).stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n                    if ( that.options.range === true ) {\n                        if ( that.orientation === \"horizontal\" ) {\n                            if ( i === 0 ) {\n                                that.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                                    left: valPercent + \"%\"\n                                }, o.animate );\n                            }\n                            if ( i === 1 ) {\n                                that.range[ animate ? \"animate\" : \"css\" ]( {\n                                    width: ( valPercent - lastValPercent ) + \"%\"\n                                }, {\n                                    queue: false,\n                                    duration: o.animate\n                                } );\n                            }\n                        } else {\n                            if ( i === 0 ) {\n                                that.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                                    bottom: ( valPercent ) + \"%\"\n                                }, o.animate );\n                            }\n                            if ( i === 1 ) {\n                                that.range[ animate ? \"animate\" : \"css\" ]( {\n                                    height: ( valPercent - lastValPercent ) + \"%\"\n                                }, {\n                                    queue: false,\n                                    duration: o.animate\n                                } );\n                            }\n                        }\n                    }\n                    lastValPercent = valPercent;\n                } );\n            } else {\n                value = this.value();\n                valueMin = this._valueMin();\n                valueMax = this._valueMax();\n                valPercent = ( valueMax !== valueMin ) ?\n                    ( value - valueMin ) / ( valueMax - valueMin ) * 100 :\n                    0;\n                _set[ this.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n                this.handle.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n\n                if ( oRange === \"min\" && this.orientation === \"horizontal\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        width: valPercent + \"%\"\n                    }, o.animate );\n                }\n                if ( oRange === \"max\" && this.orientation === \"horizontal\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        width: ( 100 - valPercent ) + \"%\"\n                    }, o.animate );\n                }\n                if ( oRange === \"min\" && this.orientation === \"vertical\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        height: valPercent + \"%\"\n                    }, o.animate );\n                }\n                if ( oRange === \"max\" && this.orientation === \"vertical\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        height: ( 100 - valPercent ) + \"%\"\n                    }, o.animate );\n                }\n            }\n        },\n\n        _handleEvents: {\n            keydown: function( event ) {\n                var allowed, curVal, newVal, step,\n                    index = $( event.target ).data( \"ui-slider-handle-index\" );\n\n                switch ( event.keyCode ) {\n                    case $.ui.keyCode.HOME:\n                    case $.ui.keyCode.END:\n                    case $.ui.keyCode.PAGE_UP:\n                    case $.ui.keyCode.PAGE_DOWN:\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        event.preventDefault();\n                        if ( !this._keySliding ) {\n                            this._keySliding = true;\n                            this._addClass( $( event.target ), null, \"ui-state-active\" );\n                            allowed = this._start( event, index );\n                            if ( allowed === false ) {\n                                return;\n                            }\n                        }\n                        break;\n                }\n\n                step = this.options.step;\n                if ( this._hasMultipleValues() ) {\n                    curVal = newVal = this.values( index );\n                } else {\n                    curVal = newVal = this.value();\n                }\n\n                switch ( event.keyCode ) {\n                    case $.ui.keyCode.HOME:\n                        newVal = this._valueMin();\n                        break;\n                    case $.ui.keyCode.END:\n                        newVal = this._valueMax();\n                        break;\n                    case $.ui.keyCode.PAGE_UP:\n                        newVal = this._trimAlignValue(\n                            curVal + ( ( this._valueMax() - this._valueMin() ) / this.numPages )\n                        );\n                        break;\n                    case $.ui.keyCode.PAGE_DOWN:\n                        newVal = this._trimAlignValue(\n                            curVal - ( ( this._valueMax() - this._valueMin() ) / this.numPages ) );\n                        break;\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                        if ( curVal === this._valueMax() ) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue( curVal + step );\n                        break;\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        if ( curVal === this._valueMin() ) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue( curVal - step );\n                        break;\n                }\n\n                this._slide( event, index, newVal );\n            },\n            keyup: function( event ) {\n                var index = $( event.target ).data( \"ui-slider-handle-index\" );\n\n                if ( this._keySliding ) {\n                    this._keySliding = false;\n                    this._stop( event, index );\n                    this._change( event, index );\n                    this._removeClass( $( event.target ), null, \"ui-state-active\" );\n                }\n            }\n        }\n    } );\n\n} );\n","jquery/ui-modules/widgets/mouse.js":"/*!\n * jQuery UI Mouse 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Mouse\n//>>group: Widgets\n//>>description: Abstracts mouse-based interactions to assist in creating certain widgets.\n//>>docs: http://api.jqueryui.com/mouse/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../ie\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var mouseHandled = false;\n    $( document ).on( \"mouseup\", function() {\n        mouseHandled = false;\n    } );\n\n    return $.widget( \"ui.mouse\", {\n        version: \"1.13.2\",\n        options: {\n            cancel: \"input, textarea, button, select, option\",\n            distance: 1,\n            delay: 0\n        },\n        _mouseInit: function() {\n            var that = this;\n\n            this.element\n                .on( \"mousedown.\" + this.widgetName, function( event ) {\n                    return that._mouseDown( event );\n                } )\n                .on( \"click.\" + this.widgetName, function( event ) {\n                    if ( true === $.data( event.target, that.widgetName + \".preventClickEvent\" ) ) {\n                        $.removeData( event.target, that.widgetName + \".preventClickEvent\" );\n                        event.stopImmediatePropagation();\n                        return false;\n                    }\n                } );\n\n            this.started = false;\n        },\n\n        // TODO: make sure destroying one instance of mouse doesn't mess with\n        // other instances of mouse\n        _mouseDestroy: function() {\n            this.element.off( \".\" + this.widgetName );\n            if ( this._mouseMoveDelegate ) {\n                this.document\n                    .off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                    .off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n            }\n        },\n\n        _mouseDown: function( event ) {\n\n            // don't let more than one widget handle mouseStart\n            if ( mouseHandled ) {\n                return;\n            }\n\n            this._mouseMoved = false;\n\n            // We may have missed mouseup (out of window)\n            if ( this._mouseStarted ) {\n                this._mouseUp( event );\n            }\n\n            this._mouseDownEvent = event;\n\n            var that = this,\n                btnIsLeft = ( event.which === 1 ),\n\n                // event.target.nodeName works around a bug in IE 8 with\n                // disabled inputs (#7620)\n                elIsCancel = ( typeof this.options.cancel === \"string\" && event.target.nodeName ?\n                    $( event.target ).closest( this.options.cancel ).length : false );\n            if ( !btnIsLeft || elIsCancel || !this._mouseCapture( event ) ) {\n                return true;\n            }\n\n            this.mouseDelayMet = !this.options.delay;\n            if ( !this.mouseDelayMet ) {\n                this._mouseDelayTimer = setTimeout( function() {\n                    that.mouseDelayMet = true;\n                }, this.options.delay );\n            }\n\n            if ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n                this._mouseStarted = ( this._mouseStart( event ) !== false );\n                if ( !this._mouseStarted ) {\n                    event.preventDefault();\n                    return true;\n                }\n            }\n\n            // Click event may never have fired (Gecko & Opera)\n            if ( true === $.data( event.target, this.widgetName + \".preventClickEvent\" ) ) {\n                $.removeData( event.target, this.widgetName + \".preventClickEvent\" );\n            }\n\n            // These delegates are required to keep context\n            this._mouseMoveDelegate = function( event ) {\n                return that._mouseMove( event );\n            };\n            this._mouseUpDelegate = function( event ) {\n                return that._mouseUp( event );\n            };\n\n            this.document\n                .on( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                .on( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n            event.preventDefault();\n\n            mouseHandled = true;\n            return true;\n        },\n\n        _mouseMove: function( event ) {\n\n            // Only check for mouseups outside the document if you've moved inside the document\n            // at least once. This prevents the firing of mouseup in the case of IE<9, which will\n            // fire a mousemove event if content is placed under the cursor. See #7778\n            // Support: IE <9\n            if ( this._mouseMoved ) {\n\n                // IE mouseup check - mouseup happened when mouse was out of window\n                if ( $.ui.ie && ( !document.documentMode || document.documentMode < 9 ) &&\n                    !event.button ) {\n                    return this._mouseUp( event );\n\n                    // Iframe mouseup check - mouseup occurred in another document\n                } else if ( !event.which ) {\n\n                    // Support: Safari <=8 - 9\n                    // Safari sets which to 0 if you press any of the following keys\n                    // during a drag (#14461)\n                    if ( event.originalEvent.altKey || event.originalEvent.ctrlKey ||\n                        event.originalEvent.metaKey || event.originalEvent.shiftKey ) {\n                        this.ignoreMissingWhich = true;\n                    } else if ( !this.ignoreMissingWhich ) {\n                        return this._mouseUp( event );\n                    }\n                }\n            }\n\n            if ( event.which || event.button ) {\n                this._mouseMoved = true;\n            }\n\n            if ( this._mouseStarted ) {\n                this._mouseDrag( event );\n                return event.preventDefault();\n            }\n\n            if ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n                this._mouseStarted =\n                    ( this._mouseStart( this._mouseDownEvent, event ) !== false );\n                if ( this._mouseStarted ) {\n                    this._mouseDrag( event );\n                } else {\n                    this._mouseUp( event );\n                }\n            }\n\n            return !this._mouseStarted;\n        },\n\n        _mouseUp: function( event ) {\n            this.document\n                .off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                .off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n            if ( this._mouseStarted ) {\n                this._mouseStarted = false;\n\n                if ( event.target === this._mouseDownEvent.target ) {\n                    $.data( event.target, this.widgetName + \".preventClickEvent\", true );\n                }\n\n                this._mouseStop( event );\n            }\n\n            if ( this._mouseDelayTimer ) {\n                clearTimeout( this._mouseDelayTimer );\n                delete this._mouseDelayTimer;\n            }\n\n            this.ignoreMissingWhich = false;\n            mouseHandled = false;\n            event.preventDefault();\n        },\n\n        _mouseDistanceMet: function( event ) {\n            return ( Math.max(\n                    Math.abs( this._mouseDownEvent.pageX - event.pageX ),\n                    Math.abs( this._mouseDownEvent.pageY - event.pageY )\n                ) >= this.options.distance\n            );\n        },\n\n        _mouseDelayMet: function( /* event */ ) {\n            return this.mouseDelayMet;\n        },\n\n        // These are placeholder methods, to be overriden by extending plugin\n        _mouseStart: function( /* event */ ) {},\n        _mouseDrag: function( /* event */ ) {},\n        _mouseStop: function( /* event */ ) {},\n        _mouseCapture: function( /* event */ ) {\n            return true;\n        }\n    } );\n\n} );\n","jquery/ui-modules/widgets/datepicker.js":"/* eslint-disable max-len, camelcase */\n/*!\n * jQuery UI Datepicker 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Datepicker\n//>>group: Widgets\n//>>description: Displays a calendar from an input or inline for selecting dates.\n//>>docs: http://api.jqueryui.com/datepicker/\n//>>demos: http://jqueryui.com/datepicker/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/datepicker.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../keycode\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.extend( $.ui, { datepicker: { version: \"1.13.2\" } } );\n\n    var datepicker_instActive;\n\n    function datepicker_getZindex( elem ) {\n        var position, value;\n        while ( elem.length && elem[ 0 ] !== document ) {\n\n            // Ignore z-index if position is set to a value where z-index is ignored by the browser\n            // This makes behavior of this function consistent across browsers\n            // WebKit always returns auto if the element is positioned\n            position = elem.css( \"position\" );\n            if ( position === \"absolute\" || position === \"relative\" || position === \"fixed\" ) {\n\n                // IE returns 0 when zIndex is not specified\n                // other browsers return a string\n                // we ignore the case of nested elements with an explicit value of 0\n                // <div style=\"z-index: -10;\"><div style=\"z-index: 0;\"></div></div>\n                value = parseInt( elem.css( \"zIndex\" ), 10 );\n                if ( !isNaN( value ) && value !== 0 ) {\n                    return value;\n                }\n            }\n            elem = elem.parent();\n        }\n\n        return 0;\n    }\n\n    /* Date picker manager.\n       Use the singleton instance of this class, $.datepicker, to interact with the date picker.\n       Settings for (groups of) date pickers are maintained in an instance object,\n       allowing multiple different settings on the same page. */\n\n    function Datepicker() {\n        this._curInst = null; // The current instance in use\n        this._keyEvent = false; // If the last event was a key event\n        this._disabledInputs = []; // List of date picker inputs that have been disabled\n        this._datepickerShowing = false; // True if the popup picker is showing , false if not\n        this._inDialog = false; // True if showing within a \"dialog\", false if not\n        this._mainDivId = \"ui-datepicker-div\"; // The ID of the main datepicker division\n        this._inlineClass = \"ui-datepicker-inline\"; // The name of the inline marker class\n        this._appendClass = \"ui-datepicker-append\"; // The name of the append marker class\n        this._triggerClass = \"ui-datepicker-trigger\"; // The name of the trigger marker class\n        this._dialogClass = \"ui-datepicker-dialog\"; // The name of the dialog marker class\n        this._disableClass = \"ui-datepicker-disabled\"; // The name of the disabled covering marker class\n        this._unselectableClass = \"ui-datepicker-unselectable\"; // The name of the unselectable cell marker class\n        this._currentClass = \"ui-datepicker-current-day\"; // The name of the current day marker class\n        this._dayOverClass = \"ui-datepicker-days-cell-over\"; // The name of the day hover marker class\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[ \"\" ] = { // Default regional settings\n            closeText: \"Done\", // Display text for close link\n            prevText: \"Prev\", // Display text for previous month link\n            nextText: \"Next\", // Display text for next month link\n            currentText: \"Today\", // Display text for current month link\n            monthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n                \"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ], // Names of months for drop-down and formatting\n            monthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\", \"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ], // For formatting\n            dayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ], // For formatting\n            dayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ], // For formatting\n            dayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ], // Column headings for days starting at Sunday\n            weekHeader: \"Wk\", // Column header for week of the year\n            dateFormat: \"mm/dd/yy\", // See format options on parseDate\n            firstDay: 0, // The first day of the week, Sun = 0, Mon = 1, ...\n            isRTL: false, // True if right-to-left language, false if left-to-right\n            showMonthAfterYear: false, // True if the year select precedes month, false for month then year\n            yearSuffix: \"\", // Additional text to append to the year in the month headers,\n            selectMonthLabel: \"Select month\", // Invisible label for month selector\n            selectYearLabel: \"Select year\" // Invisible label for year selector\n        };\n        this._defaults = { // Global defaults for all the date picker instances\n            showOn: \"focus\", // \"focus\" for popup on focus,\n            // \"button\" for trigger button, or \"both\" for either\n            showAnim: \"fadeIn\", // Name of jQuery animation for popup\n            showOptions: {}, // Options for enhanced animations\n            defaultDate: null, // Used when field is blank: actual date,\n            // +/-number for offset from today, null for today\n            appendText: \"\", // Display text following the input box, e.g. showing the format\n            buttonText: \"...\", // Text for trigger button\n            buttonImage: \"\", // URL for trigger button image\n            buttonImageOnly: false, // True if the image appears alone, false if it appears on a button\n            hideIfNoPrevNext: false, // True to hide next/previous month links\n            // if not applicable, false to just disable them\n            navigationAsDateFormat: false, // True if date formatting applied to prev/today/next links\n            gotoCurrent: false, // True if today link goes back to current selection instead\n            changeMonth: false, // True if month can be selected directly, false if only prev/next\n            changeYear: false, // True if year can be selected directly, false if only prev/next\n            yearRange: \"c-10:c+10\", // Range of years to display in drop-down,\n            // either relative to today's year (-nn:+nn), relative to currently displayed year\n            // (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)\n            showOtherMonths: false, // True to show dates in other months, false to leave blank\n            selectOtherMonths: false, // True to allow selection of dates in other months, false for unselectable\n            showWeek: false, // True to show week of the year, false to not show it\n            calculateWeek: this.iso8601Week, // How to calculate the week of the year,\n            // takes a Date and returns the number of the week for it\n            shortYearCutoff: \"+10\", // Short year values < this are in the current century,\n            // > this are in the previous century,\n            // string value starting with \"+\" for current year + value\n            minDate: null, // The earliest selectable date, or null for no limit\n            maxDate: null, // The latest selectable date, or null for no limit\n            duration: \"fast\", // Duration of display/closure\n            beforeShowDay: null, // Function that takes a date and returns an array with\n            // [0] = true if selectable, false if not, [1] = custom CSS class name(s) or \"\",\n            // [2] = cell title (optional), e.g. $.datepicker.noWeekends\n            beforeShow: null, // Function that takes an input field and\n            // returns a set of custom settings for the date picker\n            onSelect: null, // Define a callback function when a date is selected\n            onChangeMonthYear: null, // Define a callback function when the month or year is changed\n            onClose: null, // Define a callback function when the datepicker is closed\n            onUpdateDatepicker: null, // Define a callback function when the datepicker is updated\n            numberOfMonths: 1, // Number of months to show at a time\n            showCurrentAtPos: 0, // The position in multipe months at which to show the current month (starting at 0)\n            stepMonths: 1, // Number of months to step back/forward\n            stepBigMonths: 12, // Number of months to step back/forward for the big links\n            altField: \"\", // Selector for an alternate field to store selected dates into\n            altFormat: \"\", // The date format to use for the alternate field\n            constrainInput: true, // The input is constrained by the current date format\n            showButtonPanel: false, // True to show button panel, false to not show it\n            autoSize: false, // True to size the input for the date format, false to leave as is\n            disabled: false // The initial disabled state\n        };\n        $.extend( this._defaults, this.regional[ \"\" ] );\n        this.regional.en = $.extend( true, {}, this.regional[ \"\" ] );\n        this.regional[ \"en-US\" ] = $.extend( true, {}, this.regional.en );\n        this.dpDiv = datepicker_bindHover( $( \"<div id='\" + this._mainDivId + \"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\" ) );\n    }\n\n    $.extend( Datepicker.prototype, {\n\n        /* Class name added to elements to indicate already configured with a date picker. */\n        markerClassName: \"hasDatepicker\",\n\n        //Keep track of the maximum number of rows displayed (see #7043)\n        maxRows: 4,\n\n        // TODO rename to \"widget\" when switching to widget factory\n        _widgetDatepicker: function() {\n            return this.dpDiv;\n        },\n\n        /* Override the default settings for all instances of the date picker.\n         * @param  settings  object - the new settings to use as defaults (anonymous object)\n         * @return the manager object\n         */\n        setDefaults: function( settings ) {\n            datepicker_extendRemove( this._defaults, settings || {} );\n            return this;\n        },\n\n        /* Attach the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         * @param  settings  object - the new settings to use for this date picker instance (anonymous)\n         */\n        _attachDatepicker: function( target, settings ) {\n            var nodeName, inline, inst;\n            nodeName = target.nodeName.toLowerCase();\n            inline = ( nodeName === \"div\" || nodeName === \"span\" );\n            if ( !target.id ) {\n                this.uuid += 1;\n                target.id = \"dp\" + this.uuid;\n            }\n            inst = this._newInst( $( target ), inline );\n            inst.settings = $.extend( {}, settings || {} );\n            if ( nodeName === \"input\" ) {\n                this._connectDatepicker( target, inst );\n            } else if ( inline ) {\n                this._inlineDatepicker( target, inst );\n            }\n        },\n\n        /* Create a new instance object. */\n        _newInst: function( target, inline ) {\n            var id = target[ 0 ].id.replace( /([^A-Za-z0-9_\\-])/g, \"\\\\\\\\$1\" ); // escape jQuery meta chars\n            return { id: id, input: target, // associated target\n                selectedDay: 0, selectedMonth: 0, selectedYear: 0, // current selection\n                drawMonth: 0, drawYear: 0, // month being drawn\n                inline: inline, // is datepicker inline or not\n                dpDiv: ( !inline ? this.dpDiv : // presentation div\n                    datepicker_bindHover( $( \"<div class='\" + this._inlineClass + \" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\" ) ) ) };\n        },\n\n        /* Attach the date picker to an input field. */\n        _connectDatepicker: function( target, inst ) {\n            var input = $( target );\n            inst.append = $( [] );\n            inst.trigger = $( [] );\n            if ( input.hasClass( this.markerClassName ) ) {\n                return;\n            }\n            this._attachments( input, inst );\n            input.addClass( this.markerClassName ).on( \"keydown\", this._doKeyDown ).\n            on( \"keypress\", this._doKeyPress ).on( \"keyup\", this._doKeyUp );\n            this._autoSize( inst );\n            $.data( target, \"datepicker\", inst );\n\n            //If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)\n            if ( inst.settings.disabled ) {\n                this._disableDatepicker( target );\n            }\n        },\n\n        /* Make attachments based on settings. */\n        _attachments: function( input, inst ) {\n            var showOn, buttonText, buttonImage,\n                appendText = this._get( inst, \"appendText\" ),\n                isRTL = this._get( inst, \"isRTL\" );\n\n            if ( inst.append ) {\n                inst.append.remove();\n            }\n            if ( appendText ) {\n                inst.append = $( \"<span>\" )\n                    .addClass( this._appendClass )\n                    .text( appendText );\n                input[ isRTL ? \"before\" : \"after\" ]( inst.append );\n            }\n\n            input.off( \"focus\", this._showDatepicker );\n\n            if ( inst.trigger ) {\n                inst.trigger.remove();\n            }\n\n            showOn = this._get( inst, \"showOn\" );\n            if ( showOn === \"focus\" || showOn === \"both\" ) { // pop-up date picker when in the marked field\n                input.on( \"focus\", this._showDatepicker );\n            }\n            if ( showOn === \"button\" || showOn === \"both\" ) { // pop-up date picker when button clicked\n                buttonText = this._get( inst, \"buttonText\" );\n                buttonImage = this._get( inst, \"buttonImage\" );\n\n                if ( this._get( inst, \"buttonImageOnly\" ) ) {\n                    inst.trigger = $( \"<img>\" )\n                        .addClass( this._triggerClass )\n                        .attr( {\n                            src: buttonImage,\n                            alt: buttonText,\n                            title: buttonText\n                        } );\n                } else {\n                    inst.trigger = $( \"<button type='button'>\" )\n                        .addClass( this._triggerClass );\n                    if ( buttonImage ) {\n                        inst.trigger.html(\n                            $( \"<img>\" )\n                                .attr( {\n                                    src: buttonImage,\n                                    alt: buttonText,\n                                    title: buttonText\n                                } )\n                        );\n                    } else {\n                        inst.trigger.text( buttonText );\n                    }\n                }\n\n                input[ isRTL ? \"before\" : \"after\" ]( inst.trigger );\n                inst.trigger.on( \"click\", function() {\n                    if ( $.datepicker._datepickerShowing && $.datepicker._lastInput === input[ 0 ] ) {\n                        $.datepicker._hideDatepicker();\n                    } else if ( $.datepicker._datepickerShowing && $.datepicker._lastInput !== input[ 0 ] ) {\n                        $.datepicker._hideDatepicker();\n                        $.datepicker._showDatepicker( input[ 0 ] );\n                    } else {\n                        $.datepicker._showDatepicker( input[ 0 ] );\n                    }\n                    return false;\n                } );\n            }\n        },\n\n        /* Apply the maximum length for the date format. */\n        _autoSize: function( inst ) {\n            if ( this._get( inst, \"autoSize\" ) && !inst.inline ) {\n                var findMax, max, maxI, i,\n                    date = new Date( 2009, 12 - 1, 20 ), // Ensure double digits\n                    dateFormat = this._get( inst, \"dateFormat\" );\n\n                if ( dateFormat.match( /[DM]/ ) ) {\n                    findMax = function( names ) {\n                        max = 0;\n                        maxI = 0;\n                        for ( i = 0; i < names.length; i++ ) {\n                            if ( names[ i ].length > max ) {\n                                max = names[ i ].length;\n                                maxI = i;\n                            }\n                        }\n                        return maxI;\n                    };\n                    date.setMonth( findMax( this._get( inst, ( dateFormat.match( /MM/ ) ?\n                        \"monthNames\" : \"monthNamesShort\" ) ) ) );\n                    date.setDate( findMax( this._get( inst, ( dateFormat.match( /DD/ ) ?\n                        \"dayNames\" : \"dayNamesShort\" ) ) ) + 20 - date.getDay() );\n                }\n                inst.input.attr( \"size\", this._formatDate( inst, date ).length );\n            }\n        },\n\n        /* Attach an inline date picker to a div. */\n        _inlineDatepicker: function( target, inst ) {\n            var divSpan = $( target );\n            if ( divSpan.hasClass( this.markerClassName ) ) {\n                return;\n            }\n            divSpan.addClass( this.markerClassName ).append( inst.dpDiv );\n            $.data( target, \"datepicker\", inst );\n            this._setDate( inst, this._getDefaultDate( inst ), true );\n            this._updateDatepicker( inst );\n            this._updateAlternate( inst );\n\n            //If disabled option is true, disable the datepicker before showing it (see ticket #5665)\n            if ( inst.settings.disabled ) {\n                this._disableDatepicker( target );\n            }\n\n            // Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements\n            // http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height\n            inst.dpDiv.css( \"display\", \"block\" );\n        },\n\n        /* Pop-up the date picker in a \"dialog\" box.\n         * @param  input element - ignored\n         * @param  date\tstring or Date - the initial date to display\n         * @param  onSelect  function - the function to call when a date is selected\n         * @param  settings  object - update the dialog date picker instance's settings (anonymous object)\n         * @param  pos int[2] - coordinates for the dialog's position within the screen or\n         *\t\t\t\t\tevent - with x/y coordinates or\n         *\t\t\t\t\tleave empty for default (screen centre)\n         * @return the manager object\n         */\n        _dialogDatepicker: function( input, date, onSelect, settings, pos ) {\n            var id, browserWidth, browserHeight, scrollX, scrollY,\n                inst = this._dialogInst; // internal instance\n\n            if ( !inst ) {\n                this.uuid += 1;\n                id = \"dp\" + this.uuid;\n                this._dialogInput = $( \"<input type='text' id='\" + id +\n                    \"' style='position: absolute; top: -100px; width: 0px;'/>\" );\n                this._dialogInput.on( \"keydown\", this._doKeyDown );\n                $( \"body\" ).append( this._dialogInput );\n                inst = this._dialogInst = this._newInst( this._dialogInput, false );\n                inst.settings = {};\n                $.data( this._dialogInput[ 0 ], \"datepicker\", inst );\n            }\n            datepicker_extendRemove( inst.settings, settings || {} );\n            date = ( date && date.constructor === Date ? this._formatDate( inst, date ) : date );\n            this._dialogInput.val( date );\n\n            this._pos = ( pos ? ( pos.length ? pos : [ pos.pageX, pos.pageY ] ) : null );\n            if ( !this._pos ) {\n                browserWidth = document.documentElement.clientWidth;\n                browserHeight = document.documentElement.clientHeight;\n                scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;\n                scrollY = document.documentElement.scrollTop || document.body.scrollTop;\n                this._pos = // should use actual width/height below\n                    [ ( browserWidth / 2 ) - 100 + scrollX, ( browserHeight / 2 ) - 150 + scrollY ];\n            }\n\n            // Move input on screen for focus, but hidden behind dialog\n            this._dialogInput.css( \"left\", ( this._pos[ 0 ] + 20 ) + \"px\" ).css( \"top\", this._pos[ 1 ] + \"px\" );\n            inst.settings.onSelect = onSelect;\n            this._inDialog = true;\n            this.dpDiv.addClass( this._dialogClass );\n            this._showDatepicker( this._dialogInput[ 0 ] );\n            if ( $.blockUI ) {\n                $.blockUI( this.dpDiv );\n            }\n            $.data( this._dialogInput[ 0 ], \"datepicker\", inst );\n            return this;\n        },\n\n        /* Detach a datepicker from its control.\n         * @param  target\telement - the target input field or division or span\n         */\n        _destroyDatepicker: function( target ) {\n            var nodeName,\n                $target = $( target ),\n                inst = $.data( target, \"datepicker\" );\n\n            if ( !$target.hasClass( this.markerClassName ) ) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            $.removeData( target, \"datepicker\" );\n            if ( nodeName === \"input\" ) {\n                inst.append.remove();\n                inst.trigger.remove();\n                $target.removeClass( this.markerClassName ).\n                off( \"focus\", this._showDatepicker ).\n                off( \"keydown\", this._doKeyDown ).\n                off( \"keypress\", this._doKeyPress ).\n                off( \"keyup\", this._doKeyUp );\n            } else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n                $target.removeClass( this.markerClassName ).empty();\n            }\n\n            if ( datepicker_instActive === inst ) {\n                datepicker_instActive = null;\n                this._curInst = null;\n            }\n        },\n\n        /* Enable the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         */\n        _enableDatepicker: function( target ) {\n            var nodeName, inline,\n                $target = $( target ),\n                inst = $.data( target, \"datepicker\" );\n\n            if ( !$target.hasClass( this.markerClassName ) ) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            if ( nodeName === \"input\" ) {\n                target.disabled = false;\n                inst.trigger.filter( \"button\" ).\n                each( function() {\n                    this.disabled = false;\n                } ).end().\n                filter( \"img\" ).css( { opacity: \"1.0\", cursor: \"\" } );\n            } else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n                inline = $target.children( \".\" + this._inlineClass );\n                inline.children().removeClass( \"ui-state-disabled\" );\n                inline.find( \"select.ui-datepicker-month, select.ui-datepicker-year\" ).\n                prop( \"disabled\", false );\n            }\n            this._disabledInputs = $.map( this._disabledInputs,\n\n                // Delete entry\n                function( value ) {\n                    return ( value === target ? null : value );\n                } );\n        },\n\n        /* Disable the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         */\n        _disableDatepicker: function( target ) {\n            var nodeName, inline,\n                $target = $( target ),\n                inst = $.data( target, \"datepicker\" );\n\n            if ( !$target.hasClass( this.markerClassName ) ) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            if ( nodeName === \"input\" ) {\n                target.disabled = true;\n                inst.trigger.filter( \"button\" ).\n                each( function() {\n                    this.disabled = true;\n                } ).end().\n                filter( \"img\" ).css( { opacity: \"0.5\", cursor: \"default\" } );\n            } else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n                inline = $target.children( \".\" + this._inlineClass );\n                inline.children().addClass( \"ui-state-disabled\" );\n                inline.find( \"select.ui-datepicker-month, select.ui-datepicker-year\" ).\n                prop( \"disabled\", true );\n            }\n            this._disabledInputs = $.map( this._disabledInputs,\n\n                // Delete entry\n                function( value ) {\n                    return ( value === target ? null : value );\n                } );\n            this._disabledInputs[ this._disabledInputs.length ] = target;\n        },\n\n        /* Is the first field in a jQuery collection disabled as a datepicker?\n         * @param  target\telement - the target input field or division or span\n         * @return boolean - true if disabled, false if enabled\n         */\n        _isDisabledDatepicker: function( target ) {\n            if ( !target ) {\n                return false;\n            }\n            for ( var i = 0; i < this._disabledInputs.length; i++ ) {\n                if ( this._disabledInputs[ i ] === target ) {\n                    return true;\n                }\n            }\n            return false;\n        },\n\n        /* Retrieve the instance data for the target control.\n         * @param  target  element - the target input field or division or span\n         * @return  object - the associated instance data\n         * @throws  error if a jQuery problem getting data\n         */\n        _getInst: function( target ) {\n            try {\n                return $.data( target, \"datepicker\" );\n            } catch ( err ) {\n                throw \"Missing instance data for this datepicker\";\n            }\n        },\n\n        /* Update or retrieve the settings for a date picker attached to an input field or division.\n         * @param  target  element - the target input field or division or span\n         * @param  name\tobject - the new settings to update or\n         *\t\t\t\tstring - the name of the setting to change or retrieve,\n         *\t\t\t\twhen retrieving also \"all\" for all instance settings or\n         *\t\t\t\t\"defaults\" for all global defaults\n         * @param  value   any - the new value for the setting\n         *\t\t\t\t(omit if above is an object or to retrieve a value)\n         */\n        _optionDatepicker: function( target, name, value ) {\n            var settings, date, minDate, maxDate,\n                inst = this._getInst( target );\n\n            if ( arguments.length === 2 && typeof name === \"string\" ) {\n                return ( name === \"defaults\" ? $.extend( {}, $.datepicker._defaults ) :\n                    ( inst ? ( name === \"all\" ? $.extend( {}, inst.settings ) :\n                        this._get( inst, name ) ) : null ) );\n            }\n\n            settings = name || {};\n            if ( typeof name === \"string\" ) {\n                settings = {};\n                settings[ name ] = value;\n            }\n\n            if ( inst ) {\n                if ( this._curInst === inst ) {\n                    this._hideDatepicker();\n                }\n\n                date = this._getDateDatepicker( target, true );\n                minDate = this._getMinMaxDate( inst, \"min\" );\n                maxDate = this._getMinMaxDate( inst, \"max\" );\n                datepicker_extendRemove( inst.settings, settings );\n\n                // reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided\n                if ( minDate !== null && settings.dateFormat !== undefined && settings.minDate === undefined ) {\n                    inst.settings.minDate = this._formatDate( inst, minDate );\n                }\n                if ( maxDate !== null && settings.dateFormat !== undefined && settings.maxDate === undefined ) {\n                    inst.settings.maxDate = this._formatDate( inst, maxDate );\n                }\n                if ( \"disabled\" in settings ) {\n                    if ( settings.disabled ) {\n                        this._disableDatepicker( target );\n                    } else {\n                        this._enableDatepicker( target );\n                    }\n                }\n                this._attachments( $( target ), inst );\n                this._autoSize( inst );\n                this._setDate( inst, date );\n                this._updateAlternate( inst );\n                this._updateDatepicker( inst );\n            }\n        },\n\n        // Change method deprecated\n        _changeDatepicker: function( target, name, value ) {\n            this._optionDatepicker( target, name, value );\n        },\n\n        /* Redraw the date picker attached to an input field or division.\n         * @param  target  element - the target input field or division or span\n         */\n        _refreshDatepicker: function( target ) {\n            var inst = this._getInst( target );\n            if ( inst ) {\n                this._updateDatepicker( inst );\n            }\n        },\n\n        /* Set the dates for a jQuery selection.\n         * @param  target element - the target input field or division or span\n         * @param  date\tDate - the new date\n         */\n        _setDateDatepicker: function( target, date ) {\n            var inst = this._getInst( target );\n            if ( inst ) {\n                this._setDate( inst, date );\n                this._updateDatepicker( inst );\n                this._updateAlternate( inst );\n            }\n        },\n\n        /* Get the date(s) for the first entry in a jQuery selection.\n         * @param  target element - the target input field or division or span\n         * @param  noDefault boolean - true if no default date is to be used\n         * @return Date - the current date\n         */\n        _getDateDatepicker: function( target, noDefault ) {\n            var inst = this._getInst( target );\n            if ( inst && !inst.inline ) {\n                this._setDateFromField( inst, noDefault );\n            }\n            return ( inst ? this._getDate( inst ) : null );\n        },\n\n        /* Handle keystrokes. */\n        _doKeyDown: function( event ) {\n            var onSelect, dateStr, sel,\n                inst = $.datepicker._getInst( event.target ),\n                handled = true,\n                isRTL = inst.dpDiv.is( \".ui-datepicker-rtl\" );\n\n            inst._keyEvent = true;\n            if ( $.datepicker._datepickerShowing ) {\n                switch ( event.keyCode ) {\n                    case 9: $.datepicker._hideDatepicker();\n                        handled = false;\n                        break; // hide on tab out\n                    case 13: sel = $( \"td.\" + $.datepicker._dayOverClass + \":not(.\" +\n                        $.datepicker._currentClass + \")\", inst.dpDiv );\n                        if ( sel[ 0 ] ) {\n                            $.datepicker._selectDay( event.target, inst.selectedMonth, inst.selectedYear, sel[ 0 ] );\n                        }\n\n                        onSelect = $.datepicker._get( inst, \"onSelect\" );\n                        if ( onSelect ) {\n                            dateStr = $.datepicker._formatDate( inst );\n\n                            // Trigger custom callback\n                            onSelect.apply( ( inst.input ? inst.input[ 0 ] : null ), [ dateStr, inst ] );\n                        } else {\n                            $.datepicker._hideDatepicker();\n                        }\n\n                        return false; // don't submit the form\n                    case 27: $.datepicker._hideDatepicker();\n                        break; // hide on escape\n                    case 33: $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                        -$.datepicker._get( inst, \"stepBigMonths\" ) :\n                        -$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        break; // previous month/year on page up/+ ctrl\n                    case 34: $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                        +$.datepicker._get( inst, \"stepBigMonths\" ) :\n                        +$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        break; // next month/year on page down/+ ctrl\n                    case 35: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._clearDate( event.target );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // clear on ctrl or command +end\n                    case 36: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._gotoToday( event.target );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // current on ctrl or command +home\n                    case 37: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, ( isRTL ? +1 : -1 ), \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n\n                        // -1 day on ctrl or command +left\n                        if ( event.originalEvent.altKey ) {\n                            $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                                -$.datepicker._get( inst, \"stepBigMonths\" ) :\n                                -$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        }\n\n                        // next month/year on alt +left on Mac\n                        break;\n                    case 38: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, -7, \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // -1 week on ctrl or command +up\n                    case 39: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, ( isRTL ? -1 : +1 ), \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n\n                        // +1 day on ctrl or command +right\n                        if ( event.originalEvent.altKey ) {\n                            $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                                +$.datepicker._get( inst, \"stepBigMonths\" ) :\n                                +$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        }\n\n                        // next month/year on alt +right\n                        break;\n                    case 40: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, +7, \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // +1 week on ctrl or command +down\n                    default: handled = false;\n                }\n            } else if ( event.keyCode === 36 && event.ctrlKey ) { // display the date picker on ctrl+home\n                $.datepicker._showDatepicker( this );\n            } else {\n                handled = false;\n            }\n\n            if ( handled ) {\n                event.preventDefault();\n                event.stopPropagation();\n            }\n        },\n\n        /* Filter entered characters - based on date format. */\n        _doKeyPress: function( event ) {\n            var chars, chr,\n                inst = $.datepicker._getInst( event.target );\n\n            if ( $.datepicker._get( inst, \"constrainInput\" ) ) {\n                chars = $.datepicker._possibleChars( $.datepicker._get( inst, \"dateFormat\" ) );\n                chr = String.fromCharCode( event.charCode == null ? event.keyCode : event.charCode );\n                return event.ctrlKey || event.metaKey || ( chr < \" \" || !chars || chars.indexOf( chr ) > -1 );\n            }\n        },\n\n        /* Synchronise manual entry and field/alternate field. */\n        _doKeyUp: function( event ) {\n            var date,\n                inst = $.datepicker._getInst( event.target );\n\n            if ( inst.input.val() !== inst.lastVal ) {\n                try {\n                    date = $.datepicker.parseDate( $.datepicker._get( inst, \"dateFormat\" ),\n                        ( inst.input ? inst.input.val() : null ),\n                        $.datepicker._getFormatConfig( inst ) );\n\n                    if ( date ) { // only if valid\n                        $.datepicker._setDateFromField( inst );\n                        $.datepicker._updateAlternate( inst );\n                        $.datepicker._updateDatepicker( inst );\n                    }\n                } catch ( err ) {\n                }\n            }\n            return true;\n        },\n\n        /* Pop-up the date picker for a given input field.\n         * If false returned from beforeShow event handler do not show.\n         * @param  input  element - the input field attached to the date picker or\n         *\t\t\t\t\tevent - if triggered by focus\n         */\n        _showDatepicker: function( input ) {\n            input = input.target || input;\n            if ( input.nodeName.toLowerCase() !== \"input\" ) { // find from button/image trigger\n                input = $( \"input\", input.parentNode )[ 0 ];\n            }\n\n            if ( $.datepicker._isDisabledDatepicker( input ) || $.datepicker._lastInput === input ) { // already here\n                return;\n            }\n\n            var inst, beforeShow, beforeShowSettings, isFixed,\n                offset, showAnim, duration;\n\n            inst = $.datepicker._getInst( input );\n            if ( $.datepicker._curInst && $.datepicker._curInst !== inst ) {\n                $.datepicker._curInst.dpDiv.stop( true, true );\n                if ( inst && $.datepicker._datepickerShowing ) {\n                    $.datepicker._hideDatepicker( $.datepicker._curInst.input[ 0 ] );\n                }\n            }\n\n            beforeShow = $.datepicker._get( inst, \"beforeShow\" );\n            beforeShowSettings = beforeShow ? beforeShow.apply( input, [ input, inst ] ) : {};\n            if ( beforeShowSettings === false ) {\n                return;\n            }\n            datepicker_extendRemove( inst.settings, beforeShowSettings );\n\n            inst.lastVal = null;\n            $.datepicker._lastInput = input;\n            $.datepicker._setDateFromField( inst );\n\n            if ( $.datepicker._inDialog ) { // hide cursor\n                input.value = \"\";\n            }\n            if ( !$.datepicker._pos ) { // position below input\n                $.datepicker._pos = $.datepicker._findPos( input );\n                $.datepicker._pos[ 1 ] += input.offsetHeight; // add the height\n            }\n\n            isFixed = false;\n            $( input ).parents().each( function() {\n                isFixed |= $( this ).css( \"position\" ) === \"fixed\";\n                return !isFixed;\n            } );\n\n            offset = { left: $.datepicker._pos[ 0 ], top: $.datepicker._pos[ 1 ] };\n            $.datepicker._pos = null;\n\n            //to avoid flashes on Firefox\n            inst.dpDiv.empty();\n\n            // determine sizing offscreen\n            inst.dpDiv.css( { position: \"absolute\", display: \"block\", top: \"-1000px\" } );\n            $.datepicker._updateDatepicker( inst );\n\n            // fix width for dynamic number of date pickers\n            // and adjust position before showing\n            offset = $.datepicker._checkOffset( inst, offset, isFixed );\n            inst.dpDiv.css( { position: ( $.datepicker._inDialog && $.blockUI ?\n                    \"static\" : ( isFixed ? \"fixed\" : \"absolute\" ) ), display: \"none\",\n                left: offset.left + \"px\", top: offset.top + \"px\" } );\n\n            if ( !inst.inline ) {\n                showAnim = $.datepicker._get( inst, \"showAnim\" );\n                duration = $.datepicker._get( inst, \"duration\" );\n                inst.dpDiv.css( \"z-index\", datepicker_getZindex( $( input ) ) + 1 );\n                $.datepicker._datepickerShowing = true;\n\n                if ( $.effects && $.effects.effect[ showAnim ] ) {\n                    inst.dpDiv.show( showAnim, $.datepicker._get( inst, \"showOptions\" ), duration );\n                } else {\n                    inst.dpDiv[ showAnim || \"show\" ]( showAnim ? duration : null );\n                }\n\n                if ( $.datepicker._shouldFocusInput( inst ) ) {\n                    inst.input.trigger( \"focus\" );\n                }\n\n                $.datepicker._curInst = inst;\n            }\n        },\n\n        /* Generate the date picker content. */\n        _updateDatepicker: function( inst ) {\n            this.maxRows = 4; //Reset the max number of rows being displayed (see #7043)\n            datepicker_instActive = inst; // for delegate hover events\n            inst.dpDiv.empty().append( this._generateHTML( inst ) );\n            this._attachHandlers( inst );\n\n            var origyearshtml,\n                numMonths = this._getNumberOfMonths( inst ),\n                cols = numMonths[ 1 ],\n                width = 17,\n                activeCell = inst.dpDiv.find( \".\" + this._dayOverClass + \" a\" ),\n                onUpdateDatepicker = $.datepicker._get( inst, \"onUpdateDatepicker\" );\n\n            if ( activeCell.length > 0 ) {\n                datepicker_handleMouseover.apply( activeCell.get( 0 ) );\n            }\n\n            inst.dpDiv.removeClass( \"ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4\" ).width( \"\" );\n            if ( cols > 1 ) {\n                inst.dpDiv.addClass( \"ui-datepicker-multi-\" + cols ).css( \"width\", ( width * cols ) + \"em\" );\n            }\n            inst.dpDiv[ ( numMonths[ 0 ] !== 1 || numMonths[ 1 ] !== 1 ? \"add\" : \"remove\" ) +\n            \"Class\" ]( \"ui-datepicker-multi\" );\n            inst.dpDiv[ ( this._get( inst, \"isRTL\" ) ? \"add\" : \"remove\" ) +\n            \"Class\" ]( \"ui-datepicker-rtl\" );\n\n            if ( inst === $.datepicker._curInst && $.datepicker._datepickerShowing && $.datepicker._shouldFocusInput( inst ) ) {\n                inst.input.trigger( \"focus\" );\n            }\n\n            // Deffered render of the years select (to avoid flashes on Firefox)\n            if ( inst.yearshtml ) {\n                origyearshtml = inst.yearshtml;\n                setTimeout( function() {\n\n                    //assure that inst.yearshtml didn't change.\n                    if ( origyearshtml === inst.yearshtml && inst.yearshtml ) {\n                        inst.dpDiv.find( \"select.ui-datepicker-year\" ).first().replaceWith( inst.yearshtml );\n                    }\n                    origyearshtml = inst.yearshtml = null;\n                }, 0 );\n            }\n\n            if ( onUpdateDatepicker ) {\n                onUpdateDatepicker.apply( ( inst.input ? inst.input[ 0 ] : null ), [ inst ] );\n            }\n        },\n\n        // #6694 - don't focus the input if it's already focused\n        // this breaks the change event in IE\n        // Support: IE and jQuery <1.9\n        _shouldFocusInput: function( inst ) {\n            return inst.input && inst.input.is( \":visible\" ) && !inst.input.is( \":disabled\" ) && !inst.input.is( \":focus\" );\n        },\n\n        /* Check positioning to remain on screen. */\n        _checkOffset: function( inst, offset, isFixed ) {\n            var dpWidth = inst.dpDiv.outerWidth(),\n                dpHeight = inst.dpDiv.outerHeight(),\n                inputWidth = inst.input ? inst.input.outerWidth() : 0,\n                inputHeight = inst.input ? inst.input.outerHeight() : 0,\n                viewWidth = document.documentElement.clientWidth + ( isFixed ? 0 : $( document ).scrollLeft() ),\n                viewHeight = document.documentElement.clientHeight + ( isFixed ? 0 : $( document ).scrollTop() );\n\n            offset.left -= ( this._get( inst, \"isRTL\" ) ? ( dpWidth - inputWidth ) : 0 );\n            offset.left -= ( isFixed && offset.left === inst.input.offset().left ) ? $( document ).scrollLeft() : 0;\n            offset.top -= ( isFixed && offset.top === ( inst.input.offset().top + inputHeight ) ) ? $( document ).scrollTop() : 0;\n\n            // Now check if datepicker is showing outside window viewport - move to a better place if so.\n            offset.left -= Math.min( offset.left, ( offset.left + dpWidth > viewWidth && viewWidth > dpWidth ) ?\n                Math.abs( offset.left + dpWidth - viewWidth ) : 0 );\n            offset.top -= Math.min( offset.top, ( offset.top + dpHeight > viewHeight && viewHeight > dpHeight ) ?\n                Math.abs( dpHeight + inputHeight ) : 0 );\n\n            return offset;\n        },\n\n        /* Find an object's position on the screen. */\n        _findPos: function( obj ) {\n            var position,\n                inst = this._getInst( obj ),\n                isRTL = this._get( inst, \"isRTL\" );\n\n            while ( obj && ( obj.type === \"hidden\" || obj.nodeType !== 1 || $.expr.pseudos.hidden( obj ) ) ) {\n                obj = obj[ isRTL ? \"previousSibling\" : \"nextSibling\" ];\n            }\n\n            position = $( obj ).offset();\n            return [ position.left, position.top ];\n        },\n\n        /* Hide the date picker from view.\n         * @param  input  element - the input field attached to the date picker\n         */\n        _hideDatepicker: function( input ) {\n            var showAnim, duration, postProcess, onClose,\n                inst = this._curInst;\n\n            if ( !inst || ( input && inst !== $.data( input, \"datepicker\" ) ) ) {\n                return;\n            }\n\n            if ( this._datepickerShowing ) {\n                showAnim = this._get( inst, \"showAnim\" );\n                duration = this._get( inst, \"duration\" );\n                postProcess = function() {\n                    $.datepicker._tidyDialog( inst );\n                };\n\n                // DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed\n                if ( $.effects && ( $.effects.effect[ showAnim ] || $.effects[ showAnim ] ) ) {\n                    inst.dpDiv.hide( showAnim, $.datepicker._get( inst, \"showOptions\" ), duration, postProcess );\n                } else {\n                    inst.dpDiv[ ( showAnim === \"slideDown\" ? \"slideUp\" :\n                        ( showAnim === \"fadeIn\" ? \"fadeOut\" : \"hide\" ) ) ]( ( showAnim ? duration : null ), postProcess );\n                }\n\n                if ( !showAnim ) {\n                    postProcess();\n                }\n                this._datepickerShowing = false;\n\n                onClose = this._get( inst, \"onClose\" );\n                if ( onClose ) {\n                    onClose.apply( ( inst.input ? inst.input[ 0 ] : null ), [ ( inst.input ? inst.input.val() : \"\" ), inst ] );\n                }\n\n                this._lastInput = null;\n                if ( this._inDialog ) {\n                    this._dialogInput.css( { position: \"absolute\", left: \"0\", top: \"-100px\" } );\n                    if ( $.blockUI ) {\n                        $.unblockUI();\n                        $( \"body\" ).append( this.dpDiv );\n                    }\n                }\n                this._inDialog = false;\n            }\n        },\n\n        /* Tidy up after a dialog display. */\n        _tidyDialog: function( inst ) {\n            inst.dpDiv.removeClass( this._dialogClass ).off( \".ui-datepicker-calendar\" );\n        },\n\n        /* Close date picker if clicked elsewhere. */\n        _checkExternalClick: function( event ) {\n            if ( !$.datepicker._curInst ) {\n                return;\n            }\n\n            var $target = $( event.target ),\n                inst = $.datepicker._getInst( $target[ 0 ] );\n\n            if ( ( ( $target[ 0 ].id !== $.datepicker._mainDivId &&\n                    $target.parents( \"#\" + $.datepicker._mainDivId ).length === 0 &&\n                    !$target.hasClass( $.datepicker.markerClassName ) &&\n                    !$target.closest( \".\" + $.datepicker._triggerClass ).length &&\n                    $.datepicker._datepickerShowing && !( $.datepicker._inDialog && $.blockUI ) ) ) ||\n                ( $target.hasClass( $.datepicker.markerClassName ) && $.datepicker._curInst !== inst ) ) {\n                $.datepicker._hideDatepicker();\n            }\n        },\n\n        /* Adjust one of the date sub-fields. */\n        _adjustDate: function( id, offset, period ) {\n            var target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            if ( this._isDisabledDatepicker( target[ 0 ] ) ) {\n                return;\n            }\n            this._adjustInstDate( inst, offset, period );\n            this._updateDatepicker( inst );\n        },\n\n        /* Action for current link. */\n        _gotoToday: function( id ) {\n            var date,\n                target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            if ( this._get( inst, \"gotoCurrent\" ) && inst.currentDay ) {\n                inst.selectedDay = inst.currentDay;\n                inst.drawMonth = inst.selectedMonth = inst.currentMonth;\n                inst.drawYear = inst.selectedYear = inst.currentYear;\n            } else {\n                date = new Date();\n                inst.selectedDay = date.getDate();\n                inst.drawMonth = inst.selectedMonth = date.getMonth();\n                inst.drawYear = inst.selectedYear = date.getFullYear();\n            }\n            this._notifyChange( inst );\n            this._adjustDate( target );\n        },\n\n        /* Action for selecting a new month/year. */\n        _selectMonthYear: function( id, select, period ) {\n            var target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            inst[ \"selected\" + ( period === \"M\" ? \"Month\" : \"Year\" ) ] =\n                inst[ \"draw\" + ( period === \"M\" ? \"Month\" : \"Year\" ) ] =\n                    parseInt( select.options[ select.selectedIndex ].value, 10 );\n\n            this._notifyChange( inst );\n            this._adjustDate( target );\n        },\n\n        /* Action for selecting a day. */\n        _selectDay: function( id, month, year, td ) {\n            var inst,\n                target = $( id );\n\n            if ( $( td ).hasClass( this._unselectableClass ) || this._isDisabledDatepicker( target[ 0 ] ) ) {\n                return;\n            }\n\n            inst = this._getInst( target[ 0 ] );\n            inst.selectedDay = inst.currentDay = parseInt( $( \"a\", td ).attr( \"data-date\" ) );\n            inst.selectedMonth = inst.currentMonth = month;\n            inst.selectedYear = inst.currentYear = year;\n            this._selectDate( id, this._formatDate( inst,\n                inst.currentDay, inst.currentMonth, inst.currentYear ) );\n        },\n\n        /* Erase the input field and hide the date picker. */\n        _clearDate: function( id ) {\n            var target = $( id );\n            this._selectDate( target, \"\" );\n        },\n\n        /* Update the input field with the selected date. */\n        _selectDate: function( id, dateStr ) {\n            var onSelect,\n                target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            dateStr = ( dateStr != null ? dateStr : this._formatDate( inst ) );\n            if ( inst.input ) {\n                inst.input.val( dateStr );\n            }\n            this._updateAlternate( inst );\n\n            onSelect = this._get( inst, \"onSelect\" );\n            if ( onSelect ) {\n                onSelect.apply( ( inst.input ? inst.input[ 0 ] : null ), [ dateStr, inst ] );  // trigger custom callback\n            } else if ( inst.input ) {\n                inst.input.trigger( \"change\" ); // fire the change event\n            }\n\n            if ( inst.inline ) {\n                this._updateDatepicker( inst );\n            } else {\n                this._hideDatepicker();\n                this._lastInput = inst.input[ 0 ];\n                if ( typeof( inst.input[ 0 ] ) !== \"object\" ) {\n                    inst.input.trigger( \"focus\" ); // restore focus\n                }\n                this._lastInput = null;\n            }\n        },\n\n        /* Update any alternate field to synchronise with the main field. */\n        _updateAlternate: function( inst ) {\n            var altFormat, date, dateStr,\n                altField = this._get( inst, \"altField\" );\n\n            if ( altField ) { // update alternate field too\n                altFormat = this._get( inst, \"altFormat\" ) || this._get( inst, \"dateFormat\" );\n                date = this._getDate( inst );\n                dateStr = this.formatDate( altFormat, date, this._getFormatConfig( inst ) );\n                $( document ).find( altField ).val( dateStr );\n            }\n        },\n\n        /* Set as beforeShowDay function to prevent selection of weekends.\n         * @param  date  Date - the date to customise\n         * @return [boolean, string] - is this date selectable?, what is its CSS class?\n         */\n        noWeekends: function( date ) {\n            var day = date.getDay();\n            return [ ( day > 0 && day < 6 ), \"\" ];\n        },\n\n        /* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.\n         * @param  date  Date - the date to get the week for\n         * @return  number - the number of the week within the year that contains this date\n         */\n        iso8601Week: function( date ) {\n            var time,\n                checkDate = new Date( date.getTime() );\n\n            // Find Thursday of this week starting on Monday\n            checkDate.setDate( checkDate.getDate() + 4 - ( checkDate.getDay() || 7 ) );\n\n            time = checkDate.getTime();\n            checkDate.setMonth( 0 ); // Compare with Jan 1\n            checkDate.setDate( 1 );\n            return Math.floor( Math.round( ( time - checkDate ) / 86400000 ) / 7 ) + 1;\n        },\n\n        /* Parse a string value into a date object.\n         * See formatDate below for the possible formats.\n         *\n         * @param  format string - the expected format of the date\n         * @param  value string - the date in the above format\n         * @param  settings Object - attributes include:\n         *\t\t\t\t\tshortYearCutoff  number - the cutoff year for determining the century (optional)\n         *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n         *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n         *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n         *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n         * @return  Date - the extracted date value or null if value is blank\n         */\n        parseDate: function( format, value, settings ) {\n            if ( format == null || value == null ) {\n                throw \"Invalid arguments\";\n            }\n\n            value = ( typeof value === \"object\" ? value.toString() : value + \"\" );\n            if ( value === \"\" ) {\n                return null;\n            }\n\n            var iFormat, dim, extra,\n                iValue = 0,\n                shortYearCutoffTemp = ( settings ? settings.shortYearCutoff : null ) || this._defaults.shortYearCutoff,\n                shortYearCutoff = ( typeof shortYearCutoffTemp !== \"string\" ? shortYearCutoffTemp :\n                    new Date().getFullYear() % 100 + parseInt( shortYearCutoffTemp, 10 ) ),\n                dayNamesShort = ( settings ? settings.dayNamesShort : null ) || this._defaults.dayNamesShort,\n                dayNames = ( settings ? settings.dayNames : null ) || this._defaults.dayNames,\n                monthNamesShort = ( settings ? settings.monthNamesShort : null ) || this._defaults.monthNamesShort,\n                monthNames = ( settings ? settings.monthNames : null ) || this._defaults.monthNames,\n                year = -1,\n                month = -1,\n                day = -1,\n                doy = -1,\n                literal = false,\n                date,\n\n                // Check whether a format character is doubled\n                lookAhead = function( match ) {\n                    var matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n                    if ( matches ) {\n                        iFormat++;\n                    }\n                    return matches;\n                },\n\n                // Extract a number from the string value\n                getNumber = function( match ) {\n                    var isDoubled = lookAhead( match ),\n                        size = ( match === \"@\" ? 14 : ( match === \"!\" ? 20 :\n                            ( match === \"y\" && isDoubled ? 4 : ( match === \"o\" ? 3 : 2 ) ) ) ),\n                        minSize = ( match === \"y\" ? size : 1 ),\n                        digits = new RegExp( \"^\\\\d{\" + minSize + \",\" + size + \"}\" ),\n                        num = value.substring( iValue ).match( digits );\n                    if ( !num ) {\n                        throw \"Missing number at position \" + iValue;\n                    }\n                    iValue += num[ 0 ].length;\n                    return parseInt( num[ 0 ], 10 );\n                },\n\n                // Extract a name from the string value and convert to an index\n                getName = function( match, shortNames, longNames ) {\n                    var index = -1,\n                        names = $.map( lookAhead( match ) ? longNames : shortNames, function( v, k ) {\n                            return [ [ k, v ] ];\n                        } ).sort( function( a, b ) {\n                            return -( a[ 1 ].length - b[ 1 ].length );\n                        } );\n\n                    $.each( names, function( i, pair ) {\n                        var name = pair[ 1 ];\n                        if ( value.substr( iValue, name.length ).toLowerCase() === name.toLowerCase() ) {\n                            index = pair[ 0 ];\n                            iValue += name.length;\n                            return false;\n                        }\n                    } );\n                    if ( index !== -1 ) {\n                        return index + 1;\n                    } else {\n                        throw \"Unknown name at position \" + iValue;\n                    }\n                },\n\n                // Confirm that a literal character matches the string value\n                checkLiteral = function() {\n                    if ( value.charAt( iValue ) !== format.charAt( iFormat ) ) {\n                        throw \"Unexpected literal at position \" + iValue;\n                    }\n                    iValue++;\n                };\n\n            for ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n                if ( literal ) {\n                    if ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n                        literal = false;\n                    } else {\n                        checkLiteral();\n                    }\n                } else {\n                    switch ( format.charAt( iFormat ) ) {\n                        case \"d\":\n                            day = getNumber( \"d\" );\n                            break;\n                        case \"D\":\n                            getName( \"D\", dayNamesShort, dayNames );\n                            break;\n                        case \"o\":\n                            doy = getNumber( \"o\" );\n                            break;\n                        case \"m\":\n                            month = getNumber( \"m\" );\n                            break;\n                        case \"M\":\n                            month = getName( \"M\", monthNamesShort, monthNames );\n                            break;\n                        case \"y\":\n                            year = getNumber( \"y\" );\n                            break;\n                        case \"@\":\n                            date = new Date( getNumber( \"@\" ) );\n                            year = date.getFullYear();\n                            month = date.getMonth() + 1;\n                            day = date.getDate();\n                            break;\n                        case \"!\":\n                            date = new Date( ( getNumber( \"!\" ) - this._ticksTo1970 ) / 10000 );\n                            year = date.getFullYear();\n                            month = date.getMonth() + 1;\n                            day = date.getDate();\n                            break;\n                        case \"'\":\n                            if ( lookAhead( \"'\" ) ) {\n                                checkLiteral();\n                            } else {\n                                literal = true;\n                            }\n                            break;\n                        default:\n                            checkLiteral();\n                    }\n                }\n            }\n\n            if ( iValue < value.length ) {\n                extra = value.substr( iValue );\n                if ( !/^\\s+/.test( extra ) ) {\n                    throw \"Extra/unparsed characters found in date: \" + extra;\n                }\n            }\n\n            if ( year === -1 ) {\n                year = new Date().getFullYear();\n            } else if ( year < 100 ) {\n                year += new Date().getFullYear() - new Date().getFullYear() % 100 +\n                    ( year <= shortYearCutoff ? 0 : -100 );\n            }\n\n            if ( doy > -1 ) {\n                month = 1;\n                day = doy;\n                do {\n                    dim = this._getDaysInMonth( year, month - 1 );\n                    if ( day <= dim ) {\n                        break;\n                    }\n                    month++;\n                    day -= dim;\n                } while ( true );\n            }\n\n            date = this._daylightSavingAdjust( new Date( year, month - 1, day ) );\n            if ( date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day ) {\n                throw \"Invalid date\"; // E.g. 31/02/00\n            }\n            return date;\n        },\n\n        /* Standard date formats. */\n        ATOM: \"yy-mm-dd\", // RFC 3339 (ISO 8601)\n        COOKIE: \"D, dd M yy\",\n        ISO_8601: \"yy-mm-dd\",\n        RFC_822: \"D, d M y\",\n        RFC_850: \"DD, dd-M-y\",\n        RFC_1036: \"D, d M y\",\n        RFC_1123: \"D, d M yy\",\n        RFC_2822: \"D, d M yy\",\n        RSS: \"D, d M y\", // RFC 822\n        TICKS: \"!\",\n        TIMESTAMP: \"@\",\n        W3C: \"yy-mm-dd\", // ISO 8601\n\n        _ticksTo1970: ( ( ( 1970 - 1 ) * 365 + Math.floor( 1970 / 4 ) - Math.floor( 1970 / 100 ) +\n            Math.floor( 1970 / 400 ) ) * 24 * 60 * 60 * 10000000 ),\n\n        /* Format a date object into a string value.\n         * The format can be combinations of the following:\n         * d  - day of month (no leading zero)\n         * dd - day of month (two digit)\n         * o  - day of year (no leading zeros)\n         * oo - day of year (three digit)\n         * D  - day name short\n         * DD - day name long\n         * m  - month of year (no leading zero)\n         * mm - month of year (two digit)\n         * M  - month name short\n         * MM - month name long\n         * y  - year (two digit)\n         * yy - year (four digit)\n         * @ - Unix timestamp (ms since 01/01/1970)\n         * ! - Windows ticks (100ns since 01/01/0001)\n         * \"...\" - literal text\n         * '' - single quote\n         *\n         * @param  format string - the desired format of the date\n         * @param  date Date - the date value to format\n         * @param  settings Object - attributes include:\n         *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n         *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n         *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n         *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n         * @return  string - the date in the above format\n         */\n        formatDate: function( format, date, settings ) {\n            if ( !date ) {\n                return \"\";\n            }\n\n            var iFormat,\n                dayNamesShort = ( settings ? settings.dayNamesShort : null ) || this._defaults.dayNamesShort,\n                dayNames = ( settings ? settings.dayNames : null ) || this._defaults.dayNames,\n                monthNamesShort = ( settings ? settings.monthNamesShort : null ) || this._defaults.monthNamesShort,\n                monthNames = ( settings ? settings.monthNames : null ) || this._defaults.monthNames,\n\n                // Check whether a format character is doubled\n                lookAhead = function( match ) {\n                    var matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n                    if ( matches ) {\n                        iFormat++;\n                    }\n                    return matches;\n                },\n\n                // Format a number, with leading zero if necessary\n                formatNumber = function( match, value, len ) {\n                    var num = \"\" + value;\n                    if ( lookAhead( match ) ) {\n                        while ( num.length < len ) {\n                            num = \"0\" + num;\n                        }\n                    }\n                    return num;\n                },\n\n                // Format a name, short or long as requested\n                formatName = function( match, value, shortNames, longNames ) {\n                    return ( lookAhead( match ) ? longNames[ value ] : shortNames[ value ] );\n                },\n                output = \"\",\n                literal = false;\n\n            if ( date ) {\n                for ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n                    if ( literal ) {\n                        if ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n                            literal = false;\n                        } else {\n                            output += format.charAt( iFormat );\n                        }\n                    } else {\n                        switch ( format.charAt( iFormat ) ) {\n                            case \"d\":\n                                output += formatNumber( \"d\", date.getDate(), 2 );\n                                break;\n                            case \"D\":\n                                output += formatName( \"D\", date.getDay(), dayNamesShort, dayNames );\n                                break;\n                            case \"o\":\n                                output += formatNumber( \"o\",\n                                    Math.round( ( new Date( date.getFullYear(), date.getMonth(), date.getDate() ).getTime() - new Date( date.getFullYear(), 0, 0 ).getTime() ) / 86400000 ), 3 );\n                                break;\n                            case \"m\":\n                                output += formatNumber( \"m\", date.getMonth() + 1, 2 );\n                                break;\n                            case \"M\":\n                                output += formatName( \"M\", date.getMonth(), monthNamesShort, monthNames );\n                                break;\n                            case \"y\":\n                                output += ( lookAhead( \"y\" ) ? date.getFullYear() :\n                                    ( date.getFullYear() % 100 < 10 ? \"0\" : \"\" ) + date.getFullYear() % 100 );\n                                break;\n                            case \"@\":\n                                output += date.getTime();\n                                break;\n                            case \"!\":\n                                output += date.getTime() * 10000 + this._ticksTo1970;\n                                break;\n                            case \"'\":\n                                if ( lookAhead( \"'\" ) ) {\n                                    output += \"'\";\n                                } else {\n                                    literal = true;\n                                }\n                                break;\n                            default:\n                                output += format.charAt( iFormat );\n                        }\n                    }\n                }\n            }\n            return output;\n        },\n\n        /* Extract all possible characters from the date format. */\n        _possibleChars: function( format ) {\n            var iFormat,\n                chars = \"\",\n                literal = false,\n\n                // Check whether a format character is doubled\n                lookAhead = function( match ) {\n                    var matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n                    if ( matches ) {\n                        iFormat++;\n                    }\n                    return matches;\n                };\n\n            for ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n                if ( literal ) {\n                    if ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n                        literal = false;\n                    } else {\n                        chars += format.charAt( iFormat );\n                    }\n                } else {\n                    switch ( format.charAt( iFormat ) ) {\n                        case \"d\": case \"m\": case \"y\": case \"@\":\n                            chars += \"0123456789\";\n                            break;\n                        case \"D\": case \"M\":\n                            return null; // Accept anything\n                        case \"'\":\n                            if ( lookAhead( \"'\" ) ) {\n                                chars += \"'\";\n                            } else {\n                                literal = true;\n                            }\n                            break;\n                        default:\n                            chars += format.charAt( iFormat );\n                    }\n                }\n            }\n            return chars;\n        },\n\n        /* Get a setting value, defaulting if necessary. */\n        _get: function( inst, name ) {\n            return inst.settings[ name ] !== undefined ?\n                inst.settings[ name ] : this._defaults[ name ];\n        },\n\n        /* Parse existing date and initialise date picker. */\n        _setDateFromField: function( inst, noDefault ) {\n            if ( inst.input.val() === inst.lastVal ) {\n                return;\n            }\n\n            var dateFormat = this._get( inst, \"dateFormat\" ),\n                dates = inst.lastVal = inst.input ? inst.input.val() : null,\n                defaultDate = this._getDefaultDate( inst ),\n                date = defaultDate,\n                settings = this._getFormatConfig( inst );\n\n            try {\n                date = this.parseDate( dateFormat, dates, settings ) || defaultDate;\n            } catch ( event ) {\n                dates = ( noDefault ? \"\" : dates );\n            }\n            inst.selectedDay = date.getDate();\n            inst.drawMonth = inst.selectedMonth = date.getMonth();\n            inst.drawYear = inst.selectedYear = date.getFullYear();\n            inst.currentDay = ( dates ? date.getDate() : 0 );\n            inst.currentMonth = ( dates ? date.getMonth() : 0 );\n            inst.currentYear = ( dates ? date.getFullYear() : 0 );\n            this._adjustInstDate( inst );\n        },\n\n        /* Retrieve the default date shown on opening. */\n        _getDefaultDate: function( inst ) {\n            return this._restrictMinMax( inst,\n                this._determineDate( inst, this._get( inst, \"defaultDate\" ), new Date() ) );\n        },\n\n        /* A date may be specified as an exact value or a relative one. */\n        _determineDate: function( inst, date, defaultDate ) {\n            var offsetNumeric = function( offset ) {\n                    var date = new Date();\n                    date.setDate( date.getDate() + offset );\n                    return date;\n                },\n                offsetString = function( offset ) {\n                    try {\n                        return $.datepicker.parseDate( $.datepicker._get( inst, \"dateFormat\" ),\n                            offset, $.datepicker._getFormatConfig( inst ) );\n                    } catch ( e ) {\n\n                        // Ignore\n                    }\n\n                    var date = ( offset.toLowerCase().match( /^c/ ) ?\n                            $.datepicker._getDate( inst ) : null ) || new Date(),\n                        year = date.getFullYear(),\n                        month = date.getMonth(),\n                        day = date.getDate(),\n                        pattern = /([+\\-]?[0-9]+)\\s*(d|D|w|W|m|M|y|Y)?/g,\n                        matches = pattern.exec( offset );\n\n                    while ( matches ) {\n                        switch ( matches[ 2 ] || \"d\" ) {\n                            case \"d\" : case \"D\" :\n                                day += parseInt( matches[ 1 ], 10 ); break;\n                            case \"w\" : case \"W\" :\n                                day += parseInt( matches[ 1 ], 10 ) * 7; break;\n                            case \"m\" : case \"M\" :\n                                month += parseInt( matches[ 1 ], 10 );\n                                day = Math.min( day, $.datepicker._getDaysInMonth( year, month ) );\n                                break;\n                            case \"y\": case \"Y\" :\n                                year += parseInt( matches[ 1 ], 10 );\n                                day = Math.min( day, $.datepicker._getDaysInMonth( year, month ) );\n                                break;\n                        }\n                        matches = pattern.exec( offset );\n                    }\n                    return new Date( year, month, day );\n                },\n                newDate = ( date == null || date === \"\" ? defaultDate : ( typeof date === \"string\" ? offsetString( date ) :\n                    ( typeof date === \"number\" ? ( isNaN( date ) ? defaultDate : offsetNumeric( date ) ) : new Date( date.getTime() ) ) ) );\n\n            newDate = ( newDate && newDate.toString() === \"Invalid Date\" ? defaultDate : newDate );\n            if ( newDate ) {\n                newDate.setHours( 0 );\n                newDate.setMinutes( 0 );\n                newDate.setSeconds( 0 );\n                newDate.setMilliseconds( 0 );\n            }\n            return this._daylightSavingAdjust( newDate );\n        },\n\n        /* Handle switch to/from daylight saving.\n         * Hours may be non-zero on daylight saving cut-over:\n         * > 12 when midnight changeover, but then cannot generate\n         * midnight datetime, so jump to 1AM, otherwise reset.\n         * @param  date  (Date) the date to check\n         * @return  (Date) the corrected date\n         */\n        _daylightSavingAdjust: function( date ) {\n            if ( !date ) {\n                return null;\n            }\n            date.setHours( date.getHours() > 12 ? date.getHours() + 2 : 0 );\n            return date;\n        },\n\n        /* Set the date(s) directly. */\n        _setDate: function( inst, date, noChange ) {\n            var clear = !date,\n                origMonth = inst.selectedMonth,\n                origYear = inst.selectedYear,\n                newDate = this._restrictMinMax( inst, this._determineDate( inst, date, new Date() ) );\n\n            inst.selectedDay = inst.currentDay = newDate.getDate();\n            inst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth();\n            inst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear();\n            if ( ( origMonth !== inst.selectedMonth || origYear !== inst.selectedYear ) && !noChange ) {\n                this._notifyChange( inst );\n            }\n            this._adjustInstDate( inst );\n            if ( inst.input ) {\n                inst.input.val( clear ? \"\" : this._formatDate( inst ) );\n            }\n        },\n\n        /* Retrieve the date(s) directly. */\n        _getDate: function( inst ) {\n            var startDate = ( !inst.currentYear || ( inst.input && inst.input.val() === \"\" ) ? null :\n                this._daylightSavingAdjust( new Date(\n                    inst.currentYear, inst.currentMonth, inst.currentDay ) ) );\n            return startDate;\n        },\n\n        /* Attach the onxxx handlers.  These are declared statically so\n         * they work with static code transformers like Caja.\n         */\n        _attachHandlers: function( inst ) {\n            var stepMonths = this._get( inst, \"stepMonths\" ),\n                id = \"#\" + inst.id.replace( /\\\\\\\\/g, \"\\\\\" );\n            inst.dpDiv.find( \"[data-handler]\" ).map( function() {\n                var handler = {\n                    prev: function() {\n                        $.datepicker._adjustDate( id, -stepMonths, \"M\" );\n                    },\n                    next: function() {\n                        $.datepicker._adjustDate( id, +stepMonths, \"M\" );\n                    },\n                    hide: function() {\n                        $.datepicker._hideDatepicker();\n                    },\n                    today: function() {\n                        $.datepicker._gotoToday( id );\n                    },\n                    selectDay: function() {\n                        $.datepicker._selectDay( id, +this.getAttribute( \"data-month\" ), +this.getAttribute( \"data-year\" ), this );\n                        return false;\n                    },\n                    selectMonth: function() {\n                        $.datepicker._selectMonthYear( id, this, \"M\" );\n                        return false;\n                    },\n                    selectYear: function() {\n                        $.datepicker._selectMonthYear( id, this, \"Y\" );\n                        return false;\n                    }\n                };\n                $( this ).on( this.getAttribute( \"data-event\" ), handler[ this.getAttribute( \"data-handler\" ) ] );\n            } );\n        },\n\n        /* Generate the HTML for the current state of the date picker. */\n        _generateHTML: function( inst ) {\n            var maxDraw, prevText, prev, nextText, next, currentText, gotoDate,\n                controls, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin,\n                monthNames, monthNamesShort, beforeShowDay, showOtherMonths,\n                selectOtherMonths, defaultDate, html, dow, row, group, col, selectedDate,\n                cornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows,\n                printDate, dRow, tbody, daySettings, otherMonth, unselectable,\n                tempDate = new Date(),\n                today = this._daylightSavingAdjust(\n                    new Date( tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate() ) ), // clear time\n                isRTL = this._get( inst, \"isRTL\" ),\n                showButtonPanel = this._get( inst, \"showButtonPanel\" ),\n                hideIfNoPrevNext = this._get( inst, \"hideIfNoPrevNext\" ),\n                navigationAsDateFormat = this._get( inst, \"navigationAsDateFormat\" ),\n                numMonths = this._getNumberOfMonths( inst ),\n                showCurrentAtPos = this._get( inst, \"showCurrentAtPos\" ),\n                stepMonths = this._get( inst, \"stepMonths\" ),\n                isMultiMonth = ( numMonths[ 0 ] !== 1 || numMonths[ 1 ] !== 1 ),\n                currentDate = this._daylightSavingAdjust( ( !inst.currentDay ? new Date( 9999, 9, 9 ) :\n                    new Date( inst.currentYear, inst.currentMonth, inst.currentDay ) ) ),\n                minDate = this._getMinMaxDate( inst, \"min\" ),\n                maxDate = this._getMinMaxDate( inst, \"max\" ),\n                drawMonth = inst.drawMonth - showCurrentAtPos,\n                drawYear = inst.drawYear;\n\n            if ( drawMonth < 0 ) {\n                drawMonth += 12;\n                drawYear--;\n            }\n            if ( maxDate ) {\n                maxDraw = this._daylightSavingAdjust( new Date( maxDate.getFullYear(),\n                    maxDate.getMonth() - ( numMonths[ 0 ] * numMonths[ 1 ] ) + 1, maxDate.getDate() ) );\n                maxDraw = ( minDate && maxDraw < minDate ? minDate : maxDraw );\n                while ( this._daylightSavingAdjust( new Date( drawYear, drawMonth, 1 ) ) > maxDraw ) {\n                    drawMonth--;\n                    if ( drawMonth < 0 ) {\n                        drawMonth = 11;\n                        drawYear--;\n                    }\n                }\n            }\n            inst.drawMonth = drawMonth;\n            inst.drawYear = drawYear;\n\n            prevText = this._get( inst, \"prevText\" );\n            prevText = ( !navigationAsDateFormat ? prevText : this.formatDate( prevText,\n                this._daylightSavingAdjust( new Date( drawYear, drawMonth - stepMonths, 1 ) ),\n                this._getFormatConfig( inst ) ) );\n\n            if ( this._canAdjustMonth( inst, -1, drawYear, drawMonth ) ) {\n                prev = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-prev ui-corner-all\",\n                        \"data-handler\": \"prev\",\n                        \"data-event\": \"click\",\n                        title: prevText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .addClass( \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"e\" : \"w\" ) )\n                            .text( prevText )\n                    )[ 0 ].outerHTML;\n            } else if ( hideIfNoPrevNext ) {\n                prev = \"\";\n            } else {\n                prev = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-prev ui-corner-all ui-state-disabled\",\n                        title: prevText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .addClass( \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"e\" : \"w\" ) )\n                            .text( prevText )\n                    )[ 0 ].outerHTML;\n            }\n\n            nextText = this._get( inst, \"nextText\" );\n            nextText = ( !navigationAsDateFormat ? nextText : this.formatDate( nextText,\n                this._daylightSavingAdjust( new Date( drawYear, drawMonth + stepMonths, 1 ) ),\n                this._getFormatConfig( inst ) ) );\n\n            if ( this._canAdjustMonth( inst, +1, drawYear, drawMonth ) ) {\n                next = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-next ui-corner-all\",\n                        \"data-handler\": \"next\",\n                        \"data-event\": \"click\",\n                        title: nextText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .addClass( \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"w\" : \"e\" ) )\n                            .text( nextText )\n                    )[ 0 ].outerHTML;\n            } else if ( hideIfNoPrevNext ) {\n                next = \"\";\n            } else {\n                next = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-next ui-corner-all ui-state-disabled\",\n                        title: nextText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .attr( \"class\", \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"w\" : \"e\" ) )\n                            .text( nextText )\n                    )[ 0 ].outerHTML;\n            }\n\n            currentText = this._get( inst, \"currentText\" );\n            gotoDate = ( this._get( inst, \"gotoCurrent\" ) && inst.currentDay ? currentDate : today );\n            currentText = ( !navigationAsDateFormat ? currentText :\n                this.formatDate( currentText, gotoDate, this._getFormatConfig( inst ) ) );\n\n            controls = \"\";\n            if ( !inst.inline ) {\n                controls = $( \"<button>\" )\n                    .attr( {\n                        type: \"button\",\n                        \"class\": \"ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all\",\n                        \"data-handler\": \"hide\",\n                        \"data-event\": \"click\"\n                    } )\n                    .text( this._get( inst, \"closeText\" ) )[ 0 ].outerHTML;\n            }\n\n            buttonPanel = \"\";\n            if ( showButtonPanel ) {\n                buttonPanel = $( \"<div class='ui-datepicker-buttonpane ui-widget-content'>\" )\n                    .append( isRTL ? controls : \"\" )\n                    .append( this._isInRange( inst, gotoDate ) ?\n                        $( \"<button>\" )\n                            .attr( {\n                                type: \"button\",\n                                \"class\": \"ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all\",\n                                \"data-handler\": \"today\",\n                                \"data-event\": \"click\"\n                            } )\n                            .text( currentText ) :\n                        \"\" )\n                    .append( isRTL ? \"\" : controls )[ 0 ].outerHTML;\n            }\n\n            firstDay = parseInt( this._get( inst, \"firstDay\" ), 10 );\n            firstDay = ( isNaN( firstDay ) ? 0 : firstDay );\n\n            showWeek = this._get( inst, \"showWeek\" );\n            dayNames = this._get( inst, \"dayNames\" );\n            dayNamesMin = this._get( inst, \"dayNamesMin\" );\n            monthNames = this._get( inst, \"monthNames\" );\n            monthNamesShort = this._get( inst, \"monthNamesShort\" );\n            beforeShowDay = this._get( inst, \"beforeShowDay\" );\n            showOtherMonths = this._get( inst, \"showOtherMonths\" );\n            selectOtherMonths = this._get( inst, \"selectOtherMonths\" );\n            defaultDate = this._getDefaultDate( inst );\n            html = \"\";\n\n            for ( row = 0; row < numMonths[ 0 ]; row++ ) {\n                group = \"\";\n                this.maxRows = 4;\n                for ( col = 0; col < numMonths[ 1 ]; col++ ) {\n                    selectedDate = this._daylightSavingAdjust( new Date( drawYear, drawMonth, inst.selectedDay ) );\n                    cornerClass = \" ui-corner-all\";\n                    calender = \"\";\n                    if ( isMultiMonth ) {\n                        calender += \"<div class='ui-datepicker-group\";\n                        if ( numMonths[ 1 ] > 1 ) {\n                            switch ( col ) {\n                                case 0: calender += \" ui-datepicker-group-first\";\n                                    cornerClass = \" ui-corner-\" + ( isRTL ? \"right\" : \"left\" ); break;\n                                case numMonths[ 1 ] - 1: calender += \" ui-datepicker-group-last\";\n                                    cornerClass = \" ui-corner-\" + ( isRTL ? \"left\" : \"right\" ); break;\n                                default: calender += \" ui-datepicker-group-middle\"; cornerClass = \"\"; break;\n                            }\n                        }\n                        calender += \"'>\";\n                    }\n                    calender += \"<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix\" + cornerClass + \"'>\" +\n                        ( /all|left/.test( cornerClass ) && row === 0 ? ( isRTL ? next : prev ) : \"\" ) +\n                        ( /all|right/.test( cornerClass ) && row === 0 ? ( isRTL ? prev : next ) : \"\" ) +\n                        this._generateMonthYearHeader( inst, drawMonth, drawYear, minDate, maxDate,\n                            row > 0 || col > 0, monthNames, monthNamesShort ) + // draw month headers\n                        \"</div><table class='ui-datepicker-calendar'><thead>\" +\n                        \"<tr>\";\n                    thead = ( showWeek ? \"<th class='ui-datepicker-week-col'>\" + this._get( inst, \"weekHeader\" ) + \"</th>\" : \"\" );\n                    for ( dow = 0; dow < 7; dow++ ) { // days of the week\n                        day = ( dow + firstDay ) % 7;\n                        thead += \"<th scope='col'\" + ( ( dow + firstDay + 6 ) % 7 >= 5 ? \" class='ui-datepicker-week-end'\" : \"\" ) + \">\" +\n                            \"<span title='\" + dayNames[ day ] + \"'>\" + dayNamesMin[ day ] + \"</span></th>\";\n                    }\n                    calender += thead + \"</tr></thead><tbody>\";\n                    daysInMonth = this._getDaysInMonth( drawYear, drawMonth );\n                    if ( drawYear === inst.selectedYear && drawMonth === inst.selectedMonth ) {\n                        inst.selectedDay = Math.min( inst.selectedDay, daysInMonth );\n                    }\n                    leadDays = ( this._getFirstDayOfMonth( drawYear, drawMonth ) - firstDay + 7 ) % 7;\n                    curRows = Math.ceil( ( leadDays + daysInMonth ) / 7 ); // calculate the number of rows to generate\n                    numRows = ( isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows ); //If multiple months, use the higher number of rows (see #7043)\n                    this.maxRows = numRows;\n                    printDate = this._daylightSavingAdjust( new Date( drawYear, drawMonth, 1 - leadDays ) );\n                    for ( dRow = 0; dRow < numRows; dRow++ ) { // create date picker rows\n                        calender += \"<tr>\";\n                        tbody = ( !showWeek ? \"\" : \"<td class='ui-datepicker-week-col'>\" +\n                            this._get( inst, \"calculateWeek\" )( printDate ) + \"</td>\" );\n                        for ( dow = 0; dow < 7; dow++ ) { // create date picker days\n                            daySettings = ( beforeShowDay ?\n                                beforeShowDay.apply( ( inst.input ? inst.input[ 0 ] : null ), [ printDate ] ) : [ true, \"\" ] );\n                            otherMonth = ( printDate.getMonth() !== drawMonth );\n                            unselectable = ( otherMonth && !selectOtherMonths ) || !daySettings[ 0 ] ||\n                                ( minDate && printDate < minDate ) || ( maxDate && printDate > maxDate );\n                            tbody += \"<td class='\" +\n                                ( ( dow + firstDay + 6 ) % 7 >= 5 ? \" ui-datepicker-week-end\" : \"\" ) + // highlight weekends\n                                ( otherMonth ? \" ui-datepicker-other-month\" : \"\" ) + // highlight days from other months\n                                ( ( printDate.getTime() === selectedDate.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent ) || // user pressed key\n                                ( defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate.getTime() ) ?\n\n                                    // or defaultDate is current printedDate and defaultDate is selectedDate\n                                    \" \" + this._dayOverClass : \"\" ) + // highlight selected day\n                                ( unselectable ? \" \" + this._unselectableClass + \" ui-state-disabled\" : \"\" ) +  // highlight unselectable days\n                                ( otherMonth && !showOtherMonths ? \"\" : \" \" + daySettings[ 1 ] + // highlight custom dates\n                                    ( printDate.getTime() === currentDate.getTime() ? \" \" + this._currentClass : \"\" ) + // highlight selected day\n                                    ( printDate.getTime() === today.getTime() ? \" ui-datepicker-today\" : \"\" ) ) + \"'\" + // highlight today (if different)\n                                ( ( !otherMonth || showOtherMonths ) && daySettings[ 2 ] ? \" title='\" + daySettings[ 2 ].replace( /'/g, \"&#39;\" ) + \"'\" : \"\" ) + // cell title\n                                ( unselectable ? \"\" : \" data-handler='selectDay' data-event='click' data-month='\" + printDate.getMonth() + \"' data-year='\" + printDate.getFullYear() + \"'\" ) + \">\" + // actions\n                                ( otherMonth && !showOtherMonths ? \"&#xa0;\" : // display for other months\n                                    ( unselectable ? \"<span class='ui-state-default'>\" + printDate.getDate() + \"</span>\" : \"<a class='ui-state-default\" +\n                                        ( printDate.getTime() === today.getTime() ? \" ui-state-highlight\" : \"\" ) +\n                                        ( printDate.getTime() === currentDate.getTime() ? \" ui-state-active\" : \"\" ) + // highlight selected day\n                                        ( otherMonth ? \" ui-priority-secondary\" : \"\" ) + // distinguish dates from other months\n                                        \"' href='#' aria-current='\" + ( printDate.getTime() === currentDate.getTime() ? \"true\" : \"false\" ) + // mark date as selected for screen reader\n                                        \"' data-date='\" + printDate.getDate() + // store date as data\n                                        \"'>\" + printDate.getDate() + \"</a>\" ) ) + \"</td>\"; // display selectable date\n                            printDate.setDate( printDate.getDate() + 1 );\n                            printDate = this._daylightSavingAdjust( printDate );\n                        }\n                        calender += tbody + \"</tr>\";\n                    }\n                    drawMonth++;\n                    if ( drawMonth > 11 ) {\n                        drawMonth = 0;\n                        drawYear++;\n                    }\n                    calender += \"</tbody></table>\" + ( isMultiMonth ? \"</div>\" +\n                        ( ( numMonths[ 0 ] > 0 && col === numMonths[ 1 ] - 1 ) ? \"<div class='ui-datepicker-row-break'></div>\" : \"\" ) : \"\" );\n                    group += calender;\n                }\n                html += group;\n            }\n            html += buttonPanel;\n            inst._keyEvent = false;\n            return html;\n        },\n\n        /* Generate the month and year header. */\n        _generateMonthYearHeader: function( inst, drawMonth, drawYear, minDate, maxDate,\n                                            secondary, monthNames, monthNamesShort ) {\n\n            var inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear,\n                changeMonth = this._get( inst, \"changeMonth\" ),\n                changeYear = this._get( inst, \"changeYear\" ),\n                showMonthAfterYear = this._get( inst, \"showMonthAfterYear\" ),\n                selectMonthLabel = this._get( inst, \"selectMonthLabel\" ),\n                selectYearLabel = this._get( inst, \"selectYearLabel\" ),\n                html = \"<div class='ui-datepicker-title'>\",\n                monthHtml = \"\";\n\n            // Month selection\n            if ( secondary || !changeMonth ) {\n                monthHtml += \"<span class='ui-datepicker-month'>\" + monthNames[ drawMonth ] + \"</span>\";\n            } else {\n                inMinYear = ( minDate && minDate.getFullYear() === drawYear );\n                inMaxYear = ( maxDate && maxDate.getFullYear() === drawYear );\n                monthHtml += \"<select class='ui-datepicker-month' aria-label='\" + selectMonthLabel + \"' data-handler='selectMonth' data-event='change'>\";\n                for ( month = 0; month < 12; month++ ) {\n                    if ( ( !inMinYear || month >= minDate.getMonth() ) && ( !inMaxYear || month <= maxDate.getMonth() ) ) {\n                        monthHtml += \"<option value='\" + month + \"'\" +\n                            ( month === drawMonth ? \" selected='selected'\" : \"\" ) +\n                            \">\" + monthNamesShort[ month ] + \"</option>\";\n                    }\n                }\n                monthHtml += \"</select>\";\n            }\n\n            if ( !showMonthAfterYear ) {\n                html += monthHtml + ( secondary || !( changeMonth && changeYear ) ? \"&#xa0;\" : \"\" );\n            }\n\n            // Year selection\n            if ( !inst.yearshtml ) {\n                inst.yearshtml = \"\";\n                if ( secondary || !changeYear ) {\n                    html += \"<span class='ui-datepicker-year'>\" + drawYear + \"</span>\";\n                } else {\n\n                    // determine range of years to display\n                    years = this._get( inst, \"yearRange\" ).split( \":\" );\n                    thisYear = new Date().getFullYear();\n                    determineYear = function( value ) {\n                        var year = ( value.match( /c[+\\-].*/ ) ? drawYear + parseInt( value.substring( 1 ), 10 ) :\n                            ( value.match( /[+\\-].*/ ) ? thisYear + parseInt( value, 10 ) :\n                                parseInt( value, 10 ) ) );\n                        return ( isNaN( year ) ? thisYear : year );\n                    };\n                    year = determineYear( years[ 0 ] );\n                    endYear = Math.max( year, determineYear( years[ 1 ] || \"\" ) );\n                    year = ( minDate ? Math.max( year, minDate.getFullYear() ) : year );\n                    endYear = ( maxDate ? Math.min( endYear, maxDate.getFullYear() ) : endYear );\n                    inst.yearshtml += \"<select class='ui-datepicker-year' aria-label='\" + selectYearLabel + \"' data-handler='selectYear' data-event='change'>\";\n                    for ( ; year <= endYear; year++ ) {\n                        inst.yearshtml += \"<option value='\" + year + \"'\" +\n                            ( year === drawYear ? \" selected='selected'\" : \"\" ) +\n                            \">\" + year + \"</option>\";\n                    }\n                    inst.yearshtml += \"</select>\";\n\n                    html += inst.yearshtml;\n                    inst.yearshtml = null;\n                }\n            }\n\n            html += this._get( inst, \"yearSuffix\" );\n            if ( showMonthAfterYear ) {\n                html += ( secondary || !( changeMonth && changeYear ) ? \"&#xa0;\" : \"\" ) + monthHtml;\n            }\n            html += \"</div>\"; // Close datepicker_header\n            return html;\n        },\n\n        /* Adjust one of the date sub-fields. */\n        _adjustInstDate: function( inst, offset, period ) {\n            var year = inst.selectedYear + ( period === \"Y\" ? offset : 0 ),\n                month = inst.selectedMonth + ( period === \"M\" ? offset : 0 ),\n                day = Math.min( inst.selectedDay, this._getDaysInMonth( year, month ) ) + ( period === \"D\" ? offset : 0 ),\n                date = this._restrictMinMax( inst, this._daylightSavingAdjust( new Date( year, month, day ) ) );\n\n            inst.selectedDay = date.getDate();\n            inst.drawMonth = inst.selectedMonth = date.getMonth();\n            inst.drawYear = inst.selectedYear = date.getFullYear();\n            if ( period === \"M\" || period === \"Y\" ) {\n                this._notifyChange( inst );\n            }\n        },\n\n        /* Ensure a date is within any min/max bounds. */\n        _restrictMinMax: function( inst, date ) {\n            var minDate = this._getMinMaxDate( inst, \"min\" ),\n                maxDate = this._getMinMaxDate( inst, \"max\" ),\n                newDate = ( minDate && date < minDate ? minDate : date );\n            return ( maxDate && newDate > maxDate ? maxDate : newDate );\n        },\n\n        /* Notify change of month/year. */\n        _notifyChange: function( inst ) {\n            var onChange = this._get( inst, \"onChangeMonthYear\" );\n            if ( onChange ) {\n                onChange.apply( ( inst.input ? inst.input[ 0 ] : null ),\n                    [ inst.selectedYear, inst.selectedMonth + 1, inst ] );\n            }\n        },\n\n        /* Determine the number of months to show. */\n        _getNumberOfMonths: function( inst ) {\n            var numMonths = this._get( inst, \"numberOfMonths\" );\n            return ( numMonths == null ? [ 1, 1 ] : ( typeof numMonths === \"number\" ? [ 1, numMonths ] : numMonths ) );\n        },\n\n        /* Determine the current maximum date - ensure no time components are set. */\n        _getMinMaxDate: function( inst, minMax ) {\n            return this._determineDate( inst, this._get( inst, minMax + \"Date\" ), null );\n        },\n\n        /* Find the number of days in a given month. */\n        _getDaysInMonth: function( year, month ) {\n            return 32 - this._daylightSavingAdjust( new Date( year, month, 32 ) ).getDate();\n        },\n\n        /* Find the day of the week of the first of a month. */\n        _getFirstDayOfMonth: function( year, month ) {\n            return new Date( year, month, 1 ).getDay();\n        },\n\n        /* Determines if we should allow a \"next/prev\" month display change. */\n        _canAdjustMonth: function( inst, offset, curYear, curMonth ) {\n            var numMonths = this._getNumberOfMonths( inst ),\n                date = this._daylightSavingAdjust( new Date( curYear,\n                    curMonth + ( offset < 0 ? offset : numMonths[ 0 ] * numMonths[ 1 ] ), 1 ) );\n\n            if ( offset < 0 ) {\n                date.setDate( this._getDaysInMonth( date.getFullYear(), date.getMonth() ) );\n            }\n            return this._isInRange( inst, date );\n        },\n\n        /* Is the given date in the accepted range? */\n        _isInRange: function( inst, date ) {\n            var yearSplit, currentYear,\n                minDate = this._getMinMaxDate( inst, \"min\" ),\n                maxDate = this._getMinMaxDate( inst, \"max\" ),\n                minYear = null,\n                maxYear = null,\n                years = this._get( inst, \"yearRange\" );\n            if ( years ) {\n                yearSplit = years.split( \":\" );\n                currentYear = new Date().getFullYear();\n                minYear = parseInt( yearSplit[ 0 ], 10 );\n                maxYear = parseInt( yearSplit[ 1 ], 10 );\n                if ( yearSplit[ 0 ].match( /[+\\-].*/ ) ) {\n                    minYear += currentYear;\n                }\n                if ( yearSplit[ 1 ].match( /[+\\-].*/ ) ) {\n                    maxYear += currentYear;\n                }\n            }\n\n            return ( ( !minDate || date.getTime() >= minDate.getTime() ) &&\n                ( !maxDate || date.getTime() <= maxDate.getTime() ) &&\n                ( !minYear || date.getFullYear() >= minYear ) &&\n                ( !maxYear || date.getFullYear() <= maxYear ) );\n        },\n\n        /* Provide the configuration settings for formatting/parsing. */\n        _getFormatConfig: function( inst ) {\n            var shortYearCutoff = this._get( inst, \"shortYearCutoff\" );\n            shortYearCutoff = ( typeof shortYearCutoff !== \"string\" ? shortYearCutoff :\n                new Date().getFullYear() % 100 + parseInt( shortYearCutoff, 10 ) );\n            return { shortYearCutoff: shortYearCutoff,\n                dayNamesShort: this._get( inst, \"dayNamesShort\" ), dayNames: this._get( inst, \"dayNames\" ),\n                monthNamesShort: this._get( inst, \"monthNamesShort\" ), monthNames: this._get( inst, \"monthNames\" ) };\n        },\n\n        /* Format the given date for display. */\n        _formatDate: function( inst, day, month, year ) {\n            if ( !day ) {\n                inst.currentDay = inst.selectedDay;\n                inst.currentMonth = inst.selectedMonth;\n                inst.currentYear = inst.selectedYear;\n            }\n            var date = ( day ? ( typeof day === \"object\" ? day :\n                    this._daylightSavingAdjust( new Date( year, month, day ) ) ) :\n                this._daylightSavingAdjust( new Date( inst.currentYear, inst.currentMonth, inst.currentDay ) ) );\n            return this.formatDate( this._get( inst, \"dateFormat\" ), date, this._getFormatConfig( inst ) );\n        }\n    } );\n\n    /*\n     * Bind hover events for datepicker elements.\n     * Done via delegate so the binding only occurs once in the lifetime of the parent div.\n     * Global datepicker_instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.\n     */\n    function datepicker_bindHover( dpDiv ) {\n        var selector = \"button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a\";\n        return dpDiv.on( \"mouseout\", selector, function() {\n            $( this ).removeClass( \"ui-state-hover\" );\n            if ( this.className.indexOf( \"ui-datepicker-prev\" ) !== -1 ) {\n                $( this ).removeClass( \"ui-datepicker-prev-hover\" );\n            }\n            if ( this.className.indexOf( \"ui-datepicker-next\" ) !== -1 ) {\n                $( this ).removeClass( \"ui-datepicker-next-hover\" );\n            }\n        } )\n            .on( \"mouseover\", selector, datepicker_handleMouseover );\n    }\n\n    function datepicker_handleMouseover() {\n        if ( !$.datepicker._isDisabledDatepicker( datepicker_instActive.inline ? datepicker_instActive.dpDiv.parent()[ 0 ] : datepicker_instActive.input[ 0 ] ) ) {\n            $( this ).parents( \".ui-datepicker-calendar\" ).find( \"a\" ).removeClass( \"ui-state-hover\" );\n            $( this ).addClass( \"ui-state-hover\" );\n            if ( this.className.indexOf( \"ui-datepicker-prev\" ) !== -1 ) {\n                $( this ).addClass( \"ui-datepicker-prev-hover\" );\n            }\n            if ( this.className.indexOf( \"ui-datepicker-next\" ) !== -1 ) {\n                $( this ).addClass( \"ui-datepicker-next-hover\" );\n            }\n        }\n    }\n\n    /* jQuery extend now ignores nulls! */\n    function datepicker_extendRemove( target, props ) {\n        $.extend( target, props );\n        for ( var name in props ) {\n            if ( props[ name ] == null ) {\n                target[ name ] = props[ name ];\n            }\n        }\n        return target;\n    }\n\n    /* Invoke the datepicker functionality.\n       @param  options  string - a command, optionally followed by additional parameters or\n                        Object - settings for attaching new datepicker functionality\n       @return  jQuery object */\n    $.fn.datepicker = function( options ) {\n\n        /* Verify an empty collection wasn't passed - Fixes #6976 */\n        if ( !this.length ) {\n            return this;\n        }\n\n        /* Initialise the date picker. */\n        if ( !$.datepicker.initialized ) {\n            $( document ).on( \"mousedown\", $.datepicker._checkExternalClick );\n            $.datepicker.initialized = true;\n        }\n\n        /* Append datepicker main container to body if not exist. */\n        if ( $( \"#\" + $.datepicker._mainDivId ).length === 0 ) {\n            $( \"body\" ).append( $.datepicker.dpDiv );\n        }\n\n        var otherArgs = Array.prototype.slice.call( arguments, 1 );\n        if ( typeof options === \"string\" && ( options === \"isDisabled\" || options === \"getDate\" || options === \"widget\" ) ) {\n            return $.datepicker[ \"_\" + options + \"Datepicker\" ].\n            apply( $.datepicker, [ this[ 0 ] ].concat( otherArgs ) );\n        }\n        if ( options === \"option\" && arguments.length === 2 && typeof arguments[ 1 ] === \"string\" ) {\n            return $.datepicker[ \"_\" + options + \"Datepicker\" ].\n            apply( $.datepicker, [ this[ 0 ] ].concat( otherArgs ) );\n        }\n        return this.each( function() {\n            if ( typeof options === \"string\" ) {\n                $.datepicker[ \"_\" + options + \"Datepicker\" ]\n                    .apply( $.datepicker, [ this ].concat( otherArgs ) );\n            } else {\n                $.datepicker._attachDatepicker( this, options );\n            }\n        } );\n    };\n\n    $.datepicker = new Datepicker(); // singleton instance\n    $.datepicker.initialized = false;\n    $.datepicker.uuid = new Date().getTime();\n    $.datepicker.version = \"1.13.2\";\n\n    return $.datepicker;\n\n} );\n","jquery/ui-modules/widgets/accordion.js":"/*!\n * jQuery UI Accordion 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Accordion\n//>>group: Widgets\n/* eslint-disable max-len */\n//>>description: Displays collapsible content panels for presenting information in a limited amount of space.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/accordion/\n//>>demos: http://jqueryui.com/accordion/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/accordion.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../keycode\",\n            \"../unique-id\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.accordion\", {\n        version: \"1.13.2\",\n        options: {\n            active: 0,\n            animate: {},\n            classes: {\n                \"ui-accordion-header\": \"ui-corner-top\",\n                \"ui-accordion-header-collapsed\": \"ui-corner-all\",\n                \"ui-accordion-content\": \"ui-corner-bottom\"\n            },\n            collapsible: false,\n            event: \"click\",\n            header: function( elem ) {\n                return elem.find( \"> li > :first-child\" ).add( elem.find( \"> :not(li)\" ).even() );\n            },\n            heightStyle: \"auto\",\n            icons: {\n                activeHeader: \"ui-icon-triangle-1-s\",\n                header: \"ui-icon-triangle-1-e\"\n            },\n\n            // Callbacks\n            activate: null,\n            beforeActivate: null\n        },\n\n        hideProps: {\n            borderTopWidth: \"hide\",\n            borderBottomWidth: \"hide\",\n            paddingTop: \"hide\",\n            paddingBottom: \"hide\",\n            height: \"hide\"\n        },\n\n        showProps: {\n            borderTopWidth: \"show\",\n            borderBottomWidth: \"show\",\n            paddingTop: \"show\",\n            paddingBottom: \"show\",\n            height: \"show\"\n        },\n\n        _create: function() {\n            var options = this.options;\n\n            this.prevShow = this.prevHide = $();\n            this._addClass( \"ui-accordion\", \"ui-widget ui-helper-reset\" );\n            this.element.attr( \"role\", \"tablist\" );\n\n            // Don't allow collapsible: false and active: false / null\n            if ( !options.collapsible && ( options.active === false || options.active == null ) ) {\n                options.active = 0;\n            }\n\n            this._processPanels();\n\n            // handle negative values\n            if ( options.active < 0 ) {\n                options.active += this.headers.length;\n            }\n            this._refresh();\n        },\n\n        _getCreateEventData: function() {\n            return {\n                header: this.active,\n                panel: !this.active.length ? $() : this.active.next()\n            };\n        },\n\n        _createIcons: function() {\n            var icon, children,\n                icons = this.options.icons;\n\n            if ( icons ) {\n                icon = $( \"<span>\" );\n                this._addClass( icon, \"ui-accordion-header-icon\", \"ui-icon \" + icons.header );\n                icon.prependTo( this.headers );\n                children = this.active.children( \".ui-accordion-header-icon\" );\n                this._removeClass( children, icons.header )\n                    ._addClass( children, null, icons.activeHeader )\n                    ._addClass( this.headers, \"ui-accordion-icons\" );\n            }\n        },\n\n        _destroyIcons: function() {\n            this._removeClass( this.headers, \"ui-accordion-icons\" );\n            this.headers.children( \".ui-accordion-header-icon\" ).remove();\n        },\n\n        _destroy: function() {\n            var contents;\n\n            // Clean up main element\n            this.element.removeAttr( \"role\" );\n\n            // Clean up headers\n            this.headers\n                .removeAttr( \"role aria-expanded aria-selected aria-controls tabIndex\" )\n                .removeUniqueId();\n\n            this._destroyIcons();\n\n            // Clean up content panels\n            contents = this.headers.next()\n                .css( \"display\", \"\" )\n                .removeAttr( \"role aria-hidden aria-labelledby\" )\n                .removeUniqueId();\n\n            if ( this.options.heightStyle !== \"content\" ) {\n                contents.css( \"height\", \"\" );\n            }\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"active\" ) {\n\n                // _activate() will handle invalid values and update this.options\n                this._activate( value );\n                return;\n            }\n\n            if ( key === \"event\" ) {\n                if ( this.options.event ) {\n                    this._off( this.headers, this.options.event );\n                }\n                this._setupEvents( value );\n            }\n\n            this._super( key, value );\n\n            // Setting collapsible: false while collapsed; open first panel\n            if ( key === \"collapsible\" && !value && this.options.active === false ) {\n                this._activate( 0 );\n            }\n\n            if ( key === \"icons\" ) {\n                this._destroyIcons();\n                if ( value ) {\n                    this._createIcons();\n                }\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this.element.attr( \"aria-disabled\", value );\n\n            // Support: IE8 Only\n            // #5332 / #6059 - opacity doesn't cascade to positioned elements in IE\n            // so we need to add the disabled class to the headers and panels\n            this._toggleClass( null, \"ui-state-disabled\", !!value );\n            this._toggleClass( this.headers.add( this.headers.next() ), null, \"ui-state-disabled\",\n                !!value );\n        },\n\n        _keydown: function( event ) {\n            if ( event.altKey || event.ctrlKey ) {\n                return;\n            }\n\n            var keyCode = $.ui.keyCode,\n                length = this.headers.length,\n                currentIndex = this.headers.index( event.target ),\n                toFocus = false;\n\n            switch ( event.keyCode ) {\n                case keyCode.RIGHT:\n                case keyCode.DOWN:\n                    toFocus = this.headers[ ( currentIndex + 1 ) % length ];\n                    break;\n                case keyCode.LEFT:\n                case keyCode.UP:\n                    toFocus = this.headers[ ( currentIndex - 1 + length ) % length ];\n                    break;\n                case keyCode.SPACE:\n                case keyCode.ENTER:\n                    this._eventHandler( event );\n                    break;\n                case keyCode.HOME:\n                    toFocus = this.headers[ 0 ];\n                    break;\n                case keyCode.END:\n                    toFocus = this.headers[ length - 1 ];\n                    break;\n            }\n\n            if ( toFocus ) {\n                $( event.target ).attr( \"tabIndex\", -1 );\n                $( toFocus ).attr( \"tabIndex\", 0 );\n                $( toFocus ).trigger( \"focus\" );\n                event.preventDefault();\n            }\n        },\n\n        _panelKeyDown: function( event ) {\n            if ( event.keyCode === $.ui.keyCode.UP && event.ctrlKey ) {\n                $( event.currentTarget ).prev().trigger( \"focus\" );\n            }\n        },\n\n        refresh: function() {\n            var options = this.options;\n            this._processPanels();\n\n            // Was collapsed or no panel\n            if ( ( options.active === false && options.collapsible === true ) ||\n                !this.headers.length ) {\n                options.active = false;\n                this.active = $();\n\n                // active false only when collapsible is true\n            } else if ( options.active === false ) {\n                this._activate( 0 );\n\n                // was active, but active panel is gone\n            } else if ( this.active.length && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {\n\n                // all remaining panel are disabled\n                if ( this.headers.length === this.headers.find( \".ui-state-disabled\" ).length ) {\n                    options.active = false;\n                    this.active = $();\n\n                    // activate previous panel\n                } else {\n                    this._activate( Math.max( 0, options.active - 1 ) );\n                }\n\n                // was active, active panel still exists\n            } else {\n\n                // make sure active index is correct\n                options.active = this.headers.index( this.active );\n            }\n\n            this._destroyIcons();\n\n            this._refresh();\n        },\n\n        _processPanels: function() {\n            var prevHeaders = this.headers,\n                prevPanels = this.panels;\n\n            if ( typeof this.options.header === \"function\" ) {\n                this.headers = this.options.header( this.element );\n            } else {\n                this.headers = this.element.find( this.options.header );\n            }\n            this._addClass( this.headers, \"ui-accordion-header ui-accordion-header-collapsed\",\n                \"ui-state-default\" );\n\n            this.panels = this.headers.next().filter( \":not(.ui-accordion-content-active)\" ).hide();\n            this._addClass( this.panels, \"ui-accordion-content\", \"ui-helper-reset ui-widget-content\" );\n\n            // Avoid memory leaks (#10056)\n            if ( prevPanels ) {\n                this._off( prevHeaders.not( this.headers ) );\n                this._off( prevPanels.not( this.panels ) );\n            }\n        },\n\n        _refresh: function() {\n            var maxHeight,\n                options = this.options,\n                heightStyle = options.heightStyle,\n                parent = this.element.parent();\n\n            this.active = this._findActive( options.active );\n            this._addClass( this.active, \"ui-accordion-header-active\", \"ui-state-active\" )\n                ._removeClass( this.active, \"ui-accordion-header-collapsed\" );\n            this._addClass( this.active.next(), \"ui-accordion-content-active\" );\n            this.active.next().show();\n\n            this.headers\n                .attr( \"role\", \"tab\" )\n                .each( function() {\n                    var header = $( this ),\n                        headerId = header.uniqueId().attr( \"id\" ),\n                        panel = header.next(),\n                        panelId = panel.uniqueId().attr( \"id\" );\n                    header.attr( \"aria-controls\", panelId );\n                    panel.attr( \"aria-labelledby\", headerId );\n                } )\n                .next()\n                .attr( \"role\", \"tabpanel\" );\n\n            this.headers\n                .not( this.active )\n                .attr( {\n                    \"aria-selected\": \"false\",\n                    \"aria-expanded\": \"false\",\n                    tabIndex: -1\n                } )\n                .next()\n                .attr( {\n                    \"aria-hidden\": \"true\"\n                } )\n                .hide();\n\n            // Make sure at least one header is in the tab order\n            if ( !this.active.length ) {\n                this.headers.eq( 0 ).attr( \"tabIndex\", 0 );\n            } else {\n                this.active.attr( {\n                    \"aria-selected\": \"true\",\n                    \"aria-expanded\": \"true\",\n                    tabIndex: 0\n                } )\n                    .next()\n                    .attr( {\n                        \"aria-hidden\": \"false\"\n                    } );\n            }\n\n            this._createIcons();\n\n            this._setupEvents( options.event );\n\n            if ( heightStyle === \"fill\" ) {\n                maxHeight = parent.height();\n                this.element.siblings( \":visible\" ).each( function() {\n                    var elem = $( this ),\n                        position = elem.css( \"position\" );\n\n                    if ( position === \"absolute\" || position === \"fixed\" ) {\n                        return;\n                    }\n                    maxHeight -= elem.outerHeight( true );\n                } );\n\n                this.headers.each( function() {\n                    maxHeight -= $( this ).outerHeight( true );\n                } );\n\n                this.headers.next()\n                    .each( function() {\n                        $( this ).height( Math.max( 0, maxHeight -\n                            $( this ).innerHeight() + $( this ).height() ) );\n                    } )\n                    .css( \"overflow\", \"auto\" );\n            } else if ( heightStyle === \"auto\" ) {\n                maxHeight = 0;\n                this.headers.next()\n                    .each( function() {\n                        var isVisible = $( this ).is( \":visible\" );\n                        if ( !isVisible ) {\n                            $( this ).show();\n                        }\n                        maxHeight = Math.max( maxHeight, $( this ).css( \"height\", \"\" ).height() );\n                        if ( !isVisible ) {\n                            $( this ).hide();\n                        }\n                    } )\n                    .height( maxHeight );\n            }\n        },\n\n        _activate: function( index ) {\n            var active = this._findActive( index )[ 0 ];\n\n            // Trying to activate the already active panel\n            if ( active === this.active[ 0 ] ) {\n                return;\n            }\n\n            // Trying to collapse, simulate a click on the currently active header\n            active = active || this.active[ 0 ];\n\n            this._eventHandler( {\n                target: active,\n                currentTarget: active,\n                preventDefault: $.noop\n            } );\n        },\n\n        _findActive: function( selector ) {\n            return typeof selector === \"number\" ? this.headers.eq( selector ) : $();\n        },\n\n        _setupEvents: function( event ) {\n            var events = {\n                keydown: \"_keydown\"\n            };\n            if ( event ) {\n                $.each( event.split( \" \" ), function( index, eventName ) {\n                    events[ eventName ] = \"_eventHandler\";\n                } );\n            }\n\n            this._off( this.headers.add( this.headers.next() ) );\n            this._on( this.headers, events );\n            this._on( this.headers.next(), { keydown: \"_panelKeyDown\" } );\n            this._hoverable( this.headers );\n            this._focusable( this.headers );\n        },\n\n        _eventHandler: function( event ) {\n            var activeChildren, clickedChildren,\n                options = this.options,\n                active = this.active,\n                clicked = $( event.currentTarget ),\n                clickedIsActive = clicked[ 0 ] === active[ 0 ],\n                collapsing = clickedIsActive && options.collapsible,\n                toShow = collapsing ? $() : clicked.next(),\n                toHide = active.next(),\n                eventData = {\n                    oldHeader: active,\n                    oldPanel: toHide,\n                    newHeader: collapsing ? $() : clicked,\n                    newPanel: toShow\n                };\n\n            event.preventDefault();\n\n            if (\n\n                // click on active header, but not collapsible\n                ( clickedIsActive && !options.collapsible ) ||\n\n                // allow canceling activation\n                ( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n                return;\n            }\n\n            options.active = collapsing ? false : this.headers.index( clicked );\n\n            // When the call to ._toggle() comes after the class changes\n            // it causes a very odd bug in IE 8 (see #6720)\n            this.active = clickedIsActive ? $() : clicked;\n            this._toggle( eventData );\n\n            // Switch classes\n            // corner classes on the previously active header stay after the animation\n            this._removeClass( active, \"ui-accordion-header-active\", \"ui-state-active\" );\n            if ( options.icons ) {\n                activeChildren = active.children( \".ui-accordion-header-icon\" );\n                this._removeClass( activeChildren, null, options.icons.activeHeader )\n                    ._addClass( activeChildren, null, options.icons.header );\n            }\n\n            if ( !clickedIsActive ) {\n                this._removeClass( clicked, \"ui-accordion-header-collapsed\" )\n                    ._addClass( clicked, \"ui-accordion-header-active\", \"ui-state-active\" );\n                if ( options.icons ) {\n                    clickedChildren = clicked.children( \".ui-accordion-header-icon\" );\n                    this._removeClass( clickedChildren, null, options.icons.header )\n                        ._addClass( clickedChildren, null, options.icons.activeHeader );\n                }\n\n                this._addClass( clicked.next(), \"ui-accordion-content-active\" );\n            }\n        },\n\n        _toggle: function( data ) {\n            var toShow = data.newPanel,\n                toHide = this.prevShow.length ? this.prevShow : data.oldPanel;\n\n            // Handle activating a panel during the animation for another activation\n            this.prevShow.add( this.prevHide ).stop( true, true );\n            this.prevShow = toShow;\n            this.prevHide = toHide;\n\n            if ( this.options.animate ) {\n                this._animate( toShow, toHide, data );\n            } else {\n                toHide.hide();\n                toShow.show();\n                this._toggleComplete( data );\n            }\n\n            toHide.attr( {\n                \"aria-hidden\": \"true\"\n            } );\n            toHide.prev().attr( {\n                \"aria-selected\": \"false\",\n                \"aria-expanded\": \"false\"\n            } );\n\n            // if we're switching panels, remove the old header from the tab order\n            // if we're opening from collapsed state, remove the previous header from the tab order\n            // if we're collapsing, then keep the collapsing header in the tab order\n            if ( toShow.length && toHide.length ) {\n                toHide.prev().attr( {\n                    \"tabIndex\": -1,\n                    \"aria-expanded\": \"false\"\n                } );\n            } else if ( toShow.length ) {\n                this.headers.filter( function() {\n                    return parseInt( $( this ).attr( \"tabIndex\" ), 10 ) === 0;\n                } )\n                    .attr( \"tabIndex\", -1 );\n            }\n\n            toShow\n                .attr( \"aria-hidden\", \"false\" )\n                .prev()\n                .attr( {\n                    \"aria-selected\": \"true\",\n                    \"aria-expanded\": \"true\",\n                    tabIndex: 0\n                } );\n        },\n\n        _animate: function( toShow, toHide, data ) {\n            var total, easing, duration,\n                that = this,\n                adjust = 0,\n                boxSizing = toShow.css( \"box-sizing\" ),\n                down = toShow.length &&\n                    ( !toHide.length || ( toShow.index() < toHide.index() ) ),\n                animate = this.options.animate || {},\n                options = down && animate.down || animate,\n                complete = function() {\n                    that._toggleComplete( data );\n                };\n\n            if ( typeof options === \"number\" ) {\n                duration = options;\n            }\n            if ( typeof options === \"string\" ) {\n                easing = options;\n            }\n\n            // fall back from options to animation in case of partial down settings\n            easing = easing || options.easing || animate.easing;\n            duration = duration || options.duration || animate.duration;\n\n            if ( !toHide.length ) {\n                return toShow.animate( this.showProps, duration, easing, complete );\n            }\n            if ( !toShow.length ) {\n                return toHide.animate( this.hideProps, duration, easing, complete );\n            }\n\n            total = toShow.show().outerHeight();\n            toHide.animate( this.hideProps, {\n                duration: duration,\n                easing: easing,\n                step: function( now, fx ) {\n                    fx.now = Math.round( now );\n                }\n            } );\n            toShow\n                .hide()\n                .animate( this.showProps, {\n                    duration: duration,\n                    easing: easing,\n                    complete: complete,\n                    step: function( now, fx ) {\n                        fx.now = Math.round( now );\n                        if ( fx.prop !== \"height\" ) {\n                            if ( boxSizing === \"content-box\" ) {\n                                adjust += fx.now;\n                            }\n                        } else if ( that.options.heightStyle !== \"content\" ) {\n                            fx.now = Math.round( total - toHide.outerHeight() - adjust );\n                            adjust = 0;\n                        }\n                    }\n                } );\n        },\n\n        _toggleComplete: function( data ) {\n            var toHide = data.oldPanel,\n                prev = toHide.prev();\n\n            this._removeClass( toHide, \"ui-accordion-content-active\" );\n            this._removeClass( prev, \"ui-accordion-header-active\" )\n                ._addClass( prev, \"ui-accordion-header-collapsed\" );\n\n            // Work around for rendering bug in IE (#5421)\n            if ( toHide.length ) {\n                toHide.parent()[ 0 ].className = toHide.parent()[ 0 ].className;\n            }\n            this._trigger( \"activate\", null, data );\n        }\n    } );\n\n} );\n","jquery/ui-modules/vendor/jquery-color/jquery.color.js":"/*!\n * jQuery Color Animations v2.2.0\n * https://github.com/jquery/jquery-color\n *\n * Copyright OpenJS Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * Date: Sun May 10 09:02:36 2020 +0200\n */\n\n( function( root, factory ) {\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\" ], factory );\n\t} else if ( typeof exports === \"object\" ) {\n\t\tmodule.exports = factory( require( \"jquery\" ) );\n\t} else {\n\t\tfactory( root.jQuery );\n\t}\n} )( this, function( jQuery, undefined ) {\n\n\tvar stepHooks = \"backgroundColor borderBottomColor borderLeftColor borderRightColor \" +\n\t\t\"borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor\",\n\n\tclass2type = {},\n\ttoString = class2type.toString,\n\n\t// plusequals test for += 100 -= 100\n\trplusequals = /^([\\-+])=\\s*(\\d+\\.?\\d*)/,\n\n\t// a set of RE's that can match strings and generate color tuples.\n\tstringParsers = [ {\n\t\t\tre: /rgba?\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ],\n\t\t\t\t\texecResult[ 3 ],\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /rgba?\\(\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ] * 2.55,\n\t\t\t\t\texecResult[ 2 ] * 2.55,\n\t\t\t\t\texecResult[ 3 ] * 2.55,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ], 16 ),\n\t\t\t\t\texecResult[ 4 ] ?\n\t\t\t\t\t\t( parseInt( execResult[ 4 ], 16 ) / 255 ).toFixed( 2 ) :\n\t\t\t\t\t\t1\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ] + execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ] + execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ] + execResult[ 3 ], 16 ),\n\t\t\t\t\texecResult[ 4 ] ?\n\t\t\t\t\t\t( parseInt( execResult[ 4 ] + execResult[ 4 ], 16 ) / 255 )\n\t\t\t\t\t\t\t.toFixed( 2 ) :\n\t\t\t\t\t\t1\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /hsla?\\(\\s*(\\d+(?:\\.\\d+)?)\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tspace: \"hsla\",\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ] / 100,\n\t\t\t\t\texecResult[ 3 ] / 100,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t} ],\n\n\t// jQuery.Color( )\n\tcolor = jQuery.Color = function( color, green, blue, alpha ) {\n\t\treturn new jQuery.Color.fn.parse( color, green, blue, alpha );\n\t},\n\tspaces = {\n\t\trgba: {\n\t\t\tprops: {\n\t\t\t\tred: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tgreen: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tblue: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\thsla: {\n\t\t\tprops: {\n\t\t\t\thue: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"degrees\"\n\t\t\t\t},\n\t\t\t\tsaturation: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t},\n\t\t\t\tlightness: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\tpropTypes = {\n\t\t\"byte\": {\n\t\t\tfloor: true,\n\t\t\tmax: 255\n\t\t},\n\t\t\"percent\": {\n\t\t\tmax: 1\n\t\t},\n\t\t\"degrees\": {\n\t\t\tmod: 360,\n\t\t\tfloor: true\n\t\t}\n\t},\n\tsupport = color.support = {},\n\n\t// element for support tests\n\tsupportElem = jQuery( \"<p>\" )[ 0 ],\n\n\t// colors = jQuery.Color.names\n\tcolors,\n\n\t// local aliases of functions called often\n\teach = jQuery.each;\n\n// determine rgba support immediately\nsupportElem.style.cssText = \"background-color:rgba(1,1,1,.5)\";\nsupport.rgba = supportElem.style.backgroundColor.indexOf( \"rgba\" ) > -1;\n\n// define cache name and alpha properties\n// for rgba and hsla spaces\neach( spaces, function( spaceName, space ) {\n\tspace.cache = \"_\" + spaceName;\n\tspace.props.alpha = {\n\t\tidx: 3,\n\t\ttype: \"percent\",\n\t\tdef: 1\n\t};\n} );\n\n// Populate the class2type map\njQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".split( \" \" ),\n\tfunction( _i, name ) {\n\t\tclass2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n\t} );\n\nfunction getType( obj ) {\n\tif ( obj == null ) {\n\t\treturn obj + \"\";\n\t}\n\n\treturn typeof obj === \"object\" ?\n\t\tclass2type[ toString.call( obj ) ] || \"object\" :\n\t\ttypeof obj;\n}\n\nfunction clamp( value, prop, allowEmpty ) {\n\tvar type = propTypes[ prop.type ] || {};\n\n\tif ( value == null ) {\n\t\treturn ( allowEmpty || !prop.def ) ? null : prop.def;\n\t}\n\n\t// ~~ is an short way of doing floor for positive numbers\n\tvalue = type.floor ? ~~value : parseFloat( value );\n\n\t// IE will pass in empty strings as value for alpha,\n\t// which will hit this case\n\tif ( isNaN( value ) ) {\n\t\treturn prop.def;\n\t}\n\n\tif ( type.mod ) {\n\n\t\t// we add mod before modding to make sure that negatives values\n\t\t// get converted properly: -10 -> 350\n\t\treturn ( value + type.mod ) % type.mod;\n\t}\n\n\t// for now all property types without mod have min and max\n\treturn Math.min( type.max, Math.max( 0, value ) );\n}\n\nfunction stringParse( string ) {\n\tvar inst = color(),\n\t\trgba = inst._rgba = [];\n\n\tstring = string.toLowerCase();\n\n\teach( stringParsers, function( _i, parser ) {\n\t\tvar parsed,\n\t\t\tmatch = parser.re.exec( string ),\n\t\t\tvalues = match && parser.parse( match ),\n\t\t\tspaceName = parser.space || \"rgba\";\n\n\t\tif ( values ) {\n\t\t\tparsed = inst[ spaceName ]( values );\n\n\t\t\t// if this was an rgba parse the assignment might happen twice\n\t\t\t// oh well....\n\t\t\tinst[ spaces[ spaceName ].cache ] = parsed[ spaces[ spaceName ].cache ];\n\t\t\trgba = inst._rgba = parsed._rgba;\n\n\t\t\t// exit each( stringParsers ) here because we matched\n\t\t\treturn false;\n\t\t}\n\t} );\n\n\t// Found a stringParser that handled it\n\tif ( rgba.length ) {\n\n\t\t// if this came from a parsed string, force \"transparent\" when alpha is 0\n\t\t// chrome, (and maybe others) return \"transparent\" as rgba(0,0,0,0)\n\t\tif ( rgba.join() === \"0,0,0,0\" ) {\n\t\t\tjQuery.extend( rgba, colors.transparent );\n\t\t}\n\t\treturn inst;\n\t}\n\n\t// named colors\n\treturn colors[ string ];\n}\n\ncolor.fn = jQuery.extend( color.prototype, {\n\tparse: function( red, green, blue, alpha ) {\n\t\tif ( red === undefined ) {\n\t\t\tthis._rgba = [ null, null, null, null ];\n\t\t\treturn this;\n\t\t}\n\t\tif ( red.jquery || red.nodeType ) {\n\t\t\tred = jQuery( red ).css( green );\n\t\t\tgreen = undefined;\n\t\t}\n\n\t\tvar inst = this,\n\t\t\ttype = getType( red ),\n\t\t\trgba = this._rgba = [];\n\n\t\t// more than 1 argument specified - assume ( red, green, blue, alpha )\n\t\tif ( green !== undefined ) {\n\t\t\tred = [ red, green, blue, alpha ];\n\t\t\ttype = \"array\";\n\t\t}\n\n\t\tif ( type === \"string\" ) {\n\t\t\treturn this.parse( stringParse( red ) || colors._default );\n\t\t}\n\n\t\tif ( type === \"array\" ) {\n\t\t\teach( spaces.rgba.props, function( _key, prop ) {\n\t\t\t\trgba[ prop.idx ] = clamp( red[ prop.idx ], prop );\n\t\t\t} );\n\t\t\treturn this;\n\t\t}\n\n\t\tif ( type === \"object\" ) {\n\t\t\tif ( red instanceof color ) {\n\t\t\t\teach( spaces, function( _spaceName, space ) {\n\t\t\t\t\tif ( red[ space.cache ] ) {\n\t\t\t\t\t\tinst[ space.cache ] = red[ space.cache ].slice();\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t} else {\n\t\t\t\teach( spaces, function( _spaceName, space ) {\n\t\t\t\t\tvar cache = space.cache;\n\t\t\t\t\teach( space.props, function( key, prop ) {\n\n\t\t\t\t\t\t// if the cache doesn't exist, and we know how to convert\n\t\t\t\t\t\tif ( !inst[ cache ] && space.to ) {\n\n\t\t\t\t\t\t\t// if the value was null, we don't need to copy it\n\t\t\t\t\t\t\t// if the key was alpha, we don't need to copy it either\n\t\t\t\t\t\t\tif ( key === \"alpha\" || red[ key ] == null ) {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tinst[ cache ] = space.to( inst._rgba );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// this is the only case where we allow nulls for ALL properties.\n\t\t\t\t\t\t// call clamp with alwaysAllowEmpty\n\t\t\t\t\t\tinst[ cache ][ prop.idx ] = clamp( red[ key ], prop, true );\n\t\t\t\t\t} );\n\n\t\t\t\t\t// everything defined but alpha?\n\t\t\t\t\tif ( inst[ cache ] && jQuery.inArray( null, inst[ cache ].slice( 0, 3 ) ) < 0 ) {\n\n\t\t\t\t\t\t// use the default of 1\n\t\t\t\t\t\tif ( inst[ cache ][ 3 ] == null ) {\n\t\t\t\t\t\t\tinst[ cache ][ 3 ] = 1;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif ( space.from ) {\n\t\t\t\t\t\t\tinst._rgba = space.from( inst[ cache ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\t},\n\tis: function( compare ) {\n\t\tvar is = color( compare ),\n\t\t\tsame = true,\n\t\t\tinst = this;\n\n\t\teach( spaces, function( _, space ) {\n\t\t\tvar localCache,\n\t\t\t\tisCache = is[ space.cache ];\n\t\t\tif ( isCache ) {\n\t\t\t\tlocalCache = inst[ space.cache ] || space.to && space.to( inst._rgba ) || [];\n\t\t\t\teach( space.props, function( _, prop ) {\n\t\t\t\t\tif ( isCache[ prop.idx ] != null ) {\n\t\t\t\t\t\tsame = ( isCache[ prop.idx ] === localCache[ prop.idx ] );\n\t\t\t\t\t\treturn same;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\treturn same;\n\t\t} );\n\t\treturn same;\n\t},\n\t_space: function() {\n\t\tvar used = [],\n\t\t\tinst = this;\n\t\teach( spaces, function( spaceName, space ) {\n\t\t\tif ( inst[ space.cache ] ) {\n\t\t\t\tused.push( spaceName );\n\t\t\t}\n\t\t} );\n\t\treturn used.pop();\n\t},\n\ttransition: function( other, distance ) {\n\t\tvar end = color( other ),\n\t\t\tspaceName = end._space(),\n\t\t\tspace = spaces[ spaceName ],\n\t\t\tstartColor = this.alpha() === 0 ? color( \"transparent\" ) : this,\n\t\t\tstart = startColor[ space.cache ] || space.to( startColor._rgba ),\n\t\t\tresult = start.slice();\n\n\t\tend = end[ space.cache ];\n\t\teach( space.props, function( _key, prop ) {\n\t\t\tvar index = prop.idx,\n\t\t\t\tstartValue = start[ index ],\n\t\t\t\tendValue = end[ index ],\n\t\t\t\ttype = propTypes[ prop.type ] || {};\n\n\t\t\t// if null, don't override start value\n\t\t\tif ( endValue === null ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// if null - use end\n\t\t\tif ( startValue === null ) {\n\t\t\t\tresult[ index ] = endValue;\n\t\t\t} else {\n\t\t\t\tif ( type.mod ) {\n\t\t\t\t\tif ( endValue - startValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue += type.mod;\n\t\t\t\t\t} else if ( startValue - endValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue -= type.mod;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tresult[ index ] = clamp( ( endValue - startValue ) * distance + startValue, prop );\n\t\t\t}\n\t\t} );\n\t\treturn this[ spaceName ]( result );\n\t},\n\tblend: function( opaque ) {\n\n\t\t// if we are already opaque - return ourself\n\t\tif ( this._rgba[ 3 ] === 1 ) {\n\t\t\treturn this;\n\t\t}\n\n\t\tvar rgb = this._rgba.slice(),\n\t\t\ta = rgb.pop(),\n\t\t\tblend = color( opaque )._rgba;\n\n\t\treturn color( jQuery.map( rgb, function( v, i ) {\n\t\t\treturn ( 1 - a ) * blend[ i ] + a * v;\n\t\t} ) );\n\t},\n\ttoRgbaString: function() {\n\t\tvar prefix = \"rgba(\",\n\t\t\trgba = jQuery.map( this._rgba, function( v, i ) {\n\t\t\t\tif ( v != null ) {\n\t\t\t\t\treturn v;\n\t\t\t\t}\n\t\t\t\treturn i > 2 ? 1 : 0;\n\t\t\t} );\n\n\t\tif ( rgba[ 3 ] === 1 ) {\n\t\t\trgba.pop();\n\t\t\tprefix = \"rgb(\";\n\t\t}\n\n\t\treturn prefix + rgba.join() + \")\";\n\t},\n\ttoHslaString: function() {\n\t\tvar prefix = \"hsla(\",\n\t\t\thsla = jQuery.map( this.hsla(), function( v, i ) {\n\t\t\t\tif ( v == null ) {\n\t\t\t\t\tv = i > 2 ? 1 : 0;\n\t\t\t\t}\n\n\t\t\t\t// catch 1 and 2\n\t\t\t\tif ( i && i < 3 ) {\n\t\t\t\t\tv = Math.round( v * 100 ) + \"%\";\n\t\t\t\t}\n\t\t\t\treturn v;\n\t\t\t} );\n\n\t\tif ( hsla[ 3 ] === 1 ) {\n\t\t\thsla.pop();\n\t\t\tprefix = \"hsl(\";\n\t\t}\n\t\treturn prefix + hsla.join() + \")\";\n\t},\n\ttoHexString: function( includeAlpha ) {\n\t\tvar rgba = this._rgba.slice(),\n\t\t\talpha = rgba.pop();\n\n\t\tif ( includeAlpha ) {\n\t\t\trgba.push( ~~( alpha * 255 ) );\n\t\t}\n\n\t\treturn \"#\" + jQuery.map( rgba, function( v ) {\n\n\t\t\t// default to 0 when nulls exist\n\t\t\tv = ( v || 0 ).toString( 16 );\n\t\t\treturn v.length === 1 ? \"0\" + v : v;\n\t\t} ).join( \"\" );\n\t},\n\ttoString: function() {\n\t\treturn this._rgba[ 3 ] === 0 ? \"transparent\" : this.toRgbaString();\n\t}\n} );\ncolor.fn.parse.prototype = color.fn;\n\n// hsla conversions adapted from:\n// https://code.google.com/p/maashaack/source/browse/packages/graphics/trunk/src/graphics/colors/HUE2RGB.as?r=5021\n\nfunction hue2rgb( p, q, h ) {\n\th = ( h + 1 ) % 1;\n\tif ( h * 6 < 1 ) {\n\t\treturn p + ( q - p ) * h * 6;\n\t}\n\tif ( h * 2 < 1 ) {\n\t\treturn q;\n\t}\n\tif ( h * 3 < 2 ) {\n\t\treturn p + ( q - p ) * ( ( 2 / 3 ) - h ) * 6;\n\t}\n\treturn p;\n}\n\nspaces.hsla.to = function( rgba ) {\n\tif ( rgba[ 0 ] == null || rgba[ 1 ] == null || rgba[ 2 ] == null ) {\n\t\treturn [ null, null, null, rgba[ 3 ] ];\n\t}\n\tvar r = rgba[ 0 ] / 255,\n\t\tg = rgba[ 1 ] / 255,\n\t\tb = rgba[ 2 ] / 255,\n\t\ta = rgba[ 3 ],\n\t\tmax = Math.max( r, g, b ),\n\t\tmin = Math.min( r, g, b ),\n\t\tdiff = max - min,\n\t\tadd = max + min,\n\t\tl = add * 0.5,\n\t\th, s;\n\n\tif ( min === max ) {\n\t\th = 0;\n\t} else if ( r === max ) {\n\t\th = ( 60 * ( g - b ) / diff ) + 360;\n\t} else if ( g === max ) {\n\t\th = ( 60 * ( b - r ) / diff ) + 120;\n\t} else {\n\t\th = ( 60 * ( r - g ) / diff ) + 240;\n\t}\n\n\t// chroma (diff) == 0 means greyscale which, by definition, saturation = 0%\n\t// otherwise, saturation is based on the ratio of chroma (diff) to lightness (add)\n\tif ( diff === 0 ) {\n\t\ts = 0;\n\t} else if ( l <= 0.5 ) {\n\t\ts = diff / add;\n\t} else {\n\t\ts = diff / ( 2 - add );\n\t}\n\treturn [ Math.round( h ) % 360, s, l, a == null ? 1 : a ];\n};\n\nspaces.hsla.from = function( hsla ) {\n\tif ( hsla[ 0 ] == null || hsla[ 1 ] == null || hsla[ 2 ] == null ) {\n\t\treturn [ null, null, null, hsla[ 3 ] ];\n\t}\n\tvar h = hsla[ 0 ] / 360,\n\t\ts = hsla[ 1 ],\n\t\tl = hsla[ 2 ],\n\t\ta = hsla[ 3 ],\n\t\tq = l <= 0.5 ? l * ( 1 + s ) : l + s - l * s,\n\t\tp = 2 * l - q;\n\n\treturn [\n\t\tMath.round( hue2rgb( p, q, h + ( 1 / 3 ) ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h - ( 1 / 3 ) ) * 255 ),\n\t\ta\n\t];\n};\n\n\neach( spaces, function( spaceName, space ) {\n\tvar props = space.props,\n\t\tcache = space.cache,\n\t\tto = space.to,\n\t\tfrom = space.from;\n\n\t// makes rgba() and hsla()\n\tcolor.fn[ spaceName ] = function( value ) {\n\n\t\t// generate a cache for this space if it doesn't exist\n\t\tif ( to && !this[ cache ] ) {\n\t\t\tthis[ cache ] = to( this._rgba );\n\t\t}\n\t\tif ( value === undefined ) {\n\t\t\treturn this[ cache ].slice();\n\t\t}\n\n\t\tvar ret,\n\t\t\ttype = getType( value ),\n\t\t\tarr = ( type === \"array\" || type === \"object\" ) ? value : arguments,\n\t\t\tlocal = this[ cache ].slice();\n\n\t\teach( props, function( key, prop ) {\n\t\t\tvar val = arr[ type === \"object\" ? key : prop.idx ];\n\t\t\tif ( val == null ) {\n\t\t\t\tval = local[ prop.idx ];\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = clamp( val, prop );\n\t\t} );\n\n\t\tif ( from ) {\n\t\t\tret = color( from( local ) );\n\t\t\tret[ cache ] = local;\n\t\t\treturn ret;\n\t\t} else {\n\t\t\treturn color( local );\n\t\t}\n\t};\n\n\t// makes red() green() blue() alpha() hue() saturation() lightness()\n\teach( props, function( key, prop ) {\n\n\t\t// alpha is included in more than one space\n\t\tif ( color.fn[ key ] ) {\n\t\t\treturn;\n\t\t}\n\t\tcolor.fn[ key ] = function( value ) {\n\t\t\tvar local, cur, match, fn,\n\t\t\t\tvtype = getType( value );\n\n\t\t\tif ( key === \"alpha\" ) {\n\t\t\t\tfn = this._hsla ? \"hsla\" : \"rgba\";\n\t\t\t} else {\n\t\t\t\tfn = spaceName;\n\t\t\t}\n\t\t\tlocal = this[ fn ]();\n\t\t\tcur = local[ prop.idx ];\n\n\t\t\tif ( vtype === \"undefined\" ) {\n\t\t\t\treturn cur;\n\t\t\t}\n\n\t\t\tif ( vtype === \"function\" ) {\n\t\t\t\tvalue = value.call( this, cur );\n\t\t\t\tvtype = getType( value );\n\t\t\t}\n\t\t\tif ( value == null && prop.empty ) {\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( vtype === \"string\" ) {\n\t\t\t\tmatch = rplusequals.exec( value );\n\t\t\t\tif ( match ) {\n\t\t\t\t\tvalue = cur + parseFloat( match[ 2 ] ) * ( match[ 1 ] === \"+\" ? 1 : -1 );\n\t\t\t\t}\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = value;\n\t\t\treturn this[ fn ]( local );\n\t\t};\n\t} );\n} );\n\n// add cssHook and .fx.step function for each named hook.\n// accept a space separated string of properties\ncolor.hook = function( hook ) {\n\tvar hooks = hook.split( \" \" );\n\teach( hooks, function( _i, hook ) {\n\t\tjQuery.cssHooks[ hook ] = {\n\t\t\tset: function( elem, value ) {\n\t\t\t\tvar parsed, curElem,\n\t\t\t\t\tbackgroundColor = \"\";\n\n\t\t\t\tif ( value !== \"transparent\" && ( getType( value ) !== \"string\" || ( parsed = stringParse( value ) ) ) ) {\n\t\t\t\t\tvalue = color( parsed || value );\n\t\t\t\t\tif ( !support.rgba && value._rgba[ 3 ] !== 1 ) {\n\t\t\t\t\t\tcurElem = hook === \"backgroundColor\" ? elem.parentNode : elem;\n\t\t\t\t\t\twhile (\n\t\t\t\t\t\t\t( backgroundColor === \"\" || backgroundColor === \"transparent\" ) &&\n\t\t\t\t\t\t\tcurElem && curElem.style\n\t\t\t\t\t\t) {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tbackgroundColor = jQuery.css( curElem, \"backgroundColor\" );\n\t\t\t\t\t\t\t\tcurElem = curElem.parentNode;\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvalue = value.blend( backgroundColor && backgroundColor !== \"transparent\" ?\n\t\t\t\t\t\t\tbackgroundColor :\n\t\t\t\t\t\t\t\"_default\" );\n\t\t\t\t\t}\n\n\t\t\t\t\tvalue = value.toRgbaString();\n\t\t\t\t}\n\t\t\t\ttry {\n\t\t\t\t\telem.style[ hook ] = value;\n\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t// wrapped to prevent IE from throwing errors on \"invalid\" values like 'auto' or 'inherit'\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t\tjQuery.fx.step[ hook ] = function( fx ) {\n\t\t\tif ( !fx.colorInit ) {\n\t\t\t\tfx.start = color( fx.elem, hook );\n\t\t\t\tfx.end = color( fx.end );\n\t\t\t\tfx.colorInit = true;\n\t\t\t}\n\t\t\tjQuery.cssHooks[ hook ].set( fx.elem, fx.start.transition( fx.end, fx.pos ) );\n\t\t};\n\t} );\n\n};\n\ncolor.hook( stepHooks );\n\njQuery.cssHooks.borderColor = {\n\texpand: function( value ) {\n\t\tvar expanded = {};\n\n\t\teach( [ \"Top\", \"Right\", \"Bottom\", \"Left\" ], function( _i, part ) {\n\t\t\texpanded[ \"border\" + part + \"Color\" ] = value;\n\t\t} );\n\t\treturn expanded;\n\t}\n};\n\n// Basic color names only.\n// Usage of any of the other color names requires adding yourself or including\n// jquery.color.svg-names.js.\ncolors = jQuery.Color.names = {\n\n\t// 4.1. Basic color keywords\n\taqua: \"#00ffff\",\n\tblack: \"#000000\",\n\tblue: \"#0000ff\",\n\tfuchsia: \"#ff00ff\",\n\tgray: \"#808080\",\n\tgreen: \"#008000\",\n\tlime: \"#00ff00\",\n\tmaroon: \"#800000\",\n\tnavy: \"#000080\",\n\tolive: \"#808000\",\n\tpurple: \"#800080\",\n\tred: \"#ff0000\",\n\tsilver: \"#c0c0c0\",\n\tteal: \"#008080\",\n\twhite: \"#ffffff\",\n\tyellow: \"#ffff00\",\n\n\t// 4.2.3. \"transparent\" color keyword\n\ttransparent: [ null, null, null, 0 ],\n\n\t_default: \"#ffffff\"\n};\n\n} );\n","jquery/patches/jquery-ui-sortable.js":"/*!\n * jQuery UI Sortable\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Patch for sortable widget.\n     * Can safely remove only when jQuery UI is upgraded to >= 1.13.1.\n     * Fixes:\n     * https://github.com/jquery/jquery-ui/pull/2008\n     * https://github.com/jquery/jquery-ui/pull/2009\n     */\n    var sortablePatch = {\n        /** @inheritdoc */\n        _mouseDrag: function (event) {\n            var i, item, itemElement, intersection,\n                o = this.options;\n\n            //Compute the helpers position\n            this.position = this._generatePosition(event);\n            this.positionAbs = this._convertPositionTo(\"absolute\");\n\n            //Set the helper position\n            if (!this.options.axis || this.options.axis !== \"y\") {\n                this.helper[0].style.left = this.position.left + \"px\";\n            }\n            if (!this.options.axis || this.options.axis !== \"x\") {\n                this.helper[0].style.top = this.position.top + \"px\";\n            }\n\n            //Do scrolling\n            if (o.scroll) {\n                if (this._scroll(event) !== false) {\n\n                    //Update item positions used in position checks\n                    this._refreshItemPositions(true);\n\n                    if ($.ui.ddmanager && !o.dropBehaviour) {\n                        $.ui.ddmanager.prepareOffsets(this, event);\n                    }\n                }\n            }\n\n            this.dragDirection = {\n                vertical: this._getDragVerticalDirection(),\n                horizontal: this._getDragHorizontalDirection()\n            };\n\n            //Rearrange\n            for (i = this.items.length - 1; i >= 0; i--) {\n\n                //Cache variables and intersection, continue if no intersection\n                item = this.items[i];\n                itemElement = item.item[0];\n                intersection = this._intersectsWithPointer(item);\n                if (!intersection) {\n                    continue;\n                }\n\n                // Only put the placeholder inside the current Container, skip all\n                // items from other containers. This works because when moving\n                // an item from one container to another the\n                // currentContainer is switched before the placeholder is moved.\n                //\n                // Without this, moving items in \"sub-sortables\" can cause\n                // the placeholder to jitter between the outer and inner container.\n                if (item.instance !== this.currentContainer) {\n                    continue;\n                }\n\n                // Cannot intersect with itself\n                // no useless actions that have been done before\n                // no action if the item moved is the parent of the item checked\n                if (itemElement !== this.currentItem[0] &&\n                    this.placeholder[intersection === 1 ?\n                        \"next\" : \"prev\"]()[0] !== itemElement &&\n                    !$.contains(this.placeholder[0], itemElement) &&\n                    (this.options.type === \"semi-dynamic\" ?\n                            !$.contains(this.element[0], itemElement) :\n                            true\n                    )\n                ) {\n\n                    this.direction = intersection === 1 ? \"down\" : \"up\";\n\n                    if (this.options.tolerance === \"pointer\" ||\n                        this._intersectsWithSides(item)) {\n                        this._rearrange(event, item);\n                    } else {\n                        break;\n                    }\n\n                    this._trigger(\"change\", event, this._uiHash());\n                    break;\n                }\n            }\n\n            //Post events to containers\n            this._contactContainers(event);\n\n            //Interconnect with droppables\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.drag(this, event);\n            }\n\n            //Call callbacks\n            this._trigger(\"sort\", event, this._uiHash());\n\n            this.lastPositionAbs = this.positionAbs;\n            return false;\n\n        },\n\n        /** @inheritdoc */\n        refreshPositions: function (fast) {\n\n            // Determine whether items are being displayed horizontally\n            this.floating = this.items.length ?\n                this.options.axis === \"x\" || this._isFloating(this.items[0].item) :\n                false;\n\n            // This has to be redone because due to the item being moved out/into the offsetParent,\n            // the offsetParent's position will change\n            if (this.offsetParent && this.helper) {\n                this.offset.parent = this._getParentOffset();\n            }\n\n            this._refreshItemPositions(fast);\n\n            var i, p;\n\n            if (this.options.custom && this.options.custom.refreshContainers) {\n                this.options.custom.refreshContainers.call(this);\n            } else {\n                for (i = this.containers.length - 1; i >= 0; i--) {\n                    p = this.containers[i].element.offset();\n                    this.containers[i].containerCache.left = p.left;\n                    this.containers[i].containerCache.top = p.top;\n                    this.containers[i].containerCache.width =\n                        this.containers[i].element.outerWidth();\n                    this.containers[i].containerCache.height =\n                        this.containers[i].element.outerHeight();\n                }\n            }\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        _contactContainers: function (event) {\n            var i, j, dist, itemWithLeastDistance, posProperty, sizeProperty, cur, nearBottom,\n                floating, axis,\n                innermostContainer = null,\n                innermostIndex = null;\n\n            // Get innermost container that intersects with item\n            for (i = this.containers.length - 1; i >= 0; i--) {\n\n                // Never consider a container that's located within the item itself\n                if ($.contains(this.currentItem[0], this.containers[i].element[0])) {\n                    continue;\n                }\n\n                if (this._intersectsWith(this.containers[i].containerCache)) {\n\n                    // If we've already found a container and it's more \"inner\" than this, then continue\n                    if (innermostContainer &&\n                        $.contains(\n                            this.containers[i].element[0],\n                            innermostContainer.element[0])) {\n                        continue;\n                    }\n\n                    innermostContainer = this.containers[i];\n                    innermostIndex = i;\n\n                } else {\n\n                    // container doesn't intersect. trigger \"out\" event if necessary\n                    if (this.containers[i].containerCache.over) {\n                        this.containers[i]._trigger(\"out\", event, this._uiHash(this));\n                        this.containers[i].containerCache.over = 0;\n                    }\n                }\n\n            }\n\n            // If no intersecting containers found, return\n            if (!innermostContainer) {\n                return;\n            }\n\n            // Move the item into the container if it's not there already\n            if (this.containers.length === 1) {\n                if (!this.containers[innermostIndex].containerCache.over) {\n                    this.containers[innermostIndex]._trigger(\"over\", event, this._uiHash(this));\n                    this.containers[innermostIndex].containerCache.over = 1;\n                }\n            } else {\n\n                // When entering a new container, we will find the item with the least distance and\n                // append our item near it\n                dist = 10000;\n                itemWithLeastDistance = null;\n                floating = innermostContainer.floating || this._isFloating(this.currentItem);\n                posProperty = floating ? \"left\" : \"top\";\n                sizeProperty = floating ? \"width\" : \"height\";\n                axis = floating ? \"pageX\" : \"pageY\";\n\n                for (j = this.items.length - 1; j >= 0; j--) {\n                    if (!$.contains(\n                        this.containers[innermostIndex].element[0], this.items[j].item[0])\n                    ) {\n                        continue;\n                    }\n                    if (this.items[j].item[0] === this.currentItem[0]) {\n                        continue;\n                    }\n\n                    cur = this.items[j].item.offset()[posProperty];\n                    nearBottom = false;\n                    if (event[axis] - cur > this.items[j][sizeProperty] / 2) {\n                        nearBottom = true;\n                    }\n\n                    if (Math.abs(event[axis] - cur) < dist) {\n                        dist = Math.abs(event[axis] - cur);\n                        itemWithLeastDistance = this.items[j];\n                        this.direction = nearBottom ? \"up\" : \"down\";\n                    }\n                }\n\n                //Check if dropOnEmpty is enabled\n                if (!itemWithLeastDistance && !this.options.dropOnEmpty) {\n                    return;\n                }\n\n                if (this.currentContainer === this.containers[innermostIndex]) {\n                    if (!this.currentContainer.containerCache.over) {\n                        this.containers[innermostIndex]._trigger(\"over\", event, this._uiHash());\n                        this.currentContainer.containerCache.over = 1;\n                    }\n                    return;\n                }\n\n                if (itemWithLeastDistance) {\n                    this._rearrange(event, itemWithLeastDistance, null, true);\n                } else {\n                    this._rearrange(event, null, this.containers[innermostIndex].element, true);\n                }\n                this._trigger(\"change\", event, this._uiHash());\n                this.containers[innermostIndex]._trigger(\"change\", event, this._uiHash(this));\n                this.currentContainer = this.containers[innermostIndex];\n\n                //Update the placeholder\n                this.options.placeholder.update(this.currentContainer, this.placeholder);\n\n                //Update scrollParent\n                this.scrollParent = this.placeholder.scrollParent();\n\n                //Update overflowOffset\n                if (this.scrollParent[0] !== this.document[0] &&\n                    this.scrollParent[0].tagName !== \"HTML\") {\n                    this.overflowOffset = this.scrollParent.offset();\n                }\n\n                this.containers[innermostIndex]._trigger(\"over\", event, this._uiHash(this));\n                this.containers[innermostIndex].containerCache.over = 1;\n            }\n\n        }\n    }\n\n    return function () {\n        var majorVersion = parseInt($.ui.version.split('.')[0]),\n            minorVersion = parseInt($.ui.version.split('.')[1]),\n            patchVersion = parseInt($.ui.version.split('.')[2])\n\n        if (majorVersion === 1 && minorVersion === 13 && patchVersion > 0 ||\n            majorVersion === 1 && minorVersion >= 14 ||\n            majorVersion >= 2\n        ) {\n            console.warn('jQuery ui sortable patch is no longer necessary, and should be removed');\n        }\n\n        $.widget('ui.sortable', $.ui.sortable, sortablePatch);\n    };\n\n});\n","jquery/spectrum/tinycolor.js":"// This file is autogenerated. v1.6.0\n// It's here at this path for backwards compatibility for links to it\n// but the npm package now exports both CJS and ESM.\n// See https://github.com/bgrins/TinyColor/ for instructions.\n(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define(factory) :\n            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.tinycolor = factory());\n})(this, (function () { 'use strict';\n\n    function _typeof(obj) {\n        \"@babel/helpers - typeof\";\n\n        return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) {\n            return typeof obj;\n        } : function (obj) {\n            return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj;\n        }, _typeof(obj);\n    }\n\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    var trimLeft = /^\\s+/;\n    var trimRight = /\\s+$/;\n    function tinycolor(color, opts) {\n        color = color ? color : \"\";\n        opts = opts || {};\n\n        // If input is already a tinycolor, return itself\n        if (color instanceof tinycolor) {\n            return color;\n        }\n        // If we are called as a function, call using new instead\n        if (!(this instanceof tinycolor)) {\n            return new tinycolor(color, opts);\n        }\n        var rgb = inputToRGB(color);\n        this._originalInput = color, this._r = rgb.r, this._g = rgb.g, this._b = rgb.b, this._a = rgb.a, this._roundA = Math.round(100 * this._a) / 100, this._format = opts.format || rgb.format;\n        this._gradientType = opts.gradientType;\n\n        // Don't let the range of [0,255] come back in [0,1].\n        // Potentially lose a little bit of precision here, but will fix issues where\n        // .5 gets interpreted as half of the total, instead of half of 1\n        // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n        if (this._r < 1) this._r = Math.round(this._r);\n        if (this._g < 1) this._g = Math.round(this._g);\n        if (this._b < 1) this._b = Math.round(this._b);\n        this._ok = rgb.ok;\n    }\n    tinycolor.prototype = {\n        isDark: function isDark() {\n            return this.getBrightness() < 128;\n        },\n        isLight: function isLight() {\n            return !this.isDark();\n        },\n        isValid: function isValid() {\n            return this._ok;\n        },\n        getOriginalInput: function getOriginalInput() {\n            return this._originalInput;\n        },\n        getFormat: function getFormat() {\n            return this._format;\n        },\n        getAlpha: function getAlpha() {\n            return this._a;\n        },\n        getBrightness: function getBrightness() {\n            //http://www.w3.org/TR/AERT#color-contrast\n            var rgb = this.toRgb();\n            return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n        },\n        getLuminance: function getLuminance() {\n            //http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef\n            var rgb = this.toRgb();\n            var RsRGB, GsRGB, BsRGB, R, G, B;\n            RsRGB = rgb.r / 255;\n            GsRGB = rgb.g / 255;\n            BsRGB = rgb.b / 255;\n            if (RsRGB <= 0.03928) R = RsRGB / 12.92;else R = Math.pow((RsRGB + 0.055) / 1.055, 2.4);\n            if (GsRGB <= 0.03928) G = GsRGB / 12.92;else G = Math.pow((GsRGB + 0.055) / 1.055, 2.4);\n            if (BsRGB <= 0.03928) B = BsRGB / 12.92;else B = Math.pow((BsRGB + 0.055) / 1.055, 2.4);\n            return 0.2126 * R + 0.7152 * G + 0.0722 * B;\n        },\n        setAlpha: function setAlpha(value) {\n            this._a = boundAlpha(value);\n            this._roundA = Math.round(100 * this._a) / 100;\n            return this;\n        },\n        toHsv: function toHsv() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            return {\n                h: hsv.h * 360,\n                s: hsv.s,\n                v: hsv.v,\n                a: this._a\n            };\n        },\n        toHsvString: function toHsvString() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            var h = Math.round(hsv.h * 360),\n                s = Math.round(hsv.s * 100),\n                v = Math.round(hsv.v * 100);\n            return this._a == 1 ? \"hsv(\" + h + \", \" + s + \"%, \" + v + \"%)\" : \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \" + this._roundA + \")\";\n        },\n        toHsl: function toHsl() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            return {\n                h: hsl.h * 360,\n                s: hsl.s,\n                l: hsl.l,\n                a: this._a\n            };\n        },\n        toHslString: function toHslString() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            var h = Math.round(hsl.h * 360),\n                s = Math.round(hsl.s * 100),\n                l = Math.round(hsl.l * 100);\n            return this._a == 1 ? \"hsl(\" + h + \", \" + s + \"%, \" + l + \"%)\" : \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \" + this._roundA + \")\";\n        },\n        toHex: function toHex(allow3Char) {\n            return rgbToHex(this._r, this._g, this._b, allow3Char);\n        },\n        toHexString: function toHexString(allow3Char) {\n            return \"#\" + this.toHex(allow3Char);\n        },\n        toHex8: function toHex8(allow4Char) {\n            return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);\n        },\n        toHex8String: function toHex8String(allow4Char) {\n            return \"#\" + this.toHex8(allow4Char);\n        },\n        toRgb: function toRgb() {\n            return {\n                r: Math.round(this._r),\n                g: Math.round(this._g),\n                b: Math.round(this._b),\n                a: this._a\n            };\n        },\n        toRgbString: function toRgbString() {\n            return this._a == 1 ? \"rgb(\" + Math.round(this._r) + \", \" + Math.round(this._g) + \", \" + Math.round(this._b) + \")\" : \"rgba(\" + Math.round(this._r) + \", \" + Math.round(this._g) + \", \" + Math.round(this._b) + \", \" + this._roundA + \")\";\n        },\n        toPercentageRgb: function toPercentageRgb() {\n            return {\n                r: Math.round(bound01(this._r, 255) * 100) + \"%\",\n                g: Math.round(bound01(this._g, 255) * 100) + \"%\",\n                b: Math.round(bound01(this._b, 255) * 100) + \"%\",\n                a: this._a\n            };\n        },\n        toPercentageRgbString: function toPercentageRgbString() {\n            return this._a == 1 ? \"rgb(\" + Math.round(bound01(this._r, 255) * 100) + \"%, \" + Math.round(bound01(this._g, 255) * 100) + \"%, \" + Math.round(bound01(this._b, 255) * 100) + \"%)\" : \"rgba(\" + Math.round(bound01(this._r, 255) * 100) + \"%, \" + Math.round(bound01(this._g, 255) * 100) + \"%, \" + Math.round(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n        },\n        toName: function toName() {\n            if (this._a === 0) {\n                return \"transparent\";\n            }\n            if (this._a < 1) {\n                return false;\n            }\n            return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n        },\n        toFilter: function toFilter(secondColor) {\n            var hex8String = \"#\" + rgbaToArgbHex(this._r, this._g, this._b, this._a);\n            var secondHex8String = hex8String;\n            var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n            if (secondColor) {\n                var s = tinycolor(secondColor);\n                secondHex8String = \"#\" + rgbaToArgbHex(s._r, s._g, s._b, s._a);\n            }\n            return \"progid:DXImageTransform.Microsoft.gradient(\" + gradientType + \"startColorstr=\" + hex8String + \",endColorstr=\" + secondHex8String + \")\";\n        },\n        toString: function toString(format) {\n            var formatSet = !!format;\n            format = format || this._format;\n            var formattedString = false;\n            var hasAlpha = this._a < 1 && this._a >= 0;\n            var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"hex4\" || format === \"hex8\" || format === \"name\");\n            if (needsAlphaFormat) {\n                // Special case for \"transparent\", all other non-alpha formats\n                // will return rgba when there is transparency.\n                if (format === \"name\" && this._a === 0) {\n                    return this.toName();\n                }\n                return this.toRgbString();\n            }\n            if (format === \"rgb\") {\n                formattedString = this.toRgbString();\n            }\n            if (format === \"prgb\") {\n                formattedString = this.toPercentageRgbString();\n            }\n            if (format === \"hex\" || format === \"hex6\") {\n                formattedString = this.toHexString();\n            }\n            if (format === \"hex3\") {\n                formattedString = this.toHexString(true);\n            }\n            if (format === \"hex4\") {\n                formattedString = this.toHex8String(true);\n            }\n            if (format === \"hex8\") {\n                formattedString = this.toHex8String();\n            }\n            if (format === \"name\") {\n                formattedString = this.toName();\n            }\n            if (format === \"hsl\") {\n                formattedString = this.toHslString();\n            }\n            if (format === \"hsv\") {\n                formattedString = this.toHsvString();\n            }\n            return formattedString || this.toHexString();\n        },\n        clone: function clone() {\n            return tinycolor(this.toString());\n        },\n        _applyModification: function _applyModification(fn, args) {\n            var color = fn.apply(null, [this].concat([].slice.call(args)));\n            this._r = color._r;\n            this._g = color._g;\n            this._b = color._b;\n            this.setAlpha(color._a);\n            return this;\n        },\n        lighten: function lighten() {\n            return this._applyModification(_lighten, arguments);\n        },\n        brighten: function brighten() {\n            return this._applyModification(_brighten, arguments);\n        },\n        darken: function darken() {\n            return this._applyModification(_darken, arguments);\n        },\n        desaturate: function desaturate() {\n            return this._applyModification(_desaturate, arguments);\n        },\n        saturate: function saturate() {\n            return this._applyModification(_saturate, arguments);\n        },\n        greyscale: function greyscale() {\n            return this._applyModification(_greyscale, arguments);\n        },\n        spin: function spin() {\n            return this._applyModification(_spin, arguments);\n        },\n        _applyCombination: function _applyCombination(fn, args) {\n            return fn.apply(null, [this].concat([].slice.call(args)));\n        },\n        analogous: function analogous() {\n            return this._applyCombination(_analogous, arguments);\n        },\n        complement: function complement() {\n            return this._applyCombination(_complement, arguments);\n        },\n        monochromatic: function monochromatic() {\n            return this._applyCombination(_monochromatic, arguments);\n        },\n        splitcomplement: function splitcomplement() {\n            return this._applyCombination(_splitcomplement, arguments);\n        },\n        // Disabled until https://github.com/bgrins/TinyColor/issues/254\n        // polyad: function (number) {\n        //   return this._applyCombination(polyad, [number]);\n        // },\n        triad: function triad() {\n            return this._applyCombination(polyad, [3]);\n        },\n        tetrad: function tetrad() {\n            return this._applyCombination(polyad, [4]);\n        }\n    };\n\n    // If input is an object, force 1 into \"1.0\" to handle ratios properly\n    // String input requires \"1.0\" as input, so 1 will be treated as 1\n    tinycolor.fromRatio = function (color, opts) {\n        if (_typeof(color) == \"object\") {\n            var newColor = {};\n            for (var i in color) {\n                if (color.hasOwnProperty(i)) {\n                    if (i === \"a\") {\n                        newColor[i] = color[i];\n                    } else {\n                        newColor[i] = convertToPercentage(color[i]);\n                    }\n                }\n            }\n            color = newColor;\n        }\n        return tinycolor(color, opts);\n    };\n\n    // Given a string or object, convert that input to RGB\n    // Possible string inputs:\n    //\n    //     \"red\"\n    //     \"#f00\" or \"f00\"\n    //     \"#ff0000\" or \"ff0000\"\n    //     \"#ff000000\" or \"ff000000\"\n    //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n    //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n    //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n    //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n    //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n    //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n    //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n    //\n    function inputToRGB(color) {\n        var rgb = {\n            r: 0,\n            g: 0,\n            b: 0\n        };\n        var a = 1;\n        var s = null;\n        var v = null;\n        var l = null;\n        var ok = false;\n        var format = false;\n        if (typeof color == \"string\") {\n            color = stringInputToObject(color);\n        }\n        if (_typeof(color) == \"object\") {\n            if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {\n                rgb = rgbToRgb(color.r, color.g, color.b);\n                ok = true;\n                format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n            } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {\n                s = convertToPercentage(color.s);\n                v = convertToPercentage(color.v);\n                rgb = hsvToRgb(color.h, s, v);\n                ok = true;\n                format = \"hsv\";\n            } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {\n                s = convertToPercentage(color.s);\n                l = convertToPercentage(color.l);\n                rgb = hslToRgb(color.h, s, l);\n                ok = true;\n                format = \"hsl\";\n            }\n            if (color.hasOwnProperty(\"a\")) {\n                a = color.a;\n            }\n        }\n        a = boundAlpha(a);\n        return {\n            ok: ok,\n            format: color.format || format,\n            r: Math.min(255, Math.max(rgb.r, 0)),\n            g: Math.min(255, Math.max(rgb.g, 0)),\n            b: Math.min(255, Math.max(rgb.b, 0)),\n            a: a\n        };\n    }\n\n    // Conversion Functions\n    // --------------------\n\n    // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n    // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n    // `rgbToRgb`\n    // Handle bounds / percentage checking to conform to CSS color spec\n    // <http://www.w3.org/TR/css3-color/>\n    // *Assumes:* r, g, b in [0, 255] or [0, 1]\n    // *Returns:* { r, g, b } in [0, 255]\n    function rgbToRgb(r, g, b) {\n        return {\n            r: bound01(r, 255) * 255,\n            g: bound01(g, 255) * 255,\n            b: bound01(b, 255) * 255\n        };\n    }\n\n    // `rgbToHsl`\n    // Converts an RGB color value to HSL.\n    // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n    // *Returns:* { h, s, l } in [0,1]\n    function rgbToHsl(r, g, b) {\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n        var max = Math.max(r, g, b),\n            min = Math.min(r, g, b);\n        var h,\n            s,\n            l = (max + min) / 2;\n        if (max == min) {\n            h = s = 0; // achromatic\n        } else {\n            var d = max - min;\n            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n            switch (max) {\n                case r:\n                    h = (g - b) / d + (g < b ? 6 : 0);\n                    break;\n                case g:\n                    h = (b - r) / d + 2;\n                    break;\n                case b:\n                    h = (r - g) / d + 4;\n                    break;\n            }\n            h /= 6;\n        }\n        return {\n            h: h,\n            s: s,\n            l: l\n        };\n    }\n\n    // `hslToRgb`\n    // Converts an HSL color value to RGB.\n    // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n    // *Returns:* { r, g, b } in the set [0, 255]\n    function hslToRgb(h, s, l) {\n        var r, g, b;\n        h = bound01(h, 360);\n        s = bound01(s, 100);\n        l = bound01(l, 100);\n        function hue2rgb(p, q, t) {\n            if (t < 0) t += 1;\n            if (t > 1) t -= 1;\n            if (t < 1 / 6) return p + (q - p) * 6 * t;\n            if (t < 1 / 2) return q;\n            if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;\n            return p;\n        }\n        if (s === 0) {\n            r = g = b = l; // achromatic\n        } else {\n            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n            var p = 2 * l - q;\n            r = hue2rgb(p, q, h + 1 / 3);\n            g = hue2rgb(p, q, h);\n            b = hue2rgb(p, q, h - 1 / 3);\n        }\n        return {\n            r: r * 255,\n            g: g * 255,\n            b: b * 255\n        };\n    }\n\n    // `rgbToHsv`\n    // Converts an RGB color value to HSV\n    // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n    // *Returns:* { h, s, v } in [0,1]\n    function rgbToHsv(r, g, b) {\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n        var max = Math.max(r, g, b),\n            min = Math.min(r, g, b);\n        var h,\n            s,\n            v = max;\n        var d = max - min;\n        s = max === 0 ? 0 : d / max;\n        if (max == min) {\n            h = 0; // achromatic\n        } else {\n            switch (max) {\n                case r:\n                    h = (g - b) / d + (g < b ? 6 : 0);\n                    break;\n                case g:\n                    h = (b - r) / d + 2;\n                    break;\n                case b:\n                    h = (r - g) / d + 4;\n                    break;\n            }\n            h /= 6;\n        }\n        return {\n            h: h,\n            s: s,\n            v: v\n        };\n    }\n\n    // `hsvToRgb`\n    // Converts an HSV color value to RGB.\n    // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n    // *Returns:* { r, g, b } in the set [0, 255]\n    function hsvToRgb(h, s, v) {\n        h = bound01(h, 360) * 6;\n        s = bound01(s, 100);\n        v = bound01(v, 100);\n        var i = Math.floor(h),\n            f = h - i,\n            p = v * (1 - s),\n            q = v * (1 - f * s),\n            t = v * (1 - (1 - f) * s),\n            mod = i % 6,\n            r = [v, q, p, p, t, v][mod],\n            g = [t, v, v, q, p, p][mod],\n            b = [p, p, t, v, v, q][mod];\n        return {\n            r: r * 255,\n            g: g * 255,\n            b: b * 255\n        };\n    }\n\n    // `rgbToHex`\n    // Converts an RGB color to hex\n    // Assumes r, g, and b are contained in the set [0, 255]\n    // Returns a 3 or 6 character hex\n    function rgbToHex(r, g, b, allow3Char) {\n        var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];\n\n        // Return a 3 character hex if possible\n        if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n        }\n        return hex.join(\"\");\n    }\n\n    // `rgbaToHex`\n    // Converts an RGBA color plus alpha transparency to hex\n    // Assumes r, g, b are contained in the set [0, 255] and\n    // a in [0, 1]. Returns a 4 or 8 character rgba hex\n    function rgbaToHex(r, g, b, a, allow4Char) {\n        var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16)), pad2(convertDecimalToHex(a))];\n\n        // Return a 4 character hex if possible\n        if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);\n        }\n        return hex.join(\"\");\n    }\n\n    // `rgbaToArgbHex`\n    // Converts an RGBA color to an ARGB Hex8 string\n    // Rarely used, but required for \"toFilter()\"\n    function rgbaToArgbHex(r, g, b, a) {\n        var hex = [pad2(convertDecimalToHex(a)), pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];\n        return hex.join(\"\");\n    }\n\n    // `equals`\n    // Can be called with any tinycolor input\n    tinycolor.equals = function (color1, color2) {\n        if (!color1 || !color2) return false;\n        return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n    };\n    tinycolor.random = function () {\n        return tinycolor.fromRatio({\n            r: Math.random(),\n            g: Math.random(),\n            b: Math.random()\n        });\n    };\n\n    // Modification Functions\n    // ----------------------\n    // Thanks to less.js for some of the basics here\n    // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n    function _desaturate(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.s -= amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n    function _saturate(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.s += amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n    function _greyscale(color) {\n        return tinycolor(color).desaturate(100);\n    }\n    function _lighten(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.l += amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n    function _brighten(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var rgb = tinycolor(color).toRgb();\n        rgb.r = Math.max(0, Math.min(255, rgb.r - Math.round(255 * -(amount / 100))));\n        rgb.g = Math.max(0, Math.min(255, rgb.g - Math.round(255 * -(amount / 100))));\n        rgb.b = Math.max(0, Math.min(255, rgb.b - Math.round(255 * -(amount / 100))));\n        return tinycolor(rgb);\n    }\n    function _darken(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.l -= amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n    // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n    // Values outside of this range will be wrapped into this range.\n    function _spin(color, amount) {\n        var hsl = tinycolor(color).toHsl();\n        var hue = (hsl.h + amount) % 360;\n        hsl.h = hue < 0 ? 360 + hue : hue;\n        return tinycolor(hsl);\n    }\n\n    // Combination Functions\n    // ---------------------\n    // Thanks to jQuery xColor for some of the ideas behind these\n    // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n    function _complement(color) {\n        var hsl = tinycolor(color).toHsl();\n        hsl.h = (hsl.h + 180) % 360;\n        return tinycolor(hsl);\n    }\n    function polyad(color, number) {\n        if (isNaN(number) || number <= 0) {\n            throw new Error(\"Argument to polyad must be a positive number\");\n        }\n        var hsl = tinycolor(color).toHsl();\n        var result = [tinycolor(color)];\n        var step = 360 / number;\n        for (var i = 1; i < number; i++) {\n            result.push(tinycolor({\n                h: (hsl.h + i * step) % 360,\n                s: hsl.s,\n                l: hsl.l\n            }));\n        }\n        return result;\n    }\n    function _splitcomplement(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [tinycolor(color), tinycolor({\n            h: (h + 72) % 360,\n            s: hsl.s,\n            l: hsl.l\n        }), tinycolor({\n            h: (h + 216) % 360,\n            s: hsl.s,\n            l: hsl.l\n        })];\n    }\n    function _analogous(color, results, slices) {\n        results = results || 6;\n        slices = slices || 30;\n        var hsl = tinycolor(color).toHsl();\n        var part = 360 / slices;\n        var ret = [tinycolor(color)];\n        for (hsl.h = (hsl.h - (part * results >> 1) + 720) % 360; --results;) {\n            hsl.h = (hsl.h + part) % 360;\n            ret.push(tinycolor(hsl));\n        }\n        return ret;\n    }\n    function _monochromatic(color, results) {\n        results = results || 6;\n        var hsv = tinycolor(color).toHsv();\n        var h = hsv.h,\n            s = hsv.s,\n            v = hsv.v;\n        var ret = [];\n        var modification = 1 / results;\n        while (results--) {\n            ret.push(tinycolor({\n                h: h,\n                s: s,\n                v: v\n            }));\n            v = (v + modification) % 1;\n        }\n        return ret;\n    }\n\n    // Utility Functions\n    // ---------------------\n\n    tinycolor.mix = function (color1, color2, amount) {\n        amount = amount === 0 ? 0 : amount || 50;\n        var rgb1 = tinycolor(color1).toRgb();\n        var rgb2 = tinycolor(color2).toRgb();\n        var p = amount / 100;\n        var rgba = {\n            r: (rgb2.r - rgb1.r) * p + rgb1.r,\n            g: (rgb2.g - rgb1.g) * p + rgb1.g,\n            b: (rgb2.b - rgb1.b) * p + rgb1.b,\n            a: (rgb2.a - rgb1.a) * p + rgb1.a\n        };\n        return tinycolor(rgba);\n    };\n\n    // Readability Functions\n    // ---------------------\n    // <http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef (WCAG Version 2)\n\n    // `contrast`\n    // Analyze the 2 colors and returns the color contrast defined by (WCAG Version 2)\n    tinycolor.readability = function (color1, color2) {\n        var c1 = tinycolor(color1);\n        var c2 = tinycolor(color2);\n        return (Math.max(c1.getLuminance(), c2.getLuminance()) + 0.05) / (Math.min(c1.getLuminance(), c2.getLuminance()) + 0.05);\n    };\n\n    // `isReadable`\n    // Ensure that foreground and background color combinations meet WCAG2 guidelines.\n    // The third argument is an optional Object.\n    //      the 'level' property states 'AA' or 'AAA' - if missing or invalid, it defaults to 'AA';\n    //      the 'size' property states 'large' or 'small' - if missing or invalid, it defaults to 'small'.\n    // If the entire object is absent, isReadable defaults to {level:\"AA\",size:\"small\"}.\n\n    // *Example*\n    //    tinycolor.isReadable(\"#000\", \"#111\") => false\n    //    tinycolor.isReadable(\"#000\", \"#111\",{level:\"AA\",size:\"large\"}) => false\n    tinycolor.isReadable = function (color1, color2, wcag2) {\n        var readability = tinycolor.readability(color1, color2);\n        var wcag2Parms, out;\n        out = false;\n        wcag2Parms = validateWCAG2Parms(wcag2);\n        switch (wcag2Parms.level + wcag2Parms.size) {\n            case \"AAsmall\":\n            case \"AAAlarge\":\n                out = readability >= 4.5;\n                break;\n            case \"AAlarge\":\n                out = readability >= 3;\n                break;\n            case \"AAAsmall\":\n                out = readability >= 7;\n                break;\n        }\n        return out;\n    };\n\n    // `mostReadable`\n    // Given a base color and a list of possible foreground or background\n    // colors for that base, returns the most readable color.\n    // Optionally returns Black or White if the most readable color is unreadable.\n    // *Example*\n    //    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:false}).toHexString(); // \"#112255\"\n    //    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:true}).toHexString();  // \"#ffffff\"\n    //    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"large\"}).toHexString(); // \"#faf3f3\"\n    //    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"small\"}).toHexString(); // \"#ffffff\"\n    tinycolor.mostReadable = function (baseColor, colorList, args) {\n        var bestColor = null;\n        var bestScore = 0;\n        var readability;\n        var includeFallbackColors, level, size;\n        args = args || {};\n        includeFallbackColors = args.includeFallbackColors;\n        level = args.level;\n        size = args.size;\n        for (var i = 0; i < colorList.length; i++) {\n            readability = tinycolor.readability(baseColor, colorList[i]);\n            if (readability > bestScore) {\n                bestScore = readability;\n                bestColor = tinycolor(colorList[i]);\n            }\n        }\n        if (tinycolor.isReadable(baseColor, bestColor, {\n            level: level,\n            size: size\n        }) || !includeFallbackColors) {\n            return bestColor;\n        } else {\n            args.includeFallbackColors = false;\n            return tinycolor.mostReadable(baseColor, [\"#fff\", \"#000\"], args);\n        }\n    };\n\n    // Big List of Colors\n    // ------------------\n    // <https://www.w3.org/TR/css-color-4/#named-colors>\n    var names = tinycolor.names = {\n        aliceblue: \"f0f8ff\",\n        antiquewhite: \"faebd7\",\n        aqua: \"0ff\",\n        aquamarine: \"7fffd4\",\n        azure: \"f0ffff\",\n        beige: \"f5f5dc\",\n        bisque: \"ffe4c4\",\n        black: \"000\",\n        blanchedalmond: \"ffebcd\",\n        blue: \"00f\",\n        blueviolet: \"8a2be2\",\n        brown: \"a52a2a\",\n        burlywood: \"deb887\",\n        burntsienna: \"ea7e5d\",\n        cadetblue: \"5f9ea0\",\n        chartreuse: \"7fff00\",\n        chocolate: \"d2691e\",\n        coral: \"ff7f50\",\n        cornflowerblue: \"6495ed\",\n        cornsilk: \"fff8dc\",\n        crimson: \"dc143c\",\n        cyan: \"0ff\",\n        darkblue: \"00008b\",\n        darkcyan: \"008b8b\",\n        darkgoldenrod: \"b8860b\",\n        darkgray: \"a9a9a9\",\n        darkgreen: \"006400\",\n        darkgrey: \"a9a9a9\",\n        darkkhaki: \"bdb76b\",\n        darkmagenta: \"8b008b\",\n        darkolivegreen: \"556b2f\",\n        darkorange: \"ff8c00\",\n        darkorchid: \"9932cc\",\n        darkred: \"8b0000\",\n        darksalmon: \"e9967a\",\n        darkseagreen: \"8fbc8f\",\n        darkslateblue: \"483d8b\",\n        darkslategray: \"2f4f4f\",\n        darkslategrey: \"2f4f4f\",\n        darkturquoise: \"00ced1\",\n        darkviolet: \"9400d3\",\n        deeppink: \"ff1493\",\n        deepskyblue: \"00bfff\",\n        dimgray: \"696969\",\n        dimgrey: \"696969\",\n        dodgerblue: \"1e90ff\",\n        firebrick: \"b22222\",\n        floralwhite: \"fffaf0\",\n        forestgreen: \"228b22\",\n        fuchsia: \"f0f\",\n        gainsboro: \"dcdcdc\",\n        ghostwhite: \"f8f8ff\",\n        gold: \"ffd700\",\n        goldenrod: \"daa520\",\n        gray: \"808080\",\n        green: \"008000\",\n        greenyellow: \"adff2f\",\n        grey: \"808080\",\n        honeydew: \"f0fff0\",\n        hotpink: \"ff69b4\",\n        indianred: \"cd5c5c\",\n        indigo: \"4b0082\",\n        ivory: \"fffff0\",\n        khaki: \"f0e68c\",\n        lavender: \"e6e6fa\",\n        lavenderblush: \"fff0f5\",\n        lawngreen: \"7cfc00\",\n        lemonchiffon: \"fffacd\",\n        lightblue: \"add8e6\",\n        lightcoral: \"f08080\",\n        lightcyan: \"e0ffff\",\n        lightgoldenrodyellow: \"fafad2\",\n        lightgray: \"d3d3d3\",\n        lightgreen: \"90ee90\",\n        lightgrey: \"d3d3d3\",\n        lightpink: \"ffb6c1\",\n        lightsalmon: \"ffa07a\",\n        lightseagreen: \"20b2aa\",\n        lightskyblue: \"87cefa\",\n        lightslategray: \"789\",\n        lightslategrey: \"789\",\n        lightsteelblue: \"b0c4de\",\n        lightyellow: \"ffffe0\",\n        lime: \"0f0\",\n        limegreen: \"32cd32\",\n        linen: \"faf0e6\",\n        magenta: \"f0f\",\n        maroon: \"800000\",\n        mediumaquamarine: \"66cdaa\",\n        mediumblue: \"0000cd\",\n        mediumorchid: \"ba55d3\",\n        mediumpurple: \"9370db\",\n        mediumseagreen: \"3cb371\",\n        mediumslateblue: \"7b68ee\",\n        mediumspringgreen: \"00fa9a\",\n        mediumturquoise: \"48d1cc\",\n        mediumvioletred: \"c71585\",\n        midnightblue: \"191970\",\n        mintcream: \"f5fffa\",\n        mistyrose: \"ffe4e1\",\n        moccasin: \"ffe4b5\",\n        navajowhite: \"ffdead\",\n        navy: \"000080\",\n        oldlace: \"fdf5e6\",\n        olive: \"808000\",\n        olivedrab: \"6b8e23\",\n        orange: \"ffa500\",\n        orangered: \"ff4500\",\n        orchid: \"da70d6\",\n        palegoldenrod: \"eee8aa\",\n        palegreen: \"98fb98\",\n        paleturquoise: \"afeeee\",\n        palevioletred: \"db7093\",\n        papayawhip: \"ffefd5\",\n        peachpuff: \"ffdab9\",\n        peru: \"cd853f\",\n        pink: \"ffc0cb\",\n        plum: \"dda0dd\",\n        powderblue: \"b0e0e6\",\n        purple: \"800080\",\n        rebeccapurple: \"663399\",\n        red: \"f00\",\n        rosybrown: \"bc8f8f\",\n        royalblue: \"4169e1\",\n        saddlebrown: \"8b4513\",\n        salmon: \"fa8072\",\n        sandybrown: \"f4a460\",\n        seagreen: \"2e8b57\",\n        seashell: \"fff5ee\",\n        sienna: \"a0522d\",\n        silver: \"c0c0c0\",\n        skyblue: \"87ceeb\",\n        slateblue: \"6a5acd\",\n        slategray: \"708090\",\n        slategrey: \"708090\",\n        snow: \"fffafa\",\n        springgreen: \"00ff7f\",\n        steelblue: \"4682b4\",\n        tan: \"d2b48c\",\n        teal: \"008080\",\n        thistle: \"d8bfd8\",\n        tomato: \"ff6347\",\n        turquoise: \"40e0d0\",\n        violet: \"ee82ee\",\n        wheat: \"f5deb3\",\n        white: \"fff\",\n        whitesmoke: \"f5f5f5\",\n        yellow: \"ff0\",\n        yellowgreen: \"9acd32\"\n    };\n\n    // Make it easy to access colors via `hexNames[hex]`\n    var hexNames = tinycolor.hexNames = flip(names);\n\n    // Utilities\n    // ---------\n\n    // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n    function flip(o) {\n        var flipped = {};\n        for (var i in o) {\n            if (o.hasOwnProperty(i)) {\n                flipped[o[i]] = i;\n            }\n        }\n        return flipped;\n    }\n\n    // Return a valid alpha value [0,1] with all invalid values being set to 1\n    function boundAlpha(a) {\n        a = parseFloat(a);\n        if (isNaN(a) || a < 0 || a > 1) {\n            a = 1;\n        }\n        return a;\n    }\n\n    // Take input from [0, n] and return it as [0, 1]\n    function bound01(n, max) {\n        if (isOnePointZero(n)) n = \"100%\";\n        var processPercent = isPercentage(n);\n        n = Math.min(max, Math.max(0, parseFloat(n)));\n\n        // Automatically convert percentage into number\n        if (processPercent) {\n            n = parseInt(n * max, 10) / 100;\n        }\n\n        // Handle floating point rounding errors\n        if (Math.abs(n - max) < 0.000001) {\n            return 1;\n        }\n\n        // Convert into [0, 1] range if it isn't already\n        return n % max / parseFloat(max);\n    }\n\n    // Force a number between 0 and 1\n    function clamp01(val) {\n        return Math.min(1, Math.max(0, val));\n    }\n\n    // Parse a base-16 hex value into a base-10 integer\n    function parseIntFromHex(val) {\n        return parseInt(val, 16);\n    }\n\n    // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n    // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n    function isOnePointZero(n) {\n        return typeof n == \"string\" && n.indexOf(\".\") != -1 && parseFloat(n) === 1;\n    }\n\n    // Check to see if string passed in is a percentage\n    function isPercentage(n) {\n        return typeof n === \"string\" && n.indexOf(\"%\") != -1;\n    }\n\n    // Force a hex value to have 2 characters\n    function pad2(c) {\n        return c.length == 1 ? \"0\" + c : \"\" + c;\n    }\n\n    // Replace a decimal with it's percentage value\n    function convertToPercentage(n) {\n        if (n <= 1) {\n            n = n * 100 + \"%\";\n        }\n        return n;\n    }\n\n    // Converts a decimal to a hex value\n    function convertDecimalToHex(d) {\n        return Math.round(parseFloat(d) * 255).toString(16);\n    }\n    // Converts a hex value to a decimal\n    function convertHexToDecimal(h) {\n        return parseIntFromHex(h) / 255;\n    }\n    var matchers = function () {\n        // <http://www.w3.org/TR/css3-values/#integers>\n        var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n        // <http://www.w3.org/TR/css3-values/#number-value>\n        var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n        // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n        var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n        // Actual matching.\n        // Parentheses and commas are optional, but not required.\n        // Whitespace can take the place of commas or opening paren\n        var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        return {\n            CSS_UNIT: new RegExp(CSS_UNIT),\n            rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n            rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n            hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n            hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n            hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n            hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n            hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n            hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n        };\n    }();\n\n    // `isValidCSSUnit`\n    // Take in a single string / number and check to see if it looks like a CSS unit\n    // (see `matchers` above for definition).\n    function isValidCSSUnit(color) {\n        return !!matchers.CSS_UNIT.exec(color);\n    }\n\n    // `stringInputToObject`\n    // Permissive string parsing.  Take in a number of formats, and output an object\n    // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n    function stringInputToObject(color) {\n        color = color.replace(trimLeft, \"\").replace(trimRight, \"\").toLowerCase();\n        var named = false;\n        if (names[color]) {\n            color = names[color];\n            named = true;\n        } else if (color == \"transparent\") {\n            return {\n                r: 0,\n                g: 0,\n                b: 0,\n                a: 0,\n                format: \"name\"\n            };\n        }\n\n        // Try to match string input using regular expressions.\n        // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n        // Just return an object and let the conversion functions handle that.\n        // This way the result will be the same whether the tinycolor is initialized with string or object.\n        var match;\n        if (match = matchers.rgb.exec(color)) {\n            return {\n                r: match[1],\n                g: match[2],\n                b: match[3]\n            };\n        }\n        if (match = matchers.rgba.exec(color)) {\n            return {\n                r: match[1],\n                g: match[2],\n                b: match[3],\n                a: match[4]\n            };\n        }\n        if (match = matchers.hsl.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                l: match[3]\n            };\n        }\n        if (match = matchers.hsla.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                l: match[3],\n                a: match[4]\n            };\n        }\n        if (match = matchers.hsv.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                v: match[3]\n            };\n        }\n        if (match = matchers.hsva.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                v: match[3],\n                a: match[4]\n            };\n        }\n        if (match = matchers.hex8.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                a: convertHexToDecimal(match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if (match = matchers.hex6.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        if (match = matchers.hex4.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1] + \"\" + match[1]),\n                g: parseIntFromHex(match[2] + \"\" + match[2]),\n                b: parseIntFromHex(match[3] + \"\" + match[3]),\n                a: convertHexToDecimal(match[4] + \"\" + match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if (match = matchers.hex3.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1] + \"\" + match[1]),\n                g: parseIntFromHex(match[2] + \"\" + match[2]),\n                b: parseIntFromHex(match[3] + \"\" + match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        return false;\n    }\n    function validateWCAG2Parms(parms) {\n        // return valid WCAG2 parms for isReadable.\n        // If input parms are invalid, return {\"level\":\"AA\", \"size\":\"small\"}\n        var level, size;\n        parms = parms || {\n            level: \"AA\",\n            size: \"small\"\n        };\n        level = (parms.level || \"AA\").toUpperCase();\n        size = (parms.size || \"small\").toLowerCase();\n        if (level !== \"AA\" && level !== \"AAA\") {\n            level = \"AA\";\n        }\n        if (size !== \"small\" && size !== \"large\") {\n            size = \"small\";\n        }\n        return {\n            level: level,\n            size: size\n        };\n    }\n\n    return tinycolor;\n\n}));\n","jquery/spectrum/spectrum.js":"// Spectrum Colorpicker v1.8.1\n// https://github.com/bgrins/spectrum\n// Author: Brian Grinstead\n// License: MIT\n\n(function (factory) {\n    \"use strict\";\n\n    if (typeof define === 'function' && define.amd) { // AMD\n        define(['jquery'], factory);\n    }\n    else if (typeof exports == \"object\" && typeof module == \"object\") { // CommonJS\n        module.exports = factory(require('jquery'));\n    }\n    else { // Browser\n        factory(jQuery);\n    }\n})(function($, undefined) {\n    \"use strict\";\n\n    var defaultOpts = {\n\n            // Callbacks\n            beforeShow: noop,\n            move: noop,\n            change: noop,\n            show: noop,\n            hide: noop,\n\n            // Options\n            color: false,\n            flat: false,\n            showInput: false,\n            allowEmpty: false,\n            showButtons: true,\n            clickoutFiresChange: true,\n            showInitial: false,\n            showPalette: false,\n            showPaletteOnly: false,\n            hideAfterPaletteSelect: false,\n            togglePaletteOnly: false,\n            showSelectionPalette: true,\n            localStorageKey: false,\n            appendTo: \"body\",\n            maxSelectionSize: 7,\n            cancelText: \"cancel\",\n            chooseText: \"choose\",\n            togglePaletteMoreText: \"more\",\n            togglePaletteLessText: \"less\",\n            clearText: \"Clear Color Selection\",\n            noColorSelectedText: \"No Color Selected\",\n            preferredFormat: false,\n            className: \"\", // Deprecated - use containerClassName and replacerClassName instead.\n            containerClassName: \"\",\n            replacerClassName: \"\",\n            showAlpha: false,\n            theme: \"sp-light\",\n            palette: [[\"#ffffff\", \"#000000\", \"#ff0000\", \"#ff8000\", \"#ffff00\", \"#008000\", \"#0000ff\", \"#4b0082\", \"#9400d3\"]],\n            selectionPalette: [],\n            disabled: false,\n            offset: null\n        },\n        spectrums = [],\n        IE = !!/msie/i.exec( window.navigator.userAgent ),\n        rgbaSupport = (function() {\n            function contains( str, substr ) {\n                return !!~('' + str).indexOf(substr);\n            }\n\n            var elem = document.createElement('div');\n            var style = elem.style;\n            style.cssText = 'background-color:rgba(0,0,0,.5)';\n            return contains(style.backgroundColor, 'rgba') || contains(style.backgroundColor, 'hsla');\n        })(),\n        replaceInput = [\n            \"<div class='sp-replacer'>\",\n            \"<div class='sp-preview'><div class='sp-preview-inner'></div></div>\",\n            \"<div class='sp-dd'>&#9660;</div>\",\n            \"</div>\"\n        ].join(''),\n        markup = (function () {\n\n            // IE does not support gradients with multiple stops, so we need to simulate\n            //  that for the rainbow slider with 8 divs that each have a single gradient\n            var gradientFix = \"\";\n            if (IE) {\n                for (var i = 1; i <= 6; i++) {\n                    gradientFix += \"<div class='sp-\" + i + \"'></div>\";\n                }\n            }\n\n            return [\n                \"<div class='sp-container sp-hidden'>\",\n                \"<div class='sp-palette-container'>\",\n                \"<div class='sp-palette sp-thumb sp-cf'></div>\",\n                \"<div class='sp-palette-button-container sp-cf'>\",\n                \"<button type='button' class='sp-palette-toggle'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-picker-container'>\",\n                \"<div class='sp-top sp-cf'>\",\n                \"<div class='sp-fill'></div>\",\n                \"<div class='sp-top-inner'>\",\n                \"<div class='sp-color'>\",\n                \"<div class='sp-sat'>\",\n                \"<div class='sp-val'>\",\n                \"<div class='sp-dragger'></div>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-clear sp-clear-display'>\",\n                \"</div>\",\n                \"<div class='sp-hue'>\",\n                \"<div class='sp-slider'></div>\",\n                gradientFix,\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-alpha'><div class='sp-alpha-inner'><div class='sp-alpha-handle'></div></div></div>\",\n                \"</div>\",\n                \"<div class='sp-input-container sp-cf'>\",\n                \"<input class='sp-input' type='text' spellcheck='false'  />\",\n                \"</div>\",\n                \"<div class='sp-initial sp-thumb sp-cf'></div>\",\n                \"<div class='sp-button-container sp-cf'>\",\n                \"<a class='sp-cancel' href='#'></a>\",\n                \"<button type='button' class='sp-choose'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\"\n            ].join(\"\");\n        })();\n\n    function paletteTemplate (p, color, className, opts) {\n        var html = [];\n        for (var i = 0; i < p.length; i++) {\n            var current = p[i];\n            if(current) {\n                var tiny = tinycolor(current);\n                var c = tiny.toHsl().l < 0.5 ? \"sp-thumb-el sp-thumb-dark\" : \"sp-thumb-el sp-thumb-light\";\n                c += (tinycolor.equals(color, current)) ? \" sp-thumb-active\" : \"\";\n                var formattedString = tiny.toString(opts.preferredFormat || \"rgb\");\n                var swatchStyle = rgbaSupport ? (\"background-color:\" + tiny.toRgbString()) : \"filter:\" + tiny.toFilter();\n                html.push('<span title=\"' + formattedString + '\" data-color=\"' + tiny.toRgbString() + '\" class=\"' + c + '\"><span class=\"sp-thumb-inner\" style=\"' + swatchStyle + ';\"></span></span>');\n            } else {\n                var cls = 'sp-clear-display';\n                html.push($('<div />')\n                    .append($('<span data-color=\"\" style=\"background-color:transparent;\" class=\"' + cls + '\"></span>')\n                        .attr('title', opts.noColorSelectedText)\n                    )\n                    .html()\n                );\n            }\n        }\n        return \"<div class='sp-cf \" + className + \"'>\" + html.join('') + \"</div>\";\n    }\n\n    function hideAll() {\n        for (var i = 0; i < spectrums.length; i++) {\n            if (spectrums[i]) {\n                spectrums[i].hide();\n            }\n        }\n    }\n\n    function instanceOptions(o, callbackContext) {\n        var opts = $.extend({}, defaultOpts, o);\n        opts.callbacks = {\n            'move': bind(opts.move, callbackContext),\n            'change': bind(opts.change, callbackContext),\n            'show': bind(opts.show, callbackContext),\n            'hide': bind(opts.hide, callbackContext),\n            'beforeShow': bind(opts.beforeShow, callbackContext)\n        };\n\n        return opts;\n    }\n\n    function spectrum(element, o) {\n\n        var opts = instanceOptions(o, element),\n            flat = opts.flat,\n            showSelectionPalette = opts.showSelectionPalette,\n            localStorageKey = opts.localStorageKey,\n            theme = opts.theme,\n            callbacks = opts.callbacks,\n            resize = throttle(reflow, 10),\n            visible = false,\n            isDragging = false,\n            dragWidth = 0,\n            dragHeight = 0,\n            dragHelperHeight = 0,\n            slideHeight = 0,\n            slideWidth = 0,\n            alphaWidth = 0,\n            alphaSlideHelperWidth = 0,\n            slideHelperHeight = 0,\n            currentHue = 0,\n            currentSaturation = 0,\n            currentValue = 0,\n            currentAlpha = 1,\n            palette = [],\n            paletteArray = [],\n            paletteLookup = {},\n            selectionPalette = opts.selectionPalette.slice(0),\n            maxSelectionSize = opts.maxSelectionSize,\n            draggingClass = \"sp-dragging\",\n            shiftMovementDirection = null;\n\n        var doc = element.ownerDocument,\n            body = doc.body,\n            boundElement = $(element),\n            disabled = false,\n            container = $(markup, doc).addClass(theme),\n            pickerContainer = container.find(\".sp-picker-container\"),\n            dragger = container.find(\".sp-color\"),\n            dragHelper = container.find(\".sp-dragger\"),\n            slider = container.find(\".sp-hue\"),\n            slideHelper = container.find(\".sp-slider\"),\n            alphaSliderInner = container.find(\".sp-alpha-inner\"),\n            alphaSlider = container.find(\".sp-alpha\"),\n            alphaSlideHelper = container.find(\".sp-alpha-handle\"),\n            textInput = container.find(\".sp-input\"),\n            paletteContainer = container.find(\".sp-palette\"),\n            initialColorContainer = container.find(\".sp-initial\"),\n            cancelButton = container.find(\".sp-cancel\"),\n            clearButton = container.find(\".sp-clear\"),\n            chooseButton = container.find(\".sp-choose\"),\n            toggleButton = container.find(\".sp-palette-toggle\"),\n            isInput = boundElement.is(\"input\"),\n            isInputTypeColor = isInput && boundElement.attr(\"type\") === \"color\" && inputTypeColorSupport(),\n            shouldReplace = isInput && !flat,\n            replacer = (shouldReplace) ? $(replaceInput).addClass(theme).addClass(opts.className).addClass(opts.replacerClassName) : $([]),\n            offsetElement = (shouldReplace) ? replacer : boundElement,\n            previewElement = replacer.find(\".sp-preview-inner\"),\n            initialColor = opts.color || (isInput && boundElement.val()),\n            colorOnShow = false,\n            currentPreferredFormat = opts.preferredFormat,\n            clickoutFiresChange = !opts.showButtons || opts.clickoutFiresChange,\n            isEmpty = !initialColor,\n            allowEmpty = opts.allowEmpty && !isInputTypeColor;\n\n        function applyOptions() {\n\n            if (opts.showPaletteOnly) {\n                opts.showPalette = true;\n            }\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n\n            if (opts.palette) {\n                palette = opts.palette.slice(0);\n                paletteArray = $.isArray(palette[0]) ? palette : [palette];\n                paletteLookup = {};\n                for (var i = 0; i < paletteArray.length; i++) {\n                    for (var j = 0; j < paletteArray[i].length; j++) {\n                        var rgb = tinycolor(paletteArray[i][j]).toRgbString();\n                        paletteLookup[rgb] = true;\n                    }\n                }\n            }\n\n            container.toggleClass(\"sp-flat\", flat);\n            container.toggleClass(\"sp-input-disabled\", !opts.showInput);\n            container.toggleClass(\"sp-alpha-enabled\", opts.showAlpha);\n            container.toggleClass(\"sp-clear-enabled\", allowEmpty);\n            container.toggleClass(\"sp-buttons-disabled\", !opts.showButtons);\n            container.toggleClass(\"sp-palette-buttons-disabled\", !opts.togglePaletteOnly);\n            container.toggleClass(\"sp-palette-disabled\", !opts.showPalette);\n            container.toggleClass(\"sp-palette-only\", opts.showPaletteOnly);\n            container.toggleClass(\"sp-initial-disabled\", !opts.showInitial);\n            container.addClass(opts.className).addClass(opts.containerClassName);\n\n            reflow();\n        }\n\n        function initialize() {\n\n            if (IE) {\n                container.find(\"*:not(input)\").attr(\"unselectable\", \"on\");\n            }\n\n            applyOptions();\n\n            if (shouldReplace) {\n                boundElement.after(replacer).hide();\n            }\n\n            if (!allowEmpty) {\n                clearButton.hide();\n            }\n\n            if (flat) {\n                boundElement.after(container).hide();\n            }\n            else {\n\n                var appendTo = opts.appendTo === \"parent\" ? boundElement.parent() : $(opts.appendTo);\n                if (appendTo.length !== 1) {\n                    appendTo = $(\"body\");\n                }\n\n                appendTo.append(container);\n            }\n\n            updateSelectionPaletteFromStorage();\n\n            offsetElement.on(\"click.spectrum touchstart.spectrum\", function (e) {\n                if (!disabled) {\n                    toggle();\n                }\n\n                e.stopPropagation();\n\n                if (!$(e.target).is(\"input\")) {\n                    e.preventDefault();\n                }\n            });\n\n            if(boundElement.is(\":disabled\") || (opts.disabled === true)) {\n                disable();\n            }\n\n            // Prevent clicks from bubbling up to document.  This would cause it to be hidden.\n            container.click(stopPropagation);\n\n            // Handle user typed input\n            textInput.change(setFromTextInput);\n            textInput.on(\"paste\", function () {\n                setTimeout(setFromTextInput, 1);\n            });\n            textInput.keydown(function (e) { if (e.keyCode == 13) { setFromTextInput(); } });\n\n            cancelButton.text(opts.cancelText);\n            cancelButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                revert();\n                hide();\n            });\n\n            clearButton.attr(\"title\", opts.clearText);\n            clearButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                isEmpty = true;\n                move();\n\n                if(flat) {\n                    //for the flat style, this is a change event\n                    updateOriginalInput(true);\n                }\n            });\n\n            chooseButton.text(opts.chooseText);\n            chooseButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                if (IE && textInput.is(\":focus\")) {\n                    textInput.trigger('change');\n                }\n\n                if (isValid()) {\n                    updateOriginalInput(true);\n                    hide();\n                }\n            });\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n            toggleButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                opts.showPaletteOnly = !opts.showPaletteOnly;\n\n                // To make sure the Picker area is drawn on the right, next to the\n                // Palette area (and not below the palette), first move the Palette\n                // to the left to make space for the picker, plus 5px extra.\n                // The 'applyOptions' function puts the whole container back into place\n                // and takes care of the button-text and the sp-palette-only CSS class.\n                if (!opts.showPaletteOnly && !flat) {\n                    container.css('left', '-=' + (pickerContainer.outerWidth(true) + 5));\n                }\n                applyOptions();\n            });\n\n            draggable(alphaSlider, function (dragX, dragY, e) {\n                currentAlpha = (dragX / alphaWidth);\n                isEmpty = false;\n                if (e.shiftKey) {\n                    currentAlpha = Math.round(currentAlpha * 10) / 10;\n                }\n\n                move();\n            }, dragStart, dragStop);\n\n            draggable(slider, function (dragX, dragY) {\n                currentHue = parseFloat(dragY / slideHeight);\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n                move();\n            }, dragStart, dragStop);\n\n            draggable(dragger, function (dragX, dragY, e) {\n\n                // shift+drag should snap the movement to either the x or y axis.\n                if (!e.shiftKey) {\n                    shiftMovementDirection = null;\n                }\n                else if (!shiftMovementDirection) {\n                    var oldDragX = currentSaturation * dragWidth;\n                    var oldDragY = dragHeight - (currentValue * dragHeight);\n                    var furtherFromX = Math.abs(dragX - oldDragX) > Math.abs(dragY - oldDragY);\n\n                    shiftMovementDirection = furtherFromX ? \"x\" : \"y\";\n                }\n\n                var setSaturation = !shiftMovementDirection || shiftMovementDirection === \"x\";\n                var setValue = !shiftMovementDirection || shiftMovementDirection === \"y\";\n\n                if (setSaturation) {\n                    currentSaturation = parseFloat(dragX / dragWidth);\n                }\n                if (setValue) {\n                    currentValue = parseFloat((dragHeight - dragY) / dragHeight);\n                }\n\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n\n                move();\n\n            }, dragStart, dragStop);\n\n            if (!!initialColor) {\n                set(initialColor);\n\n                // In case color was black - update the preview UI and set the format\n                // since the set function will not run (default color is black).\n                updateUI();\n                currentPreferredFormat = opts.preferredFormat || tinycolor(initialColor).format;\n\n                addColorToSelectionPalette(initialColor);\n            }\n            else {\n                updateUI();\n            }\n\n            if (flat) {\n                show();\n            }\n\n            function paletteElementClick(e) {\n                if (e.data && e.data.ignore) {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n                }\n                else {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n\n                    updateOriginalInput(true);\n                    if (opts.hideAfterPaletteSelect) {\n                        hide();\n                    }\n                }\n\n                return false;\n            }\n\n            var paletteEvent = IE ? \"mousedown.spectrum\" : \"click.spectrum touchstart.spectrum\";\n            paletteContainer.on(paletteEvent, \".sp-thumb-el\", paletteElementClick);\n            initialColorContainer.on(paletteEvent, \".sp-thumb-el:nth-child(1)\", { ignore: true }, paletteElementClick);\n        }\n\n        function updateSelectionPaletteFromStorage() {\n\n            if (localStorageKey && window.localStorage) {\n\n                // Migrate old palettes over to new format.  May want to remove this eventually.\n                try {\n                    var oldPalette = window.localStorage[localStorageKey].split(\",#\");\n                    if (oldPalette.length > 1) {\n                        delete window.localStorage[localStorageKey];\n                        $.each(oldPalette, function(i, c) {\n                            addColorToSelectionPalette(c);\n                        });\n                    }\n                }\n                catch(e) { }\n\n                try {\n                    selectionPalette = window.localStorage[localStorageKey].split(\";\");\n                }\n                catch (e) { }\n            }\n        }\n\n        function addColorToSelectionPalette(color) {\n            if (showSelectionPalette) {\n                var rgb = tinycolor(color).toRgbString();\n                if (!paletteLookup[rgb] && $.inArray(rgb, selectionPalette) === -1) {\n                    selectionPalette.push(rgb);\n                    while(selectionPalette.length > maxSelectionSize) {\n                        selectionPalette.shift();\n                    }\n                }\n\n                if (localStorageKey && window.localStorage) {\n                    try {\n                        window.localStorage[localStorageKey] = selectionPalette.join(\";\");\n                    }\n                    catch(e) { }\n                }\n            }\n        }\n\n        function getUniqueSelectionPalette() {\n            var unique = [];\n            if (opts.showPalette) {\n                for (var i = 0; i < selectionPalette.length; i++) {\n                    var rgb = tinycolor(selectionPalette[i]).toRgbString();\n\n                    if (!paletteLookup[rgb]) {\n                        unique.push(selectionPalette[i]);\n                    }\n                }\n            }\n\n            return unique.reverse().slice(0, opts.maxSelectionSize);\n        }\n\n        function drawPalette() {\n\n            var currentColor = get();\n\n            var html = $.map(paletteArray, function (palette, i) {\n                return paletteTemplate(palette, currentColor, \"sp-palette-row sp-palette-row-\" + i, opts);\n            });\n\n            updateSelectionPaletteFromStorage();\n\n            if (selectionPalette) {\n                html.push(paletteTemplate(getUniqueSelectionPalette(), currentColor, \"sp-palette-row sp-palette-row-selection\", opts));\n            }\n\n            paletteContainer.html(html.join(\"\"));\n        }\n\n        function drawInitial() {\n            if (opts.showInitial) {\n                var initial = colorOnShow;\n                var current = get();\n                initialColorContainer.html(paletteTemplate([initial, current], current, \"sp-palette-row-initial\", opts));\n            }\n        }\n\n        function dragStart() {\n            if (dragHeight <= 0 || dragWidth <= 0 || slideHeight <= 0) {\n                reflow();\n            }\n            isDragging = true;\n            container.addClass(draggingClass);\n            shiftMovementDirection = null;\n            boundElement.trigger('dragstart.spectrum', [ get() ]);\n        }\n\n        function dragStop() {\n            isDragging = false;\n            container.removeClass(draggingClass);\n            boundElement.trigger('dragstop.spectrum', [ get() ]);\n        }\n\n        function setFromTextInput() {\n\n            var value = textInput.val();\n\n            if ((value === null || value === \"\") && allowEmpty) {\n                set(null);\n                move();\n                updateOriginalInput();\n            }\n            else {\n                var tiny = tinycolor(value);\n                if (tiny.isValid()) {\n                    set(tiny);\n                    move();\n                    updateOriginalInput(true);\n                }\n                else {\n                    textInput.addClass(\"sp-validation-error\");\n                }\n            }\n        }\n\n        function toggle() {\n            if (visible) {\n                hide();\n            }\n            else {\n                show();\n            }\n        }\n\n        function show() {\n            var event = $.Event('beforeShow.spectrum');\n\n            if (visible) {\n                reflow();\n                return;\n            }\n\n            boundElement.trigger(event, [ get() ]);\n\n            if (callbacks.beforeShow(get()) === false || event.isDefaultPrevented()) {\n                return;\n            }\n\n            hideAll();\n            visible = true;\n\n            $(doc).on(\"keydown.spectrum\", onkeydown);\n            $(doc).on(\"click.spectrum\", clickout);\n            $(window).on(\"resize.spectrum\", resize);\n            replacer.addClass(\"sp-active\");\n            container.removeClass(\"sp-hidden\");\n\n            reflow();\n            updateUI();\n\n            colorOnShow = get();\n\n            drawInitial();\n            callbacks.show(colorOnShow);\n            boundElement.trigger('show.spectrum', [ colorOnShow ]);\n        }\n\n        function onkeydown(e) {\n            // Close on ESC\n            if (e.keyCode === 27) {\n                hide();\n            }\n        }\n\n        function clickout(e) {\n            // Return on right click.\n            if (e.button == 2) { return; }\n\n            // If a drag event was happening during the mouseup, don't hide\n            // on click.\n            if (isDragging) { return; }\n\n            if (clickoutFiresChange) {\n                updateOriginalInput(true);\n            }\n            else {\n                revert();\n            }\n            hide();\n        }\n\n        function hide() {\n            // Return if hiding is unnecessary\n            if (!visible || flat) { return; }\n            visible = false;\n\n            $(doc).off(\"keydown.spectrum\", onkeydown);\n            $(doc).off(\"click.spectrum\", clickout);\n            $(window).off(\"resize.spectrum\", resize);\n\n            replacer.removeClass(\"sp-active\");\n            container.addClass(\"sp-hidden\");\n\n            callbacks.hide(get());\n            boundElement.trigger('hide.spectrum', [ get() ]);\n        }\n\n        function revert() {\n            set(colorOnShow, true);\n            updateOriginalInput(true);\n        }\n\n        function set(color, ignoreFormatChange) {\n            if (tinycolor.equals(color, get())) {\n                // Update UI just in case a validation error needs\n                // to be cleared.\n                updateUI();\n                return;\n            }\n\n            var newColor, newHsv;\n            if (!color && allowEmpty) {\n                isEmpty = true;\n            } else {\n                isEmpty = false;\n                newColor = tinycolor(color);\n                newHsv = newColor.toHsv();\n\n                currentHue = (newHsv.h % 360) / 360;\n                currentSaturation = newHsv.s;\n                currentValue = newHsv.v;\n                currentAlpha = newHsv.a;\n            }\n            updateUI();\n\n            if (newColor && newColor.isValid() && !ignoreFormatChange) {\n                currentPreferredFormat = opts.preferredFormat || newColor.getFormat();\n            }\n        }\n\n        function get(opts) {\n            opts = opts || { };\n\n            if (allowEmpty && isEmpty) {\n                return null;\n            }\n\n            return tinycolor.fromRatio({\n                h: currentHue,\n                s: currentSaturation,\n                v: currentValue,\n                a: Math.round(currentAlpha * 1000) / 1000\n            }, { format: opts.format || currentPreferredFormat });\n        }\n\n        function isValid() {\n            return !textInput.hasClass(\"sp-validation-error\");\n        }\n\n        function move() {\n            updateUI();\n\n            callbacks.move(get());\n            boundElement.trigger('move.spectrum', [ get() ]);\n        }\n\n        function updateUI() {\n\n            textInput.removeClass(\"sp-validation-error\");\n\n            updateHelperLocations();\n\n            // Update dragger background color (gradients take care of saturation and value).\n            var flatColor = tinycolor.fromRatio({ h: currentHue, s: 1, v: 1 });\n            dragger.css(\"background-color\", flatColor.toHexString());\n\n            // Get a format that alpha will be included in (hex and names ignore alpha)\n            var format = currentPreferredFormat;\n            if (currentAlpha < 1 && !(currentAlpha === 0 && format === \"name\")) {\n                if (format === \"hex\" || format === \"hex3\" || format === \"hex6\" || format === \"name\") {\n                    format = \"rgb\";\n                }\n            }\n\n            var realColor = get({ format: format }),\n                displayColor = '';\n\n            //reset background info for preview element\n            previewElement.removeClass(\"sp-clear-display\");\n            previewElement.css('background-color', 'transparent');\n\n            if (!realColor && allowEmpty) {\n                // Update the replaced elements background with icon indicating no color selection\n                previewElement.addClass(\"sp-clear-display\");\n            }\n            else {\n                var realHex = realColor.toHexString(),\n                    realRgb = realColor.toRgbString();\n\n                // Update the replaced elements background color (with actual selected color)\n                if (rgbaSupport || realColor.alpha === 1) {\n                    previewElement.css(\"background-color\", realRgb);\n                }\n                else {\n                    previewElement.css(\"background-color\", \"transparent\");\n                    previewElement.css(\"filter\", realColor.toFilter());\n                }\n\n                if (opts.showAlpha) {\n                    var rgb = realColor.toRgb();\n                    rgb.a = 0;\n                    var realAlpha = tinycolor(rgb).toRgbString();\n                    var gradient = \"linear-gradient(left, \" + realAlpha + \", \" + realHex + \")\";\n\n                    if (IE) {\n                        alphaSliderInner.css(\"filter\", tinycolor(realAlpha).toFilter({ gradientType: 1 }, realHex));\n                    }\n                    else {\n                        alphaSliderInner.css(\"background\", \"-webkit-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-moz-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-ms-\" + gradient);\n                        // Use current syntax gradient on unprefixed property.\n                        alphaSliderInner.css(\"background\",\n                            \"linear-gradient(to right, \" + realAlpha + \", \" + realHex + \")\");\n                    }\n                }\n\n                displayColor = realColor.toString(format);\n            }\n\n            // Update the text entry input as it changes happen\n            if (opts.showInput) {\n                textInput.val(displayColor);\n            }\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            drawInitial();\n        }\n\n        function updateHelperLocations() {\n            var s = currentSaturation;\n            var v = currentValue;\n\n            if(allowEmpty && isEmpty) {\n                //if selected color is empty, hide the helpers\n                alphaSlideHelper.hide();\n                slideHelper.hide();\n                dragHelper.hide();\n            }\n            else {\n                //make sure helpers are visible\n                alphaSlideHelper.show();\n                slideHelper.show();\n                dragHelper.show();\n\n                // Where to show the little circle in that displays your current selected color\n                var dragX = s * dragWidth;\n                var dragY = dragHeight - (v * dragHeight);\n                dragX = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragWidth - dragHelperHeight, dragX - dragHelperHeight)\n                );\n                dragY = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragHeight - dragHelperHeight, dragY - dragHelperHeight)\n                );\n                dragHelper.css({\n                    \"top\": dragY + \"px\",\n                    \"left\": dragX + \"px\"\n                });\n\n                var alphaX = currentAlpha * alphaWidth;\n                alphaSlideHelper.css({\n                    \"left\": (alphaX - (alphaSlideHelperWidth / 2)) + \"px\"\n                });\n\n                // Where to show the bar that displays your current selected hue\n                var slideY = (currentHue) * slideHeight;\n                slideHelper.css({\n                    \"top\": (slideY - slideHelperHeight) + \"px\"\n                });\n            }\n        }\n\n        function updateOriginalInput(fireCallback) {\n            var color = get(),\n                displayColor = '',\n                hasChanged = !tinycolor.equals(color, colorOnShow);\n\n            if (color) {\n                displayColor = color.toString(currentPreferredFormat);\n                // Update the selection palette with the current color\n                addColorToSelectionPalette(color);\n            }\n\n            if (isInput) {\n                boundElement.val(displayColor);\n            }\n\n            if (fireCallback && hasChanged) {\n                callbacks.change(color);\n                boundElement.trigger('change', [ color ]);\n            }\n        }\n\n        function reflow() {\n            if (!visible) {\n                return; // Calculations would be useless and wouldn't be reliable anyways\n            }\n            dragWidth = dragger.width();\n            dragHeight = dragger.height();\n            dragHelperHeight = dragHelper.height();\n            slideWidth = slider.width();\n            slideHeight = slider.height();\n            slideHelperHeight = slideHelper.height();\n            alphaWidth = alphaSlider.width();\n            alphaSlideHelperWidth = alphaSlideHelper.width();\n\n            if (!flat) {\n                container.css(\"position\", \"absolute\");\n                if (opts.offset) {\n                    container.offset(opts.offset);\n                } else {\n                    container.offset(getOffset(container, offsetElement));\n                }\n            }\n\n            updateHelperLocations();\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            boundElement.trigger('reflow.spectrum');\n        }\n\n        function destroy() {\n            boundElement.show();\n            offsetElement.off(\"click.spectrum touchstart.spectrum\");\n            container.remove();\n            replacer.remove();\n            spectrums[spect.id] = null;\n        }\n\n        function option(optionName, optionValue) {\n            if (optionName === undefined) {\n                return $.extend({}, opts);\n            }\n            if (optionValue === undefined) {\n                return opts[optionName];\n            }\n\n            opts[optionName] = optionValue;\n\n            if (optionName === \"preferredFormat\") {\n                currentPreferredFormat = opts.preferredFormat;\n            }\n            applyOptions();\n        }\n\n        function enable() {\n            disabled = false;\n            boundElement.attr(\"disabled\", false);\n            offsetElement.removeClass(\"sp-disabled\");\n        }\n\n        function disable() {\n            hide();\n            disabled = true;\n            boundElement.attr(\"disabled\", true);\n            offsetElement.addClass(\"sp-disabled\");\n        }\n\n        function setOffset(coord) {\n            opts.offset = coord;\n            reflow();\n        }\n\n        initialize();\n\n        var spect = {\n            show: show,\n            hide: hide,\n            toggle: toggle,\n            reflow: reflow,\n            option: option,\n            enable: enable,\n            disable: disable,\n            offset: setOffset,\n            set: function (c) {\n                set(c);\n                updateOriginalInput();\n            },\n            get: get,\n            destroy: destroy,\n            container: container\n        };\n\n        spect.id = spectrums.push(spect) - 1;\n\n        return spect;\n    }\n\n    /**\n     * checkOffset - get the offset below/above and left/right element depending on screen position\n     * Thanks https://github.com/jquery/jquery-ui/blob/master/ui/jquery.ui.datepicker.js\n     */\n    function getOffset(picker, input) {\n        var extraY = 0;\n        var dpWidth = picker.outerWidth();\n        var dpHeight = picker.outerHeight();\n        var inputHeight = input.outerHeight();\n        var doc = picker[0].ownerDocument;\n        var docElem = doc.documentElement;\n        var viewWidth = docElem.clientWidth + $(doc).scrollLeft();\n        var viewHeight = docElem.clientHeight + $(doc).scrollTop();\n        var offset = input.offset();\n        var offsetLeft = offset.left;\n        var offsetTop = offset.top;\n\n        offsetTop += inputHeight;\n\n        offsetLeft -=\n            Math.min(offsetLeft, (offsetLeft + dpWidth > viewWidth && viewWidth > dpWidth) ?\n                Math.abs(offsetLeft + dpWidth - viewWidth) : 0);\n\n        offsetTop -=\n            Math.min(offsetTop, ((offsetTop + dpHeight > viewHeight && viewHeight > dpHeight) ?\n                Math.abs(dpHeight + inputHeight - extraY) : extraY));\n\n        return {\n            top: offsetTop,\n            bottom: offset.bottom,\n            left: offsetLeft,\n            right: offset.right,\n            width: offset.width,\n            height: offset.height\n        };\n    }\n\n    /**\n     * noop - do nothing\n     */\n    function noop() {\n\n    }\n\n    /**\n     * stopPropagation - makes the code only doing this a little easier to read in line\n     */\n    function stopPropagation(e) {\n        e.stopPropagation();\n    }\n\n    /**\n     * Create a function bound to a given object\n     * Thanks to underscore.js\n     */\n    function bind(func, obj) {\n        var slice = Array.prototype.slice;\n        var args = slice.call(arguments, 2);\n        return function () {\n            return func.apply(obj, args.concat(slice.call(arguments)));\n        };\n    }\n\n    /**\n     * Lightweight drag helper.  Handles containment within the element, so that\n     * when dragging, the x is within [0,element.width] and y is within [0,element.height]\n     */\n    function draggable(element, onmove, onstart, onstop) {\n        onmove = onmove || function () { };\n        onstart = onstart || function () { };\n        onstop = onstop || function () { };\n        var doc = document;\n        var dragging = false;\n        var offset = {};\n        var maxHeight = 0;\n        var maxWidth = 0;\n        var hasTouch = ('ontouchstart' in window);\n\n        var duringDragEvents = {};\n        duringDragEvents[\"selectstart\"] = prevent;\n        duringDragEvents[\"dragstart\"] = prevent;\n        duringDragEvents[\"touchmove mousemove\"] = move;\n        duringDragEvents[\"touchend mouseup\"] = stop;\n\n        function prevent(e) {\n            if (e.stopPropagation) {\n                e.stopPropagation();\n            }\n            if (e.preventDefault) {\n                e.preventDefault();\n            }\n            e.returnValue = false;\n        }\n\n        function move(e) {\n            if (dragging) {\n                // Mouseup happened outside of window\n                if (IE && doc.documentMode < 9 && !e.button) {\n                    return stop();\n                }\n\n                var t0 = e.originalEvent && e.originalEvent.touches && e.originalEvent.touches[0];\n                var pageX = t0 && t0.pageX || e.pageX;\n                var pageY = t0 && t0.pageY || e.pageY;\n\n                var dragX = Math.max(0, Math.min(pageX - offset.left, maxWidth));\n                var dragY = Math.max(0, Math.min(pageY - offset.top, maxHeight));\n\n                if (hasTouch) {\n                    // Stop scrolling in iOS\n                    prevent(e);\n                }\n\n                onmove.apply(element, [dragX, dragY, e]);\n            }\n        }\n\n        function start(e) {\n            var rightclick = (e.which) ? (e.which == 3) : (e.button == 2);\n\n            if (!rightclick && !dragging) {\n                if (onstart.apply(element, arguments) !== false) {\n                    dragging = true;\n                    maxHeight = $(element).height();\n                    maxWidth = $(element).width();\n                    offset = $(element).offset();\n\n                    $(doc).on(duringDragEvents);\n                    $(doc.body).addClass(\"sp-dragging\");\n\n                    move(e);\n\n                    prevent(e);\n                }\n            }\n        }\n\n        function stop() {\n            if (dragging) {\n                $(doc).off(duringDragEvents);\n                $(doc.body).removeClass(\"sp-dragging\");\n\n                // Wait a tick before notifying observers to allow the click event\n                // to fire in Chrome.\n                setTimeout(function() {\n                    onstop.apply(element, arguments);\n                }, 0);\n            }\n            dragging = false;\n        }\n\n        $(element).on(\"touchstart mousedown\", start);\n    }\n\n    function throttle(func, wait, debounce) {\n        var timeout;\n        return function () {\n            var context = this, args = arguments;\n            var throttler = function () {\n                timeout = null;\n                func.apply(context, args);\n            };\n            if (debounce) clearTimeout(timeout);\n            if (debounce || !timeout) timeout = setTimeout(throttler, wait);\n        };\n    }\n\n    function inputTypeColorSupport() {\n        return $.fn.spectrum.inputTypeColorSupport();\n    }\n\n    /**\n     * Define a jQuery plugin\n     */\n    var dataID = \"spectrum.id\";\n    $.fn.spectrum = function (opts, extra) {\n\n        if (typeof opts == \"string\") {\n\n            var returnValue = this;\n            var args = Array.prototype.slice.call( arguments, 1 );\n\n            this.each(function () {\n                var spect = spectrums[$(this).data(dataID)];\n                if (spect) {\n                    var method = spect[opts];\n                    if (!method) {\n                        throw new Error( \"Spectrum: no such method: '\" + opts + \"'\" );\n                    }\n\n                    if (opts == \"get\") {\n                        returnValue = spect.get();\n                    }\n                    else if (opts == \"container\") {\n                        returnValue = spect.container;\n                    }\n                    else if (opts == \"option\") {\n                        returnValue = spect.option.apply(spect, args);\n                    }\n                    else if (opts == \"destroy\") {\n                        spect.destroy();\n                        $(this).removeData(dataID);\n                    }\n                    else {\n                        method.apply(spect, args);\n                    }\n                }\n            });\n\n            return returnValue;\n        }\n\n        // Initializing a new instance of spectrum\n        return this.spectrum(\"destroy\").each(function () {\n            var options = $.extend({}, $(this).data(), opts);\n            var spect = spectrum(this, options);\n            $(this).data(dataID, spect.id);\n        });\n    };\n\n    $.fn.spectrum.load = true;\n    $.fn.spectrum.loadOpts = {};\n    $.fn.spectrum.draggable = draggable;\n    $.fn.spectrum.defaults = defaultOpts;\n    $.fn.spectrum.inputTypeColorSupport = function inputTypeColorSupport() {\n        if (typeof inputTypeColorSupport._cachedResult === \"undefined\") {\n            var colorInput = $(\"<input type='color'/>\")[0]; // if color element is supported, value will default to not null\n            inputTypeColorSupport._cachedResult = colorInput.type === \"color\" && colorInput.value !== \"\";\n        }\n        return inputTypeColorSupport._cachedResult;\n    };\n\n    $.spectrum = { };\n    $.spectrum.localization = { };\n    $.spectrum.palettes = { };\n\n    $.fn.spectrum.processNativeColorInputs = function () {\n        var colorInputs = $(\"input[type=color]\");\n        if (colorInputs.length && !inputTypeColorSupport()) {\n            colorInputs.spectrum({\n                preferredFormat: \"hex6\"\n            });\n        }\n    };\n\n    // TinyColor v1.1.2\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    (function() {\n\n        var trimLeft = /^[\\s,#]+/,\n            trimRight = /\\s+$/,\n            tinyCounter = 0,\n            math = Math,\n            mathRound = math.round,\n            mathMin = math.min,\n            mathMax = math.max,\n            mathRandom = math.random;\n\n        var tinycolor = function(color, opts) {\n\n            color = (color) ? color : '';\n            opts = opts || { };\n\n            // If input is already a tinycolor, return itself\n            if (color instanceof tinycolor) {\n                return color;\n            }\n            // If we are called as a function, call using new instead\n            if (!(this instanceof tinycolor)) {\n                return new tinycolor(color, opts);\n            }\n\n            var rgb = inputToRGB(color);\n            this._originalInput = color;\n            this._r = rgb.r;\n            this._g = rgb.g;\n            this._b = rgb.b;\n            this._a = rgb.a;\n            this._roundA = mathRound(1000 * this._a) / 1000;\n            this._format = opts.format || rgb.format;\n            this._gradientType = opts.gradientType;\n\n            // Don't let the range of [0,255] come back in [0,1].\n            // Potentially lose a little bit of precision here, but will fix issues where\n            // .5 gets interpreted as half of the total, instead of half of 1\n            // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n            if (this._r < 1) { this._r = mathRound(this._r); }\n            if (this._g < 1) { this._g = mathRound(this._g); }\n            if (this._b < 1) { this._b = mathRound(this._b); }\n\n            this._ok = rgb.ok;\n            this._tc_id = tinyCounter++;\n        };\n\n        tinycolor.prototype = {\n            isDark: function() {\n                return this.getBrightness() < 128;\n            },\n            isLight: function() {\n                return !this.isDark();\n            },\n            isValid: function() {\n                return this._ok;\n            },\n            getOriginalInput: function() {\n                return this._originalInput;\n            },\n            getFormat: function() {\n                return this._format;\n            },\n            getAlpha: function() {\n                return this._a;\n            },\n            getBrightness: function() {\n                var rgb = this.toRgb();\n                return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n            },\n            setAlpha: function(value) {\n                this._a = boundAlpha(value);\n                this._roundA = mathRound(1000 * this._a) / 1000;\n                return this;\n            },\n            toHsv: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n            },\n            toHsvString: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n                return (this._a == 1) ?\n                    \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                    \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n            },\n            toHsl: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n            },\n            toHslString: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n                return (this._a == 1) ?\n                    \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                    \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n            },\n            toHex: function(allow3Char) {\n                return rgbToHex(this._r, this._g, this._b, allow3Char);\n            },\n            toHexString: function(allow3Char) {\n                return '#' + this.toHex(allow3Char);\n            },\n            toHex8: function() {\n                return rgbaToHex(this._r, this._g, this._b, this._a);\n            },\n            toHex8String: function() {\n                return '#' + this.toHex8();\n            },\n            toRgb: function() {\n                return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n            },\n            toRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                    \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n            },\n            toPercentageRgb: function() {\n                return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n            },\n            toPercentageRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                    \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n            },\n            toName: function() {\n                if (this._a === 0) {\n                    return \"transparent\";\n                }\n\n                if (this._a < 1) {\n                    return false;\n                }\n\n                return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n            },\n            toFilter: function(secondColor) {\n                var hex8String = '#' + rgbaToHex(this._r, this._g, this._b, this._a);\n                var secondHex8String = hex8String;\n                var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n                if (secondColor) {\n                    var s = tinycolor(secondColor);\n                    secondHex8String = s.toHex8String();\n                }\n\n                return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n            },\n            toString: function(format) {\n                var formatSet = !!format;\n                format = format || this._format;\n\n                var formattedString = false;\n                var hasAlpha = this._a < 1 && this._a >= 0;\n                var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"name\");\n\n                if (needsAlphaFormat) {\n                    // Special case for \"transparent\", all other non-alpha formats\n                    // will return rgba when there is transparency.\n                    if (format === \"name\" && this._a === 0) {\n                        return this.toName();\n                    }\n                    return this.toRgbString();\n                }\n                if (format === \"rgb\") {\n                    formattedString = this.toRgbString();\n                }\n                if (format === \"prgb\") {\n                    formattedString = this.toPercentageRgbString();\n                }\n                if (format === \"hex\" || format === \"hex6\") {\n                    formattedString = this.toHexString();\n                }\n                if (format === \"hex3\") {\n                    formattedString = this.toHexString(true);\n                }\n                if (format === \"hex8\") {\n                    formattedString = this.toHex8String();\n                }\n                if (format === \"name\") {\n                    formattedString = this.toName();\n                }\n                if (format === \"hsl\") {\n                    formattedString = this.toHslString();\n                }\n                if (format === \"hsv\") {\n                    formattedString = this.toHsvString();\n                }\n\n                return formattedString || this.toHexString();\n            },\n\n            _applyModification: function(fn, args) {\n                var color = fn.apply(null, [this].concat([].slice.call(args)));\n                this._r = color._r;\n                this._g = color._g;\n                this._b = color._b;\n                this.setAlpha(color._a);\n                return this;\n            },\n            lighten: function() {\n                return this._applyModification(lighten, arguments);\n            },\n            brighten: function() {\n                return this._applyModification(brighten, arguments);\n            },\n            darken: function() {\n                return this._applyModification(darken, arguments);\n            },\n            desaturate: function() {\n                return this._applyModification(desaturate, arguments);\n            },\n            saturate: function() {\n                return this._applyModification(saturate, arguments);\n            },\n            greyscale: function() {\n                return this._applyModification(greyscale, arguments);\n            },\n            spin: function() {\n                return this._applyModification(spin, arguments);\n            },\n\n            _applyCombination: function(fn, args) {\n                return fn.apply(null, [this].concat([].slice.call(args)));\n            },\n            analogous: function() {\n                return this._applyCombination(analogous, arguments);\n            },\n            complement: function() {\n                return this._applyCombination(complement, arguments);\n            },\n            monochromatic: function() {\n                return this._applyCombination(monochromatic, arguments);\n            },\n            splitcomplement: function() {\n                return this._applyCombination(splitcomplement, arguments);\n            },\n            triad: function() {\n                return this._applyCombination(triad, arguments);\n            },\n            tetrad: function() {\n                return this._applyCombination(tetrad, arguments);\n            }\n        };\n\n        // If input is an object, force 1 into \"1.0\" to handle ratios properly\n        // String input requires \"1.0\" as input, so 1 will be treated as 1\n        tinycolor.fromRatio = function(color, opts) {\n            if (typeof color == \"object\") {\n                var newColor = {};\n                for (var i in color) {\n                    if (color.hasOwnProperty(i)) {\n                        if (i === \"a\") {\n                            newColor[i] = color[i];\n                        }\n                        else {\n                            newColor[i] = convertToPercentage(color[i]);\n                        }\n                    }\n                }\n                color = newColor;\n            }\n\n            return tinycolor(color, opts);\n        };\n\n        // Given a string or object, convert that input to RGB\n        // Possible string inputs:\n        //\n        //     \"red\"\n        //     \"#f00\" or \"f00\"\n        //     \"#ff0000\" or \"ff0000\"\n        //     \"#ff000000\" or \"ff000000\"\n        //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n        //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n        //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n        //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n        //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n        //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n        //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n        //\n        function inputToRGB(color) {\n\n            var rgb = { r: 0, g: 0, b: 0 };\n            var a = 1;\n            var ok = false;\n            var format = false;\n\n            if (typeof color == \"string\") {\n                color = stringInputToObject(color);\n            }\n\n            if (typeof color == \"object\") {\n                if (color.hasOwnProperty(\"r\") && color.hasOwnProperty(\"g\") && color.hasOwnProperty(\"b\")) {\n                    rgb = rgbToRgb(color.r, color.g, color.b);\n                    ok = true;\n                    format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"v\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.v = convertToPercentage(color.v);\n                    rgb = hsvToRgb(color.h, color.s, color.v);\n                    ok = true;\n                    format = \"hsv\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"l\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.l = convertToPercentage(color.l);\n                    rgb = hslToRgb(color.h, color.s, color.l);\n                    ok = true;\n                    format = \"hsl\";\n                }\n\n                if (color.hasOwnProperty(\"a\")) {\n                    a = color.a;\n                }\n            }\n\n            a = boundAlpha(a);\n\n            return {\n                ok: ok,\n                format: color.format || format,\n                r: mathMin(255, mathMax(rgb.r, 0)),\n                g: mathMin(255, mathMax(rgb.g, 0)),\n                b: mathMin(255, mathMax(rgb.b, 0)),\n                a: a\n            };\n        }\n\n\n        // Conversion Functions\n        // --------------------\n\n        // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n        // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n        // `rgbToRgb`\n        // Handle bounds / percentage checking to conform to CSS color spec\n        // <http://www.w3.org/TR/css3-color/>\n        // *Assumes:* r, g, b in [0, 255] or [0, 1]\n        // *Returns:* { r, g, b } in [0, 255]\n        function rgbToRgb(r, g, b){\n            return {\n                r: bound01(r, 255) * 255,\n                g: bound01(g, 255) * 255,\n                b: bound01(b, 255) * 255\n            };\n        }\n\n        // `rgbToHsl`\n        // Converts an RGB color value to HSL.\n        // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n        // *Returns:* { h, s, l } in [0,1]\n        function rgbToHsl(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, l = (max + min) / 2;\n\n            if(max == min) {\n                h = s = 0; // achromatic\n            }\n            else {\n                var d = max - min;\n                s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n\n                h /= 6;\n            }\n\n            return { h: h, s: s, l: l };\n        }\n\n        // `hslToRgb`\n        // Converts an HSL color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hslToRgb(h, s, l) {\n            var r, g, b;\n\n            h = bound01(h, 360);\n            s = bound01(s, 100);\n            l = bound01(l, 100);\n\n            function hue2rgb(p, q, t) {\n                if(t < 0) t += 1;\n                if(t > 1) t -= 1;\n                if(t < 1/6) return p + (q - p) * 6 * t;\n                if(t < 1/2) return q;\n                if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n                return p;\n            }\n\n            if(s === 0) {\n                r = g = b = l; // achromatic\n            }\n            else {\n                var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n                var p = 2 * l - q;\n                r = hue2rgb(p, q, h + 1/3);\n                g = hue2rgb(p, q, h);\n                b = hue2rgb(p, q, h - 1/3);\n            }\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHsv`\n        // Converts an RGB color value to HSV\n        // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n        // *Returns:* { h, s, v } in [0,1]\n        function rgbToHsv(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, v = max;\n\n            var d = max - min;\n            s = max === 0 ? 0 : d / max;\n\n            if(max == min) {\n                h = 0; // achromatic\n            }\n            else {\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n                h /= 6;\n            }\n            return { h: h, s: s, v: v };\n        }\n\n        // `hsvToRgb`\n        // Converts an HSV color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hsvToRgb(h, s, v) {\n\n            h = bound01(h, 360) * 6;\n            s = bound01(s, 100);\n            v = bound01(v, 100);\n\n            var i = math.floor(h),\n                f = h - i,\n                p = v * (1 - s),\n                q = v * (1 - f * s),\n                t = v * (1 - (1 - f) * s),\n                mod = i % 6,\n                r = [v, q, p, p, t, v][mod],\n                g = [t, v, v, q, p, p][mod],\n                b = [p, p, t, v, v, q][mod];\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHex`\n        // Converts an RGB color to hex\n        // Assumes r, g, and b are contained in the set [0, 255]\n        // Returns a 3 or 6 character hex\n        function rgbToHex(r, g, b, allow3Char) {\n\n            var hex = [\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            // Return a 3 character hex if possible\n            if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n                return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n            }\n\n            return hex.join(\"\");\n        }\n        // `rgbaToHex`\n        // Converts an RGBA color plus alpha transparency to hex\n        // Assumes r, g, b and a are contained in the set [0, 255]\n        // Returns an 8 character hex\n        function rgbaToHex(r, g, b, a) {\n\n            var hex = [\n                pad2(convertDecimalToHex(a)),\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            return hex.join(\"\");\n        }\n\n        // `equals`\n        // Can be called with any tinycolor input\n        tinycolor.equals = function (color1, color2) {\n            if (!color1 || !color2) { return false; }\n            return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n        };\n        tinycolor.random = function() {\n            return tinycolor.fromRatio({\n                r: mathRandom(),\n                g: mathRandom(),\n                b: mathRandom()\n            });\n        };\n\n\n        // Modification Functions\n        // ----------------------\n        // Thanks to less.js for some of the basics here\n        // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n        function desaturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s -= amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function saturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s += amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function greyscale(color) {\n            return tinycolor(color).desaturate(100);\n        }\n\n        function lighten (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l += amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        function brighten(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var rgb = tinycolor(color).toRgb();\n            rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n            rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n            rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n            return tinycolor(rgb);\n        }\n\n        function darken (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l -= amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n        // Values outside of this range will be wrapped into this range.\n        function spin(color, amount) {\n            var hsl = tinycolor(color).toHsl();\n            var hue = (mathRound(hsl.h) + amount) % 360;\n            hsl.h = hue < 0 ? 360 + hue : hue;\n            return tinycolor(hsl);\n        }\n\n        // Combination Functions\n        // ---------------------\n        // Thanks to jQuery xColor for some of the ideas behind these\n        // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n        function complement(color) {\n            var hsl = tinycolor(color).toHsl();\n            hsl.h = (hsl.h + 180) % 360;\n            return tinycolor(hsl);\n        }\n\n        function triad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function tetrad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function splitcomplement(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n                tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n            ];\n        }\n\n        function analogous(color, results, slices) {\n            results = results || 6;\n            slices = slices || 30;\n\n            var hsl = tinycolor(color).toHsl();\n            var part = 360 / slices;\n            var ret = [tinycolor(color)];\n\n            for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n                hsl.h = (hsl.h + part) % 360;\n                ret.push(tinycolor(hsl));\n            }\n            return ret;\n        }\n\n        function monochromatic(color, results) {\n            results = results || 6;\n            var hsv = tinycolor(color).toHsv();\n            var h = hsv.h, s = hsv.s, v = hsv.v;\n            var ret = [];\n            var modification = 1 / results;\n\n            while (results--) {\n                ret.push(tinycolor({ h: h, s: s, v: v}));\n                v = (v + modification) % 1;\n            }\n\n            return ret;\n        }\n\n        // Utility Functions\n        // ---------------------\n\n        tinycolor.mix = function(color1, color2, amount) {\n            amount = (amount === 0) ? 0 : (amount || 50);\n\n            var rgb1 = tinycolor(color1).toRgb();\n            var rgb2 = tinycolor(color2).toRgb();\n\n            var p = amount / 100;\n            var w = p * 2 - 1;\n            var a = rgb2.a - rgb1.a;\n\n            var w1;\n\n            if (w * a == -1) {\n                w1 = w;\n            } else {\n                w1 = (w + a) / (1 + w * a);\n            }\n\n            w1 = (w1 + 1) / 2;\n\n            var w2 = 1 - w1;\n\n            var rgba = {\n                r: rgb2.r * w1 + rgb1.r * w2,\n                g: rgb2.g * w1 + rgb1.g * w2,\n                b: rgb2.b * w1 + rgb1.b * w2,\n                a: rgb2.a * p  + rgb1.a * (1 - p)\n            };\n\n            return tinycolor(rgba);\n        };\n\n\n        // Readability Functions\n        // ---------------------\n        // <http://www.w3.org/TR/AERT#color-contrast>\n\n        // `readability`\n        // Analyze the 2 colors and returns an object with the following properties:\n        //    `brightness`: difference in brightness between the two colors\n        //    `color`: difference in color/hue between the two colors\n        tinycolor.readability = function(color1, color2) {\n            var c1 = tinycolor(color1);\n            var c2 = tinycolor(color2);\n            var rgb1 = c1.toRgb();\n            var rgb2 = c2.toRgb();\n            var brightnessA = c1.getBrightness();\n            var brightnessB = c2.getBrightness();\n            var colorDiff = (\n                Math.max(rgb1.r, rgb2.r) - Math.min(rgb1.r, rgb2.r) +\n                Math.max(rgb1.g, rgb2.g) - Math.min(rgb1.g, rgb2.g) +\n                Math.max(rgb1.b, rgb2.b) - Math.min(rgb1.b, rgb2.b)\n            );\n\n            return {\n                brightness: Math.abs(brightnessA - brightnessB),\n                color: colorDiff\n            };\n        };\n\n        // `readable`\n        // http://www.w3.org/TR/AERT#color-contrast\n        // Ensure that foreground and background color combinations provide sufficient contrast.\n        // *Example*\n        //    tinycolor.isReadable(\"#000\", \"#111\") => false\n        tinycolor.isReadable = function(color1, color2) {\n            var readability = tinycolor.readability(color1, color2);\n            return readability.brightness > 125 && readability.color > 500;\n        };\n\n        // `mostReadable`\n        // Given a base color and a list of possible foreground or background\n        // colors for that base, returns the most readable color.\n        // *Example*\n        //    tinycolor.mostReadable(\"#123\", [\"#fff\", \"#000\"]) => \"#000\"\n        tinycolor.mostReadable = function(baseColor, colorList) {\n            var bestColor = null;\n            var bestScore = 0;\n            var bestIsReadable = false;\n            for (var i=0; i < colorList.length; i++) {\n\n                // We normalize both around the \"acceptable\" breaking point,\n                // but rank brightness constrast higher than hue.\n\n                var readability = tinycolor.readability(baseColor, colorList[i]);\n                var readable = readability.brightness > 125 && readability.color > 500;\n                var score = 3 * (readability.brightness / 125) + (readability.color / 500);\n\n                if ((readable && ! bestIsReadable) ||\n                    (readable && bestIsReadable && score > bestScore) ||\n                    ((! readable) && (! bestIsReadable) && score > bestScore)) {\n                    bestIsReadable = readable;\n                    bestScore = score;\n                    bestColor = tinycolor(colorList[i]);\n                }\n            }\n            return bestColor;\n        };\n\n\n        // Big List of Colors\n        // ------------------\n        // <http://www.w3.org/TR/css3-color/#svg-color>\n        var names = tinycolor.names = {\n            aliceblue: \"f0f8ff\",\n            antiquewhite: \"faebd7\",\n            aqua: \"0ff\",\n            aquamarine: \"7fffd4\",\n            azure: \"f0ffff\",\n            beige: \"f5f5dc\",\n            bisque: \"ffe4c4\",\n            black: \"000\",\n            blanchedalmond: \"ffebcd\",\n            blue: \"00f\",\n            blueviolet: \"8a2be2\",\n            brown: \"a52a2a\",\n            burlywood: \"deb887\",\n            burntsienna: \"ea7e5d\",\n            cadetblue: \"5f9ea0\",\n            chartreuse: \"7fff00\",\n            chocolate: \"d2691e\",\n            coral: \"ff7f50\",\n            cornflowerblue: \"6495ed\",\n            cornsilk: \"fff8dc\",\n            crimson: \"dc143c\",\n            cyan: \"0ff\",\n            darkblue: \"00008b\",\n            darkcyan: \"008b8b\",\n            darkgoldenrod: \"b8860b\",\n            darkgray: \"a9a9a9\",\n            darkgreen: \"006400\",\n            darkgrey: \"a9a9a9\",\n            darkkhaki: \"bdb76b\",\n            darkmagenta: \"8b008b\",\n            darkolivegreen: \"556b2f\",\n            darkorange: \"ff8c00\",\n            darkorchid: \"9932cc\",\n            darkred: \"8b0000\",\n            darksalmon: \"e9967a\",\n            darkseagreen: \"8fbc8f\",\n            darkslateblue: \"483d8b\",\n            darkslategray: \"2f4f4f\",\n            darkslategrey: \"2f4f4f\",\n            darkturquoise: \"00ced1\",\n            darkviolet: \"9400d3\",\n            deeppink: \"ff1493\",\n            deepskyblue: \"00bfff\",\n            dimgray: \"696969\",\n            dimgrey: \"696969\",\n            dodgerblue: \"1e90ff\",\n            firebrick: \"b22222\",\n            floralwhite: \"fffaf0\",\n            forestgreen: \"228b22\",\n            fuchsia: \"f0f\",\n            gainsboro: \"dcdcdc\",\n            ghostwhite: \"f8f8ff\",\n            gold: \"ffd700\",\n            goldenrod: \"daa520\",\n            gray: \"808080\",\n            green: \"008000\",\n            greenyellow: \"adff2f\",\n            grey: \"808080\",\n            honeydew: \"f0fff0\",\n            hotpink: \"ff69b4\",\n            indianred: \"cd5c5c\",\n            indigo: \"4b0082\",\n            ivory: \"fffff0\",\n            khaki: \"f0e68c\",\n            lavender: \"e6e6fa\",\n            lavenderblush: \"fff0f5\",\n            lawngreen: \"7cfc00\",\n            lemonchiffon: \"fffacd\",\n            lightblue: \"add8e6\",\n            lightcoral: \"f08080\",\n            lightcyan: \"e0ffff\",\n            lightgoldenrodyellow: \"fafad2\",\n            lightgray: \"d3d3d3\",\n            lightgreen: \"90ee90\",\n            lightgrey: \"d3d3d3\",\n            lightpink: \"ffb6c1\",\n            lightsalmon: \"ffa07a\",\n            lightseagreen: \"20b2aa\",\n            lightskyblue: \"87cefa\",\n            lightslategray: \"789\",\n            lightslategrey: \"789\",\n            lightsteelblue: \"b0c4de\",\n            lightyellow: \"ffffe0\",\n            lime: \"0f0\",\n            limegreen: \"32cd32\",\n            linen: \"faf0e6\",\n            magenta: \"f0f\",\n            maroon: \"800000\",\n            mediumaquamarine: \"66cdaa\",\n            mediumblue: \"0000cd\",\n            mediumorchid: \"ba55d3\",\n            mediumpurple: \"9370db\",\n            mediumseagreen: \"3cb371\",\n            mediumslateblue: \"7b68ee\",\n            mediumspringgreen: \"00fa9a\",\n            mediumturquoise: \"48d1cc\",\n            mediumvioletred: \"c71585\",\n            midnightblue: \"191970\",\n            mintcream: \"f5fffa\",\n            mistyrose: \"ffe4e1\",\n            moccasin: \"ffe4b5\",\n            navajowhite: \"ffdead\",\n            navy: \"000080\",\n            oldlace: \"fdf5e6\",\n            olive: \"808000\",\n            olivedrab: \"6b8e23\",\n            orange: \"ffa500\",\n            orangered: \"ff4500\",\n            orchid: \"da70d6\",\n            palegoldenrod: \"eee8aa\",\n            palegreen: \"98fb98\",\n            paleturquoise: \"afeeee\",\n            palevioletred: \"db7093\",\n            papayawhip: \"ffefd5\",\n            peachpuff: \"ffdab9\",\n            peru: \"cd853f\",\n            pink: \"ffc0cb\",\n            plum: \"dda0dd\",\n            powderblue: \"b0e0e6\",\n            purple: \"800080\",\n            rebeccapurple: \"663399\",\n            red: \"f00\",\n            rosybrown: \"bc8f8f\",\n            royalblue: \"4169e1\",\n            saddlebrown: \"8b4513\",\n            salmon: \"fa8072\",\n            sandybrown: \"f4a460\",\n            seagreen: \"2e8b57\",\n            seashell: \"fff5ee\",\n            sienna: \"a0522d\",\n            silver: \"c0c0c0\",\n            skyblue: \"87ceeb\",\n            slateblue: \"6a5acd\",\n            slategray: \"708090\",\n            slategrey: \"708090\",\n            snow: \"fffafa\",\n            springgreen: \"00ff7f\",\n            steelblue: \"4682b4\",\n            tan: \"d2b48c\",\n            teal: \"008080\",\n            thistle: \"d8bfd8\",\n            tomato: \"ff6347\",\n            turquoise: \"40e0d0\",\n            violet: \"ee82ee\",\n            wheat: \"f5deb3\",\n            white: \"fff\",\n            whitesmoke: \"f5f5f5\",\n            yellow: \"ff0\",\n            yellowgreen: \"9acd32\"\n        };\n\n        // Make it easy to access colors via `hexNames[hex]`\n        var hexNames = tinycolor.hexNames = flip(names);\n\n\n        // Utilities\n        // ---------\n\n        // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n        function flip(o) {\n            var flipped = { };\n            for (var i in o) {\n                if (o.hasOwnProperty(i)) {\n                    flipped[o[i]] = i;\n                }\n            }\n            return flipped;\n        }\n\n        // Return a valid alpha value [0,1] with all invalid values being set to 1\n        function boundAlpha(a) {\n            a = parseFloat(a);\n\n            if (isNaN(a) || a < 0 || a > 1) {\n                a = 1;\n            }\n\n            return a;\n        }\n\n        // Take input from [0, n] and return it as [0, 1]\n        function bound01(n, max) {\n            if (isOnePointZero(n)) { n = \"100%\"; }\n\n            var processPercent = isPercentage(n);\n            n = mathMin(max, mathMax(0, parseFloat(n)));\n\n            // Automatically convert percentage into number\n            if (processPercent) {\n                n = parseInt(n * max, 10) / 100;\n            }\n\n            // Handle floating point rounding errors\n            if ((math.abs(n - max) < 0.000001)) {\n                return 1;\n            }\n\n            // Convert into [0, 1] range if it isn't already\n            return (n % max) / parseFloat(max);\n        }\n\n        // Force a number between 0 and 1\n        function clamp01(val) {\n            return mathMin(1, mathMax(0, val));\n        }\n\n        // Parse a base-16 hex value into a base-10 integer\n        function parseIntFromHex(val) {\n            return parseInt(val, 16);\n        }\n\n        // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n        // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n        function isOnePointZero(n) {\n            return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n        }\n\n        // Check to see if string passed in is a percentage\n        function isPercentage(n) {\n            return typeof n === \"string\" && n.indexOf('%') != -1;\n        }\n\n        // Force a hex value to have 2 characters\n        function pad2(c) {\n            return c.length == 1 ? '0' + c : '' + c;\n        }\n\n        // Replace a decimal with it's percentage value\n        function convertToPercentage(n) {\n            if (n <= 1) {\n                n = (n * 100) + \"%\";\n            }\n\n            return n;\n        }\n\n        // Converts a decimal to a hex value\n        function convertDecimalToHex(d) {\n            return Math.round(parseFloat(d) * 255).toString(16);\n        }\n        // Converts a hex value to a decimal\n        function convertHexToDecimal(h) {\n            return (parseIntFromHex(h) / 255);\n        }\n\n        var matchers = (function() {\n\n            // <http://www.w3.org/TR/css3-values/#integers>\n            var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n            // <http://www.w3.org/TR/css3-values/#number-value>\n            var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n            // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n            var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n            // Actual matching.\n            // Parentheses and commas are optional, but not required.\n            // Whitespace can take the place of commas or opening paren\n            var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n            var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n            return {\n                rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n                rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n                hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n                hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n                hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n                hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n                hex3: /^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n                hex6: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n                hex8: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n            };\n        })();\n\n        // `stringInputToObject`\n        // Permissive string parsing.  Take in a number of formats, and output an object\n        // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n        function stringInputToObject(color) {\n\n            color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n            var named = false;\n            if (names[color]) {\n                color = names[color];\n                named = true;\n            }\n            else if (color == 'transparent') {\n                return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n            }\n\n            // Try to match string input using regular expressions.\n            // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n            // Just return an object and let the conversion functions handle that.\n            // This way the result will be the same whether the tinycolor is initialized with string or object.\n            var match;\n            if ((match = matchers.rgb.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3] };\n            }\n            if ((match = matchers.rgba.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsl.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3] };\n            }\n            if ((match = matchers.hsla.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsv.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3] };\n            }\n            if ((match = matchers.hsva.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3], a: match[4] };\n            }\n            if ((match = matchers.hex8.exec(color))) {\n                return {\n                    a: convertHexToDecimal(match[1]),\n                    r: parseIntFromHex(match[2]),\n                    g: parseIntFromHex(match[3]),\n                    b: parseIntFromHex(match[4]),\n                    format: named ? \"name\" : \"hex8\"\n                };\n            }\n            if ((match = matchers.hex6.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1]),\n                    g: parseIntFromHex(match[2]),\n                    b: parseIntFromHex(match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n            if ((match = matchers.hex3.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1] + '' + match[1]),\n                    g: parseIntFromHex(match[2] + '' + match[2]),\n                    b: parseIntFromHex(match[3] + '' + match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n\n            return false;\n        }\n\n        window.tinycolor = tinycolor;\n    })();\n\n    $(function () {\n        if ($.fn.spectrum.load) {\n            $.fn.spectrum.processNativeColorInputs();\n        }\n    });\n\n});\n","jquery/fileUploader/jquery.fileupload-validate.js":"/*\n * jQuery File Upload Validation Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/jquery.fileupload-process'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'), require('jquery/fileUploader/jquery.fileupload-process'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  // Append to the default processQueue:\n  $.blueimp.fileupload.prototype.options.processQueue.push({\n    action: 'validate',\n    // Always trigger this action,\n    // even if the previous action was rejected:\n    always: true,\n    // Options taken from the global options map:\n    acceptFileTypes: '@',\n    maxFileSize: '@',\n    minFileSize: '@',\n    maxNumberOfFiles: '@',\n    disabled: '@disableValidation'\n  });\n\n  // The File Upload Validation plugin extends the fileupload widget\n  // with file validation functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      /*\n            // The regular expression for allowed file types, matches\n            // against either file type or file name:\n            acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n            // The maximum allowed file size in bytes:\n            maxFileSize: 10000000, // 10 MB\n            // The minimum allowed file size in bytes:\n            minFileSize: undefined, // No minimal file size\n            // The limit of files to be uploaded:\n            maxNumberOfFiles: 10,\n            */\n\n      // Function returning the current number of files,\n      // has to be overridden for maxNumberOfFiles validation:\n      getNumberOfFiles: $.noop,\n\n      // Error and info messages:\n      messages: {\n        maxNumberOfFiles: 'Maximum number of files exceeded',\n        acceptFileTypes: 'File type not allowed',\n        maxFileSize: 'File is too large',\n        minFileSize: 'File is too small'\n      }\n    },\n\n    processActions: {\n      validate: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        // eslint-disable-next-line new-cap\n        var dfd = $.Deferred(),\n          settings = this.options,\n          file = data.files[data.index],\n          fileSize;\n        if (options.minFileSize || options.maxFileSize) {\n          fileSize = file.size;\n        }\n        if (\n          $.type(options.maxNumberOfFiles) === 'number' &&\n          (settings.getNumberOfFiles() || 0) + data.files.length >\n            options.maxNumberOfFiles\n        ) {\n          file.error = settings.i18n('maxNumberOfFiles');\n        } else if (\n          options.acceptFileTypes &&\n          !(\n            options.acceptFileTypes.test(file.type) ||\n            options.acceptFileTypes.test(file.name)\n          )\n        ) {\n          file.error = settings.i18n('acceptFileTypes');\n        } else if (fileSize > options.maxFileSize) {\n          file.error = settings.i18n('maxFileSize');\n        } else if (\n          $.type(fileSize) === 'number' &&\n          fileSize < options.minFileSize\n        ) {\n          file.error = settings.i18n('minFileSize');\n        } else {\n          delete file.error;\n        }\n        if (file.error || data.files.error) {\n          data.files.error = true;\n          dfd.rejectWith(this, [data]);\n        } else {\n          dfd.resolveWith(this, [data]);\n        }\n        return dfd.promise();\n      }\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload.js":"/*\n * jQuery File Upload Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2010, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n/* eslint-disable new-cap */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/vendor/jquery.ui.widget'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'), require('jquery/fileUploader/vendor/jquery.ui.widget'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  // Detect file input support, based on\n  // https://viljamis.com/2012/file-upload-support-on-mobile/\n  $.support.fileInput = !(\n    new RegExp(\n      // Handle devices which give false positives for the feature detection:\n      '(Android (1\\\\.[0156]|2\\\\.[01]))' +\n        '|(Windows Phone (OS 7|8\\\\.0))|(XBLWP)|(ZuneWP)|(WPDesktop)' +\n        '|(w(eb)?OSBrowser)|(webOS)' +\n        '|(Kindle/(1\\\\.0|2\\\\.[05]|3\\\\.0))'\n    ).test(window.navigator.userAgent) ||\n    // Feature detection for all other devices:\n    $('<input type=\"file\"/>').prop('disabled')\n  );\n\n  // The FileReader API is not actually used, but works as feature detection,\n  // as some Safari versions (5?) support XHR file uploads via the FormData API,\n  // but not non-multipart XHR file uploads.\n  // window.XMLHttpRequestUpload is not available on IE10, so we check for\n  // window.ProgressEvent instead to detect XHR2 file upload capability:\n  $.support.xhrFileUpload = !!(window.ProgressEvent && window.FileReader);\n  $.support.xhrFormDataFileUpload = !!window.FormData;\n\n  // Detect support for Blob slicing (required for chunked uploads):\n  $.support.blobSlice =\n    window.Blob &&\n    (Blob.prototype.slice ||\n      Blob.prototype.webkitSlice ||\n      Blob.prototype.mozSlice);\n\n  /**\n   * Helper function to create drag handlers for dragover/dragenter/dragleave\n   *\n   * @param {string} type Event type\n   * @returns {Function} Drag handler\n   */\n  function getDragHandler(type) {\n    var isDragOver = type === 'dragover';\n    return function (e) {\n      e.dataTransfer = e.originalEvent && e.originalEvent.dataTransfer;\n      var dataTransfer = e.dataTransfer;\n      if (\n        dataTransfer &&\n        $.inArray('Files', dataTransfer.types) !== -1 &&\n        this._trigger(type, $.Event(type, { delegatedEvent: e })) !== false\n      ) {\n        e.preventDefault();\n        if (isDragOver) {\n          dataTransfer.dropEffect = 'copy';\n        }\n      }\n    };\n  }\n\n  // The fileupload widget listens for change events on file input fields defined\n  // via fileInput setting and paste or drop events of the given dropZone.\n  // In addition to the default jQuery Widget methods, the fileupload widget\n  // exposes the \"add\" and \"send\" methods, to add or directly send files using\n  // the fileupload API.\n  // By default, files added via file input selection, paste, drag & drop or\n  // \"add\" method are uploaded immediately, but it is possible to override\n  // the \"add\" callback option to queue file uploads.\n  $.widget('blueimp.fileupload', {\n    options: {\n      // The drop target element(s), by the default the complete document.\n      // Set to null to disable drag & drop support:\n      dropZone: $(document),\n      // The paste target element(s), by the default undefined.\n      // Set to a DOM node or jQuery object to enable file pasting:\n      pasteZone: undefined,\n      // The file input field(s), that are listened to for change events.\n      // If undefined, it is set to the file input fields inside\n      // of the widget element on plugin initialization.\n      // Set to null to disable the change listener.\n      fileInput: undefined,\n      // By default, the file input field is replaced with a clone after\n      // each input field change event. This is required for iframe transport\n      // queues and allows change events to be fired for the same file\n      // selection, but can be disabled by setting the following option to false:\n      replaceFileInput: true,\n      // The parameter name for the file form data (the request argument name).\n      // If undefined or empty, the name property of the file input field is\n      // used, or \"files[]\" if the file input name property is also empty,\n      // can be a string or an array of strings:\n      paramName: undefined,\n      // By default, each file of a selection is uploaded using an individual\n      // request for XHR type uploads. Set to false to upload file\n      // selections in one request each:\n      singleFileUploads: true,\n      // To limit the number of files uploaded with one XHR request,\n      // set the following option to an integer greater than 0:\n      limitMultiFileUploads: undefined,\n      // The following option limits the number of files uploaded with one\n      // XHR request to keep the request size under or equal to the defined\n      // limit in bytes:\n      limitMultiFileUploadSize: undefined,\n      // Multipart file uploads add a number of bytes to each uploaded file,\n      // therefore the following option adds an overhead for each file used\n      // in the limitMultiFileUploadSize configuration:\n      limitMultiFileUploadSizeOverhead: 512,\n      // Set the following option to true to issue all file upload requests\n      // in a sequential order:\n      sequentialUploads: false,\n      // To limit the number of concurrent uploads,\n      // set the following option to an integer greater than 0:\n      limitConcurrentUploads: undefined,\n      // Set the following option to true to force iframe transport uploads:\n      forceIframeTransport: false,\n      // Set the following option to the location of a redirect url on the\n      // origin server, for cross-domain iframe transport uploads:\n      redirect: undefined,\n      // The parameter name for the redirect url, sent as part of the form\n      // data and set to 'redirect' if this option is empty:\n      redirectParamName: undefined,\n      // Set the following option to the location of a postMessage window,\n      // to enable postMessage transport uploads:\n      postMessage: undefined,\n      // By default, XHR file uploads are sent as multipart/form-data.\n      // The iframe transport is always using multipart/form-data.\n      // Set to false to enable non-multipart XHR uploads:\n      multipart: true,\n      // To upload large files in smaller chunks, set the following option\n      // to a preferred maximum chunk size. If set to 0, null or undefined,\n      // or the browser does not support the required Blob API, files will\n      // be uploaded as a whole.\n      maxChunkSize: undefined,\n      // When a non-multipart upload or a chunked multipart upload has been\n      // aborted, this option can be used to resume the upload by setting\n      // it to the size of the already uploaded bytes. This option is most\n      // useful when modifying the options object inside of the \"add\" or\n      // \"send\" callbacks, as the options are cloned for each file upload.\n      uploadedBytes: undefined,\n      // By default, failed (abort or error) file uploads are removed from the\n      // global progress calculation. Set the following option to false to\n      // prevent recalculating the global progress data:\n      recalculateProgress: true,\n      // Interval in milliseconds to calculate and trigger progress events:\n      progressInterval: 100,\n      // Interval in milliseconds to calculate progress bitrate:\n      bitrateInterval: 500,\n      // By default, uploads are started automatically when adding files:\n      autoUpload: true,\n      // By default, duplicate file names are expected to be handled on\n      // the server-side. If this is not possible (e.g. when uploading\n      // files directly to Amazon S3), the following option can be set to\n      // an empty object or an object mapping existing filenames, e.g.:\n      // { \"image.jpg\": true, \"image (1).jpg\": true }\n      // If it is set, all files will be uploaded with unique filenames,\n      // adding increasing number suffixes if necessary, e.g.:\n      // \"image (2).jpg\"\n      uniqueFilenames: undefined,\n\n      // Error and info messages:\n      messages: {\n        uploadedBytes: 'Uploaded bytes exceed file size'\n      },\n\n      // Translation function, gets the message key to be translated\n      // and an object with context specific data as arguments:\n      i18n: function (message, context) {\n        // eslint-disable-next-line no-param-reassign\n        message = this.messages[message] || message.toString();\n        if (context) {\n          $.each(context, function (key, value) {\n            // eslint-disable-next-line no-param-reassign\n            message = message.replace('{' + key + '}', value);\n          });\n        }\n        return message;\n      },\n\n      // Additional form data to be sent along with the file uploads can be set\n      // using this option, which accepts an array of objects with name and\n      // value properties, a function returning such an array, a FormData\n      // object (for XHR file uploads), or a simple object.\n      // The form of the first fileInput is given as parameter to the function:\n      formData: function (form) {\n        return form.serializeArray();\n      },\n\n      // The add callback is invoked as soon as files are added to the fileupload\n      // widget (via file input selection, drag & drop, paste or add API call).\n      // If the singleFileUploads option is enabled, this callback will be\n      // called once for each file in the selection for XHR file uploads, else\n      // once for each file selection.\n      //\n      // The upload starts when the submit method is invoked on the data parameter.\n      // The data object contains a files property holding the added files\n      // and allows you to override plugin options as well as define ajax settings.\n      //\n      // Listeners for this callback can also be bound the following way:\n      // .on('fileuploadadd', func);\n      //\n      // data.submit() returns a Promise object and allows to attach additional\n      // handlers using jQuery's Deferred callbacks:\n      // data.submit().done(func).fail(func).always(func);\n      add: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        if (\n          data.autoUpload ||\n          (data.autoUpload !== false &&\n            $(this).fileupload('option', 'autoUpload'))\n        ) {\n          data.process().done(function () {\n            data.submit();\n          });\n        }\n      },\n\n      // Other callbacks:\n\n      // Callback for the submit event of each file upload:\n      // submit: function (e, data) {}, // .on('fileuploadsubmit', func);\n\n      // Callback for the start of each file upload request:\n      // send: function (e, data) {}, // .on('fileuploadsend', func);\n\n      // Callback for successful uploads:\n      // done: function (e, data) {}, // .on('fileuploaddone', func);\n\n      // Callback for failed (abort or error) uploads:\n      // fail: function (e, data) {}, // .on('fileuploadfail', func);\n\n      // Callback for completed (success, abort or error) requests:\n      // always: function (e, data) {}, // .on('fileuploadalways', func);\n\n      // Callback for upload progress events:\n      // progress: function (e, data) {}, // .on('fileuploadprogress', func);\n\n      // Callback for global upload progress events:\n      // progressall: function (e, data) {}, // .on('fileuploadprogressall', func);\n\n      // Callback for uploads start, equivalent to the global ajaxStart event:\n      // start: function (e) {}, // .on('fileuploadstart', func);\n\n      // Callback for uploads stop, equivalent to the global ajaxStop event:\n      // stop: function (e) {}, // .on('fileuploadstop', func);\n\n      // Callback for change events of the fileInput(s):\n      // change: function (e, data) {}, // .on('fileuploadchange', func);\n\n      // Callback for paste events to the pasteZone(s):\n      // paste: function (e, data) {}, // .on('fileuploadpaste', func);\n\n      // Callback for drop events of the dropZone(s):\n      // drop: function (e, data) {}, // .on('fileuploaddrop', func);\n\n      // Callback for dragover events of the dropZone(s):\n      // dragover: function (e) {}, // .on('fileuploaddragover', func);\n\n      // Callback before the start of each chunk upload request (before form data initialization):\n      // chunkbeforesend: function (e, data) {}, // .on('fileuploadchunkbeforesend', func);\n\n      // Callback for the start of each chunk upload request:\n      // chunksend: function (e, data) {}, // .on('fileuploadchunksend', func);\n\n      // Callback for successful chunk uploads:\n      // chunkdone: function (e, data) {}, // .on('fileuploadchunkdone', func);\n\n      // Callback for failed (abort or error) chunk uploads:\n      // chunkfail: function (e, data) {}, // .on('fileuploadchunkfail', func);\n\n      // Callback for completed (success, abort or error) chunk upload requests:\n      // chunkalways: function (e, data) {}, // .on('fileuploadchunkalways', func);\n\n      // The plugin options are used as settings object for the ajax calls.\n      // The following are jQuery ajax settings required for the file uploads:\n      processData: false,\n      contentType: false,\n      cache: false,\n      timeout: 0\n    },\n\n    // jQuery versions before 1.8 require promise.pipe if the return value is\n    // used, as promise.then in older versions has a different behavior, see:\n    // https://blog.jquery.com/2012/08/09/jquery-1-8-released/\n    // https://bugs.jquery.com/ticket/11010\n    // https://github.com/blueimp/jQuery-File-Upload/pull/3435\n    _promisePipe: (function () {\n      var parts = $.fn.jquery.split('.');\n      return Number(parts[0]) > 1 || Number(parts[1]) > 7 ? 'then' : 'pipe';\n    })(),\n\n    // A list of options that require reinitializing event listeners and/or\n    // special initialization code:\n    _specialOptions: [\n      'fileInput',\n      'dropZone',\n      'pasteZone',\n      'multipart',\n      'forceIframeTransport'\n    ],\n\n    _blobSlice:\n      $.support.blobSlice &&\n      function () {\n        var slice = this.slice || this.webkitSlice || this.mozSlice;\n        return slice.apply(this, arguments);\n      },\n\n    _BitrateTimer: function () {\n      this.timestamp = Date.now ? Date.now() : new Date().getTime();\n      this.loaded = 0;\n      this.bitrate = 0;\n      this.getBitrate = function (now, loaded, interval) {\n        var timeDiff = now - this.timestamp;\n        if (!this.bitrate || !interval || timeDiff > interval) {\n          this.bitrate = (loaded - this.loaded) * (1000 / timeDiff) * 8;\n          this.loaded = loaded;\n          this.timestamp = now;\n        }\n        return this.bitrate;\n      };\n    },\n\n    _isXHRUpload: function (options) {\n      return (\n        !options.forceIframeTransport &&\n        ((!options.multipart && $.support.xhrFileUpload) ||\n          $.support.xhrFormDataFileUpload)\n      );\n    },\n\n    _getFormData: function (options) {\n      var formData;\n      if ($.type(options.formData) === 'function') {\n        return options.formData(options.form);\n      }\n      if ($.isArray(options.formData)) {\n        return options.formData;\n      }\n      if ($.type(options.formData) === 'object') {\n        formData = [];\n        $.each(options.formData, function (name, value) {\n          formData.push({ name: name, value: value });\n        });\n        return formData;\n      }\n      return [];\n    },\n\n    _getTotal: function (files) {\n      var total = 0;\n      $.each(files, function (index, file) {\n        total += file.size || 1;\n      });\n      return total;\n    },\n\n    _initProgressObject: function (obj) {\n      var progress = {\n        loaded: 0,\n        total: 0,\n        bitrate: 0\n      };\n      if (obj._progress) {\n        $.extend(obj._progress, progress);\n      } else {\n        obj._progress = progress;\n      }\n    },\n\n    _initResponseObject: function (obj) {\n      var prop;\n      if (obj._response) {\n        for (prop in obj._response) {\n          if (Object.prototype.hasOwnProperty.call(obj._response, prop)) {\n            delete obj._response[prop];\n          }\n        }\n      } else {\n        obj._response = {};\n      }\n    },\n\n    _onProgress: function (e, data) {\n      if (e.lengthComputable) {\n        var now = Date.now ? Date.now() : new Date().getTime(),\n          loaded;\n        if (\n          data._time &&\n          data.progressInterval &&\n          now - data._time < data.progressInterval &&\n          e.loaded !== e.total\n        ) {\n          return;\n        }\n        data._time = now;\n        loaded =\n          Math.floor(\n            (e.loaded / e.total) * (data.chunkSize || data._progress.total)\n          ) + (data.uploadedBytes || 0);\n        // Add the difference from the previously loaded state\n        // to the global loaded counter:\n        this._progress.loaded += loaded - data._progress.loaded;\n        this._progress.bitrate = this._bitrateTimer.getBitrate(\n          now,\n          this._progress.loaded,\n          data.bitrateInterval\n        );\n        data._progress.loaded = data.loaded = loaded;\n        data._progress.bitrate = data.bitrate = data._bitrateTimer.getBitrate(\n          now,\n          loaded,\n          data.bitrateInterval\n        );\n        // Trigger a custom progress event with a total data property set\n        // to the file size(s) of the current upload and a loaded data\n        // property calculated accordingly:\n        this._trigger(\n          'progress',\n          $.Event('progress', { delegatedEvent: e }),\n          data\n        );\n        // Trigger a global progress event for all current file uploads,\n        // including ajax calls queued for sequential file uploads:\n        this._trigger(\n          'progressall',\n          $.Event('progressall', { delegatedEvent: e }),\n          this._progress\n        );\n      }\n    },\n\n    _initProgressListener: function (options) {\n      var that = this,\n        xhr = options.xhr ? options.xhr() : $.ajaxSettings.xhr();\n      // Accesss to the native XHR object is required to add event listeners\n      // for the upload progress event:\n      if (xhr.upload) {\n        $(xhr.upload).on('progress', function (e) {\n          var oe = e.originalEvent;\n          // Make sure the progress event properties get copied over:\n          e.lengthComputable = oe.lengthComputable;\n          e.loaded = oe.loaded;\n          e.total = oe.total;\n          that._onProgress(e, options);\n        });\n        options.xhr = function () {\n          return xhr;\n        };\n      }\n    },\n\n    _deinitProgressListener: function (options) {\n      var xhr = options.xhr ? options.xhr() : $.ajaxSettings.xhr();\n      if (xhr.upload) {\n        $(xhr.upload).off('progress');\n      }\n    },\n\n    _isInstanceOf: function (type, obj) {\n      // Cross-frame instanceof check\n      return Object.prototype.toString.call(obj) === '[object ' + type + ']';\n    },\n\n    _getUniqueFilename: function (name, map) {\n      // eslint-disable-next-line no-param-reassign\n      name = String(name);\n      if (map[name]) {\n        // eslint-disable-next-line no-param-reassign\n        name = name.replace(/(?: \\(([\\d]+)\\))?(\\.[^.]+)?$/, function (\n          _,\n          p1,\n          p2\n        ) {\n          var index = p1 ? Number(p1) + 1 : 1;\n          var ext = p2 || '';\n          return ' (' + index + ')' + ext;\n        });\n        return this._getUniqueFilename(name, map);\n      }\n      map[name] = true;\n      return name;\n    },\n\n    _initXHRData: function (options) {\n      var that = this,\n        formData,\n        file = options.files[0],\n        // Ignore non-multipart setting if not supported:\n        multipart = options.multipart || !$.support.xhrFileUpload,\n        paramName =\n          $.type(options.paramName) === 'array'\n            ? options.paramName[0]\n            : options.paramName;\n      options.headers = $.extend({}, options.headers);\n      if (options.contentRange) {\n        options.headers['Content-Range'] = options.contentRange;\n      }\n      if (!multipart || options.blob || !this._isInstanceOf('File', file)) {\n        options.headers['Content-Disposition'] =\n          'attachment; filename=\"' +\n          encodeURI(file.uploadName || file.name) +\n          '\"';\n      }\n      if (!multipart) {\n        options.contentType = file.type || 'application/octet-stream';\n        options.data = options.blob || file;\n      } else if ($.support.xhrFormDataFileUpload) {\n        if (options.postMessage) {\n          // window.postMessage does not allow sending FormData\n          // objects, so we just add the File/Blob objects to\n          // the formData array and let the postMessage window\n          // create the FormData object out of this array:\n          formData = this._getFormData(options);\n          if (options.blob) {\n            formData.push({\n              name: paramName,\n              value: options.blob\n            });\n          } else {\n            $.each(options.files, function (index, file) {\n              formData.push({\n                name:\n                  ($.type(options.paramName) === 'array' &&\n                    options.paramName[index]) ||\n                  paramName,\n                value: file\n              });\n            });\n          }\n        } else {\n          if (that._isInstanceOf('FormData', options.formData)) {\n            formData = options.formData;\n          } else {\n            formData = new FormData();\n            $.each(this._getFormData(options), function (index, field) {\n              formData.append(field.name, field.value);\n            });\n          }\n          if (options.blob) {\n            formData.append(\n              paramName,\n              options.blob,\n              file.uploadName || file.name\n            );\n          } else {\n            $.each(options.files, function (index, file) {\n              // This check allows the tests to run with\n              // dummy objects:\n              if (\n                that._isInstanceOf('File', file) ||\n                that._isInstanceOf('Blob', file)\n              ) {\n                var fileName = file.uploadName || file.name;\n                if (options.uniqueFilenames) {\n                  fileName = that._getUniqueFilename(\n                    fileName,\n                    options.uniqueFilenames\n                  );\n                }\n                formData.append(\n                  ($.type(options.paramName) === 'array' &&\n                    options.paramName[index]) ||\n                    paramName,\n                  file,\n                  fileName\n                );\n              }\n            });\n          }\n        }\n        options.data = formData;\n      }\n      // Blob reference is not needed anymore, free memory:\n      options.blob = null;\n    },\n\n    _initIframeSettings: function (options) {\n      var targetHost = $('<a></a>').prop('href', options.url).prop('host');\n      // Setting the dataType to iframe enables the iframe transport:\n      options.dataType = 'iframe ' + (options.dataType || '');\n      // The iframe transport accepts a serialized array as form data:\n      options.formData = this._getFormData(options);\n      // Add redirect url to form data on cross-domain uploads:\n      if (options.redirect && targetHost && targetHost !== location.host) {\n        options.formData.push({\n          name: options.redirectParamName || 'redirect',\n          value: options.redirect\n        });\n      }\n    },\n\n    _initDataSettings: function (options) {\n      if (this._isXHRUpload(options)) {\n        if (!this._chunkedUpload(options, true)) {\n          if (!options.data) {\n            this._initXHRData(options);\n          }\n          this._initProgressListener(options);\n        }\n        if (options.postMessage) {\n          // Setting the dataType to postmessage enables the\n          // postMessage transport:\n          options.dataType = 'postmessage ' + (options.dataType || '');\n        }\n      } else {\n        this._initIframeSettings(options);\n      }\n    },\n\n    _getParamName: function (options) {\n      var fileInput = $(options.fileInput),\n        paramName = options.paramName;\n      if (!paramName) {\n        paramName = [];\n        fileInput.each(function () {\n          var input = $(this),\n            name = input.prop('name') || 'files[]',\n            i = (input.prop('files') || [1]).length;\n          while (i) {\n            paramName.push(name);\n            i -= 1;\n          }\n        });\n        if (!paramName.length) {\n          paramName = [fileInput.prop('name') || 'files[]'];\n        }\n      } else if (!$.isArray(paramName)) {\n        paramName = [paramName];\n      }\n      return paramName;\n    },\n\n    _initFormSettings: function (options) {\n      // Retrieve missing options from the input field and the\n      // associated form, if available:\n      if (!options.form || !options.form.length) {\n        options.form = $(options.fileInput.prop('form'));\n        // If the given file input doesn't have an associated form,\n        // use the default widget file input's form:\n        if (!options.form.length) {\n          options.form = $(this.options.fileInput.prop('form'));\n        }\n      }\n      options.paramName = this._getParamName(options);\n      if (!options.url) {\n        options.url = options.form.prop('action') || location.href;\n      }\n      // The HTTP request method must be \"POST\" or \"PUT\":\n      options.type = (\n        options.type ||\n        ($.type(options.form.prop('method')) === 'string' &&\n          options.form.prop('method')) ||\n        ''\n      ).toUpperCase();\n      if (\n        options.type !== 'POST' &&\n        options.type !== 'PUT' &&\n        options.type !== 'PATCH'\n      ) {\n        options.type = 'POST';\n      }\n      if (!options.formAcceptCharset) {\n        options.formAcceptCharset = options.form.attr('accept-charset');\n      }\n    },\n\n    _getAJAXSettings: function (data) {\n      var options = $.extend({}, this.options, data);\n      this._initFormSettings(options);\n      this._initDataSettings(options);\n      return options;\n    },\n\n    // jQuery 1.6 doesn't provide .state(),\n    // while jQuery 1.8+ removed .isRejected() and .isResolved():\n    _getDeferredState: function (deferred) {\n      if (deferred.state) {\n        return deferred.state();\n      }\n      if (deferred.isResolved()) {\n        return 'resolved';\n      }\n      if (deferred.isRejected()) {\n        return 'rejected';\n      }\n      return 'pending';\n    },\n\n    // Maps jqXHR callbacks to the equivalent\n    // methods of the given Promise object:\n    _enhancePromise: function (promise) {\n      promise.success = promise.done;\n      promise.error = promise.fail;\n      promise.complete = promise.always;\n      return promise;\n    },\n\n    // Creates and returns a Promise object enhanced with\n    // the jqXHR methods abort, success, error and complete:\n    _getXHRPromise: function (resolveOrReject, context, args) {\n      var dfd = $.Deferred(),\n        promise = dfd.promise();\n      // eslint-disable-next-line no-param-reassign\n      context = context || this.options.context || promise;\n      if (resolveOrReject === true) {\n        dfd.resolveWith(context, args);\n      } else if (resolveOrReject === false) {\n        dfd.rejectWith(context, args);\n      }\n      promise.abort = dfd.promise;\n      return this._enhancePromise(promise);\n    },\n\n    // Adds convenience methods to the data callback argument:\n    _addConvenienceMethods: function (e, data) {\n      var that = this,\n        getPromise = function (args) {\n          return $.Deferred().resolveWith(that, args).promise();\n        };\n      data.process = function (resolveFunc, rejectFunc) {\n        if (resolveFunc || rejectFunc) {\n          data._processQueue = this._processQueue = (this._processQueue ||\n            getPromise([this]))\n            [that._promisePipe](function () {\n              if (data.errorThrown) {\n                return $.Deferred().rejectWith(that, [data]).promise();\n              }\n              return getPromise(arguments);\n            })\n            [that._promisePipe](resolveFunc, rejectFunc);\n        }\n        return this._processQueue || getPromise([this]);\n      };\n      data.submit = function () {\n        if (this.state() !== 'pending') {\n          data.jqXHR = this.jqXHR =\n            that._trigger(\n              'submit',\n              $.Event('submit', { delegatedEvent: e }),\n              this\n            ) !== false && that._onSend(e, this);\n        }\n        return this.jqXHR || that._getXHRPromise();\n      };\n      data.abort = function () {\n        if (this.jqXHR) {\n          return this.jqXHR.abort();\n        }\n        this.errorThrown = 'abort';\n        that._trigger('fail', null, this);\n        return that._getXHRPromise(false);\n      };\n      data.state = function () {\n        if (this.jqXHR) {\n          return that._getDeferredState(this.jqXHR);\n        }\n        if (this._processQueue) {\n          return that._getDeferredState(this._processQueue);\n        }\n      };\n      data.processing = function () {\n        return (\n          !this.jqXHR &&\n          this._processQueue &&\n          that._getDeferredState(this._processQueue) === 'pending'\n        );\n      };\n      data.progress = function () {\n        return this._progress;\n      };\n      data.response = function () {\n        return this._response;\n      };\n    },\n\n    // Parses the Range header from the server response\n    // and returns the uploaded bytes:\n    _getUploadedBytes: function (jqXHR) {\n      var range = jqXHR.getResponseHeader('Range'),\n        parts = range && range.split('-'),\n        upperBytesPos = parts && parts.length > 1 && parseInt(parts[1], 10);\n      return upperBytesPos && upperBytesPos + 1;\n    },\n\n    // Uploads a file in multiple, sequential requests\n    // by splitting the file up in multiple blob chunks.\n    // If the second parameter is true, only tests if the file\n    // should be uploaded in chunks, but does not invoke any\n    // upload requests:\n    _chunkedUpload: function (options, testOnly) {\n      options.uploadedBytes = options.uploadedBytes || 0;\n      var that = this,\n        file = options.files[0],\n        fs = file.size,\n        ub = options.uploadedBytes,\n        mcs = options.maxChunkSize || fs,\n        slice = this._blobSlice,\n        dfd = $.Deferred(),\n        promise = dfd.promise(),\n        jqXHR,\n        upload;\n      if (\n        !(\n          this._isXHRUpload(options) &&\n          slice &&\n          (ub || ($.type(mcs) === 'function' ? mcs(options) : mcs) < fs)\n        ) ||\n        options.data\n      ) {\n        return false;\n      }\n      if (testOnly) {\n        return true;\n      }\n      if (ub >= fs) {\n        file.error = options.i18n('uploadedBytes');\n        return this._getXHRPromise(false, options.context, [\n          null,\n          'error',\n          file.error\n        ]);\n      }\n      // The chunk upload method:\n      upload = function () {\n        // Clone the options object for each chunk upload:\n        var o = $.extend({}, options),\n          currentLoaded = o._progress.loaded;\n        o.blob = slice.call(\n          file,\n          ub,\n          ub + ($.type(mcs) === 'function' ? mcs(o) : mcs),\n          file.type\n        );\n        // Store the current chunk size, as the blob itself\n        // will be dereferenced after data processing:\n        o.chunkSize = o.blob.size;\n        // Expose the chunk bytes position range:\n        o.contentRange =\n          'bytes ' + ub + '-' + (ub + o.chunkSize - 1) + '/' + fs;\n        // Trigger chunkbeforesend to allow form data to be updated for this chunk\n        that._trigger('chunkbeforesend', null, o);\n        // Process the upload data (the blob and potential form data):\n        that._initXHRData(o);\n        // Add progress listeners for this chunk upload:\n        that._initProgressListener(o);\n        jqXHR = (\n          (that._trigger('chunksend', null, o) !== false && $.ajax(o)) ||\n          that._getXHRPromise(false, o.context)\n        )\n          .done(function (result, textStatus, jqXHR) {\n            ub = that._getUploadedBytes(jqXHR) || ub + o.chunkSize;\n            // Create a progress event if no final progress event\n            // with loaded equaling total has been triggered\n            // for this chunk:\n            if (currentLoaded + o.chunkSize - o._progress.loaded) {\n              that._onProgress(\n                $.Event('progress', {\n                  lengthComputable: true,\n                  loaded: ub - o.uploadedBytes,\n                  total: ub - o.uploadedBytes\n                }),\n                o\n              );\n            }\n            options.uploadedBytes = o.uploadedBytes = ub;\n            o.result = result;\n            o.textStatus = textStatus;\n            o.jqXHR = jqXHR;\n            that._trigger('chunkdone', null, o);\n            that._trigger('chunkalways', null, o);\n            if (ub < fs) {\n              // File upload not yet complete,\n              // continue with the next chunk:\n              upload();\n            } else {\n              dfd.resolveWith(o.context, [result, textStatus, jqXHR]);\n            }\n          })\n          .fail(function (jqXHR, textStatus, errorThrown) {\n            o.jqXHR = jqXHR;\n            o.textStatus = textStatus;\n            o.errorThrown = errorThrown;\n            that._trigger('chunkfail', null, o);\n            that._trigger('chunkalways', null, o);\n            dfd.rejectWith(o.context, [jqXHR, textStatus, errorThrown]);\n          })\n          .always(function () {\n            that._deinitProgressListener(o);\n          });\n      };\n      this._enhancePromise(promise);\n      promise.abort = function () {\n        return jqXHR.abort();\n      };\n      upload();\n      return promise;\n    },\n\n    _beforeSend: function (e, data) {\n      if (this._active === 0) {\n        // the start callback is triggered when an upload starts\n        // and no other uploads are currently running,\n        // equivalent to the global ajaxStart event:\n        this._trigger('start');\n        // Set timer for global bitrate progress calculation:\n        this._bitrateTimer = new this._BitrateTimer();\n        // Reset the global progress values:\n        this._progress.loaded = this._progress.total = 0;\n        this._progress.bitrate = 0;\n      }\n      // Make sure the container objects for the .response() and\n      // .progress() methods on the data object are available\n      // and reset to their initial state:\n      this._initResponseObject(data);\n      this._initProgressObject(data);\n      data._progress.loaded = data.loaded = data.uploadedBytes || 0;\n      data._progress.total = data.total = this._getTotal(data.files) || 1;\n      data._progress.bitrate = data.bitrate = 0;\n      this._active += 1;\n      // Initialize the global progress values:\n      this._progress.loaded += data.loaded;\n      this._progress.total += data.total;\n    },\n\n    _onDone: function (result, textStatus, jqXHR, options) {\n      var total = options._progress.total,\n        response = options._response;\n      if (options._progress.loaded < total) {\n        // Create a progress event if no final progress event\n        // with loaded equaling total has been triggered:\n        this._onProgress(\n          $.Event('progress', {\n            lengthComputable: true,\n            loaded: total,\n            total: total\n          }),\n          options\n        );\n      }\n      response.result = options.result = result;\n      response.textStatus = options.textStatus = textStatus;\n      response.jqXHR = options.jqXHR = jqXHR;\n      this._trigger('done', null, options);\n    },\n\n    _onFail: function (jqXHR, textStatus, errorThrown, options) {\n      var response = options._response;\n      if (options.recalculateProgress) {\n        // Remove the failed (error or abort) file upload from\n        // the global progress calculation:\n        this._progress.loaded -= options._progress.loaded;\n        this._progress.total -= options._progress.total;\n      }\n      response.jqXHR = options.jqXHR = jqXHR;\n      response.textStatus = options.textStatus = textStatus;\n      response.errorThrown = options.errorThrown = errorThrown;\n      this._trigger('fail', null, options);\n    },\n\n    _onAlways: function (jqXHRorResult, textStatus, jqXHRorError, options) {\n      // jqXHRorResult, textStatus and jqXHRorError are added to the\n      // options object via done and fail callbacks\n      this._trigger('always', null, options);\n    },\n\n    _onSend: function (e, data) {\n      if (!data.submit) {\n        this._addConvenienceMethods(e, data);\n      }\n      var that = this,\n        jqXHR,\n        aborted,\n        slot,\n        pipe,\n        options = that._getAJAXSettings(data),\n        send = function () {\n          that._sending += 1;\n          // Set timer for bitrate progress calculation:\n          options._bitrateTimer = new that._BitrateTimer();\n          jqXHR =\n            jqXHR ||\n            (\n              ((aborted ||\n                that._trigger(\n                  'send',\n                  $.Event('send', { delegatedEvent: e }),\n                  options\n                ) === false) &&\n                that._getXHRPromise(false, options.context, aborted)) ||\n              that._chunkedUpload(options) ||\n              $.ajax(options)\n            )\n              .done(function (result, textStatus, jqXHR) {\n                that._onDone(result, textStatus, jqXHR, options);\n              })\n              .fail(function (jqXHR, textStatus, errorThrown) {\n                that._onFail(jqXHR, textStatus, errorThrown, options);\n              })\n              .always(function (jqXHRorResult, textStatus, jqXHRorError) {\n                that._deinitProgressListener(options);\n                that._onAlways(\n                  jqXHRorResult,\n                  textStatus,\n                  jqXHRorError,\n                  options\n                );\n                that._sending -= 1;\n                that._active -= 1;\n                if (\n                  options.limitConcurrentUploads &&\n                  options.limitConcurrentUploads > that._sending\n                ) {\n                  // Start the next queued upload,\n                  // that has not been aborted:\n                  var nextSlot = that._slots.shift();\n                  while (nextSlot) {\n                    if (that._getDeferredState(nextSlot) === 'pending') {\n                      nextSlot.resolve();\n                      break;\n                    }\n                    nextSlot = that._slots.shift();\n                  }\n                }\n                if (that._active === 0) {\n                  // The stop callback is triggered when all uploads have\n                  // been completed, equivalent to the global ajaxStop event:\n                  that._trigger('stop');\n                }\n              });\n          return jqXHR;\n        };\n      this._beforeSend(e, options);\n      if (\n        this.options.sequentialUploads ||\n        (this.options.limitConcurrentUploads &&\n          this.options.limitConcurrentUploads <= this._sending)\n      ) {\n        if (this.options.limitConcurrentUploads > 1) {\n          slot = $.Deferred();\n          this._slots.push(slot);\n          pipe = slot[that._promisePipe](send);\n        } else {\n          this._sequence = this._sequence[that._promisePipe](send, send);\n          pipe = this._sequence;\n        }\n        // Return the piped Promise object, enhanced with an abort method,\n        // which is delegated to the jqXHR object of the current upload,\n        // and jqXHR callbacks mapped to the equivalent Promise methods:\n        pipe.abort = function () {\n          aborted = [undefined, 'abort', 'abort'];\n          if (!jqXHR) {\n            if (slot) {\n              slot.rejectWith(options.context, aborted);\n            }\n            return send();\n          }\n          return jqXHR.abort();\n        };\n        return this._enhancePromise(pipe);\n      }\n      return send();\n    },\n\n    _onAdd: function (e, data) {\n      var that = this,\n        result = true,\n        options = $.extend({}, this.options, data),\n        files = data.files,\n        filesLength = files.length,\n        limit = options.limitMultiFileUploads,\n        limitSize = options.limitMultiFileUploadSize,\n        overhead = options.limitMultiFileUploadSizeOverhead,\n        batchSize = 0,\n        paramName = this._getParamName(options),\n        paramNameSet,\n        paramNameSlice,\n        fileSet,\n        i,\n        j = 0;\n      if (!filesLength) {\n        return false;\n      }\n      if (limitSize && files[0].size === undefined) {\n        limitSize = undefined;\n      }\n      if (\n        !(options.singleFileUploads || limit || limitSize) ||\n        !this._isXHRUpload(options)\n      ) {\n        fileSet = [files];\n        paramNameSet = [paramName];\n      } else if (!(options.singleFileUploads || limitSize) && limit) {\n        fileSet = [];\n        paramNameSet = [];\n        for (i = 0; i < filesLength; i += limit) {\n          fileSet.push(files.slice(i, i + limit));\n          paramNameSlice = paramName.slice(i, i + limit);\n          if (!paramNameSlice.length) {\n            paramNameSlice = paramName;\n          }\n          paramNameSet.push(paramNameSlice);\n        }\n      } else if (!options.singleFileUploads && limitSize) {\n        fileSet = [];\n        paramNameSet = [];\n        for (i = 0; i < filesLength; i = i + 1) {\n          batchSize += files[i].size + overhead;\n          if (\n            i + 1 === filesLength ||\n            batchSize + files[i + 1].size + overhead > limitSize ||\n            (limit && i + 1 - j >= limit)\n          ) {\n            fileSet.push(files.slice(j, i + 1));\n            paramNameSlice = paramName.slice(j, i + 1);\n            if (!paramNameSlice.length) {\n              paramNameSlice = paramName;\n            }\n            paramNameSet.push(paramNameSlice);\n            j = i + 1;\n            batchSize = 0;\n          }\n        }\n      } else {\n        paramNameSet = paramName;\n      }\n      data.originalFiles = files;\n      $.each(fileSet || files, function (index, element) {\n        var newData = $.extend({}, data);\n        newData.files = fileSet ? element : [element];\n        newData.paramName = paramNameSet[index];\n        that._initResponseObject(newData);\n        that._initProgressObject(newData);\n        that._addConvenienceMethods(e, newData);\n        result = that._trigger(\n          'add',\n          $.Event('add', { delegatedEvent: e }),\n          newData\n        );\n        return result;\n      });\n      return result;\n    },\n\n    _replaceFileInput: function (data) {\n      var input = data.fileInput,\n        inputClone = input.clone(true),\n        restoreFocus = input.is(document.activeElement);\n      // Add a reference for the new cloned file input to the data argument:\n      data.fileInputClone = inputClone;\n      $('<form></form>').append(inputClone)[0].reset();\n      // Detaching allows to insert the fileInput on another form\n      // without loosing the file input value:\n      input.after(inputClone).detach();\n      // If the fileInput had focus before it was detached,\n      // restore focus to the inputClone.\n      if (restoreFocus) {\n        inputClone.trigger('focus');\n      }\n      // Avoid memory leaks with the detached file input:\n      $.cleanData(input.off('remove'));\n      // Replace the original file input element in the fileInput\n      // elements set with the clone, which has been copied including\n      // event handlers:\n      this.options.fileInput = this.options.fileInput.map(function (i, el) {\n        if (el === input[0]) {\n          return inputClone[0];\n        }\n        return el;\n      });\n      // If the widget has been initialized on the file input itself,\n      // override this.element with the file input clone:\n      if (input[0] === this.element[0]) {\n        this.element = inputClone;\n      }\n    },\n\n    _handleFileTreeEntry: function (entry, path) {\n      var that = this,\n        dfd = $.Deferred(),\n        entries = [],\n        dirReader,\n        errorHandler = function (e) {\n          if (e && !e.entry) {\n            e.entry = entry;\n          }\n          // Since $.when returns immediately if one\n          // Deferred is rejected, we use resolve instead.\n          // This allows valid files and invalid items\n          // to be returned together in one set:\n          dfd.resolve([e]);\n        },\n        successHandler = function (entries) {\n          that\n            ._handleFileTreeEntries(entries, path + entry.name + '/')\n            .done(function (files) {\n              dfd.resolve(files);\n            })\n            .fail(errorHandler);\n        },\n        readEntries = function () {\n          dirReader.readEntries(function (results) {\n            if (!results.length) {\n              successHandler(entries);\n            } else {\n              entries = entries.concat(results);\n              readEntries();\n            }\n          }, errorHandler);\n        };\n      // eslint-disable-next-line no-param-reassign\n      path = path || '';\n      if (entry.isFile) {\n        if (entry._file) {\n          // Workaround for Chrome bug #149735\n          entry._file.relativePath = path;\n          dfd.resolve(entry._file);\n        } else {\n          entry.file(function (file) {\n            file.relativePath = path;\n            dfd.resolve(file);\n          }, errorHandler);\n        }\n      } else if (entry.isDirectory) {\n        dirReader = entry.createReader();\n        readEntries();\n      } else {\n        // Return an empty list for file system items\n        // other than files or directories:\n        dfd.resolve([]);\n      }\n      return dfd.promise();\n    },\n\n    _handleFileTreeEntries: function (entries, path) {\n      var that = this;\n      return $.when\n        .apply(\n          $,\n          $.map(entries, function (entry) {\n            return that._handleFileTreeEntry(entry, path);\n          })\n        )\n        [this._promisePipe](function () {\n          return Array.prototype.concat.apply([], arguments);\n        });\n    },\n\n    _getDroppedFiles: function (dataTransfer) {\n      // eslint-disable-next-line no-param-reassign\n      dataTransfer = dataTransfer || {};\n      var items = dataTransfer.items;\n      if (\n        items &&\n        items.length &&\n        (items[0].webkitGetAsEntry || items[0].getAsEntry)\n      ) {\n        return this._handleFileTreeEntries(\n          $.map(items, function (item) {\n            var entry;\n            if (item.webkitGetAsEntry) {\n              entry = item.webkitGetAsEntry();\n              if (entry) {\n                // Workaround for Chrome bug #149735:\n                entry._file = item.getAsFile();\n              }\n              return entry;\n            }\n            return item.getAsEntry();\n          })\n        );\n      }\n      return $.Deferred().resolve($.makeArray(dataTransfer.files)).promise();\n    },\n\n    _getSingleFileInputFiles: function (fileInput) {\n      // eslint-disable-next-line no-param-reassign\n      fileInput = $(fileInput);\n      var entries =\n          fileInput.prop('webkitEntries') || fileInput.prop('entries'),\n        files,\n        value;\n      if (entries && entries.length) {\n        return this._handleFileTreeEntries(entries);\n      }\n      files = $.makeArray(fileInput.prop('files'));\n      if (!files.length) {\n        value = fileInput.prop('value');\n        if (!value) {\n          return $.Deferred().resolve([]).promise();\n        }\n        // If the files property is not available, the browser does not\n        // support the File API and we add a pseudo File object with\n        // the input value as name with path information removed:\n        files = [{ name: value.replace(/^.*\\\\/, '') }];\n      } else if (files[0].name === undefined && files[0].fileName) {\n        // File normalization for Safari 4 and Firefox 3:\n        $.each(files, function (index, file) {\n          file.name = file.fileName;\n          file.size = file.fileSize;\n        });\n      }\n      return $.Deferred().resolve(files).promise();\n    },\n\n    _getFileInputFiles: function (fileInput) {\n      if (!(fileInput instanceof $) || fileInput.length === 1) {\n        return this._getSingleFileInputFiles(fileInput);\n      }\n      return $.when\n        .apply($, $.map(fileInput, this._getSingleFileInputFiles))\n        [this._promisePipe](function () {\n          return Array.prototype.concat.apply([], arguments);\n        });\n    },\n\n    _onChange: function (e) {\n      var that = this,\n        data = {\n          fileInput: $(e.target),\n          form: $(e.target.form)\n        };\n      this._getFileInputFiles(data.fileInput).always(function (files) {\n        data.files = files;\n        if (that.options.replaceFileInput) {\n          that._replaceFileInput(data);\n        }\n        if (\n          that._trigger(\n            'change',\n            $.Event('change', { delegatedEvent: e }),\n            data\n          ) !== false\n        ) {\n          that._onAdd(e, data);\n        }\n      });\n    },\n\n    _onPaste: function (e) {\n      var items =\n          e.originalEvent &&\n          e.originalEvent.clipboardData &&\n          e.originalEvent.clipboardData.items,\n        data = { files: [] };\n      if (items && items.length) {\n        $.each(items, function (index, item) {\n          var file = item.getAsFile && item.getAsFile();\n          if (file) {\n            data.files.push(file);\n          }\n        });\n        if (\n          this._trigger(\n            'paste',\n            $.Event('paste', { delegatedEvent: e }),\n            data\n          ) !== false\n        ) {\n          this._onAdd(e, data);\n        }\n      }\n    },\n\n    _onDrop: function (e) {\n      e.dataTransfer = e.originalEvent && e.originalEvent.dataTransfer;\n      var that = this,\n        dataTransfer = e.dataTransfer,\n        data = {};\n      if (dataTransfer && dataTransfer.files && dataTransfer.files.length) {\n        e.preventDefault();\n        this._getDroppedFiles(dataTransfer).always(function (files) {\n          data.files = files;\n          if (\n            that._trigger(\n              'drop',\n              $.Event('drop', { delegatedEvent: e }),\n              data\n            ) !== false\n          ) {\n            that._onAdd(e, data);\n          }\n        });\n      }\n    },\n\n    _onDragOver: getDragHandler('dragover'),\n\n    _onDragEnter: getDragHandler('dragenter'),\n\n    _onDragLeave: getDragHandler('dragleave'),\n\n    _initEventHandlers: function () {\n      if (this._isXHRUpload(this.options)) {\n        this._on(this.options.dropZone, {\n          dragover: this._onDragOver,\n          drop: this._onDrop,\n          // event.preventDefault() on dragenter is required for IE10+:\n          dragenter: this._onDragEnter,\n          // dragleave is not required, but added for completeness:\n          dragleave: this._onDragLeave\n        });\n        this._on(this.options.pasteZone, {\n          paste: this._onPaste\n        });\n      }\n      if ($.support.fileInput) {\n        this._on(this.options.fileInput, {\n          change: this._onChange\n        });\n      }\n    },\n\n    _destroyEventHandlers: function () {\n      this._off(this.options.dropZone, 'dragenter dragleave dragover drop');\n      this._off(this.options.pasteZone, 'paste');\n      this._off(this.options.fileInput, 'change');\n    },\n\n    _destroy: function () {\n      this._destroyEventHandlers();\n    },\n\n    _setOption: function (key, value) {\n      var reinit = $.inArray(key, this._specialOptions) !== -1;\n      if (reinit) {\n        this._destroyEventHandlers();\n      }\n      this._super(key, value);\n      if (reinit) {\n        this._initSpecialOptions();\n        this._initEventHandlers();\n      }\n    },\n\n    _initSpecialOptions: function () {\n      var options = this.options;\n      if (options.fileInput === undefined) {\n        options.fileInput = this.element.is('input[type=\"file\"]')\n          ? this.element\n          : this.element.find('input[type=\"file\"]');\n      } else if (!(options.fileInput instanceof $)) {\n        options.fileInput = $(options.fileInput);\n      }\n      if (!(options.dropZone instanceof $)) {\n        options.dropZone = $(options.dropZone);\n      }\n      if (!(options.pasteZone instanceof $)) {\n        options.pasteZone = $(options.pasteZone);\n      }\n    },\n\n    _getRegExp: function (str) {\n      var parts = str.split('/'),\n        modifiers = parts.pop();\n      parts.shift();\n      return new RegExp(parts.join('/'), modifiers);\n    },\n\n    _isRegExpOption: function (key, value) {\n      return (\n        key !== 'url' &&\n        $.type(value) === 'string' &&\n        /^\\/.*\\/[igm]{0,3}$/.test(value)\n      );\n    },\n\n    _initDataAttributes: function () {\n      var that = this,\n        options = this.options,\n        data = this.element.data();\n      // Initialize options set via HTML5 data-attributes:\n      $.each(this.element[0].attributes, function (index, attr) {\n        var key = attr.name.toLowerCase(),\n          value;\n        if (/^data-/.test(key)) {\n          // Convert hyphen-ated key to camelCase:\n          key = key.slice(5).replace(/-[a-z]/g, function (str) {\n            return str.charAt(1).toUpperCase();\n          });\n          value = data[key];\n          if (that._isRegExpOption(key, value)) {\n            value = that._getRegExp(value);\n          }\n          options[key] = value;\n        }\n      });\n    },\n\n    _create: function () {\n      this._initDataAttributes();\n      this._initSpecialOptions();\n      this._slots = [];\n      this._sequence = this._getXHRPromise(true);\n      this._sending = this._active = 0;\n      this._initProgressObject(this);\n      this._initEventHandlers();\n    },\n\n    // This method is exposed to the widget API and allows to query\n    // the number of active uploads:\n    active: function () {\n      return this._active;\n    },\n\n    // This method is exposed to the widget API and allows to query\n    // the widget upload progress.\n    // It returns an object with loaded, total and bitrate properties\n    // for the running uploads:\n    progress: function () {\n      return this._progress;\n    },\n\n    // This method is exposed to the widget API and allows adding files\n    // using the fileupload API. The data parameter accepts an object which\n    // must have a files property and can contain additional options:\n    // .fileupload('add', {files: filesList});\n    add: function (data) {\n      var that = this;\n      if (!data || this.options.disabled) {\n        return;\n      }\n      if (data.fileInput && !data.files) {\n        this._getFileInputFiles(data.fileInput).always(function (files) {\n          data.files = files;\n          that._onAdd(null, data);\n        });\n      } else {\n        data.files = $.makeArray(data.files);\n        this._onAdd(null, data);\n      }\n    },\n\n    // This method is exposed to the widget API and allows sending files\n    // using the fileupload API. The data parameter accepts an object which\n    // must have a files or fileInput property and can contain additional options:\n    // .fileupload('send', {files: filesList});\n    // The method returns a Promise object for the file upload call.\n    send: function (data) {\n      if (data && !this.options.disabled) {\n        if (data.fileInput && !data.files) {\n          var that = this,\n            dfd = $.Deferred(),\n            promise = dfd.promise(),\n            jqXHR,\n            aborted;\n          promise.abort = function () {\n            aborted = true;\n            if (jqXHR) {\n              return jqXHR.abort();\n            }\n            dfd.reject(null, 'abort', 'abort');\n            return promise;\n          };\n          this._getFileInputFiles(data.fileInput).always(function (files) {\n            if (aborted) {\n              return;\n            }\n            if (!files.length) {\n              dfd.reject();\n              return;\n            }\n            data.files = files;\n            jqXHR = that._onSend(null, data);\n            jqXHR.then(\n              function (result, textStatus, jqXHR) {\n                dfd.resolve(result, textStatus, jqXHR);\n              },\n              function (jqXHR, textStatus, errorThrown) {\n                dfd.reject(jqXHR, textStatus, errorThrown);\n              }\n            );\n          });\n          return this._enhancePromise(promise);\n        }\n        data.files = $.makeArray(data.files);\n        if (data.files.length) {\n          return this._onSend(null, data);\n        }\n      }\n      return this._getXHRPromise(false, data && data.context);\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload-ui.js":"/*\n * jQuery File Upload User Interface Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2010, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define([\n      'jquery',\n      'jquery/fileUploader/vendor/blueimp-tmpl/js/tmpl',\n      'jquery/fileUploader/jquery.fileupload-image',\n      'jquery/fileUploader/jquery.fileupload-audio',\n      'jquery/fileUploader/jquery.fileupload-video',\n      'jquery/fileUploader/jquery.fileupload-validate'\n    ], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/vendor/blueimp-tmpl/js/tmpl'),\n      require('jquery/fileUploader/jquery.fileupload-image'),\n      require('jquery/fileUploader/jquery.fileupload-audio'),\n      require('jquery/fileUploader/jquery.fileupload-video'),\n      require('jquery/fileUploader/jquery.fileupload-validate')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery, window.tmpl);\n  }\n})(function ($, tmpl) {\n  'use strict';\n\n  $.blueimp.fileupload.prototype._specialOptions.push(\n    'filesContainer',\n    'uploadTemplateId',\n    'downloadTemplateId'\n  );\n\n  // The UI version extends the file upload widget\n  // and adds complete user interface interaction:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // By default, files added to the widget are uploaded as soon\n      // as the user clicks on the start buttons. To enable automatic\n      // uploads, set the following option to true:\n      autoUpload: false,\n      // The class to show/hide UI elements:\n      showElementClass: 'in',\n      // The ID of the upload template:\n      uploadTemplateId: 'template-upload',\n      // The ID of the download template:\n      downloadTemplateId: 'template-download',\n      // The container for the list of files. If undefined, it is set to\n      // an element with class \"files\" inside of the widget element:\n      filesContainer: undefined,\n      // By default, files are appended to the files container.\n      // Set the following option to true, to prepend files instead:\n      prependFiles: false,\n      // The expected data type of the upload response, sets the dataType\n      // option of the $.ajax upload requests:\n      dataType: 'json',\n\n      // Error and info messages:\n      messages: {\n        unknownError: 'Unknown error'\n      },\n\n      // Function returning the current number of files,\n      // used by the maxNumberOfFiles validation:\n      getNumberOfFiles: function () {\n        return this.filesContainer.children().not('.processing').length;\n      },\n\n      // Callback to retrieve the list of files from the server response:\n      getFilesFromResponse: function (data) {\n        if (data.result && $.isArray(data.result.files)) {\n          return data.result.files;\n        }\n        return [];\n      },\n\n      // The add callback is invoked as soon as files are added to the fileupload\n      // widget (via file input selection, drag & drop or add API call).\n      // See the basic file upload widget for more information:\n      add: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var $this = $(this),\n          that = $this.data('blueimp-fileupload') || $this.data('fileupload'),\n          options = that.options;\n        data.context = that\n          ._renderUpload(data.files)\n          .data('data', data)\n          .addClass('processing');\n        options.filesContainer[options.prependFiles ? 'prepend' : 'append'](\n          data.context\n        );\n        that._forceReflow(data.context);\n        that._transition(data.context);\n        data\n          .process(function () {\n            return $this.fileupload('process', data);\n          })\n          .always(function () {\n            data.context\n              .each(function (index) {\n                $(this)\n                  .find('.size')\n                  .text(that._formatFileSize(data.files[index].size));\n              })\n              .removeClass('processing');\n            that._renderPreviews(data);\n          })\n          .done(function () {\n            data.context.find('.edit,.start').prop('disabled', false);\n            if (\n              that._trigger('added', e, data) !== false &&\n              (options.autoUpload || data.autoUpload) &&\n              data.autoUpload !== false\n            ) {\n              data.submit();\n            }\n          })\n          .fail(function () {\n            if (data.files.error) {\n              data.context.each(function (index) {\n                var error = data.files[index].error;\n                if (error) {\n                  $(this).find('.error').text(error);\n                }\n              });\n            }\n          });\n      },\n      // Callback for the start of each file upload request:\n      send: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n          $(this).data('blueimp-fileupload') || $(this).data('fileupload');\n        if (\n          data.context &&\n          data.dataType &&\n          data.dataType.substr(0, 6) === 'iframe'\n        ) {\n          // Iframe Transport does not support progress events.\n          // In lack of an indeterminate progress bar, we set\n          // the progress to 100%, showing the full animated bar:\n          data.context\n            .find('.progress')\n            .addClass(!$.support.transition && 'progress-animated')\n            .attr('aria-valuenow', 100)\n            .children()\n            .first()\n            .css('width', '100%');\n        }\n        return that._trigger('sent', e, data);\n      },\n      // Callback for successful uploads:\n      done: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n            $(this).data('blueimp-fileupload') || $(this).data('fileupload'),\n          getFilesFromResponse =\n            data.getFilesFromResponse || that.options.getFilesFromResponse,\n          files = getFilesFromResponse(data),\n          template,\n          deferred;\n        if (data.context) {\n          data.context.each(function (index) {\n            var file = files[index] || { error: 'Empty file upload result' };\n            deferred = that._addFinishedDeferreds();\n            that._transition($(this)).done(function () {\n              var node = $(this);\n              template = that._renderDownload([file]).replaceAll(node);\n              that._forceReflow(template);\n              that._transition(template).done(function () {\n                data.context = $(this);\n                that._trigger('completed', e, data);\n                that._trigger('finished', e, data);\n                deferred.resolve();\n              });\n            });\n          });\n        } else {\n          template = that\n            ._renderDownload(files)\n            [that.options.prependFiles ? 'prependTo' : 'appendTo'](\n              that.options.filesContainer\n            );\n          that._forceReflow(template);\n          deferred = that._addFinishedDeferreds();\n          that._transition(template).done(function () {\n            data.context = $(this);\n            that._trigger('completed', e, data);\n            that._trigger('finished', e, data);\n            deferred.resolve();\n          });\n        }\n      },\n      // Callback for failed (abort or error) uploads:\n      fail: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n            $(this).data('blueimp-fileupload') || $(this).data('fileupload'),\n          template,\n          deferred;\n        if (data.context) {\n          data.context.each(function (index) {\n            if (data.errorThrown !== 'abort') {\n              var file = data.files[index];\n              file.error =\n                file.error || data.errorThrown || data.i18n('unknownError');\n              deferred = that._addFinishedDeferreds();\n              that._transition($(this)).done(function () {\n                var node = $(this);\n                template = that._renderDownload([file]).replaceAll(node);\n                that._forceReflow(template);\n                that._transition(template).done(function () {\n                  data.context = $(this);\n                  that._trigger('failed', e, data);\n                  that._trigger('finished', e, data);\n                  deferred.resolve();\n                });\n              });\n            } else {\n              deferred = that._addFinishedDeferreds();\n              that._transition($(this)).done(function () {\n                $(this).remove();\n                that._trigger('failed', e, data);\n                that._trigger('finished', e, data);\n                deferred.resolve();\n              });\n            }\n          });\n        } else if (data.errorThrown !== 'abort') {\n          data.context = that\n            ._renderUpload(data.files)\n            [that.options.prependFiles ? 'prependTo' : 'appendTo'](\n              that.options.filesContainer\n            )\n            .data('data', data);\n          that._forceReflow(data.context);\n          deferred = that._addFinishedDeferreds();\n          that._transition(data.context).done(function () {\n            data.context = $(this);\n            that._trigger('failed', e, data);\n            that._trigger('finished', e, data);\n            deferred.resolve();\n          });\n        } else {\n          that._trigger('failed', e, data);\n          that._trigger('finished', e, data);\n          that._addFinishedDeferreds().resolve();\n        }\n      },\n      // Callback for upload progress events:\n      progress: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var progress = Math.floor((data.loaded / data.total) * 100);\n        if (data.context) {\n          data.context.each(function () {\n            $(this)\n              .find('.progress')\n              .attr('aria-valuenow', progress)\n              .children()\n              .first()\n              .css('width', progress + '%');\n          });\n        }\n      },\n      // Callback for global upload progress events:\n      progressall: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var $this = $(this),\n          progress = Math.floor((data.loaded / data.total) * 100),\n          globalProgressNode = $this.find('.fileupload-progress'),\n          extendedProgressNode = globalProgressNode.find('.progress-extended');\n        if (extendedProgressNode.length) {\n          extendedProgressNode.html(\n            (\n              $this.data('blueimp-fileupload') || $this.data('fileupload')\n            )._renderExtendedProgress(data)\n          );\n        }\n        globalProgressNode\n          .find('.progress')\n          .attr('aria-valuenow', progress)\n          .children()\n          .first()\n          .css('width', progress + '%');\n      },\n      // Callback for uploads start, equivalent to the global ajaxStart event:\n      start: function (e) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n          $(this).data('blueimp-fileupload') || $(this).data('fileupload');\n        that._resetFinishedDeferreds();\n        that\n          ._transition($(this).find('.fileupload-progress'))\n          .done(function () {\n            that._trigger('started', e);\n          });\n      },\n      // Callback for uploads stop, equivalent to the global ajaxStop event:\n      stop: function (e) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n            $(this).data('blueimp-fileupload') || $(this).data('fileupload'),\n          deferred = that._addFinishedDeferreds();\n        $.when.apply($, that._getFinishedDeferreds()).done(function () {\n          that._trigger('stopped', e);\n        });\n        that\n          ._transition($(this).find('.fileupload-progress'))\n          .done(function () {\n            $(this)\n              .find('.progress')\n              .attr('aria-valuenow', '0')\n              .children()\n              .first()\n              .css('width', '0%');\n            $(this).find('.progress-extended').html('&nbsp;');\n            deferred.resolve();\n          });\n      },\n      processstart: function (e) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        $(this).addClass('fileupload-processing');\n      },\n      processstop: function (e) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        $(this).removeClass('fileupload-processing');\n      },\n      // Callback for file deletion:\n      destroy: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n            $(this).data('blueimp-fileupload') || $(this).data('fileupload'),\n          removeNode = function () {\n            that._transition(data.context).done(function () {\n              $(this).remove();\n              that._trigger('destroyed', e, data);\n            });\n          };\n        if (data.url) {\n          data.dataType = data.dataType || that.options.dataType;\n          $.ajax(data)\n            .done(removeNode)\n            .fail(function () {\n              that._trigger('destroyfailed', e, data);\n            });\n        } else {\n          removeNode();\n        }\n      }\n    },\n\n    _resetFinishedDeferreds: function () {\n      this._finishedUploads = [];\n    },\n\n    _addFinishedDeferreds: function (deferred) {\n      // eslint-disable-next-line new-cap\n      var promise = deferred || $.Deferred();\n      this._finishedUploads.push(promise);\n      return promise;\n    },\n\n    _getFinishedDeferreds: function () {\n      return this._finishedUploads;\n    },\n\n    // Link handler, that allows to download files\n    // by drag & drop of the links to the desktop:\n    _enableDragToDesktop: function () {\n      var link = $(this),\n        url = link.prop('href'),\n        name = link.prop('download'),\n        type = 'application/octet-stream';\n      link.on('dragstart', function (e) {\n        try {\n          e.originalEvent.dataTransfer.setData(\n            'DownloadURL',\n            [type, name, url].join(':')\n          );\n        } catch (ignore) {\n          // Ignore exceptions\n        }\n      });\n    },\n\n    _formatFileSize: function (bytes) {\n      if (typeof bytes !== 'number') {\n        return '';\n      }\n      if (bytes >= 1000000000) {\n        return (bytes / 1000000000).toFixed(2) + ' GB';\n      }\n      if (bytes >= 1000000) {\n        return (bytes / 1000000).toFixed(2) + ' MB';\n      }\n      return (bytes / 1000).toFixed(2) + ' KB';\n    },\n\n    _formatBitrate: function (bits) {\n      if (typeof bits !== 'number') {\n        return '';\n      }\n      if (bits >= 1000000000) {\n        return (bits / 1000000000).toFixed(2) + ' Gbit/s';\n      }\n      if (bits >= 1000000) {\n        return (bits / 1000000).toFixed(2) + ' Mbit/s';\n      }\n      if (bits >= 1000) {\n        return (bits / 1000).toFixed(2) + ' kbit/s';\n      }\n      return bits.toFixed(2) + ' bit/s';\n    },\n\n    _formatTime: function (seconds) {\n      var date = new Date(seconds * 1000),\n        days = Math.floor(seconds / 86400);\n      days = days ? days + 'd ' : '';\n      return (\n        days +\n        ('0' + date.getUTCHours()).slice(-2) +\n        ':' +\n        ('0' + date.getUTCMinutes()).slice(-2) +\n        ':' +\n        ('0' + date.getUTCSeconds()).slice(-2)\n      );\n    },\n\n    _formatPercentage: function (floatValue) {\n      return (floatValue * 100).toFixed(2) + ' %';\n    },\n\n    _renderExtendedProgress: function (data) {\n      return (\n        this._formatBitrate(data.bitrate) +\n        ' | ' +\n        this._formatTime(((data.total - data.loaded) * 8) / data.bitrate) +\n        ' | ' +\n        this._formatPercentage(data.loaded / data.total) +\n        ' | ' +\n        this._formatFileSize(data.loaded) +\n        ' / ' +\n        this._formatFileSize(data.total)\n      );\n    },\n\n    _renderTemplate: function (func, files) {\n      if (!func) {\n        return $();\n      }\n      var result = func({\n        files: files,\n        formatFileSize: this._formatFileSize,\n        options: this.options\n      });\n      if (result instanceof $) {\n        return result;\n      }\n      return $(this.options.templatesContainer).html(result).children();\n    },\n\n    _renderPreviews: function (data) {\n      data.context.find('.preview').each(function (index, elm) {\n        $(elm).empty().append(data.files[index].preview);\n      });\n    },\n\n    _renderUpload: function (files) {\n      return this._renderTemplate(this.options.uploadTemplate, files);\n    },\n\n    _renderDownload: function (files) {\n      return this._renderTemplate(this.options.downloadTemplate, files)\n        .find('a[download]')\n        .each(this._enableDragToDesktop)\n        .end();\n    },\n\n    _editHandler: function (e) {\n      e.preventDefault();\n      if (!this.options.edit) return;\n      var that = this,\n        button = $(e.currentTarget),\n        template = button.closest('.template-upload'),\n        data = template.data('data'),\n        index = button.data().index;\n      this.options.edit(data.files[index]).then(function (file) {\n        if (!file) return;\n        data.files[index] = file;\n        data.context.addClass('processing');\n        template.find('.edit,.start').prop('disabled', true);\n        $(that.element)\n          .fileupload('process', data)\n          .always(function () {\n            template\n              .find('.size')\n              .text(that._formatFileSize(data.files[index].size));\n            data.context.removeClass('processing');\n            that._renderPreviews(data);\n          })\n          .done(function () {\n            template.find('.edit,.start').prop('disabled', false);\n          })\n          .fail(function () {\n            template.find('.edit').prop('disabled', false);\n            var error = data.files[index].error;\n            if (error) {\n              template.find('.error').text(error);\n            }\n          });\n      });\n    },\n\n    _startHandler: function (e) {\n      e.preventDefault();\n      var button = $(e.currentTarget),\n        template = button.closest('.template-upload'),\n        data = template.data('data');\n      button.prop('disabled', true);\n      if (data && data.submit) {\n        data.submit();\n      }\n    },\n\n    _cancelHandler: function (e) {\n      e.preventDefault();\n      var template = $(e.currentTarget).closest(\n          '.template-upload,.template-download'\n        ),\n        data = template.data('data') || {};\n      data.context = data.context || template;\n      if (data.abort) {\n        data.abort();\n      } else {\n        data.errorThrown = 'abort';\n        this._trigger('fail', e, data);\n      }\n    },\n\n    _deleteHandler: function (e) {\n      e.preventDefault();\n      var button = $(e.currentTarget);\n      this._trigger(\n        'destroy',\n        e,\n        $.extend(\n          {\n            context: button.closest('.template-download'),\n            type: 'DELETE'\n          },\n          button.data()\n        )\n      );\n    },\n\n    _forceReflow: function (node) {\n      return $.support.transition && node.length && node[0].offsetWidth;\n    },\n\n    _transition: function (node) {\n      // eslint-disable-next-line new-cap\n      var dfd = $.Deferred();\n      if (\n        $.support.transition &&\n        node.hasClass('fade') &&\n        node.is(':visible')\n      ) {\n        var transitionEndHandler = function (e) {\n          // Make sure we don't respond to other transition events\n          // in the container element, e.g. from button elements:\n          if (e.target === node[0]) {\n            node.off($.support.transition.end, transitionEndHandler);\n            dfd.resolveWith(node);\n          }\n        };\n        node\n          .on($.support.transition.end, transitionEndHandler)\n          .toggleClass(this.options.showElementClass);\n      } else {\n        node.toggleClass(this.options.showElementClass);\n        dfd.resolveWith(node);\n      }\n      return dfd;\n    },\n\n    _initButtonBarEventHandlers: function () {\n      var fileUploadButtonBar = this.element.find('.fileupload-buttonbar'),\n        filesList = this.options.filesContainer;\n      this._on(fileUploadButtonBar.find('.start'), {\n        click: function (e) {\n          e.preventDefault();\n          filesList.find('.start').trigger('click');\n        }\n      });\n      this._on(fileUploadButtonBar.find('.cancel'), {\n        click: function (e) {\n          e.preventDefault();\n          filesList.find('.cancel').trigger('click');\n        }\n      });\n      this._on(fileUploadButtonBar.find('.delete'), {\n        click: function (e) {\n          e.preventDefault();\n          filesList\n            .find('.toggle:checked')\n            .closest('.template-download')\n            .find('.delete')\n            .trigger('click');\n          fileUploadButtonBar.find('.toggle').prop('checked', false);\n        }\n      });\n      this._on(fileUploadButtonBar.find('.toggle'), {\n        change: function (e) {\n          filesList\n            .find('.toggle')\n            .prop('checked', $(e.currentTarget).is(':checked'));\n        }\n      });\n    },\n\n    _destroyButtonBarEventHandlers: function () {\n      this._off(\n        this.element\n          .find('.fileupload-buttonbar')\n          .find('.start, .cancel, .delete'),\n        'click'\n      );\n      this._off(this.element.find('.fileupload-buttonbar .toggle'), 'change.');\n    },\n\n    _initEventHandlers: function () {\n      this._super();\n      this._on(this.options.filesContainer, {\n        'click .edit': this._editHandler,\n        'click .start': this._startHandler,\n        'click .cancel': this._cancelHandler,\n        'click .delete': this._deleteHandler\n      });\n      this._initButtonBarEventHandlers();\n    },\n\n    _destroyEventHandlers: function () {\n      this._destroyButtonBarEventHandlers();\n      this._off(this.options.filesContainer, 'click');\n      this._super();\n    },\n\n    _enableFileInputButton: function () {\n      this.element\n        .find('.fileinput-button input')\n        .prop('disabled', false)\n        .parent()\n        .removeClass('disabled');\n    },\n\n    _disableFileInputButton: function () {\n      this.element\n        .find('.fileinput-button input')\n        .prop('disabled', true)\n        .parent()\n        .addClass('disabled');\n    },\n\n    _initTemplates: function () {\n      var options = this.options;\n      options.templatesContainer = this.document[0].createElement(\n        options.filesContainer.prop('nodeName')\n      );\n      if (tmpl) {\n        if (options.uploadTemplateId) {\n          options.uploadTemplate = tmpl(options.uploadTemplateId);\n        }\n        if (options.downloadTemplateId) {\n          options.downloadTemplate = tmpl(options.downloadTemplateId);\n        }\n      }\n    },\n\n    _initFilesContainer: function () {\n      var options = this.options;\n      if (options.filesContainer === undefined) {\n        options.filesContainer = this.element.find('.files');\n      } else if (!(options.filesContainer instanceof $)) {\n        options.filesContainer = $(options.filesContainer);\n      }\n    },\n\n    _initSpecialOptions: function () {\n      this._super();\n      this._initFilesContainer();\n      // this._initTemplates();\n    },\n\n    _create: function () {\n      this._super();\n      this._resetFinishedDeferreds();\n      if (!$.support.fileInput) {\n        this._disableFileInputButton();\n      }\n    },\n\n    enable: function () {\n      var wasDisabled = false;\n      if (this.options.disabled) {\n        wasDisabled = true;\n      }\n      this._super();\n      if (wasDisabled) {\n        this.element.find('input, button').prop('disabled', false);\n        this._enableFileInputButton();\n      }\n    },\n\n    disable: function () {\n      if (!this.options.disabled) {\n        this.element.find('input, button').prop('disabled', true);\n        this._disableFileInputButton();\n      }\n      this._super();\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload-video.js":"/*\n * jQuery File Upload Video Preview Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/jquery.fileupload-process'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'),\n      require('jquery/fileUploader/jquery.fileupload-process')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery, window.loadImage);\n  }\n})(function ($, loadImage) {\n  'use strict';\n\n  // Prepend to the default processQueue:\n  $.blueimp.fileupload.prototype.options.processQueue.unshift(\n    {\n      action: 'loadVideo',\n      // Use the action as prefix for the \"@\" options:\n      prefix: true,\n      fileTypes: '@',\n      maxFileSize: '@',\n      disabled: '@disableVideoPreview'\n    },\n    {\n      action: 'setVideo',\n      name: '@videoPreviewName',\n      disabled: '@disableVideoPreview'\n    }\n  );\n\n  // The File Upload Video Preview plugin extends the fileupload widget\n  // with video preview functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // The regular expression for the types of video files to load,\n      // matched against the file type:\n      loadVideoFileTypes: /^video\\/.*$/\n    },\n\n    _videoElement: document.createElement('video'),\n\n    processActions: {\n      // Loads the video file given via data.files and data.index\n      // as video element if the browser supports playing it.\n      // Accepts the options fileTypes (regular expression)\n      // and maxFileSize (integer) to limit the files to load:\n      loadVideo: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        var file = data.files[data.index],\n          url,\n          video;\n        if (\n          this._videoElement.canPlayType &&\n          this._videoElement.canPlayType(file.type) &&\n          ($.type(options.maxFileSize) !== 'number' ||\n            file.size <= options.maxFileSize) &&\n          (!options.fileTypes || options.fileTypes.test(file.type))\n        ) {\n          url = loadImage.createObjectURL(file);\n          if (url) {\n            video = this._videoElement.cloneNode(false);\n            video.src = url;\n            video.controls = true;\n            data.video = video;\n            return data;\n          }\n        }\n        return data;\n      },\n\n      // Sets the video element as a property of the file object:\n      setVideo: function (data, options) {\n        if (data.video && !options.disabled) {\n          data.files[data.index][options.name || 'preview'] = data.video;\n        }\n        return data;\n      }\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload-image.js":"/*\n * jQuery File Upload Image Preview & Resize Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define([\n      'jquery',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-orientation',\n      'jquery/fileUploader/vendor/blueimp-canvas-to-blob/js/canvas-to-blob',\n      'jquery/fileUploader/jquery.fileupload-process'\n    ], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-orientation'),\n      require('jquery/fileUploader/vendor/blueimp-canvas-to-blob/js/canvas-to-blob'),\n      require('jquery/fileUploader/jquery.fileupload-process')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery, window.loadImage);\n  }\n})(function ($, loadImage) {\n  'use strict';\n\n  // Prepend to the default processQueue:\n  $.blueimp.fileupload.prototype.options.processQueue.unshift(\n    {\n      action: 'loadImageMetaData',\n      maxMetaDataSize: '@',\n      disableImageHead: '@',\n      disableMetaDataParsers: '@',\n      disableExif: '@',\n      disableExifOffsets: '@',\n      includeExifTags: '@',\n      excludeExifTags: '@',\n      disableIptc: '@',\n      disableIptcOffsets: '@',\n      includeIptcTags: '@',\n      excludeIptcTags: '@',\n      disabled: '@disableImageMetaDataLoad'\n    },\n    {\n      action: 'loadImage',\n      // Use the action as prefix for the \"@\" options:\n      prefix: true,\n      fileTypes: '@',\n      maxFileSize: '@',\n      noRevoke: '@',\n      disabled: '@disableImageLoad'\n    },\n    {\n      action: 'resizeImage',\n      // Use \"image\" as prefix for the \"@\" options:\n      prefix: 'image',\n      maxWidth: '@',\n      maxHeight: '@',\n      minWidth: '@',\n      minHeight: '@',\n      crop: '@',\n      orientation: '@',\n      forceResize: '@',\n      disabled: '@disableImageResize'\n    },\n    {\n      action: 'saveImage',\n      quality: '@imageQuality',\n      type: '@imageType',\n      disabled: '@disableImageResize'\n    },\n    {\n      action: 'saveImageMetaData',\n      disabled: '@disableImageMetaDataSave'\n    },\n    {\n      action: 'resizeImage',\n      // Use \"preview\" as prefix for the \"@\" options:\n      prefix: 'preview',\n      maxWidth: '@',\n      maxHeight: '@',\n      minWidth: '@',\n      minHeight: '@',\n      crop: '@',\n      orientation: '@',\n      thumbnail: '@',\n      canvas: '@',\n      disabled: '@disableImagePreview'\n    },\n    {\n      action: 'setImage',\n      name: '@imagePreviewName',\n      disabled: '@disableImagePreview'\n    },\n    {\n      action: 'deleteImageReferences',\n      disabled: '@disableImageReferencesDeletion'\n    }\n  );\n\n  // The File Upload Resize plugin extends the fileupload widget\n  // with image resize functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // The regular expression for the types of images to load:\n      // matched against the file type:\n      loadImageFileTypes: /^image\\/(gif|jpeg|png|svg\\+xml)$/,\n      // The maximum file size of images to load:\n      loadImageMaxFileSize: 10000000, // 10MB\n      // The maximum width of resized images:\n      imageMaxWidth: 1920,\n      // The maximum height of resized images:\n      imageMaxHeight: 1080,\n      // Defines the image orientation (1-8) or takes the orientation\n      // value from Exif data if set to true:\n      imageOrientation: true,\n      // Define if resized images should be cropped or only scaled:\n      imageCrop: false,\n      // Disable the resize image functionality by default:\n      disableImageResize: true,\n      // The maximum width of the preview images:\n      previewMaxWidth: 80,\n      // The maximum height of the preview images:\n      previewMaxHeight: 80,\n      // Defines the preview orientation (1-8) or takes the orientation\n      // value from Exif data if set to true:\n      previewOrientation: true,\n      // Create the preview using the Exif data thumbnail:\n      previewThumbnail: true,\n      // Define if preview images should be cropped or only scaled:\n      previewCrop: false,\n      // Define if preview images should be resized as canvas elements:\n      previewCanvas: true\n    },\n\n    processActions: {\n      // Loads the image given via data.files and data.index\n      // as img element, if the browser supports the File API.\n      // Accepts the options fileTypes (regular expression)\n      // and maxFileSize (integer) to limit the files to load:\n      loadImage: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        var that = this,\n          file = data.files[data.index],\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred();\n        if (\n          ($.type(options.maxFileSize) === 'number' &&\n            file.size > options.maxFileSize) ||\n          (options.fileTypes && !options.fileTypes.test(file.type)) ||\n          !loadImage(\n            file,\n            function (img) {\n              if (img.src) {\n                data.img = img;\n              }\n              dfd.resolveWith(that, [data]);\n            },\n            options\n          )\n        ) {\n          return data;\n        }\n        return dfd.promise();\n      },\n\n      // Resizes the image given as data.canvas or data.img\n      // and updates data.canvas or data.img with the resized image.\n      // Also stores the resized image as preview property.\n      // Accepts the options maxWidth, maxHeight, minWidth,\n      // minHeight, canvas and crop:\n      resizeImage: function (data, options) {\n        if (options.disabled || !(data.canvas || data.img)) {\n          return data;\n        }\n        // eslint-disable-next-line no-param-reassign\n        options = $.extend({ canvas: true }, options);\n        var that = this,\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred(),\n          img = (options.canvas && data.canvas) || data.img,\n          resolve = function (newImg) {\n            if (\n              newImg &&\n              (newImg.width !== img.width ||\n                newImg.height !== img.height ||\n                options.forceResize)\n            ) {\n              data[newImg.getContext ? 'canvas' : 'img'] = newImg;\n            }\n            data.preview = newImg;\n            dfd.resolveWith(that, [data]);\n          },\n          thumbnail,\n          thumbnailBlob;\n        if (data.exif && options.thumbnail) {\n          thumbnail = data.exif.get('Thumbnail');\n          thumbnailBlob = thumbnail && thumbnail.get('Blob');\n          if (thumbnailBlob) {\n            options.orientation = data.exif.get('Orientation');\n            loadImage(thumbnailBlob, resolve, options);\n            return dfd.promise();\n          }\n        }\n        if (data.orientation) {\n          // Prevent orienting the same image twice:\n          delete options.orientation;\n        } else {\n          data.orientation = options.orientation || loadImage.orientation;\n        }\n        if (img) {\n          resolve(loadImage.scale(img, options, data));\n          return dfd.promise();\n        }\n        return data;\n      },\n\n      // Saves the processed image given as data.canvas\n      // inplace at data.index of data.files:\n      saveImage: function (data, options) {\n        if (!data.canvas || options.disabled) {\n          return data;\n        }\n        var that = this,\n          file = data.files[data.index],\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred();\n        if (data.canvas.toBlob) {\n          data.canvas.toBlob(\n            function (blob) {\n              if (!blob.name) {\n                if (file.type === blob.type) {\n                  blob.name = file.name;\n                } else if (file.name) {\n                  blob.name = file.name.replace(\n                    /\\.\\w+$/,\n                    '.' + blob.type.substr(6)\n                  );\n                }\n              }\n              // Don't restore invalid meta data:\n              if (file.type !== blob.type) {\n                delete data.imageHead;\n              }\n              // Store the created blob at the position\n              // of the original file in the files list:\n              data.files[data.index] = blob;\n              dfd.resolveWith(that, [data]);\n            },\n            options.type || file.type,\n            options.quality\n          );\n        } else {\n          return data;\n        }\n        return dfd.promise();\n      },\n\n      loadImageMetaData: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        var that = this,\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred();\n        loadImage.parseMetaData(\n          data.files[data.index],\n          function (result) {\n            $.extend(data, result);\n            dfd.resolveWith(that, [data]);\n          },\n          options\n        );\n        return dfd.promise();\n      },\n\n      saveImageMetaData: function (data, options) {\n        if (\n          !(\n            data.imageHead &&\n            data.canvas &&\n            data.canvas.toBlob &&\n            !options.disabled\n          )\n        ) {\n          return data;\n        }\n        var that = this,\n          file = data.files[data.index],\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred();\n        if (data.orientation === true && data.exifOffsets) {\n          // Reset Exif Orientation data:\n          loadImage.writeExifData(data.imageHead, data, 'Orientation', 1);\n        }\n        loadImage.replaceHead(file, data.imageHead, function (blob) {\n          blob.name = file.name;\n          data.files[data.index] = blob;\n          dfd.resolveWith(that, [data]);\n        });\n        return dfd.promise();\n      },\n\n      // Sets the resized version of the image as a property of the\n      // file object, must be called after \"saveImage\":\n      setImage: function (data, options) {\n        if (data.preview && !options.disabled) {\n          data.files[data.index][options.name || 'preview'] = data.preview;\n        }\n        return data;\n      },\n\n      deleteImageReferences: function (data, options) {\n        if (!options.disabled) {\n          delete data.img;\n          delete data.canvas;\n          delete data.preview;\n          delete data.imageHead;\n        }\n        return data;\n      }\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileuploader.js":"/**\n * Custom Uploader\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define([\n      'jquery',\n      'jquery/fileUploader/jquery.fileupload-image',\n      'jquery/fileUploader/jquery.fileupload-audio',\n      'jquery/fileUploader/jquery.fileupload-video',\n      'jquery/fileUploader/jquery.iframe-transport',\n    ], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/jquery.fileupload-image'),\n      require('jquery/fileUploader/jquery.fileupload-audio'),\n      require('jquery/fileUploader/jquery.fileupload-video'),\n      require('jquery/fileUploader/jquery.iframe-transport')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})();\n","jquery/fileUploader/jquery.fileupload-process.js":"/*\n * jQuery File Upload Processing Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2012, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/jquery.fileupload'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'), require('jquery/fileUploader/jquery.fileupload'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  var originalAdd = $.blueimp.fileupload.prototype.options.add;\n\n  // The File Upload Processing plugin extends the fileupload widget\n  // with file processing functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // The list of processing actions:\n      processQueue: [\n        /*\n                {\n                    action: 'log',\n                    type: 'debug'\n                }\n                */\n      ],\n      add: function (e, data) {\n        var $this = $(this);\n        data.process(function () {\n          return $this.fileupload('process', data);\n        });\n        originalAdd.call(this, e, data);\n      }\n    },\n\n    processActions: {\n      /*\n            log: function (data, options) {\n                console[options.type](\n                    'Processing \"' + data.files[data.index].name + '\"'\n                );\n            }\n            */\n    },\n\n    _processFile: function (data, originalData) {\n      var that = this,\n        // eslint-disable-next-line new-cap\n        dfd = $.Deferred().resolveWith(that, [data]),\n        chain = dfd.promise();\n      this._trigger('process', null, data);\n      $.each(data.processQueue, function (i, settings) {\n        var func = function (data) {\n          if (originalData.errorThrown) {\n            // eslint-disable-next-line new-cap\n            return $.Deferred().rejectWith(that, [originalData]).promise();\n          }\n          return that.processActions[settings.action].call(\n            that,\n            data,\n            settings\n          );\n        };\n        chain = chain[that._promisePipe](func, settings.always && func);\n      });\n      chain\n        .done(function () {\n          that._trigger('processdone', null, data);\n          that._trigger('processalways', null, data);\n        })\n        .fail(function () {\n          that._trigger('processfail', null, data);\n          that._trigger('processalways', null, data);\n        });\n      return chain;\n    },\n\n    // Replaces the settings of each processQueue item that\n    // are strings starting with an \"@\", using the remaining\n    // substring as key for the option map,\n    // e.g. \"@autoUpload\" is replaced with options.autoUpload:\n    _transformProcessQueue: function (options) {\n      var processQueue = [];\n      $.each(options.processQueue, function () {\n        var settings = {},\n          action = this.action,\n          prefix = this.prefix === true ? action : this.prefix;\n        $.each(this, function (key, value) {\n          if ($.type(value) === 'string' && value.charAt(0) === '@') {\n            settings[key] =\n              options[\n                value.slice(1) ||\n                  (prefix\n                    ? prefix + key.charAt(0).toUpperCase() + key.slice(1)\n                    : key)\n              ];\n          } else {\n            settings[key] = value;\n          }\n        });\n        processQueue.push(settings);\n      });\n      options.processQueue = processQueue;\n    },\n\n    // Returns the number of files currently in the processsing queue:\n    processing: function () {\n      return this._processing;\n    },\n\n    // Processes the files given as files property of the data parameter,\n    // returns a Promise object that allows to bind callbacks:\n    process: function (data) {\n      var that = this,\n        options = $.extend({}, this.options, data);\n      if (options.processQueue && options.processQueue.length) {\n        this._transformProcessQueue(options);\n        if (this._processing === 0) {\n          this._trigger('processstart');\n        }\n        $.each(data.files, function (index) {\n          var opts = index ? $.extend({}, options) : options,\n            func = function () {\n              if (data.errorThrown) {\n                // eslint-disable-next-line new-cap\n                return $.Deferred().rejectWith(that, [data]).promise();\n              }\n              return that._processFile(opts, data);\n            };\n          opts.index = index;\n          that._processing += 1;\n          that._processingQueue = that._processingQueue[that._promisePipe](\n            func,\n            func\n          ).always(function () {\n            that._processing -= 1;\n            if (that._processing === 0) {\n              that._trigger('processstop');\n            }\n          });\n        });\n      }\n      return this._processingQueue;\n    },\n\n    _create: function () {\n      this._super();\n      this._processing = 0;\n      // eslint-disable-next-line new-cap\n      this._processingQueue = $.Deferred().resolveWith(this).promise();\n    }\n  });\n});\n","jquery/fileUploader/jquery.iframe-transport.js":"/*\n * jQuery Iframe Transport Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  // Helper variable to create unique names for the transport iframes:\n  var counter = 0,\n    jsonAPI = $,\n    jsonParse = 'parseJSON';\n\n  if ('JSON' in window && 'parse' in JSON) {\n    jsonAPI = JSON;\n    jsonParse = 'parse';\n  }\n\n  // The iframe transport accepts four additional options:\n  // options.fileInput: a jQuery collection of file input fields\n  // options.paramName: the parameter name for the file form data,\n  //  overrides the name property of the file input field(s),\n  //  can be a string or an array of strings.\n  // options.formData: an array of objects with name and value properties,\n  //  equivalent to the return data of .serializeArray(), e.g.:\n  //  [{name: 'a', value: 1}, {name: 'b', value: 2}]\n  // options.initialIframeSrc: the URL of the initial iframe src,\n  //  by default set to \"javascript:false;\"\n  $.ajaxTransport('iframe', function (options) {\n    if (options.async) {\n      // javascript:false as initial iframe src\n      // prevents warning popups on HTTPS in IE6:\n      // eslint-disable-next-line no-script-url\n      var initialIframeSrc = options.initialIframeSrc || 'javascript:false;',\n        form,\n        iframe,\n        addParamChar;\n      return {\n        send: function (_, completeCallback) {\n          form = $('<form style=\"display:none;\"></form>');\n          form.attr('accept-charset', options.formAcceptCharset);\n          addParamChar = /\\?/.test(options.url) ? '&' : '?';\n          // XDomainRequest only supports GET and POST:\n          if (options.type === 'DELETE') {\n            options.url = options.url + addParamChar + '_method=DELETE';\n            options.type = 'POST';\n          } else if (options.type === 'PUT') {\n            options.url = options.url + addParamChar + '_method=PUT';\n            options.type = 'POST';\n          } else if (options.type === 'PATCH') {\n            options.url = options.url + addParamChar + '_method=PATCH';\n            options.type = 'POST';\n          }\n          // IE versions below IE8 cannot set the name property of\n          // elements that have already been added to the DOM,\n          // so we set the name along with the iframe HTML markup:\n          counter += 1;\n          iframe = $(\n            '<iframe src=\"' +\n              initialIframeSrc +\n              '\" name=\"iframe-transport-' +\n              counter +\n              '\"></iframe>'\n          ).on('load', function () {\n            var fileInputClones,\n              paramNames = $.isArray(options.paramName)\n                ? options.paramName\n                : [options.paramName];\n            iframe.off('load').on('load', function () {\n              var response;\n              // Wrap in a try/catch block to catch exceptions thrown\n              // when trying to access cross-domain iframe contents:\n              try {\n                response = iframe.contents();\n                // Google Chrome and Firefox do not throw an\n                // exception when calling iframe.contents() on\n                // cross-domain requests, so we unify the response:\n                if (!response.length || !response[0].firstChild) {\n                  throw new Error();\n                }\n              } catch (e) {\n                response = undefined;\n              }\n              // The complete callback returns the\n              // iframe content document as response object:\n              completeCallback(200, 'success', { iframe: response });\n              // Fix for IE endless progress bar activity bug\n              // (happens on form submits to iframe targets):\n              $('<iframe src=\"' + initialIframeSrc + '\"></iframe>').appendTo(\n                form\n              );\n              window.setTimeout(function () {\n                // Removing the form in a setTimeout call\n                // allows Chrome's developer tools to display\n                // the response result\n                form.remove();\n              }, 0);\n            });\n            form\n              .prop('target', iframe.prop('name'))\n              .prop('action', options.url)\n              .prop('method', options.type);\n            if (options.formData) {\n              $.each(options.formData, function (index, field) {\n                $('<input type=\"hidden\"/>')\n                  .prop('name', field.name)\n                  .val(field.value)\n                  .appendTo(form);\n              });\n            }\n            if (\n              options.fileInput &&\n              options.fileInput.length &&\n              options.type === 'POST'\n            ) {\n              fileInputClones = options.fileInput.clone();\n              // Insert a clone for each file input field:\n              options.fileInput.after(function (index) {\n                return fileInputClones[index];\n              });\n              if (options.paramName) {\n                options.fileInput.each(function (index) {\n                  $(this).prop('name', paramNames[index] || options.paramName);\n                });\n              }\n              // Appending the file input fields to the hidden form\n              // removes them from their original location:\n              form\n                .append(options.fileInput)\n                .prop('enctype', 'multipart/form-data')\n                // enctype must be set as encoding for IE:\n                .prop('encoding', 'multipart/form-data');\n              // Remove the HTML5 form attribute from the input(s):\n              options.fileInput.removeAttr('form');\n            }\n            window.setTimeout(function () {\n              // Submitting the form in a setTimeout call fixes an issue with\n              // Safari 13 not triggering the iframe load event after resetting\n              // the load event handler, see also:\n              // https://github.com/blueimp/jQuery-File-Upload/issues/3633\n              form.submit();\n              // Insert the file input fields at their original location\n              // by replacing the clones with the originals:\n              if (fileInputClones && fileInputClones.length) {\n                options.fileInput.each(function (index, input) {\n                  var clone = $(fileInputClones[index]);\n                  // Restore the original name and form properties:\n                  $(input)\n                    .prop('name', clone.prop('name'))\n                    .attr('form', clone.attr('form'));\n                  clone.replaceWith(input);\n                });\n              }\n            }, 0);\n          });\n          form.append(iframe).appendTo(document.body);\n        },\n        abort: function () {\n          if (iframe) {\n            // javascript:false as iframe src aborts the request\n            // and prevents warning popups on HTTPS in IE6.\n            iframe.off('load').prop('src', initialIframeSrc);\n          }\n          if (form) {\n            form.remove();\n          }\n        }\n      };\n    }\n  });\n\n  // The iframe transport returns the iframe content document as response.\n  // The following adds converters from iframe to text, json, html, xml\n  // and script.\n  // Please note that the Content-Type for JSON responses has to be text/plain\n  // or text/html, if the browser doesn't include application/json in the\n  // Accept header, else IE will show a download dialog.\n  // The Content-Type for XML responses on the other hand has to be always\n  // application/xml or text/xml, so IE properly parses the XML response.\n  // See also\n  // https://github.com/blueimp/jQuery-File-Upload/wiki/Setup#content-type-negotiation\n  $.ajaxSetup({\n    converters: {\n      'iframe text': function (iframe) {\n        return iframe && $(iframe[0].body).text();\n      },\n      'iframe json': function (iframe) {\n        return iframe && jsonAPI[jsonParse]($(iframe[0].body).text());\n      },\n      'iframe html': function (iframe) {\n        return iframe && $(iframe[0].body).html();\n      },\n      'iframe xml': function (iframe) {\n        var xmlDoc = iframe && iframe[0];\n        return xmlDoc && $.isXMLDoc(xmlDoc)\n          ? xmlDoc\n          : $.parseXML(\n              (xmlDoc.XMLDocument && xmlDoc.XMLDocument.xml) ||\n                $(xmlDoc.body).html()\n            );\n      },\n      'iframe script': function (iframe) {\n        return iframe && $.globalEval($(iframe[0].body).text());\n      }\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload-audio.js":"/*\n * jQuery File Upload Audio Preview Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/jquery.fileupload-process'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'),\n      require('jquery/fileUploader/jquery.fileupload-process')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery, window.loadImage);\n  }\n})(function ($, loadImage) {\n  'use strict';\n\n  // Prepend to the default processQueue:\n  $.blueimp.fileupload.prototype.options.processQueue.unshift(\n    {\n      action: 'loadAudio',\n      // Use the action as prefix for the \"@\" options:\n      prefix: true,\n      fileTypes: '@',\n      maxFileSize: '@',\n      disabled: '@disableAudioPreview'\n    },\n    {\n      action: 'setAudio',\n      name: '@audioPreviewName',\n      disabled: '@disableAudioPreview'\n    }\n  );\n\n  // The File Upload Audio Preview plugin extends the fileupload widget\n  // with audio preview functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // The regular expression for the types of audio files to load,\n      // matched against the file type:\n      loadAudioFileTypes: /^audio\\/.*$/\n    },\n\n    _audioElement: document.createElement('audio'),\n\n    processActions: {\n      // Loads the audio file given via data.files and data.index\n      // as audio element if the browser supports playing it.\n      // Accepts the options fileTypes (regular expression)\n      // and maxFileSize (integer) to limit the files to load:\n      loadAudio: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        var file = data.files[data.index],\n          url,\n          audio;\n        if (\n          this._audioElement.canPlayType &&\n          this._audioElement.canPlayType(file.type) &&\n          ($.type(options.maxFileSize) !== 'number' ||\n            file.size <= options.maxFileSize) &&\n          (!options.fileTypes || options.fileTypes.test(file.type))\n        ) {\n          url = loadImage.createObjectURL(file);\n          if (url) {\n            audio = this._audioElement.cloneNode(false);\n            audio.src = url;\n            audio.controls = true;\n            data.audio = audio;\n            return data;\n          }\n        }\n        return data;\n      },\n\n      // Sets the audio element as a property of the file object:\n      setAudio: function (data, options) {\n        if (data.audio && !options.disabled) {\n          data.files[data.index][options.name || 'preview'] = data.audio;\n        }\n        return data;\n      }\n    }\n  });\n});\n","jquery/fileUploader/cors/jquery.xdr-transport.js":"/*\n * jQuery XDomainRequest Transport Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n *\n * Based on Julian Aubourg's ajaxHooks xdr.js:\n * https://github.com/jaubourg/ajaxHooks/\n */\n\n/* global define, require, XDomainRequest */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n  if (window.XDomainRequest && !$.support.cors) {\n    $.ajaxTransport(function (s) {\n      if (s.crossDomain && s.async) {\n        if (s.timeout) {\n          s.xdrTimeout = s.timeout;\n          delete s.timeout;\n        }\n        var xdr;\n        return {\n          send: function (headers, completeCallback) {\n            var addParamChar = /\\?/.test(s.url) ? '&' : '?';\n            /**\n             * Callback wrapper function\n             *\n             * @param {number} status HTTP status code\n             * @param {string} statusText HTTP status text\n             * @param {object} [responses] Content-type specific responses\n             * @param {string} [responseHeaders] Response headers string\n             */\n            function callback(status, statusText, responses, responseHeaders) {\n              xdr.onload = xdr.onerror = xdr.ontimeout = $.noop;\n              xdr = null;\n              completeCallback(status, statusText, responses, responseHeaders);\n            }\n            xdr = new XDomainRequest();\n            // XDomainRequest only supports GET and POST:\n            if (s.type === 'DELETE') {\n              s.url = s.url + addParamChar + '_method=DELETE';\n              s.type = 'POST';\n            } else if (s.type === 'PUT') {\n              s.url = s.url + addParamChar + '_method=PUT';\n              s.type = 'POST';\n            } else if (s.type === 'PATCH') {\n              s.url = s.url + addParamChar + '_method=PATCH';\n              s.type = 'POST';\n            }\n            xdr.open(s.type, s.url);\n            xdr.onload = function () {\n              callback(\n                200,\n                'OK',\n                { text: xdr.responseText },\n                'Content-Type: ' + xdr.contentType\n              );\n            };\n            xdr.onerror = function () {\n              callback(404, 'Not Found');\n            };\n            if (s.xdrTimeout) {\n              xdr.ontimeout = function () {\n                callback(0, 'timeout');\n              };\n              xdr.timeout = s.xdrTimeout;\n            }\n            xdr.send((s.hasContent && s.data) || null);\n          },\n          abort: function () {\n            if (xdr) {\n              xdr.onerror = $.noop();\n              xdr.abort();\n            }\n          }\n        };\n      }\n    });\n  }\n});\n","jquery/fileUploader/cors/jquery.postmessage-transport.js":"/*\n * jQuery postMessage Transport Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  var counter = 0,\n    names = [\n      'accepts',\n      'cache',\n      'contents',\n      'contentType',\n      'crossDomain',\n      'data',\n      'dataType',\n      'headers',\n      'ifModified',\n      'mimeType',\n      'password',\n      'processData',\n      'timeout',\n      'traditional',\n      'type',\n      'url',\n      'username'\n    ],\n    convert = function (p) {\n      return p;\n    };\n\n  $.ajaxSetup({\n    converters: {\n      'postmessage text': convert,\n      'postmessage json': convert,\n      'postmessage html': convert\n    }\n  });\n\n  $.ajaxTransport('postmessage', function (options) {\n    if (options.postMessage && window.postMessage) {\n      var iframe,\n        loc = $('<a></a>').prop('href', options.postMessage)[0],\n        target = loc.protocol + '//' + loc.host,\n        xhrUpload = options.xhr().upload;\n      // IE always includes the port for the host property of a link\n      // element, but not in the location.host or origin property for the\n      // default http port 80 and https port 443, so we strip it:\n      if (/^(http:\\/\\/.+:80)|(https:\\/\\/.+:443)$/.test(target)) {\n        target = target.replace(/:(80|443)$/, '');\n      }\n      return {\n        send: function (_, completeCallback) {\n          counter += 1;\n          var message = {\n              id: 'postmessage-transport-' + counter\n            },\n            eventName = 'message.' + message.id;\n          iframe = $(\n            '<iframe style=\"display:none;\" src=\"' +\n              options.postMessage +\n              '\" name=\"' +\n              message.id +\n              '\"></iframe>'\n          )\n            .on('load', function () {\n              $.each(names, function (i, name) {\n                message[name] = options[name];\n              });\n              message.dataType = message.dataType.replace('postmessage ', '');\n              $(window).on(eventName, function (event) {\n                var e = event.originalEvent;\n                var data = e.data;\n                var ev;\n                if (e.origin === target && data.id === message.id) {\n                  if (data.type === 'progress') {\n                    ev = document.createEvent('Event');\n                    ev.initEvent(data.type, false, true);\n                    $.extend(ev, data);\n                    xhrUpload.dispatchEvent(ev);\n                  } else {\n                    completeCallback(\n                      data.status,\n                      data.statusText,\n                      { postmessage: data.result },\n                      data.headers\n                    );\n                    iframe.remove();\n                    $(window).off(eventName);\n                  }\n                }\n              });\n              iframe[0].contentWindow.postMessage(message, target);\n            })\n            .appendTo(document.body);\n        },\n        abort: function () {\n          if (iframe) {\n            iframe.remove();\n          }\n        }\n      };\n    }\n  });\n});\n","jquery/fileUploader/vendor/jquery.ui.widget.js":"/*! jQuery UI - v1.13.2\n * http://jqueryui.com\n * Includes: widget.js\n * Copyright jQuery Foundation and other contributors; Licensed MIT */\n\n/* global define, require */\n/* eslint-disable no-param-reassign, new-cap, jsdoc/require-jsdoc */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // AMD. Register as an anonymous module.\n        define(['jquery'], factory);\n    } else if (typeof exports === 'object') {\n        // Node/CommonJS\n        factory(require('jquery'));\n    } else {\n        // Browser globals\n        factory(window.jQuery);\n    }\n})(function ($) {\n    ('use strict');\n\n    $.ui = $.ui || {};\n\n    $.ui.version = '1.13.2';\n\n    /*!\n     * jQuery UI Widget 1.13.2\n     * http://jqueryui.com\n     *\n     * Copyright jQuery Foundation and other contributors\n     * Released under the MIT license.\n     * http://jquery.org/license\n     */\n\n    //>>label: Widget\n    //>>group: Core\n    //>>description: Provides a factory for creating stateful widgets with a common API.\n    //>>docs: http://api.jqueryui.com/jQuery.widget/\n    //>>demos: http://jqueryui.com/widget/\n\n    // Support: jQuery 1.9.x or older\n    // $.expr[ \":\" ] is deprecated.\n    if (!$.expr.pseudos) {\n        $.expr.pseudos = $.expr[':'];\n    }\n\n    // Support: jQuery 1.11.x or older\n    // $.unique has been renamed to $.uniqueSort\n    if (!$.uniqueSort) {\n        $.uniqueSort = $.unique;\n    }\n    var widgetUuid = 0;\n    var widgetHasOwnProperty = Array.prototype.hasOwnProperty;\n    var widgetSlice = Array.prototype.slice;\n\n    $.cleanData = (function (orig) {\n        return function (elems) {\n            var events, elem, i;\n            for (i = 0; (elem = elems[i]) != null; i++) {\n                // Only trigger remove when necessary to save time\n                events = $._data(elem, 'events');\n                if (events && events.remove) {\n                    $(elem).triggerHandler('remove');\n                }\n            }\n            orig(elems);\n        };\n    })($.cleanData);\n\n    $.widget = function (name, base, prototype) {\n        var existingConstructor, constructor, basePrototype;\n\n        // ProxiedPrototype allows the provided prototype to remain unmodified\n        // so that it can be used as a mixin for multiple widgets (#8876)\n        var proxiedPrototype = {};\n\n        var namespace = name.split('.')[0];\n        // eslint-disable-next-line no-param-reassign\n        name = name.split('.')[1];\n        var fullName = namespace + '-' + name;\n\n        if (!prototype) {\n            prototype = base;\n            base = $.Widget;\n        }\n\n        if (Array.isArray(prototype)) {\n            prototype = $.extend.apply(null, [{}].concat(prototype));\n        }\n\n        // Create selector for plugin\n        $.expr.pseudos[fullName.toLowerCase()] = function (elem) {\n            return !!$.data(elem, fullName);\n        };\n\n        $[namespace] = $[namespace] || {};\n        existingConstructor = $[namespace][name];\n        constructor = $[namespace][name] = function (options, element) {\n            // Allow instantiation without \"new\" keyword\n            if (!this || !this._createWidget) {\n                return new constructor(options, element);\n            }\n\n            // Allow instantiation without initializing for simple inheritance\n            // must use \"new\" keyword (the code above always passes args)\n            if (arguments.length) {\n                this._createWidget(options, element);\n            }\n        };\n\n        // Extend with the existing constructor to carry over any static properties\n        $.extend(constructor, existingConstructor, {\n            version: prototype.version,\n\n            // Copy the object used to create the prototype in case we need to\n            // redefine the widget later\n            _proto: $.extend({}, prototype),\n\n            // Track widgets that inherit from this widget in case this widget is\n            // redefined after a widget inherits from it\n            _childConstructors: []\n        });\n\n        basePrototype = new base();\n\n        // We need to make the options hash a property directly on the new instance\n        // otherwise we'll modify the options hash on the prototype that we're\n        // inheriting from\n        basePrototype.options = $.widget.extend({}, basePrototype.options);\n        $.each(prototype, function (prop, value) {\n            if (typeof value !== 'function') {\n                proxiedPrototype[prop] = value;\n                return;\n            }\n            proxiedPrototype[prop] = (function () {\n                /**\n                 *\n                 */\n                function _super() {\n                    return base.prototype[prop].apply(this, arguments);\n                }\n\n                /**\n                 * @param args\n                 */\n                function _superApply(args) {\n                    return base.prototype[prop].apply(this, args);\n                }\n\n                return function () {\n                    var __super = this._super;\n                    var __superApply = this._superApply;\n                    var returnValue;\n\n                    this._super = _super;\n                    this._superApply = _superApply;\n\n                    returnValue = value.apply(this, arguments);\n\n                    this._super = __super;\n                    this._superApply = __superApply;\n\n                    return returnValue;\n                };\n            })();\n        });\n        constructor.prototype = $.widget.extend(\n            basePrototype,\n            {\n                // TODO: remove support for widgetEventPrefix\n                // always use the name + a colon as the prefix, e.g., draggable:start\n                // don't prefix for widgets that aren't DOM-based\n                widgetEventPrefix: existingConstructor\n                    ? basePrototype.widgetEventPrefix || name\n                    : name\n            },\n            proxiedPrototype,\n            {\n                constructor: constructor,\n                namespace: namespace,\n                widgetName: name,\n                widgetFullName: fullName\n            }\n        );\n\n        // If this widget is being redefined then we need to find all widgets that\n        // are inheriting from it and redefine all of them so that they inherit from\n        // the new version of this widget. We're essentially trying to replace one\n        // level in the prototype chain.\n        if (existingConstructor) {\n            $.each(existingConstructor._childConstructors, function (i, child) {\n                var childPrototype = child.prototype;\n\n                // Redefine the child widget using the same prototype that was\n                // originally used, but inherit from the new version of the base\n                $.widget(\n                    childPrototype.namespace + '.' + childPrototype.widgetName,\n                    constructor,\n                    child._proto\n                );\n            });\n\n            // Remove the list of existing child constructors from the old constructor\n            // so the old child constructors can be garbage collected\n            delete existingConstructor._childConstructors;\n        } else {\n            base._childConstructors.push(constructor);\n        }\n\n        $.widget.bridge(name, constructor);\n\n        return constructor;\n    };\n\n    $.widget.extend = function (target) {\n        var input = widgetSlice.call(arguments, 1);\n        var inputIndex = 0;\n        var inputLength = input.length;\n        var key;\n        var value;\n\n        for (; inputIndex < inputLength; inputIndex++) {\n            for (key in input[inputIndex]) {\n                value = input[inputIndex][key];\n                if (\n                    widgetHasOwnProperty.call(input[inputIndex], key) &&\n                    value !== undefined\n                ) {\n                    // Clone objects\n                    if ($.isPlainObject(value)) {\n                        target[key] = $.isPlainObject(target[key])\n                            ? $.widget.extend({}, target[key], value)\n                            : // Don't extend strings, arrays, etc. with objects\n                            $.widget.extend({}, value);\n\n                        // Copy everything else by reference\n                    } else {\n                        target[key] = value;\n                    }\n                }\n            }\n        }\n        return target;\n    };\n\n    $.widget.bridge = function (name, object) {\n        var fullName = object.prototype.widgetFullName || name;\n        $.fn[name] = function (options) {\n            var isMethodCall = typeof options === 'string';\n            var args = widgetSlice.call(arguments, 1);\n            var returnValue = this;\n\n            if (isMethodCall) {\n                // If this is an empty collection, we need to have the instance method\n                // return undefined instead of the jQuery instance\n                if (!this.length && options === 'instance') {\n                    returnValue = undefined;\n                } else {\n                    this.each(function () {\n                        var methodValue;\n                        var instance = $.data(this, fullName);\n\n                        if (options === 'instance') {\n                            returnValue = instance;\n                            return false;\n                        }\n\n                        if (!instance) {\n                            return $.error(\n                                'cannot call methods on ' +\n                                name +\n                                ' prior to initialization; ' +\n                                \"attempted to call method '\" +\n                                options +\n                                \"'\"\n                            );\n                        }\n\n                        if (\n                            typeof instance[options] !== 'function' ||\n                            options.charAt(0) === '_'\n                        ) {\n                            return $.error(\n                                \"no such method '\" +\n                                options +\n                                \"' for \" +\n                                name +\n                                ' widget instance'\n                            );\n                        }\n\n                        methodValue = instance[options].apply(instance, args);\n\n                        if (methodValue !== instance && methodValue !== undefined) {\n                            returnValue =\n                                methodValue && methodValue.jquery\n                                    ? returnValue.pushStack(methodValue.get())\n                                    : methodValue;\n                            return false;\n                        }\n                    });\n                }\n            } else {\n                // Allow multiple hashes to be passed on init\n                if (args.length) {\n                    options = $.widget.extend.apply(null, [options].concat(args));\n                }\n\n                this.each(function () {\n                    var instance = $.data(this, fullName);\n                    if (instance) {\n                        instance.option(options || {});\n                        if (instance._init) {\n                            instance._init();\n                        }\n                    } else {\n                        $.data(this, fullName, new object(options, this));\n                    }\n                });\n            }\n\n            return returnValue;\n        };\n    };\n\n    $.Widget = function (/* options, element */) {};\n    $.Widget._childConstructors = [];\n\n    $.Widget.prototype = {\n        widgetName: 'widget',\n        widgetEventPrefix: '',\n        defaultElement: '<div>',\n\n        options: {\n            classes: {},\n            disabled: false,\n\n            // Callbacks\n            create: null\n        },\n\n        _createWidget: function (options, element) {\n            element = $(element || this.defaultElement || this)[0];\n            this.element = $(element);\n            this.uuid = widgetUuid++;\n            this.eventNamespace = '.' + this.widgetName + this.uuid;\n\n            this.bindings = $();\n            this.hoverable = $();\n            this.focusable = $();\n            this.classesElementLookup = {};\n\n            if (element !== this) {\n                $.data(element, this.widgetFullName, this);\n                this._on(true, this.element, {\n                    remove: function (event) {\n                        if (event.target === element) {\n                            this.destroy();\n                        }\n                    }\n                });\n                this.document = $(\n                    element.style\n                        ? // Element within the document\n                        element.ownerDocument\n                        : // Element is window or document\n                        element.document || element\n                );\n                this.window = $(\n                    this.document[0].defaultView || this.document[0].parentWindow\n                );\n            }\n\n            this.options = $.widget.extend(\n                {},\n                this.options,\n                this._getCreateOptions(),\n                options\n            );\n\n            this._create();\n\n            if (this.options.disabled) {\n                this._setOptionDisabled(this.options.disabled);\n            }\n\n            this._trigger('create', null, this._getCreateEventData());\n            this._init();\n        },\n\n        _getCreateOptions: function () {\n            return {};\n        },\n\n        _getCreateEventData: $.noop,\n\n        _create: $.noop,\n\n        _init: $.noop,\n\n        destroy: function () {\n            var that = this;\n\n            this._destroy();\n            $.each(this.classesElementLookup, function (key, value) {\n                that._removeClass(value, key);\n            });\n\n            // We can probably remove the unbind calls in 2.0\n            // all event bindings should go through this._on()\n            this.element.off(this.eventNamespace).removeData(this.widgetFullName);\n            this.widget().off(this.eventNamespace).removeAttr('aria-disabled');\n\n            // Clean up events and states\n            this.bindings.off(this.eventNamespace);\n        },\n\n        _destroy: $.noop,\n\n        widget: function () {\n            return this.element;\n        },\n\n        option: function (key, value) {\n            var options = key;\n            var parts;\n            var curOption;\n            var i;\n\n            if (arguments.length === 0) {\n                // Don't return a reference to the internal hash\n                return $.widget.extend({}, this.options);\n            }\n\n            if (typeof key === 'string') {\n                // Handle nested keys, e.g., \"foo.bar\" => { foo: { bar: ___ } }\n                options = {};\n                parts = key.split('.');\n                key = parts.shift();\n                if (parts.length) {\n                    curOption = options[key] = $.widget.extend({}, this.options[key]);\n                    for (i = 0; i < parts.length - 1; i++) {\n                        curOption[parts[i]] = curOption[parts[i]] || {};\n                        curOption = curOption[parts[i]];\n                    }\n                    key = parts.pop();\n                    if (arguments.length === 1) {\n                        return curOption[key] === undefined ? null : curOption[key];\n                    }\n                    curOption[key] = value;\n                } else {\n                    if (arguments.length === 1) {\n                        return this.options[key] === undefined ? null : this.options[key];\n                    }\n                    options[key] = value;\n                }\n            }\n\n            this._setOptions(options);\n\n            return this;\n        },\n\n        _setOptions: function (options) {\n            var key;\n\n            for (key in options) {\n                this._setOption(key, options[key]);\n            }\n\n            return this;\n        },\n\n        _setOption: function (key, value) {\n            if (key === 'classes') {\n                this._setOptionClasses(value);\n            }\n\n            this.options[key] = value;\n\n            if (key === 'disabled') {\n                this._setOptionDisabled(value);\n            }\n\n            return this;\n        },\n\n        _setOptionClasses: function (value) {\n            var classKey, elements, currentElements;\n\n            for (classKey in value) {\n                currentElements = this.classesElementLookup[classKey];\n                if (\n                    value[classKey] === this.options.classes[classKey] ||\n                    !currentElements ||\n                    !currentElements.length\n                ) {\n                    continue;\n                }\n\n                // We are doing this to create a new jQuery object because the _removeClass() call\n                // on the next line is going to destroy the reference to the current elements being\n                // tracked. We need to save a copy of this collection so that we can add the new classes\n                // below.\n                elements = $(currentElements.get());\n                this._removeClass(currentElements, classKey);\n\n                // We don't use _addClass() here, because that uses this.options.classes\n                // for generating the string of classes. We want to use the value passed in from\n                // _setOption(), this is the new value of the classes option which was passed to\n                // _setOption(). We pass this value directly to _classes().\n                elements.addClass(\n                    this._classes({\n                        element: elements,\n                        keys: classKey,\n                        classes: value,\n                        add: true\n                    })\n                );\n            }\n        },\n\n        _setOptionDisabled: function (value) {\n            this._toggleClass(\n                this.widget(),\n                this.widgetFullName + '-disabled',\n                null,\n                !!value\n            );\n\n            // If the widget is becoming disabled, then nothing is interactive\n            if (value) {\n                this._removeClass(this.hoverable, null, 'ui-state-hover');\n                this._removeClass(this.focusable, null, 'ui-state-focus');\n            }\n        },\n\n        enable: function () {\n            return this._setOptions({ disabled: false });\n        },\n\n        disable: function () {\n            return this._setOptions({ disabled: true });\n        },\n\n        _classes: function (options) {\n            var full = [];\n            var that = this;\n\n            options = $.extend(\n                {\n                    element: this.element,\n                    classes: this.options.classes || {}\n                },\n                options\n            );\n\n            /**\n             *\n             */\n            function bindRemoveEvent() {\n                var nodesToBind = [];\n\n                options.element.each(function (_, element) {\n                    var isTracked = $.map(that.classesElementLookup, function (elements) {\n                        return elements;\n                    }).some(function (elements) {\n                        return elements.is(element);\n                    });\n\n                    if (!isTracked) {\n                        nodesToBind.push(element);\n                    }\n                });\n\n                that._on($(nodesToBind), {\n                    remove: '_untrackClassesElement'\n                });\n            }\n\n            /**\n             * @param classes\n             * @param checkOption\n             */\n            function processClassString(classes, checkOption) {\n                var current, i;\n                for (i = 0; i < classes.length; i++) {\n                    current = that.classesElementLookup[classes[i]] || $();\n                    if (options.add) {\n                        bindRemoveEvent();\n                        current = $(\n                            $.uniqueSort(current.get().concat(options.element.get()))\n                        );\n                    } else {\n                        current = $(current.not(options.element).get());\n                    }\n                    that.classesElementLookup[classes[i]] = current;\n                    full.push(classes[i]);\n                    if (checkOption && options.classes[classes[i]]) {\n                        full.push(options.classes[classes[i]]);\n                    }\n                }\n            }\n\n            if (options.keys) {\n                processClassString(options.keys.match(/\\S+/g) || [], true);\n            }\n            if (options.extra) {\n                processClassString(options.extra.match(/\\S+/g) || []);\n            }\n\n            return full.join(' ');\n        },\n\n        _untrackClassesElement: function (event) {\n            var that = this;\n            $.each(that.classesElementLookup, function (key, value) {\n                if ($.inArray(event.target, value) !== -1) {\n                    that.classesElementLookup[key] = $(value.not(event.target).get());\n                }\n            });\n\n            this._off($(event.target));\n        },\n\n        _removeClass: function (element, keys, extra) {\n            return this._toggleClass(element, keys, extra, false);\n        },\n\n        _addClass: function (element, keys, extra) {\n            return this._toggleClass(element, keys, extra, true);\n        },\n\n        _toggleClass: function (element, keys, extra, add) {\n            add = typeof add === 'boolean' ? add : extra;\n            var shift = typeof element === 'string' || element === null,\n                options = {\n                    extra: shift ? keys : extra,\n                    keys: shift ? element : keys,\n                    element: shift ? this.element : element,\n                    add: add\n                };\n            options.element.toggleClass(this._classes(options), add);\n            return this;\n        },\n\n        _on: function (suppressDisabledCheck, element, handlers) {\n            var delegateElement;\n            var instance = this;\n\n            // No suppressDisabledCheck flag, shuffle arguments\n            if (typeof suppressDisabledCheck !== 'boolean') {\n                handlers = element;\n                element = suppressDisabledCheck;\n                suppressDisabledCheck = false;\n            }\n\n            // No element argument, shuffle and use this.element\n            if (!handlers) {\n                handlers = element;\n                element = this.element;\n                delegateElement = this.widget();\n            } else {\n                element = delegateElement = $(element);\n                this.bindings = this.bindings.add(element);\n            }\n\n            $.each(handlers, function (event, handler) {\n                /**\n                 *\n                 */\n                function handlerProxy() {\n                    // Allow widgets to customize the disabled handling\n                    // - disabled as an array instead of boolean\n                    // - disabled class as method for disabling individual parts\n                    if (\n                        !suppressDisabledCheck &&\n                        (instance.options.disabled === true ||\n                            $(this).hasClass('ui-state-disabled'))\n                    ) {\n                        return;\n                    }\n                    return (\n                        typeof handler === 'string' ? instance[handler] : handler\n                    ).apply(instance, arguments);\n                }\n\n                // Copy the guid so direct unbinding works\n                if (typeof handler !== 'string') {\n                    handlerProxy.guid = handler.guid =\n                        handler.guid || handlerProxy.guid || $.guid++;\n                }\n\n                var match = event.match(/^([\\w:-]*)\\s*(.*)$/);\n                var eventName = match[1] + instance.eventNamespace;\n                var selector = match[2];\n\n                if (selector) {\n                    delegateElement.on(eventName, selector, handlerProxy);\n                } else {\n                    element.on(eventName, handlerProxy);\n                }\n            });\n        },\n\n        _off: function (element, eventName) {\n            eventName =\n                (eventName || '').split(' ').join(this.eventNamespace + ' ') +\n                this.eventNamespace;\n            element.off(eventName);\n\n            // Clear the stack to avoid memory leaks (#10056)\n            this.bindings = $(this.bindings.not(element).get());\n            this.focusable = $(this.focusable.not(element).get());\n            this.hoverable = $(this.hoverable.not(element).get());\n        },\n\n        _delay: function (handler, delay) {\n            /**\n             *\n             */\n            function handlerProxy() {\n                return (\n                    typeof handler === 'string' ? instance[handler] : handler\n                ).apply(instance, arguments);\n            }\n            var instance = this;\n            return setTimeout(handlerProxy, delay || 0);\n        },\n\n        _hoverable: function (element) {\n            this.hoverable = this.hoverable.add(element);\n            this._on(element, {\n                mouseenter: function (event) {\n                    this._addClass($(event.currentTarget), null, 'ui-state-hover');\n                },\n                mouseleave: function (event) {\n                    this._removeClass($(event.currentTarget), null, 'ui-state-hover');\n                }\n            });\n        },\n\n        _focusable: function (element) {\n            this.focusable = this.focusable.add(element);\n            this._on(element, {\n                focusin: function (event) {\n                    this._addClass($(event.currentTarget), null, 'ui-state-focus');\n                },\n                focusout: function (event) {\n                    this._removeClass($(event.currentTarget), null, 'ui-state-focus');\n                }\n            });\n        },\n\n        _trigger: function (type, event, data) {\n            var prop, orig;\n            var callback = this.options[type];\n\n            data = data || {};\n            event = $.Event(event);\n            event.type = (\n                type === this.widgetEventPrefix ? type : this.widgetEventPrefix + type\n            ).toLowerCase();\n\n            // The original event may come from any element\n            // so we need to reset the target on the new event\n            event.target = this.element[0];\n\n            // Copy original event properties over to the new event\n            orig = event.originalEvent;\n            if (orig) {\n                for (prop in orig) {\n                    if (!(prop in event)) {\n                        event[prop] = orig[prop];\n                    }\n                }\n            }\n\n            this.element.trigger(event, data);\n            return !(\n                (typeof callback === 'function' &&\n                    callback.apply(this.element[0], [event].concat(data)) === false) ||\n                event.isDefaultPrevented()\n            );\n        }\n    };\n\n    $.each({ show: 'fadeIn', hide: 'fadeOut' }, function (method, defaultEffect) {\n        $.Widget.prototype['_' + method] = function (element, options, callback) {\n            if (typeof options === 'string') {\n                options = { effect: options };\n            }\n\n            var hasOptions;\n            var effectName = !options\n                ? method\n                : options === true || typeof options === 'number'\n                    ? defaultEffect\n                    : options.effect || defaultEffect;\n\n            options = options || {};\n            if (typeof options === 'number') {\n                options = { duration: options };\n            } else if (options === true) {\n                options = {};\n            }\n\n            hasOptions = !$.isEmptyObject(options);\n            options.complete = callback;\n\n            if (options.delay) {\n                element.delay(options.delay);\n            }\n\n            if (hasOptions && $.effects && $.effects.effect[effectName]) {\n                element[method](options);\n            } else if (effectName !== method && element[effectName]) {\n                element[effectName](options.duration, options.easing, callback);\n            } else {\n                element.queue(function (next) {\n                    $(this)[method]();\n                    if (callback) {\n                        callback.call(element[0]);\n                    }\n                    next();\n                });\n            }\n        };\n    });\n});\n","jquery/fileUploader/vendor/blueimp-tmpl/js/runtime.js":"/*\n * JavaScript Templates Runtime\n * https://github.com/blueimp/JavaScript-Templates\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define */\n\n/* eslint-disable strict */\n\n;(function ($) {\n  'use strict'\n  var tmpl = function (id, data) {\n    var f = tmpl.cache[id]\n    return data\n      ? f(data, tmpl)\n      : function (data) {\n          return f(data, tmpl)\n        }\n  }\n  tmpl.cache = {}\n  tmpl.encReg = /[<>&\"'\\x00]/g // eslint-disable-line no-control-regex\n  tmpl.encMap = {\n    '<': '&lt;',\n    '>': '&gt;',\n    '&': '&amp;',\n    '\"': '&quot;',\n    \"'\": '&#39;'\n  }\n  tmpl.encode = function (s) {\n    // eslint-disable-next-line eqeqeq\n    return (s == null ? '' : '' + s).replace(tmpl.encReg, function (c) {\n      return tmpl.encMap[c] || ''\n    })\n  }\n  if (typeof define === 'function' && define.amd) {\n    define(function () {\n      return tmpl\n    })\n  } else if (typeof module === 'object' && module.exports) {\n    module.exports = tmpl\n  } else {\n    $.tmpl = tmpl\n  }\n})(this)\n","jquery/fileUploader/vendor/blueimp-tmpl/js/tmpl.js":"/*\n * JavaScript Templates\n * https://github.com/blueimp/JavaScript-Templates\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n *\n * Inspired by John Resig's JavaScript Micro-Templating:\n * http://ejohn.org/blog/javascript-micro-templating/\n */\n\n/* global define */\n\n/* eslint-disable strict */\n\n;(function ($) {\n  'use strict'\n  var tmpl = function (str, data) {\n    var f = !/[^\\w\\-.:]/.test(str)\n      ? (tmpl.cache[str] = tmpl.cache[str] || tmpl(tmpl.load(str)))\n      : new Function( // eslint-disable-line no-new-func\n          tmpl.arg + ',tmpl',\n          'var _e=tmpl.encode' +\n            tmpl.helper +\n            \",_s='\" +\n            str.replace(tmpl.regexp, tmpl.func) +\n            \"';return _s;\"\n        )\n    return data\n      ? f(data, tmpl)\n      : function (data) {\n          return f(data, tmpl)\n        }\n  }\n  tmpl.cache = {}\n  tmpl.load = function (id) {\n    return document.getElementById(id).innerHTML\n  }\n  tmpl.regexp = /([\\s'\\\\])(?!(?:[^{]|\\{(?!%))*%\\})|(?:\\{%(=|#)([\\s\\S]+?)%\\})|(\\{%)|(%\\})/g\n  tmpl.func = function (s, p1, p2, p3, p4, p5) {\n    if (p1) {\n      // whitespace, quote and backspace in HTML context\n      return (\n        {\n          '\\n': '\\\\n',\n          '\\r': '\\\\r',\n          '\\t': '\\\\t',\n          ' ': ' '\n        }[p1] || '\\\\' + p1\n      )\n    }\n    if (p2) {\n      // interpolation: {%=prop%}, or unescaped: {%#prop%}\n      if (p2 === '=') {\n        return \"'+_e(\" + p3 + \")+'\"\n      }\n      return \"'+(\" + p3 + \"==null?'':\" + p3 + \")+'\"\n    }\n    if (p4) {\n      // evaluation start tag: {%\n      return \"';\"\n    }\n    if (p5) {\n      // evaluation end tag: %}\n      return \"_s+='\"\n    }\n  }\n  tmpl.encReg = /[<>&\"'\\x00]/g // eslint-disable-line no-control-regex\n  tmpl.encMap = {\n    '<': '&lt;',\n    '>': '&gt;',\n    '&': '&amp;',\n    '\"': '&quot;',\n    \"'\": '&#39;'\n  }\n  tmpl.encode = function (s) {\n    // eslint-disable-next-line eqeqeq\n    return (s == null ? '' : '' + s).replace(tmpl.encReg, function (c) {\n      return tmpl.encMap[c] || ''\n    })\n  }\n  tmpl.arg = 'o'\n  tmpl.helper =\n    \",print=function(s,e){_s+=e?(s==null?'':s):_e(s);}\" +\n    ',include=function(s,d){_s+=tmpl(s,d);}'\n  if (typeof define === 'function' && define.amd) {\n    define(function () {\n      return tmpl\n    })\n  } else if (typeof module === 'object' && module.exports) {\n    module.exports = tmpl\n  } else {\n    $.tmpl = tmpl\n  }\n})(this)\n","jquery/fileUploader/vendor/blueimp-tmpl/js/compile.js":"#!/usr/bin/env node\n/*\n * JavaScript Templates Compiler\n * https://github.com/blueimp/JavaScript-Templates\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* eslint-disable strict */\n/* eslint-disable no-console */\n\n;(function () {\n  'use strict'\n  var path = require('path')\n  var tmpl = require(path.join(__dirname, 'tmpl.js'))\n  var fs = require('fs')\n  // Retrieve the content of the minimal runtime:\n  var runtime = fs.readFileSync(path.join(__dirname, 'runtime.js'), 'utf8')\n  // A regular expression to parse templates from script tags in a HTML page:\n  var regexp = /<script( id=\"([\\w-]+)\")? type=\"text\\/x-tmpl\"( id=\"([\\w-]+)\")?>([\\s\\S]+?)<\\/script>/gi\n  // A regular expression to match the helper function names:\n  var helperRegexp = new RegExp(\n    tmpl.helper.match(/\\w+(?=\\s*=\\s*function\\s*\\()/g).join('\\\\s*\\\\(|') +\n      '\\\\s*\\\\('\n  )\n  // A list to store the function bodies:\n  var list = []\n  var code\n  // Extend the Templating engine with a print method for the generated functions:\n  tmpl.print = function (str) {\n    // Only add helper functions if they are used inside of the template:\n    var helper = helperRegexp.test(str) ? tmpl.helper : ''\n    var body = str.replace(tmpl.regexp, tmpl.func)\n    if (helper || /_e\\s*\\(/.test(body)) {\n      helper = '_e=tmpl.encode' + helper + ','\n    }\n    return (\n      'function(' +\n      tmpl.arg +\n      ',tmpl){' +\n      ('var ' + helper + \"_s='\" + body + \"';return _s;\")\n        .split(\"_s+='';\")\n        .join('') +\n      '}'\n    )\n  }\n  // Loop through the command line arguments:\n  process.argv.forEach(function (file, index) {\n    var listLength = list.length\n    var stats\n    var content\n    var result\n    var id\n    // Skip the first two arguments, which are \"node\" and the script:\n    if (index > 1) {\n      stats = fs.statSync(file)\n      if (!stats.isFile()) {\n        console.error(file + ' is not a file.')\n        return\n      }\n      content = fs.readFileSync(file, 'utf8')\n      // eslint-disable-next-line no-constant-condition\n      while (true) {\n        // Find templates in script tags:\n        result = regexp.exec(content)\n        if (!result) {\n          break\n        }\n        id = result[2] || result[4]\n        list.push(\"'\" + id + \"':\" + tmpl.print(result[5]))\n      }\n      if (listLength === list.length) {\n        // No template script tags found, use the complete content:\n        id = path.basename(file, path.extname(file))\n        list.push(\"'\" + id + \"':\" + tmpl.print(content))\n      }\n    }\n  })\n  if (!list.length) {\n    console.error('Missing input file.')\n    return\n  }\n  // Combine the generated functions as cache of the minimal runtime:\n  code = runtime.replace('{}', '{' + list.join(',') + '}')\n  // Print the resulting code to the console output:\n  console.log(code)\n})()\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif-map.js":"/*\n * JavaScript Load Image Exif Map\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Exif tags mapping based on\n * https://github.com/jseidelin/exif-js\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'), require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var ExifMapProto = loadImage.ExifMap.prototype\n\n  ExifMapProto.tags = {\n    // =================\n    // TIFF tags (IFD0):\n    // =================\n    0x0100: 'ImageWidth',\n    0x0101: 'ImageHeight',\n    0x0102: 'BitsPerSample',\n    0x0103: 'Compression',\n    0x0106: 'PhotometricInterpretation',\n    0x0112: 'Orientation',\n    0x0115: 'SamplesPerPixel',\n    0x011c: 'PlanarConfiguration',\n    0x0212: 'YCbCrSubSampling',\n    0x0213: 'YCbCrPositioning',\n    0x011a: 'XResolution',\n    0x011b: 'YResolution',\n    0x0128: 'ResolutionUnit',\n    0x0111: 'StripOffsets',\n    0x0116: 'RowsPerStrip',\n    0x0117: 'StripByteCounts',\n    0x0201: 'JPEGInterchangeFormat',\n    0x0202: 'JPEGInterchangeFormatLength',\n    0x012d: 'TransferFunction',\n    0x013e: 'WhitePoint',\n    0x013f: 'PrimaryChromaticities',\n    0x0211: 'YCbCrCoefficients',\n    0x0214: 'ReferenceBlackWhite',\n    0x0132: 'DateTime',\n    0x010e: 'ImageDescription',\n    0x010f: 'Make',\n    0x0110: 'Model',\n    0x0131: 'Software',\n    0x013b: 'Artist',\n    0x8298: 'Copyright',\n    0x8769: {\n      // ExifIFDPointer\n      0x9000: 'ExifVersion', // EXIF version\n      0xa000: 'FlashpixVersion', // Flashpix format version\n      0xa001: 'ColorSpace', // Color space information tag\n      0xa002: 'PixelXDimension', // Valid width of meaningful image\n      0xa003: 'PixelYDimension', // Valid height of meaningful image\n      0xa500: 'Gamma',\n      0x9101: 'ComponentsConfiguration', // Information about channels\n      0x9102: 'CompressedBitsPerPixel', // Compressed bits per pixel\n      0x927c: 'MakerNote', // Any desired information written by the manufacturer\n      0x9286: 'UserComment', // Comments by user\n      0xa004: 'RelatedSoundFile', // Name of related sound file\n      0x9003: 'DateTimeOriginal', // Date and time when the original image was generated\n      0x9004: 'DateTimeDigitized', // Date and time when the image was stored digitally\n      0x9010: 'OffsetTime', // Time zone when the image file was last changed\n      0x9011: 'OffsetTimeOriginal', // Time zone when the image was stored digitally\n      0x9012: 'OffsetTimeDigitized', // Time zone when the image was stored digitally\n      0x9290: 'SubSecTime', // Fractions of seconds for DateTime\n      0x9291: 'SubSecTimeOriginal', // Fractions of seconds for DateTimeOriginal\n      0x9292: 'SubSecTimeDigitized', // Fractions of seconds for DateTimeDigitized\n      0x829a: 'ExposureTime', // Exposure time (in seconds)\n      0x829d: 'FNumber',\n      0x8822: 'ExposureProgram', // Exposure program\n      0x8824: 'SpectralSensitivity', // Spectral sensitivity\n      0x8827: 'PhotographicSensitivity', // EXIF 2.3, ISOSpeedRatings in EXIF 2.2\n      0x8828: 'OECF', // Optoelectric conversion factor\n      0x8830: 'SensitivityType',\n      0x8831: 'StandardOutputSensitivity',\n      0x8832: 'RecommendedExposureIndex',\n      0x8833: 'ISOSpeed',\n      0x8834: 'ISOSpeedLatitudeyyy',\n      0x8835: 'ISOSpeedLatitudezzz',\n      0x9201: 'ShutterSpeedValue', // Shutter speed\n      0x9202: 'ApertureValue', // Lens aperture\n      0x9203: 'BrightnessValue', // Value of brightness\n      0x9204: 'ExposureBias', // Exposure bias\n      0x9205: 'MaxApertureValue', // Smallest F number of lens\n      0x9206: 'SubjectDistance', // Distance to subject in meters\n      0x9207: 'MeteringMode', // Metering mode\n      0x9208: 'LightSource', // Kind of light source\n      0x9209: 'Flash', // Flash status\n      0x9214: 'SubjectArea', // Location and area of main subject\n      0x920a: 'FocalLength', // Focal length of the lens in mm\n      0xa20b: 'FlashEnergy', // Strobe energy in BCPS\n      0xa20c: 'SpatialFrequencyResponse',\n      0xa20e: 'FocalPlaneXResolution', // Number of pixels in width direction per FPRUnit\n      0xa20f: 'FocalPlaneYResolution', // Number of pixels in height direction per FPRUnit\n      0xa210: 'FocalPlaneResolutionUnit', // Unit for measuring the focal plane resolution\n      0xa214: 'SubjectLocation', // Location of subject in image\n      0xa215: 'ExposureIndex', // Exposure index selected on camera\n      0xa217: 'SensingMethod', // Image sensor type\n      0xa300: 'FileSource', // Image source (3 == DSC)\n      0xa301: 'SceneType', // Scene type (1 == directly photographed)\n      0xa302: 'CFAPattern', // Color filter array geometric pattern\n      0xa401: 'CustomRendered', // Special processing\n      0xa402: 'ExposureMode', // Exposure mode\n      0xa403: 'WhiteBalance', // 1 = auto white balance, 2 = manual\n      0xa404: 'DigitalZoomRatio', // Digital zoom ratio\n      0xa405: 'FocalLengthIn35mmFilm',\n      0xa406: 'SceneCaptureType', // Type of scene\n      0xa407: 'GainControl', // Degree of overall image gain adjustment\n      0xa408: 'Contrast', // Direction of contrast processing applied by camera\n      0xa409: 'Saturation', // Direction of saturation processing applied by camera\n      0xa40a: 'Sharpness', // Direction of sharpness processing applied by camera\n      0xa40b: 'DeviceSettingDescription',\n      0xa40c: 'SubjectDistanceRange', // Distance to subject\n      0xa420: 'ImageUniqueID', // Identifier assigned uniquely to each image\n      0xa430: 'CameraOwnerName',\n      0xa431: 'BodySerialNumber',\n      0xa432: 'LensSpecification',\n      0xa433: 'LensMake',\n      0xa434: 'LensModel',\n      0xa435: 'LensSerialNumber'\n    },\n    0x8825: {\n      // GPSInfoIFDPointer\n      0x0000: 'GPSVersionID',\n      0x0001: 'GPSLatitudeRef',\n      0x0002: 'GPSLatitude',\n      0x0003: 'GPSLongitudeRef',\n      0x0004: 'GPSLongitude',\n      0x0005: 'GPSAltitudeRef',\n      0x0006: 'GPSAltitude',\n      0x0007: 'GPSTimeStamp',\n      0x0008: 'GPSSatellites',\n      0x0009: 'GPSStatus',\n      0x000a: 'GPSMeasureMode',\n      0x000b: 'GPSDOP',\n      0x000c: 'GPSSpeedRef',\n      0x000d: 'GPSSpeed',\n      0x000e: 'GPSTrackRef',\n      0x000f: 'GPSTrack',\n      0x0010: 'GPSImgDirectionRef',\n      0x0011: 'GPSImgDirection',\n      0x0012: 'GPSMapDatum',\n      0x0013: 'GPSDestLatitudeRef',\n      0x0014: 'GPSDestLatitude',\n      0x0015: 'GPSDestLongitudeRef',\n      0x0016: 'GPSDestLongitude',\n      0x0017: 'GPSDestBearingRef',\n      0x0018: 'GPSDestBearing',\n      0x0019: 'GPSDestDistanceRef',\n      0x001a: 'GPSDestDistance',\n      0x001b: 'GPSProcessingMethod',\n      0x001c: 'GPSAreaInformation',\n      0x001d: 'GPSDateStamp',\n      0x001e: 'GPSDifferential',\n      0x001f: 'GPSHPositioningError'\n    },\n    0xa005: {\n      // InteroperabilityIFDPointer\n      0x0001: 'InteroperabilityIndex'\n    }\n  }\n\n  // IFD1 directory can contain any IFD0 tags:\n  ExifMapProto.tags.ifd1 = ExifMapProto.tags\n\n  ExifMapProto.stringValues = {\n    ExposureProgram: {\n      0: 'Undefined',\n      1: 'Manual',\n      2: 'Normal program',\n      3: 'Aperture priority',\n      4: 'Shutter priority',\n      5: 'Creative program',\n      6: 'Action program',\n      7: 'Portrait mode',\n      8: 'Landscape mode'\n    },\n    MeteringMode: {\n      0: 'Unknown',\n      1: 'Average',\n      2: 'CenterWeightedAverage',\n      3: 'Spot',\n      4: 'MultiSpot',\n      5: 'Pattern',\n      6: 'Partial',\n      255: 'Other'\n    },\n    LightSource: {\n      0: 'Unknown',\n      1: 'Daylight',\n      2: 'Fluorescent',\n      3: 'Tungsten (incandescent light)',\n      4: 'Flash',\n      9: 'Fine weather',\n      10: 'Cloudy weather',\n      11: 'Shade',\n      12: 'Daylight fluorescent (D 5700 - 7100K)',\n      13: 'Day white fluorescent (N 4600 - 5400K)',\n      14: 'Cool white fluorescent (W 3900 - 4500K)',\n      15: 'White fluorescent (WW 3200 - 3700K)',\n      17: 'Standard light A',\n      18: 'Standard light B',\n      19: 'Standard light C',\n      20: 'D55',\n      21: 'D65',\n      22: 'D75',\n      23: 'D50',\n      24: 'ISO studio tungsten',\n      255: 'Other'\n    },\n    Flash: {\n      0x0000: 'Flash did not fire',\n      0x0001: 'Flash fired',\n      0x0005: 'Strobe return light not detected',\n      0x0007: 'Strobe return light detected',\n      0x0009: 'Flash fired, compulsory flash mode',\n      0x000d: 'Flash fired, compulsory flash mode, return light not detected',\n      0x000f: 'Flash fired, compulsory flash mode, return light detected',\n      0x0010: 'Flash did not fire, compulsory flash mode',\n      0x0018: 'Flash did not fire, auto mode',\n      0x0019: 'Flash fired, auto mode',\n      0x001d: 'Flash fired, auto mode, return light not detected',\n      0x001f: 'Flash fired, auto mode, return light detected',\n      0x0020: 'No flash function',\n      0x0041: 'Flash fired, red-eye reduction mode',\n      0x0045: 'Flash fired, red-eye reduction mode, return light not detected',\n      0x0047: 'Flash fired, red-eye reduction mode, return light detected',\n      0x0049: 'Flash fired, compulsory flash mode, red-eye reduction mode',\n      0x004d: 'Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected',\n      0x004f: 'Flash fired, compulsory flash mode, red-eye reduction mode, return light detected',\n      0x0059: 'Flash fired, auto mode, red-eye reduction mode',\n      0x005d: 'Flash fired, auto mode, return light not detected, red-eye reduction mode',\n      0x005f: 'Flash fired, auto mode, return light detected, red-eye reduction mode'\n    },\n    SensingMethod: {\n      1: 'Undefined',\n      2: 'One-chip color area sensor',\n      3: 'Two-chip color area sensor',\n      4: 'Three-chip color area sensor',\n      5: 'Color sequential area sensor',\n      7: 'Trilinear sensor',\n      8: 'Color sequential linear sensor'\n    },\n    SceneCaptureType: {\n      0: 'Standard',\n      1: 'Landscape',\n      2: 'Portrait',\n      3: 'Night scene'\n    },\n    SceneType: {\n      1: 'Directly photographed'\n    },\n    CustomRendered: {\n      0: 'Normal process',\n      1: 'Custom process'\n    },\n    WhiteBalance: {\n      0: 'Auto white balance',\n      1: 'Manual white balance'\n    },\n    GainControl: {\n      0: 'None',\n      1: 'Low gain up',\n      2: 'High gain up',\n      3: 'Low gain down',\n      4: 'High gain down'\n    },\n    Contrast: {\n      0: 'Normal',\n      1: 'Soft',\n      2: 'Hard'\n    },\n    Saturation: {\n      0: 'Normal',\n      1: 'Low saturation',\n      2: 'High saturation'\n    },\n    Sharpness: {\n      0: 'Normal',\n      1: 'Soft',\n      2: 'Hard'\n    },\n    SubjectDistanceRange: {\n      0: 'Unknown',\n      1: 'Macro',\n      2: 'Close view',\n      3: 'Distant view'\n    },\n    FileSource: {\n      3: 'DSC'\n    },\n    ComponentsConfiguration: {\n      0: '',\n      1: 'Y',\n      2: 'Cb',\n      3: 'Cr',\n      4: 'R',\n      5: 'G',\n      6: 'B'\n    },\n    Orientation: {\n      1: 'Original',\n      2: 'Horizontal flip',\n      3: 'Rotate 180\u00b0 CCW',\n      4: 'Vertical flip',\n      5: 'Vertical flip + Rotate 90\u00b0 CW',\n      6: 'Rotate 90\u00b0 CW',\n      7: 'Horizontal flip + Rotate 90\u00b0 CW',\n      8: 'Rotate 90\u00b0 CCW'\n    }\n  }\n\n  ExifMapProto.getText = function (name) {\n    var value = this.get(name)\n    switch (name) {\n      case 'LightSource':\n      case 'Flash':\n      case 'MeteringMode':\n      case 'ExposureProgram':\n      case 'SensingMethod':\n      case 'SceneCaptureType':\n      case 'SceneType':\n      case 'CustomRendered':\n      case 'WhiteBalance':\n      case 'GainControl':\n      case 'Contrast':\n      case 'Saturation':\n      case 'Sharpness':\n      case 'SubjectDistanceRange':\n      case 'FileSource':\n      case 'Orientation':\n        return this.stringValues[name][value]\n      case 'ExifVersion':\n      case 'FlashpixVersion':\n        if (!value) return\n        return String.fromCharCode(value[0], value[1], value[2], value[3])\n      case 'ComponentsConfiguration':\n        if (!value) return\n        return (\n          this.stringValues[name][value[0]] +\n          this.stringValues[name][value[1]] +\n          this.stringValues[name][value[2]] +\n          this.stringValues[name][value[3]]\n        )\n      case 'GPSVersionID':\n        if (!value) return\n        return value[0] + '.' + value[1] + '.' + value[2] + '.' + value[3]\n    }\n    return String(value)\n  }\n\n  ExifMapProto.getAll = function () {\n    var map = {}\n    var prop\n    var obj\n    var name\n    for (prop in this) {\n      if (Object.prototype.hasOwnProperty.call(this, prop)) {\n        obj = this[prop]\n        if (obj && obj.getAll) {\n          map[this.ifds[prop].name] = obj.getAll()\n        } else {\n          name = this.tags[prop]\n          if (name) map[name] = this.getText(name)\n        }\n      }\n    }\n    return map\n  }\n\n  ExifMapProto.getName = function (tagCode) {\n    var name = this.tags[tagCode]\n    if (typeof name === 'object') return this.ifds[tagCode].name\n    return name\n  }\n\n  // Extend the map of tag names to tag codes:\n  ;(function () {\n    var tags = ExifMapProto.tags\n    var prop\n    var ifd\n    var subTags\n    // Map the tag names to tags:\n    for (prop in tags) {\n      if (Object.prototype.hasOwnProperty.call(tags, prop)) {\n        ifd = ExifMapProto.ifds[prop]\n        if (ifd) {\n          subTags = tags[prop]\n          for (prop in subTags) {\n            if (Object.prototype.hasOwnProperty.call(subTags, prop)) {\n              ifd.map[subTags[prop]] = Number(prop)\n            }\n          }\n        } else {\n          ExifMapProto.map[tags[prop]] = Number(prop)\n        }\n      }\n    }\n  })()\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc.js":"/*\n * JavaScript Load Image IPTC Parser\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * Copyright 2018, Dave Bevan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require, DataView */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'), require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  /**\n   * IPTC tag map\n   *\n   * @name IptcMap\n   * @class\n   */\n  function IptcMap() {}\n\n  IptcMap.prototype.map = {\n    ObjectName: 5\n  }\n\n  IptcMap.prototype.types = {\n    0: 'Uint16', // ApplicationRecordVersion\n    200: 'Uint16', // ObjectPreviewFileFormat\n    201: 'Uint16', // ObjectPreviewFileVersion\n    202: 'binary' // ObjectPreviewData\n  }\n\n  /**\n   * Retrieves IPTC tag value\n   *\n   * @param {number|string} id IPTC tag code or name\n   * @returns {object} IPTC tag value\n   */\n  IptcMap.prototype.get = function (id) {\n    return this[id] || this[this.map[id]]\n  }\n\n  /**\n   * Retrieves string for the given DataView and range\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Offset start\n   * @param {number} length Offset length\n   * @returns {string} String value\n   */\n  function getStringValue(dataView, offset, length) {\n    var outstr = ''\n    var end = offset + length\n    for (var n = offset; n < end; n += 1) {\n      outstr += String.fromCharCode(dataView.getUint8(n))\n    }\n    return outstr\n  }\n\n  /**\n   * Retrieves tag value for the given DataView and range\n   *\n   * @param {number} tagCode tag code\n   * @param {IptcMap} map IPTC tag map\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Range start\n   * @param {number} length Range length\n   * @returns {object} Tag value\n   */\n  function getTagValue(tagCode, map, dataView, offset, length) {\n    if (map.types[tagCode] === 'binary') {\n      return new Blob([dataView.buffer.slice(offset, offset + length)])\n    }\n    if (map.types[tagCode] === 'Uint16') {\n      return dataView.getUint16(offset)\n    }\n    return getStringValue(dataView, offset, length)\n  }\n\n  /**\n   * Combines IPTC value with existing ones.\n   *\n   * @param {object} value Existing IPTC field value\n   * @param {object} newValue New IPTC field value\n   * @returns {object} Resulting IPTC field value\n   */\n  function combineTagValues(value, newValue) {\n    if (value === undefined) return newValue\n    if (value instanceof Array) {\n      value.push(newValue)\n      return value\n    }\n    return [value, newValue]\n  }\n\n  /**\n   * Parses IPTC tags.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} segmentOffset Segment offset\n   * @param {number} segmentLength Segment length\n   * @param {object} data Data export object\n   * @param {object} includeTags Map of tags to include\n   * @param {object} excludeTags Map of tags to exclude\n   */\n  function parseIptcTags(\n    dataView,\n    segmentOffset,\n    segmentLength,\n    data,\n    includeTags,\n    excludeTags\n  ) {\n    var value, tagSize, tagCode\n    var segmentEnd = segmentOffset + segmentLength\n    var offset = segmentOffset\n    while (offset < segmentEnd) {\n      if (\n        dataView.getUint8(offset) === 0x1c && // tag marker\n        dataView.getUint8(offset + 1) === 0x02 // record number, only handles v2\n      ) {\n        tagCode = dataView.getUint8(offset + 2)\n        if (\n          (!includeTags || includeTags[tagCode]) &&\n          (!excludeTags || !excludeTags[tagCode])\n        ) {\n          tagSize = dataView.getInt16(offset + 3)\n          value = getTagValue(tagCode, data.iptc, dataView, offset + 5, tagSize)\n          data.iptc[tagCode] = combineTagValues(data.iptc[tagCode], value)\n          if (data.iptcOffsets) {\n            data.iptcOffsets[tagCode] = offset\n          }\n        }\n      }\n      offset += 1\n    }\n  }\n\n  /**\n   * Tests if field segment starts at offset.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Segment offset\n   * @returns {boolean} True if '8BIM<EOT><EOT>' exists at offset\n   */\n  function isSegmentStart(dataView, offset) {\n    return (\n      dataView.getUint32(offset) === 0x3842494d && // Photoshop segment start\n      dataView.getUint16(offset + 4) === 0x0404 // IPTC segment start\n    )\n  }\n\n  /**\n   * Returns header length.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Segment offset\n   * @returns {number} Header length\n   */\n  function getHeaderLength(dataView, offset) {\n    var length = dataView.getUint8(offset + 7)\n    if (length % 2 !== 0) length += 1\n    // Check for pre photoshop 6 format\n    if (length === 0) {\n      // Always 4\n      length = 4\n    }\n    return length\n  }\n\n  loadImage.parseIptcData = function (dataView, offset, length, data, options) {\n    if (options.disableIptc) {\n      return\n    }\n    var markerLength = offset + length\n    while (offset + 8 < markerLength) {\n      if (isSegmentStart(dataView, offset)) {\n        var headerLength = getHeaderLength(dataView, offset)\n        var segmentOffset = offset + 8 + headerLength\n        if (segmentOffset > markerLength) {\n          // eslint-disable-next-line no-console\n          console.log('Invalid IPTC data: Invalid segment offset.')\n          break\n        }\n        var segmentLength = dataView.getUint16(offset + 6 + headerLength)\n        if (offset + segmentLength > markerLength) {\n          // eslint-disable-next-line no-console\n          console.log('Invalid IPTC data: Invalid segment size.')\n          break\n        }\n        // Create the iptc object to store the tags:\n        data.iptc = new IptcMap()\n        if (!options.disableIptcOffsets) {\n          data.iptcOffsets = new IptcMap()\n        }\n        parseIptcTags(\n          dataView,\n          segmentOffset,\n          segmentLength,\n          data,\n          options.includeIptcTags,\n          options.excludeIptcTags || { 202: true } // ObjectPreviewData\n        )\n        return\n      }\n      // eslint-disable-next-line no-param-reassign\n      offset += 1\n    }\n  }\n\n  // Registers this IPTC parser for the APP13 JPEG metadata segment:\n  loadImage.metaDataParsers.jpeg[0xffed].push(loadImage.parseIptcData)\n\n  loadImage.IptcMap = IptcMap\n\n  // Adds the following properties to the parseMetaData callback data:\n  // - iptc: The iptc tags, parsed by the parseIptcData method\n\n  // Adds the following options to the parseMetaData method:\n  // - disableIptc: Disables IPTC parsing when true.\n  // - disableIptcOffsets: Disables storing IPTC tag offsets when true.\n  // - includeIptcTags: A map of IPTC tags to include for parsing.\n  // - excludeIptcTags: A map of IPTC tags to exclude from parsing.\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-fetch.js":"/*\n * JavaScript Load Image Fetch\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2017, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require, Promise */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var global = loadImage.global\n\n  if (\n    global.fetch &&\n    global.Request &&\n    global.Response &&\n    global.Response.prototype.blob\n  ) {\n    loadImage.fetchBlob = function (url, callback, options) {\n      /**\n       * Fetch response handler.\n       *\n       * @param {Response} response Fetch response\n       * @returns {Blob} Fetched Blob.\n       */\n      function responseHandler(response) {\n        return response.blob()\n      }\n      if (global.Promise && typeof callback !== 'function') {\n        return fetch(new Request(url, callback)).then(responseHandler)\n      }\n      fetch(new Request(url, options))\n        .then(responseHandler)\n        .then(callback)\n        [\n          // Avoid parsing error in IE<9, where catch is a reserved word.\n          // eslint-disable-next-line dot-notation\n          'catch'\n        ](function (err) {\n          callback(null, err)\n        })\n    }\n  } else if (\n    global.XMLHttpRequest &&\n    // https://xhr.spec.whatwg.org/#the-responsetype-attribute\n    new XMLHttpRequest().responseType === ''\n  ) {\n    loadImage.fetchBlob = function (url, callback, options) {\n      /**\n       * Promise executor\n       *\n       * @param {Function} resolve Resolution function\n       * @param {Function} reject Rejection function\n       */\n      function executor(resolve, reject) {\n        options = options || {} // eslint-disable-line no-param-reassign\n        var req = new XMLHttpRequest()\n        req.open(options.method || 'GET', url)\n        if (options.headers) {\n          Object.keys(options.headers).forEach(function (key) {\n            req.setRequestHeader(key, options.headers[key])\n          })\n        }\n        req.withCredentials = options.credentials === 'include'\n        req.responseType = 'blob'\n        req.onload = function () {\n          resolve(req.response)\n        }\n        req.onerror = req.onabort = req.ontimeout = function (err) {\n          if (resolve === reject) {\n            // Not using Promises\n            reject(null, err)\n          } else {\n            reject(err)\n          }\n        }\n        req.send(options.body)\n      }\n      if (global.Promise && typeof callback !== 'function') {\n        options = callback // eslint-disable-line no-param-reassign\n        return new Promise(executor)\n      }\n      return executor(callback, callback)\n    }\n  }\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc-map.js":"/*\n * JavaScript Load Image IPTC Map\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * Copyright 2018, Dave Bevan\n *\n * IPTC tags mapping based on\n * https://iptc.org/standards/photo-metadata\n * https://exiftool.org/TagNames/IPTC.html\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'), require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var IptcMapProto = loadImage.IptcMap.prototype\n\n  IptcMapProto.tags = {\n    0: 'ApplicationRecordVersion',\n    3: 'ObjectTypeReference',\n    4: 'ObjectAttributeReference',\n    5: 'ObjectName',\n    7: 'EditStatus',\n    8: 'EditorialUpdate',\n    10: 'Urgency',\n    12: 'SubjectReference',\n    15: 'Category',\n    20: 'SupplementalCategories',\n    22: 'FixtureIdentifier',\n    25: 'Keywords',\n    26: 'ContentLocationCode',\n    27: 'ContentLocationName',\n    30: 'ReleaseDate',\n    35: 'ReleaseTime',\n    37: 'ExpirationDate',\n    38: 'ExpirationTime',\n    40: 'SpecialInstructions',\n    42: 'ActionAdvised',\n    45: 'ReferenceService',\n    47: 'ReferenceDate',\n    50: 'ReferenceNumber',\n    55: 'DateCreated',\n    60: 'TimeCreated',\n    62: 'DigitalCreationDate',\n    63: 'DigitalCreationTime',\n    65: 'OriginatingProgram',\n    70: 'ProgramVersion',\n    75: 'ObjectCycle',\n    80: 'Byline',\n    85: 'BylineTitle',\n    90: 'City',\n    92: 'Sublocation',\n    95: 'State',\n    100: 'CountryCode',\n    101: 'Country',\n    103: 'OriginalTransmissionReference',\n    105: 'Headline',\n    110: 'Credit',\n    115: 'Source',\n    116: 'CopyrightNotice',\n    118: 'Contact',\n    120: 'Caption',\n    121: 'LocalCaption',\n    122: 'Writer',\n    125: 'RasterizedCaption',\n    130: 'ImageType',\n    131: 'ImageOrientation',\n    135: 'LanguageIdentifier',\n    150: 'AudioType',\n    151: 'AudioSamplingRate',\n    152: 'AudioSamplingResolution',\n    153: 'AudioDuration',\n    154: 'AudioOutcue',\n    184: 'JobID',\n    185: 'MasterDocumentID',\n    186: 'ShortDocumentID',\n    187: 'UniqueDocumentID',\n    188: 'OwnerID',\n    200: 'ObjectPreviewFileFormat',\n    201: 'ObjectPreviewFileVersion',\n    202: 'ObjectPreviewData',\n    221: 'Prefs',\n    225: 'ClassifyState',\n    228: 'SimilarityIndex',\n    230: 'DocumentNotes',\n    231: 'DocumentHistory',\n    232: 'ExifCameraInfo',\n    255: 'CatalogSets'\n  }\n\n  IptcMapProto.stringValues = {\n    10: {\n      0: '0 (reserved)',\n      1: '1 (most urgent)',\n      2: '2',\n      3: '3',\n      4: '4',\n      5: '5 (normal urgency)',\n      6: '6',\n      7: '7',\n      8: '8 (least urgent)',\n      9: '9 (user-defined priority)'\n    },\n    75: {\n      a: 'Morning',\n      b: 'Both Morning and Evening',\n      p: 'Evening'\n    },\n    131: {\n      L: 'Landscape',\n      P: 'Portrait',\n      S: 'Square'\n    }\n  }\n\n  IptcMapProto.getText = function (id) {\n    var value = this.get(id)\n    var tagCode = this.map[id]\n    var stringValue = this.stringValues[tagCode]\n    if (stringValue) return stringValue[value]\n    return String(value)\n  }\n\n  IptcMapProto.getAll = function () {\n    var map = {}\n    var prop\n    var name\n    for (prop in this) {\n      if (Object.prototype.hasOwnProperty.call(this, prop)) {\n        name = this.tags[prop]\n        if (name) map[name] = this.getText(name)\n      }\n    }\n    return map\n  }\n\n  IptcMapProto.getName = function (tagCode) {\n    return this.tags[tagCode]\n  }\n\n  // Extend the map of tag names to tag codes:\n  ;(function () {\n    var tags = IptcMapProto.tags\n    var map = IptcMapProto.map || {}\n    var prop\n    // Map the tag names to tags:\n    for (prop in tags) {\n      if (Object.prototype.hasOwnProperty.call(tags, prop)) {\n        map[tags[prop]] = Number(prop)\n      }\n    }\n  })()\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/index.js":"/* global module, require */\n\nmodule.exports = require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image')\n\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-fetch')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif-map')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc-map')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-orientation')\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif.js":"/*\n * JavaScript Load Image Exif Parser\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require, DataView */\n\n/* eslint-disable no-console */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'), require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  /**\n   * Exif tag map\n   *\n   * @name ExifMap\n   * @class\n   * @param {number|string} tagCode IFD tag code\n   */\n  function ExifMap(tagCode) {\n    if (tagCode) {\n      Object.defineProperty(this, 'map', {\n        value: this.ifds[tagCode].map\n      })\n      Object.defineProperty(this, 'tags', {\n        value: (this.tags && this.tags[tagCode]) || {}\n      })\n    }\n  }\n\n  ExifMap.prototype.map = {\n    Orientation: 0x0112,\n    Thumbnail: 'ifd1',\n    Blob: 0x0201, // Alias for JPEGInterchangeFormat\n    Exif: 0x8769,\n    GPSInfo: 0x8825,\n    Interoperability: 0xa005\n  }\n\n  ExifMap.prototype.ifds = {\n    ifd1: { name: 'Thumbnail', map: ExifMap.prototype.map },\n    0x8769: { name: 'Exif', map: {} },\n    0x8825: { name: 'GPSInfo', map: {} },\n    0xa005: { name: 'Interoperability', map: {} }\n  }\n\n  /**\n   * Retrieves exif tag value\n   *\n   * @param {number|string} id Exif tag code or name\n   * @returns {object} Exif tag value\n   */\n  ExifMap.prototype.get = function (id) {\n    return this[id] || this[this.map[id]]\n  }\n\n  /**\n   * Returns the Exif Thumbnail data as Blob.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Thumbnail data offset\n   * @param {number} length Thumbnail data length\n   * @returns {undefined|Blob} Returns the Thumbnail Blob or undefined\n   */\n  function getExifThumbnail(dataView, offset, length) {\n    if (!length) return\n    if (offset + length > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid thumbnail data.')\n      return\n    }\n    return new Blob(\n      [loadImage.bufferSlice.call(dataView.buffer, offset, offset + length)],\n      {\n        type: 'image/jpeg'\n      }\n    )\n  }\n\n  var ExifTagTypes = {\n    // byte, 8-bit unsigned int:\n    1: {\n      getValue: function (dataView, dataOffset) {\n        return dataView.getUint8(dataOffset)\n      },\n      size: 1\n    },\n    // ascii, 8-bit byte:\n    2: {\n      getValue: function (dataView, dataOffset) {\n        return String.fromCharCode(dataView.getUint8(dataOffset))\n      },\n      size: 1,\n      ascii: true\n    },\n    // short, 16 bit int:\n    3: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return dataView.getUint16(dataOffset, littleEndian)\n      },\n      size: 2\n    },\n    // long, 32 bit int:\n    4: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return dataView.getUint32(dataOffset, littleEndian)\n      },\n      size: 4\n    },\n    // rational = two long values, first is numerator, second is denominator:\n    5: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return (\n          dataView.getUint32(dataOffset, littleEndian) /\n          dataView.getUint32(dataOffset + 4, littleEndian)\n        )\n      },\n      size: 8\n    },\n    // slong, 32 bit signed int:\n    9: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return dataView.getInt32(dataOffset, littleEndian)\n      },\n      size: 4\n    },\n    // srational, two slongs, first is numerator, second is denominator:\n    10: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return (\n          dataView.getInt32(dataOffset, littleEndian) /\n          dataView.getInt32(dataOffset + 4, littleEndian)\n        )\n      },\n      size: 8\n    }\n  }\n  // undefined, 8-bit byte, value depending on field:\n  ExifTagTypes[7] = ExifTagTypes[1]\n\n  /**\n   * Returns Exif tag value.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} tiffOffset TIFF offset\n   * @param {number} offset Tag offset\n   * @param {number} type Tag type\n   * @param {number} length Tag length\n   * @param {boolean} littleEndian Little endian encoding\n   * @returns {object} Tag value\n   */\n  function getExifValue(\n    dataView,\n    tiffOffset,\n    offset,\n    type,\n    length,\n    littleEndian\n  ) {\n    var tagType = ExifTagTypes[type]\n    var tagSize\n    var dataOffset\n    var values\n    var i\n    var str\n    var c\n    if (!tagType) {\n      console.log('Invalid Exif data: Invalid tag type.')\n      return\n    }\n    tagSize = tagType.size * length\n    // Determine if the value is contained in the dataOffset bytes,\n    // or if the value at the dataOffset is a pointer to the actual data:\n    dataOffset =\n      tagSize > 4\n        ? tiffOffset + dataView.getUint32(offset + 8, littleEndian)\n        : offset + 8\n    if (dataOffset + tagSize > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid data offset.')\n      return\n    }\n    if (length === 1) {\n      return tagType.getValue(dataView, dataOffset, littleEndian)\n    }\n    values = []\n    for (i = 0; i < length; i += 1) {\n      values[i] = tagType.getValue(\n        dataView,\n        dataOffset + i * tagType.size,\n        littleEndian\n      )\n    }\n    if (tagType.ascii) {\n      str = ''\n      // Concatenate the chars:\n      for (i = 0; i < values.length; i += 1) {\n        c = values[i]\n        // Ignore the terminating NULL byte(s):\n        if (c === '\\u0000') {\n          break\n        }\n        str += c\n      }\n      return str\n    }\n    return values\n  }\n\n  /**\n   * Determines if the given tag should be included.\n   *\n   * @param {object} includeTags Map of tags to include\n   * @param {object} excludeTags Map of tags to exclude\n   * @param {number|string} tagCode Tag code to check\n   * @returns {boolean} True if the tag should be included\n   */\n  function shouldIncludeTag(includeTags, excludeTags, tagCode) {\n    return (\n      (!includeTags || includeTags[tagCode]) &&\n      (!excludeTags || excludeTags[tagCode] !== true)\n    )\n  }\n\n  /**\n   * Parses Exif tags.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} tiffOffset TIFF offset\n   * @param {number} dirOffset Directory offset\n   * @param {boolean} littleEndian Little endian encoding\n   * @param {ExifMap} tags Map to store parsed exif tags\n   * @param {ExifMap} tagOffsets Map to store parsed exif tag offsets\n   * @param {object} includeTags Map of tags to include\n   * @param {object} excludeTags Map of tags to exclude\n   * @returns {number} Next directory offset\n   */\n  function parseExifTags(\n    dataView,\n    tiffOffset,\n    dirOffset,\n    littleEndian,\n    tags,\n    tagOffsets,\n    includeTags,\n    excludeTags\n  ) {\n    var tagsNumber, dirEndOffset, i, tagOffset, tagNumber, tagValue\n    if (dirOffset + 6 > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid directory offset.')\n      return\n    }\n    tagsNumber = dataView.getUint16(dirOffset, littleEndian)\n    dirEndOffset = dirOffset + 2 + 12 * tagsNumber\n    if (dirEndOffset + 4 > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid directory size.')\n      return\n    }\n    for (i = 0; i < tagsNumber; i += 1) {\n      tagOffset = dirOffset + 2 + 12 * i\n      tagNumber = dataView.getUint16(tagOffset, littleEndian)\n      if (!shouldIncludeTag(includeTags, excludeTags, tagNumber)) continue\n      tagValue = getExifValue(\n        dataView,\n        tiffOffset,\n        tagOffset,\n        dataView.getUint16(tagOffset + 2, littleEndian), // tag type\n        dataView.getUint32(tagOffset + 4, littleEndian), // tag length\n        littleEndian\n      )\n      tags[tagNumber] = tagValue\n      if (tagOffsets) {\n        tagOffsets[tagNumber] = tagOffset\n      }\n    }\n    // Return the offset to the next directory:\n    return dataView.getUint32(dirEndOffset, littleEndian)\n  }\n\n  /**\n   * Parses tags in a given IFD (Image File Directory).\n   *\n   * @param {object} data Data object to store exif tags and offsets\n   * @param {number|string} tagCode IFD tag code\n   * @param {DataView} dataView Data view interface\n   * @param {number} tiffOffset TIFF offset\n   * @param {boolean} littleEndian Little endian encoding\n   * @param {object} includeTags Map of tags to include\n   * @param {object} excludeTags Map of tags to exclude\n   */\n  function parseExifIFD(\n    data,\n    tagCode,\n    dataView,\n    tiffOffset,\n    littleEndian,\n    includeTags,\n    excludeTags\n  ) {\n    var dirOffset = data.exif[tagCode]\n    if (dirOffset) {\n      data.exif[tagCode] = new ExifMap(tagCode)\n      if (data.exifOffsets) {\n        data.exifOffsets[tagCode] = new ExifMap(tagCode)\n      }\n      parseExifTags(\n        dataView,\n        tiffOffset,\n        tiffOffset + dirOffset,\n        littleEndian,\n        data.exif[tagCode],\n        data.exifOffsets && data.exifOffsets[tagCode],\n        includeTags && includeTags[tagCode],\n        excludeTags && excludeTags[tagCode]\n      )\n    }\n  }\n\n  loadImage.parseExifData = function (dataView, offset, length, data, options) {\n    if (options.disableExif) {\n      return\n    }\n    var includeTags = options.includeExifTags\n    var excludeTags = options.excludeExifTags || {\n      0x8769: {\n        // ExifIFDPointer\n        0x927c: true // MakerNote\n      }\n    }\n    var tiffOffset = offset + 10\n    var littleEndian\n    var dirOffset\n    var thumbnailIFD\n    // Check for the ASCII code for \"Exif\" (0x45786966):\n    if (dataView.getUint32(offset + 4) !== 0x45786966) {\n      // No Exif data, might be XMP data instead\n      return\n    }\n    if (tiffOffset + 8 > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid segment size.')\n      return\n    }\n    // Check for the two null bytes:\n    if (dataView.getUint16(offset + 8) !== 0x0000) {\n      console.log('Invalid Exif data: Missing byte alignment offset.')\n      return\n    }\n    // Check the byte alignment:\n    switch (dataView.getUint16(tiffOffset)) {\n      case 0x4949:\n        littleEndian = true\n        break\n      case 0x4d4d:\n        littleEndian = false\n        break\n      default:\n        console.log('Invalid Exif data: Invalid byte alignment marker.')\n        return\n    }\n    // Check for the TIFF tag marker (0x002A):\n    if (dataView.getUint16(tiffOffset + 2, littleEndian) !== 0x002a) {\n      console.log('Invalid Exif data: Missing TIFF marker.')\n      return\n    }\n    // Retrieve the directory offset bytes, usually 0x00000008 or 8 decimal:\n    dirOffset = dataView.getUint32(tiffOffset + 4, littleEndian)\n    // Create the exif object to store the tags:\n    data.exif = new ExifMap()\n    if (!options.disableExifOffsets) {\n      data.exifOffsets = new ExifMap()\n      data.exifTiffOffset = tiffOffset\n      data.exifLittleEndian = littleEndian\n    }\n    // Parse the tags of the main image directory (IFD0) and retrieve the\n    // offset to the next directory (IFD1), usually the thumbnail directory:\n    dirOffset = parseExifTags(\n      dataView,\n      tiffOffset,\n      tiffOffset + dirOffset,\n      littleEndian,\n      data.exif,\n      data.exifOffsets,\n      includeTags,\n      excludeTags\n    )\n    if (dirOffset && shouldIncludeTag(includeTags, excludeTags, 'ifd1')) {\n      data.exif.ifd1 = dirOffset\n      if (data.exifOffsets) {\n        data.exifOffsets.ifd1 = tiffOffset + dirOffset\n      }\n    }\n    Object.keys(data.exif.ifds).forEach(function (tagCode) {\n      parseExifIFD(\n        data,\n        tagCode,\n        dataView,\n        tiffOffset,\n        littleEndian,\n        includeTags,\n        excludeTags\n      )\n    })\n    thumbnailIFD = data.exif.ifd1\n    // Check for JPEG Thumbnail offset and data length:\n    if (thumbnailIFD && thumbnailIFD[0x0201]) {\n      thumbnailIFD[0x0201] = getExifThumbnail(\n        dataView,\n        tiffOffset + thumbnailIFD[0x0201],\n        thumbnailIFD[0x0202] // Thumbnail data length\n      )\n    }\n  }\n\n  // Registers the Exif parser for the APP1 JPEG metadata segment:\n  loadImage.metaDataParsers.jpeg[0xffe1].push(loadImage.parseExifData)\n\n  loadImage.exifWriters = {\n    // Orientation writer:\n    0x0112: function (buffer, data, value) {\n      var orientationOffset = data.exifOffsets[0x0112]\n      if (!orientationOffset) return buffer\n      var view = new DataView(buffer, orientationOffset + 8, 2)\n      view.setUint16(0, value, data.exifLittleEndian)\n      return buffer\n    }\n  }\n\n  loadImage.writeExifData = function (buffer, data, id, value) {\n    loadImage.exifWriters[data.exif.map[id]](buffer, data, value)\n  }\n\n  loadImage.ExifMap = ExifMap\n\n  // Adds the following properties to the parseMetaData callback data:\n  // - exif: The parsed Exif tags\n  // - exifOffsets: The parsed Exif tag offsets\n  // - exifTiffOffset: TIFF header offset (used for offset pointers)\n  // - exifLittleEndian: little endian order if true, big endian if false\n\n  // Adds the following options to the parseMetaData method:\n  // - disableExif: Disables Exif parsing when true.\n  // - disableExifOffsets: Disables storing Exif tag offsets when true.\n  // - includeExifTags: A map of Exif tags to include for parsing.\n  // - excludeExifTags: A map of Exif tags to exclude from parsing.\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image.js":"/*\n * JavaScript Load Image\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, Promise */\n\n;(function ($) {\n  'use strict'\n\n  var urlAPI = $.URL || $.webkitURL\n\n  /**\n   * Creates an object URL for a given File object.\n   *\n   * @param {Blob} blob Blob object\n   * @returns {string|boolean} Returns object URL if API exists, else false.\n   */\n  function createObjectURL(blob) {\n    return urlAPI ? urlAPI.createObjectURL(blob) : false\n  }\n\n  /**\n   * Revokes a given object URL.\n   *\n   * @param {string} url Blob object URL\n   * @returns {undefined|boolean} Returns undefined if API exists, else false.\n   */\n  function revokeObjectURL(url) {\n    return urlAPI ? urlAPI.revokeObjectURL(url) : false\n  }\n\n  /**\n   * Helper function to revoke an object URL\n   *\n   * @param {string} url Blob Object URL\n   * @param {object} [options] Options object\n   */\n  function revokeHelper(url, options) {\n    if (url && url.slice(0, 5) === 'blob:' && !(options && options.noRevoke)) {\n      revokeObjectURL(url)\n    }\n  }\n\n  /**\n   * Loads a given File object via FileReader interface.\n   *\n   * @param {Blob} file Blob object\n   * @param {Function} onload Load event callback\n   * @param {Function} [onerror] Error/Abort event callback\n   * @param {string} [method=readAsDataURL] FileReader method\n   * @returns {FileReader|boolean} Returns FileReader if API exists, else false.\n   */\n  function readFile(file, onload, onerror, method) {\n    if (!$.FileReader) return false\n    var reader = new FileReader()\n    reader.onload = function () {\n      onload.call(reader, this.result)\n    }\n    if (onerror) {\n      reader.onabort = reader.onerror = function () {\n        onerror.call(reader, this.error)\n      }\n    }\n    var readerMethod = reader[method || 'readAsDataURL']\n    if (readerMethod) {\n      readerMethod.call(reader, file)\n      return reader\n    }\n  }\n\n  /**\n   * Cross-frame instanceof check.\n   *\n   * @param {string} type Instance type\n   * @param {object} obj Object instance\n   * @returns {boolean} Returns true if the object is of the given instance.\n   */\n  function isInstanceOf(type, obj) {\n    // Cross-frame instanceof check\n    return Object.prototype.toString.call(obj) === '[object ' + type + ']'\n  }\n\n  /**\n   * @typedef { HTMLImageElement|HTMLCanvasElement } Result\n   */\n\n  /**\n   * Loads an image for a given File object.\n   *\n   * @param {Blob|string} file Blob object or image URL\n   * @param {Function|object} [callback] Image load event callback or options\n   * @param {object} [options] Options object\n   * @returns {HTMLImageElement|FileReader|Promise<Result>} Object\n   */\n  function loadImage(file, callback, options) {\n    /**\n     * Promise executor\n     *\n     * @param {Function} resolve Resolution function\n     * @param {Function} reject Rejection function\n     * @returns {HTMLImageElement|FileReader} Object\n     */\n    function executor(resolve, reject) {\n      var img = document.createElement('img')\n      var url\n      /**\n       * Callback for the fetchBlob call.\n       *\n       * @param {HTMLImageElement|HTMLCanvasElement} img Error object\n       * @param {object} data Data object\n       * @returns {undefined} Undefined\n       */\n      function resolveWrapper(img, data) {\n        if (resolve === reject) {\n          // Not using Promises\n          if (resolve) resolve(img, data)\n          return\n        } else if (img instanceof Error) {\n          reject(img)\n          return\n        }\n        data = data || {} // eslint-disable-line no-param-reassign\n        data.image = img\n        resolve(data)\n      }\n      /**\n       * Callback for the fetchBlob call.\n       *\n       * @param {Blob} blob Blob object\n       * @param {Error} err Error object\n       */\n      function fetchBlobCallback(blob, err) {\n        if (err && $.console) console.log(err) // eslint-disable-line no-console\n        if (blob && isInstanceOf('Blob', blob)) {\n          file = blob // eslint-disable-line no-param-reassign\n          url = createObjectURL(file)\n        } else {\n          url = file\n          if (options && options.crossOrigin) {\n            img.crossOrigin = options.crossOrigin\n          }\n        }\n        img.src = url\n      }\n      img.onerror = function (event) {\n        revokeHelper(url, options)\n        if (reject) reject.call(img, event)\n      }\n      img.onload = function () {\n        revokeHelper(url, options)\n        var data = {\n          originalWidth: img.naturalWidth || img.width,\n          originalHeight: img.naturalHeight || img.height\n        }\n        try {\n          loadImage.transform(img, options, resolveWrapper, file, data)\n        } catch (error) {\n          if (reject) reject(error)\n        }\n      }\n      if (typeof file === 'string') {\n        if (loadImage.requiresMetaData(options)) {\n          loadImage.fetchBlob(file, fetchBlobCallback, options)\n        } else {\n          fetchBlobCallback()\n        }\n        return img\n      } else if (isInstanceOf('Blob', file) || isInstanceOf('File', file)) {\n        url = createObjectURL(file)\n        if (url) {\n          img.src = url\n          return img\n        }\n        return readFile(\n          file,\n          function (url) {\n            img.src = url\n          },\n          reject\n        )\n      }\n    }\n    if ($.Promise && typeof callback !== 'function') {\n      options = callback // eslint-disable-line no-param-reassign\n      return new Promise(executor)\n    }\n    return executor(callback, callback)\n  }\n\n  // Determines if metadata should be loaded automatically.\n  // Requires the load image meta extension to load metadata.\n  loadImage.requiresMetaData = function (options) {\n    return options && options.meta\n  }\n\n  // If the callback given to this function returns a blob, it is used as image\n  // source instead of the original url and overrides the file argument used in\n  // the onload and onerror event callbacks:\n  loadImage.fetchBlob = function (url, callback) {\n    callback()\n  }\n\n  loadImage.transform = function (img, options, callback, file, data) {\n    callback(img, data)\n  }\n\n  loadImage.global = $\n  loadImage.readFile = readFile\n  loadImage.isInstanceOf = isInstanceOf\n  loadImage.createObjectURL = createObjectURL\n  loadImage.revokeObjectURL = revokeObjectURL\n\n  if (typeof define === 'function' && define.amd) {\n    define(function () {\n      return loadImage\n    })\n  } else if (typeof module === 'object' && module.exports) {\n    module.exports = loadImage\n  } else {\n    $.loadImage = loadImage\n  }\n})((typeof window !== 'undefined' && window) || this)\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale.js":"/*\n * JavaScript Load Image Scaling\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var originalTransform = loadImage.transform\n\n  loadImage.createCanvas = function (width, height, offscreen) {\n    if (offscreen && loadImage.global.OffscreenCanvas) {\n      return new OffscreenCanvas(width, height)\n    }\n    var canvas = document.createElement('canvas')\n    canvas.width = width\n    canvas.height = height\n    return canvas\n  }\n\n  loadImage.transform = function (img, options, callback, file, data) {\n    originalTransform.call(\n      loadImage,\n      loadImage.scale(img, options, data),\n      options,\n      callback,\n      file,\n      data\n    )\n  }\n\n  // Transform image coordinates, allows to override e.g.\n  // the canvas orientation based on the orientation option,\n  // gets canvas, options and data passed as arguments:\n  loadImage.transformCoordinates = function () {}\n\n  // Returns transformed options, allows to override e.g.\n  // maxWidth, maxHeight and crop options based on the aspectRatio.\n  // gets img, options, data passed as arguments:\n  loadImage.getTransformedOptions = function (img, options) {\n    var aspectRatio = options.aspectRatio\n    var newOptions\n    var i\n    var width\n    var height\n    if (!aspectRatio) {\n      return options\n    }\n    newOptions = {}\n    for (i in options) {\n      if (Object.prototype.hasOwnProperty.call(options, i)) {\n        newOptions[i] = options[i]\n      }\n    }\n    newOptions.crop = true\n    width = img.naturalWidth || img.width\n    height = img.naturalHeight || img.height\n    if (width / height > aspectRatio) {\n      newOptions.maxWidth = height * aspectRatio\n      newOptions.maxHeight = height\n    } else {\n      newOptions.maxWidth = width\n      newOptions.maxHeight = width / aspectRatio\n    }\n    return newOptions\n  }\n\n  // Canvas render method, allows to implement a different rendering algorithm:\n  loadImage.drawImage = function (\n    img,\n    canvas,\n    sourceX,\n    sourceY,\n    sourceWidth,\n    sourceHeight,\n    destWidth,\n    destHeight,\n    options\n  ) {\n    var ctx = canvas.getContext('2d')\n    if (options.imageSmoothingEnabled === false) {\n      ctx.msImageSmoothingEnabled = false\n      ctx.imageSmoothingEnabled = false\n    } else if (options.imageSmoothingQuality) {\n      ctx.imageSmoothingQuality = options.imageSmoothingQuality\n    }\n    ctx.drawImage(\n      img,\n      sourceX,\n      sourceY,\n      sourceWidth,\n      sourceHeight,\n      0,\n      0,\n      destWidth,\n      destHeight\n    )\n    return ctx\n  }\n\n  // Determines if the target image should be a canvas element:\n  loadImage.requiresCanvas = function (options) {\n    return options.canvas || options.crop || !!options.aspectRatio\n  }\n\n  // Scales and/or crops the given image (img or canvas HTML element)\n  // using the given options:\n  loadImage.scale = function (img, options, data) {\n    // eslint-disable-next-line no-param-reassign\n    options = options || {}\n    // eslint-disable-next-line no-param-reassign\n    data = data || {}\n    var useCanvas =\n      img.getContext ||\n      (loadImage.requiresCanvas(options) &&\n        !!loadImage.global.HTMLCanvasElement)\n    var width = img.naturalWidth || img.width\n    var height = img.naturalHeight || img.height\n    var destWidth = width\n    var destHeight = height\n    var maxWidth\n    var maxHeight\n    var minWidth\n    var minHeight\n    var sourceWidth\n    var sourceHeight\n    var sourceX\n    var sourceY\n    var pixelRatio\n    var downsamplingRatio\n    var tmp\n    var canvas\n    /**\n     * Scales up image dimensions\n     */\n    function scaleUp() {\n      var scale = Math.max(\n        (minWidth || destWidth) / destWidth,\n        (minHeight || destHeight) / destHeight\n      )\n      if (scale > 1) {\n        destWidth *= scale\n        destHeight *= scale\n      }\n    }\n    /**\n     * Scales down image dimensions\n     */\n    function scaleDown() {\n      var scale = Math.min(\n        (maxWidth || destWidth) / destWidth,\n        (maxHeight || destHeight) / destHeight\n      )\n      if (scale < 1) {\n        destWidth *= scale\n        destHeight *= scale\n      }\n    }\n    if (useCanvas) {\n      // eslint-disable-next-line no-param-reassign\n      options = loadImage.getTransformedOptions(img, options, data)\n      sourceX = options.left || 0\n      sourceY = options.top || 0\n      if (options.sourceWidth) {\n        sourceWidth = options.sourceWidth\n        if (options.right !== undefined && options.left === undefined) {\n          sourceX = width - sourceWidth - options.right\n        }\n      } else {\n        sourceWidth = width - sourceX - (options.right || 0)\n      }\n      if (options.sourceHeight) {\n        sourceHeight = options.sourceHeight\n        if (options.bottom !== undefined && options.top === undefined) {\n          sourceY = height - sourceHeight - options.bottom\n        }\n      } else {\n        sourceHeight = height - sourceY - (options.bottom || 0)\n      }\n      destWidth = sourceWidth\n      destHeight = sourceHeight\n    }\n    maxWidth = options.maxWidth\n    maxHeight = options.maxHeight\n    minWidth = options.minWidth\n    minHeight = options.minHeight\n    if (useCanvas && maxWidth && maxHeight && options.crop) {\n      destWidth = maxWidth\n      destHeight = maxHeight\n      tmp = sourceWidth / sourceHeight - maxWidth / maxHeight\n      if (tmp < 0) {\n        sourceHeight = (maxHeight * sourceWidth) / maxWidth\n        if (options.top === undefined && options.bottom === undefined) {\n          sourceY = (height - sourceHeight) / 2\n        }\n      } else if (tmp > 0) {\n        sourceWidth = (maxWidth * sourceHeight) / maxHeight\n        if (options.left === undefined && options.right === undefined) {\n          sourceX = (width - sourceWidth) / 2\n        }\n      }\n    } else {\n      if (options.contain || options.cover) {\n        minWidth = maxWidth = maxWidth || minWidth\n        minHeight = maxHeight = maxHeight || minHeight\n      }\n      if (options.cover) {\n        scaleDown()\n        scaleUp()\n      } else {\n        scaleUp()\n        scaleDown()\n      }\n    }\n    if (useCanvas) {\n      pixelRatio = options.pixelRatio\n      if (\n        pixelRatio > 1 &&\n        // Check if the image has not yet had the device pixel ratio applied:\n        !(\n          img.style.width &&\n          Math.floor(parseFloat(img.style.width, 10)) ===\n            Math.floor(width / pixelRatio)\n        )\n      ) {\n        destWidth *= pixelRatio\n        destHeight *= pixelRatio\n      }\n      // Check if workaround for Chromium orientation crop bug is required:\n      // https://bugs.chromium.org/p/chromium/issues/detail?id=1074354\n      if (\n        loadImage.orientationCropBug &&\n        !img.getContext &&\n        (sourceX || sourceY || sourceWidth !== width || sourceHeight !== height)\n      ) {\n        // Write the complete source image to an intermediate canvas first:\n        tmp = img\n        // eslint-disable-next-line no-param-reassign\n        img = loadImage.createCanvas(width, height, true)\n        loadImage.drawImage(\n          tmp,\n          img,\n          0,\n          0,\n          width,\n          height,\n          width,\n          height,\n          options\n        )\n      }\n      downsamplingRatio = options.downsamplingRatio\n      if (\n        downsamplingRatio > 0 &&\n        downsamplingRatio < 1 &&\n        destWidth < sourceWidth &&\n        destHeight < sourceHeight\n      ) {\n        while (sourceWidth * downsamplingRatio > destWidth) {\n          canvas = loadImage.createCanvas(\n            sourceWidth * downsamplingRatio,\n            sourceHeight * downsamplingRatio,\n            true\n          )\n          loadImage.drawImage(\n            img,\n            canvas,\n            sourceX,\n            sourceY,\n            sourceWidth,\n            sourceHeight,\n            canvas.width,\n            canvas.height,\n            options\n          )\n          sourceX = 0\n          sourceY = 0\n          sourceWidth = canvas.width\n          sourceHeight = canvas.height\n          // eslint-disable-next-line no-param-reassign\n          img = canvas\n        }\n      }\n      canvas = loadImage.createCanvas(destWidth, destHeight)\n      loadImage.transformCoordinates(canvas, options, data)\n      if (pixelRatio > 1) {\n        canvas.style.width = canvas.width / pixelRatio + 'px'\n      }\n      loadImage\n        .drawImage(\n          img,\n          canvas,\n          sourceX,\n          sourceY,\n          sourceWidth,\n          sourceHeight,\n          destWidth,\n          destHeight,\n          options\n        )\n        .setTransform(1, 0, 0, 1, 0, 0) // reset to the identity matrix\n      return canvas\n    }\n    img.width = destWidth\n    img.height = destHeight\n    return img\n  }\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-orientation.js":"/*\n * JavaScript Load Image Orientation\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/*\nExif orientation values to correctly display the letter F:\n\n    1             2\n  \u2588\u2588\u2588\u2588\u2588\u2588        \u2588\u2588\u2588\u2588\u2588\u2588\n  \u2588\u2588                \u2588\u2588\n  \u2588\u2588\u2588\u2588            \u2588\u2588\u2588\u2588\n  \u2588\u2588                \u2588\u2588\n  \u2588\u2588                \u2588\u2588\n\n    3             4\n      \u2588\u2588        \u2588\u2588\n      \u2588\u2588        \u2588\u2588\n    \u2588\u2588\u2588\u2588        \u2588\u2588\u2588\u2588\n      \u2588\u2588        \u2588\u2588\n  \u2588\u2588\u2588\u2588\u2588\u2588        \u2588\u2588\u2588\u2588\u2588\u2588\n\n    5             6\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588    \u2588\u2588\n\u2588\u2588  \u2588\u2588        \u2588\u2588  \u2588\u2588\n\u2588\u2588            \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\n\n    7             8\n        \u2588\u2588    \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\n    \u2588\u2588  \u2588\u2588        \u2588\u2588  \u2588\u2588\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588            \u2588\u2588\n\n*/\n\n/* global define, module, require */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta')\n    )\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var originalTransform = loadImage.transform\n  var originalRequiresCanvas = loadImage.requiresCanvas\n  var originalRequiresMetaData = loadImage.requiresMetaData\n  var originalTransformCoordinates = loadImage.transformCoordinates\n  var originalGetTransformedOptions = loadImage.getTransformedOptions\n\n  ;(function ($) {\n    // Guard for non-browser environments (e.g. server-side rendering):\n    if (!$.global.document) return\n    // black+white 3x2 JPEG, with the following meta information set:\n    // - EXIF Orientation: 6 (Rotated 90\u00b0 CCW)\n    // Image data layout (B=black, F=white):\n    // BFF\n    // BBB\n    var testImageURL =\n      'data:image/jpeg;base64,/9j/4QAiRXhpZgAATU0AKgAAAAgAAQESAAMAAAABAAYAAAA' +\n      'AAAD/2wCEAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBA' +\n      'QEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQE' +\n      'BAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAf/AABEIAAIAAwMBEQACEQEDEQH/x' +\n      'ABRAAEAAAAAAAAAAAAAAAAAAAAKEAEBAQADAQEAAAAAAAAAAAAGBQQDCAkCBwEBAAAAAAA' +\n      'AAAAAAAAAAAAAABEBAAAAAAAAAAAAAAAAAAAAAP/aAAwDAQACEQMRAD8AG8T9NfSMEVMhQ' +\n      'voP3fFiRZ+MTHDifa/95OFSZU5OzRzxkyejv8ciEfhSceSXGjS8eSdLnZc2HDm4M3BxcXw' +\n      'H/9k='\n    var img = document.createElement('img')\n    img.onload = function () {\n      // Check if the browser supports automatic image orientation:\n      $.orientation = img.width === 2 && img.height === 3\n      if ($.orientation) {\n        var canvas = $.createCanvas(1, 1, true)\n        var ctx = canvas.getContext('2d')\n        ctx.drawImage(img, 1, 1, 1, 1, 0, 0, 1, 1)\n        // Check if the source image coordinates (sX, sY, sWidth, sHeight) are\n        // correctly applied to the auto-orientated image, which should result\n        // in a white opaque pixel (e.g. in Safari).\n        // Browsers that show a transparent pixel (e.g. Chromium) fail to crop\n        // auto-oriented images correctly and require a workaround, e.g.\n        // drawing the complete source image to an intermediate canvas first.\n        // See https://bugs.chromium.org/p/chromium/issues/detail?id=1074354\n        $.orientationCropBug =\n          ctx.getImageData(0, 0, 1, 1).data.toString() !== '255,255,255,255'\n      }\n    }\n    img.src = testImageURL\n  })(loadImage)\n\n  /**\n   * Determines if the orientation requires a canvas element.\n   *\n   * @param {object} [options] Options object\n   * @param {boolean} [withMetaData] Is metadata required for orientation\n   * @returns {boolean} Returns true if orientation requires canvas/meta\n   */\n  function requiresCanvasOrientation(options, withMetaData) {\n    var orientation = options && options.orientation\n    return (\n      // Exif orientation for browsers without automatic image orientation:\n      (orientation === true && !loadImage.orientation) ||\n      // Orientation reset for browsers with automatic image orientation:\n      (orientation === 1 && loadImage.orientation) ||\n      // Orientation to defined value, requires meta for orientation reset only:\n      ((!withMetaData || loadImage.orientation) &&\n        orientation > 1 &&\n        orientation < 9)\n    )\n  }\n\n  /**\n   * Determines if the image requires an orientation change.\n   *\n   * @param {number} [orientation] Defined orientation value\n   * @param {number} [autoOrientation] Auto-orientation based on Exif data\n   * @returns {boolean} Returns true if an orientation change is required\n   */\n  function requiresOrientationChange(orientation, autoOrientation) {\n    return (\n      orientation !== autoOrientation &&\n      ((orientation === 1 && autoOrientation > 1 && autoOrientation < 9) ||\n        (orientation > 1 && orientation < 9))\n    )\n  }\n\n  /**\n   * Determines orientation combinations that require a rotation by 180\u00b0.\n   *\n   * The following is a list of combinations that return true:\n   *\n   * 2 (flip) => 5 (rot90,flip), 7 (rot90,flip), 6 (rot90), 8 (rot90)\n   * 4 (flip) => 5 (rot90,flip), 7 (rot90,flip), 6 (rot90), 8 (rot90)\n   *\n   * 5 (rot90,flip) => 2 (flip), 4 (flip), 6 (rot90), 8 (rot90)\n   * 7 (rot90,flip) => 2 (flip), 4 (flip), 6 (rot90), 8 (rot90)\n   *\n   * 6 (rot90) => 2 (flip), 4 (flip), 5 (rot90,flip), 7 (rot90,flip)\n   * 8 (rot90) => 2 (flip), 4 (flip), 5 (rot90,flip), 7 (rot90,flip)\n   *\n   * @param {number} [orientation] Defined orientation value\n   * @param {number} [autoOrientation] Auto-orientation based on Exif data\n   * @returns {boolean} Returns true if rotation by 180\u00b0 is required\n   */\n  function requiresRot180(orientation, autoOrientation) {\n    if (autoOrientation > 1 && autoOrientation < 9) {\n      switch (orientation) {\n        case 2:\n        case 4:\n          return autoOrientation > 4\n        case 5:\n        case 7:\n          return autoOrientation % 2 === 0\n        case 6:\n        case 8:\n          return (\n            autoOrientation === 2 ||\n            autoOrientation === 4 ||\n            autoOrientation === 5 ||\n            autoOrientation === 7\n          )\n      }\n    }\n    return false\n  }\n\n  // Determines if the target image should be a canvas element:\n  loadImage.requiresCanvas = function (options) {\n    return (\n      requiresCanvasOrientation(options) ||\n      originalRequiresCanvas.call(loadImage, options)\n    )\n  }\n\n  // Determines if metadata should be loaded automatically:\n  loadImage.requiresMetaData = function (options) {\n    return (\n      requiresCanvasOrientation(options, true) ||\n      originalRequiresMetaData.call(loadImage, options)\n    )\n  }\n\n  loadImage.transform = function (img, options, callback, file, data) {\n    originalTransform.call(\n      loadImage,\n      img,\n      options,\n      function (img, data) {\n        if (data) {\n          var autoOrientation =\n            loadImage.orientation && data.exif && data.exif.get('Orientation')\n          if (autoOrientation > 4 && autoOrientation < 9) {\n            // Automatic image orientation switched image dimensions\n            var originalWidth = data.originalWidth\n            var originalHeight = data.originalHeight\n            data.originalWidth = originalHeight\n            data.originalHeight = originalWidth\n          }\n        }\n        callback(img, data)\n      },\n      file,\n      data\n    )\n  }\n\n  // Transforms coordinate and dimension options\n  // based on the given orientation option:\n  loadImage.getTransformedOptions = function (img, opts, data) {\n    var options = originalGetTransformedOptions.call(loadImage, img, opts)\n    var exifOrientation = data.exif && data.exif.get('Orientation')\n    var orientation = options.orientation\n    var autoOrientation = loadImage.orientation && exifOrientation\n    if (orientation === true) orientation = exifOrientation\n    if (!requiresOrientationChange(orientation, autoOrientation)) {\n      return options\n    }\n    var top = options.top\n    var right = options.right\n    var bottom = options.bottom\n    var left = options.left\n    var newOptions = {}\n    for (var i in options) {\n      if (Object.prototype.hasOwnProperty.call(options, i)) {\n        newOptions[i] = options[i]\n      }\n    }\n    newOptions.orientation = orientation\n    if (\n      (orientation > 4 && !(autoOrientation > 4)) ||\n      (orientation < 5 && autoOrientation > 4)\n    ) {\n      // Image dimensions and target dimensions are switched\n      newOptions.maxWidth = options.maxHeight\n      newOptions.maxHeight = options.maxWidth\n      newOptions.minWidth = options.minHeight\n      newOptions.minHeight = options.minWidth\n      newOptions.sourceWidth = options.sourceHeight\n      newOptions.sourceHeight = options.sourceWidth\n    }\n    if (autoOrientation > 1) {\n      // Browsers which correctly apply source image coordinates to\n      // auto-oriented images\n      switch (autoOrientation) {\n        case 2:\n          // Horizontal flip\n          right = options.left\n          left = options.right\n          break\n        case 3:\n          // 180\u00b0 Rotate CCW\n          top = options.bottom\n          right = options.left\n          bottom = options.top\n          left = options.right\n          break\n        case 4:\n          // Vertical flip\n          top = options.bottom\n          bottom = options.top\n          break\n        case 5:\n          // Horizontal flip + 90\u00b0 Rotate CCW\n          top = options.left\n          right = options.bottom\n          bottom = options.right\n          left = options.top\n          break\n        case 6:\n          // 90\u00b0 Rotate CCW\n          top = options.left\n          right = options.top\n          bottom = options.right\n          left = options.bottom\n          break\n        case 7:\n          // Vertical flip + 90\u00b0 Rotate CCW\n          top = options.right\n          right = options.top\n          bottom = options.left\n          left = options.bottom\n          break\n        case 8:\n          // 90\u00b0 Rotate CW\n          top = options.right\n          right = options.bottom\n          bottom = options.left\n          left = options.top\n          break\n      }\n      // Some orientation combinations require additional rotation by 180\u00b0:\n      if (requiresRot180(orientation, autoOrientation)) {\n        var tmpTop = top\n        var tmpRight = right\n        top = bottom\n        right = left\n        bottom = tmpTop\n        left = tmpRight\n      }\n    }\n    newOptions.top = top\n    newOptions.right = right\n    newOptions.bottom = bottom\n    newOptions.left = left\n    // Account for defined browser orientation:\n    switch (orientation) {\n      case 2:\n        // Horizontal flip\n        newOptions.right = left\n        newOptions.left = right\n        break\n      case 3:\n        // 180\u00b0 Rotate CCW\n        newOptions.top = bottom\n        newOptions.right = left\n        newOptions.bottom = top\n        newOptions.left = right\n        break\n      case 4:\n        // Vertical flip\n        newOptions.top = bottom\n        newOptions.bottom = top\n        break\n      case 5:\n        // Vertical flip + 90\u00b0 Rotate CW\n        newOptions.top = left\n        newOptions.right = bottom\n        newOptions.bottom = right\n        newOptions.left = top\n        break\n      case 6:\n        // 90\u00b0 Rotate CW\n        newOptions.top = right\n        newOptions.right = bottom\n        newOptions.bottom = left\n        newOptions.left = top\n        break\n      case 7:\n        // Horizontal flip + 90\u00b0 Rotate CW\n        newOptions.top = right\n        newOptions.right = top\n        newOptions.bottom = left\n        newOptions.left = bottom\n        break\n      case 8:\n        // 90\u00b0 Rotate CCW\n        newOptions.top = left\n        newOptions.right = top\n        newOptions.bottom = right\n        newOptions.left = bottom\n        break\n    }\n    return newOptions\n  }\n\n  // Transform image orientation based on the given EXIF orientation option:\n  loadImage.transformCoordinates = function (canvas, options, data) {\n    originalTransformCoordinates.call(loadImage, canvas, options, data)\n    var orientation = options.orientation\n    var autoOrientation =\n      loadImage.orientation && data.exif && data.exif.get('Orientation')\n    if (!requiresOrientationChange(orientation, autoOrientation)) {\n      return\n    }\n    var ctx = canvas.getContext('2d')\n    var width = canvas.width\n    var height = canvas.height\n    var sourceWidth = width\n    var sourceHeight = height\n    if (\n      (orientation > 4 && !(autoOrientation > 4)) ||\n      (orientation < 5 && autoOrientation > 4)\n    ) {\n      // Image dimensions and target dimensions are switched\n      canvas.width = height\n      canvas.height = width\n    }\n    if (orientation > 4) {\n      // Destination and source dimensions are switched\n      sourceWidth = height\n      sourceHeight = width\n    }\n    // Reset automatic browser orientation:\n    switch (autoOrientation) {\n      case 2:\n        // Horizontal flip\n        ctx.translate(sourceWidth, 0)\n        ctx.scale(-1, 1)\n        break\n      case 3:\n        // 180\u00b0 Rotate CCW\n        ctx.translate(sourceWidth, sourceHeight)\n        ctx.rotate(Math.PI)\n        break\n      case 4:\n        // Vertical flip\n        ctx.translate(0, sourceHeight)\n        ctx.scale(1, -1)\n        break\n      case 5:\n        // Horizontal flip + 90\u00b0 Rotate CCW\n        ctx.rotate(-0.5 * Math.PI)\n        ctx.scale(-1, 1)\n        break\n      case 6:\n        // 90\u00b0 Rotate CCW\n        ctx.rotate(-0.5 * Math.PI)\n        ctx.translate(-sourceWidth, 0)\n        break\n      case 7:\n        // Vertical flip + 90\u00b0 Rotate CCW\n        ctx.rotate(-0.5 * Math.PI)\n        ctx.translate(-sourceWidth, sourceHeight)\n        ctx.scale(1, -1)\n        break\n      case 8:\n        // 90\u00b0 Rotate CW\n        ctx.rotate(0.5 * Math.PI)\n        ctx.translate(0, -sourceHeight)\n        break\n    }\n    // Some orientation combinations require additional rotation by 180\u00b0:\n    if (requiresRot180(orientation, autoOrientation)) {\n      ctx.translate(sourceWidth, sourceHeight)\n      ctx.rotate(Math.PI)\n    }\n    switch (orientation) {\n      case 2:\n        // Horizontal flip\n        ctx.translate(width, 0)\n        ctx.scale(-1, 1)\n        break\n      case 3:\n        // 180\u00b0 Rotate CCW\n        ctx.translate(width, height)\n        ctx.rotate(Math.PI)\n        break\n      case 4:\n        // Vertical flip\n        ctx.translate(0, height)\n        ctx.scale(1, -1)\n        break\n      case 5:\n        // Vertical flip + 90\u00b0 Rotate CW\n        ctx.rotate(0.5 * Math.PI)\n        ctx.scale(1, -1)\n        break\n      case 6:\n        // 90\u00b0 Rotate CW\n        ctx.rotate(0.5 * Math.PI)\n        ctx.translate(0, -height)\n        break\n      case 7:\n        // Horizontal flip + 90\u00b0 Rotate CW\n        ctx.rotate(0.5 * Math.PI)\n        ctx.translate(width, -height)\n        ctx.scale(-1, 1)\n        break\n      case 8:\n        // 90\u00b0 Rotate CCW\n        ctx.rotate(-0.5 * Math.PI)\n        ctx.translate(-width, 0)\n        break\n    }\n  }\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta.js":"/*\n * JavaScript Load Image Meta\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Image metadata handling implementation\n * based on the help and contribution of\n * Achim St\u00f6hr.\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require, Promise, DataView, Uint8Array, ArrayBuffer */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var global = loadImage.global\n  var originalTransform = loadImage.transform\n\n  var blobSlice =\n    global.Blob &&\n    (Blob.prototype.slice ||\n      Blob.prototype.webkitSlice ||\n      Blob.prototype.mozSlice)\n\n  var bufferSlice =\n    (global.ArrayBuffer && ArrayBuffer.prototype.slice) ||\n    function (begin, end) {\n      // Polyfill for IE10, which does not support ArrayBuffer.slice\n      // eslint-disable-next-line no-param-reassign\n      end = end || this.byteLength - begin\n      var arr1 = new Uint8Array(this, begin, end)\n      var arr2 = new Uint8Array(end)\n      arr2.set(arr1)\n      return arr2.buffer\n    }\n\n  var metaDataParsers = {\n    jpeg: {\n      0xffe1: [], // APP1 marker\n      0xffed: [] // APP13 marker\n    }\n  }\n\n  /**\n   * Parses image metadata and calls the callback with an object argument\n   * with the following property:\n   * - imageHead: The complete image head as ArrayBuffer\n   * The options argument accepts an object and supports the following\n   * properties:\n   * - maxMetaDataSize: Defines the maximum number of bytes to parse.\n   * - disableImageHead: Disables creating the imageHead property.\n   *\n   * @param {Blob} file Blob object\n   * @param {Function} [callback] Callback function\n   * @param {object} [options] Parsing options\n   * @param {object} [data] Result data object\n   * @returns {Promise<object>|undefined} Returns Promise if no callback given.\n   */\n  function parseMetaData(file, callback, options, data) {\n    var that = this\n    /**\n     * Promise executor\n     *\n     * @param {Function} resolve Resolution function\n     * @param {Function} reject Rejection function\n     * @returns {undefined} Undefined\n     */\n    function executor(resolve, reject) {\n      if (\n        !(\n          global.DataView &&\n          blobSlice &&\n          file &&\n          file.size >= 12 &&\n          file.type === 'image/jpeg'\n        )\n      ) {\n        // Nothing to parse\n        return resolve(data)\n      }\n      // 256 KiB should contain all EXIF/ICC/IPTC segments:\n      var maxMetaDataSize = options.maxMetaDataSize || 262144\n      if (\n        !loadImage.readFile(\n          blobSlice.call(file, 0, maxMetaDataSize),\n          function (buffer) {\n            // Note on endianness:\n            // Since the marker and length bytes in JPEG files are always\n            // stored in big endian order, we can leave the endian parameter\n            // of the DataView methods undefined, defaulting to big endian.\n            var dataView = new DataView(buffer)\n            // Check for the JPEG marker (0xffd8):\n            if (dataView.getUint16(0) !== 0xffd8) {\n              return reject(\n                new Error('Invalid JPEG file: Missing JPEG marker.')\n              )\n            }\n            var offset = 2\n            var maxOffset = dataView.byteLength - 4\n            var headLength = offset\n            var markerBytes\n            var markerLength\n            var parsers\n            var i\n            while (offset < maxOffset) {\n              markerBytes = dataView.getUint16(offset)\n              // Search for APPn (0xffeN) and COM (0xfffe) markers,\n              // which contain application-specific metadata like\n              // Exif, ICC and IPTC data and text comments:\n              if (\n                (markerBytes >= 0xffe0 && markerBytes <= 0xffef) ||\n                markerBytes === 0xfffe\n              ) {\n                // The marker bytes (2) are always followed by\n                // the length bytes (2), indicating the length of the\n                // marker segment, which includes the length bytes,\n                // but not the marker bytes, so we add 2:\n                markerLength = dataView.getUint16(offset + 2) + 2\n                if (offset + markerLength > dataView.byteLength) {\n                  // eslint-disable-next-line no-console\n                  console.log('Invalid JPEG metadata: Invalid segment size.')\n                  break\n                }\n                parsers = metaDataParsers.jpeg[markerBytes]\n                if (parsers && !options.disableMetaDataParsers) {\n                  for (i = 0; i < parsers.length; i += 1) {\n                    parsers[i].call(\n                      that,\n                      dataView,\n                      offset,\n                      markerLength,\n                      data,\n                      options\n                    )\n                  }\n                }\n                offset += markerLength\n                headLength = offset\n              } else {\n                // Not an APPn or COM marker, probably safe to\n                // assume that this is the end of the metadata\n                break\n              }\n            }\n            // Meta length must be longer than JPEG marker (2)\n            // plus APPn marker (2), followed by length bytes (2):\n            if (!options.disableImageHead && headLength > 6) {\n              data.imageHead = bufferSlice.call(buffer, 0, headLength)\n            }\n            resolve(data)\n          },\n          reject,\n          'readAsArrayBuffer'\n        )\n      ) {\n        // No support for the FileReader interface, nothing to parse\n        resolve(data)\n      }\n    }\n    options = options || {} // eslint-disable-line no-param-reassign\n    if (global.Promise && typeof callback !== 'function') {\n      options = callback || {} // eslint-disable-line no-param-reassign\n      data = options // eslint-disable-line no-param-reassign\n      return new Promise(executor)\n    }\n    data = data || {} // eslint-disable-line no-param-reassign\n    return executor(callback, callback)\n  }\n\n  /**\n   * Replaces the head of a JPEG Blob\n   *\n   * @param {Blob} blob Blob object\n   * @param {ArrayBuffer} oldHead Old JPEG head\n   * @param {ArrayBuffer} newHead New JPEG head\n   * @returns {Blob} Combined Blob\n   */\n  function replaceJPEGHead(blob, oldHead, newHead) {\n    if (!blob || !oldHead || !newHead) return null\n    return new Blob([newHead, blobSlice.call(blob, oldHead.byteLength)], {\n      type: 'image/jpeg'\n    })\n  }\n\n  /**\n   * Replaces the image head of a JPEG blob with the given one.\n   * Returns a Promise or calls the callback with the new Blob.\n   *\n   * @param {Blob} blob Blob object\n   * @param {ArrayBuffer} head New JPEG head\n   * @param {Function} [callback] Callback function\n   * @returns {Promise<Blob|null>|undefined} Combined Blob\n   */\n  function replaceHead(blob, head, callback) {\n    var options = { maxMetaDataSize: 256, disableMetaDataParsers: true }\n    if (!callback && global.Promise) {\n      return parseMetaData(blob, options).then(function (data) {\n        return replaceJPEGHead(blob, data.imageHead, head)\n      })\n    }\n    parseMetaData(\n      blob,\n      function (data) {\n        callback(replaceJPEGHead(blob, data.imageHead, head))\n      },\n      options\n    )\n  }\n\n  loadImage.transform = function (img, options, callback, file, data) {\n    if (loadImage.requiresMetaData(options)) {\n      data = data || {} // eslint-disable-line no-param-reassign\n      parseMetaData(\n        file,\n        function (result) {\n          if (result !== data) {\n            // eslint-disable-next-line no-console\n            if (global.console) console.log(result)\n            result = data // eslint-disable-line no-param-reassign\n          }\n          originalTransform.call(\n            loadImage,\n            img,\n            options,\n            callback,\n            file,\n            result\n          )\n        },\n        options,\n        data\n      )\n    } else {\n      originalTransform.apply(loadImage, arguments)\n    }\n  }\n\n  loadImage.blobSlice = blobSlice\n  loadImage.bufferSlice = bufferSlice\n  loadImage.replaceHead = replaceHead\n  loadImage.parseMetaData = parseMetaData\n  loadImage.metaDataParsers = metaDataParsers\n})\n","jquery/fileUploader/vendor/blueimp-canvas-to-blob/js/canvas-to-blob.js":"/*\n * JavaScript Canvas to Blob\n * https://github.com/blueimp/JavaScript-Canvas-to-Blob\n *\n * Copyright 2012, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n *\n * Based on stackoverflow user Stoive's code snippet:\n * http://stackoverflow.com/q/4998908\n */\n\n/* global define, Uint8Array, ArrayBuffer, module */\n\n;(function (window) {\n  'use strict'\n\n  var CanvasPrototype =\n    window.HTMLCanvasElement && window.HTMLCanvasElement.prototype\n  var hasBlobConstructor =\n    window.Blob &&\n    (function () {\n      try {\n        return Boolean(new Blob())\n      } catch (e) {\n        return false\n      }\n    })()\n  var hasArrayBufferViewSupport =\n    hasBlobConstructor &&\n    window.Uint8Array &&\n    (function () {\n      try {\n        return new Blob([new Uint8Array(100)]).size === 100\n      } catch (e) {\n        return false\n      }\n    })()\n  var BlobBuilder =\n    window.BlobBuilder ||\n    window.WebKitBlobBuilder ||\n    window.MozBlobBuilder ||\n    window.MSBlobBuilder\n  var dataURIPattern = /^data:((.*?)(;charset=.*?)?)(;base64)?,/\n  var dataURLtoBlob =\n    (hasBlobConstructor || BlobBuilder) &&\n    window.atob &&\n    window.ArrayBuffer &&\n    window.Uint8Array &&\n    function (dataURI) {\n      var matches,\n        mediaType,\n        isBase64,\n        dataString,\n        byteString,\n        arrayBuffer,\n        intArray,\n        i,\n        bb\n      // Parse the dataURI components as per RFC 2397\n      matches = dataURI.match(dataURIPattern)\n      if (!matches) {\n        throw new Error('invalid data URI')\n      }\n      // Default to text/plain;charset=US-ASCII\n      mediaType = matches[2]\n        ? matches[1]\n        : 'text/plain' + (matches[3] || ';charset=US-ASCII')\n      isBase64 = !!matches[4]\n      dataString = dataURI.slice(matches[0].length)\n      if (isBase64) {\n        // Convert base64 to raw binary data held in a string:\n        byteString = atob(dataString)\n      } else {\n        // Convert base64/URLEncoded data component to raw binary:\n        byteString = decodeURIComponent(dataString)\n      }\n      // Write the bytes of the string to an ArrayBuffer:\n      arrayBuffer = new ArrayBuffer(byteString.length)\n      intArray = new Uint8Array(arrayBuffer)\n      for (i = 0; i < byteString.length; i += 1) {\n        intArray[i] = byteString.charCodeAt(i)\n      }\n      // Write the ArrayBuffer (or ArrayBufferView) to a blob:\n      if (hasBlobConstructor) {\n        return new Blob([hasArrayBufferViewSupport ? intArray : arrayBuffer], {\n          type: mediaType\n        })\n      }\n      bb = new BlobBuilder()\n      bb.append(arrayBuffer)\n      return bb.getBlob(mediaType)\n    }\n  if (window.HTMLCanvasElement && !CanvasPrototype.toBlob) {\n    if (CanvasPrototype.mozGetAsFile) {\n      CanvasPrototype.toBlob = function (callback, type, quality) {\n        var self = this\n        setTimeout(function () {\n          if (quality && CanvasPrototype.toDataURL && dataURLtoBlob) {\n            callback(dataURLtoBlob(self.toDataURL(type, quality)))\n          } else {\n            callback(self.mozGetAsFile('blob', type))\n          }\n        })\n      }\n    } else if (CanvasPrototype.toDataURL && dataURLtoBlob) {\n      if (CanvasPrototype.msToBlob) {\n        CanvasPrototype.toBlob = function (callback, type, quality) {\n          var self = this\n          setTimeout(function () {\n            if (\n              ((type && type !== 'image/png') || quality) &&\n              CanvasPrototype.toDataURL &&\n              dataURLtoBlob\n            ) {\n              callback(dataURLtoBlob(self.toDataURL(type, quality)))\n            } else {\n              callback(self.msToBlob(type))\n            }\n          })\n        }\n      } else {\n        CanvasPrototype.toBlob = function (callback, type, quality) {\n          var self = this\n          setTimeout(function () {\n            callback(dataURLtoBlob(self.toDataURL(type, quality)))\n          })\n        }\n      }\n    }\n  }\n  if (typeof define === 'function' && define.amd) {\n    define(function () {\n      return dataURLtoBlob\n    })\n  } else if (typeof module === 'object' && module.exports) {\n    module.exports = dataURLtoBlob\n  } else {\n    window.dataURLtoBlob = dataURLtoBlob\n  }\n})(window)\n","vimeo/player.min.js":"/*! @vimeo/player v2.16.4 | (c) 2022 Vimeo | MIT License | https://github.com/vimeo/player.js */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):((e=\"undefined\"!=typeof globalThis?globalThis:e||self).Vimeo=e.Vimeo||{},e.Vimeo.Player=t())}(this,function(){\"use strict\";function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,\"value\"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var e=\"undefined\"!=typeof global&&\"[object global]\"==={}.toString.call(global);function i(e,t){return 0===e.indexOf(t.toLowerCase())?e:\"\".concat(t.toLowerCase()).concat(e.substr(0,1).toUpperCase()).concat(e.substr(1))}function l(e){return/^(https?:)?\\/\\/((player|www)\\.)?vimeo\\.com(?=$|\\/)/.test(e)}function u(e){var t=0<arguments.length&&void 0!==e?e:{},n=t.id,e=t.url,t=n||e;if(!t)throw new Error(\"An id or url must be passed, either in an options object or as a data-vimeo-id or data-vimeo-url attribute.\");if(e=t,!isNaN(parseFloat(e))&&isFinite(e)&&Math.floor(e)==e)return\"https://vimeo.com/\".concat(t);if(l(t))return t.replace(\"http:\",\"https:\");if(n)throw new TypeError(\"\u201c\".concat(n,\"\u201d is not a valid video id.\"));throw new TypeError(\"\u201c\".concat(t,\"\u201d is not a vimeo.com url.\"))}var t=void 0!==Array.prototype.indexOf,Player=\"undefined\"!=typeof window&&void 0!==window.postMessage;if(!(e||t&&Player))throw new Error(\"Sorry, the Vimeo Player API is not available in this browser.\");var n,o,a=\"undefined\"!=typeof globalThis?globalThis:\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:{};function c(){if(void 0===this)throw new TypeError(\"Constructor WeakMap requires 'new'\");if(o(this,\"_id\",\"_WeakMap_\"+f()+\".\"+f()),0<arguments.length)throw new TypeError(\"WeakMap iterable is not supported\")}function s(e,t){if(!d(e)||!n.call(e,\"_id\"))throw new TypeError(t+\" method called on incompatible receiver \"+typeof e)}function f(){return Math.random().toString().substring(2)}function d(e){return Object(e)===e}(Player=\"undefined\"!=typeof self?self:\"undefined\"!=typeof window?window:a).WeakMap||(n=Object.prototype.hasOwnProperty,Player.WeakMap=((o=function(e,t,n){Object.defineProperty?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:n}):e[t]=n})(c.prototype,\"delete\",function(e){if(s(this,\"delete\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)&&(delete e[this._id],!0)}),o(c.prototype,\"get\",function(e){if(s(this,\"get\"),d(e)){var t=e[this._id];return t&&t[0]===e?t[1]:void 0}}),o(c.prototype,\"has\",function(e){if(s(this,\"has\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)}),o(c.prototype,\"set\",function(e,t){if(s(this,\"set\"),!d(e))throw new TypeError(\"Invalid value used as weak map key\");var n=e[this._id];return n&&n[0]===e?n[1]=t:o(e,this._id,[e,t]),this}),o(c,\"_polyfill\",!0),c));var h,m=(function(e){var t,n,r;r=function(){var t,n,r,o,i,e=Object.prototype.toString,a=\"undefined\"!=typeof setImmediate?function(e){return setImmediate(e)}:setTimeout;try{Object.defineProperty({},\"x\",{}),t=function(e,t,n,r){return Object.defineProperty(e,t,{value:n,writable:!0,configurable:!1!==r})}}catch(e){t=function(e,t,n){return e[t]=n,e}}function u(e,t){this.fn=e,this.self=t,this.next=void 0}function l(e,t){y.add(e,t),n=n||a(y.drain)}function c(e){var t,n=typeof e;return\"function\"==typeof(t=null!=e&&(\"object\"==n||\"function\"==n)?e.then:t)&&t}function s(){for(var e=0;e<this.chain.length;e++)!function(e,t,n){var r,o;try{!1===t?n.reject(e.msg):(r=!0===t?e.msg:t.call(void 0,e.msg))===n.promise?n.reject(TypeError(\"Promise-chain cycle\")):(o=c(r))?o.call(r,n.resolve,n.reject):n.resolve(r)}catch(e){n.reject(e)}}(this,1===this.state?this.chain[e].success:this.chain[e].failure,this.chain[e]);this.chain.length=0}function f(e){var n,r=this;if(!r.triggered){r.triggered=!0,r.def&&(r=r.def);try{(n=c(e))?l(function(){var t=new m(r);try{n.call(e,function(){f.apply(t,arguments)},function(){d.apply(t,arguments)})}catch(e){d.call(t,e)}}):(r.msg=e,r.state=1,0<r.chain.length&&l(s,r))}catch(e){d.call(new m(r),e)}}}function d(e){var t=this;t.triggered||(t.triggered=!0,(t=t.def?t.def:t).msg=e,t.state=2,0<t.chain.length&&l(s,t))}function h(e,n,r,o){for(var t=0;t<n.length;t++)!function(t){e.resolve(n[t]).then(function(e){r(t,e)},o)}(t)}function m(e){this.def=e,this.triggered=!1}function v(e){this.promise=e,this.state=0,this.triggered=!1,this.chain=[],this.msg=void 0}function p(e){if(\"function\"!=typeof e)throw TypeError(\"Not a function\");if(0!==this.__NPO__)throw TypeError(\"Not a promise\");this.__NPO__=1;var r=new v(this);this.then=function(e,t){var n={success:\"function\"!=typeof e||e,failure:\"function\"==typeof t&&t};return n.promise=new this.constructor(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");n.resolve=e,n.reject=t}),r.chain.push(n),0!==r.state&&l(s,r),n.promise},this.catch=function(e){return this.then(void 0,e)};try{e.call(void 0,function(e){f.call(r,e)},function(e){d.call(r,e)})}catch(e){d.call(r,e)}}var y={add:function(e,t){i=new u(e,t),o?o.next=i:r=i,o=i,i=void 0},drain:function(){var e=r;for(r=o=n=void 0;e;)e.fn.call(e.self),e=e.next}},g=t({},\"constructor\",p,!1);return t(p.prototype=g,\"__NPO__\",0,!1),t(p,\"resolve\",function(n){return n&&\"object\"==typeof n&&1===n.__NPO__?n:new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");e(n)})}),t(p,\"reject\",function(n){return new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");t(n)})}),t(p,\"all\",function(t){var a=this;return\"[object Array]\"!=e.call(t)?a.reject(TypeError(\"Not an array\")):0===t.length?a.resolve([]):new a(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");var r=t.length,o=Array(r),i=0;h(a,t,function(e,t){o[e]=t,++i===r&&n(o)},e)})}),t(p,\"race\",function(t){var r=this;return\"[object Array]\"!=e.call(t)?r.reject(TypeError(\"Not an array\")):new r(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");h(r,t,function(e,t){n(t)},e)})}),p},(n=a)[t=\"Promise\"]=n[t]||r(),e.exports&&(e.exports=n[t])}(h={exports:{}}),h.exports),v=new WeakMap;function p(e,t,n){var r=v.get(e.element)||{};t in r||(r[t]=[]),r[t].push(n),v.set(e.element,r)}function y(e,t){return(v.get(e.element)||{})[t]||[]}function g(e,t,n){var r=v.get(e.element)||{};if(!r[t])return!0;if(!n)return r[t]=[],v.set(e.element,r),!0;n=r[t].indexOf(n);return-1!==n&&r[t].splice(n,1),v.set(e.element,r),r[t]&&0===r[t].length}var w=[\"autopause\",\"autoplay\",\"background\",\"byline\",\"color\",\"controls\",\"dnt\",\"height\",\"id\",\"interactive_params\",\"keyboard\",\"loop\",\"maxheight\",\"maxwidth\",\"muted\",\"playsinline\",\"portrait\",\"responsive\",\"speed\",\"texttrack\",\"title\",\"transparent\",\"url\",\"width\"];function b(r,e){return w.reduce(function(e,t){var n=r.getAttribute(\"data-vimeo-\".concat(t));return!n&&\"\"!==n||(e[t]=\"\"===n?1:n),e},1<arguments.length&&void 0!==e?e:{})}function k(e,t){var n=e.html;if(!t)throw new TypeError(\"An element must be provided\");if(null!==t.getAttribute(\"data-vimeo-initialized\"))return t.querySelector(\"iframe\");e=document.createElement(\"div\");return e.innerHTML=n,t.appendChild(e.firstChild),t.setAttribute(\"data-vimeo-initialized\",\"true\"),t.querySelector(\"iframe\")}function E(i,e,t){var a=1<arguments.length&&void 0!==e?e:{},u=2<arguments.length?t:void 0;return new Promise(function(t,n){if(!l(i))throw new TypeError(\"\u201c\".concat(i,\"\u201d is not a vimeo.com url.\"));var e,r=\"https://vimeo.com/api/oembed.json?url=\".concat(encodeURIComponent(i));for(e in a)a.hasOwnProperty(e)&&(r+=\"&\".concat(e,\"=\").concat(encodeURIComponent(a[e])));var o=new(\"XDomainRequest\"in window?XDomainRequest:XMLHttpRequest);o.open(\"GET\",r,!0),o.onload=function(){if(404!==o.status)if(403!==o.status)try{var e=JSON.parse(o.responseText);if(403===e.domain_status_code)return k(e,u),void n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));t(e)}catch(e){n(e)}else n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));else n(new Error(\"\u201c\".concat(i,\"\u201d was not found.\")))},o.onerror=function(){var e=o.status?\" (\".concat(o.status,\")\"):\"\";n(new Error(\"There was an error fetching the embed code from Vimeo\".concat(e,\".\")))},o.send()})}function T(e){function n(e){\"console\"in window&&console.error&&console.error(\"There was an error creating an embed: \".concat(e))}e=0<arguments.length&&void 0!==e?e:document,e=[].slice.call(e.querySelectorAll(\"[data-vimeo-id], [data-vimeo-url]\"));e.forEach(function(t){try{if(null!==t.getAttribute(\"data-vimeo-defer\"))return;var e=b(t);E(u(e),e,t).then(function(e){return k(e,t)}).catch(n)}catch(e){n(e)}})}function P(e){if(\"string\"==typeof e)try{e=JSON.parse(e)}catch(e){return console.warn(e),{}}return e}function _(e,t,n){e.element.contentWindow&&e.element.contentWindow.postMessage&&(t={method:t},void 0!==n&&(t.value=n),8<=(n=parseFloat(navigator.userAgent.toLowerCase().replace(/^.*msie (\\d+).*$/,\"$1\")))&&n<10&&(t=JSON.stringify(t)),e.element.contentWindow.postMessage(t,e.origin))}function M(n,r){var t,e,o,i,a=[];(r=P(r)).event?(\"error\"===r.event&&y(n,r.data.method).forEach(function(e){var t=new Error(r.data.message);t.name=r.data.name,e.reject(t),g(n,r.data.method,e)}),a=y(n,\"event:\".concat(r.event)),t=r.data):r.method&&(e=n,o=r.method,(i=!((i=y(e,o)).length<1)&&(i=i.shift(),g(e,o,i),i))&&(a.push(i),t=r.value)),a.forEach(function(e){try{if(\"function\"==typeof e)return void e.call(n,t);e.resolve(t)}catch(e){}})}var N,F,x,C=new WeakMap,j=new WeakMap,A={},Player=function(){function Player(i){var e,a=this,t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,Player),window.jQuery&&i instanceof jQuery&&(1<i.length&&window.console&&console.warn&&console.warn(\"A jQuery object with multiple elements was passed, using the first element.\"),i=i[0]),\"undefined\"!=typeof document&&\"string\"==typeof i&&(i=document.getElementById(i)),e=i,!Boolean(e&&1===e.nodeType&&\"nodeName\"in e&&e.ownerDocument&&e.ownerDocument.defaultView))throw new TypeError(\"You must pass either a valid element or a valid id.\");if(\"IFRAME\"===i.nodeName||(r=i.querySelector(\"iframe\"))&&(i=r),\"IFRAME\"===i.nodeName&&!l(i.getAttribute(\"src\")||\"\"))throw new Error(\"The player element passed isn\u2019t a Vimeo embed.\");if(C.has(i))return C.get(i);this._window=i.ownerDocument.defaultView,this.element=i,this.origin=\"*\";var n,r=new m(function(r,o){var e;a._onMessage=function(e){if(l(e.origin)&&a.element.contentWindow===e.source){\"*\"===a.origin&&(a.origin=e.origin);var t=P(e.data);if(t&&\"error\"===t.event&&t.data&&\"ready\"===t.data.method){var n=new Error(t.data.message);return n.name=t.data.name,void o(n)}e=t&&\"ready\"===t.event,n=t&&\"ping\"===t.method;if(e||n)return a.element.setAttribute(\"data-ready\",\"true\"),void r();M(a,t)}},a._window.addEventListener(\"message\",a._onMessage),\"IFRAME\"!==a.element.nodeName&&E(u(e=b(i,t)),e,i).then(function(e){var t,n,r=k(e,i);return a.element=r,a._originalElement=i,t=i,n=r,r=v.get(t),v.set(n,r),v.delete(t),C.set(a.element,a),e}).catch(o)});return j.set(this,r),C.set(this.element,this),\"IFRAME\"===this.element.nodeName&&_(this,\"ping\"),A.isEnabled&&(n=function(){return A.exit()},this.fullscreenchangeHandler=function(){(A.isFullscreen?p:g)(a,\"event:exitFullscreen\",n),a.ready().then(function(){_(a,\"fullscreenchange\",A.isFullscreen)})},A.on(\"fullscreenchange\",this.fullscreenchangeHandler)),this}var e,t,n;return e=Player,(t=[{key:\"callMethod\",value:function(n){var r=this,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return new m(function(e,t){return r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n,o)}).catch(t)})}},{key:\"get\",value:function(n){var r=this;return new m(function(e,t){return n=i(n,\"get\"),r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n)}).catch(t)})}},{key:\"set\",value:function(n,r){var o=this;return new m(function(e,t){if(n=i(n,\"set\"),null==r)throw new TypeError(\"There must be a value to set.\");return o.ready().then(function(){p(o,n,{resolve:e,reject:t}),_(o,n,r)}).catch(t)})}},{key:\"on\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(!t)throw new TypeError(\"You must pass a callback function.\");if(\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");0===y(this,\"event:\".concat(e)).length&&this.callMethod(\"addEventListener\",e).catch(function(){}),p(this,\"event:\".concat(e),t)}},{key:\"off\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(t&&\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");g(this,\"event:\".concat(e),t)&&this.callMethod(\"removeEventListener\",e).catch(function(e){})}},{key:\"loadVideo\",value:function(e){return this.callMethod(\"loadVideo\",e)}},{key:\"ready\",value:function(){var e=j.get(this)||new m(function(e,t){t(new Error(\"Unknown player. Probably unloaded.\"))});return m.resolve(e)}},{key:\"addCuePoint\",value:function(e){return this.callMethod(\"addCuePoint\",{time:e,data:1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}})}},{key:\"removeCuePoint\",value:function(e){return this.callMethod(\"removeCuePoint\",e)}},{key:\"enableTextTrack\",value:function(e,t){if(!e)throw new TypeError(\"You must pass a language.\");return this.callMethod(\"enableTextTrack\",{language:e,kind:t})}},{key:\"disableTextTrack\",value:function(){return this.callMethod(\"disableTextTrack\")}},{key:\"pause\",value:function(){return this.callMethod(\"pause\")}},{key:\"play\",value:function(){return this.callMethod(\"play\")}},{key:\"requestFullscreen\",value:function(){return A.isEnabled?A.request(this.element):this.callMethod(\"requestFullscreen\")}},{key:\"exitFullscreen\",value:function(){return A.isEnabled?A.exit():this.callMethod(\"exitFullscreen\")}},{key:\"getFullscreen\",value:function(){return A.isEnabled?m.resolve(A.isFullscreen):this.get(\"fullscreen\")}},{key:\"requestPictureInPicture\",value:function(){return this.callMethod(\"requestPictureInPicture\")}},{key:\"exitPictureInPicture\",value:function(){return this.callMethod(\"exitPictureInPicture\")}},{key:\"getPictureInPicture\",value:function(){return this.get(\"pictureInPicture\")}},{key:\"unload\",value:function(){return this.callMethod(\"unload\")}},{key:\"destroy\",value:function(){var n=this;return new m(function(e){var t;j.delete(n),C.delete(n.element),n._originalElement&&(C.delete(n._originalElement),n._originalElement.removeAttribute(\"data-vimeo-initialized\")),n.element&&\"IFRAME\"===n.element.nodeName&&n.element.parentNode&&(n.element.parentNode.parentNode&&n._originalElement&&n._originalElement!==n.element.parentNode?n.element.parentNode.parentNode.removeChild(n.element.parentNode):n.element.parentNode.removeChild(n.element)),n.element&&\"DIV\"===n.element.nodeName&&n.element.parentNode&&(n.element.removeAttribute(\"data-vimeo-initialized\"),(t=n.element.querySelector(\"iframe\"))&&t.parentNode&&(t.parentNode.parentNode&&n._originalElement&&n._originalElement!==t.parentNode?t.parentNode.parentNode.removeChild(t.parentNode):t.parentNode.removeChild(t))),n._window.removeEventListener(\"message\",n._onMessage),A.isEnabled&&A.off(\"fullscreenchange\",n.fullscreenchangeHandler),e()})}},{key:\"getAutopause\",value:function(){return this.get(\"autopause\")}},{key:\"setAutopause\",value:function(e){return this.set(\"autopause\",e)}},{key:\"getBuffered\",value:function(){return this.get(\"buffered\")}},{key:\"getCameraProps\",value:function(){return this.get(\"cameraProps\")}},{key:\"setCameraProps\",value:function(e){return this.set(\"cameraProps\",e)}},{key:\"getChapters\",value:function(){return this.get(\"chapters\")}},{key:\"getCurrentChapter\",value:function(){return this.get(\"currentChapter\")}},{key:\"getColor\",value:function(){return this.get(\"color\")}},{key:\"setColor\",value:function(e){return this.set(\"color\",e)}},{key:\"getCuePoints\",value:function(){return this.get(\"cuePoints\")}},{key:\"getCurrentTime\",value:function(){return this.get(\"currentTime\")}},{key:\"setCurrentTime\",value:function(e){return this.set(\"currentTime\",e)}},{key:\"getDuration\",value:function(){return this.get(\"duration\")}},{key:\"getEnded\",value:function(){return this.get(\"ended\")}},{key:\"getLoop\",value:function(){return this.get(\"loop\")}},{key:\"setLoop\",value:function(e){return this.set(\"loop\",e)}},{key:\"setMuted\",value:function(e){return this.set(\"muted\",e)}},{key:\"getMuted\",value:function(){return this.get(\"muted\")}},{key:\"getPaused\",value:function(){return this.get(\"paused\")}},{key:\"getPlaybackRate\",value:function(){return this.get(\"playbackRate\")}},{key:\"setPlaybackRate\",value:function(e){return this.set(\"playbackRate\",e)}},{key:\"getPlayed\",value:function(){return this.get(\"played\")}},{key:\"getQualities\",value:function(){return this.get(\"qualities\")}},{key:\"getQuality\",value:function(){return this.get(\"quality\")}},{key:\"setQuality\",value:function(e){return this.set(\"quality\",e)}},{key:\"getSeekable\",value:function(){return this.get(\"seekable\")}},{key:\"getSeeking\",value:function(){return this.get(\"seeking\")}},{key:\"getTextTracks\",value:function(){return this.get(\"textTracks\")}},{key:\"getVideoEmbedCode\",value:function(){return this.get(\"videoEmbedCode\")}},{key:\"getVideoId\",value:function(){return this.get(\"videoId\")}},{key:\"getVideoTitle\",value:function(){return this.get(\"videoTitle\")}},{key:\"getVideoWidth\",value:function(){return this.get(\"videoWidth\")}},{key:\"getVideoHeight\",value:function(){return this.get(\"videoHeight\")}},{key:\"getVideoUrl\",value:function(){return this.get(\"videoUrl\")}},{key:\"getVolume\",value:function(){return this.get(\"volume\")}},{key:\"setVolume\",value:function(e){return this.set(\"volume\",e)}}])&&r(e.prototype,t),n&&r(e,n),Player}();return e||(N=function(){for(var e,t=[[\"requestFullscreen\",\"exitFullscreen\",\"fullscreenElement\",\"fullscreenEnabled\",\"fullscreenchange\",\"fullscreenerror\"],[\"webkitRequestFullscreen\",\"webkitExitFullscreen\",\"webkitFullscreenElement\",\"webkitFullscreenEnabled\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"webkitRequestFullScreen\",\"webkitCancelFullScreen\",\"webkitCurrentFullScreenElement\",\"webkitCancelFullScreen\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"mozRequestFullScreen\",\"mozCancelFullScreen\",\"mozFullScreenElement\",\"mozFullScreenEnabled\",\"mozfullscreenchange\",\"mozfullscreenerror\"],[\"msRequestFullscreen\",\"msExitFullscreen\",\"msFullscreenElement\",\"msFullscreenEnabled\",\"MSFullscreenChange\",\"MSFullscreenError\"]],n=0,r=t.length,o={};n<r;n++)if((e=t[n])&&e[1]in document){for(n=0;n<e.length;n++)o[t[0][n]]=e[n];return o}return!1}(),F={fullscreenchange:N.fullscreenchange,fullscreenerror:N.fullscreenerror},x={request:function(o){return new Promise(function(e,t){function n(){x.off(\"fullscreenchange\",n),e()}x.on(\"fullscreenchange\",n);var r=(o=o||document.documentElement)[N.requestFullscreen]();r instanceof Promise&&r.then(n).catch(t)})},exit:function(){return new Promise(function(t,e){var n,r;x.isFullscreen?(n=function e(){x.off(\"fullscreenchange\",e),t()},x.on(\"fullscreenchange\",n),(r=document[N.exitFullscreen]())instanceof Promise&&r.then(n).catch(e)):t()})},on:function(e,t){e=F[e];e&&document.addEventListener(e,t)},off:function(e,t){e=F[e];e&&document.removeEventListener(e,t)}},Object.defineProperties(x,{isFullscreen:{get:function(){return Boolean(document[N.fullscreenElement])}},element:{enumerable:!0,get:function(){return document[N.fullscreenElement]}},isEnabled:{enumerable:!0,get:function(){return Boolean(document[N.fullscreenEnabled])}}}),A=x,T(),function(e){var r=0<arguments.length&&void 0!==e?e:document;window.VimeoPlayerResizeEmbeds_||(window.VimeoPlayerResizeEmbeds_=!0,window.addEventListener(\"message\",function(e){if(l(e.origin)&&e.data&&\"spacechange\"===e.data.event)for(var t=r.querySelectorAll(\"iframe\"),n=0;n<t.length;n++)if(t[n].contentWindow===e.source){t[n].parentElement.style.paddingBottom=\"\".concat(e.data.data[0].bottom,\"px\");break}}))}()),Player});\n","vimeo/vimeo-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'vimeo'\n], function (Player) {\n    'use strict';\n\n    window.Vimeo = window.Vimeo || {\n        'Player': Player\n    };\n});\n","Magento_Wishlist/js/add-to-wishlist.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.addToWishlist', {\n        options: {\n            bundleInfo: 'div.control [name^=bundle_option]',\n            configurableInfo: '.super-attribute-select',\n            groupedInfo: '#super-product-table input',\n            downloadableInfo: '#downloadable-links-list input',\n            customOptionsInfo: '.product-custom-option',\n            qtyInfo: '#qty',\n            actionElement: '[data-action=\"add-to-wishlist\"]',\n            productListWrapper: '.product-item-info',\n            productPageWrapper: '.product-info-main'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._bind();\n            this._triggerWishlistFormUpdate();\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            var options = this.options,\n                dataUpdateFunc = '_updateWishlistData',\n                validateProductQty = '_validateWishlistQty',\n                changeCustomOption = 'change ' + options.customOptionsInfo,\n                changeQty = 'change ' + options.qtyInfo,\n                updateWishlist = 'click ' + options.actionElement,\n                events = {},\n                key;\n\n            if ('productType' in options) {\n                if (typeof options.productType === 'string') {\n                    options.productType = [options.productType];\n                }\n            } else {\n                options.productType = [];\n            }\n\n            events[changeCustomOption] = dataUpdateFunc;\n            events[changeQty] = dataUpdateFunc;\n            events[updateWishlist] = validateProductQty;\n\n            for (key in options.productType) {\n                if (options.productType.hasOwnProperty(key) && options.productType[key] + 'Info' in options) {\n                    events['change ' + options[options.productType[key] + 'Info']] = dataUpdateFunc;\n                }\n            }\n            this._on(events);\n        },\n\n        /**\n         * Update wishlist on page load and before submit\n         *\n         * @private\n         */\n        _triggerWishlistFormUpdate: function () {\n            var key;\n\n            $(this.options.qtyInfo).trigger('change');\n            for (key in this.options.productType) {\n                if (this.options.productType.hasOwnProperty(key)\n                    && this.options.productType[key] + 'Info' in this.options) {\n                    $(this.options[this.options.productType[key] + 'Info']).trigger('change');\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _updateWishlistData: function (event) {\n            var dataToAdd = {},\n                isFileUploaded = false,\n                handleObjSelector = null,\n                self = this;\n\n            if (event.handleObj.selector == this.options.qtyInfo) { //eslint-disable-line eqeqeq\n                this._updateAddToWishlistButton({}, event);\n                event.stopPropagation();\n\n                return;\n            }\n\n            handleObjSelector = $(event.currentTarget).closest('form').find(event.handleObj.selector);\n\n            handleObjSelector.each(function (index, element) {\n                if ($(element).is('input[type=text]') ||\n                    $(element).is('input[type=email]') ||\n                    $(element).is('input[type=number]') ||\n                    $(element).is('input[type=hidden]') ||\n                    $(element).is('input[type=checkbox]:checked') ||\n                    $(element).is('input[type=radio]:checked') ||\n                    $(element).is('textarea') ||\n                    $('#' + element.id + ' option:selected').length\n                ) {\n                    if ($(element).data('selector') || $(element).attr('name')) {\n                        dataToAdd = $.extend({}, dataToAdd, self._getElementData(element));\n                    }\n\n                    return;\n                }\n\n                if ($(element).is('input[type=file]') && $(element).val()) {\n                    isFileUploaded = true;\n                }\n            });\n\n            if (isFileUploaded) {\n                this.bindFormSubmit();\n            }\n            this._updateAddToWishlistButton(dataToAdd, event);\n            event.stopPropagation();\n        },\n\n        /**\n         * @param {Object} dataToAdd\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _updateAddToWishlistButton: function (dataToAdd, event) {\n            var self = this,\n                buttons = this._getAddToWishlistButton(event);\n\n            buttons.each(function (index, element) {\n                var params = $(element).data('post'),\n                    currentTarget = event.currentTarget,\n                    targetElement,\n                    targetValue;\n\n                if (!params) {\n                    params = {\n                        'data': {}\n                    };\n                } else if ($(currentTarget).data('selector') || $(currentTarget).attr('name')) {\n                    targetElement = self._getElementData(currentTarget);\n                    targetValue = Object.keys(targetElement)[0];\n\n                    if (params.data.hasOwnProperty(targetValue) && !dataToAdd.hasOwnProperty(targetValue)) {\n                        delete params.data[targetValue];\n                    }\n                }\n\n                params.data = $.extend({}, params.data, dataToAdd, {\n                    'qty': $(self.options.qtyInfo).val()\n                });\n                $(element).data('post', params);\n            });\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _getAddToWishlistButton: function (event) {\n            var productListWrapper = $(event.currentTarget).closest(this.options.productListWrapper);\n\n            if (productListWrapper.length) {\n                return productListWrapper.find(this.options.actionElement);\n            }\n\n            return $(this.options.actionElement);\n        },\n\n        /**\n         * @param {Object} array1\n         * @param {Object} array2\n         * @return {Object}\n         * @private\n         * @deprecated\n         */\n        _arrayDiffByKeys: function (array1, array2) {\n            var result = {};\n\n            $.each(array1, function (key, value) {\n                if (key.indexOf('option') === -1) {\n                    return;\n                }\n\n                if (!array2[key]) {\n                    result[key] = value;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * @param {HTMLElement} element\n         * @return {Object}\n         * @private\n         */\n        _getElementData: function (element) {\n            var data, elementName, elementValue;\n\n            element = $(element);\n            data = {};\n            elementName = element.data('selector') ? element.data('selector') : element.attr('name');\n            elementValue = element.val();\n\n            if (element.is('select[multiple]') && elementValue !== null) {\n                if (elementName.substr(elementName.length - 2) == '[]') { //eslint-disable-line eqeqeq\n                    elementName = elementName.substring(0, elementName.length - 2);\n                }\n                $.each(elementValue, function (key, option) {\n                    data[elementName + '[' + option + ']'] = option;\n                });\n            } else if (elementName.substr(elementName.length - 2) == '[]') { //eslint-disable-line eqeqeq, max-depth\n                elementName = elementName.substring(0, elementName.length - 2);\n\n                data[elementName + '[' + elementValue + ']'] = elementValue;\n            } else {\n                data[elementName] = elementValue;\n            }\n\n            return data;\n        },\n\n        /**\n         * @param {Object} params\n         * @param {Object} dataToAdd\n         * @private\n         * @deprecated\n         */\n        _removeExcessiveData: function (params, dataToAdd) {\n            var dataToRemove = this._arrayDiffByKeys(params.data, dataToAdd);\n\n            $.each(dataToRemove, function (key) {\n                delete params.data[key];\n            });\n        },\n\n        /**\n         * Unbind previous form submit listener.\n         */\n        unbindFormSubmit: function () {\n            $('[data-action=\"add-to-wishlist\"]').off('click');\n        },\n\n        /**\n         * Bind form submit.\n         */\n        bindFormSubmit: function () {\n            var self = this;\n\n            // Prevents double handlers and duplicate requests to add to Wishlist\n            this.unbindFormSubmit();\n\n            $('[data-action=\"add-to-wishlist\"]').on('click', function (event) {\n                var element, params, form, action;\n\n                event.stopPropagation();\n                event.preventDefault();\n\n                element = $('input[type=file]' + self.options.customOptionsInfo);\n                params = $(event.currentTarget).data('post');\n                form = $(element).closest('form');\n                action = params.action;\n\n                if (params.data.id) {\n                    $('<input>', {\n                        type: 'hidden',\n                        name: 'id',\n                        value: params.data.id\n                    }).appendTo(form);\n                }\n\n                if (params.data.uenc) {\n                    action += 'uenc/' + params.data.uenc;\n                }\n\n                $(form).attr('action', action).trigger('submit');\n            });\n        },\n\n        /**\n         * Validate product quantity before updating Wish List\n         *\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _validateWishlistQty: function (event) {\n            var element = $(this.options.qtyInfo);\n\n            if (!(element.validation() && element.validation('isValid'))) {\n                event.preventDefault();\n                event.stopPropagation();\n\n                return;\n            }\n\n            this._triggerWishlistFormUpdate();\n        }\n    });\n\n    return $.mage.addToWishlist;\n});\n","Magento_Wishlist/js/wishlist.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/validation/validation',\n    'mage/dataPost'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.wishlist', {\n        options: {\n            dataAttribute: 'item-id',\n            nameFormat: 'qty[{0}]',\n            btnRemoveSelector: '[data-role=remove]',\n            qtySelector: '[data-role=qty]',\n            addToCartSelector: '[data-role=tocart]',\n            addAllToCartSelector: '[data-role=all-tocart]',\n            commentInputType: 'textarea',\n            infoList: false\n        },\n\n        /**\n         * Bind handlers to events.\n         */\n        _create: function () {\n            var _this = this;\n\n            if (!this.options.infoList) {\n                this.element\n                    .on('addToCart', function (event, context) {\n                        var urlParams;\n\n                        event.stopPropagation(event);\n                        $(context).data('stop-processing', true);\n                        urlParams = _this._getItemsToCartParams(\n                            $(context).parents('[data-row=product-item]').find(_this.options.addToCartSelector)\n                        );\n                        $.mage.dataPost().postData(urlParams);\n\n                        return false;\n                    })\n                    .on('click', this.options.btnRemoveSelector, $.proxy(function (event) {\n                        event.preventDefault();\n                        $.mage.dataPost().postData($(event.currentTarget).data('post-remove'));\n                    }, this))\n                    .on('click', this.options.addToCartSelector, $.proxy(this._beforeAddToCart, this))\n                    .on('click', this.options.addAllToCartSelector, $.proxy(this._addAllWItemsToCart, this))\n                    .on('focusin focusout', this.options.commentInputType, $.proxy(this._focusComment, this));\n            }\n\n            // Setup validation for the form\n            this.element.mage('validation', {\n                /** @inheritdoc */\n                errorPlacement: function (error, element) {\n                    error.insertAfter(element.next());\n                }\n            });\n        },\n\n        /**\n         * Process data before add to cart\n         *\n         * - update item's qty value.\n         *\n         * @param {Event} event\n         * @private\n         */\n        _beforeAddToCart: function (event) {\n            var elem = $(event.currentTarget),\n                itemId = elem.data(this.options.dataAttribute),\n                qtyName = $.validator.format(this.options.nameFormat, itemId),\n                qtyValue = elem.parents().find('[name=\"' + qtyName + '\"]').val(),\n                params = elem.data('post');\n\n            if (params) {\n                params.data = $.extend({}, params.data, {\n                    'qty': qtyValue\n                });\n                elem.data('post', params);\n            }\n        },\n\n        /**\n         * Add wish list items to cart.\n         * @private\n         * @param {jQuery} elem - clicked 'add to cart' button\n         */\n        _getItemsToCartParams: function (elem) {\n            var itemId, url, qtyName, qtyValue;\n\n            if (elem.data(this.options.dataAttribute)) {\n                itemId = elem.data(this.options.dataAttribute);\n                url = this.options.addToCartUrl;\n                qtyName = $.validator.format(this.options.nameFormat, itemId);\n                qtyValue = elem.parents().find('[name=\"' + qtyName + '\"]').val();\n                url.data.item = itemId;\n                url.data.qty = qtyValue;\n\n                return url;\n            }\n        },\n\n        /**\n         * Add all wish list items to cart\n         * @private\n         */\n        _addAllWItemsToCart: function () {\n            var urlParams = this.options.addAllToCartUrl,\n                separator = urlParams.action.indexOf('?') >= 0 ? '&' : '?';\n\n            this.element.find(this.options.qtySelector).each(function (index, element) {\n                urlParams.action += separator + $(element).prop('name') + '=' + encodeURIComponent($(element).val());\n                separator = '&';\n            });\n            $.mage.dataPost().postData(urlParams);\n        },\n\n        /**\n         * Toggle comment string.\n         * @private\n         * @param {Event} e\n         */\n        _focusComment: function (e) {\n            var commentInput = e.currentTarget;\n\n            if (commentInput.value === '' || commentInput.value === this.options.commentString) {\n                commentInput.value = commentInput.value === this.options.commentString ?\n                    '' : this.options.commentString;\n            }\n        }\n    });\n\n    // Extension for mage.wishlist - Select All checkbox\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            selectAllCheckbox: '#select-all',\n            parentContainer: '#wishlist-table'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var selectAllCheckboxParent, checkboxCount;\n\n            this._super();\n            selectAllCheckboxParent = $(this.options.selectAllCheckbox).parents(this.options.parentContainer);\n            checkboxCount = selectAllCheckboxParent\n                .find('input:checkbox:not(' + this.options.selectAllCheckbox + ')').length;\n            // If Select all checkbox is checked, check all item checkboxes, if unchecked, uncheck all item checkboxes\n            $(this.options.selectAllCheckbox).on('click', function () {\n                selectAllCheckboxParent.find('input:checkbox').attr('checked', $(this).is(':checked'));\n            });\n            // If all item checkboxes are checked, check select all checkbox,\n            // if not all item checkboxes are checked, uncheck select all checkbox\n            selectAllCheckboxParent.on(\n                'click',\n                'input:checkbox:not(' + this.options.selectAllCheckbox + ')',\n                $.proxy(function () {\n                    var checkedCount = selectAllCheckboxParent\n                        .find('input:checkbox:checked:not(' + this.options.selectAllCheckbox + ')').length;\n\n                    $(this.options.selectAllCheckbox).attr('checked', checkboxCount === checkedCount);\n                }, this)\n            );\n        }\n    });\n    // Extension for mage.wishlist info add to cart\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        /** @inheritdoc */\n        _create: function () {\n            this._super();\n\n            if (this.options.infoList) {\n                this.element.on('addToCart', $.proxy(function (event, context) {\n                    this.element.find('input:checkbox').attr('checked', false);\n                    $(context).closest('tr').find('input:checkbox').attr('checked', true);\n                    this.element.trigger('submit');\n                }, this));\n                this._checkBoxValidate();\n            }\n        },\n\n        /**\n         * validate checkbox selection.\n         * @private\n         */\n        _checkBoxValidate: function () {\n            this.element.validation({\n                submitHandler: $.proxy(function (form) {\n                    if ($(form).find('input:checkbox:checked').length) {\n                        form.submit();\n                    } else {\n                        alert({\n                            content: this.options.checkBoxValidationMessage\n                        });\n                    }\n                }, this)\n            });\n        }\n    });\n\n    // Extension for mage.wishlist - Add Wishlist item to Gift Registry\n    $.widget('mage.wishlist', $.mage.wishlist, {\n        options: {\n            formTmplSelector: '#form-tmpl',\n            formTmplId: '#wishlist-hidden-form'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var _this = this;\n\n            this._super();\n            this.element.on('click', '[data-wishlist-to-giftregistry]', function () {\n                var json = $(this).data('wishlist-to-giftregistry'),\n                    tmplJson = {\n                        item: json.itemId,\n                        entity: json.entity,\n                        url: json.url\n                    },\n                    html = mageTemplate(_this.options.formTmplSelector, {\n                        data: tmplJson\n                    });\n\n                $(html).appendTo('body');\n                $(_this.options.formTmplId).trigger('submit');\n            });\n        }\n    });\n\n    return $.mage.wishlist;\n});\n","Magento_Wishlist/js/search.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.wishlistSearch', {\n\n        /**\n         * Bind handlers to events\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(this._toggleForm, this));\n        },\n\n        /**\n         * Toggle Form\n         * @private\n         */\n        _toggleForm: function () {\n            switch (this.element.val()) {\n                case 'name':\n                    $(this.options.emailFormSelector).hide();\n                    $(this.options.nameFormSelector).show();\n                    break;\n\n                case 'email':\n                    $(this.options.nameFormSelector).hide();\n                    $(this.options.emailFormSelector).show();\n                    break;\n                default:\n                    $(this.options.emailFormSelector).add(this.options.nameFormSelector).hide();\n            }\n        }\n    });\n\n    return $.mage.wishlistSearch;\n});\n","Magento_Wishlist/js/product/addtowishlist-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Get request POST data.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['extension_attributes']['wishlist_button'].url);\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_wishlist', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Wishlist/js/view/wishlist.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.wishlist = customerData.get('wishlist');\n        }\n    });\n});\n","Magento_Cookie/js/require-cookie.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/mage',\n    'mage/translate'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.requireCookie', {\n        options: {\n            event: 'click',\n            noCookieUrl: 'enable-cookies',\n            triggers: ['.action.login', '.action.submit'],\n            isRedirectCmsPage: true\n        },\n\n        /**\n         * Constructor\n         * @private\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * This method binds elements found in this widget.\n         * @private\n         */\n        _bind: function () {\n            var events = {};\n\n            $.each(this.options.triggers, function (index, value) {\n                events['click ' + value] = '_checkCookie';\n            });\n            this._on(events);\n        },\n\n        /**\n         * This method set the url for the redirect.\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _checkCookie: function (event) {\n            if (navigator.cookieEnabled) {\n                return;\n            }\n\n            event.preventDefault();\n\n            if (this.options.isRedirectCmsPage) {\n                window.location = this.options.noCookieUrl;\n            } else {\n                alert({\n                    content: $.mage.__('Cookies are disabled in your browser.')\n                });\n            }\n        }\n    });\n\n    return $.mage.requireCookie;\n});\n","Magento_Cookie/js/notices.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/cookies'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.cookieNotices', {\n        /** @inheritdoc */\n        _create: function () {\n            if ($.mage.cookies.get(this.options.cookieName)) {\n                this.element.hide();\n            } else {\n                this.element.show();\n            }\n            $(this.options.cookieAllowButtonSelector).on('click', $.proxy(function () {\n                var cookieExpires = new Date(new Date().getTime() + this.options.cookieLifetime * 1000);\n\n                $.mage.cookies.set(this.options.cookieName, JSON.stringify(this.options.cookieValue), {\n                    expires: cookieExpires\n                });\n\n                if ($.mage.cookies.get(this.options.cookieName)) {\n                    this.element.hide();\n                    $(document).trigger('user:allowed:save:cookie');\n                } else {\n                    window.location.href = this.options.noCookiesUrl;\n                }\n            }, this));\n        }\n    });\n\n    return $.mage.cookieNotices;\n});\n","Magento_Customer/js/password-strength-indicator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/zxcvbn',\n    'mage/translate',\n    'mage/validation'\n], function ($, zxcvbn, $t) {\n    'use strict';\n\n    $.widget('mage.passwordStrengthIndicator', {\n        options: {\n            cache: {},\n            passwordSelector: '[type=password]',\n            passwordStrengthMeterSelector: '[data-role=password-strength-meter]',\n            passwordStrengthMeterLabelSelector: '[data-role=password-strength-meter-label]',\n            formSelector: 'form',\n            emailSelector: 'input[type=\"email\"]'\n        },\n\n        /**\n         * Widget initialization\n         * @private\n         */\n        _create: function () {\n            this.options.cache.input = $(this.options.passwordSelector, this.element);\n            this.options.cache.meter = $(this.options.passwordStrengthMeterSelector, this.element);\n            this.options.cache.label = $(this.options.passwordStrengthMeterLabelSelector, this.element);\n\n            // We need to look outside the module for backward compatibility, since someone can already use the module.\n            // @todo Narrow this selector in 2.3 so it doesn't accidentally finds the email field from the\n            // newsletter email field or any other \"email\" field.\n            this.options.cache.email = $(this.options.formSelector).find(this.options.emailSelector);\n            this._bind();\n        },\n\n        /**\n         * Event binding, will monitor change, keyup and paste events.\n         * @private\n         */\n        _bind: function () {\n            this._on(this.options.cache.input, {\n                'change': this._calculateStrength,\n                'keyup': this._calculateStrength,\n                'paste': this._calculateStrength\n            });\n\n            if (this.options.cache.email.length) {\n                this._on(this.options.cache.email, {\n                    'change': this._calculateStrength,\n                    'keyup': this._calculateStrength,\n                    'paste': this._calculateStrength\n                });\n            }\n        },\n\n        /**\n         * Calculate password strength\n         * @private\n         */\n        _calculateStrength: function () {\n            var password = this._getPassword(),\n                isEmpty = password.length === 0,\n                zxcvbnScore,\n                displayScore,\n                isValid;\n\n            // Display score is based on combination of whether password is empty, valid, and zxcvbn strength\n            if (isEmpty) {\n                displayScore = 0;\n            } else {\n                this.options.cache.input.rules('add', {\n                    'password-not-equal-to-user-name': this.options.cache.email.val()\n                });\n\n                // We should only perform this check in case there is an email field on screen\n                if (this.options.cache.email.length &&\n                    password.toLowerCase() === this.options.cache.email.val().toLowerCase()) {\n                    displayScore = 1;\n                } else {\n                    isValid = $.validator.validateSingleElement(this.options.cache.input);\n                    zxcvbnScore = zxcvbn(password).score;\n                    displayScore = isValid && zxcvbnScore > 0 ? zxcvbnScore : 1;\n                }\n            }\n\n            // Update label\n            this._displayStrength(displayScore);\n        },\n\n        /**\n         * Display strength\n         * @param {Number} displayScore\n         * @private\n         */\n        _displayStrength: function (displayScore) {\n            var strengthLabel = '',\n                className;\n\n            switch (displayScore) {\n                case 0:\n                    strengthLabel = $t('No Password');\n                    className = 'password-none';\n                    break;\n\n                case 1:\n                    strengthLabel = $t('Weak');\n                    className = 'password-weak';\n                    break;\n\n                case 2:\n                    strengthLabel = $t('Medium');\n                    className = 'password-medium';\n                    break;\n\n                case 3:\n                    strengthLabel = $t('Strong');\n                    className = 'password-strong';\n                    break;\n\n                case 4:\n                    strengthLabel = $t('Very Strong');\n                    className = 'password-very-strong';\n                    break;\n            }\n\n            this.options.cache.meter\n                .removeClass()\n                .addClass(className);\n            this.options.cache.label.text(strengthLabel);\n        },\n\n        /**\n         * Get password value\n         * @returns {*}\n         * @private\n         */\n        _getPassword: function () {\n            return this.options.cache.input.val();\n        }\n    });\n\n    return $.mage.passwordStrengthIndicator;\n});\n","Magento_Customer/js/customer-data.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'Magento_Customer/js/section-config',\n    'mage/url',\n    'mage/storage',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, sectionConfig, url) {\n    'use strict';\n\n    var options = {},\n        storage,\n        storageInvalidation,\n        invalidateCacheBySessionTimeOut,\n        invalidateCacheByCloseCookieSession,\n        dataProvider,\n        buffer,\n        customerData,\n        deferred = $.Deferred();\n\n    url.setBaseUrl(window.BASE_URL);\n    options.sectionLoadUrl = url.build('customer/section/load');\n\n    /**\n     * @param {Object} invalidateOptions\n     */\n    invalidateCacheBySessionTimeOut = function (invalidateOptions) {\n        var date;\n\n        if (new Date($.localStorage.get('mage-cache-timeout')) < new Date()) {\n            storage.removeAll();\n        }\n        date = new Date(Date.now() + parseInt(invalidateOptions.cookieLifeTime, 10) * 1000);\n        $.localStorage.set('mage-cache-timeout', date);\n    };\n\n    /**\n     * Invalidate Cache By Close Cookie Session\n     */\n    invalidateCacheByCloseCookieSession = function () {\n        var isLoggedIn = parseInt(options.isLoggedIn, 10) || 0;\n\n        if (!$.cookieStorage.isSet('mage-cache-sessid')) {\n            storage.removeAll();\n        }\n\n        if (!$.localStorage.isSet('mage-customer-login')) {\n            $.localStorage.set('mage-customer-login', isLoggedIn);\n        }\n        if ($.localStorage.get('mage-customer-login') !== isLoggedIn) {\n            $.localStorage.set('mage-customer-login', isLoggedIn);\n            storage.removeAll();\n        }\n\n        $.cookieStorage.set('mage-cache-sessid', true);\n    };\n\n    dataProvider = {\n\n        /**\n         * @param {Object} sectionNames\n         * @return {Object}\n         */\n        getFromStorage: function (sectionNames) {\n            var result = {};\n\n            _.each(sectionNames, function (sectionName) {\n                result[sectionName] = storage.get(sectionName);\n            });\n\n            return result;\n        },\n\n        /**\n         * @param {Object} sectionNames\n         * @param {Boolean} forceNewSectionTimestamp\n         * @return {*}\n         */\n        getFromServer: function (sectionNames, forceNewSectionTimestamp) {\n            var parameters;\n\n            sectionNames = sectionConfig.filterClientSideSections(sectionNames);\n            parameters = _.isArray(sectionNames) && sectionNames.indexOf('*') < 0 ? {\n                sections: sectionNames.join(',')\n            } : [];\n            parameters['force_new_section_timestamp'] = forceNewSectionTimestamp;\n\n            return $.getJSON(options.sectionLoadUrl, parameters).fail(function (jqXHR) {\n                throw new Error(jqXHR);\n            });\n        }\n    };\n\n    /**\n     * @param {Function} target\n     * @param {String} sectionName\n     * @return {*}\n     */\n    ko.extenders.disposableCustomerData = function (target, sectionName) {\n        var sectionDataIds, newSectionDataIds = {};\n\n        target.subscribe(function () {\n            setTimeout(function () {\n                storage.remove(sectionName);\n                sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n                _.each(sectionDataIds, function (data, name) {\n                    if (name !== sectionName) {\n                        newSectionDataIds[name] = data;\n                    }\n                });\n                $.cookieStorage.set('section_data_ids', newSectionDataIds);\n            }, 3000);\n        });\n\n        return target;\n    };\n\n    buffer = {\n        data: {},\n\n        /**\n         * @param {String} sectionName\n         */\n        bind: function (sectionName) {\n            this.data[sectionName] = ko.observable({});\n        },\n\n        /**\n         * @param {String} sectionName\n         * @return {Object}\n         */\n        get: function (sectionName) {\n            if (!this.data[sectionName]) {\n                this.bind(sectionName);\n            }\n\n            return this.data[sectionName];\n        },\n\n        /**\n         * @return {Array}\n         */\n        keys: function () {\n            return _.keys(this.data);\n        },\n\n        /**\n         * @param {String} sectionName\n         * @param {Object} sectionData\n         */\n        notify: function (sectionName, sectionData) {\n            if (!this.data[sectionName]) {\n                this.bind(sectionName);\n            }\n            this.data[sectionName](sectionData);\n        },\n\n        /**\n         * @param {Object} sections\n         */\n        update: function (sections) {\n            var sectionId = 0,\n                sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n\n            _.each(sections, function (sectionData, sectionName) {\n                sectionId = sectionData['data_id'];\n                sectionDataIds[sectionName] = sectionId;\n                storage.set(sectionName, sectionData);\n                storageInvalidation.remove(sectionName);\n                buffer.notify(sectionName, sectionData);\n            });\n            $.cookieStorage.set('section_data_ids', sectionDataIds);\n        },\n\n        /**\n         * @param {Object} sections\n         */\n        remove: function (sections) {\n            _.each(sections, function (sectionName) {\n                storage.remove(sectionName);\n\n                if (!sectionConfig.isClientSideSection(sectionName)) {\n                    storageInvalidation.set(sectionName, true);\n                }\n            });\n        }\n    };\n\n    customerData = {\n\n        /**\n         * Customer data initialization\n         */\n        init: function () {\n            var expiredSectionNames = this.getExpiredSectionNames();\n\n            if (expiredSectionNames.length > 0) {\n                _.each(dataProvider.getFromStorage(storage.keys()), function (sectionData, sectionName) {\n                    buffer.notify(sectionName, sectionData);\n                });\n                this.reload(expiredSectionNames, false);\n            } else {\n                _.each(dataProvider.getFromStorage(storage.keys()), function (sectionData, sectionName) {\n                    buffer.notify(sectionName, sectionData);\n                });\n\n                if (!_.isEmpty(storageInvalidation.keys())) {\n                    this.reload(storageInvalidation.keys(), false);\n                }\n            }\n\n            if (!_.isEmpty($.cookieStorage.get('section_data_clean'))) {\n                this.reload(sectionConfig.getSectionNames(), true);\n                $.cookieStorage.set('section_data_clean', '');\n            }\n        },\n\n        /**\n         * Storage init\n         */\n        initStorage: function () {\n            $.cookieStorage.setConf({\n                path: '/',\n                expires: new Date(Date.now() + parseInt(options.cookieLifeTime, 10) * 1000)\n            });\n\n            if (options.cookieDomain) {\n                $.cookieStorage.setConf({\n                    domain: options.cookieDomain\n                });\n            }\n\n            storage = $.initNamespaceStorage('mage-cache-storage').localStorage;\n            storageInvalidation = $.initNamespaceStorage('mage-cache-storage-section-invalidation').localStorage;\n        },\n\n        /**\n         * Retrieve the list of sections that has expired since last page reload.\n         *\n         * Sections can expire due to lifetime constraints or due to inconsistent storage information\n         * (validated by cookie data).\n         *\n         * @return {Array}\n         */\n        getExpiredSectionNames: function () {\n            var expiredSectionNames = [],\n                cookieSectionTimestamps = $.cookieStorage.get('section_data_ids') || {},\n                sectionLifetime = options.expirableSectionLifetime * 60,\n                currentTimestamp = Math.floor(Date.now() / 1000),\n                sectionData;\n\n            // process sections that can expire due to lifetime constraints\n            _.each(options.expirableSectionNames, function (sectionName) {\n                sectionData = storage.get(sectionName);\n\n                if (typeof sectionData === 'object' && sectionData['data_id'] + sectionLifetime <= currentTimestamp) {\n                    expiredSectionNames.push(sectionName);\n                }\n            });\n\n            // process sections that can expire due to storage information inconsistency\n            _.each(cookieSectionTimestamps, function (cookieSectionTimestamp, sectionName) {\n                if (storage !== undefined) {\n                    sectionData = storage.get(sectionName);\n                }\n\n                if (typeof sectionData === 'undefined' ||\n                    typeof sectionData === 'object' &&\n                    cookieSectionTimestamp !== sectionData['data_id']\n                ) {\n                    expiredSectionNames.push(sectionName);\n                }\n            });\n\n            //remove expired section names of previously installed/enable modules\n            expiredSectionNames = _.intersection(expiredSectionNames, sectionConfig.getSectionNames());\n\n            return _.uniq(expiredSectionNames);\n        },\n\n        /**\n         * Check if some sections have to be reloaded.\n         *\n         * @deprecated Use getExpiredSectionNames instead.\n         *\n         * @return {Boolean}\n         */\n        needReload: function () {\n            var expiredSectionNames = this.getExpiredSectionNames();\n\n            return expiredSectionNames.length > 0;\n        },\n\n        /**\n         * Retrieve the list of expired keys.\n         *\n         * @deprecated Use getExpiredSectionNames instead.\n         *\n         * @return {Array}\n         */\n        getExpiredKeys: function () {\n            return this.getExpiredSectionNames();\n        },\n\n        /**\n         * @param {String} sectionName\n         * @return {*}\n         */\n        get: function (sectionName) {\n            return buffer.get(sectionName);\n        },\n\n        /**\n         * @param {String} sectionName\n         * @param {Object} sectionData\n         */\n        set: function (sectionName, sectionData) {\n            var data = {};\n\n            data[sectionName] = sectionData;\n            buffer.update(data);\n        },\n\n        /**\n         * Avoid using this function directly 'cause of possible performance drawbacks.\n         * Each customer section reload brings new non-cached ajax request.\n         *\n         * @param {Array} sectionNames\n         * @param {Boolean} forceNewSectionTimestamp\n         * @return {*}\n         */\n        reload: function (sectionNames, forceNewSectionTimestamp) {\n            return dataProvider.getFromServer(sectionNames, forceNewSectionTimestamp).done(function (sections) {\n                $(document).trigger('customer-data-reload', [sectionNames]);\n                buffer.update(sections);\n            });\n        },\n\n        /**\n         * @param {Array} sectionNames\n         */\n        invalidate: function (sectionNames) {\n            var sectionDataIds,\n                sectionsNamesForInvalidation;\n\n            sectionsNamesForInvalidation = _.contains(sectionNames, '*') ? sectionConfig.getSectionNames() :\n                sectionNames;\n\n            $(document).trigger('customer-data-invalidate', [sectionsNamesForInvalidation]);\n            buffer.remove(sectionsNamesForInvalidation);\n            sectionDataIds = $.cookieStorage.get('section_data_ids') || {};\n\n            // Invalidate section in cookie (increase version of section with 1000)\n            _.each(sectionsNamesForInvalidation, function (sectionName) {\n                if (!sectionConfig.isClientSideSection(sectionName)) {\n                    sectionDataIds[sectionName] += 1000;\n                }\n            });\n            $.cookieStorage.set('section_data_ids', sectionDataIds);\n        },\n\n        /**\n         * Checks if customer data is initialized.\n         *\n         * @returns {jQuery.Deferred}\n         */\n        getInitCustomerData: function () {\n            return deferred.promise();\n        },\n\n        /**\n         * Reload sections on ajax complete\n         *\n         * @param {Object} jsonResponse\n         * @param {Object} settings\n         */\n        onAjaxComplete: function (jsonResponse, settings) {\n            var sections,\n                redirects;\n\n            if (settings.type.match(/post|put|delete/i)) {\n                sections = sectionConfig.getAffectedSections(settings.url);\n\n                if (sections && sections.length) {\n                    this.invalidate(sections);\n                    redirects = ['redirect', 'backUrl'];\n\n                    if (_.isObject(jsonResponse) && !_.isEmpty(_.pick(jsonResponse, redirects))) { //eslint-disable-line\n                        return;\n                    }\n                    this.reload(sections, true);\n                }\n            }\n        },\n\n        /**\n         * @param {Object} settings\n         * @constructor\n         */\n        'Magento_Customer/js/customer-data': function (settings) {\n            options = settings;\n            customerData.initStorage();\n            invalidateCacheBySessionTimeOut(settings);\n            invalidateCacheByCloseCookieSession();\n            customerData.init();\n            deferred.resolve();\n        }\n    };\n\n    /**\n     * Events listener\n     */\n    $(document).on('ajaxComplete', function (event, xhr, settings) {\n        customerData.onAjaxComplete(xhr.responseJSON, settings);\n    });\n\n    /**\n     * Events listener\n     */\n    $(document).on('submit', function (event) {\n        var sections;\n\n        if (event.target.method.match(/post|put|delete/i)) {\n            sections = sectionConfig.getAffectedSections(event.target.action);\n\n            if (sections) {\n                customerData.invalidate(sections);\n            }\n        }\n    });\n\n    return customerData;\n});\n","Magento_Customer/js/customer-global-session-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data'\n], function ($, customerData) {\n    'use strict';\n\n    return function () {\n        var customer;\n\n        // When the session is available, this customer menu will be available\n        if ($('.customer-menu').length > 0) {\n            customer = customerData.get('customer');\n\n            customerData.getInitCustomerData().done(function () {\n                // Check if the customer data is set in local storage, if not reload data from server\n                if (!customer().firstname) {\n                    customerData.reload([], false);\n                }\n            });\n        }\n    };\n});\n","Magento_Customer/js/invalidation-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'Magento_Customer/js/customer-data'\n], function (_, Element, customerData) {\n    'use strict';\n\n    return Element.extend({\n        /**\n         * Initialize object\n         */\n        initialize: function () {\n            this._super();\n            this.process(customerData);\n        },\n\n        /**\n         * Process all rules in loop, each rule can invalidate some sections in customer data\n         *\n         * @param {Object} customerDataObject\n         */\n        process: function (customerDataObject) {\n            _.each(this.invalidationRules, function (rule, ruleName) {\n                _.each(rule, function (ruleArgs, rulePath) {\n                    require([rulePath], function (Rule) {\n                        var currentRule = new Rule(ruleArgs);\n\n                        if (!_.isFunction(currentRule.process)) {\n                            throw new Error('Rule ' + ruleName + ' should implement invalidationProcessor interface');\n                        }\n                        currentRule.process(customerDataObject);\n                    });\n                });\n            });\n        }\n    });\n});\n","Magento_Customer/js/address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    $.widget('mage.address', {\n        /**\n         * Options common to all instances of this widget.\n         * @type {Object}\n         */\n        options: {\n            deleteConfirmMessage: $.mage.__('Are you sure you want to delete this address?')\n        },\n\n        /**\n         * Bind event handlers for adding and deleting addresses.\n         * @private\n         */\n        _create: function () {\n            var options         = this.options,\n                addAddress      = options.addAddress,\n                deleteAddress   = options.deleteAddress;\n\n            if (addAddress) {\n                $(document).on('click', addAddress, this._addAddress.bind(this));\n            }\n\n            if (deleteAddress) {\n                $(document).on('click', deleteAddress, this._deleteAddress.bind(this));\n            }\n        },\n\n        /**\n         * Add a new address.\n         * @private\n         */\n        _addAddress: function () {\n            window.location = this.options.addAddressLocation;\n        },\n\n        /**\n         * Delete the address whose id is specified in a data attribute after confirmation from the user.\n         * @private\n         * @param {jQuery.Event} e\n         * @return {Boolean}\n         */\n        _deleteAddress: function (e) {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteConfirmMessage,\n                actions: {\n\n                    /** @inheritdoc */\n                    confirm: function () {\n                        if (typeof $(e.target).parent().data('address') !== 'undefined') {\n                            window.location = self.options.deleteUrlPrefix + $(e.target).parent().data('address') +\n                                '/form_key/' + $.mage.cookies.get('form_key');\n                        } else {\n                            window.location = self.options.deleteUrlPrefix + $(e.target).data('address') +\n                                '/form_key/' + $.mage.cookies.get('form_key');\n                        }\n                    }\n                }\n            });\n\n            return false;\n        }\n    });\n\n    return $.mage.address;\n});\n","Magento_Customer/js/addressValidation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'Magento_Checkout/js/model/postcode-validator',\n    'jquery-ui-modules/widget',\n    'validation'\n], function ($, __, utils, $t, postCodeValidator) {\n    'use strict';\n\n    $.widget('mage.addressValidation', {\n        options: {\n            selectors: {\n                button: '[data-action=save-address]',\n                zip: '#zip',\n                country: 'select[name=\"country_id\"]:visible'\n            }\n        },\n\n        zipInput: null,\n        countrySelect: null,\n\n        /**\n         * Validation creation\n         *\n         * @protected\n         */\n        _create: function () {\n            var button = $(this.options.selectors.button, this.element);\n\n            this.zipInput = $(this.options.selectors.zip, this.element);\n            this.countrySelect = $(this.options.selectors.country, this.element);\n\n            this.element.validation({\n\n                /**\n                 * Submit Handler\n                 * @param {Element} form - address form\n                 */\n                submitHandler: function (form) {\n\n                    button.attr('disabled', true);\n                    form.submit();\n                }\n            });\n\n            this._addPostCodeValidation();\n        },\n\n        /**\n         * Add postcode validation\n         *\n         * @protected\n         */\n        _addPostCodeValidation: function () {\n            var self = this;\n\n            this.zipInput.on('keyup', __.debounce(function (event) {\n                    var valid = self._validatePostCode(event.target.value);\n\n                    self._renderValidationResult(valid);\n                }, 500)\n            );\n\n            this.countrySelect.on('change', function () {\n                var valid = self._validatePostCode(self.zipInput.val());\n\n                self._renderValidationResult(valid);\n            });\n        },\n\n        /**\n         * Validate post code value.\n         *\n         * @protected\n         * @param {String} postCode - post code\n         * @return {Boolean} Whether is post code valid\n         */\n        _validatePostCode: function (postCode) {\n            var countryId = this.countrySelect.val();\n\n            if (postCode === null) {\n                return true;\n            }\n\n            return postCodeValidator.validate(postCode, countryId, this.options.postCodes);\n        },\n\n        /**\n         * Renders warning messages for invalid post code.\n         *\n         * @protected\n         * @param {Boolean} valid\n         */\n        _renderValidationResult: function (valid) {\n            var warnMessage,\n                alertDiv = this.zipInput.next();\n\n            if (!valid) {\n                warnMessage = $t('Provided Zip/Postal Code seems to be invalid.');\n\n                if (postCodeValidator.validatedPostCodeExample.length) {\n                    warnMessage += $t(' Example: ') + postCodeValidator.validatedPostCodeExample.join('; ') + '. ';\n                }\n                warnMessage += $t('If you believe it is the right one you can ignore this notice.');\n            }\n\n            alertDiv.children(':first').text(warnMessage);\n\n            if (valid) {\n                alertDiv.hide();\n            } else {\n                alertDiv.show();\n            }\n        }\n    });\n\n    return $.mage.addressValidation;\n});\n","Magento_Customer/js/logout-redirect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (data) {\n        $($.mage.redirect(data.url, 'assign', 5000));\n    };\n});\n","Magento_Customer/js/change-email-password.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.changeEmailPassword', {\n        options: {\n            changeEmailSelector: '[data-role=change-email]',\n            changePasswordSelector: '[data-role=change-password]',\n            mainContainerSelector: '[data-container=change-email-password]',\n            titleSelector: '[data-title=change-email-password]',\n            emailContainerSelector: '[data-container=change-email]',\n            newPasswordContainerSelector: '[data-container=new-password]',\n            confirmPasswordContainerSelector: '[data-container=confirm-password]',\n            currentPasswordSelector: '[data-input=current-password]',\n            emailSelector: '[data-input=change-email]',\n            newPasswordSelector: '[data-input=new-password]',\n            confirmPasswordSelector: '[data-input=confirm-password]'\n        },\n\n        /**\n         * Create widget\n         * @private\n         */\n        _create: function () {\n            this.element.on('change', $.proxy(function () {\n                this._checkChoice();\n            }, this));\n\n            this._checkChoice();\n            this._bind();\n        },\n\n        /**\n         * Event binding, will monitor change, keyup and paste events.\n         * @private\n         */\n        _bind: function () {\n            this._on($(this.options.emailSelector), {\n                'change': this._updatePasswordFieldWithEmailValue,\n                'keyup': this._updatePasswordFieldWithEmailValue,\n                'paste': this._updatePasswordFieldWithEmailValue\n            });\n        },\n\n        /**\n         * Check choice\n         * @private\n         */\n        _checkChoice: function () {\n            if ($(this.options.changeEmailSelector).is(':checked') &&\n                $(this.options.changePasswordSelector).is(':checked')) {\n                this._showAll();\n            } else if ($(this.options.changeEmailSelector).is(':checked')) {\n                this._showEmail();\n            } else if ($(this.options.changePasswordSelector).is(':checked')) {\n                this._showPassword();\n            } else {\n                this._hideAll();\n            }\n        },\n\n        /**\n         * Show email and password input fields\n         * @private\n         */\n        _showAll: function () {\n            $(this.options.titleSelector).html(this.options.titleChangeEmailAndPassword);\n\n            $(this.options.mainContainerSelector).show();\n            $(this.options.emailContainerSelector).show();\n            $(this.options.newPasswordContainerSelector).show();\n            $(this.options.confirmPasswordContainerSelector).show();\n\n            $(this.options.currentPasswordSelector).attr('data-validate', '{required:true}').prop('disabled', false);\n            $(this.options.emailSelector).attr('data-validate', '{required:true}').prop('disabled', false);\n            this._updatePasswordFieldWithEmailValue();\n            $(this.options.confirmPasswordSelector).attr(\n                'data-validate',\n                '{required:true, equalTo:\"' + this.options.newPasswordSelector + '\"}'\n            ).prop('disabled', false);\n        },\n\n        /**\n         * Hide email and password input fields\n         * @private\n         */\n        _hideAll: function () {\n            $(this.options.mainContainerSelector).hide();\n            $(this.options.emailContainerSelector).hide();\n            $(this.options.newPasswordContainerSelector).hide();\n            $(this.options.confirmPasswordContainerSelector).hide();\n\n            $(this.options.currentPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.emailSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.newPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.confirmPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Show email input fields\n         * @private\n         */\n        _showEmail: function () {\n            this._showAll();\n            $(this.options.titleSelector).html(this.options.titleChangeEmail);\n\n            $(this.options.newPasswordContainerSelector).hide();\n            $(this.options.confirmPasswordContainerSelector).hide();\n\n            $(this.options.newPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n            $(this.options.confirmPasswordSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Show password input fields\n         * @private\n         */\n        _showPassword: function () {\n            this._showAll();\n            $(this.options.titleSelector).html(this.options.titleChangePassword);\n\n            $(this.options.emailContainerSelector).hide();\n\n            $(this.options.emailSelector).removeAttr('data-validate').prop('disabled', true);\n        },\n\n        /**\n         * Update password validation rules with email input field value\n         * @private\n         */\n        _updatePasswordFieldWithEmailValue: function () {\n            $(this.options.newPasswordSelector).attr(\n                'data-validate',\n                '{required:true, ' +\n                '\\'validate-customer-password\\':true, ' +\n                '\\'password-not-equal-to-user-name\\':\\'' + $(this.options.emailSelector).val() + '\\'}'\n            ).prop('disabled', false);\n        }\n    });\n\n    return $.mage.changeEmailPassword;\n});\n","Magento_Customer/js/section-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['underscore'], function (_) {\n    'use strict';\n\n    var baseUrls = [],\n        sections = [],\n        clientSideSections = [],\n        sectionNames = [],\n        canonize;\n\n    /**\n     * @param {String} url\n     * @return {String}\n     */\n    canonize = function (url) {\n        var route = url;\n\n        _.some(baseUrls, function (baseUrl) {\n            route = url.replace(baseUrl, '');\n\n            return route !== url;\n        });\n\n        return route.replace(/^\\/?index.php\\/?/, '').toLowerCase();\n    };\n\n    return {\n        /**\n         * Returns a list of sections which should be invalidated for given URL.\n         * @param {String} url - URL which was requested.\n         * @return {Object} - List of sections to invalidate.\n         */\n        getAffectedSections: function (url) {\n            var route = canonize(url),\n                actions = _.find(sections, function (val, section) {\n                    var matched;\n\n                    // Covers the case where \"*\" works as a glob pattern.\n                    if (section.indexOf('*') >= 0) {\n                        section = section.replace(/\\*/g, '[^/]+') + '$';\n                        matched = route.match(section);\n\n                        return matched && matched[0] === route;\n                    }\n\n                    return route.indexOf(section) === 0;\n                });\n\n            return _.union(_.toArray(actions), sections['*']);\n        },\n\n        /**\n         * Filters the list of given sections to the ones defined as client side.\n         * @param {Object} allSections - List of sections to check.\n         * @return {Object} - List of filtered sections.\n         */\n        filterClientSideSections: function (allSections) {\n            return _.difference(allSections, clientSideSections);\n        },\n\n        /**\n         * Tells if section is defined as client side.\n         * @param {String} sectionName - Name of the section to check.\n         * @return {Boolean}\n         */\n        isClientSideSection: function (sectionName) {\n            return _.contains(clientSideSections, sectionName);\n        },\n\n        /**\n         * Returns array of section names.\n         * @returns {Array}\n         */\n        getSectionNames: function () {\n            return sectionNames;\n        },\n\n        /**\n         * @param {Object} options\n         * @constructor\n         */\n        'Magento_Customer/js/section-config': function (options) {\n            baseUrls = options.baseUrls;\n            sections = options.sections;\n            clientSideSections = options.clientSideSections;\n            sectionNames = options.sectionNames;\n        }\n    };\n});\n","Magento_Customer/js/validation.js":"define([\n    'jquery',\n    'moment',\n    'mageUtils',\n    'jquery/validate',\n    'validation',\n    'mage/translate'\n], function ($, moment, utils) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-date',\n        function (value, element, params) {\n            var dateFormat = utils.normalizeDate(params.dateFormat);\n\n            if (value === '') {\n                return true;\n            }\n\n            return moment(value, dateFormat, true).isValid();\n        },\n        $.mage.__('Invalid date')\n    );\n\n    $.validator.addMethod(\n        'validate-dob',\n        function (value, element, params) {\n            var dateFormat = utils.convertToMomentFormat(params.dateFormat);\n\n            if (value === '') {\n                return true;\n            }\n\n            return moment(value, dateFormat).isBefore(moment());\n        },\n        $.mage.__('The Date of Birth should not be greater than today.')\n    );\n});\n","Magento_Customer/js/checkout-balance.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.checkoutBalance', {\n        /**\n         * Initialize store credit events\n         * @private\n         */\n        _create: function () {\n            this.eventData = {\n                price: this.options.balance,\n                totalPrice: 0\n            };\n            this.element.on('change', $.proxy(function (e) {\n                if ($(e.target).is(':checked')) {\n                    this.eventData.price = -1 * this.options.balance;\n                } else {\n                    if (this.options.amountSubstracted) { //eslint-disable-line no-lonely-if\n                        this.eventData.price = parseFloat(this.options.usedAmount);\n                        this.options.amountSubstracted = false;\n                    } else {\n                        this.eventData.price = parseFloat(this.options.balance);\n                    }\n                }\n                this.element.trigger('updateCheckoutPrice', this.eventData);\n            }, this));\n        }\n    });\n\n    return $.mage.checkoutBalance;\n});\n","Magento_Customer/js/show-password.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent'\n], function ($, Component) {\n    'use strict';\n\n    return Component.extend({\n        passwordSelector: '',\n        passwordInputType: 'password',\n        textInputType: 'text',\n\n        defaults: {\n            template: 'Magento_Customer/show-password',\n            isPasswordVisible: false\n        },\n\n        /**\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['isPasswordVisible']);\n\n            this.isPasswordVisible.subscribe(function (isChecked) {\n                this._showPassword(isChecked);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Show/Hide password\n         * @private\n         */\n        _showPassword: function (isChecked) {\n            $(this.passwordSelector).attr('type',\n                isChecked ? this.textInputType : this.passwordInputType\n            );\n        }\n    });\n});\n","Magento_Customer/js/block-submit-on-send.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (config) {\n        var dataForm = $('#' + config.formId);\n\n        dataForm.on('submit', function () {\n            $(this).find(':submit').attr('disabled', 'disabled');\n\n            if (this.isValid === false) {\n                $(this).find(':submit').prop('disabled', false);\n            }\n            this.isValid = true;\n        });\n        dataForm.on('invalid-form.validate', function () {\n            $(this).find(':submit').prop('disabled', false);\n            this.isValid = false;\n        });\n    };\n});\n","Magento_Customer/js/invalidation-rules/website-rule.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiClass'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n\n        defaults: {\n            scopeConfig: {}\n        },\n\n        /**\n         * Takes website id from current customer data and compare it with current website id\n         * If customer belongs to another scope, we need to invalidate current section\n         *\n         * @param {Object} customerData\n         */\n        process: function (customerData) {\n            var customer = customerData.get('customer');\n\n            if (this.scopeConfig && customer() &&\n                ~~customer().websiteId !== ~~this.scopeConfig.websiteId && ~~customer().websiteId !== 0) {\n                customerData.reload(['customer']);\n            }\n        }\n    });\n});\n","Magento_Customer/js/action/login.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/storage',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Customer/js/customer-data',\n    'mage/translate'\n], function ($, storage, globalMessageList, customerData, $t) {\n    'use strict';\n\n    var callbacks = [],\n\n        /**\n         * @param {Object} loginData\n         * @param {String} redirectUrl\n         * @param {*} isGlobal\n         * @param {Object} messageContainer\n         */\n        action = function (loginData, redirectUrl, isGlobal, messageContainer) {\n            messageContainer = messageContainer || globalMessageList;\n            let customerLoginUrl = 'customer/ajax/login';\n\n            if (loginData.customerLoginUrl) {\n                customerLoginUrl = loginData.customerLoginUrl;\n                delete loginData.customerLoginUrl;\n            }\n\n            return storage.post(\n                customerLoginUrl,\n                JSON.stringify(loginData),\n                isGlobal\n            ).done(function (response) {\n                if (response.errors) {\n                    messageContainer.addErrorMessage(response);\n                    callbacks.forEach(function (callback) {\n                        callback(loginData);\n                    });\n                } else {\n                    callbacks.forEach(function (callback) {\n                        callback(loginData);\n                    });\n                    customerData.invalidate(['customer']);\n\n                    if (response.redirectUrl) {\n                        window.location.href = response.redirectUrl;\n                    } else if (redirectUrl) {\n                        window.location.href = redirectUrl;\n                    } else {\n                        location.reload();\n                    }\n                }\n            }).fail(function () {\n                messageContainer.addErrorMessage({\n                    'message': $t('Could not authenticate. Please try again later')\n                });\n                callbacks.forEach(function (callback) {\n                    callback(loginData);\n                });\n            });\n        };\n\n    /**\n     * @param {Function} callback\n     */\n    action.registerLoginCallback = function (callback) {\n        callbacks.push(callback);\n    };\n\n    return action;\n});\n","Magento_Customer/js/action/check-email-availability.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mage/storage',\n    'Magento_Checkout/js/model/url-builder'\n], function (storage, urlBuilder) {\n    'use strict';\n\n    return function (deferred, email) {\n        return storage.post(\n            urlBuilder.createUrl('/customers/isEmailAvailable', {}),\n            JSON.stringify({\n                customerEmail: email\n            }),\n            false\n        ).done(function (isEmailAvailable) {\n            if (isEmailAvailable) {\n                deferred.resolve();\n            } else {\n                deferred.reject();\n            }\n        }).fail(function () {\n            deferred.reject();\n        });\n    };\n});\n","Magento_Customer/js/model/authentication-popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal'\n], function ($, modal) {\n    'use strict';\n\n    return {\n        modalWindow: null,\n\n        /**\n         * Create popUp window for provided element\n         *\n         * @param {HTMLElement} element\n         */\n        createPopUp: function (element) {\n            var options = {\n                'type': 'popup',\n                'modalClass': 'popup-authentication',\n                'focus': '[name=username]',\n                'responsive': true,\n                'innerScroll': true,\n                'trigger': '.proceed-to-checkout',\n                'buttons': []\n            };\n\n            this.modalWindow = element;\n            modal(options, $(this.modalWindow));\n        },\n\n        /** Show login popup window */\n        showModal: function () {\n            $(this.modalWindow).modal('openModal').trigger('contentUpdated');\n        }\n    };\n});\n","Magento_Customer/js/model/address-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    './customer-addresses'\n], function (ko, defaultProvider) {\n    'use strict';\n\n    return ko.observableArray(defaultProvider.getAddressItems());\n});\n","Magento_Customer/js/model/customer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    './address-list'\n], function ($, ko, _, addressList) {\n    'use strict';\n\n    var isLoggedIn = ko.observable(window.isCustomerLoggedIn),\n        customerData = {};\n\n    if (isLoggedIn()) {\n        customerData = window.customerData;\n    } else {\n        customerData = {};\n    }\n\n    return {\n        customerData: customerData,\n        customerDetails: {},\n        isLoggedIn: isLoggedIn,\n\n        /**\n         * @param {Boolean} flag\n         */\n        setIsLoggedIn: function (flag) {\n            isLoggedIn(flag);\n        },\n\n        /**\n         * @return {Array}\n         */\n        getBillingAddressList: function () {\n            return addressList();\n        },\n\n        /**\n         * @return {Array}\n         */\n        getShippingAddressList: function () {\n            return addressList();\n        },\n\n        /**\n         * @param {String} fieldName\n         * @param {*} value\n         */\n        setDetails: function (fieldName, value) {\n            if (fieldName) {\n                this.customerDetails[fieldName] = value;\n            }\n        },\n\n        /**\n         * @param {String} fieldName\n         * @return {*}\n         */\n        getDetails: function (fieldName) {\n            if (fieldName) {\n                if (this.customerDetails.hasOwnProperty(fieldName)) {\n                    return this.customerDetails[fieldName];\n                }\n\n                return undefined;\n            }\n\n            return this.customerDetails;\n        },\n\n        /**\n         * @param {Array} address\n         * @return {Number}\n         */\n        addCustomerAddress: function (address) {\n            var fields = [\n                    'customer_id', 'country_id', 'street', 'company', 'telephone', 'fax', 'postcode', 'city',\n                    'firstname', 'lastname', 'middlename', 'prefix', 'suffix', 'vat_id', 'default_billing',\n                    'default_shipping'\n                ],\n                customerAddress = {},\n                hasAddress = 0,\n                existingAddress;\n\n            if (!this.customerData.addresses) {\n                this.customerData.addresses = [];\n            }\n\n            customerAddress = _.pick(address, fields);\n\n            if (address.hasOwnProperty('region_id')) {\n                customerAddress.region = {\n                    'region_id': address['region_id'],\n                    region: address.region\n                };\n            }\n\n            for (existingAddress in this.customerData.addresses) {\n                if (this.customerData.addresses.hasOwnProperty(existingAddress)) {\n                    if (_.isEqual(this.customerData.addresses[existingAddress], customerAddress)) { //eslint-disable-line\n                        hasAddress = existingAddress;\n                        break;\n                    }\n                }\n            }\n\n            if (hasAddress === 0) {\n                return this.customerData.addresses.push(customerAddress) - 1;\n            }\n\n            return hasAddress;\n        },\n\n        /**\n         * @param {*} addressId\n         * @return {Boolean}\n         */\n        setAddressAsDefaultBilling: function (addressId) {\n            if (this.customerData.addresses[addressId]) {\n                this.customerData.addresses[addressId]['default_billing'] = 1;\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {*} addressId\n         * @return {Boolean}\n         */\n        setAddressAsDefaultShipping: function (addressId) {\n            if (this.customerData.addresses[addressId]) {\n                this.customerData.addresses[addressId]['default_shipping'] = 1;\n\n                return true;\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Customer/js/model/customer-addresses.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'ko',\n    './customer/address'\n], function ($, ko, Address) {\n    'use strict';\n\n    var isLoggedIn = ko.observable(window.isCustomerLoggedIn);\n\n    return {\n        /**\n         * @return {Array}\n         */\n        getAddressItems: function () {\n            var items = [],\n                customerData = window.customerData;\n\n            if (isLoggedIn()) {\n                if (Object.keys(customerData).length) {\n                    $.each(customerData.addresses, function (key, item) {\n                        items.push(new Address(item));\n                    });\n                }\n            }\n\n            return items;\n        }\n    };\n});\n","Magento_Customer/js/model/customer/address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['underscore'], function (_) {\n    'use strict';\n\n    /**\n     * Returns new address object.\n     *\n     * @param {Object} addressData\n     * @return {Object}\n     */\n    return function (addressData) {\n        var regionId;\n\n        if (addressData.region['region_id'] && addressData.region['region_id'] !== '0') {\n            regionId = addressData.region['region_id'] + '';\n        }\n\n        return {\n            customerAddressId: addressData.id,\n            email: addressData.email,\n            countryId: addressData['country_id'],\n            regionId: regionId,\n            regionCode: addressData.region['region_code'],\n            region: addressData.region.region,\n            customerId: addressData['customer_id'],\n            street: addressData.street,\n            company: addressData.company,\n            telephone: addressData.telephone,\n            fax: addressData.fax,\n            postcode: addressData.postcode,\n            city: addressData.city,\n            firstname: addressData.firstname,\n            lastname: addressData.lastname,\n            middlename: addressData.middlename,\n            prefix: addressData.prefix,\n            suffix: addressData.suffix,\n            vatId: addressData['vat_id'],\n            sameAsBilling: addressData['same_as_billing'],\n            saveInAddressBook: addressData['save_in_address_book'],\n            customAttributes: _.toArray(addressData['custom_attributes']).reverse(),\n\n            /**\n             * @return {*}\n             */\n            isDefaultShipping: function () {\n                return addressData['default_shipping'];\n            },\n\n            /**\n             * @return {*}\n             */\n            isDefaultBilling: function () {\n                return addressData['default_billing'];\n            },\n\n            /**\n             * @return {*}\n             */\n            getAddressInline: function () {\n                return addressData.inline;\n            },\n\n            /**\n             * @return {String}\n             */\n            getType: function () {\n                return 'customer-address';\n            },\n\n            /**\n             * @return {String}\n             */\n            getKey: function () {\n                return this.getType() + this.customerAddressId;\n            },\n\n            /**\n             * @return {String}\n             */\n            getCacheKey: function () {\n                return this.getKey();\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            isEditable: function () {\n                return false;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            canUseForBilling: function () {\n                return true;\n            }\n        };\n    };\n});\n","Magento_Customer/js/view/authentication-popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'Magento_Ui/js/form/form',\n    'Magento_Customer/js/action/login',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/model/authentication-popup',\n    'mage/translate',\n    'mage/url',\n    'Magento_Ui/js/modal/alert',\n    'mage/validation'\n], function ($, ko, Component, loginAction, customerData, authenticationPopup, $t, url, alert) {\n    'use strict';\n\n    return Component.extend({\n        registerUrl: window.authenticationPopup.customerRegisterUrl,\n        forgotPasswordUrl: window.authenticationPopup.customerForgotPasswordUrl,\n        autocomplete: window.authenticationPopup.autocomplete,\n        modalWindow: null,\n        isLoading: ko.observable(false),\n\n        defaults: {\n            template: 'Magento_Customer/authentication-popup'\n        },\n\n        /**\n         * Init\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n            url.setBaseUrl(window.authenticationPopup.baseUrl);\n            loginAction.registerLoginCallback(function () {\n                self.isLoading(false);\n            });\n        },\n\n        /**\n         * Sets modal on given HTML element with on demand initialization.\n         */\n        setModalElement: function (element) {\n            var cart = customerData.get('cart');\n\n            if (cart().isGuestCheckoutAllowed === false) {\n                this.createPopup(element);\n            } else {\n                cart.subscribe(function (cartData) {\n                    if (cartData.isGuestCheckoutAllowed === false) {\n                        this.createPopup(element);\n                    }\n                }, this);\n            }\n        },\n\n        /**\n         * Initializes authentication modal on given HTML element.\n         */\n        createPopup: function (element) {\n            if (authenticationPopup.modalWindow == null) {\n                authenticationPopup.createPopUp(element);\n            }\n        },\n\n        /** Is login form enabled for current customer */\n        isActive: function () {\n            var customer = customerData.get('customer');\n\n            return customer() == false; //eslint-disable-line eqeqeq\n        },\n\n        /** Show login popup window */\n        showModal: function () {\n            if (this.modalWindow) {\n                $(this.modalWindow).modal('openModal');\n            } else {\n                alert({\n                    content: $t('Guest checkout is disabled.')\n                });\n            }\n        },\n\n        /**\n         * Provide login action\n         *\n         * @return {Boolean}\n         */\n        login: function (formUiElement, event) {\n            var loginData = {},\n                formElement = $(event.currentTarget),\n                formDataArray = formElement.serializeArray();\n\n            event.stopPropagation();\n            formDataArray.forEach(function (entry) {\n                loginData[entry.name] = entry.value;\n            });\n            loginData['customerLoginUrl'] = window.authenticationPopup.customerLoginUrl;\n            if (formElement.validation() &&\n                formElement.validation('isValid')\n            ) {\n                this.isLoading(true);\n                loginAction(loginData);\n            }\n\n            return false;\n        }\n    });\n});\n","Magento_Customer/js/view/customer.js":"/**\n* Copyright \u00a9 Magento, Inc. All rights reserved.\n* See COPYING.txt for license details.\n*/\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.customer = customerData.get('customer');\n        }\n    });\n});\n","requirejs/domReady.js":"/**\n * @license RequireJS domReady 2.0.1 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.\n * Available via the MIT or new BSD license.\n * see: http://github.com/requirejs/domReady for details\n */\n/*jslint */\n/*global require: false, define: false, requirejs: false,\n  window: false, clearInterval: false, document: false,\n  self: false, setInterval: false */\n\n\ndefine(function () {\n    'use strict';\n\n    var isTop, testDiv, scrollIntervalId,\n        isBrowser = typeof window !== \"undefined\" && window.document,\n        isPageLoaded = !isBrowser,\n        doc = isBrowser ? document : null,\n        readyCalls = [];\n\n    function runCallbacks(callbacks) {\n        var i;\n        for (i = 0; i < callbacks.length; i += 1) {\n            callbacks[i](doc);\n        }\n    }\n\n    function callReady() {\n        var callbacks = readyCalls;\n\n        if (isPageLoaded) {\n            //Call the DOM ready callbacks\n            if (callbacks.length) {\n                readyCalls = [];\n                runCallbacks(callbacks);\n            }\n        }\n    }\n\n    /**\n     * Sets the page as loaded.\n     */\n    function pageLoaded() {\n        if (!isPageLoaded) {\n            isPageLoaded = true;\n            if (scrollIntervalId) {\n                clearInterval(scrollIntervalId);\n            }\n\n            callReady();\n        }\n    }\n\n    if (isBrowser) {\n        if (document.addEventListener) {\n            //Standards. Hooray! Assumption here that if standards based,\n            //it knows about DOMContentLoaded.\n            document.addEventListener(\"DOMContentLoaded\", pageLoaded, false);\n            window.addEventListener(\"load\", pageLoaded, false);\n        } else if (window.attachEvent) {\n            window.attachEvent(\"onload\", pageLoaded);\n\n            testDiv = document.createElement('div');\n            try {\n                isTop = window.frameElement === null;\n            } catch (e) {}\n\n            //DOMContentLoaded approximation that uses a doScroll, as found by\n            //Diego Perini: http://javascript.nwbox.com/IEContentLoaded/,\n            //but modified by other contributors, including jdalton\n            if (testDiv.doScroll && isTop && window.external) {\n                scrollIntervalId = setInterval(function () {\n                    try {\n                        testDiv.doScroll();\n                        pageLoaded();\n                    } catch (e) {}\n                }, 30);\n            }\n        }\n\n        //Check if document is no longer loading, and if so, just trigger page load\n        //listeners. Latest webkit browsers also use \"interactive\", and\n        //will fire the onDOMContentLoaded before \"interactive\" but not after\n        //entering \"interactive\" or \"complete\". More details:\n        //http://dev.w3.org/html5/spec/the-end.html#the-end\n        //http://stackoverflow.com/questions/3665561/document-readystate-of-interactive-vs-ondomcontentloaded\n        //Hmm, this is more complicated on further use, see \"firing too early\"\n        //bug: https://github.com/requirejs/domReady/issues/1\n        //so removing the || document.readyState === \"interactive\" test.\n        //There is still a window.onload binding that should get fired if\n        //DOMContentLoaded is missed.\n        if (document.readyState !== \"loading\") {\n            // Handle it asynchronously to allow scripts the opportunity to delay ready\n            setTimeout(pageLoaded);\n        }\n    }\n\n    /** START OF PUBLIC API **/\n\n    /**\n     * Registers a callback for DOM ready. If DOM is already ready, the\n     * callback is called immediately.\n     * @param {Function} callback\n     */\n    function domReady(callback) {\n        if (isPageLoaded) {\n            callback(doc);\n        } else {\n            readyCalls.push(callback);\n        }\n        return domReady;\n    }\n\n    domReady.version = '2.0.1';\n\n    /**\n     * Loader Plugin API method\n     */\n    domReady.load = function (name, req, onLoad, config) {\n        if (config.isBuild) {\n            onLoad(null);\n        } else {\n            domReady(onLoad);\n        }\n    };\n\n    /** END OF PUBLIC API **/\n\n    return domReady;\n});\n","Magento_CatalogSearch/js/search-terms-log.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils'\n], function ($, utils) {\n    'use strict';\n\n    return function (data) {\n        $.ajax({\n            method: 'GET',\n            url: data.url,\n            data: {\n                'q': utils.getUrlParameters(window.location.href).q\n            }\n        });\n    };\n});\n","Magento_Newsletter/js/subscription-status-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/url'\n], function ($, urlBuilder) {\n    'use strict';\n\n    return function (email, deferred) {\n        return $.getJSON(\n            urlBuilder.build('newsletter/ajax/status'),\n            {\n                email: email\n            }\n        ).done(function (response) {\n            if (response.errors) {\n                deferred.reject();\n            } else {\n                deferred.resolve(response.subscribed);\n            }\n        }).fail(function () {\n            deferred.reject();\n        });\n    };\n});\n","Magento_Newsletter/js/newsletter-sign-up.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiElement',\n    'mage/url',\n    'subscriptionStatusResolver',\n    'mage/validation'\n], function ($, Component, urlBuilder, subscriptionStatusResolver) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            signUpElement: '',\n            submitButton: '',\n            element: null\n        },\n\n        /** @inheritdoc */\n        initialize: function (config, element) {\n            this._super();\n            this.element = element;\n            $(element).on('change', $.proxy(this.updateSignUpStatus, this));\n            this.updateSignUpStatus();\n        },\n\n        /**\n         * Send status request and update subscription element according to result.\n         */\n        updateSignUpStatus: function () {\n            var element = $(this.element),\n                email = element.val(),\n                self = this,\n                newsletterSubscription;\n\n            if ($(self.signUpElement).is(':checked')) {\n                return;\n            }\n\n            if (!email || !$.validator.methods['validate-email'].call(this, email, element)) {\n                return;\n            }\n\n            newsletterSubscription = $.Deferred();\n\n            $(self.submitButton).prop('disabled', true);\n\n            subscriptionStatusResolver(email, newsletterSubscription);\n\n            $.when(newsletterSubscription).done(function (isSubscribed) {\n                if (isSubscribed) {\n                    $(self.signUpElement).prop('checked', true);\n                }\n            }).always(function () {\n                $(self.submitButton).prop('disabled', false);\n            });\n        }\n    });\n});\n","Magento_Reports/js/recently-viewed.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.recentlyViewedProducts', {\n        options: {\n            localStorageKey: 'recently-viewed-products',\n            productBlock: '#widget_viewed_item',\n            viewedContainer: 'ol'\n        },\n\n        /**\n         * Bind events to the appropriate handlers.\n         * @private\n         */\n        _create: function () {\n            var productHtml = $(this.options.productBlock).html(),\n                productSku = $(this.options.productBlock).data('sku'),\n                products = JSON.parse(window.localStorage.getItem(this.options.localStorageKey)),\n                productsLength, maximum, showed, index;\n\n            if (products) {\n                productsLength = products.sku.length;\n                maximum = $(this.element).data('count');\n                showed = 0;\n\n                for (index = 0; index <= productsLength; index++) {\n                    if (products.sku[index] == productSku || showed >= maximum) { //eslint-disable-line\n                        products.sku.splice(index, 1);\n                        products.html.splice(index, 1);\n                    } else {\n                        $(this.element).find(this.options.viewedContainer).append(products.html[index]);\n                        $(this.element).show();\n                        showed++;\n                    }\n                }\n                $(this.element).find(this.options.productBlock).show();\n            } else {\n                products = {};\n                products.sku = [];\n                products.html = [];\n            }\n            products.sku.unshift(productSku);\n            products.html.unshift(productHtml);\n            window.localStorage.setItem(this.options.localStorageKey, JSON.stringify(products));\n        }\n    });\n\n    return $.mage.recentlyViewedProducts;\n});\n","Magento_ProductAlert/js/form-submitter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).trigger('submit');\n    };\n});\n","fotorama/fotorama.js":"/*!\n * Fotorama 4.6.4 | http://fotorama.io/license/\n */\nfotoramaVersion = '4.6.4';\n(function (window, document, location, $, undefined) {\n    \"use strict\";\n    var _fotoramaClass = 'fotorama',\n        _fullscreenClass = 'fotorama__fullscreen',\n\n        wrapClass = _fotoramaClass + '__wrap',\n        wrapCss2Class = wrapClass + '--css2',\n        wrapCss3Class = wrapClass + '--css3',\n        wrapVideoClass = wrapClass + '--video',\n        wrapFadeClass = wrapClass + '--fade',\n        wrapSlideClass = wrapClass + '--slide',\n        wrapNoControlsClass = wrapClass + '--no-controls',\n        wrapNoShadowsClass = wrapClass + '--no-shadows',\n        wrapPanYClass = wrapClass + '--pan-y',\n        wrapRtlClass = wrapClass + '--rtl',\n        wrapOnlyActiveClass = wrapClass + '--only-active',\n        wrapNoCaptionsClass = wrapClass + '--no-captions',\n        wrapToggleArrowsClass = wrapClass + '--toggle-arrows',\n\n        stageClass = _fotoramaClass + '__stage',\n        stageFrameClass = stageClass + '__frame',\n        stageFrameVideoClass = stageFrameClass + '--video',\n        stageShaftClass = stageClass + '__shaft',\n\n        grabClass = _fotoramaClass + '__grab',\n        pointerClass = _fotoramaClass + '__pointer',\n\n        arrClass = _fotoramaClass + '__arr',\n        arrDisabledClass = arrClass + '--disabled',\n        arrPrevClass = arrClass + '--prev',\n        arrNextClass = arrClass + '--next',\n\n        navClass = _fotoramaClass + '__nav',\n        navWrapClass = navClass + '-wrap',\n        navShaftClass = navClass + '__shaft',\n        navShaftVerticalClass = navWrapClass + '--vertical',\n        navShaftListClass = navWrapClass + '--list',\n        navShafthorizontalClass = navWrapClass + '--horizontal',\n        navDotsClass = navClass + '--dots',\n        navThumbsClass = navClass + '--thumbs',\n        navFrameClass = navClass + '__frame',\n\n        fadeClass = _fotoramaClass + '__fade',\n        fadeFrontClass = fadeClass + '-front',\n        fadeRearClass = fadeClass + '-rear',\n\n        shadowClass = _fotoramaClass + '__shadow',\n        shadowsClass = shadowClass + 's',\n        shadowsLeftClass = shadowsClass + '--left',\n        shadowsRightClass = shadowsClass + '--right',\n        shadowsTopClass = shadowsClass + '--top',\n        shadowsBottomClass = shadowsClass + '--bottom',\n\n        activeClass = _fotoramaClass + '__active',\n        selectClass = _fotoramaClass + '__select',\n\n        hiddenClass = _fotoramaClass + '--hidden',\n\n        fullscreenClass = _fotoramaClass + '--fullscreen',\n        fullscreenIconClass = _fotoramaClass + '__fullscreen-icon',\n\n        errorClass = _fotoramaClass + '__error',\n        loadingClass = _fotoramaClass + '__loading',\n        loadedClass = _fotoramaClass + '__loaded',\n        loadedFullClass = loadedClass + '--full',\n        loadedImgClass = loadedClass + '--img',\n\n        grabbingClass = _fotoramaClass + '__grabbing',\n\n        imgClass = _fotoramaClass + '__img',\n        imgFullClass = imgClass + '--full',\n\n        thumbClass = _fotoramaClass + '__thumb',\n        thumbArrLeft = thumbClass + '__arr--left',\n        thumbArrRight = thumbClass + '__arr--right',\n        thumbBorderClass = thumbClass + '-border',\n\n        htmlClass = _fotoramaClass + '__html',\n\n        videoContainerClass = _fotoramaClass + '-video-container',\n        videoClass = _fotoramaClass + '__video',\n        videoPlayClass = videoClass + '-play',\n        videoCloseClass = videoClass + '-close',\n\n\n        horizontalImageClass = _fotoramaClass + '_horizontal_ratio',\n        verticalImageClass = _fotoramaClass + '_vertical_ratio',\n        fotoramaSpinnerClass = _fotoramaClass + '__spinner',\n        spinnerShowClass = fotoramaSpinnerClass + '--show';\n    var JQUERY_VERSION = $ && $.fn.jquery.split('.');\n\n    if (!JQUERY_VERSION\n        || JQUERY_VERSION[0] < 1\n        || (JQUERY_VERSION[0] == 1 && JQUERY_VERSION[1] < 8)) {\n        throw 'Fotorama requires jQuery 1.8 or later and will not run without it.';\n    }\n\n    var _ = {};\n    /* Modernizr 2.8.3 (Custom Build) | MIT & BSD\n     * Build: http://modernizr.com/download/#-csstransforms3d-csstransitions-touch-prefixed\n     */\n\n    var Modernizr = (function (window, document, undefined) {\n        var version = '2.8.3',\n            Modernizr = {},\n\n\n            docElement = document.documentElement,\n\n            mod = 'modernizr',\n            modElem = document.createElement(mod),\n            mStyle = modElem.style,\n            inputElem,\n\n\n            toString = {}.toString,\n\n            prefixes = ' -webkit- -moz- -o- -ms- '.split(' '),\n\n\n            omPrefixes = 'Webkit Moz O ms',\n\n            cssomPrefixes = omPrefixes.split(' '),\n\n            domPrefixes = omPrefixes.toLowerCase().split(' '),\n\n\n            tests = {},\n            inputs = {},\n            attrs = {},\n\n            classes = [],\n\n            slice = classes.slice,\n\n            featureName,\n\n\n            injectElementWithStyles = function (rule, callback, nodes, testnames) {\n\n                var style, ret, node, docOverflow,\n                    div = document.createElement('div'),\n                    body = document.body,\n                    fakeBody = body || document.createElement('body');\n\n                if (parseInt(nodes, 10)) {\n                    while (nodes--) {\n                        node = document.createElement('div');\n                        node.id = testnames ? testnames[nodes] : mod + (nodes + 1);\n                        div.appendChild(node);\n                    }\n                }\n\n                style = ['&#173;', '<style id=\"s', mod, '\">', rule, '</style>'].join('');\n                div.id = mod;\n                (body ? div : fakeBody).innerHTML += style;\n                fakeBody.appendChild(div);\n                if (!body) {\n                    fakeBody.style.background = '';\n                    fakeBody.style.overflow = 'hidden';\n                    docOverflow = docElement.style.overflow;\n                    docElement.style.overflow = 'hidden';\n                    docElement.appendChild(fakeBody);\n                }\n\n                ret = callback(div, rule);\n                if (!body) {\n                    fakeBody.parentNode.removeChild(fakeBody);\n                    docElement.style.overflow = docOverflow;\n                } else {\n                    div.parentNode.removeChild(div);\n                }\n\n                return !!ret;\n\n            },\n            _hasOwnProperty = ({}).hasOwnProperty, hasOwnProp;\n\n        if (!is(_hasOwnProperty, 'undefined') && !is(_hasOwnProperty.call, 'undefined')) {\n            hasOwnProp = function (object, property) {\n                return _hasOwnProperty.call(object, property);\n            };\n        }\n        else {\n            hasOwnProp = function (object, property) {\n                return ((property in object) && is(object.constructor.prototype[property], 'undefined'));\n            };\n        }\n\n\n        if (!Function.prototype.bind) {\n            Function.prototype.bind = function bind(that) {\n\n                var target = this;\n\n                if (typeof target != \"function\") {\n                    throw new TypeError();\n                }\n\n                var args = slice.call(arguments, 1),\n                    bound = function () {\n\n                        if (this instanceof bound) {\n\n                            var F = function () {\n                            };\n                            F.prototype = target.prototype;\n                            var self = new F();\n\n                            var result = target.apply(\n                                self,\n                                args.concat(slice.call(arguments))\n                            );\n                            if (Object(result) === result) {\n                                return result;\n                            }\n                            return self;\n\n                        } else {\n\n                            return target.apply(\n                                that,\n                                args.concat(slice.call(arguments))\n                            );\n\n                        }\n\n                    };\n\n                return bound;\n            };\n        }\n\n        function setCss(str) {\n            mStyle.cssText = str;\n        }\n\n        function setCssAll(str1, str2) {\n            return setCss(prefixes.join(str1 + ';') + ( str2 || '' ));\n        }\n\n        function is(obj, type) {\n            return typeof obj === type;\n        }\n\n        function contains(str, substr) {\n            return !!~('' + str).indexOf(substr);\n        }\n\n        function testProps(props, prefixed) {\n            for (var i in props) {\n                var prop = props[i];\n                if (!contains(prop, \"-\") && mStyle[prop] !== undefined) {\n                    return prefixed == 'pfx' ? prop : true;\n                }\n            }\n            return false;\n        }\n\n        function testDOMProps(props, obj, elem) {\n            for (var i in props) {\n                var item = obj[props[i]];\n                if (item !== undefined) {\n\n                    if (elem === false) return props[i];\n\n                    if (is(item, 'function')) {\n                        return item.bind(elem || obj);\n                    }\n\n                    return item;\n                }\n            }\n            return false;\n        }\n\n        function testPropsAll(prop, prefixed, elem) {\n\n            var ucProp = prop.charAt(0).toUpperCase() + prop.slice(1),\n                props = (prop + ' ' + cssomPrefixes.join(ucProp + ' ') + ucProp).split(' ');\n\n            if (is(prefixed, \"string\") || is(prefixed, \"undefined\")) {\n                return testProps(props, prefixed);\n\n            } else {\n                props = (prop + ' ' + (domPrefixes).join(ucProp + ' ') + ucProp).split(' ');\n                return testDOMProps(props, prefixed, elem);\n            }\n        }\n\n        tests['touch'] = function () {\n            var bool;\n\n            if (('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch) {\n                bool = true;\n            } else {\n                injectElementWithStyles(['@media (', prefixes.join('touch-enabled),('), mod, ')', '{#modernizr{top:9px;position:absolute}}'].join(''), function (node) {\n                    bool = node.offsetTop === 9;\n                });\n            }\n\n            return bool;\n        };\n        tests['csstransforms3d'] = function () {\n\n            var ret = !!testPropsAll('perspective');\n\n            if (ret && 'webkitPerspective' in docElement.style) {\n\n                injectElementWithStyles('@media (transform-3d),(-webkit-transform-3d){#modernizr{left:9px;position:absolute;height:3px;}}', function (node, rule) {\n                    ret = node.offsetLeft === 9 && node.offsetHeight === 3;\n                });\n            }\n            return ret;\n        };\n\n\n        tests['csstransitions'] = function () {\n            return testPropsAll('transition');\n        };\n\n\n        for (var feature in tests) {\n            if (hasOwnProp(tests, feature)) {\n                featureName = feature.toLowerCase();\n                Modernizr[featureName] = tests[feature]();\n\n                classes.push((Modernizr[featureName] ? '' : 'no-') + featureName);\n            }\n        }\n\n\n        Modernizr.addTest = function (feature, test) {\n            if (typeof feature == 'object') {\n                for (var key in feature) {\n                    if (hasOwnProp(feature, key)) {\n                        Modernizr.addTest(key, feature[key]);\n                    }\n                }\n            } else {\n\n                feature = feature.toLowerCase();\n\n                if (Modernizr[feature] !== undefined) {\n                    return Modernizr;\n                }\n\n                test = typeof test == 'function' ? test() : test;\n\n                if (typeof enableClasses !== \"undefined\" && enableClasses) {\n                    docElement.className += ' ' + (test ? '' : 'no-') + feature;\n                }\n                Modernizr[feature] = test;\n\n            }\n\n            return Modernizr;\n        };\n\n\n        setCss('');\n        modElem = inputElem = null;\n\n\n        Modernizr._version = version;\n\n        Modernizr._prefixes = prefixes;\n        Modernizr._domPrefixes = domPrefixes;\n        Modernizr._cssomPrefixes = cssomPrefixes;\n\n\n        Modernizr.testProp = function (prop) {\n            return testProps([prop]);\n        };\n\n        Modernizr.testAllProps = testPropsAll;\n        Modernizr.testStyles = injectElementWithStyles;\n        Modernizr.prefixed = function (prop, obj, elem) {\n            if (!obj) {\n                return testPropsAll(prop, 'pfx');\n            } else {\n                return testPropsAll(prop, obj, elem);\n            }\n        };\n        return Modernizr;\n    })(window, document);\n\n    var fullScreenApi = {\n            ok: false,\n            is: function () {\n                return false;\n            },\n            request: function () {\n            },\n            cancel: function () {\n            },\n            event: '',\n            prefix: ''\n        },\n        browserPrefixes = 'webkit moz o ms khtml'.split(' ');\n\n// check for native support\n    if (typeof document.cancelFullScreen != 'undefined') {\n        fullScreenApi.ok = true;\n    } else {\n        // check for fullscreen support by vendor prefix\n        for (var i = 0, il = browserPrefixes.length; i < il; i++) {\n            fullScreenApi.prefix = browserPrefixes[i];\n            if (typeof document[fullScreenApi.prefix + 'CancelFullScreen'] != 'undefined') {\n                fullScreenApi.ok = true;\n                break;\n            }\n        }\n    }\n\n// update methods to do something useful\n    if (fullScreenApi.ok) {\n        fullScreenApi.event = fullScreenApi.prefix + 'fullscreenchange';\n        fullScreenApi.is = function () {\n            switch (this.prefix) {\n                case '':\n                    return document.fullScreen;\n                case 'webkit':\n                    return document.webkitIsFullScreen;\n                default:\n                    return document[this.prefix + 'FullScreen'];\n            }\n        };\n        fullScreenApi.request = function (el) {\n            return (this.prefix === '') ? el.requestFullScreen() : el[this.prefix + 'RequestFullScreen']();\n        };\n        fullScreenApi.cancel = function (el) {\n            if (!this.is()) {\n                return false;\n            }\n            return (this.prefix === '') ? document.cancelFullScreen() : document[this.prefix + 'CancelFullScreen']();\n        };\n    }\n    /* Bez v1.0.10-g5ae0136\n     * http://github.com/rdallasgray/bez\n     *\n     * A plugin to convert CSS3 cubic-bezier co-ordinates to jQuery-compatible easing functions\n     *\n     * With thanks to Nikolay Nemshilov for clarification on the cubic-bezier maths\n     * See http://st-on-it.blogspot.com/2011/05/calculating-cubic-bezier-function.html\n     *\n     * Copyright 2011 Robert Dallas Gray. All rights reserved.\n     * Provided under the FreeBSD license: https://github.com/rdallasgray/bez/blob/master/LICENSE.txt\n     */\n    function bez(coOrdArray) {\n        var encodedFuncName = \"bez_\" + $.makeArray(arguments).join(\"_\").replace(\".\", \"p\");\n        if (typeof $['easing'][encodedFuncName] !== \"function\") {\n            var polyBez = function (p1, p2) {\n                var A = [null, null],\n                    B = [null, null],\n                    C = [null, null],\n                    bezCoOrd = function (t, ax) {\n                        C[ax] = 3 * p1[ax];\n                        B[ax] = 3 * (p2[ax] - p1[ax]) - C[ax];\n                        A[ax] = 1 - C[ax] - B[ax];\n                        return t * (C[ax] + t * (B[ax] + t * A[ax]));\n                    },\n                    xDeriv = function (t) {\n                        return C[0] + t * (2 * B[0] + 3 * A[0] * t);\n                    },\n                    xForT = function (t) {\n                        var x = t, i = 0, z;\n                        while (++i < 14) {\n                            z = bezCoOrd(x, 0) - t;\n                            if (Math.abs(z) < 1e-3) break;\n                            x -= z / xDeriv(x);\n                        }\n                        return x;\n                    };\n                return function (t) {\n                    return bezCoOrd(xForT(t), 1);\n                }\n            };\n            $['easing'][encodedFuncName] = function (x, t, b, c, d) {\n                return c * polyBez([coOrdArray[0], coOrdArray[1]], [coOrdArray[2], coOrdArray[3]])(t / d) + b;\n            }\n        }\n        return encodedFuncName;\n    }\n\n    var $WINDOW = $(window),\n        $DOCUMENT = $(document),\n        $HTML,\n        $BODY,\n\n        QUIRKS_FORCE = location.hash.replace('#', '') === 'quirks',\n        TRANSFORMS3D = Modernizr.csstransforms3d,\n        CSS3 = TRANSFORMS3D && !QUIRKS_FORCE,\n        COMPAT = TRANSFORMS3D || document.compatMode === 'CSS1Compat',\n        FULLSCREEN = fullScreenApi.ok,\n\n        MOBILE = navigator.userAgent.match(/Android|webOS|iPhone|iPad|iPod|BlackBerry|Windows Phone/i),\n        SLOW = !CSS3 || MOBILE,\n\n        MS_POINTER = navigator.msPointerEnabled,\n\n        WHEEL = \"onwheel\" in document.createElement(\"div\") ? \"wheel\" : document.onmousewheel !== undefined ? \"mousewheel\" : \"DOMMouseScroll\",\n\n        TOUCH_TIMEOUT = 250,\n        TRANSITION_DURATION = 300,\n\n        SCROLL_LOCK_TIMEOUT = 1400,\n\n        AUTOPLAY_INTERVAL = 5000,\n        MARGIN = 2,\n        THUMB_SIZE = 64,\n\n        WIDTH = 500,\n        HEIGHT = 333,\n\n        STAGE_FRAME_KEY = '$stageFrame',\n        NAV_DOT_FRAME_KEY = '$navDotFrame',\n        NAV_THUMB_FRAME_KEY = '$navThumbFrame',\n\n        AUTO = 'auto',\n\n        BEZIER = bez([.1, 0, .25, 1]),\n\n        MAX_WIDTH = 1200,\n\n        /**\n         * Number of thumbnails in slide. Calculated only on setOptions and resize.\n         * @type {number}\n         */\n        thumbsPerSlide = 1,\n\n        OPTIONS = {\n\n            /**\n             * Set width for gallery.\n             * Default value - width of first image\n             * Number - set value in px\n             * String - set value in quotes\n             *\n             */\n            width: null,\n\n            /**\n             * Set min-width for gallery\n             *\n             */\n            minwidth: null,\n\n            /**\n             * Set max-width for gallery\n             *\n             */\n            maxwidth: '100%',\n\n            /**\n             * Set height for gallery\n             * Default value - height of first image\n             * Number - set value in px\n             * String - set value in quotes\n             *\n             */\n            height: null,\n\n            /**\n             * Set min-height for gallery\n             *\n             */\n            minheight: null,\n\n            /**\n             * Set max-height for gallery\n             *\n             */\n            maxheight: null,\n\n            /**\n             * Set proportion ratio for gallery depends of image\n             *\n             */\n            ratio: null, // '16/9' || 500/333 || 1.5\n\n            margin: MARGIN,\n\n            nav: 'dots', // 'thumbs' || false\n            navposition: 'bottom', // 'top'\n            navwidth: null,\n            thumbwidth: THUMB_SIZE,\n            thumbheight: THUMB_SIZE,\n            thumbmargin: MARGIN,\n            thumbborderwidth: MARGIN,\n\n            allowfullscreen: false, // true || 'native'\n\n            transition: 'slide', // 'crossfade' || 'dissolve'\n            clicktransition: null,\n            transitionduration: TRANSITION_DURATION,\n\n            captions: true,\n\n            startindex: 0,\n\n            loop: false,\n\n            autoplay: false,\n            stopautoplayontouch: true,\n\n            keyboard: false,\n\n            arrows: true,\n            click: true,\n            swipe: false,\n            trackpad: false,\n\n            shuffle: false,\n\n            direction: 'ltr', // 'rtl'\n\n            shadows: true,\n\n            showcaption: true,\n\n            /**\n             * Set type of thumbnail navigation\n             */\n            navdir: 'horizontal',\n\n            /**\n             * Set configuration to show or hide arrows in thumb navigation\n             */\n            navarrows: true,\n\n            /**\n             * Set type of navigation. Can be thumbs or slides\n             */\n            navtype: 'thumbs'\n\n        },\n\n        KEYBOARD_OPTIONS = {\n            left: true,\n            right: true,\n            down: true,\n            up: true,\n            space: false,\n            home: false,\n            end: false\n        };\n\n    function noop() {\n    }\n\n    function minMaxLimit(value, min, max) {\n        return Math.max(isNaN(min) ? -Infinity : min, Math.min(isNaN(max) ? Infinity : max, value));\n    }\n\n    function readTransform(css, dir) {\n        return css.match(/ma/) && css.match(/-?\\d+(?!d)/g)[css.match(/3d/) ?\n                (dir === 'vertical' ? 13 : 12) : (dir === 'vertical' ? 5 : 4)\n                ]\n    }\n\n    function readPosition($el, dir) {\n        if (CSS3) {\n            return +readTransform($el.css('transform'), dir);\n        } else {\n            return +$el.css(dir === 'vertical' ? 'top' : 'left').replace('px', '');\n        }\n    }\n\n    function getTranslate(pos, direction) {\n        var obj = {};\n\n        if (CSS3) {\n\n            switch (direction) {\n                case 'vertical':\n                    obj.transform = 'translate3d(0, ' + (pos) + 'px,0)';\n                    break;\n                case 'list':\n                    break;\n                default :\n                    obj.transform = 'translate3d(' + (pos) + 'px,0,0)';\n                    break;\n            }\n        } else {\n            direction === 'vertical' ?\n                obj.top = pos :\n                obj.left = pos;\n        }\n        return obj;\n    }\n\n    function getDuration(time) {\n        return {'transition-duration': time + 'ms'};\n    }\n\n    function unlessNaN(value, alternative) {\n        return isNaN(value) ? alternative : value;\n    }\n\n    function numberFromMeasure(value, measure) {\n        return unlessNaN(+String(value).replace(measure || 'px', ''));\n    }\n\n    function numberFromPercent(value) {\n        return /%$/.test(value) ? numberFromMeasure(value, '%') : undefined;\n    }\n\n    function numberFromWhatever(value, whole) {\n        return unlessNaN(numberFromPercent(value) / 100 * whole, numberFromMeasure(value));\n    }\n\n    function measureIsValid(value) {\n        return (!isNaN(numberFromMeasure(value)) || !isNaN(numberFromMeasure(value, '%'))) && value;\n    }\n\n    function getPosByIndex(index, side, margin, baseIndex) {\n\n        return (index - (baseIndex || 0)) * (side + (margin || 0));\n    }\n\n    function getIndexByPos(pos, side, margin, baseIndex) {\n        return -Math.round(pos / (side + (margin || 0)) - (baseIndex || 0));\n    }\n\n    function bindTransitionEnd($el) {\n        var elData = $el.data();\n\n        if (elData.tEnd) return;\n\n        var el = $el[0],\n            transitionEndEvent = {\n                WebkitTransition: 'webkitTransitionEnd',\n                MozTransition: 'transitionend',\n                OTransition: 'oTransitionEnd otransitionend',\n                msTransition: 'MSTransitionEnd',\n                transition: 'transitionend'\n            };\n        addEvent(el, transitionEndEvent[Modernizr.prefixed('transition')], function (e) {\n            elData.tProp && e.propertyName.match(elData.tProp) && elData.onEndFn();\n        });\n        elData.tEnd = true;\n    }\n\n    function afterTransition($el, property, fn, time) {\n        var ok,\n            elData = $el.data();\n\n        if (elData) {\n            elData.onEndFn = function () {\n                if (ok) return;\n                ok = true;\n                clearTimeout(elData.tT);\n                fn();\n            };\n            elData.tProp = property;\n\n            // Passive call, just in case of fail of native transition-end event\n            clearTimeout(elData.tT);\n            elData.tT = setTimeout(function () {\n                elData.onEndFn();\n            }, time * 1.5);\n\n            bindTransitionEnd($el);\n        }\n    }\n\n\n    function stop($el, pos/*, _001*/) {\n        var dir = $el.navdir || 'horizontal';\n        if ($el.length) {\n            var elData = $el.data();\n            if (CSS3) {\n                $el.css(getDuration(0));\n                elData.onEndFn = noop;\n                clearTimeout(elData.tT);\n            } else {\n                $el.stop();\n            }\n            var lockedPos = getNumber(pos, function () {\n                return readPosition($el, dir);\n            });\n\n            $el.css(getTranslate(lockedPos, dir/*, _001*/));//.width(); // `.width()` for reflow\n            return lockedPos;\n        }\n    }\n\n    function getNumber() {\n        var number;\n        for (var _i = 0, _l = arguments.length; _i < _l; _i++) {\n            number = _i ? arguments[_i]() : arguments[_i];\n            if (typeof number === 'number') {\n                break;\n            }\n        }\n\n        return number;\n    }\n\n    function edgeResistance(pos, edge) {\n        return Math.round(pos + ((edge - pos) / 1.5));\n    }\n\n    function getProtocol() {\n        getProtocol.p = getProtocol.p || (location.protocol === 'https:' ? 'https://' : 'http://');\n        return getProtocol.p;\n    }\n\n    function parseHref(href) {\n        var a = document.createElement('a');\n        a.href = href;\n        return a;\n    }\n\n    function findVideoId(href, forceVideo) {\n        if (typeof href !== 'string') return href;\n        href = parseHref(href);\n\n        var id,\n            type;\n\n        if (href.host.match(/youtube\\.com/) && href.search) {\n            //.log();\n            id = href.search.split('v=')[1];\n            if (id) {\n                var ampersandPosition = id.indexOf('&');\n                if (ampersandPosition !== -1) {\n                    id = id.substring(0, ampersandPosition);\n                }\n                type = 'youtube';\n            }\n        } else if (href.host.match(/youtube\\.com|youtu\\.be|youtube-nocookie.com/)) {\n            id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n            type = 'youtube';\n        } else if (href.host.match(/vimeo\\.com/)) {\n            type = 'vimeo';\n            id = href.pathname.replace(/^\\/(video\\/)?/, '').replace(/\\/.*/, '');\n        }\n\n        if ((!id || !type) && forceVideo) {\n            id = href.href;\n            type = 'custom';\n        }\n\n        return id ? {id: id, type: type, s: href.search.replace(/^\\?/, ''), p: getProtocol()} : false;\n    }\n\n    function getVideoThumbs(dataFrame, data, fotorama) {\n        var img, thumb, video = dataFrame.video;\n        if (video.type === 'youtube') {\n            thumb = getProtocol() + 'img.youtube.com/vi/' + video.id + '/default.jpg';\n            img = thumb.replace(/\\/default.jpg$/, '/hqdefault.jpg');\n            dataFrame.thumbsReady = true;\n        } else if (video.type === 'vimeo') {\n            $.ajax({\n                url: getProtocol() + 'vimeo.com/api/oembed.json',\n                data: {\n                    url: 'https://vimeo.com/' + video.id\n                },\n                dataType: 'jsonp',\n                success: function (json) {\n                    dataFrame.thumbsReady = true;\n                    updateData(data, {\n                        img: json[0].thumbnail_url,\n                        thumb: json[0].thumbnail_url\n                    }, dataFrame.i, fotorama);\n                }\n            });\n        } else {\n            dataFrame.thumbsReady = true;\n        }\n\n        return {\n            img: img,\n            thumb: thumb\n        }\n    }\n\n    function updateData(data, _dataFrame, i, fotorama) {\n        for (var _i = 0, _l = data.length; _i < _l; _i++) {\n            var dataFrame = data[_i];\n\n            if (dataFrame.i === i && dataFrame.thumbsReady) {\n                var clear = {videoReady: true};\n                clear[STAGE_FRAME_KEY] = clear[NAV_THUMB_FRAME_KEY] = clear[NAV_DOT_FRAME_KEY] = false;\n\n                fotorama.splice(_i, 1, $.extend(\n                    {},\n                    dataFrame,\n                    clear,\n                    _dataFrame\n                ));\n\n                break;\n            }\n        }\n    }\n\n    function getDataFromHtml($el) {\n        var data = [];\n\n        function getDataFromImg($img, imgData, checkVideo) {\n            var $child = $img.children('img').eq(0),\n                _imgHref = $img.attr('href'),\n                _imgSrc = $img.attr('src'),\n                _thumbSrc = $child.attr('src'),\n                _video = imgData.video,\n                video = checkVideo ? findVideoId(_imgHref, _video === true) : false;\n\n            if (video) {\n                _imgHref = false;\n            } else {\n                video = _video;\n            }\n\n            getDimensions($img, $child, $.extend(imgData, {\n                video: video,\n                img: imgData.img || _imgHref || _imgSrc || _thumbSrc,\n                thumb: imgData.thumb || _thumbSrc || _imgSrc || _imgHref\n            }));\n        }\n\n        function getDimensions($img, $child, imgData) {\n            var separateThumbFLAG = imgData.thumb && imgData.img !== imgData.thumb,\n                width = numberFromMeasure(imgData.width || $img.attr('width')),\n                height = numberFromMeasure(imgData.height || $img.attr('height'));\n\n            $.extend(imgData, {\n                width: width,\n                height: height,\n                thumbratio: getRatio(imgData.thumbratio || (numberFromMeasure(imgData.thumbwidth || ($child && $child.attr('width')) || separateThumbFLAG || width) / numberFromMeasure(imgData.thumbheight || ($child && $child.attr('height')) || separateThumbFLAG || height)))\n            });\n        }\n\n        $el.children().each(function () {\n            var $this = $(this),\n                dataFrame = optionsToLowerCase($.extend($this.data(), {id: $this.attr('id')}));\n            if ($this.is('a, img')) {\n                getDataFromImg($this, dataFrame, true);\n            } else if (!$this.is(':empty')) {\n                getDimensions($this, null, $.extend(dataFrame, {\n                    html: this,\n                    _html: $this.html() // Because of IE\n                }));\n            } else return;\n\n            data.push(dataFrame);\n        });\n\n        return data;\n    }\n\n    function isHidden(el) {\n        return el.offsetWidth === 0 && el.offsetHeight === 0;\n    }\n\n    function isDetached(el) {\n        return !$.contains(document.documentElement, el);\n    }\n\n    function waitFor(test, fn, timeout, i) {\n        if (!waitFor.i) {\n            waitFor.i = 1;\n            waitFor.ii = [true];\n        }\n\n        i = i || waitFor.i;\n\n        if (typeof waitFor.ii[i] === 'undefined') {\n            waitFor.ii[i] = true;\n        }\n\n        if (test()) {\n            fn();\n        } else {\n            waitFor.ii[i] && setTimeout(function () {\n                waitFor.ii[i] && waitFor(test, fn, timeout, i);\n            }, timeout || 100);\n        }\n\n        return waitFor.i++;\n    }\n\n    waitFor.stop = function (i) {\n        waitFor.ii[i] = false;\n    };\n\n    function fit($el, measuresToFit) {\n        var elData = $el.data(),\n            measures = elData.measures;\n\n        if (measures && (!elData.l ||\n            elData.l.W !== measures.width ||\n            elData.l.H !== measures.height ||\n            elData.l.r !== measures.ratio ||\n            elData.l.w !== measuresToFit.w ||\n            elData.l.h !== measuresToFit.h)) {\n\n            var height = minMaxLimit(measuresToFit.h, 0, measures.height),\n                width = height * measures.ratio;\n\n            UTIL.setRatio($el, width, height);\n\n            elData.l = {\n                W: measures.width,\n                H: measures.height,\n                r: measures.ratio,\n                w: measuresToFit.w,\n                h: measuresToFit.h\n            };\n        }\n\n        return true;\n    }\n\n    function setStyle($el, style) {\n        var el = $el[0];\n        if (el.styleSheet) {\n            el.styleSheet.cssText = style;\n        } else {\n            $el.html(style);\n        }\n    }\n\n    function findShadowEdge(pos, min, max, dir) {\n        return min === max ? false :\n            dir === 'vertical' ?\n                (pos <= min ? 'top' : pos >= max ? 'bottom' : 'top bottom') :\n                (pos <= min ? 'left' : pos >= max ? 'right' : 'left right');\n    }\n\n    function smartClick($el, fn, _options) {\n        _options = _options || {};\n\n        $el.each(function () {\n            var $this = $(this),\n                thisData = $this.data(),\n                startEvent;\n\n            if (thisData.clickOn) return;\n\n            thisData.clickOn = true;\n\n            $.extend(touch($this, {\n                onStart: function (e) {\n                    startEvent = e;\n                    (_options.onStart || noop).call(this, e);\n                },\n                onMove: _options.onMove || noop,\n                onTouchEnd: _options.onTouchEnd || noop,\n                onEnd: function (result) {\n                    if (result.moved) return;\n                    fn.call(this, startEvent);\n                }\n            }), {noMove: true});\n        });\n    }\n\n    function div(classes, child) {\n        return '<div class=\"' + classes + '\">' + (child || '') + '</div>';\n    }\n\n\n    /**\n     * Function transforming into valid classname\n     * @param className - name of the class\n     * @returns {string} - dom format of class name\n     */\n    function cls(className) {\n        return \".\" + className;\n    }\n\n    /**\n     *\n     * @param {json-object} videoItem Parsed object from data.video item or href from link a in input dates\n     * @returns {string} DOM view of video iframe\n     */\n    function createVideoFrame(videoItem) {\n        var frame = '<iframe src=\"' + videoItem.p + videoItem.type + '.com/embed/' + videoItem.id + '\" frameborder=\"0\" allowfullscreen></iframe>';\n        return frame;\n    }\n\n// Fisher\u2013Yates Shuffle\n// http://bost.ocks.org/mike/shuffle/\n    function shuffle(array) {\n        // While there remain elements to shuffle\n        var l = array.length;\n        while (l) {\n            // Pick a remaining element\n            var i = Math.floor(Math.random() * l--);\n\n            // And swap it with the current element\n            var t = array[l];\n            array[l] = array[i];\n            array[i] = t;\n        }\n\n        return array;\n    }\n\n    function clone(array) {\n        return Object.prototype.toString.call(array) == '[object Array]'\n            && $.map(array, function (frame) {\n                return $.extend({}, frame);\n            });\n    }\n\n    function lockScroll($el, left, top) {\n        $el\n            .scrollLeft(left || 0)\n            .scrollTop(top || 0);\n    }\n\n    function optionsToLowerCase(options) {\n        if (options) {\n            var opts = {};\n            $.each(options, function (key, value) {\n                opts[key.toLowerCase()] = value;\n            });\n\n            return opts;\n        }\n    }\n\n    function getRatio(_ratio) {\n        if (!_ratio) return;\n        var ratio = +_ratio;\n        if (!isNaN(ratio)) {\n            return ratio;\n        } else {\n            ratio = _ratio.split('/');\n            return +ratio[0] / +ratio[1] || undefined;\n        }\n    }\n\n    function addEvent(el, e, fn, bool) {\n        if (!e) return;\n        el.addEventListener ? el.addEventListener(e, fn, {passive: !!bool}) : el.attachEvent('on' + e, fn);\n    }\n\n    /**\n     *\n     * @param position guess position for navShaft\n     * @param restriction object contains min and max values for position\n     * @returns {*} filtered value of position\n     */\n    function validateRestrictions(position, restriction) {\n        if (position > restriction.max) {\n            position = restriction.max;\n        } else {\n            if (position < restriction.min) {\n                position = restriction.min;\n            }\n        }\n        return position;\n    }\n\n    function validateSlidePos(opt, navShaftTouchTail, guessIndex, offsetNav, $guessNavFrame, $navWrap, dir) {\n        var position,\n            size,\n            wrapSize;\n        if (dir === 'horizontal') {\n            size = opt.thumbwidth;\n            wrapSize = $navWrap.width();\n        } else {\n            size = opt.thumbheight;\n            wrapSize = $navWrap.height();\n        }\n        if ( (size + opt.margin) * (guessIndex + 1) >= (wrapSize - offsetNav) ) {\n            if (dir === 'horizontal') {\n                position = -$guessNavFrame.position().left;\n            } else {\n                position = -$guessNavFrame.position().top;\n            }\n        } else {\n            if ((size + opt.margin) * (guessIndex) <= Math.abs(offsetNav)) {\n                if (dir === 'horizontal') {\n                    position = -$guessNavFrame.position().left + wrapSize - (size + opt.margin);\n                } else {\n                    position = -$guessNavFrame.position().top + wrapSize - (size + opt.margin);\n                }\n            } else {\n                position = offsetNav;\n            }\n        }\n        position = validateRestrictions(position, navShaftTouchTail);\n\n        return position || 0;\n    }\n\n    function elIsDisabled(el) {\n        return !!el.getAttribute('disabled');\n    }\n\n    function disableAttr(FLAG, disable) {\n        if (disable) {\n            return {disabled: FLAG};\n        } else {\n            return {tabindex: FLAG * -1 + '', disabled: FLAG};\n\n        }\n    }\n\n    function addEnterUp(el, fn) {\n        addEvent(el, 'keyup', function (e) {\n            elIsDisabled(el) || e.keyCode == 13 && fn.call(el, e);\n        });\n    }\n\n    function addFocus(el, fn) {\n        addEvent(el, 'focus', el.onfocusin = function (e) {\n            fn.call(el, e);\n        }, true);\n    }\n\n    function stopEvent(e, stopPropagation) {\n        if (!Modernizr.touch) {\n            e.preventDefault ? e.preventDefault() : (e.returnValue = false);\n        }\n        stopPropagation && e.stopPropagation && e.stopPropagation();\n    }\n\n    function getDirectionSign(forward) {\n        return forward ? '>' : '<';\n    }\n\n    var UTIL = (function () {\n\n        function setRatioClass($el, wh, ht) {\n            var rateImg = wh / ht;\n\n            if (rateImg <= 1) {\n                $el.parent().removeClass(horizontalImageClass);\n                $el.parent().addClass(verticalImageClass);\n            } else {\n                $el.parent().removeClass(verticalImageClass);\n                $el.parent().addClass(horizontalImageClass);\n            }\n        }\n\n        /**\n         * Set specific attribute in thumbnail template\n         * @param $frame DOM item of specific thumbnail\n         * @param value Value which must be setted into specific attribute\n         * @param searchAttr Name of attribute where value must be included\n         */\n        function setThumbAttr($frame, value, searchAttr) {\n            var attr = searchAttr;\n\n            if (!$frame.attr(attr) && $frame.attr(attr) !== undefined) {\n                $frame.attr(attr, value);\n            }\n\n            if ($frame.find(\"[\" + attr + \"]\").length) {\n                $frame.find(\"[\" + attr + \"]\")\n                    .each(function () {\n                        $(this).attr(attr, value);\n                    });\n            }\n        }\n\n        /**\n         * Method describe behavior need to render caption on preview or not\n         * @param frameItem specific item from data\n         * @param isExpected {bool} if items with caption need render them or not\n         * @returns {boolean} if true then caption should be rendered\n         */\n        function isExpectedCaption(frameItem, isExpected, undefined) {\n            var expected = false,\n                frameExpected;\n\n            frameItem.showCaption === undefined || frameItem.showCaption === true ? frameExpected = true : frameExpected = false;\n\n            if (!isExpected) {\n                return false;\n            }\n\n            if (frameItem.caption && frameExpected) {\n                expected = true;\n            }\n\n            return expected;\n        }\n\n        return {\n            setRatio: setRatioClass,\n            setThumbAttr: setThumbAttr,\n            isExpectedCaption: isExpectedCaption\n        };\n\n    }(UTIL || {}, jQuery));\n\n    function slide($el, options) {\n        var elData = $el.data(),\n            elPos = Math.round(options.pos),\n            onEndFn = function () {\n                if (elData && elData.sliding) {\n                    elData.sliding = false;\n                }\n                (options.onEnd || noop)();\n            };\n\n        if (typeof options.overPos !== 'undefined' && options.overPos !== options.pos) {\n            elPos = options.overPos;\n        }\n\n        var translate = $.extend(getTranslate(elPos, options.direction), options.width && {width: options.width}, options.height && {height: options.height});\n        if (elData && elData.sliding) {\n            elData.sliding = true;\n        }\n\n        if (CSS3) {\n            $el.css($.extend(getDuration(options.time), translate));\n\n            if (options.time > 10) {\n                afterTransition($el, 'transform', onEndFn, options.time);\n            } else {\n                onEndFn();\n            }\n        } else {\n            $el.stop().animate(translate, options.time, BEZIER, onEndFn);\n        }\n    }\n\n    function fade($el1, $el2, $frames, options, fadeStack, chain) {\n        var chainedFLAG = typeof chain !== 'undefined';\n        if (!chainedFLAG) {\n            fadeStack.push(arguments);\n            Array.prototype.push.call(arguments, fadeStack.length);\n            if (fadeStack.length > 1) return;\n        }\n\n        $el1 = $el1 || $($el1);\n        $el2 = $el2 || $($el2);\n\n        var _$el1 = $el1[0],\n            _$el2 = $el2[0],\n            crossfadeFLAG = options.method === 'crossfade',\n            onEndFn = function () {\n                if (!onEndFn.done) {\n                    onEndFn.done = true;\n                    var args = (chainedFLAG || fadeStack.shift()) && fadeStack.shift();\n                    args && fade.apply(this, args);\n                    (options.onEnd || noop)(!!args);\n                }\n            },\n            time = options.time / (chain || 1);\n\n        $frames.removeClass(fadeRearClass + ' ' + fadeFrontClass);\n\n        $el1\n            .stop()\n            .addClass(fadeRearClass);\n        $el2\n            .stop()\n            .addClass(fadeFrontClass);\n\n        crossfadeFLAG && _$el2 && $el1.fadeTo(0, 0);\n\n        $el1.fadeTo(crossfadeFLAG ? time : 0, 1, crossfadeFLAG && onEndFn);\n        $el2.fadeTo(time, 0, onEndFn);\n\n        (_$el1 && crossfadeFLAG) || _$el2 || onEndFn();\n    }\n\n    var lastEvent,\n        moveEventType,\n        preventEvent,\n        preventEventTimeout,\n        dragDomEl;\n\n    function extendEvent(e) {\n        var touch = (e.touches || [])[0] || e;\n        e._x = touch.pageX || touch.originalEvent.pageX;\n        e._y = touch.clientY || touch.originalEvent.clientY;\n        e._now = $.now();\n    }\n\n    function touch($el, options) {\n        var el = $el[0],\n            tail = {},\n            touchEnabledFLAG,\n            startEvent,\n            $target,\n            controlTouch,\n            touchFLAG,\n            targetIsSelectFLAG,\n            targetIsLinkFlag,\n            isDisabledSwipe,\n            tolerance,\n            moved;\n\n        function onStart(e) {\n            $target = $(e.target);\n            tail.checked = targetIsSelectFLAG = targetIsLinkFlag = isDisabledSwipe = moved = false;\n\n            if (touchEnabledFLAG\n                || tail.flow\n                || (e.touches && e.touches.length > 1)\n                || e.which > 1\n                || (lastEvent && lastEvent.type !== e.type && preventEvent)\n                || (targetIsSelectFLAG = options.select && $target.is(options.select, el))) return targetIsSelectFLAG;\n\n            touchFLAG = e.type === 'touchstart';\n            targetIsLinkFlag = $target.is('a, a *', el);\n            isDisabledSwipe = $target.hasClass('disableSwipe');\n            controlTouch = tail.control;\n\n            tolerance = (tail.noMove || tail.noSwipe || controlTouch) ? 16 : !tail.snap ? 4 : 0;\n\n            extendEvent(e);\n\n            startEvent = lastEvent = e;\n            moveEventType = e.type.replace(/down|start/, 'move').replace(/Down/, 'Move');\n\n            (options.onStart || noop).call(el, e, {control: controlTouch, $target: $target});\n\n            touchEnabledFLAG = tail.flow = true;\n\n            if (!isDisabledSwipe && (!touchFLAG || tail.go)) stopEvent(e);\n        }\n\n        function onMove(e) {\n            if ((e.touches && e.touches.length > 1)\n                || (MS_POINTER && !e.isPrimary)\n                || moveEventType !== e.type\n                || !touchEnabledFLAG) {\n                touchEnabledFLAG && onEnd();\n                (options.onTouchEnd || noop)();\n                return;\n            }\n\n            isDisabledSwipe = $(e.target).hasClass('disableSwipe');\n\n            if (isDisabledSwipe) {\n                return;\n            }\n\n            extendEvent(e);\n\n            var xDiff = Math.abs(e._x - startEvent._x), // opt _x \u2192 _pageX\n                yDiff = Math.abs(e._y - startEvent._y),\n                xyDiff = xDiff - yDiff,\n                xWin = (tail.go || tail.x || xyDiff >= 0) && !tail.noSwipe,\n                yWin = xyDiff < 0;\n\n            if (touchFLAG && !tail.checked) {\n                if (touchEnabledFLAG = xWin) {\n                    stopEvent(e);\n                }\n            } else {\n                stopEvent(e);\n                if (movedEnough(xDiff,yDiff)) {\n                    (options.onMove || noop).call(el, e, {touch: touchFLAG});\n                }\n            }\n\n            if (!moved && movedEnough(xDiff, yDiff) && Math.sqrt(Math.pow(xDiff, 2) + Math.pow(yDiff, 2)) > tolerance) {\n                moved = true;\n            }\n\n            tail.checked = tail.checked || xWin || yWin;\n        }\n\n        function movedEnough(xDiff, yDiff) {\n            return xDiff > yDiff && xDiff > 1.5;\n        }\n\n        function onEnd(e) {\n            (options.onTouchEnd || noop)();\n\n            var _touchEnabledFLAG = touchEnabledFLAG;\n            tail.control = touchEnabledFLAG = false;\n\n            if (_touchEnabledFLAG) {\n                tail.flow = false;\n            }\n\n            if (!_touchEnabledFLAG || (targetIsLinkFlag && !tail.checked)) return;\n\n            e && stopEvent(e);\n\n            preventEvent = true;\n            clearTimeout(preventEventTimeout);\n            preventEventTimeout = setTimeout(function () {\n                preventEvent = false;\n            }, 1000);\n\n            (options.onEnd || noop).call(el, {\n                moved: moved,\n                $target: $target,\n                control: controlTouch,\n                touch: touchFLAG,\n                startEvent: startEvent,\n                aborted: !e || e.type === 'MSPointerCancel'\n            });\n        }\n\n        function onOtherStart() {\n            if (tail.flow) return;\n            tail.flow = true;\n        }\n\n        function onOtherEnd() {\n            if (!tail.flow) return;\n            tail.flow = false;\n        }\n\n        if (MS_POINTER) {\n            addEvent(el, 'MSPointerDown', onStart);\n            addEvent(document, 'MSPointerMove', onMove);\n            addEvent(document, 'MSPointerCancel', onEnd);\n            addEvent(document, 'MSPointerUp', onEnd);\n        } else {\n            addEvent(el, 'touchstart', onStart);\n            addEvent(el, 'touchmove', onMove);\n            addEvent(el, 'touchend', onEnd);\n\n            addEvent(document, 'touchstart', onOtherStart, true);\n            addEvent(document, 'touchend', onOtherEnd);\n            addEvent(document, 'touchcancel', onOtherEnd);\n\n            $WINDOW.on('scroll', onOtherEnd);\n\n            $el.on('mousedown', onStart);\n            $DOCUMENT\n                .on('mousemove', onMove)\n                .on('mouseup', onEnd);\n        }\n        if (Modernizr.touch) {\n            dragDomEl = 'a';\n        } else {\n            dragDomEl = 'div';\n        }\n        $el.on('click', dragDomEl, function (e) {\n            tail.checked && stopEvent(e);\n        });\n\n        return tail;\n    }\n\n    function moveOnTouch($el, options) {\n        var el = $el[0],\n            elData = $el.data(),\n            tail = {},\n            startCoo,\n            coo,\n            startElPos,\n            moveElPos,\n            edge,\n            moveTrack,\n            startTime,\n            endTime,\n            min,\n            max,\n            snap,\n            dir,\n            slowFLAG,\n            controlFLAG,\n            moved,\n            tracked;\n\n        function startTracking(e, noStop) {\n            tracked = true;\n            startCoo = coo = (dir === 'vertical') ? e._y : e._x;\n            startTime = e._now;\n\n            moveTrack = [\n                [startTime, startCoo]\n            ];\n\n            startElPos = moveElPos = tail.noMove || noStop ? 0 : stop($el, (options.getPos || noop)()/*, options._001*/);\n\n            (options.onStart || noop).call(el, e);\n        }\n\n        function onStart(e, result) {\n            min = tail.min;\n            max = tail.max;\n            snap = tail.snap,\n                dir = tail.direction || 'horizontal',\n                $el.navdir = dir;\n\n            slowFLAG = e.altKey;\n            tracked = moved = false;\n\n            controlFLAG = result.control;\n\n            if (!controlFLAG && !elData.sliding) {\n                startTracking(e);\n            }\n        }\n\n        function onMove(e, result) {\n            if (!tail.noSwipe) {\n                if (!tracked) {\n                    startTracking(e);\n                }\n                coo = (dir === 'vertical') ? e._y : e._x;\n\n                moveTrack.push([e._now, coo]);\n\n                moveElPos = startElPos - (startCoo - coo);\n\n                edge = findShadowEdge(moveElPos, min, max, dir);\n\n                if (moveElPos <= min) {\n                    moveElPos = edgeResistance(moveElPos, min);\n                } else if (moveElPos >= max) {\n                    moveElPos = edgeResistance(moveElPos, max);\n                }\n\n                if (!tail.noMove) {\n                    $el.css(getTranslate(moveElPos, dir));\n                    if (!moved) {\n                        moved = true;\n                        // only for mouse\n                        result.touch || MS_POINTER || $el.addClass(grabbingClass);\n                    }\n\n                    (options.onMove || noop).call(el, e, {pos: moveElPos, edge: edge});\n                }\n            }\n        }\n\n        function onEnd(result) {\n            if (tail.noSwipe && result.moved) return;\n\n            if (!tracked) {\n                startTracking(result.startEvent, true);\n            }\n\n            result.touch || MS_POINTER || $el.removeClass(grabbingClass);\n\n            endTime = $.now();\n\n            var _backTimeIdeal = endTime - TOUCH_TIMEOUT,\n                _backTime,\n                _timeDiff,\n                _timeDiffLast,\n                backTime = null,\n                backCoo,\n                virtualPos,\n                limitPos,\n                newPos,\n                overPos,\n                time = TRANSITION_DURATION,\n                speed,\n                friction = options.friction;\n\n            for (var _i = moveTrack.length - 1; _i >= 0; _i--) {\n                _backTime = moveTrack[_i][0];\n                _timeDiff = Math.abs(_backTime - _backTimeIdeal);\n                if (backTime === null || _timeDiff < _timeDiffLast) {\n                    backTime = _backTime;\n                    backCoo = moveTrack[_i][1];\n                } else if (backTime === _backTimeIdeal || _timeDiff > _timeDiffLast) {\n                    break;\n                }\n                _timeDiffLast = _timeDiff;\n            }\n\n            newPos = minMaxLimit(moveElPos, min, max);\n\n            var cooDiff = backCoo - coo,\n                forwardFLAG = cooDiff >= 0,\n                timeDiff = endTime - backTime,\n                longTouchFLAG = timeDiff > TOUCH_TIMEOUT,\n                swipeFLAG = !longTouchFLAG && moveElPos !== startElPos && newPos === moveElPos;\n\n            if (snap) {\n                newPos = minMaxLimit(Math[swipeFLAG ? (forwardFLAG ? 'floor' : 'ceil') : 'round'](moveElPos / snap) * snap, min, max);\n                min = max = newPos;\n            }\n\n            if (swipeFLAG && (snap || newPos === moveElPos)) {\n                speed = -(cooDiff / timeDiff);\n                time *= minMaxLimit(Math.abs(speed), options.timeLow, options.timeHigh);\n                virtualPos = Math.round(moveElPos + speed * time / friction);\n\n                if (!snap) {\n                    newPos = virtualPos;\n                }\n\n                if (!forwardFLAG && virtualPos > max || forwardFLAG && virtualPos < min) {\n                    limitPos = forwardFLAG ? min : max;\n                    overPos = virtualPos - limitPos;\n                    if (!snap) {\n                        newPos = limitPos;\n                    }\n                    overPos = minMaxLimit(newPos + overPos * .03, limitPos - 50, limitPos + 50);\n                    time = Math.abs((moveElPos - overPos) / (speed / friction));\n                }\n            }\n\n            time *= slowFLAG ? 10 : 1;\n\n            (options.onEnd || noop).call(el, $.extend(result, {\n                moved: result.moved || longTouchFLAG && snap,\n                pos: moveElPos,\n                newPos: newPos,\n                overPos: overPos,\n                time: time,\n                dir: dir\n            }));\n        }\n\n        tail = $.extend(touch(options.$wrap, $.extend({}, options, {\n            onStart: onStart,\n            onMove: onMove,\n            onEnd: onEnd\n        })), tail);\n\n        return tail;\n    }\n\n    function wheel($el, options) {\n        var el = $el[0],\n            lockFLAG,\n            lastDirection,\n            lastNow,\n            tail = {\n                prevent: {}\n            };\n\n        addEvent(el, WHEEL, function (e) {\n            var yDelta = e.wheelDeltaY || -1 * e.deltaY || 0,\n                xDelta = e.wheelDeltaX || -1 * e.deltaX || 0,\n                xWin = Math.abs(xDelta) && !Math.abs(yDelta),\n                direction = getDirectionSign(xDelta < 0),\n                sameDirection = lastDirection === direction,\n                now = $.now(),\n                tooFast = now - lastNow < TOUCH_TIMEOUT;\n\n            lastDirection = direction;\n            lastNow = now;\n\n            if (!xWin || !tail.ok || tail.prevent[direction] && !lockFLAG) {\n                return;\n            } else {\n                stopEvent(e, true);\n                if (lockFLAG && sameDirection && tooFast) {\n                    return;\n                }\n            }\n\n            if (options.shift) {\n                lockFLAG = true;\n                clearTimeout(tail.t);\n                tail.t = setTimeout(function () {\n                    lockFLAG = false;\n                }, SCROLL_LOCK_TIMEOUT);\n            }\n\n            (options.onEnd || noop)(e, options.shift ? direction : xDelta);\n\n        });\n\n        return tail;\n    }\n\n    jQuery.Fotorama = function ($fotorama, opts) {\n        $HTML = $('html');\n        $BODY = $('body');\n\n        var that = this,\n            stamp = $.now(),\n            stampClass = _fotoramaClass + stamp,\n            fotorama = $fotorama[0],\n            data,\n            dataFrameCount = 1,\n            fotoramaData = $fotorama.data(),\n            size,\n\n            $style = $('<style></style>'),\n\n            $anchor = $(div(hiddenClass)),\n            $wrap = $fotorama.find(cls(wrapClass)),\n            $stage = $wrap.find(cls(stageClass)),\n            stage = $stage[0],\n\n            $stageShaft = $fotorama.find(cls(stageShaftClass)),\n            $stageFrame = $(),\n            $arrPrev = $fotorama.find(cls(arrPrevClass)),\n            $arrNext = $fotorama.find(cls(arrNextClass)),\n            $arrs = $fotorama.find(cls(arrClass)),\n            $navWrap = $fotorama.find(cls(navWrapClass)),\n            $nav = $navWrap.find(cls(navClass)),\n            $navShaft = $nav.find(cls(navShaftClass)),\n            $navFrame,\n            $navDotFrame = $(),\n            $navThumbFrame = $(),\n\n            stageShaftData = $stageShaft.data(),\n            navShaftData = $navShaft.data(),\n\n            $thumbBorder = $fotorama.find(cls(thumbBorderClass)),\n            $thumbArrLeft = $fotorama.find(cls(thumbArrLeft)),\n            $thumbArrRight = $fotorama.find(cls(thumbArrRight)),\n\n            $fullscreenIcon = $fotorama.find(cls(fullscreenIconClass)),\n            fullscreenIcon = $fullscreenIcon[0],\n            $videoPlay = $(div(videoPlayClass)),\n            $videoClose = $fotorama.find(cls(videoCloseClass)),\n            videoClose = $videoClose[0],\n\n            $spinner = $fotorama.find(cls(fotoramaSpinnerClass)),\n\n            $videoPlaying,\n\n            activeIndex = false,\n            activeFrame,\n            activeIndexes,\n            repositionIndex,\n            dirtyIndex,\n            lastActiveIndex,\n            prevIndex,\n            nextIndex,\n            nextAutoplayIndex,\n            startIndex,\n\n            o_loop,\n            o_nav,\n            o_navThumbs,\n            o_navTop,\n            o_allowFullScreen,\n            o_nativeFullScreen,\n            o_fade,\n            o_thumbSide,\n            o_thumbSide2,\n            o_transitionDuration,\n            o_transition,\n            o_shadows,\n            o_rtl,\n            o_keyboard,\n            lastOptions = {},\n\n            measures = {},\n            measuresSetFLAG,\n\n            stageShaftTouchTail = {},\n            stageWheelTail = {},\n            navShaftTouchTail = {},\n            navWheelTail = {},\n\n            scrollTop,\n            scrollLeft,\n\n            showedFLAG,\n            pausedAutoplayFLAG,\n            stoppedAutoplayFLAG,\n\n            toDeactivate = {},\n            toDetach = {},\n\n            measuresStash,\n\n            touchedFLAG,\n\n            hoverFLAG,\n\n            navFrameKey,\n            stageLeft = 0,\n\n            fadeStack = [];\n\n        $wrap[STAGE_FRAME_KEY] = $('<div class=\"' + stageFrameClass + '\"></div>');\n        $wrap[NAV_THUMB_FRAME_KEY] = $($.Fotorama.jst.thumb());\n        $wrap[NAV_DOT_FRAME_KEY] = $($.Fotorama.jst.dots());\n\n        toDeactivate[STAGE_FRAME_KEY] = [];\n        toDeactivate[NAV_THUMB_FRAME_KEY] = [];\n        toDeactivate[NAV_DOT_FRAME_KEY] = [];\n        toDetach[STAGE_FRAME_KEY] = {};\n\n        $wrap.addClass(CSS3 ? wrapCss3Class : wrapCss2Class);\n\n        fotoramaData.fotorama = this;\n\n        /**\n         * Search video items in incoming data and transform object for video layout.\n         *\n         */\n        function checkForVideo() {\n            $.each(data, function (i, dataFrame) {\n                if (!dataFrame.i) {\n                    dataFrame.i = dataFrameCount++;\n                    var video = findVideoId(dataFrame.video, true);\n                    if (video) {\n                        var thumbs = {};\n                        dataFrame.video = video;\n                        if (!dataFrame.img && !dataFrame.thumb) {\n                            thumbs = getVideoThumbs(dataFrame, data, that);\n                        } else {\n                            dataFrame.thumbsReady = true;\n                        }\n                        updateData(data, {img: thumbs.img, thumb: thumbs.thumb}, dataFrame.i, that);\n                    }\n                }\n            });\n        }\n\n        /**\n         * Checks if current media object is YouTube or Vimeo video stream\n         * @returns {boolean}\n         */\n        function isVideo() {\n            return $((that.activeFrame || {}).$stageFrame || {}).hasClass('fotorama-video-container');\n        }\n\n        function allowKey(key) {\n            return o_keyboard[key];\n        }\n\n        function setStagePosition() {\n            if ($stage !== undefined) {\n\n                if (opts.navdir == 'vertical') {\n                    var padding = opts.thumbwidth + opts.thumbmargin;\n\n                    $stage.css('left', padding);\n                    $arrNext.css('right', padding);\n                    $fullscreenIcon.css('right', padding);\n                    $wrap.css('width', $wrap.css('width') + padding);\n                    $stageShaft.css('max-width', $wrap.width() - padding);\n                } else {\n                    $stage.css('left', '');\n                    $arrNext.css('right', '');\n                    $fullscreenIcon.css('right', '');\n                    $wrap.css('width', $wrap.css('width') + padding);\n                    $stageShaft.css('max-width', '');\n                }\n            }\n        }\n\n        function bindGlobalEvents(FLAG) {\n            var keydownCommon = 'keydown.' + _fotoramaClass,\n                localStamp = _fotoramaClass + stamp,\n                keydownLocal = 'keydown.' + localStamp,\n                keyupLocal = 'keyup.' + localStamp,\n                resizeLocal = 'resize.' + localStamp + ' ' + 'orientationchange.' + localStamp,\n                showParams;\n\n            if (FLAG) {\n                $DOCUMENT\n                    .on(keydownLocal, function (e) {\n                        var catched,\n                            index;\n\n                        if ($videoPlaying && e.keyCode === 27) {\n                            catched = true;\n                            unloadVideo($videoPlaying, true, true);\n                        } else if (that.fullScreen || (opts.keyboard && !that.index)) {\n                            if (e.keyCode === 27) {\n                                catched = true;\n                                that.cancelFullScreen();\n                            } else if ((e.shiftKey && e.keyCode === 32 && allowKey('space')) || (!e.altKey && !e.metaKey && e.keyCode === 37 && allowKey('left')) || (e.keyCode === 38 && allowKey('up') && $(':focus').attr('data-gallery-role'))) {\n                                that.longPress.progress();\n                                index = '<';\n                            } else if ((e.keyCode === 32 && allowKey('space')) || (!e.altKey && !e.metaKey && e.keyCode === 39 && allowKey('right')) || (e.keyCode === 40 && allowKey('down') && $(':focus').attr('data-gallery-role'))) {\n                                that.longPress.progress();\n                                index = '>';\n                            } else if (e.keyCode === 36 && allowKey('home')) {\n                                that.longPress.progress();\n                                index = '<<';\n                            } else if (e.keyCode === 35 && allowKey('end')) {\n                                that.longPress.progress();\n                                index = '>>';\n                            }\n                        }\n\n                        (catched || index) && stopEvent(e);\n                        showParams = {index: index, slow: e.altKey, user: true};\n                        index && (that.longPress.inProgress ?\n                            that.showWhileLongPress(showParams) :\n                            that.show(showParams));\n                    });\n\n                if (FLAG) {\n                    $DOCUMENT\n                        .on(keyupLocal, function (e) {\n                            if (that.longPress.inProgress) {\n                                that.showEndLongPress({user: true});\n                            }\n                            that.longPress.reset();\n                        });\n                }\n\n                if (!that.index) {\n                    $DOCUMENT\n                        .off(keydownCommon)\n                        .on(keydownCommon, 'textarea, input, select', function (e) {\n                            !$BODY.hasClass(_fullscreenClass) && e.stopPropagation();\n                        });\n                }\n\n                $WINDOW.on(resizeLocal, that.resize);\n            } else {\n                $DOCUMENT.off(keydownLocal);\n                $WINDOW.off(resizeLocal);\n            }\n        }\n\n        function appendElements(FLAG) {\n            if (FLAG === appendElements.f) return;\n\n            if (FLAG) {\n                $fotorama\n                    .addClass(_fotoramaClass + ' ' + stampClass)\n                    .before($anchor)\n                    .before($style);\n                addInstance(that);\n            } else {\n                $anchor.detach();\n                $style.detach();\n                $fotorama\n                    .html(fotoramaData.urtext)\n                    .removeClass(stampClass);\n\n                hideInstance(that);\n            }\n\n            bindGlobalEvents(FLAG);\n            appendElements.f = FLAG;\n        }\n\n        /**\n         * Set and install data from incoming @param {JSON} options or takes data attr from data-\"name\"=... values.\n         */\n        function setData() {\n            data = that.data = data || clone(opts.data) || getDataFromHtml($fotorama);\n            size = that.size = data.length;\n\n            ready.ok && opts.shuffle && shuffle(data);\n\n            checkForVideo();\n\n            activeIndex = limitIndex(activeIndex);\n\n            size && appendElements(true);\n        }\n\n        function stageNoMove() {\n            var _noMove = size < 2 || $videoPlaying;\n            stageShaftTouchTail.noMove = _noMove || o_fade;\n            stageShaftTouchTail.noSwipe = _noMove || !opts.swipe;\n\n            !o_transition && $stageShaft.toggleClass(grabClass, !opts.click && !stageShaftTouchTail.noMove && !stageShaftTouchTail.noSwipe);\n            MS_POINTER && $wrap.toggleClass(wrapPanYClass, !stageShaftTouchTail.noSwipe);\n        }\n\n        function setAutoplayInterval(interval) {\n            if (interval === true) interval = '';\n            opts.autoplay = Math.max(+interval || AUTOPLAY_INTERVAL, o_transitionDuration * 1.5);\n        }\n\n        function updateThumbArrow(opt) {\n            if (opt.navarrows && opt.nav === 'thumbs') {\n                $thumbArrLeft.show();\n                $thumbArrRight.show();\n            } else {\n                $thumbArrLeft.hide();\n                $thumbArrRight.hide();\n            }\n\n        }\n\n        function getThumbsInSlide($el, opts) {\n            return Math.floor($wrap.width() / (opts.thumbwidth + opts.thumbmargin));\n        }\n\n        /**\n         * Options on the fly\n         * */\n        function setOptions() {\n            if (!opts.nav || opts.nav === 'dots') {\n                opts.navdir = 'horizontal'\n            }\n\n            that.options = opts = optionsToLowerCase(opts);\n            thumbsPerSlide = getThumbsInSlide($wrap, opts);\n\n            o_fade = (opts.transition === 'crossfade' || opts.transition === 'dissolve');\n\n            o_loop = opts.loop && (size > 2 || (o_fade && (!o_transition || o_transition !== 'slide')));\n\n            o_transitionDuration = +opts.transitionduration || TRANSITION_DURATION;\n\n            o_rtl = opts.direction === 'rtl';\n\n            o_keyboard = $.extend({}, opts.keyboard && KEYBOARD_OPTIONS, opts.keyboard);\n            updateThumbArrow(opts);\n            var classes = {add: [], remove: []};\n\n            function addOrRemoveClass(FLAG, value) {\n                classes[FLAG ? 'add' : 'remove'].push(value);\n            }\n\n            if (size > 1) {\n                o_nav = opts.nav;\n                o_navTop = opts.navposition === 'top';\n                classes.remove.push(selectClass);\n\n                $arrs.toggle(!!opts.arrows);\n            } else {\n                o_nav = false;\n                $arrs.hide();\n            }\n\n            arrsUpdate();\n            stageWheelUpdate();\n            thumbArrUpdate();\n            if (opts.autoplay) setAutoplayInterval(opts.autoplay);\n\n            o_thumbSide = numberFromMeasure(opts.thumbwidth) || THUMB_SIZE;\n            o_thumbSide2 = numberFromMeasure(opts.thumbheight) || THUMB_SIZE;\n\n            stageWheelTail.ok = navWheelTail.ok = opts.trackpad && !SLOW;\n\n            stageNoMove();\n\n            extendMeasures(opts, [measures]);\n\n            o_navThumbs = o_nav === 'thumbs';\n\n            if ($navWrap.filter(':hidden') && !!o_nav) {\n                $navWrap.show();\n            }\n            if (o_navThumbs) {\n                frameDraw(size, 'navThumb');\n\n                $navFrame = $navThumbFrame;\n                navFrameKey = NAV_THUMB_FRAME_KEY;\n\n                setStyle($style, $.Fotorama.jst.style({\n                    w: o_thumbSide,\n                    h: o_thumbSide2,\n                    b: opts.thumbborderwidth,\n                    m: opts.thumbmargin,\n                    s: stamp,\n                    q: !COMPAT\n                }));\n\n                $nav\n                    .addClass(navThumbsClass)\n                    .removeClass(navDotsClass);\n            } else if (o_nav === 'dots') {\n                frameDraw(size, 'navDot');\n\n                $navFrame = $navDotFrame;\n                navFrameKey = NAV_DOT_FRAME_KEY;\n\n                $nav\n                    .addClass(navDotsClass)\n                    .removeClass(navThumbsClass);\n            } else {\n                $navWrap.hide();\n                o_nav = false;\n                $nav.removeClass(navThumbsClass + ' ' + navDotsClass);\n            }\n\n            if (o_nav) {\n                if (o_navTop) {\n                    $navWrap.insertBefore($stage);\n                } else {\n                    $navWrap.insertAfter($stage);\n                }\n                frameAppend.nav = false;\n\n                frameAppend($navFrame, $navShaft, 'nav');\n            }\n\n            o_allowFullScreen = opts.allowfullscreen;\n\n            if (o_allowFullScreen) {\n                $fullscreenIcon.prependTo($stage);\n                o_nativeFullScreen = FULLSCREEN && o_allowFullScreen === 'native';\n            } else {\n                $fullscreenIcon.detach();\n                o_nativeFullScreen = false;\n            }\n\n            addOrRemoveClass(o_fade, wrapFadeClass);\n            addOrRemoveClass(!o_fade, wrapSlideClass);\n            addOrRemoveClass(!opts.captions, wrapNoCaptionsClass);\n            addOrRemoveClass(o_rtl, wrapRtlClass);\n            addOrRemoveClass(opts.arrows, wrapToggleArrowsClass);\n\n            o_shadows = opts.shadows && !SLOW;\n            addOrRemoveClass(!o_shadows, wrapNoShadowsClass);\n\n            $wrap\n                .addClass(classes.add.join(' '))\n                .removeClass(classes.remove.join(' '));\n\n            lastOptions = $.extend({}, opts);\n            setStagePosition();\n        }\n\n        function normalizeIndex(index) {\n            return index < 0 ? (size + (index % size)) % size : index >= size ? index % size : index;\n        }\n\n        function limitIndex(index) {\n            return minMaxLimit(index, 0, size - 1);\n        }\n\n        function edgeIndex(index) {\n            return o_loop ? normalizeIndex(index) : limitIndex(index);\n        }\n\n        function getPrevIndex(index) {\n            return index > 0 || o_loop ? index - 1 : false;\n        }\n\n        function getNextIndex(index) {\n            return index < size - 1 || o_loop ? index + 1 : false;\n        }\n\n        function setStageShaftMinmaxAndSnap() {\n            stageShaftTouchTail.min = o_loop ? -Infinity : -getPosByIndex(size - 1, measures.w, opts.margin, repositionIndex);\n            stageShaftTouchTail.max = o_loop ? Infinity : -getPosByIndex(0, measures.w, opts.margin, repositionIndex);\n            stageShaftTouchTail.snap = measures.w + opts.margin;\n        }\n\n        function setNavShaftMinMax() {\n\n            var isVerticalDir = (opts.navdir === 'vertical');\n            var param = isVerticalDir ? $navShaft.height() : $navShaft.width();\n            var mainParam = isVerticalDir ? measures.h : measures.nw;\n            navShaftTouchTail.min = Math.min(0, mainParam - param);\n            navShaftTouchTail.max = 0;\n            navShaftTouchTail.direction = opts.navdir;\n            $navShaft.toggleClass(grabClass, !(navShaftTouchTail.noMove = navShaftTouchTail.min === navShaftTouchTail.max));\n        }\n\n        function eachIndex(indexes, type, fn) {\n            if (typeof indexes === 'number') {\n                indexes = new Array(indexes);\n                var rangeFLAG = true;\n            }\n            return $.each(indexes, function (i, index) {\n                if (rangeFLAG) index = i;\n                if (typeof index === 'number') {\n                    var dataFrame = data[normalizeIndex(index)];\n\n                    if (dataFrame) {\n                        var key = '$' + type + 'Frame',\n                            $frame = dataFrame[key];\n\n                        fn.call(this, i, index, dataFrame, $frame, key, $frame && $frame.data());\n                    }\n                }\n            });\n        }\n\n        function setMeasures(width, height, ratio, index) {\n            if (!measuresSetFLAG || (measuresSetFLAG === '*' && index === startIndex)) {\n\n                width = measureIsValid(opts.width) || measureIsValid(width) || WIDTH;\n                height = measureIsValid(opts.height) || measureIsValid(height) || HEIGHT;\n                that.resize({\n                    width: width,\n                    ratio: opts.ratio || ratio || width / height\n                }, 0, index !== startIndex && '*');\n            }\n        }\n\n        function loadImg(indexes, type, specialMeasures, again) {\n\n            eachIndex(indexes, type, function (i, index, dataFrame, $frame, key, frameData) {\n\n                if (!$frame) return;\n\n                var fullFLAG = that.fullScreen && !frameData.$full && type === 'stage';\n\n                if (frameData.$img && !again && !fullFLAG) return;\n\n                var img = new Image(),\n                    $img = $(img),\n                    imgData = $img.data();\n\n                frameData[fullFLAG ? '$full' : '$img'] = $img;\n\n                var srcKey = type === 'stage' ? (fullFLAG ? 'full' : 'img') : 'thumb',\n                    src = dataFrame[srcKey],\n                    dummy = fullFLAG ? dataFrame['img'] : dataFrame[type === 'stage' ? 'thumb' : 'img'];\n\n                if (type === 'navThumb') $frame = frameData.$wrap;\n\n                function triggerTriggerEvent(event) {\n                    var _index = normalizeIndex(index);\n                    triggerEvent(event, {\n                        index: _index,\n                        src: src,\n                        frame: data[_index]\n                    });\n                }\n\n                function error() {\n                    $img.remove();\n\n                    $.Fotorama.cache[src] = 'error';\n\n                    if ((!dataFrame.html || type !== 'stage') && dummy && dummy !== src) {\n                        dataFrame[srcKey] = src = dummy;\n                        frameData.$full = null;\n                        loadImg([index], type, specialMeasures, true);\n                    } else {\n                        if (src && !dataFrame.html && !fullFLAG) {\n                            $frame\n                                .trigger('f:error')\n                                .removeClass(loadingClass)\n                                .addClass(errorClass);\n\n                            triggerTriggerEvent('error');\n                        } else if (type === 'stage') {\n                            $frame\n                                .trigger('f:load')\n                                .removeClass(loadingClass + ' ' + errorClass)\n                                .addClass(loadedClass);\n\n                            triggerTriggerEvent('load');\n                            setMeasures();\n                        }\n\n                        frameData.state = 'error';\n\n                        if (size > 1 && data[index] === dataFrame && !dataFrame.html && !dataFrame.deleted && !dataFrame.video && !fullFLAG) {\n                            dataFrame.deleted = true;\n                            that.splice(index, 1);\n                        }\n                    }\n                }\n\n                function loaded() {\n                    $.Fotorama.measures[src] = imgData.measures = $.Fotorama.measures[src] || {\n                            width: img.width,\n                            height: img.height,\n                            ratio: img.width / img.height\n                        };\n\n                    setMeasures(imgData.measures.width, imgData.measures.height, imgData.measures.ratio, index);\n\n                    $img\n                        .off('load error')\n                        .addClass('' + (fullFLAG ? imgFullClass: imgClass))\n                        .attr('aria-hidden', 'false')\n                        .prependTo($frame);\n\n                    if ($frame.hasClass(stageFrameClass) && !$frame.hasClass(videoContainerClass)) {\n                        $frame.attr(\"href\", $img.attr(\"src\"));\n                    }\n\n                    fit($img, (\n                            $.isFunction(specialMeasures) ? specialMeasures() : specialMeasures) || measures);\n\n                    $.Fotorama.cache[src] = frameData.state = 'loaded';\n\n                    setTimeout(function () {\n                        $frame\n                            .trigger('f:load')\n                            .removeClass(loadingClass + ' ' + errorClass)\n                            .addClass(loadedClass + ' ' + (fullFLAG ? loadedFullClass : loadedImgClass));\n\n                        if (type === 'stage') {\n                            triggerTriggerEvent('load');\n                        } else if (dataFrame.thumbratio === AUTO || !dataFrame.thumbratio && opts.thumbratio === AUTO) {\n                            // danger! reflow for all thumbnails\n                            dataFrame.thumbratio = imgData.measures.ratio;\n                            reset();\n                        }\n                    }, 0);\n                }\n\n                if (!src) {\n                    error();\n                    return;\n                }\n\n                function waitAndLoad() {\n                    var _i = 10;\n                    waitFor(function () {\n                        return !touchedFLAG || !_i-- && !SLOW;\n                    }, function () {\n                        loaded();\n                    });\n                }\n\n                if (!$.Fotorama.cache[src]) {\n                    $.Fotorama.cache[src] = '*';\n\n                    $img\n                        .on('load', waitAndLoad)\n                        .on('error', error);\n                } else {\n                    (function justWait() {\n                        if ($.Fotorama.cache[src] === 'error') {\n                            error();\n                        } else if ($.Fotorama.cache[src] === 'loaded') {\n                            setTimeout(waitAndLoad, 0);\n                        } else {\n                            setTimeout(justWait, 100);\n                        }\n                    })();\n                }\n\n                frameData.state = '';\n                img.src = src;\n\n                if (frameData.data.caption) {\n                    img.alt = frameData.data.caption || \"\";\n                }\n\n                if (frameData.data.full) {\n                    $(img).data('original', frameData.data.full);\n                }\n\n                if (UTIL.isExpectedCaption(dataFrame, opts.showcaption)) {\n                    $(img).attr('aria-labelledby', dataFrame.labelledby);\n                }\n            });\n        }\n\n        function updateFotoramaState() {\n            var $frame = activeFrame[STAGE_FRAME_KEY];\n\n            if ($frame && !$frame.data().state) {\n                $spinner.addClass(spinnerShowClass);\n                $frame.on('f:load f:error', function () {\n                    $frame.off('f:load f:error');\n                    $spinner.removeClass(spinnerShowClass);\n                });\n            }\n        }\n\n        function addNavFrameEvents(frame) {\n            addEnterUp(frame, onNavFrameClick);\n            addFocus(frame, function () {\n\n                setTimeout(function () {\n                    lockScroll($nav);\n                }, 0);\n                slideNavShaft({time: o_transitionDuration, guessIndex: $(this).data().eq, minMax: navShaftTouchTail});\n            });\n        }\n\n        function frameDraw(indexes, type) {\n            eachIndex(indexes, type, function (i, index, dataFrame, $frame, key, frameData) {\n                if ($frame) return;\n\n                $frame = dataFrame[key] = $wrap[key].clone();\n                frameData = $frame.data();\n                frameData.data = dataFrame;\n                var frame = $frame[0],\n                    labelledbyValue = \"labelledby\" + $.now();\n\n                if (type === 'stage') {\n\n                    if (dataFrame.html) {\n                        $('<div class=\"' + htmlClass + '\"></div>')\n                            .append(\n                            dataFrame._html ? $(dataFrame.html)\n                                .removeAttr('id')\n                                .html(dataFrame._html) // Because of IE\n                                : dataFrame.html\n                        )\n                            .appendTo($frame);\n                    }\n\n                    if (dataFrame.id) {\n                        labelledbyValue = dataFrame.id || labelledbyValue;\n                    }\n                    dataFrame.labelledby = labelledbyValue;\n\n                    if (UTIL.isExpectedCaption(dataFrame, opts.showcaption)) {\n                        $($.Fotorama.jst.frameCaption({\n                            caption: dataFrame.caption,\n                            labelledby: labelledbyValue\n                        })).appendTo($frame);\n                    }\n\n                    dataFrame.video && $frame\n                        .addClass(stageFrameVideoClass)\n                        .append($videoPlay.clone());\n\n                    // This solves tabbing problems\n                    addFocus(frame, function (e) {\n                        setTimeout(function () {\n                            lockScroll($stage);\n                        }, 0);\n                        clickToShow({index: frameData.eq, user: true}, e);\n                    });\n\n                    $stageFrame = $stageFrame.add($frame);\n                } else if (type === 'navDot') {\n                    addNavFrameEvents(frame);\n                    $navDotFrame = $navDotFrame.add($frame);\n                } else if (type === 'navThumb') {\n                    addNavFrameEvents(frame);\n                    frameData.$wrap = $frame.children(':first');\n\n                    $navThumbFrame = $navThumbFrame.add($frame);\n                    if (dataFrame.video) {\n                        frameData.$wrap.append($videoPlay.clone());\n                    }\n                }\n            });\n        }\n\n        function callFit($img, measuresToFit) {\n            return $img && $img.length && fit($img, measuresToFit);\n        }\n\n        function stageFramePosition(indexes) {\n            eachIndex(indexes, 'stage', function (i, index, dataFrame, $frame, key, frameData) {\n                if (!$frame) return;\n\n                var normalizedIndex = normalizeIndex(index);\n                frameData.eq = normalizedIndex;\n\n                toDetach[STAGE_FRAME_KEY][normalizedIndex] = $frame.css($.extend({left: o_fade ? 0 : getPosByIndex(index, measures.w, opts.margin, repositionIndex)}, o_fade && getDuration(0)));\n\n                if (isDetached($frame[0])) {\n                    $frame.appendTo($stageShaft);\n                    unloadVideo(dataFrame.$video);\n                }\n\n                callFit(frameData.$img, measures);\n                callFit(frameData.$full, measures);\n\n                if ($frame.hasClass(stageFrameClass) && !($frame.attr('aria-hidden') === \"false\" && $frame.hasClass(activeClass))) {\n                    $frame.attr('aria-hidden', 'true');\n                }\n            });\n        }\n\n        function thumbsDraw(pos, loadFLAG) {\n            var leftLimit,\n                rightLimit,\n                exceedLimit;\n\n\n            if (o_nav !== 'thumbs' || isNaN(pos)) return;\n\n            leftLimit = -pos;\n            rightLimit = -pos + measures.nw;\n\n            if (opts.navdir === 'vertical') {\n                pos = pos - opts.thumbheight;\n                rightLimit = -pos + measures.h;\n            }\n\n            $navThumbFrame.each(function () {\n                var $this = $(this),\n                    thisData = $this.data(),\n                    eq = thisData.eq,\n                    getSpecialMeasures = function () {\n                        return {\n                            h: o_thumbSide2,\n                            w: thisData.w\n                        }\n                    },\n                    specialMeasures = getSpecialMeasures(),\n                    exceedLimit = opts.navdir === 'vertical' ?\n                    thisData.t > rightLimit : thisData.l > rightLimit;\n                specialMeasures.w = thisData.w;\n\n                if ((opts.navdir !== 'vertical' && thisData.l + thisData.w < leftLimit)\n                    || exceedLimit\n                    || callFit(thisData.$img, specialMeasures)) return;\n\n                loadFLAG && loadImg([eq], 'navThumb', getSpecialMeasures);\n            });\n        }\n\n        function frameAppend($frames, $shaft, type) {\n            if (!frameAppend[type]) {\n\n                var thumbsFLAG = type === 'nav' && o_navThumbs,\n                    left = 0,\n                    top = 0;\n\n                $shaft.append(\n                    $frames\n                        .filter(function () {\n                            var actual,\n                                $this = $(this),\n                                frameData = $this.data();\n                            for (var _i = 0, _l = data.length; _i < _l; _i++) {\n                                if (frameData.data === data[_i]) {\n                                    actual = true;\n                                    frameData.eq = _i;\n                                    break;\n                                }\n                            }\n                            return actual || $this.remove() && false;\n                        })\n                        .sort(function (a, b) {\n                            return $(a).data().eq - $(b).data().eq;\n                        })\n                        .each(function () {\n                            var $this = $(this),\n                                frameData = $this.data();\n                            UTIL.setThumbAttr($this, frameData.data.caption, \"aria-label\");\n                        })\n                        .each(function () {\n\n                            if (!thumbsFLAG) return;\n\n                            var $this = $(this),\n                                frameData = $this.data(),\n                                thumbwidth = Math.round(o_thumbSide2 * frameData.data.thumbratio) || o_thumbSide,\n                                thumbheight = Math.round(o_thumbSide / frameData.data.thumbratio) || o_thumbSide2;\n                            frameData.t = top;\n                            frameData.h = thumbheight;\n                            frameData.l = left;\n                            frameData.w = thumbwidth;\n\n                            $this.css({width: thumbwidth});\n\n                            top += thumbheight + opts.thumbmargin;\n                            left += thumbwidth + opts.thumbmargin;\n                        })\n                );\n\n                frameAppend[type] = true;\n            }\n        }\n\n        function getDirection(x) {\n            return x - stageLeft > measures.w / 3;\n        }\n\n        function disableDirrection(i) {\n            return !o_loop && (!(activeIndex + i) || !(activeIndex - size + i)) && !$videoPlaying;\n        }\n\n        function arrsUpdate() {\n            var disablePrev = disableDirrection(0),\n                disableNext = disableDirrection(1);\n            $arrPrev\n                .toggleClass(arrDisabledClass, disablePrev)\n                .attr(disableAttr(disablePrev, false));\n            $arrNext\n                .toggleClass(arrDisabledClass, disableNext)\n                .attr(disableAttr(disableNext, false));\n        }\n\n        function thumbArrUpdate() {\n            var isLeftDisable = false,\n                isRightDisable = false;\n            if (opts.navtype === 'thumbs' && !opts.loop) {\n                (activeIndex == 0) ? isLeftDisable = true : isLeftDisable = false;\n                (activeIndex == opts.data.length - 1) ? isRightDisable = true : isRightDisable = false;\n            }\n            if (opts.navtype === 'slides') {\n                var pos = readPosition($navShaft, opts.navdir);\n                pos >= navShaftTouchTail.max ? isLeftDisable = true : isLeftDisable = false;\n                pos <= Math.round(navShaftTouchTail.min) ? isRightDisable = true : isRightDisable = false;\n            }\n            $thumbArrLeft\n                .toggleClass(arrDisabledClass, isLeftDisable)\n                .attr(disableAttr(isLeftDisable, true));\n            $thumbArrRight\n                .toggleClass(arrDisabledClass, isRightDisable)\n                .attr(disableAttr(isRightDisable, true));\n        }\n\n        function stageWheelUpdate() {\n            if (stageWheelTail.ok) {\n                stageWheelTail.prevent = {'<': disableDirrection(0), '>': disableDirrection(1)};\n            }\n        }\n\n        function getNavFrameBounds($navFrame) {\n            var navFrameData = $navFrame.data(),\n                left,\n                top,\n                width,\n                height;\n\n            if (o_navThumbs) {\n                left = navFrameData.l;\n                top = navFrameData.t;\n                width = navFrameData.w;\n                height = navFrameData.h;\n            } else {\n                left = $navFrame.position().left;\n                width = $navFrame.width();\n            }\n\n            var horizontalBounds = {\n                c: left + width / 2,\n                min: -left + opts.thumbmargin * 10,\n                max: -left + measures.w - width - opts.thumbmargin * 10\n            };\n\n            var verticalBounds = {\n                c: top + height / 2,\n                min: -top + opts.thumbmargin * 10,\n                max: -top + measures.h - height - opts.thumbmargin * 10\n            };\n\n            return opts.navdir === 'vertical' ? verticalBounds : horizontalBounds;\n        }\n\n        function slideThumbBorder(time) {\n            var navFrameData = activeFrame[navFrameKey].data();\n            slide($thumbBorder, {\n                time: time * 1.2,\n                pos: (opts.navdir === 'vertical' ? navFrameData.t : navFrameData.l),\n                width: navFrameData.w,\n                height: navFrameData.h,\n                direction: opts.navdir\n            });\n        }\n\n        function slideNavShaft(options) {\n            var $guessNavFrame = data[options.guessIndex][navFrameKey],\n                typeOfAnimation = opts.navtype;\n\n            var overflowFLAG,\n                time,\n                minMax,\n                boundTop,\n                boundLeft,\n                l,\n                pos,\n                x;\n\n            if ($guessNavFrame) {\n                if (typeOfAnimation === 'thumbs') {\n                    overflowFLAG = navShaftTouchTail.min !== navShaftTouchTail.max;\n                    minMax = options.minMax || overflowFLAG && getNavFrameBounds(activeFrame[navFrameKey]);\n                    boundTop = overflowFLAG && (options.keep && slideNavShaft.t ? slideNavShaft.l : minMaxLimit((options.coo || measures.nw / 2) - getNavFrameBounds($guessNavFrame).c, minMax.min, minMax.max));\n                    boundLeft = overflowFLAG && (options.keep && slideNavShaft.l ? slideNavShaft.l : minMaxLimit((options.coo || measures.nw / 2) - getNavFrameBounds($guessNavFrame).c, minMax.min, minMax.max));\n                    l = (opts.navdir === 'vertical' ? boundTop : boundLeft);\n                    pos = overflowFLAG && minMaxLimit(l, navShaftTouchTail.min, navShaftTouchTail.max) || 0;\n                    time = options.time * 1.1;\n                    slide($navShaft, {\n                        time: time,\n                        pos: pos,\n                        direction: opts.navdir,\n                        onEnd: function () {\n                            thumbsDraw(pos, true);\n                            thumbArrUpdate();\n                        }\n                    });\n\n                    setShadow($nav, findShadowEdge(pos, navShaftTouchTail.min, navShaftTouchTail.max, opts.navdir));\n                    slideNavShaft.l = l;\n                } else {\n                    x = readPosition($navShaft, opts.navdir);\n                    time = options.time * 1.11;\n\n                    pos = validateSlidePos(opts, navShaftTouchTail, options.guessIndex, x, $guessNavFrame, $navWrap, opts.navdir);\n\n                    slide($navShaft, {\n                        time: time,\n                        pos: pos,\n                        direction: opts.navdir,\n                        onEnd: function () {\n                            thumbsDraw(pos, true);\n                            thumbArrUpdate();\n                        }\n                    });\n                    setShadow($nav, findShadowEdge(pos, navShaftTouchTail.min, navShaftTouchTail.max, opts.navdir));\n                }\n            }\n        }\n\n        function navUpdate() {\n            deactivateFrames(navFrameKey);\n            toDeactivate[navFrameKey].push(activeFrame[navFrameKey].addClass(activeClass).attr('data-active', true));\n        }\n\n        function deactivateFrames(key) {\n            var _toDeactivate = toDeactivate[key];\n\n            while (_toDeactivate.length) {\n                _toDeactivate.shift().removeClass(activeClass).attr('data-active', false);\n            }\n        }\n\n        function detachFrames(key) {\n            var _toDetach = toDetach[key];\n\n            $.each(activeIndexes, function (i, index) {\n                delete _toDetach[normalizeIndex(index)];\n            });\n\n            $.each(_toDetach, function (index, $frame) {\n                delete _toDetach[index];\n                $frame.detach();\n            });\n        }\n\n        function stageShaftReposition(skipOnEnd) {\n\n            repositionIndex = dirtyIndex = activeIndex;\n\n            var $frame = activeFrame[STAGE_FRAME_KEY];\n\n            if ($frame) {\n                deactivateFrames(STAGE_FRAME_KEY);\n                toDeactivate[STAGE_FRAME_KEY].push($frame.addClass(activeClass).attr('data-active', true));\n\n                if ($frame.hasClass(stageFrameClass)) {\n                    $frame.attr('aria-hidden', 'false');\n                }\n\n                skipOnEnd || that.showStage.onEnd(true);\n                stop($stageShaft, 0, true);\n\n                detachFrames(STAGE_FRAME_KEY);\n                stageFramePosition(activeIndexes);\n                setStageShaftMinmaxAndSnap();\n                setNavShaftMinMax();\n                addEnterUp($stageShaft[0], function () {\n                    if (!$fotorama.hasClass(fullscreenClass)) {\n                        that.requestFullScreen();\n                        $fullscreenIcon.focus();\n                    }\n                });\n            }\n        }\n\n        function extendMeasures(options, measuresArray) {\n            if (!options) return;\n\n            $.each(measuresArray, function (i, measures) {\n                if (!measures) return;\n\n                $.extend(measures, {\n                    width: options.width || measures.width,\n                    height: options.height,\n                    minwidth: options.minwidth,\n                    maxwidth: options.maxwidth,\n                    minheight: options.minheight,\n                    maxheight: options.maxheight,\n                    ratio: getRatio(options.ratio)\n                })\n            });\n        }\n\n        function triggerEvent(event, extra) {\n            $fotorama.trigger(_fotoramaClass + ':' + event, [that, extra]);\n        }\n\n        function onTouchStart() {\n            clearTimeout(onTouchEnd.t);\n            touchedFLAG = 1;\n\n            if (opts.stopautoplayontouch) {\n                that.stopAutoplay();\n            } else {\n                pausedAutoplayFLAG = true;\n            }\n        }\n\n        function onTouchEnd() {\n            if (!touchedFLAG) return;\n            if (!opts.stopautoplayontouch) {\n                releaseAutoplay();\n                changeAutoplay();\n            }\n\n            onTouchEnd.t = setTimeout(function () {\n                touchedFLAG = 0;\n            }, TRANSITION_DURATION + TOUCH_TIMEOUT);\n        }\n\n        function releaseAutoplay() {\n            pausedAutoplayFLAG = !!($videoPlaying || stoppedAutoplayFLAG);\n        }\n\n        function changeAutoplay() {\n\n            clearTimeout(changeAutoplay.t);\n            waitFor.stop(changeAutoplay.w);\n\n            if (!opts.autoplay || pausedAutoplayFLAG) {\n                if (that.autoplay) {\n                    that.autoplay = false;\n                    triggerEvent('stopautoplay');\n                }\n\n                return;\n            }\n\n            if (!that.autoplay) {\n                that.autoplay = true;\n                triggerEvent('startautoplay');\n            }\n\n            var _activeIndex = activeIndex;\n\n\n            var frameData = activeFrame[STAGE_FRAME_KEY].data();\n            changeAutoplay.w = waitFor(function () {\n                return frameData.state || _activeIndex !== activeIndex;\n            }, function () {\n                changeAutoplay.t = setTimeout(function () {\n\n                    if (pausedAutoplayFLAG || _activeIndex !== activeIndex) return;\n\n                    var _nextAutoplayIndex = nextAutoplayIndex,\n                        nextFrameData = data[_nextAutoplayIndex][STAGE_FRAME_KEY].data();\n\n                    changeAutoplay.w = waitFor(function () {\n\n                        return nextFrameData.state || _nextAutoplayIndex !== nextAutoplayIndex;\n                    }, function () {\n                        if (pausedAutoplayFLAG || _nextAutoplayIndex !== nextAutoplayIndex) return;\n                        that.show(o_loop ? getDirectionSign(!o_rtl) : nextAutoplayIndex);\n                    });\n                }, opts.autoplay);\n            });\n\n        }\n\n        that.startAutoplay = function (interval) {\n            if (that.autoplay) return this;\n            pausedAutoplayFLAG = stoppedAutoplayFLAG = false;\n            setAutoplayInterval(interval || opts.autoplay);\n            changeAutoplay();\n\n            return this;\n        };\n\n        that.stopAutoplay = function () {\n            if (that.autoplay) {\n                pausedAutoplayFLAG = stoppedAutoplayFLAG = true;\n                changeAutoplay();\n            }\n            return this;\n        };\n\n        that.showSlide = function (slideDir) {\n            var currentPosition = readPosition($navShaft, opts.navdir),\n                pos,\n                time = 500 * 1.1,\n                size = opts.navdir === 'horizontal' ? opts.thumbwidth : opts.thumbheight,\n                onEnd = function () {\n                    thumbArrUpdate();\n                };\n            if (slideDir === 'next') {\n                pos = currentPosition - (size + opts.margin) * thumbsPerSlide;\n            }\n            if (slideDir === 'prev') {\n                pos = currentPosition + (size + opts.margin) * thumbsPerSlide;\n            }\n            pos = validateRestrictions(pos, navShaftTouchTail);\n            thumbsDraw(pos, true);\n            slide($navShaft, {\n                time: time,\n                pos: pos,\n                direction: opts.navdir,\n                onEnd: onEnd\n            });\n        };\n\n        that.showWhileLongPress = function (options) {\n            if (that.longPress.singlePressInProgress) {\n                return;\n            }\n\n            var index = calcActiveIndex(options);\n            calcGlobalIndexes(index);\n            var time = calcTime(options) / 50;\n            var _activeFrame = activeFrame;\n            that.activeFrame = activeFrame = data[activeIndex];\n            var silent = _activeFrame === activeFrame && !options.user;\n\n            that.showNav(silent, options, time);\n\n            return this;\n        };\n\n        that.showEndLongPress = function (options) {\n            if (that.longPress.singlePressInProgress) {\n                return;\n            }\n\n            var index = calcActiveIndex(options);\n            calcGlobalIndexes(index);\n            var time = calcTime(options) / 50;\n            var _activeFrame = activeFrame;\n            that.activeFrame = activeFrame = data[activeIndex];\n\n            var silent = _activeFrame === activeFrame && !options.user;\n\n            that.showStage(silent, options, time);\n\n            showedFLAG = typeof lastActiveIndex !== 'undefined' && lastActiveIndex !== activeIndex;\n            lastActiveIndex = activeIndex;\n            return this;\n        };\n\n        function calcActiveIndex (options) {\n            var index;\n\n            if (typeof options !== 'object') {\n                index = options;\n                options = {};\n            } else {\n                index = options.index;\n            }\n\n            index = index === '>' ? dirtyIndex + 1 : index === '<' ? dirtyIndex - 1 : index === '<<' ? 0 : index === '>>' ? size - 1 : index;\n            index = isNaN(index) ? undefined : index;\n            index = typeof index === 'undefined' ? activeIndex || 0 : index;\n\n            return index;\n        }\n\n        function calcGlobalIndexes (index) {\n            that.activeIndex = activeIndex = edgeIndex(index);\n            prevIndex = getPrevIndex(activeIndex);\n            nextIndex = getNextIndex(activeIndex);\n            nextAutoplayIndex = normalizeIndex(activeIndex + (o_rtl ? -1 : 1));\n            activeIndexes = [activeIndex, prevIndex, nextIndex];\n\n            dirtyIndex = o_loop ? index : activeIndex;\n        }\n\n        function calcTime (options) {\n            var diffIndex = Math.abs(lastActiveIndex - dirtyIndex),\n                time = getNumber(options.time, function () {\n                    return Math.min(o_transitionDuration * (1 + (diffIndex - 1) / 12), o_transitionDuration * 2);\n                });\n\n            if (options.slow) {\n                time *= 10;\n            }\n\n            return time;\n        }\n\n        that.showStage = function (silent, options, time, e) {\n            if (e !== undefined && e.target.tagName == 'IFRAME') {\n                return;\n            }\n            unloadVideo($videoPlaying, activeFrame.i !== data[normalizeIndex(repositionIndex)].i);\n            frameDraw(activeIndexes, 'stage');\n            stageFramePosition(SLOW ? [dirtyIndex] : [dirtyIndex, getPrevIndex(dirtyIndex), getNextIndex(dirtyIndex)]);\n            updateTouchTails('go', true);\n\n            silent || triggerEvent('show', {\n                user: options.user,\n                time: time\n            });\n\n            pausedAutoplayFLAG = true;\n\n            var overPos = options.overPos;\n            var onEnd = that.showStage.onEnd = function (skipReposition) {\n                if (onEnd.ok) return;\n                onEnd.ok = true;\n\n                skipReposition || stageShaftReposition(true);\n\n                if (!silent) {\n                    triggerEvent('showend', {\n                        user: options.user\n                    });\n                }\n\n                if (!skipReposition && o_transition && o_transition !== opts.transition) {\n                    that.setOptions({transition: o_transition});\n                    o_transition = false;\n                    return;\n                }\n\n                updateFotoramaState();\n                loadImg(activeIndexes, 'stage');\n\n                updateTouchTails('go', false);\n                stageWheelUpdate();\n\n                stageCursor();\n                releaseAutoplay();\n                changeAutoplay();\n\n                if (that.fullScreen) {\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgFullClass).attr('aria-hidden', false);\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgClass).attr('aria-hidden', true)\n                } else {\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgFullClass).attr('aria-hidden', true);\n                    activeFrame[STAGE_FRAME_KEY].find('.' + imgClass).attr('aria-hidden', false)\n                }\n            };\n\n            if (!o_fade) {\n                slide($stageShaft, {\n                    pos: -getPosByIndex(dirtyIndex, measures.w, opts.margin, repositionIndex),\n                    overPos: overPos,\n                    time: time,\n                    onEnd: onEnd\n                });\n            } else {\n                var $activeFrame = activeFrame[STAGE_FRAME_KEY],\n                    $prevActiveFrame = data[lastActiveIndex] && activeIndex !== lastActiveIndex ? data[lastActiveIndex][STAGE_FRAME_KEY] : null;\n\n                fade($activeFrame, $prevActiveFrame, $stageFrame, {\n                    time: time,\n                    method: opts.transition,\n                    onEnd: onEnd\n                }, fadeStack);\n            }\n\n            arrsUpdate();\n        };\n\n        that.showNav = function(silent, options, time){\n            thumbArrUpdate();\n            if (o_nav) {\n                navUpdate();\n\n                var guessIndex = limitIndex(activeIndex + minMaxLimit(dirtyIndex - lastActiveIndex, -1, 1));\n                slideNavShaft({\n                    time: time,\n                    coo: guessIndex !== activeIndex && options.coo,\n                    guessIndex: typeof options.coo !== 'undefined' ? guessIndex : activeIndex,\n                    keep: silent\n                });\n                if (o_navThumbs) slideThumbBorder(time);\n            }\n        };\n\n        that.show = function (options, e) {\n            that.longPress.singlePressInProgress = true;\n\n            var index = calcActiveIndex(options);\n            calcGlobalIndexes(index);\n            var time = calcTime(options);\n            var _activeFrame = activeFrame;\n            that.activeFrame = activeFrame = data[activeIndex];\n\n            var silent = _activeFrame === activeFrame && !options.user;\n\n            that.showStage(silent, options, time, e);\n            that.showNav(silent, options, time);\n\n            showedFLAG = typeof lastActiveIndex !== 'undefined' && lastActiveIndex !== activeIndex;\n            lastActiveIndex = activeIndex;\n            that.longPress.singlePressInProgress = false;\n\n            return this;\n        };\n\n        that.requestFullScreen = function () {\n            if (o_allowFullScreen && !that.fullScreen) {\n\n                //check that this is not video\n                if(isVideo()) {\n                    return;\n                }\n\n                scrollTop = $WINDOW.scrollTop();\n                scrollLeft = $WINDOW.scrollLeft();\n\n                lockScroll($WINDOW);\n\n                updateTouchTails('x', true);\n\n                measuresStash = $.extend({}, measures);\n\n                $fotorama\n                    .addClass(fullscreenClass)\n                    .appendTo($BODY.addClass(_fullscreenClass));\n\n                $HTML.addClass(_fullscreenClass);\n\n                unloadVideo($videoPlaying, true, true);\n\n                that.fullScreen = true;\n\n                if (o_nativeFullScreen) {\n                    fullScreenApi.request(fotorama);\n                }\n\n                loadImg(activeIndexes, 'stage');\n                updateFotoramaState();\n                triggerEvent('fullscreenenter');\n                that.resize();\n\n                if (!('ontouchstart' in window)) {\n                    $fullscreenIcon.focus();\n                }\n            }\n\n            return this;\n        };\n\n        function cancelFullScreen() {\n            if (that.fullScreen) {\n                that.fullScreen = false;\n\n                if (FULLSCREEN) {\n                    fullScreenApi.cancel(fotorama);\n                }\n\n                $BODY.removeClass(_fullscreenClass);\n                $HTML.removeClass(_fullscreenClass);\n\n                $fotorama\n                    .removeClass(fullscreenClass)\n                    .insertAfter($anchor);\n\n                measures = $.extend({}, measuresStash);\n\n                unloadVideo($videoPlaying, true, true);\n\n                updateTouchTails('x', false);\n\n                that.resize();\n                loadImg(activeIndexes, 'stage');\n\n                lockScroll($WINDOW, scrollLeft, scrollTop);\n\n                triggerEvent('fullscreenexit');\n            }\n        }\n\n        that.cancelFullScreen = function () {\n            if (o_nativeFullScreen && fullScreenApi.is()) {\n                fullScreenApi.cancel(document);\n            } else {\n                cancelFullScreen();\n            }\n\n            return this;\n        };\n\n        that.toggleFullScreen = function () {\n            return that[(that.fullScreen ? 'cancel' : 'request') + 'FullScreen']();\n        };\n\n        that.resize = function (options) {\n            if (!data) return this;\n\n            var time = arguments[1] || 0,\n                setFLAG = arguments[2];\n\n            thumbsPerSlide = getThumbsInSlide($wrap, opts);\n            extendMeasures(!that.fullScreen ? optionsToLowerCase(options) : {\n                width: $(window).width(),\n                maxwidth: null,\n                minwidth: null,\n                height: $(window).height(),\n                maxheight: null,\n                minheight: null\n            }, [measures, setFLAG || that.fullScreen || opts]);\n\n            var width = measures.width,\n                height = measures.height,\n                ratio = measures.ratio,\n                windowHeight = $WINDOW.height() - (o_nav ? $nav.height() : 0);\n\n            if (measureIsValid(width)) {\n                $wrap.css({width: ''});\n                $stage.css({width: ''});\n                $stageShaft.css({width: ''});\n                $nav.css({width: ''});\n                $wrap.css({minWidth: measures.minwidth || 0, maxWidth: measures.maxwidth || MAX_WIDTH});\n\n                if (o_nav === 'dots') {\n                    $navWrap.hide();\n                }\n                width = measures.W = measures.w = $wrap.width();\n                measures.nw = o_nav && numberFromWhatever(opts.navwidth, width) || width;\n\n                $stageShaft.css({width: measures.w, marginLeft: (measures.W - measures.w) / 2});\n\n                height = numberFromWhatever(height, windowHeight);\n\n                height = height || (ratio && width / ratio);\n\n                if (height) {\n                    width = Math.round(width);\n                    height = measures.h = Math.round(minMaxLimit(height, numberFromWhatever(measures.minheight, windowHeight), numberFromWhatever(measures.maxheight, windowHeight)));\n                    $stage.css({'width': width, 'height': height});\n\n                    if (opts.navdir === 'vertical' && !that.fullscreen) {\n                        $nav.width(opts.thumbwidth + opts.thumbmargin * 2);\n                    }\n\n                    if (opts.navdir === 'horizontal' && !that.fullscreen) {\n                        $nav.height(opts.thumbheight + opts.thumbmargin * 2);\n                    }\n\n                    if (o_nav === 'dots') {\n                        $nav.width(width)\n                            .height('auto');\n                        $navWrap.show();\n                    }\n\n                    if (opts.navdir === 'vertical' && that.fullScreen) {\n                        $stage.css('height', $WINDOW.height());\n                    }\n\n                    if (opts.navdir === 'horizontal' && that.fullScreen) {\n                        $stage.css('height', $WINDOW.height() - $nav.height());\n                    }\n\n                    if (o_nav) {\n                        switch (opts.navdir) {\n                            case 'vertical':\n                                $navWrap.removeClass(navShafthorizontalClass);\n                                $navWrap.removeClass(navShaftListClass);\n                                $navWrap.addClass(navShaftVerticalClass);\n                                $nav\n                                    .stop()\n                                    .animate({height: measures.h, width: opts.thumbwidth}, time);\n                                break;\n                            case 'list':\n                                $navWrap.removeClass(navShaftVerticalClass);\n                                $navWrap.removeClass(navShafthorizontalClass);\n                                $navWrap.addClass(navShaftListClass);\n                                break;\n                            default:\n                                $navWrap.removeClass(navShaftVerticalClass);\n                                $navWrap.removeClass(navShaftListClass);\n                                $navWrap.addClass(navShafthorizontalClass);\n                                $nav\n                                    .stop()\n                                    .animate({width: measures.nw}, time);\n                                break;\n                        }\n\n                        stageShaftReposition();\n                        slideNavShaft({guessIndex: activeIndex, time: time, keep: true});\n                        if (o_navThumbs && frameAppend.nav) slideThumbBorder(time);\n                    }\n\n                    measuresSetFLAG = setFLAG || true;\n\n                    ready.ok = true;\n                    ready();\n                }\n            }\n\n            stageLeft = $stage.offset().left;\n            setStagePosition();\n\n            return this;\n        };\n\n        that.setOptions = function (options) {\n            $.extend(opts, options);\n            reset();\n            return this;\n        };\n\n        that.shuffle = function () {\n            data && shuffle(data) && reset();\n            return this;\n        };\n\n        function setShadow($el, edge) {\n            if (o_shadows) {\n                $el.removeClass(shadowsLeftClass + ' ' + shadowsRightClass);\n                $el.removeClass(shadowsTopClass + ' ' + shadowsBottomClass);\n                edge && !$videoPlaying && $el.addClass(edge.replace(/^|\\s/g, ' ' + shadowsClass + '--'));\n            }\n        }\n\n        that.longPress = {\n            threshold: 1,\n            count: 0,\n            thumbSlideTime: 20,\n            progress: function(){\n                if (!this.inProgress) {\n                    this.count++;\n                    this.inProgress = this.count > this.threshold;\n                }\n            },\n            end: function(){\n                if(this.inProgress) {\n                    this.isEnded = true\n                }\n            },\n            reset: function(){\n                this.count = 0;\n                this.inProgress = false;\n                this.isEnded = false;\n            }\n        };\n\n        that.destroy = function () {\n            that.cancelFullScreen();\n            that.stopAutoplay();\n\n            data = that.data = null;\n\n            appendElements();\n\n            activeIndexes = [];\n            detachFrames(STAGE_FRAME_KEY);\n\n            reset.ok = false;\n\n            return this;\n        };\n\n        /**\n         *\n         * @returns {jQuery.Fotorama}\n         */\n        that.playVideo = function () {\n            var dataFrame = activeFrame,\n                video = dataFrame.video,\n                _activeIndex = activeIndex;\n\n            if (typeof video === 'object' && dataFrame.videoReady) {\n                o_nativeFullScreen && that.fullScreen && that.cancelFullScreen();\n\n                waitFor(function () {\n                    return !fullScreenApi.is() || _activeIndex !== activeIndex;\n                }, function () {\n                    if (_activeIndex === activeIndex) {\n                        dataFrame.$video = dataFrame.$video || $(div(videoClass)).append(createVideoFrame(video));\n                        dataFrame.$video.appendTo(dataFrame[STAGE_FRAME_KEY]);\n\n                        $wrap.addClass(wrapVideoClass);\n                        $videoPlaying = dataFrame.$video;\n\n                        stageNoMove();\n\n                        $arrs.blur();\n                        $fullscreenIcon.blur();\n\n                        triggerEvent('loadvideo');\n                    }\n                });\n            }\n\n            return this;\n        };\n\n        that.stopVideo = function () {\n            unloadVideo($videoPlaying, true, true);\n            return this;\n        };\n\n        that.spliceByIndex = function (index, newImgObj) {\n            newImgObj.i = index + 1;\n            newImgObj.img && $.ajax({\n                url: newImgObj.img,\n                type: 'HEAD',\n                success: function () {\n                    data.splice(index, 1, newImgObj);\n                    reset();\n                }\n            });\n        };\n\n        function unloadVideo($video, unloadActiveFLAG, releaseAutoplayFLAG) {\n            if (unloadActiveFLAG) {\n                $wrap.removeClass(wrapVideoClass);\n                $videoPlaying = false;\n\n                stageNoMove();\n            }\n\n            if ($video && $video !== $videoPlaying) {\n                $video.remove();\n                triggerEvent('unloadvideo');\n            }\n\n            if (releaseAutoplayFLAG) {\n                releaseAutoplay();\n                changeAutoplay();\n            }\n        }\n\n        function toggleControlsClass(FLAG) {\n            $wrap.toggleClass(wrapNoControlsClass, FLAG);\n        }\n\n        function stageCursor(e) {\n            if (stageShaftTouchTail.flow) return;\n\n            var x = e ? e.pageX : stageCursor.x,\n                pointerFLAG = x && !disableDirrection(getDirection(x)) && opts.click;\n\n            if (stageCursor.p !== pointerFLAG\n                && $stage.toggleClass(pointerClass, pointerFLAG)) {\n                stageCursor.p = pointerFLAG;\n                stageCursor.x = x;\n            }\n        }\n\n        $stage.on('mousemove', stageCursor);\n\n        function clickToShow(showOptions, e) {\n            clearTimeout(clickToShow.t);\n\n            if (opts.clicktransition && opts.clicktransition !== opts.transition) {\n                setTimeout(function () {\n                    var _o_transition = opts.transition;\n\n                    that.setOptions({transition: opts.clicktransition});\n\n                    // now safe to pass base transition to o_transition, so that.show will restor it\n                    o_transition = _o_transition;\n                    // this timeout is here to prevent jerking in some browsers\n                    clickToShow.t = setTimeout(function () {\n                        that.show(showOptions);\n                    }, 10);\n                }, 0);\n            } else {\n                that.show(showOptions, e);\n            }\n        }\n\n        function onStageTap(e, toggleControlsFLAG) {\n            var target = e.target,\n                $target = $(target);\n            if ($target.hasClass(videoPlayClass)) {\n                that.playVideo();\n            } else if (target === fullscreenIcon) {\n                that.toggleFullScreen();\n            } else if ($videoPlaying) {\n                target === videoClose && unloadVideo($videoPlaying, true, true);\n            } else if (!$fotorama.hasClass(fullscreenClass)) {\n                that.requestFullScreen();\n            }\n        }\n\n        function updateTouchTails(key, value) {\n            stageShaftTouchTail[key] = navShaftTouchTail[key] = value;\n        }\n\n        stageShaftTouchTail = moveOnTouch($stageShaft, {\n            onStart: onTouchStart,\n            onMove: function (e, result) {\n                setShadow($stage, result.edge);\n            },\n            onTouchEnd: onTouchEnd,\n            onEnd: function (result) {\n                var toggleControlsFLAG;\n\n                setShadow($stage);\n                toggleControlsFLAG = (MS_POINTER && !hoverFLAG || result.touch) &&\n                    opts.arrows;\n\n                if ((result.moved || (toggleControlsFLAG && result.pos !== result.newPos && !result.control)) && result.$target[0] !== $fullscreenIcon[0]) {\n                    var index = getIndexByPos(result.newPos, measures.w, opts.margin, repositionIndex);\n\n                    that.show({\n                        index: index,\n                        time: o_fade ? o_transitionDuration : result.time,\n                        overPos: result.overPos,\n                        user: true\n                    });\n                } else if (!result.aborted && !result.control) {\n                    onStageTap(result.startEvent, toggleControlsFLAG);\n                }\n            },\n            timeLow: 1,\n            timeHigh: 1,\n            friction: 2,\n            select: '.' + selectClass + ', .' + selectClass + ' *',\n            $wrap: $stage,\n            direction: 'horizontal'\n\n        });\n\n        navShaftTouchTail = moveOnTouch($navShaft, {\n            onStart: onTouchStart,\n            onMove: function (e, result) {\n                setShadow($nav, result.edge);\n            },\n            onTouchEnd: onTouchEnd,\n            onEnd: function (result) {\n\n                function onEnd() {\n                    slideNavShaft.l = result.newPos;\n                    releaseAutoplay();\n                    changeAutoplay();\n                    thumbsDraw(result.newPos, true);\n                    thumbArrUpdate();\n                }\n\n                if (!result.moved) {\n                    var target = result.$target.closest('.' + navFrameClass, $navShaft)[0];\n                    target && onNavFrameClick.call(target, result.startEvent);\n                } else if (result.pos !== result.newPos) {\n                    pausedAutoplayFLAG = true;\n                    slide($navShaft, {\n                        time: result.time,\n                        pos: result.newPos,\n                        overPos: result.overPos,\n                        direction: opts.navdir,\n                        onEnd: onEnd\n                    });\n                    thumbsDraw(result.newPos);\n                    o_shadows && setShadow($nav, findShadowEdge(result.newPos, navShaftTouchTail.min, navShaftTouchTail.max, result.dir));\n                } else {\n                    onEnd();\n                }\n            },\n            timeLow: .5,\n            timeHigh: 2,\n            friction: 5,\n            $wrap: $nav,\n            direction: opts.navdir\n        });\n\n        stageWheelTail = wheel($stage, {\n            shift: true,\n            onEnd: function (e, direction) {\n                onTouchStart();\n                onTouchEnd();\n                that.show({index: direction, slow: e.altKey})\n            }\n        });\n\n        navWheelTail = wheel($nav, {\n            onEnd: function (e, direction) {\n                onTouchStart();\n                onTouchEnd();\n                var newPos = stop($navShaft) + direction * .25;\n                $navShaft.css(getTranslate(minMaxLimit(newPos, navShaftTouchTail.min, navShaftTouchTail.max), opts.navdir));\n                o_shadows && setShadow($nav, findShadowEdge(newPos, navShaftTouchTail.min, navShaftTouchTail.max, opts.navdir));\n                navWheelTail.prevent = {'<': newPos >= navShaftTouchTail.max, '>': newPos <= navShaftTouchTail.min};\n                clearTimeout(navWheelTail.t);\n                navWheelTail.t = setTimeout(function () {\n                    slideNavShaft.l = newPos;\n                    thumbsDraw(newPos, true)\n                }, TOUCH_TIMEOUT);\n                thumbsDraw(newPos);\n            }\n        });\n\n        $wrap.hover(\n            function () {\n                setTimeout(function () {\n                    if (touchedFLAG) return;\n                    toggleControlsClass(!(hoverFLAG = true));\n                }, 0);\n            },\n            function () {\n                if (!hoverFLAG) return;\n                toggleControlsClass(!(hoverFLAG = false));\n            }\n        );\n\n        function onNavFrameClick(e) {\n            var index = $(this).data().eq;\n\n            if (opts.navtype === 'thumbs') {\n                clickToShow({index: index, slow: e.altKey, user: true, coo: e._x - $nav.offset().left});\n            } else {\n                clickToShow({index: index, slow: e.altKey, user: true});\n            }\n        }\n\n        function onArrClick(e) {\n            clickToShow({index: $arrs.index(this) ? '>' : '<', slow: e.altKey, user: true});\n        }\n\n        smartClick($arrs, function (e) {\n            stopEvent(e);\n            onArrClick.call(this, e);\n        }, {\n            onStart: function () {\n                onTouchStart();\n                stageShaftTouchTail.control = true;\n            },\n            onTouchEnd: onTouchEnd\n        });\n\n        smartClick($thumbArrLeft, function (e) {\n            stopEvent(e);\n            if (opts.navtype === 'thumbs') {\n\n                that.show('<');\n            } else {\n                that.showSlide('prev')\n            }\n        });\n\n        smartClick($thumbArrRight, function (e) {\n            stopEvent(e);\n            if (opts.navtype === 'thumbs') {\n                that.show('>');\n            } else {\n                that.showSlide('next')\n            }\n\n        });\n\n\n        function addFocusOnControls(el) {\n            addFocus(el, function () {\n                setTimeout(function () {\n                    lockScroll($stage);\n                }, 0);\n                toggleControlsClass(false);\n            });\n        }\n\n        $arrs.each(function () {\n            addEnterUp(this, function (e) {\n                onArrClick.call(this, e);\n            });\n            addFocusOnControls(this);\n        });\n\n        addEnterUp(fullscreenIcon, function () {\n            if ($fotorama.hasClass(fullscreenClass)) {\n                that.cancelFullScreen();\n                $stageShaft.focus();\n            } else {\n                that.requestFullScreen();\n                $fullscreenIcon.focus();\n            }\n\n        });\n        addFocusOnControls(fullscreenIcon);\n\n        function reset() {\n            setData();\n            setOptions();\n\n            if (!reset.i) {\n                reset.i = true;\n                // Only once\n                var _startindex = opts.startindex;\n                activeIndex = repositionIndex = dirtyIndex = lastActiveIndex = startIndex = edgeIndex(_startindex) || 0;\n                /*(o_rtl ? size - 1 : 0)*///;\n            }\n\n            if (size) {\n                if (changeToRtl()) return;\n\n                if ($videoPlaying) {\n                    unloadVideo($videoPlaying, true);\n                }\n\n                activeIndexes = [];\n\n                if (!isVideo()) {\n                    detachFrames(STAGE_FRAME_KEY);\n                }\n\n                reset.ok = true;\n\n                that.show({index: activeIndex, time: 0});\n                that.resize();\n            } else {\n                that.destroy();\n            }\n        }\n\n        function changeToRtl() {\n\n            if (!changeToRtl.f === o_rtl) {\n                changeToRtl.f = o_rtl;\n                activeIndex = size - 1 - activeIndex;\n                that.reverse();\n\n                return true;\n            }\n        }\n\n        $.each('load push pop shift unshift reverse sort splice'.split(' '), function (i, method) {\n            that[method] = function () {\n                data = data || [];\n                if (method !== 'load') {\n                    Array.prototype[method].apply(data, arguments);\n                } else if (arguments[0] && typeof arguments[0] === 'object' && arguments[0].length) {\n                    data = clone(arguments[0]);\n                }\n                reset();\n                return that;\n            }\n        });\n\n        function ready() {\n            if (ready.ok) {\n                ready.ok = false;\n                triggerEvent('ready');\n            }\n        }\n\n        reset();\n    };\n    $.fn.fotorama = function (opts) {\n        return this.each(function () {\n            var that = this,\n                $fotorama = $(this),\n                fotoramaData = $fotorama.data(),\n                fotorama = fotoramaData.fotorama;\n\n            if (!fotorama) {\n                waitFor(function () {\n                    return !isHidden(that);\n                }, function () {\n                    fotoramaData.urtext = $fotorama.html();\n                    new $.Fotorama($fotorama,\n                        $.extend(\n                            {},\n                            OPTIONS,\n                            window.fotoramaDefaults,\n                            opts,\n                            fotoramaData\n                        )\n                    );\n                });\n            } else {\n                fotorama.setOptions(opts, true);\n            }\n        });\n    };\n    $.Fotorama.instances = [];\n\n    function calculateIndexes() {\n        $.each($.Fotorama.instances, function (index, instance) {\n            instance.index = index;\n        });\n    }\n\n    function addInstance(instance) {\n        $.Fotorama.instances.push(instance);\n        calculateIndexes();\n    }\n\n    function hideInstance(instance) {\n        $.Fotorama.instances.splice(instance.index, 1);\n        calculateIndexes();\n    }\n\n    $.Fotorama.cache = {};\n    $.Fotorama.measures = {};\n    $ = $ || {};\n    $.Fotorama = $.Fotorama || {};\n    $.Fotorama.jst = $.Fotorama.jst || {};\n\n    $.Fotorama.jst.dots = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '<div class=\"fotorama__nav__frame fotorama__nav__frame--dot\" tabindex=\"0\" role=\"button\" data-gallery-role=\"nav-frame\" data-nav-type=\"thumb\" aria-label>\\r\\n    <div class=\"fotorama__dot\"></div>\\r\\n</div>';\n        return __p\n    };\n\n    $.Fotorama.jst.frameCaption = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '<div class=\"fotorama__caption\" aria-hidden=\"true\">\\r\\n    <div class=\"fotorama__caption__wrap\" id=\"' +\n            ((__t = ( v.labelledby )) == null ? '' : __t) +\n            '\">' +\n            ((__t = ( v.caption )) == null ? '' : __t) +\n            '</div>\\r\\n</div>\\r\\n';\n        return __p\n    };\n\n    $.Fotorama.jst.style = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '.fotorama' +\n            ((__t = ( v.s )) == null ? '' : __t) +\n            ' .fotorama__nav--thumbs .fotorama__nav__frame{\\r\\npadding:' +\n            ((__t = ( v.m )) == null ? '' : __t) +\n            'px;\\r\\nheight:' +\n            ((__t = ( v.h )) == null ? '' : __t) +\n            'px}\\r\\n.fotorama' +\n            ((__t = ( v.s )) == null ? '' : __t) +\n            ' .fotorama__thumb-border{\\r\\nheight:' +\n            ((__t = ( v.h )) == null ? '' : __t) +\n            'px;\\r\\nborder-width:' +\n            ((__t = ( v.b )) == null ? '' : __t) +\n            'px;\\r\\nmargin-top:' +\n            ((__t = ( v.m )) == null ? '' : __t) +\n            'px}';\n        return __p\n    };\n\n    $.Fotorama.jst.thumb = function (v) {\n        var __t, __p = '', __e = _.escape;\n        __p += '<div class=\"fotorama__nav__frame fotorama__nav__frame--thumb\" tabindex=\"0\" role=\"button\" data-gallery-role=\"nav-frame\" data-nav-type=\"thumb\" aria-label>\\r\\n    <div class=\"fotorama__thumb\">\\r\\n    </div>\\r\\n</div>';\n        return __p\n    };\n})(window, document, location, typeof jQuery !== 'undefined' && jQuery);\n","Magento_Persistent/js/view/customer-data-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/utils/wrapper'\n], function ($, wrapper) {\n    'use strict';\n\n    var mixin = {\n\n        /**\n         * Check if persistent section is expired due to lifetime.\n         *\n         * @param {Function} originFn - Original method.\n         * @return {Array}\n         */\n        getExpiredSectionNames: function (originFn) {\n            var expiredSections = originFn(),\n                storage = $.initNamespaceStorage('mage-cache-storage').localStorage,\n                currentTimestamp = Math.floor(Date.now() / 1000),\n                persistentIndex = expiredSections.indexOf('persistent'),\n                persistentLifeTime = 0,\n                sectionData;\n\n            if (window.persistent !== undefined && window.persistent.expirationLifetime !== undefined) {\n                persistentLifeTime = window.persistent.expirationLifetime;\n            }\n\n            if (persistentIndex !== -1) {\n                sectionData = storage.get('persistent');\n\n                if (typeof sectionData === 'object' &&\n                    sectionData['data_id'] + persistentLifeTime >= currentTimestamp\n                ) {\n                    expiredSections.splice(persistentIndex, 1);\n                }\n            }\n\n            return expiredSections;\n        },\n\n        /**\n         * @param {Object} settings\n         * @constructor\n         */\n        'Magento_Customer/js/customer-data': function (originFn) {\n            let mageCacheTimeout = new Date($.localStorage.get('mage-cache-timeout')),\n                mageCacheSessId = $.cookieStorage.isSet('mage-cache-sessid');\n\n            originFn();\n            if (window.persistent !== undefined && (mageCacheTimeout < new Date() || !mageCacheSessId)) {\n                this.reload(['persistent','cart'],true);\n            }\n        }\n    };\n\n    /**\n     * Override default customer-data.getExpiredSectionNames().\n     */\n    return function (target) {\n        return wrapper.extend(target, mixin);\n    };\n});\n","Magento_Persistent/js/view/additional-welcome.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Customer/js/customer-data'\n], function ($, $t, customerData) {\n    'use strict';\n\n    return {\n        /**\n         * Init.\n         */\n        init: function () {\n            var persistent = customerData.get('persistent');\n\n            if (persistent().fullname === undefined) {\n                customerData.get('persistent').subscribe(this.replacePersistentWelcome);\n            } else {\n                this.replacePersistentWelcome();\n            }\n        },\n\n        /**\n         * Replace welcome message for customer with persistent cookie.\n         */\n        replacePersistentWelcome: function () {\n            var persistent = customerData.get('persistent'),\n                welcomeElems;\n\n            if (persistent().fullname !== undefined) {\n                welcomeElems = $('li.greet.welcome > span.not-logged-in');\n\n                if (welcomeElems.length) {\n                    $(welcomeElems).each(function () {\n                        var html = $t('Welcome, %1!').replace('%1', persistent().fullname);\n\n                        $(this).attr('data-bind', html);\n                        $(this).html(html);\n                    });\n                    $(welcomeElems).append(' <span><a ' + window.notYouLink + '>' + $t('Not you?') + '</a>');\n                }\n            }\n        },\n\n        /**\n         * @constructor\n         */\n        'Magento_Persistent/js/view/additional-welcome': function () {\n            this.init();\n        }\n    };\n});\n","Magento_Sales/js/orders-returns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.ordersReturns', {\n        options: {\n            zipCode: '#oar-zip', // Search by zip code.\n            emailAddress: '#oar-email', // Search by email address.\n            searchType: '#quick-search-type-id' // Search element used for choosing between the two.\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            $(this.options.searchType).on('change', $.proxy(this._showIdentifyBlock, this)).trigger('change');\n        },\n\n        /**\n         * Show either the search by zip code option or the search by email address option.\n         * @private\n         * @param {jQuery.Event} e - Change event. Event target value is either 'zip' or 'email'.\n         */\n        _showIdentifyBlock: function (e) {\n            var value = $(e.target).val();\n\n            $(this.options.zipCode).toggle(value === 'zip');\n            $(this.options.emailAddress).toggle(value === 'email');\n        }\n    });\n\n    return $.mage.ordersReturns;\n});\n","Magento_Sales/js/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.giftMessage', {\n        options: {\n            rowPrefix: '#order-item-row-', // Selector prefix for item's row in the table.\n            linkPrefix: '#order-item-gift-message-link-', // Selector prefix for the 'Gift Message' link.\n            duration: 100, // Toggle duration.\n            expandedClass: 'expanded', // Class added/removed to/from the 'Gift Message' link.\n            expandedContentClass: 'expanded-content', // Class added/removed to/from the 'Gift Message' content.\n            lastClass: 'last' // Class added/removed to/from the last item's row in the products table.\n        },\n\n        /**\n         * Bind a click handler on the widget's element to toggle the gift message.\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._toggleGiftMessage, this));\n        },\n\n        /**\n         * Toggle the display of the item's corresponding gift message.\n         * @private\n         * @param {jQuery.Event} event - Click event.\n         */\n        _toggleGiftMessage: function (event) {\n            var element = $(event.target), // Click target. The 'Gift Message' link or 'Close' button.\n                options = this.options, // Cached widget options.\n                itemId = element.data('item-id'), // The individual item's numeric id.\n                link = $(options.linkPrefix + itemId), // The 'Gift Message' expandable link.\n                row = $(options.rowPrefix + itemId), // The item's row in the products table.\n                region = $('#' + element.attr('aria-controls')); // The gift message container region.\n\n            region.toggleClass(options.expandedContentClass, options.duration, function () {\n                if (region.attr('aria-expanded') === 'true') {\n                    region.attr('aria-expanded', 'false');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.addClass(options.lastClass);\n                    }\n                } else {\n                    region.attr('aria-expanded', 'true');\n\n                    if (region.hasClass(options.lastClass)) {\n                        row.removeClass(options.lastClass);\n                    }\n                }\n                link.toggleClass(options.expandedClass);\n            });\n            event.preventDefault(); // Prevent event propagation and avoid going to the link's href.\n        }\n    });\n\n    return $.mage.giftMessage;\n});\n","Magento_Sales/js/view/last-ordered-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'underscore'\n], function (Component, customerData, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isShowAddToCart: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.lastOrderedItems = customerData.get('last-ordered-items');\n            this.lastOrderedItems.subscribe(this.checkSalableItems.bind(this));\n            this.checkSalableItems();\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('isShowAddToCart');\n\n            return this;\n        },\n\n        /**\n         * Check if items is_saleable and change add to cart button visibility.\n         */\n        checkSalableItems: function () {\n            var isShowAddToCart = _.some(this.lastOrderedItems().items, {\n                'is_saleable': true\n            });\n\n            this.isShowAddToCart(isShowAddToCart);\n        }\n    });\n});\n","Magento_GiftMessage/js/gift-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.giftOptions', {\n        options: {\n            mageError: 'mage-error',\n            noDisplay: 'no-display',\n            requiredEntry: 'required-entry'\n        },\n\n        /**\n         * Initial toggle of the various gift options after widget instantiation.\n         * @private\n         */\n        _init: function () {\n            this._toggleVisibility();\n        },\n\n        /**\n         * Bind a click handler to the widget's context element.\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._toggleVisibility, this));\n            $(this.element.data('selector').id).find('.giftmessage-area')\n                .on('change', $.proxy(this._toggleRequired, this));\n        },\n\n        /**\n         * Toggle the visibility of the widget's context element's selector(s).\n         * @private\n         * @param {jQuery.Event} event - Click event. Target is a checkbox.\n         */\n        _toggleVisibility: function (event) {\n            var checkbox = event ? $(event.target) : this.element,\n                container = $(checkbox.data('selector').id),\n                _this;\n\n            if (checkbox.is(':checked')) {\n                container.show()\n                    .find('.giftmessage-area:not(:visible)').each(function (x, element) {\n                        if ($(element).val().length > 0) {\n                            $(element).trigger('change');\n                            container.find('a').trigger('click');\n                        }\n                    });\n            } else {\n                _this = this;\n                container.hide()\n                    .find('.input-text:not(.giftmessage-area)').each(function (x, element) {\n                        $(element).val(element.defaultValue).removeClass(_this.options.mageError)\n                            .next('div.' + _this.options.mageError).remove();\n                    }).end()\n                    .find('.giftmessage-area').val('').change().end()\n                    .find('.select').val('').change().end()\n                    .find('.checkbox:checked').prop('checked', false).trigger('click').prop('checked', false).end()\n                    .find('.price-box').addClass(this.options.noDisplay).end();\n            }\n        },\n\n        /**\n         * Make the From and To input fields required if a gift message has been written.\n         * @private\n         * @param {jQuery.Event} event - Change event. Target is a textarea.\n         */\n        _toggleRequired: function (event) {\n            var textArea = $(event.target),\n                length = textArea.val().length;\n\n            textArea.closest('li').prev('.fields')\n                .find('.input-text').toggleClass(this.options.requiredEntry, length > 0);\n        }\n    });\n\n    return $.mage.giftOptions;\n});\n","Magento_GiftMessage/js/action/gift-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_GiftMessage/js/model/url-builder',\n    'mage/storage',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Checkout/js/model/error-processor',\n    'mage/url',\n    'Magento_Checkout/js/model/quote',\n    'underscore'\n], function (urlBuilder, storage, messageList, errorProcessor, url, quote, _) {\n    'use strict';\n\n    return function (giftMessage, remove) {\n        var serviceUrl;\n\n        url.setBaseUrl(giftMessage.getConfigValue('baseUrl'));\n\n        if (giftMessage.getConfigValue('isCustomerLoggedIn')) {\n            serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message', {});\n\n            if (giftMessage.itemId != 'orderLevel') { //eslint-disable-line eqeqeq\n                serviceUrl = urlBuilder.createUrl('/carts/mine/gift-message/:itemId', {\n                    itemId: giftMessage.itemId\n                });\n            }\n        } else {\n            serviceUrl = urlBuilder.createUrl('/guest-carts/:cartId/gift-message', {\n                cartId: quote.getQuoteId()\n            });\n\n            if (giftMessage.itemId != 'orderLevel') { //eslint-disable-line eqeqeq\n                serviceUrl = urlBuilder.createUrl(\n                    '/guest-carts/:cartId/gift-message/:itemId',\n                    {\n                        cartId: quote.getQuoteId(), itemId: giftMessage.itemId\n                    }\n                );\n            }\n        }\n        messageList.clear();\n\n        storage.post(\n            serviceUrl,\n            JSON.stringify({\n                'gift_message': giftMessage.getSubmitParams(remove)\n            })\n        ).done(function () {\n            giftMessage.reset();\n            _.each(giftMessage.getAfterSubmitCallbacks(), function (callback) {\n                if (_.isFunction(callback)) {\n                    callback();\n                }\n            });\n        }).fail(function (response) {\n            errorProcessor.process(response);\n        });\n    };\n});\n","Magento_GiftMessage/js/model/url-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/model/url-builder'\n], function ($, urlBuilder) {\n    'use strict';\n\n    return $.extend(urlBuilder, {\n        storeCode: window.giftOptionsConfig.storeCode\n    });\n});\n","Magento_GiftMessage/js/model/gift-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'ko'\n], function (_, ko) {\n    'use strict';\n\n    return {\n        options: ko.observableArray([]),\n\n        /**\n         * @param {Object} option\n         */\n        addOption: function (option) {\n            if (!this.options().hasOwnProperty(option.itemId)) {\n                this.options.push({\n                        id: option.itemId, value: option\n                    }\n                );\n            }\n        },\n\n        /**\n         * @param {*} itemId\n         * @return {*}\n         */\n        getOptionByItemId: function (itemId) {\n            var option = null;\n\n            _.each(this.options(), function (data) {\n                if (data.id === itemId) {\n                    option = data.value;\n\n                    return false;\n                }\n            });\n\n            return option;\n        }\n    };\n});\n","Magento_GiftMessage/js/model/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'underscore',\n    'mage/url'\n], function (uiElement, _, url) {\n    'use strict';\n\n    var provider = uiElement();\n\n    return function (itemId) {\n        var model = {\n            id: 'message-' + itemId,\n            itemId: itemId,\n            observables: {},\n            additionalOptions: [],\n            submitParams: [\n                'recipient',\n                'sender',\n                'message'\n            ],\n\n            /**\n             * Initialize.\n             */\n            initialize: function () {\n                var message = false;\n\n                this.getObservable('alreadyAdded')(false);\n\n                if (this.itemId == 'orderLevel') { //eslint-disable-line eqeqeq\n                    message = window.giftOptionsConfig.giftMessage.hasOwnProperty(this.itemId) ?\n                        window.giftOptionsConfig.giftMessage[this.itemId] :\n                        null;\n                } else {\n                    message =\n                        window.giftOptionsConfig.giftMessage.hasOwnProperty('itemLevel') &&\n                        window.giftOptionsConfig.giftMessage.itemLevel.hasOwnProperty(this.itemId) ?\n                            window.giftOptionsConfig.giftMessage.itemLevel[this.itemId].message :\n                            null;\n                }\n\n                if (_.isObject(message)) {\n                    this.getObservable('recipient')(message.recipient);\n                    this.getObservable('sender')(message.sender);\n                    this.getObservable('message')(message.message);\n                    this.getObservable('alreadyAdded')(true);\n                }\n            },\n\n            /**\n             * @param {String} key\n             * @return {*}\n             */\n            getObservable: function (key) {\n                this.initObservable(this.id, key);\n\n                return provider[this.getUniqueKey(this.id, key)];\n            },\n\n            /**\n             * @param {String} node\n             * @param {String} key\n             */\n            initObservable: function (node, key) {\n                if (node && !this.observables.hasOwnProperty(node)) {\n                    this.observables[node] = [];\n                }\n\n                if (key && this.observables[node].indexOf(key) === -1) {\n                    this.observables[node].push(key);\n                    provider.observe(this.getUniqueKey(node, key));\n                }\n            },\n\n            /**\n             * @param {String} node\n             * @param {String} key\n             * @return {String}\n             */\n            getUniqueKey: function (node, key) {\n                return node + '-' + key;\n            },\n\n            /**\n             * @param {String} key\n             * @return {null}\n             */\n            getConfigValue: function (key) {\n                return window.giftOptionsConfig.hasOwnProperty(key) ?\n                    window.giftOptionsConfig[key]\n                    : null;\n            },\n\n            /**\n             * Reset.\n             */\n            reset: function () {\n                this.getObservable('isClear')(true);\n            },\n\n            /**\n             * @return {Array}\n             */\n            getAfterSubmitCallbacks: function () {\n                var callbacks = [];\n\n                callbacks.push(this.afterSubmit);\n                _.each(this.additionalOptions, function (option) {\n                    if (_.isFunction(option.afterSubmit)) {\n                        callbacks.push(option.afterSubmit);\n                    }\n                });\n\n                return callbacks;\n            },\n\n            /**\n             * After submit.\n             */\n            afterSubmit: function () {\n                window.location.href = url.build('checkout/cart/updatePost') +\n                    '?form_key=' + window.checkoutConfig.formKey +\n                    '&cart[]';\n            },\n\n            /**\n             * @param {Boolean} remove\n             * @return {Object}\n             */\n            getSubmitParams: function (remove) {\n                var params = {},\n                    self = this;\n\n                _.each(this.submitParams, function (key) {\n                    var observable = provider[self.getUniqueKey(self.id, key)];\n\n                    if (_.isFunction(observable)) {\n                        params[key] = remove ? null : observable();\n                    }\n                });\n\n                if (this.additionalOptions.length) {\n                    params['extension_attributes'] = {};\n                }\n                _.each(this.additionalOptions, function (option) {\n                    if (_.isFunction(option.getSubmitParams)) {\n                        params['extension_attributes'] = _.extend(\n                            params['extension_attributes'],\n                            option.getSubmitParams(remove)\n                        );\n                    }\n                });\n\n                return params;\n            },\n\n            /**\n             * Check if gift message can be displayed\n             *\n             * @returns {Boolean}\n             */\n            isGiftMessageAvailable: function () {\n                var isGloballyAvailable,\n                    giftMessageConfig,\n                    itemConfig;\n\n                // itemId represent gift message level: 'orderLevel' constant or cart item ID\n                if (this.itemId === 'orderLevel') {\n                    return this.getConfigValue('isOrderLevelGiftOptionsEnabled');\n                }\n\n                // gift message product configuration must override system configuration\n                isGloballyAvailable = this.getConfigValue('isItemLevelGiftOptionsEnabled');\n                giftMessageConfig = window.giftOptionsConfig.giftMessage;\n                itemConfig = giftMessageConfig.hasOwnProperty('itemLevel') &&\n                    giftMessageConfig.itemLevel.hasOwnProperty(this.itemId) ?\n                    giftMessageConfig.itemLevel[this.itemId] :\n                    {};\n\n                return itemConfig.hasOwnProperty('is_available') ? itemConfig['is_available'] : isGloballyAvailable;\n            }\n        };\n\n        model.initialize();\n\n        return model;\n    };\n});\n","Magento_GiftMessage/js/view/gift-message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_GiftMessage/js/model/gift-message',\n    'Magento_GiftMessage/js/model/gift-options',\n    'Magento_GiftMessage/js/action/gift-options'\n], function (Component, GiftMessage, giftOptions, giftOptionsService) {\n    'use strict';\n\n    return Component.extend({\n        formBlockVisibility: null,\n        resultBlockVisibility: null,\n        model: {},\n\n        /**\n         * Component init\n         */\n        initialize: function () {\n            var self = this,\n                model;\n\n            this._super()\n                .observe('formBlockVisibility')\n                .observe({\n                    'resultBlockVisibility': false\n                });\n\n            this.itemId = this.itemId || 'orderLevel';\n            model = new GiftMessage(this.itemId);\n            this.model = model;\n            this.isResultBlockVisible();\n            giftOptions.addOption(model);\n\n            this.model.getObservable('isClear').subscribe(function (value) {\n                if (value == true) { //eslint-disable-line eqeqeq\n                    self.formBlockVisibility(false);\n                    self.model.getObservable('alreadyAdded')(true);\n                }\n            });\n        },\n\n        /**\n         * Is reslt block visible\n         */\n        isResultBlockVisible: function () {\n            var self = this;\n\n            if (this.model.getObservable('alreadyAdded')()) {\n                this.resultBlockVisibility(true);\n            }\n            this.model.getObservable('additionalOptionsApplied').subscribe(function (value) {\n                if (value == true) { //eslint-disable-line eqeqeq\n                    self.resultBlockVisibility(true);\n                }\n            });\n        },\n\n        /**\n         * @param {String} key\n         * @return {*}\n         */\n        getObservable: function (key) {\n            return this.model.getObservable(key);\n        },\n\n        /**\n         * Hide\\Show form block\n         */\n        toggleFormBlockVisibility: function () {\n            if (!this.model.getObservable('alreadyAdded')()) {\n                this.formBlockVisibility(!this.formBlockVisibility());\n            } else {\n                this.resultBlockVisibility(!this.resultBlockVisibility());\n            }\n        },\n\n        /**\n         * Edit options\n         */\n        editOptions: function () {\n            this.resultBlockVisibility(false);\n            this.formBlockVisibility(true);\n        },\n\n        /**\n         * Delete options\n         */\n        deleteOptions: function () {\n            giftOptionsService(this.model, true);\n        },\n\n        /**\n         * Hide form block\n         */\n        hideFormBlock: function () {\n            this.formBlockVisibility(false);\n\n            if (this.model.getObservable('alreadyAdded')()) {\n                this.resultBlockVisibility(true);\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        hasActiveOptions: function () {\n            var regionData = this.getRegion('additionalOptions'),\n                options = regionData(),\n                i;\n\n            for (i = 0; i < options.length; i++) {\n                if (options[i].isActive()) {\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isActive: function () {\n            return this.model.isGiftMessageAvailable();\n        },\n\n        /**\n         * Submit options\n         */\n        submitOptions: function () {\n            giftOptionsService(this.model);\n        }\n    });\n});\n","Magento_Downloadable/js/downloadable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'Magento_Catalog/js/price-box'\n], function ($) {\n    'use strict';\n\n    /**\n     * Downloadable widget\n     */\n    $.widget('mage.downloadable', {\n        options: {\n            priceHolderSelector: '.price-box',\n            linkElement: '',\n            allElements: ''\n        },\n\n        /**\n         * @inheritdoc\n         */\n        _init: function initLinks() {\n            var element = this.element,\n                options = $(this.options.linkElement, element);\n\n            options.trigger('change');\n        },\n\n        /**\n         *  @inheritdoc\n         */\n        _create: function () {\n            var self = this;\n\n            this.element.find(this.options.linkElement).on('change', $.proxy(function () {\n                this._reloadPrice();\n            }, this));\n\n            this.element.find(this.options.allElements).on('change', function () {\n                if (this.checked) {\n                    $('label[for=\"' + this.id + '\"] > span').text($(this).attr('data-checked'));\n                    self.element.find(self.options.linkElement + ':not(:checked)').each(function () {\n                        $(this).trigger('click');\n                    });\n                } else {\n                    $('[for=\"' + this.id + '\"] > span').text($(this).attr('data-notchecked'));\n                    self.element.find(self.options.linkElement + ':checked').each(function () {\n                        $(this).trigger('click');\n                    });\n                }\n            });\n\n            this._reloadPrice();\n        },\n\n        /**\n         * Reload product price with selected link price included\n         * @private\n         */\n        _reloadPrice: function () {\n            var finalPrice = 0,\n                basePrice = 0;\n\n            this.element.find(this.options.linkElement + ':checked').each($.proxy(function (index, element) {\n                finalPrice += this.options.config.links[$(element).val()].finalPrice;\n                basePrice += this.options.config.links[$(element).val()].basePrice;\n            }, this));\n\n            $(this.options.priceHolderSelector).trigger('updatePrice', {\n                'prices': {\n                    'finalPrice': {\n                        'amount': finalPrice\n                    },\n                    'basePrice': {\n                        'amount': basePrice\n                    }\n                }\n            });\n\n            this.reloadAllCheckText();\n        },\n\n        /**\n         * Reload all-elements-checkbox's label\n         * @private\n         */\n        reloadAllCheckText: function () {\n            var allChecked = true,\n                allElementsCheck = $(this.options.allElements),\n                allElementsLabel = $('label[for=\"' + allElementsCheck.attr('id') + '\"] > span');\n\n            $(this.options.linkElement).each(function () {\n                if (!this.checked) {\n                    allChecked = false;\n                }\n            });\n\n            if (allChecked) {\n                allElementsLabel.text(allElementsCheck.attr('data-checked'));\n                allElementsCheck.prop('checked', true);\n            } else {\n                allElementsLabel.text(allElementsCheck.attr('data-notchecked'));\n                allElementsCheck.prop('checked', false);\n            }\n        }\n    });\n\n    return $.mage.downloadable;\n});\n","Magento_CardinalCommerce/js/cardinal-client.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiClass',\n    'Magento_CardinalCommerce/js/cardinal-factory',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate'\n], function ($, Class, cardinalFactory, quote, $t) {\n    'use strict';\n\n    return {\n        /**\n         * Starts Cardinal Consumer Authentication\n         *\n         * @param {Object} cardData\n         * @return {jQuery.Deferred}\n         */\n        startAuthentication: function (cardData) {\n            var deferred = $.Deferred();\n\n            if (this.cardinalClient) {\n                this._startAuthentication(deferred, cardData);\n            } else {\n                cardinalFactory(this.getEnvironment())\n                    .done(function (client) {\n                        this.cardinalClient = client;\n                        this._startAuthentication(deferred, cardData);\n                    }.bind(this));\n            }\n\n            return deferred.promise();\n        },\n\n        /**\n         * Cardinal Consumer Authentication\n         *\n         * @param {jQuery.Deferred} deferred\n         * @param {Object} cardData\n         */\n        _startAuthentication: function (deferred, cardData) {\n            //this.cardinalClient.configure({ logging: { level: 'verbose' } });\n            this.cardinalClient.on('payments.validated', function (data, jwt) {\n                if (data.ErrorNumber !== 0) {\n                    deferred.reject(data.ErrorDescription);\n                } else if ($.inArray(data.ActionCode, ['FAILURE', 'ERROR']) !== -1) {\n                    deferred.reject($t('Authentication Failed. Please try again with another form of payment.'));\n                } else {\n                    deferred.resolve(jwt);\n                }\n                this.cardinalClient.off('payments.validated');\n            }.bind(this));\n\n            this.cardinalClient.on('payments.setupComplete', function () {\n                this.cardinalClient.start('cca', this.getRequestOrderObject(cardData));\n                this.cardinalClient.off('payments.setupComplete');\n            }.bind(this));\n\n            this.cardinalClient.setup('init', {\n                jwt: this.getRequestJWT()\n            });\n        },\n\n        /**\n         * Returns request order object.\n         *\n         * The request order object is structured object that is used to pass data\n         * to Cardinal that describes an order you'd like to process.\n         *\n         * If you pass a request object in both the JWT and the browser,\n         * Cardinal will merge the objects together where the browser overwrites\n         * the JWT object as it is considered the most recently captured data.\n         *\n         * @param {Object} cardData\n         * @returns {Object}\n         */\n        getRequestOrderObject: function (cardData) {\n            var totalAmount = quote.totals()['base_grand_total'],\n                currencyCode = quote.totals()['base_currency_code'],\n                billingAddress = quote.billingAddress(),\n                requestObject;\n\n            requestObject = {\n                OrderDetails: {\n                    Amount: totalAmount * 100,\n                    CurrencyCode: currencyCode\n                },\n                Consumer: {\n                    Account: {\n                        AccountNumber: cardData.accountNumber,\n                        ExpirationMonth: cardData.expMonth,\n                        ExpirationYear: cardData.expYear,\n                        CardCode: cardData.cardCode\n                    },\n                    BillingAddress: {\n                        FirstName: billingAddress.firstname,\n                        LastName: billingAddress.lastname,\n                        Address1: billingAddress.street[0],\n                        Address2: billingAddress.street[1],\n                        City: billingAddress.city,\n                        State: billingAddress.region,\n                        PostalCode: billingAddress.postcode,\n                        CountryCode: billingAddress.countryId,\n                        Phone1: billingAddress.telephone\n                    }\n                }\n            };\n\n            return requestObject;\n        },\n\n        /**\n         * Returns request JWT\n         * @returns {String}\n         */\n        getRequestJWT: function () {\n            return window.checkoutConfig.cardinal.requestJWT;\n        },\n\n        /**\n         * Returns type of environment\n         * @returns {String}\n         */\n        getEnvironment: function () {\n            return window.checkoutConfig.cardinal.environment;\n        }\n    };\n});\n","Magento_CardinalCommerce/js/cardinal-factory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (environment) {\n        var deferred = $.Deferred(),\n            dependency = 'cardinaljs';\n\n        if (environment === 'sandbox') {\n            dependency = 'cardinaljsSandbox';\n        }\n\n        require(\n            [dependency],\n            function (Cardinal) {\n                deferred.resolve(Cardinal);\n            },\n            deferred.reject\n        );\n\n        return deferred.promise();\n    };\n});\n","Magento_Ups/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Ups/js/model/shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Ups/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'postcode': {\n                    'required': true\n                },\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Ups/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    'Magento_Ups/js/model/shipping-rates-validator',\n    'Magento_Ups/js/model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    upsShippingRatesValidator,\n    upsShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('ups', upsShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('ups', upsShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_Variable/js/grid/columns/radioselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column',\n    'jquery'\n], function (_, $t, Column, jQuery) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Variable/grid/cells/radioselect',\n            draggable: false,\n            sortable: false,\n            selectedVariableCode: null,\n            selectedVariableType: null\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['selectedVariableCode']);\n\n            return this;\n        },\n\n        /**\n         * Remove disable class from Insert Variable button after Variable has been chosen.\n         *\n         * @return {Boolean}\n         */\n        selectVariable: function () {\n            if (jQuery('#insert_variable').hasClass('disabled')) {\n                jQuery('#insert_variable').removeClass('disabled');\n            }\n\n            return true;\n        }\n    });\n});\n","Magento_Security/js/escaper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * A loose JavaScript version of Magento\\Framework\\Escaper\n *\n * Due to differences in how XML/HTML is processed in PHP vs JS there are a couple of minor differences in behavior\n * from the PHP counterpart.\n *\n * The first difference is that the default invocation of escapeHtml without allowedTags will double-escape existing\n * entities as the intention of such an invocation is that the input isn't supposed to contain any HTML.\n *\n * The second difference is that escapeHtml will not escape quotes. Since the input is actually being processed by the\n * DOM there is no chance of quotes being mixed with HTML syntax. And, since escapeHtml is not\n * intended to be used with raw injection into a HTML attribute, this is acceptable.\n *\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        neverAllowedElements: ['script', 'img', 'embed', 'iframe', 'video', 'source', 'object', 'audio'],\n        generallyAllowedAttributes: ['id', 'class', 'href', 'title', 'style'],\n        forbiddenAttributesByElement: {\n            a: ['style']\n        },\n\n        /**\n         * Escape a string for safe injection into HTML\n         *\n         * @param {String} data\n         * @param {Array|null} allowedTags\n         * @returns {String}\n         */\n        escapeHtml: function (data, allowedTags) {\n            var domParser = new DOMParser(),\n                fragment = domParser.parseFromString('<div></div>', 'text/html');\n\n            fragment = fragment.body.childNodes[0];\n            allowedTags = typeof allowedTags === 'object' && allowedTags.length ? allowedTags : null;\n\n            if (allowedTags) {\n                fragment.innerHTML = data || '';\n                allowedTags = this._filterProhibitedTags(allowedTags);\n\n                this._removeComments(fragment);\n                this._removeNotAllowedElements(fragment, allowedTags);\n                this._removeNotAllowedAttributes(fragment);\n\n                return fragment.innerHTML;\n            }\n\n            fragment.textContent = data || '';\n\n            return fragment.innerHTML;\n        },\n\n        /**\n         * Remove the always forbidden tags from a list of provided tags\n         *\n         * @param {Array} tags\n         * @returns {Array}\n         * @private\n         */\n        _filterProhibitedTags: function (tags) {\n            return tags.filter(function (n) {\n                return this.neverAllowedElements.indexOf(n) === -1;\n            }.bind(this));\n        },\n\n        /**\n         * Remove comment nodes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeComments: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_COMMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                    false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                nodesToRemove.push(treeWalker.currentNode);\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.removeChild(nodeToRemove);\n            });\n        },\n\n        /**\n         * Strip the given node of all disallowed tags while permitting any nested text nodes\n         *\n         * @param {Node} node\n         * @param {Array|null} allowedTags\n         * @private\n         */\n        _removeNotAllowedElements: function (node, allowedTags) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function (currentNode) {\n                        return allowedTags.indexOf(currentNode.nodeName.toLowerCase()) === -1 ?\n                            NodeFilter.FILTER_ACCEPT\n                            // SKIP instead of REJECT because REJECT also rejects child nodes\n                            : NodeFilter.FILTER_SKIP;\n                    },\n                false\n                ),\n                nodesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                if (allowedTags.indexOf(treeWalker.currentNode.nodeName.toLowerCase()) === -1) {\n                    nodesToRemove.push(treeWalker.currentNode);\n                }\n            }\n\n            nodesToRemove.forEach(function (nodeToRemove) {\n                nodeToRemove.parentNode.replaceChild(\n                    node.ownerDocument.createTextNode(nodeToRemove.textContent),\n                    nodeToRemove\n                );\n            });\n        },\n\n        /**\n         * Remove any invalid attributes from the given node\n         *\n         * @param {Node} node\n         * @private\n         */\n        _removeNotAllowedAttributes: function (node) {\n            var treeWalker = node.ownerDocument.createTreeWalker(\n                    node,\n                    NodeFilter.SHOW_ELEMENT,\n                    function () {\n                        return NodeFilter.FILTER_ACCEPT;\n                    },\n                false\n                ),\n                i,\n                attribute,\n                nodeName,\n                attributesToRemove = [];\n\n            while (treeWalker.nextNode()) {\n                for (i = 0; i < treeWalker.currentNode.attributes.length; i++) {\n                    attribute = treeWalker.currentNode.attributes[i];\n                    nodeName = treeWalker.currentNode.nodeName.toLowerCase();\n\n                    if (this.generallyAllowedAttributes.indexOf(attribute.name) === -1  || // eslint-disable-line max-depth,max-len\n                        this._checkHrefValue(attribute) ||\n                        this.forbiddenAttributesByElement[nodeName] &&\n                        this.forbiddenAttributesByElement[nodeName].indexOf(attribute.name) !== -1\n                    ) {\n                        attributesToRemove.push(attribute);\n                    }\n                }\n            }\n\n            attributesToRemove.forEach(function (attributeToRemove) {\n                attributeToRemove.ownerElement.removeAttribute(attributeToRemove.name);\n            });\n        },\n\n        /**\n         * Check that attribute contains script content\n         *\n         * @param {Object} attribute\n         * @private\n         */\n        _checkHrefValue: function (attribute) {\n            return attribute.nodeName === 'href' && attribute.nodeValue.startsWith('javascript');\n        }\n    };\n});\n","Magento_Fedex/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Fedex/js/model/shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Fedex/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'postcode': {\n                    'required': true\n                },\n                'country_id': {\n                    'required': true\n                },\n                'city': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Fedex/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    'Magento_Fedex/js/model/shipping-rates-validator',\n    'Magento_Fedex/js/model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    fedexShippingRatesValidator,\n    fedexShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('fedex', fedexShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('fedex', fedexShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_ReCaptchaCheckout/js/webapiReCaptchaRegistry-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function (originalFunction) {\n        /**\n         * {@inheritDoc}\n         */\n       originalFunction.addListener = function (id , func) {\n            this._listeners[id] = func;\n       };\n\n        return originalFunction;\n    };\n\n});\n","Magento_ReCaptchaCheckout/js/reCaptchaCheckout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(\n    [\n        'Magento_ReCaptchaWebapiUi/js/webapiReCaptcha',\n        'jquery'\n    ],\n    function (Component, $) {\n        'use strict';\n\n        var reCaptchaIds = new WeakMap(),\n            uuid = 0;\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_ReCaptchaCheckout/reCaptcha',\n                skipPayments: [] // List of payment methods that do not require this reCaptcha\n            },\n\n            /**\n             * Render reCAPTCHA for payment method\n             *\n             * @param {Object} method\n             */\n            renderReCaptchaFor: function (method) {\n                var reCaptcha;\n\n                if (this.isCheckoutReCaptchaRequiredFor(method)) {\n                    reCaptcha = $.extend(true, {}, this, {reCaptchaId: this.getReCaptchaIdFor(method)});\n                    reCaptcha.renderReCaptcha();\n                }\n            },\n\n            /**\n             * Get reCAPTCHA ID for payment method\n             *\n             * @param {Object} method\n             * @returns {String}\n             */\n            getReCaptchaIdFor: function (method) {\n                if (!reCaptchaIds.has(method)) {\n                    reCaptchaIds.set(method, this.getReCaptchaId() + '-' + uuid++);\n                }\n                return reCaptchaIds.get(method);\n            },\n\n            /**\n             * Check whether checkout reCAPTCHA is required for payment method\n             *\n             * @param {Object} method\n             * @returns {Boolean}\n             */\n            isCheckoutReCaptchaRequiredFor: function (method) {\n                return !this.skipPayments || !this.skipPayments.hasOwnProperty(method.getCode());\n            },\n\n            /**\n             * @inheritdoc\n             */\n            initCaptcha: function () {\n                var $wrapper,\n                    $recaptchaResponseInput;\n\n                this._super();\n                // Since there will be multiple reCaptcha in the payment form,\n                // they may override each other if the form data is serialized and submitted.\n                // Instead, the reCaptcha response will be collected in the callback: reCaptchaCallback()\n                // and sent in the request header X-ReCaptcha\n                $wrapper = $('#' + this.getReCaptchaId() + '-wrapper');\n                $recaptchaResponseInput = $wrapper.find('[name=g-recaptcha-response]');\n                if ($recaptchaResponseInput.length) {\n                    $recaptchaResponseInput.prop('disabled', true);\n                }\n            }\n        });\n    }\n);\n","Magento_ReCaptchaCheckout/js/model/place-order-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable max-nested-callbacks */\n\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry'\n], function ($, wrapper, recaptchaRegistry) {\n    'use strict';\n\n    return function (placeOrder) {\n        return wrapper.wrap(placeOrder, function (originalAction, serviceUrl, payload, messageContainer) {\n            var recaptchaDeferred,\n                reCaptchaId,\n                $activeReCaptcha;\n\n            $activeReCaptcha = $('.recaptcha-checkout-place-order:visible .g-recaptcha');\n\n            if ($activeReCaptcha.length > 0) {\n                reCaptchaId = $activeReCaptcha.last().attr('id');\n            }\n\n            if (reCaptchaId !== undefined && recaptchaRegistry.triggers.hasOwnProperty(reCaptchaId)) {\n                //ReCaptcha is present for checkout\n                recaptchaDeferred = $.Deferred();\n                recaptchaRegistry.addListener(reCaptchaId, function (token) {\n                    //Add reCaptcha value to place-order request and resolve deferred with the API call results\n                    payload.xReCaptchaValue = token;\n                    originalAction(serviceUrl, payload, messageContainer).done(function () {\n                        recaptchaDeferred.resolve.apply(recaptchaDeferred, arguments);\n                    }).fail(function () {\n                        recaptchaDeferred.reject.apply(recaptchaDeferred, arguments);\n                    });\n                });\n                //Trigger ReCaptcha validation\n                recaptchaRegistry.triggers[reCaptchaId]();\n\n                if (\n                    !recaptchaRegistry._isInvisibleType.hasOwnProperty(reCaptchaId) ||\n                    recaptchaRegistry._isInvisibleType[reCaptchaId] === false\n                ) {\n                    //remove listener so that place order action is only triggered by the 'Place Order' button\n                    recaptchaRegistry.removeListener(reCaptchaId);\n                }\n\n                return recaptchaDeferred;\n            }\n\n            //No ReCaptcha, just sending the request\n            return originalAction(serviceUrl, payload, messageContainer);\n        });\n    };\n});\n","Magewirephp_Magewire/js/livewire.js":"!function(global,factory){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=factory():\"function\"==typeof define&&define.amd?define(factory):(global=\"undefined\"!=typeof globalThis?globalThis:global||self).Livewire=factory()}(this,(function(){\"use strict\";function ownKeys$1(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);enumerableOnly&&(symbols=symbols.filter((function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable}))),keys.push.apply(keys,symbols)}return keys}function _objectSpread2(target){for(var i=1;i<arguments.length;i++){var source=null!=arguments[i]?arguments[i]:{};i%2?ownKeys$1(Object(source),!0).forEach((function(key){_defineProperty(target,key,source[key])})):Object.getOwnPropertyDescriptors?Object.defineProperties(target,Object.getOwnPropertyDescriptors(source)):ownKeys$1(Object(source)).forEach((function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))}))}return target}function _typeof(obj){return(_typeof=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&\"function\"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?\"symbol\":typeof obj})(obj)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError(\"Cannot call a class as a function\")}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,\"value\"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Constructor}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _inherits(subClass,superClass){if(\"function\"!=typeof superClass&&null!==superClass)throw new TypeError(\"Super expression must either be null or a function\");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),superClass&&_setPrototypeOf(subClass,superClass)}function _getPrototypeOf(o){return(_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function(o){return o.__proto__||Object.getPrototypeOf(o)})(o)}function _setPrototypeOf(o,p){return(_setPrototypeOf=Object.setPrototypeOf||function(o,p){return o.__proto__=p,o})(o,p)}function _isNativeReflectConstruct(){if(\"undefined\"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if(\"function\"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}function _assertThisInitialized(self){if(void 0===self)throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\");return self}function _possibleConstructorReturn(self,call){return!call||\"object\"!=typeof call&&\"function\"!=typeof call?_assertThisInitialized(self):call}function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function(){var result,Super=_getPrototypeOf(Derived);if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget)}else result=Super.apply(this,arguments);return _possibleConstructorReturn(this,result)}}function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest()}function _toArray(arr){return _arrayWithHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableRest()}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableSpread()}function _arrayWithoutHoles(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr)}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr}function _iterableToArray(iter){if(\"undefined\"!=typeof Symbol&&null!=iter[Symbol.iterator]||null!=iter[\"@@iterator\"])return Array.from(iter)}function _iterableToArrayLimit(arr,i){var _i=null==arr?null:\"undefined\"!=typeof Symbol&&arr[Symbol.iterator]||arr[\"@@iterator\"];if(null!=_i){var _s,_e,_arr=[],_n=!0,_d=!1;try{for(_i=_i.call(arr);!(_n=(_s=_i.next()).done)&&(_arr.push(_s.value),!i||_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err}finally{try{_n||null==_i.return||_i.return()}finally{if(_d)throw _e}}return _arr}}function _unsupportedIterableToArray(o,minLen){if(o){if(\"string\"==typeof o)return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);return\"Object\"===n&&o.constructor&&(n=o.constructor.name),\"Map\"===n||\"Set\"===n?Array.from(o):\"Arguments\"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?_arrayLikeToArray(o,minLen):void 0}}function _arrayLikeToArray(arr,len){(null==len||len>arr.length)&&(len=arr.length);for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}function _nonIterableSpread(){throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\")}function _nonIterableRest(){throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\")}function debounce(func,wait,immediate){var timeout;return function(){var context=this,args=arguments,later=function(){timeout=null,immediate||func.apply(context,args)},callNow=immediate&&!timeout;clearTimeout(timeout),timeout=setTimeout(later,wait),callNow&&func.apply(context,args)}}function wireDirectives(el){return new DirectiveManager$1(el)}var DirectiveManager$1=function(){function DirectiveManager(el){_classCallCheck(this,DirectiveManager),this.el=el,this.directives=this.extractTypeModifiersAndValue()}return _createClass(DirectiveManager,[{key:\"all\",value:function(){return this.directives}},{key:\"has\",value:function(type){return this.directives.map((function(directive){return directive.type})).includes(type)}},{key:\"missing\",value:function(type){return!this.has(type)}},{key:\"get\",value:function(type){return this.directives.find((function(directive){return directive.type===type}))}},{key:\"extractTypeModifiersAndValue\",value:function(){var _this=this;return Array.from(this.el.getAttributeNames().filter((function(name){return name.match(new RegExp(\"wire:\"))})).map((function(name){var _name$replace$split2=_toArray(name.replace(new RegExp(\"wire:\"),\"\").split(\".\")),type=_name$replace$split2[0],modifiers=_name$replace$split2.slice(1);return new Directive(type,modifiers,name,_this.el)})))}}]),DirectiveManager}(),Directive=function(){function Directive(type,modifiers,rawName,el){_classCallCheck(this,Directive),this.type=type,this.modifiers=modifiers,this.rawName=rawName,this.el=el,this.eventContext}return _createClass(Directive,[{key:\"setEventContext\",value:function(context){this.eventContext=context}},{key:\"value\",get:function(){return this.el.getAttribute(this.rawName)}},{key:\"method\",get:function(){return this.parseOutMethodAndParams(this.value).method}},{key:\"params\",get:function(){return this.parseOutMethodAndParams(this.value).params}},{key:\"durationOr\",value:function(defaultDuration){var durationInMilliSeconds,durationInMilliSecondsString=this.modifiers.find((function(mod){return mod.match(/([0-9]+)ms/)})),durationInSecondsString=this.modifiers.find((function(mod){return mod.match(/([0-9]+)s/)}));return durationInMilliSecondsString?durationInMilliSeconds=Number(durationInMilliSecondsString.replace(\"ms\",\"\")):durationInSecondsString&&(durationInMilliSeconds=1e3*Number(durationInSecondsString.replace(\"s\",\"\"))),durationInMilliSeconds||defaultDuration}},{key:\"parseOutMethodAndParams\",value:function(rawMethod){var method=rawMethod,params=[],methodAndParamString=method.match(/([\\s\\S]*?)\\(([\\s\\S]*)\\)/);methodAndParamString&&(method=methodAndParamString[1],params=new Function(\"$event\",\"return (function () {\\n                for (var l=arguments.length, p=new Array(l), k=0; k<l; k++) {\\n                    p[k] = arguments[k];\\n                }\\n                return [].concat(p);\\n            })(\".concat(methodAndParamString[2],\")\"))(this.eventContext));return{method:method,params:params}}},{key:\"cardinalDirectionOr\",value:function(){var fallback=arguments.length>0&&void 0!==arguments[0]?arguments[0]:\"right\";return this.modifiers.includes(\"up\")?\"up\":this.modifiers.includes(\"down\")?\"down\":this.modifiers.includes(\"left\")?\"left\":this.modifiers.includes(\"right\")?\"right\":fallback}}]),Directive}();function walk(root,callback){if(!1!==callback(root))for(var node=root.firstElementChild;node;)walk(node,callback),node=node.nextElementSibling}function dispatch(eventName){var event=document.createEvent(\"Events\");return event.initEvent(eventName,!0,!0),document.dispatchEvent(event),event}function getCsrfToken(){var _window$livewire_toke,tokenTag=document.head.querySelector('meta[name=\"csrf-token\"]');return tokenTag?tokenTag.content:null!==(_window$livewire_toke=window.livewire_token)&&void 0!==_window$livewire_toke?_window$livewire_toke:void 0}function kebabCase(subject){return subject.replace(/([a-z])([A-Z])/g,\"$1-$2\").replace(/[_\\s]/,\"-\").toLowerCase()}\n    /*!\n       * isobject <https://github.com/jonschlinkert/isobject>\n       *\n       * Copyright (c) 2014-2017, Jon Schlinkert.\n       * Released under the MIT License.\n       */var isobject=function(val){return null!=val&&\"object\"==typeof val&&!1===Array.isArray(val)},getValue=function(target,path,options){if(isobject(options)||(options={default:options}),!isValidObject(target))return void 0!==options.default?options.default:target;\"number\"==typeof path&&(path=String(path));const isArray=Array.isArray(path),isString=\"string\"==typeof path,splitChar=options.separator||\".\",joinChar=options.joinChar||(\"string\"==typeof splitChar?splitChar:\".\");if(!isString&&!isArray)return target;if(isString&&path in target)return isValid(path,target,options)?target[path]:options.default;let segs=isArray?path:split$1(path,splitChar,options),len=segs.length,idx=0;do{let prop=segs[idx];for(\"number\"==typeof prop&&(prop=String(prop));prop&&\"\\\\\"===prop.slice(-1);)prop=join([prop.slice(0,-1),segs[++idx]||\"\"],joinChar,options);if(prop in target){if(!isValid(prop,target,options))return options.default;target=target[prop]}else{let hasProp=!1,n=idx+1;for(;n<len;)if(prop=join([prop,segs[n++]],joinChar,options),hasProp=prop in target){if(!isValid(prop,target,options))return options.default;target=target[prop],idx=n-1;break}if(!hasProp)return options.default}}while(++idx<len&&isValidObject(target));return idx===len?target:options.default};\n    /*!\n       * get-value <https://github.com/jonschlinkert/get-value>\n       *\n       * Copyright (c) 2014-2018, Jon Schlinkert.\n       * Released under the MIT License.\n       */function join(segs,joinChar,options){return\"function\"==typeof options.join?options.join(segs):segs[0]+joinChar+segs[1]}function split$1(path,splitChar,options){return\"function\"==typeof options.split?options.split(path):path.split(splitChar)}function isValid(key,target,options){return\"function\"!=typeof options.isValid||options.isValid(key,target)}function isValidObject(val){return isobject(val)||Array.isArray(val)||\"function\"==typeof val}var _default$6=function(){function _default(el){var skipWatcher=arguments.length>1&&void 0!==arguments[1]&&arguments[1];_classCallCheck(this,_default),this.el=el,this.skipWatcher=skipWatcher,this.resolveCallback=function(){},this.rejectCallback=function(){},this.signature=(Math.random()+1).toString(36).substring(8)}return _createClass(_default,[{key:\"toId\",value:function(){return btoa(encodeURIComponent(this.el.outerHTML))}},{key:\"onResolve\",value:function(callback){this.resolveCallback=callback}},{key:\"onReject\",value:function(callback){this.rejectCallback=callback}},{key:\"resolve\",value:function(thing){this.resolveCallback(thing)}},{key:\"reject\",value:function(thing){this.rejectCallback(thing)}}]),_default}(),_default$5=function(_Action){_inherits(_default,_Action);var _super=_createSuper(_default);function _default(event,params,el){var _this;return _classCallCheck(this,_default),(_this=_super.call(this,el)).type=\"fireEvent\",_this.payload={id:_this.signature,event:event,params:params},_this}return _createClass(_default,[{key:\"toId\",value:function(){return btoa(encodeURIComponent(this.type,this.payload.event,JSON.stringify(this.payload.params)))}}]),_default}(_default$6),MessageBus=function(){function MessageBus(){_classCallCheck(this,MessageBus),this.listeners={}}return _createClass(MessageBus,[{key:\"register\",value:function(name,callback){this.listeners[name]||(this.listeners[name]=[]),this.listeners[name].push(callback)}},{key:\"call\",value:function(name){for(var _len=arguments.length,params=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++)params[_key-1]=arguments[_key];(this.listeners[name]||[]).forEach((function(callback){callback.apply(void 0,params)}))}},{key:\"has\",value:function(name){return Object.keys(this.listeners).includes(name)}}]),MessageBus}(),HookManager={availableHooks:[\"component.initialized\",\"element.initialized\",\"element.updating\",\"element.updated\",\"element.removed\",\"message.sent\",\"message.failed\",\"message.received\",\"message.processed\",\"interceptWireModelSetValue\",\"interceptWireModelAttachListener\",\"beforeReplaceState\",\"beforePushState\"],bus:new MessageBus,register:function(name,callback){if(!this.availableHooks.includes(name))throw\"Livewire: Referencing unknown hook: [\".concat(name,\"]\");this.bus.register(name,callback)},call:function(name){for(var _this$bus,_len=arguments.length,params=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++)params[_key-1]=arguments[_key];(_this$bus=this.bus).call.apply(_this$bus,[name].concat(params))}},DirectiveManager={directives:new MessageBus,register:function(name,callback){if(this.has(name))throw\"Livewire: Directive already registered: [\".concat(name,\"]\");this.directives.register(name,callback)},call:function(name,el,directive,component){this.directives.call(name,el,directive,component)},has:function(name){return this.directives.has(name)}},store$2={componentsById:{},listeners:new MessageBus,initialRenderIsFinished:!1,livewireIsInBackground:!1,livewireIsOffline:!1,sessionHasExpired:!1,sessionHasExpiredCallback:void 0,directives:DirectiveManager,hooks:HookManager,onErrorCallback:function(){},components:function(){var _this=this;return Object.keys(this.componentsById).map((function(key){return _this.componentsById[key]}))},addComponent:function(component){return this.componentsById[component.id]=component},findComponent:function(id){return this.componentsById[id]},getComponentsByName:function(name){return this.components().filter((function(component){return component.name===name}))},hasComponent:function(id){return!!this.componentsById[id]},tearDownComponents:function(){var _this2=this;this.components().forEach((function(component){_this2.removeComponent(component)}))},on:function(event,callback){this.listeners.register(event,callback)},emit:function(event){for(var _this$listeners,_len=arguments.length,params=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++)params[_key-1]=arguments[_key];(_this$listeners=this.listeners).call.apply(_this$listeners,[event].concat(params)),this.componentsListeningForEvent(event).forEach((function(component){return component.addAction(new _default$5(event,params))}))},emitUp:function(el,event){for(var _len2=arguments.length,params=new Array(_len2>2?_len2-2:0),_key2=2;_key2<_len2;_key2++)params[_key2-2]=arguments[_key2];this.componentsListeningForEventThatAreTreeAncestors(el,event).forEach((function(component){return component.addAction(new _default$5(event,params))}))},emitSelf:function(componentId,event){var component=this.findComponent(componentId);if(component.listeners.includes(event)){for(var _len3=arguments.length,params=new Array(_len3>2?_len3-2:0),_key3=2;_key3<_len3;_key3++)params[_key3-2]=arguments[_key3];component.addAction(new _default$5(event,params))}},emitTo:function(componentName,event){for(var _len4=arguments.length,params=new Array(_len4>2?_len4-2:0),_key4=2;_key4<_len4;_key4++)params[_key4-2]=arguments[_key4];var components=this.getComponentsByName(componentName);components.forEach((function(component){component.listeners.includes(event)&&component.addAction(new _default$5(event,params))}))},componentsListeningForEventThatAreTreeAncestors:function(el,event){for(var parentIds=[],parent=el.parentElement.closest(\"[wire\\\\:id]\");parent;)parentIds.push(parent.getAttribute(\"wire:id\")),parent=parent.parentElement.closest(\"[wire\\\\:id]\");return this.components().filter((function(component){return component.listeners.includes(event)&&parentIds.includes(component.id)}))},componentsListeningForEvent:function(event){return this.components().filter((function(component){return component.listeners.includes(event)}))},registerDirective:function(name,callback){this.directives.register(name,callback)},registerHook:function(name,callback){this.hooks.register(name,callback)},callHook:function(name){for(var _this$hooks,_len5=arguments.length,params=new Array(_len5>1?_len5-1:0),_key5=1;_key5<_len5;_key5++)params[_key5-1]=arguments[_key5];(_this$hooks=this.hooks).call.apply(_this$hooks,[name].concat(params))},changeComponentId:function(component,newId){var oldId=component.id;component.id=newId,component.fingerprint.id=newId,this.componentsById[newId]=component,delete this.componentsById[oldId],this.components().forEach((function(component){var children=component.serverMemo.children||{};Object.entries(children).forEach((function(_ref){var _ref2=_slicedToArray(_ref,2),key=_ref2[0],_ref2$=_ref2[1],id=_ref2$.id;_ref2$.tagName,id===oldId&&(children[key].id=newId)}))}))},removeComponent:function(component){component.tearDown(),delete this.componentsById[component.id]},onError:function(callback){this.onErrorCallback=callback},getClosestParentId:function(childId,subsetOfParentIds){var _this3=this,distancesByParentId={};subsetOfParentIds.forEach((function(parentId){var distance=_this3.getDistanceToChild(parentId,childId);distance&&(distancesByParentId[parentId]=distance)}));var closestParentId,smallestDistance=Math.min.apply(Math,_toConsumableArray(Object.values(distancesByParentId)));return Object.entries(distancesByParentId).forEach((function(_ref3){var _ref4=_slicedToArray(_ref3,2),parentId=_ref4[0];_ref4[1]===smallestDistance&&(closestParentId=parentId)})),closestParentId},getDistanceToChild:function(parentId,childId){var distanceMemo=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1,parentComponent=this.findComponent(parentId);if(parentComponent){var childIds=parentComponent.childIds;if(childIds.includes(childId))return distanceMemo;for(var i=0;i<childIds.length;i++){var distance=this.getDistanceToChild(childIds[i],childId,distanceMemo+1);if(distance)return distance}}}},DOM={rootComponentElements:function(){return Array.from(document.querySelectorAll(\"[wire\\\\:id]\"))},rootComponentElementsWithNoParents:function(){var node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;null===node&&(node=document);var allEls=Array.from(node.querySelectorAll(\"[wire\\\\:initial-data]\")),onlyChildEls=Array.from(node.querySelectorAll(\"[wire\\\\:initial-data] [wire\\\\:initial-data]\"));return allEls.filter((function(el){return!onlyChildEls.includes(el)}))},allModelElementsInside:function(root){return Array.from(root.querySelectorAll(\"[wire\\\\:model]\"))},getByAttributeAndValue:function(attribute,value){return document.querySelector(\"[wire\\\\:\".concat(attribute,'=\"').concat(value,'\"]'))},nextFrame:function(fn){var _this=this;requestAnimationFrame((function(){requestAnimationFrame(fn.bind(_this))}))},closestRoot:function(el){return this.closestByAttribute(el,\"id\")},closestByAttribute:function(el,attribute){var closestEl=el.closest(\"[wire\\\\:\".concat(attribute,\"]\"));if(!closestEl)throw\"\\nLivewire Error:\\n\\nCannot find parent element in DOM tree containing attribute: [wire:\".concat(attribute,\"].\\n\\nUsually this is caused by Livewire's DOM-differ not being able to properly track changes.\\n\\nReference the following guide for common causes: https://laravel-livewire.com/docs/troubleshooting \\n\\nReferenced element:\\n\\n\").concat(el.outerHTML,\"\\n\");return closestEl},isComponentRootEl:function(el){return this.hasAttribute(el,\"id\")},hasAttribute:function(el,attribute){return el.hasAttribute(\"wire:\".concat(attribute))},getAttribute:function(el,attribute){return el.getAttribute(\"wire:\".concat(attribute))},removeAttribute:function(el,attribute){return el.removeAttribute(\"wire:\".concat(attribute))},setAttribute:function(el,attribute,value){return el.setAttribute(\"wire:\".concat(attribute),value)},hasFocus:function(el){return el===document.activeElement},isInput:function(el){return[\"INPUT\",\"TEXTAREA\",\"SELECT\"].includes(el.tagName.toUpperCase())},isTextInput:function(el){return[\"INPUT\",\"TEXTAREA\"].includes(el.tagName.toUpperCase())&&![\"checkbox\",\"radio\"].includes(el.type)},valueFromInput:function(el,component){if(\"checkbox\"===el.type){var modelName=wireDirectives(el).get(\"model\").value,modelValue=component.deferredActions[modelName]?component.deferredActions[modelName].payload.value:getValue(component.data,modelName);return Array.isArray(modelValue)?this.mergeCheckboxValueIntoArray(el,modelValue):!!el.checked&&(el.getAttribute(\"value\")||!0)}return\"SELECT\"===el.tagName&&el.multiple?this.getSelectValues(el):el.value},mergeCheckboxValueIntoArray:function(el,arrayValue){return el.checked?arrayValue.includes(el.value)?arrayValue:arrayValue.concat(el.value):arrayValue.filter((function(item){return item!=el.value}))},setInputValueFromModel:function(el,component){var modelString=wireDirectives(el).get(\"model\").value,modelValue=getValue(component.data,modelString);\"input\"===el.tagName.toLowerCase()&&\"file\"===el.type||this.setInputValue(el,modelValue)},setInputValue:function(el,value){if(store$2.callHook(\"interceptWireModelSetValue\",value,el),\"radio\"===el.type)el.checked=el.value==value;else if(\"checkbox\"===el.type)if(Array.isArray(value)){var valueFound=!1;value.forEach((function(val){val==el.value&&(valueFound=!0)})),el.checked=valueFound}else el.checked=!!value;else\"SELECT\"===el.tagName?this.updateSelect(el,value):(value=void 0===value?\"\":value,el.value=value)},getSelectValues:function(el){return Array.from(el.options).filter((function(option){return option.selected})).map((function(option){return option.value||option.text}))},updateSelect:function(el,value){var arrayWrappedValue=[].concat(value).map((function(value){return value+\"\"}));Array.from(el.options).forEach((function(option){option.selected=arrayWrappedValue.includes(option.value)}))}},ceil=Math.ceil,floor=Math.floor,toInteger=function(argument){return isNaN(argument=+argument)?0:(argument>0?floor:ceil)(argument)},requireObjectCoercible=function(it){if(null==it)throw TypeError(\"Can't call method on \"+it);return it},createMethod$3=function(CONVERT_TO_STRING){return function($this,pos){var first,second,S=String(requireObjectCoercible($this)),position=toInteger(pos),size=S.length;return position<0||position>=size?CONVERT_TO_STRING?\"\":void 0:(first=S.charCodeAt(position))<55296||first>56319||position+1===size||(second=S.charCodeAt(position+1))<56320||second>57343?CONVERT_TO_STRING?S.charAt(position):first:CONVERT_TO_STRING?S.slice(position,position+2):second-56320+(first-55296<<10)+65536}},stringMultibyte={codeAt:createMethod$3(!1),charAt:createMethod$3(!0)},commonjsGlobal=\"undefined\"!=typeof globalThis?globalThis:\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:{};function createCommonjsModule(fn,basedir,module){return fn(module={path:basedir,exports:{},require:function(path,base){return commonjsRequire(path,null==base?module.path:base)}},module.exports),module.exports}function commonjsRequire(){throw new Error(\"Dynamic requires are not currently supported by @rollup/plugin-commonjs\")}var check=function(it){return it&&it.Math==Math&&it},global_1=check(\"object\"==typeof globalThis&&globalThis)||check(\"object\"==typeof window&&window)||check(\"object\"==typeof self&&self)||check(\"object\"==typeof commonjsGlobal&&commonjsGlobal)||function(){return this}()||Function(\"return this\")(),fails=function(exec){try{return!!exec()}catch(error){return!0}},descriptors=!fails((function(){return 7!=Object.defineProperty({},1,{get:function(){return 7}})[1]})),isObject=function(it){return\"object\"==typeof it?null!==it:\"function\"==typeof it},document$3=global_1.document,EXISTS=isObject(document$3)&&isObject(document$3.createElement),documentCreateElement=function(it){return EXISTS?document$3.createElement(it):{}},ie8DomDefine=!descriptors&&!fails((function(){return 7!=Object.defineProperty(documentCreateElement(\"div\"),\"a\",{get:function(){return 7}}).a})),anObject=function(it){if(!isObject(it))throw TypeError(String(it)+\" is not an object\");return it},toPrimitive=function(input,PREFERRED_STRING){if(!isObject(input))return input;var fn,val;if(PREFERRED_STRING&&\"function\"==typeof(fn=input.toString)&&!isObject(val=fn.call(input)))return val;if(\"function\"==typeof(fn=input.valueOf)&&!isObject(val=fn.call(input)))return val;if(!PREFERRED_STRING&&\"function\"==typeof(fn=input.toString)&&!isObject(val=fn.call(input)))return val;throw TypeError(\"Can't convert object to primitive value\")},$defineProperty=Object.defineProperty,f$5=descriptors?$defineProperty:function(O,P,Attributes){if(anObject(O),P=toPrimitive(P,!0),anObject(Attributes),ie8DomDefine)try{return $defineProperty(O,P,Attributes)}catch(error){}if(\"get\"in Attributes||\"set\"in Attributes)throw TypeError(\"Accessors not supported\");return\"value\"in Attributes&&(O[P]=Attributes.value),O},objectDefineProperty={f:f$5},createPropertyDescriptor=function(bitmap,value){return{enumerable:!(1&bitmap),configurable:!(2&bitmap),writable:!(4&bitmap),value:value}},createNonEnumerableProperty=descriptors?function(object,key,value){return objectDefineProperty.f(object,key,createPropertyDescriptor(1,value))}:function(object,key,value){return object[key]=value,object},setGlobal=function(key,value){try{createNonEnumerableProperty(global_1,key,value)}catch(error){global_1[key]=value}return value},SHARED=\"__core-js_shared__\",store$1=global_1[SHARED]||setGlobal(SHARED,{}),sharedStore=store$1,functionToString=Function.toString;\"function\"!=typeof sharedStore.inspectSource&&(sharedStore.inspectSource=function(it){return functionToString.call(it)});var inspectSource=sharedStore.inspectSource,WeakMap$1=global_1.WeakMap,nativeWeakMap=\"function\"==typeof WeakMap$1&&/native code/.test(inspectSource(WeakMap$1)),toObject=function(argument){return Object(requireObjectCoercible(argument))},hasOwnProperty={}.hasOwnProperty,has$1=Object.hasOwn||function(it,key){return hasOwnProperty.call(toObject(it),key)},shared=createCommonjsModule((function(module){(module.exports=function(key,value){return sharedStore[key]||(sharedStore[key]=void 0!==value?value:{})})(\"versions\",[]).push({version:\"3.15.2\",mode:\"global\",copyright:\"\u00a9 2021 Denis Pushkarev (zloirock.ru)\"})})),id=0,postfix=Math.random(),uid=function(key){return\"Symbol(\"+String(void 0===key?\"\":key)+\")_\"+(++id+postfix).toString(36)},keys=shared(\"keys\"),sharedKey=function(key){return keys[key]||(keys[key]=uid(key))},hiddenKeys$1={},OBJECT_ALREADY_INITIALIZED=\"Object already initialized\",WeakMap=global_1.WeakMap,set$1,get,has,enforce=function(it){return has(it)?get(it):set$1(it,{})},getterFor=function(TYPE){return function(it){var state;if(!isObject(it)||(state=get(it)).type!==TYPE)throw TypeError(\"Incompatible receiver, \"+TYPE+\" required\");return state}};if(nativeWeakMap||sharedStore.state){var store=sharedStore.state||(sharedStore.state=new WeakMap),wmget=store.get,wmhas=store.has,wmset=store.set;set$1=function(it,metadata){if(wmhas.call(store,it))throw new TypeError(OBJECT_ALREADY_INITIALIZED);return metadata.facade=it,wmset.call(store,it,metadata),metadata},get=function(it){return wmget.call(store,it)||{}},has=function(it){return wmhas.call(store,it)}}else{var STATE=sharedKey(\"state\");hiddenKeys$1[STATE]=!0,set$1=function(it,metadata){if(has$1(it,STATE))throw new TypeError(OBJECT_ALREADY_INITIALIZED);return metadata.facade=it,createNonEnumerableProperty(it,STATE,metadata),metadata},get=function(it){return has$1(it,STATE)?it[STATE]:{}},has=function(it){return has$1(it,STATE)}}var internalState={set:set$1,get:get,has:has,enforce:enforce,getterFor:getterFor},$propertyIsEnumerable={}.propertyIsEnumerable,getOwnPropertyDescriptor$3=Object.getOwnPropertyDescriptor,NASHORN_BUG=getOwnPropertyDescriptor$3&&!$propertyIsEnumerable.call({1:2},1),f$4=NASHORN_BUG?function(V){var descriptor=getOwnPropertyDescriptor$3(this,V);return!!descriptor&&descriptor.enumerable}:$propertyIsEnumerable,objectPropertyIsEnumerable={f:f$4},toString={}.toString,classofRaw=function(it){return toString.call(it).slice(8,-1)},split=\"\".split,indexedObject=fails((function(){return!Object(\"z\").propertyIsEnumerable(0)}))?function(it){return\"String\"==classofRaw(it)?split.call(it,\"\"):Object(it)}:Object,toIndexedObject=function(it){return indexedObject(requireObjectCoercible(it))},$getOwnPropertyDescriptor=Object.getOwnPropertyDescriptor,f$3=descriptors?$getOwnPropertyDescriptor:function(O,P){if(O=toIndexedObject(O),P=toPrimitive(P,!0),ie8DomDefine)try{return $getOwnPropertyDescriptor(O,P)}catch(error){}if(has$1(O,P))return createPropertyDescriptor(!objectPropertyIsEnumerable.f.call(O,P),O[P])},objectGetOwnPropertyDescriptor={f:f$3},redefine=createCommonjsModule((function(module){var getInternalState=internalState.get,enforceInternalState=internalState.enforce,TEMPLATE=String(String).split(\"String\");(module.exports=function(O,key,value,options){var state,unsafe=!!options&&!!options.unsafe,simple=!!options&&!!options.enumerable,noTargetGet=!!options&&!!options.noTargetGet;\"function\"==typeof value&&(\"string\"!=typeof key||has$1(value,\"name\")||createNonEnumerableProperty(value,\"name\",key),(state=enforceInternalState(value)).source||(state.source=TEMPLATE.join(\"string\"==typeof key?key:\"\"))),O!==global_1?(unsafe?!noTargetGet&&O[key]&&(simple=!0):delete O[key],simple?O[key]=value:createNonEnumerableProperty(O,key,value)):simple?O[key]=value:setGlobal(key,value)})(Function.prototype,\"toString\",(function(){return\"function\"==typeof this&&getInternalState(this).source||inspectSource(this)}))})),path=global_1,aFunction$1=function(variable){return\"function\"==typeof variable?variable:void 0},getBuiltIn=function(namespace,method){return arguments.length<2?aFunction$1(path[namespace])||aFunction$1(global_1[namespace]):path[namespace]&&path[namespace][method]||global_1[namespace]&&global_1[namespace][method]},min$2=Math.min,toLength=function(argument){return argument>0?min$2(toInteger(argument),9007199254740991):0},max=Math.max,min$1=Math.min,toAbsoluteIndex=function(index,length){var integer=toInteger(index);return integer<0?max(integer+length,0):min$1(integer,length)},createMethod$2=function(IS_INCLUDES){return function($this,el,fromIndex){var value,O=toIndexedObject($this),length=toLength(O.length),index=toAbsoluteIndex(fromIndex,length);if(IS_INCLUDES&&el!=el){for(;length>index;)if((value=O[index++])!=value)return!0}else for(;length>index;index++)if((IS_INCLUDES||index in O)&&O[index]===el)return IS_INCLUDES||index||0;return!IS_INCLUDES&&-1}},arrayIncludes={includes:createMethod$2(!0),indexOf:createMethod$2(!1)},indexOf=arrayIncludes.indexOf,objectKeysInternal=function(object,names){var key,O=toIndexedObject(object),i=0,result=[];for(key in O)!has$1(hiddenKeys$1,key)&&has$1(O,key)&&result.push(key);for(;names.length>i;)has$1(O,key=names[i++])&&(~indexOf(result,key)||result.push(key));return result},enumBugKeys=[\"constructor\",\"hasOwnProperty\",\"isPrototypeOf\",\"propertyIsEnumerable\",\"toLocaleString\",\"toString\",\"valueOf\"],hiddenKeys=enumBugKeys.concat(\"length\",\"prototype\"),f$2=Object.getOwnPropertyNames||function(O){return objectKeysInternal(O,hiddenKeys)},objectGetOwnPropertyNames={f:f$2},f$1=Object.getOwnPropertySymbols,objectGetOwnPropertySymbols={f:f$1},ownKeys=getBuiltIn(\"Reflect\",\"ownKeys\")||function(it){var keys=objectGetOwnPropertyNames.f(anObject(it)),getOwnPropertySymbols=objectGetOwnPropertySymbols.f;return getOwnPropertySymbols?keys.concat(getOwnPropertySymbols(it)):keys},copyConstructorProperties=function(target,source){for(var keys=ownKeys(source),defineProperty=objectDefineProperty.f,getOwnPropertyDescriptor=objectGetOwnPropertyDescriptor.f,i=0;i<keys.length;i++){var key=keys[i];has$1(target,key)||defineProperty(target,key,getOwnPropertyDescriptor(source,key))}},replacement=/#|\\.prototype\\./,isForced=function(feature,detection){var value=data[normalize(feature)];return value==POLYFILL||value!=NATIVE&&(\"function\"==typeof detection?fails(detection):!!detection)},normalize=isForced.normalize=function(string){return String(string).replace(replacement,\".\").toLowerCase()},data=isForced.data={},NATIVE=isForced.NATIVE=\"N\",POLYFILL=isForced.POLYFILL=\"P\",isForced_1=isForced,getOwnPropertyDescriptor$2=objectGetOwnPropertyDescriptor.f,_export=function(options,source){var target,key,targetProperty,sourceProperty,descriptor,TARGET=options.target,GLOBAL=options.global,STATIC=options.stat;if(target=GLOBAL?global_1:STATIC?global_1[TARGET]||setGlobal(TARGET,{}):(global_1[TARGET]||{}).prototype)for(key in source){if(sourceProperty=source[key],targetProperty=options.noTargetGet?(descriptor=getOwnPropertyDescriptor$2(target,key))&&descriptor.value:target[key],!isForced_1(GLOBAL?key:TARGET+(STATIC?\".\":\"#\")+key,options.forced)&&void 0!==targetProperty){if(typeof sourceProperty==typeof targetProperty)continue;copyConstructorProperties(sourceProperty,targetProperty)}(options.sham||targetProperty&&targetProperty.sham)&&createNonEnumerableProperty(sourceProperty,\"sham\",!0),redefine(target,key,sourceProperty,options)}},correctPrototypeGetter=!fails((function(){function F(){}return F.prototype.constructor=null,Object.getPrototypeOf(new F)!==F.prototype})),IE_PROTO$1=sharedKey(\"IE_PROTO\"),ObjectPrototype=Object.prototype,objectGetPrototypeOf=correctPrototypeGetter?Object.getPrototypeOf:function(O){return O=toObject(O),has$1(O,IE_PROTO$1)?O[IE_PROTO$1]:\"function\"==typeof O.constructor&&O instanceof O.constructor?O.constructor.prototype:O instanceof Object?ObjectPrototype:null},engineUserAgent=getBuiltIn(\"navigator\",\"userAgent\")||\"\",process$3=global_1.process,versions=process$3&&process$3.versions,v8=versions&&versions.v8,match,version;v8?(match=v8.split(\".\"),version=match[0]<4?1:match[0]+match[1]):engineUserAgent&&(match=engineUserAgent.match(/Edge\\/(\\d+)/),(!match||match[1]>=74)&&(match=engineUserAgent.match(/Chrome\\/(\\d+)/),match&&(version=match[1])));var engineV8Version=version&&+version,nativeSymbol=!!Object.getOwnPropertySymbols&&!fails((function(){var symbol=Symbol();return!String(symbol)||!(Object(symbol)instanceof Symbol)||!Symbol.sham&&engineV8Version&&engineV8Version<41})),useSymbolAsUid=nativeSymbol&&!Symbol.sham&&\"symbol\"==typeof Symbol.iterator,WellKnownSymbolsStore=shared(\"wks\"),Symbol$1=global_1.Symbol,createWellKnownSymbol=useSymbolAsUid?Symbol$1:Symbol$1&&Symbol$1.withoutSetter||uid,wellKnownSymbol=function(name){return has$1(WellKnownSymbolsStore,name)&&(nativeSymbol||\"string\"==typeof WellKnownSymbolsStore[name])||(nativeSymbol&&has$1(Symbol$1,name)?WellKnownSymbolsStore[name]=Symbol$1[name]:WellKnownSymbolsStore[name]=createWellKnownSymbol(\"Symbol.\"+name)),WellKnownSymbolsStore[name]},ITERATOR$5=wellKnownSymbol(\"iterator\"),BUGGY_SAFARI_ITERATORS$1=!1,returnThis$2=function(){return this},IteratorPrototype$2,PrototypeOfArrayIteratorPrototype,arrayIterator;[].keys&&(arrayIterator=[].keys(),\"next\"in arrayIterator?(PrototypeOfArrayIteratorPrototype=objectGetPrototypeOf(objectGetPrototypeOf(arrayIterator)),PrototypeOfArrayIteratorPrototype!==Object.prototype&&(IteratorPrototype$2=PrototypeOfArrayIteratorPrototype)):BUGGY_SAFARI_ITERATORS$1=!0);var NEW_ITERATOR_PROTOTYPE=null==IteratorPrototype$2||fails((function(){var test={};return IteratorPrototype$2[ITERATOR$5].call(test)!==test}));NEW_ITERATOR_PROTOTYPE&&(IteratorPrototype$2={}),has$1(IteratorPrototype$2,ITERATOR$5)||createNonEnumerableProperty(IteratorPrototype$2,ITERATOR$5,returnThis$2);var iteratorsCore={IteratorPrototype:IteratorPrototype$2,BUGGY_SAFARI_ITERATORS:BUGGY_SAFARI_ITERATORS$1},objectKeys=Object.keys||function(O){return objectKeysInternal(O,enumBugKeys)},objectDefineProperties=descriptors?Object.defineProperties:function(O,Properties){anObject(O);for(var key,keys=objectKeys(Properties),length=keys.length,index=0;length>index;)objectDefineProperty.f(O,key=keys[index++],Properties[key]);return O},html=getBuiltIn(\"document\",\"documentElement\"),GT=\">\",LT=\"<\",PROTOTYPE=\"prototype\",SCRIPT=\"script\",IE_PROTO=sharedKey(\"IE_PROTO\"),EmptyConstructor=function(){},scriptTag=function(content){return LT+SCRIPT+GT+content+LT+\"/\"+SCRIPT+GT},NullProtoObjectViaActiveX=function(activeXDocument){activeXDocument.write(scriptTag(\"\")),activeXDocument.close();var temp=activeXDocument.parentWindow.Object;return activeXDocument=null,temp},NullProtoObjectViaIFrame=function(){var iframeDocument,iframe=documentCreateElement(\"iframe\"),JS=\"java\"+SCRIPT+\":\";return iframe.style.display=\"none\",html.appendChild(iframe),iframe.src=String(JS),(iframeDocument=iframe.contentWindow.document).open(),iframeDocument.write(scriptTag(\"document.F=Object\")),iframeDocument.close(),iframeDocument.F},activeXDocument,NullProtoObject=function(){try{activeXDocument=document.domain&&new ActiveXObject(\"htmlfile\")}catch(error){}NullProtoObject=activeXDocument?NullProtoObjectViaActiveX(activeXDocument):NullProtoObjectViaIFrame();for(var length=enumBugKeys.length;length--;)delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];return NullProtoObject()};hiddenKeys$1[IE_PROTO]=!0;var objectCreate=Object.create||function(O,Properties){var result;return null!==O?(EmptyConstructor[PROTOTYPE]=anObject(O),result=new EmptyConstructor,EmptyConstructor[PROTOTYPE]=null,result[IE_PROTO]=O):result=NullProtoObject(),void 0===Properties?result:objectDefineProperties(result,Properties)},defineProperty$1=objectDefineProperty.f,TO_STRING_TAG$3=wellKnownSymbol(\"toStringTag\"),setToStringTag=function(it,TAG,STATIC){it&&!has$1(it=STATIC?it:it.prototype,TO_STRING_TAG$3)&&defineProperty$1(it,TO_STRING_TAG$3,{configurable:!0,value:TAG})},iterators={},IteratorPrototype$1=iteratorsCore.IteratorPrototype,returnThis$1=function(){return this},createIteratorConstructor=function(IteratorConstructor,NAME,next){var TO_STRING_TAG=NAME+\" Iterator\";return IteratorConstructor.prototype=objectCreate(IteratorPrototype$1,{next:createPropertyDescriptor(1,next)}),setToStringTag(IteratorConstructor,TO_STRING_TAG,!1),iterators[TO_STRING_TAG]=returnThis$1,IteratorConstructor},aPossiblePrototype=function(it){if(!isObject(it)&&null!==it)throw TypeError(\"Can't set \"+String(it)+\" as a prototype\");return it},objectSetPrototypeOf=Object.setPrototypeOf||(\"__proto__\"in{}?function(){var setter,CORRECT_SETTER=!1,test={};try{(setter=Object.getOwnPropertyDescriptor(Object.prototype,\"__proto__\").set).call(test,[]),CORRECT_SETTER=test instanceof Array}catch(error){}return function(O,proto){return anObject(O),aPossiblePrototype(proto),CORRECT_SETTER?setter.call(O,proto):O.__proto__=proto,O}}():void 0),IteratorPrototype=iteratorsCore.IteratorPrototype,BUGGY_SAFARI_ITERATORS=iteratorsCore.BUGGY_SAFARI_ITERATORS,ITERATOR$4=wellKnownSymbol(\"iterator\"),KEYS=\"keys\",VALUES=\"values\",ENTRIES=\"entries\",returnThis=function(){return this},defineIterator=function(Iterable,NAME,IteratorConstructor,next,DEFAULT,IS_SET,FORCED){createIteratorConstructor(IteratorConstructor,NAME,next);var CurrentIteratorPrototype,methods,KEY,getIterationMethod=function(KIND){if(KIND===DEFAULT&&defaultIterator)return defaultIterator;if(!BUGGY_SAFARI_ITERATORS&&KIND in IterablePrototype)return IterablePrototype[KIND];switch(KIND){case KEYS:case VALUES:case ENTRIES:return function(){return new IteratorConstructor(this,KIND)}}return function(){return new IteratorConstructor(this)}},TO_STRING_TAG=NAME+\" Iterator\",INCORRECT_VALUES_NAME=!1,IterablePrototype=Iterable.prototype,nativeIterator=IterablePrototype[ITERATOR$4]||IterablePrototype[\"@@iterator\"]||DEFAULT&&IterablePrototype[DEFAULT],defaultIterator=!BUGGY_SAFARI_ITERATORS&&nativeIterator||getIterationMethod(DEFAULT),anyNativeIterator=\"Array\"==NAME&&IterablePrototype.entries||nativeIterator;if(anyNativeIterator&&(CurrentIteratorPrototype=objectGetPrototypeOf(anyNativeIterator.call(new Iterable)),IteratorPrototype!==Object.prototype&&CurrentIteratorPrototype.next&&(objectGetPrototypeOf(CurrentIteratorPrototype)!==IteratorPrototype&&(objectSetPrototypeOf?objectSetPrototypeOf(CurrentIteratorPrototype,IteratorPrototype):\"function\"!=typeof CurrentIteratorPrototype[ITERATOR$4]&&createNonEnumerableProperty(CurrentIteratorPrototype,ITERATOR$4,returnThis)),setToStringTag(CurrentIteratorPrototype,TO_STRING_TAG,!0))),DEFAULT==VALUES&&nativeIterator&&nativeIterator.name!==VALUES&&(INCORRECT_VALUES_NAME=!0,defaultIterator=function(){return nativeIterator.call(this)}),IterablePrototype[ITERATOR$4]!==defaultIterator&&createNonEnumerableProperty(IterablePrototype,ITERATOR$4,defaultIterator),iterators[NAME]=defaultIterator,DEFAULT)if(methods={values:getIterationMethod(VALUES),keys:IS_SET?defaultIterator:getIterationMethod(KEYS),entries:getIterationMethod(ENTRIES)},FORCED)for(KEY in methods)(BUGGY_SAFARI_ITERATORS||INCORRECT_VALUES_NAME||!(KEY in IterablePrototype))&&redefine(IterablePrototype,KEY,methods[KEY]);else _export({target:NAME,proto:!0,forced:BUGGY_SAFARI_ITERATORS||INCORRECT_VALUES_NAME},methods);return methods},charAt=stringMultibyte.charAt,STRING_ITERATOR=\"String Iterator\",setInternalState$2=internalState.set,getInternalState$2=internalState.getterFor(STRING_ITERATOR);defineIterator(String,\"String\",(function(iterated){setInternalState$2(this,{type:STRING_ITERATOR,string:String(iterated),index:0})}),(function(){var point,state=getInternalState$2(this),string=state.string,index=state.index;return index>=string.length?{value:void 0,done:!0}:(point=charAt(string,index),state.index+=point.length,{value:point,done:!1})}));var aFunction=function(it){if(\"function\"!=typeof it)throw TypeError(String(it)+\" is not a function\");return it},functionBindContext=function(fn,that,length){if(aFunction(fn),void 0===that)return fn;switch(length){case 0:return function(){return fn.call(that)};case 1:return function(a){return fn.call(that,a)};case 2:return function(a,b){return fn.call(that,a,b)};case 3:return function(a,b,c){return fn.call(that,a,b,c)}}return function(){return fn.apply(that,arguments)}},iteratorClose=function(iterator){var returnMethod=iterator.return;if(void 0!==returnMethod)return anObject(returnMethod.call(iterator)).value},callWithSafeIterationClosing=function(iterator,fn,value,ENTRIES){try{return ENTRIES?fn(anObject(value)[0],value[1]):fn(value)}catch(error){throw iteratorClose(iterator),error}},ITERATOR$3=wellKnownSymbol(\"iterator\"),ArrayPrototype$1=Array.prototype,isArrayIteratorMethod=function(it){return void 0!==it&&(iterators.Array===it||ArrayPrototype$1[ITERATOR$3]===it)},createProperty=function(object,key,value){var propertyKey=toPrimitive(key);propertyKey in object?objectDefineProperty.f(object,propertyKey,createPropertyDescriptor(0,value)):object[propertyKey]=value},TO_STRING_TAG$2=wellKnownSymbol(\"toStringTag\"),test={};test[TO_STRING_TAG$2]=\"z\";var toStringTagSupport=\"[object z]\"===String(test),TO_STRING_TAG$1=wellKnownSymbol(\"toStringTag\"),CORRECT_ARGUMENTS=\"Arguments\"==classofRaw(function(){return arguments}()),tryGet=function(it,key){try{return it[key]}catch(error){}},classof=toStringTagSupport?classofRaw:function(it){var O,tag,result;return void 0===it?\"Undefined\":null===it?\"Null\":\"string\"==typeof(tag=tryGet(O=Object(it),TO_STRING_TAG$1))?tag:CORRECT_ARGUMENTS?classofRaw(O):\"Object\"==(result=classofRaw(O))&&\"function\"==typeof O.callee?\"Arguments\":result},ITERATOR$2=wellKnownSymbol(\"iterator\"),getIteratorMethod=function(it){if(null!=it)return it[ITERATOR$2]||it[\"@@iterator\"]||iterators[classof(it)]},arrayFrom=function(arrayLike){var length,result,step,iterator,next,value,O=toObject(arrayLike),C=\"function\"==typeof this?this:Array,argumentsLength=arguments.length,mapfn=argumentsLength>1?arguments[1]:void 0,mapping=void 0!==mapfn,iteratorMethod=getIteratorMethod(O),index=0;if(mapping&&(mapfn=functionBindContext(mapfn,argumentsLength>2?arguments[2]:void 0,2)),null==iteratorMethod||C==Array&&isArrayIteratorMethod(iteratorMethod))for(result=new C(length=toLength(O.length));length>index;index++)value=mapping?mapfn(O[index],index):O[index],createProperty(result,index,value);else for(next=(iterator=iteratorMethod.call(O)).next,result=new C;!(step=next.call(iterator)).done;index++)value=mapping?callWithSafeIterationClosing(iterator,mapfn,[step.value,index],!0):step.value,createProperty(result,index,value);return result.length=index,result},ITERATOR$1=wellKnownSymbol(\"iterator\"),SAFE_CLOSING=!1;try{var called=0,iteratorWithReturn={next:function(){return{done:!!called++}},return:function(){SAFE_CLOSING=!0}};iteratorWithReturn[ITERATOR$1]=function(){return this},Array.from(iteratorWithReturn,(function(){throw 2}))}catch(error){}var checkCorrectnessOfIteration=function(exec,SKIP_CLOSING){if(!SKIP_CLOSING&&!SAFE_CLOSING)return!1;var ITERATION_SUPPORT=!1;try{var object={};object[ITERATOR$1]=function(){return{next:function(){return{done:ITERATION_SUPPORT=!0}}}},exec(object)}catch(error){}return ITERATION_SUPPORT},INCORRECT_ITERATION$1=!checkCorrectnessOfIteration((function(iterable){Array.from(iterable)}));_export({target:\"Array\",stat:!0,forced:INCORRECT_ITERATION$1},{from:arrayFrom}),path.Array.from;var UNSCOPABLES=wellKnownSymbol(\"unscopables\"),ArrayPrototype=Array.prototype;null==ArrayPrototype[UNSCOPABLES]&&objectDefineProperty.f(ArrayPrototype,UNSCOPABLES,{configurable:!0,value:objectCreate(null)});var addToUnscopables=function(key){ArrayPrototype[UNSCOPABLES][key]=!0},$includes=arrayIncludes.includes;_export({target:\"Array\",proto:!0},{includes:function(el){return $includes(this,el,arguments.length>1?arguments[1]:void 0)}}),addToUnscopables(\"includes\");var call=Function.call,entryUnbind=function(CONSTRUCTOR,METHOD,length){return functionBindContext(call,global_1[CONSTRUCTOR].prototype[METHOD],length)};entryUnbind(\"Array\",\"includes\");var isArray=Array.isArray||function(arg){return\"Array\"==classofRaw(arg)},flattenIntoArray=function(target,original,source,sourceLen,start,depth,mapper,thisArg){for(var element,targetIndex=start,sourceIndex=0,mapFn=!!mapper&&functionBindContext(mapper,thisArg,3);sourceIndex<sourceLen;){if(sourceIndex in source){if(element=mapFn?mapFn(source[sourceIndex],sourceIndex,original):source[sourceIndex],depth>0&&isArray(element))targetIndex=flattenIntoArray(target,original,element,toLength(element.length),targetIndex,depth-1)-1;else{if(targetIndex>=9007199254740991)throw TypeError(\"Exceed the acceptable array length\");target[targetIndex]=element}targetIndex++}sourceIndex++}return targetIndex},flattenIntoArray_1=flattenIntoArray,SPECIES$3=wellKnownSymbol(\"species\"),arraySpeciesCreate=function(originalArray,length){var C;return isArray(originalArray)&&(\"function\"!=typeof(C=originalArray.constructor)||C!==Array&&!isArray(C.prototype)?isObject(C)&&null===(C=C[SPECIES$3])&&(C=void 0):C=void 0),new(void 0===C?Array:C)(0===length?0:length)};_export({target:\"Array\",proto:!0},{flat:function(){var depthArg=arguments.length?arguments[0]:void 0,O=toObject(this),sourceLen=toLength(O.length),A=arraySpeciesCreate(O,0);return A.length=flattenIntoArray_1(A,O,O,sourceLen,0,void 0===depthArg?1:toInteger(depthArg)),A}}),addToUnscopables(\"flat\"),entryUnbind(\"Array\",\"flat\");var push=[].push,createMethod$1=function(TYPE){var IS_MAP=1==TYPE,IS_FILTER=2==TYPE,IS_SOME=3==TYPE,IS_EVERY=4==TYPE,IS_FIND_INDEX=6==TYPE,IS_FILTER_OUT=7==TYPE,NO_HOLES=5==TYPE||IS_FIND_INDEX;return function($this,callbackfn,that,specificCreate){for(var value,result,O=toObject($this),self=indexedObject(O),boundFunction=functionBindContext(callbackfn,that,3),length=toLength(self.length),index=0,create=specificCreate||arraySpeciesCreate,target=IS_MAP?create($this,length):IS_FILTER||IS_FILTER_OUT?create($this,0):void 0;length>index;index++)if((NO_HOLES||index in self)&&(result=boundFunction(value=self[index],index,O),TYPE))if(IS_MAP)target[index]=result;else if(result)switch(TYPE){case 3:return!0;case 5:return value;case 6:return index;case 2:push.call(target,value)}else switch(TYPE){case 4:return!1;case 7:push.call(target,value)}return IS_FIND_INDEX?-1:IS_SOME||IS_EVERY?IS_EVERY:target}},arrayIteration={forEach:createMethod$1(0),map:createMethod$1(1),filter:createMethod$1(2),some:createMethod$1(3),every:createMethod$1(4),find:createMethod$1(5),findIndex:createMethod$1(6),filterOut:createMethod$1(7)},$find=arrayIteration.find,FIND=\"find\",SKIPS_HOLES=!0;FIND in[]&&Array(1)[FIND]((function(){SKIPS_HOLES=!1})),_export({target:\"Array\",proto:!0,forced:SKIPS_HOLES},{find:function(callbackfn){return $find(this,callbackfn,arguments.length>1?arguments[1]:void 0)}}),addToUnscopables(FIND),entryUnbind(\"Array\",\"find\");var $assign=Object.assign,defineProperty=Object.defineProperty,objectAssign=!$assign||fails((function(){if(descriptors&&1!==$assign({b:1},$assign(defineProperty({},\"a\",{enumerable:!0,get:function(){defineProperty(this,\"b\",{value:3,enumerable:!1})}}),{b:2})).b)return!0;var A={},B={},symbol=Symbol();return A[symbol]=7,\"abcdefghijklmnopqrst\".split(\"\").forEach((function(chr){B[chr]=chr})),7!=$assign({},A)[symbol]||\"abcdefghijklmnopqrst\"!=objectKeys($assign({},B)).join(\"\")}))?function(target,source){for(var T=toObject(target),argumentsLength=arguments.length,index=1,getOwnPropertySymbols=objectGetOwnPropertySymbols.f,propertyIsEnumerable=objectPropertyIsEnumerable.f;argumentsLength>index;)for(var key,S=indexedObject(arguments[index++]),keys=getOwnPropertySymbols?objectKeys(S).concat(getOwnPropertySymbols(S)):objectKeys(S),length=keys.length,j=0;length>j;)key=keys[j++],descriptors&&!propertyIsEnumerable.call(S,key)||(T[key]=S[key]);return T}:$assign;_export({target:\"Object\",stat:!0,forced:Object.assign!==objectAssign},{assign:objectAssign}),path.Object.assign;var propertyIsEnumerable=objectPropertyIsEnumerable.f,createMethod=function(TO_ENTRIES){return function(it){for(var key,O=toIndexedObject(it),keys=objectKeys(O),length=keys.length,i=0,result=[];length>i;)key=keys[i++],descriptors&&!propertyIsEnumerable.call(O,key)||result.push(TO_ENTRIES?[key,O[key]]:O[key]);return result}},objectToArray={entries:createMethod(!0),values:createMethod(!1)},$entries=objectToArray.entries;_export({target:\"Object\",stat:!0},{entries:function(O){return $entries(O)}}),path.Object.entries;var $values=objectToArray.values;_export({target:\"Object\",stat:!0},{values:function(O){return $values(O)}}),path.Object.values;var Result=function(stopped,result){this.stopped=stopped,this.result=result},iterate=function(iterable,unboundFunction,options){var iterator,iterFn,index,length,result,next,step,that=options&&options.that,AS_ENTRIES=!(!options||!options.AS_ENTRIES),IS_ITERATOR=!(!options||!options.IS_ITERATOR),INTERRUPTED=!(!options||!options.INTERRUPTED),fn=functionBindContext(unboundFunction,that,1+AS_ENTRIES+INTERRUPTED),stop=function(condition){return iterator&&iteratorClose(iterator),new Result(!0,condition)},callFn=function(value){return AS_ENTRIES?(anObject(value),INTERRUPTED?fn(value[0],value[1],stop):fn(value[0],value[1])):INTERRUPTED?fn(value,stop):fn(value)};if(IS_ITERATOR)iterator=iterable;else{if(\"function\"!=typeof(iterFn=getIteratorMethod(iterable)))throw TypeError(\"Target is not iterable\");if(isArrayIteratorMethod(iterFn)){for(index=0,length=toLength(iterable.length);length>index;index++)if((result=callFn(iterable[index]))&&result instanceof Result)return result;return new Result(!1)}iterator=iterFn.call(iterable)}for(next=iterator.next;!(step=next.call(iterator)).done;){try{result=callFn(step.value)}catch(error){throw iteratorClose(iterator),error}if(\"object\"==typeof result&&result&&result instanceof Result)return result}return new Result(!1)},$AggregateError=function(errors,message){var that=this;if(!(that instanceof $AggregateError))return new $AggregateError(errors,message);objectSetPrototypeOf&&(that=objectSetPrototypeOf(new Error(void 0),objectGetPrototypeOf(that))),void 0!==message&&createNonEnumerableProperty(that,\"message\",String(message));var errorsArray=[];return iterate(errors,errorsArray.push,{that:errorsArray}),createNonEnumerableProperty(that,\"errors\",errorsArray),that};$AggregateError.prototype=objectCreate(Error.prototype,{constructor:createPropertyDescriptor(5,$AggregateError),message:createPropertyDescriptor(5,\"\"),name:createPropertyDescriptor(5,\"AggregateError\")}),_export({global:!0},{AggregateError:$AggregateError});var objectToString=toStringTagSupport?{}.toString:function(){return\"[object \"+classof(this)+\"]\"};toStringTagSupport||redefine(Object.prototype,\"toString\",objectToString,{unsafe:!0});var nativePromiseConstructor=global_1.Promise,redefineAll=function(target,src,options){for(var key in src)redefine(target,key,src[key],options);return target},SPECIES$2=wellKnownSymbol(\"species\"),setSpecies=function(CONSTRUCTOR_NAME){var Constructor=getBuiltIn(CONSTRUCTOR_NAME),defineProperty=objectDefineProperty.f;descriptors&&Constructor&&!Constructor[SPECIES$2]&&defineProperty(Constructor,SPECIES$2,{configurable:!0,get:function(){return this}})},anInstance=function(it,Constructor,name){if(!(it instanceof Constructor))throw TypeError(\"Incorrect \"+(name?name+\" \":\"\")+\"invocation\");return it},SPECIES$1=wellKnownSymbol(\"species\"),speciesConstructor=function(O,defaultConstructor){var S,C=anObject(O).constructor;return void 0===C||null==(S=anObject(C)[SPECIES$1])?defaultConstructor:aFunction(S)},engineIsIos=/(?:iphone|ipod|ipad).*applewebkit/i.test(engineUserAgent),engineIsNode=\"process\"==classofRaw(global_1.process),location=global_1.location,set=global_1.setImmediate,clear=global_1.clearImmediate,process$2=global_1.process,MessageChannel=global_1.MessageChannel,Dispatch=global_1.Dispatch,counter=0,queue={},ONREADYSTATECHANGE=\"onreadystatechange\",defer,channel,port,run=function(id){if(queue.hasOwnProperty(id)){var fn=queue[id];delete queue[id],fn()}},runner=function(id){return function(){run(id)}},listener=function(event){run(event.data)},post=function(id){global_1.postMessage(id+\"\",location.protocol+\"//\"+location.host)};set&&clear||(set=function(fn){for(var args=[],i=1;arguments.length>i;)args.push(arguments[i++]);return queue[++counter]=function(){(\"function\"==typeof fn?fn:Function(fn)).apply(void 0,args)},defer(counter),counter},clear=function(id){delete queue[id]},engineIsNode?defer=function(id){process$2.nextTick(runner(id))}:Dispatch&&Dispatch.now?defer=function(id){Dispatch.now(runner(id))}:MessageChannel&&!engineIsIos?(channel=new MessageChannel,port=channel.port2,channel.port1.onmessage=listener,defer=functionBindContext(port.postMessage,port,1)):global_1.addEventListener&&\"function\"==typeof postMessage&&!global_1.importScripts&&location&&\"file:\"!==location.protocol&&!fails(post)?(defer=post,global_1.addEventListener(\"message\",listener,!1)):defer=ONREADYSTATECHANGE in documentCreateElement(\"script\")?function(id){html.appendChild(documentCreateElement(\"script\"))[ONREADYSTATECHANGE]=function(){html.removeChild(this),run(id)}}:function(id){setTimeout(runner(id),0)});var task$1={set:set,clear:clear},engineIsWebosWebkit=/web0s(?!.*chrome)/i.test(engineUserAgent),getOwnPropertyDescriptor$1=objectGetOwnPropertyDescriptor.f,macrotask=task$1.set,MutationObserver=global_1.MutationObserver||global_1.WebKitMutationObserver,document$2=global_1.document,process$1=global_1.process,Promise$1=global_1.Promise,queueMicrotaskDescriptor=getOwnPropertyDescriptor$1(global_1,\"queueMicrotask\"),queueMicrotask=queueMicrotaskDescriptor&&queueMicrotaskDescriptor.value,flush,head,last,notify$1,toggle,node,promise,then;queueMicrotask||(flush=function(){var parent,fn;for(engineIsNode&&(parent=process$1.domain)&&parent.exit();head;){fn=head.fn,head=head.next;try{fn()}catch(error){throw head?notify$1():last=void 0,error}}last=void 0,parent&&parent.enter()},engineIsIos||engineIsNode||engineIsWebosWebkit||!MutationObserver||!document$2?Promise$1&&Promise$1.resolve?(promise=Promise$1.resolve(void 0),promise.constructor=Promise$1,then=promise.then,notify$1=function(){then.call(promise,flush)}):notify$1=engineIsNode?function(){process$1.nextTick(flush)}:function(){macrotask.call(global_1,flush)}:(toggle=!0,node=document$2.createTextNode(\"\"),new MutationObserver(flush).observe(node,{characterData:!0}),notify$1=function(){node.data=toggle=!toggle}));var microtask=queueMicrotask||function(fn){var task={fn:fn,next:void 0};last&&(last.next=task),head||(head=task,notify$1()),last=task},PromiseCapability=function(C){var resolve,reject;this.promise=new C((function($$resolve,$$reject){if(void 0!==resolve||void 0!==reject)throw TypeError(\"Bad Promise constructor\");resolve=$$resolve,reject=$$reject})),this.resolve=aFunction(resolve),this.reject=aFunction(reject)},f=function(C){return new PromiseCapability(C)},newPromiseCapability$1={f:f},promiseResolve=function(C,x){if(anObject(C),isObject(x)&&x.constructor===C)return x;var promiseCapability=newPromiseCapability$1.f(C);return(0,promiseCapability.resolve)(x),promiseCapability.promise},hostReportErrors=function(a,b){var console=global_1.console;console&&console.error&&(1===arguments.length?console.error(a):console.error(a,b))},perform=function(exec){try{return{error:!1,value:exec()}}catch(error){return{error:!0,value:error}}},engineIsBrowser=\"object\"==typeof window,task=task$1.set,SPECIES=wellKnownSymbol(\"species\"),PROMISE=\"Promise\",getInternalState$1=internalState.get,setInternalState$1=internalState.set,getInternalPromiseState=internalState.getterFor(PROMISE),NativePromisePrototype=nativePromiseConstructor&&nativePromiseConstructor.prototype,PromiseConstructor=nativePromiseConstructor,PromiseConstructorPrototype=NativePromisePrototype,TypeError$1=global_1.TypeError,document$1=global_1.document,process=global_1.process,newPromiseCapability=newPromiseCapability$1.f,newGenericPromiseCapability=newPromiseCapability,DISPATCH_EVENT=!!(document$1&&document$1.createEvent&&global_1.dispatchEvent),NATIVE_REJECTION_EVENT=\"function\"==typeof PromiseRejectionEvent,UNHANDLED_REJECTION=\"unhandledrejection\",REJECTION_HANDLED=\"rejectionhandled\",PENDING=0,FULFILLED=1,REJECTED=2,HANDLED=1,UNHANDLED=2,SUBCLASSING=!1,Internal,OwnPromiseCapability,PromiseWrapper,nativeThen,FORCED=isForced_1(PROMISE,(function(){var PROMISE_CONSTRUCTOR_SOURCE=inspectSource(PromiseConstructor),GLOBAL_CORE_JS_PROMISE=PROMISE_CONSTRUCTOR_SOURCE!==String(PromiseConstructor);if(!GLOBAL_CORE_JS_PROMISE&&66===engineV8Version)return!0;if(engineV8Version>=51&&/native code/.test(PROMISE_CONSTRUCTOR_SOURCE))return!1;var promise=new PromiseConstructor((function(resolve){resolve(1)})),FakePromise=function(exec){exec((function(){}),(function(){}))};return(promise.constructor={})[SPECIES]=FakePromise,!(SUBCLASSING=promise.then((function(){}))instanceof FakePromise)||!GLOBAL_CORE_JS_PROMISE&&engineIsBrowser&&!NATIVE_REJECTION_EVENT})),INCORRECT_ITERATION=FORCED||!checkCorrectnessOfIteration((function(iterable){PromiseConstructor.all(iterable).catch((function(){}))})),isThenable=function(it){var then;return!(!isObject(it)||\"function\"!=typeof(then=it.then))&&then},notify=function(state,isReject){if(!state.notified){state.notified=!0;var chain=state.reactions;microtask((function(){for(var value=state.value,ok=state.state==FULFILLED,index=0;chain.length>index;){var result,then,exited,reaction=chain[index++],handler=ok?reaction.ok:reaction.fail,resolve=reaction.resolve,reject=reaction.reject,domain=reaction.domain;try{handler?(ok||(state.rejection===UNHANDLED&&onHandleUnhandled(state),state.rejection=HANDLED),!0===handler?result=value:(domain&&domain.enter(),result=handler(value),domain&&(domain.exit(),exited=!0)),result===reaction.promise?reject(TypeError$1(\"Promise-chain cycle\")):(then=isThenable(result))?then.call(result,resolve,reject):resolve(result)):reject(value)}catch(error){domain&&!exited&&domain.exit(),reject(error)}}state.reactions=[],state.notified=!1,isReject&&!state.rejection&&onUnhandled(state)}))}},dispatchEvent=function(name,promise,reason){var event,handler;DISPATCH_EVENT?((event=document$1.createEvent(\"Event\")).promise=promise,event.reason=reason,event.initEvent(name,!1,!0),global_1.dispatchEvent(event)):event={promise:promise,reason:reason},!NATIVE_REJECTION_EVENT&&(handler=global_1[\"on\"+name])?handler(event):name===UNHANDLED_REJECTION&&hostReportErrors(\"Unhandled promise rejection\",reason)},onUnhandled=function(state){task.call(global_1,(function(){var result,promise=state.facade,value=state.value;if(isUnhandled(state)&&(result=perform((function(){engineIsNode?process.emit(\"unhandledRejection\",value,promise):dispatchEvent(UNHANDLED_REJECTION,promise,value)})),state.rejection=engineIsNode||isUnhandled(state)?UNHANDLED:HANDLED,result.error))throw result.value}))},isUnhandled=function(state){return state.rejection!==HANDLED&&!state.parent},onHandleUnhandled=function(state){task.call(global_1,(function(){var promise=state.facade;engineIsNode?process.emit(\"rejectionHandled\",promise):dispatchEvent(REJECTION_HANDLED,promise,state.value)}))},bind=function(fn,state,unwrap){return function(value){fn(state,value,unwrap)}},internalReject=function(state,value,unwrap){state.done||(state.done=!0,unwrap&&(state=unwrap),state.value=value,state.state=REJECTED,notify(state,!0))},internalResolve=function(state,value,unwrap){if(!state.done){state.done=!0,unwrap&&(state=unwrap);try{if(state.facade===value)throw TypeError$1(\"Promise can't be resolved itself\");var then=isThenable(value);then?microtask((function(){var wrapper={done:!1};try{then.call(value,bind(internalResolve,wrapper,state),bind(internalReject,wrapper,state))}catch(error){internalReject(wrapper,error,state)}})):(state.value=value,state.state=FULFILLED,notify(state,!1))}catch(error){internalReject({done:!1},error,state)}}};if(FORCED&&(PromiseConstructor=function(executor){anInstance(this,PromiseConstructor,PROMISE),aFunction(executor),Internal.call(this);var state=getInternalState$1(this);try{executor(bind(internalResolve,state),bind(internalReject,state))}catch(error){internalReject(state,error)}},PromiseConstructorPrototype=PromiseConstructor.prototype,Internal=function(executor){setInternalState$1(this,{type:PROMISE,done:!1,notified:!1,parent:!1,reactions:[],rejection:!1,state:PENDING,value:void 0})},Internal.prototype=redefineAll(PromiseConstructorPrototype,{then:function(onFulfilled,onRejected){var state=getInternalPromiseState(this),reaction=newPromiseCapability(speciesConstructor(this,PromiseConstructor));return reaction.ok=\"function\"!=typeof onFulfilled||onFulfilled,reaction.fail=\"function\"==typeof onRejected&&onRejected,reaction.domain=engineIsNode?process.domain:void 0,state.parent=!0,state.reactions.push(reaction),state.state!=PENDING&&notify(state,!1),reaction.promise},catch:function(onRejected){return this.then(void 0,onRejected)}}),OwnPromiseCapability=function(){var promise=new Internal,state=getInternalState$1(promise);this.promise=promise,this.resolve=bind(internalResolve,state),this.reject=bind(internalReject,state)},newPromiseCapability$1.f=newPromiseCapability=function(C){return C===PromiseConstructor||C===PromiseWrapper?new OwnPromiseCapability(C):newGenericPromiseCapability(C)},\"function\"==typeof nativePromiseConstructor&&NativePromisePrototype!==Object.prototype)){nativeThen=NativePromisePrototype.then,SUBCLASSING||(redefine(NativePromisePrototype,\"then\",(function(onFulfilled,onRejected){var that=this;return new PromiseConstructor((function(resolve,reject){nativeThen.call(that,resolve,reject)})).then(onFulfilled,onRejected)}),{unsafe:!0}),redefine(NativePromisePrototype,\"catch\",PromiseConstructorPrototype.catch,{unsafe:!0}));try{delete NativePromisePrototype.constructor}catch(error){}objectSetPrototypeOf&&objectSetPrototypeOf(NativePromisePrototype,PromiseConstructorPrototype)}_export({global:!0,wrap:!0,forced:FORCED},{Promise:PromiseConstructor}),setToStringTag(PromiseConstructor,PROMISE,!1),setSpecies(PROMISE),PromiseWrapper=getBuiltIn(PROMISE),_export({target:PROMISE,stat:!0,forced:FORCED},{reject:function(r){var capability=newPromiseCapability(this);return capability.reject.call(void 0,r),capability.promise}}),_export({target:PROMISE,stat:!0,forced:FORCED},{resolve:function(x){return promiseResolve(this,x)}}),_export({target:PROMISE,stat:!0,forced:INCORRECT_ITERATION},{all:function(iterable){var C=this,capability=newPromiseCapability(C),resolve=capability.resolve,reject=capability.reject,result=perform((function(){var $promiseResolve=aFunction(C.resolve),values=[],counter=0,remaining=1;iterate(iterable,(function(promise){var index=counter++,alreadyCalled=!1;values.push(void 0),remaining++,$promiseResolve.call(C,promise).then((function(value){alreadyCalled||(alreadyCalled=!0,values[index]=value,--remaining||resolve(values))}),reject)})),--remaining||resolve(values)}));return result.error&&reject(result.value),capability.promise},race:function(iterable){var C=this,capability=newPromiseCapability(C),reject=capability.reject,result=perform((function(){var $promiseResolve=aFunction(C.resolve);iterate(iterable,(function(promise){$promiseResolve.call(C,promise).then(capability.resolve,reject)}))}));return result.error&&reject(result.value),capability.promise}}),_export({target:\"Promise\",stat:!0},{allSettled:function(iterable){var C=this,capability=newPromiseCapability$1.f(C),resolve=capability.resolve,reject=capability.reject,result=perform((function(){var promiseResolve=aFunction(C.resolve),values=[],counter=0,remaining=1;iterate(iterable,(function(promise){var index=counter++,alreadyCalled=!1;values.push(void 0),remaining++,promiseResolve.call(C,promise).then((function(value){alreadyCalled||(alreadyCalled=!0,values[index]={status:\"fulfilled\",value:value},--remaining||resolve(values))}),(function(error){alreadyCalled||(alreadyCalled=!0,values[index]={status:\"rejected\",reason:error},--remaining||resolve(values))}))})),--remaining||resolve(values)}));return result.error&&reject(result.value),capability.promise}});var PROMISE_ANY_ERROR=\"No one promise resolved\";_export({target:\"Promise\",stat:!0},{any:function(iterable){var C=this,capability=newPromiseCapability$1.f(C),resolve=capability.resolve,reject=capability.reject,result=perform((function(){var promiseResolve=aFunction(C.resolve),errors=[],counter=0,remaining=1,alreadyResolved=!1;iterate(iterable,(function(promise){var index=counter++,alreadyRejected=!1;errors.push(void 0),remaining++,promiseResolve.call(C,promise).then((function(value){alreadyRejected||alreadyResolved||(alreadyResolved=!0,resolve(value))}),(function(error){alreadyRejected||alreadyResolved||(alreadyRejected=!0,errors[index]=error,--remaining||reject(new(getBuiltIn(\"AggregateError\"))(errors,PROMISE_ANY_ERROR)))}))})),--remaining||reject(new(getBuiltIn(\"AggregateError\"))(errors,PROMISE_ANY_ERROR))}));return result.error&&reject(result.value),capability.promise}});var NON_GENERIC=!!nativePromiseConstructor&&fails((function(){nativePromiseConstructor.prototype.finally.call({then:function(){}},(function(){}))}));if(_export({target:\"Promise\",proto:!0,real:!0,forced:NON_GENERIC},{finally:function(onFinally){var C=speciesConstructor(this,getBuiltIn(\"Promise\")),isFunction=\"function\"==typeof onFinally;return this.then(isFunction?function(x){return promiseResolve(C,onFinally()).then((function(){return x}))}:onFinally,isFunction?function(e){return promiseResolve(C,onFinally()).then((function(){throw e}))}:onFinally)}}),\"function\"==typeof nativePromiseConstructor){var method=getBuiltIn(\"Promise\").prototype.finally;nativePromiseConstructor.prototype.finally!==method&&redefine(nativePromiseConstructor.prototype,\"finally\",method,{unsafe:!0})}var domIterables={CSSRuleList:0,CSSStyleDeclaration:0,CSSValueList:0,ClientRectList:0,DOMRectList:0,DOMStringList:0,DOMTokenList:1,DataTransferItemList:0,FileList:0,HTMLAllCollection:0,HTMLCollection:0,HTMLFormElement:0,HTMLSelectElement:0,MediaList:0,MimeTypeArray:0,NamedNodeMap:0,NodeList:1,PaintRequestList:0,Plugin:0,PluginArray:0,SVGLengthList:0,SVGNumberList:0,SVGPathSegList:0,SVGPointList:0,SVGStringList:0,SVGTransformList:0,SourceBufferList:0,StyleSheetList:0,TextTrackCueList:0,TextTrackList:0,TouchList:0},ARRAY_ITERATOR=\"Array Iterator\",setInternalState=internalState.set,getInternalState=internalState.getterFor(ARRAY_ITERATOR),es_array_iterator=defineIterator(Array,\"Array\",(function(iterated,kind){setInternalState(this,{type:ARRAY_ITERATOR,target:toIndexedObject(iterated),index:0,kind:kind})}),(function(){var state=getInternalState(this),target=state.target,kind=state.kind,index=state.index++;return!target||index>=target.length?(state.target=void 0,{value:void 0,done:!0}):\"keys\"==kind?{value:index,done:!1}:\"values\"==kind?{value:target[index],done:!1}:{value:[index,target[index]],done:!1}}),\"values\");iterators.Arguments=iterators.Array,addToUnscopables(\"keys\"),addToUnscopables(\"values\"),addToUnscopables(\"entries\");var ITERATOR=wellKnownSymbol(\"iterator\"),TO_STRING_TAG=wellKnownSymbol(\"toStringTag\"),ArrayValues=es_array_iterator.values;for(var COLLECTION_NAME in domIterables){var Collection=global_1[COLLECTION_NAME],CollectionPrototype=Collection&&Collection.prototype;if(CollectionPrototype){if(CollectionPrototype[ITERATOR]!==ArrayValues)try{createNonEnumerableProperty(CollectionPrototype,ITERATOR,ArrayValues)}catch(error){CollectionPrototype[ITERATOR]=ArrayValues}if(CollectionPrototype[TO_STRING_TAG]||createNonEnumerableProperty(CollectionPrototype,TO_STRING_TAG,COLLECTION_NAME),domIterables[COLLECTION_NAME])for(var METHOD_NAME in es_array_iterator)if(CollectionPrototype[METHOD_NAME]!==es_array_iterator[METHOD_NAME])try{createNonEnumerableProperty(CollectionPrototype,METHOD_NAME,es_array_iterator[METHOD_NAME])}catch(error){CollectionPrototype[METHOD_NAME]=es_array_iterator[METHOD_NAME]}}}path.Promise,_export({target:\"Promise\",stat:!0},{try:function(callbackfn){var promiseCapability=newPromiseCapability$1.f(this),result=perform(callbackfn);return(result.error?promiseCapability.reject:promiseCapability.resolve)(result.value),promiseCapability.promise}});var MATCH$1=wellKnownSymbol(\"match\"),isRegexp=function(it){var isRegExp;return isObject(it)&&(void 0!==(isRegExp=it[MATCH$1])?!!isRegExp:\"RegExp\"==classofRaw(it))},notARegexp=function(it){if(isRegexp(it))throw TypeError(\"The method doesn't accept regular expressions\");return it},MATCH=wellKnownSymbol(\"match\"),correctIsRegexpLogic=function(METHOD_NAME){var regexp=/./;try{\"/./\"[METHOD_NAME](regexp)}catch(error1){try{return regexp[MATCH]=!1,\"/./\"[METHOD_NAME](regexp)}catch(error2){}}return!1},getOwnPropertyDescriptor=objectGetOwnPropertyDescriptor.f,$startsWith=\"\".startsWith,min=Math.min,CORRECT_IS_REGEXP_LOGIC=correctIsRegexpLogic(\"startsWith\"),MDN_POLYFILL_BUG=!(CORRECT_IS_REGEXP_LOGIC||(descriptor=getOwnPropertyDescriptor(String.prototype,\"startsWith\"),!descriptor||descriptor.writable)),descriptor;_export({target:\"String\",proto:!0,forced:!MDN_POLYFILL_BUG&&!CORRECT_IS_REGEXP_LOGIC},{startsWith:function(searchString){var that=String(requireObjectCoercible(this));notARegexp(searchString);var index=toLength(min(arguments.length>1?arguments[1]:void 0,that.length)),search=String(searchString);return $startsWith?$startsWith.call(that,search,index):that.slice(index,index+search.length)===search}}),entryUnbind(\"String\",\"startsWith\");var global$1=\"undefined\"!=typeof globalThis&&globalThis||\"undefined\"!=typeof self&&self||void 0!==global$1&&global$1,support={searchParams:\"URLSearchParams\"in global$1,iterable:\"Symbol\"in global$1&&\"iterator\"in Symbol,blob:\"FileReader\"in global$1&&\"Blob\"in global$1&&function(){try{return new Blob,!0}catch(e){return!1}}(),formData:\"FormData\"in global$1,arrayBuffer:\"ArrayBuffer\"in global$1};function isDataView(obj){return obj&&DataView.prototype.isPrototypeOf(obj)}if(support.arrayBuffer)var viewClasses=[\"[object Int8Array]\",\"[object Uint8Array]\",\"[object Uint8ClampedArray]\",\"[object Int16Array]\",\"[object Uint16Array]\",\"[object Int32Array]\",\"[object Uint32Array]\",\"[object Float32Array]\",\"[object Float64Array]\"],isArrayBufferView=ArrayBuffer.isView||function(obj){return obj&&viewClasses.indexOf(Object.prototype.toString.call(obj))>-1};function normalizeName(name){if(\"string\"!=typeof name&&(name=String(name)),/[^a-z0-9\\-#$%&'*+.^_`|~!]/i.test(name)||\"\"===name)throw new TypeError('Invalid character in header field name: \"'+name+'\"');return name.toLowerCase()}function normalizeValue(value){return\"string\"!=typeof value&&(value=String(value)),value}function iteratorFor(items){var iterator={next:function(){var value=items.shift();return{done:void 0===value,value:value}}};return support.iterable&&(iterator[Symbol.iterator]=function(){return iterator}),iterator}function Headers(headers){this.map={},headers instanceof Headers?headers.forEach((function(value,name){this.append(name,value)}),this):Array.isArray(headers)?headers.forEach((function(header){this.append(header[0],header[1])}),this):headers&&Object.getOwnPropertyNames(headers).forEach((function(name){this.append(name,headers[name])}),this)}function consumed(body){if(body.bodyUsed)return Promise.reject(new TypeError(\"Already read\"));body.bodyUsed=!0}function fileReaderReady(reader){return new Promise((function(resolve,reject){reader.onload=function(){resolve(reader.result)},reader.onerror=function(){reject(reader.error)}}))}function readBlobAsArrayBuffer(blob){var reader=new FileReader,promise=fileReaderReady(reader);return reader.readAsArrayBuffer(blob),promise}function readBlobAsText(blob){var reader=new FileReader,promise=fileReaderReady(reader);return reader.readAsText(blob),promise}function readArrayBufferAsText(buf){for(var view=new Uint8Array(buf),chars=new Array(view.length),i=0;i<view.length;i++)chars[i]=String.fromCharCode(view[i]);return chars.join(\"\")}function bufferClone(buf){if(buf.slice)return buf.slice(0);var view=new Uint8Array(buf.byteLength);return view.set(new Uint8Array(buf)),view.buffer}function Body(){return this.bodyUsed=!1,this._initBody=function(body){this.bodyUsed=this.bodyUsed,this._bodyInit=body,body?\"string\"==typeof body?this._bodyText=body:support.blob&&Blob.prototype.isPrototypeOf(body)?this._bodyBlob=body:support.formData&&FormData.prototype.isPrototypeOf(body)?this._bodyFormData=body:support.searchParams&&URLSearchParams.prototype.isPrototypeOf(body)?this._bodyText=body.toString():support.arrayBuffer&&support.blob&&isDataView(body)?(this._bodyArrayBuffer=bufferClone(body.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer])):support.arrayBuffer&&(ArrayBuffer.prototype.isPrototypeOf(body)||isArrayBufferView(body))?this._bodyArrayBuffer=bufferClone(body):this._bodyText=body=Object.prototype.toString.call(body):this._bodyText=\"\",this.headers.get(\"content-type\")||(\"string\"==typeof body?this.headers.set(\"content-type\",\"text/plain;charset=UTF-8\"):this._bodyBlob&&this._bodyBlob.type?this.headers.set(\"content-type\",this._bodyBlob.type):support.searchParams&&URLSearchParams.prototype.isPrototypeOf(body)&&this.headers.set(\"content-type\",\"application/x-www-form-urlencoded;charset=UTF-8\"))},support.blob&&(this.blob=function(){var rejected=consumed(this);if(rejected)return rejected;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error(\"could not read FormData body as blob\");return Promise.resolve(new Blob([this._bodyText]))},this.arrayBuffer=function(){if(this._bodyArrayBuffer){var isConsumed=consumed(this);return isConsumed||(ArrayBuffer.isView(this._bodyArrayBuffer)?Promise.resolve(this._bodyArrayBuffer.buffer.slice(this._bodyArrayBuffer.byteOffset,this._bodyArrayBuffer.byteOffset+this._bodyArrayBuffer.byteLength)):Promise.resolve(this._bodyArrayBuffer))}return this.blob().then(readBlobAsArrayBuffer)}),this.text=function(){var rejected=consumed(this);if(rejected)return rejected;if(this._bodyBlob)return readBlobAsText(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(readArrayBufferAsText(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error(\"could not read FormData body as text\");return Promise.resolve(this._bodyText)},support.formData&&(this.formData=function(){return this.text().then(decode)}),this.json=function(){return this.text().then(JSON.parse)},this}Headers.prototype.append=function(name,value){name=normalizeName(name),value=normalizeValue(value);var oldValue=this.map[name];this.map[name]=oldValue?oldValue+\", \"+value:value},Headers.prototype.delete=function(name){delete this.map[normalizeName(name)]},Headers.prototype.get=function(name){return name=normalizeName(name),this.has(name)?this.map[name]:null},Headers.prototype.has=function(name){return this.map.hasOwnProperty(normalizeName(name))},Headers.prototype.set=function(name,value){this.map[normalizeName(name)]=normalizeValue(value)},Headers.prototype.forEach=function(callback,thisArg){for(var name in this.map)this.map.hasOwnProperty(name)&&callback.call(thisArg,this.map[name],name,this)},Headers.prototype.keys=function(){var items=[];return this.forEach((function(value,name){items.push(name)})),iteratorFor(items)},Headers.prototype.values=function(){var items=[];return this.forEach((function(value){items.push(value)})),iteratorFor(items)},Headers.prototype.entries=function(){var items=[];return this.forEach((function(value,name){items.push([name,value])})),iteratorFor(items)},support.iterable&&(Headers.prototype[Symbol.iterator]=Headers.prototype.entries);var methods=[\"DELETE\",\"GET\",\"HEAD\",\"OPTIONS\",\"POST\",\"PUT\"];function normalizeMethod(method){var upcased=method.toUpperCase();return methods.indexOf(upcased)>-1?upcased:method}function Request(input,options){if(!(this instanceof Request))throw new TypeError('Please use the \"new\" operator, this DOM object constructor cannot be called as a function.');var body=(options=options||{}).body;if(input instanceof Request){if(input.bodyUsed)throw new TypeError(\"Already read\");this.url=input.url,this.credentials=input.credentials,options.headers||(this.headers=new Headers(input.headers)),this.method=input.method,this.mode=input.mode,this.signal=input.signal,body||null==input._bodyInit||(body=input._bodyInit,input.bodyUsed=!0)}else this.url=String(input);if(this.credentials=options.credentials||this.credentials||\"same-origin\",!options.headers&&this.headers||(this.headers=new Headers(options.headers)),this.method=normalizeMethod(options.method||this.method||\"GET\"),this.mode=options.mode||this.mode||null,this.signal=options.signal||this.signal,this.referrer=null,(\"GET\"===this.method||\"HEAD\"===this.method)&&body)throw new TypeError(\"Body not allowed for GET or HEAD requests\");if(this._initBody(body),!(\"GET\"!==this.method&&\"HEAD\"!==this.method||\"no-store\"!==options.cache&&\"no-cache\"!==options.cache)){var reParamSearch=/([?&])_=[^&]*/;if(reParamSearch.test(this.url))this.url=this.url.replace(reParamSearch,\"$1_=\"+(new Date).getTime());else{this.url+=(/\\?/.test(this.url)?\"&\":\"?\")+\"_=\"+(new Date).getTime()}}}function decode(body){var form=new FormData;return body.trim().split(\"&\").forEach((function(bytes){if(bytes){var split=bytes.split(\"=\"),name=split.shift().replace(/\\+/g,\" \"),value=split.join(\"=\").replace(/\\+/g,\" \");form.append(decodeURIComponent(name),decodeURIComponent(value))}})),form}function parseHeaders(rawHeaders){var headers=new Headers;return rawHeaders.replace(/\\r?\\n[\\t ]+/g,\" \").split(\"\\r\").map((function(header){return 0===header.indexOf(\"\\n\")?header.substr(1,header.length):header})).forEach((function(line){var parts=line.split(\":\"),key=parts.shift().trim();if(key){var value=parts.join(\":\").trim();headers.append(key,value)}})),headers}function Response(bodyInit,options){if(!(this instanceof Response))throw new TypeError('Please use the \"new\" operator, this DOM object constructor cannot be called as a function.');options||(options={}),this.type=\"default\",this.status=void 0===options.status?200:options.status,this.ok=this.status>=200&&this.status<300,this.statusText=void 0===options.statusText?\"\":\"\"+options.statusText,this.headers=new Headers(options.headers),this.url=options.url||\"\",this._initBody(bodyInit)}Request.prototype.clone=function(){return new Request(this,{body:this._bodyInit})},Body.call(Request.prototype),Body.call(Response.prototype),Response.prototype.clone=function(){return new Response(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new Headers(this.headers),url:this.url})},Response.error=function(){var response=new Response(null,{status:0,statusText:\"\"});return response.type=\"error\",response};var redirectStatuses=[301,302,303,307,308];Response.redirect=function(url,status){if(-1===redirectStatuses.indexOf(status))throw new RangeError(\"Invalid status code\");return new Response(null,{status:status,headers:{location:url}})};var DOMException=global$1.DOMException;try{new DOMException}catch(err){DOMException=function(message,name){this.message=message,this.name=name;var error=Error(message);this.stack=error.stack},DOMException.prototype=Object.create(Error.prototype),DOMException.prototype.constructor=DOMException}function fetch$1(input,init){return new Promise((function(resolve,reject){var request=new Request(input,init);if(request.signal&&request.signal.aborted)return reject(new DOMException(\"Aborted\",\"AbortError\"));var xhr=new XMLHttpRequest;function abortXhr(){xhr.abort()}xhr.onload=function(){var options={status:xhr.status,statusText:xhr.statusText,headers:parseHeaders(xhr.getAllResponseHeaders()||\"\")};options.url=\"responseURL\"in xhr?xhr.responseURL:options.headers.get(\"X-Request-URL\");var body=\"response\"in xhr?xhr.response:xhr.responseText;setTimeout((function(){resolve(new Response(body,options))}),0)},xhr.onerror=function(){setTimeout((function(){reject(new TypeError(\"Network request failed\"))}),0)},xhr.ontimeout=function(){setTimeout((function(){reject(new TypeError(\"Network request failed\"))}),0)},xhr.onabort=function(){setTimeout((function(){reject(new DOMException(\"Aborted\",\"AbortError\"))}),0)},xhr.open(request.method,function(url){try{return\"\"===url&&global$1.location.href?global$1.location.href:url}catch(e){return url}}(request.url),!0),\"include\"===request.credentials?xhr.withCredentials=!0:\"omit\"===request.credentials&&(xhr.withCredentials=!1),\"responseType\"in xhr&&(support.blob?xhr.responseType=\"blob\":support.arrayBuffer&&request.headers.get(\"Content-Type\")&&-1!==request.headers.get(\"Content-Type\").indexOf(\"application/octet-stream\")&&(xhr.responseType=\"arraybuffer\")),!init||\"object\"!=typeof init.headers||init.headers instanceof Headers?request.headers.forEach((function(value,name){xhr.setRequestHeader(name,value)})):Object.getOwnPropertyNames(init.headers).forEach((function(name){xhr.setRequestHeader(name,normalizeValue(init.headers[name]))})),request.signal&&(request.signal.addEventListener(\"abort\",abortXhr),xhr.onreadystatechange=function(){4===xhr.readyState&&request.signal.removeEventListener(\"abort\",abortXhr)}),xhr.send(void 0===request._bodyInit?null:request._bodyInit)}))}fetch$1.polyfill=!0,global$1.fetch||(global$1.fetch=fetch$1,global$1.Headers=Headers,global$1.Request=Request,global$1.Response=Response),null==Element.prototype.getAttributeNames&&(Element.prototype.getAttributeNames=function(){for(var attributes=this.attributes,length=attributes.length,result=new Array(length),i=0;i<length;i++)result[i]=attributes[i].name;return result}),Element.prototype.matches||(Element.prototype.matches=Element.prototype.matchesSelector||Element.prototype.mozMatchesSelector||Element.prototype.msMatchesSelector||Element.prototype.oMatchesSelector||Element.prototype.webkitMatchesSelector||function(s){for(var matches=(this.document||this.ownerDocument).querySelectorAll(s),i=matches.length;--i>=0&&matches.item(i)!==this;);return i>-1}),Element.prototype.matches||(Element.prototype.matches=Element.prototype.msMatchesSelector||Element.prototype.webkitMatchesSelector),Element.prototype.closest||(Element.prototype.closest=function(s){var el=this;do{if(el.matches(s))return el;el=el.parentElement||el.parentNode}while(null!==el&&1===el.nodeType);return null});var Connection=function(){function Connection(){_classCallCheck(this,Connection),this.headers={}}return _createClass(Connection,[{key:\"onMessage\",value:function(message,payload){message.component.receiveMessage(message,payload)}},{key:\"onError\",value:function(message,status,response){return message.component.messageSendFailed(),store$2.onErrorCallback(status,response)}},{key:\"showExpiredMessage\",value:function(response,message){store$2.sessionHasExpiredCallback?store$2.sessionHasExpiredCallback(response,message):confirm(\"This page has expired.\\nWould you like to refresh the page?\")&&window.location.reload()}},{key:\"sendMessage\",value:function(message){var _this=this,payload=message.payload(),csrfToken=getCsrfToken(),socketId=this.getSocketId();if(window.__testing_request_interceptor)return window.__testing_request_interceptor(payload,this);fetch(\"\".concat(window.livewire_app_url,\"/livewire/message/\").concat(payload.fingerprint.name),{method:\"POST\",body:JSON.stringify(payload),credentials:\"same-origin\",headers:_objectSpread2(_objectSpread2(_objectSpread2({\"Content-Type\":\"application/json\",Accept:\"text/html, application/xhtml+xml\",\"X-Livewire\":!0},this.headers),{},{Referer:window.location.href},csrfToken&&{\"X-CSRF-TOKEN\":csrfToken}),socketId&&{\"X-Socket-ID\":socketId})}).then((function(response){if(response.ok)response.text().then((function(response){_this.isOutputFromDump(response)?(_this.onError(message),_this.showHtmlModal(response)):_this.onMessage(message,JSON.parse(response))}));else{if(!1===_this.onError(message,response.status,response))return;if(419===response.status){if(store$2.sessionHasExpired)return;store$2.sessionHasExpired=!0,_this.showExpiredMessage(response,message)}else response.text().then((function(response){_this.showHtmlModal(response)}))}})).catch((function(){_this.onError(message)}))}},{key:\"isOutputFromDump\",value:function(output){return!!output.match(/<script>Sfdump\\(\".+\"\\)<\\/script>/)}},{key:\"getSocketId\",value:function(){if(\"undefined\"!=typeof Echo)return Echo.socketId()}},{key:\"showHtmlModal\",value:function(html){var _this2=this,page=document.createElement(\"html\");page.innerHTML=html,page.querySelectorAll(\"a\").forEach((function(a){return a.setAttribute(\"target\",\"_top\")}));var modal=document.getElementById(\"livewire-error\");void 0!==modal&&null!=modal?modal.innerHTML=\"\":((modal=document.createElement(\"div\")).id=\"livewire-error\",modal.style.position=\"fixed\",modal.style.width=\"100vw\",modal.style.height=\"100vh\",modal.style.padding=\"50px\",modal.style.backgroundColor=\"rgba(0, 0, 0, .6)\",modal.style.zIndex=2e5);var iframe=document.createElement(\"iframe\");iframe.style.backgroundColor=\"#17161A\",iframe.style.borderRadius=\"5px\",iframe.style.width=\"100%\",iframe.style.height=\"100%\",modal.appendChild(iframe),document.body.prepend(modal),document.body.style.overflow=\"hidden\",iframe.contentWindow.document.open(),iframe.contentWindow.document.write(page.outerHTML),iframe.contentWindow.document.close(),modal.addEventListener(\"click\",(function(){return _this2.hideHtmlModal(modal)})),modal.setAttribute(\"tabindex\",0),modal.addEventListener(\"keydown\",(function(e){\"Escape\"===e.key&&_this2.hideHtmlModal(modal)})),modal.focus()}},{key:\"hideHtmlModal\",value:function(modal){modal.outerHTML=\"\",document.body.style.overflow=\"visible\"}}]),Connection}(),_default$4=function(_Action){_inherits(_default,_Action);var _super=_createSuper(_default);function _default(method,params,el){var _this,skipWatcher=arguments.length>3&&void 0!==arguments[3]&&arguments[3];return _classCallCheck(this,_default),(_this=_super.call(this,el,skipWatcher)).type=\"callMethod\",_this.method=method,_this.payload={id:_this.signature,method:method,params:params},_this}return _default}(_default$6);function Polling(){store$2.registerHook(\"element.initialized\",(function(el,component){if(!wireDirectives(el).missing(\"poll\")){var intervalId=fireActionOnInterval(el,component);component.addListenerForTeardown((function(){clearInterval(intervalId)})),el.__livewire_polling_interval=intervalId}})),store$2.registerHook(\"element.updating\",(function(from,to,component){void 0===from.__livewire_polling_interval&&wireDirectives(from).missing(\"poll\")&&wireDirectives(to).has(\"poll\")&&setTimeout((function(){var intervalId=fireActionOnInterval(from,component);component.addListenerForTeardown((function(){clearInterval(intervalId)})),from.__livewire_polling_interval=intervalId}),0)}))}function fireActionOnInterval(node,component){var interval=wireDirectives(node).get(\"poll\").durationOr(2e3);return setInterval((function(){if(!1!==node.isConnected){var directives=wireDirectives(node);if(!directives.missing(\"poll\")){var directive=directives.get(\"poll\"),method=directive.method||\"$refresh\";store$2.livewireIsInBackground&&!directive.modifiers.includes(\"keep-alive\")&&Math.random()<.95||directive.modifiers.includes(\"visible\")&&!inViewport(directive.el)||store$2.livewireIsOffline||component.addAction(new _default$4(method,directive.params,node))}}}),interval)}function inViewport(el){var bounding=el.getBoundingClientRect();return bounding.top<(window.innerHeight||document.documentElement.clientHeight)&&bounding.left<(window.innerWidth||document.documentElement.clientWidth)&&bounding.bottom>0&&bounding.right>0}var _default$3=function(){function _default(component,updateQueue){_classCallCheck(this,_default),this.component=component,this.updateQueue=updateQueue}return _createClass(_default,[{key:\"payload\",value:function(){return{fingerprint:this.component.fingerprint,serverMemo:this.component.serverMemo,updates:this.updateQueue.map((function(update){return{type:update.type,payload:update.payload}}))}}},{key:\"shouldSkipWatcherForDataKey\",value:function(dataKey){if(this.response.effects.dirty.includes(dataKey))return!1;return this.updateQueue.filter((function(update){return subject=update.name,value=dataKey,\"string\"==typeof subject&&\"string\"==typeof value&&subject.split(\".\")[0]===value.split(\".\")[0];var subject,value})).some((function(update){return update.skipWatcher}))}},{key:\"storeResponse\",value:function(payload){return this.response=payload}},{key:\"resolve\",value:function(){var returns=this.response.effects.returns||[];this.updateQueue.forEach((function(update){\"callMethod\"===update.type&&update.resolve(void 0!==returns[update.signature]?returns[update.signature]:void 0!==returns[update.method]?returns[update.method]:null)}))}},{key:\"reject\",value:function(){this.updateQueue.forEach((function(update){update.reject()}))}}]),_default}(),_default$2=function(_Message){_inherits(_default,_Message);var _super=_createSuper(_default);function _default(component,action){return _classCallCheck(this,_default),_super.call(this,component,[action])}return _createClass(_default,[{key:\"prefetchId\",get:function(){return this.updateQueue[0].toId()}}]),_default}(_default$3);function morphAttrs(fromNode,toNode){if((void 0===fromNode._x_isShown||void 0===toNode._x_isShown)&&(!fromNode._x_isShown||toNode._x_isShown)&&(fromNode._x_isShown||!toNode._x_isShown)){var i,attr,attrName,attrNamespaceURI,attrValue,attrs=toNode.attributes;for(i=attrs.length-1;i>=0;--i)attrName=(attr=attrs[i]).name,attrNamespaceURI=attr.namespaceURI,attrValue=attr.value,attrNamespaceURI?(attrName=attr.localName||attrName,fromNode.getAttributeNS(attrNamespaceURI,attrName)!==attrValue&&(\"xmlns\"===attr.prefix&&(attrName=attr.name),fromNode.setAttributeNS(attrNamespaceURI,attrName,attrValue))):fromNode.getAttribute(attrName)!==attrValue&&fromNode.setAttribute(attrName,attrValue);for(i=(attrs=fromNode.attributes).length-1;i>=0;--i)!1!==(attr=attrs[i]).specified&&(attrName=attr.name,(attrNamespaceURI=attr.namespaceURI)?(attrName=attr.localName||attrName,toNode.hasAttributeNS(attrNamespaceURI,attrName)||fromNode.removeAttributeNS(attrNamespaceURI,attrName)):toNode.hasAttribute(attrName)||fromNode.removeAttribute(attrName))}}function syncBooleanAttrProp(fromEl,toEl,name){fromEl[name]!==toEl[name]&&(fromEl[name]=toEl[name],fromEl[name]?fromEl.setAttribute(name,\"\"):fromEl.removeAttribute(name))}var specialElHandlers={OPTION:function(fromEl,toEl){var parentNode=fromEl.parentNode;if(parentNode){var parentName=parentNode.nodeName.toUpperCase();\"OPTGROUP\"===parentName&&(parentName=(parentNode=parentNode.parentNode)&&parentNode.nodeName.toUpperCase()),\"SELECT\"!==parentName||parentNode.hasAttribute(\"multiple\")||(fromEl.hasAttribute(\"selected\")&&!toEl.selected&&(fromEl.setAttribute(\"selected\",\"selected\"),fromEl.removeAttribute(\"selected\")),parentNode.selectedIndex=-1)}syncBooleanAttrProp(fromEl,toEl,\"selected\")},INPUT:function(fromEl,toEl){syncBooleanAttrProp(fromEl,toEl,\"checked\"),syncBooleanAttrProp(fromEl,toEl,\"disabled\"),fromEl.value!==toEl.value&&(fromEl.value=toEl.value),toEl.hasAttribute(\"value\")||fromEl.removeAttribute(\"value\")},TEXTAREA:function(fromEl,toEl){var newValue=toEl.value;fromEl.value!==newValue&&(fromEl.value=newValue);var firstChild=fromEl.firstChild;if(firstChild){var oldValue=firstChild.nodeValue;if(oldValue==newValue||!newValue&&oldValue==fromEl.placeholder)return;firstChild.nodeValue=newValue}},SELECT:function(fromEl,toEl){if(!toEl.hasAttribute(\"multiple\")){for(var optgroup,nodeName,selectedIndex=-1,i=0,curChild=fromEl.firstChild;curChild;)if(\"OPTGROUP\"===(nodeName=curChild.nodeName&&curChild.nodeName.toUpperCase()))curChild=(optgroup=curChild).firstChild;else{if(\"OPTION\"===nodeName){if(curChild.hasAttribute(\"selected\")){selectedIndex=i;break}i++}!(curChild=curChild.nextSibling)&&optgroup&&(curChild=optgroup.nextSibling,optgroup=null)}fromEl.selectedIndex=selectedIndex}}},range,NS_XHTML=\"http://www.w3.org/1999/xhtml\",doc=\"undefined\"==typeof document?void 0:document,HAS_TEMPLATE_SUPPORT=!!doc&&\"content\"in doc.createElement(\"template\"),HAS_RANGE_SUPPORT=!!doc&&doc.createRange&&\"createContextualFragment\"in doc.createRange();function createFragmentFromTemplate(str){var template=doc.createElement(\"template\");return template.innerHTML=str,template.content.childNodes[0]}function createFragmentFromRange(str){return range||(range=doc.createRange()).selectNode(doc.body),range.createContextualFragment(str).childNodes[0]}function createFragmentFromWrap(str){var fragment=doc.createElement(\"body\");return fragment.innerHTML=str,fragment.childNodes[0]}function toElement(str){return str=str.trim(),HAS_TEMPLATE_SUPPORT?createFragmentFromTemplate(str):HAS_RANGE_SUPPORT?createFragmentFromRange(str):createFragmentFromWrap(str)}function compareNodeNames(fromEl,toEl){var fromNodeName=fromEl.nodeName,toNodeName=toEl.nodeName;return fromNodeName===toNodeName||!!(toEl.actualize&&fromNodeName.charCodeAt(0)<91&&toNodeName.charCodeAt(0)>90)&&fromNodeName===toNodeName.toUpperCase()}function createElementNS(name,namespaceURI){return namespaceURI&&namespaceURI!==NS_XHTML?doc.createElementNS(namespaceURI,name):doc.createElement(name)}function moveChildren(fromEl,toEl){for(var curChild=fromEl.firstChild;curChild;){var nextChild=curChild.nextSibling;toEl.appendChild(curChild),curChild=nextChild}return toEl}var ELEMENT_NODE=1,DOCUMENT_FRAGMENT_NODE=11,TEXT_NODE=3,COMMENT_NODE=8;function noop(){}function defaultGetNodeKey(node){return node.id}function callHook(hook){\"getNodeKey\"!==hook.name&&hook.name;for(var _len=arguments.length,params=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++)params[_key-1]=arguments[_key];if(\"function\"==typeof params[0].hasAttribute)return hook.apply(void 0,params)}function morphdomFactory(morphAttrs){return function(fromNode,toNode,options){if(options||(options={}),\"string\"==typeof toNode)if(\"#document\"===fromNode.nodeName||\"HTML\"===fromNode.nodeName){var toNodeHtml=toNode;(toNode=doc.createElement(\"html\")).innerHTML=toNodeHtml}else toNode=toElement(toNode);var getNodeKey=options.getNodeKey||defaultGetNodeKey,onBeforeNodeAdded=options.onBeforeNodeAdded||noop,onNodeAdded=options.onNodeAdded||noop,onBeforeElUpdated=options.onBeforeElUpdated||noop,onElUpdated=options.onElUpdated||noop,onBeforeNodeDiscarded=options.onBeforeNodeDiscarded||noop,onNodeDiscarded=options.onNodeDiscarded||noop,onBeforeElChildrenUpdated=options.onBeforeElChildrenUpdated||noop,childrenOnly=!0===options.childrenOnly,fromNodesLookup=Object.create(null),keyedRemovalList=[];function addKeyedRemoval(key){keyedRemovalList.push(key)}function walkDiscardedChildNodes(node,skipKeyedNodes){if(node.nodeType===ELEMENT_NODE)for(var curChild=node.firstChild;curChild;){var key=void 0;skipKeyedNodes&&(key=callHook(getNodeKey,curChild))?addKeyedRemoval(key):(callHook(onNodeDiscarded,curChild),curChild.firstChild&&walkDiscardedChildNodes(curChild,skipKeyedNodes)),curChild=curChild.nextSibling}}function removeNode(node,parentNode,skipKeyedNodes){!1!==callHook(onBeforeNodeDiscarded,node)&&(parentNode&&parentNode.removeChild(node),callHook(onNodeDiscarded,node),walkDiscardedChildNodes(node,skipKeyedNodes))}function handleNodeAdded(el){if(callHook(onNodeAdded,el),!el.skipAddingChildren)for(var curChild=el.firstChild;curChild;){var nextSibling=curChild.nextSibling,key=callHook(getNodeKey,curChild);if(key){var unmatchedFromEl=fromNodesLookup[key];unmatchedFromEl&&compareNodeNames(curChild,unmatchedFromEl)?(curChild.parentNode.replaceChild(unmatchedFromEl,curChild),morphEl(unmatchedFromEl,curChild)):handleNodeAdded(curChild)}else handleNodeAdded(curChild);curChild=nextSibling}}function morphEl(fromEl,toEl,childrenOnly){var toElKey=callHook(getNodeKey,toEl);if(toElKey&&delete fromNodesLookup[toElKey],!childrenOnly){if(!1===callHook(onBeforeElUpdated,fromEl,toEl))return;if(fromEl.skipElUpdatingButStillUpdateChildren||morphAttrs(fromEl,toEl),callHook(onElUpdated,fromEl),!1===callHook(onBeforeElChildrenUpdated,fromEl,toEl))return}\"TEXTAREA\"!==fromEl.nodeName?function(fromEl,toEl){var curToNodeKey,curFromNodeKey,fromNextSibling,toNextSibling,matchingFromEl,curToNodeChild=toEl.firstChild,curFromNodeChild=fromEl.firstChild;outer:for(;curToNodeChild;){for(toNextSibling=curToNodeChild.nextSibling,curToNodeKey=callHook(getNodeKey,curToNodeChild);curFromNodeChild;){if(fromNextSibling=curFromNodeChild.nextSibling,curToNodeChild.isSameNode&&curToNodeChild.isSameNode(curFromNodeChild)){curToNodeChild=toNextSibling,curFromNodeChild=fromNextSibling;continue outer}curFromNodeKey=callHook(getNodeKey,curFromNodeChild);var curFromNodeType=curFromNodeChild.nodeType,isCompatible=void 0;if(curFromNodeType===curToNodeChild.nodeType&&(curFromNodeType===ELEMENT_NODE?(curToNodeKey?curToNodeKey!==curFromNodeKey&&((matchingFromEl=fromNodesLookup[curToNodeKey])?fromNextSibling===matchingFromEl?isCompatible=!1:(fromEl.insertBefore(matchingFromEl,curFromNodeChild),curFromNodeKey?addKeyedRemoval(curFromNodeKey):removeNode(curFromNodeChild,fromEl,!0),curFromNodeChild=matchingFromEl):isCompatible=!1):curFromNodeKey&&(isCompatible=!1),(isCompatible=!1!==isCompatible&&compareNodeNames(curFromNodeChild,curToNodeChild))&&(!curToNodeChild.isEqualNode(curFromNodeChild)&&curToNodeChild.nextElementSibling&&curToNodeChild.nextElementSibling.isEqualNode(curFromNodeChild)?isCompatible=!1:morphEl(curFromNodeChild,curToNodeChild))):curFromNodeType!==TEXT_NODE&&curFromNodeType!=COMMENT_NODE||(isCompatible=!0,curFromNodeChild.nodeValue!==curToNodeChild.nodeValue&&(curFromNodeChild.nodeValue=curToNodeChild.nodeValue))),isCompatible){curToNodeChild=toNextSibling,curFromNodeChild=fromNextSibling;continue outer}if(curToNodeChild.nextElementSibling&&curToNod