require.config({"config": {
        "jsbuild":{"Magento_Catalog/js/product/uenc-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n        'use strict';\n\n        /**\n         * Check data to JSON.\n         *\n         * @returns {Boolean}\n         */\n        function _isJSON(data) {\n            try {\n                JSON.parse(data);\n            } catch (e) {\n                return false;\n            }\n\n            return true;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _stringProcessor(data, placeholder, uenc) {\n            if (data && ~data.indexOf(placeholder)) {\n                return data.replace(placeholder, uenc);\n            }\n\n            return data;\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         * @param {String} uenc\n         *\n         * @returns {String}\n         */\n        function _objectProcessor(data, placeholder, uenc) {\n            data = JSON.parse(data);\n\n            if (data.hasOwnProperty('action')) {\n                data.action = _stringProcessor(data.action, placeholder, uenc);\n            }\n\n            if (data.hasOwnProperty('data') && data.data.hasOwnProperty('uenc')) {\n                data.data.uenc = uenc;\n            }\n\n            return JSON.stringify(data);\n        }\n\n        /**\n         * Processes data.\n         *\n         * @param {Object} data\n         * @param {String} placeholder\n         *\n         * @returns {String}\n         */\n        return function (data, placeholder) {\n            var uenc = btoa(window.location.href).replace('+/=', '-_,');\n\n            placeholder = placeholder || encodeURI('%uenc%');\n\n            return _isJSON(data) ?\n                _objectProcessor(data, placeholder, uenc) :\n                _stringProcessor(data, placeholder, uenc);\n\n        };\n    }\n);\n","Magento_Catalog/js/product/addtocompare-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @returns {Array}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_compare_button'].url ||\n                    row['add_to_compare_button']['post_data']);\n        },\n\n        /**\n         * Depends on this option, \"Add to compare\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_compare', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'uiElement',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data',\n    'Magento_Catalog/js/product/view/product-ids-resolver'\n], function (_, $, utils, Element, storage, customerData, productResolver) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            identifiersConfig: {\n                namespace: ''\n            },\n            productStorageConfig: {\n                namespace: 'product_data_storage',\n                customerDataProvider: 'product_data_storage',\n                updateRequestConfig: {\n                    url: '',\n                    method: 'GET',\n                    dataType: 'json'\n                },\n                className: 'DataStorage'\n            },\n            ids: {},\n            listens: {\n                ids: 'idsHandler'\n            }\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initIdsStorage();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('ids');\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initIdsStorage: function () {\n            storage.onStorageInit(this.identifiersConfig.namespace, this.idsStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes ids storage handler.\n         *\n         * @param {Object} idsStorage\n         */\n        idsStorageHandler: function (idsStorage) {\n            this.idsStorage = idsStorage;\n            this.productStorage = storage.createStorage(this.productStorageConfig);\n            this.productStorage.data.subscribe(this.dataCollectionHandler.bind(this));\n\n            if (~~this.idsStorage.allowToSendRequest) {\n                customerData.reload([idsStorage.namespace]).done(this._resolveDataByIds.bind(this));\n            } else {\n                this._resolveDataByIds();\n            }\n        },\n\n        /**\n         * Callback, which load by ids from ids-storage product data\n         *\n         * @private\n         */\n        _resolveDataByIds: function () {\n            if (!window.checkout || !window.checkout.baseUrl) {\n                // We need data that the minicart provdes to determine storeId/websiteId\n                return;\n            }\n\n            // Filter initial ids to remove \"out of scope\" and \"outdated\" data\n            this.ids(\n                this.filterIds(this.ids())\n            );\n            this.initIdsListener();\n            this.idsMerger(\n                this.idsStorage.get(),\n                this.prepareDataFromCustomerData(customerData.get(this.identifiersConfig.namespace)())\n            );\n        },\n\n        /**\n         * Init ids storage listener.\n         */\n        initIdsListener: function () {\n            customerData.get(this.identifiersConfig.namespace).subscribe(function (data) {\n                this.idsMerger(this.prepareDataFromCustomerData(data));\n            }.bind(this));\n            this.idsStorage.data.subscribe(this.idsMerger.bind(this));\n        },\n\n        /**\n         * Prepare data from customerData.\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        prepareDataFromCustomerData: function (data) {\n            data = data.items ? data.items : data;\n\n            return data;\n        },\n\n        /**\n         * Filter ids by their lifetime in order to show only hot ids :)\n         *\n         * @param {Object} ids\n         * @returns {Array}\n         */\n        filterIds: function (ids) {\n            var _ids = {},\n                currentTime = new Date().getTime() / 1000,\n                currentProductIds = productResolver($('#product_addtocart_form')),\n                productCurrentScope = this.data.productCurrentScope,\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                    window.checkout.websiteId;\n\n            _.each(ids, function (id, key) {\n                if (\n                    currentTime - ids[key]['added_at'] < ~~this.idsStorage.lifetime &&\n                    !_.contains(currentProductIds, ids[key]['product_id']) &&\n                    (!id.hasOwnProperty('scope_id') || ids[key]['scope_id'] === scopeId)\n                ) {\n                    _ids[id['product_id']] = id;\n\n                }\n            }, this);\n\n            return _ids;\n        },\n\n        /**\n         * Merges id from storage and customer data\n         *\n         * @param {Object} data\n         * @param {Object} optionalData\n         */\n        idsMerger: function (data, optionalData) {\n            if (data && optionalData) {\n                data = _.extend(data, optionalData);\n            }\n\n            if (!_.isEmpty(data)) {\n                this.ids(\n                    this.filterIds(_.extend(utils.copy(this.ids()), data))\n                );\n            }\n        },\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, data);\n        },\n\n        /**\n         * Process data\n         *\n         * @param {Object} data\n         */\n        processData: function (data) {\n            var curData = utils.copy(this.data),\n                ids = this.ids();\n\n            delete data['data_id'];\n            data = _.values(data);\n\n            _.each(data, function (record, index) {\n                record._rowIndex = index;\n                record['added_at'] = ids[record.id]['added_at'];\n            }, this);\n\n            curData.items = data;\n            this.set('data', curData);\n        },\n\n        /**\n         * Product storage data handler\n         *\n         * @param {Object} data\n         */\n        dataCollectionHandler: function (data) {\n            data = this.filterData(data);\n            this.processData(data);\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.ids()),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/query-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n        'underscore'\n    ], function (_) {\n        'use strict';\n\n        return {\n\n            /**\n             * Build query to get id\n             *\n             * @param {Object} data\n             */\n            buildQuery: function (data) {\n                var filters = [];\n\n                _.each(data, function (value, key) {\n                    filters.push({\n                        field: key,\n                        value: value,\n                        'condition_type': 'in'\n                    });\n                });\n\n                return {\n                    searchCriteria: {\n                        filterGroups: [\n                            {\n                                filters: filters\n                            }\n                        ]\n                    }\n                };\n            }\n        };\n    }\n);\n","Magento_Catalog/js/product/name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'escaper'\n], function (Column, columnStatusValidator, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Depends on this option, product name can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'name', 'show_attributes');\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getNameUnsanitizedHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        }\n    });\n});\n","Magento_Catalog/js/product/breadcrumbs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Theme/js/model/breadcrumb-list'\n], function ($, breadcrumbList) {\n    'use strict';\n\n    return function (widget) {\n\n        $.widget('mage.breadcrumbs', widget, {\n            options: {\n                categoryUrlSuffix: '',\n                useCategoryPathInUrl: false,\n                product: '',\n                categoryItemSelector: '.category-item',\n                menuContainer: '[data-action=\"navigation\"] > ul'\n            },\n\n            /** @inheritdoc */\n            _render: function () {\n                this._appendCatalogCrumbs();\n                this._super();\n            },\n\n            /**\n             * Append category and product crumbs.\n             *\n             * @private\n             */\n            _appendCatalogCrumbs: function () {\n                var categoryCrumbs = this._resolveCategoryCrumbs();\n\n                categoryCrumbs.forEach(function (crumbInfo) {\n                    breadcrumbList.push(crumbInfo);\n                });\n\n                if (this.options.product) {\n                    breadcrumbList.push(this._getProductCrumb());\n                }\n            },\n\n            /**\n             * Resolve categories crumbs.\n             *\n             * @return Array\n             * @private\n             */\n            _resolveCategoryCrumbs: function () {\n                var menuItem = this._resolveCategoryMenuItem(),\n                    categoryCrumbs = [];\n\n                if (menuItem !== null && menuItem.length) {\n                    categoryCrumbs.unshift(this._getCategoryCrumb(menuItem));\n\n                    while ((menuItem = this._getParentMenuItem(menuItem)) !== null) {\n                        categoryCrumbs.unshift(this._getCategoryCrumb(menuItem));\n                    }\n                }\n\n                return categoryCrumbs;\n            },\n\n            /**\n             * Returns crumb data.\n             *\n             * @param {Object} menuItem\n             * @return {Object}\n             * @private\n             */\n            _getCategoryCrumb: function (menuItem) {\n                return {\n                    'name': 'category',\n                    'label': menuItem.text(),\n                    'link': menuItem.attr('href'),\n                    'title': ''\n                };\n            },\n\n            /**\n             * Returns product crumb.\n             *\n             * @return {Object}\n             * @private\n             */\n            _getProductCrumb: function () {\n                return {\n                    'name': 'product',\n                    'label': this.options.product,\n                    'link': '',\n                    'title': ''\n                };\n            },\n\n            /**\n             * Find parent menu item for current.\n             *\n             * @param {Object} menuItem\n             * @return {Object|null}\n             * @private\n             */\n            _getParentMenuItem: function (menuItem) {\n                var classes,\n                    classNav,\n                    parentClass,\n                    parentMenuItem = null;\n\n                if (!menuItem) {\n                    return null;\n                }\n\n                classes = menuItem.parent().attr('class');\n                classNav = classes.match(/(nav\\-)[0-9]+(\\-[0-9]+)+/gi);\n\n                if (classNav) {\n                    classNav = classNav[0];\n                    parentClass = classNav.substr(0, classNav.lastIndexOf('-'));\n\n                    if (parentClass.lastIndexOf('-') !== -1) {\n                        parentMenuItem = $(this.options.menuContainer).find('.' + parentClass + ' > a');\n                        parentMenuItem = parentMenuItem.length ? parentMenuItem : null;\n                    }\n                }\n\n                return parentMenuItem;\n            },\n\n            /**\n             * Returns category menu item.\n             *\n             * Tries to resolve category from url or from referrer as fallback and\n             * find menu item from navigation menu by category url.\n             *\n             * @return {Object|null}\n             * @private\n             */\n            _resolveCategoryMenuItem: function () {\n                var categoryUrl = this._resolveCategoryUrl(),\n                    menu = $(this.options.menuContainer),\n                    categoryMenuItem = null;\n\n                if (categoryUrl && menu.length) {\n                    categoryMenuItem = menu.find(\n                        this.options.categoryItemSelector +\n                        ' > a[href=\"' + categoryUrl + '\"]'\n                    );\n                }\n\n                return categoryMenuItem;\n            },\n\n            /**\n             * Returns category url.\n             *\n             * @return {String}\n             * @private\n             */\n            _resolveCategoryUrl: function () {\n                var categoryUrl;\n\n                if (this.options.useCategoryPathInUrl) {\n                    // In case category path is used in product url - resolve category url from current url.\n                    categoryUrl = window.location.href.split('?')[0];\n                    categoryUrl = categoryUrl.substring(0, categoryUrl.lastIndexOf('/')) +\n                        this.options.categoryUrlSuffix;\n                } else {\n                    // In other case - try to resolve it from referrer (without parameters).\n                    categoryUrl = document.referrer;\n\n                    if (categoryUrl.indexOf('?') > 0) {\n                        categoryUrl = categoryUrl.substr(0, categoryUrl.indexOf('?'));\n                    }\n                }\n\n                return categoryUrl;\n            }\n        });\n\n        return $.mage.breadcrumbs;\n    };\n});\n","Magento_Catalog/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, stock status text can be \"In stock\" or \"Out Of Stock\"\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isAvailable: function (row) {\n            return row['is_available'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/provider-compared.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    './provider',\n    'Magento_Catalog/js/product/storage/storage-service',\n    'Magento_Customer/js/customer-data'\n], function (_, Provider, storage, customerData) {\n    'use strict';\n\n    return Provider.extend({\n\n        /**\n         * Ids update handler\n         *\n         * @param {Object} data\n         */\n        idsHandler: function (data) {\n            this.productStorage.setIds(this.data.currency, this.data.store, this.dataFilter(data));\n        },\n\n        /**\n         * Filters data by provider\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        dataFilter: function (data) {\n            var providerData = this.idsStorage.prepareData(customerData.get(this.identifiersConfig.provider)().items),\n                result = {},\n                productCurrentScope,\n                scopeId;\n\n            if (typeof this.data.productCurrentScope !== 'undefined' && window.checkout && window.checkout.baseUrl) {\n                productCurrentScope = this.data.productCurrentScope;\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                    productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                        window.checkout.websiteId;\n                _.each(data, function (value, key) {\n                    if (!providerData[productCurrentScope + '-' + scopeId + '-' + key]) {\n                        result[key] = value;\n                    }\n                });\n            } else {\n                _.each(data, function (value, key) {\n                    if (!providerData[key]) {\n                        result[key] = value;\n                    }\n                });\n            }\n\n            return result;\n        },\n\n        /**\n         * Filters data from product storage by ids\n         *\n         * @param {Object} data\n         *\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var result = {},\n                i = 0,\n                ids = _.keys(this.dataFilter(this.ids())),\n                length = ids.length;\n\n            for (i; i < length; i++) {\n                if (ids[i] && data[ids[i]]) {\n                    result[ids[i]] = data[ids[i]];\n                }\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/remaining-characters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery-ui-modules/widget'\n], function ($, $t) {\n    'use strict';\n\n    $.widget('mage.remainingCharacters', {\n        options: {\n            remainingText: $t('remaining'),\n            tooManyText: $t('too many'),\n            errorClass: 'mage-error',\n            noDisplayClass: 'no-display'\n        },\n\n        /**\n         * Initializes custom option component\n         *\n         * @private\n         */\n        _create: function () {\n            this.note = $(this.options.noteSelector);\n            this.counter = $(this.options.counterSelector);\n\n            this.updateCharacterCount();\n            this.element.on('change keyup paste', this.updateCharacterCount.bind(this));\n        },\n\n        /**\n         * Updates counter message\n         */\n        updateCharacterCount: function () {\n            var length = this.element.val().length,\n                diff = this.options.maxLength - length;\n\n            this.counter.text(this._formatMessage(diff));\n            this.counter.toggleClass(this.options.noDisplayClass, length === 0);\n            this.note.toggleClass(this.options.errorClass, diff < 0);\n        },\n\n        /**\n         * Format remaining characters message\n         *\n         * @param {int} diff\n         * @returns {String}\n         * @private\n         */\n        _formatMessage: function (diff) {\n            var count = Math.abs(diff),\n                qualifier = diff < 0 ? this.options.tooManyText : this.options.remainingText;\n\n            return '(' + count + ' ' + qualifier + ')';\n        }\n    });\n\n    return $.mage.remainingCharacters;\n});\n","Magento_Catalog/js/product/storage/ids-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils) {\n    'use strict';\n\n    /**\n     * Set data to localStorage with support check.\n     *\n     * @param {String} namespace\n     * @param {Object} data\n     */\n    function setLocalStorageItem(namespace, data) {\n        try {\n            window.localStorage.setItem(namespace, JSON.stringify(data));\n        } catch (e) {\n            console.warn('localStorage is unavailable - skipping local caching of product data');\n            console.error(e);\n        }\n    }\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorage',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initCustomerDataReloadListener()\n                .initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Gets data from local storage by current namespace\n         *\n         * @return {Object}.\n         */\n        getDataFromLocalStorage: function () {\n            return this.localStorage.get();\n        },\n\n        /**\n         * Caches data from local storage to local scope\n         *\n         * @return Chainable.\n         */\n        cachesDataFromLocalStorage: function () {\n            this.data(this.getDataFromLocalStorage());\n\n            return this;\n        },\n\n        /**\n         * Initialize localStorage\n         *\n         * @return Chainable.\n         */\n        initLocalStorage: function () {\n            this.localStorage = $.initNamespaceStorage(this.namespace).localStorage;\n\n            return this;\n        },\n\n        /**\n         * Initializes listener to \"data\" property\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.internalDataHandler.bind(this));\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-reload', function (event, sections) {\n                if ((_.isEmpty(sections) || _.contains(sections, this.namespace)) && ~~this.allowToSendRequest) {\n                    this.localStorage.removeAll();\n                    this.data();\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initializes handler to \"data\" property update\n         */\n        internalDataHandler: function (data) {\n            setLocalStorageItem(this.namespace, data);\n        },\n\n        /**\n         * Initializes handler to storage update\n         */\n        externalDataHandler: function (data) {\n            data = data.items ? data.items : data;\n\n            this.set(_.extend(utils.copy(this.data()), data));\n        }\n    };\n});\n\n","Magento_Catalog/js/product/storage/ids-storage-compare.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Customer/js/customer-data',\n    'Magento_Catalog/js/product/storage/ids-storage'\n], function (_, ko, utils, customerData, idsStorage) {\n    'use strict';\n\n    return _.extend(utils.copy(idsStorage), {\n\n        /**\n         * Class name\n         */\n        name: 'IdsStorageCompare',\n\n        /**\n         * Initializes class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            if (this.provider && window.checkout && window.checkout.baseUrl) {\n                this.providerDataHandler(customerData.get(this.provider)());\n                this.initProviderListener();\n            }\n\n            this.initLocalStorage()\n                .cachesDataFromLocalStorage()\n                .initDataListener();\n\n            return this;\n        },\n\n        /**\n         * Initializes listener for external data provider\n         */\n        initProviderListener: function () {\n            customerData.get(this.provider).subscribe(this.providerDataHandler.bind(this));\n        },\n\n        /**\n         * Initializes handler for external data provider update\n         *\n         * @param {Object} data\n         */\n        providerDataHandler: function (data) {\n            data = data.items || data;\n            data = this.prepareData(data);\n\n            this.add(data);\n        },\n\n        /**\n         * Prepares data to correct interface\n         *\n         * @param {Object} data\n         *\n         * @returns {Object} data\n         */\n        prepareData: function (data) {\n            var result = {},\n                scopeId;\n\n            _.each(data, function (item) {\n                if (typeof item.productScope !== 'undefined') {\n                    scopeId = item.productScope === 'store' ? window.checkout.storeId :\n                        item.productScope === 'group' ? window.checkout.storeGroupId :\n                            window.checkout.websiteId;\n\n                    result[item.productScope + '-' + scopeId + '-' + item.id] = {\n                        'added_at': new Date().getTime() / 1000,\n                        'product_id': item.id,\n                        'scope_id': scopeId\n                    };\n                } else {\n                    result[item.id] = {\n                        'added_at': new Date().getTime() / 1000,\n                        'product_id': item.id\n                    };\n                }\n            });\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/storage/storage-service.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'Magento_Catalog/js/product/storage/ids-storage',\n    'Magento_Catalog/js/product/storage/data-storage',\n    'Magento_Catalog/js/product/storage/ids-storage-compare'\n], function ($, _, utils, $t, IdsStorage, DataStore, IdsStorageCompare) {\n    'use strict';\n\n    return (function () {\n\n        var /**\n             * {Object} storages - list of storages\n             */\n            storages = {},\n\n            /**\n             * {Object} classes - list of classes\n             */\n            classes = {},\n\n            /**\n             * {Object} prototype - methods that will be added to all storage classes to prototype property.\n             */\n            prototype = {\n\n                /**\n                 * Sets data to storage\n                 *\n                 * @param {*} data\n                 */\n                set: function (data) {\n                    if (!utils.compare(data, this.data()).equal) {\n                        this.data(data);\n                    }\n                },\n\n                /**\n                 * Adds some data to current storage data\n                 *\n                 * @param {*} data\n                 */\n                add: function (data) {\n                    if (!_.isEmpty(data)) {\n                        this.data(_.extend(utils.copy(this.data()), data));\n                    }\n                },\n\n                /**\n                 * Gets current storage data\n                 *\n                 * @returns {*} data\n                 */\n                get: function () {\n                    return this.data();\n                }\n            },\n\n            /**\n             * Required properties to storage\n             */\n            storagesInterface =  {\n                data: 'function',\n                initialize: 'function',\n                namespace: 'string'\n            },\n\n            /**\n             * Private service methods\n             */\n            _private = {\n\n                /**\n                 * Overrides class method and add ability use _super to call parent method\n                 *\n                 * @param {Object} extensionMethods\n                 * @param {Object} originInstance\n                 */\n                overrideClassMethods: function (extensionMethods, originInstance) {\n                    var methodsName = _.keys(extensionMethods),\n                        i = 0,\n                        length = methodsName.length;\n\n                    for (i; i < length; i++) {\n                        if (_.isFunction(originInstance[methodsName[i]])) {\n                            originInstance[methodsName[i]] = extensionMethods[methodsName[i]];\n                        }\n                    }\n\n                    return originInstance;\n                },\n\n                /**\n                 * Checks is storage implement interface\n                 *\n                 * @param {Object} classInstance\n                 *\n                 * @returns {Boolean}\n                 */\n                isImplementInterface: function (classInstance) {\n                    _.each(storagesInterface, function (key, value) {\n                        if (typeof classInstance[key] !== value) {\n                            return false;\n                        }\n                    });\n\n                    return true;\n                }\n            },\n\n            /**\n             * Subscribers list\n             */\n            subsctibers = {};\n\n        (function () {\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorage.name] = function (config) {\n                _.extend(this, IdsStorage, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[IdsStorageCompare.name] = function (config) {\n                _.extend(this, IdsStorageCompare, config);\n            };\n\n            /**\n             * @param {Object} config\n             * @return void\n             */\n            classes[DataStore.name] = function (config) {\n                _.extend(this, DataStore, config);\n            };\n\n            _.each(classes, function (classItem) {\n                classItem.prototype = prototype;\n            });\n        })();\n\n        return {\n\n            /**\n             * Creates new storage or returns if storage with declared namespace exist\n             *\n             * @param {Object} config - storage config\n             * @throws {Error}\n             * @returns {Object} storage instance\n             */\n            createStorage: function (config) {\n                var instance,\n                    initialized;\n\n                if (storages[config.namespace]) {\n                    return storages[config.namespace];\n                }\n\n                instance = new classes[config.className](config);\n\n                if (_private.isImplementInterface(instance)) {\n                    initialized = storages[config.namespace] = instance.initialize();\n                    this.processSubscribers(initialized, config);\n\n                    return initialized;\n                }\n\n                throw new Error('Class ' + config.className + $t('does not implement Storage Interface'));\n            },\n\n            /**\n             * Process subscribers\n             *\n             * Differentiate subscribers by their namespaces: recently_viewed or recently_compared\n             * and process callbacks. Callbacks can be add through onStorageInit function\n             *\n             * @param {Object} initialized\n             * @param {Object} config\n             * @return void\n             */\n            processSubscribers: function (initialized, config) {\n                if (subsctibers[config.namespace]) {\n                    _.each(subsctibers[config.namespace], function (callback) {\n                        callback(initialized);\n                    });\n\n                    delete subsctibers[config.namespace];\n                }\n            },\n\n            /**\n             * Listens storage creating by namespace\n             *\n             * @param {String} namespace\n             * @param {Function} callback\n             * @return void\n             */\n            onStorageInit: function (namespace, callback) {\n                if (storages[namespace]) {\n                    callback(storages[namespace]);\n                } else {\n                    subsctibers[namespace] ?\n                        subsctibers[namespace].push(callback) :\n                        subsctibers[namespace] = [callback];\n                }\n            },\n\n            /**\n             * Gets storage by namespace\n             *\n             * @param {String} namespace\n             *\n             * @returns {Object} storage insance\n             */\n            getStorage: function (namespace) {\n                return storages[namespace];\n            }\n        };\n    })();\n});\n\n","Magento_Catalog/js/product/storage/data-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'ko',\n    'mageUtils',\n    'Magento_Catalog/js/product/query-builder',\n    'Magento_Customer/js/customer-data',\n    'jquery/jquery-storageapi'\n], function ($, _, ko, utils, queryBuilder, customerData) {\n    'use strict';\n\n    /**\n     * Process data from API request\n     *\n     * @param {Object} data\n     * @returns {Object}\n     */\n    function getParsedDataFromServer(data) {\n        var result = {};\n\n        _.each(data.items, function (item) {\n                if (item.id) {\n                    result[item.id] = item;\n                }\n            }\n        );\n\n        return {\n            items: result\n        };\n    }\n\n    /**\n     * Set data to localStorage with support check.\n     *\n     * @param {String} namespace\n     * @param {Object} data\n     */\n    function setLocalStorageItem(namespace, data) {\n        try {\n            window.localStorage.setItem(namespace, JSON.stringify(data));\n        } catch (e) {\n            console.warn('localStorage is unavailable - skipping local caching of product data');\n            console.error(e);\n        }\n    }\n\n    return {\n\n        /**\n         * Class name\n         */\n        name: 'DataStorage',\n        request: {},\n        customerDataProvider: 'product_data_storage',\n\n        /**\n         * Initialize class\n         *\n         * @return Chainable.\n         */\n        initialize: function () {\n            if (!this.data) {\n                this.data = ko.observable({});\n            }\n\n            this.initLocalStorage()\n                .initCustomerDataReloadListener()\n                .cachesDataFromLocalStorage()\n                .initDataListener()\n                .initProvideStorage()\n                .initProviderListener();\n\n            return this;\n        },\n\n        /**\n         * Initialize listener to customer data reload\n         *\n         * @return Chainable.\n         */\n        initCustomerDataReloadListener: function () {\n            $(document).on('customer-data-invalidate', this._flushProductStorage.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Flush product storage\n         *\n         * @private\n         * @return void\n         */\n        _flushProductStorage: function (event, sections) {\n            if (_.isEmpty(sections) || _.contains(sections, 'product_data_storage')) {\n                this.localStorage.removeAll();\n            }\n        },\n\n        /**\n         * Initialize listener to data property\n         *\n         * @return Chainable.\n         */\n        initDataListener: function () {\n            this.data.subscribe(this.dataHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initialize provider storage\n         *\n         * @return Chainable.\n         */\n        initProvideStorage: function () {\n            this.providerHandler(customerData.get(this.customerDataProvider)());\n\n            return this;\n        },\n\n        /**\n         * Handler to update \"data\" property.\n         * Sets data to localStorage\n         *\n         * @param {Object} data\n         */\n        dataHandler: function (data) {\n            if (_.isEmpty(data)) {\n                this.localStorage.removeAll();\n            } else {\n                setLocalStorageItem(this.namespace, data);\n            }\n        },\n\n        /**\n         * Handler to update data in provider.\n         *\n         * @param {Object} data\n         */\n        providerHandler: function (data) {\n            var currentData = utils.copy(this.data()),\n                ids = _.keys(data.items);\n\n            if (data.items && ids.length) {\n                //we can extend only items\n                data = data.items;\n                this.data(_.extend(currentData, data));\n            }\n        },\n\n        /**\n         * Sets data ids\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         */\n        setIds: function (currency, store, ids) {\n            if (!this.hasInCache(currency, store, ids)) {\n                this.loadDataFromServer(currency, store, ids);\n            } else {\n                this.data.valueHasMutated();\n            }\n        },\n\n        /**\n         * Gets data from \"data\" property by identifiers\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} productIdentifiers\n         *\n         * @return {Object} data.\n         */\n        getDataByIdentifiers: function (currency, store, productIdentifiers) {\n            var data = {},\n                dataCollection = this.data(),\n                id;\n\n            for (id in productIdentifiers) {\n                if (productIdentifiers.hasOwnProperty(id)) {\n                    data[id] = dataCollection[id];\n                }\n            }\n\n            return data;\n        },\n\n        /**\n         * Checks has cached data or not\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         *\n         * @return {Boolean}\n         */\n        hasInCache: function (currency, store, ids) {\n            var data = this.data(),\n                id;\n\n            for (id in ids) {\n                if (!data.hasOwnProperty(id) ||\n                    data[id]['currency_code'] !== currency ||\n                    ~~data[id]['store_id'] !== ~~store\n                ) {\n                    return false;\n                }\n            }\n\n            return true;\n        },\n\n        /**\n         * Load data from server by ids\n         *\n         * @param {String} currency\n         * @param {String} store\n         * @param {Object} ids\n         *\n         * @return void\n         */\n        loadDataFromServer: function (currency, store, ids) {\n            var idsArray = _.keys(ids),\n                prepareAjaxParams = {\n                    'entity_id': idsArray.join(',')\n                };\n\n            if (this.request.sent && this.hasIdsInSentRequest(ids)) {\n                return;\n            }\n\n            this.request = {\n                sent: true,\n                data: ids\n            };\n\n            this.updateRequestConfig.data = queryBuilder.buildQuery(prepareAjaxParams);\n            this.updateRequestConfig.data['store_id'] = store;\n            this.updateRequestConfig.data['currency_code'] = currency;\n            $.ajax(this.updateRequestConfig).done(function (data) {\n                this.request = {};\n                this.providerHandler(getParsedDataFromServer(data));\n            }.bind(this));\n        },\n\n        /**\n         * Each product page consist product cache data,\n         * this function prepare those data to appropriate view, and save it\n         *\n         * @param {Object} data\n         */\n        addDataFromPageCache: function (data) {\n            this.providerHandler(getParsedDataFromServer(data));\n        },\n\n        /**\n         * @param {Object} ids\n         * @returns {Boolean}\n         */\n        hasIdsInSentRequest: function (ids) {\n            var sentDataIds,\n                currentDataIds;\n\n            if (this.request.data) {\n                sentDataIds = _.keys(this.request.data);\n                currentDataIds = _.keys(ids);\n\n                return _.every(currentDataIds, function (id) {\n                    return _.lastIndexOf(sentDataIds, id) !== -1;\n                });\n            }\n\n            return false;\n        },\n\n        /**\n         * Initialize provider listener\n         *\n         * @return Chainable.\n         */\n        initProviderListener: function () {\n            customerData.get(this.customerDataProvider).subscribe(this.providerHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Caches data from local storage to local scope\n         *\n         * @return Chainable.\n         */\n        cachesDataFromLocalStorage: function () {\n            this.data(this.getDataFromLocalStorage());\n\n            return this;\n        },\n\n        /**\n         * Gets data from local storage by current namespace\n         *\n         * @return {Object}.\n         */\n        getDataFromLocalStorage: function () {\n            return this.localStorage.get();\n        },\n\n        /**\n         * Initialize localStorage\n         *\n         * @return Chainable.\n         */\n        initLocalStorage: function () {\n            this.localStorage = $.initNamespaceStorage(this.namespace).localStorage;\n\n            return this;\n        }\n    };\n});\n","Magento_Catalog/js/product/list/column-status-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        /**\n         * Check whether we can show column depends on server settings or not\n         *\n         * @param {Object} source\n         * @param {String} attributeCode\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        isValid: function (source, attributeCode, type) {\n            var attributes;\n\n            if (!source[type]) {\n                return false;\n            }\n\n            attributes = source[type].split(',');\n\n            return _.contains(attributes, attributeCode);\n        }\n    });\n});\n","Magento_Catalog/js/product/list/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/listing'\n], function (ko, _, Listing) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            additionalClasses: '',\n            filteredRows: {},\n            limit: 5,\n            listens: {\n                elems: 'filterRowsFromCache',\n                '${ $.provider }:data.items': 'filterRowsFromServer'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.filteredRows = ko.observable();\n            this.initProductsLimit();\n            this.hideLoader();\n        },\n\n        /**\n         * Initialize product limit\n         * Product limit can be configured through Ui component.\n         * Product limit are present in widget form\n         *\n         * @returns {exports}\n         */\n        initProductsLimit: function () {\n            if (this.source['page_size']) {\n                this.limit = this.source['page_size'];\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Sort and filter rows, that are already in magento storage cache\n         *\n         * @return void\n         */\n        filterRowsFromCache: function () {\n            this._filterRows(this.rows);\n        },\n\n        /**\n         * Sort and filter rows, that are come from backend\n         *\n         * @param {Object} rows\n         */\n        filterRowsFromServer: function (rows) {\n            this._filterRows(rows);\n        },\n\n        /**\n         * Filter rows by limit and sort them\n         *\n         * @param {Array} rows\n         * @private\n         */\n        _filterRows: function (rows) {\n            this.filteredRows(_.sortBy(rows, 'added_at').reverse().slice(0, this.limit));\n        },\n\n        /**\n         * Can retrieve product url\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getUrl: function (row) {\n            return row.url;\n        },\n\n        /**\n         * Get product attribute by code.\n         *\n         * @param {String} code\n         * @return {Object}\n         */\n        getComponentByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                component;\n\n            component = _.filter(elems, function (elem) {\n                return elem.index === code;\n            }, this).pop();\n\n            return component;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/toolbar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    /**\n     * ProductListToolbarForm Widget - this widget is setting cookie and submitting form according to toolbar controls\n     */\n    $.widget('mage.productListToolbarForm', {\n\n        options: {\n            modeControl: '[data-role=\"mode-switcher\"]',\n            directionControl: '[data-role=\"direction-switcher\"]',\n            orderControl: '[data-role=\"sorter\"]',\n            limitControl: '[data-role=\"limiter\"]',\n            mode: 'product_list_mode',\n            direction: 'product_list_dir',\n            order: 'product_list_order',\n            limit: 'product_list_limit',\n            page: 'p',\n            modeDefault: 'grid',\n            directionDefault: 'asc',\n            orderDefault: 'position',\n            limitDefault: '9',\n            url: '',\n            formKey: '',\n            post: false\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._bind(\n                $(this.options.modeControl, this.element),\n                this.options.mode,\n                this.options.modeDefault\n            );\n            this._bind(\n                $(this.options.directionControl, this.element),\n                this.options.direction,\n                this.options.directionDefault\n            );\n            this._bind(\n                $(this.options.orderControl, this.element),\n                this.options.order,\n                this.options.orderDefault\n            );\n            this._bind(\n                $(this.options.limitControl, this.element),\n                this.options.limit,\n                this.options.limitDefault\n            );\n        },\n\n        /** @inheritdoc */\n        _bind: function (element, paramName, defaultValue) {\n            if (element.is('select')) {\n                element.on('change', {\n                    paramName: paramName,\n                    'default': defaultValue\n                }, $.proxy(this._processSelect, this));\n            } else {\n                element.on('click', {\n                    paramName: paramName,\n                    'default': defaultValue\n                }, $.proxy(this._processLink, this));\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _processLink: function (event) {\n            event.preventDefault();\n            this.changeUrl(\n                event.data.paramName,\n                $(event.currentTarget).data('value'),\n                event.data.default\n            );\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _processSelect: function (event) {\n            this.changeUrl(\n                event.data.paramName,\n                event.currentTarget.options[event.currentTarget.selectedIndex].value,\n                event.data.default\n            );\n        },\n\n        /**\n         * @private\n         */\n        getUrlParams: function () {\n            var decode = window.decodeURIComponent,\n                urlPaths = this.options.url.split('?'),\n                urlParams = urlPaths[1] ? urlPaths[1].split('&') : [],\n                params = {},\n                parameters, i;\n\n            for (i = 0; i < urlParams.length; i++) {\n                parameters = urlParams[i].split('=');\n                params[decode(parameters[0])] = parameters[1] !== undefined ?\n                    decode(parameters[1].replace(/\\+/g, '%20')) :\n                    '';\n            }\n\n            return params;\n        },\n\n        /**\n         * @returns {String}\n         * @private\n         */\n        getCurrentLimit: function () {\n            return this.getUrlParams()[this.options.limit] || this.options.limitDefault;\n        },\n\n        /**\n         * @returns {String}\n         * @private\n         */\n        getCurrentPage: function () {\n            return this.getUrlParams()[this.options.page] || 1;\n        },\n\n        /**\n         * @param {String} paramName\n         * @param {*} paramValue\n         * @param {*} defaultValue\n         */\n        changeUrl: function (paramName, paramValue, defaultValue) {\n            var urlPaths = this.options.url.split('?'),\n                baseUrl = urlPaths[0],\n                paramData = this.getUrlParams(),\n                currentPage = this.getCurrentPage(),\n                form, params, key, input, formKey, newPage;\n\n            if (currentPage > 1 && paramName === this.options.mode) {\n                delete paramData[this.options.page];\n            }\n\n            if (currentPage > 1 && paramName === this.options.limit) {\n                newPage = Math.floor(this.getCurrentLimit() * (currentPage - 1) / paramValue) + 1;\n\n                if (newPage > 1) {\n                    paramData[this.options.page] = newPage;\n                } else {\n                    delete paramData[this.options.page];\n                }\n            }\n\n            paramData[paramName] = paramValue;\n\n            if (this.options.post) {\n                form = document.createElement('form');\n                params = [this.options.mode, this.options.direction, this.options.order, this.options.limit];\n\n                for (key in paramData) {\n                    if (params.indexOf(key) !== -1) { //eslint-disable-line max-depth\n                        input = document.createElement('input');\n                        input.name = key;\n                        input.value = paramData[key];\n                        form.appendChild(input);\n                        delete paramData[key];\n                    }\n                }\n                formKey = document.createElement('input');\n                formKey.name = 'form_key';\n                formKey.value = this.options.formKey;\n                form.appendChild(formKey);\n\n                paramData = $.param(paramData);\n                baseUrl += paramData.length ? '?' + paramData : '';\n\n                form.action = baseUrl;\n                form.method = 'POST';\n                document.body.appendChild(form);\n                form.submit();\n            } else {\n                if (paramValue == defaultValue) { //eslint-disable-line eqeqeq\n                    delete paramData[paramName];\n                }\n\n                paramData = $.param(paramData);\n                location.href = baseUrl + (paramData.length ? '?' + paramData : '');\n            }\n        }\n    });\n\n    return $.mage.productListToolbarForm;\n});\n","Magento_Catalog/js/product/list/columns/final-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection'\n], function (_, registry, utils, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: false,\n            headerTmpl: 'ui/grid/columns/text',\n            showMinimalPrice: false,\n            showMaximumPrice: false,\n            useLinkForAsLowAs: false,\n            bodyTmpl: 'Magento_Catalog/product/final_price',\n            priceWrapperCssClasses: '',\n            priceWrapperAttr: {}\n        },\n\n        /**\n         * Get product final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPrice: function (row) {\n            return row['price_info']['formatted_prices']['final_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPriceUnsanitizedHtml: function (row) {\n            return this.getPrice(row);\n        },\n\n        /**\n         * Get product regular price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPriceUnsanitizedHtml: function (row) {\n            return this.getRegularPrice(row);\n        },\n\n        /**\n         * Check if product has a price range.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Check if product has special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} special price html\n         */\n        hasSpecialPrice: function (row) {\n            return row['price_info']['regular_price'] > row['price_info']['final_price'];\n        },\n\n        /**\n         * Check if product has minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        isMinimalPrice: function (row) {\n            return row['price_info']['minimal_price'] < row['price_info']['final_price'];\n        },\n\n        /**\n         * Get product minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPrice: function (row) {\n            return row['price_info']['formatted_prices']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPriceUnsanitizedHtml: function (row) {\n            return this.getMinimalPrice(row);\n        },\n\n        /**\n         * Check if product is salable.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Get product maximum price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPriceUnsanitizedHtml: function (row) {\n            return this.getMaxPrice(row);\n        },\n\n        /**\n         * Get product maximum regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMaxRegularPrice(row);\n        },\n\n        /**\n         * Get product minimal regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['min_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMinRegularPrice(row);\n        },\n\n        /**\n         * Get adjustments names and return as string.\n         *\n         * @return {String} adjustments classes\n         */\n        getAdjustmentCssClasses: function () {\n            return _.pluck(this.getAdjustments(), 'index').join(' ');\n        },\n\n        /**\n         * Get product minimal price as number.\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmount: function (row) {\n            return row['price_info']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPriceAmount\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmountUnsanitizedHtml: function (row) {\n            return this.getMinimalPriceAmount(row);\n        },\n\n        /**\n         * Get product minimal regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} minimal regular price amount\n         */\n        getMinimalRegularPriceAmount: function (row) {\n            return row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Get product maximum price as number.\n         *\n         * @param {Object} row\n         * @return {Number} maximum price amount\n         */\n        getMaximumPriceAmount: function (row) {\n            return row['price_info']['max_price'];\n        },\n\n        /**\n         * Get product maximum regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} maximum regular price amount\n         */\n        getMaximumRegularPriceAmount: function (row) {\n            return row['price_info']['max_regular_price'];\n        },\n\n        /**\n         * Check if minimal regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMinRegularPrice: function (row) {\n            return this.getMinimalPriceAmount(row) < this.getMinimalRegularPriceAmount(row);\n        },\n\n        /**\n         * Check if maximum regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMaxRegularPrice: function (row) {\n            return this.getMaximumPriceAmount(row) < this.getMaximumRegularPriceAmount(row);\n        },\n\n        /**\n         * Get path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get all price adjustments.\n         *\n         * @returns {Object}\n         */\n        getAdjustments: function () {\n            var adjustments = this.elems();\n\n            _.each(adjustments, function (adjustment) {\n                adjustment.setPriceType(this.priceType);\n                adjustment.source = this.source;\n            }, this);\n\n            return adjustments;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (_, Element, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Catalog/product/list/columns/image',\n            imageCode: 'default',\n            image: {}\n        },\n\n        /**\n         * Find image by code in scope of images\n         *\n         * @param {Object} images\n         * @returns {*|T}\n         */\n        getImage: function (images) {\n            return _.filter(images, function (image) {\n                return this.imageCode === image.code;\n            }, this).pop();\n        },\n\n        /**\n         * Get image path.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getImageUrl: function (row) {\n            return this.getImage(row.images).url;\n        },\n\n        /**\n         * Get image box width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getWidth: function (row) {\n            return this.getImage(row.images).width;\n        },\n\n        /**\n         * Get image box height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getHeight: function (row) {\n            return this.getImage(row.images).height;\n        },\n\n        /**\n         * Get resized image width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageWidth: function (row) {\n            return this.getImage(row.images)['resized_width'];\n        },\n\n        /**\n         * Get resized image height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageHeight: function (row) {\n            return this.getImage(row.images)['resized_height'];\n        },\n\n        /**\n         * Get image alt text.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getLabel: function (row) {\n            if (!this.imageExists(row)) {\n                return this._super();\n            }\n\n            return this.getImage(row.images).label;\n        },\n\n        /**\n         * Check if image exist.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        imageExists: function (row) {\n            return this.getImage(row.images) !== 'undefined';\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'image', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'uiLayout'\n], function (ko, _, registry, utils, Collection, columnStatusValidator, layout) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: '',\n            hasSpecialPrice: false,\n            showMinimalPrice: false,\n            useLinkForAsLowAs: false,\n            visible: true,\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_Catalog/product/price/price_box',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: false,\n            sorting: false,\n            draggable: true,\n            fieldClass: {},\n            renders: {\n                default: {}\n            },\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                elems: ''\n            },\n            modules: {\n                source: '${ $.provider }'\n            },\n            pricesInit: {}\n        },\n\n        /**\n         * Sort prices api\n         *\n         * @returns {exports}\n         */\n        sort: function () {\n            return this;\n        },\n\n        /**\n         * Check whether is allowed to render price or not\n         *\n         * @returns {*}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'price', 'show_attributes');\n        },\n\n        /**\n         * Retrieve array of prices, that should be rendered for specific product\n         *\n         * @param {Array} row\n         * @return {Array}\n         */\n        getPrices: function (row) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                result;\n\n            //we cant take type of product from row\n            this.initPrices(row);\n            result = _.filter(elems, function (elem) {\n                return elem.productType === row.type;\n            });\n\n            return result;\n        },\n\n        /**\n         * Recursive Merging of objects\n         *\n         * @param {Array} target\n         * @param {Array} source\n         * @returns {Array}\n         * @private\n         */\n        _deepObjectExtend: function (target, source) {\n            var _target = utils.copy(target);\n\n            _.each(source, function (value, key) {\n                if (_.keys(value).length && typeof _target[key] !== 'undefined') {\n                    _target[key] = this._deepObjectExtend(_target[key], value);\n                } else {\n                    _target[key] = value;\n                }\n            }, this);\n\n            return _target;\n        },\n\n        /**\n         * Init price type box, in cases when product type has custom component or bodyTmpl\n         *\n         * @param {String} productType\n         * @private\n         */\n        _initPriceWithCustomMetaData: function (productType) {\n            var price = this._deepObjectExtend(\n                this.renders.prices['default'],\n                this.renders.prices[productType]\n            );\n\n            price.name = productType + '.default';\n            price.parent = this.name;\n            price.source = this.source;\n            price.productType = productType;\n            layout([price]);\n        },\n\n        /**\n         * Init Prices by product type and add them to layout\n         *\n         * @param {Array} _priceData\n         * @param {String} productType\n         * @private\n         */\n        _initPricesForProductType: function (_priceData, productType) {\n            var prices = [];\n\n            this._setPriceNamesToPrices(_priceData, productType);\n            _.sortBy(_priceData, this._comparePrices);\n\n            _.each(_priceData, function (priceData) {\n                if (!priceData.component) {\n                    return;\n                }\n\n                priceData.parent = this.name;\n                priceData.provider = this.provider;\n                priceData.productType = productType;\n                priceData = utils.template(priceData, this);\n                prices.push(priceData);\n            }, this);\n\n            layout(prices);\n        },\n\n        /**\n         * Init dynamic price components\n         *\n         * @param {Array} row\n         * @returns {void}\n         */\n        initPrices: function (row) {\n            var _priceData = [],\n                productType = row.type,\n                defaultPrice = this.renders.prices['default'];\n\n            if (this.pricesInit[productType]) {\n                return true;\n            }\n\n            this.pricesInit[productType] = true;\n\n            if (this.renders.prices[productType] && this._needToApplyCustomTemplate(this.renders.prices[productType])) {\n                return this._initPriceWithCustomMetaData(productType);\n            }\n\n            if (this.renders.prices[productType] && this.renders.prices[productType].children) {\n                _priceData = this._deepObjectExtend(defaultPrice.children, this.renders.prices[productType].children);\n            } else {\n                _priceData = defaultPrice.children;\n            }\n\n            return this._initPricesForProductType(_priceData, productType);\n        },\n\n        /**\n         * Set name to all price components\n         *\n         * @param {Array} prices\n         * @param {String} productType\n         * @private\n         */\n        _setPriceNamesToPrices: function (prices, productType) {\n            _.each(prices, function (price, name) {\n                price.priceType = name;\n                price.name = name + '.' + productType;\n            });\n\n            return prices;\n        },\n\n        /**\n         * Sort callback to compare prices by sort order\n         *\n         * @param {Number} firstPrice\n         * @param {Number} secondPrice\n         * @returns {Number}\n         * @private\n         */\n        _comparePrices: function (firstPrice, secondPrice) {\n            if (firstPrice.sortOrder < secondPrice.sortOrder) {\n                return -1;\n            }\n\n            if (firstPrice.sortOrder > secondPrice.sortOrder) {\n                return 1;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Check whether metadata of product type prices was changed, and we should\n         * to apply custom template or custom component\n         *\n         * @param {Array} productData\n         * @returns {*}\n         * @private\n         */\n        _needToApplyCustomTemplate: function (productData) {\n            return productData.bodyTmpl || productData.component;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get price label.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/pricetype-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiCollection'\n], function (ko, _, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        /**\n         * Find from all price ui components, price with specific code, init source on it and set priceType\n         *\n         * @param {String} code\n         * @returns {*|T}\n         */\n        getPriceByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                price;\n\n            price = _.filter(elems, function (elem) {\n                return elem.index.split('.').shift() === code;\n            }, this).pop();\n\n            price.source = this.source();\n            price.priceType = code;\n\n            return price;\n        },\n\n        /**\n         * Retrieve body template\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check whether price has price range, depends on different options, that can be choose\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        }\n    });\n});\n","Magento_Catalog/js/product/view/product-ids.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Catalog/js/product/view/product-info-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Catalog/js/product/view/product-info'\n], function (_, productInfo) {\n    'use strict';\n\n    /**\n     * Returns info about products in form.\n     *\n     * @param {jQuery} $form\n     * @return {Array}\n     */\n    return function ($form) {\n        var product = _.findWhere($form.serializeArray(), {\n                name: 'product'\n            });\n\n        if (!_.isUndefined(product)) {\n            productInfo().push(\n                {\n                    'id': product.value\n                }\n            );\n        }\n\n        return _.uniq(productInfo(), function (item) {\n            return item.id;\n        });\n    };\n});\n\n","Magento_Catalog/js/product/view/product-info.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko'\n], function (ko) {\n    'use strict';\n\n    return ko.observableArray([]);\n});\n","Magento_Catalog/js/product/view/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiElement',\n    'Magento_Catalog/js/product/storage/storage-service'\n], function (_, Element, storage) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            identifiersConfig: {\n                namespace: 'recently_viewed_product'\n            },\n            productStorageConfig: {\n                namespace: 'product_data_storage',\n                updateRequestConfig: {\n                    method: 'GET',\n                    dataType: 'json'\n                },\n                className: 'DataStorage'\n            }\n        },\n\n        /**\n         * Initializes\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            if (window.checkout && window.checkout.baseUrl) {\n                this.initIdsStorage();\n            }\n\n            this.initDataStorage();\n\n            return this;\n        },\n\n        /**\n         * Init ids storage\n         *\n         * @returns {Object} Chainable.\n         */\n        initIdsStorage: function () {\n            storage.onStorageInit(this.identifiersConfig.namespace, this.idsStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init data storage\n         *\n         * @returns {Object} Chainable.\n         */\n        initDataStorage: function () {\n            storage.onStorageInit(this.productStorageConfig.namespace, this.dataStorageHandler.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init data storage handler\n         *\n         * @param {Object} dataStorage - storage instance\n         */\n        dataStorageHandler: function (dataStorage) {\n            this.productStorage = dataStorage;\n            this.productStorage.add(this.data.items);\n        },\n\n        /**\n         * Init ids storage handler\n         *\n         * @param {Object} idsStorage - storage instance\n         */\n        idsStorageHandler: function (idsStorage) {\n            this.idsStorage = idsStorage;\n            this.idsStorage.add(this.getIdentifiers());\n        },\n\n        /**\n         * Gets ids from items\n         *\n         * @returns {Object}\n         */\n        getIdentifiers: function () {\n            var result = {},\n                productCurrentScope = this.data.productCurrentScope,\n                scopeId = productCurrentScope === 'store' ? window.checkout.storeId :\n                    productCurrentScope === 'group' ? window.checkout.storeGroupId :\n                        window.checkout.websiteId;\n\n            _.each(this.data.items, function (item, key) {\n                result[productCurrentScope + '-' + scopeId + '-' + key] = {\n                    'added_at': new Date().getTime() / 1000,\n                    'product_id': key,\n                    'scope_id': scopeId\n                };\n            }, this);\n\n            return result;\n        }\n    });\n});\n","Magento_Catalog/js/product/view/product-ids-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Catalog/js/product/view/product-ids'\n], function (_, productIds) {\n    'use strict';\n\n    /**\n     * Returns id's of products in form.\n     *\n     * @param {jQuery} $form\n     * @return {Array}\n     */\n    return function ($form) {\n        var idSet = productIds(),\n            product = _.findWhere($form.serializeArray(), {\n            name: 'product'\n        });\n\n        if (!_.isUndefined(product)) {\n            idSet.push(product.value);\n        }\n\n        return _.uniq(idSet);\n    };\n});\n","Magento_Catalog/js/view/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.template = window.checkout.imageTemplate || this.template;\n        }\n    });\n});\n","Magento_Catalog/js/view/compare-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'jquery',\n    'underscore',\n    'mage/mage',\n    'mage/decorate'\n], function (Component, customerData, $, _) {\n    'use strict';\n\n    var sidebarInitialized = false,\n        compareProductsReloaded = false;\n\n    /**\n     * Initialize sidebar\n     */\n    function initSidebar() {\n        if (sidebarInitialized) {\n            return;\n        }\n\n        sidebarInitialized = true;\n        $('[data-role=compare-products-sidebar]').decorate('list', true);\n    }\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.compareProducts = customerData.get('compare-products');\n            if (!compareProductsReloaded\n                && !_.isEmpty(this.compareProducts())\n                //Expired section names are reloaded on page load\n                && _.indexOf(customerData.getExpiredSectionNames(), 'compare-products') === -1\n                && window.checkout\n                && window.checkout.websiteId\n                && window.checkout.websiteId !== this.compareProducts().websiteId\n            ) {\n                //set count to 0 to prevent \"compared products\" blocks and count to show with wrong count and items\n                this.compareProducts().count = 0;\n                customerData.reload(['compare-products'], false);\n                compareProductsReloaded = true;\n            }\n            initSidebar();\n        }\n    });\n});\n","Magento_Catalog/product/view/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/validation/validation'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.validation', $.mage.validation, {\n        options: {\n            radioCheckboxClosest: 'ul, ol'\n        },\n\n        /**\n         * @param {*} error\n         * @param {HTMLElement} element\n         */\n        errorPlacement: function (error, element) {\n            var messageBox,\n                dataValidate;\n\n            if ($(element).hasClass('datetime-picker')) {\n                element = $(element).parent();\n\n                if (element.parent().find('.mage-error').length) {\n                    return;\n                }\n            }\n\n            if (element.attr('data-errors-message-box')) {\n                messageBox = $(element.attr('data-errors-message-box'));\n                messageBox.html(error);\n\n                return;\n            }\n\n            dataValidate = element.attr('data-validate');\n\n            if (dataValidate && dataValidate.indexOf('validate-one-checkbox-required-by-name') > 0) {\n                error.appendTo('#links-advice-container');\n            } else if (element.is(':radio, :checkbox')) {\n                element.closest(this.radioCheckboxClosest).after(error);\n            } else {\n                element.after(error);\n            }\n        },\n\n        /**\n         * @param {HTMLElement} element\n         * @param {String} errorClass\n         */\n        highlight: function (element, errorClass) {\n            var dataValidate = $(element).attr('data-validate');\n\n            if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                $(element).parent().find('.datetime-picker').each(function () {\n                    $(this).removeClass(errorClass);\n\n                    if ($(this).val().length === 0) {\n                        $(this).addClass(errorClass);\n                    }\n                });\n            } else if ($(element).is(':radio, :checkbox')) {\n                $(element).closest(this.radioCheckboxClosest).addClass(errorClass);\n            } else {\n                $(element).addClass(errorClass);\n            }\n        },\n\n        /**\n         * @param {HTMLElement} element\n         * @param {String} errorClass\n         */\n        unhighlight: function (element, errorClass) {\n            var dataValidate = $(element).attr('data-validate');\n\n            if (dataValidate && dataValidate.indexOf('validate-required-datetime') > 0) {\n                $(element).parent().find('.datetime-picker').removeClass(errorClass);\n            } else if ($(element).is(':radio, :checkbox')) {\n                $(element).closest(this.radioCheckboxClosest).removeClass(errorClass);\n            } else {\n                $(element).removeClass(errorClass);\n            }\n        }\n    });\n\n    return $.mage.validation;\n});\n","Magento_PaymentServicesPaypal/js/order-review.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function ($, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            element: null,\n            placeOrderButtonSelector: '#review-button',\n            shippingMethodFormSelector: '#shipping-method-form',\n            shippingMethodInputSelector: '#shipping-method',\n            updateContainerSelector: '#details-reload',\n            waitLoadingContainer: '#review-please-wait',\n            orderFormSelector: '#order-review-form',\n            editShoppingCartSelector: '.magento-payments-review-items .edit',\n            updateShippingMethodUrl: null,\n            placeOrderUrl: null,\n            canEditShippingMethod: false,\n            isVirtual: false\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config, element) {\n            this._super();\n            this.element = element;\n\n            $(this.placeOrderButtonSelector).on('click', this.submitOrder.bind(this));\n            $(this.editShoppingCartSelector).on('click', this.invalidateCustomerData.bind(this));\n\n            if (!this.isVirtual && this.canEditShippingMethod) {\n                $(this.shippingMethodInputSelector).on('change', this.selectShippingMethod.bind(this));\n                this.setPlaceOrderButtonActive(!!$(this.shippingMethodInputSelector).val());\n            }\n        },\n\n        invalidateCustomerData: function () {\n            customerData.invalidate(['cart']);\n        },\n\n        /**\n         * Before request start\n         */\n        beforeRequestStart: function () {\n            $(this.waitLoadingContainer).show();\n        },\n\n        /**\n         * On request complete\n         */\n        onRequestComplete: function () {\n            $(this.waitLoadingContainer).hide();\n        },\n\n        /**\n         * Submit order\n         */\n        submitOrder: function () {\n            if (this.validateForm()) {\n                this.beforeRequestStart();\n                $(this.orderFormSelector).trigger('submit');\n                this.setPlaceOrderButtonActive(false);\n            }\n        },\n\n        /**\n         * Validate form\n         */\n        validateForm: function () {\n            return $(this.element).validation().valid();\n        },\n\n        /**\n         * Enable/disable order button\n         *\n         * @param {Boolean} isActive\n         */\n        setPlaceOrderButtonActive: function (isActive) {\n            $(this.placeOrderButtonSelector).prop('disabled', !isActive).toggleClass('no-checkout', !isActive);\n        },\n\n        /**\n         * Select shipping method\n         */\n        selectShippingMethod: function () {\n            var shippingMethod,\n                formData,\n                responseCallback;\n\n            if ($(this.waitLoadingContainer).is(':visible')) {\n                return false;\n            }\n            shippingMethod = $(this.shippingMethodInputSelector).val();\n            shippingMethod = shippingMethod.trim();\n            this.setPlaceOrderButtonActive(false);\n\n            if (shippingMethod) {\n                formData = $(this.shippingMethodFormSelector).serialize() + '&isAjax=true';\n\n                /**\n                 * @param {Object} response\n                 */\n                responseCallback = function (response) {\n                    if (typeof response.redirectUrl == 'undefined') {\n                        $(this.updateContainerSelector).html(response.html);\n                    } else {\n                        window.location = response.redirectUrl;\n                    }\n                    this.setPlaceOrderButtonActive(true);\n                    this.onRequestComplete();\n                };\n                $.ajax({\n                    url: this.updateShippingMethodUrl,\n                    type: 'post',\n                    context: this,\n                    beforeSend: this.beforeRequestStart,\n                    data: formData,\n                    success: responseCallback\n                });\n            }\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/model/payment-service-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'underscore',\n    'mage/utils/wrapper'\n], function (_, wrapper) {\n    'use strict';\n\n    /**\n     * Free method filter\n     * @param {Object} paymentMethod\n     * @return {Boolean}\n     */\n    var paymentServicesMethods = [\n            'payment_services_paypal_smart_buttons',\n            'payment_services_paypal_apple_pay',\n            'payment_services_paypal_google_pay',\n            'payment_services_paypal_hosted_fields'\n        ],\n\n        /**\n         * Check if payment method is from payment services.\n         *\n         * @param {String} needleName\n         * @param {String} paymentMethod\n         * @returns {Boolean}\n         */\n        isPaymentServicesButtonsPaymentMethod = function (needleName, paymentMethod) {\n            return paymentMethod.method === needleName;\n        },\n\n        /**\n         * Check if Apple Pay method is available.\n         */\n        checkApplePayAvailability = function () {\n            window.checkoutConfig.payment['payment_services_paypal_apple_pay'].isVisible = !!(\n                window.checkoutConfig.payment['payment_services_paypal_apple_pay'].isVisible &&\n                window.ApplePaySession\n            );\n            !window.ApplePaySession && console.log('Apple Pay is not supported or not available');\n        },\n\n        extender = {\n            /**\n             * Filter hidden payment methods.\n             *\n             * @param {Function} originFn - Original method.\n             * @param {Array} methods\n             */\n            setPaymentMethods: function (originFn, methods) {\n                var paymentServicesButtonMethodIndex;\n\n                checkApplePayAvailability();\n\n                _.each(paymentServicesMethods, function (paymentMethod) {\n                    if (!window.checkoutConfig.payment[paymentMethod].isVisible) {\n                        paymentServicesButtonMethodIndex = _.findIndex(\n                            methods,\n                            isPaymentServicesButtonsPaymentMethod.bind(null, paymentMethod)\n                        );\n                        paymentServicesButtonMethodIndex >= 0 && methods.splice(paymentServicesButtonMethodIndex, 1);\n                    }\n                });\n\n                return originFn(methods);\n            }\n    };\n\n    return function (target) {\n        return wrapper.extend(target, extender);\n    };\n});\n","Magento_PaymentServicesPaypal/js/view/customer_account/vault/add-card-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    \"jquery\",\n    \"underscore\",\n    \"uiComponent\",\n    \"scriptLoader\",\n    'Magento_PaymentServicesPaypal/js/lib/script-loader',\n    'mage/translate',\n    'Magento_Customer/js/customer-data',\n], function ($, _, Component, loadSdkScript, scriptLoader, $t, customerData) {\n    \"use strict\";\n\n    const cardFormSubmitButton = document.getElementById(\"paymentservices-add-card-button\");\n    const paymentServicesAddVaultCardContainer = document.getElementById(\"paymentservices_add_vault_card\");\n    const cardFormAddress = $(\".form-address-edit\")\n\n    return Component.extend({\n        defaults: {\n            template: \"Magento_PaymentServicesPaypal/customer_account/vault/add-card-form\",\n            componentParams: null,\n            paymentsSdk: null,\n            paymentsSdkInitPromise: null,\n            invalidFields: [],\n            emptyErrorMessage: $t('This is a required field.'),\n            fields: {\n                number: {\n                    errorMessage: $t('Please enter a valid credit card number.'),\n                },\n                expirationDate: {\n                    errorMessage: $t('Incorrect credit card expiration date.'),\n                },\n                cvv: {\n                    errorMessage: $t('Please enter a valid credit card security code.'),\n                }\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super()\n                .observe('invalidFields');\n\n            this.initPaymentsSDK(this.componentParams);\n\n            return this;\n        },\n\n        initPaymentsSDK: function ({ paymentsSDKUrl, storeViewCode, oauthToken, graphQLEndpointUrl }) {\n            this.showLoader(true);\n            this.paymentsSdkInitPromise = scriptLoader\n                .loadCustom({url: paymentsSDKUrl})\n                .then(async () => {\n                    const sdkConfig = {\n                        storeViewCode: storeViewCode\n                    }\n\n                    if (oauthToken) {\n                        sdkConfig.getCustomerToken = () => oauthToken;\n                    }\n\n                    if (graphQLEndpointUrl) {\n                        sdkConfig.apiUrl = graphQLEndpointUrl;\n                    }\n\n                    this.paymentsSdk = new PaymentServicesSDK(sdkConfig)\n                    await this.paymentsSdk.Vault.init()\n                });\n        },\n\n        /**\n         * @inheritdoc\n         */\n        afterRender: function () {\n            this.paymentsSdkInitPromise.then(async () => {\n\n                this.showLoader(false);\n\n                if (!this.paymentsSdk.Vault.CreditCard.isAvailable()) {\n                    paymentServicesAddVaultCardContainer.innerHTML = this.displayMessage($t(\"CreditCard Vault is not available.\"), 'error');\n                    return;\n                }\n\n                await this.paymentsSdk.Vault.CreditCard.render({\n                    styles: {\n                        input: {\n                            'font-family': '\"Open Sans\",\"Helvetica Neue\",Helvetica,Arial,sans-serif',\n                            'font-size': '14px',\n                            'font-weight': '400',\n                            'border': '1px solid #c2c2c2',\n                            'border-radius': '1px',\n                            'padding': '0 9px',\n                            'height': '32px',\n                            'width': '100%',\n                            'box-sizing': 'border-box',\n                        },\n                        ':focus': {\n                            color: '#333'\n                        },\n                        '.valid': {\n                            color: '#333'\n                        },\n                        '.invalid': {\n                            'color': '#ed8380',\n                            'box-shadow': 'none'\n                        },\n                        body: {\n                            'margin': '0',\n                            'padding': '0',\n                        },\n                        // Remove card icon\n                        \"input.card-field-number.display-icon + .card-icon\": {\n                            display: \"none !important\",\n                            height: \"0\",\n                        },\n                        // Unindent card number\n                        \"input.card-field-number.display-icon\": {\n                            padding: \"0 9px !important\",\n                        },\n                    },\n                    fields: {\n                        description: {selector: \"#card-vault-container #vault-card-description\"},\n                        number: {selector: \"#card-vault-container #vault-card-number\"},\n                        expirationDate: {selector: \"#card-vault-container #vault-expiration-date\"},\n                        cvv: {selector: \"#card-vault-container #vault-cvv\"},\n                    },\n                    onError: (error) => {\n                        this.addMessage($t(\"Error while vaulting the card, please try again.\"), \"error\");\n                        console.error(error.message)\n                        this.showLoader(false);\n                    },\n                    onCancel: () => {\n                        console.debug(\"user cancelled the card vaulting process\");\n                        this.showLoader(false);\n                    },\n                    getBillingAddress: this.getBillingAddress.bind(this),\n                    onSuccess: () => {\n                        this.showLoader(false);\n                        paymentServicesAddVaultCardContainer.innerHTML = this.displayMessage($t('Card vaulted successfully. Please wait to be redirected to the Stored Payment Methods page.'), 'success');\n\n                        // Redirect to saved card list page\n                        setTimeout(() => {\n                            window.location.replace(this.componentParams.savedCardListUrl);\n                        }, 3000);\n                    },\n                    onValidityChange: this.onValidityChange.bind(this),\n                }).then((creditCardVault) => {\n                    cardFormSubmitButton.addEventListener(\"click\", () => {\n\n                        // Display errors for card fields\n                        if (!creditCardVault.isFormValid()) {\n                            var fields = creditCardVault.getFormState();\n                            Object.keys(fields).forEach((field) => {\n                                this.onValidityChange(fields, field);\n                            })\n                            creditCardVault.submit();\n                        }\n\n                        // Validate the address form\n                        if (!cardFormAddress.validation() || !cardFormAddress.validation('isValid')) {\n                            this.showLoader(false);\n                            return;\n                        }\n\n                        if (creditCardVault.isFormValid()) {\n                            this.showLoader(true);\n                            creditCardVault.submit();\n                        }\n                    });\n                }).catch((e) => {\n                    this.showLoader(false);\n                    this.addMessage($t(\"Error rendering Payment SDK, please reload the page and try again.\"), \"error\");\n                    console.error('Error rendering Payments SDK', e);\n                });\n            }).catch((error) => {\n                this.showLoader(false);\n                paymentServicesAddVaultCardContainer.innerHTML = this.displayMessage($t(\"Error initializing Payment SDK, please reload the page and try again.\"), 'error');\n                console.error(\"Error initializing Payment SDK:\", error);\n            });\n        },\n\n        /**\n         * Provide the billing address from the form\n         */\n        getBillingAddress: function () {\n            const regionInput = cardFormAddress.find(\"[name='region']\").val();\n            const regionIdDropdown = cardFormAddress.find(\"[name='region_id']\");\n            const regionIdValue = regionIdDropdown.val();\n            const regionIdLabel = regionIdDropdown.val() ? regionIdDropdown.find(`option[value='${regionIdValue}']`).text() : \"\";\n\n            return {\n                firstName: cardFormAddress.find(\"[name='firstname']\").val(),\n                lastName: cardFormAddress.find(\"[name='lastname']\").val(),\n                streetAddress: cardFormAddress.find(\"[name='street[0]']\").val(),\n                extendedAddress: cardFormAddress.find(\"[name='street[1]']\").val(),\n                region: regionIdDropdown.prop('disabled') ? regionInput : regionIdLabel,\n                locality: cardFormAddress.find(\"[name='city']\").val(),\n                postalCode: cardFormAddress.find(\"[name='postcode']\").val(),\n                countryCodeAlpha2: cardFormAddress.find(\"[name='country_id']\").val(),\n            };\n        },\n\n        /**\n         * Show/hide loader.\n         *\n         * @param {Boolean} show\n         */\n        showLoader: function (show) {\n            var event = show ? 'processStart' : 'processStop';\n\n            $('body').trigger(event);\n        },\n\n        /**\n         * Add message to customer data.\n         *\n         * @param {String} message\n         * @param {String} [type]\n         */\n        addMessage: function (message, type) {\n            type = type || 'error';\n            customerData.set('messages', {\n                messages: [{\n                    type: type,\n                    text: message\n                }],\n                'data_id': Math.floor(Date.now() / 1000)\n            });\n        },\n\n        onValidityChange: function (fields, emittedBy) {\n            var valid = _.every(fields, function (field) {\n                return field.isValid\n            });\n\n            var invalidFields = this.invalidFields().filter(field => field.name !== emittedBy);\n\n            if (!valid) {\n                if (fields[emittedBy] && !fields[emittedBy].isValid) {\n                    invalidFields.push({\n                        name: emittedBy,\n                        message: fields[emittedBy].isEmpty ? this.emptyErrorMessage : this.fields[emittedBy].errorMessage\n                    });\n                }\n                this.invalidFields(invalidFields)\n            } else {\n                this.invalidFields([]);\n            }\n        },\n\n        isFieldValid: function (fieldName) {\n            return !this.invalidFields.findWhere({\n                name: fieldName\n            });\n        },\n\n        getFieldErrorMessage: function (fieldName) {\n            return !this.isFieldValid(fieldName) ? this.invalidFields.findWhere({\n                name: fieldName\n            }).message : '';\n        },\n\n        displayMessage: function (text, type) {\n            return `<div class=\"${type} message\"><div>${$t(text)}</div></div>`;\n        },\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/customer_account/vault/add-card-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.cards', {\n        /**\n         * Bind event handlers for adding cards.\n         * @private\n         */\n        _create: function () {\n            let options = this.options;\n            let addCard = options.addCard;\n\n            if (addCard) {\n                $(document).on('click', addCard, this._addCard.bind(this));\n            }\n        },\n\n        /**\n         * Add a new card.\n         * @private\n         */\n        _addCard: function () {\n            window.location = this.options.addCardLocation;\n        }\n    });\n\n    return $.mage.cards;\n});\n","Magento_PaymentServicesPaypal/js/view/payment/message-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaymentServicesPaypal/js/view/payment/paypal-abstract',\n    'Magento_PaymentServicesPaypal/js/view/payment/message',\n    'Magento_Customer/js/customer-data'\n], function (Component, Message, customerData) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalCart',\n            element: null,\n            message: null\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config, element) {\n            var cartData = customerData.get('cart');\n\n            this.element = element;\n            this._super();\n            this.getSdkParams()\n                .then(this.initMessage.bind(this))\n                .then(function () {\n                    cartData.subscribe(function (updatedCart) {\n                        this.message.updateAmount(updatedCart.subtotalAmount);\n                    }, this);\n                }.bind(this))\n                .then(this.render.bind(this));\n\n        },\n\n        /**\n         * Create instance of messages.\n         */\n        initMessage: function () {\n            var cartData = customerData.get('cart');\n\n            this.message = new Message({\n                sdkNamespace: this.sdkNamespace,\n                scriptParams: this.sdkParams,\n                element: this.element,\n                renderContainer: this.renderContainer,\n                styles: this.styles,\n                placement: this.placement,\n                amount: cartData().subtotalAmount\n            });\n        },\n\n        /**\n         * Render message\n         */\n        render: function () {\n            this.message.render();\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/smart-buttons-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'Magento_PaymentServicesPaypal/js/view/payment/paypal-abstract',\n    'scriptLoader',\n    'Magento_PaymentServicesPaypal/js/view/payment/methods/smart-buttons',\n    'mage/translate',\n    'Magento_Customer/js/customer-data',\n    'Magento_PaymentServicesPaypal/js/view/errors/response-error',\n    'jquery/jquery-storageapi'\n], function (_, $, utils, Component, loadSdkScript, SmartButtons, $t, customerData, ResponseError) {\n    'use strict';\n\n    var refreshCustomerData = function (url) {\n        // Trigger ajaxComplete event to update customer data\n        customerData.onAjaxComplete(\n            {},\n            {\n                type: 'POST',\n                url: url,\n            }\n        );\n    }\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalProduct',\n            buttonsContainerId: 'smart-buttons-${ $.uid }',\n            element: null,\n            productFormSelector: '#product_addtocart_form',\n            formInvalid: false,\n            paymentActionError: $t('Something went wrong with your request. Please try again later.'),\n            addToCartUrl: null,\n            isErrorDisplayed: false\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config, element) {\n            _.bindAll(this, 'renderButtons', 'initSmartButtons', 'onClick', 'catchError', 'beforeCreateOrder',\n                'afterCreateOrder', 'beforeOnAuthorize', 'afterOnAuthorize', 'onCancel');\n            config.uid = utils.uniqueid();\n            this._super();\n            this.element = element;\n            this.element.id = this.buttonsContainerId;\n            this.getSdkParams()\n                .then(this.initSmartButtons)\n                .then(this.renderButtons)\n                .catch(function (e) {\n                    console.log(e);\n                });\n\n            return this;\n        },\n\n        /**\n         * Create instance of smart buttons.\n         */\n        initSmartButtons: function () {\n            this.buttons = new SmartButtons({\n                sdkNamespace: this.sdkNamespace,\n                scriptParams: this.sdkParams,\n                styles: this.styles,\n                createOrderUrl: this.createOrderUrl,\n                authorizeOrderUrl: this.authorizeOrderUrl,\n                onClick: this.onClick,\n                beforeCreateOrder: this.beforeCreateOrder,\n                afterCreateOrder: this.afterCreateOrder,\n                catchCreateOrder: this.catchError,\n                finallyCreateOrder: this.showLoader.bind(this, false),\n                beforeOnAuthorize: this.beforeOnAuthorize,\n                afterOnAuthorize: this.afterOnAuthorize,\n                catchOnAuthorize: this.catchError,\n                finallyOnAuthorize: this.showLoader.bind(this, false),\n                onError: this.catchError,\n                onCancel: this.onCancel,\n                location: this.pageType,\n            });\n        },\n\n        /**\n         * Render buttons\n         */\n        renderButtons: function () {\n            this.buttons.sdkLoaded.then(function () {\n                try {\n                    this.buttons && this.buttons.render('#' + this.buttonsContainerId);\n                } catch (e) {\n                    console.log(e);\n                }\n            }.bind(this)).catch(function () {\n                console.log('Error: Failed to load PayPal SDK script!');\n            });\n        },\n\n        /**\n         * Show/hide loader.\n         *\n         * @param {Boolean} show\n         */\n        showLoader: function (show) {\n            var event = show ? 'processStart' : 'processStop';\n\n            $('body').trigger(event);\n        },\n\n        /**\n         * Catch errors.\n         *\n         * @param {*} error\n         */\n        catchError: function (error) {\n            var message = error instanceof ResponseError ? error.message : this.paymentActionError;\n\n            this.showLoader(false);\n\n            if (this.isErrorDisplayed) {\n                return;\n            }\n            this.addMessage(message);\n            this.isErrorDisplayed = true;\n        },\n\n        /**\n         * Add message to customer data.\n         *\n         * @param {String} message\n         * @param {String} [type]\n         */\n        addMessage: function (message, type) {\n            type = type || 'error';\n            customerData.set('messages', {\n                messages: [{\n                    type: type,\n                    text: message\n                }],\n                'data_id': Math.floor(Date.now() / 1000)\n            });\n        },\n\n        /**\n         * Calls when user click paypal button\n         *\n         * @param {Object} data\n         * @param {Promise} actions\n         * @return {Promise}\n         */\n        onClick: function (data, actions) {\n            var $form = $(this.productFormSelector);\n\n            if ($form.data('mageValidation')) {\n                this.formInvalid = !$form.validation('isValid');\n            }\n\n            if (this.formInvalid) {\n                return actions.reject();\n            }\n\n            return actions.resolve();\n        },\n\n        /**\n         * Before create order.\n         *\n         * @return {Promise}\n         */\n        beforeCreateOrder: function () {\n            this.isErrorDisplayed = false;\n            this.showLoader(true);\n\n            return new Promise(function (resolve, reject) {\n                if (this.formInvalid) {\n                    return reject();\n                }\n\n                fetch(this.addToCartUrl, {\n                    method: 'POST',\n                    headers: {},\n                    body: new FormData($(this.productFormSelector)[0]),\n                    credentials: 'same-origin'\n                }).then(function (response) {\n                    return response.json();\n                }).then(function (data) {\n                    if (typeof data.success !== 'undefined') {\n                        refreshCustomerData(this.addToCartUrl);\n\n                        return resolve();\n                    }\n\n                    return reject(new ResponseError(data.error));\n                }.bind(this)).catch(function () {\n                    return reject();\n                });\n            }.bind(this));\n        },\n\n        /**\n         * After order id created.\n         *\n         * @param {Object} res\n         * @return {*}\n         */\n        afterCreateOrder: function (res) {\n            if (res.response['is_successful']) {\n                refreshCustomerData(this.createOrderUrl);\n\n                return res.response['paypal-order'].id;\n            }\n\n            throw new ResponseError(res.response.error);\n        },\n\n        /**\n         * Before onAuthorize execute\n         *\n         * @param {Object} data\n         * @return {Promise}\n         */\n        beforeOnAuthorize: function (data) {\n            this.showLoader(true);\n\n            return Promise.resolve(data);\n        },\n\n        /**\n         * After onAuthorize execute\n         *\n         * @param {Object} res\n         * @param {Object} actions\n         * @return {*}\n         */\n        afterOnAuthorize: function (res, actions) {\n            if (res.success) {\n                return actions.redirect(res.redirectUrl);\n            }\n\n            throw new ResponseError(res.error);\n        },\n\n        /**\n         * Redirect to cart on cancel.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         */\n        onCancel: function (data, actions) {\n            customerData.invalidate(['cart']);\n            actions.redirect(this.cancelUrl);\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/google-pay-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'Magento_PaymentServicesPaypal/js/view/payment/paypal-abstract',\n    'mage/translate',\n    'Magento_Customer/js/customer-data',\n    'Magento_PaymentServicesPaypal/js/view/errors/response-error',\n    'Magento_PaymentServicesPaypal/js/view/payment/methods/google-pay'\n], function (_, $, utils, Component, $t, customerData, ResponseError, GooglePayButton) {\n    'use strict';\n\n    var refreshCustomerData = function (url) {\n        // Trigger ajaxComplete event to update customer data\n        customerData.onAjaxComplete(\n            {},\n            {\n                type: 'POST',\n                url: url,\n            }\n        );\n    }\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalGooglePay',\n            sdkParamsKey: 'googlepay',\n            buttonContainerId: 'google-pay-${ $.uid }',\n            paymentActionError: $t('Something went wrong with your request. Please try again later.'),\n            isErrorDisplayed: false\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config, element) {\n            _.bindAll(this, 'initGooglePayButton', 'onClick',\n                'afterOnAuthorize', 'catchError', 'onCancel');\n            config.uid = utils.uniqueid();\n            this._super();\n            this.element = element;\n            this.element.id = this.buttonContainerId;\n            this.getSdkParams()\n                .then(this.initGooglePayButton)\n                .catch(console.log);\n\n            return this;\n        },\n\n        initGooglePayButton: function () {\n            this.googlePayButton = new GooglePayButton({\n                scriptParams: this.sdkParams,\n                createOrderUrl: this.createOrderUrl,\n                updateQuoteUrl: this.authorizeOrderUrl,\n                onClick: this.onClick,\n                catchCreateOrder: this.catchError,\n                onError: this.catchError,\n                buttonContainerId: this.buttonContainerId,\n                afterOnAuthorize: this.afterOnAuthorize,\n                shippingAddressRequired: !this.isVirtual,\n                styles: this.styles,\n                onCancel: this.onCancel,\n                mode: this.googlePayMode,\n                getOrderDetailsUrl: this.getOrderDetailsUrl,\n                threeDSMode: this.threeDSMode,\n                location: this.pageType,\n            });\n\n            this.googlePayButton.sdkLoaded\n                .then(this.googlePayButton.initGoogleSDK);\n        },\n\n        afterOnAuthorize: function (data) {\n            window.location = data.redirectUrl;\n            this.googlePayButton.showLoader(false);\n        },\n\n        onClick: function () {\n            this.isErrorDisplayed = false;\n\n            this.googlePayButton.showLoaderAsync(true)\n                .then(() => {\n                    return this.googlePayButton.createOrder();\n                })\n                .then(() => {\n                    refreshCustomerData(this.createOrderUrl);\n                })\n                .catch(error => {\n                    this.catchError(error);\n                });\n        },\n\n        /**\n         * Catch errors.\n         *\n         * @param {*} error\n         */\n        catchError: function (error) {\n            var message = error instanceof ResponseError ? error.message : this.paymentActionError;\n\n            console.log(error);\n\n            this.googlePayButton.showLoader(false);\n\n            if (this.isErrorDisplayed) {\n                return;\n            }\n\n            if (error.hidden === undefined || !error.hidden) {\n                this.addMessage(message);\n            }\n\n            this.isErrorDisplayed = true;\n        },\n\n        /**\n         * Add message to customer data.\n         *\n         * @param {String} message\n         * @param {String} [type]\n         */\n        addMessage: function (message, type) {\n            type = type || 'error';\n            customerData.set('messages', {\n                messages: [{\n                    type: type,\n                    text: message\n                }],\n                'data_id': Math.floor(Date.now() / 1000)\n            });\n        },\n\n        /**\n         * Redirect to cart on cancel.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         */\n        onCancel: function () {\n            customerData.invalidate(['cart']);\n            window.location = this.cancelUrl;\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'scriptLoader'\n], function ($, Component, loadSdkScript) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypal',\n            renderContainer: null,\n            amountAttribute: 'data-pp-amount',\n            amount: null\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            this.sdkLoaded = loadSdkScript(this.scriptParams, this.sdkNamespace);\n\n            return this;\n        },\n\n        /**\n         * Update amount\n         *\n         * @param {*} amount\n         */\n        updateAmount: function (amount) {\n            this.amount = amount;\n            $(this.renderContainer).attr(this.amountAttribute, this.amount);\n        },\n\n        /**\n         * Render message\n         *\n         * @return {Promise}\n         */\n        render: function () {\n            return this.sdkLoaded.then(function (sdkScript) {\n                sdkScript.Messages({\n                    amount: parseFloat(this.amount).toFixed(2),\n                    placement: this.placement,\n                    style: this.styles\n                })\n                .render(this.renderContainer);\n            }.bind(this)).catch(function (exception) {\n                console.log('Error: Failed to load PayPal SDK script!');\n                console.log(exception.message);\n            });\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/apple-pay-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'Magento_PaymentServicesPaypal/js/view/payment/paypal-abstract',\n    'mage/translate',\n    'Magento_Customer/js/customer-data',\n    'Magento_PaymentServicesPaypal/js/view/errors/response-error',\n    'Magento_PaymentServicesPaypal/js/view/payment/methods/apple-pay',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/cart/totals-processor/default',\n    'Magento_Customer/js/model/customer',\n], function (_, $, utils, Component, $t, customerData, ResponseError, ApplePayButton, quote, totalsProcessor, customer) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalApplePay',\n            sdkParamsKey: 'applepay',\n            buttonContainerId: 'apple-pay-${ $.uid }',\n            paymentActionError: $t('Something went wrong with your request. Please try again later.'),\n            isErrorDisplayed: false\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config, element) {\n            _.bindAll(this, 'initApplePayButton', 'onClick', 'afterOnAuthorize',  'afterCreateOrder', 'showPopup', 'cancelApplePay');\n            config.uid = utils.uniqueid();\n            this._super();\n            this.element = element;\n            this.element.id = this.buttonContainerId;\n\n            this.getSdkParams()\n                .then(this.initApplePayButton)\n                .catch(console.log);\n\n            return this;\n        },\n\n        initApplePayButton: function () {\n            this.applePayButton = new ApplePayButton({\n                scriptParams: this.sdkParams,\n                createOrderUrl: this.createOrderUrl,\n                estimateShippingMethodsWhenLoggedInUrl: this.estimateShippingMethodsWhenLoggedInUrl,\n                estimateShippingMethodsWhenGuestUrl: this.estimateShippingMethodsWhenGuestUrl,\n                shippingInformationWhenLoggedInUrl: this.shippingInformationWhenLoggedInUrl,\n                shippingInformationWhenGuestUrl: this.shippingInformationWhenGuestUrl,\n                updatePaypalOrderUrl: this.updatePaypalOrderUrl,\n                countriesUrl: this.countriesUrl,\n                placeOrderUrl: this.placeOrderUrl,\n                showPopup: this.showPopup,\n                updateQuoteUrl: this.authorizeOrderUrl,\n                onClick: this.onClick,\n                afterCreateOrder: this.afterCreateOrder,\n                catchCreateOrder: this.catchError,\n                onError: this.catchError,\n                buttonContainerId: this.buttonContainerId,\n                afterOnAuthorize: this.afterOnAuthorize,\n                shippingAddressRequired: !this.isVirtual,\n                styles: this.styles,\n                location: this.pageType,\n            });\n\n            $('#' + this.buttonContainerId).on('click', this.onClick);\n\n            this.applePayButton.sdkLoaded\n                .then(this.applePayButton.initAppleSDK);\n        },\n\n        afterOnAuthorize: function (data) {\n\n            this.applePayButton.showLoaderAsync(true)\n            .then(() => {\n                fetch(this.placeOrderUrl, {\n                    method: 'POST'\n                }).then(response => {\n                    if (response.redirected && response.url.includes(\"review\")) {\n                        throw new Error();\n                    }\n                    return response.text();\n                }).then(result => {\n                    if (result) {\n                        customerData.invalidate(['cart']);\n                        document.open();\n                        document.write(result);\n                        document.close();\n                    }\n                })\n                    .catch(error => {\n                        this.applePayButton.showLoader(false);\n                        this.applePayButton.catchError(error);\n                    });\n            })\n            .catch(error => {\n                this.catchError(error);\n            });\n        },\n\n        onClick: function () {\n            // Reload customer data to use correct loggedin/guest urls in the applepay button\n            // See smart_buttons_minicart.phtml:21-22\n            if (this.location === 'minicart') {\n                this.fixCustomerData();\n            }\n\n            // Show popup with initial order amount from window.checkoutConfig\n            // See smart_buttons_minicart.phtml:20\n            this.applePayButton.showLoaderAsync(true).then(() => {\n                const data = {\n                    response: {\n                        'paypal-order': {\n                            currency_code: window.checkoutConfig.quoteData.base_currency_code,\n                            amount: window.checkoutConfig.quoteData.grand_total.toString(),\n                        }\n                    }\n                }\n                this.applePayButton.showPopup(data);\n            })\n\n            this.isErrorDisplayed = false;\n        },\n\n        /**\n         * After order created.\n         *\n         * @param {Object} data\n         * @return {String}\n         */\n        afterCreateOrder: function (data) {\n            if (data.response['paypal-order'] && data.response['paypal-order']['mp_order_id']) {\n                this.paymentsOrderId = data.response['paypal-order']['mp_order_id'];\n                this.paypalOrderId = data.response['paypal-order'].id;\n                return this.paypalOrderId;\n            }\n\n            throw new Error();\n        },\n\n        cancelApplePay: function (){\n            customerData.invalidate(['cart']);\n            window.location.reload();\n        },\n\n        showPopup: function (paymentData) {\n            const paymentRequest = {\n                countryCode: this.applePayButton.applePayConfig.countryCode,\n                merchantCapabilities: this.applePayButton.applePayConfig.merchantCapabilities,\n                supportedNetworks: this.applePayButton.applePayConfig.supportedNetworks,\n                currencyCode: paymentData.response['paypal-order']['currency_code'],\n                requiredShippingContactFields: [\"name\", \"phone\", \"email\", \"postalAddress\"],\n                requiredBillingContactFields: [\"postalAddress\"],\n                total: {\n                    label: $t(\"Summary\"),\n                    type: \"final\",\n                    amount: Number(paymentData.response['paypal-order']['amount']).toString(),\n                }\n            };\n\n            // See https://developer.apple.com/documentation/apple_pay_on_the_web/applepaysession\n            this.applePaySession = new ApplePaySession(this.applePayButton.applePayVersionNumber, paymentRequest);\n\n            this.applePayButton.onApplePayValidateMerchant(this.applePaySession);\n            this.applePayButton.onApplePayCancel(this.applePaySession, this.cancelApplePay);\n            this.applePayButton.onApplePayShippingContactSelected(this.applePaySession, quote.getQuoteId() , paymentRequest.total, quote.isVirtual());\n            this.applePayButton.onApplePayShippingMethodSelectedInCartPage(this.applePaySession, quote.getQuoteId());\n            this.applePayButton.onApplePayPaymentAuthorized(this.applePaySession);\n\n            this.applePaySession.begin();\n        },\n\n        /**\n         * Fix customer data\n         *\n         * Why do we need this?\n         * See: src/app/code/Magento/Customer/view/frontend/web/js/model/customer.js:17\n         *\n         * When we initialise customer data on the page where the minicart was not rendered yet,\n         * the customer data in the \"window\" object is 'undefined' at first because . This makes this line\n         *      var isLoggedIn = ko.observable(window.isCustomerLoggedIn),\n         * to create an observable of undefined variable, that does not work in knockout.\n         * knockout expects an existing variable to create an observable.\n         *\n         * Later, when we render minicart and update \"window\" object with customer data,\n         * it's not being picked up by customer.js logic and when try to read the data, it's still undefined,\n         * even though it exists in the \"window\" object.\n         *\n         * This function forces the customer data to be updated from the \"window\" object.\n         */\n        fixCustomerData: function () {\n            if (customer.isLoggedIn() === undefined && window.isCustomerLoggedIn !== undefined) {\n                customer.setIsLoggedIn(window.isCustomerLoggedIn);\n            }\n\n            if (customer.isLoggedIn() && _.isEmpty(customer.customerData)) {\n                customer.customerData = window.customerData;\n            }\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/smart-buttons-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'Magento_PaymentServicesPaypal/js/view/payment/paypal-abstract',\n    'scriptLoader',\n    'Magento_PaymentServicesPaypal/js/view/payment/methods/smart-buttons',\n    'mage/translate',\n    'Magento_Customer/js/customer-data',\n    'Magento_PaymentServicesPaypal/js/view/errors/response-error'\n], function (_, $, utils, Component, loadSdkScript, SmartButtons, $t, customerData, ResponseError) {\n    'use strict';\n\n    var refreshCustomerData = function (url) {\n        // Trigger ajaxComplete event to update customer data\n        customerData.onAjaxComplete(\n            {},\n            {\n                type: 'POST',\n                url: url,\n            }\n        );\n    }\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalCart',\n            buttonsContainerId: 'smart-buttons-${ $.uid }',\n            element: null,\n            paymentActionError: $t('Something went wrong with your request. Please try again later.'),\n            isErrorDisplayed: false\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config, element) {\n            _.bindAll(this, 'renderButtons', 'initSmartButtons', 'catchError', 'beforeCreateOrder', 'afterCreateOrder',\n                'beforeOnAuthorize', 'afterOnAuthorize', 'onCancel');\n            config.uid = utils.uniqueid();\n            this._super();\n            this.element = element;\n            this.element.id = this.buttonsContainerId;\n            this.getSdkParams()\n                .then(this.initSmartButtons)\n                .then(this.renderButtons)\n                .catch(function (e) {\n                    console.log(e);\n                });\n\n            return this;\n        },\n\n        /**\n         * Create instance of smart buttons.\n         */\n        initSmartButtons: function () {\n            this.buttons = new SmartButtons({\n                sdkNamespace: this.sdkNamespace,\n                scriptParams: this.sdkParams,\n                styles: this.styles,\n                createOrderUrl: this.createOrderUrl,\n                authorizeOrderUrl: this.authorizeOrderUrl,\n                beforeCreateOrder: this.beforeCreateOrder,\n                afterCreateOrder: this.afterCreateOrder,\n                catchCreateOrder: this.catchError,\n                finallyCreateOrder: this.showLoader.bind(this, false),\n                beforeOnAuthorize: this.beforeOnAuthorize,\n                afterOnAuthorize: this.afterOnAuthorize,\n                catchOnAuthorize: this.catchError,\n                finallyOnAuthorize: this.showLoader.bind(this, false),\n                onError: this.catchError,\n                onCancel: this.onCancel,\n                location: this.pageType,\n            });\n        },\n\n        /**\n         * Render buttons\n         */\n        renderButtons: function () {\n            this.buttons.sdkLoaded.then(function () {\n                this.buttons && this.buttons.render('#' + this.buttonsContainerId);\n            }.bind(this)).catch(function () {\n                console.log('Error: Failed to load PayPal SDK script!');\n            });\n        },\n\n        /**\n         * Show/hide loader.\n         *\n         * @param {Boolean} show\n         */\n        showLoader: function (show) {\n            var event = show ? 'processStart' : 'processStop';\n\n            $('body').trigger(event);\n        },\n\n        /**\n         * Catch errors.\n         *\n         * @param {*} error\n         */\n        catchError: function (error) {\n            var message = error instanceof ResponseError ? error.message : this.paymentActionError;\n\n            this.showLoader(false);\n\n            if (this.isErrorDisplayed) {\n                return;\n            }\n            this.addMessage(message);\n            this.isErrorDisplayed = true;\n        },\n\n        /**\n         * Add message to customer data.\n         *\n         * @param {String} message\n         * @param {String} [type]\n         */\n        addMessage: function (message, type) {\n            type = type || 'error';\n            customerData.set('messages', {\n                messages: [{\n                    type: type,\n                    text: message\n                }],\n                'data_id': Math.floor(Date.now() / 1000)\n            });\n        },\n\n        /**\n         * Before create order.\n         *\n         * @return {Promise}\n         */\n        beforeCreateOrder: function () {\n            this.isErrorDisplayed = false;\n            this.showLoader(true);\n\n            return Promise.resolve();\n        },\n\n        /**\n         * After order id created.\n         *\n         * @param {Object} res\n         * @return {*}\n         */\n        afterCreateOrder: function (res) {\n            if (res.response['is_successful']) {\n                refreshCustomerData(this.createOrderUrl);\n\n                return res.response['paypal-order'].id;\n            }\n\n            throw new ResponseError(res.response.error);\n        },\n\n        /**\n         * Before onAuthorize execute\n         *\n         * @param {Object} data\n         * @return {Promise}\n         */\n        beforeOnAuthorize: function (data) {\n            this.showLoader(true);\n\n            return Promise.resolve(data);\n        },\n\n        /**\n         * After onAuthorize execute\n         *\n         * @param {Object} res\n         * @param {Object} actions\n         * @return {*}\n         */\n        afterOnAuthorize: function (res, actions) {\n            if (res.success) {\n                return actions.redirect(res.redirectUrl);\n            }\n\n            throw new ResponseError(res.error);\n        },\n\n        /**\n         * Redirect to cart on cancel.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         */\n        onCancel: function (data, actions) {\n            customerData.invalidate(['cart']);\n            actions.redirect(this.cancelUrl);\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/method-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    rendererList.push({\n        type: 'payment_services_paypal_hosted_fields',\n        component: 'Magento_PaymentServicesPaypal/js/view/payment/method-renderer/hosted-fields'\n    }, {\n        type: 'payment_services_paypal_smart_buttons',\n        component: 'Magento_PaymentServicesPaypal/js/view/payment/method-renderer/smart-buttons'\n    }, {\n        type: 'payment_services_paypal_apple_pay',\n        component: 'Magento_PaymentServicesPaypal/js/view/payment/method-renderer/apple-pay'\n    }, {\n        type: 'payment_services_paypal_google_pay',\n        component: 'Magento_PaymentServicesPaypal/js/view/payment/method-renderer/google-pay'\n    });\n\n    return Component.extend({});\n});\n","Magento_PaymentServicesPaypal/js/view/payment/message-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PaymentServicesPaypal/js/view/payment/paypal-abstract',\n    'Magento_PaymentServicesPaypal/js/view/payment/message',\n    'Magento_PaymentServicesPaypal/js/view/product/product-data-provider',\n    'Magento_PaymentServicesPaypal/js/view/product/grouped-product-data-provider',\n    'Magento_PaymentServicesPaypal/js/view/product/bundle-product-data-provider',\n    'Magento_PaymentServicesPaypal/js/view/product/gift-card-product-data-provider'\n], function (\n    Component,\n    Message,\n    ProductDataProvider,\n    GroupedProductDataProvider,\n    BundledProductDataProvider,\n    GiftCardProductDataProvider\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalProduct',\n            element: null,\n            message: null\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config, element) {\n            var providerOptions = {\n                updateAmount: this.updateAmount.bind(this)\n            };\n\n            this.element = element;\n            this._super();\n\n            if (GroupedProductDataProvider.prototype.isProductGrouped()) {\n                this.provider = new GroupedProductDataProvider(providerOptions);\n            } else if (BundledProductDataProvider.prototype.isBundleProduct()) {\n                this.provider = new BundledProductDataProvider(providerOptions);\n            }  else if (GiftCardProductDataProvider.prototype.isProductGiftCard()) {\n                this.provider = new GiftCardProductDataProvider(providerOptions);\n            } else {\n                this.provider = new ProductDataProvider(providerOptions);\n            }\n            this.getSdkParams()\n                .then(this.initMessage.bind(this))\n                .then(this.render.bind(this));\n        },\n\n        /**\n         * Create instance of messages.\n         */\n        initMessage: function () {\n            this.message = new Message({\n                sdkNamespace: this.sdkNamespace,\n                scriptParams: this.sdkParams,\n                element: this.element,\n                renderContainer: this.renderContainer,\n                styles: this.styles,\n                placement: this.placement,\n                amount: this.provider.getAmount()\n            });\n        },\n\n        /**\n         * Update message amount.\n         */\n        updateAmount: function () {\n            this.message && this.message.updateAmount(this.provider.getAmount());\n        },\n\n        /**\n         * Render the message\n         */\n        render: function () {\n            this.message.render();\n            this.provider.updatePrice();\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\n/* @api */\ndefine([\n    'underscore',\n    'uiComponent',\n    'mage/translate',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'uiRegistry'\n], function (_, Component, $t, rendererList, layout, registry) {\n    'use strict';\n\n    var vaultGroupName = 'vaultGroup';\n\n    layout([{\n        name: vaultGroupName,\n        component: 'Magento_Checkout/js/model/payment/method-group',\n        alias: 'vault',\n        sortOrder: 10,\n        title: $t('Stored Cards')\n    }]);\n\n    registry.get(vaultGroupName, function (vaultGroup) {\n        _.each(window.checkoutConfig.payment.vault, function (config, index) {\n            rendererList.push(\n                {\n                    type: index,\n                    config: config.config,\n                    component: config.component,\n                    group: vaultGroup,\n\n                    /**\n                     * Custom payment method types comparator\n                     * @param {String} typeA\n                     * @param {String} typeB\n                     * @return {Boolean}\n                     */\n                    typeComparatorCallback: function (typeA, typeB) {\n                        // vault token items have the same name as vault payment without index\n                        return typeA.substring(0, typeA.lastIndexOf('_')) === typeB;\n                    }\n                }\n            );\n        });\n    });\n\n    /**\n     * Add view logic here if needed\n     */\n    return Component.extend({});\n});\n","Magento_PaymentServicesPaypal/js/view/payment/paypal-abstract.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_PaymentServicesPaypal/js/view/payment/actions/get-sdk-params'\n], function (Component, getSdkParams) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            sdkParamsKey: 'paypal',\n            sdkParams: [],\n            cacheTtl: 30000\n        },\n\n        /**\n         * Get sdk params\n         *\n         * @return {Promise<Object>}\n         */\n        getSdkParams: function () {\n            return getSdkParams(this.cacheTtl)\n                .then(function (sdkParams) {\n                    this.sdkParams = sdkParams[this.sdkParamsKey];\n                }.bind(this));\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/apple-pay-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'Magento_PaymentServicesPaypal/js/view/payment/paypal-abstract',\n    'mage/translate',\n    'Magento_Customer/js/customer-data',\n    'Magento_PaymentServicesPaypal/js/view/errors/response-error',\n    'Magento_PaymentServicesPaypal/js/view/payment/methods/apple-pay',\n], function ($, _, utils, Component, $t, customerData, ResponseError, ApplePayButton) {\n    'use strict';\n\n    const HTTP_STATUS_OK = 200;\n\n    var refreshCustomerData = function (url) {\n        // Trigger ajaxComplete event to update customer data\n        customerData.onAjaxComplete(\n            {},\n            {\n                type: 'POST',\n                url: url,\n            }\n        );\n    }\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalApplePay',\n            scriptParams: {},\n            buttonContainerId: 'apple-pay-${ $.uid }',\n            template: 'Magento_PaymentServicesPaypal/payment/apple-pay',\n            paymentsOrderId: null,\n            paypalOrderId: null,\n            sdkLoaded: null,\n            quoteIdForRest: null,\n            quoteId: null,\n            sdkParamsKey: 'applepay',\n            paymentTypeIconTitle: $t('Pay with Apple Pay'),\n            notEligibleErrorMessage: $t('This payment option is currently unavailable.'),\n            productFormSelector: '#product_addtocart_form'\n        },\n\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config, element) {\n            _.bindAll(this, 'initApplePayButton', 'onClick', 'afterUpdateQuote', 'beforeCreateOrder',\n                'afterCreateOrder', 'afterOnAuthorize', 'onCancel');\n            config.uid = utils.uniqueid();\n            this._super();\n            this.element = element;\n            this.element.id = this.buttonContainerId;\n            this.getSdkParams()\n                .then(this.initApplePayButton)\n                .catch(console.log);\n\n            return this;\n        },\n\n        initApplePayButton: function () {\n            this.applePayButton = new ApplePayButton({\n                scriptParams: this.sdkParams,\n                createOrderUrl: this.createOrderUrl,\n                updateQuoteUrl: this.authorizeOrderUrl,\n                shippingInformationWhenGuestUrl: this.shippingInformationWhenGuestUrl,\n                shippingInformationWhenLoggedInUrl: this.shippingInformationWhenLoggedInUrl,\n                estimateShippingMethodsWhenGuestUrl: this.estimateShippingMethodsWhenGuestUrl,\n                estimateShippingMethodsWhenLoggedInUrl: this.estimateShippingMethodsWhenLoggedInUrl,\n                updatePayPalOrderUrl: this.updatePayPalOrderUrl,\n                setQuoteAsInactiveUrl: this.setQuoteAsInactiveUrl,\n                countriesUrl: this.countriesUrl,\n                placeOrderUrl: this.placeOrderUrl,\n                onClick: this.onClick,\n                beforeCreateOrder: this.beforeCreateOrder,\n                afterCreateOrder: this.afterCreateOrder,\n                catchCreateOrder: this.catchError,\n                onError: this.catchError,\n                buttonContainerId: this.buttonContainerId,\n                afterUpdateQuote: this.afterUpdateQuote,\n                shippingAddressRequired: !this.isVirtual,\n                styles: this.styles,\n                afterOnAuthorize: this.afterOnAuthorize,\n                onCancel: this.onCancel,\n                location: this.pageType,\n            });\n\n            $('#' + this.buttonContainerId).on('click', this.onClick);\n\n            this.applePayButton.sdkLoaded\n                .then(this.applePayButton.initAppleSDK);\n        },\n\n        afterUpdateQuote: function (data) {\n            window.location = data.redirectUrl;\n            this.applePayButton.showLoader(false);\n        },\n\n        onClick: function () {\n\n            var $form = $(this.productFormSelector);\n\n            if ($form.data('mageValidation')) {\n                this.formValid = $form.validation('isValid');\n            }\n\n            if (this.formValid) {\n                this.applePayButton.showLoaderAsync(true)\n                    .then(() => {\n                        return this.applePayButton.createOrder();\n                    })\n                    .then(() => {\n                        refreshCustomerData(this.createOrderUrl);\n                    })\n                    .catch(error => {\n                        this.applePayButton.catchError(error);\n                    });\n            }\n        },\n\n        setQuoteInactive: function () {\n            // Set Quote as inactive to avoid having multiple active quotes for the customer\n            $.ajax({\n                type: 'POST',\n                url: this.setQuoteAsInactiveUrl,\n            });\n        },\n\n        showPopup: function (paymentData) {\n\n            const paymentRequest = {\n                countryCode: this.applePayButton.applePayConfig.countryCode,\n                merchantCapabilities: this.applePayButton.applePayConfig.merchantCapabilities,\n                supportedNetworks: this.applePayButton.applePayConfig.supportedNetworks,\n                currencyCode: String(paymentData['currencyCode']),\n                requiredShippingContactFields: [\"name\", \"phone\", \"email\", \"postalAddress\"],\n                requiredBillingContactFields: [\"postalAddress\"],\n                total: {\n                    label: $t(\"Summary\"),\n                    type: \"final\",\n                    amount: Number(paymentData['totalPrice']).toString(),\n                }\n            };\n\n            // See https://developer.apple.com/documentation/apple_pay_on_the_web/applepaysession\n            this.applePaySession = new ApplePaySession(this.applePayButton.applePayVersionNumber, paymentRequest);\n            this.applePayButton.onApplePayValidateMerchant(this.applePaySession);\n            this.applePayButton.onApplePayCancel(this.applePaySession, this.setQuoteInactive.bind(this));\n            this.applePayButton.onApplePayShippingContactSelected(this.applePaySession, this.quoteIdForRest, paymentRequest.total, null);\n            this.applePayButton.onApplePayShippingMethodSelected(this.applePaySession, this.quoteId, this.quoteIdForRest, this.paypalOrderId);\n            this.applePayButton.onApplePayPaymentAuthorized(this.applePaySession);\n\n            this.applePaySession.begin();\n        },\n\n        /**\n         * Before create order.\n         *\n         * @return {String}\n         */\n        beforeCreateOrder: function () {\n            if (this.formInvalid) {\n                throw new Error('Form is Invalid');\n            }\n\n            let xhr = new XMLHttpRequest();\n            xhr.open('POST', this.addToCartUrl, false);\n            xhr.send(new FormData($(this.productFormSelector)[0]));\n\n            if (xhr.status !== HTTP_STATUS_OK) {\n                throw new Error('Request failed');\n            } else {\n                try {\n                    let result = JSON.parse(xhr.responseText);\n\n                    if (typeof result.success !== 'undefined') {\n                        refreshCustomerData(this.addToCartUrl);\n                        this.quoteIdForRest = result.success.quoteIdMask;\n                        this.quoteId = result.success.quoteId;\n                        return result.success;\n                    }\n                } catch (parseError) {\n                    throw new Error('Failed to parse response JSON: ' + parseError.message);\n                }\n            }\n        },\n\n        /**\n         * After order created.\n         *\n         * @param {Object} data\n         * @return {String}\n         */\n        afterCreateOrder: function (data) {\n            if (data.response['paypal-order'] && data.response['paypal-order']['mp_order_id']) {\n                this.paymentsOrderId = data.response['paypal-order']['mp_order_id'];\n                this.paypalOrderId = data.response['paypal-order'].id;\n\n                this.showPopup({\n                    displayItems: [],\n                    currencyCode: data.response['paypal-order']['currency_code'],\n                    totalPriceStatus: 'FINAL',\n                    totalPrice: Number(data.response['paypal-order']['amount']).toString(),\n                    totalPriceLabel: $t('Total')\n                });\n\n                return this.paypalOrderId;\n            }\n\n            throw new Error();\n        },\n\n        afterOnAuthorize: function (data) {\n\n            this.applePayButton.showLoaderAsync(true)\n                .then(() => {\n                    fetch(this.placeOrderUrl, {\n                        method: 'POST'\n                    }).then(response => {\n                        if (response.redirected && response.url.includes(\"review\")) {\n                            throw new Error();\n                        }\n                        return response.text();\n                    }).then(result => {\n                        if (result) {\n                            customerData.invalidate(['cart']);\n                            document.open();\n                            document.write(result);\n                            document.close();\n                        }\n                    })\n                    .catch(error => {\n                        this.applePayButton.showLoader(false);\n                        this.applePayButton.catchError(error);\n                    });\n                })\n                .catch(error => {\n                    this.catchError(error);\n                });\n        },\n\n        /**\n         * Redirect to cart on cancel.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         */\n        onCancel: function () {\n            customerData.invalidate(['cart']);\n            window.location = this.cancelUrl;\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/google-pay-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'Magento_PaymentServicesPaypal/js/view/payment/paypal-abstract',\n    'mage/translate',\n    'Magento_Customer/js/customer-data',\n    'Magento_PaymentServicesPaypal/js/view/errors/response-error',\n    'Magento_PaymentServicesPaypal/js/view/payment/methods/google-pay'\n], function (_, $, utils, Component, $t, customerData, ResponseError, GooglePayButton) {\n    'use strict';\n\n    const HTTP_STATUS_OK = 200;\n\n    var refreshCustomerData = function (url) {\n        // Trigger ajaxComplete event to update customer data\n        customerData.onAjaxComplete(\n            {},\n            {\n                type: 'POST',\n                url: url,\n            }\n        );\n    }\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalGooglePay',\n            scriptParams: {},\n            buttonContainerId: 'google-pay-${ $.uid }',\n            template: 'Magento_PaymentServicesPaypal/payment/google-pay',\n            paymentsOrderId: null,\n            paypalOrderId: null,\n            sdkLoaded: null,\n            sdkParamsKey: 'googlepay',\n            paymentTypeIconTitle: $t('Pay with Google Pay'),\n            requestProcessingError: $t('Something went wrong with your request. Please try again later.'),\n            notEligibleErrorMessage: $t('This payment option is currently unavailable.'),\n            productFormSelector: '#product_addtocart_form'\n        },\n\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config, element) {\n            _.bindAll(this, 'initGooglePayButton', 'onClick', 'afterUpdateQuote',\n                'catchError', 'beforeCreateOrder', 'afterOnAuthorize', 'onCancel');\n            config.uid = utils.uniqueid();\n            this._super();\n            this.element = element;\n            this.element.id = this.buttonContainerId;\n            this.getSdkParams()\n                .then(this.initGooglePayButton)\n                .catch(console.log);\n\n            return this;\n        },\n\n        initGooglePayButton: function () {\n            this.googlePayButton = new GooglePayButton({\n                scriptParams: this.sdkParams,\n                createOrderUrl: this.createOrderUrl,\n                updateQuoteUrl: this.authorizeOrderUrl,\n                onClick: this.onClick,\n                beforeCreateOrder: this.beforeCreateOrder,\n                catchCreateOrder: this.catchError,\n                onError: this.catchError,\n                buttonContainerId: this.buttonContainerId,\n                afterUpdateQuote: this.afterUpdateQuote,\n                shippingAddressRequired: !this.isVirtual,\n                styles: this.styles,\n                afterOnAuthorize: this.afterOnAuthorize,\n                onCancel: this.onCancel,\n                mode: this.googlePayMode,\n                getOrderDetailsUrl: this.getOrderDetailsUrl,\n                threeDSMode: this.threeDSMode,\n                location: this.pageType,\n            });\n\n            this.googlePayButton.sdkLoaded\n                .then(this.googlePayButton.initGoogleSDK);\n        },\n\n        afterUpdateQuote: function (data) {\n            window.location = data.redirectUrl;\n            this.googlePayButton.showLoader(false);\n        },\n\n        onClick: function () {\n            var $form = $(this.productFormSelector);\n\n            if ($form.data('mageValidation')) {\n                this.formValid = $form.validation('isValid');\n            }\n\n            if (this.formValid) {\n                this.isErrorDisplayed = false;\n\n                this.googlePayButton.showLoaderAsync(true)\n                    .then(() => {\n                        return this.googlePayButton.createOrder();\n                    })\n                    .then(() => {\n                        refreshCustomerData(this.createOrderUrl);\n                    })\n                    .catch(error => {\n                        this.catchError(error);\n                    });\n            }\n        },\n\n        /**\n         * Catch errors.\n         *\n         * @param {*} error\n         */\n        catchError: function (error) {\n            console.log(error);\n            this.googlePayButton.showLoader(false);\n\n            if (this.isErrorDisplayed) {\n                return;\n            }\n\n            if (error.hidden === undefined || !error.hidden) {\n                this.addMessage(this.requestProcessingError);\n            }\n\n            this.isErrorDisplayed = true;\n        },\n\n        /**\n         * Add message to customer data.\n         *\n         * @param {String} message\n         * @param {String} [type]\n         */\n        addMessage: function (message, type) {\n            type = type || 'error';\n            customerData.set('messages', {\n                messages: [{\n                    type: type,\n                    text: message\n                }],\n                'data_id': Math.floor(Date.now() / 1000)\n            });\n        },\n\n        /**\n         * Before create order.\n         *\n         * @return {String}\n         */\n        beforeCreateOrder: function () {\n            this.isErrorDisplayed = false;\n\n            if (this.formInvalid) {\n                throw new Error('Form is Invalid');\n            }\n\n            let xhr = new XMLHttpRequest();\n            xhr.open('POST', this.addToCartUrl, false);\n            xhr.send(new FormData($(this.productFormSelector)[0]));\n\n            if (xhr.status !== HTTP_STATUS_OK) {\n                throw new Error('Request failed');\n            } else {\n                try {\n                    let result = JSON.parse(xhr.responseText);\n\n                    if (typeof result.success !== 'undefined') {\n                        refreshCustomerData(this.addToCartUrl);\n                        return result.success;\n                    }\n                } catch (parseError) {\n                    throw new Error('Failed to parse response JSON: ' + parseError.message);\n                }\n            }\n        },\n\n        afterOnAuthorize: function (data) {\n            window.location = data.redirectUrl;\n            this.googlePayButton.showLoader(false);\n        },\n\n        /**\n         * Redirect to cart on cancel.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         */\n        onCancel: function () {\n            customerData.invalidate(['cart']);\n            window.location = this.cancelUrl;\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/methods/google-pay.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'scriptLoader',\n    'Magento_PaymentServicesPaypal/js/lib/script-loader',\n    'mage/translate',\n    'mage/cookies'\n], function ($, _, Component, loadSdkScript, scriptLoader, $t) {\n    'use strict';\n\n    const HTTP_STATUS_CREATED = 201;\n\n    const googleSDKSrc = 'https://pay.google.com/gp/p/js/pay.js',\n        baseRequest = {\n            apiVersion: 2,\n            apiVersionMinor: 0,\n            callbackIntents: ['PAYMENT_AUTHORIZATION'],\n            emailRequired: true,\n            shippingAddressParameters: {phoneNumberRequired: true}\n        };\n\n    /**\n     * Create order request.\n     *\n     * @param {String} url\n     * @param {Object} payPalOrderData\n     * @param {FormData} orderData\n     * @param {String | false} threeDSMode\n     * @return {Object}\n     */\n    var performCreateOrder = function (url, payPalOrderData, orderData, threeDSMode) {\n\n            orderData = orderData || new FormData();\n            orderData.append('form_key', $.mage.cookies.get('form_key'));\n            orderData.append('payment_source', payPalOrderData['paymentSource']);\n\n            if (threeDSMode) {\n                orderData.append('three_ds_mode', threeDSMode);\n            }\n\n            let xhr = new XMLHttpRequest();\n            xhr.open('POST', url, false);\n            xhr.send(orderData);\n\n            if (xhr.status !== HTTP_STATUS_CREATED) {\n                throw new Error('Request failed');\n            } else {\n                return JSON.parse(xhr.responseText);\n            }\n        },\n\n        /**\n         * Payment authorization request.\n         *\n         * @return {Promise<Object>}\n         */\n        performOnAuthorize = function (url, data) {\n            var orderData = new FormData();\n\n            orderData.append('form_key', $.mage.cookies.get('form_key'));\n            orderData.append('paypal_order_id', data.orderID);\n\n            return fetch(url, {\n                method: 'POST',\n                headers: {},\n                body: orderData,\n                credentials: 'same-origin'\n            }).then(function (response) {\n                return response.json();\n            });\n        };\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypal',\n            paypal: null,\n            paymentSource: 'googlepay',\n            createOrderUrl: '',\n            updateQuoteUrl: '',\n            instance: null,\n            scriptParams: {},\n            allowedPaymentMethods: null,\n            merchantInfo: null,\n            buttonContainerId: null,\n            paypalOrderId: null,\n            eligible: false,\n            mode: 'TEST',\n            shippingAddressRequired: true,\n            getOrderDetailsUrl: '',\n            threeDSMode: '',\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            _.bindAll(this, 'createOrder', 'onApprove', 'onError', 'initGoogleSDK', 'performAuthorization',\n                'onClick', 'beforeOnAuthorize', 'afterOnAuthorize', 'onCancel');\n            this._super();\n            this.sdkLoaded = Promise.all([this.loadPayPalSDK(), this.loadGoogleSDK()]);\n\n            return this;\n        },\n\n        loadPayPalSDK: function () {\n            return loadSdkScript(this.scriptParams, this.sdkNamespace)\n                .then(function (sdkScript) {\n                    this.paypal = sdkScript;\n                }.bind(this))\n                .catch(function (e) {\n                    this.onError(e);\n                });\n        },\n\n        loadGoogleSDK: function () {\n            return scriptLoader.loadCustom({url: googleSDKSrc})\n                .catch(function (e) {\n                    this.onError(e);\n                });\n        },\n\n        initGoogleSDK: function () {\n            return this.getGooglePayConfig()\n                .then(config =>\n                    this.getGooglePaymentsClient()\n                        .isReadyToPay(this.getGoogleIsReadyToPayRequest(config.allowedPaymentMethods))\n                        .then(function (response) {\n                            if (response.result) {\n                                this.renderGooglePayButton();\n                            }\n                        }.bind(this))\n                ).catch(function (e) {\n                    this.onError({\n                        hidden: true,\n                        error: e\n                    });\n                }.bind(this));\n        },\n\n        getGooglePaymentsClient: function () {\n            if (this.instance === null) {\n                this.instance = new google.payments.api.PaymentsClient({\n                    environment: this.mode,\n                    paymentDataCallbacks: {\n                        onPaymentAuthorized: this.performAuthorization\n                    }\n                });\n            }\n            return this.instance;\n        },\n\n        showPopup: function (paymentData) {\n            this.getGooglePaymentDataRequest(paymentData)\n                .then((data) => {\n                    this.getGooglePaymentsClient()\n                        .loadPaymentData(data)\n                        .catch(this.onCancel);\n                }).catch((error) => this.onError(error));\n        },\n\n        onCancel: function () {\n            this.showLoader(false);\n        },\n\n        getGooglePaymentDataRequest: async function (transactionInfo) {\n            const paymentDataRequest = Object.assign({}, baseRequest),\n                {allowedPaymentMethods, merchantInfo} = await this.getGooglePayConfig();\n\n            paymentDataRequest.allowedPaymentMethods = allowedPaymentMethods;\n            paymentDataRequest.transactionInfo = transactionInfo;\n            paymentDataRequest.merchantInfo = merchantInfo;\n            paymentDataRequest.shippingAddressRequired = this.shippingAddressRequired;\n\n            return paymentDataRequest;\n        },\n\n        getGooglePayConfig: async function () {\n            if (this.allowedPaymentMethods === null || this.merchantInfo === null) {\n                const googlePayConfig = await this.paypal.Googlepay().config();\n\n                this.allowedPaymentMethods = googlePayConfig.allowedPaymentMethods;\n                this.merchantInfo = googlePayConfig.merchantInfo;\n            }\n\n            return {\n                allowedPaymentMethods: this.allowedPaymentMethods,\n                merchantInfo: this.merchantInfo\n            };\n        },\n\n        getGoogleIsReadyToPayRequest: function (allowedPaymentMethods) {\n            return Object.assign({}, baseRequest, {\n                allowedPaymentMethods: allowedPaymentMethods\n            });\n        },\n\n        renderGooglePayButton: function () {\n            const buttonContainer = $('#' + this.buttonContainerId);\n\n            let buttonProps = {\n                onClick: this.onClick,\n                buttonColor: this.styles.button_color,\n                buttonType: this.styles.button_type\n            };\n\n            buttonProps.buttonSizeMode = 'fill';\n\n            if (this.styles.button_custom_height) {\n                buttonContainer.height(this.styles.button_custom_height);\n            }\n\n            buttonContainer.append(\n                this.getGooglePaymentsClient().createButton(buttonProps)\n            );\n            this.eligible = true;\n        },\n\n        enableButton: function () {\n            $('#' + this.buttonContainerId).find('button').prop('disabled', false);\n        },\n\n        disableButton: function () {\n            $('#' + this.buttonContainerId).find('button').prop('disabled', true);\n        },\n\n        performAuthorization: function (paymentData) {\n            return new Promise(function (resolve) {\n                this.processPayment(paymentData)\n                    .then(resolve)\n                    .catch(function () {\n                        this.onError(new Error('couldn\\'t process payment'));\n                        resolve({transactionState: 'ERROR'});\n                    }.bind(this));\n            }.bind(this));\n        },\n\n        processPayment: async function (paymentData) {\n            try {\n                const {status} = await this.paypal.Googlepay().confirmOrder({\n                    orderId: this.paypalOrderId,\n                    paymentMethodData: paymentData.paymentMethodData,\n                    shippingAddress: paymentData.shippingAddress,\n                    email: paymentData.email\n                });\n\n                if (status === 'APPROVED') {\n                    this.onApprove(paymentData);\n                    return {transactionState: 'SUCCESS'};\n                }\n\n                if (status === 'PAYER_ACTION_REQUIRED') {\n                    this.paypal.Googlepay().initiatePayerAction({orderId: this.paypalOrderId}).then(\n                        async () => {\n                            return fetch(`${this.getOrderDetailsUrl}`, {\n                                method: 'GET'\n                            }).then((res) => {\n                                return res.json();\n                            }).then((data) => {\n                                if (data.response['is_successful'] && data.response['paypal-order']) {\n                                    const order = data.response['paypal-order'];\n                                    let authenticationResult = order.payment_source_details.card.authentication_result;\n                                    if (authenticationResult\n                                        && (\n                                            authenticationResult.liability_shift === 'POSSIBLE'\n                                            || authenticationResult.liability_shift === \"YES\"\n                                            || authenticationResult.liability_shift === undefined\n                                        )\n                                    ) {\n                                        this.onApprove(paymentData);\n                                        return {transactionState: 'SUCCESS'};\n                                    } else {\n                                        this.onError(new Error('couldn\\'t approve order'));\n                                        return {transactionState: 'ERROR'};\n                                    }\n                                }\n                            }).catch((error) => {\n                                console.log(\"ERROR: \", error)\n                            })\n                        }\n                    ).catch((error) => {\n                        console.log(\"ERROR: \", error)\n                    });\n                    return;\n                }\n\n                this.onError(new Error('couldn\\'t approve order'));\n                return {transactionState: 'ERROR'};\n            } catch (err) {\n                this.onError(err);\n                return {\n                    transactionState: 'ERROR',\n                    error: {\n                        message: err.message\n                    }\n                };\n            }\n        },\n\n        onClick: function () {\n        },\n\n        /**\n         * Calls before create order.\n         */\n        beforeCreateOrder: function () {\n        },\n\n        /**\n         * Create order.\n         *\n         * @return {String}\n         */\n        createOrder: function () {\n            let data = {'paymentSource': this.paymentSource};\n\n            try {\n                this.beforeCreateOrder();\n\n                // add location to the order create request\n                let formData = new FormData();\n                formData.append('location', this.location);\n\n                let orderData = performCreateOrder(this.createOrderUrl, data, formData, this.threeDSMode);\n                this.paypalOrderId = this.afterCreateOrder(orderData);\n                return this.paypalOrderId;\n            } catch (error) {\n                return this.catchCreateOrder(error);\n            }\n        },\n\n        /**\n         * After order created.\n         *\n         * @param {Object} data\n         * @return {String}\n         */\n        afterCreateOrder: function (data) {\n            if (data.response['paypal-order'] && data.response['paypal-order']['mp_order_id']) {\n                this.paymentsOrderId = data.response['paypal-order']['mp_order_id'];\n                this.paypalOrderId = data.response['paypal-order'].id;\n\n                this.showPopup({\n                    displayItems: [],\n                    currencyCode: data.response['paypal-order']['currency_code'],\n                    totalPriceStatus: 'FINAL',\n                    totalPrice: Number(data.response['paypal-order']['amount']).toString(),\n                    totalPriceLabel: $t('Total')\n                });\n\n                return this.paypalOrderId;\n            }\n\n            throw new Error();\n        },\n\n        /**\n         * Catch error on order creation.\n         */\n        catchCreateOrder: function () {\n        },\n\n        /**\n         * On payment approve.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         * @return {Promise}\n         */\n        onApprove: function () {\n            const data = {orderID: this.paypalOrderId};\n\n            return this.beforeOnAuthorize()\n                .then(performOnAuthorize.bind(this, this.updateQuoteUrl, data))\n                .then(this.afterOnAuthorize)\n                .catch(this.onError);\n        },\n\n        beforeOnAuthorize: function () {\n            return Promise.resolve();\n        },\n\n        afterOnAuthorize: function () {\n            return Promise.resolve();\n        },\n\n        /**\n         * Calls when error happened on paypal side.\n         *\n         * @param {Error} error\n         */\n        onError: function (error) {\n            console.log('Error: ', error.message);\n        },\n\n        isEligible: function () {\n            return this.eligible;\n        },\n\n        /**\n         * Async Show/hide loader\n         *\n         * @param {Boolean} show\n         */\n        showLoaderAsync: function (show) {\n            return new Promise(function (resolve, reject) {\n                var event = show ? 'processStart' : 'processStop';\n                $('body').trigger(event);\n\n                // Set minimum time for loader to show\n                setTimeout(() => {\n                    resolve();\n                }, 10);\n            });\n        },\n\n        /**\n         * Show/hide loader.\n         *\n         * @param {Boolean} show\n         */\n        showLoader: function (show) {\n            var event = show ? 'processStart' : 'processStop';\n\n            $('body').trigger(event);\n        },\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/methods/apple-pay.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'scriptLoader',\n    'Magento_PaymentServicesPaypal/js/lib/script-loader',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/model/customer',\n    'mage/translate',\n], function ($, _, Component, loadSdkScript, scriptLoader, customerData, customer, $t) {\n    'use strict';\n\n    const HTTP_STATUS_CREATED = 201;\n\n    const APPLE_PAY_VERSION_NUMBER = 4; // See https://developer.apple.com/documentation/apple_pay_on_the_web/apple_pay_js_api/creating_an_apple_pay_session\n    const appleSDKSrc = 'https://applepay.cdn-apple.com/jsapi/v1/apple-pay-sdk.js';\n\n    /**\n     * Create order request.\n     *\n     * @param {String} url\n     * @param {Object} payPalOrderData\n     * @param {FormData} orderData\n     * @return {Object}\n     */\n    var performCreateOrder = function (url, payPalOrderData, orderData) {\n\n            orderData = orderData || new FormData();\n            orderData.append('form_key', $.mage.cookies.get('form_key'));\n            orderData.append('payment_source', payPalOrderData['paymentSource']);\n\n            let xhr = new XMLHttpRequest();\n            xhr.open('POST', url, false);\n            xhr.send(orderData);\n\n            if (xhr.status !== HTTP_STATUS_CREATED) {\n                throw new Error('Request failed');\n            } else {\n                return JSON.parse(xhr.responseText);\n            }\n        },\n\n        /**\n         * Payment authorization request.\n         *\n         * @return {Promise<Object>}\n         */\n        performOnAuthorize = function (url, data) {\n            var orderData = new FormData();\n\n            orderData.append('form_key', $.mage.cookies.get('form_key'));\n            orderData.append('paypal_order_id', data.orderID);\n\n            return fetch(url, {\n                method: 'POST',\n                headers: {},\n                body: orderData,\n                credentials: 'same-origin'\n            }).then(function (response) {\n                return response.json();\n            });\n        };\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypal',\n            paypal: null,\n            paymentSource: 'applepay',\n            createOrderUrl: '',\n            placeOrderUrl: '',\n            updateQuoteUrl: '',\n            estimateShippingMethodsWhenLoggedInUrl: '',\n            estimateShippingMethodsWhenGuestUrl: '',\n            shippingInformationWhenLoggedInUrl: '',\n            shippingInformationWhenGuestUrl: '',\n            updatePaypalOrderUrl: '',\n            setQuoteAsInactiveUrl: '',\n            countriesUrl: '',\n            instance: null,\n            scriptParams: {},\n            allowedPaymentMethods: null,\n            merchantInfo: null,\n            buttonContainerId: null,\n            paypalOrderId: null,\n            eligible: false,\n            applePayInstance: null,\n            applePayConfig: null,\n            appleSession: null,\n            applePayVersionNumber: APPLE_PAY_VERSION_NUMBER,\n            countryCode: null,\n            regionCode: null,\n            regionId: null,\n            postalCode: null,\n            requestProcessingError: $t('Something went wrong with your request. Please try again later.'),\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            _.bindAll(this, 'createOrder', 'onApprove', 'onError', 'initAppleSDK', 'performAuthorization',\n                'onClick', 'beforeOnAuthorize', 'afterOnAuthorize', 'onCancel');\n            this._super();\n            this.sdkLoaded = Promise.all([this.loadPayPalSDK(), this.loadAppleSDK()]);\n\n            return this;\n        },\n\n        loadPayPalSDK: function () {\n            return loadSdkScript(this.scriptParams, this.sdkNamespace)\n                .then(function (sdkScript) {\n                    this.paypal = sdkScript;\n                }.bind(this))\n                .catch(function (e) {\n                    this.onError(e);\n                });\n        },\n\n        loadAppleSDK: function () {\n            return scriptLoader.loadCustom({url: appleSDKSrc})\n                .catch(function (e) {\n                    this.onError(e);\n                });\n        },\n\n        isCustomerLoggedIn: function () {\n            return customer.isLoggedIn();\n        },\n\n        initAppleSDK: function () {\n            if (!window.ApplePaySession) {\n                console.error('This device does not support Apple Pay');\n                return;\n            }\n\n            if (!ApplePaySession.canMakePayments()) {\n                console.error('This device is not capable of making Apple Pay payments');\n            }\n\n            this.applePayInstance = this.paypal.Applepay();\n            return this.applePayInstance.config()\n                .then(applePayConfig => {\n                    this.applePayConfig = applePayConfig;\n                    this.renderApplePayButton();\n                })\n                .catch(applepayConfigError => {\n                    console.error('Error while fetching Apple Pay configuration.');\n                });\n        },\n\n        onApplePayValidateMerchant: function (applePaySession) {\n            applePaySession.onvalidatemerchant = (event) => {\n                this.applePayInstance\n                    .validateMerchant({\n                        validationUrl: event.validationURL,\n                    })\n                    .then((payload) => {\n                        applePaySession.completeMerchantValidation(payload.merchantSession);\n                    })\n                    .catch((error) => {\n                        applePaySession.abort();\n                        this.isErrorDisplayed = false;\n                        this.catchError(error)\n                    });\n            };\n        },\n\n        onApplePayPaymentAuthorized: function (applePaySession, paypalOrderId = null) {\n            applePaySession.onpaymentauthorized = async (event) => {\n                try {\n                    await this.applePayInstance.confirmOrder({\n                        orderId: paypalOrderId !== null ? paypalOrderId : this.paypalOrderId,\n                        token: event.payment.token,\n                        billingContact: event.payment.billingContact,\n                        shippingContact: event.payment.shippingContact\n                    });\n\n                    applePaySession.completePayment({\n                        status: window.ApplePaySession.STATUS_SUCCESS,\n                    });\n\n                    await this.onApprove();\n                } catch (error) {\n                    applePaySession.completePayment({\n                        status: window.ApplePaySession.STATUS_FAILURE,\n                    });\n                    this.isErrorDisplayed = false;\n                    this.catchError(error)\n                }\n            };\n        },\n\n        onApplePayShippingContactSelected: function (applePaySession, quoteId, total, isVirtual) {\n            applePaySession.onshippingcontactselected = (event) => {\n\n                const shippingMethods = [];\n\n                let estimateShippingMethodURL = (this.isCustomerLoggedIn())\n                    ? this.estimateShippingMethodsWhenLoggedInUrl\n                    : this.estimateShippingMethodsWhenGuestUrl.replace(':cartId', quoteId);\n\n                if (this.location === 'product') {\n                    // Product Page: we need to use guest cart quote because it is created outside the checkout process\n                    estimateShippingMethodURL = this.estimateShippingMethodsWhenGuestUrl.replace(':cartId', quoteId);\n                }\n\n                this.countryCode = event.shippingContact.countryCode;\n                this.regionCode = event.shippingContact.administrativeArea;\n                this.postalCode = event.shippingContact.postalCode;\n\n                this.getRegionIdByCode(this.regionCode, this.countryCode)\n                    .then((regionId) => {\n                        this.regionId = regionId;\n                    })\n                    .catch((error)=>  {\n                        // If the Apple region Code doesn't match to the one in Commerce\n                        // we set the regionId to null to still apply the taxes of the country\n                        // to continue with the checkout\n                        console.log(error);\n                        this.regionId = null;\n                    });\n\n                $.ajax({\n                    type: 'POST',\n                    url: estimateShippingMethodURL,\n                    headers: {\n                        'Content-Type': 'application/json',\n                    },\n                    data: JSON.stringify({\n                        address: {\n                            country_id: event.shippingContact.countryCode,\n                            postcode: event.shippingContact.postalCode,\n                            city: event.shippingContact.locality\n                        }\n                    })\n                }).then(estimateShippingMethods => {\n\n                    estimateShippingMethods.forEach(method => {\n                        shippingMethods.push({\n                            label: method.method_title,\n                            detail: method.carrier_title,\n                            amount: method.amount.toString(),\n                            identifier: method.carrier_code + '_' + method.method_code,\n                        });\n                    });\n\n                    applePaySession.completeShippingContactSelection({\n                        newShippingMethods: shippingMethods,\n                        newTotal: total,\n                    })\n\n                }, error => {\n                    this.isErrorDisplayed = false;\n                    applePaySession.abort();\n                    this.catchError(error);\n                });\n\n                if (isVirtual) {\n                    // If Quote is virtual, no need to select shipping\n                    // We can already create the order\n                    this.createOrder();\n                }\n            }\n        },\n\n        onApplePayShippingMethodSelectedInCartPage: function (applePaySession, quoteId) {\n            this.onApplePayShippingMethodSelected(applePaySession, quoteId, null,null);\n        },\n\n        onApplePayShippingMethodSelected: function (applePaySession, quoteId, quoteMaskedId, paypalOrderId) {\n           applePaySession.onshippingmethodselected = (event) => {\n\n                let shippingInformationURL = (this.isCustomerLoggedIn())\n                    ? this.shippingInformationWhenLoggedInUrl\n                    : this.shippingInformationWhenGuestUrl.replace(':quoteId', quoteId);\n\n                if (this.location === 'product') {\n                    // Product Page: we need to use quoteMaskedId as the quote is created outside the checkout process\n                    shippingInformationURL = this.shippingInformationWhenGuestUrl.replace(':quoteId', quoteMaskedId);\n                }\n\n                $.ajax({\n                    type: 'POST',\n                    url: shippingInformationURL,\n                    headers: {\n                        'Content-Type': 'application/json',\n                    },\n                    data: JSON.stringify({\n                        addressInformation: {\n                            shipping_address: {\"country_id\": this.countryCode, \"region_id\": this.regionId, \"postcode\": this.postalCode},\n                            shipping_method_code: event.shippingMethod.identifier.split('_')[1],\n                            shipping_carrier_code: event.shippingMethod.identifier.split('_')[0],\n                            extension_attributes: {}\n                        }\n                    })\n                }).then(result => {\n\n                    let items = [];\n\n                    result['totals']['items'].forEach(item => {\n                        items.push({\n                            label: item.name + ' ( x ' + item.qty + ' )',\n                            type: \"final\",\n                            amount: item.row_total\n                        });\n                    });\n\n                    items.push({\n                        label: \"Shipping\",\n                        type: \"final\",\n                        amount: result['totals']['shipping_amount'],\n                    });\n\n                    if (result['totals']['tax_amount'] !== 0) {\n                        items.push({\n                            label: \"Tax\",\n                            type: \"final\",\n                            amount: result['totals']['tax_amount'],\n                        });\n                    }\n\n                    applePaySession.completeShippingMethodSelection({\n                        newLineItems: items,\n                        newTotal: {\n                            label: \"Summary\",\n                            type: \"final\",\n                            amount: result['totals']['grand_total'],\n                        },\n                    });\n\n                    if (this.location === 'product') {\n                        // In the product page, the paypal order has been created on the onClick handler\n                        // so we just need to update the amount with the shipping selected\n                        this.updatePaypalOrder();\n                    } else {\n                        // In Cart and Minicart, we need to create the Paypal Order\n                        this.createOrder();\n                    }\n\n                }).catch(error => {\n                    applePaySession.abort();\n                    this.isErrorDisplayed = false;\n                    this.catchError(error);\n                });\n            };\n        },\n\n        updatePaypalOrder: function() {\n\n            // Update PayPal Order Amount as the shipping method has been selected and the price changed\n            // Without the update, the payment is failing as the order amount could be different\n            $.ajax({\n                type: 'POST',\n                url: this.updatePayPalOrderUrl,\n            }).catch(error => {\n                this.catchError(error);\n            });\n        },\n\n        onApplePayCancel: function (applePaySession, callback) {\n            applePaySession.oncancel = () => {\n                if (typeof callback === 'function') {\n                    callback();\n                }\n\n                this.showLoader(false);\n            }\n        },\n\n        getApplePaymentRequestLineItems: function (quote){\n            let items = [];\n\n            quote.getItems().forEach(item => {\n                items.push({\n                    label: item.name + ' ( x ' + item.qty + ' )',\n                    type: \"final\",\n                    amount: item.price * item.qty,\n                });\n            });\n\n            items.push({\n                label: $t(\"Shipping\"),\n                type: \"final\",\n                amount: quote.getTotals()()['shipping_amount'],\n            });\n\n            if (quote.getTotals()['tax_amount'] !== 0) {\n                items.push({\n                    label: $t(\"Tax\"),\n                    type: \"final\",\n                    amount: quote.getTotals()()['tax_amount'],\n                });\n            }\n\n            return items;\n        },\n\n        showPopup: function (paymentData, quote) {\n            const paymentRequest = {\n                countryCode: this.applePayConfig.countryCode,\n                merchantCapabilities: this.applePayConfig.merchantCapabilities,\n                supportedNetworks: this.applePayConfig.supportedNetworks,\n                currencyCode: paymentData.response['paypal-order']['currency_code'],\n                lineItems: this.getApplePaymentRequestLineItems(quote),\n                requiredBillingContactFields: [\"postalAddress\"],\n                shippingContact: {\n                    countryCode: quote.shippingAddress().countryId,\n                    postalCode: quote.shippingAddress().postcode,\n                    locality: quote.shippingAddress().city,\n                    administrativeArea: quote.shippingAddress().regionCode,\n                    familyName: quote.shippingAddress().lastname,\n                    givenName: quote.shippingAddress().firstname,\n                    addressLines: quote.shippingAddress().street,\n                },\n                total: {\n                    label: $t(\"Summary\"),\n                    type: \"final\",\n                    amount: Number(paymentData.response['paypal-order']['amount']).toString(),\n                }\n            };\n\n            // See https://developer.apple.com/documentation/apple_pay_on_the_web/applepaysession\n            this.applePaySession = new ApplePaySession(APPLE_PAY_VERSION_NUMBER, paymentRequest);\n            this.onApplePayValidateMerchant(this.applePaySession);\n            this.onApplePayPaymentAuthorized(this.applePaySession, paymentData.response['paypal-order']['id']);\n            this.onApplePayCancel(this.applePaySession);\n\n            this.applePaySession.begin();\n        },\n\n        onCancel: function () {\n            window.location = data.redirectUrl;\n            this.showLoader(false);\n        },\n\n        renderApplePayButton: function () {\n            if (this.applePayConfig.isEligible) {\n                const buttonStyle = this.mapButtonStyle();\n                const buttonType = this.mapButtonType();\n                const height = this.styles.height > 0\n                    ? this.styles.height + \"px\"\n                    : \"40px\";\n\n                document.getElementById(this.buttonContainerId).innerHTML = `\n                <apple-pay-button\n                    id=\"btn-appl\"\n                    buttonstyle=\"${buttonStyle}\"\n                    type=\"${buttonType}\"\n                    locale=\"${window.LOCALE}\"\n                    style=\" --apple-pay-button-width: 100%; --apple-pay-button-height: ${height}\"\n                >`;\n                document.getElementById(\"btn-appl\").addEventListener(\"click\", this.onClick);\n            }\n        },\n\n        mapButtonStyle: function () {\n            return this.styles.color === 'white' ? 'white' : 'black';\n        },\n\n        mapButtonType: function () {\n            switch (this.styles.label) {\n                case 'paypal':\n                case 'installment':\n                    return 'plain';\n                case 'checkout':\n                    return 'check-out';\n                case 'buynow':\n                    return 'buy';\n                default:\n                    return 'pay';\n            }\n        },\n\n        enableButton: function () {\n            $('#' + this.buttonContainerId).find('button').prop('disabled', false);\n        },\n\n        disableButton: function () {\n            $('#' + this.buttonContainerId).find('button').prop('disabled', true);\n        },\n\n        performAuthorization: function (paymentData) {},\n\n        onClick: function () {},\n\n        /**\n         * Calls before create order.\n         */\n        beforeCreateOrder: function () {},\n\n        /**\n         * Create order.\n         *\n         * @return {String}\n         */\n        createOrder: function () {\n            let data = {'paymentSource': this.paymentSource};\n\n            // add location to the order create request\n            let createOrderData = new FormData();\n            createOrderData.append('location', this.location);\n\n            try {\n                this.beforeCreateOrder();\n                let orderData = performCreateOrder(this.createOrderUrl, data, createOrderData);\n                this.paypalOrderId = this.afterCreateOrder(orderData);\n                return this.paypalOrderId;\n            } catch (error) {\n                this.isErrorDisplayed = false;\n                this.catchError(error);\n\n                // Propagate the error to be caught in the promise chain\n                return Promise.reject(error);\n            }\n        },\n\n        /**\n         * After order created.\n         *\n         * @param {Object} data\n         * @return {String}\n         */\n        afterCreateOrder: function (data) {},\n\n        /**\n         * Catch error on order creation.\n         */\n        catchCreateOrder: function () {},\n\n        /**\n         * On payment approve.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         * @return {Promise}\n         */\n        onApprove: function () {\n            const data = {orderID: this.paypalOrderId};\n\n            return this.beforeOnAuthorize()\n                .then(performOnAuthorize.bind(this, this.updateQuoteUrl, data))\n                .then(this.afterOnAuthorize)\n                .catch(this.onError);\n        },\n\n        beforeOnAuthorize: function () {\n            return Promise.resolve();\n        },\n\n        afterOnAuthorize: function () {\n            return Promise.resolve();\n        },\n\n        /**\n         * Calls when error happened on paypal side.\n         *\n         * @param {Error} error\n         */\n        onError: function (error) {\n            console.log('Error: ', error.message);\n        },\n\n        isEligible: function () {\n            return this.eligible;\n        },\n\n        /**\n         * Async Show/hide loader\n         *\n         * @param {Boolean} show\n         */\n        showLoaderAsync: function (show) {\n            return new Promise(function (resolve, reject) {\n                var event = show ? 'processStart' : 'processStop';\n                $('body').trigger(event);\n\n                // Set minimum time for loader to show\n                setTimeout(() => {\n                    resolve();\n                }, 10);\n            });\n        },\n\n        /**\n         * Show/hide loader.\n         *\n         * @param {Boolean} show\n         */\n        showLoader: function (show) {\n            var event = show ? 'processStart' : 'processStop';\n\n            $('body').trigger(event);\n        },\n\n        /**\n         *  Get region ID by region code and country code\n         *\n         * @param regionCode\n         * @param countryCode\n         * @returns {null}\n         */\n        getRegionIdByCode: function (regionCode, countryCode) {\n            return new Promise(function (resolve, reject) {\n                $.ajax({\n                    url: this.countriesUrl.replace(':countryCode', countryCode),\n                    method: 'GET',\n                    success: function (response) {\n                        if (response.available_regions && response.available_regions.length) {\n                            var matchedRegion = response.available_regions.find(function (region) {\n                                return region.code === regionCode;\n                            });\n\n                            if (matchedRegion) {\n                                resolve(matchedRegion.id);\n                            } else {\n                                reject('Region not found');\n                            }\n                        } else {\n                            reject('No regions available for country: ' + countryCode);\n                        }\n                    },\n                    error: function () {\n                        reject('Error fetching regions for country: ' + countryCode);\n                    }\n                });\n            }.bind(this));\n        },\n\n        /**\n         * Catch errors.\n         *\n         * @param {*} error\n         */\n        catchError: function (error) {\n            this.showLoader(false);\n\n            if (this.isErrorDisplayed) {\n                return;\n            }\n\n            if (error.hidden === undefined || !error.hidden) {\n                this.addMessage(this.requestProcessingError);\n            }\n\n            this.isErrorDisplayed = true;\n        },\n\n        /**\n         * Add message to customer data.\n         *\n         * @param {String} message\n         * @param {String} [type]\n         */\n        addMessage: function (message, type) {\n            type = type || 'error';\n\n            // Need to set a slight delay to avoid refresh from core\n            setTimeout(function () {\n                customerData.set('messages', {\n                    messages: [{\n                        text: message,\n                        type: type\n                    }]\n                });\n            }, 1000);\n        },\n\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/methods/hosted-fields.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'underscore',\n    'uiComponent',\n    'mage/translate',\n    'Magento_PaymentServicesPaypal/js/view/errors/response-error',\n    'scriptLoader'\n], function (_, Class, $t, ResponseError, loadSdkScript) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            sdkNamespace: 'paypal',\n            paypal: null,\n            formId: 'hosted-fields-form',\n            instance: undefined,\n            createOrderUrl: null,\n            orderCreateErrorMessage: {\n                default: $t('Failed to place order. Try again or refresh the page if that does not resolve the issue.'), // eslint-disable-line max-len,\n                //TODO: Update messages\n                'POSTAL_CODE_REQUIRED': $t('Postal code is required.'),\n                'CITY_REQUIRED': $t('City is required.')\n            },\n            styles: {\n                input: {\n                    color: '#ccc',\n                    'font-family': '\"Open Sans\",\"Helvetica Neue\",Helvetica,Arial,sans-serif',\n                    'font-size': '16px',\n                    'font-weight': '400'\n                },\n                ':focus': {\n                    color: '#333'\n                },\n                '.valid': {\n                    color: '#333'\n                }\n            },\n            fields: {\n                number: {\n                    class: 'number',\n                    selector: '#${ $.formId } .${ $.fields.number.class }',\n                    placeholder: ''\n                },\n                expirationDate: {\n                    class: 'expiration-date',\n                    selector: '#${ $.formId } .${ $.fields.expirationDate.class }',\n                    placeholder: 'MM/YY'\n                },\n                cvv: {\n                    class: 'cvv',\n                    selector: '#${ $.formId } .${ $.fields.cvv.class }',\n                    placeholder: ''\n                }\n            },\n            scriptParams: [],\n            sdkLoaded: null,\n            shouldCardBeVaulted: false\n        },\n\n        /** @inheritdoc */\n        initialize: function (config) {\n            _.bindAll(this, 'createOrder');\n\n            if (config.fields) {\n                this.constructor.defaults.fields = config.fields;\n            }\n            this._super();\n            this.sdkLoaded = loadSdkScript(this.scriptParams, this.sdkNamespace).then(function (sdkScript) {\n                this.paypal = sdkScript;\n            }.bind(this));\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('shouldCardBeVaulted');\n\n            return this;\n        },\n\n        /**\n         * Check if eligible\n         *\n         * @return {Boolean}\n         */\n        isEligible: function () {\n            return typeof this.paypal !== 'undefined' &&\n                this.paypal.HostedFields &&\n                this.paypal.HostedFields.isEligible();\n        },\n\n        /**\n         * Render fields.\n         *\n         * @return {*}\n         */\n        render: function () {\n            return this.paypal.HostedFields.render({\n                createOrder: this.createOrder,\n                styles: this.styles,\n                fields: this.fields\n            }).then(function (instance) {\n                this.instance = instance;\n\n                return instance;\n            }.bind(this));\n        },\n\n        /**\n         * Calls before create order.\n         *\n         * @return {Promise}\n         */\n        beforeCreateOrder: function () {\n            return Promise.resolve();\n        },\n\n        /**\n         * Create order in payment service / PayPal\n         *\n         * @returns {Promise<any>}\n         */\n        createOrder: function () {\n            return this.beforeCreateOrder()\n                .then(function () {\n                    const shouldCardBeVaulted = this.shouldCardBeVaulted(),\n                        orderData = new FormData();\n\n                    orderData.append('payment_source', this.paymentSource);\n\n                    return fetch(`${this.createOrderUrl}?vault=${shouldCardBeVaulted}`, {\n                        method: 'POST',\n                        headers: {},\n                        body: orderData\n                    });\n                }.bind(this)).then(function (res) {\n                    return res.json();\n                }).then(function (data) {\n                    if (data.response['is_successful']) {\n                        this.onOrderSuccess(data.response['paypal-order']);\n                    } else {\n                        throw new ResponseError(\n                            this.orderCreateErrorMessage[data.response.message] || this.orderCreateErrorMessage.default\n                        );\n                    }\n\n                    return data.response['paypal-order'].id;\n                }.bind(this)).catch(function (error) {\n                    if (error instanceof ResponseError) {\n                        throw error;\n                    }\n                    throw new ResponseError(this.orderCreateErrorMessage.default);\n                }.bind(this));\n        },\n\n        /**\n         * Customizable handler for order creation.\n         */\n        onOrderSuccess: function () {}\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/methods/smart-buttons.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'scriptLoader',\n    'mage/cookies'\n], function ($, _, Component, loadSdkScript) {\n    'use strict';\n\n    /**\n     * Create order request.\n     *\n     * @param {String} url\n     * @param {Object} payPalOrderData\n     * @param {FormData} orderData\n     * @return {Promise<Object>}\n     */\n    var performCreateOrder = function (url, payPalOrderData, orderData) {\n            orderData = orderData || new FormData();\n            orderData.append('form_key', $.mage.cookies.get('form_key'));\n            orderData.append('payment_source', payPalOrderData['paymentSource']);\n\n            return fetch(url, {\n                method: 'POST',\n                headers: {},\n                body: orderData || new FormData(),\n                credentials: 'same-origin'\n            }).then(function (response) {\n                return response.json();\n            });\n        },\n\n        /**\n         * Payment authorization request.\n         *\n         * @return {Promise<Object>}\n         */\n        performAuthorization = function (url, data) {\n            var orderData = new FormData();\n\n            orderData.append('form_key', $.mage.cookies.get('form_key'));\n            orderData.append('paypal_order_id', data.orderID);\n            orderData.append('paypal_payer_id', data.payerID);\n\n            return fetch(url, {\n                method: 'POST',\n                headers: {},\n                body: orderData,\n                credentials: 'same-origin'\n            }).then(function (response) {\n                return response.json();\n            });\n        };\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypal',\n            paypal: null,\n            paymentSource: '',\n            creatOrderUrl: '',\n            authorizeOrderUrl: '',\n            style: {},\n            paymentRequest: {\n                applepay: {\n                    requiredShippingContactFields: []\n                }\n            },\n            element: null,\n            instance: null\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            _.bindAll(this, 'createOrder', 'onApprove', 'onError', 'onCancel');\n            this._super();\n            this.sdkLoaded = loadSdkScript(this.scriptParams, this.sdkNamespace).then(function (sdkScript) {\n                this.paypal = sdkScript;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * In the case where the button color is not supported by Apple (black or white)\n         * Map the button color to black (same behavior as PayPal SDK script)\n         *\n         * @param buttonStyles\n         * @returns {(*&{color: string})|*}\n         */\n        mapButtonColorForApplePay: function (buttonStyles) {\n            var buttonColor = buttonStyles.color;\n\n            if (buttonColor === 'black' || buttonColor === 'white') {\n                return buttonStyles;\n            }\n            return {\n                ...buttonStyles,\n                color: 'black'\n            };\n        },\n\n        /**\n         * Render Smart Buttons.\n         *\n         * @param {HTMLElement} element\n         * @return {*}\n         */\n        render: function (element) {\n            var buttonsConfig;\n\n            if (typeof this.paypal === 'undefined' || !this.paypal.Buttons) {\n                return null;\n            }\n\n            if (element) {\n                this.element = element;\n            }\n\n            buttonsConfig = {\n                element: this.element,\n                paymentRequest: this.paymentRequest,\n                style: this.styles,\n                onClick: this.onClick,\n                createOrder: this.createOrder,\n                onApprove: this.onApprove,\n                onError: this.onError,\n                onCancel: this.onCancel,\n                onInit: this.onInit\n            };\n\n            if (this.onShippingChange) {\n                buttonsConfig.onShippingChange = this.onShippingChange.bind(this);\n            }\n            if (this.fundingSource) {\n                buttonsConfig.fundingSource = this.fundingSource;\n                if (this.fundingSource === 'applepay') {\n                    buttonsConfig.style = this.mapButtonColorForApplePay(this.styles);\n                }\n            }\n\n            this.instance = this.paypal.Buttons(buttonsConfig);\n\n            if (this.instance.isEligible()) {\n                this.instance.render(this.element);\n            }\n\n            return this.instance;\n        },\n\n        /**\n         * Calls when smart buttons initializing\n         */\n        onInit: function () {\n        },\n\n        /**\n         * Calls when user click paypal button.\n         */\n        onClick: function () {\n        },\n\n        /**\n         * Calls before create order.\n         *\n         * @return {Promise}\n         */\n        beforeCreateOrder: function () {\n            return Promise.resolve();\n        },\n\n        /**\n         * Create order.\n         *\n         * @return {Promise}\n         */\n        createOrder: function (data) {\n            this.paymentSource = data['paymentSource'];\n\n            // add location to the order create request\n            let orderData = new FormData();\n            orderData.append('location', this.location);\n\n            return this.beforeCreateOrder()\n                .then(performCreateOrder.bind(this, this.createOrderUrl, data, orderData))\n                .then(function (orderData) {\n                    return this.afterCreateOrder(orderData);\n                }.bind(this)).catch(function (error) {\n                    return this.catchCreateOrder(error);\n                }.bind(this)).finally(function (error) {\n                    return this.finallyCreateOrder(error);\n                }.bind(this));\n        },\n\n        /**\n         * After order created.\n         *\n         * @param {Object} data\n         * @return {*}\n         */\n        afterCreateOrder: function (data) {\n            return data.orderId;\n        },\n\n        /**\n         * Catch error on order creation.\n         */\n        catchCreateOrder: function () {\n        },\n\n        /**\n         * Finally for order creation.\n         *\n         */\n        finallyCreateOrder: function () {\n        },\n\n        /**\n         * Before authorization call.\n         *\n         * @return {Promise}\n         */\n        beforeOnAuthorize: function (data) {\n            return Promise.resolve(data);\n        },\n\n        /**\n         * On payment approve.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         * @return {Promise}\n         */\n        onApprove: function (data, actions) {\n            return this.beforeOnAuthorize(data, actions)\n                .then(performAuthorization.bind(this, this.authorizeOrderUrl))\n                .then(function (authData) {\n                    return this.afterOnAuthorize(authData, actions);\n                }.bind(this)).catch(function (error) {\n                    return this.catchOnAuthorize(error);\n                }.bind(this)).finally(function (error) {\n                    return this.finallyOnAuthorize(error);\n                }.bind(this));\n        },\n\n        /**\n         * Calls after successful payment authorization.\n         *\n         * @param {Object} authData\n         * @return {*}\n         */\n        afterOnAuthorize: function (authData) {\n            return authData;\n        },\n\n        /**\n         * Catch payment authorization errors.\n         */\n        catchOnAuthorize: function () {\n        },\n\n        /**\n         * Finally for payment authorization.\n         */\n        finallyOnAuthorize: function () {\n        },\n\n        /**\n         * Calls when shipping address chenges..\n         *\n         * @param {Object} data\n         */\n        onShippingChange: undefined,\n\n        /**\n         * Calls when error happened on paypal side.\n         *\n         * @param {Error} error\n         */\n        onError: function (error) {\n            console.log('Error: ', error.message);\n        },\n\n        /**\n         * Calls when user canceled payment.\n         */\n        onCancel: function () {}\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/method-renderer/google-pay.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'Magento_Checkout/js/model/quote',\n    'mage/translate',\n    'Magento_PaymentServicesPaypal/js/view/payment/methods/google-pay',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/action/set-billing-address',\n    'Magento_Ui/js/model/messageList',\n    'uiRegistry',\n    'Magento_Customer/js/customer-data'\n], function (\n    Component,\n    $,\n    _,\n    utils,\n    quote,\n    $t,\n    GooglePayButton,\n    additionalValidators,\n    setBillingAddressAction,\n    globalMessageList,\n    registry,\n    customerData\n) {\n    'use strict';\n\n    var refreshCustomerData = function (url) {\n        // Trigger ajaxComplete event to update customer data\n        customerData.onAjaxComplete(\n            {},\n            {\n                type: 'POST',\n                url: url,\n            }\n        );\n    }\n\n    return Component.extend({\n        defaults: {\n            buttonContainerId: 'google-pay-${ $.uid }',\n            template: 'Magento_PaymentServicesPaypal/payment/google-pay',\n            isAvailable: false,\n            isButtonRendered: false,\n            paymentsOrderId: null,\n            paypalOrderId: null,\n            paymentTypeIconTitle: $t('Pay with Google Pay'),\n            requestProcessingError: $t('Error happened when processing the request. Please try again later.'),\n            notEligibleErrorMessage: $t('This payment option is currently unavailable.'),\n            paymentTypeIconUrl:  window.checkoutConfig.payment['payment_services_paypal_google_pay'].paymentTypeIconUrl,\n            fundingSource: window.checkoutConfig.payment['payment_services_paypal_google_pay'].paymentSource\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config) {\n            _.bindAll(this, 'catchError', 'beforeCreateOrder', 'afterCreateOrder', 'placeOrder', 'onClick');\n            config.uid = utils.uniqueid();\n            this._super();\n            this.initGooglePayButton();\n\n            return this;\n        },\n\n        /**\n         * Initialize observables\n         *\n         * @returns {Component} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe('isAvailable isButtonRendered');\n\n            return this;\n        },\n\n        initGooglePayButton: function () {\n            this.googlePayButton = new GooglePayButton({\n                scriptParams: window.checkoutConfig.payment[this.getCode()].sdkParams,\n                createOrderUrl: window.checkoutConfig.payment[this.getCode()].createOrderUrl,\n                onClick: this.onClick,\n                beforeCreateOrder: this.beforeCreateOrder,\n                afterCreateOrder: this.afterCreateOrder,\n                catchCreateOrder: this.catchError,\n                onError: this.catchError,\n                buttonContainerId: this.buttonContainerId,\n                onApprove: this.placeOrder,\n                styles: window.checkoutConfig.payment[this.getCode()].styles,\n                mode: window.checkoutConfig.payment[this.getCode()].mode,\n                shippingAddressRequired: false,\n                getOrderDetailsUrl: window.checkoutConfig.payment[this.getCode()].getOrderDetailsUrl,\n                threeDSMode: window.checkoutConfig.payment[this.getCode()].threeDSMode,\n                location: window.checkoutConfig.payment[this.getCode()].location,\n            });\n\n            if (!this.isPlaceOrderActionAllowed()) {\n                this.googlePayButton.disableButton();\n            }\n\n            this.isPlaceOrderActionAllowed.subscribe(function (isAllowed) {\n                if (isAllowed) {\n                    this.googlePayButton.enableButton();\n                } else {\n                    this.googlePayButton.disableButton();\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Get method code\n         *\n         * @return {String}\n         */\n        getCode: function () {\n            return 'payment_services_paypal_google_pay';\n        },\n\n        /**\n         * Get method data\n         *\n         * @return {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'additional_data': {\n                    'payments_order_id': this.paymentsOrderId,\n                    'paypal_order_id': this.paypalOrderId,\n                    'payment_source': this.fundingSource\n                }\n            };\n        },\n\n        onClick: function () {\n            this.googlePayButton.showLoaderAsync(true)\n                .then(() => {\n                    return this.googlePayButton.createOrder();\n                })\n                .then(() => {\n                    refreshCustomerData(window.checkoutConfig.payment[this.getCode()].createOrderUrl);\n                })\n                .catch(error => {\n                    this.catchError(error);\n                });\n        },\n\n        /**\n         * Render buttons\n         */\n        afterRender: function () {\n            this.googlePayButton.sdkLoaded\n                .then(function () {\n                    this.googlePayButton.initGoogleSDK()\n                        .then(function () {\n                            this.isAvailable(this.googlePayButton.isEligible());\n                        }.bind(this)).catch(function () {\n                            this.isAvailable(false);\n                        }.bind(this)).finally(function () {\n                            this.isButtonRendered(true);\n                        }.bind(this)\n                    );\n                }.bind(this));\n        },\n\n        /**\n         * Before order created.\n         *\n         * @return {Promise}\n         */\n        beforeCreateOrder: function () {\n            if (this.validate() && this.isPlaceOrderActionAllowed() && additionalValidators.validate()) {\n                setBillingAddressAction(globalMessageList)\n                    .fail(function () {\n                        throw {message: 'Failed to set billing address'};\n                    });\n            } else {\n                throw {message: 'before create order validation failed', hidden: true};\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        validate: function () {\n            var isShippingValid = true,\n                source, shippingAddress;\n\n            if (!this._super()) {\n                return false;\n            }\n            source = registry.get('checkoutProvider');\n            shippingAddress = registry.get('index = shippingAddress');\n\n            if (source && shippingAddress) {\n                source.set('params.invalid', false);\n                if (quote.billingAddress() === null) {\n                    this.triggerBillingValidation(source);\n                }\n\n                // skip shipping validation if quote is virtual or in-store pickup\n                if (!quote.isVirtual() && !quote.shippingMethod()['method_code'] === 'pickup') {\n                    isShippingValid = shippingAddress.validateShippingInformation();\n                }\n\n                return isShippingValid && !source.get('params.invalid');\n            }\n\n            return true;\n        },\n\n        /**\n         * Trigger billing address validation\n         *\n         * @param {Object} source\n         */\n        triggerBillingValidation: function (source) {\n            var dataScope = `billingAddress${ window.checkoutConfig.displayBillingOnPaymentMethod ?\n                this.getCode() : 'shared'}`;\n\n            source.trigger(`${ dataScope }.data.validate`);\n\n            if (source.get(`${dataScope}.custom_attributes`)) {\n                source.trigger(`${dataScope}.custom_attributes.data.validate`);\n            }\n        },\n\n        /**\n         * After order created.\n         *\n         * @param {Object} data\n         * @return {String}\n         */\n        afterCreateOrder: function (data) {\n            if (data.response['paypal-order'] && data.response['paypal-order']['mp_order_id']) {\n                this.paymentsOrderId = data.response['paypal-order']['mp_order_id'];\n                this.paypalOrderId = data.response['paypal-order'].id;\n\n                let displayItems = [],\n                    subTotal = this.getTotalsSegment('subtotal'),\n                    shippingTotal = this.getTotalsSegment('shipping'),\n                    taxTotal = this.getTotalsSegment('tax'),\n                    discountTotal = this.getTotalsSegment('discount');\n\n                if (subTotal != null) {\n                    displayItems.push(\n                        {\n                            label: $t('Subtotal'),\n                            type: 'SUBTOTAL',\n                            price: subTotal.value.toString()\n                        }\n                    );\n                }\n                if (taxTotal != null) {\n                    displayItems.push(\n                        {\n                            label: $t('Tax'),\n                            type: 'TAX',\n                            price: taxTotal.value.toString()\n                        }\n                    );\n                }\n\n                if (shippingTotal != null) {\n                    displayItems.push(\n                        {\n                            label: $t('Shipping'),\n                            type: 'LINE_ITEM',\n                            price: shippingTotal.value.toString()\n                        }\n                    );\n                }\n\n                if (discountTotal != null) {\n                    displayItems.push(\n                        {\n                            label: $t('Discount'),\n                            type: 'LINE_ITEM',\n                            price: discountTotal.value.toString()\n                        }\n                    );\n                }\n\n                this.googlePayButton.showPopup({\n                    displayItems: displayItems,\n                    currencyCode: quote.totals()['base_currency_code'].toString(),\n                    totalPriceStatus: 'FINAL',\n                    totalPrice: quote.totals()['base_grand_total'].toString(),\n                    totalPriceLabel: $t('Total')\n                });\n\n                return this.paypalOrderId;\n            }\n\n            throw new Error();\n        },\n\n        /**\n         * Catch error.\n         *\n         * @param {Error} error\n         */\n        catchError: function (error) {\n            if (error.hidden === undefined || !error.hidden) {\n                this.messageContainer.addErrorMessage({\n                    message: this.requestProcessingError\n                });\n            }\n\n            this.googlePayButton.showLoader(false);\n\n            console.log('Error: ', error);\n        },\n\n        getTotalsSegment: function (code) {\n            var segment = null;\n\n            if (!('total_segments' in quote.totals())) {\n                return null;\n            }\n\n            quote.totals()['total_segments'].forEach(function (s) {\n                if (s.code === code) {\n                    segment = s;\n                }\n            });\n\n            return segment;\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/method-renderer/apple-pay.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/translate',\n    'Magento_PaymentServicesPaypal/js/view/payment/methods/apple-pay',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/action/set-billing-address',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Customer/js/customer-data'\n], function (\n    Component,\n    $,\n    _,\n    utils,\n    quote,\n    fullScreenLoader,\n    $t,\n    ApplePayButton,\n    additionalValidators,\n    setBillingAddressAction,\n    globalMessageList,\n    customerData\n) {\n    'use strict';\n\n    var refreshCustomerData = function (url) {\n        // Trigger ajaxComplete event to update customer data\n        customerData.onAjaxComplete(\n            {},\n            {\n                type: 'POST',\n                url: url,\n            }\n        );\n    }\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalApplePay',\n            fundingSource: 'applepay',\n            buttonContainerId: 'apple-pay-${ $.uid }',\n            template: 'Magento_PaymentServicesPaypal/payment/apple-pay',\n            isAvailable: false,\n            isButtonRendered: false,\n            grandTotalAmount: null,\n            paymentsOrderId: null,\n            paypalOrderId: null,\n            paymentTypeIconTitle: $t('Pay with Apple Pay'),\n            requestProcessingError: $t('Error happened when processing the request. Please try again later.'),\n            notEligibleErrorMessage: $t('This payment option is currently unavailable.'),\n            paymentTypeIconUrl: window.checkoutConfig.payment['payment_services_paypal_apple_pay'].paymentTypeIconUrl\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config) {\n            _.bindAll(this, 'catchError', 'beforeCreateOrder', 'afterCreateOrder', 'placeOrder', 'onClick');\n            config.uid = utils.uniqueid();\n            this._super();\n            this.initApplePayButton();\n\n            return this;\n        },\n\n        /**\n         * Initialize observables\n         *\n         * @returns {Component} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe('grandTotalAmount isAvailable isButtonRendered');\n            this.grandTotalAmount(quote.totals()['base_grand_total']);\n\n            return this;\n        },\n\n        /**\n         * Create instance of smart buttons.\n         */\n        initApplePayButton: function () {\n            this.applePayButton = new ApplePayButton({\n                scriptParams: window.checkoutConfig.payment[this.getCode()].sdkParams,\n                createOrderUrl: window.checkoutConfig.payment[this.getCode()].createOrderUrl,\n                estimateShippingMethodsWhenLoggedInUrl: window.checkoutConfig.payment[this.getCode()].estimateShippingMethodsWhenLoggedInUrl,\n                estimateShippingMethodsWhenGuestUrl: window.checkoutConfig.payment[this.getCode()].estimateShippingMethodsWhenGuestUrl,\n                shippingInformationWhenLoggedInUrl: window.checkoutConfig.payment[this.getCode()].shippingInformationWhenLoggedInUrl,\n                shippingInformationWhenGuestUrl: window.checkoutConfig.payment[this.getCode()].shippingInformationWhenGuestUrl,\n                updatePayPalOrderUrl: window.checkoutConfig.payment[this.getCode()].updatePayPalOrderUrl,\n                countriesUrl: window.checkoutConfig.payment[this.getCode()].countriesUrl,\n                onClick: this.onClick,\n                beforeCreateOrder: this.beforeCreateOrder,\n                afterCreateOrder: this.afterCreateOrder,\n                catchCreateOrder: this.catchError,\n                onError: this.catchError,\n                buttonContainerId: this.buttonContainerId,\n                onApprove: this.placeOrder,\n                styles: window.checkoutConfig.payment[this.getCode()].buttonStyles,\n                location: window.checkoutConfig.payment[this.getCode()].location,\n            });\n        },\n\n        /**\n         * Get method code\n         *\n         * @return {String}\n         */\n        getCode: function () {\n            return 'payment_services_paypal_apple_pay';\n        },\n\n        /**\n         * Get method data\n         *\n         * @return {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'additional_data': {\n                    'payments_order_id': this.paymentsOrderId,\n                    'paypal_order_id': this.paypalOrderId,\n                    'payment_source': this.fundingSource\n                }\n            };\n        },\n\n        /**\n         * Render buttons\n         */\n        afterRender: function () {\n            this.applePayButton.sdkLoaded\n                .then(this.applePayButton.initAppleSDK)\n                .then(function () {\n                        this.isAvailable(true);\n                        this.isButtonRendered(true);\n                    }.bind(this)\n                ).catch(function () {\n                this.isAvailable(false);\n            }.bind(this)).finally(function () {\n                this.isButtonRendered(true);\n            }.bind(this));\n        },\n\n        /**\n         * Enable/disable buttons.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         */\n        onInit: function (data, actions) {\n            if (!this.isPlaceOrderActionAllowed()) {\n                actions.disable();\n            }\n\n            this.isPlaceOrderActionAllowed.subscribe(function (isAllowed) {\n                if (isAllowed) {\n                    actions.enable();\n                } else {\n                    actions.disable();\n                }\n            });\n        },\n\n        /**\n         * Validate form onClick\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         * @return {*}\n         */\n        onClick: function (data, actions) {\n            this.applePayButton.showLoaderAsync(true)\n                .then(() => {\n                    this.applePayButton.createOrder();\n                })\n                .then(() => {\n                    refreshCustomerData(window.checkoutConfig.payment[this.getCode()].createOrderUrl);\n                })\n                .catch(error => {\n                    this.catchError(error);\n                });\n        },\n\n        /**\n         * Before order created.\n         *\n         * @return {Promise}\n         */\n        beforeCreateOrder: function () {\n            if (this.validate() && this.isPlaceOrderActionAllowed() && additionalValidators.validate()) {\n                return new Promise(function (resolve, reject) {\n                    setBillingAddressAction(globalMessageList).done(resolve.bind(null, null)).fail(reject);\n                });\n            } else {\n                throw {message: 'before create order validation failed', hidden: true};\n            }\n        },\n\n        /**\n         * After order created.\n         *\n         * @param {Object} data\n         * @return {String}\n         */\n        afterCreateOrder: function (data) {\n            if (data.response['paypal-order'] && data.response['paypal-order']['mp_order_id']) {\n                this.paymentsOrderId = data.response['paypal-order']['mp_order_id'];\n                this.paypalOrderId = data.response['paypal-order'].id;\n\n                this.applePayButton.showPopup(data, quote);\n\n                return this.paypalOrderId;\n            }\n\n            throw new Error();\n        },\n\n        /**\n         * Catch error.\n         *\n         * @param {Error} error\n         */\n        catchError: function (error) {\n            this.messageContainer.addErrorMessage({\n                message: this.requestProcessingError\n            });\n            console.log('Error: ', error.message);\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/method-renderer/hosted-fields.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_PaymentServicesPaypal/js/view/errors/response-error',\n    'Magento_Checkout/js/action/set-billing-address',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Vault/js/view/payment/vault-enabler',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_PaymentServicesPaypal/js/lib/script-loader',\n    'ko'\n], function (\n    $,\n    _,\n    $t,\n    Component,\n    quote,\n    loader,\n    ResponseError,\n    setBillingAddressAction,\n    globalMessageList,\n    VaultEnabler,\n    additionalValidators,\n    scriptLoader,\n    ko\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isFormValid: false,\n            invalidFields: [],\n            isAvailable: false,\n            isFormRendered: false,\n            fields: {\n                number: {\n                    class: 'card-number-field',\n                    label: $t('Credit Card Number'),\n                    errorMessage: $t('Please enter a valid credit card number.'),\n                    selector: '#${ $.formId } .${ $.fields.number.class }',\n                    placeholder: '',\n                    showLockIcon: true\n                },\n                expirationDate: {\n                    class: 'expiration-date-field',\n                    selector: '#${ $.formId } .expiration-date-field',\n                    label: $t('Expiration Date'),\n                    errorMessage: $t('Incorrect credit card expiration date.'),\n                    placeholder: 'MM/YY'\n                },\n                cvv: {\n                    class: 'cvv-field',\n                    selector: '#${ $.formId } .cvv-field',\n                    label: $t('Card Security Code'),\n                    errorMessage: $t('Please enter a valid credit card security code.'),\n                    tooltip: {\n                        title: $t('What is this?'),\n                        src:  $.cvvImgUrl,\n                        contentUnsanitizedHtml: '<img src=\"${ $.cvvImgUrl }\" ' +\n                            'alt=\"${ $.cvvTitle }\" title=\"${ $.cvvTitle }\" />'\n                    },\n                    placeholder: ''\n                }\n            },\n            cardsByCode: {\n                \"amex\": \"AE\",\n                \"discover\": \"DI\",\n                \"elo\": \"ELO\",\n                \"hiper\": \"HC\",\n                \"jcb\": \"JCB\",\n                \"mastercard\": \"MC\",\n                \"visa\": \"VI\",\n            },\n            cards: {\n                AE: {\n                    eligibilityCode: 'amex',\n                    typeCode: 'american-express'\n                },\n                DI: {\n                    eligibilityCode: 'discover',\n                    typeCode: 'discover'\n                },\n                ELO: {\n                    eligibilityCode: 'elo',\n                    typeCode: 'elo'\n                },\n                HC: {\n                    eligibilityCode: 'hiper',\n                    typeCode: 'hiper'\n                },\n                JCB: {\n                    eligibilityCode: 'jcb',\n                    typeCode: 'jcb'\n                },\n                MC: {\n                    eligibilityCode: 'mastercard',\n                    typeCode: 'master-card'\n                },\n                VI: {\n                    eligibilityCode: 'visa',\n                    typeCode: 'visa'\n                }\n            },\n            orderCreateErrorMessage: {\n                default: $t('Failed to place order. Try again or refresh the page if that does not resolve the issue.'), // eslint-disable-line max-len,\n                'POSTAL_CODE_REQUIRED': $t('Postal code is required.'),\n                'CITY_REQUIRED': $t('City is required.')\n            },\n            availableCards: [],\n            getOrderDetailsUrl: window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].getOrderDetailsUrl, // eslint-disable-line max-len\n            requiresCardDetails: window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].requiresCardDetails, // eslint-disable-line max-len\n            ccIcons: window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].ccIcons,\n            paymentSource: window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].paymentSource,\n            cvvImgUrl:  window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].cvvImageUrl,\n            isCommerceVaultEnabled: window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].isCommerceVaultEnabled, // eslint-disable-line max-len\n            emptyErrorMessage: $t('This is a required field.'),\n            paymentTypeIconUrl:  window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].paymentTypeIconUrl, // eslint-disable-line max-len\n            paymentTypeIconTitle: $t('Pay with credit card'),\n            lockTitle: $t('Secure transaction'),\n            cvvTitle: $t('The card security code is a three or four digit number printed on a credit card. Visa, Mastercard, and Discover cards have a three digit code on the card back. American Express cards have a four digit code on the card front.'), // eslint-disable-line max-len\n            paymentMethodValidationError: $t('Your payment was not successful. Ensure you have entered your details correctly and try again, or try a different payment method. If you have continued problems, contact the issuing bank for your payment method.'), // eslint-disable-line max-len\n            notEligibleErrorMessage: $t('This payment option is currently unavailable.'),\n            generalErrorMessage: '${ $.paymentMethodValidationError }',\n            placeOrderTitle: $t('Place Order'),\n            formId: 'hosted-fields-form',\n            template: 'Magento_PaymentServicesPaypal/payment/credit-card',\n            ccType: '',\n            billingAddress: quote.billingAddress,\n            paymentsOrderId: null,\n            paypalOrderId: null,\n            cardBin: null,\n            holderName: null,\n            cardLast4: null,\n            cardExpiryMonth: null,\n            cardExpiryYear: null,\n            hostedFields: null,\n            shouldCardBeVaulted: false,\n\n            paymentsSdk: null,\n            paymentsSdkInitPromise: null,\n            isInProgress: ko.observable(false),\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'onError',\n                'getOrderCardDetails'\n            );\n            this._super();\n            this.initPaymentsSDK();\n            this.initVaulting();\n\n            return this;\n        },\n\n        /**\n         * Initialize Payments SDK\n         * Load js script and initialize SDK\n         */\n        initPaymentsSDK: function () {\n            this.paymentsSdkInitPromise = new Promise(\n                function (resolve, reject) {\n                    scriptLoader.loadCustom({url: this.getPaymentsSDKUrl()})\n                        .then(function () {\n                            const sdkConfig = {\n                                storeViewCode: this.getGraphQLStoreCode()\n                            }\n\n                            if (this.getGraphQLToken()) {\n                                sdkConfig.getCustomerToken = () => this.getGraphQLToken();\n                            }\n\n                            if (this.getGraphQLUrl()) {\n                                sdkConfig.apiUrl = this.getGraphQLUrl();\n                            }\n\n                            this.paymentsSdk = new window.PaymentServicesSDK(sdkConfig);\n\n                            this.paymentsSdk.Payment.init({location: \"CHECKOUT\"})\n                                .then(() => {resolve()})\n                                .catch((e) => {reject(e)});\n                        }.bind(this)).catch((e) => {reject(e)});\n                }.bind(this)\n            );\n        },\n\n        /**\n         * Initialize vaulting\n         */\n        initVaulting: function () {\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.isActivePaymentTokenEnabler(false);\n            this.vaultEnabler.setPaymentCode(window.checkoutConfig.payment[this.getCode()].ccVaultCode);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('billingAddress paymentsOrderId paypalOrderId cardBin ' +\n                    'holderName cardLast4 cardExpiryMonth cardExpiryYear ' +\n                    'ccType isFormValid invalidFields availableCards isAvailable isFormRendered shouldCardBeVaulted');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        getCode: function () {\n            return 'payment_services_paypal_hosted_fields';\n        },\n\n        /** @inheritdoc */\n        getData: function () {\n            var data = this._super();\n\n            data['additional_data'] = {\n                payments_order_id: this.paymentsOrderId(),\n                paypal_order_id: this.paypalOrderId(),\n                payment_source: this.paymentSource\n            };\n\n            if (this.cardBin()) {\n                data['additional_data']['cardBin'] = this.cardBin();\n            }\n\n            if (this.holderName()) {\n                data['additional_data']['holderName'] = this.holderName();\n            }\n\n            if (this.cardLast4()) {\n                data['additional_data']['cardLast4'] = this.cardLast4();\n            }\n\n            if (this.cardExpiryMonth()) {\n                data['additional_data']['cardExpiryMonth'] = this.cardExpiryMonth();\n            }\n\n            if (this.cardExpiryYear()) {\n                data['additional_data']['cardExpiryYear'] = this.cardExpiryYear();\n            }\n\n            this.vaultEnabler.visitAdditionalData(data);\n            return data;\n        },\n\n        /** @inheritdoc */\n        afterRender: function () {\n            this.$form = $('#' + this.formId);\n\n            this.paymentsSdkInitPromise.then(function () {\n                this.isAvailable(this.paymentsSdk.Payment.CreditCard.isAvailable())\n\n                if (!this.isAvailable()) {\n                    this.isFormRendered(true);\n                    return;\n                }\n\n                this.paymentsSdk.Payment.CreditCard.render({\n                    fields: {\n                        number: {\n                            selector: this.fields.number.selector,\n                            label: this.fields.number.label,\n                            class: this.fields.number.class,\n                        },\n                        expirationDate: {\n                            selector: this.fields.expirationDate.selector,\n                            label: this.fields.expirationDate.label,\n                            class: this.fields.expirationDate.class,\n                        },\n                        cvv: {\n                            selector: this.fields.cvv.selector,\n                            label: this.fields.cvv.label,\n                            class: this.fields.cvv.class,\n                        },\n                    },\n                    styles: {\n                        input: {\n                            color: '#ccc',\n                            'font-family': '\"Open Sans\",\"Helvetica Neue\",Helvetica,Arial,sans-serif',\n                            'font-size': '16px',\n                            'font-weight': '400'\n                        },\n                        ':focus': {\n                            color: '#333'\n                        },\n                        '.valid': {\n                            color: '#333'\n                        }\n                    },\n                    onRender: this.onRender.bind(this),\n                    getCartId: this.getMaskedCardId,\n                    onStart: this.onStart.bind(this),\n                    onSuccess: this.onSuccess.bind(this),\n                    getBillingAddress: this.getBillingAddress.bind(this),\n                    getShouldVaultCard: () => this.isCommerceVaultEnabled && this.checkShouldCardBeVaulted(),\n                    onValidityChange: this.onValidityChange.bind(this),\n                    onCardTypeChange: this.onCardTypeChange.bind(this),\n                    onError: this.onError.bind(this),\n                    getShouldSetPaymentMethodOnCard: () => false,\n                });\n            }.bind(this))\n                .catch((e) => {\n                    console.log('Error initializing Payments SDK', e);\n                    this.isFormRendered(true);\n                    this.isAvailable(false);\n                });\n        },\n\n        /**\n         * Get masked cart id\n         */\n        getMaskedCardId: function () {\n            return window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].quoteMaskedId;\n        },\n\n        /**\n         * Get Payments SDK URL to load JS script\n         */\n        getPaymentsSDKUrl: function () {\n            return window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].paymentsSDKUrl;\n        },\n\n        /**\n         * Get GraphQL store code to use in GraphQL requests\n         */\n        getGraphQLStoreCode: function () {\n            return window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].storeViewCode;\n        },\n\n        /**\n         * Get GraphQL edpoint\n         */\n        getGraphQLUrl: function () {\n            return window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].graphQLEndpointUrl;\n        },\n\n        /**\n         * Get GraphQL token for authentication\n         */\n        getGraphQLToken: function () {\n            return window.checkoutConfig.payment['payment_services_paypal_hosted_fields'].oauthToken;\n        },\n\n        /**\n         * Provide billing address for the order\n         */\n        getBillingAddress: function () {\n            return {\n                firstName: this.billingAddress().firstname,\n                lastName: this.billingAddress().lastname,\n                streetAddress: this.billingAddress().street[0],\n                extendedAddress: this.billingAddress().street[1],\n                region: this.billingAddress().region,\n                locality: this.billingAddress().city,\n                postalCode: this.billingAddress().postcode,\n                countryCodeAlpha2: this.billingAddress().countryId,\n            };\n        },\n\n        /**\n         * Start callback for Hosted Fields\n         * Called when the form is submitted\n         *\n         * @param preventCheckout\n         * @returns {Promise<void>}\n         */\n        onStart: async function (preventCheckout) {\n            if (!this.canProceedWithOrder()) {\n                preventCheckout(\"invalid form\");\n            }\n\n            loader.startLoader();\n\n            await setBillingAddressAction(globalMessageList);\n        },\n\n        /**\n         * Success callback for Hosted Fields\n         * Called when PP order is created and card details are collected\n         *\n         * @param data\n         */\n        onSuccess: function (data) {\n            this.paymentsOrderId(data.mpOrderId);\n            this.paypalOrderId(data.payPalOrderId);\n\n            this.getOrderCardDetails()\n                .then(this.placeOrder.bind(this))\n                .catch(this.onError.bind(this));\n        },\n\n        /**\n         * Called after Hosted Fields are rendered\n         *\n         * @param hostedFields\n         */\n        onRender: function (hostedFields)  {\n            this.isFormValid(false);\n            this.ccType('');\n            this.invalidFields([]);\n\n            var cards = hostedFields.getEligibleCards()\n                .filter(card => this.cardsByCode[card.code] !== undefined)\n                .map(card => this.cardsByCode[card.code]);\n\n            this.availableCards(cards);\n\n            this.$form.off('submit');\n            this.$form.on('submit', function (e) {\n                e.preventDefault();\n                this.isInProgress(true);\n                hostedFields.submit()\n                    .catch(this.onError.bind(this))\n                    .finally(function () {\n                        loader.stopLoader();\n                        this.isInProgress(false);\n                    }.bind(this));\n            }.bind(this));\n\n            this.isFormRendered(true);\n        },\n\n        /**\n         * Validity change handler.\n         *\n         * @param {Object} hostedFields\n         * @param {Object} event\n         */\n        onValidityChange: function (fields, emittedBy) {\n            var valid = _.every(fields, function (field) {return field.isValid});\n            var invalidFields = this.invalidFields().filter(field => field.name !== emittedBy);\n\n            if (!valid) {\n                if (fields[emittedBy] && !fields[emittedBy].isValid) {\n                    invalidFields.push({\n                        name: emittedBy,\n                        message: fields[emittedBy].isEmpty ? this.emptyErrorMessage : this.fields[emittedBy].errorMessage\n                    });\n                }\n                this.invalidFields(invalidFields)\n            }\n\n            this.isFormValid(valid);\n            this.isFormValid() && this.invalidFields([]);\n        },\n\n        /**\n         * Check if field is valid.\n         *\n         * @param {String} fieldName\n         * @return {Boolean}\n         */\n        isFieldValid: function (fieldName) {\n            return !this.invalidFields.findWhere({\n                name: fieldName\n            });\n        },\n\n        /**\n         * Get error message for field.\n         *\n         * @param {String} fieldName\n         * @return {String}\n         */\n        getFieldErrorMessage: function (fieldName) {\n            return !this.isFieldValid(fieldName) ? this.invalidFields.findWhere({\n                name: fieldName\n            }).message : '';\n        },\n\n        /**\n         * Card type changes handler.\n         *\n         * @param {Array} a list of cards\n         */\n        onCardTypeChange: function (cards) {\n            var code = '';\n\n            if (cards.length === 1 && this.cardsByCode[cards[0].code]) {\n                code = this.cardsByCode[cards[0].code]\n            }\n\n            this.ccType(code);\n        },\n\n        /**\n         * Get order card details\n         * Used when Signifyd is enabled and requires card details\n         *\n         * @param response\n         * @returns {Promise<any>|Promise<Awaited<unknown>>}\n         */\n        getOrderCardDetails: function (response) {\n            if (!this.requiresCardDetails) {\n                return Promise.resolve(response);\n            }\n\n            return fetch(`${this.getOrderDetailsUrl}`, {\n                method: 'GET'\n            }).then(function (res) {\n                return res.json();\n            }).then(function (data) {\n                if (data.response['is_successful'] && data.response['paypal-order']) {\n                    const order = data.response['paypal-order'];\n\n                    this.cardBin(order?.payment_source_details?.card?.bin_details?.bin);\n                    this.holderName(order?.payment_source_details?.card?.name);\n                    this.cardLast4(order?.payment_source_details?.card?.last_digits);\n                    this.cardExpiryMonth(order?.payment_source_details?.card?.card_expiry_month);\n                    this.cardExpiryYear(order?.payment_source_details?.card?.card_expiry_year);\n                }\n\n                return response;\n            }.bind(this)).catch(function (err) {\n                console.log(\n                    'Could not get order details. Proceeding with order placement without card details',\n                    err\n                );\n                return response;\n            });\n        },\n\n        /**\n         * Error callback for transaction.\n         */\n        onError: function (error) {\n            loader.stopLoader();\n            var message = this.generalErrorMessage;\n\n            if (error instanceof ResponseError) {\n                message = error.message;\n            } else if (error['debug_id']) {\n                message = this.paymentMethodValidationError;\n            }\n\n            if (this.isOrderCreateError(error)) {\n                message = this.parseOrderCreateError(error);\n            }\n\n            this.messageContainer.addErrorMessage({\n                message: message\n            });\n\n            if (error instanceof Error) {\n                console.log(error.toString());\n            } else {\n                console.log('Error' + JSON.stringify(error));\n            }\n        },\n\n        /**\n         * Place order\n         * Click event handler for place order button\n         */\n        placeOrderClick: function () {\n            if (this.isPlaceOrderActionAllowed() === true) {\n                $('#' + this.formId).trigger('submit');\n            }\n        },\n\n        /**\n         * Check if customer checks the \"Save for later\" box upon checkout\n         *\n         * @returns {*}\n         */\n        checkShouldCardBeVaulted: function () {\n            const checked = this.vaultEnabler.isActivePaymentTokenEnabler();\n\n            this.shouldCardBeVaulted(checked);\n            return checked;\n        },\n\n        /**\n         * Check if the form is valid and the order can be placed\n         *\n         * @returns {*}\n         */\n        canProceedWithOrder: function () {\n            return this.validate()\n                && additionalValidators.validate()\n                && this.isFormValid()\n                && this.isPlaceOrderActionAllowed();\n        },\n\n        isOrderCreateError: function (error) {\n            return error?.cause?.graphQLErrors\n                ?.find(e => e?.path?.join(\"\").indexOf(\"createPaymentOrder\") > -1) !== undefined;\n        },\n\n        parseOrderCreateError: function (error) {\n            if (this.isErrorCode(error, 'POSTAL_CODE_REQUIRED')) {\n                return this.orderCreateErrorMessage.POSTAL_CODE_REQUIRED;\n            }\n\n            if (this.isErrorCode(error, 'CITY_REQUIRED')) {\n                return this.orderCreateErrorMessage.CITY_REQUIRED;\n            }\n\n            return this.orderCreateErrorMessage.default;\n        },\n\n        isErrorCode: function (error, code) {\n            return error?.cause?.graphQLErrors\n                ?.find(e => e?.path?.join(\"\").indexOf(\"createPaymentOrder\") > -1)\n                ?.extensions?.debugMessage?.indexOf(code) > -1;\n        }\n\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/method-renderer/smart-buttons.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'mage/translate',\n    'Magento_PaymentServicesPaypal/js/view/payment/methods/smart-buttons',\n    'Magento_PaymentServicesPaypal/js/view/payment/message',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/action/set-billing-address',\n    'Magento_Ui/js/model/messageList',\n    'uiRegistry',\n    'Magento_Customer/js/customer-data'\n], function (\n    Component,\n    $,\n    _,\n    utils,\n    quote,\n    fullScreenLoader,\n    $t,\n    SmartButtons,\n    Message,\n    additionalValidators,\n    setBillingAddressAction,\n    globalMessageList,\n    registry,\n    customerData\n) {\n    'use strict';\n\n    var refreshCustomerData = function (url) {\n        // Trigger ajaxComplete event to update customer data\n        customerData.onAjaxComplete(\n            {},\n            {\n                type: 'POST',\n                url: url,\n            }\n        );\n    }\n\n    return Component.extend({\n        defaults: {\n            sdkNamespace: 'paypalCheckoutButtons',\n            buttonsContainerId: 'smart-buttons-${ $.uid }',\n            payLaterMessageContainerId: 'pay-later-message-${ $.uid }',\n            template: 'Magento_PaymentServicesPaypal/payment/smart-buttons',\n            isAvailable: false,\n            isButtonsRendered: false,\n            grandTotalAmount: null,\n            paymentsOrderId: null,\n            paypalOrderId: null,\n            requestProcessingError: $t('Error happened when processing the request. Please try again later.'),\n            notEligibleErrorMessage: $t('This payment option is currently unavailable.'),\n            paymentTypeIconUrl: window.checkoutConfig.payment['payment_services_paypal_smart_buttons'].paymentTypeIconUrl, // eslint-disable-line max-len\n            paymentTypeIconTitle: $t('Pay with PayPal')\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function (config) {\n            _.bindAll(this, 'onClick', 'onInit', 'catchError', 'beforeCreateOrder', 'afterCreateOrder');\n            config.uid = utils.uniqueid();\n            this._super();\n            this.initSmartButtons();\n            this.initMessage();\n            quote.totals.subscribe(function (totals) {\n                this.grandTotalAmount(totals['base_grand_total']);\n                this.message.updateAmount(totals['base_grand_total']);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initialize observables\n         *\n         * @returns {Component} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe('grandTotalAmount isAvailable isButtonsRendered');\n            this.grandTotalAmount(quote.totals()['base_grand_total']);\n\n            return this;\n        },\n\n        /**\n         * Create instance of smart buttons.\n         */\n        initSmartButtons: function () {\n            this.buttons = new SmartButtons({\n                sdkNamespace: this.sdkNamespace,\n                scriptParams: window.checkoutConfig.payment['payment_services_paypal_smart_buttons'].sdkParams,\n                createOrderUrl: window.checkoutConfig.payment['payment_services_paypal_smart_buttons'].createOrderUrl,\n                styles: window.checkoutConfig.payment['payment_services_paypal_smart_buttons'].buttonStyles,\n                onInit: this.onInit,\n                onClick: this.onClick,\n                beforeCreateOrder: this.beforeCreateOrder,\n                afterCreateOrder: this.afterCreateOrder,\n                catchCreateOrder: this.catchError,\n                onApprove: function () {\n                    this.placeOrder();\n                }.bind(this),\n                onError: this.catchError,\n                location: window.checkoutConfig.payment[this.getCode()].location,\n            });\n        },\n\n        /**\n         * Initialize message component\n         */\n        initMessage: function () {\n            this.message = new Message({\n                scriptParams: window.checkoutConfig.payment['payment_services_paypal_smart_buttons'].sdkParams,\n                element: this.element,\n                renderContainer: '#' + this.payLaterMessageContainerId,\n                styles: window.checkoutConfig.payment['payment_services_paypal_smart_buttons'].messageStyles,\n                placement: 'payment',\n                amount: this.grandTotalAmount()\n            });\n        },\n\n        /**\n         * Get method code\n         *\n         * @return {String}\n         */\n        getCode: function () {\n            return 'payment_services_paypal_smart_buttons';\n        },\n\n        /**\n         * Get method data\n         *\n         * @return {Object}\n         */\n        getData: function () {\n            return {\n                'method': this.item.method,\n                'additional_data': {\n                    'payments_order_id': this.paymentsOrderId,\n                    'paypal_order_id': this.paypalOrderId,\n                    'payment_source': this.buttons.paymentSource\n                }\n            };\n        },\n\n        /**\n         * Render buttons\n         */\n        afterRender: function () {\n            this.buttons.sdkLoaded.then(function () {\n                this.buttons.render('#' + this.buttonsContainerId);\n                this.renderMessage();\n                this.isAvailable(!!this.buttons.instance && this.buttons.instance.isEligible());\n            }.bind(this)).catch(function () {\n                this.isAvailable(false);\n\n                return this.buttons;\n            }.bind(this)).finally(function () {\n                this.isButtonsRendered(true);\n            }.bind(this));\n        },\n\n        /**\n         * Render message\n         */\n        renderMessage: function () {\n            if (window.checkoutConfig.payment['payment_services_paypal_smart_buttons'].canDisplayMessage) {\n                this.message.render();\n            }\n        },\n\n        /**\n         * Enable/disable buttons.\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         */\n        onInit: function (data, actions) {\n            if (!this.isPlaceOrderActionAllowed()) {\n                actions.disable();\n            }\n\n            this.isPlaceOrderActionAllowed.subscribe(function (isAllowed) {\n                if (isAllowed) {\n                    actions.enable();\n                } else {\n                    actions.disable();\n                }\n            });\n        },\n\n        /**\n         * @inheritdoc\n         */\n        validate: function () {\n            var isShippingValid = true,\n                source, shippingAddress;\n\n            if (!this._super()) {\n                return false;\n            }\n            source = registry.get('checkoutProvider');\n            shippingAddress = registry.get('index = shippingAddress');\n\n            if (source && shippingAddress) {\n                source.set('params.invalid', false);\n                if (quote.billingAddress() === null) {\n                    this.triggerBillingValidation(source);\n                }\n\n                // skip shipping validation if quote is virtual or in-store pickup\n                if (!quote.isVirtual() && !quote.shippingMethod()['method_code'] === 'pickup') {\n                    isShippingValid = shippingAddress.validateShippingInformation();\n                }\n\n                return isShippingValid && !source.get('params.invalid');\n            }\n\n            return true;\n        },\n\n        /**\n         * Trigger billing address validation\n         *\n         * @param {Object} source\n         */\n        triggerBillingValidation: function (source) {\n            var dataScope = `billingAddress${ window.checkoutConfig.displayBillingOnPaymentMethod ?\n                this.getCode() : 'shared'}`;\n\n            source.trigger(`${ dataScope }.data.validate`);\n\n            if (source.get(`${dataScope}.custom_attributes`)) {\n                source.trigger(`${dataScope}.custom_attributes.data.validate`);\n            }\n        },\n\n        /**\n         * Validate form onClick\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         * @return {*}\n         */\n        onClick: function (data, actions) {\n            if (this.validate() && additionalValidators.validate()) {\n                return actions.resolve();\n            }\n\n            return actions.reject();\n        },\n\n        /**\n         * Before order created.\n         *\n         * @return {Promise}\n         */\n        beforeCreateOrder: function () {\n            return new Promise(function (resolve, reject) {\n                setBillingAddressAction(globalMessageList).done(resolve.bind(null, null)).fail(reject);\n            });\n        },\n\n        /**\n         * After order created.\n         *\n         * @param {Object} data\n         * @return {String}\n         */\n        afterCreateOrder: function (data) {\n            if (data.response['paypal-order'] && data.response['paypal-order']['mp_order_id']) {\n                refreshCustomerData(window.checkoutConfig.payment[this.getCode()].createOrderUrl);\n\n                this.paymentsOrderId = data.response['paypal-order']['mp_order_id'];\n                this.paypalOrderId = data.response['paypal-order'].id;\n\n                return this.paypalOrderId;\n            }\n\n            throw new Error();\n        },\n\n        /**\n         * Catch error.\n         *\n         * @param {Error} error\n         */\n        catchError: function (error) {\n            this.messageContainer.addErrorMessage({\n                message: this.requestProcessingError\n            });\n            console.log('Error: ', error.message);\n        }\n\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 2013-2017 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Vault/js/view/payment/method-renderer/vault',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_PaymentServicesPaypal/js/view/errors/response-error',\n    'escaper'\n], function (\n    $t,\n    VaultComponent,\n    loader,\n    ResponseError,\n    escaper\n) {\n   'use strict';\n\n   return VaultComponent.extend({\n       defaults: {\n           template: 'Magento_PaymentServicesPaypal/payment/vault',\n           paymentSource: 'vault',\n           paypalOrderId: null,\n           paymentsOrderId: null,\n           generalErrorMessage: $t('An error occurred. Refresh the page and try again.'),\n           paymentMethodValidationError: $t('Your payment was not successful. Try again.'),\n           allowedTags: ['br'],\n       },\n\n       /**\n        * Get card brand\n        * @returns {String}\n        */\n       getCardBrand: function () {\n           return this.mapCardBrand(this.details.brand);\n       },\n\n       /**\n        * Map the credit card brand received from PayPal to the Commerce standard\n        * @param payPalCardBrand\n        * @returns {*}\n        */\n       mapCardBrand: function (payPalCardBrand) {\n           const cardBrandMapping = {\n               AMEX: 'AE',\n               DISCOVER: 'DI',\n               DINERS: 'DN',\n               ELO: 'ELO',\n               HIPER: 'HC',\n               JCB: 'JCB',\n               MAESTRO: 'MI',\n               MASTER_CARD: 'MC',\n               MASTERCARD: 'MC',\n               VISA: 'VI'\n           };\n\n           return cardBrandMapping[payPalCardBrand];\n       },\n\n       /**\n        * Get last 4 digits of card\n        * @returns {String}\n        */\n       getMaskedCard: function () {\n           return this.details.maskedCC;\n       },\n\n       /**\n        * Get card Description\n        * @returns {String}\n        */\n       getCardDescription: function () {\n           return this.details.description;\n       },\n\n       /**\n        * Get formatted card billing address\n        * @returns {String}\n        */\n       getFormattedCardBillingAddress: function () {\n           let billingAddress = this.details.billingAddress;\n\n           if (!billingAddress) {\n               return '';\n           }\n\n           let street1 = billingAddress.address_line_1 || '';\n           let street2 = billingAddress.address_line_2 || '';\n           let region = billingAddress.region || '';\n           let city = billingAddress.city || '';\n           let postalCode = billingAddress.postal_code || '';\n           let countryCode = billingAddress.country_code || '';\n\n           let formattedAddress = street1 + '<br/>';\n\n           if (street2 !== '') {\n               formattedAddress += street2 + '<br/>';\n           }\n\n           formattedAddress += region + ' ' + city + ' ' + postalCode + '<br/>' +\n               countryCode;\n\n           return this.getSafeHtml(formattedAddress);\n       },\n\n       /**\n        * Get card holder name\n        * @returns {String}\n        */\n       getCardHolderName: function () {\n           return this.details.cardholderName;\n       },\n\n       /**\n        * Sanitize text\n        *\n        * @param {String} html\n        * @returns {String}\n        */\n       getSafeHtml: function (html) {\n           return escaper.escapeHtml(html, this.allowedTags);\n       },\n\n       /**\n        * Get PayPal order ID\n        */\n       getData: function () {\n          let data = this._super();\n\n          data['additional_data']['paypal_order_id'] = this.paypalOrderId;\n          data['additional_data']['payments_order_id'] = this.paymentsOrderId;\n          data['additional_data']['public_hash'] = this.publicHash;\n          data['additional_data']['payment_source'] = this.paymentSource;\n          return data;\n       },\n\n       /**\n        * Place order\n        */\n       onPlaceOrder: function () {\n           loader.startLoader();\n           this.createOrder()\n               .then(function (order) {\n                   this.onOrderSuccess(order);\n               }.bind(this))\n               .then(function () {\n                   this.placeOrder();\n               }.bind(this))\n               .catch(this.onError.bind(this))\n               .finally(loader.stopLoader);\n       },\n\n       /**\n        * Create PayPal order\n        * @returns {Promise<any>}\n        */\n       createOrder: function () {\n           var orderData = new FormData();\n\n           orderData.append('payment_source', this.paymentSource);\n           orderData.append('location', this.location);\n\n           return fetch(this.createOrderUrl, {\n               method: 'POST',\n               headers: {},\n               body: orderData,\n               credentials: 'same-origin'\n           }).then(function (res) {\n               return res.json();\n           }).then(function (data) {\n               if (data.response['is_successful']) {\n                   return data.response['paypal-order'];\n               }\n           });\n       },\n\n       /**\n        * populate PayPal order ID and trigger Commerce order flow\n        * @param order\n        */\n       onOrderSuccess: function (order) {\n           this.paypalOrderId = order['id'];\n           this.paymentsOrderId = order['mp_order_id'];\n       },\n\n       /**\n        * handle payment error\n        * @param error\n        */\n       onError: function (error) {\n           var message = this.generalErrorMessage;\n\n           if (error instanceof ResponseError) {\n               message = error.message;\n           } else if (error['debug_id']) {\n               message = this.paymentMethodValidationError;\n           }\n\n           this.messageContainer.addErrorMessage({\n               message: message\n           });\n           console.log(error['debug_id'] ? 'Error' + JSON.stringify(error) : error.toString());\n       },\n   });\n});\n","Magento_PaymentServicesPaypal/js/view/payment/actions/get-sdk-params.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Customer/js/customer-data',\n    'jquery/jquery-storageapi'\n], function ($, _, customerData) {\n    'use strict';\n\n    var promise = null,\n        timeoutKey = 'payments-sdk-params-timeout',\n        paymentsKey = 'payments',\n        sdkParamsKey = 'sdkParams';\n\n    return function (cacheTtl) {\n        if (!promise) {\n            promise = new Promise(function (resolve, reject) {\n                var dateNow = Date.now(),\n                    dateTo = dateNow + cacheTtl,\n                    timeout = $.localStorage.get(timeoutKey);\n                if (timeout < dateNow || !timeout) {\n                    return customerData.reload([paymentsKey]).done(function () {\n                        $.localStorage.set(timeoutKey, dateTo);\n                        resolve(customerData.get(paymentsKey)()[sdkParamsKey]);\n                    }).fail(reject.bind(this, []));\n                }\n\n                if (!_.isEmpty(customerData.get(paymentsKey)())) {\n                    return resolve(customerData.get(paymentsKey)()[sdkParamsKey]);\n                }\n\n                customerData.get(paymentsKey).subscribe(function (payments) {\n                    resolve(payments[sdkParamsKey]);\n                });\n\n            });\n        }\n\n        return promise;\n    };\n});\n","Magento_PaymentServicesPaypal/js/view/product/gift-card-product-data-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_PaymentServicesPaypal/js/view/product/product-data-provider'\n], function ($, _, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            priceBoxContextSelector: '.giftcard-amount',\n            priceBoxSelector: '#giftcard-amount, #giftcard-amount-input'\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.price = $(this.priceBoxSelector, this.priceBoxContextSelector).val();\n\n            return this;\n        },\n\n        /**\n         * Subscribe for price change.\n         */\n        priceSubscribe: function () {\n            $(this.priceBoxSelector, this.priceBoxContextSelector).on('change', function (event) {\n                this.price = event.target.value;\n                this.updateAmount(this.getAmount());\n            }.bind(this));\n        },\n\n        /**\n         * Checks if product is grouped type.\n         *\n         * @return {Boolean}\n         */\n        isProductGiftCard: function () {\n            return !!$(this.constructor.defaults.priceBoxContextSelector).length;\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/product/grouped-product-data-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery', 'underscore', 'uiClass'], function ($, _, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            tableWrapperSelector: '.table-wrapper.grouped',\n            qtyFieldSelector: '.input-text.qty',\n            priceBoxSelector: '[data-role=\"priceBox\"]',\n            priceInfo: {}\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            $('tbody tr', this.tableWrapperSelector).each(function (index, element) {\n                var priceBox = $(this.priceBoxSelector, element),\n                    qtyElement = $(this.qtyFieldSelector, element),\n                    productId = priceBox.data('productId'),\n                    priceElement = $('#product-price-' + productId);\n\n                this.priceInfo[productId] = {\n                    qty: this.getQuantity(qtyElement),\n                    price: priceElement.data('priceAmount')\n                };\n            }.bind(this));\n            this.quantitySubscribe();\n\n            return this;\n        },\n\n        /**\n         * Subscribe for quantity changes.\n         */\n        quantitySubscribe: function () {\n            $(this.qtyFieldSelector).on('change', function (event) {\n                var qtyElement = $(event.target),\n                    parent = qtyElement.parents('tr'),\n                    priceBox = $(this.priceBoxSelector, parent),\n                    productId = priceBox.data('productId');\n\n                if (this.priceInfo[productId]) {\n                    this.priceInfo[productId].qty = this.getQuantity(qtyElement);\n                }\n\n                this.updateAmount(this.getAmount());\n            }.bind(this));\n        },\n\n        /**\n         * Get product amount.\n         *\n         * @return {Number}\n         */\n        getAmount: function () {\n            var amount = 0;\n\n            _.each(this.priceInfo, function (info) {\n                amount += info.price * info.qty;\n            });\n\n            return amount;\n        },\n\n        /**\n         * Get product quantity.\n         *\n         * @param {HTMLElement} element\n         * @return {Number}\n         */\n        getQuantity: function (element) {\n            var qty = parseFloat(element.val());\n\n            return !isNaN(qty) && qty ? qty : 0;\n        },\n\n        /**\n         * Checks if product is grouped type.\n         *\n         * @return {Boolean}\n         */\n        isProductGrouped: function () {\n            return !!$(this.constructor.defaults.tableWrapperSelector).length;\n        },\n\n        /**\n         * Subscribe for price change.\n         */\n        priceSubscribe: function () {\n        },\n\n        /**\n         * Trigger price update.\n         */\n        updatePrice: function () {\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/product/bundle-product-data-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_PaymentServicesPaypal/js/view/product/product-data-provider'\n], function ($, _, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            priceBoxContextSelector: '#bundleSummary',\n            slideSelector: '#bundle-slide'\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            // Need to track bundle product slide to trigger amount update to make message visible.\n            $(this.slideSelector).on('click', function () {\n                setTimeout(function () {\n                    this.updateAmount(this.getAmount());\n                }.bind(this), 300);\n            }.bind(this));\n            this.updateAmount(this.getAmount());\n\n            return this;\n        },\n\n        /**\n         * Checks if product is grouped type.\n         *\n         * @return {Boolean}\n         */\n        isBundleProduct: function () {\n            return !!$(this.constructor.defaults.priceBoxContextSelector).length;\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/product/product-data-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery', 'uiClass', 'priceBox'], function ($, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            qtyFieldSelector: '#qty',\n            priceBoxSelector: '.price-box',\n            priceBoxContextSelector: '.product-info-main',\n            finalPriceSelector: '[data-price-type=\"finalPrice\"]',\n            price: 0,\n            qty: 0\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.price = $(this.finalPriceSelector, this.priceBoxContextSelector).attr('data-price-amount');\n            this.qty = $(this.qtyFieldSelector).val();\n            this.quantitySubscribe();\n            this.priceSubscribe();\n\n            return this;\n        },\n\n        /**\n         * Subscribe for quantity changes.\n         */\n        quantitySubscribe: function () {\n            $(this.qtyFieldSelector).on('change', function () {\n                this.qty = $(this.qtyFieldSelector).val();\n                this.updateAmount(this.getAmount());\n            }.bind(this));\n        },\n\n        /**\n         * Subscribe for price change.\n         */\n        priceSubscribe: function () {\n            $(this.priceBoxSelector, this.priceBoxContextSelector).on('updatePrice', function (event) {\n                var prices = $(event.target).data('magePriceBox').cache.displayPrices;\n\n                this.price = prices.finalPrice.amount;\n                this.updateAmount(this.getAmount());\n            }.bind(this));\n        },\n\n        /**\n         * Trigger price update.\n         */\n        updatePrice: function () {\n            $(this.priceBoxSelector).trigger('updatePrice');\n        },\n\n        /**\n         * Get product amount.\n         *\n         * @return {Number}\n         */\n        getAmount: function () {\n            return this.qty * this.price;\n        }\n    });\n});\n","Magento_PaymentServicesPaypal/js/view/errors/response-error.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Error type to handle response errors.\n     *\n     * @param {String} message\n     * @constructor\n     */\n    function ResponseError(message) {\n        this.name = 'ResponseError';\n        this.message = message;\n        this.stack = new Error().stack;\n    }\n\n    ResponseError.prototype = new Error;\n\n    /**\n     * Return a string representation\n     *\n     * @returns {String}\n     */\n    ResponseError.prototype.toString = function () {\n        return this.message;\n    };\n\n    return ResponseError;\n});\n","Magento_PaymentServicesPaypal/js/lib/script-loader.min.js":"/*!\n * paypal-js v3.1.1 (2021-03-14T21:08:07.006Z)\n * Copyright 2020-present, PayPal, Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\nvar paypalLoadScript=function(t){\"use strict\";function e(t,e){var r=document.querySelector('script[src=\"'.concat(t,'\"]'));if(null===r)return null;var n=a(t,e);if(Object.keys(r.dataset).length!==Object.keys(n.dataset).length)return null;var o=!0;return Object.keys(r.dataset).forEach((function(t){r.dataset[t]!==n.dataset[t]&&(o=!1)})),o?r:null}function r(t){var e=t.url,r=t.attributes,n=t.onSuccess,o=t.onError,i=a(e,r);i.onerror=o,i.onload=n,document.head.insertBefore(i,document.head.firstElementChild)}function n(t){var e=\"https://www.paypal.com/sdk/js\";t.sdkBaseURL&&(e=t.sdkBaseURL,delete t.sdkBaseURL);var r=function(t,e){var r=\"\",n=\"\";Array.isArray(t)?t.length>1?(r=\"*\",n=t.toString()):r=t.toString():\"string\"==typeof t&&t.length>0?r=t:\"string\"==typeof e&&e.length>0&&(r=\"*\",n=e);return{\"merchant-id\":r,\"data-merchant-id\":n}}(t[\"merchant-id\"],t[\"data-merchant-id\"]),n=Object.assign(t,r),a=Object.keys(n).filter((function(t){return void 0!==n[t]&&null!==n[t]&&\"\"!==n[t]})).reduce((function(t,e){var r=n[e].toString();return\"data-\"===e.substring(0,5)?t.dataAttributes[e]=r:t.queryParams[e]=r,t}),{queryParams:{},dataAttributes:{}}),i=a.queryParams,u=a.dataAttributes;return{url:\"\".concat(e,\"?\").concat(o(i)),dataAttributes:u}}function o(t){var e=\"\";return Object.keys(t).forEach((function(r){0!==e.length&&(e+=\"&\"),e+=r+\"=\"+t[r]})),e}function a(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=document.createElement(\"script\");return r.src=t,Object.keys(e).forEach((function(t){r.setAttribute(t,e[t]),\"data-csp-nonce\"===t&&r.setAttribute(\"nonce\",e[\"data-csp-nonce\"])})),r}function i(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:u();s(t,e);var n=t.url,o=t.attributes;if(\"string\"!=typeof n||0===n.length)throw new Error(\"Invalid url.\");if(void 0!==o&&\"object\"!=typeof o)throw new Error(\"Expected attributes to be an object.\");return new e((function(t,e){if(\"undefined\"==typeof window)return t();r({url:n,attributes:o,onSuccess:function(){return t()},onError:function(){return e(new Error('The script \"'.concat(n,'\" failed to load.')))}})}))}function u(){if(\"undefined\"==typeof Promise)throw new Error(\"Promise is undefined. To resolve the issue, use a Promise polyfill.\");return Promise}function c(t){return window[t]}function s(t,e){if(\"object\"!=typeof t||null===t)throw new Error(\"Expected an options object.\");if(void 0!==e&&\"function\"!=typeof e)throw new Error(\"Expected PromisePonyfill to be a function.\")}return t.loadCustomScript=i,t.loadScript=function(t){var r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:u();if(s(t,r),\"undefined\"==typeof window)return r.resolve(null);var o=n(t),a=o.url,d=o.dataAttributes,l=d[\"data-namespace\"]||\"paypal\",f=c(l);return e(a,d)&&f?r.resolve(f):i({url:a,attributes:d},r).then((function(){var t=c(l);if(t)return t;throw new Error(\"The window.\".concat(l,\" global variable is not available.\"))}))},t.version=\"3.1.1\",Object.defineProperty(t,\"__esModule\",{value:!0}),t}({});window.paypalLoadCustomScript=paypalLoadScript.loadCustomScript,window.paypalLoadScript=paypalLoadScript.loadScript;\n","Magento_PaymentServicesPaypal/js/lib/script-loader-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\ndefine(['underscore', 'Magento_PaymentServicesPaypal/js/lib/script-loader'], function (_, scriptLoader) {\n    'use strict';\n\n    var promises = {},\n        defaultNamespace = 'paypal';\n\n    /**\n     * Parse src query string and move all params to object\n     *\n     * @param {Object} params\n     * @return {Object}\n     */\n    function processParamsSrc(params) {\n        var processedParams = _.clone(params),\n            url = new URL(params.src),\n            queryString = url.search.substring(1),\n            urlParams = JSON.parse('{\"' +\n                decodeURI(queryString).replace(/\"/g, '\\\\\"').replace(/&/g, '\",\"').replace(/=/g, '\":\"') +\n                '\"}');\n\n        _.extend(processedParams, urlParams);\n        delete processedParams.src;\n\n        return processedParams;\n    }\n\n    /**\n     * Convert params to object key => value format\n     *\n     * @param {Object} params\n     * @return {Object}\n     */\n    function convertToParamsObject(params) {\n        var processedParams = {};\n\n        _.each(params, function (param) {\n            processedParams[param.name] = param.value;\n        });\n\n        return processedParams;\n    }\n\n    /**\n     * Load PayPal sdk with params.\n     *\n     * @param {Array} params\n     * @param {String} sdkNamespace\n     * @return {Promise}\n     */\n    return function (params, sdkNamespace) {\n        var src;\n\n        if (!params || !params.length) {\n            return Promise.reject();\n        }\n\n        params = convertToParamsObject(params);\n        params['data-namespace'] = sdkNamespace || defaultNamespace;\n\n        if (!params || !params.src) {\n            return Promise.reject();\n        }\n\n        src = params.src;\n\n        if (!promises[src]) {\n            params = processParamsSrc(params);\n\n            promises[src] = scriptLoader.load(params);\n        }\n\n        return promises[src];\n    };\n});\n","Magento_Shipping/js/model/config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return function () {\n        return window.checkoutConfig.shippingPolicy;\n    };\n});\n","Magento_Shipping/js/view/checkout/shipping/shipping-policy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Shipping/js/model/config'\n\n], function (Component, config) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Shipping/checkout/shipping/shipping-policy'\n        },\n        config: config()\n    });\n});\n","knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.5.1\n * (c) The Knockout.js team - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\n    var DEBUG=true;\n    (function(undefined){\n        // (0, eval)('this') is a robust way of getting a reference to the global object\n        // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n        var window = this || (0, eval)('this'),\n            document = window['document'],\n            navigator = window['navigator'],\n            jQueryInstance = window[\"jQuery\"],\n            JSON = window[\"JSON\"];\n\n        if (!jQueryInstance && typeof jQuery !== \"undefined\") {\n            jQueryInstance = jQuery;\n        }\n        (function(factory) {\n            // Support three module loading scenarios\n            if (typeof define === 'function' && define['amd']) {\n                // [1] AMD anonymous module\n                define(['exports', 'require'], factory);\n            } else if (typeof exports === 'object' && typeof module === 'object') {\n                // [2] CommonJS/Node.js\n                factory(module['exports'] || exports);  // module.exports is for Node.js\n            } else {\n                // [3] No module loader (plain <script> tag) - put directly in global namespace\n                factory(window['ko'] = {});\n            }\n        }(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\n            var ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\n            ko.exportSymbol = function(koPath, object) {\n                var tokens = koPath.split(\".\");\n\n                // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n                // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n                var target = ko;\n\n                for (var i = 0; i < tokens.length - 1; i++)\n                    target = target[tokens[i]];\n                target[tokens[tokens.length - 1]] = object;\n            };\n            ko.exportProperty = function(owner, publicName, object) {\n                owner[publicName] = object;\n            };\n            ko.version = \"3.5.1\";\n\n            ko.exportSymbol('version', ko.version);\n// For any options that may affect various areas of Knockout and aren't directly associated with data binding.\n            ko.options = {\n                'deferUpdates': false,\n                'useOnlyNativeEvents': false,\n                'foreachHidesDestroyed': false\n            };\n\n//ko.exportSymbol('options', ko.options);   // 'options' isn't minified\n            ko.utils = (function () {\n                var hasOwnProperty = Object.prototype.hasOwnProperty;\n\n                function objectForEach(obj, action) {\n                    for (var prop in obj) {\n                        if (hasOwnProperty.call(obj, prop)) {\n                            action(prop, obj[prop]);\n                        }\n                    }\n                }\n\n                function extend(target, source) {\n                    if (source) {\n                        for(var prop in source) {\n                            if(hasOwnProperty.call(source, prop)) {\n                                target[prop] = source[prop];\n                            }\n                        }\n                    }\n                    return target;\n                }\n\n                function setPrototypeOf(obj, proto) {\n                    obj.__proto__ = proto;\n                    return obj;\n                }\n\n                var canSetPrototype = ({ __proto__: [] } instanceof Array);\n                var canUseSymbols = !DEBUG && typeof Symbol === 'function';\n\n                // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n                var knownEvents = {}, knownEventTypesByEventName = {};\n                var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n                knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n                knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n                objectForEach(knownEvents, function(eventType, knownEventsForType) {\n                    if (knownEventsForType.length) {\n                        for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                            knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n                    }\n                });\n                var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n                // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n                // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n                // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n                // If there is a future need to detect specific versions of IE10+, we will amend this.\n                var ieVersion = document && (function() {\n                    var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n                    // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n                    while (\n                        div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n                            iElems[0]\n                        ) {}\n                    return version > 4 ? version : undefined;\n                }());\n                var isIe6 = ieVersion === 6,\n                    isIe7 = ieVersion === 7;\n\n                function isClickOnCheckableElement(element, eventType) {\n                    if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n                    if (eventType.toLowerCase() != \"click\") return false;\n                    var inputType = element.type;\n                    return (inputType == \"checkbox\") || (inputType == \"radio\");\n                }\n\n                // For details on the pattern for changing node classes\n                // see: https://github.com/knockout/knockout/issues/1597\n                var cssClassNameRegex = /\\S+/g;\n\n                var jQueryEventAttachName;\n\n                function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n                    var addOrRemoveFn;\n                    if (classNames) {\n                        if (typeof node.classList === 'object') {\n                            addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                            ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                                addOrRemoveFn.call(node.classList, className);\n                            });\n                        } else if (typeof node.className['baseVal'] === 'string') {\n                            // SVG tag .classNames is an SVGAnimatedString instance\n                            toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n                        } else {\n                            // node.className ought to be a string.\n                            toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n                        }\n                    }\n                }\n\n                function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n                    // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n                    var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n                    ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                        ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n                    });\n                    obj[prop] = currentClassNames.join(\" \");\n                }\n\n                return {\n                    fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n                    arrayForEach: function (array, action, actionOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            action.call(actionOwner, array[i], i, array);\n                        }\n                    },\n\n                    arrayIndexOf: typeof Array.prototype.indexOf == \"function\"\n                        ? function (array, item) {\n                            return Array.prototype.indexOf.call(array, item);\n                        }\n                        : function (array, item) {\n                            for (var i = 0, j = array.length; i < j; i++) {\n                                if (array[i] === item)\n                                    return i;\n                            }\n                            return -1;\n                        },\n\n                    arrayFirst: function (array, predicate, predicateOwner) {\n                        for (var i = 0, j = array.length; i < j; i++) {\n                            if (predicate.call(predicateOwner, array[i], i, array))\n                                return array[i];\n                        }\n                        return undefined;\n                    },\n\n                    arrayRemoveItem: function (array, itemToRemove) {\n                        var index = ko.utils.arrayIndexOf(array, itemToRemove);\n                        if (index > 0) {\n                            array.splice(index, 1);\n                        }\n                        else if (index === 0) {\n                            array.shift();\n                        }\n                    },\n\n                    arrayGetDistinctValues: function (array) {\n                        var result = [];\n                        if (array) {\n                            ko.utils.arrayForEach(array, function(item) {\n                                if (ko.utils.arrayIndexOf(result, item) < 0)\n                                    result.push(item);\n                            });\n                        }\n                        return result;\n                    },\n\n                    arrayMap: function (array, mapping, mappingOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                result.push(mapping.call(mappingOwner, array[i], i));\n                        }\n                        return result;\n                    },\n\n                    arrayFilter: function (array, predicate, predicateOwner) {\n                        var result = [];\n                        if (array) {\n                            for (var i = 0, j = array.length; i < j; i++)\n                                if (predicate.call(predicateOwner, array[i], i))\n                                    result.push(array[i]);\n                        }\n                        return result;\n                    },\n\n                    arrayPushAll: function (array, valuesToPush) {\n                        if (valuesToPush instanceof Array)\n                            array.push.apply(array, valuesToPush);\n                        else\n                            for (var i = 0, j = valuesToPush.length; i < j; i++)\n                                array.push(valuesToPush[i]);\n                        return array;\n                    },\n\n                    addOrRemoveItem: function(array, value, included) {\n                        var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n                        if (existingEntryIndex < 0) {\n                            if (included)\n                                array.push(value);\n                        } else {\n                            if (!included)\n                                array.splice(existingEntryIndex, 1);\n                        }\n                    },\n\n                    canSetPrototype: canSetPrototype,\n\n                    extend: extend,\n\n                    setPrototypeOf: setPrototypeOf,\n\n                    setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n                    objectForEach: objectForEach,\n\n                    objectMap: function(source, mapping, mappingOwner) {\n                        if (!source)\n                            return source;\n                        var target = {};\n                        for (var prop in source) {\n                            if (hasOwnProperty.call(source, prop)) {\n                                target[prop] = mapping.call(mappingOwner, source[prop], prop, source);\n                            }\n                        }\n                        return target;\n                    },\n\n                    emptyDomNode: function (domNode) {\n                        while (domNode.firstChild) {\n                            ko.removeNode(domNode.firstChild);\n                        }\n                    },\n\n                    moveCleanedNodesToContainerElement: function(nodes) {\n                        // Ensure it's a real array, as we're about to reparent the nodes and\n                        // we don't want the underlying collection to change while we're doing that.\n                        var nodesArray = ko.utils.makeArray(nodes);\n                        var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n                        var container = templateDocument.createElement('div');\n                        for (var i = 0, j = nodesArray.length; i < j; i++) {\n                            container.appendChild(ko.cleanNode(nodesArray[i]));\n                        }\n                        return container;\n                    },\n\n                    cloneNodes: function (nodesArray, shouldCleanNodes) {\n                        for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                            var clonedNode = nodesArray[i].cloneNode(true);\n                            newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n                        }\n                        return newNodesArray;\n                    },\n\n                    setDomNodeChildren: function (domNode, childNodes) {\n                        ko.utils.emptyDomNode(domNode);\n                        if (childNodes) {\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                domNode.appendChild(childNodes[i]);\n                        }\n                    },\n\n                    replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n                        var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n                        if (nodesToReplaceArray.length > 0) {\n                            var insertionPoint = nodesToReplaceArray[0];\n                            var parent = insertionPoint.parentNode;\n                            for (var i = 0, j = newNodesArray.length; i < j; i++)\n                                parent.insertBefore(newNodesArray[i], insertionPoint);\n                            for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                                ko.removeNode(nodesToReplaceArray[i]);\n                            }\n                        }\n                    },\n\n                    fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n                        // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n                        // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n                        // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n                        // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n                        // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n                        //\n                        // Rules:\n                        //   [A] Any leading nodes that have been removed should be ignored\n                        //       These most likely correspond to memoization nodes that were already removed during binding\n                        //       See https://github.com/knockout/knockout/pull/440\n                        //   [B] Any trailing nodes that have been remove should be ignored\n                        //       This prevents the code here from adding unrelated nodes to the array while processing rule [C]\n                        //       See https://github.com/knockout/knockout/pull/1903\n                        //   [C] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n                        //       and include any nodes that have been inserted among the previous collection\n\n                        if (continuousNodeArray.length) {\n                            // The parent node can be a virtual element; so get the real parent node\n                            parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                            // Rule [A]\n                            while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                                continuousNodeArray.splice(0, 1);\n\n                            // Rule [B]\n                            while (continuousNodeArray.length > 1 && continuousNodeArray[continuousNodeArray.length - 1].parentNode !== parentNode)\n                                continuousNodeArray.length--;\n\n                            // Rule [C]\n                            if (continuousNodeArray.length > 1) {\n                                var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                                // Replace with the actual new continuous node set\n                                continuousNodeArray.length = 0;\n                                while (current !== last) {\n                                    continuousNodeArray.push(current);\n                                    current = current.nextSibling;\n                                }\n                                continuousNodeArray.push(last);\n                            }\n                        }\n                        return continuousNodeArray;\n                    },\n\n                    setOptionNodeSelectionState: function (optionNode, isSelected) {\n                        // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n                        if (ieVersion < 7)\n                            optionNode.setAttribute(\"selected\", isSelected);\n                        else\n                            optionNode.selected = isSelected;\n                    },\n\n                    stringTrim: function (string) {\n                        return string === null || string === undefined ? '' :\n                            string.trim ?\n                                string.trim() :\n                                string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n                    },\n\n                    stringStartsWith: function (string, startsWith) {\n                        string = string || \"\";\n                        if (startsWith.length > string.length)\n                            return false;\n                        return string.substring(0, startsWith.length) === startsWith;\n                    },\n\n                    domNodeIsContainedBy: function (node, containedByNode) {\n                        if (node === containedByNode)\n                            return true;\n                        if (node.nodeType === 11)\n                            return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n                        if (containedByNode.contains)\n                            return containedByNode.contains(node.nodeType !== 1 ? node.parentNode : node);\n                        if (containedByNode.compareDocumentPosition)\n                            return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n                        while (node && node != containedByNode) {\n                            node = node.parentNode;\n                        }\n                        return !!node;\n                    },\n\n                    domNodeIsAttachedToDocument: function (node) {\n                        return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n                    },\n\n                    anyDomNodeIsAttachedToDocument: function(nodes) {\n                        return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n                    },\n\n                    tagNameLower: function(element) {\n                        // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n                        // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n                        // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n                        return element && element.tagName && element.tagName.toLowerCase();\n                    },\n\n                    catchFunctionErrors: function (delegate) {\n                        return ko['onError'] ? function () {\n                            try {\n                                return delegate.apply(this, arguments);\n                            } catch (e) {\n                                ko['onError'] && ko['onError'](e);\n                                throw e;\n                            }\n                        } : delegate;\n                    },\n\n                    setTimeout: function (handler, timeout) {\n                        return setTimeout(ko.utils.catchFunctionErrors(handler), timeout);\n                    },\n\n                    deferError: function (error) {\n                        setTimeout(function () {\n                            ko['onError'] && ko['onError'](error);\n                            throw error;\n                        }, 0);\n                    },\n\n                    registerEventHandler: function (element, eventType, handler) {\n                        var wrappedHandler = ko.utils.catchFunctionErrors(handler);\n\n                        var mustUseAttachEvent = eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n                        if (!ko.options['useOnlyNativeEvents'] && !mustUseAttachEvent && jQueryInstance) {\n                            if (!jQueryEventAttachName) {\n                                jQueryEventAttachName = (typeof jQueryInstance(element)['on'] == 'function') ? 'on' : 'bind';\n                            }\n                            jQueryInstance(element)[jQueryEventAttachName](eventType, wrappedHandler);\n                        } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                            element.addEventListener(eventType, wrappedHandler, false);\n                        else if (typeof element.attachEvent != \"undefined\") {\n                            var attachEventHandler = function (event) { wrappedHandler.call(element, event); },\n                                attachEventName = \"on\" + eventType;\n                            element.attachEvent(attachEventName, attachEventHandler);\n\n                            // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                            // so to avoid leaks, we have to remove them manually. See bug #856\n                            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                                element.detachEvent(attachEventName, attachEventHandler);\n                            });\n                        } else\n                            throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n                    },\n\n                    triggerEvent: function (element, eventType) {\n                        if (!(element && element.nodeType))\n                            throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n                        // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n                        // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n                        // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n                        // In both cases, we'll use the click method instead.\n                        var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n                        if (!ko.options['useOnlyNativeEvents'] && jQueryInstance && !useClickWorkaround) {\n                            jQueryInstance(element)['trigger'](eventType);\n                        } else if (typeof document.createEvent == \"function\") {\n                            if (typeof element.dispatchEvent == \"function\") {\n                                var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                                var event = document.createEvent(eventCategory);\n                                event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                                element.dispatchEvent(event);\n                            }\n                            else\n                                throw new Error(\"The supplied element doesn't support dispatchEvent\");\n                        } else if (useClickWorkaround && element.click) {\n                            element.click();\n                        } else if (typeof element.fireEvent != \"undefined\") {\n                            element.fireEvent(\"on\" + eventType);\n                        } else {\n                            throw new Error(\"Browser doesn't support triggering events\");\n                        }\n                    },\n\n                    unwrapObservable: function (value) {\n                        return ko.isObservable(value) ? value() : value;\n                    },\n\n                    peekObservable: function (value) {\n                        return ko.isObservable(value) ? value.peek() : value;\n                    },\n\n                    toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n                    setTextContent: function(element, textContent) {\n                        var value = ko.utils.unwrapObservable(textContent);\n                        if ((value === null) || (value === undefined))\n                            value = \"\";\n\n                        // We need there to be exactly one child: a text node.\n                        // If there are no children, more than one, or if it's not a text node,\n                        // we'll clear everything and create a single text node.\n                        var innerTextNode = ko.virtualElements.firstChild(element);\n                        if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                            ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n                        } else {\n                            innerTextNode.data = value;\n                        }\n\n                        ko.utils.forceRefresh(element);\n                    },\n\n                    setElementName: function(element, name) {\n                        element.name = name;\n\n                        // Workaround IE 6/7 issue\n                        // - https://github.com/SteveSanderson/knockout/issues/197\n                        // - http://www.matts411.com/post/setting_the_name_attribute_in_ie_dom/\n                        if (ieVersion <= 7) {\n                            try {\n                                var escapedName = element.name.replace(/[&<>'\"]/g, function(r){ return \"&#\" + r.charCodeAt(0) + \";\"; });\n                                element.mergeAttributes(document.createElement(\"<input name='\" + escapedName + \"'/>\"), false);\n                            }\n                            catch(e) {} // For IE9 with doc mode \"IE9 Standards\" and browser mode \"IE9 Compatibility View\"\n                        }\n                    },\n\n                    forceRefresh: function(node) {\n                        // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n                        if (ieVersion >= 9) {\n                            // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                            var elem = node.nodeType == 1 ? node : node.parentNode;\n                            if (elem.style)\n                                elem.style.zoom = elem.style.zoom;\n                        }\n                    },\n\n                    ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n                        // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n                        // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n                        // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n                        if (ieVersion) {\n                            var originalWidth = selectElement.style.width;\n                            selectElement.style.width = 0;\n                            selectElement.style.width = originalWidth;\n                        }\n                    },\n\n                    range: function (min, max) {\n                        min = ko.utils.unwrapObservable(min);\n                        max = ko.utils.unwrapObservable(max);\n                        var result = [];\n                        for (var i = min; i <= max; i++)\n                            result.push(i);\n                        return result;\n                    },\n\n                    makeArray: function(arrayLikeObject) {\n                        var result = [];\n                        for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                            result.push(arrayLikeObject[i]);\n                        };\n                        return result;\n                    },\n\n                    createSymbolOrString: function(identifier) {\n                        return canUseSymbols ? Symbol(identifier) : identifier;\n                    },\n\n                    isIe6 : isIe6,\n                    isIe7 : isIe7,\n                    ieVersion : ieVersion,\n\n                    getFormFields: function(form, fieldName) {\n                        var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n                        var isMatchingField = (typeof fieldName == 'string')\n                            ? function(field) { return field.name === fieldName }\n                            : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n                        var matches = [];\n                        for (var i = fields.length - 1; i >= 0; i--) {\n                            if (isMatchingField(fields[i]))\n                                matches.push(fields[i]);\n                        };\n                        return matches;\n                    },\n\n                    parseJson: function (jsonString) {\n                        if (typeof jsonString == \"string\") {\n                            jsonString = ko.utils.stringTrim(jsonString);\n                            if (jsonString) {\n                                if (JSON && JSON.parse) // Use native parsing where available\n                                    return JSON.parse(jsonString);\n                                return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                            }\n                        }\n                        return null;\n                    },\n\n                    stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n                        if (!JSON || !JSON.stringify)\n                            throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n                        return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n                    },\n\n                    postJson: function (urlOrForm, data, options) {\n                        options = options || {};\n                        var params = options['params'] || {};\n                        var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n                        var url = urlOrForm;\n\n                        // If we were given a form, use its 'action' URL and pick out any requested field values\n                        if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                            var originalForm = urlOrForm;\n                            url = originalForm.action;\n                            for (var i = includeFields.length - 1; i >= 0; i--) {\n                                var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                                for (var j = fields.length - 1; j >= 0; j--)\n                                    params[fields[j].name] = fields[j].value;\n                            }\n                        }\n\n                        data = ko.utils.unwrapObservable(data);\n                        var form = document.createElement(\"form\");\n                        form.style.display = \"none\";\n                        form.action = url;\n                        form.method = \"post\";\n                        for (var key in data) {\n                            // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                            form.appendChild(input);\n                        }\n                        objectForEach(params, function(key, value) {\n                            var input = document.createElement(\"input\");\n                            input.type = \"hidden\";\n                            input.name = key;\n                            input.value = value;\n                            form.appendChild(input);\n                        });\n                        document.body.appendChild(form);\n                        options['submitter'] ? options['submitter'](form) : form.submit();\n                        setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n                    }\n                }\n            }());\n\n            ko.exportSymbol('utils', ko.utils);\n            ko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\n            ko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\n            ko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\n            ko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\n            ko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\n            ko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\n            ko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\n            ko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\n            ko.exportSymbol('utils.cloneNodes', ko.utils.cloneNodes);\n            ko.exportSymbol('utils.createSymbolOrString', ko.utils.createSymbolOrString);\n            ko.exportSymbol('utils.extend', ko.utils.extend);\n            ko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\n            ko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\n            ko.exportSymbol('utils.objectMap', ko.utils.objectMap);\n            ko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\n            ko.exportSymbol('utils.postJson', ko.utils.postJson);\n            ko.exportSymbol('utils.parseJson', ko.utils.parseJson);\n            ko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\n            ko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\n            ko.exportSymbol('utils.range', ko.utils.range);\n            ko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\n            ko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\n            ko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\n            ko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\n            ko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\n            ko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\n            ko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\n            if (!Function.prototype['bind']) {\n                // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n                // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n                Function.prototype['bind'] = function (object) {\n                    var originalFunction = this;\n                    if (arguments.length === 1) {\n                        return function () {\n                            return originalFunction.apply(object, arguments);\n                        };\n                    } else {\n                        var partialArgs = Array.prototype.slice.call(arguments, 1);\n                        return function () {\n                            var args = partialArgs.slice(0);\n                            args.push.apply(args, arguments);\n                            return originalFunction.apply(object, args);\n                        };\n                    }\n                };\n            }\n\n            ko.utils.domData = new (function () {\n                var uniqueId = 0;\n                var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n                var dataStore = {};\n\n                var getDataForNode, clear;\n                if (!ko.utils.ieVersion) {\n                    // We considered using WeakMap, but it has a problem in IE 11 and Edge that prevents using\n                    // it cross-window, so instead we just store the data directly on the node.\n                    // See https://github.com/knockout/knockout/issues/2141\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataForNode = node[dataStoreKeyExpandoPropertyName];\n                        if (!dataForNode && createIfNotFound) {\n                            dataForNode = node[dataStoreKeyExpandoPropertyName] = {};\n                        }\n                        return dataForNode;\n                    };\n                    clear = function (node) {\n                        if (node[dataStoreKeyExpandoPropertyName]) {\n                            delete node[dataStoreKeyExpandoPropertyName];\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                } else {\n                    // Old IE versions have memory issues if you store objects on the node, so we use a\n                    // separate data storage and link to it from the node using a string key.\n                    getDataForNode = function (node, createIfNotFound) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n                        if (!hasExistingDataStore) {\n                            if (!createIfNotFound)\n                                return undefined;\n                            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n                            dataStore[dataStoreKey] = {};\n                        }\n                        return dataStore[dataStoreKey];\n                    };\n                    clear = function (node) {\n                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n                        if (dataStoreKey) {\n                            delete dataStore[dataStoreKey];\n                            node[dataStoreKeyExpandoPropertyName] = null;\n                            return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n                        }\n                        return false;\n                    };\n                }\n\n                return {\n                    get: function (node, key) {\n                        var dataForNode = getDataForNode(node, false);\n                        return dataForNode && dataForNode[key];\n                    },\n                    set: function (node, key, value) {\n                        // Make sure we don't actually create a new domData key if we are actually deleting a value\n                        var dataForNode = getDataForNode(node, value !== undefined /* createIfNotFound */);\n                        dataForNode && (dataForNode[key] = value);\n                    },\n                    getOrSet: function (node, key, value) {\n                        var dataForNode = getDataForNode(node, true /* createIfNotFound */);\n                        return dataForNode[key] || (dataForNode[key] = value);\n                    },\n                    clear: clear,\n\n                    nextKey: function () {\n                        return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.domData', ko.utils.domData);\n            ko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\n            ko.utils.domNodeDisposal = new (function () {\n                var domDataKey = ko.utils.domData.nextKey();\n                var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n                var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n                function getDisposeCallbacksCollection(node, createIfNotFound) {\n                    var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n                    if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n                        allDisposeCallbacks = [];\n                        ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n                    }\n                    return allDisposeCallbacks;\n                }\n                function destroyCallbacksCollection(node) {\n                    ko.utils.domData.set(node, domDataKey, undefined);\n                }\n\n                function cleanSingleNode(node) {\n                    // Run all the dispose callbacks\n                    var callbacks = getDisposeCallbacksCollection(node, false);\n                    if (callbacks) {\n                        callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n                        for (var i = 0; i < callbacks.length; i++)\n                            callbacks[i](node);\n                    }\n\n                    // Erase the DOM data\n                    ko.utils.domData.clear(node);\n\n                    // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n                    ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n                    // Clear any immediate-child comment nodes, as these wouldn't have been found by\n                    // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n                    if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                        cleanNodesInList(node.childNodes, true/*onlyComments*/);\n                    }\n                }\n\n                function cleanNodesInList(nodeList, onlyComments) {\n                    var cleanedNodes = [], lastCleanedNode;\n                    for (var i = 0; i < nodeList.length; i++) {\n                        if (!onlyComments || nodeList[i].nodeType === 8) {\n                            cleanSingleNode(cleanedNodes[cleanedNodes.length] = lastCleanedNode = nodeList[i]);\n                            if (nodeList[i] !== lastCleanedNode) {\n                                while (i-- && ko.utils.arrayIndexOf(cleanedNodes, nodeList[i]) == -1) {}\n                            }\n                        }\n                    }\n                }\n\n                return {\n                    addDisposeCallback : function(node, callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"Callback must be a function\");\n                        getDisposeCallbacksCollection(node, true).push(callback);\n                    },\n\n                    removeDisposeCallback : function(node, callback) {\n                        var callbacksCollection = getDisposeCallbacksCollection(node, false);\n                        if (callbacksCollection) {\n                            ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                            if (callbacksCollection.length == 0)\n                                destroyCallbacksCollection(node);\n                        }\n                    },\n\n                    cleanNode : function(node) {\n                        ko.dependencyDetection.ignore(function () {\n                            // First clean this node, where applicable\n                            if (cleanableNodeTypes[node.nodeType]) {\n                                cleanSingleNode(node);\n\n                                // ... then its descendants, where applicable\n                                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                                    cleanNodesInList(node.getElementsByTagName(\"*\"));\n                                }\n                            }\n                        });\n\n                        return node;\n                    },\n\n                    removeNode : function(node) {\n                        ko.cleanNode(node);\n                        if (node.parentNode)\n                            node.parentNode.removeChild(node);\n                    },\n\n                    \"cleanExternalData\" : function (node) {\n                        // Special support for jQuery here because it's so commonly used.\n                        // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n                        // so notify it to tear down any resources associated with the node & descendants here.\n                        if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                            jQueryInstance['cleanData']([node]);\n                    }\n                };\n            })();\n            ko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\n            ko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\n            ko.exportSymbol('cleanNode', ko.cleanNode);\n            ko.exportSymbol('removeNode', ko.removeNode);\n            ko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\n            ko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\n            ko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n            (function () {\n                var none = [0, \"\", \"\"],\n                    table = [1, \"<table>\", \"</table>\"],\n                    tbody = [2, \"<table><tbody>\", \"</tbody></table>\"],\n                    tr = [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"],\n                    select = [1, \"<select multiple='multiple'>\", \"</select>\"],\n                    lookup = {\n                        'thead': table,\n                        'tbody': table,\n                        'tfoot': table,\n                        'tr': tbody,\n                        'td': tr,\n                        'th': tr,\n                        'option': select,\n                        'optgroup': select\n                    },\n\n                    // This is needed for old IE if you're *not* using either jQuery or innerShiv. Doesn't affect other cases.\n                    mayRequireCreateElementHack = ko.utils.ieVersion <= 8;\n\n                function getWrap(tags) {\n                    var m = tags.match(/^(?:<!--.*?-->\\s*?)*?<([a-z]+)[\\s>]/);\n                    return (m && lookup[m[1]]) || none;\n                }\n\n                function simpleHtmlParse(html, documentContext) {\n                    documentContext || (documentContext = document);\n                    var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n                    // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n                    // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n                    // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n                    // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n                    // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n                    // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n                    // Trim whitespace, otherwise indexOf won't work as expected\n                    var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\"),\n                        wrap = getWrap(tags),\n                        depth = wrap[0];\n\n                    // Go to html and back, then peel off extra wrappers\n                    // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n                    var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n                    if (typeof windowContext['innerShiv'] == \"function\") {\n                        // Note that innerShiv is deprecated in favour of html5shiv. We should consider adding\n                        // support for html5shiv (except if no explicit support is needed, e.g., if html5shiv\n                        // somehow shims the native APIs so it just works anyway)\n                        div.appendChild(windowContext['innerShiv'](markup));\n                    } else {\n                        if (mayRequireCreateElementHack) {\n                            // The document.createElement('my-element') trick to enable custom elements in IE6-8\n                            // only works if we assign innerHTML on an element associated with that document.\n                            documentContext.body.appendChild(div);\n                        }\n\n                        div.innerHTML = markup;\n\n                        if (mayRequireCreateElementHack) {\n                            div.parentNode.removeChild(div);\n                        }\n                    }\n\n                    // Move to the right depth\n                    while (depth--)\n                        div = div.lastChild;\n\n                    return ko.utils.makeArray(div.lastChild.childNodes);\n                }\n\n                function jQueryHtmlParse(html, documentContext) {\n                    // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n                    if (jQueryInstance['parseHTML']) {\n                        return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n                    } else {\n                        // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n                        var elems = jQueryInstance['clean']([html], documentContext);\n\n                        // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n                        // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n                        // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n                        if (elems && elems[0]) {\n                            // Find the top-most parent element that's a direct child of a document fragment\n                            var elem = elems[0];\n                            while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                                elem = elem.parentNode;\n                            // ... then detach it\n                            if (elem.parentNode)\n                                elem.parentNode.removeChild(elem);\n                        }\n\n                        return elems;\n                    }\n                }\n\n                ko.utils.parseHtmlFragment = function(html, documentContext) {\n                    return jQueryInstance ?\n                        jQueryHtmlParse(html, documentContext) :   // As below, benefit from jQuery's optimisations where possible\n                        simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n                };\n\n                ko.utils.parseHtmlForTemplateNodes = function(html, documentContext) {\n                    var nodes = ko.utils.parseHtmlFragment(html, documentContext);\n                    return (nodes.length && nodes[0].parentElement) || ko.utils.moveCleanedNodesToContainerElement(nodes);\n                };\n\n                ko.utils.setHtml = function(node, html) {\n                    ko.utils.emptyDomNode(node);\n\n                    // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n                    html = ko.utils.unwrapObservable(html);\n\n                    if ((html !== null) && (html !== undefined)) {\n                        if (typeof html != 'string')\n                            html = html.toString();\n\n                        // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n                        // for example <tr> elements which are not normally allowed to exist on their own.\n                        // If you've referenced jQuery we'll use that rather than duplicating its code.\n                        if (jQueryInstance) {\n                            jQueryInstance(node)['html'](html);\n                        } else {\n                            // ... otherwise, use KO's own parsing logic.\n                            var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                            for (var i = 0; i < parsedNodes.length; i++)\n                                node.appendChild(parsedNodes[i]);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\n            ko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\n            ko.memoization = (function () {\n                var memos = {};\n\n                function randomMax8HexChars() {\n                    return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n                }\n                function generateRandomId() {\n                    return randomMax8HexChars() + randomMax8HexChars();\n                }\n                function findMemoNodes(rootNode, appendToArray) {\n                    if (!rootNode)\n                        return;\n                    if (rootNode.nodeType == 8) {\n                        var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n                        if (memoId != null)\n                            appendToArray.push({ domNode: rootNode, memoId: memoId });\n                    } else if (rootNode.nodeType == 1) {\n                        for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                            findMemoNodes(childNodes[i], appendToArray);\n                    }\n                }\n\n                return {\n                    memoize: function (callback) {\n                        if (typeof callback != \"function\")\n                            throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n                        var memoId = generateRandomId();\n                        memos[memoId] = callback;\n                        return \"<!--[ko_memo:\" + memoId + \"]-->\";\n                    },\n\n                    unmemoize: function (memoId, callbackParams) {\n                        var callback = memos[memoId];\n                        if (callback === undefined)\n                            throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n                        try {\n                            callback.apply(null, callbackParams || []);\n                            return true;\n                        }\n                        finally { delete memos[memoId]; }\n                    },\n\n                    unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n                        var memos = [];\n                        findMemoNodes(domNode, memos);\n                        for (var i = 0, j = memos.length; i < j; i++) {\n                            var node = memos[i].domNode;\n                            var combinedParams = [node];\n                            if (extraCallbackParamsArray)\n                                ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                            ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                            node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                            if (node.parentNode)\n                                node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n                        }\n                    },\n\n                    parseMemoText: function (memoText) {\n                        var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n                        return match ? match[1] : null;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('memoization', ko.memoization);\n            ko.exportSymbol('memoization.memoize', ko.memoization.memoize);\n            ko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\n            ko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\n            ko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\n            ko.tasks = (function () {\n                var scheduler,\n                    taskQueue = [],\n                    taskQueueLength = 0,\n                    nextHandle = 1,\n                    nextIndexToProcess = 0;\n\n                if (window['MutationObserver']) {\n                    // Chrome 27+, Firefox 14+, IE 11+, Opera 15+, Safari 6.1+\n                    // From https://github.com/petkaantonov/bluebird * Copyright (c) 2014 Petka Antonov * License: MIT\n                    scheduler = (function (callback) {\n                        var div = document.createElement(\"div\");\n                        new MutationObserver(callback).observe(div, {attributes: true});\n                        return function () { div.classList.toggle(\"foo\"); };\n                    })(scheduledProcess);\n                } else if (document && \"onreadystatechange\" in document.createElement(\"script\")) {\n                    // IE 6-10\n                    // From https://github.com/YuzuJS/setImmediate * Copyright (c) 2012 Barnesandnoble.com, llc, Donavon West, and Domenic Denicola * License: MIT\n                    scheduler = function (callback) {\n                        var script = document.createElement(\"script\");\n                        script.onreadystatechange = function () {\n                            script.onreadystatechange = null;\n                            document.documentElement.removeChild(script);\n                            script = null;\n                            callback();\n                        };\n                        document.documentElement.appendChild(script);\n                    };\n                } else {\n                    scheduler = function (callback) {\n                        setTimeout(callback, 0);\n                    };\n                }\n\n                function processTasks() {\n                    if (taskQueueLength) {\n                        // Each mark represents the end of a logical group of tasks and the number of these groups is\n                        // limited to prevent unchecked recursion.\n                        var mark = taskQueueLength, countMarks = 0;\n\n                        // nextIndexToProcess keeps track of where we are in the queue; processTasks can be called recursively without issue\n                        for (var task; nextIndexToProcess < taskQueueLength; ) {\n                            if (task = taskQueue[nextIndexToProcess++]) {\n                                if (nextIndexToProcess > mark) {\n                                    if (++countMarks >= 5000) {\n                                        nextIndexToProcess = taskQueueLength;   // skip all tasks remaining in the queue since any of them could be causing the recursion\n                                        ko.utils.deferError(Error(\"'Too much recursion' after processing \" + countMarks + \" task groups.\"));\n                                        break;\n                                    }\n                                    mark = taskQueueLength;\n                                }\n                                try {\n                                    task();\n                                } catch (ex) {\n                                    ko.utils.deferError(ex);\n                                }\n                            }\n                        }\n                    }\n                }\n\n                function scheduledProcess() {\n                    processTasks();\n\n                    // Reset the queue\n                    nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                }\n\n                function scheduleTaskProcessing() {\n                    ko.tasks['scheduler'](scheduledProcess);\n                }\n\n                var tasks = {\n                    'scheduler': scheduler,     // Allow overriding the scheduler\n\n                    schedule: function (func) {\n                        if (!taskQueueLength) {\n                            scheduleTaskProcessing();\n                        }\n\n                        taskQueue[taskQueueLength++] = func;\n                        return nextHandle++;\n                    },\n\n                    cancel: function (handle) {\n                        var index = handle - (nextHandle - taskQueueLength);\n                        if (index >= nextIndexToProcess && index < taskQueueLength) {\n                            taskQueue[index] = null;\n                        }\n                    },\n\n                    // For testing only: reset the queue and return the previous queue length\n                    'resetForTesting': function () {\n                        var length = taskQueueLength - nextIndexToProcess;\n                        nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n                        return length;\n                    },\n\n                    runEarly: processTasks\n                };\n\n                return tasks;\n            })();\n\n            ko.exportSymbol('tasks', ko.tasks);\n            ko.exportSymbol('tasks.schedule', ko.tasks.schedule);\n//ko.exportSymbol('tasks.cancel', ko.tasks.cancel);  \"cancel\" isn't minified\n            ko.exportSymbol('tasks.runEarly', ko.tasks.runEarly);\n            ko.extenders = {\n                'throttle': function(target, timeout) {\n                    // Throttling means two things:\n\n                    // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n                    //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n                    target['throttleEvaluation'] = timeout;\n\n                    // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n                    //     so the target cannot change value synchronously or faster than a certain rate\n                    var writeTimeoutInstance = null;\n                    return ko.dependentObservable({\n                        'read': target,\n                        'write': function(value) {\n                            clearTimeout(writeTimeoutInstance);\n                            writeTimeoutInstance = ko.utils.setTimeout(function() {\n                                target(value);\n                            }, timeout);\n                        }\n                    });\n                },\n\n                'rateLimit': function(target, options) {\n                    var timeout, method, limitFunction;\n\n                    if (typeof options == 'number') {\n                        timeout = options;\n                    } else {\n                        timeout = options['timeout'];\n                        method = options['method'];\n                    }\n\n                    // rateLimit supersedes deferred updates\n                    target._deferUpdates = false;\n\n                    limitFunction = typeof method == 'function' ? method : method == 'notifyWhenChangesStop' ?  debounce : throttle;\n                    target.limit(function(callback) {\n                        return limitFunction(callback, timeout, options);\n                    });\n                },\n\n                'deferred': function(target, options) {\n                    if (options !== true) {\n                        throw new Error('The \\'deferred\\' extender only accepts the value \\'true\\', because it is not supported to turn deferral off once enabled.')\n                    }\n\n                    if (!target._deferUpdates) {\n                        target._deferUpdates = true;\n                        target.limit(function (callback) {\n                            var handle,\n                                ignoreUpdates = false;\n                            return function () {\n                                if (!ignoreUpdates) {\n                                    ko.tasks.cancel(handle);\n                                    handle = ko.tasks.schedule(callback);\n\n                                    try {\n                                        ignoreUpdates = true;\n                                        target['notifySubscribers'](undefined, 'dirty');\n                                    } finally {\n                                        ignoreUpdates = false;\n                                    }\n                                }\n                            };\n                        });\n                    }\n                },\n\n                'notify': function(target, notifyWhen) {\n                    target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n                        null :  // null equalityComparer means to always notify\n                        valuesArePrimitiveAndEqual;\n                }\n            };\n\n            var primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\n            function valuesArePrimitiveAndEqual(a, b) {\n                var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n                return oldValueIsPrimitive ? (a === b) : false;\n            }\n\n            function throttle(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    if (!timeoutInstance) {\n                        timeoutInstance = ko.utils.setTimeout(function () {\n                            timeoutInstance = undefined;\n                            callback();\n                        }, timeout);\n                    }\n                };\n            }\n\n            function debounce(callback, timeout) {\n                var timeoutInstance;\n                return function () {\n                    clearTimeout(timeoutInstance);\n                    timeoutInstance = ko.utils.setTimeout(callback, timeout);\n                };\n            }\n\n            function applyExtenders(requestedExtenders) {\n                var target = this;\n                if (requestedExtenders) {\n                    ko.utils.objectForEach(requestedExtenders, function(key, value) {\n                        var extenderHandler = ko.extenders[key];\n                        if (typeof extenderHandler == 'function') {\n                            target = extenderHandler(target, value) || target;\n                        }\n                    });\n                }\n                return target;\n            }\n\n            ko.exportSymbol('extenders', ko.extenders);\n\n            ko.subscription = function (target, callback, disposeCallback) {\n                this._target = target;\n                this._callback = callback;\n                this._disposeCallback = disposeCallback;\n                this._isDisposed = false;\n                this._node = null;\n                this._domNodeDisposalCallback = null;\n                ko.exportProperty(this, 'dispose', this.dispose);\n                ko.exportProperty(this, 'disposeWhenNodeIsRemoved', this.disposeWhenNodeIsRemoved);\n            };\n            ko.subscription.prototype.dispose = function () {\n                var self = this;\n                if (!self._isDisposed) {\n                    if (self._domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(self._node, self._domNodeDisposalCallback);\n                    }\n                    self._isDisposed = true;\n                    self._disposeCallback();\n\n                    self._target = self._callback = self._disposeCallback = self._node = self._domNodeDisposalCallback = null;\n                }\n            };\n            ko.subscription.prototype.disposeWhenNodeIsRemoved = function (node) {\n                this._node = node;\n                ko.utils.domNodeDisposal.addDisposeCallback(node, this._domNodeDisposalCallback = this.dispose.bind(this));\n            };\n\n            ko.subscribable = function () {\n                ko.utils.setPrototypeOfOrExtend(this, ko_subscribable_fn);\n                ko_subscribable_fn.init(this);\n            }\n\n            var defaultEvent = \"change\";\n\n// Moved out of \"limit\" to avoid the extra closure\n            function limitNotifySubscribers(value, event) {\n                if (!event || event === defaultEvent) {\n                    this._limitChange(value);\n                } else if (event === 'beforeChange') {\n                    this._limitBeforeChange(value);\n                } else {\n                    this._origNotifySubscribers(value, event);\n                }\n            }\n\n            var ko_subscribable_fn = {\n                init: function(instance) {\n                    instance._subscriptions = { \"change\": [] };\n                    instance._versionNumber = 1;\n                },\n\n                subscribe: function (callback, callbackTarget, event) {\n                    var self = this;\n\n                    event = event || defaultEvent;\n                    var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n                    var subscription = new ko.subscription(self, boundCallback, function () {\n                        ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n                        if (self.afterSubscriptionRemove)\n                            self.afterSubscriptionRemove(event);\n                    });\n\n                    if (self.beforeSubscriptionAdd)\n                        self.beforeSubscriptionAdd(event);\n\n                    if (!self._subscriptions[event])\n                        self._subscriptions[event] = [];\n                    self._subscriptions[event].push(subscription);\n\n                    return subscription;\n                },\n\n                \"notifySubscribers\": function (valueToNotify, event) {\n                    event = event || defaultEvent;\n                    if (event === defaultEvent) {\n                        this.updateVersion();\n                    }\n                    if (this.hasSubscriptionsForEvent(event)) {\n                        var subs = event === defaultEvent && this._changeSubscriptions || this._subscriptions[event].slice(0);\n                        try {\n                            ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                            for (var i = 0, subscription; subscription = subs[i]; ++i) {\n                                // In case a subscription was disposed during the arrayForEach cycle, check\n                                // for isDisposed on each subscription before invoking its callback\n                                if (!subscription._isDisposed)\n                                    subscription._callback(valueToNotify);\n                            }\n                        } finally {\n                            ko.dependencyDetection.end(); // End suppressing dependency detection\n                        }\n                    }\n                },\n\n                getVersion: function () {\n                    return this._versionNumber;\n                },\n\n                hasChanged: function (versionToCheck) {\n                    return this.getVersion() !== versionToCheck;\n                },\n\n                updateVersion: function () {\n                    ++this._versionNumber;\n                },\n\n                limit: function(limitFunction) {\n                    var self = this, selfIsObservable = ko.isObservable(self),\n                        ignoreBeforeChange, notifyNextChange, previousValue, pendingValue, didUpdate,\n                        beforeChange = 'beforeChange';\n\n                    if (!self._origNotifySubscribers) {\n                        self._origNotifySubscribers = self[\"notifySubscribers\"];\n                        self[\"notifySubscribers\"] = limitNotifySubscribers;\n                    }\n\n                    var finish = limitFunction(function() {\n                        self._notificationIsPending = false;\n\n                        // If an observable provided a reference to itself, access it to get the latest value.\n                        // This allows computed observables to delay calculating their value until needed.\n                        if (selfIsObservable && pendingValue === self) {\n                            pendingValue = self._evalIfChanged ? self._evalIfChanged() : self();\n                        }\n                        var shouldNotify = notifyNextChange || (didUpdate && self.isDifferent(previousValue, pendingValue));\n\n                        didUpdate = notifyNextChange = ignoreBeforeChange = false;\n\n                        if (shouldNotify) {\n                            self._origNotifySubscribers(previousValue = pendingValue);\n                        }\n                    });\n\n                    self._limitChange = function(value, isDirty) {\n                        if (!isDirty || !self._notificationIsPending) {\n                            didUpdate = !isDirty;\n                        }\n                        self._changeSubscriptions = self._subscriptions[defaultEvent].slice(0);\n                        self._notificationIsPending = ignoreBeforeChange = true;\n                        pendingValue = value;\n                        finish();\n                    };\n                    self._limitBeforeChange = function(value) {\n                        if (!ignoreBeforeChange) {\n                            previousValue = value;\n                            self._origNotifySubscribers(value, beforeChange);\n                        }\n                    };\n                    self._recordUpdate = function() {\n                        didUpdate = true;\n                    };\n                    self._notifyNextChangeIfValueIsDifferent = function() {\n                        if (self.isDifferent(previousValue, self.peek(true /*evaluate*/))) {\n                            notifyNextChange = true;\n                        }\n                    };\n                },\n\n                hasSubscriptionsForEvent: function(event) {\n                    return this._subscriptions[event] && this._subscriptions[event].length;\n                },\n\n                getSubscriptionsCount: function (event) {\n                    if (event) {\n                        return this._subscriptions[event] && this._subscriptions[event].length || 0;\n                    } else {\n                        var total = 0;\n                        ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                            if (eventName !== 'dirty')\n                                total += subscriptions.length;\n                        });\n                        return total;\n                    }\n                },\n\n                isDifferent: function(oldValue, newValue) {\n                    return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n                },\n\n                toString: function() {\n                    return '[object Object]'\n                },\n\n                extend: applyExtenders\n            };\n\n            ko.exportProperty(ko_subscribable_fn, 'init', ko_subscribable_fn.init);\n            ko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\n            ko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\n            ko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n            }\n\n            ko.subscribable['fn'] = ko_subscribable_fn;\n\n\n            ko.isSubscribable = function (instance) {\n                return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n            };\n\n            ko.exportSymbol('subscribable', ko.subscribable);\n            ko.exportSymbol('isSubscribable', ko.isSubscribable);\n\n            ko.computedContext = ko.dependencyDetection = (function () {\n                var outerFrames = [],\n                    currentFrame,\n                    lastId = 0;\n\n                // Return a unique ID that can be assigned to an observable for dependency tracking.\n                // Theoretically, you could eventually overflow the number storage size, resulting\n                // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n                // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n                // take over 285 years to reach that number.\n                // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n                function getId() {\n                    return ++lastId;\n                }\n\n                function begin(options) {\n                    outerFrames.push(currentFrame);\n                    currentFrame = options;\n                }\n\n                function end() {\n                    currentFrame = outerFrames.pop();\n                }\n\n                return {\n                    begin: begin,\n\n                    end: end,\n\n                    registerDependency: function (subscribable) {\n                        if (currentFrame) {\n                            if (!ko.isSubscribable(subscribable))\n                                throw new Error(\"Only subscribable things can act as dependencies\");\n                            currentFrame.callback.call(currentFrame.callbackTarget, subscribable, subscribable._id || (subscribable._id = getId()));\n                        }\n                    },\n\n                    ignore: function (callback, callbackTarget, callbackArgs) {\n                        try {\n                            begin();\n                            return callback.apply(callbackTarget, callbackArgs || []);\n                        } finally {\n                            end();\n                        }\n                    },\n\n                    getDependenciesCount: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependenciesCount();\n                    },\n\n                    getDependencies: function () {\n                        if (currentFrame)\n                            return currentFrame.computed.getDependencies();\n                    },\n\n                    isInitial: function() {\n                        if (currentFrame)\n                            return currentFrame.isInitial;\n                    },\n\n                    computed: function() {\n                        if (currentFrame)\n                            return currentFrame.computed;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('computedContext', ko.computedContext);\n            ko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\n            ko.exportSymbol('computedContext.getDependencies', ko.computedContext.getDependencies);\n            ko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\n            ko.exportSymbol('computedContext.registerDependency', ko.computedContext.registerDependency);\n\n            ko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\n            var observableLatestValue = ko.utils.createSymbolOrString('_latestValue');\n\n            ko.observable = function (initialValue) {\n                function observable() {\n                    if (arguments.length > 0) {\n                        // Write\n\n                        // Ignore writes if the value hasn't changed\n                        if (observable.isDifferent(observable[observableLatestValue], arguments[0])) {\n                            observable.valueWillMutate();\n                            observable[observableLatestValue] = arguments[0];\n                            observable.valueHasMutated();\n                        }\n                        return this; // Permits chained assignments\n                    }\n                    else {\n                        // Read\n                        ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n                        return observable[observableLatestValue];\n                    }\n                }\n\n                observable[observableLatestValue] = initialValue;\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(observable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(observable);\n\n                // Inherit from 'observable'\n                ko.utils.setPrototypeOfOrExtend(observable, observableFn);\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](observable, true);\n                }\n\n                return observable;\n            }\n\n// Define prototype for observables\n            var observableFn = {\n                'equalityComparer': valuesArePrimitiveAndEqual,\n                peek: function() { return this[observableLatestValue]; },\n                valueHasMutated: function () {\n                    this['notifySubscribers'](this[observableLatestValue], 'spectate');\n                    this['notifySubscribers'](this[observableLatestValue]);\n                },\n                valueWillMutate: function () { this['notifySubscribers'](this[observableLatestValue], 'beforeChange'); }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(observableFn, ko.subscribable['fn']);\n            }\n\n            var protoProperty = ko.observable.protoProperty = '__ko_proto__';\n            observableFn[protoProperty] = ko.observable;\n\n            ko.isObservable = function (instance) {\n                var proto = typeof instance == 'function' && instance[protoProperty];\n                if (proto && proto !== observableFn[protoProperty] && proto !== ko.computed['fn'][protoProperty]) {\n                    throw Error(\"Invalid object that looks like an observable; possibly from another Knockout instance\");\n                }\n                return !!proto;\n            };\n\n            ko.isWriteableObservable = function (instance) {\n                return (typeof instance == 'function' && (\n                    (instance[protoProperty] === observableFn[protoProperty]) ||  // Observable\n                    (instance[protoProperty] === ko.computed['fn'][protoProperty] && instance.hasWriteFunction)));   // Writable computed observable\n            };\n\n            ko.exportSymbol('observable', ko.observable);\n            ko.exportSymbol('isObservable', ko.isObservable);\n            ko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\n            ko.exportSymbol('observable.fn', observableFn);\n            ko.exportProperty(observableFn, 'peek', observableFn.peek);\n            ko.exportProperty(observableFn, 'valueHasMutated', observableFn.valueHasMutated);\n            ko.exportProperty(observableFn, 'valueWillMutate', observableFn.valueWillMutate);\n            ko.observableArray = function (initialValues) {\n                initialValues = initialValues || [];\n\n                if (typeof initialValues != 'object' || !('length' in initialValues))\n                    throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n                var result = ko.observable(initialValues);\n                ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n                return result.extend({'trackArrayChanges':true});\n            };\n\n            ko.observableArray['fn'] = {\n                'remove': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var removedValues = [];\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    for (var i = 0; i < underlyingArray.length; i++) {\n                        var value = underlyingArray[i];\n                        if (predicate(value)) {\n                            if (removedValues.length === 0) {\n                                this.valueWillMutate();\n                            }\n                            if (underlyingArray[i] !== value) {\n                                throw Error(\"Array modified during remove; cannot remove item\");\n                            }\n                            removedValues.push(value);\n                            underlyingArray.splice(i, 1);\n                            i--;\n                        }\n                    }\n                    if (removedValues.length) {\n                        this.valueHasMutated();\n                    }\n                    return removedValues;\n                },\n\n                'removeAll': function (arrayOfValues) {\n                    // If you passed zero args, we remove everything\n                    if (arrayOfValues === undefined) {\n                        var underlyingArray = this.peek();\n                        var allValues = underlyingArray.slice(0);\n                        this.valueWillMutate();\n                        underlyingArray.splice(0, underlyingArray.length);\n                        this.valueHasMutated();\n                        return allValues;\n                    }\n                    // If you passed an arg, we interpret it as an array of entries to remove\n                    if (!arrayOfValues)\n                        return [];\n                    return this['remove'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'destroy': function (valueOrPredicate) {\n                    var underlyingArray = this.peek();\n                    var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n                    this.valueWillMutate();\n                    for (var i = underlyingArray.length - 1; i >= 0; i--) {\n                        var value = underlyingArray[i];\n                        if (predicate(value))\n                            value[\"_destroy\"] = true;\n                    }\n                    this.valueHasMutated();\n                },\n\n                'destroyAll': function (arrayOfValues) {\n                    // If you passed zero args, we destroy everything\n                    if (arrayOfValues === undefined)\n                        return this['destroy'](function() { return true });\n\n                    // If you passed an arg, we interpret it as an array of entries to destroy\n                    if (!arrayOfValues)\n                        return [];\n                    return this['destroy'](function (value) {\n                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n                    });\n                },\n\n                'indexOf': function (item) {\n                    var underlyingArray = this();\n                    return ko.utils.arrayIndexOf(underlyingArray, item);\n                },\n\n                'replace': function(oldItem, newItem) {\n                    var index = this['indexOf'](oldItem);\n                    if (index >= 0) {\n                        this.valueWillMutate();\n                        this.peek()[index] = newItem;\n                        this.valueHasMutated();\n                    }\n                },\n\n                'sorted': function (compareFunction) {\n                    var arrayCopy = this().slice(0);\n                    return compareFunction ? arrayCopy.sort(compareFunction) : arrayCopy.sort();\n                },\n\n                'reversed': function () {\n                    return this().slice(0).reverse();\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n            }\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\n            ko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n                    // (for consistency with mutating regular observables)\n                    var underlyingArray = this.peek();\n                    this.valueWillMutate();\n                    this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n                    var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n                    this.valueHasMutated();\n                    // The native sort and reverse methods return a reference to the array, but it makes more sense to return the observable array instead.\n                    return methodCallResult === underlyingArray ? this : methodCallResult;\n                };\n            });\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\n            ko.utils.arrayForEach([\"slice\"], function (methodName) {\n                ko.observableArray['fn'][methodName] = function () {\n                    var underlyingArray = this();\n                    return underlyingArray[methodName].apply(underlyingArray, arguments);\n                };\n            });\n\n            ko.isObservableArray = function (instance) {\n                return ko.isObservable(instance)\n                    && typeof instance[\"remove\"] == \"function\"\n                    && typeof instance[\"push\"] == \"function\";\n            };\n\n            ko.exportSymbol('observableArray', ko.observableArray);\n            ko.exportSymbol('isObservableArray', ko.isObservableArray);\n            var arrayChangeEventName = 'arrayChange';\n            ko.extenders['trackArrayChanges'] = function(target, options) {\n                // Use the provided options--each call to trackArrayChanges overwrites the previously set options\n                target.compareArrayOptions = {};\n                if (options && typeof options == \"object\") {\n                    ko.utils.extend(target.compareArrayOptions, options);\n                }\n                target.compareArrayOptions['sparse'] = true;\n\n                // Only modify the target observable once\n                if (target.cacheDiffForKnownOperation) {\n                    return;\n                }\n                var trackingChanges = false,\n                    cachedDiff = null,\n                    changeSubscription,\n                    spectateSubscription,\n                    pendingChanges = 0,\n                    previousContents,\n                    underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n                    underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n                // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n                target.beforeSubscriptionAdd = function (event) {\n                    if (underlyingBeforeSubscriptionAddFunction) {\n                        underlyingBeforeSubscriptionAddFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName) {\n                        trackChanges();\n                    }\n                };\n                // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n                target.afterSubscriptionRemove = function (event) {\n                    if (underlyingAfterSubscriptionRemoveFunction) {\n                        underlyingAfterSubscriptionRemoveFunction.call(target, event);\n                    }\n                    if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                        if (changeSubscription) {\n                            changeSubscription.dispose();\n                        }\n                        if (spectateSubscription) {\n                            spectateSubscription.dispose();\n                        }\n                        spectateSubscription = changeSubscription = null;\n                        trackingChanges = false;\n                        previousContents = undefined;\n                    }\n                };\n\n                function trackChanges() {\n                    if (trackingChanges) {\n                        // Whenever there's a new subscription and there are pending notifications, make sure all previous\n                        // subscriptions are notified of the change so that all subscriptions are in sync.\n                        notifyChanges();\n                        return;\n                    }\n\n                    trackingChanges = true;\n\n                    // Track how many times the array actually changed value\n                    spectateSubscription = target.subscribe(function () {\n                        ++pendingChanges;\n                    }, null, \"spectate\");\n\n                    // Each time the array changes value, capture a clone so that on the next\n                    // change it's possible to produce a diff\n                    previousContents = [].concat(target.peek() || []);\n                    cachedDiff = null;\n                    changeSubscription = target.subscribe(notifyChanges);\n\n                    function notifyChanges() {\n                        if (pendingChanges) {\n                            // Make a copy of the current contents and ensure it's an array\n                            var currentContents = [].concat(target.peek() || []), changes;\n\n                            // Compute the diff and issue notifications, but only if someone is listening\n                            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                                changes = getChanges(previousContents, currentContents);\n                            }\n\n                            // Eliminate references to the old, removed items, so they can be GCed\n                            previousContents = currentContents;\n                            cachedDiff = null;\n                            pendingChanges = 0;\n\n                            if (changes && changes.length) {\n                                target['notifySubscribers'](changes, arrayChangeEventName);\n                            }\n                        }\n                    }\n                }\n\n                function getChanges(previousContents, currentContents) {\n                    // We try to re-use cached diffs.\n                    // The scenarios where pendingChanges > 1 are when using rate limiting or deferred updates,\n                    // which without this check would not be compatible with arrayChange notifications. Normally,\n                    // notifications are issued immediately so we wouldn't be queueing up more than one.\n                    if (!cachedDiff || pendingChanges > 1) {\n                        cachedDiff = ko.utils.compareArrays(previousContents, currentContents, target.compareArrayOptions);\n                    }\n\n                    return cachedDiff;\n                }\n\n                target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n                    // Only run if we're currently tracking changes for this observable array\n                    // and there aren't any pending deferred notifications.\n                    if (!trackingChanges || pendingChanges) {\n                        return;\n                    }\n                    var diff = [],\n                        arrayLength = rawArray.length,\n                        argsLength = args.length,\n                        offset = 0;\n\n                    function pushDiff(status, value, index) {\n                        return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n                    }\n                    switch (operationName) {\n                        case 'push':\n                            offset = arrayLength;\n                        case 'unshift':\n                            for (var index = 0; index < argsLength; index++) {\n                                pushDiff('added', args[index], offset + index);\n                            }\n                            break;\n\n                        case 'pop':\n                            offset = arrayLength - 1;\n                        case 'shift':\n                            if (arrayLength) {\n                                pushDiff('deleted', rawArray[offset], offset);\n                            }\n                            break;\n\n                        case 'splice':\n                            // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                            // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                            var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                                endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                                endAddIndex = startIndex + argsLength - 2,\n                                endIndex = Math.max(endDeleteIndex, endAddIndex),\n                                additions = [], deletions = [];\n                            for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                                if (index < endDeleteIndex)\n                                    deletions.push(pushDiff('deleted', rawArray[index], index));\n                                if (index < endAddIndex)\n                                    additions.push(pushDiff('added', args[argsIndex], index));\n                            }\n                            ko.utils.findMovesInArrayComparison(deletions, additions);\n                            break;\n\n                        default:\n                            return;\n                    }\n                    cachedDiff = diff;\n                };\n            };\n            var computedState = ko.utils.createSymbolOrString('_state');\n\n            ko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n                if (typeof evaluatorFunctionOrOptions === \"object\") {\n                    // Single-parameter syntax - everything is on this \"options\" param\n                    options = evaluatorFunctionOrOptions;\n                } else {\n                    // Multi-parameter syntax - construct the options according to the params passed\n                    options = options || {};\n                    if (evaluatorFunctionOrOptions) {\n                        options[\"read\"] = evaluatorFunctionOrOptions;\n                    }\n                }\n                if (typeof options[\"read\"] != \"function\")\n                    throw Error(\"Pass a function that returns the value of the ko.computed\");\n\n                var writeFunction = options[\"write\"];\n                var state = {\n                    latestValue: undefined,\n                    isStale: true,\n                    isDirty: true,\n                    isBeingEvaluated: false,\n                    suppressDisposalUntilDisposeWhenReturnsFalse: false,\n                    isDisposed: false,\n                    pure: false,\n                    isSleeping: false,\n                    readFunction: options[\"read\"],\n                    evaluatorFunctionTarget: evaluatorFunctionTarget || options[\"owner\"],\n                    disposeWhenNodeIsRemoved: options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n                    disposeWhen: options[\"disposeWhen\"] || options.disposeWhen,\n                    domNodeDisposalCallback: null,\n                    dependencyTracking: {},\n                    dependenciesCount: 0,\n                    evaluationTimeoutInstance: null\n                };\n\n                function computedObservable() {\n                    if (arguments.length > 0) {\n                        if (typeof writeFunction === \"function\") {\n                            // Writing a value\n                            writeFunction.apply(state.evaluatorFunctionTarget, arguments);\n                        } else {\n                            throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n                        }\n                        return this; // Permits chained assignments\n                    } else {\n                        // Reading the value\n                        if (!state.isDisposed) {\n                            ko.dependencyDetection.registerDependency(computedObservable);\n                        }\n                        if (state.isDirty || (state.isSleeping && computedObservable.haveDependenciesChanged())) {\n                            computedObservable.evaluateImmediate();\n                        }\n                        return state.latestValue;\n                    }\n                }\n\n                computedObservable[computedState] = state;\n                computedObservable.hasWriteFunction = typeof writeFunction === \"function\";\n\n                // Inherit from 'subscribable'\n                if (!ko.utils.canSetPrototype) {\n                    // 'subscribable' won't be on the prototype chain unless we put it there directly\n                    ko.utils.extend(computedObservable, ko.subscribable['fn']);\n                }\n                ko.subscribable['fn'].init(computedObservable);\n\n                // Inherit from 'computed'\n                ko.utils.setPrototypeOfOrExtend(computedObservable, computedFn);\n\n                if (options['pure']) {\n                    state.pure = true;\n                    state.isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n                    ko.utils.extend(computedObservable, pureComputedOverrides);\n                } else if (options['deferEvaluation']) {\n                    ko.utils.extend(computedObservable, deferEvaluationOverrides);\n                }\n\n                if (ko.options['deferUpdates']) {\n                    ko.extenders['deferred'](computedObservable, true);\n                }\n\n                if (DEBUG) {\n                    // #1731 - Aid debugging by exposing the computed's options\n                    computedObservable[\"_options\"] = options;\n                }\n\n                if (state.disposeWhenNodeIsRemoved) {\n                    // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n                    // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n                    // we'll prevent disposal until \"disposeWhen\" first returns false.\n                    state.suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n                    // disposeWhenNodeIsRemoved: true can be used to opt into the \"only dispose after first false result\"\n                    // behaviour even if there's no specific node to watch. In that case, clear the option so we don't try\n                    // to watch for a non-node's disposal. This technique is intended for KO's internal use only and shouldn't\n                    // be documented or used by application code, as it's likely to change in a future version of KO.\n                    if (!state.disposeWhenNodeIsRemoved.nodeType) {\n                        state.disposeWhenNodeIsRemoved = null;\n                    }\n                }\n\n                // Evaluate, unless sleeping or deferEvaluation is true\n                if (!state.isSleeping && !options['deferEvaluation']) {\n                    computedObservable.evaluateImmediate();\n                }\n\n                // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n                // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n                if (state.disposeWhenNodeIsRemoved && computedObservable.isActive()) {\n                    ko.utils.domNodeDisposal.addDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback = function () {\n                        computedObservable.dispose();\n                    });\n                }\n\n                return computedObservable;\n            };\n\n// Utility function that disposes a given dependencyTracking entry\n            function computedDisposeDependencyCallback(id, entryToDispose) {\n                if (entryToDispose !== null && entryToDispose.dispose) {\n                    entryToDispose.dispose();\n                }\n            }\n\n// This function gets called each time a dependency is detected while evaluating a computed.\n// It's factored out as a shared function to avoid creating unnecessary function instances during evaluation.\n            function computedBeginDependencyDetectionCallback(subscribable, id) {\n                var computedObservable = this.computedObservable,\n                    state = computedObservable[computedState];\n                if (!state.isDisposed) {\n                    if (this.disposalCount && this.disposalCandidates[id]) {\n                        // Don't want to dispose this subscription, as it's still being used\n                        computedObservable.addDependencyTracking(id, subscribable, this.disposalCandidates[id]);\n                        this.disposalCandidates[id] = null; // No need to actually delete the property - disposalCandidates is a transient object anyway\n                        --this.disposalCount;\n                    } else if (!state.dependencyTracking[id]) {\n                        // Brand new subscription - add it\n                        computedObservable.addDependencyTracking(id, subscribable, state.isSleeping ? { _target: subscribable } : computedObservable.subscribeToDependency(subscribable));\n                    }\n                    // If the observable we've accessed has a pending notification, ensure we get notified of the actual final value (bypass equality checks)\n                    if (subscribable._notificationIsPending) {\n                        subscribable._notifyNextChangeIfValueIsDifferent();\n                    }\n                }\n            }\n\n            var computedFn = {\n                \"equalityComparer\": valuesArePrimitiveAndEqual,\n                getDependenciesCount: function () {\n                    return this[computedState].dependenciesCount;\n                },\n                getDependencies: function () {\n                    var dependencyTracking = this[computedState].dependencyTracking, dependentObservables = [];\n\n                    ko.utils.objectForEach(dependencyTracking, function (id, dependency) {\n                        dependentObservables[dependency._order] = dependency._target;\n                    });\n\n                    return dependentObservables;\n                },\n                hasAncestorDependency: function (obs) {\n                    if (!this[computedState].dependenciesCount) {\n                        return false;\n                    }\n                    var dependencies = this.getDependencies();\n                    if (ko.utils.arrayIndexOf(dependencies, obs) !== -1) {\n                        return true;\n                    }\n                    return !!ko.utils.arrayFirst(dependencies, function (dep) {\n                        return dep.hasAncestorDependency && dep.hasAncestorDependency(obs);\n                    });\n                },\n                addDependencyTracking: function (id, target, trackingObj) {\n                    if (this[computedState].pure && target === this) {\n                        throw Error(\"A 'pure' computed must not be called recursively\");\n                    }\n\n                    this[computedState].dependencyTracking[id] = trackingObj;\n                    trackingObj._order = this[computedState].dependenciesCount++;\n                    trackingObj._version = target.getVersion();\n                },\n                haveDependenciesChanged: function () {\n                    var id, dependency, dependencyTracking = this[computedState].dependencyTracking;\n                    for (id in dependencyTracking) {\n                        if (Object.prototype.hasOwnProperty.call(dependencyTracking, id)) {\n                            dependency = dependencyTracking[id];\n                            if ((this._evalDelayed && dependency._target._notificationIsPending) || dependency._target.hasChanged(dependency._version)) {\n                                return true;\n                            }\n                        }\n                    }\n                },\n                markDirty: function () {\n                    // Process \"dirty\" events if we can handle delayed notifications\n                    if (this._evalDelayed && !this[computedState].isBeingEvaluated) {\n                        this._evalDelayed(false /*isChange*/);\n                    }\n                },\n                isActive: function () {\n                    var state = this[computedState];\n                    return state.isDirty || state.dependenciesCount > 0;\n                },\n                respondToChange: function () {\n                    // Ignore \"change\" events if we've already scheduled a delayed notification\n                    if (!this._notificationIsPending) {\n                        this.evaluatePossiblyAsync();\n                    } else if (this[computedState].isDirty) {\n                        this[computedState].isStale = true;\n                    }\n                },\n                subscribeToDependency: function (target) {\n                    if (target._deferUpdates) {\n                        var dirtySub = target.subscribe(this.markDirty, this, 'dirty'),\n                            changeSub = target.subscribe(this.respondToChange, this);\n                        return {\n                            _target: target,\n                            dispose: function () {\n                                dirtySub.dispose();\n                                changeSub.dispose();\n                            }\n                        };\n                    } else {\n                        return target.subscribe(this.evaluatePossiblyAsync, this);\n                    }\n                },\n                evaluatePossiblyAsync: function () {\n                    var computedObservable = this,\n                        throttleEvaluationTimeout = computedObservable['throttleEvaluation'];\n                    if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n                        clearTimeout(this[computedState].evaluationTimeoutInstance);\n                        this[computedState].evaluationTimeoutInstance = ko.utils.setTimeout(function () {\n                            computedObservable.evaluateImmediate(true /*notifyChange*/);\n                        }, throttleEvaluationTimeout);\n                    } else if (computedObservable._evalDelayed) {\n                        computedObservable._evalDelayed(true /*isChange*/);\n                    } else {\n                        computedObservable.evaluateImmediate(true /*notifyChange*/);\n                    }\n                },\n                evaluateImmediate: function (notifyChange) {\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        disposeWhen = state.disposeWhen,\n                        changed = false;\n\n                    if (state.isBeingEvaluated) {\n                        // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n                        // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n                        // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n                        // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n                        return;\n                    }\n\n                    // Do not evaluate (and possibly capture new dependencies) if disposed\n                    if (state.isDisposed) {\n                        return;\n                    }\n\n                    if (state.disposeWhenNodeIsRemoved && !ko.utils.domNodeIsAttachedToDocument(state.disposeWhenNodeIsRemoved) || disposeWhen && disposeWhen()) {\n                        // See comment above about suppressDisposalUntilDisposeWhenReturnsFalse\n                        if (!state.suppressDisposalUntilDisposeWhenReturnsFalse) {\n                            computedObservable.dispose();\n                            return;\n                        }\n                    } else {\n                        // It just did return false, so we can stop suppressing now\n                        state.suppressDisposalUntilDisposeWhenReturnsFalse = false;\n                    }\n\n                    state.isBeingEvaluated = true;\n                    try {\n                        changed = this.evaluateImmediate_CallReadWithDependencyDetection(notifyChange);\n                    } finally {\n                        state.isBeingEvaluated = false;\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadWithDependencyDetection: function (notifyChange) {\n                    // This function is really just part of the evaluateImmediate logic. You would never call it from anywhere else.\n                    // Factoring it out into a separate function means it can be independent of the try/catch block in evaluateImmediate,\n                    // which contributes to saving about 40% off the CPU overhead of computed evaluation (on V8 at least).\n\n                    var computedObservable = this,\n                        state = computedObservable[computedState],\n                        changed = false;\n\n                    // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n                    // Then, during evaluation, we cross off any that are in fact still being used.\n                    var isInitial = state.pure ? undefined : !state.dependenciesCount,   // If we're evaluating when there are no previous dependencies, it must be the first time\n                        dependencyDetectionContext = {\n                            computedObservable: computedObservable,\n                            disposalCandidates: state.dependencyTracking,\n                            disposalCount: state.dependenciesCount\n                        };\n\n                    ko.dependencyDetection.begin({\n                        callbackTarget: dependencyDetectionContext,\n                        callback: computedBeginDependencyDetectionCallback,\n                        computed: computedObservable,\n                        isInitial: isInitial\n                    });\n\n                    state.dependencyTracking = {};\n                    state.dependenciesCount = 0;\n\n                    var newValue = this.evaluateImmediate_CallReadThenEndDependencyDetection(state, dependencyDetectionContext);\n\n                    if (!state.dependenciesCount) {\n                        computedObservable.dispose();\n                        changed = true; // When evaluation causes a disposal, make sure all dependent computeds get notified so they'll see the new state\n                    } else {\n                        changed = computedObservable.isDifferent(state.latestValue, newValue);\n                    }\n\n                    if (changed) {\n                        if (!state.isSleeping) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"beforeChange\");\n                        } else {\n                            computedObservable.updateVersion();\n                        }\n\n                        state.latestValue = newValue;\n                        if (DEBUG) computedObservable._latestValue = newValue;\n\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"spectate\");\n\n                        if (!state.isSleeping && notifyChange) {\n                            computedObservable[\"notifySubscribers\"](state.latestValue);\n                        }\n                        if (computedObservable._recordUpdate) {\n                            computedObservable._recordUpdate();\n                        }\n                    }\n\n                    if (isInitial) {\n                        computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                    }\n\n                    return changed;\n                },\n                evaluateImmediate_CallReadThenEndDependencyDetection: function (state, dependencyDetectionContext) {\n                    // This function is really part of the evaluateImmediate_CallReadWithDependencyDetection logic.\n                    // You'd never call it from anywhere else. Factoring it out means that evaluateImmediate_CallReadWithDependencyDetection\n                    // can be independent of try/finally blocks, which contributes to saving about 40% off the CPU\n                    // overhead of computed evaluation (on V8 at least).\n\n                    try {\n                        var readFunction = state.readFunction;\n                        return state.evaluatorFunctionTarget ? readFunction.call(state.evaluatorFunctionTarget) : readFunction();\n                    } finally {\n                        ko.dependencyDetection.end();\n\n                        // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n                        if (dependencyDetectionContext.disposalCount && !state.isSleeping) {\n                            ko.utils.objectForEach(dependencyDetectionContext.disposalCandidates, computedDisposeDependencyCallback);\n                        }\n\n                        state.isStale = state.isDirty = false;\n                    }\n                },\n                peek: function (evaluate) {\n                    // By default, peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n                    // Pass in true to evaluate if needed.\n                    var state = this[computedState];\n                    if ((state.isDirty && (evaluate || !state.dependenciesCount)) || (state.isSleeping && this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return state.latestValue;\n                },\n                limit: function (limitFunction) {\n                    // Override the limit function with one that delays evaluation as well\n                    ko.subscribable['fn'].limit.call(this, limitFunction);\n                    this._evalIfChanged = function () {\n                        if (!this[computedState].isSleeping) {\n                            if (this[computedState].isStale) {\n                                this.evaluateImmediate();\n                            } else {\n                                this[computedState].isDirty = false;\n                            }\n                        }\n                        return this[computedState].latestValue;\n                    };\n                    this._evalDelayed = function (isChange) {\n                        this._limitBeforeChange(this[computedState].latestValue);\n\n                        // Mark as dirty\n                        this[computedState].isDirty = true;\n                        if (isChange) {\n                            this[computedState].isStale = true;\n                        }\n\n                        // Pass the observable to the \"limit\" code, which will evaluate it when\n                        // it's time to do the notification.\n                        this._limitChange(this, !isChange /* isDirty */);\n                    };\n                },\n                dispose: function () {\n                    var state = this[computedState];\n                    if (!state.isSleeping && state.dependencyTracking) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose)\n                                dependency.dispose();\n                        });\n                    }\n                    if (state.disposeWhenNodeIsRemoved && state.domNodeDisposalCallback) {\n                        ko.utils.domNodeDisposal.removeDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback);\n                    }\n                    state.dependencyTracking = undefined;\n                    state.dependenciesCount = 0;\n                    state.isDisposed = true;\n                    state.isStale = false;\n                    state.isDirty = false;\n                    state.isSleeping = false;\n                    state.disposeWhenNodeIsRemoved = undefined;\n                    state.disposeWhen = undefined;\n                    state.readFunction = undefined;\n                    if (!this.hasWriteFunction) {\n                        state.evaluatorFunctionTarget = undefined;\n                    }\n                }\n            };\n\n            var pureComputedOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // If asleep, wake up the computed by subscribing to any dependencies.\n                    var computedObservable = this,\n                        state = computedObservable[computedState];\n                    if (!state.isDisposed && state.isSleeping && event == 'change') {\n                        state.isSleeping = false;\n                        if (state.isStale || computedObservable.haveDependenciesChanged()) {\n                            state.dependencyTracking = null;\n                            state.dependenciesCount = 0;\n                            if (computedObservable.evaluateImmediate()) {\n                                computedObservable.updateVersion();\n                            }\n                        } else {\n                            // First put the dependencies in order\n                            var dependenciesOrder = [];\n                            ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                                dependenciesOrder[dependency._order] = id;\n                            });\n                            // Next, subscribe to each one\n                            ko.utils.arrayForEach(dependenciesOrder, function (id, order) {\n                                var dependency = state.dependencyTracking[id],\n                                    subscription = computedObservable.subscribeToDependency(dependency._target);\n                                subscription._order = order;\n                                subscription._version = dependency._version;\n                                state.dependencyTracking[id] = subscription;\n                            });\n                            // Waking dependencies may have triggered effects\n                            if (computedObservable.haveDependenciesChanged()) {\n                                if (computedObservable.evaluateImmediate()) {\n                                    computedObservable.updateVersion();\n                                }\n                            }\n                        }\n\n                        if (!state.isDisposed) {     // test since evaluating could trigger disposal\n                            computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n                        }\n                    }\n                },\n                afterSubscriptionRemove: function (event) {\n                    var state = this[computedState];\n                    if (!state.isDisposed && event == 'change' && !this.hasSubscriptionsForEvent('change')) {\n                        ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                            if (dependency.dispose) {\n                                state.dependencyTracking[id] = {\n                                    _target: dependency._target,\n                                    _order: dependency._order,\n                                    _version: dependency._version\n                                };\n                                dependency.dispose();\n                            }\n                        });\n                        state.isSleeping = true;\n                        this[\"notifySubscribers\"](undefined, \"asleep\");\n                    }\n                },\n                getVersion: function () {\n                    // Because a pure computed is not automatically updated while it is sleeping, we can't\n                    // simply return the version number. Instead, we check if any of the dependencies have\n                    // changed and conditionally re-evaluate the computed observable.\n                    var state = this[computedState];\n                    if (state.isSleeping && (state.isStale || this.haveDependenciesChanged())) {\n                        this.evaluateImmediate();\n                    }\n                    return ko.subscribable['fn'].getVersion.call(this);\n                }\n            };\n\n            var deferEvaluationOverrides = {\n                beforeSubscriptionAdd: function (event) {\n                    // This will force a computed with deferEvaluation to evaluate when the first subscription is registered.\n                    if (event == 'change' || event == 'beforeChange') {\n                        this.peek();\n                    }\n                }\n            };\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.computed constructor\n            if (ko.utils.canSetPrototype) {\n                ko.utils.setPrototypeOf(computedFn, ko.subscribable['fn']);\n            }\n\n// Set the proto values for ko.computed\n            var protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\n            computedFn[protoProp] = ko.computed;\n\n            ko.isComputed = function (instance) {\n                return (typeof instance == 'function' && instance[protoProp] === computedFn[protoProp]);\n            };\n\n            ko.isPureComputed = function (instance) {\n                return ko.isComputed(instance) && instance[computedState] && instance[computedState].pure;\n            };\n\n            ko.exportSymbol('computed', ko.computed);\n            ko.exportSymbol('dependentObservable', ko.computed);    // export ko.dependentObservable for backwards compatibility (1.x)\n            ko.exportSymbol('isComputed', ko.isComputed);\n            ko.exportSymbol('isPureComputed', ko.isPureComputed);\n            ko.exportSymbol('computed.fn', computedFn);\n            ko.exportProperty(computedFn, 'peek', computedFn.peek);\n            ko.exportProperty(computedFn, 'dispose', computedFn.dispose);\n            ko.exportProperty(computedFn, 'isActive', computedFn.isActive);\n            ko.exportProperty(computedFn, 'getDependenciesCount', computedFn.getDependenciesCount);\n            ko.exportProperty(computedFn, 'getDependencies', computedFn.getDependencies);\n\n            ko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n                if (typeof evaluatorFunctionOrOptions === 'function') {\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n                } else {\n                    evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n                    evaluatorFunctionOrOptions['pure'] = true;\n                    return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n                }\n            }\n            ko.exportSymbol('pureComputed', ko.pureComputed);\n\n            (function() {\n                var maxNestedObservableDepth = 10; // Escape the (unlikely) pathological case where an observable's current value is itself (or similar reference cycle)\n\n                ko.toJS = function(rootObject) {\n                    if (arguments.length == 0)\n                        throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n                    // We just unwrap everything at every level in the object graph\n                    return mapJsObjectGraph(rootObject, function(valueToMap) {\n                        // Loop because an observable's value might in turn be another observable wrapper\n                        for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                            valueToMap = valueToMap();\n                        return valueToMap;\n                    });\n                };\n\n                ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n                    var plainJavaScriptObject = ko.toJS(rootObject);\n                    return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n                };\n\n                function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n                    visitedObjects = visitedObjects || new objectLookup();\n\n                    rootObject = mapInputCallback(rootObject);\n                    var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof RegExp)) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n                    if (!canHaveProperties)\n                        return rootObject;\n\n                    var outputProperties = rootObject instanceof Array ? [] : {};\n                    visitedObjects.save(rootObject, outputProperties);\n\n                    visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n                        var propertyValue = mapInputCallback(rootObject[indexer]);\n\n                        switch (typeof propertyValue) {\n                            case \"boolean\":\n                            case \"number\":\n                            case \"string\":\n                            case \"function\":\n                                outputProperties[indexer] = propertyValue;\n                                break;\n                            case \"object\":\n                            case \"undefined\":\n                                var previouslyMappedValue = visitedObjects.get(propertyValue);\n                                outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                                    ? previouslyMappedValue\n                                    : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                                break;\n                        }\n                    });\n\n                    return outputProperties;\n                }\n\n                function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n                    if (rootObject instanceof Array) {\n                        for (var i = 0; i < rootObject.length; i++)\n                            visitorCallback(i);\n\n                        // For arrays, also respect toJSON property for custom mappings (fixes #278)\n                        if (typeof rootObject['toJSON'] == 'function')\n                            visitorCallback('toJSON');\n                    } else {\n                        for (var propertyName in rootObject) {\n                            visitorCallback(propertyName);\n                        }\n                    }\n                };\n\n                function objectLookup() {\n                    this.keys = [];\n                    this.values = [];\n                };\n\n                objectLookup.prototype = {\n                    constructor: objectLookup,\n                    save: function(key, value) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        if (existingIndex >= 0)\n                            this.values[existingIndex] = value;\n                        else {\n                            this.keys.push(key);\n                            this.values.push(value);\n                        }\n                    },\n                    get: function(key) {\n                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n                        return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n                    }\n                };\n            })();\n\n            ko.exportSymbol('toJS', ko.toJS);\n            ko.exportSymbol('toJSON', ko.toJSON);\n            ko.when = function(predicate, callback, context) {\n                function kowhen (resolve) {\n                    var observable = ko.pureComputed(predicate, context).extend({notify:'always'});\n                    var subscription = observable.subscribe(function(value) {\n                        if (value) {\n                            subscription.dispose();\n                            resolve(value);\n                        }\n                    });\n                    // In case the initial value is true, process it right away\n                    observable['notifySubscribers'](observable.peek());\n\n                    return subscription;\n                }\n                if (typeof Promise === \"function\" && !callback) {\n                    return new Promise(kowhen);\n                } else {\n                    return kowhen(callback.bind(context));\n                }\n            };\n\n            ko.exportSymbol('when', ko.when);\n            (function () {\n                var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n                // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n                // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n                // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n                ko.selectExtensions = {\n                    readValue : function(element) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (element[hasDomDataExpandoProperty] === true)\n                                    return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                                return ko.utils.ieVersion <= 7\n                                    ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                                    : element.value;\n                            case 'select':\n                                return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                            default:\n                                return element.value;\n                        }\n                    },\n\n                    writeValue: function(element, value, allowUnset) {\n                        switch (ko.utils.tagNameLower(element)) {\n                            case 'option':\n                                if (typeof value === \"string\") {\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                                    if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                        delete element[hasDomDataExpandoProperty];\n                                    }\n                                    element.value = value;\n                                }\n                                else {\n                                    // Store arbitrary object using DomData\n                                    ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                                    element[hasDomDataExpandoProperty] = true;\n\n                                    // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                                    element.value = typeof value === \"number\" ? value : \"\";\n                                }\n                                break;\n                            case 'select':\n                                if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                                    value = undefined;\n                                var selection = -1;\n                                for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                                    optionValue = ko.selectExtensions.readValue(element.options[i]);\n                                    // Include special check to handle selecting a caption with a blank string value\n                                    if (optionValue == value || (optionValue === \"\" && value === undefined)) {\n                                        selection = i;\n                                        break;\n                                    }\n                                }\n                                if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                                    element.selectedIndex = selection;\n                                    if (ko.utils.ieVersion === 6) {\n                                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                                        // to apply the value as well.\n                                        ko.utils.setTimeout(function () {\n                                            element.selectedIndex = selection;\n                                        }, 0);\n                                    }\n                                }\n                                break;\n                            default:\n                                if ((value === null) || (value === undefined))\n                                    value = \"\";\n                                element.value = value;\n                                break;\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('selectExtensions', ko.selectExtensions);\n            ko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\n            ko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\n            ko.expressionRewriting = (function () {\n                var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n                // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n                // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n                // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n                var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n                function getWriteableValue(expression) {\n                    if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n                        return false;\n                    var match = expression.match(javaScriptAssignmentTarget);\n                    return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n                }\n\n                // The following regular expressions will be used to split an object-literal string into tokens\n\n                var specials = ',\"\\'`{}()/:[\\\\]',    // These characters have special meaning to the parser and must not appear in the middle of a token, except as part of a string.\n                    // Create the actual regular expression by or-ing the following regex strings. The order is important.\n                    bindingToken = RegExp([\n                        // These match strings, either with double quotes, single quotes, or backticks\n                        '\"(?:\\\\\\\\.|[^\"])*\"',\n                        \"'(?:\\\\\\\\.|[^'])*'\",\n                        \"`(?:\\\\\\\\.|[^`])*`\",\n                        // Match C style comments\n                        \"/\\\\*(?:[^*]|\\\\*+[^*/])*\\\\*+/\",\n                        // Match C++ style comments\n                        \"//.*\\n\",\n                        // Match a regular expression (text enclosed by slashes), but will also match sets of divisions\n                        // as a regular expression (this is handled by the parsing loop below).\n                        '/(?:\\\\\\\\.|[^/])+/\\w*',\n                        // Match text (at least two characters) that does not contain any of the above special characters,\n                        // although some of the special characters are allowed to start it (all but the colon and comma).\n                        // The text can contain spaces, but leading or trailing spaces are skipped.\n                        '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n                        // Match any non-space character not matched already. This will match colons and commas, since they're\n                        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n                        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n                        '[^\\\\s]'\n                    ].join('|'), 'g'),\n\n                    // Match end of previous token to determine whether a slash is a division or regex.\n                    divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n                    keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n                function parseObjectLiteral(objectLiteralString) {\n                    // Trim leading and trailing spaces from the string\n                    var str = ko.utils.stringTrim(objectLiteralString);\n\n                    // Trim braces '{' surrounding the whole object literal\n                    if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n                    // Add a newline to correctly match a C++ style comment at the end of the string and\n                    // add a comma so that we don't need a separate code block to deal with the last item\n                    str += \"\\n,\";\n\n                    // Split into tokens\n                    var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n                    if (toks.length > 1) {\n                        for (var i = 0, tok; tok = toks[i]; ++i) {\n                            var c = tok.charCodeAt(0);\n                            // A comma signals the end of a key/value pair if depth is zero\n                            if (c === 44) { // \",\"\n                                if (depth <= 0) {\n                                    result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                                    key = depth = 0;\n                                    values = [];\n                                    continue;\n                                }\n                                // Simply skip the colon that separates the name and value\n                            } else if (c === 58) { // \":\"\n                                if (!depth && !key && values.length === 1) {\n                                    key = values.pop();\n                                    continue;\n                                }\n                                // Comments: skip them\n                            } else if (c === 47 && tok.length > 1 && (tok.charCodeAt(1) === 47 || tok.charCodeAt(1) === 42)) {  // \"//\" or \"/*\"\n                                continue;\n                                // A set of slashes is initially matched as a regular expression, but could be division\n                            } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                                // Look at the end of the previous token to determine if the slash is actually division\n                                var match = toks[i-1].match(divisionLookBehind);\n                                if (match && !keywordRegexLookBehind[match[0]]) {\n                                    // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                                    str = str.substr(str.indexOf(tok) + 1);\n                                    toks = str.match(bindingToken);\n                                    i = -1;\n                                    // Continue with just the slash\n                                    tok = '/';\n                                }\n                                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                            } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                                ++depth;\n                            } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                                --depth;\n                                // The key will be the first token; if it's a string, trim the quotes\n                            } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                                tok = tok.slice(1, -1);\n                            }\n                            values.push(tok);\n                        }\n                        if (depth > 0) {\n                            throw Error(\"Unbalanced parentheses, braces, or brackets\");\n                        }\n                    }\n                    return result;\n                }\n\n                // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n                var twoWayBindings = {};\n\n                function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n                    bindingOptions = bindingOptions || {};\n\n                    function processKeyValue(key, val) {\n                        var writableVal;\n                        function callPreprocessHook(obj) {\n                            return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n                        }\n                        if (!bindingParams) {\n                            if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                                return;\n\n                            if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                                // For two-way bindings, provide a write method in case the value\n                                // isn't a writable observable.\n                                var writeKey = typeof twoWayBindings[key] == 'string' ? twoWayBindings[key] : key;\n                                propertyAccessorResultStrings.push(\"'\" + writeKey + \"':function(_z){\" + writableVal + \"=_z}\");\n                            }\n                        }\n                        // Values are wrapped in a function so that each value can be accessed independently\n                        if (makeValueAccessors) {\n                            val = 'function(){return ' + val + ' }';\n                        }\n                        resultStrings.push(\"'\" + key + \"':\" + val);\n                    }\n\n                    var resultStrings = [],\n                        propertyAccessorResultStrings = [],\n                        makeValueAccessors = bindingOptions['valueAccessors'],\n                        bindingParams = bindingOptions['bindingParams'],\n                        keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                            parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n                    ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n                        processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n                    });\n\n                    if (propertyAccessorResultStrings.length)\n                        processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n                    return resultStrings.join(\",\");\n                }\n\n                return {\n                    bindingRewriteValidators: [],\n\n                    twoWayBindings: twoWayBindings,\n\n                    parseObjectLiteral: parseObjectLiteral,\n\n                    preProcessBindings: preProcessBindings,\n\n                    keyValueArrayContainsKey: function(keyValueArray, key) {\n                        for (var i = 0; i < keyValueArray.length; i++)\n                            if (keyValueArray[i]['key'] == key)\n                                return true;\n                        return false;\n                    },\n\n                    // Internal, private KO utility for updating model properties from within bindings\n                    // property:            If the property being updated is (or might be) an observable, pass it here\n                    //                      If it turns out to be a writable observable, it will be written to directly\n                    // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n                    //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n                    // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n                    // value:               The value to be written\n                    // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n                    //                      it is !== existing value on that writable observable\n                    writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n                        if (!property || !ko.isObservable(property)) {\n                            var propWriters = allBindings.get('_ko_property_writers');\n                            if (propWriters && propWriters[key])\n                                propWriters[key](value);\n                        } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                            property(value);\n                        }\n                    }\n                };\n            })();\n\n            ko.exportSymbol('expressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\n            ko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\n            ko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\n            ko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\n            ko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\n            ko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n            (function() {\n                // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n                // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n                // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n                // of that virtual hierarchy\n                //\n                // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n                // without having to scatter special cases all over the binding and templating code.\n\n                // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n                // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n                // So, use node.text where available, and node.nodeValue elsewhere\n                var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n                var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n                var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n                var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n                function isStartComment(node) {\n                    return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isEndComment(node) {\n                    return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n                }\n\n                function isUnmatchedEndComment(node) {\n                    return isEndComment(node) && !(ko.utils.domData.get(node, matchedEndCommentDataKey));\n                }\n\n                var matchedEndCommentDataKey = \"__ko_matchedEndComment__\"\n\n                function getVirtualChildren(startComment, allowUnbalanced) {\n                    var currentNode = startComment;\n                    var depth = 1;\n                    var children = [];\n                    while (currentNode = currentNode.nextSibling) {\n                        if (isEndComment(currentNode)) {\n                            ko.utils.domData.set(currentNode, matchedEndCommentDataKey, true);\n                            depth--;\n                            if (depth === 0)\n                                return children;\n                        }\n\n                        children.push(currentNode);\n\n                        if (isStartComment(currentNode))\n                            depth++;\n                    }\n                    if (!allowUnbalanced)\n                        throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n                    return null;\n                }\n\n                function getMatchingEndComment(startComment, allowUnbalanced) {\n                    var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n                    if (allVirtualChildren) {\n                        if (allVirtualChildren.length > 0)\n                            return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n                        return startComment.nextSibling;\n                    } else\n                        return null; // Must have no matching end comment, and allowUnbalanced is true\n                }\n\n                function getUnbalancedChildTags(node) {\n                    // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n                    //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n                    var childNode = node.firstChild, captureRemaining = null;\n                    if (childNode) {\n                        do {\n                            if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                                captureRemaining.push(childNode);\n                            else if (isStartComment(childNode)) {\n                                var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                                if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                                    childNode = matchingEndComment;\n                                else\n                                    captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                            } else if (isEndComment(childNode)) {\n                                captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                            }\n                        } while (childNode = childNode.nextSibling);\n                    }\n                    return captureRemaining;\n                }\n\n                ko.virtualElements = {\n                    allowedBindings: {},\n\n                    childNodes: function(node) {\n                        return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n                    },\n\n                    emptyNode: function(node) {\n                        if (!isStartComment(node))\n                            ko.utils.emptyDomNode(node);\n                        else {\n                            var virtualChildren = ko.virtualElements.childNodes(node);\n                            for (var i = 0, j = virtualChildren.length; i < j; i++)\n                                ko.removeNode(virtualChildren[i]);\n                        }\n                    },\n\n                    setDomNodeChildren: function(node, childNodes) {\n                        if (!isStartComment(node))\n                            ko.utils.setDomNodeChildren(node, childNodes);\n                        else {\n                            ko.virtualElements.emptyNode(node);\n                            var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                            for (var i = 0, j = childNodes.length; i < j; i++)\n                                endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n                        }\n                    },\n\n                    prepend: function(containerNode, nodeToPrepend) {\n                        var insertBeforeNode;\n\n                        if (isStartComment(containerNode)) {\n                            // Start comments must always have a parent and at least one following sibling (the end comment)\n                            insertBeforeNode = containerNode.nextSibling;\n                            containerNode = containerNode.parentNode;\n                        } else {\n                            insertBeforeNode = containerNode.firstChild;\n                        }\n\n                        if (!insertBeforeNode) {\n                            containerNode.appendChild(nodeToPrepend);\n                        } else if (nodeToPrepend !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                            containerNode.insertBefore(nodeToPrepend, insertBeforeNode);\n                        }\n                    },\n\n                    insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n                        if (!insertAfterNode) {\n                            ko.virtualElements.prepend(containerNode, nodeToInsert);\n                        } else {\n                            // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                            var insertBeforeNode = insertAfterNode.nextSibling;\n\n                            if (isStartComment(containerNode)) {\n                                containerNode = containerNode.parentNode;\n                            }\n\n                            if (!insertBeforeNode) {\n                                containerNode.appendChild(nodeToInsert);\n                            } else if (nodeToInsert !== insertBeforeNode) {       // IE will sometimes crash if you try to insert a node before itself\n                                containerNode.insertBefore(nodeToInsert, insertBeforeNode);\n                            }\n                        }\n                    },\n\n                    firstChild: function(node) {\n                        if (!isStartComment(node)) {\n                            if (node.firstChild && isEndComment(node.firstChild)) {\n                                throw new Error(\"Found invalid end comment, as the first child of \" + node);\n                            }\n                            return node.firstChild;\n                        } else if (!node.nextSibling || isEndComment(node.nextSibling)) {\n                            return null;\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    nextSibling: function(node) {\n                        if (isStartComment(node)) {\n                            node = getMatchingEndComment(node);\n                        }\n\n                        if (node.nextSibling && isEndComment(node.nextSibling)) {\n                            if (isUnmatchedEndComment(node.nextSibling)) {\n                                throw Error(\"Found end comment without a matching opening comment, as child of \" + node);\n                            } else {\n                                return null;\n                            }\n                        } else {\n                            return node.nextSibling;\n                        }\n                    },\n\n                    hasBindingValue: isStartComment,\n\n                    virtualNodeBindingValue: function(node) {\n                        var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n                        return regexMatch ? regexMatch[1] : null;\n                    },\n\n                    normaliseVirtualElementDomStructure: function(elementVerified) {\n                        // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n                        // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n                        // that are direct descendants of <ul> into the preceding <li>)\n                        if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                            return;\n\n                        // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n                        // must be intended to appear *after* that child, so move them there.\n                        var childNode = elementVerified.firstChild;\n                        if (childNode) {\n                            do {\n                                if (childNode.nodeType === 1) {\n                                    var unbalancedTags = getUnbalancedChildTags(childNode);\n                                    if (unbalancedTags) {\n                                        // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                                        var nodeToInsertBefore = childNode.nextSibling;\n                                        for (var i = 0; i < unbalancedTags.length; i++) {\n                                            if (nodeToInsertBefore)\n                                                elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                            else\n                                                elementVerified.appendChild(unbalancedTags[i]);\n                                        }\n                                    }\n                                }\n                            } while (childNode = childNode.nextSibling);\n                        }\n                    }\n                };\n            })();\n            ko.exportSymbol('virtualElements', ko.virtualElements);\n            ko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\n            ko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\n            ko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\n            ko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\n            ko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n            (function() {\n                var defaultBindingAttributeName = \"data-bind\";\n\n                ko.bindingProvider = function() {\n                    this.bindingCache = {};\n                };\n\n                ko.utils.extend(ko.bindingProvider.prototype, {\n                    'nodeHasBindings': function(node) {\n                        switch (node.nodeType) {\n                            case 1: // Element\n                                return node.getAttribute(defaultBindingAttributeName) != null\n                                    || ko.components['getComponentNameForNode'](node);\n                            case 8: // Comment node\n                                return ko.virtualElements.hasBindingValue(node);\n                            default: return false;\n                        }\n                    },\n\n                    'getBindings': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n                    },\n\n                    'getBindingAccessors': function(node, bindingContext) {\n                        var bindingsString = this['getBindingsString'](node, bindingContext),\n                            parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n                        return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'getBindingsString': function(node, bindingContext) {\n                        switch (node.nodeType) {\n                            case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                            case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                            default: return null;\n                        }\n                    },\n\n                    // The following function is only used internally by this default provider.\n                    // It's not part of the interface definition for a general binding provider.\n                    'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n                        try {\n                            var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                            return bindingFunction(bindingContext, node);\n                        } catch (ex) {\n                            ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                            throw ex;\n                        }\n                    }\n                });\n\n                ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n                function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n                    var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n                    return cache[cacheKey]\n                        || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n                }\n\n                function createBindingsStringEvaluator(bindingsString, options) {\n                    // Build the source for a function that evaluates \"expression\"\n                    // For each scope variable, add an extra level of \"with\" nesting\n                    // Example result: with(sc1) { with(sc0) { return (expression) } }\n                    var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n                        functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n                    return new Function(\"$context\", \"$element\", functionBody);\n                }\n            })();\n\n            ko.exportSymbol('bindingProvider', ko.bindingProvider);\n            (function () {\n                // Hide or don't minify context properties, see https://github.com/knockout/knockout/issues/2294\n                var contextSubscribable = ko.utils.createSymbolOrString('_subscribable');\n                var contextAncestorBindingInfo = ko.utils.createSymbolOrString('_ancestorBindingInfo');\n                var contextDataDependency = ko.utils.createSymbolOrString('_dataDependency');\n\n                ko.bindingHandlers = {};\n\n                // The following element types will not be recursed into during binding.\n                var bindingDoesNotRecurseIntoElementTypes = {\n                    // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n                    // because it's unexpected and a potential XSS issue.\n                    // Also bindings should not operate on <template> elements since this breaks in Internet Explorer\n                    // and because such elements' contents are always intended to be bound in a different context\n                    // from where they appear in the document.\n                    'script': true,\n                    'textarea': true,\n                    'template': true\n                };\n\n                // Use an overridable method for retrieving binding handlers so that plugins may support dynamically created handlers\n                ko['getBindingHandler'] = function(bindingKey) {\n                    return ko.bindingHandlers[bindingKey];\n                };\n\n                var inheritParentVm = {};\n\n                // The ko.bindingContext constructor is only called directly to create the root context. For child\n                // contexts, use bindingContext.createChildContext or bindingContext.extend.\n                ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback, options) {\n\n                    // The binding context object includes static properties for the current, parent, and root view models.\n                    // If a view model is actually stored in an observable, the corresponding binding context object, and\n                    // any child contexts, must be updated when the view model is changed.\n                    function updateContext() {\n                        // Most of the time, the context will directly get a view model object, but if a function is given,\n                        // we call the function to retrieve the view model. If the function accesses any observables or returns\n                        // an observable, the dependency is tracked, and those observables can later cause the binding\n                        // context to be updated.\n                        var dataItemOrObservable = isFunc ? realDataItemOrAccessor() : realDataItemOrAccessor,\n                            dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n                        if (parentContext) {\n                            // Copy $root and any custom properties from the parent context\n                            ko.utils.extend(self, parentContext);\n\n                            // Copy Symbol properties\n                            if (contextAncestorBindingInfo in parentContext) {\n                                self[contextAncestorBindingInfo] = parentContext[contextAncestorBindingInfo];\n                            }\n                        } else {\n                            self['$parents'] = [];\n                            self['$root'] = dataItem;\n\n                            // Export 'ko' in the binding context so it will be available in bindings and templates\n                            // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                            // See https://github.com/SteveSanderson/knockout/issues/490\n                            self['ko'] = ko;\n                        }\n\n                        self[contextSubscribable] = subscribable;\n\n                        if (shouldInheritData) {\n                            dataItem = self['$data'];\n                        } else {\n                            self['$rawData'] = dataItemOrObservable;\n                            self['$data'] = dataItem;\n                        }\n\n                        if (dataItemAlias)\n                            self[dataItemAlias] = dataItem;\n\n                        // The extendCallback function is provided when creating a child context or extending a context.\n                        // It handles the specific actions needed to finish setting up the binding context. Actions in this\n                        // function could also add dependencies to this binding context.\n                        if (extendCallback)\n                            extendCallback(self, parentContext, dataItem);\n\n                        // When a \"parent\" context is given and we don't already have a dependency on its context, register a dependency on it.\n                        // Thus whenever the parent context is updated, this context will also be updated.\n                        if (parentContext && parentContext[contextSubscribable] && !ko.computedContext.computed().hasAncestorDependency(parentContext[contextSubscribable])) {\n                            parentContext[contextSubscribable]();\n                        }\n\n                        if (dataDependency) {\n                            self[contextDataDependency] = dataDependency;\n                        }\n\n                        return self['$data'];\n                    }\n\n                    var self = this,\n                        shouldInheritData = dataItemOrAccessor === inheritParentVm,\n                        realDataItemOrAccessor = shouldInheritData ? undefined : dataItemOrAccessor,\n                        isFunc = typeof(realDataItemOrAccessor) == \"function\" && !ko.isObservable(realDataItemOrAccessor),\n                        nodes,\n                        subscribable,\n                        dataDependency = options && options['dataDependency'];\n\n                    if (options && options['exportDependencies']) {\n                        // The \"exportDependencies\" option means that the calling code will track any dependencies and re-create\n                        // the binding context when they change.\n                        updateContext();\n                    } else {\n                        subscribable = ko.pureComputed(updateContext);\n                        subscribable.peek();\n\n                        // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n                        // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n                        // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n                        // the context object.\n                        if (subscribable.isActive()) {\n                            // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n                            subscribable['equalityComparer'] = null;\n                        } else {\n                            self[contextSubscribable] = undefined;\n                        }\n                    }\n                }\n\n                // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n                // any observables, the new child context will automatically get a dependency on the parent context.\n                // But this does not mean that the $data value of the child context will also get updated. If the child\n                // view model also depends on the parent view model, you must provide a function that returns the correct\n                // view model on each update.\n                ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback, options) {\n                    if (!options && dataItemAlias && typeof dataItemAlias == \"object\") {\n                        options = dataItemAlias;\n                        dataItemAlias = options['as'];\n                        extendCallback = options['extend'];\n                    }\n\n                    if (dataItemAlias && options && options['noChildContext']) {\n                        var isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor);\n                        return new ko.bindingContext(inheritParentVm, this, null, function (self) {\n                            if (extendCallback)\n                                extendCallback(self);\n                            self[dataItemAlias] = isFunc ? dataItemOrAccessor() : dataItemOrAccessor;\n                        }, options);\n                    }\n\n                    return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function (self, parentContext) {\n                        // Extend the context hierarchy by setting the appropriate pointers\n                        self['$parentContext'] = parentContext;\n                        self['$parent'] = parentContext['$data'];\n                        self['$parents'] = (parentContext['$parents'] || []).slice(0);\n                        self['$parents'].unshift(self['$parent']);\n                        if (extendCallback)\n                            extendCallback(self);\n                    }, options);\n                };\n\n                // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n                // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n                // when an observable view model is updated.\n                ko.bindingContext.prototype['extend'] = function(properties, options) {\n                    return new ko.bindingContext(inheritParentVm, this, null, function(self, parentContext) {\n                        ko.utils.extend(self, typeof(properties) == \"function\" ? properties(self) : properties);\n                    }, options);\n                };\n\n                var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n                function asyncContextDispose(node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey),\n                        asyncContext = bindingInfo && bindingInfo.asyncContext;\n                    if (asyncContext) {\n                        bindingInfo.asyncContext = null;\n                        asyncContext.notifyAncestor();\n                    }\n                }\n                function AsyncCompleteContext(node, bindingInfo, ancestorBindingInfo) {\n                    this.node = node;\n                    this.bindingInfo = bindingInfo;\n                    this.asyncDescendants = [];\n                    this.childrenComplete = false;\n\n                    if (!bindingInfo.asyncContext) {\n                        ko.utils.domNodeDisposal.addDisposeCallback(node, asyncContextDispose);\n                    }\n\n                    if (ancestorBindingInfo && ancestorBindingInfo.asyncContext) {\n                        ancestorBindingInfo.asyncContext.asyncDescendants.push(node);\n                        this.ancestorBindingInfo = ancestorBindingInfo;\n                    }\n                }\n                AsyncCompleteContext.prototype.notifyAncestor = function () {\n                    if (this.ancestorBindingInfo && this.ancestorBindingInfo.asyncContext) {\n                        this.ancestorBindingInfo.asyncContext.descendantComplete(this.node);\n                    }\n                };\n                AsyncCompleteContext.prototype.descendantComplete = function (node) {\n                    ko.utils.arrayRemoveItem(this.asyncDescendants, node);\n                    if (!this.asyncDescendants.length && this.childrenComplete) {\n                        this.completeChildren();\n                    }\n                };\n                AsyncCompleteContext.prototype.completeChildren = function () {\n                    this.childrenComplete = true;\n                    if (this.bindingInfo.asyncContext && !this.asyncDescendants.length) {\n                        this.bindingInfo.asyncContext = null;\n                        ko.utils.domNodeDisposal.removeDisposeCallback(this.node, asyncContextDispose);\n                        ko.bindingEvent.notify(this.node, ko.bindingEvent.descendantsComplete);\n                        this.notifyAncestor();\n                    }\n                };\n\n                ko.bindingEvent = {\n                    childrenComplete: \"childrenComplete\",\n                    descendantsComplete : \"descendantsComplete\",\n\n                    subscribe: function (node, event, callback, context, options) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n                        if (!bindingInfo.eventSubscribable) {\n                            bindingInfo.eventSubscribable = new ko.subscribable;\n                        }\n                        if (options && options['notifyImmediately'] && bindingInfo.notifiedEvents[event]) {\n                            ko.dependencyDetection.ignore(callback, context, [node]);\n                        }\n                        return bindingInfo.eventSubscribable.subscribe(callback, context, event);\n                    },\n\n                    notify: function (node, event) {\n                        var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                        if (bindingInfo) {\n                            bindingInfo.notifiedEvents[event] = true;\n                            if (bindingInfo.eventSubscribable) {\n                                bindingInfo.eventSubscribable['notifySubscribers'](node, event);\n                            }\n                            if (event == ko.bindingEvent.childrenComplete) {\n                                if (bindingInfo.asyncContext) {\n                                    bindingInfo.asyncContext.completeChildren();\n                                } else if (bindingInfo.asyncContext === undefined && bindingInfo.eventSubscribable && bindingInfo.eventSubscribable.hasSubscriptionsForEvent(ko.bindingEvent.descendantsComplete)) {\n                                    // It's currently an error to register a descendantsComplete handler for a node that was never registered as completing asynchronously.\n                                    // That's because without the asyncContext, we don't have a way to know that all descendants have completed.\n                                    throw new Error(\"descendantsComplete event not supported for bindings on this node\");\n                                }\n                            }\n                        }\n                    },\n\n                    startPossiblyAsyncContentBinding: function (node, bindingContext) {\n                        var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                        if (!bindingInfo.asyncContext) {\n                            bindingInfo.asyncContext = new AsyncCompleteContext(node, bindingInfo, bindingContext[contextAncestorBindingInfo]);\n                        }\n\n                        // If the provided context was already extended with this node's binding info, just return the extended context\n                        if (bindingContext[contextAncestorBindingInfo] == bindingInfo) {\n                            return bindingContext;\n                        }\n\n                        return bindingContext['extend'](function (ctx) {\n                            ctx[contextAncestorBindingInfo] = bindingInfo;\n                        });\n                    }\n                };\n\n                // Returns the valueAccessor function for a binding value\n                function makeValueAccessor(value) {\n                    return function() {\n                        return value;\n                    };\n                }\n\n                // Returns the value of a valueAccessor function\n                function evaluateValueAccessor(valueAccessor) {\n                    return valueAccessor();\n                }\n\n                // Given a function that returns bindings, create and return a new object that contains\n                // binding value-accessors functions. Each accessor function calls the original function\n                // so that it always gets the latest value and all dependencies are captured. This is used\n                // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n                function makeAccessorsFromFunction(callback) {\n                    return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n                        return function() {\n                            return callback()[key];\n                        };\n                    });\n                }\n\n                // Given a bindings function or object, create and return a new object that contains\n                // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n                function makeBindingAccessors(bindings, context, node) {\n                    if (typeof bindings === 'function') {\n                        return makeAccessorsFromFunction(bindings.bind(null, context, node));\n                    } else {\n                        return ko.utils.objectMap(bindings, makeValueAccessor);\n                    }\n                }\n\n                // This function is used if the binding provider doesn't include a getBindingAccessors function.\n                // It must be called with 'this' set to the provider instance.\n                function getBindingsAndMakeAccessors(node, context) {\n                    return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n                }\n\n                function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n                    var validator = ko.virtualElements.allowedBindings[bindingName];\n                    if (!validator)\n                        throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n                }\n\n                function applyBindingsToDescendantsInternal(bindingContext, elementOrVirtualElement) {\n                    var nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n\n                    if (nextInQueue) {\n                        var currentChild,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n                        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n                        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n                        // trigger insertion of <template> contents at that point in the document.\n                        if (preprocessNode) {\n                            while (currentChild = nextInQueue) {\n                                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                                preprocessNode.call(provider, currentChild);\n                            }\n                            // Reset nextInQueue for the next loop\n                            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n                        }\n\n                        while (currentChild = nextInQueue) {\n                            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n                            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild);\n                        }\n                    }\n                    ko.bindingEvent.notify(elementOrVirtualElement, ko.bindingEvent.childrenComplete);\n                }\n\n                function applyBindingsToNodeAndDescendantsInternal(bindingContext, nodeVerified) {\n                    var bindingContextForDescendants = bindingContext;\n\n                    var isElement = (nodeVerified.nodeType === 1);\n                    if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n                    // Perf optimisation: Apply bindings only if...\n                    // (1) We need to store the binding info for the node (all element nodes)\n                    // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n                    var shouldApplyBindings = isElement || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);\n                    if (shouldApplyBindings)\n                        bindingContextForDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext)['bindingContextForDescendants'];\n\n                    if (bindingContextForDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n                        applyBindingsToDescendantsInternal(bindingContextForDescendants, nodeVerified);\n                    }\n                }\n\n                function topologicalSortBindings(bindings) {\n                    // Depth-first sort\n                    var result = [],                // The list of key/handler pairs that we will return\n                        bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n                        cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n                    ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n                        if (!bindingsConsidered[bindingKey]) {\n                            var binding = ko['getBindingHandler'](bindingKey);\n                            if (binding) {\n                                // First add dependencies (if any) of the current binding\n                                if (binding['after']) {\n                                    cyclicDependencyStack.push(bindingKey);\n                                    ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                                        if (bindings[bindingDependencyKey]) {\n                                            if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                                throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                            } else {\n                                                pushBinding(bindingDependencyKey);\n                                            }\n                                        }\n                                    });\n                                    cyclicDependencyStack.length--;\n                                }\n                                // Next add the current binding\n                                result.push({ key: bindingKey, handler: binding });\n                            }\n                            bindingsConsidered[bindingKey] = true;\n                        }\n                    });\n\n                    return result;\n                }\n\n                function applyBindingsToNodeInternal(node, sourceBindings, bindingContext) {\n                    var bindingInfo = ko.utils.domData.getOrSet(node, boundElementDomDataKey, {});\n\n                    // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n                    var alreadyBound = bindingInfo.alreadyBound;\n                    if (!sourceBindings) {\n                        if (alreadyBound) {\n                            throw Error(\"You cannot apply bindings multiple times to the same element.\");\n                        }\n                        bindingInfo.alreadyBound = true;\n                    }\n                    if (!alreadyBound) {\n                        bindingInfo.context = bindingContext;\n                    }\n                    if (!bindingInfo.notifiedEvents) {\n                        bindingInfo.notifiedEvents = {};\n                    }\n\n                    // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n                    var bindings;\n                    if (sourceBindings && typeof sourceBindings !== 'function') {\n                        bindings = sourceBindings;\n                    } else {\n                        var provider = ko.bindingProvider['instance'],\n                            getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n                        // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n                        // the binding context is updated or if the binding provider accesses observables.\n                        var bindingsUpdater = ko.dependentObservable(\n                            function() {\n                                bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                                // Register a dependency on the binding context to support observable view models.\n                                if (bindings) {\n                                    if (bindingContext[contextSubscribable]) {\n                                        bindingContext[contextSubscribable]();\n                                    }\n                                    if (bindingContext[contextDataDependency]) {\n                                        bindingContext[contextDataDependency]();\n                                    }\n                                }\n                                return bindings;\n                            },\n                            null, { disposeWhenNodeIsRemoved: node }\n                        );\n\n                        if (!bindings || !bindingsUpdater.isActive())\n                            bindingsUpdater = null;\n                    }\n\n                    var contextToExtend = bindingContext;\n                    var bindingHandlerThatControlsDescendantBindings;\n                    if (bindings) {\n                        // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n                        // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n                        // the latest binding value and registers a dependency on the binding updater.\n                        var getValueAccessor = bindingsUpdater\n                            ? function(bindingKey) {\n                                return function() {\n                                    return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                                };\n                            } : function(bindingKey) {\n                                return bindings[bindingKey];\n                            };\n\n                        // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n                        function allBindings() {\n                            return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n                        }\n                        // The following is the 3.x allBindings API\n                        allBindings['get'] = function(key) {\n                            return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n                        };\n                        allBindings['has'] = function(key) {\n                            return key in bindings;\n                        };\n\n                        if (ko.bindingEvent.childrenComplete in bindings) {\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.childrenComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.childrenComplete]);\n                                if (callback) {\n                                    var nodes = ko.virtualElements.childNodes(node);\n                                    if (nodes.length) {\n                                        callback(nodes, ko.dataFor(nodes[0]));\n                                    }\n                                }\n                            });\n                        }\n\n                        if (ko.bindingEvent.descendantsComplete in bindings) {\n                            contextToExtend = ko.bindingEvent.startPossiblyAsyncContentBinding(node, bindingContext);\n                            ko.bindingEvent.subscribe(node, ko.bindingEvent.descendantsComplete, function () {\n                                var callback = evaluateValueAccessor(bindings[ko.bindingEvent.descendantsComplete]);\n                                if (callback && ko.virtualElements.firstChild(node)) {\n                                    callback(node);\n                                }\n                            });\n                        }\n\n                        // First put the bindings into the right order\n                        var orderedBindings = topologicalSortBindings(bindings);\n\n                        // Go through the sorted bindings, calling init and update for each\n                        ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                            // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                            // so bindingKeyAndHandler.handler will always be nonnull.\n                            var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                                handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                                bindingKey = bindingKeyAndHandler.key;\n\n                            if (node.nodeType === 8) {\n                                validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                            }\n\n                            try {\n                                // Run init, ignoring any dependencies\n                                if (typeof handlerInitFn == \"function\") {\n                                    ko.dependencyDetection.ignore(function() {\n                                        var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n\n                                        // If this binding handler claims to control descendant bindings, make a note of this\n                                        if (initResult && initResult['controlsDescendantBindings']) {\n                                            if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                                throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                            bindingHandlerThatControlsDescendantBindings = bindingKey;\n                                        }\n                                    });\n                                }\n\n                                // Run update in its own computed wrapper\n                                if (typeof handlerUpdateFn == \"function\") {\n                                    ko.dependentObservable(\n                                        function() {\n                                            handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, contextToExtend['$data'], contextToExtend);\n                                        },\n                                        null,\n                                        { disposeWhenNodeIsRemoved: node }\n                                    );\n                                }\n                            } catch (ex) {\n                                ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                                throw ex;\n                            }\n                        });\n                    }\n\n                    var shouldBindDescendants = bindingHandlerThatControlsDescendantBindings === undefined;\n                    return {\n                        'shouldBindDescendants': shouldBindDescendants,\n                        'bindingContextForDescendants': shouldBindDescendants && contextToExtend\n                    };\n                };\n\n                ko.storedBindingContextForNode = function (node) {\n                    var bindingInfo = ko.utils.domData.get(node, boundElementDomDataKey);\n                    return bindingInfo && bindingInfo.context;\n                }\n\n                function getBindingContext(viewModelOrBindingContext, extendContextCallback) {\n                    return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n                        ? viewModelOrBindingContext\n                        : new ko.bindingContext(viewModelOrBindingContext, undefined, undefined, extendContextCallback);\n                }\n\n                ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n                        ko.virtualElements.normaliseVirtualElementDomStructure(node);\n                    return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext));\n                };\n\n                ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n                    var context = getBindingContext(viewModelOrBindingContext);\n                    return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n                };\n\n                ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n                    if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n                        applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode);\n                };\n\n                ko.applyBindings = function (viewModelOrBindingContext, rootNode, extendContextCallback) {\n                    // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n                    if (!jQueryInstance && window['jQuery']) {\n                        jQueryInstance = window['jQuery'];\n                    }\n\n                    if (arguments.length < 2) {\n                        rootNode = document.body;\n                        if (!rootNode) {\n                            throw Error(\"ko.applyBindings: could not find document.body; has the document been loaded?\");\n                        }\n                    } else if (!rootNode || (rootNode.nodeType !== 1 && rootNode.nodeType !== 8)) {\n                        throw Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n                    }\n\n                    applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext, extendContextCallback), rootNode);\n                };\n\n                // Retrieving binding context from arbitrary nodes\n                ko.contextFor = function(node) {\n                    // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n                    if (node && (node.nodeType === 1 || node.nodeType === 8)) {\n                        return ko.storedBindingContextForNode(node);\n                    }\n                    return undefined;\n                };\n                ko.dataFor = function(node) {\n                    var context = ko.contextFor(node);\n                    return context ? context['$data'] : undefined;\n                };\n\n                ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n                ko.exportSymbol('bindingEvent', ko.bindingEvent);\n                ko.exportSymbol('bindingEvent.subscribe', ko.bindingEvent.subscribe);\n                ko.exportSymbol('bindingEvent.startPossiblyAsyncContentBinding', ko.bindingEvent.startPossiblyAsyncContentBinding);\n                ko.exportSymbol('applyBindings', ko.applyBindings);\n                ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n                ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n                ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n                ko.exportSymbol('contextFor', ko.contextFor);\n                ko.exportSymbol('dataFor', ko.dataFor);\n            })();\n            (function(undefined) {\n                var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n                    loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n                ko.components = {\n                    get: function(componentName, callback) {\n                        var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n                        if (cachedDefinition) {\n                            // It's already loaded and cached. Reuse the same definition object.\n                            // Note that for API consistency, even cache hits complete asynchronously by default.\n                            // You can bypass this by putting synchronous:true on your component config.\n                            if (cachedDefinition.isSynchronousComponent) {\n                                ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                                    callback(cachedDefinition.definition);\n                                });\n                            } else {\n                                ko.tasks.schedule(function() { callback(cachedDefinition.definition); });\n                            }\n                        } else {\n                            // Join the loading process that is already underway, or start a new one.\n                            loadComponentAndNotify(componentName, callback);\n                        }\n                    },\n\n                    clearCachedDefinition: function(componentName) {\n                        delete loadedDefinitionsCache[componentName];\n                    },\n\n                    _getFirstResultFromLoaders: getFirstResultFromLoaders\n                };\n\n                function getObjectOwnProperty(obj, propName) {\n                    return Object.prototype.hasOwnProperty.call(obj, propName) ? obj[propName] : undefined;\n                }\n\n                function loadComponentAndNotify(componentName, callback) {\n                    var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n                        completedAsync;\n                    if (!subscribable) {\n                        // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n                        subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n                        subscribable.subscribe(callback);\n\n                        beginLoadingComponent(componentName, function(definition, config) {\n                            var isSynchronousComponent = !!(config && config['synchronous']);\n                            loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                            delete loadingSubscribablesCache[componentName];\n\n                            // For API consistency, all loads complete asynchronously. However we want to avoid\n                            // adding an extra task schedule if it's unnecessary (i.e., the completion is already\n                            // async).\n                            //\n                            // You can bypass the 'always asynchronous' feature by putting the synchronous:true\n                            // flag on your component configuration when you register it.\n                            if (completedAsync || isSynchronousComponent) {\n                                // Note that notifySubscribers ignores any dependencies read within the callback.\n                                // See comment in loaderRegistryBehaviors.js for reasoning\n                                subscribable['notifySubscribers'](definition);\n                            } else {\n                                ko.tasks.schedule(function() {\n                                    subscribable['notifySubscribers'](definition);\n                                });\n                            }\n                        });\n                        completedAsync = true;\n                    } else {\n                        subscribable.subscribe(callback);\n                    }\n                }\n\n                function beginLoadingComponent(componentName, callback) {\n                    getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n                        if (config) {\n                            // We have a config, so now load its definition\n                            getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                                callback(definition, config);\n                            });\n                        } else {\n                            // The component has no config - it's unknown to all the loaders.\n                            // Note that this is not an error (e.g., a module loading error) - that would abort the\n                            // process and this callback would not run. For this callback to run, all loaders must\n                            // have confirmed they don't know about this component.\n                            callback(null, null);\n                        }\n                    });\n                }\n\n                function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n                    // On the first call in the stack, start with the full set of loaders\n                    if (!candidateLoaders) {\n                        candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n                    }\n\n                    // Try the next candidate\n                    var currentCandidateLoader = candidateLoaders.shift();\n                    if (currentCandidateLoader) {\n                        var methodInstance = currentCandidateLoader[methodName];\n                        if (methodInstance) {\n                            var wasAborted = false,\n                                synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                                    if (wasAborted) {\n                                        callback(null);\n                                    } else if (result !== null) {\n                                        // This candidate returned a value. Use it.\n                                        callback(result);\n                                    } else {\n                                        // Try the next candidate\n                                        getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                                    }\n                                }));\n\n                            // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                            // that we'll extend the API to support synchronous return values in the future. It won't be\n                            // a breaking change, because currently no loader is allowed to return anything except undefined.\n                            if (synchronousReturnValue !== undefined) {\n                                wasAborted = true;\n\n                                // Method to suppress exceptions will remain undocumented. This is only to keep\n                                // KO's specs running tidily, since we can observe the loading got aborted without\n                                // having exceptions cluttering up the console too.\n                                if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                                    throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                                }\n                            }\n                        } else {\n                            // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    } else {\n                        // No candidates returned a value\n                        callback(null);\n                    }\n                }\n\n                // Reference the loaders via string name so it's possible for developers\n                // to replace the whole array by assigning to ko.components.loaders\n                ko.components['loaders'] = [];\n\n                ko.exportSymbol('components', ko.components);\n                ko.exportSymbol('components.get', ko.components.get);\n                ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n            })();\n            (function(undefined) {\n\n                // The default loader is responsible for two things:\n                // 1. Maintaining the default in-memory registry of component configuration objects\n                //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n                // 2. Answering requests for components by fetching configuration objects\n                //    from that default in-memory registry and resolving them into standard\n                //    component definition objects (of the form { createViewModel: ..., template: ... })\n                // Custom loaders may override either of these facilities, i.e.,\n                // 1. To supply configuration objects from some other source (e.g., conventions)\n                // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n                var defaultConfigRegistry = {};\n\n                ko.components.register = function(componentName, config) {\n                    if (!config) {\n                        throw new Error('Invalid configuration for ' + componentName);\n                    }\n\n                    if (ko.components.isRegistered(componentName)) {\n                        throw new Error('Component ' + componentName + ' is already registered');\n                    }\n\n                    defaultConfigRegistry[componentName] = config;\n                };\n\n                ko.components.isRegistered = function(componentName) {\n                    return Object.prototype.hasOwnProperty.call(defaultConfigRegistry, componentName);\n                };\n\n                ko.components.unregister = function(componentName) {\n                    delete defaultConfigRegistry[componentName];\n                    ko.components.clearCachedDefinition(componentName);\n                };\n\n                ko.components.defaultLoader = {\n                    'getConfig': function(componentName, callback) {\n                        var result = ko.components.isRegistered(componentName)\n                            ? defaultConfigRegistry[componentName]\n                            : null;\n                        callback(result);\n                    },\n\n                    'loadComponent': function(componentName, config, callback) {\n                        var errorCallback = makeErrorCallback(componentName);\n                        possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                            resolveConfig(componentName, errorCallback, loadedConfig, callback);\n                        });\n                    },\n\n                    'loadTemplate': function(componentName, templateConfig, callback) {\n                        resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n                    },\n\n                    'loadViewModel': function(componentName, viewModelConfig, callback) {\n                        resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n                    }\n                };\n\n                var createViewModelKey = 'createViewModel';\n\n                // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n                // into the standard component definition format:\n                //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n                // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n                // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n                // so this is implemented manually below.\n                function resolveConfig(componentName, errorCallback, config, callback) {\n                    var result = {},\n                        makeCallBackWhenZero = 2,\n                        tryIssueCallback = function() {\n                            if (--makeCallBackWhenZero === 0) {\n                                callback(result);\n                            }\n                        },\n                        templateConfig = config['template'],\n                        viewModelConfig = config['viewModel'];\n\n                    if (templateConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                                result['template'] = resolvedTemplate;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n\n                    if (viewModelConfig) {\n                        possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                            ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                                result[createViewModelKey] = resolvedViewModel;\n                                tryIssueCallback();\n                            });\n                        });\n                    } else {\n                        tryIssueCallback();\n                    }\n                }\n\n                function resolveTemplate(errorCallback, templateConfig, callback) {\n                    if (typeof templateConfig === 'string') {\n                        // Markup - parse it\n                        callback(ko.utils.parseHtmlFragment(templateConfig));\n                    } else if (templateConfig instanceof Array) {\n                        // Assume already an array of DOM nodes - pass through unchanged\n                        callback(templateConfig);\n                    } else if (isDocumentFragment(templateConfig)) {\n                        // Document fragment - use its child nodes\n                        callback(ko.utils.makeArray(templateConfig.childNodes));\n                    } else if (templateConfig['element']) {\n                        var element = templateConfig['element'];\n                        if (isDomElement(element)) {\n                            // Element instance - copy its child nodes\n                            callback(cloneNodesFromTemplateSourceElement(element));\n                        } else if (typeof element === 'string') {\n                            // Element ID - find it, then copy its child nodes\n                            var elemInstance = document.getElementById(element);\n                            if (elemInstance) {\n                                callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                            } else {\n                                errorCallback('Cannot find element with ID ' + element);\n                            }\n                        } else {\n                            errorCallback('Unknown element type: ' + element);\n                        }\n                    } else {\n                        errorCallback('Unknown template value: ' + templateConfig);\n                    }\n                }\n\n                function resolveViewModel(errorCallback, viewModelConfig, callback) {\n                    if (typeof viewModelConfig === 'function') {\n                        // Constructor - convert to standard factory function format\n                        // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n                        // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n                        // be used in factory functions, not viewmodel constructors.\n                        callback(function (params /*, componentInfo */) {\n                            return new viewModelConfig(params);\n                        });\n                    } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n                        // Already a factory function - use it as-is\n                        callback(viewModelConfig[createViewModelKey]);\n                    } else if ('instance' in viewModelConfig) {\n                        // Fixed object instance - promote to createViewModel format for API consistency\n                        var fixedInstance = viewModelConfig['instance'];\n                        callback(function (params, componentInfo) {\n                            return fixedInstance;\n                        });\n                    } else if ('viewModel' in viewModelConfig) {\n                        // Resolved AMD module whose value is of the form { viewModel: ... }\n                        resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n                    } else {\n                        errorCallback('Unknown viewModel value: ' + viewModelConfig);\n                    }\n                }\n\n                function cloneNodesFromTemplateSourceElement(elemInstance) {\n                    switch (ko.utils.tagNameLower(elemInstance)) {\n                        case 'script':\n                            return ko.utils.parseHtmlFragment(elemInstance.text);\n                        case 'textarea':\n                            return ko.utils.parseHtmlFragment(elemInstance.value);\n                        case 'template':\n                            // For browsers with proper <template> element support (i.e., where the .content property\n                            // gives a document fragment), use that document fragment.\n                            if (isDocumentFragment(elemInstance.content)) {\n                                return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                            }\n                    }\n\n                    // Regular elements such as <div>, and <template> elements on old browsers that don't really\n                    // understand <template> and just treat it as a regular container\n                    return ko.utils.cloneNodes(elemInstance.childNodes);\n                }\n\n                function isDomElement(obj) {\n                    if (window['HTMLElement']) {\n                        return obj instanceof HTMLElement;\n                    } else {\n                        return obj && obj.tagName && obj.nodeType === 1;\n                    }\n                }\n\n                function isDocumentFragment(obj) {\n                    if (window['DocumentFragment']) {\n                        return obj instanceof DocumentFragment;\n                    } else {\n                        return obj && obj.nodeType === 11;\n                    }\n                }\n\n                function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n                    if (typeof config['require'] === 'string') {\n                        // The config is the value of an AMD module\n                        if (amdRequire || window['require']) {\n                            (amdRequire || window['require'])([config['require']], function (module) {\n                                if (module && typeof module === 'object' && module.__esModule && module.default) {\n                                    module = module.default;\n                                }\n                                callback(module);\n                            });\n                        } else {\n                            errorCallback('Uses require, but no AMD loader is present');\n                        }\n                    } else {\n                        callback(config);\n                    }\n                }\n\n                function makeErrorCallback(componentName) {\n                    return function (message) {\n                        throw new Error('Component \\'' + componentName + '\\': ' + message);\n                    };\n                }\n\n                ko.exportSymbol('components.register', ko.components.register);\n                ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n                ko.exportSymbol('components.unregister', ko.components.unregister);\n\n                // Expose the default loader so that developers can directly ask it for configuration\n                // or to resolve configuration\n                ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n                // By default, the default loader is the only registered component loader\n                ko.components['loaders'].push(ko.components.defaultLoader);\n\n                // Privately expose the underlying config registry for use in old-IE shim\n                ko.components._allRegisteredComponents = defaultConfigRegistry;\n            })();\n            (function (undefined) {\n                // Overridable API for determining which component name applies to a given node. By overriding this,\n                // you can for example map specific tagNames to components that are not preregistered.\n                ko.components['getComponentNameForNode'] = function(node) {\n                    var tagNameLower = ko.utils.tagNameLower(node);\n                    if (ko.components.isRegistered(tagNameLower)) {\n                        // Try to determine that this node can be considered a *custom* element; see https://github.com/knockout/knockout/issues/1603\n                        if (tagNameLower.indexOf('-') != -1 || ('' + node) == \"[object HTMLUnknownElement]\" || (ko.utils.ieVersion <= 8 && node.tagName === tagNameLower)) {\n                            return tagNameLower;\n                        }\n                    }\n                };\n\n                ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n                    // Determine if it's really a custom element matching a component\n                    if (node.nodeType === 1) {\n                        var componentName = ko.components['getComponentNameForNode'](node);\n                        if (componentName) {\n                            // It does represent a component, so add a component binding for it\n                            allBindings = allBindings || {};\n\n                            if (allBindings['component']) {\n                                // Avoid silently overwriting some other 'component' binding that may already be on the element\n                                throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                            }\n\n                            var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                            allBindings['component'] = valueAccessors\n                                ? function() { return componentBindingValue; }\n                                : componentBindingValue;\n                        }\n                    }\n\n                    return allBindings;\n                }\n\n                var nativeBindingProviderInstance = new ko.bindingProvider();\n\n                function getComponentParamsFromCustomElement(elem, bindingContext) {\n                    var paramsAttribute = elem.getAttribute('params');\n\n                    if (paramsAttribute) {\n                        var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                            rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                                return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                            }),\n                            result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                                var paramValue = paramValueComputed.peek();\n                                // Does the evaluation of the parameter value unwrap any observables?\n                                if (!paramValueComputed.isActive()) {\n                                    // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                                    // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                                    return paramValue;\n                                } else {\n                                    // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                                    // level of observability, and any inner (resulting model value) level of observability.\n                                    // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                                    // writable observable, the computed will also be writable and pass the value on to the observable.\n                                    return ko.computed({\n                                        'read': function() {\n                                            return ko.utils.unwrapObservable(paramValueComputed());\n                                        },\n                                        'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                            paramValueComputed()(value);\n                                        },\n                                        disposeWhenNodeIsRemoved: elem\n                                    });\n                                }\n                            });\n\n                        // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n                        // This is in case the developer wants to react to outer (binding) observability separately from inner\n                        // (model value) observability, or in case the model value observable has subobservables.\n                        if (!Object.prototype.hasOwnProperty.call(result, '$raw')) {\n                            result['$raw'] = rawParamComputedValues;\n                        }\n\n                        return result;\n                    } else {\n                        // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n                        // any empty one. Otherwise component viewmodels need special code to check whether or not\n                        // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n                        return { '$raw': {} };\n                    }\n                }\n\n                // --------------------------------------------------------------------------------\n                // Compatibility code for older (pre-HTML5) IE browsers\n\n                if (ko.utils.ieVersion < 9) {\n                    // Whenever you preregister a component, enable it as a custom element in the current document\n                    ko.components['register'] = (function(originalFunction) {\n                        return function(componentName) {\n                            document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                            return originalFunction.apply(this, arguments);\n                        }\n                    })(ko.components['register']);\n\n                    // Whenever you create a document fragment, enable all preregistered component names as custom elements\n                    // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n                    document.createDocumentFragment = (function(originalFunction) {\n                        return function() {\n                            var newDocFrag = originalFunction(),\n                                allComponents = ko.components._allRegisteredComponents;\n                            for (var componentName in allComponents) {\n                                if (Object.prototype.hasOwnProperty.call(allComponents, componentName)) {\n                                    newDocFrag.createElement(componentName);\n                                }\n                            }\n                            return newDocFrag;\n                        };\n                    })(document.createDocumentFragment);\n                }\n            })();(function(undefined) {\n                var componentLoadingOperationUniqueId = 0;\n\n                ko.bindingHandlers['component'] = {\n                    'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n                        var currentViewModel,\n                            currentLoadingOperationId,\n                            afterRenderSub,\n                            disposeAssociatedComponentViewModel = function () {\n                                var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                                if (typeof currentViewModelDispose === 'function') {\n                                    currentViewModelDispose.call(currentViewModel);\n                                }\n                                if (afterRenderSub) {\n                                    afterRenderSub.dispose();\n                                }\n                                afterRenderSub = null;\n                                currentViewModel = null;\n                                // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                                currentLoadingOperationId = null;\n                            },\n                            originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n                        ko.virtualElements.emptyNode(element);\n                        ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n                        ko.computed(function () {\n                            var value = ko.utils.unwrapObservable(valueAccessor()),\n                                componentName, componentParams;\n\n                            if (typeof value === 'string') {\n                                componentName = value;\n                            } else {\n                                componentName = ko.utils.unwrapObservable(value['name']);\n                                componentParams = ko.utils.unwrapObservable(value['params']);\n                            }\n\n                            if (!componentName) {\n                                throw new Error('No component name specified');\n                            }\n\n                            var asyncContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n\n                            var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                            ko.components.get(componentName, function(componentDefinition) {\n                                // If this is not the current load operation for this element, ignore it.\n                                if (currentLoadingOperationId !== loadingOperationId) {\n                                    return;\n                                }\n\n                                // Clean up previous state\n                                disposeAssociatedComponentViewModel();\n\n                                // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                                if (!componentDefinition) {\n                                    throw new Error('Unknown component \\'' + componentName + '\\'');\n                                }\n                                cloneTemplateIntoElement(componentName, componentDefinition, element);\n\n                                var componentInfo = {\n                                    'element': element,\n                                    'templateNodes': originalChildNodes\n                                };\n\n                                var componentViewModel = createViewModel(componentDefinition, componentParams, componentInfo),\n                                    childBindingContext = asyncContext['createChildContext'](componentViewModel, {\n                                        'extend': function(ctx) {\n                                            ctx['$component'] = componentViewModel;\n                                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                                        }\n                                    });\n\n                                if (componentViewModel && componentViewModel['koDescendantsComplete']) {\n                                    afterRenderSub = ko.bindingEvent.subscribe(element, ko.bindingEvent.descendantsComplete, componentViewModel['koDescendantsComplete'], componentViewModel);\n                                }\n\n                                currentViewModel = componentViewModel;\n                                ko.applyBindingsToDescendants(childBindingContext, element);\n                            });\n                        }, null, { disposeWhenNodeIsRemoved: element });\n\n                        return { 'controlsDescendantBindings': true };\n                    }\n                };\n\n                ko.virtualElements.allowedBindings['component'] = true;\n\n                function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n                    var template = componentDefinition['template'];\n                    if (!template) {\n                        throw new Error('Component \\'' + componentName + '\\' has no template');\n                    }\n\n                    var clonedNodesArray = ko.utils.cloneNodes(template);\n                    ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n                }\n\n                function createViewModel(componentDefinition, componentParams, componentInfo) {\n                    var componentViewModelFactory = componentDefinition['createViewModel'];\n                    return componentViewModelFactory\n                        ? componentViewModelFactory.call(componentDefinition, componentParams, componentInfo)\n                        : componentParams; // Template-only component\n                }\n\n            })();\n            var attrHtmlToJavaScriptMap = { 'class': 'className', 'for': 'htmlFor' };\n            ko.bindingHandlers['attr'] = {\n                'update': function(element, valueAccessor, allBindings) {\n                    var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n                    ko.utils.objectForEach(value, function(attrName, attrValue) {\n                        attrValue = ko.utils.unwrapObservable(attrValue);\n\n                        // Find the namespace of this attribute, if any.\n                        var prefixLen = attrName.indexOf(':');\n                        var namespace = \"lookupNamespaceURI\" in element && prefixLen > 0 && element.lookupNamespaceURI(attrName.substr(0, prefixLen));\n\n                        // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n                        // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n                        // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n                        var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n                        if (toRemove) {\n                            namespace ? element.removeAttributeNS(namespace, attrName) : element.removeAttribute(attrName);\n                        } else {\n                            attrValue = attrValue.toString();\n                        }\n\n                        // In IE <= 7 and IE8 Quirks Mode, you have to use the JavaScript property name instead of the\n                        // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n                        // but instead of figuring out the mode, we'll just set the attribute through the JavaScript\n                        // property for IE <= 8.\n                        if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavaScriptMap) {\n                            attrName = attrHtmlToJavaScriptMap[attrName];\n                            if (toRemove)\n                                element.removeAttribute(attrName);\n                            else\n                                element[attrName] = attrValue;\n                        } else if (!toRemove) {\n                            namespace ? element.setAttributeNS(namespace, attrName, attrValue) : element.setAttribute(attrName, attrValue);\n                        }\n\n                        // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n                        // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n                        // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n                        // entirely, and there's no strong reason to allow for such casing in HTML.\n                        if (attrName === \"name\") {\n                            ko.utils.setElementName(element, toRemove ? \"\" : attrValue);\n                        }\n                    });\n                }\n            };\n            (function() {\n\n                ko.bindingHandlers['checked'] = {\n                    'after': ['value', 'attr'],\n                    'init': function (element, valueAccessor, allBindings) {\n                        var checkedValue = ko.pureComputed(function() {\n                            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n                            if (allBindings['has']('checkedValue')) {\n                                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                            } else if (useElementValue) {\n                                if (allBindings['has']('value')) {\n                                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                                } else {\n                                    return element.value;\n                                }\n                            }\n                        });\n\n                        function updateModel() {\n                            // This updates the model value from the view value.\n                            // It runs in response to DOM events (click) and changes in checkedValue.\n                            var isChecked = element.checked,\n                                elemValue = checkedValue();\n\n                            // When we're first setting up this computed, don't change any model state.\n                            if (ko.computedContext.isInitial()) {\n                                return;\n                            }\n\n                            // We can ignore unchecked radio buttons, because some other radio\n                            // button will be checked, and that one can take care of updating state.\n                            // Also ignore value changes to an already unchecked checkbox.\n                            if (!isChecked && (isRadio || ko.computedContext.getDependenciesCount())) {\n                                return;\n                            }\n\n                            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n                            if (valueIsArray) {\n                                var writableValue = rawValueIsNonArrayObservable ? modelValue.peek() : modelValue,\n                                    saveOldValue = oldElemValue;\n                                oldElemValue = elemValue;\n\n                                if (saveOldValue !== elemValue) {\n                                    // When we're responding to the checkedValue changing, and the element is\n                                    // currently checked, replace the old elem value with the new elem value\n                                    // in the model array.\n                                    if (isChecked) {\n                                        ko.utils.addOrRemoveItem(writableValue, elemValue, true);\n                                        ko.utils.addOrRemoveItem(writableValue, saveOldValue, false);\n                                    }\n                                } else {\n                                    // When we're responding to the user having checked/unchecked a checkbox,\n                                    // add/remove the element value to the model array.\n                                    ko.utils.addOrRemoveItem(writableValue, elemValue, isChecked);\n                                }\n\n                                if (rawValueIsNonArrayObservable && ko.isWriteableObservable(modelValue)) {\n                                    modelValue(writableValue);\n                                }\n                            } else {\n                                if (isCheckbox) {\n                                    if (elemValue === undefined) {\n                                        elemValue = isChecked;\n                                    } else if (!isChecked) {\n                                        elemValue = undefined;\n                                    }\n                                }\n                                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                            }\n                        };\n\n                        function updateView() {\n                            // This updates the view value from the model value.\n                            // It runs in response to changes in the bound (checked) value.\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor()),\n                                elemValue = checkedValue();\n\n                            if (valueIsArray) {\n                                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                                element.checked = ko.utils.arrayIndexOf(modelValue, elemValue) >= 0;\n                                oldElemValue = elemValue;\n                            } else if (isCheckbox && elemValue === undefined) {\n                                // When a checkbox is bound to any other value (not an array) and \"checkedValue\" is not defined,\n                                // being checked represents the value being trueish\n                                element.checked = !!modelValue;\n                            } else {\n                                // Otherwise, being checked means that the checkbox or radio button's value corresponds to the model value\n                                element.checked = (checkedValue() === modelValue);\n                            }\n                        };\n\n                        var isCheckbox = element.type == \"checkbox\",\n                            isRadio = element.type == \"radio\";\n\n                        // Only bind to check boxes and radio buttons\n                        if (!isCheckbox && !isRadio) {\n                            return;\n                        }\n\n                        var rawValue = valueAccessor(),\n                            valueIsArray = isCheckbox && (ko.utils.unwrapObservable(rawValue) instanceof Array),\n                            rawValueIsNonArrayObservable = !(valueIsArray && rawValue.push && rawValue.splice),\n                            useElementValue = isRadio || valueIsArray,\n                            oldElemValue = valueIsArray ? checkedValue() : undefined;\n\n                        // IE 6 won't allow radio buttons to be selected unless they have a name\n                        if (isRadio && !element.name)\n                            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n                        // Set up two computeds to update the binding:\n\n                        // The first responds to changes in the checkedValue value and to element clicks\n                        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n                        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n                        // The second responds to changes in the model value (the one associated with the checked binding)\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n\n                        rawValue = undefined;\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['checked'] = true;\n\n                ko.bindingHandlers['checkedValue'] = {\n                    'update': function (element, valueAccessor) {\n                        element.value = ko.utils.unwrapObservable(valueAccessor());\n                    }\n                };\n\n            })();var classesWrittenByBindingKey = '__ko__cssValue';\n            ko.bindingHandlers['class'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.stringTrim(ko.utils.unwrapObservable(valueAccessor()));\n                    ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n                    element[classesWrittenByBindingKey] = value;\n                    ko.utils.toggleDomNodeCssClass(element, value, true);\n                }\n            };\n\n            ko.bindingHandlers['css'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value !== null && typeof value == \"object\") {\n                        ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                            shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                            ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n                        });\n                    } else {\n                        ko.bindingHandlers['class']['update'](element, valueAccessor);\n                    }\n                }\n            };\n            ko.bindingHandlers['enable'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    if (value && element.disabled)\n                        element.removeAttribute(\"disabled\");\n                    else if ((!value) && (!element.disabled))\n                        element.disabled = true;\n                }\n            };\n\n            ko.bindingHandlers['disable'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\n            function makeEventHandlerShortcut(eventName) {\n                ko.bindingHandlers[eventName] = {\n                    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var newValueAccessor = function () {\n                            var result = {};\n                            result[eventName] = valueAccessor();\n                            return result;\n                        };\n                        return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n                    }\n                }\n            }\n\n            ko.bindingHandlers['event'] = {\n                'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var eventsToHandle = valueAccessor() || {};\n                    ko.utils.objectForEach(eventsToHandle, function(eventName) {\n                        if (typeof eventName == \"string\") {\n                            ko.utils.registerEventHandler(element, eventName, function (event) {\n                                var handlerReturnValue;\n                                var handlerFunction = valueAccessor()[eventName];\n                                if (!handlerFunction)\n                                    return;\n\n                                try {\n                                    // Take all the event args, and prefix with the viewmodel\n                                    var argsForHandler = ko.utils.makeArray(arguments);\n                                    viewModel = bindingContext['$data'];\n                                    argsForHandler.unshift(viewModel);\n                                    handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                                } finally {\n                                    if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                        if (event.preventDefault)\n                                            event.preventDefault();\n                                        else\n                                            event.returnValue = false;\n                                    }\n                                }\n\n                                var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                                if (!bubble) {\n                                    event.cancelBubble = true;\n                                    if (event.stopPropagation)\n                                        event.stopPropagation();\n                                }\n                            });\n                        }\n                    });\n                }\n            };\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\n            ko.bindingHandlers['foreach'] = {\n                makeTemplateValueAccessor: function(valueAccessor) {\n                    return function() {\n                        var modelValue = valueAccessor(),\n                            unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n                        // If unwrappedValue is the array, pass in the wrapped value on its own\n                        // The value will be unwrapped and tracked within the template binding\n                        // (See https://github.com/SteveSanderson/knockout/issues/523)\n                        if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                            return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n                        // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n                        ko.utils.unwrapObservable(modelValue);\n                        return {\n                            'foreach': unwrappedValue['data'],\n                            'as': unwrappedValue['as'],\n                            'noChildContext': unwrappedValue['noChildContext'],\n                            'includeDestroyed': unwrappedValue['includeDestroyed'],\n                            'afterAdd': unwrappedValue['afterAdd'],\n                            'beforeRemove': unwrappedValue['beforeRemove'],\n                            'afterRender': unwrappedValue['afterRender'],\n                            'beforeMove': unwrappedValue['beforeMove'],\n                            'afterMove': unwrappedValue['afterMove'],\n                            'templateEngine': ko.nativeTemplateEngine.instance\n                        };\n                    };\n                },\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n                },\n                'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n                }\n            };\n            ko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\n            ko.virtualElements.allowedBindings['foreach'] = true;\n            var hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\n            var hasfocusLastValue = '__ko_hasfocusLastValue';\n            ko.bindingHandlers['hasfocus'] = {\n                'init': function(element, valueAccessor, allBindings) {\n                    var handleElementFocusChange = function(isFocused) {\n                        // Where possible, ignore which event was raised and determine focus state using activeElement,\n                        // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n                        // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n                        // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n                        // from calling 'blur()' on the element when it loses focus.\n                        // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n                        element[hasfocusUpdatingProperty] = true;\n                        var ownerDoc = element.ownerDocument;\n                        if (\"activeElement\" in ownerDoc) {\n                            var active;\n                            try {\n                                active = ownerDoc.activeElement;\n                            } catch(e) {\n                                // IE9 throws if you access activeElement during page load (see issue #703)\n                                active = ownerDoc.body;\n                            }\n                            isFocused = (active === element);\n                        }\n                        var modelValue = valueAccessor();\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n                        //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n                        element[hasfocusLastValue] = isFocused;\n                        element[hasfocusUpdatingProperty] = false;\n                    };\n                    var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n                    var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n                    ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n                    ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n                    ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n                    ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n\n                    // Assume element is not focused (prevents \"blur\" being called initially)\n                    element[hasfocusLastValue] = false;\n                },\n                'update': function(element, valueAccessor) {\n                    var value = !!ko.utils.unwrapObservable(valueAccessor());\n\n                    if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n                        value ? element.focus() : element.blur();\n\n                        // In IE, the blur method doesn't always cause the element to lose focus (for example, if the window is not in focus).\n                        // Setting focus to the body element does seem to be reliable in IE, but should only be used if we know that the current\n                        // element was focused already.\n                        if (!value && element[hasfocusLastValue]) {\n                            element.ownerDocument.body.focus();\n                        }\n\n                        // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]);\n                    }\n                }\n            };\n            ko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\n            ko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\n            ko.expressionRewriting.twoWayBindings['hasFocus'] = 'hasfocus';\n            ko.bindingHandlers['html'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    // setHtml will unwrap the value if needed\n                    ko.utils.setHtml(element, valueAccessor());\n                }\n            };\n            (function () {\n\n// Makes a binding like with or if\n                function makeWithIfBinding(bindingKey, isWith, isNot) {\n                    ko.bindingHandlers[bindingKey] = {\n                        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                            var didDisplayOnLastUpdate, savedNodes, contextOptions = {}, completeOnRender, needAsyncContext, renderOnEveryChange;\n\n                            if (isWith) {\n                                var as = allBindings.get('as'), noChildContext = allBindings.get('noChildContext');\n                                renderOnEveryChange = !(as && noChildContext);\n                                contextOptions = { 'as': as, 'noChildContext': noChildContext, 'exportDependencies': renderOnEveryChange };\n                            }\n\n                            completeOnRender = allBindings.get(\"completeOn\") == \"render\";\n                            needAsyncContext = completeOnRender || allBindings['has'](ko.bindingEvent.descendantsComplete);\n\n                            ko.computed(function() {\n                                var value = ko.utils.unwrapObservable(valueAccessor()),\n                                    shouldDisplay = !isNot !== !value, // equivalent to isNot ? !value : !!value,\n                                    isInitial = !savedNodes,\n                                    childContext;\n\n                                if (!renderOnEveryChange && shouldDisplay === didDisplayOnLastUpdate) {\n                                    return;\n                                }\n\n                                if (needAsyncContext) {\n                                    bindingContext = ko.bindingEvent.startPossiblyAsyncContentBinding(element, bindingContext);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isWith || renderOnEveryChange) {\n                                        contextOptions['dataDependency'] = ko.computedContext.computed();\n                                    }\n\n                                    if (isWith) {\n                                        childContext = bindingContext['createChildContext'](typeof value == \"function\" ? value : valueAccessor, contextOptions);\n                                    } else if (ko.computedContext.getDependenciesCount()) {\n                                        childContext = bindingContext['extend'](null, contextOptions);\n                                    } else {\n                                        childContext = bindingContext;\n                                    }\n                                }\n\n                                // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                                if (isInitial && ko.computedContext.getDependenciesCount()) {\n                                    savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                                }\n\n                                if (shouldDisplay) {\n                                    if (!isInitial) {\n                                        ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                                    }\n\n                                    ko.applyBindingsToDescendants(childContext, element);\n                                } else {\n                                    ko.virtualElements.emptyNode(element);\n\n                                    if (!completeOnRender) {\n                                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                                    }\n                                }\n\n                                didDisplayOnLastUpdate = shouldDisplay;\n\n                            }, null, { disposeWhenNodeIsRemoved: element });\n\n                            return { 'controlsDescendantBindings': true };\n                        }\n                    };\n                    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n                    ko.virtualElements.allowedBindings[bindingKey] = true;\n                }\n\n// Construct the actual binding handlers\n                makeWithIfBinding('if');\n                makeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\n                makeWithIfBinding('with', true /* isWith */);\n\n            })();ko.bindingHandlers['let'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    // Make a modified binding context, with extra properties, and apply it to descendant elements\n                    var innerContext = bindingContext['extend'](valueAccessor);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['let'] = true;\n            var captionPlaceholder = {};\n            ko.bindingHandlers['options'] = {\n                'init': function(element) {\n                    if (ko.utils.tagNameLower(element) !== \"select\")\n                        throw new Error(\"options binding applies only to SELECT elements\");\n\n                    // Remove all existing <option>s.\n                    while (element.length > 0) {\n                        element.remove(0);\n                    }\n\n                    // Ensures that the binding processor doesn't try to bind the options\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor, allBindings) {\n                    function selectedOptions() {\n                        return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n                    }\n\n                    var selectWasPreviouslyEmpty = element.length == 0,\n                        multiple = element.multiple,\n                        previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n                        unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                        valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n                        includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                        arrayToDomNodeChildrenOptions = {},\n                        captionValue,\n                        filteredArray,\n                        previousSelectedValues = [];\n\n                    if (!valueAllowUnset) {\n                        if (multiple) {\n                            previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n                        } else if (element.selectedIndex >= 0) {\n                            previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n                        }\n                    }\n\n                    if (unwrappedArray) {\n                        if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                            unwrappedArray = [unwrappedArray];\n\n                        // Filter out any entries marked as destroyed\n                        filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                            return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                        });\n\n                        // If caption is included, add it to the array\n                        if (allBindings['has']('optionsCaption')) {\n                            captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                            // If caption value is null or undefined, don't show a caption\n                            if (captionValue !== null && captionValue !== undefined) {\n                                filteredArray.unshift(captionPlaceholder);\n                            }\n                        }\n                    } else {\n                        // If a falsy value is provided (e.g. null), we'll simply empty the select element\n                    }\n\n                    function applyToObject(object, predicate, defaultValue) {\n                        var predicateType = typeof predicate;\n                        if (predicateType == \"function\")    // Given a function; run it against the data value\n                            return predicate(object);\n                        else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                            return object[predicate];\n                        else                                // Given no optionsText arg; use the data value itself\n                            return defaultValue;\n                    }\n\n                    // The following functions can run at two different times:\n                    // The first is when the whole array is being updated directly from this binding handler.\n                    // The second is when an observable value for a specific array entry is updated.\n                    // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n                    var itemUpdate = false;\n                    function optionForArrayItem(arrayEntry, index, oldOptions) {\n                        if (oldOptions.length) {\n                            previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                            itemUpdate = true;\n                        }\n                        var option = element.ownerDocument.createElement(\"option\");\n                        if (arrayEntry === captionPlaceholder) {\n                            ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                            ko.selectExtensions.writeValue(option, undefined);\n                        } else {\n                            // Apply a value to the option element\n                            var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                            ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                            // Apply some text to the option element\n                            var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                            ko.utils.setTextContent(option, optionText);\n                        }\n                        return [option];\n                    }\n\n                    // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n                    // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n                    arrayToDomNodeChildrenOptions['beforeRemove'] =\n                        function (option) {\n                            element.removeChild(option);\n                        };\n\n                    function setSelectionCallback(arrayEntry, newOptions) {\n                        if (itemUpdate && valueAllowUnset) {\n                            // The model value is authoritative, so make sure its value is the one selected\n                            ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                        } else if (previousSelectedValues.length) {\n                            // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                            // That's why we first added them without selection. Now it's time to set the selection.\n                            var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                            ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                            // If this option was changed from being selected during a single-item update, notify the change\n                            if (itemUpdate && !isSelected) {\n                                ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                            }\n                        }\n                    }\n\n                    var callback = setSelectionCallback;\n                    if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n                        callback = function(arrayEntry, newOptions) {\n                            setSelectionCallback(arrayEntry, newOptions);\n                            ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n                        }\n                    }\n\n                    ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n                    if (!valueAllowUnset) {\n                        // Determine if the selection has changed as a result of updating the options list\n                        var selectionChanged;\n                        if (multiple) {\n                            // For a multiple-select box, compare the new selection count to the previous one\n                            // But if nothing was selected before, the selection can't have changed\n                            selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                        } else {\n                            // For a single-select box, compare the current value to the previous value\n                            // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                            selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                                ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                                : (previousSelectedValues.length || element.selectedIndex >= 0);\n                        }\n\n                        // Ensure consistency between model value and selected option.\n                        // If the dropdown was changed so that selection is no longer the same,\n                        // notify the value or selectedOptions binding.\n                        if (selectionChanged) {\n                            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                        }\n                    }\n\n                    if (valueAllowUnset || ko.computedContext.isInitial()) {\n                        ko.bindingEvent.notify(element, ko.bindingEvent.childrenComplete);\n                    }\n\n                    // Workaround for IE bug\n                    ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n                    if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n                        element.scrollTop = previousScrollTop;\n                }\n            };\n            ko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\n            ko.bindingHandlers['selectedOptions'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    function updateFromView() {\n                        var value = valueAccessor(), valueToWrite = [];\n                        ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                            if (node.selected)\n                                valueToWrite.push(ko.selectExtensions.readValue(node));\n                        });\n                        ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n                    }\n\n                    function updateFromModel() {\n                        var newValue = ko.utils.unwrapObservable(valueAccessor()),\n                            previousScrollTop = element.scrollTop;\n\n                        if (newValue && typeof newValue.length == \"number\") {\n                            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                                if (node.selected != isSelected) {      // This check prevents flashing of the select element in IE\n                                    ko.utils.setOptionNodeSelectionState(node, isSelected);\n                                }\n                            });\n                        }\n\n                        element.scrollTop = previousScrollTop;\n                    }\n\n                    if (ko.utils.tagNameLower(element) != \"select\") {\n                        throw new Error(\"selectedOptions binding applies only to SELECT elements\");\n                    }\n\n                    var updateFromModelComputed;\n                    ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                        if (!updateFromModelComputed) {\n                            ko.utils.registerEventHandler(element, \"change\", updateFromView);\n                            updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                        } else {\n                            updateFromView();\n                        }\n                    }, null, { 'notifyImmediately': true });\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped binding\n            };\n            ko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\n            ko.bindingHandlers['style'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor() || {});\n                    ko.utils.objectForEach(value, function(styleName, styleValue) {\n                        styleValue = ko.utils.unwrapObservable(styleValue);\n\n                        if (styleValue === null || styleValue === undefined || styleValue === false) {\n                            // Empty string removes the value, whereas null/undefined have no effect\n                            styleValue = \"\";\n                        }\n\n                        if (jQueryInstance) {\n                            jQueryInstance(element)['css'](styleName, styleValue);\n                        } else if (/^--/.test(styleName)) {\n                            // Is styleName a custom CSS property?\n                            element.style.setProperty(styleName, styleValue);\n                        } else {\n                            styleName = styleName.replace(/-(\\w)/g, function (all, letter) {\n                                return letter.toUpperCase();\n                            });\n\n                            var previousStyle = element.style[styleName];\n                            element.style[styleName] = styleValue;\n\n                            if (styleValue !== previousStyle && element.style[styleName] == previousStyle && !isNaN(styleValue)) {\n                                element.style[styleName] = styleValue + \"px\";\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['submit'] = {\n                'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    if (typeof valueAccessor() != \"function\")\n                        throw new Error(\"The value for a submit binding must be a function\");\n                    ko.utils.registerEventHandler(element, \"submit\", function (event) {\n                        var handlerReturnValue;\n                        var value = valueAccessor();\n                        try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n                        finally {\n                            if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                                if (event.preventDefault)\n                                    event.preventDefault();\n                                else\n                                    event.returnValue = false;\n                            }\n                        }\n                    });\n                }\n            };\n            ko.bindingHandlers['text'] = {\n                'init': function() {\n                    // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n                    // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n                    return { 'controlsDescendantBindings': true };\n                },\n                'update': function (element, valueAccessor) {\n                    ko.utils.setTextContent(element, valueAccessor());\n                }\n            };\n            ko.virtualElements.allowedBindings['text'] = true;\n            (function () {\n\n                if (window && window.navigator) {\n                    var parseVersion = function (matches) {\n                        if (matches) {\n                            return parseFloat(matches[1]);\n                        }\n                    };\n\n                    // Detect various browser versions because some old versions don't fully support the 'input' event\n                    var userAgent = window.navigator.userAgent,\n                        operaVersion, chromeVersion, safariVersion, firefoxVersion, ieVersion, edgeVersion;\n\n                    (operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()))\n                    || (edgeVersion = parseVersion(userAgent.match(/Edge\\/([^ ]+)$/)))\n                    || (chromeVersion = parseVersion(userAgent.match(/Chrome\\/([^ ]+)/)))\n                    || (safariVersion = parseVersion(userAgent.match(/Version\\/([^ ]+) Safari/)))\n                    || (firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]+)/)))\n                    || (ieVersion = ko.utils.ieVersion || parseVersion(userAgent.match(/MSIE ([^ ]+)/)))      // Detects up to IE 10\n                    || (ieVersion = parseVersion(userAgent.match(/rv:([^ )]+)/)));      // Detects IE 11\n                }\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\n                if (ieVersion >= 8 && ieVersion < 10) {\n                    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n                        selectionChangeHandlerName = ko.utils.domData.nextKey();\n                    var selectionChangeHandler = function(event) {\n                        var target = this.activeElement,\n                            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n                        if (handler) {\n                            handler(event);\n                        }\n                    };\n                    var registerForSelectionChangeEvent = function (element, handler) {\n                        var ownerDoc = element.ownerDocument;\n                        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n                            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n                            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n                        }\n                        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n                    };\n                }\n\n                ko.bindingHandlers['textInput'] = {\n                    'init': function (element, valueAccessor, allBindings) {\n\n                        var previousElementValue = element.value,\n                            timeoutHandle,\n                            elementValueBeforeEvent;\n\n                        var updateModel = function (event) {\n                            clearTimeout(timeoutHandle);\n                            elementValueBeforeEvent = timeoutHandle = undefined;\n\n                            var elementValue = element.value;\n                            if (previousElementValue !== elementValue) {\n                                // Provide a way for tests to know exactly which event was processed\n                                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                                previousElementValue = elementValue;\n                                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n                            }\n                        };\n\n                        var deferUpdateModel = function (event) {\n                            if (!timeoutHandle) {\n                                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                                // event firing and the updateModel function running. This allows us to ignore model\n                                // updates that are from the previous state of the element, usually due to techniques\n                                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                                elementValueBeforeEvent = element.value;\n                                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                                timeoutHandle = ko.utils.setTimeout(handler, 4);\n                            }\n                        };\n\n                        // IE9 will mess up the DOM if you handle events synchronously which results in DOM changes (such as other bindings);\n                        // so we'll make sure all updates are asynchronous\n                        var ieUpdateModel = ko.utils.ieVersion == 9 ? deferUpdateModel : updateModel,\n                            ourUpdate = false;\n\n                        var updateView = function () {\n                            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                            if (modelValue === null || modelValue === undefined) {\n                                modelValue = '';\n                            }\n\n                            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateView, 4);\n                                return;\n                            }\n\n                            // Update the element only if the element and model are different. On some browsers, updating the value\n                            // will move the cursor to the end of the input, which would be bad while the user is typing.\n                            if (element.value !== modelValue) {\n                                ourUpdate = true;  // Make sure we ignore events (propertychange) that result from updating the value\n                                element.value = modelValue;\n                                ourUpdate = false;\n                                previousElementValue = element.value; // In case the browser changes the value (see #2281)\n                            }\n                        };\n\n                        var onEvent = function (event, handler) {\n                            ko.utils.registerEventHandler(element, event, handler);\n                        };\n\n                        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n                            // Provide a way for tests to specify exactly which events are bound\n                            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                                if (eventName.slice(0,5) == 'after') {\n                                    onEvent(eventName.slice(5), deferUpdateModel);\n                                } else {\n                                    onEvent(eventName, updateModel);\n                                }\n                            });\n                        } else {\n                            if (ieVersion) {\n                                // All versions (including 11) of Internet Explorer have a bug that they don't generate an input or propertychange event when ESC is pressed\n                                onEvent('keypress', updateModel);\n                            }\n                            if (ieVersion < 11) {\n                                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                                // but that's an acceptable compromise for this binding. IE 9 and 10 support 'input', but since they don't always\n                                // fire it when using autocomplete, we'll use 'propertychange' for them also.\n                                onEvent('propertychange', function(event) {\n                                    if (!ourUpdate && event.propertyName === 'value') {\n                                        ieUpdateModel(event);\n                                    }\n                                });\n                            }\n                            if (ieVersion == 8) {\n                                // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                                // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                                // events too.\n                                onEvent('keyup', updateModel);      // A single keystoke\n                                onEvent('keydown', updateModel);    // The first character when a key is held down\n                            }\n                            if (registerForSelectionChangeEvent) {\n                                // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                                // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                                // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                                // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                                // These are also needed in IE8 because of the bug described above.\n                                registerForSelectionChangeEvent(element, ieUpdateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                                onEvent('dragend', deferUpdateModel);\n                            }\n\n                            if (!ieVersion || ieVersion >= 9) {\n                                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                                // through the user interface.\n                                onEvent('input', ieUpdateModel);\n                            }\n\n                            if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                                // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                                // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                                onEvent('keydown', deferUpdateModel);\n                                onEvent('paste', deferUpdateModel);\n                                onEvent('cut', deferUpdateModel);\n                            } else if (operaVersion < 11) {\n                                // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                                // We can try to catch some of those using 'keydown'.\n                                onEvent('keydown', deferUpdateModel);\n                            } else if (firefoxVersion < 4.0) {\n                                // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                                onEvent('DOMAutoComplete', updateModel);\n\n                                // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                                onEvent('dragdrop', updateModel);       // <3.5\n                                onEvent('drop', updateModel);           // 3.5\n                            } else if (edgeVersion && element.type === \"number\") {\n                                // Microsoft Edge doesn't fire 'input' or 'change' events for number inputs when\n                                // the value is changed via the up / down arrow keys\n                                onEvent('keydown', deferUpdateModel);\n                            }\n                        }\n\n                        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n                        onEvent('change', updateModel);\n\n                        // To deal with browsers that don't notify any kind of event for some changes (IE, Safari, etc.)\n                        onEvent('blur', updateModel);\n\n                        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                };\n                ko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\n                ko.bindingHandlers['textinput'] = {\n                    // preprocess is the only way to set up a full alias\n                    'preprocess': function (value, name, addBinding) {\n                        addBinding('textInput', value);\n                    }\n                };\n\n            })();ko.bindingHandlers['uniqueName'] = {\n                'init': function (element, valueAccessor) {\n                    if (valueAccessor()) {\n                        var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n                        ko.utils.setElementName(element, name);\n                    }\n                }\n            };\n            ko.bindingHandlers['uniqueName'].currentIndex = 0;\n            ko.bindingHandlers['using'] = {\n                'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n                    var options;\n\n                    if (allBindings['has']('as')) {\n                        options = { 'as': allBindings.get('as'), 'noChildContext': allBindings.get('noChildContext') };\n                    }\n\n                    var innerContext = bindingContext['createChildContext'](valueAccessor, options);\n                    ko.applyBindingsToDescendants(innerContext, element);\n\n                    return { 'controlsDescendantBindings': true };\n                }\n            };\n            ko.virtualElements.allowedBindings['using'] = true;\n            ko.bindingHandlers['value'] = {\n                'init': function (element, valueAccessor, allBindings) {\n                    var tagName = ko.utils.tagNameLower(element),\n                        isInputElement = tagName == \"input\";\n\n                    // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n                    if (isInputElement && (element.type == \"checkbox\" || element.type == \"radio\")) {\n                        ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n                        return;\n                    }\n\n                    var eventsToCatch = [];\n                    var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n                    var propertyChangedFired = false;\n                    var elementValueBeforeEvent = null;\n\n                    if (requestedEventsToCatch) {\n                        // Allow both individual event names, and arrays of event names\n                        if (typeof requestedEventsToCatch == \"string\") {\n                            eventsToCatch = [requestedEventsToCatch];\n                        } else {\n                            eventsToCatch = ko.utils.arrayGetDistinctValues(requestedEventsToCatch);\n                        }\n                        ko.utils.arrayRemoveItem(eventsToCatch, \"change\");  // We'll subscribe to \"change\" events later\n                    }\n\n                    var valueUpdateHandler = function() {\n                        elementValueBeforeEvent = null;\n                        propertyChangedFired = false;\n                        var modelValue = valueAccessor();\n                        var elementValue = ko.selectExtensions.readValue(element);\n                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n                    }\n\n                    // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n                    // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n                    var ieAutoCompleteHackNeeded = ko.utils.ieVersion && isInputElement && element.type == \"text\"\n                        && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n                    if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n                        ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n                        ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n                        ko.utils.registerEventHandler(element, \"blur\", function() {\n                            if (propertyChangedFired) {\n                                valueUpdateHandler();\n                            }\n                        });\n                    }\n\n                    ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n                        // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n                        // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n                        // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n                        var handler = valueUpdateHandler;\n                        if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                            handler = function() {\n                                // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                                // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                                // at the earliest asynchronous opportunity. We store this temporary information so that\n                                // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                                // we can overwrite that model value change with the value the user just typed. Otherwise,\n                                // techniques like rateLimit can trigger model changes at critical moments that will\n                                // override the user's inputs, causing keystrokes to be lost.\n                                elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                                ko.utils.setTimeout(valueUpdateHandler, 0);\n                            };\n                            eventName = eventName.substring(\"after\".length);\n                        }\n                        ko.utils.registerEventHandler(element, eventName, handler);\n                    });\n\n                    var updateFromModel;\n\n                    if (isInputElement && element.type == \"file\") {\n                        // For file input elements, can only write the empty string\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            if (newValue === null || newValue === undefined || newValue === \"\") {\n                                element.value = \"\";\n                            } else {\n                                ko.dependencyDetection.ignore(valueUpdateHandler);  // reset the model to match the element\n                            }\n                        }\n                    } else {\n                        updateFromModel = function () {\n                            var newValue = ko.utils.unwrapObservable(valueAccessor());\n                            var elementValue = ko.selectExtensions.readValue(element);\n\n                            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                                ko.utils.setTimeout(updateFromModel, 0);\n                                return;\n                            }\n\n                            var valueHasChanged = newValue !== elementValue;\n\n                            if (valueHasChanged || elementValue === undefined) {\n                                if (tagName === \"select\") {\n                                    var allowUnset = allBindings.get('valueAllowUnset');\n                                    ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                                        ko.dependencyDetection.ignore(valueUpdateHandler);\n                                    }\n                                } else {\n                                    ko.selectExtensions.writeValue(element, newValue);\n                                }\n                            }\n                        };\n                    }\n\n                    if (tagName === \"select\") {\n                        var updateFromModelComputed;\n                        ko.bindingEvent.subscribe(element, ko.bindingEvent.childrenComplete, function () {\n                            if (!updateFromModelComputed) {\n                                ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                                updateFromModelComputed = ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                            } else if (allBindings.get('valueAllowUnset')) {\n                                updateFromModel();\n                            } else {\n                                valueUpdateHandler();\n                            }\n                        }, null, { 'notifyImmediately': true });\n                    } else {\n                        ko.utils.registerEventHandler(element, \"change\", valueUpdateHandler);\n                        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n                    }\n                },\n                'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n            };\n            ko.expressionRewriting.twoWayBindings['value'] = true;\n            ko.bindingHandlers['visible'] = {\n                'update': function (element, valueAccessor) {\n                    var value = ko.utils.unwrapObservable(valueAccessor());\n                    var isCurrentlyVisible = !(element.style.display == \"none\");\n                    if (value && !isCurrentlyVisible)\n                        element.style.display = \"\";\n                    else if ((!value) && isCurrentlyVisible)\n                        element.style.display = \"none\";\n                }\n            };\n\n            ko.bindingHandlers['hidden'] = {\n                'update': function (element, valueAccessor) {\n                    ko.bindingHandlers['visible']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n                }\n            };\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\n            makeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\n            ko.templateEngine = function () { };\n\n            ko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                throw new Error(\"Override renderTemplateSource\");\n            };\n\n            ko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n                throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n            };\n\n            ko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n                // Named template\n                if (typeof template == \"string\") {\n                    templateDocument = templateDocument || document;\n                    var elem = templateDocument.getElementById(template);\n                    if (!elem)\n                        throw new Error(\"Cannot find template with ID \" + template);\n                    return new ko.templateSources.domElement(elem);\n                } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n                    // Anonymous template\n                    return new ko.templateSources.anonymousTemplate(template);\n                } else\n                    throw new Error(\"Unknown template type: \" + template);\n            };\n\n            ko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n            };\n\n            ko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n                // Skip rewriting if requested\n                if (this['allowTemplateRewriting'] === false)\n                    return true;\n                return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n            };\n\n            ko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n                var templateSource = this['makeTemplateSource'](template, templateDocument);\n                var rewritten = rewriterCallback(templateSource['text']());\n                templateSource['text'](rewritten);\n                templateSource['data'](\"isRewritten\", true);\n            };\n\n            ko.exportSymbol('templateEngine', ko.templateEngine);\n\n            ko.templateRewriting = (function () {\n                var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n                var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n                function validateDataBindValuesForRewriting(keyValueArray) {\n                    var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n                    for (var i = 0; i < keyValueArray.length; i++) {\n                        var key = keyValueArray[i]['key'];\n                        if (Object.prototype.hasOwnProperty.call(allValidators, key)) {\n                            var validator = allValidators[key];\n\n                            if (typeof validator === \"function\") {\n                                var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                                if (possibleErrorMessage)\n                                    throw new Error(possibleErrorMessage);\n                            } else if (!validator) {\n                                throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                            }\n                        }\n                    }\n                }\n\n                function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n                    var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n                    validateDataBindValuesForRewriting(dataBindKeyValueArray);\n                    var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n                    // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n                    // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n                    // extra indirection.\n                    var applyBindingsToNextSiblingScript =\n                        \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n                    return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n                }\n\n                return {\n                    ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n                        if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                            templateEngine['rewriteTemplate'](template, function (htmlString) {\n                                return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                            }, templateDocument);\n                    },\n\n                    memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n                        return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n                        }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                            return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n                        });\n                    },\n\n                    applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n                        return ko.memoization.memoize(function (domNode, bindingContext) {\n                            var nodeToBind = domNode.nextSibling;\n                            if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                                ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                            }\n                        });\n                    }\n                }\n            })();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\n            ko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n            (function() {\n                // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n                // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n                //\n                // Two are provided by default:\n                //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n                //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n                //                                           without reading/writing the actual element text content, since it will be overwritten\n                //                                           with the rendered template output.\n                // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n                // Template sources need to have the following functions:\n                //   text() \t\t\t- returns the template text from your storage location\n                //   text(value)\t\t- writes the supplied template text to your storage location\n                //   data(key)\t\t\t- reads values stored using data(key, value) - see below\n                //   data(key, value)\t- associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n                //\n                // Optionally, template sources can also have the following functions:\n                //   nodes()            - returns a DOM element containing the nodes of this template, where available\n                //   nodes(value)       - writes the given DOM element to your storage location\n                // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n                // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n                //\n                // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n                // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n                ko.templateSources = {};\n\n                // ---- ko.templateSources.domElement -----\n\n                // template types\n                var templateScript = 1,\n                    templateTextArea = 2,\n                    templateTemplate = 3,\n                    templateElement = 4;\n\n                ko.templateSources.domElement = function(element) {\n                    this.domElement = element;\n\n                    if (element) {\n                        var tagNameLower = ko.utils.tagNameLower(element);\n                        this.templateType =\n                            tagNameLower === \"script\" ? templateScript :\n                                tagNameLower === \"textarea\" ? templateTextArea :\n                                    // For browsers with proper <template> element support, where the .content property gives a document fragment\n                                    tagNameLower == \"template\" && element.content && element.content.nodeType === 11 ? templateTemplate :\n                                        templateElement;\n                    }\n                }\n\n                ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n                    var elemContentsProperty = this.templateType === templateScript ? \"text\"\n                        : this.templateType === templateTextArea ? \"value\"\n                            : \"innerHTML\";\n\n                    if (arguments.length == 0) {\n                        return this.domElement[elemContentsProperty];\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (elemContentsProperty === \"innerHTML\")\n                            ko.utils.setHtml(this.domElement, valueToWrite);\n                        else\n                            this.domElement[elemContentsProperty] = valueToWrite;\n                    }\n                };\n\n                var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n                ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n                    if (arguments.length === 1) {\n                        return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n                    } else {\n                        ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n                    }\n                };\n\n                var templatesDomDataKey = ko.utils.domData.nextKey();\n                function getTemplateDomData(element) {\n                    return ko.utils.domData.get(element, templatesDomDataKey) || {};\n                }\n                function setTemplateDomData(element, data) {\n                    ko.utils.domData.set(element, templatesDomDataKey, data);\n                }\n\n                ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n                    var element = this.domElement;\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(element),\n                            nodes = templateData.containerData || (\n                                this.templateType === templateTemplate ? element.content :\n                                    this.templateType === templateElement ? element :\n                                        undefined);\n                        if (!nodes || templateData.alwaysCheckText) {\n                            // If the template is associated with an element that stores the template as text,\n                            // parse and cache the nodes whenever there's new text content available. This allows\n                            // the user to update the template content by updating the text of template node.\n                            var text = this['text']();\n                            if (text && text !== templateData.textData) {\n                                nodes = ko.utils.parseHtmlForTemplateNodes(text, element.ownerDocument);\n                                setTemplateDomData(element, {containerData: nodes, textData: text, alwaysCheckText: true});\n                            }\n                        }\n                        return nodes;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        if (this.templateType !== undefined) {\n                            this['text'](\"\");   // clear the text from the node\n                        }\n                        setTemplateDomData(element, {containerData: valueToWrite});\n                    }\n                };\n\n                // ---- ko.templateSources.anonymousTemplate -----\n                // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n                // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n                // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n                ko.templateSources.anonymousTemplate = function(element) {\n                    this.domElement = element;\n                }\n                ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n                ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n                ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n                    if (arguments.length == 0) {\n                        var templateData = getTemplateDomData(this.domElement);\n                        if (templateData.textData === undefined && templateData.containerData)\n                            templateData.textData = templateData.containerData.innerHTML;\n                        return templateData.textData;\n                    } else {\n                        var valueToWrite = arguments[0];\n                        setTemplateDomData(this.domElement, {textData: valueToWrite});\n                    }\n                };\n\n                ko.exportSymbol('templateSources', ko.templateSources);\n                ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n                ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n            })();\n            (function () {\n                var _templateEngine;\n                ko.setTemplateEngine = function (templateEngine) {\n                    if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n                        throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n                    _templateEngine = templateEngine;\n                }\n\n                function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n                    var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n                    while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n                        nextInQueue = ko.virtualElements.nextSibling(node);\n                        action(node, nextInQueue);\n                    }\n                }\n\n                function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n                    // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n                    // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n                    // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n                    // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n                    // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n                    if (continuousNodeArray.length) {\n                        var firstNode = continuousNodeArray[0],\n                            lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                            parentNode = firstNode.parentNode,\n                            provider = ko.bindingProvider['instance'],\n                            preprocessNode = provider['preprocessNode'];\n\n                        if (preprocessNode) {\n                            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                                var nodePreviousSibling = node.previousSibling;\n                                var newNodes = preprocessNode.call(provider, node);\n                                if (newNodes) {\n                                    if (node === firstNode)\n                                        firstNode = newNodes[0] || nextNodeInRange;\n                                    if (node === lastNode)\n                                        lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                                }\n                            });\n\n                            // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                            // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                            // first node needs to be in the array).\n                            continuousNodeArray.length = 0;\n                            if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                                return;\n                            }\n                            if (firstNode === lastNode) {\n                                continuousNodeArray.push(firstNode);\n                            } else {\n                                continuousNodeArray.push(firstNode, lastNode);\n                                ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                            }\n                        }\n\n                        // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n                        // whereas a regular applyBindings won't introduce new memoized nodes\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.applyBindings(bindingContext, node);\n                        });\n                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                            if (node.nodeType === 1 || node.nodeType === 8)\n                                ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n                        });\n\n                        // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n                        ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                    }\n                }\n\n                function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n                    return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                            : null;\n                }\n\n                function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n                    options = options || {};\n                    var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n                    var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n                    ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n                    var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n                    // Loosely check result is an array of DOM nodes\n                    if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n                        throw new Error(\"Template engine must return an array of DOM nodes\");\n\n                    var haveAddedNodesToParent = false;\n                    switch (renderMode) {\n                        case \"replaceChildren\":\n                            ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"replaceNode\":\n                            ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                            haveAddedNodesToParent = true;\n                            break;\n                        case \"ignoreTargetNode\": break;\n                        default:\n                            throw new Error(\"Unknown renderMode: \" + renderMode);\n                    }\n\n                    if (haveAddedNodesToParent) {\n                        activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n                        if (options['afterRender']) {\n                            ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext[options['as'] || '$data']]);\n                        }\n                        if (renderMode == \"replaceChildren\") {\n                            ko.bindingEvent.notify(targetNodeOrNodeArray, ko.bindingEvent.childrenComplete);\n                        }\n                    }\n\n                    return renderedNodesArray;\n                }\n\n                function resolveTemplateName(template, data, context) {\n                    // The template can be specified as:\n                    if (ko.isObservable(template)) {\n                        // 1. An observable, with string value\n                        return template();\n                    } else if (typeof template === 'function') {\n                        // 2. A function of (data, context) returning a string\n                        return template(data, context);\n                    } else {\n                        // 3. A string\n                        return template;\n                    }\n                }\n\n                ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n                    options = options || {};\n                    if ((options['templateEngine'] || _templateEngine) == undefined)\n                        throw new Error(\"Set a template engine before calling renderTemplate\");\n                    renderMode = renderMode || \"replaceChildren\";\n\n                    if (targetNodeOrNodeArray) {\n                        var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n                        var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n                        var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n                        return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                            function () {\n                                // Ensure we've got a proper binding context to work with\n                                var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                                    ? dataOrBindingContext\n                                    : new ko.bindingContext(dataOrBindingContext, null, null, null, { \"exportDependencies\": true });\n\n                                var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                                    renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                                if (renderMode == \"replaceNode\") {\n                                    targetNodeOrNodeArray = renderedNodesArray;\n                                    firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                                }\n                            },\n                            null,\n                            { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n                        );\n                    } else {\n                        // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n                        return ko.memoization.memoize(function (domNode) {\n                            ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n                        });\n                    }\n                };\n\n                ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n                    // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n                    // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n                    var arrayItemContext, asName = options['as'];\n\n                    // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n                    var executeTemplateForArrayItem = function (arrayValue, index) {\n                        // Support selecting template as a function of the data being rendered\n                        arrayItemContext = parentBindingContext['createChildContext'](arrayValue, {\n                            'as': asName,\n                            'noChildContext': options['noChildContext'],\n                            'extend': function(context) {\n                                context['$index'] = index;\n                                if (asName) {\n                                    context[asName + \"Index\"] = index;\n                                }\n                            }\n                        });\n\n                        var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n                        return executeTemplate(targetNode, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n                    };\n\n                    // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n                    var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n                        activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n                        if (options['afterRender'])\n                            options['afterRender'](addedNodesArray, arrayValue);\n\n                        // release the \"cache\" variable, so that it can be collected by\n                        // the GC when its value isn't used from within the bindings anymore.\n                        arrayItemContext = null;\n                    };\n\n                    var setDomNodeChildrenFromArrayMapping = function (newArray, changeList) {\n                        // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n                        // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n                        ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, newArray, executeTemplateForArrayItem, options, activateBindingsCallback, changeList]);\n                        ko.bindingEvent.notify(targetNode, ko.bindingEvent.childrenComplete);\n                    };\n\n                    var shouldHideDestroyed = (options['includeDestroyed'] === false) || (ko.options['foreachHidesDestroyed'] && !options['includeDestroyed']);\n\n                    if (!shouldHideDestroyed && !options['beforeRemove'] && ko.isObservableArray(arrayOrObservableArray)) {\n                        setDomNodeChildrenFromArrayMapping(arrayOrObservableArray.peek());\n\n                        var subscription = arrayOrObservableArray.subscribe(function (changeList) {\n                            setDomNodeChildrenFromArrayMapping(arrayOrObservableArray(), changeList);\n                        }, null, \"arrayChange\");\n                        subscription.disposeWhenNodeIsRemoved(targetNode);\n\n                        return subscription;\n                    } else {\n                        return ko.dependentObservable(function () {\n                            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n                            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                                unwrappedArray = [unwrappedArray];\n\n                            if (shouldHideDestroyed) {\n                                // Filter out any entries marked as destroyed\n                                unwrappedArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                                    return item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n                                });\n                            }\n                            setDomNodeChildrenFromArrayMapping(unwrappedArray);\n\n                        }, null, { disposeWhenNodeIsRemoved: targetNode });\n                    }\n                };\n\n                var templateComputedDomDataKey = ko.utils.domData.nextKey();\n                function disposeOldComputedAndStoreNewOne(element, newComputed) {\n                    var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n                    if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n                        oldComputed.dispose();\n                    ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && (!newComputed.isActive || newComputed.isActive())) ? newComputed : undefined);\n                }\n\n                var cleanContainerDomDataKey = ko.utils.domData.nextKey();\n                ko.bindingHandlers['template'] = {\n                    'init': function(element, valueAccessor) {\n                        // Support anonymous templates\n                        var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n                        if (typeof bindingValue == \"string\" || 'name' in bindingValue) {\n                            // It's a named template - clear the element\n                            ko.virtualElements.emptyNode(element);\n                        } else if ('nodes' in bindingValue) {\n                            // We've been given an array of DOM nodes. Save them as the template source.\n                            // There is no known use case for the node array being an observable array (if the output\n                            // varies, put that behavior *into* your template - that's what templates are for), and\n                            // the implementation would be a mess, so assert that it's not observable.\n                            var nodes = bindingValue['nodes'] || [];\n                            if (ko.isObservable(nodes)) {\n                                throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                            }\n\n                            // If the nodes are already attached to a KO-generated container, we reuse that container without moving the\n                            // elements to a new one (we check only the first node, as the nodes are always moved together)\n                            var container = nodes[0] && nodes[0].parentNode;\n                            if (!container || !ko.utils.domData.get(container, cleanContainerDomDataKey)) {\n                                container = ko.utils.moveCleanedNodesToContainerElement(nodes);\n                                ko.utils.domData.set(container, cleanContainerDomDataKey, true);\n                            }\n\n                            new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                        } else {\n                            // It's an anonymous template - store the element contents, then clear the element\n                            var templateNodes = ko.virtualElements.childNodes(element);\n                            if (templateNodes.length > 0) {\n                                var container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n                            } else {\n                                throw new Error(\"Anonymous template defined, but no template content was provided\");\n                            }\n                        }\n                        return { 'controlsDescendantBindings': true };\n                    },\n                    'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n                        var value = valueAccessor(),\n                            options = ko.utils.unwrapObservable(value),\n                            shouldDisplay = true,\n                            templateComputed = null,\n                            template;\n\n                        if (typeof options == \"string\") {\n                            template = value;\n                            options = {};\n                        } else {\n                            template = 'name' in options ? options['name'] : element;\n\n                            // Support \"if\"/\"ifnot\" conditions\n                            if ('if' in options)\n                                shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                            if (shouldDisplay && 'ifnot' in options)\n                                shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n\n                            // Don't show anything if an empty name is given (see #2446)\n                            if (shouldDisplay && !template) {\n                                shouldDisplay = false;\n                            }\n                        }\n\n                        if ('foreach' in options) {\n                            // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                            var dataArray = (shouldDisplay && options['foreach']) || [];\n                            templateComputed = ko.renderTemplateForEach(template, dataArray, options, element, bindingContext);\n                        } else if (!shouldDisplay) {\n                            ko.virtualElements.emptyNode(element);\n                        } else {\n                            // Render once for this single data point (or use the viewModel if no data was provided)\n                            var innerBindingContext = bindingContext;\n                            if ('data' in options) {\n                                innerBindingContext = bindingContext['createChildContext'](options['data'], {\n                                    'as': options['as'],\n                                    'noChildContext': options['noChildContext'],\n                                    'exportDependencies': true\n                                });\n                            }\n                            templateComputed = ko.renderTemplate(template, innerBindingContext, options, element);\n                        }\n\n                        // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n                        disposeOldComputedAndStoreNewOne(element, templateComputed);\n                    }\n                };\n\n                // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n                ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n                    var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n                    if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n                        return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n                    if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n                        return null; // Named templates can be rewritten, so return \"no error\"\n                    return \"This template engine does not support anonymous templates nested within its templates\";\n                };\n\n                ko.virtualElements.allowedBindings['template'] = true;\n            })();\n\n            ko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\n            ko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\n            ko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n                if (left.length && right.length) {\n                    var failedCompares, l, r, leftItem, rightItem;\n                    for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n                        for (r = 0; rightItem = right[r]; ++r) {\n                            if (leftItem['value'] === rightItem['value']) {\n                                leftItem['moved'] = rightItem['index'];\n                                rightItem['moved'] = leftItem['index'];\n                                right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                                failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                                break;\n                            }\n                        }\n                        failedCompares += r;\n                    }\n                }\n            };\n\n            ko.utils.compareArrays = (function () {\n                var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n                // Simple calculation based on Levenshtein distance.\n                function compareArrays(oldArray, newArray, options) {\n                    // For backward compatibility, if the third arg is actually a bool, interpret\n                    // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n                    options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n                    oldArray = oldArray || [];\n                    newArray = newArray || [];\n\n                    if (oldArray.length < newArray.length)\n                        return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n                    else\n                        return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n                }\n\n                function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n                    var myMin = Math.min,\n                        myMax = Math.max,\n                        editDistanceMatrix = [],\n                        smlIndex, smlIndexMax = smlArray.length,\n                        bigIndex, bigIndexMax = bigArray.length,\n                        compareRange = (bigIndexMax - smlIndexMax) || 1,\n                        maxDistance = smlIndexMax + bigIndexMax + 1,\n                        thisRow, lastRow,\n                        bigIndexMaxForRow, bigIndexMinForRow;\n\n                    for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n                        lastRow = thisRow;\n                        editDistanceMatrix.push(thisRow = []);\n                        bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n                        bigIndexMinForRow = myMax(0, smlIndex - 1);\n                        for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                            if (!bigIndex)\n                                thisRow[bigIndex] = smlIndex + 1;\n                            else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                                thisRow[bigIndex] = bigIndex + 1;\n                            else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                                thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                            else {\n                                var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                                var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                                thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                            }\n                        }\n                    }\n\n                    var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n                    for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n                        meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n                        if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                            notInSml.push(editScript[editScript.length] = {     // added\n                                'status': statusNotInSml,\n                                'value': bigArray[--bigIndex],\n                                'index': bigIndex });\n                        } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                            notInBig.push(editScript[editScript.length] = {     // deleted\n                                'status': statusNotInBig,\n                                'value': smlArray[--smlIndex],\n                                'index': smlIndex });\n                        } else {\n                            --bigIndex;\n                            --smlIndex;\n                            if (!options['sparse']) {\n                                editScript.push({\n                                    'status': \"retained\",\n                                    'value': bigArray[bigIndex] });\n                            }\n                        }\n                    }\n\n                    // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n                    // smlIndexMax keeps the time complexity of this algorithm linear.\n                    ko.utils.findMovesInArrayComparison(notInBig, notInSml, !options['dontLimitMoves'] && smlIndexMax * 10);\n\n                    return editScript.reverse();\n                }\n\n                return compareArrays;\n            })();\n\n            ko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n            (function () {\n                // Objective:\n                // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n                //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n                // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n                //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n                //   previously mapped - retain those nodes, and just insert/delete other ones\n\n                // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n                // You can use this, for example, to activate bindings on those nodes.\n\n                function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n                    // Map this array value inside a dependentObservable so we re-map when any dependency changes\n                    var mappedNodes = [];\n                    var dependentObservable = ko.dependentObservable(function() {\n                        var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n                        // On subsequent evaluations, just replace the previously-inserted DOM nodes\n                        if (mappedNodes.length > 0) {\n                            ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                            if (callbackAfterAddingNodes)\n                                ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n                        }\n\n                        // Replace the contents of the mappedNodes array, thereby updating the record\n                        // of which nodes would be deleted if valueToMap was itself later removed\n                        mappedNodes.length = 0;\n                        ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n                    }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n                    return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n                }\n\n                var lastMappingResultDomDataKey = ko.utils.domData.nextKey(),\n                    deletedItemDummyValue = ko.utils.domData.nextKey();\n\n                ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes, editScript) {\n                    array = array || [];\n                    if (typeof array.length == \"undefined\") // Coerce single value into array\n                        array = [array];\n\n                    options = options || {};\n                    var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey);\n                    var isFirstExecution = !lastMappingResult;\n\n                    // Build the new mapping result\n                    var newMappingResult = [];\n                    var lastMappingResultIndex = 0;\n                    var currentArrayIndex = 0;\n\n                    var nodesToDelete = [];\n                    var itemsToMoveFirstIndexes = [];\n                    var itemsForBeforeRemoveCallbacks = [];\n                    var itemsForMoveCallbacks = [];\n                    var itemsForAfterAddCallbacks = [];\n                    var mapData;\n                    var countWaitingForRemove = 0;\n\n                    function itemAdded(value) {\n                        mapData = { arrayEntry: value, indexObservable: ko.observable(currentArrayIndex++) };\n                        newMappingResult.push(mapData);\n                        if (!isFirstExecution) {\n                            itemsForAfterAddCallbacks.push(mapData);\n                        }\n                    }\n\n                    function itemMovedOrRetained(oldPosition) {\n                        mapData = lastMappingResult[oldPosition];\n                        if (currentArrayIndex !== mapData.indexObservable.peek())\n                            itemsForMoveCallbacks.push(mapData);\n                        // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n                        mapData.indexObservable(currentArrayIndex++);\n                        ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n                        newMappingResult.push(mapData);\n                    }\n\n                    function callCallback(callback, items) {\n                        if (callback) {\n                            for (var i = 0, n = items.length; i < n; i++) {\n                                ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                                    callback(node, i, items[i].arrayEntry);\n                                });\n                            }\n                        }\n                    }\n\n                    if (isFirstExecution) {\n                        ko.utils.arrayForEach(array, itemAdded);\n                    } else {\n                        if (!editScript || (lastMappingResult && lastMappingResult['_countWaitingForRemove'])) {\n                            // Compare the provided array against the previous one\n                            var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; }),\n                                compareOptions = {\n                                    'dontLimitMoves': options['dontLimitMoves'],\n                                    'sparse': true\n                                };\n                            editScript = ko.utils.compareArrays(lastArray, array, compareOptions);\n                        }\n\n                        for (var i = 0, editScriptItem, movedIndex, itemIndex; editScriptItem = editScript[i]; i++) {\n                            movedIndex = editScriptItem['moved'];\n                            itemIndex = editScriptItem['index'];\n                            switch (editScriptItem['status']) {\n                                case \"deleted\":\n                                    while (lastMappingResultIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex === undefined) {\n                                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                                        // Stop tracking changes to the mapping for these nodes\n                                        if (mapData.dependentObservable) {\n                                            mapData.dependentObservable.dispose();\n                                            mapData.dependentObservable = undefined;\n                                        }\n\n                                        // Queue these nodes for later removal\n                                        if (ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode).length) {\n                                            if (options['beforeRemove']) {\n                                                newMappingResult.push(mapData);\n                                                countWaitingForRemove++;\n                                                if (mapData.arrayEntry === deletedItemDummyValue) {\n                                                    mapData = null;\n                                                } else {\n                                                    itemsForBeforeRemoveCallbacks.push(mapData);\n                                                }\n                                            }\n                                            if (mapData) {\n                                                nodesToDelete.push.apply(nodesToDelete, mapData.mappedNodes);\n                                            }\n                                        }\n                                    }\n                                    lastMappingResultIndex++;\n                                    break;\n\n                                case \"added\":\n                                    while (currentArrayIndex < itemIndex) {\n                                        itemMovedOrRetained(lastMappingResultIndex++);\n                                    }\n                                    if (movedIndex !== undefined) {\n                                        itemsToMoveFirstIndexes.push(newMappingResult.length);\n                                        itemMovedOrRetained(movedIndex);\n                                    } else {\n                                        itemAdded(editScriptItem['value']);\n                                    }\n                                    break;\n                            }\n                        }\n\n                        while (currentArrayIndex < array.length) {\n                            itemMovedOrRetained(lastMappingResultIndex++);\n                        }\n\n                        // Record that the current view may still contain deleted items\n                        // because it means we won't be able to use a provided editScript.\n                        newMappingResult['_countWaitingForRemove'] = countWaitingForRemove;\n                    }\n\n                    // Store a copy of the array items we just considered so we can difference it next time\n                    ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n\n                    // Call beforeMove first before any changes have been made to the DOM\n                    callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n                    // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n                    ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n                    var i, j, lastNode, nodeToInsert, mappedNodes, activeElement;\n\n                    // Since most browsers remove the focus from an element when it's moved to another location,\n                    // save the focused element and try to restore it later.\n                    try {\n                        activeElement = domNode.ownerDocument.activeElement;\n                    } catch(e) {\n                        // IE9 throws if you access activeElement during page load (see issue #703)\n                    }\n\n                    // Try to reduce overall moved nodes by first moving the ones that were marked as moved by the edit script\n                    if (itemsToMoveFirstIndexes.length) {\n                        while ((i = itemsToMoveFirstIndexes.shift()) != undefined) {\n                            mapData = newMappingResult[i];\n                            for (lastNode = undefined; i; ) {\n                                if ((mappedNodes = newMappingResult[--i].mappedNodes) && mappedNodes.length) {\n                                    lastNode = mappedNodes[mappedNodes.length-1];\n                                    break;\n                                }\n                            }\n                            for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                                ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                            }\n                        }\n                    }\n\n                    // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n                    for (i = 0; mapData = newMappingResult[i]; i++) {\n                        // Get nodes for newly added items\n                        if (!mapData.mappedNodes)\n                            ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n                        // Put nodes in the right place if they aren't there already\n                        for (j = 0; nodeToInsert = mapData.mappedNodes[j]; lastNode = nodeToInsert, j++) {\n                            ko.virtualElements.insertAfter(domNode, nodeToInsert, lastNode);\n                        }\n\n                        // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n                        if (!mapData.initialized && callbackAfterAddingNodes) {\n                            callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                            mapData.initialized = true;\n                            lastNode = mapData.mappedNodes[mapData.mappedNodes.length - 1];     // get the last node again since it may have been changed by a preprocessor\n                        }\n                    }\n\n                    // Restore the focused element if it had lost focus\n                    if (activeElement && domNode.ownerDocument.activeElement != activeElement) {\n                        activeElement.focus();\n                    }\n\n                    // If there's a beforeRemove callback, call it after reordering.\n                    // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n                    // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n                    // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n                    // Perhaps we'll make that change in the future if this scenario becomes more common.\n                    callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n                    // Replace the stored values of deleted items with a dummy value. This provides two benefits: it marks this item\n                    // as already \"removed\" so we won't call beforeRemove for it again, and it ensures that the item won't match up\n                    // with an actual item in the array and appear as \"retained\" or \"moved\".\n                    for (i = 0; i < itemsForBeforeRemoveCallbacks.length; ++i) {\n                        itemsForBeforeRemoveCallbacks[i].arrayEntry = deletedItemDummyValue;\n                    }\n\n                    // Finally call afterMove and afterAdd callbacks\n                    callCallback(options['afterMove'], itemsForMoveCallbacks);\n                    callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n                }\n            })();\n\n            ko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\n            ko.nativeTemplateEngine = function () {\n                this['allowTemplateRewriting'] = false;\n            }\n\n            ko.nativeTemplateEngine.prototype = new ko.templateEngine();\n            ko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\n            ko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n                var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n                    templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n                    templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n                if (templateNodes) {\n                    return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n                } else {\n                    var templateText = templateSource['text']();\n                    return ko.utils.parseHtmlFragment(templateText, templateDocument);\n                }\n            };\n\n            ko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\n            ko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\n            ko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n            (function() {\n                ko.jqueryTmplTemplateEngine = function () {\n                    // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n                    // doesn't expose a version number, so we have to infer it.\n                    // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n                    // which KO internally refers to as version \"2\", so older versions are no longer detected.\n                    var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n                        if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                            return 0;\n                        // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n                        try {\n                            if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                                // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                                return 2; // Final version of jquery.tmpl\n                            }\n                        } catch(ex) { /* Apparently not the version we were looking for */ }\n\n                        return 1; // Any older version that we don't support\n                    })();\n\n                    function ensureHasReferencedJQueryTemplates() {\n                        if (jQueryTmplVersion < 2)\n                            throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n                    }\n\n                    function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n                        return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n                    }\n\n                    this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n                        templateDocument = templateDocument || document;\n                        options = options || {};\n                        ensureHasReferencedJQueryTemplates();\n\n                        // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n                        var precompiled = templateSource['data']('precompiled');\n                        if (!precompiled) {\n                            var templateText = templateSource['text']() || \"\";\n                            // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                            templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                            precompiled = jQueryInstance['template'](null, templateText);\n                            templateSource['data']('precompiled', precompiled);\n                        }\n\n                        var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n                        var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n                        var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n                        resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n                        jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n                        return resultNodes;\n                    };\n\n                    this['createJavaScriptEvaluatorBlock'] = function(script) {\n                        return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n                    };\n\n                    this['addTemplate'] = function(templateName, templateMarkup) {\n                        document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n                    };\n\n                    if (jQueryTmplVersion > 0) {\n                        jQueryInstance['tmpl']['tag']['ko_code'] = {\n                            open: \"__.push($1 || '');\"\n                        };\n                        jQueryInstance['tmpl']['tag']['ko_with'] = {\n                            open: \"with($1) {\",\n                            close: \"} \"\n                        };\n                    }\n                };\n\n                ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n                ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n                // Use this one by default *only if jquery.tmpl is referenced*\n                var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n                if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n                    ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n                ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n            })();\n        }));\n    }());\n})();\n","knockoutjs/knockout-fast-foreach.js":"/*!\n  Knockout Fast Foreach v0.4.1 (2015-07-17T14:06:15.974Z)\n  By: Brian M Hunt (C) 2015\n  License: MIT\n\n  Adds `fastForEach` to `ko.bindingHandlers`.\n*/\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    define(['knockout'], factory);\n  } else if (typeof exports === 'object') {\n    module.exports = factory(require('knockout'));\n  } else {\n    root.KnockoutFastForeach = factory(root.ko);\n  }\n}(this, function (ko) {\n  \"use strict\";\n// index.js\n// --------\n// Fast For Each\n//\n// Employing sound techniques to make a faster Knockout foreach binding.\n// --------\n\n//      Utilities\n\n// from https://github.com/jonschlinkert/is-plain-object\nfunction isPlainObject(o) {\n  return !!o && typeof o === 'object' && o.constructor === Object;\n}\n\n// From knockout/src/virtualElements.js\nvar commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\nvar startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\nvar supportsDocumentFragment = document && typeof document.createDocumentFragment === \"function\";\nfunction isVirtualNode(node) {\n  return (node.nodeType === 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n}\n\n\n// Get a copy of the (possibly virtual) child nodes of the given element,\n// put them into a container, then empty the given node.\nfunction makeTemplateNode(sourceNode) {\n  var container = document.createElement(\"div\");\n  var parentNode;\n  if (sourceNode.content) {\n    // For e.g. <template> tags\n    parentNode = sourceNode.content;\n  } else if (sourceNode.tagName === 'SCRIPT') {\n    parentNode = document.createElement(\"div\");\n    parentNode.innerHTML = sourceNode.text;\n  } else {\n    // Anything else e.g. <div>\n    parentNode = sourceNode;\n  }\n  ko.utils.arrayForEach(ko.virtualElements.childNodes(parentNode), function (child) {\n    // FIXME - This cloneNode could be expensive; we may prefer to iterate over the\n    // parentNode children in reverse (so as not to foul the indexes as childNodes are\n    // removed from parentNode when inserted into the container)\n    if (child) {\n      container.insertBefore(child.cloneNode(true), null);\n    }\n  });\n  return container;\n}\n\nfunction insertAllAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode) {\n  var frag, len, i;\n  // poor man's node and array check, should be enough for this\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\" && typeof nodeOrNodeArrayToInsert.length === \"undefined\") {\n    throw new Error(\"Expected a single node or a node array\");\n  }\n\n  if (typeof nodeOrNodeArrayToInsert.nodeType !== \"undefined\") {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert, insertAfterNode);\n    return;\n  }\n\n  if (nodeOrNodeArrayToInsert.length === 1) {\n    ko.virtualElements.insertAfter(containerNode, nodeOrNodeArrayToInsert[0], insertAfterNode);\n    return;\n  }\n\n  if (supportsDocumentFragment) {\n    frag = document.createDocumentFragment();\n\n    for (i = 0, len = nodeOrNodeArrayToInsert.length; i !== len; ++i) {\n      frag.appendChild(nodeOrNodeArrayToInsert[i]);\n    }\n    ko.virtualElements.insertAfter(containerNode, frag, insertAfterNode);\n  } else {\n    // Nodes are inserted in reverse order - pushed down immediately after\n    // the last node for the previous item or as the first node of element.\n    for (i = nodeOrNodeArrayToInsert.length - 1; i >= 0; --i) {\n      var child = nodeOrNodeArrayToInsert[i];\n      if (!child) {\n        return;\n      }\n      ko.virtualElements.insertAfter(containerNode, child, insertAfterNode);\n    }\n  }\n}\n\n// Mimic a KO change item 'add'\nfunction valueToChangeAddItem(value, index) {\n  return {\n    status: 'added',\n    value: value,\n    index: index\n  };\n}\n\nfunction isAdditionAdjacentToLast(changeIndex, arrayChanges) {\n  return changeIndex > 0 &&\n    changeIndex < arrayChanges.length &&\n    arrayChanges[changeIndex].status === \"added\" &&\n    arrayChanges[changeIndex - 1].status === \"added\" &&\n    arrayChanges[changeIndex - 1].index === arrayChanges[changeIndex].index - 1;\n}\n\nfunction FastForEach(spec) {\n  this.element = spec.element;\n  this.container = isVirtualNode(this.element) ?\n                   this.element.parentNode : this.element;\n  this.$context = spec.$context;\n  this.data = spec.data;\n  this.as = spec.as;\n  this.noContext = spec.noContext;\n  this.templateNode = makeTemplateNode(\n    spec.name ? document.getElementById(spec.name).cloneNode(true) : spec.element\n  );\n  this.afterQueueFlush = spec.afterQueueFlush;\n  this.beforeQueueFlush = spec.beforeQueueFlush;\n  this.changeQueue = [];\n  this.lastNodesList = [];\n  this.indexesToDelete = [];\n  this.rendering_queued = false;\n\n  // Remove existing content.\n  ko.virtualElements.emptyNode(this.element);\n\n  // Prime content\n  var primeData = ko.unwrap(this.data);\n  if (primeData.map) {\n    this.onArrayChange(primeData.map(valueToChangeAddItem));\n  }\n\n  // Watch for changes\n  if (ko.isObservable(this.data)) {\n    if (!this.data.indexOf) {\n      // Make sure the observable is trackable.\n      this.data = this.data.extend({trackArrayChanges: true});\n    }\n    this.changeSubs = this.data.subscribe(this.onArrayChange, this, 'arrayChange');\n  }\n}\n\n\nFastForEach.animateFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame ||\n  window.mozRequestAnimationFrame || window.msRequestAnimationFrame ||\n  function(cb) { return window.setTimeout(cb, 1000 / 60); };\n\n\nFastForEach.prototype.dispose = function () {\n  if (this.changeSubs) {\n    this.changeSubs.dispose();\n  }\n};\n\n\n// If the array changes we register the change.\nFastForEach.prototype.onArrayChange = function (changeSet) {\n  var self = this;\n  var changeMap = {\n    added: [],\n    deleted: []\n  };\n  for (var i = 0, len = changeSet.length; i < len; i++) {\n    // the change is appended to a last change info object when both are 'added' and have indexes next to each other\n    // here I presume that ko is sending changes in monotonic order (in index variable) which happens to be true, tested with push and splice with multiple pushed values\n    if (isAdditionAdjacentToLast(i, changeSet)) {\n      var batchValues = changeMap.added[changeMap.added.length - 1].values;\n      if (!batchValues) {\n        // transform the last addition into a batch addition object\n        var lastAddition = changeMap.added.pop();\n        var batchAddition = {\n          isBatch: true,\n          status: 'added',\n          index: lastAddition.index,\n          values: [lastAddition.value]\n        };\n        batchValues = batchAddition.values;\n        changeMap.added.push(batchAddition);\n      }\n      batchValues.push(changeSet[i].value);\n    } else {\n      changeMap[changeSet[i].status].push(changeSet[i]);\n    }\n  }\n  if (changeMap.deleted.length > 0) {\n    this.changeQueue.push.apply(this.changeQueue, changeMap.deleted);\n    this.changeQueue.push({status: 'clearDeletedIndexes'});\n  }\n  this.changeQueue.push.apply(this.changeQueue, changeMap.added);\n  // Once a change is registered, the ticking count-down starts for the processQueue.\n  if (this.changeQueue.length > 0 && !this.rendering_queued) {\n    this.rendering_queued = true;\n    FastForEach.animateFrame.call(window, function () { self.processQueue(); });\n  }\n};\n\n\n// Reflect all the changes in the queue in the DOM, then wipe the queue.\nFastForEach.prototype.processQueue = function () {\n  var self = this;\n\n  // Callback so folks can do things before the queue flush.\n  if (typeof this.beforeQueueFlush === 'function') {\n    this.beforeQueueFlush(this.changeQueue);\n  }\n\n  ko.utils.arrayForEach(this.changeQueue, function (changeItem) {\n    // console.log(self.data(), \"CI\", JSON.stringify(changeItem, null, 2), JSON.stringify($(self.element).text()))\n    self[changeItem.status](changeItem);\n    // console.log(\"  ==> \", JSON.stringify($(self.element).text()))\n  });\n  this.rendering_queued = false;\n  // Callback so folks can do things.\n  if (typeof this.afterQueueFlush === 'function') {\n    this.afterQueueFlush(this.changeQueue);\n  }\n  this.changeQueue = [];\n};\n\n\n// Process a changeItem with {status: 'added', ...}\nFastForEach.prototype.added = function (changeItem) {\n  var index = changeItem.index;\n  var valuesToAdd = changeItem.isBatch ? changeItem.values : [changeItem.value];\n  var referenceElement = this.lastNodesList[index - 1] || null;\n  // gather all childnodes for a possible batch insertion\n  var allChildNodes = [];\n\n  for (var i = 0, len = valuesToAdd.length; i < len; ++i) {\n    var templateClone = this.templateNode.cloneNode(true);\n    var childContext;\n\n    if (this.noContext) {\n      childContext = this.$context.extend({\n        '$item': valuesToAdd[i]\n      });\n    } else {\n      childContext = this.$context.createChildContext(valuesToAdd[i], this.as || null);\n    }\n\n    // apply bindings first, and then process child nodes, because bindings can add childnodes\n    ko.applyBindingsToDescendants(childContext, templateClone);\n\n    var childNodes = ko.virtualElements.childNodes(templateClone);\n    // Note discussion at https://github.com/angular/angular.js/issues/7851\n    allChildNodes.push.apply(allChildNodes, Array.prototype.slice.call(childNodes));\n    this.lastNodesList.splice(index + i, 0, childNodes[childNodes.length - 1]);\n  }\n\n  insertAllAfter(this.element, allChildNodes, referenceElement);\n};\n\n\n// Process a changeItem with {status: 'deleted', ...}\nFastForEach.prototype.deleted = function (changeItem) {\n  var index = changeItem.index;\n  var ptr = this.lastNodesList[index],\n      // We use this.element because that will be the last previous node\n      // for virtual element lists.\n      lastNode = this.lastNodesList[index - 1] || this.element;\n  do {\n    ptr = ptr.previousSibling;\n    ko.removeNode((ptr && ptr.nextSibling) || ko.virtualElements.firstChild(this.element));\n  } while (ptr && ptr !== lastNode);\n  // The \"last node\" in the DOM from which we begin our delets of the next adjacent node is\n  // now the sibling that preceded the first node of this item.\n  this.lastNodesList[index] = this.lastNodesList[index - 1];\n  this.indexesToDelete.push(index);\n};\n\n\n// We batch our deletion of item indexes in our parallel array.\n// See brianmhunt/knockout-fast-foreach#6/#8\nFastForEach.prototype.clearDeletedIndexes = function () {\n  // We iterate in reverse on the presumption (following the unit tests) that KO's diff engine\n  // processes diffs (esp. deletes) monotonically ascending i.e. from index 0 -> N.\n  for (var i = this.indexesToDelete.length - 1; i >= 0; --i) {\n    this.lastNodesList.splice(this.indexesToDelete[i], 1);\n  }\n  this.indexesToDelete = [];\n};\n\n\nko.bindingHandlers.fastForEach = {\n  // Valid valueAccessors:\n  //    []\n  //    ko.observable([])\n  //    ko.observableArray([])\n  //    ko.computed\n  //    {data: array, name: string, as: string}\n  init: function init(element, valueAccessor, bindings, vm, context) {\n    var value = valueAccessor(),\n        ffe;\n    if (isPlainObject(value)) {\n      value.element = value.element || element;\n      value.$context = context;\n      ffe = new FastForEach(value);\n    } else {\n      ffe = new FastForEach({\n        element: element,\n        data: ko.unwrap(context.$rawData) === value ? context.$rawData : value,\n        $context: context\n      });\n    }\n    ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n      ffe.dispose();\n    });\n    return {controlsDescendantBindings: true};\n  },\n\n  // Export for testing, debugging, and overloading.\n  FastForEach: FastForEach\n};\n\nko.virtualElements.allowedBindings.fastForEach = true;\n}));","knockoutjs/knockout-repeat.js":"// REPEAT binding for Knockout http://knockoutjs.com/\n// (c) Michael Best\n// License: MIT (http://www.opensource.org/licenses/mit-license.php)\n// Version 2.1.0\n\n(function(factory) {\n    if (typeof define === 'function' && define.amd) {\n        // [1] AMD anonymous module\n        define(['knockout'], factory);\n    } else if (typeof exports === 'object') {\n        // [2] commonJS\n        factory(require('knockout'));\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window.ko);\n    }\n})(function(ko) {\n\nif (!ko.virtualElements)\n    throw Error('Repeat requires at least Knockout 2.1');\n\nvar ko_bindingFlags = ko.bindingFlags || {};\nvar ko_unwrap = ko.utils.unwrapObservable;\n\nvar koProtoName = '__ko_proto__';\n\nif (ko.version >= \"3.0.0\") {\n    // In Knockout 3.0.0, use the node preprocessor to replace a node with a repeat binding with a virtual element\n    var provider = ko.bindingProvider.instance, previousPreprocessFn = provider.preprocessNode;\n    provider.preprocessNode = function(node) {\n        var newNodes, nodeBinding;\n        if (!previousPreprocessFn || !(newNodes = previousPreprocessFn.call(this, node))) {\n            if (node.nodeType === 1 && (nodeBinding = node.getAttribute('data-bind'))) {\n                if (/^\\s*repeat\\s*:/.test(nodeBinding)) {\n                    var leadingComment = node.ownerDocument.createComment('ko ' + nodeBinding),\n                        trailingComment = node.ownerDocument.createComment('/ko');\n                    node.parentNode.insertBefore(leadingComment, node);\n                    node.parentNode.insertBefore(trailingComment, node.nextSibling);\n                    node.removeAttribute('data-bind');\n                    newNodes = [leadingComment, node, trailingComment];\n                }\n            }\n        }\n        return newNodes;\n    };\n}\n\nko.virtualElements.allowedBindings.repeat = true;\nko.bindingHandlers.repeat = {\n    flags: ko_bindingFlags.contentBind | ko_bindingFlags.canUseVirtual,\n    init: function(element, valueAccessor, allBindingsAccessor, xxx, bindingContext) {\n\n        // Read and set fixed options--these options cannot be changed\n        var repeatParam = ko_unwrap(valueAccessor());\n        if (repeatParam && typeof repeatParam == 'object' && !('length' in repeatParam)) {\n            var repeatIndex = repeatParam.index,\n                repeatData = repeatParam.item,\n                repeatStep = repeatParam.step,\n                repeatReversed = repeatParam.reverse,\n                repeatBind = repeatParam.bind,\n                repeatInit = repeatParam.init,\n                repeatUpdate = repeatParam.update;\n        }\n        // Set default values for options that need it\n        repeatIndex = repeatIndex || '$index';\n        repeatData = repeatData || ko.bindingHandlers.repeat.itemName || '$item';\n        repeatStep = repeatStep || 1;\n        repeatReversed = repeatReversed || false;\n\n        var parent = element.parentNode, placeholder;\n        if (element.nodeType == 8) {    // virtual element\n            // Extract the \"children\" and find the single element node\n            var childNodes = ko.utils.arrayFilter(ko.virtualElements.childNodes(element), function(node) { return node.nodeType == 1;});\n            if (childNodes.length !== 1) {\n                throw Error(\"Repeat binding requires a single element to repeat\");\n            }\n            ko.virtualElements.emptyNode(element);\n\n            // The placeholder is the closing comment normally, or the opening comment if reversed\n            placeholder = repeatReversed ? element : element.nextSibling;\n            // The element to repeat is the contained element\n            element = childNodes[0];\n        } else {    // regular element\n            // First clean the element node and remove node's binding\n            var origBindString = element.getAttribute('data-bind');\n            ko.cleanNode(element);\n            element.removeAttribute('data-bind');\n\n            // Original element is no longer needed: delete it and create a placeholder comment\n            placeholder = element.ownerDocument.createComment('ko_repeatplaceholder ' + origBindString);\n            parent.replaceChild(placeholder, element);\n        }\n\n        // extract and remove a data-repeat-bind attribute, if present\n        if (!repeatBind) {\n            repeatBind = element.getAttribute('data-repeat-bind');\n            if (repeatBind) {\n                element.removeAttribute('data-repeat-bind');\n            }\n        }\n\n        // Make a copy of the element node to be copied for each repetition\n        var cleanNode = element.cloneNode(true);\n        if (typeof repeatBind == \"string\") {\n            cleanNode.setAttribute('data-bind', repeatBind);\n            repeatBind = null;\n        }\n\n        // Set up persistent data\n        var lastRepeatCount = 0,\n            notificationObservable = ko.observable(),\n            repeatArray, arrayObservable;\n\n        if (repeatInit) {\n            repeatInit(parent);\n        }\n\n        var subscribable = ko.computed(function() {\n            function makeArrayItemAccessor(index) {\n                var f = function(newValue) {\n                    var item = repeatArray[index];\n                    // Reading the value of the item\n                    if (!arguments.length) {\n                        notificationObservable();   // for dependency tracking\n                        return ko_unwrap(item);\n                    }\n                    // Writing a value to the item\n                    if (ko.isObservable(item)) {\n                        item(newValue);\n                    } else if (arrayObservable && arrayObservable.splice) {\n                        arrayObservable.splice(index, 1, newValue);\n                    } else {\n                        repeatArray[index] = newValue;\n                    }\n                    return this;\n                };\n                // Pretend that our accessor function is an observable\n                f[koProtoName] = ko.observable;\n                return f;\n            }\n\n            function makeBinding(item, index, context) {\n                return repeatArray\n                    ? function() { return repeatBind.call(bindingContext.$data, item, index, context); }\n                    : function() { return repeatBind.call(bindingContext.$data, index, context); }\n            }\n\n            // Read and set up variable options--these options can change and will update the binding\n            var paramObservable = valueAccessor(), repeatParam = ko_unwrap(paramObservable), repeatCount = 0;\n            if (repeatParam && typeof repeatParam == 'object') {\n                if ('length' in repeatParam) {\n                    repeatArray = repeatParam;\n                    repeatCount = repeatArray.length;\n                } else {\n                    if ('foreach' in repeatParam) {\n                        repeatArray = ko_unwrap(paramObservable = repeatParam.foreach);\n                        if (repeatArray && typeof repeatArray == 'object' && 'length' in repeatArray) {\n                            repeatCount = repeatArray.length || 0;\n                        } else {\n                            repeatCount = repeatArray || 0;\n                            repeatArray = null;\n                        }\n                    }\n                    // If a count value is provided (>0), always output that number of items\n                    if ('count' in repeatParam)\n                        repeatCount = ko_unwrap(repeatParam.count) || repeatCount;\n                    // If a limit is provided, don't output more than the limit\n                    if ('limit' in repeatParam)\n                        repeatCount = Math.min(repeatCount, ko_unwrap(repeatParam.limit)) || repeatCount;\n                }\n                arrayObservable = repeatArray && ko.isObservable(paramObservable) ? paramObservable : null;\n            } else {\n                repeatCount = repeatParam || 0;\n            }\n\n            // Remove nodes from end if array is shorter\n            for (; lastRepeatCount > repeatCount; lastRepeatCount-=repeatStep) {\n                ko.removeNode(repeatReversed ? placeholder.nextSibling : placeholder.previousSibling);\n            }\n\n            // Notify existing nodes of change\n            notificationObservable.notifySubscribers();\n\n            // Add nodes to end if array is longer (also initially populates nodes)\n            for (; lastRepeatCount < repeatCount; lastRepeatCount+=repeatStep) {\n                // Clone node and add to document\n                var newNode = cleanNode.cloneNode(true);\n                parent.insertBefore(newNode, repeatReversed ? placeholder.nextSibling : placeholder);\n                newNode.setAttribute('data-repeat-index', lastRepeatCount);\n\n                // Apply bindings to inserted node\n                if (repeatArray && repeatData == '$data') {\n                    var newContext = bindingContext.createChildContext(makeArrayItemAccessor(lastRepeatCount));\n                } else {\n                    var newContext = bindingContext.extend();\n                    if (repeatArray)\n                        newContext[repeatData] = makeArrayItemAccessor(lastRepeatCount);\n                }\n                newContext[repeatIndex] = lastRepeatCount;\n                if (repeatBind) {\n                    var result = ko.applyBindingsToNode(newNode, makeBinding(newContext[repeatData], lastRepeatCount, newContext), newContext, true),\n                        shouldBindDescendants = result && result.shouldBindDescendants;\n                }\n                if (!repeatBind || (result && shouldBindDescendants !== false)) {\n                    ko.applyBindings(newContext, newNode);\n                }\n            }\n            if (repeatUpdate) {\n                repeatUpdate(parent);\n            }\n        }, null, {disposeWhenNodeIsRemoved: placeholder});\n\n        return { controlsDescendantBindings: true, subscribable: subscribable };\n    }\n};\n});","knockoutjs/knockout-es5.js":"/*!\n * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5\n * Copyright (c) Steve Sanderson\n * MIT license\n */\n\n(function(global, undefined) {\n  'use strict';\n\n  var ko;\n\n  // Model tracking\n  // --------------\n  //\n  // This is the central feature of Knockout-ES5. We augment model objects by converting properties\n  // into ES5 getter/setter pairs that read/write an underlying Knockout observable. This means you can\n  // use plain JavaScript syntax to read/write the property while still getting the full benefits of\n  // Knockout's automatic dependency detection and notification triggering.\n  //\n  // For comparison, here's Knockout ES3-compatible syntax:\n  //\n  //     var firstNameLength = myModel.user().firstName().length; // Read\n  //     myModel.user().firstName('Bert'); // Write\n  //\n  // ... versus Knockout-ES5 syntax:\n  //\n  //     var firstNameLength = myModel.user.firstName.length; // Read\n  //     myModel.user.firstName = 'Bert'; // Write\n\n  // `ko.track(model)` converts each property on the given model object into a getter/setter pair that\n  // wraps a Knockout observable. Optionally specify an array of property names to wrap; otherwise we\n  // wrap all properties. If any of the properties are already observables, we replace them with\n  // ES5 getter/setter pairs that wrap your original observable instances. In the case of readonly\n  // ko.computed properties, we simply do not define a setter (so attempted writes will be ignored,\n  // which is how ES5 readonly properties normally behave).\n  //\n  // By design, this does *not* recursively walk child object properties, because making literally\n  // everything everywhere independently observable is usually unhelpful. When you do want to track\n  // child object properties independently, define your own class for those child objects and put\n  // a separate ko.track call into its constructor --- this gives you far more control.\n  /**\n   * @param {object} obj\n   * @param {object|array.<string>} propertyNamesOrSettings\n   * @param {boolean} propertyNamesOrSettings.deep Use deep track.\n   * @param {array.<string>} propertyNamesOrSettings.fields Array of property names to wrap.\n   * todo: @param {array.<string>} propertyNamesOrSettings.exclude Array of exclude property names to wrap.\n   * todo: @param {function(string, *):boolean} propertyNamesOrSettings.filter Function to filter property \n   *   names to wrap. A function that takes ... params\n   * @return {object}\n   */\n  function track(obj, propertyNamesOrSettings) {\n    if (!obj || typeof obj !== 'object') {\n      throw new Error('When calling ko.track, you must pass an object as the first parameter.');\n    }\n\n    var propertyNames;\n\n    if ( isPlainObject(propertyNamesOrSettings) ) {\n      // defaults\n      propertyNamesOrSettings.deep = propertyNamesOrSettings.deep || false;\n      propertyNamesOrSettings.fields = propertyNamesOrSettings.fields || Object.getOwnPropertyNames(obj);\n      propertyNamesOrSettings.lazy = propertyNamesOrSettings.lazy || false;\n\n      wrap(obj, propertyNamesOrSettings.fields, propertyNamesOrSettings);\n    } else {\n      propertyNames = propertyNamesOrSettings || Object.getOwnPropertyNames(obj);\n      wrap(obj, propertyNames, {});\n    }\n\n    return obj;\n  }\n\n  // fix for ie\n  var rFunctionName = /^function\\s*([^\\s(]+)/;\n  function getFunctionName( ctor ){\n    if (ctor.name) {\n      return ctor.name;\n    }\n    return (ctor.toString().trim().match( rFunctionName ) || [])[1];\n  }\n\n  function canTrack(obj) {\n    return obj && typeof obj === 'object' && getFunctionName(obj.constructor) === 'Object';\n  }\n\n  function createPropertyDescriptor(originalValue, prop, map) {\n    var isObservable = ko.isObservable(originalValue);\n    var isArray = !isObservable && Array.isArray(originalValue);\n    var observable = isObservable ? originalValue\n        : isArray ? ko.observableArray(originalValue)\n        : ko.observable(originalValue);\n\n    map[prop] = function () { return observable; };\n\n    // add check in case the object is already an observable array\n    if (isArray || (isObservable && 'push' in observable)) {\n      notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n    }\n\n    return {\n      configurable: true,\n      enumerable: true,\n      get: observable,\n      set: ko.isWriteableObservable(observable) ? observable : undefined\n    };\n  }\n\n  function createLazyPropertyDescriptor(originalValue, prop, map) {\n    if (ko.isObservable(originalValue)) {\n      // no need to be lazy if we already have an observable\n      return createPropertyDescriptor(originalValue, prop, map);\n    }\n\n    var observable;\n\n    function getOrCreateObservable(value, writing) {\n      if (observable) {\n        return writing ? observable(value) : observable;\n      }\n\n      if (Array.isArray(value)) {\n        observable = ko.observableArray(value);\n        notifyWhenPresentOrFutureArrayValuesMutate(ko, observable);\n        return observable;\n      }\n\n      return (observable = ko.observable(value));\n    }\n\n    map[prop] = function () { return getOrCreateObservable(originalValue); };\n    return {\n      configurable: true,\n      enumerable: true,\n      get: function () { return getOrCreateObservable(originalValue)(); },\n      set: function (value) { getOrCreateObservable(value, true); }\n    };\n  }\n\n  function wrap(obj, props, options) {\n    if (!props.length) {\n      return;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, true);\n    var descriptors = {};\n\n    props.forEach(function (prop) {\n      // Skip properties that are already tracked\n      if (prop in allObservablesForObject) {\n        return;\n      }\n\n      // Skip properties where descriptor can't be redefined\n      if (Object.getOwnPropertyDescriptor(obj, prop).configurable === false){\n        return;\n      }\n\n      var originalValue = obj[prop];\n      descriptors[prop] = (options.lazy ? createLazyPropertyDescriptor : createPropertyDescriptor)\n        (originalValue, prop, allObservablesForObject);\n\n      if (options.deep && canTrack(originalValue)) {\n        wrap(originalValue, Object.keys(originalValue), options);\n      }\n    });\n\n    Object.defineProperties(obj, descriptors);\n  }\n\n  function isPlainObject( obj ){\n    return !!obj && typeof obj === 'object' && obj.constructor === Object;\n  }\n\n  // Lazily created by `getAllObservablesForObject` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var objectToObservableMap;\n\n  // Gets or creates the hidden internal key-value collection of observables corresponding to\n  // properties on the model object.\n  function getAllObservablesForObject(obj, createIfNotDefined) {\n    if (!objectToObservableMap) {\n      objectToObservableMap = weakMapFactory();\n    }\n\n    var result = objectToObservableMap.get(obj);\n    if (!result && createIfNotDefined) {\n      result = {};\n      objectToObservableMap.set(obj, result);\n    }\n    return result;\n  }\n\n  // Removes the internal references to observables mapped to the specified properties\n  // or the entire object reference if no properties are passed in. This allows the\n  // observables to be replaced and tracked again.\n  function untrack(obj, propertyNames) {\n    if (!objectToObservableMap) {\n      return;\n    }\n\n    if (arguments.length === 1) {\n      objectToObservableMap['delete'](obj);\n    } else {\n      var allObservablesForObject = getAllObservablesForObject(obj, false);\n      if (allObservablesForObject) {\n        propertyNames.forEach(function(propertyName) {\n          delete allObservablesForObject[propertyName];\n        });\n      }\n    }\n  }\n\n  // Computed properties\n  // -------------------\n  //\n  // The preceding code is already sufficient to upgrade ko.computed model properties to ES5\n  // getter/setter pairs (or in the case of readonly ko.computed properties, just a getter).\n  // These then behave like a regular property with a getter function, except they are smarter:\n  // your evaluator is only invoked when one of its dependencies changes. The result is cached\n  // and used for all evaluations until the next time a dependency changes).\n  //\n  // However, instead of forcing developers to declare a ko.computed property explicitly, it's\n  // nice to offer a utility function that declares a computed getter directly.\n\n  // Implements `ko.defineProperty`\n  function defineComputedProperty(obj, propertyName, evaluatorOrOptions) {\n    var ko = this,\n      computedOptions = { owner: obj, deferEvaluation: true };\n\n    if (typeof evaluatorOrOptions === 'function') {\n      computedOptions.read = evaluatorOrOptions;\n    } else {\n      if ('value' in evaluatorOrOptions) {\n        throw new Error('For ko.defineProperty, you must not specify a \"value\" for the property. ' +\n                        'You must provide a \"get\" function.');\n      }\n\n      if (typeof evaluatorOrOptions.get !== 'function') {\n        throw new Error('For ko.defineProperty, the third parameter must be either an evaluator function, ' +\n                        'or an options object containing a function called \"get\".');\n      }\n\n      computedOptions.read = evaluatorOrOptions.get;\n      computedOptions.write = evaluatorOrOptions.set;\n    }\n\n    obj[propertyName] = ko.computed(computedOptions);\n    track.call(ko, obj, [propertyName]);\n    return obj;\n  }\n\n  // Array handling\n  // --------------\n  //\n  // Arrays are special, because unlike other property types, they have standard mutator functions\n  // (`push`/`pop`/`splice`/etc.) and it's desirable to trigger a change notification whenever one of\n  // those mutator functions is invoked.\n  //\n  // Traditionally, Knockout handles this by putting special versions of `push`/`pop`/etc. on observable\n  // arrays that mutate the underlying array and then trigger a notification. That approach doesn't\n  // work for Knockout-ES5 because properties now return the underlying arrays, so the mutator runs\n  // in the context of the underlying array, not any particular observable:\n  //\n  //     // Operates on the underlying array value\n  //     myModel.someCollection.push('New value');\n  //\n  // To solve this, Knockout-ES5 detects array values, and modifies them as follows:\n  //  1. Associates a hidden subscribable with each array instance that it encounters\n  //  2. Intercepts standard mutators (`push`/`pop`/etc.) and makes them trigger the subscribable\n  // Then, for model properties whose values are arrays, the property's underlying observable\n  // subscribes to the array subscribable, so it can trigger a change notification after mutation.\n\n  // Given an observable that underlies a model property, watch for any array value that might\n  // be assigned as the property value, and hook into its change events\n  function notifyWhenPresentOrFutureArrayValuesMutate(ko, observable) {\n    var watchingArraySubscription = null;\n    ko.computed(function () {\n      // Unsubscribe to any earlier array instance\n      if (watchingArraySubscription) {\n        watchingArraySubscription.dispose();\n        watchingArraySubscription = null;\n      }\n\n      // Subscribe to the new array instance\n      var newArrayInstance = observable();\n      if (newArrayInstance instanceof Array) {\n        watchingArraySubscription = startWatchingArrayInstance(ko, observable, newArrayInstance);\n      }\n    });\n  }\n\n  // Listens for array mutations, and when they happen, cause the observable to fire notifications.\n  // This is used to make model properties of type array fire notifications when the array changes.\n  // Returns a subscribable that can later be disposed.\n  function startWatchingArrayInstance(ko, observable, arrayInstance) {\n    var subscribable = getSubscribableForArray(ko, arrayInstance);\n    return subscribable.subscribe(observable);\n  }\n\n  // Lazily created by `getSubscribableForArray` below. Has to be created lazily because the\n  // WeakMap factory isn't available until the module has finished loading (may be async).\n  var arraySubscribablesMap;\n\n  // Gets or creates a subscribable that fires after each array mutation\n  function getSubscribableForArray(ko, arrayInstance) {\n    if (!arraySubscribablesMap) {\n      arraySubscribablesMap = weakMapFactory();\n    }\n\n    var subscribable = arraySubscribablesMap.get(arrayInstance);\n    if (!subscribable) {\n      subscribable = new ko.subscribable();\n      arraySubscribablesMap.set(arrayInstance, subscribable);\n\n      var notificationPauseSignal = {};\n      wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal);\n      addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal);\n    }\n\n    return subscribable;\n  }\n\n  // After each array mutation, fires a notification on the given subscribable\n  function wrapStandardArrayMutators(arrayInstance, subscribable, notificationPauseSignal) {\n    ['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'].forEach(function(fnName) {\n      var origMutator = arrayInstance[fnName];\n      arrayInstance[fnName] = function() {\n        var result = origMutator.apply(this, arguments);\n        if (notificationPauseSignal.pause !== true) {\n          subscribable.notifySubscribers(this);\n        }\n        return result;\n      };\n    });\n  }\n\n  // Adds Knockout's additional array mutation functions to the array\n  function addKnockoutArrayMutators(ko, arrayInstance, subscribable, notificationPauseSignal) {\n    ['remove', 'removeAll', 'destroy', 'destroyAll', 'replace'].forEach(function(fnName) {\n      // Make it a non-enumerable property for consistency with standard Array functions\n      Object.defineProperty(arrayInstance, fnName, {\n        enumerable: false,\n        value: function() {\n          var result;\n\n          // These additional array mutators are built using the underlying push/pop/etc.\n          // mutators, which are wrapped to trigger notifications. But we don't want to\n          // trigger multiple notifications, so pause the push/pop/etc. wrappers and\n          // delivery only one notification at the end of the process.\n          notificationPauseSignal.pause = true;\n          try {\n            // Creates a temporary observableArray that can perform the operation.\n            result = ko.observableArray.fn[fnName].apply(ko.observableArray(arrayInstance), arguments);\n          }\n          finally {\n            notificationPauseSignal.pause = false;\n          }\n          subscribable.notifySubscribers(arrayInstance);\n          return result;\n        }\n      });\n    });\n  }\n\n  // Static utility functions\n  // ------------------------\n  //\n  // Since Knockout-ES5 sets up properties that return values, not observables, you can't\n  // trivially subscribe to the underlying observables (e.g., `someProperty.subscribe(...)`),\n  // or tell them that object values have mutated, etc. To handle this, we set up some\n  // extra utility functions that can return or work with the underlying observables.\n\n  // Returns the underlying observable associated with a model property (or `null` if the\n  // model or property doesn't exist, or isn't associated with an observable). This means\n  // you can subscribe to the property, e.g.:\n  //\n  //     ko.getObservable(model, 'propertyName')\n  //       .subscribe(function(newValue) { ... });\n  function getObservable(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return null;\n    }\n\n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    if (allObservablesForObject && propertyName in allObservablesForObject) {\n      return allObservablesForObject[propertyName]();\n    }\n\n    return null;\n  }\n  \n  // Returns a boolean indicating whether the property on the object has an underlying\n  // observables. This does the check in a way not to create an observable if the\n  // object was created with lazily created observables\n  function isTracked(obj, propertyName) {\n    if (!obj || typeof obj !== 'object') {\n      return false;\n    }\n    \n    var allObservablesForObject = getAllObservablesForObject(obj, false);\n    return !!allObservablesForObject && propertyName in allObservablesForObject;\n  }\n\n  // Causes a property's associated observable to fire a change notification. Useful when\n  // the property value is a complex object and you've modified a child property.\n  function valueHasMutated(obj, propertyName) {\n    var observable = getObservable(obj, propertyName);\n\n    if (observable) {\n      observable.valueHasMutated();\n    }\n  }\n\n  // Module initialisation\n  // ---------------------\n  //\n  // When this script is first evaluated, it works out what kind of module loading scenario\n  // it is in (Node.js or a browser `<script>` tag), stashes a reference to its dependencies\n  // (currently that's just the WeakMap shim), and then finally attaches itself to whichever\n  // instance of Knockout.js it can find.\n\n  // A function that returns a new ES6-compatible WeakMap instance (using ES5 shim if needed).\n  // Instantiated by prepareExports, accounting for which module loader is being used.\n  var weakMapFactory;\n\n  // Extends a Knockout instance with Knockout-ES5 functionality\n  function attachToKo(ko) {\n    ko.track = track;\n    ko.untrack = untrack;\n    ko.getObservable = getObservable;\n    ko.valueHasMutated = valueHasMutated;\n    ko.defineProperty = defineComputedProperty;\n\n    // todo: test it, maybe added it to ko. directly\n    ko.es5 = {\n      getAllObservablesForObject: getAllObservablesForObject,\n      notifyWhenPresentOrFutureArrayValuesMutate: notifyWhenPresentOrFutureArrayValuesMutate,\n      isTracked: isTracked\n    };\n  }\n\n  // Determines which module loading scenario we're in, grabs dependencies, and attaches to KO\n  function prepareExports() {\n    if (typeof exports === 'object' && typeof module === 'object') {\n      // Node.js case - load KO and WeakMap modules synchronously\n      ko = require('knockout');\n      var WM = require('../lib/weakmap');\n      attachToKo(ko);\n      weakMapFactory = function() { return new WM(); };\n      module.exports = ko;\n    } else if (typeof define === 'function' && define.amd) {\n      define(['knockout'], function(koModule) {\n        ko = koModule;\n        attachToKo(koModule);\n        weakMapFactory = function() { return new global.WeakMap(); };\n        return koModule;\n      });\n    } else if ('ko' in global) {\n      // Non-module case - attach to the global instance, and assume a global WeakMap constructor\n      ko = global.ko;\n      attachToKo(global.ko);\n      weakMapFactory = function() { return new global.WeakMap(); };\n    }\n  }\n\n  prepareExports();\n\n})(this);","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * UnsanitizedHtml version of getTax.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTaxUnsanitizedHtml: function (row) {\n            return this.getTax(row);\n        },\n\n        /**\n         * Set price tax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/shipping_method/price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils'\n], function (Component, quote, priceUtils) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Tax/checkout/shipping_method/price'\n        },\n        isDisplayShippingPriceExclTax: window.checkoutConfig.isDisplayShippingPriceExclTax,\n        isDisplayShippingBothPrices: window.checkoutConfig.isDisplayShippingBothPrices,\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isPriceEqual: function (item) {\n            return item['price_excl_tax'] != item['price_incl_tax']; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            //todo add format data\n            return priceUtils.formatPriceLocale(price, quote.getPriceFormat());\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/tax',\n    'Magento_Checkout/js/model/totals'\n], function (Component, totals) {\n    'use strict';\n\n    var isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed;\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        ifShowValue: function () {\n            if (this.isFullMode() && this.getPureValue() == 0) { //eslint-disable-line eqeqeq\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @override\n         */\n        ifShowDetails: function () {\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return this.totals() && totals.getSegment('tax') !== null;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/grand-total'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isDisplayed: function () {\n            return true;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return !!quote.shippingMethod();\n        },\n\n        /**\n         * @override\n         */\n        getShippingMethodTitle: function () {\n            return '(' + this._super() + ')';\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    var displaySubtotalMode = window.checkoutConfig.reviewTotalsDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displaySubtotalMode: displaySubtotalMode,\n            template: 'Magento_Tax/checkout/summary/subtotal'\n        },\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals().subtotal;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displaySubtotalMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingTaxDisplayed: function () {\n            return this.displaySubtotalMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValueInclTax: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['subtotal_incl_tax'];\n            }\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/totals',\n    'mage/translate',\n    'underscore'\n], function (ko, Component, quote, totals, $t, _) {\n    'use strict';\n\n    var isTaxDisplayedInGrandTotal = window.checkoutConfig.includeTaxInGrandTotal,\n        isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed,\n        taxAmount = 0,\n        rates = 0;\n\n    return Component.extend({\n        defaults: {\n            isTaxDisplayedInGrandTotal: isTaxDisplayedInGrandTotal,\n            notCalculatedMessage: $t('Not yet calculated'),\n            template: 'Magento_Tax/checkout/summary/tax'\n        },\n        totals: quote.getTotals(),\n        isFullTaxSummaryDisplayed: isFullTaxSummaryDisplayed,\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowValue: function () {\n            if (this.isFullMode() && this.getPureValue() == 0) { //eslint-disable-line eqeqeq\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowDetails: function () {\n            if (!this.isFullMode()) {\n                return false;\n            }\n\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            var amount = 0,\n                taxTotal;\n\n            if (this.totals()) {\n                taxTotal = totals.getSegment('tax');\n\n                if (taxTotal) {\n                    amount = taxTotal.value;\n                }\n            }\n\n            return amount;\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && totals.getSegment('tax') != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getValue: function () {\n            var amount;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            amount = totals.getSegment('tax').value;\n\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @param {*} amount\n         * @return {*|String}\n         */\n        formatPrice: function (amount) {\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @param {*} parent\n         * @param {*} percentage\n         * @return {*|String}\n         */\n        getTaxAmount: function (parent, percentage) {\n            var totalPercentage = 0;\n\n            taxAmount = parent.amount;\n            rates = parent.rates;\n            _.each(rates, function (rate) {\n                totalPercentage += parseFloat(rate.percent);\n            });\n\n            return this.getFormattedPrice(this.getPercentAmount(taxAmount, totalPercentage, percentage));\n        },\n\n        /**\n         * @param {*} amount\n         * @param {*} totalPercentage\n         * @param {*} percentage\n         * @return {*|String}\n         */\n        getPercentAmount: function (amount, totalPercentage, percentage) {\n            return parseFloat(amount * percentage / totalPercentage);\n        },\n\n        /**\n         * @return {Array}\n         */\n        getDetails: function () {\n            var taxSegment = totals.getSegment('tax');\n\n            if (taxSegment && taxSegment['extension_attributes']) {\n                return taxSegment['extension_attributes']['tax_grandtotal_details'];\n            }\n\n            return [];\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals'\n], function (Component, quote, priceUtils, totals) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isFullTaxSummaryDisplayed: window.checkoutConfig.isFullTaxSummaryDisplayed || false,\n            template: 'Magento_Tax/checkout/summary/grand-total'\n        },\n        totals: quote.getTotals(),\n        isTaxDisplayedInGrandTotal: window.checkoutConfig.includeTaxInGrandTotal || false,\n\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = totals.getSegment('grand_total').value;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getBaseValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['base_grand_total'];\n            }\n\n            return priceUtils.formatPriceLocale(price, quote.getBasePriceFormat());\n        },\n\n        /**\n         * @return {*}\n         */\n        getGrandTotalExclTax: function () {\n            var total = this.totals(),\n                amount;\n\n            if (!total) {\n                return 0;\n            }\n\n            amount = total['grand_total'] - total['tax_amount'];\n\n            if (amount < 0) {\n                amount = 0;\n            }\n\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBaseGrandTotalDisplayNeeded: function () {\n            var total = this.totals();\n\n            if (!total) {\n                return false;\n            }\n\n            return total['base_currency_code'] != total['quote_currency_code']; //eslint-disable-line eqeqeq\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function ($, Component, quote) {\n    'use strict';\n\n    var displayMode = window.checkoutConfig.reviewShippingDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displayMode: displayMode,\n            template: 'Magento_Tax/checkout/summary/shipping'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displayMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingDisplayed: function () {\n            return this.displayMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isExcludingDisplayed: function () {\n            return this.displayMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && quote.shippingMethod() != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getIncludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_incl_tax'];\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*}\n         */\n        getExcludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_amount'];\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/item/details/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/item/details/subtotal'\n], function (subtotal) {\n    'use strict';\n\n    var displayPriceMode = window.checkoutConfig.reviewItemPriceDisplayMode || 'including';\n\n    return subtotal.extend({\n        defaults: {\n            displayPriceMode: displayPriceMode,\n            template: 'Magento_Tax/checkout/summary/item/details/subtotal'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceInclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceExclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueInclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total_incl_tax']);\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueExclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total']);\n        }\n\n    });\n});\n","Magento_Captcha/js/captcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    /**\n     * @api\n     */\n    $.widget('mage.captcha', {\n        options: {\n            refreshClass: 'refreshing',\n            reloadSelector: '.captcha-reload',\n            imageSelector: '.captcha-img',\n            imageLoader: ''\n        },\n\n        /**\n         * Method binds click event to reload image\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', this.options.reloadSelector, $.proxy(this.refresh, this));\n        },\n\n        /**\n         * Method triggers an AJAX request to refresh the CAPTCHA image\n         */\n        refresh: function () {\n            var imageLoader = this.options.imageLoader;\n\n            if (imageLoader) {\n                this.element.find(this.options.imageSelector).attr('src', imageLoader);\n            }\n            this.element.addClass(this.options.refreshClass);\n\n            $.ajax({\n                url: this.options.url,\n                type: 'post',\n                dataType: 'json',\n                context: this,\n                data: {\n                    'formId': this.options.type\n                },\n\n                /**\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    if (response.imgSrc) {\n                        this.element.find(this.options.imageSelector).attr('src', response.imgSrc);\n                    }\n                },\n\n                /** Complete callback. */\n                complete: function () {\n                    this.element.removeClass(this.options.refreshClass);\n                }\n            });\n        }\n    });\n\n    return $.mage.captcha;\n});\n","Magento_Captcha/js/action/refresh.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery', 'mage/url'\n], function ($, urlBuilder) {\n    'use strict';\n\n    return function (refreshUrl, formId, imageSource) {\n        return $.ajax({\n            url: urlBuilder.build(refreshUrl),\n            type: 'POST',\n            data: JSON.stringify({\n                'formId': formId\n            }),\n            global: false,\n            contentType: 'application/json'\n        }).done(\n            function (response) {\n                if (response.imgSrc) {\n                    imageSource(response.imgSrc);\n                }\n            }\n        );\n    };\n});\n","Magento_Captcha/js/model/captcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'Magento_Captcha/js/action/refresh'\n], function ($, ko, refreshAction) {\n    'use strict';\n\n    return function (captchaData) {\n        return {\n            formId: captchaData.formId,\n            imageSource: ko.observable(captchaData.imageSrc),\n            visibility: ko.observable(false),\n            captchaValue: ko.observable(null),\n            isRequired: ko.observable(captchaData.isRequired),\n            isCaseSensitive: captchaData.isCaseSensitive,\n            imageHeight: captchaData.imageHeight,\n            refreshUrl: captchaData.refreshUrl,\n            isLoading: ko.observable(false),\n            timestamp: null,\n\n            /**\n             * @return {String}\n             */\n            getFormId: function () {\n                return this.formId;\n            },\n\n            /**\n             * @param {String} formId\n             */\n            setFormId: function (formId) {\n                this.formId = formId;\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            getIsVisible: function () {\n                return this.visibility();\n            },\n\n            /**\n             * @param {Boolean} flag\n             */\n            setIsVisible: function (flag) {\n                this.visibility(flag);\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            getIsRequired: function () {\n                return this.isRequired();\n            },\n\n            /**\n             * @param {Boolean} flag\n             */\n            setIsRequired: function (flag) {\n                this.isRequired(flag);\n            },\n\n            /**\n             * @return {Boolean}\n             */\n            getIsCaseSensitive: function () {\n                return this.isCaseSensitive;\n            },\n\n            /**\n             * @param {Boolean} flag\n             */\n            setIsCaseSensitive: function (flag) {\n                this.isCaseSensitive = flag;\n            },\n\n            /**\n             * @return {String|Number}\n             */\n            getImageHeight: function () {\n                return this.imageHeight;\n            },\n\n            /**\n             * @param {String|Number}height\n             */\n            setImageHeight: function (height) {\n                this.imageHeight = height;\n            },\n\n            /**\n             * @return {String}\n             */\n            getImageSource: function () {\n                return this.imageSource;\n            },\n\n            /**\n             * @param {String} imageSource\n             */\n            setImageSource: function (imageSource) {\n                this.imageSource(imageSource);\n            },\n\n            /**\n             * @return {String}\n             */\n            getRefreshUrl: function () {\n                return this.refreshUrl;\n            },\n\n            /**\n             * @param {String} url\n             */\n            setRefreshUrl: function (url) {\n                this.refreshUrl = url;\n            },\n\n            /**\n             * @return {*}\n             */\n            getCaptchaValue: function () {\n                return this.captchaValue;\n            },\n\n            /**\n             * @param {*} value\n             */\n            setCaptchaValue: function (value) {\n                this.captchaValue(value);\n            },\n\n            /**\n             * Refresh captcha.\n             */\n            refresh: function () {\n                var refresh,\n                    self = this;\n\n                this.isLoading(true);\n\n                refresh = refreshAction(this.getRefreshUrl(), this.getFormId(), this.getImageSource());\n                $.when(refresh).done(function () {\n                    self.isLoading(false);\n                });\n            }\n        };\n    };\n});\n","Magento_Captcha/js/model/captchaList.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    var captchaList = [];\n\n    return {\n        /**\n         * @param {Object} captcha\n         */\n        add: function (captcha) {\n            captchaList.push(captcha);\n        },\n\n        /**\n         * @param {String} formId\n         * @return {Object}\n         */\n        getCaptchaByFormId: function (formId) {\n            var captcha = null;\n\n            $.each(captchaList, function (key, item) {\n                if (formId === item.formId) {\n                    captcha = item;\n\n                    return false;\n                }\n            });\n\n            return captcha;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getCaptchaList: function () {\n            return captchaList;\n        }\n    };\n});\n","Magento_Captcha/js/view/checkout/loginCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Customer/js/action/login',\n    'underscore'\n],\nfunction (defaultCaptcha, captchaList, loginAction, _) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this,\n                currentCaptcha;\n\n            this._super();\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n\n                loginAction.registerLoginCallback(function (loginData) {\n                    if (loginData['captcha_form_id'] &&\n                        loginData['captcha_form_id'] === self.formId &&\n                        self.isRequired()\n                    ) {\n                        _.defer(self.refresh.bind(self));\n                    }\n                });\n            }\n        }\n    });\n});\n","Magento_Captcha/js/view/checkout/defaultCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Captcha/js/model/captcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Customer/js/customer-data',\n    'underscore'\n], function ($, Component, Captcha, captchaList, customerData, _) {\n    'use strict';\n\n    var captchaConfig;\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Captcha/checkout/captcha'\n        },\n        dataScope: 'global',\n        currentCaptcha: null,\n        subscribedFormIds: [],\n\n        /**\n         * @return {*}\n         */\n        captchaValue: function () {\n            return this.currentCaptcha.getCaptchaValue();\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            if (window[this.configSource] && window[this.configSource].captcha) {\n                captchaConfig = window[this.configSource].captcha;\n                $.each(captchaConfig, function (formId, captchaData) {\n                    var captcha;\n\n                    captchaData.formId = formId;\n                    captcha = Captcha(captchaData);\n                    this.checkCustomerData(formId, customerData.get('captcha')(), captcha);\n                    this.subscribeCustomerData(formId, captcha);\n                    captchaList.add(captcha);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Check customer data for captcha configuration.\n         *\n         * @param {String} formId\n         * @param {Object} captchaData\n         * @param {Object} captcha\n         */\n        checkCustomerData: function (formId, captchaData, captcha) {\n            if (!_.isEmpty(captchaData) &&\n                !_.isEmpty(captchaData[formId]) &&\n                captchaData[formId].timestamp > captcha.timestamp\n            ) {\n                if (!captcha.isRequired() && captchaData[formId].isRequired) {\n                    captcha.refresh();\n                }\n                captcha.isRequired(captchaData[formId].isRequired);\n                captcha.timestamp = captchaData[formId].timestamp;\n            }\n        },\n\n        /**\n         * Subscribe for customer data updates.\n         *\n         * @param {String} formId\n         * @param {Object} captcha\n         */\n        subscribeCustomerData: function (formId, captcha) {\n            if (this.subscribedFormIds.includes(formId) === false) {\n                this.subscribedFormIds.push(formId);\n                customerData.get('captcha').subscribe(function (captchaData) {\n                    this.checkCustomerData(formId, captchaData, captcha);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        getIsLoading: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.isLoading : false;\n        },\n\n        /**\n         * @return {null|Object}\n         */\n        getCurrentCaptcha: function () {\n            return this.currentCaptcha;\n        },\n\n        /**\n         * @param {Object} captcha\n         */\n        setCurrentCaptcha: function (captcha) {\n            this.currentCaptcha = captcha;\n        },\n\n        /**\n         * @return {String|null}\n         */\n        getFormId: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getFormId() : null;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        getIsVisible: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getIsVisible() : false;\n        },\n\n        /**\n         * @param {Boolean} flag\n         */\n        setIsVisible: function (flag) {\n            this.currentCaptcha.setIsVisible(flag);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isRequired: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getIsRequired() : false;\n        },\n\n        /**\n         * Set isRequired on current captcha model.\n         *\n         * @param {Boolean} flag\n         */\n        setIsRequired: function (flag) {\n            this.currentCaptcha.setIsRequired(flag);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isCaseSensitive: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getIsCaseSensitive() : false;\n        },\n\n        /**\n         * @return {String|Number|null}\n         */\n        imageHeight: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getImageHeight() : null;\n        },\n\n        /**\n         * @return {String|null}\n         */\n        getImageSource: function () {\n            return this.currentCaptcha !== null ? this.currentCaptcha.getImageSource() : null;\n        },\n\n        /**\n         * Refresh captcha.\n         */\n        refresh: function () {\n            this.currentCaptcha.refresh();\n        }\n    });\n});\n","Magento_Weee/js/tax-toggle.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} config\n     * @param {jQuery.Event} e\n     */\n    function onToggle(config, e) {\n        var elem = $(e.currentTarget),\n            expandedClassName = config.expandedClassName || 'cart-tax-total-expanded';\n\n        elem.toggleClass(expandedClassName);\n\n        $(config.itemTaxId).toggle();\n    }\n\n    return function (data, el) {\n        $(el).on('click', onToggle.bind(null, data));\n    };\n});\n","Magento_Weee/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Weee/price/adjustment',\n            dataSource: '${ $.parentName }.provider',\n            //Weee configuration constants can be configured from backend\n            inclFptWithDesc: 1,//show FPT and description\n            inclFpt: 0, //show FPT attribute\n            exclFpt: 2, //do not show FPT\n            bothFptPrices: 3 //show price without FPT and with FPT and with description\n        },\n\n        /**\n         * Get Weee attributes.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeAttributes: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'];\n        },\n\n        /**\n         * Get Weee without Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTax: function (taxAmount) {\n            return taxAmount['amount_excl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithoutTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithoutTax(taxAmount);\n        },\n\n        /**\n         * Get Weee with Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTax: function (taxAmount) {\n            return taxAmount['tax_amount_incl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithTax(taxAmount);\n        },\n\n        /**\n         * Get Weee Tax name.\n         *\n         * @param {String} taxAmount\n         * @return {String} Weee name\n         */\n        getWeeTaxAttributeName: function (taxAmount) {\n            return taxAmount['attribute_code'];\n        },\n\n        /**\n         * Set price type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Check if Weee Tax must be shown.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isShown: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'].length;\n        },\n\n        /**\n         * Get Weee final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustment: function (row) {\n            return row['price_info']['extension_attributes']['weee_adjustment'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeAdjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustmentUnsanitizedHtml: function (row) {\n            return this.getWeeeAdjustment(row);\n        },\n\n        /**\n         * Return whether display setting is to display price including FPT only.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFpt: function () {\n            return +this.source.data.displayWeee === this.inclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * price including FPT and FPT description.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFptDescr: function () {\n            return +this.source.data.displayWeee === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price\n         * excluding FPT but including FPT description and final price.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFptDescr: function () {\n            return +this.source.data.displayWeee === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding FPT.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFpt: function () {\n            return +this.source.data.displayWeee === this.bothFptPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclTax: function () {\n            return +this.source.data.displayTaxes === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPricesTax: function () {\n            return +this.source.data.displayTaxes === this.bothFptPrices;\n        }\n    });\n});\n","Magento_Weee/js/view/checkout/summary/weee.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/totals',\n    'Magento_Catalog/js/price-utils'\n], function (Component, quote, totals) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Weee/checkout/summary/weee'\n        },\n        isIncludedInSubtotal: window.checkoutConfig.isIncludedInSubtotal,\n        totals: totals.totals,\n\n        /**\n         * @returns {Number}\n         */\n        getWeeeTaxSegment: function () {\n            var weee = totals.getSegment('weee_tax') || totals.getSegment('weee');\n\n            if (weee !== null && weee.hasOwnProperty('value')) {\n                return weee.value;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Get weee value\n         * @returns {String}\n         */\n        getValue: function () {\n            return this.getFormattedPrice(this.getWeeeTaxSegment());\n        },\n\n        /**\n         * Weee display flag\n         * @returns {Boolean}\n         */\n        isDisplayed: function () {\n            return this.isFullMode() && this.getWeeeTaxSegment() > 0;\n        }\n    });\n});\n","Magento_Weee/js/view/checkout/summary/item/price/row_excl_tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Weee/js/view/checkout/summary/item/price/weee'\n], function (weee) {\n    'use strict';\n\n    return weee.extend({\n        defaults: {\n            template: 'Magento_Weee/checkout/summary/item/price/row_excl_tax'\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getFinalRowDisplayPriceExclTax: function (item) {\n            var rowTotalExclTax = parseFloat(item['row_total']);\n\n            if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalExclTax += parseFloat(item['qty']) *\n                    parseFloat(item['weee_tax_applied_amount']);\n            }\n\n            return rowTotalExclTax;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getRowDisplayPriceExclTax: function (item) {\n            var rowTotalExclTax = parseFloat(item['row_total']);\n\n            if (window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalExclTax += this.getRowWeeeTaxExclTax(item);\n            }\n\n            return rowTotalExclTax;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getRowWeeeTaxExclTax: function (item) {\n            var totalWeeeTaxExclTaxApplied = 0,\n                weeeTaxAppliedAmounts;\n\n            if (item['weee_tax_applied']) {\n                weeeTaxAppliedAmounts = JSON.parse(item['weee_tax_applied']);\n                weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                    totalWeeeTaxExclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount['row_amount'], 0));\n                });\n            }\n\n            return totalWeeeTaxExclTaxApplied;\n        }\n\n    });\n});\n","Magento_Weee/js/view/checkout/summary/item/price/row_incl_tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Weee/js/view/checkout/summary/item/price/weee'\n], function (weee) {\n    'use strict';\n\n    return weee.extend({\n        defaults: {\n            template: 'Magento_Weee/checkout/summary/item/price/row_incl_tax',\n            displayArea: 'row_incl_tax'\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getFinalRowDisplayPriceInclTax: function (item) {\n            var rowTotalInclTax = parseFloat(item['row_total_incl_tax']);\n\n            if (!window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n            }\n\n            return rowTotalInclTax;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Number}\n         */\n        getRowDisplayPriceInclTax: function (item) {\n            var rowTotalInclTax = parseFloat(item['row_total_incl_tax']);\n\n            if (window.checkoutConfig.getIncludeWeeeFlag) {\n                rowTotalInclTax += this.getRowWeeeTaxInclTax(item);\n            }\n\n            return rowTotalInclTax;\n        },\n\n        /**\n         * @param {Object}item\n         * @return {Number}\n         */\n        getRowWeeeTaxInclTax: function (item) {\n            var totalWeeeTaxInclTaxApplied = 0,\n                weeeTaxAppliedAmounts;\n\n            if (item['weee_tax_applied']) {\n                weeeTaxAppliedAmounts = JSON.parse(item['weee_tax_applied']);\n                weeeTaxAppliedAmounts.forEach(function (weeeTaxAppliedAmount) {\n                    totalWeeeTaxInclTaxApplied += parseFloat(Math.max(weeeTaxAppliedAmount['row_amount_incl_tax'], 0));\n                });\n            }\n\n            return totalWeeeTaxInclTaxApplied;\n        }\n\n    });\n});\n","Magento_Weee/js/view/checkout/summary/item/price/weee.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isDisplayPriceWithWeeeDetails: function (item) {\n            if (!parseFloat(item['weee_tax_applied_amount']) || parseFloat(item['weee_tax_applied_amount'] <= 0)) {\n                return false;\n            }\n\n            return window.checkoutConfig.isDisplayPriceWithWeeeDetails;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isDisplayFinalPrice: function (item) {\n            if (!parseFloat(item['weee_tax_applied_amount'])) {\n                return false;\n            }\n\n            return window.checkoutConfig.isDisplayFinalPrice;\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Array}\n         */\n        getWeeeTaxApplied: function (item) {\n            if (item['weee_tax_applied']) {\n                return JSON.parse(item['weee_tax_applied']);\n            }\n\n            return [];\n        }\n    });\n});\n","Magento_Weee/js/view/cart/totals/weee.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Weee/js/view/checkout/summary/weee'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        isFullMode: function () {\n            return true;\n        }\n    });\n});\n","Magento_Bundle/js/product-summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery-ui-modules/widget',\n    'Magento_Bundle/js/price-bundle'\n], function ($, mageTemplate) {\n    'use strict';\n\n    /**\n     * Widget product Summary:\n     * Handles rendering of Bundle options and displays them in the Summary box\n     */\n    $.widget('mage.productSummary', {\n        options: {\n            mainContainer:          '#product_addtocart_form',\n            templates: {\n                summaryBlock:       '[data-template=\"bundle-summary\"]',\n                optionBlock:        '[data-template=\"bundle-option\"]'\n            },\n            optionSelector:         '[data-container=\"options\"]',\n            summaryContainer:       '[data-container=\"product-summary\"]',\n            bundleSummaryContainer: '.bundle-summary'\n        },\n        cache: {},\n\n        /**\n         * Method attaches event observer to the product form\n         * @private\n         */\n        _create: function () {\n            this.element\n                .closest(this.options.mainContainer)\n                .on('updateProductSummary', $.proxy(this._renderSummaryBox, this))\n                .priceBundle({})\n            ;\n        },\n\n        /**\n         * Method extracts data from the event and renders Summary box\n         * using jQuery template mechanism\n         * @param {Event} event\n         * @param {Object} data\n         * @private\n         */\n        _renderSummaryBox: function (event, data) {\n            this.cache.currentElement = data.config;\n            this.cache.currentElementCount = 0;\n\n            // Clear Summary box\n            this.element.html('');\n            this.cache.currentElement.positions.forEach(function (optionId) {\n                this._renderOption(optionId, this.cache.currentElement.selected[optionId]);\n            }, this);\n            this.element\n                .parents(this.options.bundleSummaryContainer)\n                .toggleClass('empty', !this.cache.currentElementCount); // Zero elements equal '.empty' container\n        },\n\n        /**\n         * @param {String} key\n         * @param {String} row\n         * @private\n         */\n        _renderOption: function (key, row) {\n            var template;\n\n            if (row && row.length > 0 && row[0] !== null) {\n                template = this.element\n                    .closest(this.options.summaryContainer)\n                    .find(this.options.templates.summaryBlock)\n                    .html();\n                template = mageTemplate(template.trim(), {\n                    data: {\n                        _label_: this.cache.currentElement.options[key].title\n                    }\n                });\n\n                this.cache.currentKey = key;\n                this.cache.summaryContainer = $(template);\n                this.element.append(this.cache.summaryContainer);\n\n                $.each(row, this._renderOptionRow.bind(this));\n                this.cache.currentElementCount += row.length;\n\n                //Reset Cache\n                this.cache.currentKey = null;\n            }\n        },\n\n        /**\n         * @param {String} key\n         * @param {String} optionIndex\n         * @private\n         */\n        _renderOptionRow: function (key, optionIndex) {\n            var template;\n\n            template = this.element\n                .closest(this.options.summaryContainer)\n                .find(this.options.templates.optionBlock)\n                .html();\n            template = mageTemplate(template.trim(), {\n                data: {\n                    _quantity_: this.cache.currentElement.options[this.cache.currentKey].selections[optionIndex].qty,\n                    _label_: this.cache.currentElement.options[this.cache.currentKey].selections[optionIndex].name\n                }\n            });\n            this.cache.summaryContainer\n                .find(this.options.optionSelector)\n                .append(template);\n        }\n    });\n\n    return $.mage.productSummary;\n});\n","Magento_Bundle/js/slide.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.slide', {\n        options: {\n            slideSpeed: 1500,\n            slideSelector: '#bundle-slide',\n            slideBackSelector: '.bundle-slide-back',\n            bundleProductSelector: '#bundleProduct',\n            bundleOptionsContainer: '#options-container',\n            productViewContainer: '#productView',\n            slidedown: true\n\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            if (this.options.slidedown === true) {\n                $(this.options.slideSelector).on('click', $.proxy(this._show, this));\n                $(this.options.slideBackSelector).on('click', $.proxy(this._hide, this));\n                this.options.autostart && this._show();\n            } else {\n                $(this.options.slideSelector).on('click', $.proxy(this._slide, this));\n                $(this.options.slideBackSelector).on('click', $.proxy(this._slideBack, this));\n                this.options.autostart && this._slide();\n            }\n        },\n\n        /**\n         * slide bundleOptionsContainer over to the main view area\n         * @private\n         */\n        _slide: function () {\n            $(this.options.bundleProductSelector).css('top', '0px');\n            $(this.options.bundleOptionsContainer).show();\n            this.element.css('height', $(this.options.productViewContainer).height() + 'px');\n            $(this.options.bundleProductSelector).css('left', '0px').animate(\n                {\n                    'left': '-' + this.element.width() + 'px'\n                },\n                this.options.slideSpeed,\n                $.proxy(function () {\n                    this.element.css('height', 'auto');\n                    $(this.options.productViewContainer).hide();\n                }, this)\n            );\n        },\n\n        /**\n         * slideback productViewContainer to main view area\n         * @private\n         */\n        _slideBack: function () {\n            $(this.options.bundleProductSelector).css('top', '0px');\n            $(this.options.productViewContainer).show();\n            this.element.css('height', $(this.options.bundleOptionsContainer).height() + 'px');\n            $(this.options.bundleProductSelector).animate(\n                {\n                    'left': '0px'\n                },\n                this.options.slideSpeed,\n                $.proxy(function () {\n                    $(this.options.bundleOptionsContainer).hide();\n                    this.element.css('height', 'auto');\n                }, this)\n            );\n        },\n\n        /**\n         * @private\n         */\n        _show: function () {\n            $(this.options.bundleOptionsContainer).slideDown(800);\n            $('html, body').animate({\n                scrollTop: $(this.options.bundleOptionsContainer).offset().top\n            }, 600);\n            $('#product-options-wrapper > fieldset').trigger('focus');\n        },\n\n        /**\n         * @private\n         */\n        _hide: function () {\n            $('html, body').animate({\n                scrollTop: 0\n            }, 600);\n            $(this.options.bundleOptionsContainer).slideUp(800);\n        }\n    });\n\n    return $.mage.slide;\n});\n","Magento_Bundle/js/price-bundle.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'jquery/jquery.parsequery',\n    'priceBox'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        optionConfig: null,\n        productBundleSelector: 'input.bundle.option, select.bundle.option, textarea.bundle.option',\n        qtyFieldSelector: 'input.qty',\n        priceBoxSelector: '.price-box',\n        optionHandlers: {},\n        optionTemplate: '<%- data.label %>' +\n            '<% if (data.finalPrice.value) { %>' +\n            ' +<%- data.finalPrice.formatted %>' +\n            '<% } %>',\n        controlContainer: 'dd', // should be eliminated\n        priceFormat: {},\n        isFixedPrice: false,\n        optionTierPricesBlocksSelector: '#option-tier-prices-{1} [data-role=\"selection-tier-prices\"]',\n        isOptionsInitialized: false\n    };\n\n    $.widget('mage.priceBundle', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form),\n                qty = $(this.options.qtyFieldSelector, form);\n\n            // Override defaults with URL query parameters and/or inputs values\n            this._overrideDefaults();\n\n            options.trigger('change');\n            qty.trigger('change');\n        },\n\n        /**\n         * @private\n         */\n        _create: function createPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form),\n                priceBox = $(this.options.priceBoxSelector, form),\n                qty = $(this.options.qtyFieldSelector, form);\n\n            this._updatePriceBox();\n            priceBox.on('price-box-initialized', this._updatePriceBox.bind(this));\n            options.on('change', this._onBundleOptionChanged.bind(this));\n            qty.on('change', this._onQtyFieldChanged.bind(this));\n        },\n\n        /**\n         * Override default options values settings with either URL query parameters or\n         * initialized inputs values.\n         * @private\n         */\n        _overrideDefaults: function () {\n            var hashIndex = window.location.href.indexOf('#');\n\n            if (hashIndex !== -1) {\n                this._parseQueryParams(window.location.href.substr(hashIndex + 1));\n            }\n        },\n\n        /**\n         * Parse query parameters from a query string and set options values based on the\n         * key value pairs of the parameters.\n         * @param {*} queryString - URL query string containing query parameters.\n         * @private\n         */\n        _parseQueryParams: function (queryString) {\n            var queryParams = $.parseQuery({\n                    query: queryString\n                }),\n                selectedValues = [],\n                form = this.element,\n                options = $(this.options.productBundleSelector, form),\n                qtys = $(this.options.qtyFieldSelector, form);\n\n            $.each(queryParams, $.proxy(function (key, value) {\n                qtys.each(function (index, qty) {\n                    if (qty.name === key) {\n                        $(qty).val(value);\n                    }\n                });\n                options.each(function (index, option) {\n                    let optionType = $(option).prop('type');\n\n                    if (option.name === key ||\n                        optionType === 'select-multiple'\n                        && key.indexOf(option.name.substr(0, option.name.length - 2)) !== false\n                    ) {\n\n                        switch (optionType) {\n                            case 'radio':\n                                $(option).val() === value ? $(option).prop('checked', true) : '';\n                                break;\n                            case 'checkbox':\n                                $(option).prop('checked', true);\n                                break;\n                            case 'hidden':\n                            case 'select-one':\n                                $(option).val(value);\n                                break;\n                            case 'select-multiple':\n                                selectedValues.push(value);\n                                break;\n                        }\n                        if (optionType === 'select-multiple' && selectedValues.length) {\n                            $(option).val(selectedValues);\n                        }\n                    }\n                });\n            }, this));\n        },\n\n        /**\n         * Update price box config with bundle option prices\n         * @private\n         */\n        _updatePriceBox: function () {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form),\n                priceBox = $(this.options.priceBoxSelector, form);\n\n            if (!this.options.isOptionsInitialized) {\n                if (priceBox.data('magePriceBox') &&\n                    priceBox.priceBox('option') &&\n                    priceBox.priceBox('option').priceConfig\n                ) {\n                    if (priceBox.priceBox('option').priceConfig.optionTemplate) { //eslint-disable-line max-depth\n                        this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                    }\n                    this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n                    priceBox.priceBox('setDefault', this.options.optionConfig.prices);\n                    this.options.isOptionsInitialized = true;\n                }\n                this._applyOptionNodeFix(options);\n            }\n\n            return this;\n        },\n\n        /**\n         * Handle change on bundle option inputs\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onBundleOptionChanged: function onBundleOptionChanged(event) {\n            var changes,\n                bundleOption = $(event.target),\n                priceBox = $(this.options.priceBoxSelector, this.element),\n                handler = this.options.optionHandlers[bundleOption.data('role')];\n\n            bundleOption.data('optionContainer', bundleOption.closest(this.options.controlContainer));\n            bundleOption.data('qtyField', bundleOption.data('optionContainer').find(this.options.qtyFieldSelector));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(bundleOption, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(bundleOption, this.options.optionConfig);//eslint-disable-line\n            }\n\n            // eslint-disable-next-line no-use-before-define\n            if (isValidQty(bundleOption)) {\n                if (changes) {\n                    priceBox.trigger('updatePrice', changes);\n                }\n\n                this._displayTierPriceBlock(bundleOption);\n                this.updateProductSummary();\n            }\n        },\n\n        /**\n         * Handle change on qty inputs near bundle option\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onQtyFieldChanged: function onQtyFieldChanged(event) {\n            var field = $(event.target),\n                optionInstance,\n                optionConfig;\n\n            if (field.data('optionId') && field.data('optionValueId')) {\n                optionInstance = field.data('option');\n                optionConfig = this.options.optionConfig\n                    .options[field.data('optionId')]\n                    .selections[field.data('optionValueId')];\n                optionConfig.qty = field.val();\n\n                // eslint-disable-next-line no-use-before-define\n                if (isValidQty(optionInstance)) {\n                    optionInstance.trigger('change');\n                }\n            }\n        },\n\n        /**\n         * Helper to fix backend behavior:\n         *  - if default qty large than 1 then backend multiply price in config\n         *\n         * @deprecated\n         * @private\n         */\n        _applyQtyFix: function applyQtyFix() {\n            var config = this.options.optionConfig;\n\n            if (config.isFixedPrice) {\n                _.each(config.options, function (option) {\n                    _.each(option.selections, function (item) {\n                        if (item.qty && item.qty !== 1) {\n                            _.each(item.prices, function (price) {\n                                price.amount /= item.qty;\n                            });\n                        }\n                    });\n                });\n            }\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig.options[optionId].selections,\n                    value;\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue].prices;\n\n                    _.each(prices, function (price, type) {\n                        value = +price.amount;\n                        value += _.reduce(price.adjustments, function (sum, x) {//eslint-disable-line\n                            return sum + x;\n                        }, 0);\n                        toTemplate.data[type] = {\n                            value: value,\n                            formatted: utils.formatPriceLocale(value, format)\n                        };\n                    });\n\n                    $option.html(template(toTemplate));\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            this._super(options);\n\n            return this;\n        },\n\n        /**\n         * Show or hide option tier prices block\n         *\n         * @param {Object} optionElement\n         * @private\n         */\n        _displayTierPriceBlock: function (optionElement) {\n            var optionType = optionElement.prop('type'),\n                optionId,\n                optionValue,\n                optionTierPricesElements;\n\n            if (optionType === 'select-one') {\n                optionId = utils.findOptionId(optionElement[0]);\n                optionValue = optionElement.val() || null;\n                optionTierPricesElements = $(this.options.optionTierPricesBlocksSelector.replace('{1}', optionId));\n\n                _.each(optionTierPricesElements, function (tierPriceElement) {\n                    var selectionId = $(tierPriceElement).data('selection-id') + '';\n\n                    if (selectionId === optionValue) {\n                        $(tierPriceElement).show();\n                    } else {\n                        $(tierPriceElement).hide();\n                    }\n                });\n            }\n        },\n\n        /**\n         * Handler to update productSummary box\n         */\n        updateProductSummary: function updateProductSummary() {\n            this.element.trigger('updateProductSummary', {\n                config: this.options.optionConfig\n            });\n        }\n    });\n\n    return $.mage.priceBundle;\n\n    /**\n     * Converts option value to priceBox object\n     *\n     * @param   {jQuery} element\n     * @param   {Object} config\n     * @returns {Object|null} - priceBox object with additional prices\n     */\n    function defaultGetOptionValue(element, config) {\n        var changes = {},\n            optionHash,\n            tempChanges,\n            qtyField,\n            optionId = utils.findOptionId(element[0]),\n            optionValue = element.val() || null,\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = config.options[optionId].selections,\n            optionQty = 0,\n            canQtyCustomize = false,\n            selectedIds = config.selected;\n\n        switch (optionType) {\n            case 'radio':\n            case 'select-one':\n\n                if (optionType === 'radio' && !element.is(':checked')) {\n                    return null;\n                }\n\n                qtyField = element.data('qtyField');\n                qtyField.data('option', element);\n\n                if (optionValue) {\n                    optionQty = optionConfig[optionValue].qty || 0;\n                    canQtyCustomize = optionConfig[optionValue].customQty === '1';\n                    toggleQtyField(qtyField, optionQty, optionId, optionValue, canQtyCustomize);//eslint-disable-line\n                    tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                    tempChanges = applyTierPrice(//eslint-disable-line\n                        tempChanges,\n                        optionQty,\n                        optionConfig[optionValue]\n                    );\n                    tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n                } else {\n                    tempChanges = {};\n                    toggleQtyField(qtyField, '0', optionId, optionValue, false);//eslint-disable-line\n                }\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n\n            case 'select-multiple':\n                optionValue = _.compact(optionValue);\n\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = 'bundle-option-' + optionName + '##' + optionValueCode;\n                    optionQty = row.qty || 0;\n                    tempChanges = utils.deepClone(row.prices);\n                    tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);//eslint-disable-line\n                    tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? tempChanges : {};\n                });\n\n                selectedIds[optionId] = optionValue || [];\n                break;\n\n            case 'checkbox':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);//eslint-disable-line\n                tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n                changes[optionHash] = element.is(':checked') ? tempChanges : {};\n\n                selectedIds[optionId] = selectedIds[optionId] || [];\n\n                if (!_.contains(selectedIds[optionId], optionValue) && element.is(':checked')) {\n                    selectedIds[optionId].push(optionValue);\n                } else if (!element.is(':checked')) {\n                    selectedIds[optionId] = _.without(selectedIds[optionId], optionValue);\n                }\n                break;\n\n            case 'hidden':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                canQtyCustomize = optionConfig[optionValue].customQty === '1';\n                qtyField = element.data('qtyField');\n                qtyField.data('option', element);\n                toggleQtyField(qtyField, optionQty, optionId, optionValue, canQtyCustomize);//eslint-disable-line\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);//eslint-disable-line\n                tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n        }\n\n        return changes;\n    }\n\n    /**\n     * Check the quantity field if negative value occurs.\n     *\n     * @param {Object} bundleOption\n     */\n    function isValidQty(bundleOption) {\n        var isValid = true,\n            qtyElem = bundleOption.data('qtyField'),\n            bundleOptionType = bundleOption.prop('type');\n\n        if (['radio', 'select-one'].includes(bundleOptionType) && qtyElem.val() < 0) {\n            isValid = false;\n        }\n\n        return isValid;\n    }\n\n    /**\n     * Helper to toggle qty field\n     * @param {jQuery} element\n     * @param {String|Number} value\n     * @param {String|Number} optionId\n     * @param {String|Number} optionValueId\n     * @param {Boolean} canEdit\n     */\n    function toggleQtyField(element, value, optionId, optionValueId, canEdit) {\n        element\n            .val(value)\n            .data('optionId', optionId)\n            .data('optionValueId', optionValueId)\n            .attr('disabled', !canEdit);\n\n        if (canEdit) {\n            element.removeClass('qty-disabled');\n        } else {\n            element.addClass('qty-disabled');\n        }\n    }\n\n    /**\n     * Helper to multiply on qty\n     *\n     * @param   {Object} prices\n     * @param   {Number} qty\n     * @returns {Object}\n     */\n    function applyQty(prices, qty) {\n        _.each(prices, function (everyPrice) {\n            everyPrice.amount *= qty;\n            _.each(everyPrice.adjustments, function (el, index) {\n                everyPrice.adjustments[index] *= qty;\n            });\n        });\n\n        return prices;\n    }\n\n    /**\n     * Helper to limit price with tier price\n     *\n     * @param {Object} oneItemPrice\n     * @param {Number} qty\n     * @param {Object} optionConfig\n     * @returns {Object}\n     */\n    function applyTierPrice(oneItemPrice, qty, optionConfig) {\n        var tiers = optionConfig.tierPrice,\n            magicKey = _.keys(oneItemPrice)[0],\n            tiersFirstKey = _.keys(optionConfig)[0],\n            lowest = false;\n\n        if (!tiers) {//tiers is undefined when options has only one option\n            tiers = optionConfig[tiersFirstKey].tierPrice;\n        }\n\n        tiers.sort(function (a, b) {//sorting based on \"price_qty\"\n            return a['price_qty'] - b['price_qty'];\n        });\n\n        _.each(tiers, function (tier, index) {\n            if (tier['price_qty'] > qty) {\n                return;\n            }\n\n            if (tier.prices[magicKey].amount < oneItemPrice[magicKey].amount) {\n                lowest = index;\n            }\n        });\n\n        if (lowest !== false) {\n            oneItemPrice = utils.deepClone(tiers[lowest].prices);\n        }\n\n        return oneItemPrice;\n    }\n});\n","Magento_SendFriend/requirejs-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nvar config = {\n    map: {\n        '*': {\n            'Magento_SendFriend/back-event': 'Magento_SendFriend/js/back-event'\n        }\n    }\n};\n","Magento_SendFriend/js/back-event.js":"/**\n* Copyright \u00a9 Magento, Inc. All rights reserved.\n* See COPYING.txt for license details.\n*/\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).on('click', function () {\n            history.back();\n\n            return false;\n        });\n    };\n});\n","Smile_ElasticsuiteCatalog/js/attribute-filter.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCatalog\n * @author    Aurelien FOUCRET <aurelien.foucret@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'underscore',\n    'mage/translate'\n], function ($, Component, _) {\n    \"use strict\";\n\n    return Component.extend({\n        defaults: {\n            template: \"Smile_ElasticsuiteCatalog/attribute-filter\",\n            showMoreLabel       : $.mage.__(\"Show more\"),\n            showLessLabel       : $.mage.__(\"Show less\"),\n            noSearchResultLabel : $.mage.__(\"No value matching the search <b>%s</b>.\")\n        },\n\n        /**\n         * Component initialization\n         */\n        initialize: function () {\n            this._super();\n            this.expanded = false;\n            this.items = this.items.map(this.addItemId.bind(this));\n            this.observe(['fulltextSearch', 'expanded']);\n\n            var lastSelectedIndex = Math.max.apply(null, (this.items.map(\n                function (v, k) {return v['is_selected'] ? k : 0;}))\n            );\n            this.maxSize = Math.max(this.maxSize, lastSelectedIndex + 1);\n\n            this.initSearchPlaceholder();\n            this.onShowLess();\n            this.displaySearch = this.displayShowMore();\n          \n        },\n\n        /**\n         * Init the place holder\n         */\n        initSearchPlaceholder: function () {\n            var examples = this.items.slice(0, 2).map(function (item) {return item.label});\n\n            if (this.items.length > 2) {\n                examples.push('...');\n            }\n            this.searchPlaceholder = $('<div/>').html($.mage.__('Search (%s)').replace('%s', examples.join(', '))).text();\n        },\n\n        /**\n         * Triggered when typing on the search input\n         */\n        onSearchChange: function (component, ev) {\n            var text = ev.target.value;\n            if (text.trim() === \"\") {\n                component.fulltextSearch(null);\n                component.onShowLess();\n            } else {\n                component.fulltextSearch(text);\n                component.onShowMore();\n            }\n            return true;\n        },\n        \n        /**\n         * Triggered when leaving the search field.\n         */\n        onSearchFocusOut: function(component, ev) {\n            var text = ev.target.value;\n            if (text.trim() === \"\") {\n                component.fulltextSearch(null);\n                ev.target.value = \"\";\n            }\n        },\n\n        /**\n         * Retrieve additional Results\n         *\n         * @param callback\n         */\n        loadAdditionalItems: function (callback) {\n            $.get(this.ajaxLoadUrl, function (data) {\n                this.items = data.map(this.addItemId.bind(this));\n                this.hasMoreItems  = false;\n                \n                if (callback) {\n                    return callback();\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Retrieve items to display\n         *\n         * @returns {*}\n         */\n        getDisplayedItems: function () {\n            var items = this.items;\n            \n            if (this.expanded() === false) {\n                items = this.items.slice(0, this.maxSize);\n            }\n            \n            if (this.fulltextSearch()) {\n               var searchTokens    = this.slugify(this.fulltextSearch()).split('-');\n               var lastSearchToken = searchTokens.splice(-1, 1)[0];\n\n               items = items.filter(function(item) {\n                   var isValidItem = true;\n                   var itemTokens = this.slugify(item.label).split('-');\n                   searchTokens.forEach(function(currentToken) {\n                       if (itemTokens.indexOf(currentToken) === -1) {\n                           isValidItem = false;\n                       }\n                   })\n                   if (isValidItem && lastSearchToken) {\n                       var ngrams = itemTokens.map(function(token) {return token.substring(0, lastSearchToken.length)});\n                       isValidItem = ngrams.indexOf(lastSearchToken) !== -1;\n                   }\n                   return isValidItem;\n               }.bind(this))\n            }\n\n            return items;\n        },\n\n        /**\n         * Does the search have a result\n         */\n        hasSearchResult: function () {\n            return this.getDisplayedItems().length > 0\n        },\n        \n        /**\n         * Search result message\n         */\n        getSearchResultMessage : function() {\n            return this.noSearchResultLabel.replace(\"%s\", '\"' + this.fulltextSearch() + '\"')\n        },\n        \n        /**\n         * Callback for the \"Show more\" button\n         */\n        onShowMore: function () {\n            if (this.hasMoreItems) {\n                this.loadAdditionalItems(this.onShowMore.bind(this));\n            } else {\n                this.expanded(true);\n            }\n        },\n\n        /**\n         * Index the text to be searched.\n         */\n        slugify: function(text) {\n          return text.toString().toLowerCase()\n            .replace(/\\s+/g, '-')                                              // Replace spaces with -\n            .replace(/[^\\w\\u0400-\\u052F\\u2DE0-\\u2DFF\\uA640-\\uA69F'\\-]+/g, '')  // Remove all non-word chars\n            .replace(/\\-\\-+/g, '-')                                            // Replace multiple - with single -\n            .replace(/^-+/, '')                                                // Trim - from start of text\n        },\n        \n        /**\n         * Callback for the \"Show less\" button\n         */\n        onShowLess: function () {\n            this.expanded(false);\n        },\n\n        /**\n         * Check if the filter can be expanded\n         *\n         * @returns {boolean}\n         */\n        enableExpansion : function () {\n           return this.hasMoreItems || this.items.length > this.maxSize;\n        },\n\n        /**\n         * Displays the \"Show More\" link\n         *\n         * @returns {*|boolean}\n         */\n        displayShowMore: function () {\n            return this.enableExpansion() && this.expanded() === false && !this.fulltextSearch();\n        },\n\n        /**\n         * Displays the \"Show Less\" link\n         *\n         * @returns {*|boolean}\n         */\n        displayShowLess: function () {\n            return this.enableExpansion() && this.expanded() === true && !this.fulltextSearch();\n        },\n\n        /**\n         * Add an id to items.\n         */\n        addItemId: function (item) {\n            item.id = _.uniqueId(this.index + \"_option_\");\n            item.displayProductCount = this.displayProductCount && (item.count >= 1);\n\n            return item;\n        },\n    });\n});\n","Smile_ElasticsuiteCatalog/js/range-slider-widget.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCatalog\n * @author    Aurelien FOUCRET <aurelien.foucret@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\n\n/*jshint browser:true jquery:true*/\n/*global alert*/\n\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'mage/template',\n    'Smile_ElasticsuiteCatalog/js/slider',\n    'Magento_Ui/js/modal/modal',\n    'Smile_ElasticsuiteCatalog/js/jquery.ui.touch-punch.min'\n], function ($, priceUtil, mageTemplate) {\n\n    \"use strict\";\n\n    $.widget('smileEs.rangeSlider', {\n\n        options: {\n            fromLabel      : '[data-role=from-label]',\n            toLabel        : '[data-role=to-label]',\n            sliderBar      : '[data-role=slider-bar]',\n            message        : '[data-role=message-box]',\n            applyButton    : '[data-role=apply-range]',\n            rate           : 1.0000,\n            maxLabelOffset : 0.01,\n            messageTemplates : {\n                \"displayOne\": '<span class=\"msg\">1 item</span>',\n                \"displayCount\": '<span class=\"msg\"><%- count %> items</span>',\n                \"displayEmpty\": '<span class=\"msg-error\">No items in the current range.</span>'\n            },\n        },\n\n        _create: function () {\n            this.showAdaptiveSlider = this.options.showAdaptiveSlider;\n            if (this.showAdaptiveSlider) {\n                this._initAdaptiveSliderValues();\n            } else {\n                this._initSliderValues();\n            }\n\n            this._createSlider();\n            this._refreshDisplay();\n            this.element.find(this.options.applyButton).on('click', this._applyRange.bind(this));\n        },\n\n        _initSliderValues: function () {\n            this.rate         = parseFloat(this.options.rate);\n            this.from         = Math.floor(this.options.currentValue.from * this.rate);\n            this.to           = Math.round(this.options.currentValue.to * this.rate);\n            this.intervals    = this.options.intervals.map(\n                function(item) { item.value = Math.round(item.value * this.rate); return item}.bind(this)\n            );\n            this.minValue = Math.floor(this.options.minValue * this.rate);\n            this.maxValue = Math.round(this.options.maxValue * this.rate);\n        },\n\n        _initAdaptiveSliderValues: function () {\n            this.intervals = this.options.adaptiveIntervals;\n            this.from      = this._getAdaptiveValue(Number(this.options.currentValue.from));\n            this.to        = this._getAdaptiveValue(Number(this.options.currentValue.to));\n            this.rate      = parseFloat(this.options.rate);\n            this.intervals = this.intervals.map(\n                function(item) { item.originalValue = Math.ceil(item.originalValue * this.rate); return item}.bind(this)\n            );\n            this.minValue  = this.intervals[0].value;\n            this.maxValue  = this.intervals[this.intervals.length - 1].value;\n        },\n\n        _createSlider: function () {\n            this.element.find(this.options.sliderBar).slider({\n                range: true,\n                min: this.minValue,\n                max: this.maxValue,\n                values: [ this.from, this.to ],\n                slide: this._onSliderChange.bind(this),\n                step: this.options.step\n            });\n        },\n\n        _onSliderChange : function (ev, ui) {\n            this.from = this._getClosestAdaptiveValue(ui.values[0]);\n            this.to   = this._getClosestAdaptiveValue(ui.values[1]);\n            this._refreshDisplay();\n        },\n\n        _refreshDisplay: function () {\n            this.count = this._getItemCount();\n\n            if (this.element.find('[data-role=from-label]')) {\n                this.element.find('[data-role=from-label]').html(this._formatLabel(this._getOriginalValue(this.from)));\n            }\n\n            if (this.element.find('[data-role=to-label]')) {\n                var to = this._getOriginalValue(this.to) - this.options.maxLabelOffset;\n                if (this.showAdaptiveSlider && to < this._getOriginalValue(this.minValue)) {\n                    to = this._getOriginalValue(this.to);\n                }\n                this.element.find('[data-role=to-label]').html(this._formatLabel(to));\n            }\n\n            if (this.element.find('[data-role=message-box]')) {\n                var messageTemplate = this.options.messageTemplates[this.count > 0 ? (this.count > 1 ? 'displayCount' : 'displayOne' ) : 'displayEmpty'];\n                var message = mageTemplate(messageTemplate)(this);\n                this.element.find('[data-role=message-box]').html(message);\n\n                if (this.count > 0) {\n                    this.element.find('[data-role=message-box]').removeClass('empty');\n                } else {\n                    this.element.find('[data-role=message-box]').addClass('empty');\n                }\n\n            }\n        },\n\n        _applyRange : function () {\n            // Do not submit \"rate applied\" values. Revert the rate on submitted values.\n            var range = {\n                from : this._getOriginalValue(this.from) * (1 / this.rate),\n                to   : this._getOriginalValue(this.to) * (1 / this.rate)\n            };\n\n            var url = mageTemplate(this.options.urlTemplate)(range);\n            this.element.find(this.options.applyButton).attr('href', url);\n        },\n\n        _getAdaptiveValue : function (value) {\n            if (!this.showAdaptiveSlider) {\n                return value;\n            }\n\n            var adaptiveValue = this.intervals[0].value;\n            var found = false;\n            this.intervals.forEach(function (item) {\n                if (found === false && item.originalValue === value) {\n                    adaptiveValue = item.value;\n                    found = true;\n                }\n\n                if (found === false && item.originalValue < value) {\n                    adaptiveValue = item.value;\n                }\n            });\n\n            return adaptiveValue;\n        },\n\n        _getClosestAdaptiveValue : function (value) {\n            if (!this.showAdaptiveSlider) {\n                return value;\n            }\n\n            var closestValue = this.intervals[0].value;\n            var found = false;\n            this.intervals.forEach(function (item) {\n                if (item.value === value) {\n                    closestValue = value;\n                    found = true;\n                }\n\n                if (found === false && item.value < value) {\n                    closestValue = item.value;\n                }\n            });\n\n            return closestValue;\n        },\n\n        _getOriginalValue : function (value) {\n            if (!this.showAdaptiveSlider) {\n                return value;\n            }\n\n            var originalValue = null;\n            this.intervals.forEach(function (item) {\n                if (item.value === value) {\n                    originalValue = item.originalValue;\n                }\n            });\n\n            return originalValue;\n        },\n\n        _getItemCount : function () {\n            var from = this.from, to = this.to, intervals = this.intervals;\n\n            var count = intervals.map(function (item) {\n                return (item.value >= from && (item.value < to || ((from === to) && item.value <= to))) ? item.count : 0;\n            })\n            .reduce(function (a,b) {\n                return a + b;\n            });\n            return count;\n        },\n\n        _formatLabel : function (value) {\n            var formattedValue = value;\n\n            if (this.options.fieldFormat) {\n                formattedValue = priceUtil.formatPrice(value, this.options.fieldFormat);\n            }\n\n            return formattedValue;\n        }\n    });\n\n    return $.smileEs.rangeSlider;\n});\n","Smile_ElasticsuiteCatalog/js/jquery.ui.touch-punch.min.js":"/*!\n * jQuery UI Touch Punch 0.2.3\n *\n * Copyright 2011\u20132014, Dave Furfero\n * Dual licensed under the MIT or GPL Version 2 licenses.\n *\n * Depends:\n *  jquery.ui.widget.js\n *  jquery.ui.mouse.js\n */ !function(t){if(t.support.touch=\"ontouchend\"in document,t.support.touch){var o,e=t.ui.mouse.prototype,u=e._mouseInit,n=e._mouseDestroy;e._touchStart=function(t){var e=this;!o&&e._mouseCapture(t.originalEvent.changedTouches[0])&&(o=!0,e._touchMoved=!1,c(t,\"mouseover\"),c(t,\"mousemove\"),c(t,\"mousedown\"))},e._touchMove=function(t){o&&(this._touchMoved=!0,c(t,\"mousemove\"))},e._touchEnd=function(t){o&&(c(t,\"mouseup\"),c(t,\"mouseout\"),this._touchMoved||c(t,\"click\"),o=!1)},e._mouseInit=function(){this.element.on({touchstart:t.proxy(this,\"_touchStart\"),touchmove:t.proxy(this,\"_touchMove\"),touchend:t.proxy(this,\"_touchEnd\")}),u.call(this)},e._mouseDestroy=function(){this.element.unbind({touchstart:t.proxy(this,\"_touchStart\"),touchmove:t.proxy(this,\"_touchMove\"),touchend:t.proxy(this,\"_touchEnd\")}),n.call(this)}}function c(t,o){if(!(t.originalEvent.touches.length>1)){t.preventDefault();var e=t.originalEvent.changedTouches[0],u=document.createEvent(\"MouseEvents\");u.initMouseEvent(o,!0,!0,window,1,e.screenX,e.screenY,e.clientX,e.clientY,!1,!1,!1,!1,0,null),t.target.dispatchEvent(u)}}}(jQuery);\n","Smile_ElasticsuiteCatalog/js/slider.js":"/*!\n * jQuery UI Slider - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/slider/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/mouse'\n], function ($, undefined) {\n\n// number of pages in a slider\n// (how many times can you page up/down to go through the whole range)\n    var numPages = 5;\n\n    $.widget(\"ui.slider\", $.ui.mouse, {\n        version: \"1.10.4\",\n        widgetEventPrefix: \"slide\",\n\n        options: {\n            animate: false,\n            distance: 0,\n            max: 100,\n            min: 0,\n            orientation: \"horizontal\",\n            range: false,\n            step: 1,\n            value: 0,\n            values: null,\n\n            // callbacks\n            change: null,\n            slide: null,\n            start: null,\n            stop: null\n        },\n\n        _create: function () {\n            this._keySliding = false;\n            this._mouseSliding = false;\n            this._animateOff = true;\n            this._handleIndex = null;\n            this._detectOrientation();\n            this._mouseInit();\n\n            this.element\n                .addClass(\"ui-slider\" +\n                    \" ui-slider-\" + this.orientation +\n                    \" ui-widget\" +\n                    \" ui-widget-content\" +\n                    \" ui-corner-all\");\n\n            this._refresh();\n            this._setOption(\"disabled\", this.options.disabled);\n\n            this._animateOff = false;\n        },\n\n        _refresh: function () {\n            this._createRange();\n            this._createHandles();\n            this._setupEvents();\n            this._refreshValue();\n        },\n\n        _createHandles: function () {\n            var i, handleCount,\n                options = this.options,\n                existingHandles = this.element.find(\".ui-slider-handle\").addClass(\"ui-state-default ui-corner-all\"),\n                handle = \"<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>\",\n                handles = [];\n\n            handleCount = (options.values && options.values.length) || 1;\n\n            if (existingHandles.length > handleCount) {\n                existingHandles.slice(handleCount).remove();\n                existingHandles = existingHandles.slice(0, handleCount);\n            }\n\n            for (i = existingHandles.length; i < handleCount; i++) {\n                handles.push(handle);\n            }\n\n            this.handles = existingHandles.add($(handles.join(\"\")).appendTo(this.element));\n\n            this.handle = this.handles.eq(0);\n\n            this.handles.each(function (i) {\n                $(this).data(\"ui-slider-handle-index\", i);\n            });\n        },\n\n        _createRange: function () {\n            var options = this.options,\n                classes = \"\";\n\n            if (options.range) {\n                if (options.range === true) {\n                    if (!options.values) {\n                        options.values = [this._valueMin(), this._valueMin()];\n                    } else if (options.values.length && options.values.length !== 2) {\n                        options.values = [options.values[0], options.values[0]];\n                    } else if (Array.isArray(options.values)) {\n                        options.values = options.values.slice(0);\n                    }\n                }\n\n                if (!this.range || !this.range.length) {\n                    this.range = $(\"<div></div>\")\n                        .appendTo(this.element);\n\n                    classes = \"ui-slider-range\" +\n                        // note: this isn't the most fittingly semantic framework class for this element,\n                        // but worked best visually with a variety of themes\n                        \" ui-widget-header ui-corner-all\";\n                } else {\n                    this.range.removeClass(\"ui-slider-range-min ui-slider-range-max\")\n                    // Handle range switching from true to min/max\n                        .css({\n                            \"left\": \"\",\n                            \"bottom\": \"\"\n                        });\n                }\n\n                this.range.addClass(classes +\n                    ((options.range === \"min\" || options.range === \"max\") ? \" ui-slider-range-\" + options.range : \"\"));\n            } else {\n                if (this.range) {\n                    this.range.remove();\n                }\n                this.range = null;\n            }\n        },\n\n        _setupEvents: function () {\n            var elements = this.handles.add(this.range).filter(\"a\");\n            this._off(elements);\n            this._on(elements, this._handleEvents);\n            this._hoverable(elements);\n            this._focusable(elements);\n        },\n\n        _destroy: function () {\n            this.handles.remove();\n            if (this.range) {\n                this.range.remove();\n            }\n\n            this.element\n                .removeClass(\"ui-slider\" +\n                    \" ui-slider-horizontal\" +\n                    \" ui-slider-vertical\" +\n                    \" ui-widget\" +\n                    \" ui-widget-content\" +\n                    \" ui-corner-all\");\n\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function (event) {\n            var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,\n                that = this,\n                o = this.options;\n\n            if (o.disabled) {\n                return false;\n            }\n\n            this.elementSize = {\n                width: this.element.outerWidth(),\n                height: this.element.outerHeight()\n            };\n            this.elementOffset = this.element.offset();\n\n            position = {x: event.pageX, y: event.pageY};\n            normValue = this._normValueFromMouse(position);\n            distance = this._valueMax() - this._valueMin() + 1;\n            this.handles.each(function (i) {\n                var thisDistance = Math.abs(normValue - that.values(i));\n                if ((distance > thisDistance) ||\n                    (distance === thisDistance &&\n                        (i === that._lastChangedValue || that.values(i) === o.min))) {\n                    distance = thisDistance;\n                    closestHandle = $(this);\n                    index = i;\n                }\n            });\n\n            allowed = this._start(event, index);\n            if (allowed === false) {\n                return false;\n            }\n            this._mouseSliding = true;\n\n            this._handleIndex = index;\n\n            closestHandle\n                .addClass(\"ui-state-active\")\n                .trigger(\"focus\");\n\n            offset = closestHandle.offset();\n            mouseOverHandle = !$(event.target).parents().addBack().is(\".ui-slider-handle\");\n            this._clickOffset = mouseOverHandle ? {left: 0, top: 0} : {\n                left: event.pageX - offset.left - (closestHandle.width() / 2),\n                top: event.pageY - offset.top -\n                    (closestHandle.height() / 2) -\n                    (parseInt(closestHandle.css(\"borderTopWidth\"), 10) || 0) -\n                    (parseInt(closestHandle.css(\"borderBottomWidth\"), 10) || 0) +\n                    (parseInt(closestHandle.css(\"marginTop\"), 10) || 0)\n            };\n\n            if (!this.handles.hasClass(\"ui-state-hover\")) {\n                this._slide(event, index, normValue);\n            }\n            this._animateOff = true;\n            return true;\n        },\n\n        _mouseStart: function () {\n            return true;\n        },\n\n        _mouseDrag: function (event) {\n            var position = {x: event.pageX, y: event.pageY},\n                normValue = this._normValueFromMouse(position);\n\n            this._slide(event, this._handleIndex, normValue);\n\n            return false;\n        },\n\n        _mouseStop: function (event) {\n            this.handles.removeClass(\"ui-state-active\");\n            this._mouseSliding = false;\n\n            this._stop(event, this._handleIndex);\n            this._change(event, this._handleIndex);\n\n            this._handleIndex = null;\n            this._clickOffset = null;\n            this._animateOff = false;\n\n            return false;\n        },\n\n        _detectOrientation: function () {\n            this.orientation = (this.options.orientation === \"vertical\") ? \"vertical\" : \"horizontal\";\n        },\n\n        _normValueFromMouse: function (position) {\n            var pixelTotal,\n                pixelMouse,\n                percentMouse,\n                valueTotal,\n                valueMouse;\n\n            if (this.orientation === \"horizontal\") {\n                pixelTotal = this.elementSize.width;\n                pixelMouse = position.x - this.elementOffset.left - (this._clickOffset ? this._clickOffset.left : 0);\n            } else {\n                pixelTotal = this.elementSize.height;\n                pixelMouse = position.y - this.elementOffset.top - (this._clickOffset ? this._clickOffset.top : 0);\n            }\n\n            percentMouse = (pixelMouse / pixelTotal);\n            if (percentMouse > 1) {\n                percentMouse = 1;\n            }\n            if (percentMouse < 0) {\n                percentMouse = 0;\n            }\n            if (this.orientation === \"vertical\") {\n                percentMouse = 1 - percentMouse;\n            }\n\n            valueTotal = this._valueMax() - this._valueMin();\n            valueMouse = this._valueMin() + percentMouse * valueTotal;\n\n            return this._trimAlignValue(valueMouse);\n        },\n\n        _start: function (event, index) {\n            var uiHash = {\n                handle: this.handles[index],\n                value: this.value()\n            };\n            if (this.options.values && this.options.values.length) {\n                uiHash.value = this.values(index);\n                uiHash.values = this.values();\n            }\n            return this._trigger(\"start\", event, uiHash);\n        },\n\n        _slide: function (event, index, newVal) {\n            var otherVal,\n                newValues,\n                allowed;\n\n            if (this.options.values && this.options.values.length) {\n                otherVal = this.values(index ? 0 : 1);\n\n                if ((this.options.values.length === 2 && this.options.range === true) &&\n                    ((index === 0 && newVal > otherVal) || (index === 1 && newVal < otherVal))\n                ) {\n                    newVal = otherVal;\n                }\n\n                if (newVal !== this.values(index)) {\n                    newValues = this.values();\n                    newValues[index] = newVal;\n                    // A slide can be canceled by returning false from the slide callback\n                    allowed = this._trigger(\"slide\", event, {\n                        handle: this.handles[index],\n                        value: newVal,\n                        values: newValues\n                    });\n                    otherVal = this.values(index ? 0 : 1);\n                    if (allowed !== false) {\n                        this.values(index, newVal);\n                    }\n                }\n            } else {\n                if (newVal !== this.value()) {\n                    // A slide can be canceled by returning false from the slide callback\n                    allowed = this._trigger(\"slide\", event, {\n                        handle: this.handles[index],\n                        value: newVal\n                    });\n                    if (allowed !== false) {\n                        this.value(newVal);\n                    }\n                }\n            }\n        },\n\n        _stop: function (event, index) {\n            var uiHash = {\n                handle: this.handles[index],\n                value: this.value()\n            };\n            if (this.options.values && this.options.values.length) {\n                uiHash.value = this.values(index);\n                uiHash.values = this.values();\n            }\n\n            this._trigger(\"stop\", event, uiHash);\n        },\n\n        _change: function (event, index) {\n            if (!this._keySliding && !this._mouseSliding) {\n                var uiHash = {\n                    handle: this.handles[index],\n                    value: this.value()\n                };\n                if (this.options.values && this.options.values.length) {\n                    uiHash.value = this.values(index);\n                    uiHash.values = this.values();\n                }\n\n                //store the last changed value index for reference when handles overlap\n                this._lastChangedValue = index;\n\n                this._trigger(\"change\", event, uiHash);\n            }\n        },\n\n        value: function (newValue) {\n            if (arguments.length) {\n                this.options.value = this._trimAlignValue(newValue);\n                this._refreshValue();\n                this._change(null, 0);\n                return;\n            }\n\n            return this._value();\n        },\n\n        values: function (index, newValue) {\n            var vals,\n                newValues,\n                i;\n\n            if (arguments.length > 1) {\n                this.options.values[index] = this._trimAlignValue(newValue);\n                this._refreshValue();\n                this._change(null, index);\n                return;\n            }\n\n            if (arguments.length) {\n                if (Array.isArray(arguments[0])) {\n                    vals = this.options.values;\n                    newValues = arguments[0];\n                    for (i = 0; i < vals.length; i += 1) {\n                        vals[i] = this._trimAlignValue(newValues[i]);\n                        this._change(null, i);\n                    }\n                    this._refreshValue();\n                } else {\n                    if (this.options.values && this.options.values.length) {\n                        return this._values(index);\n                    } else {\n                        return this.value();\n                    }\n                }\n            } else {\n                return this._values();\n            }\n        },\n\n        _setOption: function (key, value) {\n            var i,\n                valsLength = 0;\n\n            if (key === \"range\" && this.options.range === true) {\n                if (value === \"min\") {\n                    this.options.value = this._values(0);\n                    this.options.values = null;\n                } else if (value === \"max\") {\n                    this.options.value = this._values(this.options.values.length - 1);\n                    this.options.values = null;\n                }\n            }\n\n            if (Array.isArray(this.options.values)) {\n                valsLength = this.options.values.length;\n            }\n\n            $.Widget.prototype._setOption.apply(this, arguments);\n\n            switch (key) {\n                case \"orientation\":\n                    this._detectOrientation();\n                    this.element\n                        .removeClass(\"ui-slider-horizontal ui-slider-vertical\")\n                        .addClass(\"ui-slider-\" + this.orientation);\n                    this._refreshValue();\n                    break;\n                case \"value\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    this._change(null, 0);\n                    this._animateOff = false;\n                    break;\n                case \"values\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    for (i = 0; i < valsLength; i += 1) {\n                        this._change(null, i);\n                    }\n                    this._animateOff = false;\n                    break;\n                case \"min\":\n                case \"max\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    this._animateOff = false;\n                    break;\n                case \"range\":\n                    this._animateOff = true;\n                    this._refresh();\n                    this._animateOff = false;\n                    break;\n            }\n        },\n\n        //internal value getter\n        // _value() returns value trimmed by min and max, aligned by step\n        _value: function () {\n            var val = this.options.value;\n            val = this._trimAlignValue(val);\n\n            return val;\n        },\n\n        //internal values getter\n        // _values() returns array of values trimmed by min and max, aligned by step\n        // _values( index ) returns single value trimmed by min and max, aligned by step\n        _values: function (index) {\n            var val,\n                vals,\n                i;\n\n            if (arguments.length) {\n                val = this.options.values[index];\n                val = this._trimAlignValue(val);\n\n                return val;\n            } else if (this.options.values && this.options.values.length) {\n                // .slice() creates a copy of the array\n                // this copy gets trimmed by min and max and then returned\n                vals = this.options.values.slice();\n                for (i = 0; i < vals.length; i += 1) {\n                    vals[i] = this._trimAlignValue(vals[i]);\n                }\n\n                return vals;\n            } else {\n                return [];\n            }\n        },\n\n        // returns the step-aligned value that val is closest to, between (inclusive) min and max\n        _trimAlignValue: function (val) {\n            if (val <= this._valueMin()) {\n                return this._valueMin();\n            }\n            if (val >= this._valueMax()) {\n                return this._valueMax();\n            }\n            var step = (this.options.step > 0) ? this.options.step : 1,\n                valModStep = (val - this._valueMin()) % step,\n                alignValue = val - valModStep;\n\n            if (Math.abs(valModStep) * 2 >= step) {\n                alignValue += (valModStep > 0) ? step : (-step);\n            }\n\n            // Since JavaScript has problems with large floats, round\n            // the final value to 5 digits after the decimal point (see #4124)\n            return parseFloat(alignValue.toFixed(5));\n        },\n\n        _valueMin: function () {\n            return this.options.min;\n        },\n\n        _valueMax: function () {\n            return this.options.max;\n        },\n\n        _refreshValue: function () {\n            var lastValPercent, valPercent, value, valueMin, valueMax,\n                oRange = this.options.range,\n                o = this.options,\n                that = this,\n                animate = (!this._animateOff) ? o.animate : false,\n                _set = {};\n\n            if (this.options.values && this.options.values.length) {\n                this.handles.each(function (i) {\n                    valPercent = (that.values(i) - that._valueMin()) / (that._valueMax() - that._valueMin()) * 100;\n                    _set[that.orientation === \"horizontal\" ? \"left\" : \"bottom\"] = valPercent + \"%\";\n                    $(this).stop(1, 1)[animate ? \"animate\" : \"css\"](_set, o.animate);\n                    if (that.options.range === true) {\n                        if (that.orientation === \"horizontal\") {\n                            if (i === 0) {\n                                that.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({left: valPercent + \"%\"}, o.animate);\n                            }\n                            if (i === 1) {\n                                that.range[animate ? \"animate\" : \"css\"]({width: (valPercent - lastValPercent) + \"%\"}, {\n                                    queue: false,\n                                    duration: o.animate\n                                });\n                            }\n                        } else {\n                            if (i === 0) {\n                                that.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({bottom: (valPercent) + \"%\"}, o.animate);\n                            }\n                            if (i === 1) {\n                                that.range[animate ? \"animate\" : \"css\"]({height: (valPercent - lastValPercent) + \"%\"}, {\n                                    queue: false,\n                                    duration: o.animate\n                                });\n                            }\n                        }\n                    }\n                    lastValPercent = valPercent;\n                });\n            } else {\n                value = this.value();\n                valueMin = this._valueMin();\n                valueMax = this._valueMax();\n                valPercent = (valueMax !== valueMin) ?\n                    (value - valueMin) / (valueMax - valueMin) * 100 :\n                    0;\n                _set[this.orientation === \"horizontal\" ? \"left\" : \"bottom\"] = valPercent + \"%\";\n                this.handle.stop(1, 1)[animate ? \"animate\" : \"css\"](_set, o.animate);\n\n                if (oRange === \"min\" && this.orientation === \"horizontal\") {\n                    this.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({width: valPercent + \"%\"}, o.animate);\n                }\n                if (oRange === \"max\" && this.orientation === \"horizontal\") {\n                    this.range[animate ? \"animate\" : \"css\"]({width: (100 - valPercent) + \"%\"}, {\n                        queue: false,\n                        duration: o.animate\n                    });\n                }\n                if (oRange === \"min\" && this.orientation === \"vertical\") {\n                    this.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({height: valPercent + \"%\"}, o.animate);\n                }\n                if (oRange === \"max\" && this.orientation === \"vertical\") {\n                    this.range[animate ? \"animate\" : \"css\"]({height: (100 - valPercent) + \"%\"}, {\n                        queue: false,\n                        duration: o.animate\n                    });\n                }\n            }\n        },\n\n        _handleEvents: {\n            keydown: function (event) {\n                var allowed, curVal, newVal, step,\n                    index = $(event.target).data(\"ui-slider-handle-index\");\n\n                switch (event.keyCode) {\n                    case $.ui.keyCode.HOME:\n                    case $.ui.keyCode.END:\n                    case $.ui.keyCode.PAGE_UP:\n                    case $.ui.keyCode.PAGE_DOWN:\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        event.preventDefault();\n                        if (!this._keySliding) {\n                            this._keySliding = true;\n                            $(event.target).addClass(\"ui-state-active\");\n                            allowed = this._start(event, index);\n                            if (allowed === false) {\n                                return;\n                            }\n                        }\n                        break;\n                }\n\n                step = this.options.step;\n                if (this.options.values && this.options.values.length) {\n                    curVal = newVal = this.values(index);\n                } else {\n                    curVal = newVal = this.value();\n                }\n\n                switch (event.keyCode) {\n                    case $.ui.keyCode.HOME:\n                        newVal = this._valueMin();\n                        break;\n                    case $.ui.keyCode.END:\n                        newVal = this._valueMax();\n                        break;\n                    case $.ui.keyCode.PAGE_UP:\n                        newVal = this._trimAlignValue(curVal + ((this._valueMax() - this._valueMin()) / numPages));\n                        break;\n                    case $.ui.keyCode.PAGE_DOWN:\n                        newVal = this._trimAlignValue(curVal - ((this._valueMax() - this._valueMin()) / numPages));\n                        break;\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                        if (curVal === this._valueMax()) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue(curVal + step);\n                        break;\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        if (curVal === this._valueMin()) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue(curVal - step);\n                        break;\n                }\n\n                this._slide(event, index, newVal);\n            },\n            click: function (event) {\n                event.preventDefault();\n            },\n            keyup: function (event) {\n                var index = $(event.target).data(\"ui-slider-handle-index\");\n\n                if (this._keySliding) {\n                    this._keySliding = false;\n                    this._stop(event, index);\n                    this._change(event, index);\n                    $(event.target).removeClass(\"ui-state-active\");\n                }\n            }\n        }\n\n    });\n\n});\n","Smile_ElasticsuiteCatalog/js/mouse.js":"/*!\n * jQuery UI Mouse 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/mouse/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($, undefined) {\n\n    var mouseHandled = false;\n    $( document ).on( \"mouseup\", function() {\n        mouseHandled = false;\n    } );\n\n    var widgetsMouse = $.widget( \"ui.mouse\", {\n        version: \"1.13.2\",\n        options: {\n            cancel: \"input, textarea, button, select, option\",\n            distance: 1,\n            delay: 0\n        },\n        _mouseInit: function() {\n            var that = this;\n\n            this.element\n                .on( \"mousedown.\" + this.widgetName, function( event ) {\n                    return that._mouseDown( event );\n                } )\n                .on( \"click.\" + this.widgetName, function( event ) {\n                    if ( true === $.data( event.target, that.widgetName + \".preventClickEvent\" ) ) {\n                        $.removeData( event.target, that.widgetName + \".preventClickEvent\" );\n                        event.stopImmediatePropagation();\n                        return false;\n                    }\n                } );\n\n            this.started = false;\n        },\n\n        // TODO: make sure destroying one instance of mouse doesn't mess with\n        // other instances of mouse\n        _mouseDestroy: function() {\n            this.element.off( \".\" + this.widgetName );\n            if ( this._mouseMoveDelegate ) {\n                this.document\n                    .off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                    .off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n            }\n        },\n\n        _mouseDown: function( event ) {\n\n            // don't let more than one widget handle mouseStart\n            if ( mouseHandled ) {\n                return;\n            }\n\n            this._mouseMoved = false;\n\n            // We may have missed mouseup (out of window)\n            if ( this._mouseStarted ) {\n                this._mouseUp( event );\n            }\n\n            this._mouseDownEvent = event;\n\n            var that = this,\n                btnIsLeft = ( event.which === 1 ),\n\n                // event.target.nodeName works around a bug in IE 8 with\n                // disabled inputs (#7620)\n                elIsCancel = ( typeof this.options.cancel === \"string\" && event.target.nodeName ?\n                    $( event.target ).closest( this.options.cancel ).length : false );\n            if ( !btnIsLeft || elIsCancel || !this._mouseCapture( event ) ) {\n                return true;\n            }\n\n            this.mouseDelayMet = !this.options.delay;\n            if ( !this.mouseDelayMet ) {\n                this._mouseDelayTimer = setTimeout( function() {\n                    that.mouseDelayMet = true;\n                }, this.options.delay );\n            }\n\n            if ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n                this._mouseStarted = ( this._mouseStart( event ) !== false );\n                if ( !this._mouseStarted ) {\n                    event.preventDefault();\n                    return true;\n                }\n            }\n\n            // Click event may never have fired (Gecko & Opera)\n            if ( true === $.data( event.target, this.widgetName + \".preventClickEvent\" ) ) {\n                $.removeData( event.target, this.widgetName + \".preventClickEvent\" );\n            }\n\n            // These delegates are required to keep context\n            this._mouseMoveDelegate = function( event ) {\n                return that._mouseMove( event );\n            };\n            this._mouseUpDelegate = function( event ) {\n                return that._mouseUp( event );\n            };\n\n            this.document\n                .on( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                .on( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n            event.preventDefault();\n\n            mouseHandled = true;\n            return true;\n        },\n\n        _mouseMove: function( event ) {\n\n            // Only check for mouseups outside the document if you've moved inside the document\n            // at least once. This prevents the firing of mouseup in the case of IE<9, which will\n            // fire a mousemove event if content is placed under the cursor. See #7778\n            // Support: IE <9\n            if ( this._mouseMoved ) {\n\n                // IE mouseup check - mouseup happened when mouse was out of window\n                if ( $.ui.ie && ( !document.documentMode || document.documentMode < 9 ) &&\n                    !event.button ) {\n                    return this._mouseUp( event );\n\n                    // Iframe mouseup check - mouseup occurred in another document\n                } else if ( !event.which ) {\n\n                    // Support: Safari <=8 - 9\n                    // Safari sets which to 0 if you press any of the following keys\n                    // during a drag (#14461)\n                    if ( event.originalEvent.altKey || event.originalEvent.ctrlKey ||\n                        event.originalEvent.metaKey || event.originalEvent.shiftKey ) {\n                        this.ignoreMissingWhich = true;\n                    } else if ( !this.ignoreMissingWhich ) {\n                        return this._mouseUp( event );\n                    }\n                }\n            }\n\n            if ( event.which || event.button ) {\n                this._mouseMoved = true;\n            }\n\n            if ( this._mouseStarted ) {\n                this._mouseDrag( event );\n                return event.preventDefault();\n            }\n\n            if ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n                this._mouseStarted =\n                    ( this._mouseStart( this._mouseDownEvent, event ) !== false );\n                if ( this._mouseStarted ) {\n                    this._mouseDrag( event );\n                } else {\n                    this._mouseUp( event );\n                }\n            }\n\n            return !this._mouseStarted;\n        },\n\n        _mouseUp: function( event ) {\n            this.document\n                .off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                .off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n            if ( this._mouseStarted ) {\n                this._mouseStarted = false;\n\n                if ( event.target === this._mouseDownEvent.target ) {\n                    $.data( event.target, this.widgetName + \".preventClickEvent\", true );\n                }\n\n                this._mouseStop( event );\n            }\n\n            if ( this._mouseDelayTimer ) {\n                clearTimeout( this._mouseDelayTimer );\n                delete this._mouseDelayTimer;\n            }\n\n            this.ignoreMissingWhich = false;\n            mouseHandled = false;\n            event.preventDefault();\n        },\n\n        _mouseDistanceMet: function( event ) {\n            return ( Math.max(\n                    Math.abs( this._mouseDownEvent.pageX - event.pageX ),\n                    Math.abs( this._mouseDownEvent.pageY - event.pageY )\n                ) >= this.options.distance\n            );\n        },\n\n        _mouseDelayMet: function( /* event */ ) {\n            return this.mouseDelayMet;\n        },\n\n        // These are placeholder methods, to be overriden by extending plugin\n        _mouseStart: function( /* event */ ) {},\n        _mouseDrag: function( /* event */ ) {},\n        _mouseStop: function( /* event */ ) {},\n        _mouseCapture: function( /* event */ ) {\n            return true;\n        }\n    });\n\n});\n","Smile_ElasticsuiteCatalog/js/autocomplete/product-attribute.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCatalog\n * @author    Aurelien FOUCRET <aurelien.foucret@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\n/*jshint browser:true jquery:true*/\n/*global alert*/\n\ndefine(['underscore'], function(_) {\n    var Renderer = {\n        render : function (data) {\n            data = data.filter(function(item) {\n                return item.type === \"product_attribute\";\n            }).map(function(item) {\n                return item['attribute_label']\n            }).reduce(function(prev, item) {\n                if (item in prev) {\n                    prev[item]++;\n                } else {\n                    prev[item] = 1;\n                }\n                return prev;\n            }, {});\n\n            data = _.pairs(data).sort(function(item1, item2) {\n                return item2[1] - item1[1]\n            }).map(function(item) {return item[0]});\n\n            if (data.length > 2) {\n                data = data.slice(0, 2);\n                data.push('...');\n            }\n\n            return data.join(', ');\n        }\n    }\n\n    return Renderer;\n});\n","Magento_ReCaptchaStorePickup/js/reCaptchaStorePickup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['Magento_ReCaptchaFrontendUi/js/reCaptcha'], function (reCaptcha) {\n    'use strict';\n\n    return reCaptcha.extend({\n\n        /**\n         * @inheritdoc\n         */\n        renderReCaptcha: function () {\n            this.captchaInitialized = false;\n            this._super();\n        }\n    });\n});\n"}
}});
