require.config({"config": {
        "jsbuild":{"underscore.js":"(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define('underscore', factory) :\n            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, (function () {\n                var current = global._;\n                var exports = global._ = factory();\n                exports.noConflict = function () { global._ = current; return exports; };\n            }()));\n}(this, (function () {\n    //     Underscore.js 1.13.6\n    //     https://underscorejs.org\n    //     (c) 2009-2022 Jeremy Ashkenas, Julian Gonggrijp, and DocumentCloud and Investigative Reporters & Editors\n    //     Underscore may be freely distributed under the MIT license.\n\n    // Current version.\n    var VERSION = '1.13.6';\n\n    // Establish the root object, `window` (`self`) in the browser, `global`\n    // on the server, or `this` in some virtual machines. We use `self`\n    // instead of `window` for `WebWorker` support.\n    var root = (typeof self == 'object' && self.self === self && self) ||\n        (typeof global == 'object' && global.global === global && global) ||\n        Function('return this')() ||\n        {};\n\n    // Save bytes in the minified (but not gzipped) version:\n    var ArrayProto = Array.prototype, ObjProto = Object.prototype;\n    var SymbolProto = typeof Symbol !== 'undefined' ? Symbol.prototype : null;\n\n    // Create quick reference variables for speed access to core prototypes.\n    var push = ArrayProto.push,\n        slice = ArrayProto.slice,\n        toString = ObjProto.toString,\n        hasOwnProperty = ObjProto.hasOwnProperty;\n\n    // Modern feature detection.\n    var supportsArrayBuffer = typeof ArrayBuffer !== 'undefined',\n        supportsDataView = typeof DataView !== 'undefined';\n\n    // All **ECMAScript 5+** native function implementations that we hope to use\n    // are declared here.\n    var nativeIsArray = Array.isArray,\n        nativeKeys = Object.keys,\n        nativeCreate = Object.create,\n        nativeIsView = supportsArrayBuffer && ArrayBuffer.isView;\n\n    // Create references to these builtin functions because we override them.\n    var _isNaN = isNaN,\n        _isFinite = isFinite;\n\n    // Keys in IE < 9 that won't be iterated by `for key in ...` and thus missed.\n    var hasEnumBug = !{toString: null}.propertyIsEnumerable('toString');\n    var nonEnumerableProps = ['valueOf', 'isPrototypeOf', 'toString',\n        'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];\n\n    // The largest integer that can be represented exactly.\n    var MAX_ARRAY_INDEX = Math.pow(2, 53) - 1;\n\n    // Some functions take a variable number of arguments, or a few expected\n    // arguments at the beginning and then a variable number of values to operate\n    // on. This helper accumulates all remaining arguments past the function\u2019s\n    // argument length (or an explicit `startIndex`), into an array that becomes\n    // the last argument. Similar to ES6\u2019s \"rest parameter\".\n    function restArguments(func, startIndex) {\n        startIndex = startIndex == null ? func.length - 1 : +startIndex;\n        return function() {\n            var length = Math.max(arguments.length - startIndex, 0),\n                rest = Array(length),\n                index = 0;\n            for (; index < length; index++) {\n                rest[index] = arguments[index + startIndex];\n            }\n            switch (startIndex) {\n                case 0: return func.call(this, rest);\n                case 1: return func.call(this, arguments[0], rest);\n                case 2: return func.call(this, arguments[0], arguments[1], rest);\n            }\n            var args = Array(startIndex + 1);\n            for (index = 0; index < startIndex; index++) {\n                args[index] = arguments[index];\n            }\n            args[startIndex] = rest;\n            return func.apply(this, args);\n        };\n    }\n\n    // Is a given variable an object?\n    function isObject(obj) {\n        var type = typeof obj;\n        return type === 'function' || (type === 'object' && !!obj);\n    }\n\n    // Is a given value equal to null?\n    function isNull(obj) {\n        return obj === null;\n    }\n\n    // Is a given variable undefined?\n    function isUndefined(obj) {\n        return obj === void 0;\n    }\n\n    // Is a given value a boolean?\n    function isBoolean(obj) {\n        return obj === true || obj === false || toString.call(obj) === '[object Boolean]';\n    }\n\n    // Is a given value a DOM element?\n    function isElement(obj) {\n        return !!(obj && obj.nodeType === 1);\n    }\n\n    // Internal function for creating a `toString`-based type tester.\n    function tagTester(name) {\n        var tag = '[object ' + name + ']';\n        return function(obj) {\n            return toString.call(obj) === tag;\n        };\n    }\n\n    var isString = tagTester('String');\n\n    var isNumber = tagTester('Number');\n\n    var isDate = tagTester('Date');\n\n    var isRegExp = tagTester('RegExp');\n\n    var isError = tagTester('Error');\n\n    var isSymbol = tagTester('Symbol');\n\n    var isArrayBuffer = tagTester('ArrayBuffer');\n\n    var isFunction = tagTester('Function');\n\n    // Optimize `isFunction` if appropriate. Work around some `typeof` bugs in old\n    // v8, IE 11 (#1621), Safari 8 (#1929), and PhantomJS (#2236).\n    var nodelist = root.document && root.document.childNodes;\n    if (typeof /./ != 'function' && typeof Int8Array != 'object' && typeof nodelist != 'function') {\n        isFunction = function(obj) {\n            return typeof obj == 'function' || false;\n        };\n    }\n\n    var isFunction$1 = isFunction;\n\n    var hasObjectTag = tagTester('Object');\n\n    // In IE 10 - Edge 13, `DataView` has string tag `'[object Object]'`.\n    // In IE 11, the most common among them, this problem also applies to\n    // `Map`, `WeakMap` and `Set`.\n    var hasStringTagBug = (\n            supportsDataView && hasObjectTag(new DataView(new ArrayBuffer(8)))\n        ),\n        isIE11 = (typeof Map !== 'undefined' && hasObjectTag(new Map));\n\n    var isDataView = tagTester('DataView');\n\n    // In IE 10 - Edge 13, we need a different heuristic\n    // to determine whether an object is a `DataView`.\n    function ie10IsDataView(obj) {\n        return obj != null && isFunction$1(obj.getInt8) && isArrayBuffer(obj.buffer);\n    }\n\n    var isDataView$1 = (hasStringTagBug ? ie10IsDataView : isDataView);\n\n    // Is a given value an array?\n    // Delegates to ECMA5's native `Array.isArray`.\n    var isArray = nativeIsArray || tagTester('Array');\n\n    // Internal function to check whether `key` is an own property name of `obj`.\n    function has$1(obj, key) {\n        return obj != null && hasOwnProperty.call(obj, key);\n    }\n\n    var isArguments = tagTester('Arguments');\n\n    // Define a fallback version of the method in browsers (ahem, IE < 9), where\n    // there isn't any inspectable \"Arguments\" type.\n    (function() {\n        if (!isArguments(arguments)) {\n            isArguments = function(obj) {\n                return has$1(obj, 'callee');\n            };\n        }\n    }());\n\n    var isArguments$1 = isArguments;\n\n    // Is a given object a finite number?\n    function isFinite$1(obj) {\n        return !isSymbol(obj) && _isFinite(obj) && !isNaN(parseFloat(obj));\n    }\n\n    // Is the given value `NaN`?\n    function isNaN$1(obj) {\n        return isNumber(obj) && _isNaN(obj);\n    }\n\n    // Predicate-generating function. Often useful outside of Underscore.\n    function constant(value) {\n        return function() {\n            return value;\n        };\n    }\n\n    // Common internal logic for `isArrayLike` and `isBufferLike`.\n    function createSizePropertyCheck(getSizeProperty) {\n        return function(collection) {\n            var sizeProperty = getSizeProperty(collection);\n            return typeof sizeProperty == 'number' && sizeProperty >= 0 && sizeProperty <= MAX_ARRAY_INDEX;\n        }\n    }\n\n    // Internal helper to generate a function to obtain property `key` from `obj`.\n    function shallowProperty(key) {\n        return function(obj) {\n            return obj == null ? void 0 : obj[key];\n        };\n    }\n\n    // Internal helper to obtain the `byteLength` property of an object.\n    var getByteLength = shallowProperty('byteLength');\n\n    // Internal helper to determine whether we should spend extensive checks against\n    // `ArrayBuffer` et al.\n    var isBufferLike = createSizePropertyCheck(getByteLength);\n\n    // Is a given value a typed array?\n    var typedArrayPattern = /\\[object ((I|Ui)nt(8|16|32)|Float(32|64)|Uint8Clamped|Big(I|Ui)nt64)Array\\]/;\n    function isTypedArray(obj) {\n        // `ArrayBuffer.isView` is the most future-proof, so use it when available.\n        // Otherwise, fall back on the above regular expression.\n        return nativeIsView ? (nativeIsView(obj) && !isDataView$1(obj)) :\n            isBufferLike(obj) && typedArrayPattern.test(toString.call(obj));\n    }\n\n    var isTypedArray$1 = supportsArrayBuffer ? isTypedArray : constant(false);\n\n    // Internal helper to obtain the `length` property of an object.\n    var getLength = shallowProperty('length');\n\n    // Internal helper to create a simple lookup structure.\n    // `collectNonEnumProps` used to depend on `_.contains`, but this led to\n    // circular imports. `emulatedSet` is a one-off solution that only works for\n    // arrays of strings.\n    function emulatedSet(keys) {\n        var hash = {};\n        for (var l = keys.length, i = 0; i < l; ++i) hash[keys[i]] = true;\n        return {\n            contains: function(key) { return hash[key] === true; },\n            push: function(key) {\n                hash[key] = true;\n                return keys.push(key);\n            }\n        };\n    }\n\n    // Internal helper. Checks `keys` for the presence of keys in IE < 9 that won't\n    // be iterated by `for key in ...` and thus missed. Extends `keys` in place if\n    // needed.\n    function collectNonEnumProps(obj, keys) {\n        keys = emulatedSet(keys);\n        var nonEnumIdx = nonEnumerableProps.length;\n        var constructor = obj.constructor;\n        var proto = (isFunction$1(constructor) && constructor.prototype) || ObjProto;\n\n        // Constructor is a special case.\n        var prop = 'constructor';\n        if (has$1(obj, prop) && !keys.contains(prop)) keys.push(prop);\n\n        while (nonEnumIdx--) {\n            prop = nonEnumerableProps[nonEnumIdx];\n            if (prop in obj && obj[prop] !== proto[prop] && !keys.contains(prop)) {\n                keys.push(prop);\n            }\n        }\n    }\n\n    // Retrieve the names of an object's own properties.\n    // Delegates to **ECMAScript 5**'s native `Object.keys`.\n    function keys(obj) {\n        if (!isObject(obj)) return [];\n        if (nativeKeys) return nativeKeys(obj);\n        var keys = [];\n        for (var key in obj) if (has$1(obj, key)) keys.push(key);\n        // Ahem, IE < 9.\n        if (hasEnumBug) collectNonEnumProps(obj, keys);\n        return keys;\n    }\n\n    // Is a given array, string, or object empty?\n    // An \"empty\" object has no enumerable own-properties.\n    function isEmpty(obj) {\n        if (obj == null) return true;\n        // Skip the more expensive `toString`-based type checks if `obj` has no\n        // `.length`.\n        var length = getLength(obj);\n        if (typeof length == 'number' && (\n            isArray(obj) || isString(obj) || isArguments$1(obj)\n        )) return length === 0;\n        return getLength(keys(obj)) === 0;\n    }\n\n    // Returns whether an object has a given set of `key:value` pairs.\n    function isMatch(object, attrs) {\n        var _keys = keys(attrs), length = _keys.length;\n        if (object == null) return !length;\n        var obj = Object(object);\n        for (var i = 0; i < length; i++) {\n            var key = _keys[i];\n            if (attrs[key] !== obj[key] || !(key in obj)) return false;\n        }\n        return true;\n    }\n\n    // If Underscore is called as a function, it returns a wrapped object that can\n    // be used OO-style. This wrapper holds altered versions of all functions added\n    // through `_.mixin`. Wrapped objects may be chained.\n    function _$1(obj) {\n        if (obj instanceof _$1) return obj;\n        if (!(this instanceof _$1)) return new _$1(obj);\n        this._wrapped = obj;\n    }\n\n    _$1.VERSION = VERSION;\n\n    // Extracts the result from a wrapped and chained object.\n    _$1.prototype.value = function() {\n        return this._wrapped;\n    };\n\n    // Provide unwrapping proxies for some methods used in engine operations\n    // such as arithmetic and JSON stringification.\n    _$1.prototype.valueOf = _$1.prototype.toJSON = _$1.prototype.value;\n\n    _$1.prototype.toString = function() {\n        return String(this._wrapped);\n    };\n\n    // Internal function to wrap or shallow-copy an ArrayBuffer,\n    // typed array or DataView to a new view, reusing the buffer.\n    function toBufferView(bufferSource) {\n        return new Uint8Array(\n            bufferSource.buffer || bufferSource,\n            bufferSource.byteOffset || 0,\n            getByteLength(bufferSource)\n        );\n    }\n\n    // We use this string twice, so give it a name for minification.\n    var tagDataView = '[object DataView]';\n\n    // Internal recursive comparison function for `_.isEqual`.\n    function eq(a, b, aStack, bStack) {\n        // Identical objects are equal. `0 === -0`, but they aren't identical.\n        // See the [Harmony `egal` proposal](https://wiki.ecmascript.org/doku.php?id=harmony:egal).\n        if (a === b) return a !== 0 || 1 / a === 1 / b;\n        // `null` or `undefined` only equal to itself (strict comparison).\n        if (a == null || b == null) return false;\n        // `NaN`s are equivalent, but non-reflexive.\n        if (a !== a) return b !== b;\n        // Exhaust primitive checks\n        var type = typeof a;\n        if (type !== 'function' && type !== 'object' && typeof b != 'object') return false;\n        return deepEq(a, b, aStack, bStack);\n    }\n\n    // Internal recursive comparison function for `_.isEqual`.\n    function deepEq(a, b, aStack, bStack) {\n        // Unwrap any wrapped objects.\n        if (a instanceof _$1) a = a._wrapped;\n        if (b instanceof _$1) b = b._wrapped;\n        // Compare `[[Class]]` names.\n        var className = toString.call(a);\n        if (className !== toString.call(b)) return false;\n        // Work around a bug in IE 10 - Edge 13.\n        if (hasStringTagBug && className == '[object Object]' && isDataView$1(a)) {\n            if (!isDataView$1(b)) return false;\n            className = tagDataView;\n        }\n        switch (className) {\n            // These types are compared by value.\n            case '[object RegExp]':\n            // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')\n            case '[object String]':\n                // Primitives and their corresponding object wrappers are equivalent; thus, `\"5\"` is\n                // equivalent to `new String(\"5\")`.\n                return '' + a === '' + b;\n            case '[object Number]':\n                // `NaN`s are equivalent, but non-reflexive.\n                // Object(NaN) is equivalent to NaN.\n                if (+a !== +a) return +b !== +b;\n                // An `egal` comparison is performed for other numeric values.\n                return +a === 0 ? 1 / +a === 1 / b : +a === +b;\n            case '[object Date]':\n            case '[object Boolean]':\n                // Coerce dates and booleans to numeric primitive values. Dates are compared by their\n                // millisecond representations. Note that invalid dates with millisecond representations\n                // of `NaN` are not equivalent.\n                return +a === +b;\n            case '[object Symbol]':\n                return SymbolProto.valueOf.call(a) === SymbolProto.valueOf.call(b);\n            case '[object ArrayBuffer]':\n            case tagDataView:\n                // Coerce to typed array so we can fall through.\n                return deepEq(toBufferView(a), toBufferView(b), aStack, bStack);\n        }\n\n        var areArrays = className === '[object Array]';\n        if (!areArrays && isTypedArray$1(a)) {\n            var byteLength = getByteLength(a);\n            if (byteLength !== getByteLength(b)) return false;\n            if (a.buffer === b.buffer && a.byteOffset === b.byteOffset) return true;\n            areArrays = true;\n        }\n        if (!areArrays) {\n            if (typeof a != 'object' || typeof b != 'object') return false;\n\n            // Objects with different constructors are not equivalent, but `Object`s or `Array`s\n            // from different frames are.\n            var aCtor = a.constructor, bCtor = b.constructor;\n            if (aCtor !== bCtor && !(isFunction$1(aCtor) && aCtor instanceof aCtor &&\n                    isFunction$1(bCtor) && bCtor instanceof bCtor)\n                && ('constructor' in a && 'constructor' in b)) {\n                return false;\n            }\n        }\n        // Assume equality for cyclic structures. The algorithm for detecting cyclic\n        // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.\n\n        // Initializing stack of traversed objects.\n        // It's done here since we only need them for objects and arrays comparison.\n        aStack = aStack || [];\n        bStack = bStack || [];\n        var length = aStack.length;\n        while (length--) {\n            // Linear search. Performance is inversely proportional to the number of\n            // unique nested structures.\n            if (aStack[length] === a) return bStack[length] === b;\n        }\n\n        // Add the first object to the stack of traversed objects.\n        aStack.push(a);\n        bStack.push(b);\n\n        // Recursively compare objects and arrays.\n        if (areArrays) {\n            // Compare array lengths to determine if a deep comparison is necessary.\n            length = a.length;\n            if (length !== b.length) return false;\n            // Deep compare the contents, ignoring non-numeric properties.\n            while (length--) {\n                if (!eq(a[length], b[length], aStack, bStack)) return false;\n            }\n        } else {\n            // Deep compare objects.\n            var _keys = keys(a), key;\n            length = _keys.length;\n            // Ensure that both objects contain the same number of properties before comparing deep equality.\n            if (keys(b).length !== length) return false;\n            while (length--) {\n                // Deep compare each member\n                key = _keys[length];\n                if (!(has$1(b, key) && eq(a[key], b[key], aStack, bStack))) return false;\n            }\n        }\n        // Remove the first object from the stack of traversed objects.\n        aStack.pop();\n        bStack.pop();\n        return true;\n    }\n\n    // Perform a deep comparison to check if two objects are equal.\n    function isEqual(a, b) {\n        return eq(a, b);\n    }\n\n    // Retrieve all the enumerable property names of an object.\n    function allKeys(obj) {\n        if (!isObject(obj)) return [];\n        var keys = [];\n        for (var key in obj) keys.push(key);\n        // Ahem, IE < 9.\n        if (hasEnumBug) collectNonEnumProps(obj, keys);\n        return keys;\n    }\n\n    // Since the regular `Object.prototype.toString` type tests don't work for\n    // some types in IE 11, we use a fingerprinting heuristic instead, based\n    // on the methods. It's not great, but it's the best we got.\n    // The fingerprint method lists are defined below.\n    function ie11fingerprint(methods) {\n        var length = getLength(methods);\n        return function(obj) {\n            if (obj == null) return false;\n            // `Map`, `WeakMap` and `Set` have no enumerable keys.\n            var keys = allKeys(obj);\n            if (getLength(keys)) return false;\n            for (var i = 0; i < length; i++) {\n                if (!isFunction$1(obj[methods[i]])) return false;\n            }\n            // If we are testing against `WeakMap`, we need to ensure that\n            // `obj` doesn't have a `forEach` method in order to distinguish\n            // it from a regular `Map`.\n            return methods !== weakMapMethods || !isFunction$1(obj[forEachName]);\n        };\n    }\n\n    // In the interest of compact minification, we write\n    // each string in the fingerprints only once.\n    var forEachName = 'forEach',\n        hasName = 'has',\n        commonInit = ['clear', 'delete'],\n        mapTail = ['get', hasName, 'set'];\n\n    // `Map`, `WeakMap` and `Set` each have slightly different\n    // combinations of the above sublists.\n    var mapMethods = commonInit.concat(forEachName, mapTail),\n        weakMapMethods = commonInit.concat(mapTail),\n        setMethods = ['add'].concat(commonInit, forEachName, hasName);\n\n    var isMap = isIE11 ? ie11fingerprint(mapMethods) : tagTester('Map');\n\n    var isWeakMap = isIE11 ? ie11fingerprint(weakMapMethods) : tagTester('WeakMap');\n\n    var isSet = isIE11 ? ie11fingerprint(setMethods) : tagTester('Set');\n\n    var isWeakSet = tagTester('WeakSet');\n\n    // Retrieve the values of an object's properties.\n    function values(obj) {\n        var _keys = keys(obj);\n        var length = _keys.length;\n        var values = Array(length);\n        for (var i = 0; i < length; i++) {\n            values[i] = obj[_keys[i]];\n        }\n        return values;\n    }\n\n    // Convert an object into a list of `[key, value]` pairs.\n    // The opposite of `_.object` with one argument.\n    function pairs(obj) {\n        var _keys = keys(obj);\n        var length = _keys.length;\n        var pairs = Array(length);\n        for (var i = 0; i < length; i++) {\n            pairs[i] = [_keys[i], obj[_keys[i]]];\n        }\n        return pairs;\n    }\n\n    // Invert the keys and values of an object. The values must be serializable.\n    function invert(obj) {\n        var result = {};\n        var _keys = keys(obj);\n        for (var i = 0, length = _keys.length; i < length; i++) {\n            result[obj[_keys[i]]] = _keys[i];\n        }\n        return result;\n    }\n\n    // Return a sorted list of the function names available on the object.\n    function functions(obj) {\n        var names = [];\n        for (var key in obj) {\n            if (isFunction$1(obj[key])) names.push(key);\n        }\n        return names.sort();\n    }\n\n    // An internal function for creating assigner functions.\n    function createAssigner(keysFunc, defaults) {\n        return function(obj) {\n            var length = arguments.length;\n            if (defaults) obj = Object(obj);\n            if (length < 2 || obj == null) return obj;\n            for (var index = 1; index < length; index++) {\n                var source = arguments[index],\n                    keys = keysFunc(source),\n                    l = keys.length;\n                for (var i = 0; i < l; i++) {\n                    var key = keys[i];\n                    if (!defaults || obj[key] === void 0) obj[key] = source[key];\n                }\n            }\n            return obj;\n        };\n    }\n\n    // Extend a given object with all the properties in passed-in object(s).\n    var extend = createAssigner(allKeys);\n\n    // Assigns a given object with all the own properties in the passed-in\n    // object(s).\n    // (https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)\n    var extendOwn = createAssigner(keys);\n\n    // Fill in a given object with default properties.\n    var defaults = createAssigner(allKeys, true);\n\n    // Create a naked function reference for surrogate-prototype-swapping.\n    function ctor() {\n        return function(){};\n    }\n\n    // An internal function for creating a new object that inherits from another.\n    function baseCreate(prototype) {\n        if (!isObject(prototype)) return {};\n        if (nativeCreate) return nativeCreate(prototype);\n        var Ctor = ctor();\n        Ctor.prototype = prototype;\n        var result = new Ctor;\n        Ctor.prototype = null;\n        return result;\n    }\n\n    // Creates an object that inherits from the given prototype object.\n    // If additional properties are provided then they will be added to the\n    // created object.\n    function create(prototype, props) {\n        var result = baseCreate(prototype);\n        if (props) extendOwn(result, props);\n        return result;\n    }\n\n    // Create a (shallow-cloned) duplicate of an object.\n    function clone(obj) {\n        if (!isObject(obj)) return obj;\n        return isArray(obj) ? obj.slice() : extend({}, obj);\n    }\n\n    // Invokes `interceptor` with the `obj` and then returns `obj`.\n    // The primary purpose of this method is to \"tap into\" a method chain, in\n    // order to perform operations on intermediate results within the chain.\n    function tap(obj, interceptor) {\n        interceptor(obj);\n        return obj;\n    }\n\n    // Normalize a (deep) property `path` to array.\n    // Like `_.iteratee`, this function can be customized.\n    function toPath$1(path) {\n        return isArray(path) ? path : [path];\n    }\n    _$1.toPath = toPath$1;\n\n    // Internal wrapper for `_.toPath` to enable minification.\n    // Similar to `cb` for `_.iteratee`.\n    function toPath(path) {\n        return _$1.toPath(path);\n    }\n\n    // Internal function to obtain a nested property in `obj` along `path`.\n    function deepGet(obj, path) {\n        var length = path.length;\n        for (var i = 0; i < length; i++) {\n            if (obj == null) return void 0;\n            obj = obj[path[i]];\n        }\n        return length ? obj : void 0;\n    }\n\n    // Get the value of the (deep) property on `path` from `object`.\n    // If any property in `path` does not exist or if the value is\n    // `undefined`, return `defaultValue` instead.\n    // The `path` is normalized through `_.toPath`.\n    function get(object, path, defaultValue) {\n        var value = deepGet(object, toPath(path));\n        return isUndefined(value) ? defaultValue : value;\n    }\n\n    // Shortcut function for checking if an object has a given property directly on\n    // itself (in other words, not on a prototype). Unlike the internal `has`\n    // function, this public version can also traverse nested properties.\n    function has(obj, path) {\n        path = toPath(path);\n        var length = path.length;\n        for (var i = 0; i < length; i++) {\n            var key = path[i];\n            if (!has$1(obj, key)) return false;\n            obj = obj[key];\n        }\n        return !!length;\n    }\n\n    // Keep the identity function around for default iteratees.\n    function identity(value) {\n        return value;\n    }\n\n    // Returns a predicate for checking whether an object has a given set of\n    // `key:value` pairs.\n    function matcher(attrs) {\n        attrs = extendOwn({}, attrs);\n        return function(obj) {\n            return isMatch(obj, attrs);\n        };\n    }\n\n    // Creates a function that, when passed an object, will traverse that object\u2019s\n    // properties down the given `path`, specified as an array of keys or indices.\n    function property(path) {\n        path = toPath(path);\n        return function(obj) {\n            return deepGet(obj, path);\n        };\n    }\n\n    // Internal function that returns an efficient (for current engines) version\n    // of the passed-in callback, to be repeatedly applied in other Underscore\n    // functions.\n    function optimizeCb(func, context, argCount) {\n        if (context === void 0) return func;\n        switch (argCount == null ? 3 : argCount) {\n            case 1: return function(value) {\n                return func.call(context, value);\n            };\n            // The 2-argument case is omitted because we\u2019re not using it.\n            case 3: return function(value, index, collection) {\n                return func.call(context, value, index, collection);\n            };\n            case 4: return function(accumulator, value, index, collection) {\n                return func.call(context, accumulator, value, index, collection);\n            };\n        }\n        return function() {\n            return func.apply(context, arguments);\n        };\n    }\n\n    // An internal function to generate callbacks that can be applied to each\n    // element in a collection, returning the desired result \u2014 either `_.identity`,\n    // an arbitrary callback, a property matcher, or a property accessor.\n    function baseIteratee(value, context, argCount) {\n        if (value == null) return identity;\n        if (isFunction$1(value)) return optimizeCb(value, context, argCount);\n        if (isObject(value) && !isArray(value)) return matcher(value);\n        return property(value);\n    }\n\n    // External wrapper for our callback generator. Users may customize\n    // `_.iteratee` if they want additional predicate/iteratee shorthand styles.\n    // This abstraction hides the internal-only `argCount` argument.\n    function iteratee(value, context) {\n        return baseIteratee(value, context, Infinity);\n    }\n    _$1.iteratee = iteratee;\n\n    // The function we call internally to generate a callback. It invokes\n    // `_.iteratee` if overridden, otherwise `baseIteratee`.\n    function cb(value, context, argCount) {\n        if (_$1.iteratee !== iteratee) return _$1.iteratee(value, context);\n        return baseIteratee(value, context, argCount);\n    }\n\n    // Returns the results of applying the `iteratee` to each element of `obj`.\n    // In contrast to `_.map` it returns an object.\n    function mapObject(obj, iteratee, context) {\n        iteratee = cb(iteratee, context);\n        var _keys = keys(obj),\n            length = _keys.length,\n            results = {};\n        for (var index = 0; index < length; index++) {\n            var currentKey = _keys[index];\n            results[currentKey] = iteratee(obj[currentKey], currentKey, obj);\n        }\n        return results;\n    }\n\n    // Predicate-generating function. Often useful outside of Underscore.\n    function noop(){}\n\n    // Generates a function for a given object that returns a given property.\n    function propertyOf(obj) {\n        if (obj == null) return noop;\n        return function(path) {\n            return get(obj, path);\n        };\n    }\n\n    // Run a function **n** times.\n    function times(n, iteratee, context) {\n        var accum = Array(Math.max(0, n));\n        iteratee = optimizeCb(iteratee, context, 1);\n        for (var i = 0; i < n; i++) accum[i] = iteratee(i);\n        return accum;\n    }\n\n    // Return a random integer between `min` and `max` (inclusive).\n    function random(min, max) {\n        if (max == null) {\n            max = min;\n            min = 0;\n        }\n        return min + Math.floor(Math.random() * (max - min + 1));\n    }\n\n    // A (possibly faster) way to get the current timestamp as an integer.\n    var now = Date.now || function() {\n        return new Date().getTime();\n    };\n\n    // Internal helper to generate functions for escaping and unescaping strings\n    // to/from HTML interpolation.\n    function createEscaper(map) {\n        var escaper = function(match) {\n            return map[match];\n        };\n        // Regexes for identifying a key that needs to be escaped.\n        var source = '(?:' + keys(map).join('|') + ')';\n        var testRegexp = RegExp(source);\n        var replaceRegexp = RegExp(source, 'g');\n        return function(string) {\n            string = string == null ? '' : '' + string;\n            return testRegexp.test(string) ? string.replace(replaceRegexp, escaper) : string;\n        };\n    }\n\n    // Internal list of HTML entities for escaping.\n    var escapeMap = {\n        '&': '&amp;',\n        '<': '&lt;',\n        '>': '&gt;',\n        '\"': '&quot;',\n        \"'\": '&#x27;',\n        '`': '&#x60;'\n    };\n\n    // Function for escaping strings to HTML interpolation.\n    var _escape = createEscaper(escapeMap);\n\n    // Internal list of HTML entities for unescaping.\n    var unescapeMap = invert(escapeMap);\n\n    // Function for unescaping strings from HTML interpolation.\n    var _unescape = createEscaper(unescapeMap);\n\n    // By default, Underscore uses ERB-style template delimiters. Change the\n    // following template settings to use alternative delimiters.\n    var templateSettings = _$1.templateSettings = {\n        evaluate: /<%([\\s\\S]+?)%>/g,\n        interpolate: /<%=([\\s\\S]+?)%>/g,\n        escape: /<%-([\\s\\S]+?)%>/g\n    };\n\n    // When customizing `_.templateSettings`, if you don't want to define an\n    // interpolation, evaluation or escaping regex, we need one that is\n    // guaranteed not to match.\n    var noMatch = /(.)^/;\n\n    // Certain characters need to be escaped so that they can be put into a\n    // string literal.\n    var escapes = {\n        \"'\": \"'\",\n        '\\\\': '\\\\',\n        '\\r': 'r',\n        '\\n': 'n',\n        '\\u2028': 'u2028',\n        '\\u2029': 'u2029'\n    };\n\n    var escapeRegExp = /\\\\|'|\\r|\\n|\\u2028|\\u2029/g;\n\n    function escapeChar(match) {\n        return '\\\\' + escapes[match];\n    }\n\n    // In order to prevent third-party code injection through\n    // `_.templateSettings.variable`, we test it against the following regular\n    // expression. It is intentionally a bit more liberal than just matching valid\n    // identifiers, but still prevents possible loopholes through defaults or\n    // destructuring assignment.\n    var bareIdentifier = /^\\s*(\\w|\\$)+\\s*$/;\n\n    // JavaScript micro-templating, similar to John Resig's implementation.\n    // Underscore templating handles arbitrary delimiters, preserves whitespace,\n    // and correctly escapes quotes within interpolated code.\n    // NB: `oldSettings` only exists for backwards compatibility.\n    function template(text, settings, oldSettings) {\n        if (!settings && oldSettings) settings = oldSettings;\n        settings = defaults({}, settings, _$1.templateSettings);\n\n        // Combine delimiters into one regular expression via alternation.\n        var matcher = RegExp([\n            (settings.escape || noMatch).source,\n            (settings.interpolate || noMatch).source,\n            (settings.evaluate || noMatch).source\n        ].join('|') + '|$', 'g');\n\n        // Compile the template source, escaping string literals appropriately.\n        var index = 0;\n        var source = \"__p+='\";\n        text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {\n            source += text.slice(index, offset).replace(escapeRegExp, escapeChar);\n            index = offset + match.length;\n\n            if (escape) {\n                source += \"'+\\n((__t=(\" + escape + \"))==null?'':_.escape(__t))+\\n'\";\n            } else if (interpolate) {\n                source += \"'+\\n((__t=(\" + interpolate + \"))==null?'':__t)+\\n'\";\n            } else if (evaluate) {\n                source += \"';\\n\" + evaluate + \"\\n__p+='\";\n            }\n\n            // Adobe VMs need the match returned to produce the correct offset.\n            return match;\n        });\n        source += \"';\\n\";\n\n        var argument = settings.variable;\n        if (argument) {\n            // Insure against third-party code injection. (CVE-2021-23358)\n            if (!bareIdentifier.test(argument)) throw new Error(\n                'variable is not a bare identifier: ' + argument\n            );\n        } else {\n            // If a variable is not specified, place data values in local scope.\n            source = 'with(obj||{}){\\n' + source + '}\\n';\n            argument = 'obj';\n        }\n\n        source = \"var __t,__p='',__j=Array.prototype.join,\" +\n            \"print=function(){__p+=__j.call(arguments,'');};\\n\" +\n            source + 'return __p;\\n';\n\n        var render;\n        try {\n            render = new Function(argument, '_', source);\n        } catch (e) {\n            e.source = source;\n            throw e;\n        }\n\n        var template = function(data) {\n            return render.call(this, data, _$1);\n        };\n\n        // Provide the compiled source as a convenience for precompilation.\n        template.source = 'function(' + argument + '){\\n' + source + '}';\n\n        return template;\n    }\n\n    // Traverses the children of `obj` along `path`. If a child is a function, it\n    // is invoked with its parent as context. Returns the value of the final\n    // child, or `fallback` if any child is undefined.\n    function result(obj, path, fallback) {\n        path = toPath(path);\n        var length = path.length;\n        if (!length) {\n            return isFunction$1(fallback) ? fallback.call(obj) : fallback;\n        }\n        for (var i = 0; i < length; i++) {\n            var prop = obj == null ? void 0 : obj[path[i]];\n            if (prop === void 0) {\n                prop = fallback;\n                i = length; // Ensure we don't continue iterating.\n            }\n            obj = isFunction$1(prop) ? prop.call(obj) : prop;\n        }\n        return obj;\n    }\n\n    // Generate a unique integer id (unique within the entire client session).\n    // Useful for temporary DOM ids.\n    var idCounter = 0;\n    function uniqueId(prefix) {\n        var id = ++idCounter + '';\n        return prefix ? prefix + id : id;\n    }\n\n    // Start chaining a wrapped Underscore object.\n    function chain(obj) {\n        var instance = _$1(obj);\n        instance._chain = true;\n        return instance;\n    }\n\n    // Internal function to execute `sourceFunc` bound to `context` with optional\n    // `args`. Determines whether to execute a function as a constructor or as a\n    // normal function.\n    function executeBound(sourceFunc, boundFunc, context, callingContext, args) {\n        if (!(callingContext instanceof boundFunc)) return sourceFunc.apply(context, args);\n        var self = baseCreate(sourceFunc.prototype);\n        var result = sourceFunc.apply(self, args);\n        if (isObject(result)) return result;\n        return self;\n    }\n\n    // Partially apply a function by creating a version that has had some of its\n    // arguments pre-filled, without changing its dynamic `this` context. `_` acts\n    // as a placeholder by default, allowing any combination of arguments to be\n    // pre-filled. Set `_.partial.placeholder` for a custom placeholder argument.\n    var partial = restArguments(function(func, boundArgs) {\n        var placeholder = partial.placeholder;\n        var bound = function() {\n            var position = 0, length = boundArgs.length;\n            var args = Array(length);\n            for (var i = 0; i < length; i++) {\n                args[i] = boundArgs[i] === placeholder ? arguments[position++] : boundArgs[i];\n            }\n            while (position < arguments.length) args.push(arguments[position++]);\n            return executeBound(func, bound, this, this, args);\n        };\n        return bound;\n    });\n\n    partial.placeholder = _$1;\n\n    // Create a function bound to a given object (assigning `this`, and arguments,\n    // optionally).\n    var bind = restArguments(function(func, context, args) {\n        if (!isFunction$1(func)) throw new TypeError('Bind must be called on a function');\n        var bound = restArguments(function(callArgs) {\n            return executeBound(func, bound, context, this, args.concat(callArgs));\n        });\n        return bound;\n    });\n\n    // Internal helper for collection methods to determine whether a collection\n    // should be iterated as an array or as an object.\n    // Related: https://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength\n    // Avoids a very nasty iOS 8 JIT bug on ARM-64. #2094\n    var isArrayLike = createSizePropertyCheck(getLength);\n\n    // Internal implementation of a recursive `flatten` function.\n    function flatten$1(input, depth, strict, output) {\n        output = output || [];\n        if (!depth && depth !== 0) {\n            depth = Infinity;\n        } else if (depth <= 0) {\n            return output.concat(input);\n        }\n        var idx = output.length;\n        for (var i = 0, length = getLength(input); i < length; i++) {\n            var value = input[i];\n            if (isArrayLike(value) && (isArray(value) || isArguments$1(value))) {\n                // Flatten current level of array or arguments object.\n                if (depth > 1) {\n                    flatten$1(value, depth - 1, strict, output);\n                    idx = output.length;\n                } else {\n                    var j = 0, len = value.length;\n                    while (j < len) output[idx++] = value[j++];\n                }\n            } else if (!strict) {\n                output[idx++] = value;\n            }\n        }\n        return output;\n    }\n\n    // Bind a number of an object's methods to that object. Remaining arguments\n    // are the method names to be bound. Useful for ensuring that all callbacks\n    // defined on an object belong to it.\n    var bindAll = restArguments(function(obj, keys) {\n        keys = flatten$1(keys, false, false);\n        var index = keys.length;\n        if (index < 1) throw new Error('bindAll must be passed function names');\n        while (index--) {\n            var key = keys[index];\n            obj[key] = bind(obj[key], obj);\n        }\n        return obj;\n    });\n\n    // Memoize an expensive function by storing its results.\n    function memoize(func, hasher) {\n        var memoize = function(key) {\n            var cache = memoize.cache;\n            var address = '' + (hasher ? hasher.apply(this, arguments) : key);\n            if (!has$1(cache, address)) cache[address] = func.apply(this, arguments);\n            return cache[address];\n        };\n        memoize.cache = {};\n        return memoize;\n    }\n\n    // Delays a function for the given number of milliseconds, and then calls\n    // it with the arguments supplied.\n    var delay = restArguments(function(func, wait, args) {\n        return setTimeout(function() {\n            return func.apply(null, args);\n        }, wait);\n    });\n\n    // Defers a function, scheduling it to run after the current call stack has\n    // cleared.\n    var defer = partial(delay, _$1, 1);\n\n    // Returns a function, that, when invoked, will only be triggered at most once\n    // during a given window of time. Normally, the throttled function will run\n    // as much as it can, without ever going more than once per `wait` duration;\n    // but if you'd like to disable the execution on the leading edge, pass\n    // `{leading: false}`. To disable execution on the trailing edge, ditto.\n    function throttle(func, wait, options) {\n        var timeout, context, args, result;\n        var previous = 0;\n        if (!options) options = {};\n\n        var later = function() {\n            previous = options.leading === false ? 0 : now();\n            timeout = null;\n            result = func.apply(context, args);\n            if (!timeout) context = args = null;\n        };\n\n        var throttled = function() {\n            var _now = now();\n            if (!previous && options.leading === false) previous = _now;\n            var remaining = wait - (_now - previous);\n            context = this;\n            args = arguments;\n            if (remaining <= 0 || remaining > wait) {\n                if (timeout) {\n                    clearTimeout(timeout);\n                    timeout = null;\n                }\n                previous = _now;\n                result = func.apply(context, args);\n                if (!timeout) context = args = null;\n            } else if (!timeout && options.trailing !== false) {\n                timeout = setTimeout(later, remaining);\n            }\n            return result;\n        };\n\n        throttled.cancel = function() {\n            clearTimeout(timeout);\n            previous = 0;\n            timeout = context = args = null;\n        };\n\n        return throttled;\n    }\n\n    // When a sequence of calls of the returned function ends, the argument\n    // function is triggered. The end of a sequence is defined by the `wait`\n    // parameter. If `immediate` is passed, the argument function will be\n    // triggered at the beginning of the sequence instead of at the end.\n    function debounce(func, wait, immediate) {\n        var timeout, previous, args, result, context;\n\n        var later = function() {\n            var passed = now() - previous;\n            if (wait > passed) {\n                timeout = setTimeout(later, wait - passed);\n            } else {\n                timeout = null;\n                if (!immediate) result = func.apply(context, args);\n                // This check is needed because `func` can recursively invoke `debounced`.\n                if (!timeout) args = context = null;\n            }\n        };\n\n        var debounced = restArguments(function(_args) {\n            context = this;\n            args = _args;\n            previous = now();\n            if (!timeout) {\n                timeout = setTimeout(later, wait);\n                if (immediate) result = func.apply(context, args);\n            }\n            return result;\n        });\n\n        debounced.cancel = function() {\n            clearTimeout(timeout);\n            timeout = args = context = null;\n        };\n\n        return debounced;\n    }\n\n    // Returns the first function passed as an argument to the second,\n    // allowing you to adjust arguments, run code before and after, and\n    // conditionally execute the original function.\n    function wrap(func, wrapper) {\n        return partial(wrapper, func);\n    }\n\n    // Returns a negated version of the passed-in predicate.\n    function negate(predicate) {\n        return function() {\n            return !predicate.apply(this, arguments);\n        };\n    }\n\n    // Returns a function that is the composition of a list of functions, each\n    // consuming the return value of the function that follows.\n    function compose() {\n        var args = arguments;\n        var start = args.length - 1;\n        return function() {\n            var i = start;\n            var result = args[start].apply(this, arguments);\n            while (i--) result = args[i].call(this, result);\n            return result;\n        };\n    }\n\n    // Returns a function that will only be executed on and after the Nth call.\n    function after(times, func) {\n        return function() {\n            if (--times < 1) {\n                return func.apply(this, arguments);\n            }\n        };\n    }\n\n    // Returns a function that will only be executed up to (but not including) the\n    // Nth call.\n    function before(times, func) {\n        var memo;\n        return function() {\n            if (--times > 0) {\n                memo = func.apply(this, arguments);\n            }\n            if (times <= 1) func = null;\n            return memo;\n        };\n    }\n\n    // Returns a function that will be executed at most one time, no matter how\n    // often you call it. Useful for lazy initialization.\n    var once = partial(before, 2);\n\n    // Returns the first key on an object that passes a truth test.\n    function findKey(obj, predicate, context) {\n        predicate = cb(predicate, context);\n        var _keys = keys(obj), key;\n        for (var i = 0, length = _keys.length; i < length; i++) {\n            key = _keys[i];\n            if (predicate(obj[key], key, obj)) return key;\n        }\n    }\n\n    // Internal function to generate `_.findIndex` and `_.findLastIndex`.\n    function createPredicateIndexFinder(dir) {\n        return function(array, predicate, context) {\n            predicate = cb(predicate, context);\n            var length = getLength(array);\n            var index = dir > 0 ? 0 : length - 1;\n            for (; index >= 0 && index < length; index += dir) {\n                if (predicate(array[index], index, array)) return index;\n            }\n            return -1;\n        };\n    }\n\n    // Returns the first index on an array-like that passes a truth test.\n    var findIndex = createPredicateIndexFinder(1);\n\n    // Returns the last index on an array-like that passes a truth test.\n    var findLastIndex = createPredicateIndexFinder(-1);\n\n    // Use a comparator function to figure out the smallest index at which\n    // an object should be inserted so as to maintain order. Uses binary search.\n    function sortedIndex(array, obj, iteratee, context) {\n        iteratee = cb(iteratee, context, 1);\n        var value = iteratee(obj);\n        var low = 0, high = getLength(array);\n        while (low < high) {\n            var mid = Math.floor((low + high) / 2);\n            if (iteratee(array[mid]) < value) low = mid + 1; else high = mid;\n        }\n        return low;\n    }\n\n    // Internal function to generate the `_.indexOf` and `_.lastIndexOf` functions.\n    function createIndexFinder(dir, predicateFind, sortedIndex) {\n        return function(array, item, idx) {\n            var i = 0, length = getLength(array);\n            if (typeof idx == 'number') {\n                if (dir > 0) {\n                    i = idx >= 0 ? idx : Math.max(idx + length, i);\n                } else {\n                    length = idx >= 0 ? Math.min(idx + 1, length) : idx + length + 1;\n                }\n            } else if (sortedIndex && idx && length) {\n                idx = sortedIndex(array, item);\n                return array[idx] === item ? idx : -1;\n            }\n            if (item !== item) {\n                idx = predicateFind(slice.call(array, i, length), isNaN$1);\n                return idx >= 0 ? idx + i : -1;\n            }\n            for (idx = dir > 0 ? i : length - 1; idx >= 0 && idx < length; idx += dir) {\n                if (array[idx] === item) return idx;\n            }\n            return -1;\n        };\n    }\n\n    // Return the position of the first occurrence of an item in an array,\n    // or -1 if the item is not included in the array.\n    // If the array is large and already in sort order, pass `true`\n    // for **isSorted** to use binary search.\n    var indexOf = createIndexFinder(1, findIndex, sortedIndex);\n\n    // Return the position of the last occurrence of an item in an array,\n    // or -1 if the item is not included in the array.\n    var lastIndexOf = createIndexFinder(-1, findLastIndex);\n\n    // Return the first value which passes a truth test.\n    function find(obj, predicate, context) {\n        var keyFinder = isArrayLike(obj) ? findIndex : findKey;\n        var key = keyFinder(obj, predicate, context);\n        if (key !== void 0 && key !== -1) return obj[key];\n    }\n\n    // Convenience version of a common use case of `_.find`: getting the first\n    // object containing specific `key:value` pairs.\n    function findWhere(obj, attrs) {\n        return find(obj, matcher(attrs));\n    }\n\n    // The cornerstone for collection functions, an `each`\n    // implementation, aka `forEach`.\n    // Handles raw objects in addition to array-likes. Treats all\n    // sparse array-likes as if they were dense.\n    function each(obj, iteratee, context) {\n        iteratee = optimizeCb(iteratee, context);\n        var i, length;\n        if (isArrayLike(obj)) {\n            for (i = 0, length = obj.length; i < length; i++) {\n                iteratee(obj[i], i, obj);\n            }\n        } else {\n            var _keys = keys(obj);\n            for (i = 0, length = _keys.length; i < length; i++) {\n                iteratee(obj[_keys[i]], _keys[i], obj);\n            }\n        }\n        return obj;\n    }\n\n    // Return the results of applying the iteratee to each element.\n    function map(obj, iteratee, context) {\n        iteratee = cb(iteratee, context);\n        var _keys = !isArrayLike(obj) && keys(obj),\n            length = (_keys || obj).length,\n            results = Array(length);\n        for (var index = 0; index < length; index++) {\n            var currentKey = _keys ? _keys[index] : index;\n            results[index] = iteratee(obj[currentKey], currentKey, obj);\n        }\n        return results;\n    }\n\n    // Internal helper to create a reducing function, iterating left or right.\n    function createReduce(dir) {\n        // Wrap code that reassigns argument variables in a separate function than\n        // the one that accesses `arguments.length` to avoid a perf hit. (#1991)\n        var reducer = function(obj, iteratee, memo, initial) {\n            var _keys = !isArrayLike(obj) && keys(obj),\n                length = (_keys || obj).length,\n                index = dir > 0 ? 0 : length - 1;\n            if (!initial) {\n                memo = obj[_keys ? _keys[index] : index];\n                index += dir;\n            }\n            for (; index >= 0 && index < length; index += dir) {\n                var currentKey = _keys ? _keys[index] : index;\n                memo = iteratee(memo, obj[currentKey], currentKey, obj);\n            }\n            return memo;\n        };\n\n        return function(obj, iteratee, memo, context) {\n            var initial = arguments.length >= 3;\n            return reducer(obj, optimizeCb(iteratee, context, 4), memo, initial);\n        };\n    }\n\n    // **Reduce** builds up a single result from a list of values, aka `inject`,\n    // or `foldl`.\n    var reduce = createReduce(1);\n\n    // The right-associative version of reduce, also known as `foldr`.\n    var reduceRight = createReduce(-1);\n\n    // Return all the elements that pass a truth test.\n    function filter(obj, predicate, context) {\n        var results = [];\n        predicate = cb(predicate, context);\n        each(obj, function(value, index, list) {\n            if (predicate(value, index, list)) results.push(value);\n        });\n        return results;\n    }\n\n    // Return all the elements for which a truth test fails.\n    function reject(obj, predicate, context) {\n        return filter(obj, negate(cb(predicate)), context);\n    }\n\n    // Determine whether all of the elements pass a truth test.\n    function every(obj, predicate, context) {\n        predicate = cb(predicate, context);\n        var _keys = !isArrayLike(obj) && keys(obj),\n            length = (_keys || obj).length;\n        for (var index = 0; index < length; index++) {\n            var currentKey = _keys ? _keys[index] : index;\n            if (!predicate(obj[currentKey], currentKey, obj)) return false;\n        }\n        return true;\n    }\n\n    // Determine if at least one element in the object passes a truth test.\n    function some(obj, predicate, context) {\n        predicate = cb(predicate, context);\n        var _keys = !isArrayLike(obj) && keys(obj),\n            length = (_keys || obj).length;\n        for (var index = 0; index < length; index++) {\n            var currentKey = _keys ? _keys[index] : index;\n            if (predicate(obj[currentKey], currentKey, obj)) return true;\n        }\n        return false;\n    }\n\n    // Determine if the array or object contains a given item (using `===`).\n    function contains(obj, item, fromIndex, guard) {\n        if (!isArrayLike(obj)) obj = values(obj);\n        if (typeof fromIndex != 'number' || guard) fromIndex = 0;\n        return indexOf(obj, item, fromIndex) >= 0;\n    }\n\n    // Invoke a method (with arguments) on every item in a collection.\n    var invoke = restArguments(function(obj, path, args) {\n        var contextPath, func;\n        if (isFunction$1(path)) {\n            func = path;\n        } else {\n            path = toPath(path);\n            contextPath = path.slice(0, -1);\n            path = path[path.length - 1];\n        }\n        return map(obj, function(context) {\n            var method = func;\n            if (!method) {\n                if (contextPath && contextPath.length) {\n                    context = deepGet(context, contextPath);\n                }\n                if (context == null) return void 0;\n                method = context[path];\n            }\n            return method == null ? method : method.apply(context, args);\n        });\n    });\n\n    // Convenience version of a common use case of `_.map`: fetching a property.\n    function pluck(obj, key) {\n        return map(obj, property(key));\n    }\n\n    // Convenience version of a common use case of `_.filter`: selecting only\n    // objects containing specific `key:value` pairs.\n    function where(obj, attrs) {\n        return filter(obj, matcher(attrs));\n    }\n\n    // Return the maximum element (or element-based computation).\n    function max(obj, iteratee, context) {\n        var result = -Infinity, lastComputed = -Infinity,\n            value, computed;\n        if (iteratee == null || (typeof iteratee == 'number' && typeof obj[0] != 'object' && obj != null)) {\n            obj = isArrayLike(obj) ? obj : values(obj);\n            for (var i = 0, length = obj.length; i < length; i++) {\n                value = obj[i];\n                if (value != null && value > result) {\n                    result = value;\n                }\n            }\n        } else {\n            iteratee = cb(iteratee, context);\n            each(obj, function(v, index, list) {\n                computed = iteratee(v, index, list);\n                if (computed > lastComputed || (computed === -Infinity && result === -Infinity)) {\n                    result = v;\n                    lastComputed = computed;\n                }\n            });\n        }\n        return result;\n    }\n\n    // Return the minimum element (or element-based computation).\n    function min(obj, iteratee, context) {\n        var result = Infinity, lastComputed = Infinity,\n            value, computed;\n        if (iteratee == null || (typeof iteratee == 'number' && typeof obj[0] != 'object' && obj != null)) {\n            obj = isArrayLike(obj) ? obj : values(obj);\n            for (var i = 0, length = obj.length; i < length; i++) {\n                value = obj[i];\n                if (value != null && value < result) {\n                    result = value;\n                }\n            }\n        } else {\n            iteratee = cb(iteratee, context);\n            each(obj, function(v, index, list) {\n                computed = iteratee(v, index, list);\n                if (computed < lastComputed || (computed === Infinity && result === Infinity)) {\n                    result = v;\n                    lastComputed = computed;\n                }\n            });\n        }\n        return result;\n    }\n\n    // Safely create a real, live array from anything iterable.\n    var reStrSymbol = /[^\\ud800-\\udfff]|[\\ud800-\\udbff][\\udc00-\\udfff]|[\\ud800-\\udfff]/g;\n    function toArray(obj) {\n        if (!obj) return [];\n        if (isArray(obj)) return slice.call(obj);\n        if (isString(obj)) {\n            // Keep surrogate pair characters together.\n            return obj.match(reStrSymbol);\n        }\n        if (isArrayLike(obj)) return map(obj, identity);\n        return values(obj);\n    }\n\n    // Sample **n** random values from a collection using the modern version of the\n    // [Fisher-Yates shuffle](https://en.wikipedia.org/wiki/Fisher\u2013Yates_shuffle).\n    // If **n** is not specified, returns a single random element.\n    // The internal `guard` argument allows it to work with `_.map`.\n    function sample(obj, n, guard) {\n        if (n == null || guard) {\n            if (!isArrayLike(obj)) obj = values(obj);\n            return obj[random(obj.length - 1)];\n        }\n        var sample = toArray(obj);\n        var length = getLength(sample);\n        n = Math.max(Math.min(n, length), 0);\n        var last = length - 1;\n        for (var index = 0; index < n; index++) {\n            var rand = random(index, last);\n            var temp = sample[index];\n            sample[index] = sample[rand];\n            sample[rand] = temp;\n        }\n        return sample.slice(0, n);\n    }\n\n    // Shuffle a collection.\n    function shuffle(obj) {\n        return sample(obj, Infinity);\n    }\n\n    // Sort the object's values by a criterion produced by an iteratee.\n    function sortBy(obj, iteratee, context) {\n        var index = 0;\n        iteratee = cb(iteratee, context);\n        return pluck(map(obj, function(value, key, list) {\n            return {\n                value: value,\n                index: index++,\n                criteria: iteratee(value, key, list)\n            };\n        }).sort(function(left, right) {\n            var a = left.criteria;\n            var b = right.criteria;\n            if (a !== b) {\n                if (a > b || a === void 0) return 1;\n                if (a < b || b === void 0) return -1;\n            }\n            return left.index - right.index;\n        }), 'value');\n    }\n\n    // An internal function used for aggregate \"group by\" operations.\n    function group(behavior, partition) {\n        return function(obj, iteratee, context) {\n            var result = partition ? [[], []] : {};\n            iteratee = cb(iteratee, context);\n            each(obj, function(value, index) {\n                var key = iteratee(value, index, obj);\n                behavior(result, value, key);\n            });\n            return result;\n        };\n    }\n\n    // Groups the object's values by a criterion. Pass either a string attribute\n    // to group by, or a function that returns the criterion.\n    var groupBy = group(function(result, value, key) {\n        if (has$1(result, key)) result[key].push(value); else result[key] = [value];\n    });\n\n    // Indexes the object's values by a criterion, similar to `_.groupBy`, but for\n    // when you know that your index values will be unique.\n    var indexBy = group(function(result, value, key) {\n        result[key] = value;\n    });\n\n    // Counts instances of an object that group by a certain criterion. Pass\n    // either a string attribute to count by, or a function that returns the\n    // criterion.\n    var countBy = group(function(result, value, key) {\n        if (has$1(result, key)) result[key]++; else result[key] = 1;\n    });\n\n    // Split a collection into two arrays: one whose elements all pass the given\n    // truth test, and one whose elements all do not pass the truth test.\n    var partition = group(function(result, value, pass) {\n        result[pass ? 0 : 1].push(value);\n    }, true);\n\n    // Return the number of elements in a collection.\n    function size(obj) {\n        if (obj == null) return 0;\n        return isArrayLike(obj) ? obj.length : keys(obj).length;\n    }\n\n    // Internal `_.pick` helper function to determine whether `key` is an enumerable\n    // property name of `obj`.\n    function keyInObj(value, key, obj) {\n        return key in obj;\n    }\n\n    // Return a copy of the object only containing the allowed properties.\n    var pick = restArguments(function(obj, keys) {\n        var result = {}, iteratee = keys[0];\n        if (obj == null) return result;\n        if (isFunction$1(iteratee)) {\n            if (keys.length > 1) iteratee = optimizeCb(iteratee, keys[1]);\n            keys = allKeys(obj);\n        } else {\n            iteratee = keyInObj;\n            keys = flatten$1(keys, false, false);\n            obj = Object(obj);\n        }\n        for (var i = 0, length = keys.length; i < length; i++) {\n            var key = keys[i];\n            var value = obj[key];\n            if (iteratee(value, key, obj)) result[key] = value;\n        }\n        return result;\n    });\n\n    // Return a copy of the object without the disallowed properties.\n    var omit = restArguments(function(obj, keys) {\n        var iteratee = keys[0], context;\n        if (isFunction$1(iteratee)) {\n            iteratee = negate(iteratee);\n            if (keys.length > 1) context = keys[1];\n        } else {\n            keys = map(flatten$1(keys, false, false), String);\n            iteratee = function(value, key) {\n                return !contains(keys, key);\n            };\n        }\n        return pick(obj, iteratee, context);\n    });\n\n    // Returns everything but the last entry of the array. Especially useful on\n    // the arguments object. Passing **n** will return all the values in\n    // the array, excluding the last N.\n    function initial(array, n, guard) {\n        return slice.call(array, 0, Math.max(0, array.length - (n == null || guard ? 1 : n)));\n    }\n\n    // Get the first element of an array. Passing **n** will return the first N\n    // values in the array. The **guard** check allows it to work with `_.map`.\n    function first(array, n, guard) {\n        if (array == null || array.length < 1) return n == null || guard ? void 0 : [];\n        if (n == null || guard) return array[0];\n        return initial(array, array.length - n);\n    }\n\n    // Returns everything but the first entry of the `array`. Especially useful on\n    // the `arguments` object. Passing an **n** will return the rest N values in the\n    // `array`.\n    function rest(array, n, guard) {\n        return slice.call(array, n == null || guard ? 1 : n);\n    }\n\n    // Get the last element of an array. Passing **n** will return the last N\n    // values in the array.\n    function last(array, n, guard) {\n        if (array == null || array.length < 1) return n == null || guard ? void 0 : [];\n        if (n == null || guard) return array[array.length - 1];\n        return rest(array, Math.max(0, array.length - n));\n    }\n\n    // Trim out all falsy values from an array.\n    function compact(array) {\n        return filter(array, Boolean);\n    }\n\n    // Flatten out an array, either recursively (by default), or up to `depth`.\n    // Passing `true` or `false` as `depth` means `1` or `Infinity`, respectively.\n    function flatten(array, depth) {\n        return flatten$1(array, depth, false);\n    }\n\n    // Take the difference between one array and a number of other arrays.\n    // Only the elements present in just the first array will remain.\n    var difference = restArguments(function(array, rest) {\n        rest = flatten$1(rest, true, true);\n        return filter(array, function(value){\n            return !contains(rest, value);\n        });\n    });\n\n    // Return a version of the array that does not contain the specified value(s).\n    var without = restArguments(function(array, otherArrays) {\n        return difference(array, otherArrays);\n    });\n\n    // Produce a duplicate-free version of the array. If the array has already\n    // been sorted, you have the option of using a faster algorithm.\n    // The faster algorithm will not work with an iteratee if the iteratee\n    // is not a one-to-one function, so providing an iteratee will disable\n    // the faster algorithm.\n    function uniq(array, isSorted, iteratee, context) {\n        if (!isBoolean(isSorted)) {\n            context = iteratee;\n            iteratee = isSorted;\n            isSorted = false;\n        }\n        if (iteratee != null) iteratee = cb(iteratee, context);\n        var result = [];\n        var seen = [];\n        for (var i = 0, length = getLength(array); i < length; i++) {\n            var value = array[i],\n                computed = iteratee ? iteratee(value, i, array) : value;\n            if (isSorted && !iteratee) {\n                if (!i || seen !== computed) result.push(value);\n                seen = computed;\n            } else if (iteratee) {\n                if (!contains(seen, computed)) {\n                    seen.push(computed);\n                    result.push(value);\n                }\n            } else if (!contains(result, value)) {\n                result.push(value);\n            }\n        }\n        return result;\n    }\n\n    // Produce an array that contains the union: each distinct element from all of\n    // the passed-in arrays.\n    var union = restArguments(function(arrays) {\n        return uniq(flatten$1(arrays, true, true));\n    });\n\n    // Produce an array that contains every item shared between all the\n    // passed-in arrays.\n    function intersection(array) {\n        var result = [];\n        var argsLength = arguments.length;\n        for (var i = 0, length = getLength(array); i < length; i++) {\n            var item = array[i];\n            if (contains(result, item)) continue;\n            var j;\n            for (j = 1; j < argsLength; j++) {\n                if (!contains(arguments[j], item)) break;\n            }\n            if (j === argsLength) result.push(item);\n        }\n        return result;\n    }\n\n    // Complement of zip. Unzip accepts an array of arrays and groups\n    // each array's elements on shared indices.\n    function unzip(array) {\n        var length = (array && max(array, getLength).length) || 0;\n        var result = Array(length);\n\n        for (var index = 0; index < length; index++) {\n            result[index] = pluck(array, index);\n        }\n        return result;\n    }\n\n    // Zip together multiple lists into a single array -- elements that share\n    // an index go together.\n    var zip = restArguments(unzip);\n\n    // Converts lists into objects. Pass either a single array of `[key, value]`\n    // pairs, or two parallel arrays of the same length -- one of keys, and one of\n    // the corresponding values. Passing by pairs is the reverse of `_.pairs`.\n    function object(list, values) {\n        var result = {};\n        for (var i = 0, length = getLength(list); i < length; i++) {\n            if (values) {\n                result[list[i]] = values[i];\n            } else {\n                result[list[i][0]] = list[i][1];\n            }\n        }\n        return result;\n    }\n\n    // Generate an integer Array containing an arithmetic progression. A port of\n    // the native Python `range()` function. See\n    // [the Python documentation](https://docs.python.org/library/functions.html#range).\n    function range(start, stop, step) {\n        if (stop == null) {\n            stop = start || 0;\n            start = 0;\n        }\n        if (!step) {\n            step = stop < start ? -1 : 1;\n        }\n\n        var length = Math.max(Math.ceil((stop - start) / step), 0);\n        var range = Array(length);\n\n        for (var idx = 0; idx < length; idx++, start += step) {\n            range[idx] = start;\n        }\n\n        return range;\n    }\n\n    // Chunk a single array into multiple arrays, each containing `count` or fewer\n    // items.\n    function chunk(array, count) {\n        if (count == null || count < 1) return [];\n        var result = [];\n        var i = 0, length = array.length;\n        while (i < length) {\n            result.push(slice.call(array, i, i += count));\n        }\n        return result;\n    }\n\n    // Helper function to continue chaining intermediate results.\n    function chainResult(instance, obj) {\n        return instance._chain ? _$1(obj).chain() : obj;\n    }\n\n    // Add your own custom functions to the Underscore object.\n    function mixin(obj) {\n        each(functions(obj), function(name) {\n            var func = _$1[name] = obj[name];\n            _$1.prototype[name] = function() {\n                var args = [this._wrapped];\n                push.apply(args, arguments);\n                return chainResult(this, func.apply(_$1, args));\n            };\n        });\n        return _$1;\n    }\n\n    // Add all mutator `Array` functions to the wrapper.\n    each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {\n        var method = ArrayProto[name];\n        _$1.prototype[name] = function() {\n            var obj = this._wrapped;\n            if (obj != null) {\n                method.apply(obj, arguments);\n                if ((name === 'shift' || name === 'splice') && obj.length === 0) {\n                    delete obj[0];\n                }\n            }\n            return chainResult(this, obj);\n        };\n    });\n\n    // Add all accessor `Array` functions to the wrapper.\n    each(['concat', 'join', 'slice'], function(name) {\n        var method = ArrayProto[name];\n        _$1.prototype[name] = function() {\n            var obj = this._wrapped;\n            if (obj != null) obj = method.apply(obj, arguments);\n            return chainResult(this, obj);\n        };\n    });\n\n    // Named Exports\n\n    var allExports = {\n        __proto__: null,\n        VERSION: VERSION,\n        restArguments: restArguments,\n        isObject: isObject,\n        isNull: isNull,\n        isUndefined: isUndefined,\n        isBoolean: isBoolean,\n        isElement: isElement,\n        isString: isString,\n        isNumber: isNumber,\n        isDate: isDate,\n        isRegExp: isRegExp,\n        isError: isError,\n        isSymbol: isSymbol,\n        isArrayBuffer: isArrayBuffer,\n        isDataView: isDataView$1,\n        isArray: isArray,\n        isFunction: isFunction$1,\n        isArguments: isArguments$1,\n        isFinite: isFinite$1,\n        isNaN: isNaN$1,\n        isTypedArray: isTypedArray$1,\n        isEmpty: isEmpty,\n        isMatch: isMatch,\n        isEqual: isEqual,\n        isMap: isMap,\n        isWeakMap: isWeakMap,\n        isSet: isSet,\n        isWeakSet: isWeakSet,\n        keys: keys,\n        allKeys: allKeys,\n        values: values,\n        pairs: pairs,\n        invert: invert,\n        functions: functions,\n        methods: functions,\n        extend: extend,\n        extendOwn: extendOwn,\n        assign: extendOwn,\n        defaults: defaults,\n        create: create,\n        clone: clone,\n        tap: tap,\n        get: get,\n        has: has,\n        mapObject: mapObject,\n        identity: identity,\n        constant: constant,\n        noop: noop,\n        toPath: toPath$1,\n        property: property,\n        propertyOf: propertyOf,\n        matcher: matcher,\n        matches: matcher,\n        times: times,\n        random: random,\n        now: now,\n        escape: _escape,\n        unescape: _unescape,\n        templateSettings: templateSettings,\n        template: template,\n        result: result,\n        uniqueId: uniqueId,\n        chain: chain,\n        iteratee: iteratee,\n        partial: partial,\n        bind: bind,\n        bindAll: bindAll,\n        memoize: memoize,\n        delay: delay,\n        defer: defer,\n        throttle: throttle,\n        debounce: debounce,\n        wrap: wrap,\n        negate: negate,\n        compose: compose,\n        after: after,\n        before: before,\n        once: once,\n        findKey: findKey,\n        findIndex: findIndex,\n        findLastIndex: findLastIndex,\n        sortedIndex: sortedIndex,\n        indexOf: indexOf,\n        lastIndexOf: lastIndexOf,\n        find: find,\n        detect: find,\n        findWhere: findWhere,\n        each: each,\n        forEach: each,\n        map: map,\n        collect: map,\n        reduce: reduce,\n        foldl: reduce,\n        inject: reduce,\n        reduceRight: reduceRight,\n        foldr: reduceRight,\n        filter: filter,\n        select: filter,\n        reject: reject,\n        every: every,\n        all: every,\n        some: some,\n        any: some,\n        contains: contains,\n        includes: contains,\n        include: contains,\n        invoke: invoke,\n        pluck: pluck,\n        where: where,\n        max: max,\n        min: min,\n        shuffle: shuffle,\n        sample: sample,\n        sortBy: sortBy,\n        groupBy: groupBy,\n        indexBy: indexBy,\n        countBy: countBy,\n        partition: partition,\n        toArray: toArray,\n        size: size,\n        pick: pick,\n        omit: omit,\n        first: first,\n        head: first,\n        take: first,\n        initial: initial,\n        last: last,\n        rest: rest,\n        tail: rest,\n        drop: rest,\n        compact: compact,\n        flatten: flatten,\n        without: without,\n        uniq: uniq,\n        unique: uniq,\n        union: union,\n        intersection: intersection,\n        difference: difference,\n        unzip: unzip,\n        transpose: unzip,\n        zip: zip,\n        object: object,\n        range: range,\n        chunk: chunk,\n        mixin: mixin,\n        'default': _$1\n    };\n\n    // Default Export\n\n    // Add all of the Underscore functions to the wrapper object.\n    var _ = mixin(allExports);\n    // Legacy Node.js API.\n    _._ = _;\n\n    return _;\n\n})));\n//# sourceMappingURL=underscore-umd.js.map\n","moment.js":"//! moment.js\n//! version : 2.29.4\n//! authors : Tim Wood, Iskren Chernev, Moment.js contributors\n//! license : MIT\n//! momentjs.com\n/* jscs:disable */\n/* eslint-disable */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):e.moment=t()}(this,function(){\"use strict\";var H;function f(){return H.apply(null,arguments)}function a(e){return e instanceof Array||\"[object Array]\"===Object.prototype.toString.call(e)}function F(e){return null!=e&&\"[object Object]\"===Object.prototype.toString.call(e)}function c(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function L(e){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(e).length;for(var t in e)if(c(e,t))return;return 1}function o(e){return void 0===e}function u(e){return\"number\"==typeof e||\"[object Number]\"===Object.prototype.toString.call(e)}function V(e){return e instanceof Date||\"[object Date]\"===Object.prototype.toString.call(e)}function G(e,t){for(var n=[],s=e.length,i=0;i<s;++i)n.push(t(e[i],i));return n}function E(e,t){for(var n in t)c(t,n)&&(e[n]=t[n]);return c(t,\"toString\")&&(e.toString=t.toString),c(t,\"valueOf\")&&(e.valueOf=t.valueOf),e}function l(e,t,n,s){return Pt(e,t,n,s,!0).utc()}function m(e){return null==e._pf&&(e._pf={empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidEra:null,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],era:null,meridiem:null,rfc2822:!1,weekdayMismatch:!1}),e._pf}function A(e){if(null==e._isValid){var t=m(e),n=j.call(t.parsedDateParts,function(e){return null!=e}),n=!isNaN(e._d.getTime())&&t.overflow<0&&!t.empty&&!t.invalidEra&&!t.invalidMonth&&!t.invalidWeekday&&!t.weekdayMismatch&&!t.nullInput&&!t.invalidFormat&&!t.userInvalidated&&(!t.meridiem||t.meridiem&&n);if(e._strict&&(n=n&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour),null!=Object.isFrozen&&Object.isFrozen(e))return n;e._isValid=n}return e._isValid}function I(e){var t=l(NaN);return null!=e?E(m(t),e):m(t).userInvalidated=!0,t}var j=Array.prototype.some||function(e){for(var t=Object(this),n=t.length>>>0,s=0;s<n;s++)if(s in t&&e.call(this,t[s],s,t))return!0;return!1},Z=f.momentProperties=[],z=!1;function $(e,t){var n,s,i,r=Z.length;if(o(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),o(t._i)||(e._i=t._i),o(t._f)||(e._f=t._f),o(t._l)||(e._l=t._l),o(t._strict)||(e._strict=t._strict),o(t._tzm)||(e._tzm=t._tzm),o(t._isUTC)||(e._isUTC=t._isUTC),o(t._offset)||(e._offset=t._offset),o(t._pf)||(e._pf=m(t)),o(t._locale)||(e._locale=t._locale),0<r)for(n=0;n<r;n++)o(i=t[s=Z[n]])||(e[s]=i);return e}function q(e){$(this,e),this._d=new Date(null!=e._d?e._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===z&&(z=!0,f.updateOffset(this),z=!1)}function h(e){return e instanceof q||null!=e&&null!=e._isAMomentObject}function B(e){!1===f.suppressDeprecationWarnings&&\"undefined\"!=typeof console&&console.warn&&console.warn(\"Deprecation warning: \"+e)}function e(r,a){var o=!0;return E(function(){if(null!=f.deprecationHandler&&f.deprecationHandler(null,r),o){for(var e,t,n=[],s=arguments.length,i=0;i<s;i++){if(e=\"\",\"object\"==typeof arguments[i]){for(t in e+=\"\\n[\"+i+\"] \",arguments[0])c(arguments[0],t)&&(e+=t+\": \"+arguments[0][t]+\", \");e=e.slice(0,-2)}else e=arguments[i];n.push(e)}B(r+\"\\nArguments: \"+Array.prototype.slice.call(n).join(\"\")+\"\\n\"+(new Error).stack),o=!1}return a.apply(this,arguments)},a)}var J={};function Q(e,t){null!=f.deprecationHandler&&f.deprecationHandler(e,t),J[e]||(B(t),J[e]=!0)}function d(e){return\"undefined\"!=typeof Function&&e instanceof Function||\"[object Function]\"===Object.prototype.toString.call(e)}function X(e,t){var n,s=E({},e);for(n in t)c(t,n)&&(F(e[n])&&F(t[n])?(s[n]={},E(s[n],e[n]),E(s[n],t[n])):null!=t[n]?s[n]=t[n]:delete s[n]);for(n in e)c(e,n)&&!c(t,n)&&F(e[n])&&(s[n]=E({},s[n]));return s}function K(e){null!=e&&this.set(e)}f.suppressDeprecationWarnings=!1,f.deprecationHandler=null;var ee=Object.keys||function(e){var t,n=[];for(t in e)c(e,t)&&n.push(t);return n};function r(e,t,n){var s=\"\"+Math.abs(e);return(0<=e?n?\"+\":\"\":\"-\")+Math.pow(10,Math.max(0,t-s.length)).toString().substr(1)+s}var te=/(\\[[^\\[]*\\])|(\\\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,ne=/(\\[[^\\[]*\\])|(\\\\)?(LTS|LT|LL?L?L?|l{1,4})/g,se={},ie={};function s(e,t,n,s){var i=\"string\"==typeof s?function(){return this[s]()}:s;e&&(ie[e]=i),t&&(ie[t[0]]=function(){return r(i.apply(this,arguments),t[1],t[2])}),n&&(ie[n]=function(){return this.localeData().ordinal(i.apply(this,arguments),e)})}function re(e,t){return e.isValid()?(t=ae(t,e.localeData()),se[t]=se[t]||function(s){for(var e,i=s.match(te),t=0,r=i.length;t<r;t++)ie[i[t]]?i[t]=ie[i[t]]:i[t]=(e=i[t]).match(/\\[[\\s\\S]/)?e.replace(/^\\[|\\]$/g,\"\"):e.replace(/\\\\/g,\"\");return function(e){for(var t=\"\",n=0;n<r;n++)t+=d(i[n])?i[n].call(e,s):i[n];return t}}(t),se[t](e)):e.localeData().invalidDate()}function ae(e,t){var n=5;function s(e){return t.longDateFormat(e)||e}for(ne.lastIndex=0;0<=n&&ne.test(e);)e=e.replace(ne,s),ne.lastIndex=0,--n;return e}var oe={};function t(e,t){var n=e.toLowerCase();oe[n]=oe[n+\"s\"]=oe[t]=e}function _(e){return\"string\"==typeof e?oe[e]||oe[e.toLowerCase()]:void 0}function ue(e){var t,n,s={};for(n in e)c(e,n)&&(t=_(n))&&(s[t]=e[n]);return s}var le={};function n(e,t){le[e]=t}function he(e){return e%4==0&&e%100!=0||e%400==0}function y(e){return e<0?Math.ceil(e)||0:Math.floor(e)}function g(e){var e=+e,t=0;return t=0!=e&&isFinite(e)?y(e):t}function de(t,n){return function(e){return null!=e?(fe(this,t,e),f.updateOffset(this,n),this):ce(this,t)}}function ce(e,t){return e.isValid()?e._d[\"get\"+(e._isUTC?\"UTC\":\"\")+t]():NaN}function fe(e,t,n){e.isValid()&&!isNaN(n)&&(\"FullYear\"===t&&he(e.year())&&1===e.month()&&29===e.date()?(n=g(n),e._d[\"set\"+(e._isUTC?\"UTC\":\"\")+t](n,e.month(),We(n,e.month()))):e._d[\"set\"+(e._isUTC?\"UTC\":\"\")+t](n))}var i=/\\d/,w=/\\d\\d/,me=/\\d{3}/,_e=/\\d{4}/,ye=/[+-]?\\d{6}/,p=/\\d\\d?/,ge=/\\d\\d\\d\\d?/,we=/\\d\\d\\d\\d\\d\\d?/,pe=/\\d{1,3}/,ke=/\\d{1,4}/,ve=/[+-]?\\d{1,6}/,Me=/\\d+/,De=/[+-]?\\d+/,Se=/Z|[+-]\\d\\d:?\\d\\d/gi,Ye=/Z|[+-]\\d\\d(?::?\\d\\d)?/gi,k=/[0-9]{0,256}['a-z\\u00A0-\\u05FF\\u0700-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFF07\\uFF10-\\uFFEF]{1,256}|[\\u0600-\\u06FF\\/]{1,256}(\\s*?[\\u0600-\\u06FF]{1,256}){1,2}/i;function v(e,n,s){be[e]=d(n)?n:function(e,t){return e&&s?s:n}}function Oe(e,t){return c(be,e)?be[e](t._strict,t._locale):new RegExp(M(e.replace(\"\\\\\",\"\").replace(/\\\\(\\[)|\\\\(\\])|\\[([^\\]\\[]*)\\]|\\\\(.)/g,function(e,t,n,s,i){return t||n||s||i})))}function M(e){return e.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g,\"\\\\$&\")}var be={},xe={};function D(e,n){var t,s,i=n;for(\"string\"==typeof e&&(e=[e]),u(n)&&(i=function(e,t){t[n]=g(e)}),s=e.length,t=0;t<s;t++)xe[e[t]]=i}function Te(e,i){D(e,function(e,t,n,s){n._w=n._w||{},i(e,n._w,n,s)})}var S,Y=0,O=1,b=2,x=3,T=4,N=5,Ne=6,Pe=7,Re=8;function We(e,t){if(isNaN(e)||isNaN(t))return NaN;var n=(t%(n=12)+n)%n;return e+=(t-n)/12,1==n?he(e)?29:28:31-n%7%2}S=Array.prototype.indexOf||function(e){for(var t=0;t<this.length;++t)if(this[t]===e)return t;return-1},s(\"M\",[\"MM\",2],\"Mo\",function(){return this.month()+1}),s(\"MMM\",0,0,function(e){return this.localeData().monthsShort(this,e)}),s(\"MMMM\",0,0,function(e){return this.localeData().months(this,e)}),t(\"month\",\"M\"),n(\"month\",8),v(\"M\",p),v(\"MM\",p,w),v(\"MMM\",function(e,t){return t.monthsShortRegex(e)}),v(\"MMMM\",function(e,t){return t.monthsRegex(e)}),D([\"M\",\"MM\"],function(e,t){t[O]=g(e)-1}),D([\"MMM\",\"MMMM\"],function(e,t,n,s){s=n._locale.monthsParse(e,s,n._strict);null!=s?t[O]=s:m(n).invalidMonth=e});var Ce=\"January_February_March_April_May_June_July_August_September_October_November_December\".split(\"_\"),Ue=\"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec\".split(\"_\"),He=/D[oD]?(\\[[^\\[\\]]*\\]|\\s)+MMMM?/,Fe=k,Le=k;function Ve(e,t){var n;if(e.isValid()){if(\"string\"==typeof t)if(/^\\d+$/.test(t))t=g(t);else if(!u(t=e.localeData().monthsParse(t)))return;n=Math.min(e.date(),We(e.year(),t)),e._d[\"set\"+(e._isUTC?\"UTC\":\"\")+\"Month\"](t,n)}}function Ge(e){return null!=e?(Ve(this,e),f.updateOffset(this,!0),this):ce(this,\"Month\")}function Ee(){function e(e,t){return t.length-e.length}for(var t,n=[],s=[],i=[],r=0;r<12;r++)t=l([2e3,r]),n.push(this.monthsShort(t,\"\")),s.push(this.months(t,\"\")),i.push(this.months(t,\"\")),i.push(this.monthsShort(t,\"\"));for(n.sort(e),s.sort(e),i.sort(e),r=0;r<12;r++)n[r]=M(n[r]),s[r]=M(s[r]);for(r=0;r<24;r++)i[r]=M(i[r]);this._monthsRegex=new RegExp(\"^(\"+i.join(\"|\")+\")\",\"i\"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp(\"^(\"+s.join(\"|\")+\")\",\"i\"),this._monthsShortStrictRegex=new RegExp(\"^(\"+n.join(\"|\")+\")\",\"i\")}function Ae(e){return he(e)?366:365}s(\"Y\",0,0,function(){var e=this.year();return e<=9999?r(e,4):\"+\"+e}),s(0,[\"YY\",2],0,function(){return this.year()%100}),s(0,[\"YYYY\",4],0,\"year\"),s(0,[\"YYYYY\",5],0,\"year\"),s(0,[\"YYYYYY\",6,!0],0,\"year\"),t(\"year\",\"y\"),n(\"year\",1),v(\"Y\",De),v(\"YY\",p,w),v(\"YYYY\",ke,_e),v(\"YYYYY\",ve,ye),v(\"YYYYYY\",ve,ye),D([\"YYYYY\",\"YYYYYY\"],Y),D(\"YYYY\",function(e,t){t[Y]=2===e.length?f.parseTwoDigitYear(e):g(e)}),D(\"YY\",function(e,t){t[Y]=f.parseTwoDigitYear(e)}),D(\"Y\",function(e,t){t[Y]=parseInt(e,10)}),f.parseTwoDigitYear=function(e){return g(e)+(68<g(e)?1900:2e3)};var Ie=de(\"FullYear\",!0);function je(e,t,n,s,i,r,a){var o;return e<100&&0<=e?(o=new Date(e+400,t,n,s,i,r,a),isFinite(o.getFullYear())&&o.setFullYear(e)):o=new Date(e,t,n,s,i,r,a),o}function Ze(e){var t;return e<100&&0<=e?((t=Array.prototype.slice.call(arguments))[0]=e+400,t=new Date(Date.UTC.apply(null,t)),isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e)):t=new Date(Date.UTC.apply(null,arguments)),t}function ze(e,t,n){n=7+t-n;return n-(7+Ze(e,0,n).getUTCDay()-t)%7-1}function $e(e,t,n,s,i){var r,t=1+7*(t-1)+(7+n-s)%7+ze(e,s,i),n=t<=0?Ae(r=e-1)+t:t>Ae(e)?(r=e+1,t-Ae(e)):(r=e,t);return{year:r,dayOfYear:n}}function qe(e,t,n){var s,i,r=ze(e.year(),t,n),r=Math.floor((e.dayOfYear()-r-1)/7)+1;return r<1?s=r+P(i=e.year()-1,t,n):r>P(e.year(),t,n)?(s=r-P(e.year(),t,n),i=e.year()+1):(i=e.year(),s=r),{week:s,year:i}}function P(e,t,n){var s=ze(e,t,n),t=ze(e+1,t,n);return(Ae(e)-s+t)/7}s(\"w\",[\"ww\",2],\"wo\",\"week\"),s(\"W\",[\"WW\",2],\"Wo\",\"isoWeek\"),t(\"week\",\"w\"),t(\"isoWeek\",\"W\"),n(\"week\",5),n(\"isoWeek\",5),v(\"w\",p),v(\"ww\",p,w),v(\"W\",p),v(\"WW\",p,w),Te([\"w\",\"ww\",\"W\",\"WW\"],function(e,t,n,s){t[s.substr(0,1)]=g(e)});function Be(e,t){return e.slice(t,7).concat(e.slice(0,t))}s(\"d\",0,\"do\",\"day\"),s(\"dd\",0,0,function(e){return this.localeData().weekdaysMin(this,e)}),s(\"ddd\",0,0,function(e){return this.localeData().weekdaysShort(this,e)}),s(\"dddd\",0,0,function(e){return this.localeData().weekdays(this,e)}),s(\"e\",0,0,\"weekday\"),s(\"E\",0,0,\"isoWeekday\"),t(\"day\",\"d\"),t(\"weekday\",\"e\"),t(\"isoWeekday\",\"E\"),n(\"day\",11),n(\"weekday\",11),n(\"isoWeekday\",11),v(\"d\",p),v(\"e\",p),v(\"E\",p),v(\"dd\",function(e,t){return t.weekdaysMinRegex(e)}),v(\"ddd\",function(e,t){return t.weekdaysShortRegex(e)}),v(\"dddd\",function(e,t){return t.weekdaysRegex(e)}),Te([\"dd\",\"ddd\",\"dddd\"],function(e,t,n,s){s=n._locale.weekdaysParse(e,s,n._strict);null!=s?t.d=s:m(n).invalidWeekday=e}),Te([\"d\",\"e\",\"E\"],function(e,t,n,s){t[s]=g(e)});var Je=\"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday\".split(\"_\"),Qe=\"Sun_Mon_Tue_Wed_Thu_Fri_Sat\".split(\"_\"),Xe=\"Su_Mo_Tu_We_Th_Fr_Sa\".split(\"_\"),Ke=k,et=k,tt=k;function nt(){function e(e,t){return t.length-e.length}for(var t,n,s,i=[],r=[],a=[],o=[],u=0;u<7;u++)s=l([2e3,1]).day(u),t=M(this.weekdaysMin(s,\"\")),n=M(this.weekdaysShort(s,\"\")),s=M(this.weekdays(s,\"\")),i.push(t),r.push(n),a.push(s),o.push(t),o.push(n),o.push(s);i.sort(e),r.sort(e),a.sort(e),o.sort(e),this._weekdaysRegex=new RegExp(\"^(\"+o.join(\"|\")+\")\",\"i\"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp(\"^(\"+a.join(\"|\")+\")\",\"i\"),this._weekdaysShortStrictRegex=new RegExp(\"^(\"+r.join(\"|\")+\")\",\"i\"),this._weekdaysMinStrictRegex=new RegExp(\"^(\"+i.join(\"|\")+\")\",\"i\")}function st(){return this.hours()%12||12}function it(e,t){s(e,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)})}function rt(e,t){return t._meridiemParse}s(\"H\",[\"HH\",2],0,\"hour\"),s(\"h\",[\"hh\",2],0,st),s(\"k\",[\"kk\",2],0,function(){return this.hours()||24}),s(\"hmm\",0,0,function(){return\"\"+st.apply(this)+r(this.minutes(),2)}),s(\"hmmss\",0,0,function(){return\"\"+st.apply(this)+r(this.minutes(),2)+r(this.seconds(),2)}),s(\"Hmm\",0,0,function(){return\"\"+this.hours()+r(this.minutes(),2)}),s(\"Hmmss\",0,0,function(){return\"\"+this.hours()+r(this.minutes(),2)+r(this.seconds(),2)}),it(\"a\",!0),it(\"A\",!1),t(\"hour\",\"h\"),n(\"hour\",13),v(\"a\",rt),v(\"A\",rt),v(\"H\",p),v(\"h\",p),v(\"k\",p),v(\"HH\",p,w),v(\"hh\",p,w),v(\"kk\",p,w),v(\"hmm\",ge),v(\"hmmss\",we),v(\"Hmm\",ge),v(\"Hmmss\",we),D([\"H\",\"HH\"],x),D([\"k\",\"kk\"],function(e,t,n){e=g(e);t[x]=24===e?0:e}),D([\"a\",\"A\"],function(e,t,n){n._isPm=n._locale.isPM(e),n._meridiem=e}),D([\"h\",\"hh\"],function(e,t,n){t[x]=g(e),m(n).bigHour=!0}),D(\"hmm\",function(e,t,n){var s=e.length-2;t[x]=g(e.substr(0,s)),t[T]=g(e.substr(s)),m(n).bigHour=!0}),D(\"hmmss\",function(e,t,n){var s=e.length-4,i=e.length-2;t[x]=g(e.substr(0,s)),t[T]=g(e.substr(s,2)),t[N]=g(e.substr(i)),m(n).bigHour=!0}),D(\"Hmm\",function(e,t,n){var s=e.length-2;t[x]=g(e.substr(0,s)),t[T]=g(e.substr(s))}),D(\"Hmmss\",function(e,t,n){var s=e.length-4,i=e.length-2;t[x]=g(e.substr(0,s)),t[T]=g(e.substr(s,2)),t[N]=g(e.substr(i))});k=de(\"Hours\",!0);var at,ot={calendar:{sameDay:\"[Today at] LT\",nextDay:\"[Tomorrow at] LT\",nextWeek:\"dddd [at] LT\",lastDay:\"[Yesterday at] LT\",lastWeek:\"[Last] dddd [at] LT\",sameElse:\"L\"},longDateFormat:{LTS:\"h:mm:ss A\",LT:\"h:mm A\",L:\"MM/DD/YYYY\",LL:\"MMMM D, YYYY\",LLL:\"MMMM D, YYYY h:mm A\",LLLL:\"dddd, MMMM D, YYYY h:mm A\"},invalidDate:\"Invalid date\",ordinal:\"%d\",dayOfMonthOrdinalParse:/\\d{1,2}/,relativeTime:{future:\"in %s\",past:\"%s ago\",s:\"a few seconds\",ss:\"%d seconds\",m:\"a minute\",mm:\"%d minutes\",h:\"an hour\",hh:\"%d hours\",d:\"a day\",dd:\"%d days\",w:\"a week\",ww:\"%d weeks\",M:\"a month\",MM:\"%d months\",y:\"a year\",yy:\"%d years\"},months:Ce,monthsShort:Ue,week:{dow:0,doy:6},weekdays:Je,weekdaysMin:Xe,weekdaysShort:Qe,meridiemParse:/[ap]\\.?m?\\.?/i},R={},ut={};function lt(e){return e&&e.toLowerCase().replace(\"_\",\"-\")}function ht(e){for(var t,n,s,i,r=0;r<e.length;){for(t=(i=lt(e[r]).split(\"-\")).length,n=(n=lt(e[r+1]))?n.split(\"-\"):null;0<t;){if(s=dt(i.slice(0,t).join(\"-\")))return s;if(n&&n.length>=t&&function(e,t){for(var n=Math.min(e.length,t.length),s=0;s<n;s+=1)if(e[s]!==t[s])return s;return n}(i,n)>=t-1)break;t--}r++}return at}function dt(t){var e;if(void 0===R[t]&&\"undefined\"!=typeof module&&module&&module.exports&&null!=t.match(\"^[^/\\\\\\\\]*$\"))try{e=at._abbr,require(\"./locale/\"+t),ct(e)}catch(e){R[t]=null}return R[t]}function ct(e,t){return e&&((t=o(t)?mt(e):ft(e,t))?at=t:\"undefined\"!=typeof console&&console.warn&&console.warn(\"Locale \"+e+\" not found. Did you forget to load it?\")),at._abbr}function ft(e,t){if(null===t)return delete R[e],null;var n,s=ot;if(t.abbr=e,null!=R[e])Q(\"defineLocaleOverride\",\"use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info.\"),s=R[e]._config;else if(null!=t.parentLocale)if(null!=R[t.parentLocale])s=R[t.parentLocale]._config;else{if(null==(n=dt(t.parentLocale)))return ut[t.parentLocale]||(ut[t.parentLocale]=[]),ut[t.parentLocale].push({name:e,config:t}),null;s=n._config}return R[e]=new K(X(s,t)),ut[e]&&ut[e].forEach(function(e){ft(e.name,e.config)}),ct(e),R[e]}function mt(e){var t;if(!(e=e&&e._locale&&e._locale._abbr?e._locale._abbr:e))return at;if(!a(e)){if(t=dt(e))return t;e=[e]}return ht(e)}function _t(e){var t=e._a;return t&&-2===m(e).overflow&&(t=t[O]<0||11<t[O]?O:t[b]<1||t[b]>We(t[Y],t[O])?b:t[x]<0||24<t[x]||24===t[x]&&(0!==t[T]||0!==t[N]||0!==t[Ne])?x:t[T]<0||59<t[T]?T:t[N]<0||59<t[N]?N:t[Ne]<0||999<t[Ne]?Ne:-1,m(e)._overflowDayOfYear&&(t<Y||b<t)&&(t=b),m(e)._overflowWeeks&&-1===t&&(t=Pe),m(e)._overflowWeekday&&-1===t&&(t=Re),m(e).overflow=t),e}var yt=/^\\s*((?:[+-]\\d{6}|\\d{4})-(?:\\d\\d-\\d\\d|W\\d\\d-\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?::\\d\\d(?::\\d\\d(?:[.,]\\d+)?)?)?)([+-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,gt=/^\\s*((?:[+-]\\d{6}|\\d{4})(?:\\d\\d\\d\\d|W\\d\\d\\d|W\\d\\d|\\d\\d\\d|\\d\\d|))(?:(T| )(\\d\\d(?:\\d\\d(?:\\d\\d(?:[.,]\\d+)?)?)?)([+-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,wt=/Z|[+-]\\d\\d(?::?\\d\\d)?/,pt=[[\"YYYYYY-MM-DD\",/[+-]\\d{6}-\\d\\d-\\d\\d/],[\"YYYY-MM-DD\",/\\d{4}-\\d\\d-\\d\\d/],[\"GGGG-[W]WW-E\",/\\d{4}-W\\d\\d-\\d/],[\"GGGG-[W]WW\",/\\d{4}-W\\d\\d/,!1],[\"YYYY-DDD\",/\\d{4}-\\d{3}/],[\"YYYY-MM\",/\\d{4}-\\d\\d/,!1],[\"YYYYYYMMDD\",/[+-]\\d{10}/],[\"YYYYMMDD\",/\\d{8}/],[\"GGGG[W]WWE\",/\\d{4}W\\d{3}/],[\"GGGG[W]WW\",/\\d{4}W\\d{2}/,!1],[\"YYYYDDD\",/\\d{7}/],[\"YYYYMM\",/\\d{6}/,!1],[\"YYYY\",/\\d{4}/,!1]],kt=[[\"HH:mm:ss.SSSS\",/\\d\\d:\\d\\d:\\d\\d\\.\\d+/],[\"HH:mm:ss,SSSS\",/\\d\\d:\\d\\d:\\d\\d,\\d+/],[\"HH:mm:ss\",/\\d\\d:\\d\\d:\\d\\d/],[\"HH:mm\",/\\d\\d:\\d\\d/],[\"HHmmss.SSSS\",/\\d\\d\\d\\d\\d\\d\\.\\d+/],[\"HHmmss,SSSS\",/\\d\\d\\d\\d\\d\\d,\\d+/],[\"HHmmss\",/\\d\\d\\d\\d\\d\\d/],[\"HHmm\",/\\d\\d\\d\\d/],[\"HH\",/\\d\\d/]],vt=/^\\/?Date\\((-?\\d+)/i,Mt=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\\s)?(\\d{1,2})\\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s(\\d{2,4})\\s(\\d\\d):(\\d\\d)(?::(\\d\\d))?\\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\\d{4}))$/,Dt={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function St(e){var t,n,s,i,r,a,o=e._i,u=yt.exec(o)||gt.exec(o),o=pt.length,l=kt.length;if(u){for(m(e).iso=!0,t=0,n=o;t<n;t++)if(pt[t][1].exec(u[1])){i=pt[t][0],s=!1!==pt[t][2];break}if(null==i)e._isValid=!1;else{if(u[3]){for(t=0,n=l;t<n;t++)if(kt[t][1].exec(u[3])){r=(u[2]||\" \")+kt[t][0];break}if(null==r)return void(e._isValid=!1)}if(s||null==r){if(u[4]){if(!wt.exec(u[4]))return void(e._isValid=!1);a=\"Z\"}e._f=i+(r||\"\")+(a||\"\"),Tt(e)}else e._isValid=!1}}else e._isValid=!1}function Yt(e,t,n,s,i,r){e=[function(e){e=parseInt(e,10);{if(e<=49)return 2e3+e;if(e<=999)return 1900+e}return e}(e),Ue.indexOf(t),parseInt(n,10),parseInt(s,10),parseInt(i,10)];return r&&e.push(parseInt(r,10)),e}function Ot(e){var t,n,s,i,r=Mt.exec(e._i.replace(/\\([^()]*\\)|[\\n\\t]/g,\" \").replace(/(\\s\\s+)/g,\" \").replace(/^\\s\\s*/,\"\").replace(/\\s\\s*$/,\"\"));r?(t=Yt(r[4],r[3],r[2],r[5],r[6],r[7]),n=r[1],s=t,i=e,n&&Qe.indexOf(n)!==new Date(s[0],s[1],s[2]).getDay()?(m(i).weekdayMismatch=!0,i._isValid=!1):(e._a=t,e._tzm=(n=r[8],s=r[9],i=r[10],n?Dt[n]:s?0:60*(((n=parseInt(i,10))-(s=n%100))/100)+s),e._d=Ze.apply(null,e._a),e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),m(e).rfc2822=!0)):e._isValid=!1}function bt(e,t,n){return null!=e?e:null!=t?t:n}function xt(e){var t,n,s,i,r,a,o,u,l,h,d,c=[];if(!e._d){for(s=e,i=new Date(f.now()),n=s._useUTC?[i.getUTCFullYear(),i.getUTCMonth(),i.getUTCDate()]:[i.getFullYear(),i.getMonth(),i.getDate()],e._w&&null==e._a[b]&&null==e._a[O]&&(null!=(i=(s=e)._w).GG||null!=i.W||null!=i.E?(u=1,l=4,r=bt(i.GG,s._a[Y],qe(W(),1,4).year),a=bt(i.W,1),((o=bt(i.E,1))<1||7<o)&&(h=!0)):(u=s._locale._week.dow,l=s._locale._week.doy,d=qe(W(),u,l),r=bt(i.gg,s._a[Y],d.year),a=bt(i.w,d.week),null!=i.d?((o=i.d)<0||6<o)&&(h=!0):null!=i.e?(o=i.e+u,(i.e<0||6<i.e)&&(h=!0)):o=u),a<1||a>P(r,u,l)?m(s)._overflowWeeks=!0:null!=h?m(s)._overflowWeekday=!0:(d=$e(r,a,o,u,l),s._a[Y]=d.year,s._dayOfYear=d.dayOfYear)),null!=e._dayOfYear&&(i=bt(e._a[Y],n[Y]),(e._dayOfYear>Ae(i)||0===e._dayOfYear)&&(m(e)._overflowDayOfYear=!0),h=Ze(i,0,e._dayOfYear),e._a[O]=h.getUTCMonth(),e._a[b]=h.getUTCDate()),t=0;t<3&&null==e._a[t];++t)e._a[t]=c[t]=n[t];for(;t<7;t++)e._a[t]=c[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[x]&&0===e._a[T]&&0===e._a[N]&&0===e._a[Ne]&&(e._nextDay=!0,e._a[x]=0),e._d=(e._useUTC?Ze:je).apply(null,c),r=e._useUTC?e._d.getUTCDay():e._d.getDay(),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[x]=24),e._w&&void 0!==e._w.d&&e._w.d!==r&&(m(e).weekdayMismatch=!0)}}function Tt(e){if(e._f===f.ISO_8601)St(e);else if(e._f===f.RFC_2822)Ot(e);else{e._a=[],m(e).empty=!0;for(var t,n,s,i,r,a=\"\"+e._i,o=a.length,u=0,l=ae(e._f,e._locale).match(te)||[],h=l.length,d=0;d<h;d++)n=l[d],(t=(a.match(Oe(n,e))||[])[0])&&(0<(s=a.substr(0,a.indexOf(t))).length&&m(e).unusedInput.push(s),a=a.slice(a.indexOf(t)+t.length),u+=t.length),ie[n]?(t?m(e).empty=!1:m(e).unusedTokens.push(n),s=n,r=e,null!=(i=t)&&c(xe,s)&&xe[s](i,r._a,r,s)):e._strict&&!t&&m(e).unusedTokens.push(n);m(e).charsLeftOver=o-u,0<a.length&&m(e).unusedInput.push(a),e._a[x]<=12&&!0===m(e).bigHour&&0<e._a[x]&&(m(e).bigHour=void 0),m(e).parsedDateParts=e._a.slice(0),m(e).meridiem=e._meridiem,e._a[x]=function(e,t,n){if(null==n)return t;return null!=e.meridiemHour?e.meridiemHour(t,n):null!=e.isPM?((e=e.isPM(n))&&t<12&&(t+=12),t=e||12!==t?t:0):t}(e._locale,e._a[x],e._meridiem),null!==(o=m(e).era)&&(e._a[Y]=e._locale.erasConvertYear(o,e._a[Y])),xt(e),_t(e)}}function Nt(e){var t,n,s,i=e._i,r=e._f;if(e._locale=e._locale||mt(e._l),null===i||void 0===r&&\"\"===i)return I({nullInput:!0});if(\"string\"==typeof i&&(e._i=i=e._locale.preparse(i)),h(i))return new q(_t(i));if(V(i))e._d=i;else if(a(r))!function(e){var t,n,s,i,r,a,o=!1,u=e._f.length;if(0===u)return m(e).invalidFormat=!0,e._d=new Date(NaN);for(i=0;i<u;i++)r=0,a=!1,t=$({},e),null!=e._useUTC&&(t._useUTC=e._useUTC),t._f=e._f[i],Tt(t),A(t)&&(a=!0),r=(r+=m(t).charsLeftOver)+10*m(t).unusedTokens.length,m(t).score=r,o?r<s&&(s=r,n=t):(null==s||r<s||a)&&(s=r,n=t,a&&(o=!0));E(e,n||t)}(e);else if(r)Tt(e);else if(o(r=(i=e)._i))i._d=new Date(f.now());else V(r)?i._d=new Date(r.valueOf()):\"string\"==typeof r?(n=i,null!==(t=vt.exec(n._i))?n._d=new Date(+t[1]):(St(n),!1===n._isValid&&(delete n._isValid,Ot(n),!1===n._isValid&&(delete n._isValid,n._strict?n._isValid=!1:f.createFromInputFallback(n))))):a(r)?(i._a=G(r.slice(0),function(e){return parseInt(e,10)}),xt(i)):F(r)?(t=i)._d||(s=void 0===(n=ue(t._i)).day?n.date:n.day,t._a=G([n.year,n.month,s,n.hour,n.minute,n.second,n.millisecond],function(e){return e&&parseInt(e,10)}),xt(t)):u(r)?i._d=new Date(r):f.createFromInputFallback(i);return A(e)||(e._d=null),e}function Pt(e,t,n,s,i){var r={};return!0!==t&&!1!==t||(s=t,t=void 0),!0!==n&&!1!==n||(s=n,n=void 0),(F(e)&&L(e)||a(e)&&0===e.length)&&(e=void 0),r._isAMomentObject=!0,r._useUTC=r._isUTC=i,r._l=n,r._i=e,r._f=t,r._strict=s,(i=new q(_t(Nt(i=r))))._nextDay&&(i.add(1,\"d\"),i._nextDay=void 0),i}function W(e,t,n,s){return Pt(e,t,n,s,!1)}f.createFromInputFallback=e(\"value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.\",function(e){e._d=new Date(e._i+(e._useUTC?\" UTC\":\"\"))}),f.ISO_8601=function(){},f.RFC_2822=function(){};ge=e(\"moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var e=W.apply(null,arguments);return this.isValid()&&e.isValid()?e<this?this:e:I()}),we=e(\"moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var e=W.apply(null,arguments);return this.isValid()&&e.isValid()?this<e?this:e:I()});function Rt(e,t){var n,s;if(!(t=1===t.length&&a(t[0])?t[0]:t).length)return W();for(n=t[0],s=1;s<t.length;++s)t[s].isValid()&&!t[s][e](n)||(n=t[s]);return n}var Wt=[\"year\",\"quarter\",\"month\",\"week\",\"day\",\"hour\",\"minute\",\"second\",\"millisecond\"];function Ct(e){var e=ue(e),t=e.year||0,n=e.quarter||0,s=e.month||0,i=e.week||e.isoWeek||0,r=e.day||0,a=e.hour||0,o=e.minute||0,u=e.second||0,l=e.millisecond||0;this._isValid=function(e){var t,n,s=!1,i=Wt.length;for(t in e)if(c(e,t)&&(-1===S.call(Wt,t)||null!=e[t]&&isNaN(e[t])))return!1;for(n=0;n<i;++n)if(e[Wt[n]]){if(s)return!1;parseFloat(e[Wt[n]])!==g(e[Wt[n]])&&(s=!0)}return!0}(e),this._milliseconds=+l+1e3*u+6e4*o+1e3*a*60*60,this._days=+r+7*i,this._months=+s+3*n+12*t,this._data={},this._locale=mt(),this._bubble()}function Ut(e){return e instanceof Ct}function Ht(e){return e<0?-1*Math.round(-1*e):Math.round(e)}function Ft(e,n){s(e,0,0,function(){var e=this.utcOffset(),t=\"+\";return e<0&&(e=-e,t=\"-\"),t+r(~~(e/60),2)+n+r(~~e%60,2)})}Ft(\"Z\",\":\"),Ft(\"ZZ\",\"\"),v(\"Z\",Ye),v(\"ZZ\",Ye),D([\"Z\",\"ZZ\"],function(e,t,n){n._useUTC=!0,n._tzm=Vt(Ye,e)});var Lt=/([\\+\\-]|\\d\\d)/gi;function Vt(e,t){var t=(t||\"\").match(e);return null===t?null:0===(t=60*(e=((t[t.length-1]||[])+\"\").match(Lt)||[\"-\",0,0])[1]+g(e[2]))?0:\"+\"===e[0]?t:-t}function Gt(e,t){var n;return t._isUTC?(t=t.clone(),n=(h(e)||V(e)?e:W(e)).valueOf()-t.valueOf(),t._d.setTime(t._d.valueOf()+n),f.updateOffset(t,!1),t):W(e).local()}function Et(e){return-Math.round(e._d.getTimezoneOffset())}function At(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}f.updateOffset=function(){};var It=/^(-|\\+)?(?:(\\d*)[. ])?(\\d+):(\\d+)(?::(\\d+)(\\.\\d*)?)?$/,jt=/^(-|\\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function C(e,t){var n,s=e,i=null;return Ut(e)?s={ms:e._milliseconds,d:e._days,M:e._months}:u(e)||!isNaN(+e)?(s={},t?s[t]=+e:s.milliseconds=+e):(i=It.exec(e))?(n=\"-\"===i[1]?-1:1,s={y:0,d:g(i[b])*n,h:g(i[x])*n,m:g(i[T])*n,s:g(i[N])*n,ms:g(Ht(1e3*i[Ne]))*n}):(i=jt.exec(e))?(n=\"-\"===i[1]?-1:1,s={y:Zt(i[2],n),M:Zt(i[3],n),w:Zt(i[4],n),d:Zt(i[5],n),h:Zt(i[6],n),m:Zt(i[7],n),s:Zt(i[8],n)}):null==s?s={}:\"object\"==typeof s&&(\"from\"in s||\"to\"in s)&&(t=function(e,t){var n;if(!e.isValid()||!t.isValid())return{milliseconds:0,months:0};t=Gt(t,e),e.isBefore(t)?n=zt(e,t):((n=zt(t,e)).milliseconds=-n.milliseconds,n.months=-n.months);return n}(W(s.from),W(s.to)),(s={}).ms=t.milliseconds,s.M=t.months),i=new Ct(s),Ut(e)&&c(e,\"_locale\")&&(i._locale=e._locale),Ut(e)&&c(e,\"_isValid\")&&(i._isValid=e._isValid),i}function Zt(e,t){e=e&&parseFloat(e.replace(\",\",\".\"));return(isNaN(e)?0:e)*t}function zt(e,t){var n={};return n.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(n.months,\"M\").isAfter(t)&&--n.months,n.milliseconds=+t-+e.clone().add(n.months,\"M\"),n}function $t(s,i){return function(e,t){var n;return null===t||isNaN(+t)||(Q(i,\"moment().\"+i+\"(period, number) is deprecated. Please use moment().\"+i+\"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.\"),n=e,e=t,t=n),qt(this,C(e,t),s),this}}function qt(e,t,n,s){var i=t._milliseconds,r=Ht(t._days),t=Ht(t._months);e.isValid()&&(s=null==s||s,t&&Ve(e,ce(e,\"Month\")+t*n),r&&fe(e,\"Date\",ce(e,\"Date\")+r*n),i&&e._d.setTime(e._d.valueOf()+i*n),s&&f.updateOffset(e,r||t))}C.fn=Ct.prototype,C.invalid=function(){return C(NaN)};Ce=$t(1,\"add\"),Je=$t(-1,\"subtract\");function Bt(e){return\"string\"==typeof e||e instanceof String}function Jt(e){return h(e)||V(e)||Bt(e)||u(e)||function(t){var e=a(t),n=!1;e&&(n=0===t.filter(function(e){return!u(e)&&Bt(t)}).length);return e&&n}(e)||function(e){var t,n,s=F(e)&&!L(e),i=!1,r=[\"years\",\"year\",\"y\",\"months\",\"month\",\"M\",\"days\",\"day\",\"d\",\"dates\",\"date\",\"D\",\"hours\",\"hour\",\"h\",\"minutes\",\"minute\",\"m\",\"seconds\",\"second\",\"s\",\"milliseconds\",\"millisecond\",\"ms\"],a=r.length;for(t=0;t<a;t+=1)n=r[t],i=i||c(e,n);return s&&i}(e)||null==e}function Qt(e,t){if(e.date()<t.date())return-Qt(t,e);var n=12*(t.year()-e.year())+(t.month()-e.month()),s=e.clone().add(n,\"months\"),t=t-s<0?(t-s)/(s-e.clone().add(n-1,\"months\")):(t-s)/(e.clone().add(1+n,\"months\")-s);return-(n+t)||0}function Xt(e){return void 0===e?this._locale._abbr:(null!=(e=mt(e))&&(this._locale=e),this)}f.defaultFormat=\"YYYY-MM-DDTHH:mm:ssZ\",f.defaultFormatUtc=\"YYYY-MM-DDTHH:mm:ss[Z]\";Xe=e(\"moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.\",function(e){return void 0===e?this.localeData():this.locale(e)});function Kt(){return this._locale}var en=126227808e5;function tn(e,t){return(e%t+t)%t}function nn(e,t,n){return e<100&&0<=e?new Date(e+400,t,n)-en:new Date(e,t,n).valueOf()}function sn(e,t,n){return e<100&&0<=e?Date.UTC(e+400,t,n)-en:Date.UTC(e,t,n)}function rn(e,t){return t.erasAbbrRegex(e)}function an(){for(var e=[],t=[],n=[],s=[],i=this.eras(),r=0,a=i.length;r<a;++r)t.push(M(i[r].name)),e.push(M(i[r].abbr)),n.push(M(i[r].narrow)),s.push(M(i[r].name)),s.push(M(i[r].abbr)),s.push(M(i[r].narrow));this._erasRegex=new RegExp(\"^(\"+s.join(\"|\")+\")\",\"i\"),this._erasNameRegex=new RegExp(\"^(\"+t.join(\"|\")+\")\",\"i\"),this._erasAbbrRegex=new RegExp(\"^(\"+e.join(\"|\")+\")\",\"i\"),this._erasNarrowRegex=new RegExp(\"^(\"+n.join(\"|\")+\")\",\"i\")}function on(e,t){s(0,[e,e.length],0,t)}function un(e,t,n,s,i){var r;return null==e?qe(this,s,i).year:(r=P(e,s,i),function(e,t,n,s,i){e=$e(e,t,n,s,i),t=Ze(e.year,0,e.dayOfYear);return this.year(t.getUTCFullYear()),this.month(t.getUTCMonth()),this.date(t.getUTCDate()),this}.call(this,e,t=r<t?r:t,n,s,i))}s(\"N\",0,0,\"eraAbbr\"),s(\"NN\",0,0,\"eraAbbr\"),s(\"NNN\",0,0,\"eraAbbr\"),s(\"NNNN\",0,0,\"eraName\"),s(\"NNNNN\",0,0,\"eraNarrow\"),s(\"y\",[\"y\",1],\"yo\",\"eraYear\"),s(\"y\",[\"yy\",2],0,\"eraYear\"),s(\"y\",[\"yyy\",3],0,\"eraYear\"),s(\"y\",[\"yyyy\",4],0,\"eraYear\"),v(\"N\",rn),v(\"NN\",rn),v(\"NNN\",rn),v(\"NNNN\",function(e,t){return t.erasNameRegex(e)}),v(\"NNNNN\",function(e,t){return t.erasNarrowRegex(e)}),D([\"N\",\"NN\",\"NNN\",\"NNNN\",\"NNNNN\"],function(e,t,n,s){s=n._locale.erasParse(e,s,n._strict);s?m(n).era=s:m(n).invalidEra=e}),v(\"y\",Me),v(\"yy\",Me),v(\"yyy\",Me),v(\"yyyy\",Me),v(\"yo\",function(e,t){return t._eraYearOrdinalRegex||Me}),D([\"y\",\"yy\",\"yyy\",\"yyyy\"],Y),D([\"yo\"],function(e,t,n,s){var i;n._locale._eraYearOrdinalRegex&&(i=e.match(n._locale._eraYearOrdinalRegex)),n._locale.eraYearOrdinalParse?t[Y]=n._locale.eraYearOrdinalParse(e,i):t[Y]=parseInt(e,10)}),s(0,[\"gg\",2],0,function(){return this.weekYear()%100}),s(0,[\"GG\",2],0,function(){return this.isoWeekYear()%100}),on(\"gggg\",\"weekYear\"),on(\"ggggg\",\"weekYear\"),on(\"GGGG\",\"isoWeekYear\"),on(\"GGGGG\",\"isoWeekYear\"),t(\"weekYear\",\"gg\"),t(\"isoWeekYear\",\"GG\"),n(\"weekYear\",1),n(\"isoWeekYear\",1),v(\"G\",De),v(\"g\",De),v(\"GG\",p,w),v(\"gg\",p,w),v(\"GGGG\",ke,_e),v(\"gggg\",ke,_e),v(\"GGGGG\",ve,ye),v(\"ggggg\",ve,ye),Te([\"gggg\",\"ggggg\",\"GGGG\",\"GGGGG\"],function(e,t,n,s){t[s.substr(0,2)]=g(e)}),Te([\"gg\",\"GG\"],function(e,t,n,s){t[s]=f.parseTwoDigitYear(e)}),s(\"Q\",0,\"Qo\",\"quarter\"),t(\"quarter\",\"Q\"),n(\"quarter\",7),v(\"Q\",i),D(\"Q\",function(e,t){t[O]=3*(g(e)-1)}),s(\"D\",[\"DD\",2],\"Do\",\"date\"),t(\"date\",\"D\"),n(\"date\",9),v(\"D\",p),v(\"DD\",p,w),v(\"Do\",function(e,t){return e?t._dayOfMonthOrdinalParse||t._ordinalParse:t._dayOfMonthOrdinalParseLenient}),D([\"D\",\"DD\"],b),D(\"Do\",function(e,t){t[b]=g(e.match(p)[0])});ke=de(\"Date\",!0);s(\"DDD\",[\"DDDD\",3],\"DDDo\",\"dayOfYear\"),t(\"dayOfYear\",\"DDD\"),n(\"dayOfYear\",4),v(\"DDD\",pe),v(\"DDDD\",me),D([\"DDD\",\"DDDD\"],function(e,t,n){n._dayOfYear=g(e)}),s(\"m\",[\"mm\",2],0,\"minute\"),t(\"minute\",\"m\"),n(\"minute\",14),v(\"m\",p),v(\"mm\",p,w),D([\"m\",\"mm\"],T);var ln,_e=de(\"Minutes\",!1),ve=(s(\"s\",[\"ss\",2],0,\"second\"),t(\"second\",\"s\"),n(\"second\",15),v(\"s\",p),v(\"ss\",p,w),D([\"s\",\"ss\"],N),de(\"Seconds\",!1));for(s(\"S\",0,0,function(){return~~(this.millisecond()/100)}),s(0,[\"SS\",2],0,function(){return~~(this.millisecond()/10)}),s(0,[\"SSS\",3],0,\"millisecond\"),s(0,[\"SSSS\",4],0,function(){return 10*this.millisecond()}),s(0,[\"SSSSS\",5],0,function(){return 100*this.millisecond()}),s(0,[\"SSSSSS\",6],0,function(){return 1e3*this.millisecond()}),s(0,[\"SSSSSSS\",7],0,function(){return 1e4*this.millisecond()}),s(0,[\"SSSSSSSS\",8],0,function(){return 1e5*this.millisecond()}),s(0,[\"SSSSSSSSS\",9],0,function(){return 1e6*this.millisecond()}),t(\"millisecond\",\"ms\"),n(\"millisecond\",16),v(\"S\",pe,i),v(\"SS\",pe,w),v(\"SSS\",pe,me),ln=\"SSSS\";ln.length<=9;ln+=\"S\")v(ln,Me);function hn(e,t){t[Ne]=g(1e3*(\"0.\"+e))}for(ln=\"S\";ln.length<=9;ln+=\"S\")D(ln,hn);ye=de(\"Milliseconds\",!1),s(\"z\",0,0,\"zoneAbbr\"),s(\"zz\",0,0,\"zoneName\");i=q.prototype;function dn(e){return e}i.add=Ce,i.calendar=function(e,t){1===arguments.length&&(arguments[0]?Jt(arguments[0])?(e=arguments[0],t=void 0):function(e){for(var t=F(e)&&!L(e),n=!1,s=[\"sameDay\",\"nextDay\",\"lastDay\",\"nextWeek\",\"lastWeek\",\"sameElse\"],i=0;i<s.length;i+=1)n=n||c(e,s[i]);return t&&n}(arguments[0])&&(t=arguments[0],e=void 0):t=e=void 0);var e=e||W(),n=Gt(e,this).startOf(\"day\"),n=f.calendarFormat(this,n)||\"sameElse\",t=t&&(d(t[n])?t[n].call(this,e):t[n]);return this.format(t||this.localeData().calendar(n,this,W(e)))},i.clone=function(){return new q(this)},i.diff=function(e,t,n){var s,i,r;if(!this.isValid())return NaN;if(!(s=Gt(e,this)).isValid())return NaN;switch(i=6e4*(s.utcOffset()-this.utcOffset()),t=_(t)){case\"year\":r=Qt(this,s)/12;break;case\"month\":r=Qt(this,s);break;case\"quarter\":r=Qt(this,s)/3;break;case\"second\":r=(this-s)/1e3;break;case\"minute\":r=(this-s)/6e4;break;case\"hour\":r=(this-s)/36e5;break;case\"day\":r=(this-s-i)/864e5;break;case\"week\":r=(this-s-i)/6048e5;break;default:r=this-s}return n?r:y(r)},i.endOf=function(e){var t,n;if(void 0===(e=_(e))||\"millisecond\"===e||!this.isValid())return this;switch(n=this._isUTC?sn:nn,e){case\"year\":t=n(this.year()+1,0,1)-1;break;case\"quarter\":t=n(this.year(),this.month()-this.month()%3+3,1)-1;break;case\"month\":t=n(this.year(),this.month()+1,1)-1;break;case\"week\":t=n(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case\"isoWeek\":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case\"day\":case\"date\":t=n(this.year(),this.month(),this.date()+1)-1;break;case\"hour\":t=this._d.valueOf(),t+=36e5-tn(t+(this._isUTC?0:6e4*this.utcOffset()),36e5)-1;break;case\"minute\":t=this._d.valueOf(),t+=6e4-tn(t,6e4)-1;break;case\"second\":t=this._d.valueOf(),t+=1e3-tn(t,1e3)-1;break}return this._d.setTime(t),f.updateOffset(this,!0),this},i.format=function(e){return e=e||(this.isUtc()?f.defaultFormatUtc:f.defaultFormat),e=re(this,e),this.localeData().postformat(e)},i.from=function(e,t){return this.isValid()&&(h(e)&&e.isValid()||W(e).isValid())?C({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},i.fromNow=function(e){return this.from(W(),e)},i.to=function(e,t){return this.isValid()&&(h(e)&&e.isValid()||W(e).isValid())?C({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},i.toNow=function(e){return this.to(W(),e)},i.get=function(e){return d(this[e=_(e)])?this[e]():this},i.invalidAt=function(){return m(this).overflow},i.isAfter=function(e,t){return e=h(e)?e:W(e),!(!this.isValid()||!e.isValid())&&(\"millisecond\"===(t=_(t)||\"millisecond\")?this.valueOf()>e.valueOf():e.valueOf()<this.clone().startOf(t).valueOf())},i.isBefore=function(e,t){return e=h(e)?e:W(e),!(!this.isValid()||!e.isValid())&&(\"millisecond\"===(t=_(t)||\"millisecond\")?this.valueOf()<e.valueOf():this.clone().endOf(t).valueOf()<e.valueOf())},i.isBetween=function(e,t,n,s){return e=h(e)?e:W(e),t=h(t)?t:W(t),!!(this.isValid()&&e.isValid()&&t.isValid())&&((\"(\"===(s=s||\"()\")[0]?this.isAfter(e,n):!this.isBefore(e,n))&&(\")\"===s[1]?this.isBefore(t,n):!this.isAfter(t,n)))},i.isSame=function(e,t){var e=h(e)?e:W(e);return!(!this.isValid()||!e.isValid())&&(\"millisecond\"===(t=_(t)||\"millisecond\")?this.valueOf()===e.valueOf():(e=e.valueOf(),this.clone().startOf(t).valueOf()<=e&&e<=this.clone().endOf(t).valueOf()))},i.isSameOrAfter=function(e,t){return this.isSame(e,t)||this.isAfter(e,t)},i.isSameOrBefore=function(e,t){return this.isSame(e,t)||this.isBefore(e,t)},i.isValid=function(){return A(this)},i.lang=Xe,i.locale=Xt,i.localeData=Kt,i.max=we,i.min=ge,i.parsingFlags=function(){return E({},m(this))},i.set=function(e,t){if(\"object\"==typeof e)for(var n=function(e){var t,n=[];for(t in e)c(e,t)&&n.push({unit:t,priority:le[t]});return n.sort(function(e,t){return e.priority-t.priority}),n}(e=ue(e)),s=n.length,i=0;i<s;i++)this[n[i].unit](e[n[i].unit]);else if(d(this[e=_(e)]))return this[e](t);return this},i.startOf=function(e){var t,n;if(void 0===(e=_(e))||\"millisecond\"===e||!this.isValid())return this;switch(n=this._isUTC?sn:nn,e){case\"year\":t=n(this.year(),0,1);break;case\"quarter\":t=n(this.year(),this.month()-this.month()%3,1);break;case\"month\":t=n(this.year(),this.month(),1);break;case\"week\":t=n(this.year(),this.month(),this.date()-this.weekday());break;case\"isoWeek\":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case\"day\":case\"date\":t=n(this.year(),this.month(),this.date());break;case\"hour\":t=this._d.valueOf(),t-=tn(t+(this._isUTC?0:6e4*this.utcOffset()),36e5);break;case\"minute\":t=this._d.valueOf(),t-=tn(t,6e4);break;case\"second\":t=this._d.valueOf(),t-=tn(t,1e3);break}return this._d.setTime(t),f.updateOffset(this,!0),this},i.subtract=Je,i.toArray=function(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]},i.toObject=function(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}},i.toDate=function(){return new Date(this.valueOf())},i.toISOString=function(e){if(!this.isValid())return null;var t=(e=!0!==e)?this.clone().utc():this;return t.year()<0||9999<t.year()?re(t,e?\"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]\":\"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ\"):d(Date.prototype.toISOString)?e?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace(\"Z\",re(t,\"Z\")):re(t,e?\"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]\":\"YYYY-MM-DD[T]HH:mm:ss.SSSZ\")},i.inspect=function(){if(!this.isValid())return\"moment.invalid(/* \"+this._i+\" */)\";var e,t=\"moment\",n=\"\";return this.isLocal()||(t=0===this.utcOffset()?\"moment.utc\":\"moment.parseZone\",n=\"Z\"),t=\"[\"+t+'(\"]',e=0<=this.year()&&this.year()<=9999?\"YYYY\":\"YYYYYY\",this.format(t+e+\"-MM-DD[T]HH:mm:ss.SSS\"+(n+'[\")]'))},\"undefined\"!=typeof Symbol&&null!=Symbol.for&&(i[Symbol.for(\"nodejs.util.inspect.custom\")]=function(){return\"Moment<\"+this.format()+\">\"}),i.toJSON=function(){return this.isValid()?this.toISOString():null},i.toString=function(){return this.clone().locale(\"en\").format(\"ddd MMM DD YYYY HH:mm:ss [GMT]ZZ\")},i.unix=function(){return Math.floor(this.valueOf()/1e3)},i.valueOf=function(){return this._d.valueOf()-6e4*(this._offset||0)},i.creationData=function(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}},i.eraName=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf(\"day\").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].name;if(t[n].until<=e&&e<=t[n].since)return t[n].name}return\"\"},i.eraNarrow=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf(\"day\").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].narrow;if(t[n].until<=e&&e<=t[n].since)return t[n].narrow}return\"\"},i.eraAbbr=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf(\"day\").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].abbr;if(t[n].until<=e&&e<=t[n].since)return t[n].abbr}return\"\"},i.eraYear=function(){for(var e,t,n=this.localeData().eras(),s=0,i=n.length;s<i;++s)if(e=n[s].since<=n[s].until?1:-1,t=this.clone().startOf(\"day\").valueOf(),n[s].since<=t&&t<=n[s].until||n[s].until<=t&&t<=n[s].since)return(this.year()-f(n[s].since).year())*e+n[s].offset;return this.year()},i.year=Ie,i.isLeapYear=function(){return he(this.year())},i.weekYear=function(e){return un.call(this,e,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)},i.isoWeekYear=function(e){return un.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)},i.quarter=i.quarters=function(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)},i.month=Ge,i.daysInMonth=function(){return We(this.year(),this.month())},i.week=i.weeks=function(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),\"d\")},i.isoWeek=i.isoWeeks=function(e){var t=qe(this,1,4).week;return null==e?t:this.add(7*(e-t),\"d\")},i.weeksInYear=function(){var e=this.localeData()._week;return P(this.year(),e.dow,e.doy)},i.weeksInWeekYear=function(){var e=this.localeData()._week;return P(this.weekYear(),e.dow,e.doy)},i.isoWeeksInYear=function(){return P(this.year(),1,4)},i.isoWeeksInISOWeekYear=function(){return P(this.isoWeekYear(),1,4)},i.date=ke,i.day=i.days=function(e){if(!this.isValid())return null!=e?this:NaN;var t,n,s=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=e?(t=e,n=this.localeData(),e=\"string\"!=typeof t?t:isNaN(t)?\"number\"==typeof(t=n.weekdaysParse(t))?t:null:parseInt(t,10),this.add(e-s,\"d\")):s},i.weekday=function(e){if(!this.isValid())return null!=e?this:NaN;var t=(this.day()+7-this.localeData()._week.dow)%7;return null==e?t:this.add(e-t,\"d\")},i.isoWeekday=function(e){return this.isValid()?null!=e?(t=e,n=this.localeData(),n=\"string\"==typeof t?n.weekdaysParse(t)%7||7:isNaN(t)?null:t,this.day(this.day()%7?n:n-7)):this.day()||7:null!=e?this:NaN;var t,n},i.dayOfYear=function(e){var t=Math.round((this.clone().startOf(\"day\")-this.clone().startOf(\"year\"))/864e5)+1;return null==e?t:this.add(e-t,\"d\")},i.hour=i.hours=k,i.minute=i.minutes=_e,i.second=i.seconds=ve,i.millisecond=i.milliseconds=ye,i.utcOffset=function(e,t,n){var s,i=this._offset||0;if(!this.isValid())return null!=e?this:NaN;if(null==e)return this._isUTC?i:Et(this);if(\"string\"==typeof e){if(null===(e=Vt(Ye,e)))return this}else Math.abs(e)<16&&!n&&(e*=60);return!this._isUTC&&t&&(s=Et(this)),this._offset=e,this._isUTC=!0,null!=s&&this.add(s,\"m\"),i!==e&&(!t||this._changeInProgress?qt(this,C(e-i,\"m\"),1,!1):this._changeInProgress||(this._changeInProgress=!0,f.updateOffset(this,!0),this._changeInProgress=null)),this},i.utc=function(e){return this.utcOffset(0,e)},i.local=function(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e&&this.subtract(Et(this),\"m\")),this},i.parseZone=function(){var e;return null!=this._tzm?this.utcOffset(this._tzm,!1,!0):\"string\"==typeof this._i&&(null!=(e=Vt(Se,this._i))?this.utcOffset(e):this.utcOffset(0,!0)),this},i.hasAlignedHourOffset=function(e){return!!this.isValid()&&(e=e?W(e).utcOffset():0,(this.utcOffset()-e)%60==0)},i.isDST=function(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()},i.isLocal=function(){return!!this.isValid()&&!this._isUTC},i.isUtcOffset=function(){return!!this.isValid()&&this._isUTC},i.isUtc=At,i.isUTC=At,i.zoneAbbr=function(){return this._isUTC?\"UTC\":\"\"},i.zoneName=function(){return this._isUTC?\"Coordinated Universal Time\":\"\"},i.dates=e(\"dates accessor is deprecated. Use date instead.\",ke),i.months=e(\"months accessor is deprecated. Use month instead\",Ge),i.years=e(\"years accessor is deprecated. Use year instead\",Ie),i.zone=e(\"moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/\",function(e,t){return null!=e?(this.utcOffset(e=\"string\"!=typeof e?-e:e,t),this):-this.utcOffset()}),i.isDSTShifted=e(\"isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information\",function(){if(!o(this._isDSTShifted))return this._isDSTShifted;var e,t={};return $(t,this),(t=Nt(t))._a?(e=(t._isUTC?l:W)(t._a),this._isDSTShifted=this.isValid()&&0<function(e,t,n){for(var s=Math.min(e.length,t.length),i=Math.abs(e.length-t.length),r=0,a=0;a<s;a++)(n&&e[a]!==t[a]||!n&&g(e[a])!==g(t[a]))&&r++;return r+i}(t._a,e.toArray())):this._isDSTShifted=!1,this._isDSTShifted});w=K.prototype;function cn(e,t,n,s){var i=mt(),s=l().set(s,t);return i[n](s,e)}function fn(e,t,n){if(u(e)&&(t=e,e=void 0),e=e||\"\",null!=t)return cn(e,t,n,\"month\");for(var s=[],i=0;i<12;i++)s[i]=cn(e,i,n,\"month\");return s}function mn(e,t,n,s){t=(\"boolean\"==typeof e?u(t)&&(n=t,t=void 0):(t=e,e=!1,u(n=t)&&(n=t,t=void 0)),t||\"\");var i,r=mt(),a=e?r._week.dow:0,o=[];if(null!=n)return cn(t,(n+a)%7,s,\"day\");for(i=0;i<7;i++)o[i]=cn(t,(i+a)%7,s,\"day\");return o}w.calendar=function(e,t,n){return d(e=this._calendar[e]||this._calendar.sameElse)?e.call(t,n):e},w.longDateFormat=function(e){var t=this._longDateFormat[e],n=this._longDateFormat[e.toUpperCase()];return t||!n?t:(this._longDateFormat[e]=n.match(te).map(function(e){return\"MMMM\"===e||\"MM\"===e||\"DD\"===e||\"dddd\"===e?e.slice(1):e}).join(\"\"),this._longDateFormat[e])},w.invalidDate=function(){return this._invalidDate},w.ordinal=function(e){return this._ordinal.replace(\"%d\",e)},w.preparse=dn,w.postformat=dn,w.relativeTime=function(e,t,n,s){var i=this._relativeTime[n];return d(i)?i(e,t,n,s):i.replace(/%d/i,e)},w.pastFuture=function(e,t){return d(e=this._relativeTime[0<e?\"future\":\"past\"])?e(t):e.replace(/%s/i,t)},w.set=function(e){var t,n;for(n in e)c(e,n)&&(d(t=e[n])?this[n]=t:this[\"_\"+n]=t);this._config=e,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+\"|\"+/\\d{1,2}/.source)},w.eras=function(e,t){for(var n,s=this._eras||mt(\"en\")._eras,i=0,r=s.length;i<r;++i){switch(typeof s[i].since){case\"string\":n=f(s[i].since).startOf(\"day\"),s[i].since=n.valueOf();break}switch(typeof s[i].until){case\"undefined\":s[i].until=1/0;break;case\"string\":n=f(s[i].until).startOf(\"day\").valueOf(),s[i].until=n.valueOf();break}}return s},w.erasParse=function(e,t,n){var s,i,r,a,o,u=this.eras();for(e=e.toUpperCase(),s=0,i=u.length;s<i;++s)if(r=u[s].name.toUpperCase(),a=u[s].abbr.toUpperCase(),o=u[s].narrow.toUpperCase(),n)switch(t){case\"N\":case\"NN\":case\"NNN\":if(a===e)return u[s];break;case\"NNNN\":if(r===e)return u[s];break;case\"NNNNN\":if(o===e)return u[s];break}else if(0<=[r,a,o].indexOf(e))return u[s]},w.erasConvertYear=function(e,t){var n=e.since<=e.until?1:-1;return void 0===t?f(e.since).year():f(e.since).year()+(t-e.offset)*n},w.erasAbbrRegex=function(e){return c(this,\"_erasAbbrRegex\")||an.call(this),e?this._erasAbbrRegex:this._erasRegex},w.erasNameRegex=function(e){return c(this,\"_erasNameRegex\")||an.call(this),e?this._erasNameRegex:this._erasRegex},w.erasNarrowRegex=function(e){return c(this,\"_erasNarrowRegex\")||an.call(this),e?this._erasNarrowRegex:this._erasRegex},w.months=function(e,t){return e?(a(this._months)?this._months:this._months[(this._months.isFormat||He).test(t)?\"format\":\"standalone\"])[e.month()]:a(this._months)?this._months:this._months.standalone},w.monthsShort=function(e,t){return e?(a(this._monthsShort)?this._monthsShort:this._monthsShort[He.test(t)?\"format\":\"standalone\"])[e.month()]:a(this._monthsShort)?this._monthsShort:this._monthsShort.standalone},w.monthsParse=function(e,t,n){var s,i;if(this._monthsParseExact)return function(e,t,n){var s,i,r,e=e.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],s=0;s<12;++s)r=l([2e3,s]),this._shortMonthsParse[s]=this.monthsShort(r,\"\").toLocaleLowerCase(),this._longMonthsParse[s]=this.months(r,\"\").toLocaleLowerCase();return n?\"MMM\"===t?-1!==(i=S.call(this._shortMonthsParse,e))?i:null:-1!==(i=S.call(this._longMonthsParse,e))?i:null:\"MMM\"===t?-1!==(i=S.call(this._shortMonthsParse,e))||-1!==(i=S.call(this._longMonthsParse,e))?i:null:-1!==(i=S.call(this._longMonthsParse,e))||-1!==(i=S.call(this._shortMonthsParse,e))?i:null}.call(this,e,t,n);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),s=0;s<12;s++){if(i=l([2e3,s]),n&&!this._longMonthsParse[s]&&(this._longMonthsParse[s]=new RegExp(\"^\"+this.months(i,\"\").replace(\".\",\"\")+\"$\",\"i\"),this._shortMonthsParse[s]=new RegExp(\"^\"+this.monthsShort(i,\"\").replace(\".\",\"\")+\"$\",\"i\")),n||this._monthsParse[s]||(i=\"^\"+this.months(i,\"\")+\"|^\"+this.monthsShort(i,\"\"),this._monthsParse[s]=new RegExp(i.replace(\".\",\"\"),\"i\")),n&&\"MMMM\"===t&&this._longMonthsParse[s].test(e))return s;if(n&&\"MMM\"===t&&this._shortMonthsParse[s].test(e))return s;if(!n&&this._monthsParse[s].test(e))return s}},w.monthsRegex=function(e){return this._monthsParseExact?(c(this,\"_monthsRegex\")||Ee.call(this),e?this._monthsStrictRegex:this._monthsRegex):(c(this,\"_monthsRegex\")||(this._monthsRegex=Le),this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex)},w.monthsShortRegex=function(e){return this._monthsParseExact?(c(this,\"_monthsRegex\")||Ee.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):(c(this,\"_monthsShortRegex\")||(this._monthsShortRegex=Fe),this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex)},w.week=function(e){return qe(e,this._week.dow,this._week.doy).week},w.firstDayOfYear=function(){return this._week.doy},w.firstDayOfWeek=function(){return this._week.dow},w.weekdays=function(e,t){return t=a(this._weekdays)?this._weekdays:this._weekdays[e&&!0!==e&&this._weekdays.isFormat.test(t)?\"format\":\"standalone\"],!0===e?Be(t,this._week.dow):e?t[e.day()]:t},w.weekdaysMin=function(e){return!0===e?Be(this._weekdaysMin,this._week.dow):e?this._weekdaysMin[e.day()]:this._weekdaysMin},w.weekdaysShort=function(e){return!0===e?Be(this._weekdaysShort,this._week.dow):e?this._weekdaysShort[e.day()]:this._weekdaysShort},w.weekdaysParse=function(e,t,n){var s,i;if(this._weekdaysParseExact)return function(e,t,n){var s,i,r,e=e.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],s=0;s<7;++s)r=l([2e3,1]).day(s),this._minWeekdaysParse[s]=this.weekdaysMin(r,\"\").toLocaleLowerCase(),this._shortWeekdaysParse[s]=this.weekdaysShort(r,\"\").toLocaleLowerCase(),this._weekdaysParse[s]=this.weekdays(r,\"\").toLocaleLowerCase();return n?\"dddd\"===t?-1!==(i=S.call(this._weekdaysParse,e))?i:null:\"ddd\"===t?-1!==(i=S.call(this._shortWeekdaysParse,e))?i:null:-1!==(i=S.call(this._minWeekdaysParse,e))?i:null:\"dddd\"===t?-1!==(i=S.call(this._weekdaysParse,e))||-1!==(i=S.call(this._shortWeekdaysParse,e))||-1!==(i=S.call(this._minWeekdaysParse,e))?i:null:\"ddd\"===t?-1!==(i=S.call(this._shortWeekdaysParse,e))||-1!==(i=S.call(this._weekdaysParse,e))||-1!==(i=S.call(this._minWeekdaysParse,e))?i:null:-1!==(i=S.call(this._minWeekdaysParse,e))||-1!==(i=S.call(this._weekdaysParse,e))||-1!==(i=S.call(this._shortWeekdaysParse,e))?i:null}.call(this,e,t,n);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),s=0;s<7;s++){if(i=l([2e3,1]).day(s),n&&!this._fullWeekdaysParse[s]&&(this._fullWeekdaysParse[s]=new RegExp(\"^\"+this.weekdays(i,\"\").replace(\".\",\"\\\\.?\")+\"$\",\"i\"),this._shortWeekdaysParse[s]=new RegExp(\"^\"+this.weekdaysShort(i,\"\").replace(\".\",\"\\\\.?\")+\"$\",\"i\"),this._minWeekdaysParse[s]=new RegExp(\"^\"+this.weekdaysMin(i,\"\").replace(\".\",\"\\\\.?\")+\"$\",\"i\")),this._weekdaysParse[s]||(i=\"^\"+this.weekdays(i,\"\")+\"|^\"+this.weekdaysShort(i,\"\")+\"|^\"+this.weekdaysMin(i,\"\"),this._weekdaysParse[s]=new RegExp(i.replace(\".\",\"\"),\"i\")),n&&\"dddd\"===t&&this._fullWeekdaysParse[s].test(e))return s;if(n&&\"ddd\"===t&&this._shortWeekdaysParse[s].test(e))return s;if(n&&\"dd\"===t&&this._minWeekdaysParse[s].test(e))return s;if(!n&&this._weekdaysParse[s].test(e))return s}},w.weekdaysRegex=function(e){return this._weekdaysParseExact?(c(this,\"_weekdaysRegex\")||nt.call(this),e?this._weekdaysStrictRegex:this._weekdaysRegex):(c(this,\"_weekdaysRegex\")||(this._weekdaysRegex=Ke),this._weekdaysStrictRegex&&e?this._weekdaysStrictRegex:this._weekdaysRegex)},w.weekdaysShortRegex=function(e){return this._weekdaysParseExact?(c(this,\"_weekdaysRegex\")||nt.call(this),e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(c(this,\"_weekdaysShortRegex\")||(this._weekdaysShortRegex=et),this._weekdaysShortStrictRegex&&e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)},w.weekdaysMinRegex=function(e){return this._weekdaysParseExact?(c(this,\"_weekdaysRegex\")||nt.call(this),e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(c(this,\"_weekdaysMinRegex\")||(this._weekdaysMinRegex=tt),this._weekdaysMinStrictRegex&&e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)},w.isPM=function(e){return\"p\"===(e+\"\").toLowerCase().charAt(0)},w.meridiem=function(e,t,n){return 11<e?n?\"pm\":\"PM\":n?\"am\":\"AM\"},ct(\"en\",{eras:[{since:\"0001-01-01\",until:1/0,offset:1,name:\"Anno Domini\",narrow:\"AD\",abbr:\"AD\"},{since:\"0000-12-31\",until:-1/0,offset:1,name:\"Before Christ\",narrow:\"BC\",abbr:\"BC\"}],dayOfMonthOrdinalParse:/\\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10;return e+(1===g(e%100/10)?\"th\":1==t?\"st\":2==t?\"nd\":3==t?\"rd\":\"th\")}}),f.lang=e(\"moment.lang is deprecated. Use moment.locale instead.\",ct),f.langData=e(\"moment.langData is deprecated. Use moment.localeData instead.\",mt);var _n=Math.abs;function yn(e,t,n,s){t=C(t,n);return e._milliseconds+=s*t._milliseconds,e._days+=s*t._days,e._months+=s*t._months,e._bubble()}function gn(e){return e<0?Math.floor(e):Math.ceil(e)}function wn(e){return 4800*e/146097}function pn(e){return 146097*e/4800}function kn(e){return function(){return this.as(e)}}pe=kn(\"ms\"),me=kn(\"s\"),Ce=kn(\"m\"),we=kn(\"h\"),ge=kn(\"d\"),Je=kn(\"w\"),k=kn(\"M\"),_e=kn(\"Q\"),ve=kn(\"y\");function vn(e){return function(){return this.isValid()?this._data[e]:NaN}}var ye=vn(\"milliseconds\"),ke=vn(\"seconds\"),Ie=vn(\"minutes\"),w=vn(\"hours\"),Mn=vn(\"days\"),Dn=vn(\"months\"),Sn=vn(\"years\");var Yn=Math.round,On={ss:44,s:45,m:45,h:22,d:26,w:null,M:11};function bn(e,t,n,s){var i=C(e).abs(),r=Yn(i.as(\"s\")),a=Yn(i.as(\"m\")),o=Yn(i.as(\"h\")),u=Yn(i.as(\"d\")),l=Yn(i.as(\"M\")),h=Yn(i.as(\"w\")),i=Yn(i.as(\"y\")),r=(r<=n.ss?[\"s\",r]:r<n.s&&[\"ss\",r])||a<=1&&[\"m\"]||a<n.m&&[\"mm\",a]||o<=1&&[\"h\"]||o<n.h&&[\"hh\",o]||u<=1&&[\"d\"]||u<n.d&&[\"dd\",u];return(r=(r=null!=n.w?r||h<=1&&[\"w\"]||h<n.w&&[\"ww\",h]:r)||l<=1&&[\"M\"]||l<n.M&&[\"MM\",l]||i<=1&&[\"y\"]||[\"yy\",i])[2]=t,r[3]=0<+e,r[4]=s,function(e,t,n,s,i){return i.relativeTime(t||1,!!n,e,s)}.apply(null,r)}var xn=Math.abs;function Tn(e){return(0<e)-(e<0)||+e}function Nn(){if(!this.isValid())return this.localeData().invalidDate();var e,t,n,s,i,r,a,o=xn(this._milliseconds)/1e3,u=xn(this._days),l=xn(this._months),h=this.asSeconds();return h?(e=y(o/60),t=y(e/60),o%=60,e%=60,n=y(l/12),l%=12,s=o?o.toFixed(3).replace(/\\.?0+$/,\"\"):\"\",i=Tn(this._months)!==Tn(h)?\"-\":\"\",r=Tn(this._days)!==Tn(h)?\"-\":\"\",a=Tn(this._milliseconds)!==Tn(h)?\"-\":\"\",(h<0?\"-\":\"\")+\"P\"+(n?i+n+\"Y\":\"\")+(l?i+l+\"M\":\"\")+(u?r+u+\"D\":\"\")+(t||e||o?\"T\":\"\")+(t?a+t+\"H\":\"\")+(e?a+e+\"M\":\"\")+(o?a+s+\"S\":\"\")):\"P0D\"}var U=Ct.prototype;return U.isValid=function(){return this._isValid},U.abs=function(){var e=this._data;return this._milliseconds=_n(this._milliseconds),this._days=_n(this._days),this._months=_n(this._months),e.milliseconds=_n(e.milliseconds),e.seconds=_n(e.seconds),e.minutes=_n(e.minutes),e.hours=_n(e.hours),e.months=_n(e.months),e.years=_n(e.years),this},U.add=function(e,t){return yn(this,e,t,1)},U.subtract=function(e,t){return yn(this,e,t,-1)},U.as=function(e){if(!this.isValid())return NaN;var t,n,s=this._milliseconds;if(\"month\"===(e=_(e))||\"quarter\"===e||\"year\"===e)switch(t=this._days+s/864e5,n=this._months+wn(t),e){case\"month\":return n;case\"quarter\":return n/3;case\"year\":return n/12}else switch(t=this._days+Math.round(pn(this._months)),e){case\"week\":return t/7+s/6048e5;case\"day\":return t+s/864e5;case\"hour\":return 24*t+s/36e5;case\"minute\":return 1440*t+s/6e4;case\"second\":return 86400*t+s/1e3;case\"millisecond\":return Math.floor(864e5*t)+s;default:throw new Error(\"Unknown unit \"+e)}},U.asMilliseconds=pe,U.asSeconds=me,U.asMinutes=Ce,U.asHours=we,U.asDays=ge,U.asWeeks=Je,U.asMonths=k,U.asQuarters=_e,U.asYears=ve,U.valueOf=function(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*g(this._months/12):NaN},U._bubble=function(){var e=this._milliseconds,t=this._days,n=this._months,s=this._data;return 0<=e&&0<=t&&0<=n||e<=0&&t<=0&&n<=0||(e+=864e5*gn(pn(n)+t),n=t=0),s.milliseconds=e%1e3,e=y(e/1e3),s.seconds=e%60,e=y(e/60),s.minutes=e%60,e=y(e/60),s.hours=e%24,t+=y(e/24),n+=e=y(wn(t)),t-=gn(pn(e)),e=y(n/12),n%=12,s.days=t,s.months=n,s.years=e,this},U.clone=function(){return C(this)},U.get=function(e){return e=_(e),this.isValid()?this[e+\"s\"]():NaN},U.milliseconds=ye,U.seconds=ke,U.minutes=Ie,U.hours=w,U.days=Mn,U.weeks=function(){return y(this.days()/7)},U.months=Dn,U.years=Sn,U.humanize=function(e,t){if(!this.isValid())return this.localeData().invalidDate();var n=!1,s=On;return\"object\"==typeof e&&(t=e,e=!1),\"boolean\"==typeof e&&(n=e),\"object\"==typeof t&&(s=Object.assign({},On,t),null!=t.s&&null==t.ss&&(s.ss=t.s-1)),e=this.localeData(),t=bn(this,!n,s,e),n&&(t=e.pastFuture(+this,t)),e.postformat(t)},U.toISOString=Nn,U.toString=Nn,U.toJSON=Nn,U.locale=Xt,U.localeData=Kt,U.toIsoString=e(\"toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)\",Nn),U.lang=Xe,s(\"X\",0,0,\"unix\"),s(\"x\",0,0,\"valueOf\"),v(\"x\",De),v(\"X\",/[+-]?\\d+(\\.\\d{1,3})?/),D(\"X\",function(e,t,n){n._d=new Date(1e3*parseFloat(e))}),D(\"x\",function(e,t,n){n._d=new Date(g(e))}),f.version=\"2.29.4\",H=W,f.fn=i,f.min=function(){return Rt(\"isBefore\",[].slice.call(arguments,0))},f.max=function(){return Rt(\"isAfter\",[].slice.call(arguments,0))},f.now=function(){return Date.now?Date.now():+new Date},f.utc=l,f.unix=function(e){return W(1e3*e)},f.months=function(e,t){return fn(e,t,\"months\")},f.isDate=V,f.locale=ct,f.invalid=I,f.duration=C,f.isMoment=h,f.weekdays=function(e,t,n){return mn(e,t,n,\"weekdays\")},f.parseZone=function(){return W.apply(null,arguments).parseZone()},f.localeData=mt,f.isDuration=Ut,f.monthsShort=function(e,t){return fn(e,t,\"monthsShort\")},f.weekdaysMin=function(e,t,n){return mn(e,t,n,\"weekdaysMin\")},f.defineLocale=ft,f.updateLocale=function(e,t){var n,s;return null!=t?(s=ot,null!=R[e]&&null!=R[e].parentLocale?R[e].set(X(R[e]._config,t)):(t=X(s=null!=(n=dt(e))?n._config:s,t),null==n&&(t.abbr=e),(s=new K(t)).parentLocale=R[e],R[e]=s),ct(e)):null!=R[e]&&(null!=R[e].parentLocale?(R[e]=R[e].parentLocale,e===ct()&&ct(e)):null!=R[e]&&delete R[e]),R[e]},f.locales=function(){return ee(R)},f.weekdaysShort=function(e,t,n){return mn(e,t,n,\"weekdaysShort\")},f.normalizeUnits=_,f.relativeTimeRounding=function(e){return void 0===e?Yn:\"function\"==typeof e&&(Yn=e,!0)},f.relativeTimeThreshold=function(e,t){return void 0!==On[e]&&(void 0===t?On[e]:(On[e]=t,\"s\"===e&&(On.ss=t-1),!0))},f.calendarFormat=function(e,t){return(e=e.diff(t,\"days\",!0))<-6?\"sameElse\":e<-1?\"lastWeek\":e<0?\"lastDay\":e<1?\"sameDay\":e<2?\"nextDay\":e<7?\"nextWeek\":\"sameElse\"},f.prototype=i,f.HTML5_FMT={DATETIME_LOCAL:\"YYYY-MM-DDTHH:mm\",DATETIME_LOCAL_SECONDS:\"YYYY-MM-DDTHH:mm:ss\",DATETIME_LOCAL_MS:\"YYYY-MM-DDTHH:mm:ss.SSS\",DATE:\"YYYY-MM-DD\",TIME:\"HH:mm\",TIME_SECONDS:\"HH:mm:ss\",TIME_MS:\"HH:mm:ss.SSS\",WEEK:\"GGGG-[W]WW\",MONTH:\"YYYY-MM\"},f});\n/* jscs:disable */\n/* eslint:disable */\n","moment-timezone-with-data.js":"//! moment-timezone.js\n//! version : 0.5.43\n//! Copyright (c) JS Foundation and other contributors\n//! license : MIT\n//! github.com/moment/moment-timezone\n\n(function (root, factory) {\n    \"use strict\";\n\n    /*global define*/\n    if (typeof module === 'object' && module.exports) {\n        module.exports = factory(require('moment')); // Node\n    } else if (typeof define === 'function' && define.amd) {\n        define(['moment'], factory);                 // AMD\n    } else {\n        factory(root.moment);                        // Browser\n    }\n}(this, function (moment) {\n    \"use strict\";\n\n    // Resolves es6 module loading issue\n    if (moment.version === undefined && moment.default) {\n        moment = moment.default;\n    }\n\n    // Do not load moment-timezone a second time.\n    // if (moment.tz !== undefined) {\n    // \tlogError('Moment Timezone ' + moment.tz.version + ' was already loaded ' + (moment.tz.dataVersion ? 'with data from ' : 'without any data') + moment.tz.dataVersion);\n    // \treturn moment;\n    // }\n\n    var VERSION = \"0.5.43\",\n        zones = {},\n        links = {},\n        countries = {},\n        names = {},\n        guesses = {},\n        cachedGuess;\n\n    if (!moment || typeof moment.version !== 'string') {\n        logError('Moment Timezone requires Moment.js. See https://momentjs.com/timezone/docs/#/use-it/browser/');\n    }\n\n    var momentVersion = moment.version.split('.'),\n        major = +momentVersion[0],\n        minor = +momentVersion[1];\n\n    // Moment.js version check\n    if (major < 2 || (major === 2 && minor < 6)) {\n        logError('Moment Timezone requires Moment.js >= 2.6.0. You are using Moment.js ' + moment.version + '. See momentjs.com');\n    }\n\n    /************************************\n     Unpacking\n     ************************************/\n\n    function charCodeToInt(charCode) {\n        if (charCode > 96) {\n            return charCode - 87;\n        } else if (charCode > 64) {\n            return charCode - 29;\n        }\n        return charCode - 48;\n    }\n\n    function unpackBase60(string) {\n        var i = 0,\n            parts = string.split('.'),\n            whole = parts[0],\n            fractional = parts[1] || '',\n            multiplier = 1,\n            num,\n            out = 0,\n            sign = 1;\n\n        // handle negative numbers\n        if (string.charCodeAt(0) === 45) {\n            i = 1;\n            sign = -1;\n        }\n\n        // handle digits before the decimal\n        for (i; i < whole.length; i++) {\n            num = charCodeToInt(whole.charCodeAt(i));\n            out = 60 * out + num;\n        }\n\n        // handle digits after the decimal\n        for (i = 0; i < fractional.length; i++) {\n            multiplier = multiplier / 60;\n            num = charCodeToInt(fractional.charCodeAt(i));\n            out += num * multiplier;\n        }\n\n        return out * sign;\n    }\n\n    function arrayToInt (array) {\n        for (var i = 0; i < array.length; i++) {\n            array[i] = unpackBase60(array[i]);\n        }\n    }\n\n    function intToUntil (array, length) {\n        for (var i = 0; i < length; i++) {\n            array[i] = Math.round((array[i - 1] || 0) + (array[i] * 60000)); // minutes to milliseconds\n        }\n\n        array[length - 1] = Infinity;\n    }\n\n    function mapIndices (source, indices) {\n        var out = [], i;\n\n        for (i = 0; i < indices.length; i++) {\n            out[i] = source[indices[i]];\n        }\n\n        return out;\n    }\n\n    function unpack (string) {\n        var data = string.split('|'),\n            offsets = data[2].split(' '),\n            indices = data[3].split(''),\n            untils  = data[4].split(' ');\n\n        arrayToInt(offsets);\n        arrayToInt(indices);\n        arrayToInt(untils);\n\n        intToUntil(untils, indices.length);\n\n        return {\n            name       : data[0],\n            abbrs      : mapIndices(data[1].split(' '), indices),\n            offsets    : mapIndices(offsets, indices),\n            untils     : untils,\n            population : data[5] | 0\n        };\n    }\n\n    /************************************\n     Zone object\n     ************************************/\n\n    function Zone (packedString) {\n        if (packedString) {\n            this._set(unpack(packedString));\n        }\n    }\n\n    Zone.prototype = {\n        _set : function (unpacked) {\n            this.name       = unpacked.name;\n            this.abbrs      = unpacked.abbrs;\n            this.untils     = unpacked.untils;\n            this.offsets    = unpacked.offsets;\n            this.population = unpacked.population;\n        },\n\n        _index : function (timestamp) {\n            var target = +timestamp,\n                untils = this.untils,\n                i;\n\n            for (i = 0; i < untils.length; i++) {\n                if (target < untils[i]) {\n                    return i;\n                }\n            }\n        },\n\n        countries : function () {\n            var zone_name = this.name;\n            return Object.keys(countries).filter(function (country_code) {\n                return countries[country_code].zones.indexOf(zone_name) !== -1;\n            });\n        },\n\n        parse : function (timestamp) {\n            var target  = +timestamp,\n                offsets = this.offsets,\n                untils  = this.untils,\n                max     = untils.length - 1,\n                offset, offsetNext, offsetPrev, i;\n\n            for (i = 0; i < max; i++) {\n                offset     = offsets[i];\n                offsetNext = offsets[i + 1];\n                offsetPrev = offsets[i ? i - 1 : i];\n\n                if (offset < offsetNext && tz.moveAmbiguousForward) {\n                    offset = offsetNext;\n                } else if (offset > offsetPrev && tz.moveInvalidForward) {\n                    offset = offsetPrev;\n                }\n\n                if (target < untils[i] - (offset * 60000)) {\n                    return offsets[i];\n                }\n            }\n\n            return offsets[max];\n        },\n\n        abbr : function (mom) {\n            return this.abbrs[this._index(mom)];\n        },\n\n        offset : function (mom) {\n            logError(\"zone.offset has been deprecated in favor of zone.utcOffset\");\n            return this.offsets[this._index(mom)];\n        },\n\n        utcOffset : function (mom) {\n            return this.offsets[this._index(mom)];\n        }\n    };\n\n    /************************************\n     Country object\n     ************************************/\n\n    function Country (country_name, zone_names) {\n        this.name = country_name;\n        this.zones = zone_names;\n    }\n\n    /************************************\n     Current Timezone\n     ************************************/\n\n    function OffsetAt(at) {\n        var timeString = at.toTimeString();\n        var abbr = timeString.match(/\\([a-z ]+\\)/i);\n        if (abbr && abbr[0]) {\n            // 17:56:31 GMT-0600 (CST)\n            // 17:56:31 GMT-0600 (Central Standard Time)\n            abbr = abbr[0].match(/[A-Z]/g);\n            abbr = abbr ? abbr.join('') : undefined;\n        } else {\n            // 17:56:31 CST\n            // 17:56:31 GMT+0800 (\u53f0\u5317\u6a19\u6e96\u6642\u9593)\n            abbr = timeString.match(/[A-Z]{3,5}/g);\n            abbr = abbr ? abbr[0] : undefined;\n        }\n\n        if (abbr === 'GMT') {\n            abbr = undefined;\n        }\n\n        this.at = +at;\n        this.abbr = abbr;\n        this.offset = at.getTimezoneOffset();\n    }\n\n    function ZoneScore(zone) {\n        this.zone = zone;\n        this.offsetScore = 0;\n        this.abbrScore = 0;\n    }\n\n    ZoneScore.prototype.scoreOffsetAt = function (offsetAt) {\n        this.offsetScore += Math.abs(this.zone.utcOffset(offsetAt.at) - offsetAt.offset);\n        if (this.zone.abbr(offsetAt.at).replace(/[^A-Z]/g, '') !== offsetAt.abbr) {\n            this.abbrScore++;\n        }\n    };\n\n    function findChange(low, high) {\n        var mid, diff;\n\n        while ((diff = ((high.at - low.at) / 12e4 | 0) * 6e4)) {\n            mid = new OffsetAt(new Date(low.at + diff));\n            if (mid.offset === low.offset) {\n                low = mid;\n            } else {\n                high = mid;\n            }\n        }\n\n        return low;\n    }\n\n    function userOffsets() {\n        var startYear = new Date().getFullYear() - 2,\n            last = new OffsetAt(new Date(startYear, 0, 1)),\n            offsets = [last],\n            change, next, i;\n\n        for (i = 1; i < 48; i++) {\n            next = new OffsetAt(new Date(startYear, i, 1));\n            if (next.offset !== last.offset) {\n                change = findChange(last, next);\n                offsets.push(change);\n                offsets.push(new OffsetAt(new Date(change.at + 6e4)));\n            }\n            last = next;\n        }\n\n        for (i = 0; i < 4; i++) {\n            offsets.push(new OffsetAt(new Date(startYear + i, 0, 1)));\n            offsets.push(new OffsetAt(new Date(startYear + i, 6, 1)));\n        }\n\n        return offsets;\n    }\n\n    function sortZoneScores (a, b) {\n        if (a.offsetScore !== b.offsetScore) {\n            return a.offsetScore - b.offsetScore;\n        }\n        if (a.abbrScore !== b.abbrScore) {\n            return a.abbrScore - b.abbrScore;\n        }\n        if (a.zone.population !== b.zone.population) {\n            return b.zone.population - a.zone.population;\n        }\n        return b.zone.name.localeCompare(a.zone.name);\n    }\n\n    function addToGuesses (name, offsets) {\n        var i, offset;\n        arrayToInt(offsets);\n        for (i = 0; i < offsets.length; i++) {\n            offset = offsets[i];\n            guesses[offset] = guesses[offset] || {};\n            guesses[offset][name] = true;\n        }\n    }\n\n    function guessesForUserOffsets (offsets) {\n        var offsetsLength = offsets.length,\n            filteredGuesses = {},\n            out = [],\n            i, j, guessesOffset;\n\n        for (i = 0; i < offsetsLength; i++) {\n            guessesOffset = guesses[offsets[i].offset] || {};\n            for (j in guessesOffset) {\n                if (guessesOffset.hasOwnProperty(j)) {\n                    filteredGuesses[j] = true;\n                }\n            }\n        }\n\n        for (i in filteredGuesses) {\n            if (filteredGuesses.hasOwnProperty(i)) {\n                out.push(names[i]);\n            }\n        }\n\n        return out;\n    }\n\n    function rebuildGuess () {\n\n        // use Intl API when available and returning valid time zone\n        try {\n            var intlName = Intl.DateTimeFormat().resolvedOptions().timeZone;\n            if (intlName && intlName.length > 3) {\n                var name = names[normalizeName(intlName)];\n                if (name) {\n                    return name;\n                }\n                logError(\"Moment Timezone found \" + intlName + \" from the Intl api, but did not have that data loaded.\");\n            }\n        } catch (e) {\n            // Intl unavailable, fall back to manual guessing.\n        }\n\n        var offsets = userOffsets(),\n            offsetsLength = offsets.length,\n            guesses = guessesForUserOffsets(offsets),\n            zoneScores = [],\n            zoneScore, i, j;\n\n        for (i = 0; i < guesses.length; i++) {\n            zoneScore = new ZoneScore(getZone(guesses[i]), offsetsLength);\n            for (j = 0; j < offsetsLength; j++) {\n                zoneScore.scoreOffsetAt(offsets[j]);\n            }\n            zoneScores.push(zoneScore);\n        }\n\n        zoneScores.sort(sortZoneScores);\n\n        return zoneScores.length > 0 ? zoneScores[0].zone.name : undefined;\n    }\n\n    function guess (ignoreCache) {\n        if (!cachedGuess || ignoreCache) {\n            cachedGuess = rebuildGuess();\n        }\n        return cachedGuess;\n    }\n\n    /************************************\n     Global Methods\n     ************************************/\n\n    function normalizeName (name) {\n        return (name || '').toLowerCase().replace(/\\//g, '_');\n    }\n\n    function addZone (packed) {\n        var i, name, split, normalized;\n\n        if (typeof packed === \"string\") {\n            packed = [packed];\n        }\n\n        for (i = 0; i < packed.length; i++) {\n            split = packed[i].split('|');\n            name = split[0];\n            normalized = normalizeName(name);\n            zones[normalized] = packed[i];\n            names[normalized] = name;\n            addToGuesses(normalized, split[2].split(' '));\n        }\n    }\n\n    function getZone (name, caller) {\n\n        name = normalizeName(name);\n\n        var zone = zones[name];\n        var link;\n\n        if (zone instanceof Zone) {\n            return zone;\n        }\n\n        if (typeof zone === 'string') {\n            zone = new Zone(zone);\n            zones[name] = zone;\n            return zone;\n        }\n\n        // Pass getZone to prevent recursion more than 1 level deep\n        if (links[name] && caller !== getZone && (link = getZone(links[name], getZone))) {\n            zone = zones[name] = new Zone();\n            zone._set(link);\n            zone.name = names[name];\n            return zone;\n        }\n\n        return null;\n    }\n\n    function getNames () {\n        var i, out = [];\n\n        for (i in names) {\n            if (names.hasOwnProperty(i) && (zones[i] || zones[links[i]]) && names[i]) {\n                out.push(names[i]);\n            }\n        }\n\n        return out.sort();\n    }\n\n    function getCountryNames () {\n        return Object.keys(countries);\n    }\n\n    function addLink (aliases) {\n        var i, alias, normal0, normal1;\n\n        if (typeof aliases === \"string\") {\n            aliases = [aliases];\n        }\n\n        for (i = 0; i < aliases.length; i++) {\n            alias = aliases[i].split('|');\n\n            normal0 = normalizeName(alias[0]);\n            normal1 = normalizeName(alias[1]);\n\n            links[normal0] = normal1;\n            names[normal0] = alias[0];\n\n            links[normal1] = normal0;\n            names[normal1] = alias[1];\n        }\n    }\n\n    function addCountries (data) {\n        var i, country_code, country_zones, split;\n        if (!data || !data.length) return;\n        for (i = 0; i < data.length; i++) {\n            split = data[i].split('|');\n            country_code = split[0].toUpperCase();\n            country_zones = split[1].split(' ');\n            countries[country_code] = new Country(\n                country_code,\n                country_zones\n            );\n        }\n    }\n\n    function getCountry (name) {\n        name = name.toUpperCase();\n        return countries[name] || null;\n    }\n\n    function zonesForCountry(country, with_offset) {\n        country = getCountry(country);\n\n        if (!country) return null;\n\n        var zones = country.zones.sort();\n\n        if (with_offset) {\n            return zones.map(function (zone_name) {\n                var zone = getZone(zone_name);\n                return {\n                    name: zone_name,\n                    offset: zone.utcOffset(new Date())\n                };\n            });\n        }\n\n        return zones;\n    }\n\n    function loadData (data) {\n        addZone(data.zones);\n        addLink(data.links);\n        addCountries(data.countries);\n        tz.dataVersion = data.version;\n    }\n\n    function zoneExists (name) {\n        if (!zoneExists.didShowError) {\n            zoneExists.didShowError = true;\n            logError(\"moment.tz.zoneExists('\" + name + \"') has been deprecated in favor of !moment.tz.zone('\" + name + \"')\");\n        }\n        return !!getZone(name);\n    }\n\n    function needsOffset (m) {\n        var isUnixTimestamp = (m._f === 'X' || m._f === 'x');\n        return !!(m._a && (m._tzm === undefined) && !isUnixTimestamp);\n    }\n\n    function logError (message) {\n        if (typeof console !== 'undefined' && typeof console.error === 'function') {\n            console.error(message);\n        }\n    }\n\n    /************************************\n     moment.tz namespace\n     ************************************/\n\n    function tz (input) {\n        var args = Array.prototype.slice.call(arguments, 0, -1),\n            name = arguments[arguments.length - 1],\n            zone = getZone(name),\n            out  = moment.utc.apply(null, args);\n\n        if (zone && !moment.isMoment(input) && needsOffset(out)) {\n            out.add(zone.parse(out), 'minutes');\n        }\n\n        out.tz(name);\n\n        return out;\n    }\n\n    tz.version      = VERSION;\n    tz.dataVersion  = '';\n    tz._zones       = zones;\n    tz._links       = links;\n    tz._names       = names;\n    tz._countries\t= countries;\n    tz.add          = addZone;\n    tz.link         = addLink;\n    tz.load         = loadData;\n    tz.zone         = getZone;\n    tz.zoneExists   = zoneExists; // deprecated in 0.1.0\n    tz.guess        = guess;\n    tz.names        = getNames;\n    tz.Zone         = Zone;\n    tz.unpack       = unpack;\n    tz.unpackBase60 = unpackBase60;\n    tz.needsOffset  = needsOffset;\n    tz.moveInvalidForward   = true;\n    tz.moveAmbiguousForward = false;\n    tz.countries    = getCountryNames;\n    tz.zonesForCountry = zonesForCountry;\n\n    /************************************\n     Interface with Moment.js\n     ************************************/\n\n    var fn = moment.fn;\n\n    moment.tz = tz;\n\n    moment.defaultZone = null;\n\n    moment.updateOffset = function (mom, keepTime) {\n        var zone = moment.defaultZone,\n            offset;\n\n        if (mom._z === undefined) {\n            if (zone && needsOffset(mom) && !mom._isUTC) {\n                mom._d = moment.utc(mom._a)._d;\n                mom.utc().add(zone.parse(mom), 'minutes');\n            }\n            mom._z = zone;\n        }\n        if (mom._z) {\n            offset = mom._z.utcOffset(mom);\n            if (Math.abs(offset) < 16) {\n                offset = offset / 60;\n            }\n            if (mom.utcOffset !== undefined) {\n                var z = mom._z;\n                mom.utcOffset(-offset, keepTime);\n                mom._z = z;\n            } else {\n                mom.zone(offset, keepTime);\n            }\n        }\n    };\n\n    fn.tz = function (name, keepTime) {\n        if (name) {\n            if (typeof name !== 'string') {\n                throw new Error('Time zone name must be a string, got ' + name + ' [' + typeof name + ']');\n            }\n            this._z = getZone(name);\n            if (this._z) {\n                moment.updateOffset(this, keepTime);\n            } else {\n                logError(\"Moment Timezone has no data for \" + name + \". See http://momentjs.com/timezone/docs/#/data-loading/.\");\n            }\n            return this;\n        }\n        if (this._z) { return this._z.name; }\n    };\n\n    function abbrWrap (old) {\n        return function () {\n            if (this._z) { return this._z.abbr(this); }\n            return old.call(this);\n        };\n    }\n\n    function resetZoneWrap (old) {\n        return function () {\n            this._z = null;\n            return old.apply(this, arguments);\n        };\n    }\n\n    function resetZoneWrap2 (old) {\n        return function () {\n            if (arguments.length > 0) this._z = null;\n            return old.apply(this, arguments);\n        };\n    }\n\n    fn.zoneName  = abbrWrap(fn.zoneName);\n    fn.zoneAbbr  = abbrWrap(fn.zoneAbbr);\n    fn.utc       = resetZoneWrap(fn.utc);\n    fn.local     = resetZoneWrap(fn.local);\n    fn.utcOffset = resetZoneWrap2(fn.utcOffset);\n\n    moment.tz.setDefault = function(name) {\n        if (major < 2 || (major === 2 && minor < 9)) {\n            logError('Moment Timezone setDefault() requires Moment.js >= 2.9.0. You are using Moment.js ' + moment.version + '.');\n        }\n        moment.defaultZone = name ? getZone(name) : null;\n        return moment;\n    };\n\n    // Cloning a moment should include the _z property.\n    var momentProperties = moment.momentProperties;\n    if (Object.prototype.toString.call(momentProperties) === '[object Array]') {\n        // moment 2.8.1+\n        momentProperties.push('_z');\n        momentProperties.push('_a');\n    } else if (momentProperties) {\n        // moment 2.7.0\n        momentProperties._z = null;\n    }\n\n    loadData({\n        \"version\": \"2023c\",\n        \"zones\": [\n            \"Africa/Abidjan|GMT|0|0||48e5\",\n            \"Africa/Nairobi|EAT|-30|0||47e5\",\n            \"Africa/Algiers|WET WEST CET CEST|0 -10 -10 -20|01012320102|3bX0 11A0 dDd0 17b0 11B0 1cN0 2Dy0 1cN0 1fB0 1cL0|26e5\",\n            \"Africa/Lagos|WAT|-10|0||17e6\",\n            \"Africa/Bissau|-01 GMT|10 0|01|cap0|39e4\",\n            \"Africa/Maputo|CAT|-20|0||26e5\",\n            \"Africa/Cairo|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|LX0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1WL0 rd0 1Rz0 wp0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1qL0 Xd0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1ny0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 WL0 1qN0 Rb0 1wp0 On0 1zd0 Lz0 1EN0 Fb0 c10 8n0 8Nd0 gL0 e10 mn0 kSp0 1cL0 1cN0 1fz0 1a10 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0|15e6\",\n            \"Africa/Casablanca|+00 +01|0 -10|01010101010101010101010101010101010101010101010101010101010101010101010|aS00 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4mn0 SyN0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600|32e5\",\n            \"Africa/Ceuta|WET WEST CET CEST|0 -10 -10 -20|0101010102323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|aS00 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4VB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|85e3\",\n            \"Africa/El_Aaiun|-01 +00 +01|10 0 -10|01212121212121212121212121212121212121212121212121212121212121212121|fi10 6L0 AL0 1Nd0 XX0 1Cp0 pz0 1cBB0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600|20e4\",\n            \"Africa/Johannesburg|SAST|-20|0||84e5\",\n            \"Africa/Juba|CAT CAST EAT|-20 -30 -30|01010101010101010101010101010101020|LW0 16L0 1iN0 17b0 1jd0 17b0 1ip0 17z0 1i10 17X0 1hB0 18n0 1hd0 19b0 1gp0 19z0 1iN0 17b0 1ip0 17z0 1i10 18n0 1hd0 18L0 1gN0 19b0 1gp0 19z0 1iN0 17z0 1i10 17X0 yGd0 PeX0|\",\n            \"Africa/Khartoum|CAT CAST EAT|-20 -30 -30|01010101010101010101010101010101020|LW0 16L0 1iN0 17b0 1jd0 17b0 1ip0 17z0 1i10 17X0 1hB0 18n0 1hd0 19b0 1gp0 19z0 1iN0 17b0 1ip0 17z0 1i10 18n0 1hd0 18L0 1gN0 19b0 1gp0 19z0 1iN0 17z0 1i10 17X0 yGd0 HjL0|51e5\",\n            \"Africa/Monrovia|MMT GMT|I.u 0|01|4SoI.u|11e5\",\n            \"Africa/Ndjamena|WAT WAST|-10 -20|010|nNb0 Wn0|13e5\",\n            \"Africa/Sao_Tome|GMT WAT|0 -10|010|1UQN0 2q00|\",\n            \"Africa/Tripoli|EET CET CEST|-20 -10 -20|0121212121212121210120120|tda0 A10 1db0 1cN0 1db0 1dd0 1db0 1eN0 1bb0 1e10 1cL0 1c10 1db0 1dd0 1db0 1cN0 1db0 1q10 fAn0 1ep0 1db0 AKq0 TA0 1o00|11e5\",\n            \"Africa/Tunis|CET CEST|-10 -20|0101010101010101010|hOn0 WM0 1rA0 11c0 nwo0 Ko0 1cM0 1cM0 1rA0 10M0 zuM0 10N0 1aN0 1qM0 WM0 1qM0 11A0 1o00|20e5\",\n            \"Africa/Windhoek|SAST CAT WAT|-20 -20 -10|01212121212121212121212121212121212121212121212121|Ndy0 9Io0 16P0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0|32e4\",\n            \"America/Adak|BST BDT AHST HST HDT|b0 a0 a0 a0 90|0101010101010101010101010101234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|Kd0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|326\",\n            \"America/Anchorage|AHST AHDT YST AKST AKDT|a0 90 90 90 80|0101010101010101010101010101234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|Kc0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|30e4\",\n            \"America/Puerto_Rico|AST|40|0||24e5\",\n            \"America/Araguaina|-03 -02|30 20|01010101010101010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 ny10 Lz0|14e4\",\n            \"America/Argentina/Buenos_Aires|-03 -02|30 20|01010101010101010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 A4p0 uL0 1qN0 WL0|\",\n            \"America/Argentina/Catamarca|-03 -02 -04|30 20 40|01010101210102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 rlB0 7B0 8zb0 uL0|\",\n            \"America/Argentina/Cordoba|-03 -02 -04|30 20 40|01010101210101010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 A4p0 uL0 1qN0 WL0|\",\n            \"America/Argentina/Jujuy|-03 -02 -04|30 20 40|010101202101010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1ze0 TX0 1ld0 WK0 1wp0 TX0 A4p0 uL0|\",\n            \"America/Argentina/La_Rioja|-03 -02 -04|30 20 40|010101012010102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 rlB0 7B0 8zb0 uL0|\",\n            \"America/Argentina/Mendoza|-03 -02 -04|30 20 40|01010120202102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1u20 SL0 1vd0 Tb0 1wp0 TW0 ri10 Op0 7TX0 uL0|\",\n            \"America/Argentina/Rio_Gallegos|-03 -02 -04|30 20 40|01010101010102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 rlB0 7B0 8zb0 uL0|\",\n            \"America/Argentina/Salta|-03 -02 -04|30 20 40|010101012101010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 A4p0 uL0|\",\n            \"America/Argentina/San_Juan|-03 -02 -04|30 20 40|010101012010102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 rld0 m10 8lb0 uL0|\",\n            \"America/Argentina/San_Luis|-03 -02 -04|30 20 40|010101202020102020|9Rf0 Db0 zvd0 Bz0 1tB0 XX0 1q20 SL0 AN0 vDb0 m10 8lb0 8L0 jd0 1qN0 WL0 1qN0|\",\n            \"America/Argentina/Tucuman|-03 -02 -04|30 20 40|0101010121010201010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 rlB0 4N0 8BX0 uL0 1qN0 WL0|\",\n            \"America/Argentina/Ushuaia|-03 -02 -04|30 20 40|01010101010102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 rkN0 8p0 8zb0 uL0|\",\n            \"America/Asuncion|-04 -03|40 30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|6FE0 3CL0 3Dd0 10L0 1pB0 10n0 1pB0 10n0 1pB0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1lB0 14n0 1dd0 1cL0 1fd0 WL0 1rd0 1aL0 1dB0 Xz0 1qp0 Xb0 1qN0 10L0 1rB0 TX0 1tB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 WN0 1qL0 11B0 1nX0 1ip0 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 TX0 1tB0 19X0 1a10 1fz0 1a10 1fz0 1cN0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0|28e5\",\n            \"America/Panama|EST|50|0||15e5\",\n            \"America/Bahia_Banderas|PST MST MDT CDT CST|80 70 60 50 60|01212121212121212121212121212134343434343434343434343434|80 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nW0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|84e3\",\n            \"America/Bahia|-03 -02|30 20|010101010101010101010101010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 l5B0 Rb0|27e5\",\n            \"America/Barbados|AST ADT|40 30|010101010|i7G0 IL0 1ip0 17b0 1ip0 17b0 1ld0 13b0|28e4\",\n            \"America/Belem|-03 -02|30 20|0101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0|20e5\",\n            \"America/Belize|CST CDT|60 50|01010|9xG0 qn0 lxB0 mn0|57e3\",\n            \"America/Boa_Vista|-04 -03|40 30|01010101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 smp0 WL0 1tB0 2L0|62e2\",\n            \"America/Bogota|-05 -04|50 40|010|Snh0 1PX0|90e5\",\n            \"America/Boise|MST MDT|70 60|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 Dd0 1Kn0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e4\",\n            \"America/Cambridge_Bay|MST MDT CST CDT EST|70 60 60 50 50|010101010101010101010101010101010101010101010101010101012342101010101010101010101010101010101010101010101010101010101010|5E90 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11A0 1nX0 2K0 WQ0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e2\",\n            \"America/Campo_Grande|-04 -03|40 30|010101010101010101010101010101010101010101010101010101010101010101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1HB0 FX0|77e4\",\n            \"America/Cancun|CST EST EDT CDT|60 50 40 50|012121230303030303030303030303030303030301|t9G0 yLB0 1lb0 14p0 1lb0 14p0 Lz0 xB0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 Dd0|63e4\",\n            \"America/Caracas|-04 -0430|40 4u|010|1wmv0 kqo0|29e5\",\n            \"America/Cayenne|-03|30|0||58e3\",\n            \"America/Chicago|CST CDT|60 50|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K80 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|92e5\",\n            \"America/Chihuahua|CST CDT MDT MST|60 50 60 70|0101023232323232323232323232323232323232323232323232320|13Vk0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|81e4\",\n            \"America/Ciudad_Juarez|CST CDT MDT MST|60 50 60 70|010102323232323232323232323232323232323232323232323232032323232323232323|13Vk0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1wn0 cm0 EP0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Costa_Rica|CST CDT|60 50|010101010|mgS0 Db0 1Kp0 Db0 pRB0 15b0 1kp0 mL0|12e5\",\n            \"America/Phoenix|MST|70|0||42e5\",\n            \"America/Cuiaba|-04 -03|40 30|0101010101010101010101010101010101010101010101010101010101010101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 4a10 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1HB0 FX0|54e4\",\n            \"America/Danmarkshavn|-03 -02 GMT|30 20 0|0101010101010101010101010101010102|oXh0 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 DC0|8\",\n            \"America/Dawson_Creek|PST PDT MST|80 70 70|0101012|Ka0 1cL0 1cN0 1fz0 1cN0 ML0|12e3\",\n            \"America/Dawson|YST PST PDT MST|90 80 70 70|012121212121212121212121212121212121212121212121212121212121212121212121212121212123|9ix0 fNd0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1z90|13e2\",\n            \"America/Denver|MST MDT|70 60|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e5\",\n            \"America/Detroit|EST EDT|50 40|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|85H0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e5\",\n            \"America/Edmonton|MST MDT|70 60|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|5E90 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|10e5\",\n            \"America/Eirunepe|-05 -04|50 40|01010101010|CxF0 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0 yTd0 d5X0|31e3\",\n            \"America/El_Salvador|CST CDT|60 50|01010|Gcu0 WL0 1qN0 WL0|11e5\",\n            \"America/Tijuana|PST PDT|80 70|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|fmy0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|20e5\",\n            \"America/Fort_Nelson|PST PDT MST|80 70 70|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010102|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0|39e2\",\n            \"America/Fort_Wayne|EST EDT|50 40|01010101010101010101010101010101010101010101010101010|K70 1cL0 1qhd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Fortaleza|-03 -02|30 20|01010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 5z0 2mN0 On0|34e5\",\n            \"America/Glace_Bay|AST ADT|40 30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|5E60 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|19e3\",\n            \"America/Godthab|-03 -02 -01|30 20 10|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010121212121212121|oXh0 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 2so0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|17e3\",\n            \"America/Goose_Bay|AST ADT ADDT|40 30 20|010101010101010101010101010101010101020101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K60 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|76e2\",\n            \"America/Grand_Turk|EST EDT AST|50 40 40|0101010101010101010101010101010101010101010101010101010101010101010101010210101010101010101010101010|mG70 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 7jA0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e2\",\n            \"America/Guatemala|CST CDT|60 50|010101010|9tG0 An0 mtd0 Nz0 ifB0 17b0 zDB0 11z0|13e5\",\n            \"America/Guayaquil|-05 -04|50 40|010|TKR0 rz0|27e5\",\n            \"America/Guyana|-0345 -03 -04|3J 30 40|012|dzfJ Ey0f|80e4\",\n            \"America/Halifax|AST ADT|40 30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K60 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|39e4\",\n            \"America/Havana|CST CDT|50 40|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K50 1cL0 1cN0 1fz0 1cN0 14n0 1ld0 14L0 1kN0 15b0 1kp0 1cL0 1cN0 1fz0 1a10 1fz0 1fB0 11z0 14p0 1nX0 11B0 1nX0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 1a10 1in0 1a10 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 17c0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 11A0 6i00 Rc0 1wo0 U00 1tA0 Rc0 1wo0 U00 1wo0 U00 1zc0 U00 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0|21e5\",\n            \"America/Hermosillo|PST MST MDT|80 70 60|01212121|80 13Vd0 1lb0 14p0 1lb0 14p0 1lb0|64e4\",\n            \"America/Indiana/Knox|CST CDT EST|60 50 50|01010101010101010101010101010101010101010101210101010101010101010101010101010101010101010101010|K80 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 z8o0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Marengo|EST EDT CDT|50 40 50|010101010201010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1e6p0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Petersburg|CST CDT EST EDT|60 50 50 40|0101010101010101210123232323232323232323232323232323232323232323232|K80 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 19co0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Tell_City|EST EDT CDT CST|50 40 50 60|01023232323232323232323232323232323232323232323232323|K70 1cL0 1qhd0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Vevay|EST EDT|50 40|010101010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1lnd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Vincennes|EST EDT CDT CST|50 40 50 60|01023201010101010101010101010101010101010101010101010|K70 1cL0 1qhd0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Winamac|EST EDT CDT CST|50 40 50 60|01023101010101010101010101010101010101010101010101010|K70 1cL0 1qhd0 1o00 Rd0 1za0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Inuvik|PST PDT MDT MST|80 70 60 70|01010101010101023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323|5Ea0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cK0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|35e2\",\n            \"America/Iqaluit|EST EDT CST CDT|50 40 60 50|01010101010101010101010101010101010101010101010101010101230101010101010101010101010101010101010101010101010101010101010|5E70 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11C0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|67e2\",\n            \"America/Jamaica|EST EDT|50 40|010101010101010101010|9Kv0 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0|94e4\",\n            \"America/Juneau|PST PDT YDT YST AKST AKDT|80 70 80 90 90 80|0101010101010101010102010101345454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cM0 1cM0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|33e3\",\n            \"America/Kentucky/Louisville|EST EDT CDT|50 40 50|010101010201010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Kentucky/Monticello|CST CDT EST EDT|60 50 50 40|010101010101010101010101010101010101010101010101010101010101012323232323232323232323232323232323232323232323232323232323232|K80 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/La_Paz|-04|40|0||19e5\",\n            \"America/Lima|-05 -04|50 40|010101010|CVF0 zX0 1O10 zX0 6Gp0 zX0 98p0 zX0|11e6\",\n            \"America/Los_Angeles|PST PDT|80 70|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e6\",\n            \"America/Maceio|-03 -02|30 20|0101010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 8Q10 WL0 1tB0 5z0 2mN0 On0|93e4\",\n            \"America/Managua|CST EST CDT|60 50 50|010202010102020|86u0 4mn0 9Up0 Dz0 1K10 Dz0 s3F0 1KH0 DB0 9In0 k8p0 19X0 1o30 11y0|22e5\",\n            \"America/Manaus|-04 -03|40 30|010101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0|19e5\",\n            \"America/Martinique|AST ADT|40 30|010|oXg0 19X0|39e4\",\n            \"America/Matamoros|CST CDT|60 50|0101010101010101010101010101010101010101010101010101010101010101010101010|IqU0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|45e4\",\n            \"America/Mazatlan|PST MST MDT|80 70 60|01212121212121212121212121212121212121212121212121212121|80 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|44e4\",\n            \"America/Menominee|EST CDT CST|50 50 60|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|85H0 1cM0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|85e2\",\n            \"America/Merida|CST EST CDT|60 50 50|010202020202020202020202020202020202020202020202020202020|t9G0 2hz0 wu30 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|11e5\",\n            \"America/Metlakatla|PST PDT AKST AKDT|80 70 90 80|0101010101010101010101010101023232302323232323232323232323232|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1hU10 Rd0 1zb0 Op0 1zb0 Op0 1zb0 uM0 jB0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|14e2\",\n            \"America/Mexico_City|CST CDT|60 50|0101010101010101010101010101010101010101010101010101010|13Vk0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|20e6\",\n            \"America/Miquelon|AST -03 -02|40 30 20|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|p9g0 gQ10 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|61e2\",\n            \"America/Moncton|AST ADT|40 30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K60 1cL0 1cN0 1fz0 1cN0 1cL0 3Cp0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14n1 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 ReX 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|64e3\",\n            \"America/Monterrey|CST CDT|60 50|010101010101010101010101010101010101010101010101010101010|IqU0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|41e5\",\n            \"America/Montevideo|-03 -02 -0130 -0230|30 20 1u 2u|0101023010101010101010101010101010101010101010101010|JD0 jX0 4vB0 xz0 3Cp0 mmu 1a10 IMu Db0 4c10 uL0 1Nd0 An0 1SN0 uL0 mp0 28L0 iPB0 un0 1SN0 xz0 1zd0 Lz0 1zd0 Rb0 1zd0 On0 1wp0 Rb0 s8p0 1fB0 1ip0 11z0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 11z0|17e5\",\n            \"America/Toronto|EST EDT|50 40|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e5\",\n            \"America/New_York|EST EDT|50 40|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e6\",\n            \"America/Nome|BST BDT YST AKST AKDT|b0 a0 90 90 80|0101010101010101010101010101234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|Kd0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cl0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|38e2\",\n            \"America/Noronha|-02 -01|20 10|01010101010101010|CxC0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|30e2\",\n            \"America/North_Dakota/Beulah|MST MDT CST CDT|70 60 60 50|010101010101010101010101010101010101010101010101010101010101010101010101010101010123232323232323232323232323232323232323232|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/North_Dakota/Center|MST MDT CST CDT|70 60 60 50|010101010101010101010101010101010101010101010123232323232323232323232323232323232323232323232323232323232323232323232323232|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/North_Dakota/New_Salem|MST MDT CST CDT|70 60 60 50|010101010101010101010101010101010101010101010101010101010101010101012323232323232323232323232323232323232323232323232323232|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Ojinaga|CST CDT MDT MST|60 50 60 70|01010232323232323232323232323232323232323232323232323201010101010101010|13Vk0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1wn0 Rc0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e3\",\n            \"America/Paramaribo|-0330 -03|3u 30|01|zSPu|24e4\",\n            \"America/Port-au-Prince|EST EDT|50 40|01010101010101010101010101010101010101010101010101010101010101010101010|wu50 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14q0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 i6n0 1nX0 11B0 1nX0 d430 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 3iN0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\n            \"America/Rio_Branco|-05 -04|50 40|010101010|CxF0 Rb0 1tB0 IL0 1Fd0 FX0 NBd0 d5X0|31e4\",\n            \"America/Porto_Velho|-04 -03|40 30|0101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0|37e4\",\n            \"America/Punta_Arenas|-03 -04|30 40|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|yP0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0|\",\n            \"America/Winnipeg|CST CDT|60 50|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K80 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|66e4\",\n            \"America/Rankin_Inlet|CST CDT EST|60 50 50|01010101010101010101010101010101010101010101010101010101012101010101010101010101010101010101010101010101010101010101010|5E80 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e2\",\n            \"America/Recife|-03 -02|30 20|01010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|33e5\",\n            \"America/Regina|CST|60|0||19e4\",\n            \"America/Resolute|CST CDT EST|60 50 50|01010101010101010101010101010101010101010101010101010101012101010101012101010101010101010101010101010101010101010101010|5E80 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|229\",\n            \"America/Santarem|-04 -03|40 30|01010101|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 NBd0|21e4\",\n            \"America/Santiago|-03 -04|30 40|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|yP0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1zb0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0|62e5\",\n            \"America/Santo_Domingo|-0430 EST AST|4u 50 40|0101010101212|ksu 1Cou yLu 1RAu wLu 1QMu xzu 1Q0u xXu 1PAu 13jB0 e00|29e5\",\n            \"America/Sao_Paulo|-03 -02|30 20|010101010101010101010101010101010101010101010101010101010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1HB0 FX0|20e6\",\n            \"America/Scoresbysund|-02 -01 +00|20 10 0|0102121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|oXg0 1a00 1cK0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|452\",\n            \"America/Sitka|PST PDT YST AKST AKDT|80 70 90 90 80|0101010101010101010101010101234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|90e2\",\n            \"America/St_Johns|NST NDT NDDT|3u 2u 1u|010101010101010101010101010101010101020101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K5u 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|11e4\",\n            \"America/Swift_Current|MST CST|70 60|01|5E90|16e3\",\n            \"America/Tegucigalpa|CST CDT|60 50|0101010|Gcu0 WL0 1qN0 WL0 GRd0 AL0|11e5\",\n            \"America/Thule|AST ADT|40 30|010101010101010101010101010101010101010101010101010101010101010101010101010101010|PHG0 1cL0 1cN0 1cL0 1fB0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|656\",\n            \"America/Vancouver|PST PDT|80 70|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\n            \"America/Whitehorse|PST PDT MST|80 70 70|01010101010101010101010101010101010101010101010101010101010101010101010101010101012|p7K0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1z90|23e3\",\n            \"America/Yakutat|YST YDT AKST AKDT|90 80 90 80|0101010101010101010101010101023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|Kb0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cn0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|642\",\n            \"Antarctica/Casey|+08 +11|-80 -b0|010101010101|1ARS0 T90 40P0 KL0 blz0 3m10 1o30 14k0 1kr0 12l0 1o01|10\",\n            \"Antarctica/Davis|+07 +05|-70 -50|01010|1ART0 VB0 3Wn0 KN0|70\",\n            \"Pacific/Port_Moresby|+10|-a0|0||25e4\",\n            \"Antarctica/Macquarie|AEDT AEST|-b0 -a0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|qg0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 3Co0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|1\",\n            \"Antarctica/Mawson|+06 +05|-60 -50|01|1ARU0|60\",\n            \"Pacific/Auckland|NZST NZDT|-c0 -d0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|bKC0 IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00|14e5\",\n            \"Antarctica/Palmer|-03 -02 -04|30 20 40|01020202020202020202020202020202020202020202020202020202020202020202020|9Rf0 Db0 jsN0 14N0 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0|40\",\n            \"Antarctica/Rothera|-00 -03|0 30|01|gOo0|130\",\n            \"Asia/Riyadh|+03|-30|0||57e5\",\n            \"Antarctica/Troll|-00 +00 +02|0 0 -20|012121212121212121212121212121212121212121212121212121|1puo0 hd0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|40\",\n            \"Asia/Urumqi|+06|-60|0||32e5\",\n            \"Europe/Berlin|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|oXd0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|41e5\",\n            \"Asia/Almaty|+06 +07 +05|-60 -70 -50|0101010101010101010102010101010101010101010101010|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|15e5\",\n            \"Asia/Amman|EET EEST +03|-20 -30 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101012|8kK0 KL0 1oN0 11b0 1oN0 11b0 1pd0 1dz0 1cp0 11b0 1op0 11b0 fO10 1db0 1e10 1cL0 1cN0 1cL0 1cN0 1fz0 1pd0 10n0 1ld0 14n0 1hB0 15b0 1ip0 19X0 1cN0 1cL0 1cN0 17b0 1ld0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1So0 y00 1fc0 1dc0 1co0 1dc0 1cM0 1cM0 1cM0 1o00 11A0 1lc0 17c0 1cM0 1cM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 4bX0 Dd0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 LA0 1C00|25e5\",\n            \"Asia/Anadyr|+13 +14 +12 +11|-d0 -e0 -c0 -b0|010202020202020202023202020202020202020202020202020202020232|rmX0 1db0 2q10 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|13e3\",\n            \"Asia/Aqtau|+05 +06 +04|-50 -60 -40|0101010101010101010201010120202020202020202020|sAj0 2pX0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|15e4\",\n            \"Asia/Aqtobe|+05 +06 +04|-50 -60 -40|01010101010101010102010101010101010101010101010|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|27e4\",\n            \"Asia/Ashgabat|+05 +06 +04|-50 -60 -40|01010101010101010101020|rn70 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0|41e4\",\n            \"Asia/Atyrau|+05 +06 +04|-50 -60 -40|010101010101010101020101010101010102020202020|sAj0 2pX0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 2sp0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|\",\n            \"Asia/Baghdad|+03 +04|-30 -40|01010101010101010101010101010101010101010101010101010|u190 11b0 1cp0 1dz0 1dd0 1db0 1cN0 1cp0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1de0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0|66e5\",\n            \"Asia/Qatar|+04 +03|-40 -30|01|5QI0|96e4\",\n            \"Asia/Baku|+04 +05 +03|-40 -50 -30|010101010101010101010201010101010101010101010101010101010101010|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 1cM0 9Je0 1o00 11z0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00|27e5\",\n            \"Asia/Bangkok|+07|-70|0||15e6\",\n            \"Asia/Barnaul|+07 +08 +06|-70 -80 -60|01010101010101010101020101010102020202020202020202020202020202020|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 p90 LE0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|\",\n            \"Asia/Beirut|EET EEST|-20 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|61a0 En0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1op0 11b0 dA10 17b0 1iN0 17b0 1iN0 17b0 1iN0 17b0 1vB0 SL0 1mp0 13z0 1iN0 17b0 1iN0 17b0 1jd0 12n0 1a10 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0|22e5\",\n            \"Asia/Bishkek|+06 +07 +05|-60 -70 -50|0101010101010101010102020202020202020202020202020|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2e00 1tX0 17b0 1ip0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1cPu 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0|87e4\",\n            \"Asia/Brunei|+08|-80|0||42e4\",\n            \"Asia/Kolkata|IST|-5u|0||15e6\",\n            \"Asia/Chita|+09 +10 +08|-90 -a0 -80|0101010101010101010102010101010101010101010101010101010101010120|rn30 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3re0|33e4\",\n            \"Asia/Choibalsan|+07 +08 +10 +09|-70 -80 -a0 -90|012323232323232323232323232323232323232323232313131|jsF0 cKn0 1da0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 3Db0 h1f0 1cJ0 1cP0 1cJ0|38e3\",\n            \"Asia/Shanghai|CST CDT|-80 -90|0101010101010|DKG0 Rb0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0|23e6\",\n            \"Asia/Colombo|+0530 +0630 +06|-5u -6u -60|0120|14giu 11zu n3cu|22e5\",\n            \"Asia/Dhaka|+06 +07|-60 -70|010|1A5R0 1i00|16e6\",\n            \"Asia/Damascus|EET EEST +03|-20 -30 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101012|M00 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 Nb0 1AN0 Nb0 bcp0 19X0 1gp0 19X0 3ld0 1xX0 Vd0 1Bz0 Sp0 1vX0 10p0 1dz0 1cN0 1cL0 1db0 1db0 1g10 1an0 1ap0 1db0 1fd0 1db0 1cN0 1db0 1dd0 1db0 1cp0 1dz0 1c10 1dX0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 19z0 1fB0 1qL0 11B0 1on0 Wp0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0|26e5\",\n            \"Asia/Dili|+09 +08|-90 -80|010|fpr0 Xld0|19e4\",\n            \"Asia/Dubai|+04|-40|0||39e5\",\n            \"Asia/Dushanbe|+06 +07 +05|-60 -70 -50|0101010101010101010102|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2hB0|76e4\",\n            \"Asia/Famagusta|EET EEST +03|-20 -30 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101012010101010101010101010101010|cPa0 1cL0 1qp0 Xz0 19B0 19X0 1fB0 1db0 1cp0 1cL0 1fB0 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1o30 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 15U0 2Ks0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|\",\n            \"Asia/Gaza|IST IDT EET EEST|-20 -30 -20 -30|010101010101010101010101010101023232323232323232323232323232323232323232323232323232323232323232323232|aXa0 Db0 1fB0 Rb0 bXB0 gM0 8Q00 IM0 1wo0 TX0 1HB0 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 11z0 1o10 14o0 1lA1 SKX 1xd1 MKX 1AN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nA0 1210 1qL0 WN0 1qL0 WN0 1qL0 11c0 1on0 11B0 1o00 11A0 1qo0 XA0 1qp0 1cN0 1cL0 17d0 1in0 14p0 1lb0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0|18e5\",\n            \"Asia/Hebron|IST IDT EET EEST|-20 -30 -20 -30|01010101010101010101010101010102323232323232323232323232323232323232323232323232323232323232323232323232|aXa0 Db0 1fB0 Rb0 bXB0 gM0 8Q00 IM0 1wo0 TX0 1HB0 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 12L0 1mN0 14o0 1lc0 Tb0 1xd1 MKX bB0 cn0 1cN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nA0 1210 1qL0 WN0 1qL0 WN0 1qL0 11c0 1on0 11B0 1o00 11A0 1qo0 XA0 1qp0 1cN0 1cL0 17d0 1in0 14p0 1lb0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0|25e4\",\n            \"Asia/Ho_Chi_Minh|+08 +07|-80 -70|01|dfs0|90e5\",\n            \"Asia/Hong_Kong|HKT HKST|-80 -90|01010101010101010|H7u 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1cL0 6fd0 14n0|73e5\",\n            \"Asia/Hovd|+06 +07 +08|-60 -70 -80|01212121212121212121212121212121212121212121212121|jsG0 cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0|81e3\",\n            \"Asia/Irkutsk|+08 +09 +07|-80 -90 -70|010101010101010101010201010101010101010101010101010101010101010|rn40 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\n            \"Europe/Istanbul|EET EEST +03 +04|-20 -30 -30 -40|01010101010123201010101010101010101010101010101010101010101010101010101010101012|8jz0 11A0 WN0 1qL0 TB0 1tX0 U10 1tz0 11B0 1in0 17d0 z90 cne0 pb0 2Cp0 1800 14o0 1dc0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1a00 1fA0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WO0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 Xc0 1qo0 WM0 1qM0 11A0 1o00 1200 1nA0 11A0 1tA0 U00 15w0|13e6\",\n            \"Asia/Jakarta|WIB|-70|0||31e6\",\n            \"Asia/Jayapura|WIT|-90|0||26e4\",\n            \"Asia/Jerusalem|IST IDT|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|aXa0 Db0 1fB0 Rb0 bXB0 gM0 8Q00 IM0 1wo0 TX0 1HB0 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 1hB0 1dX0 1ep0 1aL0 1eN0 17X0 1nf0 11z0 1tB0 19W0 1e10 17b0 1ep0 1gL0 18N0 1fz0 1eN0 17b0 1gq0 1gn0 19d0 1dz0 1c10 17X0 1hB0 1gn0 19d0 1dz0 1c10 17X0 1kp0 1dz0 1c10 1aL0 1eN0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0|81e4\",\n            \"Asia/Kabul|+0430|-4u|0||46e5\",\n            \"Asia/Kamchatka|+12 +13 +11|-c0 -d0 -b0|0101010101010101010102010101010101010101010101010101010101020|rn00 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|18e4\",\n            \"Asia/Karachi|+05 PKT PKST|-50 -50 -60|01212121|2Xv0 1fy00 1cL0 dK10 11b0 1610 1jX0|24e6\",\n            \"Asia/Kathmandu|+0530 +0545|-5u -5J|01|CVuu|12e5\",\n            \"Asia/Khandyga|+09 +10 +08 +11|-90 -a0 -80 -b0|01010101010101010101020101010101010101010101010131313131313131310|rn30 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 qK0 yN0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|66e2\",\n            \"Asia/Krasnoyarsk|+07 +08 +06|-70 -80 -60|010101010101010101010201010101010101010101010101010101010101010|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|10e5\",\n            \"Asia/Kuala_Lumpur|+0730 +08|-7u -80|01|td40|71e5\",\n            \"Asia/Macau|CST CDT|-80 -90|01010101010101010|H7u 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1cL0 6fd0 14n0|57e4\",\n            \"Asia/Magadan|+11 +12 +10|-b0 -c0 -a0|0101010101010101010102010101010101010101010101010101010101010120|rn10 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Cq0|95e3\",\n            \"Asia/Makassar|WITA|-80|0||15e5\",\n            \"Asia/Manila|PST PDT|-80 -90|010|k0E0 1db0|24e6\",\n            \"Asia/Nicosia|EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|cPa0 1cL0 1qp0 Xz0 19B0 19X0 1fB0 1db0 1cp0 1cL0 1fB0 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1o30 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|32e4\",\n            \"Asia/Novokuznetsk|+07 +08 +06|-70 -80 -60|0101010101010101010102010101010101010101010101010101010101020|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|55e4\",\n            \"Asia/Novosibirsk|+07 +08 +06|-70 -80 -60|01010101010101010101020101020202020202020202020202020202020202020|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 ml0 Os0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 4eN0|15e5\",\n            \"Asia/Omsk|+06 +07 +05|-60 -70 -50|010101010101010101010201010101010101010101010101010101010101010|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|12e5\",\n            \"Asia/Oral|+05 +06 +04|-50 -60 -40|010101010101010202020202020202020202020202020|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 1cM0 IM0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|27e4\",\n            \"Asia/Pontianak|WITA WIB|-80 -70|01|HNs0|23e4\",\n            \"Asia/Pyongyang|KST KST|-90 -8u|010|1P4D0 6BA0|29e5\",\n            \"Asia/Qostanay|+05 +06 +04|-50 -60 -40|0101010101010101010201010101010101010101010101|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|\",\n            \"Asia/Qyzylorda|+05 +06|-50 -60|010101010101010101010101010101010101010101010|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 3ao0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 zQl0|73e4\",\n            \"Asia/Rangoon|+0630|-6u|0||48e5\",\n            \"Asia/Sakhalin|+11 +12 +10|-b0 -c0 -a0|010101010101010101010201010101010202020202020202020202020202020|rn10 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 2pB0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|58e4\",\n            \"Asia/Samarkand|+05 +06|-50 -60|010101010101010101010|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|36e4\",\n            \"Asia/Seoul|KST KDT|-90 -a0|01010|Gf50 11A0 1o00 11A0|23e6\",\n            \"Asia/Srednekolymsk|+11 +12 +10|-b0 -c0 -a0|010101010101010101010201010101010101010101010101010101010101010|rn10 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|35e2\",\n            \"Asia/Taipei|CST CDT|-80 -90|0101010|akg0 1db0 1cN0 1db0 97B0 AL0|74e5\",\n            \"Asia/Tashkent|+06 +07 +05|-60 -70 -50|0101010101010101010102|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0|23e5\",\n            \"Asia/Tbilisi|+04 +05 +03|-40 -50 -30|01010101010101010101020202010101010101010101020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 1cK0 1cL0 1cN0 1cL0 1cN0 2pz0 1cL0 1fB0 3Nz0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 An0 Os0 WM0|11e5\",\n            \"Asia/Tehran|+0330 +0430 +04 +05|-3u -4u -40 -50|0123201010101010101010101010101010101010101010101010101010101010101010|hyHu 1pc0 120u Rc0 XA0 Wou JX0 1dB0 1en0 pNB0 UL0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 64p0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0|14e6\",\n            \"Asia/Thimphu|+0530 +06|-5u -60|01|HcGu|79e3\",\n            \"Asia/Tokyo|JST|-90|0||38e6\",\n            \"Asia/Tomsk|+07 +08 +06|-70 -80 -60|01010101010101010101020101010101010101010101020202020202020202020|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 co0 1bB0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Qp0|10e5\",\n            \"Asia/Ulaanbaatar|+07 +08 +09|-70 -80 -90|01212121212121212121212121212121212121212121212121|jsF0 cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0|12e5\",\n            \"Asia/Ust-Nera|+09 +12 +11 +10|-90 -c0 -b0 -a0|0121212121212121212123212121212121212121212121212121212121212123|rn30 1d90 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|65e2\",\n            \"Asia/Vladivostok|+10 +11 +09|-a0 -b0 -90|010101010101010101010201010101010101010101010101010101010101010|rn20 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\n            \"Asia/Yakutsk|+09 +10 +08|-90 -a0 -80|010101010101010101010201010101010101010101010101010101010101010|rn30 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|28e4\",\n            \"Asia/Yekaterinburg|+05 +06 +04|-50 -60 -40|010101010101010101010201010101010101010101010101010101010101010|rn70 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|14e5\",\n            \"Asia/Yerevan|+04 +05 +03|-40 -50 -30|01010101010101010101020202020101010101010101010101010101010|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 4RX0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0|13e5\",\n            \"Atlantic/Azores|-01 +00 WET|10 0 0|0101010101010101010101010101010121010101010101010101010101010101010101010101010101010101010101010101010101010|hAN0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|25e4\",\n            \"Atlantic/Bermuda|AST ADT|40 30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|avi0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e3\",\n            \"Atlantic/Canary|WET WEST|0 -10|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|oXc0 1a10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|54e4\",\n            \"Atlantic/Cape_Verde|-02 -01|20 10|01|elE0|50e4\",\n            \"Atlantic/Faroe|WET WEST|0 -10|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|rm10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|49e3\",\n            \"Atlantic/Madeira|WET WEST|0 -10|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hAM0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|27e4\",\n            \"Atlantic/South_Georgia|-02|20|0||30\",\n            \"Atlantic/Stanley|-04 -03 -02|40 30 20|01212101010101010101010101010101010101010101010101010101|wrg0 WL0 1qL0 U10 1tz0 2mN0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 U10 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qN0 U10 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1wn0 U10 1tz0 U10 1tz0 U10|21e2\",\n            \"Australia/Sydney|AEST AEDT|-a0 -b0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4r40 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|40e5\",\n            \"Australia/Adelaide|ACST ACDT|-9u -au|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4r4u LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 WM0 1qM0 Rc0 1zc0 U00 1tA0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|11e5\",\n            \"Australia/Brisbane|AEST AEDT|-a0 -b0|010101010|4r40 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0|20e5\",\n            \"Australia/Broken_Hill|ACST ACDT|-9u -au|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4r4u LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|18e3\",\n            \"Australia/Hobart|AEDT AEST|-b0 -a0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|qg0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|21e4\",\n            \"Australia/Darwin|ACST|-9u|0||12e4\",\n            \"Australia/Eucla|+0845 +0945|-8J -9J|0101010101010|bHRf Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|368\",\n            \"Australia/Lord_Howe|AEST +1030 +1130 +11|-a0 -au -bu -b0|01212121213131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313|raC0 1zdu Rb0 1zd0 On0 1zd0 On0 1zd0 On0 1zd0 TXu 1qMu WLu 1tAu WLu 1tAu TXu 1tAu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu 11zu 1o0u 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 11Au 1nXu 1qMu 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 1qMu 11zu 1o0u WLu 1qMu 14nu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1fzu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu|347\",\n            \"Australia/Lindeman|AEST AEDT|-a0 -b0|0101010101010|4r40 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0|10\",\n            \"Australia/Melbourne|AEST AEDT|-a0 -b0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4r40 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1qM0 11A0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|39e5\",\n            \"Australia/Perth|AWST AWDT|-80 -90|0101010101010|bHS0 Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|18e5\",\n            \"Europe/Brussels|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|21e5\",\n            \"Pacific/Easter|-06 -07 -05|60 70 50|010101010101010101010101020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202|yP0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 2pA0 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1zb0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0|30e2\",\n            \"EET|EET EEST|-20 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|\",\n            \"Europe/Dublin|IST GMT|-10 0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4re0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|12e5\",\n            \"Etc/GMT-1|+01|-10|0||\",\n            \"Pacific/Guadalcanal|+11|-b0|0||11e4\",\n            \"Pacific/Tarawa|+12|-c0|0||29e3\",\n            \"Etc/GMT-13|+13|-d0|0||\",\n            \"Etc/GMT-14|+14|-e0|0||\",\n            \"Etc/GMT-2|+02|-20|0||\",\n            \"Indian/Maldives|+05|-50|0||35e4\",\n            \"Pacific/Palau|+09|-90|0||21e3\",\n            \"Etc/GMT+1|-01|10|0||\",\n            \"Pacific/Tahiti|-10|a0|0||18e4\",\n            \"Pacific/Niue|-11|b0|0||12e2\",\n            \"Etc/GMT+12|-12|c0|0||\",\n            \"Etc/GMT+5|-05|50|0||\",\n            \"Etc/GMT+6|-06|60|0||\",\n            \"Etc/GMT+7|-07|70|0||\",\n            \"Etc/GMT+8|-08|80|0||\",\n            \"Pacific/Gambier|-09|90|0||125\",\n            \"Etc/UTC|UTC|0|0||\",\n            \"Europe/Andorra|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|B7d0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|79e3\",\n            \"Europe/Astrakhan|+04 +05 +03|-40 -50 -30|0101010101010101020202020202020202020202020202020202020202020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|10e5\",\n            \"Europe/Athens|EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|cOK0 1vc0 SO0 1cM0 1a00 1ao0 1fc0 1a10 1fG0 1cg0 1dX0 1bX0 1cQ0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|35e5\",\n            \"Europe/London|BST GMT|-10 0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4re0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|10e6\",\n            \"Europe/Belgrade|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|wdd0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|12e5\",\n            \"Europe/Prague|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|muN0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|13e5\",\n            \"Europe/Bucharest|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|mRa0 On0 1fA0 1a10 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|19e5\",\n            \"Europe/Budapest|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|oXb0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cO0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|17e5\",\n            \"Europe/Zurich|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|rm10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|38e4\",\n            \"Europe/Chisinau|MSK MSD EEST EET|-30 -40 -30 -20|010101010101010101012323232323232323232323232323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 gL0 WO0 1cM0 1cM0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11D0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|67e4\",\n            \"Europe/Gibraltar|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|tLB0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|30e3\",\n            \"Europe/Helsinki|EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|rm00 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|12e5\",\n            \"Europe/Kaliningrad|MSK MSD EEST EET +03|-30 -40 -30 -20 -30|010101010101010102323232323232323232323232323232323232323232343|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|44e4\",\n            \"Europe/Kiev|MSK MSD EEST EET|-30 -40 -30 -20|0101010101010101010123232323232323232323232323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 Db0 3220 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o10 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|34e5\",\n            \"Europe/Kirov|+04 +05 MSD MSK MSK|-40 -50 -40 -30 -40|01010101010101010232302323232323232323232323232323232323232343|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 2pz0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|48e4\",\n            \"Europe/Lisbon|CET WET WEST CEST|-10 0 -10 -20|01212121212121212121212121212121203030302121212121212121212121212121212121212121212121212121212121212121212121|go00 1cM0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|27e5\",\n            \"Europe/Madrid|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|apy0 1a10 1fz0 1a10 19X0 1cN0 1fz0 1a10 1fC0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|62e5\",\n            \"Europe/Malta|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|XX0 LA0 1zc0 Oo0 1C00 Oo0 1co0 1cM0 1lA0 Xc0 1qq0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1iN0 19z0 1fB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|42e4\",\n            \"Europe/Minsk|MSK MSD EEST EET +03|-30 -40 -30 -20 -30|010101010101010101023232323232323232323232323232323232323234|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 3Fc0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0|19e5\",\n            \"Europe/Paris|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|fbc0 1cL0 1fC0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|11e6\",\n            \"Europe/Moscow|MSK MSD EEST EET MSK|-30 -40 -30 -20 -40|0101010101010101010102301010101010101010101010101010101010101040|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|16e6\",\n            \"Europe/Riga|MSK MSD EEST EET|-30 -40 -30 -20|010101010101010102323232323232323232323232323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 1o00 11A0 1o00 11A0 1qM0 3oo0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|64e4\",\n            \"Europe/Rome|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|XX0 LA0 1zc0 Oo0 1C00 Oo0 1C00 LA0 1zc0 Oo0 1C00 LA0 1C00 LA0 1zc0 Oo0 1C00 Oo0 1zc0 Oo0 1fC0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|39e5\",\n            \"Europe/Samara|+04 +05 +03|-40 -50 -30|01010101010101010202010101010101010101010101010101010101020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 2y10 14m0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|12e5\",\n            \"Europe/Saratov|+04 +05 +03|-40 -50 -30|0101010101010102020202020202020202020202020202020202020202020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1cM0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 5810|\",\n            \"Europe/Simferopol|MSK MSD EET EEST MSK|-30 -40 -20 -30 -40|0101010101010101010232323101010323232323232323232323232323232323240|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Q00 4eN0 1cM0 1cM0 1cM0 1cM0 dV0 WO0 1cM0 1cM0 1fy0 1o30 11B0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11z0 1nW0|33e4\",\n            \"Europe/Sofia|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|muJ0 1dd0 1fb0 1ap0 1fb0 1a20 1fy0 1a30 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|12e5\",\n            \"Europe/Tallinn|MSK MSD EEST EET|-30 -40 -30 -20|0101010101010101023232323232323232323232323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o10 11A0 1qM0 5QM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|41e4\",\n            \"Europe/Tirane|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|axz0 10n0 1op0 11z0 1pd0 11z0 1qN0 WL0 1qp0 Xb0 1qp0 Xb0 1qp0 11z0 1lB0 11z0 1qN0 11z0 1iN0 16n0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|42e4\",\n            \"Europe/Ulyanovsk|+04 +05 +03 +02|-40 -50 -30 -20|010101010101010102023202020202020202020202020202020202020202020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|13e5\",\n            \"Europe/Vienna|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|oXb0 19X0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|18e5\",\n            \"Europe/Vilnius|MSK MSD EEST EET CEST CET|-30 -40 -30 -20 -20 -10|01010101010101010232323232323232323454323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11B0 1o00 11A0 1qM0 8io0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|54e4\",\n            \"Europe/Volgograd|+04 +05 MSD MSK MSK|-40 -50 -40 -30 -40|0101010101010102323230232323232323232323232323232323232323234303|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1fA0 1cM0 2pz0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 9Jd0 5gn0|10e5\",\n            \"Europe/Warsaw|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDA0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|17e5\",\n            \"Pacific/Honolulu|HST|a0|0||37e4\",\n            \"Indian/Chagos|+05 +06|-50 -60|01|13ij0|30e2\",\n            \"Indian/Mauritius|+04 +05|-40 -50|01010|v5U0 14L0 12kr0 11z0|15e4\",\n            \"Pacific/Kwajalein|-12 +12|c0 -c0|01|Vxo0|14e3\",\n            \"MET|MET MEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|\",\n            \"Pacific/Chatham|+1245 +1345|-cJ -dJ|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|bKC0 IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00|600\",\n            \"Pacific/Apia|-11 -10 +14 +13|b0 a0 -e0 -d0|010123232323232323232323|1Dbn0 1ff0 1a00 CI0 AQ0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0|37e3\",\n            \"Pacific/Bougainville|+10 +11|-a0 -b0|01|1NwE0|18e4\",\n            \"Pacific/Efate|+11 +12|-b0 -c0|01010101010101010101010|9EA0 Dc0 n610 1cL0 1cN0 1cL0 1fB0 19X0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 Lz0 1Nd0 An0|66e3\",\n            \"Pacific/Enderbury|-12 -11 +13|c0 b0 -d0|012|nIc0 B7X0|1\",\n            \"Pacific/Fakaofo|-11 +13|b0 -d0|01|1Gfn0|483\",\n            \"Pacific/Fiji|+12 +13|-c0 -d0|01010101010101010101010101010|1ace0 LA0 1EM0 IM0 nJc0 LA0 1o00 Rc0 1wo0 Ao0 1Nc0 Ao0 1Q00 xz0 1SN0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 s00 20o0 pc0 2hc0 bc0|88e4\",\n            \"Pacific/Galapagos|-05 -06|50 60|0101|CVF0 gNd0 rz0|25e3\",\n            \"Pacific/Guam|GST GDT ChST|-a0 -b0 -a0|010101010102|JQ0 Rb0 1wp0 Rb0 5xd0 rX0 5sN0 zb1 1C0X On0 ULb0|17e4\",\n            \"Pacific/Kiritimati|-1040 -10 +14|aE a0 -e0|012|nIaE B7Xk|51e2\",\n            \"Pacific/Kosrae|+12 +11|-c0 -b0|01|1aAA0|66e2\",\n            \"Pacific/Marquesas|-0930|9u|0||86e2\",\n            \"Pacific/Pago_Pago|SST|b0|0||37e2\",\n            \"Pacific/Nauru|+1130 +12|-bu -c0|01|maCu|10e3\",\n            \"Pacific/Norfolk|+1130 +1230 +11 +12|-bu -cu -b0 -c0|010232323232323232323232323|bHOu Oo0 1COo0 9Jcu 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|25e4\",\n            \"Pacific/Noumea|+11 +12|-b0 -c0|0101010|jhp0 xX0 1PB0 yn0 HeP0 Ao0|98e3\",\n            \"Pacific/Pitcairn|-0830 -08|8u 80|01|18Vku|56\",\n            \"Pacific/Rarotonga|-1030 -0930 -10|au 9u a0|012121212121212121212121212|lyWu IL0 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu|13e3\",\n            \"Pacific/Tongatapu|+13 +14|-d0 -e0|010101010|1csd0 15A0 1wo0 xz0 1Q10 xz0 zWN0 s00|75e3\",\n            \"WET|WET WEST|0 -10|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|\"\n        ],\n        \"links\": [\n            \"Africa/Abidjan|Africa/Accra\",\n            \"Africa/Abidjan|Africa/Bamako\",\n            \"Africa/Abidjan|Africa/Banjul\",\n            \"Africa/Abidjan|Africa/Conakry\",\n            \"Africa/Abidjan|Africa/Dakar\",\n            \"Africa/Abidjan|Africa/Freetown\",\n            \"Africa/Abidjan|Africa/Lome\",\n            \"Africa/Abidjan|Africa/Nouakchott\",\n            \"Africa/Abidjan|Africa/Ouagadougou\",\n            \"Africa/Abidjan|Africa/Timbuktu\",\n            \"Africa/Abidjan|Atlantic/Reykjavik\",\n            \"Africa/Abidjan|Atlantic/St_Helena\",\n            \"Africa/Abidjan|Etc/GMT\",\n            \"Africa/Abidjan|Etc/GMT+0\",\n            \"Africa/Abidjan|Etc/GMT-0\",\n            \"Africa/Abidjan|Etc/GMT0\",\n            \"Africa/Abidjan|Etc/Greenwich\",\n            \"Africa/Abidjan|GMT\",\n            \"Africa/Abidjan|GMT+0\",\n            \"Africa/Abidjan|GMT-0\",\n            \"Africa/Abidjan|GMT0\",\n            \"Africa/Abidjan|Greenwich\",\n            \"Africa/Abidjan|Iceland\",\n            \"Africa/Cairo|Egypt\",\n            \"Africa/Johannesburg|Africa/Maseru\",\n            \"Africa/Johannesburg|Africa/Mbabane\",\n            \"Africa/Lagos|Africa/Bangui\",\n            \"Africa/Lagos|Africa/Brazzaville\",\n            \"Africa/Lagos|Africa/Douala\",\n            \"Africa/Lagos|Africa/Kinshasa\",\n            \"Africa/Lagos|Africa/Libreville\",\n            \"Africa/Lagos|Africa/Luanda\",\n            \"Africa/Lagos|Africa/Malabo\",\n            \"Africa/Lagos|Africa/Niamey\",\n            \"Africa/Lagos|Africa/Porto-Novo\",\n            \"Africa/Maputo|Africa/Blantyre\",\n            \"Africa/Maputo|Africa/Bujumbura\",\n            \"Africa/Maputo|Africa/Gaborone\",\n            \"Africa/Maputo|Africa/Harare\",\n            \"Africa/Maputo|Africa/Kigali\",\n            \"Africa/Maputo|Africa/Lubumbashi\",\n            \"Africa/Maputo|Africa/Lusaka\",\n            \"Africa/Nairobi|Africa/Addis_Ababa\",\n            \"Africa/Nairobi|Africa/Asmara\",\n            \"Africa/Nairobi|Africa/Asmera\",\n            \"Africa/Nairobi|Africa/Dar_es_Salaam\",\n            \"Africa/Nairobi|Africa/Djibouti\",\n            \"Africa/Nairobi|Africa/Kampala\",\n            \"Africa/Nairobi|Africa/Mogadishu\",\n            \"Africa/Nairobi|Indian/Antananarivo\",\n            \"Africa/Nairobi|Indian/Comoro\",\n            \"Africa/Nairobi|Indian/Mayotte\",\n            \"Africa/Tripoli|Libya\",\n            \"America/Adak|America/Atka\",\n            \"America/Adak|US/Aleutian\",\n            \"America/Anchorage|US/Alaska\",\n            \"America/Argentina/Buenos_Aires|America/Buenos_Aires\",\n            \"America/Argentina/Catamarca|America/Argentina/ComodRivadavia\",\n            \"America/Argentina/Catamarca|America/Catamarca\",\n            \"America/Argentina/Cordoba|America/Cordoba\",\n            \"America/Argentina/Cordoba|America/Rosario\",\n            \"America/Argentina/Jujuy|America/Jujuy\",\n            \"America/Argentina/Mendoza|America/Mendoza\",\n            \"America/Cayenne|Etc/GMT+3\",\n            \"America/Chicago|CST6CDT\",\n            \"America/Chicago|US/Central\",\n            \"America/Denver|America/Shiprock\",\n            \"America/Denver|MST7MDT\",\n            \"America/Denver|Navajo\",\n            \"America/Denver|US/Mountain\",\n            \"America/Detroit|US/Michigan\",\n            \"America/Edmonton|America/Yellowknife\",\n            \"America/Edmonton|Canada/Mountain\",\n            \"America/Fort_Wayne|America/Indiana/Indianapolis\",\n            \"America/Fort_Wayne|America/Indianapolis\",\n            \"America/Fort_Wayne|US/East-Indiana\",\n            \"America/Godthab|America/Nuuk\",\n            \"America/Halifax|Canada/Atlantic\",\n            \"America/Havana|Cuba\",\n            \"America/Indiana/Knox|America/Knox_IN\",\n            \"America/Indiana/Knox|US/Indiana-Starke\",\n            \"America/Iqaluit|America/Pangnirtung\",\n            \"America/Jamaica|Jamaica\",\n            \"America/Kentucky/Louisville|America/Louisville\",\n            \"America/La_Paz|Etc/GMT+4\",\n            \"America/Los_Angeles|PST8PDT\",\n            \"America/Los_Angeles|US/Pacific\",\n            \"America/Manaus|Brazil/West\",\n            \"America/Mazatlan|Mexico/BajaSur\",\n            \"America/Mexico_City|Mexico/General\",\n            \"America/New_York|EST5EDT\",\n            \"America/New_York|US/Eastern\",\n            \"America/Noronha|Brazil/DeNoronha\",\n            \"America/Panama|America/Atikokan\",\n            \"America/Panama|America/Cayman\",\n            \"America/Panama|America/Coral_Harbour\",\n            \"America/Panama|EST\",\n            \"America/Phoenix|America/Creston\",\n            \"America/Phoenix|MST\",\n            \"America/Phoenix|US/Arizona\",\n            \"America/Puerto_Rico|America/Anguilla\",\n            \"America/Puerto_Rico|America/Antigua\",\n            \"America/Puerto_Rico|America/Aruba\",\n            \"America/Puerto_Rico|America/Blanc-Sablon\",\n            \"America/Puerto_Rico|America/Curacao\",\n            \"America/Puerto_Rico|America/Dominica\",\n            \"America/Puerto_Rico|America/Grenada\",\n            \"America/Puerto_Rico|America/Guadeloupe\",\n            \"America/Puerto_Rico|America/Kralendijk\",\n            \"America/Puerto_Rico|America/Lower_Princes\",\n            \"America/Puerto_Rico|America/Marigot\",\n            \"America/Puerto_Rico|America/Montserrat\",\n            \"America/Puerto_Rico|America/Port_of_Spain\",\n            \"America/Puerto_Rico|America/St_Barthelemy\",\n            \"America/Puerto_Rico|America/St_Kitts\",\n            \"America/Puerto_Rico|America/St_Lucia\",\n            \"America/Puerto_Rico|America/St_Thomas\",\n            \"America/Puerto_Rico|America/St_Vincent\",\n            \"America/Puerto_Rico|America/Tortola\",\n            \"America/Puerto_Rico|America/Virgin\",\n            \"America/Regina|Canada/Saskatchewan\",\n            \"America/Rio_Branco|America/Porto_Acre\",\n            \"America/Rio_Branco|Brazil/Acre\",\n            \"America/Santiago|Chile/Continental\",\n            \"America/Sao_Paulo|Brazil/East\",\n            \"America/St_Johns|Canada/Newfoundland\",\n            \"America/Tijuana|America/Ensenada\",\n            \"America/Tijuana|America/Santa_Isabel\",\n            \"America/Tijuana|Mexico/BajaNorte\",\n            \"America/Toronto|America/Montreal\",\n            \"America/Toronto|America/Nassau\",\n            \"America/Toronto|America/Nipigon\",\n            \"America/Toronto|America/Thunder_Bay\",\n            \"America/Toronto|Canada/Eastern\",\n            \"America/Vancouver|Canada/Pacific\",\n            \"America/Whitehorse|Canada/Yukon\",\n            \"America/Winnipeg|America/Rainy_River\",\n            \"America/Winnipeg|Canada/Central\",\n            \"Asia/Ashgabat|Asia/Ashkhabad\",\n            \"Asia/Bangkok|Asia/Phnom_Penh\",\n            \"Asia/Bangkok|Asia/Vientiane\",\n            \"Asia/Bangkok|Etc/GMT-7\",\n            \"Asia/Bangkok|Indian/Christmas\",\n            \"Asia/Brunei|Asia/Kuching\",\n            \"Asia/Brunei|Etc/GMT-8\",\n            \"Asia/Dhaka|Asia/Dacca\",\n            \"Asia/Dubai|Asia/Muscat\",\n            \"Asia/Dubai|Etc/GMT-4\",\n            \"Asia/Dubai|Indian/Mahe\",\n            \"Asia/Dubai|Indian/Reunion\",\n            \"Asia/Ho_Chi_Minh|Asia/Saigon\",\n            \"Asia/Hong_Kong|Hongkong\",\n            \"Asia/Jerusalem|Asia/Tel_Aviv\",\n            \"Asia/Jerusalem|Israel\",\n            \"Asia/Kathmandu|Asia/Katmandu\",\n            \"Asia/Kolkata|Asia/Calcutta\",\n            \"Asia/Kuala_Lumpur|Asia/Singapore\",\n            \"Asia/Kuala_Lumpur|Singapore\",\n            \"Asia/Macau|Asia/Macao\",\n            \"Asia/Makassar|Asia/Ujung_Pandang\",\n            \"Asia/Nicosia|Europe/Nicosia\",\n            \"Asia/Qatar|Asia/Bahrain\",\n            \"Asia/Rangoon|Asia/Yangon\",\n            \"Asia/Rangoon|Indian/Cocos\",\n            \"Asia/Riyadh|Antarctica/Syowa\",\n            \"Asia/Riyadh|Asia/Aden\",\n            \"Asia/Riyadh|Asia/Kuwait\",\n            \"Asia/Riyadh|Etc/GMT-3\",\n            \"Asia/Seoul|ROK\",\n            \"Asia/Shanghai|Asia/Chongqing\",\n            \"Asia/Shanghai|Asia/Chungking\",\n            \"Asia/Shanghai|Asia/Harbin\",\n            \"Asia/Shanghai|PRC\",\n            \"Asia/Taipei|ROC\",\n            \"Asia/Tehran|Iran\",\n            \"Asia/Thimphu|Asia/Thimbu\",\n            \"Asia/Tokyo|Japan\",\n            \"Asia/Ulaanbaatar|Asia/Ulan_Bator\",\n            \"Asia/Urumqi|Antarctica/Vostok\",\n            \"Asia/Urumqi|Asia/Kashgar\",\n            \"Asia/Urumqi|Etc/GMT-6\",\n            \"Atlantic/Faroe|Atlantic/Faeroe\",\n            \"Atlantic/South_Georgia|Etc/GMT+2\",\n            \"Australia/Adelaide|Australia/South\",\n            \"Australia/Brisbane|Australia/Queensland\",\n            \"Australia/Broken_Hill|Australia/Yancowinna\",\n            \"Australia/Darwin|Australia/North\",\n            \"Australia/Hobart|Australia/Currie\",\n            \"Australia/Hobart|Australia/Tasmania\",\n            \"Australia/Lord_Howe|Australia/LHI\",\n            \"Australia/Melbourne|Australia/Victoria\",\n            \"Australia/Perth|Australia/West\",\n            \"Australia/Sydney|Australia/ACT\",\n            \"Australia/Sydney|Australia/Canberra\",\n            \"Australia/Sydney|Australia/NSW\",\n            \"Etc/UTC|Etc/UCT\",\n            \"Etc/UTC|Etc/Universal\",\n            \"Etc/UTC|Etc/Zulu\",\n            \"Etc/UTC|UCT\",\n            \"Etc/UTC|UTC\",\n            \"Etc/UTC|Universal\",\n            \"Etc/UTC|Zulu\",\n            \"Europe/Belgrade|Europe/Ljubljana\",\n            \"Europe/Belgrade|Europe/Podgorica\",\n            \"Europe/Belgrade|Europe/Sarajevo\",\n            \"Europe/Belgrade|Europe/Skopje\",\n            \"Europe/Belgrade|Europe/Zagreb\",\n            \"Europe/Berlin|Arctic/Longyearbyen\",\n            \"Europe/Berlin|Atlantic/Jan_Mayen\",\n            \"Europe/Berlin|Europe/Copenhagen\",\n            \"Europe/Berlin|Europe/Oslo\",\n            \"Europe/Berlin|Europe/Stockholm\",\n            \"Europe/Brussels|CET\",\n            \"Europe/Brussels|Europe/Amsterdam\",\n            \"Europe/Brussels|Europe/Luxembourg\",\n            \"Europe/Chisinau|Europe/Tiraspol\",\n            \"Europe/Dublin|Eire\",\n            \"Europe/Helsinki|Europe/Mariehamn\",\n            \"Europe/Istanbul|Asia/Istanbul\",\n            \"Europe/Istanbul|Turkey\",\n            \"Europe/Kiev|Europe/Kyiv\",\n            \"Europe/Kiev|Europe/Uzhgorod\",\n            \"Europe/Kiev|Europe/Zaporozhye\",\n            \"Europe/Lisbon|Portugal\",\n            \"Europe/London|Europe/Belfast\",\n            \"Europe/London|Europe/Guernsey\",\n            \"Europe/London|Europe/Isle_of_Man\",\n            \"Europe/London|Europe/Jersey\",\n            \"Europe/London|GB\",\n            \"Europe/London|GB-Eire\",\n            \"Europe/Moscow|W-SU\",\n            \"Europe/Paris|Europe/Monaco\",\n            \"Europe/Prague|Europe/Bratislava\",\n            \"Europe/Rome|Europe/San_Marino\",\n            \"Europe/Rome|Europe/Vatican\",\n            \"Europe/Warsaw|Poland\",\n            \"Europe/Zurich|Europe/Busingen\",\n            \"Europe/Zurich|Europe/Vaduz\",\n            \"Indian/Maldives|Etc/GMT-5\",\n            \"Indian/Maldives|Indian/Kerguelen\",\n            \"Pacific/Auckland|Antarctica/McMurdo\",\n            \"Pacific/Auckland|Antarctica/South_Pole\",\n            \"Pacific/Auckland|NZ\",\n            \"Pacific/Chatham|NZ-CHAT\",\n            \"Pacific/Easter|Chile/EasterIsland\",\n            \"Pacific/Enderbury|Pacific/Kanton\",\n            \"Pacific/Gambier|Etc/GMT+9\",\n            \"Pacific/Guadalcanal|Etc/GMT-11\",\n            \"Pacific/Guadalcanal|Pacific/Pohnpei\",\n            \"Pacific/Guadalcanal|Pacific/Ponape\",\n            \"Pacific/Guam|Pacific/Saipan\",\n            \"Pacific/Honolulu|HST\",\n            \"Pacific/Honolulu|Pacific/Johnston\",\n            \"Pacific/Honolulu|US/Hawaii\",\n            \"Pacific/Kwajalein|Kwajalein\",\n            \"Pacific/Niue|Etc/GMT+11\",\n            \"Pacific/Pago_Pago|Pacific/Midway\",\n            \"Pacific/Pago_Pago|Pacific/Samoa\",\n            \"Pacific/Pago_Pago|US/Samoa\",\n            \"Pacific/Palau|Etc/GMT-9\",\n            \"Pacific/Port_Moresby|Antarctica/DumontDUrville\",\n            \"Pacific/Port_Moresby|Etc/GMT-10\",\n            \"Pacific/Port_Moresby|Pacific/Chuuk\",\n            \"Pacific/Port_Moresby|Pacific/Truk\",\n            \"Pacific/Port_Moresby|Pacific/Yap\",\n            \"Pacific/Tahiti|Etc/GMT+10\",\n            \"Pacific/Tarawa|Etc/GMT-12\",\n            \"Pacific/Tarawa|Pacific/Funafuti\",\n            \"Pacific/Tarawa|Pacific/Majuro\",\n            \"Pacific/Tarawa|Pacific/Wake\",\n            \"Pacific/Tarawa|Pacific/Wallis\"\n        ],\n        \"countries\": [\n            \"AD|Europe/Andorra\",\n            \"AE|Asia/Dubai\",\n            \"AF|Asia/Kabul\",\n            \"AG|America/Puerto_Rico America/Antigua\",\n            \"AI|America/Puerto_Rico America/Anguilla\",\n            \"AL|Europe/Tirane\",\n            \"AM|Asia/Yerevan\",\n            \"AO|Africa/Lagos Africa/Luanda\",\n            \"AQ|Antarctica/Casey Antarctica/Davis Antarctica/Mawson Antarctica/Palmer Antarctica/Rothera Antarctica/Troll Asia/Urumqi Pacific/Auckland Pacific/Port_Moresby Asia/Riyadh Antarctica/McMurdo Antarctica/DumontDUrville Antarctica/Syowa Antarctica/Vostok\",\n            \"AR|America/Argentina/Buenos_Aires America/Argentina/Cordoba America/Argentina/Salta America/Argentina/Jujuy America/Argentina/Tucuman America/Argentina/Catamarca America/Argentina/La_Rioja America/Argentina/San_Juan America/Argentina/Mendoza America/Argentina/San_Luis America/Argentina/Rio_Gallegos America/Argentina/Ushuaia\",\n            \"AS|Pacific/Pago_Pago\",\n            \"AT|Europe/Vienna\",\n            \"AU|Australia/Lord_Howe Antarctica/Macquarie Australia/Hobart Australia/Melbourne Australia/Sydney Australia/Broken_Hill Australia/Brisbane Australia/Lindeman Australia/Adelaide Australia/Darwin Australia/Perth Australia/Eucla\",\n            \"AW|America/Puerto_Rico America/Aruba\",\n            \"AX|Europe/Helsinki Europe/Mariehamn\",\n            \"AZ|Asia/Baku\",\n            \"BA|Europe/Belgrade Europe/Sarajevo\",\n            \"BB|America/Barbados\",\n            \"BD|Asia/Dhaka\",\n            \"BE|Europe/Brussels\",\n            \"BF|Africa/Abidjan Africa/Ouagadougou\",\n            \"BG|Europe/Sofia\",\n            \"BH|Asia/Qatar Asia/Bahrain\",\n            \"BI|Africa/Maputo Africa/Bujumbura\",\n            \"BJ|Africa/Lagos Africa/Porto-Novo\",\n            \"BL|America/Puerto_Rico America/St_Barthelemy\",\n            \"BM|Atlantic/Bermuda\",\n            \"BN|Asia/Kuching Asia/Brunei\",\n            \"BO|America/La_Paz\",\n            \"BQ|America/Puerto_Rico America/Kralendijk\",\n            \"BR|America/Noronha America/Belem America/Fortaleza America/Recife America/Araguaina America/Maceio America/Bahia America/Sao_Paulo America/Campo_Grande America/Cuiaba America/Santarem America/Porto_Velho America/Boa_Vista America/Manaus America/Eirunepe America/Rio_Branco\",\n            \"BS|America/Toronto America/Nassau\",\n            \"BT|Asia/Thimphu\",\n            \"BW|Africa/Maputo Africa/Gaborone\",\n            \"BY|Europe/Minsk\",\n            \"BZ|America/Belize\",\n            \"CA|America/St_Johns America/Halifax America/Glace_Bay America/Moncton America/Goose_Bay America/Toronto America/Iqaluit America/Winnipeg America/Resolute America/Rankin_Inlet America/Regina America/Swift_Current America/Edmonton America/Cambridge_Bay America/Inuvik America/Dawson_Creek America/Fort_Nelson America/Whitehorse America/Dawson America/Vancouver America/Panama America/Puerto_Rico America/Phoenix America/Blanc-Sablon America/Atikokan America/Creston\",\n            \"CC|Asia/Yangon Indian/Cocos\",\n            \"CD|Africa/Maputo Africa/Lagos Africa/Kinshasa Africa/Lubumbashi\",\n            \"CF|Africa/Lagos Africa/Bangui\",\n            \"CG|Africa/Lagos Africa/Brazzaville\",\n            \"CH|Europe/Zurich\",\n            \"CI|Africa/Abidjan\",\n            \"CK|Pacific/Rarotonga\",\n            \"CL|America/Santiago America/Punta_Arenas Pacific/Easter\",\n            \"CM|Africa/Lagos Africa/Douala\",\n            \"CN|Asia/Shanghai Asia/Urumqi\",\n            \"CO|America/Bogota\",\n            \"CR|America/Costa_Rica\",\n            \"CU|America/Havana\",\n            \"CV|Atlantic/Cape_Verde\",\n            \"CW|America/Puerto_Rico America/Curacao\",\n            \"CX|Asia/Bangkok Indian/Christmas\",\n            \"CY|Asia/Nicosia Asia/Famagusta\",\n            \"CZ|Europe/Prague\",\n            \"DE|Europe/Zurich Europe/Berlin Europe/Busingen\",\n            \"DJ|Africa/Nairobi Africa/Djibouti\",\n            \"DK|Europe/Berlin Europe/Copenhagen\",\n            \"DM|America/Puerto_Rico America/Dominica\",\n            \"DO|America/Santo_Domingo\",\n            \"DZ|Africa/Algiers\",\n            \"EC|America/Guayaquil Pacific/Galapagos\",\n            \"EE|Europe/Tallinn\",\n            \"EG|Africa/Cairo\",\n            \"EH|Africa/El_Aaiun\",\n            \"ER|Africa/Nairobi Africa/Asmara\",\n            \"ES|Europe/Madrid Africa/Ceuta Atlantic/Canary\",\n            \"ET|Africa/Nairobi Africa/Addis_Ababa\",\n            \"FI|Europe/Helsinki\",\n            \"FJ|Pacific/Fiji\",\n            \"FK|Atlantic/Stanley\",\n            \"FM|Pacific/Kosrae Pacific/Port_Moresby Pacific/Guadalcanal Pacific/Chuuk Pacific/Pohnpei\",\n            \"FO|Atlantic/Faroe\",\n            \"FR|Europe/Paris\",\n            \"GA|Africa/Lagos Africa/Libreville\",\n            \"GB|Europe/London\",\n            \"GD|America/Puerto_Rico America/Grenada\",\n            \"GE|Asia/Tbilisi\",\n            \"GF|America/Cayenne\",\n            \"GG|Europe/London Europe/Guernsey\",\n            \"GH|Africa/Abidjan Africa/Accra\",\n            \"GI|Europe/Gibraltar\",\n            \"GL|America/Nuuk America/Danmarkshavn America/Scoresbysund America/Thule\",\n            \"GM|Africa/Abidjan Africa/Banjul\",\n            \"GN|Africa/Abidjan Africa/Conakry\",\n            \"GP|America/Puerto_Rico America/Guadeloupe\",\n            \"GQ|Africa/Lagos Africa/Malabo\",\n            \"GR|Europe/Athens\",\n            \"GS|Atlantic/South_Georgia\",\n            \"GT|America/Guatemala\",\n            \"GU|Pacific/Guam\",\n            \"GW|Africa/Bissau\",\n            \"GY|America/Guyana\",\n            \"HK|Asia/Hong_Kong\",\n            \"HN|America/Tegucigalpa\",\n            \"HR|Europe/Belgrade Europe/Zagreb\",\n            \"HT|America/Port-au-Prince\",\n            \"HU|Europe/Budapest\",\n            \"ID|Asia/Jakarta Asia/Pontianak Asia/Makassar Asia/Jayapura\",\n            \"IE|Europe/Dublin\",\n            \"IL|Asia/Jerusalem\",\n            \"IM|Europe/London Europe/Isle_of_Man\",\n            \"IN|Asia/Kolkata\",\n            \"IO|Indian/Chagos\",\n            \"IQ|Asia/Baghdad\",\n            \"IR|Asia/Tehran\",\n            \"IS|Africa/Abidjan Atlantic/Reykjavik\",\n            \"IT|Europe/Rome\",\n            \"JE|Europe/London Europe/Jersey\",\n            \"JM|America/Jamaica\",\n            \"JO|Asia/Amman\",\n            \"JP|Asia/Tokyo\",\n            \"KE|Africa/Nairobi\",\n            \"KG|Asia/Bishkek\",\n            \"KH|Asia/Bangkok Asia/Phnom_Penh\",\n            \"KI|Pacific/Tarawa Pacific/Kanton Pacific/Kiritimati\",\n            \"KM|Africa/Nairobi Indian/Comoro\",\n            \"KN|America/Puerto_Rico America/St_Kitts\",\n            \"KP|Asia/Pyongyang\",\n            \"KR|Asia/Seoul\",\n            \"KW|Asia/Riyadh Asia/Kuwait\",\n            \"KY|America/Panama America/Cayman\",\n            \"KZ|Asia/Almaty Asia/Qyzylorda Asia/Qostanay Asia/Aqtobe Asia/Aqtau Asia/Atyrau Asia/Oral\",\n            \"LA|Asia/Bangkok Asia/Vientiane\",\n            \"LB|Asia/Beirut\",\n            \"LC|America/Puerto_Rico America/St_Lucia\",\n            \"LI|Europe/Zurich Europe/Vaduz\",\n            \"LK|Asia/Colombo\",\n            \"LR|Africa/Monrovia\",\n            \"LS|Africa/Johannesburg Africa/Maseru\",\n            \"LT|Europe/Vilnius\",\n            \"LU|Europe/Brussels Europe/Luxembourg\",\n            \"LV|Europe/Riga\",\n            \"LY|Africa/Tripoli\",\n            \"MA|Africa/Casablanca\",\n            \"MC|Europe/Paris Europe/Monaco\",\n            \"MD|Europe/Chisinau\",\n            \"ME|Europe/Belgrade Europe/Podgorica\",\n            \"MF|America/Puerto_Rico America/Marigot\",\n            \"MG|Africa/Nairobi Indian/Antananarivo\",\n            \"MH|Pacific/Tarawa Pacific/Kwajalein Pacific/Majuro\",\n            \"MK|Europe/Belgrade Europe/Skopje\",\n            \"ML|Africa/Abidjan Africa/Bamako\",\n            \"MM|Asia/Yangon\",\n            \"MN|Asia/Ulaanbaatar Asia/Hovd Asia/Choibalsan\",\n            \"MO|Asia/Macau\",\n            \"MP|Pacific/Guam Pacific/Saipan\",\n            \"MQ|America/Martinique\",\n            \"MR|Africa/Abidjan Africa/Nouakchott\",\n            \"MS|America/Puerto_Rico America/Montserrat\",\n            \"MT|Europe/Malta\",\n            \"MU|Indian/Mauritius\",\n            \"MV|Indian/Maldives\",\n            \"MW|Africa/Maputo Africa/Blantyre\",\n            \"MX|America/Mexico_City America/Cancun America/Merida America/Monterrey America/Matamoros America/Chihuahua America/Ciudad_Juarez America/Ojinaga America/Mazatlan America/Bahia_Banderas America/Hermosillo America/Tijuana\",\n            \"MY|Asia/Kuching Asia/Singapore Asia/Kuala_Lumpur\",\n            \"MZ|Africa/Maputo\",\n            \"NA|Africa/Windhoek\",\n            \"NC|Pacific/Noumea\",\n            \"NE|Africa/Lagos Africa/Niamey\",\n            \"NF|Pacific/Norfolk\",\n            \"NG|Africa/Lagos\",\n            \"NI|America/Managua\",\n            \"NL|Europe/Brussels Europe/Amsterdam\",\n            \"NO|Europe/Berlin Europe/Oslo\",\n            \"NP|Asia/Kathmandu\",\n            \"NR|Pacific/Nauru\",\n            \"NU|Pacific/Niue\",\n            \"NZ|Pacific/Auckland Pacific/Chatham\",\n            \"OM|Asia/Dubai Asia/Muscat\",\n            \"PA|America/Panama\",\n            \"PE|America/Lima\",\n            \"PF|Pacific/Tahiti Pacific/Marquesas Pacific/Gambier\",\n            \"PG|Pacific/Port_Moresby Pacific/Bougainville\",\n            \"PH|Asia/Manila\",\n            \"PK|Asia/Karachi\",\n            \"PL|Europe/Warsaw\",\n            \"PM|America/Miquelon\",\n            \"PN|Pacific/Pitcairn\",\n            \"PR|America/Puerto_Rico\",\n            \"PS|Asia/Gaza Asia/Hebron\",\n            \"PT|Europe/Lisbon Atlantic/Madeira Atlantic/Azores\",\n            \"PW|Pacific/Palau\",\n            \"PY|America/Asuncion\",\n            \"QA|Asia/Qatar\",\n            \"RE|Asia/Dubai Indian/Reunion\",\n            \"RO|Europe/Bucharest\",\n            \"RS|Europe/Belgrade\",\n            \"RU|Europe/Kaliningrad Europe/Moscow Europe/Simferopol Europe/Kirov Europe/Volgograd Europe/Astrakhan Europe/Saratov Europe/Ulyanovsk Europe/Samara Asia/Yekaterinburg Asia/Omsk Asia/Novosibirsk Asia/Barnaul Asia/Tomsk Asia/Novokuznetsk Asia/Krasnoyarsk Asia/Irkutsk Asia/Chita Asia/Yakutsk Asia/Khandyga Asia/Vladivostok Asia/Ust-Nera Asia/Magadan Asia/Sakhalin Asia/Srednekolymsk Asia/Kamchatka Asia/Anadyr\",\n            \"RW|Africa/Maputo Africa/Kigali\",\n            \"SA|Asia/Riyadh\",\n            \"SB|Pacific/Guadalcanal\",\n            \"SC|Asia/Dubai Indian/Mahe\",\n            \"SD|Africa/Khartoum\",\n            \"SE|Europe/Berlin Europe/Stockholm\",\n            \"SG|Asia/Singapore\",\n            \"SH|Africa/Abidjan Atlantic/St_Helena\",\n            \"SI|Europe/Belgrade Europe/Ljubljana\",\n            \"SJ|Europe/Berlin Arctic/Longyearbyen\",\n            \"SK|Europe/Prague Europe/Bratislava\",\n            \"SL|Africa/Abidjan Africa/Freetown\",\n            \"SM|Europe/Rome Europe/San_Marino\",\n            \"SN|Africa/Abidjan Africa/Dakar\",\n            \"SO|Africa/Nairobi Africa/Mogadishu\",\n            \"SR|America/Paramaribo\",\n            \"SS|Africa/Juba\",\n            \"ST|Africa/Sao_Tome\",\n            \"SV|America/El_Salvador\",\n            \"SX|America/Puerto_Rico America/Lower_Princes\",\n            \"SY|Asia/Damascus\",\n            \"SZ|Africa/Johannesburg Africa/Mbabane\",\n            \"TC|America/Grand_Turk\",\n            \"TD|Africa/Ndjamena\",\n            \"TF|Asia/Dubai Indian/Maldives Indian/Kerguelen\",\n            \"TG|Africa/Abidjan Africa/Lome\",\n            \"TH|Asia/Bangkok\",\n            \"TJ|Asia/Dushanbe\",\n            \"TK|Pacific/Fakaofo\",\n            \"TL|Asia/Dili\",\n            \"TM|Asia/Ashgabat\",\n            \"TN|Africa/Tunis\",\n            \"TO|Pacific/Tongatapu\",\n            \"TR|Europe/Istanbul\",\n            \"TT|America/Puerto_Rico America/Port_of_Spain\",\n            \"TV|Pacific/Tarawa Pacific/Funafuti\",\n            \"TW|Asia/Taipei\",\n            \"TZ|Africa/Nairobi Africa/Dar_es_Salaam\",\n            \"UA|Europe/Simferopol Europe/Kyiv\",\n            \"UG|Africa/Nairobi Africa/Kampala\",\n            \"UM|Pacific/Pago_Pago Pacific/Tarawa Pacific/Midway Pacific/Wake\",\n            \"US|America/New_York America/Detroit America/Kentucky/Louisville America/Kentucky/Monticello America/Indiana/Indianapolis America/Indiana/Vincennes America/Indiana/Winamac America/Indiana/Marengo America/Indiana/Petersburg America/Indiana/Vevay America/Chicago America/Indiana/Tell_City America/Indiana/Knox America/Menominee America/North_Dakota/Center America/North_Dakota/New_Salem America/North_Dakota/Beulah America/Denver America/Boise America/Phoenix America/Los_Angeles America/Anchorage America/Juneau America/Sitka America/Metlakatla America/Yakutat America/Nome America/Adak Pacific/Honolulu\",\n            \"UY|America/Montevideo\",\n            \"UZ|Asia/Samarkand Asia/Tashkent\",\n            \"VA|Europe/Rome Europe/Vatican\",\n            \"VC|America/Puerto_Rico America/St_Vincent\",\n            \"VE|America/Caracas\",\n            \"VG|America/Puerto_Rico America/Tortola\",\n            \"VI|America/Puerto_Rico America/St_Thomas\",\n            \"VN|Asia/Bangkok Asia/Ho_Chi_Minh\",\n            \"VU|Pacific/Efate\",\n            \"WF|Pacific/Tarawa Pacific/Wallis\",\n            \"WS|Pacific/Apia\",\n            \"YE|Asia/Riyadh Asia/Aden\",\n            \"YT|Africa/Nairobi Indian/Mayotte\",\n            \"ZA|Africa/Johannesburg\",\n            \"ZM|Africa/Maputo Africa/Lusaka\",\n            \"ZW|Africa/Maputo Africa/Harare\"\n        ]\n    });\n\n\n    return moment;\n}));\n","matchMedia.js":"/*! matchMedia() polyfill - Test a CSS media type/query in JS. Authors & copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas, David Knight. MIT license */\n\nwindow.matchMedia || (window.matchMedia = function() {\n    \"use strict\";\n\n    // For browsers that support matchMedium api such as IE 9 and webkit\n    var styleMedia = (window.styleMedia || window.media);\n\n    // For those that don't support matchMedium\n    if (!styleMedia) {\n        var style       = document.createElement('style'),\n            script      = document.getElementsByTagName('script')[0],\n            info        = null;\n\n        style.type  = 'text/css';\n        style.id    = 'matchmediajs-test';\n\n        if (!script) {\n            document.head.appendChild(style);\n        } else {\n            script.parentNode.insertBefore(style, script);\n        }\n\n        // 'style.currentStyle' is used by IE <= 8 and 'window.getComputedStyle' for all other browsers\n        info = ('getComputedStyle' in window) && window.getComputedStyle(style, null) || style.currentStyle;\n\n        styleMedia = {\n            matchMedium: function(media) {\n                var text = '@media ' + media + '{ #matchmediajs-test { width: 1px; } }';\n\n                // 'style.styleSheet' is used by IE <= 8 and 'style.textContent' for all other browsers\n                if (style.styleSheet) {\n                    style.styleSheet.cssText = text;\n                } else {\n                    style.textContent = text;\n                }\n\n                // Test if media query is true or false\n                return info.width === '1px';\n            }\n        };\n    }\n\n    return function(media) {\n        return {\n            matches: styleMedia.matchMedium(media || 'all'),\n            media: media || 'all'\n        };\n    };\n}());\n\n/*! matchMedia() polyfill addListener/removeListener extension. Author & copyright (c) 2012: Scott Jehl. Dual MIT/BSD license */\n(function() {\n    // Bail out for browsers that have addListener support\n    if (window.matchMedia && window.matchMedia('all').addListener) {\n        return false;\n    }\n\n    var localMatchMedia = window.matchMedia,\n        hasMediaQueries = localMatchMedia('only all').matches,\n        isListening = false,\n        timeoutID = 0, // setTimeout for debouncing 'handleChange'\n        queries = [], // Contains each 'mql' and associated 'listeners' if 'addListener' is used\n        handleChange = function(evt) {\n            // Debounce\n            clearTimeout(timeoutID);\n\n            timeoutID = setTimeout(function() {\n                for (var i = 0, il = queries.length; i < il; i++) {\n                    var mql = queries[i].mql,\n                        listeners = queries[i].listeners || [],\n                        matches = localMatchMedia(mql.media).matches;\n\n                    // Update mql.matches value and call listeners\n                    // Fire listeners only if transitioning to or from matched state\n                    if (matches !== mql.matches) {\n                        mql.matches = matches;\n\n                        for (var j = 0, jl = listeners.length; j < jl; j++) {\n                            listeners[j].call(window, mql);\n                        }\n                    }\n                }\n            }, 30);\n        };\n\n    window.matchMedia = function(media) {\n        var mql = localMatchMedia(media),\n            listeners = [],\n            index = 0;\n\n        mql.addListener = function(listener) {\n            // Changes would not occur to css media type so return now (Affects IE <= 8)\n            if (!hasMediaQueries) {\n                return;\n            }\n\n            // Set up 'resize' listener for browsers that support CSS3 media queries (Not for IE <= 8)\n            // There should only ever be 1 resize listener running for performance\n            if (!isListening) {\n                isListening = true;\n                window.addEventListener('resize', handleChange, true);\n            }\n\n            // Push object only if it has not been pushed already\n            if (index === 0) {\n                index = queries.push({\n                    mql: mql,\n                    listeners: listeners\n                });\n            }\n\n            listeners.push(listener);\n        };\n\n        mql.removeListener = function(listener) {\n            for (var i = 0, il = listeners.length; i < il; i++) {\n                if (listeners[i] === listener) {\n                    listeners.splice(i, 1);\n                }\n            }\n        };\n\n        return mql;\n    };\n}());\n\nwindow.mediaCheck = function(options) {\n    var mq;\n\n    function mqChange(mq, options) {\n        if (mq.matches) {\n            if (typeof options.entry === \"function\") {\n                options.entry();\n            }\n        } else if (typeof options.exit === \"function\") {\n            options.exit();\n        }\n    };\n\n    mq = window.matchMedia(options.media);\n\n    mq.addListener(function() {\n        mqChange(mq, options);\n    });\n\n    mqChange(mq, options);\n};\n","requirejs-min-resolver.js":"    (function () {\n        var ctx = require.s.contexts._,\n            origNameToUrl = ctx.nameToUrl,\n            baseUrl = ctx.config.baseUrl;\n\n        ctx.nameToUrl = function() {\n            var url = origNameToUrl.apply(ctx, arguments);\n            if (url.indexOf(baseUrl)===0&&!url.match(/\\/tiny_mce\\//)&&!url.match(/\\/v1\\/songbird/)&&!url.match(/Xtento_ProductExport\\/js\\/ace\\/mode-xml/)&&!url.match(/Xtento_ProductExport\\/js\\/ace\\/theme-eclipse/)&&!url.match(/js.mollie.com/)&&!url.match(/\\/pay.google.com\\//)) {\n                url = url.replace(/(\\.min)?\\.js$/, '.min.js');\n            }\n            return url;\n        };\n    })();","requirejs-config.js":"(function(require){\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            directoryRegionUpdater: 'Magento_Directory/js/region-updater'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    waitSeconds: 0,\n    map: {\n        '*': {\n            'ko': 'knockoutjs/knockout',\n            'knockout': 'knockoutjs/knockout',\n            'mageUtils': 'mage/utils/main',\n            'rjsResolver': 'mage/requirejs/resolver',\n            'jquery-ui-modules/core': 'jquery/ui-modules/core',\n            'jquery-ui-modules/accordion': 'jquery/ui-modules/widgets/accordion',\n            'jquery-ui-modules/autocomplete': 'jquery/ui-modules/widgets/autocomplete',\n            'jquery-ui-modules/button': 'jquery/ui-modules/widgets/button',\n            'jquery-ui-modules/datepicker': 'jquery/ui-modules/widgets/datepicker',\n            'jquery-ui-modules/dialog': 'jquery/ui-modules/widgets/dialog',\n            'jquery-ui-modules/draggable': 'jquery/ui-modules/widgets/draggable',\n            'jquery-ui-modules/droppable': 'jquery/ui-modules/widgets/droppable',\n            'jquery-ui-modules/effect-blind': 'jquery/ui-modules/effects/effect-blind',\n            'jquery-ui-modules/effect-bounce': 'jquery/ui-modules/effects/effect-bounce',\n            'jquery-ui-modules/effect-clip': 'jquery/ui-modules/effects/effect-clip',\n            'jquery-ui-modules/effect-drop': 'jquery/ui-modules/effects/effect-drop',\n            'jquery-ui-modules/effect-explode': 'jquery/ui-modules/effects/effect-explode',\n            'jquery-ui-modules/effect-fade': 'jquery/ui-modules/effects/effect-fade',\n            'jquery-ui-modules/effect-fold': 'jquery/ui-modules/effects/effect-fold',\n            'jquery-ui-modules/effect-highlight': 'jquery/ui-modules/effects/effect-highlight',\n            'jquery-ui-modules/effect-scale': 'jquery/ui-modules/effects/effect-scale',\n            'jquery-ui-modules/effect-pulsate': 'jquery/ui-modules/effects/effect-pulsate',\n            'jquery-ui-modules/effect-shake': 'jquery/ui-modules/effects/effect-shake',\n            'jquery-ui-modules/effect-slide': 'jquery/ui-modules/effects/effect-slide',\n            'jquery-ui-modules/effect-transfer': 'jquery/ui-modules/effects/effect-transfer',\n            'jquery-ui-modules/effect': 'jquery/ui-modules/effect',\n            'jquery-ui-modules/menu': 'jquery/ui-modules/widgets/menu',\n            'jquery-ui-modules/mouse': 'jquery/ui-modules/widgets/mouse',\n            'jquery-ui-modules/position': 'jquery/ui-modules/position',\n            'jquery-ui-modules/progressbar': 'jquery/ui-modules/widgets/progressbar',\n            'jquery-ui-modules/resizable': 'jquery/ui-modules/widgets/resizable',\n            'jquery-ui-modules/selectable': 'jquery/ui-modules/widgets/selectable',\n            'jquery-ui-modules/selectmenu': 'jquery/ui-modules/widgets/selectmenu',\n            'jquery-ui-modules/slider': 'jquery/ui-modules/widgets/slider',\n            'jquery-ui-modules/sortable': 'jquery/ui-modules/widgets/sortable',\n            'jquery-ui-modules/spinner': 'jquery/ui-modules/widgets/spinner',\n            'jquery-ui-modules/tabs': 'jquery/ui-modules/widgets/tabs',\n            'jquery-ui-modules/tooltip': 'jquery/ui-modules/widgets/tooltip',\n            'jquery-ui-modules/widget': 'jquery/ui-modules/widget',\n            'jquery-ui-modules/timepicker': 'jquery/timepicker',\n            'vimeo': 'vimeo/player',\n            'vimeoWrapper': 'vimeo/vimeo-wrapper'\n        }\n    },\n    shim: {\n        'mage/adminhtml/backup': ['prototype'],\n        'mage/captcha': ['prototype'],\n        'mage/new-gallery': ['jquery'],\n        'jquery/ui': ['jquery'],\n        'matchMedia': {\n            'exports': 'mediaCheck'\n        },\n        'magnifier/magnifier': ['jquery'],\n        'vimeo/player': {\n            'exports': 'Player'\n        }\n    },\n    paths: {\n        'jquery/validate': 'jquery/jquery.validate',\n        'jquery/uppy-core': 'jquery/uppy/dist/uppy.min',\n        'prototype': 'legacy-build.min',\n        'jquery/jquery-storageapi': 'js-storage/storage-wrapper',\n        'text': 'mage/requirejs/text',\n        'domReady': 'requirejs/domReady',\n        'spectrum': 'jquery/spectrum/spectrum',\n        'tinycolor': 'jquery/spectrum/tinycolor',\n        'jquery-ui-modules': 'jquery/ui-modules'\n    },\n    config: {\n        text: {\n            'headers': {\n                'X-Requested-With': 'XMLHttpRequest'\n            }\n        }\n    }\n};\n\nrequire(['jquery'], function ($) {\n    'use strict';\n\n    $.noConflict();\n});\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'rowBuilder':             'Magento_Theme/js/row-builder',\n            'toggleAdvanced':         'mage/toggle',\n            'translateInline':        'mage/translate-inline',\n            'sticky':                 'mage/sticky',\n            'tabs':                   'mage/tabs',\n            'collapsible':            'mage/collapsible',\n            'dropdownDialog':         'mage/dropdown',\n            'dropdown':               'mage/dropdowns',\n            'accordion':              'mage/accordion',\n            'loader':                 'mage/loader',\n            'tooltip':                'mage/tooltip',\n            'deletableItem':          'mage/deletable-item',\n            'itemTable':              'mage/item-table',\n            'fieldsetControls':       'mage/fieldset-controls',\n            'fieldsetResetControl':   'mage/fieldset-controls',\n            'redirectUrl':            'mage/redirect-url',\n            'loaderAjax':             'mage/loader',\n            'menu':                   'mage/menu',\n            'popupWindow':            'mage/popup-window',\n            'validation':             'mage/validation/validation',\n            'breadcrumbs':            'Magento_Theme/js/view/breadcrumbs',\n            'jquery/ui':              'jquery/compat',\n            'cookieStatus':           'Magento_Theme/js/cookie-status'\n        }\n    },\n    deps: [\n        'mage/common',\n        'mage/dataPost',\n        'mage/bootstrap'\n    ],\n    config: {\n        mixins: {\n            'Magento_Theme/js/view/breadcrumbs': {\n                'Magento_Theme/js/view/add-home-breadcrumb': true\n            }\n        }\n    }\n};\n\n/* eslint-disable max-depth */\n/**\n * Adds polyfills only for browser contexts which prevents bundlers from including them.\n */\nif (typeof window !== 'undefined' && window.document) {\n    /**\n     * Polyfill localStorage and sessionStorage for browsers that do not support them.\n     */\n    try {\n        if (!window.localStorage || !window.sessionStorage) {\n            throw new Error();\n        }\n\n        localStorage.setItem('storage_test', 1);\n        localStorage.removeItem('storage_test');\n    } catch (e) {\n        config.deps.push('mage/polyfill');\n    }\n}\n/* eslint-enable max-depth */\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            escaper: 'Magento_Security/js/escaper'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            checkoutBalance:    'Magento_Customer/js/checkout-balance',\n            address:            'Magento_Customer/js/address',\n            changeEmailPassword: 'Magento_Customer/js/change-email-password',\n            passwordStrengthIndicator: 'Magento_Customer/js/password-strength-indicator',\n            zxcvbn: 'Magento_Customer/js/zxcvbn',\n            addressValidation: 'Magento_Customer/js/addressValidation',\n            showPassword: 'Magento_Customer/js/show-password',\n            'Magento_Customer/address': 'Magento_Customer/js/address',\n            'Magento_Customer/change-email-password': 'Magento_Customer/js/change-email-password',\n            globalSessionLoader:    'Magento_Customer/js/customer-global-session-loader.js'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            quickSearch: 'Magento_Search/js/form-mini',\n            'Magento_Search/form-mini': 'Magento_Search/js/form-mini'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            priceBox:             'Magento_Catalog/js/price-box',\n            priceOptionDate:      'Magento_Catalog/js/price-option-date',\n            priceOptionFile:      'Magento_Catalog/js/price-option-file',\n            priceOptions:         'Magento_Catalog/js/price-options',\n            priceUtils:           'Magento_Catalog/js/price-utils'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            compareList:            'Magento_Catalog/js/list',\n            relatedProducts:        'Magento_Catalog/js/related-products',\n            upsellProducts:         'Magento_Catalog/js/upsell-products',\n            productListToolbarForm: 'Magento_Catalog/js/product/list/toolbar',\n            catalogGallery:         'Magento_Catalog/js/gallery',\n            catalogAddToCart:       'Magento_Catalog/js/catalog-add-to-cart'\n        }\n    },\n    config: {\n        mixins: {\n            'Magento_Theme/js/view/breadcrumbs': {\n                'Magento_Catalog/js/product/breadcrumbs': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            addToCart: 'Magento_Msrp/js/msrp'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            catalogSearch: 'Magento_CatalogSearch/form-mini'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            creditCardType: 'Magento_Payment/js/cc-type',\n            'Magento_Payment/cc-type': 'Magento_Payment/js/cc-type'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            giftMessage:    'Magento_Sales/js/gift-message',\n            ordersReturns:  'Magento_Sales/js/orders-returns',\n            'Magento_Sales/gift-message':    'Magento_Sales/js/gift-message',\n            'Magento_Sales/orders-returns':  'Magento_Sales/js/orders-returns'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            discountCode:           'Magento_Checkout/js/discount-codes',\n            shoppingCart:           'Magento_Checkout/js/shopping-cart',\n            regionUpdater:          'Magento_Checkout/js/region-updater',\n            sidebar:                'Magento_Checkout/js/sidebar',\n            checkoutLoader:         'Magento_Checkout/js/checkout-loader',\n            checkoutData:           'Magento_Checkout/js/checkout-data',\n            proceedToCheckout:      'Magento_Checkout/js/proceed-to-checkout',\n            catalogAddToCart:       'Magento_Catalog/js/catalog-add-to-cart'\n        }\n    },\n    shim: {\n        'Magento_Checkout/js/model/totals' : {\n            deps: ['Magento_Customer/js/customer-data']\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            requireCookie: 'Magento_Cookie/js/require-cookie',\n            cookieNotices: 'Magento_Cookie/js/notices'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            downloadable: 'Magento_Downloadable/js/downloadable',\n            'Magento_Downloadable/downloadable': 'Magento_Downloadable/js/downloadable'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            subscriptionStatusResolver: 'Magento_Newsletter/js/subscription-status-resolver',\n            newsletterSignUp:  'Magento_Newsletter/js/newsletter-sign-up'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            bundleOption:   'Magento_Bundle/bundle',\n            priceBundle:    'Magento_Bundle/js/price-bundle',\n            slide:          'Magento_Bundle/js/slide',\n            productSummary: 'Magento_Bundle/js/product-summary'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            giftOptions:    'Magento_GiftMessage/js/gift-options',\n            'Magento_GiftMessage/gift-options':    'Magento_GiftMessage/js/gift-options'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    deps: [],\n    shim: {\n        'chartjs/chartjs-adapter-moment': ['moment'],\n        'chartjs/es6-shim.min': {},\n        'tiny_mce_6/tinymce.min': {\n            exports: 'tinyMCE'\n        }\n    },\n    paths: {\n        'ui/template': 'Magento_Ui/templates'\n    },\n    map: {\n        '*': {\n            uiElement:      'Magento_Ui/js/lib/core/element/element',\n            uiCollection:   'Magento_Ui/js/lib/core/collection',\n            uiComponent:    'Magento_Ui/js/lib/core/collection',\n            uiClass:        'Magento_Ui/js/lib/core/class',\n            uiEvents:       'Magento_Ui/js/lib/core/events',\n            uiRegistry:     'Magento_Ui/js/lib/registry/registry',\n            consoleLogger:  'Magento_Ui/js/lib/logger/console-logger',\n            uiLayout:       'Magento_Ui/js/core/renderer/layout',\n            buttonAdapter:  'Magento_Ui/js/form/button-adapter',\n            chartJs:        'chartjs/Chart.min',\n            'chart.js':     'chartjs/Chart.min',\n            tinymce:        'tiny_mce_6/tinymce.min',\n            wysiwygAdapter: 'mage/adminhtml/wysiwyg/tiny_mce/tinymceAdapter'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    deps: [\n        'Magento_Ui/js/core/app'\n    ]\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            pageCache:  'Magento_PageCache/js/page-cache'\n        }\n    },\n    deps: ['Magento_PageCache/js/form-key-provider']\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            groupedProduct: 'Magento_GroupedProduct/js/grouped-product'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            captcha: 'Magento_Captcha/js/captcha',\n            'Magento_Captcha/captcha': 'Magento_Captcha/js/captcha'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            configurable: 'Magento_ConfigurableProduct/js/configurable'\n        }\n    },\n    config: {\n        mixins: {\n            'Magento_Catalog/js/catalog-add-to-cart': {\n                'Magento_ConfigurableProduct/js/catalog-add-to-cart-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            multiShipping: 'Magento_Multishipping/js/multi-shipping',\n            orderOverview: 'Magento_Multishipping/js/overview',\n            payment: 'Magento_Multishipping/js/payment',\n            billingLoader: 'Magento_Checkout/js/checkout-loader',\n            cartUpdate: 'Magento_Checkout/js/action/update-shopping-cart',\n            multiShippingBalance: 'Magento_Multishipping/js/multi-shipping-balance'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            recentlyViewedProducts: 'Magento_Reports/js/recently-viewed'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/action/select-payment-method': {\n                'Magento_SalesRule/js/action/select-payment-method-mixin': true\n            },\n            'Magento_Checkout/js/model/shipping-save-processor': {\n                'Magento_SalesRule/js/model/shipping-save-processor-mixin': true\n            },\n            'Magento_Checkout/js/action/place-order': {\n                'Magento_SalesRule/js/model/place-order-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright 2023 Adobe\n * All Rights Reserved.\n */\nvar config = {\n    map: {\n        '*': {\n            'cancelOrderModal': 'Magento_OrderCancellationUi/js/cancel-order-modal'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'slick': 'Magento_PageBuilder/js/resource/slick/slick',\n            'jarallax': 'Magento_PageBuilder/js/resource/jarallax/jarallax',\n            'jarallaxVideo': 'Magento_PageBuilder/js/resource/jarallax/jarallax-video',\n            'Magento_PageBuilder/js/resource/vimeo/player': 'vimeo/player',\n            'Magento_PageBuilder/js/resource/vimeo/vimeo-wrapper': 'vimeo/vimeo-wrapper',\n            'jarallax-wrapper': 'Magento_PageBuilder/js/resource/jarallax/jarallax-wrapper'\n        }\n    },\n    shim: {\n        'Magento_PageBuilder/js/resource/slick/slick': {\n            deps: ['jquery']\n        },\n        'Magento_PageBuilder/js/resource/jarallax/jarallax-video': {\n            deps: ['jarallax-wrapper', 'vimeoWrapper']\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    shim: {\n        cardinaljs: {\n            exports: 'Cardinal'\n        },\n        cardinaljsSandbox: {\n            exports: 'Cardinal'\n        }\n    },\n    paths: {\n        cardinaljsSandbox: 'https://includestest.ccdc02.com/cardinalcruise/v1/songbird',\n        cardinaljs: 'https://songbird.cardinalcommerce.com/edge/v1/songbird'\n    }\n};\n\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            transparent: 'Magento_Payment/js/transparent',\n            'Magento_Payment/transparent': 'Magento_Payment/js/transparent'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            orderReview: 'Magento_Paypal/js/order-review',\n            'Magento_Paypal/order-review': 'Magento_Paypal/js/order-review',\n            paypalCheckout: 'Magento_Paypal/js/paypal-checkout'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Customer/js/customer-data': {\n                'Magento_Persistent/js/view/customer-data-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            loadPlayer: 'Magento_ProductVideo/js/load-player',\n            fotoramaVideoEvents: 'Magento_ProductVideo/js/fotorama-add-video-events',\n            'vimeoWrapper': 'vimeo/vimeo-wrapper'\n        }\n    },\n    shim: {\n        vimeoAPI: {},\n        'Magento_ProductVideo/js/load-player': {\n            deps: ['vimeoWrapper']\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/action/place-order': {\n                'Magento_CheckoutAgreements/js/model/place-order-mixin': true\n            },\n            'Magento_Checkout/js/action/set-payment-information': {\n                'Magento_CheckoutAgreements/js/model/set-payment-information-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// eslint-disable-next-line no-unused-vars\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/model/place-order': {\n                'Magento_ReCaptchaCheckout/js/model/place-order-mixin': true\n            },\n            'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry': {\n                'Magento_ReCaptchaCheckout/js/webapiReCaptchaRegistry-mixin': true\n            }\n        }\n    }\n};\n\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint strict: [\"error\", \"global\"]*/\n\n'use strict';\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Ui/js/view/messages': {\n                'Magento_ReCaptchaFrontendUi/js/ui-messages-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// eslint-disable-next-line no-unused-vars\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method': {\n                'Magento_ReCaptchaPaypal/js/payflowpro-method-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// eslint-disable-next-line no-unused-vars\nvar config = {\n    config: {\n        mixins: {\n            'jquery': {\n                'Magento_ReCaptchaWebapiUi/js/jquery-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            scriptLoader: 'Magento_PaymentServicesPaypal/js/lib/script-loader-wrapper'\n        }\n    },\n    shim: {\n        'Magento_PaymentServicesPaypal/js/lib/script-loader': {\n            init: function () {\n                'use strict';\n\n                return {\n                    load: window.paypalLoadScript,\n                    loadCustom: window.paypalLoadCustomScript\n                };\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'Magento_Vault/js/view/payment/vault': 'Magento_PaymentServicesPaypal/js/view/payment/vault'\n        }\n    },\n    config: {\n        mixins: {\n            'Magento_Checkout/js/model/payment-service': {\n                'Magento_PaymentServicesPaypal/js/model/payment-service-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            mageTranslationDictionary: 'Magento_Translation/js/mage-translation-dictionary'\n        }\n    },\n    deps: [\n        'mageTranslationDictionary'\n    ]\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            editTrigger: 'mage/edit-trigger',\n            addClass: 'Magento_Translation/js/add-class',\n            'Magento_Translation/add-class': 'Magento_Translation/js/add-class'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/view/payment/list': {\n                'Magento_PaypalCaptcha/js/view/payment/list-mixin': true\n            },\n            'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method': {\n                'Magento_PaypalCaptcha/js/view/payment/method-renderer/payflowpro-method-mixin': true\n            },\n            'Magento_Captcha/js/view/checkout/defaultCaptcha': {\n                'Magento_PaypalCaptcha/js/view/checkout/defaultCaptcha-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'taxToggle': 'Magento_Weee/js/tax-toggle',\n            'Magento_Weee/tax-toggle': 'Magento_Weee/js/tax-toggle'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            wishlist:       'Magento_Wishlist/js/wishlist',\n            addToWishlist:  'Magento_Wishlist/js/add-to-wishlist',\n            wishlistSearch: 'Magento_Wishlist/js/search'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCore\n * @author    Botis <botis@smile.fr>\n * @copyright 2021 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Ui/js/lib/validation/validator': {\n                'Smile_ElasticsuiteCore/js/validation/validator-mixin': true\n            }\n        }\n    },\n};\n\n\nrequire.config(config);\n})();\n(function() {\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCore\n * @author    Romain Ruaud <romain.ruaud@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\nvar config = {\n    map: {\n        '*': {\n            quickSearch: 'Smile_ElasticsuiteCore/js/form-mini'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCatalog\n * @author    Aurelien FOUCRET <aurelien.foucret@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\nvar config = {\n    map: {\n        '*': {\n            rangeSlider: 'Smile_ElasticsuiteCatalog/js/range-slider-widget'\n        }\n    },\n    shim: {\n        'Smile_ElasticsuiteCatalog/js/jquery.ui.touch-punch.min': {\n            deps: ['Smile_ElasticsuiteCatalog/js/mouse']\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    config: {\n        mixins: {\n            'Magento_InstantPurchase/js/view/instant-purchase': {\n                'Mollie_Payment/js/view/instant-purchase/instant-purchase': true\n            },\n            'Onestepcheckout_Iosc/js/ajax': {\n                'Mollie_Payment/js/mixin/onestepcheckout/ajax-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Config to pull in all the relevant Braintree JS SDKs\n * @type {\n *  paths: {\n *      braintreePayPalInContextCheckout: string,\n *      braintreePayPalCheckout: string,\n *      braintreeVenmo: string,\n *      braintreeHostedFields: string,\n *      braintreeDataCollector: string,\n *      braintreeThreeDSecure: string,\n *      braintreeGooglePay: string,\n *      braintreeApplePay: string,\n *      braintreeAch: string,\n *      braintreeLpm: string,\n *      googlePayLibrary: string\n * },\n *  map: {\n *      \"*\": {\n *          braintree: string\n *      }\n *  }\n * }\n */\nvar config = {\n    map: {\n        '*': {\n            braintree: 'https://js.braintreegateway.com/web/3.112.0/js/client.min.js'\n        }\n    },\n\n    paths: {\n        'braintreePayPalCheckout': 'https://js.braintreegateway.com/web/3.112.0/js/paypal-checkout.min',\n        'braintreeHostedFields': 'https://js.braintreegateway.com/web/3.112.0/js/hosted-fields.min',\n        'braintreeDataCollector': 'https://js.braintreegateway.com/web/3.112.0/js/data-collector.min',\n        'braintreeThreeDSecure': 'https://js.braintreegateway.com/web/3.112.0/js/three-d-secure.min',\n        'braintreeApplePay': 'https://js.braintreegateway.com/web/3.112.0/js/apple-pay.min',\n        'braintreeGooglePay': 'https://js.braintreegateway.com/web/3.112.0/js/google-payment.min',\n        'braintreeVenmo': 'https://js.braintreegateway.com/web/3.112.0/js/venmo.min',\n        'braintreeAch': 'https://js.braintreegateway.com/web/3.112.0/js/us-bank-account.min',\n        'braintreeLpm': 'https://js.braintreegateway.com/web/3.112.0/js/local-payment.min',\n        'googlePayLibrary': 'https://pay.google.com/gp/p/js/pay',\n        'braintreePayPalInContextCheckout': 'https://www.paypalobjects.com/api/checkout'\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Checkout/js/model/step-navigator': {\n                'PayPal_Braintree/js/model/step-navigator-mixin': true\n            },\n            'Magento_Checkout/js/model/place-order': {\n                'PayPal_Braintree/js/model/place-order-mixin': true\n            },\n            'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry': {\n                'PayPal_Braintree/js/reCaptcha/webapiReCaptchaRegistry-mixin': true\n            },\n            'Magento_CheckoutAgreements/js/view/checkout-agreements': {\n                'PayPal_Braintree/js/checkoutAgreements/view/checkout-agreements-mixin': true\n            }\n        }\n    },\n    map: {\n        '*': {\n            braintreeCheckoutPayPalAdapter: 'PayPal_Braintree/js/view/payment/adapter'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n\n\n\n})(require);","jquery.js":"/*!\n * jQuery JavaScript Library v3.7.1\n * https://jquery.com/\n *\n * Copyright OpenJS Foundation and other contributors\n * Released under the MIT license\n * https://jquery.org/license\n *\n * Date: 2023-08-28T13:37Z\n */\n( function( global, factory ) {\n\n    \"use strict\";\n\n    if ( typeof module === \"object\" && typeof module.exports === \"object\" ) {\n\n        // For CommonJS and CommonJS-like environments where a proper `window`\n        // is present, execute the factory and get jQuery.\n        // For environments that do not have a `window` with a `document`\n        // (such as Node.js), expose a factory as module.exports.\n        // This accentuates the need for the creation of a real `window`.\n        // e.g. var jQuery = require(\"jquery\")(window);\n        // See ticket trac-14549 for more info.\n        module.exports = global.document ?\n            factory( global, true ) :\n            function( w ) {\n                if ( !w.document ) {\n                    throw new Error( \"jQuery requires a window with a document\" );\n                }\n                return factory( w );\n            };\n    } else {\n        factory( global );\n    }\n\n// Pass this if window is not defined yet\n} )( typeof window !== \"undefined\" ? window : this, function( window, noGlobal ) {\n\n// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1\n// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode\n// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common\n// enough that all such attempts are guarded in a try block.\n    \"use strict\";\n\n    var arr = [];\n\n    var getProto = Object.getPrototypeOf;\n\n    var slice = arr.slice;\n\n    var flat = arr.flat ? function( array ) {\n        return arr.flat.call( array );\n    } : function( array ) {\n        return arr.concat.apply( [], array );\n    };\n\n\n    var push = arr.push;\n\n    var indexOf = arr.indexOf;\n\n    var class2type = {};\n\n    var toString = class2type.toString;\n\n    var hasOwn = class2type.hasOwnProperty;\n\n    var fnToString = hasOwn.toString;\n\n    var ObjectFunctionString = fnToString.call( Object );\n\n    var support = {};\n\n    var isFunction = function isFunction( obj ) {\n\n        // Support: Chrome <=57, Firefox <=52\n        // In some browsers, typeof returns \"function\" for HTML <object> elements\n        // (i.e., `typeof document.createElement( \"object\" ) === \"function\"`).\n        // We don't want to classify *any* DOM node as a function.\n        // Support: QtWeb <=3.8.5, WebKit <=534.34, wkhtmltopdf tool <=0.12.5\n        // Plus for old WebKit, typeof returns \"function\" for HTML collections\n        // (e.g., `typeof document.getElementsByTagName(\"div\") === \"function\"`). (gh-4756)\n        return typeof obj === \"function\" && typeof obj.nodeType !== \"number\" &&\n            typeof obj.item !== \"function\";\n    };\n\n\n    var isWindow = function isWindow( obj ) {\n        return obj != null && obj === obj.window;\n    };\n\n\n    var document = window.document;\n\n\n\n    var preservedScriptAttributes = {\n        type: true,\n        src: true,\n        nonce: true,\n        noModule: true\n    };\n\n    function DOMEval( code, node, doc ) {\n        doc = doc || document;\n\n        var i, val,\n            script = doc.createElement( \"script\" );\n\n        script.text = code;\n        if ( node ) {\n            for ( i in preservedScriptAttributes ) {\n\n                // Support: Firefox 64+, Edge 18+\n                // Some browsers don't support the \"nonce\" property on scripts.\n                // On the other hand, just using `getAttribute` is not enough as\n                // the `nonce` attribute is reset to an empty string whenever it\n                // becomes browsing-context connected.\n                // See https://github.com/whatwg/html/issues/2369\n                // See https://html.spec.whatwg.org/#nonce-attributes\n                // The `node.getAttribute` check was added for the sake of\n                // `jQuery.globalEval` so that it can fake a nonce-containing node\n                // via an object.\n                val = node[ i ] || node.getAttribute && node.getAttribute( i );\n                if ( val ) {\n                    script.setAttribute( i, val );\n                }\n            }\n        }\n        doc.head.appendChild( script ).parentNode.removeChild( script );\n    }\n\n\n    function toType( obj ) {\n        if ( obj == null ) {\n            return obj + \"\";\n        }\n\n        // Support: Android <=2.3 only (functionish RegExp)\n        return typeof obj === \"object\" || typeof obj === \"function\" ?\n            class2type[ toString.call( obj ) ] || \"object\" :\n            typeof obj;\n    }\n    /* global Symbol */\n// Defining this global in .eslintrc.json would create a danger of using the global\n// unguarded in another place, it seems safer to define global only for this module\n\n\n\n    var version = \"3.7.1\",\n\n        rhtmlSuffix = /HTML$/i,\n\n        // Define a local copy of jQuery\n        jQuery = function( selector, context ) {\n\n            // The jQuery object is actually just the init constructor 'enhanced'\n            // Need init if jQuery is called (just allow error to be thrown if not included)\n            return new jQuery.fn.init( selector, context );\n        };\n\n    jQuery.fn = jQuery.prototype = {\n\n        // The current version of jQuery being used\n        jquery: version,\n\n        constructor: jQuery,\n\n        // The default length of a jQuery object is 0\n        length: 0,\n\n        toArray: function() {\n            return slice.call( this );\n        },\n\n        // Get the Nth element in the matched element set OR\n        // Get the whole matched element set as a clean array\n        get: function( num ) {\n\n            // Return all the elements in a clean array\n            if ( num == null ) {\n                return slice.call( this );\n            }\n\n            // Return just the one element from the set\n            return num < 0 ? this[ num + this.length ] : this[ num ];\n        },\n\n        // Take an array of elements and push it onto the stack\n        // (returning the new matched element set)\n        pushStack: function( elems ) {\n\n            // Build a new jQuery matched element set\n            var ret = jQuery.merge( this.constructor(), elems );\n\n            // Add the old object onto the stack (as a reference)\n            ret.prevObject = this;\n\n            // Return the newly-formed element set\n            return ret;\n        },\n\n        // Execute a callback for every element in the matched set.\n        each: function( callback ) {\n            return jQuery.each( this, callback );\n        },\n\n        map: function( callback ) {\n            return this.pushStack( jQuery.map( this, function( elem, i ) {\n                return callback.call( elem, i, elem );\n            } ) );\n        },\n\n        slice: function() {\n            return this.pushStack( slice.apply( this, arguments ) );\n        },\n\n        first: function() {\n            return this.eq( 0 );\n        },\n\n        last: function() {\n            return this.eq( -1 );\n        },\n\n        even: function() {\n            return this.pushStack( jQuery.grep( this, function( _elem, i ) {\n                return ( i + 1 ) % 2;\n            } ) );\n        },\n\n        odd: function() {\n            return this.pushStack( jQuery.grep( this, function( _elem, i ) {\n                return i % 2;\n            } ) );\n        },\n\n        eq: function( i ) {\n            var len = this.length,\n                j = +i + ( i < 0 ? len : 0 );\n            return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );\n        },\n\n        end: function() {\n            return this.prevObject || this.constructor();\n        },\n\n        // For internal use only.\n        // Behaves like an Array's method, not like a jQuery method.\n        push: push,\n        sort: arr.sort,\n        splice: arr.splice\n    };\n\n    jQuery.extend = jQuery.fn.extend = function() {\n        var options, name, src, copy, copyIsArray, clone,\n            target = arguments[ 0 ] || {},\n            i = 1,\n            length = arguments.length,\n            deep = false;\n\n        // Handle a deep copy situation\n        if ( typeof target === \"boolean\" ) {\n            deep = target;\n\n            // Skip the boolean and the target\n            target = arguments[ i ] || {};\n            i++;\n        }\n\n        // Handle case when target is a string or something (possible in deep copy)\n        if ( typeof target !== \"object\" && !isFunction( target ) ) {\n            target = {};\n        }\n\n        // Extend jQuery itself if only one argument is passed\n        if ( i === length ) {\n            target = this;\n            i--;\n        }\n\n        for ( ; i < length; i++ ) {\n\n            // Only deal with non-null/undefined values\n            if ( ( options = arguments[ i ] ) != null ) {\n\n                // Extend the base object\n                for ( name in options ) {\n                    copy = options[ name ];\n\n                    // Prevent Object.prototype pollution\n                    // Prevent never-ending loop\n                    if ( name === \"__proto__\" || target === copy ) {\n                        continue;\n                    }\n\n                    // Recurse if we're merging plain objects or arrays\n                    if ( deep && copy && ( jQuery.isPlainObject( copy ) ||\n                        ( copyIsArray = Array.isArray( copy ) ) ) ) {\n                        src = target[ name ];\n\n                        // Ensure proper type for the source value\n                        if ( copyIsArray && !Array.isArray( src ) ) {\n                            clone = [];\n                        } else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {\n                            clone = {};\n                        } else {\n                            clone = src;\n                        }\n                        copyIsArray = false;\n\n                        // Never move original objects, clone them\n                        target[ name ] = jQuery.extend( deep, clone, copy );\n\n                        // Don't bring in undefined values\n                    } else if ( copy !== undefined ) {\n                        target[ name ] = copy;\n                    }\n                }\n            }\n        }\n\n        // Return the modified object\n        return target;\n    };\n\n    jQuery.extend( {\n\n        // Unique for each copy of jQuery on the page\n        expando: \"jQuery\" + ( version + Math.random() ).replace( /\\D/g, \"\" ),\n\n        // Assume jQuery is ready without the ready module\n        isReady: true,\n\n        error: function( msg ) {\n            throw new Error( msg );\n        },\n\n        noop: function() {},\n\n        isPlainObject: function( obj ) {\n            var proto, Ctor;\n\n            // Detect obvious negatives\n            // Use toString instead of jQuery.type to catch host objects\n            if ( !obj || toString.call( obj ) !== \"[object Object]\" ) {\n                return false;\n            }\n\n            proto = getProto( obj );\n\n            // Objects with no prototype (e.g., `Object.create( null )`) are plain\n            if ( !proto ) {\n                return true;\n            }\n\n            // Objects with prototype are plain iff they were constructed by a global Object function\n            Ctor = hasOwn.call( proto, \"constructor\" ) && proto.constructor;\n            return typeof Ctor === \"function\" && fnToString.call( Ctor ) === ObjectFunctionString;\n        },\n\n        isEmptyObject: function( obj ) {\n            var name;\n\n            for ( name in obj ) {\n                return false;\n            }\n            return true;\n        },\n\n        // Evaluates a script in a provided context; falls back to the global one\n        // if not specified.\n        globalEval: function( code, options, doc ) {\n            DOMEval( code, { nonce: options && options.nonce }, doc );\n        },\n\n        each: function( obj, callback ) {\n            var length, i = 0;\n\n            if ( isArrayLike( obj ) ) {\n                length = obj.length;\n                for ( ; i < length; i++ ) {\n                    if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n                        break;\n                    }\n                }\n            } else {\n                for ( i in obj ) {\n                    if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n                        break;\n                    }\n                }\n            }\n\n            return obj;\n        },\n\n\n        // Retrieve the text value of an array of DOM nodes\n        text: function( elem ) {\n            var node,\n                ret = \"\",\n                i = 0,\n                nodeType = elem.nodeType;\n\n            if ( !nodeType ) {\n\n                // If no nodeType, this is expected to be an array\n                while ( ( node = elem[ i++ ] ) ) {\n\n                    // Do not traverse comment nodes\n                    ret += jQuery.text( node );\n                }\n            }\n            if ( nodeType === 1 || nodeType === 11 ) {\n                return elem.textContent;\n            }\n            if ( nodeType === 9 ) {\n                return elem.documentElement.textContent;\n            }\n            if ( nodeType === 3 || nodeType === 4 ) {\n                return elem.nodeValue;\n            }\n\n            // Do not include comment or processing instruction nodes\n\n            return ret;\n        },\n\n        // results is for internal usage only\n        makeArray: function( arr, results ) {\n            var ret = results || [];\n\n            if ( arr != null ) {\n                if ( isArrayLike( Object( arr ) ) ) {\n                    jQuery.merge( ret,\n                        typeof arr === \"string\" ?\n                            [ arr ] : arr\n                    );\n                } else {\n                    push.call( ret, arr );\n                }\n            }\n\n            return ret;\n        },\n\n        inArray: function( elem, arr, i ) {\n            return arr == null ? -1 : indexOf.call( arr, elem, i );\n        },\n\n        isXMLDoc: function( elem ) {\n            var namespace = elem && elem.namespaceURI,\n                docElem = elem && ( elem.ownerDocument || elem ).documentElement;\n\n            // Assume HTML when documentElement doesn't yet exist, such as inside\n            // document fragments.\n            return !rhtmlSuffix.test( namespace || docElem && docElem.nodeName || \"HTML\" );\n        },\n\n        // Support: Android <=4.0 only, PhantomJS 1 only\n        // push.apply(_, arraylike) throws on ancient WebKit\n        merge: function( first, second ) {\n            var len = +second.length,\n                j = 0,\n                i = first.length;\n\n            for ( ; j < len; j++ ) {\n                first[ i++ ] = second[ j ];\n            }\n\n            first.length = i;\n\n            return first;\n        },\n\n        grep: function( elems, callback, invert ) {\n            var callbackInverse,\n                matches = [],\n                i = 0,\n                length = elems.length,\n                callbackExpect = !invert;\n\n            // Go through the array, only saving the items\n            // that pass the validator function\n            for ( ; i < length; i++ ) {\n                callbackInverse = !callback( elems[ i ], i );\n                if ( callbackInverse !== callbackExpect ) {\n                    matches.push( elems[ i ] );\n                }\n            }\n\n            return matches;\n        },\n\n        // arg is for internal usage only\n        map: function( elems, callback, arg ) {\n            var length, value,\n                i = 0,\n                ret = [];\n\n            // Go through the array, translating each of the items to their new values\n            if ( isArrayLike( elems ) ) {\n                length = elems.length;\n                for ( ; i < length; i++ ) {\n                    value = callback( elems[ i ], i, arg );\n\n                    if ( value != null ) {\n                        ret.push( value );\n                    }\n                }\n\n                // Go through every key on the object,\n            } else {\n                for ( i in elems ) {\n                    value = callback( elems[ i ], i, arg );\n\n                    if ( value != null ) {\n                        ret.push( value );\n                    }\n                }\n            }\n\n            // Flatten any nested arrays\n            return flat( ret );\n        },\n\n        // A global GUID counter for objects\n        guid: 1,\n\n        // jQuery.support is not used in Core but other projects attach their\n        // properties to it so it needs to exist.\n        support: support\n    } );\n\n    if ( typeof Symbol === \"function\" ) {\n        jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];\n    }\n\n// Populate the class2type map\n    jQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".split( \" \" ),\n        function( _i, name ) {\n            class2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n        } );\n\n    function isArrayLike( obj ) {\n\n        // Support: real iOS 8.2 only (not reproducible in simulator)\n        // `in` check used to prevent JIT error (gh-2145)\n        // hasOwn isn't used here due to false negatives\n        // regarding Nodelist length in IE\n        var length = !!obj && \"length\" in obj && obj.length,\n            type = toType( obj );\n\n        if ( isFunction( obj ) || isWindow( obj ) ) {\n            return false;\n        }\n\n        return type === \"array\" || length === 0 ||\n            typeof length === \"number\" && length > 0 && ( length - 1 ) in obj;\n    }\n\n\n    function nodeName( elem, name ) {\n\n        return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();\n\n    }\n    var pop = arr.pop;\n\n\n    var sort = arr.sort;\n\n\n    var splice = arr.splice;\n\n\n    var whitespace = \"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\";\n\n\n    var rtrimCSS = new RegExp(\n        \"^\" + whitespace + \"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\" + whitespace + \"+$\",\n        \"g\"\n    );\n\n\n\n\n// Note: an element does not contain itself\n    jQuery.contains = function( a, b ) {\n        var bup = b && b.parentNode;\n\n        return a === bup || !!( bup && bup.nodeType === 1 && (\n\n            // Support: IE 9 - 11+\n            // IE doesn't have `contains` on SVG.\n            a.contains ?\n                a.contains( bup ) :\n                a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16\n        ) );\n    };\n\n\n\n\n// CSS string/identifier serialization\n// https://drafts.csswg.org/cssom/#common-serializing-idioms\n    var rcssescape = /([\\0-\\x1f\\x7f]|^-?\\d)|^-$|[^\\x80-\\uFFFF\\w-]/g;\n\n    function fcssescape( ch, asCodePoint ) {\n        if ( asCodePoint ) {\n\n            // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER\n            if ( ch === \"\\0\" ) {\n                return \"\\uFFFD\";\n            }\n\n            // Control characters and (dependent upon position) numbers get escaped as code points\n            return ch.slice( 0, -1 ) + \"\\\\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + \" \";\n        }\n\n        // Other potentially-special ASCII characters get backslash-escaped\n        return \"\\\\\" + ch;\n    }\n\n    jQuery.escapeSelector = function( sel ) {\n        return ( sel + \"\" ).replace( rcssescape, fcssescape );\n    };\n\n\n\n\n    var preferredDoc = document,\n        pushNative = push;\n\n    ( function() {\n\n        var i,\n            Expr,\n            outermostContext,\n            sortInput,\n            hasDuplicate,\n            push = pushNative,\n\n            // Local document vars\n            document,\n            documentElement,\n            documentIsHTML,\n            rbuggyQSA,\n            matches,\n\n            // Instance-specific data\n            expando = jQuery.expando,\n            dirruns = 0,\n            done = 0,\n            classCache = createCache(),\n            tokenCache = createCache(),\n            compilerCache = createCache(),\n            nonnativeSelectorCache = createCache(),\n            sortOrder = function( a, b ) {\n                if ( a === b ) {\n                    hasDuplicate = true;\n                }\n                return 0;\n            },\n\n            booleans = \"checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|\" +\n                \"loop|multiple|open|readonly|required|scoped\",\n\n            // Regular expressions\n\n            // https://www.w3.org/TR/css-syntax-3/#ident-token-diagram\n            identifier = \"(?:\\\\\\\\[\\\\da-fA-F]{1,6}\" + whitespace +\n                \"?|\\\\\\\\[^\\\\r\\\\n\\\\f]|[\\\\w-]|[^\\0-\\\\x7f])+\",\n\n            // Attribute selectors: https://www.w3.org/TR/selectors/#attribute-selectors\n            attributes = \"\\\\[\" + whitespace + \"*(\" + identifier + \")(?:\" + whitespace +\n\n                // Operator (capture 2)\n                \"*([*^$|!~]?=)\" + whitespace +\n\n                // \"Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]\"\n                \"*(?:'((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\"|(\" + identifier + \"))|)\" +\n                whitespace + \"*\\\\]\",\n\n            pseudos = \":(\" + identifier + \")(?:\\\\((\" +\n\n                // To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:\n                // 1. quoted (capture 3; capture 4 or capture 5)\n                \"('((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\")|\" +\n\n                // 2. simple (capture 6)\n                \"((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\" + attributes + \")*)|\" +\n\n                // 3. anything else (capture 2)\n                \".*\" +\n                \")\\\\)|)\",\n\n            // Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter\n            rwhitespace = new RegExp( whitespace + \"+\", \"g\" ),\n\n            rcomma = new RegExp( \"^\" + whitespace + \"*,\" + whitespace + \"*\" ),\n            rleadingCombinator = new RegExp( \"^\" + whitespace + \"*([>+~]|\" + whitespace + \")\" +\n                whitespace + \"*\" ),\n            rdescend = new RegExp( whitespace + \"|>\" ),\n\n            rpseudo = new RegExp( pseudos ),\n            ridentifier = new RegExp( \"^\" + identifier + \"$\" ),\n\n            matchExpr = {\n                ID: new RegExp( \"^#(\" + identifier + \")\" ),\n                CLASS: new RegExp( \"^\\\\.(\" + identifier + \")\" ),\n                TAG: new RegExp( \"^(\" + identifier + \"|[*])\" ),\n                ATTR: new RegExp( \"^\" + attributes ),\n                PSEUDO: new RegExp( \"^\" + pseudos ),\n                CHILD: new RegExp(\n                    \"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\" +\n                    whitespace + \"*(even|odd|(([+-]|)(\\\\d*)n|)\" + whitespace + \"*(?:([+-]|)\" +\n                    whitespace + \"*(\\\\d+)|))\" + whitespace + \"*\\\\)|)\", \"i\" ),\n                bool: new RegExp( \"^(?:\" + booleans + \")$\", \"i\" ),\n\n                // For use in libraries implementing .is()\n                // We use this for POS matching in `select`\n                needsContext: new RegExp( \"^\" + whitespace +\n                    \"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\" + whitespace +\n                    \"*((?:-\\\\d)?\\\\d*)\" + whitespace + \"*\\\\)|)(?=[^-]|$)\", \"i\" )\n            },\n\n            rinputs = /^(?:input|select|textarea|button)$/i,\n            rheader = /^h\\d$/i,\n\n            // Easily-parseable/retrievable ID or TAG or CLASS selectors\n            rquickExpr = /^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,\n\n            rsibling = /[+~]/,\n\n            // CSS escapes\n            // https://www.w3.org/TR/CSS21/syndata.html#escaped-characters\n            runescape = new RegExp( \"\\\\\\\\[\\\\da-fA-F]{1,6}\" + whitespace +\n                \"?|\\\\\\\\([^\\\\r\\\\n\\\\f])\", \"g\" ),\n            funescape = function( escape, nonHex ) {\n                var high = \"0x\" + escape.slice( 1 ) - 0x10000;\n\n                if ( nonHex ) {\n\n                    // Strip the backslash prefix from a non-hex escape sequence\n                    return nonHex;\n                }\n\n                // Replace a hexadecimal escape sequence with the encoded Unicode code point\n                // Support: IE <=11+\n                // For values outside the Basic Multilingual Plane (BMP), manually construct a\n                // surrogate pair\n                return high < 0 ?\n                    String.fromCharCode( high + 0x10000 ) :\n                    String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );\n            },\n\n            // Used for iframes; see `setDocument`.\n            // Support: IE 9 - 11+, Edge 12 - 18+\n            // Removing the function wrapper causes a \"Permission Denied\"\n            // error in IE/Edge.\n            unloadHandler = function() {\n                setDocument();\n            },\n\n            inDisabledFieldset = addCombinator(\n                function( elem ) {\n                    return elem.disabled === true && nodeName( elem, \"fieldset\" );\n                },\n                { dir: \"parentNode\", next: \"legend\" }\n            );\n\n// Support: IE <=9 only\n// Accessing document.activeElement can throw unexpectedly\n// https://bugs.jquery.com/ticket/13393\n        function safeActiveElement() {\n            try {\n                return document.activeElement;\n            } catch ( err ) { }\n        }\n\n// Optimize for push.apply( _, NodeList )\n        try {\n            push.apply(\n                ( arr = slice.call( preferredDoc.childNodes ) ),\n                preferredDoc.childNodes\n            );\n\n            // Support: Android <=4.0\n            // Detect silently failing push.apply\n            // eslint-disable-next-line no-unused-expressions\n            arr[ preferredDoc.childNodes.length ].nodeType;\n        } catch ( e ) {\n            push = {\n                apply: function( target, els ) {\n                    pushNative.apply( target, slice.call( els ) );\n                },\n                call: function( target ) {\n                    pushNative.apply( target, slice.call( arguments, 1 ) );\n                }\n            };\n        }\n\n        function find( selector, context, results, seed ) {\n            var m, i, elem, nid, match, groups, newSelector,\n                newContext = context && context.ownerDocument,\n\n                // nodeType defaults to 9, since context defaults to document\n                nodeType = context ? context.nodeType : 9;\n\n            results = results || [];\n\n            // Return early from calls with invalid selector or context\n            if ( typeof selector !== \"string\" || !selector ||\n                nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {\n\n                return results;\n            }\n\n            // Try to shortcut find operations (as opposed to filters) in HTML documents\n            if ( !seed ) {\n                setDocument( context );\n                context = context || document;\n\n                if ( documentIsHTML ) {\n\n                    // If the selector is sufficiently simple, try using a \"get*By*\" DOM method\n                    // (excepting DocumentFragment context, where the methods don't exist)\n                    if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {\n\n                        // ID selector\n                        if ( ( m = match[ 1 ] ) ) {\n\n                            // Document context\n                            if ( nodeType === 9 ) {\n                                if ( ( elem = context.getElementById( m ) ) ) {\n\n                                    // Support: IE 9 only\n                                    // getElementById can match elements by name instead of ID\n                                    if ( elem.id === m ) {\n                                        push.call( results, elem );\n                                        return results;\n                                    }\n                                } else {\n                                    return results;\n                                }\n\n                                // Element context\n                            } else {\n\n                                // Support: IE 9 only\n                                // getElementById can match elements by name instead of ID\n                                if ( newContext && ( elem = newContext.getElementById( m ) ) &&\n                                    find.contains( context, elem ) &&\n                                    elem.id === m ) {\n\n                                    push.call( results, elem );\n                                    return results;\n                                }\n                            }\n\n                            // Type selector\n                        } else if ( match[ 2 ] ) {\n                            push.apply( results, context.getElementsByTagName( selector ) );\n                            return results;\n\n                            // Class selector\n                        } else if ( ( m = match[ 3 ] ) && context.getElementsByClassName ) {\n                            push.apply( results, context.getElementsByClassName( m ) );\n                            return results;\n                        }\n                    }\n\n                    // Take advantage of querySelectorAll\n                    if ( !nonnativeSelectorCache[ selector + \" \" ] &&\n                        ( !rbuggyQSA || !rbuggyQSA.test( selector ) ) ) {\n\n                        newSelector = selector;\n                        newContext = context;\n\n                        // qSA considers elements outside a scoping root when evaluating child or\n                        // descendant combinators, which is not what we want.\n                        // In such cases, we work around the behavior by prefixing every selector in the\n                        // list with an ID selector referencing the scope context.\n                        // The technique has to be used as well when a leading combinator is used\n                        // as such selectors are not recognized by querySelectorAll.\n                        // Thanks to Andrew Dupont for this technique.\n                        if ( nodeType === 1 &&\n                            ( rdescend.test( selector ) || rleadingCombinator.test( selector ) ) ) {\n\n                            // Expand context for sibling selectors\n                            newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||\n                                context;\n\n                            // We can use :scope instead of the ID hack if the browser\n                            // supports it & if we're not changing the context.\n                            // Support: IE 11+, Edge 17 - 18+\n                            // IE/Edge sometimes throw a \"Permission denied\" error when\n                            // strict-comparing two documents; shallow comparisons work.\n                            // eslint-disable-next-line eqeqeq\n                            if ( newContext != context || !support.scope ) {\n\n                                // Capture the context ID, setting it first if necessary\n                                if ( ( nid = context.getAttribute( \"id\" ) ) ) {\n                                    nid = jQuery.escapeSelector( nid );\n                                } else {\n                                    context.setAttribute( \"id\", ( nid = expando ) );\n                                }\n                            }\n\n                            // Prefix every selector in the list\n                            groups = tokenize( selector );\n                            i = groups.length;\n                            while ( i-- ) {\n                                groups[ i ] = ( nid ? \"#\" + nid : \":scope\" ) + \" \" +\n                                    toSelector( groups[ i ] );\n                            }\n                            newSelector = groups.join( \",\" );\n                        }\n\n                        try {\n                            push.apply( results,\n                                newContext.querySelectorAll( newSelector )\n                            );\n                            return results;\n                        } catch ( qsaError ) {\n                            nonnativeSelectorCache( selector, true );\n                        } finally {\n                            if ( nid === expando ) {\n                                context.removeAttribute( \"id\" );\n                            }\n                        }\n                    }\n                }\n            }\n\n            // All others\n            return select( selector.replace( rtrimCSS, \"$1\" ), context, results, seed );\n        }\n\n        /**\n         * Create key-value caches of limited size\n         * @returns {function(string, object)} Returns the Object data after storing it on itself with\n         *\tproperty name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)\n         *\tdeleting the oldest entry\n         */\n        function createCache() {\n            var keys = [];\n\n            function cache( key, value ) {\n\n                // Use (key + \" \") to avoid collision with native prototype properties\n                // (see https://github.com/jquery/sizzle/issues/157)\n                if ( keys.push( key + \" \" ) > Expr.cacheLength ) {\n\n                    // Only keep the most recent entries\n                    delete cache[ keys.shift() ];\n                }\n                return ( cache[ key + \" \" ] = value );\n            }\n            return cache;\n        }\n\n        /**\n         * Mark a function for special use by jQuery selector module\n         * @param {Function} fn The function to mark\n         */\n        function markFunction( fn ) {\n            fn[ expando ] = true;\n            return fn;\n        }\n\n        /**\n         * Support testing using an element\n         * @param {Function} fn Passed the created element and returns a boolean result\n         */\n        function assert( fn ) {\n            var el = document.createElement( \"fieldset\" );\n\n            try {\n                return !!fn( el );\n            } catch ( e ) {\n                return false;\n            } finally {\n\n                // Remove from its parent by default\n                if ( el.parentNode ) {\n                    el.parentNode.removeChild( el );\n                }\n\n                // release memory in IE\n                el = null;\n            }\n        }\n\n        /**\n         * Returns a function to use in pseudos for input types\n         * @param {String} type\n         */\n        function createInputPseudo( type ) {\n            return function( elem ) {\n                return nodeName( elem, \"input\" ) && elem.type === type;\n            };\n        }\n\n        /**\n         * Returns a function to use in pseudos for buttons\n         * @param {String} type\n         */\n        function createButtonPseudo( type ) {\n            return function( elem ) {\n                return ( nodeName( elem, \"input\" ) || nodeName( elem, \"button\" ) ) &&\n                    elem.type === type;\n            };\n        }\n\n        /**\n         * Returns a function to use in pseudos for :enabled/:disabled\n         * @param {Boolean} disabled true for :disabled; false for :enabled\n         */\n        function createDisabledPseudo( disabled ) {\n\n            // Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable\n            return function( elem ) {\n\n                // Only certain elements can match :enabled or :disabled\n                // https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled\n                // https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled\n                if ( \"form\" in elem ) {\n\n                    // Check for inherited disabledness on relevant non-disabled elements:\n                    // * listed form-associated elements in a disabled fieldset\n                    //   https://html.spec.whatwg.org/multipage/forms.html#category-listed\n                    //   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled\n                    // * option elements in a disabled optgroup\n                    //   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled\n                    // All such elements have a \"form\" property.\n                    if ( elem.parentNode && elem.disabled === false ) {\n\n                        // Option elements defer to a parent optgroup if present\n                        if ( \"label\" in elem ) {\n                            if ( \"label\" in elem.parentNode ) {\n                                return elem.parentNode.disabled === disabled;\n                            } else {\n                                return elem.disabled === disabled;\n                            }\n                        }\n\n                        // Support: IE 6 - 11+\n                        // Use the isDisabled shortcut property to check for disabled fieldset ancestors\n                        return elem.isDisabled === disabled ||\n\n                            // Where there is no isDisabled, check manually\n                            elem.isDisabled !== !disabled &&\n                            inDisabledFieldset( elem ) === disabled;\n                    }\n\n                    return elem.disabled === disabled;\n\n                    // Try to winnow out elements that can't be disabled before trusting the disabled property.\n                    // Some victims get caught in our net (label, legend, menu, track), but it shouldn't\n                    // even exist on them, let alone have a boolean value.\n                } else if ( \"label\" in elem ) {\n                    return elem.disabled === disabled;\n                }\n\n                // Remaining elements are neither :enabled nor :disabled\n                return false;\n            };\n        }\n\n        /**\n         * Returns a function to use in pseudos for positionals\n         * @param {Function} fn\n         */\n        function createPositionalPseudo( fn ) {\n            return markFunction( function( argument ) {\n                argument = +argument;\n                return markFunction( function( seed, matches ) {\n                    var j,\n                        matchIndexes = fn( [], seed.length, argument ),\n                        i = matchIndexes.length;\n\n                    // Match elements found at the specified indexes\n                    while ( i-- ) {\n                        if ( seed[ ( j = matchIndexes[ i ] ) ] ) {\n                            seed[ j ] = !( matches[ j ] = seed[ j ] );\n                        }\n                    }\n                } );\n            } );\n        }\n\n        /**\n         * Checks a node for validity as a jQuery selector context\n         * @param {Element|Object=} context\n         * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value\n         */\n        function testContext( context ) {\n            return context && typeof context.getElementsByTagName !== \"undefined\" && context;\n        }\n\n        /**\n         * Sets document-related variables once based on the current document\n         * @param {Element|Object} [node] An element or document object to use to set the document\n         * @returns {Object} Returns the current document\n         */\n        function setDocument( node ) {\n            var subWindow,\n                doc = node ? node.ownerDocument || node : preferredDoc;\n\n            // Return early if doc is invalid or already selected\n            // Support: IE 11+, Edge 17 - 18+\n            // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n            // two documents; shallow comparisons work.\n            // eslint-disable-next-line eqeqeq\n            if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {\n                return document;\n            }\n\n            // Update global variables\n            document = doc;\n            documentElement = document.documentElement;\n            documentIsHTML = !jQuery.isXMLDoc( document );\n\n            // Support: iOS 7 only, IE 9 - 11+\n            // Older browsers didn't support unprefixed `matches`.\n            matches = documentElement.matches ||\n                documentElement.webkitMatchesSelector ||\n                documentElement.msMatchesSelector;\n\n            // Support: IE 9 - 11+, Edge 12 - 18+\n            // Accessing iframe documents after unload throws \"permission denied\" errors\n            // (see trac-13936).\n            // Limit the fix to IE & Edge Legacy; despite Edge 15+ implementing `matches`,\n            // all IE 9+ and Edge Legacy versions implement `msMatchesSelector` as well.\n            if ( documentElement.msMatchesSelector &&\n\n                // Support: IE 11+, Edge 17 - 18+\n                // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                // two documents; shallow comparisons work.\n                // eslint-disable-next-line eqeqeq\n                preferredDoc != document &&\n                ( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {\n\n                // Support: IE 9 - 11+, Edge 12 - 18+\n                subWindow.addEventListener( \"unload\", unloadHandler );\n            }\n\n            // Support: IE <10\n            // Check if getElementById returns elements by name\n            // The broken getElementById methods don't pick up programmatically-set names,\n            // so use a roundabout getElementsByName test\n            support.getById = assert( function( el ) {\n                documentElement.appendChild( el ).id = jQuery.expando;\n                return !document.getElementsByName ||\n                    !document.getElementsByName( jQuery.expando ).length;\n            } );\n\n            // Support: IE 9 only\n            // Check to see if it's possible to do matchesSelector\n            // on a disconnected node.\n            support.disconnectedMatch = assert( function( el ) {\n                return matches.call( el, \"*\" );\n            } );\n\n            // Support: IE 9 - 11+, Edge 12 - 18+\n            // IE/Edge don't support the :scope pseudo-class.\n            support.scope = assert( function() {\n                return document.querySelectorAll( \":scope\" );\n            } );\n\n            // Support: Chrome 105 - 111 only, Safari 15.4 - 16.3 only\n            // Make sure the `:has()` argument is parsed unforgivingly.\n            // We include `*` in the test to detect buggy implementations that are\n            // _selectively_ forgiving (specifically when the list includes at least\n            // one valid selector).\n            // Note that we treat complete lack of support for `:has()` as if it were\n            // spec-compliant support, which is fine because use of `:has()` in such\n            // environments will fail in the qSA path and fall back to jQuery traversal\n            // anyway.\n            support.cssHas = assert( function() {\n                try {\n                    document.querySelector( \":has(*,:jqfake)\" );\n                    return false;\n                } catch ( e ) {\n                    return true;\n                }\n            } );\n\n            // ID filter and find\n            if ( support.getById ) {\n                Expr.filter.ID = function( id ) {\n                    var attrId = id.replace( runescape, funescape );\n                    return function( elem ) {\n                        return elem.getAttribute( \"id\" ) === attrId;\n                    };\n                };\n                Expr.find.ID = function( id, context ) {\n                    if ( typeof context.getElementById !== \"undefined\" && documentIsHTML ) {\n                        var elem = context.getElementById( id );\n                        return elem ? [ elem ] : [];\n                    }\n                };\n            } else {\n                Expr.filter.ID =  function( id ) {\n                    var attrId = id.replace( runescape, funescape );\n                    return function( elem ) {\n                        var node = typeof elem.getAttributeNode !== \"undefined\" &&\n                            elem.getAttributeNode( \"id\" );\n                        return node && node.value === attrId;\n                    };\n                };\n\n                // Support: IE 6 - 7 only\n                // getElementById is not reliable as a find shortcut\n                Expr.find.ID = function( id, context ) {\n                    if ( typeof context.getElementById !== \"undefined\" && documentIsHTML ) {\n                        var node, i, elems,\n                            elem = context.getElementById( id );\n\n                        if ( elem ) {\n\n                            // Verify the id attribute\n                            node = elem.getAttributeNode( \"id\" );\n                            if ( node && node.value === id ) {\n                                return [ elem ];\n                            }\n\n                            // Fall back on getElementsByName\n                            elems = context.getElementsByName( id );\n                            i = 0;\n                            while ( ( elem = elems[ i++ ] ) ) {\n                                node = elem.getAttributeNode( \"id\" );\n                                if ( node && node.value === id ) {\n                                    return [ elem ];\n                                }\n                            }\n                        }\n\n                        return [];\n                    }\n                };\n            }\n\n            // Tag\n            Expr.find.TAG = function( tag, context ) {\n                if ( typeof context.getElementsByTagName !== \"undefined\" ) {\n                    return context.getElementsByTagName( tag );\n\n                    // DocumentFragment nodes don't have gEBTN\n                } else {\n                    return context.querySelectorAll( tag );\n                }\n            };\n\n            // Class\n            Expr.find.CLASS = function( className, context ) {\n                if ( typeof context.getElementsByClassName !== \"undefined\" && documentIsHTML ) {\n                    return context.getElementsByClassName( className );\n                }\n            };\n\n            /* QSA/matchesSelector\n\t---------------------------------------------------------------------- */\n\n            // QSA and matchesSelector support\n\n            rbuggyQSA = [];\n\n            // Build QSA regex\n            // Regex strategy adopted from Diego Perini\n            assert( function( el ) {\n\n                var input;\n\n                documentElement.appendChild( el ).innerHTML =\n                    \"<a id='\" + expando + \"' href='' disabled='disabled'></a>\" +\n                    \"<select id='\" + expando + \"-\\r\\\\' disabled='disabled'>\" +\n                    \"<option selected=''></option></select>\";\n\n                // Support: iOS <=7 - 8 only\n                // Boolean attributes and \"value\" are not treated correctly in some XML documents\n                if ( !el.querySelectorAll( \"[selected]\" ).length ) {\n                    rbuggyQSA.push( \"\\\\[\" + whitespace + \"*(?:value|\" + booleans + \")\" );\n                }\n\n                // Support: iOS <=7 - 8 only\n                if ( !el.querySelectorAll( \"[id~=\" + expando + \"-]\" ).length ) {\n                    rbuggyQSA.push( \"~=\" );\n                }\n\n                // Support: iOS 8 only\n                // https://bugs.webkit.org/show_bug.cgi?id=136851\n                // In-page `selector#id sibling-combinator selector` fails\n                if ( !el.querySelectorAll( \"a#\" + expando + \"+*\" ).length ) {\n                    rbuggyQSA.push( \".#.+[+~]\" );\n                }\n\n                // Support: Chrome <=105+, Firefox <=104+, Safari <=15.4+\n                // In some of the document kinds, these selectors wouldn't work natively.\n                // This is probably OK but for backwards compatibility we want to maintain\n                // handling them through jQuery traversal in jQuery 3.x.\n                if ( !el.querySelectorAll( \":checked\" ).length ) {\n                    rbuggyQSA.push( \":checked\" );\n                }\n\n                // Support: Windows 8 Native Apps\n                // The type and name attributes are restricted during .innerHTML assignment\n                input = document.createElement( \"input\" );\n                input.setAttribute( \"type\", \"hidden\" );\n                el.appendChild( input ).setAttribute( \"name\", \"D\" );\n\n                // Support: IE 9 - 11+\n                // IE's :disabled selector does not pick up the children of disabled fieldsets\n                // Support: Chrome <=105+, Firefox <=104+, Safari <=15.4+\n                // In some of the document kinds, these selectors wouldn't work natively.\n                // This is probably OK but for backwards compatibility we want to maintain\n                // handling them through jQuery traversal in jQuery 3.x.\n                documentElement.appendChild( el ).disabled = true;\n                if ( el.querySelectorAll( \":disabled\" ).length !== 2 ) {\n                    rbuggyQSA.push( \":enabled\", \":disabled\" );\n                }\n\n                // Support: IE 11+, Edge 15 - 18+\n                // IE 11/Edge don't find elements on a `[name='']` query in some cases.\n                // Adding a temporary attribute to the document before the selection works\n                // around the issue.\n                // Interestingly, IE 10 & older don't seem to have the issue.\n                input = document.createElement( \"input\" );\n                input.setAttribute( \"name\", \"\" );\n                el.appendChild( input );\n                if ( !el.querySelectorAll( \"[name='']\" ).length ) {\n                    rbuggyQSA.push( \"\\\\[\" + whitespace + \"*name\" + whitespace + \"*=\" +\n                        whitespace + \"*(?:''|\\\"\\\")\" );\n                }\n            } );\n\n            if ( !support.cssHas ) {\n\n                // Support: Chrome 105 - 110+, Safari 15.4 - 16.3+\n                // Our regular `try-catch` mechanism fails to detect natively-unsupported\n                // pseudo-classes inside `:has()` (such as `:has(:contains(\"Foo\"))`)\n                // in browsers that parse the `:has()` argument as a forgiving selector list.\n                // https://drafts.csswg.org/selectors/#relational now requires the argument\n                // to be parsed unforgivingly, but browsers have not yet fully adjusted.\n                rbuggyQSA.push( \":has\" );\n            }\n\n            rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( \"|\" ) );\n\n            /* Sorting\n\t---------------------------------------------------------------------- */\n\n            // Document order sorting\n            sortOrder = function( a, b ) {\n\n                // Flag for duplicate removal\n                if ( a === b ) {\n                    hasDuplicate = true;\n                    return 0;\n                }\n\n                // Sort on method existence if only one input has compareDocumentPosition\n                var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;\n                if ( compare ) {\n                    return compare;\n                }\n\n                // Calculate position if both inputs belong to the same document\n                // Support: IE 11+, Edge 17 - 18+\n                // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                // two documents; shallow comparisons work.\n                // eslint-disable-next-line eqeqeq\n                compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?\n                    a.compareDocumentPosition( b ) :\n\n                    // Otherwise we know they are disconnected\n                    1;\n\n                // Disconnected nodes\n                if ( compare & 1 ||\n                    ( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {\n\n                    // Choose the first element that is related to our preferred document\n                    // Support: IE 11+, Edge 17 - 18+\n                    // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                    // two documents; shallow comparisons work.\n                    // eslint-disable-next-line eqeqeq\n                    if ( a === document || a.ownerDocument == preferredDoc &&\n                        find.contains( preferredDoc, a ) ) {\n                        return -1;\n                    }\n\n                    // Support: IE 11+, Edge 17 - 18+\n                    // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                    // two documents; shallow comparisons work.\n                    // eslint-disable-next-line eqeqeq\n                    if ( b === document || b.ownerDocument == preferredDoc &&\n                        find.contains( preferredDoc, b ) ) {\n                        return 1;\n                    }\n\n                    // Maintain original order\n                    return sortInput ?\n                        ( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :\n                        0;\n                }\n\n                return compare & 4 ? -1 : 1;\n            };\n\n            return document;\n        }\n\n        find.matches = function( expr, elements ) {\n            return find( expr, null, null, elements );\n        };\n\n        find.matchesSelector = function( elem, expr ) {\n            setDocument( elem );\n\n            if ( documentIsHTML &&\n                !nonnativeSelectorCache[ expr + \" \" ] &&\n                ( !rbuggyQSA || !rbuggyQSA.test( expr ) ) ) {\n\n                try {\n                    var ret = matches.call( elem, expr );\n\n                    // IE 9's matchesSelector returns false on disconnected nodes\n                    if ( ret || support.disconnectedMatch ||\n\n                        // As well, disconnected nodes are said to be in a document\n                        // fragment in IE 9\n                        elem.document && elem.document.nodeType !== 11 ) {\n                        return ret;\n                    }\n                } catch ( e ) {\n                    nonnativeSelectorCache( expr, true );\n                }\n            }\n\n            return find( expr, document, null, [ elem ] ).length > 0;\n        };\n\n        find.contains = function( context, elem ) {\n\n            // Set document vars if needed\n            // Support: IE 11+, Edge 17 - 18+\n            // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n            // two documents; shallow comparisons work.\n            // eslint-disable-next-line eqeqeq\n            if ( ( context.ownerDocument || context ) != document ) {\n                setDocument( context );\n            }\n            return jQuery.contains( context, elem );\n        };\n\n\n        find.attr = function( elem, name ) {\n\n            // Set document vars if needed\n            // Support: IE 11+, Edge 17 - 18+\n            // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n            // two documents; shallow comparisons work.\n            // eslint-disable-next-line eqeqeq\n            if ( ( elem.ownerDocument || elem ) != document ) {\n                setDocument( elem );\n            }\n\n            var fn = Expr.attrHandle[ name.toLowerCase() ],\n\n                // Don't get fooled by Object.prototype properties (see trac-13807)\n                val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?\n                    fn( elem, name, !documentIsHTML ) :\n                    undefined;\n\n            if ( val !== undefined ) {\n                return val;\n            }\n\n            return elem.getAttribute( name );\n        };\n\n        find.error = function( msg ) {\n            throw new Error( \"Syntax error, unrecognized expression: \" + msg );\n        };\n\n        /**\n         * Document sorting and removing duplicates\n         * @param {ArrayLike} results\n         */\n        jQuery.uniqueSort = function( results ) {\n            var elem,\n                duplicates = [],\n                j = 0,\n                i = 0;\n\n            // Unless we *know* we can detect duplicates, assume their presence\n            //\n            // Support: Android <=4.0+\n            // Testing for detecting duplicates is unpredictable so instead assume we can't\n            // depend on duplicate detection in all browsers without a stable sort.\n            hasDuplicate = !support.sortStable;\n            sortInput = !support.sortStable && slice.call( results, 0 );\n            sort.call( results, sortOrder );\n\n            if ( hasDuplicate ) {\n                while ( ( elem = results[ i++ ] ) ) {\n                    if ( elem === results[ i ] ) {\n                        j = duplicates.push( i );\n                    }\n                }\n                while ( j-- ) {\n                    splice.call( results, duplicates[ j ], 1 );\n                }\n            }\n\n            // Clear input after sorting to release objects\n            // See https://github.com/jquery/sizzle/pull/225\n            sortInput = null;\n\n            return results;\n        };\n\n        jQuery.fn.uniqueSort = function() {\n            return this.pushStack( jQuery.uniqueSort( slice.apply( this ) ) );\n        };\n\n        Expr = jQuery.expr = {\n\n            // Can be adjusted by the user\n            cacheLength: 50,\n\n            createPseudo: markFunction,\n\n            match: matchExpr,\n\n            attrHandle: {},\n\n            find: {},\n\n            relative: {\n                \">\": { dir: \"parentNode\", first: true },\n                \" \": { dir: \"parentNode\" },\n                \"+\": { dir: \"previousSibling\", first: true },\n                \"~\": { dir: \"previousSibling\" }\n            },\n\n            preFilter: {\n                ATTR: function( match ) {\n                    match[ 1 ] = match[ 1 ].replace( runescape, funescape );\n\n                    // Move the given value to match[3] whether quoted or unquoted\n                    match[ 3 ] = ( match[ 3 ] || match[ 4 ] || match[ 5 ] || \"\" )\n                        .replace( runescape, funescape );\n\n                    if ( match[ 2 ] === \"~=\" ) {\n                        match[ 3 ] = \" \" + match[ 3 ] + \" \";\n                    }\n\n                    return match.slice( 0, 4 );\n                },\n\n                CHILD: function( match ) {\n\n                    /* matches from matchExpr[\"CHILD\"]\n\t\t\t\t1 type (only|nth|...)\n\t\t\t\t2 what (child|of-type)\n\t\t\t\t3 argument (even|odd|\\d*|\\d*n([+-]\\d+)?|...)\n\t\t\t\t4 xn-component of xn+y argument ([+-]?\\d*n|)\n\t\t\t\t5 sign of xn-component\n\t\t\t\t6 x of xn-component\n\t\t\t\t7 sign of y-component\n\t\t\t\t8 y of y-component\n\t\t\t*/\n                    match[ 1 ] = match[ 1 ].toLowerCase();\n\n                    if ( match[ 1 ].slice( 0, 3 ) === \"nth\" ) {\n\n                        // nth-* requires argument\n                        if ( !match[ 3 ] ) {\n                            find.error( match[ 0 ] );\n                        }\n\n                        // numeric x and y parameters for Expr.filter.CHILD\n                        // remember that false/true cast respectively to 0/1\n                        match[ 4 ] = +( match[ 4 ] ?\n                                match[ 5 ] + ( match[ 6 ] || 1 ) :\n                                2 * ( match[ 3 ] === \"even\" || match[ 3 ] === \"odd\" )\n                        );\n                        match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === \"odd\" );\n\n                        // other types prohibit arguments\n                    } else if ( match[ 3 ] ) {\n                        find.error( match[ 0 ] );\n                    }\n\n                    return match;\n                },\n\n                PSEUDO: function( match ) {\n                    var excess,\n                        unquoted = !match[ 6 ] && match[ 2 ];\n\n                    if ( matchExpr.CHILD.test( match[ 0 ] ) ) {\n                        return null;\n                    }\n\n                    // Accept quoted arguments as-is\n                    if ( match[ 3 ] ) {\n                        match[ 2 ] = match[ 4 ] || match[ 5 ] || \"\";\n\n                        // Strip excess characters from unquoted arguments\n                    } else if ( unquoted && rpseudo.test( unquoted ) &&\n\n                        // Get excess from tokenize (recursively)\n                        ( excess = tokenize( unquoted, true ) ) &&\n\n                        // advance to the next closing parenthesis\n                        ( excess = unquoted.indexOf( \")\", unquoted.length - excess ) - unquoted.length ) ) {\n\n                        // excess is a negative index\n                        match[ 0 ] = match[ 0 ].slice( 0, excess );\n                        match[ 2 ] = unquoted.slice( 0, excess );\n                    }\n\n                    // Return only captures needed by the pseudo filter method (type and argument)\n                    return match.slice( 0, 3 );\n                }\n            },\n\n            filter: {\n\n                TAG: function( nodeNameSelector ) {\n                    var expectedNodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();\n                    return nodeNameSelector === \"*\" ?\n                        function() {\n                            return true;\n                        } :\n                        function( elem ) {\n                            return nodeName( elem, expectedNodeName );\n                        };\n                },\n\n                CLASS: function( className ) {\n                    var pattern = classCache[ className + \" \" ];\n\n                    return pattern ||\n                        ( pattern = new RegExp( \"(^|\" + whitespace + \")\" + className +\n                            \"(\" + whitespace + \"|$)\" ) ) &&\n                        classCache( className, function( elem ) {\n                            return pattern.test(\n                                typeof elem.className === \"string\" && elem.className ||\n                                typeof elem.getAttribute !== \"undefined\" &&\n                                elem.getAttribute( \"class\" ) ||\n                                \"\"\n                            );\n                        } );\n                },\n\n                ATTR: function( name, operator, check ) {\n                    return function( elem ) {\n                        var result = find.attr( elem, name );\n\n                        if ( result == null ) {\n                            return operator === \"!=\";\n                        }\n                        if ( !operator ) {\n                            return true;\n                        }\n\n                        result += \"\";\n\n                        if ( operator === \"=\" ) {\n                            return result === check;\n                        }\n                        if ( operator === \"!=\" ) {\n                            return result !== check;\n                        }\n                        if ( operator === \"^=\" ) {\n                            return check && result.indexOf( check ) === 0;\n                        }\n                        if ( operator === \"*=\" ) {\n                            return check && result.indexOf( check ) > -1;\n                        }\n                        if ( operator === \"$=\" ) {\n                            return check && result.slice( -check.length ) === check;\n                        }\n                        if ( operator === \"~=\" ) {\n                            return ( \" \" + result.replace( rwhitespace, \" \" ) + \" \" )\n                                .indexOf( check ) > -1;\n                        }\n                        if ( operator === \"|=\" ) {\n                            return result === check || result.slice( 0, check.length + 1 ) === check + \"-\";\n                        }\n\n                        return false;\n                    };\n                },\n\n                CHILD: function( type, what, _argument, first, last ) {\n                    var simple = type.slice( 0, 3 ) !== \"nth\",\n                        forward = type.slice( -4 ) !== \"last\",\n                        ofType = what === \"of-type\";\n\n                    return first === 1 && last === 0 ?\n\n                        // Shortcut for :nth-*(n)\n                        function( elem ) {\n                            return !!elem.parentNode;\n                        } :\n\n                        function( elem, _context, xml ) {\n                            var cache, outerCache, node, nodeIndex, start,\n                                dir = simple !== forward ? \"nextSibling\" : \"previousSibling\",\n                                parent = elem.parentNode,\n                                name = ofType && elem.nodeName.toLowerCase(),\n                                useCache = !xml && !ofType,\n                                diff = false;\n\n                            if ( parent ) {\n\n                                // :(first|last|only)-(child|of-type)\n                                if ( simple ) {\n                                    while ( dir ) {\n                                        node = elem;\n                                        while ( ( node = node[ dir ] ) ) {\n                                            if ( ofType ?\n                                                nodeName( node, name ) :\n                                                node.nodeType === 1 ) {\n\n                                                return false;\n                                            }\n                                        }\n\n                                        // Reverse direction for :only-* (if we haven't yet done so)\n                                        start = dir = type === \"only\" && !start && \"nextSibling\";\n                                    }\n                                    return true;\n                                }\n\n                                start = [ forward ? parent.firstChild : parent.lastChild ];\n\n                                // non-xml :nth-child(...) stores cache data on `parent`\n                                if ( forward && useCache ) {\n\n                                    // Seek `elem` from a previously-cached index\n                                    outerCache = parent[ expando ] || ( parent[ expando ] = {} );\n                                    cache = outerCache[ type ] || [];\n                                    nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n                                    diff = nodeIndex && cache[ 2 ];\n                                    node = nodeIndex && parent.childNodes[ nodeIndex ];\n\n                                    while ( ( node = ++nodeIndex && node && node[ dir ] ||\n\n                                        // Fallback to seeking `elem` from the start\n                                        ( diff = nodeIndex = 0 ) || start.pop() ) ) {\n\n                                        // When found, cache indexes on `parent` and break\n                                        if ( node.nodeType === 1 && ++diff && node === elem ) {\n                                            outerCache[ type ] = [ dirruns, nodeIndex, diff ];\n                                            break;\n                                        }\n                                    }\n\n                                } else {\n\n                                    // Use previously-cached element index if available\n                                    if ( useCache ) {\n                                        outerCache = elem[ expando ] || ( elem[ expando ] = {} );\n                                        cache = outerCache[ type ] || [];\n                                        nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n                                        diff = nodeIndex;\n                                    }\n\n                                    // xml :nth-child(...)\n                                    // or :nth-last-child(...) or :nth(-last)?-of-type(...)\n                                    if ( diff === false ) {\n\n                                        // Use the same loop as above to seek `elem` from the start\n                                        while ( ( node = ++nodeIndex && node && node[ dir ] ||\n                                            ( diff = nodeIndex = 0 ) || start.pop() ) ) {\n\n                                            if ( ( ofType ?\n                                                    nodeName( node, name ) :\n                                                    node.nodeType === 1 ) &&\n                                                ++diff ) {\n\n                                                // Cache the index of each encountered element\n                                                if ( useCache ) {\n                                                    outerCache = node[ expando ] ||\n                                                        ( node[ expando ] = {} );\n                                                    outerCache[ type ] = [ dirruns, diff ];\n                                                }\n\n                                                if ( node === elem ) {\n                                                    break;\n                                                }\n                                            }\n                                        }\n                                    }\n                                }\n\n                                // Incorporate the offset, then check against cycle size\n                                diff -= last;\n                                return diff === first || ( diff % first === 0 && diff / first >= 0 );\n                            }\n                        };\n                },\n\n                PSEUDO: function( pseudo, argument ) {\n\n                    // pseudo-class names are case-insensitive\n                    // https://www.w3.org/TR/selectors/#pseudo-classes\n                    // Prioritize by case sensitivity in case custom pseudos are added with uppercase letters\n                    // Remember that setFilters inherits from pseudos\n                    var args,\n                        fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||\n                            find.error( \"unsupported pseudo: \" + pseudo );\n\n                    // The user may use createPseudo to indicate that\n                    // arguments are needed to create the filter function\n                    // just as jQuery does\n                    if ( fn[ expando ] ) {\n                        return fn( argument );\n                    }\n\n                    // But maintain support for old signatures\n                    if ( fn.length > 1 ) {\n                        args = [ pseudo, pseudo, \"\", argument ];\n                        return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?\n                            markFunction( function( seed, matches ) {\n                                var idx,\n                                    matched = fn( seed, argument ),\n                                    i = matched.length;\n                                while ( i-- ) {\n                                    idx = indexOf.call( seed, matched[ i ] );\n                                    seed[ idx ] = !( matches[ idx ] = matched[ i ] );\n                                }\n                            } ) :\n                            function( elem ) {\n                                return fn( elem, 0, args );\n                            };\n                    }\n\n                    return fn;\n                }\n            },\n\n            pseudos: {\n\n                // Potentially complex pseudos\n                not: markFunction( function( selector ) {\n\n                    // Trim the selector passed to compile\n                    // to avoid treating leading and trailing\n                    // spaces as combinators\n                    var input = [],\n                        results = [],\n                        matcher = compile( selector.replace( rtrimCSS, \"$1\" ) );\n\n                    return matcher[ expando ] ?\n                        markFunction( function( seed, matches, _context, xml ) {\n                            var elem,\n                                unmatched = matcher( seed, null, xml, [] ),\n                                i = seed.length;\n\n                            // Match elements unmatched by `matcher`\n                            while ( i-- ) {\n                                if ( ( elem = unmatched[ i ] ) ) {\n                                    seed[ i ] = !( matches[ i ] = elem );\n                                }\n                            }\n                        } ) :\n                        function( elem, _context, xml ) {\n                            input[ 0 ] = elem;\n                            matcher( input, null, xml, results );\n\n                            // Don't keep the element\n                            // (see https://github.com/jquery/sizzle/issues/299)\n                            input[ 0 ] = null;\n                            return !results.pop();\n                        };\n                } ),\n\n                has: markFunction( function( selector ) {\n                    return function( elem ) {\n                        return find( selector, elem ).length > 0;\n                    };\n                } ),\n\n                contains: markFunction( function( text ) {\n                    text = text.replace( runescape, funescape );\n                    return function( elem ) {\n                        return ( elem.textContent || jQuery.text( elem ) ).indexOf( text ) > -1;\n                    };\n                } ),\n\n                // \"Whether an element is represented by a :lang() selector\n                // is based solely on the element's language value\n                // being equal to the identifier C,\n                // or beginning with the identifier C immediately followed by \"-\".\n                // The matching of C against the element's language value is performed case-insensitively.\n                // The identifier C does not have to be a valid language name.\"\n                // https://www.w3.org/TR/selectors/#lang-pseudo\n                lang: markFunction( function( lang ) {\n\n                    // lang value must be a valid identifier\n                    if ( !ridentifier.test( lang || \"\" ) ) {\n                        find.error( \"unsupported lang: \" + lang );\n                    }\n                    lang = lang.replace( runescape, funescape ).toLowerCase();\n                    return function( elem ) {\n                        var elemLang;\n                        do {\n                            if ( ( elemLang = documentIsHTML ?\n                                elem.lang :\n                                elem.getAttribute( \"xml:lang\" ) || elem.getAttribute( \"lang\" ) ) ) {\n\n                                elemLang = elemLang.toLowerCase();\n                                return elemLang === lang || elemLang.indexOf( lang + \"-\" ) === 0;\n                            }\n                        } while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );\n                        return false;\n                    };\n                } ),\n\n                // Miscellaneous\n                target: function( elem ) {\n                    var hash = window.location && window.location.hash;\n                    return hash && hash.slice( 1 ) === elem.id;\n                },\n\n                root: function( elem ) {\n                    return elem === documentElement;\n                },\n\n                focus: function( elem ) {\n                    return elem === safeActiveElement() &&\n                        document.hasFocus() &&\n                        !!( elem.type || elem.href || ~elem.tabIndex );\n                },\n\n                // Boolean properties\n                enabled: createDisabledPseudo( false ),\n                disabled: createDisabledPseudo( true ),\n\n                checked: function( elem ) {\n\n                    // In CSS3, :checked should return both checked and selected elements\n                    // https://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n                    return ( nodeName( elem, \"input\" ) && !!elem.checked ) ||\n                        ( nodeName( elem, \"option\" ) && !!elem.selected );\n                },\n\n                selected: function( elem ) {\n\n                    // Support: IE <=11+\n                    // Accessing the selectedIndex property\n                    // forces the browser to treat the default option as\n                    // selected when in an optgroup.\n                    if ( elem.parentNode ) {\n                        // eslint-disable-next-line no-unused-expressions\n                        elem.parentNode.selectedIndex;\n                    }\n\n                    return elem.selected === true;\n                },\n\n                // Contents\n                empty: function( elem ) {\n\n                    // https://www.w3.org/TR/selectors/#empty-pseudo\n                    // :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),\n                    //   but not by others (comment: 8; processing instruction: 7; etc.)\n                    // nodeType < 6 works because attributes (2) do not appear as children\n                    for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n                        if ( elem.nodeType < 6 ) {\n                            return false;\n                        }\n                    }\n                    return true;\n                },\n\n                parent: function( elem ) {\n                    return !Expr.pseudos.empty( elem );\n                },\n\n                // Element/input types\n                header: function( elem ) {\n                    return rheader.test( elem.nodeName );\n                },\n\n                input: function( elem ) {\n                    return rinputs.test( elem.nodeName );\n                },\n\n                button: function( elem ) {\n                    return nodeName( elem, \"input\" ) && elem.type === \"button\" ||\n                        nodeName( elem, \"button\" );\n                },\n\n                text: function( elem ) {\n                    var attr;\n                    return nodeName( elem, \"input\" ) && elem.type === \"text\" &&\n\n                        // Support: IE <10 only\n                        // New HTML5 attribute values (e.g., \"search\") appear\n                        // with elem.type === \"text\"\n                        ( ( attr = elem.getAttribute( \"type\" ) ) == null ||\n                            attr.toLowerCase() === \"text\" );\n                },\n\n                // Position-in-collection\n                first: createPositionalPseudo( function() {\n                    return [ 0 ];\n                } ),\n\n                last: createPositionalPseudo( function( _matchIndexes, length ) {\n                    return [ length - 1 ];\n                } ),\n\n                eq: createPositionalPseudo( function( _matchIndexes, length, argument ) {\n                    return [ argument < 0 ? argument + length : argument ];\n                } ),\n\n                even: createPositionalPseudo( function( matchIndexes, length ) {\n                    var i = 0;\n                    for ( ; i < length; i += 2 ) {\n                        matchIndexes.push( i );\n                    }\n                    return matchIndexes;\n                } ),\n\n                odd: createPositionalPseudo( function( matchIndexes, length ) {\n                    var i = 1;\n                    for ( ; i < length; i += 2 ) {\n                        matchIndexes.push( i );\n                    }\n                    return matchIndexes;\n                } ),\n\n                lt: createPositionalPseudo( function( matchIndexes, length, argument ) {\n                    var i;\n\n                    if ( argument < 0 ) {\n                        i = argument + length;\n                    } else if ( argument > length ) {\n                        i = length;\n                    } else {\n                        i = argument;\n                    }\n\n                    for ( ; --i >= 0; ) {\n                        matchIndexes.push( i );\n                    }\n                    return matchIndexes;\n                } ),\n\n                gt: createPositionalPseudo( function( matchIndexes, length, argument ) {\n                    var i = argument < 0 ? argument + length : argument;\n                    for ( ; ++i < length; ) {\n                        matchIndexes.push( i );\n                    }\n                    return matchIndexes;\n                } )\n            }\n        };\n\n        Expr.pseudos.nth = Expr.pseudos.eq;\n\n// Add button/input type pseudos\n        for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {\n            Expr.pseudos[ i ] = createInputPseudo( i );\n        }\n        for ( i in { submit: true, reset: true } ) {\n            Expr.pseudos[ i ] = createButtonPseudo( i );\n        }\n\n// Easy API for creating new setFilters\n        function setFilters() {}\n        setFilters.prototype = Expr.filters = Expr.pseudos;\n        Expr.setFilters = new setFilters();\n\n        function tokenize( selector, parseOnly ) {\n            var matched, match, tokens, type,\n                soFar, groups, preFilters,\n                cached = tokenCache[ selector + \" \" ];\n\n            if ( cached ) {\n                return parseOnly ? 0 : cached.slice( 0 );\n            }\n\n            soFar = selector;\n            groups = [];\n            preFilters = Expr.preFilter;\n\n            while ( soFar ) {\n\n                // Comma and first run\n                if ( !matched || ( match = rcomma.exec( soFar ) ) ) {\n                    if ( match ) {\n\n                        // Don't consume trailing commas as valid\n                        soFar = soFar.slice( match[ 0 ].length ) || soFar;\n                    }\n                    groups.push( ( tokens = [] ) );\n                }\n\n                matched = false;\n\n                // Combinators\n                if ( ( match = rleadingCombinator.exec( soFar ) ) ) {\n                    matched = match.shift();\n                    tokens.push( {\n                        value: matched,\n\n                        // Cast descendant combinators to space\n                        type: match[ 0 ].replace( rtrimCSS, \" \" )\n                    } );\n                    soFar = soFar.slice( matched.length );\n                }\n\n                // Filters\n                for ( type in Expr.filter ) {\n                    if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||\n                        ( match = preFilters[ type ]( match ) ) ) ) {\n                        matched = match.shift();\n                        tokens.push( {\n                            value: matched,\n                            type: type,\n                            matches: match\n                        } );\n                        soFar = soFar.slice( matched.length );\n                    }\n                }\n\n                if ( !matched ) {\n                    break;\n                }\n            }\n\n            // Return the length of the invalid excess\n            // if we're just parsing\n            // Otherwise, throw an error or return tokens\n            if ( parseOnly ) {\n                return soFar.length;\n            }\n\n            return soFar ?\n                find.error( selector ) :\n\n                // Cache the tokens\n                tokenCache( selector, groups ).slice( 0 );\n        }\n\n        function toSelector( tokens ) {\n            var i = 0,\n                len = tokens.length,\n                selector = \"\";\n            for ( ; i < len; i++ ) {\n                selector += tokens[ i ].value;\n            }\n            return selector;\n        }\n\n        function addCombinator( matcher, combinator, base ) {\n            var dir = combinator.dir,\n                skip = combinator.next,\n                key = skip || dir,\n                checkNonElements = base && key === \"parentNode\",\n                doneName = done++;\n\n            return combinator.first ?\n\n                // Check against closest ancestor/preceding element\n                function( elem, context, xml ) {\n                    while ( ( elem = elem[ dir ] ) ) {\n                        if ( elem.nodeType === 1 || checkNonElements ) {\n                            return matcher( elem, context, xml );\n                        }\n                    }\n                    return false;\n                } :\n\n                // Check against all ancestor/preceding elements\n                function( elem, context, xml ) {\n                    var oldCache, outerCache,\n                        newCache = [ dirruns, doneName ];\n\n                    // We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching\n                    if ( xml ) {\n                        while ( ( elem = elem[ dir ] ) ) {\n                            if ( elem.nodeType === 1 || checkNonElements ) {\n                                if ( matcher( elem, context, xml ) ) {\n                                    return true;\n                                }\n                            }\n                        }\n                    } else {\n                        while ( ( elem = elem[ dir ] ) ) {\n                            if ( elem.nodeType === 1 || checkNonElements ) {\n                                outerCache = elem[ expando ] || ( elem[ expando ] = {} );\n\n                                if ( skip && nodeName( elem, skip ) ) {\n                                    elem = elem[ dir ] || elem;\n                                } else if ( ( oldCache = outerCache[ key ] ) &&\n                                    oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {\n\n                                    // Assign to newCache so results back-propagate to previous elements\n                                    return ( newCache[ 2 ] = oldCache[ 2 ] );\n                                } else {\n\n                                    // Reuse newcache so results back-propagate to previous elements\n                                    outerCache[ key ] = newCache;\n\n                                    // A match means we're done; a fail means we have to keep checking\n                                    if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {\n                                        return true;\n                                    }\n                                }\n                            }\n                        }\n                    }\n                    return false;\n                };\n        }\n\n        function elementMatcher( matchers ) {\n            return matchers.length > 1 ?\n                function( elem, context, xml ) {\n                    var i = matchers.length;\n                    while ( i-- ) {\n                        if ( !matchers[ i ]( elem, context, xml ) ) {\n                            return false;\n                        }\n                    }\n                    return true;\n                } :\n                matchers[ 0 ];\n        }\n\n        function multipleContexts( selector, contexts, results ) {\n            var i = 0,\n                len = contexts.length;\n            for ( ; i < len; i++ ) {\n                find( selector, contexts[ i ], results );\n            }\n            return results;\n        }\n\n        function condense( unmatched, map, filter, context, xml ) {\n            var elem,\n                newUnmatched = [],\n                i = 0,\n                len = unmatched.length,\n                mapped = map != null;\n\n            for ( ; i < len; i++ ) {\n                if ( ( elem = unmatched[ i ] ) ) {\n                    if ( !filter || filter( elem, context, xml ) ) {\n                        newUnmatched.push( elem );\n                        if ( mapped ) {\n                            map.push( i );\n                        }\n                    }\n                }\n            }\n\n            return newUnmatched;\n        }\n\n        function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {\n            if ( postFilter && !postFilter[ expando ] ) {\n                postFilter = setMatcher( postFilter );\n            }\n            if ( postFinder && !postFinder[ expando ] ) {\n                postFinder = setMatcher( postFinder, postSelector );\n            }\n            return markFunction( function( seed, results, context, xml ) {\n                var temp, i, elem, matcherOut,\n                    preMap = [],\n                    postMap = [],\n                    preexisting = results.length,\n\n                    // Get initial elements from seed or context\n                    elems = seed ||\n                        multipleContexts( selector || \"*\",\n                            context.nodeType ? [ context ] : context, [] ),\n\n                    // Prefilter to get matcher input, preserving a map for seed-results synchronization\n                    matcherIn = preFilter && ( seed || !selector ) ?\n                        condense( elems, preMap, preFilter, context, xml ) :\n                        elems;\n\n                if ( matcher ) {\n\n                    // If we have a postFinder, or filtered seed, or non-seed postFilter\n                    // or preexisting results,\n                    matcherOut = postFinder || ( seed ? preFilter : preexisting || postFilter ) ?\n\n                        // ...intermediate processing is necessary\n                        [] :\n\n                        // ...otherwise use results directly\n                        results;\n\n                    // Find primary matches\n                    matcher( matcherIn, matcherOut, context, xml );\n                } else {\n                    matcherOut = matcherIn;\n                }\n\n                // Apply postFilter\n                if ( postFilter ) {\n                    temp = condense( matcherOut, postMap );\n                    postFilter( temp, [], context, xml );\n\n                    // Un-match failing elements by moving them back to matcherIn\n                    i = temp.length;\n                    while ( i-- ) {\n                        if ( ( elem = temp[ i ] ) ) {\n                            matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );\n                        }\n                    }\n                }\n\n                if ( seed ) {\n                    if ( postFinder || preFilter ) {\n                        if ( postFinder ) {\n\n                            // Get the final matcherOut by condensing this intermediate into postFinder contexts\n                            temp = [];\n                            i = matcherOut.length;\n                            while ( i-- ) {\n                                if ( ( elem = matcherOut[ i ] ) ) {\n\n                                    // Restore matcherIn since elem is not yet a final match\n                                    temp.push( ( matcherIn[ i ] = elem ) );\n                                }\n                            }\n                            postFinder( null, ( matcherOut = [] ), temp, xml );\n                        }\n\n                        // Move matched elements from seed to results to keep them synchronized\n                        i = matcherOut.length;\n                        while ( i-- ) {\n                            if ( ( elem = matcherOut[ i ] ) &&\n                                ( temp = postFinder ? indexOf.call( seed, elem ) : preMap[ i ] ) > -1 ) {\n\n                                seed[ temp ] = !( results[ temp ] = elem );\n                            }\n                        }\n                    }\n\n                    // Add elements to results, through postFinder if defined\n                } else {\n                    matcherOut = condense(\n                        matcherOut === results ?\n                            matcherOut.splice( preexisting, matcherOut.length ) :\n                            matcherOut\n                    );\n                    if ( postFinder ) {\n                        postFinder( null, results, matcherOut, xml );\n                    } else {\n                        push.apply( results, matcherOut );\n                    }\n                }\n            } );\n        }\n\n        function matcherFromTokens( tokens ) {\n            var checkContext, matcher, j,\n                len = tokens.length,\n                leadingRelative = Expr.relative[ tokens[ 0 ].type ],\n                implicitRelative = leadingRelative || Expr.relative[ \" \" ],\n                i = leadingRelative ? 1 : 0,\n\n                // The foundational matcher ensures that elements are reachable from top-level context(s)\n                matchContext = addCombinator( function( elem ) {\n                    return elem === checkContext;\n                }, implicitRelative, true ),\n                matchAnyContext = addCombinator( function( elem ) {\n                    return indexOf.call( checkContext, elem ) > -1;\n                }, implicitRelative, true ),\n                matchers = [ function( elem, context, xml ) {\n\n                    // Support: IE 11+, Edge 17 - 18+\n                    // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                    // two documents; shallow comparisons work.\n                    // eslint-disable-next-line eqeqeq\n                    var ret = ( !leadingRelative && ( xml || context != outermostContext ) ) || (\n                        ( checkContext = context ).nodeType ?\n                            matchContext( elem, context, xml ) :\n                            matchAnyContext( elem, context, xml ) );\n\n                    // Avoid hanging onto element\n                    // (see https://github.com/jquery/sizzle/issues/299)\n                    checkContext = null;\n                    return ret;\n                } ];\n\n            for ( ; i < len; i++ ) {\n                if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {\n                    matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];\n                } else {\n                    matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );\n\n                    // Return special upon seeing a positional matcher\n                    if ( matcher[ expando ] ) {\n\n                        // Find the next relative operator (if any) for proper handling\n                        j = ++i;\n                        for ( ; j < len; j++ ) {\n                            if ( Expr.relative[ tokens[ j ].type ] ) {\n                                break;\n                            }\n                        }\n                        return setMatcher(\n                            i > 1 && elementMatcher( matchers ),\n                            i > 1 && toSelector(\n\n                                // If the preceding token was a descendant combinator, insert an implicit any-element `*`\n                                tokens.slice( 0, i - 1 )\n                                    .concat( { value: tokens[ i - 2 ].type === \" \" ? \"*\" : \"\" } )\n                            ).replace( rtrimCSS, \"$1\" ),\n                            matcher,\n                            i < j && matcherFromTokens( tokens.slice( i, j ) ),\n                            j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),\n                            j < len && toSelector( tokens )\n                        );\n                    }\n                    matchers.push( matcher );\n                }\n            }\n\n            return elementMatcher( matchers );\n        }\n\n        function matcherFromGroupMatchers( elementMatchers, setMatchers ) {\n            var bySet = setMatchers.length > 0,\n                byElement = elementMatchers.length > 0,\n                superMatcher = function( seed, context, xml, results, outermost ) {\n                    var elem, j, matcher,\n                        matchedCount = 0,\n                        i = \"0\",\n                        unmatched = seed && [],\n                        setMatched = [],\n                        contextBackup = outermostContext,\n\n                        // We must always have either seed elements or outermost context\n                        elems = seed || byElement && Expr.find.TAG( \"*\", outermost ),\n\n                        // Use integer dirruns iff this is the outermost matcher\n                        dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),\n                        len = elems.length;\n\n                    if ( outermost ) {\n\n                        // Support: IE 11+, Edge 17 - 18+\n                        // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                        // two documents; shallow comparisons work.\n                        // eslint-disable-next-line eqeqeq\n                        outermostContext = context == document || context || outermost;\n                    }\n\n                    // Add elements passing elementMatchers directly to results\n                    // Support: iOS <=7 - 9 only\n                    // Tolerate NodeList properties (IE: \"length\"; Safari: <number>) matching\n                    // elements by id. (see trac-14142)\n                    for ( ; i !== len && ( elem = elems[ i ] ) != null; i++ ) {\n                        if ( byElement && elem ) {\n                            j = 0;\n\n                            // Support: IE 11+, Edge 17 - 18+\n                            // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                            // two documents; shallow comparisons work.\n                            // eslint-disable-next-line eqeqeq\n                            if ( !context && elem.ownerDocument != document ) {\n                                setDocument( elem );\n                                xml = !documentIsHTML;\n                            }\n                            while ( ( matcher = elementMatchers[ j++ ] ) ) {\n                                if ( matcher( elem, context || document, xml ) ) {\n                                    push.call( results, elem );\n                                    break;\n                                }\n                            }\n                            if ( outermost ) {\n                                dirruns = dirrunsUnique;\n                            }\n                        }\n\n                        // Track unmatched elements for set filters\n                        if ( bySet ) {\n\n                            // They will have gone through all possible matchers\n                            if ( ( elem = !matcher && elem ) ) {\n                                matchedCount--;\n                            }\n\n                            // Lengthen the array for every element, matched or not\n                            if ( seed ) {\n                                unmatched.push( elem );\n                            }\n                        }\n                    }\n\n                    // `i` is now the count of elements visited above, and adding it to `matchedCount`\n                    // makes the latter nonnegative.\n                    matchedCount += i;\n\n                    // Apply set filters to unmatched elements\n                    // NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`\n                    // equals `i`), unless we didn't visit _any_ elements in the above loop because we have\n                    // no element matchers and no seed.\n                    // Incrementing an initially-string \"0\" `i` allows `i` to remain a string only in that\n                    // case, which will result in a \"00\" `matchedCount` that differs from `i` but is also\n                    // numerically zero.\n                    if ( bySet && i !== matchedCount ) {\n                        j = 0;\n                        while ( ( matcher = setMatchers[ j++ ] ) ) {\n                            matcher( unmatched, setMatched, context, xml );\n                        }\n\n                        if ( seed ) {\n\n                            // Reintegrate element matches to eliminate the need for sorting\n                            if ( matchedCount > 0 ) {\n                                while ( i-- ) {\n                                    if ( !( unmatched[ i ] || setMatched[ i ] ) ) {\n                                        setMatched[ i ] = pop.call( results );\n                                    }\n                                }\n                            }\n\n                            // Discard index placeholder values to get only actual matches\n                            setMatched = condense( setMatched );\n                        }\n\n                        // Add matches to results\n                        push.apply( results, setMatched );\n\n                        // Seedless set matches succeeding multiple successful matchers stipulate sorting\n                        if ( outermost && !seed && setMatched.length > 0 &&\n                            ( matchedCount + setMatchers.length ) > 1 ) {\n\n                            jQuery.uniqueSort( results );\n                        }\n                    }\n\n                    // Override manipulation of globals by nested matchers\n                    if ( outermost ) {\n                        dirruns = dirrunsUnique;\n                        outermostContext = contextBackup;\n                    }\n\n                    return unmatched;\n                };\n\n            return bySet ?\n                markFunction( superMatcher ) :\n                superMatcher;\n        }\n\n        function compile( selector, match /* Internal Use Only */ ) {\n            var i,\n                setMatchers = [],\n                elementMatchers = [],\n                cached = compilerCache[ selector + \" \" ];\n\n            if ( !cached ) {\n\n                // Generate a function of recursive functions that can be used to check each element\n                if ( !match ) {\n                    match = tokenize( selector );\n                }\n                i = match.length;\n                while ( i-- ) {\n                    cached = matcherFromTokens( match[ i ] );\n                    if ( cached[ expando ] ) {\n                        setMatchers.push( cached );\n                    } else {\n                        elementMatchers.push( cached );\n                    }\n                }\n\n                // Cache the compiled function\n                cached = compilerCache( selector,\n                    matcherFromGroupMatchers( elementMatchers, setMatchers ) );\n\n                // Save selector and tokenization\n                cached.selector = selector;\n            }\n            return cached;\n        }\n\n        /**\n         * A low-level selection function that works with jQuery's compiled\n         *  selector functions\n         * @param {String|Function} selector A selector or a pre-compiled\n         *  selector function built with jQuery selector compile\n         * @param {Element} context\n         * @param {Array} [results]\n         * @param {Array} [seed] A set of elements to match against\n         */\n        function select( selector, context, results, seed ) {\n            var i, tokens, token, type, find,\n                compiled = typeof selector === \"function\" && selector,\n                match = !seed && tokenize( ( selector = compiled.selector || selector ) );\n\n            results = results || [];\n\n            // Try to minimize operations if there is only one selector in the list and no seed\n            // (the latter of which guarantees us context)\n            if ( match.length === 1 ) {\n\n                // Reduce context if the leading compound selector is an ID\n                tokens = match[ 0 ] = match[ 0 ].slice( 0 );\n                if ( tokens.length > 2 && ( token = tokens[ 0 ] ).type === \"ID\" &&\n                    context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[ 1 ].type ] ) {\n\n                    context = ( Expr.find.ID(\n                        token.matches[ 0 ].replace( runescape, funescape ),\n                        context\n                    ) || [] )[ 0 ];\n                    if ( !context ) {\n                        return results;\n\n                        // Precompiled matchers will still verify ancestry, so step up a level\n                    } else if ( compiled ) {\n                        context = context.parentNode;\n                    }\n\n                    selector = selector.slice( tokens.shift().value.length );\n                }\n\n                // Fetch a seed set for right-to-left matching\n                i = matchExpr.needsContext.test( selector ) ? 0 : tokens.length;\n                while ( i-- ) {\n                    token = tokens[ i ];\n\n                    // Abort if we hit a combinator\n                    if ( Expr.relative[ ( type = token.type ) ] ) {\n                        break;\n                    }\n                    if ( ( find = Expr.find[ type ] ) ) {\n\n                        // Search, expanding context for leading sibling combinators\n                        if ( ( seed = find(\n                            token.matches[ 0 ].replace( runescape, funescape ),\n                            rsibling.test( tokens[ 0 ].type ) &&\n                            testContext( context.parentNode ) || context\n                        ) ) ) {\n\n                            // If seed is empty or no tokens remain, we can return early\n                            tokens.splice( i, 1 );\n                            selector = seed.length && toSelector( tokens );\n                            if ( !selector ) {\n                                push.apply( results, seed );\n                                return results;\n                            }\n\n                            break;\n                        }\n                    }\n                }\n            }\n\n            // Compile and execute a filtering function if one is not provided\n            // Provide `match` to avoid retokenization if we modified the selector above\n            ( compiled || compile( selector, match ) )(\n                seed,\n                context,\n                !documentIsHTML,\n                results,\n                !context || rsibling.test( selector ) && testContext( context.parentNode ) || context\n            );\n            return results;\n        }\n\n// One-time assignments\n\n// Support: Android <=4.0 - 4.1+\n// Sort stability\n        support.sortStable = expando.split( \"\" ).sort( sortOrder ).join( \"\" ) === expando;\n\n// Initialize against the default document\n        setDocument();\n\n// Support: Android <=4.0 - 4.1+\n// Detached nodes confoundingly follow *each other*\n        support.sortDetached = assert( function( el ) {\n\n            // Should return 1, but returns 4 (following)\n            return el.compareDocumentPosition( document.createElement( \"fieldset\" ) ) & 1;\n        } );\n\n        jQuery.find = find;\n\n// Deprecated\n        jQuery.expr[ \":\" ] = jQuery.expr.pseudos;\n        jQuery.unique = jQuery.uniqueSort;\n\n// These have always been private, but they used to be documented as part of\n// Sizzle so let's maintain them for now for backwards compatibility purposes.\n        find.compile = compile;\n        find.select = select;\n        find.setDocument = setDocument;\n        find.tokenize = tokenize;\n\n        find.escape = jQuery.escapeSelector;\n        find.getText = jQuery.text;\n        find.isXML = jQuery.isXMLDoc;\n        find.selectors = jQuery.expr;\n        find.support = jQuery.support;\n        find.uniqueSort = jQuery.uniqueSort;\n\n        /* eslint-enable */\n\n    } )();\n\n\n    var dir = function( elem, dir, until ) {\n        var matched = [],\n            truncate = until !== undefined;\n\n        while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {\n            if ( elem.nodeType === 1 ) {\n                if ( truncate && jQuery( elem ).is( until ) ) {\n                    break;\n                }\n                matched.push( elem );\n            }\n        }\n        return matched;\n    };\n\n\n    var siblings = function( n, elem ) {\n        var matched = [];\n\n        for ( ; n; n = n.nextSibling ) {\n            if ( n.nodeType === 1 && n !== elem ) {\n                matched.push( n );\n            }\n        }\n\n        return matched;\n    };\n\n\n    var rneedsContext = jQuery.expr.match.needsContext;\n\n    var rsingleTag = ( /^<([a-z][^\\/\\0>:\\x20\\t\\r\\n\\f]*)[\\x20\\t\\r\\n\\f]*\\/?>(?:<\\/\\1>|)$/i );\n\n\n\n// Implement the identical functionality for filter and not\n    function winnow( elements, qualifier, not ) {\n        if ( isFunction( qualifier ) ) {\n            return jQuery.grep( elements, function( elem, i ) {\n                return !!qualifier.call( elem, i, elem ) !== not;\n            } );\n        }\n\n        // Single element\n        if ( qualifier.nodeType ) {\n            return jQuery.grep( elements, function( elem ) {\n                return ( elem === qualifier ) !== not;\n            } );\n        }\n\n        // Arraylike of elements (jQuery, arguments, Array)\n        if ( typeof qualifier !== \"string\" ) {\n            return jQuery.grep( elements, function( elem ) {\n                return ( indexOf.call( qualifier, elem ) > -1 ) !== not;\n            } );\n        }\n\n        // Filtered directly for both simple and complex selectors\n        return jQuery.filter( qualifier, elements, not );\n    }\n\n    jQuery.filter = function( expr, elems, not ) {\n        var elem = elems[ 0 ];\n\n        if ( not ) {\n            expr = \":not(\" + expr + \")\";\n        }\n\n        if ( elems.length === 1 && elem.nodeType === 1 ) {\n            return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];\n        }\n\n        return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {\n            return elem.nodeType === 1;\n        } ) );\n    };\n\n    jQuery.fn.extend( {\n        find: function( selector ) {\n            var i, ret,\n                len = this.length,\n                self = this;\n\n            if ( typeof selector !== \"string\" ) {\n                return this.pushStack( jQuery( selector ).filter( function() {\n                    for ( i = 0; i < len; i++ ) {\n                        if ( jQuery.contains( self[ i ], this ) ) {\n                            return true;\n                        }\n                    }\n                } ) );\n            }\n\n            ret = this.pushStack( [] );\n\n            for ( i = 0; i < len; i++ ) {\n                jQuery.find( selector, self[ i ], ret );\n            }\n\n            return len > 1 ? jQuery.uniqueSort( ret ) : ret;\n        },\n        filter: function( selector ) {\n            return this.pushStack( winnow( this, selector || [], false ) );\n        },\n        not: function( selector ) {\n            return this.pushStack( winnow( this, selector || [], true ) );\n        },\n        is: function( selector ) {\n            return !!winnow(\n                this,\n\n                // If this is a positional/relative selector, check membership in the returned set\n                // so $(\"p:first\").is(\"p:last\") won't return true for a doc with two \"p\".\n                typeof selector === \"string\" && rneedsContext.test( selector ) ?\n                    jQuery( selector ) :\n                    selector || [],\n                false\n            ).length;\n        }\n    } );\n\n\n// Initialize a jQuery object\n\n\n// A central reference to the root jQuery(document)\n    var rootjQuery,\n\n        // A simple way to check for HTML strings\n        // Prioritize #id over <tag> to avoid XSS via location.hash (trac-9521)\n        // Strict HTML recognition (trac-11290: must start with <)\n        // Shortcut simple #id case for speed\n        rquickExpr = /^(?:\\s*(<[\\w\\W]+>)[^>]*|#([\\w-]+))$/,\n\n        init = jQuery.fn.init = function( selector, context, root ) {\n            var match, elem;\n\n            // HANDLE: $(\"\"), $(null), $(undefined), $(false)\n            if ( !selector ) {\n                return this;\n            }\n\n            // Method init() accepts an alternate rootjQuery\n            // so migrate can support jQuery.sub (gh-2101)\n            root = root || rootjQuery;\n\n            // Handle HTML strings\n            if ( typeof selector === \"string\" ) {\n                if ( selector[ 0 ] === \"<\" &&\n                    selector[ selector.length - 1 ] === \">\" &&\n                    selector.length >= 3 ) {\n\n                    // Assume that strings that start and end with <> are HTML and skip the regex check\n                    match = [ null, selector, null ];\n\n                } else {\n                    match = rquickExpr.exec( selector );\n                }\n\n                // Match html or make sure no context is specified for #id\n                if ( match && ( match[ 1 ] || !context ) ) {\n\n                    // HANDLE: $(html) -> $(array)\n                    if ( match[ 1 ] ) {\n                        context = context instanceof jQuery ? context[ 0 ] : context;\n\n                        // Option to run scripts is true for back-compat\n                        // Intentionally let the error be thrown if parseHTML is not present\n                        jQuery.merge( this, jQuery.parseHTML(\n                            match[ 1 ],\n                            context && context.nodeType ? context.ownerDocument || context : document,\n                            true\n                        ) );\n\n                        // HANDLE: $(html, props)\n                        if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {\n                            for ( match in context ) {\n\n                                // Properties of context are called as methods if possible\n                                if ( isFunction( this[ match ] ) ) {\n                                    this[ match ]( context[ match ] );\n\n                                    // ...and otherwise set as attributes\n                                } else {\n                                    this.attr( match, context[ match ] );\n                                }\n                            }\n                        }\n\n                        return this;\n\n                        // HANDLE: $(#id)\n                    } else {\n                        elem = document.getElementById( match[ 2 ] );\n\n                        if ( elem ) {\n\n                            // Inject the element directly into the jQuery object\n                            this[ 0 ] = elem;\n                            this.length = 1;\n                        }\n                        return this;\n                    }\n\n                    // HANDLE: $(expr, $(...))\n                } else if ( !context || context.jquery ) {\n                    return ( context || root ).find( selector );\n\n                    // HANDLE: $(expr, context)\n                    // (which is just equivalent to: $(context).find(expr)\n                } else {\n                    return this.constructor( context ).find( selector );\n                }\n\n                // HANDLE: $(DOMElement)\n            } else if ( selector.nodeType ) {\n                this[ 0 ] = selector;\n                this.length = 1;\n                return this;\n\n                // HANDLE: $(function)\n                // Shortcut for document ready\n            } else if ( isFunction( selector ) ) {\n                return root.ready !== undefined ?\n                    root.ready( selector ) :\n\n                    // Execute immediately if ready is not present\n                    selector( jQuery );\n            }\n\n            return jQuery.makeArray( selector, this );\n        };\n\n// Give the init function the jQuery prototype for later instantiation\n    init.prototype = jQuery.fn;\n\n// Initialize central reference\n    rootjQuery = jQuery( document );\n\n\n    var rparentsprev = /^(?:parents|prev(?:Until|All))/,\n\n        // Methods guaranteed to produce a unique set when starting from a unique set\n        guaranteedUnique = {\n            children: true,\n            contents: true,\n            next: true,\n            prev: true\n        };\n\n    jQuery.fn.extend( {\n        has: function( target ) {\n            var targets = jQuery( target, this ),\n                l = targets.length;\n\n            return this.filter( function() {\n                var i = 0;\n                for ( ; i < l; i++ ) {\n                    if ( jQuery.contains( this, targets[ i ] ) ) {\n                        return true;\n                    }\n                }\n            } );\n        },\n\n        closest: function( selectors, context ) {\n            var cur,\n                i = 0,\n                l = this.length,\n                matched = [],\n                targets = typeof selectors !== \"string\" && jQuery( selectors );\n\n            // Positional selectors never match, since there's no _selection_ context\n            if ( !rneedsContext.test( selectors ) ) {\n                for ( ; i < l; i++ ) {\n                    for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {\n\n                        // Always skip document fragments\n                        if ( cur.nodeType < 11 && ( targets ?\n                            targets.index( cur ) > -1 :\n\n                            // Don't pass non-elements to jQuery#find\n                            cur.nodeType === 1 &&\n                            jQuery.find.matchesSelector( cur, selectors ) ) ) {\n\n                            matched.push( cur );\n                            break;\n                        }\n                    }\n                }\n            }\n\n            return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );\n        },\n\n        // Determine the position of an element within the set\n        index: function( elem ) {\n\n            // No argument, return index in parent\n            if ( !elem ) {\n                return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;\n            }\n\n            // Index in selector\n            if ( typeof elem === \"string\" ) {\n                return indexOf.call( jQuery( elem ), this[ 0 ] );\n            }\n\n            // Locate the position of the desired element\n            return indexOf.call( this,\n\n                // If it receives a jQuery object, the first element is used\n                elem.jquery ? elem[ 0 ] : elem\n            );\n        },\n\n        add: function( selector, context ) {\n            return this.pushStack(\n                jQuery.uniqueSort(\n                    jQuery.merge( this.get(), jQuery( selector, context ) )\n                )\n            );\n        },\n\n        addBack: function( selector ) {\n            return this.add( selector == null ?\n                this.prevObject : this.prevObject.filter( selector )\n            );\n        }\n    } );\n\n    function sibling( cur, dir ) {\n        while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}\n        return cur;\n    }\n\n    jQuery.each( {\n        parent: function( elem ) {\n            var parent = elem.parentNode;\n            return parent && parent.nodeType !== 11 ? parent : null;\n        },\n        parents: function( elem ) {\n            return dir( elem, \"parentNode\" );\n        },\n        parentsUntil: function( elem, _i, until ) {\n            return dir( elem, \"parentNode\", until );\n        },\n        next: function( elem ) {\n            return sibling( elem, \"nextSibling\" );\n        },\n        prev: function( elem ) {\n            return sibling( elem, \"previousSibling\" );\n        },\n        nextAll: function( elem ) {\n            return dir( elem, \"nextSibling\" );\n        },\n        prevAll: function( elem ) {\n            return dir( elem, \"previousSibling\" );\n        },\n        nextUntil: function( elem, _i, until ) {\n            return dir( elem, \"nextSibling\", until );\n        },\n        prevUntil: function( elem, _i, until ) {\n            return dir( elem, \"previousSibling\", until );\n        },\n        siblings: function( elem ) {\n            return siblings( ( elem.parentNode || {} ).firstChild, elem );\n        },\n        children: function( elem ) {\n            return siblings( elem.firstChild );\n        },\n        contents: function( elem ) {\n            if ( elem.contentDocument != null &&\n\n                // Support: IE 11+\n                // <object> elements with no `data` attribute has an object\n                // `contentDocument` with a `null` prototype.\n                getProto( elem.contentDocument ) ) {\n\n                return elem.contentDocument;\n            }\n\n            // Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only\n            // Treat the template element as a regular one in browsers that\n            // don't support it.\n            if ( nodeName( elem, \"template\" ) ) {\n                elem = elem.content || elem;\n            }\n\n            return jQuery.merge( [], elem.childNodes );\n        }\n    }, function( name, fn ) {\n        jQuery.fn[ name ] = function( until, selector ) {\n            var matched = jQuery.map( this, fn, until );\n\n            if ( name.slice( -5 ) !== \"Until\" ) {\n                selector = until;\n            }\n\n            if ( selector && typeof selector === \"string\" ) {\n                matched = jQuery.filter( selector, matched );\n            }\n\n            if ( this.length > 1 ) {\n\n                // Remove duplicates\n                if ( !guaranteedUnique[ name ] ) {\n                    jQuery.uniqueSort( matched );\n                }\n\n                // Reverse order for parents* and prev-derivatives\n                if ( rparentsprev.test( name ) ) {\n                    matched.reverse();\n                }\n            }\n\n            return this.pushStack( matched );\n        };\n    } );\n    var rnothtmlwhite = ( /[^\\x20\\t\\r\\n\\f]+/g );\n\n\n\n// Convert String-formatted options into Object-formatted ones\n    function createOptions( options ) {\n        var object = {};\n        jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {\n            object[ flag ] = true;\n        } );\n        return object;\n    }\n\n    /*\n * Create a callback list using the following parameters:\n *\n *\toptions: an optional list of space-separated options that will change how\n *\t\t\tthe callback list behaves or a more traditional option object\n *\n * By default a callback list will act like an event callback list and can be\n * \"fired\" multiple times.\n *\n * Possible options:\n *\n *\tonce:\t\t\twill ensure the callback list can only be fired once (like a Deferred)\n *\n *\tmemory:\t\t\twill keep track of previous values and will call any callback added\n *\t\t\t\t\tafter the list has been fired right away with the latest \"memorized\"\n *\t\t\t\t\tvalues (like a Deferred)\n *\n *\tunique:\t\t\twill ensure a callback can only be added once (no duplicate in the list)\n *\n *\tstopOnFalse:\tinterrupt callings when a callback returns false\n *\n */\n    jQuery.Callbacks = function( options ) {\n\n        // Convert options from String-formatted to Object-formatted if needed\n        // (we check in cache first)\n        options = typeof options === \"string\" ?\n            createOptions( options ) :\n            jQuery.extend( {}, options );\n\n        var // Flag to know if list is currently firing\n            firing,\n\n            // Last fire value for non-forgettable lists\n            memory,\n\n            // Flag to know if list was already fired\n            fired,\n\n            // Flag to prevent firing\n            locked,\n\n            // Actual callback list\n            list = [],\n\n            // Queue of execution data for repeatable lists\n            queue = [],\n\n            // Index of currently firing callback (modified by add/remove as needed)\n            firingIndex = -1,\n\n            // Fire callbacks\n            fire = function() {\n\n                // Enforce single-firing\n                locked = locked || options.once;\n\n                // Execute callbacks for all pending executions,\n                // respecting firingIndex overrides and runtime changes\n                fired = firing = true;\n                for ( ; queue.length; firingIndex = -1 ) {\n                    memory = queue.shift();\n                    while ( ++firingIndex < list.length ) {\n\n                        // Run callback and check for early termination\n                        if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&\n                            options.stopOnFalse ) {\n\n                            // Jump to end and forget the data so .add doesn't re-fire\n                            firingIndex = list.length;\n                            memory = false;\n                        }\n                    }\n                }\n\n                // Forget the data if we're done with it\n                if ( !options.memory ) {\n                    memory = false;\n                }\n\n                firing = false;\n\n                // Clean up if we're done firing for good\n                if ( locked ) {\n\n                    // Keep an empty list if we have data for future add calls\n                    if ( memory ) {\n                        list = [];\n\n                        // Otherwise, this object is spent\n                    } else {\n                        list = \"\";\n                    }\n                }\n            },\n\n            // Actual Callbacks object\n            self = {\n\n                // Add a callback or a collection of callbacks to the list\n                add: function() {\n                    if ( list ) {\n\n                        // If we have memory from a past run, we should fire after adding\n                        if ( memory && !firing ) {\n                            firingIndex = list.length - 1;\n                            queue.push( memory );\n                        }\n\n                        ( function add( args ) {\n                            jQuery.each( args, function( _, arg ) {\n                                if ( isFunction( arg ) ) {\n                                    if ( !options.unique || !self.has( arg ) ) {\n                                        list.push( arg );\n                                    }\n                                } else if ( arg && arg.length && toType( arg ) !== \"string\" ) {\n\n                                    // Inspect recursively\n                                    add( arg );\n                                }\n                            } );\n                        } )( arguments );\n\n                        if ( memory && !firing ) {\n                            fire();\n                        }\n                    }\n                    return this;\n                },\n\n                // Remove a callback from the list\n                remove: function() {\n                    jQuery.each( arguments, function( _, arg ) {\n                        var index;\n                        while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {\n                            list.splice( index, 1 );\n\n                            // Handle firing indexes\n                            if ( index <= firingIndex ) {\n                                firingIndex--;\n                            }\n                        }\n                    } );\n                    return this;\n                },\n\n                // Check if a given callback is in the list.\n                // If no argument is given, return whether or not list has callbacks attached.\n                has: function( fn ) {\n                    return fn ?\n                        jQuery.inArray( fn, list ) > -1 :\n                        list.length > 0;\n                },\n\n                // Remove all callbacks from the list\n                empty: function() {\n                    if ( list ) {\n                        list = [];\n                    }\n                    return this;\n                },\n\n                // Disable .fire and .add\n                // Abort any current/pending executions\n                // Clear all callbacks and values\n                disable: function() {\n                    locked = queue = [];\n                    list = memory = \"\";\n                    return this;\n                },\n                disabled: function() {\n                    return !list;\n                },\n\n                // Disable .fire\n                // Also disable .add unless we have memory (since it would have no effect)\n                // Abort any pending executions\n                lock: function() {\n                    locked = queue = [];\n                    if ( !memory && !firing ) {\n                        list = memory = \"\";\n                    }\n                    return this;\n                },\n                locked: function() {\n                    return !!locked;\n                },\n\n                // Call all callbacks with the given context and arguments\n                fireWith: function( context, args ) {\n                    if ( !locked ) {\n                        args = args || [];\n                        args = [ context, args.slice ? args.slice() : args ];\n                        queue.push( args );\n                        if ( !firing ) {\n                            fire();\n                        }\n                    }\n                    return this;\n                },\n\n                // Call all the callbacks with the given arguments\n                fire: function() {\n                    self.fireWith( this, arguments );\n                    return this;\n                },\n\n                // To know if the callbacks have already been called at least once\n                fired: function() {\n                    return !!fired;\n                }\n            };\n\n        return self;\n    };\n\n\n    function Identity( v ) {\n        return v;\n    }\n    function Thrower( ex ) {\n        throw ex;\n    }\n\n    function adoptValue( value, resolve, reject, noValue ) {\n        var method;\n\n        try {\n\n            // Check for promise aspect first to privilege synchronous behavior\n            if ( value && isFunction( ( method = value.promise ) ) ) {\n                method.call( value ).done( resolve ).fail( reject );\n\n                // Other thenables\n            } else if ( value && isFunction( ( method = value.then ) ) ) {\n                method.call( value, resolve, reject );\n\n                // Other non-thenables\n            } else {\n\n                // Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:\n                // * false: [ value ].slice( 0 ) => resolve( value )\n                // * true: [ value ].slice( 1 ) => resolve()\n                resolve.apply( undefined, [ value ].slice( noValue ) );\n            }\n\n            // For Promises/A+, convert exceptions into rejections\n            // Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in\n            // Deferred#then to conditionally suppress rejection.\n        } catch ( value ) {\n\n            // Support: Android 4.0 only\n            // Strict mode functions invoked without .call/.apply get global-object context\n            reject.apply( undefined, [ value ] );\n        }\n    }\n\n    jQuery.extend( {\n\n        Deferred: function( func ) {\n            var tuples = [\n\n                    // action, add listener, callbacks,\n                    // ... .then handlers, argument index, [final state]\n                    [ \"notify\", \"progress\", jQuery.Callbacks( \"memory\" ),\n                        jQuery.Callbacks( \"memory\" ), 2 ],\n                    [ \"resolve\", \"done\", jQuery.Callbacks( \"once memory\" ),\n                        jQuery.Callbacks( \"once memory\" ), 0, \"resolved\" ],\n                    [ \"reject\", \"fail\", jQuery.Callbacks( \"once memory\" ),\n                        jQuery.Callbacks( \"once memory\" ), 1, \"rejected\" ]\n                ],\n                state = \"pending\",\n                promise = {\n                    state: function() {\n                        return state;\n                    },\n                    always: function() {\n                        deferred.done( arguments ).fail( arguments );\n                        return this;\n                    },\n                    \"catch\": function( fn ) {\n                        return promise.then( null, fn );\n                    },\n\n                    // Keep pipe for back-compat\n                    pipe: function( /* fnDone, fnFail, fnProgress */ ) {\n                        var fns = arguments;\n\n                        return jQuery.Deferred( function( newDefer ) {\n                            jQuery.each( tuples, function( _i, tuple ) {\n\n                                // Map tuples (progress, done, fail) to arguments (done, fail, progress)\n                                var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];\n\n                                // deferred.progress(function() { bind to newDefer or newDefer.notify })\n                                // deferred.done(function() { bind to newDefer or newDefer.resolve })\n                                // deferred.fail(function() { bind to newDefer or newDefer.reject })\n                                deferred[ tuple[ 1 ] ]( function() {\n                                    var returned = fn && fn.apply( this, arguments );\n                                    if ( returned && isFunction( returned.promise ) ) {\n                                        returned.promise()\n                                            .progress( newDefer.notify )\n                                            .done( newDefer.resolve )\n                                            .fail( newDefer.reject );\n                                    } else {\n                                        newDefer[ tuple[ 0 ] + \"With\" ](\n                                            this,\n                                            fn ? [ returned ] : arguments\n                                        );\n                                    }\n                                } );\n                            } );\n                            fns = null;\n                        } ).promise();\n                    },\n                    then: function( onFulfilled, onRejected, onProgress ) {\n                        var maxDepth = 0;\n                        function resolve( depth, deferred, handler, special ) {\n                            return function() {\n                                var that = this,\n                                    args = arguments,\n                                    mightThrow = function() {\n                                        var returned, then;\n\n                                        // Support: Promises/A+ section 2.3.3.3.3\n                                        // https://promisesaplus.com/#point-59\n                                        // Ignore double-resolution attempts\n                                        if ( depth < maxDepth ) {\n                                            return;\n                                        }\n\n                                        returned = handler.apply( that, args );\n\n                                        // Support: Promises/A+ section 2.3.1\n                                        // https://promisesaplus.com/#point-48\n                                        if ( returned === deferred.promise() ) {\n                                            throw new TypeError( \"Thenable self-resolution\" );\n                                        }\n\n                                        // Support: Promises/A+ sections 2.3.3.1, 3.5\n                                        // https://promisesaplus.com/#point-54\n                                        // https://promisesaplus.com/#point-75\n                                        // Retrieve `then` only once\n                                        then = returned &&\n\n                                            // Support: Promises/A+ section 2.3.4\n                                            // https://promisesaplus.com/#point-64\n                                            // Only check objects and functions for thenability\n                                            ( typeof returned === \"object\" ||\n                                                typeof returned === \"function\" ) &&\n                                            returned.then;\n\n                                        // Handle a returned thenable\n                                        if ( isFunction( then ) ) {\n\n                                            // Special processors (notify) just wait for resolution\n                                            if ( special ) {\n                                                then.call(\n                                                    returned,\n                                                    resolve( maxDepth, deferred, Identity, special ),\n                                                    resolve( maxDepth, deferred, Thrower, special )\n                                                );\n\n                                                // Normal processors (resolve) also hook into progress\n                                            } else {\n\n                                                // ...and disregard older resolution values\n                                                maxDepth++;\n\n                                                then.call(\n                                                    returned,\n                                                    resolve( maxDepth, deferred, Identity, special ),\n                                                    resolve( maxDepth, deferred, Thrower, special ),\n                                                    resolve( maxDepth, deferred, Identity,\n                                                        deferred.notifyWith )\n                                                );\n                                            }\n\n                                            // Handle all other returned values\n                                        } else {\n\n                                            // Only substitute handlers pass on context\n                                            // and multiple values (non-spec behavior)\n                                            if ( handler !== Identity ) {\n                                                that = undefined;\n                                                args = [ returned ];\n                                            }\n\n                                            // Process the value(s)\n                                            // Default process is resolve\n                                            ( special || deferred.resolveWith )( that, args );\n                                        }\n                                    },\n\n                                    // Only normal processors (resolve) catch and reject exceptions\n                                    process = special ?\n                                        mightThrow :\n                                        function() {\n                                            try {\n                                                mightThrow();\n                                            } catch ( e ) {\n\n                                                if ( jQuery.Deferred.exceptionHook ) {\n                                                    jQuery.Deferred.exceptionHook( e,\n                                                        process.error );\n                                                }\n\n                                                // Support: Promises/A+ section 2.3.3.3.4.1\n                                                // https://promisesaplus.com/#point-61\n                                                // Ignore post-resolution exceptions\n                                                if ( depth + 1 >= maxDepth ) {\n\n                                                    // Only substitute handlers pass on context\n                                                    // and multiple values (non-spec behavior)\n                                                    if ( handler !== Thrower ) {\n                                                        that = undefined;\n                                                        args = [ e ];\n                                                    }\n\n                                                    deferred.rejectWith( that, args );\n                                                }\n                                            }\n                                        };\n\n                                // Support: Promises/A+ section 2.3.3.3.1\n                                // https://promisesaplus.com/#point-57\n                                // Re-resolve promises immediately to dodge false rejection from\n                                // subsequent errors\n                                if ( depth ) {\n                                    process();\n                                } else {\n\n                                    // Call an optional hook to record the error, in case of exception\n                                    // since it's otherwise lost when execution goes async\n                                    if ( jQuery.Deferred.getErrorHook ) {\n                                        process.error = jQuery.Deferred.getErrorHook();\n\n                                        // The deprecated alias of the above. While the name suggests\n                                        // returning the stack, not an error instance, jQuery just passes\n                                        // it directly to `console.warn` so both will work; an instance\n                                        // just better cooperates with source maps.\n                                    } else if ( jQuery.Deferred.getStackHook ) {\n                                        process.error = jQuery.Deferred.getStackHook();\n                                    }\n                                    window.setTimeout( process );\n                                }\n                            };\n                        }\n\n                        return jQuery.Deferred( function( newDefer ) {\n\n                            // progress_handlers.add( ... )\n                            tuples[ 0 ][ 3 ].add(\n                                resolve(\n                                    0,\n                                    newDefer,\n                                    isFunction( onProgress ) ?\n                                        onProgress :\n                                        Identity,\n                                    newDefer.notifyWith\n                                )\n                            );\n\n                            // fulfilled_handlers.add( ... )\n                            tuples[ 1 ][ 3 ].add(\n                                resolve(\n                                    0,\n                                    newDefer,\n                                    isFunction( onFulfilled ) ?\n                                        onFulfilled :\n                                        Identity\n                                )\n                            );\n\n                            // rejected_handlers.add( ... )\n                            tuples[ 2 ][ 3 ].add(\n                                resolve(\n                                    0,\n                                    newDefer,\n                                    isFunction( onRejected ) ?\n                                        onRejected :\n                                        Thrower\n                                )\n                            );\n                        } ).promise();\n                    },\n\n                    // Get a promise for this deferred\n                    // If obj is provided, the promise aspect is added to the object\n                    promise: function( obj ) {\n                        return obj != null ? jQuery.extend( obj, promise ) : promise;\n                    }\n                },\n                deferred = {};\n\n            // Add list-specific methods\n            jQuery.each( tuples, function( i, tuple ) {\n                var list = tuple[ 2 ],\n                    stateString = tuple[ 5 ];\n\n                // promise.progress = list.add\n                // promise.done = list.add\n                // promise.fail = list.add\n                promise[ tuple[ 1 ] ] = list.add;\n\n                // Handle state\n                if ( stateString ) {\n                    list.add(\n                        function() {\n\n                            // state = \"resolved\" (i.e., fulfilled)\n                            // state = \"rejected\"\n                            state = stateString;\n                        },\n\n                        // rejected_callbacks.disable\n                        // fulfilled_callbacks.disable\n                        tuples[ 3 - i ][ 2 ].disable,\n\n                        // rejected_handlers.disable\n                        // fulfilled_handlers.disable\n                        tuples[ 3 - i ][ 3 ].disable,\n\n                        // progress_callbacks.lock\n                        tuples[ 0 ][ 2 ].lock,\n\n                        // progress_handlers.lock\n                        tuples[ 0 ][ 3 ].lock\n                    );\n                }\n\n                // progress_handlers.fire\n                // fulfilled_handlers.fire\n                // rejected_handlers.fire\n                list.add( tuple[ 3 ].fire );\n\n                // deferred.notify = function() { deferred.notifyWith(...) }\n                // deferred.resolve = function() { deferred.resolveWith(...) }\n                // deferred.reject = function() { deferred.rejectWith(...) }\n                deferred[ tuple[ 0 ] ] = function() {\n                    deferred[ tuple[ 0 ] + \"With\" ]( this === deferred ? undefined : this, arguments );\n                    return this;\n                };\n\n                // deferred.notifyWith = list.fireWith\n                // deferred.resolveWith = list.fireWith\n                // deferred.rejectWith = list.fireWith\n                deferred[ tuple[ 0 ] + \"With\" ] = list.fireWith;\n            } );\n\n            // Make the deferred a promise\n            promise.promise( deferred );\n\n            // Call given func if any\n            if ( func ) {\n                func.call( deferred, deferred );\n            }\n\n            // All done!\n            return deferred;\n        },\n\n        // Deferred helper\n        when: function( singleValue ) {\n            var\n\n                // count of uncompleted subordinates\n                remaining = arguments.length,\n\n                // count of unprocessed arguments\n                i = remaining,\n\n                // subordinate fulfillment data\n                resolveContexts = Array( i ),\n                resolveValues = slice.call( arguments ),\n\n                // the primary Deferred\n                primary = jQuery.Deferred(),\n\n                // subordinate callback factory\n                updateFunc = function( i ) {\n                    return function( value ) {\n                        resolveContexts[ i ] = this;\n                        resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;\n                        if ( !( --remaining ) ) {\n                            primary.resolveWith( resolveContexts, resolveValues );\n                        }\n                    };\n                };\n\n            // Single- and empty arguments are adopted like Promise.resolve\n            if ( remaining <= 1 ) {\n                adoptValue( singleValue, primary.done( updateFunc( i ) ).resolve, primary.reject,\n                    !remaining );\n\n                // Use .then() to unwrap secondary thenables (cf. gh-3000)\n                if ( primary.state() === \"pending\" ||\n                    isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {\n\n                    return primary.then();\n                }\n            }\n\n            // Multiple arguments are aggregated like Promise.all array elements\n            while ( i-- ) {\n                adoptValue( resolveValues[ i ], updateFunc( i ), primary.reject );\n            }\n\n            return primary.promise();\n        }\n    } );\n\n\n// These usually indicate a programmer mistake during development,\n// warn about them ASAP rather than swallowing them by default.\n    var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;\n\n// If `jQuery.Deferred.getErrorHook` is defined, `asyncError` is an error\n// captured before the async barrier to get the original error cause\n// which may otherwise be hidden.\n    jQuery.Deferred.exceptionHook = function( error, asyncError ) {\n\n        // Support: IE 8 - 9 only\n        // Console exists when dev tools are open, which can happen at any time\n        if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {\n            window.console.warn( \"jQuery.Deferred exception: \" + error.message,\n                error.stack, asyncError );\n        }\n    };\n\n\n\n\n    jQuery.readyException = function( error ) {\n        window.setTimeout( function() {\n            throw error;\n        } );\n    };\n\n\n\n\n// The deferred used on DOM ready\n    var readyList = jQuery.Deferred();\n\n    jQuery.fn.ready = function( fn ) {\n\n        readyList\n            .then( fn )\n\n            // Wrap jQuery.readyException in a function so that the lookup\n            // happens at the time of error handling instead of callback\n            // registration.\n            .catch( function( error ) {\n                jQuery.readyException( error );\n            } );\n\n        return this;\n    };\n\n    jQuery.extend( {\n\n        // Is the DOM ready to be used? Set to true once it occurs.\n        isReady: false,\n\n        // A counter to track how many items to wait for before\n        // the ready event fires. See trac-6781\n        readyWait: 1,\n\n        // Handle when the DOM is ready\n        ready: function( wait ) {\n\n            // Abort if there are pending holds or we're already ready\n            if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {\n                return;\n            }\n\n            // Remember that the DOM is ready\n            jQuery.isReady = true;\n\n            // If a normal DOM Ready event fired, decrement, and wait if need be\n            if ( wait !== true && --jQuery.readyWait > 0 ) {\n                return;\n            }\n\n            // If there are functions bound, to execute\n            readyList.resolveWith( document, [ jQuery ] );\n        }\n    } );\n\n    jQuery.ready.then = readyList.then;\n\n// The ready event handler and self cleanup method\n    function completed() {\n        document.removeEventListener( \"DOMContentLoaded\", completed );\n        window.removeEventListener( \"load\", completed );\n        jQuery.ready();\n    }\n\n// Catch cases where $(document).ready() is called\n// after the browser event has already occurred.\n// Support: IE <=9 - 10 only\n// Older IE sometimes signals \"interactive\" too soon\n    if ( document.readyState === \"complete\" ||\n        ( document.readyState !== \"loading\" && !document.documentElement.doScroll ) ) {\n\n        // Handle it asynchronously to allow scripts the opportunity to delay ready\n        window.setTimeout( jQuery.ready );\n\n    } else {\n\n        // Use the handy event callback\n        document.addEventListener( \"DOMContentLoaded\", completed );\n\n        // A fallback to window.onload, that will always work\n        window.addEventListener( \"load\", completed );\n    }\n\n\n\n\n// Multifunctional method to get and set values of a collection\n// The value/s can optionally be executed if it's a function\n    var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {\n        var i = 0,\n            len = elems.length,\n            bulk = key == null;\n\n        // Sets many values\n        if ( toType( key ) === \"object\" ) {\n            chainable = true;\n            for ( i in key ) {\n                access( elems, fn, i, key[ i ], true, emptyGet, raw );\n            }\n\n            // Sets one value\n        } else if ( value !== undefined ) {\n            chainable = true;\n\n            if ( !isFunction( value ) ) {\n                raw = true;\n            }\n\n            if ( bulk ) {\n\n                // Bulk operations run against the entire set\n                if ( raw ) {\n                    fn.call( elems, value );\n                    fn = null;\n\n                    // ...except when executing function values\n                } else {\n                    bulk = fn;\n                    fn = function( elem, _key, value ) {\n                        return bulk.call( jQuery( elem ), value );\n                    };\n                }\n            }\n\n            if ( fn ) {\n                for ( ; i < len; i++ ) {\n                    fn(\n                        elems[ i ], key, raw ?\n                            value :\n                            value.call( elems[ i ], i, fn( elems[ i ], key ) )\n                    );\n                }\n            }\n        }\n\n        if ( chainable ) {\n            return elems;\n        }\n\n        // Gets\n        if ( bulk ) {\n            return fn.call( elems );\n        }\n\n        return len ? fn( elems[ 0 ], key ) : emptyGet;\n    };\n\n\n// Matches dashed string for camelizing\n    var rmsPrefix = /^-ms-/,\n        rdashAlpha = /-([a-z])/g;\n\n// Used by camelCase as callback to replace()\n    function fcamelCase( _all, letter ) {\n        return letter.toUpperCase();\n    }\n\n// Convert dashed to camelCase; used by the css and data modules\n// Support: IE <=9 - 11, Edge 12 - 15\n// Microsoft forgot to hump their vendor prefix (trac-9572)\n    function camelCase( string ) {\n        return string.replace( rmsPrefix, \"ms-\" ).replace( rdashAlpha, fcamelCase );\n    }\n    var acceptData = function( owner ) {\n\n        // Accepts only:\n        //  - Node\n        //    - Node.ELEMENT_NODE\n        //    - Node.DOCUMENT_NODE\n        //  - Object\n        //    - Any\n        return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );\n    };\n\n\n\n\n    function Data() {\n        this.expando = jQuery.expando + Data.uid++;\n    }\n\n    Data.uid = 1;\n\n    Data.prototype = {\n\n        cache: function( owner ) {\n\n            // Check if the owner object already has a cache\n            var value = owner[ this.expando ];\n\n            // If not, create one\n            if ( !value ) {\n                value = {};\n\n                // We can accept data for non-element nodes in modern browsers,\n                // but we should not, see trac-8335.\n                // Always return an empty object.\n                if ( acceptData( owner ) ) {\n\n                    // If it is a node unlikely to be stringify-ed or looped over\n                    // use plain assignment\n                    if ( owner.nodeType ) {\n                        owner[ this.expando ] = value;\n\n                        // Otherwise secure it in a non-enumerable property\n                        // configurable must be true to allow the property to be\n                        // deleted when data is removed\n                    } else {\n                        Object.defineProperty( owner, this.expando, {\n                            value: value,\n                            configurable: true\n                        } );\n                    }\n                }\n            }\n\n            return value;\n        },\n        set: function( owner, data, value ) {\n            var prop,\n                cache = this.cache( owner );\n\n            // Handle: [ owner, key, value ] args\n            // Always use camelCase key (gh-2257)\n            if ( typeof data === \"string\" ) {\n                cache[ camelCase( data ) ] = value;\n\n                // Handle: [ owner, { properties } ] args\n            } else {\n\n                // Copy the properties one-by-one to the cache object\n                for ( prop in data ) {\n                    cache[ camelCase( prop ) ] = data[ prop ];\n                }\n            }\n            return cache;\n        },\n        get: function( owner, key ) {\n            return key === undefined ?\n                this.cache( owner ) :\n\n                // Always use camelCase key (gh-2257)\n                owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];\n        },\n        access: function( owner, key, value ) {\n\n            // In cases where either:\n            //\n            //   1. No key was specified\n            //   2. A string key was specified, but no value provided\n            //\n            // Take the \"read\" path and allow the get method to determine\n            // which value to return, respectively either:\n            //\n            //   1. The entire cache object\n            //   2. The data stored at the key\n            //\n            if ( key === undefined ||\n                ( ( key && typeof key === \"string\" ) && value === undefined ) ) {\n\n                return this.get( owner, key );\n            }\n\n            // When the key is not a string, or both a key and value\n            // are specified, set or extend (existing objects) with either:\n            //\n            //   1. An object of properties\n            //   2. A key and value\n            //\n            this.set( owner, key, value );\n\n            // Since the \"set\" path can have two possible entry points\n            // return the expected data based on which path was taken[*]\n            return value !== undefined ? value : key;\n        },\n        remove: function( owner, key ) {\n            var i,\n                cache = owner[ this.expando ];\n\n            if ( cache === undefined ) {\n                return;\n            }\n\n            if ( key !== undefined ) {\n\n                // Support array or space separated string of keys\n                if ( Array.isArray( key ) ) {\n\n                    // If key is an array of keys...\n                    // We always set camelCase keys, so remove that.\n                    key = key.map( camelCase );\n                } else {\n                    key = camelCase( key );\n\n                    // If a key with the spaces exists, use it.\n                    // Otherwise, create an array by matching non-whitespace\n                    key = key in cache ?\n                        [ key ] :\n                        ( key.match( rnothtmlwhite ) || [] );\n                }\n\n                i = key.length;\n\n                while ( i-- ) {\n                    delete cache[ key[ i ] ];\n                }\n            }\n\n            // Remove the expando if there's no more data\n            if ( key === undefined || jQuery.isEmptyObject( cache ) ) {\n\n                // Support: Chrome <=35 - 45\n                // Webkit & Blink performance suffers when deleting properties\n                // from DOM nodes, so set to undefined instead\n                // https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)\n                if ( owner.nodeType ) {\n                    owner[ this.expando ] = undefined;\n                } else {\n                    delete owner[ this.expando ];\n                }\n            }\n        },\n        hasData: function( owner ) {\n            var cache = owner[ this.expando ];\n            return cache !== undefined && !jQuery.isEmptyObject( cache );\n        }\n    };\n    var dataPriv = new Data();\n\n    var dataUser = new Data();\n\n\n\n//\tImplementation Summary\n//\n//\t1. Enforce API surface and semantic compatibility with 1.9.x branch\n//\t2. Improve the module's maintainability by reducing the storage\n//\t\tpaths to a single mechanism.\n//\t3. Use the same single mechanism to support \"private\" and \"user\" data.\n//\t4. _Never_ expose \"private\" data to user code (TODO: Drop _data, _removeData)\n//\t5. Avoid exposing implementation details on user objects (eg. expando properties)\n//\t6. Provide a clear path for implementation upgrade to WeakMap in 2014\n\n    var rbrace = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/,\n        rmultiDash = /[A-Z]/g;\n\n    function getData( data ) {\n        if ( data === \"true\" ) {\n            return true;\n        }\n\n        if ( data === \"false\" ) {\n            return false;\n        }\n\n        if ( data === \"null\" ) {\n            return null;\n        }\n\n        // Only convert to a number if it doesn't change the string\n        if ( data === +data + \"\" ) {\n            return +data;\n        }\n\n        if ( rbrace.test( data ) ) {\n            return JSON.parse( data );\n        }\n\n        return data;\n    }\n\n    function dataAttr( elem, key, data ) {\n        var name;\n\n        // If nothing was found internally, try to fetch any\n        // data from the HTML5 data-* attribute\n        if ( data === undefined && elem.nodeType === 1 ) {\n            name = \"data-\" + key.replace( rmultiDash, \"-$&\" ).toLowerCase();\n            data = elem.getAttribute( name );\n\n            if ( typeof data === \"string\" ) {\n                try {\n                    data = getData( data );\n                } catch ( e ) {}\n\n                // Make sure we set the data so it isn't changed later\n                dataUser.set( elem, key, data );\n            } else {\n                data = undefined;\n            }\n        }\n        return data;\n    }\n\n    jQuery.extend( {\n        hasData: function( elem ) {\n            return dataUser.hasData( elem ) || dataPriv.hasData( elem );\n        },\n\n        data: function( elem, name, data ) {\n            return dataUser.access( elem, name, data );\n        },\n\n        removeData: function( elem, name ) {\n            dataUser.remove( elem, name );\n        },\n\n        // TODO: Now that all calls to _data and _removeData have been replaced\n        // with direct calls to dataPriv methods, these can be deprecated.\n        _data: function( elem, name, data ) {\n            return dataPriv.access( elem, name, data );\n        },\n\n        _removeData: function( elem, name ) {\n            dataPriv.remove( elem, name );\n        }\n    } );\n\n    jQuery.fn.extend( {\n        data: function( key, value ) {\n            var i, name, data,\n                elem = this[ 0 ],\n                attrs = elem && elem.attributes;\n\n            // Gets all values\n            if ( key === undefined ) {\n                if ( this.length ) {\n                    data = dataUser.get( elem );\n\n                    if ( elem.nodeType === 1 && !dataPriv.get( elem, \"hasDataAttrs\" ) ) {\n                        i = attrs.length;\n                        while ( i-- ) {\n\n                            // Support: IE 11 only\n                            // The attrs elements can be null (trac-14894)\n                            if ( attrs[ i ] ) {\n                                name = attrs[ i ].name;\n                                if ( name.indexOf( \"data-\" ) === 0 ) {\n                                    name = camelCase( name.slice( 5 ) );\n                                    dataAttr( elem, name, data[ name ] );\n                                }\n                            }\n                        }\n                        dataPriv.set( elem, \"hasDataAttrs\", true );\n                    }\n                }\n\n                return data;\n            }\n\n            // Sets multiple values\n            if ( typeof key === \"object\" ) {\n                return this.each( function() {\n                    dataUser.set( this, key );\n                } );\n            }\n\n            return access( this, function( value ) {\n                var data;\n\n                // The calling jQuery object (element matches) is not empty\n                // (and therefore has an element appears at this[ 0 ]) and the\n                // `value` parameter was not undefined. An empty jQuery object\n                // will result in `undefined` for elem = this[ 0 ] which will\n                // throw an exception if an attempt to read a data cache is made.\n                if ( elem && value === undefined ) {\n\n                    // Attempt to get data from the cache\n                    // The key will always be camelCased in Data\n                    data = dataUser.get( elem, key );\n                    if ( data !== undefined ) {\n                        return data;\n                    }\n\n                    // Attempt to \"discover\" the data in\n                    // HTML5 custom data-* attrs\n                    data = dataAttr( elem, key );\n                    if ( data !== undefined ) {\n                        return data;\n                    }\n\n                    // We tried really hard, but the data doesn't exist.\n                    return;\n                }\n\n                // Set the data...\n                this.each( function() {\n\n                    // We always store the camelCased key\n                    dataUser.set( this, key, value );\n                } );\n            }, null, value, arguments.length > 1, null, true );\n        },\n\n        removeData: function( key ) {\n            return this.each( function() {\n                dataUser.remove( this, key );\n            } );\n        }\n    } );\n\n\n    jQuery.extend( {\n        queue: function( elem, type, data ) {\n            var queue;\n\n            if ( elem ) {\n                type = ( type || \"fx\" ) + \"queue\";\n                queue = dataPriv.get( elem, type );\n\n                // Speed up dequeue by getting out quickly if this is just a lookup\n                if ( data ) {\n                    if ( !queue || Array.isArray( data ) ) {\n                        queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );\n                    } else {\n                        queue.push( data );\n                    }\n                }\n                return queue || [];\n            }\n        },\n\n        dequeue: function( elem, type ) {\n            type = type || \"fx\";\n\n            var queue = jQuery.queue( elem, type ),\n                startLength = queue.length,\n                fn = queue.shift(),\n                hooks = jQuery._queueHooks( elem, type ),\n                next = function() {\n                    jQuery.dequeue( elem, type );\n                };\n\n            // If the fx queue is dequeued, always remove the progress sentinel\n            if ( fn === \"inprogress\" ) {\n                fn = queue.shift();\n                startLength--;\n            }\n\n            if ( fn ) {\n\n                // Add a progress sentinel to prevent the fx queue from being\n                // automatically dequeued\n                if ( type === \"fx\" ) {\n                    queue.unshift( \"inprogress\" );\n                }\n\n                // Clear up the last queue stop function\n                delete hooks.stop;\n                fn.call( elem, next, hooks );\n            }\n\n            if ( !startLength && hooks ) {\n                hooks.empty.fire();\n            }\n        },\n\n        // Not public - generate a queueHooks object, or return the current one\n        _queueHooks: function( elem, type ) {\n            var key = type + \"queueHooks\";\n            return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {\n                empty: jQuery.Callbacks( \"once memory\" ).add( function() {\n                    dataPriv.remove( elem, [ type + \"queue\", key ] );\n                } )\n            } );\n        }\n    } );\n\n    jQuery.fn.extend( {\n        queue: function( type, data ) {\n            var setter = 2;\n\n            if ( typeof type !== \"string\" ) {\n                data = type;\n                type = \"fx\";\n                setter--;\n            }\n\n            if ( arguments.length < setter ) {\n                return jQuery.queue( this[ 0 ], type );\n            }\n\n            return data === undefined ?\n                this :\n                this.each( function() {\n                    var queue = jQuery.queue( this, type, data );\n\n                    // Ensure a hooks for this queue\n                    jQuery._queueHooks( this, type );\n\n                    if ( type === \"fx\" && queue[ 0 ] !== \"inprogress\" ) {\n                        jQuery.dequeue( this, type );\n                    }\n                } );\n        },\n        dequeue: function( type ) {\n            return this.each( function() {\n                jQuery.dequeue( this, type );\n            } );\n        },\n        clearQueue: function( type ) {\n            return this.queue( type || \"fx\", [] );\n        },\n\n        // Get a promise resolved when queues of a certain type\n        // are emptied (fx is the type by default)\n        promise: function( type, obj ) {\n            var tmp,\n                count = 1,\n                defer = jQuery.Deferred(),\n                elements = this,\n                i = this.length,\n                resolve = function() {\n                    if ( !( --count ) ) {\n                        defer.resolveWith( elements, [ elements ] );\n                    }\n                };\n\n            if ( typeof type !== \"string\" ) {\n                obj = type;\n                type = undefined;\n            }\n            type = type || \"fx\";\n\n            while ( i-- ) {\n                tmp = dataPriv.get( elements[ i ], type + \"queueHooks\" );\n                if ( tmp && tmp.empty ) {\n                    count++;\n                    tmp.empty.add( resolve );\n                }\n            }\n            resolve();\n            return defer.promise( obj );\n        }\n    } );\n    var pnum = ( /[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/ ).source;\n\n    var rcssNum = new RegExp( \"^(?:([+-])=|)(\" + pnum + \")([a-z%]*)$\", \"i\" );\n\n\n    var cssExpand = [ \"Top\", \"Right\", \"Bottom\", \"Left\" ];\n\n    var documentElement = document.documentElement;\n\n\n\n    var isAttached = function( elem ) {\n            return jQuery.contains( elem.ownerDocument, elem );\n        },\n        composed = { composed: true };\n\n    // Support: IE 9 - 11+, Edge 12 - 18+, iOS 10.0 - 10.2 only\n    // Check attachment across shadow DOM boundaries when possible (gh-3504)\n    // Support: iOS 10.0-10.2 only\n    // Early iOS 10 versions support `attachShadow` but not `getRootNode`,\n    // leading to errors. We need to check for `getRootNode`.\n    if ( documentElement.getRootNode ) {\n        isAttached = function( elem ) {\n            return jQuery.contains( elem.ownerDocument, elem ) ||\n                elem.getRootNode( composed ) === elem.ownerDocument;\n        };\n    }\n    var isHiddenWithinTree = function( elem, el ) {\n\n        // isHiddenWithinTree might be called from jQuery#filter function;\n        // in that case, element will be second argument\n        elem = el || elem;\n\n        // Inline style trumps all\n        return elem.style.display === \"none\" ||\n            elem.style.display === \"\" &&\n\n            // Otherwise, check computed style\n            // Support: Firefox <=43 - 45\n            // Disconnected elements can have computed display: none, so first confirm that elem is\n            // in the document.\n            isAttached( elem ) &&\n\n            jQuery.css( elem, \"display\" ) === \"none\";\n    };\n\n\n\n    function adjustCSS( elem, prop, valueParts, tween ) {\n        var adjusted, scale,\n            maxIterations = 20,\n            currentValue = tween ?\n                function() {\n                    return tween.cur();\n                } :\n                function() {\n                    return jQuery.css( elem, prop, \"\" );\n                },\n            initial = currentValue(),\n            unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" ),\n\n            // Starting value computation is required for potential unit mismatches\n            initialInUnit = elem.nodeType &&\n                ( jQuery.cssNumber[ prop ] || unit !== \"px\" && +initial ) &&\n                rcssNum.exec( jQuery.css( elem, prop ) );\n\n        if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {\n\n            // Support: Firefox <=54\n            // Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)\n            initial = initial / 2;\n\n            // Trust units reported by jQuery.css\n            unit = unit || initialInUnit[ 3 ];\n\n            // Iteratively approximate from a nonzero starting point\n            initialInUnit = +initial || 1;\n\n            while ( maxIterations-- ) {\n\n                // Evaluate and update our best guess (doubling guesses that zero out).\n                // Finish if the scale equals or crosses 1 (making the old*new product non-positive).\n                jQuery.style( elem, prop, initialInUnit + unit );\n                if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {\n                    maxIterations = 0;\n                }\n                initialInUnit = initialInUnit / scale;\n\n            }\n\n            initialInUnit = initialInUnit * 2;\n            jQuery.style( elem, prop, initialInUnit + unit );\n\n            // Make sure we update the tween properties later on\n            valueParts = valueParts || [];\n        }\n\n        if ( valueParts ) {\n            initialInUnit = +initialInUnit || +initial || 0;\n\n            // Apply relative offset (+=/-=) if specified\n            adjusted = valueParts[ 1 ] ?\n                initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :\n                +valueParts[ 2 ];\n            if ( tween ) {\n                tween.unit = unit;\n                tween.start = initialInUnit;\n                tween.end = adjusted;\n            }\n        }\n        return adjusted;\n    }\n\n\n    var defaultDisplayMap = {};\n\n    function getDefaultDisplay( elem ) {\n        var temp,\n            doc = elem.ownerDocument,\n            nodeName = elem.nodeName,\n            display = defaultDisplayMap[ nodeName ];\n\n        if ( display ) {\n            return display;\n        }\n\n        temp = doc.body.appendChild( doc.createElement( nodeName ) );\n        display = jQuery.css( temp, \"display\" );\n\n        temp.parentNode.removeChild( temp );\n\n        if ( display === \"none\" ) {\n            display = \"block\";\n        }\n        defaultDisplayMap[ nodeName ] = display;\n\n        return display;\n    }\n\n    function showHide( elements, show ) {\n        var display, elem,\n            values = [],\n            index = 0,\n            length = elements.length;\n\n        // Determine new display value for elements that need to change\n        for ( ; index < length; index++ ) {\n            elem = elements[ index ];\n            if ( !elem.style ) {\n                continue;\n            }\n\n            display = elem.style.display;\n            if ( show ) {\n\n                // Since we force visibility upon cascade-hidden elements, an immediate (and slow)\n                // check is required in this first loop unless we have a nonempty display value (either\n                // inline or about-to-be-restored)\n                if ( display === \"none\" ) {\n                    values[ index ] = dataPriv.get( elem, \"display\" ) || null;\n                    if ( !values[ index ] ) {\n                        elem.style.display = \"\";\n                    }\n                }\n                if ( elem.style.display === \"\" && isHiddenWithinTree( elem ) ) {\n                    values[ index ] = getDefaultDisplay( elem );\n                }\n            } else {\n                if ( display !== \"none\" ) {\n                    values[ index ] = \"none\";\n\n                    // Remember what we're overwriting\n                    dataPriv.set( elem, \"display\", display );\n                }\n            }\n        }\n\n        // Set the display of the elements in a second loop to avoid constant reflow\n        for ( index = 0; index < length; index++ ) {\n            if ( values[ index ] != null ) {\n                elements[ index ].style.display = values[ index ];\n            }\n        }\n\n        return elements;\n    }\n\n    jQuery.fn.extend( {\n        show: function() {\n            return showHide( this, true );\n        },\n        hide: function() {\n            return showHide( this );\n        },\n        toggle: function( state ) {\n            if ( typeof state === \"boolean\" ) {\n                return state ? this.show() : this.hide();\n            }\n\n            return this.each( function() {\n                if ( isHiddenWithinTree( this ) ) {\n                    jQuery( this ).show();\n                } else {\n                    jQuery( this ).hide();\n                }\n            } );\n        }\n    } );\n    var rcheckableType = ( /^(?:checkbox|radio)$/i );\n\n    var rtagName = ( /<([a-z][^\\/\\0>\\x20\\t\\r\\n\\f]*)/i );\n\n    var rscriptType = ( /^$|^module$|\\/(?:java|ecma)script/i );\n\n\n\n    ( function() {\n        var fragment = document.createDocumentFragment(),\n            div = fragment.appendChild( document.createElement( \"div\" ) ),\n            input = document.createElement( \"input\" );\n\n        // Support: Android 4.0 - 4.3 only\n        // Check state lost if the name is set (trac-11217)\n        // Support: Windows Web Apps (WWA)\n        // `name` and `type` must use .setAttribute for WWA (trac-14901)\n        input.setAttribute( \"type\", \"radio\" );\n        input.setAttribute( \"checked\", \"checked\" );\n        input.setAttribute( \"name\", \"t\" );\n\n        div.appendChild( input );\n\n        // Support: Android <=4.1 only\n        // Older WebKit doesn't clone checked state correctly in fragments\n        support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;\n\n        // Support: IE <=11 only\n        // Make sure textarea (and checkbox) defaultValue is properly cloned\n        div.innerHTML = \"<textarea>x</textarea>\";\n        support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;\n\n        // Support: IE <=9 only\n        // IE <=9 replaces <option> tags with their contents when inserted outside of\n        // the select element.\n        div.innerHTML = \"<option></option>\";\n        support.option = !!div.lastChild;\n    } )();\n\n\n// We have to close these tags to support XHTML (trac-13200)\n    var wrapMap = {\n\n        // XHTML parsers do not magically insert elements in the\n        // same way that tag soup parsers do. So we cannot shorten\n        // this by omitting <tbody> or other required elements.\n        thead: [ 1, \"<table>\", \"</table>\" ],\n        col: [ 2, \"<table><colgroup>\", \"</colgroup></table>\" ],\n        tr: [ 2, \"<table><tbody>\", \"</tbody></table>\" ],\n        td: [ 3, \"<table><tbody><tr>\", \"</tr></tbody></table>\" ],\n\n        _default: [ 0, \"\", \"\" ]\n    };\n\n    wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;\n    wrapMap.th = wrapMap.td;\n\n// Support: IE <=9 only\n    if ( !support.option ) {\n        wrapMap.optgroup = wrapMap.option = [ 1, \"<select multiple='multiple'>\", \"</select>\" ];\n    }\n\n\n    function getAll( context, tag ) {\n\n        // Support: IE <=9 - 11 only\n        // Use typeof to avoid zero-argument method invocation on host objects (trac-15151)\n        var ret;\n\n        if ( typeof context.getElementsByTagName !== \"undefined\" ) {\n            ret = context.getElementsByTagName( tag || \"*\" );\n\n        } else if ( typeof context.querySelectorAll !== \"undefined\" ) {\n            ret = context.querySelectorAll( tag || \"*\" );\n\n        } else {\n            ret = [];\n        }\n\n        if ( tag === undefined || tag && nodeName( context, tag ) ) {\n            return jQuery.merge( [ context ], ret );\n        }\n\n        return ret;\n    }\n\n\n// Mark scripts as having already been evaluated\n    function setGlobalEval( elems, refElements ) {\n        var i = 0,\n            l = elems.length;\n\n        for ( ; i < l; i++ ) {\n            dataPriv.set(\n                elems[ i ],\n                \"globalEval\",\n                !refElements || dataPriv.get( refElements[ i ], \"globalEval\" )\n            );\n        }\n    }\n\n\n    var rhtml = /<|&#?\\w+;/;\n\n    function buildFragment( elems, context, scripts, selection, ignored ) {\n        var elem, tmp, tag, wrap, attached, j,\n            fragment = context.createDocumentFragment(),\n            nodes = [],\n            i = 0,\n            l = elems.length;\n\n        for ( ; i < l; i++ ) {\n            elem = elems[ i ];\n\n            if ( elem || elem === 0 ) {\n\n                // Add nodes directly\n                if ( toType( elem ) === \"object\" ) {\n\n                    // Support: Android <=4.0 only, PhantomJS 1 only\n                    // push.apply(_, arraylike) throws on ancient WebKit\n                    jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );\n\n                    // Convert non-html into a text node\n                } else if ( !rhtml.test( elem ) ) {\n                    nodes.push( context.createTextNode( elem ) );\n\n                    // Convert html into DOM nodes\n                } else {\n                    tmp = tmp || fragment.appendChild( context.createElement( \"div\" ) );\n\n                    // Deserialize a standard representation\n                    tag = ( rtagName.exec( elem ) || [ \"\", \"\" ] )[ 1 ].toLowerCase();\n                    wrap = wrapMap[ tag ] || wrapMap._default;\n                    tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];\n\n                    // Descend through wrappers to the right content\n                    j = wrap[ 0 ];\n                    while ( j-- ) {\n                        tmp = tmp.lastChild;\n                    }\n\n                    // Support: Android <=4.0 only, PhantomJS 1 only\n                    // push.apply(_, arraylike) throws on ancient WebKit\n                    jQuery.merge( nodes, tmp.childNodes );\n\n                    // Remember the top-level container\n                    tmp = fragment.firstChild;\n\n                    // Ensure the created nodes are orphaned (trac-12392)\n                    tmp.textContent = \"\";\n                }\n            }\n        }\n\n        // Remove wrapper from fragment\n        fragment.textContent = \"\";\n\n        i = 0;\n        while ( ( elem = nodes[ i++ ] ) ) {\n\n            // Skip elements already in the context collection (trac-4087)\n            if ( selection && jQuery.inArray( elem, selection ) > -1 ) {\n                if ( ignored ) {\n                    ignored.push( elem );\n                }\n                continue;\n            }\n\n            attached = isAttached( elem );\n\n            // Append to fragment\n            tmp = getAll( fragment.appendChild( elem ), \"script\" );\n\n            // Preserve script evaluation history\n            if ( attached ) {\n                setGlobalEval( tmp );\n            }\n\n            // Capture executables\n            if ( scripts ) {\n                j = 0;\n                while ( ( elem = tmp[ j++ ] ) ) {\n                    if ( rscriptType.test( elem.type || \"\" ) ) {\n                        scripts.push( elem );\n                    }\n                }\n            }\n        }\n\n        return fragment;\n    }\n\n\n    var rtypenamespace = /^([^.]*)(?:\\.(.+)|)/;\n\n    function returnTrue() {\n        return true;\n    }\n\n    function returnFalse() {\n        return false;\n    }\n\n    function on( elem, types, selector, data, fn, one ) {\n        var origFn, type;\n\n        // Types can be a map of types/handlers\n        if ( typeof types === \"object\" ) {\n\n            // ( types-Object, selector, data )\n            if ( typeof selector !== \"string\" ) {\n\n                // ( types-Object, data )\n                data = data || selector;\n                selector = undefined;\n            }\n            for ( type in types ) {\n                on( elem, type, selector, data, types[ type ], one );\n            }\n            return elem;\n        }\n\n        if ( data == null && fn == null ) {\n\n            // ( types, fn )\n            fn = selector;\n            data = selector = undefined;\n        } else if ( fn == null ) {\n            if ( typeof selector === \"string\" ) {\n\n                // ( types, selector, fn )\n                fn = data;\n                data = undefined;\n            } else {\n\n                // ( types, data, fn )\n                fn = data;\n                data = selector;\n                selector = undefined;\n            }\n        }\n        if ( fn === false ) {\n            fn = returnFalse;\n        } else if ( !fn ) {\n            return elem;\n        }\n\n        if ( one === 1 ) {\n            origFn = fn;\n            fn = function( event ) {\n\n                // Can use an empty set, since event contains the info\n                jQuery().off( event );\n                return origFn.apply( this, arguments );\n            };\n\n            // Use same guid so caller can remove using origFn\n            fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );\n        }\n        return elem.each( function() {\n            jQuery.event.add( this, types, fn, data, selector );\n        } );\n    }\n\n    /*\n * Helper functions for managing events -- not part of the public interface.\n * Props to Dean Edwards' addEvent library for many of the ideas.\n */\n    jQuery.event = {\n\n        global: {},\n\n        add: function( elem, types, handler, data, selector ) {\n\n            var handleObjIn, eventHandle, tmp,\n                events, t, handleObj,\n                special, handlers, type, namespaces, origType,\n                elemData = dataPriv.get( elem );\n\n            // Only attach events to objects that accept data\n            if ( !acceptData( elem ) ) {\n                return;\n            }\n\n            // Caller can pass in an object of custom data in lieu of the handler\n            if ( handler.handler ) {\n                handleObjIn = handler;\n                handler = handleObjIn.handler;\n                selector = handleObjIn.selector;\n            }\n\n            // Ensure that invalid selectors throw exceptions at attach time\n            // Evaluate against documentElement in case elem is a non-element node (e.g., document)\n            if ( selector ) {\n                jQuery.find.matchesSelector( documentElement, selector );\n            }\n\n            // Make sure that the handler has a unique ID, used to find/remove it later\n            if ( !handler.guid ) {\n                handler.guid = jQuery.guid++;\n            }\n\n            // Init the element's event structure and main handler, if this is the first\n            if ( !( events = elemData.events ) ) {\n                events = elemData.events = Object.create( null );\n            }\n            if ( !( eventHandle = elemData.handle ) ) {\n                eventHandle = elemData.handle = function( e ) {\n\n                    // Discard the second event of a jQuery.event.trigger() and\n                    // when an event is called after a page has unloaded\n                    return typeof jQuery !== \"undefined\" && jQuery.event.triggered !== e.type ?\n                        jQuery.event.dispatch.apply( elem, arguments ) : undefined;\n                };\n            }\n\n            // Handle multiple events separated by a space\n            types = ( types || \"\" ).match( rnothtmlwhite ) || [ \"\" ];\n            t = types.length;\n            while ( t-- ) {\n                tmp = rtypenamespace.exec( types[ t ] ) || [];\n                type = origType = tmp[ 1 ];\n                namespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n                // There *must* be a type, no attaching namespace-only handlers\n                if ( !type ) {\n                    continue;\n                }\n\n                // If event changes its type, use the special event handlers for the changed type\n                special = jQuery.event.special[ type ] || {};\n\n                // If selector defined, determine special event api type, otherwise given type\n                type = ( selector ? special.delegateType : special.bindType ) || type;\n\n                // Update special based on newly reset type\n                special = jQuery.event.special[ type ] || {};\n\n                // handleObj is passed to all event handlers\n                handleObj = jQuery.extend( {\n                    type: type,\n                    origType: origType,\n                    data: data,\n                    handler: handler,\n                    guid: handler.guid,\n                    selector: selector,\n                    needsContext: selector && jQuery.expr.match.needsContext.test( selector ),\n                    namespace: namespaces.join( \".\" )\n                }, handleObjIn );\n\n                // Init the event handler queue if we're the first\n                if ( !( handlers = events[ type ] ) ) {\n                    handlers = events[ type ] = [];\n                    handlers.delegateCount = 0;\n\n                    // Only use addEventListener if the special events handler returns false\n                    if ( !special.setup ||\n                        special.setup.call( elem, data, namespaces, eventHandle ) === false ) {\n\n                        if ( elem.addEventListener ) {\n                            elem.addEventListener( type, eventHandle );\n                        }\n                    }\n                }\n\n                if ( special.add ) {\n                    special.add.call( elem, handleObj );\n\n                    if ( !handleObj.handler.guid ) {\n                        handleObj.handler.guid = handler.guid;\n                    }\n                }\n\n                // Add to the element's handler list, delegates in front\n                if ( selector ) {\n                    handlers.splice( handlers.delegateCount++, 0, handleObj );\n                } else {\n                    handlers.push( handleObj );\n                }\n\n                // Keep track of which events have ever been used, for event optimization\n                jQuery.event.global[ type ] = true;\n            }\n\n        },\n\n        // Detach an event or set of events from an element\n        remove: function( elem, types, handler, selector, mappedTypes ) {\n\n            var j, origCount, tmp,\n                events, t, handleObj,\n                special, handlers, type, namespaces, origType,\n                elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );\n\n            if ( !elemData || !( events = elemData.events ) ) {\n                return;\n            }\n\n            // Once for each type.namespace in types; type may be omitted\n            types = ( types || \"\" ).match( rnothtmlwhite ) || [ \"\" ];\n            t = types.length;\n            while ( t-- ) {\n                tmp = rtypenamespace.exec( types[ t ] ) || [];\n                type = origType = tmp[ 1 ];\n                namespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n                // Unbind all events (on this namespace, if provided) for the element\n                if ( !type ) {\n                    for ( type in events ) {\n                        jQuery.event.remove( elem, type + types[ t ], handler, selector, true );\n                    }\n                    continue;\n                }\n\n                special = jQuery.event.special[ type ] || {};\n                type = ( selector ? special.delegateType : special.bindType ) || type;\n                handlers = events[ type ] || [];\n                tmp = tmp[ 2 ] &&\n                    new RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" );\n\n                // Remove matching events\n                origCount = j = handlers.length;\n                while ( j-- ) {\n                    handleObj = handlers[ j ];\n\n                    if ( ( mappedTypes || origType === handleObj.origType ) &&\n                        ( !handler || handler.guid === handleObj.guid ) &&\n                        ( !tmp || tmp.test( handleObj.namespace ) ) &&\n                        ( !selector || selector === handleObj.selector ||\n                            selector === \"**\" && handleObj.selector ) ) {\n                        handlers.splice( j, 1 );\n\n                        if ( handleObj.selector ) {\n                            handlers.delegateCount--;\n                        }\n                        if ( special.remove ) {\n                            special.remove.call( elem, handleObj );\n                        }\n                    }\n                }\n\n                // Remove generic event handler if we removed something and no more handlers exist\n                // (avoids potential for endless recursion during removal of special event handlers)\n                if ( origCount && !handlers.length ) {\n                    if ( !special.teardown ||\n                        special.teardown.call( elem, namespaces, elemData.handle ) === false ) {\n\n                        jQuery.removeEvent( elem, type, elemData.handle );\n                    }\n\n                    delete events[ type ];\n                }\n            }\n\n            // Remove data and the expando if it's no longer used\n            if ( jQuery.isEmptyObject( events ) ) {\n                dataPriv.remove( elem, \"handle events\" );\n            }\n        },\n\n        dispatch: function( nativeEvent ) {\n\n            var i, j, ret, matched, handleObj, handlerQueue,\n                args = new Array( arguments.length ),\n\n                // Make a writable jQuery.Event from the native event object\n                event = jQuery.event.fix( nativeEvent ),\n\n                handlers = (\n                    dataPriv.get( this, \"events\" ) || Object.create( null )\n                )[ event.type ] || [],\n                special = jQuery.event.special[ event.type ] || {};\n\n            // Use the fix-ed jQuery.Event rather than the (read-only) native event\n            args[ 0 ] = event;\n\n            for ( i = 1; i < arguments.length; i++ ) {\n                args[ i ] = arguments[ i ];\n            }\n\n            event.delegateTarget = this;\n\n            // Call the preDispatch hook for the mapped type, and let it bail if desired\n            if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {\n                return;\n            }\n\n            // Determine handlers\n            handlerQueue = jQuery.event.handlers.call( this, event, handlers );\n\n            // Run delegates first; they may want to stop propagation beneath us\n            i = 0;\n            while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {\n                event.currentTarget = matched.elem;\n\n                j = 0;\n                while ( ( handleObj = matched.handlers[ j++ ] ) &&\n                !event.isImmediatePropagationStopped() ) {\n\n                    // If the event is namespaced, then each handler is only invoked if it is\n                    // specially universal or its namespaces are a superset of the event's.\n                    if ( !event.rnamespace || handleObj.namespace === false ||\n                        event.rnamespace.test( handleObj.namespace ) ) {\n\n                        event.handleObj = handleObj;\n                        event.data = handleObj.data;\n\n                        ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||\n                            handleObj.handler ).apply( matched.elem, args );\n\n                        if ( ret !== undefined ) {\n                            if ( ( event.result = ret ) === false ) {\n                                event.preventDefault();\n                                event.stopPropagation();\n                            }\n                        }\n                    }\n                }\n            }\n\n            // Call the postDispatch hook for the mapped type\n            if ( special.postDispatch ) {\n                special.postDispatch.call( this, event );\n            }\n\n            return event.result;\n        },\n\n        handlers: function( event, handlers ) {\n            var i, handleObj, sel, matchedHandlers, matchedSelectors,\n                handlerQueue = [],\n                delegateCount = handlers.delegateCount,\n                cur = event.target;\n\n            // Find delegate handlers\n            if ( delegateCount &&\n\n                // Support: IE <=9\n                // Black-hole SVG <use> instance trees (trac-13180)\n                cur.nodeType &&\n\n                // Support: Firefox <=42\n                // Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)\n                // https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click\n                // Support: IE 11 only\n                // ...but not arrow key \"clicks\" of radio inputs, which can have `button` -1 (gh-2343)\n                !( event.type === \"click\" && event.button >= 1 ) ) {\n\n                for ( ; cur !== this; cur = cur.parentNode || this ) {\n\n                    // Don't check non-elements (trac-13208)\n                    // Don't process clicks on disabled elements (trac-6911, trac-8165, trac-11382, trac-11764)\n                    if ( cur.nodeType === 1 && !( event.type === \"click\" && cur.disabled === true ) ) {\n                        matchedHandlers = [];\n                        matchedSelectors = {};\n                        for ( i = 0; i < delegateCount; i++ ) {\n                            handleObj = handlers[ i ];\n\n                            // Don't conflict with Object.prototype properties (trac-13203)\n                            sel = handleObj.selector + \" \";\n\n                            if ( matchedSelectors[ sel ] === undefined ) {\n                                matchedSelectors[ sel ] = handleObj.needsContext ?\n                                    jQuery( sel, this ).index( cur ) > -1 :\n                                    jQuery.find( sel, this, null, [ cur ] ).length;\n                            }\n                            if ( matchedSelectors[ sel ] ) {\n                                matchedHandlers.push( handleObj );\n                            }\n                        }\n                        if ( matchedHandlers.length ) {\n                            handlerQueue.push( { elem: cur, handlers: matchedHandlers } );\n                        }\n                    }\n                }\n            }\n\n            // Add the remaining (directly-bound) handlers\n            cur = this;\n            if ( delegateCount < handlers.length ) {\n                handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );\n            }\n\n            return handlerQueue;\n        },\n\n        addProp: function( name, hook ) {\n            Object.defineProperty( jQuery.Event.prototype, name, {\n                enumerable: true,\n                configurable: true,\n\n                get: isFunction( hook ) ?\n                    function() {\n                        if ( this.originalEvent ) {\n                            return hook( this.originalEvent );\n                        }\n                    } :\n                    function() {\n                        if ( this.originalEvent ) {\n                            return this.originalEvent[ name ];\n                        }\n                    },\n\n                set: function( value ) {\n                    Object.defineProperty( this, name, {\n                        enumerable: true,\n                        configurable: true,\n                        writable: true,\n                        value: value\n                    } );\n                }\n            } );\n        },\n\n        fix: function( originalEvent ) {\n            return originalEvent[ jQuery.expando ] ?\n                originalEvent :\n                new jQuery.Event( originalEvent );\n        },\n\n        special: {\n            load: {\n\n                // Prevent triggered image.load events from bubbling to window.load\n                noBubble: true\n            },\n            click: {\n\n                // Utilize native event to ensure correct state for checkable inputs\n                setup: function( data ) {\n\n                    // For mutual compressibility with _default, replace `this` access with a local var.\n                    // `|| data` is dead code meant only to preserve the variable through minification.\n                    var el = this || data;\n\n                    // Claim the first handler\n                    if ( rcheckableType.test( el.type ) &&\n                        el.click && nodeName( el, \"input\" ) ) {\n\n                        // dataPriv.set( el, \"click\", ... )\n                        leverageNative( el, \"click\", true );\n                    }\n\n                    // Return false to allow normal processing in the caller\n                    return false;\n                },\n                trigger: function( data ) {\n\n                    // For mutual compressibility with _default, replace `this` access with a local var.\n                    // `|| data` is dead code meant only to preserve the variable through minification.\n                    var el = this || data;\n\n                    // Force setup before triggering a click\n                    if ( rcheckableType.test( el.type ) &&\n                        el.click && nodeName( el, \"input\" ) ) {\n\n                        leverageNative( el, \"click\" );\n                    }\n\n                    // Return non-false to allow normal event-path propagation\n                    return true;\n                },\n\n                // For cross-browser consistency, suppress native .click() on links\n                // Also prevent it if we're currently inside a leveraged native-event stack\n                _default: function( event ) {\n                    var target = event.target;\n                    return rcheckableType.test( target.type ) &&\n                        target.click && nodeName( target, \"input\" ) &&\n                        dataPriv.get( target, \"click\" ) ||\n                        nodeName( target, \"a\" );\n                }\n            },\n\n            beforeunload: {\n                postDispatch: function( event ) {\n\n                    // Support: Firefox 20+\n                    // Firefox doesn't alert if the returnValue field is not set.\n                    if ( event.result !== undefined && event.originalEvent ) {\n                        event.originalEvent.returnValue = event.result;\n                    }\n                }\n            }\n        }\n    };\n\n// Ensure the presence of an event listener that handles manually-triggered\n// synthetic events by interrupting progress until reinvoked in response to\n// *native* events that it fires directly, ensuring that state changes have\n// already occurred before other listeners are invoked.\n    function leverageNative( el, type, isSetup ) {\n\n        // Missing `isSetup` indicates a trigger call, which must force setup through jQuery.event.add\n        if ( !isSetup ) {\n            if ( dataPriv.get( el, type ) === undefined ) {\n                jQuery.event.add( el, type, returnTrue );\n            }\n            return;\n        }\n\n        // Register the controller as a special universal handler for all event namespaces\n        dataPriv.set( el, type, false );\n        jQuery.event.add( el, type, {\n            namespace: false,\n            handler: function( event ) {\n                var result,\n                    saved = dataPriv.get( this, type );\n\n                if ( ( event.isTrigger & 1 ) && this[ type ] ) {\n\n                    // Interrupt processing of the outer synthetic .trigger()ed event\n                    if ( !saved ) {\n\n                        // Store arguments for use when handling the inner native event\n                        // There will always be at least one argument (an event object), so this array\n                        // will not be confused with a leftover capture object.\n                        saved = slice.call( arguments );\n                        dataPriv.set( this, type, saved );\n\n                        // Trigger the native event and capture its result\n                        this[ type ]();\n                        result = dataPriv.get( this, type );\n                        dataPriv.set( this, type, false );\n\n                        if ( saved !== result ) {\n\n                            // Cancel the outer synthetic event\n                            event.stopImmediatePropagation();\n                            event.preventDefault();\n\n                            return result;\n                        }\n\n                        // If this is an inner synthetic event for an event with a bubbling surrogate\n                        // (focus or blur), assume that the surrogate already propagated from triggering\n                        // the native event and prevent that from happening again here.\n                        // This technically gets the ordering wrong w.r.t. to `.trigger()` (in which the\n                        // bubbling surrogate propagates *after* the non-bubbling base), but that seems\n                        // less bad than duplication.\n                    } else if ( ( jQuery.event.special[ type ] || {} ).delegateType ) {\n                        event.stopPropagation();\n                    }\n\n                    // If this is a native event triggered above, everything is now in order\n                    // Fire an inner synthetic event with the original arguments\n                } else if ( saved ) {\n\n                    // ...and capture the result\n                    dataPriv.set( this, type, jQuery.event.trigger(\n                        saved[ 0 ],\n                        saved.slice( 1 ),\n                        this\n                    ) );\n\n                    // Abort handling of the native event by all jQuery handlers while allowing\n                    // native handlers on the same element to run. On target, this is achieved\n                    // by stopping immediate propagation just on the jQuery event. However,\n                    // the native event is re-wrapped by a jQuery one on each level of the\n                    // propagation so the only way to stop it for jQuery is to stop it for\n                    // everyone via native `stopPropagation()`. This is not a problem for\n                    // focus/blur which don't bubble, but it does also stop click on checkboxes\n                    // and radios. We accept this limitation.\n                    event.stopPropagation();\n                    event.isImmediatePropagationStopped = returnTrue;\n                }\n            }\n        } );\n    }\n\n    jQuery.removeEvent = function( elem, type, handle ) {\n\n        // This \"if\" is needed for plain objects\n        if ( elem.removeEventListener ) {\n            elem.removeEventListener( type, handle );\n        }\n    };\n\n    jQuery.Event = function( src, props ) {\n\n        // Allow instantiation without the 'new' keyword\n        if ( !( this instanceof jQuery.Event ) ) {\n            return new jQuery.Event( src, props );\n        }\n\n        // Event object\n        if ( src && src.type ) {\n            this.originalEvent = src;\n            this.type = src.type;\n\n            // Events bubbling up the document may have been marked as prevented\n            // by a handler lower down the tree; reflect the correct value.\n            this.isDefaultPrevented = src.defaultPrevented ||\n            src.defaultPrevented === undefined &&\n\n            // Support: Android <=2.3 only\n            src.returnValue === false ?\n                returnTrue :\n                returnFalse;\n\n            // Create target properties\n            // Support: Safari <=6 - 7 only\n            // Target should not be a text node (trac-504, trac-13143)\n            this.target = ( src.target && src.target.nodeType === 3 ) ?\n                src.target.parentNode :\n                src.target;\n\n            this.currentTarget = src.currentTarget;\n            this.relatedTarget = src.relatedTarget;\n\n            // Event type\n        } else {\n            this.type = src;\n        }\n\n        // Put explicitly provided properties onto the event object\n        if ( props ) {\n            jQuery.extend( this, props );\n        }\n\n        // Create a timestamp if incoming event doesn't have one\n        this.timeStamp = src && src.timeStamp || Date.now();\n\n        // Mark it as fixed\n        this[ jQuery.expando ] = true;\n    };\n\n// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding\n// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html\n    jQuery.Event.prototype = {\n        constructor: jQuery.Event,\n        isDefaultPrevented: returnFalse,\n        isPropagationStopped: returnFalse,\n        isImmediatePropagationStopped: returnFalse,\n        isSimulated: false,\n\n        preventDefault: function() {\n            var e = this.originalEvent;\n\n            this.isDefaultPrevented = returnTrue;\n\n            if ( e && !this.isSimulated ) {\n                e.preventDefault();\n            }\n        },\n        stopPropagation: function() {\n            var e = this.originalEvent;\n\n            this.isPropagationStopped = returnTrue;\n\n            if ( e && !this.isSimulated ) {\n                e.stopPropagation();\n            }\n        },\n        stopImmediatePropagation: function() {\n            var e = this.originalEvent;\n\n            this.isImmediatePropagationStopped = returnTrue;\n\n            if ( e && !this.isSimulated ) {\n                e.stopImmediatePropagation();\n            }\n\n            this.stopPropagation();\n        }\n    };\n\n// Includes all common event props including KeyEvent and MouseEvent specific props\n    jQuery.each( {\n        altKey: true,\n        bubbles: true,\n        cancelable: true,\n        changedTouches: true,\n        ctrlKey: true,\n        detail: true,\n        eventPhase: true,\n        metaKey: true,\n        pageX: true,\n        pageY: true,\n        shiftKey: true,\n        view: true,\n        \"char\": true,\n        code: true,\n        charCode: true,\n        key: true,\n        keyCode: true,\n        button: true,\n        buttons: true,\n        clientX: true,\n        clientY: true,\n        offsetX: true,\n        offsetY: true,\n        pointerId: true,\n        pointerType: true,\n        screenX: true,\n        screenY: true,\n        targetTouches: true,\n        toElement: true,\n        touches: true,\n        which: true\n    }, jQuery.event.addProp );\n\n    jQuery.each( { focus: \"focusin\", blur: \"focusout\" }, function( type, delegateType ) {\n\n        function focusMappedHandler( nativeEvent ) {\n            if ( document.documentMode ) {\n\n                // Support: IE 11+\n                // Attach a single focusin/focusout handler on the document while someone wants\n                // focus/blur. This is because the former are synchronous in IE while the latter\n                // are async. In other browsers, all those handlers are invoked synchronously.\n\n                // `handle` from private data would already wrap the event, but we need\n                // to change the `type` here.\n                var handle = dataPriv.get( this, \"handle\" ),\n                    event = jQuery.event.fix( nativeEvent );\n                event.type = nativeEvent.type === \"focusin\" ? \"focus\" : \"blur\";\n                event.isSimulated = true;\n\n                // First, handle focusin/focusout\n                handle( nativeEvent );\n\n                // ...then, handle focus/blur\n                //\n                // focus/blur don't bubble while focusin/focusout do; simulate the former by only\n                // invoking the handler at the lower level.\n                if ( event.target === event.currentTarget ) {\n\n                    // The setup part calls `leverageNative`, which, in turn, calls\n                    // `jQuery.event.add`, so event handle will already have been set\n                    // by this point.\n                    handle( event );\n                }\n            } else {\n\n                // For non-IE browsers, attach a single capturing handler on the document\n                // while someone wants focusin/focusout.\n                jQuery.event.simulate( delegateType, nativeEvent.target,\n                    jQuery.event.fix( nativeEvent ) );\n            }\n        }\n\n        jQuery.event.special[ type ] = {\n\n            // Utilize native event if possible so blur/focus sequence is correct\n            setup: function() {\n\n                var attaches;\n\n                // Claim the first handler\n                // dataPriv.set( this, \"focus\", ... )\n                // dataPriv.set( this, \"blur\", ... )\n                leverageNative( this, type, true );\n\n                if ( document.documentMode ) {\n\n                    // Support: IE 9 - 11+\n                    // We use the same native handler for focusin & focus (and focusout & blur)\n                    // so we need to coordinate setup & teardown parts between those events.\n                    // Use `delegateType` as the key as `type` is already used by `leverageNative`.\n                    attaches = dataPriv.get( this, delegateType );\n                    if ( !attaches ) {\n                        this.addEventListener( delegateType, focusMappedHandler );\n                    }\n                    dataPriv.set( this, delegateType, ( attaches || 0 ) + 1 );\n                } else {\n\n                    // Return false to allow normal processing in the caller\n                    return false;\n                }\n            },\n            trigger: function() {\n\n                // Force setup before trigger\n                leverageNative( this, type );\n\n                // Return non-false to allow normal event-path propagation\n                return true;\n            },\n\n            teardown: function() {\n                var attaches;\n\n                if ( document.documentMode ) {\n                    attaches = dataPriv.get( this, delegateType ) - 1;\n                    if ( !attaches ) {\n                        this.removeEventListener( delegateType, focusMappedHandler );\n                        dataPriv.remove( this, delegateType );\n                    } else {\n                        dataPriv.set( this, delegateType, attaches );\n                    }\n                } else {\n\n                    // Return false to indicate standard teardown should be applied\n                    return false;\n                }\n            },\n\n            // Suppress native focus or blur if we're currently inside\n            // a leveraged native-event stack\n            _default: function( event ) {\n                return dataPriv.get( event.target, type );\n            },\n\n            delegateType: delegateType\n        };\n\n        // Support: Firefox <=44\n        // Firefox doesn't have focus(in | out) events\n        // Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787\n        //\n        // Support: Chrome <=48 - 49, Safari <=9.0 - 9.1\n        // focus(in | out) events fire after focus & blur events,\n        // which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order\n        // Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857\n        //\n        // Support: IE 9 - 11+\n        // To preserve relative focusin/focus & focusout/blur event order guaranteed on the 3.x branch,\n        // attach a single handler for both events in IE.\n        jQuery.event.special[ delegateType ] = {\n            setup: function() {\n\n                // Handle: regular nodes (via `this.ownerDocument`), window\n                // (via `this.document`) & document (via `this`).\n                var doc = this.ownerDocument || this.document || this,\n                    dataHolder = document.documentMode ? this : doc,\n                    attaches = dataPriv.get( dataHolder, delegateType );\n\n                // Support: IE 9 - 11+\n                // We use the same native handler for focusin & focus (and focusout & blur)\n                // so we need to coordinate setup & teardown parts between those events.\n                // Use `delegateType` as the key as `type` is already used by `leverageNative`.\n                if ( !attaches ) {\n                    if ( document.documentMode ) {\n                        this.addEventListener( delegateType, focusMappedHandler );\n                    } else {\n                        doc.addEventListener( type, focusMappedHandler, true );\n                    }\n                }\n                dataPriv.set( dataHolder, delegateType, ( attaches || 0 ) + 1 );\n            },\n            teardown: function() {\n                var doc = this.ownerDocument || this.document || this,\n                    dataHolder = document.documentMode ? this : doc,\n                    attaches = dataPriv.get( dataHolder, delegateType ) - 1;\n\n                if ( !attaches ) {\n                    if ( document.documentMode ) {\n                        this.removeEventListener( delegateType, focusMappedHandler );\n                    } else {\n                        doc.removeEventListener( type, focusMappedHandler, true );\n                    }\n                    dataPriv.remove( dataHolder, delegateType );\n                } else {\n                    dataPriv.set( dataHolder, delegateType, attaches );\n                }\n            }\n        };\n    } );\n\n// Create mouseenter/leave events using mouseover/out and event-time checks\n// so that event delegation works in jQuery.\n// Do the same for pointerenter/pointerleave and pointerover/pointerout\n//\n// Support: Safari 7 only\n// Safari sends mouseenter too often; see:\n// https://bugs.chromium.org/p/chromium/issues/detail?id=470258\n// for the description of the bug (it existed in older Chrome versions as well).\n    jQuery.each( {\n        mouseenter: \"mouseover\",\n        mouseleave: \"mouseout\",\n        pointerenter: \"pointerover\",\n        pointerleave: \"pointerout\"\n    }, function( orig, fix ) {\n        jQuery.event.special[ orig ] = {\n            delegateType: fix,\n            bindType: fix,\n\n            handle: function( event ) {\n                var ret,\n                    target = this,\n                    related = event.relatedTarget,\n                    handleObj = event.handleObj;\n\n                // For mouseenter/leave call the handler if related is outside the target.\n                // NB: No relatedTarget if the mouse left/entered the browser window\n                if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {\n                    event.type = handleObj.origType;\n                    ret = handleObj.handler.apply( this, arguments );\n                    event.type = fix;\n                }\n                return ret;\n            }\n        };\n    } );\n\n    jQuery.fn.extend( {\n\n        on: function( types, selector, data, fn ) {\n            return on( this, types, selector, data, fn );\n        },\n        one: function( types, selector, data, fn ) {\n            return on( this, types, selector, data, fn, 1 );\n        },\n        off: function( types, selector, fn ) {\n            var handleObj, type;\n            if ( types && types.preventDefault && types.handleObj ) {\n\n                // ( event )  dispatched jQuery.Event\n                handleObj = types.handleObj;\n                jQuery( types.delegateTarget ).off(\n                    handleObj.namespace ?\n                        handleObj.origType + \".\" + handleObj.namespace :\n                        handleObj.origType,\n                    handleObj.selector,\n                    handleObj.handler\n                );\n                return this;\n            }\n            if ( typeof types === \"object\" ) {\n\n                // ( types-object [, selector] )\n                for ( type in types ) {\n                    this.off( type, selector, types[ type ] );\n                }\n                return this;\n            }\n            if ( selector === false || typeof selector === \"function\" ) {\n\n                // ( types [, fn] )\n                fn = selector;\n                selector = undefined;\n            }\n            if ( fn === false ) {\n                fn = returnFalse;\n            }\n            return this.each( function() {\n                jQuery.event.remove( this, types, fn, selector );\n            } );\n        }\n    } );\n\n\n    var\n\n        // Support: IE <=10 - 11, Edge 12 - 13 only\n        // In IE/Edge using regex groups here causes severe slowdowns.\n        // See https://connect.microsoft.com/IE/feedback/details/1736512/\n        rnoInnerhtml = /<script|<style|<link/i,\n\n        // checked=\"checked\" or checked\n        rchecked = /checked\\s*(?:[^=]|=\\s*.checked.)/i,\n\n        rcleanScript = /^\\s*<!\\[CDATA\\[|\\]\\]>\\s*$/g;\n\n// Prefer a tbody over its parent table for containing new rows\n    function manipulationTarget( elem, content ) {\n        if ( nodeName( elem, \"table\" ) &&\n            nodeName( content.nodeType !== 11 ? content : content.firstChild, \"tr\" ) ) {\n\n            return jQuery( elem ).children( \"tbody\" )[ 0 ] || elem;\n        }\n\n        return elem;\n    }\n\n// Replace/restore the type attribute of script elements for safe DOM manipulation\n    function disableScript( elem ) {\n        elem.type = ( elem.getAttribute( \"type\" ) !== null ) + \"/\" + elem.type;\n        return elem;\n    }\n    function restoreScript( elem ) {\n        if ( ( elem.type || \"\" ).slice( 0, 5 ) === \"true/\" ) {\n            elem.type = elem.type.slice( 5 );\n        } else {\n            elem.removeAttribute( \"type\" );\n        }\n\n        return elem;\n    }\n\n    function cloneCopyEvent( src, dest ) {\n        var i, l, type, pdataOld, udataOld, udataCur, events;\n\n        if ( dest.nodeType !== 1 ) {\n            return;\n        }\n\n        // 1. Copy private data: events, handlers, etc.\n        if ( dataPriv.hasData( src ) ) {\n            pdataOld = dataPriv.get( src );\n            events = pdataOld.events;\n\n            if ( events ) {\n                dataPriv.remove( dest, \"handle events\" );\n\n                for ( type in events ) {\n                    for ( i = 0, l = events[ type ].length; i < l; i++ ) {\n                        jQuery.event.add( dest, type, events[ type ][ i ] );\n                    }\n                }\n            }\n        }\n\n        // 2. Copy user data\n        if ( dataUser.hasData( src ) ) {\n            udataOld = dataUser.access( src );\n            udataCur = jQuery.extend( {}, udataOld );\n\n            dataUser.set( dest, udataCur );\n        }\n    }\n\n// Fix IE bugs, see support tests\n    function fixInput( src, dest ) {\n        var nodeName = dest.nodeName.toLowerCase();\n\n        // Fails to persist the checked state of a cloned checkbox or radio button.\n        if ( nodeName === \"input\" && rcheckableType.test( src.type ) ) {\n            dest.checked = src.checked;\n\n            // Fails to return the selected option to the default selected state when cloning options\n        } else if ( nodeName === \"input\" || nodeName === \"textarea\" ) {\n            dest.defaultValue = src.defaultValue;\n        }\n    }\n\n    function domManip( collection, args, callback, ignored ) {\n\n        // Flatten any nested arrays\n        args = flat( args );\n\n        var fragment, first, scripts, hasScripts, node, doc,\n            i = 0,\n            l = collection.length,\n            iNoClone = l - 1,\n            value = args[ 0 ],\n            valueIsFunction = isFunction( value );\n\n        // We can't cloneNode fragments that contain checked, in WebKit\n        if ( valueIsFunction ||\n            ( l > 1 && typeof value === \"string\" &&\n                !support.checkClone && rchecked.test( value ) ) ) {\n            return collection.each( function( index ) {\n                var self = collection.eq( index );\n                if ( valueIsFunction ) {\n                    args[ 0 ] = value.call( this, index, self.html() );\n                }\n                domManip( self, args, callback, ignored );\n            } );\n        }\n\n        if ( l ) {\n            fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );\n            first = fragment.firstChild;\n\n            if ( fragment.childNodes.length === 1 ) {\n                fragment = first;\n            }\n\n            // Require either new content or an interest in ignored elements to invoke the callback\n            if ( first || ignored ) {\n                scripts = jQuery.map( getAll( fragment, \"script\" ), disableScript );\n                hasScripts = scripts.length;\n\n                // Use the original fragment for the last item\n                // instead of the first because it can end up\n                // being emptied incorrectly in certain situations (trac-8070).\n                for ( ; i < l; i++ ) {\n                    node = fragment;\n\n                    if ( i !== iNoClone ) {\n                        node = jQuery.clone( node, true, true );\n\n                        // Keep references to cloned scripts for later restoration\n                        if ( hasScripts ) {\n\n                            // Support: Android <=4.0 only, PhantomJS 1 only\n                            // push.apply(_, arraylike) throws on ancient WebKit\n                            jQuery.merge( scripts, getAll( node, \"script\" ) );\n                        }\n                    }\n\n                    callback.call( collection[ i ], node, i );\n                }\n\n                if ( hasScripts ) {\n                    doc = scripts[ scripts.length - 1 ].ownerDocument;\n\n                    // Re-enable scripts\n                    jQuery.map( scripts, restoreScript );\n\n                    // Evaluate executable scripts on first document insertion\n                    for ( i = 0; i < hasScripts; i++ ) {\n                        node = scripts[ i ];\n                        if ( rscriptType.test( node.type || \"\" ) &&\n                            !dataPriv.access( node, \"globalEval\" ) &&\n                            jQuery.contains( doc, node ) ) {\n\n                            if ( node.src && ( node.type || \"\" ).toLowerCase()  !== \"module\" ) {\n\n                                // Optional AJAX dependency, but won't run scripts if not present\n                                if ( jQuery._evalUrl && !node.noModule ) {\n                                    jQuery._evalUrl( node.src, {\n                                        nonce: node.nonce || node.getAttribute( \"nonce\" )\n                                    }, doc );\n                                }\n                            } else {\n\n                                // Unwrap a CDATA section containing script contents. This shouldn't be\n                                // needed as in XML documents they're already not visible when\n                                // inspecting element contents and in HTML documents they have no\n                                // meaning but we're preserving that logic for backwards compatibility.\n                                // This will be removed completely in 4.0. See gh-4904.\n                                DOMEval( node.textContent.replace( rcleanScript, \"\" ), node, doc );\n                            }\n                        }\n                    }\n                }\n            }\n        }\n\n        return collection;\n    }\n\n    function remove( elem, selector, keepData ) {\n        var node,\n            nodes = selector ? jQuery.filter( selector, elem ) : elem,\n            i = 0;\n\n        for ( ; ( node = nodes[ i ] ) != null; i++ ) {\n            if ( !keepData && node.nodeType === 1 ) {\n                jQuery.cleanData( getAll( node ) );\n            }\n\n            if ( node.parentNode ) {\n                if ( keepData && isAttached( node ) ) {\n                    setGlobalEval( getAll( node, \"script\" ) );\n                }\n                node.parentNode.removeChild( node );\n            }\n        }\n\n        return elem;\n    }\n\n    jQuery.extend( {\n        htmlPrefilter: function( html ) {\n            return html;\n        },\n\n        clone: function( elem, dataAndEvents, deepDataAndEvents ) {\n            var i, l, srcElements, destElements,\n                clone = elem.cloneNode( true ),\n                inPage = isAttached( elem );\n\n            // Fix IE cloning issues\n            if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&\n                !jQuery.isXMLDoc( elem ) ) {\n\n                // We eschew jQuery#find here for performance reasons:\n                // https://jsperf.com/getall-vs-sizzle/2\n                destElements = getAll( clone );\n                srcElements = getAll( elem );\n\n                for ( i = 0, l = srcElements.length; i < l; i++ ) {\n                    fixInput( srcElements[ i ], destElements[ i ] );\n                }\n            }\n\n            // Copy the events from the original to the clone\n            if ( dataAndEvents ) {\n                if ( deepDataAndEvents ) {\n                    srcElements = srcElements || getAll( elem );\n                    destElements = destElements || getAll( clone );\n\n                    for ( i = 0, l = srcElements.length; i < l; i++ ) {\n                        cloneCopyEvent( srcElements[ i ], destElements[ i ] );\n                    }\n                } else {\n                    cloneCopyEvent( elem, clone );\n                }\n            }\n\n            // Preserve script evaluation history\n            destElements = getAll( clone, \"script\" );\n            if ( destElements.length > 0 ) {\n                setGlobalEval( destElements, !inPage && getAll( elem, \"script\" ) );\n            }\n\n            // Return the cloned set\n            return clone;\n        },\n\n        cleanData: function( elems ) {\n            var data, elem, type,\n                special = jQuery.event.special,\n                i = 0;\n\n            for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {\n                if ( acceptData( elem ) ) {\n                    if ( ( data = elem[ dataPriv.expando ] ) ) {\n                        if ( data.events ) {\n                            for ( type in data.events ) {\n                                if ( special[ type ] ) {\n                                    jQuery.event.remove( elem, type );\n\n                                    // This is a shortcut to avoid jQuery.event.remove's overhead\n                                } else {\n                                    jQuery.removeEvent( elem, type, data.handle );\n                                }\n                            }\n                        }\n\n                        // Support: Chrome <=35 - 45+\n                        // Assign undefined instead of using delete, see Data#remove\n                        elem[ dataPriv.expando ] = undefined;\n                    }\n                    if ( elem[ dataUser.expando ] ) {\n\n                        // Support: Chrome <=35 - 45+\n                        // Assign undefined instead of using delete, see Data#remove\n                        elem[ dataUser.expando ] = undefined;\n                    }\n                }\n            }\n        }\n    } );\n\n    jQuery.fn.extend( {\n        detach: function( selector ) {\n            return remove( this, selector, true );\n        },\n\n        remove: function( selector ) {\n            return remove( this, selector );\n        },\n\n        text: function( value ) {\n            return access( this, function( value ) {\n                return value === undefined ?\n                    jQuery.text( this ) :\n                    this.empty().each( function() {\n                        if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n                            this.textContent = value;\n                        }\n                    } );\n            }, null, value, arguments.length );\n        },\n\n        append: function() {\n            return domManip( this, arguments, function( elem ) {\n                if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n                    var target = manipulationTarget( this, elem );\n                    target.appendChild( elem );\n                }\n            } );\n        },\n\n        prepend: function() {\n            return domManip( this, arguments, function( elem ) {\n                if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n                    var target = manipulationTarget( this, elem );\n                    target.insertBefore( elem, target.firstChild );\n                }\n            } );\n        },\n\n        before: function() {\n            return domManip( this, arguments, function( elem ) {\n                if ( this.parentNode ) {\n                    this.parentNode.insertBefore( elem, this );\n                }\n            } );\n        },\n\n        after: function() {\n            return domManip( this, arguments, function( elem ) {\n                if ( this.parentNode ) {\n                    this.parentNode.insertBefore( elem, this.nextSibling );\n                }\n            } );\n        },\n\n        empty: function() {\n            var elem,\n                i = 0;\n\n            for ( ; ( elem = this[ i ] ) != null; i++ ) {\n                if ( elem.nodeType === 1 ) {\n\n                    // Prevent memory leaks\n                    jQuery.cleanData( getAll( elem, false ) );\n\n                    // Remove any remaining nodes\n                    elem.textContent = \"\";\n                }\n            }\n\n            return this;\n        },\n\n        clone: function( dataAndEvents, deepDataAndEvents ) {\n            dataAndEvents = dataAndEvents == null ? false : dataAndEvents;\n            deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;\n\n            return this.map( function() {\n                return jQuery.clone( this, dataAndEvents, deepDataAndEvents );\n            } );\n        },\n\n        html: function( value ) {\n            return access( this, function( value ) {\n                var elem = this[ 0 ] || {},\n                    i = 0,\n                    l = this.length;\n\n                if ( value === undefined && elem.nodeType === 1 ) {\n                    return elem.innerHTML;\n                }\n\n                // See if we can take a shortcut and just use innerHTML\n                if ( typeof value === \"string\" && !rnoInnerhtml.test( value ) &&\n                    !wrapMap[ ( rtagName.exec( value ) || [ \"\", \"\" ] )[ 1 ].toLowerCase() ] ) {\n\n                    value = jQuery.htmlPrefilter( value );\n\n                    try {\n                        for ( ; i < l; i++ ) {\n                            elem = this[ i ] || {};\n\n                            // Remove element nodes and prevent memory leaks\n                            if ( elem.nodeType === 1 ) {\n                                jQuery.cleanData( getAll( elem, false ) );\n                                elem.innerHTML = value;\n                            }\n                        }\n\n                        elem = 0;\n\n                        // If using innerHTML throws an exception, use the fallback method\n                    } catch ( e ) {}\n                }\n\n                if ( elem ) {\n                    this.empty().append( value );\n                }\n            }, null, value, arguments.length );\n        },\n\n        replaceWith: function() {\n            var ignored = [];\n\n            // Make the changes, replacing each non-ignored context element with the new content\n            return domManip( this, arguments, function( elem ) {\n                var parent = this.parentNode;\n\n                if ( jQuery.inArray( this, ignored ) < 0 ) {\n                    jQuery.cleanData( getAll( this ) );\n                    if ( parent ) {\n                        parent.replaceChild( elem, this );\n                    }\n                }\n\n                // Force callback invocation\n            }, ignored );\n        }\n    } );\n\n    jQuery.each( {\n        appendTo: \"append\",\n        prependTo: \"prepend\",\n        insertBefore: \"before\",\n        insertAfter: \"after\",\n        replaceAll: \"replaceWith\"\n    }, function( name, original ) {\n        jQuery.fn[ name ] = function( selector ) {\n            var elems,\n                ret = [],\n                insert = jQuery( selector ),\n                last = insert.length - 1,\n                i = 0;\n\n            for ( ; i <= last; i++ ) {\n                elems = i === last ? this : this.clone( true );\n                jQuery( insert[ i ] )[ original ]( elems );\n\n                // Support: Android <=4.0 only, PhantomJS 1 only\n                // .get() because push.apply(_, arraylike) throws on ancient WebKit\n                push.apply( ret, elems.get() );\n            }\n\n            return this.pushStack( ret );\n        };\n    } );\n    var rnumnonpx = new RegExp( \"^(\" + pnum + \")(?!px)[a-z%]+$\", \"i\" );\n\n    var rcustomProp = /^--/;\n\n\n    var getStyles = function( elem ) {\n\n        // Support: IE <=11 only, Firefox <=30 (trac-15098, trac-14150)\n        // IE throws on elements created in popups\n        // FF meanwhile throws on frame elements through \"defaultView.getComputedStyle\"\n        var view = elem.ownerDocument.defaultView;\n\n        if ( !view || !view.opener ) {\n            view = window;\n        }\n\n        return view.getComputedStyle( elem );\n    };\n\n    var swap = function( elem, options, callback ) {\n        var ret, name,\n            old = {};\n\n        // Remember the old values, and insert the new ones\n        for ( name in options ) {\n            old[ name ] = elem.style[ name ];\n            elem.style[ name ] = options[ name ];\n        }\n\n        ret = callback.call( elem );\n\n        // Revert the old values\n        for ( name in options ) {\n            elem.style[ name ] = old[ name ];\n        }\n\n        return ret;\n    };\n\n\n    var rboxStyle = new RegExp( cssExpand.join( \"|\" ), \"i\" );\n\n\n\n    ( function() {\n\n        // Executing both pixelPosition & boxSizingReliable tests require only one layout\n        // so they're executed at the same time to save the second computation.\n        function computeStyleTests() {\n\n            // This is a singleton, we need to execute it only once\n            if ( !div ) {\n                return;\n            }\n\n            container.style.cssText = \"position:absolute;left:-11111px;width:60px;\" +\n                \"margin-top:1px;padding:0;border:0\";\n            div.style.cssText =\n                \"position:relative;display:block;box-sizing:border-box;overflow:scroll;\" +\n                \"margin:auto;border:1px;padding:1px;\" +\n                \"width:60%;top:1%\";\n            documentElement.appendChild( container ).appendChild( div );\n\n            var divStyle = window.getComputedStyle( div );\n            pixelPositionVal = divStyle.top !== \"1%\";\n\n            // Support: Android 4.0 - 4.3 only, Firefox <=3 - 44\n            reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;\n\n            // Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3\n            // Some styles come back with percentage values, even though they shouldn't\n            div.style.right = \"60%\";\n            pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;\n\n            // Support: IE 9 - 11 only\n            // Detect misreporting of content dimensions for box-sizing:border-box elements\n            boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;\n\n            // Support: IE 9 only\n            // Detect overflow:scroll screwiness (gh-3699)\n            // Support: Chrome <=64\n            // Don't get tricked when zoom affects offsetWidth (gh-4029)\n            div.style.position = \"absolute\";\n            scrollboxSizeVal = roundPixelMeasures( div.offsetWidth / 3 ) === 12;\n\n            documentElement.removeChild( container );\n\n            // Nullify the div so it wouldn't be stored in the memory and\n            // it will also be a sign that checks already performed\n            div = null;\n        }\n\n        function roundPixelMeasures( measure ) {\n            return Math.round( parseFloat( measure ) );\n        }\n\n        var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,\n            reliableTrDimensionsVal, reliableMarginLeftVal,\n            container = document.createElement( \"div\" ),\n            div = document.createElement( \"div\" );\n\n        // Finish early in limited (non-browser) environments\n        if ( !div.style ) {\n            return;\n        }\n\n        // Support: IE <=9 - 11 only\n        // Style of cloned element affects source element cloned (trac-8908)\n        div.style.backgroundClip = \"content-box\";\n        div.cloneNode( true ).style.backgroundClip = \"\";\n        support.clearCloneStyle = div.style.backgroundClip === \"content-box\";\n\n        jQuery.extend( support, {\n            boxSizingReliable: function() {\n                computeStyleTests();\n                return boxSizingReliableVal;\n            },\n            pixelBoxStyles: function() {\n                computeStyleTests();\n                return pixelBoxStylesVal;\n            },\n            pixelPosition: function() {\n                computeStyleTests();\n                return pixelPositionVal;\n            },\n            reliableMarginLeft: function() {\n                computeStyleTests();\n                return reliableMarginLeftVal;\n            },\n            scrollboxSize: function() {\n                computeStyleTests();\n                return scrollboxSizeVal;\n            },\n\n            // Support: IE 9 - 11+, Edge 15 - 18+\n            // IE/Edge misreport `getComputedStyle` of table rows with width/height\n            // set in CSS while `offset*` properties report correct values.\n            // Behavior in IE 9 is more subtle than in newer versions & it passes\n            // some versions of this test; make sure not to make it pass there!\n            //\n            // Support: Firefox 70+\n            // Only Firefox includes border widths\n            // in computed dimensions. (gh-4529)\n            reliableTrDimensions: function() {\n                var table, tr, trChild, trStyle;\n                if ( reliableTrDimensionsVal == null ) {\n                    table = document.createElement( \"table\" );\n                    tr = document.createElement( \"tr\" );\n                    trChild = document.createElement( \"div\" );\n\n                    table.style.cssText = \"position:absolute;left:-11111px;border-collapse:separate\";\n                    tr.style.cssText = \"box-sizing:content-box;border:1px solid\";\n\n                    // Support: Chrome 86+\n                    // Height set through cssText does not get applied.\n                    // Computed height then comes back as 0.\n                    tr.style.height = \"1px\";\n                    trChild.style.height = \"9px\";\n\n                    // Support: Android 8 Chrome 86+\n                    // In our bodyBackground.html iframe,\n                    // display for all div elements is set to \"inline\",\n                    // which causes a problem only in Android 8 Chrome 86.\n                    // Ensuring the div is `display: block`\n                    // gets around this issue.\n                    trChild.style.display = \"block\";\n\n                    documentElement\n                        .appendChild( table )\n                        .appendChild( tr )\n                        .appendChild( trChild );\n\n                    trStyle = window.getComputedStyle( tr );\n                    reliableTrDimensionsVal = ( parseInt( trStyle.height, 10 ) +\n                        parseInt( trStyle.borderTopWidth, 10 ) +\n                        parseInt( trStyle.borderBottomWidth, 10 ) ) === tr.offsetHeight;\n\n                    documentElement.removeChild( table );\n                }\n                return reliableTrDimensionsVal;\n            }\n        } );\n    } )();\n\n\n    function curCSS( elem, name, computed ) {\n        var width, minWidth, maxWidth, ret,\n            isCustomProp = rcustomProp.test( name ),\n\n            // Support: Firefox 51+\n            // Retrieving style before computed somehow\n            // fixes an issue with getting wrong values\n            // on detached elements\n            style = elem.style;\n\n        computed = computed || getStyles( elem );\n\n        // getPropertyValue is needed for:\n        //   .css('filter') (IE 9 only, trac-12537)\n        //   .css('--customProperty) (gh-3144)\n        if ( computed ) {\n\n            // Support: IE <=9 - 11+\n            // IE only supports `\"float\"` in `getPropertyValue`; in computed styles\n            // it's only available as `\"cssFloat\"`. We no longer modify properties\n            // sent to `.css()` apart from camelCasing, so we need to check both.\n            // Normally, this would create difference in behavior: if\n            // `getPropertyValue` returns an empty string, the value returned\n            // by `.css()` would be `undefined`. This is usually the case for\n            // disconnected elements. However, in IE even disconnected elements\n            // with no styles return `\"none\"` for `getPropertyValue( \"float\" )`\n            ret = computed.getPropertyValue( name ) || computed[ name ];\n\n            if ( isCustomProp && ret ) {\n\n                // Support: Firefox 105+, Chrome <=105+\n                // Spec requires trimming whitespace for custom properties (gh-4926).\n                // Firefox only trims leading whitespace. Chrome just collapses\n                // both leading & trailing whitespace to a single space.\n                //\n                // Fall back to `undefined` if empty string returned.\n                // This collapses a missing definition with property defined\n                // and set to an empty string but there's no standard API\n                // allowing us to differentiate them without a performance penalty\n                // and returning `undefined` aligns with older jQuery.\n                //\n                // rtrimCSS treats U+000D CARRIAGE RETURN and U+000C FORM FEED\n                // as whitespace while CSS does not, but this is not a problem\n                // because CSS preprocessing replaces them with U+000A LINE FEED\n                // (which *is* CSS whitespace)\n                // https://www.w3.org/TR/css-syntax-3/#input-preprocessing\n                ret = ret.replace( rtrimCSS, \"$1\" ) || undefined;\n            }\n\n            if ( ret === \"\" && !isAttached( elem ) ) {\n                ret = jQuery.style( elem, name );\n            }\n\n            // A tribute to the \"awesome hack by Dean Edwards\"\n            // Android Browser returns percentage for some values,\n            // but width seems to be reliably pixels.\n            // This is against the CSSOM draft spec:\n            // https://drafts.csswg.org/cssom/#resolved-values\n            if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {\n\n                // Remember the original values\n                width = style.width;\n                minWidth = style.minWidth;\n                maxWidth = style.maxWidth;\n\n                // Put in the new values to get a computed value out\n                style.minWidth = style.maxWidth = style.width = ret;\n                ret = computed.width;\n\n                // Revert the changed values\n                style.width = width;\n                style.minWidth = minWidth;\n                style.maxWidth = maxWidth;\n            }\n        }\n\n        return ret !== undefined ?\n\n            // Support: IE <=9 - 11 only\n            // IE returns zIndex value as an integer.\n            ret + \"\" :\n            ret;\n    }\n\n\n    function addGetHookIf( conditionFn, hookFn ) {\n\n        // Define the hook, we'll check on the first run if it's really needed.\n        return {\n            get: function() {\n                if ( conditionFn() ) {\n\n                    // Hook not needed (or it's not possible to use it due\n                    // to missing dependency), remove it.\n                    delete this.get;\n                    return;\n                }\n\n                // Hook needed; redefine it so that the support test is not executed again.\n                return ( this.get = hookFn ).apply( this, arguments );\n            }\n        };\n    }\n\n\n    var cssPrefixes = [ \"Webkit\", \"Moz\", \"ms\" ],\n        emptyStyle = document.createElement( \"div\" ).style,\n        vendorProps = {};\n\n// Return a vendor-prefixed property or undefined\n    function vendorPropName( name ) {\n\n        // Check for vendor prefixed names\n        var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),\n            i = cssPrefixes.length;\n\n        while ( i-- ) {\n            name = cssPrefixes[ i ] + capName;\n            if ( name in emptyStyle ) {\n                return name;\n            }\n        }\n    }\n\n// Return a potentially-mapped jQuery.cssProps or vendor prefixed property\n    function finalPropName( name ) {\n        var final = jQuery.cssProps[ name ] || vendorProps[ name ];\n\n        if ( final ) {\n            return final;\n        }\n        if ( name in emptyStyle ) {\n            return name;\n        }\n        return vendorProps[ name ] = vendorPropName( name ) || name;\n    }\n\n\n    var\n\n        // Swappable if display is none or starts with table\n        // except \"table\", \"table-cell\", or \"table-caption\"\n        // See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display\n        rdisplayswap = /^(none|table(?!-c[ea]).+)/,\n        cssShow = { position: \"absolute\", visibility: \"hidden\", display: \"block\" },\n        cssNormalTransform = {\n            letterSpacing: \"0\",\n            fontWeight: \"400\"\n        };\n\n    function setPositiveNumber( _elem, value, subtract ) {\n\n        // Any relative (+/-) values have already been\n        // normalized at this point\n        var matches = rcssNum.exec( value );\n        return matches ?\n\n            // Guard against undefined \"subtract\", e.g., when used as in cssHooks\n            Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || \"px\" ) :\n            value;\n    }\n\n    function boxModelAdjustment( elem, dimension, box, isBorderBox, styles, computedVal ) {\n        var i = dimension === \"width\" ? 1 : 0,\n            extra = 0,\n            delta = 0,\n            marginDelta = 0;\n\n        // Adjustment may not be necessary\n        if ( box === ( isBorderBox ? \"border\" : \"content\" ) ) {\n            return 0;\n        }\n\n        for ( ; i < 4; i += 2 ) {\n\n            // Both box models exclude margin\n            // Count margin delta separately to only add it after scroll gutter adjustment.\n            // This is needed to make negative margins work with `outerHeight( true )` (gh-3982).\n            if ( box === \"margin\" ) {\n                marginDelta += jQuery.css( elem, box + cssExpand[ i ], true, styles );\n            }\n\n            // If we get here with a content-box, we're seeking \"padding\" or \"border\" or \"margin\"\n            if ( !isBorderBox ) {\n\n                // Add padding\n                delta += jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\n                // For \"border\" or \"margin\", add border\n                if ( box !== \"padding\" ) {\n                    delta += jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\n                    // But still keep track of it otherwise\n                } else {\n                    extra += jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n                }\n\n                // If we get here with a border-box (content + padding + border), we're seeking \"content\" or\n                // \"padding\" or \"margin\"\n            } else {\n\n                // For \"content\", subtract padding\n                if ( box === \"content\" ) {\n                    delta -= jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n                }\n\n                // For \"content\" or \"padding\", subtract border\n                if ( box !== \"margin\" ) {\n                    delta -= jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n                }\n            }\n        }\n\n        // Account for positive content-box scroll gutter when requested by providing computedVal\n        if ( !isBorderBox && computedVal >= 0 ) {\n\n            // offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border\n            // Assuming integer scroll gutter, subtract the rest and round down\n            delta += Math.max( 0, Math.ceil(\n                elem[ \"offset\" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -\n                computedVal -\n                delta -\n                extra -\n                0.5\n\n                // If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter\n                // Use an explicit zero to avoid NaN (gh-3964)\n            ) ) || 0;\n        }\n\n        return delta + marginDelta;\n    }\n\n    function getWidthOrHeight( elem, dimension, extra ) {\n\n        // Start with computed style\n        var styles = getStyles( elem ),\n\n            // To avoid forcing a reflow, only fetch boxSizing if we need it (gh-4322).\n            // Fake content-box until we know it's needed to know the true value.\n            boxSizingNeeded = !support.boxSizingReliable() || extra,\n            isBorderBox = boxSizingNeeded &&\n                jQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\",\n            valueIsBorderBox = isBorderBox,\n\n            val = curCSS( elem, dimension, styles ),\n            offsetProp = \"offset\" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 );\n\n        // Support: Firefox <=54\n        // Return a confounding non-pixel value or feign ignorance, as appropriate.\n        if ( rnumnonpx.test( val ) ) {\n            if ( !extra ) {\n                return val;\n            }\n            val = \"auto\";\n        }\n\n\n        // Support: IE 9 - 11 only\n        // Use offsetWidth/offsetHeight for when box sizing is unreliable.\n        // In those cases, the computed value can be trusted to be border-box.\n        if ( ( !support.boxSizingReliable() && isBorderBox ||\n\n                // Support: IE 10 - 11+, Edge 15 - 18+\n                // IE/Edge misreport `getComputedStyle` of table rows with width/height\n                // set in CSS while `offset*` properties report correct values.\n                // Interestingly, in some cases IE 9 doesn't suffer from this issue.\n                !support.reliableTrDimensions() && nodeName( elem, \"tr\" ) ||\n\n                // Fall back to offsetWidth/offsetHeight when value is \"auto\"\n                // This happens for inline elements with no explicit setting (gh-3571)\n                val === \"auto\" ||\n\n                // Support: Android <=4.1 - 4.3 only\n                // Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)\n                !parseFloat( val ) && jQuery.css( elem, \"display\", false, styles ) === \"inline\" ) &&\n\n            // Make sure the element is visible & connected\n            elem.getClientRects().length ) {\n\n            isBorderBox = jQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\";\n\n            // Where available, offsetWidth/offsetHeight approximate border box dimensions.\n            // Where not available (e.g., SVG), assume unreliable box-sizing and interpret the\n            // retrieved value as a content box dimension.\n            valueIsBorderBox = offsetProp in elem;\n            if ( valueIsBorderBox ) {\n                val = elem[ offsetProp ];\n            }\n        }\n\n        // Normalize \"\" and auto\n        val = parseFloat( val ) || 0;\n\n        // Adjust for the element's box model\n        return ( val +\n            boxModelAdjustment(\n                elem,\n                dimension,\n                extra || ( isBorderBox ? \"border\" : \"content\" ),\n                valueIsBorderBox,\n                styles,\n\n                // Provide the current computed size to request scroll gutter calculation (gh-3589)\n                val\n            )\n        ) + \"px\";\n    }\n\n    jQuery.extend( {\n\n        // Add in style property hooks for overriding the default\n        // behavior of getting and setting a style property\n        cssHooks: {\n            opacity: {\n                get: function( elem, computed ) {\n                    if ( computed ) {\n\n                        // We should always get a number back from opacity\n                        var ret = curCSS( elem, \"opacity\" );\n                        return ret === \"\" ? \"1\" : ret;\n                    }\n                }\n            }\n        },\n\n        // Don't automatically add \"px\" to these possibly-unitless properties\n        cssNumber: {\n            animationIterationCount: true,\n            aspectRatio: true,\n            borderImageSlice: true,\n            columnCount: true,\n            flexGrow: true,\n            flexShrink: true,\n            fontWeight: true,\n            gridArea: true,\n            gridColumn: true,\n            gridColumnEnd: true,\n            gridColumnStart: true,\n            gridRow: true,\n            gridRowEnd: true,\n            gridRowStart: true,\n            lineHeight: true,\n            opacity: true,\n            order: true,\n            orphans: true,\n            scale: true,\n            widows: true,\n            zIndex: true,\n            zoom: true,\n\n            // SVG-related\n            fillOpacity: true,\n            floodOpacity: true,\n            stopOpacity: true,\n            strokeMiterlimit: true,\n            strokeOpacity: true\n        },\n\n        // Add in properties whose names you wish to fix before\n        // setting or getting the value\n        cssProps: {},\n\n        // Get and set the style property on a DOM Node\n        style: function( elem, name, value, extra ) {\n\n            // Don't set styles on text and comment nodes\n            if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {\n                return;\n            }\n\n            // Make sure that we're working with the right name\n            var ret, type, hooks,\n                origName = camelCase( name ),\n                isCustomProp = rcustomProp.test( name ),\n                style = elem.style;\n\n            // Make sure that we're working with the right name. We don't\n            // want to query the value if it is a CSS custom property\n            // since they are user-defined.\n            if ( !isCustomProp ) {\n                name = finalPropName( origName );\n            }\n\n            // Gets hook for the prefixed version, then unprefixed version\n            hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n            // Check if we're setting a value\n            if ( value !== undefined ) {\n                type = typeof value;\n\n                // Convert \"+=\" or \"-=\" to relative numbers (trac-7345)\n                if ( type === \"string\" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {\n                    value = adjustCSS( elem, name, ret );\n\n                    // Fixes bug trac-9237\n                    type = \"number\";\n                }\n\n                // Make sure that null and NaN values aren't set (trac-7116)\n                if ( value == null || value !== value ) {\n                    return;\n                }\n\n                // If a number was passed in, add the unit (except for certain CSS properties)\n                // The isCustomProp check can be removed in jQuery 4.0 when we only auto-append\n                // \"px\" to a few hardcoded values.\n                if ( type === \"number\" && !isCustomProp ) {\n                    value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? \"\" : \"px\" );\n                }\n\n                // background-* props affect original clone's values\n                if ( !support.clearCloneStyle && value === \"\" && name.indexOf( \"background\" ) === 0 ) {\n                    style[ name ] = \"inherit\";\n                }\n\n                // If a hook was provided, use that value, otherwise just set the specified value\n                if ( !hooks || !( \"set\" in hooks ) ||\n                    ( value = hooks.set( elem, value, extra ) ) !== undefined ) {\n\n                    if ( isCustomProp ) {\n                        style.setProperty( name, value );\n                    } else {\n                        style[ name ] = value;\n                    }\n                }\n\n            } else {\n\n                // If a hook was provided get the non-computed value from there\n                if ( hooks && \"get\" in hooks &&\n                    ( ret = hooks.get( elem, false, extra ) ) !== undefined ) {\n\n                    return ret;\n                }\n\n                // Otherwise just get the value from the style object\n                return style[ name ];\n            }\n        },\n\n        css: function( elem, name, extra, styles ) {\n            var val, num, hooks,\n                origName = camelCase( name ),\n                isCustomProp = rcustomProp.test( name );\n\n            // Make sure that we're working with the right name. We don't\n            // want to modify the value if it is a CSS custom property\n            // since they are user-defined.\n            if ( !isCustomProp ) {\n                name = finalPropName( origName );\n            }\n\n            // Try prefixed name followed by the unprefixed name\n            hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n            // If a hook was provided get the computed value from there\n            if ( hooks && \"get\" in hooks ) {\n                val = hooks.get( elem, true, extra );\n            }\n\n            // Otherwise, if a way to get the computed value exists, use that\n            if ( val === undefined ) {\n                val = curCSS( elem, name, styles );\n            }\n\n            // Convert \"normal\" to computed value\n            if ( val === \"normal\" && name in cssNormalTransform ) {\n                val = cssNormalTransform[ name ];\n            }\n\n            // Make numeric if forced or a qualifier was provided and val looks numeric\n            if ( extra === \"\" || extra ) {\n                num = parseFloat( val );\n                return extra === true || isFinite( num ) ? num || 0 : val;\n            }\n\n            return val;\n        }\n    } );\n\n    jQuery.each( [ \"height\", \"width\" ], function( _i, dimension ) {\n        jQuery.cssHooks[ dimension ] = {\n            get: function( elem, computed, extra ) {\n                if ( computed ) {\n\n                    // Certain elements can have dimension info if we invisibly show them\n                    // but it must have a current display style that would benefit\n                    return rdisplayswap.test( jQuery.css( elem, \"display\" ) ) &&\n\n                    // Support: Safari 8+\n                    // Table columns in Safari have non-zero offsetWidth & zero\n                    // getBoundingClientRect().width unless display is changed.\n                    // Support: IE <=11 only\n                    // Running getBoundingClientRect on a disconnected node\n                    // in IE throws an error.\n                    ( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?\n                        swap( elem, cssShow, function() {\n                            return getWidthOrHeight( elem, dimension, extra );\n                        } ) :\n                        getWidthOrHeight( elem, dimension, extra );\n                }\n            },\n\n            set: function( elem, value, extra ) {\n                var matches,\n                    styles = getStyles( elem ),\n\n                    // Only read styles.position if the test has a chance to fail\n                    // to avoid forcing a reflow.\n                    scrollboxSizeBuggy = !support.scrollboxSize() &&\n                        styles.position === \"absolute\",\n\n                    // To avoid forcing a reflow, only fetch boxSizing if we need it (gh-3991)\n                    boxSizingNeeded = scrollboxSizeBuggy || extra,\n                    isBorderBox = boxSizingNeeded &&\n                        jQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\",\n                    subtract = extra ?\n                        boxModelAdjustment(\n                            elem,\n                            dimension,\n                            extra,\n                            isBorderBox,\n                            styles\n                        ) :\n                        0;\n\n                // Account for unreliable border-box dimensions by comparing offset* to computed and\n                // faking a content-box to get border and padding (gh-3699)\n                if ( isBorderBox && scrollboxSizeBuggy ) {\n                    subtract -= Math.ceil(\n                        elem[ \"offset\" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -\n                        parseFloat( styles[ dimension ] ) -\n                        boxModelAdjustment( elem, dimension, \"border\", false, styles ) -\n                        0.5\n                    );\n                }\n\n                // Convert to pixels if value adjustment is needed\n                if ( subtract && ( matches = rcssNum.exec( value ) ) &&\n                    ( matches[ 3 ] || \"px\" ) !== \"px\" ) {\n\n                    elem.style[ dimension ] = value;\n                    value = jQuery.css( elem, dimension );\n                }\n\n                return setPositiveNumber( elem, value, subtract );\n            }\n        };\n    } );\n\n    jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,\n        function( elem, computed ) {\n            if ( computed ) {\n                return ( parseFloat( curCSS( elem, \"marginLeft\" ) ) ||\n                    elem.getBoundingClientRect().left -\n                    swap( elem, { marginLeft: 0 }, function() {\n                        return elem.getBoundingClientRect().left;\n                    } )\n                ) + \"px\";\n            }\n        }\n    );\n\n// These hooks are used by animate to expand properties\n    jQuery.each( {\n        margin: \"\",\n        padding: \"\",\n        border: \"Width\"\n    }, function( prefix, suffix ) {\n        jQuery.cssHooks[ prefix + suffix ] = {\n            expand: function( value ) {\n                var i = 0,\n                    expanded = {},\n\n                    // Assumes a single number if not a string\n                    parts = typeof value === \"string\" ? value.split( \" \" ) : [ value ];\n\n                for ( ; i < 4; i++ ) {\n                    expanded[ prefix + cssExpand[ i ] + suffix ] =\n                        parts[ i ] || parts[ i - 2 ] || parts[ 0 ];\n                }\n\n                return expanded;\n            }\n        };\n\n        if ( prefix !== \"margin\" ) {\n            jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;\n        }\n    } );\n\n    jQuery.fn.extend( {\n        css: function( name, value ) {\n            return access( this, function( elem, name, value ) {\n                var styles, len,\n                    map = {},\n                    i = 0;\n\n                if ( Array.isArray( name ) ) {\n                    styles = getStyles( elem );\n                    len = name.length;\n\n                    for ( ; i < len; i++ ) {\n                        map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );\n                    }\n\n                    return map;\n                }\n\n                return value !== undefined ?\n                    jQuery.style( elem, name, value ) :\n                    jQuery.css( elem, name );\n            }, name, value, arguments.length > 1 );\n        }\n    } );\n\n\n    function Tween( elem, options, prop, end, easing ) {\n        return new Tween.prototype.init( elem, options, prop, end, easing );\n    }\n    jQuery.Tween = Tween;\n\n    Tween.prototype = {\n        constructor: Tween,\n        init: function( elem, options, prop, end, easing, unit ) {\n            this.elem = elem;\n            this.prop = prop;\n            this.easing = easing || jQuery.easing._default;\n            this.options = options;\n            this.start = this.now = this.cur();\n            this.end = end;\n            this.unit = unit || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" );\n        },\n        cur: function() {\n            var hooks = Tween.propHooks[ this.prop ];\n\n            return hooks && hooks.get ?\n                hooks.get( this ) :\n                Tween.propHooks._default.get( this );\n        },\n        run: function( percent ) {\n            var eased,\n                hooks = Tween.propHooks[ this.prop ];\n\n            if ( this.options.duration ) {\n                this.pos = eased = jQuery.easing[ this.easing ](\n                    percent, this.options.duration * percent, 0, 1, this.options.duration\n                );\n            } else {\n                this.pos = eased = percent;\n            }\n            this.now = ( this.end - this.start ) * eased + this.start;\n\n            if ( this.options.step ) {\n                this.options.step.call( this.elem, this.now, this );\n            }\n\n            if ( hooks && hooks.set ) {\n                hooks.set( this );\n            } else {\n                Tween.propHooks._default.set( this );\n            }\n            return this;\n        }\n    };\n\n    Tween.prototype.init.prototype = Tween.prototype;\n\n    Tween.propHooks = {\n        _default: {\n            get: function( tween ) {\n                var result;\n\n                // Use a property on the element directly when it is not a DOM element,\n                // or when there is no matching style property that exists.\n                if ( tween.elem.nodeType !== 1 ||\n                    tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {\n                    return tween.elem[ tween.prop ];\n                }\n\n                // Passing an empty string as a 3rd parameter to .css will automatically\n                // attempt a parseFloat and fallback to a string if the parse fails.\n                // Simple values such as \"10px\" are parsed to Float;\n                // complex values such as \"rotate(1rad)\" are returned as-is.\n                result = jQuery.css( tween.elem, tween.prop, \"\" );\n\n                // Empty strings, null, undefined and \"auto\" are converted to 0.\n                return !result || result === \"auto\" ? 0 : result;\n            },\n            set: function( tween ) {\n\n                // Use step hook for back compat.\n                // Use cssHook if its there.\n                // Use .style if available and use plain properties where available.\n                if ( jQuery.fx.step[ tween.prop ] ) {\n                    jQuery.fx.step[ tween.prop ]( tween );\n                } else if ( tween.elem.nodeType === 1 && (\n                    jQuery.cssHooks[ tween.prop ] ||\n                    tween.elem.style[ finalPropName( tween.prop ) ] != null ) ) {\n                    jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );\n                } else {\n                    tween.elem[ tween.prop ] = tween.now;\n                }\n            }\n        }\n    };\n\n// Support: IE <=9 only\n// Panic based approach to setting things on disconnected nodes\n    Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {\n        set: function( tween ) {\n            if ( tween.elem.nodeType && tween.elem.parentNode ) {\n                tween.elem[ tween.prop ] = tween.now;\n            }\n        }\n    };\n\n    jQuery.easing = {\n        linear: function( p ) {\n            return p;\n        },\n        swing: function( p ) {\n            return 0.5 - Math.cos( p * Math.PI ) / 2;\n        },\n        _default: \"swing\"\n    };\n\n    jQuery.fx = Tween.prototype.init;\n\n// Back compat <1.8 extension point\n    jQuery.fx.step = {};\n\n\n\n\n    var\n        fxNow, inProgress,\n        rfxtypes = /^(?:toggle|show|hide)$/,\n        rrun = /queueHooks$/;\n\n    function schedule() {\n        if ( inProgress ) {\n            if ( document.hidden === false && window.requestAnimationFrame ) {\n                window.requestAnimationFrame( schedule );\n            } else {\n                window.setTimeout( schedule, jQuery.fx.interval );\n            }\n\n            jQuery.fx.tick();\n        }\n    }\n\n// Animations created synchronously will run synchronously\n    function createFxNow() {\n        window.setTimeout( function() {\n            fxNow = undefined;\n        } );\n        return ( fxNow = Date.now() );\n    }\n\n// Generate parameters to create a standard animation\n    function genFx( type, includeWidth ) {\n        var which,\n            i = 0,\n            attrs = { height: type };\n\n        // If we include width, step value is 1 to do all cssExpand values,\n        // otherwise step value is 2 to skip over Left and Right\n        includeWidth = includeWidth ? 1 : 0;\n        for ( ; i < 4; i += 2 - includeWidth ) {\n            which = cssExpand[ i ];\n            attrs[ \"margin\" + which ] = attrs[ \"padding\" + which ] = type;\n        }\n\n        if ( includeWidth ) {\n            attrs.opacity = attrs.width = type;\n        }\n\n        return attrs;\n    }\n\n    function createTween( value, prop, animation ) {\n        var tween,\n            collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ \"*\" ] ),\n            index = 0,\n            length = collection.length;\n        for ( ; index < length; index++ ) {\n            if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {\n\n                // We're done with this property\n                return tween;\n            }\n        }\n    }\n\n    function defaultPrefilter( elem, props, opts ) {\n        var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,\n            isBox = \"width\" in props || \"height\" in props,\n            anim = this,\n            orig = {},\n            style = elem.style,\n            hidden = elem.nodeType && isHiddenWithinTree( elem ),\n            dataShow = dataPriv.get( elem, \"fxshow\" );\n\n        // Queue-skipping animations hijack the fx hooks\n        if ( !opts.queue ) {\n            hooks = jQuery._queueHooks( elem, \"fx\" );\n            if ( hooks.unqueued == null ) {\n                hooks.unqueued = 0;\n                oldfire = hooks.empty.fire;\n                hooks.empty.fire = function() {\n                    if ( !hooks.unqueued ) {\n                        oldfire();\n                    }\n                };\n            }\n            hooks.unqueued++;\n\n            anim.always( function() {\n\n                // Ensure the complete handler is called before this completes\n                anim.always( function() {\n                    hooks.unqueued--;\n                    if ( !jQuery.queue( elem, \"fx\" ).length ) {\n                        hooks.empty.fire();\n                    }\n                } );\n            } );\n        }\n\n        // Detect show/hide animations\n        for ( prop in props ) {\n            value = props[ prop ];\n            if ( rfxtypes.test( value ) ) {\n                delete props[ prop ];\n                toggle = toggle || value === \"toggle\";\n                if ( value === ( hidden ? \"hide\" : \"show\" ) ) {\n\n                    // Pretend to be hidden if this is a \"show\" and\n                    // there is still data from a stopped show/hide\n                    if ( value === \"show\" && dataShow && dataShow[ prop ] !== undefined ) {\n                        hidden = true;\n\n                        // Ignore all other no-op show/hide data\n                    } else {\n                        continue;\n                    }\n                }\n                orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );\n            }\n        }\n\n        // Bail out if this is a no-op like .hide().hide()\n        propTween = !jQuery.isEmptyObject( props );\n        if ( !propTween && jQuery.isEmptyObject( orig ) ) {\n            return;\n        }\n\n        // Restrict \"overflow\" and \"display\" styles during box animations\n        if ( isBox && elem.nodeType === 1 ) {\n\n            // Support: IE <=9 - 11, Edge 12 - 15\n            // Record all 3 overflow attributes because IE does not infer the shorthand\n            // from identically-valued overflowX and overflowY and Edge just mirrors\n            // the overflowX value there.\n            opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];\n\n            // Identify a display type, preferring old show/hide data over the CSS cascade\n            restoreDisplay = dataShow && dataShow.display;\n            if ( restoreDisplay == null ) {\n                restoreDisplay = dataPriv.get( elem, \"display\" );\n            }\n            display = jQuery.css( elem, \"display\" );\n            if ( display === \"none\" ) {\n                if ( restoreDisplay ) {\n                    display = restoreDisplay;\n                } else {\n\n                    // Get nonempty value(s) by temporarily forcing visibility\n                    showHide( [ elem ], true );\n                    restoreDisplay = elem.style.display || restoreDisplay;\n                    display = jQuery.css( elem, \"display\" );\n                    showHide( [ elem ] );\n                }\n            }\n\n            // Animate inline elements as inline-block\n            if ( display === \"inline\" || display === \"inline-block\" && restoreDisplay != null ) {\n                if ( jQuery.css( elem, \"float\" ) === \"none\" ) {\n\n                    // Restore the original display value at the end of pure show/hide animations\n                    if ( !propTween ) {\n                        anim.done( function() {\n                            style.display = restoreDisplay;\n                        } );\n                        if ( restoreDisplay == null ) {\n                            display = style.display;\n                            restoreDisplay = display === \"none\" ? \"\" : display;\n                        }\n                    }\n                    style.display = \"inline-block\";\n                }\n            }\n        }\n\n        if ( opts.overflow ) {\n            style.overflow = \"hidden\";\n            anim.always( function() {\n                style.overflow = opts.overflow[ 0 ];\n                style.overflowX = opts.overflow[ 1 ];\n                style.overflowY = opts.overflow[ 2 ];\n            } );\n        }\n\n        // Implement show/hide animations\n        propTween = false;\n        for ( prop in orig ) {\n\n            // General show/hide setup for this element animation\n            if ( !propTween ) {\n                if ( dataShow ) {\n                    if ( \"hidden\" in dataShow ) {\n                        hidden = dataShow.hidden;\n                    }\n                } else {\n                    dataShow = dataPriv.access( elem, \"fxshow\", { display: restoreDisplay } );\n                }\n\n                // Store hidden/visible for toggle so `.stop().toggle()` \"reverses\"\n                if ( toggle ) {\n                    dataShow.hidden = !hidden;\n                }\n\n                // Show elements before animating them\n                if ( hidden ) {\n                    showHide( [ elem ], true );\n                }\n\n                /* eslint-disable no-loop-func */\n\n                anim.done( function() {\n\n                    /* eslint-enable no-loop-func */\n\n                    // The final step of a \"hide\" animation is actually hiding the element\n                    if ( !hidden ) {\n                        showHide( [ elem ] );\n                    }\n                    dataPriv.remove( elem, \"fxshow\" );\n                    for ( prop in orig ) {\n                        jQuery.style( elem, prop, orig[ prop ] );\n                    }\n                } );\n            }\n\n            // Per-property setup\n            propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );\n            if ( !( prop in dataShow ) ) {\n                dataShow[ prop ] = propTween.start;\n                if ( hidden ) {\n                    propTween.end = propTween.start;\n                    propTween.start = 0;\n                }\n            }\n        }\n    }\n\n    function propFilter( props, specialEasing ) {\n        var index, name, easing, value, hooks;\n\n        // camelCase, specialEasing and expand cssHook pass\n        for ( index in props ) {\n            name = camelCase( index );\n            easing = specialEasing[ name ];\n            value = props[ index ];\n            if ( Array.isArray( value ) ) {\n                easing = value[ 1 ];\n                value = props[ index ] = value[ 0 ];\n            }\n\n            if ( index !== name ) {\n                props[ name ] = value;\n                delete props[ index ];\n            }\n\n            hooks = jQuery.cssHooks[ name ];\n            if ( hooks && \"expand\" in hooks ) {\n                value = hooks.expand( value );\n                delete props[ name ];\n\n                // Not quite $.extend, this won't overwrite existing keys.\n                // Reusing 'index' because we have the correct \"name\"\n                for ( index in value ) {\n                    if ( !( index in props ) ) {\n                        props[ index ] = value[ index ];\n                        specialEasing[ index ] = easing;\n                    }\n                }\n            } else {\n                specialEasing[ name ] = easing;\n            }\n        }\n    }\n\n    function Animation( elem, properties, options ) {\n        var result,\n            stopped,\n            index = 0,\n            length = Animation.prefilters.length,\n            deferred = jQuery.Deferred().always( function() {\n\n                // Don't match elem in the :animated selector\n                delete tick.elem;\n            } ),\n            tick = function() {\n                if ( stopped ) {\n                    return false;\n                }\n                var currentTime = fxNow || createFxNow(),\n                    remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),\n\n                    // Support: Android 2.3 only\n                    // Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (trac-12497)\n                    temp = remaining / animation.duration || 0,\n                    percent = 1 - temp,\n                    index = 0,\n                    length = animation.tweens.length;\n\n                for ( ; index < length; index++ ) {\n                    animation.tweens[ index ].run( percent );\n                }\n\n                deferred.notifyWith( elem, [ animation, percent, remaining ] );\n\n                // If there's more to do, yield\n                if ( percent < 1 && length ) {\n                    return remaining;\n                }\n\n                // If this was an empty animation, synthesize a final progress notification\n                if ( !length ) {\n                    deferred.notifyWith( elem, [ animation, 1, 0 ] );\n                }\n\n                // Resolve the animation and report its conclusion\n                deferred.resolveWith( elem, [ animation ] );\n                return false;\n            },\n            animation = deferred.promise( {\n                elem: elem,\n                props: jQuery.extend( {}, properties ),\n                opts: jQuery.extend( true, {\n                    specialEasing: {},\n                    easing: jQuery.easing._default\n                }, options ),\n                originalProperties: properties,\n                originalOptions: options,\n                startTime: fxNow || createFxNow(),\n                duration: options.duration,\n                tweens: [],\n                createTween: function( prop, end ) {\n                    var tween = jQuery.Tween( elem, animation.opts, prop, end,\n                        animation.opts.specialEasing[ prop ] || animation.opts.easing );\n                    animation.tweens.push( tween );\n                    return tween;\n                },\n                stop: function( gotoEnd ) {\n                    var index = 0,\n\n                        // If we are going to the end, we want to run all the tweens\n                        // otherwise we skip this part\n                        length = gotoEnd ? animation.tweens.length : 0;\n                    if ( stopped ) {\n                        return this;\n                    }\n                    stopped = true;\n                    for ( ; index < length; index++ ) {\n                        animation.tweens[ index ].run( 1 );\n                    }\n\n                    // Resolve when we played the last frame; otherwise, reject\n                    if ( gotoEnd ) {\n                        deferred.notifyWith( elem, [ animation, 1, 0 ] );\n                        deferred.resolveWith( elem, [ animation, gotoEnd ] );\n                    } else {\n                        deferred.rejectWith( elem, [ animation, gotoEnd ] );\n                    }\n                    return this;\n                }\n            } ),\n            props = animation.props;\n\n        propFilter( props, animation.opts.specialEasing );\n\n        for ( ; index < length; index++ ) {\n            result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );\n            if ( result ) {\n                if ( isFunction( result.stop ) ) {\n                    jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =\n                        result.stop.bind( result );\n                }\n                return result;\n            }\n        }\n\n        jQuery.map( props, createTween, animation );\n\n        if ( isFunction( animation.opts.start ) ) {\n            animation.opts.start.call( elem, animation );\n        }\n\n        // Attach callbacks from options\n        animation\n            .progress( animation.opts.progress )\n            .done( animation.opts.done, animation.opts.complete )\n            .fail( animation.opts.fail )\n            .always( animation.opts.always );\n\n        jQuery.fx.timer(\n            jQuery.extend( tick, {\n                elem: elem,\n                anim: animation,\n                queue: animation.opts.queue\n            } )\n        );\n\n        return animation;\n    }\n\n    jQuery.Animation = jQuery.extend( Animation, {\n\n        tweeners: {\n            \"*\": [ function( prop, value ) {\n                var tween = this.createTween( prop, value );\n                adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );\n                return tween;\n            } ]\n        },\n\n        tweener: function( props, callback ) {\n            if ( isFunction( props ) ) {\n                callback = props;\n                props = [ \"*\" ];\n            } else {\n                props = props.match( rnothtmlwhite );\n            }\n\n            var prop,\n                index = 0,\n                length = props.length;\n\n            for ( ; index < length; index++ ) {\n                prop = props[ index ];\n                Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];\n                Animation.tweeners[ prop ].unshift( callback );\n            }\n        },\n\n        prefilters: [ defaultPrefilter ],\n\n        prefilter: function( callback, prepend ) {\n            if ( prepend ) {\n                Animation.prefilters.unshift( callback );\n            } else {\n                Animation.prefilters.push( callback );\n            }\n        }\n    } );\n\n    jQuery.speed = function( speed, easing, fn ) {\n        var opt = speed && typeof speed === \"object\" ? jQuery.extend( {}, speed ) : {\n            complete: fn || !fn && easing ||\n                isFunction( speed ) && speed,\n            duration: speed,\n            easing: fn && easing || easing && !isFunction( easing ) && easing\n        };\n\n        // Go to the end state if fx are off\n        if ( jQuery.fx.off ) {\n            opt.duration = 0;\n\n        } else {\n            if ( typeof opt.duration !== \"number\" ) {\n                if ( opt.duration in jQuery.fx.speeds ) {\n                    opt.duration = jQuery.fx.speeds[ opt.duration ];\n\n                } else {\n                    opt.duration = jQuery.fx.speeds._default;\n                }\n            }\n        }\n\n        // Normalize opt.queue - true/undefined/null -> \"fx\"\n        if ( opt.queue == null || opt.queue === true ) {\n            opt.queue = \"fx\";\n        }\n\n        // Queueing\n        opt.old = opt.complete;\n\n        opt.complete = function() {\n            if ( isFunction( opt.old ) ) {\n                opt.old.call( this );\n            }\n\n            if ( opt.queue ) {\n                jQuery.dequeue( this, opt.queue );\n            }\n        };\n\n        return opt;\n    };\n\n    jQuery.fn.extend( {\n        fadeTo: function( speed, to, easing, callback ) {\n\n            // Show any hidden elements after setting opacity to 0\n            return this.filter( isHiddenWithinTree ).css( \"opacity\", 0 ).show()\n\n                // Animate to the value specified\n                .end().animate( { opacity: to }, speed, easing, callback );\n        },\n        animate: function( prop, speed, easing, callback ) {\n            var empty = jQuery.isEmptyObject( prop ),\n                optall = jQuery.speed( speed, easing, callback ),\n                doAnimation = function() {\n\n                    // Operate on a copy of prop so per-property easing won't be lost\n                    var anim = Animation( this, jQuery.extend( {}, prop ), optall );\n\n                    // Empty animations, or finishing resolves immediately\n                    if ( empty || dataPriv.get( this, \"finish\" ) ) {\n                        anim.stop( true );\n                    }\n                };\n\n            doAnimation.finish = doAnimation;\n\n            return empty || optall.queue === false ?\n                this.each( doAnimation ) :\n                this.queue( optall.queue, doAnimation );\n        },\n        stop: function( type, clearQueue, gotoEnd ) {\n            var stopQueue = function( hooks ) {\n                var stop = hooks.stop;\n                delete hooks.stop;\n                stop( gotoEnd );\n            };\n\n            if ( typeof type !== \"string\" ) {\n                gotoEnd = clearQueue;\n                clearQueue = type;\n                type = undefined;\n            }\n            if ( clearQueue ) {\n                this.queue( type || \"fx\", [] );\n            }\n\n            return this.each( function() {\n                var dequeue = true,\n                    index = type != null && type + \"queueHooks\",\n                    timers = jQuery.timers,\n                    data = dataPriv.get( this );\n\n                if ( index ) {\n                    if ( data[ index ] && data[ index ].stop ) {\n                        stopQueue( data[ index ] );\n                    }\n                } else {\n                    for ( index in data ) {\n                        if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {\n                            stopQueue( data[ index ] );\n                        }\n                    }\n                }\n\n                for ( index = timers.length; index--; ) {\n                    if ( timers[ index ].elem === this &&\n                        ( type == null || timers[ index ].queue === type ) ) {\n\n                        timers[ index ].anim.stop( gotoEnd );\n                        dequeue = false;\n                        timers.splice( index, 1 );\n                    }\n                }\n\n                // Start the next in the queue if the last step wasn't forced.\n                // Timers currently will call their complete callbacks, which\n                // will dequeue but only if they were gotoEnd.\n                if ( dequeue || !gotoEnd ) {\n                    jQuery.dequeue( this, type );\n                }\n            } );\n        },\n        finish: function( type ) {\n            if ( type !== false ) {\n                type = type || \"fx\";\n            }\n            return this.each( function() {\n                var index,\n                    data = dataPriv.get( this ),\n                    queue = data[ type + \"queue\" ],\n                    hooks = data[ type + \"queueHooks\" ],\n                    timers = jQuery.timers,\n                    length = queue ? queue.length : 0;\n\n                // Enable finishing flag on private data\n                data.finish = true;\n\n                // Empty the queue first\n                jQuery.queue( this, type, [] );\n\n                if ( hooks && hooks.stop ) {\n                    hooks.stop.call( this, true );\n                }\n\n                // Look for any active animations, and finish them\n                for ( index = timers.length; index--; ) {\n                    if ( timers[ index ].elem === this && timers[ index ].queue === type ) {\n                        timers[ index ].anim.stop( true );\n                        timers.splice( index, 1 );\n                    }\n                }\n\n                // Look for any animations in the old queue and finish them\n                for ( index = 0; index < length; index++ ) {\n                    if ( queue[ index ] && queue[ index ].finish ) {\n                        queue[ index ].finish.call( this );\n                    }\n                }\n\n                // Turn off finishing flag\n                delete data.finish;\n            } );\n        }\n    } );\n\n    jQuery.each( [ \"toggle\", \"show\", \"hide\" ], function( _i, name ) {\n        var cssFn = jQuery.fn[ name ];\n        jQuery.fn[ name ] = function( speed, easing, callback ) {\n            return speed == null || typeof speed === \"boolean\" ?\n                cssFn.apply( this, arguments ) :\n                this.animate( genFx( name, true ), speed, easing, callback );\n        };\n    } );\n\n// Generate shortcuts for custom animations\n    jQuery.each( {\n        slideDown: genFx( \"show\" ),\n        slideUp: genFx( \"hide\" ),\n        slideToggle: genFx( \"toggle\" ),\n        fadeIn: { opacity: \"show\" },\n        fadeOut: { opacity: \"hide\" },\n        fadeToggle: { opacity: \"toggle\" }\n    }, function( name, props ) {\n        jQuery.fn[ name ] = function( speed, easing, callback ) {\n            return this.animate( props, speed, easing, callback );\n        };\n    } );\n\n    jQuery.timers = [];\n    jQuery.fx.tick = function() {\n        var timer,\n            i = 0,\n            timers = jQuery.timers;\n\n        fxNow = Date.now();\n\n        for ( ; i < timers.length; i++ ) {\n            timer = timers[ i ];\n\n            // Run the timer and safely remove it when done (allowing for external removal)\n            if ( !timer() && timers[ i ] === timer ) {\n                timers.splice( i--, 1 );\n            }\n        }\n\n        if ( !timers.length ) {\n            jQuery.fx.stop();\n        }\n        fxNow = undefined;\n    };\n\n    jQuery.fx.timer = function( timer ) {\n        jQuery.timers.push( timer );\n        jQuery.fx.start();\n    };\n\n    jQuery.fx.interval = 13;\n    jQuery.fx.start = function() {\n        if ( inProgress ) {\n            return;\n        }\n\n        inProgress = true;\n        schedule();\n    };\n\n    jQuery.fx.stop = function() {\n        inProgress = null;\n    };\n\n    jQuery.fx.speeds = {\n        slow: 600,\n        fast: 200,\n\n        // Default speed\n        _default: 400\n    };\n\n\n// Based off of the plugin by Clint Helfers, with permission.\n    jQuery.fn.delay = function( time, type ) {\n        time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;\n        type = type || \"fx\";\n\n        return this.queue( type, function( next, hooks ) {\n            var timeout = window.setTimeout( next, time );\n            hooks.stop = function() {\n                window.clearTimeout( timeout );\n            };\n        } );\n    };\n\n\n    ( function() {\n        var input = document.createElement( \"input\" ),\n            select = document.createElement( \"select\" ),\n            opt = select.appendChild( document.createElement( \"option\" ) );\n\n        input.type = \"checkbox\";\n\n        // Support: Android <=4.3 only\n        // Default value for a checkbox should be \"on\"\n        support.checkOn = input.value !== \"\";\n\n        // Support: IE <=11 only\n        // Must access selectedIndex to make default options select\n        support.optSelected = opt.selected;\n\n        // Support: IE <=11 only\n        // An input loses its value after becoming a radio\n        input = document.createElement( \"input\" );\n        input.value = \"t\";\n        input.type = \"radio\";\n        support.radioValue = input.value === \"t\";\n    } )();\n\n\n    var boolHook,\n        attrHandle = jQuery.expr.attrHandle;\n\n    jQuery.fn.extend( {\n        attr: function( name, value ) {\n            return access( this, jQuery.attr, name, value, arguments.length > 1 );\n        },\n\n        removeAttr: function( name ) {\n            return this.each( function() {\n                jQuery.removeAttr( this, name );\n            } );\n        }\n    } );\n\n    jQuery.extend( {\n        attr: function( elem, name, value ) {\n            var ret, hooks,\n                nType = elem.nodeType;\n\n            // Don't get/set attributes on text, comment and attribute nodes\n            if ( nType === 3 || nType === 8 || nType === 2 ) {\n                return;\n            }\n\n            // Fallback to prop when attributes are not supported\n            if ( typeof elem.getAttribute === \"undefined\" ) {\n                return jQuery.prop( elem, name, value );\n            }\n\n            // Attribute hooks are determined by the lowercase version\n            // Grab necessary hook if one is defined\n            if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n                hooks = jQuery.attrHooks[ name.toLowerCase() ] ||\n                    ( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );\n            }\n\n            if ( value !== undefined ) {\n                if ( value === null ) {\n                    jQuery.removeAttr( elem, name );\n                    return;\n                }\n\n                if ( hooks && \"set\" in hooks &&\n                    ( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n                    return ret;\n                }\n\n                elem.setAttribute( name, value + \"\" );\n                return value;\n            }\n\n            if ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n                return ret;\n            }\n\n            ret = jQuery.find.attr( elem, name );\n\n            // Non-existent attributes return null, we normalize to undefined\n            return ret == null ? undefined : ret;\n        },\n\n        attrHooks: {\n            type: {\n                set: function( elem, value ) {\n                    if ( !support.radioValue && value === \"radio\" &&\n                        nodeName( elem, \"input\" ) ) {\n                        var val = elem.value;\n                        elem.setAttribute( \"type\", value );\n                        if ( val ) {\n                            elem.value = val;\n                        }\n                        return value;\n                    }\n                }\n            }\n        },\n\n        removeAttr: function( elem, value ) {\n            var name,\n                i = 0,\n\n                // Attribute names can contain non-HTML whitespace characters\n                // https://html.spec.whatwg.org/multipage/syntax.html#attributes-2\n                attrNames = value && value.match( rnothtmlwhite );\n\n            if ( attrNames && elem.nodeType === 1 ) {\n                while ( ( name = attrNames[ i++ ] ) ) {\n                    elem.removeAttribute( name );\n                }\n            }\n        }\n    } );\n\n// Hooks for boolean attributes\n    boolHook = {\n        set: function( elem, value, name ) {\n            if ( value === false ) {\n\n                // Remove boolean attributes when set to false\n                jQuery.removeAttr( elem, name );\n            } else {\n                elem.setAttribute( name, name );\n            }\n            return name;\n        }\n    };\n\n    jQuery.each( jQuery.expr.match.bool.source.match( /\\w+/g ), function( _i, name ) {\n        var getter = attrHandle[ name ] || jQuery.find.attr;\n\n        attrHandle[ name ] = function( elem, name, isXML ) {\n            var ret, handle,\n                lowercaseName = name.toLowerCase();\n\n            if ( !isXML ) {\n\n                // Avoid an infinite loop by temporarily removing this function from the getter\n                handle = attrHandle[ lowercaseName ];\n                attrHandle[ lowercaseName ] = ret;\n                ret = getter( elem, name, isXML ) != null ?\n                    lowercaseName :\n                    null;\n                attrHandle[ lowercaseName ] = handle;\n            }\n            return ret;\n        };\n    } );\n\n\n\n\n    var rfocusable = /^(?:input|select|textarea|button)$/i,\n        rclickable = /^(?:a|area)$/i;\n\n    jQuery.fn.extend( {\n        prop: function( name, value ) {\n            return access( this, jQuery.prop, name, value, arguments.length > 1 );\n        },\n\n        removeProp: function( name ) {\n            return this.each( function() {\n                delete this[ jQuery.propFix[ name ] || name ];\n            } );\n        }\n    } );\n\n    jQuery.extend( {\n        prop: function( elem, name, value ) {\n            var ret, hooks,\n                nType = elem.nodeType;\n\n            // Don't get/set properties on text, comment and attribute nodes\n            if ( nType === 3 || nType === 8 || nType === 2 ) {\n                return;\n            }\n\n            if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n\n                // Fix name and attach hooks\n                name = jQuery.propFix[ name ] || name;\n                hooks = jQuery.propHooks[ name ];\n            }\n\n            if ( value !== undefined ) {\n                if ( hooks && \"set\" in hooks &&\n                    ( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n                    return ret;\n                }\n\n                return ( elem[ name ] = value );\n            }\n\n            if ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n                return ret;\n            }\n\n            return elem[ name ];\n        },\n\n        propHooks: {\n            tabIndex: {\n                get: function( elem ) {\n\n                    // Support: IE <=9 - 11 only\n                    // elem.tabIndex doesn't always return the\n                    // correct value when it hasn't been explicitly set\n                    // Use proper attribute retrieval (trac-12072)\n                    var tabindex = jQuery.find.attr( elem, \"tabindex\" );\n\n                    if ( tabindex ) {\n                        return parseInt( tabindex, 10 );\n                    }\n\n                    if (\n                        rfocusable.test( elem.nodeName ) ||\n                        rclickable.test( elem.nodeName ) &&\n                        elem.href\n                    ) {\n                        return 0;\n                    }\n\n                    return -1;\n                }\n            }\n        },\n\n        propFix: {\n            \"for\": \"htmlFor\",\n            \"class\": \"className\"\n        }\n    } );\n\n// Support: IE <=11 only\n// Accessing the selectedIndex property\n// forces the browser to respect setting selected\n// on the option\n// The getter ensures a default option is selected\n// when in an optgroup\n// eslint rule \"no-unused-expressions\" is disabled for this code\n// since it considers such accessions noop\n    if ( !support.optSelected ) {\n        jQuery.propHooks.selected = {\n            get: function( elem ) {\n\n                /* eslint no-unused-expressions: \"off\" */\n\n                var parent = elem.parentNode;\n                if ( parent && parent.parentNode ) {\n                    parent.parentNode.selectedIndex;\n                }\n                return null;\n            },\n            set: function( elem ) {\n\n                /* eslint no-unused-expressions: \"off\" */\n\n                var parent = elem.parentNode;\n                if ( parent ) {\n                    parent.selectedIndex;\n\n                    if ( parent.parentNode ) {\n                        parent.parentNode.selectedIndex;\n                    }\n                }\n            }\n        };\n    }\n\n    jQuery.each( [\n        \"tabIndex\",\n        \"readOnly\",\n        \"maxLength\",\n        \"cellSpacing\",\n        \"cellPadding\",\n        \"rowSpan\",\n        \"colSpan\",\n        \"useMap\",\n        \"frameBorder\",\n        \"contentEditable\"\n    ], function() {\n        jQuery.propFix[ this.toLowerCase() ] = this;\n    } );\n\n\n\n\n    // Strip and collapse whitespace according to HTML spec\n    // https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace\n    function stripAndCollapse( value ) {\n        var tokens = value.match( rnothtmlwhite ) || [];\n        return tokens.join( \" \" );\n    }\n\n\n    function getClass( elem ) {\n        return elem.getAttribute && elem.getAttribute( \"class\" ) || \"\";\n    }\n\n    function classesToArray( value ) {\n        if ( Array.isArray( value ) ) {\n            return value;\n        }\n        if ( typeof value === \"string\" ) {\n            return value.match( rnothtmlwhite ) || [];\n        }\n        return [];\n    }\n\n    jQuery.fn.extend( {\n        addClass: function( value ) {\n            var classNames, cur, curValue, className, i, finalValue;\n\n            if ( isFunction( value ) ) {\n                return this.each( function( j ) {\n                    jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );\n                } );\n            }\n\n            classNames = classesToArray( value );\n\n            if ( classNames.length ) {\n                return this.each( function() {\n                    curValue = getClass( this );\n                    cur = this.nodeType === 1 && ( \" \" + stripAndCollapse( curValue ) + \" \" );\n\n                    if ( cur ) {\n                        for ( i = 0; i < classNames.length; i++ ) {\n                            className = classNames[ i ];\n                            if ( cur.indexOf( \" \" + className + \" \" ) < 0 ) {\n                                cur += className + \" \";\n                            }\n                        }\n\n                        // Only assign if different to avoid unneeded rendering.\n                        finalValue = stripAndCollapse( cur );\n                        if ( curValue !== finalValue ) {\n                            this.setAttribute( \"class\", finalValue );\n                        }\n                    }\n                } );\n            }\n\n            return this;\n        },\n\n        removeClass: function( value ) {\n            var classNames, cur, curValue, className, i, finalValue;\n\n            if ( isFunction( value ) ) {\n                return this.each( function( j ) {\n                    jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );\n                } );\n            }\n\n            if ( !arguments.length ) {\n                return this.attr( \"class\", \"\" );\n            }\n\n            classNames = classesToArray( value );\n\n            if ( classNames.length ) {\n                return this.each( function() {\n                    curValue = getClass( this );\n\n                    // This expression is here for better compressibility (see addClass)\n                    cur = this.nodeType === 1 && ( \" \" + stripAndCollapse( curValue ) + \" \" );\n\n                    if ( cur ) {\n                        for ( i = 0; i < classNames.length; i++ ) {\n                            className = classNames[ i ];\n\n                            // Remove *all* instances\n                            while ( cur.indexOf( \" \" + className + \" \" ) > -1 ) {\n                                cur = cur.replace( \" \" + className + \" \", \" \" );\n                            }\n                        }\n\n                        // Only assign if different to avoid unneeded rendering.\n                        finalValue = stripAndCollapse( cur );\n                        if ( curValue !== finalValue ) {\n                            this.setAttribute( \"class\", finalValue );\n                        }\n                    }\n                } );\n            }\n\n            return this;\n        },\n\n        toggleClass: function( value, stateVal ) {\n            var classNames, className, i, self,\n                type = typeof value,\n                isValidValue = type === \"string\" || Array.isArray( value );\n\n            if ( isFunction( value ) ) {\n                return this.each( function( i ) {\n                    jQuery( this ).toggleClass(\n                        value.call( this, i, getClass( this ), stateVal ),\n                        stateVal\n                    );\n                } );\n            }\n\n            if ( typeof stateVal === \"boolean\" && isValidValue ) {\n                return stateVal ? this.addClass( value ) : this.removeClass( value );\n            }\n\n            classNames = classesToArray( value );\n\n            return this.each( function() {\n                if ( isValidValue ) {\n\n                    // Toggle individual class names\n                    self = jQuery( this );\n\n                    for ( i = 0; i < classNames.length; i++ ) {\n                        className = classNames[ i ];\n\n                        // Check each className given, space separated list\n                        if ( self.hasClass( className ) ) {\n                            self.removeClass( className );\n                        } else {\n                            self.addClass( className );\n                        }\n                    }\n\n                    // Toggle whole class name\n                } else if ( value === undefined || type === \"boolean\" ) {\n                    className = getClass( this );\n                    if ( className ) {\n\n                        // Store className if set\n                        dataPriv.set( this, \"__className__\", className );\n                    }\n\n                    // If the element has a class name or if we're passed `false`,\n                    // then remove the whole classname (if there was one, the above saved it).\n                    // Otherwise bring back whatever was previously saved (if anything),\n                    // falling back to the empty string if nothing was stored.\n                    if ( this.setAttribute ) {\n                        this.setAttribute( \"class\",\n                            className || value === false ?\n                                \"\" :\n                                dataPriv.get( this, \"__className__\" ) || \"\"\n                        );\n                    }\n                }\n            } );\n        },\n\n        hasClass: function( selector ) {\n            var className, elem,\n                i = 0;\n\n            className = \" \" + selector + \" \";\n            while ( ( elem = this[ i++ ] ) ) {\n                if ( elem.nodeType === 1 &&\n                    ( \" \" + stripAndCollapse( getClass( elem ) ) + \" \" ).indexOf( className ) > -1 ) {\n                    return true;\n                }\n            }\n\n            return false;\n        }\n    } );\n\n\n\n\n    var rreturn = /\\r/g;\n\n    jQuery.fn.extend( {\n        val: function( value ) {\n            var hooks, ret, valueIsFunction,\n                elem = this[ 0 ];\n\n            if ( !arguments.length ) {\n                if ( elem ) {\n                    hooks = jQuery.valHooks[ elem.type ] ||\n                        jQuery.valHooks[ elem.nodeName.toLowerCase() ];\n\n                    if ( hooks &&\n                        \"get\" in hooks &&\n                        ( ret = hooks.get( elem, \"value\" ) ) !== undefined\n                    ) {\n                        return ret;\n                    }\n\n                    ret = elem.value;\n\n                    // Handle most common string cases\n                    if ( typeof ret === \"string\" ) {\n                        return ret.replace( rreturn, \"\" );\n                    }\n\n                    // Handle cases where value is null/undef or number\n                    return ret == null ? \"\" : ret;\n                }\n\n                return;\n            }\n\n            valueIsFunction = isFunction( value );\n\n            return this.each( function( i ) {\n                var val;\n\n                if ( this.nodeType !== 1 ) {\n                    return;\n                }\n\n                if ( valueIsFunction ) {\n                    val = value.call( this, i, jQuery( this ).val() );\n                } else {\n                    val = value;\n                }\n\n                // Treat null/undefined as \"\"; convert numbers to string\n                if ( val == null ) {\n                    val = \"\";\n\n                } else if ( typeof val === \"number\" ) {\n                    val += \"\";\n\n                } else if ( Array.isArray( val ) ) {\n                    val = jQuery.map( val, function( value ) {\n                        return value == null ? \"\" : value + \"\";\n                    } );\n                }\n\n                hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];\n\n                // If set returns undefined, fall back to normal setting\n                if ( !hooks || !( \"set\" in hooks ) || hooks.set( this, val, \"value\" ) === undefined ) {\n                    this.value = val;\n                }\n            } );\n        }\n    } );\n\n    jQuery.extend( {\n        valHooks: {\n            option: {\n                get: function( elem ) {\n\n                    var val = jQuery.find.attr( elem, \"value\" );\n                    return val != null ?\n                        val :\n\n                        // Support: IE <=10 - 11 only\n                        // option.text throws exceptions (trac-14686, trac-14858)\n                        // Strip and collapse whitespace\n                        // https://html.spec.whatwg.org/#strip-and-collapse-whitespace\n                        stripAndCollapse( jQuery.text( elem ) );\n                }\n            },\n            select: {\n                get: function( elem ) {\n                    var value, option, i,\n                        options = elem.options,\n                        index = elem.selectedIndex,\n                        one = elem.type === \"select-one\",\n                        values = one ? null : [],\n                        max = one ? index + 1 : options.length;\n\n                    if ( index < 0 ) {\n                        i = max;\n\n                    } else {\n                        i = one ? index : 0;\n                    }\n\n                    // Loop through all the selected options\n                    for ( ; i < max; i++ ) {\n                        option = options[ i ];\n\n                        // Support: IE <=9 only\n                        // IE8-9 doesn't update selected after form reset (trac-2551)\n                        if ( ( option.selected || i === index ) &&\n\n                            // Don't return options that are disabled or in a disabled optgroup\n                            !option.disabled &&\n                            ( !option.parentNode.disabled ||\n                                !nodeName( option.parentNode, \"optgroup\" ) ) ) {\n\n                            // Get the specific value for the option\n                            value = jQuery( option ).val();\n\n                            // We don't need an array for one selects\n                            if ( one ) {\n                                return value;\n                            }\n\n                            // Multi-Selects return an array\n                            values.push( value );\n                        }\n                    }\n\n                    return values;\n                },\n\n                set: function( elem, value ) {\n                    var optionSet, option,\n                        options = elem.options,\n                        values = jQuery.makeArray( value ),\n                        i = options.length;\n\n                    while ( i-- ) {\n                        option = options[ i ];\n\n                        /* eslint-disable no-cond-assign */\n\n                        if ( option.selected =\n                            jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1\n                        ) {\n                            optionSet = true;\n                        }\n\n                        /* eslint-enable no-cond-assign */\n                    }\n\n                    // Force browsers to behave consistently when non-matching value is set\n                    if ( !optionSet ) {\n                        elem.selectedIndex = -1;\n                    }\n                    return values;\n                }\n            }\n        }\n    } );\n\n// Radios and checkboxes getter/setter\n    jQuery.each( [ \"radio\", \"checkbox\" ], function() {\n        jQuery.valHooks[ this ] = {\n            set: function( elem, value ) {\n                if ( Array.isArray( value ) ) {\n                    return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );\n                }\n            }\n        };\n        if ( !support.checkOn ) {\n            jQuery.valHooks[ this ].get = function( elem ) {\n                return elem.getAttribute( \"value\" ) === null ? \"on\" : elem.value;\n            };\n        }\n    } );\n\n\n\n\n// Return jQuery for attributes-only inclusion\n    var location = window.location;\n\n    var nonce = { guid: Date.now() };\n\n    var rquery = ( /\\?/ );\n\n\n\n// Cross-browser xml parsing\n    jQuery.parseXML = function( data ) {\n        var xml, parserErrorElem;\n        if ( !data || typeof data !== \"string\" ) {\n            return null;\n        }\n\n        // Support: IE 9 - 11 only\n        // IE throws on parseFromString with invalid input.\n        try {\n            xml = ( new window.DOMParser() ).parseFromString( data, \"text/xml\" );\n        } catch ( e ) {}\n\n        parserErrorElem = xml && xml.getElementsByTagName( \"parsererror\" )[ 0 ];\n        if ( !xml || parserErrorElem ) {\n            jQuery.error( \"Invalid XML: \" + (\n                parserErrorElem ?\n                    jQuery.map( parserErrorElem.childNodes, function( el ) {\n                        return el.textContent;\n                    } ).join( \"\\n\" ) :\n                    data\n            ) );\n        }\n        return xml;\n    };\n\n\n    var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,\n        stopPropagationCallback = function( e ) {\n            e.stopPropagation();\n        };\n\n    jQuery.extend( jQuery.event, {\n\n        trigger: function( event, data, elem, onlyHandlers ) {\n\n            var i, cur, tmp, bubbleType, ontype, handle, special, lastElement,\n                eventPath = [ elem || document ],\n                type = hasOwn.call( event, \"type\" ) ? event.type : event,\n                namespaces = hasOwn.call( event, \"namespace\" ) ? event.namespace.split( \".\" ) : [];\n\n            cur = lastElement = tmp = elem = elem || document;\n\n            // Don't do events on text and comment nodes\n            if ( elem.nodeType === 3 || elem.nodeType === 8 ) {\n                return;\n            }\n\n            // focus/blur morphs to focusin/out; ensure we're not firing them right now\n            if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {\n                return;\n            }\n\n            if ( type.indexOf( \".\" ) > -1 ) {\n\n                // Namespaced trigger; create a regexp to match event type in handle()\n                namespaces = type.split( \".\" );\n                type = namespaces.shift();\n                namespaces.sort();\n            }\n            ontype = type.indexOf( \":\" ) < 0 && \"on\" + type;\n\n            // Caller can pass in a jQuery.Event object, Object, or just an event type string\n            event = event[ jQuery.expando ] ?\n                event :\n                new jQuery.Event( type, typeof event === \"object\" && event );\n\n            // Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)\n            event.isTrigger = onlyHandlers ? 2 : 3;\n            event.namespace = namespaces.join( \".\" );\n            event.rnamespace = event.namespace ?\n                new RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" ) :\n                null;\n\n            // Clean up the event in case it is being reused\n            event.result = undefined;\n            if ( !event.target ) {\n                event.target = elem;\n            }\n\n            // Clone any incoming data and prepend the event, creating the handler arg list\n            data = data == null ?\n                [ event ] :\n                jQuery.makeArray( data, [ event ] );\n\n            // Allow special events to draw outside the lines\n            special = jQuery.event.special[ type ] || {};\n            if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {\n                return;\n            }\n\n            // Determine event propagation path in advance, per W3C events spec (trac-9951)\n            // Bubble up to document, then to window; watch for a global ownerDocument var (trac-9724)\n            if ( !onlyHandlers && !special.noBubble && !isWindow( elem ) ) {\n\n                bubbleType = special.delegateType || type;\n                if ( !rfocusMorph.test( bubbleType + type ) ) {\n                    cur = cur.parentNode;\n                }\n                for ( ; cur; cur = cur.parentNode ) {\n                    eventPath.push( cur );\n                    tmp = cur;\n                }\n\n                // Only add window if we got to document (e.g., not plain obj or detached DOM)\n                if ( tmp === ( elem.ownerDocument || document ) ) {\n                    eventPath.push( tmp.defaultView || tmp.parentWindow || window );\n                }\n            }\n\n            // Fire handlers on the event path\n            i = 0;\n            while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {\n                lastElement = cur;\n                event.type = i > 1 ?\n                    bubbleType :\n                    special.bindType || type;\n\n                // jQuery handler\n                handle = ( dataPriv.get( cur, \"events\" ) || Object.create( null ) )[ event.type ] &&\n                    dataPriv.get( cur, \"handle\" );\n                if ( handle ) {\n                    handle.apply( cur, data );\n                }\n\n                // Native handler\n                handle = ontype && cur[ ontype ];\n                if ( handle && handle.apply && acceptData( cur ) ) {\n                    event.result = handle.apply( cur, data );\n                    if ( event.result === false ) {\n                        event.preventDefault();\n                    }\n                }\n            }\n            event.type = type;\n\n            // If nobody prevented the default action, do it now\n            if ( !onlyHandlers && !event.isDefaultPrevented() ) {\n\n                if ( ( !special._default ||\n                        special._default.apply( eventPath.pop(), data ) === false ) &&\n                    acceptData( elem ) ) {\n\n                    // Call a native DOM method on the target with the same name as the event.\n                    // Don't do default actions on window, that's where global variables be (trac-6170)\n                    if ( ontype && isFunction( elem[ type ] ) && !isWindow( elem ) ) {\n\n                        // Don't re-trigger an onFOO event when we call its FOO() method\n                        tmp = elem[ ontype ];\n\n                        if ( tmp ) {\n                            elem[ ontype ] = null;\n                        }\n\n                        // Prevent re-triggering of the same event, since we already bubbled it above\n                        jQuery.event.triggered = type;\n\n                        if ( event.isPropagationStopped() ) {\n                            lastElement.addEventListener( type, stopPropagationCallback );\n                        }\n\n                        elem[ type ]();\n\n                        if ( event.isPropagationStopped() ) {\n                            lastElement.removeEventListener( type, stopPropagationCallback );\n                        }\n\n                        jQuery.event.triggered = undefined;\n\n                        if ( tmp ) {\n                            elem[ ontype ] = tmp;\n                        }\n                    }\n                }\n            }\n\n            return event.result;\n        },\n\n        // Piggyback on a donor event to simulate a different one\n        // Used only for `focus(in | out)` events\n        simulate: function( type, elem, event ) {\n            var e = jQuery.extend(\n                new jQuery.Event(),\n                event,\n                {\n                    type: type,\n                    isSimulated: true\n                }\n            );\n\n            jQuery.event.trigger( e, null, elem );\n        }\n\n    } );\n\n    jQuery.fn.extend( {\n\n        trigger: function( type, data ) {\n            return this.each( function() {\n                jQuery.event.trigger( type, data, this );\n            } );\n        },\n        triggerHandler: function( type, data ) {\n            var elem = this[ 0 ];\n            if ( elem ) {\n                return jQuery.event.trigger( type, data, elem, true );\n            }\n        }\n    } );\n\n\n    var\n        rbracket = /\\[\\]$/,\n        rCRLF = /\\r?\\n/g,\n        rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,\n        rsubmittable = /^(?:input|select|textarea|keygen)/i;\n\n    function buildParams( prefix, obj, traditional, add ) {\n        var name;\n\n        if ( Array.isArray( obj ) ) {\n\n            // Serialize array item.\n            jQuery.each( obj, function( i, v ) {\n                if ( traditional || rbracket.test( prefix ) ) {\n\n                    // Treat each array item as a scalar.\n                    add( prefix, v );\n\n                } else {\n\n                    // Item is non-scalar (array or object), encode its numeric index.\n                    buildParams(\n                        prefix + \"[\" + ( typeof v === \"object\" && v != null ? i : \"\" ) + \"]\",\n                        v,\n                        traditional,\n                        add\n                    );\n                }\n            } );\n\n        } else if ( !traditional && toType( obj ) === \"object\" ) {\n\n            // Serialize object item.\n            for ( name in obj ) {\n                buildParams( prefix + \"[\" + name + \"]\", obj[ name ], traditional, add );\n            }\n\n        } else {\n\n            // Serialize scalar item.\n            add( prefix, obj );\n        }\n    }\n\n// Serialize an array of form elements or a set of\n// key/values into a query string\n    jQuery.param = function( a, traditional ) {\n        var prefix,\n            s = [],\n            add = function( key, valueOrFunction ) {\n\n                // If value is a function, invoke it and use its return value\n                var value = isFunction( valueOrFunction ) ?\n                    valueOrFunction() :\n                    valueOrFunction;\n\n                s[ s.length ] = encodeURIComponent( key ) + \"=\" +\n                    encodeURIComponent( value == null ? \"\" : value );\n            };\n\n        if ( a == null ) {\n            return \"\";\n        }\n\n        // If an array was passed in, assume that it is an array of form elements.\n        if ( Array.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {\n\n            // Serialize the form elements\n            jQuery.each( a, function() {\n                add( this.name, this.value );\n            } );\n\n        } else {\n\n            // If traditional, encode the \"old\" way (the way 1.3.2 or older\n            // did it), otherwise encode params recursively.\n            for ( prefix in a ) {\n                buildParams( prefix, a[ prefix ], traditional, add );\n            }\n        }\n\n        // Return the resulting serialization\n        return s.join( \"&\" );\n    };\n\n    jQuery.fn.extend( {\n        serialize: function() {\n            return jQuery.param( this.serializeArray() );\n        },\n        serializeArray: function() {\n            return this.map( function() {\n\n                // Can add propHook for \"elements\" to filter or add form elements\n                var elements = jQuery.prop( this, \"elements\" );\n                return elements ? jQuery.makeArray( elements ) : this;\n            } ).filter( function() {\n                var type = this.type;\n\n                // Use .is( \":disabled\" ) so that fieldset[disabled] works\n                return this.name && !jQuery( this ).is( \":disabled\" ) &&\n                    rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&\n                    ( this.checked || !rcheckableType.test( type ) );\n            } ).map( function( _i, elem ) {\n                var val = jQuery( this ).val();\n\n                if ( val == null ) {\n                    return null;\n                }\n\n                if ( Array.isArray( val ) ) {\n                    return jQuery.map( val, function( val ) {\n                        return { name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n                    } );\n                }\n\n                return { name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n            } ).get();\n        }\n    } );\n\n\n    var\n        r20 = /%20/g,\n        rhash = /#.*$/,\n        rantiCache = /([?&])_=[^&]*/,\n        rheaders = /^(.*?):[ \\t]*([^\\r\\n]*)$/mg,\n\n        // trac-7653, trac-8125, trac-8152: local protocol detection\n        rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,\n        rnoContent = /^(?:GET|HEAD)$/,\n        rprotocol = /^\\/\\//,\n\n        /* Prefilters\n\t * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)\n\t * 2) These are called:\n\t *    - BEFORE asking for a transport\n\t *    - AFTER param serialization (s.data is a string if s.processData is true)\n\t * 3) key is the dataType\n\t * 4) the catchall symbol \"*\" can be used\n\t * 5) execution will start with transport dataType and THEN continue down to \"*\" if needed\n\t */\n        prefilters = {},\n\n        /* Transports bindings\n\t * 1) key is the dataType\n\t * 2) the catchall symbol \"*\" can be used\n\t * 3) selection will start with transport dataType and THEN go to \"*\" if needed\n\t */\n        transports = {},\n\n        // Avoid comment-prolog char sequence (trac-10098); must appease lint and evade compression\n        allTypes = \"*/\".concat( \"*\" ),\n\n        // Anchor tag for parsing the document origin\n        originAnchor = document.createElement( \"a\" );\n\n    originAnchor.href = location.href;\n\n// Base \"constructor\" for jQuery.ajaxPrefilter and jQuery.ajaxTransport\n    function addToPrefiltersOrTransports( structure ) {\n\n        // dataTypeExpression is optional and defaults to \"*\"\n        return function( dataTypeExpression, func ) {\n\n            if ( typeof dataTypeExpression !== \"string\" ) {\n                func = dataTypeExpression;\n                dataTypeExpression = \"*\";\n            }\n\n            var dataType,\n                i = 0,\n                dataTypes = dataTypeExpression.toLowerCase().match( rnothtmlwhite ) || [];\n\n            if ( isFunction( func ) ) {\n\n                // For each dataType in the dataTypeExpression\n                while ( ( dataType = dataTypes[ i++ ] ) ) {\n\n                    // Prepend if requested\n                    if ( dataType[ 0 ] === \"+\" ) {\n                        dataType = dataType.slice( 1 ) || \"*\";\n                        ( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );\n\n                        // Otherwise append\n                    } else {\n                        ( structure[ dataType ] = structure[ dataType ] || [] ).push( func );\n                    }\n                }\n            }\n        };\n    }\n\n// Base inspection function for prefilters and transports\n    function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {\n\n        var inspected = {},\n            seekingTransport = ( structure === transports );\n\n        function inspect( dataType ) {\n            var selected;\n            inspected[ dataType ] = true;\n            jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {\n                var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );\n                if ( typeof dataTypeOrTransport === \"string\" &&\n                    !seekingTransport && !inspected[ dataTypeOrTransport ] ) {\n\n                    options.dataTypes.unshift( dataTypeOrTransport );\n                    inspect( dataTypeOrTransport );\n                    return false;\n                } else if ( seekingTransport ) {\n                    return !( selected = dataTypeOrTransport );\n                }\n            } );\n            return selected;\n        }\n\n        return inspect( options.dataTypes[ 0 ] ) || !inspected[ \"*\" ] && inspect( \"*\" );\n    }\n\n// A special extend for ajax options\n// that takes \"flat\" options (not to be deep extended)\n// Fixes trac-9887\n    function ajaxExtend( target, src ) {\n        var key, deep,\n            flatOptions = jQuery.ajaxSettings.flatOptions || {};\n\n        for ( key in src ) {\n            if ( src[ key ] !== undefined ) {\n                ( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];\n            }\n        }\n        if ( deep ) {\n            jQuery.extend( true, target, deep );\n        }\n\n        return target;\n    }\n\n    /* Handles responses to an ajax request:\n * - finds the right dataType (mediates between content-type and expected dataType)\n * - returns the corresponding response\n */\n    function ajaxHandleResponses( s, jqXHR, responses ) {\n\n        var ct, type, finalDataType, firstDataType,\n            contents = s.contents,\n            dataTypes = s.dataTypes;\n\n        // Remove auto dataType and get content-type in the process\n        while ( dataTypes[ 0 ] === \"*\" ) {\n            dataTypes.shift();\n            if ( ct === undefined ) {\n                ct = s.mimeType || jqXHR.getResponseHeader( \"Content-Type\" );\n            }\n        }\n\n        // Check if we're dealing with a known content-type\n        if ( ct ) {\n            for ( type in contents ) {\n                if ( contents[ type ] && contents[ type ].test( ct ) ) {\n                    dataTypes.unshift( type );\n                    break;\n                }\n            }\n        }\n\n        // Check to see if we have a response for the expected dataType\n        if ( dataTypes[ 0 ] in responses ) {\n            finalDataType = dataTypes[ 0 ];\n        } else {\n\n            // Try convertible dataTypes\n            for ( type in responses ) {\n                if ( !dataTypes[ 0 ] || s.converters[ type + \" \" + dataTypes[ 0 ] ] ) {\n                    finalDataType = type;\n                    break;\n                }\n                if ( !firstDataType ) {\n                    firstDataType = type;\n                }\n            }\n\n            // Or just use first one\n            finalDataType = finalDataType || firstDataType;\n        }\n\n        // If we found a dataType\n        // We add the dataType to the list if needed\n        // and return the corresponding response\n        if ( finalDataType ) {\n            if ( finalDataType !== dataTypes[ 0 ] ) {\n                dataTypes.unshift( finalDataType );\n            }\n            return responses[ finalDataType ];\n        }\n    }\n\n    /* Chain conversions given the request and the original response\n * Also sets the responseXXX fields on the jqXHR instance\n */\n    function ajaxConvert( s, response, jqXHR, isSuccess ) {\n        var conv2, current, conv, tmp, prev,\n            converters = {},\n\n            // Work with a copy of dataTypes in case we need to modify it for conversion\n            dataTypes = s.dataTypes.slice();\n\n        // Create converters map with lowercased keys\n        if ( dataTypes[ 1 ] ) {\n            for ( conv in s.converters ) {\n                converters[ conv.toLowerCase() ] = s.converters[ conv ];\n            }\n        }\n\n        current = dataTypes.shift();\n\n        // Convert to each sequential dataType\n        while ( current ) {\n\n            if ( s.responseFields[ current ] ) {\n                jqXHR[ s.responseFields[ current ] ] = response;\n            }\n\n            // Apply the dataFilter if provided\n            if ( !prev && isSuccess && s.dataFilter ) {\n                response = s.dataFilter( response, s.dataType );\n            }\n\n            prev = current;\n            current = dataTypes.shift();\n\n            if ( current ) {\n\n                // There's only work to do if current dataType is non-auto\n                if ( current === \"*\" ) {\n\n                    current = prev;\n\n                    // Convert response if prev dataType is non-auto and differs from current\n                } else if ( prev !== \"*\" && prev !== current ) {\n\n                    // Seek a direct converter\n                    conv = converters[ prev + \" \" + current ] || converters[ \"* \" + current ];\n\n                    // If none found, seek a pair\n                    if ( !conv ) {\n                        for ( conv2 in converters ) {\n\n                            // If conv2 outputs current\n                            tmp = conv2.split( \" \" );\n                            if ( tmp[ 1 ] === current ) {\n\n                                // If prev can be converted to accepted input\n                                conv = converters[ prev + \" \" + tmp[ 0 ] ] ||\n                                    converters[ \"* \" + tmp[ 0 ] ];\n                                if ( conv ) {\n\n                                    // Condense equivalence converters\n                                    if ( conv === true ) {\n                                        conv = converters[ conv2 ];\n\n                                        // Otherwise, insert the intermediate dataType\n                                    } else if ( converters[ conv2 ] !== true ) {\n                                        current = tmp[ 0 ];\n                                        dataTypes.unshift( tmp[ 1 ] );\n                                    }\n                                    break;\n                                }\n                            }\n                        }\n                    }\n\n                    // Apply converter (if not an equivalence)\n                    if ( conv !== true ) {\n\n                        // Unless errors are allowed to bubble, catch and return them\n                        if ( conv && s.throws ) {\n                            response = conv( response );\n                        } else {\n                            try {\n                                response = conv( response );\n                            } catch ( e ) {\n                                return {\n                                    state: \"parsererror\",\n                                    error: conv ? e : \"No conversion from \" + prev + \" to \" + current\n                                };\n                            }\n                        }\n                    }\n                }\n            }\n        }\n\n        return { state: \"success\", data: response };\n    }\n\n    jQuery.extend( {\n\n        // Counter for holding the number of active queries\n        active: 0,\n\n        // Last-Modified header cache for next request\n        lastModified: {},\n        etag: {},\n\n        ajaxSettings: {\n            url: location.href,\n            type: \"GET\",\n            isLocal: rlocalProtocol.test( location.protocol ),\n            global: true,\n            processData: true,\n            async: true,\n            contentType: \"application/x-www-form-urlencoded; charset=UTF-8\",\n\n            /*\n\t\ttimeout: 0,\n\t\tdata: null,\n\t\tdataType: null,\n\t\tusername: null,\n\t\tpassword: null,\n\t\tcache: null,\n\t\tthrows: false,\n\t\ttraditional: false,\n\t\theaders: {},\n\t\t*/\n\n            accepts: {\n                \"*\": allTypes,\n                text: \"text/plain\",\n                html: \"text/html\",\n                xml: \"application/xml, text/xml\",\n                json: \"application/json, text/javascript\"\n            },\n\n            contents: {\n                xml: /\\bxml\\b/,\n                html: /\\bhtml/,\n                json: /\\bjson\\b/\n            },\n\n            responseFields: {\n                xml: \"responseXML\",\n                text: \"responseText\",\n                json: \"responseJSON\"\n            },\n\n            // Data converters\n            // Keys separate source (or catchall \"*\") and destination types with a single space\n            converters: {\n\n                // Convert anything to text\n                \"* text\": String,\n\n                // Text to html (true = no transformation)\n                \"text html\": true,\n\n                // Evaluate text as a json expression\n                \"text json\": JSON.parse,\n\n                // Parse text as xml\n                \"text xml\": jQuery.parseXML\n            },\n\n            // For options that shouldn't be deep extended:\n            // you can add your own custom options here if\n            // and when you create one that shouldn't be\n            // deep extended (see ajaxExtend)\n            flatOptions: {\n                url: true,\n                context: true\n            }\n        },\n\n        // Creates a full fledged settings object into target\n        // with both ajaxSettings and settings fields.\n        // If target is omitted, writes into ajaxSettings.\n        ajaxSetup: function( target, settings ) {\n            return settings ?\n\n                // Building a settings object\n                ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :\n\n                // Extending ajaxSettings\n                ajaxExtend( jQuery.ajaxSettings, target );\n        },\n\n        ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),\n        ajaxTransport: addToPrefiltersOrTransports( transports ),\n\n        // Main method\n        ajax: function( url, options ) {\n\n            // If url is an object, simulate pre-1.5 signature\n            if ( typeof url === \"object\" ) {\n                options = url;\n                url = undefined;\n            }\n\n            // Force options to be an object\n            options = options || {};\n\n            var transport,\n\n                // URL without anti-cache param\n                cacheURL,\n\n                // Response headers\n                responseHeadersString,\n                responseHeaders,\n\n                // timeout handle\n                timeoutTimer,\n\n                // Url cleanup var\n                urlAnchor,\n\n                // Request state (becomes false upon send and true upon completion)\n                completed,\n\n                // To know if global events are to be dispatched\n                fireGlobals,\n\n                // Loop variable\n                i,\n\n                // uncached part of the url\n                uncached,\n\n                // Create the final options object\n                s = jQuery.ajaxSetup( {}, options ),\n\n                // Callbacks context\n                callbackContext = s.context || s,\n\n                // Context for global events is callbackContext if it is a DOM node or jQuery collection\n                globalEventContext = s.context &&\n                ( callbackContext.nodeType || callbackContext.jquery ) ?\n                    jQuery( callbackContext ) :\n                    jQuery.event,\n\n                // Deferreds\n                deferred = jQuery.Deferred(),\n                completeDeferred = jQuery.Callbacks( \"once memory\" ),\n\n                // Status-dependent callbacks\n                statusCode = s.statusCode || {},\n\n                // Headers (they are sent all at once)\n                requestHeaders = {},\n                requestHeadersNames = {},\n\n                // Default abort message\n                strAbort = \"canceled\",\n\n                // Fake xhr\n                jqXHR = {\n                    readyState: 0,\n\n                    // Builds headers hashtable if needed\n                    getResponseHeader: function( key ) {\n                        var match;\n                        if ( completed ) {\n                            if ( !responseHeaders ) {\n                                responseHeaders = {};\n                                while ( ( match = rheaders.exec( responseHeadersString ) ) ) {\n                                    responseHeaders[ match[ 1 ].toLowerCase() + \" \" ] =\n                                        ( responseHeaders[ match[ 1 ].toLowerCase() + \" \" ] || [] )\n                                            .concat( match[ 2 ] );\n                                }\n                            }\n                            match = responseHeaders[ key.toLowerCase() + \" \" ];\n                        }\n                        return match == null ? null : match.join( \", \" );\n                    },\n\n                    // Raw string\n                    getAllResponseHeaders: function() {\n                        return completed ? responseHeadersString : null;\n                    },\n\n                    // Caches the header\n                    setRequestHeader: function( name, value ) {\n                        if ( completed == null ) {\n                            name = requestHeadersNames[ name.toLowerCase() ] =\n                                requestHeadersNames[ name.toLowerCase() ] || name;\n                            requestHeaders[ name ] = value;\n                        }\n                        return this;\n                    },\n\n                    // Overrides response content-type header\n                    overrideMimeType: function( type ) {\n                        if ( completed == null ) {\n                            s.mimeType = type;\n                        }\n                        return this;\n                    },\n\n                    // Status-dependent callbacks\n                    statusCode: function( map ) {\n                        var code;\n                        if ( map ) {\n                            if ( completed ) {\n\n                                // Execute the appropriate callbacks\n                                jqXHR.always( map[ jqXHR.status ] );\n                            } else {\n\n                                // Lazy-add the new callbacks in a way that preserves old ones\n                                for ( code in map ) {\n                                    statusCode[ code ] = [ statusCode[ code ], map[ code ] ];\n                                }\n                            }\n                        }\n                        return this;\n                    },\n\n                    // Cancel the request\n                    abort: function( statusText ) {\n                        var finalText = statusText || strAbort;\n                        if ( transport ) {\n                            transport.abort( finalText );\n                        }\n                        done( 0, finalText );\n                        return this;\n                    }\n                };\n\n            // Attach deferreds\n            deferred.promise( jqXHR );\n\n            // Add protocol if not provided (prefilters might expect it)\n            // Handle falsy url in the settings object (trac-10093: consistency with old signature)\n            // We also use the url parameter if available\n            s.url = ( ( url || s.url || location.href ) + \"\" )\n                .replace( rprotocol, location.protocol + \"//\" );\n\n            // Alias method option to type as per ticket trac-12004\n            s.type = options.method || options.type || s.method || s.type;\n\n            // Extract dataTypes list\n            s.dataTypes = ( s.dataType || \"*\" ).toLowerCase().match( rnothtmlwhite ) || [ \"\" ];\n\n            // A cross-domain request is in order when the origin doesn't match the current origin.\n            if ( s.crossDomain == null ) {\n                urlAnchor = document.createElement( \"a\" );\n\n                // Support: IE <=8 - 11, Edge 12 - 15\n                // IE throws exception on accessing the href property if url is malformed,\n                // e.g. http://example.com:80x/\n                try {\n                    urlAnchor.href = s.url;\n\n                    // Support: IE <=8 - 11 only\n                    // Anchor's host property isn't correctly set when s.url is relative\n                    urlAnchor.href = urlAnchor.href;\n                    s.crossDomain = originAnchor.protocol + \"//\" + originAnchor.host !==\n                        urlAnchor.protocol + \"//\" + urlAnchor.host;\n                } catch ( e ) {\n\n                    // If there is an error parsing the URL, assume it is crossDomain,\n                    // it can be rejected by the transport if it is invalid\n                    s.crossDomain = true;\n                }\n            }\n\n            // Convert data if not already a string\n            if ( s.data && s.processData && typeof s.data !== \"string\" ) {\n                s.data = jQuery.param( s.data, s.traditional );\n            }\n\n            // Apply prefilters\n            inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );\n\n            // If request was aborted inside a prefilter, stop there\n            if ( completed ) {\n                return jqXHR;\n            }\n\n            // We can fire global events as of now if asked to\n            // Don't fire events if jQuery.event is undefined in an AMD-usage scenario (trac-15118)\n            fireGlobals = jQuery.event && s.global;\n\n            // Watch for a new set of requests\n            if ( fireGlobals && jQuery.active++ === 0 ) {\n                jQuery.event.trigger( \"ajaxStart\" );\n            }\n\n            // Uppercase the type\n            s.type = s.type.toUpperCase();\n\n            // Determine if request has content\n            s.hasContent = !rnoContent.test( s.type );\n\n            // Save the URL in case we're toying with the If-Modified-Since\n            // and/or If-None-Match header later on\n            // Remove hash to simplify url manipulation\n            cacheURL = s.url.replace( rhash, \"\" );\n\n            // More options handling for requests with no content\n            if ( !s.hasContent ) {\n\n                // Remember the hash so we can put it back\n                uncached = s.url.slice( cacheURL.length );\n\n                // If data is available and should be processed, append data to url\n                if ( s.data && ( s.processData || typeof s.data === \"string\" ) ) {\n                    cacheURL += ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + s.data;\n\n                    // trac-9682: remove data so that it's not used in an eventual retry\n                    delete s.data;\n                }\n\n                // Add or update anti-cache param if needed\n                if ( s.cache === false ) {\n                    cacheURL = cacheURL.replace( rantiCache, \"$1\" );\n                    uncached = ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + \"_=\" + ( nonce.guid++ ) +\n                        uncached;\n                }\n\n                // Put hash and anti-cache on the URL that will be requested (gh-1732)\n                s.url = cacheURL + uncached;\n\n                // Change '%20' to '+' if this is encoded form body content (gh-2658)\n            } else if ( s.data && s.processData &&\n                ( s.contentType || \"\" ).indexOf( \"application/x-www-form-urlencoded\" ) === 0 ) {\n                s.data = s.data.replace( r20, \"+\" );\n            }\n\n            // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n            if ( s.ifModified ) {\n                if ( jQuery.lastModified[ cacheURL ] ) {\n                    jqXHR.setRequestHeader( \"If-Modified-Since\", jQuery.lastModified[ cacheURL ] );\n                }\n                if ( jQuery.etag[ cacheURL ] ) {\n                    jqXHR.setRequestHeader( \"If-None-Match\", jQuery.etag[ cacheURL ] );\n                }\n            }\n\n            // Set the correct header, if data is being sent\n            if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {\n                jqXHR.setRequestHeader( \"Content-Type\", s.contentType );\n            }\n\n            // Set the Accepts header for the server, depending on the dataType\n            jqXHR.setRequestHeader(\n                \"Accept\",\n                s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?\n                    s.accepts[ s.dataTypes[ 0 ] ] +\n                    ( s.dataTypes[ 0 ] !== \"*\" ? \", \" + allTypes + \"; q=0.01\" : \"\" ) :\n                    s.accepts[ \"*\" ]\n            );\n\n            // Check for headers option\n            for ( i in s.headers ) {\n                jqXHR.setRequestHeader( i, s.headers[ i ] );\n            }\n\n            // Allow custom headers/mimetypes and early abort\n            if ( s.beforeSend &&\n                ( s.beforeSend.call( callbackContext, jqXHR, s ) === false || completed ) ) {\n\n                // Abort if not done already and return\n                return jqXHR.abort();\n            }\n\n            // Aborting is no longer a cancellation\n            strAbort = \"abort\";\n\n            // Install callbacks on deferreds\n            completeDeferred.add( s.complete );\n            jqXHR.done( s.success );\n            jqXHR.fail( s.error );\n\n            // Get transport\n            transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );\n\n            // If no transport, we auto-abort\n            if ( !transport ) {\n                done( -1, \"No Transport\" );\n            } else {\n                jqXHR.readyState = 1;\n\n                // Send global event\n                if ( fireGlobals ) {\n                    globalEventContext.trigger( \"ajaxSend\", [ jqXHR, s ] );\n                }\n\n                // If request was aborted inside ajaxSend, stop there\n                if ( completed ) {\n                    return jqXHR;\n                }\n\n                // Timeout\n                if ( s.async && s.timeout > 0 ) {\n                    timeoutTimer = window.setTimeout( function() {\n                        jqXHR.abort( \"timeout\" );\n                    }, s.timeout );\n                }\n\n                try {\n                    completed = false;\n                    transport.send( requestHeaders, done );\n                } catch ( e ) {\n\n                    // Rethrow post-completion exceptions\n                    if ( completed ) {\n                        throw e;\n                    }\n\n                    // Propagate others as results\n                    done( -1, e );\n                }\n            }\n\n            // Callback for when everything is done\n            function done( status, nativeStatusText, responses, headers ) {\n                var isSuccess, success, error, response, modified,\n                    statusText = nativeStatusText;\n\n                // Ignore repeat invocations\n                if ( completed ) {\n                    return;\n                }\n\n                completed = true;\n\n                // Clear timeout if it exists\n                if ( timeoutTimer ) {\n                    window.clearTimeout( timeoutTimer );\n                }\n\n                // Dereference transport for early garbage collection\n                // (no matter how long the jqXHR object will be used)\n                transport = undefined;\n\n                // Cache response headers\n                responseHeadersString = headers || \"\";\n\n                // Set readyState\n                jqXHR.readyState = status > 0 ? 4 : 0;\n\n                // Determine if successful\n                isSuccess = status >= 200 && status < 300 || status === 304;\n\n                // Get response data\n                if ( responses ) {\n                    response = ajaxHandleResponses( s, jqXHR, responses );\n                }\n\n                // Use a noop converter for missing script but not if jsonp\n                if ( !isSuccess &&\n                    jQuery.inArray( \"script\", s.dataTypes ) > -1 &&\n                    jQuery.inArray( \"json\", s.dataTypes ) < 0 ) {\n                    s.converters[ \"text script\" ] = function() {};\n                }\n\n                // Convert no matter what (that way responseXXX fields are always set)\n                response = ajaxConvert( s, response, jqXHR, isSuccess );\n\n                // If successful, handle type chaining\n                if ( isSuccess ) {\n\n                    // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n                    if ( s.ifModified ) {\n                        modified = jqXHR.getResponseHeader( \"Last-Modified\" );\n                        if ( modified ) {\n                            jQuery.lastModified[ cacheURL ] = modified;\n                        }\n                        modified = jqXHR.getResponseHeader( \"etag\" );\n                        if ( modified ) {\n                            jQuery.etag[ cacheURL ] = modified;\n                        }\n                    }\n\n                    // if no content\n                    if ( status === 204 || s.type === \"HEAD\" ) {\n                        statusText = \"nocontent\";\n\n                        // if not modified\n                    } else if ( status === 304 ) {\n                        statusText = \"notmodified\";\n\n                        // If we have data, let's convert it\n                    } else {\n                        statusText = response.state;\n                        success = response.data;\n                        error = response.error;\n                        isSuccess = !error;\n                    }\n                } else {\n\n                    // Extract error from statusText and normalize for non-aborts\n                    error = statusText;\n                    if ( status || !statusText ) {\n                        statusText = \"error\";\n                        if ( status < 0 ) {\n                            status = 0;\n                        }\n                    }\n                }\n\n                // Set data for the fake xhr object\n                jqXHR.status = status;\n                jqXHR.statusText = ( nativeStatusText || statusText ) + \"\";\n\n                // Success/Error\n                if ( isSuccess ) {\n                    deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );\n                } else {\n                    deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );\n                }\n\n                // Status-dependent callbacks\n                jqXHR.statusCode( statusCode );\n                statusCode = undefined;\n\n                if ( fireGlobals ) {\n                    globalEventContext.trigger( isSuccess ? \"ajaxSuccess\" : \"ajaxError\",\n                        [ jqXHR, s, isSuccess ? success : error ] );\n                }\n\n                // Complete\n                completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );\n\n                if ( fireGlobals ) {\n                    globalEventContext.trigger( \"ajaxComplete\", [ jqXHR, s ] );\n\n                    // Handle the global AJAX counter\n                    if ( !( --jQuery.active ) ) {\n                        jQuery.event.trigger( \"ajaxStop\" );\n                    }\n                }\n            }\n\n            return jqXHR;\n        },\n\n        getJSON: function( url, data, callback ) {\n            return jQuery.get( url, data, callback, \"json\" );\n        },\n\n        getScript: function( url, callback ) {\n            return jQuery.get( url, undefined, callback, \"script\" );\n        }\n    } );\n\n    jQuery.each( [ \"get\", \"post\" ], function( _i, method ) {\n        jQuery[ method ] = function( url, data, callback, type ) {\n\n            // Shift arguments if data argument was omitted\n            if ( isFunction( data ) ) {\n                type = type || callback;\n                callback = data;\n                data = undefined;\n            }\n\n            // The url can be an options object (which then must have .url)\n            return jQuery.ajax( jQuery.extend( {\n                url: url,\n                type: method,\n                dataType: type,\n                data: data,\n                success: callback\n            }, jQuery.isPlainObject( url ) && url ) );\n        };\n    } );\n\n    jQuery.ajaxPrefilter( function( s ) {\n        var i;\n        for ( i in s.headers ) {\n            if ( i.toLowerCase() === \"content-type\" ) {\n                s.contentType = s.headers[ i ] || \"\";\n            }\n        }\n    } );\n\n\n    jQuery._evalUrl = function( url, options, doc ) {\n        return jQuery.ajax( {\n            url: url,\n\n            // Make this explicit, since user can override this through ajaxSetup (trac-11264)\n            type: \"GET\",\n            dataType: \"script\",\n            cache: true,\n            async: false,\n            global: false,\n\n            // Only evaluate the response if it is successful (gh-4126)\n            // dataFilter is not invoked for failure responses, so using it instead\n            // of the default converter is kludgy but it works.\n            converters: {\n                \"text script\": function() {}\n            },\n            dataFilter: function( response ) {\n                jQuery.globalEval( response, options, doc );\n            }\n        } );\n    };\n\n\n    jQuery.fn.extend( {\n        wrapAll: function( html ) {\n            var wrap;\n\n            if ( this[ 0 ] ) {\n                if ( isFunction( html ) ) {\n                    html = html.call( this[ 0 ] );\n                }\n\n                // The elements to wrap the target around\n                wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );\n\n                if ( this[ 0 ].parentNode ) {\n                    wrap.insertBefore( this[ 0 ] );\n                }\n\n                wrap.map( function() {\n                    var elem = this;\n\n                    while ( elem.firstElementChild ) {\n                        elem = elem.firstElementChild;\n                    }\n\n                    return elem;\n                } ).append( this );\n            }\n\n            return this;\n        },\n\n        wrapInner: function( html ) {\n            if ( isFunction( html ) ) {\n                return this.each( function( i ) {\n                    jQuery( this ).wrapInner( html.call( this, i ) );\n                } );\n            }\n\n            return this.each( function() {\n                var self = jQuery( this ),\n                    contents = self.contents();\n\n                if ( contents.length ) {\n                    contents.wrapAll( html );\n\n                } else {\n                    self.append( html );\n                }\n            } );\n        },\n\n        wrap: function( html ) {\n            var htmlIsFunction = isFunction( html );\n\n            return this.each( function( i ) {\n                jQuery( this ).wrapAll( htmlIsFunction ? html.call( this, i ) : html );\n            } );\n        },\n\n        unwrap: function( selector ) {\n            this.parent( selector ).not( \"body\" ).each( function() {\n                jQuery( this ).replaceWith( this.childNodes );\n            } );\n            return this;\n        }\n    } );\n\n\n    jQuery.expr.pseudos.hidden = function( elem ) {\n        return !jQuery.expr.pseudos.visible( elem );\n    };\n    jQuery.expr.pseudos.visible = function( elem ) {\n        return !!( elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length );\n    };\n\n\n\n\n    jQuery.ajaxSettings.xhr = function() {\n        try {\n            return new window.XMLHttpRequest();\n        } catch ( e ) {}\n    };\n\n    var xhrSuccessStatus = {\n\n            // File protocol always yields status code 0, assume 200\n            0: 200,\n\n            // Support: IE <=9 only\n            // trac-1450: sometimes IE returns 1223 when it should be 204\n            1223: 204\n        },\n        xhrSupported = jQuery.ajaxSettings.xhr();\n\n    support.cors = !!xhrSupported && ( \"withCredentials\" in xhrSupported );\n    support.ajax = xhrSupported = !!xhrSupported;\n\n    jQuery.ajaxTransport( function( options ) {\n        var callback, errorCallback;\n\n        // Cross domain only allowed if supported through XMLHttpRequest\n        if ( support.cors || xhrSupported && !options.crossDomain ) {\n            return {\n                send: function( headers, complete ) {\n                    var i,\n                        xhr = options.xhr();\n\n                    xhr.open(\n                        options.type,\n                        options.url,\n                        options.async,\n                        options.username,\n                        options.password\n                    );\n\n                    // Apply custom fields if provided\n                    if ( options.xhrFields ) {\n                        for ( i in options.xhrFields ) {\n                            xhr[ i ] = options.xhrFields[ i ];\n                        }\n                    }\n\n                    // Override mime type if needed\n                    if ( options.mimeType && xhr.overrideMimeType ) {\n                        xhr.overrideMimeType( options.mimeType );\n                    }\n\n                    // X-Requested-With header\n                    // For cross-domain requests, seeing as conditions for a preflight are\n                    // akin to a jigsaw puzzle, we simply never set it to be sure.\n                    // (it can always be set on a per-request basis or even using ajaxSetup)\n                    // For same-domain requests, won't change header if already provided.\n                    if ( !options.crossDomain && !headers[ \"X-Requested-With\" ] ) {\n                        headers[ \"X-Requested-With\" ] = \"XMLHttpRequest\";\n                    }\n\n                    // Set headers\n                    for ( i in headers ) {\n                        xhr.setRequestHeader( i, headers[ i ] );\n                    }\n\n                    // Callback\n                    callback = function( type ) {\n                        return function() {\n                            if ( callback ) {\n                                callback = errorCallback = xhr.onload =\n                                    xhr.onerror = xhr.onabort = xhr.ontimeout =\n                                        xhr.onreadystatechange = null;\n\n                                if ( type === \"abort\" ) {\n                                    xhr.abort();\n                                } else if ( type === \"error\" ) {\n\n                                    // Support: IE <=9 only\n                                    // On a manual native abort, IE9 throws\n                                    // errors on any property access that is not readyState\n                                    if ( typeof xhr.status !== \"number\" ) {\n                                        complete( 0, \"error\" );\n                                    } else {\n                                        complete(\n\n                                            // File: protocol always yields status 0; see trac-8605, trac-14207\n                                            xhr.status,\n                                            xhr.statusText\n                                        );\n                                    }\n                                } else {\n                                    complete(\n                                        xhrSuccessStatus[ xhr.status ] || xhr.status,\n                                        xhr.statusText,\n\n                                        // Support: IE <=9 only\n                                        // IE9 has no XHR2 but throws on binary (trac-11426)\n                                        // For XHR2 non-text, let the caller handle it (gh-2498)\n                                        ( xhr.responseType || \"text\" ) !== \"text\"  ||\n                                        typeof xhr.responseText !== \"string\" ?\n                                            { binary: xhr.response } :\n                                            { text: xhr.responseText },\n                                        xhr.getAllResponseHeaders()\n                                    );\n                                }\n                            }\n                        };\n                    };\n\n                    // Listen to events\n                    xhr.onload = callback();\n                    errorCallback = xhr.onerror = xhr.ontimeout = callback( \"error\" );\n\n                    // Support: IE 9 only\n                    // Use onreadystatechange to replace onabort\n                    // to handle uncaught aborts\n                    if ( xhr.onabort !== undefined ) {\n                        xhr.onabort = errorCallback;\n                    } else {\n                        xhr.onreadystatechange = function() {\n\n                            // Check readyState before timeout as it changes\n                            if ( xhr.readyState === 4 ) {\n\n                                // Allow onerror to be called first,\n                                // but that will not handle a native abort\n                                // Also, save errorCallback to a variable\n                                // as xhr.onerror cannot be accessed\n                                window.setTimeout( function() {\n                                    if ( callback ) {\n                                        errorCallback();\n                                    }\n                                } );\n                            }\n                        };\n                    }\n\n                    // Create the abort callback\n                    callback = callback( \"abort\" );\n\n                    try {\n\n                        // Do send the request (this may raise an exception)\n                        xhr.send( options.hasContent && options.data || null );\n                    } catch ( e ) {\n\n                        // trac-14683: Only rethrow if this hasn't been notified as an error yet\n                        if ( callback ) {\n                            throw e;\n                        }\n                    }\n                },\n\n                abort: function() {\n                    if ( callback ) {\n                        callback();\n                    }\n                }\n            };\n        }\n    } );\n\n\n\n\n// Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)\n    jQuery.ajaxPrefilter( function( s ) {\n        if ( s.crossDomain ) {\n            s.contents.script = false;\n        }\n    } );\n\n// Install script dataType\n    jQuery.ajaxSetup( {\n        accepts: {\n            script: \"text/javascript, application/javascript, \" +\n                \"application/ecmascript, application/x-ecmascript\"\n        },\n        contents: {\n            script: /\\b(?:java|ecma)script\\b/\n        },\n        converters: {\n            \"text script\": function( text ) {\n                jQuery.globalEval( text );\n                return text;\n            }\n        }\n    } );\n\n// Handle cache's special case and crossDomain\n    jQuery.ajaxPrefilter( \"script\", function( s ) {\n        if ( s.cache === undefined ) {\n            s.cache = false;\n        }\n        if ( s.crossDomain ) {\n            s.type = \"GET\";\n        }\n    } );\n\n// Bind script tag hack transport\n    jQuery.ajaxTransport( \"script\", function( s ) {\n\n        // This transport only deals with cross domain or forced-by-attrs requests\n        if ( s.crossDomain || s.scriptAttrs ) {\n            var script, callback;\n            return {\n                send: function( _, complete ) {\n                    script = jQuery( \"<script>\" )\n                        .attr( s.scriptAttrs || {} )\n                        .prop( { charset: s.scriptCharset, src: s.url } )\n                        .on( \"load error\", callback = function( evt ) {\n                            script.remove();\n                            callback = null;\n                            if ( evt ) {\n                                complete( evt.type === \"error\" ? 404 : 200, evt.type );\n                            }\n                        } );\n\n                    // Use native DOM manipulation to avoid our domManip AJAX trickery\n                    document.head.appendChild( script[ 0 ] );\n                },\n                abort: function() {\n                    if ( callback ) {\n                        callback();\n                    }\n                }\n            };\n        }\n    } );\n\n\n\n\n    var oldCallbacks = [],\n        rjsonp = /(=)\\?(?=&|$)|\\?\\?/;\n\n// Default jsonp settings\n    jQuery.ajaxSetup( {\n        jsonp: \"callback\",\n        jsonpCallback: function() {\n            var callback = oldCallbacks.pop() || ( jQuery.expando + \"_\" + ( nonce.guid++ ) );\n            this[ callback ] = true;\n            return callback;\n        }\n    } );\n\n// Detect, normalize options and install callbacks for jsonp requests\n    jQuery.ajaxPrefilter( \"json jsonp\", function( s, originalSettings, jqXHR ) {\n\n        var callbackName, overwritten, responseContainer,\n            jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?\n                    \"url\" :\n                    typeof s.data === \"string\" &&\n                    ( s.contentType || \"\" )\n                        .indexOf( \"application/x-www-form-urlencoded\" ) === 0 &&\n                    rjsonp.test( s.data ) && \"data\"\n            );\n\n        // Handle iff the expected data type is \"jsonp\" or we have a parameter to set\n        if ( jsonProp || s.dataTypes[ 0 ] === \"jsonp\" ) {\n\n            // Get callback name, remembering preexisting value associated with it\n            callbackName = s.jsonpCallback = isFunction( s.jsonpCallback ) ?\n                s.jsonpCallback() :\n                s.jsonpCallback;\n\n            // Insert callback into url or form data\n            if ( jsonProp ) {\n                s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, \"$1\" + callbackName );\n            } else if ( s.jsonp !== false ) {\n                s.url += ( rquery.test( s.url ) ? \"&\" : \"?\" ) + s.jsonp + \"=\" + callbackName;\n            }\n\n            // Use data converter to retrieve json after script execution\n            s.converters[ \"script json\" ] = function() {\n                if ( !responseContainer ) {\n                    jQuery.error( callbackName + \" was not called\" );\n                }\n                return responseContainer[ 0 ];\n            };\n\n            // Force json dataType\n            s.dataTypes[ 0 ] = \"json\";\n\n            // Install callback\n            overwritten = window[ callbackName ];\n            window[ callbackName ] = function() {\n                responseContainer = arguments;\n            };\n\n            // Clean-up function (fires after converters)\n            jqXHR.always( function() {\n\n                // If previous value didn't exist - remove it\n                if ( overwritten === undefined ) {\n                    jQuery( window ).removeProp( callbackName );\n\n                    // Otherwise restore preexisting value\n                } else {\n                    window[ callbackName ] = overwritten;\n                }\n\n                // Save back as free\n                if ( s[ callbackName ] ) {\n\n                    // Make sure that re-using the options doesn't screw things around\n                    s.jsonpCallback = originalSettings.jsonpCallback;\n\n                    // Save the callback name for future use\n                    oldCallbacks.push( callbackName );\n                }\n\n                // Call if it was a function and we have a response\n                if ( responseContainer && isFunction( overwritten ) ) {\n                    overwritten( responseContainer[ 0 ] );\n                }\n\n                responseContainer = overwritten = undefined;\n            } );\n\n            // Delegate to script\n            return \"script\";\n        }\n    } );\n\n\n\n\n// Support: Safari 8 only\n// In Safari 8 documents created via document.implementation.createHTMLDocument\n// collapse sibling forms: the second one becomes a child of the first one.\n// Because of that, this security measure has to be disabled in Safari 8.\n// https://bugs.webkit.org/show_bug.cgi?id=137337\n    support.createHTMLDocument = ( function() {\n        var body = document.implementation.createHTMLDocument( \"\" ).body;\n        body.innerHTML = \"<form></form><form></form>\";\n        return body.childNodes.length === 2;\n    } )();\n\n\n// Argument \"data\" should be string of html\n// context (optional): If specified, the fragment will be created in this context,\n// defaults to document\n// keepScripts (optional): If true, will include scripts passed in the html string\n    jQuery.parseHTML = function( data, context, keepScripts ) {\n        if ( typeof data !== \"string\" ) {\n            return [];\n        }\n        if ( typeof context === \"boolean\" ) {\n            keepScripts = context;\n            context = false;\n        }\n\n        var base, parsed, scripts;\n\n        if ( !context ) {\n\n            // Stop scripts or inline event handlers from being executed immediately\n            // by using document.implementation\n            if ( support.createHTMLDocument ) {\n                context = document.implementation.createHTMLDocument( \"\" );\n\n                // Set the base href for the created document\n                // so any parsed elements with URLs\n                // are based on the document's URL (gh-2965)\n                base = context.createElement( \"base\" );\n                base.href = document.location.href;\n                context.head.appendChild( base );\n            } else {\n                context = document;\n            }\n        }\n\n        parsed = rsingleTag.exec( data );\n        scripts = !keepScripts && [];\n\n        // Single tag\n        if ( parsed ) {\n            return [ context.createElement( parsed[ 1 ] ) ];\n        }\n\n        parsed = buildFragment( [ data ], context, scripts );\n\n        if ( scripts && scripts.length ) {\n            jQuery( scripts ).remove();\n        }\n\n        return jQuery.merge( [], parsed.childNodes );\n    };\n\n\n    /**\n     * Load a url into a page\n     */\n    jQuery.fn.load = function( url, params, callback ) {\n        var selector, type, response,\n            self = this,\n            off = url.indexOf( \" \" );\n\n        if ( off > -1 ) {\n            selector = stripAndCollapse( url.slice( off ) );\n            url = url.slice( 0, off );\n        }\n\n        // If it's a function\n        if ( isFunction( params ) ) {\n\n            // We assume that it's the callback\n            callback = params;\n            params = undefined;\n\n            // Otherwise, build a param string\n        } else if ( params && typeof params === \"object\" ) {\n            type = \"POST\";\n        }\n\n        // If we have elements to modify, make the request\n        if ( self.length > 0 ) {\n            jQuery.ajax( {\n                url: url,\n\n                // If \"type\" variable is undefined, then \"GET\" method will be used.\n                // Make value of this field explicit since\n                // user can override it through ajaxSetup method\n                type: type || \"GET\",\n                dataType: \"html\",\n                data: params\n            } ).done( function( responseText ) {\n\n                // Save response for use in complete callback\n                response = arguments;\n\n                self.html( selector ?\n\n                    // If a selector was specified, locate the right elements in a dummy div\n                    // Exclude scripts to avoid IE 'Permission Denied' errors\n                    jQuery( \"<div>\" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :\n\n                    // Otherwise use the full result\n                    responseText );\n\n                // If the request succeeds, this function gets \"data\", \"status\", \"jqXHR\"\n                // but they are ignored because response was set above.\n                // If it fails, this function gets \"jqXHR\", \"status\", \"error\"\n            } ).always( callback && function( jqXHR, status ) {\n                self.each( function() {\n                    callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );\n                } );\n            } );\n        }\n\n        return this;\n    };\n\n\n\n\n    jQuery.expr.pseudos.animated = function( elem ) {\n        return jQuery.grep( jQuery.timers, function( fn ) {\n            return elem === fn.elem;\n        } ).length;\n    };\n\n\n\n\n    jQuery.offset = {\n        setOffset: function( elem, options, i ) {\n            var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,\n                position = jQuery.css( elem, \"position\" ),\n                curElem = jQuery( elem ),\n                props = {};\n\n            // Set position first, in-case top/left are set even on static elem\n            if ( position === \"static\" ) {\n                elem.style.position = \"relative\";\n            }\n\n            curOffset = curElem.offset();\n            curCSSTop = jQuery.css( elem, \"top\" );\n            curCSSLeft = jQuery.css( elem, \"left\" );\n            calculatePosition = ( position === \"absolute\" || position === \"fixed\" ) &&\n                ( curCSSTop + curCSSLeft ).indexOf( \"auto\" ) > -1;\n\n            // Need to be able to calculate position if either\n            // top or left is auto and position is either absolute or fixed\n            if ( calculatePosition ) {\n                curPosition = curElem.position();\n                curTop = curPosition.top;\n                curLeft = curPosition.left;\n\n            } else {\n                curTop = parseFloat( curCSSTop ) || 0;\n                curLeft = parseFloat( curCSSLeft ) || 0;\n            }\n\n            if ( isFunction( options ) ) {\n\n                // Use jQuery.extend here to allow modification of coordinates argument (gh-1848)\n                options = options.call( elem, i, jQuery.extend( {}, curOffset ) );\n            }\n\n            if ( options.top != null ) {\n                props.top = ( options.top - curOffset.top ) + curTop;\n            }\n            if ( options.left != null ) {\n                props.left = ( options.left - curOffset.left ) + curLeft;\n            }\n\n            if ( \"using\" in options ) {\n                options.using.call( elem, props );\n\n            } else {\n                curElem.css( props );\n            }\n        }\n    };\n\n    jQuery.fn.extend( {\n\n        // offset() relates an element's border box to the document origin\n        offset: function( options ) {\n\n            // Preserve chaining for setter\n            if ( arguments.length ) {\n                return options === undefined ?\n                    this :\n                    this.each( function( i ) {\n                        jQuery.offset.setOffset( this, options, i );\n                    } );\n            }\n\n            var rect, win,\n                elem = this[ 0 ];\n\n            if ( !elem ) {\n                return;\n            }\n\n            // Return zeros for disconnected and hidden (display: none) elements (gh-2310)\n            // Support: IE <=11 only\n            // Running getBoundingClientRect on a\n            // disconnected node in IE throws an error\n            if ( !elem.getClientRects().length ) {\n                return { top: 0, left: 0 };\n            }\n\n            // Get document-relative position by adding viewport scroll to viewport-relative gBCR\n            rect = elem.getBoundingClientRect();\n            win = elem.ownerDocument.defaultView;\n            return {\n                top: rect.top + win.pageYOffset,\n                left: rect.left + win.pageXOffset\n            };\n        },\n\n        // position() relates an element's margin box to its offset parent's padding box\n        // This corresponds to the behavior of CSS absolute positioning\n        position: function() {\n            if ( !this[ 0 ] ) {\n                return;\n            }\n\n            var offsetParent, offset, doc,\n                elem = this[ 0 ],\n                parentOffset = { top: 0, left: 0 };\n\n            // position:fixed elements are offset from the viewport, which itself always has zero offset\n            if ( jQuery.css( elem, \"position\" ) === \"fixed\" ) {\n\n                // Assume position:fixed implies availability of getBoundingClientRect\n                offset = elem.getBoundingClientRect();\n\n            } else {\n                offset = this.offset();\n\n                // Account for the *real* offset parent, which can be the document or its root element\n                // when a statically positioned element is identified\n                doc = elem.ownerDocument;\n                offsetParent = elem.offsetParent || doc.documentElement;\n                while ( offsetParent &&\n                ( offsetParent === doc.body || offsetParent === doc.documentElement ) &&\n                jQuery.css( offsetParent, \"position\" ) === \"static\" ) {\n\n                    offsetParent = offsetParent.parentNode;\n                }\n                if ( offsetParent && offsetParent !== elem && offsetParent.nodeType === 1 ) {\n\n                    // Incorporate borders into its offset, since they are outside its content origin\n                    parentOffset = jQuery( offsetParent ).offset();\n                    parentOffset.top += jQuery.css( offsetParent, \"borderTopWidth\", true );\n                    parentOffset.left += jQuery.css( offsetParent, \"borderLeftWidth\", true );\n                }\n            }\n\n            // Subtract parent offsets and element margins\n            return {\n                top: offset.top - parentOffset.top - jQuery.css( elem, \"marginTop\", true ),\n                left: offset.left - parentOffset.left - jQuery.css( elem, \"marginLeft\", true )\n            };\n        },\n\n        // This method will return documentElement in the following cases:\n        // 1) For the element inside the iframe without offsetParent, this method will return\n        //    documentElement of the parent window\n        // 2) For the hidden or detached element\n        // 3) For body or html element, i.e. in case of the html node - it will return itself\n        //\n        // but those exceptions were never presented as a real life use-cases\n        // and might be considered as more preferable results.\n        //\n        // This logic, however, is not guaranteed and can change at any point in the future\n        offsetParent: function() {\n            return this.map( function() {\n                var offsetParent = this.offsetParent;\n\n                while ( offsetParent && jQuery.css( offsetParent, \"position\" ) === \"static\" ) {\n                    offsetParent = offsetParent.offsetParent;\n                }\n\n                return offsetParent || documentElement;\n            } );\n        }\n    } );\n\n// Create scrollLeft and scrollTop methods\n    jQuery.each( { scrollLeft: \"pageXOffset\", scrollTop: \"pageYOffset\" }, function( method, prop ) {\n        var top = \"pageYOffset\" === prop;\n\n        jQuery.fn[ method ] = function( val ) {\n            return access( this, function( elem, method, val ) {\n\n                // Coalesce documents and windows\n                var win;\n                if ( isWindow( elem ) ) {\n                    win = elem;\n                } else if ( elem.nodeType === 9 ) {\n                    win = elem.defaultView;\n                }\n\n                if ( val === undefined ) {\n                    return win ? win[ prop ] : elem[ method ];\n                }\n\n                if ( win ) {\n                    win.scrollTo(\n                        !top ? val : win.pageXOffset,\n                        top ? val : win.pageYOffset\n                    );\n\n                } else {\n                    elem[ method ] = val;\n                }\n            }, method, val, arguments.length );\n        };\n    } );\n\n// Support: Safari <=7 - 9.1, Chrome <=37 - 49\n// Add the top/left cssHooks using jQuery.fn.position\n// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084\n// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347\n// getComputedStyle returns percent when specified for top/left/bottom/right;\n// rather than make the css module depend on the offset module, just check for it here\n    jQuery.each( [ \"top\", \"left\" ], function( _i, prop ) {\n        jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,\n            function( elem, computed ) {\n                if ( computed ) {\n                    computed = curCSS( elem, prop );\n\n                    // If curCSS returns percentage, fallback to offset\n                    return rnumnonpx.test( computed ) ?\n                        jQuery( elem ).position()[ prop ] + \"px\" :\n                        computed;\n                }\n            }\n        );\n    } );\n\n\n// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods\n    jQuery.each( { Height: \"height\", Width: \"width\" }, function( name, type ) {\n        jQuery.each( {\n            padding: \"inner\" + name,\n            content: type,\n            \"\": \"outer\" + name\n        }, function( defaultExtra, funcName ) {\n\n            // Margin is only for outerHeight, outerWidth\n            jQuery.fn[ funcName ] = function( margin, value ) {\n                var chainable = arguments.length && ( defaultExtra || typeof margin !== \"boolean\" ),\n                    extra = defaultExtra || ( margin === true || value === true ? \"margin\" : \"border\" );\n\n                return access( this, function( elem, type, value ) {\n                    var doc;\n\n                    if ( isWindow( elem ) ) {\n\n                        // $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)\n                        return funcName.indexOf( \"outer\" ) === 0 ?\n                            elem[ \"inner\" + name ] :\n                            elem.document.documentElement[ \"client\" + name ];\n                    }\n\n                    // Get document width or height\n                    if ( elem.nodeType === 9 ) {\n                        doc = elem.documentElement;\n\n                        // Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],\n                        // whichever is greatest\n                        return Math.max(\n                            elem.body[ \"scroll\" + name ], doc[ \"scroll\" + name ],\n                            elem.body[ \"offset\" + name ], doc[ \"offset\" + name ],\n                            doc[ \"client\" + name ]\n                        );\n                    }\n\n                    return value === undefined ?\n\n                        // Get width or height on the element, requesting but not forcing parseFloat\n                        jQuery.css( elem, type, extra ) :\n\n                        // Set width or height on the element\n                        jQuery.style( elem, type, value, extra );\n                }, type, chainable ? margin : undefined, chainable );\n            };\n        } );\n    } );\n\n\n    jQuery.each( [\n        \"ajaxStart\",\n        \"ajaxStop\",\n        \"ajaxComplete\",\n        \"ajaxError\",\n        \"ajaxSuccess\",\n        \"ajaxSend\"\n    ], function( _i, type ) {\n        jQuery.fn[ type ] = function( fn ) {\n            return this.on( type, fn );\n        };\n    } );\n\n\n\n\n    jQuery.fn.extend( {\n\n        bind: function( types, data, fn ) {\n            return this.on( types, null, data, fn );\n        },\n        unbind: function( types, fn ) {\n            return this.off( types, null, fn );\n        },\n\n        delegate: function( selector, types, data, fn ) {\n            return this.on( types, selector, data, fn );\n        },\n        undelegate: function( selector, types, fn ) {\n\n            // ( namespace ) or ( selector, types [, fn] )\n            return arguments.length === 1 ?\n                this.off( selector, \"**\" ) :\n                this.off( types, selector || \"**\", fn );\n        },\n\n        hover: function( fnOver, fnOut ) {\n            return this\n                .on( \"mouseenter\", fnOver )\n                .on( \"mouseleave\", fnOut || fnOver );\n        }\n    } );\n\n    jQuery.each(\n        ( \"blur focus focusin focusout resize scroll click dblclick \" +\n            \"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave \" +\n            \"change select submit keydown keypress keyup contextmenu\" ).split( \" \" ),\n        function( _i, name ) {\n\n            // Handle event binding\n            jQuery.fn[ name ] = function( data, fn ) {\n                return arguments.length > 0 ?\n                    this.on( name, null, data, fn ) :\n                    this.trigger( name );\n            };\n        }\n    );\n\n\n\n\n// Support: Android <=4.0 only\n// Make sure we trim BOM and NBSP\n// Require that the \"whitespace run\" starts from a non-whitespace\n// to avoid O(N^2) behavior when the engine would try matching \"\\s+$\" at each space position.\n    var rtrim = /^[\\s\\uFEFF\\xA0]+|([^\\s\\uFEFF\\xA0])[\\s\\uFEFF\\xA0]+$/g;\n\n// Bind a function to a context, optionally partially applying any\n// arguments.\n// jQuery.proxy is deprecated to promote standards (specifically Function#bind)\n// However, it is not slated for removal any time soon\n    jQuery.proxy = function( fn, context ) {\n        var tmp, args, proxy;\n\n        if ( typeof context === \"string\" ) {\n            tmp = fn[ context ];\n            context = fn;\n            fn = tmp;\n        }\n\n        // Quick check to determine if target is callable, in the spec\n        // this throws a TypeError, but we will just return undefined.\n        if ( !isFunction( fn ) ) {\n            return undefined;\n        }\n\n        // Simulated bind\n        args = slice.call( arguments, 2 );\n        proxy = function() {\n            return fn.apply( context || this, args.concat( slice.call( arguments ) ) );\n        };\n\n        // Set the guid of unique handler to the same of original handler, so it can be removed\n        proxy.guid = fn.guid = fn.guid || jQuery.guid++;\n\n        return proxy;\n    };\n\n    jQuery.holdReady = function( hold ) {\n        if ( hold ) {\n            jQuery.readyWait++;\n        } else {\n            jQuery.ready( true );\n        }\n    };\n    jQuery.isArray = Array.isArray;\n    jQuery.parseJSON = JSON.parse;\n    jQuery.nodeName = nodeName;\n    jQuery.isFunction = isFunction;\n    jQuery.isWindow = isWindow;\n    jQuery.camelCase = camelCase;\n    jQuery.type = toType;\n\n    jQuery.now = Date.now;\n\n    jQuery.isNumeric = function( obj ) {\n\n        // As of jQuery 3.0, isNumeric is limited to\n        // strings and numbers (primitives or objects)\n        // that can be coerced to finite numbers (gh-2662)\n        var type = jQuery.type( obj );\n        return ( type === \"number\" || type === \"string\" ) &&\n\n            // parseFloat NaNs numeric-cast false positives (\"\")\n            // ...but misinterprets leading-number strings, particularly hex literals (\"0x...\")\n            // subtraction forces infinities to NaN\n            !isNaN( obj - parseFloat( obj ) );\n    };\n\n    jQuery.trim = function( text ) {\n        return text == null ?\n            \"\" :\n            ( text + \"\" ).replace( rtrim, \"$1\" );\n    };\n\n\n\n// Register as a named AMD module, since jQuery can be concatenated with other\n// files that may use define, but not via a proper concatenation script that\n// understands anonymous AMD modules. A named AMD is safest and most robust\n// way to register. Lowercase jquery is used because AMD module names are\n// derived from file names, and jQuery is normally delivered in a lowercase\n// file name. Do this after creating the global so that if an AMD module wants\n// to call noConflict to hide this version of jQuery, it will work.\n\n// Note that for maximum portability, libraries that are not jQuery should\n// declare themselves as anonymous modules, and avoid setting a global if an\n// AMD loader is present. jQuery is a special case. For more information, see\n// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon\n\n    if ( typeof define === \"function\" && define.amd ) {\n        define( \"jquery\", [], function() {\n            return jQuery;\n        } );\n    }\n\n\n\n\n    var\n\n        // Map over jQuery in case of overwrite\n        _jQuery = window.jQuery,\n\n        // Map over the $ in case of overwrite\n        _$ = window.$;\n\n    jQuery.noConflict = function( deep ) {\n        if ( window.$ === jQuery ) {\n            window.$ = _$;\n        }\n\n        if ( deep && window.jQuery === jQuery ) {\n            window.jQuery = _jQuery;\n        }\n\n        return jQuery;\n    };\n\n// Expose jQuery and $ identifiers, even in AMD\n// (trac-7102#comment:10, https://github.com/jquery/jquery/pull/557)\n// and CommonJS for browser emulators (trac-13566)\n    if ( typeof noGlobal === \"undefined\" ) {\n        window.jQuery = window.$ = jQuery;\n    }\n\n\n\n\n    return jQuery;\n} );\n","Magento_Translation/js/add-class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).addClass(config.class);\n    };\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Translation/js/mage-translation-dictionary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'text!js-translation.json'\n], function (dict) {\n    'use strict';\n\n    return JSON.parse(dict);\n});\n","Extendware_AskQuestion/js/view/form.js":"define(\n    [\n        'jquery',\n        'uiComponent',\n        'knockout',\n        'mage/translate',\n    ],\n    function ($, Component, ko, $t,) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Extendware_AskQuestion/view/form',\n            },\n            productSku: null,\n            productName: null,\n            form_key: $.cookie('form_key'),\n            responseMessage: ko.observable(''),\n            questionSent: ko.observable(false),\n            formData: ko.observable({\n                name: '',\n                email: '',\n                question: '',\n            }),\n            initialize: function(config) {\n                this._super();\n                const self = this;\n\n                self.buttonLabel = ko.computed(() => {\n                    return self.questionSent() ? $t('Sent') : $t('Submit Question');\n                });\n\n                self.productName = config.productName;\n                self.endpoint = config.endpoint;\n                self.productSku = config.productSku;\n            },\n            sendQuestion: function () {\n                const self = this;\n\n                if (self.questionSent()) {\n                    return true;\n                }\n\n                self.questionSent(true);\n\n                self.postFormData(self.endpoint,\n                    {\n                        ...self.formData(),\n                        product_sku: self.productSku,\n                        form_key: self.form_key,\n                        isAjax: true,\n                    })\n                    .then((data) => {\n                        self.responseMessage(data.msg);\n\n                        if (!data || !data.success) {\n                            this.questionSent(false);\n                        }\n                    });\n            },\n            postFormData: async function (url, data) {\n                const response = await fetch(url, {\n                    method: 'POST',\n                    headers: {\n                        \"content-type\": \"application/x-www-form-urlencoded; charset=UTF-8\",\n                    },\n                    body: new URLSearchParams(data),\n                });\n\n                return response.json();\n            }\n        });\n    }\n);\n","Extendware_Bfcache/js/service-worker-handler.js":"/*\n web-vision GmbH\n Do not edit or add to this file if you wish to upgrade Magento to newer\n versions in the future. If you wish to customize Magento for your\n needs please refer to https://www.web-vision.de for more information.\n @category    Extendware\n @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)\n @author      Bushra Asif <ba@web-vision.de>\n*/\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data'\n], function ($, customerData) {\n    'use strict';\n\n    return function (config) {\n        // Event listener for the 'pageshow' event\n        window.addEventListener('pageshow', (event) => {\n            // Retrieve navigation entries to check navigation type\n            const navigationEntries = performance.getEntriesByType('navigation');\n            const navTiming = navigationEntries.length > 0 ? navigationEntries[0] : null;\n            const eventTypes = ['click', 'wheel', 'scroll', 'keydown'];\n\n            // Check if the event is persisted or a 'back_forward' type of navigation\n            if (event.persisted || (navTiming && navTiming.type === 'back_forward')) {\n                // Check if minicart is enabled in the configuration\n                if (config && config.isminicartenabled) {\n                    // Function to handle updating the minicart on specified events\n                    const handleMiniCartUpdate = (eventList) => {\n                        // Update the minicart and remove event listeners\n                        const updateMiniCart = () => {\n                            eventList.forEach(type => window.removeEventListener(type, updateMiniCart));\n                            reloadCart();\n                        };\n                        // Add event listeners for specified events\n                        eventList.forEach(type => window.addEventListener(type, updateMiniCart, {\n                            once: true,\n                            passive: true\n                        }));\n                    };\n                    handleMiniCartUpdate(eventTypes);\n                } else {\n                    // Reload cart if minicart is not enabled\n                    reloadCart();\n                }\n            }\n        });\n\n        // Reload cart data\n        function reloadCart() {\n            customerData.reload(['cart'], true);\n        }\n\n        const events = ['touchstart', 'mouseover'];\n        let DELAY_ON_HOVER = 65;\n        const DELAY_TO_NOT_BE_CONSIDERED_A_TOUCH_INITIATED_ACTION = 1200;\n        let preloadaction = config.getpreloadintensity;\n        if(preloadaction === 'custom') {\n            DELAY_ON_HOVER = config.customdelay;\n        }\n        let blackListUrls = /(customer|checkout|sendfriend|\\?|#)/;\n        let blacklistUrlsArray = config.blacklisturls;\n        let blacklistUrls = blacklistUrlsArray.join(',');\n        blacklistUrls = blacklistUrls.trim();\n        if (blacklistUrls.length > 0) {\n            blackListUrls = new RegExp('(' + blacklistUrls.split(',').map(item => item.replace(/[.*+\\-?^${}()|[\\]\\\\]/g, '\\\\$&')).join('|') + ')');\n        }\n\n        let lastTouchTimestamp;\n        let mouseoverTimer;\n        let preloadedList = new Set();\n\n        function init() {\n            if (!document.createElement('link').relList.supports('prefetch')) {\n                return;\n            }\n            const eventListenersOptions = { capture: true, passive: true };\n\n            document.addEventListener('touchstart', touchstartListener, eventListenersOptions);\n            document.addEventListener('mouseover', mouseoverListener, eventListenersOptions);\n\n            observeViewportLinks();\n        }\n\n        function touchstartListener(event) {\n            lastTouchTimestamp = performance.now();\n            const anchorElement = event.target.closest('a');\n\n            if (isPreloadable(anchorElement)) {\n                preload(anchorElement.href, 'high');\n            }\n        }\n\n        function mouseoverListener(event) {\n            if (performance.now() - lastTouchTimestamp < DELAY_TO_NOT_BE_CONSIDERED_A_TOUCH_INITIATED_ACTION) {\n                return;\n            }\n\n            const anchorElement = event.target.closest('a');\n            if (!anchorElement) return;\n\n            anchorElement.addEventListener('mouseout', mouseoutListener, { passive: true });\n\n            mouseoverTimer = setTimeout(() => {\n                if (isPreloadable(anchorElement)) {\n                    preload(anchorElement.href, 'high');\n                }\n                mouseoverTimer = undefined;\n            }, DELAY_ON_HOVER);\n        }\n\n        function mouseoutListener(event) {\n            if (mouseoverTimer) {\n                clearTimeout(mouseoverTimer);\n                mouseoverTimer = undefined;\n            }\n        }\n\n        function observeViewportLinks() {\n            if (!('IntersectionObserver' in window)) {\n                return;\n            }\n\n            const intersectionObserver = new IntersectionObserver((entries) => {\n                entries.forEach((entry) => {\n                    if (entry.isIntersecting) {\n                        const anchorElement = entry.target;\n                        intersectionObserver.unobserve(anchorElement);\n                        preload(anchorElement.href);\n                    }\n                });\n            });\n\n            document.querySelectorAll('a').forEach((anchorElement) => {\n                if (isPreloadable(anchorElement)) {\n                    intersectionObserver.observe(anchorElement);\n                }\n            });\n        }\n\n        function isPreloadable(anchorElement) {\n            if (!anchorElement || !anchorElement.href) {\n                return false;\n            }\n\n            if (blackListUrls && anchorElement.href.match(blackListUrls)) {\n                return false;\n            }\n\n            if (anchorElement.origin !== location.origin) {\n                return false;\n            }\n\n            if (!['http:', 'https:'].includes(anchorElement.protocol)) {\n                return false;\n            }\n\n            if (anchorElement.protocol === 'http:' && location.protocol === 'https:') {\n                return false;\n            }\n\n            if (anchorElement.hash && anchorElement.pathname + anchorElement.search === location.pathname + location.search) {\n                return false;\n            }\n\n            return true;\n        }\n\n        function preload(url, fetchPriority = 'auto') {\n            if (preloadedList.has(url)) {\n                return;\n            }\n\n            const linkElement = document.createElement('link');\n            linkElement.rel = 'prefetch';\n            linkElement.href = url;\n            linkElement.fetchPriority = fetchPriority;\n            linkElement.as = 'document';\n\n            document.head.appendChild(linkElement);\n            preloadedList.add(url);\n        }\n\n        function loadPagePreload() {\n            events.forEach(type => window.removeEventListener(type, loadPagePreload));\n            init();\n        }\n\n        events.forEach(type => window.addEventListener(type, loadPagePreload, { once: true, passive: true }));\n\n    };\n});\n","Magento_PageCache/js/form-key-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return function (settings) {\n        var formKey,\n            inputElements,\n            inputSelector = 'input[name=\"form_key\"]';\n\n        /**\n         * Set form_key cookie\n         * @private\n         */\n        function setFormKeyCookie(value) {\n            var expires,\n                secure,\n                date = new Date(),\n                cookiesConfig = window.cookiesConfig || {},\n                isSecure = !!cookiesConfig.secure,\n                samesite = cookiesConfig.samesite || 'lax';\n\n            date.setTime(date.getTime() + 86400000);\n            expires = '; expires=' + date.toUTCString();\n            secure = isSecure ? '; secure' : '';\n            samesite = '; samesite=' + samesite;\n\n            document.cookie = 'form_key=' + (value || '') + expires + secure + '; path=/' + samesite;\n        }\n\n        /**\n         * Retrieves form key from cookie\n         * @private\n         */\n        function getFormKeyCookie() {\n            var cookie,\n                i,\n                nameEQ = 'form_key=',\n                cookieArr = document.cookie.split(';');\n\n            for (i = 0; i < cookieArr.length; i++) {\n                cookie = cookieArr[i];\n\n                while (cookie.charAt(0) === ' ') {\n                    cookie = cookie.substring(1, cookie.length);\n                }\n\n                if (cookie.indexOf(nameEQ) === 0) {\n                    return cookie.substring(nameEQ.length, cookie.length);\n                }\n            }\n\n            return null;\n        }\n\n        /**\n         * Get form key from UI input hidden\n         * @private\n         */\n        function getFormKeyFromUI() {\n            return document.querySelector(inputSelector).value;\n        }\n\n        /**\n         * Generate form key string\n         * @private\n         */\n        function generateFormKeyString() {\n            var result = '',\n                length = 16,\n                chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';\n\n            while (length--) {\n                result += chars[Math.round(Math.random() * (chars.length - 1))];\n            }\n\n            return result;\n        }\n\n        /**\n         * Init form_key inputs with value\n         * @private\n         */\n        function initFormKey() {\n            formKey = getFormKeyCookie();\n\n            if (settings && settings.isPaginationCacheEnabled && !formKey) {\n                formKey = getFormKeyFromUI();\n                setFormKeyCookie(formKey);\n            }\n\n            if (!formKey) {\n                formKey = generateFormKeyString();\n                setFormKeyCookie(formKey);\n            }\n            inputElements = document.querySelectorAll(inputSelector);\n\n            if (inputElements.length) {\n                Array.prototype.forEach.call(inputElements, function (element) {\n                    element.setAttribute('value', formKey);\n                });\n            }\n        }\n\n        initFormKey();\n    };\n});\n","Magento_PageCache/js/page-cache.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'domReady',\n    'consoleLogger',\n    'Magento_PageCache/js/form-key-provider',\n    'jquery-ui-modules/widget',\n    'mage/cookies'\n], function ($, domReady, consoleLogger, formKeyInit) {\n    'use strict';\n\n    /**\n     * Helper. Generate random string\n     * TODO: Merge with mage/utils\n     * @param {String} chars - list of symbols\n     * @param {Number} length - length for need string\n     * @returns {String}\n     */\n    function generateRandomString(chars, length) {\n        var result = '';\n\n        length = length > 0 ? length : 1;\n\n        while (length--) {\n            result += chars[Math.round(Math.random() * (chars.length - 1))];\n        }\n\n        return result;\n    }\n\n    /**\n     * Nodes tree to flat list converter\n     * @returns {Array}\n     */\n    $.fn.comments = function () {\n        var elements = [],\n            contents,\n            elementContents;\n\n        /**\n         * @param {jQuery} element - Comment holder\n         */\n        (function lookup(element) {\n            var iframeHostName;\n\n            // prevent cross origin iframe content reading\n            if ($(element).prop('tagName') === 'IFRAME') {\n                iframeHostName = $('<a>').prop('href', $(element).prop('src'))\n                    .prop('hostname');\n\n                if (window.location.hostname !== iframeHostName) {\n                    return [];\n                }\n            }\n\n            /**\n             * Rewrite jQuery contents().\n             *\n             * @param {jQuery} elem\n             */\n            contents = function (elem) {\n                return $.map(elem, function (el) {\n                    try {\n                        return el.nodeName.toLowerCase() === 'iframe' ?\n                            el.contentDocument || (el.contentWindow ? el.contentWindow.document : []) :\n                            $.merge([], el.childNodes);\n                    } catch (e) {\n                        consoleLogger.error(e);\n\n                        return [];\n                    }\n                });\n            };\n\n            elementContents = contents($(element));\n\n            $.each(elementContents, function (index, el) {\n                switch (el.nodeType) {\n                    case 1: // ELEMENT_NODE\n                        lookup(el);\n                        break;\n\n                    case 8: // COMMENT_NODE\n                        elements.push(el);\n                        break;\n\n                    case 9: // DOCUMENT_NODE\n                        lookup($(el).find('body'));\n                        break;\n                }\n            });\n        })(this);\n\n        return elements;\n    };\n\n    /**\n     * FormKey Widget - this widget is generating from key, saves it to cookie and\n     * @deprecated see Magento/PageCache/view/frontend/web/js/form-key-provider.js\n     */\n    $.widget('mage.formKey', {\n        options: {\n            inputSelector: 'input[name=\"form_key\"]',\n            allowedCharacters: '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',\n            length: 16\n        },\n\n        /**\n         * Creates widget 'mage.formKey'\n         * @private\n         */\n        _create: function () {\n            var formKey = $.mage.cookies.get('form_key'),\n                options = {\n                    secure: window.cookiesConfig ? window.cookiesConfig.secure : false\n                };\n\n            if (!formKey) {\n                formKey = generateRandomString(this.options.allowedCharacters, this.options.length);\n                $.mage.cookies.set('form_key', formKey, options);\n            }\n            $(this.options.inputSelector).val(formKey);\n        }\n    });\n\n    /**\n     * PageCache Widget\n     * Handles additional ajax request for rendering user private content.\n     */\n    $.widget('mage.pageCache', {\n        options: {\n            url: '/',\n            patternPlaceholderOpen: /^ BLOCK (.+) $/,\n            patternPlaceholderClose: /^ \\/BLOCK (.+) $/,\n            versionCookieName: 'private_content_version',\n            handles: []\n        },\n\n        /**\n         * Creates widget 'mage.pageCache'\n         * @private\n         */\n        _create: function () {\n            var placeholders,\n                version = $.mage.cookies.get(this.options.versionCookieName);\n\n            if (!version) {\n                return;\n            }\n            placeholders = this._searchPlaceholders(this.element.comments());\n\n            if (placeholders && placeholders.length) {\n                this._ajax(placeholders, version);\n            }\n        },\n\n        /**\n         * Parse page for placeholders.\n         * @param {Array} elements\n         * @returns {Array}\n         * @private\n         */\n        _searchPlaceholders: function (elements) {\n            var placeholders = [],\n                tmp = {},\n                ii,\n                len,\n                el, matches, name;\n\n            if (!(elements && elements.length)) {\n                return placeholders;\n            }\n\n            for (ii = 0, len = elements.length; ii < len; ii++) {\n                el = elements[ii];\n                matches = this.options.patternPlaceholderOpen.exec(el.nodeValue);\n                name = null;\n\n                if (matches) {\n                    name = matches[1];\n                    tmp[name] = {\n                        name: name,\n                        openElement: el\n                    };\n                } else {\n                    matches = this.options.patternPlaceholderClose.exec(el.nodeValue);\n\n                    if (matches) { //eslint-disable-line max-depth\n                        name = matches[1];\n\n                        if (tmp[name]) { //eslint-disable-line max-depth\n                            tmp[name].closeElement = el;\n                            placeholders.push(tmp[name]);\n                            delete tmp[name];\n                        }\n                    }\n                }\n            }\n\n            return placeholders;\n        },\n\n        /**\n         * Parse for page and replace placeholders\n         * @param {Object} placeholder\n         * @param {Object} html\n         * @protected\n         */\n        _replacePlaceholder: function (placeholder, html) {\n            var startReplacing = false,\n                prevSibling = null,\n                parent, contents, yy, len, element;\n\n            if (!placeholder || !html) {\n                return;\n            }\n\n            parent = $(placeholder.openElement).parent();\n            contents = parent.contents();\n\n            for (yy = 0, len = contents.length; yy < len; yy++) {\n                element = contents[yy];\n\n                if (element == placeholder.openElement) { //eslint-disable-line eqeqeq\n                    startReplacing = true;\n                }\n\n                if (startReplacing) {\n                    $(element).remove();\n                } else if (element.nodeType != 8) { //eslint-disable-line eqeqeq\n                    //due to comment tag doesn't have siblings we try to find it manually\n                    prevSibling = element;\n                }\n\n                if (element == placeholder.closeElement) { //eslint-disable-line eqeqeq\n                    break;\n                }\n            }\n\n            if (prevSibling) {\n                $(prevSibling).after(html);\n            } else {\n                $(parent).prepend(html);\n            }\n\n            // trigger event to use mage-data-init attribute\n            $(parent).trigger('contentUpdated');\n        },\n\n        /**\n         * AJAX helper\n         * @param {Object} placeholders\n         * @param {String} version\n         * @private\n         */\n        _ajax: function (placeholders, version) {\n            var ii,\n                data = {\n                    blocks: [],\n                    handles: this.options.handles,\n                    originalRequest: this.options.originalRequest,\n                    version: version\n                };\n\n            for (ii = 0; ii < placeholders.length; ii++) {\n                data.blocks.push(placeholders[ii].name);\n            }\n            data.blocks = JSON.stringify(data.blocks.sort());\n            data.handles = JSON.stringify(data.handles);\n            data.originalRequest = JSON.stringify(data.originalRequest);\n            $.ajax({\n                url: this.options.url,\n                data: data,\n                type: 'GET',\n                cache: true,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * Response handler\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var placeholder, i;\n\n                    for (i = 0; i < placeholders.length; i++) {\n                        placeholder = placeholders[i];\n\n                        if (response.hasOwnProperty(placeholder.name)) {\n                            this._replacePlaceholder(placeholder, response[placeholder.name]);\n                        }\n                    }\n                }\n            });\n        }\n    });\n\n    domReady(function () {\n        formKeyInit();\n    });\n\n    return {\n        'pageCache': $.mage.pageCache,\n        'formKey': $.mage.formKey\n    };\n});\n","Magento_Swatches/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'mage/smart-keyboard-handler',\n    'mage/translate',\n    'priceUtils',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery',\n    'mage/validation/validation'\n], function ($, _, mageTemplate, keyboardHandler, $t, priceUtils) {\n    'use strict';\n\n    /**\n     * Extend form validation to support swatch accessibility\n     */\n    $.widget('mage.validation', $.mage.validation, {\n        /**\n         * Handle form with swatches validation. Focus on first invalid swatch block.\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} validation\n         */\n        listenFormValidateHandler: function (event, validation) {\n            var swatchWrapper, firstActive, swatches, swatch, successList, errorList, firstSwatch;\n\n            this._superApply(arguments);\n\n            swatchWrapper = '.swatch-attribute-options';\n            swatches = $(event.target).find(swatchWrapper);\n\n            if (!swatches.length) {\n                return;\n            }\n\n            swatch = '.swatch-attribute';\n            firstActive = $(validation.errorList[0].element || []);\n            successList = validation.successList;\n            errorList = validation.errorList;\n            firstSwatch = $(firstActive).parent(swatch).find(swatchWrapper);\n\n            keyboardHandler.focus(swatches);\n\n            $.each(successList, function (index, item) {\n                $(item).parent(swatch).find(swatchWrapper).attr('aria-invalid', false);\n            });\n\n            $.each(errorList, function (index, item) {\n                $(item.element).parent(swatch).find(swatchWrapper).attr('aria-invalid', true);\n            });\n\n            if (firstSwatch.length) {\n                $(firstSwatch).trigger('focus');\n            }\n        }\n    });\n\n    /**\n     * Render tooltips by attributes (only to up).\n     * Required element attributes:\n     *  - data-option-type (integer, 0-3)\n     *  - data-option-label (string)\n     *  - data-option-tooltip-thumb\n     *  - data-option-tooltip-value\n     *  - data-thumb-width\n     *  - data-thumb-height\n     */\n    $.widget('mage.SwatchRendererTooltip', {\n        options: {\n            delay: 200,                             //how much ms before tooltip to show\n            tooltipClass: 'swatch-option-tooltip'  //configurable, but remember about css\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            var $widget = this,\n                $this = this.element,\n                $element = $('.' + $widget.options.tooltipClass),\n                timer,\n                type = parseInt($this.data('option-type'), 10),\n                label = $this.data('option-label'),\n                thumb = $this.data('option-tooltip-thumb'),\n                value = $this.data('option-tooltip-value'),\n                width = $this.data('thumb-width'),\n                height = $this.data('thumb-height'),\n                $image,\n                $title,\n                $corner;\n\n            if (!$element.length) {\n                $element = $('<div class=\"' +\n                    $widget.options.tooltipClass +\n                    '\"><div class=\"image\"></div><div class=\"title\"></div><div class=\"corner\"></div></div>'\n                );\n                $('body').append($element);\n            }\n\n            $image = $element.find('.image');\n            $title = $element.find('.title');\n            $corner = $element.find('.corner');\n\n            $this.on('mouseenter', function () {\n                if (!$this.hasClass('disabled')) {\n                    timer = setTimeout(\n                        function () {\n                            var leftOpt = null,\n                                leftCorner = 0,\n                                left,\n                                $window;\n\n                            if (type === 2) {\n                                // Image\n                                $image.css({\n                                    'background': 'url(\"' + thumb + '\") no-repeat center', //Background case\n                                    'background-size': 'initial',\n                                    'width': width + 'px',\n                                    'height': height + 'px'\n                                });\n                                $image.show();\n                            } else if (type === 1) {\n                                // Color\n                                $image.css({\n                                    background: value\n                                });\n                                $image.show();\n                            } else if (type === 0 || type === 3) {\n                                // Default\n                                $image.hide();\n                            }\n\n                            $title.text(label);\n\n                            leftOpt = $this.offset().left;\n                            left = leftOpt + $this.width() / 2 - $element.width() / 2;\n                            $window = $(window);\n\n                            // the numbers (5 and 5) is magick constants for offset from left or right page\n                            if (left < 0) {\n                                left = 5;\n                            } else if (left + $element.width() > $window.width()) {\n                                left = $window.width() - $element.width() - 5;\n                            }\n\n                            // the numbers (6,  3 and 18) is magick constants for offset tooltip\n                            leftCorner = 0;\n\n                            if ($element.width() < $this.width()) {\n                                leftCorner = $element.width() / 2 - 3;\n                            } else {\n                                leftCorner = (leftOpt > left ? leftOpt - left : left - leftOpt) + $this.width() / 2 - 6;\n                            }\n\n                            $corner.css({\n                                left: leftCorner\n                            });\n                            $element.css({\n                                left: left,\n                                top: $this.offset().top - $element.height() - $corner.height() - 18\n                            }).show();\n                        },\n                        $widget.options.delay\n                    );\n                }\n            });\n\n            $this.on('mouseleave', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $(document).on('tap', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $this.on('tap', function (event) {\n                event.stopPropagation();\n            });\n        }\n    });\n\n    /**\n     * Render swatch controls with options and use tooltips.\n     * Required two json:\n     *  - jsonConfig (magento's option config)\n     *  - jsonSwatchConfig (swatch's option config)\n     *\n     *  Tuning:\n     *  - numberToShow (show \"more\" button if options are more)\n     *  - onlySwatches (hide selectboxes)\n     *  - moreButtonText (text for \"more\" button)\n     *  - selectorProduct (selector for product container)\n     *  - selectorProductPrice (selector for change price)\n     */\n    $.widget('mage.SwatchRenderer', {\n        options: {\n            classes: {\n                attributeClass: 'swatch-attribute',\n                attributeLabelClass: 'swatch-attribute-label',\n                attributeSelectedOptionLabelClass: 'swatch-attribute-selected-option',\n                attributeOptionsWrapper: 'swatch-attribute-options',\n                attributeInput: 'swatch-input',\n                optionClass: 'swatch-option',\n                selectClass: 'swatch-select',\n                moreButton: 'swatch-more',\n                loader: 'swatch-option-loading'\n            },\n            // option's json config\n            jsonConfig: {},\n\n            // swatch's json config\n            jsonSwatchConfig: {},\n\n            // selector of parental block of prices and swatches (need to know where to seek for price block)\n            selectorProduct: '.product-info-main',\n\n            // selector of price wrapper (need to know where set price)\n            selectorProductPrice: '[data-role=priceBox]',\n\n            //selector of product images gallery wrapper\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n\n            // selector of category product tile wrapper\n            selectorProductTile: '.product-item',\n\n            // number of controls to show (false or zero = show all)\n            numberToShow: false,\n\n            // show only swatch controls\n            onlySwatches: false,\n\n            // enable label for control\n            enableControlLabel: true,\n\n            // control label id\n            controlLabelId: '',\n\n            // text for more button\n            moreButtonText: $t('More'),\n\n            // Callback url for media\n            mediaCallback: '',\n\n            // Local media cache\n            mediaCache: {},\n\n            // Cache for BaseProduct images. Needed when option unset\n            mediaGalleryInitial: [{}],\n\n            // Use ajax to get image data\n            useAjax: false,\n\n            /**\n             * Defines the mechanism of how images of a gallery should be\n             * updated when user switches between configurations of a product.\n             *\n             * As for now value of this option can be either 'replace' or 'prepend'.\n             *\n             * @type {String}\n             */\n            gallerySwitchStrategy: 'replace',\n\n            // whether swatches are rendered in product list or on product page\n            inProductList: false,\n\n            // sly-old-price block selector\n            slyOldPriceSelector: '.sly-old-price',\n\n            // tier prise selectors start\n            tierPriceTemplateSelector: '#tier-prices-template',\n            tierPriceBlockSelector: '[data-role=\"tier-price-block\"]',\n            tierPriceTemplate: '',\n            // tier prise selectors end\n\n            // A price label selector\n            normalPriceLabelSelector: '.normal-price .price-label',\n            qtyInfo: '#qty'\n        },\n\n        /**\n         * Get chosen product\n         *\n         * @returns int|null\n         */\n        getProduct: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) ? products[0] : null;\n        },\n\n        /**\n         * Get chosen product id\n         *\n         * @returns int|null\n         */\n        getProductId: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) && products.length === 1 ? products[0] : null;\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            // Don't render the same set of swatches twice\n            if ($(this.element).attr('data-rendered')) {\n                return;\n            }\n\n            $(this.element).attr('data-rendered', true);\n\n            if (_.isEmpty(this.options.jsonConfig.images)) {\n                this.options.useAjax = true;\n                // creates debounced variant of _LoadProductMedia()\n                // to use it in events handlers instead of _LoadProductMedia()\n                this._debouncedLoadProductMedia = _.debounce(this._LoadProductMedia.bind(this), 500);\n            }\n\n            this.options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();\n\n            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {\n                // store unsorted attributes\n                this.options.jsonConfig.mappedAttributes = _.clone(this.options.jsonConfig.attributes);\n                this._sortAttributes();\n                this._RenderControls();\n                this._setPreSelectedGallery();\n                $(this.element).trigger('swatch.initialized');\n            } else {\n                console.log('SwatchRenderer: No input data received');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _sortAttributes: function () {\n            this.options.jsonConfig.attributes = _.sortBy(this.options.jsonConfig.attributes, function (attribute) {\n                return parseInt(attribute.position, 10);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            var options = this.options,\n                gallery = $('[data-gallery-role=gallery-placeholder]', '.column.main'),\n                productData = this._determineProductData(),\n                $main = productData.isInProductView ?\n                    this.element.parents('.column.main') :\n                    this.element.parents('.product-item-info');\n\n            if (productData.isInProductView) {\n                gallery.data('gallery') ?\n                    this._onGalleryLoaded(gallery) :\n                    gallery.on('gallery:loaded', this._onGalleryLoaded.bind(this, gallery));\n            } else {\n                options.mediaGalleryInitial = [{\n                    'img': $main.find('.product-image-photo').attr('src')\n                }];\n            }\n\n            this.productForm = this.element.parents(this.options.selectorProductTile).find('form:first');\n            this.inProductList = this.productForm.length > 0;\n            $(this.options.qtyInfo).on('input', this._onQtyChanged.bind(this));\n        },\n\n        /**\n         * Determine product id and related data\n         *\n         * @returns {{productId: *, isInProductView: bool}}\n         * @private\n         */\n        _determineProductData: function () {\n            // Check if product is in a list of products.\n            var productId,\n                isInProductView = false;\n\n            productId = this.element.parents('.product-item-details')\n                .find('.price-box.price-final_price').attr('data-product-id');\n\n            if (!productId) {\n                // Check individual product.\n                productId = $('[name=product]').val();\n                isInProductView = productId > 0;\n            }\n\n            return {\n                productId: productId,\n                isInProductView: isInProductView\n            };\n        },\n\n        /**\n         * Render controls\n         *\n         * @private\n         */\n        _RenderControls: function () {\n            var $widget = this,\n                container = this.element,\n                classes = this.options.classes,\n                chooseText = this.options.jsonConfig.chooseText,\n                showTooltip = this.options.showTooltip;\n\n            $widget.optionsMap = {};\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                var item = this,\n                    controlLabelId = 'option-label-' + item.code + '-' + item.id,\n                    options = $widget._RenderSwatchOptions(item, controlLabelId),\n                    select = $widget._RenderSwatchSelect(item, chooseText),\n                    input = $widget._RenderFormInput(item),\n                    listLabel = '',\n                    label = '';\n\n                // Show only swatch controls\n                if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {\n                    return;\n                }\n\n                if ($widget.options.enableControlLabel) {\n                    label +=\n                        '<span id=\"' + controlLabelId + '\" class=\"' + classes.attributeLabelClass + '\">' +\n                        $('<i></i>').text(item.label).html() +\n                        '</span>' +\n                        '<span class=\"' + classes.attributeSelectedOptionLabelClass + '\"></span>';\n                }\n\n                if ($widget.inProductList) {\n                    $widget.productForm.append(input);\n                    input = '';\n                    listLabel = 'aria-label=\"' + $('<i></i>').text(item.label).html() + '\"';\n                } else {\n                    listLabel = 'aria-labelledby=\"' + controlLabelId + '\"';\n                }\n\n                // Create new control\n                container.append(\n                    '<div class=\"' + classes.attributeClass + ' ' + item.code + '\" ' +\n                         'data-attribute-code=\"' + item.code + '\" ' +\n                         'data-attribute-id=\"' + item.id + '\">' +\n                        label +\n                        '<div aria-activedescendant=\"\" ' +\n                             'tabindex=\"0\" ' +\n                             'aria-invalid=\"false\" ' +\n                             'aria-required=\"true\" ' +\n                             'role=\"listbox\" ' + listLabel +\n                             'class=\"' + classes.attributeOptionsWrapper + ' clearfix\">' +\n                            options + select +\n                        '</div>' + input +\n                    '</div>'\n                );\n\n                $widget.optionsMap[item.id] = {};\n\n                // Aggregate options array to hash (key => value)\n                $.each(item.options, function () {\n                    if (this.products.length > 0) {\n                        let salableProducts = this.products;\n\n                        if ($widget.options.jsonConfig.canDisplayShowOutOfStockStatus) {\n                            salableProducts = $widget.options.jsonConfig.salable[item.id][this.id];\n                        }\n                        $widget.optionsMap[item.id][this.id] = {\n                            price: parseInt(\n                                $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,\n                                10\n                            ),\n                            products: salableProducts\n                        };\n                    }\n                });\n            });\n\n            if (showTooltip === 1) {\n                // Connect Tooltip\n                container\n                    .find('[data-option-type=\"1\"], [data-option-type=\"2\"],' +\n                        ' [data-option-type=\"0\"], [data-option-type=\"3\"]')\n                    .SwatchRendererTooltip();\n            }\n\n            // Hide all elements below more button\n            $('.' + classes.moreButton).nextAll().hide();\n\n            // Handle events like click or change\n            $widget._EventListener();\n\n            // Rewind options\n            $widget._Rewind(container);\n\n            //Emulate click on all swatches from Request\n            $widget._EmulateSelected($.parseQuery());\n            $widget._EmulateSelected($widget._getSelectedAttributes());\n        },\n\n        disableSwatchForOutOfStockProducts: function () {\n            let $widget = this, container = this.element;\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                let item = this;\n\n                if ($widget.options.jsonConfig.canDisplayShowOutOfStockStatus) {\n                    let salableProducts = $widget.options.jsonConfig.salable[item.id],\n                        swatchOptions = $(container).find(`[data-attribute-id='${item.id}']`).find('.swatch-option');\n\n                    swatchOptions.each(function (key, value) {\n                        let optionId = $(value).data('option-id');\n\n                        if (!salableProducts.hasOwnProperty(optionId)) {\n                            $(value).attr('disabled', true).addClass('disabled');\n                        }\n                    });\n                }\n            });\n        },\n\n        /**\n         * Render swatch options by part of config\n         *\n         * @param {Object} config\n         * @param {String} controlId\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchOptions: function (config, controlId) {\n            var optionConfig = this.options.jsonSwatchConfig[config.id],\n                optionClass = this.options.classes.optionClass,\n                sizeConfig = this.options.jsonSwatchImageSizeConfig,\n                moreLimit = parseInt(this.options.numberToShow, 10),\n                moreClass = this.options.classes.moreButton,\n                moreText = this.options.moreButtonText,\n                countAttributes = 0,\n                html = '';\n\n            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            $.each(config.options, function (index) {\n                var id,\n                    type,\n                    value,\n                    thumb,\n                    label,\n                    width,\n                    height,\n                    attr,\n                    swatchImageWidth,\n                    swatchImageHeight;\n\n                if (!optionConfig.hasOwnProperty(this.id)) {\n                    return '';\n                }\n\n                // Add more button\n                if (moreLimit === countAttributes++) {\n                    html += '<a href=\"#\" class=\"' + moreClass + '\"><span>' + moreText + '</span></a>';\n                }\n\n                id = this.id;\n                type = parseInt(optionConfig[id].type, 10);\n                value = optionConfig[id].hasOwnProperty('value') ?\n                    $('<i></i>').text(optionConfig[id].value).html() : '';\n                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';\n                width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;\n                height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;\n                label = this.label ? $('<i></i>').text(this.label).html() : '';\n                attr =\n                    ' id=\"' + controlId + '-item-' + id + '\"' +\n                    ' index=\"' + index + '\"' +\n                    ' aria-checked=\"false\"' +\n                    ' aria-describedby=\"' + controlId + '\"' +\n                    ' tabindex=\"0\"' +\n                    ' data-option-type=\"' + type + '\"' +\n                    ' data-option-id=\"' + id + '\"' +\n                    ' data-option-label=\"' + label + '\"' +\n                    ' aria-label=\"' + label + '\"' +\n                    ' role=\"option\"' +\n                    ' data-thumb-width=\"' + width + '\"' +\n                    ' data-thumb-height=\"' + height + '\"';\n\n                attr += thumb !== '' ? ' data-option-tooltip-thumb=\"' + thumb + '\"' : '';\n                attr += value !== '' ? ' data-option-tooltip-value=\"' + value + '\"' : '';\n\n                swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;\n                swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                if (type === 0) {\n                    // Text\n                    html += '<div class=\"' + optionClass + ' text\" ' + attr + '>' + (value ? value : label) +\n                        '</div>';\n                } else if (type === 1) {\n                    // Color\n                    html += '<div class=\"' + optionClass + ' color\" ' + attr +\n                        ' style=\"background: ' + value +\n                        ' no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 2) {\n                    // Image\n                    html += '<div class=\"' + optionClass + ' image\" ' + attr +\n                        ' style=\"background: url(' + value + ') no-repeat center; background-size: initial;width:' +\n                        swatchImageWidth + 'px; height:' + swatchImageHeight + 'px\">' + '' +\n                        '</div>';\n                } else if (type === 3) {\n                    // Clear\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '></div>';\n                } else {\n                    // Default\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '>' + label + '</div>';\n                }\n            });\n\n            return html;\n        },\n\n        /**\n         * Render select by part of config\n         *\n         * @param {Object} config\n         * @param {String} chooseText\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchSelect: function (config, chooseText) {\n            var html;\n\n            if (this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            html =\n                '<select class=\"' + this.options.classes.selectClass + ' ' + config.code + '\">' +\n                '<option value=\"0\" data-option-id=\"0\">' + chooseText + '</option>';\n\n            $.each(config.options, function () {\n                var label = this.label,\n                    attr = ' value=\"' + this.id + '\" data-option-id=\"' + this.id + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                html += '<option ' + attr + '>' + label + '</option>';\n            });\n\n            html += '</select>';\n\n            return html;\n        },\n\n        /**\n         * Input for submit form.\n         * This control shouldn't have \"type=hidden\", \"display: none\" for validation work :(\n         *\n         * @param {Object} config\n         * @private\n         */\n        _RenderFormInput: function (config) {\n            return '<input class=\"' + this.options.classes.attributeInput + ' super-attribute-select\" ' +\n                'name=\"super_attribute[' + config.id + ']\" ' +\n                'type=\"text\" ' +\n                'value=\"\" ' +\n                'data-selector=\"super_attribute[' + config.id + ']\" ' +\n                'data-validate=\"{required: true}\" ' +\n                'aria-required=\"true\" ' +\n                'aria-invalid=\"false\">';\n        },\n\n        /**\n         * Event listener\n         *\n         * @private\n         */\n        _EventListener: function () {\n            var $widget = this,\n                options = this.options.classes,\n                target;\n\n            $widget.element.on('click', '.' + options.optionClass, function () {\n                return $widget._OnClick($(this), $widget);\n            });\n\n            $widget.element.on('change', '.' + options.selectClass, function () {\n                return $widget._OnChange($(this), $widget);\n            });\n\n            $widget.element.on('click', '.' + options.moreButton, function (e) {\n                e.preventDefault();\n\n                return $widget._OnMoreClick($(this));\n            });\n\n            $widget.element.on('keydown', function (e) {\n                if (e.which === 13) {\n                    target = $(e.target);\n\n                    if (target.is('.' + options.optionClass)) {\n                        return $widget._OnClick(target, $widget);\n                    } else if (target.is('.' + options.selectClass)) {\n                        return $widget._OnChange(target, $widget);\n                    } else if (target.is('.' + options.moreButton)) {\n                        e.preventDefault();\n\n                        return $widget._OnMoreClick(target);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Load media gallery using ajax or json config.\n         *\n         * @private\n         */\n        _loadMedia: function () {\n            var $main = this.inProductList ?\n                    this.element.parents('.product-item-info') :\n                    this.element.parents('.column.main'),\n                images;\n\n            if (this.options.useAjax) {\n                this._debouncedLoadProductMedia();\n            }  else {\n                images = this.options.jsonConfig.images[this.getProduct()];\n\n                if (!images) {\n                    images = this.options.mediaGalleryInitial;\n                }\n                this.updateBaseImage(this._sortImages(images), $main, !this.inProductList);\n            }\n        },\n\n        /**\n         * Sorting images array\n         *\n         * @private\n         */\n        _sortImages: function (images) {\n            return _.sortBy(images, function (image) {\n                return parseInt(image.position, 10);\n            });\n        },\n\n        /**\n         * Event for swatch options\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnClick: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                $wrapper = $this.parents('.' + $widget.options.classes.attributeOptionsWrapper),\n                $label = $parent.find('.' + $widget.options.classes.attributeSelectedOptionLabelClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput),\n                checkAdditionalData = JSON.parse(this.options.jsonSwatchConfig[attributeId]['additional_data']),\n                $priceBox = $widget.element.parents($widget.options.selectorProduct)\n                    .find(this.options.selectorProductPrice);\n\n            if ($widget.inProductList) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.hasClass('disabled')) {\n                return;\n            }\n\n            if ($this.hasClass('selected')) {\n                $parent.removeAttr('data-option-selected').find('.selected').removeClass('selected');\n                $input.val('');\n                $label.text('');\n                $this.attr('aria-checked', false);\n            } else {\n                $parent.attr('data-option-selected', $this.data('option-id')).find('.selected').removeClass('selected');\n                $label.text($this.data('option-label'));\n                $input.val($this.data('option-id'));\n                $input.attr('data-attr-name', this._getAttributeCodeById(attributeId));\n                $this.addClass('selected');\n                $widget._toggleCheckedAttributes($this, $wrapper);\n            }\n\n            $widget._Rebuild();\n\n            if ($priceBox.is(':data(mage-priceBox)')) {\n                $widget._UpdatePrice();\n            }\n\n            $(document).trigger('updateMsrpPriceBlock',\n                [\n                    this._getSelectedOptionPriceIndex(),\n                    $widget.options.jsonConfig.optionPrices,\n                    $priceBox\n                ]);\n\n            if (parseInt(checkAdditionalData['update_product_preview_image'], 10) === 1) {\n                $widget._loadMedia();\n            }\n\n            $input.trigger('change');\n        },\n\n        /**\n         * Get selected option price index\n         *\n         * @return {String|undefined}\n         * @private\n         */\n        _getSelectedOptionPriceIndex: function () {\n            var allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (_.isEmpty(allowedProduct)) {\n                return undefined;\n            }\n\n            return allowedProduct;\n        },\n\n        /**\n         * Get human readable attribute code (eg. size, color) by it ID from configuration\n         *\n         * @param {Number} attributeId\n         * @returns {*}\n         * @private\n         */\n        _getAttributeCodeById: function (attributeId) {\n            var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n            return attribute ? attribute.code : attributeId;\n        },\n\n        /**\n         * Toggle accessibility attributes\n         *\n         * @param {Object} $this\n         * @param {Object} $wrapper\n         * @private\n         */\n        _toggleCheckedAttributes: function ($this, $wrapper) {\n            $wrapper.attr('aria-activedescendant', $this.attr('id'))\n                .find('.' + this.options.classes.optionClass).attr('aria-checked', false);\n            $this.attr('aria-checked', true);\n        },\n\n        /**\n         * Event for select\n         *\n         * @param {Object} $this\n         * @param {Object} $widget\n         * @private\n         */\n        _OnChange: function ($this, $widget) {\n            var $parent = $this.parents('.' + $widget.options.classes.attributeClass),\n                attributeId = $parent.data('attribute-id'),\n                $input = $parent.find('.' + $widget.options.classes.attributeInput);\n\n            if ($widget.productForm.length > 0) {\n                $input = $widget.productForm.find(\n                    '.' + $widget.options.classes.attributeInput + '[name=\"super_attribute[' + attributeId + ']\"]'\n                );\n            }\n\n            if ($this.val() > 0) {\n                $parent.attr('data-option-selected', $this.val());\n                $input.val($this.val());\n            } else {\n                $parent.removeAttr('data-option-selected');\n                $input.val('');\n            }\n\n            $widget._Rebuild();\n            $widget._UpdatePrice();\n            $widget._loadMedia();\n            $input.trigger('change');\n        },\n\n        /**\n         * Event for more switcher\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _OnMoreClick: function ($this) {\n            $this.nextAll().show();\n            $this.trigger('blur').remove();\n        },\n\n        /**\n         * Rewind options for controls\n         *\n         * @private\n         */\n        _Rewind: function (controls) {\n            controls.find('div[data-option-id], option[data-option-id]')\n                .removeClass('disabled')\n                .prop('disabled', false);\n            controls.find('div[data-option-empty], option[data-option-empty]')\n                .attr('disabled', true)\n                .addClass('disabled')\n                .attr('tabindex', '-1');\n            this.disableSwatchForOutOfStockProducts();\n        },\n\n        /**\n         * Rebuild container\n         *\n         * @private\n         */\n        _Rebuild: function () {\n            var $widget = this,\n                controls = $widget.element.find('.' + $widget.options.classes.attributeClass + '[data-attribute-id]'),\n                selected = controls.filter('[data-option-selected]');\n\n            // Enable all options\n            $widget._Rewind(controls);\n\n            // done if nothing selected\n            if (selected.length <= 0) {\n                return;\n            }\n\n            // Disable not available options\n            controls.each(function () {\n                var $this = $(this),\n                    id = $this.data('attribute-id'),\n                    products = $widget._CalcProducts(id);\n\n                if (selected.length === 1 && selected.first().data('attribute-id') === id) {\n                    return;\n                }\n\n                $this.find('[data-option-id]').each(function () {\n                    var $element = $(this),\n                        option = $element.data('option-id');\n\n                    if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option) ||\n                        $element.hasClass('selected') ||\n                        $element.is(':selected')) {\n                        return;\n                    }\n\n                    if (_.intersection(products, $widget.optionsMap[id][option].products).length <= 0) {\n                        $element.attr('disabled', true).addClass('disabled');\n                    }\n                });\n            });\n        },\n\n        /**\n         * Get selected product list\n         *\n         * @returns {Array}\n         * @private\n         */\n        _CalcProducts: function ($skipAttributeId) {\n            var $widget = this,\n                selectedOptions = '.' + $widget.options.classes.attributeClass + '[data-option-selected]',\n                products = [];\n\n            // Generate intersection of products\n            $widget.element.find(selectedOptions).each(function () {\n                var id = $(this).data('attribute-id'),\n                    option = $(this).attr('data-option-selected');\n\n                if ($skipAttributeId !== undefined && $skipAttributeId === id) {\n                    return;\n                }\n\n                if (!$widget.optionsMap.hasOwnProperty(id) || !$widget.optionsMap[id].hasOwnProperty(option)) {\n                    return;\n                }\n\n                if (products.length === 0) {\n                    products = $widget.optionsMap[id][option].products;\n                } else {\n                    products = _.intersection(products, $widget.optionsMap[id][option].products);\n                }\n            });\n\n            return products;\n        },\n\n        /**\n         * Update total price\n         *\n         * @private\n         */\n        _UpdatePrice: function () {\n            var $widget = this,\n                $product = $widget.element.parents($widget.options.selectorProduct),\n                $productPrice = $product.find(this.options.selectorProductPrice),\n                result = $widget._getNewPrices(),\n                tierPriceHtml,\n                isShow;\n\n            $productPrice.trigger(\n                'updatePrice',\n                {\n                    'prices': $widget._getPrices(result, $productPrice.priceBox('option').prices)\n                }\n            );\n\n            isShow = typeof result != 'undefined' && result.oldPrice.amount !== result.finalPrice.amount;\n\n            $productPrice.find('span:first').toggleClass('special-price', isShow);\n\n            $product.find(this.options.slyOldPriceSelector)[isShow ? 'show' : 'hide']();\n\n            if (typeof result != 'undefined' && result.tierPrices && result.tierPrices.length) {\n                if (this.options.tierPriceTemplate) {\n                    tierPriceHtml = mageTemplate(\n                        this.options.tierPriceTemplate,\n                        {\n                            'tierPrices': result.tierPrices,\n                            '$t': $t,\n                            'currencyFormat': this.options.jsonConfig.currencyFormat,\n                            'priceUtils': priceUtils\n                        }\n                    );\n                    $(this.options.tierPriceBlockSelector).html(tierPriceHtml).show();\n                }\n            } else {\n                $(this.options.tierPriceBlockSelector).hide();\n            }\n\n            $product.find(this.options.normalPriceLabelSelector).hide();\n\n            _.each(this.element.find('.' + this.options.classes.attributeOptionsWrapper), function (attribute) {\n                if ($(attribute).find('.' + this.options.classes.optionClass + '.selected').length === 0) {\n                    if ($(attribute).find('.' + this.options.classes.selectClass).length > 0) {\n                        _.each($(attribute).find('.' + this.options.classes.selectClass), function (dropdown) {\n                            if ($(dropdown).val() === '0') {\n                                $product.find(this.options.normalPriceLabelSelector).show();\n                            }\n                        }.bind(this));\n                    } else {\n                        $product.find(this.options.normalPriceLabelSelector).show();\n                    }\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Get new prices for selected options\n         *\n         * @returns {*}\n         * @private\n         */\n        _getNewPrices: function () {\n            var $widget = this,\n                newPrices = $widget.options.jsonConfig.prices,\n                allowedProduct = this._getAllowedProductWithMinPrice(this._CalcProducts());\n\n            if (!_.isEmpty(allowedProduct)) {\n                newPrices = this.options.jsonConfig.optionPrices[allowedProduct];\n            }\n\n            return newPrices;\n        },\n\n        /**\n         * Get prices\n         *\n         * @param {Object} newPrices\n         * @param {Object} displayPrices\n         * @returns {*}\n         * @private\n         */\n        _getPrices: function (newPrices, displayPrices) {\n            var $widget = this;\n\n            if (_.isEmpty(newPrices)) {\n                newPrices = $widget._getNewPrices();\n            }\n            _.each(displayPrices, function (price, code) {\n\n                if (newPrices[code]) {\n                    displayPrices[code].amount = newPrices[code].amount - displayPrices[code].amount;\n                }\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Get product with minimum price from selected options.\n         *\n         * @param {Array} allowedProducts\n         * @returns {String}\n         * @private\n         */\n        _getAllowedProductWithMinPrice: function (allowedProducts) {\n            var optionPrices = this.options.jsonConfig.optionPrices,\n                product = {},\n                optionFinalPrice, optionMinPrice;\n\n            _.each(allowedProducts, function (allowedProduct) {\n                optionFinalPrice = parseFloat(optionPrices[allowedProduct].finalPrice.amount);\n\n                if (_.isEmpty(product) || optionFinalPrice < optionMinPrice) {\n                    optionMinPrice = optionFinalPrice;\n                    product = allowedProduct;\n                }\n            }, this);\n\n            return product;\n        },\n\n        /**\n         * Gets all product media and change current to the needed one\n         *\n         * @private\n         */\n        _LoadProductMedia: function () {\n            var $widget = this,\n                $this = $widget.element,\n                productData = this._determineProductData(),\n                mediaCallData,\n                mediaCacheKey,\n\n                /**\n                 * Processes product media data\n                 *\n                 * @param {Object} data\n                 * @returns void\n                 */\n                mediaSuccessCallback = function (data) {\n                    if (!(mediaCacheKey in $widget.options.mediaCache)) {\n                        $widget.options.mediaCache[mediaCacheKey] = data;\n                    }\n                    $widget._ProductMediaCallback($this, data, productData.isInProductView);\n                    setTimeout(function () {\n                        $widget._DisableProductMediaLoader($this);\n                    }, 300);\n                };\n\n            if (!$widget.options.mediaCallback) {\n                return;\n            }\n\n            mediaCallData = {\n                'product_id': this.getProduct()\n            };\n\n            mediaCacheKey = JSON.stringify(mediaCallData);\n\n            if (mediaCacheKey in $widget.options.mediaCache) {\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                mediaSuccessCallback($widget.options.mediaCache[mediaCacheKey]);\n            } else {\n                mediaCallData.isAjax = true;\n                $widget._XhrKiller();\n                $widget._EnableProductMediaLoader($this);\n                $widget.xhr = $.ajax({\n                    url: $widget.options.mediaCallback,\n                    cache: true,\n                    type: 'GET',\n                    dataType: 'json',\n                    data: mediaCallData,\n                    success: mediaSuccessCallback\n                }).done(function () {\n                    $widget._XhrKiller();\n                });\n            }\n        },\n\n        /**\n         * Enable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _EnableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .addClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .addClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Disable loader\n         *\n         * @param {Object} $this\n         * @private\n         */\n        _DisableProductMediaLoader: function ($this) {\n            var $widget = this;\n\n            if ($('body.catalog-product-view').length > 0) {\n                $this.parents('.column.main').find('.photo.image')\n                    .removeClass($widget.options.classes.loader);\n            } else {\n                //Category View\n                $this.parents('.product-item-info').find('.product-image-photo')\n                    .removeClass($widget.options.classes.loader);\n            }\n        },\n\n        /**\n         * Callback for product media\n         *\n         * @param {Object} $this\n         * @param {String} response\n         * @param {Boolean} isInProductView\n         * @private\n         */\n        _ProductMediaCallback: function ($this, response, isInProductView) {\n            var $main = isInProductView ? $this.parents('.column.main') : $this.parents('.product-item-info'),\n                $widget = this,\n                images = [],\n\n                /**\n                 * Check whether object supported or not\n                 *\n                 * @param {Object} e\n                 * @returns {*|Boolean}\n                 */\n                support = function (e) {\n                    return e.hasOwnProperty('large') && e.hasOwnProperty('medium') && e.hasOwnProperty('small');\n                };\n\n            if (_.size($widget) < 1 || !support(response)) {\n                this.updateBaseImage(this.options.mediaGalleryInitial, $main, isInProductView);\n\n                return;\n            }\n\n            images.push({\n                full: response.large,\n                img: response.medium,\n                thumb: response.small,\n                isMain: true\n            });\n\n            if (response.hasOwnProperty('gallery')) {\n                $.each(response.gallery, function () {\n                    if (!support(this) || response.large === this.large) {\n                        return;\n                    }\n                    images.push({\n                        full: this.large,\n                        img: this.medium,\n                        thumb: this.small\n                    });\n                });\n            }\n\n            this.updateBaseImage(images, $main, isInProductView);\n        },\n\n        /**\n         * Check if images to update are initial and set their type\n         * @param {Array} images\n         */\n        _setImageType: function (images) {\n\n            images.map(function (img) {\n                if (!img.type) {\n                    img.type = 'image';\n                }\n            });\n\n            return images;\n        },\n\n        /**\n         * Update [gallery-placeholder] or [product-image-photo]\n         * @param {Array} images\n         * @param {jQuery} context\n         * @param {Boolean} isInProductView\n         */\n        updateBaseImage: function (images, context, isInProductView) {\n            var justAnImage = images[0],\n                initialImages = this.options.mediaGalleryInitial,\n                imagesToUpdate,\n                gallery = context.find(this.options.mediaGallerySelector).data('gallery'),\n                isInitial;\n\n            if (isInProductView) {\n                if (_.isUndefined(gallery)) {\n                    context.find(this.options.mediaGallerySelector).on('gallery:loaded', function () {\n                        this.updateBaseImage(images, context, isInProductView);\n                    }.bind(this));\n\n                    return;\n                }\n\n                imagesToUpdate = images.length ? this._setImageType($.extend(true, [], images)) : [];\n                isInitial = _.isEqual(\n                    imagesToUpdate.map(({thumb, img, full, type, videoUrl}) => ({thumb, img, full, type, videoUrl})),\n                    initialImages.map(({thumb, img, full, type, videoUrl}) => ({thumb, img, full, type, videoUrl}))\n                );\n\n                if (this.options.gallerySwitchStrategy === 'prepend' && !isInitial) {\n                    imagesToUpdate = imagesToUpdate.concat(initialImages);\n                }\n\n                imagesToUpdate = this._setImageIndex(imagesToUpdate);\n\n                gallery.updateData(imagesToUpdate);\n                this._addFotoramaVideoEvents(isInitial);\n            } else if (justAnImage && justAnImage.img) {\n                context.find('.product-image-photo').attr('src', justAnImage.img);\n            }\n        },\n\n        /**\n         * Add video events\n         *\n         * @param {Boolean} isInitial\n         * @private\n         */\n        _addFotoramaVideoEvents: function (isInitial) {\n            if (_.isUndefined($.mage.AddFotoramaVideoEvents)) {\n                return;\n            }\n\n            if (isInitial) {\n                $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n\n                return;\n            }\n\n            $(this.options.mediaGallerySelector).AddFotoramaVideoEvents({\n                selectedOption: this.getProduct(),\n                dataMergeStrategy: this.options.gallerySwitchStrategy\n            });\n        },\n\n        /**\n         * Set correct indexes for image set.\n         *\n         * @param {Array} images\n         * @private\n         */\n        _setImageIndex: function (images) {\n            var length = images.length,\n                i;\n\n            for (i = 0; length > i; i++) {\n                images[i].i = i + 1;\n            }\n\n            return images;\n        },\n\n        /**\n         * Kill doubled AJAX requests\n         *\n         * @private\n         */\n        _XhrKiller: function () {\n            var $widget = this;\n\n            if ($widget.xhr !== undefined && $widget.xhr !== null) {\n                $widget.xhr.abort();\n                $widget.xhr = null;\n            }\n        },\n\n        /**\n         * Emulate mouse click on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelected: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeCode, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-code=\"' + attributeCode + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Emulate mouse click or selection change on all swatches that should be selected\n         * @param {Object} [selectedAttributes]\n         * @private\n         */\n        _EmulateSelectedByAttributeId: function (selectedAttributes) {\n            $.each(selectedAttributes, $.proxy(function (attributeId, optionId) {\n                var elem = this.element.find('.' + this.options.classes.attributeClass +\n                    '[data-attribute-id=\"' + attributeId + '\"] [data-option-id=\"' + optionId + '\"]'),\n                    parentInput = elem.parent();\n\n                if (elem.hasClass('selected')) {\n                    return;\n                }\n\n                if (parentInput.hasClass(this.options.classes.selectClass)) {\n                    parentInput.val(optionId);\n                    parentInput.trigger('change');\n                } else {\n                    elem.trigger('click');\n                }\n            }, this));\n        },\n\n        /**\n         * Get default options values settings with either URL query parameters\n         * @private\n         */\n        _getSelectedAttributes: function () {\n            var hashIndex = window.location.href.indexOf('#'),\n                selectedAttributes = {},\n                params;\n\n            if (hashIndex !== -1) {\n                params = $.parseQuery(window.location.href.substr(hashIndex + 1));\n\n                selectedAttributes = _.invert(_.mapObject(_.invert(params), function (attributeId) {\n                    var attribute = this.options.jsonConfig.mappedAttributes[attributeId];\n\n                    return attribute ? attribute.code : attributeId;\n                }.bind(this)));\n            }\n\n            return selectedAttributes;\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         *\n         * @param {HTMLElement} element - DOM element associated with a gallery.\n         */\n        _onGalleryLoaded: function (element) {\n            var galleryObject = element.data('gallery');\n\n            this.options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n        },\n\n        /**\n         * Sets mediaCache for cases when jsonConfig contains preSelectedGallery on layered navigation result pages\n         *\n         * @private\n         */\n        _setPreSelectedGallery: function () {\n            var mediaCallData;\n\n            if (this.options.jsonConfig.preSelectedGallery) {\n                mediaCallData = {\n                    'product_id': this.getProduct()\n                };\n\n                this.options.mediaCache[JSON.stringify(mediaCallData)] = this.options.jsonConfig.preSelectedGallery;\n            }\n        },\n\n        /**\n         * Callback for quantity change event.\n         */\n        _onQtyChanged: function () {\n            var $price = this.element.parents(this.options.selectorProduct)\n                .find(this.options.selectorProductPrice);\n\n            $price.trigger(\n                'updatePrice',\n                {\n                    'prices': this._getPrices(this._getNewPrices(), $price.priceBox('option').prices)\n                }\n            );\n        }\n    });\n\n    return $.mage.SwatchRenderer;\n});\n","Magento_Swatches/js/catalog-add-to-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Add selected swatch attributes to redirect url\n     *\n     * @see Magento_Catalog/js/catalog-add-to-cart\n     */\n    $('body').on('catalogCategoryAddToCartRedirect', function (event, data) {\n        $(data.form).find('[name*=\"super\"]').each(function (index, item) {\n            var $item = $(item),\n                attr;\n\n            if ($item.attr('data-attr-name')) {\n                attr = $item.attr('data-attr-name');\n            } else {\n                attr = $item.parent().attr('attribute-code');\n            }\n            data.redirectParameters.push(attr + '=' + $item.val());\n\n        });\n    });\n});\n","Magento_Swatches/js/configurable-customer-data.js":"require([\n    'jquery',\n    'Magento_ConfigurableProduct/js/options-updater'\n], function ($, Updater) {\n    'use strict';\n\n    var selectors = {\n            formSelector: '#product_addtocart_form',\n            swatchSelector: '.swatch-opt'\n        },\n        swatchWidgetName = 'mage-SwatchRenderer',\n        widgetInitEvent = 'swatch.initialized',\n\n    /**\n    * Sets all configurable swatch attribute's selected values\n    */\n    updateSwatchOptions = function () {\n        var swatchWidget = $(selectors.swatchSelector).data(swatchWidgetName);\n\n        if (!swatchWidget || !swatchWidget._EmulateSelectedByAttributeId) {\n            return;\n        }\n        swatchWidget._EmulateSelectedByAttributeId(this.productOptions);\n    },\n    updater = new Updater(widgetInitEvent, updateSwatchOptions);\n\n    updater.listen();\n});\n","Magento_LoginAsCustomerFrontendUi/js/login.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/section-config'\n], function ($, customerData, sectionConfig) {\n\n    'use strict';\n\n    return function (config) {\n        customerData.reload(sectionConfig.getSectionNames()).done(function () {\n            window.location.href = config.redirectUrl;\n        });\n    };\n});\n","Magento_LoginAsCustomerFrontendUi/js/view/loginAsCustomer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'mage/translate'\n], function ($, _, Component, customer) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            isVisible: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var customerData, loggedAsCustomerData;\n\n            this._super();\n\n            customerData = customer.get('customer');\n            loggedAsCustomerData = customer.get('loggedAsCustomer');\n\n            customerData.subscribe(function (data) {\n                this.fullname = data.fullname;\n                this.updateBanner();\n            }.bind(this));\n            loggedAsCustomerData.subscribe(function (data) {\n                this.adminUserId = data.adminUserId;\n                this.websiteName = data.websiteName;\n                this.updateBanner();\n            }.bind(this));\n\n            this.fullname = customerData().fullname;\n            this.adminUserId = loggedAsCustomerData().adminUserId;\n            this.websiteName = loggedAsCustomerData().websiteName;\n\n            this.updateBanner();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe(['isVisible', 'notificationText']);\n\n            return this;\n        },\n\n        /**\n         * Update banner area\n         *\n         * @returns void\n         */\n        updateBanner: function () {\n            if (this.adminUserId !== undefined) {\n                this.isVisible(this.adminUserId);\n            }\n\n            if (this.fullname !== undefined && this.websiteName !== undefined) {\n                this.notificationText($.mage.__('You are connected as <strong>%1</strong> on %2')\n                    .replace('%1', _.escape(this.fullname))\n                    .replace('%2', _.escape(this.websiteName)));\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'mage/translate',\n    'priceUtils',\n    'priceBox',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery',\n    'fotoramaVideoEvents'\n], function ($, _, mageTemplate, $t, priceUtils) {\n    'use strict';\n\n    $.widget('mage.configurable', {\n        options: {\n            superSelector: '.super-attribute-select',\n            selectSimpleProduct: '[name=\"selected_configurable_option\"]',\n\n            /**\n             * @deprecated Not used anymore\n             * @see selectorProductPrice\n             */\n            priceHolderSelector: '.price-box',\n            spConfig: {},\n            state: {},\n            priceFormat: {},\n            optionTemplate: '<%- data.label %>' +\n            '<% if (typeof data.finalPrice.value !== \"undefined\") { %>' +\n            ' <%- data.finalPrice.formatted %>' +\n            '<% } %>',\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n            mediaGalleryInitial: null,\n            slyOldPriceSelector: '.sly-old-price',\n            normalPriceLabelSelector: '.product-info-main .normal-price .price-label',\n\n            /**\n             * Defines the mechanism of how images of a gallery should be\n             * updated when user switches between configurations of a product.\n             *\n             * As for now value of this option can be either 'replace' or 'prepend'.\n             *\n             * @type {String}\n             */\n            gallerySwitchStrategy: 'replace',\n            tierPriceTemplateSelector: '#tier-prices-template',\n            tierPriceBlockSelector: '[data-role=\"tier-price-block\"]',\n            tierPriceTemplate: '',\n            selectorProduct: '.product-info-main',\n            selectorProductPrice: '[data-role=priceBox]',\n            qtyInfo: '#qty'\n        },\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            // Initial setting of various option values\n            this._initializeOptions();\n\n            // Override defaults with URL query parameters and/or inputs values\n            this._overrideDefaults();\n\n            // Change events to check select reloads\n            this._setupChangeEvents();\n\n            // Fill state\n            this._fillState();\n\n            // Setup child and prev/next settings\n            this._setChildSettings();\n\n            // Setup/configure values to inputs\n            this._configureForValues();\n\n            $(this.element).trigger('configurable.initialized');\n            $(this.options.qtyInfo).on('input', this._reloadPrice.bind(this));\n        },\n\n        /**\n         * Initialize tax configuration, initial settings, and options values.\n         * @private\n         */\n        _initializeOptions: function () {\n            var options = this.options,\n                gallery = $(options.mediaGallerySelector),\n                priceBoxOptions = this._getPriceBoxElement().priceBox('option').priceConfig || null;\n\n            if (priceBoxOptions && priceBoxOptions.optionTemplate) {\n                options.optionTemplate = priceBoxOptions.optionTemplate;\n            }\n\n            if (priceBoxOptions && priceBoxOptions.priceFormat) {\n                options.priceFormat = priceBoxOptions.priceFormat;\n            }\n            options.optionTemplate = mageTemplate(options.optionTemplate);\n            options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();\n\n            options.settings = options.spConfig.containerId ?\n                $(options.spConfig.containerId).find(options.superSelector) :\n                this.element.parents(this.options.selectorProduct).find(options.superSelector);\n\n            options.values = options.spConfig.defaultValues || {};\n            options.parentImage = $('[data-role=base-image-container] img').attr('src');\n\n            this.inputSimpleProduct = this.element.find(options.selectSimpleProduct);\n\n            gallery.data('gallery') ?\n                this._onGalleryLoaded(gallery) :\n                gallery.on('gallery:loaded', this._onGalleryLoaded.bind(this, gallery));\n\n        },\n\n        /**\n         * Override default options values settings with either URL query parameters or\n         * initialized inputs values.\n         * @private\n         */\n        _overrideDefaults: function () {\n            var hashIndex = window.location.href.indexOf('#');\n\n            if (hashIndex !== -1) {\n                this._parseQueryParams(window.location.href.substr(hashIndex + 1));\n            }\n\n            if (this.options.spConfig.inputsInitialized) {\n                this._setValuesByAttribute();\n            }\n\n            this._setInitialOptionsLabels();\n        },\n\n        /**\n         * Parse query parameters from a query string and set options values based on the\n         * key value pairs of the parameters.\n         * @param {*} queryString - URL query string containing query parameters.\n         * @private\n         */\n        _parseQueryParams: function (queryString) {\n            var queryParams = $.parseQuery({\n                query: queryString\n            });\n\n            $.each(queryParams, $.proxy(function (key, value) {\n                if (this.options.spConfig.attributes[key] !== undefined &&\n                    _.find(this.options.spConfig.attributes[key].options, function (element) {\n                        return element.id === value;\n                    })) {\n                    this.options.values[key] = value;\n                }\n            }, this));\n        },\n\n        /**\n         * Override default options values with values based on each element's attribute\n         * identifier.\n         * @private\n         */\n        _setValuesByAttribute: function () {\n            this.options.values = {};\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                var attributeId;\n\n                if (element.value) {\n                    attributeId = element.id.replace(/[a-z]*/, '');\n\n                    if (this.options.spConfig.attributes[attributeId] !== undefined &&\n                        _.find(this.options.spConfig.attributes[attributeId].options, function (optionElement) {\n                            return optionElement.id === element.value;\n                        })) {\n                        this.options.values[attributeId] = element.value;\n                    }\n                }\n            }, this));\n        },\n\n        /**\n         * Set additional field with initial label to be used when switching between options with different prices.\n         * @private\n         */\n        _setInitialOptionsLabels: function () {\n            $.each(this.options.spConfig.attributes, $.proxy(function (index, element) {\n                $.each(element.options, $.proxy(function (optIndex, optElement) {\n                    this.options.spConfig.attributes[index].options[optIndex].initialLabel = optElement.label;\n                }, this));\n            }, this));\n        },\n\n        /**\n         * Set up .on('change') events for each option element to configure the option.\n         * @private\n         */\n        _setupChangeEvents: function () {\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                $(element).on('change', this, this._configure);\n            }, this));\n        },\n\n        /**\n         * Iterate through the option settings and set each option's element configuration,\n         * attribute identifier. Set the state based on the attribute identifier.\n         * @private\n         */\n        _fillState: function () {\n            $.each(this.options.settings, $.proxy(function (index, element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.options.spConfig.attributes[attributeId]) {\n                    element.config = this.options.spConfig.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.options.state[attributeId] = false;\n                }\n            }, this));\n        },\n\n        /**\n         * Set each option's child settings, and next/prev option setting. Fill (initialize)\n         * an option's list of selections as needed or disable an option's setting.\n         * @private\n         */\n        _setChildSettings: function () {\n            var childSettings = [],\n                settings = this.options.settings,\n                index = settings.length,\n                option;\n\n            while (index--) {\n                option = settings[index];\n\n                if (index) {\n                    option.disabled = true;\n                } else {\n                    this._fillSelect(option);\n                }\n\n                _.extend(option, {\n                    childSettings: childSettings.slice(),\n                    prevSetting: settings[index - 1],\n                    nextSetting: settings[index + 1]\n                });\n\n                childSettings.push(option);\n            }\n        },\n\n        /**\n         * Setup for all configurable option settings. Set the value of the option and configure\n         * the option, which sets its state, and initializes the option's choices, etc.\n         * @private\n         */\n        _configureForValues: function () {\n            if (this.options.values) {\n                this.options.settings.each($.proxy(function (index, element) {\n                    var attributeId = element.attributeId;\n\n                    element.value = this.options.values[attributeId] || '';\n                    this._configureElement(element);\n                }, this));\n            }\n        },\n\n        /**\n         * Event handler for configuring an option.\n         * @private\n         * @param {Object} event - Event triggered to configure an option.\n         */\n        _configure: function (event) {\n            event.data._configureElement(this);\n        },\n\n        /**\n         * Configure an option, initializing it's state and enabling related options, which\n         * populates the related option's selection and resets child option selections.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _configureElement: function (element) {\n            this.simpleProduct = this._getSimpleProductId(element);\n\n            if (element.value && element.config) {\n                this.options.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this._fillSelect(element.nextSetting);\n                    this._resetChildren(element.nextSetting);\n                } else {\n                    if (!!document.documentMode) { //eslint-disable-line\n                        this.inputSimpleProduct.val(element.options[element.selectedIndex].config.allowedProducts[0]);\n                    } else {\n                        this.inputSimpleProduct.val(element.selectedOptions[0].config.allowedProducts[0]);\n                    }\n                }\n            } else {\n                this._resetChildren(element);\n            }\n\n            this._reloadPrice();\n            if (element.config) {\n                this._displayRegularPriceBlock(this.simpleProduct);\n                this._displayTierPriceBlock(this.simpleProduct);\n                this._displayNormalPriceLabel();\n            }\n            this._changeProductImage();\n        },\n\n        /**\n         * Change displayed product image according to chosen options of configurable product\n         *\n         * @private\n         */\n        _changeProductImage: function () {\n            var images,\n                initialImages = this.options.mediaGalleryInitial,\n                gallery = $(this.options.mediaGallerySelector).data('gallery');\n\n            if (_.isUndefined(gallery)) {\n                $(this.options.mediaGallerySelector).on('gallery:loaded', function () {\n                    this._changeProductImage();\n                }.bind(this));\n\n                return;\n            }\n\n            images = this.options.spConfig.images[this.simpleProduct];\n\n            if (images) {\n                images = this._sortImages(images);\n\n                if (this.options.gallerySwitchStrategy === 'prepend') {\n                    images = images.concat(initialImages);\n                }\n\n                images = $.extend(true, [], images);\n                images = this._setImageIndex(images);\n\n                gallery.updateData(images);\n                this._addFotoramaVideoEvents(false);\n            } else {\n                gallery.updateData(initialImages);\n                this._addFotoramaVideoEvents(true);\n            }\n        },\n\n        /**\n         * Add video events\n         *\n         * @param {Boolean} isInitial\n         * @private\n         */\n        _addFotoramaVideoEvents: function (isInitial) {\n            if (_.isUndefined($.mage.AddFotoramaVideoEvents)) {\n                return;\n            }\n\n            if (isInitial) {\n                $(this.options.mediaGallerySelector).AddFotoramaVideoEvents();\n\n                return;\n            }\n\n            $(this.options.mediaGallerySelector).AddFotoramaVideoEvents({\n                selectedOption: this.simpleProduct,\n                dataMergeStrategy: this.options.gallerySwitchStrategy\n            });\n        },\n\n        /**\n         * Sorting images array\n         *\n         * @private\n         */\n        _sortImages: function (images) {\n            return _.sortBy(images, function (image) {\n                return parseInt(image.position, 10);\n            });\n        },\n\n        /**\n         * Set correct indexes for image set.\n         *\n         * @param {Array} images\n         * @private\n         */\n        _setImageIndex: function (images) {\n            var length = images.length,\n                i;\n\n            for (i = 0; length > i; i++) {\n                images[i].i = i + 1;\n            }\n\n            return images;\n        },\n\n        /**\n         * For a given option element, reset all of its selectable options. Clear any selected\n         * index, disable the option choice, and reset the option's state if necessary.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _resetChildren: function (element) {\n            if (element.childSettings) {\n                _.each(element.childSettings, function (set) {\n                    set.selectedIndex = 0;\n                    set.disabled = true;\n                });\n\n                if (element.config) {\n                    this.options.state[element.config.id] = false;\n                }\n            }\n        },\n\n        /**\n         * Populates an option's selectable choices.\n         * @private\n         * @param {*} element - Element associated with a configurable option.\n         */\n        _fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this._getAttributeOptions(attributeId),\n                prevConfig,\n                index = 1,\n                allowedProducts,\n                allowedProductsByOption,\n                allowedProductsAll,\n                i,\n                j,\n                finalPrice = parseFloat(this.options.spConfig.prices.finalPrice.amount),\n                optionFinalPrice,\n                optionPriceDiff,\n                optionPrices = this.options.spConfig.optionPrices,\n                allowedOptions = [],\n                indexKey,\n                allowedProductMinPrice,\n                allowedProductsAllMinPrice,\n                canDisplayOutOfStockProducts = false,\n                filteredSalableProducts;\n\n            this._clearSelect(element);\n            if (element.options) {\n                element.options[0] = new Option('', '');\n                element.options[0].innerHTML = this.options.spConfig.chooseText;\n            }\n            prevConfig = false;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (indexKey in this.options.spConfig.index) {\n                    /* eslint-disable max-depth */\n                    if (this.options.spConfig.index.hasOwnProperty(indexKey)) {\n                        allowedOptions = allowedOptions.concat(_.values(this.options.spConfig.index[indexKey]));\n                    }\n                }\n\n                if (prevConfig) {\n                    allowedProductsByOption = {};\n                    allowedProductsAll = [];\n\n                    for (i = 0; i < options.length; i++) {\n                        /* eslint-disable max-depth */\n                        for (j = 0; j < options[i].products.length; j++) {\n                            // prevConfig.config can be undefined\n                            if (prevConfig.config &&\n                                prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1) {\n                                if (!allowedProductsByOption[i]) {\n                                    allowedProductsByOption[i] = [];\n                                }\n                                allowedProductsByOption[i].push(options[i].products[j]);\n                                allowedProductsAll.push(options[i].products[j]);\n                            }\n                        }\n                    }\n\n                    if (typeof allowedProductsAll[0] !== 'undefined' &&\n                        typeof optionPrices[allowedProductsAll[0]] !== 'undefined') {\n                        allowedProductsAllMinPrice = this._getAllowedProductWithMinPrice(allowedProductsAll);\n                        finalPrice = parseFloat(optionPrices[allowedProductsAllMinPrice].finalPrice.amount);\n                    }\n                }\n\n                for (i = 0; i < options.length; i++) {\n                    if (prevConfig && typeof allowedProductsByOption[i] === 'undefined') {\n                        continue; //jscs:ignore disallowKeywords\n                    }\n\n                    allowedProducts = prevConfig ? allowedProductsByOption[i] : options[i].products.slice(0);\n                    optionPriceDiff = 0;\n\n                    if (typeof allowedProducts[0] !== 'undefined' &&\n                        typeof optionPrices[allowedProducts[0]] !== 'undefined') {\n                        allowedProductMinPrice = this._getAllowedProductWithMinPrice(allowedProducts);\n                        optionFinalPrice = parseFloat(optionPrices[allowedProductMinPrice].finalPrice.amount);\n                        optionPriceDiff = optionFinalPrice - finalPrice;\n                        options[i].label = options[i].initialLabel;\n\n                        if (optionPriceDiff !== 0) {\n                            options[i].label += ' ' + priceUtils.formatPriceLocale(\n                                optionPriceDiff,\n                                this.options.priceFormat,\n                                true\n                            );\n                        }\n                    }\n\n                    if (allowedProducts.length > 0 || _.include(allowedOptions, options[i].id)) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this._getOptionLabel(options[i]), options[i].id);\n\n                        if (this.options.spConfig.canDisplayShowOutOfStockStatus) {\n                            filteredSalableProducts = $(this.options.spConfig.salable[attributeId][options[i].id]).\n                            filter(options[i].allowedProducts);\n                            canDisplayOutOfStockProducts = filteredSalableProducts.length === 0;\n                        }\n\n                        if (typeof options[i].price !== 'undefined') {\n                            element.options[index].setAttribute('price', options[i].price);\n                        }\n\n                        if (allowedProducts.length === 0 || canDisplayOutOfStockProducts) {\n                            element.options[index].disabled = true;\n                        }\n\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n\n                    /* eslint-enable max-depth */\n                }\n            }\n        },\n\n        /**\n         * Generate the label associated with a configurable option. This includes the option's\n         * label or value and the option's price.\n         * @private\n         * @param {*} option - A single choice among a group of choices for a configurable option.\n         * @return {String} The option label with option value and price (e.g. Black +1.99)\n         */\n        _getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * Removes an option's selections.\n         * @private\n         * @param {*} element - The element associated with a configurable option.\n         */\n        _clearSelect: function (element) {\n            var i;\n\n            if (element.options) {\n                for (i = element.options.length - 1; i >= 0; i--) {\n                    element.remove(i);\n                }\n            }\n        },\n\n        /**\n         * Retrieve the attribute options associated with a specific attribute Id.\n         * @private\n         * @param {Number} attributeId - The id of the attribute whose configurable options are sought.\n         * @return {Object} Object containing the attribute options.\n         */\n        _getAttributeOptions: function (attributeId) {\n            if (this.options.spConfig.attributes[attributeId]) {\n                return this.options.spConfig.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload the price of the configurable product incorporating the prices of all of the\n         * configurable product's option selections.\n         */\n        _reloadPrice: function () {\n            this._getPriceBoxElement().trigger('updatePrice', this._getPrices());\n        },\n\n        /**\n         * Get product various prices\n         * @returns {{}}\n         * @private\n         */\n        _getPrices: function () {\n            var prices = {},\n                elements = _.toArray(this.options.settings),\n                allowedProduct,\n                selected,\n                config,\n                priceValue;\n\n            _.each(elements, function (element) {\n                if (element.options) {\n                    selected = element.options[element.selectedIndex];\n                    config = selected && selected.config;\n                    priceValue = this._calculatePrice({});\n\n                    if (config && config.allowedProducts.length === 1) {\n                        priceValue = this._calculatePrice(config);\n                    } else if (element.value) {\n                        allowedProduct = this._getAllowedProductWithMinPrice(config.allowedProducts);\n                        priceValue = this._calculatePrice({\n                            'allowedProducts': [\n                                allowedProduct\n                            ]\n                        });\n                    }\n\n                    if (!_.isEmpty(priceValue)) {\n                        prices.prices = priceValue;\n                    }\n                }\n            }, this);\n\n            return prices;\n        },\n\n        /**\n         * Get product with minimum price from selected options.\n         *\n         * @param {Array} allowedProducts\n         * @returns {String}\n         * @private\n         */\n        _getAllowedProductWithMinPrice: function (allowedProducts) {\n            var optionPrices = this.options.spConfig.optionPrices,\n                product = {},\n                optionMinPrice, optionFinalPrice;\n\n            _.each(allowedProducts, function (allowedProduct) {\n                optionFinalPrice = parseFloat(optionPrices[allowedProduct].finalPrice.amount);\n\n                if (_.isEmpty(product) || optionFinalPrice < optionMinPrice) {\n                    optionMinPrice = optionFinalPrice;\n                    product = allowedProduct;\n                }\n            }, this);\n\n            return product;\n        },\n\n        /**\n         * Returns prices for configured products\n         *\n         * @param {*} config - Products configuration\n         * @returns {*}\n         * @private\n         */\n        _calculatePrice: function (config) {\n            var displayPrices = this._getPriceBoxElement().priceBox('option').prices,\n                newPrices = this.options.spConfig.optionPrices[_.first(config.allowedProducts)] || {};\n\n            _.each(displayPrices, function (price, code) {\n                displayPrices[code].amount = newPrices[code] ? newPrices[code].amount - displayPrices[code].amount : 0;\n            });\n\n            return displayPrices;\n        },\n\n        /**\n         * Returns Simple product Id\n         *  depending on current selected option.\n         *\n         * @private\n         * @param {HTMLElement} element\n         * @returns {String|undefined}\n         */\n        _getSimpleProductId: function (element) {\n            // TODO: Rewrite algorithm. It should return ID of\n            //        simple product based on selected options.\n            var allOptions,\n                value,\n                config;\n\n            if (element.config) {\n                allOptions = element.config.options;\n                value = element.value;\n\n                config = _.filter(allOptions, function (option) {\n                    return option.id === value;\n                });\n                config = _.first(config);\n\n                return _.isEmpty(config) ?\n                    undefined :\n                    _.first(config.allowedProducts);\n            }\n        },\n\n        /**\n         * Show or hide regular price block\n         *\n         * @param {*} optionId\n         * @private\n         */\n        _displayRegularPriceBlock: function (optionId) {\n            var shouldBeShown = true,\n                $priceBox = this._getPriceBoxElement();\n\n            _.each(this.options.settings, function (element) {\n                if (element.value === '') {\n                    shouldBeShown = false;\n                }\n            });\n\n            if (shouldBeShown &&\n                this.options.spConfig.optionPrices[optionId].oldPrice.amount !==\n                this.options.spConfig.optionPrices[optionId].finalPrice.amount\n            ) {\n                $(this.options.slyOldPriceSelector).show();\n            } else {\n                $(this.options.slyOldPriceSelector).hide();\n            }\n\n            $(document).trigger('updateMsrpPriceBlock',\n                [\n                    optionId,\n                    this.options.spConfig.optionPrices,\n                    $priceBox\n                ]\n            );\n        },\n\n        /**\n         * Show or hide normal price label\n         *\n         * @private\n         */\n        _displayNormalPriceLabel: function () {\n            var shouldBeShown = false;\n\n            _.each(this.options.settings, function (element) {\n                if (element.value === '') {\n                    shouldBeShown = true;\n                }\n            });\n\n            if (shouldBeShown) {\n                $(this.options.normalPriceLabelSelector).show();\n            } else {\n                $(this.options.normalPriceLabelSelector).hide();\n            }\n        },\n\n        /**\n         * Callback which fired after gallery gets initialized.\n         *\n         * @param {HTMLElement} element - DOM element associated with gallery.\n         */\n        _onGalleryLoaded: function (element) {\n            var galleryObject = element.data('gallery');\n\n            this.options.mediaGalleryInitial = galleryObject.returnCurrentImages();\n        },\n\n        /**\n         * Show or hide tier price block\n         *\n         * @param {*} optionId\n         * @private\n         */\n        _displayTierPriceBlock: function (optionId) {\n            var tierPrices = typeof optionId != 'undefined' && this.options.spConfig.optionPrices[optionId].tierPrices;\n\n            if (_.isArray(tierPrices) && tierPrices.length > 0) {\n\n                if (this.options.tierPriceTemplate) {\n                    $(this.options.tierPriceBlockSelector).html(\n                        mageTemplate(this.options.tierPriceTemplate, {\n                            'tierPrices': tierPrices,\n                            '$t': $t,\n                            'currencyFormat': this.options.spConfig.currencyFormat,\n                            'priceUtils': priceUtils\n                        })\n                    ).show();\n                }\n            } else {\n                $(this.options.tierPriceBlockSelector).hide();\n            }\n        },\n\n        /**\n         * Returns the price container element\n         *\n         * @returns {*}\n         * @private\n         */\n        _getPriceBoxElement: function () {\n            return this.element\n                .parents(this.options.selectorProduct)\n                .find(this.options.selectorProductPrice);\n        }\n    });\n\n    return $.mage.configurable;\n});\n","Magento_ConfigurableProduct/js/catalog-add-to-cart-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_ConfigurableProduct/js/product/view/product-info-resolver'\n], function (_, $, productInfoResolver) {\n    'use strict';\n\n    return function (widget) {\n\n        $.widget('mage.catalogAddToCart', widget, {\n            /**\n             * @param {jQuery} form\n             */\n            ajaxSubmit: function (form) {\n                var isConfigurable = !!_.find(form.serializeArray(), function (item) {\n                    return item.name.indexOf('super_attribute') !== -1;\n                });\n\n                if (isConfigurable) {\n                    this.options.productInfoResolver = productInfoResolver;\n                }\n\n                return this._super(form);\n            }\n        });\n\n        return $.mage.catalogAddToCart;\n    };\n});\n","Magento_ConfigurableProduct/js/catalog-add-to-cart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Add selected configurable attributes to redirect url\n     *\n     * @see Magento_Catalog/js/catalog-add-to-cart\n     */\n    $('body').on('catalogCategoryAddToCartRedirect', function (event, data) {\n        $(data.form).find('select[name*=\"super\"]').each(function (index, item) {\n            data.redirectParameters.push(item.config.id + '=' + $(item).val());\n        });\n    });\n});\n","Magento_ConfigurableProduct/js/configurable-customer-data.js":"require([\n    'jquery',\n    'Magento_ConfigurableProduct/js/options-updater'\n], function ($, Updater) {\n    'use strict';\n\n    var selectors = {\n            formSelector: '#product_addtocart_form'\n        },\n        configurableWidgetName = 'mageConfigurable',\n        widgetInitEvent = 'configurable.initialized',\n\n    /**\n    * Sets all configurable attribute's selected values\n    */\n    updateConfigurableOptions = function () {\n        var configurableWidget = $(selectors.formSelector).data(configurableWidgetName);\n\n        if (!configurableWidget) {\n            return;\n        }\n        configurableWidget.options.values = this.productOptions || {};\n        configurableWidget._configureForValues();\n    },\n    updater = new Updater(widgetInitEvent, updateConfigurableOptions);\n\n    updater.listen();\n});\n","Magento_ConfigurableProduct/js/options-updater.js":"define([\n    'jquery',\n    'underscore',\n    'Magento_Customer/js/customer-data',\n    'domReady!'\n], function ($, _, customerData) {\n    'use strict';\n\n    var selectors = {\n        formSelector: '#product_addtocart_form',\n        productIdSelector: '#product_addtocart_form [name=\"product\"]',\n        itemIdSelector: '#product_addtocart_form [name=\"item\"]'\n    },\n    cartData = customerData.get('cart'),\n    productId = $(selectors.productIdSelector).val(),\n    itemId = $(selectors.itemIdSelector).val(),\n\n    /**\n    * set productOptions according to cart data from customer-data\n    *\n    * @param {Object} data - cart data from customer-data\n    * @returns {Boolean} - whether the new options differ from previous\n    */\n    setProductOptions = function (data) {\n        var changedProductOptions;\n\n        if (!(data && data.items && data.items.length && productId)) {\n            return false;\n        }\n        changedProductOptions = _.find(data.items, function (item) {\n            if (item['item_id'] === itemId) {\n                return item['product_id'] === productId;\n            }\n        });\n        changedProductOptions = changedProductOptions && changedProductOptions.options &&\n            changedProductOptions.options.reduce(function (obj, val) {\n                obj[val['option_id']] = val['option_value'];\n\n                return obj;\n            }, {});\n\n        if (JSON.stringify(this.productOptions || {}) === JSON.stringify(changedProductOptions || {})) {\n            return false;\n        }\n\n        this.productOptions = changedProductOptions;\n\n        return true;\n    },\n\n    /**\n    * Listens to update of cart data or options initialization and update selected option according to customer data\n    *\n    */\n    listen = function () {\n        cartData.subscribe(function (updateCartData) {\n            if (this.setProductOptions(updateCartData)) {\n                this.updateOptions();\n            }\n        }.bind(this));\n        $(selectors.formSelector).on(this.eventName, function () {\n            this.setProductOptions(cartData());\n            this.updateOptions();\n        }.bind(this));\n    },\n\n    /**\n    * Updater constructor function\n    *\n    */\n    Updater = function (eventName, updateOptionsCallback) {\n        if (this instanceof Updater) {\n            this.eventName = eventName;\n            this.updateOptions = updateOptionsCallback;\n            this.productOptions = {};\n        }\n    };\n\n    Updater.prototype.setProductOptions = setProductOptions;\n    Updater.prototype.listen = listen;\n\n    return Updater;\n});\n","Magento_ConfigurableProduct/js/product/view/product-info-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Catalog/js/product/view/product-info'\n], function (_, productInfo) {\n    'use strict';\n\n    /**\n     * Returns info about configurable products in form.\n     *\n     * @param {jQuery} $form\n     * @return {Array}\n     */\n    return function ($form) {\n        var optionValues = [],\n            product = _.findWhere($form.serializeArray(), {\n                name: 'product'\n            }),\n            productId;\n\n        if (!_.isUndefined(product)) {\n            productId = product.value;\n            _.each($form.serializeArray(), function (item) {\n                if (item.name.indexOf('super_attribute') !== -1) {\n                    optionValues.push(item.value);\n                }\n            });\n            optionValues.sort();\n            productInfo().push(\n                {\n                    'id': productId,\n                    'optionValues': optionValues\n                }\n            );\n        }\n\n        return _.uniq(productInfo(), function (item) {\n            var optionValuesStr = item.optionValues ? item.optionValues.join() : '';\n\n            return item.id + optionValuesStr;\n        });\n    };\n});\n\n","Magento_OrderCancellationUi/js/cancel-order-modal.js":"/**\n * Copyright 2023 Adobe\n * All Rights Reserved.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'Magento_Customer/js/customer-data'\n],function ($, modal, customerData) {\n    'use strict';\n\n    return function (config, element) {\n        let order_id = config.order_id,\n            options = {\n                type: 'popup',\n                responsive: true,\n                title: 'Cancel Order',\n                buttons: [{\n                    text: $.mage.__('Close'),\n                    class: 'action-secondary action-dismiss close-modal-button',\n\n                    /** @inheritdoc */\n                    click: function () {\n                        this.closeModal();\n                    }\n                }, {\n                    text: $.mage.__('Confirm'),\n                    class: 'action-primary action-accept cancel-order-button',\n\n                    /** @inheritdoc */\n                    click: function () {\n                        let thisModal = this,\n                            reason = $('#cancel-order-reason-' + order_id).find(':selected').text(),\n                            mutation = `\nmutation cancelOrder($order_id: ID!, $reason: String!) {\n  cancelOrder(input: {order_id: $order_id, reason: $reason}) {\n    error\n    order {\n      status\n    }\n  }\n}`;\n\n                        $.ajax({\n                            showLoader: true,\n                            type: 'POST',\n                            url: `${config.url}graphql`,\n                            contentType: 'application/json',\n                            data: JSON.stringify({\n                                query: mutation,\n                                variables: {\n                                    'order_id': config.order_id,\n                                    'reason': reason\n                                }\n                            }),\n                            complete: function (response) {\n                                let type = 'success',\n                                    message;\n\n                                if (response.responseJSON.data.cancelOrder.error !== null) {\n                                    message = $.mage.__(response.responseJSON.data.cancelOrder.error);\n                                    type = 'error';\n                                } else {\n                                    message = $.mage.__(response.responseJSON.data.cancelOrder.order.status);\n                                    location.reload();\n                                }\n\n                                setTimeout(function () {\n                                    customerData.set('messages', {\n                                        messages: [{\n                                            text: message,\n                                            type: type\n                                        }]\n                                    });\n                                }, 1000);\n                            }\n                        }).always(function () {\n                            thisModal.closeModal(true);\n                        });\n                    }\n                }]\n            };\n\n        $(element).on('click', function () {\n            $('#cancel-order-modal-' + order_id).modal('openModal');\n        });\n\n        modal(options, $('#cancel-order-modal-' + order_id));\n    };\n});\n","Magento_ReCaptchaFrontendUi/js/ui-messages-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['Magento_ReCaptchaFrontendUi/js/registry'], function (registry) {\n    'use strict';\n\n    return function (originalComponent) {\n        return originalComponent.extend({\n            /**\n             * Initialize reset on messages\n             * @returns {initialize}\n             */\n            initialize: function () {\n                this._super();\n\n                this.messageContainer.errorMessages.subscribe(function () {\n                    var\n                        i,\n                        captchaList = registry.captchaList(),\n                        tokenFieldsList = registry.tokenFields();\n\n                    for (i = 0; i < captchaList.length; i++) {\n                        // eslint-disable-next-line no-undef\n                        grecaptcha.reset(captchaList[i]);\n\n                        if (tokenFieldsList[i]) {\n                            tokenFieldsList[i].value = '';\n                        }\n                    }\n                }, null, 'arrayChange');\n\n                return this;\n            }\n        });\n    };\n});\n","Magento_ReCaptchaFrontendUi/js/registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    return {\n        ids: ko.observableArray([]),\n        captchaList: ko.observableArray([]),\n        tokenFields: ko.observableArray([])\n    };\n});\n","Magento_ReCaptchaFrontendUi/js/nonInlineReCaptchaRenderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global grecaptcha */\ndefine([\n    'jquery',\n    'jquery/z-index'\n], function ($) {\n    'use strict';\n\n    var reCaptchaEntities = [],\n        initialized = false,\n        rendererRecaptchaId = 'recaptcha-invisible',\n        rendererReCaptcha = null;\n\n    return {\n        /**\n         * Add reCaptcha entity to checklist.\n         *\n         * @param {jQuery} reCaptchaEntity\n         * @param {Object} parameters\n         */\n        add: function (reCaptchaEntity, parameters) {\n            if (!initialized) {\n                this.init();\n                grecaptcha.render(rendererRecaptchaId, parameters);\n                setInterval(this.resolveVisibility, 100);\n                initialized = true;\n            }\n\n            reCaptchaEntities.push(reCaptchaEntity);\n        },\n\n        /**\n         * Show additional reCaptcha instance if any other should be visible, otherwise hide it.\n         */\n        resolveVisibility: function () {\n            reCaptchaEntities.some(function (entity) {\n                return entity.is(':visible') &&\n                    // 900 is some magic z-index value of modal popups.\n                    (entity.closest('[data-role=\\'modal\\']').length === 0 || entity.zIndex() > 900);\n            }) ? rendererReCaptcha.show() : rendererReCaptcha.hide();\n        },\n\n        /**\n         * Initialize additional reCaptcha instance.\n         */\n        init: function () {\n            rendererReCaptcha = $('<div/>', {\n                'id': rendererRecaptchaId\n            });\n            rendererReCaptcha.hide();\n            $('body').append(rendererReCaptcha);\n        }\n    };\n});\n","Magento_ReCaptchaFrontendUi/js/reCaptchaScriptLoader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var scriptTagAdded = false;\n\n    return {\n        /**\n         * Add script tag. Script tag should be added once\n         */\n        addReCaptchaScriptTag: function () {\n            var element, scriptTag;\n\n            if (!scriptTagAdded) {\n                element = document.createElement('script');\n                scriptTag = document.getElementsByTagName('script')[0];\n\n                element.async = true;\n                element.src = 'https://www.google.com/recaptcha/api.js' +\n                    '?onload=globalOnRecaptchaOnLoadCallback&render=explicit';\n\n                scriptTag.parentNode.insertBefore(element, scriptTag);\n                scriptTagAdded = true;\n            }\n        }\n    };\n});\n","Magento_ReCaptchaFrontendUi/js/reCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global grecaptcha */\ndefine(\n    [\n        'uiComponent',\n        'jquery',\n        'ko',\n        'underscore',\n        'Magento_ReCaptchaFrontendUi/js/registry',\n        'Magento_ReCaptchaFrontendUi/js/reCaptchaScriptLoader',\n        'Magento_ReCaptchaFrontendUi/js/nonInlineReCaptchaRenderer'\n    ], function (Component, $, ko, _, registry, reCaptchaLoader, nonInlineReCaptchaRenderer) {\n        'use strict';\n\n        return Component.extend({\n\n            defaults: {\n                template: 'Magento_ReCaptchaFrontendUi/reCaptcha',\n                reCaptchaId: 'recaptcha'\n            },\n\n            /**\n             * @inheritdoc\n             */\n            initialize: function () {\n                this._super();\n                this._loadApi();\n            },\n\n            /**\n             * Loads recaptchaapi API and triggers event, when loaded\n             * @private\n             */\n            _loadApi: function () {\n                if (this._isApiRegistered !== undefined) {\n                    if (this._isApiRegistered === true) {\n                        $(window).trigger('recaptchaapiready');\n                    }\n\n                    return;\n                }\n                this._isApiRegistered = false;\n\n                // global function\n                window.globalOnRecaptchaOnLoadCallback = function () {\n                    this._isApiRegistered = true;\n                    $(window).trigger('recaptchaapiready');\n                }.bind(this);\n\n                reCaptchaLoader.addReCaptchaScriptTag();\n            },\n\n            /**\n             * Checking that reCAPTCHA is invisible type\n             * @returns {Boolean}\n             */\n            getIsInvisibleRecaptcha: function () {\n                if (this.settings ===\n\n                    void 0) {\n                    return false;\n                }\n\n                return this.settings.invisible;\n            },\n\n            /**\n             * reCAPTCHA callback\n             * @param {String} token\n             */\n            reCaptchaCallback: function (token) {\n                var submitButton;\n\n                if (this.getIsInvisibleRecaptcha()) {\n                    this.tokenField.value = token;\n                    submitButton = this.$parentForm.find('button:not([type]), [type=submit]');\n                    if (submitButton.length) { //eslint-disable-line max-depth\n                        submitButton.attr('disabled', false);\n                    }\n                    this.$parentForm.submit();\n                }\n            },\n\n            /**\n             * Initialize reCAPTCHA after first rendering\n             */\n            initCaptcha: function () {\n                var $parentForm,\n                    $wrapper,\n                    $reCaptcha,\n                    widgetId,\n                    parameters;\n\n                if (this.captchaInitialized || this.settings ===\n\n                    void 0) {\n                    return;\n                }\n\n                this.captchaInitialized = true;\n\n                /*\n                 * Workaround for data-bind issue:\n                 * We cannot use data-bind to link a dynamic id to our component\n                 * See:\n                 * https://stackoverflow.com/questions/46657573/recaptcha-the-bind-parameter-must-be-an-element-or-id\n                 *\n                 * We create a wrapper element with a wrapping id and we inject the real ID with jQuery.\n                 * In this way we have no data-bind attribute at all in our reCAPTCHA div\n                 */\n                $wrapper = $('#' + this.getReCaptchaId() + '-wrapper');\n                $reCaptcha = $wrapper.find('.g-recaptcha');\n                $reCaptcha.attr('id', this.getReCaptchaId());\n\n                $parentForm = $wrapper.parents('form');\n\n                if (this.settings === undefined) {\n\n                    return;\n                }\n\n                parameters = _.extend(\n                    {\n                        'callback': function (token) { // jscs:ignore jsDoc\n                            this.reCaptchaCallback(token);\n                            this.validateReCaptcha(true);\n                        }.bind(this),\n                        'expired-callback': function () {\n                            this.validateReCaptcha(false);\n                        }.bind(this)\n                    },\n                    this.settings.rendering\n                );\n\n                if (parameters.size === 'invisible' && parameters.badge !== 'inline') {\n                    nonInlineReCaptchaRenderer.add($reCaptcha, parameters);\n                }\n\n                // eslint-disable-next-line no-undef\n                widgetId = grecaptcha.render(this.getReCaptchaId(), parameters);\n                this.initParentForm($parentForm, widgetId);\n\n                registry.ids.push(this.getReCaptchaId());\n                registry.captchaList.push(widgetId);\n                registry.tokenFields.push(this.tokenField);\n\n            },\n\n            /**\n             * Initialize parent form.\n             *\n             * @param {Object} parentForm\n             * @param {String} widgetId\n             */\n            initParentForm: function (parentForm, widgetId) {\n                var listeners;\n\n                if (this.getIsInvisibleRecaptcha() && parentForm.length > 0) {\n                    parentForm.submit(function (event) {\n                        var submitButton;\n\n                        if (!this.tokenField.value) {\n                            submitButton = this.$parentForm.find('button:not([type]), [type=submit]');\n                            if (submitButton.length) { //eslint-disable-line max-depth\n                                submitButton.attr('disabled', true);\n                            }\n                            // eslint-disable-next-line no-undef\n                            grecaptcha.execute(widgetId);\n                            event.preventDefault(event);\n                            event.stopImmediatePropagation();\n                        }\n                    }.bind(this));\n\n                    // Move our (last) handler topmost. We need this to avoid submit bindings with ko.\n                    listeners = $._data(parentForm[0], 'events').submit;\n                    listeners.unshift(listeners.pop());\n\n                    // Create a virtual token field\n                    this.tokenField = $('<input type=\"text\" name=\"token\" style=\"display: none\" />')[0];\n                    this.$parentForm = parentForm;\n                    parentForm.append(this.tokenField);\n                } else {\n                    this.tokenField = null;\n                }\n                let submitButton = parentForm.find('button:not([type]), [type=submit]');\n\n                if (submitButton.length) {\n                    submitButton.prop('disabled', false);\n                }\n            },\n\n            /**\n             * Validates reCAPTCHA\n             * @param {*} state\n             * @returns {jQuery}\n             */\n            validateReCaptcha: function (state) {\n                if (!this.getIsInvisibleRecaptcha()) {\n                    return $(document).find('input[type=checkbox].required-captcha').prop('checked', state);\n                }\n            },\n\n            /**\n             * Render reCAPTCHA\n             */\n            renderReCaptcha: function () {\n                if (window.grecaptcha && window.grecaptcha.render) { // Check if reCAPTCHA is already loaded\n                    this.initCaptcha();\n                } else { // Wait for reCAPTCHA to be loaded\n                    $(window).on('recaptchaapiready', function () {\n                        this.initCaptcha();\n                    }.bind(this));\n                }\n            },\n\n            /**\n             * Get reCAPTCHA ID\n             * @returns {String}\n             */\n            getReCaptchaId: function () {\n                return this.reCaptchaId;\n            }\n        });\n    });\n","js-storage/js.storage.js":"/*\n * JS Storage Plugin\n *\n * Copyright (c) 2019 Julien Maurel\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/mit-license.php\n *\n * Project home:\n * https://github.com/julien-maurel/js-storage\n *\n * Version: 1.1.0\n */\n(function (factory) {\n    var registeredInModuleLoader = false;\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery', 'jquery/jquery.cookie'], factory);\n        registeredInModuleLoader = true;\n    }\n    if (typeof exports === 'object') {\n        module.exports = factory();\n        registeredInModuleLoader = true;\n    }\n    if (!registeredInModuleLoader) {\n        var OldStorages = window.Storages;\n        var api = window.Storages = factory();\n        api.noConflict = function () {\n            window.Storages = OldStorages;\n            return api;\n        };\n    }\n}(function () {\n    // Variables used by utilities functions (like isPlainObject...)\n    var class2type = {};\n    var toString = class2type.toString;\n    var hasOwn = class2type.hasOwnProperty;\n    var fnToString = hasOwn.toString;\n    var ObjectFunctionString = fnToString.call(Object);\n    var getProto = Object.getPrototypeOf;\n    var apis = {};\n\n    // Prefix to use with cookie fallback\n    var cookie_local_prefix = \"ls_\";\n    var cookie_session_prefix = \"ss_\";\n\n    // Get items from a storage\n    function _get() {\n        var storage = this._type, l = arguments.length, s = window[storage], a = arguments, a0 = a[0], vi, ret, tmp, i, j;\n        if (l < 1) {\n            throw new Error('Minimum 1 argument must be given');\n        } else if (Array.isArray(a0)) {\n            // If second argument is an array, return an object with value of storage for each item in this array\n            ret = {};\n            for (i in a0) {\n                if (a0.hasOwnProperty(i)) {\n                    vi = a0[i];\n                    try {\n                        ret[vi] = JSON.parse(s.getItem(vi));\n                    } catch (e) {\n                        ret[vi] = s.getItem(vi);\n                    }\n                }\n            }\n            return ret;\n        } else if (l == 1) {\n            // If only 1 argument, return value directly\n            try {\n                return JSON.parse(s.getItem(a0));\n            } catch (e) {\n                return s.getItem(a0);\n            }\n        } else {\n            // If more than 1 argument, parse storage to retrieve final value to return it\n            // Get first level\n            try {\n                ret = JSON.parse(s.getItem(a0));\n                if (!ret) {\n                    throw new ReferenceError(a0 + ' is not defined in this storage');\n                }\n            } catch (e) {\n                throw new ReferenceError(a0 + ' is not defined in this storage');\n            }\n            // Parse next levels\n            for (i = 1; i < l - 1; i++) {\n                ret = ret[a[i]];\n                if (ret === undefined) {\n                    throw new ReferenceError([].slice.call(a, 0, i + 1).join('.') + ' is not defined in this storage');\n                }\n            }\n            // If last argument is an array, return an object with value for each item in this array\n            // Else return value normally\n            if (Array.isArray(a[i])) {\n                tmp = ret;\n                ret = {};\n                for (j in a[i]) {\n                    if (a[i].hasOwnProperty(j)) {\n                        ret[a[i][j]] = tmp[a[i][j]];\n                    }\n                }\n                return ret;\n            } else {\n                return ret[a[i]];\n            }\n        }\n    }\n\n    // Set items of a storage\n    function _set() {\n        var storage = this._type, l = arguments.length, s = window[storage], a = arguments, a0 = a[0], a1 = a[1], vi, to_store = isNaN(a1) ? {} : [], type, tmp, i;\n        if (l < 1 || !_isPlainObject(a0) && l < 2) {\n            throw new Error('Minimum 2 arguments must be given or first parameter must be an object');\n        } else if (_isPlainObject(a0)) {\n            // If first argument is an object, set values of storage for each property of this object\n            for (i in a0) {\n                if (a0.hasOwnProperty(i)) {\n                    vi = a0[i];\n                    if (!_isPlainObject(vi) && !this.alwaysUseJson) {\n                        s.setItem(i, vi);\n                    } else {\n                        s.setItem(i, JSON.stringify(vi));\n                    }\n                }\n            }\n            return a0;\n        } else if (l == 2) {\n            // If only 2 arguments, set value of storage directly\n            if (typeof a1 === 'object' || this.alwaysUseJson) {\n                s.setItem(a0, JSON.stringify(a1));\n            } else {\n                s.setItem(a0, a1);\n            }\n            return a1;\n        } else {\n            // If more than 3 arguments, parse storage to retrieve final node and set value\n            // Get first level\n            try {\n                tmp = s.getItem(a0);\n                if (tmp != null) {\n                    to_store = JSON.parse(tmp);\n                }\n            } catch (e) {\n            }\n            tmp = to_store;\n            // Parse next levels and set value\n            for (i = 1; i < l - 2; i++) {\n                vi = a[i];\n                type = isNaN(a[i + 1]) ? \"object\" : \"array\";\n                if (!tmp[vi] || type == \"object\" && !_isPlainObject(tmp[vi]) || type == \"array\" && !Array.isArray(tmp[vi])) {\n                    if (type == \"array\") tmp[vi] = [];\n                    else tmp[vi] = {};\n                }\n                tmp = tmp[vi];\n            }\n            tmp[a[i]] = a[i + 1];\n            s.setItem(a0, JSON.stringify(to_store));\n            return to_store;\n        }\n    }\n\n    // Remove items from a storage\n    function _remove() {\n        var storage = this._type, l = arguments.length, s = window[storage], a = arguments, a0 = a[0], to_store, tmp, i, j;\n        if (l < 1) {\n            throw new Error('Minimum 1 argument must be given');\n        } else if (Array.isArray(a0)) {\n            // If first argument is an array, remove values from storage for each item of this array\n            for (i in a0) {\n                if (a0.hasOwnProperty(i)) {\n                    s.removeItem(a0[i]);\n                }\n            }\n            return true;\n        } else if (l == 1) {\n            // If only 2 arguments, remove value from storage directly\n            s.removeItem(a0);\n            return true;\n        } else {\n            // If more than 2 arguments, parse storage to retrieve final node and remove value\n            // Get first level\n            try {\n                to_store = tmp = JSON.parse(s.getItem(a0));\n            } catch (e) {\n                throw new ReferenceError(a0 + ' is not defined in this storage');\n            }\n            // Parse next levels and remove value\n            for (i = 1; i < l - 1; i++) {\n                tmp = tmp[a[i]];\n                if (tmp === undefined) {\n                    throw new ReferenceError([].slice.call(a, 1, i).join('.') + ' is not defined in this storage');\n                }\n            }\n            // If last argument is an array,remove value for each item in this array\n            // Else remove value normally\n            if (Array.isArray(a[i])) {\n                for (j in a[i]) {\n                    if (a[i].hasOwnProperty(j)) {\n                        delete tmp[a[i][j]];\n                    }\n                }\n            } else {\n                delete tmp[a[i]];\n            }\n            s.setItem(a0, JSON.stringify(to_store));\n            return true;\n        }\n    }\n\n    // Remove all items from a storage\n    function _removeAll(reinit_ns) {\n        var keys = _keys.call(this), i;\n        for (i in keys) {\n            if (keys.hasOwnProperty(i)) {\n                _remove.call(this, keys[i]);\n            }\n        }\n        // Reinitialize all namespace storages\n        if (reinit_ns) {\n            for (i in apis.namespaceStorages) {\n                if (apis.namespaceStorages.hasOwnProperty(i)) {\n                    _createNamespace(i);\n                }\n            }\n        }\n    }\n\n    // Check if items of a storage are empty\n    function _isEmpty() {\n        var l = arguments.length, a = arguments, a0 = a[0], i;\n        if (l == 0) {\n            // If no argument, test if storage is empty\n            return (_keys.call(this).length == 0);\n        } else if (Array.isArray(a0)) {\n            // If first argument is an array, test each item of this array and return true only if all items are empty\n            for (i = 0; i < a0.length; i++) {\n                if (!_isEmpty.call(this, a0[i])) {\n                    return false;\n                }\n            }\n            return true;\n        } else {\n            // If at least 1 argument, try to get value and test it\n            try {\n                var v = _get.apply(this, arguments);\n                // Convert result to an object (if last argument is an array, _get return already an object) and test each item\n                if (!Array.isArray(a[l - 1])) {\n                    v = {'totest': v};\n                }\n                for (i in v) {\n                    if (v.hasOwnProperty(i) && !(\n                        (_isPlainObject(v[i]) && _isEmptyObject(v[i])) ||\n                        (Array.isArray(v[i]) && !v[i].length) ||\n                        (typeof v[i] !== 'boolean' && !v[i])\n                    )) {\n                        return false;\n                    }\n                }\n                return true;\n            } catch (e) {\n                return true;\n            }\n        }\n    }\n\n    // Check if items of a storage exist\n    function _isSet() {\n        var l = arguments.length, a = arguments, a0 = a[0], i;\n        if (l < 1) {\n            throw new Error('Minimum 1 argument must be given');\n        }\n        if (Array.isArray(a0)) {\n            // If first argument is an array, test each item of this array and return true only if all items exist\n            for (i = 0; i < a0.length; i++) {\n                if (!_isSet.call(this, a0[i])) {\n                    return false;\n                }\n            }\n            return true;\n        } else {\n            // For other case, try to get value and test it\n            try {\n                var v = _get.apply(this, arguments);\n                // Convert result to an object (if last argument is an array, _get return already an object) and test each item\n                if (!Array.isArray(a[l - 1])) {\n                    v = {'totest': v};\n                }\n                for (i in v) {\n                    if (v.hasOwnProperty(i) && !(v[i] !== undefined && v[i] !== null)) {\n                        return false;\n                    }\n                }\n                return true;\n            } catch (e) {\n                return false;\n            }\n        }\n    }\n\n    // Get keys of a storage or of an item of the storage\n    function _keys() {\n        var storage = this._type, l = arguments.length, s = window[storage], keys = [], o = {};\n        // If at least 1 argument, get value from storage to retrieve keys\n        // Else, use storage to retrieve keys\n        if (l > 0) {\n            o = _get.apply(this, arguments);\n        } else {\n            o = s;\n        }\n        if (o && o._cookie) {\n            // If storage is a cookie, use js-cookie to retrieve keys\n            var cookies = Cookies.get();\n            for (var key in cookies) {\n                if (cookies.hasOwnProperty(key) && key != '') {\n                    keys.push(key.replace(o._prefix, ''));\n                }\n            }\n        } else {\n            for (var i in o) {\n                if (o.hasOwnProperty(i)) {\n                    keys.push(i);\n                }\n            }\n        }\n        return keys;\n    }\n\n    // Create new namespace storage\n    function _createNamespace(name) {\n        if (!name || typeof name != \"string\") {\n            throw new Error('First parameter must be a string');\n        }\n        if (storage_available) {\n            if (!window.localStorage.getItem(name)) {\n                window.localStorage.setItem(name, '{}');\n            }\n            if (!window.sessionStorage.getItem(name)) {\n                window.sessionStorage.setItem(name, '{}');\n            }\n        } else {\n            if (!window.localCookieStorage.getItem(name)) {\n                window.localCookieStorage.setItem(name, '{}');\n            }\n            if (!window.sessionCookieStorage.getItem(name)) {\n                window.sessionCookieStorage.setItem(name, '{}');\n            }\n        }\n        var ns = {\n            localStorage: _extend({}, apis.localStorage, {_ns: name}),\n            sessionStorage: _extend({}, apis.sessionStorage, {_ns: name})\n        };\n        if (cookies_available) {\n            if (!window.cookieStorage.getItem(name)) {\n                window.cookieStorage.setItem(name, '{}');\n            }\n            ns.cookieStorage = _extend({}, apis.cookieStorage, {_ns: name});\n        }\n        apis.namespaceStorages[name] = ns;\n        return ns;\n    }\n\n    // Test if storage is natively available on browser\n    function _testStorage(name) {\n        var foo = 'jsapi';\n        try {\n            if (!window[name]) {\n                return false;\n            }\n            window[name].setItem(foo, foo);\n            window[name].removeItem(foo);\n            return true;\n        } catch (e) {\n            return false;\n        }\n    }\n\n    // Test if a variable is a plain object (from jQuery)\n    function _isPlainObject(obj) {\n        var proto, Ctor;\n\n        // Detect obvious negatives\n        // Use toString instead of jQuery.type to catch host objects\n        if (!obj || toString.call(obj) !== \"[object Object]\") {\n            return false;\n        }\n\n        proto = getProto(obj);\n\n        // Objects with no prototype (e.g., `Object.create( null )`) are plain\n        if (!proto) {\n            return true;\n        }\n\n        // Objects with prototype are plain iff they were constructed by a global Object function\n        Ctor = hasOwn.call(proto, \"constructor\") && proto.constructor;\n        return typeof Ctor === \"function\" && fnToString.call(Ctor) === ObjectFunctionString;\n    }\n\n    // Test if a variable is an empty object (from jQuery)\n    function _isEmptyObject(obj) {\n        var name;\n\n        for (name in obj) {\n            return false;\n        }\n        return true;\n    }\n\n    // Merge objects\n    function _extend() {\n        var i = 1;\n        var result = arguments[0];\n        for (; i < arguments.length; i++) {\n            var attributes = arguments[i];\n            for (var key in attributes) {\n                if (attributes.hasOwnProperty(key)) {\n                    result[key] = attributes[key];\n                }\n            }\n        }\n        return result;\n    }\n\n    // Check if storages are natively available on browser and check is js-cookie is present\n    var storage_available = _testStorage('localStorage');\n    var cookies_available = typeof Cookies !== 'undefined';\n\n    // Namespace object\n    var storage = {\n        _type: '',\n        _ns: '',\n        _callMethod: function (f, a) {\n            a = Array.prototype.slice.call(a);\n            var p = [], a0 = a[0];\n            if (this._ns) {\n                p.push(this._ns);\n            }\n            if (typeof a0 === 'string' && a0.indexOf('.') !== -1) {\n                a.shift();\n                [].unshift.apply(a, a0.split('.'));\n            }\n            [].push.apply(p, a);\n            return f.apply(this, p);\n        },\n        // Define if plugin always use JSON to store values (even to store simple values like string, int...) or not\n        alwaysUseJson: false,\n        // Get items. If no parameters and storage have a namespace, return all namespace\n        get: function () {\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_get, arguments);\n        },\n        // Set items\n        set: function () {\n            var l = arguments.length, a = arguments, a0 = a[0];\n            if (l < 1 || !_isPlainObject(a0) && l < 2) {\n                throw new Error('Minimum 2 arguments must be given or first parameter must be an object');\n            }\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            // If first argument is an object and storage is a namespace storage, set values individually\n            if (_isPlainObject(a0) && this._ns) {\n                for (var i in a0) {\n                    if (a0.hasOwnProperty(i)) {\n                        this._callMethod(_set, [i, a0[i]]);\n                    }\n                }\n                return a0;\n            } else {\n                var r = this._callMethod(_set, a);\n                if (this._ns) {\n                    return r[a0.split('.')[0]];\n                } else {\n                    return r;\n                }\n            }\n        },\n        // Delete items\n        remove: function () {\n            if (arguments.length < 1) {\n                throw new Error('Minimum 1 argument must be given');\n            }\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_remove, arguments);\n        },\n        // Delete all items\n        removeAll: function (reinit_ns) {\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            if (this._ns) {\n                this._callMethod(_set, [{}]);\n                return true;\n            } else {\n                return this._callMethod(_removeAll, [reinit_ns]);\n            }\n        },\n        // Items empty\n        isEmpty: function () {\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_isEmpty, arguments);\n        },\n        // Items exists\n        isSet: function () {\n            if (arguments.length < 1) {\n                throw new Error('Minimum 1 argument must be given');\n            }\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_isSet, arguments);\n        },\n        // Get keys of items\n        keys: function () {\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_keys, arguments);\n        }\n    };\n\n    // Use js-cookie for compatibility with old browsers and give access to cookieStorage\n    if (cookies_available) {\n        // sessionStorage is valid for one window/tab. To simulate that with cookie, we set a name for the window and use it for the name of the cookie\n        if (!window.name) {\n            window.name = Math.floor(Math.random() * 100000000);\n        }\n        var cookie_storage = {\n            _cookie: true,\n            _prefix: '',\n            _expires: null,\n            _path: null,\n            _domain: null,\n            _secure: false,\n            setItem: function (n, v) {\n                Cookies.set(this._prefix + n, v, {expires: this._expires, path: this._path, domain: this._domain, secure: this._secure});\n            },\n            getItem: function (n) {\n                return Cookies.get(this._prefix + n);\n            },\n            removeItem: function (n) {\n                return Cookies.remove(this._prefix + n, {path: this._path});\n            },\n            clear: function () {\n                var cookies = Cookies.get();\n                for (var key in cookies) {\n                    if (cookies.hasOwnProperty(key) && key != '') {\n                        if (!this._prefix && key.indexOf(cookie_local_prefix) === -1 && key.indexOf(cookie_session_prefix) === -1 || this._prefix && key.indexOf(this._prefix) === 0) {\n                            Cookies.remove(key);\n                        }\n                    }\n                }\n            },\n            setExpires: function (e) {\n                this._expires = e;\n                return this;\n            },\n            setPath: function (p) {\n                this._path = p;\n                return this;\n            },\n            setDomain: function (d) {\n                this._domain = d;\n                return this;\n            },\n            setSecure: function (s) {\n                this._secure = s;\n                return this;\n            },\n            setConf: function (c) {\n                if (c.path) {\n                    this._path = c.path;\n                }\n                if (c.domain) {\n                    this._domain = c.domain;\n                }\n                if (c.secure) {\n                    this._secure = c.secure;\n                }\n                if (c.expires) {\n                    this._expires = c.expires;\n                }\n                return this;\n            },\n            setDefaultConf: function () {\n                this._path = this._domain = this._expires = null;\n                this._secure = false;\n            }\n        };\n        if (!storage_available) {\n            window.localCookieStorage = _extend({}, cookie_storage, {\n                _prefix: cookie_local_prefix,\n                _expires: 365 * 10,\n                _secure: true\n            });\n            window.sessionCookieStorage = _extend({}, cookie_storage, {\n                _prefix: cookie_session_prefix + window.name + '_',\n                _secure: true\n            });\n        }\n        window.cookieStorage = _extend({}, cookie_storage);\n        // cookieStorage API\n        apis.cookieStorage = _extend({}, storage, {\n            _type: 'cookieStorage',\n            setExpires: function (e) {\n                window.cookieStorage.setExpires(e);\n                return this;\n            },\n            setPath: function (p) {\n                window.cookieStorage.setPath(p);\n                return this;\n            },\n            setDomain: function (d) {\n                window.cookieStorage.setDomain(d);\n                return this;\n            },\n            setSecure: function (s) {\n                window.cookieStorage.setSecure(s);\n                return this;\n            },\n            setConf: function (c) {\n                window.cookieStorage.setConf(c);\n                return this;\n            },\n            setDefaultConf: function () {\n                window.cookieStorage.setDefaultConf();\n                return this;\n            }\n        });\n    }\n\n    // Get a new API on a namespace\n    apis.initNamespaceStorage = function (ns) {\n        return _createNamespace(ns);\n    };\n    if (storage_available) {\n        // localStorage API\n        apis.localStorage = _extend({}, storage, {_type: 'localStorage'});\n        // sessionStorage API\n        apis.sessionStorage = _extend({}, storage, {_type: 'sessionStorage'});\n    } else {\n        // localStorage API\n        apis.localStorage = _extend({}, storage, {_type: 'localCookieStorage'});\n        // sessionStorage API\n        apis.sessionStorage = _extend({}, storage, {_type: 'sessionCookieStorage'});\n    }\n    // List of all namespace storage\n    apis.namespaceStorages = {};\n    // Remove all items in all storages\n    apis.removeAllStorages = function (reinit_ns) {\n        apis.localStorage.removeAll(reinit_ns);\n        apis.sessionStorage.removeAll(reinit_ns);\n        if (apis.cookieStorage) {\n            apis.cookieStorage.removeAll(reinit_ns);\n        }\n        if (!reinit_ns) {\n            apis.namespaceStorages = {};\n        }\n    };\n    // About alwaysUseJson\n    // By default, all values are string on html storages and the plugin don't use json to store simple values (strings, int, float...)\n    // So by default, if you do storage.setItem('test',2), value in storage will be \"2\", not 2\n    // If you set this property to true, all values set with the plugin will be stored as json to have typed values in any cases\n    apis.alwaysUseJsonInStorage = function (value) {\n        storage.alwaysUseJson = value;\n        apis.localStorage.alwaysUseJson = value;\n        apis.sessionStorage.alwaysUseJson = value;\n        if (apis.cookieStorage) {\n            apis.cookieStorage.alwaysUseJson = value;\n        }\n    };\n\n    return apis;\n}));\n","js-storage/storage-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-storage/js.storage'\n], function ($, storage) {\n    'use strict';\n\n    if (window.cookieStorage) {\n        var cookiesConfig = window.cookiesConfig || {};\n\n        $.extend(window.cookieStorage, {\n            _secure: !!cookiesConfig.secure,\n            _samesite: cookiesConfig.samesite ? cookiesConfig.samesite : 'lax',\n\n            /**\n             * Set value under name\n             * @param {String} name\n             * @param {String} value\n             * @param {Object} [options]\n             */\n            setItem: function (name, value, options) {\n                var _default = {\n                    expires: this._expires,\n                    path: this._path,\n                    domain: this._domain,\n                    secure: this._secure,\n                    samesite: this._samesite\n                };\n\n                $.cookie(this._prefix + name, value, $.extend(_default, options || {}));\n            },\n\n            /**\n             * Set default options\n             * @param {Object} c\n             * @returns {storage}\n             */\n            setConf: function (c) {\n                if (c.path) {\n                    this._path = c.path;\n                }\n\n                if (c.domain) {\n                    this._domain = c.domain;\n                }\n\n                if (c.expires) {\n                    this._expires = c.expires;\n                }\n\n                if (typeof c.secure !== 'undefined') {\n                    this._secure = c.secure;\n                }\n\n                if (typeof c.samesite !== 'undefined') {\n                    this._samesite = c.samesite;\n                }\n\n                return this;\n            }\n        });\n    }\n\n    $.alwaysUseJsonInStorage = $.alwaysUseJsonInStorage || storage.alwaysUseJsonInStorage;\n    $.cookieStorage = $.cookieStorage || storage.cookieStorage;\n    $.initNamespaceStorage = $.initNamespaceStorage || storage.initNamespaceStorage;\n    $.localStorage = $.localStorage || storage.localStorage;\n    $.namespaceStorages = $.namespaceStorages || storage.namespaceStorages;\n    $.removeAllStorages = $.removeAllStorages || storage.removeAllStorages;\n    $.sessionStorage = $.sessionStorage || storage.sessionStorage;\n});\n","Magento_CheckoutAgreements/js/model/agreements-assigner.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var agreementsConfig = window.checkoutConfig.checkoutAgreements;\n\n    /** Override default place order action and add agreement_ids to request */\n    return function (paymentData) {\n        var agreementForm,\n            agreementData,\n            agreementIds;\n\n        if (!agreementsConfig.isEnabled) {\n            return;\n        }\n\n        agreementForm = $('.payment-method._active div[data-role=checkout-agreements] input');\n        agreementData = agreementForm.serializeArray();\n        agreementIds = [];\n\n        agreementData.forEach(function (item) {\n            agreementIds.push(item.value);\n        });\n\n        if (paymentData['extension_attributes'] === undefined) {\n            paymentData['extension_attributes'] = {};\n        }\n\n        paymentData['extension_attributes']['agreement_ids'] = agreementIds;\n    };\n});\n","Magento_CheckoutAgreements/js/model/set-payment-information-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_CheckoutAgreements/js/model/agreements-assigner'\n], function ($, wrapper, agreementsAssigner) {\n    'use strict';\n\n    return function (placeOrderAction) {\n\n        /** Override place-order-mixin for set-payment-information action as they differs only by method signature */\n        return wrapper.wrap(placeOrderAction, function (originalAction, messageContainer, paymentData) {\n            agreementsAssigner(paymentData);\n\n            return originalAction(messageContainer, paymentData);\n        });\n    };\n});\n","Magento_CheckoutAgreements/js/model/agreement-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/validation'\n], function ($) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig,\n        agreementsConfig = checkoutConfig ? checkoutConfig.checkoutAgreements : {},\n        agreementsInputPath = '.payment-method._active div.checkout-agreements input';\n\n    return {\n        /**\n         * Validate checkout agreements\n         *\n         * @returns {Boolean}\n         */\n        validate: function (hideError) {\n            var isValid = true;\n\n            if (!agreementsConfig.isEnabled || $(agreementsInputPath).length === 0) {\n                return true;\n            }\n\n            $(agreementsInputPath).each(function (index, element) {\n                if (!$.validator.validateSingleElement(element, {\n                    errorElement: 'div',\n                    hideError: hideError || false\n                })) {\n                    isValid = false;\n                }\n            });\n\n            return isValid;\n        }\n    };\n});\n","Magento_CheckoutAgreements/js/model/place-order-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/utils/wrapper',\n    'Magento_CheckoutAgreements/js/model/agreements-assigner'\n], function ($, wrapper, agreementsAssigner) {\n    'use strict';\n\n    return function (placeOrderAction) {\n\n        /** Override default place order action and add agreement_ids to request */\n        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, messageContainer) {\n            agreementsAssigner(paymentData);\n\n            return originalAction(paymentData, messageContainer);\n        });\n    };\n});\n","Magento_CheckoutAgreements/js/model/agreements-modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal, $t) {\n    'use strict';\n\n    return {\n        modalWindow: null,\n\n        /**\n         * Create popUp window for provided element.\n         *\n         * @param {HTMLElement} element\n         */\n        createModal: function (element) {\n            var options;\n\n            this.modalWindow = element;\n            options = {\n                'type': 'popup',\n                'modalClass': 'agreements-modal',\n                'responsive': true,\n                'innerScroll': true,\n                'trigger': '.show-modal',\n                'buttons': [\n                    {\n                        text: $t('Close'),\n                        class: 'action secondary action-hide-popup',\n\n                        /** @inheritdoc */\n                        click: function () {\n                            this.closeModal();\n                        }\n                    }\n                ]\n            };\n            modal(options, $(this.modalWindow));\n        },\n\n        /** Show login popup window */\n        showModal: function () {\n            $(this.modalWindow).modal('openModal');\n        }\n    };\n});\n","Magento_CheckoutAgreements/js/view/checkout-agreements.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'uiComponent',\n    'Magento_CheckoutAgreements/js/model/agreements-modal'\n], function (ko, $, Component, agreementsModal) {\n    'use strict';\n\n    var checkoutConfig = window.checkoutConfig,\n        agreementManualMode = 1,\n        agreementsConfig = checkoutConfig ? checkoutConfig.checkoutAgreements : {};\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_CheckoutAgreements/checkout/checkout-agreements'\n        },\n        isVisible: agreementsConfig.isEnabled,\n        agreements: agreementsConfig.agreements,\n        modalTitle: ko.observable(null),\n        modalContent: ko.observable(null),\n        contentHeight: ko.observable(null),\n        modalWindow: null,\n\n        /**\n         * Checks if agreement required\n         *\n         * @param {Object} element\n         */\n        isAgreementRequired: function (element) {\n            return element.mode == agreementManualMode; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * Show agreement content in modal\n         *\n         * @param {Object} element\n         */\n        showContent: function (element) {\n            this.modalTitle(element.checkboxText);\n            this.modalContent(element.content);\n            this.contentHeight(element.contentHeight ? element.contentHeight : 'auto');\n            agreementsModal.showModal();\n        },\n\n        /**\n         * build a unique id for the term checkbox\n         *\n         * @param {Object} context - the ko context\n         * @param {Number} agreementId\n         */\n        getCheckboxId: function (context, agreementId) {\n            var paymentMethodName = '',\n                paymentMethodRenderer = context.$parents[1];\n\n            // corresponding payment method fetched from parent context\n            if (paymentMethodRenderer) {\n                // item looks like this: {title: \"Check / Money order\", method: \"checkmo\"}\n                paymentMethodName = paymentMethodRenderer.item ?\n                  paymentMethodRenderer.item.method : '';\n            }\n\n            return 'agreement_' + paymentMethodName + '_' + agreementId;\n        },\n\n        /**\n         * Init modal window for rendered element\n         *\n         * @param {Object} element\n         */\n        initModal: function (element) {\n            agreementsModal.createModal(element);\n        }\n    });\n});\n","Magento_CheckoutAgreements/js/view/agreement-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_CheckoutAgreements/js/model/agreement-validator'\n], function (Component, additionalValidators, agreementValidator) {\n    'use strict';\n\n    additionalValidators.registerValidator(agreementValidator);\n\n    return Component.extend({});\n});\n","Magento_Search/js/form-mini.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'matchMedia',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/core',\n    'mage/translate'\n], function ($, _, mageTemplate, mediaCheck) {\n    'use strict';\n\n    /**\n     * Check whether the incoming string is not empty or if doesn't consist of spaces.\n     *\n     * @param {String} value - Value to check.\n     * @returns {Boolean}\n     */\n    function isEmpty(value) {\n        return value.length === 0 || value == null || /^\\s+$/.test(value);\n    }\n\n    $.widget('mage.quickSearch', {\n        options: {\n            autocomplete: 'off',\n            minSearchLength: 3,\n            responseFieldElements: 'ul li',\n            selectClass: 'selected',\n            template:\n                '<li class=\"<%- data.row_class %>\" id=\"qs-option-<%- data.index %>\" role=\"option\">' +\n                '<span class=\"qs-option-name\">' +\n                ' <%- data.title %>' +\n                '</span>' +\n                '<span aria-hidden=\"true\" class=\"amount\">' +\n                '<%- data.num_results %>' +\n                '</span>' +\n                '</li>',\n            submitBtn: 'button[type=\"submit\"]',\n            searchLabel: '[data-role=minisearch-label]',\n            isExpandable: null,\n            suggestionDelay: 300\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.responseList = {\n                indexList: null,\n                selected: null\n            };\n            this.autoComplete = $(this.options.destinationSelector);\n            this.searchForm = $(this.options.formSelector);\n            this.submitBtn = this.searchForm.find(this.options.submitBtn)[0];\n            this.searchLabel = this.searchForm.find(this.options.searchLabel);\n            this.isExpandable = this.options.isExpandable;\n\n            _.bindAll(this, '_onKeyDown', '_onPropertyChange', '_onSubmit');\n\n            this.submitBtn.disabled = true;\n\n            this.element.attr('autocomplete', this.options.autocomplete);\n\n            mediaCheck({\n                media: '(max-width: 768px)',\n                entry: function () {\n                    this.isExpandable = true;\n                }.bind(this),\n                exit: function () {\n                    this.isExpandable = true;\n                }.bind(this)\n            });\n\n            this.searchLabel.on('click', function (e) {\n                // allow input to lose its' focus when clicking on label\n                if (this.isExpandable && this.isActive()) {\n                    e.preventDefault();\n                }\n            }.bind(this));\n\n            this.element.on('blur', $.proxy(function () {\n                if (!this.searchLabel.hasClass('active')) {\n                    return;\n                }\n\n                setTimeout($.proxy(function () {\n                    if (this.autoComplete.is(':hidden')) {\n                        this.setActiveState(false);\n                    } else {\n                        this.element.trigger('focus');\n                    }\n                    this.autoComplete.hide();\n                    this._updateAriaHasPopup(false);\n                }, this), 250);\n            }, this));\n\n            if (this.element.get(0) === document.activeElement) {\n                this.setActiveState(true);\n            }\n\n            this.element.on('focus', this.setActiveState.bind(this, true));\n            this.element.on('keydown', this._onKeyDown);\n            // Prevent spamming the server with requests by waiting till the user has stopped typing for period of time\n            this.element.on('input propertychange', _.debounce(this._onPropertyChange, this.options.suggestionDelay));\n\n            this.searchForm.on('submit', $.proxy(function (e) {\n                this._onSubmit(e);\n                this._updateAriaHasPopup(false);\n            }, this));\n        },\n\n        /**\n         * Checks if search field is active.\n         *\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            return this.searchLabel.hasClass('active');\n        },\n\n        /**\n         * Sets state of the search field to provided value.\n         *\n         * @param {Boolean} isActive\n         */\n        setActiveState: function (isActive) {\n            var searchValue;\n\n            this.searchForm.toggleClass('active', isActive);\n            this.searchLabel.toggleClass('active', isActive);\n\n            if (this.isExpandable) {\n                this.element.attr('aria-expanded', isActive);\n                searchValue = this.element.val();\n                this.element.val('');\n                this.element.val(searchValue);\n            }\n        },\n\n        /**\n         * @private\n         * @return {Element} The first element in the suggestion list.\n         */\n        _getFirstVisibleElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.first() : false;\n        },\n\n        /**\n         * @private\n         * @return {Element} The last element in the suggestion list.\n         */\n        _getLastElement: function () {\n            return this.responseList.indexList ? this.responseList.indexList.last() : false;\n        },\n\n        /**\n         * @private\n         * @param {Boolean} show - Set attribute aria-haspopup to \"true/false\" for element.\n         */\n        _updateAriaHasPopup: function (show) {\n            if (show) {\n                this.element.attr('aria-haspopup', 'true');\n            } else {\n                this.element.attr('aria-haspopup', 'false');\n            }\n        },\n\n        /**\n         * Clears the item selected from the suggestion list and resets the suggestion list.\n         * @private\n         * @param {Boolean} all - Controls whether to clear the suggestion list.\n         */\n        _resetResponseList: function (all) {\n            this.responseList.selected = null;\n\n            if (all === true) {\n                this.responseList.indexList = null;\n            }\n        },\n\n        /**\n         * Executes when the search box is submitted. Sets the search input field to the\n         * value of the selected item.\n         * @private\n         * @param {Event} e - The submit event\n         */\n        _onSubmit: function (e) {\n            var value = this.element.val();\n\n            if (isEmpty(value)) {\n                e.preventDefault();\n            }\n\n            if (this.responseList.selected) {\n                this.element.val(this.responseList.selected.find('.qs-option-name').text());\n            }\n        },\n\n        /**\n         * Executes when keys are pressed in the search input field. Performs specific actions\n         * depending on which keys are pressed.\n         * @private\n         * @param {Event} e - The key down event\n         * @return {Boolean} Default return type for any unhandled keys\n         */\n        _onKeyDown: function (e) {\n            var keyCode = e.keyCode || e.which;\n\n            switch (keyCode) {\n                case $.ui.keyCode.HOME:\n                    if (this._getFirstVisibleElement()) {\n                        this._getFirstVisibleElement().addClass(this.options.selectClass);\n                        this.responseList.selected = this._getFirstVisibleElement();\n                    }\n                    break;\n\n                case $.ui.keyCode.END:\n                    if (this._getLastElement()) {\n                        this._getLastElement().addClass(this.options.selectClass);\n                        this.responseList.selected = this._getLastElement();\n                    }\n                    break;\n\n                case $.ui.keyCode.ESCAPE:\n                    this._resetResponseList(true);\n                    this.autoComplete.hide();\n                    break;\n\n                case $.ui.keyCode.ENTER:\n                    if (this.element.val().length >= parseInt(this.options.minSearchLength, 10)) {\n                        this.searchForm.trigger('submit');\n                        e.preventDefault();\n                    }\n                    break;\n\n                case $.ui.keyCode.DOWN:\n                    if (this.responseList.indexList) {\n                        if (!this.responseList.selected) {  //eslint-disable-line max-depth\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        } else if (!this._getLastElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected\n                                .removeClass(this.options.selectClass).next().addClass(this.options.selectClass);\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getFirstVisibleElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getFirstVisibleElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                        this._updateAriaHasPopup(true);\n                        this.autoComplete.show();\n                    }\n                    break;\n\n                case $.ui.keyCode.UP:\n                    if (this.responseList.indexList !== null) {\n                        if (!this._getFirstVisibleElement().hasClass(this.options.selectClass)) {\n                            this.responseList.selected = this.responseList.selected\n                                .removeClass(this.options.selectClass).prev().addClass(this.options.selectClass);\n\n                        } else {\n                            this.responseList.selected.removeClass(this.options.selectClass);\n                            this._getLastElement().addClass(this.options.selectClass);\n                            this.responseList.selected = this._getLastElement();\n                        }\n                        this.element.val(this.responseList.selected.find('.qs-option-name').text());\n                        this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n                        this._updateAriaHasPopup(true);\n                        this.autoComplete.show();\n                    }\n                    break;\n                default:\n                    return true;\n            }\n        },\n\n        /**\n         * Executes when the value of the search input field changes. Executes a GET request\n         * to populate a suggestion list based on entered text. Handles click (select), hover,\n         * and mouseout events on the populated suggestion list dropdown.\n         * @private\n         */\n        _onPropertyChange: function () {\n            var searchField = this.element,\n                clonePosition = {\n                    position: 'absolute',\n                    // Removed to fix display issues\n                    // left: searchField.offset().left,\n                    // top: searchField.offset().top + searchField.outerHeight(),\n                    width: searchField.outerWidth()\n                },\n                source = this.options.template,\n                template = mageTemplate(source),\n                dropdown = $('<ul role=\"listbox\"></ul>'),\n                value = this.element.val();\n\n            this.submitBtn.disabled = true;\n\n            if (value.length >= parseInt(this.options.minSearchLength, 10)) {\n                this.submitBtn.disabled = false;\n\n                if (this.options.url !== '') { //eslint-disable-line eqeqeq\n                    $.getJSON(this.options.url, {\n                        q: value\n                    }, $.proxy(function (data) {\n                        if (data.length) {\n                            $.each(data, function (index, element) {\n                                var html;\n\n                                element.index = index;\n                                html = template({\n                                    data: element\n                                });\n                                dropdown.append(html);\n                            });\n\n                            this._resetResponseList(true);\n\n                            this.responseList.indexList = this.autoComplete.html(dropdown)\n                                .css(clonePosition)\n                                .show()\n                                .find(this.options.responseFieldElements + ':visible');\n\n                            this.element.removeAttr('aria-activedescendant');\n\n                            if (this.responseList.indexList.length) {\n                                this._updateAriaHasPopup(true);\n                            } else {\n                                this._updateAriaHasPopup(false);\n                            }\n\n                            this.responseList.indexList\n                                .on('click', function (e) {\n                                    this.responseList.selected = $(e.currentTarget);\n                                    this.searchForm.trigger('submit');\n                                }.bind(this))\n                                .on('mouseenter mouseleave', function (e) {\n                                    this.responseList.indexList.removeClass(this.options.selectClass);\n                                    $(e.target).addClass(this.options.selectClass);\n                                    this.responseList.selected = $(e.target);\n                                    this.element.attr('aria-activedescendant', $(e.target).attr('id'));\n                                }.bind(this))\n                                .on('mouseout', function (e) {\n                                    if (!this._getLastElement() &&\n                                        this._getLastElement().hasClass(this.options.selectClass)) {\n                                        $(e.target).removeClass(this.options.selectClass);\n                                        this._resetResponseList(false);\n                                    }\n                                }.bind(this));\n                        } else {\n                            this._resetResponseList(true);\n                            this.autoComplete.hide();\n                            this._updateAriaHasPopup(false);\n                            this.element.removeAttr('aria-activedescendant');\n                        }\n                    }, this));\n                }\n            } else {\n                this._resetResponseList(true);\n                this.autoComplete.hide();\n                this._updateAriaHasPopup(false);\n                this.element.removeAttr('aria-activedescendant');\n            }\n        }\n    });\n\n    return $.mage.quickSearch;\n});\n","Magento_Theme/js/cookie-status.js":"define([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal) {\n    'use strict';\n\n    $.widget('mage.cookieStatus', {\n        options: {\n            type: 'popup',\n            responsive: true,\n            innerScroll: true,\n            autoOpen: true,\n            buttons: [{\n                text: $.mage.__('Close'),\n                class: 'cookie-status',\n\n                /**\n                 * Callback for click event\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }]\n        },\n\n        /**\n         * Init object\n         * @private\n         */\n        _init: function () {\n\n            if (!navigator.cookieEnabled) {\n                modal(this.options, $('#cookie-status'));\n            }\n        }\n    });\n\n    return $.mage.cookieStatus;\n});\n","Magento_Theme/js/row-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.rowBuilder'\n *\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.rowBuilder', {\n\n        /**\n         * options with default values for setting up the template\n         */\n        options: {\n            //Default template options\n            rowTemplate: '#template-registrant',\n            rowContainer: '#registrant-container',\n            //Row index used by the template rows.\n            rowIndex: 0,\n            //Row count: Should not be set externally\n            rowCount: 0,\n            rowParentElem: '<li></li>',\n            rowContainerClass: 'fields',\n            addRowBtn: '#add-registrant-button',\n            btnRemoveIdPrefix: 'btn-remove',\n            btnRemoveSelector: '.btn-remove',\n            rowIdPrefix: 'row',\n            //This class is added to rows added after the first one. Adds the dotted separator\n            additionalRowClass: 'add-row',\n\n            /*\n             This is provided during widget instantiation. eg :\n             formDataPost : {\"formData\":formData,\"templateFields\":['field1-name','field2-name'] }\n             -\"formData\" is the multi-dimensional array of form field values : [['a','b'],['c','b']]\n             received from the server and encoded\n             -\"templateFields\" are the input fields in the template with index suffixed after the field name\n             eg field1-name{index}\n             */\n            formDataPost: null,\n            //Default selectors for add element of a template\n            addEventSelector: 'button',\n            //Default selectors for remove markup elements of a template\n            remEventSelector: 'a',\n            //This option allows adding first row delete option and a row separator\n            hideFirstRowAddSeparator: true,\n            //Max rows - This option should be set when instantiating the widget\n            maxRows: 1000,\n            maxRowsMsg: '#max-registrant-message'\n        },\n\n        /**\n         * Initialize create\n         * @private\n         */\n        _create: function () {\n            this.rowTemplate = mageTemplate(this.options.rowTemplate);\n\n            this.options.rowCount = this.options.rowIndex = 0;\n\n            //On document ready related tasks\n            $($.proxy(this.ready, this));\n\n            //Binding template-wide events handlers for adding and removing rows\n            this.element.on(\n                'click',\n                this.options.addEventSelector + this.options.addRowBtn,\n                $.proxy(this.handleAdd, this)\n            );\n            this.element.on(\n                'click',\n                this.options.remEventSelector + this.options.btnRemoveSelector,\n                $.proxy(this.handleRemove, this)\n            );\n        },\n\n        /**\n         * Initialize template\n         * @public\n         */\n        ready: function () {\n            if (this.options.formDataPost &&\n                this.options.formDataPost.formData &&\n                this.options.formDataPost.formData.length\n            ) {\n                this.processFormDataArr(this.options.formDataPost);\n            } else if (this.options.rowIndex === 0 && this.options.maxRows !== 0) {\n                //If no form data , then add default row\n                this.addRow(0);\n            }\n        },\n\n        /**\n         * Process and loop through all row data to create preselected values. This is used for any error on submit.\n         * For complex implementations the inheriting widget can override this behavior\n         * @public\n         * @param {Object} formDataArr\n         */\n        processFormDataArr: function (formDataArr) {\n            var formData = formDataArr.formData,\n                templateFields = formDataArr.templateFields,\n                formRow,\n                i, j;\n\n            for (i = this.options.rowIndex = 0; i < formData.length; this.options.rowIndex = i++) {\n                this.addRow(i);\n\n                formRow = formData[i];\n\n                for (j = 0; j < formRow.length; j++) {\n                    this.setFieldById(templateFields[j] + i, formRow[j]);\n                }\n            }\n\n        },\n\n        /**\n         * Initialize and create markup for template row. Add it to the parent container.\n         * The template processing will substitute row index at all places marked with _index_ in the template\n         * using the template\n         * @public\n         * @param {Number} index - current index/count of the created template. This will be used as the id\n         * @return {*}\n         */\n        addRow: function (index) {\n            var row = $(this.options.rowParentElem),\n                tmpl;\n\n            row.addClass(this.options.rowContainerClass).attr('id', this.options.rowIdPrefix + index);\n\n            tmpl = this.rowTemplate({\n                data: {\n                    _index_: index\n                }\n            });\n\n            $(tmpl).appendTo(row);\n\n            $(this.options.rowContainer).append(row).trigger('contentUpdated');\n\n            row.addClass(this.options.additionalRowClass);\n\n            //Remove 'delete' link and additionalRowClass for first row\n            if (this.options.rowIndex === 0 && this.options.hideFirstRowAddSeparator) {\n                $('#' + this._esc(this.options.btnRemoveIdPrefix) + '0').remove();\n                $('#' + this._esc(this.options.rowIdPrefix) + '0').removeClass(this.options.additionalRowClass);\n            }\n\n            this.maxRowCheck(++this.options.rowCount);\n\n            return row;\n        },\n\n        /**\n         * Remove return item information row\n         * @public\n         * @param {*} rowIndex - return item information row index\n         * @return {Boolean}\n         */\n        removeRow: function (rowIndex) {\n            $('#' + this._esc(this.options.rowIdPrefix) + rowIndex).remove();\n            this.maxRowCheck(--this.options.rowCount);\n\n            return false;\n        },\n\n        /**\n         * Function to check if maximum rows are exceeded and render/hide maxMsg and Add btn\n         * @public\n         * @param {Number} rowIndex\n         */\n        maxRowCheck: function (rowIndex) {\n            var addRowBtn = $(this.options.addRowBtn),\n                maxRowMsg = $(this.options.maxRowsMsg);\n\n            //liIndex starts from 0\n            if (rowIndex >= this.options.maxRows) {\n                addRowBtn.hide();\n                maxRowMsg.show();\n            } else if (addRowBtn.is(':hidden')) {\n                addRowBtn.show();\n                maxRowMsg.hide();\n            }\n        },\n\n        /**\n         * Set the value on given element\n         * @public\n         * @param {String} domId\n         * @param {String} value\n         */\n        setFieldById: function (domId, value) {\n            var x = $('#' + this._esc(domId));\n\n            if (x.length) {\n\n                if (x.is(':checkbox')) {\n                    x.attr('checked', true);\n                } else if (x.is('option')) {\n                    x.attr('selected', 'selected');\n                } else {\n                    x.val(value);\n                }\n            }\n        },\n\n        /**\n         * Delegated handler for adding a row\n         * @public\n         * @return {Boolean}\n         */\n        handleAdd: function () {\n            this.addRow(++this.options.rowIndex);\n\n            return false;\n        },\n\n        /**\n         * Delegated handler for removing a selected row\n         * @public\n         * @param {Object} e - Native event object\n         * @return {Boolean}\n         */\n        handleRemove: function (e) {\n            this.removeRow($(e.currentTarget).closest('[id^=\"' + this.options.btnRemoveIdPrefix + '\"]')\n                .attr('id').replace(this.options.btnRemoveIdPrefix, ''));\n\n            return false;\n        },\n\n        /**\n         * Utility function to add escape chars for jquery selector strings\n         * @private\n         * @param {String} str - String to be processed\n         * @return {String}\n         */\n        _esc: function (str) {\n            return str ? str.replace(/([ ;&,.+*~\\':\"!\\^$\\[\\]()=>|\\/@])/g, '\\\\$1') : str;\n        }\n    });\n\n    return $.mage.rowBuilder;\n});\n","Magento_Theme/js/model/breadcrumb-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return [];\n});\n","Magento_Theme/js/view/breadcrumbs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Theme/js/model/breadcrumb-list',\n    'text!Magento_Theme/templates/breadcrumbs.html',\n    'jquery-ui-modules/widget'\n], function ($, mageTemplate, breadcrumbList, tpl) {\n    'use strict';\n\n    /**\n     * Breadcrumb Widget.\n     */\n    $.widget('mage.breadcrumbs', {\n\n        /** @inheritdoc */\n        _init: function () {\n            this._super();\n            this._render();\n        },\n\n        /**\n         * Render breadcrumb.\n         *\n         * @private\n         */\n        _render: function () {\n            var html,\n                crumbs = breadcrumbList,\n                template = mageTemplate(tpl);\n\n            this._decorate(crumbs);\n\n            html = template({\n                'breadcrumbs': crumbs\n            });\n\n            if (html.length) {\n                $(this.element).html(html);\n            }\n        },\n\n        /**\n         * Decorate list.\n         *\n         * @param {Array} list\n         * @private\n         */\n        _decorate: function (list) {\n\n            if (list.length) {\n                list[0].first = true;\n            }\n\n            if (list.length > 1) {\n                list[list.length - 1].last = true;\n            }\n        }\n    });\n\n    return $.mage.breadcrumbs;\n});\n","Magento_Theme/js/view/add-home-breadcrumb.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* eslint-disable max-nested-callbacks, no-undef */\ndefine([\n    'jquery',\n    'Magento_Theme/js/model/breadcrumb-list',\n    'mage/translate'\n], function ($, breadcrumbList) {\n    'use strict';\n\n    /**\n     * @return {Object}\n     */\n    var homeCrumb = function () {\n        return {\n            name: 'home',\n            label: $.mage.__('Home'),\n            title: $.mage.__('Go to Home Page'),\n            link: BASE_URL || ''\n        };\n    };\n\n    return function (breadcrumb) {\n\n        breadcrumbList.unshift(homeCrumb());\n\n        return breadcrumb;\n    };\n});\n","Magento_Theme/js/view/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'underscore',\n    'escaper',\n    'jquery/jquery-storageapi'\n], function ($, Component, customerData, _, escaper) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            cookieMessages: [],\n            cookieMessagesObservable: [],\n            messages: [],\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Extends Component object by storage observable messages.\n         */\n        initialize: function () {\n            this._super().observe(\n                [\n                    'cookieMessagesObservable'\n                ]\n            );\n\n            // The \"cookieMessages\" variable is not used anymore. It exists for backward compatibility; to support\n            // merchants who have overwritten \"messages.phtml\" which would still point to cookieMessages instead of the\n            // observable variant (also see https://github.com/magento/magento2/pull/37309).\n            this.cookieMessages = _.unique($.cookieStorage.get('mage-messages'), 'text');\n            this.cookieMessagesObservable(this.cookieMessages);\n\n            this.messages = customerData.get('messages').extend({\n                disposableCustomerData: 'messages'\n            });\n\n            $.mage.cookies.set('mage-messages', '', {\n                samesite: 'strict',\n                domain: ''\n            });\n        },\n\n        /**\n         * Prepare the given message to be rendered as HTML\n         *\n         * @param {String} message\n         * @return {String}\n         */\n        prepareMessageForHtml: function (message) {\n            return escaper.escapeHtml(message, this.allowedTags);\n        },\n        purgeMessages: function () {\n            if (!_.isEmpty(this.messages().messages)) {\n                customerData.set('messages', {});\n            }\n        }\n    });\n});\n","Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * recaptchaId: token map.\n         *\n         * Tokens for already verified recaptcha.\n         */\n        tokens: {},\n\n        /**\n         * recaptchaId: triggerFn map.\n         *\n         * Call a trigger to initiate a recaptcha verification.\n         */\n        triggers: {},\n\n        /**\n         * recaptchaId: callback map\n         */\n        _listeners: {},\n\n        /**\n         * recaptchaId: bool map\n         */\n        _isInvisibleType: {},\n\n        /**\n         * Add a listener to when the ReCaptcha finishes verification\n         * @param {String} id - ReCaptchaId\n         * @param {Function} func - Will be called back with the token\n         */\n        addListener: function (id, func) {\n            if (this.tokens.hasOwnProperty(id)) {\n                func(this.tokens[id]);\n            } else {\n                this._listeners[id] = func;\n            }\n        },\n\n        /**\n         * Remove a listener\n         *\n         * @param id\n         */\n        removeListener: function (id) {\n            this._listeners[id] = undefined;\n        }\n    };\n});\n","Magento_ReCaptchaWebapiUi/js/jquery-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// jscs:disable requireDotNotation\n\ndefine([\n    'mage/utils/wrapper'\n], function (wrapper) {\n    'use strict';\n\n    return function (jQuery) {\n        jQuery.ajax = wrapper.wrapSuper(jQuery.ajax, function () {\n            //Moving ReCaptcha value from payload to the header for requests to web API\n            var settings,\n                payload;\n\n            if (arguments.length !== 0) {\n                settings = arguments.length === 1 ? arguments[0] : arguments[1];\n            }\n\n            if (settings && settings.hasOwnProperty('data')) {\n                //The request has a body, trying to parse JSON data\n                try {\n                    payload = JSON.parse(settings.data);\n                } catch (e) {\n                    //Not JSON\n                }\n            }\n\n            if (payload && payload.hasOwnProperty('xReCaptchaValue')) {\n                if (!settings.hasOwnProperty('headers')) {\n                    settings.headers = {};\n                }\n                settings.headers['X-ReCaptcha'] = payload.xReCaptchaValue;\n                delete payload['xReCaptchaValue'];\n                settings.data = JSON.stringify(payload);\n            }\n\n            return this._super.apply(this, arguments);\n        });\n\n        return jQuery;\n    };\n});\n","Magento_ReCaptchaWebapiUi/js/webapiReCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// jscs:disable jsDoc\n\n/* global grecaptcha */\ndefine(\n    [\n        'Magento_ReCaptchaFrontendUi/js/reCaptcha',\n        'Magento_ReCaptchaWebapiUi/js/webapiReCaptchaRegistry'\n    ],\n    function (Component, registry) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                autoTrigger: false\n            },\n\n            /**\n             * Provide the token to the registry.\n             *\n             * @param {String} token\n             */\n            reCaptchaCallback: function (token) {\n                //Make the token retrievable in other UI components.\n                registry.tokens[this.getReCaptchaId()] = token;\n\n                if (typeof registry._listeners[this.getReCaptchaId()] !== 'undefined') {\n                    registry._listeners[this.getReCaptchaId()](token);\n                }\n            },\n\n            /**\n             * Register this ReCaptcha.\n             *\n             * @param {Object} parentForm\n             * @param {String} widgetId\n             */\n            initParentForm: function (parentForm, widgetId) {\n                var self = this,\n                    trigger;\n\n                trigger = function () {\n                    self.reCaptchaCallback(grecaptcha.getResponse(widgetId));\n                };\n                registry._isInvisibleType[this.getReCaptchaId()] = false;\n\n                if (this.getIsInvisibleRecaptcha()) {\n                    trigger = function () {\n                        grecaptcha.execute(widgetId);\n                    };\n                    registry._isInvisibleType[this.getReCaptchaId()] = true;\n                }\n\n                if (this.autoTrigger) {\n                    //Validate ReCaptcha when initiated\n                    trigger();\n                    registry.triggers[this.getReCaptchaId()] = new Function();\n                } else {\n                    registry.triggers[this.getReCaptchaId()] = trigger;\n                }\n                this.tokenField = null;\n            }\n        });\n    }\n);\n","Magento_GoogleGtag/js/google-analytics.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* jscs:disable */\n/* eslint-disable */\ndefine([\n    'jquery',\n    'mage/cookies'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} config\n     */\n    return function (config) {\n        var allowServices = false,\n            allowedCookies,\n            allowedWebsites,\n            measurementId;\n\n        if (config.isCookieRestrictionModeEnabled) {\n            allowedCookies = $.mage.cookies.get(config.cookieName);\n\n            if (allowedCookies !== null) {\n                allowedWebsites = JSON.parse(allowedCookies);\n\n                if (allowedWebsites[config.currentWebsite] === 1) {\n                    allowServices = true;\n                }\n            }\n        } else {\n            allowServices = true;\n        }\n\n        if (allowServices) {\n            /* Global site tag (gtag.js) - Google Analytics */\n            measurementId = config.pageTrackingData.measurementId;\n            if (window.gtag) {\n                gtag('config', measurementId, { 'anonymize_ip': true });\n                // Purchase Event\n                if (config.ordersTrackingData.hasOwnProperty('currency')) {\n                    var purchaseObject = config.ordersTrackingData.orders[0];\n                    purchaseObject['items'] = config.ordersTrackingData.products;\n                    gtag('event', 'purchase', purchaseObject);\n                }\n            } else {\n                (function(d,s,u){\n                    var gtagScript = d.createElement(s);\n                    gtagScript.type = 'text/javascript';\n                    gtagScript.async = true;\n                    gtagScript.src = u;\n                    d.head.insertBefore(gtagScript, d.head.children[0]);\n                })(document, 'script', 'https://www.googletagmanager.com/gtag/js?id=' + measurementId);\n                window.dataLayer = window.dataLayer || [];\n                function gtag(){dataLayer.push(arguments);}\n                gtag('js', new Date());\n                gtag('set', 'developer_id.dYjhlMD', true);\n                gtag('config', measurementId, { 'anonymize_ip': true });\n                // Purchase Event\n                if (config.ordersTrackingData.hasOwnProperty('currency')) {\n                    var purchaseObject = config.ordersTrackingData.orders[0];\n                    purchaseObject['items'] = config.ordersTrackingData.products;\n                    gtag('event', 'purchase', purchaseObject);\n                }\n            }\n        }\n    }\n});\n","Magento_GoogleGtag/js/google-adwords.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* jscs:disable */\n/* eslint-disable */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} config\n     */\n    return function (config) {\n        if (!window.gtag) {\n            // Inject Global Site Tag\n            var gtagScript = document.createElement('script');\n            gtagScript.type = 'text/javascript';\n            gtagScript.async = true;\n            gtagScript.src = config.gtagSiteSrc;\n            document.head.appendChild(gtagScript);\n\n            window.dataLayer = window.dataLayer || [];\n\n            function gtag(){dataLayer.push(arguments);}\n            gtag('js', new Date());\n            gtag('set', 'developer_id.dYjhlMD', true);\n            if (config.conversionLabel) {\n                gtag(\n                    'event',\n                    'conversion',\n                    {'send_to': config.conversionId + '/'\n                            + config.conversionLabel}\n                );\n            }\n        } else {\n            gtag('config', config.conversionId);\n        }\n    }\n});\n"}
}});
